# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -653.49600270    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -5.24094984E+00  +6.99792901E-01  -1.47854407E-01
   006   -4.87137423E+00  -1.90173734E+00  -3.11477512E-01
   006   -2.48878136E+00  -2.88262268E+00  +4.37487189E-02
   006   -4.28892286E-01  -1.32255466E+00  +6.28051488E-01
   006   -8.46589604E-01  +1.28799454E+00  +8.03625595E-01
   006   -3.21294902E+00  +2.28771070E+00  +3.97374784E-01
   006   +2.08167111E+00  -2.34961851E+00  +1.01807710E+00
   008   +3.48008153E+00  -1.56687729E+00  -2.98543616E+00
   008   -7.59609549E+00  +1.57714478E+00  -5.41466735E-01
   006   +3.94244370E+00  -9.50356883E-01  +2.44507013E+00
   006   +2.58231727E+00  -5.08321538E+00  +5.83683813E-01
   001   -7.61846364E+00  +3.38170088E+00  -3.97520884E-01
   001   -3.47685885E+00  +4.31623081E+00  +4.88268697E-01
   001   +6.92617442E-01  +2.59071353E+00  +1.17065841E+00
   001   -2.23985673E+00  -4.90419828E+00  -1.01763667E-01
   001   -6.46451164E+00  -3.10913839E+00  -7.29620225E-01
   001   +1.58573236E+00  -5.84406644E+00  -1.03761473E+00
   001   +4.59658546E+00  -5.38882789E+00  +3.28998189E-01
   001   +1.99486187E+00  -6.10007557E+00  +2.28865555E+00
   001   +3.12307387E+00  +3.39657216E-01  +3.81611388E+00
   001   +5.36264754E+00  -2.17201703E+00  +3.28928724E+00
   001   +5.00224190E+00  +3.68725126E-01  +1.02288052E+00
   001   +2.05863277E+00  -9.21466268E-01  -3.89851688E+00
   008   +3.05275471E+00  +5.81258846E+00  +5.24694898E-01
   001   +4.07630294E+00  +6.78003578E+00  +1.65189443E+00
   001   +4.22496603E+00  +4.59016752E+00  -2.74112634E-01
   008   +5.84459443E+00  +2.08388136E+00  -1.31370191E+00
   001   +7.62356768E+00  +2.20495896E+00  -1.59306715E+00
   001   +4.58209374E+00  +5.55657620E-03  -2.54279129E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -6.00000000E-08  +1.40000000E-07  +9.00000000E-08
   +1.00000000E-08  +8.00000000E-08  -4.20000000E-07
   -1.20000000E-07  +3.00000000E-08  -6.80000000E-07
   +1.60000000E-07  -1.50000000E-07  -1.80000000E-07
   -5.00000000E-08  -4.00000000E-08  +3.30000000E-07
   -1.00000000E-08  +0.00000000E+00  +4.60000000E-07
   +0.00000000E+00  +3.00000000E-08  -3.50000000E-07
   +1.20000000E-07  +7.20000000E-07  -4.20000000E-07
   +1.40000000E-07  +1.30000000E-07  +2.80000000E-07
   -4.30000000E-07  -7.40000000E-07  +1.10000000E-07
   -6.00000000E-08  -1.00000000E-08  -1.01000000E-06
   +3.00000000E-08  +1.70000000E-07  +6.20000000E-07
   +2.00000000E-08  -5.00000000E-08  +8.80000000E-07
   -3.00000000E-08  -2.50000000E-07  +5.40000000E-07
   +0.00000000E+00  +3.00000000E-08  -9.80000000E-07
   +2.00000000E-08  +2.30000000E-07  -6.80000000E-07
   -3.00000000E-08  +2.40000000E-07  -1.17000000E-06
   +0.00000000E+00  -7.00000000E-08  -1.02000000E-06
   -5.00000000E-08  -4.10000000E-07  -1.18000000E-06
   +0.00000000E+00  -7.60000000E-07  +1.70000000E-07
   +0.00000000E+00  -6.60000000E-07  -4.00000000E-07
   +2.90000000E-07  -3.00000000E-08  +0.00000000E+00
   +9.00000000E-08  +8.50000000E-07  -9.00000000E-08
   -3.00000000E-08  -2.00000000E-08  +1.22000000E-06
   +5.00000000E-08  -2.90000000E-07  +1.49000000E-06
   +4.00000000E-08  +1.10000000E-07  +1.05000000E-06
   +4.00000000E-08  +1.40000000E-07  +4.40000000E-07
   -2.00000000E-08  +4.70000000E-07  +6.60000000E-07
   -9.00000000E-08  +1.20000000E-07  +2.30000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.91340080E-01  -1.83179500E-02  +7.23252340E-01  +1.01541370E-01  +4.45779200E-02
   +1.97377250E-01  -1.24256000E-01  -3.46451400E-02  -1.34897200E-02  +7.47480460E-01
   +4.02041000E-02  -3.14890450E-01  -1.38015600E-02  +1.43397700E-02  +6.92031320E-01
   -6.31777000E-03  -2.77309500E-02  -7.57898400E-02  +1.20089790E-01  +5.41685700E-02
   +1.55531160E-01  +1.60520300E-02  +9.63380300E-02  +1.16543600E-02  -3.33723400E-01
   +4.71814400E-02  -4.67360400E-02  +6.74266210E-01  +3.88864800E-02  -8.92842000E-03
   +6.27035000E-03  +1.15448930E-01  -1.64998600E-01  +1.25694200E-02  -4.04864100E-02
   +7.41326910E-01  +6.00715000E-03  +1.95173500E-02  +3.69622000E-03  -3.86024900E-02
   -3.47045000E-03  -6.92529000E-02  +9.44177800E-02  +5.19054000E-02  +1.72404080E-01
   +5.25705000E-03  -3.17603800E-02  -2.37680000E-04  -5.64666000E-02  +1.86178500E-02
   -1.26913900E-02  -2.17344970E-01  -1.09731440E-01  -3.47230400E-02  +6.37377580E-01
   -3.15401600E-02  -5.90640700E-02  -1.07992700E-02  -3.03170200E-02  +5.06919400E-02
   -2.98260000E-03  -6.64379200E-02  -1.96542890E-01  -2.88776900E-02  +1.65011000E-03
   +6.64988200E-01  -3.10160000E-04  -1.48584500E-02  -8.67625000E-03  -1.78736900E-02
   +1.26382100E-02  +7.04888000E-03  -3.07537400E-02  -3.81524700E-02  -7.70664500E-02
   +9.83856200E-02  +6.12311400E-02  +1.87928020E-01  -6.17481100E-02  -4.28479800E-02
   -1.69544900E-02  -2.47382500E-02  +2.69715200E-02  -1.28399000E-03  +4.24502200E-02
   -2.07024800E-02  +3.73214000E-03  -1.17186190E-01  -9.34561000E-03  -1.22259700E-02
   +7.26219860E-01  +1.39804800E-02  +7.47091200E-02  +9.03852000E-03  +3.42124300E-02
   -4.08653000E-02  +2.53560000E-03  -6.03909400E-02  -4.25475800E-02  -1.62035400E-02
   +3.54066600E-02  -3.01437840E-01  -1.69231400E-02  +2.09118500E-02  +6.88339080E-01
   -1.07717400E-02  -2.71723000E-03  -1.47150000E-03  -1.76489000E-03  +2.63774000E-03
   -2.73465000E-03  +2.41900000E-03  -9.18739000E-03  +7.85241000E-03  -1.05020800E-02
   -2.13056000E-02  -7.69361500E-02  +1.13807610E-01  +4.74356900E-02  +1.84468410E-01
   -2.15919270E-01  -4.62548100E-02  -3.28104100E-02  +4.70667600E-02  -5.68497900E-02
   +1.58441000E-03  -6.24725400E-02  -1.07702700E-02  -1.27391300E-02  +2.13572000E-03
   +7.94829900E-02  +7.33833000E-03  -3.25740360E-01  +5.18435800E-02  -5.04955500E-02
   +6.80078030E-01  -1.26421320E-01  -2.21636140E-01  -3.82514500E-02  -1.95669400E-02
   -2.99030500E-02  -7.55162000E-03  -4.68645000E-03  -2.79420000E-03  -4.39770000E-04
   +3.06834800E-02  -8.21947000E-03  +4.66530000E-03  +1.19349480E-01  -1.69074520E-01
   +1.57308400E-02  -3.97880100E-02  +7.45235630E-01  -3.93406100E-02  -2.10911300E-02
   -8.06210000E-02  +6.49346000E-03  -1.55151600E-02  +8.09418000E-03  -1.28707600E-02
   -2.20156000E-03  -5.70302000E-03  +9.27680000E-04  +1.29948800E-02  +1.15833300E-02
   -4.43008800E-02  +2.58304000E-03  -7.20668700E-02  +1.09854080E-01  +3.94045800E-02
   +1.51824800E-01  -1.46337600E-02  +5.48606000E-03  -2.42609000E-03  +6.18861000E-03
   -1.80073100E-02  -3.14680000E-04  -5.02896300E-02  +2.54051000E-03  -1.44051400E-02
   -2.02455850E-01  +3.74433200E-02  -2.30958600E-02  -1.73459000E-02  +3.19759900E-02
   +3.52182000E-03  +1.60316200E-02  +3.88510000E-03  +1.64306000E-03  +5.30395760E-01
   +7.63310000E-04  -6.27531000E-03  -1.98270000E-04  -7.60525000E-03  +1.65628000E-03
   -1.72648000E-03  -8.94178000E-03  +1.68360500E-02  +1.69312000E-03  +5.19582900E-02
   -1.32360030E-01  -1.15889000E-03  +3.77060300E-02  -1.31855400E-02  +4.75459000E-03
   +1.85410000E-04  -7.63951000E-03  -3.22420000E-04  -3.18040200E-02  +5.49543350E-01
   +7.27100000E-05  -6.55300000E-05  -7.70900000E-05  -2.38011000E-03  -2.08035000E-03
   +5.35495000E-03  -8.82267000E-03  +4.65397000E-03  -1.92458000E-03  -3.92668800E-02
   +2.53365000E-03  -7.35805100E-02  +3.40318000E-03  +1.07750000E-03  +6.78030000E-04
   -1.47009000E-03  -1.55303000E-03  +5.35032000E-03  +1.26889590E-01  +9.14897500E-02
   +2.50288320E-01  +2.33872000E-03  -1.90782000E-03  +3.72000000E-05  -1.10761000E-03
   +2.59790000E-03  -4.81960000E-04  +3.61936000E-03  +1.48802000E-03  +2.73610000E-03
   -1.21075700E-02  +5.26780000E-04  +9.17458000E-03  +8.35070000E-04  -3.42165000E-03
   +1.28360000E-03  -9.79230000E-04  -7.54060000E-04  -5.03350000E-04  -1.08779900E-02
   -6.01560000E-04  -1.70702600E-02  +4.65211440E-01  +7.26290000E-04  +1.96260000E-04
   +8.21700000E-05  +5.44200000E-04  +2.65080000E-04  +1.36600000E-04  -3.07510000E-04
   +1.05400000E-05  +5.26300000E-04  -2.21828000E-03  +2.00501000E-03  +3.34460000E-04
   +1.06723000E-03  -1.67829000E-03  -3.40110000E-04  -1.15800000E-03  +3.03070000E-04
   -6.15610000E-04  +8.36420000E-04  -1.17985900E-02  -2.02462700E-02  -3.14841000E-02
   +3.21616640E-01  -2.89001000E-03  +2.70592000E-03  -4.45120000E-04  +2.69833000E-03
   -3.98513000E-03  +9.41140000E-04  -5.66537000E-03  -2.04519000E-03  -2.97697000E-03
   +1.79057800E-02  -2.24634000E-03  -5.71328000E-03  -1.54773000E-03  +3.95493000E-03
   -2.63140000E-04  +1.97082000E-03  +1.12094000E-03  +8.22880000E-04  -1.47544600E-02
   -4.68024000E-03  +2.74524300E-02  +2.56493340E-01  -4.70010200E-02  +1.95922790E-01
   -2.99960870E-01  +4.12591900E-02  -4.63524100E-02  -1.73106800E-02  +2.56597100E-02
   -2.67006000E-03  +6.75463000E-03  -2.80153000E-03  +1.08100000E-03  -1.51517900E-02
   +1.03254100E-02  -3.49344000E-03  +7.73510000E-03  -1.33302900E-02  -1.59757000E-03
   -5.98931000E-02  +1.83605800E-02  -1.32295500E-02  +1.62180600E-02  -2.95163000E-03
   +1.27780000E-04  -2.92052000E-03  -5.42500000E-04  +3.79272000E-03  +4.10350710E-01
   +9.23010800E-02  -1.37739830E-01  +1.08645400E-02  +6.14858800E-02  -2.80523000E-02
   +8.89820000E-03  -1.26577900E-02  -6.05738000E-03  -4.09171000E-03  +9.67252000E-03
   +1.25981000E-03  +3.20886000E-03  -1.20053000E-03  -5.46548000E-03  -1.01863000E-03
   -1.77096300E-02  +1.48617600E-02  -3.31466000E-03  -7.79203000E-03  +2.12288000E-03
   +9.83800000E-05  +1.52155000E-03  +3.51450000E-04  -1.92388000E-03  -9.32476700E-02
   +6.81507380E-01  -4.23462000E-02  +1.09267000E-03  -5.68451000E-02  +5.56280000E-04
   +1.74162000E-03  +8.02098000E-03  -8.12490000E-04  -1.62675000E-03  +4.89846000E-03
   -1.72316000E-03  +2.50495000E-03  -1.36969000E-03  -1.69230000E-04  -3.85231000E-03
   +7.19097000E-03  -1.63185500E-02  +3.91584000E-03  +9.89937000E-03  +2.66995000E-03
   -4.27780000E-04  -8.75710000E-04  -3.44340000E-04  -9.73000000E-06  +6.53800000E-04
   +6.75831600E-02  +3.53900200E-02  +4.77465600E-02  +3.61812000E-03  -3.46290000E-03
   +6.94800000E-04  -3.28117000E-03  +4.12391000E-03  +2.22210000E-04  +4.34315000E-03
   +4.93245000E-03  +1.49640000E-04  -3.31863300E-02  -8.23790000E-03  -1.96390700E-02
   +4.19220000E-04  -5.15552000E-03  -1.69317000E-03  -2.59275000E-03  -1.55023000E-03
   +3.56260000E-04  -1.50674680E-01  -5.00618600E-02  -4.44337400E-02  +8.50968000E-03
   +1.05316800E-02  -9.27549000E-03  -4.83479000E-03  +2.67894000E-03  -9.97910000E-04
   +4.98004730E-01  +3.20199000E-03  -3.26339000E-03  +4.00280000E-04  -2.01546000E-03
   +5.95890000E-03  +4.01880000E-04  +1.04967600E-02  -3.64030000E-04  +1.57771000E-03
   -5.43251000E-03  +2.14608600E-02  -3.71995000E-03  +2.20991000E-03  -5.91791000E-03
   -5.44610000E-04  -2.12645000E-03  -6.47100000E-04  -2.58020000E-04  -2.47767500E-02
   -1.27198290E-01  -2.26840100E-02  +5.86191000E-03  +1.11008900E-02  -9.47190000E-03
   -4.19115000E-03  +2.32917000E-03  -6.48220000E-04  -1.15362570E-01  +5.02591910E-01
   -1.66321000E-03  +5.41950000E-04  -3.50880000E-04  +5.79480000E-04  -1.90738000E-03
   -9.72120000E-04  -2.45663000E-03  +3.35290000E-04  +2.29974000E-03  -5.18029000E-03
   -7.00356000E-03  +6.54075000E-03  -1.05181000E-03  +1.88690000E-03  -1.55273000E-03
   +1.79941000E-03  +2.42630000E-04  -3.78490000E-04  -9.45770100E-02  -6.90932100E-02
   -1.42544590E-01  -4.02864000E-03  -3.22269000E-03  -8.01652000E-03  +1.77141000E-03
   -9.49350000E-04  +5.58980000E-04  +7.22554400E-02  +7.75032200E-02  +5.00133000E-01
   +1.17360000E-04  -2.33000000E-06  -1.01880000E-04  +4.13960000E-04  +4.54990000E-04
   -3.68200000E-05  -1.91221000E-03  +6.87580000E-04  +5.68150000E-04  +1.24844000E-03
   +3.13024000E-02  -7.84100000E-05  -5.68298000E-03  +8.57950000E-04  -2.47991000E-03
   +3.18910000E-04  +1.72257000E-03  +8.23740000E-04  -9.57027700E-02  +2.90291700E-02
   -2.06339000E-03  -1.94296000E-03  -4.81964000E-03  +2.86680000E-03  -2.38410000E-04
   +9.60100000E-05  -7.41000000E-05  +7.21623000E-03  -1.89861000E-02  -5.66987000E-03
   +5.98745890E-01  -9.93350000E-04  -5.52820000E-04  -1.73440000E-04  -4.53090000E-04
   -4.90900000E-04  +6.64300000E-05  -1.17265000E-03  -1.07286000E-03  -2.68860000E-04
   +1.02189000E-02  -1.10619600E-02  -1.02812000E-03  -9.51010000E-04  +2.78901000E-03
   -9.77400000E-04  +1.25608000E-03  +3.65500000E-04  +5.15620000E-04  +2.47332700E-02
   -2.12802880E-01  -3.56655500E-02  -1.19355000E-03  -6.51215000E-03  +5.93125000E-03
   +8.41210000E-04  -2.89080000E-04  +9.85700000E-05  +1.64440000E-04  -2.11984600E-02
   -9.15437000E-03  +1.11986000E-02  +4.93659470E-01  +9.86180000E-04  +3.13990000E-04
   +2.81010000E-04  -4.55000000E-05  +9.20700000E-05  -5.49020000E-04  +1.58134000E-03
   +1.16138000E-03  -1.39703000E-03  -4.43657000E-03  +3.33411000E-03  +7.45697000E-03
   -2.83230000E-04  -1.43367000E-03  +3.46616000E-03  -1.08810000E-03  -3.51290000E-04
   -1.25668000E-03  +2.20700000E-03  -3.94228200E-02  -7.53103900E-02  +1.31787000E-03
   +1.07788900E-02  -1.03099400E-02  -7.85340000E-04  +2.00700000E-04  +5.80000000E-07
   -5.76289000E-03  -2.00016300E-02  +5.73189000E-03  +2.38069200E-02  +3.40148100E-02
   +5.68504680E-01  -6.09316000E-03  +5.02628400E-02  +3.43410000E-03  -6.52997000E-03
   +8.89150000E-04  -1.86592000E-03  +1.16270000E-03  +1.41094000E-03  +7.67000000E-06
   +2.13470000E-04  -6.47590000E-04  -3.98800000E-05  -3.10460000E-04  +2.12410000E-04
   +1.07600000E-04  +1.65958000E-03  +2.12926000E-03  +8.11100000E-04  -4.94640000E-04
   -9.63300000E-05  -8.30000000E-06  +1.42020000E-04  -2.47400000E-05  -1.32540000E-04
   -4.37459100E-02  -3.42426900E-02  -1.02327100E-02  +1.45270000E-04  +9.27900000E-05
   -1.63100000E-05  +7.61400000E-05  -5.17000000E-05  +2.22100000E-05  +5.50257600E-02
   +2.73139000E-03  -2.11514500E-02  -1.03753000E-03  +2.02861000E-03  +3.01441000E-03
   +4.41910000E-04  +4.90720000E-04  -9.62870000E-04  +7.38000000E-06  -1.91132000E-03
   +1.43345000E-03  -4.56710000E-04  +6.85930000E-04  -2.12793000E-03  -9.56600000E-05
   -5.82204000E-03  +5.54785000E-03  -6.17400000E-04  +2.18753000E-03  -4.16960000E-04
   +1.60600000E-05  -4.07130000E-04  -1.07620000E-04  +4.88700000E-04  +1.75186300E-02
   -5.28782560E-01  -3.95624500E-02  -6.78490000E-04  -5.96440000E-04  +2.59150000E-04
   -1.98500000E-05  +1.09370000E-04  -1.08550000E-04  -1.77016600E-02  +5.43762390E-01
   -3.59090000E-04  +8.35886000E-03  -1.68653000E-03  -1.78625000E-03  +1.77150000E-04
   +2.89574000E-03  +5.01900000E-05  +1.22600000E-05  +1.73643000E-03  -1.75840000E-04
   +2.64200000E-05  +9.58000000E-06  +1.64700000E-04  -9.95600000E-05  -6.18830000E-04
   +1.34270000E-04  +9.92810000E-04  -1.58871000E-03  +3.68700000E-05  -6.90800000E-05
   +4.04900000E-05  -2.64000000E-06  +7.70000000E-07  -1.18270000E-04  -6.07452000E-03
   -4.97461100E-02  -1.17831300E-02  +1.38500000E-05  -2.43300000E-05  -2.58400000E-05
   +4.82600000E-05  -4.87000000E-06  +1.76500000E-05  +8.13311000E-03  +4.07853700E-02
   +1.14556400E-02  +5.46088000E-03  -2.38455300E-02  -1.34331000E-03  -3.30815000E-03
   -2.85672000E-03  -2.05183000E-03  -1.56453000E-03  -4.62300000E-05  -1.28860000E-04
   -4.40565000E-03  +1.57057000E-03  -2.62038000E-03  +1.55050000E-04  +3.05124800E-02
   +1.81189000E-03  -6.24269000E-02  +3.25423600E-02  -3.45526000E-03  +7.12890000E-04
   +1.64034000E-03  +1.63910000E-04  -1.40420000E-04  -1.52620000E-04  +9.41900000E-05
   +3.07827000E-03  -9.61280000E-04  +1.21712000E-03  -2.00260000E-04  -2.29570000E-04
   +9.00700000E-05  -4.98120000E-04  -3.07300000E-05  +5.81800000E-05  -9.77750000E-04
   +8.33410000E-04  -1.99030000E-04  +6.20497200E-02  +8.58179000E-03  -1.52913400E-02
   +3.09340000E-04  -3.29925000E-03  -3.16710000E-04  -1.06002000E-03  -5.69690000E-04
   +6.11430000E-04  -1.19000000E-05  +1.96339000E-03  +1.72302000E-03  +1.29560000E-04
   +6.79350000E-04  -8.30009000E-03  -7.14680000E-04  +3.33710600E-02  -3.33961050E-01
   -1.47702100E-02  -4.36570000E-04  -4.53120000E-04  -1.12750000E-04  +7.56600000E-05
   +1.64600000E-05  -1.39210000E-04  -2.46830000E-04  +3.18399000E-03  +4.26160000E-04
   +1.48590000E-04  +1.11730000E-04  -2.86200000E-05  +1.75020000E-04  +2.88800000E-05
   +2.09700000E-05  -2.20372000E-03  -5.88960000E-04  -5.18220000E-04  -3.83687000E-02
   +3.53649260E-01  +7.16080000E-04  -6.66697000E-03  +3.33695000E-03  -2.14823000E-03
   -1.11269000E-03  +4.89564000E-03  -1.84830000E-04  +1.19260000E-04  -9.26690000E-04
   -2.00356000E-03  -6.08090000E-04  +7.59616000E-03  -4.47860000E-04  +5.72587000E-03
   +3.44211000E-03  -3.11075000E-03  -1.42007000E-02  -3.66833100E-02  -2.84300000E-04
   +2.44520000E-04  +5.74210000E-04  -1.00100000E-05  +4.01600000E-05  -1.18270000E-04
   +1.52256000E-03  +2.22790000E-04  -3.30039000E-03  -8.55000000E-05  -1.70200000E-05
   -1.50300000E-05  +3.51300000E-05  +8.55100000E-05  -2.77830000E-04  -4.26300000E-04
   +1.39960000E-04  +4.52850000E-04  +5.31381000E-03  +1.59769800E-02  +2.66590100E-02
   -3.03509000E-03  +2.56584000E-03  -1.95690000E-03  -2.84650000E-04  +1.03066000E-03
   +2.80150000E-04  +6.63500000E-04  +3.02233000E-03  -4.36570000E-04  +1.00688400E-02
   +5.30899000E-03  +1.10941000E-03  -2.19748940E-01  -1.31170330E-01  -4.14269300E-02
   -1.66255400E-02  -1.73232000E-02  -5.61816000E-03  +2.38459000E-03  -5.01900000E-05
   +9.89120000E-04  -8.27450000E-04  -5.42720000E-04  +8.79800000E-05  -9.28060000E-04
   -7.23650000E-04  -9.67800000E-05  -2.35328000E-03  -1.55130000E-04  -6.23670000E-04
   -5.89600000E-05  -7.51200000E-05  -6.27300000E-05  +9.48000000E-06  -1.65700000E-04
   -3.14200000E-05  +8.43850000E-04  -3.22680000E-04  +9.24010000E-04  +2.33770720E-01
   +3.03646000E-03  -1.47801000E-03  +1.80040000E-04  +6.03230000E-04  +2.89880000E-04
   +2.16330000E-04  +2.13112000E-03  -4.34075000E-03  -2.89370000E-04  -2.15124100E-02
   -1.09144200E-02  -5.22378000E-03  -1.33765010E-01  -1.73912550E-01  -3.55586600E-02
   +1.26007100E-02  +1.35450300E-02  +3.29687000E-03  -5.91300000E-05  +2.66840000E-04
   -1.19620000E-04  -6.83110000E-04  -2.53670000E-04  +4.32290000E-04  +1.40239000E-03
   +5.60000000E-04  +3.52500000E-04  -4.47060000E-04  -7.87330000E-04  +2.95770000E-04
   -1.42900000E-04  +1.50910000E-04  -4.60700000E-05  -2.08540000E-04  +1.78030000E-04
   -4.06600000E-05  +3.51130000E-04  +4.47750000E-04  +2.59190000E-04  +1.36109920E-01
   +1.76605670E-01  -2.43304000E-03  -2.62290000E-04  +8.55174000E-03  +2.07120000E-04
   +6.78360000E-04  -1.24000000E-03  -5.38980000E-04  -6.94790000E-04  +5.57124000E-03
   +1.50700000E-05  -1.78117000E-03  +4.67946000E-03  -4.03089500E-02  -3.20663300E-02
   -5.71281500E-02  -3.96281000E-03  -3.49371000E-03  +6.23231000E-03  -1.91700000E-05
   -4.36670000E-04  -3.07534000E-03  +2.75700000E-05  +6.27240000E-04  -2.39580000E-04
   -1.18700000E-04  -2.90300000E-05  -1.03835000E-03  -1.48457000E-03  +6.73300000E-04
   +1.01124000E-03  -1.86020000E-04  -2.15100000E-05  -1.80100000E-05  -1.35400000E-05
   -5.76100000E-05  +1.09590000E-04  +1.12084000E-03  +3.77720000E-04  -4.58665000E-03
   +4.70795700E-02  +3.56072200E-02  +4.48301900E-02  -4.39245000E-03  +1.46538000E-03
   -2.33526000E-03  +5.81360000E-04  +3.00970300E-02  +1.98347000E-03  -6.42027500E-02
   +3.33105400E-02  -1.97529000E-03  +9.08446000E-03  -2.26034600E-02  -1.09621000E-03
   -3.99953000E-03  -3.29156000E-03  -2.19035000E-03  -1.16535000E-03  -6.65000000E-06
   +5.17000000E-06  +1.17449000E-03  -6.90240000E-04  +8.45960000E-04  +3.47200000E-05
   +3.32830000E-04  +5.42500000E-05  -6.57000000E-05  +1.65960000E-03  +1.33470000E-04
   +2.60210000E-04  +3.72080000E-04  -8.53500000E-05  -3.08346000E-03  +6.30070000E-04
   -7.32080000E-04  -3.82580000E-04  +1.95940000E-04  -2.50000000E-07  +5.19800000E-05
   +2.61000000E-06  +1.50660000E-04  +6.73630000E-04  -9.47760000E-04  -1.18560000E-04
   +6.86096600E-02  +1.61473000E-03  +1.43012000E-03  -4.57510000E-04  -8.50440000E-04
   -7.51429000E-03  -1.23593000E-03  +3.36510800E-02  -3.39788300E-01  -2.24728100E-02
   +4.37423000E-03  -1.36434800E-02  -8.68310000E-04  -3.63580000E-03  -5.59510000E-04
   -1.46811000E-03  -4.19600000E-05  +7.17750000E-04  +1.91760000E-04  +1.50754000E-03
   -1.21164000E-03  +8.62800000E-05  -1.19200000E-05  +2.56210000E-04  +3.07660000E-04
   +1.44590000E-04  -6.87080000E-04  -3.25100000E-05  -1.08930000E-04  +1.14540000E-04
   -2.54000000E-06  +2.19281000E-03  -5.23200000E-05  -5.33450000E-04  +8.38900000E-05
   -9.82000000E-06  +4.13900000E-05  +5.11100000E-05  -8.46100000E-05  +8.51400000E-05
   +5.64410000E-04  -4.89530000E-04  -4.55800000E-05  -4.12404400E-02  +3.60311380E-01
   -2.44880000E-03  -6.47090000E-04  +8.47859000E-03  -1.33441000E-03  +4.43667000E-03
   +5.82270000E-03  -2.10820000E-04  -2.17362000E-02  -4.28268500E-02  -1.91390000E-04
   -6.29087000E-03  +2.99278000E-03  -2.48664000E-03  -1.02371000E-03  +5.09730000E-03
   +3.61380000E-04  +3.45590000E-04  -1.18226000E-03  +1.13762000E-03  -7.28650000E-04
   -2.95344000E-03  +3.64000000E-06  -4.96000000E-05  -4.15960000E-04  +9.57600000E-05
   +2.24090000E-04  -1.47400000E-04  -3.74600000E-05  -1.44940000E-04  +5.69200000E-05
   +2.75270000E-04  -3.50200000E-05  +1.15654000E-03  +2.41500000E-05  +6.53400000E-05
   -3.74920000E-04  +1.65400000E-04  +4.12100000E-05  -6.77870000E-04  +1.08760000E-04
   -2.78250000E-04  +5.73320000E-04  +3.38003000E-03  +2.51430900E-02  +2.96320900E-02
   +5.85043000E-03  +4.63244000E-03  +6.35160000E-04  -2.30460160E-01  -1.33655840E-01
   -4.98845000E-02  -1.66256200E-02  -1.86750200E-02  -5.45271000E-03  -2.56378000E-03
   +3.76635000E-03  -1.29750000E-03  -3.66900000E-05  +6.68060000E-04  +2.84960000E-04
   +7.73790000E-04  +1.58530000E-03  -7.78240000E-04  -3.72200000E-04  -1.12117000E-03
   -5.92830000E-04  -5.11000000E-05  +1.86900000E-05  +1.53760000E-04  +7.55130000E-04
   -4.48520000E-04  +7.78330000E-04  -3.69200000E-04  +1.95330000E-04  +3.58700000E-05
   -9.40000000E-06  -2.15800000E-05  +5.16000000E-06  +1.53300000E-05  -9.11600000E-05
   +9.14400000E-05  +3.50730000E-04  +2.46090000E-04  +1.20550000E-04  -1.85300000E-05
   -6.57100000E-05  +1.10940000E-04  +6.69510000E-04  +8.75100000E-05  +1.05233000E-03
   +2.42186160E-01  -2.76160700E-02  -1.30052000E-02  -6.97603000E-03  -1.32140200E-01
   -1.63372950E-01  -3.71420300E-02  +1.16363600E-02  +1.20030000E-02  +3.15706000E-03
   +3.00740000E-03  +1.95000000E-06  -3.65050000E-04  +1.26654000E-03  -8.15160000E-04
   +2.75870000E-04  +2.16230000E-03  -5.37959000E-03  -5.13180000E-04  +5.58840000E-04
   +6.39640000E-04  +1.33980000E-04  +1.17000000E-05  -3.88000000E-06  -1.55200000E-05
   -1.52250000E-04  +2.34502000E-03  +4.46330000E-04  +1.15020000E-04  -1.39230000E-04
   +9.91000000E-05  -3.73000000E-05  +4.83500000E-05  -1.84000000E-05  +2.00200000E-05
   +4.24920000E-04  +7.95600000E-05  -1.17531000E-03  -7.33380000E-04  -3.07300000E-04
   -5.18900000E-05  +5.88700000E-05  +5.13000000E-05  -4.47270000E-04  +8.33220000E-04
   +4.90440000E-04  +1.42883090E-01  +1.67149610E-01  -2.22037000E-03  -8.61100000E-04
   +4.16874000E-03  -4.98668400E-02  -3.74205700E-02  -4.83037700E-02  -2.38123000E-03
   -2.40909000E-03  +1.69696000E-03  -2.18147000E-03  +1.68910000E-04  +7.49945000E-03
   +3.96890000E-04  -2.39700000E-05  -9.95410000E-04  -7.06070000E-04  -7.51550000E-04
   +5.14606000E-03  +1.25930000E-04  -3.82250000E-04  +6.61150000E-04  -1.09330000E-04
   -4.54900000E-05  +8.66800000E-05  +6.61090000E-04  +4.67650000E-04  -3.09081000E-03
   +5.37300000E-05  +3.01400000E-05  -2.64590000E-04  +2.65100000E-05  -6.68000000E-05
   +6.09100000E-05  +1.07080000E-04  +4.76300000E-05  -4.97160000E-04  -4.77500000E-05
   -1.03700000E-05  -9.33300000E-05  +7.79600000E-05  +1.78400000E-05  -6.17660000E-04
   +1.02636000E-03  +5.68850000E-04  -4.69283000E-03  +5.48947100E-02  +4.05686100E-02
   +3.92955300E-02  +1.62720000E-04  +2.76440000E-04  +1.03990000E-04  +2.19000000E-06
   -4.90700000E-05  +1.82240000E-04  -8.38340000E-04  +1.27860000E-03  +5.80310000E-04
   -1.39153000E-03  +3.86110000E-04  -1.87690000E-04  +4.37080000E-04  -6.70100000E-04
   -1.48780000E-04  -4.00620000E-04  -1.70600000E-04  -6.46600000E-05  +3.50157000E-03
   -1.98156000E-03  +6.10320000E-03  +2.26210000E-04  +8.16050000E-04  +7.28830000E-04
   -9.71700000E-05  +2.57000000E-06  -5.27600000E-05  +1.46813000E-03  +1.53549000E-03
   -1.97715000E-03  -1.16558690E-01  -4.77772900E-02  -1.11027260E-01  -2.86000000E-06
   -1.22600000E-05  -3.02800000E-05  +1.33800000E-05  -1.49300000E-05  +6.85000000E-06
   +3.30200000E-05  -4.40000000E-07  +3.39700000E-05  -3.46463000E-03  +1.63196000E-03
   +5.45790000E-04  -1.03600000E-05  +4.10000000E-07  +4.63000000E-06  +1.24982000E-01
   +7.02200000E-05  +1.05870000E-04  -9.30000000E-07  +2.73440000E-04  +2.94400000E-05
   +1.61540000E-04  -8.49500000E-05  +4.92400000E-05  -1.27360000E-04  -5.61030000E-04
   +6.83440000E-04  +9.42640000E-04  -1.45020000E-04  -5.72200000E-05  +3.99770000E-04
   -7.03400000E-05  +1.24830000E-04  -1.02010000E-04  -1.93390100E-02  -1.14828400E-02
   -2.70874900E-02  +1.14913000E-03  +9.76040000E-04  +4.08900000E-04  -6.59400000E-05
   +5.29500000E-05  -2.87000000E-06  +2.19535000E-03  -4.60227000E-03  -1.47870000E-04
   -4.65368100E-02  -8.31083000E-02  -8.02754100E-02  +1.43000000E-05  -8.49000000E-06
   -6.75000000E-06  -4.07000000E-06  +3.88000000E-06  -4.40300000E-05  -9.01200000E-05
   +4.93100000E-05  -2.20200000E-05  +1.20465000E-03  +2.48660000E-04  -2.65970000E-04
   +1.38000000E-06  -4.69000000E-06  -8.91000000E-06  +5.18045300E-02  +9.12656700E-02
   -2.07270000E-04  -4.84100000E-05  -7.71000000E-05  +2.52630000E-04  +4.81620000E-04
   +1.46330000E-04  -1.28338000E-03  -8.31210000E-04  +6.44600000E-05  +3.84850000E-04
   -1.13310000E-04  +1.23990000E-04  +2.39200000E-05  +2.05560000E-04  +1.40270000E-04
   +1.40760000E-04  +1.63570000E-04  +4.59100000E-05  -1.64356000E-03  +2.48129000E-03
   -2.92636000E-03  +9.94430000E-04  +1.23822000E-03  -2.36890000E-04  +7.63300000E-05
   +7.24800000E-05  +5.13000000E-06  -8.99400000E-04  -9.54280000E-04  +1.89672000E-03
   -1.10564400E-01  -8.59322700E-02  -2.24622590E-01  -6.62000000E-06  +1.47000000E-05
   -1.11000000E-06  +2.89000000E-06  +4.58000000E-06  -1.14400000E-05  -7.56600000E-05
   +4.70200000E-05  -1.33700000E-05  +6.85980000E-04  +4.90800000E-04  +2.72830000E-04
   +6.16000000E-06  -3.13900000E-05  +4.24300000E-05  +1.20961940E-01  +8.94978500E-02
   +2.39473590E-01  +2.71700000E-05  -1.00470000E-04  -2.33700000E-05  +7.45700000E-05
   +1.88280000E-04  +4.74600000E-05  -5.84100000E-05  -3.78900000E-04  -4.53900000E-05
   +9.23170000E-04  +1.10210000E-04  +7.64040000E-04  -1.93400000E-04  -7.33300000E-05
   +1.27100000E-05  +8.32100000E-05  +1.71020000E-04  -2.75900000E-05  -7.15934000E-03
   +1.83804000E-03  +1.24090000E-04  +9.35910000E-04  -7.76680000E-04  +3.72690000E-04
   -7.64200000E-05  +7.72400000E-05  -1.85000000E-06  +1.58513000E-03  -1.86398000E-03
   -1.53652000E-03  -3.18103910E-01  +3.96512700E-02  +3.32098000E-02  +1.10600000E-05
   -9.54000000E-06  +2.98000000E-06  -3.10800000E-05  +1.22600000E-05  -1.21000000E-05
   -2.68900000E-05  +2.93900000E-05  +4.38500000E-05  +1.57110000E-04  +3.45100000E-04
   +4.24800000E-05  -9.73000000E-06  -4.04000000E-06  +8.71000000E-06  -1.25325300E-02
   +2.04901000E-03  +2.95294000E-03  +3.41146540E-01  -2.00240000E-04  -9.11800000E-05
   -6.48200000E-05  +1.68150000E-04  +3.37900000E-04  -8.22400000E-05  -8.93320000E-04
   -6.13610000E-04  -3.50220000E-04  -1.43814000E-03  -5.72416000E-03  -5.37550000E-04
   +1.53550000E-03  -7.90900000E-05  +7.54590000E-04  +6.54300000E-05  -4.63790000E-04
   -1.26570000E-04  +3.61956300E-02  -7.55817000E-03  -4.34316000E-03  -8.13400000E-05
   +9.56300000E-05  -4.26940000E-04  +8.81000000E-05  +2.66500000E-05  +5.05100000E-05
   -5.13300000E-05  -5.65000000E-05  +1.79475000E-03  +3.52008300E-02  -4.94639800E-02
   -8.57576000E-03  -2.71800000E-05  +1.18000000E-05  +2.87000000E-06  +1.56830000E-04
   -5.02700000E-05  -1.47900000E-05  +3.24700000E-05  +5.53900000E-05  +8.43000000E-06
   -5.54500000E-05  +4.24440000E-04  +2.17950000E-04  +3.42400000E-05  -1.59000000E-05
   +1.01600000E-05  -1.12198700E-02  +1.27552000E-03  +2.70004000E-03  -4.23212600E-02
   +5.88718900E-02  -3.78380000E-04  -1.33790000E-04  -9.75400000E-05  +8.89000000E-05
   +9.11200000E-05  +1.12440000E-04  -8.20030000E-04  -4.36450000E-04  -1.05480000E-04
   +3.71160000E-04  -1.25918000E-03  +1.31389000E-03  -2.34500000E-04  +5.38150000E-04
   +4.92680000E-04  +4.45950000E-04  +1.22100000E-04  -7.42100000E-05  +3.10115000E-03
   +4.17762000E-03  -2.05044000E-03  -1.63080000E-04  -3.54500000E-05  -4.96490000E-04
   +2.65950000E-04  -6.11100000E-05  +4.91600000E-05  +5.00400000E-04  -1.30922000E-03
   +7.86200000E-05  +3.34035400E-02  -1.06790000E-02  -4.95236900E-02  -1.54700000E-05
   +3.62600000E-05  -3.60000000E-06  +2.59500000E-05  +2.66000000E-06  -5.70400000E-05
   -1.66300000E-05  +1.12100000E-05  +7.24200000E-05  +1.29840000E-04  +3.73710000E-04
   -2.24550000E-04  +4.13000000E-06  -3.69000000E-06  +1.76700000E-05  -2.48741000E-02
   +4.69150000E-03  +4.12805000E-03  -3.69032400E-02  +8.78720000E-03  +5.05499600E-02
   +4.31700000E-04  +4.81100000E-04  +9.86400000E-05  +1.18280000E-04  -2.79440000E-04
   -7.58300000E-05  +1.50100000E-04  +9.09370000E-04  +8.24800000E-05  -1.96052000E-03
   +7.61670000E-04  +1.02079000E-03  +4.26700000E-04  -8.77110000E-04  +3.17840000E-04
   -6.76470000E-04  -1.56180000E-04  -3.32590000E-04  +2.77770000E-04  +2.74497000E-03
   -4.84006000E-03  +1.37314000E-03  +3.68940000E-04  +1.44730000E-04  -2.49800000E-04
   +1.96300000E-05  -2.16100000E-05  +3.13380000E-04  -8.31750000E-04  -5.66060000E-04
   -6.24164700E-02  -3.57834100E-02  +5.90607500E-02  +7.55000000E-06  -3.10600000E-05
   +2.63000000E-06  +3.41000000E-06  -5.41000000E-06  -2.73900000E-05  -1.21200000E-05
   -2.14600000E-05  +5.61500000E-05  -3.34730000E-04  -8.63600000E-05  -3.45920000E-04
   -1.79100000E-05  +1.09000000E-06  -3.92000000E-06  +4.23584000E-03  +9.32544000E-03
   -1.23553700E-02  -7.18842000E-03  -1.67020000E-02  +2.54537400E-02  +6.61031100E-02
   -2.07020000E-04  +9.62700000E-05  +8.96000000E-06  +2.42110000E-04  -2.75390000E-04
   +7.13500000E-05  -3.22850000E-04  -7.14700000E-05  +1.53170000E-04  +1.49621000E-03
   -2.45560000E-04  -1.47580000E-03  -7.39000000E-05  +2.65150000E-04  -9.25690000E-04
   +2.02340000E-04  +1.59350000E-04  +3.52370000E-04  -1.12905800E-02  -1.56376300E-02
   +2.68747800E-02  +3.44220000E-04  -1.51289000E-03  +1.29796000E-03  +1.93590000E-04
   -7.28100000E-05  -2.05100000E-05  +2.27914000E-03  -1.02170000E-04  -2.52455000E-03
   -3.78070500E-02  -1.10542190E-01  +1.06846700E-01  +1.75000000E-06  +2.49000000E-05
   +8.48000000E-06  -3.47200000E-05  -6.91000000E-06  +8.05500000E-05  -1.63000000E-05
   +1.58700000E-05  -3.79700000E-05  +3.46490000E-04  -4.30000000E-07  +7.06400000E-05
   -2.64000000E-06  +5.22000000E-06  -2.00000000E-08  +4.57751000E-03  +6.47939000E-03
   -9.71207000E-03  +1.16696000E-03  +2.42561000E-03  -4.90322000E-03  +3.99751000E-02
   +1.18303990E-01  -1.30490000E-04  -1.58700000E-05  +4.72000000E-06  -9.74400000E-05
   -2.91510000E-04  +2.03260000E-04  +9.55200000E-05  +2.16450000E-04  +3.23160000E-04
   +1.02729000E-03  -6.55900000E-05  +5.20120000E-04  -3.96000000E-04  +3.26900000E-04
   -1.71320000E-04  +2.33340000E-04  +7.74500000E-05  +1.12490000E-04  -1.78921000E-03
   +1.48843000E-03  +4.14100000E-04  +6.39160000E-04  +1.54064000E-03  +1.06124000E-03
   +1.59980000E-04  -8.95900000E-05  -1.30200000E-05  -1.09697000E-03  -1.50997000E-03
   +5.41300000E-05  +6.00851000E-02  +1.00726270E-01  -2.18601640E-01  +8.10000000E-07
   +1.96600000E-05  -2.06600000E-05  -1.48400000E-05  +1.62000000E-06  -9.10000000E-07
   +2.10000000E-07  -1.29000000E-06  -6.25000000E-06  +1.99000000E-06  -1.01460000E-04
   -5.57610000E-04  -3.69000000E-06  +1.62200000E-05  -1.54500000E-05  +8.39954000E-03
   +1.27613800E-02  -1.77947800E-02  +1.16950000E-04  +1.25498000E-03  -3.35039000E-03
   -6.73370400E-02  -1.16893830E-01  +2.38874120E-01  -3.55180000E-04  -5.16160000E-04
   -1.51440000E-04  -2.96360000E-04  +4.25120000E-04  -1.80070000E-04  +8.13880000E-04
   +1.42620000E-04  +6.07590000E-04  -1.46209000E-03  -2.04430000E-04  -3.36900000E-05
   -1.39806000E-03  +3.95910000E-04  -1.40853000E-03  +4.61960000E-04  -2.30000000E-07
   -1.50170000E-04  +9.21784000E-03  -1.80092100E-02  -1.75821500E-02  -6.76610000E-04
   -6.81450000E-04  +1.94650000E-04  +1.14270000E-04  -8.51000000E-06  +1.36910000E-04
   -9.06052200E-02  +8.41497100E-02  +7.12574200E-02  -2.67307000E-03  -1.25930000E-03
   -8.54630000E-04  -2.65300000E-05  +2.32500000E-05  -2.34300000E-05  +4.68000000E-05
   +7.32000000E-06  -4.40200000E-05  -7.90230000E-04  +8.78710000E-04  -7.46950000E-04
   +4.05300000E-05  -9.22000000E-06  -1.72000000E-06  +2.36300000E-05  +1.03100000E-05
   -3.92800000E-05  -2.15600000E-05  -8.57290000E-04  +5.67700000E-05  +2.15410000E-04
   +6.64500000E-05  -2.82300000E-05  +2.90000000E-07  -3.20450000E-04  -8.66700000E-05
   +1.00176920E-01  -2.51630000E-04  +1.37952000E-03  +1.60240000E-04  +9.31530000E-04
   -1.34353000E-03  -5.38000000E-05  -2.02499000E-03  -6.64320000E-04  -2.64300000E-04
   +3.45761000E-03  -1.05563000E-03  +2.90102000E-03  +1.38847000E-03  +1.06676000E-03
   +1.01689000E-03  -5.70600000E-04  +8.37200000E-05  +3.31750000E-04  -1.56510000E-04
   -1.64882400E-02  -1.64269200E-02  -5.94030000E-04  -1.04245000E-03  +1.97998000E-03
   +7.96370000E-04  -5.10720000E-04  -2.80100000E-05  +8.09381100E-02  -1.41350560E-01
   -1.18964520E-01  -2.09861000E-03  -1.51280000E-04  -3.61759000E-03  -7.77000000E-06
   +1.10570000E-04  +2.72000000E-05  +4.33700000E-05  -2.90900000E-05  -3.61000000E-06
   +1.65693000E-03  -2.38880000E-04  +7.94260000E-04  +8.79000000E-06  +2.77200000E-05
   +5.77300000E-05  +2.34600000E-05  -1.30900000E-05  -3.42400000E-05  -4.21550000E-04
   -1.21776000E-03  +7.91200000E-05  -3.07270000E-04  +4.98050000E-04  +2.99760000E-04
   +7.23200000E-05  +1.73650000E-04  +3.70460000E-04  -8.15889800E-02  +1.61971890E-01
   +4.47600000E-04  -4.24560000E-04  -3.18300000E-05  -1.90220000E-04  +6.91950000E-04
   -3.48300000E-05  +7.24500000E-04  +3.26580000E-04  +6.02780000E-04  -1.58584000E-03
   +1.01187000E-03  -4.68900000E-04  -4.29450000E-04  -1.47170000E-03  -2.03880000E-04
   -1.77700000E-04  +3.18930000E-04  +6.63000000E-06  +1.53369800E-02  -4.33720000E-03
   -5.85241000E-03  +2.04000000E-06  +1.12584000E-03  -2.23022000E-03  -4.06980000E-04
   +3.18660000E-04  -3.51100000E-05  +6.25817100E-02  -1.28633030E-01  -1.69897410E-01
   -1.64219000E-03  -5.16470000E-04  +1.59177000E-03  -3.68300000E-05  -6.50100000E-05
   -1.23400000E-05  -4.75100000E-05  -9.14000000E-06  +4.13300000E-05  -9.71350000E-04
   +1.07450000E-03  -7.50400000E-04  +1.05990000E-04  +4.49700000E-05  -5.61000000E-06
   -6.44000000E-06  +1.30700000E-05  -4.62100000E-05  +9.17100000E-05  -2.13340000E-04
   +1.22640000E-04  +3.93400000E-05  +2.08070000E-04  -1.15580000E-04  -1.73490000E-04
   -7.04000000E-04  -4.14670000E-04  -7.55487400E-02  +1.32171480E-01  +1.79234600E-01
   -1.21840000E-04  -7.44800000E-05  -9.18800000E-05  -2.52020000E-04  -4.59300000E-04
   +1.31500000E-04  -7.97390000E-04  +7.07580000E-04  -3.10480000E-04  -2.65120000E-04
   -3.32996000E-03  -2.93187000E-03  -6.75400000E-05  +7.97900000E-05  +1.99580000E-04
   +3.80530000E-04  +7.81100000E-05  -1.63270000E-04  -2.18978700E-02  +1.31159500E-02
   -1.27048000E-02  -6.56140000E-04  -7.90560000E-04  +9.52500000E-04  +9.69100000E-05
   -6.31900000E-05  +8.07200000E-05  -1.66484230E-01  +1.17650310E-01  -8.00053400E-02
   +1.08676000E-03  +1.12602000E-03  +2.77347000E-03  +1.89100000E-05  +2.27300000E-05
   -1.38400000E-05  -1.21500000E-05  +1.20200000E-05  +1.02000000E-06  +1.53600000E-05
   -9.67100000E-05  +2.75320000E-04  -3.60200000E-05  -7.11600000E-05  -1.23040000E-04
   -8.89500000E-05  +4.13800000E-05  +3.54700000E-05  +3.36020000E-04  +3.31430000E-04
   +4.47100000E-04  +2.96270000E-04  -3.49400000E-04  -4.03450000E-04  -4.66080000E-04
   -6.05030000E-04  +6.23900000E-05  -7.40022000E-03  +4.70158000E-03  -4.88112000E-03
   +1.87706350E-01  -1.91740000E-04  -1.69870000E-04  -1.46530000E-04  -1.48190000E-04
   -1.46290000E-04  -2.66000000E-06  -8.33540000E-04  +4.83550000E-04  +7.80600000E-05
   -1.84244000E-03  -2.44580000E-03  -1.38703000E-03  -1.63740000E-04  -6.17150000E-04
   +8.95600000E-05  +3.75100000E-04  +3.44800000E-04  +9.54000000E-06  -1.69473700E-02
   +9.43447000E-03  -1.04251600E-02  -5.41090000E-04  -4.79120000E-04  +3.17650000E-04
   +2.38010000E-04  -4.36800000E-05  +9.42500000E-05  +1.26730810E-01  -1.46047420E-01
   +6.30100600E-02  -2.13876000E-03  +1.44130000E-04  -5.15780000E-04  -4.01300000E-05
   +3.29700000E-05  -1.23700000E-05  +1.19000000E-06  -1.02200000E-05  +1.49500000E-05
   +1.15700000E-04  +4.78670000E-04  +7.24100000E-05  +6.91000000E-06  +3.16700000E-05
   -6.51000000E-06  -5.06500000E-05  +3.50800000E-05  -2.37100000E-05  -1.77920000E-04
   +1.93930000E-04  +1.14780000E-04  +1.31190000E-04  +2.31200000E-04  -3.75830000E-04
   +4.70300000E-05  -3.23700000E-05  -4.82000000E-06  +8.88406000E-03  -9.88103000E-03
   +1.00405500E-02  -1.25093380E-01  +1.57545780E-01  +4.77910000E-04  -3.30350000E-04
   +7.88900000E-05  -3.09960000E-04  +2.39170000E-04  -2.96700000E-04  -1.18020000E-04
   +8.49570000E-04  +7.14100000E-04  -2.58915000E-03  -2.26399000E-03  +1.33166000E-03
   +5.69180000E-04  -1.09752000E-03  -6.74800000E-05  -3.53570000E-04  +4.53400000E-05
   +4.17300000E-05  -6.15141000E-03  +1.37739000E-02  -4.17499000E-03  +7.64400000E-04
   +6.97610000E-04  -2.27451000E-03  -4.96110000E-04  +2.87860000E-04  -9.55500000E-05
   -8.69790800E-02  +5.75113500E-02  -9.28608500E-02  -3.93030000E-04  +1.13522000E-03
   -4.19060000E-04  +1.12400000E-05  -7.07500000E-05  +8.14000000E-06  -4.40800000E-05
   +2.15500000E-05  -6.93000000E-06  +1.01570000E-04  +4.41400000E-05  -1.53300000E-04
   -5.33000000E-06  -5.18700000E-05  +9.36300000E-05  -6.25900000E-05  +4.99400000E-05
   -1.00400000E-04  +3.79400000E-04  +3.17200000E-05  -4.07500000E-05  +4.04770000E-04
   -8.97960000E-04  -6.14700000E-04  +5.44700000E-05  -4.58500000E-05  -1.57850000E-04
   +1.50142400E-02  -1.15251300E-02  +1.05394100E-02  +9.10634200E-02  -6.68878000E-02
   +9.53159600E-02  -1.15044000E-03  +4.30550000E-04  -2.86910000E-04  +3.90830000E-04
   -7.08660000E-04  +3.40680000E-04  -5.53980000E-04  -5.11940000E-04  -9.99090000E-04
   +1.75160000E-03  -4.11800000E-04  -1.81373000E-03  -7.95540000E-04  +4.55590000E-04
   +4.42750000E-04  +1.02544000E-03  +3.61020000E-04  +2.60170000E-04  -2.36114200E-02
   -1.72027100E-02  -1.74537000E-03  -5.51266000E-03  -7.46061000E-03  +3.98118000E-03
   +1.39029000E-03  -6.59570000E-04  +2.63430000E-04  -5.75744500E-02  -2.75141000E-02
   +3.83717600E-02  -5.02070000E-04  +1.09403000E-03  -7.61100000E-04  -9.22300000E-05
   +2.00470000E-04  -4.33500000E-05  +1.78840000E-04  -6.60200000E-05  -4.01800000E-05
   -1.36390000E-04  +1.37044000E-03  -8.89600000E-05  -8.01700000E-05  +2.68000000E-05
   -1.04590000E-04  +6.65500000E-05  -2.54500000E-05  +9.53700000E-05  +2.21700000E-05
   +6.28100000E-05  +4.32740000E-04  -3.60800000E-05  +1.57900000E-04  -7.05600000E-05
   +5.43700000E-05  +3.68820000E-04  +1.01618000E-03  -6.26810000E-03  -7.52961000E-03
   +8.26735000E-03  +8.78561000E-03  +1.26572600E-02  -1.17893600E-02  +8.51629600E-02
   -1.91710000E-03  +2.27859000E-03  -3.74340000E-04  +1.65005000E-03  -2.81767000E-03
   +7.00400000E-05  -3.41971000E-03  -1.42505000E-03  -1.53125000E-03  +6.43084000E-03
   -2.93916000E-03  +2.87279000E-03  -2.31800000E-05  +2.71340000E-03  +1.66861000E-03
   +9.41420000E-04  +2.96730000E-04  -1.70830000E-04  -2.72549800E-02  -2.14903600E-02
   -1.46878200E-02  -7.83480000E-03  -1.03226100E-02  +4.71916000E-03  +2.71238000E-03
   -1.56361000E-03  +5.39910000E-04  -1.70497900E-02  -6.03708800E-02  +4.80577000E-02
   -1.10013000E-03  +1.18565000E-03  -1.68471000E-03  -7.02900000E-05  +3.98070000E-04
   -3.68600000E-05  +2.74670000E-04  -1.06120000E-04  -1.68900000E-05  +1.68643000E-03
   +9.13850000E-04  -1.57440000E-04  -1.72250000E-04  +2.31000000E-06  +7.50000000E-06
   +1.02710000E-04  -4.02800000E-05  +9.41100000E-05  +7.93000000E-06  +6.45500000E-05
   +2.20890000E-04  +3.53120000E-04  +1.26570000E-04  +2.37290000E-04  +4.39240000E-04
   +5.62080000E-04  +8.79790000E-04  +8.53520000E-03  +7.14399000E-03  -9.25400000E-03
   -8.40286000E-03  -9.69257000E-03  +1.02408400E-02  +2.84656600E-02  +8.42319100E-02
   +2.46732000E-03  -1.83362000E-03  +6.50750000E-04  -1.57158000E-03  +2.87812000E-03
   +2.62900000E-04  +3.63302000E-03  +1.18291000E-03  +7.10390000E-04  -6.05328000E-03
   +4.08010000E-03  -4.64335000E-03  +7.05440000E-04  -2.47904000E-03  -9.22550000E-04
   -2.04434000E-03  -6.85270000E-04  +6.64600000E-05  +1.92777300E-02  +3.05066000E-03
   +4.03276700E-02  +7.66253000E-03  +1.17964500E-02  -1.05078200E-02  -3.12062000E-03
   +1.67667000E-03  -7.28680000E-04  +5.29313000E-03  +1.82718300E-02  -8.17261400E-02
   +3.85370000E-04  -4.41510000E-04  -4.92955000E-03  +1.06410000E-04  -4.53280000E-04
   +5.32800000E-05  -2.71530000E-04  +1.15750000E-04  +8.45000000E-06  -1.18144000E-03
   -1.15273000E-03  -2.06260000E-04  +2.14830000E-04  -4.83000000E-06  -8.30100000E-05
   -1.13340000E-04  -9.80000000E-07  -1.42000000E-06  +6.53960000E-04  -1.05918000E-03
   -1.10235000E-03  +1.90000000E-06  -5.90410000E-04  -1.04830000E-04  -3.18500000E-04
   +1.06333000E-03  -7.05510000E-04  +1.07713200E-02  +1.29472500E-02  -1.37740600E-02
   +6.35254000E-03  +5.82793000E-03  -7.59089000E-03  -2.25473700E-02  -2.63056200E-02
   +8.46963300E-02  -7.47800000E-05  -4.08200000E-05  +8.14400000E-05  -3.92610000E-04
   +4.17440000E-04  -2.56670000E-04  +2.21040000E-04  -1.46810000E-04  +1.49180000E-04
   -1.31024000E-03  +3.32240000E-04  +3.75970000E-04  +9.41700000E-05  +1.21960000E-04
   +3.83800000E-05  -3.31910000E-04  -5.73000000E-05  -1.66010000E-04  +5.56661000E-03
   -2.17400000E-04  -5.95450000E-03  -3.45025810E-01  +1.22987730E-01  -2.07590070E-01
   -1.37920000E-04  +6.93600000E-05  -5.80400000E-05  +9.18400000E-04  +1.52485000E-03
   +1.12018000E-03  -4.56340000E-04  -8.01270000E-04  +1.51479000E-03  -4.61900000E-05
   -4.04000000E-06  +2.32700000E-05  +1.16500000E-05  +3.77000000E-06  +3.01900000E-05
   +1.01140000E-04  -4.37000000E-06  +3.23400000E-05  +2.52700000E-05  -4.78600000E-05
   +1.15150000E-04  -2.05500000E-05  -5.94000000E-06  +1.63700000E-05  +2.74200000E-05
   -2.26670000E-04  -1.14230000E-04  -1.85870000E-04  -4.06700000E-05  +6.71200000E-05
   -1.40670000E-04  -6.27710000E-04  -5.51600000E-05  +5.85400000E-05  -1.88680000E-04
   +4.62670000E-04  -8.55900000E-05  -6.67000000E-06  +2.86020000E-04  -4.39990000E-04
   -2.66830000E-04  +1.50911000E-03  +3.57452650E-01  +1.11500000E-05  +2.84820000E-04
   +3.69300000E-05  -1.16560000E-04  -1.95710000E-04  -1.78510000E-04  -1.73400000E-04
   -1.09550000E-04  -1.86690000E-04  +5.44520000E-04  +2.76420000E-04  -2.16650000E-04
   -4.97800000E-05  +4.00960000E-04  -2.26440000E-04  +1.25060000E-04  -2.03310000E-04
   +2.31780000E-04  +5.59970000E-04  -4.66180000E-04  +5.60720000E-04  +1.57940180E-01
   -1.00502530E-01  +1.07541250E-01  +1.26320000E-04  -1.50260000E-04  +1.97700000E-05
   -4.53640000E-04  -4.59220000E-04  -2.07220000E-04  +4.19550000E-04  -4.50290000E-04
   +1.04574000E-03  +3.27300000E-05  +2.71200000E-05  -1.66100000E-05  +3.36100000E-05
   -2.64000000E-05  -4.61200000E-05  +3.32000000E-06  -6.40100000E-05  -1.84520000E-04
   -7.83600000E-05  -1.42290000E-04  +1.40380000E-04  -1.83800000E-05  -1.21800000E-05
   +4.40600000E-05  +1.83100000E-05  -4.78830000E-04  +2.06100000E-04  -3.69000000E-04
   +1.94130000E-04  -2.17720000E-04  -3.25740000E-04  -2.27940000E-04  +3.19100000E-05
   -3.67700000E-05  +3.58700000E-05  -1.13010000E-04  +1.54900000E-05  -5.26000000E-06
   -9.24700000E-05  +2.50300000E-05  +2.33810000E-04  -4.04380000E-04  -1.35926940E-01
   +9.14309900E-02  +8.34050000E-04  -5.06240000E-04  +1.39900000E-05  -3.30110000E-04
   +4.31480000E-04  -1.57920000E-04  +1.10271000E-03  +5.06930000E-04  +5.77990000E-04
   -2.38280000E-04  -1.71780000E-04  +2.99050000E-04  +2.89530000E-04  -8.10730000E-04
   +2.23710000E-04  -4.18200000E-05  -2.52970000E-04  +1.80200000E-05  -5.33046000E-03
   +1.48825000E-03  +3.98220000E-04  -2.09835590E-01  +8.62704300E-02  -1.42354330E-01
   -9.77620000E-04  +4.47280000E-04  -1.78830000E-04  -2.65630000E-04  -1.32026000E-03
   -1.03330000E-03  +2.94820000E-04  +9.15480000E-04  -1.41600000E-03  +9.17100000E-05
   -1.16720000E-04  +4.71400000E-05  -5.39800000E-05  +5.24400000E-05  +4.38000000E-06
   -1.59160000E-04  -2.37490000E-04  -2.05700000E-04  -2.96600000E-05  -5.38800000E-05
   -7.01000000E-06  -6.74600000E-05  -4.98000000E-06  +2.44500000E-05  -6.80200000E-05
   +2.17260000E-04  +1.13990000E-04  +3.55720000E-04  -1.36080000E-04  -4.63600000E-05
   +2.28490000E-04  +3.56400000E-04  +7.60200000E-05  -2.65000000E-05  +2.00750000E-04
   -4.31670000E-04  +4.87000000E-05  -5.06900000E-05  -6.11200000E-05  +2.00960000E-04
   +4.08990000E-04  -1.02702000E-03  +2.20281410E-01  -9.28342700E-02  +1.49018600E-01
   +1.52180000E-04  +9.29860000E-04  +4.51700000E-05  +3.89550000E-04  -1.15834000E-03
   -2.16800000E-05  -8.22210000E-04  -9.14810000E-04  -5.31740000E-04  +6.66620000E-04
   -1.15156000E-03  +3.01510000E-04  -3.90940000E-04  -1.86378000E-03  +4.70420000E-04
   -6.59200000E-05  -2.90780000E-04  +3.71800000E-05  -4.95142000E-03  -5.81050000E-04
   -7.11840000E-04  +3.56574000E-03  +2.92325000E-03  +2.91130000E-04  +2.56280000E-04
   -4.63620000E-04  +1.01300000E-05  +3.90238000E-03  +3.55876000E-03  -1.39926000E-03
   +2.31770000E-04  +6.66400000E-05  -4.97900000E-05  +2.00180000E-04  +1.07350000E-04
   +5.43200000E-05  +5.91710000E-04  +1.57900000E-04  +6.63200000E-05  -1.21059000E-03
   +6.19700000E-04  +6.17140000E-04  -2.19860000E-04  -1.64830000E-04  -4.28700000E-05
   +1.83100000E-05  -6.29300000E-05  +3.38600000E-05  -7.26500000E-05  +5.16600000E-05
   +1.30110000E-04  +5.45300000E-05  -9.72400000E-05  +4.96900000E-05  +3.47200000E-05
   +1.15870000E-04  +3.80000000E-06  -3.43950000E-04  -2.29280000E-04  +1.02720000E-04
   -1.58400000E-04  -2.93130000E-04  +2.42490000E-04  -3.20230000E-03  -4.05766000E-03
   +4.93098000E-03  +5.77000000E-06  +2.25380000E-04  +1.71450000E-04  +4.11347950E-01
   +1.28273000E-03  -1.79700000E-05  +1.87910000E-04  -3.54110000E-04  +4.35010000E-04
   -2.96900000E-05  +7.18480000E-04  -1.54760000E-04  +1.18520000E-04  -2.06466000E-03
   +5.78300000E-05  -5.52910000E-04  -7.09020000E-04  -2.39015000E-03  +1.23014000E-03
   -1.06226000E-03  -1.74263000E-03  -4.63330000E-04  +2.29517000E-03  +1.14101000E-03
   +1.02744000E-03  -1.84285000E-03  -2.07470000E-03  -1.04129000E-03  -1.79028000E-03
   +6.60150000E-04  -3.07430000E-04  -2.39371000E-03  -2.51573000E-03  +1.06203000E-03
   -2.70700000E-05  -2.38640000E-04  +2.38900000E-05  +1.67920000E-04  -3.25150000E-04
   +2.22200000E-05  -4.49240000E-04  +1.12320000E-04  -2.28000000E-05  +1.90750000E-04
   -1.69060000E-03  -2.19500000E-05  -7.91300000E-05  -1.29190000E-04  -5.18500000E-05
   -5.74000000E-05  +4.14000000E-06  -9.76000000E-06  +1.72000000E-05  -4.85500000E-05
   -9.88900000E-05  -4.47000000E-06  +5.19800000E-05  -5.95800000E-05  -3.76300000E-05
   -8.95200000E-05  -4.22800000E-05  +2.48430000E-04  +5.28890000E-04  -7.61850000E-04
   +1.58550000E-04  -2.10890000E-04  -1.89380000E-04  +1.54385000E-03  +3.28041000E-03
   -3.05731000E-03  -5.44200000E-05  -3.10600000E-05  +3.04000000E-04  -7.64431000E-03
   +3.66795580E-01  +1.50650000E-04  -1.91780000E-04  -1.92750000E-04  -8.07400000E-05
   +3.18170000E-04  +3.80600000E-05  +2.42600000E-04  +2.25410000E-04  +5.38300000E-05
   -3.52430000E-04  +4.35200000E-04  +7.57600000E-05  -8.02150000E-04  -9.95700000E-04
   +1.36680000E-03  +1.55410000E-04  +2.23300000E-05  +2.96660000E-04  +1.22463000E-03
   +5.92940000E-04  -5.10660000E-04  -1.46055000E-03  -1.65071000E-03  +3.04500000E-04
   -1.79450000E-04  +1.63030000E-04  +9.17600000E-05  -1.55934000E-03  -1.54404000E-03
   +8.29340000E-04  +6.30700000E-05  -1.67300000E-05  +2.19410000E-04  -2.43500000E-05
   -3.76400000E-05  -1.22850000E-04  -9.94000000E-05  -5.95000000E-06  -3.14010000E-04
   -1.05370000E-04  -1.32870000E-04  -2.45613000E-03  +6.01800000E-05  +4.67800000E-05
   -3.61100000E-05  -1.55000000E-06  +1.91600000E-05  -2.15400000E-05  +6.59700000E-05
   +7.14700000E-05  -3.97900000E-05  +3.98000000E-06  +6.71000000E-06  -7.98800000E-05
   -2.19900000E-05  -1.06300000E-04  -1.24000000E-06  -3.33240000E-04  -6.67940000E-04
   +5.73730000E-04  +5.79000000E-05  +3.96240000E-04  +7.65300000E-05  +2.35767000E-03
   +1.86862000E-03  -3.92899000E-03  -2.75000000E-06  +2.16560000E-04  +1.00100000E-05
   +9.03701100E-02  +3.08364670E-01  +3.10267460E-01  +1.53780000E-04  +4.75600000E-05
   +1.52100000E-05  -3.93000000E-06  -2.15600000E-05  -4.53000000E-06  +2.18200000E-05
   -7.91100000E-05  -3.44600000E-05  -2.68710000E-04  -3.62400000E-05  -1.38900000E-05
   +1.70650000E-04  -4.73890000E-04  +3.95070000E-04  +2.40000000E-06  -1.44350000E-04
   +3.18100000E-05  -7.79200000E-05  +5.56900000E-05  -6.51900000E-05  -1.16280000E-04
   -1.74980000E-04  -5.65000000E-06  -1.62170000E-04  +4.95300000E-05  -1.00000000E-07
   -2.46000000E-05  -6.99300000E-05  -3.00000000E-06  +2.41300000E-05  -1.99000000E-06
   +5.79000000E-06  +2.33300000E-05  -3.64400000E-05  -2.66300000E-05  +4.94500000E-05
   +3.83900000E-05  -1.07070000E-04  -2.77940000E-04  +4.62550000E-04  -6.81360000E-04
   -1.94300000E-05  -1.78800000E-05  -2.10100000E-05  -2.54000000E-06  -1.25000000E-06
   -2.56000000E-06  +2.31000000E-06  +7.82000000E-06  -6.60000000E-07  +3.24000000E-06
   -4.72000000E-06  -4.10000000E-06  -5.20000000E-07  -4.46000000E-06  +1.88000000E-06
   +5.81000000E-06  -7.87800000E-05  +1.89400000E-05  +6.50000000E-06  +5.21800000E-05
   +2.67400000E-05  +1.27280000E-04  +7.86400000E-05  -1.09550000E-04  -8.36000000E-06
   +9.86000000E-06  +1.79700000E-05  -2.06536510E-01  -1.69275190E-01  -2.02063500E-01
   +1.94405430E-01  -2.93740000E-04  +1.47990000E-04  -1.21140000E-04  +9.02000000E-05
   -1.42600000E-04  +1.57100000E-05  -1.25850000E-04  -1.02340000E-04  -8.68100000E-05
   +1.83400000E-04  -1.38200000E-04  +1.22090000E-04  -2.17760000E-04  -1.03280000E-04
   +3.53580000E-04  +1.32060000E-04  +1.89000000E-06  +3.85400000E-05  -8.59590000E-04
   -8.71200000E-05  -3.85120000E-04  +3.35010000E-04  +3.09280000E-04  +2.06630000E-04
   +2.82050000E-04  -1.46980000E-04  +5.66700000E-05  +6.45020000E-04  +5.28680000E-04
   -1.00920000E-04  +7.59400000E-05  +5.41800000E-05  +4.86100000E-05  -3.02700000E-05
   +5.27800000E-05  -6.27000000E-06  -3.19600000E-05  +1.33100000E-05  +2.57000000E-05
   -1.39860000E-04  -2.23200000E-04  -5.86640000E-04  -2.27600000E-05  -6.13000000E-06
   -1.30400000E-05  +8.07000000E-06  +2.42000000E-06  +7.39000000E-06  +4.10000000E-06
   +3.67900000E-05  +2.65000000E-05  +1.18300000E-05  -2.67100000E-05  -4.74000000E-06
   +5.06000000E-06  +4.98000000E-06  +6.21000000E-06  -2.49720000E-04  -3.39890000E-04
   +2.53090000E-04  -4.54400000E-05  +5.46800000E-05  +9.29700000E-05  -1.69910000E-04
   -5.72570000E-04  +2.57400000E-05  -1.10500000E-05  +9.79000000E-06  -5.48000000E-06
   -1.31949400E-01  -1.67984630E-01  -1.83777510E-01  +1.53215650E-01  +1.82927500E-01
   +6.63000000E-06  -3.83600000E-05  +4.70200000E-05  +8.83000000E-06  +3.37000000E-06
   -7.50000000E-07  -3.22000000E-05  +7.40900000E-05  +3.64000000E-06  +1.75130000E-04
   +3.75000000E-05  +4.55900000E-05  +6.66260000E-04  +8.70400000E-04  -1.99880000E-04
   +2.00000000E-07  +1.45620000E-04  -2.74400000E-05  +1.08180000E-04  -8.34900000E-05
   +1.15650000E-04  +2.10910000E-04  +2.43220000E-04  -2.80500000E-05  +5.86100000E-05
   +1.21000000E-06  -1.74200000E-05  -1.18700000E-05  +1.23790000E-04  -1.06610000E-04
   -3.88000000E-05  +3.80000000E-07  -2.87200000E-05  -9.90000000E-06  +3.95000000E-06
   +2.58800000E-05  -3.90000000E-06  -5.70500000E-05  +3.70400000E-05  -7.34860000E-04
   -9.01270000E-04  +3.20770000E-04  +1.83300000E-05  +1.81300000E-05  +1.71800000E-05
   +1.02000000E-06  -8.40000000E-07  +3.30000000E-06  -9.02000000E-06  -1.70800000E-05
   -1.60000000E-07  -5.43000000E-06  +9.25000000E-06  +1.34500000E-05  +2.76000000E-06
   +1.29100000E-05  -2.00000000E-08  +9.82200000E-05  +1.31250000E-04  -2.83900000E-05
   -1.88000000E-06  -1.44800000E-05  -3.15700000E-05  -1.77440000E-04  -2.77050000E-04
   +4.49110000E-04  +1.24800000E-05  +2.03400000E-05  +3.18000000E-06  -1.69000720E-01
   -1.93334970E-01  -2.17362100E-01  +1.84939800E-01  +2.02251720E-01  +2.29396500E-01
   +2.42540000E-04  -8.98920000E-04  +2.60100000E-05  -3.99230000E-04  +1.09650000E-03
   +1.92800000E-05  +8.97420000E-04  +5.96720000E-04  +5.03900000E-04  -1.35230000E-03
   +8.28020000E-04  -3.12160000E-04  -2.38300000E-05  -1.02673000E-03  -7.34630000E-04
   +7.43000000E-06  +3.50620000E-04  +3.52300000E-05  +4.64153000E-03  +7.50020000E-04
   +8.69590000E-04  -4.56080000E-03  -3.62496000E-03  -7.79560000E-04  -5.46900000E-04
   +5.08630000E-04  -7.49400000E-05  -4.55771000E-03  -4.18109000E-03  +1.78379000E-03
   -1.40160000E-04  -1.18370000E-04  +1.32990000E-04  -9.85600000E-05  -1.14720000E-04
   -1.85300000E-05  -1.71750000E-04  +2.50200000E-05  +2.76000000E-06  -3.11724000E-03
   -2.61597000E-03  +1.31374000E-03  +1.55180000E-04  +1.01700000E-04  +2.59600000E-05
   -2.33400000E-05  +3.57400000E-05  -3.74800000E-05  +8.42300000E-05  -2.69000000E-05
   -1.28640000E-04  -3.37400000E-05  +7.62200000E-05  -8.02000000E-05  -4.28800000E-05
   -1.46620000E-04  -2.47700000E-05  +8.25000000E-05  +2.71100000E-05  +1.55090000E-04
   +2.25540000E-04  +4.51210000E-04  -2.56990000E-04  +4.51434000E-03  +4.91809000E-03
   -6.56518000E-03  -1.62530000E-04  -5.01470000E-04  -2.01900000E-04  -1.95420110E-01
   +1.61303700E-01  +1.01179400E-01  +1.51128600E-02  -2.28589600E-02  -1.73742000E-02
   +1.86855590E-01  -8.25200000E-04  +8.92470000E-04  -2.01900000E-05  +5.81820000E-04
   -1.22768000E-03  -5.00000000E-06  -1.15364000E-03  -6.76070000E-04  -5.21460000E-04
   +1.75853000E-03  -9.66500000E-04  +4.32630000E-04  -5.60320000E-04  -3.15400000E-05
   -3.49000000E-04  +6.15780000E-04  +5.00700000E-04  +1.71130000E-04  -5.56399000E-03
   -1.57181000E-03  -1.18018000E-03  +3.48537000E-03  +3.61151000E-03  +7.20830000E-04
   +1.32618000E-03  -7.91320000E-04  +1.92350000E-04  +4.96839000E-03  +5.01049000E-03
   -1.94121000E-03  +1.46060000E-04  +2.39900000E-04  -1.11890000E-04  +1.97500000E-05
   +2.51310000E-04  +1.83000000E-05  +5.28640000E-04  +8.11000000E-06  +1.64500000E-05
   -5.84980000E-04  +2.77221000E-03  +1.20300000E-03  -1.40090000E-04  -5.79600000E-05
   -8.00000000E-07  +5.06700000E-05  -3.99500000E-05  +3.50900000E-05  -8.98500000E-05
   +5.66600000E-05  +1.69340000E-04  +3.53100000E-05  -9.43800000E-05  +1.00140000E-04
   +5.64800000E-05  +1.77120000E-04  +4.69700000E-05  -2.17900000E-04  -2.74230000E-04
   +3.18680000E-04  -1.80840000E-04  -1.35190000E-04  +1.62300000E-04  -3.62288000E-03
   -7.99652000E-03  +7.72816000E-03  -4.34300000E-05  +1.36800000E-05  -2.06320000E-04
   +1.22236840E-01  -1.75362110E-01  -1.09492660E-01  +1.48426600E-02  -1.41226600E-02
   -9.31691000E-03  -1.23860910E-01  +1.87714210E-01  -2.21420000E-04  +4.60190000E-04
   +5.01300000E-05  +1.95780000E-04  -5.96520000E-04  -3.29800000E-05  -4.68300000E-04
   -3.82010000E-04  -2.64330000E-04  +6.12230000E-04  -5.44660000E-04  -1.63000000E-05
   -2.81150000E-04  +2.90590000E-04  +3.63500000E-04  -8.10400000E-05  -1.03530000E-04
   -2.47470000E-04  -2.29489000E-03  -6.82520000E-04  +1.54730000E-04  +1.57771000E-03
   +1.83982000E-03  -9.93300000E-05  +3.37090000E-04  -3.12190000E-04  +1.33200000E-05
   +2.73089000E-03  +2.34739000E-03  -1.33268000E-03  +1.35200000E-05  +4.97200000E-05
   -2.38310000E-04  +5.48500000E-05  +8.00500000E-05  +4.91000000E-05  +2.04940000E-04
   +4.10700000E-05  +7.70400000E-05  +2.43655000E-03  +2.08767000E-03  +1.29390000E-04
   -9.34400000E-05  -6.67000000E-05  -2.67000000E-06  +9.60000000E-06  -2.68000000E-05
   +2.62300000E-05  -6.65600000E-05  -4.08000000E-05  +7.05800000E-05  +7.34000000E-06
   -3.61600000E-05  +8.49600000E-05  +2.89000000E-05  +1.30260000E-04  +1.35500000E-05
   +2.82080000E-04  +2.89450000E-04  -4.98190000E-04  -1.34950000E-04  -4.37730000E-04
   +1.02420000E-04  -3.51054000E-03  -1.19716000E-03  +4.95754000E-03  -8.63200000E-05
   -2.40220000E-04  -7.74500000E-05  +6.78120400E-02  -1.02782310E-01  -9.14367700E-02
   +1.73502700E-02  -1.88983800E-02  -1.26004000E-02  -8.06472800E-02  +1.12180120E-01
   +1.11732880E-01  +1.47478000E-03  -4.56780000E-04  +1.80180000E-04  -3.93420000E-04
   +7.41600000E-04  -8.53100000E-05  +8.57230000E-04  +3.26470000E-04  +4.61810000E-04
   -1.75103000E-03  +6.47630000E-04  +2.48600000E-04  +6.89380000E-04  -6.99160000E-04
   +1.91490000E-04  -9.01470000E-04  -4.43070000E-04  -2.71530000E-04  +5.79780000E-03
   +2.22451000E-03  -6.17060000E-04  -1.43196800E-02  -3.59949200E-02  -1.23502200E-02
   -1.56961000E-03  +6.81970000E-04  -2.14870000E-04  -4.51811000E-03  -1.30120700E-02
   +9.98113000E-03  -3.88280000E-04  -8.43490000E-04  +7.92300000E-04  +1.69940000E-04
   -2.02090000E-04  +8.85000000E-06  -1.63600000E-05  +6.48400000E-05  +2.94000000E-06
   +4.02100000E-05  +6.13600000E-05  -1.94350000E-04  +6.11700000E-05  -2.34700000E-05
   -1.23000000E-05  -4.85300000E-05  -1.15300000E-05  -3.83400000E-05  +2.50290000E-04
   +1.32890000E-04  -1.94070000E-04  -8.65000000E-05  -1.88000000E-04  -1.25710000E-04
   -2.32400000E-05  -3.66130000E-04  -2.04230000E-04  +7.30740000E-04  +8.88420000E-04
   -7.69270000E-04  -7.61800000E-04  -1.59726000E-03  +1.36589000E-03  -1.14051200E-02
   +5.57140000E-03  -6.81820000E-03  +2.87800000E-04  -3.07200000E-04  +7.69850000E-04
   -3.54018000E-03  +1.61405200E-02  +8.77249000E-03  -2.47033000E-03  +2.22051000E-03
   +1.26367000E-03  -7.56840000E-03  -6.65650000E-03  -3.21318000E-03  +5.89597320E-01
   +2.18638000E-03  -2.18144000E-03  +2.41050000E-04  -1.35455000E-03  +2.82763000E-03
   -2.41400000E-05  +2.95429000E-03  +1.41464000E-03  +1.53171000E-03  -6.08114000E-03
   +2.46826000E-03  -1.20447000E-03  +5.77250000E-04  -2.37886000E-03  -5.17960000E-04
   -1.23033000E-03  -4.28150000E-04  -1.92250000E-04  +1.44520600E-02  +4.23872000E-03
   -8.85000000E-05  -3.80013700E-02  -3.35832100E-02  -1.48960400E-02  -2.95876000E-03
   +1.72663000E-03  -4.76370000E-04  -1.89107900E-02  -1.58300300E-02  +1.50822000E-02
   -4.85590000E-04  -1.28006000E-03  +7.26750000E-04  +5.31700000E-05  -4.80790000E-04
   +1.05800000E-05  -5.24360000E-04  +8.25600000E-05  +1.03300000E-05  -1.68163000E-03
   -2.74518000E-03  +1.68800000E-05  +3.08350000E-04  +1.21310000E-04  -1.53300000E-05
   -9.94100000E-05  +4.79600000E-05  -9.05400000E-05  +3.09070000E-04  +8.26000000E-05
   -2.38830000E-04  -1.53880000E-04  +3.04410000E-04  -2.89860000E-04  -1.13600000E-04
   -3.78850000E-04  +4.34000000E-06  -1.01085000E-03  -2.80760000E-04  +9.01790000E-04
   +7.68120000E-04  +6.17020000E-04  -7.08040000E-04  +1.01013700E-02  -2.81125000E-03
   -9.59809000E-03  -3.42401000E-03  -5.39588000E-03  -2.18770000E-04  +2.32095700E-02
   -1.62771800E-02  -1.43614000E-02  +6.29960000E-04  +9.03270000E-04  +1.07609000E-03
   -1.80917100E-02  +1.17424000E-03  +7.33405000E-03  +4.97050000E-02  +8.30950000E-02
   -1.09123000E-03  +9.36420000E-04  -3.72960000E-04  +9.72880000E-04  -1.21935000E-03
   -3.47800000E-05  -1.72148000E-03  -6.06130000E-04  -2.60440000E-04  +2.86943000E-03
   -1.54917000E-03  +2.96611000E-03  -1.40870000E-04  +1.09581000E-03  +6.78910000E-04
   +8.11340000E-04  +3.29830000E-04  +5.62000000E-05  -1.28251700E-02  -6.55237000E-03
   -2.74127300E-02  -2.75222900E-02  -3.16650400E-02  +6.92754000E-03  +1.42140000E-03
   -7.15350000E-04  +4.04190000E-04  +3.35440000E-02  +3.57988900E-02  -1.69475100E-02
   -4.37700000E-04  +1.29480000E-04  +2.75476000E-03  -8.33800000E-05  +1.85610000E-04
   -9.25300000E-05  +3.28000000E-05  -8.88700000E-05  -8.51100000E-05  -1.90580000E-04
   -1.44370000E-04  -6.14700000E-05  -4.28500000E-05  +8.03800000E-05  -1.15700000E-05
   +8.05900000E-05  +3.82000000E-06  -1.97900000E-05  +2.83800000E-05  +8.58190000E-04
   +4.94350000E-04  -5.39000000E-05  +2.54550000E-04  -2.24660000E-04  +1.00230000E-04
   -6.97760000E-04  +7.13590000E-04  -1.01155000E-03  -2.34166000E-03  +2.17588000E-03
   -1.30619000E-03  -4.13050000E-04  +1.33632000E-03  -1.88693100E-02  -1.59051000E-02
   +1.16820200E-02  -4.85480000E-04  -1.01193000E-03  +1.44170000E-04  +8.32583000E-03
   -9.98691000E-03  +1.43115000E-03  -7.43100000E-05  +1.11714000E-03  +1.29740000E-04
   -2.90434000E-03  +1.01999000E-03  -8.74018000E-03  -8.79405600E-02  +8.31769000E-03
   +5.48105400E-02  -1.71940000E-04  +1.21410000E-04  -3.98700000E-05  +6.64200000E-05
   -2.00450000E-04  +2.24000000E-06  -1.43180000E-04  -7.24300000E-05  -6.43500000E-05
   +2.21120000E-04  -1.44180000E-04  +4.28400000E-05  +1.09300000E-05  +2.49460000E-04
   +1.06540000E-04  +1.24650000E-04  +2.73000000E-06  +2.24300000E-05  -7.66900000E-04
   -3.39200000E-05  -1.26462000E-03  +8.73900000E-05  -2.02727000E-03  -6.22960000E-04
   +2.36180000E-04  -1.30260000E-04  +3.94300000E-05  +2.25107000E-03  +1.63310000E-03
   -4.70020000E-04  +2.79000000E-06  +1.14390000E-04  -1.17910000E-04  -4.23000000E-06
   +3.19500000E-05  +1.61000000E-06  +1.81600000E-05  -8.24000000E-06  +2.08000000E-06
   +1.40730000E-04  +2.10000000E-07  -1.07230000E-04  -1.77900000E-05  -3.92000000E-06
   -9.07000000E-06  +8.88000000E-06  -1.16000000E-06  +6.12000000E-06  -1.93800000E-05
   +5.21400000E-05  +3.06200000E-05  -8.62000000E-06  +2.08400000E-05  +3.72500000E-05
   +1.58900000E-05  +9.49700000E-05  +7.32100000E-05  -1.23260000E-04  -1.16570000E-04
   +1.25270000E-04  -1.83750000E-04  -2.47380000E-04  +2.64350000E-04  -2.38705000E-03
   -1.88319000E-03  +2.15224000E-03  +2.07870000E-04  +1.53460000E-04  +1.98340000E-04
   +7.91220000E-04  +5.16440000E-04  +2.08590000E-04  -3.14210000E-04  +2.63430000E-04
   +1.63550000E-04  -1.97790000E-03  -1.85396000E-03  -3.26600000E-04  -5.39051520E-01
   -3.81277500E-02  +8.12940000E-02  +5.44473500E-01  +9.87500000E-05  -4.70000000E-05
   +2.96000000E-05  -2.44300000E-05  +1.23240000E-04  -1.07400000E-05  +9.57000000E-05
   +4.83700000E-05  +3.29800000E-05  -3.27200000E-05  +6.80600000E-05  +4.14600000E-05
   +1.32630000E-04  -1.75720000E-04  -1.44930000E-04  -1.03470000E-04  +2.29200000E-05
   -4.24100000E-05  +1.08934000E-03  +6.61900000E-04  +1.15173000E-03  -1.83819000E-03
   -6.26898000E-03  -3.32610000E-03  -1.22930000E-04  +6.94900000E-05  -1.09000000E-05
   -1.95416000E-03  -3.01231000E-03  +1.91596000E-03  -8.82700000E-05  +3.63300000E-05
   +6.66800000E-05  -6.04000000E-06  -1.45600000E-05  -4.81000000E-06  -1.60700000E-05
   +0.00000000E+00  +5.00000000E-08  -1.51350000E-04  -4.90100000E-05  +1.34550000E-04
   +8.40000000E-06  +3.00000000E-07  +3.46000000E-06  -6.05000000E-06  +2.86000000E-06
   -6.40000000E-06  +4.95100000E-05  +1.71300000E-05  -9.63000000E-05  +2.25000000E-06
   -1.23390000E-04  -4.42000000E-06  +1.75400000E-05  -6.36700000E-05  -1.01270000E-04
   +3.38810000E-04  +2.28440000E-04  -1.69570000E-04  -8.75900000E-05  -2.08600000E-04
   +2.89550000E-04  -2.29556000E-03  +2.19426000E-03  -4.12863000E-03  +1.52270000E-04
   -4.66700000E-05  -4.28900000E-05  +1.24604000E-03  -4.88869000E-03  -2.22824000E-03
   +7.01710000E-04  -5.69450000E-04  -6.35310000E-04  +1.25628000E-03  +7.09434000E-03
   +2.45578000E-03  -3.26778900E-02  -1.59306800E-02  +2.47568000E-03  +3.86460200E-02
   +1.43718600E-02  -2.35960000E-04  -5.63600000E-05  -3.82000000E-05  -2.40900000E-05
   -9.59800000E-05  +1.10000000E-06  -1.43900000E-05  -1.55500000E-05  -3.13800000E-05
   -2.57600000E-05  -1.82230000E-04  -3.90100000E-05  -3.33660000E-04  +1.00910000E-04
   +6.35400000E-05  +3.07350000E-04  +5.07500000E-05  +1.20770000E-04  -1.62360000E-03
   -5.99040000E-04  -2.32334000E-03  -2.43785000E-03  -6.92465000E-03  -1.88602000E-03
   +2.45690000E-04  -1.04870000E-04  +1.10300000E-05  +2.90350000E-03  +4.92663000E-03
   -2.70275000E-03  -4.63700000E-05  +3.54200000E-05  -9.15600000E-05  -6.94000000E-06
   +3.27200000E-05  +1.19000000E-05  +2.36300000E-05  -7.11000000E-06  -2.10000000E-07
   -3.40000000E-06  +1.07730000E-04  -7.83200000E-05  -8.91000000E-06  +1.33000000E-06
   +1.76000000E-06  +7.49000000E-06  +9.80000000E-07  +8.16000000E-06  -4.00000000E-05
   +4.62200000E-05  +1.02780000E-04  -1.58900000E-05  +9.26800000E-05  +5.94600000E-05
   +1.98300000E-05  +9.47600000E-05  +1.65720000E-04  -3.21490000E-04  -3.67720000E-04
   +3.85750000E-04  +1.44620000E-04  +4.50980000E-04  -2.54040000E-04  +3.61297000E-03
   -5.07550000E-03  +4.95452000E-03  +5.00000000E-05  +2.34160000E-04  +3.36350000E-04
   +2.82000000E-06  -1.17478000E-03  -2.56900000E-04  +3.15210000E-04  -4.37680000E-04
   -1.46000000E-06  +9.45070000E-04  +1.45498000E-03  -6.70890000E-04  +8.28371100E-02
   +3.29257000E-03  -2.34778000E-02  -8.42239000E-02  -3.66841000E-03  +2.17375600E-02
   -7.66660000E-04  +8.35770000E-04  +5.40200000E-05  +4.31210000E-04  -7.90480000E-04
   +7.56500000E-05  -9.24120000E-04  -3.71760000E-04  -6.36170000E-04  +1.68221000E-03
   -3.49700000E-05  -9.44350000E-04  -2.36680000E-04  +5.59790000E-04  -1.97130000E-04
   +4.14000000E-05  +1.37720000E-04  -2.87400000E-05  -7.96850000E-04  -6.18600000E-05
   +2.20047300E-02  -8.50565800E-02  -4.83717700E-02  -3.71696400E-02  +9.04020000E-04
   -5.15590000E-04  +7.07200000E-05  -1.16983300E-02  -1.17343800E-02  +2.26416000E-03
   +8.85890000E-04  +4.32980000E-04  -1.46761000E-03  -7.56500000E-05  +1.49570000E-04
   +1.87800000E-05  +1.36350000E-04  -2.30300000E-05  +3.71300000E-05  +7.06850000E-04
   +9.13280000E-04  +6.95700000E-05  -1.14850000E-04  -6.32800000E-05  +3.63300000E-05
   +1.01500000E-05  -1.75900000E-05  +6.38500000E-05  -3.74280000E-04  -7.18050000E-04
   -1.06930000E-04  +2.17600000E-04  -1.28420000E-04  +1.72910000E-04  -1.64300000E-05
   +4.20370000E-04  -6.80840000E-04  +4.51300000E-04  +1.23079000E-03  -1.59478000E-03
   +7.80330000E-04  +6.22740000E-04  -1.47744000E-03  +1.02776900E-02  +1.12849800E-02
   -1.54029100E-02  -1.61589700E-02  -2.18867000E-02  -7.25950000E-03  -5.27387000E-03
   +3.26198000E-03  +2.17417000E-03  +1.74480000E-04  -4.66060000E-04  -3.34360000E-04
   +7.37820000E-03  -5.29800000E-03  -2.22814000E-03  -1.11430900E-02  +2.69951200E-02
   +2.72203000E-02  -3.48708000E-03  -4.43053000E-03  -2.05309000E-03  +1.12045760E-01
   -9.01800000E-04  +1.01050000E-03  +3.51400000E-05  +2.90270000E-04  -1.10759000E-03
   +6.28200000E-05  -1.01057000E-03  -5.68690000E-04  -1.10459000E-03  +3.16253000E-03
   -3.59080000E-04  -1.39090000E-03  -9.05700000E-05  +1.43722000E-03  -2.55750000E-04
   +1.98630000E-04  -1.90000000E-05  +1.94900000E-04  -1.45890000E-03  +1.58308000E-03
   +2.74472300E-02  -8.41388900E-02  -1.64973380E-01  -4.09352800E-02  +1.12704000E-03
   -7.04260000E-04  +8.37300000E-05  -1.45729500E-02  -1.47479100E-02  +3.16131000E-03
   +7.30930000E-04  +4.56490000E-04  -1.97827000E-03  -3.22600000E-05  +1.93670000E-04
   +2.22700000E-05  +1.87390000E-04  -3.44500000E-05  +1.35900000E-05  +9.57110000E-04
   +7.98900000E-04  -3.45440000E-04  -1.74240000E-04  -1.43050000E-04  +4.37500000E-05
   +1.01300000E-05  -2.67900000E-05  +8.43400000E-05  -1.30400000E-04  -7.86990000E-04
   -1.57510000E-04  +1.90340000E-04  -5.70060000E-04  +3.04550000E-04  +2.61600000E-05
   +5.66220000E-04  -6.52220000E-04  +8.64580000E-04  +1.63239000E-03  -2.14716000E-03
   +8.40860000E-04  +4.97520000E-04  -1.31191000E-03  +1.08572000E-02  +1.65224900E-02
   -1.84499900E-02  +1.65333000E-02  +1.60600100E-02  +5.36984000E-03  -4.52610000E-03
   +3.10484000E-03  +2.46217000E-03  +2.28580000E-04  -4.81820000E-04  -3.46430000E-04
   +5.74173000E-03  -6.16903000E-03  -3.23847000E-03  +1.40724600E-02  +8.78070000E-04
   +2.02935900E-02  +2.95010000E-03  +6.45924000E-03  +7.78704000E-03  +4.80673600E-02
   +1.39491460E-01  -3.41910000E-04  -2.51800000E-05  +3.77000000E-05  -2.47200000E-04
   -2.08760000E-04  +3.08100000E-05  -2.96500000E-05  -8.44900000E-05  -4.69770000E-04
   +1.48384000E-03  -3.13640000E-04  -1.50168000E-03  -8.02900000E-05  +8.14530000E-04
   -1.92250000E-04  +2.62900000E-04  -5.95900000E-05  +1.11350000E-04  +4.25452000E-03
   +5.66632000E-03  +1.37823000E-02  -1.89551900E-02  -5.47245000E-03  -4.54422400E-02
   +3.01850000E-04  -1.85940000E-04  -2.51100000E-05  -7.07748000E-03  -6.78098000E-03
   +1.53669000E-03  +1.11667000E-03  +1.27778000E-03  -2.25232000E-03  +6.94000000E-06
   +5.48700000E-05  +3.30600000E-05  +5.60500000E-05  +1.24800000E-05  +2.98500000E-05
   +4.96310000E-04  +9.60900000E-05  -2.06740000E-04  -8.29600000E-05  -8.48200000E-05
   +4.02000000E-06  -1.13800000E-05  +7.40000000E-07  +2.26600000E-05  -3.24450000E-04
   -6.66430000E-04  -3.77370000E-04  +1.13540000E-04  +2.99000000E-05  +1.96700000E-04
   -2.52640000E-04  +6.24940000E-04  -7.24890000E-04  +1.53310000E-04  +5.36850000E-04
   -4.42810000E-04  +4.45850000E-04  +1.87190000E-04  -4.38120000E-04  +3.20467000E-03
   +4.78832000E-03  -1.68369700E-02  -1.13968400E-02  -1.41529400E-02  -4.31256000E-03
   -2.31132000E-03  +1.64843000E-03  +1.12470000E-03  +9.89200000E-05  -2.24540000E-04
   -1.75070000E-04  +3.14799000E-03  -2.82481000E-03  -1.56741000E-03  +6.17286000E-03
   +4.37456000E-03  -8.96393000E-03  +2.47580000E-03  +6.02387000E-03  +3.89151000E-03
   +1.73192800E-02  +4.94769000E-03  +6.31278700E-02
end_hess

