# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -577.03271040    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +5.03763033E+00  -3.18365189E-01  -5.47931875E-04
   006   +4.19498051E+00  +2.14933168E+00  -2.90108789E-01
   006   +1.64340848E+00  +2.67579318E+00  -1.05911435E-01
   006   -1.12555930E-01  +7.81147786E-01  +4.11981014E-01
   006   +7.69309733E-01  -1.69149995E+00  +6.98120769E-01
   006   +3.30757385E+00  -2.24266663E+00  +4.80173166E-01
   006   -2.83138571E+00  +1.33426659E+00  +6.85625189E-01
   008   -3.98503384E+00  -2.70003964E-01  -2.73054110E+00
   008   +7.54762943E+00  -7.49240346E-01  -2.14532500E-01
   006   -4.24551624E+00  -9.05997590E-02  +2.49632776E+00
   006   -3.79982402E+00  +3.87045975E+00  -8.80128825E-02
   001   +7.89498609E+00  -2.50871842E+00  +2.26419906E-02
   001   +3.95208560E+00  -4.17694356E+00  +6.74394117E-01
   001   -5.66713263E-01  -3.20878435E+00  +1.01496055E+00
   001   +1.02831538E+00  +4.61027526E+00  -3.36774648E-01
   001   +5.55342302E+00  +3.62864359E+00  -6.62535580E-01
   001   -2.99471721E+00  +4.52900715E+00  -1.85779325E+00
   001   -5.84437820E+00  +3.80564508E+00  -2.71236453E-01
   001   -3.33722842E+00  +5.21608414E+00  +1.41259911E+00
   001   -3.11422326E+00  -8.31960015E-01  +4.03985906E+00
   001   -5.96642168E+00  +8.30487924E-01  +3.13204959E+00
   001   -4.87347097E+00  -2.07035894E+00  +1.35467345E+00
   001   -2.47219315E+00  -5.75386509E-01  -3.67536542E+00
   008   -5.13733752E+00  -3.99820583E+00  -4.22139847E-01
   001   -6.85955567E+00  -4.53877269E+00  -4.99813676E-01
   001   -4.60177517E+00  -2.09045653E+00  -1.95982989E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -3.00000000E-08  +7.90000000E-07  -4.20000000E-07
   -2.80000000E-07  +6.00000000E-07  -8.80000000E-07
   -3.00000000E-07  +2.70000000E-07  -9.00000000E-07
   -7.00000000E-08  +2.40000000E-07  -5.00000000E-07
   +2.00000000E-07  +3.30000000E-07  +2.10000000E-07
   +3.60000000E-07  +5.90000000E-07  +1.30000000E-07
   +5.60000000E-07  +8.00000000E-07  +8.20000000E-07
   +8.00000000E-08  -6.30000000E-07  -4.00000000E-08
   +1.10000000E-07  +1.00000000E-06  -7.30000000E-07
   +2.30000000E-07  +8.90000000E-07  +8.30000000E-07
   -8.10000000E-07  -5.80000000E-07  -9.90000000E-07
   +3.70000000E-07  +1.25000000E-06  -1.40000000E-07
   +6.50000000E-07  +8.20000000E-07  +5.30000000E-07
   +1.60000000E-07  +1.30000000E-07  +8.00000000E-07
   -6.60000000E-07  +1.40000000E-07  -1.20000000E-06
   -5.50000000E-07  +7.10000000E-07  -1.41000000E-06
   -8.80000000E-07  -7.50000000E-07  -7.70000000E-07
   -5.10000000E-07  -7.70000000E-07  -3.20000000E-07
   -5.60000000E-07  +0.00000000E+00  -9.50000000E-07
   +6.20000000E-07  +3.60000000E-07  +4.20000000E-07
   +1.70000000E-07  -2.50000000E-07  +4.40000000E-07
   +0.00000000E+00  -1.74000000E-06  +0.00000000E+00
   -1.40000000E-07  -1.14000000E-06  +3.90000000E-07
   +8.00000000E-07  -4.70000000E-07  +1.42000000E-06
   +7.50000000E-07  -5.90000000E-07  +1.90000000E-06
   -2.40000000E-07  -2.00000000E-06  +1.37000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.04855590E-01  -2.23005200E-02  +7.14783840E-01  -5.58253000E-02  -8.09244100E-02
   +1.86574260E-01  -1.36549140E-01  +2.33947000E-03  +6.66689000E-03  +7.39849570E-01
   +8.02342600E-02  -3.12309550E-01  +2.82804900E-02  +2.40124600E-02  +7.03346310E-01
   -5.27278000E-03  +3.63065700E-02  -7.67474300E-02  -6.86859900E-02  -9.06835000E-02
   +1.50064010E-01  -5.63707000E-03  +9.88506800E-02  -1.43143900E-02  -3.48273720E-01
   +9.14821000E-03  +2.84669500E-02  +6.91446880E-01  +3.97538000E-02  +1.74626200E-02
   -6.38417000E-03  +7.88179500E-02  -1.39896610E-01  +3.16673000E-03  -3.89177100E-02
   +7.24454700E-01  -4.58343000E-03  -1.39517800E-02  +3.97676000E-03  +1.64976900E-02
   +1.25496700E-02  -6.48405200E-02  -5.15919400E-02  -8.75313300E-02  +1.65611390E-01
   +8.23191000E-03  -1.61309600E-02  +9.68120000E-04  -4.82809800E-02  -6.72568000E-03
   +8.71132000E-03  -2.04446610E-01  -1.19502780E-01  +2.90347500E-02  +6.46890210E-01
   -1.80111000E-02  -7.79780500E-02  +1.26126900E-02  -5.77380200E-02  +5.18469400E-02
   +7.14050000E-04  -6.21834000E-02  -2.31826410E-01  +3.57113400E-02  +3.05453000E-03
   +6.62159650E-01  +8.66940000E-04  +1.57547500E-02  -9.00713000E-03  +1.74518700E-02
   -9.29837000E-03  +7.79060000E-03  +2.08108000E-02  +4.22895100E-02  -7.57500300E-02
   -6.21386300E-02  -8.84318600E-02  +1.92050110E-01  -4.99401300E-02  -6.98678000E-02
   +1.62677900E-02  -3.95826000E-02  +3.21245700E-02  -1.39956000E-03  +5.98799800E-02
   -8.69230000E-04  -4.38806000E-03  -1.36987210E-01  +2.11139900E-02  +7.26982000E-03
   +7.31098520E-01  -1.11085700E-02  +6.74397800E-02  -8.05084000E-03  +3.76638300E-02
   -3.37240800E-02  +1.05584000E-03  -4.96849200E-02  -5.47005400E-02  +1.46280400E-02
   +8.04074000E-02  -2.90841230E-01  +2.53232100E-02  +2.86290100E-02  +6.90619610E-01
   +6.61657000E-03  -1.49400000E-03  +1.57449000E-03  -1.20228000E-03  +4.30450000E-04
   -2.93474000E-03  +1.04221000E-03  +9.99263000E-03  +7.14584000E-03  +5.57720000E-04
   +2.88859100E-02  -7.68765600E-02  -6.67777200E-02  -7.71832100E-02  +1.70659550E-01
   -1.93060900E-01  -4.00483100E-02  +2.00608400E-02  +6.05974700E-02  -4.47776700E-02
   +1.59180000E-03  -6.36719800E-02  -2.24733000E-02  +9.74219000E-03  -1.21955500E-02
   +8.57713700E-02  -1.25779900E-02  -3.51713280E-01  +1.44967800E-02  +3.24949500E-02
   +7.04429100E-01  -1.23226760E-01  -2.48394970E-01  +4.03136000E-02  -1.21769000E-03
   -4.30564600E-02  +8.20960000E-03  -1.73221200E-02  -8.59185000E-03  +2.27219000E-03
   +3.22074300E-02  +1.28265400E-02  -5.11096000E-03  +8.40264500E-02  -1.41792090E-01
   +2.15189000E-03  -4.42501000E-02  +7.21758280E-01  +3.19775800E-02  +2.97948400E-02
   -7.83194300E-02  -6.10631000E-03  +1.33860900E-02  +6.96228000E-03  +9.84136000E-03
   +3.38007000E-03  -4.97271000E-03  -2.28483000E-03  -9.16611000E-03  +1.12990700E-02
   +2.13966900E-02  +9.42971000E-03  -6.59333600E-02  -6.02881700E-02  -7.93306200E-02
   +1.45555810E-01  -1.00980600E-02  +9.17420000E-04  +8.30760000E-04  +5.99138000E-03
   -9.67910000E-03  -2.93500000E-05  -3.58204200E-02  -5.43628000E-03  +1.08477700E-02
   -2.06278840E-01  +2.26097000E-02  +1.57937800E-02  -2.28572200E-02  +2.11897900E-02
   -5.26950000E-03  +1.06200600E-02  +4.62016000E-03  -6.03030000E-04  +5.27704760E-01
   -1.03370000E-03  -3.67964000E-03  +5.35770000E-04  -4.49746000E-03  -3.47494000E-03
   +1.50646000E-03  -2.14897100E-02  +1.21552600E-02  +5.06530000E-04  +3.36907000E-02
   -1.10290360E-01  +1.01934000E-02  +3.40417900E-02  -9.57240000E-04  -4.05289000E-03
   +3.40120000E-03  -5.89518000E-03  +5.11140000E-04  -4.17429600E-02  +5.02160330E-01
   -4.67900000E-05  -1.34630000E-04  -1.73890000E-04  +1.47477000E-03  +2.55470000E-03
   +5.78143000E-03  +8.69604000E-03  -2.76246000E-03  +2.92670000E-04  +2.75086400E-02
   +9.59644000E-03  -7.05399000E-02  -5.46697000E-03  -1.15334000E-03  +8.14910000E-04
   +8.61890000E-04  +2.37183000E-03  +4.85227000E-03  -1.08664510E-01  -1.67349800E-01
   +2.74932880E-01  +2.30500000E-03  -2.12272000E-03  +2.48170000E-04  -2.29951000E-03
   +2.51097000E-03  +7.18220000E-04  +3.50657000E-03  +2.52132000E-03  -2.87122000E-03
   -1.39489400E-02  -6.57830000E-03  -1.16948100E-02  +2.63060000E-04  -2.39587000E-03
   -1.29371000E-03  +6.11600000E-05  -8.91900000E-04  +2.75300000E-04  -1.80141600E-02
   +2.77773000E-03  +2.08004800E-02  +4.50443600E-01  +1.36714000E-03  +1.74300000E-05
   -6.27800000E-05  -9.64200000E-05  +9.97320000E-04  +2.50830000E-04  +6.23670000E-04
   +8.00550000E-04  -1.58601000E-03  -7.73657000E-03  -7.19590000E-04  -3.78890000E-03
   +1.86548000E-03  -2.44260000E-03  +7.49850000E-04  -1.52882000E-03  -3.84200000E-05
   +8.99520000E-04  +2.31546000E-03  -1.04140500E-02  +4.63613900E-02  -3.73366500E-02
   +2.30555460E-01  +1.97666000E-03  -1.82089000E-03  -9.61100000E-05  -2.73370000E-03
   +2.22525000E-03  +7.77800000E-04  +3.36103000E-03  +2.55774000E-03  -2.66181000E-03
   -1.62525900E-02  -5.16129000E-03  -6.80922000E-03  +9.15250000E-04  -1.62475000E-03
   +3.26240000E-04  -6.82520000E-04  -1.00562000E-03  +6.29720000E-04  +1.26755900E-02
   +1.83268100E-02  +3.54290700E-02  -2.62185780E-01  -2.87385100E-02  +2.27731680E-01
   -3.15604080E-01  +6.40391000E-03  +2.91626300E-02  -3.12510700E-02  +2.21941100E-02
   +8.57190000E-04  +5.92677000E-03  -1.02844000E-03  -8.48280000E-04  -1.10472500E-02
   +4.56355000E-03  +1.24362000E-03  +6.01306000E-03  -7.00221000E-03  +1.88990000E-03
   -5.44879200E-02  +5.62385000E-03  +6.54047000E-03  +1.12735900E-02  +3.36160000E-04
   -4.36300000E-05  -3.08467000E-03  -1.43411000E-03  -2.67511000E-03  +4.50768350E-01
   +5.79652200E-02  -1.15819150E-01  +4.28374000E-03  +5.98017300E-02  -1.12284300E-02
   -3.64067000E-03  -9.33505000E-03  -8.01729000E-03  +3.32535000E-03  +3.92913000E-03
   +5.81633000E-03  -1.93759000E-03  +3.29200000E-03  -8.55995000E-03  +1.70436000E-03
   -3.25871100E-02  +1.15329300E-02  +3.67910000E-03  -2.87325000E-03  +3.78850000E-04
   -1.18690000E-04  +9.52290000E-04  +4.83360000E-04  +7.79230000E-04  -1.33828970E-01
   +6.33037350E-01  +2.11202700E-02  +9.99178000E-03  -4.97332900E-02  -4.99540000E-03
   +5.32650000E-04  +8.24186000E-03  +1.34736000E-03  +2.25826000E-03  +4.71044000E-03
   +3.08800000E-04  -1.73727000E-03  -9.63250000E-04  -1.36860000E-04  +3.15719000E-03
   +6.87929000E-03  +1.21328100E-02  -7.89560000E-04  +9.76422000E-03  -7.98870000E-04
   -1.26460000E-04  -7.76360000E-04  +1.25250000E-04  -3.18200000E-05  +2.62070000E-04
   -2.61248900E-02  -7.96295500E-02  +4.41393000E-02  +2.72265000E-03  -7.73430000E-04
   -4.02400000E-04  -1.88978000E-03  +8.76840000E-04  -6.11740000E-04  -1.26554000E-03
   +4.14293000E-03  +4.64120000E-04  -2.38002800E-02  -1.56006600E-02  +2.19716300E-02
   +3.49410000E-04  -2.82541000E-03  +2.34124000E-03  -1.96508000E-03  -1.41777000E-03
   -6.33850000E-04  -1.42206100E-01  -4.58890100E-02  +5.10186500E-02  +8.23880000E-03
   +1.51714500E-02  +9.10132000E-03  -3.39070000E-03  +1.03182000E-03  +4.47250000E-04
   +5.59512620E-01  +3.62222000E-03  -9.40310000E-04  -5.00860000E-04  -1.49015000E-03
   +3.89407000E-03  -3.23890000E-04  +6.54084000E-03  +1.07422000E-03  -1.18862000E-03
   -6.49149000E-03  +1.53386100E-02  +1.36306000E-03  +2.75834000E-03  -5.24910000E-03
   +1.72121000E-03  -2.89337000E-03  -7.82310000E-04  -2.80940000E-04  -1.97893600E-02
   -1.25617180E-01  +2.31075400E-02  +8.29863000E-03  +2.73988000E-02  +1.68956900E-02
   -4.22974000E-03  +1.32348000E-03  +4.31330000E-04  -1.33091210E-01  +3.47475860E-01
   +5.05670000E-04  +1.01492000E-03  -2.88900000E-04  +6.73350000E-04  +6.64000000E-06
   -4.56880000E-04  -1.05754000E-03  -1.16494000E-03  +1.27540000E-03  +9.13980000E-03
   +4.62110000E-03  +6.89650000E-04  +5.11220000E-04  +2.76480000E-04  -9.84720000E-04
   -1.40783000E-03  -3.17620000E-04  -1.90880000E-04  +8.73647600E-02  +9.81189200E-02
   -1.75489260E-01  +3.77532000E-03  -1.08324000E-03  -1.86776000E-02  -4.88000000E-04
   +7.30800000E-05  +2.39830000E-04  -5.14808600E-02  -1.11032880E-01  +5.32785710E-01
   +2.76710000E-04  +1.59900000E-05  +9.93000000E-06  +2.83450000E-04  +6.38210000E-04
   -2.10700000E-05  -1.55277000E-03  +6.88580000E-04  -5.00500000E-04  -7.96103000E-03
   +3.15286100E-02  -5.46395000E-03  -5.78520000E-03  -8.10520000E-04  +1.19254000E-03
   -4.91600000E-05  +1.71248000E-03  -3.55170000E-04  -1.06241930E-01  +4.61288900E-02
   -7.84713000E-03  -6.51120000E-04  -6.98043000E-03  -2.55904000E-03  -4.23930000E-04
   +8.51500000E-05  +5.11700000E-05  +9.96858000E-03  -1.04178200E-02  +4.97242000E-03
   +5.89960860E-01  -4.12030000E-04  -3.63150000E-04  +1.45300000E-05  -2.89370000E-04
   -4.47480000E-04  -3.27840000E-04  -1.02535000E-03  -6.19590000E-04  -1.02000000E-06
   +9.05122000E-03  -2.40563000E-03  +2.28347000E-03  -1.82519000E-03  +1.76176000E-03
   +1.16994000E-03  +5.86820000E-04  +6.31720000E-04  -4.12190000E-04  +4.32684600E-02
   -1.87802930E-01  +5.17096500E-02  -3.76990000E-04  -1.51198700E-02  -8.75726000E-03
   +3.71770000E-04  -4.53900000E-05  +4.02500000E-05  +6.75176000E-03  -1.54913300E-02
   +1.13814900E-02  +2.51004200E-02  +4.94154430E-01  -4.50350000E-04  -2.66100000E-04
   +2.32200000E-04  +6.41700000E-05  -7.50700000E-05  -4.29100000E-04  -2.66300000E-04
   -8.47020000E-04  -1.01177000E-03  +2.30589000E-03  -1.05351000E-03  +5.14015000E-03
   +4.47100000E-04  +5.53350000E-04  +1.76253000E-03  +6.42240000E-04  +3.27960000E-04
   -5.86870000E-04  -1.33364100E-02  +5.14062300E-02  -8.17663200E-02  +4.12230000E-04
   -1.65403700E-02  -9.94852000E-03  +4.48750000E-04  -1.98100000E-05  +1.96300000E-05
   -1.69160000E-04  +2.72776200E-02  -2.27235000E-03  -1.82242500E-02  -1.52705200E-02
   +5.80891160E-01  -1.57037000E-02  +5.06572600E-02  -6.47767000E-03  -7.21102000E-03
   -7.31780000E-04  +1.20083000E-03  +9.71180000E-04  +1.79934000E-03  -1.35060000E-04
   +4.15090000E-04  -8.95090000E-04  +8.23700000E-05  -6.48290000E-04  +4.86380000E-04
   -8.10400000E-05  +2.70173000E-03  +1.56044000E-03  -6.48550000E-04  -6.08080000E-04
   -1.75010000E-04  +3.56400000E-05  +2.02080000E-04  +3.53200000E-05  +1.47040000E-04
   -5.72586300E-02  +5.26721100E-02  -2.37394000E-03  +1.94990000E-04  +1.97970000E-04
   +4.48000000E-06  +9.61200000E-05  -1.91100000E-05  -2.06400000E-05  +7.79001100E-02
   +2.35678000E-03  -1.09457800E-02  +9.91220000E-04  +6.04670000E-04  +2.84145000E-03
   -1.12270000E-04  +3.45580000E-04  -6.26480000E-04  +2.25040000E-04  -1.09594000E-03
   +6.56960000E-04  +1.13370000E-04  +4.58110000E-04  -1.45402000E-03  +1.53130000E-04
   -5.76748000E-03  +4.73388000E-03  -2.20280000E-04  +1.24342000E-03  +6.10000000E-07
   +1.30000000E-07  -3.29200000E-04  -1.90400000E-04  -2.76730000E-04  +1.05164050E-01
   -5.12887680E-01  +6.79118900E-02  -3.72190000E-04  -5.02080000E-04  -6.93900000E-05
   -2.04600000E-05  +5.04000000E-05  +5.27300000E-05  -1.03168950E-01  +5.18272170E-01
   +1.12731000E-03  -4.45937000E-03  -2.11407000E-03  +1.03104000E-03  +3.79400000E-05
   +2.49965000E-03  -2.79200000E-05  +1.72540000E-04  +1.74098000E-03  +1.50050000E-04
   -3.25700000E-05  +5.90500000E-05  -1.03770000E-04  +8.39100000E-05  -6.60290000E-04
   +4.99200000E-04  -1.02635000E-03  -1.14285000E-03  -7.66000000E-05  +4.10700000E-05
   +4.10200000E-05  +5.82000000E-06  -7.65000000E-06  -1.17680000E-04  -1.06538900E-02
   +7.38113200E-02  -1.51168000E-02  +2.70200000E-05  +2.86800000E-05  -3.56800000E-05
   -2.26100000E-05  +9.30000000E-06  +4.67000000E-06  +8.03963000E-03  -6.88858600E-02
   +1.50889500E-02  +7.95266000E-03  -1.92512400E-02  +2.19795000E-03  -2.19028000E-03
   -3.39527000E-03  +1.39756000E-03  -1.45782000E-03  -4.82340000E-04  +1.31140000E-04
   -5.22931000E-03  +4.08880000E-04  +1.68575000E-03  -4.89017000E-03  +3.10353000E-02
   -3.48463000E-03  -8.55121800E-02  +7.97222000E-02  -5.28795000E-03  +4.73670000E-04
   +1.73596000E-03  -3.17890000E-04  -8.03400000E-05  -1.61360000E-04  -5.56100000E-05
   +3.39572000E-03  -9.85130000E-04  -6.17520000E-04  -1.73680000E-04  -3.29160000E-04
   -5.44400000E-05  -5.10450000E-04  -1.41210000E-04  -1.03900000E-05  -7.72530000E-04
   +8.15330000E-04  -4.96000000E-06  +8.73712800E-02  +1.35881600E-02  -1.78006300E-02
   +1.47474000E-03  -3.91789000E-03  -1.66738000E-03  +1.45297000E-03  -9.95400000E-04
   +4.33320000E-04  -6.91200000E-05  +9.25490000E-04  +2.33511000E-03  +5.37250000E-04
   +3.37330000E-04  -2.58922000E-03  +7.23610000E-04  +8.00814700E-02  -3.08468640E-01
   +2.88535400E-02  -3.52210000E-04  -2.66640000E-04  +1.76950000E-04  +1.09540000E-04
   +4.67200000E-05  +1.07660000E-04  -2.28190000E-04  +2.84800000E-03  -8.68630000E-04
   +1.35020000E-04  +1.38500000E-04  -2.10700000E-05  +1.17220000E-04  +3.88700000E-05
   -3.67600000E-05  -2.18438000E-03  -7.77020000E-04  +4.01540000E-04  -8.82191600E-02
   +3.26231540E-01  -2.09908000E-03  +5.69062000E-03  +3.40591000E-03  +1.55559000E-03
   +1.40930000E-03  +5.02162000E-03  +9.34100000E-05  -1.73100000E-04  -9.01360000E-04
   +9.81280000E-04  +1.07123000E-03  +7.47204000E-03  +1.10209000E-03  -3.27044000E-03
   +3.27039000E-03  -5.66519000E-03  +2.84854700E-02  -3.76134800E-02  +3.55200000E-04
   +4.68000000E-05  +6.54830000E-04  -2.01600000E-05  -6.77100000E-05  -1.70740000E-04
   -9.41130000E-04  -8.06550000E-04  -3.51031000E-03  +4.50000000E-05  +5.97000000E-06
   -9.23100000E-05  +1.42500000E-05  -9.24600000E-05  -1.58010000E-04  +4.29220000E-04
   +6.61000000E-05  +5.07560000E-04  +4.88748000E-03  -3.18665900E-02  +2.75919000E-02
   -3.89006000E-03  +2.54779000E-03  +8.85740000E-04  -4.39090000E-04  +8.64120000E-04
   -2.02100000E-04  -1.01650000E-04  +3.05520000E-03  -1.43500000E-05  +1.10927700E-02
   +8.49593000E-03  -1.67584000E-03  -1.80150210E-01  -1.37362300E-01  +3.09835200E-02
   -1.44293000E-02  -2.27514200E-02  +5.07182000E-03  +1.35378000E-03  +8.64290000E-04
   -9.33020000E-04  -6.56890000E-04  -6.80690000E-04  +3.54310000E-04  -1.32176000E-03
   -1.01319000E-03  +2.42150000E-04  -1.59572000E-03  -6.17570000E-04  +7.20170000E-04
   +7.24200000E-05  -8.41800000E-05  +4.58200000E-05  +1.35160000E-04  -2.22490000E-04
   +2.51400000E-05  +9.23490000E-04  +4.46800000E-05  -5.25580000E-04  +1.89509480E-01
   +2.57595000E-03  +5.47850000E-04  +5.39200000E-04  +8.79260000E-04  +7.92500000E-05
   -2.68590000E-04  +3.02403000E-03  -4.44081000E-03  +1.10929000E-03  -2.02960700E-02
   -1.55184800E-02  +4.67519000E-03  -1.35628740E-01  -2.18693170E-01  +3.61910100E-02
   +7.24129000E-03  +1.00405300E-02  -1.54893000E-03  -1.44078000E-03  -1.84680000E-04
   -1.14560000E-04  -3.22510000E-04  +3.25000000E-06  -1.22060000E-04  +5.34820000E-04
   +4.38240000E-04  -1.74960000E-04  +4.47000000E-06  -9.72300000E-05  -1.22720000E-04
   +4.62000000E-06  +1.11410000E-04  +4.51000000E-05  -7.87100000E-05  +4.97500000E-05
   +9.31000000E-06  -2.67240000E-04  +6.86860000E-04  -5.63440000E-04  +1.43267820E-01
   +2.27429140E-01  +1.20976000E-03  +6.29870000E-04  +8.20343000E-03  -2.22820000E-04
   -4.07500000E-04  -1.18349000E-03  +1.96250000E-04  +1.43290000E-03  +5.88023000E-03
   +5.64190000E-04  +3.28384000E-03  +4.32584000E-03  +3.00785500E-02  +3.35156600E-02
   -5.01095200E-02  +1.67452000E-03  +2.41120000E-03  +4.92762000E-03  +8.36640000E-04
   +5.01920000E-04  -2.65420000E-03  +4.99300000E-05  -1.13911000E-03  -4.68620000E-04
   +1.42080000E-04  +5.12600000E-05  -4.67720000E-04  +1.18703000E-03  -2.53050000E-04
   +4.71490000E-04  +5.25000000E-06  +2.56500000E-05  -6.33000000E-05  -1.43700000E-05
   +3.68900000E-05  +2.49200000E-05  -6.45340000E-04  -7.62920000E-04  -4.59065000E-03
   -3.54476400E-02  -3.96395100E-02  +3.78936600E-02  -4.92095000E-03  +2.96040000E-04
   +1.32254000E-03  -5.02635000E-03  +3.03817900E-02  -3.60894000E-03  -8.49145400E-02
   +8.01395800E-02  -6.78362000E-03  +1.15234300E-02  -1.83877500E-02  +2.02651000E-03
   -2.55000000E-03  -3.58445000E-03  +1.50018000E-03  -1.16405000E-03  -4.24940000E-04
   +7.92200000E-05  +8.56730000E-04  -5.14350000E-04  -5.20430000E-04  -3.77400000E-05
   +3.43030000E-04  +1.16600000E-05  -4.23170000E-04  +1.68943000E-03  -2.16020000E-04
   +2.07730000E-04  +4.10520000E-04  -1.64000000E-05  -2.06417000E-03  -2.33550000E-04
   +2.82090000E-04  -4.22980000E-04  +1.23980000E-04  +6.44000000E-06  +4.57800000E-05
   +3.12300000E-05  -9.37600000E-05  +5.45990000E-04  -1.00803000E-03  +1.27120000E-04
   +9.04110100E-02  +4.17570000E-04  +2.06731000E-03  +9.59680000E-04  -3.41960000E-04
   -2.14086000E-03  +9.55750000E-04  +7.98980600E-02  -3.14825630E-01  +3.38349100E-02
   +9.10680000E-03  -1.64093300E-02  +2.18665000E-03  -3.88070000E-03  -1.81358000E-03
   +1.77179000E-03  -5.22250000E-04  +6.06310000E-04  -2.31890000E-04  +1.70751000E-03
   -8.98060000E-04  -2.60040000E-04  -1.61780000E-04  +2.59400000E-04  -3.13200000E-04
   +2.65330000E-04  -3.86180000E-04  +3.42700000E-05  -2.92700000E-05  +3.04920000E-04
   +2.60300000E-05  +1.20429000E-03  +3.56400000E-04  +5.95670000E-04  +1.12700000E-05
   +3.22700000E-05  -4.20400000E-05  +7.55000000E-05  -8.00300000E-05  -1.15890000E-04
   +6.45970000E-04  -8.21660000E-04  +1.12890000E-04  -8.89890000E-02  +3.32361590E-01
   +1.29722000E-03  +9.51750000E-04  +8.08869000E-03  +1.12425000E-03  -2.00523000E-03
   +4.92112000E-03  -7.83408000E-03  +3.29655700E-02  -4.41952300E-02  -9.50630000E-04
   +5.31346000E-03  +3.32614000E-03  +1.69066000E-03  +1.54572000E-03  +5.81225000E-03
   +1.61000000E-05  -3.81220000E-04  -1.11912000E-03  -1.00573000E-03  +3.62170000E-04
   -3.29279000E-03  -1.96930000E-04  -1.59340000E-04  -3.96760000E-04  -5.53600000E-05
   -9.31600000E-05  -5.08300000E-05  +2.92010000E-04  +1.18410000E-04  -8.54000000E-06
   -3.23220000E-04  +3.08240000E-04  +1.05719000E-03  -3.24000000E-06  -6.13600000E-05
   -2.68320000E-04  -1.00370000E-04  -9.21900000E-05  -6.86870000E-04  -1.17270000E-04
   +2.92820000E-04  +2.22840000E-04  +7.00546000E-03  -3.78960500E-02  +3.19608400E-02
   +9.39483000E-03  +8.57961000E-03  -1.77143000E-03  -1.82978960E-01  -1.37923200E-01
   +3.70025500E-02  -1.43989200E-02  -2.36604500E-02  +5.47374000E-03  -4.25247000E-03
   +2.82188000E-03  +5.01580000E-04  -4.05570000E-04  +8.35170000E-04  -2.24570000E-04
   -9.75900000E-05  +2.52404000E-03  +2.43770000E-04  -6.76100000E-05  -1.23473000E-03
   +4.90580000E-04  -1.16200000E-04  -4.72200000E-05  -1.69530000E-04  +9.91220000E-04
   -6.87640000E-04  -4.00660000E-04  -4.28190000E-04  +1.08590000E-04  +1.60600000E-05
   +1.13000000E-06  -5.64600000E-05  -1.04000000E-05  +4.71600000E-05  -1.64020000E-04
   -3.96200000E-05  +4.91290000E-04  +5.07340000E-04  -1.42980000E-04  -5.50000000E-06
   -9.68100000E-05  -6.06800000E-05  +8.77140000E-04  +1.21280000E-04  -5.76460000E-04
   +1.91000670E-01  -2.36633800E-02  -1.62155500E-02  +5.80496000E-03  -1.36324960E-01
   -2.12972860E-01  +4.17950000E-02  +6.56146000E-03  +9.46008000E-03  -1.80192000E-03
   +2.38424000E-03  +1.30425000E-03  +7.77590000E-04  +1.33612000E-03  -4.26330000E-04
   -2.57370000E-04  +3.06194000E-03  -4.44621000E-03  +1.20429000E-03  +2.98980000E-04
   +4.40100000E-04  -1.09300000E-05  +2.73500000E-05  +7.21000000E-06  +2.60700000E-05
   -4.03330000E-04  +2.07880000E-03  -7.90150000E-04  +3.67300000E-05  -7.34500000E-05
   -6.79800000E-05  -4.84700000E-05  +2.78800000E-05  +2.75000000E-06  -5.20500000E-05
   +4.06930000E-04  -1.34870000E-04  -9.57110000E-04  -9.31390000E-04  +2.25050000E-04
   -6.17900000E-05  +1.64600000E-05  -9.48500000E-05  -4.56290000E-04  +7.10180000E-04
   -8.00960000E-04  +1.48276290E-01  +2.20668880E-01  +3.14641000E-03  +2.43345000E-03
   +4.38453000E-03  +3.67944800E-02  +4.19364200E-02  -4.56891300E-02  +7.50890000E-04
   +1.20782000E-03  +2.13380000E-03  +1.27911000E-03  +4.53180000E-04  +7.15774000E-03
   -3.92110000E-04  -6.03400000E-05  -1.08633000E-03  +1.17550000E-04  +1.38060000E-03
   +5.37560000E-03  -2.90120000E-04  +1.65650000E-04  +5.46030000E-04  +1.58500000E-04
   +8.44500000E-05  +1.39890000E-04  -3.21330000E-04  -8.03370000E-04  -3.31068000E-03
   -8.29700000E-05  +1.09680000E-04  -8.12100000E-05  -2.97400000E-05  +4.70000000E-05
   -2.73300000E-05  -6.34300000E-05  -1.14730000E-04  -5.29250000E-04  +1.09200000E-04
   +8.70900000E-05  -1.24910000E-04  -3.58400000E-05  -7.41000000E-05  -6.54960000E-04
   -5.16620000E-04  -8.38490000E-04  -4.44363000E-03  -4.05118600E-02  -4.58769200E-02
   +3.62248000E-02  -4.72900000E-05  +7.76700000E-05  +1.67600000E-05  -6.33300000E-05
   -1.23000000E-06  -6.55000000E-06  -9.93050000E-04  +5.64960000E-04  -6.57100000E-04
   -4.38230000E-04  -1.76700000E-05  -1.34470000E-04  +2.91120000E-04  -2.14620000E-04
   +1.32220000E-04  -4.44300000E-05  -1.25310000E-04  +8.54000000E-06  +5.27586000E-03
   +8.49540000E-04  -1.04777800E-02  -1.25830000E-04  +3.62440000E-04  -9.84400000E-04
   +6.06000000E-05  -3.53100000E-05  +5.68000000E-06  +5.11440000E-04  +2.99202000E-03
   +9.77770000E-04  -9.39482600E-02  -3.30362300E-02  +9.64352900E-02  -1.41200000E-05
   +3.70000000E-06  +1.04900000E-05  +2.22400000E-05  -1.42600000E-05  -8.22000000E-06
   +4.12600000E-05  -2.33500000E-05  -2.82300000E-05  -2.19987000E-03  +3.14590000E-04
   -8.38000000E-04  -3.88000000E-06  -2.71000000E-06  -3.42100000E-05  +9.89723900E-02
   +1.44420000E-04  +2.71010000E-04  -4.34900000E-05  +2.77250000E-04  -9.41900000E-05
   -1.10210000E-04  +5.72000000E-06  +4.29750000E-04  -7.54700000E-05  -1.18930000E-03
   +6.18140000E-04  -7.99710000E-04  +9.72700000E-05  -3.60560000E-04  -2.85170000E-04
   -2.95210000E-04  -7.30000000E-06  +9.53900000E-05  -1.45339200E-02  -1.03869600E-02
   +2.77015100E-02  +6.42270000E-04  +1.19228000E-03  -9.04600000E-04  -1.11240000E-04
   +8.31000000E-06  +8.16000000E-06  +3.08136000E-03  -3.71775000E-03  +1.15376000E-03
   -3.18255400E-02  -7.25279200E-02  +7.26138700E-02  +1.68400000E-05  -1.14900000E-05
   +1.14900000E-05  -4.56000000E-06  +3.69000000E-06  +3.98300000E-05  -5.33700000E-05
   +4.56300000E-05  +1.97400000E-05  +1.34090000E-04  +3.25920000E-04  +8.23700000E-05
   -1.45000000E-06  -5.80000000E-07  +1.20900000E-05  +3.48971400E-02  +8.01251700E-02
   +5.14100000E-05  +1.95700000E-05  -5.95400000E-05  -1.78550000E-04  -4.93300000E-04
   +1.79340000E-04  +5.58370000E-04  +1.05074000E-03  +1.31060000E-04  +2.22850000E-04
   -1.52600000E-04  +2.41320000E-04  -1.69740000E-04  +9.16800000E-05  +1.74190000E-04
   +7.04200000E-05  -1.44380000E-04  -2.73000000E-06  +3.64827000E-03  -7.25620000E-04
   -6.95304000E-03  -1.05820000E-03  -2.06284000E-03  +5.88420000E-04  +4.10300000E-05
   -9.84300000E-05  +2.52000000E-06  +8.69900000E-05  +2.58289000E-03  +1.46883000E-03
   +9.48650000E-02  +7.79504300E-02  -2.54723580E-01  +1.41000000E-06  -6.80000000E-07
   -4.63000000E-06  -2.59000000E-06  -1.03200000E-05  -2.14800000E-05  +8.17900000E-05
   -9.37000000E-05  -1.15000000E-06  -6.70960000E-04  -6.78280000E-04  -1.64480000E-04
   -2.34200000E-05  +3.00500000E-05  +2.82500000E-05  -1.03981390E-01  -8.28280000E-02
   +2.73360110E-01  +1.41870000E-04  -1.31600000E-05  -8.87000000E-06  +4.62300000E-05
   +1.18580000E-04  -8.71500000E-05  +1.98770000E-04  -2.07570000E-04  -4.40000000E-07
   +8.21740000E-04  +1.39675000E-03  -8.12180000E-04  -4.15300000E-04  -2.36670000E-04
   +4.17100000E-05  -6.83300000E-05  +2.23400000E-04  +2.20900000E-05  -1.34624300E-02
   -1.58500000E-05  -5.54570000E-04  +1.11892000E-03  -6.97180000E-04  -2.67440000E-04
   -1.74670000E-04  +6.20900000E-05  +1.28700000E-05  +1.76524000E-03  -7.27480000E-04
   +1.64425000E-03  -3.23781020E-01  -1.03568500E-02  -2.43865700E-02  +2.50500000E-05
   -1.34400000E-05  +1.63000000E-06  -6.33100000E-05  +1.82900000E-05  +1.42700000E-05
   -5.66000000E-06  +5.39200000E-05  -3.95900000E-05  +1.45750000E-04  +2.86660000E-04
   +3.10400000E-05  -1.62600000E-05  -6.55000000E-06  -4.30000000E-06  -1.00649900E-02
   -2.80940000E-04  -2.00118000E-03  +3.48344460E-01  -1.31950000E-04  -6.19100000E-05
   +5.06000000E-05  +1.14970000E-04  +3.63550000E-04  +4.47800000E-05  -7.47090000E-04
   -7.89330000E-04  +2.14320000E-04  -7.75300000E-05  -5.46377000E-03  +1.42364000E-03
   +1.64337000E-03  +1.57560000E-04  -3.56670000E-04  +3.56700000E-05  -4.41710000E-04
   +2.30000000E-05  +3.41676700E-02  -1.26797000E-03  +2.44043000E-03  +2.02980000E-04
   +5.29710000E-04  +6.17460000E-04  +5.76800000E-05  +4.72400000E-05  -3.14800000E-05
   +4.77000000E-06  -3.37840000E-04  -1.40909000E-03  -1.47727400E-02  -4.37874100E-02
   +1.75611000E-03  -2.46500000E-05  +2.68000000E-06  -4.90000000E-06  +1.50200000E-04
   -3.02100000E-05  -3.21000000E-06  +1.69000000E-06  +1.91600000E-05  +3.17900000E-05
   -6.56800000E-05  +4.57880000E-04  -2.21990000E-04  +3.79300000E-05  -1.04200000E-05
   -3.39000000E-06  -9.41183000E-03  -1.07217000E-03  -2.02479000E-03  +1.08562900E-02
   +5.15880300E-02  +1.45120000E-04  +6.73300000E-05  -3.74400000E-05  -7.67800000E-05
   -9.44400000E-05  +1.39610000E-04  +5.10980000E-04  +4.25090000E-04  +3.66000000E-05
   -1.94700000E-05  +1.68858000E-03  +6.60500000E-04  -2.26050000E-04  -1.64620000E-04
   +4.92760000E-04  -1.21000000E-04  -7.30000000E-07  -1.03650000E-04  -7.75284000E-03
   -4.07237000E-03  -1.24396000E-03  +2.39230000E-04  +7.36000000E-06  -6.43570000E-04
   -1.00550000E-04  -1.39300000E-05  +7.55000000E-06  -6.40270000E-04  +1.27050000E-03
   -6.01000000E-06  -2.43899100E-02  +3.36399000E-03  -4.87162200E-02  +1.23900000E-05
   -1.13000000E-05  -4.32000000E-06  -4.12600000E-05  -5.03000000E-06  -6.07900000E-05
   +2.60300000E-05  -1.29000000E-06  +5.15700000E-05  -3.88600000E-05  -3.49240000E-04
   -3.08420000E-04  -8.31000000E-06  +6.22000000E-06  +2.10700000E-05  +2.77066000E-02
   +2.39750000E-04  +3.69744000E-03  +2.73309900E-02  -2.42955000E-03  +4.90617500E-02
   +1.51590000E-04  +3.18410000E-04  -2.26300000E-05  +9.18000000E-05  -1.98490000E-04
   +1.63200000E-04  -3.20900000E-04  +7.49420000E-04  -2.79800000E-05  -1.30360000E-03
   -1.85110000E-04  -9.21810000E-04  +3.61210000E-04  -4.41610000E-04  -2.47300000E-04
   -3.49410000E-04  -2.16280000E-04  +2.20020000E-04  +1.57468000E-03  +6.72241000E-03
   +7.76348000E-03  +1.21728000E-03  +1.53547000E-03  +2.72610000E-04  -9.30400000E-05
   -4.45400000E-05  -1.68000000E-05  +1.09260000E-04  -6.76910000E-04  +4.58810000E-04
   -5.67234700E-02  -3.65697800E-02  -4.13577000E-02  -1.08000000E-06  -1.37900000E-05
   -6.01000000E-06  +1.70100000E-05  -6.22000000E-06  +2.07100000E-05  +7.82000000E-06
   -4.10900000E-05  -2.77600000E-05  -8.40810000E-04  +1.20800000E-05  +3.91060000E-04
   -1.40700000E-05  +3.66000000E-06  +1.79000000E-06  +2.19254000E-03  +9.50802000E-03
   +8.70471000E-03  -5.17215000E-03  -2.14028300E-02  -2.31192000E-02  +5.94005000E-02
   -3.21300000E-05  +1.41040000E-04  -5.64200000E-05  +2.77280000E-04  -4.42000000E-05
   +8.99000000E-06  -1.92700000E-04  -4.25500000E-05  +9.09600000E-05  +4.79240000E-04
   +3.89820000E-04  +8.21310000E-04  +8.75100000E-05  -1.27140000E-04  +5.13310000E-04
   -8.26200000E-05  +1.25070000E-04  -1.49390000E-04  -8.74342000E-03  -1.93395400E-02
   -2.15903100E-02  +8.81230000E-04  -2.82255000E-03  -1.13222000E-03  +3.81700000E-05
   +7.02000000E-06  +2.08300000E-05  +2.00601000E-03  +1.07572000E-03  +1.81883000E-03
   -3.81774700E-02  -1.57554100E-01  -1.22787600E-01  +2.32000000E-06  +2.69000000E-06
   -1.09900000E-05  -2.36900000E-05  -8.93000000E-06  -4.99500000E-05  -3.45000000E-05
   +5.19000000E-05  -6.36000000E-06  +3.36370000E-04  +1.56030000E-04  -1.94180000E-04
   +1.21000000E-06  -3.74000000E-06  -4.41000000E-06  +3.17235000E-03  +7.55838000E-03
   +7.61899000E-03  +6.13700000E-05  -5.68110000E-04  +3.06540000E-04  +4.10738800E-02
   +1.71314880E-01  -2.94900000E-05  -2.19200000E-05  +2.00100000E-05  +4.03900000E-05
   +3.50430000E-04  +1.09560000E-04  -3.44540000E-04  -5.32700000E-04  +3.52940000E-04
   -5.53820000E-04  -2.88140000E-04  +3.01630000E-04  +2.83260000E-04  -2.05600000E-05
   -1.67130000E-04  -6.66700000E-05  -4.78100000E-05  +6.90600000E-05  +2.78806000E-03
   +2.96545000E-03  +3.30221000E-03  -4.71750000E-04  -1.30838000E-03  +2.00721000E-03
   -4.15600000E-05  +4.52800000E-05  -2.94500000E-05  +2.17700000E-04  +1.74736000E-03
   -1.19740000E-04  -4.25091900E-02  -1.19613400E-01  -1.83082440E-01  -5.39000000E-06
   -2.79000000E-06  -1.27600000E-05  +2.14800000E-05  +1.55000000E-06  +2.82000000E-06
   +6.40000000E-06  +1.30700000E-05  -1.60200000E-05  +1.86450000E-04  +1.82590000E-04
   -4.28790000E-04  +1.76800000E-05  -1.65900000E-05  -2.55000000E-06  -7.39423000E-03
   -1.80221300E-02  -1.72010900E-02  +1.01560000E-04  -8.54840000E-04  -2.33937000E-03
   +4.73610800E-02  +1.35795420E-01  +1.97837510E-01  -1.81340000E-04  -6.29520000E-04
   +9.59600000E-05  -5.13590000E-04  +4.23160000E-04  +7.52800000E-05  +1.03228000E-03
   +4.47320000E-04  -3.86790000E-04  -1.75293000E-03  -8.00400000E-04  +1.44367000E-03
   -8.56300000E-04  +2.77380000E-04  +1.31167000E-03  +4.29150000E-04  +5.28000000E-06
   +6.21700000E-05  +9.60974000E-03  -8.75961000E-03  +1.51098000E-02  -7.06460000E-04
   -8.74720000E-04  +6.33350000E-04  +1.37000000E-05  +4.45500000E-05  -8.09100000E-05
   -1.35011120E-01  +6.91001400E-02  -1.16541210E-01  -1.55177000E-03  -1.17242000E-03
   +5.83940000E-04  -2.29500000E-05  +3.53000000E-06  +1.49800000E-05  +4.12500000E-05
   +1.60900000E-05  +6.82100000E-05  -4.64090000E-04  +2.36000000E-04  +2.82430000E-04
   +2.22400000E-05  -1.88100000E-05  +9.00000000E-06  +1.09800000E-05  +1.30900000E-05
   +1.56600000E-05  +1.89060000E-04  -4.83050000E-04  +2.30500000E-05  +2.88360000E-04
   -2.13500000E-05  +6.41600000E-05  +5.68700000E-05  -1.98270000E-04  +1.21570000E-04
   +1.43840750E-01  -6.03440000E-04  +1.12334000E-03  -1.43170000E-04  +9.32780000E-04
   -1.15172000E-03  +1.83930000E-04  -1.61241000E-03  -8.49470000E-04  +2.49600000E-04
   +2.55903000E-03  -9.85900000E-04  -2.83547000E-03  +9.01220000E-04  +1.45359000E-03
   -9.74450000E-04  -4.22290000E-04  -1.34520000E-04  -4.62000000E-05  +3.49261000E-03
   -1.45960800E-02  +2.53211900E-02  -9.73510000E-04  -3.61455000E-03  -4.48464000E-03
   +9.67830000E-04  -3.95890000E-04  +1.13400000E-05  +6.51437900E-02  -5.13579200E-02
   +7.45159500E-02  -1.95813000E-03  -2.62090000E-04  +4.14979000E-03  -2.00900000E-05
   +1.14690000E-04  -2.75200000E-05  +6.20000000E-05  -3.71000000E-05  +3.86000000E-06
   +7.85810000E-04  -4.27610000E-04  -4.58450000E-04  -2.10200000E-05  -1.75500000E-05
   -5.11800000E-05  +2.63700000E-05  -5.59000000E-06  +6.44000000E-06  -2.17470000E-04
   -1.38895000E-03  +1.41400000E-04  -3.22250000E-04  +3.91120000E-04  -3.93550000E-04
   +2.22800000E-05  +2.13840000E-04  -4.92500000E-04  -6.51774600E-02  +7.36465700E-02
   -2.26570000E-04  -1.94020000E-04  -1.73000000E-05  -1.62000000E-04  -1.20430000E-04
   -4.53400000E-05  +1.96660000E-04  -5.33900000E-05  +3.86090000E-04  -1.23510000E-04
   -4.80810000E-04  +5.92500000E-05  +1.88260000E-04  +8.11520000E-04  -1.13570000E-04
   +4.34110000E-04  -2.17300000E-04  +1.58430000E-04  -1.65798400E-02  +2.07463000E-03
   -8.63734000E-03  +4.09110000E-04  -1.81100000E-03  -3.17923000E-03  +1.07180000E-04
   -7.95400000E-05  -1.13100000E-05  -1.08951160E-01  +9.03906800E-02  -2.06206430E-01
   +1.80096000E-03  +8.25870000E-04  +6.15870000E-04  +3.16000000E-05  +2.31600000E-05
   -7.45000000E-06  +3.67200000E-05  +1.51700000E-05  +1.70300000E-05  +3.81590000E-04
   -7.42740000E-04  -6.52660000E-04  -8.89300000E-05  -7.55100000E-05  -8.28000000E-06
   +1.08200000E-05  -1.09000000E-05  -4.50800000E-05  -9.95900000E-05  +4.21310000E-04
   +5.98600000E-05  +3.56600000E-05  -2.48420000E-04  -4.16000000E-05  -1.82600000E-05
   +6.21080000E-04  -3.86190000E-04  +1.22124440E-01  -8.94063200E-02  +2.17878080E-01
   +1.20930000E-04  -4.18890000E-04  +1.08890000E-04  -4.48810000E-04  -2.19100000E-05
   -2.28170000E-04  +1.77100000E-05  +6.24340000E-04  +2.25570000E-04  -8.76700000E-05
   -1.65944000E-03  +3.59914000E-03  -1.80520000E-04  -3.95100000E-05  -9.21800000E-05
   +4.05660000E-04  +3.84900000E-05  +1.03140000E-04  -1.66868500E-02  +7.77269000E-03
   +7.56919000E-03  -5.94970000E-04  -1.29181000E-03  -1.20920000E-03  -2.36750000E-04
   +7.15500000E-05  -3.07300000E-05  -2.35473290E-01  +1.10980970E-01  +7.17983300E-02
   +1.09377000E-03  +7.51840000E-04  -2.92123000E-03  +3.12900000E-05  -1.28100000E-05
   +1.35200000E-05  -1.77000000E-05  +2.00500000E-05  -2.66000000E-06  -2.08700000E-05
   -9.48700000E-05  -2.35980000E-04  -2.58200000E-05  -8.42600000E-05  +1.33810000E-04
   -7.10900000E-05  +9.93000000E-06  -5.62100000E-05  +3.31550000E-04  +3.03400000E-04
   -4.77540000E-04  +3.10310000E-04  -4.27540000E-04  +4.38250000E-04  -3.24850000E-04
   -5.86550000E-04  +6.72400000E-05  -1.07868400E-02  +5.38955000E-03  +6.09497000E-03
   +2.57804390E-01  -1.62620000E-04  -3.06360000E-04  +1.70710000E-04  -2.64150000E-04
   -3.59000000E-06  -2.87710000E-04  -4.13530000E-04  +3.05500000E-04  +2.29500000E-05
   -1.25453000E-03  -1.33081000E-03  +4.06152000E-03  -3.02590000E-04  -3.69080000E-04
   -1.86400000E-04  +3.95770000E-04  +2.92130000E-04  -5.08100000E-05  -2.06020300E-02
   +6.16484000E-03  +1.15394100E-02  -9.51120000E-04  -1.88565000E-03  -1.69452000E-03
   +1.47200000E-04  +2.10800000E-05  -6.02300000E-05  +1.24770810E-01  -9.53435100E-02
   -3.44374300E-02  -1.73419000E-03  -1.16630000E-04  -1.15333000E-03  -4.26300000E-05
   +1.67200000E-05  +1.70300000E-05  +1.23600000E-05  -1.17600000E-05  -1.62100000E-05
   +1.36500000E-05  +4.66030000E-04  -1.36400000E-05  -1.57400000E-05  +1.64700000E-05
   +1.28840000E-04  -4.42900000E-05  +1.27900000E-05  -1.22600000E-05  -1.98270000E-04
   +2.76600000E-04  -3.54690000E-04  -9.16000000E-06  +3.78790000E-04  +2.53360000E-04
   -4.65400000E-05  -2.56490000E-04  -6.94000000E-05  +5.19507000E-03  -6.08354000E-03
   -5.25037000E-03  -1.18938520E-01  +1.04134450E-01  -2.81280000E-04  -1.26010000E-04
   +3.74000000E-05  +3.66400000E-05  +3.19270000E-04  -2.09200000E-04  +1.18841000E-03
   -7.12760000E-04  +2.42960000E-04  +1.15632000E-03  +3.80870000E-03  +6.93100000E-04
   -5.83480000E-04  +6.14550000E-04  +1.23190000E-04  +3.88210000E-04  -2.44000000E-05
   +4.05200000E-05  +1.63947200E-02  -1.29815000E-02  -2.58422000E-03  -6.18430000E-04
   -1.51656000E-03  -2.86922000E-03  +2.36790000E-04  -7.10200000E-05  -2.82100000E-05
   +7.61604400E-02  -2.81180000E-02  -7.57138100E-02  +7.16170000E-04  -1.40103000E-03
   -5.43630000E-04  -1.44200000E-05  +2.48800000E-05  +8.70000000E-07  +4.78300000E-05
   -1.56300000E-05  -4.87000000E-06  -2.00800000E-04  -8.44500000E-05  -1.29040000E-04
   -1.80300000E-05  +3.87000000E-05  +6.29100000E-05  +1.07950000E-04  -3.62400000E-05
   -4.33000000E-05  -3.15020000E-04  -4.92500000E-05  -4.65400000E-05  -6.36240000E-04
   +6.10090000E-04  -5.99330000E-04  -8.21900000E-05  -2.05300000E-05  -8.92100000E-05
   -1.89370300E-02  +1.00792500E-02  +9.38342000E-03  -8.23538600E-02  +3.26106800E-02
   +7.59413600E-02  -3.70720000E-04  -8.63300000E-05  +4.62400000E-05  +2.25700000E-05
   +1.54500000E-04  -2.18400000E-04  +4.89280000E-04  -1.22810000E-04  +8.55300000E-05
   -5.91930000E-04  +1.05116000E-03  +1.74324000E-03  -5.80040000E-04  -4.99390000E-04
   +1.60500000E-05  +3.47370000E-04  +2.52750000E-04  -3.06500000E-04  -9.10522000E-03
   -1.20452200E-02  +3.36411000E-03  -2.34863000E-03  -7.61500000E-03  -2.59654000E-03
   +4.82400000E-04  -7.21300000E-05  -1.96100000E-05  -3.77885000E-02  -5.07368000E-03
   -4.32373000E-03  -3.71870000E-04  +2.80970000E-04  +1.52410000E-04  -8.16000000E-05
   +4.86900000E-05  +2.00300000E-05  +9.77400000E-05  -3.45100000E-05  +4.84400000E-05
   -1.15325000E-03  +1.02573000E-03  +6.65450000E-04  -4.03100000E-05  +2.79000000E-05
   +7.23000000E-05  +5.95400000E-05  -4.00000000E-06  -3.79000000E-06  +1.02670000E-04
   +2.85300000E-05  -3.53360000E-04  -1.39020000E-04  +5.92400000E-05  +1.79870000E-04
   -1.53720000E-04  +4.32800000E-05  -6.11000000E-04  -4.78593000E-03  -1.14879200E-02
   -6.89598000E-03  +5.30682000E-03  +1.66651900E-02  +8.52488000E-03  +7.15281100E-02
   -2.64752000E-03  +8.18590000E-04  +5.00170000E-04  +1.08477000E-03  -1.69686000E-03
   +7.23600000E-05  -1.14493000E-03  -1.58399000E-03  +9.43190000E-04  +2.06227000E-03
   -1.64382000E-03  -9.26780000E-04  -3.23730000E-04  +2.66054000E-03  -2.70572000E-03
   +1.69696000E-03  +2.64610000E-04  +4.73160000E-04  -2.52056800E-02  -2.73289800E-02
   +4.58388800E-02  -1.03907700E-02  -2.83919000E-02  -1.11667500E-02  +3.24780000E-03
   -1.06243000E-03  -4.45120000E-04  +1.66077700E-02  -1.61314400E-02  -1.98253900E-02
   -1.88743000E-03  +3.76390000E-04  -1.18758000E-03  -1.78460000E-04  +3.92590000E-04
   +3.76600000E-05  +3.96270000E-04  -1.41850000E-04  +2.35400000E-05  +2.33128000E-03
   +1.05387000E-03  +2.27660000E-04  -2.81380000E-04  -1.33490000E-04  +2.71400000E-05
   +1.81480000E-04  -1.47200000E-05  -9.00400000E-05  -4.13970000E-04  +4.46350000E-04
   -1.07288000E-03  +1.56100000E-05  +4.30150000E-04  -3.56320000E-04  +3.22080000E-04
   -5.64200000E-05  -1.39345000E-03  +1.80939000E-03  -8.74390000E-04  +5.07190000E-04
   -3.89404000E-03  -7.65973000E-03  -4.39269000E-03  +3.69018000E-03  +3.57354000E-02
   -1.90218000E-03  +2.56360000E-04  +4.81800000E-04  +6.23630000E-04  -1.20030000E-03
   +2.88290000E-04  -1.00777000E-03  -7.10900000E-04  +3.66430000E-04  +9.76010000E-04
   -2.26069000E-03  -1.81732000E-03  -4.01330000E-04  +1.52374000E-03  -1.62867000E-03
   +1.55870000E-03  +4.60110000E-04  +2.39450000E-04  -1.28575700E-02  +2.54934000E-03
   +4.64499400E-02  -6.40382000E-03  -2.02969500E-02  -1.29383400E-02  +2.28550000E-03
   -6.99950000E-04  -3.65400000E-04  +2.24781800E-02  +2.79771000E-02  -4.01734600E-02
   -5.67100000E-04  -9.77480000E-04  -6.11454000E-03  -1.31470000E-04  +2.73950000E-04
   +3.21000000E-05  +2.47510000E-04  -8.88900000E-05  +2.20000000E-05  +1.38975000E-03
   +6.08020000E-04  +4.41270000E-04  -1.93910000E-04  -1.11090000E-04  -9.61600000E-05
   +8.83600000E-05  +1.86000000E-05  -2.70300000E-05  -8.49670000E-04  +1.03157000E-03
   -1.45799000E-03  -1.82410000E-04  +5.16530000E-04  -1.75100000E-04  +3.85040000E-04
   -1.20406000E-03  -4.24090000E-04  -7.25648000E-03  -1.87356700E-02  -1.06356100E-02
   -3.09189000E-03  -4.84789000E-03  -3.78688000E-03  -8.71129000E-03  -2.88557500E-02
   +4.62246800E-02  -3.25340000E-04  +3.39800000E-05  -5.63100000E-05  -1.61900000E-04
   +1.01260000E-04  +1.50010000E-04  -2.50780000E-04  -2.33560000E-04  -4.20900000E-05
   -4.45940000E-04  -5.97630000E-04  -8.76680000E-04  -3.05300000E-04  +5.12470000E-04
   -2.49770000E-04  -2.63800000E-04  +5.73500000E-05  +1.86340000E-04  +5.76337000E-03
   +2.19495000E-03  +6.61573000E-03  -3.87694000E-01  +5.73197300E-02  +2.33911490E-01
   +1.61250000E-04  -2.18600000E-05  +2.02400000E-05  +9.72520000E-04  +2.99485000E-03
   -2.43538000E-03  -7.22380000E-04  -8.27780000E-04  -1.12335000E-03  -6.63700000E-05
   +1.43400000E-05  -2.78200000E-05  +1.26200000E-05  -7.21000000E-06  -4.48300000E-05
   +1.04990000E-04  -1.48000000E-05  -1.13270000E-04  +6.36100000E-05  +2.25600000E-05
   -7.49900000E-05  -8.25000000E-06  +2.78000000E-06  +2.31000000E-06  +6.83600000E-05
   -4.56600000E-05  +2.25680000E-04  -2.95000000E-05  -8.15800000E-05  -6.41300000E-05
   +1.12440000E-04  -5.80090000E-04  +1.60540000E-04  +1.88940000E-04  -5.08120000E-04
   -7.39210000E-04  -1.23330000E-04  -1.78570000E-04  -3.92580000E-04  -4.47920000E-04
   -1.74638000E-03  -2.49298000E-03  +3.91405870E-01  -2.39880000E-04  +8.85800000E-05
   -9.72000000E-06  -1.99050000E-04  -2.15710000E-04  +1.57120000E-04  -2.43020000E-04
   -2.79140000E-04  +3.90360000E-04  +4.67870000E-04  +4.12420000E-04  +3.45500000E-05
   -1.99010000E-04  +7.88250000E-04  +1.81710000E-04  +3.73150000E-04  -1.05550000E-04
   -2.54410000E-04  +3.70992000E-03  +8.12700000E-05  +1.75444000E-03  +8.32870600E-02
   -4.74607800E-02  -5.55934600E-02  +3.51670000E-04  -1.54560000E-04  -1.24500000E-05
   +1.41220000E-04  +1.02056000E-03  -7.17820000E-04  +3.23660000E-04  -1.00807000E-03
   -2.00522000E-03  +9.16000000E-06  +5.20200000E-05  +1.01700000E-05  +5.06300000E-05
   -2.86200000E-05  +3.96700000E-05  -4.21000000E-05  -2.05880000E-04  +3.10310000E-04
   -3.46400000E-05  -1.40420000E-04  -1.25160000E-04  +1.27000000E-06  -1.14500000E-05
   -4.35500000E-05  -5.89000000E-06  -7.85800000E-04  +6.83200000E-05  -4.75350000E-04
   +1.70420000E-04  +1.03320000E-04  -3.16870000E-04  -6.60930000E-04  +2.77260000E-04
   -2.82000000E-06  -2.80960000E-04  -1.94200000E-04  -1.82200000E-05  -3.72500000E-05
   -6.22100000E-05  -3.30390000E-04  -7.83780000E-04  -9.81660000E-04  -6.52038100E-02
   +4.12947700E-02  -8.83490000E-04  +7.90560000E-04  -1.34970000E-04  +8.20440000E-04
   -6.74130000E-04  -1.86430000E-04  -1.32828000E-03  -7.27950000E-04  +6.40230000E-04
   +4.15710000E-04  +3.83300000E-04  +2.48050000E-04  -2.62930000E-04  +6.11120000E-04
   +1.95320000E-04  -3.62880000E-04  +2.70680000E-04  +8.85100000E-05  +7.35026000E-03
   +8.71900000E-05  -2.93930000E-04  +2.22738340E-01  -3.77745800E-02  -1.51734200E-01
   +1.22970000E-03  -3.33810000E-04  -1.12560000E-04  -2.42800000E-04  +2.01181000E-03
   -2.28484000E-03  -4.16260000E-04  -1.14924000E-03  -1.09407000E-03  -1.19110000E-04
   +1.11750000E-04  +3.85800000E-05  +6.91300000E-05  -6.94900000E-05  +2.13300000E-05
   +9.38200000E-05  +2.17820000E-04  -3.51740000E-04  +3.45700000E-05  +1.07720000E-04
   +3.90000000E-05  +7.24900000E-05  +1.57100000E-05  +1.93500000E-05  +1.09480000E-04
   -1.10710000E-04  +2.03420000E-04  -2.90990000E-04  +8.75100000E-05  -5.83000000E-05
   -6.00400000E-05  -3.07800000E-04  +1.70950000E-04  +1.18270000E-04  -4.66330000E-04
   -6.14400000E-04  -4.33500000E-05  -1.32500000E-05  -1.34850000E-04  -2.40790000E-04
   -1.48607000E-03  -1.45163000E-03  -2.37794370E-01  +4.20440600E-02  +1.61895200E-01
   +7.67460000E-04  +4.81400000E-05  +9.05300000E-05  -2.13070000E-04  +9.33200000E-05
   +7.95600000E-05  +1.46020000E-04  +7.08700000E-05  -3.76400000E-05  -3.99080000E-04
   -4.93770000E-04  -5.98730000E-04  -2.56610000E-04  +3.61900000E-04  -1.11927000E-03
   -3.46530000E-04  -7.04540000E-04  +3.73500000E-04  +2.16890000E-03  +1.12670000E-03
   +1.15487000E-03  +3.05867000E-03  -3.08169000E-02  +1.46998000E-02  -9.58410000E-04
   +1.12950000E-04  +4.42000000E-06  +5.53306000E-03  -1.14419400E-02  -5.79251000E-03
   -2.13830000E-04  -5.41440000E-04  -6.74200000E-04  +1.70310000E-04  -7.36200000E-05
   +9.57000000E-06  -2.02300000E-05  +5.85800000E-05  -4.86100000E-05  -7.90800000E-05
   -2.22490000E-04  +9.67300000E-05  +8.59000000E-06  -5.65000000E-05  +2.29300000E-05
   -3.93700000E-05  -2.15600000E-05  +7.21000000E-06  +1.22170000E-04  +1.57350000E-04
   +8.23300000E-05  +5.46600000E-05  -1.48400000E-04  +8.45100000E-05  +7.39800000E-05
   -3.07920000E-04  +2.17270000E-04  +9.29050000E-04  +1.63184000E-03  +8.62370000E-04
   -6.71450000E-04  -2.76664000E-03  -1.43538000E-03  -2.58744400E-02  +2.24167000E-03
   +4.96955000E-03  +8.78820000E-04  +1.10829000E-03  -7.77040000E-04  +5.43692120E-01
   +2.64303000E-03  -1.00613000E-03  -2.12850000E-04  -1.16626000E-03  +1.79073000E-03
   -3.13300000E-05  +1.31002000E-03  +1.45771000E-03  -1.11110000E-03  -2.85492000E-03
   +6.02480000E-04  +2.80550000E-04  -3.03060000E-04  -2.28997000E-03  +1.01895000E-03
   -1.33073000E-03  -6.12640000E-04  +4.67600000E-05  +1.36440700E-02  +8.74640000E-03
   -1.16170200E-02  -2.72010600E-02  -4.77316900E-02  +3.52007100E-02  -3.34119000E-03
   +1.04735000E-03  +3.07250000E-04  -2.39222300E-02  -4.96031000E-02  -2.25625100E-02
   -3.05700000E-04  -1.48189000E-03  +2.73200000E-05  +2.23650000E-04  -4.09910000E-04
   -1.20700000E-05  -4.41160000E-04  +1.44320000E-04  -6.50400000E-05  -9.40340000E-04
   -1.13749000E-03  -1.37040000E-04  +3.10310000E-04  +1.72380000E-04  -1.27900000E-05
   -1.58070000E-04  +8.86000000E-06  +9.11700000E-05  +4.60670000E-04  -3.31200000E-05
   +5.31640000E-04  -9.53900000E-05  +7.40600000E-05  +3.11970000E-04  +4.83700000E-05
   -4.47290000E-04  +3.43840000E-04  -6.37560000E-04  +9.90610000E-04  -9.23900000E-05
   +6.98730000E-04  +3.07800000E-04  +1.88660000E-04  +1.22561400E-02  +5.85523000E-03
   +1.64262600E-02  -1.49875000E-03  -7.11768000E-03  +1.16537000E-03  +1.74725710E-01
   +1.53299290E-01  +9.33330000E-04  -2.96030000E-04  -3.53860000E-04  -5.58450000E-04
   +6.15170000E-04  -1.78050000E-04  +6.24250000E-04  +4.56310000E-04  +3.20000000E-05
   -1.76840000E-04  +1.44000000E-03  +2.04038000E-03  -6.59000000E-05  -5.24020000E-04
   +1.44422000E-03  -7.76810000E-04  -3.88940000E-04  -2.58290000E-04  +1.00248300E-02
   +3.59006000E-03  -4.63681800E-02  +3.04643400E-02  +6.69395000E-02  -2.42828000E-03
   -1.27373000E-03  +3.75440000E-04  +3.32750000E-04  -3.26732300E-02  -6.88348500E-02
   -1.15885800E-02  +1.17681000E-03  +1.26998000E-03  +4.34717000E-03  +8.30000000E-05
   -1.46170000E-04  -8.60900000E-05  -1.21780000E-04  +6.74200000E-05  -8.80000000E-05
   -3.50240000E-04  -1.49750000E-04  -3.62830000E-04  +6.11500000E-05  -1.89800000E-05
   -4.12000000E-06  -7.11500000E-05  -1.45000000E-05  -9.28000000E-06  +2.79670000E-04
   -1.11036000E-03  +1.07638000E-03  +2.02650000E-04  -4.84280000E-04  -1.00590000E-04
   -3.08240000E-04  +1.11526000E-03  +8.32510000E-04  +1.13479000E-03  +5.44184000E-03
   +3.02930000E-03  +1.36762000E-03  +1.29594000E-03  +1.34002000E-03  +2.32226900E-02
   +4.16554900E-02  +1.27175900E-02  +1.46410000E-03  +3.68298000E-03  +3.13940000E-04
   +1.76045300E-02  -9.57536000E-03  +5.65132600E-02  -1.34600000E-04  +5.46200000E-05
   +3.75200000E-05  +2.33400000E-05  -1.18300000E-04  -3.06000000E-06  +2.58000000E-05
   -8.49400000E-05  +3.93400000E-05  -1.39420000E-04  -2.32600000E-05  +8.31900000E-05
   +8.38900000E-05  +4.33900000E-04  -2.76900000E-04  +6.95200000E-05  -1.35840000E-04
   +3.32200000E-05  -4.76370000E-04  +2.51940000E-04  +1.54492000E-03  +8.07050000E-04
   +1.04600000E-04  -7.06430000E-04  +1.49070000E-04  -6.86500000E-05  -1.23800000E-05
   +1.90553000E-03  +2.31557000E-03  -1.86400000E-05  +4.96300000E-05  +1.18970000E-04
   +1.26980000E-04  +4.21000000E-06  +1.65300000E-05  -2.32000000E-06  +1.03800000E-05
   -3.25000000E-06  -1.15600000E-05  +2.97150000E-04  -8.91000000E-05  +2.70680000E-04
   -2.82800000E-05  -2.16800000E-05  +1.41300000E-05  +1.02100000E-05  -2.09000000E-06
   -7.99000000E-06  -4.29200000E-05  +4.08600000E-05  -5.07600000E-05  -1.87600000E-05
   +3.15200000E-05  -4.21900000E-05  -1.77800000E-05  +1.09120000E-04  -9.58300000E-05
   -1.47820000E-04  -2.29980000E-04  -8.38000000E-05  -9.77100000E-05  -2.99960000E-04
   -1.57970000E-04  -1.34839000E-03  -2.57857000E-03  -2.03477000E-03  +1.20730000E-04
   +2.04290000E-04  -2.53420000E-04  -5.01708990E-01  -1.60838200E-01  -1.82186800E-02
   +5.03896590E-01  -4.43800000E-05  +9.33300000E-05  +7.71000000E-06  +1.08170000E-04
   -3.84000000E-05  +7.19000000E-06  -1.36930000E-04  -6.66000000E-06  +3.92700000E-05
   +3.04020000E-04  -6.78200000E-05  -2.74840000E-04  +4.66770000E-04  -1.29800000E-05
   +2.51500000E-04  -7.42700000E-05  +1.89150000E-04  +4.26000000E-06  +3.95850000E-04
   +3.25210000E-04  -1.04226000E-03  +4.02130000E-04  -5.50840000E-03  +4.22079000E-03
   +1.18910000E-04  -1.60000000E-05  -4.07800000E-05  -2.74800000E-05  -3.59679000E-03
   -1.48752000E-03  -7.23700000E-05  +9.97900000E-05  -7.22400000E-05  -3.09700000E-05
   +1.36000000E-05  +6.87000000E-06  +1.01300000E-05  -1.13300000E-05  +1.17800000E-05
   -4.03990000E-04  -1.99180000E-04  -3.32950000E-04  +4.62000000E-06  +1.23500000E-05
   +4.36000000E-06  -1.32000000E-06  +3.95000000E-06  +1.36000000E-06  +4.16700000E-05
   +5.69700000E-05  +6.67800000E-05  +4.41000000E-05  -1.09380000E-04  +2.30100000E-05
   +3.31200000E-05  -2.32100000E-05  +9.54000000E-05  +3.75150000E-04  +4.66170000E-04
   +1.56610000E-04  -1.17750000E-04  -6.12620000E-04  -4.02520000E-04  -8.27626000E-03
   +1.17415000E-03  +3.99527000E-03  +3.32680000E-04  +5.83100000E-05  +1.46410000E-04
   -1.44567580E-01  -5.84239400E-02  -5.05090000E-03  +1.60376380E-01  +6.29643100E-02
   +1.49510000E-04  +1.92190000E-04  +7.93000000E-06  +1.07050000E-04  -3.54200000E-05
   +1.34100000E-05  -1.69550000E-04  -6.97900000E-05  +4.33700000E-05  +2.88000000E-04
   -3.98700000E-05  -2.23920000E-04  +2.40990000E-04  +1.06000000E-06  -9.53700000E-05
   -2.61190000E-04  -9.15200000E-05  +1.92090000E-04  +7.16420000E-04  +6.08200000E-05
   -2.67827000E-03  +3.66270000E-04  +9.51938000E-03  -3.84761000E-03  -1.66600000E-04
   +1.22700000E-05  -4.48000000E-05  -6.30660000E-04  -5.54848000E-03  -1.76334000E-03
   +1.03410000E-04  +5.82800000E-05  -1.10820000E-04  +1.41000000E-05  -1.58600000E-05
   +1.83200000E-05  -2.41200000E-05  +5.62000000E-06  -6.54000000E-06  +3.12550000E-04
   +2.86500000E-05  -2.32600000E-04  +4.78000000E-06  +9.70000000E-07  +2.19100000E-05
   -8.41000000E-06  -3.50000000E-06  +1.24000000E-06  +2.18500000E-05  -1.61200000E-05
   +1.04810000E-04  +4.38300000E-05  -3.73400000E-05  +6.07300000E-05  +2.72000000E-06
   -6.54200000E-05  +1.72230000E-04  +2.10780000E-04  +5.38700000E-04  +3.38070000E-04
   -8.57700000E-05  -6.64610000E-04  -2.16180000E-04  -9.40387000E-03  +4.35219000E-03
   +4.84598000E-03  +2.85000000E-06  -1.25340000E-04  +4.08190000E-04  -2.11308000E-02
   -6.39374000E-03  -1.98610200E-02  +2.06495200E-02  +6.71027000E-03  +1.55044000E-02
   -4.57800000E-04  +5.01910000E-04  -1.38250000E-04  +4.67380000E-04  -3.03730000E-04
   -3.96000000E-05  -5.35490000E-04  -3.56190000E-04  +3.26660000E-04  +6.12120000E-04
   +3.55240000E-04  +3.21190000E-04  -2.36290000E-04  -1.23260000E-04  +1.98380000E-04
   -2.41750000E-04  +1.10350000E-04  +7.91300000E-05  -7.43210000E-04  -4.49735000E-03
   -1.91360800E-02  -4.08627400E-02  +1.62541100E-02  +1.50177700E-02  +5.20350000E-04
   -1.57190000E-04  +6.31000000E-06  -7.00383000E-03  -1.30507800E-02  +1.05412000E-03
   +7.49680000E-04  +6.85710000E-04  +1.00405000E-03  -8.31500000E-05  +5.56900000E-05
   -1.63600000E-05  +6.28700000E-05  -2.77800000E-05  -1.14300000E-05  +2.28810000E-04
   +7.76690000E-04  -5.50950000E-04  -4.89800000E-05  -1.11700000E-05  -2.36900000E-05
   +1.97800000E-05  -8.28000000E-06  -3.26000000E-05  -1.95040000E-04  -5.10290000E-04
   +3.04390000E-04  +1.50030000E-04  -5.08200000E-05  -9.73400000E-05  -5.21000000E-05
   +3.90040000E-04  +5.32780000E-04  +1.28780000E-04  +1.63896000E-03  +1.25439000E-03
   +4.26110000E-04  +1.02501000E-03  +1.06835000E-03  +6.74498000E-03  +1.50053200E-02
   +1.30824200E-02  -9.00872000E-03  -2.27171300E-02  +1.00235300E-02  -2.68227600E-02
   +1.87139000E-02  -3.40487400E-02  -3.29206000E-03  -9.26039000E-03  +8.64633000E-03
   +7.94730300E-02  -1.05054000E-03  +9.66460000E-04  -1.51080000E-04  +6.28760000E-04
   -9.96300000E-04  -1.02160000E-04  -8.64000000E-04  -9.37380000E-04  +1.20336000E-03
   +2.72642000E-03  +1.17396000E-03  +1.28548000E-03  +2.07200000E-05  +1.52175000E-03
   -1.15380000E-04  -8.89400000E-05  -2.33320000E-04  -8.90900000E-05  -3.18204000E-03
   -8.05245000E-03  -4.43204500E-02  -1.25811200E-02  -9.59510200E-02  +4.18390900E-02
   +1.22060000E-03  -4.95410000E-04  +3.32300000E-05  -1.59581000E-02  -3.02034200E-02
   +1.31241000E-03  +1.46314000E-03  +1.42444000E-03  +2.50665000E-03  -7.01900000E-05
   +1.65450000E-04  -3.46300000E-05  +1.83890000E-04  -5.62000000E-05  -2.86400000E-05
   +1.34969000E-03  +6.86850000E-04  +6.53780000E-04  -1.84180000E-04  -1.72630000E-04
   -6.03000000E-06  +5.32200000E-05  -3.40700000E-05  -9.47900000E-05  -1.86100000E-05
   -9.71410000E-04  +5.88020000E-04  +3.20780000E-04  -6.70130000E-04  -1.74650000E-04
   -1.89130000E-04  +9.18790000E-04  +8.66940000E-04  +8.29850000E-04  +4.06390000E-03
   +3.13011000E-03  +9.44590000E-04  +1.62379000E-03  +1.72003000E-03  +1.00633900E-02
   +3.82959200E-02  +2.53344100E-02  +7.95885000E-03  +1.53099500E-02  -4.93765000E-03
   +1.04260100E-02  -4.20237000E-03  -4.13512500E-02  +4.35520000E-04  +3.16942000E-03
   -8.37337000E-03  -4.43857000E-03  +7.36554300E-02  +4.76970000E-04  -2.05410000E-04
   +9.59500000E-05  -4.00000000E-05  +4.53230000E-04  +1.09730000E-04  +2.57340000E-04
   +3.14590000E-04  -6.65760000E-04  -2.06825000E-03  -7.79090000E-04  -1.56730000E-03
   -1.72100000E-05  -1.17067000E-03  -8.49000000E-05  -7.52800000E-05  +2.21920000E-04
   +8.87200000E-05  -2.36271000E-03  -4.24174000E-03  +3.03544000E-02  +6.02829000E-03
   -6.83653000E-03  -5.09045900E-02  -4.50790000E-04  +2.05650000E-04  -7.85000000E-05
   +1.06805000E-02  +1.90420300E-02  -4.96360000E-04  -1.67876000E-03  -2.45561000E-03
   -3.42171000E-03  +6.60000000E-06  -6.68300000E-05  +4.35400000E-05  -6.29100000E-05
   +1.54000000E-06  +4.28900000E-05  -1.11790000E-03  -2.87100000E-05  -5.04370000E-04
   +1.18290000E-04  +1.23060000E-04  -4.05500000E-05  -6.11000000E-06  +1.14000000E-05
   +4.23700000E-05  +1.04520000E-04  +9.24390000E-04  -6.79700000E-04  -2.10620000E-04
   +2.93700000E-04  +2.09080000E-04  +4.70680000E-04  -1.15186000E-03  -8.79820000E-04
   -3.00760000E-04  -2.12784000E-03  -1.32363000E-03  -6.90930000E-04  -9.87680000E-04
   -8.67260000E-04  -4.45637000E-03  -2.07541100E-02  -3.10173000E-02  +3.78845000E-03
   +1.10709200E-02  -5.83013000E-03  -8.74547000E-03  -4.11719000E-03  -2.33235000E-03
   -8.22800000E-04  -7.04481000E-03  +7.34780000E-03  +1.17523000E-03  +1.93056500E-02
   +6.23597400E-02
end_hess

