# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -500.56321030    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.19641186E+00  -2.15477155E+00  -1.08537751E-01
   006   -5.97226726E-01  -2.12592034E+00  +7.95410946E-03
   006   +7.73301688E-01  +1.15178890E-01  -2.81940588E-01
   006   -5.76116174E-01  +2.33235208E+00  -6.97130697E-01
   006   -3.18928481E+00  +2.32533942E+00  -8.51606116E-01
   006   -4.51100544E+00  +8.11040951E-02  -5.51829591E-01
   006   +3.56017864E+00  +1.13698566E-01  -2.07637795E-01
   006   +4.94091104E+00  -2.06676220E+00  -9.73271773E-01
   008   -7.06272434E+00  -5.08184319E-02  -6.63985674E-01
   006   +4.92433331E+00  +2.58070218E+00  -3.84107857E-02
   008   +4.25998595E+00  -1.00350113E+00  +3.45124955E+00
   001   -7.75381548E+00  +1.59420511E+00  -9.60723466E-01
   001   -4.19635882E+00  +4.07413742E+00  -1.20003217E+00
   001   +4.07737371E-01  +4.10623716E+00  -9.35099587E-01
   001   +3.96257500E-01  -3.87073702E+00  +3.86334743E-01
   001   -4.24562696E+00  -3.88946303E+00  +1.43643718E-01
   001   +4.06140550E+00  +3.86230930E+00  +1.31317518E+00
   001   +6.87536642E+00  +2.25548454E+00  +5.12778435E-01
   001   +4.92152258E+00  +3.46008932E+00  -1.91005158E+00
   001   +3.93457918E+00  -3.53852925E+00  -1.97468276E+00
   001   +6.86307054E+00  -1.74942051E+00  -1.60381619E+00
   001   +4.93543217E+00  -2.42677757E+00  +1.46539628E+00
   001   +2.93608576E+00  -1.44388604E+00  +4.61116319E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.20000000E-07  +2.10000000E-07  +1.66000000E-06
   -1.70000000E-07  +9.00000000E-08  +1.86000000E-06
   -2.00000000E-08  -2.30000000E-07  -2.00000000E-08
   +2.20000000E-07  -4.90000000E-07  -2.07000000E-06
   +1.30000000E-07  -5.20000000E-07  -2.28000000E-06
   +5.00000000E-08  -1.60000000E-07  -4.30000000E-07
   +4.00000000E-08  -3.00000000E-07  +4.10000000E-07
   +0.00000000E+00  -1.14000000E-06  +2.45000000E-06
   +4.00000000E-08  -8.00000000E-08  -5.40000000E-07
   +1.60000000E-07  -2.50000000E-07  -1.83000000E-06
   -3.40000000E-07  +2.98000000E-06  +1.26000000E-06
   +1.60000000E-07  -3.30000000E-07  -2.02000000E-06
   +3.30000000E-07  -7.20000000E-07  -3.92000000E-06
   +3.20000000E-07  -7.30000000E-07  -3.56000000E-06
   -2.70000000E-07  +4.10000000E-07  +3.47000000E-06
   -2.30000000E-07  +4.80000000E-07  +3.09000000E-06
   +9.00000000E-08  +1.02000000E-06  -3.01000000E-06
   +6.00000000E-08  +1.40000000E-07  -1.38000000E-06
   +3.60000000E-07  -1.88000000E-06  -2.64000000E-06
   -3.00000000E-08  -1.85000000E-06  +3.46000000E-06
   +0.00000000E+00  -1.70000000E-06  +2.14000000E-06
   -2.20000000E-07  +1.04000000E-06  +2.36000000E-06
   -5.60000000E-07  +4.00000000E-06  +1.54000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.40404120E-01  +4.49170700E-02  +7.08293030E-01  +2.14342700E-02  -9.75143800E-02
   +1.47563800E-01  -3.71863610E-01  -3.94048700E-02  -7.97031000E-03  +7.25398600E-01
   +3.08884800E-02  -1.33125010E-01  +1.42103100E-02  -3.52897600E-02  +6.98833790E-01
   -1.94674700E-02  +1.00970300E-02  -6.30358200E-02  +3.49127800E-02  -9.75614600E-02
   +1.66787840E-01  -3.32604400E-02  -2.37400200E-02  +1.67656000E-03  -1.66238060E-01
   -1.04722000E-01  +1.76647400E-02  +6.53414490E-01  -7.68887000E-02  +3.75781900E-02
   -9.52032000E-03  -4.55762800E-02  -2.61866320E-01  +2.91837300E-02  -5.25205000E-03
   +6.73385730E-01  +9.29875000E-03  -4.97381000E-03  +9.84859000E-03  +4.91558000E-03
   +2.43871900E-02  -7.44311300E-02  +1.94807600E-02  -7.22852400E-02  +1.73763310E-01
   -5.42783800E-02  +2.88738500E-02  -6.99108000E-03  +6.63142600E-02  +2.56566400E-02
   -2.29835000E-03  -1.72304740E-01  +5.06666700E-02  -1.90649200E-02  +7.02940630E-01
   +3.13081300E-02  -1.94616300E-02  +4.24484000E-03  -2.35674200E-02  -5.99741300E-02
   +1.02631000E-02  +1.10149980E-01  -2.72520190E-01  +3.79213800E-02  +3.76054100E-02
   +7.14919640E-01  -7.92864000E-03  +4.81926000E-03  -3.99388000E-03  +7.81071000E-03
   +1.27264000E-02  +6.49066000E-03  -2.86322300E-02  +3.49367700E-02  -7.42045400E-02
   +2.73513900E-02  -9.05708100E-02  +1.60032960E-01  +6.57707600E-02  -2.26475500E-02
   +6.32543000E-03  -5.42814100E-02  -3.34905500E-02  +3.56256000E-03  -3.15908400E-02
   +7.74781900E-02  -1.19154600E-02  -3.48650820E-01  -3.56873900E-02  -1.28665400E-02
   +7.14394430E-01  +2.22760500E-02  -4.87679400E-02  +1.02167400E-02  -2.73858100E-02
   -1.97816300E-02  +1.91872000E-03  +2.37847200E-02  +3.43263900E-02  -1.43840000E-04
   +3.50895300E-02  -1.27804980E-01  +1.21604300E-02  -2.53101100E-02  +7.09062130E-01
   -2.78910000E-04  +7.91864000E-03  +6.85361000E-03  +1.34727000E-03  +6.97420000E-04
   -2.99662000E-03  -4.93021000E-03  -1.46054000E-03  +7.81395000E-03  -2.27374800E-02
   +9.88865000E-03  -6.28860600E-02  +3.78462900E-02  -9.90487000E-02  +1.42793300E-01
   -1.57073880E-01  +1.06380920E-01  -2.22340800E-02  -3.08788400E-02  +2.91962200E-02
   -7.24866000E-03  +1.08653100E-02  +1.80589000E-03  -4.20500000E-04  -2.92096200E-02
   -3.12054600E-02  +4.34134000E-03  -1.68791160E-01  -1.13718450E-01  +1.34775400E-02
   +7.15532720E-01  +2.75271100E-02  -2.80183140E-01  +3.74225300E-02  +8.77344100E-02
   +4.69540200E-02  -3.61173000E-03  +1.76410000E-04  -8.26194500E-02  +9.85314000E-03
   -9.19859900E-02  +4.30292800E-02  -1.11492200E-02  -3.05888600E-02  -2.87545610E-01
   +3.49932400E-02  -1.50921000E-03  +7.06552460E-01  -8.74897000E-03  +4.04844400E-02
   -7.89542200E-02  -1.65444000E-02  -6.39616000E-03  +1.97193000E-03  +9.76330000E-04
   +1.30101500E-02  -7.75117000E-03  +1.37148000E-02  -9.02569000E-03  +3.48788000E-03
   -4.65230000E-04  +3.00295500E-02  -7.43052600E-02  +2.91488400E-02  -8.96662800E-02
   +1.83006290E-01  +8.16051000E-03  -6.43394000E-03  +1.86149000E-03  -3.08112900E-02
   -1.59440800E-02  -2.72418000E-03  -2.19384010E-01  -4.25100000E-05  -4.76428000E-03
   -2.93570600E-02  +1.50011800E-02  +1.22107000E-03  +7.37805000E-03  +6.15602000E-03
   -2.40258000E-03  -8.80297000E-03  -1.48450000E-04  -4.66240000E-04  +5.63927490E-01
   -5.28123000E-03  -4.42083000E-03  +1.87903000E-03  -2.79846000E-02  +9.90777000E-03
   -1.77796000E-03  -9.71584000E-03  -1.07948440E-01  -7.72990000E-04  +3.07668000E-02
   +4.97406000E-03  +1.80300000E-04  +2.51436000E-03  -5.20230000E-03  +2.78654000E-03
   +1.51268000E-03  -3.48750000E-03  +7.05050000E-04  -1.25648100E-02  +5.85688340E-01
   +2.21227000E-03  -6.51900000E-05  +5.25688000E-03  +9.34620000E-04  -3.70241000E-03
   +2.29110000E-04  +1.21194800E-02  -1.57488000E-03  -6.01775800E-02  -6.20076000E-03
   +2.59820000E-03  +1.74191000E-03  +9.59990000E-04  +2.61192000E-03  +5.78640000E-03
   -2.05811000E-03  +4.41110000E-04  -4.66200000E-04  -1.92023200E-02  +6.21948000E-02
   +1.24168290E-01  -6.60260000E-04  +1.04766000E-03  -9.36090000E-04  -2.83320000E-04
   +2.43036000E-03  +1.49565000E-03  -1.98898100E-02  +2.63245500E-02  +1.00803700E-02
   -2.86741000E-03  -3.19822000E-03  +1.18001000E-03  -1.58350000E-03  -6.85300000E-05
   -7.48760000E-04  +1.87631000E-03  +5.28550000E-04  -7.23600000E-05  -1.49290350E-01
   +7.74388800E-02  +1.03283300E-02  +6.11493460E-01  +1.56007000E-03  -7.84700000E-04
   +3.03010000E-04  -2.83959000E-03  -3.70213000E-03  -8.66580000E-04  +1.07629700E-02
   +6.77789000E-03  -3.84182000E-03  -4.18756000E-03  +1.75426000E-03  -5.40040000E-04
   +1.16135000E-03  +1.81867000E-03  -3.31910000E-04  -1.99871000E-03  -3.58700000E-05
   +2.35400000E-05  +5.89417000E-02  -2.12393040E-01  -1.27482400E-02  +7.32199100E-02
   +4.92313830E-01  -1.60525000E-03  +5.54790000E-04  -1.14050000E-03  +1.38917000E-03
   +3.21351000E-03  +6.64440000E-04  -3.81199000E-03  -4.94083000E-03  +1.05301700E-02
   +2.74121000E-03  -8.83330000E-04  +1.23471000E-03  -1.29010000E-03  -2.21097000E-03
   -3.59780000E-04  +2.20491000E-03  +2.46030000E-04  -1.23270000E-04  +6.97671000E-02
   -1.11378680E-01  -1.13969250E-01  -9.32079500E-02  +2.27192670E-01  +3.15702480E-01
   -4.56576600E-02  +1.30673900E-02  -4.96489000E-03  +6.90792000E-03  +2.59144000E-03
   +3.52670000E-04  -1.09449300E-02  -2.37905000E-03  +1.23117000E-03  +5.09941000E-03
   -3.05335000E-03  -5.35800000E-04  -4.61162200E-02  -7.65843000E-03  -1.71272000E-03
   -3.20001400E-01  -4.11747300E-02  -7.74985000E-03  +9.96239000E-03  -1.39760000E-03
   +2.31321000E-03  -2.38183000E-03  +2.24433000E-03  -2.74780000E-03  +5.10200280E-01
   +5.13925600E-02  +5.10305000E-03  +2.95717000E-03  -6.04841000E-03  -9.82781000E-03
   +2.24262000E-03  +1.86070000E-04  +7.11776000E-03  -1.22944000E-03  +6.52219000E-03
   -8.38395000E-03  +3.00614000E-03  -4.58760800E-02  +2.77089000E-03  -1.14381000E-03
   +1.04336200E-02  -1.11507290E-01  +1.13376000E-02  -2.70440000E-04  +4.37630000E-04
   -2.32060000E-04  -2.70200000E-05  -1.86000000E-06  -3.30000000E-07  -1.48733510E-01
   +5.69911190E-01  -1.12652800E-02  +1.15185000E-03  +6.64929000E-03  +1.24025000E-03
   +2.49863000E-03  +4.49696000E-03  -5.99510000E-04  -1.35545000E-03  -9.77800000E-04
   -1.43897000E-03  +2.49543000E-03  +7.28231000E-03  +4.64856000E-03  +9.24890000E-04
   +1.09670200E-02  -1.59128400E-02  +8.64910000E-03  -4.77694500E-02  +7.59400000E-04
   -3.58530000E-04  -5.81860000E-04  -5.35400000E-05  +1.19660000E-04  +7.69000000E-05
   +4.86867800E-02  -9.39862300E-02  +4.62279700E-02  -5.60870000E-04  -1.45663000E-03
   +2.75600000E-04  -4.80646000E-03  +2.37558000E-03  -8.45180000E-04  -1.54348000E-02
   -2.95064100E-02  +9.06270000E-04  -2.04347000E-03  -6.77360000E-04  -3.76730000E-04
   +9.76300000E-05  -8.16270000E-04  +3.81480000E-04  +3.81860000E-04  -1.58410000E-04
   +7.09900000E-05  -1.21668010E-01  -5.73649300E-02  -5.07880000E-03  +1.03260700E-02
   +9.96205000E-03  +2.67802000E-03  -5.84070000E-04  +7.92000000E-06  -6.42600000E-05
   +5.79602750E-01  -1.48340000E-04  +8.14900000E-04  -5.24100000E-05  +2.97923000E-03
   +4.06620000E-04  -4.90870000E-04  -5.60935000E-03  +4.03573000E-03  -2.03799000E-03
   +1.10871000E-03  -4.90900000E-04  +1.62000000E-04  +1.53450000E-04  -1.87090000E-04
   +3.18430000E-04  +8.68200000E-05  -1.97110000E-04  +1.44810000E-04  -5.65783800E-02
   -1.90070970E-01  -1.68192100E-02  -1.07837500E-02  -2.79197100E-02  -4.77171000E-03
   -4.22500000E-05  +1.25200000E-05  -7.51000000E-05  -4.69603100E-02  +5.21630650E-01
   +4.64980000E-04  -9.09630000E-04  -1.75300000E-04  -1.28185000E-03  +1.39030000E-04
   +1.96034000E-03  +1.77763000E-03  -2.54672000E-03  +5.82211000E-03  -7.18310000E-04
   +2.26810000E-04  -1.40505000E-03  +1.58590000E-04  -3.85400000E-05  -4.88430000E-04
   -3.08900000E-04  +2.60940000E-04  +7.20200000E-05  -9.64035000E-03  -1.93566300E-02
   -6.66930700E-02  -3.50166000E-03  -1.24374600E-02  +6.93724000E-03  +2.83610000E-04
   -6.35000000E-05  +1.16010000E-04  +7.47880000E-04  +2.84395900E-02  +5.59768240E-01
   +9.82700000E-04  +6.30490000E-04  -5.77000000E-05  -8.40000000E-06  +1.31300000E-04
   -2.31914000E-03  -6.99925000E-03  +5.33676000E-03  -1.26672900E-02  +2.23469000E-03
   -2.90634000E-03  -1.31702000E-03  -2.44004000E-03  -1.12352000E-03  +9.57160000E-04
   +1.90000000E-03  +1.86182000E-03  +3.62300000E-05  -2.74435900E-02  +5.97349000E-03
   +1.45812200E-02  +1.61756500E-02  -3.18061000E-03  +3.86690100E-02  -2.40608000E-03
   -8.04300000E-05  -2.38860000E-04  -6.40020000E-04  -3.20564000E-03  +5.21101000E-03
   +3.21915480E-01  +2.00500000E-04  +5.86300000E-05  -2.61190000E-04  -5.64240000E-04
   -1.87528000E-03  +4.17570000E-04  +5.41068000E-03  -2.26171000E-03  +7.68458000E-03
   -4.43040000E-04  +1.15871000E-03  +1.04077000E-03  +4.67820000E-04  +7.01170000E-04
   -7.18570000E-04  -5.57920000E-04  -5.37640000E-04  -5.03000000E-06  +1.97436500E-02
   -2.56622800E-02  -5.06473800E-02  -8.35392000E-03  +3.68219800E-02  -4.59856300E-02
   +6.99460000E-04  +1.63220000E-04  +1.41380000E-04  +1.72764000E-03  -5.68506000E-03
   +1.16518100E-02  +8.84149700E-02  +7.50645500E-02  -1.40282000E-03  +1.45226000E-03
   -3.62900000E-05  +1.08703000E-03  +2.60774000E-03  +9.26000000E-04  -1.31126400E-02
   +5.14526000E-03  -9.73014000E-03  +2.24861000E-03  -3.96966000E-03  -1.03973000E-03
   -3.28122000E-03  -1.75747000E-03  +9.57600000E-04  +3.32945000E-03  +1.27379000E-03
   -3.10430000E-04  +7.73120000E-03  -8.63157000E-03  +1.86042700E-02  +1.12720500E-02
   -8.52512000E-03  -6.28600900E-02  -4.17196000E-03  -1.38200000E-05  -1.07180000E-04
   +1.46680000E-04  +7.56197000E-03  -1.31932100E-02  -2.55438470E-01  -6.35882400E-02
   +2.96048070E-01  -6.87291000E-03  -2.84007000E-03  +2.24000000E-05  +5.28050000E-04
   +2.07141000E-03  -5.10450000E-04  +7.37770000E-04  -8.53290000E-04  +1.18800000E-04
   -9.38310000E-04  +5.71680000E-04  -6.84100000E-05  +3.69181000E-03  +1.33435000E-03
   +1.45600000E-05  -2.57016000E-02  +4.73487400E-02  -8.77762000E-03  -7.24210000E-04
   -7.41000000E-06  -1.49270000E-04  +2.38340000E-04  -1.98950000E-04  +1.96590000E-04
   -1.06509760E-01  +1.33778870E-01  -2.65229600E-02  +8.30700000E-05  +4.60000000E-07
   +2.29700000E-05  +2.58200000E-04  -6.97400000E-05  +3.85400000E-04  +1.35860760E-01
   -1.42386000E-03  +2.26270000E-03  -4.22800000E-05  +4.96260000E-04  -5.13100000E-05
   +3.63180000E-04  -9.38300000E-04  -9.99800000E-05  +1.38330000E-04  +4.22060000E-04
   -1.09059000E-03  +2.66000000E-06  -5.70785000E-03  +3.63733000E-03  -1.08979000E-03
   -1.42433000E-03  +1.50610000E-04  -4.66930000E-04  +8.98250000E-04  -1.65660000E-04
   +1.90710000E-04  -1.60780000E-04  +1.87540000E-04  -2.34860000E-04  +1.86560240E-01
   -4.60198630E-01  +8.20279700E-02  -2.58800000E-05  -9.81000000E-06  +5.36300000E-05
   -1.74440000E-04  +4.96700000E-05  -3.17790000E-04  -1.78920240E-01  +4.56006410E-01
   -3.33730000E-04  -5.20700000E-05  +2.63424000E-03  -1.02170000E-04  +4.00670000E-04
   +1.55033000E-03  +1.51800000E-04  +2.41600000E-05  +5.48400000E-05  -2.42800000E-05
   +6.17500000E-05  -6.82450000E-04  +1.12373000E-03  -7.38210000E-04  -9.77790000E-04
   -1.04508000E-03  +2.06256000E-03  -2.97523000E-03  -1.99000000E-04  +6.68000000E-06
   -2.15000000E-05  +7.76700000E-05  -3.39500000E-05  +5.10900000E-05  -3.48215000E-02
   +7.92417800E-02  -1.90127000E-02  +7.43000000E-06  +9.09000000E-06  +1.70000000E-07
   +7.69100000E-05  -5.09000000E-05  -4.07100000E-05  +3.52260900E-02  -8.09100600E-02
   +1.96641400E-02  -7.95520000E-04  -3.35737000E-03  +2.31030000E-04  -1.02735000E-03
   -7.97790000E-04  +1.20180000E-04  -5.30528000E-03  -1.54461000E-03  -7.28470000E-04
   -1.05177600E-02  +2.91201200E-02  -5.52057000E-03  -1.24292830E-01  +1.13933830E-01
   -2.40458800E-02  +8.12456000E-03  -1.39545500E-02  +2.54782000E-03  +2.03070000E-04
   +1.48668000E-03  -1.95800000E-05  -4.64440000E-04  -9.25000000E-05  +2.40700000E-05
   +3.61906000E-03  -6.48320000E-04  +4.94240000E-04  +9.78000000E-06  +5.71000000E-05
   -4.90500000E-05  -1.70810000E-04  +3.25900000E-05  -3.57510000E-04  -5.20670000E-04
   +8.44120000E-04  -1.88980000E-04  +1.29758330E-01  -3.99041000E-03  -3.32962000E-03
   +1.28123000E-03  -1.30498000E-03  -5.40000000E-07  -2.49960000E-04  -6.66650000E-04
   +2.30347000E-03  +7.22780000E-04  -1.90202000E-03  +3.82442000E-03  -3.97140000E-04
   +1.14171630E-01  -2.63739390E-01  +4.50369500E-02  +1.90100600E-02  -1.79210000E-02
   +4.70815000E-03  -3.60320000E-04  +1.35150000E-04  -9.05000000E-06  +3.06500000E-05
   -4.67300000E-05  +6.04700000E-05  +1.55300000E-04  +2.57708000E-03  -1.10428000E-03
   +4.84400000E-05  -1.45000000E-05  +6.27000000E-06  +7.03100000E-05  -1.17200000E-05
   +1.24190000E-04  -2.11250000E-03  -1.01153000E-03  +1.69470000E-04  -1.24320620E-01
   +2.77565350E-01  +2.81370000E-04  +1.22438000E-03  +5.46702000E-03  +1.23660000E-04
   -3.16220000E-04  -1.03724000E-03  -1.95620000E-04  +7.60500000E-04  +6.86997000E-03
   -4.35150000E-04  +1.54664000E-03  +1.82772000E-03  -2.40694600E-02  +4.50363000E-02
   -4.16471000E-02  -2.98827000E-03  +2.82163000E-03  +3.43333000E-03  -2.54740000E-04
   +2.22070000E-04  +4.96780000E-04  -1.55450000E-04  -4.52800000E-05  -4.02800000E-05
   +4.64980000E-04  -1.12811000E-03  -3.78082000E-03  -4.14600000E-05  -4.19800000E-05
   -3.59300000E-05  +1.45140000E-04  -9.56500000E-05  +7.37500000E-05  +3.08030000E-04
   +3.16510000E-04  +5.24400000E-04  +2.67142800E-02  -4.95372300E-02  +3.27423700E-02
   -8.50900000E-04  +7.40250000E-04  -9.58200000E-05  -1.10974000E-03  +3.34962000E-03
   -9.89090000E-04  +1.21098700E-02  +1.28002600E-02  -1.70985000E-03  -1.24111090E-01
   -1.18769720E-01  +1.55609600E-02  -1.08373600E-02  -2.83022900E-02  +3.84299000E-03
   -4.88759000E-03  +1.24878000E-03  -9.80010000E-04  +7.43110000E-04  +2.95570000E-04
   +8.11100000E-05  +5.10200000E-05  -2.07410000E-04  +3.00100000E-05  -1.27751000E-03
   -1.44384000E-03  +1.91310000E-04  -1.04163000E-03  +5.92030000E-04  -1.63300000E-04
   -1.28120000E-04  -1.67630000E-04  +2.89860000E-04  +2.33540000E-04  -1.82710000E-04
   +4.23800000E-05  +8.69230000E-04  +3.01420000E-04  +2.58590000E-04  +1.31874470E-01
   +8.66700000E-04  +3.20480000E-04  -1.95790000E-04  +3.75787000E-03  -3.32376000E-03
   +1.68767000E-03  -1.46260100E-02  -1.73618100E-02  +2.68303000E-03  -1.18250340E-01
   -2.75137280E-01  +3.20275800E-02  +2.22766000E-03  +3.62570000E-03  +3.55910000E-04
   +9.60960000E-04  +1.96322000E-03  +1.01229000E-03  -2.08028000E-03  -8.54370000E-04
   -7.72420000E-04  +1.83010000E-04  +1.61670000E-04  -1.97700000E-05  -9.81400000E-05
   +3.17800000E-05  -8.46300000E-05  -9.69100000E-04  +3.92770000E-04  -3.02050000E-04
   +1.78570000E-04  +2.62030000E-04  -1.48400000E-05  +3.62400000E-05  -2.51300000E-05
   +1.15200000E-05  -1.82850000E-04  +7.25920000E-04  -8.37510000E-04  +1.28986690E-01
   +2.89105800E-01  -1.71140000E-04  -1.05300000E-04  -1.25971000E-03  -9.36730000E-04
   +1.91318000E-03  +6.11507000E-03  +4.05330000E-03  +4.02655000E-03  +3.71590000E-03
   +1.45654500E-02  +3.28434700E-02  -4.34083300E-02  -1.23194000E-03  -1.64145000E-03
   +4.40413000E-03  -9.27320000E-04  +1.06314000E-03  +7.65977000E-03  +1.96560000E-04
   -1.06190000E-03  -3.38867000E-03  +2.53840000E-04  -2.27750000E-04  +2.12630000E-04
   -1.02710000E-04  -1.30760000E-04  -2.10670000E-04  -2.99500000E-04  +2.23600000E-05
   +1.26913000E-03  -2.59510000E-04  +1.48560000E-04  -4.41550000E-04  +1.07000000E-06
   -2.04100000E-05  +5.59000000E-06  +3.64670000E-04  -8.12570000E-04  -4.16651000E-03
   -1.54991600E-02  -3.56292300E-02  +3.12411200E-02  -1.07835200E-02  +2.81410800E-02
   -5.81986000E-03  -1.25702710E-01  +1.17162890E-01  -2.66893300E-02  +1.22620800E-02
   -1.32439100E-02  +2.90057000E-03  -1.19460000E-03  -3.50583000E-03  +1.13710000E-04
   -8.24660000E-04  -6.83610000E-04  +1.04030000E-04  -4.70507000E-03  -1.43954000E-03
   -3.70620000E-04  +7.57490000E-04  -2.73000000E-04  +1.62750000E-04  -1.23293000E-03
   +6.09800000E-05  +3.14770000E-04  -8.14030000E-04  +1.56871000E-03  -3.08230000E-04
   +1.09810000E-04  +7.22600000E-05  -2.92000000E-06  -2.29660000E-04  +3.14390000E-04
   +1.97920000E-04  -4.26610000E-04  +2.08700000E-05  -2.45800000E-05  +2.55000000E-05
   +7.12200000E-05  +3.59200000E-05  +5.20960000E-04  -8.30810000E-04  +2.01990000E-04
   +1.33291750E-01  -2.58631000E-03  +4.49503000E-03  -7.95000000E-05  +1.16720320E-01
   -2.68242200E-01  +4.84490300E-02  +1.46273200E-02  -1.74865000E-02  +4.78821000E-03
   -3.87932000E-03  -3.40682000E-03  +1.44964000E-03  -7.71330000E-04  +4.03900000E-04
   -3.39080000E-04  -1.23729000E-03  +1.78675000E-03  +1.28628000E-03  +2.19612000E-03
   -1.03481000E-03  -1.36760000E-04  +2.40390000E-04  +4.70640000E-04  -6.51280000E-04
   +1.03610000E-04  +5.49500000E-05  -1.56600000E-05  -9.19300000E-05  +1.16070000E-04
   -1.22460000E-04  +5.45540000E-04  +7.86570000E-04  -1.00140000E-04  -7.88700000E-05
   +3.94400000E-05  -6.20600000E-05  +1.01260000E-04  -4.39100000E-05  -1.02460000E-04
   +8.11640000E-04  -9.72380000E-04  +2.09110000E-04  -1.26443250E-01  +2.81667150E-01
   -5.84100000E-05  +1.17339000E-03  +4.74528000E-03  -2.60491100E-02  +4.98115500E-02
   -5.11875100E-02  -4.08679000E-03  +2.47480000E-03  +3.63555000E-03  +4.02810000E-04
   +1.28873000E-03  +5.86950000E-03  +1.13430000E-04  -2.46120000E-04  -1.21756000E-03
   -3.38880000E-04  +1.27876000E-03  +8.55739000E-03  +5.65440000E-04  -1.16196000E-03
   -2.14121000E-03  +8.20780000E-04  +4.30390000E-04  +8.71040000E-04  -2.58200000E-05
   +4.14000000E-06  -9.99800000E-05  +4.59700000E-05  -7.42100000E-05  -8.19700000E-05
   +5.36490000E-04  +5.04150000E-04  -1.11185000E-03  +2.88100000E-05  -5.19900000E-05
   -2.89450000E-04  +1.55300000E-05  -9.94700000E-05  -6.54680000E-04  -1.36000000E-04
   +1.80300000E-04  +1.75300000E-04  +2.80377900E-02  -5.37930100E-02  +3.85487800E-02
   -1.32185640E-01  -1.23918190E-01  +1.68786300E-02  -1.03433800E-02  -2.79587600E-02
   +4.18757000E-03  -4.91474000E-03  +1.34844000E-03  -6.00230000E-04  -9.05590000E-04
   +7.89700000E-04  -1.20630000E-04  -1.29132000E-03  +3.00347000E-03  -8.27050000E-04
   +1.11585600E-02  +1.41804200E-02  -2.18350000E-03  +3.73200000E-05  -1.60744000E-03
   +1.61890000E-04  -7.53600000E-05  +1.30380000E-04  -1.25610000E-04  +1.29626000E-03
   -7.46240000E-04  +3.66990000E-04  -4.18150000E-04  +2.00030000E-04  -9.02200000E-05
   +1.30700000E-05  +4.19800000E-05  -1.81970000E-04  +1.05960000E-04  -2.12240000E-04
   +6.70300000E-05  +5.20250000E-04  +8.33830000E-04  -8.76700000E-05  +2.18000000E-05
   -9.03100000E-05  +4.80200000E-05  +9.34810000E-04  +2.91340000E-04  +1.90870000E-04
   +1.36123950E-01  -1.22376820E-01  -2.68232050E-01  +3.46107800E-02  +2.33958000E-03
   +4.97077000E-03  -2.58340000E-04  +7.65110000E-04  +2.05699000E-03  +1.11620000E-03
   +1.29402000E-03  +9.86400000E-05  -1.37010000E-04  +3.54795000E-03  -3.13724000E-03
   +1.62926000E-03  -1.80711800E-02  -1.82350200E-02  +3.18583000E-03  +2.89650000E-04
   +1.10480000E-04  +1.27250000E-04  -5.46200000E-05  +2.09400000E-05  -4.86300000E-05
   -4.85860000E-04  +1.82006000E-03  -9.06270000E-04  +2.64300000E-05  +2.74900000E-05
   -2.44500000E-05  -6.33100000E-05  +2.47000000E-06  -1.50240000E-04  -9.99800000E-05
   +3.46570000E-04  -1.69350000E-04  -6.53460000E-04  -9.88050000E-04  +1.01170000E-04
   -5.36900000E-05  -3.45200000E-05  -1.16100000E-04  -2.72990000E-04  +6.18560000E-04
   -9.64450000E-04  +1.33868310E-01  +2.80576800E-01  +1.63977200E-02  +3.47780400E-02
   -4.12590500E-02  -7.94560000E-04  -1.36719000E-03  +2.94715000E-03  -1.12337000E-03
   +8.95860000E-04  +7.86764000E-03  -2.90460000E-04  -1.27310000E-04  -9.87620000E-04
   -8.57980000E-04  +1.57503000E-03  +5.05307000E-03  +3.59037000E-03  +4.44028000E-03
   +4.32958000E-03  +1.47150000E-04  -1.43630000E-04  +6.42430000E-04  +6.57300000E-05
   -2.80800000E-05  -1.02330000E-04  +1.69300000E-04  -8.91250000E-04  -3.11441000E-03
   +2.86000000E-06  +5.63200000E-05  -2.09320000E-04  +1.96100000E-05  -4.43600000E-05
   -1.89340000E-04  +6.17600000E-05  -1.78170000E-04  -4.86870000E-04  +1.35270000E-04
   +1.97190000E-04  -1.08810000E-04  +4.80000000E-05  -1.04820000E-04  -6.65110000E-04
   +3.54270000E-04  -1.01922000E-03  -4.71200000E-03  -1.79930100E-02  -3.80753400E-02
   +3.09039800E-02  +5.44200000E-05  +7.11400000E-05  -2.90500000E-05  +2.66760000E-04
   +9.77000000E-05  +1.83780000E-04  -2.06440000E-04  +1.38260000E-04  -1.29420000E-04
   -1.04158000E-03  -3.73850000E-04  -7.25470000E-04  -1.37310000E-04  -6.13800000E-05
   +1.82300000E-05  -7.93200000E-05  +5.84900000E-05  +2.07200000E-05  +8.61084000E-03
   -9.02994000E-03  -1.20349200E-02  -1.10297000E-03  -2.45496000E-03  +1.17864000E-03
   +8.20600000E-05  +9.63000000E-06  +2.05200000E-05  -1.01122480E-01  +7.39614800E-02
   +7.96616200E-02  -3.87580000E-04  -1.50700000E-04  -3.83530000E-04  -2.38600000E-05
   -1.56000000E-06  -6.58000000E-06  +8.31000000E-06  -1.17600000E-05  -4.30400000E-05
   -1.28211000E-03  -2.11240000E-04  -9.62600000E-04  +3.48800000E-05  +2.12600000E-05
   -4.66400000E-05  +2.16800000E-05  +3.10000000E-07  -1.52700000E-05  +1.06655030E-01
   +3.35450000E-04  -6.86000000E-05  -1.98200000E-05  -3.22200000E-04  -3.03130000E-04
   +3.59580000E-04  +1.23683000E-03  +7.85450000E-04  +7.80240000E-04  +3.80030000E-04
   +2.50020000E-04  +1.52230000E-04  -3.19670000E-04  +1.37490000E-04  +7.69900000E-05
   -7.21100000E-05  +3.00570000E-04  -8.32200000E-05  +1.44455700E-02  -1.98482800E-02
   -1.93305500E-02  -3.71554000E-03  -3.58974000E-03  -4.36540000E-04  +1.29540000E-04
   -5.01000000E-06  -9.15000000E-06  +7.16898300E-02  -1.51269550E-01  -1.12820340E-01
   -8.46120000E-04  +1.90066000E-03  +1.47314000E-03  -2.37500000E-05  +6.94000000E-06
   -9.40000000E-07  -1.97000000E-06  -1.06900000E-05  +5.08000000E-06  +2.61000000E-05
   +4.58530000E-04  -1.46880000E-04  +7.29200000E-05  +7.62800000E-05  -3.19600000E-05
   +6.59000000E-06  -1.16400000E-05  -4.30000000E-05  -7.78990500E-02  +1.65676370E-01
   +1.33000000E-05  +1.37780000E-04  -3.87400000E-05  -7.37300000E-05  +9.67500000E-05
   +1.06970000E-04  -1.67270000E-04  +1.14220000E-04  -1.12970000E-04  +5.99900000E-05
   -1.06877000E-03  +4.23690000E-04  -1.99400000E-05  +4.68950000E-04  -4.22300000E-05
   +7.74200000E-05  -8.18100000E-05  -1.04600000E-05  +1.05166000E-03  +2.98668000E-03
   -1.30487000E-03  +1.29860000E-04  -2.51380000E-04  +2.51134000E-03  +3.87200000E-05
   +8.06100000E-05  -2.14700000E-05  +7.74981600E-02  -1.17394960E-01  -1.68858550E-01
   -3.96470000E-04  +1.14070000E-03  +2.00620000E-04  -3.91500000E-05  -1.53500000E-05
   +3.71000000E-06  -1.92900000E-05  -1.84800000E-05  +2.63600000E-05  -7.18390000E-04
   +3.99790000E-04  -5.99610000E-04  +5.06200000E-05  +8.26600000E-05  -3.62200000E-05
   -2.85000000E-06  +5.49000000E-06  -1.25600000E-05  -8.54097100E-02  +1.24729490E-01
   +1.79189790E-01  -1.30380000E-04  -2.68190000E-04  +1.07850000E-04  -5.96520000E-04
   +4.21720000E-04  -1.93820000E-04  +3.39840000E-04  -2.62495000E-03  -2.72680000E-04
   +2.86020000E-04  -1.90100000E-05  -2.42300000E-05  +4.43000000E-05  -7.86400000E-05
   -8.80300000E-05  +1.45920000E-04  -4.74000000E-05  +1.27000000E-05  -1.80715900E-02
   +1.84810000E-03  -3.97290000E-03  +1.43414000E-03  +1.64511000E-03  +1.34893000E-03
   -1.77120000E-04  -4.12000000E-06  +1.00500000E-05  -2.98217810E-01  +4.39620000E-02
   -7.17924700E-02  +1.04169000E-03  +3.65770000E-04  -1.11520000E-04  +3.42200000E-05
   -3.84000000E-06  -1.93000000E-06  -3.02400000E-05  +1.26500000E-05  -1.03500000E-05
   +1.22510000E-04  -1.82870000E-04  +2.18140000E-04  +7.51000000E-06  -9.12000000E-05
   -1.44400000E-05  -7.84700000E-05  +6.94000000E-06  +1.10200000E-05  -1.06954200E-02
   +1.25217000E-03  -3.82463000E-03  +3.21717840E-01  -1.15470000E-04  -3.80320000E-04
   +8.32300000E-05  -1.53103000E-03  +5.43250000E-04  +4.33700000E-05  -9.99190000E-04
   -5.30133000E-03  +4.97010000E-04  +6.61660000E-04  -1.00779000E-03  +2.35970000E-04
   -6.98600000E-05  +3.78270000E-04  -1.08600000E-04  +1.34080000E-04  -8.11700000E-05
   -1.28100000E-05  -3.10132800E-02  +4.35221000E-03  -7.83032000E-03  -6.99670000E-04
   -4.51040000E-04  +1.45931000E-03  -2.49500000E-05  +6.64100000E-05  +7.05000000E-06
   +4.83195800E-02  -5.43022400E-02  +1.04223900E-02  -4.04910000E-04  +5.40880000E-04
   -2.94530000E-04  -1.84100000E-05  -6.72000000E-06  -1.85000000E-06  -3.39900000E-05
   -4.29000000E-06  +6.72000000E-06  +8.02500000E-05  +5.26630000E-04  -8.13800000E-05
   +1.70200000E-05  +4.98000000E-06  -1.13000000E-05  -1.26920000E-04  +4.17000000E-06
   -3.41000000E-05  +1.77897100E-02  -2.96440000E-03  +6.82534000E-03  -4.60026300E-02
   +6.11773200E-02  -5.54500000E-05  +5.08500000E-05  -1.30630000E-04  +1.37790000E-04
   +2.12270000E-04  +3.54080000E-04  -2.43900000E-05  +7.30500000E-05  +9.22400000E-04
   +2.82260000E-04  -1.01340000E-04  +2.05360000E-04  -6.91100000E-05  -4.16000000E-06
   +1.44160000E-04  +1.08880000E-04  -2.28900000E-05  +1.28700000E-05  +7.64340000E-04
   +3.24735000E-03  -1.83191000E-03  -4.03900000E-04  -4.91910000E-04  +1.75860000E-04
   -1.08220000E-04  +7.38000000E-06  -3.83200000E-05  -7.34989700E-02  +8.32643000E-03
   -6.51865900E-02  +5.71180000E-04  -5.40970000E-04  -7.00340000E-04  +5.91000000E-06
   -1.02400000E-05  +9.76000000E-06  -4.63000000E-06  +4.46000000E-06  +1.53400000E-05
   -1.37300000E-05  -1.21200000E-05  -4.09100000E-04  +9.10000000E-06  +1.87000000E-06
   +5.04300000E-05  +3.22000000E-06  -7.92000000E-06  -5.67700000E-05  +2.09883800E-02
   -2.57367000E-03  +6.40785000E-03  +7.86036800E-02  -1.16679100E-02  +6.73300700E-02
   -2.00790000E-04  +2.86280000E-04  +7.60400000E-05  +3.20790000E-04  +1.47450000E-04
   -3.52410000E-04  -9.43250000E-04  +7.09100000E-05  -1.27888000E-03  -3.76330000E-04
   -6.74530000E-04  +1.39750000E-04  +1.78300000E-05  +2.42840000E-04  +7.36100000E-05
   +7.87600000E-05  -1.85500000E-04  +7.63700000E-05  -3.38030000E-04  -6.28123000E-03
   +1.48321400E-02  +4.63100000E-05  +6.99050000E-04  -7.28280000E-04  -3.23100000E-05
   +5.88300000E-05  -5.46200000E-05  -4.45209900E-02  -1.17005000E-03  +8.89870000E-04
   +3.38010000E-04  -1.67373000E-03  +6.78870000E-04  -3.18600000E-05  -1.87200000E-05
   +7.23000000E-06  -8.96000000E-06  -8.11000000E-06  +4.25000000E-06  -1.07566000E-03
   +3.06610000E-04  +2.97690000E-04  +2.56600000E-05  +6.18200000E-05  -2.68900000E-05
   +1.09400000E-05  +8.40000000E-06  +3.44500000E-05  -6.75740000E-04  -6.93136000E-03
   +1.16656000E-02  +2.19781000E-03  +1.31182300E-02  -2.75849100E-02  +4.54211800E-02
   +1.47900000E-04  +8.27900000E-05  +6.95800000E-05  -9.25000000E-05  -3.37150000E-04
   -3.66030000E-04  -1.93900000E-04  +2.68750000E-04  -6.67900000E-04  +1.56780000E-04
   +1.86670000E-04  -7.12300000E-05  -2.99550000E-04  -1.02400000E-04  -6.00000000E-08
   +2.53500000E-05  +2.28290000E-04  -5.17000000E-06  +2.27324000E-03  -1.24796800E-02
   +2.67687300E-02  -8.21170000E-04  -8.42750000E-04  -1.68983000E-03  -3.32100000E-05
   -1.04900000E-05  -2.03200000E-05  -3.93570000E-04  -9.45729200E-02  +1.00219350E-01
   -1.75843000E-03  -4.34000000E-04  +2.30959000E-03  -4.46000000E-06  -5.55000000E-06
   +5.05000000E-06  +3.21000000E-06  +4.40000000E-07  +5.69000000E-06  -6.52100000E-05
   +1.47490000E-04  -5.09900000E-05  +3.52700000E-05  +7.34000000E-05  +5.76000000E-06
   +1.03900000E-05  -3.60000000E-07  +5.17500000E-05  -1.01044000E-03  +9.96420000E-03
   -1.78666700E-02  -3.41240000E-04  -2.76644000E-03  +3.69537000E-03  +1.50292000E-03
   +1.00501560E-01  -1.32070000E-04  +7.11300000E-05  +1.77900000E-05  +3.65360000E-04
   +6.61200000E-05  -5.15000000E-05  -6.35590000E-04  +4.11000000E-04  +6.57600000E-05
   -4.44040000E-04  +6.04620000E-04  +1.04980000E-04  +4.18700000E-05  -2.78060000E-04
   +2.49680000E-04  -3.87100000E-05  -5.84100000E-05  +7.72000000E-06  +9.26360000E-04
   +1.15286000E-03  -7.14500000E-04  +5.81590000E-04  -1.17034000E-03  +1.85689000E-03
   -4.52700000E-05  -4.32400000E-05  -4.04300000E-05  -1.13240000E-03  +9.69728300E-02
   -2.58333520E-01  +3.07340000E-04  +1.58440000E-03  +1.77366000E-03  +1.78400000E-05
   +4.03000000E-06  +2.50000000E-06  +1.67500000E-05  +1.32400000E-05  -4.83000000E-06
   +1.38240000E-04  -3.88720000E-04  -2.52380000E-04  -1.30900000E-05  -3.41100000E-05
   -4.35000000E-06  +1.70600000E-05  -3.42000000E-06  -1.75000000E-06  -1.46982000E-03
   +9.58200000E-03  -1.68243500E-02  +8.83340000E-04  +2.56237000E-03  -7.24168000E-03
   +5.69120000E-04  -1.11134430E-01  +2.82084520E-01  +1.57990000E-04  -3.82200000E-05
   +1.16910000E-04  -1.34424000E-03  +5.36380000E-04  +8.33180000E-04  -5.35770000E-04
   +3.44960000E-04  -3.31400000E-05  +5.26340000E-04  -3.66700000E-04  -2.52400000E-05
   -2.33120000E-04  -1.61190000E-04  +9.49000000E-05  -1.13510000E-04  +3.03830000E-04
   -9.61000000E-05  +1.10571700E-02  +1.26548600E-02  +8.29595000E-03  -1.25300960E-01
   -1.08537060E-01  -6.77038200E-02  +8.65900000E-05  -3.58400000E-05  -1.65500000E-05
   -1.56552000E-03  +1.59908000E-03  +1.87140000E-04  -1.04010000E-04  +1.21190000E-04
   +6.13920000E-04  -1.48900000E-05  -2.46000000E-06  -1.39700000E-05  +1.61600000E-05
   -1.21400000E-05  +2.60000000E-06  +3.04700000E-05  -1.52100000E-05  +1.94600000E-05
   -1.43811000E-03  +1.23200000E-04  +8.25610000E-04  +5.71000000E-06  +7.12000000E-06
   +7.09500000E-05  +4.56770000E-04  +5.21030000E-04  -1.51000000E-05  +3.41080000E-04
   +1.02570000E-04  +1.73860000E-04  +5.63900000E-05  +2.04390000E-04  +6.54200000E-05
   +1.28960250E-01  +5.48070000E-04  +6.26300000E-05  +3.04810000E-04  -7.13800000E-04
   +7.27080000E-04  +3.82280000E-04  -2.56260000E-03  +6.90020000E-04  +2.21769000E-03
   +9.22940000E-04  -6.44380000E-04  +3.90550000E-04  -7.71630000E-04  -4.45910000E-04
   -1.31330000E-04  +3.21050000E-04  +7.43700000E-04  -9.70500000E-05  -1.30095000E-02
   -2.15743600E-02  -1.50858200E-02  -1.01678120E-01  -1.84138450E-01  -1.10369840E-01
   -4.65680000E-04  -4.37100000E-05  -4.48300000E-05  +3.61410000E-03  -2.10656000E-03
   -3.91353000E-03  -7.04690000E-04  -2.04714000E-03  +1.38767000E-03  +5.34200000E-05
   -4.12500000E-05  -2.37900000E-05  -1.23300000E-05  -4.42000000E-06  -3.93500000E-05
   -8.26500000E-05  +8.81800000E-05  +3.96100000E-05  -5.93720000E-04  +4.14720000E-04
   -1.88940000E-04  -1.33100000E-05  -1.91800000E-05  +7.00000000E-07  -4.58570000E-04
   -1.61123000E-03  +2.39540000E-04  +1.59470000E-04  +4.15480000E-04  +1.80430000E-04
   -5.84000000E-06  +2.21650000E-04  +2.37160000E-04  +1.11739340E-01  +2.04774250E-01
   -2.05000000E-06  +4.56340000E-04  -9.68800000E-05  +1.76050000E-04  -1.63327000E-03
   +3.62450000E-04  +1.13993000E-03  +3.73500000E-04  -2.38866000E-03  -3.23860000E-04
   +4.85020000E-04  +4.56000000E-05  +3.16070000E-04  +4.86890000E-04  +5.08200000E-05
   -4.01990000E-04  -3.82620000E-04  -7.22700000E-05  -8.90169000E-03  +7.11383000E-03
   +4.09072000E-03  -6.53180500E-02  -1.24921650E-01  -1.02429130E-01  +4.36360000E-04
   +1.02870000E-04  +1.41200000E-05  -2.44880000E-04  +5.23530000E-04  +4.32802000E-03
   +2.89208000E-03  +3.76346000E-03  -5.07236000E-03  -4.45400000E-05  +4.51800000E-05
   +6.65000000E-06  +2.62600000E-05  -1.33000000E-06  -9.70000000E-06  -4.39500000E-05
   +5.78000000E-05  -9.01500000E-05  +1.18577000E-03  +5.74590000E-04  -5.05260000E-04
   +5.27500000E-05  +7.30000000E-07  +5.94100000E-05  +9.41600000E-05  +6.07570000E-04
   +4.59100000E-05  +1.23750000E-04  -8.49000000E-06  -2.01040000E-04  -1.41760000E-04
   -1.10056000E-03  -3.17990000E-04  +7.18441300E-02  +1.19644710E-01  +1.07425570E-01
   +2.27560000E-04  -6.64000000E-06  +1.39060000E-04  -5.05000000E-05  -3.47800000E-05
   -1.12840000E-04  +1.45140000E-04  +2.48532000E-03  +1.78780000E-03  -3.12760000E-04
   -4.40830000E-04  +2.72270000E-04  -2.90910000E-04  +1.08930000E-04  -2.33130000E-04
   +1.70870000E-04  +2.57460000E-04  +7.22000000E-06  -1.61083900E-02  -3.18580000E-03
   +6.52984000E-03  -2.97613120E-01  -4.63252900E-02  +8.69554200E-02  -2.18520000E-04
   -7.62000000E-06  -2.34600000E-05  +1.35422000E-03  -1.85439000E-03  -2.12666000E-03
   -6.63560000E-04  +9.31980000E-04  -6.93590000E-04  +3.38800000E-05  -1.13600000E-05
   -5.25000000E-06  -7.93700000E-05  -4.22000000E-06  -4.71300000E-05  -1.59900000E-05
   +1.08040000E-04  +7.05600000E-05  +1.09730000E-04  +9.41000000E-05  -2.52290000E-04
   -1.73600000E-05  -9.97000000E-06  +7.27000000E-06  +2.93150000E-04  -4.61560000E-04
   -1.62430000E-04  +4.20150000E-04  +4.78990000E-04  +2.79810000E-04  -1.43090000E-04
   +5.58490000E-04  -7.95900000E-05  -9.14558000E-03  -9.38500000E-05  +4.80758000E-03
   +3.19653050E-01  -1.53540000E-04  +4.05230000E-04  -1.31590000E-04  -1.87490000E-04
   -5.94900000E-04  +5.29330000E-04  +1.07228000E-03  -4.43308000E-03  -2.09422000E-03
   +1.10379000E-03  +4.88610000E-04  +7.03200000E-05  +2.06230000E-04  -1.37840000E-04
   +2.69450000E-04  -3.82000000E-05  -3.16340000E-04  -5.90700000E-05  +2.94226100E-02
   +2.87227000E-03  -1.08730200E-02  -5.63081100E-02  -5.27072300E-02  +3.26029000E-03
   +1.11400000E-05  +7.94800000E-05  +7.80000000E-07  +1.34652000E-03  +9.72660000E-04
   +1.41273000E-03  +1.42294000E-03  -5.40400000E-05  +4.82350000E-04  -9.44000000E-06
   +2.38000000E-06  +1.01200000E-05  +1.10390000E-04  +5.93000000E-06  +1.13200000E-05
   +1.79900000E-05  -3.05000000E-05  -1.00120000E-04  +7.47400000E-05  +4.75620000E-04
   -1.26200000E-04  +2.54400000E-05  +2.18000000E-06  +1.97200000E-05  +2.66300000E-05
   +4.21770000E-04  +1.78220000E-04  -1.97090000E-04  -1.54030000E-04  -5.66490000E-04
   -5.49000000E-06  -3.02190000E-04  +1.12820000E-04  -1.75183700E-02  -1.92806000E-03
   +9.54251000E-03  +4.73798700E-02  +5.64904600E-02  +4.94230000E-04  -1.45790000E-04
   +1.81080000E-04  -7.59150000E-04  -2.61960000E-04  -7.17300000E-05  -9.35050000E-04
   -1.38440000E-04  +3.28180000E-03  +4.99750000E-04  +2.11770000E-04  +2.56980000E-04
   -1.86240000E-04  -2.02150000E-04  -3.23140000E-04  -2.33650000E-04  +3.57210000E-04
   -2.12400000E-05  -1.64514000E-03  +8.19083000E-03  +5.31605000E-03  +9.71356600E-02
   -2.92728000E-03  -5.72878800E-02  +2.20680000E-04  -2.39700000E-05  +8.46000000E-06
   +9.96220000E-04  -6.87600000E-05  -2.21576000E-03  -3.16932000E-03  +7.68620000E-04
   -5.63976000E-03  -2.38100000E-05  +1.12800000E-05  -1.90100000E-05  +4.47300000E-05
   -1.08400000E-05  -4.64600000E-05  -4.19600000E-05  +3.36500000E-05  +1.44900000E-04
   -1.17580000E-04  +2.96000000E-06  -2.93670000E-04  +2.76800000E-05  -2.05000000E-06
   +1.89000000E-06  -4.01420000E-04  -3.69920000E-04  -2.20420000E-04  -5.04750000E-04
   -7.47480000E-04  -2.59070000E-04  -8.59900000E-05  +2.82460000E-04  -2.17340000E-04
   -1.51321400E-02  -5.65560000E-04  +4.57222000E-03  -9.42549700E-02  -4.83496000E-03
   +6.13080200E-02  -1.94410000E-04  -1.20720000E-04  -2.47510000E-04  -3.99800000E-04
   +1.34669000E-03  +6.99640000E-04  -1.13546000E-03  -1.33303000E-03  +3.29122000E-03
   +8.47240000E-04  -1.22220000E-04  +2.76000000E-04  -9.50400000E-05  -5.66850000E-04
   -2.16460000E-04  +2.61820000E-04  +5.97500000E-05  -1.51660000E-04  +7.51240000E-03
   -1.84252000E-03  -4.10354500E-02  -4.32930000E-02  +1.65122000E-02  -3.77543500E-02
   -3.21860000E-04  -2.95700000E-05  +6.29400000E-05  +8.24060000E-04  +1.60060000E-04
   +2.92886000E-03  -5.18013000E-03  -2.64854400E-02  +6.54879000E-03  +7.27000000E-06
   -3.86500000E-05  +1.12200000E-05  +5.28700000E-05  -2.81000000E-06  -9.42000000E-06
   +2.90000000E-07  -3.95200000E-05  +1.14920000E-04  -7.47580000E-04  -5.76540000E-04
   -2.05660000E-04  -1.77600000E-05  +4.20000000E-06  +7.86000000E-06  +2.15900000E-04
   +4.70170000E-04  +2.95400000E-04  -2.22760000E-04  +1.44570000E-04  +8.35000000E-06
   -5.53960000E-04  -6.19270000E-04  +7.98900000E-05  -2.23546000E-03  +3.72690000E-03
   -7.00531000E-03  +2.48596000E-03  -7.93196000E-03  +1.90972100E-02  +4.41028700E-02
   +6.64830000E-04  -4.90050000E-04  +3.15200000E-04  -5.83550000E-04  -2.69920000E-04
   -5.09010000E-04  +1.16075000E-03  +2.15395000E-03  -4.17548000E-03  -9.79820000E-04
   -2.29910000E-04  -3.87350000E-04  -2.60600000E-05  +4.85940000E-04  +3.35630000E-04
   -3.74540000E-04  +3.55540000E-04  -9.85000000E-06  -6.07160000E-03  +1.39105000E-03
   +5.76029800E-02  +8.50941000E-03  -6.09120200E-02  +5.95433200E-02  +4.96990000E-04
   -7.32900000E-05  -3.55500000E-05  -3.90570000E-04  -4.18230000E-04  -3.86614000E-03
   -6.25257000E-03  -2.10804800E-02  -2.23434800E-02  -1.42600000E-05  +4.99900000E-05
   -2.74000000E-06  -6.46100000E-05  -1.24700000E-05  +4.02600000E-05  +5.76200000E-05
   -4.29300000E-05  -1.87800000E-04  -1.91970000E-04  -1.36000000E-05  -1.93160000E-04
   -1.58000000E-06  +1.16000000E-05  +2.73300000E-05  -4.80950000E-04  -2.61460000E-04
   -9.18030000E-04  -3.93750000E-04  -6.95650000E-04  +1.26150000E-04  +4.77710000E-04
   +1.17461000E-03  -5.85070000E-04  -1.34184000E-03  +6.64038000E-03  -1.59939400E-02
   -2.21890000E-04  -1.15676000E-03  -5.16400000E-04  +1.31305900E-02  +6.04652300E-02
   +1.31151000E-03  -4.74380000E-04  +6.88530000E-04  +9.19800000E-05  -1.86124000E-03
   -2.43898000E-03  -6.08200000E-04  +2.48775000E-03  -4.68799000E-03  -1.46330000E-04
   +4.34560000E-04  -5.04130000E-04  +3.99840000E-04  +6.03900000E-04  +3.25620000E-04
   -1.35140000E-03  +3.55440000E-04  +2.81410000E-04  -3.98948300E-02  +5.48229900E-02
   +7.95260200E-02  +3.01957500E-02  -5.09269800E-02  +5.11148000E-03  +1.83902000E-03
   -8.77800000E-05  -1.29660000E-04  -1.82309000E-03  -9.87920000E-04  -2.86388000E-03
   -3.16244600E-02  +4.71679800E-02  -1.14546000E-03  -1.53540000E-04  +1.31750000E-04
   +1.20400000E-05  +1.31640000E-04  -5.07400000E-05  +5.13300000E-05  -1.13230000E-04
   -1.42600000E-05  -9.45900000E-05  -3.37830000E-04  +1.12480000E-04  +4.57420000E-04
   +1.86030000E-04  +5.37700000E-05  +8.68800000E-05  -5.14100000E-04  -1.99735000E-03
   -9.29360000E-04  -2.78890000E-04  -1.18430000E-03  +5.50520000E-04  +8.74610000E-04
   -3.28360000E-04  -2.18250000E-03  -2.09150000E-04  +4.57491000E-03  -7.69450000E-03
   -2.81695000E-03  +2.79420000E-03  -7.91257000E-03  +5.26601200E-02  -7.41220800E-02
   -5.46390200E-02  -3.88890000E-04  +7.62900000E-05  +2.01150000E-04  +9.26000000E-06
   -1.66160000E-04  -2.61870000E-04  -7.86690000E-04  +4.44610000E-04  -4.26160000E-04
   -1.39050000E-04  +2.20300000E-05  -1.25700000E-04  +6.17100000E-05  +5.35000000E-06
   +6.31500000E-05  -2.51720000E-04  -9.31200000E-05  -5.48000000E-06  +3.64965000E-03
   +2.04491000E-03  +1.62393400E-02  +4.39797000E-03  -6.87746000E-03  +1.47730000E-03
   +1.89350000E-04  -6.95000000E-06  +1.80200000E-05  -1.64960000E-04  +1.41973000E-03
   -2.65850000E-03  -2.98058240E-01  -8.00062500E-02  +2.44605470E-01  -4.82000000E-05
   +5.43000000E-06  -2.44500000E-05  +6.10000000E-06  -8.99000000E-06  -1.08000000E-06
   +4.04500000E-05  -3.56800000E-05  -1.50500000E-05  +1.93000000E-05  -1.81870000E-04
   -3.42610000E-04  -2.54000000E-06  -1.61200000E-05  -4.89500000E-05  +5.50100000E-05
   +2.70800000E-05  -3.17700000E-05  +8.72900000E-05  +1.93660000E-04  -1.73460000E-04
   +3.87290000E-04  +7.15020000E-04  -1.96000000E-05  +3.36240000E-04  +8.10100000E-05
   -6.66830000E-04  -2.34560000E-04  +1.29120000E-04  -1.02497000E-03  -1.91344000E-03
   -7.10832000E-03  -7.81849000E-03  +2.92748660E-01  +3.31750000E-04  -2.32740000E-04
   -8.11800000E-05  -6.31120000E-04  +9.31910000E-04  -2.45270000E-04  -3.07220000E-04
   +4.18490000E-04  -5.67060000E-04  +3.97020000E-04  -5.31770000E-04  -1.08200000E-04
   -3.62150000E-04  -4.95580000E-04  +6.52900000E-05  +3.39760000E-04  +6.02710000E-04
   -1.00450000E-04  -4.85041000E-03  -4.72644000E-03  -1.27083900E-02  -4.08391000E-03
   +7.19786000E-03  -1.19081400E-02  -5.12680000E-04  -9.39800000E-05  -2.07400000E-05
   -3.06730000E-04  -1.16476000E-03  +3.56893000E-03  -8.38651700E-02  -5.78611900E-02
   +8.58889400E-02  +5.62000000E-05  -3.34000000E-05  +4.30500000E-05  -2.43100000E-05
   +1.10000000E-06  +4.55400000E-05  -3.30800000E-05  -2.75200000E-05  +4.66300000E-05
   -1.33710000E-04  -2.83850000E-04  -2.09200000E-04  -5.53300000E-05  -9.65000000E-06
   +1.42500000E-05  -3.01800000E-05  -3.45600000E-05  +1.29230000E-04  +5.81010000E-04
   +1.05810000E-04  +7.40200000E-05  -2.65000000E-05  -9.95900000E-04  +3.21220000E-04
   -2.28920000E-04  -1.73440000E-04  +2.63340000E-04  +2.55030000E-04  -4.01590000E-04
   +9.56770000E-04  +4.15396000E-03  +1.29284600E-02  +1.84956700E-02  +8.93366800E-02
   +4.48800200E-02  -4.58230000E-04  -1.29600000E-04  +2.14890000E-04  -2.02200000E-05
   +1.19130000E-04  +2.87220000E-04  -1.77670000E-04  -9.48900000E-05  +2.69970000E-04
   -7.52280000E-04  +6.31940000E-04  +1.07530000E-04  +7.56860000E-04  +2.76330000E-04
   -1.55410000E-04  -7.70370000E-04  -5.45910000E-04  -6.09700000E-05  +5.10358000E-03
   -8.45140000E-04  +5.43176000E-03  +7.80470000E-04  -7.75349000E-03  -7.62373000E-03
   +9.50040000E-04  -6.01000000E-06  +4.57100000E-05  -3.52280000E-04  +2.77750000E-04
   -5.32690000E-04  +2.43484840E-01  +8.59239500E-02  -2.16965550E-01  -1.20500000E-04
   +5.26400000E-05  -1.37600000E-05  +6.74900000E-05  -3.33100000E-05  +3.99000000E-06
   +2.10400000E-05  -7.34000000E-05  +4.28400000E-05  +1.48600000E-05  -5.01070000E-04
   -5.74980000E-04  +2.49900000E-05  +3.31000000E-05  +1.39000000E-05  +5.51000000E-06
   +9.70100000E-05  +9.55500000E-05  -2.28810000E-04  -1.59690000E-04  -1.23250000E-04
   +3.41300000E-05  -1.11800000E-04  +2.36200000E-05  +1.01160000E-04  +8.59990000E-04
   -2.12356000E-03  -4.85200000E-05  +9.15100000E-05  -5.43350000E-04  +5.43380000E-04
   +5.85522000E-03  -1.86860000E-03  -2.48959460E-01  -8.39642500E-02  +2.24048860E-01
end_hess

