# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -424.79000130    # Total energy in hartree
   pointgroup    Cs              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +4.03688076E+00  +2.30031601E-02  +2.25310764E-18
   006   +5.47976624E+00  -2.40848068E+00  +2.25310764E-18
   006   +1.35212695E+00  +1.10357307E-02  +2.25310764E-18
   006   -7.16224494E-02  +2.27130257E+00  +2.25310764E-18
   006   -2.67809772E+00  +2.25588666E+00  +2.25310764E-18
   006   -3.99383313E+00  -2.04752340E-02  +2.25310764E-18
   006   -2.65470311E+00  -2.28493960E+00  +2.25310764E-18
   006   -5.45259441E-02  -2.26609935E+00  +2.25310764E-18
   008   -6.55918415E+00  -1.44835846E-01  +2.25310764E-18
   006   +5.45699814E+00  +2.46778533E+00  +2.25310764E-18
   001   -7.24843710E+00  +1.52673956E+00  +2.25310764E-18
   001   -3.70566605E+00  +4.02911297E+00  +2.25310764E-18
   001   +8.87467045E-01  +4.07484096E+00  +2.25310764E-18
   001   +9.26326254E-01  -4.05803005E+00  +2.25310764E-18
   001   -3.69115867E+00  -4.04654079E+00  +2.25310764E-18
   001   +5.00736859E+00  +3.62220896E+00  +1.65767918E+00
   001   +7.48950164E+00  +2.15197373E+00  +2.25310764E-18
   001   +5.00736859E+00  +3.62220896E+00  -1.65767918E+00
   001   +5.04074919E+00  -3.56708100E+00  -1.65746038E+00
   001   +7.50920280E+00  -2.07335885E+00  +2.25310764E-18
   001   +5.04074919E+00  -3.56708100E+00  +1.65746038E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -6.91000000E-06  -1.59000000E-06  +0.00000000E+00
   -2.54000000E-06  +1.04000000E-06  +0.00000000E+00
   -5.99000000E-06  +1.10000000E-07  +0.00000000E+00
   -4.01000000E-06  -1.08500000E-05  +0.00000000E+00
   +1.62300000E-05  +6.71000000E-06  +0.00000000E+00
   +1.68420000E-04  +6.25000000E-06  +0.00000000E+00
   +2.20000000E-06  -4.12000000E-06  +0.00000000E+00
   -6.72000000E-06  +1.18200000E-05  +0.00000000E+00
   -1.59170000E-04  -2.58000000E-06  +0.00000000E+00
   -7.77000000E-06  +1.04900000E-05  +0.00000000E+00
   -3.10000000E-06  -4.94000000E-06  +0.00000000E+00
   +6.80000000E-07  -4.51000000E-06  +0.00000000E+00
   -4.94000000E-06  -6.03000000E-06  +0.00000000E+00
   -6.19000000E-06  +6.05000000E-06  +0.00000000E+00
   +5.53000000E-06  +4.39000000E-06  +0.00000000E+00
   +3.38000000E-06  -1.80000000E-06  -1.23100000E-05
   +3.54000000E-06  +1.89000000E-06  +0.00000000E+00
   +3.38000000E-06  -1.80000000E-06  +1.23100000E-05
   +2.60000000E-07  -4.06000000E-06  -1.97000000E-06
   +3.47000000E-06  -2.42000000E-06  +0.00000000E+00
   +2.60000000E-07  -4.06000000E-06  +1.97000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.58888560E-01  -1.52820000E-04  +5.54586000E-01  +0.00000000E+00  +0.00000000E+00
   +1.32734820E-01  -1.21203690E-01  +6.27336200E-02  +0.00000000E+00  +5.73527610E-01
   +4.98766900E-02  -1.83034630E-01  +0.00000000E+00  +3.75361100E-02  +4.96745300E-01
   +0.00000000E+00  +0.00000000E+00  -5.45746900E-02  +0.00000000E+00  +0.00000000E+00
   +5.08870260E-01  -2.26795940E-01  -5.85180000E-04  +0.00000000E+00  -2.02310300E-02
   +1.19120600E-02  +0.00000000E+00  +6.03486220E-01  -1.72641000E-03  -1.10826160E-01
   +0.00000000E+00  +2.96721000E-02  +2.41698000E-03  +0.00000000E+00  -8.80890000E-04
   +6.48436380E-01  +0.00000000E+00  +0.00000000E+00  -5.35780100E-02  +0.00000000E+00
   +0.00000000E+00  +2.89889000E-03  +0.00000000E+00  +0.00000000E+00  +1.50335540E-01
   -5.22998600E-02  +3.34672200E-02  +0.00000000E+00  -4.17391000E-03  -3.57649000E-03
   +0.00000000E+00  -1.35414690E-01  +4.74236000E-02  +0.00000000E+00  +7.02878170E-01
   +4.00642900E-02  +5.94587000E-03  +0.00000000E+00  -3.33230000E-03  +2.61735000E-03
   +0.00000000E+00  +6.17787100E-02  -2.52688840E-01  +0.00000000E+00  +4.88820900E-02
   +6.88227600E-01  +0.00000000E+00  +0.00000000E+00  +5.69976000E-03  +0.00000000E+00
   +0.00000000E+00  +4.04126000E-03  +0.00000000E+00  +0.00000000E+00  -6.83191000E-02
   +0.00000000E+00  +0.00000000E+00  +1.33149690E-01  +1.85371900E-02  +1.06181000E-03
   +0.00000000E+00  -5.48240000E-04  -7.54100000E-05  +0.00000000E+00  -4.69673500E-02
   +6.54791700E-02  +0.00000000E+00  -3.52977060E-01  -3.41484400E-02  +0.00000000E+00
   +7.06136120E-01  +8.93036000E-03  -6.56162000E-03  +0.00000000E+00  +1.82907000E-03
   +1.31690000E-04  +0.00000000E+00  +1.66902200E-02  +3.31859500E-02  +0.00000000E+00
   +4.03453400E-02  -1.29223520E-01  +0.00000000E+00  -4.12383100E-02  +7.10449700E-01
   +0.00000000E+00  +0.00000000E+00  +3.82099000E-03  +0.00000000E+00  +0.00000000E+00
   +2.68730000E-04  +0.00000000E+00  +0.00000000E+00  +6.98521000E-03  +0.00000000E+00
   +0.00000000E+00  -5.58639600E-02  +0.00000000E+00  +0.00000000E+00  +1.22466000E-01
   -1.05435500E-02  +5.08000000E-05  +0.00000000E+00  -6.68200000E-05  -4.84890000E-04
   +0.00000000E+00  +1.75709700E-02  +1.25407000E-03  +0.00000000E+00  -3.11021000E-02
   -2.97010300E-02  +0.00000000E+00  -1.62962900E-01  -1.11159620E-01  +0.00000000E+00
   +7.07438740E-01  +1.31712000E-03  +8.10300000E-05  +0.00000000E+00  -4.30300000E-04
   +1.63122000E-03  +0.00000000E+00  -1.92230000E-04  -7.08937700E-02  +0.00000000E+00
   -9.66421000E-02  +3.32489200E-02  +0.00000000E+00  -1.33624200E-02  -2.76144650E-01
   +0.00000000E+00  -9.77853000E-03  +6.90002330E-01  +0.00000000E+00  +0.00000000E+00
   -9.39480000E-04  +0.00000000E+00  +0.00000000E+00  +1.87970000E-04  +0.00000000E+00
   +0.00000000E+00  -6.20022000E-03  +0.00000000E+00  +0.00000000E+00  +3.15632000E-03
   +0.00000000E+00  +0.00000000E+00  -6.58575200E-02  +0.00000000E+00  +0.00000000E+00
   +1.51825660E-01  +2.00645000E-02  -9.65980000E-04  +0.00000000E+00  -5.80840000E-04
   +2.22718000E-03  +0.00000000E+00  -4.73590800E-02  -6.50244100E-02  +0.00000000E+00
   -4.74016400E-02  +1.74926300E-02  +0.00000000E+00  +6.53848200E-02  +2.52074800E-02
   +0.00000000E+00  -1.56041280E-01  +1.74638000E-02  +0.00000000E+00  +7.23160900E-01
   -9.87364000E-03  -6.83424000E-03  +0.00000000E+00  +1.03071000E-03  -1.49606000E-03
   +0.00000000E+00  -1.70157100E-02  +3.35629800E-02  +0.00000000E+00  +2.79022600E-02
   -1.24524600E-02  +0.00000000E+00  -2.49908100E-02  -5.44087600E-02  +0.00000000E+00
   +1.10047640E-01  -2.75041420E-01  +0.00000000E+00  +4.68411000E-02  +7.17856360E-01
   +0.00000000E+00  +0.00000000E+00  +3.76230000E-03  +0.00000000E+00  +0.00000000E+00
   -1.41970000E-04  +0.00000000E+00  +0.00000000E+00  +6.95933000E-03  +0.00000000E+00
   +0.00000000E+00  -1.86994000E-03  +0.00000000E+00  +0.00000000E+00  +7.67994000E-03
   +0.00000000E+00  +0.00000000E+00  -6.82755300E-02  +0.00000000E+00  +0.00000000E+00
   +1.27660990E-01  -5.16119500E-02  -3.37729700E-02  +0.00000000E+00  -7.55810000E-04
   -5.02204000E-03  +0.00000000E+00  -1.33058300E-01  -4.48344200E-02  +0.00000000E+00
   +5.32135800E-02  -6.46573000E-03  +0.00000000E+00  -4.76428700E-02  -2.69763100E-02
   +0.00000000E+00  -3.47264700E-02  +9.39762000E-02  +0.00000000E+00  -3.63220440E-01
   -4.40104900E-02  +0.00000000E+00  +7.12431530E-01  -3.93286300E-02  +5.56457000E-03
   +0.00000000E+00  +1.27458000E-03  -1.50708000E-03  +0.00000000E+00  -5.96372900E-02
   -2.51109360E-01  +0.00000000E+00  +7.86491000E-03  -4.26694200E-02  +0.00000000E+00
   -1.89268200E-02  -1.31563100E-02  +0.00000000E+00  +2.78218700E-02  +3.68861800E-02
   +0.00000000E+00  +3.08589200E-02  -1.33307480E-01  +0.00000000E+00  -5.07096700E-02
   +6.84592960E-01  +0.00000000E+00  +0.00000000E+00  +5.50551000E-03  +0.00000000E+00
   +0.00000000E+00  -2.83543000E-03  +0.00000000E+00  +0.00000000E+00  -6.89276200E-02
   +0.00000000E+00  +0.00000000E+00  +5.25294000E-03  +0.00000000E+00  +0.00000000E+00
   -2.20529000E-03  +0.00000000E+00  +0.00000000E+00  +3.17180000E-03  +0.00000000E+00
   +0.00000000E+00  -5.74175800E-02  +0.00000000E+00  +0.00000000E+00  +1.36503810E-01
   -4.95830000E-04  -3.19200000E-05  +0.00000000E+00  +5.87660000E-04  -5.23330000E-04
   +0.00000000E+00  -4.19141000E-03  -9.61560000E-04  +0.00000000E+00  +1.87212000E-03
   -2.18818000E-03  +0.00000000E+00  -4.16404200E-02  -3.47647000E-03  +0.00000000E+00
   -3.15172630E-01  -4.09732900E-02  +0.00000000E+00  -4.20043100E-02  +1.03623200E-02
   +0.00000000E+00  +4.06440000E-03  +1.02424000E-03  +0.00000000E+00  +5.01718800E-01
   -2.10660000E-04  +2.54580000E-04  +0.00000000E+00  +3.62100000E-05  -1.45940000E-04
   +0.00000000E+00  +1.17980000E-04  +5.90960000E-03  +0.00000000E+00  +7.33011000E-03
   -7.74136000E-03  +0.00000000E+00  -4.69969200E-02  +1.34509000E-03  +0.00000000E+00
   +1.21083900E-02  -1.08397450E-01  +0.00000000E+00  +5.28259600E-02  +3.92211000E-03
   +0.00000000E+00  -6.73153000E-03  -9.02037000E-03  +0.00000000E+00  -1.53890990E-01
   +5.85114730E-01  +0.00000000E+00  +0.00000000E+00  -2.18200000E-04  +0.00000000E+00
   +0.00000000E+00  -7.73400000E-05  +0.00000000E+00  +0.00000000E+00  -1.37281000E-03
   +0.00000000E+00  +0.00000000E+00  +6.69939000E-03  +0.00000000E+00  +0.00000000E+00
   +8.86435000E-03  +0.00000000E+00  +0.00000000E+00  -3.95416400E-02  +0.00000000E+00
   +0.00000000E+00  +6.42018000E-03  +0.00000000E+00  +0.00000000E+00  +4.31428000E-03
   +0.00000000E+00  +0.00000000E+00  +2.54163100E-02  -1.20194400E-01  -6.20780200E-02
   +0.00000000E+00  +7.56951000E-03  +1.01793000E-02  +0.00000000E+00  -1.99211600E-02
   -2.99120500E-02  +0.00000000E+00  -9.47860000E-04  -1.35335000E-03  +0.00000000E+00
   -4.41640000E-04  -9.20960000E-04  +0.00000000E+00  -8.35900000E-05  +1.00230000E-04
   +0.00000000E+00  -6.53370000E-04  -1.79625000E-03  +0.00000000E+00  -4.17108000E-03
   +3.28959000E-03  +0.00000000E+00  +5.84060000E-04  -6.73800000E-05  +0.00000000E+00
   +5.74157270E-01  -4.92715000E-02  -1.84036670E-01  +0.00000000E+00  -9.89690000E-03
   -2.36704500E-02  +0.00000000E+00  -1.21576500E-02  +2.17256000E-03  +0.00000000E+00
   +5.05389000E-03  -1.56147000E-03  +0.00000000E+00  -2.12204000E-03  -1.41001000E-03
   +0.00000000E+00  +4.33580000E-04  +1.34440000E-03  +0.00000000E+00  -1.27280000E-04
   +2.25950000E-04  +0.00000000E+00  +3.56524000E-03  +2.60706000E-03  +0.00000000E+00
   +6.22440000E-04  -1.34280000E-04  +0.00000000E+00  -3.66576100E-02  +4.95825350E-01
   +0.00000000E+00  +0.00000000E+00  -5.47191400E-02  +0.00000000E+00  +0.00000000E+00
   +1.08712200E-02  +0.00000000E+00  +0.00000000E+00  +2.89572000E-03  +0.00000000E+00
   +0.00000000E+00  -2.84372000E-03  +0.00000000E+00  +0.00000000E+00  -1.40460000E-04
   +0.00000000E+00  +0.00000000E+00  +2.01830000E-04  +0.00000000E+00  +0.00000000E+00
   +2.43970000E-04  +0.00000000E+00  +0.00000000E+00  +4.11409000E-03  +0.00000000E+00
   +0.00000000E+00  -6.52000000E-05  +0.00000000E+00  +0.00000000E+00  +5.08722600E-01
   -1.98300000E-04  -1.32660000E-04  +0.00000000E+00  +8.68000000E-06  +4.58200000E-05
   +0.00000000E+00  +5.56330000E-04  -6.81200000E-04  +0.00000000E+00  -1.03736000E-03
   +3.72200000E-04  +0.00000000E+00  +3.94105000E-03  +1.51354000E-03  +0.00000000E+00
   -2.54925300E-02  +4.76016500E-02  +0.00000000E+00  -7.27888000E-03  -2.68420000E-03
   +0.00000000E+00  +6.89220000E-04  +2.03392000E-03  +0.00000000E+00  -1.06550890E-01
   +1.36896490E-01  +0.00000000E+00  +1.31300000E-05  -7.22000000E-06  +0.00000000E+00
   +1.35797720E-01  +8.12000000E-05  -7.19200000E-05  +0.00000000E+00  +7.78300000E-05
   -2.24300000E-05  +0.00000000E+00  -4.48890000E-04  +1.11920000E-04  +0.00000000E+00
   +1.90400000E-04  -1.11412000E-03  +0.00000000E+00  -5.52000000E-03  +4.22816000E-03
   +0.00000000E+00  -1.79722000E-03  -4.78870000E-04  +0.00000000E+00  -1.12114000E-03
   +2.04186000E-03  +0.00000000E+00  +2.73770000E-04  -2.47530000E-04  +0.00000000E+00
   +1.90357560E-01  -4.75922610E-01  +0.00000000E+00  +7.78700000E-05  +4.59800000E-05
   +0.00000000E+00  -1.82582820E-01  +4.72117060E-01  +0.00000000E+00  +0.00000000E+00
   -4.59200000E-05  +0.00000000E+00  +0.00000000E+00  +1.12400000E-05  +0.00000000E+00
   +0.00000000E+00  +9.89800000E-05  +0.00000000E+00  +0.00000000E+00  -6.71160000E-04
   +0.00000000E+00  +0.00000000E+00  -9.30200000E-04  +0.00000000E+00  +0.00000000E+00
   -2.56489000E-03  +0.00000000E+00  +0.00000000E+00  +2.20139000E-03  +0.00000000E+00
   +0.00000000E+00  +1.54977000E-03  +0.00000000E+00  +0.00000000E+00  -3.78780000E-03
   +0.00000000E+00  +0.00000000E+00  +1.59600000E-05  +0.00000000E+00  +0.00000000E+00
   +4.32822000E-03  +2.21590000E-04  +1.64150000E-03  +0.00000000E+00  -4.44500000E-04
   -2.05040000E-04  +0.00000000E+00  -5.40456000E-03  -1.86653000E-03  +0.00000000E+00
   -1.07657100E-02  +2.97974900E-02  +0.00000000E+00  -1.26495070E-01  +1.16597510E-01
   +0.00000000E+00  +7.84997000E-03  -1.33462600E-02  +0.00000000E+00  -6.31810000E-04
   -3.41760000E-03  +0.00000000E+00  -1.01054000E-03  -5.82400000E-04  +0.00000000E+00
   +3.81520000E-03  -8.05660000E-04  +0.00000000E+00  +2.70700000E-05  +3.50200000E-05
   +0.00000000E+00  -4.95970000E-04  +9.46180000E-04  +0.00000000E+00  +1.32126750E-01
   +1.42660000E-04  -8.80000000E-06  +0.00000000E+00  -1.47500000E-05  +5.07000000E-05
   +0.00000000E+00  -1.03466000E-03  +1.99311000E-03  +0.00000000E+00  -1.58384000E-03
   +3.57501000E-03  +0.00000000E+00  +1.16843580E-01  -2.68391120E-01  +0.00000000E+00
   +1.98953900E-02  -1.83653300E-02  +0.00000000E+00  -4.06287000E-03  -3.67958000E-03
   +0.00000000E+00  -1.20274000E-03  +3.27020000E-04  +0.00000000E+00  +1.01500000E-05
   +2.75191000E-03  +0.00000000E+00  +1.26400000E-05  -5.46800000E-05  +0.00000000E+00
   -2.16849000E-03  -1.06736000E-03  +0.00000000E+00  -1.28044290E-01  +2.83047660E-01
   +0.00000000E+00  +0.00000000E+00  +3.68460000E-04  +0.00000000E+00  +0.00000000E+00
   -3.29420000E-04  +0.00000000E+00  +0.00000000E+00  +7.84556000E-03  +0.00000000E+00
   +0.00000000E+00  +2.40793000E-03  +0.00000000E+00  +0.00000000E+00  -3.32697600E-02
   +0.00000000E+00  +0.00000000E+00  +3.88712000E-03  +0.00000000E+00  +0.00000000E+00
   +5.26547000E-03  +0.00000000E+00  +0.00000000E+00  -8.88780000E-04  +0.00000000E+00
   +0.00000000E+00  -3.75372000E-03  +0.00000000E+00  +0.00000000E+00  +1.24890000E-04
   +0.00000000E+00  +0.00000000E+00  +5.71690000E-04  +0.00000000E+00  +0.00000000E+00
   +2.31989700E-02  -2.59450000E-04  -7.34400000E-05  +0.00000000E+00  +6.53500000E-05
   -9.41800000E-05  +0.00000000E+00  +1.30061600E-02  +1.34455700E-02  +0.00000000E+00
   -1.20688250E-01  -1.16628630E-01  +0.00000000E+00  -1.08789000E-02  -2.91437100E-02
   +0.00000000E+00  -4.86108000E-03  +1.48103000E-03  +0.00000000E+00  -6.78680000E-04
   +6.95980000E-04  +0.00000000E+00  -1.51935000E-03  +3.03450000E-03  +0.00000000E+00
   -1.44315000E-03  -1.48753000E-03  +0.00000000E+00  -1.58315000E-03  +6.00630000E-04
   +0.00000000E+00  +2.51390000E-04  -1.91820000E-04  +0.00000000E+00  +8.42010000E-04
   +2.46560000E-04  +0.00000000E+00  +1.29731850E-01  -1.57818000E-03  -4.48990000E-04
   +0.00000000E+00  +1.21230000E-04  +6.98700000E-05  +0.00000000E+00  -1.50385200E-02
   -1.76045700E-02  +0.00000000E+00  -1.16775930E-01  -2.82033570E-01  +0.00000000E+00
   +2.13015000E-03  +3.03277000E-03  +0.00000000E+00  +8.87730000E-04  +2.21457000E-03
   +0.00000000E+00  +1.07885000E-03  +9.61900000E-05  +0.00000000E+00  +3.83437000E-03
   -3.48335000E-03  +0.00000000E+00  -1.41800000E-05  -2.06100000E-05  +0.00000000E+00
   -9.87550000E-04  +4.18220000E-04  +0.00000000E+00  +4.67500000E-05  -1.61800000E-05
   +0.00000000E+00  -2.79040000E-04  +9.51740000E-04  +0.00000000E+00  +1.27362710E-01
   +2.96549450E-01  +0.00000000E+00  +0.00000000E+00  -2.11137000E-03  +0.00000000E+00
   +0.00000000E+00  -3.38540000E-04  +0.00000000E+00  +0.00000000E+00  +3.32980000E-03
   +0.00000000E+00  +0.00000000E+00  -3.53487300E-02  +0.00000000E+00  +0.00000000E+00
   +3.83522000E-03  +0.00000000E+00  +0.00000000E+00  +7.82021000E-03  +0.00000000E+00
   +0.00000000E+00  -1.11986000E-03  +0.00000000E+00  +0.00000000E+00  +5.45157000E-03
   +0.00000000E+00  +0.00000000E+00  +1.47060000E-04  +0.00000000E+00  +0.00000000E+00
   +1.00425000E-03  +0.00000000E+00  +0.00000000E+00  -2.96200000E-05  +0.00000000E+00
   +0.00000000E+00  -4.67913000E-03  +0.00000000E+00  +0.00000000E+00  +2.38869100E-02
   -2.67930000E-04  +6.44300000E-05  +0.00000000E+00  -1.82636000E-03  -6.40620000E-04
   +0.00000000E+00  +1.28263200E-02  -1.31773300E-02  +0.00000000E+00  -1.39174000E-03
   -3.03202000E-03  +0.00000000E+00  -7.61260000E-04  -7.35970000E-04  +0.00000000E+00
   -4.69984000E-03  -1.35388000E-03  +0.00000000E+00  -1.12384800E-02  +2.92048200E-02
   +0.00000000E+00  -1.23601050E-01  +1.18371070E-01  +0.00000000E+00  -9.48310000E-04
   +1.60545000E-03  +0.00000000E+00  +7.04700000E-05  +9.47600000E-05  +0.00000000E+00
   -4.33120000E-04  +2.35200000E-05  +0.00000000E+00  +2.76600000E-05  +7.61900000E-05
   +0.00000000E+00  +5.51350000E-04  -8.47350000E-04  +0.00000000E+00  +1.33431260E-01
   +1.56923000E-03  -4.67340000E-04  +0.00000000E+00  +9.96680000E-04  +4.21330000E-04
   +0.00000000E+00  +1.52744800E-02  -1.76157600E-02  +0.00000000E+00  -3.75437000E-03
   -3.55990000E-03  +0.00000000E+00  -1.09403000E-03  +1.42010000E-04  +0.00000000E+00
   -1.03267000E-03  +2.16101000E-03  +0.00000000E+00  -2.19877000E-03  +3.42795000E-03
   +0.00000000E+00  +1.18599620E-01  -2.79197640E-01  +0.00000000E+00  +1.02690000E-04
   -4.44800000E-05  +0.00000000E+00  -1.21180000E-04  +6.75100000E-05  +0.00000000E+00
   -7.31300000E-05  +3.48100000E-05  +0.00000000E+00  +1.10590000E-04  -3.32800000E-05
   +0.00000000E+00  +8.56170000E-04  -1.09584000E-03  +0.00000000E+00  -1.29300760E-01
   +2.93444290E-01  +0.00000000E+00  +0.00000000E+00  -2.00179000E-03  +0.00000000E+00
   +0.00000000E+00  +9.68130000E-04  +0.00000000E+00  +0.00000000E+00  +3.40937000E-03
   +0.00000000E+00  +0.00000000E+00  +5.26192000E-03  +0.00000000E+00  +0.00000000E+00
   -9.92450000E-04  +0.00000000E+00  +0.00000000E+00  +8.33182000E-03  +0.00000000E+00
   +0.00000000E+00  +4.38792000E-03  +0.00000000E+00  +0.00000000E+00  -3.66210000E-02
   +0.00000000E+00  +0.00000000E+00  +1.94860000E-04  +0.00000000E+00  +0.00000000E+00
   -3.30190000E-04  +0.00000000E+00  +0.00000000E+00  -2.20020000E-04  +0.00000000E+00
   +0.00000000E+00  -6.77350000E-04  +0.00000000E+00  +0.00000000E+00  -1.09360000E-04
   +0.00000000E+00  +0.00000000E+00  +2.44753100E-02  +2.02860000E-04  -1.51629000E-03
   +0.00000000E+00  +3.87100000E-05  -3.18200000E-05  +0.00000000E+00  -5.20092000E-03
   +1.71354000E-03  +0.00000000E+00  -8.54250000E-04  +5.59960000E-04  +0.00000000E+00
   -1.26943000E-03  +3.19448000E-03  +0.00000000E+00  +1.10577100E-02  +1.40318900E-02
   +0.00000000E+00  -1.30114980E-01  -1.22869060E-01  +0.00000000E+00  -1.00827200E-02
   -2.85223300E-02  +0.00000000E+00  +1.44815000E-03  -7.78360000E-04  +0.00000000E+00
   -4.10630000E-04  +1.81280000E-04  +0.00000000E+00  +1.04640000E-04  -2.21220000E-04
   +0.00000000E+00  +5.15370000E-04  +8.51280000E-04  +0.00000000E+00  +3.30100000E-05
   -1.00060000E-04  +0.00000000E+00  +8.85350000E-04  +2.72480000E-04  +0.00000000E+00
   +1.33797660E-01  -1.32250000E-04  +8.01500000E-05  +0.00000000E+00  -8.63000000E-06
   -4.64100000E-05  +0.00000000E+00  +1.18331000E-03  +1.79072000E-03  +0.00000000E+00
   +1.19479000E-03  +3.41850000E-04  +0.00000000E+00  +3.74554000E-03  -3.48396000E-03
   +0.00000000E+00  -1.85794500E-02  -1.87428400E-02  +0.00000000E+00  -1.21214550E-01
   -2.74176970E-01  +0.00000000E+00  +2.09420000E-03  +4.67805000E-03  +0.00000000E+00
   -4.17970000E-04  +1.95625000E-03  +0.00000000E+00  +4.10200000E-05  +4.03400000E-05
   +0.00000000E+00  -1.22350000E-04  +3.80310000E-04  +0.00000000E+00  -6.53400000E-04
   -1.07514000E-03  +0.00000000E+00  -7.40800000E-05  -1.63900000E-05  +0.00000000E+00
   -3.30880000E-04  +9.05170000E-04  +0.00000000E+00  +1.33294470E-01  +2.87380730E-01
   +0.00000000E+00  +0.00000000E+00  +3.21830000E-04  +0.00000000E+00  +0.00000000E+00
   +1.43670000E-04  +0.00000000E+00  +0.00000000E+00  +8.27156000E-03  +0.00000000E+00
   +0.00000000E+00  -9.28720000E-04  +0.00000000E+00  +0.00000000E+00  +5.17571000E-03
   +0.00000000E+00  +0.00000000E+00  +4.89753000E-03  +0.00000000E+00  +0.00000000E+00
   -3.59040700E-02  +0.00000000E+00  +0.00000000E+00  +2.81400000E-03  +0.00000000E+00
   +0.00000000E+00  -3.22482000E-03  +0.00000000E+00  +0.00000000E+00  -3.55160000E-04
   +0.00000000E+00  +0.00000000E+00  -5.08090000E-04  +0.00000000E+00  +0.00000000E+00
   -1.74100000E-05  +0.00000000E+00  +0.00000000E+00  -6.71320000E-04  +0.00000000E+00
   +0.00000000E+00  -5.03235000E-03  +0.00000000E+00  +0.00000000E+00  +2.50704500E-02
   +4.73695000E-03  -8.29447000E-03  -1.27726600E-02  -9.32170000E-04  -2.21660000E-04
   -2.21230000E-04  -5.97670000E-04  -2.45550000E-04  +3.08970000E-04  +5.27450000E-04
   -3.78580000E-04  -3.49230000E-04  -8.46830000E-04  -4.26560000E-04  +1.66700000E-04
   +2.77970000E-04  +7.16630000E-04  +2.99200000E-05  +2.67300000E-04  -8.45300000E-05
   -8.13000000E-06  +5.50600000E-05  +2.70970000E-04  +6.05930000E-04  -1.79670000E-04
   -1.68100000E-05  -5.00500000E-05  -6.02560800E-02  +2.92421300E-02  +4.55258600E-02
   -2.12000000E-06  -2.72600000E-05  +5.80000000E-07  -2.02200000E-05  -9.46000000E-06
   +5.52000000E-06  -1.37231000E-03  +1.45250000E-04  -8.17840000E-04  +1.04700000E-05
   -2.50000000E-06  -4.35900000E-05  +1.44300000E-05  -3.86000000E-06  -5.21300000E-05
   +6.18617300E-02  +2.56488000E-03  -2.06207600E-02  -1.85162100E-02  -1.88761000E-03
   -1.82500000E-03  +1.53190000E-04  +3.31137000E-03  +3.74120000E-04  +6.41920000E-04
   -4.55410000E-04  +8.06630000E-04  -8.85500000E-05  -6.20000000E-06  +5.08000000E-06
   +1.10290000E-04  +2.18160000E-04  +1.95320000E-04  -2.09500000E-05  +3.67800000E-04
   +1.04750000E-04  +1.55900000E-05  -6.79910000E-04  -9.20570000E-04  +5.65410000E-04
   -6.42130000E-04  +2.58700000E-05  +1.40000000E-06  +3.32371200E-02  -1.17206720E-01
   -1.17005900E-01  +2.81800000E-05  -5.55600000E-05  -5.28000000E-06  -2.21500000E-05
   +2.28000000E-05  +2.75000000E-06  -3.91800000E-05  +3.61320000E-04  -1.48820000E-04
   +4.12200000E-05  +4.66900000E-05  -7.84900000E-05  -4.66000000E-06  -2.62900000E-05
   -6.77500000E-05  -3.30932300E-02  +1.33649530E-01  -3.32269000E-03  -6.36660000E-04
   +4.90215000E-03  -2.56760000E-04  +7.19890000E-04  -1.67156000E-03  +1.69229000E-03
   -3.00710000E-04  +8.27190000E-04  -2.35910000E-04  -6.14350000E-04  -5.34200000E-05
   +2.08100000E-04  +4.63240000E-04  +5.25900000E-05  +1.66860000E-04  -9.34700000E-05
   -1.83600000E-05  +1.50870000E-04  +1.05030000E-04  +8.90000000E-07  -5.00910000E-04
   -3.43250000E-04  -1.87320000E-04  -3.23880000E-04  +8.81900000E-05  +1.94000000E-06
   +4.81975600E-02  -1.11894650E-01  -2.09597420E-01  -1.07600000E-05  -4.27900000E-05
   -2.47000000E-06  -2.48800000E-05  -4.62000000E-06  -6.15000000E-06  -3.87330000E-04
   +5.19860000E-04  -3.46380000E-04  +2.84700000E-05  +5.78800000E-05  +6.87000000E-06
   -1.40700000E-05  -3.48000000E-06  +3.45000000E-06  -5.20735500E-02  +1.24662410E-01
   +2.28283760E-01  -1.63138800E-02  +4.00743000E-03  +0.00000000E+00  +4.88380000E-04
   +2.21672000E-03  +0.00000000E+00  -2.81760000E-04  -3.04904000E-03  +0.00000000E+00
   +4.29520000E-04  -1.58040000E-04  +0.00000000E+00  -2.66300000E-05  -1.52130000E-04
   +0.00000000E+00  +3.48490000E-04  -1.01160000E-04  +0.00000000E+00  -2.82860000E-04
   -2.23670000E-04  +0.00000000E+00  -4.73060000E-04  +6.62780000E-04  +0.00000000E+00
   -4.18700000E-04  -3.99000000E-06  +0.00000000E+00  -3.12075800E-01  +4.29342700E-02
   +0.00000000E+00  +6.29600000E-05  -1.78600000E-05  +0.00000000E+00  -4.90300000E-05
   +2.78300000E-05  +0.00000000E+00  +1.47260000E-04  -2.63780000E-04  +0.00000000E+00
   +6.77000000E-06  -1.32570000E-04  +0.00000000E+00  -1.00050000E-04  -3.88000000E-06
   +0.00000000E+00  -5.82842000E-03  +9.21560000E-04  -2.41460000E-04  +3.38047910E-01
   -2.96276400E-02  +3.95126000E-03  +0.00000000E+00  -2.25946000E-03  +8.20790000E-04
   +0.00000000E+00  -1.46110000E-03  -5.18520000E-03  +0.00000000E+00  +8.00550000E-04
   -1.15150000E-03  +0.00000000E+00  -2.34230000E-04  +2.88660000E-04  +0.00000000E+00
   +2.08130000E-04  +7.25100000E-05  +0.00000000E+00  -7.40100000E-05  -3.95310000E-04
   +0.00000000E+00  -1.46232000E-03  +5.25980000E-04  +0.00000000E+00  -8.32100000E-05
   +5.60300000E-05  +0.00000000E+00  +4.76774000E-02  -5.46861100E-02  +0.00000000E+00
   -1.39800000E-05  -1.26100000E-05  +0.00000000E+00  -3.60500000E-05  -5.59000000E-06
   +0.00000000E+00  +1.21120000E-04  +5.85580000E-04  +0.00000000E+00  -6.52000000E-06
   -1.74800000E-05  +0.00000000E+00  -1.23200000E-04  +4.24000000E-06  +0.00000000E+00
   +1.66003900E-02  -3.25852000E-03  +1.66651000E-03  -4.74403900E-02  +6.26613100E-02
   +0.00000000E+00  +0.00000000E+00  -1.80340000E-03  +0.00000000E+00  +0.00000000E+00
   -1.72290000E-04  +0.00000000E+00  +0.00000000E+00  +1.03163000E-03  +0.00000000E+00
   +0.00000000E+00  +2.25110000E-04  +0.00000000E+00  +0.00000000E+00  +1.56420000E-04
   +0.00000000E+00  +0.00000000E+00  -1.01600000E-05  +0.00000000E+00  +0.00000000E+00
   -9.23000000E-05  +0.00000000E+00  +0.00000000E+00  +4.45830000E-04  +0.00000000E+00
   +0.00000000E+00  -2.94400000E-05  +0.00000000E+00  +0.00000000E+00  -4.70432600E-02
   +0.00000000E+00  +0.00000000E+00  +6.70000000E-06  +0.00000000E+00  +0.00000000E+00
   +6.05000000E-06  +0.00000000E+00  +0.00000000E+00  -4.29780000E-04  +0.00000000E+00
   +0.00000000E+00  +3.67200000E-05  +0.00000000E+00  +0.00000000E+00  -5.88600000E-05
   +2.66749100E-02  -4.04170000E-03  +9.56050000E-04  +0.00000000E+00  +0.00000000E+00
   +4.54135000E-02  +4.73695000E-03  -8.29447000E-03  +1.27726600E-02  -9.32170000E-04
   -2.21660000E-04  +2.21230000E-04  -5.97660000E-04  -2.45560000E-04  -3.08970000E-04
   +5.27450000E-04  -3.78580000E-04  +3.49230000E-04  -8.46830000E-04  -4.26550000E-04
   -1.66700000E-04  +2.77970000E-04  +7.16630000E-04  -2.99200000E-05  +2.67300000E-04
   -8.45300000E-05  +8.13000000E-06  +5.50600000E-05  +2.70970000E-04  -6.05930000E-04
   -1.79670000E-04  -1.68100000E-05  +5.00500000E-05  -6.02560800E-02  +2.92421300E-02
   -4.55258500E-02  -2.12000000E-06  -2.72600000E-05  -5.80000000E-07  -2.02200000E-05
   -9.46000000E-06  -5.52000000E-06  -1.37231000E-03  +1.45250000E-04  +8.17840000E-04
   +1.04700000E-05  -2.50000000E-06  +4.35900000E-05  +1.44300000E-05  -3.86000000E-06
   +5.21300000E-05  +1.46974000E-03  -3.87014000E-03  +6.94553000E-03  -5.82842000E-03
   +1.66003900E-02  -2.66749100E-02  +6.18617300E-02  +2.56488000E-03  -2.06207600E-02
   +1.85162100E-02  -1.88761000E-03  -1.82500000E-03  -1.53190000E-04  +3.31137000E-03
   +3.74120000E-04  -6.41920000E-04  -4.55410000E-04  +8.06630000E-04  +8.85500000E-05
   -6.19000000E-06  +5.08000000E-06  -1.10290000E-04  +2.18160000E-04  +1.95320000E-04
   +2.09500000E-05  +3.67800000E-04  +1.04750000E-04  -1.55900000E-05  -6.79910000E-04
   -9.20570000E-04  -5.65410000E-04  -6.42130000E-04  +2.58700000E-05  -1.40000000E-06
   +3.32371200E-02  -1.17206720E-01  +1.17005900E-01  +2.81800000E-05  -5.55600000E-05
   +5.28000000E-06  -2.21500000E-05  +2.28000000E-05  -2.75000000E-06  -3.91800000E-05
   +3.61320000E-04  +1.48820000E-04  +4.12200000E-05  +4.66900000E-05  +7.84900000E-05
   -4.66000000E-06  -2.62900000E-05  +6.77500000E-05  -3.87014000E-03  +9.72203000E-03
   -1.43552800E-02  +9.21560000E-04  -3.25852000E-03  +4.04170000E-03  -3.30932300E-02
   +1.33649530E-01  +3.32269000E-03  +6.36660000E-04  +4.90215000E-03  +2.56760000E-04
   -7.19890000E-04  -1.67156000E-03  -1.69229000E-03  +3.00710000E-04  +8.27190000E-04
   +2.35910000E-04  +6.14340000E-04  -5.34200000E-05  -2.08100000E-04  -4.63240000E-04
   +5.25900000E-05  -1.66860000E-04  +9.34700000E-05  -1.83600000E-05  -1.50870000E-04
   -1.05030000E-04  +8.90000000E-07  +5.00910000E-04  +3.43250000E-04  -1.87320000E-04
   +3.23890000E-04  -8.81900000E-05  +1.94000000E-06  -4.81975600E-02  +1.11894650E-01
   -2.09597420E-01  +1.07600000E-05  +4.27900000E-05  -2.47000000E-06  +2.48800000E-05
   +4.62000000E-06  -6.15000000E-06  +3.87330000E-04  -5.19860000E-04  -3.46380000E-04
   -2.84700000E-05  -5.78800000E-05  +6.87000000E-06  +1.40700000E-05  +3.48000000E-06
   +3.45000000E-06  -6.94553000E-03  +1.43552800E-02  -2.30996600E-02  +2.41460000E-04
   -1.66651000E-03  +9.56050000E-04  +5.20735500E-02  -1.24662410E-01  +2.28283760E-01
   +4.67510000E-03  +8.53794000E-03  +1.29348000E-02  -5.97083200E-02  -2.87679500E-02
   -4.44976200E-02  -5.51760000E-04  +2.66550000E-04  -3.17780000E-04  +4.26300000E-05
   -2.63950000E-04  -6.04010000E-04  +2.98210000E-04  +6.69700000E-05  +6.85000000E-06
   +2.88290000E-04  -6.59730000E-04  -2.13500000E-05  -8.08850000E-04  +4.08310000E-04
   -1.68820000E-04  +4.60590000E-04  +3.82510000E-04  +3.54580000E-04  -2.25290000E-04
   +3.34500000E-05  +4.19200000E-05  -9.58460000E-04  +2.27310000E-04  +2.18660000E-04
   +5.23000000E-06  -2.57800000E-05  +5.42000000E-06  +1.59300000E-05  +4.08000000E-06
   +5.08800000E-05  +1.18900000E-05  +2.00000000E-08  +4.54200000E-05  -1.39265000E-03
   -1.69020000E-04  +8.30200000E-04  -2.32300000E-05  +4.85000000E-06  -9.19000000E-06
   +2.42140000E-04  +1.44940000E-04  +8.23800000E-05  +3.85910000E-04  +1.26610000E-04
   -1.51580000E-04  +1.83340000E-04  +5.85700000E-05  +5.99400000E-05  +6.13207400E-02
   -2.32975000E-03  -2.05480400E-02  -1.83794800E-02  -3.27334700E-02  -1.17863670E-01
   -1.17554140E-01  -3.31031000E-03  +3.69850000E-04  +6.37570000E-04  +6.65400000E-04
   -9.46460000E-04  +5.52250000E-04  -3.03330000E-04  +1.67080000E-04  +1.68000000E-05
   -2.09480000E-04  -5.23000000E-06  -2.26800000E-05  -7.35600000E-05  +7.38200000E-05
   +1.02750000E-04  +4.79640000E-04  +7.65870000E-04  -8.16300000E-05  +6.35830000E-04
   +4.67000000E-06  +6.88000000E-06  +1.89211000E-03  -1.80213000E-03  +1.62340000E-04
   -3.89900000E-05  +4.87300000E-05  -9.41000000E-06  +1.07400000E-05  -2.94900000E-05
   -6.39100000E-05  -4.07300000E-05  +4.66300000E-05  -7.93100000E-05  +1.68400000E-05
   +3.68450000E-04  -1.31610000E-04  +1.63700000E-05  +2.01700000E-05  +5.18000000E-06
   -1.29610000E-04  -8.97360000E-04  -2.86420000E-04  +1.96630000E-04  +5.92300000E-05
   +4.15000000E-06  -4.84900000E-05  -5.60070000E-04  -2.54340000E-04  +3.24683500E-02
   +1.34351720E-01  +3.32713000E-03  -5.61180000E-04  +4.89035000E-03  -4.71913400E-02
   -1.12449460E-01  -2.09681750E-01  -1.68896000E-03  -3.12450000E-04  +8.25080000E-04
   +4.88830000E-04  -3.50320000E-04  -1.90680000E-04  -1.13590000E-04  +1.45940000E-04
   +9.00000000E-08  -1.43040000E-04  -2.26040000E-04  -1.91300000E-05  -2.73700000E-04
   +5.01490000E-04  +4.38900000E-05  +2.89660000E-04  -6.45830000E-04  -4.23300000E-05
   +3.22920000E-04  +7.54900000E-05  +9.65000000E-06  +2.47030000E-04  +7.29370000E-04
   -1.66683000E-03  -2.99700000E-05  +3.00100000E-05  -6.38000000E-06  +1.52200000E-05
   -3.67000000E-06  +3.66000000E-06  -2.86600000E-05  +5.79600000E-05  +8.23000000E-06
   +3.75100000E-04  +5.38120000E-04  -3.37050000E-04  +2.90100000E-05  -3.03000000E-06
   -4.80000000E-06  -7.69700000E-05  -2.85030000E-04  -4.40000000E-05  +1.88800000E-05
   +3.85300000E-05  -1.01700000E-05  +5.87200000E-05  +2.56090000E-04  +1.75000000E-06
   +5.09557600E-02  +1.25215930E-01  +2.28333130E-01  -1.65540400E-02  -4.20447000E-03
   +0.00000000E+00  -3.11173730E-01  -4.53608300E-02  +0.00000000E+00  -3.20920000E-04
   +3.08381000E-03  +0.00000000E+00  -4.79080000E-04  -6.54580000E-04  +0.00000000E+00
   -2.90160000E-04  +2.14650000E-04  +0.00000000E+00  +3.54410000E-04  +9.44700000E-05
   +0.00000000E+00  -4.04700000E-05  +1.49030000E-04  +0.00000000E+00  +4.43620000E-04
   +1.63810000E-04  +0.00000000E+00  -4.14830000E-04  +1.91400000E-05  +0.00000000E+00
   +4.90270000E-04  -2.21981000E-03  +0.00000000E+00  +5.57200000E-05  -2.12900000E-05
   +0.00000000E+00  -1.19850000E-04  +1.61300000E-05  +0.00000000E+00  +4.49000000E-06
   +1.32230000E-04  +0.00000000E+00  +1.33280000E-04  +2.68560000E-04  +0.00000000E+00
   -3.28700000E-05  -1.78500000E-05  +0.00000000E+00  +3.88920000E-04  -1.93190000E-04
   -1.99200000E-05  +1.37549000E-03  +5.60920000E-04  +0.00000000E+00  +3.88920000E-04
   -1.93190000E-04  +1.99200000E-05  -5.67061000E-03  -9.44970000E-04  +2.29390000E-04
   +3.37132040E-01  +2.94499300E-02  +4.16450000E-03  +0.00000000E+00  -5.01236500E-02
   -5.56049200E-02  +0.00000000E+00  +1.49326000E-03  -5.14450000E-03  +0.00000000E+00
   +1.45759000E-03  +5.19210000E-04  +0.00000000E+00  +6.82400000E-05  -3.68400000E-04
   +0.00000000E+00  -1.91540000E-04  +4.19700000E-05  +0.00000000E+00  +2.04610000E-04
   +3.01730000E-04  +0.00000000E+00  -7.54650000E-04  -1.17389000E-03  +0.00000000E+00
   +9.42800000E-05  +5.57200000E-05  +0.00000000E+00  +2.25785000E-03  +8.23990000E-04
   +0.00000000E+00  -2.27100000E-05  +7.18000000E-06  +0.00000000E+00  +1.30800000E-04
   -2.90000000E-06  +0.00000000E+00  +8.94000000E-06  -1.48000000E-05  +0.00000000E+00
   -1.31010000E-04  +5.97330000E-04  +0.00000000E+00  +3.95200000E-05  -3.85000000E-06
   +0.00000000E+00  -1.22680000E-04  +5.66900000E-05  +3.83300000E-05  -5.38900000E-04
   -1.11397000E-03  +0.00000000E+00  -1.22680000E-04  +5.66900000E-05  -3.83300000E-05
   -1.66248000E-02  -3.41414000E-03  +1.68177000E-03  +5.00524000E-02  +6.36305200E-02
   +0.00000000E+00  +0.00000000E+00  -1.80668000E-03  +0.00000000E+00  +0.00000000E+00
   -4.70850500E-02  +0.00000000E+00  +0.00000000E+00  +1.03165000E-03  +0.00000000E+00
   +0.00000000E+00  +4.39220000E-04  +0.00000000E+00  +0.00000000E+00  -9.83000000E-05
   +0.00000000E+00  +0.00000000E+00  -1.58400000E-05  +0.00000000E+00  +0.00000000E+00
   +1.50220000E-04  +0.00000000E+00  +0.00000000E+00  +2.31410000E-04  +0.00000000E+00
   +0.00000000E+00  -8.63000000E-06  +0.00000000E+00  +0.00000000E+00  -1.68920000E-04
   +0.00000000E+00  +0.00000000E+00  -8.57000000E-06  +0.00000000E+00  +0.00000000E+00
   -5.56000000E-05  +0.00000000E+00  +0.00000000E+00  +3.89900000E-05  +0.00000000E+00
   +0.00000000E+00  -4.21180000E-04  +0.00000000E+00  +0.00000000E+00  +8.76000000E-06
   +1.51230000E-04  +6.53000000E-06  -9.90000000E-06  +0.00000000E+00  +0.00000000E+00
   +4.25760000E-04  -1.51230000E-04  -6.53000000E-06  -9.90000000E-06  -2.66278700E-02
   -4.27462000E-03  +9.73440000E-04  +0.00000000E+00  +0.00000000E+00  +4.54156800E-02
   +4.67510000E-03  +8.53794000E-03  -1.29348000E-02  -5.97083200E-02  -2.87679500E-02
   +4.44976200E-02  -5.51760000E-04  +2.66550000E-04  +3.17780000E-04  +4.26300000E-05
   -2.63950000E-04  +6.04010000E-04  +2.98210000E-04  +6.69700000E-05  -6.85000000E-06
   +2.88290000E-04  -6.59730000E-04  +2.13500000E-05  -8.08850000E-04  +4.08310000E-04
   +1.68820000E-04  +4.60590000E-04  +3.82500000E-04  -3.54580000E-04  -2.25290000E-04
   +3.34500000E-05  -4.19200000E-05  -9.58460000E-04  +2.27320000E-04  -2.18650000E-04
   +5.23000000E-06  -2.57800000E-05  -5.42000000E-06  +1.59300000E-05  +4.08000000E-06
   -5.08800000E-05  +1.18900000E-05  +2.00000000E-08  -4.54200000E-05  -1.39265000E-03
   -1.69020000E-04  -8.30200000E-04  -2.32300000E-05  +4.85000000E-06  +9.19000000E-06
   +1.83340000E-04  +5.85700000E-05  -5.99400000E-05  +3.85910000E-04  +1.26610000E-04
   +1.51580000E-04  +2.42140000E-04  +1.44940000E-04  -8.23800000E-05  +1.40918000E-03
   +3.78077000E-03  -6.81142000E-03  -5.67061000E-03  -1.66248000E-02  +2.66278700E-02
   +6.13207400E-02  -2.32975000E-03  -2.05480400E-02  +1.83794800E-02  -3.27334700E-02
   -1.17863670E-01  +1.17554140E-01  -3.31031000E-03  +3.69850000E-04  -6.37570000E-04
   +6.65400000E-04  -9.46460000E-04  -5.52250000E-04  -3.03340000E-04  +1.67080000E-04
   -1.68000000E-05  -2.09480000E-04  -5.23000000E-06  +2.26800000E-05  -7.35600000E-05
   +7.38200000E-05  -1.02750000E-04  +4.79640000E-04  +7.65870000E-04  +8.16300000E-05
   +6.35830000E-04  +4.67000000E-06  -6.88000000E-06  +1.89211000E-03  -1.80213000E-03
   -1.62340000E-04  -3.89900000E-05  +4.87300000E-05  +9.41000000E-06  +1.07400000E-05
   -2.94900000E-05  +6.39000000E-05  -4.07300000E-05  +4.66300000E-05  +7.93100000E-05
   +1.68400000E-05  +3.68450000E-04  +1.31610000E-04  +1.63700000E-05  +2.01700000E-05
   -5.18000000E-06  -4.84900000E-05  -5.60070000E-04  +2.54340000E-04  +1.96630000E-04
   +5.92300000E-05  -4.15000000E-06  -1.29610000E-04  -8.97360000E-04  +2.86420000E-04
   +3.78077000E-03  +9.79036000E-03  -1.44336900E-02  -9.44970000E-04  -3.41414000E-03
   +4.27462000E-03  +3.24683500E-02  +1.34351720E-01  -3.32713000E-03  +5.61180000E-04
   +4.89035000E-03  +4.71913400E-02  +1.12449450E-01  -2.09681750E-01  +1.68896000E-03
   +3.12450000E-04  +8.25080000E-04  -4.88830000E-04  +3.50320000E-04  -1.90680000E-04
   +1.13590000E-04  -1.45940000E-04  +9.00000000E-08  +1.43040000E-04  +2.26040000E-04
   -1.91300000E-05  +2.73700000E-04  -5.01490000E-04  +4.38900000E-05  -2.89660000E-04
   +6.45830000E-04  -4.23300000E-05  -3.22920000E-04  -7.54900000E-05  +9.65000000E-06
   -2.47030000E-04  -7.29370000E-04  -1.66683000E-03  +2.99700000E-05  -3.00100000E-05
   -6.38000000E-06  -1.52200000E-05  +3.67000000E-06  +3.66000000E-06  +2.86600000E-05
   -5.79600000E-05  +8.23000000E-06  -3.75100000E-04  -5.38120000E-04  -3.37050000E-04
   -2.90100000E-05  +3.03000000E-06  -4.80000000E-06  -5.87200000E-05  -2.56090000E-04
   +1.75000000E-06  -1.88800000E-05  -3.85300000E-05  -1.01700000E-05  +7.69700000E-05
   +2.85030000E-04  -4.40000000E-05  +6.81142000E-03  +1.44336900E-02  -2.30861600E-02
   -2.29390000E-04  -1.68177000E-03  +9.73440000E-04  -5.09557600E-02  -1.25215930E-01
   +2.28333130E-01
end_hess

