# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.23913180    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +4.89553975E+00  +2.07218137E+00  -5.85592542E-01
   006   +2.24970397E+00  +1.22280428E+00  -1.19518228E+00
   006   +2.02805421E+00  -1.59199381E+00  -1.54819068E+00
   006   +3.91082237E+00  -3.18200559E+00  -1.07372014E+00
   006   +6.40788568E+00  -2.28937645E+00  -1.97943573E-01
   006   +6.78104612E+00  +4.78072661E-01  -1.38980338E-01
   006   +3.27181647E-01  +2.03981414E+00  +1.22830076E+00
   006   +1.56328930E+00  +1.07760906E+00  +3.64976748E+00
   008   +1.30373920E+00  +2.50252114E+00  -3.16536728E+00
   008   +8.07601874E+00  -3.74586585E+00  +3.92314272E-01
   006   -2.25682797E+00  +8.75283644E-01  +7.57195820E-01
   006   -3.84096270E+00  +1.80723043E+00  -1.12826519E+00
   006   -6.19573153E+00  +7.70148731E-01  -1.58080925E+00
   006   -7.03918811E+00  -1.25873872E+00  -1.42540582E-01
   006   -5.49151753E+00  -2.22950614E+00  +1.73562798E+00
   006   -3.13940377E+00  -1.17026363E+00  +2.16186704E+00
   008   -9.32691134E+00  -2.35347407E+00  -4.96828326E-01
   006   +1.65211331E-01  +4.92423541E+00  +1.36532292E+00
   001   -1.02063426E+01  -1.51967399E+00  -1.83928221E+00
   001   -7.37588817E+00  +1.53698259E+00  -3.06894589E+00
   001   -3.22092655E+00  +3.34839279E+00  -2.31513225E+00
   001   -1.98411214E+00  -1.98753238E+00  +3.63265601E+00
   001   -6.14507742E+00  -3.81283963E+00  +2.84902627E+00
   001   +2.01302900E+00  +5.75888208E+00  +1.71940090E+00
   001   -5.97357412E-01  +5.76707405E+00  -3.42917692E-01
   001   -1.06447692E+00  +5.42787954E+00  +2.94102002E+00
   001   +2.01970729E+00  -9.26929264E-01  +3.57779726E+00
   001   +3.29689570E+00  +2.10779515E+00  +4.04067811E+00
   001   +2.71585904E-01  +1.39560839E+00  +5.22375627E+00
   001   +2.20538732E-01  -2.24995865E+00  -2.24048240E+00
   001   +3.71180397E+00  -5.20059592E+00  -1.33528847E+00
   001   +8.67596521E+00  +1.12791168E+00  +2.72959170E-01
   001   +5.19872552E+00  +4.09550546E+00  -5.94054735E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.09100000E-05  +5.43000000E-06  +5.45000000E-06
   -9.97000000E-06  +1.30700000E-05  -1.06400000E-05
   -2.72000000E-06  -1.83700000E-05  -8.50000000E-07
   +3.20000000E-07  +7.29000000E-06  -2.57000000E-06
   +8.05000000E-06  -8.15000000E-06  +4.17000000E-06
   -3.04000000E-06  +9.30000000E-07  -3.67000000E-06
   +5.61000000E-06  -3.15000000E-06  +9.38000000E-06
   -8.40000000E-07  +3.94000000E-06  +4.05000000E-06
   +5.82000000E-06  -5.02000000E-06  +6.66000000E-06
   -6.61000000E-06  +6.86000000E-06  -1.99000000E-06
   -9.90000000E-06  -6.77000000E-06  -1.90000000E-06
   +4.64000000E-06  +3.77000000E-06  -2.01000000E-06
   -3.90000000E-06  -2.03000000E-06  -1.15000000E-06
   +3.40000000E-06  +2.60000000E-06  +3.76000000E-06
   -3.76000000E-06  -7.90000000E-07  -2.82000000E-06
   +3.69000000E-06  +1.41000000E-06  +2.23000000E-06
   -1.69000000E-06  -2.46000000E-06  -1.04000000E-06
   +1.30000000E-07  +7.95000000E-06  +4.23000000E-06
   +1.80000000E-07  -6.30000000E-07  +5.70000000E-07
   -1.40000000E-07  -1.14000000E-06  +2.80000000E-07
   -1.95000000E-06  -2.62000000E-06  +8.10000000E-07
   -8.00000000E-08  -7.00000000E-07  -1.84000000E-06
   +4.80000000E-07  -6.50000000E-07  -4.70000000E-07
   +2.30000000E-07  -3.00000000E-08  -2.87000000E-06
   +1.27000000E-06  -1.81000000E-06  +9.40000000E-07
   +1.04000000E-06  -3.35000000E-06  -7.10000000E-07
   +4.90000000E-07  -1.90000000E-07  -1.87000000E-06
   +3.70000000E-07  -1.36000000E-06  -2.00000000E-07
   +1.42000000E-06  +5.00000000E-08  -3.05000000E-06
   +1.07000000E-06  +7.68000000E-06  +2.50000000E-07
   +1.40000000E-06  -3.80000000E-07  -1.00000000E-06
   +4.00000000E-07  -2.00000000E-07  -8.30000000E-07
   -6.32000000E-06  -1.18000000E-06  -1.30000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.53918180E-01  -1.37843890E-01  +7.65880630E-01  +1.11807360E-01  -4.74182600E-02
   +1.88142750E-01  -1.64538870E-01  -3.18121900E-02  -1.21818100E-02  +4.26655670E-01
   -4.86235900E-02  -1.07392040E-01  -1.24995300E-02  +7.71188000E-03  +4.87419590E-01
   -2.47352900E-02  -3.06574000E-03  -4.95546700E-02  +1.40527150E-01  -4.27438100E-02
   +2.31413110E-01  -3.05781000E-03  -3.96927100E-02  -4.10362000E-03  -8.89037200E-02
   -8.30686000E-03  -1.84756700E-02  +7.61482200E-01  -1.13394700E-02  -1.46621300E-02
   -6.80097000E-03  -3.01710000E-02  -1.75784590E-01  -2.63624700E-02  -1.26642480E-01
   +6.22207020E-01  +8.69030000E-04  -1.12068800E-02  +1.64337000E-03  -1.29354100E-02
   -2.87963000E-02  -5.55537400E-02  +1.91586500E-01  +6.51562000E-03  +2.28303240E-01
   -5.63462000E-03  -1.78100000E-04  -2.31079000E-03  +2.41025000E-03  +2.83754000E-03
   +1.82651000E-03  -3.57012540E-01  +1.97245180E-01  -8.10106700E-02  +6.44432660E-01
   +2.22053000E-03  +3.62433000E-03  +9.37700000E-05  +2.33579000E-02  -2.52920900E-02
   +4.66656000E-03  +2.13467980E-01  -2.97485110E-01  +4.60458000E-02  -1.42650080E-01
   +7.84732660E-01  -2.13791000E-03  +3.10920000E-04  -7.56200000E-04  +1.53121000E-03
   +1.88200000E-03  +9.60615000E-03  -7.94987200E-02  +4.09887600E-02  -7.57311100E-02
   +1.59794490E-01  +1.09462600E-02  +1.72177770E-01  +1.08925200E-02  +3.12560500E-02
   +1.32403000E-03  +2.76645000E-03  +1.54668000E-03  +1.67915000E-03  -2.83720300E-02
   +1.52970200E-02  -8.61503000E-03  -1.60907200E-01  -6.26665300E-02  -3.11041900E-02
   +7.24778620E-01  +2.41839100E-02  -2.08897900E-02  +5.79537000E-03  +6.55290000E-04
   +4.02012000E-03  +3.06114000E-03  +2.18710500E-02  +2.04090100E-02  +8.98083000E-03
   -5.36455600E-02  -1.40483480E-01  -2.17212100E-02  -1.89770500E-01  +7.05625340E-01
   +8.68270000E-04  +7.21740000E-03  +3.07326000E-03  +6.93139000E-03  -6.86760000E-04
   -1.22276300E-02  -8.46383000E-03  +6.80355000E-03  +3.23810000E-04  -2.70544200E-02
   -2.46499400E-02  -9.18306600E-02  +1.77402270E-01  -6.92922600E-02  +2.65710600E-01
   -3.65629750E-01  +2.12048990E-01  -7.12538300E-02  -2.61073400E-02  +1.72444800E-02
   -7.18988000E-03  +2.26762000E-03  +3.84429000E-03  +1.32042000E-03  +1.93593000E-03
   -3.39794400E-02  -5.20863000E-03  -1.16558580E-01  -5.57734400E-02  -7.44397000E-03
   +7.99132740E-01  +1.94272150E-01  -2.95515140E-01  +4.63040400E-02  -1.04149000E-03
   +8.49092000E-03  -3.53862000E-03  +1.60358000E-03  -5.56416000E-03  +1.33361000E-03
   -1.39702900E-02  -1.00663000E-02  -3.44284000E-03  -4.59340100E-02  -1.92950590E-01
   -1.26245100E-02  -1.01186640E-01  +6.46373990E-01  -7.16407700E-02  +5.04907000E-02
   -6.90953400E-02  -1.18897000E-02  +1.72263000E-03  +5.03079000E-03  +4.17090000E-04
   +1.35430000E-03  +4.86410000E-04  -5.92427000E-03  -1.07442500E-02  +1.40582200E-02
   -8.28996000E-03  -1.19867700E-02  -8.29913600E-02  +1.58414070E-01  -2.97462500E-02
   +1.57285600E-01  -2.66635500E-02  +2.41346000E-03  +2.18785400E-02  -3.00330200E-02
   +1.14440500E-02  -7.22372100E-02  -4.59543000E-03  +7.59863000E-03  +5.96804000E-03
   +1.51132000E-03  -6.74080000E-04  +7.88470000E-04  -1.96831000E-03  +2.15375000E-03
   +3.30890000E-04  +1.53044000E-03  -2.40482000E-03  +5.08360000E-04  +3.98950670E-01
   -1.80154000E-03  -9.38240000E-04  +3.74785000E-03  +1.42770000E-04  -4.36627300E-02
   +2.44784900E-02  +1.27388000E-02  -1.18129300E-02  -2.36263200E-02  -4.22900000E-05
   +4.72730000E-04  +7.25140000E-04  +5.04960000E-04  -5.96240000E-04  -6.84250000E-04
   -5.99500000E-05  +3.05950000E-04  -7.11300000E-05  +3.03244600E-02  +4.65232010E-01
   +1.15261500E-02  -2.25417000E-03  +4.12780000E-04  -1.03250600E-02  -9.23518000E-03
   +2.93449400E-02  +8.95940000E-03  -1.40616100E-02  -8.56805000E-03  -3.40325000E-03
   +1.68848000E-03  -3.24875000E-03  +2.43941000E-03  -1.94610000E-03  +1.26938000E-03
   -1.66228000E-03  +3.68082000E-03  -2.85762000E-03  +1.03251390E-01  -4.37695300E-02
   +3.70221660E-01  -2.49910000E-04  +9.55480000E-04  +2.11587000E-03  +3.03746000E-03
   -6.26235000E-03  +2.28390200E-02  +5.52200000E-05  -9.13730000E-04  -1.09985000E-03
   -2.35530000E-04  +3.41720000E-04  +2.52530000E-04  +6.60350000E-04  -2.33440000E-04
   +2.51450000E-04  -4.93410000E-04  -3.56000000E-04  +8.67440000E-04  -9.34376900E-02
   +1.27669700E-02  -4.06803700E-02  +5.75643640E-01  -1.71690000E-04  -1.65980000E-04
   +2.97470000E-04  -2.07115000E-03  +2.69188000E-03  -8.42512000E-03  +2.26900000E-04
   -2.28080000E-04  -3.07370000E-04  +3.12800000E-05  -5.01130000E-04  -1.27300000E-04
   +2.53320000E-04  +1.31488000E-03  -4.53200000E-04  +4.93720000E-04  -1.40720000E-04
   -1.33495000E-03  +1.11385300E-02  -9.11021700E-02  +2.86679200E-02  +1.74276800E-02
   +5.89512640E-01  +1.49228000E-03  -4.02230000E-04  -2.59906000E-03  -1.48134000E-03
   +5.56356000E-03  -2.86647900E-02  +1.45490000E-04  -8.88900000E-05  -1.24707000E-03
   -5.26320000E-04  +1.23660000E-04  -6.85490000E-04  -3.00320000E-04  +8.47990000E-04
   +2.94000000E-06  +1.52490000E-04  +2.46590000E-04  -1.70990000E-03  -4.46436700E-02
   +3.32878700E-02  -1.44311410E-01  -3.60647700E-02  +2.89613100E-02  +4.89015550E-01
   -2.41505200E-02  +1.69342900E-02  -4.39383000E-02  -9.14819000E-02  +4.09557000E-02
   -6.23360500E-02  +3.66448000E-03  +1.31728300E-02  -6.78084000E-03  +3.05679000E-03
   +1.69920000E-04  +9.63370000E-04  -1.16787000E-03  -3.47294000E-03  -2.85344000E-03
   -3.11423000E-03  -6.55200000E-04  +5.96850000E-04  +1.25310600E-02  -9.49275000E-03
   -7.66313000E-03  -1.97837000E-03  +1.20604000E-03  +2.41728000E-03  +1.10512120E-01
   +8.89637000E-03  +6.33328000E-03  +8.56847000E-03  +5.16546700E-02  -1.16185940E-01
   +6.84861600E-02  +1.27100000E-02  -3.72749200E-02  +4.34001800E-02  +7.30470000E-04
   -2.99652000E-03  -1.56749000E-03  -3.55785000E-03  -3.02153000E-03  +1.34707000E-03
   -6.62830000E-04  +3.75442000E-03  -3.82200000E-05  -2.20476000E-02  +2.33900000E-03
   +2.14752500E-02  +3.14448000E-03  -9.52130000E-04  -1.55851000E-03  -6.34793800E-02
   +1.42496860E-01  -2.26140800E-02  +9.21221000E-03  -3.21460700E-02  -1.02620330E-01
   +9.73548300E-02  -1.28623370E-01  +4.32900000E-04  +2.21783400E-02  -1.51870600E-02
   +1.82767000E-03  +9.27520000E-04  +9.96100000E-04  +1.41100000E-05  -1.10460000E-03
   -2.54629000E-03  -2.23600000E-03  -1.71606000E-03  +3.73950000E-04  +3.29165700E-02
   -4.77599000E-03  -6.40297500E-02  -3.47067000E-03  +1.88841000E-03  -9.09020000E-04
   +1.01179480E-01  -1.25492250E-01  +2.32502440E-01  +5.79136000E-03  -2.78166000E-03
   +8.11490000E-04  -1.84255000E-03  -6.74880000E-04  +1.09985000E-03  -3.51636000E-03
   -1.30379800E-02  -3.23876000E-03  -5.89710200E-02  +4.07760100E-02  -2.72655700E-02
   -4.26719450E-01  +2.81745030E-01  -1.27445120E-01  +4.99853000E-03  +2.91928900E-02
   -5.68868000E-03  +1.48825000E-03  -1.23550000E-04  -2.44718000E-03  -4.16010000E-04
   +2.19890000E-04  +1.73370000E-04  +3.01280000E-04  +1.01143000E-03  +2.50100000E-05
   +4.78131740E-01  -1.14118300E-02  -7.85352000E-03  -2.25745000E-03  -2.12030000E-04
   -1.56045000E-03  -1.97740000E-03  -4.39782000E-03  +2.86298000E-03  -1.30400000E-03
   +1.63188400E-02  +1.72794900E-02  +5.07728000E-03  +2.81703750E-01  -3.54485710E-01
   +1.00907720E-01  +5.37704300E-02  -5.42750000E-02  +1.84814600E-02  -1.58948000E-03
   +8.88400000E-05  +2.04136000E-03  +2.88500000E-04  -6.36970000E-04  -3.33800000E-04
   +1.24522000E-03  +7.85860000E-04  +5.12070000E-04  -3.42543580E-01  +3.92524440E-01
   +1.45899000E-03  -3.13380000E-04  +2.15159000E-03  -1.20179000E-03  -2.06020000E-04
   +2.14255000E-03  -2.31236000E-03  -4.38491000E-03  +7.51230000E-04  -2.80882400E-02
   +1.39167300E-02  +1.28178600E-02  -1.26506460E-01  +9.99746700E-02  -1.11691640E-01
   -6.63195000E-03  +1.11062000E-02  +2.00630600E-02  +5.49750000E-04  -4.78700000E-05
   -1.00026000E-03  -2.55370000E-04  +3.06780000E-04  +1.95630000E-04  +2.77640000E-04
   +1.84520000E-04  +7.43400000E-05  +1.59846060E-01  -1.22629940E-01  +8.25030700E-02
   +3.76240000E-04  +2.01010000E-03  +5.16990000E-04  -2.53466300E-02  -8.66714000E-03
   +1.67744800E-02  -6.74210000E-04  +2.47392000E-03  +1.47236000E-03  -9.21100000E-05
   -1.12029000E-03  +2.95850000E-04  -8.09490000E-04  -1.10471000E-03  -3.06960000E-04
   -9.85870000E-04  +1.05200000E-05  -4.06020000E-04  -1.50095590E-01  -3.90705000E-02
   -3.01936200E-02  -1.59782800E-02  -4.46292000E-03  -7.93740000E-03  -3.35219000E-03
   +3.45821000E-03  -5.41309000E-03  +2.05520000E-04  +3.15370000E-04  +1.64500000E-05
   +5.50068300E-01  +8.92970000E-04  +4.07610000E-04  -1.73799000E-03  +3.81350000E-04
   +8.15800000E-05  +4.44046000E-03  +3.39635000E-03  -6.52590000E-04  -1.05813000E-03
   -1.33490000E-04  -3.58010000E-04  +7.98200000E-05  -4.14230000E-04  -3.85380000E-04
   -1.07200000E-05  -2.14150000E-04  +3.27570000E-04  +7.22600000E-05  -3.33987900E-02
   -9.89262000E-02  +3.94840000E-03  +8.76052000E-03  +6.94559000E-03  -9.39010000E-04
   -1.53588000E-03  +1.44497000E-03  -3.29840000E-04  +1.62570000E-04  +1.26820000E-04
   -2.66500000E-05  +1.07384840E-01  +4.71725740E-01  +6.50310000E-04  -1.01810000E-03
   -3.01763000E-03  +1.66909500E-02  +7.25069000E-03  -3.56832000E-03  +1.11154000E-03
   -2.25930000E-04  +2.69370000E-04  +5.23560000E-04  -1.65750000E-04  +2.55890000E-04
   -3.15500000E-04  +5.31340000E-04  -3.25520000E-04  +5.70160000E-04  -1.86820000E-04
   +5.80480000E-04  -1.73410600E-02  +7.79333000E-03  -8.27338200E-02  -2.68217900E-02
   -1.18634700E-02  -5.98538000E-03  +3.01879000E-03  -6.80800000E-05  +2.75213000E-03
   +4.47870000E-04  -4.73530000E-04  +2.39330000E-04  +1.20100990E-01  -2.10370530E-01
   +4.58062500E-01  +2.60960000E-04  -5.76110000E-04  +1.56350000E-04  +1.86272000E-03
   +1.20884000E-03  -4.62517000E-03  -2.33740000E-04  -1.35840000E-04  -2.32340000E-04
   +5.66400000E-05  +2.31940000E-04  +1.37500000E-05  -1.38610000E-04  +9.83000000E-06
   +1.63280000E-04  +3.26280000E-04  +1.98820000E-04  +6.16700000E-05  -2.69883600E-02
   +6.99521000E-03  -2.13669200E-02  -3.28559000E-03  -3.68635000E-03  +8.82400000E-04
   -3.24744000E-03  -7.82540000E-04  +2.99588000E-03  +6.70200000E-05  -1.11200000E-05
   -2.56700000E-05  -1.81348150E-01  +4.29139000E-03  -7.11250800E-02  +6.11079190E-01
   +8.71700000E-05  +9.15020000E-04  +2.10190000E-04  -3.42215000E-03  -1.22236000E-03
   +2.23886000E-03  +1.37125000E-03  -1.35400000E-04  +1.88630000E-04  -1.75900000E-04
   -4.02560000E-04  -1.12430000E-04  -2.30930000E-04  -4.03260000E-04  -1.23860000E-04
   -2.35260000E-04  -7.73100000E-05  -9.83800000E-05  -3.55205000E-03  +9.03880000E-03
   -1.24689400E-02  -4.05247000E-03  -1.42690000E-03  +1.53060000E-04  +1.00043000E-03
   +7.48920000E-04  -1.98135000E-03  +5.66700000E-05  +1.60330000E-04  +4.41800000E-05
   +4.77058500E-02  -1.30772170E-01  +8.77194300E-02  +1.65377740E-01  +5.00961830E-01
   -3.02170000E-04  -6.51060000E-04  +2.23390000E-04  +2.96868000E-03  +1.40044000E-03
   -3.37715000E-03  -5.72870000E-04  -9.45200000E-04  -9.06070000E-04  +4.17320000E-04
   +7.03380000E-04  +7.96000000E-05  -1.83730000E-04  +1.34210000E-04  +6.83600000E-05
   +3.47270000E-04  +1.19540000E-04  +1.26190000E-04  -1.08848200E-02  -4.03074000E-03
   +6.26690000E-04  +2.47990000E-04  +4.74090000E-04  +5.74240000E-04  +1.24414000E-03
   -6.82260000E-04  +1.86685000E-03  +1.91120000E-04  -1.29830000E-04  +4.46800000E-05
   -1.16494340E-01  +6.12892900E-02  -2.00339780E-01  +1.22849400E-01  -2.48733710E-01
   +4.70721740E-01  -4.69100000E-05  -1.34990000E-04  -7.27500000E-05  +4.89300000E-05
   +1.47890000E-04  +2.23632000E-03  -3.53250000E-04  -2.94590000E-04  -1.00130000E-04
   +1.29810000E-04  +9.57200000E-05  +7.90600000E-05  +3.05430000E-04  -6.19400000E-05
   -2.66100000E-05  -2.84000000E-06  +2.66000000E-06  +6.44100000E-05  +5.20854000E-03
   +1.45593000E-03  -4.71171000E-03  -8.19140000E-04  -3.77610000E-04  -4.75800000E-05
   -1.13930000E-04  +4.18550000E-04  -6.56740000E-04  -1.53620000E-04  +6.60900000E-05
   -3.96000000E-06  -3.74970100E-02  +2.98602000E-02  -5.69414100E-02  -3.03505330E-01
   -1.22664220E-01  -2.99710300E-02  +6.31033120E-01  -4.55000000E-06  -2.57630000E-04
   +5.52700000E-05  -9.68500000E-05  -4.02630000E-04  +3.11370000E-03  -7.38630000E-04
   -3.54020000E-04  -2.40250000E-04  +8.11600000E-05  +2.65320000E-04  +6.98800000E-05
   +3.48980000E-04  -2.64460000E-04  +9.75000000E-06  -6.19200000E-05  +1.83470000E-04
   +6.37000000E-06  +3.95023000E-03  +1.54827000E-03  +2.96182000E-03  +1.02185000E-03
   +6.29150000E-04  -1.12800000E-04  -6.49430000E-04  +8.59190000E-04  -6.91380000E-04
   -2.66850000E-04  +2.19730000E-04  -6.05300000E-05  -7.39743000E-03  +4.28452600E-02
   -3.82821200E-02  -7.56822700E-02  -1.37462800E-01  +2.88256500E-02  +1.37689940E-01
   +4.63833180E-01  -1.21200000E-04  +2.54130000E-04  -1.65500000E-05  -9.85670000E-04
   -2.76450000E-04  +1.61690000E-04  +1.15320000E-04  +1.67630000E-04  +5.94900000E-05
   +1.09110000E-04  -1.23730000E-04  +7.01600000E-05  -2.52120000E-04  +6.59100000E-05
   -1.24700000E-04  +2.10600000E-05  -1.12670000E-04  -2.21600000E-05  -3.64726000E-03
   +4.16293000E-03  -8.96670000E-04  -9.88120000E-04  -4.41230000E-04  +1.43370000E-04
   +9.36290000E-04  -9.14000000E-06  -5.22310000E-04  +2.04320000E-04  -1.16950000E-04
   +8.95000000E-05  -2.16430400E-02  -1.49333800E-02  +1.02281000E-02  -7.64517000E-02
   -1.26211000E-03  -1.07489430E-01  +1.79970900E-01  -2.43017410E-01  +4.75231740E-01
   -5.22660000E-04  -1.57910000E-04  -2.37490000E-04  +6.43780000E-04  +1.08221000E-03
   -3.22465000E-03  -3.08480000E-04  +2.73730000E-04  +2.04200000E-05  +6.87930000E-04
   +1.59590000E-04  +1.50650000E-04  -1.08603000E-03  +6.25170000E-04  -2.95590000E-04
   +2.67940000E-04  -3.69780000E-04  +9.87200000E-05  -4.97479000E-03  -5.04580000E-04
   +1.00437000E-03  +3.27020000E-04  +1.38490000E-04  -6.59600000E-05  +1.54468000E-03
   -7.03610000E-04  +1.26019000E-03  +9.43650000E-04  -6.93960000E-04  +2.63130000E-04
   +2.52170000E-03  +1.42764800E-02  -7.38371000E-03  -3.83927000E-03  -2.84572600E-02
   +2.43225800E-02  -1.35202440E-01  -7.91547000E-02  +3.58970500E-02  +6.31687620E-01
   +4.50800000E-05  +1.48220000E-04  -7.57300000E-05  -1.86560000E-04  -4.35200000E-05
   -1.74725000E-03  +1.82950000E-04  +2.37530000E-04  +1.02060000E-04  +1.22400000E-04
   -6.21700000E-05  +5.44000000E-06  -5.31750000E-04  +1.55630000E-04  -8.01100000E-05
   +3.51300000E-05  -5.21400000E-05  -3.93000000E-05  -2.54223000E-03  -1.37314000E-03
   +1.66723000E-03  +4.34700000E-05  +1.48790000E-04  +1.38930000E-04  +1.59660000E-04
   -3.39440000E-04  +6.06030000E-04  +3.64910000E-04  -2.22230000E-04  +8.10500000E-05
   +1.47608900E-02  -3.89758700E-02  +4.04206900E-02  -6.82621700E-02  -1.62632200E-02
   -2.51378800E-02  -2.35114900E-02  -2.18610580E-01  +1.29681810E-01  +1.33444080E-01
   +4.91648730E-01  -3.31060000E-04  -4.89720000E-04  -2.08650000E-04  +1.39020000E-03
   +1.06875000E-03  -2.40130000E-04  -6.82050000E-04  +1.07650000E-04  +6.84400000E-05
   +1.83540000E-04  +1.47410000E-04  +4.50500000E-05  +5.02000000E-05  +3.78860000E-04
   -4.27500000E-05  +1.82790000E-04  -1.60340000E-04  +1.14090000E-04  -4.54370000E-04
   +5.74930000E-04  -1.30311000E-03  +7.05300000E-05  +1.33800000E-04  -2.19780000E-04
   +4.69250000E-04  -2.48130000E-04  +4.52500000E-04  +1.04470000E-04  -2.23830000E-04
   +3.39700000E-05  -8.90607000E-03  +4.01189700E-02  -4.95432500E-02  +6.19637300E-02
   +4.35350000E-04  +4.13856000E-02  -1.78256200E-02  +9.48094400E-02  -1.72829440E-01
   +1.58071730E-01  -2.31850430E-01  +4.85660610E-01  +5.76470000E-04  +4.19430000E-04
   +1.31180000E-04  -1.05450000E-03  -1.46806000E-03  +2.13481000E-03  +4.74690000E-04
   -2.59800000E-04  -4.51730000E-04  -1.06280000E-04  +2.39600000E-05  -5.27800000E-05
   -2.33500000E-05  -6.27960000E-04  +7.14400000E-05  -2.43220000E-04  +3.59040000E-04
   -1.47450000E-04  +5.74316000E-03  -1.15737000E-03  -1.02348000E-03  -1.96530000E-04
   -5.60400000E-05  +4.31100000E-04  -1.28703000E-03  +7.10470000E-04  -9.29650000E-04
   -1.90510000E-04  +3.74030000E-04  -8.06100000E-05  -5.04018000E-03  -6.28753900E-02
   +5.08745300E-02  -5.45337700E-02  +1.32135000E-03  -3.39772300E-02  +5.41203600E-02
   +4.20583500E-02  -1.26183200E-02  -1.72711520E-01  +4.37892000E-03  -6.58409100E-02
   +6.22568190E-01  +1.08740000E-04  +6.75100000E-05  +2.18570000E-04  -3.00170000E-04
   -5.52060000E-04  +3.06180000E-04  -2.19240000E-04  -2.31660000E-04  -3.01180000E-04
   +1.67930000E-04  +2.36390000E-04  -5.91000000E-06  -3.21210000E-04  -2.42150000E-04
   -1.08200000E-05  -5.48200000E-05  +1.61590000E-04  -4.54600000E-05  -1.67882000E-03
   -2.01900000E-04  +4.87039000E-03  +7.92980000E-04  -1.30000000E-05  +2.40580000E-04
   -4.61590000E-04  +3.82100000E-05  -1.30110000E-04  +1.32270000E-04  +6.39600000E-05
   +1.07300000E-05  -2.71167600E-02  -1.32473300E-02  +4.57956000E-03  -1.15446000E-03
   -2.41558000E-03  -1.67957000E-03  +1.13210300E-02  -8.83061000E-03  +2.37280500E-02
   +5.67108500E-02  -1.44927540E-01  +1.05019660E-01  +1.70647840E-01  +5.09657790E-01
   +3.06720000E-04  +4.29530000E-04  +1.58500000E-04  -1.68930000E-03  -1.46749000E-03
   +2.48983000E-03  +1.52660000E-04  -1.26810000E-04  -3.73780000E-04  -6.13600000E-05
   -6.42900000E-05  +4.17500000E-05  -5.41900000E-05  -5.63470000E-04  +3.59400000E-05
   -2.05530000E-04  +2.54970000E-04  -8.64000000E-05  +1.41919000E-03  +5.87678000E-03
   -1.48700000E-05  -9.28070000E-04  -3.72620000E-04  -3.54040000E-04  -7.95890000E-04
   +7.62400000E-04  -1.14596000E-03  -1.40850000E-04  +3.20630000E-04  -5.16800000E-05
   +1.82838600E-02  -1.89078700E-02  +3.54057000E-02  -3.04553800E-02  +3.73000000E-05
   -2.22909800E-02  +1.70796100E-02  +4.27821300E-02  -2.19460800E-02  -1.16611900E-01
   +7.26573900E-02  -2.12678320E-01  +1.38575870E-01  -2.59350430E-01  +4.62980820E-01
   -3.46590000E-04  -6.80500000E-05  +2.65730000E-04  -4.51640000E-04  +1.65970000E-04
   -4.50260000E-04  -5.63220000E-04  -2.30790000E-04  +9.49510000E-04  -2.43000000E-05
   +8.78500000E-05  -4.65700000E-05  +2.48200000E-04  +1.63100000E-05  -3.25300000E-05
   +6.73600000E-05  -6.84200000E-05  +6.32600000E-05  -1.12240600E-02  -2.51089500E-02
   +1.37422500E-02  -2.04735000E-03  -1.28509000E-03  +2.86840000E-04  +6.71910000E-04
   -1.38210000E-04  -1.51450000E-04  -9.28400000E-05  +2.02600000E-05  -1.21200000E-05
   -1.39844290E-01  -3.90613700E-02  -3.94832000E-03  +5.50451900E-02  +1.11435900E-02
   +1.83500300E-02  -3.74970900E-02  -3.19936700E-02  +1.01824500E-02  -3.96186800E-02
   +3.58006300E-02  -6.01574500E-02  -3.02026070E-01  -1.23649900E-01  -2.85383200E-02
   +6.28200520E-01  -6.67140000E-04  -5.04620000E-04  +1.99920000E-04  +2.16942000E-03
   +1.57870000E-03  -5.40176000E-03  -2.82210000E-04  -3.35220000E-04  -8.43040000E-04
   +5.88150000E-04  +2.98020000E-04  +1.92950000E-04  -2.69070000E-04  +4.20690000E-04
   -5.71300000E-05  +4.85510000E-04  -1.95070000E-04  +3.08150000E-04  -1.54519500E-02
   -9.03905000E-03  +4.25045000E-03  -1.02353000E-03  -1.15760000E-03  +2.43650000E-04
   +2.22980000E-03  -1.20421000E-03  +1.67950000E-03  +3.56140000E-04  -3.57760000E-04
   +1.49790000E-04  -8.39039900E-02  -2.15821490E-01  +9.34445700E-02  +4.61785400E-02
   -1.39948100E-02  +5.06865300E-02  -3.56662800E-02  -3.58822000E-02  +9.42125000E-03
   -4.00468000E-03  +4.87519100E-02  -4.77000100E-02  -7.53946300E-02  -1.41272470E-01
   +3.04680800E-02  +1.21684920E-01  +4.71971320E-01  +8.01100000E-05  -2.94100000E-05
   +3.50750000E-04  -7.25530000E-04  -4.74730000E-04  +6.18770000E-04  +8.14800000E-04
   -3.13070000E-04  -5.00740000E-04  -1.86150000E-04  +2.32900000E-04  -2.86800000E-04
   +2.59700000E-05  -2.65950000E-04  +7.05000000E-05  -1.18820000E-04  +1.76400000E-04
   -2.48600000E-05  +2.07280000E-03  -5.18497000E-03  +6.68588000E-03  -2.91430000E-04
   -1.38582000E-03  -2.41570000E-04  -3.90120000E-04  +1.32660000E-04  -5.36970000E-04
   -1.17570000E-04  +1.91280000E-04  -8.54900000E-05  +3.79634900E-02  +1.19978660E-01
   -1.57647080E-01  -1.56020800E-02  +2.82790900E-02  -2.82669900E-02  +1.27831800E-02
   +1.10877200E-02  -6.56740000E-03  -2.24338400E-02  -2.21105500E-02  +9.72658000E-03
   -7.30793000E-02  +4.70560000E-04  -1.06793260E-01  +1.75505200E-01  -2.36853740E-01
   +4.79409070E-01  +5.05460000E-04  +2.30640000E-04  +3.81370000E-04  -6.94760000E-04
   -1.29490000E-03  +3.58120000E-03  +1.36460000E-04  -4.73310000E-04  -1.03120000E-04
   -6.05580000E-04  -6.25700000E-05  -1.10970000E-04  +1.12297000E-03  -8.44550000E-04
   +2.87060000E-04  -3.03060000E-04  +4.27500000E-04  -8.91200000E-05  +5.48485000E-03
   +8.94720000E-04  -1.03585000E-03  -5.40000000E-04  -3.23010000E-04  +8.38100000E-05
   -1.58048000E-03  +9.92330000E-04  -1.42585000E-03  -1.00687000E-03  +8.17140000E-04
   -2.78050000E-04  -5.62031000E-03  -3.73468000E-03  -4.42800000E-04  +3.84123000E-03
   -1.57813000E-03  -6.76320000E-04  -2.76740100E-02  -2.00561100E-02  -4.20264000E-03
   -2.64891900E-01  -1.15683490E-01  -2.41243100E-02  -4.44215700E-02  -1.38809500E-02
   -1.84096200E-02  +5.76634000E-03  +3.42228000E-03  -2.18493000E-03  +4.74696600E-01
   +2.14750000E-04  +5.20700000E-05  +1.87830000E-04  -7.97300000E-05  -4.11740000E-04
   +1.17897000E-03  -1.51100000E-05  -2.45320000E-04  -2.35500000E-05  -2.17560000E-04
   +5.84000000E-06  -4.15300000E-05  +4.43810000E-04  -3.85080000E-04  +1.11370000E-04
   -1.14670000E-04  +1.98330000E-04  -2.46900000E-05  +2.32442000E-03  +2.39490000E-04
   -9.29570000E-04  -2.01410000E-04  -1.49060000E-04  +6.84000000E-05  -7.24800000E-04
   +3.96140000E-04  -4.19050000E-04  -4.06100000E-04  +3.61160000E-04  -1.11150000E-04
   -2.92389000E-03  +1.40768000E-03  -4.82574000E-03  +4.58643000E-03  +7.33090000E-04
   +9.48774000E-03  -4.61764700E-02  -1.55119800E-02  -3.63894000E-03  -8.10459500E-02
   -1.25034800E-01  +2.72608100E-02  +1.18948200E-02  +1.55445500E-02  -1.69680000E-04
   -2.10082000E-03  -2.63134000E-03  +6.28354000E-03  +3.23510800E-02  +2.67765650E-01
   +1.29720000E-04  +1.31820000E-04  +1.04050000E-04  -4.20170000E-04  -3.54720000E-04
   +6.63040000E-04  +1.14520000E-04  -9.45400000E-05  +5.92000000E-06  -1.12600000E-04
   -5.61900000E-05  -9.10000000E-07  +1.68920000E-04  -2.08780000E-04  +2.69500000E-05
   -7.63000000E-05  +8.91100000E-05  -2.03900000E-05  +1.43072000E-03  -3.01840000E-04
   -2.97020000E-04  -1.72510000E-04  -4.26800000E-05  +6.86600000E-05  -3.26540000E-04
   +2.38910000E-04  -3.45980000E-04  -1.74660000E-04  +1.73040000E-04  -3.28100000E-05
   +2.24880000E-04  -4.69399000E-03  +3.08723000E-03  -6.57798000E-03  +5.34797000E-03
   -1.99192000E-03  +2.09626500E-02  +1.26166900E-02  +1.11263800E-02  -5.74494900E-02
   +5.92870000E-03  -8.58797100E-02  -4.33406000E-02  -1.60760700E-02  -3.49201000E-03
   +2.40053000E-03  +9.49311000E-03  -2.20797000E-03  +2.43602410E-01  -2.10813910E-01
   +3.80203910E-01  +7.28280000E-04  +2.25691000E-03  -3.35370000E-04  -3.90131000E-03
   +1.40253900E-02  +8.65468000E-03  -1.04403000E-03  -1.14624000E-03  +2.24808000E-03
   -7.72570000E-04  +3.07860000E-04  -5.02350000E-04  +1.04574000E-03  +2.77700000E-04
   +6.19930000E-04  -3.78470000E-04  -3.48900000E-04  -6.19000000E-05  -7.38383500E-02
   +3.83252000E-03  -7.11489000E-03  -1.49767000E-03  +1.65090700E-02  -2.28765000E-03
   -1.30682000E-03  +4.61487000E-03  -9.85710000E-04  -6.29730000E-04  +1.80880000E-04
   -2.60070000E-04  -1.19597000E-03  -3.26602500E-02  -5.70630000E-04  -5.65920000E-04
   -1.67801000E-03  -4.65460000E-04  +2.97790000E-04  -2.33150000E-04  +4.98250000E-04
   +1.10481000E-03  -1.44340000E-04  +7.28880000E-04  -1.87746000E-03  +1.41900000E-04
   +7.34590000E-04  -2.80025000E-03  -2.97240000E-04  -2.73958000E-03  -1.41601000E-03
   -4.80650000E-04  -3.54680000E-04  +5.87832180E-01  +1.23924000E-03  +1.38220000E-03
   -5.22330000E-04  +3.85929000E-03  -9.29558000E-03  -5.38586000E-03  +5.80230000E-04
   -2.06110000E-04  +1.73840000E-04  -1.36520000E-04  -2.19900000E-05  -3.19430000E-04
   +3.90000000E-05  -9.80900000E-05  +7.93500000E-05  -6.24650000E-04  -4.82020000E-04
   -2.85180000E-04  +6.58814000E-03  -1.80154220E-01  +8.09040000E-04  +4.11938000E-03
   -2.04458000E-02  +6.05559000E-03  +1.53083000E-03  -1.66093000E-03  -9.91320000E-04
   -4.25700000E-05  +1.17600000E-05  +5.07000000E-06  -8.65707000E-03  -1.89497200E-02
   -2.08136000E-03  +9.85910000E-04  -1.22620000E-04  -1.39070000E-04  +2.87840000E-04
   -2.55470000E-04  +5.70010000E-04  -4.24900000E-05  -7.22700000E-05  +2.36540000E-04
   -4.63110000E-04  +9.13300000E-05  +2.06900000E-04  +4.45190000E-04  +2.88820000E-04
   -1.38697000E-03  +4.01500000E-05  +9.86000000E-06  +2.16000000E-06  +9.67250000E-03
   +4.71787260E-01  -5.92370000E-04  +3.88770000E-04  +2.60370000E-04  +6.05071000E-03
   -2.08156900E-02  -1.30019500E-02  +2.02689000E-03  +1.37964000E-03  -2.70152000E-03
   +7.47100000E-04  -8.60880000E-04  +7.21610000E-04  -9.89080000E-04  +2.03210000E-04
   -7.10480000E-04  -1.22790000E-04  -9.73130000E-04  +5.51100000E-05  -7.56002000E-03
   -3.10955000E-03  -7.16916100E-02  -5.36783000E-03  +3.28073500E-02  -8.76110000E-04
   +2.15257000E-03  -5.50369000E-03  +2.37061000E-03  +8.61320000E-04  -5.91040000E-04
   +4.08400000E-04  +8.74590000E-04  -6.11415000E-03  +9.54150000E-04  -7.94280000E-04
   -4.23430000E-04  +3.01130000E-04  +4.40140000E-04  +4.05090000E-04  -4.61200000E-05
   -5.52100000E-05  -3.28380000E-04  +6.81900000E-05  +1.15400000E-05  +8.02000000E-06
   +2.36920000E-04  -4.12250000E-04  +5.20900000E-05  -5.58360000E-04  +1.70460000E-04
   +1.26310000E-04  +8.78000000E-06  +1.16278400E-02  -2.53027100E-02  +5.92517870E-01
   -6.44800000E-05  +9.01000000E-06  -3.71300000E-05  -7.79600000E-05  +6.48600000E-05
   -2.58500000E-04  -3.26300000E-05  +4.85000000E-05  -9.84000000E-06  +1.21560000E-04
   +1.62300000E-05  +3.14000000E-05  -2.28750000E-04  +7.23800000E-05  -6.52300000E-05
   +3.08500000E-05  -4.31000000E-05  +6.61000000E-06  -4.57050000E-04  -1.49670000E-04
   +2.27470000E-04  +6.35300000E-05  +4.81400000E-05  +2.26000000E-06  +2.18910000E-04
   -4.83000000E-05  +6.92200000E-05  +1.78850000E-04  -1.05720000E-04  +5.18900000E-05
   +6.52790000E-04  -3.14510000E-04  +6.99360000E-04  -9.45930000E-04  +2.59400000E-04
   -4.51740000E-04  +3.51388000E-03  +2.34756000E-03  +5.55520000E-04  -2.78239900E-02
   +2.03543900E-02  -3.49638400E-02  -4.63148000E-03  -4.97307000E-03  +4.33690000E-04
   +4.17870000E-04  +1.00754000E-03  -1.78749000E-03  -1.43798380E-01  +8.11826000E-02
   -1.64016330E-01  +1.20240000E-04  +1.16600000E-05  -4.08900000E-05  +1.73003260E-01
   -1.42300000E-05  +2.12400000E-05  -1.45700000E-05  -1.08420000E-04  -4.34700000E-05
   +1.23080000E-04  +3.92000000E-05  +1.84400000E-05  -1.00800000E-05  +3.05000000E-06
   -6.72000000E-06  -4.78000000E-06  -2.15400000E-05  +3.17200000E-05  -1.60000000E-06
   -6.50000000E-06  -2.51300000E-05  -8.01000000E-06  +2.28520000E-04  -5.26900000E-05
   +6.92400000E-05  +3.32500000E-05  +1.08300000E-05  +3.20000000E-06  +4.30100000E-05
   +1.50500000E-05  -7.63000000E-05  +2.18400000E-05  -2.94900000E-05  +1.55000000E-06
   -1.62050000E-04  -2.52010000E-04  +1.45550000E-04  +1.58510000E-04  -6.38220000E-04
   +6.68600000E-05  -2.31538000E-03  +7.12140000E-04  -3.14536000E-03  -1.23198700E-02
   +7.07903000E-03  -1.70154500E-02  -4.00135000E-03  -2.66850000E-04  +9.80200000E-05
   -8.80600000E-05  +1.39019000E-03  +3.20630000E-04  +1.16554040E-01  -1.41330540E-01
   +2.03666490E-01  -6.85500000E-05  -3.10000000E-07  -2.54600000E-05  -9.82890700E-02
   +1.34343640E-01  -4.39100000E-05  -1.72800000E-05  -3.74300000E-05  +8.49500000E-05
   +1.15100000E-04  -3.39010000E-04  +1.10200000E-05  +4.86700000E-05  +1.03600000E-05
   +2.71300000E-05  -3.82000000E-06  -4.38000000E-06  -5.00600000E-05  +8.06200000E-05
   -4.24000000E-06  +2.28800000E-05  -4.43100000E-05  +3.78000000E-06  -4.88830000E-04
   -6.89800000E-05  +8.34500000E-05  +4.19400000E-05  +2.22200000E-05  +5.28000000E-06
   +1.44210000E-04  -1.09090000E-04  +1.22460000E-04  +5.71800000E-05  -6.28300000E-05
   +8.44000000E-06  +4.25340000E-04  +1.07830000E-04  +3.68190000E-04  -3.28830000E-04
   +1.69150000E-04  -1.02551000E-03  +5.05806000E-03  -2.81080000E-04  +2.38129000E-03
   -3.55314000E-03  +3.08987000E-03  -7.89997000E-03  -5.10900000E-04  -5.17340000E-04
   +2.50718000E-03  -6.45540000E-04  +9.97760000E-04  +3.25460000E-04  -1.98031750E-01
   +1.81908480E-01  -3.00676240E-01  +8.05500000E-05  -1.21800000E-05  -7.25000000E-06
   +1.98039230E-01  -1.85189470E-01  +3.04417870E-01  +5.67900000E-05  -8.82000000E-06
   +4.20200000E-05  +4.17300000E-05  -4.14800000E-05  +2.64210000E-04  -4.70900000E-05
   -6.24500000E-05  +2.88000000E-06  -2.09900000E-05  +1.58000000E-05  +3.95000000E-06
   +6.67200000E-05  -6.67600000E-05  -2.57000000E-06  -5.42000000E-06  +4.02200000E-05
   +5.86000000E-06  +1.58560000E-04  +7.05400000E-04  -1.31604000E-03  -4.77890000E-04
   -2.22990000E-04  +6.37700000E-05  -9.98000000E-05  +9.00800000E-05  -6.25100000E-05
   -6.16300000E-05  +5.67300000E-05  -7.09000000E-06  -2.76180000E-03  -4.74599000E-03
   -1.62536000E-03  -1.19285800E-02  +1.27064700E-02  -2.15353400E-02  -1.44754060E-01
   +5.25711400E-02  -1.20996720E-01  +6.13833000E-03  -5.69879000E-03  +6.83162000E-03
   +1.29422000E-03  -3.09046000E-03  +3.56120000E-04  -7.77600000E-04  -6.49990000E-04
   +7.08690000E-04  +2.45310000E-03  +1.60750000E-03  +2.35987000E-03  -1.59500000E-05
   +1.25440000E-04  +2.70300000E-05  -1.85170000E-04  +4.33170000E-04  -8.66080000E-04
   +1.50752650E-01  -9.96000000E-06  +2.46000000E-05  +8.96000000E-06  -5.71900000E-05
   +1.55800000E-05  -3.18000000E-06  +6.24100000E-05  +8.40000000E-06  +2.94000000E-06
   -1.97200000E-05  -2.32200000E-05  -1.61100000E-05  +1.61800000E-05  +1.38500000E-05
   +1.31400000E-05  -8.67000000E-06  -1.85900000E-05  -7.28000000E-06  -3.80960000E-04
   +5.45750000E-04  -3.70310000E-04  -9.31700000E-05  -1.50670000E-04  +3.97700000E-05
   +8.01800000E-05  -5.21700000E-05  -5.82400000E-05  -7.21000000E-06  -5.11000000E-06
   -6.42000000E-06  -4.24778000E-03  +2.56673000E-03  +2.17205000E-03  -8.01286000E-03
   +8.24896000E-03  -1.03866500E-02  +5.30754000E-02  -8.95987300E-02  +8.78925300E-02
   +1.60214300E-02  -3.75772000E-03  +1.77308800E-02  -3.52566000E-03  -1.47186000E-03
   +4.48559000E-03  -8.71670000E-04  -9.93930000E-04  -4.69550000E-04  +2.13046000E-03
   +8.56400000E-05  -2.49735000E-03  +1.16200000E-05  -1.70600000E-05  +3.54100000E-05
   -1.55888000E-03  -6.36860000E-04  +2.10600000E-04  -5.52427300E-02  +8.72725500E-02
   +1.72900000E-05  +2.88900000E-05  +2.73500000E-05  -3.76500000E-05  -3.46100000E-05
   +5.28200000E-05  +4.81200000E-05  -2.01100000E-05  -1.48000000E-06  -4.39800000E-05
   -1.82300000E-05  -1.20400000E-05  +6.78000000E-05  -2.92800000E-05  +2.33300000E-05
   -1.93800000E-05  +7.77000000E-06  -8.16000000E-06  -1.73600000E-05  +4.06400000E-04
   -9.02900000E-05  -2.99300000E-05  -1.16500000E-04  +6.41600000E-05  -2.19800000E-05
   -1.11700000E-05  -5.97000000E-05  -5.51900000E-05  +3.45600000E-05  -1.64900000E-05
   -1.91549000E-03  +1.69469000E-03  +4.54008000E-03  -1.75396000E-03  +2.47564000E-03
   -8.25300000E-04  -1.21247600E-01  +8.81463300E-02  -1.95784930E-01  -1.44227200E-02
   +3.75089000E-03  -8.54979000E-03  +7.35710000E-04  +4.75687000E-03  +1.25874000E-03
   +9.98200000E-04  -1.32380000E-04  -1.22240000E-04  +1.93210000E-03  -2.75626000E-03
   +7.91600000E-05  -7.50700000E-05  -5.99500000E-05  +5.65300000E-05  +1.07444000E-03
   +1.45175000E-03  -2.07410000E-04  +1.33872120E-01  -9.70414000E-02  +2.02006690E-01
   -1.09200000E-04  -4.19930000E-04  -1.08420000E-04  -3.55460000E-04  +5.63710000E-04
   +1.71991000E-03  -1.55790000E-04  +8.50500000E-05  -2.08320000E-04  +7.24200000E-05
   +2.36300000E-05  +2.26700000E-05  -2.80100000E-05  +2.17340000E-04  -3.17400000E-05
   +1.60320000E-04  +1.19500000E-05  +2.83100000E-05  +9.30370000E-04  +4.07770000E-04
   +4.85800000E-05  -1.13000000E-04  +1.65060000E-04  +1.32670000E-04  -1.74974000E-03
   +2.10160000E-04  -3.40430000E-04  +7.89100000E-05  -1.37750000E-04  +2.89600000E-05
   +1.02904200E-02  +1.36837100E-02  -9.91857000E-03  -8.13887500E-02  -7.02382400E-02
   +4.40941500E-02  -4.74307000E-03  -2.27404300E-02  +1.68288400E-02  -2.92965000E-03
   -3.18619000E-03  -3.65190000E-03  -1.10474000E-03  +3.17250000E-04  -2.52600000E-04
   -1.13569000E-03  +5.21970000E-04  -4.62922000E-03  -8.90200000E-04  -1.28730000E-03
   +8.34410000E-04  -8.47270000E-04  -3.49170000E-04  -8.02340000E-04  +2.17920000E-04
   -2.98100000E-05  +1.60720000E-04  +1.18300000E-05  +1.55058000E-03  +1.29249000E-03
   +8.40069100E-02  +1.70150000E-04  -5.27340000E-04  +2.00400000E-05  +1.78113000E-03
   +9.17680000E-04  -1.56152000E-03  -4.87080000E-04  -1.11770000E-04  +8.22000000E-06
   +9.94000000E-06  +1.97350000E-04  -1.96300000E-05  +2.02280000E-04  +1.34890000E-04
   +1.05820000E-04  +9.92000000E-05  +1.12470000E-04  +6.36200000E-05  -1.15303000E-03
   -1.93587000E-03  -8.33420000E-04  +2.28740000E-04  -1.70540000E-04  -1.33990000E-04
   -1.12714000E-03  -3.65900000E-04  +1.32219000E-03  -1.13820000E-04  -1.58600000E-05
   -5.27500000E-05  -4.01827000E-03  -4.23779000E-03  +6.08195000E-03  -6.97878800E-02
   -2.13722260E-01  +1.33217440E-01  -2.76413000E-03  -5.36996000E-03  +8.51871000E-03
   -3.77740000E-03  +4.15399000E-03  +1.72900000E-03  +6.89620000E-04  -1.65700000E-05
   -7.51380000E-04  +2.56020000E-04  +2.51981000E-03  +3.98262000E-03  -3.07820000E-04
   -7.17660000E-04  +2.60170000E-04  -7.51520000E-04  -2.46850000E-04  -6.60250000E-04
   +1.26270000E-04  -9.00000000E-06  +7.75800000E-05  +1.35831000E-03  -1.39712000E-03
   -2.42946000E-03  +8.10385700E-02  +2.21941740E-01  -1.16400000E-05  +5.56430000E-04
   -5.66600000E-05  -1.34318000E-03  -4.60200000E-04  -4.42180000E-04  +6.29680000E-04
   +2.34710000E-04  +2.07970000E-04  -1.18330000E-04  -2.79390000E-04  -3.34500000E-05
   -8.30900000E-05  +1.61900000E-05  -2.39000000E-05  -1.46070000E-04  -1.87870000E-04
   -5.06400000E-05  +1.74842000E-03  -4.35300000E-04  -4.45440000E-04  -1.09280000E-04
   -2.57010000E-04  +6.70000000E-07  +1.62662000E-03  +2.16900000E-05  -7.45470000E-04
   +5.59000000E-05  -3.27000000E-05  +1.59400000E-05  +9.07241000E-03  +1.72298000E-02
   -7.64480000E-03  +4.38330900E-02  +1.34770040E-01  -1.48905330E-01  -3.70186000E-03
   -4.80835000E-03  +7.35408000E-03  -3.64160000E-03  +2.01186000E-03  +3.66406000E-03
   -1.54660000E-04  -8.63100000E-04  -4.63180000E-04  -5.04300000E-03  +3.34491000E-03
   -2.18270000E-04  +4.56300000E-05  -4.27270000E-04  +9.19200000E-05  -2.25890000E-04
   +2.29220000E-04  -5.84720000E-04  +1.17200000E-05  +9.71000000E-06  +1.77500000E-05
   +1.52433000E-03  -2.13680000E-03  -1.37010000E-03  -4.39363300E-02  -1.47545640E-01
   +1.49444420E-01  -1.08600000E-05  -2.05200000E-05  +3.23000000E-05  -1.11950000E-04
   -7.31800000E-05  -1.03880000E-04  +7.15700000E-05  -5.64100000E-05  -4.15900000E-05
   +3.30400000E-05  +7.32000000E-05  -1.02430000E-04  -1.56600000E-04  -1.53600000E-05
   -1.87000000E-06  -1.44200000E-05  +4.27400000E-05  -7.07000000E-06  -8.91260000E-04
   +1.28214000E-03  +7.13080000E-04  -2.17258000E-03  -2.50038000E-03  -2.17370000E-04
   -1.22100000E-05  -2.13800000E-05  +2.41000000E-05  +7.91500000E-05  -3.18900000E-05
   +5.34000000E-06  +1.02110900E-02  -3.35048000E-03  +6.75597000E-03  +1.08531000E-03
   -3.57658000E-03  +2.22350000E-04  -6.64580000E-04  -5.12860000E-04  +7.63550000E-04
   -2.24520000E-03  -4.69273000E-03  -1.89739000E-03  -1.22816000E-02  +1.21137900E-02
   -2.16621700E-02  -1.46572750E-01  +5.97755200E-02  -1.21264530E-01  -8.93090000E-04
   +6.55190000E-04  -1.19108000E-03  +3.24930000E-04  +1.01630000E-04  -2.19510000E-04
   -3.83720000E-04  -8.84800000E-05  -2.24700000E-05  -1.24690000E-04  +2.19240000E-04
   +1.43420000E-04  +4.29290000E-04  -2.73220000E-04  +4.75700000E-04  +1.57829990E-01
   -4.17500000E-05  -7.84600000E-05  -3.81800000E-05  +3.87230000E-04  +2.75690000E-04
   -4.62520000E-04  +5.68100000E-05  +7.20600000E-05  +1.74790000E-04  -6.31100000E-05
   +4.34000000E-06  -2.95100000E-05  +3.11400000E-05  +2.12870000E-04  +3.74700000E-05
   -2.83500000E-05  -9.73800000E-05  -6.64500000E-05  +2.27231000E-03  -8.26070000E-04
   -7.68600000E-04  -5.44330000E-04  -3.08640000E-04  +4.29640000E-04  -1.75900000E-05
   -1.30730000E-04  +2.21840000E-04  +1.31500000E-05  -1.13160000E-04  +3.04000000E-06
   +1.45875600E-02  -4.10289000E-03  +1.63890100E-02  -3.77148000E-03  -1.20704000E-03
   +4.97441000E-03  -5.91120000E-04  -8.59690000E-04  -6.34060000E-04  -4.65951000E-03
   +2.72329000E-03  +2.41940000E-03  -8.79449000E-03  +8.72592000E-03  -9.19234000E-03
   +5.94802000E-02  -9.78896900E-02  +9.07897200E-02  -1.80190000E-04  +3.52650000E-04
   -4.87710000E-04  -3.98890000E-04  -5.85800000E-05  -1.68340000E-04  -1.48710000E-04
   -1.58210000E-04  -1.78120000E-04  +2.49540000E-04  -2.41410000E-04  -2.66040000E-04
   +7.91410000E-04  -3.09940000E-04  +9.90360000E-04  -5.87494900E-02  +9.60687200E-02
   -6.23500000E-05  -1.47200000E-05  -1.48910000E-04  +1.78910000E-04  +3.90350000E-04
   -3.24110000E-04  +4.03600000E-05  +1.83330000E-04  +1.69430000E-04  -1.16190000E-04
   -2.09690000E-04  +8.46200000E-05  +3.19900000E-04  +1.79400000E-04  +5.43200000E-05
   +3.85800000E-05  -1.09030000E-04  +1.70500000E-05  +9.55000000E-06  -1.67846000E-03
   -1.95704000E-03  -1.60749000E-03  -5.97330000E-04  +3.67190000E-04  +2.31660000E-04
   -1.07440000E-04  +1.59380000E-04  -1.36110000E-04  -3.13400000E-05  -2.48400000E-05
   -1.10037900E-02  +5.34932000E-03  -7.76854000E-03  +3.71500000E-04  +5.21074000E-03
   +1.58154000E-03  +7.74760000E-04  -5.69390000E-04  -1.09400000E-04  -1.96920000E-03
   +2.48495000E-03  +4.72188000E-03  -1.94826000E-03  +3.29943000E-03  +2.96250000E-04
   -1.20709690E-01  +9.16740800E-02  -1.99452360E-01  -2.97220000E-04  +5.16900000E-05
   -2.63360000E-04  -2.98140000E-04  -2.05190000E-04  +1.89300000E-05  +6.01700000E-05
   -1.24110000E-04  -8.40100000E-05  +1.15230000E-04  -2.94040000E-04  -3.33830000E-04
   -6.55500000E-04  +2.59150000E-04  -4.17160000E-04  +1.35848800E-01  -1.00788860E-01
   +2.04510860E-01  +3.08900000E-05  +1.27300000E-05  +4.67600000E-05  +6.78000000E-06
   -7.68200000E-05  +9.80100000E-05  +5.95000000E-06  -4.80300000E-05  -2.56200000E-05
   -9.32000000E-06  +1.92400000E-05  -2.47000000E-05  +1.04400000E-05  -8.65500000E-05
   +8.84000000E-06  -1.07300000E-05  +4.65200000E-05  -2.44000000E-06  +2.64700000E-04
   -1.02531000E-03  +5.62570000E-04  +3.21000000E-05  +2.54800000E-05  +1.03380000E-04
   -3.64900000E-05  +4.95600000E-05  -7.78500000E-05  -2.72000000E-05  +6.47700000E-05
   -1.86300000E-05  -3.12246000E-03  -3.05408000E-03  -3.16899000E-03  -1.26556000E-03
   +3.55270000E-04  -4.64520000E-04  -1.18959000E-03  +1.25510000E-04  -4.30245000E-03
   +1.01410600E-02  +1.44432400E-02  -1.08018800E-02  -8.33347700E-02  -7.52720300E-02
   +4.25334600E-02  -4.04940000E-03  -2.18540300E-02  +1.68745300E-02  +7.37850000E-04
   +7.02140000E-04  +1.95011000E-03  -3.83730000E-04  -4.05200000E-05  -5.01000000E-05
   +5.85700000E-05  +1.54600000E-05  +3.53760000E-04  +3.70620000E-04  +8.65450000E-04
   -5.65530000E-04  -6.98600000E-05  +1.44490000E-04  +2.46150000E-04  +2.86600000E-05
   +1.54996000E-03  +1.35644000E-03  +8.18521600E-02  +3.64300000E-05  +3.76300000E-05
   +2.75400000E-05  -1.50800000E-04  -1.44970000E-04  +2.49340000E-04  +4.10300000E-05
   -3.67000000E-05  -4.80000000E-06  -4.04100000E-05  -1.24000000E-06  -1.44000000E-05
   +6.23900000E-05  -4.32200000E-05  +1.73100000E-05  -2.63700000E-05  +1.62900000E-05
   -1.30700000E-05  +3.07450000E-04  -9.44200000E-05  +3.55630000E-04  -2.06000000E-06
   -4.30000000E-05  +1.04900000E-05  -9.47700000E-05  +7.27000000E-05  -1.13770000E-04
   -5.35300000E-05  +3.95200000E-05  -1.81900000E-05  -3.56474000E-03  +3.64373000E-03
   +1.31462000E-03  +7.76280000E-04  +7.60400000E-05  -5.71660000E-04  +4.93620000E-04
   +2.22722000E-03  +3.48098000E-03  -7.17984000E-03  -5.37653000E-03  +5.76796000E-03
   -7.41512300E-02  -2.21468830E-01  +1.32539260E-01  -1.69289000E-03  -5.37243000E-03
   +6.51766000E-03  +8.57170000E-04  -7.01560000E-04  -2.14153000E-03  -6.97800000E-05
   +5.66100000E-05  +3.13000000E-05  +8.94300000E-05  -1.32920000E-04  -3.43950000E-04
   -1.49000000E-04  -3.68020000E-04  +1.82290000E-04  +1.37680000E-04  -3.21990000E-04
   -2.38290000E-04  +1.22002000E-03  -1.34585000E-03  -2.40247000E-03  +8.31592100E-02
   +2.29300280E-01  +1.89400000E-05  +2.78100000E-05  +3.94000000E-06  -1.78130000E-04
   -9.15000000E-05  +1.38850000E-04  +6.63300000E-05  -8.38000000E-06  +1.07100000E-05
   -2.97000000E-05  -7.16000000E-06  -1.14800000E-05  +2.85500000E-05  +1.05200000E-05
   +1.29700000E-05  -1.89700000E-05  -1.07000000E-05  -1.64600000E-05  -7.79300000E-05
   -6.64800000E-05  +3.55850000E-04  +5.31500000E-05  -1.97500000E-05  -1.84700000E-05
   -4.13700000E-05  +2.56300000E-05  -6.54900000E-05  -1.56100000E-05  -5.89000000E-06
   -9.98000000E-06  -3.24914000E-03  +1.70108000E-03  +3.70561000E-03  -6.01630000E-04
   -8.38210000E-04  -6.33750000E-04  -4.63988000E-03  +3.16618000E-03  -3.02860000E-04
   +9.89770000E-03  +1.91245200E-02  -6.99720000E-03  +4.16737900E-02  +1.31876200E-01
   -1.36092500E-01  -2.67292000E-03  -5.95556000E-03  +6.56434000E-03  +1.67485000E-03
   -2.30650000E-03  -2.53570000E-04  +4.92500000E-05  +4.06700000E-05  -3.45000000E-06
   +2.92190000E-04  -3.90850000E-04  +7.98000000E-06  +4.08220000E-04  +7.70510000E-04
   -5.95120000E-04  +2.09550000E-04  -2.68650000E-04  -2.69040000E-04  +1.70489000E-03
   -2.17901000E-03  -1.53503000E-03  -4.45540200E-02  -1.44636120E-01  +1.35984800E-01
   -1.61916000E-03  +3.59130000E-04  +1.00931000E-03  -2.63200000E-05  -5.05780000E-04
   -2.32700000E-04  -3.45800000E-05  +1.01990000E-04  -1.81670000E-04  +1.59020000E-04
   +2.09800000E-05  +6.51000000E-05  -2.20550000E-04  -1.46810000E-04  -2.04930000E-04
   +2.39870000E-04  +3.36880000E-04  +1.84800000E-05  +2.23062000E-03  +2.45700000E-03
   +7.52130000E-04  +3.92810000E-04  +7.44410000E-04  +7.70200000E-05  +1.77760000E-04
   -1.83200000E-05  +1.47200000E-05  +8.29100000E-05  +7.27600000E-05  +5.26900000E-05
   +1.51830000E-04  -1.46930000E-04  -3.52930000E-04  +1.51570000E-04  -2.11210000E-04
   +3.19600000E-05  +2.04870000E-04  -5.27100000E-05  +4.09400000E-05  +3.29480000E-04
   -5.43000000E-05  +2.50360000E-04  -3.47010000E-04  -4.07400000E-05  -1.81650000E-04
   +6.63690000E-04  +4.54740000E-04  -4.30430000E-04  -3.35620000E-04  -1.23380000E-04
   -6.00800000E-05  -2.68031980E-01  -9.70094400E-02  -4.23725900E-02  +4.85400000E-05
   +6.69000000E-06  +2.54700000E-05  -2.30100000E-05  +5.64000000E-06  -1.39200000E-05
   -4.08600000E-05  +4.65100000E-05  +2.88500000E-04  +1.24500000E-05  -3.86600000E-05
   +8.87000000E-05  -2.04600000E-05  +1.71400000E-05  +2.09800000E-05  +2.92075710E-01
   +1.66000000E-04  -5.93330000E-04  -3.55380000E-04  -7.22250000E-04  +2.18360000E-04
   -2.73630000E-04  +7.26700000E-05  +2.14330000E-04  +2.19690000E-04  +1.91960000E-04
   +3.20800000E-05  +3.55500000E-05  -3.01260000E-04  -5.88530000E-04  -1.53990000E-04
   +2.35150000E-04  +4.36430000E-04  +1.74220000E-04  -3.03278000E-02  -1.32224800E-02
   -4.92626000E-03  -1.42202000E-03  +1.02646000E-03  -1.11165000E-03  +3.41770000E-04
   +1.36110000E-04  +9.53300000E-05  +1.69400000E-05  +2.88310000E-04  +1.81900000E-05
   +1.76624000E-03  -5.97492000E-03  +5.34670000E-04  +2.07160000E-04  -1.02810000E-04
   +7.35250000E-04  -1.87570000E-04  +4.21000000E-05  +6.35100000E-05  +4.64560000E-04
   +3.82600000E-05  +1.44810000E-04  -4.98450000E-04  +2.08600000E-05  +2.79090000E-04
   -1.02554000E-03  -2.23870000E-04  -9.57310000E-04  -5.26460000E-04  -2.01370000E-04
   -1.53290000E-04  -9.36536500E-02  -8.90318000E-02  -1.75759100E-02  +4.25800000E-05
   -2.40200000E-05  +3.14300000E-05  -5.92700000E-05  -2.41000000E-06  -1.77200000E-05
   +8.83900000E-05  +1.11300000E-04  -2.96170000E-04  +7.87600000E-05  -1.41760000E-04
   -7.26100000E-05  -1.48580000E-04  -2.17300000E-05  +1.86100000E-05  +1.03228870E-01
   +9.91993600E-02  +2.89900000E-04  -1.05898000E-03  -2.60250000E-04  -6.85760000E-04
   -3.77180000E-04  +2.17660000E-04  +1.87000000E-04  +2.61300000E-05  +7.83000000E-06
   +4.18500000E-05  +4.61200000E-05  -1.69500000E-05  -1.40710000E-04  -3.61750000E-04
   -2.72500000E-05  +1.17520000E-04  +4.63320000E-04  -2.57000000E-06  -2.23649000E-03
   -1.09521000E-03  -2.03660000E-03  +8.33920000E-04  +8.62120000E-04  -7.04600000E-05
   +2.40970000E-04  +6.07490000E-04  -1.65300000E-05  -4.65700000E-05  +2.23190000E-04
   -3.77400000E-05  -2.68910000E-04  -1.40600000E-04  +7.98950000E-04  -2.54060000E-04
   -3.97000000E-05  -2.75090000E-04  +1.80440000E-04  -1.42200000E-04  -3.55000000E-06
   -2.84300000E-05  -8.15900000E-05  +3.27600000E-05  -4.87000000E-06  -1.75950000E-04
   +5.94300000E-05  -1.65380000E-04  -7.92900000E-05  -1.05170000E-04  -9.26000000E-06
   +1.31300000E-05  +4.69900000E-05  -4.19927900E-02  -1.81034600E-02  -5.57829900E-02
   +1.73000000E-05  +1.44200000E-05  -5.54000000E-06  -6.38000000E-06  -6.11000000E-06
   -2.08300000E-05  +9.26800000E-05  +4.50000000E-05  +4.98680000E-04  +1.85200000E-05
   +2.05300000E-05  +6.17000000E-05  -3.07400000E-05  +1.09600000E-05  +1.38800000E-05
   +4.47488600E-02  +2.00862700E-02  +5.56958200E-02  -1.41620000E-04  -3.85330000E-04
   +6.53000000E-06  +2.15790000E-04  +1.01808000E-03  +3.84730000E-04  -2.30070000E-04
   +9.22100000E-05  -8.85400000E-05  +7.61700000E-05  -2.96000000E-06  +2.47400000E-05
   +2.74400000E-05  +1.14190000E-04  -9.90200000E-05  +1.90840000E-04  +2.91300000E-05
   +7.23000000E-05  -2.15731000E-03  +7.65960000E-04  -1.24321000E-03  -1.74200000E-05
   +6.52280000E-04  +1.56710000E-04  -8.38400000E-05  -4.65370000E-04  -3.15920000E-04
   +2.04400000E-05  -8.14500000E-05  +4.52300000E-05  -3.01400000E-05  +3.02580000E-04
   +5.63710000E-04  -8.97610000E-04  -1.18784000E-03  -2.95190000E-04  -1.11480000E-04
   -9.12200000E-05  +3.88000000E-05  -1.02310000E-04  +5.64900000E-05  -7.44600000E-05
   +1.32710000E-04  +9.15000000E-06  -8.58000000E-06  -9.49400000E-05  +1.08600000E-05
   -5.99500000E-05  +5.66100000E-05  +3.49400000E-05  +1.78700000E-05  -8.62296700E-02
   +4.08028100E-02  -8.75121200E-02  -1.65300000E-05  -1.59700000E-05  -6.15000000E-06
   +1.87200000E-05  -2.29300000E-05  -2.02700000E-05  -8.24820000E-04  -1.48105000E-03
   -9.95930000E-04  -4.12000000E-06  +2.74000000E-05  -9.48000000E-06  +1.37000000E-06
   +1.06300000E-05  +1.26000000E-06  -9.69329000E-03  +1.22333400E-02  -2.45851600E-02
   +9.08524400E-02  +7.38700000E-05  +1.54540000E-04  +1.70320000E-04  +2.73820000E-04
   +7.96540000E-04  -1.52945000E-03  -3.66600000E-05  -1.91160000E-04  +3.57710000E-04
   -1.38710000E-04  +7.79800000E-05  -5.14800000E-05  +2.36500000E-05  -8.26300000E-05
   +1.14870000E-04  -1.26540000E-04  +4.11100000E-05  -8.82000000E-05  +1.14555300E-02
   -1.03579600E-02  +2.88572600E-02  +2.74650000E-04  -6.87428000E-03  -1.80833000E-03
   +3.62710000E-04  -4.27340000E-04  +4.65180000E-04  -6.39400000E-05  +7.88500000E-05
   -5.64900000E-05  +1.02682000E-03  +1.27296000E-03  -1.28840000E-04  -3.04950000E-04
   -7.96450000E-04  +4.81160000E-04  -3.25410000E-04  +2.79330000E-04  -2.80890000E-04
   -1.04250000E-04  +1.57040000E-04  -1.66420000E-04  +3.08060000E-04  +1.43520000E-04
   +5.53400000E-05  -2.93670000E-04  -1.87330000E-04  +2.33740000E-04  +1.84550000E-04
   +8.15000000E-05  -2.53500000E-05  +3.97794700E-02  -9.24588300E-02  +9.13074200E-02
   -4.75600000E-05  -1.16600000E-05  -8.01000000E-06  -2.95000000E-06  -2.19700000E-05
   +1.49400000E-05  -1.28500000E-03  -5.92340000E-04  -1.37061000E-03  +1.05030000E-04
   +1.22360000E-04  -8.00700000E-05  +1.86900000E-05  -1.47400000E-05  -1.69000000E-05
   -4.12017000E-03  +5.22936000E-03  -1.17308200E-02  -4.37906900E-02  +1.01270880E-01
   +1.26190000E-04  -3.30160000E-04  -2.02600000E-04  +2.48740000E-04  +1.19449000E-03
   +1.14276000E-03  -5.26940000E-04  -4.03000000E-06  -1.40730000E-04  +7.63800000E-05
   +1.78640000E-04  +7.72000000E-06  +1.18380000E-04  +2.18500000E-05  +3.63000000E-06
   +1.04120000E-04  +1.02380000E-04  +5.89300000E-05  +2.91713000E-03  -3.05160000E-03
   +3.56819000E-03  -6.05700000E-04  +1.33660000E-04  +5.27530000E-04  +1.03731000E-03
   -2.05488000E-03  -2.31008000E-03  -7.38800000E-05  +1.83100000E-05  -1.32700000E-05
   -3.93530000E-04  +4.45140000E-04  -1.03680000E-04  -8.28750000E-04  -8.73340000E-04
   -1.01189000E-03  +2.72770000E-04  -1.68760000E-04  +7.53100000E-05  -7.44700000E-05
   -1.62200000E-05  +1.14450000E-04  -8.98400000E-05  -8.93200000E-05  -5.63000000E-06
   +1.30660000E-04  +1.39560000E-04  +7.38000000E-06  +6.32000000E-06  -1.34400000E-05
   +3.78700000E-05  -8.83631200E-02  +9.53766800E-02  -2.43207180E-01  +1.33500000E-05
   +1.92700000E-05  -4.10000000E-07  +8.68000000E-06  -7.24000000E-06  -1.78500000E-05
   -1.39527000E-03  -1.39045000E-03  +2.63460000E-04  -1.68300000E-05  -4.74500000E-05
   +1.43900000E-05  +1.01500000E-05  +1.49000000E-06  +1.88000000E-06  -4.59900000E-04
   +1.20602000E-03  -3.58366000E-03  +9.76459200E-02  -9.93919900E-02  +2.62544770E-01
   -1.60790000E-04  -4.40590000E-04  +4.38900000E-05  +5.62180000E-04  -1.42780000E-04
   -1.07700000E-04  -6.87900000E-05  +1.26250000E-04  -2.00000000E-07  +1.91010000E-04
   +7.92100000E-05  +1.06300000E-05  -1.21260000E-04  -2.37260000E-04  +3.03000000E-06
   +1.61240000E-04  +2.84850000E-04  +5.14100000E-05  -2.01535000E-03  +1.81300000E-05
   +1.14265000E-03  +5.39700000E-05  -2.82910000E-04  +6.84900000E-05  +1.81140000E-04
   -1.17970000E-04  -4.56730000E-04  -2.81900000E-05  +1.47610000E-04  -3.69600000E-05
   +3.10780000E-04  -7.83560000E-04  -8.09520000E-04  +9.41200000E-05  -1.59400000E-05
   +2.66300000E-05  -9.97200000E-05  +6.11400000E-05  +1.01590000E-04  -3.39100000E-05
   -3.51400000E-05  +2.31900000E-05  -6.32500000E-05  +5.24000000E-05  -4.58900000E-05
   +2.24690000E-04  +1.42080000E-04  +2.54900000E-05  +3.73700000E-05  +5.22000000E-06
   -1.62300000E-05  -1.43052610E-01  +3.83943900E-02  +1.23445490E-01  -1.16000000E-05
   -6.54000000E-06  -1.03000000E-06  +4.58000000E-06  +6.10000000E-07  -2.11000000E-06
   +1.28100000E-04  +4.31100000E-05  -6.80500000E-05  +2.41800000E-05  +2.77400000E-05
   -1.63100000E-05  +8.91000000E-06  +7.81000000E-06  +3.25000000E-06  -1.61217800E-02
   +7.42579000E-03  +2.25264000E-02  +7.95015000E-03  -3.90102000E-03  -9.93917000E-03
   +1.51486940E-01  -1.07384000E-03  -1.83720000E-04  +3.05100000E-04  +1.99080000E-04
   -4.88323000E-03  -3.17219000E-03  +9.53610000E-04  +6.06910000E-04  -8.69480000E-04
   +3.29660000E-04  -3.60250000E-04  +2.60750000E-04  -6.54370000E-04  -1.50400000E-04
   -3.89610000E-04  +1.77670000E-04  -1.78000000E-06  +1.03900000E-04  +1.86225500E-02
   -1.02956600E-02  -2.37791700E-02  +9.31100000E-05  +1.10507000E-03  -8.90210000E-04
   +4.21140000E-04  -5.66620000E-04  +2.07269000E-03  +4.08820000E-04  -1.16910000E-04
   +1.73430000E-04  +8.53600000E-04  +9.81390000E-04  -2.63030000E-04  -1.85510000E-04
   +1.55300000E-04  -1.17980000E-04  +3.19800000E-05  +6.08700000E-05  -9.01100000E-05
   -2.48760000E-04  -8.60000000E-05  -1.14830000E-04  +1.71030000E-04  -9.28600000E-05
   +1.20260000E-04  -2.61050000E-04  -1.22000000E-06  +3.65470000E-04  +3.22050000E-04
   +1.44890000E-04  +9.77400000E-05  +3.74915600E-02  -6.05525600E-02  -4.74139100E-02
   -3.21100000E-05  -1.30000000E-07  -3.18700000E-05  +2.13000000E-05  -9.44000000E-06
   +8.36000000E-06  +2.15700000E-05  -6.04700000E-05  +1.91800000E-05  -5.59000000E-06
   -5.57000000E-05  -1.22900000E-05  +2.41200000E-05  -1.04300000E-05  -2.76200000E-05
   -7.08954000E-03  +2.77052000E-03  +1.07761800E-02  -8.92150000E-03  +2.81429000E-03
   +9.17584000E-03  -4.15889300E-02  +6.89143200E-02  -3.20990000E-04  -1.33080000E-04
   -1.44490000E-04  -7.71170000E-04  +2.39010000E-04  +1.59413000E-03  +3.78100000E-05
   +3.35310000E-04  -1.30010000E-04  -1.03100000E-05  -3.46000000E-05  +4.89300000E-05
   -3.59600000E-05  +1.89850000E-04  -6.37100000E-05  +1.30970000E-04  -1.97100000E-05
   +8.61600000E-05  +1.48313000E-03  -1.38719000E-03  -3.33432000E-03  -4.62790000E-04
   +8.47190000E-04  +3.21180000E-04  +2.82760000E-04  -7.74350000E-04  -8.30720000E-04
   +8.68200000E-05  -1.17640000E-04  +2.99200000E-05  +4.01400000E-04  +4.15440000E-04
   +5.88230000E-04  -2.17960000E-04  +3.42340000E-04  -1.89400000E-04  -2.78870000E-04
   -1.58550000E-04  +1.26610000E-04  -1.05540000E-04  +8.96100000E-05  -2.29170000E-04
   +2.24450000E-04  -2.16300000E-05  +1.08050000E-04  -4.32550000E-04  -3.37420000E-04
   +6.55700000E-05  +3.74300000E-05  +1.03100000E-05  +3.76700000E-05  +1.22960990E-01
   -4.76253300E-02  -2.04950160E-01  -1.61000000E-06  -1.08900000E-05  -1.21800000E-05
   +1.02000000E-06  -1.44100000E-05  -1.86100000E-05  +2.52360000E-04  -2.94400000E-05
   +2.51000000E-06  +1.10600000E-05  +3.76300000E-05  +1.41000000E-06  -7.98000000E-06
   -6.79000000E-06  -1.52000000E-06  -4.55049000E-03  +2.25040000E-03  +5.21915000E-03
   +1.68862300E-02  -6.88193000E-03  -1.84708100E-02  -1.35446800E-01  +5.28193600E-02
   +2.19639310E-01  +3.44150000E-04  -4.29720000E-04  -2.41850000E-04  +1.58520000E-04
   -8.23000000E-06  +3.20870000E-04  +1.57190000E-04  -9.94200000E-05  +4.11430000E-04
   -1.61290000E-04  +1.17450000E-04  +4.01560000E-04  +3.67400000E-05  +9.84200000E-05
   +6.77390000E-04  -1.48340000E-04  +1.96850000E-04  -3.16630000E-04  -3.23240000E-03
   +1.26588700E-02  +3.20788000E-03  -6.08207100E-02  +5.69281600E-02  +6.72690000E-04
   -6.59300000E-05  -9.80600000E-05  +1.27510000E-04  -1.45430000E-04  +6.77600000E-05
   -2.17850000E-04  +3.86390000E-04  +1.09500000E-04  +1.04340000E-04  +6.10500000E-05
   -1.73130000E-04  -2.08200000E-05  +7.25900000E-05  -5.52000000E-05  +1.02770000E-04
   +1.53900000E-05  +2.54100000E-05  -5.18000000E-05  +4.31700000E-05  -2.68850000E-04
   +2.59890000E-04  -9.38010000E-04  +5.34310000E-04  -6.65280000E-04  +6.92500000E-05
   -1.94800000E-05  +6.13600000E-05  -1.14775000E-03  +2.33500000E-05  -2.19810000E-03
   -2.36000000E-06  -2.22000000E-06  -1.39000000E-06  -1.55000000E-06  +7.23000000E-06
   +1.88000000E-05  +5.69600000E-05  -6.58000000E-06  +1.02120000E-04  -2.64860000E-03
   -8.03260000E-04  +2.48430000E-04  -3.54700000E-05  +1.36200000E-05  +8.60000000E-07
   +3.21660000E-04  +3.04510000E-04  -7.50000000E-06  +5.72620000E-04  +8.31470000E-04
   -5.23200000E-05  +7.40800000E-05  -3.68730000E-04  -1.13710000E-04  +6.41389200E-02
   +1.53130000E-04  -2.59730000E-04  -1.79500000E-05  +4.77560000E-04  -7.32130000E-04
   +1.87460000E-04  +2.66900000E-04  +1.45780000E-04  -1.13374000E-03  -1.81500000E-05
   +2.83200000E-05  -9.02840000E-04  -7.15500000E-05  -1.20200000E-05  +1.44840000E-04
   -2.06850000E-04  +1.96130000E-04  -6.98900000E-05  +1.29798000E-03  -9.40174000E-03
   +9.30000000E-07  +5.77121300E-02  -3.05943230E-01  -1.10361700E-02  -1.91470000E-04
   +2.68240000E-04  -3.26190000E-04  -9.15400000E-05  +7.58800000E-05  -4.91500000E-05
   -6.16950000E-04  -1.82270000E-04  +1.30450000E-04  +2.19770000E-04  +8.95600000E-05
   +1.17390000E-04  -7.33800000E-05  -7.92000000E-06  -4.48800000E-05  -5.45300000E-05
   -8.34800000E-05  -3.43800000E-05  -5.38300000E-05  +4.00730000E-04  -3.40350000E-04
   -8.59670000E-04  -5.40470000E-04  +6.53250000E-04  -2.03300000E-05  +4.00200000E-05
   -5.19500000E-05  +1.32958000E-03  +1.92700000E-05  +2.82431000E-03  -8.58000000E-06
   -1.03100000E-05  -7.03000000E-06  +1.57000000E-05  +1.15000000E-06  -4.35000000E-06
   -6.68300000E-05  +1.05100000E-05  -8.10600000E-05  -1.18093000E-03  +4.71460000E-04
   -6.26540000E-04  +1.10800000E-05  +1.50300000E-05  +3.06000000E-05  +9.16100000E-05
   +3.88500000E-04  -1.23680000E-04  +1.98660000E-04  -6.69530000E-04  -1.66830000E-04
   -1.18580000E-04  +2.54910000E-04  -1.68140000E-04  -6.21986400E-02  +3.32571540E-01
   -1.59500000E-05  -4.21200000E-05  -1.64290000E-04  -9.08000000E-05  +7.26340000E-04
   +6.70440000E-04  -2.75090000E-04  +2.71800000E-04  -1.50447000E-03  +6.54400000E-05
   -8.09340000E-04  -3.26690000E-04  +1.28561000E-03  +2.58020000E-04  +1.08070000E-04
   +1.06950000E-04  -2.06780000E-04  -1.78300000E-05  -4.02454000E-03  +2.82423600E-02
   +2.59813000E-03  +2.09243000E-03  -1.34308100E-02  -4.79960700E-02  -5.67500000E-05
   -2.86570000E-04  +1.94270000E-04  -4.96690000E-04  +8.71300000E-05  -2.31320000E-04
   +7.48290000E-04  -1.50610000E-04  +4.43940000E-04  +3.75500000E-05  -6.65000000E-05
   -2.59480000E-04  +1.06320000E-04  +8.83300000E-05  -9.24000000E-06  -1.20800000E-05
   -1.29060000E-04  +1.64000000E-04  -1.91350000E-04  +1.79700000E-05  -1.70460000E-04
   -8.26300000E-05  -6.03300000E-04  +4.14570000E-04  -1.15800000E-05  +1.22000000E-05
   -3.38000000E-05  -2.46605000E-03  +1.06921000E-03  -5.29719000E-03  -8.83000000E-06
   +5.05000000E-06  +1.90000000E-07  -1.58800000E-05  +2.18200000E-05  +8.44000000E-06
   +3.57300000E-05  +5.32100000E-05  +5.07300000E-05  -2.90400000E-04  +2.22900000E-05
   +2.30950000E-04  -1.17000000E-06  -2.25000000E-06  +8.74000000E-06  +9.92200000E-05
   -1.73310000E-04  -8.16100000E-05  -3.75240000E-04  +1.92998000E-03  +3.02760000E-04
   -2.44950000E-04  -4.76000000E-06  +1.26630000E-04  -1.42812000E-03  +1.21953400E-02
   +5.21036600E-02  -6.81560000E-04  +3.62670000E-04  +1.67006000E-03  -2.19880000E-04
   -5.43700000E-05  -4.93490000E-04  -1.33200000E-04  +2.88080000E-04  +1.30690000E-04
   +2.38490000E-04  +4.23500000E-05  +1.24120000E-04  -2.15990000E-04  -5.19500000E-04
   -7.35500000E-05  -5.02010000E-04  +2.64770000E-04  +1.57376000E-03  -1.22261500E-02
   -6.01599000E-03  -1.40318000E-03  -2.42077870E-01  -1.18265690E-01  -4.40567200E-02
   +1.31520000E-04  -4.59600000E-05  +2.90840000E-04  +2.87600000E-05  +1.20140000E-04
   -1.64100000E-05  -3.77100000E-05  +1.32098000E-03  -2.37580000E-03  -2.63040000E-04
   -7.23100000E-04  +1.49840000E-04  -2.93940000E-04  +7.04800000E-05  -1.01720000E-04
   +2.23100000E-04  +1.94490000E-04  -5.64600000E-05  +7.68200000E-05  +2.02000000E-06
   -9.39700000E-05  +2.92740000E-04  +1.27490000E-04  -1.21650000E-04  -2.92670000E-04
   -1.24220000E-04  -5.32300000E-05  +2.27800000E-04  -1.06899000E-03  +6.89630000E-04
   +4.14000000E-05  +8.89000000E-06  +2.36800000E-05  -1.01950000E-04  -7.31000000E-06
   +4.57000000E-06  +2.59600000E-05  +2.25800000E-05  -8.26000000E-05  -1.54210000E-04
   +2.74050000E-04  +5.40000000E-07  -1.71800000E-05  -2.25400000E-05  -1.45000000E-06
   +4.57110000E-04  +8.12810000E-04  -2.23660000E-04  +4.71200000E-04  +5.73000000E-05
   +1.87520000E-04  -1.87010000E-04  +9.40000000E-07  -5.25500000E-05  +7.31702000E-03
   +4.30253000E-03  +1.72008000E-03  +2.63205250E-01  -6.22150000E-04  +8.50600000E-04
   +2.40710000E-04  -4.15850000E-04  +3.34500000E-05  -5.41420000E-04  +1.70000000E-04
   -1.17900000E-04  -1.41750000E-04  +1.68210000E-04  +1.42450000E-04  -2.54820000E-04
   -5.33330000E-04  -8.40500000E-04  -3.69510000E-04  +1.82100000E-04  -3.45700000E-05
   +8.65770000E-04  +1.03675700E-02  +4.32706000E-03  +1.82673000E-03  -1.19280950E-01
   -1.20058820E-01  -2.60754200E-02  +2.22650000E-04  -9.03600000E-05  +9.02500000E-05
   +1.79440000E-04  +1.89800000E-04  +1.28520000E-04  +6.41260000E-04  -9.29520000E-04
   +2.39526000E-03  +4.87630000E-04  +5.19500000E-04  +1.33030000E-04  +1.34370000E-04
   -4.97300000E-05  -7.81000000E-06  -3.09300000E-05  -1.36080000E-04  +9.23100000E-05
   -1.16590000E-04  +3.03450000E-04  -2.90230000E-04  -1.45290000E-04  -6.10520000E-04
   +6.44500000E-04  -3.47800000E-05  +3.97300000E-05  -5.63400000E-05  +1.52360000E-03
   +7.44740000E-04  +5.95640000E-04  -5.57000000E-06  -3.15000000E-06  -2.00000000E-06
   +6.20800000E-05  -4.43000000E-06  -2.04900000E-05  -3.68700000E-05  +6.74900000E-05
   +5.78000000E-06  -4.64000000E-06  +3.09220000E-04  -5.83370000E-04  +8.35000000E-06
   +1.01900000E-05  +1.79000000E-05  +8.19300000E-05  -3.30710000E-04  +6.17560000E-04
   +2.93000000E-05  +9.44800000E-05  -1.31220000E-04  +3.14300000E-05  -2.78400000E-05
   -1.17520000E-04  -2.72148700E-02  -1.41267300E-02  -4.83317000E-03  +1.28499060E-01
   +1.27123290E-01  +4.18200000E-04  -7.35800000E-05  -1.52796000E-03  -9.32970000E-04
   -4.71510000E-04  +3.23990000E-04  +1.97190000E-04  +9.07400000E-05  -1.52750000E-04
   +1.85250000E-04  +3.42000000E-05  -4.24800000E-05  -3.48660000E-04  -1.03545000E-03
   -9.40900000E-05  +7.13560000E-04  +2.86970000E-04  -1.71530000E-04  -2.49952900E-02
   -1.44078700E-02  -6.17719000E-03  -4.08865600E-02  -2.39009600E-02  -5.48443300E-02
   +3.00610000E-04  +7.96100000E-05  +2.83620000E-04  -1.89300000E-05  +4.42290000E-04
   -4.54000000E-05  -5.53910000E-04  +2.96147000E-03  -4.10021000E-03  -1.59154000E-03
   -9.11260000E-04  +1.40560000E-04  -9.99200000E-05  +3.07810000E-04  -2.85190000E-04
   +1.93940000E-04  +1.29700000E-05  +4.71100000E-05  -1.74370000E-04  -1.77630000E-04
   +2.08630000E-04  +3.49580000E-04  +1.03731000E-03  -3.04830000E-04  -1.35880000E-04
   -1.01110000E-04  -8.66000000E-06  +2.55500000E-05  -1.55497000E-03  +7.26860000E-04
   +3.11400000E-05  +7.52000000E-06  +9.75000000E-06  -1.32880000E-04  -6.84400000E-05
   -4.28100000E-05  +2.60300000E-05  -2.65000000E-06  -4.50000000E-06  +4.48470000E-04
   -3.07590000E-04  +2.21480000E-04  -5.02300000E-05  -2.36000000E-06  +8.04000000E-06
   +1.90920000E-04  +7.99790000E-04  +1.06240000E-04  +3.60280000E-04  -2.13430000E-04
   -5.13000000E-05  +1.78310000E-04  +8.06400000E-05  +2.67800000E-05  -1.02953000E-03
   -1.00555000E-03  -9.85440000E-04  +4.69562700E-02  +2.41328500E-02  +6.15365900E-02
   -6.71270000E-04  +3.85690000E-04  +5.88020000E-04  -5.44890000E-04  +5.89960000E-04
   -3.83206000E-03  -1.09120000E-04  +3.39190000E-04  +7.77000000E-05  +1.19680000E-04
   -1.19890000E-04  +5.84400000E-05  -9.37200000E-05  -6.55280000E-04  -1.36290000E-04
   +2.94190000E-04  -9.13400000E-05  +6.89020000E-04  +7.18739000E-03  -1.46318000E-03
   -1.07906200E-02  -1.52957340E-01  +2.74634700E-02  +1.30106500E-01  +4.30300000E-04
   -5.22730000E-04  +8.64970000E-04  -1.53100000E-05  +2.26500000E-04  -9.81000000E-06
   -5.87200000E-05  -4.04120000E-04  -5.68460000E-04  +2.54570000E-04  +2.15890000E-04
   +1.33270000E-04  -6.51500000E-05  -1.79720000E-04  +7.31100000E-05  -9.74100000E-05
   +7.44200000E-05  -1.31790000E-04  +8.81200000E-05  +9.98000000E-06  -1.13000000E-04
   -7.78960000E-04  -1.02902000E-03  -6.76650000E-04  +4.64500000E-05  +3.73300000E-05
   +4.21100000E-05  +1.19530000E-04  -2.42090000E-04  -3.09100000E-05  -1.14800000E-05
   +1.19000000E-06  +1.22000000E-06  +2.46000000E-05  +1.85900000E-05  +2.20900000E-05
   +4.90500000E-05  -4.27800000E-05  +3.93200000E-05  -8.49390000E-04  -8.36290000E-04
   -7.04450000E-04  +3.30500000E-05  -2.53900000E-05  -2.10900000E-05  -4.76500000E-05
   +7.21800000E-05  +9.82300000E-05  +6.22900000E-05  -2.80960000E-04  -2.14600000E-05
   +1.40490000E-04  +5.06800000E-05  -9.51000000E-06  -4.45837000E-03  -3.43720000E-04
   +3.94952000E-03  -1.54291300E-02  +5.58623000E-03  +2.01416700E-02  +1.67138390E-01
   +1.94740000E-04  +2.97360000E-04  +1.81320000E-04  +6.97600000E-05  -1.37129000E-03
   +2.23187000E-03  +3.56060000E-04  +3.15900000E-05  -4.60460000E-04  -9.21600000E-05
   +3.40490000E-04  -2.86500000E-04  -3.94560000E-04  -3.29790000E-04  +1.16830000E-04
   -1.66670000E-04  +4.37400000E-05  +1.75970000E-04  -6.17580000E-03  +1.85000000E-04
   +8.28690000E-03  +2.63230200E-02  -5.27175700E-02  -3.18407400E-02  -2.46940000E-04
   +4.64700000E-04  -4.91030000E-04  +6.11700000E-05  +1.26950000E-04  -1.42700000E-05
   -3.26300000E-05  +1.81690000E-04  -3.69540000E-04  -4.72000000E-06  -2.82130000E-04
   +1.11200000E-05  +2.21000000E-06  -2.75500000E-05  +4.36800000E-05  +2.95000000E-06
   +5.69200000E-05  -9.44500000E-05  +7.47600000E-05  -1.73970000E-04  +2.78030000E-04
   -5.45890000E-04  +5.22660000E-04  -8.40920000E-04  +5.71400000E-05  -2.33400000E-05
   +4.52400000E-05  -4.85150000E-04  +2.04700000E-04  +3.33340000E-04  -2.54000000E-06
   -8.70000000E-07  +2.76000000E-06  -1.09600000E-05  +1.99000000E-06  +1.79600000E-05
   +5.60000000E-07  +8.54000000E-06  +4.41800000E-05  -5.18860000E-04  -1.33960000E-03
   -5.56100000E-04  -2.85800000E-05  +2.68000000E-06  -6.64000000E-06  -5.70400000E-05
   -1.66000000E-06  +9.51000000E-05  +8.44200000E-05  +8.89000000E-05  -3.41510000E-04
   +4.59800000E-04  -4.78210000E-04  +3.02820000E-04  +1.98463800E-02  -3.05954000E-03
   -2.41301200E-02  -9.95437000E-03  +2.57234000E-03  +1.36546300E-02  -2.88735900E-02
   +5.45968200E-02  -1.02146000E-03  -1.58060000E-04  +2.46300000E-04  -1.63193000E-03
   +1.96532000E-03  -4.85960000E-03  +6.25100000E-05  +7.61110000E-04  +4.69120000E-04
   +9.08000000E-06  -1.90840000E-04  +9.49300000E-05  -2.96890000E-04  +7.08900000E-05
   -9.84300000E-05  +7.79900000E-05  +1.06800000E-05  +3.39060000E-04  +1.61266500E-02
   -3.94426000E-03  -2.29192600E-02  +1.29651870E-01  -3.23522600E-02  -2.00073740E-01
   +5.67140000E-04  -6.08880000E-04  +2.68800000E-04  +2.02280000E-04  -1.37360000E-04
   +7.52400000E-05  +9.04480000E-04  +1.68180000E-04  +9.04220000E-04  -6.20710000E-04
   +3.84400000E-04  -1.29130000E-04  +3.73960000E-04  +1.02960000E-04  +4.20200000E-05
   -5.43200000E-05  -2.73770000E-04  +1.23970000E-04  -2.78300000E-04  -1.78840000E-04
   +2.07530000E-04  -9.63200000E-05  +3.59950000E-04  +4.42000000E-06  +1.96430000E-04
   +7.53100000E-05  +6.94000000E-05  +5.39680000E-04  -8.67780000E-04  +5.68360000E-04
   -1.87600000E-05  -1.31100000E-05  -2.32700000E-05  +4.62200000E-05  -2.84900000E-05
   -2.54900000E-05  +9.97200000E-05  -1.03850000E-04  +6.62100000E-05  -1.16460000E-04
   -8.67520000E-04  +4.99000000E-05  -6.55000000E-06  +6.68000000E-06  -1.30600000E-05
   -9.67200000E-05  -3.61100000E-05  -1.93300000E-05  -3.53380000E-04  -1.09340000E-04
   +4.36590000E-04  -3.41820000E-04  +7.40510000E-04  +3.48070000E-04  -2.69880000E-04
   +1.00290000E-04  -4.28830000E-04  -4.26824000E-03  +1.52147000E-03  +5.31712000E-03
   -1.39641970E-01  +3.37049500E-02  +2.19169510E-01  +4.75280000E-04  -2.56210000E-04
   -6.02900000E-05  -1.05680000E-04  +1.90441000E-03  -7.39150000E-04  -2.78966080E-01
   -8.42055900E-02  -9.17387800E-02  -1.49520900E-02  -9.38154000E-03  -9.49532000E-03
   +2.43806000E-03  +3.68144000E-03  -3.80036000E-03  +9.70200000E-05  +1.79560000E-04
   +7.38990000E-04  -7.03400000E-05  -7.53070000E-04  -3.61490000E-04  -5.47700000E-05
   -1.87700000E-05  +1.44400000E-04  +4.33340000E-04  +3.12490000E-04  +4.93180000E-04
   -2.39681000E-03  +1.22800000E-05  +1.40250000E-04  -1.37720000E-03  +1.70359000E-03
   +1.53516000E-03  +1.24110000E-04  +5.04100000E-04  +6.52460000E-04  -1.13500000E-04
   -2.98820000E-04  -1.69120000E-04  -2.32440000E-04  -1.17300000E-05  -3.10290000E-04
   +3.32190000E-04  -2.37000000E-05  +1.29230000E-04  -7.73090000E-04  +7.26370000E-04
   +6.79330000E-04  +7.19700000E-05  +3.47900000E-05  +4.35000000E-05  +1.43500000E-05
   -2.70300000E-05  -1.26690000E-04  -2.29700000E-05  -7.04000000E-06  -8.88000000E-06
   -1.68000000E-06  +3.98000000E-06  +1.55400000E-05  +1.83400000E-05  -7.27200000E-05
   -1.84000000E-05  +4.59600000E-05  -7.63100000E-05  -1.73800000E-04  +2.03000000E-06
   -4.83000000E-06  -1.18000000E-05  -1.10700000E-05  -1.69700000E-05  -1.74000000E-06
   -4.56000000E-06  +1.74800000E-05  -6.93000000E-06  +8.39000000E-06  -2.45900000E-05
   -1.56600000E-05  -3.44900000E-05  -3.50000000E-07  +6.31000000E-06  -3.90000000E-06
   +9.76000000E-06  +6.73000000E-06  +3.92000000E-05  +5.74000000E-06  +1.93400000E-05
   +2.94936690E-01  +1.96960000E-03  -5.89364000E-03  -4.27420000E-04  -2.78603000E-02
   -9.18732000E-03  -9.97935000E-03  -8.40137400E-02  -8.74352500E-02  -3.36440000E-02
   +2.18826300E-02  +1.12533200E-02  +7.08122000E-03  +7.63410000E-04  -4.00261000E-03
   -1.58439000E-03  +1.81110000E-04  +7.87960000E-04  +2.47020000E-04  -4.30000000E-04
   +4.65420000E-04  +1.22770000E-04  +6.64600000E-05  +2.15000000E-06  +1.91500000E-05
   +6.29180000E-04  +4.19934000E-03  -6.16500000E-04  +1.85197000E-03  +3.77910000E-04
   +9.70140000E-04  +4.66200000E-05  -3.20500000E-04  -6.36960000E-04  +4.71400000E-04
   -2.46990000E-04  +3.42390000E-04  +6.87600000E-05  +1.49000000E-06  +9.26300000E-05
   +3.48320000E-04  +1.32300000E-04  -4.59500000E-05  -7.98800000E-05  -1.08950000E-04
   -1.27530000E-04  +4.10720000E-04  +5.57790000E-04  -1.24430000E-04  -3.59030000E-04
   -1.62110000E-04  -5.60900000E-05  +6.03700000E-05  +3.89000000E-06  +7.19000000E-05
   +4.60300000E-05  +1.75400000E-05  +2.73100000E-05  -1.72300000E-05  -1.02100000E-05
   -1.87500000E-05  -1.09900000E-05  -1.92200000E-05  -4.86700000E-05  +3.30000000E-07
   -2.70300000E-05  +4.88200000E-05  -3.11800000E-05  -2.06000000E-06  +3.65400000E-05
   +2.53800000E-05  +1.04710000E-04  +6.18400000E-05  -1.94900000E-05  -2.50000000E-05
   +5.85000000E-06  +6.18800000E-05  -1.85400000E-05  -4.73200000E-05  -3.69000000E-05
   -9.50000000E-06  -2.20000000E-07  +3.24700000E-05  +3.05600000E-05  +8.76100000E-05
   +9.43000000E-06  -5.00000000E-06  -7.10200000E-05  +8.61118700E-02  +8.89690000E-02
   +1.18591000E-03  -8.31990000E-04  +7.88600000E-04  -5.48417000E-03  -5.22360000E-04
   -8.55320000E-04  -9.09401500E-02  -3.32537000E-02  -7.62789500E-02  -6.45397000E-03
   -3.06847000E-03  +8.28274000E-03  -3.57034000E-03  -8.42340000E-04  +1.25241000E-02
   +5.01900000E-04  +5.54730000E-04  -1.94994000E-03  -6.07200000E-04  +8.75510000E-04
   +9.47350000E-04  +2.26750000E-04  -2.56500000E-05  -2.20860000E-04  +1.49859000E-03
   -8.88210000E-04  +1.34503000E-03  +6.71780000E-04  +4.28180000E-04  -2.61104000E-03
   +2.34190000E-04  -9.39780000E-04  -5.96120000E-04  +2.78260000E-04  -3.34500000E-05
   +2.90690000E-04  -4.85200000E-05  -5.03500000E-05  -1.18180000E-04  +3.38050000E-04
   -2.35800000E-05  +1.36080000E-04  +4.19000000E-05  +2.22910000E-04  -1.78700000E-05
   +4.33360000E-04  +4.45700000E-05  -3.47430000E-04  -3.00840000E-04  -1.07860000E-04
   -1.00450000E-04  +1.10330000E-04  -1.98900000E-05  -3.57200000E-05  +2.59200000E-05
   +1.28200000E-05  +3.76800000E-05  -4.75000000E-05  +2.57300000E-05  -5.49000000E-06
   -1.50400000E-05  +6.64300000E-05  -3.77600000E-05  -2.15400000E-05  -2.94800000E-05
   -9.99300000E-05  +6.77000000E-06  -4.83000000E-06  -7.45000000E-06  +2.84100000E-05
   +7.10300000E-05  +3.20400000E-05  -1.80000000E-05  -1.40400000E-05  +1.42900000E-05
   -4.50000000E-06  -3.91900000E-05  -1.33000000E-05  -6.62100000E-05  -5.31800000E-05
   -2.99800000E-05  +1.46000000E-05  +8.80300000E-05  +5.77300000E-05  -4.19500000E-05
   -2.96500000E-05  -8.54600000E-05  +1.00043580E-01  +3.75585000E-02  +6.47994300E-02
   -4.01940000E-04  -4.80650000E-04  +1.33600000E-04  -1.44811000E-03  +1.66207000E-03
   -3.13087000E-03  +5.34453000E-03  +2.70863500E-02  +2.86063000E-03  -5.71205300E-02
   -3.04922900E-02  -9.70753000E-03  +1.45518000E-03  -2.98241900E-02  -3.53442000E-03
   -4.67825000E-03  -1.54110000E-04  -1.98379000E-03  +8.26400000E-05  -1.12163000E-03
   -4.05680000E-04  -1.75420000E-04  +7.38000000E-05  +4.79100000E-05  -5.63860000E-04
   +1.57743000E-03  -1.11088000E-03  +2.25082000E-03  +3.07812000E-03  +1.76625000E-03
   +2.15510000E-04  +1.71290000E-04  +1.14460000E-04  -2.34600000E-05  +1.50710000E-04
   -9.29100000E-05  -4.95200000E-05  -1.13930000E-04  +5.20100000E-05  +1.81100000E-05
   +7.43400000E-05  -8.98200000E-05  +3.11700000E-05  -6.37700000E-05  +9.71000000E-06
   -2.65500000E-05  -4.01100000E-05  -5.88600000E-05  -5.58800000E-05  -4.63700000E-05
   +1.79000000E-06  +6.21000000E-05  +3.17200000E-05  -1.46400000E-05  +2.53000000E-06
   +8.63000000E-06  +6.68000000E-06  -1.02100000E-05  +6.41000000E-06  +4.54000000E-06
   -2.09300000E-05  -8.18200000E-05  +7.80100000E-05  +5.41000000E-06  +2.06800000E-05
   +4.58800000E-05  -2.47600000E-05  +3.49000000E-06  +2.13500000E-05  +1.22000000E-06
   +2.49500000E-05  +5.18000000E-06  -2.14600000E-05  +1.35700000E-05  -5.90600000E-05
   -8.55000000E-06  +3.53500000E-05  -2.61000000E-06  +1.69000000E-05  -1.25800000E-05
   -9.10000000E-07  +1.84900000E-05  +9.18000000E-06  +2.51700000E-05  +4.72100000E-05
   -6.40000000E-06  +7.37600000E-05  +2.95000000E-06  -4.29960000E-04  +2.55748000E-03
   +5.48919700E-02  +1.21390000E-04  +5.91440000E-04  +1.06430000E-04  +2.10380000E-03
   +1.35799000E-03  -4.68210000E-04  -3.31186000E-03  -1.43848000E-02  -3.17863000E-03
   -3.06331200E-02  -3.35620110E-01  -3.90830500E-02  +2.98626000E-03  -9.09393000E-03
   +4.81500000E-05  -1.64988000E-03  +6.04920000E-04  -7.67040000E-04  -8.87200000E-05
   -1.80840000E-04  +9.28400000E-05  +7.04800000E-05  -6.85200000E-05  -1.15000000E-05
   +1.98850000E-04  -3.54100000E-04  +3.50320000E-04  -2.31260000E-04  +2.54855000E-03
   +2.10440000E-04  -1.01220000E-04  -4.28900000E-05  -2.77500000E-05  +2.29800000E-05
   -3.72500000E-05  +2.91900000E-05  +8.66000000E-06  +5.01800000E-05  -2.99700000E-05
   -2.98100000E-05  -2.98800000E-05  +1.83800000E-05  +2.35100000E-05  +4.93200000E-05
   +1.93000000E-05  +3.55000000E-06  -1.74700000E-05  +5.24000000E-05  +5.54100000E-05
   +3.44400000E-05  +6.91000000E-06  +4.34300000E-05  +2.03200000E-05  -1.12710000E-04
   -3.66000000E-06  -4.97000000E-06  -7.25000000E-06  +7.96000000E-06  -2.90000000E-06
   -5.30000000E-07  -1.02500000E-05  +2.82400000E-05  -3.47800000E-05  +6.16000000E-06
   -2.40100000E-05  -4.58900000E-05  +1.58700000E-05  +5.20000000E-07  -8.23000000E-06
   +1.72000000E-06  +1.37500000E-05  +1.26300000E-05  -9.80000000E-07  +5.87000000E-06
   +2.35200000E-05  +2.03200000E-05  -4.85500000E-05  -1.75700000E-05  -3.51700000E-05
   -2.53600000E-05  -2.28100000E-05  -4.36000000E-06  +4.47300000E-05  +2.77900000E-05
   +6.56000000E-06  +8.31000000E-06  -3.87100000E-05  +6.87500000E-05  +7.79280000E-04
   +8.98600000E-04  +3.03925900E-02  +3.54268960E-01  -9.53900000E-05  +6.51470000E-04
   -4.59020000E-04  -4.40714000E-03  +1.03419000E-03  +7.19563000E-03  +1.28690000E-04
   +5.94888000E-03  +6.34823000E-03  -1.04129800E-02  -3.92762300E-02  -4.60457300E-02
   +5.36750000E-04  -1.10775600E-02  +2.80348000E-03  -2.82882000E-03  -1.63010000E-04
   +9.02890000E-04  -3.57520000E-04  +2.38267000E-03  +8.32420000E-04  +1.47010000E-04
   -8.82900000E-05  -1.93480000E-04  +1.25791000E-03  -3.03208000E-03  +2.09758000E-03
   +1.25313000E-03  +1.58062000E-03  -1.33275000E-03  +1.69460000E-04  -7.47800000E-05
   -2.26350000E-04  -6.88000000E-05  -1.40300000E-05  -2.22700000E-05  +1.98700000E-05
   +5.30300000E-05  -1.61800000E-05  +4.14200000E-05  -1.66400000E-05  +5.90500000E-05
   -4.13100000E-05  +1.76800000E-05  -3.20100000E-05  +8.05300000E-05  -3.11700000E-05
   +8.72700000E-05  -3.05600000E-05  -1.29100000E-05  -2.48900000E-05  -3.40320000E-04
   -5.96800000E-05  +3.61270000E-04  +3.29000000E-06  +6.25000000E-06  +7.29000000E-06
   -3.88000000E-06  +2.93000000E-06  -4.25000000E-06  +3.10700000E-05  +6.53000000E-06
   -1.30500000E-05  +1.40200000E-05  -2.90200000E-05  -5.07400000E-05  +1.61500000E-05
   +2.87000000E-06  +1.62000000E-06  +2.36700000E-05  +9.00000000E-08  +1.63900000E-05
   +1.37600000E-05  -3.56100000E-05  +1.10200000E-05  -2.44000000E-06  +1.49130000E-04
   +4.03500000E-05  -4.34800000E-05  -6.49000000E-05  +4.27000000E-06  -6.38000000E-06
   +5.38600000E-05  +4.87200000E-05  -6.10000000E-06  +3.14000000E-05  -2.53500000E-05
   +2.71858000E-03  +8.87020000E-04  -6.68173000E-03  +1.22932000E-02  +4.18406000E-02
   +3.42297000E-02  -1.73589300E-02  -8.86445000E-03  -4.81363000E-03  +1.35601000E-03
   +2.08516000E-03  -1.08646000E-03  +6.35210000E-04  +3.70880000E-04  +3.21870000E-04
   +8.37600000E-04  -8.01870000E-04  -5.21900000E-05  -3.25074000E-03  +2.26316000E-03
   -1.88631000E-03  -3.00546050E-01  -8.82072700E-02  -5.69001300E-02  +7.66670000E-04
   +2.16720000E-04  -2.46650000E-04  -1.59090000E-04  -7.34500000E-05  +5.99000000E-06
   -1.33986000E-03  +7.07980000E-04  -1.47170000E-03  +1.80428000E-03  -2.91210000E-04
   +1.01183000E-03  -9.81700000E-05  -9.35900000E-05  +4.62400000E-05  +7.00600000E-05
   -4.50000000E-05  +5.49600000E-05  +4.34000000E-06  -1.68000000E-06  +4.00000000E-08
   +6.62200000E-05  +5.06000000E-06  +3.91600000E-05  -5.30300000E-05  +5.62000000E-06
   -2.96900000E-05  +2.59100000E-05  +9.23200000E-05  -9.88000000E-06  -6.39000000E-05
   -1.97000000E-05  -1.34100000E-05  -1.24080000E-04  -6.83800000E-05  +8.02000000E-05
   +9.75000000E-06  -2.40000000E-06  +2.54000000E-06  -1.20000000E-07  -2.15000000E-06
   -4.53000000E-06  +2.92600000E-05  +3.20700000E-05  -3.11300000E-05  +6.41000000E-06
   -1.04500000E-05  -6.87000000E-06  -2.20000000E-07  -6.34000000E-06  -5.50000000E-06
   -1.26000000E-06  +1.18000000E-05  -2.10200000E-05  +5.07800000E-05  -2.01900000E-05
   +1.36400000E-05  -1.45700000E-05  +3.11100000E-05  +2.37200000E-05  +1.10100000E-05
   +4.56000000E-06  -3.65600000E-05  -1.79500000E-05  +6.72200000E-05  +4.83500000E-05
   +5.12000000E-05  +8.89000000E-06  +6.51500000E-05  -5.90800000E-05  -7.04000000E-05
   -5.26400000E-05  -4.48700000E-05  -5.84900000E-05  -1.37760000E-04  +3.16949990E-01
   +2.26534000E-02  +9.92933000E-03  +4.72228000E-03  +2.18296000E-03  -1.92820000E-03
   +6.92070000E-04  +5.46600000E-05  -4.37240000E-04  -1.29900000E-04  +1.02345000E-03
   -5.72672000E-03  +2.42710000E-04  -3.19339000E-02  -4.99157000E-03  -7.19707000E-03
   -8.80600300E-02  -8.73945800E-02  -1.82180700E-02  -3.19640000E-04  -2.09200000E-04
   -3.15600000E-05  +1.15840000E-04  -5.44300000E-05  -6.81000000E-06  +4.67740000E-04
   -1.86380000E-04  +5.54980000E-04  +3.24720000E-03  +3.43458000E-03  +5.58830000E-04
   +1.60760000E-04  +7.17000000E-05  -6.50100000E-05  -5.37300000E-05  +8.79100000E-05
   -5.11000000E-05  -1.68000000E-05  -1.59200000E-05  +1.34400000E-05  -3.16900000E-05
   +1.36800000E-05  -5.73900000E-05  +6.75700000E-05  +1.89100000E-05  +5.60600000E-05
   -2.70500000E-05  -7.20300000E-05  +1.27000000E-05  +4.17700000E-05  +1.57800000E-05
   +1.69700000E-05  +8.27100000E-05  +9.45300000E-05  +3.62100000E-05  -1.60000000E-07
   +8.10000000E-07  -4.14000000E-06  +9.50000000E-07  +1.10000000E-06  +2.69000000E-06
   -4.58300000E-05  -4.78600000E-05  +4.29400000E-05  +6.50000000E-07  -9.04000000E-06
   -1.56100000E-05  +4.81000000E-06  +4.04000000E-06  +9.40000000E-07  -8.92000000E-06
   +9.54000000E-06  +3.16000000E-06  -5.23100000E-05  +2.45000000E-05  -2.98000000E-05
   -2.53000000E-06  +4.62000000E-06  -3.55700000E-05  -1.59900000E-05  +6.20000000E-06
   -5.01000000E-05  -1.77600000E-05  +3.79500000E-05  +1.82500000E-05  -7.28000000E-06
   +4.25900000E-05  -3.80100000E-05  -5.48900000E-05  +2.32100000E-04  +9.26000000E-06
   -1.57414000E-03  -3.87740000E-04  -6.12570000E-04  +9.22207000E-02  +8.64398800E-02
   -4.23344000E-03  -1.73321000E-03  +4.75633000E-03  -3.51137000E-03  +1.74049000E-03
   +7.86302000E-03  -2.11840000E-04  -1.91800000E-05  -5.50600000E-04  -4.84320000E-04
   +4.95560000E-04  +1.67037000E-03  -7.19500000E-04  -2.62190000E-04  +3.52212000E-03
   -5.68562900E-02  -1.76833800E-02  -5.09595200E-02  -2.62988000E-03  -6.86220000E-04
   +2.02990000E-04  +6.35600000E-05  +3.75300000E-05  -1.35760000E-04  +2.90389000E-03
   -1.35117000E-03  +2.68866000E-03  +6.18180000E-04  -1.00120000E-04  -1.73880000E-03
   +1.11450000E-04  +3.42860000E-04  +3.64270000E-04  -6.84300000E-05  +1.86800000E-05
   -7.69700000E-05  -1.68100000E-05  -2.70800000E-05  +1.04800000E-05  +3.12900000E-05
   +3.72100000E-05  -8.91000000E-06  +2.98400000E-05  -2.67700000E-05  +9.50000000E-07
   -8.61200000E-05  -1.09650000E-04  -3.07200000E-05  -6.05700000E-05  -3.30800000E-05
   -1.38200000E-05  +9.41300000E-05  -2.73100000E-05  -1.65660000E-04  +8.61000000E-06
   +5.16000000E-06  +6.79000000E-06  -1.08400000E-05  -6.80000000E-07  -4.19000000E-06
   +6.08000000E-06  -3.07900000E-05  +2.93300000E-05  -6.21000000E-06  +1.52100000E-05
   +1.48600000E-05  -7.80000000E-06  -1.41000000E-06  +4.55000000E-06  +4.37400000E-05
   +1.84200000E-05  +3.10400000E-05  -1.26700000E-05  +3.49000000E-06  +1.79700000E-05
   +2.62300000E-05  -5.86000000E-06  +2.25000000E-05  -6.50000000E-07  -1.21800000E-05
   +4.49500000E-05  +9.82000000E-06  -4.58700000E-05  -4.52700000E-05  -3.54700000E-05
   -2.84900000E-05  -2.71900000E-05  +3.33000000E-05  +1.03250000E-04  -1.37890000E-04
   -2.56000000E-06  +4.63200000E-05  +2.32560000E-04  +6.32803900E-02  +1.97738500E-02
   +3.98160500E-02  -6.18956100E-02  -4.51027600E-02  -3.26612000E-03  -2.51977000E-03
   -3.00584800E-02  -8.81930000E-04  -5.88298000E-03  +6.73030000E-04  -1.37711000E-03
   +5.55670000E-04  +3.02470000E-04  +6.97890000E-04  -3.78832000E-03  -8.98210000E-04
   -3.85649000E-03  +8.02081000E-03  +2.73307500E-02  -9.28660000E-04  +7.99760000E-04
   -2.77980000E-04  -1.82710000E-04  -6.45000000E-05  +5.23500000E-05  -1.77500000E-05
   +2.87724000E-03  +1.42052000E-03  +1.80326000E-03  -2.37930000E-04  +2.56063000E-03
   +4.48950000E-04  -2.41100000E-05  +2.23150000E-04  -9.80000000E-05  +1.91000000E-05
   -3.84600000E-05  +8.43200000E-05  +1.05100000E-05  +5.58200000E-05  -1.18100000E-05
   -4.01400000E-05  -2.50500000E-05  -8.17000000E-06  +4.65800000E-05  +3.68000000E-05
   +3.36000000E-06  +5.89300000E-05  +2.58900000E-05  +3.96700000E-05  +5.77600000E-05
   +3.26000000E-05  +1.05200000E-05  -8.20140000E-04  -1.06670000E-04  +5.62100000E-05
   -5.94000000E-06  -7.98000000E-06  -7.57000000E-06  +6.74000000E-06  -6.58000000E-06
   -5.60000000E-07  +9.90000000E-07  -2.72000000E-06  -6.65400000E-05  +4.36000000E-06
   -1.51900000E-05  -1.45600000E-05  +1.20600000E-05  +1.10000000E-06  -5.99000000E-06
   -1.12651000E-03  +1.10340000E-03  +1.31065000E-03  -3.83800000E-05  +3.60000000E-05
   -1.00800000E-05  +3.45050000E-04  +1.93570000E-04  +1.69100000E-05  -1.29200000E-05
   +1.07280000E-04  -1.27880000E-04  +9.96700000E-05  -1.95700000E-05  +1.53460000E-04
   +6.22000000E-05  +4.92600000E-05  +9.74700000E-05  +1.39840000E-04  -1.67883000E-03
   -5.25220000E-04  +2.27570000E-04  +5.30000000E-07  +3.43800000E-05  +4.57220000E-04
   -1.02520000E-04  +1.69426000E-03  +6.26551900E-02  -4.40739800E-02  -3.35002300E-01
   +7.04320000E-04  +1.30021000E-03  -7.80174000E-03  +1.18517000E-03  -2.07803000E-03
   +8.73030000E-04  -2.24030000E-04  +4.23310000E-04  +4.16510000E-04  +1.02570000E-04
   +2.12774000E-03  +2.00195000E-03  +1.29510000E-03  -5.55018000E-03  -1.51448200E-02
   -4.13790000E-04  -2.71840000E-04  -4.04560000E-04  -2.99040000E-04  -1.95240000E-04
   -7.82000000E-05  -8.34100000E-05  +7.77930000E-04  +1.45624000E-03  -2.17700000E-04
   +6.20120000E-04  -1.97355000E-03  +1.33860000E-04  -3.42000000E-05  +1.00520000E-04
   +1.49420000E-04  +3.58000000E-06  -3.12000000E-06  +2.75900000E-05  +5.60000000E-07
   +4.98000000E-06  +7.88000000E-06  +2.36300000E-05  +1.30000000E-06  +6.43000000E-06
   +1.10000000E-06  +1.01500000E-05  -2.58000000E-06  +8.40000000E-07  +4.93000000E-06
   -8.08000000E-06  -1.81400000E-05  -2.59000000E-06  -2.70000000E-06  +2.74360000E-04
   -5.84490000E-04  -6.26780000E-04  +4.62000000E-06  -3.10000000E-06  -6.30000000E-07
   +2.06000000E-06  -2.47000000E-06  -2.79000000E-06  +8.23000000E-06  -7.68000000E-06
   -2.37900000E-05  -1.39000000E-06  -1.36900000E-05  -6.70000000E-06  +3.75000000E-06
   -1.83000000E-06  -3.57000000E-06  +1.57057000E-03  +1.81050000E-04  -4.68620000E-04
   +4.66900000E-05  -2.28200000E-05  +6.55300000E-05  +2.83980000E-04  +1.87430000E-04
   +5.98200000E-05  +7.11500000E-05  +8.07200000E-05  -5.92300000E-05  +2.00500000E-05
   -8.01800000E-05  +1.71910000E-04  +3.00900000E-05  +3.25600000E-05  +4.55100000E-05
   -4.24500000E-05  -4.40860000E-04  -7.83000000E-05  +2.12800000E-05  -8.35200000E-05
   -6.07300000E-05  +5.13770000E-04  +9.91140000E-04  -4.53390000E-04  +4.41358300E-02
   +3.55308990E-01  -2.96540000E-03  +1.54204000E-03  -4.19475600E-02  -1.07250000E-03
   -4.13414000E-03  +9.61800000E-04  -1.22266000E-03  -6.86380000E-04  +3.93180000E-04
   +5.13400000E-04  +3.15820000E-04  -2.02635000E-03  -3.60525000E-03  -1.03170000E-04
   +1.31688800E-02  -8.03220000E-04  +6.18891000E-03  +1.04028900E-02  -1.19615000E-03
   -1.30480000E-04  +7.63390000E-04  +8.70600000E-05  +1.02480000E-04  +7.04000000E-05
   +1.85709000E-03  -9.38410000E-04  +1.47207000E-03  +6.51210000E-04  +6.52000000E-06
   -2.72123000E-03  +9.43600000E-05  +8.43300000E-05  +5.21100000E-05  -1.55800000E-05
   -4.43500000E-05  -1.48400000E-05  -1.14600000E-05  +2.12000000E-06  -9.83000000E-06
   +2.80800000E-05  +1.92800000E-05  +1.17900000E-05  -2.30000000E-07  +6.74000000E-06
   +1.28000000E-05  -5.47000000E-05  -8.37400000E-05  -3.20200000E-05  -3.78300000E-05
   -1.98600000E-05  -1.44000000E-05  +4.66950000E-04  +9.57000000E-05  -1.46300000E-05
   +5.40000000E-06  +3.50000000E-06  +5.63000000E-06  -1.27900000E-05  -1.60000000E-07
   -9.20000000E-07  +7.60000000E-07  -3.80000000E-06  +1.79000000E-05  +1.25000000E-06
   +1.54600000E-05  -6.88000000E-06  -5.89000000E-06  -4.70000000E-07  +2.67000000E-06
   +1.26683000E-03  -6.79010000E-04  -4.92430000E-04  -1.44780000E-04  -3.21000000E-06
   -3.17800000E-05  -1.36240000E-04  -4.64500000E-05  -4.47800000E-05  +7.22000000E-06
   -6.39400000E-05  +6.19700000E-05  -6.49500000E-05  +2.07800000E-05  -1.79280000E-04
   -1.13570000E-04  -6.76900000E-05  -7.26400000E-05  -3.61180000E-04  -3.35340000E-04
   +9.75100000E-04  +9.69600000E-05  +7.08100000E-05  -1.51920000E-04  +1.81198000E-03
   -2.14620000E-04  -7.40448000E-03  +4.93583000E-03  -9.19270000E-04  +2.67933800E-02
end_hess

