# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.26831780    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -8.96446740E+00  -3.55564685E+00  -7.16051692E-01
   006   -6.93293272E+00  -1.99939786E+00  -4.99872379E-01
   006   -5.04354510E+00  -1.87392935E+00  -2.32199272E+00
   006   -3.01987049E+00  -2.56399405E-01  -1.99092281E+00
   006   -2.80515475E+00  +1.27985178E+00  +1.37024578E-01
   006   -4.71321284E+00  +1.11754615E+00  +1.93399628E+00
   006   -6.75750948E+00  -4.96332072E-01  +1.63490489E+00
   006   -5.50019808E-01  +3.07332092E+00  +3.65836869E-01
   006   -7.93898955E-01  +5.13977227E+00  -1.65743724E+00
   006   -4.17885248E-01  +4.36108462E+00  +2.96219434E+00
   006   +1.90569316E+00  +1.60570080E+00  -1.06916852E-02
   006   +3.85961381E+00  +2.40831665E+00  -1.49648517E+00
   006   +6.14228445E+00  +1.23548045E+00  -1.85954523E+00
   006   +6.53345406E+00  -1.01639721E+00  -5.78342626E-01
   006   +4.61253304E+00  -1.95207190E+00  +9.82243566E-01
   006   +2.35746343E+00  -6.75616842E-01  +1.25909928E+00
   008   +8.73176324E+00  -2.29193567E+00  -8.43834261E-01
   001   -8.86857076E+00  -4.46804516E+00  -2.27400908E+00
   001   -5.15150655E+00  -3.04808711E+00  -3.99768512E+00
   001   -1.55279732E+00  -2.07762346E-01  -3.41717453E+00
   001   -4.63695281E+00  +2.26271701E+00  +3.62350034E+00
   001   -8.22699330E+00  -6.00942923E-01  +3.05108877E+00
   001   -2.54185062E+00  +6.19428773E+00  -1.37661072E+00
   001   +7.91721534E-01  +6.45354919E+00  -1.54705380E+00
   001   -8.25006835E-01  +4.33566673E+00  -3.55249383E+00
   001   -2.98111140E-01  +2.98465612E+00  +4.49125110E+00
   001   +1.26247575E+00  +5.54835504E+00  +3.04862592E+00
   001   -2.06172526E+00  +5.56254665E+00  +3.28680192E+00
   001   +7.60509788E+00  +1.98030124E+00  -3.07829192E+00
   001   +8.89700414E-01  -1.46738466E+00  +2.45484248E+00
   001   +8.64595854E+00  -3.79235332E+00  +1.73611451E-01
   008   +5.15828417E+00  -4.18982933E+00  +2.16082314E+00
   001   +3.74800158E+00  -4.73420399E+00  +3.14995687E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -8.00000000E-07  +1.61000000E-06  +3.03000000E-06
   -9.20000000E-07  +1.53000000E-06  +1.72000000E-06
   -1.13000000E-06  -2.30000000E-07  +1.70000000E-06
   -2.40000000E-07  +1.40000000E-07  +5.40000000E-07
   +2.20000000E-07  +8.30000000E-07  -2.00000000E-07
   +1.70000000E-07  +1.95000000E-06  +6.60000000E-07
   -2.60000000E-07  +2.40000000E-06  +1.23000000E-06
   +7.30000000E-07  -5.20000000E-07  -3.00000000E-08
   +1.02000000E-06  -3.30000000E-07  -2.16000000E-06
   +1.17000000E-06  +1.44000000E-06  -1.61000000E-06
   +2.60000000E-07  -4.60000000E-07  -1.48000000E-06
   +9.00000000E-07  -2.08000000E-06  -1.37000000E-06
   -1.42000000E-06  -2.43000000E-06  -3.50000000E-07
   +7.60000000E-07  -3.21000000E-06  -5.30000000E-07
   -9.10000000E-07  +4.70000000E-07  -4.00000000E-07
   -1.30000000E-07  -5.00000000E-07  +6.10000000E-07
   -1.96000000E-06  -2.03000000E-06  +5.00000000E-07
   -1.85000000E-06  +1.60000000E-06  +2.96000000E-06
   -1.40000000E-06  -5.20000000E-07  +2.09000000E-06
   -5.00000000E-07  -1.28000000E-06  +3.50000000E-07
   +8.30000000E-07  +2.61000000E-06  -2.40000000E-07
   +1.20000000E-07  +3.33000000E-06  +1.30000000E-06
   +1.24000000E-06  +5.00000000E-08  -2.09000000E-06
   +1.46000000E-06  -9.70000000E-07  -2.62000000E-06
   +6.50000000E-07  -1.42000000E-06  -1.72000000E-06
   +1.32000000E-06  +1.90000000E-06  -9.20000000E-07
   +1.74000000E-06  +7.60000000E-07  -2.23000000E-06
   +1.65000000E-06  +1.75000000E-06  -2.00000000E-06
   +4.00000000E-07  -3.46000000E-06  -1.68000000E-06
   -3.20000000E-07  +7.40000000E-07  +6.70000000E-07
   -1.12000000E-06  -2.37000000E-06  +5.70000000E-07
   -4.50000000E-07  -1.56000000E-06  +2.07000000E-06
   -1.21000000E-06  +2.40000000E-07  +1.61000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.01275900E-01  +1.65434940E-01  +3.12437450E-01  -4.06603400E-02  +2.70664760E-01
   +5.01581530E-01  -2.22654620E-01  -1.33728680E-01  -1.44364600E-02  +5.65453670E-01
   -1.09671920E-01  -1.47860270E-01  -4.42579500E-02  +1.99599170E-01  +4.30958950E-01
   +2.42189300E-02  -1.70583400E-02  -9.71482400E-02  -1.23496950E-01  +1.99731890E-01
   +6.04549940E-01  -3.82883000E-02  -1.49324600E-02  +2.79772900E-02  -2.02389940E-01
   -4.30971800E-02  +7.66225400E-02  +5.52003130E-01  -3.43653700E-02  -1.85396000E-03
   +1.89965300E-02  -2.31881000E-03  -1.00836350E-01  -4.58078900E-02  +2.16683970E-01
   +4.21654030E-01  -1.56541000E-03  -1.73081000E-03  +8.76668000E-03  +1.38762520E-01
   -2.20318000E-03  -2.21109780E-01  -1.20508430E-01  +2.21808580E-01  +5.93807720E-01
   +3.39865000E-03  -2.62227000E-03  +2.32820000E-04  -4.55983100E-02  -4.61962000E-03
   +4.39111500E-02  -2.50124650E-01  -1.52316090E-01  -3.13448500E-02  +5.95933260E-01
   +1.61675000E-03  +2.85901000E-03  -8.26253000E-03  -3.31500500E-02  +1.95075000E-02
   +6.08662100E-02  -1.18475960E-01  -1.80796450E-01  -5.97979400E-02  +2.05928900E-01
   +4.03875320E-01  +6.65491000E-03  -3.86259000E-03  -5.71442000E-03  -3.44000000E-06
   +3.07106800E-02  +4.94137000E-02  +2.05297200E-02  -2.38345000E-02  -1.18183820E-01
   -1.56790970E-01  +1.77225130E-01  +5.77576230E-01  -1.98808000E-03  -2.37448000E-03
   -3.00955000E-03  -9.72390000E-03  +1.41688000E-02  +2.65837100E-02  +2.17879800E-02
   -8.79728000E-03  -2.78093600E-02  -1.14157040E-01  -4.42704500E-02  -2.19854300E-02
   +5.29117260E-01  -2.04351000E-03  -1.10428000E-03  +2.37705000E-03  +1.50946000E-02
   -1.04920000E-02  -2.30184600E-02  -3.42456300E-02  -2.36509200E-02  -1.24415400E-02
   -1.15645400E-02  -1.61201290E-01  -1.24599480E-01  +1.55463470E-01  +3.98514560E-01
   -3.59032000E-03  +1.93381000E-03  +5.39265000E-03  +2.85402700E-02  -2.22151000E-02
   -7.03651800E-02  -6.90511900E-02  -4.01049800E-02  +2.00783900E-02  +2.97533900E-02
   -8.95189300E-02  -2.38728940E-01  -1.31561840E-01  +1.56775270E-01  +5.64316960E-01
   +7.08560000E-04  +2.86808000E-03  +9.21734000E-03  +2.55941900E-02  -3.44295000E-02
   -7.84194600E-02  -5.71495300E-02  -2.43392200E-02  +1.96253400E-02  +3.45529500E-02
   +5.03027100E-02  +5.02504700E-02  -2.18293700E-01  -4.92531300E-02  +8.65274200E-02
   +5.44440820E-01  -3.55180000E-04  +4.54762000E-03  -7.06540000E-04  -6.12221000E-03
   -2.82817700E-02  -4.03859100E-02  -2.24093900E-02  -1.35103300E-02  +8.72346000E-03
   +2.44470900E-02  +2.49871300E-02  -3.92970000E-04  -1.61939000E-02  -9.91323100E-02
   -3.17071900E-02  +2.01133220E-01  +4.22965310E-01  +4.06762000E-03  -4.12256000E-03
   -5.66382000E-03  -3.40035800E-02  -1.03652000E-02  +2.24696700E-02  +2.15613500E-02
   +1.01527300E-02  -1.09324000E-02  +1.07814400E-02  -2.74946000E-02  -4.51449300E-02
   +1.37683110E-01  +2.42752000E-03  -2.10582570E-01  -1.21134330E-01  +2.15111970E-01
   +6.06197340E-01  -4.51995000E-03  -3.34777600E-02  -3.87958000E-02  -1.14780360E-01
   -4.70770000E-04  +4.60979200E-02  +3.44742900E-02  +2.32831400E-02  +8.09422000E-03
   -1.85368700E-02  -2.41917900E-02  -2.07219300E-02  -4.08283500E-02  -6.54373000E-03
   +4.16504000E-02  -2.45240800E-01  -1.46756340E-01  -2.77918800E-02  +5.92007290E-01
   -1.45845600E-02  -2.40612500E-02  -3.32791100E-02  -3.86998600E-02  -1.57179600E-01
   -9.11583600E-02  +4.64579600E-02  +2.51437600E-02  -2.41834400E-02  -2.25817600E-02
   -3.74426300E-02  -2.90075600E-02  -3.12683900E-02  +1.91591600E-02  +5.14268800E-02
   -1.12787550E-01  -1.76847410E-01  -5.68514800E-02  +2.15282510E-01  +4.00876620E-01
   -9.77255000E-03  -1.31823700E-02  -2.07370000E-03  -1.26421700E-02  -1.31982280E-01
   -2.61825160E-01  +4.37995500E-02  +7.63280000E-04  -3.72125800E-02  -1.82370000E-02
   -2.73221900E-02  -2.58130800E-02  +3.20910000E-03  +2.54749800E-02  +4.23500400E-02
   +2.37733700E-02  -2.14011000E-02  -1.18485640E-01  -1.64083740E-01  +1.88297740E-01
   +5.96403250E-01  +1.58944000E-03  +1.42602000E-03  -4.83100000E-05  -2.39697000E-03
   -2.30080000E-04  +1.24538000E-03  +4.30937000E-03  +2.59520000E-04  +1.50589000E-03
   -2.62144000E-03  -7.14078000E-03  -6.99584000E-03  -1.36550440E-01  -4.73153000E-02
   +3.18030000E-04  -1.66236300E-02  -1.43590800E-02  +6.61700000E-05  +1.12986000E-03
   -1.56765000E-03  +3.73438000E-03  +4.77879150E-01  +8.01790000E-04  +1.66230000E-04
   +3.81880000E-04  -5.01940000E-04  -8.03910000E-04  -5.97800000E-05  -2.51710000E-04
   +2.65969000E-03  -3.60560000E-03  -1.61185700E-02  -1.37286100E-02  -4.90956000E-03
   -4.82813300E-02  -1.12081310E-01  -1.09574800E-02  -4.40336000E-03  +2.04774000E-03
   +3.75662000E-03  -6.75660000E-04  +4.30789000E-03  -3.13478000E-03  +4.61678000E-03
   +4.79476110E-01  +6.38930000E-04  +1.09936000E-03  +3.71950000E-04  +9.86700000E-05
   -7.84420000E-04  -1.76747000E-03  +1.43178000E-03  -4.78369000E-03  -3.21840000E-03
   -2.20592400E-02  -1.58680400E-02  +1.93389000E-03  -2.91652000E-03  -1.30001500E-02
   -8.64768800E-02  +1.34769500E-02  +1.33455600E-02  +7.16017000E-03  +4.31097000E-03
   -1.85360000E-03  -8.79670000E-04  -2.62525000E-03  +1.45366000E-03  +4.80273490E-01
   -1.16020000E-03  -1.01934000E-03  -2.85810000E-04  +5.67260000E-04  +7.01790000E-04
   +6.27660000E-04  -1.86730000E-04  +6.24580000E-04  +2.28830000E-04  -3.94690000E-04
   -1.07278000E-03  +6.63880000E-04  -8.84040000E-04  -2.07587700E-02  +1.91272600E-02
   -6.66130000E-04  -1.81971000E-03  -1.09841000E-03  -1.46320000E-03  +3.33640000E-04
   -1.05992000E-03  -7.65581500E-02  +3.42064000E-03  -3.86633000E-03  +5.85823040E-01
   -3.71930000E-04  -3.73000000E-04  -1.43840000E-04  +8.19500000E-05  +4.11020000E-04
   +5.92590000E-04  +3.78200000E-05  +7.37300000E-04  +1.55220000E-04  -2.09190000E-04
   -4.62430000E-04  +9.57660000E-04  -7.36510000E-03  -2.24487000E-02  +1.54089500E-02
   +1.39412000E-03  -9.87810000E-04  -9.53130000E-04  -8.44340000E-04  +1.73500000E-05
   -8.08000000E-04  +9.57228000E-03  -1.25578150E-01  +5.09876800E-02  +5.74656000E-03
   +5.18306820E-01  -5.62470000E-04  -4.73930000E-04  -1.88260000E-04  +2.45590000E-04
   +2.13460000E-04  +4.05700000E-04  +1.85110000E-04  +1.07470000E-04  -1.87280000E-04
   -1.60617000E-03  -1.24277000E-03  -2.66020000E-04  +6.31107000E-03  +4.75198000E-03
   +1.30209000E-03  -7.32690000E-04  -3.90030000E-04  -1.58160000E-04  -1.65990000E-04
   -1.73690000E-04  -3.15430000E-04  -8.36846000E-03  +4.77687200E-02  -1.23682420E-01
   -7.97841000E-03  +6.29045000E-02  +5.32974900E-01  -5.47120000E-04  -4.39470000E-04
   -8.53300000E-05  +3.97670000E-04  +2.45810000E-04  +1.27350000E-04  +3.06190000E-04
   -8.84690000E-04  -1.03191000E-03  -4.45019000E-03  -2.90050000E-03  +9.28150000E-04
   -1.49302000E-03  -1.29858200E-02  -2.53821200E-02  -1.47644000E-03  -7.64910000E-04
   -7.94860000E-04  +1.37650000E-04  -2.72530000E-04  -7.77230000E-04  -7.55375000E-02
   -9.94000000E-04  -4.67660000E-04  +5.18610000E-04  -8.66380000E-04  -3.46637000E-03
   +5.86382040E-01  -8.59100000E-05  -9.04800000E-05  -3.59600000E-05  -9.45700000E-05
   +1.24030000E-04  -8.54200000E-05  +1.96920000E-04  -4.84420000E-04  -8.09350000E-04
   -3.42768000E-03  -9.87020000E-04  +5.29180000E-04  -4.62812000E-03  -1.22609800E-02
   -2.07625000E-02  -4.54520000E-04  -9.50680000E-04  +4.31810000E-04  +5.30840000E-04
   -3.35040000E-04  -7.32740000E-04  -4.63655000E-03  -9.45750100E-02  -4.06556800E-02
   +8.35540000E-04  +9.62443000E-03  +2.22769000E-02  -2.01369000E-03  +5.59882970E-01
   +3.23030000E-04  +2.51440000E-04  +1.19000000E-06  -2.79310000E-04  -1.25060000E-04
   +2.46680000E-04  +4.42700000E-04  +1.62910000E-04  +3.09000000E-05  +7.48510000E-04
   +7.72860000E-04  +2.57560000E-04  -5.28873000E-03  -4.11255000E-03  -2.91977000E-03
   +1.00131000E-03  +8.49310000E-04  +3.24090000E-04  +2.94910000E-04  +1.06000000E-06
   -2.95590000E-04  -6.45323000E-03  -3.77475900E-02  -1.54996660E-01  -1.70871000E-03
   -6.66809000E-03  -3.51484000E-02  -8.47427000E-03  -5.35101600E-02  +4.90967740E-01
   -1.29470000E-04  -1.29180000E-04  -9.27100000E-05  -7.41300000E-05  +2.30890000E-04
   +5.67440000E-04  +2.89390000E-04  +5.02500000E-04  +6.85900000E-04  -7.75880000E-04
   +6.11730000E-04  +1.06700000E-05  -3.58032300E-02  +5.78662000E-03  +6.05231000E-03
   -7.83470000E-04  -3.87300000E-05  -2.60975000E-03  -1.99870000E-04  -1.21771000E-03
   +4.53700000E-04  -1.42698670E-01  +4.14139100E-02  +1.23211200E-02  -4.96633000E-03
   +8.35768000E-03  -2.55941000E-03  -4.43679000E-03  +7.59587000E-03  +9.62805000E-03
   +5.75490710E-01  -7.05020000E-04  -6.83060000E-04  -2.23880000E-04  +2.03710000E-04
   +7.66490000E-04  +5.96150000E-04  +1.74170000E-04  -7.48400000E-05  +7.72000000E-06
   -2.24219000E-03  -5.61700000E-04  -3.25500000E-04  -1.35255200E-02  +1.21844700E-02
   +4.64900000E-03  -1.57115000E-03  -2.39143000E-03  -1.36318000E-03  -5.20920000E-04
   -1.08669000E-03  +4.77040000E-04  +4.23947900E-02  -1.03931990E-01  +6.70400000E-04
   +2.47753700E-02  -1.91543200E-02  -9.54910000E-04  +1.50203100E-02  -1.27322800E-02
   -9.36304000E-03  -6.84031400E-02  +4.86933340E-01  -3.12260000E-04  -3.63760000E-04
   +1.46700000E-05  +1.91870000E-04  +1.86140000E-04  +7.75000000E-06  -2.13320000E-04
   +3.17060000E-04  +4.02400000E-05  -2.06293000E-03  -9.15440000E-04  -1.07920000E-04
   +2.50304000E-03  +1.17130000E-03  -4.62600000E-04  +1.29730000E-04  +1.78660000E-04
   +3.16400000E-05  -6.12700000E-05  +2.81500000E-05  -1.10540000E-04  +1.31613100E-02
   +1.48875000E-03  -7.33256200E-02  -2.20498300E-02  +1.49313100E-02  +2.43237000E-03
   +2.69756100E-02  -1.91659600E-02  -8.52581000E-03  -1.61044410E-01  -1.65021660E-01
   +3.58875730E-01  -8.24000000E-05  -3.86800000E-05  -7.80000000E-07  +1.84190000E-04
   +1.29000000E-05  -3.81170000E-04  -2.57550000E-04  -3.36830000E-04  +1.03710000E-04
   +6.57760000E-04  +3.86100000E-05  +4.82560000E-04  -1.11449000E-03  +2.01663000E-03
   +3.76400000E-04  -8.09730000E-04  -8.24660000E-04  +6.03900000E-05  +1.75910000E-04
   +1.64430000E-04  +3.09630000E-04  -2.39810000E-02  -3.77222000E-03  +1.38464300E-02
   -1.26200000E-03  -6.35360000E-04  +8.46360000E-04  -7.70700000E-05  -1.72625000E-03
   -1.20098000E-03  -2.39672890E-01  -3.44968100E-02  +1.15527090E-01  +5.88214330E-01
   +1.64770000E-04  +1.25340000E-04  +3.37700000E-05  -1.78770000E-04  -5.01800000E-05
   +9.35500000E-05  +1.80700000E-04  +2.16370000E-04  -5.62100000E-05  -2.07020000E-04
   +5.54200000E-05  +1.62600000E-05  +1.20098000E-03  -1.88828000E-03  -7.88480000E-04
   +4.21270000E-04  +5.15910000E-04  +1.33430000E-04  -8.68000000E-06  +1.02960000E-04
   -1.71690000E-04  +6.78068000E-03  +9.79409000E-03  -8.89395000E-03  +2.25026000E-03
   +8.69120000E-04  -4.45750000E-04  +1.89256000E-03  -1.23450000E-03  -3.89420000E-04
   -5.79087300E-02  -1.08036940E-01  +6.38399500E-02  -8.16997900E-02  +2.78120710E-01
   -1.77360000E-04  -1.99470000E-04  -2.73200000E-05  -9.20100000E-05  +2.07110000E-04
   +4.26580000E-04  +2.65550000E-04  +3.26280000E-04  +9.38100000E-05  -6.42910000E-04
   -8.75000000E-05  -5.28690000E-04  -2.39681000E-03  +4.07400000E-05  +4.96900000E-04
   +2.88240000E-04  +2.50510000E-04  -2.55370000E-04  -2.64700000E-04  -4.82640000E-04
   -1.05870000E-04  +8.42499000E-03  -4.41986000E-03  -2.51337000E-03  -9.34380000E-04
   -1.22600000E-04  +4.27290000E-04  +2.86000000E-06  +4.20530000E-04  +1.39320000E-04
   +1.29991450E-01  +5.38592800E-02  -1.52403680E-01  -2.02515300E-01  -9.25072200E-02
   +2.34888840E-01  -1.57170000E-04  -1.39650000E-04  -7.02100000E-05  +7.22400000E-05
   +1.58170000E-04  +2.74120000E-04  +1.79030000E-04  +9.46500000E-05  -1.23120000E-04
   -3.36530000E-04  +1.31880000E-04  -5.94000000E-06  -5.72250000E-04  +6.90780000E-04
   +5.10060000E-04  +1.52230000E-04  +9.67900000E-05  -2.90310000E-04  -1.18500000E-04
   -2.32410000E-04  -1.10510000E-04  +1.56760000E-04  -2.46784000E-03  +3.08745000E-03
   +1.70800000E-04  -5.30660000E-04  +2.46240000E-04  -1.00980000E-03  +5.60920000E-04
   +1.09000000E-05  -4.68729600E-02  -1.84373500E-02  +3.74994200E-02  -2.90783160E-01
   +1.17996120E-01  +4.41492000E-02  +6.43223510E-01  +1.73370000E-04  +1.88690000E-04
   +5.82400000E-05  -1.92400000E-05  -2.03820000E-04  -3.39640000E-04  -2.00120000E-04
   -1.62190000E-04  +8.87600000E-05  +4.53200000E-04  -1.50000000E-06  +1.01470000E-04
   +4.18210000E-04  -3.57830000E-04  -3.66940000E-04  -1.94810000E-04  -1.58860000E-04
   +2.26490000E-04  +1.76350000E-04  +2.83770000E-04  +1.43090000E-04  +6.54840000E-04
   +3.71960000E-04  +2.17636000E-03  +4.47890000E-04  -4.97490000E-04  -1.18050000E-04
   +1.00380000E-04  -3.66040000E-04  +2.57170000E-04  +1.00745700E-02  +4.81571800E-02
   -3.30454100E-02  +9.63036400E-02  -1.33418560E-01  +7.22879000E-03  -8.41750700E-02
   +5.06577360E-01  +2.56400000E-05  +2.15400000E-05  +1.98400000E-05  -2.63000000E-05
   -3.33100000E-05  +1.03800000E-05  -1.81000000E-06  +3.55800000E-05  +9.28000000E-06
   +7.59600000E-05  -7.33400000E-05  -1.94580000E-04  +9.32820000E-04  -7.28270000E-04
   -3.04540000E-04  +1.86850000E-04  +1.70390000E-04  +1.64290000E-04  -1.05600000E-05
   +3.97400000E-05  -7.79000000E-05  +2.10159000E-03  +4.51980000E-03  +1.58563000E-03
   -1.66300000E-04  +4.71650000E-04  +1.92600000E-05  -8.74230000E-04  +5.61770000E-04
   +7.11100000E-05  +1.84132700E-02  -1.99904300E-02  +7.59705000E-03  +5.75371500E-02
   -2.55900000E-03  -7.44409100E-02  -2.06308280E-01  -2.13248450E-01  +3.59870710E-01
   +9.68790000E-04  +8.04230000E-04  +1.39760000E-04  -7.93360000E-04  -6.37160000E-04
   -1.35670000E-04  +3.08860000E-04  -4.45700000E-05  -3.29480000E-04  -6.92900000E-05
   +1.65220000E-04  +1.97320000E-04  -2.01970000E-04  -7.50550000E-04  -3.89300000E-05
   +9.17200000E-05  +2.53220000E-04  +1.46940000E-04  +1.78370000E-04  +2.66430000E-04
   +1.20770000E-04  -2.81531000E-03  +6.63290000E-04  -3.47660000E-04  +4.03530000E-04
   +1.68070000E-04  -3.21770000E-04  +1.04674000E-03  -3.60210000E-04  +1.33680000E-04
   -4.90086000E-03  -2.79907100E-02  +2.22192800E-02  +1.49648700E-02  +3.09244700E-02
   -2.32435200E-02  -1.17415100E-01  +5.65821000E-02  -1.02700000E-02  +6.14891300E-01
   -3.93500000E-04  -3.59910000E-04  -9.35700000E-05  +2.04450000E-04  +3.57740000E-04
   +3.71950000E-04  +1.33990000E-04  +1.49800000E-04  -6.54000000E-06  -3.18990000E-04
   -5.69500000E-05  -2.38360000E-04  -4.31870000E-04  +6.49870000E-04  +4.45740000E-04
   +2.15100000E-04  +1.54440000E-04  -2.28910000E-04  -2.16240000E-04  -3.82960000E-04
   -1.83740000E-04  -6.49930000E-04  -1.15422000E-03  +7.44840000E-04  -2.07800000E-04
   +5.62800000E-05  -5.06500000E-05  -5.72440000E-04  +5.39050000E-04  -1.90330000E-04
   -2.31720800E-02  -3.62286400E-02  +3.53763300E-02  +7.91566600E-02  -2.73664900E-02
   -1.53949100E-02  -1.01238900E-02  -2.56735510E-01  +1.31647340E-01  -1.29054340E-01
   +6.04184540E-01  -2.23160000E-04  -1.73930000E-04  -1.58000000E-05  +2.56950000E-04
   +9.52100000E-05  -2.15330000E-04  -2.68900000E-04  -1.49720000E-04  +1.64760000E-04
   +3.02480000E-04  -1.01720000E-04  +1.37350000E-04  +2.54690000E-04  +1.19180000E-04
   -2.67680000E-04  -2.62800000E-04  -2.14520000E-04  +7.51400000E-05  +9.95100000E-05
   +1.09700000E-04  +6.36100000E-05  +1.27664000E-03  +1.03080000E-04  -9.98330000E-04
   -2.39850000E-04  -1.43790000E-04  +2.07050000E-04  +4.31200000E-05  -3.36310000E-04
   +1.31470000E-04  +1.80156600E-02  +3.77767700E-02  -3.37557900E-02  -5.55226900E-02
   +7.59227000E-03  +2.95392400E-02  +3.36429600E-02  +9.81541900E-02  -1.44787170E-01
   -1.48236200E-01  -2.33877020E-01  +3.73288470E-01  -9.00200000E-05  -5.62900000E-05
   +1.53300000E-05  +1.23440000E-04  -5.08800000E-05  -3.36170000E-04  -3.43290000E-04
   -2.64950000E-04  +1.90210000E-04  +4.43480000E-04  -2.06280000E-04  +2.33490000E-04
   +4.45720000E-04  +3.72530000E-04  -4.58290000E-04  -3.87550000E-04  -4.30170000E-04
   +1.94720000E-04  +1.69170000E-04  +2.09370000E-04  +1.49180000E-04  +3.77549000E-03
   -7.15960000E-04  +1.70988000E-03  +5.15160000E-04  -4.08060000E-04  +3.71360000E-04
   -7.48810000E-04  +2.32350000E-04  +1.03110000E-04  +1.82824700E-02  +6.97230800E-02
   -5.55724000E-02  -7.01788200E-02  +1.31836000E-03  +3.13254300E-02  +5.02143000E-02
   -5.71407300E-02  +1.44410600E-02  -1.97556710E-01  -1.16844000E-03  +6.24363600E-02
   +6.58184700E-01  -1.00150000E-03  -9.27190000E-04  -1.49740000E-04  +8.37580000E-04
   +7.05210000E-04  +3.43340000E-04  -1.20060000E-04  +8.47900000E-05  +2.73600000E-04
   -9.01300000E-05  +2.81450000E-04  -9.69500000E-05  -7.17680000E-04  +5.66450000E-04
   -1.93000000E-04  +3.84640000E-04  +2.44770000E-04  -5.16260000E-04  -1.70660000E-04
   -4.05280000E-04  -2.50060000E-04  +7.47750000E-04  -1.78399000E-03  +4.63146000E-03
   +7.93200000E-04  -3.87770000E-04  -2.30680000E-04  -9.46810000E-04  +6.25210000E-04
   +2.73200000E-04  +2.56836200E-02  -2.21575300E-02  +2.65011000E-03  -6.64770000E-04
   -1.90900000E-05  -1.49463000E-03  -1.55440600E-02  -1.57410300E-02  +2.07513300E-02
   -7.65665300E-02  -1.20331320E-01  +6.81919700E-02  -1.28454520E-01  +5.63476860E-01
   +6.49620000E-04  +5.77400000E-04  +7.08600000E-05  -5.76830000E-04  -4.00810000E-04
   +3.98800000E-05  +3.15600000E-04  +1.72620000E-04  -3.39810000E-04  -2.58100000E-04
   -4.22400000E-05  -6.71000000E-05  +3.44040000E-04  -3.11830000E-04  -3.14200000E-05
   +1.33190000E-04  +1.98150000E-04  +1.70050000E-04  +1.38800000E-05  +7.66400000E-05
   +3.04200000E-05  -3.19940000E-04  +3.99294000E-03  +1.06529000E-03  -2.21330000E-04
   +3.79180000E-04  +3.91000000E-06  +2.23940000E-04  +2.06070000E-04  -3.15800000E-05
   -2.43322900E-02  -1.85448100E-02  +2.78809200E-02  +3.35916800E-02  -2.49419000E-03
   -1.72771900E-02  -1.27780300E-02  +4.12295200E-02  -1.66103100E-02  +1.10754350E-01
   +3.06482000E-02  -1.48842920E-01  -1.68393960E-01  -2.08540960E-01  +3.61569550E-01
   -2.70590000E-04  -2.83710000E-04  -6.58900000E-05  +9.67700000E-05  +2.61260000E-04
   +4.99900000E-04  +3.85820000E-04  +2.77980000E-04  -1.18800000E-04  -1.30288000E-03
   +5.05100000E-04  -5.45720000E-04  -1.04648000E-03  +2.41567000E-03  -9.83120000E-04
   +8.59450000E-04  +6.89880000E-04  -6.38980000E-04  -2.55160000E-04  -5.63050000E-04
   -2.21490000E-04  -4.08218000E-03  +2.41780400E-02  -1.35413900E-02  -5.12578000E-03
   +2.39798000E-03  +1.44845000E-03  -3.45550000E-04  +4.18760000E-04  -1.33502000E-03
   -1.11861980E-01  +6.77851000E-03  +2.18988300E-02  +3.80343100E-02  -1.85913000E-02
   +6.78330000E-04  -2.40895800E-02  +2.99002600E-02  -6.90288000E-03  -4.95842800E-02
   -2.10865600E-02  +3.97263400E-02  -2.91988420E-01  +1.33301220E-01  +2.74276000E-02
   +6.40303160E-01  +5.71000000E-06  +2.76600000E-05  +4.63300000E-05  -1.22250000E-04
   -2.78500000E-05  +1.66300000E-04  +7.94200000E-05  +2.62180000E-04  +1.65380000E-04
   -1.46130000E-04  -3.80820000E-04  -8.26330000E-04  -5.63680000E-04  -5.68790000E-04
   +3.73650000E-04  +1.58200000E-05  +8.86400000E-05  +1.91390000E-04  -2.13330000E-04
   -3.34200000E-04  +7.75300000E-05  +9.70481000E-03  -1.35138200E-02  +6.82736000E-03
   +1.52329000E-03  +6.95000000E-05  -7.79970000E-04  -2.55940000E-04  +3.25500000E-04
   +1.11185000E-03  +6.66908500E-02  -2.37130230E-01  +8.03010700E-02  -6.70789800E-02
   -1.44721600E-02  +5.03713900E-02  +3.42571500E-02  -4.06048600E-02  +1.06159400E-02
   +2.22106800E-02  +5.27954200E-02  -4.28344100E-02  +6.52072400E-02  -1.60233740E-01
   +3.32261900E-02  -9.83138700E-02  +5.35350340E-01  +5.69400000E-05  +6.26400000E-05
   -6.95000000E-06  +9.05000000E-06  +3.43600000E-05  +1.85730000E-04  +2.64120000E-04
   +2.67030000E-04  -6.71800000E-05  -7.26470000E-04  +5.14590000E-04  -2.88580000E-04
   -2.63680000E-04  +1.00900000E-05  +3.28450000E-04  +4.14280000E-04  +1.49690000E-04
   -3.58650000E-04  -7.30800000E-05  +8.51800000E-05  -1.10330000E-04  -2.72660000E-03
   -2.25083000E-03  +6.41631000E-03  +1.32463000E-03  -5.16930000E-04  -2.36460000E-04
   +6.95880000E-04  -7.94530000E-04  -2.70010000E-04  -1.85776400E-02  +1.09722940E-01
   -1.24442190E-01  +3.25702800E-02  +2.66603100E-02  -2.03938700E-02  -1.00390800E-02
   +1.35045700E-02  -2.16871000E-03  +1.11414400E-02  -2.20713800E-02  +1.22283000E-02
   +7.16685600E-02  +4.41990000E-04  -9.55808500E-02  -1.85541400E-01  -2.17080090E-01
   +3.52242980E-01  -1.07144000E-03  -9.02490000E-04  -1.81770000E-04  +8.34760000E-04
   +7.36510000E-04  +2.90140000E-04  -2.42650000E-04  +6.93500000E-05  +2.77170000E-04
   -1.32160000E-04  -8.16300000E-05  -1.27830000E-04  -1.14500000E-05  +9.81300000E-04
   +9.97100000E-05  +3.59800000E-05  -1.01930000E-04  -3.48770000E-04  -2.24490000E-04
   -3.90020000E-04  -2.22970000E-04  +2.05073000E-03  -6.52890000E-04  +7.46070000E-04
   -5.76370000E-04  -7.53600000E-05  +3.67460000E-04  -1.52546000E-03  +6.12270000E-04
   -4.36970000E-04  -1.94992000E-03  +5.24221000E-03  -4.27593000E-03  -1.96679000E-03
   -9.37030000E-04  +4.03547000E-03  -6.84092000E-03  +1.63498800E-02  -3.66698000E-03
   -2.61910840E-01  +8.27142300E-02  +5.56774300E-02  -5.21020900E-02  +3.18783600E-02
   +1.02381400E-02  +5.71357000E-03  -6.90082000E-03  +4.38261000E-03  +3.57157210E-01
   +7.10540000E-04  +6.30900000E-04  +1.22970000E-04  -5.20160000E-04  -5.06980000E-04
   -2.32140000E-04  +1.32990000E-04  -3.84100000E-05  -1.80450000E-04  +1.28590000E-04
   +1.05340000E-04  +1.03960000E-04  +7.02800000E-05  -7.68310000E-04  -9.61200000E-05
   -4.43600000E-05  +4.97200000E-05  +2.40370000E-04  +1.66340000E-04  +3.27970000E-04
   +1.61990000E-04  -1.18331000E-03  +4.34460000E-04  -7.23070000E-04  +3.54270000E-04
   -1.45100000E-05  -2.55980000E-04  +1.00785000E-03  -4.51920000E-04  +3.11910000E-04
   +2.53445000E-03  +3.10320000E-04  -1.24284000E-03  -1.81268000E-03  -1.42667000E-03
   +5.15870000E-03  +4.56638800E-02  -2.65769500E-02  -7.68190000E-04  +1.25502360E-01
   -1.44033250E-01  +3.91412000E-03  +4.54535000E-03  -8.70060000E-04  +4.49342000E-03
   -1.32215000E-03  -6.57810000E-04  +4.53506000E-03  -1.24460260E-01  +5.19944490E-01
   +9.81100000E-05  +8.35700000E-05  +2.70800000E-05  -8.47200000E-05  -6.14900000E-05
   -1.51800000E-05  +3.42000000E-05  -1.91000000E-06  -2.28700000E-05  +3.27900000E-05
   -2.73700000E-05  -4.95600000E-05  +4.51500000E-05  -9.81500000E-05  +1.10060000E-04
   -7.57000000E-06  -2.91600000E-05  +5.66600000E-05  -1.28400000E-05  +1.76200000E-05
   +3.57300000E-05  -2.20200000E-04  -1.24750000E-04  -6.79400000E-05  +7.21100000E-05
   +4.41900000E-05  -4.59600000E-05  +1.70200000E-05  +4.35800000E-05  -3.07000000E-05
   -1.33934000E-03  -3.36740000E-03  +1.96525000E-03  +4.87255000E-03  +4.74308000E-03
   -3.17360000E-04  -2.29435200E-02  +1.40321600E-02  +9.41949000E-03  +2.79007600E-02
   +2.50544200E-02  -7.23120100E-02  +2.76558400E-02  -9.01994000E-03  +1.81523000E-03
   +8.10130000E-04  +7.26402000E-03  +1.97550000E-04  -8.25753300E-02  -2.57356510E-01
   +2.36983680E-01  -3.70189000E-02  +1.57958000E-02  +6.22590800E-02  -2.46598000E-03
   -2.22994900E-02  -3.57378400E-02  +1.33494000E-03  -2.07200000E-05  -2.38970000E-03
   -6.20500000E-04  -1.50480000E-04  -2.29870000E-04  -7.24100000E-05  +2.78490000E-04
   +6.20880000E-04  +1.54444000E-03  -7.25510000E-04  -8.16090000E-04  -4.60607000E-03
   -4.06758000E-03  +8.91070000E-04  -1.80420000E-04  +6.62000000E-06  +1.03560000E-04
   +4.32900000E-05  -3.78000000E-06  -1.63200000E-05  +7.20600000E-05  +2.97600000E-05
   -2.01500000E-05  -1.95500000E-05  +3.56000000E-06  +2.31900000E-05  +1.16000000E-06
   +2.88000000E-06  +1.17900000E-05  +9.26000000E-06  -1.01200000E-05  +4.95000000E-06
   -1.29910000E-04  +4.16300000E-05  +2.77500000E-05  +7.04000000E-06  +7.34700000E-05
   -5.42100000E-05  +1.13200000E-05  +2.91300000E-05  +2.49400000E-05  +1.33560000E-04
   -6.94700000E-05  -8.20000000E-06  +4.30749900E-02  -8.69594000E-03  -1.41786570E-01
   -2.10337790E-01  +3.66370000E-04  -1.97893200E-02  -2.73265000E-02  +3.18731000E-03
   +2.06894000E-03  +1.17791000E-03  +4.56100000E-05  -8.85690000E-04  -3.71140000E-04
   -2.23000000E-05  +3.96420000E-04  +5.58170000E-04  +2.07560000E-04  +6.92450000E-04
   -1.78809000E-03  -4.86182000E-03  -7.44120000E-04  +8.45210000E-04  -1.89770000E-04
   -9.11500000E-05  +9.85000000E-06  +6.88400000E-05  +1.22400000E-05  +2.56400000E-05
   +7.47700000E-05  +1.02700000E-05  -2.54000000E-05  +8.80000000E-06  +7.97000000E-05
   +6.16100000E-05  +1.14500000E-05  -2.40000000E-05  +3.50700000E-05  +1.13500000E-05
   -2.68100000E-05  +1.39000000E-06  -1.63800000E-04  +6.45300000E-05  +3.92600000E-05
   +1.44000000E-05  +2.02620000E-04  -1.29480000E-04  +4.23300000E-05  +7.13000000E-06
   -1.66500000E-05  +1.70240000E-04  -1.25330000E-04  -1.46300000E-05  +1.05144600E-02
   +1.60059520E-01  +2.29779600E-02  -2.37859250E-01  -4.07625550E-01  +5.94910000E-04
   -1.85579000E-03  -6.29462000E-03  +2.64739000E-03  +4.66721000E-03  +3.46954000E-03
   +3.54200000E-05  -2.38520000E-04  -1.01594000E-03  +1.29880000E-04  +1.51910000E-04
   +3.50960000E-04  +5.93300000E-04  -7.76040000E-04  -9.64200000E-05  -2.70360000E-04
   +2.20000000E-06  +2.36049000E-03  -1.61580000E-04  -3.91600000E-05  -1.59310000E-04
   +1.32250000E-04  +6.14200000E-05  +7.20100000E-05  +3.37000000E-05  +3.07000000E-06
   -2.24600000E-05  +1.91000000E-05  +5.67500000E-05  +1.95700000E-05  -2.18000000E-06
   -3.89000000E-06  +2.84000000E-06  +2.10900000E-05  -1.56600000E-05  -8.01000000E-06
   -6.48400000E-05  +3.00000000E-05  +1.41700000E-05  +4.84000000E-06  +3.31700000E-05
   -2.08500000E-05  +9.37000000E-06  -8.46000000E-06  +9.72000000E-06  +7.85800000E-05
   -4.72600000E-05  -1.54200000E-05  -2.63967400E-02  +2.36134490E-01  +4.09377260E-01
   +1.42452000E-03  +3.01866000E-03  -9.30850000E-04  +4.85167000E-03  +1.23803100E-02
   +1.80202300E-02  -5.42369500E-02  -1.62132000E-02  -2.87834000E-03  +3.19352000E-03
   -1.38415200E-02  -2.16744800E-02  -1.63055000E-03  -5.45082000E-03  +1.46190000E-03
   -1.56010000E-03  -3.48410000E-04  +1.57900000E-04  -1.71748000E-03  -1.99543000E-03
   +4.54963000E-03  +5.95370000E-04  -4.83560000E-04  -9.81520000E-04  +1.39000000E-06
   +8.87000000E-05  -9.45700000E-05  -3.57830000E-04  -1.59370000E-04  +8.83800000E-05
   +9.02700000E-05  -3.51700000E-05  -1.89900000E-05  +3.90000000E-06  +2.11100000E-05
   -1.57500000E-05  -1.69400000E-05  +3.01800000E-05  +1.10900000E-05  +5.95600000E-05
   -2.71900000E-05  -1.38800000E-05  -2.24400000E-05  -7.47400000E-05  +6.22600000E-05
   -1.97300000E-05  +2.24000000E-06  +2.91500000E-05  -7.66700000E-05  +6.76500000E-05
   +1.35500000E-05  -7.11030000E-04  -1.03601000E-03  -2.95850000E-04  +5.05220500E-02
   +2.70119000E-03  -1.81640000E-04  +2.72125000E-03  -3.47516000E-03  +2.32530000E-03
   +1.09841000E-03  -1.62984800E-02  -1.34922120E-01  -1.37396480E-01  +1.00776000E-03
   -7.72647000E-03  -1.69003200E-02  -5.61993000E-03  +2.57573000E-03  -1.51996000E-03
   -1.00440000E-04  -4.78350000E-04  +7.32510000E-04  -1.72314000E-03  +3.62290000E-03
   -8.98220000E-04  +2.04360000E-04  +4.56500000E-05  -9.27320000E-04  -5.89300000E-05
   -7.94000000E-06  -8.84000000E-06  -2.92700000E-04  -2.34860000E-04  +9.33200000E-05
   +1.93680000E-04  -9.93200000E-05  -3.65600000E-05  -4.14600000E-05  +1.90900000E-05
   +2.86000000E-05  -6.99000000E-06  -4.83000000E-06  +1.54100000E-05  +8.49100000E-05
   -9.84000000E-06  -3.66100000E-05  -3.29700000E-05  -4.22900000E-05  +3.32300000E-05
   +2.15500000E-05  +2.47000000E-05  +1.53100000E-05  -8.66800000E-05  +5.06500000E-05
   +1.56600000E-05  +4.18130000E-04  +2.59420000E-04  -9.20380000E-04  +2.09437900E-02
   +1.37273340E-01  -1.52112000E-03  +2.35490000E-03  +1.38239000E-03  -6.02027000E-03
   -1.57606600E-02  -1.36557700E-02  -3.17859000E-03  -1.37472150E-01  -2.39562610E-01
   +1.06497000E-03  -9.08200000E-04  +1.21670000E-04  +9.05390000E-04  -2.07078000E-03
   +3.43031000E-03  +4.16660000E-04  +9.54740000E-04  +1.41950000E-04  +5.02875000E-03
   -5.08270000E-04  -7.37750000E-04  +4.06940000E-04  -9.17100000E-05  -8.66200000E-05
   -5.22600000E-05  +1.45000000E-05  -5.83400000E-05  -1.14670000E-04  -7.08000000E-06
   +4.63200000E-05  -4.27600000E-05  -3.61200000E-05  -1.18100000E-05  +2.00400000E-05
   +1.53900000E-05  -5.53200000E-05  -1.50800000E-05  +3.55500000E-05  -2.57000000E-06
   +7.95000000E-05  -4.85000000E-05  -8.07000000E-06  -4.45000000E-06  -1.22060000E-04
   +8.70400000E-05  -3.95600000E-05  -1.77500000E-05  +1.64500000E-05  -9.48300000E-05
   +7.82100000E-05  +6.62000000E-06  +1.94106000E-03  +5.90240000E-04  -5.50080000E-04
   +3.09727000E-03  +1.51613410E-01  +2.51017050E-01  -1.29180000E-03  -2.54980000E-04
   +8.23440000E-04  +9.31000000E-05  -5.49664000E-03  -2.11370000E-04  -1.28778900E-02
   +3.36920000E-04  +1.82816000E-02  -1.97262870E-01  -1.17010000E-02  +1.44443750E-01
   +4.94587000E-03  -3.24360000E-04  -1.30273000E-03  +2.52364000E-03  -2.24928000E-03
   +4.80780000E-04  -2.69080000E-04  +4.95700000E-05  -9.23720000E-04  -9.68330000E-04
   +6.70190000E-04  -9.30820000E-04  -3.69900000E-05  -1.94640000E-04  +1.21990000E-04
   -2.92600000E-05  +1.51500000E-04  -5.01200000E-05  -5.85890000E-04  -4.96090000E-04
   -5.63660000E-04  +1.23200000E-04  +2.89600000E-05  +2.48400000E-05  -1.83800000E-04
   +1.23070000E-04  +1.42500000E-05  -2.93870000E-04  -3.52000000E-05  +1.92110000E-04
   +2.79090000E-04  +1.56860000E-04  -2.15260000E-04  -3.14140000E-04  -3.94200000E-05
   -3.06340000E-04  +1.86190000E-04  -1.12810000E-04  -2.47400000E-05  +1.01560000E-04
   +1.77280000E-04  +1.58790000E-04  -4.26460000E-04  +1.80287000E-03  -1.42780000E-03
   +2.05966420E-01  -9.46750000E-04  -2.38730000E-04  +7.75500000E-04  -5.30710000E-03
   +1.90117000E-03  -3.70040000E-03  -1.49910600E-02  +3.26726000E-03  +1.42872900E-02
   -1.12320700E-02  -4.97433100E-02  -3.68508000E-03  +1.36877700E-02  +5.71306000E-03
   -1.20992800E-02  -2.70681000E-03  +1.23141000E-03  -5.15437000E-03  +5.31600000E-05
   -1.09259000E-03  +7.17900000E-05  +1.48801000E-03  -1.38770000E-03  +1.05981000E-03
   -1.80250000E-04  -5.38860000E-04  -5.84990000E-04  +1.62010000E-04  -1.89200000E-05
   +1.09920000E-04  -3.22000000E-04  +4.51800000E-05  -2.22000000E-04  +8.00300000E-05
   -8.93600000E-05  -1.82100000E-05  -1.56850000E-04  +9.76800000E-05  -6.33000000E-06
   -2.05600000E-04  -8.39800000E-05  +1.76400000E-04  +3.36840000E-04  +7.43000000E-06
   -2.42310000E-04  -2.75480000E-04  +1.80860000E-04  -1.99190000E-04  +1.47830000E-04
   -1.20150000E-04  -9.50000000E-06  +8.34200000E-05  +1.05120000E-04  +1.26770000E-04
   +2.12375000E-03  -1.95341000E-03  +1.73815000E-03  +1.74559800E-02  +4.40541600E-02
   -6.50400000E-05  +1.00550000E-04  +1.72890000E-04  +1.72530000E-04  -3.31283000E-03
   +2.97896000E-03  -4.16711000E-03  -1.46229000E-03  +6.21204000E-03  +1.43842900E-01
   -3.00574000E-03  -1.91688270E-01  +1.95519200E-02  +1.94603000E-03  -1.28224800E-02
   +3.05100000E-04  -5.62610000E-03  -2.28405000E-03  -1.11444000E-03  -8.54200000E-05
   -2.01680000E-04  +3.52710000E-04  +1.87837000E-03  -7.26940000E-04  -8.06000000E-06
   -3.20300000E-05  -1.26950000E-04  -2.05930000E-04  +1.25100000E-05  +3.11000000E-06
   -3.64590000E-04  -3.99150000E-04  +1.47950000E-04  -3.67340000E-04  +1.49740000E-04
   +2.54180000E-04  -2.10000000E-07  -1.23040000E-04  +5.10700000E-05  -3.67890000E-04
   +1.06280000E-04  +2.54800000E-05  -9.70000000E-06  +3.07580000E-04  -1.60790000E-04
   +6.68200000E-05  +4.74410000E-04  -5.71500000E-05  +3.65940000E-04  -2.30930000E-04
   -2.06300000E-05  -1.95300000E-05  +8.00000000E-08  -1.27000000E-05  -1.12040000E-03
   +2.05326000E-03  -3.80040000E-04  -1.57909100E-01  +6.81837000E-03  +1.99010700E-01
   +4.44900000E-05  -7.17780000E-04  -1.13577000E-03  -1.27745000E-03  -5.39777000E-03
   +1.60394000E-03  -1.32147000E-03  -1.30270000E-04  +4.48300000E-05  -1.66231000E-03
   -2.47350000E-03  +5.10746000E-03  +6.72546000E-03  +1.28777100E-02  +1.73881700E-02
   -5.51390100E-02  -1.30367500E-02  -3.26171000E-03  +2.64483000E-03  -1.46730700E-02
   -2.10862500E-02  -2.25600000E-04  +1.85205000E-03  -1.02694000E-03  +3.75800000E-04
   +3.54600000E-05  -1.04560000E-04  -2.10921000E-03  -1.50029000E-03  +5.85700000E-04
   -2.16030000E-04  -1.19820000E-04  -1.24160000E-04  -2.08500000E-05  -1.49000000E-06
   -5.03600000E-05  +2.56300000E-05  -6.17000000E-06  +1.79500000E-05  -7.77300000E-05
   +2.90500000E-05  +2.83300000E-05  -2.45000000E-06  +8.72800000E-05  -7.68100000E-05
   -5.55000000E-06  -1.11590000E-04  +1.52600000E-05  +9.41100000E-05  -5.85000000E-05
   -1.43200000E-05  -3.20340000E-04  -1.76860000E-04  -1.26930000E-04  -1.28230000E-04
   +2.94240000E-04  -1.98730000E-04  +1.91020000E-04  +7.48140000E-04  +1.02578000E-03
   +5.47346200E-02  -1.07580000E-04  -6.29010000E-04  -9.64830000E-04  -5.44041000E-03
   +3.01411000E-03  -1.81592000E-03  -4.48800000E-05  -5.65540000E-04  +8.64900000E-04
   -2.41253000E-03  +4.13323000E-03  -1.41951000E-03  +7.52700000E-05  +4.98345000E-03
   +7.50020000E-04  -1.27993100E-02  -1.37430950E-01  -1.38049720E-01  +8.15200000E-05
   -6.99222000E-03  -1.68917300E-02  +1.27631000E-03  -2.40611000E-03  +9.61860000E-04
   -5.03830000E-04  -2.59650000E-04  +1.41600000E-05  -2.66270000E-03  -7.79890000E-04
   +2.11280000E-04  +3.13260000E-04  +4.19870000E-04  -1.86430000E-04  +6.52800000E-05
   -1.09630000E-04  +6.81700000E-05  +2.46200000E-05  -2.47600000E-05  -1.31400000E-05
   -6.12200000E-05  +5.36300000E-05  +4.93000000E-06  +2.93600000E-05  +1.86700000E-05
   -1.58000000E-05  +6.22000000E-05  +1.16810000E-04  -8.37100000E-05  +6.19800000E-05
   -6.20500000E-05  +5.98000000E-06  -1.18380000E-04  -2.52480000E-04  +3.22300000E-05
   +2.70000000E-04  -4.11610000E-04  +2.03410000E-04  -7.37600000E-05  +9.09700000E-05
   +1.89480000E-04  +2.14281900E-02  +1.41015090E-01  -1.65530000E-04  -2.89270000E-04
   -2.19330000E-04  +1.49452000E-03  -1.90220000E-03  +3.41233000E-03  +1.58160000E-04
   +9.50240000E-04  +2.04490000E-04  +5.16849000E-03  -1.19222000E-03  -6.53590000E-04
   -2.47616000E-03  -1.31204600E-02  -1.32269100E-02  -2.78416000E-03  -1.37860090E-01
   -2.49363700E-01  +1.57733000E-03  -1.19797000E-03  +4.59200000E-04  -2.09644000E-03
   +1.72440000E-04  -1.36871000E-03  +5.27190000E-04  +1.50950000E-04  +5.26000000E-05
   -1.02677000E-03  -1.10186000E-03  +3.33890000E-04  -1.50900000E-04  -8.24200000E-05
   +1.07960000E-04  -3.28900000E-05  +5.67700000E-05  +1.63900000E-05  +1.62000000E-06
   +5.27000000E-06  +4.10000000E-07  +2.98100000E-05  -1.16200000E-05  -1.97700000E-05
   -3.54600000E-05  -1.54900000E-05  +2.81000000E-05  +2.71900000E-05  -3.07000000E-06
   +6.66900000E-05  -3.52100000E-05  +3.36400000E-05  +4.72000000E-06  -4.42500000E-05
   +8.80900000E-05  -5.99000000E-06  -2.33030000E-04  +1.73840000E-04  -2.08800000E-04
   -1.99100000E-04  -6.73550000E-04  -8.10960000E-04  +3.02013000E-03  +1.53461160E-01
   +2.60742560E-01  -2.03750000E-04  +1.81771000E-03  -8.48370000E-04  +4.11764000E-03
   -2.09799000E-03  -1.94986000E-03  +2.22980000E-03  -2.14656000E-03  +4.27100000E-04
   -2.24420000E-04  +3.42600000E-05  -9.02800000E-04  -4.44900000E-04  -5.43511000E-03
   -2.49720000E-04  -1.22376400E-02  +1.06837000E-03  +1.73511600E-02  -1.98362490E-01
   -1.74686600E-02  +1.48383840E-01  -1.03880000E-04  +2.96540000E-04  +8.94800000E-04
   -2.19050000E-04  -9.84700000E-05  -9.43900000E-05  -3.28700000E-05  +8.28500000E-05
   +6.23200000E-05  +2.47600000E-05  -1.97370000E-04  +2.75000000E-06  -5.89000000E-05
   +5.95300000E-05  -7.08000000E-06  -4.88000000E-06  +2.10000000E-06  +1.19600000E-05
   +8.37500000E-05  -1.75000000E-05  -2.75800000E-05  -3.37400000E-05  -8.65500000E-05
   +7.02600000E-05  -2.93900000E-05  -1.16100000E-05  +2.39800000E-05  -7.92600000E-05
   +5.78400000E-05  +2.70000000E-07  -1.30840000E-04  +2.39240000E-04  -1.03610000E-04
   +1.99770000E-04  +3.26200000E-05  -2.26770000E-04  -2.05440000E-04  +2.84770000E-04
   -9.88200000E-05  -4.85510000E-04  +1.81828000E-03  -1.43647000E-03  +2.06199770E-01
   +1.66008000E-03  -9.78680000E-04  +2.29782000E-03  +1.32642300E-02  +6.08878000E-03
   -1.30503500E-02  -2.42468000E-03  +9.23930000E-04  -4.76411000E-03  -1.04830000E-04
   -1.27760000E-03  -1.67920000E-04  -5.12359000E-03  +1.47328000E-03  -3.05586000E-03
   -1.34237600E-02  +2.71852000E-03  +1.49355100E-02  -1.82456100E-02  -4.73446700E-02
   +5.25020000E-04  -4.63270000E-04  +4.55080000E-04  +5.02020000E-04  -7.44300000E-05
   +5.54900000E-05  -5.12800000E-05  +6.16400000E-05  +2.51800000E-05  +8.41500000E-05
   -2.38140000E-04  -2.59440000E-04  -8.73000000E-06  -1.99200000E-05  +1.97400000E-05
   -4.30300000E-05  -3.01000000E-05  +3.12900000E-05  +2.18500000E-05  +2.99400000E-05
   -3.46500000E-05  +3.73000000E-06  +4.47000000E-06  -1.06000000E-06  +1.31800000E-05
   -8.80000000E-07  +1.97000000E-06  -6.62000000E-06  -5.13500000E-05  +3.16200000E-05
   +4.35000000E-06  +1.94750000E-04  -1.50600000E-04  +4.27920000E-04  +7.33350000E-04
   +3.28300000E-05  -6.38580000E-04  +2.54430000E-04  -3.26460000E-04  +2.98850000E-04
   +2.12942000E-03  -1.89231000E-03  +1.68275000E-03  +2.18553900E-02  +4.04123200E-02
   -1.09825000E-03  +2.12025000E-03  +8.41300000E-04  +2.18606600E-02  +3.57412000E-03
   -1.26434200E-02  -2.00800000E-05  -5.12744000E-03  -2.18452000E-03  -1.24720000E-03
   -3.94730000E-04  -3.84200000E-04  -2.57000000E-06  -2.76762000E-03  +2.86694000E-03
   -4.81153000E-03  -5.80500000E-04  +6.66044000E-03  +1.47056410E-01  -4.02610000E-04
   -1.93820830E-01  -1.60660000E-04  -1.42150000E-04  +2.85640000E-04  -2.17100000E-05
   -6.54700000E-05  -1.61500000E-05  +1.80200000E-05  +6.04200000E-05  -2.25500000E-05
   +7.55900000E-05  +2.34900000E-05  +1.07100000E-05  -5.51000000E-06  +6.73000000E-06
   +2.13500000E-05  +9.96000000E-06  -1.21000000E-05  +4.30000000E-07  -2.45900000E-05
   +1.88500000E-05  +1.07000000E-06  -7.90000000E-06  +1.80200000E-05  -1.20600000E-05
   +3.72000000E-06  +2.39000000E-06  -1.21000000E-06  +3.29200000E-05  -1.87500000E-05
   -3.04000000E-06  -1.81960000E-04  +3.71130000E-04  +2.02460000E-04  +8.81020000E-04
   +1.11040000E-04  -8.22780000E-04  -1.09480000E-04  +2.78650000E-04  -1.61580000E-04
   -9.88810000E-04  +2.00110000E-03  -3.00420000E-04  -1.61257530E-01  +9.94820000E-04
   +1.99514260E-01  +7.51000000E-05  +3.13000000E-05  +2.86400000E-05  -7.55000000E-06
   -4.22400000E-05  -1.37590000E-04  -1.64710000E-04  -1.02000000E-05  -2.64900000E-05
   +2.49290000E-04  +2.05790000E-04  +1.68930000E-04  +7.86770000E-04  -9.24910000E-04
   -2.71910000E-04  +1.64440000E-04  +1.77000000E-04  +1.44230000E-04  +9.50700000E-05
   +9.59000000E-05  -1.85500000E-05  -2.83371000E-03  +4.70800000E-05  +1.15997000E-03
   -2.41952120E-01  +1.15806430E-01  +3.26559400E-02  -4.33700000E-05  -2.53920000E-04
   +3.82960000E-04  +7.24420000E-04  +4.95220000E-04  -4.39840000E-04  -8.87000000E-06
   -5.52500000E-05  +6.57900000E-05  +9.36500000E-05  +1.69900000E-04  -1.91620000E-04
   +1.86220000E-04  -7.87200000E-05  -3.09000000E-05  -1.88000000E-05  -1.24050000E-04
   +6.34400000E-05  +1.99600000E-05  -2.04700000E-04  +2.16810000E-04  -2.26700000E-04
   +1.97310000E-04  -1.25200000E-05  -1.13500000E-05  +2.80000000E-07  -7.11000000E-06
   -2.04000000E-06  +1.26100000E-05  +2.49000000E-06  +2.80800000E-05  -6.14000000E-05
   -1.85000000E-06  +2.30300000E-05  +2.07600000E-05  -2.09900000E-05  +2.03800000E-05
   +1.84700000E-05  +2.09000000E-06  +2.59783720E-01  +1.63010000E-04  +1.71940000E-04
   +2.69200000E-05  -2.02450000E-04  -1.23750000E-04  +1.25190000E-04  +1.35580000E-04
   +4.81500000E-05  -4.10100000E-05  -1.99650000E-04  -2.26000000E-04  -5.73310000E-04
   +1.21412000E-03  +8.65250000E-04  -3.11570000E-04  -2.82470000E-04  +1.40850000E-04
   +1.19700000E-05  -1.69810000E-04  -9.00000000E-05  +5.73200000E-05  +1.97237200E-02
   -1.32490100E-02  -3.80102000E-03  +1.13642480E-01  -1.14745300E-01  -1.98011200E-02
   -1.53880000E-04  +4.28790000E-04  -1.34869000E-03  -6.93140000E-04  -2.68285000E-03
   +3.79978000E-03  -1.62140000E-04  -4.14200000E-04  +3.49130000E-04  +1.38800000E-05
   +1.60950000E-04  -1.34160000E-04  -3.40880000E-04  -6.20000000E-07  +2.17120000E-04
   +8.84900000E-05  -1.64670000E-04  -4.85700000E-05  +1.46161000E-03  -8.88000000E-06
   -2.68790000E-04  +3.05110000E-04  -1.66010000E-04  -5.50300000E-05  -3.69000000E-06
   -3.36200000E-05  -1.31300000E-05  +1.12500000E-05  -8.71000000E-06  +1.10500000E-05
   +1.69700000E-05  +1.08350000E-04  +1.48370000E-04  +2.76000000E-05  -2.55400000E-05
   +7.04100000E-05  +3.23000000E-06  -1.20100000E-05  -1.94000000E-06  -1.27017710E-01
   +1.24492520E-01  -1.16900000E-04  -8.72800000E-05  -3.40000000E-06  +1.12520000E-04
   -6.83000000E-06  -1.89240000E-04  -3.54990000E-04  -2.36100000E-05  +1.09060000E-04
   +3.85170000E-04  +5.91000000E-06  -1.98390000E-04  -6.63280000E-04  -5.49780000E-04
   +4.79750000E-04  -9.45000000E-05  -1.68180000E-04  +1.56530000E-04  +1.09710000E-04
   +1.13920000E-04  +4.44000000E-06  -1.96276300E-02  +1.14860600E-02  +1.79898000E-03
   +3.44011400E-02  -2.11646100E-02  -5.32310300E-02  -1.19210000E-03  +6.19570000E-04
   +1.30449000E-03  +4.19360000E-04  +3.03171000E-03  -3.16180000E-03  +4.62110000E-04
   +1.61300000E-04  -8.85200000E-05  -2.41930000E-04  -3.18300000E-05  +8.87800000E-05
   +2.51000000E-05  -7.03700000E-05  +3.34700000E-05  +2.03900000E-04  +2.76530000E-04
   -1.77170000E-04  -1.29958000E-03  +6.70100000E-04  +5.24000000E-04  -6.36500000E-05
   +9.46000000E-06  +2.85400000E-05  +1.38400000E-05  +3.28000000E-06  +1.39700000E-05
   +1.67100000E-05  -1.59800000E-05  +1.50000000E-07  +2.91600000E-05  +2.95100000E-05
   +1.02180000E-04  +2.66800000E-05  +1.03900000E-05  -6.61800000E-05  +1.20000000E-07
   +3.85000000E-06  +1.02800000E-05  -3.63429600E-02  +1.86541600E-02  +5.64340100E-02
   -2.48190000E-04  -2.09470000E-04  -3.59400000E-05  +2.51880000E-04  +1.81360000E-04
   -1.92600000E-05  -1.87020000E-04  -3.16300000E-05  +7.09500000E-05  +2.42500000E-04
   +2.49830000E-04  +4.69970000E-04  +4.92510000E-04  -4.98600000E-04  -1.00980000E-04
   +5.93460000E-04  +1.27900000E-05  -1.93080000E-04  -5.60000000E-06  -8.20500000E-05
   -8.74000000E-05  +1.60025000E-03  +2.76272000E-03  -3.23220000E-04  -2.05642870E-01
   -1.29930830E-01  -1.28470200E-02  +1.93930000E-04  +3.84760000E-04  -1.65800000E-04
   +1.73230000E-04  +4.44650000E-04  +9.24700000E-05  -4.98300000E-05  +3.67600000E-05
   +4.96000000E-06  -7.80000000E-06  +1.03090000E-04  -1.91510000E-04  -1.15260000E-04
   -1.70100000E-05  +1.07640000E-04  +1.98900000E-05  +1.97400000E-05  -3.33200000E-05
   +3.31350000E-04  -1.12110000E-04  +1.42520000E-04  +7.43300000E-05  -9.29000000E-06
   -2.10700000E-05  +1.95400000E-05  +3.67300000E-05  +2.09700000E-05  -2.51500000E-05
   -6.58000000E-06  -1.92200000E-05  -1.59400000E-05  -6.32000000E-06  -2.38600000E-05
   -5.12900000E-05  +5.20300000E-05  +1.48600000E-05  -9.96000000E-06  -1.48000000E-06
   +3.98000000E-06  -1.87491200E-02  -1.76652300E-02  -2.42762000E-03  +2.20625490E-01
   -5.16630000E-04  -4.36780000E-04  -1.44840000E-04  +2.17550000E-04  +4.17640000E-04
   +5.06820000E-04  +1.57800000E-04  +1.64800000E-04  +4.20400000E-05  -3.32250000E-04
   -1.56220000E-04  +2.59030000E-04  +7.60400000E-04  -2.35223000E-03  +4.00617000E-03
   +3.04390000E-04  -5.12160000E-04  -4.38910000E-04  -6.30810000E-04  -2.44040000E-04
   -3.89090000E-04  -1.82704800E-02  -1.52841600E-02  -1.98023000E-03  -1.28947540E-01
   -1.52946000E-01  -1.06133300E-02  -2.00620000E-04  +6.20390000E-04  -1.43671000E-03
   -1.04508000E-03  +1.07380000E-03  -6.37200000E-04  +6.82410000E-04  -1.00368000E-03
   +3.94930000E-04  +2.39040000E-04  +2.14410000E-04  -2.40960000E-04  +1.81350000E-04
   -2.65500000E-05  -9.19000000E-05  -1.36160000E-04  -1.59710000E-04  +1.74980000E-04
   +3.34560000E-04  -6.10600000E-05  +4.64700000E-05  -1.64530000E-04  +1.89650000E-04
   -3.41800000E-05  +2.91000000E-05  +4.22900000E-05  +5.19700000E-05  -2.60900000E-05
   -5.03700000E-05  -3.44100000E-05  -2.84100000E-05  +1.60690000E-04  -6.59200000E-05
   +5.85900000E-05  -7.40000000E-05  +1.49290000E-04  -1.06030000E-04  -7.51000000E-06
   -3.35900000E-05  +1.31680000E-02  +1.18156600E-02  +1.46358000E-03  +1.42977650E-01
   +1.65637710E-01  +3.14890000E-04  +3.07720000E-04  +4.08500000E-05  -3.36310000E-04
   -5.29000000E-05  +2.24450000E-04  +6.10350000E-04  -1.10400000E-05  +4.60400000E-05
   -1.60000000E-06  -3.59840000E-04  -6.39000000E-05  -1.35395000E-03  +2.34983000E-03
   -2.77858000E-03  +5.98590000E-04  +5.42010000E-04  +1.53330000E-04  +8.57600000E-05
   -3.06990000E-04  +1.36350000E-04  +1.79340600E-02  +1.50796000E-02  -3.64700000E-04
   -1.38447600E-02  -1.16522500E-02  -4.87552300E-02  +1.15419000E-03  +6.41150000E-04
   +1.09757000E-03  +3.71640000E-04  -7.71540000E-04  +6.48770000E-04  -2.03170000E-04
   -4.47520000E-04  +2.48130000E-04  -1.95300000E-05  +2.13350000E-04  -1.19120000E-04
   -1.25990000E-04  -1.14440000E-04  +1.30270000E-04  +1.04770000E-04  -2.19100000E-05
   -4.05100000E-05  +8.28300000E-05  +2.95300000E-05  -2.24800000E-04  +3.85700000E-05
   +2.01900000E-05  -3.77800000E-05  +7.90000000E-07  -1.37100000E-05  -4.09300000E-05
   +2.98800000E-05  +1.71100000E-05  +1.68700000E-05  -2.83880000E-04  +3.94330000E-04
   +3.19100000E-05  -3.84500000E-05  +1.22260000E-04  -1.02400000E-04  +4.54100000E-05
   +3.88100000E-05  -1.01500000E-05  +3.78663000E-03  +3.41184000E-03  -6.84240000E-04
   +1.50163500E-02  +8.83402000E-03  +5.13642300E-02  +6.32000000E-05  +6.13300000E-05
   +6.44000000E-06  -3.16600000E-05  -1.08360000E-04  -1.01180000E-04  -2.38260000E-04
   -3.27200000E-05  -2.40000000E-05  -4.73800000E-05  -2.42980000E-04  -2.57600000E-05
   -4.76600000E-05  +4.49250000E-04  +6.88430000E-04  -1.41030000E-04  -8.37700000E-05
   +6.40900000E-05  +1.18130000E-04  +6.73000000E-05  +6.06500000E-05  -1.94914000E-03
   -1.35848000E-03  -2.49673000E-03  -4.69240000E-02  -1.73713000E-03  -3.70136000E-03
   -4.38700000E-05  +5.70740000E-04  -3.67730000E-04  +3.98940000E-04  -5.68950000E-04
   -7.25470000E-04  -3.09790000E-04  +5.03470000E-04  -2.06890000E-04  -1.16750000E-04
   -1.18140000E-04  +9.52600000E-05  -1.13560000E-04  +5.21000000E-05  +3.23500000E-05
   +8.68000000E-05  +7.79600000E-05  -1.04880000E-04  -1.04730000E-04  +7.16800000E-05
   +8.71500000E-05  +1.19270000E-04  -1.17310000E-04  +2.61200000E-05  -9.52000000E-06
   -2.46500000E-05  +3.08000000E-06  +2.58800000E-05  -1.41600000E-05  +1.64700000E-05
   +2.30010000E-04  -2.69350000E-04  +7.34500000E-05  +1.44200000E-05  +1.76500000E-05
   -5.18500000E-05  +0.00000000E+00  +1.00000000E-05  -7.70000000E-06  +1.27341000E-03
   +1.05542900E-02  +2.58096200E-02  +1.91360000E-04  -9.28645000E-03  -2.34600600E-02
   +4.64312800E-02  +1.59530000E-04  +1.10430000E-04  +2.51600000E-05  +4.67000000E-06
   -8.71400000E-05  -2.40160000E-04  -5.90400000E-05  -1.78210000E-04  -1.72180000E-04
   -4.42900000E-04  -4.22170000E-04  +7.43690000E-04  +5.02730000E-04  +1.15682000E-03
   +4.66900000E-05  -2.82450000E-04  -2.33500000E-05  -1.61300000E-05  +1.90150000E-04
   +1.59230000E-04  +1.62370000E-04  +2.57170000E-04  +8.74535000E-03  +2.20924800E-02
   -1.55108000E-03  -9.14778300E-02  -1.01601870E-01  +2.72970000E-04  -3.31208000E-03
   +2.91242000E-03  -6.11960000E-04  +1.29396000E-03  -1.76720000E-04  +3.67740000E-04
   +3.24500000E-05  -7.10300000E-05  +2.82800000E-05  -1.51640000E-04  +1.28700000E-05
   +1.48250000E-04  +1.02430000E-04  -1.05040000E-04  -1.67050000E-04  +1.54800000E-05
   +7.09800000E-05  -1.36220000E-04  -1.59810000E-04  -1.05900000E-05  -8.17200000E-05
   +2.56200000E-05  +2.42300000E-05  -2.18300000E-05  -1.49700000E-05  -1.63900000E-05
   +8.30000000E-07  -6.87000000E-06  +2.69500000E-05  -1.17320000E-04  -1.33689000E-03
   +6.44700000E-05  +5.21700000E-05  -7.29000000E-06  -1.57700000E-05  +1.44000000E-05
   -5.86000000E-06  +3.51000000E-06  -1.69786000E-03  -6.71123000E-03  -1.40980900E-02
   +1.19902000E-03  -8.02771000E-03  -1.79805500E-02  +1.81837000E-03  +9.95087800E-02
   -6.46900000E-05  -2.20900000E-05  -2.29900000E-05  -2.31480000E-04  +2.55740000E-04
   +5.15860000E-04  +5.82410000E-04  +2.90780000E-04  +2.36410000E-04  +1.11700000E-04
   -7.60050000E-04  -1.04300000E-04  -1.29232000E-03  -1.01347000E-03  +6.45500000E-04
   +8.13760000E-04  +1.95440000E-04  -2.89410000E-04  -4.31460000E-04  -4.00330000E-04
   -1.72950000E-04  -3.60900000E-05  -9.78766000E-03  -2.01684800E-02  -3.38344000E-03
   -9.85787700E-02  -2.73001320E-01  -3.70060000E-04  +4.82053000E-03  -2.60757000E-03
   +8.90460000E-04  -1.09991000E-03  +7.93610000E-04  +7.58000000E-06  +1.17960000E-04
   +1.33900000E-04  -3.28050000E-04  +1.02940000E-04  +1.48000000E-06  -1.17010000E-04
   -1.62610000E-04  +1.77600000E-04  +2.45950000E-04  +1.42600000E-05  -1.48690000E-04
   -9.76700000E-05  +5.36780000E-04  +1.98120000E-04  +1.62400000E-05  -5.72000000E-06
   +8.73000000E-06  +2.35300000E-05  +1.62000000E-05  -5.90000000E-07  +3.92800000E-05
   -1.88000000E-06  -1.29000000E-06  -2.75670000E-04  +3.64560000E-04  +3.42730000E-04
   -1.28440000E-04  -1.44600000E-05  +9.80500000E-05  -7.76000000E-06  +1.92400000E-05
   -1.71600000E-05  -4.15060000E-04  -9.27000000E-04  -2.83810000E-03  +1.57270000E-04
   +5.16500000E-05  -5.50710000E-04  +4.43406000E-03  +1.06696970E-01  +2.97595630E-01
   +9.65100000E-05  +1.09580000E-04  +5.84300000E-05  -6.89500000E-05  -2.72500000E-05
   +1.56400000E-05  +1.02490000E-04  +9.41100000E-05  +3.95300000E-05  -8.06200000E-05
   -7.48400000E-05  -3.09400000E-05  +2.62940000E-04  +5.09880000E-04  -2.80790000E-04
   +4.20300000E-05  -2.71690000E-04  -7.10640000E-04  -1.00500000E-04  +1.81000000E-06
   +2.75490000E-04  -1.94367000E-03  +1.25259000E-03  -9.56220000E-04  -1.71000000E-05
   -3.06830000E-04  -3.76960000E-04  -4.80434300E-02  +1.09081200E-02  -1.11523300E-02
   +7.83900000E-05  -7.79470000E-04  +4.71410000E-04  -1.30680000E-04  +3.36800000E-05
   +7.43600000E-05  +9.79000000E-05  -6.59100000E-05  +1.82200000E-05  -2.41000000E-05
   +1.02880000E-04  -2.68200000E-05  -2.37030000E-04  +6.91700000E-05  -2.70000000E-06
   -2.53600000E-05  +1.80260000E-04  -7.01600000E-05  +6.36000000E-05  -4.30400000E-05
   -1.59800000E-05  -8.34000000E-06  -8.56000000E-06  -6.49000000E-06  +9.39000000E-06
   +1.09400000E-05  +1.40500000E-05  -1.78300000E-05  +4.16000000E-05  +6.06600000E-05
   -1.42788000E-03  +9.85500000E-05  -2.84430000E-04  -1.35300000E-05  +3.04000000E-06
   -2.31500000E-05  +2.93570000E-04  -3.10890000E-04  +2.34470000E-04  +1.66620000E-04
   +3.12240000E-04  -1.59310000E-04  +6.58210000E-04  +1.20750000E-04  -1.36230000E-04
   +4.85223600E-02  +8.04100000E-05  +4.19900000E-05  -2.43100000E-05  -9.92600000E-05
   -6.56900000E-05  +1.31760000E-04  +8.76400000E-05  +4.25600000E-05  -3.44400000E-05
   +2.50300000E-04  +3.33500000E-05  +9.32000000E-06  -1.18140000E-04  +6.37280000E-04
   +3.81100000E-04  -7.11020000E-04  +2.89690000E-04  +2.05870000E-04  +3.18900000E-05
   -8.58600000E-05  -2.07640000E-04  -4.75810000E-04  +9.87998000E-03  -1.13866200E-02
   -1.23550000E-04  -7.78510000E-04  -2.26611000E-03  +1.13264000E-02  -1.70723260E-01
   +1.33670360E-01  -2.87530000E-04  +8.46040000E-04  -6.56500000E-05  +5.15000000E-05
   +9.20000000E-07  +8.92800000E-05  -3.46700000E-05  +6.88400000E-05  -8.72300000E-05
   +5.64000000E-05  -4.22400000E-05  +3.95400000E-05  -7.60000000E-05  -1.22710000E-04
   +8.91400000E-05  +1.92320000E-04  -4.40600000E-05  -4.76330000E-04  -1.45240000E-04
   +8.69900000E-05  -3.51000000E-06  -8.79000000E-06  -1.41200000E-05  -5.73000000E-06
   +1.72500000E-05  +1.69900000E-05  +1.71000000E-06  +1.72000000E-06  +1.10700000E-05
   -3.27500000E-05  -3.10180000E-04  -2.76720000E-04  -3.28920000E-04  -8.34000000E-06
   +4.06100000E-05  -1.26500000E-05  -2.36460000E-04  +2.79600000E-05  -1.73500000E-04
   +2.18630000E-04  +7.87700000E-05  -2.17980000E-04  -7.98300000E-05  +7.71800000E-04
   -5.60590000E-04  -1.13313600E-02  +1.83490750E-01  +2.18800000E-05  +1.74200000E-05
   +1.43600000E-05  -1.36330000E-04  +1.19950000E-04  +2.36550000E-04  +2.52970000E-04
   +2.08100000E-04  +2.17000000E-06  +1.00500000E-05  -5.30060000E-04  -1.58270000E-04
   +9.66400000E-04  +9.60180000E-04  +1.18099000E-03  +2.24900000E-04  -2.05860000E-04
   +3.41300000E-05  -2.77280000E-04  -2.40430000E-04  +1.43960000E-04  -1.25674000E-03
   +2.05142500E-02  -2.04134200E-02  -4.88500000E-05  -4.38067000E-03  -5.23406000E-03
   -1.08010100E-02  +1.31664990E-01  -1.90413960E-01  -1.36207000E-03  +8.29670000E-04
   +7.80190000E-04  +6.65800000E-04  +2.95800000E-05  -1.47240000E-04  -4.47200000E-04
   +3.19060000E-04  -2.11300000E-05  -2.03350000E-04  -3.63730000E-04  +3.10500000E-04
   +7.43630000E-04  -3.53170000E-04  +4.49400000E-05  -6.86000000E-06  +4.07600000E-04
   +1.49660000E-04  -4.66400000E-05  -4.88000000E-06  +2.80000000E-06  -9.81000000E-06
   +5.86000000E-06  -9.34000000E-06  -2.31700000E-05  +3.24300000E-05  -2.45600000E-05
   -3.48200000E-05  +1.00030000E-04  +5.16000000E-05  -5.09720000E-04  +1.75420000E-04
   +1.82220000E-04  -2.16300000E-05  -1.84200000E-05  -1.38400000E-05  -6.44300000E-05
   -9.79200000E-05  +2.32990000E-04  +9.66400000E-05  -1.55950000E-04  +3.30120000E-04
   -2.52770000E-04  +1.39537000E-03  -1.49597000E-03  +1.23430400E-02  -1.43863520E-01
   +2.08995980E-01  -1.59750000E-04  -1.57320000E-04  -6.98100000E-05  +9.44700000E-05
   +9.34700000E-05  +3.90000000E-07  -7.72100000E-05  -5.41000000E-05  -1.06090000E-04
   +7.78100000E-05  +4.07200000E-05  +2.82440000E-04  +6.87210000E-04  +9.65400000E-05
   +1.02950000E-04  -1.48270000E-04  +9.59000000E-06  +4.49390000E-04  +1.65750000E-04
   -1.09190000E-04  -2.50640000E-04  -1.90975000E-03  -2.05600000E-05  +8.20340000E-04
   -1.12840000E-04  +1.15160000E-04  +3.97290000E-04  -2.29059360E-01  -1.27713310E-01
   -7.74409000E-03  +8.35910000E-04  +1.29780000E-03  +3.23020000E-04  +1.42500000E-04
   -5.74800000E-05  +9.23300000E-05  +1.51130000E-04  -1.16060000E-04  -3.28400000E-05
   +2.51800000E-05  +1.17650000E-04  -1.28530000E-04  -2.51150000E-04  +2.16600000E-05
   +1.05200000E-05  +2.90560000E-04  -2.59200000E-04  +7.68900000E-05  +4.62200000E-05
   -2.36500000E-05  +1.66700000E-05  +1.44200000E-05  +1.97100000E-05  +1.17000000E-05
   -3.50000000E-05  -1.71000000E-06  -2.49600000E-05  +7.70100000E-05  -4.19000000E-05
   -6.11700000E-05  +1.41750000E-04  +4.59000000E-06  -5.24840000E-04  -3.92000000E-06
   -1.01800000E-05  +1.85800000E-05  -2.88100000E-05  -1.25020000E-04  +1.11400000E-05
   +2.89780000E-04  +2.92770000E-04  -4.62400000E-04  +2.56860000E-04  +2.49100000E-04
   +2.72400000E-05  +2.38464000E-03  +2.53629000E-03  +2.17190000E-04  +2.45425190E-01
   -2.30360000E-04  -1.81980000E-04  -1.78200000E-05  +2.59490000E-04  +1.06780000E-04
   -7.45200000E-05  -5.45600000E-05  -2.72990000E-04  -1.47790000E-04  -9.39160000E-04
   -1.02000000E-04  +1.89980000E-04  +7.86790000E-04  -3.70540000E-04  -3.01874000E-03
   +3.06390000E-04  +2.60010000E-04  -3.57290000E-04  -5.68900000E-05  +1.25500000E-04
   +1.94200000E-05  -1.18782100E-02  -1.04077600E-02  -7.48110000E-04  +4.97150000E-04
   +3.52870000E-04  +1.05770000E-03  -1.26157260E-01  -1.35585810E-01  -4.20191000E-03
   -1.04180000E-03  +3.75540000E-04  +2.24300000E-04  +2.44940000E-04  +1.80370000E-04
   +3.37400000E-05  +2.19590000E-04  -8.92900000E-05  -5.12600000E-05  +2.61840000E-04
   -4.32000000E-06  -1.70630000E-04  -1.95580000E-04  -1.41460000E-04  +1.29880000E-04
   +2.28210000E-04  -4.19490000E-04  +4.51160000E-04  -1.89150000E-04  +1.49930000E-04
   +2.57600000E-05  +2.96400000E-05  +2.87000000E-05  +2.02500000E-05  -5.39300000E-05
   -1.08360000E-04  +1.11000000E-06  +7.91000000E-06  +3.87900000E-05  -7.56100000E-05
   +1.95190000E-04  -2.14770000E-04  +1.90640000E-04  -3.97400000E-05  -1.05000000E-06
   -6.34000000E-06  +1.10910000E-04  +3.97600000E-05  -3.49100000E-05  +5.41600000E-05
   +5.55140000E-04  +3.13400000E-05  +2.34390000E-04  -2.56200000E-05  +2.62100000E-05
   -1.76010600E-02  -1.20400200E-02  -1.59108000E-03  +1.38927590E-01  +1.45390420E-01
   -1.59620000E-04  -9.31000000E-05  +2.43200000E-05  +1.41050000E-04  +1.55690000E-04
   +9.30000000E-06  +1.15090000E-04  -2.17430000E-04  -3.38540000E-04  -1.59548000E-03
   -1.07740000E-03  +2.56150000E-04  +1.27533000E-03  -1.72564000E-03  -5.35647000E-03
   +9.82870000E-04  -8.32100000E-05  -6.88290000E-04  -2.13570000E-04  -4.83000000E-05
   +2.61300000E-04  -2.43524000E-02  -1.76290000E-02  -2.97358000E-03  -1.00423000E-03
   -9.82070000E-04  +1.34541000E-03  -5.65005000E-03  -2.84430000E-03  -4.63276600E-02
   -1.14360000E-03  +2.35840000E-04  +6.01290000E-04  -5.63200000E-05  +1.44480000E-04
   +2.80940000E-04  +2.45280000E-04  -1.54420000E-04  -1.03450000E-04  +2.89330000E-04
   +1.22110000E-04  -2.57850000E-04  -4.58900000E-04  -1.98680000E-04  +2.49390000E-04
   +4.31650000E-04  -1.02040000E-04  +3.25000000E-06  -2.38240000E-04  +1.59940000E-04
   +2.43100000E-05  +2.33900000E-05  +2.55200000E-05  +1.09700000E-05  -1.32240000E-04
   -9.34000000E-05  -3.83900000E-05  +1.62000000E-06  +3.33600000E-05  -2.75000000E-06
   -5.52800000E-05  +4.60460000E-04  +4.20820000E-04  -2.71400000E-05  -3.79500000E-05
   +2.28000000E-06  +6.10300000E-05  +6.94400000E-05  -6.31300000E-05  +3.01560000E-04
   +5.09890000E-04  -6.70800000E-04  +3.20610000E-04  +8.60800000E-05  +2.89360000E-04
   +2.03021300E-02  +1.26573400E-02  +1.21154000E-03  +7.27768000E-03  +7.46439000E-03
   +5.26524900E-02  +8.10900000E-05  +4.24100000E-05  -2.29100000E-05  -1.59370000E-04
   -2.30600000E-05  +4.63000000E-06  +2.89500000E-05  +4.69000000E-06  -1.05000000E-06
   +1.32140000E-04  +1.45950000E-04  +2.88200000E-05  -4.72700000E-05  -1.13560000E-04
   +2.44380000E-04  -5.92710000E-04  -9.28020000E-04  +4.55190000E-04  +1.42980000E-04
   -9.60600000E-05  -2.35800000E-04  +1.07433000E-03  -1.57587000E-03  -7.09340000E-04
   +3.10280000E-04  -2.73600000E-04  -3.19230000E-04  -2.17607270E-01  +1.23977490E-01
   +3.09637200E-02  +5.28320000E-04  +5.25300000E-04  +4.47300000E-04  +3.86710000E-04
   +2.53310000E-04  +5.10000000E-06  +3.17700000E-05  -1.14900000E-05  -7.34000000E-05
   +3.68790000E-04  -7.08300000E-05  -1.72050000E-04  -2.89020000E-04  -1.91810000E-04
   +2.14720000E-04  +2.96070000E-04  -4.25680000E-04  +4.00960000E-04  -3.31820000E-04
   +2.20200000E-04  +3.67000000E-05  -1.83800000E-05  -8.37000000E-06  -8.94000000E-06
   +1.20300000E-05  +2.20400000E-05  +8.40000000E-07  -8.40000000E-06  -4.51000000E-06
   -1.55700000E-05  -6.00450000E-04  -1.52439000E-03  -3.99410000E-04  +3.29500000E-05
   -1.06400000E-05  +2.34400000E-05  +2.86820000E-04  -1.77630000E-04  +3.07820000E-04
   -1.45680000E-04  +1.17580000E-04  +5.79700000E-05  +1.93150000E-04  -2.33020000E-04
   +2.13500000E-05  -8.22290000E-04  -8.37400000E-04  +6.30000000E-05  -1.93519000E-02
   +1.61456700E-02  +3.28195000E-03  +2.36110960E-01  +9.41200000E-05  +1.32570000E-04
   +8.85800000E-05  -3.09400000E-05  -4.33600000E-05  +4.67900000E-05  +1.36820000E-04
   +1.47710000E-04  +7.87000000E-05  -2.65760000E-04  -9.43900000E-05  -1.29750000E-04
   +5.98550000E-04  +4.63440000E-04  +2.70470000E-04  +2.41480000E-04  -3.42980000E-04
   -9.77530000E-04  -3.04120000E-04  +1.55570000E-04  +4.32270000E-04  +1.17726600E-02
   -8.73579000E-03  -1.01949000E-03  -2.65270000E-04  +4.03690000E-04  +1.23577000E-03
   +1.22785370E-01  -1.36592390E-01  -2.23288800E-02  -2.03130000E-04  -4.69430000E-04
   -3.02518000E-03  -5.08660000E-04  -3.31280000E-04  +9.72100000E-05  +5.87000000E-04
   -3.60200000E-04  +1.73580000E-04  -1.82910000E-04  +4.69740000E-04  -2.71240000E-04
   -3.50140000E-04  +2.91410000E-04  -4.14200000E-05  +3.76160000E-04  -6.28000000E-06
   -2.74730000E-04  +4.12580000E-04  -2.87620000E-04  +1.20900000E-05  -3.08000000E-06
   -1.32700000E-05  -3.69000000E-06  +1.05600000E-05  -2.55000000E-06  +2.05800000E-05
   +1.91700000E-05  +4.34300000E-05  +1.29290000E-04  -1.14534000E-03  -1.29075000E-03
   +6.16140000E-04  -1.32500000E-05  -2.97300000E-05  -2.05300000E-05  -1.50850000E-04
   +5.71330000E-04  -9.85700000E-05  -1.43580000E-04  -2.83900000E-05  -8.01200000E-05
   -2.43200000E-04  -3.64300000E-05  +4.35100000E-05  +1.68249600E-02  -1.18430600E-02
   -4.36088000E-03  -1.51341100E-02  +1.21166500E-02  +3.01534000E-03  -1.35063380E-01
   +1.45661340E-01  +6.91000000E-05  +5.60600000E-05  -8.07000000E-06  -1.32750000E-04
   -1.08500000E-05  +1.88690000E-04  +1.65020000E-04  +1.21640000E-04  -4.76000000E-06
   -9.62100000E-05  +3.87700000E-05  -2.73780000E-04  +3.02430000E-04  +6.23850000E-04
   +7.53190000E-04  -2.75860000E-04  +2.04580000E-04  +3.59310000E-04  -1.63670000E-04
   -1.09700000E-04  -7.85100000E-05  +2.40440200E-02  -1.60825400E-02  -5.09999000E-03
   +1.20372000E-03  -8.48670000E-04  +1.41111000E-03  +3.05037300E-02  -2.13541000E-02
   -5.35229200E-02  -8.34010000E-04  -2.08183000E-03  -4.79846000E-03  +2.46120000E-04
   -5.59480000E-04  -3.19300000E-05  +1.46820000E-04  +5.19200000E-05  +2.42430000E-04
   -5.78420000E-04  +5.70900000E-05  +1.96640000E-04  +8.04620000E-04  +2.03920000E-04
   -1.35920000E-04  -3.44900000E-05  +4.40060000E-04  +1.46230000E-04  +6.33930000E-04
   -4.38710000E-04  -3.82100000E-05  -6.11000000E-06  -1.82700000E-05  -5.61000000E-06
   +2.50900000E-05  -1.32500000E-05  +1.23300000E-05  +4.62500000E-05  -9.68000000E-06
   +5.60600000E-05  -2.61500000E-05  -4.85900000E-05  +2.86840000E-04  +5.12000000E-06
   -8.53000000E-06  +3.57000000E-06  -6.05530000E-04  +3.92280000E-04  -6.29640000E-04
   +1.74800000E-05  +9.59400000E-05  -7.83100000E-05  -2.77440000E-04  +1.06260000E-04
   +3.81340000E-04  -1.98204700E-02  +1.26834600E-02  +4.21348000E-03  -7.52660000E-04
   +7.95120000E-04  -7.64640000E-04  -3.44987200E-02  +2.61343600E-02  +5.73467000E-02
   -5.08600000E-05  -4.28100000E-05  -1.32500000E-05  +4.15200000E-05  +2.98800000E-05
   +1.13000000E-06  -2.83300000E-05  -1.76700000E-05  +6.11000000E-06  -1.64700000E-05
   -3.26000000E-06  +2.64700000E-05  -2.85900000E-05  +1.90490000E-04  +6.60000000E-05
   -4.35100000E-05  -5.26600000E-05  -3.72400000E-05  -3.21000000E-06  -1.76400000E-05
   +5.42000000E-06  +6.92400000E-05  -6.93230000E-04  +4.38480000E-04  +4.61000000E-06
   -3.51600000E-05  +4.33300000E-05  -1.55810000E-04  +7.44900000E-05  -5.63800000E-05
   -2.63110000E-03  +2.84130000E-03  +1.69530000E-03  -1.65569000E-02  -8.56154000E-03
   +1.31684100E-02  -1.94596880E-01  -7.43827100E-02  +1.29449420E-01  +6.81340000E-03
   +3.73966000E-03  -1.86312000E-03  +1.23949000E-03  +2.11588000E-03  +9.55130000E-04
   -3.13200000E-05  +6.78980000E-04  -9.19550000E-04  -2.94700000E-05  -1.43143000E-03
   -9.71970000E-04  +2.73000000E-06  +5.55000000E-06  +6.55000000E-06  -1.01800000E-05
   -9.92000000E-06  -4.24000000E-06  +3.45000000E-06  +1.01500000E-05  +1.43600000E-05
   +6.23000000E-06  +9.86000000E-06  -6.00000000E-06  -7.28000000E-06  -5.84000000E-06
   +1.30000000E-07  -1.51900000E-05  +3.60900000E-05  -2.27200000E-05  +3.92000000E-06
   +9.11000000E-06  +1.88600000E-05  -2.23600000E-05  -3.68000000E-06  -2.37600000E-05
   +2.40000000E-07  -5.68000000E-06  -7.05000000E-06  +1.77300000E-05  -4.85000000E-06
   +1.18000000E-06  -1.52400000E-05  +5.81800000E-05  +5.80000000E-05  +2.05832050E-01
   +2.49000000E-05  +1.85600000E-05  +5.57000000E-06  -5.65000000E-06  -2.23100000E-05
   -2.75800000E-05  -1.46100000E-05  -3.60000000E-06  -3.54000000E-06  +1.63400000E-05
   -6.44000000E-06  +1.59000000E-05  +2.10440000E-04  -1.45670000E-04  -6.19900000E-05
   -1.31000000E-06  -2.15000000E-06  +3.75100000E-05  +1.85300000E-05  +4.17100000E-05
   +1.88000000E-06  +1.60890000E-04  +4.99200000E-04  -1.90440000E-04  -3.85000000E-06
   +1.13090000E-04  -2.34400000E-05  +6.28700000E-05  +1.10400000E-05  +4.71300000E-05
   +4.61046000E-03  +1.32870000E-04  +4.09640000E-04  +7.65511000E-03  +8.85130000E-03
   -1.05614700E-02  -6.84918300E-02  -8.91291100E-02  +7.11036900E-02  -2.08094400E-02
   -4.01978000E-03  +1.83115400E-02  +2.81380000E-03  -1.84019000E-03  +3.67787000E-03
   +4.86720000E-04  -1.34204000E-03  -9.28000000E-06  -9.01290000E-04  +1.24596000E-03
   -2.89609000E-03  -2.32000000E-06  -1.13000000E-06  -6.40000000E-07  -2.80000000E-06
   -3.80000000E-07  +1.91000000E-06  +4.70000000E-07  +8.37000000E-06  +7.27000000E-06
   +4.40000000E-06  -7.91000000E-06  -2.51000000E-06  +3.02000000E-06  +6.27000000E-06
   -2.31000000E-06  -1.20200000E-05  -2.20400000E-05  +2.10800000E-05  -1.75000000E-05
   -4.82900000E-05  -1.93400000E-05  +2.13000000E-06  +1.43200000E-05  +1.40700000E-05
   -8.80000000E-06  -1.98000000E-06  -2.87000000E-06  -1.28400000E-05  -7.17000000E-06
   -1.49400000E-05  +4.27000000E-06  -4.33000000E-06  -3.01400000E-05  +7.54863000E-02
   +8.66469100E-02  +2.78600000E-05  +2.17400000E-05  +4.07000000E-06  -9.39000000E-06
   -2.73400000E-05  -3.09300000E-05  -1.94800000E-05  -1.26500000E-05  -9.59000000E-06
   +1.14500000E-05  -2.78000000E-06  +1.55600000E-05  +1.67090000E-04  -4.35700000E-05
   -2.77300000E-05  -2.33700000E-05  -2.52900000E-05  +3.15700000E-05  +2.20700000E-05
   +3.50700000E-05  +1.41700000E-05  -6.64600000E-05  +9.61900000E-05  +1.90810000E-04
   +3.34800000E-05  +7.75000000E-06  -3.29000000E-06  -7.17000000E-06  +7.01700000E-05
   +1.79100000E-05  +4.23080000E-04  +1.23750000E-03  +3.29653000E-03  +2.49133000E-03
   -2.34186000E-03  -1.07307000E-03  +1.25639290E-01  +7.40108700E-02  -1.44047590E-01
   +1.43223500E-02  +6.00255000E-03  -3.06343000E-03  +4.38860000E-04  +4.02093000E-03
   +3.06480000E-03  -8.68370000E-04  -8.88800000E-05  -5.03180000E-04  -1.36590000E-03
   -2.59552000E-03  -1.48466000E-03  -4.25000000E-06  -3.66000000E-06  -2.00000000E-07
   -3.67000000E-06  -1.91000000E-06  +1.79000000E-06  -6.26000000E-06  -1.52000000E-06
   +4.34000000E-06  +3.97000000E-06  -2.36000000E-06  -4.33000000E-06  +6.40000000E-07
   +4.77000000E-06  -2.94000000E-06  +1.74800000E-05  +3.70000000E-06  -8.45000000E-06
   +1.98000000E-06  +9.43000000E-06  +2.47600000E-05  -3.71800000E-05  -7.28000000E-06
   -2.11500000E-05  -7.94000000E-06  +3.28000000E-06  -2.64500000E-05  +6.25000000E-06
   -6.05000000E-06  +7.10000000E-06  +3.42000000E-06  +3.75500000E-05  -8.68000000E-06
   -1.41487890E-01  -8.04807500E-02  +1.44726980E-01  +2.72890000E-04  +2.20940000E-04
   +3.35500000E-05  -3.63350000E-04  -1.57360000E-04  +1.62040000E-04  +3.51780000E-04
   +1.39010000E-04  -9.84600000E-05  -4.49640000E-04  +3.60100000E-05  -4.31710000E-04
   -5.13080000E-04  +8.85550000E-04  -3.37420000E-04  -6.59400000E-05  -1.32800000E-05
   +9.14100000E-05  -1.54530000E-04  -1.36940000E-04  +2.41800000E-05  -8.50640000E-04
   -1.73890000E-04  -8.06600000E-04  -3.30300000E-05  -1.45610000E-04  -8.64400000E-05
   +3.44800000E-05  -5.41500000E-05  +8.62600000E-05  +6.55773000E-03  +1.84653000E-03
   -2.69081000E-03  +1.95416000E-03  +1.49138000E-03  +4.94890000E-04  -4.17530000E-04
   +4.82300000E-04  -6.23020000E-04  -1.67018000E-03  +4.20636000E-03  +7.46390000E-04
   -1.42218000E-02  -1.32689200E-02  +1.77230800E-02  -1.95239170E-01  -6.90398800E-02
   +1.20855810E-01  -1.43552000E-03  -3.30200000E-04  +6.84830000E-04  -2.28100000E-05
   -3.98400000E-05  -2.09500000E-05  +1.60500000E-05  +1.26800000E-05  +2.07300000E-05
   +3.96200000E-05  -3.53500000E-05  +6.92800000E-05  +4.32500000E-05  +1.09300000E-05
   -4.67000000E-06  +1.04400000E-05  +1.25000000E-06  -1.22100000E-05  +3.43500000E-05
   -1.24300000E-05  +1.74800000E-05  -1.58700000E-05  -7.56800000E-05  +2.12700000E-05
   +1.38400000E-05  +1.74700000E-05  -9.20000000E-06  +1.46450000E-04  +4.23500000E-05
   -1.05700000E-04  +7.30000000E-06  -4.83900000E-05  +1.25500000E-05  -1.38900000E-05
   +4.55800000E-05  -1.66400000E-04  -1.96900000E-05  +1.91100000E-05  +8.39600000E-05
   +2.05139330E-01  -2.09140000E-04  -1.76910000E-04  -4.00100000E-05  +2.41780000E-04
   +4.20100000E-05  -1.40620000E-04  -2.37170000E-04  -2.37990000E-04  +7.38500000E-05
   +1.72960000E-04  +3.54370000E-04  +3.79580000E-04  +3.69440000E-04  -1.13640000E-04
   -9.40500000E-05  +1.00130000E-04  +5.29100000E-05  -6.26700000E-05  +1.23350000E-04
   +9.38600000E-05  -3.68000000E-05  -1.60961000E-03  +7.06200000E-05  -1.23915000E-03
   -7.79300000E-05  -2.68900000E-05  -1.07060000E-04  +3.01580000E-04  -5.15350000E-04
   +3.43930000E-04  -1.98739900E-02  -5.78037000E-03  +1.57957600E-02  +8.38020000E-04
   -3.64406000E-03  +5.36363000E-03  +8.28080000E-04  -2.30070000E-04  -1.03176000E-03
   +3.41011000E-03  -2.43040000E-04  +1.95875000E-03  +1.21895400E-02  +7.41195000E-03
   -7.45971000E-03  -7.02449900E-02  -9.20839400E-02  +7.03971700E-02  +6.86030000E-04
   +3.88900000E-04  -8.00340000E-04  +1.29000000E-06  +2.95600000E-05  +1.26800000E-05
   -2.69300000E-05  -1.39000000E-05  -2.21200000E-05  +9.52000000E-06  +1.37900000E-05
   -8.95300000E-05  +7.12300000E-05  -7.42700000E-05  -1.96000000E-05  -1.01800000E-05
   +4.39000000E-06  +5.54000000E-06  +1.18060000E-04  +3.76100000E-05  -4.85900000E-05
   +4.72100000E-05  +1.66240000E-04  +1.66800000E-05  -7.75300000E-05  +2.71900000E-05
   -8.71100000E-05  +1.43500000E-04  -3.54100000E-04  -5.97690000E-04  +2.89900000E-05
   +1.57740000E-04  +3.31300000E-05  +9.29000000E-06  +1.54790000E-04  -3.41110000E-04
   -2.91900000E-05  +4.28400000E-05  +1.10800000E-04  +7.41672800E-02  +9.28640600E-02
   +2.14940000E-04  +1.53200000E-04  +4.29700000E-05  -1.84500000E-04  -1.55530000E-04
   -1.81510000E-04  -1.43710000E-04  -2.79960000E-04  -8.17000000E-06  +1.89870000E-04
   -2.03400000E-04  -7.30500000E-05  -1.06170000E-04  +2.73280000E-04  +2.26770000E-04
   -4.65260000E-04  -3.18380000E-04  +2.30030000E-04  +8.38300000E-05  +2.00220000E-04
   +1.35590000E-04  +4.25900000E-05  -1.72420000E-03  -1.91479000E-03  -2.90980000E-04
   -1.12100000E-05  -2.07800000E-05  +5.51800000E-05  -1.56770000E-04  +1.25450000E-04
   +1.11145900E-02  +5.76271000E-03  -4.90293000E-03  +1.21162000E-03  +5.19346000E-03
   +1.40216000E-03  -1.05376000E-03  -8.26360000E-04  -1.83000000E-04  +1.30238000E-03
   +1.46023000E-03  +3.99099000E-03  +2.02107000E-03  +4.64133000E-03  +8.53600000E-04
   +1.20600590E-01  +6.89593500E-02  -1.34342130E-01  +1.90190000E-04  -3.30700000E-04
   -1.89360000E-04  -3.79500000E-05  -1.86400000E-05  -2.68700000E-05  -1.37300000E-05
   +2.52200000E-05  -1.07900000E-05  +6.40900000E-05  +1.27960000E-04  -5.35800000E-05
   +4.83600000E-05  -4.06100000E-05  -4.91600000E-05  +8.97000000E-06  -3.29000000E-06
   -6.33000000E-06  -5.13200000E-05  +7.43000000E-05  +6.69000000E-06  -2.71900000E-05
   -1.19540000E-04  +9.48000000E-06  +5.03200000E-05  +3.79600000E-05  +2.12000000E-06
   +1.33930000E-04  -1.96800000E-04  -1.49900000E-04  +2.91500000E-05  -7.84500000E-05
   +2.29300000E-05  -2.27500000E-05  +1.68420000E-04  -1.55140000E-04  +1.20270000E-04
   +9.69600000E-05  +8.11900000E-05  -1.33679810E-01  -7.95397700E-02  +1.36306600E-01
   +1.28380000E-04  +8.33600000E-05  +2.35600000E-05  -1.23870000E-04  -8.28000000E-05
   -1.85700000E-05  +3.47800000E-05  -3.09600000E-05  -2.62600000E-05  +7.61000000E-06
   -3.24300000E-05  +1.11500000E-05  +1.81000000E-05  -2.30700000E-05  +2.80000000E-06
   -1.58100000E-05  -1.19100000E-05  +3.98300000E-05  +1.41800000E-05  +1.12100000E-05
   +3.01800000E-05  -1.12800000E-04  +4.50000000E-06  +1.25190000E-04  +6.10800000E-05
   -8.69000000E-06  -1.63000000E-05  -2.30000000E-07  +3.35000000E-05  -2.25300000E-05
   -2.03720000E-04  -5.17520000E-04  +3.84400000E-04  +8.93520000E-04  +1.00063000E-03
   -3.95050000E-04  -5.88959000E-03  +2.98399000E-03  +1.73004000E-03  -3.16549000E-03
   +3.82003700E-02  -2.42759900E-02  -2.84365000E-03  +6.40367000E-03  -1.81289000E-03
   +2.12590000E-04  -1.70770000E-04  -5.10160000E-04  -4.21063000E-02  -3.97105600E-02
   +4.39422000E-02  -3.20400000E-05  -1.14500000E-05  -1.52000000E-05  -8.96000000E-06
   +1.48200000E-05  -3.76000000E-06  -1.84600000E-05  +1.73100000E-05  -3.20600000E-05
   -1.15500000E-05  +7.77000000E-06  -5.01000000E-06  +1.60000000E-06  +6.43000000E-06
   -6.85000000E-06  +1.65900000E-05  -2.91900000E-05  +1.28200000E-05  -1.71200000E-05
   +1.12000000E-06  -9.70000000E-06  -3.10000000E-07  +1.04600000E-05  -3.52000000E-06
   -1.14700000E-05  +8.38000000E-06  +3.25300000E-05  -1.10000000E-05  +2.53000000E-06
   +1.30500000E-05  +2.46000000E-05  -1.83400000E-05  +6.48000000E-06  -7.48600000E-05
   -2.56040000E-04  -1.34040000E-04  +2.93600000E-05  -5.05300000E-05  +9.66100000E-05
   +5.05783200E-02  -1.76810000E-04  -1.64050000E-04  -2.88300000E-05  +1.40270000E-04
   +1.27260000E-04  +4.82300000E-05  -3.82700000E-05  -1.29000000E-06  +5.08200000E-05
   -1.12400000E-05  -1.07100000E-05  -1.75800000E-05  +1.92000000E-06  +1.47730000E-04
   +2.31000000E-06  +6.65000000E-06  -7.43000000E-06  -5.07800000E-05  -3.13200000E-05
   -6.79500000E-05  -3.80200000E-05  +3.14230000E-04  -8.51700000E-05  +1.68720000E-04
   -7.41000000E-05  -1.42300000E-05  +3.60200000E-05  -1.97120000E-04  +8.86300000E-05
   -4.58300000E-05  -2.72660000E-04  +6.49370000E-04  -5.23620000E-04  +6.31900000E-05
   -6.21640000E-04  +1.26241000E-03  +2.94112000E-03  +1.32113000E-03  -1.38577000E-03
   +5.20499000E-03  -2.66530700E-02  +1.34335100E-02  -2.40771000E-03  +3.73052000E-03
   -2.77200000E-05  +2.94650000E-04  -1.94929000E-03  +4.81880000E-04  -1.36200000E-05
   -3.55359890E-01  +2.27056530E-01  +1.42500000E-05  +3.69500000E-05  +9.14000000E-06
   -1.85000000E-05  -9.93000000E-06  -2.31800000E-05  +2.89000000E-05  +2.89900000E-05
   +5.08300000E-05  +1.75800000E-05  +9.91000000E-06  -8.72000000E-06  -1.40100000E-05
   -4.49000000E-06  +4.18000000E-06  -3.03700000E-05  +4.25700000E-05  -3.66000000E-06
   +9.61000000E-06  -2.89000000E-05  +7.96000000E-06  +2.07100000E-05  -9.46000000E-06
   +6.20000000E-07  +1.89400000E-05  -1.36600000E-05  -8.92000000E-06  +8.00000000E-08
   -4.16100000E-05  -2.78600000E-05  -4.98900000E-05  +5.58800000E-05  +8.11900000E-05
   -1.84800000E-04  +3.27400000E-05  -3.77510000E-04  -2.96700000E-04  +2.56670000E-04
   +1.03520000E-04  -5.02338000E-03  +3.80377740E-01  +4.19300000E-05  +3.65700000E-05
   -2.72000000E-06  -2.90000000E-05  -3.04500000E-05  -1.08100000E-05  +8.82000000E-06
   -5.13000000E-06  -1.27200000E-05  -3.45000000E-06  +1.48000000E-05  +3.54400000E-05
   +2.38400000E-05  -5.84300000E-05  -3.17700000E-05  -1.52000000E-05  +1.10200000E-05
   +9.99000000E-06  +2.25600000E-05  +3.31400000E-05  -2.24000000E-06  -9.98300000E-05
   +1.15450000E-04  -4.00100000E-05  +8.23000000E-06  +9.82000000E-06  -2.12300000E-05
   +1.14980000E-04  -6.66700000E-05  +5.42500000E-05  +2.73430000E-04  -2.40180000E-04
   +5.81800000E-05  +2.04250000E-04  +8.05750000E-04  +7.47700000E-04  +1.72728000E-03
   -1.33530000E-03  +1.52374000E-03  -2.79508000E-03  -3.01257000E-03  +1.37187000E-03
   +3.87107000E-03  -4.41009000E-03  +2.67524000E-03  -8.18080000E-04  +7.27370000E-04
   -1.06361000E-03  +1.80743300E-02  +2.46758500E-01  -1.75181800E-01  -6.68000000E-06
   -6.33000000E-06  +4.51000000E-06  -6.06000000E-06  -1.00000000E-06  +1.76000000E-06
   -7.67000000E-06  +4.34000000E-06  -2.14900000E-05  +3.29000000E-06  -1.36300000E-05
   +0.00000000E+00  +9.51000000E-06  +1.70000000E-07  -8.70000000E-07  +1.29900000E-05
   -1.10500000E-05  +1.08000000E-06  +1.67000000E-06  +8.42000000E-06  +5.36000000E-06
   -7.55000000E-06  +3.38000000E-06  -5.41000000E-06  +1.04500000E-05  +1.93500000E-05
   -1.26600000E-05  -5.49000000E-06  +5.11000000E-06  +2.17800000E-05  +2.05300000E-05
   -2.88600000E-05  -5.58500000E-05  -1.81590000E-04  -3.43620000E-04  -3.62130000E-04
   +2.64380000E-04  -2.80300000E-05  +5.80400000E-05  -1.85126900E-02  -2.40147470E-01
   +1.71966570E-01  -2.41870000E-04  -1.83950000E-04  -4.61000000E-05  +2.12800000E-04
   +1.65880000E-04  +6.79700000E-05  -3.57400000E-05  +4.49800000E-05  +3.66700000E-05
   -6.61700000E-05  +4.00700000E-05  +1.86700000E-05  +1.07690000E-04  +7.42600000E-05
   +5.22900000E-05  +5.98000000E-05  +2.09300000E-05  -1.11140000E-04  -4.49700000E-05
   -7.06000000E-05  -7.31200000E-05  +6.35940000E-04  +1.04028000E-03  -1.05154000E-03
   -5.58720000E-04  +2.18950000E-04  +1.93260000E-04  +5.40900000E-05  -9.96500000E-05
   -8.96700000E-05  -4.08738000E-03  -1.45149000E-03  +6.85519000E-03  +2.26935000E-03
   +1.22045000E-03  -2.33655000E-03  -5.77730000E-03  +1.35057000E-03  +3.84300000E-03
   +1.53789000E-03  -2.53228300E-02  +1.97651300E-02  -1.09407420E-01  +3.08896100E-02
   +1.34771100E-02  -3.80257000E-03  +4.06566100E-02  -2.14684800E-02  +5.68818000E-03
   -8.76729000E-03  +1.30080000E-03  +4.08700000E-05  +2.92600000E-05  +2.42500000E-05
   -4.84000000E-06  -2.45200000E-05  -5.91000000E-06  +6.69000000E-06  -9.93000000E-06
   +4.60000000E-05  +1.98300000E-05  -1.29000000E-06  +5.31000000E-06  -1.36900000E-05
   -1.05100000E-05  +7.79000000E-06  -8.20100000E-05  +1.31220000E-04  -1.56840000E-04
   +2.46000000E-05  -3.53900000E-05  +1.74400000E-05  +1.24800000E-05  -1.10200000E-05
   -2.98100000E-05  +2.24100000E-05  -3.67600000E-05  -5.35600000E-05  +3.05600000E-05
   +2.27700000E-05  +6.75000000E-06  -3.08200000E-05  +5.70800000E-05  -8.56000000E-06
   +3.05690000E-04  -1.08851000E-03  +4.95390000E-04  +1.90876000E-03  -9.91290000E-04
   -2.42907000E-03  +1.46347000E-03  -1.09050000E-04  -1.24865000E-03  +4.62837200E-01
   +9.22740000E-04  +8.93080000E-04  +1.24150000E-04  -7.22660000E-04  -6.72100000E-04
   -2.59200000E-04  +1.71490000E-04  +6.28600000E-05  -2.90200000E-04  -5.33700000E-05
   +3.24000000E-05  +9.95400000E-05  -2.65540000E-04  -6.91840000E-04  -1.50560000E-04
   -1.40890000E-04  +5.85400000E-05  +2.74340000E-04  +2.00940000E-04  +3.93490000E-04
   +1.75110000E-04  -1.62140000E-03  -1.93240000E-04  +1.22704000E-03  +8.93560000E-04
   -3.60280000E-04  -2.64530000E-04  +3.52330000E-04  -4.43500000E-05  +1.03500000E-05
   +1.15896000E-03  +7.87340000E-04  +3.74396000E-03  +5.60869000E-03  -5.19709000E-03
   +1.73250000E-04  -2.85045000E-03  +6.87481000E-03  -8.31430000E-04  +6.83080000E-03
   -3.64368000E-02  +2.55455200E-02  +6.87470800E-02  -2.35019850E-01  +9.39479000E-02
   +7.61164000E-03  -2.77273800E-02  +1.77757200E-02  -5.56251000E-03  +6.50712000E-03
   -3.36512000E-03  -4.52300000E-05  -2.07560000E-04  -1.57900000E-05  +1.04030000E-04
   +3.34300000E-05  +1.44150000E-04  -1.89660000E-04  -2.04070000E-04  -2.38880000E-04
   -8.45200000E-05  -6.41600000E-05  +3.60200000E-05  +1.03390000E-04  +2.24000000E-06
   -1.00200000E-05  +2.65670000E-04  -3.31200000E-04  +4.11400000E-05  -6.37600000E-05
   +3.50210000E-04  -1.59600000E-05  -1.67860000E-04  +3.27600000E-05  -1.29210000E-04
   -6.55600000E-05  +5.85100000E-05  +6.00300000E-05  -2.22500000E-05  +1.64150000E-04
   +1.72420000E-04  +1.98530000E-04  -2.30920000E-04  -1.40780000E-04  +1.28790000E-04
   -6.85820000E-04  +2.77250000E-04  -1.67014000E-03  +1.63435000E-03  -2.89791000E-03
   -1.16521000E-03  -1.47437000E-03  +6.59210000E-04  +4.51352900E-02  +3.63188120E-01
   -4.82640000E-04  -4.32810000E-04  -5.23800000E-05  +3.74700000E-04  +3.48260000E-04
   +1.35380000E-04  -6.12800000E-05  +4.00800000E-05  +1.51450000E-04  -3.15100000E-05
   -1.52000000E-05  -1.05510000E-04  -9.27600000E-05  +2.65710000E-04  +1.04670000E-04
   +1.31800000E-04  -1.97300000E-05  -1.61860000E-04  -1.35000000E-04  -2.44330000E-04
   -8.39800000E-05  +1.19436000E-03  -3.73000000E-05  +7.91900000E-05  -1.77800000E-04
   +4.32000000E-05  +9.57200000E-05  -2.27530000E-04  +1.27470000E-04  -9.48500000E-05
   +4.66756000E-03  +5.22562000E-03  +1.29962000E-03  -5.41631000E-03  +2.22839000E-03
   +1.58620000E-04  +6.51448000E-03  -2.96585000E-03  +2.36419000E-03  -7.30700000E-04
   +4.15492300E-02  -1.79637700E-02  -1.07974100E-02  +1.10727260E-01  -1.04794180E-01
   -4.88700000E-05  +1.70861000E-03  +5.49669000E-03  -8.16020000E-04  -1.93802000E-03
   -1.41791000E-03  +4.78000000E-05  +9.11000000E-05  +9.18000000E-06  -2.21500000E-05
   -2.32600000E-05  -4.68100000E-05  +1.13080000E-04  +7.29000000E-05  +1.49160000E-04
   +2.46300000E-05  +5.41800000E-05  -8.47000000E-06  -6.34100000E-05  -8.50000000E-07
   +5.67000000E-06  -1.70640000E-04  +3.99600000E-05  -8.50000000E-06  +8.30000000E-06
   -2.12400000E-04  +9.11000000E-06  +9.90100000E-05  -1.07800000E-05  +4.93700000E-05
   -9.33000000E-06  -6.44200000E-05  +6.03000000E-06  +2.53000000E-06  -8.93600000E-05
   -1.30420000E-04  -1.28150000E-04  +7.74000000E-05  +1.41720000E-04  -3.18470000E-04
   +8.34000000E-04  -5.97380000E-04  -1.90105000E-03  -3.43567000E-03  -1.52845000E-03
   -5.79400000E-04  +2.10650000E-04  -1.04199000E-03  -2.30333220E-01  -2.36740500E-01
   +2.80167810E-01  +4.69500000E-05  -3.59000000E-06  +2.02800000E-05  -7.75000000E-05
   -2.61400000E-05  +2.90000000E-06  +2.34400000E-05  -5.95400000E-05  +1.18000000E-06
   +4.13500000E-05  -4.33200000E-05  -3.61800000E-05  +7.53900000E-05  +4.76400000E-05
   +2.63000000E-05  +1.13000000E-05  -1.14000000E-05  +4.50600000E-05  -2.19800000E-05
   -5.74300000E-05  +3.29500000E-05  +7.73100000E-05  +1.14020000E-04  -1.03600000E-04
   -5.44900000E-05  +1.99800000E-05  -1.45400000E-05  -1.31800000E-05  +1.15500000E-05
   -9.56000000E-06  -6.04410000E-04  +2.92180000E-04  -2.45940000E-04  -6.84130000E-04
   +4.24770000E-04  +1.74670000E-04  +6.29200000E-04  -4.39340000E-04  +4.29250000E-04
   -1.09116000E-03  +4.05123000E-03  -1.33937000E-03  +6.93699000E-03  +4.48109000E-03
   -7.08802000E-03  +2.96990000E-03  +2.65609000E-03  -3.17861000E-03  +6.42590000E-04
   -1.34342000E-03  +6.92520000E-04  -3.27800000E-05  +7.83000000E-06  -2.23500000E-05
   -1.47900000E-05  +1.56000000E-05  -2.01700000E-05  +1.15100000E-05  +3.19700000E-05
   +5.21000000E-06  -1.55000000E-06  +2.18500000E-05  -1.10300000E-05  -1.55200000E-05
   +1.23300000E-05  -6.64000000E-06  -1.05300000E-05  +1.75400000E-05  +5.81000000E-06
   -7.94000000E-06  -4.15000000E-05  +8.85000000E-06  +1.27900000E-05  +3.08000000E-06
   +1.09000000E-05  +2.50100000E-05  +2.45400000E-05  +3.09600000E-05  -1.30400000E-05
   -4.42300000E-05  +2.97000000E-06  -7.44000000E-06  +5.80000000E-06  -4.80000000E-07
   -3.05000000E-06  +4.90600000E-05  -1.48600000E-04  -1.07312000E-03  -4.18900000E-04
   +9.27630000E-04  +1.16303000E-03  -1.27530000E-04  -9.56520000E-04  -3.53084790E-01
   -1.23742910E-01  +2.39365410E-01  +3.44144660E-01  -2.52240000E-04  -2.63710000E-04
   -3.49200000E-05  +2.24350000E-04  +1.92420000E-04  +6.20000000E-05  -5.93300000E-05
   -4.45400000E-05  +6.65600000E-05  +7.19000000E-06  +4.58700000E-05  +1.70100000E-05
   +3.81100000E-05  +1.41970000E-04  -5.50000000E-06  +2.45200000E-05  +1.23200000E-05
   -7.92400000E-05  -2.50000000E-05  -7.52400000E-05  -5.55900000E-05  +2.36410000E-04
   +3.70600000E-05  -1.03470000E-04  -1.69900000E-04  +3.04500000E-05  +4.66500000E-05
   -1.05390000E-04  -3.02100000E-05  +1.90900000E-05  -3.08840000E-04  -5.94420000E-04
   +1.33300000E-04  +4.57980000E-04  +4.44010000E-04  -3.56180000E-04  -1.32149000E-03
   +4.93240000E-04  +1.01915000E-03  +3.41926000E-03  -5.37333000E-03  +2.72007000E-03
   -3.35703600E-02  -1.73138700E-02  +2.49623800E-02  -1.41838000E-03  +2.47580000E-03
   -1.09651000E-03  +1.33063000E-03  +9.86290000E-04  -1.16214000E-03  +4.12000000E-06
   +6.48900000E-05  -1.40000000E-06  -3.00300000E-05  -6.27000000E-06  -4.43500000E-05
   +2.12700000E-05  +2.66600000E-05  +4.44800000E-05  +3.56200000E-05  -4.10000000E-06
   -1.18800000E-05  -2.22000000E-05  +2.59000000E-06  +4.50000000E-06  -4.00300000E-05
   +6.39500000E-05  -2.57600000E-05  +4.71000000E-06  -3.96500000E-05  +8.37000000E-06
   +1.95200000E-05  -2.05000000E-06  -1.66300000E-05  +5.86400000E-05  -1.81200000E-05
   -6.38800000E-05  +7.19000000E-06  -2.81100000E-05  -1.57300000E-05  -4.75300000E-05
   +7.55900000E-05  +9.76000000E-06  +6.73900000E-05  -3.74840000E-04  +6.93900000E-05
   +1.87404000E-03  -3.09350000E-04  -3.76590000E-04  -1.64723000E-03  -3.88920000E-04
   +5.26420000E-04  -8.28841100E-02  -7.15324000E-02  +8.25864700E-02  +1.14071120E-01
   +9.13060200E-02  +1.35380000E-04  +8.86300000E-05  +3.38000000E-06  -1.34030000E-04
   -8.84300000E-05  -4.89000000E-06  +1.91700000E-05  -9.37400000E-05  -2.79600000E-05
   +4.55300000E-05  +4.48000000E-06  +5.92900000E-05  +3.01100000E-05  -5.87200000E-05
   -3.11100000E-05  -6.47300000E-05  +5.30000000E-06  +3.89500000E-05  +3.93400000E-05
   +6.69500000E-05  +4.89000000E-06  -1.93380000E-04  -6.38800000E-05  +8.19700000E-05
   +9.09900000E-05  -4.84500000E-05  -5.26500000E-05  +5.55600000E-05  -7.03400000E-05
   +7.74400000E-05  +5.91000000E-05  -2.96610000E-04  -6.00830000E-04  +2.71570000E-04
   -3.63500000E-04  +3.81520000E-04  +1.04858000E-03  +6.43280000E-04  +2.94300000E-05
   -8.71670000E-04  +2.48411000E-03  +4.20470000E-04  +1.71413900E-02  +7.81361000E-03
   -1.53778800E-02  -6.03580000E-04  -2.95362000E-03  +1.90571000E-03  -1.04786000E-03
   +3.63350000E-04  +5.63950000E-04  -3.79800000E-05  -9.80000000E-06  -6.76000000E-06
   -2.46500000E-05  +1.53700000E-05  -2.03100000E-05  -1.32000000E-05  +3.67600000E-05
   -6.23300000E-05  +8.89000000E-06  -3.09600000E-05  -8.57000000E-06  +2.47200000E-05
   -3.28000000E-06  -2.35000000E-06  +3.98800000E-05  -2.86100000E-05  +1.83900000E-05
   -1.30700000E-05  +2.45400000E-05  +4.56000000E-06  -1.85600000E-05  +1.07600000E-05
   -2.37300000E-05  +1.90700000E-05  +2.72000000E-05  -3.43000000E-06  -1.01600000E-05
   +3.79000000E-06  +2.10300000E-05  +2.55100000E-05  -1.71700000E-05  -4.92100000E-05
   -1.61330000E-04  +8.49500000E-05  -2.06410000E-04  -4.17630000E-04  +7.29900000E-04
   +3.01310000E-04  -7.08600000E-05  -2.93040000E-04  -6.68190000E-04  +2.13229170E-01
   +1.00862980E-01  -1.62387130E-01  -2.28601260E-01  -1.08845830E-01  +1.75621440E-01
end_hess

