# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.26475740    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -8.86820587E+00  -3.59334481E+00  -7.58999413E-01
   006   -6.84953209E+00  -2.02207047E+00  -5.33500096E-01
   006   -4.97173285E+00  -1.85505736E+00  -2.36415866E+00
   006   -2.95962636E+00  -2.25367851E-01  -2.02153797E+00
   006   -2.74741624E+00  +1.28267381E+00  +1.25953691E-01
   006   -4.64441532E+00  +1.08192175E+00  +1.93028434E+00
   006   -6.67565911E+00  -5.46278807E-01  +1.62058736E+00
   006   -5.09475333E-01  +3.10148708E+00  +3.63179401E-01
   006   -8.76820592E-01  +5.22297666E+00  -1.58334078E+00
   006   -3.58054090E-01  +4.33224481E+00  +2.98829182E+00
   006   +1.95538186E+00  +1.64295139E+00  -6.43552828E-02
   006   +3.84257258E+00  +2.46497238E+00  -1.70912091E+00
   006   +6.00140860E+00  +1.04619424E+00  -1.87840372E+00
   006   +6.51579455E+00  -1.12855142E+00  -5.90376096E-01
   006   +4.59987664E+00  -1.93289970E+00  +1.05369409E+00
   006   +2.38553269E+00  -5.73707172E-01  +1.29925389E+00
   008   +8.69011980E+00  -2.44391469E+00  -8.63694941E-01
   001   -8.77089755E+00  -4.48799142E+00  -2.32715127E+00
   001   -5.07810535E+00  -3.00804416E+00  -4.05452120E+00
   001   -1.49905695E+00  -1.46852225E-01  -3.45326254E+00
   001   -4.56889726E+00  +2.20574249E+00  +3.63430678E+00
   001   -8.13613013E+00  -6.83564165E-01  +3.04325984E+00
   001   -2.69815448E+00  +6.13045080E+00  -1.26496837E+00
   001   +5.86768443E-01  +6.66447879E+00  -1.40964818E+00
   001   -8.60383346E-01  +4.50116474E+00  -3.51236142E+00
   001   -2.19361769E-01  +2.92593581E+00  +4.48714353E+00
   001   +1.31895858E+00  +5.52372352E+00  +3.08650733E+00
   001   -2.00263627E+00  +5.52055826E+00  +3.35458078E+00
   001   +3.62255709E+00  +4.16183890E+00  -2.82372435E+00
   001   +9.30845672E-01  -1.27562330E+00  +2.56101637E+00
   001   +8.60834195E+00  -3.89545244E+00  +2.21734128E-01
   008   +5.09858615E+00  -4.11713128E+00  +2.33606290E+00
   001   +3.68716917E+00  -4.56878750E+00  +3.37095896E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.42000000E-06  +2.50000000E-06  +2.20000000E-06
   -1.02000000E-06  +1.90000000E-06  +1.49000000E-06
   -1.13000000E-06  +7.70000000E-07  +1.24000000E-06
   -6.10000000E-07  +1.40000000E-07  +4.70000000E-07
   +2.40000000E-07  +6.80000000E-07  +4.00000000E-08
   +3.50000000E-07  +2.00000000E-06  +3.00000000E-07
   -2.80000000E-07  +2.49000000E-06  +9.80000000E-07
   +8.80000000E-07  +9.00000000E-08  -7.50000000E-07
   +1.35000000E-06  -3.90000000E-07  -1.35000000E-06
   +1.56000000E-06  +8.60000000E-07  -1.10000000E-06
   +3.60000000E-07  -7.70000000E-07  -7.00000000E-07
   +3.50000000E-07  -1.98000000E-06  -8.70000000E-07
   -6.00000000E-08  -2.87000000E-06  -7.60000000E-07
   -8.40000000E-07  -2.48000000E-06  -1.30000000E-07
   -7.50000000E-07  -1.37000000E-06  +2.20000000E-07
   -2.80000000E-07  -7.20000000E-07  +2.00000000E-07
   -1.04000000E-06  -3.39000000E-06  -9.00000000E-08
   -2.00000000E-06  +2.10000000E-06  +2.45000000E-06
   -1.68000000E-06  +2.80000000E-07  +1.61000000E-06
   -6.40000000E-07  -7.00000000E-07  +3.10000000E-07
   +9.00000000E-07  +2.42000000E-06  -2.00000000E-08
   -1.20000000E-07  +3.46000000E-06  +1.22000000E-06
   +1.68000000E-06  +3.20000000E-07  -1.45000000E-06
   +1.85000000E-06  -8.00000000E-07  -1.96000000E-06
   +9.20000000E-07  -1.04000000E-06  -1.17000000E-06
   +1.19000000E-06  +1.22000000E-06  -7.40000000E-07
   +1.95000000E-06  +3.40000000E-07  -1.70000000E-06
   +2.01000000E-06  +1.54000000E-06  -1.33000000E-06
   +8.70000000E-07  -2.27000000E-06  -1.60000000E-06
   -3.60000000E-07  +2.90000000E-07  +4.30000000E-07
   -1.47000000E-06  -3.08000000E-06  +5.20000000E-07
   -1.42000000E-06  -1.18000000E-06  +8.80000000E-07
   -1.35000000E-06  -3.60000000E-07  +1.16000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.98079070E-01  +1.67112510E-01  +3.09525890E-01  -4.02404700E-02  +2.67474160E-01
   +5.07900370E-01  -2.20550040E-01  -1.34453920E-01  -1.50871800E-02  +5.60709460E-01
   -1.10874630E-01  -1.49379250E-01  -4.44619100E-02  +2.03679440E-01  +4.29359050E-01
   +2.35907100E-02  -1.68596800E-02  -9.79026100E-02  -1.22472900E-01  +1.95044910E-01
   +6.11023510E-01  -3.76833200E-02  -1.56157800E-02  +2.78893500E-02  -2.00682350E-01
   -4.50610100E-02  +7.63009900E-02  +5.46832880E-01  -3.45583700E-02  -2.54935000E-03
   +1.93035600E-02  -5.26595000E-03  -1.00731080E-01  -4.35409400E-02  +2.20432810E-01
   +4.19413140E-01  -1.69661000E-03  -1.79015000E-03  +8.86818000E-03  +1.38562840E-01
   +8.63200000E-04  -2.22970390E-01  -1.19299870E-01  +2.17171650E-01  +6.01010590E-01
   +3.42273000E-03  -2.65829000E-03  +2.16120000E-04  -4.50584200E-02  -5.57640000E-03
   +4.38671400E-02  -2.47845050E-01  -1.52602370E-01  -3.21406400E-02  +5.90986000E-01
   +1.49058000E-03  +3.02592000E-03  -8.16550000E-03  -3.34163900E-02  +1.79317700E-02
   +6.10608100E-02  -1.19471650E-01  -1.81767320E-01  -6.02355900E-02  +2.10427050E-01
   +4.02285100E-01  +6.62581000E-03  -3.69297000E-03  -5.93519000E-03  -1.88570000E-04
   +3.03136600E-02  +5.03855500E-02  +1.98048000E-02  -2.36439800E-02  -1.19121040E-01
   -1.55400760E-01  +1.72591420E-01  +5.83432260E-01  -1.96922000E-03  -2.31704000E-03
   -3.03679000E-03  -9.79565000E-03  +1.36830900E-02  +2.68139500E-02  +2.17585300E-02
   -8.14042000E-03  -2.78704400E-02  -1.13628810E-01  -4.42205200E-02  -2.21108400E-02
   +5.22821160E-01  -1.90452000E-03  -1.11699000E-03  +2.29455000E-03  +1.44652000E-02
   -9.76881000E-03  -2.20879300E-02  -3.28865400E-02  -2.33110700E-02  -1.30862700E-02
   -1.22772200E-02  -1.58816370E-01  -1.24071990E-01  +1.57896040E-01  +3.98350900E-01
   -3.58382000E-03  +1.84489000E-03  +5.51870000E-03  +2.86397100E-02  -2.13116500E-02
   -7.14914700E-02  -6.93640900E-02  -4.13759300E-02  +1.99349700E-02  +2.99617400E-02
   -8.81152100E-02  -2.42051630E-01  -1.30658740E-01  +1.51994790E-01  +5.69683890E-01
   +7.18240000E-04  +2.63848000E-03  +9.22493000E-03  +2.53796300E-02  -3.29021700E-02
   -7.85236100E-02  -5.65632800E-02  -2.49041300E-02  +1.94957900E-02  +3.42785700E-02
   +4.95280500E-02  +5.05259000E-02  -2.16170530E-01  -5.13063300E-02  +8.61134500E-02
   +5.39424460E-01  -4.75570000E-04  +4.57454000E-03  -4.80200000E-04  -5.42091000E-03
   -2.78791300E-02  -4.16789800E-02  -2.29261500E-02  -1.40942000E-02  +8.95477000E-03
   +2.42550800E-02  +2.59940800E-02  +1.04159000E-03  -1.90016900E-02  -9.93870200E-02
   -2.95305800E-02  +2.05002150E-01  +4.20835490E-01  +4.09184000E-03  -3.93845000E-03
   -5.78955000E-03  -3.39791700E-02  -1.12041500E-02  +2.23675300E-02  +2.15157000E-02
   +1.04866300E-02  -1.09768500E-02  +1.08057500E-02  -2.67342400E-02  -4.55753100E-02
   +1.37498810E-01  +5.27395000E-03  -2.12184770E-01  -1.20000930E-01  +2.10311520E-01
   +6.12638980E-01  -4.33196000E-03  -3.28431000E-02  -3.89262600E-02  -1.14379970E-01
   -1.53182000E-03  +4.61169000E-02  +3.41254800E-02  +2.32867400E-02  +8.27187000E-03
   -1.82963700E-02  -2.39965000E-02  -2.09809000E-02  -4.04215400E-02  -7.41513000E-03
   +4.17767800E-02  -2.42879720E-01  -1.47160990E-01  -2.85262700E-02  +5.86397900E-01
   -1.44849000E-02  -2.38856600E-02  -3.38671300E-02  -3.86618200E-02  -1.54376570E-01
   -8.89008100E-02  +4.58340200E-02  +2.60898500E-02  -2.34428100E-02  -2.23565100E-02
   -3.70912900E-02  -2.92407500E-02  -3.16576000E-02  +1.78553100E-02  +5.18122400E-02
   -1.14091960E-01  -1.78157240E-01  -5.72128600E-02  +2.20305260E-01  +3.99687980E-01
   -9.84865000E-03  -1.33649400E-02  -2.46254000E-03  -1.26919400E-02  -1.30463510E-01
   -2.64835360E-01  +4.40299900E-02  +1.90821000E-03  -3.77773900E-02  -1.84268500E-02
   -2.73630900E-02  -2.62129700E-02  +2.92760000E-03  +2.52923700E-02  +4.31554200E-02
   +2.31242600E-02  -2.12583700E-02  -1.19367850E-01  -1.62729100E-01  +1.82622790E-01
   +6.02879000E-01  +1.49417000E-03  +1.37423000E-03  -5.41700000E-05  -2.27500000E-03
   -1.93310000E-04  +1.25175000E-03  +4.24068000E-03  +1.43540000E-04  +1.42573000E-03
   -2.66795000E-03  -6.96565000E-03  -6.79653000E-03  -1.33752810E-01  -4.66839100E-02
   +9.06870000E-04  -1.65002300E-02  -1.46398200E-02  -3.39900000E-04  +1.08748000E-03
   -1.65549000E-03  +3.80699000E-03  +4.71515570E-01  +7.35230000E-04  +1.10110000E-04
   +3.55670000E-04  -4.52870000E-04  -7.27140000E-04  -2.30500000E-05  -2.80100000E-04
   +2.71705000E-03  -3.45550000E-03  -1.56018700E-02  -1.35662800E-02  -4.81036000E-03
   -4.85976000E-02  -1.11501160E-01  -1.06374600E-02  -4.71065000E-03  +1.48541000E-03
   +3.59136000E-03  -7.79700000E-04  +4.26074000E-03  -2.98800000E-03  +1.20733000E-03
   +4.80487510E-01  +6.24760000E-04  +1.08598000E-03  +3.86380000E-04  +7.46400000E-05
   -7.78330000E-04  -1.74229000E-03  +1.47371000E-03  -4.65689000E-03  -3.31220000E-03
   -2.20668100E-02  -1.63671100E-02  +1.71499000E-03  -2.56190000E-03  -1.29313700E-02
   -8.63749700E-02  +1.32748600E-02  +1.35676700E-02  +7.34466000E-03  +4.25134000E-03
   -1.70520000E-03  -1.04082000E-03  +6.10490000E-04  -1.05550000E-03  +4.80181220E-01
   -1.16111000E-03  -1.02267000E-03  -2.91530000E-04  +5.72630000E-04  +6.79190000E-04
   +6.02090000E-04  -2.23070000E-04  +5.81320000E-04  +2.63050000E-04  -4.12940000E-04
   -1.09279000E-03  +5.70600000E-04  +4.65200000E-05  -2.05112600E-02  +1.79015200E-02
   -7.05650000E-04  -1.68010000E-03  -1.06696000E-03  -1.40462000E-03  +2.84150000E-04
   -1.04315000E-03  -7.70118400E-02  +6.28654000E-03  -6.01611000E-03  +5.83520960E-01
   -4.71140000E-04  -4.65810000E-04  -1.62490000E-04  +1.40190000E-04  +4.61760000E-04
   +5.87290000E-04  -6.27800000E-05  +7.84790000E-04  +1.99810000E-04  -6.34500000E-05
   -5.13990000E-04  +1.13217000E-03  -6.97821000E-03  -2.52438100E-02  +1.55932600E-02
   +1.55467000E-03  -8.69990000E-04  -9.97300000E-04  -8.87090000E-04  +3.27500000E-05
   -9.47510000E-04  +1.16747700E-02  -1.27169660E-01  +5.02076100E-02  +1.36847900E-02
   +5.16359130E-01  -5.57500000E-04  -4.73780000E-04  -2.02610000E-04  +1.90650000E-04
   +2.62400000E-04  +5.19030000E-04  +3.06090000E-04  +1.52710000E-04  -1.90390000E-04
   -1.63549000E-03  -1.33912000E-03  -1.79680000E-04  +5.70007000E-03  +4.73622000E-03
   +1.36624000E-03  -4.80190000E-04  -3.58290000E-04  -2.29950000E-04  -2.29050000E-04
   -2.85830000E-04  -3.60930000E-04  -9.56675000E-03  +4.68257300E-02  -1.19995840E-01
   -1.34529400E-02  +6.22004200E-02  +5.38695610E-01  -5.25660000E-04  -4.29370000E-04
   -8.40000000E-05  +3.76610000E-04  +2.53800000E-04  +1.42100000E-04  +3.48200000E-04
   -8.63940000E-04  -1.01643000E-03  -4.37722000E-03  -2.92170000E-03  +8.80460000E-04
   -1.74355000E-03  -1.21879700E-02  -2.54158800E-02  -1.28876000E-03  -6.76720000E-04
   -8.16010000E-04  +1.20800000E-04  -2.52290000E-04  -7.64880000E-04  -7.55922000E-02
   -8.25320000E-04  -9.89820000E-04  +2.72270000E-04  -1.00867000E-03  -4.62170000E-03
   +5.85908710E-01  -9.39600000E-05  -9.47400000E-05  -3.40200000E-05  -8.51900000E-05
   +1.21780000E-04  -1.01260000E-04  +1.93130000E-04  -5.02930000E-04  -8.12110000E-04
   -3.48053000E-03  -1.07608000E-03  +5.42690000E-04  -4.63825000E-03  -1.18717000E-02
   -2.13124100E-02  -3.99080000E-04  -8.84520000E-04  +4.60740000E-04  +5.33800000E-04
   -3.16980000E-04  -7.28850000E-04  -4.54913000E-03  -9.23647500E-02  -3.87605900E-02
   +9.27880000E-04  +8.84579000E-03  +2.33262100E-02  -2.65320000E-03  +5.62423160E-01
   +3.20510000E-04  +2.51620000E-04  +5.90000000E-07  -2.86770000E-04  -1.25180000E-04
   +2.49520000E-04  +4.49840000E-04  +1.75500000E-04  +3.09200000E-05  +7.00720000E-04
   +8.25460000E-04  +2.20970000E-04  -5.47177000E-03  -4.11872000E-03  -2.93962000E-03
   +1.01970000E-03  +8.10020000E-04  +3.69110000E-04  +2.99420000E-04  -4.87000000E-06
   -3.10670000E-04  -7.06209000E-03  -3.58829700E-02  -1.55463610E-01  -2.29900000E-03
   -5.18852000E-03  -3.52206900E-02  -8.80033000E-03  -5.32508200E-02  +4.89087730E-01
   +1.23490000E-04  +8.54000000E-05  -2.61800000E-05  -2.52110000E-04  +1.22000000E-05
   +4.79480000E-04  +3.79570000E-04  +5.84010000E-04  +6.45960000E-04  -8.85670000E-04
   +5.68980000E-04  -3.68920000E-04  -3.52273400E-02  +5.08314000E-03  +6.29180000E-03
   -8.92570000E-04  -8.73500000E-05  -2.13609000E-03  -8.14900000E-05  -9.82920000E-04
   +5.03320000E-04  -1.42727640E-01  +4.07215300E-02  +1.42207400E-02  -5.67409000E-03
   +8.45169000E-03  -3.06539000E-03  -3.22452000E-03  +6.48931000E-03  +9.67666000E-03
   +5.41320140E-01  -6.80650000E-04  -6.79020000E-04  -2.20240000E-04  +1.54340000E-04
   +7.50770000E-04  +6.24070000E-04  +1.99930000E-04  -9.95600000E-05  +3.10700000E-05
   -2.25947000E-03  -6.13960000E-04  -5.20950000E-04  -1.35472600E-02  +1.21450300E-02
   +5.23783000E-03  -1.53374000E-03  -2.48361000E-03  -1.36606000E-03  -5.52140000E-04
   -1.13264000E-03  +4.90520000E-04  +3.78373200E-02  -1.03207850E-01  +3.59530000E-03
   +2.34273400E-02  -1.60729100E-02  -2.82836000E-03  +1.38876100E-02  -1.16310100E-02
   -9.93892000E-03  -7.80837300E-02  +5.07531240E-01  -3.61290000E-04  -4.00320000E-04
   -7.41000000E-06  +2.78210000E-04  +2.07440000E-04  -7.51000000E-06  -2.84380000E-04
   +3.00390000E-04  -7.04000000E-06  -2.16794000E-03  -9.11100000E-04  +7.32100000E-05
   +2.59624000E-03  +1.06815000E-03  -3.28830000E-04  +8.08600000E-05  +1.89830000E-04
   -7.38300000E-05  -5.26300000E-05  +4.81800000E-05  -1.06100000E-04  +1.71029700E-02
   +1.66209000E-03  -7.83097600E-02  -2.03942900E-02  +1.17153200E-02  +4.15989000E-03
   +2.68457500E-02  -1.85783500E-02  -9.40488000E-03  -1.49278020E-01  -1.87661380E-01
   +3.99335090E-01  -3.30390000E-04  -2.46820000E-04  -4.36500000E-05  +3.82320000E-04
   +1.74700000E-04  -3.62890000E-04  -3.63890000E-04  -3.81300000E-04  +2.13150000E-04
   +6.74940000E-04  +1.48700000E-05  +4.67650000E-04  -1.05461000E-03  +1.78704000E-03
   +8.18200000E-04  -7.94530000E-04  -8.43880000E-04  -1.60210000E-04  +1.25520000E-04
   +8.92700000E-05  +2.81040000E-04  -1.76619600E-02  -4.80780000E-03  +1.51480200E-02
   -1.94803000E-03  +2.32750000E-04  +1.38663000E-03  -1.14351000E-03  -1.26821000E-03
   -1.03986000E-03  -2.02633960E-01  -2.77854000E-03  +7.99652200E-02  +5.41408680E-01
   +1.85110000E-04  +1.37270000E-04  +3.82800000E-05  -2.01090000E-04  -5.80100000E-05
   +1.09770000E-04  +1.85040000E-04  +2.15670000E-04  -5.48100000E-05  -2.27600000E-04
   +7.62100000E-05  +2.22800000E-05  +1.14713000E-03  -2.01785000E-03  -1.05777000E-03
   +5.16870000E-04  +6.64380000E-04  +9.10000000E-05  -8.95000000E-06  +5.74700000E-05
   -1.93020000E-04  +1.13259900E-02  +9.14273000E-03  -8.67337000E-03  +1.34081000E-03
   -7.15970000E-04  -6.04080000E-04  +1.19071000E-03  -8.17330000E-04  -2.89470000E-04
   -6.25568600E-02  -1.23901550E-01  +7.73964600E-02  -1.42469200E-01  +5.63009540E-01
   -1.47500000E-05  -4.55000000E-05  +2.14700000E-05  -1.98220000E-04  +4.43700000E-05
   +3.21710000E-04  +2.56940000E-04  +3.50880000E-04  +1.27380000E-04  -5.78520000E-04
   -1.20730000E-04  -8.42480000E-04  -1.47502000E-03  -4.16630000E-04  -5.35800000E-05
   +3.54760000E-04  +2.84790000E-04  +1.22880000E-04  -1.80950000E-04  -3.50280000E-04
   -9.77700000E-05  +5.33567000E-03  +1.42700000E-04  +1.24091000E-03  -4.95890000E-04
   -5.72530000E-04  -4.33120000E-04  -3.26580000E-04  +5.47150000E-04  +2.09690000E-04
   +1.22622000E-01  +4.55878500E-02  -1.65713580E-01  -1.31848430E-01  -2.41779820E-01
   +3.70705080E-01  -2.03210000E-04  -1.73620000E-04  -8.99700000E-05  +1.10640000E-04
   +1.86180000E-04  +2.95840000E-04  +1.82080000E-04  +7.58600000E-05  -1.44750000E-04
   -3.38560000E-04  +1.46370000E-04  +3.18700000E-05  -5.16760000E-04  +8.65840000E-04
   +3.78650000E-04  +1.48790000E-04  +1.05120000E-04  -2.70630000E-04  -1.10200000E-04
   -2.61370000E-04  -1.33410000E-04  -7.34230000E-04  -1.68479000E-03  +4.53457000E-03
   +2.57820000E-04  -8.15300000E-04  +1.54090000E-04  -1.48224000E-03  +7.73870000E-04
   -1.82500000E-05  -5.64259600E-02  -1.79905000E-02  +5.03039900E-02  -2.62380090E-01
   +1.41731780E-01  +1.71959700E-02  +4.23605360E-01  +1.69150000E-04  +1.99430000E-04
   +7.72500000E-05  +1.75100000E-05  -2.35400000E-04  -4.13910000E-04  -2.64400000E-04
   -1.84790000E-04  +1.59940000E-04  +5.64670000E-04  -3.77700000E-05  +8.94000000E-06
   +9.27530000E-04  -6.84720000E-04  -4.69370000E-04  -2.16880000E-04  -1.99360000E-04
   +3.35450000E-04  +1.89410000E-04  +3.92790000E-04  +1.63160000E-04  +4.17240000E-04
   +2.07351000E-03  +2.22756000E-03  +3.70900000E-04  -2.93920000E-04  -2.23670000E-04
   +2.61420000E-04  -5.28180000E-04  +3.44170000E-04  +3.02703500E-02  +4.73729000E-02
   -4.27519400E-02  +1.18779280E-01  -1.63067390E-01  +1.63761500E-02  -2.28740460E-01
   +4.83024150E-01  +6.13400000E-05  +4.86600000E-05  +2.47800000E-05  -6.05500000E-05
   -4.55200000E-05  +3.53600000E-05  +3.04600000E-05  +4.03400000E-05  -8.10000000E-06
   +6.03600000E-05  -7.01200000E-05  -1.99430000E-04  +8.24680000E-04  -6.62450000E-04
   -3.25090000E-04  +2.07270000E-04  +2.03500000E-04  +1.39680000E-04  -3.45200000E-05
   +2.70200000E-05  -7.29200000E-05  +3.68039000E-03  +3.95449000E-03  +1.87556000E-03
   -6.41810000E-04  +3.80270000E-04  -4.69700000E-05  -1.15257000E-03  +7.64590000E-04
   +1.44070000E-04  +1.52613200E-02  -1.68079500E-02  +1.38818700E-02  +3.31240700E-02
   +4.42269000E-03  -6.96426300E-02  -3.25890100E-02  -1.73857340E-01  +2.11728650E-01
   +9.74300000E-04  +8.23620000E-04  +1.48170000E-04  -7.86960000E-04  -6.53040000E-04
   -1.73020000E-04  +2.89840000E-04  -3.67700000E-05  -3.45260000E-04  -4.88900000E-05
   +1.58760000E-04  +2.33910000E-04  -2.31700000E-05  -8.17400000E-04  -2.14590000E-04
   +8.24300000E-05  +2.55940000E-04  +1.96590000E-04  +2.03120000E-04  +2.99750000E-04
   +1.23680000E-04  -2.50159000E-03  +1.04464000E-03  -6.56390000E-04  +3.12520000E-04
   +2.49580000E-04  -2.47010000E-04  +9.94370000E-04  -3.07760000E-04  +1.71110000E-04
   -1.42294000E-03  -2.35227900E-02  +1.92471100E-02  +2.09560800E-02  +2.80736700E-02
   -3.14642200E-02  -1.08536630E-01  +6.73076200E-02  -1.47514200E-02  +5.93638720E-01
   -4.92870000E-04  -4.47040000E-04  -1.25460000E-04  +2.83460000E-04  +4.38140000E-04
   +4.15870000E-04  +1.35320000E-04  +1.63910000E-04  -2.20700000E-05  -3.54460000E-04
   -5.17900000E-05  -1.86320000E-04  -4.33930000E-04  +9.32260000E-04  +4.42140000E-04
   +1.80920000E-04  +1.36980000E-04  -2.78740000E-04  -2.18410000E-04  -4.28610000E-04
   -2.08010000E-04  -6.62470000E-04  -1.46852000E-03  +9.05800000E-04  -2.37750000E-04
   -3.18300000E-05  +3.93000000E-06  -8.34250000E-04  +6.42360000E-04  -2.13810000E-04
   -1.96424400E-02  -3.30660600E-02  +3.56006000E-02  +5.33332400E-02  -2.82150500E-02
   -8.28201000E-03  +4.31399200E-02  -2.70807060E-01  +1.37307880E-01  -1.75566770E-01
   +5.92589870E-01  -1.77240000E-04  -1.40900000E-04  +3.33000000E-06  +2.28690000E-04
   +5.90300000E-05  -2.76130000E-04  -3.01900000E-04  -1.81000000E-04  +1.91440000E-04
   +3.71070000E-04  -1.32180000E-04  +1.08080000E-04  +3.05120000E-04  +7.07500000E-05
   -1.76650000E-04  -3.21810000E-04  -2.77370000E-04  +1.10940000E-04  +1.16340000E-04
   +1.44000000E-04  +1.15320000E-04  +9.77170000E-04  -2.79440000E-04  -1.31014000E-03
   -5.75500000E-05  +3.49600000E-05  +2.34900000E-04  +3.18500000E-04  -4.34660000E-04
   +1.70930000E-04  +1.59348000E-02  +3.78021600E-02  -3.54207400E-02  -5.04350700E-02
   +5.01961000E-03  +2.41504200E-02  +2.78198000E-03  +1.23650970E-01  -1.39607270E-01
   -1.28882250E-01  -2.30936040E-01  +3.74503000E-01  +1.04850000E-04  +1.11850000E-04
   +6.03000000E-05  -1.72200000E-05  -1.93470000E-04  -4.23050000E-04  -3.41320000E-04
   -2.95160000E-04  +1.83830000E-04  +5.19170000E-04  -1.80650000E-04  +2.08110000E-04
   +2.98340000E-04  +1.59850000E-04  -3.80510000E-04  -4.20000000E-04  -4.57930000E-04
   +2.50690000E-04  +2.02050000E-04  +3.01130000E-04  +2.25360000E-04  +3.29278000E-03
   -7.95260000E-04  +1.04872000E-03  +5.94270000E-04  -2.86160000E-04  +3.38360000E-04
   -5.98300000E-05  -1.17510000E-04  +1.95900000E-04  +1.39926700E-02  +6.91512300E-02
   -5.83054100E-02  -6.34309500E-02  +3.83231000E-03  +3.27875300E-02  +5.17475200E-02
   -6.19792700E-02  +2.02452200E-02  -1.96192790E-01  +1.06984100E-02  +6.13728300E-02
   +6.36124960E-01  -1.01438000E-03  -9.62150000E-04  -1.61270000E-04  +8.22010000E-04
   +7.37640000E-04  +4.00400000E-04  -7.80600000E-05  +9.59700000E-05  +2.63540000E-04
   -1.62890000E-04  +3.09740000E-04  -8.31300000E-05  -8.46390000E-04  +6.64160000E-04
   -1.72780000E-04  +4.13320000E-04  +3.24960000E-04  -5.69490000E-04  -1.89030000E-04
   -4.66190000E-04  -2.77390000E-04  +3.42640000E-04  -1.73022000E-03  +4.38541000E-03
   +7.26480000E-04  -2.51570000E-04  -2.94110000E-04  -7.63000000E-04  +5.78020000E-04
   +3.50080000E-04  +2.66317400E-02  -2.77997300E-02  +5.93284000E-03  +4.95145000E-03
   +5.70101000E-03  -5.19419000E-03  -1.55180000E-02  -1.54905400E-02  +2.54849700E-02
   -6.98323400E-02  -1.07616220E-01  +6.41153600E-02  -1.40884340E-01  +5.41485300E-01
   +5.77110000E-04  +5.26080000E-04  +4.54300000E-05  -5.40320000E-04  -3.35510000E-04
   +1.08220000E-04  +3.50140000E-04  +1.95140000E-04  -3.59810000E-04  -3.46480000E-04
   -3.17900000E-05  +2.82000000E-05  +2.07710000E-04  -4.91400000E-05  -6.09900000E-05
   +1.44790000E-04  +1.98740000E-04  +8.98800000E-05  -1.55200000E-05  +1.08400000E-05
   -9.97000000E-06  -4.37800000E-04  +3.66803000E-03  +1.59000000E-06  -4.09420000E-04
   +4.03880000E-04  +1.58150000E-04  +3.93040000E-04  +4.69300000E-05  -1.07940000E-04
   -2.56383400E-02  -1.72629500E-02  +2.96542800E-02  +3.27723600E-02  -4.39021000E-03
   -1.20762700E-02  -1.34808600E-02  +5.11166800E-02  -2.19680900E-02  +1.18547760E-01
   +1.89787100E-02  -1.52379210E-01  -1.71257570E-01  -2.08258230E-01  +3.84084800E-01
   -4.34550000E-04  -4.42150000E-04  -1.03800000E-04  +1.77620000E-04  +4.00290000E-04
   +6.03800000E-04  +4.23780000E-04  +3.24220000E-04  -9.63300000E-05  -1.41477000E-03
   +4.38360000E-04  -5.23280000E-04  -1.66826000E-03  +2.98878000E-03  -9.67710000E-04
   +8.41110000E-04  +7.27890000E-04  -8.01010000E-04  -3.00490000E-04  -7.23040000E-04
   -2.65440000E-04  -5.47364000E-03  +2.40200000E-02  -1.45771800E-02  -5.03105000E-03
   +2.24601000E-03  +1.88671000E-03  -6.57450000E-04  +7.61350000E-04  -1.44373000E-03
   -1.16092380E-01  +1.23565800E-02  +2.10668800E-02  +3.70227100E-02  -1.86879800E-02
   -1.58562000E-03  -2.64492300E-02  +2.73168100E-02  -5.96378000E-03  -4.22271600E-02
   -1.96820800E-02  +3.93447200E-02  -2.79549000E-01  +1.35716950E-01  +2.41544900E-02
   +6.32315020E-01  +1.99880000E-04  +2.09510000E-04  +7.80700000E-05  -2.42340000E-04
   -1.66670000E-04  +1.40570000E-04  +1.70590000E-04  +3.54690000E-04  +8.08800000E-05
   -2.33180000E-04  -3.68270000E-04  -8.63250000E-04  -3.04300000E-04  -8.39740000E-04
   +4.87650000E-04  +4.28000000E-06  +6.00500000E-05  +2.70250000E-04  -1.57000000E-04
   -1.98620000E-04  +1.25270000E-04  +9.91905000E-03  -1.42046400E-02  +5.91081000E-03
   +1.83616000E-03  +1.33130000E-04  -7.22480000E-04  +7.89120000E-04  -3.93950000E-04
   +1.05771000E-03  +6.04377500E-02  -2.40942650E-01  +9.33363600E-02  -5.76965500E-02
   -7.45820000E-03  +4.26888500E-02  +3.44240600E-02  -4.63617400E-02  +1.36333200E-02
   +1.86456600E-02  +4.92917600E-02  -4.32074100E-02  +7.22415800E-02  -1.62686830E-01
   +3.43428900E-02  -1.15145250E-01  +5.35128030E-01  -5.01900000E-05  -4.11300000E-05
   -3.37100000E-05  +6.53500000E-05  +1.19590000E-04  +2.58210000E-04  +2.49320000E-04
   +2.62250000E-04  -3.80100000E-05  -7.44500000E-04  +5.83280000E-04  -2.01550000E-04
   -8.07100000E-04  +1.79310000E-04  +4.27720000E-04  +4.39540000E-04  +2.54440000E-04
   -5.54230000E-04  -1.07950000E-04  +7.47000000E-06  -1.64870000E-04  -3.06952000E-03
   -3.33122000E-03  +6.18600000E-03  +1.73234000E-03  -3.61500000E-04  -4.06520000E-04
   +1.08043000E-03  -9.61290000E-04  -5.21970000E-04  -1.47949700E-02  +1.19639130E-01
   -1.42339210E-01  +2.66903200E-02  +2.14726300E-02  -2.19223100E-02  -1.12121600E-02
   +1.79232900E-02  -8.17879000E-03  +1.14570200E-02  -2.23448600E-02  +1.29489800E-02
   +6.94245400E-02  -1.35500000E-04  -9.78576800E-02  -1.91389780E-01  -2.27578030E-01
   +3.91725580E-01  -1.04609000E-03  -8.96570000E-04  -1.85420000E-04  +8.13920000E-04
   +7.30180000E-04  +3.01820000E-04  -2.30670000E-04  +7.17000000E-05  +2.70060000E-04
   -1.45900000E-04  -8.24300000E-05  -1.40730000E-04  -2.11500000E-05  +9.62710000E-04
   +1.55000000E-04  +2.80500000E-05  -9.63200000E-05  -3.48990000E-04  -2.21540000E-04
   -3.84090000E-04  -2.22090000E-04  +1.96713000E-03  -5.87250000E-04  +7.73610000E-04
   -5.35310000E-04  -1.53040000E-04  +3.57690000E-04  -1.49548000E-03  +6.19100000E-04
   -3.96210000E-04  -2.52816000E-03  +3.94921000E-03  -3.10442000E-03  -1.17022000E-03
   -3.32484000E-03  +4.85165000E-03  -6.47195000E-03  +1.99565900E-02  -9.65422000E-03
   -2.57303720E-01  +8.57186000E-02  +6.10770900E-02  -4.75008600E-02  +3.32539700E-02
   +9.25091000E-03  +3.98735000E-03  -4.93160000E-03  +4.26226000E-03  +3.47429820E-01
   +7.23080000E-04  +6.50900000E-04  +1.33160000E-04  -5.25540000E-04  -5.28910000E-04
   -2.59020000E-04  +1.18660000E-04  -5.02300000E-05  -1.78800000E-04  +1.52980000E-04
   +9.78200000E-05  +1.04040000E-04  +1.56760000E-04  -8.59230000E-04  -1.29190000E-04
   -3.62700000E-05  +4.04900000E-05  +2.69080000E-04  +1.72030000E-04  +3.44580000E-04
   +1.67930000E-04  -1.04836000E-03  +6.16870000E-04  -5.58070000E-04  +4.10210000E-04
   +4.54200000E-05  -2.54050000E-04  +9.43900000E-04  -4.25340000E-04  +2.86830000E-04
   +2.44670000E-03  -5.61230000E-04  -9.64850000E-04  -2.46935000E-03  +3.18490000E-04
   +3.66304000E-03  +3.95400200E-02  -2.87909600E-02  -1.24000000E-06  +1.33884020E-01
   -1.39465000E-01  -2.20421000E-03  +4.98903000E-03  -1.31681000E-03  +5.97839000E-03
   -8.76450000E-04  -3.32130000E-04  +4.53627000E-03  -1.34102180E-01  +4.98023070E-01
   +1.12530000E-04  +9.89900000E-05  +3.03100000E-05  -9.28600000E-05  -7.57200000E-05
   -2.25800000E-05  +3.45200000E-05  +6.96000000E-06  -3.05900000E-05  +3.10400000E-05
   -3.49300000E-05  -6.44100000E-05  +1.24480000E-04  -1.57990000E-04  +8.93400000E-05
   +2.85000000E-06  -3.50800000E-05  +8.06200000E-05  -8.46000000E-06  +3.27500000E-05
   +3.56400000E-05  -4.88800000E-05  +8.57100000E-05  +2.08260000E-04  +6.48300000E-05
   +2.02600000E-05  -5.66500000E-05  -9.53500000E-05  +9.59000000E-05  -3.63600000E-05
   -1.16350000E-03  -2.51447000E-03  +1.44807000E-03  +4.53901000E-03  +4.05912000E-03
   -2.02132000E-03  -2.38344900E-02  +1.12038400E-02  +7.29874000E-03  +2.66311500E-02
   +2.45867200E-02  -7.07826400E-02  +2.90732800E-02  -9.66219000E-03  +1.83063000E-03
   +1.45893000E-03  +6.69916000E-03  -3.15020000E-04  -8.37368600E-02  -2.63509140E-01
   +2.61399170E-01  -3.67020900E-02  +1.50065600E-02  +6.27206100E-02  -2.44892000E-03
   -2.17749700E-02  -3.57657000E-02  +1.30458000E-03  +2.52600000E-05  -2.38628000E-03
   -6.22090000E-04  -1.39120000E-04  -2.33720000E-04  -6.81500000E-05  +2.60950000E-04
   +6.21420000E-04  +1.54320000E-03  -7.10060000E-04  -8.20650000E-04  -4.52477000E-03
   -4.11754000E-03  +8.65430000E-04  -1.68670000E-04  +8.12000000E-06  +1.03830000E-04
   +4.13800000E-05  -7.00000000E-08  -1.52200000E-05  +6.94800000E-05  +3.11700000E-05
   -2.05700000E-05  -2.80900000E-05  -5.51000000E-06  +3.14900000E-05  +2.40300000E-05
   -3.37000000E-06  +7.48000000E-06  +1.38800000E-05  -8.00000000E-07  +4.50000000E-07
   -1.26230000E-04  +5.33100000E-05  +2.09000000E-05  -1.36800000E-05  +6.84500000E-05
   -4.69700000E-05  +1.90100000E-05  +2.40900000E-05  +2.69500000E-05  +1.29910000E-04
   -7.12800000E-05  -7.55000000E-06  +4.26746800E-02  -8.98650000E-03  -1.36883320E-01
   -2.06780240E-01  +4.18490000E-04  -1.96147200E-02  -2.77676900E-02  +3.15122000E-03
   +2.02843000E-03  +1.12024000E-03  +4.68400000E-05  -8.73270000E-04  -3.78690000E-04
   -2.86000000E-05  +3.80220000E-04  +5.65470000E-04  +2.02960000E-04  +7.30900000E-04
   -1.77931000E-03  -4.87451000E-03  -8.36990000E-04  +8.34830000E-04  -1.75940000E-04
   -8.27000000E-05  +1.17000000E-05  +6.78600000E-05  +1.78400000E-05  +2.53000000E-05
   +7.24600000E-05  +1.12900000E-05  -2.56600000E-05  -1.86600000E-05  +8.49000000E-05
   +6.21300000E-05  +4.99800000E-05  -2.44200000E-05  +1.28300000E-05  +1.26100000E-05
   -1.99800000E-05  -2.50000000E-06  -1.68190000E-04  +7.59700000E-05  +3.75900000E-05
   -1.37600000E-05  +2.06710000E-04  -1.25130000E-04  +6.94900000E-05  -2.82700000E-05
   -1.02000000E-06  +1.69010000E-04  -1.27840000E-04  -1.77900000E-05  +1.08150100E-02
   +1.55094470E-01  +2.34166200E-02  -2.34719990E-01  -4.12810400E-01  +5.76110000E-04
   -1.90448000E-03  -6.47670000E-03  +2.64937000E-03  +4.66412000E-03  +3.53274000E-03
   +3.73900000E-05  -2.29600000E-04  -1.01611000E-03  +1.32340000E-04  +1.42110000E-04
   +3.51150000E-04  +5.94180000E-04  -7.55550000E-04  -1.31450000E-04  -2.97000000E-04
   -2.05300000E-05  +2.36691000E-03  -1.58980000E-04  -3.47700000E-05  -1.58050000E-04
   +1.33370000E-04  +7.37000000E-05  +7.18400000E-05  +3.48100000E-05  +3.38000000E-06
   -2.25700000E-05  -5.69000000E-06  +4.71200000E-05  +3.15000000E-05  +1.74100000E-05
   -7.43000000E-06  -1.08300000E-05  +2.85300000E-05  -1.96600000E-05  -1.20800000E-05
   -6.50600000E-05  +4.34700000E-05  +6.24000000E-06  -1.29800000E-05  +3.25500000E-05
   -9.03000000E-06  +2.08500000E-05  -1.51000000E-05  +1.73900000E-05  +7.87100000E-05
   -5.07800000E-05  -1.54600000E-05  -2.68011000E-02  +2.33043690E-01  +4.14698780E-01
   +1.35062000E-03  +3.04750000E-03  -9.27660000E-04  +4.85947000E-03  +1.20882100E-02
   +1.80627200E-02  -5.39994100E-02  -1.62320600E-02  -2.88120000E-03  +3.19100000E-03
   -1.34552400E-02  -2.17072400E-02  -1.53139000E-03  -5.52618000E-03  +1.41632000E-03
   -1.55291000E-03  -3.51180000E-04  +1.54170000E-04  -1.62607000E-03  -2.11143000E-03
   +4.53717000E-03  +5.68220000E-04  -4.68290000E-04  -9.85230000E-04  -1.23000000E-06
   +9.09900000E-05  -8.99900000E-05  -3.46880000E-04  -1.63320000E-04  +9.22000000E-05
   +1.18980000E-04  -3.39200000E-05  -2.35200000E-05  -2.56200000E-05  +1.77300000E-05
   +5.25000000E-06  -2.04500000E-05  +2.91200000E-05  +1.01600000E-05  +6.08800000E-05
   -3.44700000E-05  -1.34600000E-05  -2.96000000E-06  -7.19400000E-05  +5.43300000E-05
   -3.31000000E-05  +2.50700000E-05  +1.99300000E-05  -7.59300000E-05  +6.72600000E-05
   +1.49900000E-05  -6.96210000E-04  -1.03848000E-03  -2.92500000E-04  +5.01866800E-02
   +2.75331000E-03  -1.93570000E-04  +2.68088000E-03  -3.37156000E-03  +2.62374000E-03
   +1.49909000E-03  -1.63263100E-02  -1.31634120E-01  -1.35950000E-01  +1.01473000E-03
   -7.58027000E-03  -1.71757000E-02  -5.65265000E-03  +2.53173000E-03  -1.49195000E-03
   -1.10740000E-04  -5.07790000E-04  +7.19760000E-04  -1.85306000E-03  +3.60517000E-03
   -7.85720000E-04  +1.70540000E-04  +5.11200000E-05  -9.14770000E-04  -5.65800000E-05
   -7.35000000E-06  -1.90300000E-05  -2.87750000E-04  -2.40940000E-04  +8.62100000E-05
   +2.15770000E-04  -9.01800000E-05  -5.06700000E-05  -5.58500000E-05  +2.89300000E-05
   +4.42100000E-05  -1.49100000E-05  -1.62000000E-06  +1.97600000E-05  +7.70300000E-05
   -2.68200000E-05  -2.78400000E-05  -1.09900000E-05  -3.89700000E-05  +1.77100000E-05
   +9.37000000E-06  +3.50900000E-05  +1.23200000E-05  -8.26200000E-05  +5.18700000E-05
   +1.47400000E-05  +3.76440000E-04  +2.53970000E-04  -9.14750000E-04  +2.09933400E-02
   +1.33642910E-01  -1.51995000E-03  +2.29388000E-03  +1.45467000E-03  -5.99657000E-03
   -1.56571900E-02  -1.38929100E-02  -3.20752000E-03  -1.35989790E-01  -2.43170550E-01
   +1.06192000E-03  -9.25240000E-04  +1.66300000E-05  +8.65720000E-04  -2.05251000E-03
   +3.37217000E-03  +4.20140000E-04  +9.51930000E-04  +1.60630000E-04  +5.01038000E-03
   -4.04110000E-04  -8.11990000E-04  +3.97610000E-04  -8.26200000E-05  -1.04190000E-04
   -5.27700000E-05  +1.01000000E-05  -5.59100000E-05  -1.11130000E-04  -1.09600000E-05
   +5.06100000E-05  -2.04600000E-05  -4.51200000E-05  -7.63000000E-06  -9.17000000E-06
   +1.20600000E-05  -3.82700000E-05  -1.54300000E-05  +3.02500000E-05  -3.15000000E-06
   +8.63500000E-05  -5.06500000E-05  -9.06000000E-06  +1.04100000E-05  -1.23690000E-04
   +8.39500000E-05  -5.38600000E-05  +9.42000000E-06  +3.91000000E-06  -9.48500000E-05
   +7.86400000E-05  +9.38000000E-06  +1.94027000E-03  +6.29510000E-04  -5.59700000E-04
   +3.13004000E-03  +1.49983210E-01  +2.54975560E-01  -1.27577000E-03  -2.73040000E-04
   +8.20750000E-04  +1.69480000E-04  -5.50049000E-03  -2.36180000E-04  -1.26826200E-02
   -2.03200000E-05  +1.82443800E-02  -1.95738860E-01  -1.48518100E-02  +1.44233680E-01
   +4.92378000E-03  -2.97010000E-04  -1.33562000E-03  +2.56013000E-03  -2.26094000E-03
   +4.50750000E-04  -2.89460000E-04  +5.83400000E-05  -9.24390000E-04  -9.79340000E-04
   +6.96620000E-04  -9.31590000E-04  -2.90000000E-05  -1.52110000E-04  +1.15960000E-04
   -4.69200000E-05  +1.44180000E-04  -4.57300000E-05  -5.89940000E-04  -5.10070000E-04
   -6.99940000E-04  -1.09200000E-05  -3.53600000E-05  +1.27900000E-05  -1.76060000E-04
   +1.57360000E-04  +1.71000000E-06  -2.64780000E-04  +1.71000000E-06  +1.84310000E-04
   +2.30970000E-04  +1.80850000E-04  -1.78750000E-04  -2.26560000E-04  -1.14270000E-04
   -2.36810000E-04  +1.75110000E-04  -1.22200000E-04  -2.86400000E-05  +1.00450000E-04
   +1.75940000E-04  +1.59510000E-04  -4.61430000E-04  +1.83181000E-03  -1.40780000E-03
   +2.04233840E-01  -9.57360000E-04  -2.60500000E-04  +7.86440000E-04  -5.34491000E-03
   +1.89121000E-03  -3.70773000E-03  -1.50103800E-02  +2.95996000E-03  +1.45191400E-02
   -1.42488500E-02  -4.99865600E-02  -7.00480000E-04  +1.33431900E-02  +5.92080000E-03
   -1.19432300E-02  -2.74673000E-03  +1.35919000E-03  -5.06976000E-03  +8.71700000E-05
   -1.08599000E-03  +5.78200000E-05  +1.53041000E-03  -1.34327000E-03  +1.01684000E-03
   -1.40680000E-04  -5.37600000E-04  -5.07350000E-04  +1.63980000E-04  +1.64000000E-06
   +1.05320000E-04  -3.75620000E-04  +1.15040000E-04  -2.79500000E-04  +1.39280000E-04
   -1.12630000E-04  -5.49800000E-05  -1.56130000E-04  +1.86530000E-04  +2.24000000E-06
   -2.11250000E-04  -1.10280000E-04  +2.02410000E-04  +3.15050000E-04  -9.10000000E-07
   -2.37920000E-04  -2.44340000E-04  +7.59700000E-05  -2.16270000E-04  +1.34590000E-04
   -1.07580000E-04  -1.63800000E-05  +8.60900000E-05  +1.06610000E-04  +1.28740000E-04
   +2.15656000E-03  -1.96797000E-03  +1.69226000E-03  +2.07992900E-02  +4.41643600E-02
   -6.34000000E-05  +9.34400000E-05  +1.79400000E-04  +1.44610000E-04  -3.29226000E-03
   +2.90903000E-03  -4.22261000E-03  -1.50838000E-03  +6.27992000E-03  +1.43515730E-01
   +7.68500000E-05  -1.92787650E-01  +1.96359800E-02  +2.35066000E-03  -1.30065400E-02
   +3.10700000E-04  -5.56929000E-03  -2.44284000E-03  -1.12532000E-03  -1.17540000E-04
   -1.93860000E-04  +3.33820000E-04  +1.83875000E-03  -6.38550000E-04  -1.17800000E-05
   -4.53500000E-05  -1.60310000E-04  -2.04170000E-04  +5.31000000E-06  +9.81000000E-06
   -3.61310000E-04  -4.35070000E-04  +9.11400000E-05  -3.16860000E-04  +1.45280000E-04
   +3.09480000E-04  -3.54500000E-05  -9.94700000E-05  +4.40500000E-05  -3.51130000E-04
   +1.21770000E-04  +2.67700000E-05  -4.61300000E-05  +2.92640000E-04  -1.81930000E-04
   +9.46300000E-05  +4.62590000E-04  -2.37300000E-05  +3.66320000E-04  -2.39340000E-04
   -1.20400000E-05  -2.01000000E-05  +8.90000000E-07  -1.21700000E-05  -1.11038000E-03
   +2.01378000E-03  -3.22670000E-04  -1.57549570E-01  +3.55568000E-03  +2.00363910E-01
   +4.55100000E-05  -7.02670000E-04  -1.14142000E-03  -1.16685000E-03  -5.46490000E-03
   +1.58155000E-03  -1.31570000E-03  -1.34710000E-04  +3.66500000E-05  -1.57327000E-03
   -2.59095000E-03  +5.09161000E-03  +6.67005000E-03  +1.25808800E-02  +1.74694200E-02
   -5.50289600E-02  -1.31407100E-02  -3.28167000E-03  +2.67577000E-03  -1.43107200E-02
   -2.11683100E-02  -2.54480000E-04  +1.84875000E-03  -1.00113000E-03  +3.75040000E-04
   +5.82500000E-05  -1.02170000E-04  -2.25782000E-03  -1.63467000E-03  +5.92000000E-04
   -2.31540000E-04  -1.12610000E-04  -1.01000000E-04  +1.94500000E-05  +3.47000000E-06
   -6.09100000E-05  +3.00800000E-05  -6.40000000E-07  +1.08300000E-05  -6.84900000E-05
   +4.03400000E-05  +1.84600000E-05  -3.20300000E-05  +8.28300000E-05  -7.87600000E-05
   -1.22700000E-05  -1.39010000E-04  +2.79600000E-05  +9.18400000E-05  -5.47900000E-05
   -1.12900000E-05  -3.19250000E-04  -1.74420000E-04  -1.27540000E-04  -1.35230000E-04
   +2.99870000E-04  -1.97170000E-04  +1.96830000E-04  +7.28500000E-04  +1.02868000E-03
   +5.48822500E-02  -1.06490000E-04  -6.22970000E-04  -9.85620000E-04  -5.51321000E-03
   +2.95488000E-03  -1.77216000E-03  -5.47100000E-05  -5.91790000E-04  +8.55640000E-04
   -2.52926000E-03  +4.12334000E-03  -1.29828000E-03  +1.91960000E-04  +5.27015000E-03
   +1.13889000E-03  -1.30282000E-02  -1.33896980E-01  -1.36224160E-01  +8.85700000E-05
   -6.90838000E-03  -1.72252300E-02  +1.31314000E-03  -2.37148000E-03  +8.98560000E-04
   -4.88910000E-04  -2.97090000E-04  +2.34700000E-05  -2.72739000E-03  -8.59980000E-04
   +2.11070000E-04  +2.65450000E-04  +4.56890000E-04  -2.01610000E-04  +9.34200000E-05
   -1.02410000E-04  +4.46600000E-05  +3.25400000E-05  -4.59200000E-05  -8.93000000E-06
   -6.89000000E-05  +5.85600000E-05  +1.05500000E-05  +1.68400000E-05  +2.48300000E-05
   -1.01700000E-05  +1.02650000E-04  +7.50900000E-05  -8.86600000E-05  +5.95900000E-05
   -6.20100000E-05  +4.07000000E-06  -1.19830000E-04  -2.54960000E-04  +2.73400000E-05
   +2.76800000E-04  -4.10940000E-04  +1.97280000E-04  -7.30300000E-05  +9.95500000E-05
   +2.10910000E-04  +2.18341400E-02  +1.37423630E-01  -1.69550000E-04  -3.01260000E-04
   -2.36150000E-04  +1.45631000E-03  -1.86055000E-03  +3.35780000E-03  +1.60160000E-04
   +9.38500000E-04  +2.23600000E-04  +5.15223000E-03  -1.06506000E-03  -7.39100000E-04
   -2.48443000E-03  -1.29682600E-02  -1.34620900E-02  -2.80616000E-03  -1.36149490E-01
   -2.52624950E-01  +1.57144000E-03  -1.22178000E-03  +2.75580000E-04  -2.04384000E-03
   +1.09640000E-04  -1.35004000E-03  +5.12940000E-04  +1.85940000E-04  +4.54400000E-05
   -9.88030000E-04  -1.10165000E-03  +3.04080000E-04  -1.43340000E-04  -8.89200000E-05
   +1.15150000E-04  -3.60800000E-05  +5.27200000E-05  +1.83900000E-05  -3.13000000E-06
   +1.30400000E-05  +2.60000000E-06  +2.55900000E-05  -1.70500000E-05  -1.99000000E-05
   -2.30000000E-05  -1.87500000E-05  +2.74400000E-05  +2.05300000E-05  +2.35100000E-05
   +6.48400000E-05  -3.51800000E-05  +3.25300000E-05  +4.32000000E-06  -4.52400000E-05
   +8.46500000E-05  -2.79000000E-06  -2.30660000E-04  +1.67650000E-04  -2.02330000E-04
   -1.98490000E-04  -6.65270000E-04  -8.23990000E-04  +3.03819000E-03  +1.51579870E-01
   +2.64506070E-01  -2.53040000E-04  +1.83909000E-03  -8.38980000E-04  +4.14675000E-03
   -2.06675000E-03  -1.95933000E-03  +2.26336000E-03  -2.17340000E-03  +4.21120000E-04
   -2.34760000E-04  +5.75900000E-05  -9.00720000E-04  -3.43520000E-04  -5.47111000E-03
   -2.55010000E-04  -1.20570700E-02  +6.86610000E-04  +1.73171300E-02  -1.96381800E-01
   -2.08042600E-02  +1.48046430E-01  -1.30200000E-04  +2.68230000E-04  +8.96150000E-04
   -2.05420000E-04  -8.83300000E-05  -9.80800000E-05  -3.00700000E-05  +8.25600000E-05
   +6.14700000E-05  +4.31600000E-05  -2.07860000E-04  +1.80000000E-07  -8.05300000E-05
   +6.85800000E-05  +7.78000000E-06  -6.87000000E-06  +1.52000000E-06  +1.54600000E-05
   +8.63200000E-05  -2.35400000E-05  -3.25600000E-05  -2.06300000E-05  -8.93100000E-05
   +7.10500000E-05  -4.93300000E-05  +9.29000000E-06  +2.44700000E-05  -7.69100000E-05
   +5.71500000E-05  +1.74000000E-06  -1.35520000E-04  +2.43270000E-04  -1.01750000E-04
   +1.94530000E-04  +4.07900000E-05  -2.28740000E-04  -2.09860000E-04  +2.89080000E-04
   -9.82200000E-05  -5.33680000E-04  +1.86639000E-03  -1.42651000E-03  +2.03988880E-01
   +1.69280000E-03  -1.00296000E-03  +2.25380000E-03  +1.28736900E-02  +6.33112000E-03
   -1.28636900E-02  -2.43590000E-03  +1.01312000E-03  -4.71404000E-03  -7.60100000E-05
   -1.27442000E-03  -1.90470000E-04  -5.15201000E-03  +1.46473000E-03  -3.03125000E-03
   -1.33946300E-02  +2.42143000E-03  +1.51040700E-02  -2.15842900E-02  -4.78632300E-02
   +3.98730000E-03  -4.92270000E-04  +4.39020000E-04  +5.06280000E-04  -7.55800000E-05
   +5.17700000E-05  -4.54700000E-05  +6.19700000E-05  +2.61700000E-05  +8.54300000E-05
   -1.97510000E-04  -2.61200000E-04  -2.00500000E-05  -3.56700000E-05  +2.15100000E-05
   -2.10000000E-06  -3.35300000E-05  +4.38800000E-05  +1.80600000E-05  +3.57100000E-05
   -4.42300000E-05  +9.77000000E-06  +1.22100000E-05  -3.55000000E-06  -2.70000000E-07
   -1.38800000E-05  +1.03500000E-05  -2.46700000E-05  -5.24000000E-05  +3.67500000E-05
   +6.96000000E-06  +1.98940000E-04  -1.58600000E-04  +4.20250000E-04  +7.22340000E-04
   +4.35900000E-05  -6.30030000E-04  +2.56920000E-04  -3.29570000E-04  +2.94400000E-04
   +2.16701000E-03  -1.90184000E-03  +1.63754000E-03  +2.55091500E-02  +4.09561100E-02
   -1.09043000E-03  +2.07519000E-03  +9.16020000E-04  +2.19062600E-02  +4.03907000E-03
   -1.28743200E-02  -3.20800000E-05  -5.07693000E-03  -2.32470000E-03  -1.24926000E-03
   -4.17690000E-04  -3.75680000E-04  -3.35500000E-05  -2.75943000E-03  +2.79677000E-03
   -4.88174000E-03  -6.89410000E-04  +6.78493000E-03  +1.46716990E-01  +3.05558000E-03
   -1.95404240E-01  -1.69760000E-04  -1.45870000E-04  +2.91380000E-04  -1.60900000E-05
   -5.04900000E-05  -2.34800000E-05  +1.74900000E-05  +6.06800000E-05  -2.13200000E-05
   +6.53800000E-05  +1.60300000E-05  +1.19100000E-05  -2.49000000E-06  +6.59000000E-06
   +1.42900000E-05  +1.24000000E-05  -1.27300000E-05  +8.90000000E-07  -2.51600000E-05
   +2.13200000E-05  -3.28000000E-06  -1.25100000E-05  +1.97200000E-05  -8.65000000E-06
   +5.94000000E-06  -2.67000000E-06  +6.80000000E-06  +3.20900000E-05  -1.99600000E-05
   -3.69000000E-06  -1.79130000E-04  +3.63970000E-04  +2.15030000E-04  +8.83540000E-04
   +1.34360000E-04  -8.34030000E-04  -1.07270000E-04  +2.74800000E-04  -1.54200000E-04
   -9.74140000E-04  +1.96155000E-03  -2.38550000E-04  -1.60873750E-01  -2.78713000E-03
   +2.01263740E-01  +2.17200000E-05  -1.30600000E-05  +2.08300000E-05  +3.48800000E-05
   -1.94900000E-05  -1.66990000E-04  -2.20350000E-04  -9.55000000E-06  -2.93000000E-06
   +3.26340000E-04  +2.35170000E-04  +2.81670000E-04  +7.89280000E-04  -1.34734000E-03
   -1.99390000E-04  +2.43260000E-04  +1.31600000E-04  +1.42830000E-04  +1.02170000E-04
   +1.12150000E-04  -4.45400000E-05  -4.13642000E-03  +8.55280000E-04  +1.27813000E-03
   -2.59857830E-01  +1.04466610E-01  +3.87532900E-02  -1.13170000E-04  -2.32180000E-04
   +4.61320000E-04  +7.57050000E-04  +1.54460000E-04  -3.91490000E-04  -1.61760000E-04
   -1.27710000E-04  +3.05650000E-04  +1.34870000E-04  +1.12390000E-04  -1.18200000E-04
   +2.01990000E-04  -4.24700000E-05  -1.02370000E-04  +9.70000000E-07  -1.28780000E-04
   +9.07000000E-05  -1.57580000E-04  -2.92400000E-05  +2.09430000E-04  -2.08780000E-04
   +1.72260000E-04  -4.91000000E-06  -9.41000000E-06  +5.08000000E-06  -1.38000000E-06
   -4.02000000E-06  +1.18300000E-05  +1.70000000E-07  +2.98900000E-05  -6.99200000E-05
   -8.61000000E-06  +2.05500000E-05  +2.77100000E-05  -1.56000000E-05  +2.06800000E-05
   +1.61500000E-05  +6.40000000E-06  +2.79347800E-01  +2.20930000E-04  +2.15510000E-04
   +4.13200000E-05  -2.35660000E-04  -1.60070000E-04  +1.15680000E-04  +1.32720000E-04
   +5.73300000E-05  -7.08500000E-05  -1.75440000E-04  -2.00010000E-04  -5.72520000E-04
   +1.37791000E-03  +7.22440000E-04  -2.57770000E-04  -2.95490000E-04  +1.36990000E-04
   +4.76700000E-05  -1.69820000E-04  -7.75700000E-05  +7.04100000E-05  +2.14332000E-02
   -1.29216200E-02  -3.78305000E-03  +1.02297420E-01  -9.61247000E-02  -1.95960500E-02
   -2.39170000E-04  +3.36870000E-04  -1.31466000E-03  -7.53570000E-04  -3.01460000E-03
   +4.08518000E-03  -6.37280000E-04  -1.46800000E-05  +4.53410000E-04  +1.60270000E-04
   +1.60250000E-04  -4.14000000E-05  -3.12990000E-04  +8.54200000E-05  +1.29300000E-04
   -3.83000000E-06  -1.88890000E-04  +5.97300000E-05  +1.45785000E-03  -2.02300000E-04
   -3.60840000E-04  +2.78560000E-04  -1.73580000E-04  -5.33300000E-05  -8.76000000E-06
   -3.80000000E-05  -1.92900000E-05  +1.18900000E-05  -3.96000000E-06  +1.36600000E-05
   +2.61700000E-05  +8.07500000E-05  +1.48220000E-04  +3.10300000E-05  -2.83000000E-05
   +7.21200000E-05  +7.37000000E-06  -9.47000000E-06  -4.00000000E-06  -1.13693030E-01
   +1.05421390E-01  -1.28280000E-04  -9.88000000E-05  -9.17000000E-06  +1.24160000E-04
   -2.03000000E-06  -1.96270000E-04  -3.73450000E-04  -3.98900000E-05  +1.03650000E-04
   +3.63750000E-04  +5.02700000E-05  -2.24270000E-04  -6.29580000E-04  -3.88230000E-04
   +5.33760000E-04  -1.35910000E-04  -1.63810000E-04  +1.67930000E-04  +1.24110000E-04
   +1.14680000E-04  +5.28000000E-06  -1.97449700E-02  +1.00413100E-02  +1.87791000E-03
   +4.01686600E-02  -2.06171500E-02  -5.42036900E-02  -1.20458000E-03  +5.73790000E-04
   +1.19499000E-03  +4.73060000E-04  +2.93567000E-03  -3.14061000E-03  +7.45190000E-04
   +2.36650000E-04  -1.93890000E-04  -2.07030000E-04  +1.15070000E-04  +1.94160000E-04
   +4.67000000E-06  -1.39460000E-04  +3.99900000E-05  +1.96520000E-04  +2.78340000E-04
   -2.06800000E-04  -1.17196000E-03  +6.04770000E-04  +4.86430000E-04  -6.33700000E-05
   +1.56100000E-05  +2.19100000E-05  +1.35300000E-05  +2.58000000E-06  +1.57800000E-05
   +1.71700000E-05  -1.79300000E-05  +1.20000000E-07  +4.14100000E-05  +7.02000000E-06
   +9.43300000E-05  +2.66100000E-05  +1.02100000E-05  -8.17300000E-05  -2.18000000E-06
   +4.55000000E-06  +9.55000000E-06  -4.27983200E-02  +1.78051200E-02  +5.80377300E-02
   -2.32260000E-04  -1.96810000E-04  -3.05500000E-05  +2.48860000E-04  +1.64160000E-04
   -6.07600000E-05  -1.96220000E-04  -3.71600000E-05  +7.20600000E-05  +2.73330000E-04
   +2.46320000E-04  +4.58400000E-04  +4.40810000E-04  -3.37910000E-04  -1.55130000E-04
   +5.52520000E-04  -2.87400000E-05  -1.74600000E-04  +3.76300000E-05  -3.80300000E-05
   -4.53400000E-05  +2.80183000E-03  +3.70009000E-03  +3.06500000E-04  -1.82916280E-01
   -1.31973740E-01  -1.81209200E-02  +3.78020000E-04  +3.59520000E-04  -8.42600000E-05
   +7.89200000E-05  -1.21950000E-04  +2.52520000E-04  -8.72370000E-04  +7.94350000E-04
   +5.56930000E-04  +1.36050000E-04  +1.42320000E-04  -8.69200000E-05  -1.62400000E-04
   +1.11600000E-05  +5.03200000E-05  +3.04100000E-05  +2.30600000E-05  -1.26900000E-05
   +1.19590000E-04  -8.93200000E-05  -2.50200000E-05  +1.00000000E-04  -4.80400000E-05
   -3.28200000E-05  +1.98600000E-05  +3.59800000E-05  +1.93600000E-05  -2.39800000E-05
   -6.37000000E-06  -1.78200000E-05  -1.15500000E-05  -1.76600000E-05  -1.85900000E-05
   -5.77800000E-05  +6.21800000E-05  +9.47000000E-06  -8.70000000E-06  -3.73000000E-06
   +5.19000000E-06  -1.87254200E-02  -2.03138700E-02  -3.50586000E-03  +1.98255940E-01
   -5.53000000E-04  -4.75710000E-04  -1.54690000E-04  +2.58000000E-04  +4.40800000E-04
   +5.14110000E-04  +1.04920000E-04  +1.68810000E-04  +4.21500000E-05  -3.17700000E-04
   -1.15360000E-04  +2.98330000E-04  +9.62700000E-04  -2.57775000E-03  +3.92690000E-03
   +3.82110000E-04  -4.75890000E-04  -4.71360000E-04  -6.41840000E-04  -2.64630000E-04
   -4.22620000E-04  -1.74249900E-02  -1.60642700E-02  -2.99411000E-03  -1.30633330E-01
   -1.74544240E-01  -1.71048100E-02  -3.17600000E-04  +6.92950000E-04  -1.59370000E-03
   -8.63520000E-04  +4.29010000E-04  -4.59400000E-05  -1.84460000E-04  -2.62880000E-04
   +5.72690000E-04  +3.98870000E-04  +1.51610000E-04  -2.24600000E-04  +1.17410000E-04
   +7.53100000E-05  -1.84640000E-04  -1.48140000E-04  -1.78250000E-04  +2.14210000E-04
   +2.13520000E-04  +6.02000000E-05  +7.15600000E-05  -1.09590000E-04  +1.36550000E-04
   -2.79700000E-05  +3.12200000E-05  +4.55800000E-05  +5.71700000E-05  -2.90600000E-05
   -5.13000000E-05  -3.68400000E-05  -1.57200000E-05  +1.32970000E-04  -6.79900000E-05
   +5.69800000E-05  -7.63800000E-05  +1.54560000E-04  -1.06210000E-04  -8.08000000E-06
   -3.18800000E-05  +1.03453700E-02  +1.08808800E-02  +1.69214000E-03  +1.43972380E-01
   +1.89054200E-01  +3.29020000E-04  +3.21880000E-04  +4.35500000E-05  -3.52180000E-04
   -6.11400000E-05  +2.49620000E-04  +6.44330000E-04  +2.34000000E-06  +3.06400000E-05
   +2.78000000E-06  -3.67830000E-04  -9.95500000E-05  -1.43169000E-03  +2.51570000E-03
   -2.51955000E-03  +5.58900000E-04  +5.12820000E-04  +1.50960000E-04  +6.61700000E-05
   -3.07560000E-04  +1.39490000E-04  +1.63130600E-02  +1.49444600E-02  +5.32360000E-04
   -1.82108100E-02  -1.82820500E-02  -5.08490200E-02  +1.08453000E-03  +7.97550000E-04
   +1.03511000E-03  +2.03970000E-04  -5.77450000E-04  +4.04350000E-04  -3.40940000E-04
   -5.26580000E-04  +4.48130000E-04  -3.45000000E-05  +1.54950000E-04  -1.23940000E-04
   -7.08600000E-05  -5.07600000E-05  +1.06560000E-04  +9.02300000E-05  -3.19000000E-05
   -4.89100000E-05  +1.69700000E-05  +7.04000000E-06  -1.94460000E-04  +2.76200000E-05
   +7.31000000E-06  -2.70100000E-05  +1.80000000E-07  -1.50300000E-05  -4.30900000E-05
   +3.18800000E-05  +1.76800000E-05  +1.76000000E-05  -2.88440000E-04  +3.89910000E-04
   +2.98600000E-05  -3.61800000E-05  +1.19190000E-04  -1.03850000E-04  +4.21900000E-05
   +3.71500000E-05  -1.14100000E-05  +3.97084000E-03  +4.27409000E-03  -3.41380000E-04
   +1.95544000E-02  +1.67004900E-02  +5.27257400E-02  +4.52500000E-05  +4.82500000E-05
   +3.63000000E-06  -1.22600000E-05  -9.98800000E-05  -1.03840000E-04  -2.50270000E-04
   -3.96800000E-05  -2.43700000E-05  -2.47500000E-05  -1.42980000E-04  -4.82500000E-05
   -7.30800000E-05  +4.03620000E-04  +6.25830000E-04  -1.52420000E-04  -1.07740000E-04
   +7.68800000E-05  +1.23390000E-04  +7.30700000E-05  +6.21100000E-05  -1.72871000E-03
   -1.81931000E-03  -4.08608000E-03  -4.70354200E-02  +4.68100000E-04  +2.73514000E-03
   -1.25080000E-04  +8.90560000E-04  -6.28840000E-04  +4.30180000E-04  -3.95890000E-04
   -5.75410000E-04  -1.26730000E-04  +4.05850000E-04  -3.76280000E-04  -1.36860000E-04
   +2.09200000E-05  +1.64740000E-04  -1.52000000E-04  -4.30800000E-05  +9.11900000E-05
   +1.16360000E-04  +8.80200000E-05  -1.41780000E-04  -2.72700000E-05  +6.05000000E-06
   +6.61000000E-06  +1.22370000E-04  -1.13480000E-04  +9.85000000E-06  -7.35000000E-06
   -2.29500000E-05  +4.60000000E-06  +2.26900000E-05  -1.56300000E-05  +1.38700000E-05
   +2.37440000E-04  -1.74620000E-04  +5.48100000E-05  +9.14000000E-06  +2.13500000E-05
   -5.81600000E-05  -1.76000000E-06  +1.00900000E-05  -7.53000000E-06  +6.64860000E-04
   +9.94718000E-03  +2.73826200E-02  +5.15420000E-04  -7.42026000E-03  -2.21712700E-02
   +4.78058100E-02  +1.55500000E-04  +1.04260000E-04  +3.01600000E-05  +3.72100000E-05
   -1.07740000E-04  -2.94600000E-04  -1.32490000E-04  -1.94400000E-04  -1.87600000E-04
   -3.74330000E-04  -2.04800000E-04  +6.50180000E-04  +6.58490000E-04  +1.21777000E-03
   +5.29700000E-05  -3.75390000E-04  -5.02600000E-05  +1.81900000E-05  +2.25510000E-04
   +2.02740000E-04  +1.80250000E-04  -8.12490000E-04  +8.61249000E-03  +2.25014800E-02
   +1.34120000E-04  -8.33528900E-02  -9.23852000E-02  +4.68820000E-04  -3.46818000E-03
   +2.85703000E-03  -3.71560000E-04  +1.15032000E-03  -3.46140000E-04  +5.71420000E-04
   +2.67440000E-04  -1.39830000E-04  +6.96000000E-05  -1.41420000E-04  +8.48400000E-05
   +1.15960000E-04  +8.12900000E-05  -1.40510000E-04  -1.77540000E-04  +3.24000000E-05
   +7.30800000E-05  -1.94450000E-04  -1.80270000E-04  -2.33000000E-05  -7.48300000E-05
   +2.81700000E-05  +2.43700000E-05  -2.30200000E-05  -1.49800000E-05  -1.54300000E-05
   -4.33000000E-06  -4.20000000E-06  +2.46600000E-05  +2.15700000E-05  -1.13514000E-03
   -3.29600000E-05  +5.40800000E-05  -9.72000000E-06  -1.88600000E-05  +1.45700000E-05
   -7.79000000E-06  +5.41000000E-06  -1.10566000E-03  -5.43360000E-03  -1.22328800E-02
   +2.09512000E-03  -7.66427000E-03  -2.00354000E-02  -1.44525000E-03  +8.97094600E-02
   -2.61700000E-05  +4.16000000E-06  -1.17500000E-05  -2.31910000E-04  +2.15700000E-04
   +4.77220000E-04  +5.55830000E-04  +2.81520000E-04  +2.11390000E-04  +1.26360000E-04
   -7.02550000E-04  -1.40630000E-04  -1.21277000E-03  -8.44910000E-04  +5.84950000E-04
   +7.46080000E-04  +1.93670000E-04  -2.71640000E-04  -3.94690000E-04  -3.67540000E-04
   -1.39720000E-04  +4.02570000E-04  -8.76467000E-03  -1.93166000E-02  +2.65678000E-03
   -9.00638900E-02  -2.80410990E-01  -4.22970000E-04  +4.82186000E-03  -2.41997000E-03
   +1.09738000E-03  -7.97810000E-04  +4.62630000E-04  +3.63320000E-04  +1.01490000E-04
   +2.33460000E-04  -3.29600000E-04  +2.23420000E-04  +2.18530000E-04  -9.13500000E-05
   -2.16850000E-04  +1.56250000E-04  +2.46440000E-04  +5.90700000E-05  -1.50420000E-04
   -9.17800000E-05  +3.79850000E-04  +1.33630000E-04  -8.78000000E-06  -1.85700000E-05
   +4.76000000E-06  +1.99500000E-05  +1.30100000E-05  -4.29000000E-06  +3.92900000E-05
   +4.06000000E-06  +8.20000000E-07  -2.52030000E-04  +2.82740000E-04  +2.95540000E-04
   -1.26040000E-04  -1.22100000E-05  +9.64600000E-05  -4.86000000E-06  +1.85800000E-05
   -1.62500000E-05  -4.23780000E-04  -1.25248000E-03  -3.69698000E-03  +3.74040000E-04
   -1.09480000E-04  -1.19049000E-03  -2.43697000E-03  +9.76267000E-02  +3.05557440E-01
   +9.74600000E-05  +1.11520000E-04  +6.03600000E-05  -7.39000000E-05  -2.33900000E-05
   +2.61800000E-05  +1.14090000E-04  +1.03450000E-04  +3.99100000E-05  -8.94700000E-05
   -8.68400000E-05  -5.20600000E-05  +2.85910000E-04  +5.54970000E-04  -2.75470000E-04
   +6.36300000E-05  -2.79630000E-04  -7.53590000E-04  -1.10700000E-04  -9.14000000E-06
   +2.83990000E-04  -1.98984000E-03  +1.40342000E-03  -1.15533000E-03  +5.80000000E-07
   -4.32250000E-04  -5.53550000E-04  -4.82279200E-02  +1.28786100E-02  -1.27520000E-02
   +6.99000000E-05  -8.25910000E-04  +5.41280000E-04  -1.26570000E-04  +8.99400000E-05
   +7.30900000E-05  +1.25580000E-04  -8.62200000E-05  +3.23700000E-05  -1.99800000E-05
   +1.20160000E-04  -5.76400000E-05  -2.74750000E-04  +8.82700000E-05  +1.60800000E-05
   -1.06820000E-04  +1.99330000E-04  -4.90700000E-05  +6.66600000E-05  -4.76900000E-05
   -1.51900000E-05  -8.37000000E-06  -8.53000000E-06  -6.76000000E-06  +1.02300000E-05
   +1.04800000E-05  +1.45600000E-05  -1.94700000E-05  +4.06600000E-05  +6.41200000E-05
   -1.41082000E-03  +1.35470000E-04  -2.37260000E-04  -1.38500000E-05  +2.52000000E-06
   -2.34700000E-05  +3.33350000E-04  -2.88680000E-04  +2.57610000E-04  +1.19070000E-04
   +3.32580000E-04  -1.05530000E-04  +6.26650000E-04  +1.95590000E-04  -1.80850000E-04
   +4.88260300E-02  +7.84800000E-05  +4.14100000E-05  -2.47500000E-05  -9.59600000E-05
   -7.03200000E-05  +1.24570000E-04  +8.12600000E-05  +3.93400000E-05  -3.34600000E-05
   +2.48270000E-04  +5.08600000E-05  +6.22000000E-06  -1.91100000E-04  +6.32450000E-04
   +3.80640000E-04  -7.09110000E-04  +3.00610000E-04  +2.16930000E-04  +4.08300000E-05
   -7.99500000E-05  -2.09720000E-04  -5.80160000E-04  +9.53081000E-03  -1.06053700E-02
   -1.44340000E-04  -6.02160000E-04  -2.11721000E-03  +1.31550500E-02  -1.76440630E-01
   +1.34358990E-01  -2.37060000E-04  +7.09930000E-04  -1.10000000E-06  +1.33300000E-05
   -3.53000000E-06  +8.66900000E-05  -1.78600000E-05  +6.98200000E-05  -6.48200000E-05
   +6.27100000E-05  -2.30200000E-05  +3.44800000E-05  -9.07000000E-05  -1.23100000E-04
   +9.85200000E-05  +2.84000000E-04  -1.50650000E-04  -6.87940000E-04  -1.42920000E-04
   +7.95200000E-05  -2.59000000E-06  -8.73000000E-06  -1.38700000E-05  -5.73000000E-06
   +1.84900000E-05  +1.51700000E-05  +2.91000000E-06  +3.11000000E-06  +9.24000000E-06
   -3.21800000E-05  -2.76920000E-04  -2.66650000E-04  -3.44150000E-04  -9.63000000E-06
   +4.14600000E-05  -1.22000000E-05  -2.11490000E-04  +3.29000000E-06  -1.68070000E-04
   +2.31050000E-04  +1.40380000E-04  -2.41700000E-04  -8.74600000E-05  +7.42300000E-04
   -5.10930000E-04  -1.35639000E-02  +1.90193120E-01  +2.18600000E-05  +1.68200000E-05
   +1.29800000E-05  -1.34580000E-04  +1.16390000E-04  +2.41560000E-04  +2.51140000E-04
   +2.05990000E-04  +2.03000000E-06  +2.12100000E-05  -5.17260000E-04  -1.59440000E-04
   +9.63700000E-04  +9.95660000E-04  +1.23257000E-03  +2.10800000E-04  -2.14540000E-04
   +4.19000000E-06  -2.73740000E-04  -2.45360000E-04  +1.42300000E-04  -1.57232000E-03
   +2.09392200E-02  -2.00140100E-02  +1.09680000E-04  -4.12499000E-03  -5.39292000E-03
   -1.22923200E-02  +1.32199520E-01  -1.85127370E-01  -1.48528000E-03  +9.78440000E-04
   +6.64340000E-04  +7.36590000E-04  -2.73200000E-05  -2.04200000E-04  -4.94050000E-04
   +3.79750000E-04  -3.41400000E-05  -2.13940000E-04  -4.07450000E-04  +3.62480000E-04
   +8.15230000E-04  -4.28820000E-04  +1.15200000E-04  +4.26800000E-05  +5.95980000E-04
   +1.82210000E-04  -7.60400000E-05  +3.48000000E-06  -2.86000000E-06  -1.03000000E-05
   +5.89000000E-06  -9.07000000E-06  -2.34900000E-05  +3.30000000E-05  -2.41800000E-05
   -3.58600000E-05  +9.53500000E-05  +4.84600000E-05  -5.11340000E-04  +1.73150000E-04
   +2.00740000E-04  -2.21200000E-05  -1.78400000E-05  -1.45800000E-05  -7.54000000E-05
   -9.48500000E-05  +2.03030000E-04  +1.09530000E-04  -1.87030000E-04  +3.13720000E-04
   -3.75480000E-04  +1.42629000E-03  -1.46569000E-03  +1.42136000E-02  -1.44535970E-01
   +2.02926970E-01  -1.55920000E-04  -1.57130000E-04  -7.13400000E-05  +8.79200000E-05
   +9.42400000E-05  +2.89000000E-06  -7.21000000E-05  -5.49100000E-05  -1.07220000E-04
   +6.98400000E-05  +3.75200000E-05  +2.75600000E-04  +6.72670000E-04  +1.21150000E-04
   +6.30300000E-05  -1.40890000E-04  +2.59300000E-05  +4.85670000E-04  +1.64650000E-04
   -1.04100000E-04  -2.65070000E-04  -1.91193000E-03  -1.20620000E-04  +8.55670000E-04
   -1.89430000E-04  +9.24000000E-06  +3.73580000E-04  -2.28040460E-01  -1.27747530E-01
   -8.86089000E-03  +7.48850000E-04  +1.27773000E-03  +3.44180000E-04  +2.15800000E-04
   -9.88900000E-05  +6.43700000E-05  +1.41260000E-04  -1.06250000E-04  -6.52400000E-05
   -5.81000000E-06  +1.08230000E-04  -1.13680000E-04  -2.58920000E-04  +1.11600000E-05
   +3.68000000E-06  +3.41290000E-04  -2.44550000E-04  +6.90700000E-05  +4.70300000E-05
   -1.54100000E-05  +1.52700000E-05  +1.42700000E-05  +1.91200000E-05  +1.19300000E-05
   -3.46900000E-05  -1.90000000E-06  -2.45500000E-05  +7.62500000E-05  -3.94900000E-05
   -6.21800000E-05  +1.32980000E-04  -1.20300000E-05  -5.44440000E-04  -2.67000000E-06
   -1.02900000E-05  +1.88800000E-05  +2.78200000E-05  -1.26860000E-04  +3.01100000E-05
   +2.61130000E-04  +3.72510000E-04  -4.94390000E-04  +2.68130000E-04  +2.63280000E-04
   +2.30300000E-05  +2.55478000E-03  +2.65845000E-03  +2.69590000E-04  +2.44326880E-01
   -2.31100000E-04  -1.85670000E-04  -2.04200000E-05  +2.61510000E-04  +1.07330000E-04
   -8.15200000E-05  -6.36300000E-05  -2.72450000E-04  -1.43060000E-04  -9.05540000E-04
   -8.89900000E-05  +1.96500000E-04  +7.38100000E-04  -2.89960000E-04  -2.95239000E-03
   +2.73440000E-04  +2.57980000E-04  -3.34670000E-04  -4.75800000E-05  +1.27240000E-04
   +1.48600000E-05  -1.12727100E-02  -1.00974200E-02  -7.71520000E-04  +6.35930000E-04
   +3.17380000E-04  +9.93830000E-04  -1.26309480E-01  -1.36137460E-01  -5.00550000E-03
   -1.03307000E-03  +3.73530000E-04  +2.32530000E-04  +3.31180000E-04  +1.91250000E-04
   -1.27800000E-05  +1.67210000E-04  -6.30600000E-05  -5.03300000E-05  +2.15730000E-04
   -5.18900000E-05  -1.34730000E-04  -7.73900000E-05  -1.40060000E-04  +1.03890000E-04
   +1.51440000E-04  -3.24080000E-04  +4.95160000E-04  -1.72910000E-04  +1.48690000E-04
   +2.00200000E-05  +2.93900000E-05  +2.87300000E-05  +2.08200000E-05  -5.13500000E-05
   -1.07060000E-04  +4.80000000E-07  +7.62000000E-06  +3.83800000E-05  -7.50900000E-05
   +2.03530000E-04  -2.22230000E-04  +1.72180000E-04  -3.92000000E-05  -4.60000000E-07
   -5.76000000E-06  +1.02970000E-04  +4.79800000E-05  +1.53100000E-05  +2.47000000E-05
   +5.44940000E-04  +9.41400000E-05  +2.12610000E-04  -8.80000000E-06  +1.04000000E-06
   -1.80624000E-02  -1.23139000E-02  -1.72263000E-03  +1.39077310E-01  +1.45888250E-01
   -1.63040000E-04  -9.76800000E-05  +2.39900000E-05  +1.41450000E-04  +1.61790000E-04
   +1.20300000E-05  +1.24470000E-04  -2.22280000E-04  -3.34860000E-04  -1.60351000E-03
   -1.09818000E-03  +2.47240000E-04  +1.22105000E-03  -1.54607000E-03  -5.47427000E-03
   +9.88920000E-04  -7.30000000E-05  -7.07280000E-04  -2.18680000E-04  -5.30300000E-05
   +2.61410000E-04  -2.44490200E-02  -1.77952900E-02  -3.17173000E-03  -9.33110000E-04
   -1.13904000E-03  +1.33585000E-03  -6.89953000E-03  -3.73018000E-03  -4.63882700E-02
   -1.16582000E-03  +6.70800000E-05  +7.53300000E-04  -7.21100000E-05  +1.97350000E-04
   +2.11930000E-04  +2.65300000E-04  -1.74200000E-04  -2.07700000E-05  +2.50690000E-04
   +8.69200000E-05  -2.59780000E-04  -3.90380000E-04  -1.96560000E-04  +2.66680000E-04
   +3.61510000E-04  +1.23000000E-06  -5.90200000E-05  -2.33160000E-04  +1.58310000E-04
   +2.08900000E-05  +2.38800000E-05  +2.57700000E-05  +1.18200000E-05  -1.31520000E-04
   -9.55300000E-05  -3.79100000E-05  -4.53000000E-06  +4.11400000E-05  -4.28000000E-06
   -5.29200000E-05  +4.54900000E-04  +4.43360000E-04  -2.70200000E-05  -3.85500000E-05
   +1.81000000E-06  +7.74600000E-05  +4.62100000E-05  -6.92400000E-05  +2.37940000E-04
   +6.19130000E-04  -6.04370000E-04  +3.35060000E-04  +9.99600000E-05  +2.75620000E-04
   +1.98794400E-02  +1.24227100E-02  +1.27261000E-03  +8.57462000E-03  +8.26444000E-03
   +5.28793600E-02  +7.81600000E-05  +3.86700000E-05  -2.68900000E-05  -1.65170000E-04
   -2.42200000E-05  +1.25200000E-05  +3.18700000E-05  +5.28000000E-06  -3.18000000E-06
   +1.24030000E-04  +1.43770000E-04  +2.61000000E-05  -4.80500000E-05  -9.46000000E-05
   +2.65410000E-04  -6.76920000E-04  -9.68810000E-04  +4.97820000E-04  +1.48770000E-04
   -1.05610000E-04  -2.69690000E-04  +1.27459000E-03  -1.65106000E-03  -7.80500000E-04
   +4.01320000E-04  -2.79310000E-04  -4.10480000E-04  -2.17991740E-01  +1.22548460E-01
   +3.52436400E-02  +4.40080000E-04  +5.13350000E-04  +4.25520000E-04  +5.13350000E-04
   +2.40190000E-04  -7.24800000E-05  -2.79200000E-05  +4.60900000E-05  -4.19500000E-05
   +3.33390000E-04  -1.45170000E-04  -1.09080000E-04  -1.63260000E-04  -2.06610000E-04
   +1.73760000E-04  +2.80010000E-04  -3.49500000E-04  +3.80770000E-04  -3.23210000E-04
   +2.28510000E-04  +3.08100000E-05  -1.86400000E-05  -8.74000000E-06  -8.97000000E-06
   +1.19400000E-05  +2.09300000E-05  +7.00000000E-07  -9.06000000E-06  -4.02000000E-06
   -1.73500000E-05  -7.92940000E-04  -1.70107000E-03  -4.49190000E-04  +3.35800000E-05
   -8.85000000E-06  +2.37200000E-05  +3.04640000E-04  -1.64190000E-04  +2.44440000E-04
   -2.02230000E-04  +9.72500000E-05  +1.07790000E-04  +1.90200000E-04  -2.34510000E-04
   +9.84000000E-06  -1.07695000E-03  -6.82830000E-04  +1.18150000E-04  -1.93920200E-02
   +1.59583200E-02  +3.80816000E-03  +2.36810290E-01  +9.03700000E-05  +1.31420000E-04
   +9.03200000E-05  -2.51700000E-05  -4.21200000E-05  +4.10800000E-05  +1.31900000E-04
   +1.43790000E-04  +7.79900000E-05  -2.70560000E-04  -9.90400000E-05  -1.18950000E-04
   +5.97770000E-04  +4.43300000E-04  +2.59110000E-04  +2.04270000E-04  -4.27530000E-04
   -1.06970000E-03  -2.98190000E-04  +1.49700000E-04  +4.50370000E-04  +1.11714800E-02
   -8.22464000E-03  -1.11059000E-03  -1.56710000E-04  +4.03830000E-04  +1.29499000E-03
   +1.21378680E-01  -1.34885370E-01  -2.51171400E-02  -2.29730000E-04  -3.88400000E-04
   -2.79239000E-03  -3.28530000E-04  -2.22920000E-04  +1.58140000E-04  +6.72960000E-04
   -4.23790000E-04  +1.81500000E-04  -1.81140000E-04  +5.23110000E-04  -3.23850000E-04
   -5.40880000E-04  +2.90960000E-04  -7.58000000E-05  +4.39990000E-04  -1.91600000E-04
   -3.62500000E-04  +3.99240000E-04  -2.54140000E-04  +3.53200000E-05  -2.51000000E-06
   -1.25300000E-05  -3.74000000E-06  +9.03000000E-06  -2.41000000E-06  +1.95400000E-05
   +1.91100000E-05  +4.12100000E-05  +1.28220000E-04  -1.32033000E-03  -1.41796000E-03
   +6.23160000E-04  -1.33000000E-05  -3.00700000E-05  -2.08500000E-05  -1.83160000E-04
   +5.80460000E-04  -8.04300000E-05  -1.53700000E-04  -2.42200000E-05  -1.03780000E-04
   -2.44770000E-04  -5.39400000E-05  +4.84600000E-05  +1.72146700E-02  -1.19270100E-02
   -4.88502000E-03  -1.52312400E-02  +1.20091100E-02  +3.45799000E-03  -1.33244940E-01
   +1.43796280E-01  +6.51100000E-05  +5.63400000E-05  -5.20000000E-06  -1.22750000E-04
   -1.54600000E-05  +1.84100000E-04  +1.58060000E-04  +1.20060000E-04  -2.32000000E-06
   -1.03970000E-04  +3.49400000E-05  -2.62360000E-04  +3.15460000E-04  +6.05410000E-04
   +7.44230000E-04  -2.50040000E-04  +2.03200000E-04  +3.06610000E-04  -1.69300000E-04
   -9.87500000E-05  -5.84400000E-05  +2.43521600E-02  -1.61033700E-02  -5.85199000E-03
   +1.20182000E-03  -8.66050000E-04  +1.29222000E-03  +3.47274800E-02  -2.40758300E-02
   -5.51467000E-02  -1.32898000E-03  -1.71721000E-03  -4.79349000E-03  +5.33800000E-04
   -3.99370000E-04  +4.42000000E-06  +3.20680000E-04  +1.80000000E-07  +3.35280000E-04
   -5.54570000E-04  +1.67040000E-04  +9.84800000E-05  +5.97420000E-04  +1.14090000E-04
   -1.19570000E-04  +5.97800000E-05  +2.87960000E-04  +1.28290000E-04  +6.15290000E-04
   -4.33810000E-04  -1.01900000E-05  -5.28000000E-06  -1.75200000E-05  -5.55000000E-06
   +2.34700000E-05  -1.37000000E-05  +1.12400000E-05  +4.88200000E-05  -4.48000000E-06
   +5.69900000E-05  -3.68900000E-05  -8.47300000E-05  +2.88240000E-04  +4.00000000E-06
   -9.54000000E-06  +2.65000000E-06  -6.27260000E-04  +3.29940000E-04  -6.70270000E-04
   +4.23900000E-05  +1.27340000E-04  -6.17800000E-05  -2.48870000E-04  +7.41500000E-05
   +4.21900000E-04  -1.94203200E-02  +1.22340300E-02  +4.56492000E-03  -8.94960000E-04
   +9.27150000E-04  -7.06320000E-04  -3.90474300E-02  +2.90422500E-02  +5.95414500E-02
   +1.12550000E-04  +9.58700000E-05  +1.43000000E-05  -7.37600000E-05  -8.20400000E-05
   -2.04300000E-05  +1.23900000E-05  +1.74900000E-05  -6.59600000E-05  -4.06100000E-05
   +8.06800000E-05  +1.08370000E-04  -1.58500000E-04  +3.49700000E-05  -2.14880000E-04
   -4.60000000E-06  +4.44900000E-05  -9.08000000E-06  +4.64300000E-05  +3.35800000E-05
   +2.90800000E-05  +1.05510000E-04  -8.41880000E-04  -1.70775000E-03  -1.47796000E-03
   +2.91740000E-04  +8.66270000E-04  +3.66070000E-04  +7.42200000E-05  -6.70400000E-05
   +8.24536000E-03  -1.82819500E-02  +1.18199400E-02  -5.21170600E-02  +3.17442500E-02
   -1.20432300E-02  -1.72339000E-03  +2.02216700E-02  -1.41310400E-02  -2.81927000E-03
   +3.81896000E-03  +1.33875000E-03  -1.58759000E-03  -1.81050000E-04  +6.01520000E-04
   -1.90780000E-03  -4.03770000E-04  +4.56376000E-03  +1.46710000E-04  +9.05150000E-04
   -6.31740000E-04  -1.21800000E-05  -2.12200000E-05  -5.12000000E-06  +9.83000000E-06
   +3.50000000E-06  +1.39000000E-05  +5.58400000E-05  -7.86100000E-05  -7.99000000E-06
   -8.67000000E-06  -1.56200000E-05  +1.36000000E-06  +1.49200000E-05  -1.07000000E-06
   -3.90000000E-07  +2.32580000E-04  -9.42700000E-05  -1.10340000E-04  -9.50150000E-04
   +1.22622000E-03  +4.45880000E-04  -1.34496000E-03  +2.34440000E-04  -3.77500000E-04
   +1.07100000E-05  +1.09100000E-05  -1.54320000E-04  +2.98800000E-05  -4.10200000E-05
   +8.26000000E-06  -4.83400000E-05  -4.23800000E-05  -5.75900000E-05  +5.46467700E-02
   -2.07400000E-05  -2.86100000E-05  -2.00000000E-05  +1.49000000E-05  +3.12400000E-05
   +2.68300000E-05  +9.48000000E-06  -5.31000000E-06  -6.25300000E-05  -1.09810000E-04
   +3.79200000E-05  +1.54660000E-04  -2.02510000E-04  +2.76590000E-04  +2.60310000E-04
   -6.99600000E-05  -7.44000000E-05  -9.00500000E-05  -6.61000000E-06  -1.96200000E-05
   -1.84000000E-06  -2.38770000E-04  -2.06892000E-03  -1.58541000E-03  +1.95898000E-03
   -3.81900000E-05  -4.10500000E-04  +4.33720000E-04  -1.54840000E-04  -9.09600000E-05
   +2.11110000E-03  -3.92384000E-03  +5.92199000E-03  +2.63684700E-02  -2.44503900E-01
   +1.40137520E-01  +3.98454000E-03  -1.23626900E-02  +6.01041000E-03  +2.17972000E-03
   +8.56420000E-04  +1.45453000E-03  +1.41350000E-04  +6.07900000E-05  -7.21590000E-04
   -4.87110000E-04  +2.39319000E-03  +2.80173000E-03  +1.60590000E-04  -4.19030000E-04
   +3.90550000E-04  -4.35000000E-06  -1.70000000E-06  +7.44000000E-06  -6.94000000E-06
   -1.42100000E-05  +3.47000000E-06  -5.85000000E-06  -8.13100000E-05  +2.75000000E-06
   +9.07000000E-06  -1.62000000E-06  -8.09000000E-06  -5.83000000E-06  -1.09400000E-05
   -1.30000000E-06  +1.91310000E-04  +5.61600000E-05  -5.12760000E-04  +1.54919000E-03
   -5.30360000E-04  -3.42510000E-04  -2.02870000E-04  -1.67260000E-04  -3.23510000E-04
   -8.04000000E-06  -6.10000000E-06  -3.65800000E-05  -2.33800000E-05  -1.47000000E-05
   +1.58300000E-05  -5.91800000E-05  -8.83000000E-06  -1.19230000E-04  -3.79355000E-02
   +2.60841620E-01  -6.40500000E-05  -6.80400000E-05  -2.24200000E-05  +4.16100000E-05
   +5.49600000E-05  +8.79000000E-06  -2.46700000E-05  -3.01600000E-05  -1.69800000E-05
   -4.30300000E-05  -4.10000000E-06  +1.49870000E-04  -2.86820000E-04  +2.19320000E-04
   +2.85320000E-04  -8.19800000E-05  -1.10240000E-04  -8.07100000E-05  -7.43000000E-06
   -3.44200000E-05  -1.39000000E-06  -2.40369000E-03  -1.18940000E-03  -2.15803000E-03
   -1.00880000E-04  +7.15380000E-04  +5.87770000E-04  +7.60500000E-04  -1.59330000E-04
   -7.88700000E-05  -3.13743000E-03  +1.72218500E-02  -5.06481000E-03  -7.94075000E-03
   +1.37478610E-01  -1.27713540E-01  -2.50628000E-03  -2.85777000E-03  +2.55130000E-03
   +2.47972000E-03  +4.26730000E-04  +2.78749000E-03  +3.53540000E-04  -4.99050000E-04
   -6.48510000E-04  +4.61941000E-03  +2.62746000E-03  +1.38616000E-03  -6.68700000E-05
   -1.71900000E-05  +2.85300000E-04  -3.09000000E-06  +8.59000000E-06  +7.49000000E-06
   -1.21800000E-05  -1.28400000E-05  -4.59000000E-06  +1.56000000E-06  -2.16000000E-06
   -1.63900000E-05  +5.82000000E-06  +1.40600000E-05  -1.83200000E-05  -1.24000000E-05
   -8.19000000E-06  -1.62000000E-06  -4.23180000E-04  -3.59360000E-04  +2.75600000E-05
   +3.27740000E-04  -1.01049000E-03  -3.46900000E-05  -4.36000000E-04  +8.11700000E-05
   +4.82600000E-05  -6.69000000E-05  -3.93100000E-05  +6.70200000E-05  -4.25000000E-06
   -5.77200000E-05  -1.12890000E-04  -2.07000000E-05  -8.88300000E-05  -2.02950000E-04
   +9.17221000E-03  -1.52988440E-01  +1.28164650E-01  +2.45090000E-04  +2.04170000E-04
   +2.81700000E-05  -3.36230000E-04  -1.51980000E-04  +1.64820000E-04  +3.34610000E-04
   +1.32380000E-04  -7.23200000E-05  -3.95250000E-04  +7.92900000E-05  -3.56900000E-04
   -7.27390000E-04  +8.35070000E-04  -4.37690000E-04  -1.08250000E-04  +7.11100000E-05
   +1.78600000E-05  -1.49030000E-04  -1.61530000E-04  +1.03200000E-05  -8.00000000E-04
   -1.25340000E-04  -9.03920000E-04  -2.45900000E-05  -1.21620000E-04  -9.93000000E-05
   -7.69100000E-05  +1.11920000E-04  +1.22880000E-04  +6.58457000E-03  +6.31930000E-04
   -2.82513000E-03  +1.86873000E-03  +2.05741000E-03  +2.21460000E-04  -3.79160000E-04
   +8.75660000E-04  -8.54820000E-04  -1.66604000E-03  +4.13851000E-03  +9.53510000E-04
   -1.45989100E-02  -1.19176700E-02  +1.86159000E-02  -1.94048680E-01  -6.02880000E-02
   +1.28363110E-01  -1.40545000E-03  -1.23050000E-04  +6.56980000E-04  -2.20100000E-05
   -3.76800000E-05  -1.76800000E-05  +1.29700000E-05  +1.15000000E-05  +1.81100000E-05
   +3.16400000E-05  -2.95600000E-05  +5.94600000E-05  +4.36500000E-05  +2.18100000E-05
   -4.80000000E-07  +1.20400000E-05  -2.01000000E-06  -9.65000000E-06  +6.97900000E-05
   +1.63000000E-06  -5.67000000E-06  -1.28700000E-05  -5.65000000E-05  +3.69600000E-05
   -6.07000000E-06  +8.14000000E-06  -2.64400000E-05  +2.02480000E-04  +1.65410000E-04
   -1.39500000E-04  +1.72000000E-05  -5.84800000E-05  +1.99800000E-05  -2.22700000E-05
   +8.68300000E-05  -2.03180000E-04  +3.41230000E-04  +2.52730000E-04  -9.80700000E-05
   +2.04206390E-01  -1.79310000E-04  -1.55780000E-04  -3.19900000E-05  +2.20850000E-04
   +1.86800000E-05  -1.85570000E-04  -2.59570000E-04  -2.69270000E-04  +7.14700000E-05
   +1.98400000E-04  +3.11740000E-04  +3.60320000E-04  +4.36030000E-04  -6.63000000E-05
   +8.30000000E-06  +5.70500000E-05  -8.40000000E-07  -5.85000000E-06  +1.27470000E-04
   +1.12230000E-04  -5.57000000E-06  -1.57202000E-03  -3.61350000E-04  -9.67110000E-04
   -5.83900000E-05  +1.58100000E-05  -1.14480000E-04  +2.18630000E-04  -6.06730000E-04
   +3.69900000E-04  -2.05677100E-02  -3.54290000E-03  +1.52250800E-02  +2.05429000E-03
   -2.69981000E-03  +4.63273000E-03  +8.35160000E-04  -1.02941000E-03  -2.54580000E-04
   +3.92538000E-03  -2.45990000E-04  +1.91370000E-03  +1.29119100E-02  +6.91869000E-03
   -8.80261000E-03  -6.04068100E-02  -8.39910600E-02  +6.78384900E-02  +6.32720000E-04
   +2.33560000E-04  -7.22070000E-04  -1.86000000E-06  +2.65400000E-05  +9.22000000E-06
   -2.79200000E-05  -1.21600000E-05  -2.08600000E-05  +9.40000000E-07  +3.02200000E-05
   -9.24900000E-05  +8.26900000E-05  -6.98300000E-05  -3.28600000E-05  -1.37100000E-05
   +5.55000000E-06  +4.11000000E-06  +7.05600000E-05  +1.52700000E-05  -2.82300000E-05
   -4.87000000E-06  +8.87900000E-05  +2.20000000E-05  -6.42300000E-05  +3.18800000E-05
   -1.02220000E-04  +2.20550000E-04  -5.94610000E-04  -7.13700000E-04  +4.14700000E-05
   +1.51210000E-04  +1.91600000E-05  +6.72000000E-06  +2.28380000E-04  -3.43740000E-04
   -9.26230000E-04  -1.90510000E-04  +9.45390000E-04  +6.35079500E-02  +8.43711900E-02
   +2.46920000E-04  +1.80230000E-04  +5.11400000E-05  -2.19400000E-04  -1.55270000E-04
   -1.50270000E-04  -8.99500000E-05  -2.31760000E-04  -3.88800000E-05  +1.82520000E-04
   -2.71100000E-04  -1.36810000E-04  -2.50700000E-05  +2.46250000E-04  +2.98220000E-04
   -4.31150000E-04  -3.41230000E-04  +2.87450000E-04  +4.15200000E-05  +1.71100000E-04
   +1.38580000E-04  +3.85400000E-05  -1.60064000E-03  -1.81266000E-03  -2.89850000E-04
   -4.34200000E-05  -2.88700000E-05  +2.20700000E-05  -1.79600000E-04  +1.03350000E-04
   +1.20912200E-02  +4.26319000E-03  -6.97799000E-03  +5.04220000E-04  +4.80714000E-03
   +1.71856000E-03  -9.25380000E-04  -2.32150000E-04  -1.22920000E-04  +1.19263000E-03
   +1.68890000E-03  +3.80038000E-03  +1.67269000E-03  +4.41870000E-03  +1.43510000E-04
   +1.27303240E-01  +6.69102100E-02  -1.47131590E-01  +2.56960000E-04  -3.19400000E-04
   -1.66690000E-04  -3.66700000E-05  -2.17400000E-05  -3.07800000E-05  -1.01600000E-05
   +2.64300000E-05  -7.24000000E-06  +4.93700000E-05  +1.16030000E-04  -2.58700000E-05
   +4.47100000E-05  -3.92100000E-05  -5.28800000E-05  +8.34000000E-06  -5.00000000E-08
   -7.80000000E-06  -5.36400000E-05  +9.10400000E-05  -3.28000000E-06  -3.77000000E-06
   -1.17570000E-04  +1.90600000E-05  +4.21100000E-05  +3.36400000E-05  +3.70000000E-07
   +1.87250000E-04  -3.11410000E-04  -1.03030000E-04  +3.35000000E-05  -1.05910000E-04
   +2.48600000E-05  -3.54400000E-05  +1.95890000E-04  -1.20160000E-04  +7.37790000E-04
   +2.89420000E-04  -2.32600000E-04  -1.41001970E-01  -7.62097400E-02  +1.51310040E-01
   +1.28880000E-04  +8.57700000E-05  +2.39700000E-05  -1.23940000E-04  -8.43200000E-05
   -1.89500000E-05  +3.57600000E-05  -2.71000000E-05  -2.82200000E-05  +5.50000000E-06
   -3.07100000E-05  +1.13100000E-05  +1.01600000E-05  -2.10400000E-05  +1.96000000E-06
   -1.33800000E-05  -1.24800000E-05  +3.87000000E-05  +1.43900000E-05  +1.07700000E-05
   +3.05100000E-05  -1.15790000E-04  -2.18000000E-05  +9.26000000E-05  +6.02700000E-05
   -1.00000000E-05  -1.60200000E-05  +1.04400000E-05  +2.94500000E-05  -2.51800000E-05
   -2.28050000E-04  -1.43400000E-04  +1.98150000E-04  +1.06161000E-03  +8.33810000E-04
   -3.87790000E-04  -5.66081000E-03  +2.71454000E-03  +1.51409000E-03  -4.77942000E-03
   +3.72050900E-02  -2.53805300E-02  -1.98926000E-03  +6.07832000E-03  -1.88673000E-03
   +3.92970000E-04  -2.26250000E-04  -4.55870000E-04  -4.09154500E-02  -3.66386200E-02
   +4.61892200E-02  -3.17400000E-05  -1.21900000E-05  -1.49500000E-05  -8.34000000E-06
   +1.42400000E-05  -2.75000000E-06  -1.83800000E-05  +1.34800000E-05  -2.99900000E-05
   -1.21600000E-05  +7.70000000E-06  -4.57000000E-06  +1.69000000E-06  +6.46000000E-06
   -6.73000000E-06  +1.86200000E-05  -2.75700000E-05  +7.18000000E-06  -1.97600000E-05
   +1.30000000E-06  -4.86000000E-06  -7.57000000E-06  +9.42000000E-06  -6.14000000E-06
   -1.20400000E-05  +9.23000000E-06  +3.51800000E-05  -1.16500000E-05  +6.60000000E-07
   +1.29000000E-05  +2.23500000E-05  -2.21100000E-05  +4.27000000E-06  -2.65280000E-04
   +1.08820000E-04  +6.22700000E-05  +1.82900000E-05  -2.66800000E-05  +4.54300000E-05
   +5.09689200E-02  -1.79400000E-04  -1.68790000E-04  -3.11800000E-05  +1.43050000E-04
   +1.31010000E-04  +5.09300000E-05  -3.87200000E-05  -1.14000000E-06  +5.10800000E-05
   -1.44200000E-05  -8.59000000E-06  -1.52900000E-05  -9.80000000E-06  +1.52270000E-04
   +1.12300000E-05  +5.65000000E-06  -5.86000000E-06  -5.50300000E-05  -3.04200000E-05
   -6.83100000E-05  -4.01000000E-05  +2.72710000E-04  -1.01300000E-04  +9.08400000E-05
   -6.73500000E-05  -1.89000000E-05  +3.62700000E-05  -1.66430000E-04  +7.30700000E-05
   -4.16700000E-05  -2.13600000E-04  +4.03550000E-04  -3.45600000E-04  +1.94000000E-05
   -2.27060000E-04  +1.15998000E-03  +2.59813000E-03  +1.19410000E-04  -1.21483000E-03
   +4.12873000E-03  -2.58751900E-02  +1.44921900E-02  -1.85663000E-03  +3.58908000E-03
   +2.04730000E-04  +2.14900000E-05  -1.50054000E-03  +5.70550000E-04  +2.80859000E-03
   -3.34933950E-01  +2.34448920E-01  +1.43100000E-05  +3.76800000E-05  +1.00100000E-05
   -1.82500000E-05  -9.98000000E-06  -2.31800000E-05  +2.84000000E-05  +2.63700000E-05
   +5.08400000E-05  +1.75700000E-05  +9.18000000E-06  -8.86000000E-06  -1.38000000E-05
   -4.98000000E-06  +4.37000000E-06  -3.12500000E-05  +3.69500000E-05  -6.66000000E-06
   +9.68000000E-06  -2.43500000E-05  +5.74000000E-06  +1.85300000E-05  -8.07000000E-06
   -6.44000000E-06  +2.00400000E-05  -1.35000000E-05  -1.29800000E-05  +9.00000000E-07
   -3.98900000E-05  -2.88300000E-05  -5.13000000E-05  +5.13800000E-05  +7.00400000E-05
   +1.00370000E-04  +1.05500000E-05  -5.81600000E-05  -2.77730000E-04  +2.24820000E-04
   +6.56300000E-05  -6.81212000E-03  +3.59744080E-01  +4.47400000E-05  +3.78700000E-05
   -1.70000000E-06  -3.15400000E-05  -3.27500000E-05  -1.27800000E-05  +7.85000000E-06
   -8.01000000E-06  -1.20300000E-05  -8.00000000E-07  +1.36200000E-05  +3.84800000E-05
   +2.11200000E-05  -6.65500000E-05  -3.16700000E-05  -1.37900000E-05  +1.02000000E-05
   +1.14800000E-05  +2.37200000E-05  +3.49300000E-05  -2.34000000E-06  -1.32160000E-04
   +9.23900000E-05  -1.11800000E-04  +2.19600000E-05  +1.32900000E-05  -2.34200000E-05
   +1.39040000E-04  -8.12700000E-05  +4.81200000E-05  +2.63530000E-04  -2.81250000E-04
   +1.07990000E-04  +2.02060000E-04  +7.47270000E-04  +7.77740000E-04  +1.57386000E-03
   -1.22809000E-03  +5.41640000E-04  -1.69033000E-03  -4.00729000E-03  +1.41565000E-03
   +3.79905000E-03  -4.27969000E-03  +3.22735000E-03  -6.48110000E-04  +7.21680000E-04
   -8.34710000E-04  +1.78958300E-02  +2.56493740E-01  -1.99224020E-01  -8.16000000E-06
   -6.04000000E-06  +3.69000000E-06  -6.28000000E-06  -1.80000000E-07  +1.16000000E-06
   -7.09000000E-06  +5.64000000E-06  -2.45200000E-05  +3.34000000E-06  -1.38300000E-05
   -5.40000000E-07  +9.62000000E-06  +8.20000000E-07  -1.16000000E-06  +1.23000000E-05
   -1.59200000E-05  -1.72000000E-06  -6.79000000E-06  +4.31000000E-06  +4.03000000E-06
   -1.07300000E-05  +3.43000000E-06  -1.17400000E-05  +9.65000000E-06  +1.86900000E-05
   -9.66000000E-06  -4.36000000E-06  +4.44000000E-06  +1.97200000E-05  +1.86600000E-05
   -2.88300000E-05  -6.49300000E-05  +6.74500000E-05  -6.15800000E-05  +8.80000000E-06
   +2.43060000E-04  -8.68000000E-05  +7.44000000E-06  -2.01640400E-02  -2.49292840E-01
   +1.96323790E-01  -2.36510000E-04  -1.79570000E-04  -4.76600000E-05  +2.10320000E-04
   +1.61940000E-04  +6.77500000E-05  -3.74200000E-05  +4.61400000E-05  +3.56100000E-05
   -6.72000000E-05  +4.03600000E-05  +2.24600000E-05  +1.44430000E-04  +2.89100000E-05
   +1.80200000E-05  +6.47300000E-05  +3.33900000E-05  -1.04800000E-04  -3.92400000E-05
   -5.88200000E-05  -8.09400000E-05  +6.64490000E-04  +1.26319000E-03  -1.09947000E-03
   -5.58120000E-04  +1.45800000E-04  +2.12680000E-04  +3.50700000E-05  -1.03250000E-04
   -8.71800000E-05  -3.34900000E-03  -2.09267000E-03  +7.68685000E-03  +2.76792000E-03
   +1.50287000E-03  -3.52664000E-03  -5.37345000E-03  +1.32555000E-03  +4.33545000E-03
   +1.28284000E-03  -2.45922900E-02  +2.20146300E-02  -1.07218140E-01  +2.90507200E-02
   +1.48784900E-02  -2.75742000E-03  +3.89877600E-02  -2.26107000E-02  +5.97063000E-03
   -7.43400000E-03  +1.60020000E-04  +4.16700000E-05  +2.76900000E-05  +2.57600000E-05
   -4.63000000E-06  -2.45400000E-05  -5.14000000E-06  +7.18000000E-06  -9.14000000E-06
   +4.38000000E-05  +2.21700000E-05  -5.77000000E-06  +5.86000000E-06  -1.11400000E-05
   -1.03000000E-05  +7.84000000E-06  -7.34000000E-05  +1.40190000E-04  -1.48560000E-04
   +3.49200000E-05  -3.94000000E-06  +7.52000000E-06  +1.69000000E-05  -9.66000000E-06
   -3.27100000E-05  +2.64800000E-05  -3.86800000E-05  -6.83300000E-05  +2.99100000E-05
   +2.33200000E-05  +7.74000000E-06  -3.34900000E-05  +6.46600000E-05  -3.31000000E-06
   +1.93960000E-04  -6.73800000E-05  -2.09050000E-04  +1.82032000E-03  -1.14053000E-03
   -2.55211000E-03  +4.80640000E-04  -2.08020000E-04  -7.51080000E-04  +4.56634550E-01
   +9.06900000E-04  +8.97620000E-04  +1.25310000E-04  -7.00640000E-04  -6.76620000E-04
   -2.76860000E-04  +1.48650000E-04  +6.47800000E-05  -2.85980000E-04  -3.97400000E-05
   +4.07700000E-05  +1.21440000E-04  -2.56570000E-04  -7.35630000E-04  -2.12300000E-04
   -1.55750000E-04  +5.05500000E-05  +2.78230000E-04  +2.09180000E-04  +4.10710000E-04
   +1.73950000E-04  -1.41794000E-03  -8.22000000E-05  +1.36793000E-03  +8.77930000E-04
   -3.22130000E-04  -2.39300000E-04  +3.00350000E-04  -1.49100000E-05  -9.86000000E-06
   +2.00126000E-03  +2.97012000E-03  +2.21798000E-03  +4.64267000E-03  -5.85749000E-03
   +6.81260000E-04  -3.23904000E-03  +6.81089000E-03  -3.32630000E-04  +6.78105000E-03
   -3.31348800E-02  +2.62687800E-02  +6.62909100E-02  -2.27141990E-01  +9.77776500E-02
   +8.49332000E-03  -2.95453800E-02  +2.08381600E-02  -5.83466000E-03  +6.71312000E-03
   -3.72578000E-03  -4.03900000E-05  -2.08160000E-04  -1.24500000E-05  +9.99500000E-05
   +2.80400000E-05  +1.43290000E-04  -1.96770000E-04  -2.05750000E-04  -2.29040000E-04
   -7.98900000E-05  -6.99000000E-05  +3.67800000E-05  +1.07760000E-04  +8.20000000E-07
   -9.10000000E-06  +2.67100000E-04  -3.11000000E-04  +1.69100000E-05  -5.80600000E-05
   +3.20370000E-04  +1.21300000E-05  -1.91540000E-04  +2.77300000E-05  -1.59540000E-04
   -6.90300000E-05  +4.96300000E-05  +8.50200000E-05  -2.86900000E-05  +1.52430000E-04
   +1.64060000E-04  +1.87900000E-04  -2.38670000E-04  -9.94000000E-05  -1.25360000E-04
   -3.59300000E-05  -1.92670000E-04  -1.80016000E-03  +1.39538000E-03  -2.94128000E-03
   -1.47165000E-03  -1.33627000E-03  +8.10220000E-04  +2.52210800E-02  +3.37146790E-01
   -5.19330000E-04  -4.75010000E-04  -5.78300000E-05  +3.98620000E-04  +3.77410000E-04
   +1.53690000E-04  -6.23300000E-05  +3.55600000E-05  +1.77460000E-04  -2.14600000E-05
   -2.11800000E-05  -1.40300000E-04  -9.56400000E-05  +2.98370000E-04  +1.43370000E-04
   +1.53150000E-04  -1.12100000E-05  -1.78410000E-04  -1.48180000E-04  -2.70170000E-04
   -9.36900000E-05  +1.25513000E-03  -5.40800000E-05  +1.97960000E-04  -2.63840000E-04
   +3.40900000E-05  +6.44400000E-05  -2.72910000E-04  +1.29220000E-04  -9.37700000E-05
   +4.40113000E-03  +4.69003000E-03  +1.47731000E-03  -5.91473000E-03  +2.26168000E-03
   -1.22200000E-04  +7.51812000E-03  -3.01337000E-03  +1.96041000E-03  -1.75440000E-04
   +4.38745200E-02  -2.18152300E-02  -1.14144700E-02  +1.16222550E-01  -1.16408050E-01
   -8.41530000E-04  +4.20106000E-03  +4.72789000E-03  -1.03064000E-03  -3.02219000E-03
   -4.56290000E-04  +4.86400000E-05  +1.01140000E-04  +8.63000000E-06  -2.48300000E-05
   -2.08300000E-05  -5.37100000E-05  +1.21080000E-04  +9.33100000E-05  +1.54010000E-04
   +2.45100000E-05  +6.16500000E-05  -8.26000000E-06  -7.07800000E-05  +5.00000000E-08
   +5.51000000E-06  -1.92590000E-04  +4.50400000E-05  +6.20000000E-06  +2.40100000E-05
   -2.28190000E-04  -3.94000000E-06  +1.40970000E-04  -5.64000000E-06  +9.47800000E-05
   -1.33800000E-05  -6.51900000E-05  -5.36000000E-06  +9.32000000E-06  -8.64800000E-05
   -1.33310000E-04  -1.22170000E-04  +9.54700000E-05  +1.40680000E-04  -2.18050000E-04
   -1.85300000E-04  -7.68100000E-05  -2.00460000E-03  -3.52401000E-03  -1.09033000E-03
   +1.78000000E-04  +1.62370000E-04  -1.54756000E-03  -2.39196480E-01  -2.32028460E-01
   +3.10046610E-01  +4.90300000E-05  -1.89000000E-06  +2.24200000E-05  -8.17500000E-05
   -2.93400000E-05  +2.65000000E-06  +2.93300000E-05  -5.29300000E-05  +2.00000000E-08
   +3.53800000E-05  -4.77900000E-05  -4.88900000E-05  +8.18200000E-05  +5.63400000E-05
   +3.34200000E-05  +2.19200000E-05  -1.15900000E-05  +4.93700000E-05  -2.65600000E-05
   -6.83100000E-05  +3.65100000E-05  +1.02020000E-04  +1.12520000E-04  -4.91500000E-05
   -5.25500000E-05  +1.81000000E-05  -1.54800000E-05  -3.26300000E-05  +2.46700000E-05
   -1.76700000E-05  -8.37480000E-04  +1.39520000E-04  -2.22440000E-04  -6.07470000E-04
   +4.53990000E-04  -2.37900000E-05  +5.20110000E-04  -8.00680000E-04  +5.65700000E-04
   -3.08520000E-04  +4.01911000E-03  -1.51523000E-03  +6.41676000E-03  +3.35356000E-03
   -6.43186000E-03  +2.70439000E-03  +2.67441000E-03  -3.53952000E-03  +6.00240000E-04
   -1.24100000E-03  +5.61010000E-04  -3.30400000E-05  +7.38000000E-06  -2.33700000E-05
   -1.35700000E-05  +1.59800000E-05  -1.84800000E-05  +1.11400000E-05  +3.19300000E-05
   +8.46000000E-06  -3.36000000E-06  +2.67100000E-05  -1.07500000E-05  -1.85800000E-05
   +1.39900000E-05  -6.98000000E-06  -1.49700000E-05  +1.61600000E-05  +9.26000000E-06
   -1.23600000E-05  -4.74600000E-05  +6.43000000E-06  +1.77700000E-05  +2.68000000E-06
   +1.63900000E-05  +2.78300000E-05  +2.82600000E-05  +3.94600000E-05  -1.20500000E-05
   -4.91200000E-05  +5.52000000E-06  -6.36000000E-06  +8.39000000E-06  +4.72000000E-06
   -3.06100000E-05  -1.91200000E-05  +1.25340000E-04  -1.02988000E-03  -2.98950000E-04
   +9.73490000E-04  +9.82500000E-04  -2.18330000E-04  -8.81580000E-04  -3.50689970E-01
   -1.00830110E-01  +2.48330700E-01  +3.42211470E-01  -2.48960000E-04  -2.65900000E-04
   -3.58100000E-05  +2.23280000E-04  +1.91610000E-04  +5.94300000E-05  -6.14900000E-05
   -5.16100000E-05  +6.30500000E-05  +7.85000000E-06  +4.91400000E-05  +1.96500000E-05
   +5.97500000E-05  +1.27990000E-04  -1.54000000E-05  +2.29800000E-05  +2.05800000E-05
   -7.36500000E-05  -1.97700000E-05  -7.07800000E-05  -5.65600000E-05  +2.51850000E-04
   +1.32040000E-04  -6.13900000E-05  -1.61560000E-04  +5.31000000E-06  +4.16800000E-05
   -1.15980000E-04  -3.65900000E-05  +3.70800000E-05  -1.61500000E-04  -1.08033000E-03
   +1.48380000E-04  +5.57400000E-04  +4.51180000E-04  -6.98520000E-04  -1.27541000E-03
   +1.64540000E-04  +1.05468000E-03  +3.29668000E-03  -4.84190000E-03  +3.15466000E-03
   -3.30640700E-02  -1.48842500E-02  +2.62854800E-02  -1.63680000E-03  +2.24051000E-03
   -1.08687000E-03  +1.12332000E-03  +8.42100000E-04  -1.27890000E-03  +2.87000000E-06
   +6.44700000E-05  -1.89000000E-06  -2.99100000E-05  -5.51000000E-06  -4.37400000E-05
   +1.90400000E-05  +2.50600000E-05  +4.34800000E-05  +3.89500000E-05  -6.74000000E-06
   -1.35300000E-05  -2.27700000E-05  +3.99000000E-06  +4.63000000E-06  -3.36700000E-05
   +6.44000000E-05  -2.37100000E-05  +8.69000000E-06  -2.54300000E-05  +7.11000000E-06
   +1.74000000E-05  -5.40000000E-07  -2.17200000E-05  +6.94100000E-05  -2.03700000E-05
   -7.76200000E-05  +5.03000000E-06  -2.63500000E-05  -1.55600000E-05  -5.09000000E-05
   +8.22400000E-05  +8.08000000E-06  +1.33480000E-04  +9.83400000E-05  -5.66000000E-06
   +1.95787000E-03  -3.43390000E-04  -3.82320000E-04  -1.54102000E-03  -2.62740000E-04
   +4.78390000E-04  -6.20850000E-02  -5.71628300E-02  +7.03278000E-02  +9.27129700E-02
   +7.45217600E-02  +1.45850000E-04  +9.84300000E-05  +6.95000000E-06  -1.41820000E-04
   -9.73000000E-05  -1.09100000E-05  +1.97800000E-05  -9.63500000E-05  -3.27600000E-05
   +5.21700000E-05  +3.87000000E-06  +5.00900000E-05  +3.81400000E-05  -7.51000000E-05
   -3.70700000E-05  -6.45100000E-05  +7.96000000E-06  +5.11700000E-05  +3.89500000E-05
   +6.97700000E-05  +1.09000000E-05  -1.40550000E-04  -1.73300000E-05  +1.98100000E-04
   +1.08110000E-04  -4.54900000E-05  -5.94100000E-05  +3.29700000E-05  -6.23500000E-05
   +7.50000000E-05  -1.12010000E-04  -1.63230000E-04  -9.68620000E-04  +1.49900000E-05
   -6.75400000E-04  +4.50050000E-04  +9.28550000E-04  +8.49640000E-04  -6.11250000E-04
   -8.24140000E-04  +2.81452000E-03  +7.22410000E-04  +1.90698200E-02  +8.01647000E-03
   -1.72634700E-02  -5.36180000E-04  -3.29561000E-03  +2.09335000E-03  -1.17510000E-03
   +2.51430000E-04  +4.80490000E-04  -3.92700000E-05  -1.14100000E-05  -8.87000000E-06
   -2.23100000E-05  +1.65700000E-05  -1.84100000E-05  -1.73400000E-05  +3.26400000E-05
   -6.11500000E-05  +8.53000000E-06  -3.22200000E-05  -8.63000000E-06  +2.58800000E-05
   -1.66000000E-06  -2.34000000E-06  +3.95900000E-05  -3.17700000E-05  +1.89900000E-05
   -1.89700000E-05  +1.88200000E-05  +6.67000000E-06  -2.01500000E-05  +1.03700000E-05
   -2.68800000E-05  +1.88600000E-05  +2.84200000E-05  +9.16000000E-06  -1.14200000E-05
   +3.68000000E-06  +2.18400000E-05  +2.76700000E-05  -1.74000000E-05  -3.94900000E-05
   +3.36000000E-05  +8.47400000E-05  +1.20340000E-04  -4.75240000E-04  +8.24580000E-04
   +3.37680000E-04  -1.24400000E-05  -3.04090000E-04  -6.20780000E-04  +2.20993660E-01
   +8.96355600E-02  -1.77073880E-01  -2.37985680E-01  -9.78407500E-02  +1.92190740E-01
end_hess

