# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.26688000    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -8.84658130E+00  -3.63927119E+00  -7.23979563E-01
   006   -6.83764581E+00  -2.05510171E+00  -4.94166714E-01
   006   -4.92466916E+00  -1.92286755E+00  -2.28951874E+00
   006   -2.92444523E+00  -2.78348639E-01  -1.94291169E+00
   006   -2.76015837E+00  +1.27716227E+00  +1.74248310E-01
   006   -4.69499516E+00  +1.11261754E+00  +1.94274983E+00
   006   -6.71287436E+00  -5.29256582E-01  +1.62884881E+00
   006   -5.46265939E-01  +3.12591360E+00  +4.11049672E-01
   006   -9.28665109E-01  +5.24861435E+00  -1.52880095E+00
   006   -3.92664378E-01  +4.33105753E+00  +3.04610084E+00
   006   +1.91901888E+00  +1.69115734E+00  -3.28295925E-02
   006   +3.84168372E+00  +2.45350092E+00  -1.66462007E+00
   006   +6.05315718E+00  +1.05726685E+00  -1.93731514E+00
   006   +6.42579037E+00  -1.15172735E+00  -5.92703138E-01
   006   +4.53224085E+00  -1.97784679E+00  +1.06448567E+00
   006   +2.42811334E+00  -5.09874277E-01  +1.24979242E+00
   008   +8.58131124E+00  -2.50006001E+00  -8.77476413E-01
   001   -8.71012542E+00  -4.57334462E+00  -2.26593743E+00
   001   -4.99336275E+00  -3.11371873E+00  -3.95543790E+00
   001   -1.43887747E+00  -2.22438327E-01  -3.34973804E+00
   001   -4.65591983E+00  +2.27254147E+00  +3.62333478E+00
   001   -8.20028856E+00  -6.41830298E-01  +3.02557670E+00
   001   -2.75278718E+00  +6.14799724E+00  -1.20239480E+00
   001   +5.31178943E-01  +6.69468305E+00  -1.35848298E+00
   001   -9.15720529E-01  +4.52792138E+00  -3.45846164E+00
   001   -2.41425162E-01  +2.89825205E+00  +4.51874853E+00
   001   +1.27849608E+00  +5.53029644E+00  +3.15347023E+00
   001   -2.04110634E+00  +5.50752228E+00  +3.43194573E+00
   001   +3.62380093E+00  +4.15906051E+00  -2.76856668E+00
   001   +7.51926066E+00  +1.67580425E+00  -3.21867681E+00
   001   +8.49069439E+00  -3.96487389E+00  +1.88958209E-01
   008   +4.97334624E+00  -4.17469557E+00  +2.34244812E+00
   001   +3.53964068E+00  -4.56788490E+00  +3.37270282E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -9.30000000E-07  +1.44000000E-06  +2.54000000E-06
   -6.20000000E-07  +1.04000000E-06  +2.02000000E-06
   -1.03000000E-06  +6.30000000E-07  +1.42000000E-06
   -7.20000000E-07  +2.70000000E-07  +7.20000000E-07
   +3.00000000E-08  +4.60000000E-07  +7.40000000E-07
   +6.90000000E-07  +8.50000000E-07  +1.18000000E-06
   +2.10000000E-07  +1.11000000E-06  +1.79000000E-06
   +6.70000000E-07  +4.00000000E-08  -1.50000000E-07
   +3.70000000E-07  +3.00000000E-08  -9.00000000E-08
   +1.36000000E-06  +1.70000000E-07  -1.50000000E-07
   +1.20000000E-07  -3.40000000E-07  -6.60000000E-07
   -2.10000000E-07  -6.90000000E-07  -1.35000000E-06
   -5.70000000E-07  -1.14000000E-06  -1.72000000E-06
   -5.00000000E-07  -1.14000000E-06  -1.67000000E-06
   +2.10000000E-07  -1.16000000E-06  -1.09000000E-06
   -3.00000000E-08  -2.90000000E-07  -5.10000000E-07
   -7.60000000E-07  -1.56000000E-06  -2.23000000E-06
   -1.46000000E-06  +1.21000000E-06  +2.67000000E-06
   -1.71000000E-06  +5.40000000E-07  +1.52000000E-06
   -1.03000000E-06  -2.00000000E-08  +3.60000000E-07
   +1.25000000E-06  +9.80000000E-07  +1.11000000E-06
   +6.20000000E-07  +1.51000000E-06  +2.24000000E-06
   +5.70000000E-07  +3.30000000E-07  +3.60000000E-07
   +6.00000000E-07  -2.20000000E-07  -5.90000000E-07
   -3.10000000E-07  -1.10000000E-07  -8.00000000E-08
   +1.59000000E-06  +2.60000000E-07  -1.40000000E-07
   +1.68000000E-06  -8.00000000E-08  -7.30000000E-07
   +1.72000000E-06  +5.00000000E-07  +1.80000000E-07
   -1.60000000E-07  -8.00000000E-07  -1.28000000E-06
   -7.10000000E-07  -1.49000000E-06  -2.22000000E-06
   -7.10000000E-07  -1.43000000E-06  -2.15000000E-06
   -3.30000000E-07  -3.70000000E-07  -1.24000000E-06
   +9.00000000E-08  -5.00000000E-07  -8.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.98625350E-01  +1.59279610E-01  +3.24436540E-01  -5.04017400E-02  +2.75525130E-01
   +4.91856920E-01  -2.19521040E-01  -1.34447880E-01  -1.40728900E-02  +5.64638540E-01
   -1.09143240E-01  -1.51515140E-01  -4.53913300E-02  +1.96707640E-01  +4.39946400E-01
   +2.38762600E-02  -1.82226700E-02  -9.60626000E-02  -1.29667570E-01  +2.02307490E-01
   +5.97117900E-01  -3.79866300E-02  -1.50209100E-02  +2.72122000E-02  -2.05458980E-01
   -4.36672300E-02  +7.83404500E-02  +5.50296360E-01  -3.51792100E-02  -2.38796000E-03
   +1.89429500E-02  -1.37700000E-03  -1.01955250E-01  -4.60425500E-02  +2.13089020E-01
   +4.30390700E-01  -1.81551000E-03  -1.84031000E-03  +9.02834000E-03  +1.39586120E-01
   -2.19754000E-03  -2.18150560E-01  -1.26675880E-01  +2.24769010E-01  +5.86477610E-01
   +3.27890000E-03  -2.62904000E-03  +4.63350000E-04  -4.58627600E-02  -5.29909000E-03
   +4.23445200E-02  -2.45844040E-01  -1.52481880E-01  -3.11665100E-02  +5.94044760E-01
   +1.85641000E-03  +2.83267000E-03  -8.26518000E-03  -3.49524200E-02  +1.97575300E-02
   +6.07878700E-02  -1.17866160E-01  -1.84465910E-01  -6.11047000E-02  +2.04293490E-01
   +4.11518140E-01  +6.81591000E-03  -3.92442000E-03  -5.48283000E-03  -1.42395000E-03
   +3.07870900E-02  +4.90193700E-02  +2.00131400E-02  -2.50152300E-02  -1.17561420E-01
   -1.60690740E-01  +1.80227250E-01  +5.70058090E-01  -2.08517000E-03  -2.65910000E-03
   -3.21125000E-03  -1.10242000E-02  +1.49294300E-02  +2.80204600E-02  +2.39462800E-02
   -7.68905000E-03  -2.73479200E-02  -1.13789130E-01  -4.22995400E-02  -1.79693100E-02
   +5.24576170E-01  -1.83746000E-03  -8.36720000E-04  +2.41997000E-03  +1.53548500E-02
   -1.09297100E-02  -2.29988900E-02  -3.36574200E-02  -2.45532800E-02  -1.30634200E-02
   -9.28294000E-03  -1.64520030E-01  -1.27109010E-01  +1.54170220E-01  +4.07260520E-01
   -3.66890000E-03  +1.91164000E-03  +5.23573000E-03  +2.94329700E-02  -2.20627500E-02
   -6.89304200E-02  -6.80731100E-02  -4.07546000E-02  +1.90472600E-02  +3.29599200E-02
   -9.07383300E-02  -2.37456370E-01  -1.36774360E-01  +1.60115880E-01  +5.56748570E-01
   +6.12990000E-04  +3.06040000E-03  +9.33123000E-03  +2.77557500E-02  -3.44834800E-02
   -7.77890300E-02  -5.73711700E-02  -2.47328900E-02  +1.92096500E-02  +3.32313300E-02
   +5.08296500E-02  +5.08345200E-02  -2.19030680E-01  -4.99072900E-02  +8.72385400E-02
   +5.42810600E-01  -3.36080000E-04  +4.47115000E-03  -6.75230000E-04  -5.16920000E-03
   -2.91300900E-02  -4.10011400E-02  -2.26533500E-02  -1.38426300E-02  +8.67828000E-03
   +2.44499900E-02  +2.56258500E-02  +6.24500000E-05  -1.51538900E-02  -1.00600030E-01
   -3.20929800E-02  +1.98928980E-01  +4.32387020E-01  +4.16511000E-03  -4.16768000E-03
   -5.43475000E-03  -3.35519900E-02  -1.09257900E-02  +2.13835800E-02  +2.10360500E-02
   +1.02639700E-02  -1.05015000E-02  +1.19119500E-02  -2.72828600E-02  -4.35503900E-02
   +1.37174070E-01  +2.44731000E-03  -2.06690260E-01  -1.25775630E-01  +2.18309140E-01
   +5.98003470E-01  -3.15864000E-03  -3.33308000E-02  -3.80024200E-02  -1.15063950E-01
   +2.53330000E-03  +4.96086100E-02  +3.28374700E-02  +2.32785500E-02  +9.16862000E-03
   -1.74553200E-02  -2.34649900E-02  -2.00397800E-02  -4.12940400E-02  -7.21048000E-03
   +3.97962900E-02  -2.42601530E-01  -1.48223010E-01  -2.78191600E-02  +5.91910010E-01
   -1.40371700E-02  -2.52309000E-02  -3.37691600E-02  -3.66968800E-02  -1.59596740E-01
   -9.13114000E-02  +4.73853800E-02  +2.60026500E-02  -2.40615100E-02  -2.23105300E-02
   -3.84534300E-02  -2.94383800E-02  -3.32999600E-02  +1.96953200E-02  +5.15316200E-02
   -1.13041850E-01  -1.81639510E-01  -5.84592100E-02  +2.14054190E-01  +4.10266490E-01
   -9.41418000E-03  -1.34129400E-02  -2.33824000E-03  -8.30024000E-03  -1.32777570E-01
   -2.58763540E-01  +4.45522700E-02  +9.68670000E-04  -3.61393800E-02  -1.79941100E-02
   -2.74281100E-02  -2.57189500E-02  +1.51090000E-03  +2.59360700E-02  +4.21043100E-02
   +2.32985900E-02  -2.27659000E-02  -1.17960440E-01  -1.68339030E-01  +1.90304130E-01
   +5.87861600E-01  +1.33836000E-03  +1.23525000E-03  -8.31900000E-05  -2.12028000E-03
   -8.39800000E-05  +1.22018000E-03  +3.89253000E-03  +1.78080000E-04  +1.67881000E-03
   -1.83595000E-03  -6.24974000E-03  -6.14489000E-03  -1.34856960E-01  -4.77921300E-02
   +3.64220000E-04  -1.64965200E-02  -1.47687900E-02  -9.50120000E-04  +8.40440000E-04
   -1.67259000E-03  +3.79882000E-03  +4.74488200E-01  +7.65360000E-04  +1.53390000E-04
   +3.84850000E-04  -4.50180000E-04  -7.38500000E-04  -9.48700000E-05  -2.44110000E-04
   +2.55305000E-03  -3.61209000E-03  -1.56428500E-02  -1.42006800E-02  -4.45111000E-03
   -4.84692900E-02  -1.13067610E-01  -1.08399200E-02  -4.44488000E-03  +1.63231000E-03
   +3.60277000E-03  -6.38130000E-04  +4.18059000E-03  -3.10419000E-03  -1.54369000E-03
   +4.81384810E-01  +6.12280000E-04  +1.12342000E-03  +3.57660000E-04  +1.09610000E-04
   -8.41520000E-04  -1.76172000E-03  +1.64234000E-03  -4.87335000E-03  -3.01207000E-03
   -2.15079200E-02  -1.64409000E-02  +1.71237000E-03  -1.63104000E-03  -1.33965300E-02
   -8.57647600E-02  +1.25321700E-02  +1.35254000E-02  +7.32758000E-03  +4.33011000E-03
   -1.69408000E-03  -7.76990000E-04  +7.51910000E-04  +1.75420000E-04  +4.80104010E-01
   -1.12324000E-03  -1.00626000E-03  -2.69120000E-04  +5.79520000E-04  +6.37070000E-04
   +4.74200000E-04  -3.17800000E-04  +5.68910000E-04  +2.02100000E-04  -3.61140000E-04
   -1.05278000E-03  +6.37860000E-04  +9.16310000E-04  -2.01222200E-02  +1.76512300E-02
   -7.35440000E-04  -1.68421000E-03  -9.42070000E-04  -1.26670000E-03  +3.41280000E-04
   -1.01746000E-03  -7.75914600E-02  +6.85014000E-03  -6.67795000E-03  +5.82902590E-01
   -4.74240000E-04  -4.80550000E-04  -1.56930000E-04  +1.58840000E-04  +4.71330000E-04
   +5.46380000E-04  -1.44380000E-04  +7.78850000E-04  +1.40680000E-04  -6.00900000E-05
   -3.72340000E-04  +1.17145000E-03  -6.63472000E-03  -2.52644600E-02  +1.54596900E-02
   +1.59230000E-03  -8.08490000E-04  -9.35030000E-04  -8.27510000E-04  +1.36600000E-05
   -9.63630000E-04  +1.23025100E-02  -1.28040570E-01  +5.05035100E-02  +1.36169300E-02
   +5.16695310E-01  -5.54630000E-04  -4.85710000E-04  -1.93290000E-04  +1.89220000E-04
   +2.66840000E-04  +4.65010000E-04  +2.27080000E-04  +1.53720000E-04  -1.74480000E-04
   -1.53801000E-03  -1.28234000E-03  -2.11730000E-04  +5.44170000E-03  +4.56109000E-03
   +1.32041000E-03  -4.65730000E-04  -3.61990000E-04  -2.43740000E-04  -1.99010000E-04
   -2.75890000E-04  -3.41080000E-04  -1.02549400E-02  +4.70823800E-02  -1.20153830E-01
   -1.35051900E-02  +6.14460100E-02  +5.38514440E-01  -5.40540000E-04  -4.42230000E-04
   -7.78900000E-05  +4.02690000E-04  +2.69090000E-04  +9.44500000E-05  +3.65980000E-04
   -9.33720000E-04  -9.03320000E-04  -4.31526000E-03  -2.77622000E-03  +8.37370000E-04
   -1.72477000E-03  -1.19980300E-02  -2.53361400E-02  -1.15614000E-03  -6.56260000E-04
   -9.49200000E-04  +1.34560000E-04  -2.03670000E-04  -6.89120000E-04  -7.56978700E-02
   -9.81090000E-04  -1.47499000E-03  +2.52650000E-04  -1.11039000E-03  -4.90971000E-03
   +5.86018730E-01  -9.01700000E-05  -9.58300000E-05  -3.66600000E-05  -9.15400000E-05
   +1.02570000E-04  -1.07750000E-04  +2.16920000E-04  -5.61320000E-04  -7.73050000E-04
   -3.46511000E-03  -1.12594000E-03  +4.80660000E-04  -4.67495000E-03  -1.20280000E-02
   -2.14664800E-02  -5.33500000E-04  -7.72940000E-04  +5.60820000E-04  +5.42350000E-04
   -3.36130000E-04  -7.46660000E-04  -4.18527000E-03  -9.18557400E-02  -3.84977700E-02
   +9.44640000E-04  +8.88436000E-03  +2.36392100E-02  -3.10066000E-03  +5.65594850E-01
   +3.26530000E-04  +2.57450000E-04  +5.30000000E-06  -2.98310000E-04  -1.13880000E-04
   +2.24350000E-04  +4.40980000E-04  +1.69330000E-04  +4.03500000E-05  +6.73160000E-04
   +8.87400000E-04  +1.97040000E-04  -5.42920000E-03  -4.19613000E-03  -3.20805000E-03
   +1.06872000E-03  +7.02610000E-04  +4.17490000E-04  +3.04390000E-04  +1.03700000E-05
   -3.04880000E-04  -6.82362000E-03  -3.60054000E-02  -1.57683500E-01  -2.36521000E-03
   -5.02610000E-03  -3.44605500E-02  -8.98161000E-03  -5.15210800E-02  +4.87437040E-01
   -3.23900000E-05  -5.38100000E-05  -6.60400000E-05  -1.82470000E-04  +1.40120000E-04
   +5.68750000E-04  +3.99100000E-04  +5.90730000E-04  +6.76080000E-04  -1.31559000E-03
   +7.37170000E-04  -4.50990000E-04  -3.53043300E-02  +6.12456000E-03  +5.85780000E-03
   -6.51320000E-04  -2.50170000E-04  -2.18823000E-03  -1.35200000E-04  -1.09673000E-03
   +5.21380000E-04  -1.45667260E-01  +4.34749500E-02  +1.36883000E-02  -6.78540000E-03
   +8.85630000E-03  -2.48949000E-03  -3.56203000E-03  +6.26974000E-03  +9.42734000E-03
   +5.30715490E-01  -9.18430000E-04  -8.87810000E-04  -2.72670000E-04  +3.42740000E-04
   +8.70530000E-04  +6.51210000E-04  -4.22000000E-05  -1.16320000E-04  +2.23570000E-04
   -2.31779000E-03  -1.24640000E-04  -1.98860000E-04  -1.60779800E-02  +1.15101000E-02
   +4.20185000E-03  -1.33479000E-03  -1.76808000E-03  -1.85860000E-03  -5.09900000E-04
   -1.37031000E-03  +3.11840000E-04  +3.55670200E-02  -9.89766500E-02  +3.43791000E-03
   +2.43154500E-02  -1.65642000E-02  -2.95222000E-03  +1.44039100E-02  -1.17334200E-02
   -9.66659000E-03  -9.98668100E-02  +5.05979600E-01  -9.54900000E-05  -1.90490000E-04
   +8.17400000E-05  +9.21600000E-05  -4.12000000E-06  -2.86290000E-04  -3.97390000E-04
   +1.95350000E-04  -4.18800000E-05  -2.07898000E-03  -1.47990000E-03  -2.89940000E-04
   +3.74413000E-03  +9.38400000E-04  +7.39150000E-04  -4.95870000E-04  -3.52100000E-04
   +2.65520000E-04  +6.08000000E-05  +3.82060000E-04  +1.58060000E-04  +2.16903500E-02
   -2.31884000E-03  -7.65981600E-02  -2.05520900E-02  +1.17246300E-02  +3.88128000E-03
   +2.71672400E-02  -1.85405600E-02  -9.84907000E-03  -1.35830950E-01  -1.76026470E-01
   +3.73671190E-01  -9.32400000E-05  -6.28400000E-05  +5.76000000E-06  +1.77660000E-04
   +3.24000000E-05  -3.75590000E-04  -2.76480000E-04  -3.20590000E-04  +1.30810000E-04
   +6.67110000E-04  -4.72400000E-05  +4.27280000E-04  -1.34842000E-03  +1.46735000E-03
   +7.53940000E-04  -7.64480000E-04  -7.57970000E-04  -9.19300000E-05  +1.33780000E-04
   +1.06630000E-04  +3.21100000E-04  -1.68891100E-02  -4.14966000E-03  +1.50563100E-02
   -1.14151000E-03  -2.55120000E-04  +1.28007000E-03  -8.49550000E-04  -1.14544000E-03
   -1.08369000E-03  -2.13192770E-01  +3.33341000E-03  +8.20066700E-02  +5.62492350E-01
   +1.40040000E-04  +8.26900000E-05  +2.02900000E-05  -2.05390000E-04  +2.94600000E-05
   +2.62320000E-04  +2.99140000E-04  +3.19330000E-04  -9.53900000E-05  -4.81560000E-04
   +2.32860000E-04  +6.09900000E-05  +1.07284000E-03  -1.88677000E-03  -1.40646000E-03
   +9.09980000E-04  +7.76840000E-04  +2.71900000E-05  -9.09200000E-05  -8.75700000E-05
   -3.13700000E-04  +1.08673100E-02  +1.09535400E-02  -9.39347000E-03  +8.85460000E-04
   -2.81550000E-04  -5.28650000E-04  +1.66317000E-03  -9.80340000E-04  -3.23790000E-04
   -5.76944100E-02  -1.19599410E-01  +7.18524900E-02  -1.29696910E-01  +5.66059850E-01
   -2.61370000E-04  -2.69070000E-04  -3.68300000E-05  -5.73100000E-05  +2.45230000E-04
   +4.84790000E-04  +2.74970000E-04  +4.20390000E-04  +1.58570000E-04  -8.37230000E-04
   -5.37200000E-05  -8.13110000E-04  -2.29801000E-03  +1.62860000E-04  -3.41100000E-05
   +4.01430000E-04  +3.88610000E-04  -1.95060000E-04  -2.50990000E-04  -5.66120000E-04
   -1.66470000E-04  +5.20939000E-03  -1.46102000E-03  +2.30694000E-03  -3.13540000E-04
   -5.95720000E-04  -3.61310000E-04  -4.65210000E-04  +6.09660000E-04  +4.99900000E-05
   +1.26260180E-01  +3.86496500E-02  -1.62764020E-01  -1.55487740E-01  -2.37783720E-01
   +3.89616010E-01  -1.64880000E-04  -1.52690000E-04  -7.21700000E-05  +7.71900000E-05
   +1.65270000E-04  +2.64670000E-04  +1.62470000E-04  +7.04800000E-05  -1.27600000E-04
   -2.86410000E-04  +1.12690000E-04  +1.70000000E-06  -3.60490000E-04  +6.16770000E-04
   +3.11960000E-04  +1.40400000E-04  +1.13060000E-04  -2.33200000E-04  -1.05590000E-04
   -2.22430000E-04  -1.24110000E-04  +8.05460000E-04  -1.46009000E-03  +3.64699000E-03
   +1.44280000E-04  -5.37980000E-04  +4.86500000E-05  -1.43362000E-03  +6.93390000E-04
   +4.08000000E-05  -4.30797600E-02  -2.15014700E-02  +4.33811400E-02  -2.62892420E-01
   +1.34343020E-01  +2.15958600E-02  +6.27551640E-01  +2.38390000E-04  +2.66510000E-04
   +8.31300000E-05  -4.37100000E-05  -2.90150000E-04  -3.93080000E-04  -2.07920000E-04
   -1.67530000E-04  +1.19240000E-04  +5.50790000E-04  -2.34900000E-05  -2.32800000E-05
   +7.33640000E-04  -5.98480000E-04  -4.03500000E-04  -1.96790000E-04  -1.62370000E-04
   +3.62570000E-04  +1.94650000E-04  +3.71570000E-04  +1.64080000E-04  -2.72350000E-04
   +1.60610000E-03  +3.05658000E-03  +5.36430000E-04  -5.09780000E-04  -1.74850000E-04
   +1.34270000E-04  -4.38590000E-04  +3.52920000E-04  +1.75545300E-02  +4.68082800E-02
   -3.84916700E-02  +8.38922200E-02  -1.68049760E-01  +2.79473400E-02  -1.14958490E-01
   +5.44441250E-01  +1.37400000E-05  +1.60200000E-05  +2.31400000E-05  -1.74100000E-05
   -2.74300000E-05  +5.81000000E-06  -1.05800000E-05  +3.35300000E-05  +2.29400000E-05
   +1.26650000E-04  -1.17540000E-04  -2.54750000E-04  +1.00591000E-03  -6.84360000E-04
   -3.15880000E-04  +1.61650000E-04  +1.70820000E-04  +1.98110000E-04  -1.96400000E-05
   +4.97900000E-05  -7.46100000E-05  +3.36909000E-03  +4.45453000E-03  +1.80243000E-03
   -6.33050000E-04  +4.00070000E-04  -1.26400000E-05  -1.25171000E-03  +7.03140000E-04
   +1.50990000E-04  +1.57064000E-02  -1.67718800E-02  +8.83869000E-03  +5.68986000E-02
   +2.23070000E-04  -9.18330600E-02  -2.04984430E-01  -2.29112560E-01  +4.07103710E-01
   +9.12250000E-04  +7.77300000E-04  +1.34280000E-04  -7.60310000E-04  -6.03260000E-04
   -1.16050000E-04  +3.35990000E-04  -4.39900000E-05  -3.43860000E-04  -1.10120000E-04
   +1.14090000E-04  +1.96680000E-04  -1.30140000E-04  -5.92330000E-04  +3.25300000E-05
   +2.96300000E-05  +1.96610000E-04  +1.27610000E-04  +1.52670000E-04  +2.30090000E-04
   +1.23370000E-04  -2.64661000E-03  +8.57800000E-05  +2.28370000E-04  +4.10460000E-04
   +2.26140000E-04  -2.76620000E-04  +7.48880000E-04  -1.65210000E-04  -9.15000000E-06
   -2.82400000E-03  -2.34172200E-02  +2.02109400E-02  +2.19758400E-02  +2.47851100E-02
   -2.83751500E-02  -1.23025280E-01  +5.78411400E-02  -6.90716000E-03  +5.93025760E-01
   -4.78940000E-04  -4.43180000E-04  -1.13010000E-04  +2.59310000E-04  +4.31230000E-04
   +3.83200000E-04  +1.16960000E-04  +1.32040000E-04  +1.45300000E-05  -2.94910000E-04
   -7.38600000E-05  -1.92090000E-04  -5.00270000E-04  +9.59480000E-04  +3.86730000E-04
   +1.30200000E-04  +9.97300000E-05  -2.85360000E-04  -2.17910000E-04  -4.25440000E-04
   -1.64850000E-04  -1.93100000E-04  -1.51075000E-03  +5.43010000E-04  -2.90230000E-04
   -4.30900000E-05  +7.90500000E-05  -8.86600000E-04  +7.28070000E-04  -3.66290000E-04
   -2.23526500E-02  -3.21449000E-02  +3.68128300E-02  +6.45507600E-02  -3.25271000E-02
   -1.09222400E-02  +7.28060000E-04  -2.59870060E-01  +1.37646640E-01  -1.42498030E-01
   +5.97645330E-01  -2.07710000E-04  -1.51070000E-04  -1.83100000E-05  +2.61250000E-04
   +9.77400000E-05  -1.65890000E-04  -1.90710000E-04  -8.74300000E-05  +1.64990000E-04
   +2.42220000E-04  +5.20500000E-05  +1.72610000E-04  +1.69860000E-04  -4.04100000E-05
   -3.61470000E-04  -7.90600000E-05  -1.83080000E-04  +4.82000000E-05  +6.89800000E-05
   +9.96800000E-05  +4.16600000E-05  +7.86370000E-04  +2.71530000E-04  -1.54099000E-03
   -7.33600000E-05  +8.72000000E-05  +2.17650000E-04  +4.95570000E-04  -4.36300000E-04
   +1.78640000E-04  +1.85331200E-02  +3.70060400E-02  -3.46862600E-02  -5.65381600E-02
   +1.05980300E-02  +2.60862800E-02  +3.36161200E-02  +1.05178250E-01  -1.56909800E-01
   -1.55207390E-01  -2.36343660E-01  +3.99674510E-01  +1.85200000E-05  +5.04800000E-05
   +3.95800000E-05  +7.60800000E-05  -1.42930000E-04  -3.97180000E-04  -3.50810000E-04
   -2.82500000E-04  +1.84170000E-04  +5.40820000E-04  -1.97320000E-04  +2.40410000E-04
   +6.87680000E-04  -3.09700000E-05  -3.05020000E-04  -4.25690000E-04  -4.62920000E-04
   +3.09000000E-04  +1.75370000E-04  +3.04450000E-04  +1.86270000E-04  +2.64029000E-03
   +9.04800000E-04  -2.27530000E-04  +2.12210000E-04  -2.00230000E-04  +4.16830000E-04
   -1.00940000E-04  -1.08940000E-04  +2.73120000E-04  +1.48478600E-02  +5.83194600E-02
   -4.93095700E-02  -6.21563400E-02  +7.28880000E-03  +3.02721100E-02  +4.44794800E-02
   -5.92568600E-02  +1.87825200E-02  -1.86954180E-01  +6.07995000E-03  +5.93420500E-02
   +5.98790600E-01  -9.24070000E-04  -9.10870000E-04  -1.43020000E-04  +7.11630000E-04
   +7.12160000E-04  +4.19270000E-04  -7.16500000E-05  +8.26400000E-05  +2.33030000E-04
   -9.19300000E-05  +2.42220000E-04  -1.73600000E-04  -4.81450000E-04  +5.50860000E-04
   +1.66540000E-04  +3.99000000E-04  +1.12240000E-04  -4.30010000E-04  -2.71040000E-04
   -4.64140000E-04  -2.59140000E-04  -1.77850000E-04  -2.39965000E-03  +4.84438000E-03
   +7.65310000E-04  -2.72320000E-04  -4.70410000E-04  -9.89360000E-04  +5.95580000E-04
   +3.54830000E-04  +3.02391000E-02  -2.69895300E-02  +1.34955000E-03  +5.59300000E-03
   +5.90357000E-03  -6.39303000E-03  -2.18530500E-02  -6.16417000E-03  +1.91254500E-02
   -7.44629600E-02  -1.13503340E-01  +7.10527300E-02  -1.61122770E-01  +5.65473410E-01
   +7.38140000E-04  +6.96000000E-04  +9.22500000E-05  -5.66210000E-04  -5.27100000E-04
   -1.79660000E-04  +1.82080000E-04  -8.54000000E-06  -3.40470000E-04  -6.35000000E-06
   -1.67760000E-04  +7.12400000E-05  +8.09090000E-04  -4.25760000E-04  +8.33200000E-05
   -2.98550000E-04  +4.36200000E-05  +2.98200000E-04  +1.62500000E-04  +3.49560000E-04
   +1.45920000E-04  +3.90040000E-04  +2.92117000E-03  -1.87470000E-04  -3.97240000E-04
   +2.71150000E-04  +1.00620000E-04  +2.30030000E-04  +1.03430000E-04  +8.76200000E-05
   -2.92592800E-02  -1.37962100E-02  +2.76807700E-02  +3.32918900E-02  -6.66402000E-03
   -1.16349100E-02  -8.66520000E-03  +4.15259400E-02  -2.11142300E-02  +1.16278710E-01
   +2.36510000E-02  -1.56036700E-01  -1.53920390E-01  -2.10063780E-01  +3.65065710E-01
   +1.78730000E-04  +9.76400000E-05  +2.22600000E-05  -2.81570000E-04  -5.57000000E-06
   +3.57790000E-04  +6.41890000E-04  +4.68470000E-04  -3.23860000E-04  -1.44834000E-03
   -6.36590000E-04  -1.27843000E-03  +2.00390000E-04  +1.56789000E-03  +6.43980000E-04
   -4.26580000E-04  +3.06900000E-04  -9.20900000E-05  -7.77300000E-05  -1.31780000E-04
   +5.59000000E-05  -6.38090000E-03  +2.25114200E-02  -1.40674100E-02  -4.43037000E-03
   +1.93651000E-03  +1.59877000E-03  -4.42870000E-04  +7.58270000E-04  -1.40238000E-03
   -9.28936600E-02  +3.97261000E-02  -4.81951000E-03  +4.16759800E-02  -1.41478300E-02
   -4.84158000E-03  -2.65538800E-02  +2.75606100E-02  -5.59935000E-03  -5.16030000E-02
   -1.37363700E-02  +4.48100800E-02  -2.69130830E-01  +1.47272230E-01  +2.46464400E-02
   +4.11171330E-01  +1.32300000E-05  +5.18500000E-05  +4.53000000E-05  -2.53000000E-05
   -9.50300000E-05  -1.10700000E-05  -1.52900000E-05  +1.60660000E-04  +1.59670000E-04
   -2.66000000E-04  -3.13690000E-04  -7.80600000E-04  -3.36790000E-04  +1.63410000E-04
   +3.76910000E-04  -8.73600000E-05  -1.64340000E-04  +1.89470000E-04  -5.57000000E-05
   -1.34400000E-05  +1.76910000E-04  +1.38562500E-02  -1.86985600E-02  +4.04009000E-03
   +1.28859000E-03  +2.91660000E-04  -6.12600000E-04  +4.72870000E-04  -3.86790000E-04
   +1.28111000E-03  +6.05390600E-02  -2.52157920E-01  +1.07271100E-01  -6.32205300E-02
   -1.60440500E-02  +5.60759300E-02  +3.44696300E-02  -4.73011900E-02  +1.28236100E-02
   +3.27206900E-02  +5.05149400E-02  -4.88848900E-02  +1.19895070E-01  -1.76682740E-01
   +2.23225300E-02  -2.27992480E-01  +4.92135330E-01  -8.54300000E-05  -8.36900000E-05
   -2.78900000E-05  +8.29700000E-05  +1.38220000E-04  +1.95940000E-04  +7.82000000E-05
   +1.72860000E-04  +2.75800000E-05  -5.18180000E-04  +5.14070000E-04  -3.28400000E-05
   -1.03702000E-03  -4.67600000E-05  +2.12500000E-04  +6.35480000E-04  +3.20570000E-04
   -5.63060000E-04  -1.75270000E-04  -1.73750000E-04  -1.88740000E-04  -6.65911000E-03
   -1.33980000E-03  +4.30742000E-03  +1.46670000E-03  -2.49440000E-04  -3.45740000E-04
   +1.43198000E-03  -1.45936000E-03  -3.55670000E-04  -1.92776600E-02  +1.19373030E-01
   -1.25351310E-01  +2.86409000E-02  +2.77597200E-02  -2.42785600E-02  -1.01012100E-02
   +1.67188800E-02  -7.73163000E-03  +1.08620500E-02  -2.19152800E-02  +1.68313000E-02
   +4.50331900E-02  +7.28482000E-03  -7.62436300E-02  -3.66548500E-02  -1.68477030E-01
   +2.08417320E-01  -1.07191000E-03  -9.36890000E-04  -1.91980000E-04  +8.16310000E-04
   +7.69890000E-04  +3.30730000E-04  -2.38760000E-04  +9.58100000E-05  +2.79670000E-04
   -1.71110000E-04  -2.93300000E-05  -1.30690000E-04  -1.78150000E-04  +1.04178000E-03
   +8.10800000E-05  +1.20680000E-04  -9.27900000E-05  -3.79360000E-04  -2.42570000E-04
   -4.39990000E-04  -2.40920000E-04  +1.94960000E-03  -6.47610000E-04  +6.91280000E-04
   -5.27460000E-04  -1.40080000E-04  +3.65540000E-04  -1.42512000E-03  +5.56190000E-04
   -3.81150000E-04  -1.21274000E-03  +4.65597000E-03  -4.39621000E-03  -1.31687000E-03
   -1.95903000E-03  +4.26779000E-03  -6.11819000E-03  +1.65327200E-02  -4.42963000E-03
   -2.50961170E-01  +8.89457700E-02  +5.77904100E-02  -4.94600400E-02  +3.39727700E-02
   +1.08114600E-02  +2.55744000E-03  -5.75638000E-03  +5.33797000E-03  +3.41504620E-01
   +7.11350000E-04  +6.47860000E-04  +1.26470000E-04  -5.22410000E-04  -5.18410000E-04
   -2.19110000E-04  +1.51740000E-04  -2.71500000E-05  -1.94190000E-04  +8.49200000E-05
   +1.25920000E-04  +9.82500000E-05  +5.17300000E-05  -8.47170000E-04  -1.59680000E-04
   +1.32900000E-05  +1.13110000E-04  +2.29910000E-04  +1.62170000E-04  +3.08780000E-04
   +1.36600000E-04  -1.14053000E-03  +7.86720000E-04  -3.59810000E-04  +4.53850000E-04
   +4.82500000E-05  -2.57170000E-04  +9.99110000E-04  -4.58100000E-04  +2.87970000E-04
   +3.14587000E-03  -1.56434000E-03  -1.66950000E-03  -4.34691000E-03  +6.27790000E-04
   +4.51279000E-03  +4.51706200E-02  -2.76560800E-02  -1.82001000E-03  +1.28516870E-01
   -1.47551830E-01  +2.53706000E-03  +6.87403000E-03  -2.16735000E-03  +5.63283000E-03
   -1.32116000E-03  +4.40110000E-04  +3.76035000E-03  -1.31447000E-01  +5.11142370E-01
   +9.91000000E-05  +8.11900000E-05  +2.79200000E-05  -9.84800000E-05  -5.96000000E-05
   -1.18000000E-06  +4.07500000E-05  +1.27900000E-05  -2.73300000E-05  -7.96000000E-06
   -2.41600000E-05  -7.03200000E-05  -7.47900000E-05  -6.52700000E-05  +3.87200000E-05
   +2.86700000E-05  +3.07100000E-05  +3.44600000E-05  -1.06200000E-05  -1.58100000E-05
   +2.09300000E-05  -8.48700000E-05  +1.01970000E-04  +2.98410000E-04  +1.00870000E-04
   +1.34500000E-05  -3.30900000E-05  -3.47300000E-05  +6.39900000E-05  -5.19600000E-05
   -2.77494000E-03  -3.03085000E-03  +1.68202000E-03  +5.82780000E-03  +3.11988000E-03
   -1.62217000E-03  -2.44219100E-02  +1.44095600E-02  +1.02529800E-02  +3.04292900E-02
   +2.47829800E-02  -7.42517200E-02  +3.03004500E-02  -1.01504900E-02  +1.06750000E-03
   +2.17402000E-03  +6.78096000E-03  -1.14705000E-03  -8.69970200E-02  -2.61794880E-01
   +2.57582640E-01  -3.89916900E-02  +2.26623000E-02  +7.15322400E-02  -1.57708000E-03
   -2.26029900E-02  -3.50132400E-02  +1.28061000E-03  -1.36570000E-04  -2.42832000E-03
   -6.29870000E-04  -1.30530000E-04  -2.31880000E-04  -8.78000000E-05  +2.70180000E-04
   +6.14900000E-04  +1.53807000E-03  -6.97360000E-04  -7.88380000E-04  -4.50098000E-03
   -4.12252000E-03  +8.31830000E-04  -1.63780000E-04  +6.41000000E-06  +1.05230000E-04
   +3.83100000E-05  -6.80000000E-07  -1.48900000E-05  +6.97400000E-05  +3.08700000E-05
   -1.90400000E-05  -1.75600000E-05  -2.90000000E-06  +9.76000000E-06  -3.54000000E-06
   -1.73000000E-06  +2.52700000E-05  +9.18000000E-06  -9.95000000E-06  +1.07100000E-05
   -1.21010000E-04  +4.98800000E-05  +3.31500000E-05  +2.85000000E-06  +5.31100000E-05
   -5.20400000E-05  +3.04000000E-06  +3.58100000E-05  +9.99000000E-06  +1.28180000E-04
   -6.92700000E-05  -1.08400000E-05  +4.41344200E-02  -3.00232000E-03  -1.48571120E-01
   -2.13621780E-01  +1.16292000E-03  -2.03945300E-02  -2.75635100E-02  +3.18220000E-03
   +2.19190000E-03  +1.21167000E-03  +5.43400000E-05  -8.96430000E-04  -3.88670000E-04
   -1.91200000E-05  +3.83530000E-04  +5.72890000E-04  +2.41200000E-04  +6.65340000E-04
   -1.78692000E-03  -4.91707000E-03  -8.37520000E-04  +8.11030000E-04  -1.66800000E-04
   -8.45400000E-05  +8.42000000E-06  +7.00400000E-05  +2.04600000E-05  +2.71500000E-05
   +7.36600000E-05  +9.59000000E-06  -2.84000000E-05  +2.58000000E-06  +1.02200000E-04
   +4.04400000E-05  +1.77100000E-05  -1.74200000E-05  +4.64800000E-05  +1.40600000E-05
   -3.56000000E-05  +4.43000000E-06  -1.60290000E-04  +7.93800000E-05  +3.53500000E-05
   -2.26000000E-06  +1.98840000E-04  -1.48040000E-04  -6.69000000E-06  +6.59000000E-06
   +4.56000000E-06  +1.75270000E-04  -1.30130000E-04  -1.56500000E-05  +4.08162000E-03
   +1.67463950E-01  +3.29949900E-02  -2.41093720E-01  -3.99117360E-01  +6.49660000E-04
   -2.10456000E-03  -6.55826000E-03  +2.51340000E-03  +4.71283000E-03  +3.40307000E-03
   +4.00700000E-05  -2.34020000E-04  -1.01089000E-03  +1.53480000E-04  +1.18180000E-04
   +3.50360000E-04  +6.12120000E-04  -7.87710000E-04  -7.91600000E-05  -3.41870000E-04
   -4.24000000E-05  +2.35726000E-03  -1.37150000E-04  -3.75700000E-05  -1.56510000E-04
   +1.27910000E-04  +7.34600000E-05  +7.06100000E-05  +3.86200000E-05  +2.30000000E-06
   -2.11100000E-05  +6.82000000E-06  +7.88700000E-05  -3.29000000E-06  -6.31000000E-06
   -2.17000000E-06  +1.02400000E-05  +2.06100000E-05  -2.38900000E-05  -9.17000000E-06
   -6.18000000E-05  +3.64300000E-05  +1.61000000E-05  -3.48000000E-06  +1.83100000E-05
   -2.14500000E-05  -2.66400000E-05  -4.53000000E-06  +1.55800000E-05  +7.96900000E-05
   -4.68800000E-05  -1.58700000E-05  -3.63034800E-02  +2.39632770E-01  +4.01155360E-01
   +1.37392000E-03  +2.98985000E-03  -1.01285000E-03  +4.56674000E-03  +1.28277400E-02
   +1.81571600E-02  -5.38187000E-02  -1.32023100E-02  +1.72654000E-03  +3.60910000E-03
   -1.38703800E-02  -2.12851200E-02  -1.56020000E-03  -5.44601000E-03  +1.45570000E-03
   -1.53123000E-03  -3.70200000E-04  +1.17420000E-04  -1.82262000E-03  -2.02598000E-03
   +4.54167000E-03  +5.74970000E-04  -4.93260000E-04  -9.69390000E-04  -1.24500000E-05
   +8.34800000E-05  -8.55100000E-05  -3.32900000E-04  -1.63660000E-04  +9.59100000E-05
   +1.00930000E-04  -2.73500000E-05  -2.37800000E-05  +1.02000000E-06  +2.04800000E-05
   -1.39600000E-05  -2.03400000E-05  +4.04900000E-05  +1.20600000E-05  +5.06900000E-05
   -3.88600000E-05  -3.17000000E-06  -7.18000000E-06  -7.65100000E-05  +5.42400000E-05
   +7.67000000E-06  -4.80000000E-06  +1.96300000E-05  -7.41200000E-05  +7.04500000E-05
   +1.62100000E-05  -7.17250000E-04  -1.06564000E-03  -2.68920000E-04  +5.00228900E-02
   +2.69193000E-03  -4.85500000E-05  +2.79168000E-03  -3.53587000E-03  +2.28253000E-03
   +1.07789000E-03  -1.33438100E-02  -1.37822460E-01  -1.38553450E-01  +1.47435000E-03
   -8.02221000E-03  -1.70293700E-02  -5.58637000E-03  +2.35183000E-03  -1.56852000E-03
   -1.41200000E-04  -4.74220000E-04  +7.42520000E-04  -1.71959000E-03  +3.58161000E-03
   -8.81590000E-04  +1.98170000E-04  +4.21900000E-05  -9.15920000E-04  -5.72300000E-05
   -6.11000000E-06  -2.77100000E-05  -2.94830000E-04  -2.43710000E-04  +8.25800000E-05
   +1.88240000E-04  -8.62600000E-05  -3.56500000E-05  -2.64100000E-05  +2.62600000E-05
   +2.37600000E-05  -9.56000000E-06  +6.54000000E-06  +1.46800000E-05  +7.98600000E-05
   -2.09500000E-05  -3.21600000E-05  -2.14300000E-05  -3.38100000E-05  +3.38000000E-05
   +3.89000000E-05  +8.27000000E-06  +2.07600000E-05  -9.00900000E-05  +5.37100000E-05
   +1.60800000E-05  +4.37630000E-04  +2.38520000E-04  -9.33620000E-04  +1.76309400E-02
   +1.40543950E-01  -1.60303000E-03  +2.38633000E-03  +1.28020000E-03  -5.52850000E-03
   -1.58294000E-02  -1.33263900E-02  +1.45257000E-03  -1.38564830E-01  -2.36841180E-01
   +1.08137000E-03  -1.02050000E-03  -2.83000000E-05  +8.59290000E-04  -2.11532000E-03
   +3.49160000E-03  +4.13400000E-04  +9.61760000E-04  +1.25100000E-04  +5.03339000E-03
   -5.21050000E-04  -6.12740000E-04  +4.03170000E-04  -9.39900000E-05  -1.01690000E-04
   -5.44200000E-05  +7.96000000E-06  -5.47300000E-05  -1.05580000E-04  -1.19800000E-05
   +5.57400000E-05  -3.68900000E-05  -5.07700000E-05  -6.91000000E-06  +1.06900000E-05
   +1.25100000E-05  -6.13400000E-05  -1.86700000E-05  +4.02100000E-05  -5.08000000E-06
   +7.79000000E-05  -5.84600000E-05  +7.90000000E-07  +7.84000000E-06  -1.31820000E-04
   +9.38200000E-05  -8.17000000E-06  -1.53300000E-05  +5.61000000E-06  -9.74200000E-05
   +8.29400000E-05  +7.97000000E-06  +1.92805000E-03  +6.04700000E-04  -5.19930000E-04
   -1.92452000E-03  +1.52890540E-01  +2.48077360E-01  -1.28779000E-03  -2.55860000E-04
   +7.94680000E-04  +2.10330000E-04  -5.44125000E-03  -1.92500000E-04  -1.28968900E-02
   +2.98650000E-04  +1.78179300E-02  -2.00556980E-01  -1.24202000E-02  +1.44498420E-01
   +4.43514000E-03  -3.64220000E-04  -8.81300000E-04  +2.53440000E-03  -2.10517000E-03
   +6.22850000E-04  -2.25850000E-04  +5.06600000E-05  -9.12670000E-04  -9.67120000E-04
   +6.87550000E-04  -9.44420000E-04  +5.14000000E-06  -7.55900000E-05  +1.47310000E-04
   -6.19000000E-05  +1.41480000E-04  -5.53400000E-05  -7.49220000E-04  -6.33640000E-04
   -8.18750000E-04  -3.43300000E-05  -7.82200000E-05  -7.06500000E-05  -1.37660000E-04
   +1.44080000E-04  +4.93300000E-05  -2.91450000E-04  +2.13600000E-05  +1.78350000E-04
   +2.80260000E-04  +1.73960000E-04  -1.76160000E-04  -3.23180000E-04  -1.41090000E-04
   -3.38720000E-04  +1.77700000E-04  -1.29920000E-04  -3.44200000E-05  +9.59900000E-05
   +1.78980000E-04  +1.57410000E-04  -4.19280000E-04  +1.75340000E-03  -1.45558000E-03
   +2.09899130E-01  -9.98490000E-04  -2.45070000E-04  +7.64080000E-04  -5.25649000E-03
   +1.68917000E-03  -3.71261000E-03  -1.53525600E-02  +3.19841000E-03  +1.43793400E-02
   -1.18984900E-02  -5.00981000E-02  -3.37916000E-03  +1.39044100E-02  +5.84891000E-03
   -1.21040400E-02  -2.57187000E-03  +1.08475000E-03  -5.21024000E-03  +3.09900000E-05
   -1.11357000E-03  +4.20500000E-05  +1.51496000E-03  -1.28912000E-03  +1.09137000E-03
   -1.28360000E-04  -4.71290000E-04  -4.94710000E-04  +1.71030000E-04  +3.17400000E-05
   +1.04560000E-04  -4.30630000E-04  +2.44000000E-05  -2.31320000E-04  +4.46300000E-05
   -1.79780000E-04  -9.95700000E-05  -1.34430000E-04  +1.42080000E-04  +1.82800000E-05
   -2.07230000E-04  -7.36800000E-05  +1.54070000E-04  +3.48110000E-04  +2.64400000E-05
   -1.60600000E-04  -2.29220000E-04  +1.77800000E-04  -1.82960000E-04  +1.36560000E-04
   -1.44540000E-04  -3.00600000E-05  +8.32300000E-05  +1.10440000E-04  +1.29510000E-04
   +2.10229000E-03  -1.85706000E-03  +1.75413000E-03  +1.80229700E-02  +4.41686500E-02
   -6.48000000E-05  +1.00620000E-04  +1.73900000E-04  +2.11000000E-04  -3.35283000E-03
   +3.04199000E-03  -4.26824000E-03  -1.48576000E-03  +6.24229000E-03  +1.43670840E-01
   -2.49527000E-03  -1.87361970E-01  +1.96565400E-02  +2.02021000E-03  -1.24562900E-02
   +4.85990000E-04  -5.67828000E-03  -2.19843000E-03  -1.12052000E-03  -1.08640000E-04
   -2.29800000E-04  +3.02790000E-04  +1.86877000E-03  -7.13750000E-04  -3.17900000E-05
   -4.64200000E-05  -1.21860000E-04  -2.23010000E-04  +3.90000000E-07  -4.70000000E-07
   -3.63540000E-04  -4.70910000E-04  +7.57700000E-05  -3.84940000E-04  +1.64680000E-04
   +3.76010000E-04  -4.74000000E-06  -1.46410000E-04  +6.46800000E-05  -3.65670000E-04
   +1.31490000E-04  +1.94400000E-05  -2.76300000E-05  +3.07010000E-04  -2.47470000E-04
   +7.16100000E-05  +4.02440000E-04  -5.94200000E-05  +3.81470000E-04  -2.41920000E-04
   -1.43600000E-05  -2.14500000E-05  +1.20000000E-07  -1.24400000E-05  -1.15558000E-03
   +2.07273000E-03  -4.46290000E-04  -1.57736500E-01  +6.55909000E-03  +1.94381160E-01
   +7.32800000E-05  -7.20900000E-04  -1.12034000E-03  -1.18238000E-03  -5.40487000E-03
   +1.66445000E-03  -1.27972000E-03  -1.55440000E-04  -6.83000000E-06  -1.81218000E-03
   -2.45456000E-03  +5.08380000E-03  +6.24178000E-03  +1.32506200E-02  +1.77532200E-02
   -5.51345200E-02  -1.03212200E-02  +1.05558000E-03  +3.12100000E-03  -1.47706900E-02
   -2.07626600E-02  -2.30080000E-04  +1.81097000E-03  -9.69660000E-04  +3.46390000E-04
   +5.30700000E-05  -8.56000000E-05  -2.53266000E-03  -1.75253000E-03  +5.27250000E-04
   -2.22260000E-04  -1.17070000E-04  -8.79800000E-05  -2.05400000E-05  -2.30200000E-05
   -7.12500000E-05  +3.45000000E-05  -1.29300000E-05  +2.02200000E-05  -6.72000000E-05
   +3.03700000E-05  +1.38200000E-05  +3.93000000E-06  +9.91800000E-05  -3.02300000E-05
   +4.51400000E-05  -7.48100000E-05  -2.47700000E-05  +8.28600000E-05  -6.05200000E-05
   -2.28400000E-05  -3.16470000E-04  -1.76070000E-04  -1.32770000E-04  -1.26580000E-04
   +2.92530000E-04  -2.03030000E-04  +1.75620000E-04  +7.66700000E-04  +1.03637000E-03
   +5.54533900E-02  -9.25400000E-05  -6.67600000E-04  -9.88890000E-04  -5.48435000E-03
   +2.83272000E-03  -1.89892000E-03  -1.03440000E-04  -5.48910000E-04  +8.85260000E-04
   -2.37306000E-03  +4.04838000E-03  -1.41418000E-03  +1.89940000E-04  +5.14396000E-03
   +7.05500000E-04  -1.02806400E-02  -1.40028990E-01  -1.38697790E-01  +4.98150000E-04
   -7.34513000E-03  -1.72559700E-02  +1.19441000E-03  -2.35026000E-03  +9.40200000E-04
   -4.80670000E-04  -2.79420000E-04  +2.29000000E-05  -2.87482000E-03  -1.03529000E-03
   +1.63210000E-04  +3.22330000E-04  +4.06970000E-04  -1.89260000E-04  +9.51400000E-05
   -9.36500000E-05  +7.04500000E-05  +2.30300000E-05  -3.82600000E-05  -1.06300000E-05
   -4.55000000E-05  +6.29000000E-05  -1.61000000E-05  +2.02000000E-06  +3.80700000E-05
   -5.67800000E-05  +2.62900000E-05  +5.71800000E-05  -2.88900000E-05  +6.66900000E-05
   -5.85200000E-05  +1.47500000E-05  -1.24150000E-04  -2.56190000E-04  +2.88900000E-05
   +2.70700000E-04  -4.04450000E-04  +2.07980000E-04  -7.98000000E-05  +8.78100000E-05
   +1.93820000E-04  +1.90021500E-02  +1.44315160E-01  -1.56440000E-04  -2.98710000E-04
   -2.31210000E-04  +1.49065000E-03  -1.93932000E-03  +3.49415000E-03  +1.44440000E-04
   +9.47130000E-04  +1.82190000E-04  +5.15106000E-03  -1.19606000E-03  -5.15780000E-04
   -2.12300000E-03  -1.31152500E-02  -1.27871200E-02  +1.69801000E-03  -1.38963550E-01
   -2.47000200E-01  +1.64351000E-03  -1.34567000E-03  +3.35250000E-04  -1.97638000E-03
   +1.56620000E-04  -1.44991000E-03  +5.27600000E-04  +1.92860000E-04  +5.09700000E-05
   -9.32420000E-04  -1.16089000E-03  +2.96970000E-04  -1.61060000E-04  -6.45900000E-05
   +8.66300000E-05  -2.93500000E-05  +6.44200000E-05  +1.90500000E-05  -2.09000000E-06
   +1.42500000E-05  -4.60000000E-07  +2.28100000E-05  -1.57800000E-05  +2.31000000E-06
   -2.73000000E-05  -2.14200000E-05  +6.96000000E-06  -2.66700000E-05  -9.15000000E-06
   +6.73500000E-05  -3.08000000E-05  +3.46300000E-05  +2.59000000E-06  -4.91000000E-05
   +8.82300000E-05  -1.02600000E-05  -2.34240000E-04  +1.77280000E-04  -2.19070000E-04
   -1.64890000E-04  -6.74330000E-04  -7.93970000E-04  -1.90471000E-03  +1.54655590E-01
   +2.58062200E-01  -2.29080000E-04  +1.76816000E-03  -9.10030000E-04  +3.66479000E-03
   -2.20033000E-03  -1.50720000E-03  +2.25812000E-03  -2.01085000E-03  +5.71400000E-04
   -1.83900000E-04  +5.37100000E-05  -8.87400000E-04  -3.14640000E-04  -5.46919000E-03
   -1.72650000E-04  -1.22289000E-02  +9.59780000E-04  +1.68846900E-02  -2.01822580E-01
   -1.82184300E-02  +1.48299730E-01  -1.63310000E-04  +2.99620000E-04  +8.81970000E-04
   -1.90590000E-04  -7.98800000E-05  -9.67500000E-05  -2.88700000E-05  +7.60000000E-05
   +6.70500000E-05  +1.26700000E-05  -1.96000000E-04  -1.79000000E-06  -6.47500000E-05
   +6.61700000E-05  -8.24000000E-06  -4.30000000E-06  +6.38000000E-06  +1.28600000E-05
   +7.61400000E-05  -2.87700000E-05  -2.99200000E-05  -2.67100000E-05  -9.89200000E-05
   +9.21700000E-05  +3.24500000E-05  -5.19000000E-06  +6.46000000E-06  -8.36600000E-05
   +6.17300000E-05  +2.88000000E-06  -1.30060000E-04  +2.36430000E-04  -1.14440000E-04
   +1.80990000E-04  +2.58100000E-05  -1.98720000E-04  -2.06710000E-04  +2.78990000E-04
   -1.04670000E-04  -5.08270000E-04  +1.82645000E-03  -1.48075000E-03  +2.09958220E-01
   +1.64684000E-03  -8.62620000E-04  +2.32713000E-03  +1.35968700E-02  +6.16484000E-03
   -1.30722200E-02  -2.31181000E-03  +7.17780000E-04  -4.81994000E-03  -1.18490000E-04
   -1.30130000E-03  -1.91650000E-04  -5.07709000E-03  +1.31971000E-03  -3.04726000E-03
   -1.38899300E-02  +2.75163000E-03  +1.49776700E-02  -1.90665600E-02  -4.78906100E-02
   +1.03963000E-03  -4.97850000E-04  +4.37840000E-04  +4.86390000E-04  -7.68700000E-05
   +4.93800000E-05  -4.36800000E-05  +5.55900000E-05  +3.17400000E-05  +8.15600000E-05
   -2.03440000E-04  -2.56210000E-04  -2.50400000E-05  -2.18800000E-05  +3.40100000E-05
   -2.74900000E-05  -2.93800000E-05  +4.64400000E-05  +1.80400000E-05  +2.44900000E-05
   -4.57800000E-05  +1.97900000E-05  +1.63600000E-05  +5.00000000E-08  -5.73000000E-06
   -4.30100000E-05  -8.36000000E-06  -6.47000000E-06  -4.94700000E-05  +3.50200000E-05
   +4.24000000E-06  +1.86330000E-04  -1.40770000E-04  +4.30170000E-04  +7.52990000E-04
   +4.17100000E-05  -6.48230000E-04  +2.47010000E-04  -3.12990000E-04  +3.01370000E-04
   +2.12847000E-03  -1.82851000E-03  +1.70841000E-03  +2.27222400E-02  +4.10474300E-02
   -1.17523000E-03  +2.12475000E-03  +7.80510000E-04  +2.19245600E-02  +3.68548000E-03
   -1.22794900E-02  +1.10310000E-04  -5.15389000E-03  -2.09241000E-03  -1.23792000E-03
   -3.89640000E-04  -3.87540000E-04  +1.66400000E-05  -2.86035000E-03  +2.89962000E-03
   -4.92219000E-03  -6.52520000E-04  +6.69957000E-03  +1.47055380E-01  +8.66400000E-05
   -1.89695770E-01  -1.68420000E-04  -1.41890000E-04  +3.03330000E-04  -1.11200000E-05
   -4.74300000E-05  -2.38100000E-05  +1.72200000E-05  +6.07900000E-05  -1.87100000E-05
   +6.55200000E-05  +3.25600000E-05  +2.22000000E-06  -8.59000000E-06  +3.32000000E-06
   +2.52500000E-05  +1.13500000E-05  -1.54000000E-05  +3.20000000E-06  -2.32500000E-05
   +2.22000000E-05  -7.24000000E-06  -1.34600000E-05  +7.95000000E-06  -2.34000000E-06
   +2.33800000E-05  +5.41000000E-06  +3.34000000E-06  +3.00000000E-05  -1.79700000E-05
   -1.46000000E-06  -1.87910000E-04  +3.77490000E-04  +1.95130000E-04  +8.89870000E-04
   +1.08270000E-04  -8.08130000E-04  -1.13400000E-04  +2.81490000E-04  -1.70550000E-04
   -1.04162000E-03  +2.04984000E-03  -3.63930000E-04  -1.61259550E-01  +5.02340000E-04
   +1.94971670E-01  +3.75800000E-05  +5.36000000E-06  +2.55100000E-05  +3.54900000E-05
   -4.25300000E-05  -1.82930000E-04  -2.21490000E-04  -1.97700000E-05  -1.03000000E-05
   +3.11810000E-04  +2.30460000E-04  +2.51590000E-04  +8.28820000E-04  -1.29390000E-03
   -2.10460000E-04  +1.84250000E-04  +1.16420000E-04  +1.71480000E-04  +1.20420000E-04
   +1.36200000E-04  -2.26300000E-05  -4.41541000E-03  +1.05446000E-03  +1.29732000E-03
   -2.60264140E-01  +1.03570140E-01  +3.97726600E-02  -1.02760000E-04  -2.19590000E-04
   +4.54450000E-04  +1.10240000E-03  -2.69400000E-05  -4.61870000E-04  -1.70000000E-04
   -1.48200000E-04  +2.85580000E-04  +1.21050000E-04  +1.65750000E-04  -1.69590000E-04
   +1.56130000E-04  -6.32700000E-05  -4.31900000E-05  -4.47800000E-05  -1.23040000E-04
   +1.28930000E-04  -2.44140000E-04  +2.18490000E-04  +8.66200000E-05  -2.05570000E-04
   +1.73960000E-04  -1.86700000E-05  -9.26000000E-06  +3.21000000E-06  -3.29000000E-06
   -3.80000000E-06  +1.30400000E-05  +6.50000000E-07  +2.73000000E-05  -6.65900000E-05
   -4.09000000E-06  +2.22600000E-05  +3.17200000E-05  -1.89000000E-05  +2.28500000E-05
   +1.58700000E-05  +7.35000000E-06  +2.79803580E-01  +2.03840000E-04  +2.00550000E-04
   +3.32000000E-05  -2.45550000E-04  -1.30380000E-04  +1.70010000E-04  +1.83370000E-04
   +7.51500000E-05  -6.52000000E-05  -2.10780000E-04  -2.05860000E-04  -5.67270000E-04
   +1.21584000E-03  +7.90330000E-04  -3.03550000E-04  -2.20940000E-04  +1.68340000E-04
   +1.16400000E-05  -2.17100000E-04  -1.25090000E-04  +2.75600000E-05  +2.15015600E-02
   -1.27703600E-02  -3.87484000E-03  +1.01523700E-01  -9.52643200E-02  -1.98395200E-02
   -2.52010000E-04  +3.67230000E-04  -1.26644000E-03  -3.98570000E-04  -3.23115000E-03
   +4.07742000E-03  -7.03130000E-04  -9.46000000E-05  +4.57890000E-04  +1.21710000E-04
   +1.78620000E-04  -7.29500000E-05  -3.22970000E-04  +1.08330000E-04  +1.27780000E-04
   +1.08300000E-04  -2.01590000E-04  +2.74600000E-05  +1.29698000E-03  -3.04400000E-05
   -2.45550000E-04  +2.73330000E-04  -1.88130000E-04  -6.78100000E-05  -8.71000000E-06
   -3.69700000E-05  -1.67000000E-05  +1.15400000E-05  -2.16000000E-06  +1.27200000E-05
   +1.83900000E-05  +8.65600000E-05  +1.43640000E-04  +2.99700000E-05  -3.23500000E-05
   +8.71800000E-05  +6.19000000E-06  -8.83000000E-06  -4.69000000E-06  -1.12940070E-01
   +1.04360970E-01  -1.23040000E-04  -9.28800000E-05  -9.06000000E-06  +1.28380000E-04
   -9.87000000E-06  -2.02140000E-04  -3.66680000E-04  -5.01800000E-05  +9.10500000E-05
   +3.65610000E-04  +4.49000000E-05  -1.93170000E-04  -5.37060000E-04  -4.07220000E-04
   +5.29360000E-04  -1.54400000E-04  -1.62580000E-04  +1.85760000E-04  +1.27420000E-04
   +1.24860000E-04  +1.21500000E-05  -1.97285400E-02  +9.90549000E-03  +1.94476000E-03
   +4.10536500E-02  -2.08114000E-02  -5.44801400E-02  -1.17651000E-03  +5.15150000E-04
   +1.17878000E-03  +6.16100000E-05  +3.16308000E-03  -3.03920000E-03  +7.75060000E-04
   +2.42130000E-04  -2.31930000E-04  -1.79580000E-04  +3.48600000E-05  +2.04130000E-04
   +3.52600000E-05  -1.31880000E-04  +2.56600000E-05  +1.22050000E-04  +2.83790000E-04
   -1.93960000E-04  -9.50750000E-04  +4.31060000E-04  +4.74700000E-04  -6.85400000E-05
   +1.34900000E-05  +2.26300000E-05  +1.38700000E-05  +2.66000000E-06  +1.48100000E-05
   +1.59200000E-05  -1.73200000E-05  +5.10000000E-07  +2.98700000E-05  +1.58900000E-05
   +8.73500000E-05  +2.95100000E-05  +6.54000000E-06  -8.94500000E-05  -1.21000000E-06
   +3.46000000E-06  +1.07400000E-05  -4.37606300E-02  +1.81313400E-02  +5.82343100E-02
   -2.27030000E-04  -1.91650000E-04  -2.77400000E-05  +2.57020000E-04  +1.49810000E-04
   -8.91400000E-05  -2.23310000E-04  -5.37800000E-05  +7.53200000E-05  +2.76220000E-04
   +2.64690000E-04  +4.66310000E-04  +4.43210000E-04  -3.26880000E-04  -2.37230000E-04
   +5.26820000E-04  -3.14600000E-05  -1.57020000E-04  +6.63000000E-05  -2.12600000E-05
   -2.56700000E-05  +2.95075000E-03  +3.90160000E-03  +3.43610000E-04  -1.82452750E-01
   -1.31679790E-01  -1.76447900E-02  +3.62140000E-04  +3.55520000E-04  -5.25900000E-05
   +1.10310000E-04  -1.82500000E-04  +3.17970000E-04  -8.73790000E-04  +6.94500000E-04
   +5.70480000E-04  +7.66400000E-05  +1.91490000E-04  -1.38740000E-04  -1.73170000E-04
   +1.04200000E-05  +6.77100000E-05  +5.19100000E-05  +2.58200000E-05  -2.13100000E-05
   +6.42400000E-05  -6.37500000E-05  -2.34600000E-05  +1.00230000E-04  -4.91200000E-05
   -4.06300000E-05  +1.94400000E-05  +3.61700000E-05  +1.81900000E-05  -2.41400000E-05
   -5.91000000E-06  -1.83300000E-05  -1.05900000E-05  -1.90600000E-05  -1.60200000E-05
   -5.94300000E-05  +6.76100000E-05  -3.10000000E-07  -7.06000000E-06  -3.76000000E-06
   +6.51000000E-06  -1.86563500E-02  -2.04118700E-02  -3.46991000E-03  +1.97694380E-01
   -5.55430000E-04  -4.90000000E-04  -1.53200000E-04  +2.55230000E-04  +4.56740000E-04
   +4.90760000E-04  +8.05600000E-05  +1.75600000E-04  +3.08700000E-05  -3.10480000E-04
   -1.31280000E-04  +3.18260000E-04  +1.05119000E-03  -2.56518000E-03  +3.93313000E-03
   +4.01180000E-04  -4.54440000E-04  -4.55270000E-04  -6.20120000E-04  -2.70250000E-04
   -4.38630000E-04  -1.74857900E-02  -1.62073800E-02  -3.01928000E-03  -1.30355610E-01
   -1.75289110E-01  -1.68453700E-02  -3.17560000E-04  +7.29040000E-04  -1.59324000E-03
   -7.11390000E-04  +4.92010000E-04  -1.97780000E-04  -1.20830000E-04  -3.63870000E-04
   +5.95990000E-04  +3.24510000E-04  +2.42110000E-04  -2.74190000E-04  +8.04100000E-05
   +4.70400000E-05  -1.26320000E-04  -1.43170000E-04  -2.01030000E-04  +1.88560000E-04
   +1.45660000E-04  +9.45600000E-05  +6.76300000E-05  -1.03110000E-04  +1.48440000E-04
   -2.89200000E-05  +2.99900000E-05  +4.73900000E-05  +5.73400000E-05  -2.99800000E-05
   -5.29000000E-05  -3.73300000E-05  -9.05000000E-06  +1.15180000E-04  -7.59100000E-05
   +5.65700000E-05  -7.83100000E-05  +1.60570000E-04  -1.02000000E-04  -1.11300000E-05
   -3.02900000E-05  +1.02520900E-02  +1.08430700E-02  +1.65850000E-03  +1.43712560E-01
   +1.90049710E-01  +3.25980000E-04  +3.17710000E-04  +3.83400000E-05  -3.62930000E-04
   -4.62000000E-05  +2.69790000E-04  +6.67540000E-04  +1.37600000E-05  +3.79600000E-05
   -2.02000000E-06  -3.44300000E-04  -9.81500000E-05  -1.48604000E-03  +2.47815000E-03
   -2.45087000E-03  +5.52040000E-04  +5.04400000E-04  +1.45190000E-04  +4.15000000E-05
   -3.12600000E-04  +1.24220000E-04  +1.63950300E-02  +1.49303300E-02  +5.90690000E-04
   -1.77201800E-02  -1.80598600E-02  -5.08372100E-02  +1.07140000E-03  +7.40550000E-04
   +1.06720000E-03  +1.87290000E-04  -5.30890000E-04  +3.98530000E-04  -2.54340000E-04
   -5.72250000E-04  +4.21520000E-04  -5.54000000E-05  +1.89160000E-04  -1.39980000E-04
   -1.06280000E-04  -4.83000000E-05  +1.13750000E-04  +1.06640000E-04  -4.03000000E-05
   -2.74100000E-05  -8.99000000E-06  +4.73700000E-05  -1.98830000E-04  +2.74100000E-05
   +9.28000000E-06  -2.87100000E-05  -5.40000000E-07  -1.64400000E-05  -4.17200000E-05
   +3.32600000E-05  +1.95500000E-05  +1.85800000E-05  -2.77820000E-04  +3.76330000E-04
   +3.91000000E-06  -3.17200000E-05  +1.08220000E-04  -1.06630000E-04  +4.00500000E-05
   +3.59700000E-05  -1.25300000E-05  +4.02749000E-03  +4.38617000E-03  -3.57620000E-04
   +1.90623000E-02  +1.64552200E-02  +5.25620900E-02  +4.07500000E-05  +4.56700000E-05
   +9.80000000E-07  -1.67200000E-05  -9.15100000E-05  -7.60600000E-05  -2.29780000E-04
   -3.03400000E-05  -2.71600000E-05  -1.66000000E-06  -1.19130000E-04  -8.00500000E-05
   -1.01920000E-04  +3.92190000E-04  +6.36610000E-04  -1.23560000E-04  -9.27500000E-05
   +7.74800000E-05  +1.00670000E-04  +5.33700000E-05  +5.10500000E-05  -1.76003000E-03
   -1.87842000E-03  -4.28835000E-03  -4.70545200E-02  +2.77630000E-04  +2.24952000E-03
   -9.92300000E-05  +9.38980000E-04  -6.49820000E-04  +3.93960000E-04  -4.82570000E-04
   -4.98380000E-04  -4.24300000E-05  +4.27510000E-04  -3.68270000E-04  -1.07800000E-04
   -3.16600000E-05  +2.14220000E-04  -1.21780000E-04  -2.94200000E-05  +5.13500000E-05
   +1.04570000E-04  +9.94800000E-05  -1.46410000E-04  -8.26000000E-06  -4.06000000E-06
   +6.35000000E-06  +1.24530000E-04  -1.18260000E-04  +1.74400000E-05  -6.06000000E-06
   -2.25700000E-05  +5.08000000E-06  +2.34400000E-05  -1.48500000E-05  +1.39600000E-05
   +2.17640000E-04  -1.02580000E-04  +6.07600000E-05  +1.09300000E-05  +2.26900000E-05
   -6.05800000E-05  -2.23000000E-06  +1.07300000E-05  -8.09000000E-06  +7.32750000E-04
   +9.92425000E-03  +2.74359100E-02  +4.88320000E-04  -7.40580000E-03  -2.21473200E-02
   +4.76268000E-02  +1.55950000E-04  +1.08530000E-04  +2.97500000E-05  +4.02700000E-05
   -1.19290000E-04  -2.74590000E-04  -1.21500000E-04  -1.95980000E-04  -1.83380000E-04
   -3.66560000E-04  -1.13810000E-04  +6.11320000E-04  +6.50870000E-04  +1.22803000E-03
   +1.19800000E-04  -3.53250000E-04  -5.64600000E-05  +1.44600000E-05  +2.14240000E-04
   +1.97990000E-04  +1.78730000E-04  -8.22100000E-04  +8.64943000E-03  +2.26632400E-02
   -2.54600000E-05  -8.32265300E-02  -9.22412100E-02  +5.00060000E-04  -3.51941000E-03
   +2.83388000E-03  -4.03430000E-04  +1.15988000E-03  -3.07800000E-04  +4.89590000E-04
   +2.94530000E-04  -1.48980000E-04  +7.63700000E-05  -1.90460000E-04  +6.50500000E-05
   +1.45580000E-04  +6.79600000E-05  -1.53340000E-04  -1.76670000E-04  +6.69500000E-05
   +9.11700000E-05  -1.42200000E-04  -2.08320000E-04  -2.50200000E-05  -8.01300000E-05
   +2.10900000E-05  +1.86400000E-05  -2.25700000E-05  -1.54600000E-05  -1.54900000E-05
   -5.97000000E-06  -1.55000000E-06  +2.33300000E-05  +1.03210000E-04  -8.74530000E-04
   -6.26400000E-05  +4.93500000E-05  -9.89000000E-06  -1.85100000E-05  +1.25300000E-05
   -5.92000000E-06  +3.69000000E-06  -1.13065000E-03  -5.38409000E-03  -1.21207200E-02
   +2.02972000E-03  -7.67338000E-03  -2.01255100E-02  -1.29256000E-03  +8.92777500E-02
   -3.06500000E-05  -4.97000000E-06  -1.75000000E-05  -2.38250000E-04  +2.36390000E-04
   +4.90430000E-04  +5.74560000E-04  +2.95230000E-04  +1.96430000E-04  +1.15730000E-04
   -6.52830000E-04  -8.86200000E-05  -1.22827000E-03  -8.85750000E-04  +6.23780000E-04
   +7.78390000E-04  +2.03190000E-04  -2.80680000E-04  -4.00610000E-04  -3.83830000E-04
   -1.62190000E-04  +4.56410000E-04  -8.80112000E-03  -1.94180500E-02  +2.22960000E-03
   -8.98611800E-02  -2.80356610E-01  -4.67780000E-04  +4.85630000E-03  -2.33069000E-03
   +9.51880000E-04  -7.77050000E-04  +5.16290000E-04  +3.62490000E-04  +1.53390000E-04
   +1.51250000E-04  -2.71340000E-04  +1.35790000E-04  +2.18330000E-04  -9.45600000E-05
   -1.90760000E-04  +1.49360000E-04  +2.25080000E-04  +2.69500000E-05  -1.62270000E-04
   -7.78700000E-05  +3.48830000E-04  +1.44460000E-04  -1.13200000E-05  -2.16000000E-05
   +6.32000000E-06  +1.82100000E-05  +1.33300000E-05  -3.46000000E-06  +3.75600000E-05
   +6.93000000E-06  +9.00000000E-08  -2.32530000E-04  +2.98940000E-04  +2.38110000E-04
   -1.21960000E-04  -8.46000000E-06  +9.72500000E-05  -4.70000000E-06  +1.67100000E-05
   -1.62100000E-05  -4.41970000E-04  -1.27265000E-03  -3.80112000E-03  +3.49060000E-04
   -1.05510000E-04  -1.13828000E-03  -1.90598000E-03  +9.73066100E-02  +3.05610430E-01
   +9.32900000E-05  +1.08800000E-04  +5.76500000E-05  -8.16800000E-05  -1.61600000E-05
   +2.98500000E-05  +1.16240000E-04  +1.09540000E-04  +3.81000000E-05  -1.00510000E-04
   -7.99100000E-05  -5.97900000E-05  +2.39590000E-04  +5.64560000E-04  -3.24830000E-04
   +6.62900000E-05  -3.37330000E-04  -7.25290000E-04  -1.20540000E-04  -2.31800000E-05
   +2.70750000E-04  -1.92604000E-03  +1.39168000E-03  -1.21344000E-03  +3.97100000E-05
   -4.49810000E-04  -5.79570000E-04  -4.88293300E-02  +1.41991900E-02  -1.34441400E-02
   +7.27300000E-05  -7.21780000E-04  +5.83200000E-04  -1.59880000E-04  +3.84100000E-05
   +4.35700000E-05  +1.23640000E-04  -6.60900000E-05  +4.34000000E-05  -3.55800000E-05
   +9.26300000E-05  -3.38200000E-05  -1.64350000E-04  +1.71630000E-04  +4.51400000E-05
   -1.67600000E-05  -1.54000000E-06  -5.40600000E-05  +6.61700000E-05  -5.74900000E-05
   -3.61500000E-05  -8.77000000E-06  -8.41000000E-06  -6.75000000E-06  +9.89000000E-06
   +1.01100000E-05  +1.47800000E-05  -1.94100000E-05  +3.83600000E-05  +6.55700000E-05
   -1.27302000E-03  +2.59420000E-04  -2.01230000E-04  -1.34600000E-05  +1.22000000E-06
   -2.27500000E-05  +3.32690000E-04  -2.89230000E-04  +2.70370000E-04  +1.17140000E-04
   +3.34700000E-04  -1.04460000E-04  +6.18270000E-04  +1.99540000E-04  -1.86170000E-04
   +4.93367500E-02  +8.24900000E-05  +4.62400000E-05  -1.71000000E-05  -9.15400000E-05
   -7.23800000E-05  +9.13100000E-05  +6.47600000E-05  +2.37500000E-05  -2.70400000E-05
   +2.52440000E-04  +6.97800000E-05  +3.45800000E-05  -1.28520000E-04  +6.56400000E-04
   +1.63050000E-04  -7.11340000E-04  +2.84630000E-04  +1.60470000E-04  +4.65000000E-05
   -5.21400000E-05  -1.85110000E-04  -5.87500000E-04  +9.27342000E-03  -1.06305900E-02
   -2.15880000E-04  -5.50030000E-04  -2.03361000E-03  +1.46257100E-02  -1.81020620E-01
   +1.34647150E-01  -3.71840000E-04  +9.48470000E-04  -1.11900000E-04  -1.10500000E-05
   -5.67000000E-05  +5.81200000E-05  -9.61000000E-06  +6.16500000E-05  -6.81900000E-05
   +2.52700000E-05  -5.58900000E-05  -2.86500000E-05  -8.42900000E-05  -8.61200000E-05
   +7.76700000E-05  +9.08300000E-05  -1.12000000E-05  -2.15300000E-04  -1.25280000E-04
   +8.40600000E-05  +1.26100000E-05  -7.24000000E-06  -1.45400000E-05  -5.40000000E-06
   +1.91300000E-05  +1.33200000E-05  +5.52000000E-06  -9.00000000E-07  +1.23400000E-05
   -3.21900000E-05  -1.99050000E-04  -2.57560000E-04  -2.88390000E-04  -5.94000000E-06
   +3.72800000E-05  -1.02700000E-05  -2.14880000E-04  +1.89500000E-05  -1.84880000E-04
   +2.18470000E-04  +1.17220000E-04  -2.28520000E-04  -9.47400000E-05  +7.30000000E-04
   -5.07040000E-04  -1.46912700E-02  +1.93922280E-01  +4.88600000E-05  +3.74500000E-05
   +1.26000000E-05  -1.64750000E-04  +1.01920000E-04  +2.46170000E-04  +2.68470000E-04
   +2.19350000E-04  -1.86400000E-05  +3.60300000E-05  -5.67360000E-04  -1.63400000E-04
   +9.61790000E-04  +9.87040000E-04  +1.28486000E-03  +1.03070000E-04  -1.84180000E-04
   +3.64700000E-05  -2.56880000E-04  -2.43320000E-04  +1.21770000E-04  -1.98142000E-03
   +2.13472500E-02  -2.04703300E-02  +1.08360000E-04  -4.06909000E-03  -5.39634000E-03
   -1.31488500E-02  +1.32293780E-01  -1.80410910E-01  -1.52866000E-03  +7.13760000E-04
   +8.49970000E-04  +9.44130000E-04  +9.71600000E-05  -9.43400000E-05  -4.60480000E-04
   +3.20570000E-04  -3.35700000E-05  -1.12550000E-04  -3.08790000E-04  +3.18750000E-04
   +5.56360000E-04  -5.39300000E-04  -1.39150000E-04  +5.83200000E-05  +2.66480000E-04
   +1.24360000E-04  -5.55600000E-05  +4.45500000E-05  +5.64900000E-05  -1.22000000E-05
   +2.18000000E-06  -1.17000000E-05  -2.15200000E-05  +3.57000000E-05  -2.41700000E-05
   -3.43600000E-05  +8.92200000E-05  +4.24000000E-05  -4.85240000E-04  +1.57080000E-04
   +1.44620000E-04  -1.87900000E-05  -1.48900000E-05  -1.45300000E-05  -7.78500000E-05
   -9.85600000E-05  +1.96080000E-04  +1.19100000E-04  -1.85170000E-04  +3.04750000E-04
   -3.85810000E-04  +1.42918000E-03  -1.46013000E-03  +1.52486300E-02  -1.44579600E-01
   +1.98285360E-01  -1.51560000E-04  -1.61650000E-04  -7.27100000E-05  +7.82700000E-05
   +9.77600000E-05  +1.51000000E-05  -5.84200000E-05  -5.13100000E-05  -1.17550000E-04
   +4.08400000E-05  +4.07800000E-05  +2.56690000E-04  +6.68940000E-04  +1.18710000E-04
   +7.47400000E-05  -1.69620000E-04  +5.55300000E-05  +5.07250000E-04  +1.63260000E-04
   -1.13550000E-04  -2.84800000E-04  -1.95435000E-03  -1.23660000E-04  +9.85120000E-04
   -1.92600000E-04  +5.54000000E-06  +3.42790000E-04  -2.26546710E-01  -1.27987040E-01
   -9.85179000E-03  +7.57650000E-04  +1.33873000E-03  +3.59420000E-04  +2.00390000E-04
   -1.69340000E-04  +3.44100000E-05  +9.86200000E-05  -7.42400000E-05  -7.16400000E-05
   +1.90600000E-05  +1.04610000E-04  -9.10200000E-05  -2.04370000E-04  +5.64200000E-05
   +1.76600000E-05  +3.36490000E-04  -2.45530000E-04  +9.14400000E-05  +4.02100000E-05
   -2.77900000E-05  -2.32000000E-06  +1.42900000E-05  +1.86700000E-05  +1.15400000E-05
   -3.26600000E-05  -5.82000000E-06  -2.42600000E-05  +7.87400000E-05  -4.32000000E-05
   -5.97000000E-05  +1.33260000E-04  -6.90200000E-05  -5.56660000E-04  -3.80000000E-06
   -8.96000000E-06  +1.91400000E-05  +2.99900000E-05  -1.26960000E-04  +3.17900000E-05
   +2.51020000E-04  +3.73780000E-04  -4.89350000E-04  +2.63960000E-04  +2.60440000E-04
   +1.79000000E-05  +2.67201000E-03  +2.73879000E-03  +3.25540000E-04  +2.42865120E-01
   -2.41540000E-04  -1.92360000E-04  -1.92000000E-05  +2.84400000E-04  +1.06450000E-04
   -1.11170000E-04  -8.48700000E-05  -2.99700000E-04  -1.11230000E-04  -8.77290000E-04
   -3.71200000E-05  +1.93740000E-04  +7.47060000E-04  -2.57520000E-04  -2.96480000E-03
   +2.83760000E-04  +2.32820000E-04  -3.39710000E-04  -3.23200000E-05  +1.52620000E-04
   +3.34700000E-05  -1.09401500E-02  -9.94924000E-03  -6.98720000E-04  +6.23270000E-04
   +3.08370000E-04  +9.41030000E-04  -1.26586110E-01  -1.37195280E-01  -5.77343000E-03
   -9.19840000E-04  +3.08710000E-04  +2.13900000E-04  +2.99740000E-04  +2.08680000E-04
   -4.28900000E-05  +1.38090000E-04  -2.35400000E-05  -5.43200000E-05  +1.95570000E-04
   -8.76500000E-05  -1.05250000E-04  -7.85100000E-05  -1.35760000E-04  +1.23930000E-04
   +9.37600000E-05  -1.88650000E-04  +3.76580000E-04  -1.64580000E-04  +1.49040000E-04
   +1.55000000E-05  +3.01200000E-05  +3.02200000E-05  +2.20300000E-05  -4.97300000E-05
   -1.07680000E-04  +2.26000000E-06  +6.28000000E-06  +4.05000000E-05  -7.96900000E-05
   +2.12450000E-04  -1.93800000E-04  +1.93990000E-04  -3.73900000E-05  -2.41000000E-06
   -4.69000000E-06  +9.93600000E-05  +4.78200000E-05  +1.74900000E-05  +1.56500000E-05
   +5.28610000E-04  +8.33400000E-05  +2.04590000E-04  -3.33000000E-06  -8.29000000E-06
   -1.82768400E-02  -1.24284800E-02  -1.96308000E-03  +1.39374490E-01  +1.47002390E-01
   -1.65350000E-04  -9.89400000E-05  +2.03600000E-05  +1.33870000E-04  +1.64740000E-04
   +1.23300000E-05  +1.48880000E-04  -2.36750000E-04  -3.17380000E-04  -1.60930000E-03
   -1.10779000E-03  +2.20540000E-04  +1.23714000E-03  -1.49712000E-03  -5.44466000E-03
   +9.81280000E-04  -1.02830000E-04  -6.61600000E-04  -2.15230000E-04  -5.64400000E-05
   +2.52030000E-04  -2.45071900E-02  -1.80928200E-02  -3.27130000E-03  -8.77450000E-04
   -1.10900000E-03  +1.34693000E-03  -7.75634000E-03  -4.38543000E-03  -4.64953300E-02
   -1.20346000E-03  +2.25260000E-04  +6.93540000E-04  -4.11600000E-05  +1.31010000E-04
   +1.83730000E-04  +2.16290000E-04  -1.00660000E-04  -6.20700000E-05  +2.47520000E-04
   +6.69400000E-05  -2.11380000E-04  -3.28710000E-04  -1.56360000E-04  +2.73510000E-04
   +3.23320000E-04  -1.36220000E-04  +1.03100000E-05  -2.40310000E-04  +1.53720000E-04
   +8.36000000E-06  +2.33100000E-05  +2.59500000E-05  +1.17100000E-05  -1.28650000E-04
   -9.93100000E-05  -3.75600000E-05  -8.62000000E-06  +4.73800000E-05  -1.07900000E-05
   -6.72800000E-05  +4.60120000E-04  +4.18880000E-04  -2.71800000E-05  -3.90100000E-05
   +2.95000000E-06  +7.44000000E-05  +4.41700000E-05  -6.58900000E-05  +2.40470000E-04
   +6.22240000E-04  -5.81360000E-04  +3.42250000E-04  +9.87800000E-05  +2.71850000E-04
   +1.95300100E-02  +1.22194000E-02  +1.42093000E-03  +9.58340000E-03  +9.14765000E-03
   +5.28262300E-02  +8.45400000E-05  +4.08500000E-05  -2.74900000E-05  -1.74090000E-04
   -2.78500000E-05  +1.96300000E-05  +3.84600000E-05  +1.41600000E-05  -9.94000000E-06
   +1.24650000E-04  +1.16850000E-04  +2.11800000E-05  -6.41700000E-05  -8.06900000E-05
   +3.34820000E-04  -6.82260000E-04  -9.11500000E-04  +5.28540000E-04  +1.50490000E-04
   -1.15370000E-04  -2.79520000E-04  +1.33658000E-03  -1.63380000E-03  -8.58760000E-04
   +4.14690000E-04  -2.73040000E-04  -3.75160000E-04  -2.18678020E-01  +1.21849990E-01
   +3.74099700E-02  +3.91290000E-04  +5.16130000E-04  +4.55450000E-04  +5.79830000E-04
   +2.59710000E-04  -1.15090000E-04  -3.98800000E-05  +8.67600000E-05  -4.94000000E-05
   +3.23520000E-04  -1.61150000E-04  -8.22700000E-05  -1.83950000E-04  -2.06570000E-04
   +1.67720000E-04  +2.54590000E-04  -3.72520000E-04  +3.57480000E-04  -3.22920000E-04
   +2.33680000E-04  +3.35900000E-05  -1.90300000E-05  -1.02900000E-05  -9.44000000E-06
   +1.19800000E-05  +2.11000000E-05  +5.80000000E-07  -8.72000000E-06  -3.60000000E-06
   -1.92800000E-05  -9.86900000E-04  -1.92148000E-03  -5.21680000E-04  +3.21600000E-05
   -7.20000000E-06  +2.36000000E-05  +2.95830000E-04  -1.64420000E-04  +2.56630000E-04
   -1.92980000E-04  +9.55300000E-05  +1.05820000E-04  +1.87400000E-04  -2.27140000E-04
   +9.41000000E-06  -1.21380000E-03  -6.15160000E-04  +1.47320000E-04  -1.94564300E-02
   +1.57403900E-02  +4.05866000E-03  +2.37881320E-01  +7.54000000E-05  +1.26930000E-04
   +9.18400000E-05  -8.34000000E-06  -3.17500000E-05  +3.31200000E-05  +1.19890000E-04
   +1.43910000E-04  +8.61400000E-05  -2.72970000E-04  -8.93800000E-05  -9.28400000E-05
   +5.72380000E-04  +4.65230000E-04  +2.46450000E-04  +3.57920000E-04  -4.56620000E-04
   -1.15214000E-03  -3.14740000E-04  +1.60040000E-04  +4.84580000E-04  +1.10119900E-02
   -7.98082000E-03  -9.57850000E-04  -1.72530000E-04  +3.82970000E-04  +1.23927000E-03
   +1.20561450E-01  -1.33132460E-01  -2.63176800E-02  -2.32830000E-04  -1.66450000E-04
   -2.86371000E-03  -4.59810000E-04  -4.52910000E-04  +1.34440000E-04  +5.89150000E-04
   -3.56670000E-04  +1.60550000E-04  -1.36590000E-04  +4.85430000E-04  -3.45380000E-04
   -3.58610000E-04  +3.98400000E-04  +6.72900000E-05  +4.34430000E-04  -1.40120000E-04
   -2.58400000E-04  +3.50270000E-04  -2.88900000E-04  -1.25900000E-05  -1.94000000E-06
   -9.92000000E-06  -2.30000000E-06  +5.43000000E-06  -6.90000000E-07  +1.82700000E-05
   +1.66300000E-05  +4.47600000E-05  +1.30910000E-04  -1.53830000E-03  -1.40174000E-03
   +6.20520000E-04  -1.54500000E-05  -3.11100000E-05  -2.25800000E-05  -1.79430000E-04
   +5.64590000E-04  -7.86500000E-05  -1.52450000E-04  -2.36700000E-05  -9.59900000E-05
   -2.36400000E-04  -5.32300000E-05  +3.36200000E-05  +1.74940000E-02  -1.17298300E-02
   -5.31963000E-03  -1.53302100E-02  +1.19157900E-02  +3.68345000E-03  -1.32269690E-01
   +1.41753650E-01  +6.66300000E-05  +6.01100000E-05  -9.70000000E-07  -1.21230000E-04
   -1.40500000E-05  +1.78400000E-04  +1.53080000E-04  +1.22830000E-04  +1.48000000E-06
   -8.87800000E-05  +7.53000000E-06  -2.48860000E-04  +3.21000000E-04  +5.77430000E-04
   +7.53810000E-04  -2.40960000E-04  +2.32580000E-04  +2.55830000E-04  -1.77310000E-04
   -9.04600000E-05  -3.71000000E-05  +2.44444900E-02  -1.58209100E-02  -5.93299000E-03
   +1.19474000E-03  -8.19970000E-04  +1.34038000E-03  +3.67328800E-02  -2.52993000E-02
   -5.62358800E-02  -1.13393000E-03  -2.20974000E-03  -4.70337000E-03  +5.33040000E-04
   -4.32680000E-04  +1.88230000E-04  +2.96950000E-04  -1.44200000E-05  +3.59570000E-04
   -4.30830000E-04  +2.56080000E-04  +6.13000000E-06  +4.20620000E-04  +6.93600000E-05
   -2.35200000E-04  -5.44900000E-05  +3.51890000E-04  -7.18900000E-05  +6.20140000E-04
   -4.25150000E-04  +1.97900000E-05  -4.97000000E-06  -1.76600000E-05  -5.30000000E-06
   +2.16100000E-05  -1.12200000E-05  +1.10700000E-05  +5.17400000E-05  +3.58000000E-06
   +6.07300000E-05  -6.42100000E-05  -1.16800000E-04  +3.44090000E-04  +2.57000000E-06
   -8.50000000E-06  +1.06000000E-06  -6.20060000E-04  +3.35270000E-04  -6.43930000E-04
   +4.06100000E-05  +1.26990000E-04  -6.38000000E-05  -2.53820000E-04  +6.84500000E-05
   +4.17600000E-04  -1.92050300E-02  +1.17229300E-02  +4.80144000E-03  -1.03768000E-03
   +1.04590000E-03  -6.35100000E-04  -4.14916500E-02  +3.04807400E-02  +6.03308200E-02
   +6.86200000E-05  +6.36200000E-05  +3.00000000E-06  -4.23500000E-05  -4.88800000E-05
   +1.12800000E-05  +2.66600000E-05  +2.67100000E-05  -5.50600000E-05  -6.03900000E-05
   +1.19360000E-04  +1.05590000E-04  -1.90960000E-04  +1.31270000E-04  -2.34750000E-04
   +5.16800000E-05  +4.54400000E-05  -3.45600000E-05  +2.26800000E-05  +4.89000000E-06
   +9.71000000E-06  +2.77490000E-04  -9.20160000E-04  -1.85434000E-03  -1.33832000E-03
   +2.36230000E-04  +8.10390000E-04  +3.20420000E-04  +5.95200000E-05  -9.45500000E-05
   +5.65979000E-03  -1.81284900E-02  +1.26613900E-02  -5.57720700E-02  +2.92727900E-02
   -8.96949000E-03  +7.71420000E-04  +2.25047500E-02  -1.47589000E-02  -2.48823000E-03
   +2.78100000E-03  +2.38832000E-03  -1.61482000E-03  +7.65340000E-04  -2.35020000E-04
   -9.10770000E-04  -1.72958000E-03  +4.98938000E-03  +2.03480000E-04  +1.47449000E-03
   -6.98550000E-04  -6.18000000E-06  -1.64600000E-05  -2.40000000E-07  +8.36000000E-06
   -1.09000000E-06  +1.24600000E-05  +6.02300000E-05  -7.14200000E-05  +1.12000000E-06
   -6.27000000E-06  -1.42700000E-05  +5.47000000E-06  +1.04400000E-05  -1.27000000E-06
   -7.50000000E-07  +2.38690000E-04  -5.90700000E-05  -1.07480000E-04  -9.78110000E-04
   +1.12098000E-03  +3.85760000E-04  -1.27790000E-03  +2.22890000E-04  -3.74650000E-04
   +1.50600000E-05  -3.53000000E-06  -1.66680000E-04  +3.85200000E-05  -2.59000000E-05
   +1.59900000E-05  -4.58600000E-05  -3.60500000E-05  -5.72000000E-05  +5.71605000E-02
   -2.54300000E-05  -2.62700000E-05  -2.05700000E-05  +2.02000000E-05  +2.90000000E-05
   +2.89700000E-05  +1.05100000E-05  +8.20000000E-07  -5.47000000E-05  -1.04900000E-04
   +6.08600000E-05  +1.42330000E-04  -2.47350000E-04  +2.52170000E-04  +2.43430000E-04
   -5.33800000E-05  -8.81300000E-05  -9.07300000E-05  -1.46000000E-05  -1.78700000E-05
   -7.50000000E-07  -1.83790000E-04  -2.12207000E-03  -1.49979000E-03  +1.72986000E-03
   -2.33000000E-06  -3.64040000E-04  +3.45660000E-04  -1.08180000E-04  -1.16580000E-04
   +1.86087000E-03  -3.69665000E-03  +5.26056000E-03  +2.98275600E-02  -2.48401650E-01
   +1.37117280E-01  -1.52990000E-04  -9.90245000E-03  +9.26580000E-03  +3.26588000E-03
   +1.75801000E-03  +5.93980000E-04  -2.32890000E-04  +1.38570000E-04  -8.85600000E-04
   -4.05310000E-04  +1.13502000E-03  +3.58650000E-03  +3.25890000E-04  -5.97110000E-04
   +8.44870000E-04  -1.28000000E-06  -3.06000000E-06  +8.63000000E-06  -4.75000000E-06
   -1.42900000E-05  +4.60000000E-06  +1.14600000E-05  -8.23100000E-05  +1.34600000E-05
   +8.61000000E-06  -4.26000000E-06  -3.15000000E-06  -6.84000000E-06  -1.07100000E-05
   -1.60000000E-06  +1.96910000E-04  +8.85600000E-05  -5.29840000E-04  +1.55384000E-03
   -5.06330000E-04  -2.89730000E-04  -2.00290000E-04  -1.90370000E-04  -2.95970000E-04
   -2.23000000E-06  -1.04100000E-05  -4.25900000E-05  -1.35800000E-05  -1.85100000E-05
   +2.70200000E-05  -6.08500000E-05  +4.62000000E-06  -9.41000000E-05  -3.66819900E-02
   +2.62841480E-01  -2.04100000E-05  -2.71200000E-05  -1.03700000E-05  +1.29900000E-05
   +2.00500000E-05  -1.43400000E-05  -7.71000000E-06  -2.49300000E-05  -2.19700000E-05
   -1.46500000E-05  -4.91200000E-05  +1.20230000E-04  -1.59740000E-04  +8.76700000E-05
   +3.34320000E-04  -1.24070000E-04  -1.32490000E-04  -3.11700000E-05  +3.80000000E-06
   +1.13900000E-05  +2.07000000E-05  -2.44362000E-03  -1.04774000E-03  -2.24943000E-03
   -2.08490000E-04  +7.26920000E-04  +5.72950000E-04  +7.75710000E-04  -1.64070000E-04
   -9.52100000E-05  -2.10017000E-03  +1.68716000E-02  -5.92044000E-03  -9.26625000E-03
   +1.37966060E-01  -1.27961180E-01  +1.61060000E-03  -3.83636000E-03  +4.79000000E-03
   +2.16837000E-03  +9.37880000E-04  +3.18207000E-03  -9.12800000E-05  -1.22993000E-03
   -4.39200000E-04  +4.32802000E-03  +3.77159000E-03  +6.23730000E-04  +9.04600000E-05
   +2.26790000E-04  +6.58480000E-04  -4.12000000E-06  +3.65000000E-06  +2.55000000E-06
   -8.21000000E-06  -7.62000000E-06  -1.87000000E-06  +6.24000000E-06  +1.31000000E-05
   -2.40600000E-05  +7.45000000E-06  +4.72000000E-06  -1.63800000E-05  -9.38000000E-06
   -5.77000000E-06  -2.46000000E-06  -4.23480000E-04  -3.80210000E-04  +5.22700000E-05
   +2.71660000E-04  -9.45720000E-04  -3.40100000E-05  -3.50290000E-04  +8.68200000E-05
   +4.77400000E-05  -6.23700000E-05  -6.21600000E-05  +7.96000000E-05  -3.09000000E-06
   -5.43900000E-05  -9.85400000E-05  -1.09200000E-05  -9.07300000E-05  -2.21690000E-04
   +7.67304000E-03  -1.50731860E-01  +1.28356760E-01  -6.82200000E-05  -5.86800000E-05
   -1.72800000E-05  +5.77300000E-05  +3.94400000E-05  +4.40000000E-07  -3.88900000E-05
   -2.35400000E-05  +1.13200000E-05  -1.08800000E-05  -1.70000000E-06  +3.09300000E-05
   -2.17500000E-05  +2.12660000E-04  +7.77100000E-05  -5.22800000E-05  -6.51400000E-05
   -4.01900000E-05  -3.25000000E-06  -1.70400000E-05  +4.33000000E-06  -1.10650000E-04
   -6.52380000E-04  +6.57780000E-04  -5.01000000E-06  -9.99900000E-05  +3.59000000E-05
   -2.13520000E-04  +7.93400000E-05  -5.26600000E-05  -2.23155000E-03  +4.15152000E-03
   +1.65134000E-03  -1.27864400E-02  -1.01946000E-02  +1.58823400E-02  -1.99495890E-01
   -5.83447200E-02  +1.36382770E-01  +5.78829000E-03  +3.10374000E-03  -2.63636000E-03
   +1.28447000E-03  +2.25930000E-03  +1.03485000E-03  -5.65400000E-05  +7.44290000E-04
   -8.65550000E-04  -2.39300000E-05  -1.49202000E-03  -1.12489000E-03  +4.45000000E-06
   +8.37000000E-06  +8.35000000E-06  -1.28200000E-05  -1.24000000E-05  -6.24000000E-06
   +1.82000000E-06  +1.82700000E-05  +1.40700000E-05  +9.90000000E-06  +1.04400000E-05
   -7.11000000E-06  -9.26000000E-06  -6.53000000E-06  +3.70000000E-07  -6.86000000E-06
   +4.53200000E-05  -1.50300000E-05  +2.80300000E-05  +2.05400000E-05  +9.60000000E-06
   -1.32100000E-05  +1.04000000E-05  -2.03600000E-05  +3.10000000E-06  -4.64000000E-06
   -1.95900000E-05  +2.24600000E-05  -1.32000000E-06  -5.70000000E-07  -1.99100000E-05
   +8.02600000E-05  +7.15000000E-05  -7.01300000E-05  -9.16800000E-04  -1.69252000E-03
   +2.07780690E-01  +2.96000000E-05  +2.36400000E-05  +6.55000000E-06  -8.53000000E-06
   -2.54300000E-05  -2.78200000E-05  -1.64500000E-05  -2.59000000E-06  -4.59000000E-06
   +2.08400000E-05  -9.37000000E-06  +2.07900000E-05  +2.22200000E-04  -1.84890000E-04
   -6.50100000E-05  +7.38000000E-06  +3.27000000E-06  +3.95200000E-05  +1.66800000E-05
   +4.66600000E-05  -2.70000000E-07  +4.29590000E-04  +5.29400000E-04  -2.76610000E-04
   -7.22900000E-05  +6.10100000E-05  -4.10200000E-05  +3.58800000E-05  +2.22000000E-05
   +6.12300000E-05  +4.37154000E-03  +4.02850000E-04  +1.17707000E-03  +1.21476500E-02
   +8.95195000E-03  -1.18066500E-02  -5.70158600E-02  -8.04593700E-02  +6.56426500E-02
   -2.10175900E-02  -2.66391000E-03  +1.75564900E-02  +2.68189000E-03  -1.94217000E-03
   +3.98724000E-03  +6.56020000E-04  -1.34199000E-03  +1.20170000E-04  -9.81920000E-04
   +7.68770000E-04  -2.66820000E-03  -2.06000000E-06  -2.22000000E-06  -5.40000000E-07
   -2.31000000E-06  +4.00000000E-08  +2.42000000E-06  +4.02000000E-06  +1.04000000E-05
   +7.46000000E-06  +6.32000000E-06  -1.00700000E-05  -1.84000000E-06  +4.55000000E-06
   +6.15000000E-06  -2.24000000E-06  +8.90000000E-07  -9.52000000E-06  +2.75800000E-05
   +1.96000000E-06  -3.31100000E-05  -4.82000000E-06  +3.57000000E-06  +2.18700000E-05
   +2.78000000E-05  -3.02000000E-06  +2.91000000E-06  -1.89000000E-05  -1.27500000E-05
   -7.70000000E-06  -1.20300000E-05  +3.40000000E-07  +4.87000000E-06  -2.79800000E-05
   -1.39260000E-03  -5.72050000E-04  -1.76194000E-03  +6.11371100E-02  +7.73656600E-02
   +4.80300000E-05  +3.81100000E-05  +9.13000000E-06  -2.52200000E-05  -4.17300000E-05
   -3.74000000E-05  -1.83700000E-05  -1.93000000E-05  -1.18100000E-05  +2.45400000E-05
   -9.51000000E-06  +1.96600000E-05  +1.98130000E-04  -1.08540000E-04  -2.75700000E-05
   -2.03600000E-05  -1.85100000E-05  +4.49900000E-05  +2.36800000E-05  +4.66700000E-05
   +1.46600000E-05  -1.16100000E-05  +2.27400000E-04  +2.05130000E-04  -1.50000000E-06
   -1.90000000E-05  -5.84500000E-05  -1.13400000E-05  +5.96100000E-05  +3.46500000E-05
   +1.26081000E-03  +1.18580000E-03  +4.11812000E-03  +2.71410000E-04  +1.08846000E-03
   +1.30490000E-03  +1.35422990E-01  +6.65695100E-02  -1.59252170E-01  +1.45238900E-02
   +3.55355000E-03  -5.85617000E-03  +6.75000000E-04  +4.23107000E-03  +2.47450000E-03
   -9.86210000E-04  +1.48000000E-04  -1.71210000E-04  -1.52591000E-03  -2.34425000E-03
   -1.27668000E-03  -7.01000000E-06  -5.85000000E-06  -2.69000000E-06  -3.03000000E-06
   +1.19000000E-06  +2.22000000E-06  -9.58000000E-06  +7.24000000E-06  -8.21000000E-06
   +4.78000000E-06  -4.76000000E-06  -3.77000000E-06  +2.65000000E-06  +5.84000000E-06
   -3.26000000E-06  +1.86900000E-05  +3.09000000E-06  +1.72800000E-05  +1.88800000E-05
   +7.76000000E-06  +8.18000000E-06  -2.24500000E-05  +2.55100000E-05  +1.87000000E-06
   -5.76000000E-06  +7.76000000E-06  -3.72200000E-05  +1.14000000E-06  -2.63000000E-06
   +6.90000000E-06  +3.60000000E-07  +4.46300000E-05  -1.73200000E-05  -1.37278000E-03
   -2.06784000E-03  -1.90298000E-03  -1.48710750E-01  -7.26406000E-02  +1.61491850E-01
   +1.33480000E-04  +9.16000000E-05  +2.57400000E-05  -1.24590000E-04  -9.18100000E-05
   -2.94800000E-05  +3.15000000E-05  -3.56400000E-05  -2.60400000E-05  +1.64400000E-05
   -4.16100000E-05  +1.86600000E-05  +2.28700000E-05  -2.70500000E-05  +1.24900000E-05
   -4.06100000E-05  -1.51000000E-05  +4.14000000E-05  +2.18300000E-05  +2.36900000E-05
   +3.69000000E-05  -1.62540000E-04  -5.71300000E-05  -1.70800000E-05  +5.15700000E-05
   -8.27000000E-06  -1.31700000E-05  +2.99700000E-05  +2.39700000E-05  -2.31300000E-05
   -4.54010000E-04  -1.27850000E-04  +4.21150000E-04  +1.48801000E-03  +9.17350000E-04
   -2.47430000E-04  -5.87486000E-03  +2.77873000E-03  +2.01868000E-03  -3.13563000E-03
   +3.63850200E-02  -2.52371700E-02  -2.54343000E-03  +6.05338000E-03  -1.90779000E-03
   +4.97110000E-04  -9.55700000E-05  -4.37970000E-04  -4.11980000E-02  -3.88313400E-02
   +4.75047900E-02  -3.24900000E-05  -1.29900000E-05  -1.57700000E-05  -9.51000000E-06
   +1.47400000E-05  -3.64000000E-06  -1.65600000E-05  +1.93400000E-05  -3.46700000E-05
   -1.03100000E-05  +5.13000000E-06  -6.03000000E-06  +2.95000000E-06  +5.40000000E-06
   -6.42000000E-06  +1.63800000E-05  -2.51700000E-05  +7.60000000E-06  -2.00900000E-05
   -1.03000000E-06  -4.35000000E-06  -8.47000000E-06  +1.01400000E-05  -4.45000000E-06
   -1.07600000E-05  +8.81000000E-06  +2.67600000E-05  -1.05600000E-05  -6.80000000E-07
   +1.48500000E-05  +2.14600000E-05  -1.76000000E-05  -7.65000000E-06  -3.76190000E-04
   +1.43980000E-04  +3.61900000E-05  -7.15600000E-05  -1.73140000E-04  -1.62030000E-04
   +5.02077000E-02  -1.84940000E-04  -1.75590000E-04  -3.23500000E-05  +1.47170000E-04
   +1.38050000E-04  +5.36000000E-05  -4.14800000E-05  +5.80000000E-07  +5.35700000E-05
   -8.91000000E-06  -3.55000000E-06  -8.46000000E-06  -1.77200000E-05  +1.65970000E-04
   +1.99300000E-05  +1.14500000E-05  -2.00700000E-05  -5.68200000E-05  -3.53500000E-05
   -7.05700000E-05  -3.98100000E-05  +2.31630000E-04  -1.94900000E-04  -2.65900000E-05
   -7.97800000E-05  -1.53800000E-05  +3.71500000E-05  -1.47640000E-04  +6.02200000E-05
   -4.03800000E-05  +9.50000000E-06  +5.68010000E-04  -4.36430000E-04  -7.71000000E-05
   -1.30360000E-04  +1.60922000E-03  +3.15511000E-03  +7.95360000E-04  -1.65011000E-03
   +3.63732000E-03  -2.66113400E-02  +1.43131700E-02  -2.42460000E-03  +3.30266000E-03
   +1.41130000E-04  +1.17640000E-04  -1.57396000E-03  +8.02270000E-04  -6.57500000E-05
   -3.40785310E-01  +2.32679800E-01  +1.47600000E-05  +3.91300000E-05  +1.00600000E-05
   -1.86700000E-05  -1.15600000E-05  -2.44500000E-05  +3.19600000E-05  +2.98000000E-05
   +5.31700000E-05  +1.79500000E-05  +8.66000000E-06  -8.12000000E-06  -1.51600000E-05
   -5.25000000E-06  +3.88000000E-06  -2.81300000E-05  +4.24100000E-05  -1.04200000E-05
   +1.33000000E-05  -2.23200000E-05  +6.76000000E-06  +1.68000000E-05  -8.68000000E-06
   -6.85000000E-06  +2.43300000E-05  -1.33100000E-05  -2.20000000E-05  +4.44000000E-06
   -3.86400000E-05  -2.66600000E-05  -5.34400000E-05  +5.27700000E-05  +5.96300000E-05
   +1.72160000E-04  -5.84600000E-05  -1.37890000E-04  -1.57330000E-04  +6.82400000E-05
   -3.71210000E-04  -4.15940000E-03  +3.65856690E-01  +4.52900000E-05  +4.00200000E-05
   -2.26000000E-06  -3.03500000E-05  -3.41400000E-05  -1.39800000E-05  +8.36000000E-06
   -9.89000000E-06  -1.20700000E-05  +4.92000000E-06  +1.02700000E-05  +4.65100000E-05
   +2.05300000E-05  -5.88600000E-05  -1.21800000E-05  -2.19600000E-05  -1.27000000E-06
   +1.08100000E-05  +2.26700000E-05  +3.85400000E-05  +4.40000000E-07  -1.93280000E-04
   -1.64100000E-05  -2.27930000E-04  +1.52800000E-05  +1.85400000E-05  -2.51700000E-05
   +1.59350000E-04  -8.72500000E-05  +4.53200000E-05  +2.94950000E-04  -2.69050000E-04
   +1.52270000E-04  +4.34120000E-04  +1.08656000E-03  +1.08332000E-03  +1.68992000E-03
   -1.32111000E-03  +1.04268000E-03  -2.42606000E-03  -4.24661000E-03  +1.35309000E-03
   +3.91430000E-03  -4.63552000E-03  +2.54499000E-03  -5.71300000E-04  +8.24940000E-04
   -6.02070000E-04  +2.05644700E-02  +2.54609860E-01  -1.93139900E-01  -7.78000000E-06
   -6.47000000E-06  +4.28000000E-06  -7.09000000E-06  -5.30000000E-07  +1.13000000E-06
   -3.87000000E-06  +8.39000000E-06  -2.60300000E-05  +4.08000000E-06  -1.42800000E-05
   -4.60000000E-07  +9.62000000E-06  -2.60000000E-07  -1.01000000E-06  +1.34800000E-05
   -1.42500000E-05  -1.67000000E-06  -5.82000000E-06  +2.58000000E-06  +3.14000000E-06
   -1.15900000E-05  +4.56000000E-06  -1.00500000E-05  +1.15700000E-05  +1.64600000E-05
   -1.51400000E-05  -7.00000000E-07  +3.64000000E-06  +2.28100000E-05  +1.70500000E-05
   -2.39800000E-05  -7.71800000E-05  +3.34400000E-05  -1.22680000E-04  -4.19900000E-05
   -1.79030000E-04  -3.54780000E-04  -2.12710000E-04  -2.20010900E-02  -2.46712620E-01
   +1.89867340E-01  -1.92040000E-04  -1.43450000E-04  -3.88200000E-05  +1.73530000E-04
   +1.30380000E-04  +4.19500000E-05  -4.32900000E-05  +3.41900000E-05  +2.67500000E-05
   -3.84100000E-05  +5.30000000E-06  +8.81000000E-06  +1.33980000E-04  +7.53900000E-05
   +8.04600000E-05  +2.92200000E-05  -1.11000000E-06  -8.19000000E-05  -2.79300000E-05
   -4.20700000E-05  -5.31500000E-05  +7.65090000E-04  +6.14190000E-04  -7.57700000E-04
   -4.44200000E-04  +1.20840000E-04  +1.68950000E-04  +6.35000000E-06  -8.67800000E-05
   -6.24700000E-05  -2.86990000E-03  -2.81300000E-04  +5.06738000E-03  +1.65945000E-03
   +6.44060000E-04  -2.07640000E-03  -5.48964000E-03  +2.25740000E-03  +3.73458000E-03
   +2.32961000E-03  -2.54858500E-02  +2.27963500E-02  -9.71784800E-02  +2.82600500E-02
   +1.34552800E-02  -4.66334000E-03  +3.53097700E-02  -2.08467600E-02  +6.33082000E-03
   -7.64887000E-03  -5.86470000E-04  +3.69800000E-05  +2.13000000E-05  +2.24500000E-05
   -2.12000000E-06  -2.21800000E-05  -7.80000000E-07  +8.60000000E-07  -5.47000000E-06
   +3.59500000E-05  +1.73700000E-05  +3.80000000E-07  +3.65000000E-06  -1.01600000E-05
   -1.10500000E-05  +7.04000000E-06  -5.85100000E-05  +1.06880000E-04  -1.26980000E-04
   +2.75600000E-05  -9.61000000E-06  +3.82000000E-06  +2.05200000E-05  -4.21000000E-06
   -3.08300000E-05  +1.52200000E-05  -2.23600000E-05  -5.72700000E-05  +2.36300000E-05
   +2.53800000E-05  +2.26000000E-06  -2.84100000E-05  +5.11200000E-05  +1.01400000E-05
   +3.59360000E-04  +3.59100000E-05  -9.20700000E-05  +3.41350000E-04  -1.16131000E-03
   +5.64160000E-04  +7.64720000E-04  +1.48310000E-04  -1.03638000E-03  +4.55456640E-01
   +8.79490000E-04  +8.95420000E-04  +1.18900000E-04  -6.47870000E-04  -6.80450000E-04
   -3.11540000E-04  +1.27470000E-04  +5.02500000E-05  -2.87580000E-04  -2.19800000E-05
   +9.23000000E-06  +1.48190000E-04  -1.70670000E-04  -7.78200000E-04  -1.64890000E-04
   -2.33280000E-04  +5.07200000E-05  +2.73880000E-04  +2.37620000E-04  +4.51790000E-04
   +1.82610000E-04  -1.58528000E-03  +2.34300000E-04  +9.81500000E-04  +8.24350000E-04
   -2.72510000E-04  -1.96120000E-04  +3.63790000E-04  -8.94500000E-05  +4.35900000E-05
   +7.33180000E-04  +2.22844000E-03  +2.29256000E-03  +3.38558000E-03  -5.50515000E-03
   +1.34172000E-03  -1.65102000E-03  +6.57998000E-03  -1.09472000E-03  +7.61914000E-03
   -2.98990800E-02  +2.38797500E-02  +5.58164000E-02  -2.31486080E-01  +1.03894980E-01
   +1.42039000E-02  -3.15039100E-02  +1.48301800E-02  -6.01861000E-03  +6.67243000E-03
   -3.80157000E-03  -2.93800000E-05  -2.07790000E-04  -3.50000000E-06  +1.01540000E-04
   +2.61200000E-05  +1.53000000E-04  -1.95790000E-04  -2.13350000E-04  -2.38260000E-04
   -6.86200000E-05  -7.61800000E-05  +3.56600000E-05  +1.10820000E-04  -3.39000000E-06
   -3.46000000E-06  +2.43070000E-04  -2.87230000E-04  +7.85000000E-06  -5.96700000E-05
   +3.15610000E-04  +7.62000000E-06  -1.89590000E-04  +2.54400000E-05  -1.55370000E-04
   -7.91500000E-05  +7.15100000E-05  +7.25400000E-05  -2.82400000E-05  +1.62600000E-04
   +1.59540000E-04  +1.89420000E-04  -2.30380000E-04  -1.37370000E-04  -1.35300000E-05
   +6.26400000E-05  +4.94400000E-05  +5.48600000E-05  -6.65930000E-04  +3.02610000E-04
   -1.27710000E-03  -1.16303000E-03  +7.84060000E-04  +1.71190900E-02  +3.36070940E-01
   -4.73810000E-04  -4.47350000E-04  -4.47900000E-05  +3.56710000E-04  +3.47770000E-04
   +1.17250000E-04  -8.42900000E-05  +1.95700000E-05  +1.72450000E-04  +3.49200000E-05
   -9.10600000E-05  -1.65020000E-04  -1.57300000E-05  +3.00930000E-04  +1.88320000E-04
   +9.47200000E-05  -3.45500000E-05  -1.28920000E-04  -1.31900000E-04  -2.42730000E-04
   -6.53000000E-05  +1.12105000E-03  -1.89590000E-04  +6.76200000E-05  -2.45250000E-04
   +3.53200000E-05  +6.46600000E-05  -2.20860000E-04  +9.83600000E-05  -3.66300000E-05
   +4.42516000E-03  +3.25333000E-03  +2.39290000E-04  -4.47656000E-03  +2.93545000E-03
   -6.74700000E-04  +6.44108000E-03  -3.67711000E-03  +2.71791000E-03  -2.35650000E-04
   +4.31125900E-02  -1.85598100E-02  -5.55850000E-03  +1.18146380E-01  -1.16477050E-01
   -6.26392000E-03  +2.49772000E-03  +4.46301000E-03  -1.41342000E-03  -3.23512000E-03
   -7.43150000E-04  +4.03100000E-05  +9.76200000E-05  +7.90000000E-07  -2.45100000E-05
   -1.73800000E-05  -5.50300000E-05  +1.25080000E-04  +1.08680000E-04  +1.57010000E-04
   +2.25400000E-05  +6.33800000E-05  -1.40900000E-05  -6.87100000E-05  +5.50000000E-07
   +4.26000000E-06  -1.83380000E-04  +4.44500000E-05  +7.01000000E-06  +1.79600000E-05
   -2.25610000E-04  +1.65000000E-06  +1.40490000E-04  -8.30000000E-06  +9.35500000E-05
   -3.60000000E-06  -3.25200000E-05  -4.05200000E-05  +9.80000000E-07  -8.72400000E-05
   -1.29640000E-04  -1.25200000E-04  +9.64200000E-05  +1.11620000E-04  -8.44200000E-05
   +7.06200000E-05  +2.17630000E-04  -3.25590000E-04  +9.51180000E-04  -7.09990000E-04
   -9.88000000E-06  +4.84300000E-05  -1.12029000E-03  -2.42657900E-01  -2.23512660E-01
   +3.05843470E-01  +5.45300000E-05  -2.23000000E-06  +2.74800000E-05  -9.32000000E-05
   -3.24000000E-05  -4.95000000E-06  +2.55100000E-05  -6.29300000E-05  +2.27000000E-06
   +4.79600000E-05  -8.43300000E-05  -7.38300000E-05  +1.26750000E-04  +8.02100000E-05
   +5.36000000E-05  -9.58000000E-06  -1.57000000E-05  +6.98700000E-05  -2.59200000E-05
   -6.71200000E-05  +4.56800000E-05  +1.76470000E-04  +7.14600000E-05  -1.00720000E-04
   -7.87200000E-05  +1.53200000E-05  -6.61000000E-06  -3.75200000E-05  +3.40300000E-05
   -2.98200000E-05  -1.18075000E-03  +2.44520000E-04  -1.18700000E-05  -2.02450000E-04
   +2.95300000E-04  +5.56000000E-06  +5.94930000E-04  -4.69500000E-04  +4.77850000E-04
   -8.86050000E-04  +3.86630000E-03  -1.19179000E-03  +6.35000000E-03  +3.98045000E-03
   -6.85419000E-03  +2.22623000E-03  +9.30520000E-04  -2.03675000E-03  +6.29470000E-04
   -1.08726000E-03  +5.05230000E-04  -3.66600000E-05  +8.25000000E-06  -2.80200000E-05
   -1.47000000E-05  +1.79200000E-05  -2.23300000E-05  +1.33600000E-05  +3.88300000E-05
   +1.27600000E-05  -2.83000000E-06  +2.90500000E-05  -1.55000000E-05  -1.94600000E-05
   +1.41500000E-05  -7.58000000E-06  -1.71800000E-05  +2.53700000E-05  +5.80000000E-06
   -1.29200000E-05  -5.45300000E-05  +8.81000000E-06  +2.10300000E-05  +3.26000000E-06
   +1.79500000E-05  +3.61200000E-05  +2.33600000E-05  +3.57100000E-05  -1.56300000E-05
   -5.72900000E-05  +2.87000000E-06  -1.14600000E-05  +1.36300000E-05  +8.04000000E-06
   -1.14870000E-04  -2.78800000E-05  +1.08310000E-04  +2.60000000E-07  +8.18000000E-05
   -1.65240000E-04  +7.94180000E-04  -2.38430000E-04  -7.67070000E-04  -3.57445840E-01
   -8.97399400E-02  +2.49782100E-01  +3.49108940E-01  -2.50240000E-04  -2.75860000E-04
   -3.49500000E-05  +2.18370000E-04  +2.02500000E-04  +7.15000000E-05  -6.13500000E-05
   -5.10600000E-05  +6.44100000E-05  +6.46000000E-06  +5.89500000E-05  +2.08100000E-05
   +1.20800000E-05  +1.72260000E-04  -1.22400000E-05  +5.19700000E-05  +7.63000000E-06
   -7.91600000E-05  -3.15500000E-05  -8.94200000E-05  -5.91700000E-05  +2.60560000E-04
   +2.03300000E-05  -2.32200000E-05  -1.54880000E-04  +8.72000000E-06  +3.30300000E-05
   -1.24030000E-04  -3.96700000E-05  +3.36500000E-05  -1.73850000E-04  -3.76180000E-04
   -1.15800000E-04  +1.40070000E-04  +2.51270000E-04  -2.97620000E-04  -1.23597000E-03
   +6.91540000E-04  +9.22740000E-04  +3.10584000E-03  -5.56803000E-03  +3.27337000E-03
   -3.33622300E-02  -1.42020100E-02  +2.67594600E-02  -5.12220000E-04  +1.62730000E-03
   -1.14346000E-03  +1.22911000E-03  +8.09600000E-04  -1.23811000E-03  -4.00000000E-07
   +6.67300000E-05  -4.80000000E-06  -3.06900000E-05  -5.97000000E-06  -4.77200000E-05
   +1.86400000E-05  +2.52500000E-05  +4.37700000E-05  +3.53400000E-05  -2.50000000E-06
   -1.26200000E-05  -2.52200000E-05  +4.86000000E-06  +2.80000000E-06  -3.04100000E-05
   +6.16200000E-05  -2.22600000E-05  +9.75000000E-06  -2.86400000E-05  +5.82000000E-06
   +2.00700000E-05  +1.26000000E-06  -2.07700000E-05  +6.53000000E-05  -1.50000000E-05
   -5.87600000E-05  +4.16000000E-06  -2.72200000E-05  -1.99800000E-05  -4.91700000E-05
   +7.26800000E-05  +1.90200000E-05  +1.42830000E-04  +6.17400000E-05  -8.76500000E-05
   +7.29900000E-05  -3.59590000E-04  +9.99300000E-05  -1.48280000E-03  -2.26270000E-04
   +4.81540000E-04  -5.00343300E-02  -5.08453000E-02  +5.95724800E-02  +8.21658300E-02
   +6.79684600E-02  +1.40840000E-04  +9.57500000E-05  +4.23000000E-06  -1.36520000E-04
   -9.82000000E-05  -1.33900000E-05  +1.08500000E-05  -1.06060000E-04  -3.00000000E-05
   +5.18000000E-05  +1.16300000E-05  +6.67100000E-05  +2.20800000E-05  -7.62500000E-05
   -4.59700000E-05  -7.18800000E-05  +1.67400000E-05  +3.90000000E-05  +4.85600000E-05
   +7.71600000E-05  +5.28000000E-06  -2.33780000E-04  +3.87900000E-05  +1.43030000E-04
   +1.06420000E-04  -4.91100000E-05  -6.01400000E-05  +6.45300000E-05  -9.35400000E-05
   +9.11400000E-05  +3.71870000E-04  -4.32000000E-04  -5.90890000E-04  +7.25500000E-05
   -3.52840000E-04  +2.97020000E-04  +1.10444000E-03  +5.11470000E-04  -5.02400000E-05
   -6.07590000E-04  +2.88621000E-03  +2.43000000E-06  +1.88024700E-02  +6.91668000E-03
   -1.64043500E-02  -1.05944000E-03  -1.70787000E-03  +1.44500000E-03  -1.15932000E-03
   +3.09750000E-04  +6.36740000E-04  -3.96600000E-05  -1.17100000E-05  -7.26000000E-06
   -2.47200000E-05  +1.54200000E-05  -2.13600000E-05  -1.71500000E-05  +3.28500000E-05
   -6.85500000E-05  +1.16500000E-05  -3.67300000E-05  -8.76000000E-06  +2.79600000E-05
   -3.15000000E-06  -1.47000000E-06  +3.71000000E-05  -3.07800000E-05  +1.99400000E-05
   -1.74100000E-05  +2.13800000E-05  +7.62000000E-06  -2.30300000E-05  +1.25200000E-05
   -2.92800000E-05  +1.66300000E-05  +3.14400000E-05  +3.48000000E-06  -1.27900000E-05
   +6.28000000E-06  +1.87000000E-05  +2.79700000E-05  -1.77900000E-05  -5.14700000E-05
   -6.93000000E-06  +4.07000000E-06  +2.82300000E-05  -1.59880000E-04  +8.77100000E-05
   -1.64440000E-04  +3.00600000E-05  -2.80600000E-04  -6.36070000E-04  +2.22475910E-01
   +8.03468300E-02  -1.75502580E-01  -2.39853610E-01  -8.81260300E-02  +1.90877670E-01
end_hess

