# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.26632850    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.79037845E+00  -5.79473129E-01  +1.73558533E+00
   006   +2.25790947E+00  +1.26092695E+00  -1.02486399E-01
   006   +4.09541945E+00  +1.44296366E+00  -1.91325036E+00
   006   +6.29319668E+00  +1.14950300E-01  -2.17126315E+00
   006   +6.72942178E+00  -1.69416196E+00  -3.11822584E-01
   006   +4.98326323E+00  -2.02776754E+00  +1.62475471E+00
   006   -1.26258034E-01  +2.88782529E+00  -8.50982331E-02
   006   -6.06919688E-02  +4.63041159E+00  +2.23375928E+00
   008   +8.88106956E+00  -3.07824554E+00  -4.65266448E-01
   006   -2.47508440E+00  +1.19868696E+00  -1.54423107E-01
   006   -2.61499239E+00  -7.54901214E-01  -1.90838343E+00
   006   -4.72958757E+00  -2.28088223E+00  -2.10180475E+00
   006   -6.78450845E+00  -1.87634689E+00  -5.19569792E-01
   006   -6.68660120E+00  +5.85131598E-02  +1.24144461E+00
   006   -4.55202298E+00  +1.56626536E+00  +1.40934578E+00
   008   -8.91335788E+00  -3.31561916E+00  -6.14671085E-01
   006   -1.62412314E-01  +4.56625500E+00  -2.45636828E+00
   008   +1.09535721E+00  -9.13225725E-01  +3.62746831E+00
   001   -8.74226020E+00  -4.56152174E+00  -1.91334960E+00
   001   -4.77745631E+00  -3.79303038E+00  -3.48398778E+00
   001   -1.02512123E+00  -1.11298555E+00  -3.14678265E+00
   001   -4.52880575E+00  +3.04556821E+00  +2.81703498E+00
   001   -8.28619323E+00  +3.63608530E-01  +2.47620138E+00
   001   -1.87522093E+00  +5.71170664E+00  -2.46581740E+00
   001   +1.47039638E+00  +5.82578001E+00  -2.48786549E+00
   001   -1.38935544E-01  +3.43703942E+00  -4.17857497E+00
   001   -1.50003841E-01  +3.56852273E+00  +3.99243501E+00
   001   +1.69078309E+00  +5.71476783E+00  +2.21824459E+00
   001   -1.62552505E+00  +5.97175212E+00  +2.18987010E+00
   001   +7.63267834E+00  +4.04704883E-01  -3.68558770E+00
   001   +5.33246265E+00  -3.43245839E+00  +3.07762205E+00
   001   +8.96624359E+00  -4.24307372E+00  +9.14972273E-01
   001   +1.59899309E+00  -2.29757746E+00  +4.67520208E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +9.00000000E-08  -1.93000000E-06  +1.85000000E-06
   +6.20000000E-07  +1.90000000E-07  -1.75000000E-06
   -1.61000000E-06  +9.10000000E-07  +8.30000000E-07
   +1.10000000E-06  -1.35000000E-06  +6.60000000E-07
   +1.48000000E-06  +1.71000000E-06  -3.10000000E-06
   -1.36000000E-06  +7.00000000E-08  +1.35000000E-06
   +1.20000000E-07  +6.70000000E-07  -2.90000000E-07
   -6.20000000E-07  +9.00000000E-08  +1.20000000E-07
   -3.90000000E-07  +1.50000000E-07  +1.80000000E-07
   -2.17000000E-06  +2.29000000E-06  +2.03000000E-06
   -6.20000000E-07  -2.00000000E-06  -1.21000000E-06
   +2.55000000E-06  +2.60000000E-07  -3.60000000E-07
   -1.39000000E-06  +1.57000000E-06  +1.57000000E-06
   -9.90000000E-07  -2.14000000E-06  -8.30000000E-07
   +2.32000000E-06  -2.20000000E-07  -4.70000000E-07
   +6.90000000E-07  -1.09000000E-06  +2.90000000E-07
   -5.00000000E-07  -3.30000000E-07  +1.02000000E-06
   +1.49000000E-06  -1.80000000E-07  -9.30000000E-07
   +1.00000000E-08  -3.00000000E-08  -1.40000000E-07
   -2.30000000E-07  -1.50000000E-07  -2.00000000E-08
   +6.00000000E-08  +8.00000000E-08  +1.00000000E-08
   -2.50000000E-07  -4.30000000E-07  +1.20000000E-07
   +1.60000000E-07  -1.90000000E-07  +2.40000000E-07
   -3.10000000E-07  +1.80000000E-07  -3.00000000E-08
   -2.70000000E-07  +1.10000000E-07  +9.00000000E-08
   -2.90000000E-07  +3.50000000E-07  -2.10000000E-07
   -1.00000000E-08  +5.90000000E-07  -9.00000000E-08
   -1.30000000E-07  -1.10000000E-07  +2.40000000E-07
   -2.20000000E-07  -1.90000000E-07  +1.00000000E-08
   +2.00000000E-08  +5.20000000E-07  -3.60000000E-07
   +2.80000000E-07  +1.50000000E-07  -4.10000000E-07
   +2.40000000E-07  +6.20000000E-07  -4.90000000E-07
   +1.20000000E-07  -1.40000000E-07  +9.00000000E-08
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.73183710E-01  -1.76001910E-01  +4.47716350E-01  -1.38248640E-01  -1.96218770E-01
   +5.23190740E-01  -1.20473560E-01  +7.33013500E-02  -4.95147600E-02  +5.46053930E-01
   +2.72240500E-02  -1.80112300E-01  +1.07150360E-01  -1.39713970E-01  +3.88077180E-01
   +6.52346000E-03  +6.89963600E-02  -1.65088850E-01  -1.53264160E-01  -1.55122900E-01
   +4.91651810E-01  +4.27021400E-02  -6.22062900E-02  +4.79948900E-02  -2.20367490E-01
   +1.49677800E-02  +1.28854460E-01  +5.55450090E-01  -2.49875100E-02  +1.60703000E-02
   +1.28648000E-02  +8.61500000E-05  -7.61711400E-02  +3.32623800E-02  -1.70526620E-01
   +2.40682300E-01  +2.54355000E-03  +4.47647600E-02  -4.81155900E-02  +1.46936450E-01
   +2.13670500E-02  -2.03854610E-01  -2.01458350E-01  -5.47072900E-02  +3.20405300E-01
   -2.22112700E-02  +3.43044100E-02  -2.18103100E-02  -3.61221900E-02  -4.34996000E-03
   +4.16804900E-02  -2.83857660E-01  +1.38500890E-01  +3.31040200E-02  +5.98923660E-01
   +3.38568100E-02  -4.10379400E-02  +2.25767500E-02  +1.33211400E-02  +2.95003900E-02
   -4.07663400E-02  +1.22590250E-01  -1.40839520E-01  +7.83647000E-03  -1.74340690E-01
   +3.85150280E-01  -2.19349000E-02  +2.27202300E-02  -7.82699000E-03  +2.01334300E-02
   -2.57626400E-02  +2.09321200E-02  +5.23890100E-02  -5.28052000E-03  -8.68290100E-02
   -2.06641670E-01  -1.87641040E-01  +5.21162000E-01  -4.59068000E-02  +1.96457700E-02
   +1.33428200E-02  -8.74400000E-05  -1.40467400E-02  +1.83129200E-02  +2.90269000E-03
   +2.51272500E-02  -2.55618800E-02  -1.06697560E-01  +4.61367000E-02  -2.62098200E-02
   +5.73159920E-01  -1.57944700E-02  +3.72369800E-02  -3.54110400E-02  -1.37817300E-02
   -1.63818300E-02  +3.30361400E-02  +6.39778400E-02  -3.08378900E-02  -5.60922000E-03
   -1.81158000E-03  -1.78144080E-01  +1.33610200E-01  -1.78498500E-01  +4.54187650E-01
   +5.72214600E-02  -6.67487900E-02  +3.00032200E-02  +1.79601600E-02  +3.34864900E-02
   -5.65435100E-02  -7.40628400E-02  +2.78179000E-02  +3.81241100E-02  +3.29063800E-02
   +9.27475600E-02  -2.13674400E-01  -1.37876750E-01  -2.10455020E-01  +5.40645020E-01
   -2.41122010E-01  +9.01314500E-02  +4.20017800E-02  +1.20397200E-02  +4.10324800E-02
   -5.41681700E-02  -5.50928900E-02  +1.59174800E-02  +2.55397000E-02  +3.94981700E-02
   -4.30337600E-02  +2.82351700E-02  -1.90317220E-01  +2.24158600E-02  +8.11408500E-02
   +5.65181170E-01  +1.34423300E-01  -1.64649190E-01  +8.05754000E-03  +1.51029000E-02
   -1.94137900E-02  +2.20619800E-02  +1.48370100E-02  -9.15149000E-03  -4.12415000E-03
   -1.66454000E-02  +1.04137200E-02  +1.39541300E-02  -2.07185800E-02  -1.06325240E-01
   +6.98416600E-02  -1.94896140E-01  +4.39518060E-01  -1.23476700E-02  +4.58572400E-02
   -1.09445100E-01  -2.20619900E-02  -3.85250000E-04  +2.78923300E-02  +2.74852900E-02
   -5.41366000E-03  -1.91171400E-02  -4.59021000E-03  +3.70573600E-02  -3.19651700E-02
   +1.35278220E-01  +3.25380700E-02  -2.22377560E-01  -1.53008810E-01  -2.39237620E-01
   +5.43516100E-01  -7.20160000E-04  +9.05665000E-03  -7.23862000E-03  -1.34548090E-01
   +4.61648500E-02  +1.97203000E-03  -2.42149700E-02  +8.60264000E-03  +8.99817000E-03
   +1.72467000E-03  +9.34280000E-04  +1.64434000E-03  -1.84110000E-03  +1.06530000E-04
   +5.30640000E-04  +2.77953000E-03  -1.44330000E-04  +1.53129000E-03  +4.74054220E-01
   +1.81671300E-02  -1.10211900E-02  +3.99500000E-03  +4.63897700E-02  -1.03497350E-01
   +7.54257000E-03  +2.50994000E-03  +2.89478000E-03  -8.69439000E-03  -9.85650000E-04
   +2.93685000E-03  +3.92346000E-03  +5.22640000E-04  -1.50924000E-03  +1.69250000E-04
   +4.02130000E-04  +8.66390000E-04  +3.50372000E-03  -9.85600000E-04  +4.74329180E-01
   -1.81901600E-02  +1.23590100E-02  +5.67797000E-03  +2.04828000E-03  +7.94674000E-03
   -7.78174900E-02  +1.49585000E-02  -1.33146000E-02  +1.28215000E-03  +4.02681000E-03
   +1.85890000E-03  -8.37200000E-04  -2.95250000E-04  +7.49180000E-04  -1.71757000E-03
   +7.14700000E-04  +4.55994000E-03  -2.06022000E-03  -4.75791000E-03  +9.95120000E-03
   +4.78575330E-01  -5.69130000E-04  -7.64850000E-04  +6.50140000E-04  -4.74099000E-03
   +1.85588200E-02  +2.29533100E-02  +6.74800000E-05  +2.35526000E-03  -7.54520000E-04
   -1.43491000E-03  -7.80700000E-05  -5.41060000E-04  +7.29560000E-04  -5.38430000E-04
   +3.57910000E-04  -4.70100000E-04  -7.72450000E-04  +3.92700000E-05  -7.58951500E-02
   -5.93000000E-06  +7.61710000E-04  +5.84154940E-01  +4.92640000E-04  +3.80330000E-04
   -1.11632000E-03  +7.95595000E-03  -1.78429100E-02  -1.78867700E-02  -1.42299000E-03
   -1.43430000E-03  +9.62230000E-04  +6.86970000E-04  +1.82600000E-05  +4.18030000E-04
   -3.48090000E-04  +3.06470000E-04  -2.50390000E-04  +2.94500000E-04  +7.86650000E-04
   -9.14000000E-05  -3.11911000E-03  -1.11036820E-01  -4.95707200E-02  -2.19361000E-03
   +5.39083210E-01  -2.48338000E-03  +1.07845000E-03  +2.19007000E-03  +6.55836000E-03
   -5.70908000E-03  -1.20373000E-03  -7.43140000E-04  +1.83500000E-05  -1.50940000E-04
   -3.23640000E-04  +4.03590000E-04  -2.18000000E-04  +1.40590000E-04  -4.12400000E-04
   +4.71210000E-04  +6.29640000E-04  -1.51380000E-04  -3.59980000E-04  -3.57230000E-03
   -4.52429800E-02  -1.40243670E-01  -6.11444000E-03  -6.69092000E-02  +5.19518070E-01
   +4.98474000E-03  -1.58138000E-03  +4.14305000E-03  -2.81851000E-03  +2.29432000E-03
   -1.70278000E-03  +1.41763000E-03  +6.67870000E-04  +1.68068000E-03  -1.18179700E-02
   +1.97590800E-02  -7.01860000E-03  -2.41815780E-01  +9.84997200E-02  +4.97291300E-02
   -3.93176800E-02  +2.78299900E-02  +8.09192000E-03  +1.53644000E-03  -1.03695000E-03
   +6.67070000E-04  -1.15710000E-03  +4.99670000E-04  -5.69730000E-04  +3.26597870E-01
   +3.47602000E-03  -1.44700000E-05  +5.98438000E-03  +1.79486000E-03  +2.99180000E-04
   -3.89540000E-03  -2.70422000E-03  +1.05155000E-03  +6.53153000E-03  +4.06082200E-02
   -2.51349100E-02  +6.62099000E-03  +1.28198180E-01  -1.36769320E-01  +3.76894000E-03
   +7.01385000E-03  +5.66623000E-03  -5.77700000E-04  -1.06789000E-03  +6.53210000E-04
   -7.37480000E-04  +8.49490000E-04  -3.95500000E-04  +4.19710000E-04  -1.80192080E-01
   +3.79012150E-01  -2.31385000E-03  +1.06132400E-02  -3.87647000E-03  -1.15157000E-03
   -4.30010000E-03  +4.79944000E-03  +5.90671000E-03  +3.55976000E-03  -5.03778000E-03
   -3.26327800E-02  +2.44762100E-02  +6.52539000E-03  +1.26042500E-02  +2.97430700E-02
   -9.20305500E-02  +3.43533200E-02  -1.87944300E-02  +3.47118000E-03  -2.09910000E-04
   -1.32620000E-04  +1.54380000E-04  -3.10400000E-05  +1.42700000E-05  -7.42600000E-05
   -3.68643100E-02  -2.82239450E-01  +4.11446630E-01  +7.01160000E-04  -1.08900000E-04
   +1.07810000E-04  -3.52931500E-02  -1.00635400E-02  +3.29257000E-03  -1.04164000E-03
   +8.03600000E-05  -2.60565000E-03  -1.21120000E-04  +7.80130000E-04  +6.38240000E-04
   +3.05000000E-06  -3.25110000E-04  +2.14780000E-04  +3.73150000E-04  -2.69750000E-04
   +8.55260000E-04  -1.41363520E-01  -4.57106600E-02  +1.94881000E-03  -7.34800000E-04
   -5.19754000E-03  -4.40950000E-03  -1.49820000E-04  +6.32200000E-05  -6.34600000E-05
   +5.71371680E-01  +2.31629000E-03  +3.01490000E-04  -1.75827000E-03  +9.57002000E-03
   +1.23074800E-02  -6.01340000E-04  +1.13742000E-03  -1.30837000E-03  +9.20400000E-04
   +8.39770000E-04  -1.24663000E-03  -3.46380000E-04  -5.22330000E-04  +1.07812000E-03
   -5.11630000E-04  -4.66230000E-04  -2.06390000E-04  +4.04000000E-06  -4.26025300E-02
   -1.10062680E-01  -1.18814800E-02  -1.76096000E-02  -1.50892500E-02  -2.28442000E-03
   +1.09206000E-03  -8.34760000E-04  +8.82800000E-05  +9.71394800E-02  +4.63709170E-01
   -4.67980000E-04  +3.97520000E-04  -5.95570000E-04  +2.50720000E-03  +8.88890000E-04
   -1.75520000E-04  +6.96600000E-05  -2.20840000E-04  +2.30250000E-04  +2.66270000E-04
   -2.94450000E-04  -8.85400000E-05  +4.57500000E-05  +2.12210000E-04  -2.62910000E-04
   -7.90000000E-05  +3.50000000E-06  +2.40790000E-04  +4.42977000E-03  -9.91255000E-03
   -8.06708800E-02  -2.32801700E-02  -1.71000700E-02  -5.00060000E-04  -1.62400000E-05
   -3.40300000E-05  +4.53300000E-05  -1.42846690E-01  +2.00169370E-01  +4.56545840E-01
   -5.00950000E-04  -2.53790000E-04  -5.73330000E-04  -6.66310000E-04  -2.59732000E-03
   -1.63731000E-03  +3.54410000E-04  -5.33530000E-04  -6.22210000E-04  -1.24350000E-04
   +3.68700000E-04  +6.02100000E-05  +4.64200000E-05  -5.48000000E-05  +9.12400000E-05
   +2.26600000E-04  -1.50100000E-05  +7.58200000E-05  -1.70240000E-03  -2.13818200E-02
   -1.90672300E-02  -4.94380000E-03  -3.01357000E-03  +1.05511000E-03  -1.84640000E-04
   +1.22600000E-04  +9.74000000E-06  -1.20727500E-01  +4.45382000E-03  +3.34112700E-02
   +6.50320350E-01  -9.58920000E-04  -7.73820000E-04  +1.33275000E-03  +2.83840000E-04
   -3.42290000E-04  -1.08072000E-03  +1.17240000E-04  +1.88500000E-05  -1.90870000E-04
   +1.09060000E-04  -4.86100000E-05  -1.82370000E-04  +8.12200000E-05  -8.83800000E-05
   +1.65400000E-05  +4.89800000E-05  +1.04260000E-04  -1.17300000E-04  -7.85656000E-03
   -1.56585800E-02  -1.12842400E-02  -2.29297000E-03  -3.89430000E-04  +6.42580000E-04
   -1.06410000E-04  +1.01350000E-04  -3.28200000E-05  -4.42180700E-02  -2.10175930E-01
   -1.05576450E-01  +1.33646330E-01  +4.71141530E-01  -8.81750000E-04  -8.70500000E-04
   +7.35420000E-04  -3.25000000E-04  -9.17830000E-04  -3.95570000E-04  +2.75540000E-04
   -3.68300000E-05  -3.95360000E-04  +5.74400000E-05  -6.73200000E-05  -1.92350000E-04
   +2.44890000E-04  -7.88300000E-05  +1.12450000E-04  +1.46650000E-04  -1.59930000E-04
   -7.66500000E-05  -6.05569000E-03  -2.17200000E-03  +3.16996000E-03  +9.64190000E-04
   +3.23440000E-04  +4.45500000E-05  -1.60750000E-04  +7.64900000E-05  -4.33000000E-05
   -1.21208300E-02  -1.32538120E-01  -1.87883570E-01  -1.68703890E-01  +2.27376250E-01
   +4.52716120E-01  +2.20240000E-04  -1.40100000E-04  +1.05620000E-04  -8.05000000E-06
   +6.19300000E-05  -2.49290000E-04  -1.24220000E-04  +2.25040000E-04  +2.60600000E-05
   +5.89600000E-05  -1.15740000E-04  +1.85500000E-05  +2.53600000E-04  -3.56900000E-05
   -1.73940000E-04  -3.17340000E-04  +1.47600000E-04  +1.49010000E-04  +3.80353000E-03
   +4.14660000E-04  +1.68906000E-03  +3.78770000E-04  +3.24340000E-04  +4.47490000E-04
   -2.19570000E-04  +1.47210000E-04  +1.68800000E-05  +2.87965000E-02  -5.22973200E-02
   -6.14326300E-02  -2.66588300E-01  -1.00069550E-01  +2.80981600E-02  +6.06068760E-01
   -4.15400000E-05  +1.64060000E-04  -2.49100000E-05  +6.20360000E-04  +2.08000000E-05
   +3.42310000E-04  -2.04260000E-04  +2.54120000E-04  +2.85460000E-04  -3.10500000E-05
   -5.66800000E-05  +6.45600000E-05  -1.88040000E-04  +7.90100000E-05  -1.68300000E-05
   -3.99200000E-05  +7.29000000E-05  -4.70000000E-05  +7.84770000E-04  +5.46780000E-04
   -5.77842000E-03  -1.17717000E-03  -5.73800000E-04  +2.29890000E-04  +1.76870000E-04
   -9.34600000E-05  +7.86000000E-06  -1.44487900E-02  -2.93511300E-02  -2.61124800E-02
   -1.47708540E-01  -1.78201010E-01  -2.53230400E-02  +1.50371550E-01  +5.03263710E-01
   -1.14840000E-04  +2.53150000E-04  -3.96800000E-04  +7.47010000E-04  +1.79190000E-04
   +1.46030000E-04  -1.71900000E-05  -5.64800000E-05  +1.12860000E-04  -3.48800000E-05
   +6.89000000E-06  +5.19600000E-05  -2.19590000E-04  +1.21150000E-04  +1.55200000E-05
   +1.46640000E-04  -7.07300000E-05  -3.52600000E-05  +1.81500000E-03  -4.51201000E-03
   -7.17660000E-04  -7.17500000E-04  -5.80190000E-04  +1.04880000E-04  +2.10180000E-04
   -1.65490000E-04  +6.66000000E-06  -2.56996900E-02  -4.25530000E-03  +1.91142300E-02
   -1.68652400E-02  -5.31193300E-02  -9.90039800E-02  -1.40684200E-01  +2.65266210E-01
   +4.54915270E-01  -7.26780000E-04  -1.24860000E-04  +3.46860000E-04  +4.37600000E-05
   +4.18100000E-04  -1.09590000E-04  -2.25580000E-04  -6.99300000E-05  +2.04480000E-04
   +2.92450000E-04  -2.74340000E-04  +7.41100000E-05  -7.02370000E-04  +4.92560000E-04
   +5.15000000E-06  +3.83150000E-04  -7.38900000E-05  -1.87460000E-04  -2.40034000E-03
   -2.50720000E-04  +4.18600000E-05  +3.90770000E-04  -2.03750000E-04  -2.79460000E-04
   +7.91400000E-04  -5.49180000E-04  -5.06000000E-06  -1.34321900E-02  +2.40216800E-02
   +2.70684200E-02  -5.21639300E-02  -3.32117100E-02  +6.58180000E-04  -2.27581040E-01
   +4.28575700E-02  +1.33142640E-01  +6.18076760E-01  -1.25550000E-04  +8.31000000E-05
   -8.58500000E-05  +3.39750000E-04  +7.30010000E-04  -1.82660000E-04  -4.18380000E-04
   +2.03890000E-04  +4.02800000E-04  +3.39390000E-04  -4.67290000E-04  +1.61400000E-04
   -4.99310000E-04  +5.53770000E-04  -2.49080000E-04  -3.64000000E-06  +1.62800000E-05
   -2.71600000E-05  +1.72050000E-04  -7.82890000E-04  -9.80050000E-04  +2.59620000E-04
   +8.89100000E-05  +1.21300000E-05  +6.97830000E-04  -5.20730000E-04  +2.36200000E-05
   +2.30206900E-02  -2.64854100E-02  -3.25132900E-02  +7.76846000E-03  +4.22434600E-02
   +3.28767700E-02  -1.53756800E-02  -1.17962640E-01  -3.68450100E-02  +1.34993140E-01
   +5.06123390E-01  +7.78600000E-05  +1.06080000E-04  +1.58900000E-05  +3.01070000E-04
   +4.07570000E-04  -2.02810000E-04  -3.68690000E-04  +2.00320000E-04  +2.82590000E-04
   +1.87360000E-04  -2.84730000E-04  +9.38500000E-05  -9.29600000E-05  +2.41840000E-04
   -2.32290000E-04  -1.93820000E-04  +7.67300000E-05  +3.65600000E-05  +1.02162000E-03
   -2.72960000E-04  -1.40283000E-03  +9.46000000E-05  -2.30300000E-05  +2.91130000E-04
   +2.18840000E-04  -1.71570000E-04  +1.69100000E-05  +2.65823700E-02  -3.32962300E-02
   -5.21310700E-02  +3.91979200E-02  +5.64664100E-02  +3.28560400E-02  +7.88966200E-02
   -7.09809300E-02  -1.81403140E-01  -1.41426410E-01  +2.43664690E-01  +4.74104640E-01
   -3.80990000E-04  -2.79320000E-04  +7.34880000E-04  -4.32940000E-04  -4.50360000E-04
   +3.78100000E-05  +2.36050000E-04  -1.29850000E-04  -2.89000000E-04  -1.23640000E-04
   +2.45620000E-04  -1.16360000E-04  +1.19510000E-04  -2.50470000E-04  +2.22050000E-04
   +2.20500000E-04  -1.10060000E-04  -1.59830000E-04  +2.92940000E-04  +8.75600000E-04
   +4.04283000E-03  +2.07500000E-04  +5.50070000E-04  +1.39280000E-04  -2.29300000E-04
   +1.81670000E-04  -3.43000000E-05  -4.82764000E-02  +5.09066000E-03  +3.68981000E-02
   -1.86393000E-02  -2.69928300E-02  -1.63395600E-02  +3.47804500E-02  +2.40698200E-02
   +7.22984000E-03  -1.21058770E-01  +2.00374100E-02  +4.85387800E-02  +6.55907530E-01
   -3.14890000E-04  -3.67390000E-04  +5.69900000E-04  -7.77130000E-04  -6.72840000E-04
   +1.87720000E-04  +3.28620000E-04  -1.90700000E-04  -4.35280000E-04  -2.20220000E-04
   +3.79930000E-04  -1.48570000E-04  +2.09280000E-04  -3.95320000E-04  +2.75050000E-04
   +2.58830000E-04  -2.88100000E-05  -5.97400000E-05  -1.97200000E-04  +2.69454000E-03
   -2.83285000E-03  -4.75770000E-04  -5.54890000E-04  -8.64000000E-05  -4.04650000E-04
   +3.20670000E-04  -3.94200000E-05  -3.12930800E-02  +3.92135200E-02  +4.77203200E-02
   -2.58767400E-02  -4.58940200E-02  -2.53113400E-02  +5.80089200E-02  +1.19172700E-02
   -3.09035200E-02  -3.47445400E-02  -2.08736240E-01  -1.08653760E-01  +1.40945270E-01
   +4.72600220E-01  +3.21000000E-04  +1.08150000E-04  -4.82430000E-04  +8.76470000E-04
   +5.46450000E-04  -4.95100000E-05  +3.18550000E-04  -1.70370000E-04  +1.79300000E-05
   -9.44600000E-05  +6.75800000E-05  -9.08400000E-05  +8.91700000E-05  -1.05530000E-04
   +7.14000000E-05  -2.79300000E-05  -2.86800000E-05  +5.14000000E-06  +3.90174000E-03
   -4.20055000E-03  +1.31158000E-03  -6.48160000E-04  -6.33600000E-04  -1.91610000E-04
   -1.25110000E-04  +9.71100000E-05  +9.64000000E-06  +3.21846000E-03  +2.71243600E-02
   +3.00846100E-02  -1.51927500E-02  -2.43764600E-02  -1.72364000E-02  +3.90012000E-02
   -1.10271200E-02  -2.45879700E-02  -2.91162000E-03  -1.41198700E-01  -2.02006330E-01
   -1.77686690E-01  +2.40375570E-01  +4.60917940E-01  -4.06150000E-04  +2.20200000E-05
   +4.06170000E-04  -1.08165000E-03  -1.53360000E-03  +2.21760000E-04  -6.73070000E-04
   +4.64570000E-04  +2.29700000E-05  +2.19200000E-05  -7.30000000E-06  +2.23300000E-04
   +3.30900000E-05  +7.83800000E-05  -2.06910000E-04  -2.40110000E-04  +1.86560000E-04
   +1.28610000E-04  -1.98891900E-02  -2.54770000E-04  +1.23163000E-02  -1.65168000E-03
   -4.91320000E-04  +1.18206000E-03  +3.40000000E-07  +5.36000000E-06  +2.43400000E-05
   -2.41922950E-01  -1.84182500E-02  +8.57564400E-02  +3.55992800E-02  +6.34529500E-02
   +4.40410200E-02  -6.49493200E-02  -1.66423600E-02  +2.03044100E-02  +3.32546800E-02
   -5.52324400E-02  -7.03250400E-02  -2.66608340E-01  -9.68043700E-02  +3.02551100E-02
   +5.98687260E-01  -2.15220000E-04  -3.07000000E-06  +8.45590000E-04  -1.39115000E-03
   -1.90016000E-03  +3.24220000E-04  -4.29980000E-04  +3.46320000E-04  -1.65980000E-04
   -1.25860000E-04  +1.89580000E-04  +1.23340000E-04  +1.20360000E-04  -1.30720000E-04
   +6.99000000E-06  -8.22600000E-05  +6.27300000E-05  -8.39900000E-05  -1.40107800E-02
   +6.80368000E-03  +1.12889800E-02  -1.13873000E-03  -5.50230000E-04  +7.11600000E-04
   -1.74160000E-04  +1.46420000E-04  -6.41000000E-06  +2.95723400E-02  -1.11049140E-01
   -5.83500300E-02  +2.63706600E-02  +1.04266300E-02  -1.33471400E-02  -1.47356500E-02
   -7.27164000E-03  +5.26000000E-03  -1.41855000E-02  -3.27336200E-02  -2.44811800E-02
   -1.44582040E-01  -1.76133840E-01  -2.38038500E-02  +1.39700090E-01  +5.03995610E-01
   +1.62020000E-04  +9.28800000E-05  -3.48770000E-04  -2.35981000E-03  -1.22425000E-03
   +3.58980000E-04  +2.50570000E-04  -7.77300000E-05  -3.75170000E-04  -2.53460000E-04
   +3.67740000E-04  +5.60600000E-05  +1.49620000E-04  -2.86780000E-04  +1.82350000E-04
   +1.26340000E-04  +1.64700000E-05  +1.35670000E-04  +6.68290000E-04  +3.54598000E-03
   +4.98773000E-03  -8.65720000E-04  +7.61530000E-04  +1.46390000E-04  -3.37930000E-04
   +2.44210000E-04  -1.43000000E-05  +1.31200250E-01  -3.08200700E-02  -1.73156750E-01
   +9.72259000E-03  -3.53345800E-02  -3.03240800E-02  +2.18762200E-02  +6.63275000E-03
   -1.01300700E-02  -3.15582700E-02  -3.38690000E-04  +2.04930000E-02  -1.51418300E-02
   -5.26767600E-02  -1.01184970E-01  -1.36057210E-01  +2.61188320E-01  +4.72891130E-01
   +4.77630000E-04  -1.69560000E-04  +1.40060000E-04  -2.76110000E-04  -8.76060000E-04
   +3.43300000E-05  +4.57060000E-04  -7.65200000E-05  -4.95400000E-04  -4.07800000E-04
   +5.09530000E-04  -1.80810000E-04  +8.61080000E-04  -7.28290000E-04  +1.59270000E-04
   -2.67290000E-04  +9.79600000E-05  +1.56880000E-04  +1.62861000E-03  +5.62130000E-04
   +7.35050000E-04  -5.93240000E-04  +4.37500000E-05  +2.93300000E-04  -1.06689000E-03
   +7.65930000E-04  -1.65300000E-05  -1.46985000E-03  -2.81481000E-03  -2.84304000E-03
   +2.46502000E-03  +3.46960000E-03  +6.16271000E-03  -4.39910800E-02  -3.29529500E-02
   +6.06300000E-04  -2.40050810E-01  -9.12092000E-02  +3.09260400E-02  -3.51894000E-03
   -1.47062400E-02  -7.35896000E-03  -6.95750000E-04  +9.61010000E-04  +4.06005000E-03
   +3.32619060E-01  +2.56690000E-04  -1.64480000E-04  +1.45530000E-04  -2.39190000E-04
   -7.24430000E-04  -1.82000000E-05  +3.64220000E-04  -9.17700000E-05  -4.05410000E-04
   -3.23300000E-04  +4.34140000E-04  -1.48290000E-04  +6.20960000E-04  -5.72550000E-04
   +1.67320000E-04  -1.49540000E-04  +9.01300000E-05  +1.18560000E-04  +1.15911000E-03
   +1.55910000E-04  +1.21949000E-03  -4.19970000E-04  -4.81000000E-06  +1.88930000E-04
   -8.06610000E-04  +6.03580000E-04  -1.37600000E-05  -3.08788000E-03  +7.61580000E-04
   +3.44204000E-03  -2.36850000E-03  -5.03200000E-04  -5.93459000E-03  -5.15357000E-03
   +4.85171000E-03  -1.27709000E-03  -1.26164290E-01  -1.43502760E-01  -1.98346200E-02
   -4.17142100E-02  -2.92589800E-02  -9.86072000E-03  +5.46740000E-03  +2.54414000E-03
   -5.84935000E-03  +1.23616380E-01  +4.21896380E-01  +1.52190000E-04  +6.89700000E-05
   -1.62670000E-04  -4.26300000E-05  -1.48700000E-04  +1.47780000E-04  +6.89900000E-05
   +2.23000000E-06  -3.16800000E-05  -7.80700000E-05  +7.33100000E-05  +6.37000000E-06
   +7.09700000E-05  -7.64800000E-05  +1.31000000E-05  -2.93700000E-05  +8.06000000E-06
   +2.13100000E-05  -1.55890000E-04  +4.23390000E-04  +7.13000000E-05  -5.19100000E-05
   -3.03900000E-05  -1.63900000E-05  -9.56400000E-05  +6.90900000E-05  +7.45000000E-06
   -2.87063000E-03  +3.45823000E-03  +3.55098000E-03  +7.42440000E-04  -9.20981000E-03
   -1.80054000E-03  +2.63173500E-02  +1.50116000E-02  +7.98326000E-03  -2.68155000E-03
   -4.11570200E-02  -8.06668600E-02  -3.27660600E-02  -2.57849600E-02  +2.59199000E-03
   +8.46645000E-03  -3.09198000E-03  -2.80300000E-03  -6.52665500E-02  +3.04375690E-01
   +3.57409280E-01  -5.11950000E-03  +2.06952000E-03  +1.79535000E-03  -3.59662000E-03
   +2.04169500E-02  -2.55279300E-02  -5.00650000E-04  +1.81879000E-03  -1.43559000E-03
   -1.89610000E-04  +5.57920000E-04  -4.28800000E-04  +3.15560000E-04  -3.72660000E-04
   +5.55100000E-05  +2.46980000E-04  +9.71140000E-04  -1.12868000E-03  -7.46288600E-02
   -9.32970000E-04  +1.73792000E-03  +7.20420000E-04  +1.33130000E-04  -4.54700000E-04
   -5.20520000E-04  +3.56130000E-04  +1.65100000E-05  -3.88528000E-03  -1.84429600E-02
   +2.30687100E-02  -5.34380000E-04  -8.52470000E-04  +9.43820000E-04  -2.36030000E-04
   +7.65400000E-04  +4.40200000E-05  +5.76220000E-04  +7.27100000E-04  +4.37460000E-04
   -1.18857000E-03  +1.83180000E-04  -1.32586000E-03  -5.23930000E-04  -1.79546000E-03
   -6.90220000E-04  -1.22296000E-03  -9.89000000E-04  -1.65220000E-04  +5.86754220E-01
   +2.68777000E-03  -5.37090000E-04  -1.08582000E-03  +6.28298000E-03  -1.70458300E-02
   +2.00227800E-02  -8.57000000E-06  +9.86900000E-05  +3.80690000E-04  -3.78960000E-04
   -1.45360000E-04  +5.32060000E-04  +7.93000000E-06  +2.00700000E-05  -7.32900000E-05
   -1.65190000E-04  -5.15780000E-04  +7.42480000E-04  +4.28872000E-03  -1.07836490E-01
   +4.75957300E-02  +1.15400000E-04  +1.09580200E-02  -1.54006300E-02  +8.03000000E-06
   -3.14400000E-05  +1.37700000E-05  -8.88517000E-03  -1.77116900E-02  +1.76953400E-02
   -6.20420000E-04  -3.61500000E-04  +1.00110000E-03  +6.11800000E-05  +7.58270000E-04
   -1.05270000E-04  +9.30100000E-05  +5.44970000E-04  +5.14780000E-04  -6.47080000E-04
   -1.74770000E-04  -9.01030000E-04  +1.36448000E-03  -1.09109000E-03  -5.91020000E-04
   -4.67200000E-04  -4.42120000E-04  -1.10740000E-04  -1.01455000E-03  +5.40544430E-01
   +1.20015000E-03  -5.98420000E-04  -3.12500000E-04  -3.61755000E-03  +3.71542000E-03
   -2.42660000E-03  +7.10120000E-04  -8.20760000E-04  +1.08730000E-03  +4.48860000E-04
   -1.32750000E-04  -1.98310000E-04  -2.57130000E-04  -9.70000000E-07  +1.49980000E-04
   +1.91890000E-04  -9.45700000E-05  +1.00000000E-04  -4.32935000E-03  +4.46174700E-02
   -1.39962220E-01  -1.22830000E-04  +1.35930800E-02  -3.71526000E-02  +3.11480000E-04
   -1.93510000E-04  -3.03300000E-05  +8.04441000E-03  +7.06264000E-03  -1.41755000E-03
   -1.58643000E-03  -1.23811000E-03  -4.32230000E-04  +1.39220000E-04  -1.41800000E-05
   -1.39630000E-04  +2.31990000E-04  +1.96390000E-04  +2.57640000E-04  -2.62700000E-05
   -1.74910000E-04  -1.64500000E-04  -1.06525000E-03  -1.79300000E-04  -9.98900000E-05
   -5.82620000E-04  -4.52880000E-04  -1.21260000E-04  -2.87467000E-03  +6.24937400E-02
   +5.07585140E-01  -1.87264660E-01  +2.21641300E-02  +1.01516670E-01  +7.46137000E-03
   -4.47969000E-03  +5.60531000E-03  -5.42720000E-04  +3.68887000E-03  -7.44030000E-04
   -1.85717000E-03  -3.38651000E-03  +4.61741000E-03  +3.26472000E-03  +7.66049000E-03
   -5.53645000E-03  -3.70106100E-02  -1.83942000E-03  +4.39894000E-02  -2.65759000E-03
   -1.42300000E-04  -1.28690000E-03  +1.26077000E-03  -1.23440000E-04  +1.21632000E-03
   -2.42814000E-03  -5.68100000E-05  +2.05141000E-03  -2.03303000E-03  -5.20700000E-04
   -2.15241000E-03  -2.26050000E-04  +1.60033000E-03  +5.54590000E-04  -1.38320000E-04
   +1.94200000E-05  +7.21600000E-05  +7.69840000E-04  +1.03000000E-05  -9.06700000E-05
   +7.11330000E-04  +5.66810000E-04  -2.38770000E-04  -1.46740000E-04  +5.83690000E-04
   -1.10147000E-03  -3.82470000E-04  -1.83760000E-04  -1.51010000E-04  +4.35410000E-04
   -1.22010000E-04  -1.91550000E-04  +2.95269470E-01  -9.41959000E-03  -8.57809500E-02
   +5.49275000E-02  -2.29777700E-02  -2.21329000E-03  +3.33979900E-02  +6.64753000E-03
   -2.79109000E-03  +3.02104000E-03  -3.30432000E-03  +2.79570000E-03  -2.63182000E-03
   +2.53663000E-03  -1.44920000E-03  +8.68424000E-03  +1.84702200E-02  +1.06883100E-02
   -1.59247300E-02  -2.62455000E-03  -3.00770000E-04  -2.35393000E-03  +1.75111000E-03
   -2.01764000E-03  -1.42199000E-03  +7.97140000E-04  +5.80370000E-04  -1.56848000E-03
   -2.65970000E-04  -1.02810000E-04  +2.58390000E-04  -3.62240000E-04  -4.60100000E-05
   +1.42190000E-04  +4.27330000E-04  +3.38840000E-04  -2.43860000E-04  -8.42900000E-05
   +1.16930000E-04  +1.90790000E-04  +1.65700000E-05  -6.49000000E-06  -6.20300000E-05
   +4.55090000E-04  -8.15000000E-05  +5.78000000E-05  +1.96580000E-04  +1.86950000E-04
   -3.93000000E-05  -8.44400000E-05  +3.06670000E-04  -8.76800000E-05  -1.33715970E-01
   +4.04320950E-01  +1.33895170E-01  +2.60806700E-02  -1.94168130E-01  +2.80995600E-02
   +1.75040500E-02  -3.78787300E-02  -4.29007000E-03  +5.05954000E-03  +1.30127000E-03
   +4.49620000E-03  -2.32385000E-03  -2.58059000E-03  +4.30410000E-04  +4.45096000E-03
   +1.73706000E-03  +1.91755700E-02  +9.45590000E-04  -8.01968000E-03  +2.56137000E-03
   -4.47361000E-03  +4.86260000E-04  -5.03770000E-04  +9.68940000E-04  -1.27025000E-03
   +8.82110000E-04  -7.30630000E-04  +6.97000000E-05  -1.44433000E-03  +1.76153000E-03
   -7.37650000E-04  +5.10000000E-07  +6.72400000E-05  -5.37450000E-04  -1.50640000E-04
   +9.11100000E-05  +4.72360000E-04  +1.45700000E-04  +8.00200000E-05  -1.02860000E-04
   -3.38630000E-04  -4.56090000E-04  +3.41560000E-04  -1.32300000E-04  -3.64300000E-04
   -4.83140000E-04  -4.72690000E-04  -3.50340000E-04  +8.86400000E-05  -2.40240000E-04
   +2.27400000E-05  +5.02670000E-04  -8.93527100E-02  -2.90006670E-01  +4.23968990E-01
   -8.85800000E-05  +2.60000000E-06  +3.40200000E-05  +1.20100000E-05  +3.75300000E-05
   -1.68900000E-05  -5.33400000E-05  +1.70600000E-05  +5.07600000E-05  +3.76200000E-05
   -3.61700000E-05  +2.26100000E-05  -1.29080000E-04  +7.73400000E-05  +2.98000000E-06
   +5.86500000E-05  +1.16200000E-05  -2.10300000E-05  -1.82010000E-04  +3.87700000E-05
   +1.00880000E-04  +7.37500000E-05  +2.06300000E-05  -2.22900000E-05  +1.35070000E-04
   -8.05400000E-05  +2.36000000E-06  -1.47110000E-04  +4.62260000E-04  +5.72320000E-04
   -6.44440000E-04  -2.14730000E-04  -2.03160000E-04  +1.57665000E-03  -9.52890000E-04
   -2.29598000E-03  -7.73960000E-04  -3.11888200E-02  -3.10102900E-02  -5.34771000E-03
   -3.51672000E-03  +1.04653000E-03  +1.50958000E-03  -8.54550000E-04  -6.90440000E-04
   -4.53268400E-02  +4.76879400E-02  +7.09637000E-02  +3.25500000E-05  -1.32300000E-05
   -1.39500000E-05  +9.49700000E-05  +3.88300000E-05  -3.04000000E-06  +5.04032800E-02
   -4.69200000E-05  +5.13900000E-05  -5.26900000E-05  +4.51500000E-05  +1.03870000E-04
   +1.69000000E-05  -6.84200000E-05  +1.59100000E-05  +7.52900000E-05  +5.48700000E-05
   -7.99700000E-05  +3.59700000E-05  -1.29770000E-04  +1.19480000E-04  -3.56600000E-05
   +3.15500000E-05  -2.36600000E-05  -2.41000000E-05  -2.03740000E-04  -5.80100000E-05
   -3.84000000E-05  +7.48300000E-05  -8.56000000E-06  -2.15200000E-05  +1.61480000E-04
   -1.28140000E-04  +2.57000000E-06  -4.33500000E-05  +5.11170000E-04  +4.35900000E-04
   +7.99400000E-05  -9.94880000E-04  -3.26120000E-04  +3.62983000E-03  +3.26210000E-03
   +1.73889000E-03  +1.70035000E-03  -2.36335400E-02  -2.10200400E-02  -4.69645000E-03
   +2.71000000E-05  +8.57130000E-04  +5.02360000E-04  +1.21700000E-04  -1.76430000E-03
   +1.22347400E-02  -2.55827910E-01  -2.49495400E-01  +9.47400000E-05  +3.21700000E-05
   +4.26600000E-05  +2.58600000E-05  -4.56900000E-05  +7.19500000E-05  -1.26073500E-02
   +2.76406400E-01  -9.81200000E-05  -3.70800000E-05  +1.05280000E-04  +9.04000000E-06
   +6.08900000E-05  -3.29100000E-05  -3.75900000E-05  +7.25000000E-06  +1.85100000E-05
   +2.92100000E-05  -2.40800000E-05  -8.37000000E-06  -5.13500000E-05  +2.73500000E-05
   +1.44900000E-05  +3.57600000E-05  -4.39000000E-06  -1.94300000E-05  -1.16200000E-04
   -2.46100000E-05  -1.53100000E-04  +2.61600000E-05  -2.36000000E-06  -1.51400000E-05
   +5.33900000E-05  -3.23100000E-05  -7.00000000E-06  +8.44100000E-05  +1.22890000E-04
   +2.22400000E-04  +5.67400000E-05  -2.19200000E-04  -8.81140000E-04  +2.05426000E-03
   +4.46846000E-03  +2.13197000E-03  +6.84890000E-04  -1.04649000E-03  -4.02699000E-03
   -1.44000000E-05  +1.71700000E-04  +2.17407000E-03  +6.29110000E-04  -9.35820000E-04
   +4.79660000E-04  +3.67658000E-02  -2.71063110E-01  -2.85617030E-01  +1.17080000E-04
   +6.36000000E-05  +5.70500000E-05  +1.12800000E-04  +4.51400000E-05  -5.39600000E-05
   -4.00199400E-02  +2.68740270E-01  +2.86009670E-01  -2.30000000E-07  -5.56900000E-05
   +3.84900000E-05  +8.17100000E-05  -2.65800000E-05  +1.53000000E-05  +5.32800000E-05
   -7.13000000E-06  -4.65200000E-05  -4.33900000E-05  +6.97600000E-05  -1.96000000E-06
   +3.53000000E-05  -5.48700000E-05  +2.39800000E-05  -4.99000000E-06  +4.49300000E-05
   +9.67000000E-06  +6.14650000E-04  -7.34250000E-04  -8.68160000E-04  -3.70840000E-04
   -1.31090000E-04  +1.00640000E-04  -6.64900000E-05  +6.90000000E-05  +5.94000000E-06
   -2.65937000E-03  -4.52254000E-03  +1.78279000E-03  +4.07557000E-03  -1.91062900E-02
   -1.88211400E-02  -5.62634000E-02  -9.08906000E-03  +5.12752000E-03  +4.38579000E-03
   +1.76213400E-02  +1.61869400E-02  -2.89156000E-03  -4.48780000E-04  +4.47605000E-03
   -1.62754000E-03  -3.25910000E-04  +1.28920000E-04  +2.09686000E-03  +2.44081000E-03
   -1.20875000E-03  +3.30000000E-06  +6.65400000E-05  -9.88600000E-05  +6.58000000E-06
   +6.04700000E-05  -1.84600000E-05  -8.82350000E-04  -1.06685000E-03  -1.84290000E-04
   +5.32595100E-02  +9.38500000E-05  +1.29700000E-05  -2.83400000E-05  +1.38120000E-04
   -1.06560000E-04  +3.45000000E-05  +4.11800000E-05  +4.69000000E-06  -3.60900000E-05
   -4.24900000E-05  +4.60300000E-05  +2.63000000E-06  +8.71300000E-05  -5.56200000E-05
   -9.64000000E-06  -4.29200000E-05  +1.69700000E-05  +2.49900000E-05  +3.35280000E-04
   -1.80290000E-04  -8.29390000E-04  -3.11910000E-04  -1.78920000E-04  +1.15010000E-04
   -1.03850000E-04  +7.28000000E-05  +6.04000000E-06  -4.85307000E-03  +2.37133000E-03
   -1.77485000E-03  +1.99504000E-03  -1.02170100E-02  -1.29147900E-02  -9.20943000E-03
   -1.97342860E-01  -1.47897000E-01  -4.89873000E-03  -2.55421000E-03  -3.25882000E-03
   +6.04700000E-05  +3.23580000E-03  -2.09002000E-03  -3.17600000E-05  -5.73900000E-05
   +7.94880000E-04  +1.93877000E-03  +7.06580000E-04  +3.18497000E-03  -6.32100000E-05
   -8.80000000E-06  -3.25300000E-05  -6.60000000E-05  -2.06800000E-05  -3.13000000E-06
   +1.03015000E-03  +1.57600000E-04  -9.82160000E-04  +1.26311900E-02  +2.05977020E-01
   -4.99100000E-05  -1.04080000E-04  +1.04010000E-04  -9.81200000E-05  -1.33000000E-05
   -1.42600000E-05  +6.06000000E-05  -2.17100000E-05  -7.31100000E-05  -3.55500000E-05
   +6.45800000E-05  -3.23400000E-05  +4.39000000E-05  -7.34800000E-05  +5.57700000E-05
   +1.32700000E-05  +3.21900000E-05  +3.89000000E-06  +4.07080000E-04  -1.69190000E-04
   +7.66500000E-05  -7.94500000E-05  +3.56400000E-05  +2.65500000E-05  -7.75400000E-05
   +7.46600000E-05  -4.68000000E-06  +1.23179000E-03  -2.31704000E-03  +4.57437000E-03
   +8.90080000E-04  -4.08420000E-04  +1.42705000E-03  +4.98246000E-03  -1.47934620E-01
   -1.73570040E-01  -4.75084000E-03  -1.63953300E-02  -8.51154000E-03  +4.92725000E-03
   -1.81836000E-03  +8.51320000E-04  +3.51900000E-04  +9.59950000E-04  -2.17250000E-04
   -1.75081000E-03  +2.89092000E-03  -2.07050000E-04  -4.13600000E-05  +7.05000000E-06
   -6.46600000E-05  +5.71900000E-05  +9.34200000E-05  -5.50700000E-05  +1.78368000E-03
   +2.09560000E-04  -2.52650000E-04  -5.89833000E-03  +1.63217310E-01  +1.78455470E-01
   -2.31330000E-04  -1.71720000E-04  -4.16980000E-04  -7.37530000E-04  -9.11090000E-04
   -7.51640000E-04  -2.85110000E-04  -1.83040000E-04  -1.60780000E-04  -5.32400000E-05
   +3.98900000E-05  +8.91100000E-05  -1.83790000E-04  +1.47540000E-04  +6.59500000E-05
   +1.89230000E-04  -4.13700000E-05  -7.55000000E-06  -9.15770000E-04  +3.40610000E-04
   -9.33370000E-04  -7.90000000E-06  +1.42370000E-04  -1.04720000E-04  +1.68840000E-04
   -1.36680000E-04  -1.29400000E-05  +4.18757000E-03  -3.09110000E-04  -3.26830000E-04
   -2.23014660E-01  +3.31390600E-02  +1.36389060E-01  -1.52664600E-02  +5.78148000E-03
   +1.64491300E-02  -7.11710000E-04  -4.99646000E-03  +2.27770000E-04  -5.25400000E-05
   -2.16030000E-04  -8.78160000E-04  +2.09294000E-03  -1.63001000E-03  +8.84520000E-04
   -1.45605000E-03  -2.50500000E-05  +7.63570000E-04  -2.57800000E-05  -6.90100000E-05
   +1.61770000E-04  -4.61200000E-05  +3.56800000E-05  +2.65510000E-04  +1.02610000E-04
   +2.13590000E-04  +1.36060000E-04  +1.25050000E-04  +1.10583000E-03  -1.52052000E-03
   +2.35820400E-01  +1.46800000E-05  +5.22050000E-04  -6.18590000E-04  -2.24840000E-04
   -1.62640000E-04  -7.52800000E-05  -3.31460000E-04  -3.75100000E-05  +4.13600000E-05
   -5.18900000E-05  -6.05800000E-05  +6.13600000E-05  -1.35870000E-04  +8.81900000E-05
   +4.40500000E-05  +1.54530000E-04  -2.02420000E-04  -2.38000000E-05  +1.44677000E-03
   -8.80940000E-04  +1.33452000E-03  +1.13860000E-04  +3.79700000E-05  +9.96300000E-05
   +1.92030000E-04  -1.74350000E-04  +3.46000000E-06  +1.91438800E-02  +1.75052000E-03
   -1.35431600E-02  +3.33693500E-02  -6.12572400E-02  -3.94078900E-02  -1.54669300E-02
   +6.70006000E-03  +1.16507000E-02  -4.67420000E-03  +1.05831000E-03  -3.60823000E-03
   -3.04240000E-04  -1.09445000E-03  +2.70850000E-04  -2.16588000E-03  -9.77440000E-04
   -5.77821000E-03  -9.66690000E-04  +5.66300000E-05  +6.18220000E-04  -1.86940000E-04
   -5.58830000E-04  -4.59780000E-04  -2.96070000E-04  -2.30010000E-04  +3.37250000E-04
   +6.72800000E-05  +1.04630000E-04  +1.01050000E-04  +1.54172000E-03  -1.19064000E-03
   +2.13827000E-03  -3.23110800E-02  +5.71704200E-02  +1.11770000E-04  +3.89290000E-04
   -6.20990000E-04  -1.04170000E-04  -2.49520000E-04  +2.22620000E-04  -4.70630000E-04
   +2.52630000E-04  +3.71040000E-04  +2.44900000E-05  -1.29150000E-04  +7.60500000E-05
   -3.44220000E-04  +9.48700000E-05  +1.20500000E-05  +4.29800000E-05  +1.23440000E-04
   -7.18600000E-05  +1.96670000E-04  +1.90749000E-03  -1.51333000E-03  -2.50130000E-04
   +2.33900000E-05  -2.97600000E-05  +3.47830000E-04  -2.11780000E-04  -2.79000000E-06
   +1.74038500E-02  -2.61031000E-03  -7.84300000E-03  +1.35877500E-01  -3.87895400E-02
   -1.52701290E-01  -2.92775000E-03  -6.86980000E-04  +4.77703000E-03  +5.72080000E-04
   -3.27919000E-03  +4.56955000E-03  -1.07966000E-03  +1.28740000E-04  -4.82140000E-04
   +8.26050000E-04  -6.16528000E-03  +4.05850000E-04  +3.35200000E-05  +1.00640000E-04
   +9.00800000E-05  +6.94000000E-06  +4.73700000E-05  +1.64700000E-05  -2.30970000E-04
   +4.40000000E-07  +2.71080000E-04  -3.14100000E-05  -5.05000000E-06  -2.81000000E-05
   -1.23134000E-03  +2.39778000E-03  -1.55585000E-03  -1.49640850E-01  +4.61371400E-02
   +1.54918100E-01  -1.03070000E-04  -5.83000000E-06  +2.30950000E-04  -1.18770000E-04
   -1.02590000E-04  -2.56650000E-04  -7.01000000E-05  -3.01700000E-05  -4.29000000E-06
   +8.06400000E-05  -3.73900000E-05  +1.12200000E-05  -6.63900000E-05  +6.16400000E-05
   -4.24000000E-06  +5.58700000E-05  -1.85200000E-05  -4.57200000E-05  +3.70980000E-04
   +1.39064000E-03  -1.09143000E-03  -7.49220000E-04  -1.34970000E-04  +6.22180000E-04
   +8.86900000E-05  -7.04400000E-05  -9.57000000E-06  +6.42993000E-03  +1.79032300E-02
   +1.60793700E-02  -3.00583000E-03  -6.52570000E-04  +4.99197000E-03  -1.35536000E-03
   -1.75880000E-04  -4.50000000E-07  -2.31341000E-03  -4.43349000E-03  +1.94514000E-03
   +3.19274000E-03  -1.95831400E-02  -1.82090800E-02  -5.56530100E-02  -6.41254000E-03
   +3.76437000E-03  +1.20390000E-04  -9.72690000E-04  -9.57730000E-04  +2.51340000E-04
   -3.13000000E-05  -8.64600000E-05  +1.23340000E-04  -1.55170000E-04  -1.48070000E-04
   -3.22220000E-04  -2.12190000E-04  -1.10350000E-04  -4.71300000E-05  +1.98820000E-04
   -2.10300000E-04  +1.47720000E-04  +1.06608000E-03  +9.20610000E-04  +5.46241400E-02
   +2.44380000E-04  +1.81320000E-04  -4.66950000E-04  +3.46870000E-04  +2.78700000E-04
   -1.16480000E-04  +4.29200000E-05  -5.74300000E-05  +7.52500000E-05  +1.67000000E-05
   -4.65700000E-05  +2.48300000E-05  -2.52500000E-05  +5.64900000E-05  -5.51600000E-05
   -8.54100000E-05  +3.96000000E-06  +7.39500000E-05  +5.45610000E-04  -2.11834000E-03
   +1.31889000E-03  -1.50970000E-03  -1.21820000E-04  +1.89120000E-04  +5.16900000E-05
   -4.50300000E-05  +1.79500000E-05  -4.56420000E-04  +5.70590000E-04  -3.62826000E-03
   -5.69080000E-04  +3.41452000E-03  -2.81610000E-03  -2.76000000E-06  -7.29900000E-05
   +9.41930000E-04  -4.57334000E-03  +2.89617000E-03  -2.26114000E-03  +1.07075000E-03
   -9.36124000E-03  -1.32853900E-02  -5.88565000E-03  -1.98924460E-01  -1.49879150E-01
   -1.17630000E-04  -8.18000000E-04  -7.76780000E-04  -4.21730000E-04  -2.02580000E-04
   +2.73600000E-05  -3.67260000E-04  -4.54000000E-05  +3.79500000E-04  -1.32900000E-04
   -1.97900000E-04  +7.01700000E-05  +1.71830000E-04  -3.48460000E-04  +2.66870000E-04
   -1.06920000E-04  -1.46650000E-04  -2.35500000E-05  +1.20760000E-02  +2.07531700E-01
   -1.04070000E-04  -8.54900000E-05  +1.26300000E-04  -2.25690000E-04  -6.68300000E-05
   +1.22770000E-04  -3.36000000E-05  +4.87900000E-05  -2.17200000E-05  -1.15300000E-05
   +2.84000000E-05  -5.16000000E-06  +8.49000000E-06  -2.72600000E-05  +8.13000000E-06
   +7.79000000E-06  +8.43000000E-06  -8.05000000E-06  -2.05785000E-03  +6.22570000E-04
   -1.94172000E-03  -5.60310000E-04  -8.92480000E-04  +4.38180000E-04  -2.98500000E-05
   +3.54400000E-05  -2.60000000E-07  -1.74591000E-03  -1.42843300E-02  -8.19489000E-03
   +5.03522000E-03  -2.45113000E-03  +1.27107000E-03  +7.50000000E-05  +9.64600000E-04
   -1.83710000E-04  +1.88794000E-03  -2.30035000E-03  +4.64448000E-03  +1.61322000E-03
   -8.14910000E-04  +2.28568000E-03  +4.16588000E-03  -1.50342500E-01  -1.85929350E-01
   -1.42860000E-04  -2.28150000E-04  -7.80400000E-05  +6.66640000E-04  +1.67610000E-04
   +4.27400000E-05  +2.03360000E-04  +5.65200000E-05  -5.68200000E-05  -3.41400000E-05
   +1.17600000E-04  -5.73600000E-05  -2.43980000E-04  +2.36560000E-04  -3.52580000E-04
   -1.37640000E-04  -7.17370000E-04  -5.92220000E-04  -5.60003000E-03  +1.66678590E-01
   +1.89743920E-01  -4.80700000E-05  -5.81500000E-05  +1.86060000E-04  -7.24800000E-05
   -1.93480000E-04  +2.71500000E-05  -9.22000000E-06  +2.71900000E-05  -5.37300000E-05
   -3.17400000E-05  +5.07700000E-05  -1.13700000E-05  +5.87000000E-05  -6.19700000E-05
   +2.07800000E-05  -9.70000000E-07  +1.58100000E-05  -9.00000000E-06  -2.04190000E-04
   +5.59020000E-04  +7.75130000E-04  -2.80100000E-05  +9.16800000E-05  +4.99900000E-05
   -8.32500000E-05  +6.23200000E-05  -7.48000000E-06  -1.27758000E-03  -5.03737000E-03
   +3.76040000E-04  -5.61100000E-05  -2.83570000E-04  -8.84710000E-04  +1.89933000E-03
   -1.53012000E-03  +7.71240000E-04  +2.95765000E-03  -2.42997000E-03  -9.70900000E-04
   -2.27360080E-01  +2.93289900E-02  +1.41390470E-01  -1.42541900E-02  +6.09785000E-03
   +1.56845400E-02  +2.78830000E-04  +1.32061000E-03  -1.02970000E-03  -1.92080000E-04
   -7.92400000E-05  -9.03400000E-05  +8.66500000E-05  +5.51100000E-05  -1.94640000E-04
   -6.87200000E-05  +1.71710000E-04  -1.34470000E-04  +1.95900000E-04  -3.94900000E-05
   -1.63390000E-04  -1.49680000E-04  +2.18370000E-04  -1.21040000E-04  +4.67700000E-05
   +1.19299000E-03  -1.56767000E-03  +2.38365120E-01  -1.16000000E-05  +1.02000000E-06
   +2.02000000E-06  -2.45600000E-04  -2.05890000E-04  +3.56900000E-05  +1.38000000E-05
   -2.68000000E-06  -5.16200000E-05  -3.49100000E-05  +4.91800000E-05  +8.48000000E-06
   +2.16300000E-05  -3.52400000E-05  +2.11200000E-05  +5.21000000E-06  -2.97000000E-06
   +3.08000000E-06  -5.01180000E-04  +4.72550000E-04  +3.38120000E-04  +5.98700000E-05
   +4.75200000E-05  +6.29900000E-05  -4.26000000E-05  +3.13700000E-05  +5.50000000E-07
   -4.61938000E-03  +1.00779000E-03  -3.09804000E-03  -4.75680000E-04  -1.29996000E-03
   +8.13600000E-05  -2.00236000E-03  -1.19534000E-03  -5.20427000E-03  +1.94608900E-02
   +2.09559000E-03  -1.44937900E-02  +2.82393200E-02  -5.72523500E-02  -3.76292600E-02
   -1.44643500E-02  +6.62051000E-03  +1.24657600E-02  +1.07987000E-03  -6.24700000E-05
   +2.67272000E-03  -5.17200000E-05  +3.87400000E-05  -5.35100000E-05  -2.24000000E-06
   -1.89800000E-05  +2.25700000E-05  +1.07880000E-04  +2.56600000E-05  +4.86910000E-04
   +9.73760000E-04  -1.81550000E-04  -7.10780000E-04  +1.82600000E-04  -2.17790000E-04
   +3.32170000E-04  +1.60289000E-03  -1.26023000E-03  +2.14459000E-03  -2.93350000E-02
   +5.13607500E-02  -2.12500000E-05  -7.25000000E-06  +5.30700000E-05  +1.23790000E-04
   +5.89500000E-05  -1.45400000E-05  -2.36600000E-05  +1.82100000E-05  +3.43600000E-05
   +2.21800000E-05  -2.59800000E-05  +3.22000000E-06  -3.05900000E-05  +2.74400000E-05
   -1.13500000E-05  +8.71000000E-06  +8.62000000E-06  -1.13600000E-05  -1.10380000E-04
   -9.89000000E-05  +2.81880000E-04  +1.03200000E-05  +5.12300000E-05  -4.31800000E-05
   +3.98000000E-05  -2.53800000E-05  -6.80000000E-07  +3.99500000E-04  -2.87236000E-03
   +4.27985000E-03  -1.16327000E-03  -1.31150000E-04  -5.27990000E-04  +3.81260000E-04
   -5.48395000E-03  +2.07340000E-04  +1.96943600E-02  -1.36679000E-03  -7.71331000E-03
   +1.40309220E-01  -3.84337600E-02  -1.54455530E-01  -3.56843000E-03  +2.53560000E-04
   +4.86938000E-03  -1.27241000E-03  +2.50760000E-03  -4.59170000E-04  -1.38800000E-05
   -7.24400000E-05  -6.40000000E-07  +4.15100000E-05  +1.23200000E-05  -5.58300000E-05
   -1.98450000E-04  +4.45870000E-04  -2.13700000E-05  +7.95910000E-04  -1.26950000E-04
   -5.94860000E-04  -1.29390000E-04  +3.16640000E-04  -3.24610000E-04  -1.18081000E-03
   +2.45618000E-03  -1.50074000E-03  -1.54104180E-01  +4.25746400E-02  +1.56013830E-01
   +8.82000000E-06  -1.75180000E-04  +7.10950000E-04  +7.33420000E-04  +7.18400000E-05
   -1.79580000E-04  -6.80700000E-05  +2.55100000E-05  +6.56900000E-05  +5.11100000E-05
   +1.63340000E-04  -2.95210000E-04  +1.06830000E-04  -1.30430000E-04  +9.00000000E-05
   -7.00900000E-05  +7.12400000E-05  -1.11190000E-04  -1.24271000E-03  -7.52000000E-04
   +8.90450000E-04  -1.94100000E-05  -2.25650000E-04  +3.82550000E-04  -2.06620000E-04
   +1.86980000E-04  -4.85700000E-05  +8.51370000E-04  -1.09380000E-03  -4.29800000E-05
   +2.55310000E-04  +2.37100000E-04  +1.62820000E-04  -1.68760000E-04  -1.53500000E-05
   -4.43300000E-05  +4.74000000E-06  -8.47700000E-05  -1.30590000E-04  +9.80500000E-05
   +9.61100000E-05  -1.90200000E-05  +1.46590000E-04  +1.52210000E-04  +1.42390000E-04
   +8.14400000E-05  +4.14700000E-05  +2.95200000E-05  -2.34685140E-01  +1.24145530E-01
   +5.44990000E-04  +2.46250000E-04  +8.86800000E-05  -3.37520000E-04  -1.06600000E-05
   -1.58000000E-06  -8.18000000E-06  -2.75000000E-06  +1.35600000E-05  -1.50000000E-07
   +2.53000000E-05  -5.64100000E-05  +2.00000000E-05  +2.99100000E-05  +2.63700000E-05
   -1.87300000E-05  +2.29700000E-05  +1.50500000E-05  +1.98000000E-06  +2.51779060E-01
   +1.45418000E-03  +1.31770000E-04  -5.69630000E-04  -5.38860000E-04  -1.66838000E-03
   +3.53512000E-03  -2.74560000E-04  -1.22730000E-04  +4.88130000E-04  +9.40000000E-05
   -7.04700000E-05  -5.93200000E-05  -2.10980000E-04  +1.37110000E-04  +5.52900000E-05
   -1.84600000E-05  -2.96770000E-04  +2.29430000E-04  +1.55330700E-02  -1.20533500E-02
   -4.76380000E-04  -3.27710000E-04  +3.61570000E-04  -1.26860000E-03  +2.48800000E-04
   -1.59610000E-04  -1.79400000E-05  +1.15114000E-03  +6.97650000E-04  -2.23120000E-04
   -1.66900000E-04  -3.90620000E-04  -5.68450000E-04  +1.71110000E-04  +5.31300000E-05
   -3.66400000E-05  -2.35120000E-04  -4.38600000E-05  +1.66500000E-04  -2.33400000E-04
   -1.06920000E-04  +1.58300000E-05  -2.42280000E-04  +1.61710000E-04  -2.44900000E-05
   +1.60330000E-04  +1.48600000E-04  +2.10000000E-06  +1.22054880E-01  -1.28092140E-01
   -9.81360000E-04  -2.70500000E-04  -2.47900000E-05  +2.16520000E-04  -4.61000000E-06
   -3.47200000E-05  -3.93000000E-06  +1.23100000E-05  -6.59000000E-06  +1.38800000E-05
   +1.23900000E-05  +1.47460000E-04  +1.31180000E-04  +2.99100000E-05  -1.93700000E-05
   +7.67000000E-05  +2.32000000E-06  -1.32100000E-05  +2.04000000E-06  -1.35674020E-01
   +1.38011700E-01  -1.42684000E-03  +8.17380000E-04  +6.32420000E-04  +5.67770000E-04
   +2.75402000E-03  -4.23827000E-03  +5.63680000E-04  +1.52680000E-04  -5.25790000E-04
   -2.47140000E-04  -4.60200000E-05  +2.48140000E-04  +1.57900000E-04  -3.91300000E-05
   -5.49900000E-05  +7.31600000E-05  +2.08290000E-04  -3.36810000E-04  -2.20102600E-02
   +1.47093800E-02  -1.47311000E-03  -1.25762000E-03  +9.06620000E-04  +1.32778000E-03
   -1.05680000E-04  +2.78200000E-05  +5.68900000E-05  -9.06170000E-04  -5.52950000E-04
   +5.01770000E-04  +4.49000000E-04  +6.70700000E-05  -2.56600000E-05  -4.24010000E-04
   -1.10300000E-05  +7.37900000E-05  +1.90670000E-04  -6.82500000E-05  -2.32070000E-04
   +1.86680000E-04  +1.49970000E-04  -1.88000000E-06  -1.20000000E-04  -1.40520000E-04
   +2.14050000E-04  -1.55110000E-04  -1.04550000E-04  +1.69000000E-06  +2.66264000E-03
   -2.51626000E-03  -4.68069100E-02  +7.72400000E-05  -1.04770000E-04  +2.50800000E-05
   +1.42100000E-05  +1.09000000E-05  +1.49800000E-05  +1.15200000E-05  -1.49000000E-05
   +2.60000000E-06  +1.43300000E-05  +8.17000000E-06  +6.79100000E-05  +2.92700000E-05
   -6.10000000E-06  -9.43900000E-05  +1.24000000E-06  +7.84000000E-06  +1.25400000E-05
   -1.61464000E-03  -1.77232000E-03  +5.12638600E-02  +2.56800000E-04  -1.69400000E-04
   +1.99140000E-04  +3.49110000E-04  +4.62180000E-04  -1.16950000E-04  -6.52220000E-04
   +7.47040000E-04  +3.45200000E-05  +7.75200000E-05  +4.03000000E-06  -2.42060000E-04
   -8.14400000E-05  +5.32900000E-05  +3.83000000E-05  -1.57300000E-05  +1.05000000E-05
   -1.69000000E-06  -2.93610000E-04  +1.31458000E-03  -6.97730000E-04  +1.84420000E-04
   +3.50430000E-04  -3.70030000E-04  +5.62800000E-05  -4.02000000E-06  -2.36000000E-05
   +5.34600000E-04  -8.93020000E-04  +4.51100000E-04  +2.69380000E-04  +4.09990000E-04
   +5.14880000E-04  -3.09430000E-04  -2.11900000E-05  +7.23800000E-05  +3.50160000E-04
   +1.42340000E-04  -8.81300000E-05  +2.01600000E-05  -4.23200000E-05  -7.10400000E-05
   +5.27240000E-04  -1.48480000E-04  -1.58840000E-04  -3.33910000E-04  -2.45360000E-04
   -2.02500000E-05  -2.15069270E-01  -1.27577870E-01  +1.07548000E-03  +9.38300000E-05
   +1.14750000E-04  -3.30600000E-05  +2.41800000E-05  +4.60200000E-05  +1.94600000E-05
   -3.11700000E-05  -1.55000000E-05  -2.53200000E-05  -7.60000000E-07  -2.71700000E-05
   -2.38800000E-05  -5.37300000E-05  +5.14200000E-05  +6.32000000E-06  -1.95600000E-05
   -3.63000000E-06  +6.35000000E-06  -1.89452900E-02  -1.68714800E-02  -3.13300000E-04
   +2.31818170E-01  +3.13400000E-05  -2.16260000E-04  +5.89220000E-04  -8.76850000E-04
   +9.22090000E-04  -8.35360000E-04  +9.20850000E-04  -1.28983000E-03  +6.59720000E-04
   +1.30750000E-04  +1.51570000E-04  -3.39160000E-04  +5.41000000E-05  -1.40580000E-04
   +9.34400000E-05  -6.82500000E-05  +1.09920000E-04  -1.07280000E-04  -1.50384800E-02
   -1.19348100E-02  -7.34380000E-04  +1.08550000E-04  +4.90020000E-04  -1.40758000E-03
   -1.31200000E-04  +1.66030000E-04  -6.02400000E-05  +1.48950000E-04  -1.31399000E-03
   +3.78174000E-03  -4.16990000E-04  -1.77000000E-04  +2.55670000E-04  +2.97280000E-04
   +1.87720000E-04  +1.43400000E-05  +1.26320000E-04  +5.30300000E-04  +4.78900000E-04
   -6.05020000E-04  -3.78900000E-04  -4.06650000E-04  +4.78300000E-04  -4.11260000E-04
   -3.01620000E-04  -4.85400000E-04  -3.88880000E-04  -1.00740000E-04  -1.26883290E-01
   -1.44955550E-01  +4.73400000E-04  +3.06160000E-04  +1.97590000E-04  -4.20200000E-04
   +2.57600000E-05  +4.61900000E-05  +3.90600000E-05  -1.99700000E-05  -5.26700000E-05
   -2.29100000E-05  -4.49000000E-05  +1.67650000E-04  -1.19160000E-04  +3.58400000E-05
   -4.38100000E-05  +1.52850000E-04  -8.88400000E-05  -1.80000000E-06  -3.95800000E-05
   +1.46155400E-02  +1.23479300E-02  -4.56000000E-05  +1.40435270E-01  +1.55939940E-01
   +4.08300000E-05  -1.62000000E-06  -3.17660000E-04  +5.54160000E-04  -9.20070000E-04
   +8.39260000E-04  -3.70990000E-04  -1.17870000E-04  +3.95960000E-04  -1.33200000E-05
   +1.30750000E-04  -1.62360000E-04  -1.32570000E-04  -5.71000000E-05  +1.76090000E-04
   +1.35480000E-04  -5.23200000E-05  -2.18600000E-05  +2.15164200E-02  +1.65260700E-02
   -1.78580000E-03  +1.08034000E-03  +7.28940000E-04  +1.36808000E-03  +5.44500000E-05
   -8.98000000E-06  -4.63300000E-05  -1.13355000E-03  +2.15159000E-03  -3.86251000E-03
   +5.56100000E-05  -2.89090000E-04  +3.83500000E-05  +6.19640000E-04  -7.30700000E-05
   +9.87400000E-05  -3.94410000E-04  -2.16100000E-05  +1.68790000E-04  +9.82500000E-05
   -2.54930000E-04  +2.46480000E-04  +6.21950000E-04  +5.60620000E-04  +1.26790000E-04
   +4.20880000E-04  +3.47510000E-04  +1.59700000E-05  -1.47720000E-04  -5.83900000E-04
   -4.77281400E-02  -4.12800000E-05  -5.55200000E-05  +8.17000000E-06  -2.61000000E-06
   -2.99300000E-05  -4.28200000E-05  +3.28700000E-05  +3.11000000E-05  +1.87700000E-05
   -2.35730000E-04  +3.58240000E-04  -9.07900000E-05  -1.77800000E-05  +1.09360000E-04
   -1.59460000E-04  +6.05300000E-05  +3.11400000E-05  -9.71000000E-06  +3.79660000E-04
   +7.29200000E-05  -1.02742000E-03  -5.99410000E-04  -3.09709000E-03  +5.09953400E-02
   +9.84300000E-05  +1.20670000E-04  -1.97170000E-04  +3.68440000E-04  -6.28240000E-04
   -3.97580000E-04  -8.64600000E-04  +7.99160000E-04  -7.89230000E-04  -3.51400000E-05
   -1.36740000E-04  +2.12570000E-04  -3.33200000E-05  +1.28570000E-04  -1.31600000E-04
   -2.05000000E-05  -5.74400000E-05  +6.73100000E-05  -1.95010000E-03  -3.96550000E-04
   -3.59090000E-04  +4.55000000E-06  +1.83710000E-04  -9.04700000E-05  +1.07290000E-04
   -1.15250000E-04  +5.58600000E-05  +5.31700000E-05  +6.81110000E-04  +6.18030000E-04
   -4.72000000E-05  -1.71440000E-04  -1.20500000E-05  -2.71520000E-04  -5.34500000E-05
   -6.17300000E-05  -1.51800000E-05  -1.50620000E-04  -1.02940000E-04  +1.33940000E-04
   +1.02160000E-04  +7.24900000E-05  -2.25320000E-04  -6.49800000E-05  +9.81100000E-05
   +7.84600000E-05  +6.59200000E-05  +1.31000000E-06  -4.70471200E-02  +1.07121000E-03
   +2.09682000E-03  -1.99730000E-04  -1.34520000E-04  +2.47240000E-04  -1.21400000E-05
   -2.44000000E-05  +6.32000000E-06  +2.08200000E-05  -1.07900000E-05  +2.22400000E-05
   +2.04570000E-04  -1.97820000E-04  +1.02620000E-04  +3.54400000E-05  +6.67000000E-06
   -6.57000000E-05  +2.36000000E-06  +7.24000000E-06  -8.74000000E-06  +4.20890000E-04
   +1.45697400E-02  +2.30579200E-02  +9.56990000E-04  -1.36715000E-02  -2.19596000E-02
   +4.70972200E-02  -2.09480000E-04  -1.41000000E-05  +5.95300000E-05  -4.88750000E-04
   +1.08805000E-03  -1.90870000E-04  +7.67590000E-04  -1.02430000E-04  -1.71940000E-04
   -7.29800000E-05  -1.44440000E-04  +1.85930000E-04  +1.34130000E-04  +4.85400000E-05
   -1.26040000E-04  -6.64400000E-05  +2.73900000E-05  +3.21000000E-05  -3.35330000E-04
   +9.82114000E-03  +1.64878400E-02  -6.04200000E-05  -1.85391000E-03  +2.70955000E-03
   -5.67500000E-05  -1.40000000E-06  +4.14600000E-05  +3.56890000E-04  +9.74730000E-04
   +2.05860000E-04  -4.32680000E-04  -1.38990000E-04  +6.58760000E-04  +4.76300000E-05
   -1.53430000E-04  -1.00540000E-04  -1.84800000E-05  -7.54000000E-05  -1.18690000E-04
   +8.79200000E-05  +1.02980000E-04  +1.18880000E-04  -9.30900000E-05  -1.54200000E-05
   -7.80900000E-05  +1.56770000E-04  +1.00060000E-04  +1.41000000E-05  +1.72081000E-03
   -1.31946090E-01  -1.26335890E-01  -4.47000000E-06  +1.88100000E-05  +2.48000000E-06
   -1.70200000E-05  -1.33000000E-05  -1.54800000E-05  +1.08000000E-06  +5.78000000E-06
   +2.32700000E-05  -4.16100000E-05  -8.27010000E-04  +1.79350000E-04  +1.82100000E-05
   -1.00200000E-05  +1.38700000E-05  +9.79000000E-06  -1.96000000E-06  -1.28000000E-06
   -1.31911000E-03  -9.67444000E-03  -1.39274900E-02  +1.71833000E-03  -1.04251900E-02
   -1.51589500E-02  -1.81001000E-03  +1.42322230E-01  +1.32600000E-04  +5.98140000E-04
   -3.14510000E-04  +8.74830000E-04  -1.30038000E-03  +1.32269000E-03  -2.79770000E-04
   +4.10820000E-04  -1.86700000E-04  -2.80670000E-04  -2.26000000E-06  +1.22580000E-04
   -3.18700000E-05  -3.88400000E-05  +1.03540000E-04  +1.24480000E-04  -1.52380000E-04
   +4.07000000E-06  +6.26880000E-04  -1.55066600E-02  -2.13560000E-02  +1.20530000E-04
   +4.82847000E-03  -4.30089000E-03  +2.47000000E-05  -2.11500000E-05  +3.05600000E-05
   -1.62637000E-03  -9.84260000E-04  +8.00160000E-04  +1.02300000E-04  -6.79850000E-04
   +1.62400000E-05  +6.31890000E-04  +3.36270000E-04  +2.02480000E-04  -2.62970000E-04
   +4.29630000E-04  +4.92830000E-04  -4.86440000E-04  -4.65330000E-04  -1.86390000E-04
   +9.46560000E-04  +9.70500000E-05  -2.77740000E-04  -9.32300000E-05  -5.38900000E-05
   -3.49700000E-05  +2.76442000E-03  -1.23436390E-01  -2.31299280E-01  -1.18830000E-04
   +2.50800000E-05  +3.58960000E-04  +2.36000000E-05  +1.55700000E-05  +2.66000000E-06
   +3.92300000E-05  -1.59000000E-06  -3.16000000E-06  -2.16720000E-04  +5.46210000E-04
   +1.01890000E-04  -1.42970000E-04  +9.63000000E-06  +8.43300000E-05  -7.44000000E-06
   +1.39200000E-05  -2.12100000E-05  -8.84200000E-05  +9.76400000E-04  +9.08710000E-04
   -9.55800000E-05  +1.20904000E-03  +1.16718000E-03  -2.50339000E-03  +1.34203540E-01
   +2.53186160E-01  -5.78860000E-04  +2.36210000E-04  +9.65610000E-04  +1.08800000E-04
   -4.08100000E-04  +1.28810000E-04  -1.98050000E-04  +4.02000000E-05  +3.65700000E-05
   +1.56280000E-04  -7.17700000E-05  -2.16300000E-05  -7.28500000E-05  +8.86900000E-05
   -5.57000000E-06  -4.14000000E-06  -1.01900000E-05  -5.06800000E-05  -1.66115000E-03
   +3.77910000E-04  -7.64460000E-04  -4.91674300E-02  -6.03905000E-03  +1.03700000E-02
   +6.50800000E-05  -5.02500000E-05  -2.15700000E-05  +2.23040000E-04  +4.66560000E-04
   -3.92970000E-04  -7.60200000E-05  -5.44100000E-05  -4.64200000E-05  +1.27100000E-04
   +9.96600000E-05  +2.38000000E-05  -8.94100000E-05  -1.11900000E-05  +3.15700000E-05
   -1.10510000E-04  +2.19600000E-05  +2.21330000E-04  +4.15200000E-05  -3.71430000E-04
   -5.69460000E-04  +1.02890000E-04  +1.11400000E-04  +3.56700000E-05  -2.21000000E-06
   -1.59610000E-04  -2.91380000E-04  +3.92000000E-05  +2.46350000E-04  -6.68890000E-04
   -8.91000000E-06  -1.05900000E-05  -4.64000000E-06  +1.33500000E-05  +1.17400000E-05
   +1.65100000E-05  -1.11200000E-05  +4.80900000E-05  +4.43300000E-05  -1.14833000E-03
   +2.34990000E-04  -4.16220000E-04  -9.31000000E-06  +8.30000000E-07  -2.38300000E-05
   +2.79020000E-04  -2.78800000E-04  +2.91340000E-04  +1.93200000E-04  +2.96870000E-04
   -2.35750000E-04  +6.87080000E-04  +4.48700000E-05  -7.67000000E-05  +4.94835200E-02
   +1.36516000E-03  +3.22950000E-04  -1.55333000E-03  -5.01740000E-04  +7.48250000E-04
   +6.28840000E-04  +1.95440000E-04  +3.24000000E-06  -1.47600000E-05  -1.96300000E-04
   +6.60900000E-05  +3.15200000E-05  +9.96500000E-05  -1.05600000E-04  +3.51000000E-06
   -2.84340000E-04  -1.78300000E-05  +2.13190000E-04  +8.66150000E-04  +1.17018700E-02
   -1.76929000E-02  -5.77263000E-03  -1.23756620E-01  +1.24648640E-01  -1.52210000E-04
   +8.00500000E-05  +2.08500000E-05  +2.00260000E-04  +8.42420000E-04  +3.38390000E-04
   +2.13370000E-04  -1.47320000E-04  +1.84100000E-05  +1.42490000E-04  +4.13600000E-05
   -4.25200000E-05  -1.35080000E-04  +3.08300000E-05  +1.69500000E-04  -2.11300000E-05
   -2.27050000E-04  -1.44910000E-04  -5.68660000E-04  +3.45940000E-04  +1.18660000E-04
   +6.42900000E-05  +9.24000000E-06  -2.58600000E-05  -1.72390000E-04  -2.39052000E-03
   -3.00116000E-03  +1.21620000E-04  -2.62492000E-03  +7.91550000E-04  -1.32600000E-05
   -7.22000000E-06  -8.42000000E-06  +6.51000000E-06  +1.85300000E-05  -1.28600000E-05
   -1.75000000E-05  +2.30300000E-05  -4.15800000E-05  -1.60470000E-04  -1.28730000E-04
   -2.09810000E-04  -1.02800000E-05  +3.22700000E-05  -2.20300000E-05  -2.43990000E-04
   -5.45000000E-06  -1.13340000E-04  +2.30880000E-04  -2.89200000E-05  -6.65500000E-05
   -6.38000000E-05  +8.24350000E-04  -1.18338000E-03  +6.75736000E-03  +1.33044100E-01
   +1.29794000E-03  -7.68600000E-05  -1.48795000E-03  -5.78400000E-04  +3.40130000E-04
   +8.79580000E-04  +2.30630000E-04  +5.18400000E-05  -8.17700000E-05  -1.74680000E-04
   +5.35700000E-05  +6.23400000E-05  +2.96600000E-05  -4.06400000E-05  +2.21400000E-05
   -1.03280000E-04  -1.49430000E-04  +1.48200000E-04  +8.12300000E-04  +1.43834400E-02
   -2.07594800E-02  +1.05108900E-02  +1.20569780E-01  -2.44904750E-01  -1.78400000E-05
   +7.76000000E-06  +4.01700000E-05  +7.95330000E-04  +1.04483000E-03  +9.14740000E-04
   -3.58700000E-05  -4.60490000E-04  -2.84000000E-05  +2.21850000E-04  +1.67770000E-04
   +2.22000000E-06  -1.04620000E-04  +1.55470000E-04  +1.37360000E-04  -2.66040000E-04
   -1.15880000E-04  +1.77370000E-04  +2.02500000E-04  -2.51430000E-04  -3.64500000E-05
   +4.56000000E-06  +1.18300000E-05  +1.63500000E-05  +8.97400000E-05  -4.75933000E-03
   -3.84479000E-03  -8.72060000E-04  +1.52897000E-03  +6.69360000E-04  -6.18000000E-06
   +5.61000000E-06  -8.12000000E-06  -1.64600000E-05  +2.36100000E-05  -2.77600000E-05
   -2.30300000E-05  +9.01300000E-05  +2.81600000E-05  -5.46810000E-04  +1.87600000E-04
   +3.38400000E-05  -1.96000000E-05  -2.25700000E-05  -9.23000000E-06  -2.46700000E-05
   -8.03500000E-05  +2.65290000E-04  +6.82500000E-05  -7.19500000E-05  +3.39400000E-04
   -5.58600000E-05  +9.55240000E-04  -1.51328000E-03  -1.10803300E-02  -1.31946160E-01
   +2.66880150E-01  -1.41000000E-05  -1.53740000E-04  +2.83180000E-04  +8.30180000E-04
   +1.27943000E-03  +2.60390000E-04  +3.47050000E-04  -1.44070000E-04  -2.57600000E-05
   +2.77000000E-05  -2.74900000E-05  -6.89400000E-05  -4.69500000E-05  +2.11900000E-05
   +9.90000000E-06  +3.10100000E-05  -2.40900000E-05  -1.36900000E-05  -1.27653000E-03
   +7.45920000E-04  +9.96880000E-04  -2.43619170E-01  -1.20580450E-01  +3.06480000E-03
   +5.57500000E-05  -2.81900000E-05  +2.30000000E-07  +6.43380000E-04  +1.22350000E-04
   +1.81950000E-04  +7.44800000E-05  +1.78190000E-04  +2.49330000E-04  -8.64300000E-05
   -8.21000000E-05  -9.76400000E-05  +1.13120000E-04  +7.95900000E-05  -1.57700000E-05
   +1.90680000E-04  -1.56030000E-04  -2.38970000E-04  -2.74720000E-04  +1.36530000E-04
   +4.21900000E-04  -1.73450000E-04  -1.70410000E-04  -5.30100000E-05  -9.53200000E-05
   +2.55550000E-04  +3.29440000E-04  +5.45600000E-05  -5.21000000E-06  -1.59590000E-04
   +1.67800000E-05  +2.08000000E-05  +9.38000000E-06  -2.80700000E-05  -1.19000000E-05
   -2.27600000E-05  +8.41200000E-05  -6.27000000E-05  -4.76500000E-05  +3.10620000E-04
   -1.22730000E-04  -4.76320000E-04  -8.57000000E-06  -1.09000000E-06  +1.88300000E-05
   -1.14600000E-05  -1.21310000E-04  +3.95400000E-05  +3.05990000E-04  +2.14550000E-04
   -4.74920000E-04  +2.79440000E-04  +2.30330000E-04  -3.48600000E-05  -1.13980000E-04
   +7.49790000E-04  -4.42800000E-05  +2.62028690E-01  -3.06460000E-04  -3.83810000E-04
   +7.58170000E-04  -1.20150000E-03  +5.18670000E-04  +3.04760000E-04  +4.26610000E-04
   +5.77800000E-05  -1.38140000E-04  +1.97000000E-05  +5.59500000E-05  -1.25340000E-04
   +1.46910000E-04  -1.60300000E-04  -1.06600000E-05  +6.32200000E-05  -4.33100000E-05
   +5.05900000E-05  -1.70680400E-02  -1.25833200E-02  -1.23000000E-06  -1.18876490E-01
   -1.18904860E-01  +3.45065000E-03  -1.99320000E-04  +1.74610000E-04  +6.60000000E-06
   +1.30271000E-03  -1.48237000E-03  -3.65551000E-03  -1.25549000E-03  -1.93250000E-04
   +1.56930000E-04  -4.17300000E-05  -3.41920000E-04  -1.21710000E-04  +3.01770000E-04
   +8.77800000E-05  -7.80800000E-05  -9.66000000E-05  +1.50440000E-04  +6.31400000E-05
   +5.76670000E-04  +7.20000000E-05  -4.57860000E-04  -2.67910000E-04  -1.68840000E-04
   +5.96000000E-06  +2.48650000E-04  +3.05300000E-04  +1.19936000E-03  +4.54120000E-04
   -1.38420000E-04  -2.71520000E-04  +3.40200000E-05  +3.41300000E-05  +1.73400000E-05
   -8.63700000E-05  -1.17490000E-04  +1.14000000E-05  +8.97000000E-06  +3.19700000E-05
   -8.13200000E-05  +1.01760000E-04  -4.48800000E-05  +3.40050000E-04  -4.34600000E-05
   -7.11000000E-06  -8.03000000E-06  +1.26330000E-04  +4.89700000E-05  -3.84300000E-05
   +1.14010000E-04  +6.06490000E-04  -1.62570000E-04  +2.69140000E-04  -1.41800000E-05
   +6.61500000E-05  -1.41776100E-02  -8.38810000E-03  -1.01020000E-03  +1.30950470E-01
   +1.28849240E-01  +1.48730000E-04  -9.20000000E-05  +2.44380000E-04  -9.57170000E-04
   +6.59960000E-04  +7.56610000E-04  +1.88950000E-04  +1.65170000E-04  +5.97100000E-05
   -5.30000000E-06  +1.36000000E-06  -1.21800000E-04  +9.18500000E-05  -6.28500000E-05
   +5.90000000E-07  -1.70380000E-04  -5.19000000E-06  +6.94300000E-05  -2.28700500E-02
   -1.43659700E-02  -1.54024000E-03  +5.49766000E-03  +4.49992000E-03  -4.71363900E-02
   -1.65850000E-04  +1.12840000E-04  -1.40100000E-05  +1.26317000E-03  -2.39360000E-03
   -4.19709000E-03  -1.47079000E-03  -8.33690000E-04  +2.84010000E-04  +1.45000000E-04
   -2.53500000E-04  -2.25100000E-04  +1.04290000E-04  +1.37070000E-04  -3.04000000E-06
   -1.96200000E-04  -1.71400000E-05  +1.95220000E-04  +8.68120000E-04  -2.97210000E-04
   -4.25490000E-04  -1.42470000E-04  -6.49100000E-05  +1.91000000E-05  -1.18603000E-03
   -7.73850000E-04  +1.19806000E-03  -7.09100000E-05  +2.45370000E-04  -2.33290000E-04
   +1.98100000E-05  +2.07600000E-05  +6.77000000E-06  -1.19480000E-04  -7.65600000E-05
   -3.19300000E-05  +6.62000000E-06  +3.13200000E-05  -1.30400000E-05  -1.02650000E-04
   +4.81570000E-04  +1.88620000E-04  -2.46700000E-05  -3.27700000E-05  +1.07600000E-05
   +4.69400000E-05  +2.36200000E-05  -6.26700000E-05  +3.68820000E-04  +2.92850000E-04
   -7.20960000E-04  +2.95910000E-04  +1.52000000E-04  +2.78240000E-04  +2.46214800E-02
   +1.27209900E-02  +1.11436000E-03  -4.80403000E-03  +2.63030000E-04  +5.12349000E-02
   -8.12200000E-05  -3.38230000E-04  +6.29890000E-04  +5.43600000E-04  +6.17810000E-04
   +6.11930000E-04  +6.17910000E-04  +1.47530000E-04  -2.30320000E-04  -1.78120000E-04
   +1.44320000E-04  -1.34580000E-04  +2.30200000E-04  -2.32610000E-04  +4.24000000E-05
   -6.66000000E-05  -3.96800000E-05  +3.47600000E-05  +2.25930000E-04  -1.22702000E-03
   -1.14380000E-04  -2.01787280E-01  +1.31391250E-01  -6.58354000E-03  -2.99120000E-04
   +2.26860000E-04  +8.24000000E-06  -7.22800000E-05  -1.73400000E-05  +3.01870000E-04
   +1.03610000E-04  +8.04100000E-05  +8.74000000E-06  +6.54600000E-05  +2.32800000E-05
   -1.68300000E-05  -1.92170000E-04  +1.01600000E-05  +2.84600000E-05  +1.14370000E-04
   -1.91220000E-04  -2.48440000E-04  -1.06344000E-03  -9.81580000E-04  +5.18460000E-04
   +9.60200000E-05  +2.83100000E-05  -2.24800000E-05  +3.10410000E-04  -2.92760000E-04
   -3.73960000E-04  +2.34620000E-04  -9.69600000E-05  -2.28100000E-04  -1.90000000E-05
   -1.18600000E-05  -7.90000000E-06  +1.38900000E-05  +2.12400000E-05  -2.07000000E-06
   -1.19300000E-05  -2.96000000E-06  -1.25800000E-05  -9.57040000E-04  -1.75644000E-03
   -1.52570000E-04  +2.81500000E-05  -4.30000000E-06  +2.47300000E-05  +3.18310000E-04
   -1.27200000E-04  +3.64440000E-04  -1.80980000E-04  +1.24970000E-04  +4.24900000E-05
   +1.91350000E-04  -2.66470000E-04  +3.37400000E-05  +1.65095000E-03  -2.60028000E-03
   -6.06200000E-05  -1.96419500E-02  +1.84647200E-02  -1.39642000E-03  +2.19836980E-01
   +1.20200000E-04  +3.12520000E-04  +6.74000000E-05  -6.83120000E-04  -1.25343000E-03
   -3.72571000E-03  -2.17940000E-04  -5.62910000E-04  +2.32430000E-04  +5.46780000E-04
   -1.66350000E-04  +1.49180000E-04  -3.09290000E-04  +3.26110000E-04  -1.94320000E-04
   +1.31700000E-04  +1.31200000E-04  +1.79100000E-05  +1.55417400E-02  -1.29446400E-02
   +1.28025000E-03  +1.30126440E-01  -1.57816990E-01  +5.50172000E-03  +4.51500000E-04
   -3.46100000E-04  +2.74000000E-06  +6.89810000E-04  +5.92640000E-04  +4.23970000E-04
   -3.04230000E-04  -1.55330000E-04  -1.74840000E-04  +1.82620000E-04  +1.80470000E-04
   +5.15500000E-05  -6.55600000E-05  -3.11000000E-06  +9.66500000E-05  -3.59610000E-04
   +2.13540000E-04  +3.36160000E-04  +1.31940000E-04  -5.62960000E-04  -8.19900000E-04
   +9.37200000E-05  +1.37890000E-04  +6.16400000E-05  -9.73400000E-05  +5.52290000E-04
   +1.55164000E-03  -2.47620000E-04  -5.21510000E-04  +3.98600000E-05  -4.01000000E-06
   -1.40000000E-05  -6.10000000E-07  +8.91000000E-06  -1.30000000E-06  +2.24000000E-05
   +2.33400000E-05  +7.58500000E-05  +1.29220000E-04  -1.33522000E-03  -8.73890000E-04
   +7.37660000E-04  -1.55900000E-05  -3.30700000E-05  -1.58200000E-05  -2.67330000E-04
   +6.29650000E-04  -3.81530000E-04  -1.24270000E-04  -2.03200000E-05  -1.20210000E-04
   -3.29080000E-04  +4.61600000E-05  +1.21140000E-04  +1.24110900E-02  -1.01571600E-02
   -8.65810000E-04  -1.32629900E-02  +1.21264700E-02  -6.02320000E-04  -1.43024440E-01
   +1.70120850E-01  +1.23115000E-03  +4.46050000E-04  -1.51756000E-03  -9.89000000E-05
   -3.13437000E-03  -3.97943000E-03  -1.03220000E-04  -6.17390000E-04  +3.20220000E-04
   +3.93990000E-04  -8.53700000E-05  +2.37740000E-04  -2.16930000E-04  +2.15620000E-04
   -1.95340000E-04  -2.61200000E-05  +1.39360000E-04  +1.02300000E-04  +2.06344800E-02
   -1.61231200E-02  -4.82420000E-04  -7.41746000E-03  +6.69893000E-03  -4.81455900E-02
   +4.21980000E-04  -3.06500000E-04  +3.85800000E-05  +1.32050000E-04  +5.50620000E-04
   +6.15740000E-04  +8.96000000E-06  +6.04000000E-06  -2.36170000E-04  +1.23620000E-04
   +7.12000000E-05  -2.31000000E-05  -1.43300000E-04  +3.56900000E-05  +1.44080000E-04
   -7.39800000E-05  -1.65030000E-04  -1.38250000E-04  -4.15320000E-04  +3.51810000E-04
   +4.37100000E-04  +6.22600000E-05  +2.52200000E-05  -2.46100000E-05  +1.24897000E-03
   -8.64140000E-04  +1.23145000E-03  -8.49090000E-04  +4.53440000E-04  +9.79330000E-04
   -7.80000000E-06  -1.54400000E-05  -3.83000000E-06  +2.06600000E-05  -7.70000000E-06
   +1.06000000E-05  +4.13900000E-05  -1.14400000E-05  +3.77900000E-05  +1.26470000E-04
   +5.82600000E-05  +1.82630000E-04  +1.05200000E-05  -2.60000000E-07  +9.94000000E-06
   -5.03600000E-04  +1.29280000E-04  -7.16960000E-04  +4.94500000E-05  +1.09120000E-04
   -7.50400000E-05  -2.06790000E-04  +1.88270000E-04  +3.67610000E-04  -2.20964200E-02
   +1.61572900E-02  +7.77340000E-04  +7.37240000E-04  -4.77330000E-04  -1.01060000E-03
   +6.92079000E-03  -3.84649000E-03  +5.10049700E-02  -6.68360000E-04  +5.28770000E-04
   -1.12420000E-03  -1.58684000E-03  +3.18245000E-03  +1.37830000E-03  -1.56746300E-02
   -3.90744000E-03  +1.55848300E-02  -1.69393470E-01  -2.21614800E-02  +1.49358050E-01
   +7.26857000E-03  +3.19725000E-03  -4.00787000E-03  +1.43219000E-03  +2.21220000E-03
   -1.11630000E-04  +2.90910000E-04  -2.58480000E-04  +7.31580000E-04  -2.29960000E-04
   +1.17990000E-04  -8.49400000E-05  -2.67630000E-04  -1.75790000E-03  -7.16610000E-04
   +4.57400000E-05  +1.23430000E-04  +1.49000000E-06  -4.05100000E-05  +1.21200000E-05
   +2.03500000E-05  -2.16800000E-05  -1.05000000E-05  +1.11000000E-06  +3.30400000E-05
   +1.99000000E-05  +4.33000000E-06  -7.60000000E-07  -1.23200000E-05  +1.12000000E-06
   -3.49700000E-05  -3.79800000E-05  -2.48600000E-05  -4.39400000E-05  -3.64500000E-05
   -9.80000000E-06  +1.03600000E-05  -2.72900000E-05  +6.37500000E-05  +6.52700000E-05
   -1.57200000E-04  +1.06500000E-05  +4.20000000E-07  +5.33000000E-06  +6.10000000E-06
   -1.34800000E-05  -1.19700000E-05  -3.12000000E-06  +1.01300000E-05  +1.66300000E-05
   +2.38500000E-05  +1.16800000E-05  +5.93000000E-06  -7.46000000E-06  -5.92000000E-06
   -4.05000000E-06  +1.40000000E-07  -1.11500000E-05  +3.13800000E-05  -2.96800000E-05
   +2.56000000E-06  +1.14200000E-05  +1.62200000E-05  -2.50300000E-05  -1.16200000E-05
   -3.03200000E-05  +8.30000000E-07  -7.68000000E-06  -7.76000000E-06  +1.01500000E-05
   -7.95000000E-06  -6.21000000E-06  -2.12300000E-05  +7.60600000E-05  +7.25100000E-05
   +1.78563180E-01  +2.88010000E-04  -1.53504000E-03  +1.70650000E-04  +4.48135000E-03
   +5.86710000E-04  +1.08794000E-03  +7.87136000E-03  +3.08804000E-03  -1.45680000E-02
   -1.78630000E-02  -4.84076700E-02  +4.03212100E-02  -1.45056900E-02  +2.98249000E-03
   +1.76924800E-02  +2.61131000E-03  -5.42560000E-04  +3.93129000E-03  +2.22000000E-04
   +7.07570000E-04  -1.87490000E-04  +2.68000000E-05  +3.56800000E-05  +4.57400000E-05
   -1.48815000E-03  -3.34760000E-04  -2.74176000E-03  +2.19120000E-04  -2.19320000E-04
   -4.28700000E-05  -7.39000000E-06  +5.25000000E-06  +2.17200000E-05  -1.91000000E-06
   +6.00000000E-08  -1.10500000E-05  -1.91700000E-05  -3.12500000E-05  -1.35700000E-05
   +2.59000000E-05  +3.36000000E-05  -1.33200000E-05  +1.41300000E-05  +2.76800000E-05
   +4.19600000E-05  +3.72800000E-05  +2.33100000E-05  +3.06000000E-06  +1.22000000E-05
   +9.13200000E-05  -4.13900000E-05  -1.63060000E-04  +1.52240000E-04  -2.08140000E-04
   -5.58000000E-06  -2.50000000E-06  -1.10000000E-07  -5.18000000E-06  +4.50000000E-07
   +1.74000000E-06  -7.60000000E-07  +1.02500000E-05  +7.66000000E-06  +5.00000000E-06
   -9.11000000E-06  -1.65000000E-06  +6.45000000E-06  +6.07000000E-06  -3.82000000E-06
   -4.73000000E-06  -2.02800000E-05  +2.50600000E-05  -2.41400000E-05  -4.82200000E-05
   -1.35900000E-05  +6.02000000E-06  +2.18800000E-05  +6.23000000E-06  -1.96000000E-06
   -8.37000000E-06  -6.24000000E-06  -1.69400000E-05  -3.49000000E-06  -1.35000000E-05
   +3.68000000E-06  -9.47000000E-06  -1.65900000E-05  +1.90396800E-02  +4.34344700E-02
   -8.27540000E-04  +9.58600000E-05  -6.11970000E-04  -4.00750000E-04  +1.99386000E-03
   +2.44780000E-03  +1.03591000E-03  -4.34904000E-03  +1.27945000E-03  +1.44279040E-01
   +4.38504100E-02  -2.06722180E-01  +1.77233400E-02  +2.57084000E-03  -1.13222900E-02
   -5.66730000E-04  +4.34654000E-03  -3.98270000E-04  +8.57500000E-05  +2.39730000E-04
   +3.37440000E-04  -7.13000000E-05  +8.57800000E-05  -1.34300000E-05  -9.42000000E-04
   -2.57770000E-03  +3.93370000E-04  +1.01510000E-04  -6.36000000E-05  -1.71100000E-05
   -5.60000000E-06  +7.93000000E-06  +6.79000000E-06  -4.20000000E-06  -7.45000000E-06
   -9.41000000E-06  -1.36700000E-05  -2.10800000E-05  -7.86000000E-06  +1.39000000E-05
   +1.68600000E-05  +1.00000000E-07  -8.05000000E-06  +1.91000000E-06  +2.02300000E-05
   +2.26600000E-05  +1.49900000E-05  +1.50000000E-07  +4.21300000E-05  -8.24000000E-06
   +2.42600000E-05  -1.02460000E-04  -1.60880000E-04  +1.71740000E-04  -4.37000000E-06
   -3.29000000E-06  +6.90000000E-07  -3.50000000E-06  -1.49000000E-06  +1.17000000E-06
   -2.02000000E-06  -3.05000000E-06  +6.13000000E-06  +4.51000000E-06  -1.83000000E-06
   -2.29000000E-06  +1.97000000E-06  +2.22000000E-06  -2.20000000E-06  +2.05900000E-05
   +7.90000000E-07  -1.96200000E-05  +9.56000000E-06  +1.50200000E-05  +2.35900000E-05
   -3.06400000E-05  -2.57600000E-05  -2.86900000E-05  -3.80000000E-07  -6.23000000E-06
   -1.17400000E-05  -2.25000000E-06  -3.58000000E-06  -9.60000000E-07  -5.69000000E-06
   +2.69800000E-05  +2.53800000E-05  -1.60827180E-01  -4.58779000E-02  +2.14943280E-01
   +6.13700000E-05  +1.73719900E-02  -1.90408600E-02  -3.03018000E-03  +3.94816000E-03
   +1.53648000E-03  -1.75061000E-03  +2.46910000E-04  +7.18710000E-04  -1.40204000E-03
   +4.48080000E-04  +4.32781000E-03  +6.71794000E-03  -1.39093700E-02  +1.41330400E-02
   -6.06795700E-02  +4.26368600E-02  -2.36721800E-02  +6.11020000E-04  +5.68790000E-04
   -8.94550000E-04  +5.05000000E-06  -7.51700000E-05  -9.39600000E-05  +1.27397000E-03
   -2.90758000E-03  -1.24560000E-03  +1.75660000E-04  +1.05170000E-04  +2.16500000E-05
   -9.09000000E-06  -3.71400000E-05  +1.40000000E-05  -1.62100000E-05  -2.90100000E-05
   +1.43300000E-05  +2.28900000E-05  +3.04900000E-05  +8.54000000E-06  -1.56000000E-05
   -2.71400000E-05  +1.76000000E-06  -1.71900000E-05  -3.61500000E-05  -2.90000000E-06
   -4.71800000E-05  -5.07500000E-05  +6.90000000E-07  -4.03530000E-04  +1.78440000E-04
   +1.08950000E-04  +9.88570000E-04  -1.53891000E-03  -2.69552000E-03  -5.56000000E-06
   +1.28400000E-05  -5.17000000E-06  -1.65900000E-05  -4.38000000E-06  -1.74300000E-05
   +3.32000000E-06  +3.12100000E-05  +9.10000000E-07  +6.89000000E-06  +1.14000000E-05
   -8.60000000E-06  -9.97000000E-06  -8.90000000E-07  -2.20000000E-06  -2.83500000E-05
   +7.90700000E-05  -1.44050000E-04  -6.60000000E-07  -1.85500000E-05  +2.98200000E-05
   +1.02300000E-05  -2.01300000E-05  -2.64200000E-05  +5.02000000E-06  +2.70400000E-05
   +3.03700000E-05  -3.73000000E-06  -1.25300000E-05  +1.16900000E-05  -2.22200000E-05
   +2.00700000E-05  +4.02600000E-05  +4.32200000E-04  -5.82340000E-04  +7.46070000E-04
   +5.87883500E-02  -7.29450000E-04  -8.75971000E-03  +1.53035600E-02  +4.28890000E-03
   +1.09850000E-03  +4.18620000E-04  +1.43450000E-04  +1.22500000E-04  -9.46060000E-04
   +2.04580000E-04  +2.84482000E-03  +1.52495000E-03  +4.22964000E-03  -1.71953000E-03
   +2.08448000E-03  +4.27760100E-02  -1.71406710E-01  +1.43855030E-01  -3.15270000E-04
   +1.02700000E-05  +8.16910000E-04  +5.95100000E-05  +2.95000000E-06  +1.03300000E-04
   -2.28032000E-03  -3.08810000E-04  -2.96038000E-03  -1.11410000E-04  -1.44760000E-04
   -2.52300000E-05  -9.90000000E-07  +3.18100000E-05  +2.86400000E-05  +1.39600000E-05
   -1.74400000E-05  -1.71500000E-05  -5.85000000E-05  -5.26400000E-05  -9.20000000E-06
   +3.58900000E-05  +3.78200000E-05  -4.67000000E-06  -1.09000000E-06  +3.90600000E-05
   +8.06000000E-06  +8.27100000E-05  +5.81000000E-05  +1.61000000E-06  +3.37780000E-04
   -1.80530000E-04  -9.22900000E-05  -2.56334000E-03  -4.49830000E-04  -2.72373000E-03
   -1.26800000E-05  -1.01700000E-05  -1.77000000E-06  +2.10000000E-07  +6.34000000E-06
   +2.10000000E-06  -9.80000000E-06  -1.18700000E-05  -3.14100000E-05  +2.16000000E-06
   -1.67900000E-05  +2.37000000E-06  +1.28500000E-05  +1.77000000E-06  -6.00000000E-07
   +2.47000000E-06  -1.21850000E-04  +6.64400000E-05  -2.97900000E-05  +4.09000000E-06
   +9.05000000E-06  -1.08800000E-05  +1.13300000E-05  -4.49000000E-05  +1.85800000E-05
   +1.49400000E-05  -4.57400000E-05  -1.63400000E-05  -6.45000000E-06  +1.60600000E-05
   +1.54300000E-05  -3.71700000E-05  -5.09100000E-05  +2.05480000E-04  +1.06480000E-04
   +2.82040000E-04  -4.75247000E-02  +1.78299900E-01  +3.27622000E-03  -5.94120000E-04
   +9.10760000E-04  +1.22041000E-03  +8.04010000E-04  +2.37676000E-03  +8.64190000E-04
   -9.99460000E-04  -5.71000000E-05  +4.52086000E-03  +1.33965000E-03  -1.39680000E-03
   -8.76899000E-03  +1.79067900E-02  -1.18522100E-02  -2.36467700E-02  +1.44164190E-01
   -1.86437620E-01  +3.24480000E-04  +3.14800000E-05  +1.63370000E-04  -5.08200000E-05
   +2.03100000E-05  -1.82300000E-05  -1.86615000E-03  -2.50570000E-03  +5.38830000E-04
   -8.59000000E-06  +4.63200000E-05  +2.47700000E-05  +5.15000000E-06  -2.56800000E-05
   +2.03000000E-06  -1.78600000E-05  -1.53300000E-05  +2.55100000E-05  +3.20700000E-05
   +4.10900000E-05  +1.98200000E-05  -1.11100000E-05  -3.25300000E-05  -9.43000000E-06
   -1.33200000E-05  -7.84000000E-06  -2.56100000E-05  -5.97400000E-05  -6.07300000E-05
   -2.17000000E-06  -6.01100000E-05  -1.16000000E-06  +1.95800000E-05  -1.49807000E-03
   -3.38585000E-03  +9.76900000E-04  -3.72000000E-06  +1.66900000E-05  -4.09000000E-06
   -1.55900000E-05  -2.69000000E-06  -2.07600000E-05  +1.53300000E-05  +3.31300000E-05
   +3.63000000E-06  +8.94000000E-06  +4.06000000E-06  -6.78000000E-06  -6.03000000E-06
   -1.70000000E-06  +2.10000000E-07  -4.17100000E-05  -1.50700000E-05  -1.70200000E-05
   -1.72200000E-05  -4.70800000E-05  +1.37200000E-05  +2.81500000E-05  +3.08000000E-06
   -1.73700000E-05  +8.75000000E-06  +1.96300000E-05  +7.03000000E-06  -7.88000000E-06
   -3.02900000E-05  -1.52000000E-06  -2.12200000E-05  +2.80500000E-05  +2.59600000E-05
   -2.28290000E-04  +9.54110000E-04  -5.21530000E-04  +2.46880200E-02  -1.58220160E-01
   +1.95227140E-01  -1.64090000E-03  +4.18840000E-04  -1.14090000E-04  +2.48740000E-04
   -6.24390000E-04  +5.85680000E-04  +6.30210000E-04  +1.20302000E-03  -7.88390000E-04
   -4.45899000E-03  +3.17192000E-03  +2.20921000E-03  -6.79134000E-03  +2.99095500E-02
   -3.35529200E-02  +1.56830000E-03  -4.07470000E-04  -1.81861000E-03  -1.67730000E-04
   +4.85800000E-05  +1.00180000E-04  +4.05700000E-05  +2.28000000E-06  +2.81000000E-06
   -3.50765600E-02  +5.60833000E-03  +2.06873200E-02  +2.70000000E-06  -5.53700000E-05
   -4.31000000E-06  +1.98000000E-06  -8.71000000E-06  +3.18100000E-05  +3.64200000E-05
   -3.52200000E-05  -1.98200000E-05  -1.26420000E-04  -8.31500000E-05  -1.51300000E-05
   +1.90500000E-05  +2.75000000E-05  +2.12300000E-05  -1.42700000E-05  +4.82000000E-06
   +3.09700000E-05  +1.40340000E-04  +8.93300000E-05  +1.45600000E-05  +8.04900000E-05
   -2.35900000E-05  -1.85000000E-05  +7.43370000E-04  -2.42900000E-04  -3.59430000E-04
   -2.95900000E-05  -1.50300000E-05  -1.14800000E-05  -6.45000000E-06  +1.34200000E-05
   -3.05000000E-06  -1.69300000E-05  +5.27000000E-06  -4.33600000E-05  -1.07000000E-05
   +1.53000000E-06  -4.91000000E-06  +6.90000000E-06  +3.60000000E-06  -7.32000000E-06
   +1.75500000E-05  -3.21800000E-05  +2.51000000E-05  -1.43300000E-05  +5.43000000E-06
   -1.07500000E-05  -4.51000000E-06  +1.24600000E-05  -4.11000000E-06  -1.80900000E-05
   +3.81000000E-05  +1.54200000E-05  -1.25500000E-05  +8.29000000E-06  +1.37200000E-05
   +2.81800000E-05  -3.29100000E-05  -4.74000000E-06  -1.41500000E-04  -3.34230000E-04
   -1.86480000E-04  -5.89640000E-04  -4.44120000E-04  +1.84793000E-03  +4.57933900E-02
   +2.76020000E-04  -1.23479000E-03  -1.50420000E-04  -2.96800000E-04  +5.07800000E-04
   -3.81750000E-04  +4.66630000E-04  -8.58400000E-05  +1.41858000E-03  +4.17157000E-03
   +8.15250000E-04  -1.38346000E-03  +2.24377000E-03  -2.13888600E-02  +2.16010000E-02
   -3.75799000E-03  +2.49676000E-03  -1.18773000E-03  +2.31400000E-04  -7.51700000E-05
   +6.06000000E-05  -1.07310000E-04  +5.69800000E-05  -4.42200000E-05  +3.50264900E-02
   -2.23554880E-01  +2.44418680E-01  +1.70900000E-05  +1.03310000E-04  -5.83000000E-06
   -1.26100000E-05  -8.47000000E-06  -9.66000000E-06  -3.31600000E-05  +1.20800000E-05
   +3.68000000E-05  +1.13650000E-04  +9.73000000E-05  +2.74700000E-05  -2.20100000E-05
   -4.82300000E-05  -2.20400000E-05  -5.69000000E-06  -1.92000000E-05  -3.36300000E-05
   -1.45940000E-04  -1.21040000E-04  -1.22900000E-05  -6.39800000E-05  +2.97000000E-06
   +2.69300000E-05  -6.06680000E-04  +1.54340000E-04  +3.20530000E-04  +1.29900000E-05
   +2.94500000E-05  +4.20000000E-06  -1.60900000E-05  -1.33000000E-05  -1.86200000E-05
   +2.45000000E-05  +3.19300000E-05  +3.66200000E-05  +1.74600000E-05  +1.75000000E-06
   -6.38000000E-06  -9.65000000E-06  -3.44000000E-06  +4.04000000E-06  -1.83000000E-05
   +3.42600000E-05  -2.00300000E-05  +7.40000000E-06  -1.44400000E-05  +1.72300000E-05
   +7.82000000E-06  -1.18300000E-05  -3.70000000E-06  +2.20900000E-05  -1.83700000E-05
   -1.23500000E-05  +6.10000000E-07  -3.81400000E-05  -8.15000000E-06  -3.83300000E-05
   +4.82300000E-05  +2.98500000E-05  -3.72120000E-04  -1.40610000E-04  -5.05860000E-04
   +9.95380000E-04  +4.11790000E-04  -2.86480000E-04  -3.82766100E-02  +2.41848310E-01
   +8.62900000E-05  -2.77190000E-04  -9.01630000E-04  +1.14120000E-04  -6.14800000E-05
   -3.54400000E-05  +1.18360000E-04  +7.53100000E-04  +3.68220000E-04  +1.01876000E-03
   -5.58910000E-04  +2.44201000E-03  +1.04315000E-03  -2.57080000E-03  -1.56440000E-04
   +2.34946000E-03  -4.09980000E-03  +2.01794000E-03  -7.28300000E-05  +1.11380000E-04
   -8.61500000E-05  +7.95400000E-05  -4.51600000E-05  +4.98800000E-05  -1.61056500E-02
   +2.70187170E-01  -3.26842230E-01  +4.86200000E-05  -7.05100000E-05  -3.80000000E-06
   +5.65000000E-06  +1.32000000E-05  +2.54100000E-05  +4.83000000E-06  -1.38600000E-05
   -5.58000000E-06  -3.00400000E-05  -3.13900000E-05  -1.03300000E-05  +2.07600000E-05
   +2.72700000E-05  -2.69000000E-06  -1.17600000E-05  +5.30000000E-06  +1.79400000E-05
   +4.37200000E-05  +2.96400000E-05  -1.85000000E-06  +2.46000000E-06  +1.23900000E-05
   -1.74600000E-05  +7.65800000E-05  +3.29300000E-05  -1.12280000E-04  -8.68000000E-06
   -4.02000000E-06  +1.60000000E-06  -6.05000000E-06  +1.15000000E-06  -4.60000000E-07
   -5.43000000E-06  +3.51000000E-06  -2.33100000E-05  +2.37000000E-06  -9.35000000E-06
   +8.20000000E-07  +6.50000000E-06  +1.07000000E-06  -1.58000000E-06  +1.06800000E-05
   -7.60000000E-06  +1.19000000E-06  -2.75000000E-06  +2.13000000E-06  +1.05000000E-06
   -2.96000000E-06  +1.86000000E-06  -3.64000000E-06  +8.47000000E-06  +5.29000000E-06
   -6.83000000E-06  -3.84000000E-06  +7.08000000E-06  +1.60300000E-05  +1.70100000E-05
   -2.70800000E-05  -3.71900000E-05  -1.28350000E-04  -5.46130000E-04  -4.48700000E-05
   +3.79400000E-05  +9.60130000E-04  -4.01040000E-04  +1.11289700E-02  -2.63821100E-01
   +3.23708490E-01  +6.16163000E-03  -2.66154800E-02  +2.17145900E-02  -2.81592000E-03
   +2.67050000E-04  +4.34601000E-03  +1.03084000E-03  -1.92960000E-04  +5.18510000E-04
   -3.89320000E-04  +5.55170000E-04  -4.16600000E-04  -1.33330000E-03  -3.35470000E-04
   +5.37240000E-04  +7.33620000E-04  -2.51586000E-03  +1.45490000E-03  -1.78260000E-04
   -1.73150000E-04  +3.66600000E-05  -4.83800000E-05  +1.84600000E-05  +4.51200000E-05
   +4.46210000E-04  -1.51900000E-05  -3.34360000E-04  +2.14890000E-04  +9.79700000E-05
   -2.29600000E-05  +1.03350000E-04  +2.21940000E-04  +2.48000000E-05  -1.53290000E-04
   -1.40810000E-04  +1.12170000E-04  +1.17660000E-04  -2.69200000E-05  -8.19300000E-05
   -8.84000000E-06  -6.90800000E-05  +6.23400000E-05  +3.90700000E-05  +3.08600000E-05
   -7.77100000E-05  -1.79130000E-04  -1.70020000E-04  +2.88200000E-05  -6.98700000E-05
   -4.37100000E-05  -3.21800000E-05  -7.70167600E-02  +1.43231950E-01  -8.84383200E-02
   -2.58700000E-05  +3.25000000E-05  -3.19100000E-05  -2.57400000E-05  +1.58000000E-06
   -3.79400000E-05  +1.65800000E-05  +3.34000000E-05  +3.65000000E-06  +4.72200000E-05
   +3.51700000E-05  -2.42200000E-05  -5.96300000E-05  +2.61500000E-05  -1.97900000E-05
   -6.47000000E-06  +2.37000000E-05  -2.31000000E-05  -1.85000000E-05  -1.90200000E-05
   +1.08000000E-05  +7.60000000E-07  +1.80400000E-05  -3.86800000E-05  +9.35000000E-05
   -1.56370000E-04  -2.71030000E-04  +3.27000000E-06  +2.34000000E-05  -4.15000000E-06
   -1.53800000E-05  +1.24640000E-04  -1.13060000E-04  +3.84000000E-06  +1.53960000E-04
   -8.21300000E-05  -1.05458000E-03  +1.67907000E-03  -4.97340000E-04  -2.37730000E-04
   +1.48400000E-04  +1.54110000E-04  +7.46245400E-02  +2.37499000E-03  -6.88299000E-03
   +3.74026000E-03  -4.10470000E-04  +2.92741000E-03  -3.57010000E-04  +4.46020000E-04
   +1.64680000E-04  +7.95990000E-04  +1.50900000E-04  +2.49320000E-04  -4.25570000E-04
   -8.54500000E-05  -1.01097000E-03  +1.59170000E-04  +1.40118000E-03  +1.75505000E-03
   -4.94457000E-03  +7.90000000E-05  -5.98400000E-05  -4.72370000E-04  -2.58400000E-05
   -1.23270000E-04  -2.71180000E-04  +3.02080000E-04  -1.11900000E-04  -1.53160000E-04
   +7.20000000E-05  -8.90000000E-06  +1.37620000E-04  +4.00300000E-05  -2.48000000E-05
   -4.24100000E-05  +6.92000000E-06  -7.00900000E-05  +4.43500000E-05  +3.61700000E-05
   +8.45800000E-05  +5.23600000E-05  -3.82600000E-05  -4.39700000E-05  -1.62900000E-05
   -5.74400000E-05  +9.43000000E-06  -5.30000000E-07  -8.69200000E-05  -1.12690000E-04
   +5.45000000E-06  -4.32100000E-05  -2.57000000E-05  -1.41400000E-05  +1.11956030E-01
   -3.20947730E-01  +2.43117600E-01  -1.76100000E-05  +3.12300000E-05  -2.43600000E-05
   -2.37100000E-05  +1.42000000E-06  -4.45200000E-05  +2.42600000E-05  +5.34500000E-05
   +4.42000000E-06  +1.49100000E-05  -2.14900000E-05  -4.53000000E-06  -7.65000000E-06
   +5.26000000E-06  -1.23000000E-06  -1.66400000E-05  +1.40100000E-05  -8.44000000E-06
   -1.48500000E-05  -2.51200000E-05  +1.04300000E-05  +8.38000000E-06  +1.01100000E-05
   -1.83400000E-05  +1.09500000E-04  -1.37270000E-04  +3.37840000E-04  +2.49000000E-06
   -9.95900000E-05  +6.93000000E-05  -5.03100000E-05  -1.41600000E-05  +5.60100000E-05
   -3.57000000E-06  -9.00000000E-07  +6.52100000E-05  +6.28500000E-05  +1.41810000E-04
   +8.19290000E-04  +4.36100000E-05  +1.24120000E-04  -1.02500000E-05  -1.16249370E-01
   +3.24149510E-01  -8.91148000E-03  +2.98687300E-02  -2.73973900E-02  +5.16859000E-03
   -5.47360000E-04  -9.44810000E-04  -8.48700000E-05  +1.55879000E-03  -8.37760000E-04
   -2.34690000E-04  -5.58820000E-04  +9.30590000E-04  +2.81990000E-04  -1.99380000E-04
   -1.48678000E-03  -3.17295000E-03  -1.43168000E-03  +2.99711000E-03  -1.21070000E-04
   -3.01440000E-04  -5.49000000E-05  +1.71640000E-04  -3.58450000E-04  +1.20800000E-05
   -6.74960000E-04  +1.76610000E-04  +3.73840000E-04  -8.18100000E-05  -6.29000000E-05
   -7.36000000E-06  +7.08500000E-05  +3.52800000E-05  +1.66100000E-05  +4.32700000E-05
   -1.35350000E-04  -1.06600000E-05  -2.26410000E-04  -1.08770000E-04  +2.81700000E-05
   +1.35200000E-05  +5.83500000E-05  -1.11500000E-05  -3.74000000E-05  +3.55100000E-05
   +9.70000000E-06  +2.05830000E-04  +1.34680000E-04  -7.52000000E-06  +2.06900000E-05
   -2.97200000E-05  -5.28100000E-05  -5.55623100E-02  +2.14873920E-01  -1.86083410E-01
   -4.31000000E-05  -2.41400000E-05  -6.39000000E-06  -1.35700000E-05  +1.81100000E-05
   -1.82000000E-05  -5.83000000E-06  +2.16000000E-05  -8.23500000E-05  -1.19600000E-05
   -4.48400000E-05  +1.20300000E-05  +3.82100000E-05  -1.04000000E-05  +2.70000000E-06
   +9.89000000E-06  -3.05400000E-05  +1.48800000E-05  -1.31600000E-05  -9.94000000E-06
   +9.12000000E-06  -7.34000000E-06  +1.40300000E-05  -7.06000000E-06  -3.69600000E-05
   +1.99530000E-04  +2.05150000E-04  -1.08200000E-05  -2.94100000E-05  +6.13200000E-05
   +2.37500000E-05  -1.03920000E-04  +3.73100000E-05  +7.39100000E-05  -3.72000000E-06
   +5.28700000E-05  +1.37842000E-03  -3.09150000E-04  +4.53260000E-04  +2.52460000E-04
   -8.88200000E-05  +4.42000000E-05  +6.14976900E-02  -2.42606390E-01  +2.11747590E-01
end_hess

