# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.25910540    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.77605293E+00  -5.51152472E-01  +1.67376038E+00
   006   +2.30563179E+00  +1.27932595E+00  -1.81338808E-01
   006   +4.14350095E+00  +1.52756883E+00  -2.06310178E+00
   006   +6.24361447E+00  +3.22501579E-02  -2.03394052E+00
   006   +6.74563398E+00  -1.77855158E+00  -2.52150924E-01
   006   +4.93821852E+00  -2.04707685E+00  +1.64273469E+00
   006   -9.17008403E-02  +2.90106147E+00  -1.18635908E-01
   006   +4.93810421E-03  +4.61901143E+00  +2.22250704E+00
   008   +8.88042846E+00  -3.18525715E+00  -3.73519000E-01
   006   -2.42842038E+00  +1.18910815E+00  -1.63803731E-01
   006   -2.57676964E+00  -7.51629537E-01  -1.92983528E+00
   006   -4.68488568E+00  -2.28939722E+00  -2.11005827E+00
   006   -6.72331732E+00  -1.90822667E+00  -5.01742022E-01
   006   -6.61657779E+00  +1.60162341E-02  +1.27121423E+00
   006   -4.48993601E+00  +1.53544176E+00  +1.42494844E+00
   008   -8.84481715E+00  -3.35917715E+00  -5.81182914E-01
   006   -2.71518836E-01  +4.63698288E+00  -2.44224527E+00
   008   +1.04075363E+00  -8.46233083E-01  +3.54514983E+00
   001   -8.68057028E+00  -4.59846537E+00  -1.88706444E+00
   001   -4.73941324E+00  -3.79201402E+00  -3.50230169E+00
   001   -9.98687095E-01  -1.09338882E+00  -3.18796816E+00
   001   -4.45803853E+00  +3.00354121E+00  +2.84423062E+00
   001   -8.20347160E+00  +3.02396544E-01  +2.52673087E+00
   001   -2.03661999E+00  +5.69377227E+00  -2.34910408E+00
   001   +1.27983484E+00  +5.99512494E+00  -2.49455449E+00
   001   -2.79025759E-01  +3.56906072E+00  -4.20383605E+00
   001   -4.00749514E-02  +3.53876321E+00  +3.97001775E+00
   001   +1.74684683E+00  +5.71845691E+00  +2.18326277E+00
   001   -1.57069081E+00  +5.94824777E+00  +2.22565443E+00
   001   +3.90241219E+00  +2.89943422E+00  -3.55748371E+00
   001   +5.21923781E+00  -3.43964120E+00  +3.12571087E+00
   001   +8.92384429E+00  -4.34534905E+00  +1.01282690E+00
   001   +1.49055820E+00  -2.24986947E+00  +4.59000775E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -3.40000000E-07  -1.30000000E-07  -6.70000000E-07
   -1.50000000E-07  -2.30000000E-07  -3.90000000E-07
   -4.00000000E-07  +1.04000000E-06  -5.10000000E-07
   +4.00000000E-07  +5.00000000E-07  -9.90000000E-07
   +7.00000000E-08  +7.30000000E-07  -1.41000000E-06
   +9.00000000E-07  -1.80000000E-07  -7.80000000E-07
   -4.10000000E-07  +2.40000000E-07  +3.90000000E-07
   +2.10000000E-07  -5.40000000E-07  +4.80000000E-07
   +7.00000000E-08  +6.80000000E-07  -1.64000000E-06
   -6.00000000E-08  +2.90000000E-07  +6.30000000E-07
   +7.00000000E-08  -2.00000000E-08  +3.60000000E-07
   +9.00000000E-08  +3.00000000E-08  -3.00000000E-08
   +0.00000000E+00  -4.40000000E-07  +5.00000000E-07
   +2.20000000E-07  -7.60000000E-07  +7.70000000E-07
   -8.00000000E-08  -4.40000000E-07  +5.20000000E-07
   +2.40000000E-07  -5.00000000E-07  +3.00000000E-07
   -8.30000000E-07  +4.50000000E-07  +7.50000000E-07
   +1.14000000E-06  -9.00000000E-08  -4.00000000E-07
   +2.00000000E-07  -3.40000000E-07  +2.50000000E-07
   -1.30000000E-07  +2.40000000E-07  -2.30000000E-07
   -2.10000000E-07  +4.80000000E-07  -2.50000000E-07
   +1.80000000E-07  -9.30000000E-07  +9.30000000E-07
   +3.50000000E-07  -1.04000000E-06  +9.60000000E-07
   -7.50000000E-07  +2.10000000E-07  +9.80000000E-07
   -8.90000000E-07  +6.00000000E-07  +8.20000000E-07
   -6.10000000E-07  +7.90000000E-07  +5.30000000E-07
   +1.10000000E-07  -5.60000000E-07  +4.70000000E-07
   -6.00000000E-08  -3.60000000E-07  +6.70000000E-07
   -5.00000000E-08  -3.70000000E-07  +9.90000000E-07
   -7.40000000E-07  +7.70000000E-07  +6.00000000E-08
   +5.60000000E-07  +0.00000000E+00  -1.26000000E-06
   +3.80000000E-07  +7.70000000E-07  -2.07000000E-06
   +5.30000000E-07  -8.90000000E-07  -7.30000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.76447610E-01  -1.77269680E-01  +4.58176570E-01  -1.37643660E-01  -2.00512840E-01
   +5.27510210E-01  -1.22827100E-01  +6.88294200E-02  -4.09268500E-02  +5.25994680E-01
   +2.75207400E-02  -1.84417190E-01  +1.10900340E-01  -1.33642120E-01  +4.09522200E-01
   +8.35564000E-03  +7.67465100E-02  -1.75682680E-01  -1.37182790E-01  -1.75317410E-01
   +5.06488840E-01  +4.11577000E-02  -5.98045300E-02  +4.07333700E-02  -1.94361880E-01
   +2.85039400E-02  +7.98505000E-02  +5.30220830E-01  -2.71810000E-02  +1.55490300E-02
   +9.01672000E-03  -1.52378100E-02  -9.38511400E-02  +5.51406000E-02  -1.96070120E-01
   +4.54990320E-01  +1.69464000E-03  +3.66781300E-02  -4.21972900E-02  +1.33906010E-01
   +1.81047200E-02  -1.97265100E-01  -1.01686270E-01  -2.32209880E-01  +5.05114180E-01
   -2.52777100E-02  +3.54290300E-02  -2.31498100E-02  -4.78860300E-02  -2.72983000E-03
   +5.35210600E-02  -2.61679800E-01  +1.51765170E-01  -2.79747000E-03  +4.12543830E-01
   +3.29649600E-02  -4.78410700E-02  +2.75066200E-02  +3.16795000E-02  +3.05367300E-02
   -5.09264700E-02  +1.34302310E-01  -1.66588580E-01  +2.91006800E-02  -2.43968250E-01
   +3.97938870E-01  -2.05415400E-02  +2.60684800E-02  -1.60841300E-02  +1.17667800E-02
   -2.20680700E-02  +2.80671000E-02  +1.89097800E-02  +1.43197600E-02  -8.26500100E-02
   -5.85280000E-04  -1.98102380E-01  +3.07567090E-01  -4.11815700E-02  +1.71811700E-02
   +1.16036400E-02  +9.04300000E-04  -1.33516000E-02  +1.68159000E-02  +1.27738800E-02
   +1.95429100E-02  -3.56305700E-02  -9.92640900E-02  +5.34436100E-02  -2.69963800E-02
   +5.67904180E-01  -1.70873200E-02  +3.86967800E-02  -3.69183800E-02  -1.41422900E-02
   -1.81836300E-02  +3.56188600E-02  +4.40078400E-02  -3.17610300E-02  +2.49830000E-04
   +3.47537600E-02  -1.95278900E-01  +1.41399330E-01  -2.05266950E-01  +4.69504600E-01
   +5.34843600E-02  -6.65964400E-02  +3.17357300E-02  +1.75484500E-02  +3.52394300E-02
   -5.70411900E-02  -6.59880900E-02  +2.11075700E-02  +2.96121200E-02  -3.76930000E-03
   +1.25507060E-01  -2.04303730E-01  -1.10331360E-01  -2.15052110E-01  +5.07876490E-01
   -2.36782720E-01  +9.12166500E-02  +3.75152900E-02  +1.14934800E-02  +4.28225600E-02
   -5.65296200E-02  -5.28931600E-02  +1.76780100E-02  +2.50338800E-02  +4.13024700E-02
   -4.95284200E-02  +3.59639600E-02  -1.94151560E-01  +3.03705500E-02  +7.68059300E-02
   +5.59288200E-01  +1.36925860E-01  -1.69252990E-01  +1.13926000E-02  +1.57687800E-02
   -2.24717900E-02  +2.33149300E-02  +1.84906100E-02  -5.59784000E-03  -6.76537000E-03
   -1.75739500E-02  +1.16028000E-02  +1.56097700E-02  -2.04720400E-02  -1.01635040E-01
   +6.67537700E-02  -1.92570660E-01  +4.34098020E-01  -1.80868700E-02  +5.02340600E-02
   -1.08945280E-01  -2.34667600E-02  +1.31260000E-04  +2.70555000E-02  +2.46004600E-02
   -6.36266000E-03  -1.14243600E-02  -3.46814000E-03  +4.33371300E-02  -3.82892900E-02
   +1.39817330E-01  +2.29651800E-02  -2.10484150E-01  -1.52659700E-01  -2.34073670E-01
   +5.30870560E-01  -1.43554000E-03  +8.27027000E-03  -7.64714000E-03  -1.36887170E-01
   +4.27982100E-02  +7.05322000E-03  -1.84942900E-02  +1.23451500E-02  +4.28197000E-03
   +1.21311000E-03  +4.78650000E-04  +3.43585000E-03  -1.54447000E-03  +3.85430000E-04
   +2.55950000E-04  +2.31414000E-03  -1.62440000E-04  +1.59846000E-03  +4.69681350E-01
   +1.80377500E-02  -1.23171000E-02  +2.35420000E-03  +4.56983500E-02  -1.04322810E-01
   +6.38065000E-03  +1.31984000E-03  +4.85934000E-03  -2.85818000E-03  -5.68930000E-04
   +3.99976000E-03  +3.11291000E-03  +9.14280000E-04  -1.45956000E-03  +2.81180000E-04
   +2.61710000E-04  +6.34930000E-04  +3.13273000E-03  -2.05661000E-03  +4.74718490E-01
   -1.89268700E-02  +1.11138900E-02  +5.61440000E-03  +3.46393000E-03  +9.26883000E-03
   -8.24447200E-02  +1.63958700E-02  -1.17072500E-02  +3.15030000E-03  +4.79089000E-03
   +1.57786000E-03  -1.40130000E-04  -6.11700000E-04  +1.17561000E-03  -1.44737000E-03
   +5.99240000E-04  +4.37260000E-03  -2.14566000E-03  -1.14435000E-03  +6.51390000E-03
   +4.76415990E-01  -7.63600000E-04  +2.09120000E-04  +8.47860000E-04  -3.30089000E-03
   +1.76109500E-02  +2.27905700E-02  -1.23110000E-03  +1.62205000E-03  -5.53050000E-04
   -1.64514000E-03  +7.02100000E-05  -9.27670000E-04  +7.65930000E-04  -8.04060000E-04
   +4.51590000E-04  -1.41380000E-04  -7.67870000E-04  +1.44900000E-05  -7.58843100E-02
   -3.66730000E-04  +4.61390000E-04  +5.82668620E-01  +5.49410000E-04  -3.26710000E-04
   -1.12339000E-03  +6.98165000E-03  -1.70934600E-02  -1.74146800E-02  -8.72950000E-04
   -8.90620000E-04  +7.58400000E-04  +7.99700000E-04  -7.26500000E-05  +6.97750000E-04
   -2.87600000E-04  +4.32760000E-04  -2.50940000E-04  +1.92180000E-04  +7.95430000E-04
   -1.28390000E-04  -3.74170000E-03  -1.08392450E-01  -4.81819000E-02  -3.90280000E-03
   +5.39868590E-01  -2.66414000E-03  +1.43586000E-03  +2.00398000E-03  +6.89703000E-03
   -6.71172000E-03  -1.94128000E-03  -6.81860000E-04  -7.96300000E-05  -7.94200000E-05
   -3.91580000E-04  +5.84600000E-04  -2.32640000E-04  +1.59520000E-04  -5.41720000E-04
   +5.79790000E-04  +8.62540000E-04  -1.66520000E-04  -3.83640000E-04  -4.44363000E-03
   -4.33459800E-02  -1.39389280E-01  -6.80833000E-03  -6.92855000E-02  +5.19160100E-01
   +3.62394000E-03  -1.68520000E-04  +3.58583000E-03  -2.97565000E-03  +1.77076000E-03
   -5.07880000E-04  +2.01398000E-03  -2.09652000E-03  +3.37655000E-03  -1.04314500E-02
   +2.14651200E-02  -1.33845000E-02  -2.44530670E-01  +1.00713140E-01  +5.16711600E-02
   -3.69916200E-02  +2.83843900E-02  +6.11597000E-03  +1.52117000E-03  -8.32780000E-04
   +7.67780000E-04  -1.22491000E-03  +5.08400000E-04  -5.75300000E-04  +3.25719570E-01
   +3.74589000E-03  -5.12460000E-04  +6.41030000E-03  +2.33833000E-03  +5.60120000E-04
   -3.82364000E-03  -4.37038000E-03  +2.38746000E-03  +4.67792000E-03  +3.63184800E-02
   -2.81651200E-02  +8.75225000E-03  +1.36152080E-01  -1.37607340E-01  -3.75220000E-04
   +6.48537000E-03  +5.79021000E-03  +5.88870000E-04  -9.80460000E-04  +7.80080000E-04
   -7.06250000E-04  +8.77420000E-04  -4.10670000E-04  +4.12990000E-04  -1.77772800E-01
   +3.80766240E-01  -1.39376000E-03  +9.91735000E-03  -3.59167000E-03  -1.14386000E-03
   -3.41251000E-03  +4.20745000E-03  +6.17465000E-03  +2.67237000E-03  -5.46090000E-03
   -3.14814200E-02  +2.14024200E-02  +5.47031000E-03  +8.11023000E-03  +3.03686100E-02
   -8.60964000E-02  +3.34040100E-02  -1.84768700E-02  +4.49149000E-03  -7.45000000E-05
   -4.85000000E-05  +2.60520000E-04  -9.67000000E-05  +3.66200000E-05  -1.07970000E-04
   -4.18654200E-02  -2.82789000E-01  +4.08181950E-01  +7.73600000E-05  -8.54400000E-05
   -3.47390000E-04  -3.43594100E-02  -1.04424400E-02  +3.49887000E-03  -1.12862000E-03
   +5.30530000E-04  -1.60912000E-03  -7.65200000E-05  +1.00128000E-03  +5.01570000E-04
   +9.51000000E-05  -2.27230000E-04  +2.93900000E-04  +3.05430000E-04  -3.90700000E-04
   +7.78870000E-04  -1.39016790E-01  -4.54661100E-02  +3.33210000E-03  -1.06996000E-03
   -5.28256000E-03  -4.49978000E-03  -1.15690000E-04  +1.01630000E-04  -4.75400000E-05
   +5.65229790E-01  +3.03221000E-03  +1.46300000E-04  -1.35454000E-03  +8.65404000E-03
   +1.26450000E-02  -7.49050000E-04  +1.37088000E-03  -1.91342000E-03  +1.49240000E-04
   +9.41920000E-04  -1.39867000E-03  -2.25580000E-04  -7.17670000E-04  +1.21065000E-03
   -6.15210000E-04  -6.24230000E-04  -5.86000000E-05  +2.13230000E-04  -4.21713700E-02
   -1.09744470E-01  -1.13595900E-02  -1.68726300E-02  -1.49737400E-02  -1.99943000E-03
   +1.07214000E-03  -9.15310000E-04  +6.94100000E-05  +1.00004300E-01  +4.63796960E-01
   -4.28440000E-04  +5.11840000E-04  -5.05390000E-04  +3.15214000E-03  +1.51419000E-03
   -3.10410000E-04  +3.90500000E-04  -5.46640000E-04  -7.58300000E-05  +2.16380000E-04
   -3.59670000E-04  -1.09110000E-04  -5.64200000E-05  +2.03150000E-04  -2.12180000E-04
   -5.18200000E-05  -4.86000000E-06  +2.36880000E-04  +5.56396000E-03  -9.32276000E-03
   -8.05161300E-02  -2.31834700E-02  -1.73649300E-02  +2.30100000E-05  -5.89000000E-06
   -4.13700000E-05  +2.14400000E-05  -1.44459440E-01  +1.96874700E-01  +4.63270780E-01
   -6.02240000E-04  -2.83130000E-04  -6.73880000E-04  -7.60000000E-04  -2.47315000E-03
   -1.67544000E-03  +4.82290000E-04  -5.28110000E-04  -5.85720000E-04  -1.54570000E-04
   +4.82010000E-04  +7.99000000E-06  +1.63300000E-05  -1.33230000E-04  +1.76310000E-04
   +3.17820000E-04  -8.06800000E-05  +2.81600000E-05  -1.73347000E-03  -2.11421800E-02
   -1.90575800E-02  -4.85813000E-03  -3.05236000E-03  +1.11315000E-03  -1.94110000E-04
   +1.44980000E-04  -5.06000000E-06  -1.20556840E-01  +3.06755000E-03  +3.33362400E-02
   +6.44278090E-01  -1.07196000E-03  -7.23510000E-04  +1.37407000E-03  +1.82330000E-04
   -3.84830000E-04  -1.01985000E-03  +1.19500000E-04  +1.51100000E-05  -3.07020000E-04
   +1.21020000E-04  -1.08520000E-04  -1.64820000E-04  +1.22730000E-04  -5.89700000E-05
   -1.44300000E-05  +6.19600000E-05  +1.13600000E-04  -1.10560000E-04  -7.68240000E-03
   -1.57296300E-02  -1.15320700E-02  -2.29625000E-03  -4.55060000E-04  +7.09910000E-04
   -1.11690000E-04  +9.56100000E-05  -3.27400000E-05  -4.53388900E-02  -2.08843710E-01
   -1.05537720E-01  +1.37974110E-01  +4.69226400E-01  -9.67380000E-04  -8.68720000E-04
   +7.35550000E-04  -6.54700000E-04  -8.64880000E-04  -2.33090000E-04  +3.51050000E-04
   -1.11710000E-04  -6.48750000E-04  +5.90600000E-05  -1.15610000E-04  -1.84560000E-04
   +2.60690000E-04  -6.76200000E-05  +8.66500000E-05  +1.70860000E-04  -1.54880000E-04
   -4.51300000E-05  -5.67969000E-03  -1.99090000E-03  +3.29245000E-03  +9.63970000E-04
   +3.72250000E-04  -2.70800000E-05  -1.69370000E-04  +7.92000000E-05  -4.70500000E-05
   -1.25332100E-02  -1.33486970E-01  -1.90203610E-01  -1.71095830E-01  +2.25322030E-01
   +4.59665350E-01  +2.26290000E-04  -8.06400000E-05  +8.58600000E-05  +1.52910000E-04
   -4.68000000E-05  -3.33970000E-04  -2.80040000E-04  +2.56440000E-04  +6.51000000E-05
   +7.46800000E-05  -1.50800000E-04  +6.71800000E-05  +2.66740000E-04  -3.39600000E-05
   -1.90680000E-04  -3.14030000E-04  +1.70580000E-04  +1.57150000E-04  +3.65982000E-03
   +4.06590000E-04  +1.70141000E-03  +4.01540000E-04  +3.31480000E-04  +4.54970000E-04
   -2.19970000E-04  +1.38160000E-04  +1.42400000E-05  +2.84509000E-02  -5.16246500E-02
   -6.18405700E-02  -2.64327110E-01  -1.01009710E-01  +2.93391800E-02  +6.00779080E-01
   -6.43000000E-06  +1.68550000E-04  +6.68000000E-06  +6.88290000E-04  -5.68500000E-05
   +2.82180000E-04  -2.66380000E-04  +2.75990000E-04  +3.36430000E-04  -3.00900000E-05
   -5.70900000E-05  +6.99200000E-05  -1.75790000E-04  +8.91500000E-05  -5.17800000E-05
   -8.26400000E-05  +9.79100000E-05  -3.98700000E-05  +5.83980000E-04  +6.38480000E-04
   -5.71456000E-03  -1.16088000E-03  -5.80030000E-04  +2.64300000E-04  +1.79050000E-04
   -1.00910000E-04  +1.64700000E-05  -1.40734400E-02  -2.96676300E-02  -2.67569000E-02
   -1.48001210E-01  -1.78623420E-01  -2.39902000E-02  +1.54616640E-01  +5.01234170E-01
   -1.03230000E-04  +1.90060000E-04  -3.60380000E-04  +6.97640000E-04  +2.56660000E-04
   +1.38320000E-04  +8.77700000E-05  -7.49900000E-05  +9.82800000E-05  -4.99200000E-05
   +4.60200000E-05  +2.56900000E-05  -2.49850000E-04  +1.09270000E-04  +3.96300000E-05
   +1.41960000E-04  -7.13200000E-05  -3.24400000E-05  +1.79082000E-03  -4.41762000E-03
   -8.22960000E-04  -6.91580000E-04  -5.93280000E-04  +1.15060000E-04  +2.13760000E-04
   -1.65610000E-04  +2.21000000E-06  -2.59894500E-02  -4.15393000E-03  +1.98217600E-02
   -1.55611800E-02  -5.25502700E-02  -9.94219800E-02  -1.43116230E-01  +2.63393780E-01
   +4.62278920E-01  -6.72780000E-04  -2.66190000E-04  +4.50070000E-04  -1.94300000E-04
   +5.24230000E-04  -2.27400000E-05  +4.14300000E-05  -1.58920000E-04  +3.82800000E-05
   +3.11830000E-04  -2.69830000E-04  +5.56100000E-05  -7.34180000E-04  +5.57620000E-04
   -5.01500000E-05  +2.81870000E-04  -4.20300000E-05  -1.32080000E-04  -2.22244000E-03
   -2.48980000E-04  +2.59100000E-05  +3.67740000E-04  -2.04760000E-04  -2.92350000E-04
   +7.92680000E-04  -5.63030000E-04  +1.14000000E-06  -1.32907500E-02  +2.34715500E-02
   +2.69845900E-02  -5.16188100E-02  -3.30345200E-02  +1.35522000E-03  -2.25710520E-01
   +4.04182100E-02  +1.34341460E-01  +6.13666840E-01  +5.23000000E-06  -5.54000000E-05
   +6.80800000E-05  +1.59920000E-04  +7.49590000E-04  -2.05310000E-04  -2.64920000E-04
   +1.41840000E-04  +2.33750000E-04  +3.70530000E-04  -5.24350000E-04  +1.87590000E-04
   -5.32400000E-04  +6.27270000E-04  -3.26510000E-04  -1.29580000E-04  +8.85700000E-05
   +4.65600000E-05  +1.62600000E-04  -7.35320000E-04  -9.81230000E-04  +2.72760000E-04
   +8.62700000E-05  +2.09000000E-05  +7.02020000E-04  -5.47300000E-04  +2.81000000E-05
   +2.26352000E-02  -2.59019900E-02  -3.25080400E-02  +7.30122000E-03  +4.14986100E-02
   +3.29029800E-02  -1.69192700E-02  -1.17174270E-01  -3.56317100E-02  +1.39547970E-01
   +5.04280640E-01  +1.49400000E-04  +5.87500000E-05  +8.07800000E-05  +2.90160000E-04
   +3.52990000E-04  -2.44250000E-04  -3.98080000E-04  +2.03090000E-04  +2.32400000E-04
   +2.20700000E-04  -3.26680000E-04  +1.42080000E-04  -9.18600000E-05  +2.77900000E-04
   -2.93500000E-04  -2.64470000E-04  +1.33670000E-04  +8.25500000E-05  +9.57560000E-04
   -2.38250000E-04  -1.39290000E-03  +1.00990000E-04  -1.23600000E-05  +3.01070000E-04
   +2.14370000E-04  -1.84920000E-04  +2.00000000E-05  +2.67206200E-02  -3.33792600E-02
   -5.32767700E-02  +3.99099800E-02  +5.72051000E-02  +3.28860300E-02  +8.00237500E-02
   -7.07131000E-02  -1.84737480E-01  -1.43845360E-01  +2.41271940E-01  +4.80403920E-01
   -4.82700000E-04  -2.11550000E-04  +6.77890000E-04  -3.65590000E-04  -4.45590000E-04
   +6.89300000E-05  +2.24360000E-04  -1.08220000E-04  -2.17630000E-04  -1.48870000E-04
   +2.69540000E-04  -1.48190000E-04  +1.40990000E-04  -2.67790000E-04  +2.56130000E-04
   +2.75380000E-04  -1.64200000E-04  -2.00930000E-04  +3.49320000E-04  +7.94030000E-04
   +4.00465000E-03  +2.11290000E-04  +5.43380000E-04  +1.22800000E-04  -2.24480000E-04
   +1.92350000E-04  -3.19800000E-05  -4.78215500E-02  +4.74007000E-03  +3.75972000E-02
   -1.87241000E-02  -2.70434100E-02  -1.62896000E-02  +3.48023000E-02  +2.40862000E-02
   +6.88153000E-03  -1.20328520E-01  +1.85569200E-02  +4.83060300E-02  +6.50403510E-01
   -4.32000000E-04  -2.65040000E-04  +4.48530000E-04  -5.93710000E-04  -6.64680000E-04
   +2.23290000E-04  +2.66940000E-04  -1.79120000E-04  -3.10650000E-04  -2.47360000E-04
   +4.52710000E-04  -1.82460000E-04  +2.28070000E-04  -4.41060000E-04  +3.28560000E-04
   +3.59960000E-04  -1.01000000E-04  -1.17890000E-04  -2.39830000E-04  +2.66506000E-03
   -2.74158000E-03  -5.04750000E-04  -5.54900000E-04  -9.45400000E-05  -4.00130000E-04
   +3.35390000E-04  -4.19000000E-05  -3.14944400E-02  +3.87247700E-02  +4.85228500E-02
   -2.59326000E-02  -4.59046400E-02  -2.53339600E-02  +5.75813200E-02  +1.26390100E-02
   -3.12754900E-02  -3.55696600E-02  -2.06717260E-01  -1.07660080E-01  +1.46359570E-01
   +4.70834550E-01  +3.57290000E-04  +1.39980000E-04  -5.06760000E-04  +8.40890000E-04
   +6.32110000E-04  -4.59000000E-05  +3.26610000E-04  -2.04810000E-04  -2.35800000E-05
   -1.04660000E-04  +6.85700000E-05  -9.65900000E-05  +8.02700000E-05  -1.22440000E-04
   +1.07780000E-04  +8.22000000E-06  -4.61500000E-05  -9.80000000E-06  +4.03705000E-03
   -4.13516000E-03  +1.12713000E-03  -6.75740000E-04  -6.55710000E-04  -1.96800000E-04
   -1.27710000E-04  +9.86400000E-05  +4.38000000E-06  +3.57449000E-03  +2.72527300E-02
   +3.01259600E-02  -1.51899300E-02  -2.43367900E-02  -1.71527000E-02  +3.87331100E-02
   -1.08316500E-02  -2.54991500E-02  -3.34992000E-03  -1.41254130E-01  -2.03928510E-01
   -1.80303480E-01  +2.37431870E-01  +4.68096640E-01  -4.84490000E-04  +1.24700000E-05
   +4.27740000E-04  -1.09157000E-03  -1.72266000E-03  +1.78320000E-04  -7.05720000E-04
   +6.24090000E-04  +1.08840000E-04  +2.14600000E-05  -1.63100000E-05  +2.50520000E-04
   +5.95600000E-05  +6.60700000E-05  -2.45250000E-04  -2.83790000E-04  +2.27240000E-04
   +1.45470000E-04  -1.97400100E-02  -3.83900000E-04  +1.24925200E-02  -1.66514000E-03
   -5.17270000E-04  +1.24462000E-03  -4.23000000E-06  +1.21400000E-05  +3.02900000E-05
   -2.39113030E-01  -2.01176100E-02  +8.66995200E-02  +3.57260100E-02  +6.29269700E-02
   +4.36552600E-02  -6.42975500E-02  -1.70843100E-02  +2.08166100E-02  +3.24679100E-02
   -5.43799300E-02  -7.07183800E-02  -2.65422900E-01  -9.85442800E-02  +3.16097400E-02
   +5.94219090E-01  -3.42340000E-04  +5.00000000E-08  +8.56340000E-04  -1.32282000E-03
   -2.08482000E-03  +3.47820000E-04  -5.48260000E-04  +5.37190000E-04  -2.64400000E-05
   -1.36800000E-04  +1.95320000E-04  +1.35200000E-04  +1.67020000E-04  -1.42340000E-04
   -8.50000000E-07  -7.48300000E-05  +5.92800000E-05  -1.19370000E-04  -1.42160700E-02
   +6.49920000E-03  +1.15850800E-02  -1.13739000E-03  -5.74270000E-04  +7.07510000E-04
   -1.71580000E-04  +1.50240000E-04  -1.21000000E-06  +2.75299000E-02  -1.10406110E-01
   -5.78530100E-02  +2.62767800E-02  +1.13272300E-02  -1.29277000E-02  -1.51790800E-02
   -7.63434000E-03  +5.40730000E-03  -1.38786200E-02  -3.29941700E-02  -2.50967200E-02
   -1.45693150E-01  -1.77273340E-01  -2.25256100E-02  +1.44482740E-01  +5.02109540E-01
   +1.19200000E-05  +1.82100000E-04  -5.34540000E-04  -1.88619000E-03  -1.31476000E-03
   +2.96740000E-04  +2.99700000E-05  -1.51600000E-05  +2.60000000E-07  -2.51780000E-04
   +4.66220000E-04  -7.73000000E-06  +1.67110000E-04  -3.33240000E-04  +2.51210000E-04
   +1.99430000E-04  -5.19600000E-05  +6.98200000E-05  +6.16400000E-04  +3.53025000E-03
   +4.86047000E-03  -7.82710000E-04  +7.56140000E-04  +1.85190000E-04  -3.31470000E-04
   +2.65930000E-04  -1.28700000E-05  +1.32380880E-01  -2.93470700E-02  -1.75882800E-01
   +9.27927000E-03  -3.57939400E-02  -3.12680000E-02  +2.25042700E-02  +6.93656000E-03
   -1.06573800E-02  -3.18702700E-02  -2.23320000E-04  +2.16152300E-02  -1.40099400E-02
   -5.23798900E-02  -1.01871040E-01  -1.37579660E-01  +2.59128610E-01  +4.80136080E-01
   +3.50150000E-04  +4.85600000E-05  -5.09600000E-05  +1.84600000E-05  -9.82750000E-04
   -4.54000000E-06  +1.48100000E-04  +3.58900000E-05  -2.71610000E-04  -4.40070000E-04
   +5.34240000E-04  -1.76840000E-04  +9.07050000E-04  -8.16510000E-04  +2.41860000E-04
   -1.06610000E-04  +2.76200000E-05  +7.22500000E-05  +1.53011000E-03  +5.32240000E-04
   +7.21480000E-04  -5.84940000E-04  +4.06200000E-05  +2.97050000E-04  -1.06639000E-03
   +7.87080000E-04  -2.44700000E-05  -1.46404000E-03  -2.66746000E-03  -2.71405000E-03
   +2.50910000E-03  +3.26636000E-03  +6.10104000E-03  -4.34030000E-02  -3.30120300E-02
   +1.01915000E-03  -2.38488030E-01  -9.24157400E-02  +3.22727100E-02  -3.63392000E-03
   -1.47683200E-02  -7.29656000E-03  -6.39090000E-04  +8.57910000E-04  +4.07987000E-03
   +3.29729810E-01  +1.46170000E-04  +1.22400000E-05  -1.81100000E-05  -1.28300000E-05
   -8.07110000E-04  -3.20100000E-05  +1.36800000E-04  -1.16800000E-05  -2.24200000E-04
   -3.50580000E-04  +4.70680000E-04  -1.55160000E-04  +6.63710000E-04  -6.50510000E-04
   +2.32210000E-04  -2.31300000E-05  +3.12800000E-05  +5.40100000E-05  +1.11733000E-03
   +1.34620000E-04  +1.21677000E-03  -4.21050000E-04  -7.08000000E-06  +1.90050000E-04
   -8.16720000E-04  +6.27060000E-04  -1.97500000E-05  -3.04183000E-03  +7.67230000E-04
   +3.53401000E-03  -2.46871000E-03  -4.35320000E-04  -5.90553000E-03  -5.59005000E-03
   +4.56113000E-03  -1.21054000E-03  -1.27004500E-01  -1.44474740E-01  -1.86227000E-02
   -4.14408900E-02  -2.93652200E-02  -9.60433000E-03  +5.29662000E-03  +2.61086000E-03
   -5.85225000E-03  +1.26745630E-01  +4.20360890E-01  +1.42230000E-04  +8.20900000E-05
   -1.76170000E-04  +1.86000000E-06  -1.48680000E-04  +1.31730000E-04  +3.28600000E-05
   +2.07100000E-05  +5.30000000E-06  -8.40800000E-05  +7.98100000E-05  +2.86000000E-06
   +6.55800000E-05  -8.70300000E-05  +3.07000000E-05  -6.99000000E-06  -1.92000000E-06
   +4.56000000E-06  -1.73990000E-04  +4.09930000E-04  +8.11100000E-05  -5.21600000E-05
   -3.13400000E-05  -1.95300000E-05  -8.74800000E-05  +6.70600000E-05  +5.57000000E-06
   -2.88066000E-03  +3.48367000E-03  +3.69463000E-03  +7.11060000E-04  -9.26949000E-03
   -1.97552000E-03  +2.68209500E-02  +1.55592100E-02  +7.75860000E-03  -1.34778000E-03
   -4.04916600E-02  -8.12671000E-02  -3.27978200E-02  -2.60251000E-02  +2.79677000E-03
   +8.49156000E-03  -2.99525000E-03  -3.02931000E-03  -6.60958500E-02  +3.02937100E-01
   +3.61714000E-01  -5.29845000E-03  +2.12396000E-03  +2.21723000E-03  -4.29443000E-03
   +1.91326600E-02  -2.35925200E-02  -2.28217000E-03  +1.47125000E-03  -8.09170000E-04
   +5.03600000E-05  +4.94820000E-04  -8.95620000E-04  +2.74190000E-04  -2.81980000E-04
   +2.14810000E-04  +3.92830000E-04  +9.36970000E-04  -1.20795000E-03  -7.45294800E-02
   +1.54828000E-03  -1.39133000E-03  +5.53810000E-04  +2.65180000E-04  -1.70367000E-03
   -5.39950000E-04  +4.09410000E-04  -2.86500000E-05  -2.62614000E-03  -1.85047800E-02
   +2.22172400E-02  -5.95360000E-04  -9.28000000E-04  +9.04430000E-04  -2.56250000E-04
   +7.42290000E-04  +6.56700000E-05  +5.93470000E-04  +7.06560000E-04  +4.20640000E-04
   -1.13319000E-03  +1.39790000E-04  -1.30631000E-03  -6.06840000E-04  -1.67652000E-03
   -6.65050000E-04  -1.24644000E-03  -1.00797000E-03  -1.62280000E-04  +5.86475630E-01
   +2.60139000E-03  -2.19580000E-04  -1.00131000E-03  +6.81803000E-03  -1.50857600E-02
   +1.64172200E-02  +5.78480000E-04  -1.38034000E-03  -1.21510000E-04  -7.22390000E-04
   -1.17260000E-04  +5.18220000E-04  +1.66740000E-04  +3.11600000E-05  +9.98300000E-05
   -1.50020000E-04  -4.82470000E-04  +7.09710000E-04  +6.37641000E-03  -1.08366150E-01
   +4.77267700E-02  -4.10110000E-04  +1.05921300E-02  -1.43090700E-02  -4.77300000E-05
   -3.04400000E-05  +3.65000000E-06  -8.72266000E-03  -2.01464700E-02  +1.84362100E-02
   -4.86800000E-04  -3.90370000E-04  +1.22547000E-03  -6.02500000E-05  +7.97530000E-04
   -8.48400000E-05  +1.57270000E-04  +5.49640000E-04  +4.64420000E-04  -6.19380000E-04
   -1.60810000E-04  -9.90050000E-04  +1.45608000E-03  -9.88470000E-04  -6.04090000E-04
   -5.46560000E-04  -5.01640000E-04  -1.10580000E-04  +6.33379000E-03  +5.37308490E-01
   +1.70294000E-03  -7.90250000E-04  -4.66230000E-04  -4.57097000E-03  +1.83445000E-03
   +6.70920000E-04  +7.73770000E-04  -8.05790000E-04  -1.47970000E-04  +4.56790000E-04
   -3.15530000E-04  -1.10480000E-04  -1.79750000E-04  +1.32270000E-04  +1.36450000E-04
   +1.39060000E-04  -8.84700000E-05  +1.78910000E-04  -6.23372000E-03  +4.42552700E-02
   -1.36427980E-01  -1.60861000E-03  +1.42258100E-02  -3.82854800E-02  +3.28130000E-04
   -2.36080000E-04  -4.09600000E-05  +7.68279000E-03  +7.87673000E-03  -2.17981000E-03
   -1.59856000E-03  -1.25665000E-03  -3.97100000E-04  +1.94640000E-04  -3.08800000E-05
   -1.43460000E-04  +1.84770000E-04  +2.14100000E-04  +2.86970000E-04  -2.37900000E-05
   -2.42990000E-04  -1.24470000E-04  -9.23170000E-04  -1.41130000E-04  -1.09760000E-04
   -5.40780000E-04  -4.23310000E-04  -1.19930000E-04  -1.06333700E-02  +6.48452400E-02
   +5.13261130E-01  -1.88719300E-01  +2.40617100E-02  +1.02707900E-01  +6.99961000E-03
   -5.11506000E-03  +6.22614000E-03  -1.08298000E-03  +4.16702000E-03  -1.21815000E-03
   -1.54055000E-03  -3.01449000E-03  +4.17860000E-03  +2.29073000E-03  +7.13746000E-03
   -4.31895000E-03  -3.85014600E-02  -5.62480000E-04  +4.30526400E-02  -2.61684000E-03
   -1.49600000E-04  -1.28630000E-03  +1.42703000E-03  +7.59300000E-05  +1.24294000E-03
   -2.46305000E-03  +2.02580000E-04  +1.81078000E-03  -2.47724000E-03  -3.87990000E-04
   -2.76468000E-03  -2.12150000E-04  +1.85241000E-03  +6.03380000E-04  -2.11870000E-04
   -2.36400000E-05  +1.17930000E-04  +8.69920000E-04  -4.42800000E-05  -1.64390000E-04
   +8.44380000E-04  +7.16100000E-04  -2.31700000E-04  -4.47560000E-04  +7.55990000E-04
   -1.37465000E-03  -4.23680000E-04  -2.06600000E-04  -1.49720000E-04  +5.47060000E-04
   -1.01610000E-04  -2.05790000E-04  +2.91133640E-01  -7.45877000E-03  -8.51630000E-02
   +5.22285300E-02  -2.41791000E-02  -1.01308000E-03  +3.16014200E-02  +7.02952000E-03
   -2.87722000E-03  +2.49750000E-03  -3.06849000E-03  +2.80911000E-03  -2.10620000E-03
   +3.08468000E-03  -1.85909000E-03  +8.26449000E-03  +2.00715200E-02  +9.50684000E-03
   -1.65204400E-02  -2.70670000E-03  -2.24410000E-04  -2.28988000E-03  +1.62726000E-03
   -2.49502000E-03  -1.76701000E-03  +6.84930000E-04  +4.91200000E-04  -1.30319000E-03
   -6.39600000E-05  -2.57080000E-04  +7.05940000E-04  -4.01490000E-04  -1.41510000E-04
   +1.31580000E-04  +5.05460000E-04  +3.81520000E-04  -2.68820000E-04  -1.06420000E-04
   +1.74480000E-04  +2.61650000E-04  -2.16500000E-05  -7.09900000E-05  -7.17200000E-05
   +6.44220000E-04  -1.25570000E-04  +1.26320000E-04  +1.92780000E-04  +1.75270000E-04
   -4.19400000E-05  -1.25330000E-04  +3.87090000E-04  -5.15500000E-05  -1.27929380E-01
   +4.17327560E-01  +1.33072470E-01  +2.32309700E-02  -1.88320290E-01  +2.87297200E-02
   +1.57061700E-02  -3.67840000E-02  -4.37922000E-03  +4.25789000E-03  +2.39664000E-03
   +4.56837000E-03  -2.12207000E-03  -2.26549000E-03  +3.96150000E-04  +5.27551000E-03
   +7.32550000E-04  +1.77547600E-02  +5.01520000E-04  -6.84007000E-03  +2.81258000E-03
   -4.47263000E-03  +5.79950000E-04  -4.91240000E-04  +9.81780000E-04  -1.24422000E-03
   +1.06350000E-03  -8.35140000E-04  +1.17000000E-06  -1.77008000E-03  +2.03076000E-03
   -1.19740000E-03  -4.60700000E-05  +2.07670000E-04  -6.06800000E-04  -1.76460000E-04
   +1.05640000E-04  +5.12140000E-04  +1.82400000E-04  +1.89900000E-05  -1.53900000E-04
   -2.89030000E-04  -4.03040000E-04  +3.64310000E-04  -2.77630000E-04  -3.19710000E-04
   -5.76320000E-04  -4.84580000E-04  -3.46160000E-04  +9.17300000E-05  -2.94320000E-04
   -3.09000000E-06  +5.41130000E-04  -9.78301300E-02  -2.90714690E-01  +4.16688150E-01
   -7.64300000E-05  -1.28800000E-05  +4.43300000E-05  +5.70000000E-07  +4.30500000E-05
   -1.16100000E-05  -2.74600000E-05  +7.82000000E-06  +4.03400000E-05  +4.13800000E-05
   -3.33100000E-05  +1.95900000E-05  -1.31600000E-04  +8.59200000E-05  -8.83000000E-06
   +4.07600000E-05  +1.78600000E-05  -1.25200000E-05  -1.68770000E-04  +3.82700000E-05
   +1.01010000E-04  +7.05000000E-05  +2.14800000E-05  -2.46900000E-05  +1.34750000E-04
   -8.36000000E-05  +4.24000000E-06  -1.49920000E-04  +4.57730000E-04  +5.85540000E-04
   -6.52390000E-04  -2.16710000E-04  -2.09570000E-04  +1.56235000E-03  -8.86150000E-04
   -2.30173000E-03  -9.48720000E-04  -3.09358700E-02  -3.10595300E-02  -5.28577000E-03
   -3.55723000E-03  +1.10264000E-03  +1.50799000E-03  -8.45460000E-04  -7.07880000E-04
   -4.44749800E-02  +4.56742800E-02  +7.00070300E-02  +2.98700000E-05  -1.02300000E-05
   -1.39300000E-05  +9.93500000E-05  +4.00100000E-05  -8.90000000E-07  +4.96625000E-02
   -2.40000000E-05  +1.37100000E-05  -2.19100000E-05  +1.00600000E-05  +1.22420000E-04
   +1.58700000E-05  -2.38400000E-05  +3.68000000E-06  +4.36300000E-05  +5.79700000E-05
   -8.15600000E-05  +3.62700000E-05  -1.39910000E-04  +1.31920000E-04  -4.42100000E-05
   +8.70000000E-06  -1.29500000E-05  -1.24200000E-05  -1.91120000E-04  -5.35400000E-05
   -3.73900000E-05  +7.40900000E-05  -8.74000000E-06  -2.22200000E-05  +1.63710000E-04
   -1.32140000E-04  +3.01000000E-06  -5.05600000E-05  +5.02070000E-04  +4.36250000E-04
   +7.93800000E-05  -9.86350000E-04  -3.28660000E-04  +3.62396000E-03  +3.23938000E-03
   +1.68443000E-03  +1.61959000E-03  -2.36551900E-02  -2.12957300E-02  -4.70827000E-03
   -3.75500000E-05  +9.02490000E-04  +4.92400000E-04  +1.45010000E-04  -1.77479000E-03
   +1.05757400E-02  -2.52938630E-01  -2.49034670E-01  +9.65800000E-05  +3.73500000E-05
   +3.89700000E-05  +3.16300000E-05  -4.19700000E-05  +6.93500000E-05  -1.08401200E-02
   +2.73599900E-01  -9.50300000E-05  -3.81700000E-05  +1.07390000E-04  -1.14400000E-05
   +5.99300000E-05  -2.17200000E-05  -1.91300000E-05  -1.82000000E-06  +7.81000000E-06
   +3.27400000E-05  -2.75600000E-05  -9.10000000E-06  -4.82000000E-05  +3.60500000E-05
   +3.17000000E-06  +2.31800000E-05  -1.72000000E-06  -1.22900000E-05  -1.12880000E-04
   -2.34500000E-05  -1.52140000E-04  +2.62100000E-05  -2.27000000E-06  -1.50600000E-05
   +5.24400000E-05  -3.33400000E-05  -4.76000000E-06  +9.00600000E-05  +1.08760000E-04
   +2.04210000E-04  +6.06700000E-05  -2.03220000E-04  -8.75570000E-04  +2.04307000E-03
   +4.47899000E-03  +2.16991000E-03  +6.51730000E-04  -8.04760000E-04  -3.81029000E-03
   +3.71400000E-05  +1.97190000E-04  +2.16429000E-03  +6.25350000E-04  -9.25290000E-04
   +4.62510000E-04  +3.57873300E-02  -2.71153610E-01  -2.89170840E-01  +1.19290000E-04
   +7.21900000E-05  +5.40400000E-05  +1.15120000E-04  +4.12100000E-05  -4.71900000E-05
   -3.90625400E-02  +2.68541750E-01  +2.89352090E-01  -1.80400000E-05  -2.65900000E-05
   +2.77300000E-05  +1.13040000E-04  -3.98500000E-05  +7.67000000E-06  +1.82400000E-05
   -1.16000000E-06  -2.03200000E-05  -4.92900000E-05  +7.43700000E-05  -8.87000000E-06
   +3.65500000E-05  -6.86700000E-05  +3.10100000E-05  +1.36400000E-05  +3.68500000E-05
   -9.30000000E-07  +5.82160000E-04  -7.20830000E-04  -8.68330000E-04  -3.59140000E-04
   -1.35080000E-04  +1.08430000E-04  -6.76600000E-05  +7.02800000E-05  +5.38000000E-06
   -2.56345000E-03  -4.58517000E-03  +1.83194000E-03  +3.96445000E-03  -1.88626000E-02
   -1.89044900E-02  -5.59905300E-02  -1.00688300E-02  +4.52572000E-03  +4.45622000E-03
   +1.73720500E-02  +1.61819100E-02  -2.77922000E-03  -5.50490000E-04  +4.53445000E-03
   -1.61477000E-03  -3.18360000E-04  +1.34180000E-04  +2.02344000E-03  +2.48804000E-03
   -1.24663000E-03  -3.78000000E-06  +6.83600000E-05  -9.89100000E-05  +5.31000000E-06
   +5.96600000E-05  -1.87600000E-05  -8.60000000E-04  -1.06717000E-03  -1.73130000E-04
   +5.29209300E-02  +8.10000000E-05  +2.97100000E-05  -4.01200000E-05  +1.67450000E-04
   -1.12260000E-04  +2.54800000E-05  +7.98000000E-06  +2.01300000E-05  -1.59200000E-05
   -4.66200000E-05  +5.05800000E-05  +2.65000000E-06  +8.72000000E-05  -7.03900000E-05
   +3.29000000E-06  -2.18000000E-05  +1.09600000E-05  +1.43800000E-05  +3.03390000E-04
   -1.69010000E-04  -8.27870000E-04  -3.07580000E-04  -1.82110000E-04  +1.16790000E-04
   -1.03770000E-04  +7.48900000E-05  +3.29000000E-06  -4.89098000E-03  +2.33250000E-03
   -1.70551000E-03  +1.95695000E-03  -1.02189700E-02  -1.31085300E-02  -1.01925100E-02
   -1.95416080E-01  -1.48058300E-01  -4.84608000E-03  -2.32703000E-03  -3.06921000E-03
   -4.30500000E-05  +3.27566000E-03  -2.05536000E-03  -3.55400000E-05  -7.76500000E-05
   +8.01780000E-04  +1.99471000E-03  +6.82110000E-04  +3.16576000E-03  -6.06900000E-05
   -8.25000000E-06  -4.05200000E-05  -6.57300000E-05  -2.32800000E-05  -7.67000000E-06
   +9.94940000E-04  +1.62200000E-04  -9.90040000E-04  +1.36989300E-02  +2.03854930E-01
   -6.69100000E-05  -7.00600000E-05  +8.07900000E-05  -7.68000000E-05  -2.97000000E-05
   -7.50000000E-06  +3.48200000E-05  -1.95800000E-05  -5.21800000E-05  -3.93500000E-05
   +6.51100000E-05  -3.71000000E-05  +5.15500000E-05  -7.85000000E-05  +5.61100000E-05
   +2.52800000E-05  +2.33100000E-05  -2.66000000E-06  +3.96900000E-04  -1.59630000E-04
   +7.05300000E-05  -7.27800000E-05  +3.28900000E-05  +3.04800000E-05  -7.82100000E-05
   +7.56800000E-05  -3.09000000E-06  +1.28152000E-03  -2.25793000E-03  +4.49767000E-03
   +8.64070000E-04  -2.47410000E-04  +1.53227000E-03  +4.38949000E-03  -1.48083370E-01
   -1.75973690E-01  -4.83641000E-03  -1.65700200E-02  -8.76028000E-03  +4.97641000E-03
   -1.78772000E-03  +7.27230000E-04  +3.65950000E-04  +9.69330000E-04  -2.20950000E-04
   -1.78567000E-03  +2.85239000E-03  -1.43960000E-04  -4.57900000E-05  +3.65000000E-06
   -5.84300000E-05  +5.37700000E-05  +8.77400000E-05  -4.60900000E-05  +1.79457000E-03
   +2.40900000E-04  -2.76360000E-04  -5.26801000E-03  +1.63333110E-01  +1.81099650E-01
   -2.12200000E-04  -2.15760000E-04  -3.52590000E-04  -7.09940000E-04  -9.20590000E-04
   -8.25050000E-04  -4.01510000E-04  -2.04510000E-04  -1.36200000E-04  -4.68100000E-05
   +4.83600000E-05  +5.88700000E-05  -1.82020000E-04  +1.52870000E-04  +6.29900000E-05
   +1.73310000E-04  -2.48000000E-05  +3.67000000E-06  -9.29400000E-04  +3.49800000E-04
   -9.52570000E-04  -1.81500000E-05  +1.35270000E-04  -1.03550000E-04  +1.65050000E-04
   -1.39350000E-04  -1.16600000E-05  +4.21241000E-03  -3.23140000E-04  -4.01780000E-04
   -2.20130460E-01  +3.09069400E-02  +1.37534520E-01  -1.50889100E-02  +5.57547000E-03
   +1.66321600E-02  -6.56760000E-04  -5.02151000E-03  +2.50960000E-04  -7.41900000E-05
   -2.05150000E-04  -8.83250000E-04  +2.13851000E-03  -1.67287000E-03  +8.87070000E-04
   -1.44026000E-03  -4.35900000E-05  +7.84270000E-04  -7.68000000E-06  -2.74100000E-05
   +1.72720000E-04  -4.10200000E-05  +5.33400000E-05  +2.56440000E-04  +1.03640000E-04
   +2.14500000E-04  +1.34400000E-04  +8.35100000E-05  +1.13149000E-03  -1.52734000E-03
   +2.32712550E-01  +6.98800000E-05  +4.18570000E-04  -5.99360000E-04  -2.44580000E-04
   -7.25200000E-05  -9.15100000E-05  -2.51240000E-04  -6.32500000E-05  +1.72000000E-05
   -4.76800000E-05  +9.23000000E-06  +5.65200000E-05  -1.62640000E-04  +7.78900000E-05
   +5.61200000E-05  +1.27600000E-04  -1.91720000E-04  -4.20000000E-06  +1.49931000E-03
   -8.67160000E-04  +1.29299000E-03  +1.17400000E-04  +4.48100000E-05  +9.13200000E-05
   +1.89610000E-04  -1.67320000E-04  -7.80000000E-07  +1.88458000E-02  +1.92052000E-03
   -1.36613100E-02  +3.12508800E-02  -6.03486700E-02  -3.85353400E-02  -1.54323400E-02
   +6.55044000E-03  +1.19765200E-02  -4.72264000E-03  +1.03436000E-03  -3.56136000E-03
   -2.81760000E-04  -1.11417000E-03  +2.61230000E-04  -2.21953000E-03  -8.78630000E-04
   -5.75883000E-03  -9.74320000E-04  +4.91300000E-05  +6.30650000E-04  -1.75060000E-04
   -5.03110000E-04  -4.15830000E-04  -3.17330000E-04  -2.20430000E-04  +3.29810000E-04
   +6.99100000E-05  +1.05710000E-04  +1.01610000E-04  +1.56930000E-03  -1.19905000E-03
   +2.09968000E-03  -2.99316200E-02  +5.60408000E-02  +1.97930000E-04  +3.45350000E-04
   -5.71580000E-04  -5.64400000E-05  -3.02360000E-04  +1.86570000E-04  -4.67920000E-04
   +2.86890000E-04  +4.45620000E-04  +2.14300000E-05  -1.70590000E-04  +9.30300000E-05
   -3.10830000E-04  +1.52370000E-04  -4.77000000E-05  -4.28700000E-05  +1.55780000E-04
   -6.43000000E-05  +1.27660000E-04  +1.88027000E-03  -1.44598000E-03  -2.52600000E-04
   +1.18800000E-05  -1.88300000E-05  +3.56330000E-04  -2.27700000E-04  +1.56100000E-05
   +1.74481500E-02  -2.39365000E-03  -8.14769000E-03  +1.36914620E-01  -3.78093100E-02
   -1.55854130E-01  -2.76181000E-03  -7.48030000E-04  +4.60551000E-03  +6.15670000E-04
   -3.21390000E-03  +4.52402000E-03  -1.09858000E-03  +1.16180000E-04  -4.58170000E-04
   +8.44200000E-04  -6.16624000E-03  +3.02950000E-04  +6.05100000E-05  +9.62200000E-05
   +8.58800000E-05  -1.45400000E-05  +3.25800000E-05  -1.47300000E-05  -2.60080000E-04
   +6.96000000E-06  +2.92410000E-04  -3.53300000E-05  -7.41000000E-06  -2.95700000E-05
   -1.24870000E-03  +2.37311000E-03  -1.48584000E-03  -1.50889440E-01  +4.50649100E-02
   +1.58525100E-01  -1.00520000E-04  -3.74000000E-05  +2.40640000E-04  -1.44040000E-04
   -8.62200000E-05  -2.49840000E-04  -2.32500000E-05  -2.43500000E-05  -1.53600000E-05
   +8.12000000E-05  -4.62700000E-05  +1.28500000E-05  -6.65400000E-05  +7.82200000E-05
   -1.49200000E-05  +3.83600000E-05  -1.82900000E-05  -4.23800000E-05  +3.69340000E-04
   +1.38786000E-03  -1.13767000E-03  -3.69030000E-04  +3.56500000E-05  +6.31450000E-04
   +9.16100000E-05  -7.03800000E-05  -6.27000000E-06  +6.45858000E-03  +1.76035700E-02
   +1.60492200E-02  -2.88700000E-03  -7.48110000E-04  +5.04086000E-03  -1.35133000E-03
   -1.73750000E-04  -2.66000000E-06  -2.19756000E-03  -4.50416000E-03  +2.01360000E-03
   +3.08539000E-03  -1.93544300E-02  -1.82672100E-02  -5.52677900E-02  -7.38059000E-03
   +2.90238000E-03  +1.17970000E-04  -9.57460000E-04  -9.54440000E-04  +2.50670000E-04
   -2.31000000E-05  -9.08300000E-05  +1.41680000E-04  -1.70900000E-04  -1.55940000E-04
   -3.20530000E-04  -2.09290000E-04  -1.09000000E-04  -5.29900000E-05  +2.03160000E-04
   -2.12210000E-04  +1.47670000E-04  +1.04966000E-03  +9.19600000E-04  +5.35365900E-02
   +2.83710000E-04  +1.68560000E-04  -4.55730000E-04  +2.94620000E-04  +3.11410000E-04
   -1.37330000E-04  +7.31100000E-05  -6.97500000E-05  +4.07300000E-05  +2.24200000E-05
   -5.62500000E-05  +3.01000000E-05  -3.96900000E-05  +5.97400000E-05  -4.83400000E-05
   -9.61500000E-05  +1.10500000E-05  +8.38000000E-05  +6.29180000E-04  -2.07809000E-03
   +1.29363000E-03  -1.28915000E-03  -9.60000000E-07  +1.93050000E-04  +5.20400000E-05
   -4.75000000E-05  +1.66400000E-05  -4.18250000E-04  +7.54090000E-04  -3.54823000E-03
   -6.75900000E-04  +3.43852000E-03  -2.77350000E-03  +6.98000000E-06  -8.29300000E-05
   +9.46100000E-04  -4.65635000E-03  +2.88957000E-03  -2.21401000E-03  +9.52010000E-04
   -9.36801000E-03  -1.35068100E-02  -6.89107000E-03  -1.96524960E-01  -1.49903860E-01
   -1.17200000E-04  -8.15930000E-04  -7.84640000E-04  -4.14640000E-04  -2.28190000E-04
   +3.24800000E-05  -4.17210000E-04  -4.12700000E-05  +3.90750000E-04  -1.33570000E-04
   -2.01170000E-04  +7.00100000E-05  +1.77960000E-04  -3.49440000E-04  +2.64040000E-04
   -1.01670000E-04  -1.35470000E-04  -1.08700000E-05  +1.28816100E-02  +2.04826600E-01
   -1.17050000E-04  -6.95900000E-05  +1.06880000E-04  -2.07770000E-04  -7.18900000E-05
   +1.33650000E-04  -4.78500000E-05  +5.39000000E-05  -4.78000000E-06  -1.25100000E-05
   +3.33600000E-05  -7.71000000E-06  +1.14600000E-05  -3.08600000E-05  +4.83000000E-06
   +1.05800000E-05  +4.35000000E-06  -1.14600000E-05  -2.05027000E-03  +5.77990000E-04
   -1.81804000E-03  -5.94320000E-04  -8.89150000E-04  +4.23850000E-04  -3.04200000E-05
   +3.59000000E-05  -4.40000000E-07  -1.86559000E-03  -1.44284300E-02  -8.53466000E-03
   +5.08125000E-03  -2.38770000E-03  +1.12620000E-03  +7.46300000E-05  +9.58860000E-04
   -1.78090000E-04  +1.96330000E-03  -2.25137000E-03  +4.55742000E-03  +1.62196000E-03
   -6.42510000E-04  +2.39917000E-03  +3.31091000E-03  -1.50524010E-01  -1.88739190E-01
   -1.46960000E-04  -2.20060000E-04  -6.93300000E-05  +6.52380000E-04  +1.89660000E-04
   +9.23000000E-06  +2.28320000E-04  +5.25300000E-05  -3.49800000E-05  -3.16100000E-05
   +1.19840000E-04  -5.42100000E-05  -2.46490000E-04  +2.31980000E-04  -3.42920000E-04
   -1.42530000E-04  -7.24200000E-04  -6.07240000E-04  -4.68407000E-03  +1.66873110E-01
   +1.92857110E-01  -6.90400000E-05  -3.51200000E-05  +1.69840000E-04  -4.09100000E-05
   -2.18400000E-04  +2.86900000E-05  -4.24900000E-05  +4.72100000E-05  -2.56000000E-05
   -3.38700000E-05  +5.25500000E-05  -1.14600000E-05  +6.67200000E-05  -6.68400000E-05
   +2.01100000E-05  +1.00800000E-05  +1.17800000E-05  -1.44700000E-05  -2.27520000E-04
   +5.48910000E-04  +7.77730000E-04  -2.31200000E-05  +9.14700000E-05  +4.96500000E-05
   -8.22500000E-05  +6.29100000E-05  -6.95000000E-06  -1.19991000E-03  -5.09081000E-03
   +4.65650000E-04  -8.02400000E-05  -2.75870000E-04  -8.93500000E-04  +1.93772000E-03
   -1.57557000E-03  +7.73610000E-04  +3.06374000E-03  -2.42468000E-03  -1.02604000E-03
   -2.24422260E-01  +2.68778800E-02  +1.42659600E-01  -1.40442900E-02  +5.84761000E-03
   +1.58546600E-02  +2.36350000E-04  +1.35188000E-03  -1.04427000E-03  -1.80820000E-04
   -6.59700000E-05  -8.82500000E-05  +9.25000000E-05  +4.99600000E-05  -1.99300000E-04
   -7.33900000E-05  +1.76630000E-04  -1.35350000E-04  +1.96530000E-04  -3.66100000E-05
   -1.70000000E-04  -1.53930000E-04  +2.22820000E-04  -1.23410000E-04  -9.49000000E-06
   +1.24783000E-03  -1.59076000E-03  +2.35120370E-01  -3.38200000E-05  +5.73000000E-06
   -1.01200000E-05  -2.09630000E-04  -2.16860000E-04  +2.96900000E-05  +4.40000000E-07
   +1.20400000E-05  -1.66800000E-05  -4.04700000E-05  +5.96100000E-05  +1.83000000E-06
   +2.54900000E-05  -4.30300000E-05  +3.22200000E-05  +1.46100000E-05  -1.16600000E-05
   -7.28000000E-06  -5.15210000E-04  +4.66880000E-04  +3.45320000E-04  +5.95800000E-05
   +4.99000000E-05  +6.13200000E-05  -4.22600000E-05  +3.53700000E-05  +6.00000000E-07
   -4.66429000E-03  +1.00808000E-03  -3.07604000E-03  -4.57670000E-04  -1.30429000E-03
   +7.78400000E-05  -2.04828000E-03  -1.14581000E-03  -5.18052000E-03  +1.91654500E-02
   +2.30152000E-03  -1.46535300E-02  +2.58127100E-02  -5.63703600E-02  -3.63603500E-02
   -1.44397200E-02  +6.48359000E-03  +1.27402700E-02  +1.12260000E-03  -7.88700000E-05
   +2.64652000E-03  -5.40100000E-05  +3.87700000E-05  -5.01700000E-05  +2.68000000E-06
   -1.81900000E-05  +2.47600000E-05  +1.11780000E-04  +2.01700000E-05  +4.84720000E-04
   +9.62810000E-04  -1.71110000E-04  -7.17130000E-04  +1.86500000E-04  -2.18530000E-04
   +3.29310000E-04  +1.64224000E-03  -1.28852000E-03  +2.11943000E-03  -2.66414100E-02
   +5.04184000E-02  -1.27700000E-05  -1.04500000E-05  +5.84500000E-05  +1.09360000E-04
   +5.70600000E-05  -1.06200000E-05  -2.20500000E-05  +1.30200000E-05  +2.33400000E-05
   +2.65300000E-05  -3.04000000E-05  +5.46000000E-06  -3.20400000E-05  +3.22300000E-05
   -2.07900000E-05  +1.87000000E-06  +1.46600000E-05  -4.98000000E-06  -1.12300000E-04
   -1.03890000E-04  +2.76640000E-04  +1.28200000E-05  +4.93700000E-05  -4.23800000E-05
   +3.98000000E-05  -2.81500000E-05  -1.10000000E-07  +4.51940000E-04  -2.84476000E-03
   +4.25324000E-03  -1.17332000E-03  -1.42790000E-04  -5.02700000E-04  +3.86890000E-04
   -5.46033000E-03  +1.21940000E-04  +1.96876400E-02  -1.13387000E-03  -8.04149000E-03
   +1.41584020E-01  -3.71923500E-02  -1.58273790E-01  -3.43618000E-03  +1.51200000E-04
   +4.80064000E-03  -1.28231000E-03  +2.47219000E-03  -3.97180000E-04  -4.21000000E-06
   -5.44400000E-05  -6.73000000E-06  +4.16100000E-05  +7.56000000E-06  -5.53400000E-05
   -2.00470000E-04  +4.41690000E-04  -9.36000000E-06  +7.90850000E-04  -1.15380000E-04
   -6.07750000E-04  -1.30170000E-04  +3.13820000E-04  -3.18040000E-04  -1.20760000E-03
   +2.44763000E-03  -1.43905000E-03  -1.55513680E-01  +4.11962000E-02  +1.60201090E-01
   -2.25720000E-04  -3.02800000E-05  +5.41080000E-04  +7.49030000E-04  -9.58400000E-05
   -1.25740000E-04  -1.57210000E-04  -5.76600000E-05  +4.47650000E-04  +1.18120000E-04
   +1.65930000E-04  -2.02950000E-04  +1.36390000E-04  -1.14500000E-04  +1.79700000E-05
   -3.63100000E-05  +7.85500000E-05  -1.13780000E-04  -2.65404000E-03  +4.34900000E-04
   +7.30070000E-04  -8.43800000E-05  -1.80440000E-04  +5.54140000E-04  -1.92810000E-04
   +1.62480000E-04  -3.63500000E-05  +8.09510000E-04  -1.45801000E-03  +5.60100000E-05
   +3.39930000E-04  +2.90320000E-04  +2.45460000E-04  -2.56580000E-04  -1.83100000E-05
   -2.11400000E-05  +5.79700000E-05  -9.65200000E-05  -1.84380000E-04  +1.25270000E-04
   +1.30080000E-04  -2.35900000E-05  +1.65220000E-04  +7.56500000E-05  +1.64910000E-04
   +3.38200000E-05  +1.02300000E-05  +2.91300000E-05  -2.47531180E-01  +1.18891790E-01
   +1.22921600E-02  +2.67950000E-04  +3.06500000E-05  -2.87480000E-04  -8.37000000E-06
   +3.27000000E-06  -4.33000000E-06  -4.91000000E-06  +1.25100000E-05  -2.22000000E-06
   +2.79400000E-05  -6.04800000E-05  +2.31300000E-05  +3.09600000E-05  +3.83900000E-05
   -1.39700000E-05  +2.29500000E-05  +1.30300000E-05  +7.09000000E-06  +2.65680740E-01
   +1.45772000E-03  -5.46200000E-05  -5.97630000E-04  -6.06640000E-04  -1.73369000E-03
   +3.62537000E-03  -5.22840000E-04  +2.99250000E-04  +4.52970000E-04  +2.13100000E-04
   -6.04000000E-06  +3.90800000E-05  -2.31490000E-04  +1.64870000E-04  +1.91000000E-06
   -7.18700000E-05  -2.65220000E-04  +2.66740000E-04  +1.68027000E-02  -1.23205900E-02
   -6.43370000E-04  -3.91970000E-04  +3.03320000E-04  -1.32169000E-03  +2.39170000E-04
   -1.70390000E-04  -1.69000000E-05  +1.24540000E-03  +5.78200000E-04  -1.15480000E-04
   -1.68650000E-04  -3.94980000E-04  -5.85550000E-04  +2.02100000E-04  +6.49100000E-05
   -6.13700000E-05  -2.74420000E-04  -5.64700000E-05  +1.87280000E-04  -2.58960000E-04
   -1.10850000E-04  +1.26500000E-05  -2.34550000E-04  +1.74350000E-04  -2.37000000E-06
   +2.09840000E-04  +1.81760000E-04  +7.47000000E-06  +1.16964570E-01  -1.15680740E-01
   -8.26986000E-03  -2.90830000E-04  -2.56400000E-05  +2.30740000E-04  -8.36000000E-06
   -3.91000000E-05  -8.21000000E-06  +1.37800000E-05  -1.56000000E-06  +1.48600000E-05
   +1.01200000E-05  +1.35860000E-04  +1.39790000E-04  +3.14400000E-05  -2.41500000E-05
   +8.72200000E-05  +5.64000000E-06  -1.20500000E-05  -4.30000000E-07  -1.29187140E-01
   +1.25213330E-01  -1.37558000E-03  +7.18860000E-04  +6.19320000E-04  +6.52010000E-04
   +2.71852000E-03  -4.35128000E-03  +1.06877000E-03  +6.44700000E-05  -5.64370000E-04
   -2.69370000E-04  +1.16240000E-04  +2.28610000E-04  +1.07720000E-04  -1.33130000E-04
   +2.89000000E-05  +1.39270000E-04  +1.88060000E-04  -3.45000000E-04  -2.23526900E-02
   +1.39911600E-02  -8.49160000E-04  -1.28371000E-03  +9.43880000E-04  +1.17300000E-03
   -1.05300000E-04  +4.45400000E-05  +3.76300000E-05  -8.66890000E-04  -3.51490000E-04
   +4.42870000E-04  +4.27700000E-04  +7.93900000E-05  -6.91100000E-05  -4.40840000E-04
   -2.66200000E-05  +8.31300000E-05  +2.07030000E-04  -6.37100000E-05  -2.42060000E-04
   +1.97060000E-04  +1.45730000E-04  -4.53000000E-06  -1.60890000E-04  -1.12020000E-04
   +2.31920000E-04  -1.76620000E-04  -1.20290000E-04  -1.59000000E-06  +1.40766500E-02
   -9.55069000E-03  -4.67515600E-02  +6.87000000E-05  -7.37800000E-05  -2.19000000E-05
   +1.56600000E-05  +1.16900000E-05  +1.69300000E-05  +1.13200000E-05  -1.71800000E-05
   +2.23000000E-06  +1.68000000E-05  +2.86000000E-06  +6.70700000E-05  +2.95500000E-05
   -1.20500000E-05  -1.12070000E-04  -2.70000000E-07  +7.76000000E-06  +1.37500000E-05
   -1.43982500E-02  +5.63325000E-03  +5.24847900E-02  +1.11770000E-04  -1.75980000E-04
   -5.24800000E-05  +1.62660000E-04  +3.59200000E-05  +1.76210000E-04  -7.44540000E-04
   +1.13475000E-03  +5.95450000E-04  +2.10760000E-04  +3.53200000E-05  -1.23680000E-04
   -1.31210000E-04  +3.38900000E-05  -1.55000000E-05  +5.22000000E-06  +1.16100000E-05
   +1.84000000E-05  +1.19695000E-03  +2.27723000E-03  -4.41990000E-04  +3.09140000E-04
   +3.33680000E-04  -2.47370000E-04  +8.65600000E-05  -4.02400000E-05  -2.04600000E-05
   +4.85990000E-04  -7.27360000E-04  +3.15710000E-04  +3.06800000E-04  +4.28840000E-04
   +5.11300000E-04  -3.26350000E-04  -3.11100000E-05  +7.91300000E-05  +3.53430000E-04
   +1.13710000E-04  -1.30360000E-04  +6.43100000E-05  +6.19000000E-06  -2.80100000E-05
   +5.02180000E-04  -1.98300000E-04  -1.44410000E-04  -3.18600000E-04  -2.32540000E-04
   -1.28500000E-05  -1.98855780E-01  -1.31058630E-01  +2.74186000E-03  +8.18900000E-05
   +7.40400000E-05  +3.80900000E-05  +2.52600000E-05  +4.54100000E-05  +1.75800000E-05
   -3.07000000E-05  -1.52600000E-05  -2.39500000E-05  +6.40000000E-07  -3.11600000E-05
   -1.63300000E-05  -5.95000000E-05  +6.20400000E-05  -6.32000000E-06  -1.93400000E-05
   -4.34000000E-06  +6.64000000E-06  -1.90986200E-02  -1.87797500E-02  -2.34640000E-04
   +2.15701840E-01  -9.43800000E-05  -1.51460000E-04  +5.37510000E-04  -8.07210000E-04
   +6.01480000E-04  -2.60590000E-04  -9.46400000E-05  -3.30750000E-04  +6.94660000E-04
   +3.31310000E-04  +1.52420000E-04  -3.26500000E-04  +2.11800000E-05  -5.54900000E-05
   -4.57100000E-05  -8.04600000E-05  +1.17270000E-04  -8.76000000E-05  -1.47836600E-02
   -1.26081300E-02  -8.40930000E-04  +1.87000000E-06  +5.31550000E-04  -1.57542000E-03
   -1.03430000E-04  +1.33190000E-04  -4.85200000E-05  +2.88370000E-04  -1.53601000E-03
   +3.86828000E-03  -4.08680000E-04  -1.58750000E-04  +2.95000000E-04  +2.63650000E-04
   +1.99410000E-04  +6.83000000E-06  +1.61760000E-04  +5.55540000E-04  +4.89440000E-04
   -6.25470000E-04  -4.09440000E-04  -4.37260000E-04  +5.39540000E-04  -3.80160000E-04
   -3.37970000E-04  -5.23430000E-04  -4.24010000E-04  -1.00990000E-04  -1.29872990E-01
   -1.60179290E-01  +2.24027000E-03  +3.31180000E-04  +1.49590000E-04  -3.69730000E-04
   +2.73700000E-05  +5.03100000E-05  +4.26200000E-05  -2.25300000E-05  -5.41100000E-05
   -2.52400000E-05  -4.12800000E-05  +1.47520000E-04  -1.17120000E-04  +3.60800000E-05
   -5.07300000E-05  +1.59860000E-04  -8.99300000E-05  -2.39000000E-06  -3.70600000E-05
   +1.26999000E-02  +1.20275400E-02  -1.98350000E-04  +1.43107850E-01  +1.72682200E-01
   +1.85300000E-05  +1.30800000E-05  -3.12580000E-04  +3.83550000E-04  -7.41340000E-04
   +5.35840000E-04  -3.70370000E-04  -2.38950000E-04  +4.88070000E-04  -5.42100000E-05
   +8.92900000E-05  -8.61600000E-05  -7.50900000E-05  -3.85400000E-05  +1.32590000E-04
   +1.08910000E-04  -4.76100000E-05  -2.31800000E-05  +2.02521000E-02  +1.63614000E-02
   -1.47113000E-03  +1.05029000E-03  +8.10800000E-04  +1.34566000E-03  +4.43400000E-05
   -1.86800000E-05  -2.56800000E-05  -1.31402000E-03  +2.37083000E-03  -3.65117000E-03
   +3.63000000E-05  -3.37350000E-04  +3.60000000E-06  +6.92880000E-04  -5.52100000E-05
   +7.48100000E-05  -4.35960000E-04  -1.27400000E-05  +2.14570000E-04  +6.59000000E-05
   -2.63020000E-04  +2.43000000E-04  +5.95780000E-04  +5.29910000E-04  +1.15900000E-04
   +4.48930000E-04  +3.67750000E-04  +1.20800000E-05  +2.54369000E-03  +1.14043000E-03
   -4.85704800E-02  -4.49000000E-05  -7.80300000E-05  +2.40500000E-05  -4.77000000E-06
   -3.36200000E-05  -4.51000000E-05  +3.68900000E-05  +3.17800000E-05  +2.07200000E-05
   -2.47010000E-04  +3.58170000E-04  -9.11100000E-05  -1.45600000E-05  +1.07410000E-04
   -1.57270000E-04  +5.69900000E-05  +2.97200000E-05  -1.30600000E-05  +1.55873000E-03
   +1.41797000E-03  -9.77430000E-04  -3.49761000E-03  -4.43863000E-03  +5.07903200E-02
   +1.93330000E-04  +1.25340000E-04  -2.36070000E-04  +3.28330000E-04  -4.90370000E-04
   -2.62270000E-04  -3.58640000E-04  +3.79490000E-04  -7.57260000E-04  -7.80800000E-05
   -4.73000000E-05  +2.27040000E-04  -6.78300000E-05  +4.84000000E-05  -1.46200000E-05
   +2.50000000E-05  -7.43800000E-05  +5.66800000E-05  -1.88048000E-03  -1.36743000E-03
   -1.82553000E-03  -4.80000000E-05  +4.48590000E-04  -3.62810000E-04  +1.08070000E-04
   -1.08640000E-04  +3.19700000E-05  -7.20000000E-07  +5.86190000E-04  +6.68840000E-04
   -6.45000000E-06  -1.75390000E-04  -5.38300000E-05  -2.59170000E-04  -4.28300000E-05
   -5.21200000E-05  -1.43600000E-05  -1.25990000E-04  -7.98700000E-05  +1.08950000E-04
   +8.12600000E-05  +5.96200000E-05  -1.94470000E-04  -6.40100000E-05  +9.99100000E-05
   +5.86900000E-05  +5.37900000E-05  -2.48000000E-06  -4.70209500E-02  -9.95320000E-04
   -4.89750000E-04  -2.16550000E-04  -1.05250000E-04  +2.33520000E-04  -8.75000000E-06
   -2.27100000E-05  +7.75000000E-06  +2.12000000E-05  -1.33900000E-05  +2.06500000E-05
   +1.92990000E-04  -1.19480000E-04  +9.14100000E-05  +3.26100000E-05  +9.13000000E-06
   -6.87900000E-05  +5.70000000E-07  +8.13000000E-06  -9.07000000E-06  +8.13890000E-04
   +1.43382700E-02  +2.43059400E-02  +4.04150000E-04  -1.20181500E-02  -2.13931400E-02
   +4.86300700E-02  -2.40590000E-04  -1.15200000E-04  +7.54800000E-05  -1.87450000E-04
   +8.70190000E-04  -4.74380000E-04  +1.05733000E-03  +1.50270000E-04  -1.86910000E-04
   -5.51600000E-05  -5.11500000E-05  +1.68820000E-04  +7.68000000E-05  -1.89000000E-06
   -1.29950000E-04  -6.61400000E-05  +3.31100000E-05  +3.76500000E-05  -6.30510000E-04
   +1.01397000E-02  +1.66861000E-02  +1.72370000E-04  -1.94973000E-03  +2.75569000E-03
   -5.97100000E-05  +1.89400000E-05  +3.40300000E-05  +5.13550000E-04  +1.05779000E-03
   +2.16220000E-04  -3.99500000E-04  -8.44300000E-05  +5.98040000E-04  -1.15700000E-05
   -1.63410000E-04  -1.06720000E-04  -1.00000000E-06  -1.11820000E-04  -1.53960000E-04
   +1.20380000E-04  +1.38500000E-04  +1.32610000E-04  -1.57550000E-04  -3.04500000E-05
   -4.80400000E-05  +1.63200000E-04  +1.05780000E-04  +1.86200000E-05  -1.26237000E-03
   -1.23366370E-01  -1.21837060E-01  -1.97300000E-05  +3.30100000E-05  -3.29100000E-05
   -1.84800000E-05  -1.37800000E-05  -1.56500000E-05  -6.70000000E-07  +7.60000000E-06
   +2.23300000E-05  +5.26800000E-05  -6.67370000E-04  +1.39040000E-04  +1.88100000E-05
   -1.01400000E-05  +1.10800000E-05  +9.61000000E-06  -1.07000000E-06  -1.74000000E-06
   -1.33118000E-03  -8.69934000E-03  -1.31054200E-02  +1.93126000E-03  -1.03870000E-02
   -1.67190000E-02  -2.07410000E-04  +1.32432860E-01  +1.22170000E-04  +4.53460000E-04
   -3.58390000E-04  +1.04759000E-03  -9.32950000E-04  +7.74000000E-04  +5.79790000E-04
   +2.11770000E-04  +1.91700000E-05  -3.39530000E-04  +1.90480000E-04  +2.73190000E-04
   -2.94600000E-05  -1.61180000E-04  +1.35350000E-04  +1.59830000E-04  -1.42680000E-04
   +8.31000000E-06  +4.39740000E-04  -1.46255700E-02  -2.06989100E-02  -3.43400000E-05
   +4.90266000E-03  -4.26211000E-03  -6.22000000E-06  -1.59700000E-05  +2.37100000E-05
   -1.63217000E-03  -9.26450000E-04  +7.98240000E-04  +1.05350000E-04  -6.60650000E-04
   +9.38000000E-06  +6.53750000E-04  +3.40810000E-04  +1.81120000E-04  -2.68710000E-04
   +4.14770000E-04  +4.93920000E-04  -4.80030000E-04  -4.53190000E-04  -1.74070000E-04
   +9.37910000E-04  +1.05290000E-04  -2.81520000E-04  -6.79000000E-05  -3.98800000E-05
   -2.88800000E-05  -1.44630000E-04  -1.19477240E-01  -2.39940300E-01  -1.28150000E-04
   +7.83600000E-05  +3.46350000E-04  +2.15800000E-05  +1.42000000E-05  -4.80000000E-07
   +4.00000000E-05  +3.72000000E-06  -3.54000000E-06  -2.26730000E-04  +4.99730000E-04
   +1.01340000E-04  -1.45430000E-04  +5.71000000E-06  +8.81600000E-05  -6.42000000E-06
   +1.45200000E-05  -2.16700000E-05  -1.92680000E-04  -1.95630000E-04  -7.82600000E-04
   +8.63200000E-05  +1.50495000E-03  +1.75964000E-03  +2.92310000E-04  +1.30275850E-01
   +2.62037500E-01  -5.96070000E-04  +3.46720000E-04  +9.44470000E-04  +1.16110000E-04
   -4.05750000E-04  +2.00040000E-04  -2.04370000E-04  +4.85800000E-05  +4.19800000E-05
   +1.69370000E-04  -8.62700000E-05  +1.18000000E-06  -6.24500000E-05  +1.13600000E-04
   -5.31600000E-05  -4.46600000E-05  -1.57000000E-06  -3.07200000E-05  -1.69277000E-03
   +5.78120000E-04  -1.20910000E-03  -4.89428900E-02  -2.95737000E-03  +5.41220000E-03
   +6.75000000E-05  -5.67400000E-05  -1.40900000E-05  +2.29490000E-04  +5.28240000E-04
   -3.80740000E-04  -8.51200000E-05  -7.28300000E-05  -5.80300000E-05  +1.38560000E-04
   +1.09090000E-04  +2.08500000E-05  -9.56400000E-05  -1.47000000E-06  +4.36700000E-05
   -1.14790000E-04  +2.14000000E-06  +2.13370000E-04  +7.20300000E-05  -3.40050000E-04
   -5.24320000E-04  +9.96200000E-05  +1.07950000E-04  +3.34500000E-05  -4.91300000E-05
   -2.93260000E-04  -4.49520000E-04  +6.30400000E-05  +4.44160000E-04  -6.99480000E-04
   -9.10000000E-06  -1.02600000E-05  -4.72000000E-06  +1.37900000E-05  +1.11900000E-05
   +1.63100000E-05  -1.30100000E-05  +4.82200000E-05  +4.65900000E-05  -1.14806000E-03
   +2.09000000E-04  -4.08590000E-04  -9.17000000E-06  +1.70000000E-07  -2.27600000E-05
   +3.33260000E-04  -2.87290000E-04  +2.85660000E-04  +1.53750000E-04  +3.27470000E-04
   -2.09990000E-04  +6.84680000E-04  +9.78600000E-05  -1.56620000E-04  +4.92390600E-02
   +1.61455000E-03  +3.17290000E-04  -1.75294000E-03  -5.72730000E-04  +7.19240000E-04
   +6.65310000E-04  +2.45000000E-04  -2.49400000E-05  -4.18800000E-05  -2.28200000E-04
   +9.50700000E-05  +3.83100000E-05  +8.28400000E-05  -1.58400000E-04  +6.00000000E-05
   -2.64420000E-04  -1.11200000E-05  +2.31290000E-04  +4.76060000E-04  +1.15572600E-02
   -1.69537600E-02  -2.54395000E-03  -1.26769190E-01  +1.27126970E-01  -1.64010000E-04
   +8.55700000E-05  +1.25400000E-05  +1.75710000E-04  +8.48020000E-04  +3.25880000E-04
   +2.05360000E-04  -1.51080000E-04  +1.03500000E-05  +1.40390000E-04  +3.77600000E-05
   -4.36800000E-05  -1.33140000E-04  +3.08000000E-05  +1.67180000E-04  -2.09900000E-05
   -2.28980000E-04  -1.35500000E-04  -5.37890000E-04  +3.32130000E-04  +1.14880000E-04
   +6.19100000E-05  +8.35000000E-06  -2.62900000E-05  -1.78560000E-04  -2.24234000E-03
   -3.00425000E-03  +1.86450000E-04  -3.79328000E-03  +1.07859000E-03  -1.41000000E-05
   -6.31000000E-06  -8.88000000E-06  +5.46000000E-06  +1.75500000E-05  -1.28100000E-05
   -1.89300000E-05  +2.25800000E-05  -4.29400000E-05  -1.57940000E-04  -1.11530000E-04
   -2.09040000E-04  -1.19200000E-05  +3.15500000E-05  -2.16700000E-05  -2.40790000E-04
   -2.77400000E-05  -9.53100000E-05  +2.38110000E-04  -1.77000000E-05  -8.50100000E-05
   -1.21060000E-04  +8.21210000E-04  -1.18354000E-03  +3.04059000E-03  +1.37562790E-01
   +1.39332000E-03  -1.45920000E-04  -1.52598000E-03  -6.84580000E-04  +4.20680000E-04
   +7.99920000E-04  +3.80830000E-04  -4.50000000E-06  -1.25040000E-04  -2.01520000E-04
   +9.57700000E-05  +2.93700000E-05  +9.66000000E-06  -8.05300000E-05  +8.07100000E-05
   -8.37600000E-05  -1.63640000E-04  +1.41440000E-04  +2.90110000E-04  +1.44931800E-02
   -2.05923200E-02  +5.53239000E-03  +1.22766190E-01  -2.44078640E-01  -3.18900000E-05
   +2.59200000E-05  +3.07000000E-05  +7.65230000E-04  +1.07255000E-03  +9.30060000E-04
   -2.19700000E-05  -4.34490000E-04  -2.35700000E-05  +2.06880000E-04  +1.57690000E-04
   +4.25000000E-06  -9.37600000E-05  +1.51030000E-04  +1.34120000E-04  -2.49080000E-04
   -1.17900000E-04  +1.62790000E-04  +1.58670000E-04  -2.22340000E-04  -2.66500000E-05
   -3.49000000E-06  +3.22000000E-06  +1.36300000E-05  +1.24760000E-04  -4.57056000E-03
   -4.00974000E-03  -9.97240000E-04  +2.18738000E-03  +5.05750000E-04  -5.82000000E-06
   +6.32000000E-06  -7.36000000E-06  -1.66900000E-05  +2.28300000E-05  -2.74000000E-05
   -2.28700000E-05  +8.49200000E-05  +2.48700000E-05  -5.28830000E-04  +1.37470000E-04
   +7.29000000E-06  -1.99800000E-05  -2.09300000E-05  -9.19000000E-06  -1.59800000E-05
   -9.11600000E-05  +2.46490000E-04  +8.67700000E-05  -9.13700000E-05  +3.27400000E-04
   -1.49910000E-04  +9.81690000E-04  -1.49639000E-03  -5.29669000E-03  -1.34931050E-01
   +2.65858610E-01  +1.22100000E-05  -1.49960000E-04  +3.47640000E-04  +7.53860000E-04
   +1.38284000E-03  +2.59320000E-04  +3.72200000E-04  -1.90390000E-04  -3.74800000E-05
   +2.81300000E-05  -3.39900000E-05  -1.05360000E-04  -6.20600000E-05  +3.08000000E-05
   +2.56000000E-06  +1.89700000E-05  -2.47300000E-05  -2.39000000E-06  -1.49256000E-03
   +5.36230000E-04  +1.01840000E-03  -2.41122240E-01  -1.21399320E-01  +5.77641000E-03
   +5.37900000E-05  -2.58800000E-05  -5.60000000E-07  +6.41690000E-04  +1.17830000E-04
   +1.09150000E-04  +5.97700000E-05  +1.69720000E-04  +2.46520000E-04  -8.35500000E-05
   -8.64800000E-05  -9.81700000E-05  +1.11620000E-04  +8.04400000E-05  -1.90400000E-05
   +1.84060000E-04  -1.45650000E-04  -2.37430000E-04  -2.67460000E-04  +1.01730000E-04
   +4.02490000E-04  -1.70860000E-04  -1.68890000E-04  -5.07700000E-05  -1.57220000E-04
   +1.62900000E-04  +3.40450000E-04  +5.18200000E-05  +8.90000000E-06  -2.09770000E-04
   +1.69600000E-05  +2.06000000E-05  +9.48000000E-06  -2.90400000E-05  -1.25100000E-05
   -2.24700000E-05  +8.47100000E-05  -6.12100000E-05  -4.96400000E-05  +3.21110000E-04
   -8.53200000E-05  -4.58980000E-04  -8.03000000E-06  -1.98000000E-06  +1.90500000E-05
   +2.47000000E-05  -1.26850000E-04  +5.46000000E-05  +2.89480000E-04  +2.75360000E-04
   -5.20890000E-04  +2.88000000E-04  +2.43280000E-04  -4.18600000E-05  +4.39360000E-04
   +1.05073000E-03  -8.11000000E-06  +2.59354170E-01  -3.85510000E-04  -2.74950000E-04
   +7.63360000E-04  -1.19021000E-03  +4.73890000E-04  +3.20300000E-04  +4.17420000E-04
   +5.67800000E-05  -1.26170000E-04  +2.88800000E-05  +5.42900000E-05  -1.38030000E-04
   +1.36020000E-04  -1.68210000E-04  -3.36000000E-06  +1.05520000E-04  -6.68900000E-05
   +4.76300000E-05  -1.66222700E-02  -1.25570400E-02  +2.22500000E-04  -1.19802500E-01
   -1.20829450E-01  +5.14839000E-03  -1.94480000E-04  +1.77500000E-04  +8.60000000E-07
   +1.28230000E-03  -1.41290000E-03  -3.63880000E-03  -1.24124000E-03  -2.02670000E-04
   +1.73790000E-04  -4.43400000E-05  -3.38840000E-04  -1.21570000E-04  +3.01260000E-04
   +9.00600000E-05  -8.17100000E-05  -9.24400000E-05  +1.42320000E-04  +6.29100000E-05
   +5.62560000E-04  +8.80400000E-05  -4.39360000E-04  -2.69550000E-04  -1.72160000E-04
   +6.63000000E-06  +3.51170000E-04  +2.46720000E-04  +1.17388000E-03  +4.94200000E-04
   -2.51880000E-04  -2.80740000E-04  +3.39700000E-05  +3.45100000E-05  +1.72900000E-05
   -8.53500000E-05  -1.16570000E-04  +1.08100000E-05  +8.83000000E-06  +3.20500000E-05
   -8.11300000E-05  +9.55600000E-05  -5.67300000E-05  +3.25620000E-04  -4.29600000E-05
   -7.35000000E-06  -7.05000000E-06  +1.21210000E-04  +5.75800000E-05  -2.08200000E-05
   +1.00730000E-04  +6.09620000E-04  -1.04610000E-04  +2.62460000E-04  -1.97000000E-06
   +3.86600000E-05  -1.44756100E-02  -8.54844000E-03  -8.67990000E-04  +1.31940530E-01
   +1.30918900E-01  +1.18320000E-04  -1.31000000E-05  +1.84540000E-04  -1.01605000E-03
   +6.23330000E-04  +8.82700000E-04  +1.29640000E-04  +1.48180000E-04  +2.88400000E-05
   +1.61300000E-05  +5.92000000E-06  -8.54700000E-05  +9.07900000E-05  -7.88200000E-05
   -1.71700000E-05  -1.48490000E-04  -1.90000000E-07  +8.49100000E-05  -2.27995000E-02
   -1.47083300E-02  -1.35658000E-03  +8.14837000E-03  +6.20827000E-03  -4.72405400E-02
   -1.74440000E-04  +1.11820000E-04  -1.70800000E-05  +1.18069000E-03  -2.30015000E-03
   -4.31871000E-03  -1.47780000E-03  -8.45320000E-04  +2.85490000E-04  +1.46960000E-04
   -2.58320000E-04  -2.16870000E-04  +1.04690000E-04  +1.38370000E-04  -5.64000000E-06
   -1.96400000E-04  -1.62900000E-05  +1.95100000E-04  +8.57490000E-04  -2.85760000E-04
   -4.49670000E-04  -1.45070000E-04  -6.76400000E-05  +2.08300000E-05  -1.13770000E-03
   -8.82840000E-04  +1.21796000E-03  -1.00380000E-04  +3.17250000E-04  -2.15900000E-04
   +1.99700000E-05  +2.08600000E-05  +7.21000000E-06  -1.18460000E-04  -7.86300000E-05
   -2.93500000E-05  +1.84000000E-06  +3.79300000E-05  -1.70900000E-05  -1.05370000E-04
   +4.68580000E-04  +2.05140000E-04  -2.46900000E-05  -3.27000000E-05  +1.04300000E-05
   +5.26900000E-05  +4.63000000E-06  -6.98400000E-05  +3.01690000E-04  +3.58070000E-04
   -7.20730000E-04  +3.04910000E-04  +1.65020000E-04  +2.69910000E-04  +2.44676600E-02
   +1.26960400E-02  +8.37790000E-04  -7.71085000E-03  -1.61388000E-03  +5.15205600E-02
   -8.14800000E-05  -2.89420000E-04  +5.87640000E-04  +4.27380000E-04  +6.48440000E-04
   +5.90030000E-04  +7.09010000E-04  +1.05540000E-04  -2.84010000E-04  -1.96820000E-04
   +1.94280000E-04  -1.29800000E-04  +2.35230000E-04  -2.70690000E-04  +8.38900000E-05
   -1.79000000E-05  -6.76500000E-05  +2.07500000E-05  +5.56120000E-04  -1.41384000E-03
   -2.22190000E-04  -2.03863870E-01  +1.31131600E-01  -1.93647000E-03  -3.01980000E-04
   +2.34280000E-04  -2.52000000E-06  -6.35700000E-05  -2.44500000E-05  +3.10790000E-04
   +9.79000000E-05  +6.94700000E-05  +2.01000000E-06  +7.46300000E-05  +2.81900000E-05
   -2.06900000E-05  -1.94860000E-04  +1.29500000E-05  +3.87400000E-05  +9.82900000E-05
   -1.81430000E-04  -2.49360000E-04  -9.64920000E-04  -9.33540000E-04  +5.06390000E-04
   +9.79200000E-05  +2.93100000E-05  -2.19000000E-05  +3.40280000E-04  -3.38510000E-04
   -4.86100000E-04  +2.40770000E-04  -1.08520000E-04  -2.25450000E-04  -1.89700000E-05
   -1.22900000E-05  -7.62000000E-06  +1.33400000E-05  +2.08900000E-05  -2.37000000E-06
   -1.22500000E-05  -2.48000000E-06  -1.37100000E-05  -7.41020000E-04  -1.64623000E-03
   -1.94800000E-04  +2.73200000E-05  -3.88000000E-06  +2.27400000E-05  +3.79260000E-04
   -1.43010000E-04  +2.85330000E-04  -2.15590000E-04  +1.25440000E-04  +8.14600000E-05
   +2.08910000E-04  -2.73130000E-04  +2.04500000E-05  +1.13970000E-03  -2.13764000E-03
   -1.03000000E-04  -1.97249800E-02  +1.82111600E-02  -8.37900000E-04  +2.21808560E-01
   +1.44620000E-04  +1.39700000E-04  +1.14900000E-04  -8.35880000E-04  -1.09608000E-03
   -3.63677000E-03  -5.09600000E-05  -3.95240000E-04  +2.37270000E-04  +6.22470000E-04
   -2.71450000E-04  +2.03930000E-04  -3.31400000E-04  +4.18560000E-04  -2.66230000E-04
   +1.25800000E-05  +1.46520000E-04  +4.84300000E-05  +1.53577800E-02  -1.26317000E-02
   +7.16460000E-04  +1.29870140E-01  -1.55749110E-01  +1.70811000E-03  +4.67320000E-04
   -3.49900000E-04  +2.63400000E-05  +7.02500000E-04  +5.90520000E-04  +4.54230000E-04
   -3.10630000E-04  -1.62310000E-04  -1.60570000E-04  +1.83690000E-04  +1.83260000E-04
   +4.70300000E-05  -6.85600000E-05  -1.84000000E-06  +1.01760000E-04  -3.51190000E-04
   +1.90260000E-04  +3.27350000E-04  +1.30580000E-04  -5.07670000E-04  -7.64610000E-04
   +9.10900000E-05  +1.34710000E-04  +5.90700000E-05  +8.07000000E-05  +5.17140000E-04
   +1.66030000E-03  -2.57840000E-04  -5.91250000E-04  +2.23800000E-05  -3.99000000E-06
   -1.40700000E-05  -6.20000000E-07  +8.30000000E-06  -9.40000000E-07  +2.10200000E-05
   +2.37200000E-05  +7.36000000E-05  +1.29580000E-04  -1.15358000E-03  -8.74520000E-04
   +6.32600000E-04  -1.55900000E-05  -3.25300000E-05  -1.53400000E-05  -3.26460000E-04
   +6.58730000E-04  -3.34870000E-04  -1.30910000E-04  -1.37200000E-05  -1.30910000E-04
   -3.38240000E-04  +3.58600000E-05  +1.42610000E-04  +1.28257700E-02  -1.01835800E-02
   -1.24193000E-03  -1.35838600E-02  +1.21808300E-02  -1.90890000E-04  -1.42837110E-01
   +1.67647680E-01  +1.35346000E-03  +1.26330000E-04  -1.57346000E-03  -6.84670000E-04
   -2.85862000E-03  -3.94532000E-03  +2.77320000E-04  -4.14910000E-04  +1.99180000E-04
   +4.97740000E-04  -1.38320000E-04  +3.61990000E-04  -2.33570000E-04  +3.11880000E-04
   -2.21180000E-04  -1.27310000E-04  +1.49940000E-04  +1.07630000E-04  +2.09211200E-02
   -1.60646800E-02  -1.25546000E-03  -2.98880000E-03  +2.99525000E-03  -4.78173100E-02
   +4.43840000E-04  -3.21040000E-04  +5.32200000E-05  +1.51760000E-04  +5.51300000E-04
   +6.24630000E-04  +6.17000000E-06  +5.32000000E-06  -2.25520000E-04  +1.16970000E-04
   +7.12400000E-05  -2.44200000E-05  -1.34260000E-04  +3.02400000E-05  +1.43620000E-04
   -7.94600000E-05  -1.52290000E-04  -1.25980000E-04  -3.88380000E-04  +3.58880000E-04
   +4.17270000E-04  +5.96600000E-05  +2.65800000E-05  -2.34800000E-05  +1.29479000E-03
   -9.54240000E-04  +1.06682000E-03  -8.93760000E-04  +6.47300000E-04  +9.98500000E-04
   -7.08000000E-06  -1.51000000E-05  -3.69000000E-06  +1.94600000E-05  -7.66000000E-06
   +9.46000000E-06  +4.15500000E-05  -8.31000000E-06  +3.72900000E-05  +9.77000000E-05
   +3.70600000E-05  +2.00940000E-04  +9.36000000E-06  -6.10000000E-07  +8.70000000E-06
   -5.19260000E-04  +5.80600000E-05  -8.25150000E-04  +6.06300000E-05  +1.34100000E-04
   -6.55400000E-05  -1.75540000E-04  +1.61720000E-04  +4.14570000E-04  -2.21398400E-02
   +1.57722900E-02  +1.47400000E-03  +1.00058000E-03  -6.91970000E-04  -1.01130000E-03
   +2.14500000E-03  +2.84380000E-04  +5.10915800E-02  -1.11140000E-03  +1.45429000E-03
   +4.22541000E-03  +8.17483000E-03  -1.32801600E-02  +1.55064700E-02  -5.29445800E-02
   +2.90053000E-02  -2.26105000E-02  -1.02725000E-03  +1.59197000E-02  -1.74872500E-02
   -2.59437000E-03  +4.86514000E-03  +3.92670000E-04  -1.20545000E-03  -1.48040000E-04
   +7.54720000E-04  -1.13450000E-04  -1.51543000E-03  -1.55193000E-03  +4.49160000E-04
   +7.77100000E-05  -1.26250000E-04  +3.69800000E-05  +4.78370000E-04  -8.95050000E-04
   -2.44250000E-04  +6.67400000E-05  -1.18020000E-04  -4.49000000E-05  +1.37490000E-04
   +8.59500000E-05  +2.03200000E-05  -5.05000000E-06  -7.84500000E-05  -9.14200000E-05
   -9.18200000E-05  -1.08900000E-05  +3.89600000E-05  +4.29100000E-05  +3.62800000E-05
   -2.81700000E-05  +4.67000000E-06  -1.44900000E-05  +1.38380000E-04  +1.03530000E-04
   +4.50000000E-06  -1.88988000E-03  +9.94870000E-04  +1.13776000E-03  +5.79500000E-05
   -9.73380000E-04  +1.01918000E-03  -1.63900000E-05  -2.45000000E-05  -1.99000000E-06
   +1.04300000E-05  +8.19000000E-06  +1.60700000E-05  +7.85500000E-05  -9.56800000E-05
   +1.04500000E-05  -1.02200000E-05  -1.32500000E-05  +3.43000000E-06  +1.37400000E-05
   -4.54000000E-06  +3.00000000E-07  +1.46640000E-04  -2.26510000E-04  -1.42150000E-04
   -6.23320000E-04  +1.05988000E-03  +1.72860000E-04  -1.94782000E-03  +4.56060000E-04
   -5.33360000E-04  +1.87800000E-05  -7.00100000E-05  -1.58310000E-04  +2.57900000E-05
   -3.24700000E-05  +2.95700000E-05  -4.56100000E-05  -5.11700000E-05  -5.23900000E-05
   +5.51463100E-02  +1.27538000E-03  +3.52793000E-03  +1.91069000E-03  +1.45791000E-03
   +3.00030000E-03  +3.75144000E-03  +2.41968500E-02  -1.73792100E-01  +1.48286750E-01
   +4.38320000E-03  -1.06882600E-02  +1.11810600E-02  +3.53017000E-03  +1.04688000E-03
   +1.61395000E-03  +1.47300000E-05  +9.97100000E-05  -8.08060000E-04  -8.70170000E-04
   -2.57475000E-03  -1.08643000E-03  +5.15930000E-04  -2.74560000E-04  -3.26000000E-05
   -7.83700000E-05  -5.65390000E-04  +3.81130000E-04  -2.15560000E-04  +3.86410000E-04
   +3.07400000E-04  -1.27940000E-04  +1.07670000E-04  +1.77070000E-04  +4.58000000E-06
   -4.28100000E-05  -6.18600000E-05  +3.20200000E-05  +4.50900000E-05  +1.23700000E-05
   -5.66000000E-06  -1.18400000E-05  +2.52000000E-06  -1.17970000E-04  -1.33020000E-04
   -9.36200000E-05  -3.95600000E-05  -4.90700000E-05  -1.98300000E-05  +2.54091000E-03
   -2.26910000E-04  -4.19740000E-04  +6.39700000E-05  -1.33220000E-04  +1.04200000E-05
   -6.88000000E-06  +2.92000000E-06  +8.60000000E-06  -1.34400000E-05  -1.66200000E-05
   +4.65000000E-06  +8.83000000E-06  -9.38600000E-05  +1.78100000E-05  +1.66500000E-05
   -5.00000000E-08  -1.17200000E-05  -1.04900000E-05  -1.41100000E-05  +7.90000000E-07
   +7.60700000E-05  -1.68960000E-04  -4.93790000E-04  +1.48290000E-03  -1.14808000E-03
   -3.26480000E-04  +8.71400000E-05  -2.03410000E-04  -3.26460000E-04  -1.57600000E-05
   -1.13600000E-05  +6.00000000E-07  -1.65500000E-05  -1.83000000E-06  -1.28000000E-05
   -4.75800000E-05  -3.63700000E-05  -1.60430000E-04  -3.82403700E-02  +1.82102570E-01
   +4.53264000E-03  +1.49786000E-03  +1.97490000E-04  -2.94326000E-03  +1.68111700E-02
   -1.13336300E-02  -1.69513800E-02  +1.44373780E-01  -2.01704690E-01  -2.96022000E-03
   +1.00906000E-03  +2.82207000E-03  +2.09804000E-03  +6.31090000E-04  +2.16093000E-03
   +3.83410000E-04  -6.11520000E-04  -1.03410000E-04  -2.32524000E-03  -6.05210000E-04
   -1.39864000E-03  +5.26410000E-04  -1.39680000E-04  +2.25800000E-05  -2.03560000E-04
   -1.21760000E-04  +1.23000000E-05  -2.50570000E-04  +2.14310000E-04  +2.00930000E-04
   -5.73000000E-06  +3.20800000E-05  +9.15200000E-05  -2.81500000E-05  -3.08900000E-05
   +1.44600000E-05  +5.25800000E-05  +4.75700000E-05  -4.09000000E-06  -5.68000000E-06
   -2.51900000E-05  +5.16000000E-06  -6.90800000E-05  -9.78000000E-05  -5.39600000E-05
   -7.39700000E-05  -6.39900000E-05  -1.24700000E-05  -7.89520000E-04  +8.87820000E-04
   +5.31230000E-04  -1.92070000E-04  +9.92580000E-04  -1.02722000E-03  +5.30000000E-07
   +1.08600000E-05  +4.74000000E-06  -1.12700000E-05  -1.03500000E-05  -5.28000000E-06
   +1.70000000E-05  +2.37900000E-05  -2.69400000E-05  +7.33000000E-06  +1.23100000E-05
   -1.66000000E-05  -1.19700000E-05  -5.14000000E-06  -9.00000000E-07  -5.70660000E-04
   -2.26810000E-04  +3.03610000E-04  -1.46200000E-05  -9.53640000E-04  +1.01500000E-04
   -4.75270000E-04  +3.07470000E-04  +3.55150000E-04  -5.25100000E-05  +3.80000000E-06
   +5.41600000E-05  +3.97000000E-06  -3.72500000E-05  -6.64700000E-05  +2.19100000E-05
   -9.33500000E-05  -1.35350000E-04  +2.01036800E-02  -1.63810640E-01  +2.09280750E-01
   +1.10723000E-03  +1.68137900E-02  -1.84405300E-02  -2.97429000E-03  +3.64636000E-03
   +1.64655000E-03  -1.15368000E-03  +2.53140000E-04  -2.92960000E-04  -1.32230000E-03
   -1.17710000E-04  +4.90173000E-03  +5.71315000E-03  -1.35945000E-02  +1.59756400E-02
   -5.75621800E-02  +3.49556400E-02  -1.77018600E-02  +6.18570000E-04  +7.12470000E-04
   -1.02346000E-03  +1.26200000E-05  -8.30600000E-05  -8.15200000E-05  +1.46096000E-03
   -2.64118000E-03  -1.62274000E-03  +1.95620000E-04  +6.59300000E-05  +6.91000000E-06
   -6.26000000E-06  -3.96400000E-05  +1.10400000E-05  -1.30300000E-05  -2.77200000E-05
   +1.08000000E-05  +1.21600000E-05  +2.02000000E-05  +5.20000000E-06  -1.12600000E-05
   -1.87000000E-05  +1.47000000E-06  -1.09000000E-05  -2.88600000E-05  +7.84000000E-06
   -3.17300000E-05  -3.82500000E-05  +2.33000000E-06  -3.96870000E-04  +1.39190000E-04
   +1.37230000E-04  +9.73410000E-04  -1.31205000E-03  -2.88515000E-03  -6.32000000E-06
   +1.01400000E-05  -5.32000000E-06  -1.47200000E-05  -3.28000000E-06  -1.51700000E-05
   +1.01000000E-06  +2.84800000E-05  +1.07000000E-06  +5.86000000E-06  +9.54000000E-06
   -7.19000000E-06  -8.08000000E-06  +3.00000000E-08  -2.38000000E-06  -2.30700000E-05
   +8.05700000E-05  -1.42130000E-04  +9.16000000E-06  -4.00000000E-06  +2.38300000E-05
   +9.50000000E-06  -2.15100000E-05  -3.33200000E-05  +7.23000000E-06  +3.29600000E-05
   +2.43000000E-05  -5.95000000E-06  -1.02500000E-05  +1.68400000E-05  -1.97300000E-05
   +1.60000000E-05  +3.54800000E-05  +6.13400000E-05  +1.38860000E-04  +6.56000000E-05
   +5.51101400E-02  -1.06848000E-03  -8.53726000E-03  +1.60659600E-02  +4.46727000E-03
   +9.10350000E-04  +8.99600000E-05  -5.89300000E-05  -1.05550000E-04  -1.14693000E-03
   -7.13400000E-05  +2.49884000E-03  +2.09311000E-03  +4.43029000E-03  -4.19800000E-04
   +2.43585000E-03  +3.58986900E-02  -1.67834710E-01  +1.42304350E-01  -3.57460000E-04
   +3.79700000E-05  +9.08500000E-04  +4.44000000E-05  +4.05000000E-06  +1.08150000E-04
   -2.29251000E-03  -2.51650000E-04  -2.78230000E-03  -1.09520000E-04  -1.69100000E-04
   -2.48700000E-05  +7.02000000E-06  +2.81500000E-05  +2.08800000E-05  +1.09700000E-05
   -1.54800000E-05  -1.44100000E-05  -5.80300000E-05  -5.47300000E-05  -1.09200000E-05
   +3.72900000E-05  +4.29300000E-05  -7.77000000E-06  +1.44000000E-06  +4.33800000E-05
   +1.32900000E-05  +8.32700000E-05  +5.99600000E-05  +1.67000000E-06  +3.23000000E-04
   -1.71800000E-04  -1.26900000E-04  -2.62485000E-03  -3.91090000E-04  -2.67275000E-03
   -1.20100000E-05  -1.02700000E-05  -1.81000000E-06  +1.51000000E-06  +6.78000000E-06
   +2.31000000E-06  -1.06500000E-05  -1.02700000E-05  -3.07100000E-05  +2.92000000E-06
   -1.84900000E-05  +3.19000000E-06  +1.37100000E-05  +2.19000000E-06  -4.20000000E-07
   +3.65000000E-06  -1.22240000E-04  +7.02300000E-05  -2.90700000E-05  -3.91000000E-06
   +1.52100000E-05  -1.09100000E-05  +1.29600000E-05  -3.18400000E-05  +1.97400000E-05
   +1.45000000E-05  -4.97500000E-05  -1.58100000E-05  -6.17000000E-06  +1.67000000E-05
   +1.59500000E-05  -3.19300000E-05  -5.22200000E-05  +1.18910000E-04  +1.22420000E-04
   +2.00960000E-04  -4.00430500E-02  +1.73978100E-01  +3.32117000E-03  +4.73490000E-04
   +2.72750000E-04  +7.34680000E-04  +8.74980000E-04  +2.43055000E-03  +1.70100000E-04
   -1.39981000E-03  +4.90800000E-04  +4.68340000E-03  +2.20208000E-03  -2.62292000E-03
   -6.58485000E-03  +1.80276700E-02  -1.19699900E-02  -1.86058300E-02  +1.43323490E-01
   -1.89396100E-01  +4.38050000E-04  -1.94000000E-05  +2.06350000E-04  -9.35100000E-05
   +2.28800000E-05  -3.29900000E-05  -1.88458000E-03  -2.56872000E-03  +7.56740000E-04
   -4.27000000E-06  +6.34400000E-05  +3.88300000E-05  +1.20000000E-05  -3.52100000E-05
   -3.48000000E-06  -2.19700000E-05  -1.83600000E-05  +3.07400000E-05  +3.88900000E-05
   +4.82900000E-05  +2.02500000E-05  -1.48500000E-05  -3.67000000E-05  -8.64000000E-06
   -1.77600000E-05  -1.15700000E-05  -2.85000000E-05  -6.95700000E-05  -6.97700000E-05
   -1.39000000E-06  -7.94300000E-05  -2.06000000E-05  +2.05000000E-05  -1.39414000E-03
   -3.49629000E-03  +9.87360000E-04  -3.42000000E-06  +1.88100000E-05  -4.72000000E-06
   -1.66400000E-05  -2.82000000E-06  -2.26600000E-05  +1.33200000E-05  +3.73700000E-05
   +4.00000000E-06  +9.82000000E-06  +6.34000000E-06  -7.38000000E-06  -7.52000000E-06
   -2.22000000E-06  +5.20000000E-07  -4.13500000E-05  -7.36000000E-06  -1.93500000E-05
   -8.58000000E-06  -4.28400000E-05  +1.04000000E-05  +2.96200000E-05  +7.47000000E-06
   -1.74100000E-05  +1.03500000E-05  +2.21200000E-05  +9.65000000E-06  -6.54000000E-06
   -3.14500000E-05  +1.08000000E-06  -2.23100000E-05  +4.16100000E-05  +3.86600000E-05
   +1.04650000E-04  +1.69210000E-04  +5.35100000E-05  +1.80925000E-02  -1.58036180E-01
   +1.98661010E-01  -1.31586000E-03  +4.09110000E-04  -2.31700000E-05  +1.97670000E-04
   -3.22110000E-04  +3.92640000E-04  +9.12310000E-04  +9.76770000E-04  -7.19680000E-04
   -4.53752000E-03  +3.02744000E-03  +1.73343000E-03  -6.92323000E-03  +3.00957300E-02
   -3.35093000E-02  +1.85889000E-03  -4.16150000E-04  -1.65667000E-03  -1.73500000E-04
   +2.78000000E-06  +9.27400000E-05  +4.28400000E-05  +1.90000000E-07  -1.23000000E-06
   -3.46286100E-02  -1.96709000E-03  +2.95065900E-02  -9.01000000E-06  -4.96900000E-05
   -6.89000000E-06  +1.88000000E-06  -9.56000000E-06  +3.29400000E-05  +3.62000000E-05
   -3.42100000E-05  -2.15300000E-05  -1.27150000E-04  -8.37500000E-05  -1.35900000E-05
   +1.84800000E-05  +2.62400000E-05  +2.15500000E-05  -1.30100000E-05  +3.65000000E-06
   +2.99300000E-05  +1.40720000E-04  +9.03400000E-05  +1.35400000E-05  +7.24200000E-05
   -2.13100000E-05  -2.49400000E-05  +6.67820000E-04  -2.35640000E-04  -3.92950000E-04
   -2.98400000E-05  -1.53300000E-05  -1.12700000E-05  -6.32000000E-06  +1.33100000E-05
   -2.77000000E-06  -1.57900000E-05  +3.46000000E-06  -4.10600000E-05  -1.08900000E-05
   +1.70000000E-06  -4.98000000E-06  +6.83000000E-06  +3.51000000E-06  -7.27000000E-06
   +1.88500000E-05  -3.22500000E-05  +1.84700000E-05  -1.61300000E-05  +4.43000000E-06
   -4.85000000E-06  -1.01500000E-05  +1.00600000E-05  -5.17000000E-06  -1.61100000E-05
   +4.10100000E-05  +1.43500000E-05  -1.18000000E-05  +6.13000000E-06  +1.51600000E-05
   +2.60200000E-05  -3.09300000E-05  -7.68000000E-06  -2.85420000E-04  +6.04600000E-05
   -5.24000000E-06  -6.82830000E-04  -4.46060000E-04  +1.80779000E-03  +4.50377600E-02
   +2.02070000E-04  -8.48730000E-04  -5.07500000E-05  -1.29970000E-04  +3.60430000E-04
   -1.45700000E-04  +2.66600000E-04  +1.89640000E-04  +1.28452000E-03  +3.61763000E-03
   +7.94200000E-05  -1.03761000E-03  +1.53091000E-03  -2.17141100E-02  +2.16410000E-02
   -3.49856000E-03  +2.79066000E-03  -1.17377000E-03  +1.91370000E-04  -9.37600000E-05
   +1.72400000E-05  -9.74200000E-05  +4.34900000E-05  -4.54500000E-05  +2.85936900E-02
   -2.22338730E-01  +2.44179980E-01  +1.45100000E-05  +1.12020000E-04  +1.09000000E-06
   -1.17400000E-05  -9.99000000E-06  -8.37000000E-06  -3.59300000E-05  +1.20000000E-05
   +3.95500000E-05  +1.20740000E-04  +1.03300000E-04  +2.75500000E-05  -2.29100000E-05
   -4.96900000E-05  -2.35000000E-05  -6.84000000E-06  -2.27800000E-05  -3.52700000E-05
   -1.54160000E-04  -1.29150000E-04  -1.17900000E-05  -7.23700000E-05  -1.33000000E-06
   +2.18400000E-05  -6.27180000E-04  +7.88100000E-05  +2.97910000E-04  +1.35800000E-05
   +3.12800000E-05  +4.25000000E-06  -1.66000000E-05  -1.37700000E-05  -1.93900000E-05
   +2.63900000E-05  +3.36800000E-05  +3.76900000E-05  +1.85000000E-05  +2.29000000E-06
   -6.87000000E-06  -1.01600000E-05  -3.73000000E-06  +4.35000000E-06  -2.40000000E-05
   +3.07100000E-05  -1.72800000E-05  +7.22000000E-06  -1.86400000E-05  +1.38500000E-05
   +1.06200000E-05  -8.56000000E-06  -7.75000000E-06  +2.30200000E-05  -2.02800000E-05
   -1.38200000E-05  +2.43000000E-06  -3.80600000E-05  -9.82000000E-06  -4.15200000E-05
   +5.07400000E-05  +2.55300000E-05  +1.02850000E-04  -1.66530000E-04  -1.37130000E-04
   +1.02019000E-03  +2.93640000E-04  -3.50520000E-04  -3.11470000E-02  +2.41162590E-01
   +2.39370000E-04  -2.53730000E-04  -6.58050000E-04  +1.10120000E-04  +5.63700000E-05
   -4.46000000E-06  +1.25080000E-04  +6.70000000E-04  +5.20080000E-04  +1.04568000E-03
   -5.33430000E-04  +1.52609000E-03  +1.56182000E-03  -3.07058000E-03  -5.65930000E-04
   +2.12643000E-03  -3.83225000E-03  +2.30116000E-03  -9.00800000E-05  +7.56800000E-05
   -1.24930000E-04  +9.95700000E-05  -5.66000000E-05  +5.07100000E-05  -8.03275000E-03
   +2.70648860E-01  -3.28423050E-01  +4.15200000E-05  -7.46400000E-05  -2.00000000E-06
   +9.39000000E-06  +1.35600000E-05  +3.04200000E-05  +4.81000000E-06  -1.64800000E-05
   -6.48000000E-06  -3.53100000E-05  -3.65600000E-05  -1.23300000E-05  +2.25100000E-05
   +3.02000000E-05  -1.87000000E-06  -1.22700000E-05  +4.55000000E-06  +1.95400000E-05
   +5.06200000E-05  +3.49200000E-05  -1.59000000E-06  +1.67700000E-05  +8.90000000E-07
   -2.04600000E-05  +8.17600000E-05  -8.06000000E-06  -1.72860000E-04  -1.00400000E-05
   -4.97000000E-06  +1.20000000E-06  -5.87000000E-06  +1.94000000E-06  -2.90000000E-07
   -5.28000000E-06  +3.32000000E-06  -2.75400000E-05  +1.89000000E-06  -9.68000000E-06
   +6.70000000E-07  +7.05000000E-06  +1.26000000E-06  -1.92000000E-06  +1.04800000E-05
   -1.25700000E-05  +1.61000000E-06  -7.32000000E-06  +2.22000000E-06  -7.70000000E-07
   -5.58000000E-06  +4.74000000E-06  -7.75000000E-06  +7.32000000E-06  +6.38000000E-06
   -5.81000000E-06  -2.85000000E-06  +8.57000000E-06  +1.70000000E-05  +1.75100000E-05
   -2.95400000E-05  -4.48700000E-05  -5.23700000E-05  -1.04990000E-04  -3.35100000E-05
   -1.69300000E-05  +9.17720000E-04  -4.34040000E-04  +2.56272000E-03  -2.64417190E-01
   +3.26034880E-01  +5.02737000E-03  -2.73885200E-02  +2.15630500E-02  -3.41370000E-03
   +3.70620000E-04  +4.15724000E-03  +1.12317000E-03  -1.38320000E-04  +6.47450000E-04
   -3.29970000E-04  +6.08740000E-04  -3.67150000E-04  -9.59150000E-04  -3.19930000E-04
   +5.22810000E-04  +8.77010000E-04  -2.48169000E-03  +1.56268000E-03  -1.54890000E-04
   -1.46310000E-04  +1.73800000E-04  -7.98900000E-05  +5.37000000E-05  +1.76200000E-05
   +3.78860000E-04  -9.44600000E-05  -2.83520000E-04  +1.55520000E-04  +1.66140000E-04
   -1.45310000E-04  +1.29320000E-04  +2.87380000E-04  +3.44700000E-05  -1.94270000E-04
   -1.60560000E-04  +1.41390000E-04  +1.37990000E-04  -4.84000000E-05  -1.14780000E-04
   -1.93000000E-06  -7.82800000E-05  +7.82000000E-05  +2.77700000E-05  +5.58500000E-05
   -1.16060000E-04  -2.07030000E-04  -1.90030000E-04  +3.17900000E-05  -7.85900000E-05
   -4.40400000E-05  -2.43200000E-05  -6.79016200E-02  +1.34365950E-01  -7.90132500E-02
   -2.81900000E-05  +3.49900000E-05  -3.16100000E-05  -2.82100000E-05  +2.09000000E-06
   -3.89200000E-05  +1.17900000E-05  +3.88900000E-05  +4.54000000E-06  +5.01600000E-05
   +4.43400000E-05  -2.63800000E-05  -6.72700000E-05  +2.97400000E-05  -2.05700000E-05
   -9.20000000E-06  +2.89500000E-05  -1.89200000E-05  -2.22400000E-05  -3.23900000E-05
   +1.53900000E-05  +3.47000000E-06  +2.04000000E-05  -3.40400000E-05  +9.79900000E-05
   -1.80860000E-04  -2.93790000E-04  +3.36000000E-06  +2.92900000E-05  -1.03000000E-05
   -1.70900000E-05  +1.41060000E-04  -1.00570000E-04  -1.94250000E-04  -8.02300000E-05
   +1.26870000E-04  -1.05472000E-03  +1.72864000E-03  -5.89200000E-04  -2.25500000E-04
   +1.34020000E-04  +1.34250000E-04  +6.69439200E-02  +2.03773000E-03  -6.29447000E-03
   +2.42622000E-03  -2.80930000E-04  +2.28520000E-03  -3.62190000E-04  +8.08610000E-04
   +3.44490000E-04  +5.13410000E-04  +1.09550000E-04  +3.01480000E-04  -2.16040000E-04
   +1.21280000E-04  -7.83440000E-04  +1.62850000E-04  +1.58002000E-03  +1.96583000E-03
   -4.88084000E-03  +1.50170000E-04  +1.13890000E-04  -4.30000000E-04  -6.84600000E-05
   -1.61820000E-04  -3.37420000E-04  +2.71510000E-04  -1.96480000E-04  -1.99230000E-04
   +1.07890000E-04  -3.59200000E-05  +1.53900000E-04  +3.93800000E-05  -2.89100000E-05
   -6.72600000E-05  +1.72000000E-05  -7.06900000E-05  +4.33100000E-05  +3.00300000E-05
   +8.47400000E-05  +5.94100000E-05  -3.79200000E-05  -4.21900000E-05  -2.05500000E-05
   -6.82600000E-05  +2.33600000E-05  +1.20700000E-05  -8.37000000E-05  -1.11930000E-04
   +5.23000000E-06  -4.66300000E-05  -2.79300000E-05  -4.64000000E-06  +1.02076520E-01
   -3.31755990E-01  +2.47808730E-01  -1.90300000E-05  +3.07800000E-05  -2.47500000E-05
   -2.42900000E-05  +2.60000000E-06  -4.53400000E-05  +1.77100000E-05  +5.48200000E-05
   +6.23000000E-06  +1.42800000E-05  -2.70400000E-05  -3.08000000E-06  -6.08000000E-06
   +6.65000000E-06  -1.24000000E-06  -1.70100000E-05  +2.39400000E-05  -9.86000000E-06
   -6.08000000E-06  -2.78800000E-05  +1.21300000E-05  +9.44000000E-06  +9.30000000E-06
   -1.65700000E-05  +1.22590000E-04  -1.95400000E-04  +4.40440000E-04  +5.07000000E-06
   -1.11000000E-04  +7.45200000E-05  -5.46200000E-05  -2.39300000E-05  +9.30100000E-05
   -1.24200000E-04  -8.87700000E-05  -8.61500000E-05  +4.02900000E-05  +9.82300000E-05
   +8.10570000E-04  +3.47500000E-05  +1.03140000E-04  -1.99400000E-05  -1.06756800E-01
   +3.34535360E-01  -7.84457000E-03  +2.91507500E-02  -2.69374200E-02  +5.18122000E-03
   -7.88300000E-04  -1.13270000E-03  -4.11290000E-04  +1.63736000E-03  -4.08120000E-04
   -1.46750000E-04  -3.15600000E-04  +7.07410000E-04  +5.44600000E-05  -1.72100000E-04
   -1.07041000E-03  -3.05702000E-03  -1.23684000E-03  +2.92948000E-03  -2.95000000E-05
   -2.10530000E-04  -4.54400000E-05  +1.64400000E-04  -4.42690000E-04  +7.20000000E-07
   -6.71420000E-04  +1.96700000E-04  +2.35640000E-04  -1.04760000E-04  -8.35400000E-05
   -6.14600000E-05  +8.84000000E-05  +8.06500000E-05  +2.05300000E-05  +3.25400000E-05
   -1.52200000E-04  -1.71000000E-06  -2.25920000E-04  -1.14420000E-04  +3.16300000E-05
   +1.63300000E-05  +5.23500000E-05  -1.73700000E-05  -1.86300000E-05  +6.50000000E-05
   -1.55100000E-05  +1.99310000E-04  +1.31850000E-04  -1.17000000E-05  +3.77300000E-05
   -3.88300000E-05  -4.92200000E-05  -4.69744400E-02  +2.18555300E-01  -1.85452220E-01
   -4.47500000E-05  -2.41100000E-05  -5.70000000E-06  -1.44700000E-05  +1.92000000E-05
   -1.98400000E-05  -1.05700000E-05  +2.05900000E-05  -8.48000000E-05  -1.23000000E-05
   -5.18800000E-05  +1.49000000E-05  +4.09500000E-05  -9.86000000E-06  +2.84000000E-06
   +2.34000000E-05  -2.36100000E-05  +5.16000000E-06  -9.27000000E-06  +1.66000000E-06
   +1.12800000E-05  -1.62700000E-05  +1.20800000E-05  -1.49900000E-05  -3.42000000E-05
   +2.16620000E-04  +2.55090000E-04  -7.44000000E-06  -3.52800000E-05  +6.89500000E-05
   +2.55800000E-05  -1.13730000E-04  +4.99700000E-05  +2.29450000E-04  -6.70200000E-05
   -2.88900000E-04  +1.30431000E-03  -2.78270000E-04  +5.35840000E-04  +2.18380000E-04
   -8.43500000E-05  +4.71600000E-05  +5.20171200E-02  -2.45896940E-01  +2.10700890E-01
end_hess

