# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.26185070    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.73439274E+00  -5.69232675E-01  +1.73162709E+00
   006   +2.29516622E+00  +1.25823930E+00  -1.48560343E-01
   006   +4.13747619E+00  +1.48548685E+00  -2.01094359E+00
   006   +6.31624622E+00  +2.87641857E-02  -2.09609606E+00
   006   +6.73968875E+00  -1.78125542E+00  -2.42092842E-01
   006   +4.90452703E+00  -1.97331784E+00  +1.57651718E+00
   006   -1.03072399E-01  +2.88220066E+00  -8.46549266E-02
   006   -5.67018458E-03  +4.59378392E+00  +2.26083144E+00
   008   +8.86242294E+00  -3.21190216E+00  -3.17024037E-01
   006   -2.44086771E+00  +1.17216381E+00  -1.32244697E-01
   006   -2.58405492E+00  -7.76445978E-01  -1.89012454E+00
   006   -4.69335052E+00  -2.31214745E+00  -2.07240591E+00
   006   -6.73808306E+00  -1.92114575E+00  -4.74516114E-01
   006   -6.63662414E+00  +1.09283564E-02  +1.29018725E+00
   006   -4.50871809E+00  +1.52824822E+00  +1.44615777E+00
   008   -8.86084340E+00  -3.36986618E+00  -5.56395695E-01
   006   -2.79797303E-01  +4.62207179E+00  -2.40566881E+00
   008   +1.02983548E+00  -9.03321987E-01  +3.61670568E+00
   001   -8.69035231E+00  -4.61866192E+00  -1.85238576E+00
   001   -4.74345554E+00  -3.82184838E+00  -3.45710763E+00
   001   -1.00052887E+00  -1.12563497E+00  -3.13931090E+00
   001   -4.48105252E+00  +3.00294164E+00  +2.85870774E+00
   001   -8.22817412E+00  +3.04482036E-01  +2.53805545E+00
   001   -2.04394900E+00  +5.68059389E+00  -2.30899370E+00
   001   +1.27393012E+00  +5.97720964E+00  -2.45599791E+00
   001   -2.88978623E-01  +3.55659823E+00  -4.16842865E+00
   001   -5.69813289E-02  +3.50985040E+00  +4.00627951E+00
   001   +1.73942172E+00  +5.68834092E+00  +2.22757191E+00
   001   -1.57756160E+00  +5.92734966E+00  +2.26549495E+00
   001   +3.87810300E+00  +2.86229462E+00  -3.49434422E+00
   001   +7.69703422E+00  +2.72206333E-01  -3.58355419E+00
   001   +8.86226608E+00  -4.35237145E+00  +1.08705298E+00
   001   +1.56348946E+00  -2.28116404E+00  +4.65988733E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +8.50000000E-07  -7.00000000E-08  +1.14000000E-06
   -1.70000000E-07  -1.90000000E-07  -9.50000000E-07
   -1.21000000E-06  +1.24000000E-06  -2.60000000E-07
   +2.00000000E-07  +1.00000000E-08  +1.00000000E-07
   -3.50000000E-07  +1.01000000E-06  -1.76000000E-06
   -5.20000000E-07  +1.70000000E-07  -9.00000000E-07
   +4.20000000E-07  +1.50000000E-07  -9.00000000E-08
   +1.20000000E-07  -1.00000000E-07  +5.20000000E-07
   +1.06000000E-06  -1.30000000E-07  -1.35000000E-06
   -8.70000000E-07  +5.80000000E-07  +2.11000000E-06
   -6.50000000E-07  -8.80000000E-07  -7.90000000E-07
   +1.43000000E-06  +3.70000000E-07  -7.00000000E-07
   -4.80000000E-07  +8.60000000E-07  +1.16000000E-06
   -5.80000000E-07  -1.54000000E-06  -3.20000000E-07
   +1.46000000E-06  -2.60000000E-07  -2.20000000E-07
   +1.90000000E-07  -7.70000000E-07  +1.30000000E-07
   -4.90000000E-07  +3.60000000E-07  +7.30000000E-07
   -4.00000000E-08  -4.30000000E-07  -7.60000000E-07
   -7.00000000E-08  +1.20000000E-07  -5.50000000E-07
   -1.80000000E-07  +3.40000000E-07  -4.00000000E-07
   -3.00000000E-07  +6.50000000E-07  -1.60000000E-07
   -1.10000000E-07  -8.90000000E-07  +5.00000000E-07
   +1.60000000E-07  -7.00000000E-07  +5.30000000E-07
   -1.50000000E-07  +1.60000000E-07  +9.50000000E-07
   -3.00000000E-07  +3.40000000E-07  +7.80000000E-07
   -4.70000000E-07  +7.90000000E-07  +4.20000000E-07
   +3.20000000E-07  -5.90000000E-07  +4.60000000E-07
   -1.40000000E-07  -3.20000000E-07  +9.20000000E-07
   +1.30000000E-07  -6.20000000E-07  +9.40000000E-07
   -2.00000000E-08  +4.20000000E-07  +4.30000000E-07
   +2.00000000E-08  +8.90000000E-07  -9.20000000E-07
   +2.90000000E-07  -8.00000000E-08  -1.15000000E-06
   +4.70000000E-07  -9.00000000E-07  -5.40000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.80688290E-01  -1.75945800E-01  +4.20394120E-01  -1.55453670E-01  -1.75201350E-01
   +4.98566760E-01  -1.16666420E-01  +6.70753200E-02  -4.31055000E-02  +5.31347840E-01
   +1.69696000E-02  -1.73650860E-01  +1.08832840E-01  -1.29001990E-01  +4.02239470E-01
   +1.68738400E-02  +6.68876600E-02  -1.70457870E-01  -1.46860150E-01  -1.68936850E-01
   +5.08101060E-01  +4.46216700E-02  -5.83969700E-02  +3.49411300E-02  -2.13002350E-01
   +2.90467400E-02  +9.30593800E-02  +5.63965470E-01  -2.72956100E-02  +1.24472500E-02
   +1.20671500E-02  -6.73174000E-03  -1.00093990E-01  +5.26538200E-02  -1.86398630E-01
   +4.62365080E-01  -1.68103000E-03  +3.83188500E-02  -4.17252900E-02  +1.37581310E-01
   +2.25272900E-02  -2.08010760E-01  -1.31049500E-01  -2.32928090E-01  +5.44600630E-01
   -2.03291700E-02  +3.50707000E-02  -2.25815900E-02  -4.03475900E-02  -5.62674000E-03
   +4.74404900E-02  -2.63374030E-01  +1.40631740E-01  +1.67263000E-03  +5.91655750E-01
   +3.30542600E-02  -3.98047800E-02  +2.32712200E-02  +2.01825400E-02  +2.99979000E-02
   -4.56643700E-02  +1.02978600E-01  -1.62644910E-01  +3.62334400E-02  -1.81504800E-01
   +4.17131510E-01  -2.07188300E-02  +2.25727200E-02  -6.50141000E-03  +1.57748700E-02
   -2.38417800E-02  +2.29604400E-02  +4.84039900E-02  +3.81713000E-03  -1.07104310E-01
   -1.84612680E-01  -2.09786380E-01  +5.34163640E-01  -4.51177600E-02  +1.54000100E-02
   +1.62932700E-02  -3.15960000E-04  -1.40819600E-02  +2.05202900E-02  +1.72184200E-02
   +1.45001000E-02  -3.10801600E-02  -1.11770180E-01  +5.45124700E-02  -3.01954700E-02
   +5.86958450E-01  -8.69850000E-03  +3.30370300E-02  -3.84469200E-02  -1.48330200E-02
   -1.28877300E-02  +3.22839200E-02  +4.67734000E-02  -3.07078800E-02  -4.48140000E-04
   +1.57702000E-03  -1.82886700E-01  +1.37589940E-01  -1.88637180E-01  +4.34460950E-01
   +4.55780000E-02  -5.99932900E-02  +2.91032500E-02  +2.12612200E-02  +3.17800900E-02
   -5.45168700E-02  -7.10889700E-02  +2.72582200E-02  +2.87613200E-02  +3.48823100E-02
   +9.23470500E-02  -2.11701010E-01  -1.49425980E-01  -1.91881400E-01  +5.09716890E-01
   -2.55232990E-01  +1.19421270E-01  +3.20247400E-02  +6.91125000E-03  +5.07565400E-02
   -6.04901100E-02  -5.76640100E-02  +1.82203500E-02  +2.58970700E-02  +3.67991800E-02
   -5.16914100E-02  +4.16868900E-02  -2.06382890E-01  +1.30802800E-02  +1.20944290E-01
   +5.52209150E-01  +1.37446110E-01  -1.51885200E-01  +7.79039000E-03  +1.85487200E-02
   -2.44467400E-02  +2.56125700E-02  +1.75783400E-02  -9.34732000E-03  -4.76077000E-03
   -1.89206500E-02  +1.45544000E-02  +1.17992400E-02  -5.73778000E-03  -7.95349300E-02
   +4.42581800E-02  -1.75198140E-01  +2.33575760E-01  +1.05585200E-02  +2.27600000E-02
   -8.54892700E-02  -2.11176100E-02  -2.12099000E-03  +3.01772500E-02  +2.76431000E-02
   -5.76047000E-03  -1.76162700E-02  +1.17618000E-03  +4.06960600E-02  -3.98127400E-02
   +1.43991360E-01  +2.80628100E-02  -2.06200820E-01  -2.14319200E-01  -6.67230600E-02
   +3.23272520E-01  -2.01741000E-03  +8.50856000E-03  -5.64086000E-03  -1.34900830E-01
   +4.11363500E-02  +7.63886000E-03  -1.79918300E-02  +1.14734400E-02  +3.84043000E-03
   +2.11132000E-03  +2.56750000E-04  +2.45924000E-03  -2.42809000E-03  +6.03940000E-04
   +2.01200000E-05  +2.72935000E-03  +2.51790000E-04  +9.94940000E-04  +4.68261480E-01
   +1.93589900E-02  -1.27554700E-02  +4.04693000E-03  +4.47975200E-02  -1.03229810E-01
   +5.73808000E-03  +1.39523000E-03  +5.13520000E-03  -5.05008000E-03  -5.28290000E-04
   +3.28701000E-03  +3.50779000E-03  -1.52050000E-04  -1.43326000E-03  +1.85920000E-04
   +1.44094000E-03  -2.61300000E-05  +3.51645000E-03  -1.41666000E-03  +4.74121800E-01
   -1.86327000E-02  +1.40879500E-02  +3.74603000E-03  +2.97477000E-03  +9.20437000E-03
   -8.14978800E-02  +1.51294400E-02  -1.31240800E-02  +4.70859000E-03  +3.47047000E-03
   +2.15121000E-03  -4.16590000E-04  +6.67700000E-04  -2.01940000E-04  -1.98237000E-03
   -8.84410000E-04  +5.22088000E-03  -1.62870000E-03  -5.03540000E-04  +6.69839000E-03
   +4.75683370E-01  -7.17630000E-04  -7.24200000E-05  +7.16570000E-04  -3.39870000E-03
   +1.75337500E-02  +2.29761600E-02  -1.01416000E-03  +2.17464000E-03  -8.17420000E-04
   -1.42726000E-03  -2.13290000E-04  -8.43270000E-04  +6.50300000E-04  -5.91880000E-04
   +6.54380000E-04  -1.78370000E-04  -8.32610000E-04  -6.88200000E-05  -7.59449700E-02
   -3.79720000E-04  +1.71850000E-04  +5.83054890E-01  +6.64030000E-04  -6.67700000E-05
   -1.15079000E-03  +6.94753000E-03  -1.70235400E-02  -1.72946400E-02  -8.84600000E-04
   -1.19022000E-03  +7.79140000E-04  +6.56920000E-04  -2.33100000E-05  +5.95750000E-04
   -2.84620000E-04  +2.69770000E-04  -4.13790000E-04  +5.56900000E-05  +8.20590000E-04
   -7.05700000E-05  -3.59132000E-03  -1.08358770E-01  -4.81769100E-02  -3.81522000E-03
   +5.40241210E-01  -2.61071000E-03  +1.47866000E-03  +1.98882000E-03  +6.78223000E-03
   -6.70977000E-03  -1.82297000E-03  -6.66270000E-04  +8.03600000E-05  -2.16820000E-04
   -3.13520000E-04  +4.41810000E-04  -1.99570000E-04  +8.00600000E-05  -4.96680000E-04
   +6.44870000E-04  +7.59590000E-04  -1.28870000E-04  -4.00950000E-04  -4.44486000E-03
   -4.33877400E-02  -1.39985350E-01  -6.85944000E-03  -6.86653500E-02  +5.18483220E-01
   +3.66587000E-03  -1.26149000E-03  +2.75260000E-03  -1.91368000E-03  +2.89305000E-03
   -2.65169000E-03  +6.07440000E-04  -7.46600000E-05  +3.25768000E-03  -7.59270000E-03
   +1.67314700E-02  -5.67956000E-03  -2.38772620E-01  +1.07963180E-01  +3.67304100E-02
   -4.13303400E-02  +2.37661700E-02  +1.21816600E-02  +1.53144000E-03  -8.12940000E-04
   +7.50480000E-04  -1.16876000E-03  +5.13450000E-04  -5.32920000E-04  +3.23350740E-01
   +1.46237000E-03  -5.11490000E-04  +5.09276000E-03  +2.12183000E-03  -6.77800000E-04
   -1.91456000E-03  -3.24496000E-03  +2.38723000E-03  +5.32543000E-03  +4.00730200E-02
   -2.28548200E-02  +5.79342000E-03  +1.31026910E-01  -1.42283560E-01  +9.43681000E-03
   +9.29402000E-03  +4.94167000E-03  -5.35740000E-03  -9.16170000E-04  +8.33980000E-04
   -6.31280000E-04  +8.86780000E-04  -3.85950000E-04  +4.14850000E-04  -1.70874020E-01
   +3.75593720E-01  -9.29290000E-04  +7.72575000E-03  -3.78169000E-03  -1.54386000E-03
   -2.57445000E-03  +3.74532000E-03  +7.06647000E-03  +2.61768000E-03  -4.84621000E-03
   -3.41232700E-02  +2.55809200E-02  +7.84255000E-03  +8.41933000E-03  +2.93478000E-02
   -8.58639100E-02  +3.02077200E-02  -1.78531300E-02  +2.81656000E-03  -2.31100000E-05
   -1.10110000E-04  +4.06200000E-04  -1.10300000E-04  +7.13400000E-05  -9.95200000E-05
   -4.68332400E-02  -2.83189420E-01  +4.14634650E-01  +1.01670000E-04  -1.78140000E-04
   +4.05700000E-05  -3.41649900E-02  -1.04174000E-02  +3.37188000E-03  -1.17646000E-03
   +5.03930000E-04  -2.08962000E-03  -3.38000000E-06  +9.05030000E-04  +5.12180000E-04
   -2.14470000E-04  -2.78000000E-04  +2.54180000E-04  +6.35200000E-04  -4.35160000E-04
   +7.79220000E-04  -1.39505890E-01  -4.53263500E-02  +3.33608000E-03  -1.09591000E-03
   -5.31745000E-03  -4.51359000E-03  -1.28690000E-04  +8.87000000E-05  -7.70100000E-05
   +5.66943040E-01  +2.89640000E-03  +1.27630000E-04  -1.27121000E-03  +8.97304000E-03
   +1.28622000E-02  -1.05189000E-03  +1.26839000E-03  -2.05684000E-03  +7.91140000E-04
   +6.39300000E-04  -1.16037000E-03  -3.63950000E-04  -4.24760000E-04  +1.14876000E-03
   -6.71570000E-04  -6.26550000E-04  -2.02100000E-04  +1.16620000E-04  -4.22698800E-02
   -1.09928720E-01  -1.13803300E-02  -1.69015000E-02  -1.49845200E-02  -2.03845000E-03
   +1.06579000E-03  -8.69270000E-04  +1.30360000E-04  +9.83148200E-02  +4.65589580E-01
   -5.41520000E-04  +4.78550000E-04  -5.03850000E-04  +3.22917000E-03  +1.54165000E-03
   -4.25430000E-04  +2.88690000E-04  -5.71480000E-04  +1.04800000E-04  +1.59660000E-04
   -3.02660000E-04  -1.50820000E-04  +5.70500000E-05  +1.84100000E-04  -1.99510000E-04
   -6.00800000E-05  -4.39000000E-06  +1.96800000E-04  +5.35379000E-03  -9.39239000E-03
   -8.04593700E-02  -2.33110600E-02  -1.74247600E-02  -6.21200000E-05  -1.21500000E-05
   -3.24100000E-05  +3.68500000E-05  -1.43808780E-01  +1.97634940E-01  +4.60311460E-01
   -5.82650000E-04  -2.60980000E-04  -6.82060000E-04  -8.34080000E-04  -2.52825000E-03
   -1.66283000E-03  +4.75680000E-04  -5.26520000E-04  -6.27120000E-04  -1.37330000E-04
   +4.73700000E-04  +3.49400000E-05  +2.01000000E-05  -1.26760000E-04  +1.97500000E-04
   +3.03220000E-04  -6.12600000E-05  +1.71100000E-05  -1.62534000E-03  -2.11781900E-02
   -1.89876100E-02  -4.87335000E-03  -3.04740000E-03  +1.09233000E-03  -1.79960000E-04
   +1.25910000E-04  -1.24800000E-05  -1.20567780E-01  +3.73405000E-03  +3.35776000E-02
   +6.46029930E-01  -9.95990000E-04  -6.64860000E-04  +1.26716000E-03  +1.25260000E-04
   -3.57500000E-04  -9.91500000E-04  +1.31570000E-04  +2.03000000E-06  -2.76340000E-04
   +1.13890000E-04  -1.49160000E-04  -1.93300000E-04  +1.14770000E-04  -6.45300000E-05
   -2.89300000E-05  -3.17200000E-05  +1.02780000E-04  -9.10500000E-05  -7.62980000E-03
   -1.57387200E-02  -1.15116500E-02  -2.26961000E-03  -4.45460000E-04  +7.08770000E-04
   -1.16700000E-04  +1.20490000E-04  -2.57400000E-05  -4.48825300E-02  -2.10087450E-01
   -1.05638650E-01  +1.35930130E-01  +4.71246450E-01  -9.73040000E-04  -8.83870000E-04
   +7.02360000E-04  -6.39690000E-04  -8.44530000E-04  -2.28150000E-04  +3.53110000E-04
   -1.16400000E-04  -6.29080000E-04  +5.83000000E-05  -1.38140000E-04  -2.29330000E-04
   +2.35970000E-04  -5.20000000E-05  +1.10270000E-04  +1.75260000E-04  -1.38230000E-04
   -6.44700000E-05  -5.66723000E-03  -2.01150000E-03  +3.30174000E-03  +9.47510000E-04
   +3.55900000E-04  -3.00300000E-05  -1.66560000E-04  +8.82100000E-05  -4.50900000E-05
   -1.22652700E-02  -1.33349170E-01  -1.88903350E-01  -1.70591450E-01  +2.26156550E-01
   +4.56191670E-01  +2.48630000E-04  -9.11300000E-05  +7.69800000E-05  +1.19910000E-04
   -6.84900000E-05  -3.11090000E-04  -2.69560000E-04  +2.90090000E-04  +3.95600000E-05
   +9.91000000E-05  -1.77020000E-04  +6.15000000E-05  +2.81280000E-04  -4.32700000E-05
   -1.92490000E-04  -3.57490000E-04  +1.77400000E-04  +1.52050000E-04  +3.63774000E-03
   +4.27730000E-04  +1.68396000E-03  +4.06640000E-04  +3.26060000E-04  +4.55760000E-04
   -2.21290000E-04  +1.52300000E-04  +1.36700000E-05  +2.86877000E-02  -5.18745000E-02
   -6.16424300E-02  -2.64744240E-01  -1.00585910E-01  +2.90932700E-02  +6.02468330E-01
   -3.23800000E-05  +1.52280000E-04  -2.94000000E-05  +6.90430000E-04  -5.69100000E-05
   +3.22420000E-04  -2.47910000E-04  +2.97000000E-04  +3.06880000E-04  -2.83600000E-05
   -5.06100000E-05  +9.36600000E-05  -1.86050000E-04  +7.25400000E-05  -5.20600000E-05
   -6.72100000E-05  +8.02200000E-05  -2.51900000E-05  +6.15630000E-04  +6.13430000E-04
   -5.76060000E-03  -1.17029000E-03  -5.90700000E-04  +2.65210000E-04  +1.72780000E-04
   -1.03680000E-04  +1.36500000E-05  -1.41648600E-02  -2.97007900E-02  -2.65184400E-02
   -1.47926590E-01  -1.78795450E-01  -2.43319500E-02  +1.52689870E-01  +5.03412160E-01
   -1.07560000E-04  +2.15890000E-04  -3.46680000E-04  +6.97670000E-04  +2.54470000E-04
   +1.17470000E-04  +9.10700000E-05  -7.22600000E-05  +1.21950000E-04  -7.76900000E-05
   +7.26800000E-05  +3.37300000E-05  -2.33440000E-04  +1.03580000E-04  +5.36900000E-05
   +1.62540000E-04  -1.03110000E-04  -3.31400000E-05  +1.79862000E-03  -4.43462000E-03
   -7.38920000E-04  -6.75710000E-04  -5.78520000E-04  +1.12300000E-04  +2.16330000E-04
   -1.70170000E-04  +7.63000000E-06  -2.58308700E-02  -4.17346000E-03  +1.96377000E-02
   -1.57224000E-02  -5.26220200E-02  -9.91082800E-02  -1.42965100E-01  +2.63800880E-01
   +4.58208180E-01  -7.18870000E-04  -2.38450000E-04  +4.36950000E-04  -1.30740000E-04
   +5.38600000E-04  -6.57000000E-05  +4.54400000E-05  -2.01360000E-04  +1.06920000E-04
   +2.09960000E-04  -1.81970000E-04  +3.09100000E-05  -7.21300000E-04  +5.22350000E-04
   -3.33400000E-05  +3.56090000E-04  -1.31030000E-04  -1.00550000E-04  -2.25007000E-03
   -2.74470000E-04  +7.56700000E-05  +3.70890000E-04  -2.03000000E-04  -2.94840000E-04
   +7.72650000E-04  -5.55840000E-04  +1.53100000E-05  -1.34105100E-02  +2.36918400E-02
   +2.70191100E-02  -5.17478700E-02  -3.31767300E-02  +1.09273000E-03  -2.26549810E-01
   +4.15173100E-02  +1.33952050E-01  +6.15177690E-01  -4.04100000E-05  -3.40400000E-05
   +6.33300000E-05  +2.12370000E-04  +7.63450000E-04  -2.39630000E-04  -2.46430000E-04
   +1.33200000E-04  +3.00050000E-04  +2.72010000E-04  -4.49980000E-04  +1.53050000E-04
   -4.81010000E-04  +5.90440000E-04  -3.01570000E-04  -8.46600000E-05  -5.78000000E-06
   +6.81300000E-05  +1.42540000E-04  -7.89840000E-04  -9.48570000E-04  +2.72620000E-04
   +8.16400000E-05  +2.27200000E-05  +6.84460000E-04  -5.27910000E-04  +4.61200000E-05
   +2.28949000E-02  -2.62274100E-02  -3.25452100E-02  +7.52222000E-03  +4.19207900E-02
   +3.28934100E-02  -1.63168800E-02  -1.17673170E-01  -3.60817400E-02  +1.37639800E-01
   +5.06329880E-01  +1.39370000E-04  +6.99200000E-05  +6.58400000E-05  +2.92320000E-04
   +3.54060000E-04  -2.40260000E-04  -3.80470000E-04  +2.06940000E-04  +2.46910000E-04
   +1.80860000E-04  -3.01200000E-04  +1.20480000E-04  -5.89600000E-05  +2.47940000E-04
   -2.77580000E-04  -2.62630000E-04  +1.00850000E-04  +9.10200000E-05  +9.43250000E-04
   -2.67440000E-04  -1.38842000E-03  +9.79600000E-05  -1.87200000E-05  +2.98810000E-04
   +2.04460000E-04  -1.65760000E-04  +2.82100000E-05  +2.67245200E-02  -3.33526100E-02
   -5.27629400E-02  +3.96120700E-02  +5.69393200E-02  +3.27104500E-02  +7.98365300E-02
   -7.08858400E-02  -1.83364630E-01  -1.43713040E-01  +2.41763550E-01  +4.76781730E-01
   -4.41760000E-04  -2.12740000E-04  +6.49130000E-04  -3.97330000E-04  -4.63360000E-04
   +8.50200000E-05  +2.07730000E-04  -1.13580000E-04  -2.56620000E-04  -1.07470000E-04
   +2.39420000E-04  -1.28680000E-04  +1.05740000E-04  -2.46980000E-04  +2.51280000E-04
   +2.57050000E-04  -1.15240000E-04  -1.87660000E-04  +3.27150000E-04  +8.67820000E-04
   +3.98892000E-03  +2.09810000E-04  +5.48780000E-04  +1.22970000E-04  -2.22290000E-04
   +1.82070000E-04  -4.06600000E-05  -4.80138900E-02  +4.81809000E-03  +3.72892900E-02
   -1.86414800E-02  -2.69996300E-02  -1.62233100E-02  +3.47267500E-02  +2.41079100E-02
   +6.94891000E-03  -1.20604320E-01  +1.92798400E-02  +4.85071400E-02  +6.52281890E-01
   -3.77630000E-04  -2.66680000E-04  +4.21490000E-04  -6.15950000E-04  -6.86120000E-04
   +2.51080000E-04  +2.49240000E-04  -1.79880000E-04  -3.65730000E-04  -1.82310000E-04
   +4.00030000E-04  -1.57980000E-04  +1.76690000E-04  -4.08640000E-04  +3.21180000E-04
   +3.31330000E-04  -4.06900000E-05  -1.21090000E-04  -1.86270000E-04  +2.68780000E-03
   -2.77679000E-03  -4.94600000E-04  -5.57800000E-04  -9.52100000E-05  -3.91970000E-04
   +3.17970000E-04  -5.48000000E-05  -3.16092900E-02  +3.90748900E-02  +4.82388800E-02
   -2.59476700E-02  -4.60534000E-02  -2.53272400E-02  +5.78461600E-02  +1.23988900E-02
   -3.11640400E-02  -3.51158800E-02  -2.07890690E-01  -1.07793190E-01  +1.44460240E-01
   +4.72714340E-01  +3.34810000E-04  +1.23130000E-04  -4.84670000E-04  +8.59840000E-04
   +6.50670000E-04  -5.22100000E-05  +3.17230000E-04  -2.16030000E-04  +1.84100000E-05
   -9.99700000E-05  +6.85100000E-05  -9.61100000E-05  +8.19700000E-05  -1.14140000E-04
   +8.74800000E-05  +5.78000000E-06  -3.55400000E-05  -2.91500000E-05  +4.03037000E-03
   -4.15626000E-03  +1.17724000E-03  -6.62510000E-04  -6.53200000E-04  -1.93610000E-04
   -1.15960000E-04  +9.10900000E-05  +4.89000000E-06  +3.39019000E-03  +2.72505700E-02
   +2.99809100E-02  -1.51565800E-02  -2.42890700E-02  -1.71313100E-02  +3.87083600E-02
   -1.09412200E-02  -2.50420700E-02  -2.92406000E-03  -1.41120530E-01  -2.02535780E-01
   -1.79900370E-01  +2.38149690E-01  +4.64543120E-01  -4.22570000E-04  +3.70200000E-05
   +3.64820000E-04  -1.14646000E-03  -1.75886000E-03  +2.61450000E-04  -6.77200000E-04
   +6.83030000E-04  +4.21000000E-06  +5.45100000E-05  -5.49900000E-05  +2.68300000E-04
   +5.05400000E-05  +4.59700000E-05  -2.26920000E-04  -3.24130000E-04  +2.04210000E-04
   +1.76160000E-04  -1.98132400E-02  -3.24970000E-04  +1.23634900E-02  -1.60304000E-03
   -5.16150000E-04  +1.27067000E-03  -7.37000000E-06  +2.12400000E-05  +2.50800000E-05
   -2.39950550E-01  -1.94625400E-02  +8.63332700E-02  +3.56598100E-02  +6.32350300E-02
   +4.37490600E-02  -6.45416000E-02  -1.69481000E-02  +2.06502600E-02  +3.28419400E-02
   -5.47726500E-02  -7.04722300E-02  -2.65818930E-01  -9.80768100E-02  +3.13397500E-02
   +5.95641590E-01  -2.80090000E-04  +3.38200000E-05  +7.73330000E-04  -1.40245000E-03
   -2.11632000E-03  +4.12180000E-04  -5.20300000E-04  +5.83840000E-04  -1.31370000E-04
   -6.57500000E-05  +1.32830000E-04  +1.69800000E-04  +1.32080000E-04  -1.43180000E-04
   +9.14000000E-06  -1.14550000E-04  +8.29600000E-05  -7.84600000E-05  -1.41947100E-02
   +6.60552000E-03  +1.15203400E-02  -1.09909000E-03  -5.30130000E-04  +6.83030000E-04
   -1.75960000E-04  +1.55940000E-04  -1.01000000E-05  +2.84858300E-02  -1.10859250E-01
   -5.80343700E-02  +2.63358900E-02  +1.09040600E-02  -1.31501700E-02  -1.49726600E-02
   -7.44457000E-03  +5.39849000E-03  -1.39932200E-02  -3.29472900E-02  -2.47564500E-02
   -1.45566530E-01  -1.77364510E-01  -2.28799500E-02  +1.42708780E-01  +5.04095260E-01
   +4.63100000E-05  +1.36580000E-04  -4.53150000E-04  -1.95203000E-03  -1.37024000E-03
   +3.11640000E-04  +3.09300000E-05  +3.63000000E-06  -1.56880000E-04  -1.94570000E-04
   +4.37510000E-04  +4.19100000E-05  +9.37400000E-05  -3.10050000E-04  +2.40320000E-04
   +2.33420000E-04  -8.99000000E-06  +7.02200000E-05  +5.78430000E-04  +3.60371000E-03
   +4.84657000E-03  -8.13450000E-04  +7.68120000E-04  +2.00960000E-04  -3.22350000E-04
   +2.37440000E-04  -3.29500000E-05  +1.31900450E-01  -2.98843700E-02  -1.74625960E-01
   +9.42175000E-03  -3.57933600E-02  -3.08752500E-02  +2.23224900E-02  +6.92943000E-03
   -1.04286300E-02  -3.17272900E-02  -1.80780000E-04  +2.12960100E-02  -1.41236100E-02
   -5.23827300E-02  -1.01520420E-01  -1.37470260E-01  +2.59579150E-01  +4.76355590E-01
   +4.23800000E-04  +1.03200000E-05  -5.56900000E-05  -6.66600000E-05  -1.00464000E-03
   +6.01100000E-05  +1.33990000E-04  +7.66600000E-05  -3.68970000E-04  -2.92490000E-04
   +4.12660000E-04  -1.39750000E-04  +8.61770000E-04  -7.65560000E-04  +2.14750000E-04
   -2.04060000E-04  +1.53840000E-04  +3.98300000E-05  +1.57236000E-03  +5.74400000E-04
   +6.63940000E-04  -5.83730000E-04  +4.06900000E-05  +2.99220000E-04  -1.04157000E-03
   +7.71940000E-04  -4.70100000E-05  -1.50392000E-03  -2.67341000E-03  -2.77652000E-03
   +2.49501000E-03  +3.35576000E-03  +6.10954000E-03  -4.35948500E-02  -3.30505000E-02
   +9.87720000E-04  -2.38973810E-01  -9.18790700E-02  +3.19690600E-02  -3.52411000E-03
   -1.47893900E-02  -7.26868000E-03  -6.32980000E-04  +9.08260000E-04  +4.08967000E-03
   +3.30875020E-01  +1.97230000E-04  -2.14400000E-05  -2.67700000E-05  -8.07200000E-05
   -8.21260000E-04  +2.39700000E-05  +1.26270000E-04  +1.84700000E-05  -2.96150000E-04
   -2.31830000E-04  +3.77490000E-04  -1.16720000E-04  +6.19230000E-04  -6.12860000E-04
   +2.05470000E-04  -9.64300000E-05  +1.33060000E-04  +2.23000000E-05  +1.14326000E-03
   +1.72230000E-04  +1.16860000E-03  -4.18220000E-04  -7.07000000E-06  +1.91760000E-04
   -7.97520000E-04  +6.13560000E-04  -3.87500000E-05  -3.09048000E-03  +8.13770000E-04
   +3.48426000E-03  -2.42577000E-03  -4.73900000E-04  -5.92067000E-03  -5.43133000E-03
   +4.64792000E-03  -1.20631000E-03  -1.26895260E-01  -1.44645070E-01  -1.89600700E-02
   -4.15987100E-02  -2.94939400E-02  -9.60323000E-03  +5.38290000E-03  +2.54785000E-03
   -5.85661000E-03  +1.24689380E-01  +4.24678500E-01  +1.49340000E-04  +7.85700000E-05
   -1.72830000E-04  -5.36000000E-06  -1.52830000E-04  +1.37740000E-04  +3.42500000E-05
   +3.03500000E-05  -9.73000000E-06  -6.95100000E-05  +6.88200000E-05  +8.96000000E-06
   +6.10000000E-05  -8.08500000E-05  +2.80100000E-05  -1.17100000E-05  +2.65000000E-06
   +7.12000000E-06  -1.66700000E-04  +4.20640000E-04  +6.92300000E-05  -5.07900000E-05
   -3.08200000E-05  -1.81900000E-05  -8.29600000E-05  +6.21600000E-05  +3.63000000E-06
   -2.89166000E-03  +3.48340000E-03  +3.63724000E-03  +7.37440000E-04  -9.26186000E-03
   -1.88007000E-03  +2.66516100E-02  +1.54010800E-02  +7.83238000E-03  -1.40849000E-03
   -4.05220100E-02  -8.07608300E-02  -3.26562800E-02  -2.59214400E-02  +2.77702000E-03
   +8.48934000E-03  -3.02322000E-03  -2.92953000E-03  -6.68215700E-02  +3.03310080E-01
   +3.56608600E-01  -5.08670000E-03  +2.71824000E-03  +1.49282000E-03  -4.37172000E-03
   +1.91101500E-02  -2.32145200E-02  -2.16442000E-03  +1.15828000E-03  -4.15300000E-04
   -2.13630000E-04  +5.86970000E-04  -8.37880000E-04  +5.11050000E-04  -6.38820000E-04
   +3.32980000E-04  -8.15500000E-05  +1.08986000E-03  -1.06892000E-03  -7.41434000E-02
   +1.49071000E-03  -1.79195000E-03  +5.79120000E-04  +2.56840000E-04  -1.70901000E-03
   -4.66520000E-04  +4.16990000E-04  -2.19500000E-05  -2.60451000E-03  -1.85007600E-02
   +2.22277400E-02  -5.91440000E-04  -8.98170000E-04  +9.15380000E-04  -2.86920000E-04
   +7.42300000E-04  +5.81700000E-05  +6.16700000E-04  +7.09790000E-04  +4.03930000E-04
   -1.11987000E-03  +1.41870000E-04  -1.30953000E-03  -6.17840000E-04  -1.70430000E-03
   -6.59950000E-04  -1.26991000E-03  -1.02447000E-03  -1.62330000E-04  +5.86284430E-01
   +2.54041000E-03  -3.95290000E-04  -7.75120000E-04  +6.87719000E-03  -1.51729600E-02
   +1.65593700E-02  +3.80250000E-04  -9.15570000E-04  -5.93490000E-04  -4.05990000E-04
   -4.05940000E-04  +5.96100000E-04  +4.59800000E-05  +1.50680000E-04  -1.38000000E-05
   +3.00200000E-05  -5.75280000E-04  +6.01510000E-04  +5.96899000E-03  -1.08416030E-01
   +4.78427200E-02  -3.20930000E-04  +1.06165200E-02  -1.42220300E-02  -4.98500000E-05
   -1.14300000E-05  +2.82000000E-05  -8.75724000E-03  -2.00993000E-02  +1.83496900E-02
   -4.78840000E-04  -3.53390000E-04  +1.22379000E-03  -7.65100000E-05  +7.97130000E-04
   -9.78900000E-05  +1.60470000E-04  +5.46000000E-04  +4.53210000E-04  -6.04050000E-04
   -1.61300000E-04  -9.86640000E-04  +1.47130000E-03  -9.86550000E-04  -5.91260000E-04
   -5.45220000E-04  -4.99910000E-04  -1.09100000E-04  +6.77113000E-03  +5.36765090E-01
   +1.73036000E-03  -1.12163000E-03  +1.85000000E-06  -4.34341000E-03  +2.08456000E-03
   +2.55380000E-04  +9.04380000E-04  -9.86300000E-04  -9.14700000E-05  +2.75550000E-04
   -1.12130000E-04  -2.07050000E-04  -3.28740000E-04  +2.82740000E-04  +1.04580000E-04
   +2.35800000E-04  -1.81920000E-04  +1.30830000E-04  -6.13516000E-03  +4.38989000E-02
   -1.35941930E-01  -1.55032000E-03  +1.43910700E-02  -3.81265900E-02  +3.34450000E-04
   -2.18130000E-04  -2.44100000E-05  +7.57086000E-03  +7.85000000E-03  -2.13142000E-03
   -1.59036000E-03  -1.24534000E-03  -4.23700000E-04  +2.00650000E-04  -2.02900000E-05
   -1.42010000E-04  +1.68310000E-04  +2.08130000E-04  +2.87940000E-04  -2.47300000E-05
   -2.39170000E-04  -1.17580000E-04  -9.20290000E-04  -1.45470000E-04  -1.15710000E-04
   -5.26770000E-04  -4.10660000E-04  -1.18950000E-04  -1.07021800E-02  +6.52522700E-02
   +5.13416610E-01  -1.83917050E-01  +1.43743000E-02  +1.08280640E-01  +9.07811000E-03
   -3.05401000E-03  +4.06907000E-03  -1.26492000E-03  +4.31508000E-03  -1.20357000E-03
   -1.35131000E-03  -3.07192000E-03  +4.32713000E-03  +1.91629000E-03  +5.17611000E-03
   -4.28461000E-03  -4.08978100E-02  +3.01655000E-03  +3.88371900E-02  -2.77424000E-03
   -6.06910000E-04  -6.81100000E-04  +1.34495000E-03  +8.15900000E-05  +1.20252000E-03
   -1.86831000E-03  -8.24400000E-05  +1.25110000E-03  -2.61133000E-03  -3.40940000E-04
   -2.75184000E-03  -2.43840000E-04  +1.71742000E-03  +5.53070000E-04  -1.49620000E-04
   -2.73000000E-06  +8.29800000E-05  +7.81200000E-04  -3.65600000E-05  -1.25320000E-04
   +7.79890000E-04  +6.49360000E-04  -2.19010000E-04  -3.49400000E-04  +6.96140000E-04
   -1.26599000E-03  -3.59690000E-04  -1.62610000E-04  -1.47540000E-04  +6.98150000E-04
   -1.90010000E-04  -3.22970000E-04  +3.00834300E-01  -8.84748000E-03  -8.21031900E-02
   +5.16545000E-02  -2.38190700E-02  +6.72750000E-04  +3.18615900E-02  +7.16650000E-03
   -2.75513000E-03  +2.10950000E-03  -2.69349000E-03  +1.91130000E-03  -1.05515000E-03
   +2.37647000E-03  -2.00874000E-03  +5.79526000E-03  +1.62920800E-02  +9.73983000E-03
   -1.58109300E-02  -2.38897000E-03  +5.03000000E-06  -3.07504000E-03  +1.83943000E-03
   -2.64246000E-03  -1.76031000E-03  +3.58220000E-04  +2.26470000E-04  -1.32257000E-03
   +8.39000000E-06  -1.57150000E-04  +6.46400000E-04  -3.79550000E-04  -1.53710000E-04
   +1.36410000E-04  +4.76360000E-04  +3.57390000E-04  -2.58650000E-04  -1.16220000E-04
   +1.53650000E-04  +2.33650000E-04  -2.06200000E-05  -5.80500000E-05  -6.53100000E-05
   +5.66220000E-04  -1.37070000E-04  +1.29830000E-04  +2.08870000E-04  +1.90460000E-04
   -4.14000000E-05  -3.05650000E-04  +4.20640000E-04  +5.04700000E-05  -1.37811370E-01
   +3.96669550E-01  +1.30862770E-01  +3.02465200E-02  -1.94190640E-01  +2.87720000E-02
   +1.45123700E-02  -3.29471800E-02  -4.17246000E-03  +4.04522000E-03  +2.32625000E-03
   +3.71137000E-03  -3.86780000E-04  -3.52584000E-03  -1.16836000E-03  +3.05473000E-03
   +1.32236000E-03  +2.32034800E-02  -4.88219000E-03  -6.57076000E-03  +2.40448000E-03
   -4.59111000E-03  +7.46820000E-04  -4.65510000E-04  +1.00853000E-03  -1.15361000E-03
   +6.40880000E-04  -8.55230000E-04  -6.20100000E-05  -1.93395000E-03  +1.92915000E-03
   -1.26324000E-03  -2.14600000E-05  +1.88240000E-04  -5.75530000E-04  -1.84230000E-04
   +8.35300000E-05  +4.91530000E-04  +1.89720000E-04  +3.06500000E-05  -1.51230000E-04
   -2.73620000E-04  -3.76380000E-04  +3.56960000E-04  -2.75930000E-04  -3.09500000E-04
   -5.66450000E-04  -4.81170000E-04  -3.52420000E-04  +9.30300000E-05  -2.86880000E-04
   -3.22100000E-05  +4.75240000E-04  -8.68974500E-02  -2.85792560E-01  +4.19601430E-01
   -8.69100000E-05  -1.28000000E-05  +3.89500000E-05  +7.40000000E-06  +4.42500000E-05
   -1.10300000E-05  -2.38400000E-05  +4.93000000E-06  +4.62000000E-05  +2.91300000E-05
   -2.06100000E-05  +2.26300000E-05  -1.31860000E-04  +7.83800000E-05  -9.48000000E-06
   +5.12500000E-05  +5.04000000E-06  -9.27000000E-06  -1.70890000E-04  +3.58200000E-05
   +1.04540000E-04  +7.04700000E-05  +2.15200000E-05  -2.44900000E-05  +1.30370000E-04
   -8.25600000E-05  +5.53000000E-06  -1.49390000E-04  +4.59760000E-04  +5.81180000E-04
   -6.51130000E-04  -2.08620000E-04  -2.09420000E-04  +1.56068000E-03  -9.21760000E-04
   -2.29960000E-03  -8.24070000E-04  -3.11913500E-02  -3.08610900E-02  -5.30200000E-03
   -3.55260000E-03  +1.09378000E-03  +1.50509000E-03  -8.48170000E-04  -7.07370000E-04
   -4.50578800E-02  +4.75693300E-02  +7.08166200E-02  +3.07600000E-05  -1.03100000E-05
   -1.41200000E-05  +9.35100000E-05  +3.76400000E-05  -2.14000000E-06  +5.01439800E-02
   -3.17600000E-05  +2.15800000E-05  -1.90800000E-05  +2.26100000E-05  +1.23280000E-04
   +5.78000000E-06  -2.18900000E-05  -8.10000000E-07  +5.40800000E-05  +3.44800000E-05
   -6.34400000E-05  +2.87400000E-05  -1.30870000E-04  +1.24330000E-04  -3.68100000E-05
   +2.43400000E-05  -3.40200000E-05  -3.85000000E-06  -1.97340000E-04  -6.03100000E-05
   -2.72500000E-05  +7.38300000E-05  -8.65000000E-06  -2.26200000E-05  +1.61420000E-04
   -1.30580000E-04  +7.19000000E-06  -4.90700000E-05  +5.04150000E-04  +4.42370000E-04
   +7.74100000E-05  -9.88700000E-04  -3.37560000E-04  +3.63539000E-03  +3.27609000E-03
   +1.69677000E-03  +1.73753000E-03  -2.37442600E-02  -2.11098300E-02  -4.69975000E-03
   -1.92200000E-05  +8.89840000E-04  +5.00480000E-04  +1.38070000E-04  -1.76947000E-03
   +1.20620800E-02  -2.57055070E-01  -2.49329520E-01  +1.00160000E-04  +3.70100000E-05
   +3.62900000E-05  +2.23600000E-05  -4.48500000E-05  +7.28800000E-05  -1.24652900E-02
   +2.77762990E-01  -1.01650000E-04  -3.93900000E-05  +1.05350000E-04  -7.90000000E-06
   +6.20800000E-05  -2.25100000E-05  -1.94800000E-05  -6.97000000E-06  +1.33500000E-05
   +2.71400000E-05  -2.26900000E-05  -8.67000000E-06  -4.96500000E-05  +3.25300000E-05
   +2.68000000E-06  +2.76300000E-05  -1.58000000E-06  -1.54200000E-05  -1.12770000E-04
   -2.52800000E-05  -1.50130000E-04  +2.67900000E-05  -2.41000000E-06  -1.49200000E-05
   +4.82000000E-05  -3.10800000E-05  -4.88000000E-06  +9.64500000E-05  +1.06370000E-04
   +2.07060000E-04  +5.56600000E-05  -2.00920000E-04  -8.74610000E-04  +2.02406000E-03
   +4.46825000E-03  +2.13167000E-03  +6.23050000E-04  -8.77120000E-04  -3.85107000E-03
   +2.53500000E-05  +1.89870000E-04  +2.17194000E-03  +6.18790000E-04  -9.36010000E-04
   +4.71740000E-04  +3.68386200E-02  -2.71163610E-01  -2.84681150E-01  +1.19980000E-04
   +7.20300000E-05  +5.38000000E-05  +1.12740000E-04  +4.30600000E-05  -5.19900000E-05
   -4.00568800E-02  +2.68653200E-01  +2.84916980E-01  -1.25000000E-05  -3.34200000E-05
   +1.21400000E-05  +1.03260000E-04  -4.08200000E-05  +2.03900000E-05  +1.94600000E-05
   +7.30000000E-06  -2.91600000E-05  -3.22200000E-05  +6.47100000E-05  +5.04000000E-06
   +3.28500000E-05  -6.44600000E-05  +2.39900000E-05  -7.50000000E-07  +4.46800000E-05
   +1.31000000E-06  +5.89990000E-04  -7.18440000E-04  -8.76090000E-04  -3.57890000E-04
   -1.34580000E-04  +1.08760000E-04  -6.65500000E-05  +6.77400000E-05  +2.70000000E-06
   -2.59091000E-03  -4.56631000E-03  +1.82192000E-03  +4.02279000E-03  -1.89835900E-02
   -1.88188400E-02  -5.60769400E-02  -9.47999000E-03  +5.01663000E-03  +4.42308000E-03
   +1.75188000E-02  +1.61433000E-02  -2.81843000E-03  -5.14120000E-04  +4.51665000E-03
   -1.61767000E-03  -3.19180000E-04  +1.33500000E-04  +2.04135000E-03  +2.46215000E-03
   -1.24956000E-03  -7.66000000E-06  +6.81300000E-05  -9.52300000E-05  +7.88000000E-06
   +5.88100000E-05  -2.12700000E-05  -8.65880000E-04  -1.06989000E-03  -1.66080000E-04
   +5.30191100E-02  +9.05300000E-05  +2.63500000E-05  -4.17900000E-05  +1.54090000E-04
   -1.16840000E-04  +3.07300000E-05  +1.00300000E-05  +3.09400000E-05  -2.59500000E-05
   -3.14500000E-05  +3.84500000E-05  +6.98000000E-06  +8.74300000E-05  -6.51300000E-05
   +2.50000000E-06  -3.53100000E-05  +2.03200000E-05  +1.47900000E-05  +3.12570000E-04
   -1.65050000E-04  -8.31430000E-04  -3.08520000E-04  -1.83120000E-04  +1.15640000E-04
   -1.00380000E-04  +7.29900000E-05  +1.62000000E-06  -4.86699000E-03  +2.32090000E-03
   -1.72003000E-03  +2.00460000E-03  -1.02605000E-02  -1.30145600E-02  -9.61367000E-03
   -1.96928290E-01  -1.47948760E-01  -4.87628000E-03  -2.43652000E-03  -3.13427000E-03
   -4.55000000E-06  +3.25554000E-03  -2.06696000E-03  -3.56700000E-05  -6.79600000E-05
   +7.97980000E-04  +1.97629000E-03  +7.18860000E-04  +3.17392000E-03  -6.29100000E-05
   -7.95000000E-06  -4.07900000E-05  -6.23200000E-05  -2.09900000E-05  -5.78000000E-06
   +1.00893000E-03  +1.53630000E-04  -9.91100000E-04  +1.30675100E-02  +2.05497850E-01
   -6.76000000E-05  -7.94500000E-05  +7.07000000E-05  -8.20700000E-05  -2.78200000E-05
   +3.71000000E-06  +3.18200000E-05  -1.80400000E-05  -6.04900000E-05  -2.26200000E-05
   +5.38400000E-05  -2.64600000E-05  +4.15200000E-05  -7.56800000E-05  +4.73100000E-05
   +1.60600000E-05  +3.62600000E-05  -7.17000000E-06  +4.02180000E-04  -1.57970000E-04
   +6.44800000E-05  -7.02800000E-05  +3.41700000E-05  +3.16200000E-05  -7.91000000E-05
   +7.45300000E-05  -6.80000000E-06  +1.26698000E-03  -2.27383000E-03  +4.53357000E-03
   +8.62860000E-04  -2.84880000E-04  +1.51976000E-03  +4.86470000E-03  -1.47935110E-01
   -1.74247400E-01  -4.75552000E-03  -1.65324500E-02  -8.61529000E-03  +4.96466000E-03
   -1.80780000E-03  +7.77650000E-04  +3.64530000E-04  +9.68320000E-04  -2.21750000E-04
   -1.79183000E-03  +2.85451000E-03  -1.91170000E-04  -4.81600000E-05  +3.77000000E-06
   -5.59500000E-05  +5.80700000E-05  +8.98200000E-05  -5.23500000E-05  +1.78708000E-03
   +2.37450000E-04  -2.63880000E-04  -5.79219000E-03  +1.63208570E-01  +1.79220630E-01
   -2.13370000E-04  -2.03100000E-04  -3.69510000E-04  -7.50500000E-04  -9.49270000E-04
   -8.08680000E-04  -3.69330000E-04  -2.05230000E-04  -1.63030000E-04  -7.06000000E-05
   +7.16100000E-05  +7.45100000E-05  -1.98050000E-04  +1.40830000E-04  +7.93100000E-05
   +1.98950000E-04  -5.62900000E-05  +6.04000000E-06  -9.26180000E-04  +3.46790000E-04
   -9.60160000E-04  -2.02400000E-05  +1.34830000E-04  -1.03380000E-04  +1.69610000E-04
   -1.39810000E-04  -8.18000000E-06  +4.16271000E-03  -3.10380000E-04  -3.62620000E-04
   -2.21341310E-01  +3.18937900E-02  +1.37072830E-01  -1.51378600E-02  +5.67037000E-03
   +1.65163200E-02  -6.70880000E-04  -5.00568000E-03  +2.49360000E-04  -6.55500000E-05
   -2.10520000E-04  -8.80980000E-04  +2.11794000E-03  -1.64749000E-03  +8.89490000E-04
   -1.44319000E-03  -3.55700000E-05  +7.74670000E-04  +2.40000000E-07  -1.27400000E-05
   +1.75230000E-04  -3.97100000E-05  +4.40000000E-05  +2.58040000E-04  +1.02230000E-04
   +2.15130000E-04  +1.33980000E-04  +1.01160000E-04  +1.11301000E-03  -1.52381000E-03
   +2.34039300E-01  +4.88500000E-05  +4.25330000E-04  -5.62480000E-04  -2.46730000E-04
   -8.67000000E-05  -1.22180000E-04  -2.51430000E-04  -4.54800000E-05  +8.48000000E-06
   -8.22100000E-05  +2.65000000E-05  +4.93600000E-05  -1.67370000E-04  +6.48600000E-05
   +9.18400000E-05  +1.90710000E-04  -2.07790000E-04  -2.09800000E-05  +1.48655000E-03
   -8.48730000E-04  +1.32605000E-03  +1.16240000E-04  +5.31700000E-05  +9.07200000E-05
   +1.98170000E-04  -1.78190000E-04  +2.13000000E-06  +1.89800600E-02  +1.82450000E-03
   -1.36226000E-02  +3.22073000E-02  -6.07802700E-02  -3.89516100E-02  -1.54561900E-02
   +6.61739000E-03  +1.18674300E-02  -4.70752000E-03  +1.01897000E-03  -3.56519000E-03
   -2.92850000E-04  -1.11097000E-03  +2.62570000E-04  -2.19140000E-03  -9.37120000E-04
   -5.76482000E-03  -9.74050000E-04  +5.29200000E-05  +6.26780000E-04  -1.72700000E-04
   -4.92650000E-04  -4.13990000E-04  -3.14530000E-04  -2.12250000E-04  +3.25490000E-04
   +6.88200000E-05  +1.05910000E-04  +1.00370000E-04  +1.55799000E-03  -1.17959000E-03
   +2.11018000E-03  -3.10278600E-02  +5.64682300E-02  +1.63350000E-04  +3.72990000E-04
   -5.77430000E-04  -7.17300000E-05  -3.29480000E-04  +2.34960000E-04  -4.32250000E-04
   +2.72840000E-04  +4.17270000E-04  -2.93000000E-06  -1.37950000E-04  +1.05110000E-04
   -3.31400000E-04  +1.31600000E-04  -5.16500000E-05  +4.80000000E-06  +1.02980000E-04
   -4.66700000E-05  +1.43140000E-04  +1.91306000E-03  -1.47286000E-03  -2.56130000E-04
   +1.06000000E-05  -1.90200000E-05  +3.47200000E-04  -2.26600000E-04  +1.61000000E-05
   +1.74126800E-02  -2.50262000E-03  -8.02436000E-03  +1.36391530E-01  -3.82033100E-02
   -1.54354980E-01  -2.78844000E-03  -7.22610000E-04  +4.63329000E-03  +6.13800000E-04
   -3.23133000E-03  +4.56095000E-03  -1.09164000E-03  +1.24870000E-04  -4.69250000E-04
   +8.48760000E-04  -6.17629000E-03  +3.64330000E-04  +5.84300000E-05  +9.90800000E-05
   +8.50400000E-05  -1.70000000E-05  +3.05900000E-05  -3.95000000E-06  -2.43700000E-04
   -4.70000000E-06  +2.74120000E-04  -3.50600000E-05  -6.90000000E-06  -2.92100000E-05
   -1.24540000E-03  +2.38004000E-03  -1.52354000E-03  -1.50347270E-01  +4.55542900E-02
   +1.56845510E-01  -9.56400000E-05  -2.01200000E-05  +2.29900000E-04  -1.36680000E-04
   -9.07000000E-05  -2.60650000E-04  -3.07700000E-05  -4.47900000E-05  -1.18700000E-05
   +7.10800000E-05  -3.17700000E-05  +6.86000000E-06  -6.41300000E-05  +7.46800000E-05
   -1.01100000E-05  +4.45100000E-05  -1.81100000E-05  -2.88300000E-05  +3.71320000E-04
   +1.37914000E-03  -1.10812000E-03  -3.89050000E-04  +3.64200000E-05  +6.21630000E-04
   +8.57800000E-05  -7.06900000E-05  -6.25000000E-06  +6.43997000E-03  +1.77760900E-02
   +1.60500900E-02  -2.93826000E-03  -7.07700000E-04  +5.02271000E-03  -1.35043000E-03
   -1.77330000E-04  -3.76000000E-06  -2.22707000E-03  -4.48229000E-03  +2.00494000E-03
   +3.14519000E-03  -1.94521800E-02  -1.81934300E-02  -5.53460500E-02  -6.84986000E-03
   +3.34662000E-03  +1.23450000E-04  -9.63780000E-04  -9.51410000E-04  +2.46060000E-04
   -2.63200000E-05  -9.19000000E-05  +1.32750000E-04  -1.72330000E-04  -1.31290000E-04
   -3.21710000E-04  -2.09210000E-04  -1.10540000E-04  -5.15600000E-05  +2.01490000E-04
   -2.12220000E-04  +1.48650000E-04  +1.05770000E-03  +9.20680000E-04  +5.37514400E-02
   +2.58440000E-04  +1.56600000E-04  -4.20970000E-04  +3.10330000E-04  +3.20000000E-04
   -1.50820000E-04  +6.96300000E-05  -7.33300000E-05  +6.33400000E-05  +3.99000000E-06
   -4.40700000E-05  +2.42700000E-05  -2.34100000E-05  +5.38200000E-05  -5.54000000E-05
   -8.20700000E-05  +1.06000000E-06  +7.15100000E-05  +5.86930000E-04  -2.08691000E-03
   +1.31448000E-03  -1.28669000E-03  -5.08000000E-06  +1.98850000E-04  +5.37900000E-05
   -4.79900000E-05  +1.90600000E-05  -4.10420000E-04  +6.88460000E-04  -3.57687000E-03
   -6.29140000E-04  +3.42102000E-03  -2.78995000E-03  -1.30000000E-06  -7.60400000E-05
   +9.46560000E-04  -4.63253000E-03  +2.87673000E-03  -2.23741000E-03  +1.00937000E-03
   -9.40697000E-03  -1.34323700E-02  -6.37589000E-03  -1.97824600E-01  -1.49776580E-01
   -1.16530000E-04  -8.21450000E-04  -7.78920000E-04  -4.10170000E-04  -2.23280000E-04
   +3.04600000E-05  -3.93310000E-04  -3.30000000E-05  +3.61030000E-04  -1.33570000E-04
   -1.99340000E-04  +6.98200000E-05  +1.75900000E-04  -3.48440000E-04  +2.66050000E-04
   -1.04270000E-04  -1.39740000E-04  -1.71900000E-05  +1.23371000E-02  +2.06241300E-01
   -1.13880000E-04  -7.07700000E-05  +9.88000000E-05  -2.14380000E-04  -7.46600000E-05
   +1.42200000E-04  -4.32500000E-05  +5.95100000E-05  -9.57000000E-06  -2.98000000E-06
   +2.89200000E-05  -6.13000000E-06  +4.77000000E-06  -2.95800000E-05  +7.88000000E-06
   +4.99000000E-06  +6.80000000E-06  -1.15000000E-05  -2.04681000E-03  +5.91840000E-04
   -1.85255000E-03  -5.78120000E-04  -8.87150000E-04  +4.31850000E-04  -3.12100000E-05
   +3.68600000E-05  -2.00000000E-06  -1.83398000E-03  -1.43903400E-02  -8.36266000E-03
   +5.06770000E-03  -2.40542000E-03  +1.18977000E-03  +7.15200000E-05  +9.61180000E-04
   -1.82700000E-04  +1.95175000E-03  -2.26339000E-03  +4.60167000E-03  +1.61698000E-03
   -6.81340000E-04  +2.38618000E-03  +3.78225000E-03  -1.50412730E-01  -1.87094080E-01
   -1.45010000E-04  -2.22400000E-04  -7.20300000E-05  +6.56520000E-04  +1.87570000E-04
   +1.34500000E-05  +2.17670000E-04  +4.96000000E-05  -3.79600000E-05  -3.30600000E-05
   +1.19730000E-04  -5.60200000E-05  -2.45910000E-04  +2.33780000E-04  -3.47820000E-04
   -1.38330000E-04  -7.23740000E-04  -5.99390000E-04  -5.23862000E-03  +1.66695820E-01
   +1.90978910E-01  -5.56700000E-05  -3.47000000E-05  +1.57530000E-04  -5.73400000E-05
   -2.27220000E-04  +4.17900000E-05  -4.03200000E-05  +5.50400000E-05  -4.19900000E-05
   -1.76000000E-05  +3.77600000E-05  -5.12000000E-06  +6.04600000E-05  -6.23100000E-05
   +2.16100000E-05  -2.72000000E-06  +2.44700000E-05  -1.41500000E-05  -2.24650000E-04
   +5.61340000E-04  +7.67570000E-04  -2.27200000E-05  +9.09900000E-05  +5.03500000E-05
   -8.23800000E-05  +6.32800000E-05  -9.52000000E-06  -1.21373000E-03  -5.08732000E-03
   +4.52160000E-04  -6.64900000E-05  -2.75280000E-04  -8.86530000E-04  +1.92062000E-03
   -1.55382000E-03  +7.83680000E-04  +3.01856000E-03  -2.43052000E-03  -9.88180000E-04
   -2.25489920E-01  +2.78072200E-02  +1.42200910E-01  -1.41124900E-02  +5.93534000E-03
   +1.57751500E-02  +2.44160000E-04  +1.33498000E-03  -1.04481000E-03  -1.82970000E-04
   -6.37600000E-05  -8.77100000E-05  +9.26500000E-05  +5.27900000E-05  -1.95000000E-04
   -7.10400000E-05  +1.75220000E-04  -1.35170000E-04  +1.95090000E-04  -3.67700000E-05
   -1.67710000E-04  -1.52110000E-04  +2.21000000E-04  -1.23220000E-04  +6.43000000E-06
   +1.23234000E-03  -1.58847000E-03  +2.36295470E-01  -2.73500000E-05  +4.02000000E-06
   -1.01700000E-05  -2.16670000E-04  -2.19950000E-04  +3.45800000E-05  -3.50000000E-07
   +1.59500000E-05  -3.56900000E-05  -3.07700000E-05  +5.27600000E-05  +7.59000000E-06
   +1.59400000E-05  -4.12200000E-05  +3.10100000E-05  +1.58300000E-05  -7.43000000E-06
   -2.23000000E-06  -5.14740000E-04  +4.75940000E-04  +3.37410000E-04  +5.96500000E-05
   +5.12900000E-05  +6.11600000E-05  -4.04100000E-05  +3.16500000E-05  -1.72000000E-06
   -4.64627000E-03  +9.93960000E-04  -3.07222000E-03  -4.71970000E-04  -1.30788000E-03
   +7.70500000E-05  -2.02105000E-03  -1.19662000E-03  -5.19333000E-03  +1.93088200E-02
   +2.22423000E-03  -1.46216400E-02  +2.67102300E-02  -5.67840900E-02  -3.68323400E-02
   -1.44686700E-02  +6.55839000E-03  +1.26550200E-02  +1.10829000E-03  -5.25000000E-05
   +2.65352000E-03  -5.42400000E-05  +3.85900000E-05  -4.94600000E-05  -9.00000000E-07
   -2.04500000E-05  +2.40500000E-05  +1.09060000E-04  +2.29600000E-05  +4.84740000E-04
   +9.70890000E-04  -1.78020000E-04  -7.14860000E-04  +1.83840000E-04  -2.16780000E-04
   +3.30000000E-04  +1.62862000E-03  -1.27108000E-03  +2.12848000E-03  -2.76506700E-02
   +5.08560000E-02  -1.40400000E-05  -7.15000000E-06  +5.48500000E-05  +1.09200000E-04
   +5.58100000E-05  -1.15100000E-05  -1.92800000E-05  +1.34900000E-05  +3.03000000E-05
   +2.12200000E-05  -2.66600000E-05  +4.60000000E-06  -2.73700000E-05  +3.11500000E-05
   -1.86200000E-05  -1.70000000E-07  +1.06200000E-05  -5.55000000E-06  -1.10460000E-04
   -1.04810000E-04  +2.82580000E-04  +1.21600000E-05  +4.93400000E-05  -4.25400000E-05
   +3.76400000E-05  -2.54500000E-05  +9.70000000E-07  +4.41630000E-04  -2.86203000E-03
   +4.27338000E-03  -1.16487000E-03  -1.34280000E-04  -5.08700000E-04  +3.91410000E-04
   -5.46185000E-03  +1.77450000E-04  +1.96468300E-02  -1.21680000E-03  -7.89413000E-03
   +1.41158260E-01  -3.76596300E-02  -1.56882140E-01  -3.46476000E-03  +1.73490000E-04
   +4.80999000E-03  -1.28923000E-03  +2.47932000E-03  -4.26860000E-04  -4.69000000E-06
   -5.40600000E-05  -8.20000000E-06  +4.06300000E-05  +9.39000000E-06  -5.38800000E-05
   -1.98220000E-04  +4.44110000E-04  -1.41400000E-05  +7.89950000E-04  -1.17790000E-04
   -6.02110000E-04  -1.29640000E-04  +3.14280000E-04  -3.21970000E-04  -1.20488000E-03
   +2.45313000E-03  -1.47013000E-03  -1.55020730E-01  +4.17188100E-02  +1.58641980E-01
   -1.92940000E-04  -7.09000000E-05  +5.04630000E-04  +7.41620000E-04  -8.83900000E-05
   -1.11990000E-04  -1.15950000E-04  -1.41190000E-04  +5.25250000E-04  +1.60950000E-04
   +2.00810000E-04  -2.62290000E-04  +8.42700000E-05  -1.04730000E-04  +8.91000000E-06
   -1.01710000E-04  +1.35180000E-04  -1.07920000E-04  -2.67828000E-03  +4.99250000E-04
   +7.07360000E-04  -8.50500000E-05  -1.77160000E-04  +5.56040000E-04  -2.00950000E-04
   +1.60860000E-04  -5.59100000E-05  +8.18770000E-04  -1.47080000E-03  +5.67300000E-05
   +3.38490000E-04  +2.93240000E-04  +2.44510000E-04  -2.58040000E-04  -2.08500000E-05
   -2.19400000E-05  +5.86200000E-05  -1.01000000E-04  -1.86160000E-04  +1.28780000E-04
   +1.33470000E-04  -2.11600000E-05  +1.60450000E-04  +7.14100000E-05  +1.72340000E-04
   +3.66400000E-05  +1.30800000E-05  +2.94300000E-05  -2.47148070E-01  +1.18866920E-01
   +1.27126700E-02  +2.46010000E-04  +3.62000000E-05  -2.99600000E-04  -8.39000000E-06
   +2.94000000E-06  -4.52000000E-06  -4.95000000E-06  +1.29000000E-05  -2.40000000E-06
   +2.72900000E-05  -6.06000000E-05  +2.33500000E-05  +3.20900000E-05  +3.98000000E-05
   -1.67800000E-05  +2.33800000E-05  +1.30900000E-05  +7.16000000E-06  +2.65310900E-01
   +1.38119000E-03  -2.15760000E-04  -4.39680000E-04  -5.31010000E-04  -1.68775000E-03
   +3.51539000E-03  -4.64770000E-04  +2.09590000E-04  +5.28340000E-04  +1.98830000E-04
   +8.67200000E-05  -1.59100000E-05  -3.07280000E-04  +2.06110000E-04  -3.65100000E-05
   +8.86000000E-05  -3.30720000E-04  +2.37730000E-04  +1.68166400E-02  -1.24125500E-02
   -5.12360000E-04  -3.95790000E-04  +3.21910000E-04  -1.31787000E-03  +2.16510000E-04
   -1.86610000E-04  -2.82000000E-05  +1.22449000E-03  +5.82310000E-04  -1.33300000E-04
   -1.76210000E-04  -4.00240000E-04  -5.87690000E-04  +2.16590000E-04  +6.74500000E-05
   -6.09700000E-05  -2.81860000E-04  -5.26100000E-05  +1.94160000E-04  -2.65730000E-04
   -1.16710000E-04  +8.37000000E-06  -2.29250000E-04  +1.77840000E-04  -2.09000000E-06
   +2.13610000E-04  +1.84000000E-04  +7.24000000E-06  +1.16995570E-01  -1.15877700E-01
   -8.58936000E-03  -3.31850000E-04  +4.40000000E-06  +2.08090000E-04  -8.76000000E-06
   -3.97000000E-05  -8.21000000E-06  +1.42100000E-05  -6.70000000E-07  +1.50000000E-05
   +9.39000000E-06  +1.37610000E-04  +1.37800000E-04  +3.18200000E-05  -2.46500000E-05
   +8.74400000E-05  +6.20000000E-06  -1.20100000E-05  -2.50000000E-07  -1.29255210E-01
   +1.25409080E-01  -1.35698000E-03  +8.81780000E-04  +3.84550000E-04  +5.89720000E-04
   +2.67424000E-03  -4.17267000E-03  +9.52100000E-04  +2.25740000E-04  -6.56840000E-04
   -2.66680000E-04  +6.56000000E-06  +3.52540000E-04  +1.94680000E-04  -2.58230000E-04
   +4.05900000E-05  +5.78000000E-06  +2.48050000E-04  -2.96790000E-04  -2.22183100E-02
   +1.40878600E-02  -9.89170000E-04  -1.28712000E-03  +9.31970000E-04  +1.16225000E-03
   -9.38400000E-05  +2.47700000E-05  +3.43900000E-05  -8.39680000E-04  -3.52950000E-04
   +4.51410000E-04  +4.24640000E-04  +7.99400000E-05  -6.11500000E-05  -4.43110000E-04
   -2.98400000E-05  +8.11900000E-05  +2.13110000E-04  -6.28300000E-05  -2.42740000E-04
   +1.97100000E-04  +1.46140000E-04  -4.36000000E-06  -1.67160000E-04  -1.13280000E-04
   +2.30550000E-04  -1.82070000E-04  -1.24450000E-04  -2.30000000E-06  +1.43510600E-02
   -9.78801000E-03  -4.68062300E-02  +1.21380000E-04  -1.45380000E-04  -1.20200000E-05
   +1.59600000E-05  +1.27800000E-05  +1.68500000E-05  +1.00100000E-05  -1.76700000E-05
   +1.43000000E-06  +1.42600000E-05  +4.92000000E-06  +6.46400000E-05  +3.12400000E-05
   -1.18400000E-05  -1.12600000E-04  -1.28000000E-06  +7.56000000E-06  +1.38300000E-05
   -1.48272900E-02  +5.89661000E-03  +5.25496300E-02  +9.33700000E-05  -1.93890000E-04
   -3.42500000E-05  +1.42000000E-04  +5.70600000E-05  +2.00970000E-04  -5.21650000E-04
   +8.92330000E-04  +6.52670000E-04  +1.54880000E-04  +8.01300000E-05  -1.67810000E-04
   -1.47510000E-04  +4.68600000E-05  -4.56200000E-05  +2.02300000E-05  -6.33000000E-06
   -9.50000000E-07  +1.22976000E-03  +2.27729000E-03  -4.33060000E-04  +3.00570000E-04
   +3.35860000E-04  -2.45330000E-04  +7.81200000E-05  -4.27100000E-05  -2.00000000E-05
   +4.77530000E-04  -7.45500000E-04  +2.97960000E-04  +3.08500000E-04  +4.36590000E-04
   +5.14270000E-04  -3.31610000E-04  -3.35100000E-05  +7.97900000E-05  +3.55320000E-04
   +1.10900000E-04  -1.31970000E-04  +6.66800000E-05  +4.81000000E-06  -2.62400000E-05
   +5.06030000E-04  -1.94610000E-04  -1.42220000E-04  -3.17720000E-04  -2.30210000E-04
   -1.33600000E-05  -1.99262810E-01  -1.31314930E-01  +2.53379000E-03  +6.77600000E-05
   +7.14800000E-05  +4.19000000E-05  +2.52800000E-05  +4.51200000E-05  +1.75400000E-05
   -3.05600000E-05  -1.51600000E-05  -2.38600000E-05  +6.90000000E-07  -3.07200000E-05
   -1.55500000E-05  -6.00700000E-05  +6.29200000E-05  -8.46000000E-06  -1.86900000E-05
   -4.32000000E-06  +7.06000000E-06  -1.90639100E-02  -1.86931200E-02  -2.56900000E-04
   +2.15852790E-01  -1.04600000E-04  -1.81060000E-04  +5.29370000E-04  -7.58840000E-04
   +6.52230000E-04  -3.42890000E-04  -1.07220000E-04  -4.99490000E-04  +9.75690000E-04
   +3.10840000E-04  +2.83910000E-04  -4.55490000E-04  -3.61000000E-05  -4.05500000E-05
   -4.74000000E-05  -7.64400000E-05  +1.31200000E-04  -8.92700000E-05  -1.48280200E-02
   -1.26389700E-02  -8.49270000E-04  -6.70000000E-07  +5.25240000E-04  -1.54552000E-03
   -1.20020000E-04  +1.43400000E-04  -6.98100000E-05  +2.85400000E-04  -1.52642000E-03
   +3.87783000E-03  -4.09300000E-04  -1.53080000E-04  +2.95320000E-04  +2.59860000E-04
   +2.00780000E-04  +4.19000000E-06  +1.63550000E-04  +5.59730000E-04  +4.86560000E-04
   -6.24950000E-04  -4.11270000E-04  -4.41660000E-04  +5.43500000E-04  -3.81500000E-04
   -3.37500000E-04  -5.27120000E-04  -4.27190000E-04  -1.01540000E-04  -1.30043650E-01
   -1.59623700E-01  +2.09423000E-03  +3.16010000E-04  +1.55300000E-04  -3.84370000E-04
   +2.72400000E-05  +5.07400000E-05  +4.29900000E-05  -2.27200000E-05  -5.44300000E-05
   -2.51400000E-05  -3.95100000E-05  +1.41330000E-04  -1.18610000E-04  +3.62000000E-05
   -5.10900000E-05  +1.61620000E-04  -8.97500000E-05  -2.80000000E-06  -3.70800000E-05
   +1.27185300E-02  +1.20285800E-02  -1.92180000E-04  +1.43525650E-01  +1.71912460E-01
   +2.25500000E-05  +3.40400000E-05  -3.00180000E-04  +2.90750000E-04  -7.31420000E-04
   +5.81700000E-04  -2.81610000E-04  -2.89850000E-04  +4.91100000E-04  -8.01200000E-05
   +9.95800000E-05  -1.17700000E-04  -9.39800000E-05  +3.96000000E-06  +1.28350000E-04
   +1.35960000E-04  -6.72800000E-05  -3.20100000E-05  +2.02614500E-02  +1.63219900E-02
   -1.44791000E-03  +1.04128000E-03  +8.02290000E-04  +1.33541000E-03  +4.54500000E-05
   -1.31800000E-05  -1.85000000E-05  -1.29800000E-03  +2.36880000E-03  -3.63950000E-03
   +3.58400000E-05  -3.34290000E-04  +3.82000000E-06  +6.98150000E-04  -5.50400000E-05
   +7.62800000E-05  -4.39640000E-04  -9.39000000E-06  +2.17170000E-04  +6.11500000E-05
   -2.64450000E-04  +2.40820000E-04  +5.96550000E-04  +5.30720000E-04  +1.18060000E-04
   +4.51280000E-04  +3.67470000E-04  +1.21100000E-05  +2.36655000E-03  +9.71170000E-04
   -4.85536000E-02  -3.78200000E-05  -7.33100000E-05  +3.26600000E-05  -5.08000000E-06
   -3.39300000E-05  -4.51000000E-05  +3.73000000E-05  +3.20300000E-05  +2.10700000E-05
   -2.42210000E-04  +3.55520000E-04  -9.67700000E-05  -1.32900000E-05  +1.05060000E-04
   -1.57670000E-04  +5.70000000E-05  +2.94700000E-05  -1.29900000E-05  +1.59864000E-03
   +1.45307000E-03  -9.81370000E-04  -3.26576000E-03  -4.33168000E-03  +5.07975800E-02
   +1.83620000E-04  +1.16290000E-04  -2.10160000E-04  +3.41730000E-04  -5.43620000E-04
   -2.34890000E-04  -3.06980000E-04  +4.44970000E-04  -8.09840000E-04  -7.02900000E-05
   -8.81300000E-05  +2.80480000E-04  -3.65500000E-05  +4.10000000E-05  -1.66200000E-05
   +3.25000000E-05  -7.12600000E-05  +6.11900000E-05  -1.90364000E-03  -1.35515000E-03
   -1.80978000E-03  -3.60700000E-05  +4.54680000E-04  -3.53970000E-04  +1.15330000E-04
   -1.14290000E-04  +4.21200000E-05  -1.98000000E-06  +5.88440000E-04  +6.61780000E-04
   -3.26000000E-06  -1.76680000E-04  -5.62200000E-05  -2.55010000E-04  -4.12200000E-05
   -5.30200000E-05  -1.64100000E-05  -1.25030000E-04  -7.70000000E-05  +1.06370000E-04
   +7.90600000E-05  +5.90200000E-05  -1.93570000E-04  -5.90100000E-05  +1.00590000E-04
   +5.96700000E-05  +5.44900000E-05  -2.44000000E-06  -4.69700900E-02  -1.12403000E-03
   -6.40280000E-04  -2.12740000E-04  -1.03740000E-04  +2.37850000E-04  -8.65000000E-06
   -2.27900000E-05  +7.67000000E-06  +2.12900000E-05  -1.29900000E-05  +2.06500000E-05
   +1.88300000E-04  -1.17360000E-04  +9.90800000E-05  +3.31000000E-05  +8.51000000E-06
   -6.95600000E-05  +7.50000000E-07  +8.15000000E-06  -9.00000000E-06  +8.27700000E-04
   +1.42642600E-02  +2.43024900E-02  +3.82970000E-04  -1.19996200E-02  -2.14353100E-02
   +4.85949200E-02  -2.36880000E-04  -9.71200000E-05  +6.03800000E-05  -1.23040000E-04
   +8.68090000E-04  -4.95430000E-04  +8.74860000E-04  +3.03110000E-04  -2.31000000E-04
   -2.63400000E-05  -1.35420000E-04  +1.96950000E-04  +1.16990000E-04  -4.86000000E-05
   -1.10880000E-04  -1.03090000E-04  +4.17400000E-05  +3.80300000E-05  -6.23400000E-04
   +1.01891200E-02  +1.67573600E-02  +1.60670000E-04  -1.98169000E-03  +2.76869000E-03
   -5.77700000E-05  +1.61900000E-05  +3.02900000E-05  +5.19920000E-04  +1.04639000E-03
   +2.39800000E-04  -3.91610000E-04  -7.32700000E-05  +5.88810000E-04  -1.32000000E-05
   -1.63050000E-04  -1.04250000E-04  +1.60000000E-06  -1.11400000E-04  -1.51630000E-04
   +1.18480000E-04  +1.37850000E-04  +1.31330000E-04  -1.56550000E-04  -3.04600000E-05
   -5.18000000E-05  +1.60540000E-04  +1.03470000E-04  +1.87500000E-05  -1.44985000E-03
   -1.23060410E-01  -1.21847330E-01  -1.93000000E-06  +2.93200000E-05  -2.95600000E-05
   -1.82100000E-05  -1.32200000E-05  -1.55800000E-05  -1.32000000E-06  +7.81000000E-06
   +2.16400000E-05  +4.89300000E-05  -6.31200000E-04  +1.23840000E-04  +1.87100000E-05
   -1.03600000E-05  +1.11100000E-05  +9.18000000E-06  -1.18000000E-06  -1.71000000E-06
   -1.34278000E-03  -8.66740000E-03  -1.31103900E-02  +1.89635000E-03  -1.03522200E-02
   -1.67180900E-02  -3.23100000E-05  +1.32026700E-01  +1.08610000E-04  +4.25110000E-04
   -3.95110000E-04  +9.90810000E-04  -9.37690000E-04  +8.58560000E-04  +5.56930000E-04
   +3.73470000E-04  -1.14940000E-04  -2.85010000E-04  +9.53200000E-05  +3.61860000E-04
   -4.08100000E-05  -1.91250000E-04  +1.14080000E-04  +1.65170000E-04  -1.41150000E-04
   +5.89000000E-06  +4.30220000E-04  -1.45509500E-02  -2.07142100E-02  -9.58000000E-06
   +4.90379000E-03  -4.24075000E-03  -2.29000000E-06  -3.79400000E-05  +2.16900000E-05
   -1.63201000E-03  -9.22540000E-04  +7.97050000E-04  +1.02210000E-04  -6.49380000E-04
   +1.63100000E-05  +6.56440000E-04  +3.40210000E-04  +1.76880000E-04  -2.68890000E-04
   +4.18780000E-04  +4.92600000E-04  -4.79280000E-04  -4.55490000E-04  -1.77200000E-04
   +9.44230000E-04  +1.06330000E-04  -2.78850000E-04  -6.75400000E-05  -4.12400000E-05
   -2.91600000E-05  -3.59440000E-04  -1.19440110E-01  -2.40430300E-01  -1.31190000E-04
   +5.92700000E-05  +3.30660000E-04  +2.09800000E-05  +1.44100000E-05  -6.00000000E-07
   +3.97000000E-05  +4.35000000E-06  -3.59000000E-06  -2.14670000E-04  +4.98030000E-04
   +1.00200000E-04  -1.45140000E-04  +7.23000000E-06  +8.76800000E-05  -5.83000000E-06
   +1.42600000E-05  -2.13100000E-05  -1.94860000E-04  -2.01700000E-04  -7.89690000E-04
   +1.08830000E-04  +1.47613000E-03  +1.73035000E-03  +4.38430000E-04  +1.30186730E-01
   +2.62542620E-01  -5.98110000E-04  +3.81750000E-04  +9.80330000E-04  +9.81500000E-05
   -4.31520000E-04  +2.08350000E-04  -1.97270000E-04  +4.28000000E-05  +4.45700000E-05
   +1.68920000E-04  -6.57200000E-05  -8.21000000E-06  -6.51800000E-05  +1.17830000E-04
   -2.98200000E-05  -1.73500000E-05  -1.41000000E-05  -2.72700000E-05  -1.67022000E-03
   +5.13710000E-04  -1.13032000E-03  -4.88233000E-02  -3.53008000E-03  +6.16259000E-03
   +5.70100000E-05  -5.00900000E-05  -1.66200000E-05  +2.44030000E-04  +5.15420000E-04
   -3.89550000E-04  -8.37600000E-05  -6.97500000E-05  -5.87100000E-05  +1.36410000E-04
   +1.07800000E-04  +2.11400000E-05  -9.52500000E-05  -3.58000000E-06  +3.89900000E-05
   -1.15240000E-04  +8.67000000E-06  +2.16960000E-04  +8.06200000E-05  -3.47050000E-04
   -5.25720000E-04  +1.00930000E-04  +1.09500000E-04  +3.42500000E-05  -4.72700000E-05
   -2.85750000E-04  -4.73210000E-04  +6.59300000E-05  +2.03130000E-04  -5.80190000E-04
   -9.02000000E-06  -1.03800000E-05  -4.79000000E-06  +1.38300000E-05  +1.12000000E-05
   +1.67800000E-05  -1.27600000E-05  +4.85000000E-05  +4.67900000E-05  -1.10198000E-03
   +2.40250000E-04  -3.85250000E-04  -9.10000000E-06  -1.90000000E-07  -2.25700000E-05
   +3.33490000E-04  -2.88910000E-04  +2.87730000E-04  +1.52700000E-04  +3.24160000E-04
   -2.09000000E-04  +6.82710000E-04  +9.70500000E-05  -1.58390000E-04  +4.90793500E-02
   +1.51406000E-03  +2.23790000E-04  -1.67577000E-03  -6.01080000E-04  +7.48360000E-04
   +7.04700000E-04  +2.38230000E-04  -6.80000000E-07  -3.09000000E-05  -2.08880000E-04
   +5.83200000E-05  +4.60000000E-05  +1.07730000E-04  -1.14030000E-04  +3.28600000E-05
   -2.29400000E-04  -1.50000000E-07  +1.94590000E-04  +4.64980000E-04  +1.16649800E-02
   -1.70134900E-02  -3.31347000E-03  -1.26863890E-01  +1.27093850E-01  -1.46180000E-04
   +8.38400000E-05  +1.94500000E-05  +1.82150000E-04  +8.65760000E-04  +3.43090000E-04
   +2.06550000E-04  -1.50380000E-04  +1.28200000E-05  +1.42110000E-04  +3.70400000E-05
   -4.34600000E-05  -1.33100000E-04  +3.28000000E-05  +1.67220000E-04  -2.05100000E-05
   -2.27320000E-04  -1.34260000E-04  -5.18840000E-04  +3.41840000E-04  +1.18750000E-04
   +6.21900000E-05  +8.26000000E-06  -2.61800000E-05  -1.75700000E-04  -2.25291000E-03
   -2.98226000E-03  +1.40190000E-04  -3.13092000E-03  +8.20630000E-04  -1.37600000E-05
   -6.42000000E-06  -8.67000000E-06  +5.69000000E-06  +1.74400000E-05  -1.28300000E-05
   -1.90000000E-05  +2.13800000E-05  -4.36500000E-05  -1.30640000E-04  -1.10170000E-04
   -1.88610000E-04  -1.14200000E-05  +3.15400000E-05  -2.19000000E-05  -2.45150000E-04
   -2.59300000E-05  -9.86700000E-05  +2.40000000E-04  -1.30500000E-05  -8.79200000E-05
   -1.26130000E-04  +8.32420000E-04  -1.17672000E-03  +3.94872000E-03  +1.36983490E-01
   +1.38581000E-03  -2.24310000E-04  -1.37734000E-03  -5.90520000E-04  +4.42090000E-04
   +6.74110000E-04  +3.78170000E-04  +8.24000000E-06  -1.30440000E-04  -1.99420000E-04
   +8.68800000E-05  +3.21700000E-05  -1.63000000E-06  -7.05700000E-05  +6.85800000E-05
   -3.44500000E-05  -1.90220000E-04  +7.69600000E-05  +2.77300000E-04  +1.46125700E-02
   -2.05638700E-02  +6.36212000E-03  +1.22648050E-01  -2.43170460E-01  -1.79400000E-05
   +1.67000000E-05  +3.41800000E-05  +7.77110000E-04  +1.06512000E-03  +9.48760000E-04
   -2.23800000E-05  -4.38640000E-04  -2.23900000E-05  +2.11550000E-04  +1.60470000E-04
   +1.09000000E-06  -9.84100000E-05  +1.50950000E-04  +1.36000000E-04  -2.50560000E-04
   -1.18560000E-04  +1.61620000E-04  +1.35830000E-04  -2.28090000E-04  -3.72100000E-05
   +5.20000000E-07  +5.93000000E-06  +1.35600000E-05  +1.36020000E-04  -4.57420000E-03
   -4.04239000E-03  -9.20750000E-04  +2.04514000E-03  +4.92720000E-04  -6.19000000E-06
   +5.76000000E-06  -7.59000000E-06  -1.63500000E-05  +2.34600000E-05  -2.75300000E-05
   -2.25100000E-05  +8.33200000E-05  +2.55300000E-05  -5.17730000E-04  +1.50980000E-04
   +1.68000000E-05  -1.97200000E-05  -2.08500000E-05  -9.31000000E-06  -1.48000000E-05
   -9.77100000E-05  +2.56460000E-04  +8.60400000E-05  -8.75700000E-05  +3.25580000E-04
   -1.48720000E-04  +9.88630000E-04  -1.49502000E-03  -6.33180000E-03  -1.34719680E-01
   +2.64933850E-01  -7.06000000E-06  -1.73350000E-04  +3.20630000E-04  +7.58830000E-04
   +1.38756000E-03  +2.48380000E-04  +3.73390000E-04  -2.04310000E-04  +6.35000000E-06
   +1.40000000E-05  +2.12000000E-06  -1.08370000E-04  -5.24900000E-05  +2.82700000E-05
   +9.20000000E-07  +2.76900000E-05  -3.05500000E-05  -4.56000000E-06  -1.50276000E-03
   +5.20980000E-04  +1.04520000E-03  -2.41885150E-01  -1.21128810E-01  +5.11679000E-03
   +4.65000000E-05  -2.87600000E-05  -3.35000000E-06  +6.41090000E-04  +1.24040000E-04
   +1.12380000E-04  +5.53600000E-05  +1.72600000E-04  +2.43340000E-04  -8.08200000E-05
   -8.60800000E-05  -9.86400000E-05  +1.10790000E-04  +8.24200000E-05  -1.63900000E-05
   +1.82570000E-04  -1.49830000E-04  -2.41740000E-04  -2.69130000E-04  +1.14450000E-04
   +4.04120000E-04  -1.71810000E-04  -1.70480000E-04  -5.11200000E-05  -1.55190000E-04
   +1.61310000E-04  +3.29340000E-04  +5.09400000E-05  +2.29000000E-06  -1.93540000E-04
   +1.70000000E-05  +2.05400000E-05  +9.54000000E-06  -2.88200000E-05  -1.33200000E-05
   -2.22800000E-05  +8.49300000E-05  -6.16200000E-05  -4.93200000E-05  +3.31530000E-04
   -9.36000000E-05  -4.58830000E-04  -8.29000000E-06  -1.74000000E-06  +1.88300000E-05
   +2.60600000E-05  -1.27290000E-04  +5.43100000E-05  +2.85850000E-04  +2.76280000E-04
   -5.15950000E-04  +2.85880000E-04  +2.40800000E-04  -4.25100000E-05  +3.59190000E-04
   +1.02437000E-03  -2.23200000E-05  +2.60192340E-01  -3.77400000E-04  -3.08470000E-04
   +7.64430000E-04  -1.16079000E-03  +4.96400000E-04  +2.72810000E-04  +3.95800000E-04
   +7.04200000E-05  -9.28400000E-05  +6.23400000E-05  +5.61700000E-05  -1.43530000E-04
   +1.15970000E-04  -1.73550000E-04  -1.56900000E-05  +7.66500000E-05  -3.71000000E-05
   +3.45400000E-05  -1.66089800E-02  -1.24977000E-02  +1.81200000E-04  -1.19497480E-01
   -1.20203450E-01  +4.73346000E-03  -1.96530000E-04  +1.75510000E-04  -5.43000000E-06
   +1.27141000E-03  -1.40538000E-03  -3.64833000E-03  -1.23723000E-03  -1.88030000E-04
   +1.67270000E-04  -4.88200000E-05  -3.42840000E-04  -1.14290000E-04  +3.05740000E-04
   +8.83000000E-05  -8.60800000E-05  -9.06200000E-05  +1.47890000E-04  +6.62400000E-05
   +5.66450000E-04  +7.91500000E-05  -4.41480000E-04  -2.71390000E-04  -1.71890000E-04
   +6.49000000E-06  +3.61380000E-04  +2.48760000E-04  +1.15784000E-03  +4.73880000E-04
   -2.23250000E-04  -2.63240000E-04  +3.41100000E-05  +3.45800000E-05  +1.75900000E-05
   -8.51100000E-05  -1.16680000E-04  +1.16000000E-05  +7.74000000E-06  +3.20100000E-05
   -8.19700000E-05  +8.55700000E-05  -5.89500000E-05  +3.28180000E-04  -4.27600000E-05
   -7.57000000E-06  -7.03000000E-06  +1.19850000E-04  +5.59000000E-05  -1.88400000E-05
   +9.51200000E-05  +6.03960000E-04  -1.06610000E-04  +2.58380000E-04  -3.88000000E-06
   +3.69900000E-05  -1.45525900E-02  -8.56708000E-03  -8.97460000E-04  +1.31626960E-01
   +1.30217970E-01  +1.05570000E-04  -5.37500000E-05  +2.03920000E-04  -1.01894000E-03
   +6.12340000E-04  +8.34540000E-04  +1.36900000E-04  +1.52690000E-04  +6.62400000E-05
   +4.14300000E-05  +5.55000000E-06  -9.70200000E-05  +9.86200000E-05  -4.28000000E-05
   -1.17000000E-05  -1.37550000E-04  +2.73000000E-06  +6.48100000E-05  -2.28665700E-02
   -1.46990300E-02  -1.38857000E-03  +7.47369000E-03  +5.79401000E-03  -4.71634900E-02
   -1.75050000E-04  +1.18320000E-04  -1.84900000E-05  +1.18097000E-03  -2.29645000E-03
   -4.31553000E-03  -1.48055000E-03  -8.40750000E-04  +2.80440000E-04  +1.49920000E-04
   -2.61640000E-04  -2.13520000E-04  +1.03990000E-04  +1.39860000E-04  -4.59000000E-06
   -1.97080000E-04  -1.93100000E-05  +1.90880000E-04  +8.55210000E-04  -2.92850000E-04
   -4.37110000E-04  -1.46020000E-04  -6.81500000E-05  +1.96500000E-05  -1.12879000E-03
   -8.62250000E-04  +1.22160000E-03  -8.86600000E-05  +3.13310000E-04  -2.19250000E-04
   +1.99300000E-05  +2.08300000E-05  +7.35000000E-06  -1.18310000E-04  -7.90200000E-05
   -2.91300000E-05  +7.10000000E-07  +3.84400000E-05  -1.84600000E-05  -1.00900000E-04
   +4.70320000E-04  +1.99240000E-04  -2.46700000E-05  -3.27400000E-05  +1.07500000E-05
   +5.53100000E-05  +3.00000000E-06  -6.86300000E-05  +3.04350000E-04  +3.58350000E-04
   -7.16000000E-04  +3.08150000E-04  +1.61940000E-04  +2.68320000E-04  +2.44408700E-02
   +1.26523000E-02  +8.87280000E-04  -6.99197000E-03  -1.16592000E-03  +5.14528600E-02
   -6.20500000E-05  -3.19290000E-04  +5.54250000E-04  +4.07090000E-04  +6.36610000E-04
   +5.93800000E-04  +7.01310000E-04  +1.40850000E-04  -2.85850000E-04  -1.43840000E-04
   +1.63570000E-04  -1.12250000E-04  +2.27230000E-04  -2.61110000E-04  +7.95200000E-05
   -5.65000000E-05  -3.12800000E-05  +1.32400000E-05  +5.66020000E-04  -1.43101000E-03
   -2.08360000E-04  -2.03425830E-01  +1.31247560E-01  -1.82506000E-03  -2.96140000E-04
   +2.28740000E-04  -9.56000000E-06  -7.08800000E-05  -2.45800000E-05  +3.14070000E-04
   +9.67800000E-05  +7.04300000E-05  +2.62000000E-06  +7.48400000E-05  +2.75200000E-05
   -2.13400000E-05  -1.99720000E-04  +1.35800000E-05  +4.08400000E-05  +1.07070000E-04
   -1.98900000E-04  -2.65930000E-04  -1.11123000E-03  -1.01331000E-03  +5.18570000E-04
   +9.67600000E-05  +2.60800000E-05  -2.41500000E-05  +3.46030000E-04  -3.32260000E-04
   -4.83390000E-04  +2.31100000E-04  -1.12430000E-04  -2.17960000E-04  -1.93000000E-05
   -1.25300000E-05  -7.61000000E-06  +1.36500000E-05  +2.04800000E-05  -2.32000000E-06
   -1.25400000E-05  -3.09000000E-06  -1.39500000E-05  -8.93900000E-04  -1.73208000E-03
   -1.47450000E-04  +2.78100000E-05  -2.80000000E-06  +2.36000000E-05  +3.79070000E-04
   -1.43020000E-04  +2.86210000E-04  -2.17010000E-04  +1.26190000E-04  +7.97500000E-05
   +2.05900000E-04  -2.73370000E-04  +2.02300000E-05  +1.18953000E-03  -2.18264000E-03
   -1.09800000E-04  -1.97217300E-02  +1.83102200E-02  -8.16940000E-04  +2.21615330E-01
   +7.60700000E-05  +1.87320000E-04  +1.61820000E-04  -8.00010000E-04  -1.06078000E-03
   -3.71808000E-03  -9.28800000E-05  -5.40770000E-04  +3.19640000E-04  +5.22440000E-04
   -1.46980000E-04  +1.60090000E-04  -2.83880000E-04  +3.65340000E-04  -2.85550000E-04
   +7.29600000E-05  +1.41760000E-04  +7.38900000E-05  +1.52859000E-02  -1.26095300E-02
   +8.06020000E-04  +1.29958640E-01  -1.56663080E-01  +1.48500000E-03  +4.37320000E-04
   -3.51930000E-04  +2.55800000E-05  +7.01470000E-04  +5.76050000E-04  +4.29290000E-04
   -3.09430000E-04  -1.60400000E-04  -1.56870000E-04  +1.79950000E-04  +1.80280000E-04
   +4.86200000E-05  -6.54100000E-05  -2.25000000E-06  +9.73400000E-05  -3.50230000E-04
   +1.94990000E-04  +3.30160000E-04  +8.12400000E-05  -5.72360000E-04  -7.82180000E-04
   +8.87300000E-05  +1.34100000E-04  +5.91600000E-05  +7.91500000E-05  +5.09750000E-04
   +1.66112000E-03  -2.39320000E-04  -5.97980000E-04  +4.86100000E-05  -3.80000000E-06
   -1.37200000E-05  -5.60000000E-07  +7.50000000E-06  -8.30000000E-07  +2.06200000E-05
   +2.41000000E-05  +7.56600000E-05  +1.29540000E-04  -1.27053000E-03  -8.73660000E-04
   +6.82620000E-04  -1.56600000E-05  -3.23900000E-05  -1.53000000E-05  -3.28320000E-04
   +6.59640000E-04  -3.41880000E-04  -1.26700000E-04  -1.49500000E-05  -1.30250000E-04
   -3.37770000E-04  +3.61000000E-05  +1.40600000E-04  +1.28371400E-02  -1.02434800E-02
   -1.24714000E-03  -1.34927000E-02  +1.21683100E-02  -1.75040000E-04  -1.42784520E-01
   +1.68661400E-01  +1.29392000E-03  +1.79800000E-04  -1.45082000E-03  -6.14810000E-04
   -2.82783000E-03  -3.99478000E-03  +2.63060000E-04  -5.92460000E-04  +2.81310000E-04
   +3.97970000E-04  -3.21300000E-05  +3.08960000E-04  -2.09970000E-04  +2.54540000E-04
   -2.81310000E-04  -6.98300000E-05  +1.43150000E-04  +1.03700000E-04  +2.08781800E-02
   -1.61008500E-02  -1.20419000E-03  -2.85224000E-03  +2.79653000E-03  -4.77985100E-02
   +4.33220000E-04  -3.21120000E-04  +6.20700000E-05  +1.51930000E-04  +5.35430000E-04
   +6.19930000E-04  +7.29000000E-06  +6.50000000E-07  -2.22740000E-04  +1.16490000E-04
   +7.09600000E-05  -2.36600000E-05  -1.33180000E-04  +3.07400000E-05  +1.42620000E-04
   -8.06600000E-05  -1.49760000E-04  -1.22290000E-04  -3.82980000E-04  +3.63520000E-04
   +4.05350000E-04  +5.92200000E-05  +2.64200000E-05  -2.29300000E-05  +1.30146000E-03
   -9.71710000E-04  +1.06842000E-03  -8.78550000E-04  +6.02740000E-04  +9.27310000E-04
   -6.97000000E-06  -1.48900000E-05  -3.68000000E-06  +1.89300000E-05  -7.63000000E-06
   +9.23000000E-06  +4.20000000E-05  -6.69000000E-06  +3.73900000E-05  +1.17280000E-04
   +5.05200000E-05  +2.20960000E-04  +9.01000000E-06  -5.20000000E-07  +8.43000000E-06
   -5.22510000E-04  +6.05900000E-05  -8.33170000E-04  +6.09500000E-05  +1.33720000E-04
   -6.12800000E-05  -1.77750000E-04  +1.60570000E-04  +4.11970000E-04  -2.20532800E-02
   +1.58273500E-02  +1.46470000E-03  +9.34910000E-04  -6.25080000E-04  -1.02380000E-03
   +1.94712000E-03  +4.41660000E-04  +5.11088100E-02  -1.22463000E-03  +1.48319000E-03
   +4.41033000E-03  +7.63214000E-03  -1.40338100E-02  +1.46137700E-02  -5.86855000E-02
   +3.08597100E-02  -2.10966200E-02  +3.94330000E-04  +1.82196800E-02  -1.92310900E-02
   -2.18099000E-03  +4.85935000E-03  +1.57184000E-03  -1.23985000E-03  +6.78500000E-05
   +7.10080000E-04  -2.94790000E-04  -1.65020000E-03  -1.25580000E-03  +3.84930000E-04
   +5.10900000E-05  -1.44030000E-04  -1.38060000E-04  +8.91070000E-04  -1.04442000E-03
   -2.78550000E-04  +1.35190000E-04  -6.47600000E-05  -3.91700000E-05  +1.26280000E-04
   +8.25300000E-05  +1.24600000E-05  -4.71000000E-06  -7.01700000E-05  -6.73300000E-05
   -7.12000000E-05  -5.93000000E-06  +2.99200000E-05  +3.33900000E-05  +3.59700000E-05
   -4.11900000E-05  -2.00700000E-05  -2.51900000E-05  +1.05180000E-04  +7.76400000E-05
   +1.53000000E-06  -2.54104000E-03  +1.42602000E-03  +1.16255000E-03  +1.17890000E-04
   -1.07065000E-03  +1.08533000E-03  -1.30000000E-05  -1.92000000E-05  -7.00000000E-07
   +7.67000000E-06  +4.63000000E-06  +1.31000000E-05  +7.67900000E-05  -8.50600000E-05
   +1.19100000E-05  -6.70000000E-06  -9.98000000E-06  +1.95000000E-06  +9.03000000E-06
   -6.30000000E-06  +9.10000000E-07  +1.12480000E-04  -2.06350000E-04  -1.04460000E-04
   -5.23480000E-04  +8.79430000E-04  +1.25620000E-04  -2.02493000E-03  +5.44660000E-04
   -4.94500000E-04  +1.83100000E-05  -6.30600000E-05  -1.43130000E-04  +3.14800000E-05
   -3.07400000E-05  +2.77400000E-05  -4.13900000E-05  -4.35300000E-05  -4.23900000E-05
   +6.13264300E-02  +1.50829000E-03  +3.43754000E-03  +2.04732000E-03  +6.04870000E-04
   +1.85300000E-03  +2.55441000E-03  +2.99991700E-02  -1.79222290E-01  +1.48587110E-01
   +1.48556000E-03  -7.97097000E-03  +1.36834600E-02  +4.56830000E-03  +2.33294000E-03
   +1.34575000E-03  +5.39100000E-05  +1.91360000E-04  -6.67870000E-04  -7.98530000E-04
   -2.64567000E-03  -1.08820000E-03  +4.77100000E-04  -2.46140000E-04  -7.98900000E-05
   +1.56070000E-04  -7.59720000E-04  +6.94610000E-04  -2.80040000E-04  +3.94130000E-04
   +2.78630000E-04  -1.25010000E-04  +1.05240000E-04  +1.59040000E-04  +5.94000000E-06
   -3.62300000E-05  -6.39800000E-05  +2.58000000E-05  +3.98300000E-05  +1.55300000E-05
   -7.02000000E-06  -1.39700000E-05  +5.25000000E-06  -1.17130000E-04  -1.28970000E-04
   -9.01500000E-05  -3.39300000E-05  -4.22400000E-05  -1.98900000E-05  +2.96834000E-03
   -6.32580000E-04  -3.85860000E-04  -2.45400000E-05  -1.48570000E-04  +3.66800000E-05
   -6.38000000E-06  +9.30000000E-07  +8.95000000E-06  -1.08700000E-05  -1.64000000E-05
   +5.96000000E-06  +1.23200000E-05  -1.03470000E-04  +2.99100000E-05  +1.55800000E-05
   -1.80000000E-06  -9.54000000E-06  -9.92000000E-06  -1.49000000E-05  +1.85000000E-06
   +1.31730000E-04  -1.55920000E-04  -5.48630000E-04  +1.43355000E-03  -9.41630000E-04
   -2.59330000E-04  +1.12320000E-04  -2.85670000E-04  -3.66320000E-04  -9.52000000E-06
   -1.62000000E-05  -1.13500000E-05  -1.32600000E-05  -7.77000000E-06  -6.92000000E-06
   -5.15100000E-05  -3.01900000E-05  -1.43140000E-04  -4.05702600E-02  +1.86770130E-01
   +4.53923000E-03  +1.79001000E-03  +1.54100000E-05  -3.60109000E-03  +1.55570100E-02
   -1.18557100E-02  -2.03995400E-02  +1.48136860E-01  -2.04382430E-01  +1.79850000E-03
   -1.09719000E-03  +3.93633000E-03  +2.06002000E-03  +1.24422000E-03  +3.25101000E-03
   +4.55680000E-04  -5.89600000E-04  +1.73000000E-05  -2.27529000E-03  -4.23900000E-04
   -1.68453000E-03  +5.80920000E-04  -1.90300000E-04  +4.70000000E-05  -1.61900000E-04
   +5.59000000E-05  -6.22000000E-06  -2.20350000E-04  +1.43770000E-04  +1.99330000E-04
   +4.61000000E-06  +1.98800000E-05  +8.73100000E-05  -1.89800000E-05  -2.87900000E-05
   +1.27500000E-05  +3.54500000E-05  +3.71000000E-05  -6.24000000E-06  -1.72000000E-06
   -1.78000000E-05  +1.98000000E-06  -5.71000000E-05  -8.68300000E-05  -3.17600000E-05
   -5.45200000E-05  -5.08300000E-05  -8.59000000E-06  -8.16010000E-04  +1.04007000E-03
   +4.78400000E-04  -1.75430000E-04  +9.79040000E-04  -1.11710000E-03  -1.84000000E-06
   +9.54000000E-06  +1.92000000E-06  -9.09000000E-06  -6.57000000E-06  -5.48000000E-06
   +1.17300000E-05  +2.89200000E-05  -3.63800000E-05  +4.75000000E-06  +9.76000000E-06
   -1.62400000E-05  -1.02000000E-05  -2.44000000E-06  -2.20000000E-06  -6.12770000E-04
   -2.61750000E-04  +3.39940000E-04  -7.83700000E-05  -1.00324000E-03  +5.25500000E-05
   -4.64430000E-04  +3.47400000E-04  +3.91480000E-04  -5.67200000E-05  +1.28300000E-05
   +6.86400000E-05  -4.39000000E-06  -3.53300000E-05  -6.81400000E-05  +3.44200000E-05
   -1.21690000E-04  -1.61440000E-04  +2.07830200E-02  -1.63447660E-01  +2.11467640E-01
   -9.75340000E-04  +1.15520000E-04  -8.84840000E-04  -1.50919000E-03  +4.14776000E-03
   +1.27650000E-04  -1.18638800E-02  -5.46606000E-03  +1.85276100E-02  -1.79299470E-01
   -1.54327500E-02  +1.47090600E-01  +6.23224000E-03  +4.06539000E-03  -4.31884000E-03
   +1.50303000E-03  +1.49487000E-03  +2.91010000E-04  +1.41760000E-04  -2.14140000E-04
   +1.15773000E-03  -3.01500000E-04  +1.45280000E-04  -9.68000000E-05  -2.74810000E-04
   -2.12222000E-03  -4.88260000E-04  +4.66100000E-05  +1.81540000E-04  +2.53900000E-05
   -3.63900000E-05  +8.17000000E-06  +9.73000000E-06  -2.62900000E-05  -1.04600000E-05
   +8.29000000E-06  +5.02900000E-05  +3.34700000E-05  +5.85000000E-06  -7.79000000E-06
   -1.92100000E-05  +4.40000000E-06  -4.46500000E-05  -5.53700000E-05  -2.82600000E-05
   -6.68100000E-05  -5.37500000E-05  -1.03800000E-05  +3.22200000E-05  -1.16840000E-04
   +3.21600000E-05  +2.72180000E-04  +5.10000000E-05  +2.52760000E-04  +3.39000000E-06
   +9.12000000E-06  +6.32000000E-06  -1.49700000E-05  -1.35600000E-05  -5.30000000E-06
   +9.30000000E-06  +2.33900000E-05  +2.13500000E-05  +1.25500000E-05  +1.02300000E-05
   -8.17000000E-06  -9.68000000E-06  -4.41000000E-06  +8.00000000E-08  -5.79000000E-06
   +3.46300000E-05  -4.03000000E-06  +3.02000000E-05  +1.91300000E-05  +2.13000000E-06
   -1.42600000E-05  +1.78100000E-05  -1.55200000E-05  -3.17000000E-06  -7.44000000E-06
   +1.99000000E-06  +1.50100000E-05  -3.10000000E-06  -1.42700000E-05  -2.39500000E-05
   +9.52300000E-05  +9.53500000E-05  -3.68760000E-04  -1.57568000E-03  -1.47900000E-03
   +1.86623760E-01  +6.39530000E-04  -1.57979000E-03  -9.02890000E-04  +3.79851000E-03
   +5.92970000E-04  +1.59792000E-03  +1.14091700E-02  +5.41388000E-03  -1.42506700E-02
   -1.54305200E-02  -4.96298500E-02  +3.68888600E-02  -1.41017600E-02  +1.95082000E-03
   +1.83401500E-02  +1.16259000E-03  -7.09040000E-04  +4.75232000E-03  +6.87450000E-04
   +8.95810000E-04  -1.97560000E-04  -1.40000000E-05  +8.53000000E-05  +4.19800000E-05
   -1.39242000E-03  -3.84040000E-04  -3.08229000E-03  +2.52980000E-04  -2.52620000E-04
   -6.12500000E-05  -7.78000000E-06  +1.49900000E-05  +1.59500000E-05  -7.50000000E-07
   +5.47000000E-06  -1.24100000E-05  -1.51100000E-05  -2.88500000E-05  -1.15500000E-05
   +2.34100000E-05  +3.15000000E-05  -1.55500000E-05  +3.10000000E-05  +4.03300000E-05
   +3.83900000E-05  +3.32500000E-05  +2.30600000E-05  +2.44000000E-06  -9.52100000E-05
   +4.87600000E-05  -5.55800000E-05  +9.61700000E-05  +5.16150000E-04  +9.52000000E-05
   -3.27000000E-06  -3.04000000E-06  +9.80000000E-07  -3.61000000E-06  +3.00000000E-08
   +3.18000000E-06  +3.80000000E-07  +8.38000000E-06  +1.06300000E-05  +4.16000000E-06
   -9.90000000E-06  +6.30000000E-07  +7.00000000E-06  +6.66000000E-06  -3.63000000E-06
   +9.92000000E-06  +4.95000000E-06  +2.28400000E-05  +1.70200000E-05  -2.38200000E-05
   +5.18000000E-06  -5.97000000E-06  +3.18300000E-05  +3.46400000E-05  -9.40000000E-07
   -1.57300000E-05  -5.77000000E-06  -1.78200000E-05  -1.01000000E-06  -1.71300000E-05
   +9.50000000E-07  -6.25000000E-06  -1.31000000E-06  -1.87478000E-03  -1.52857000E-03
   -1.85105000E-03  +1.49695300E-02  +4.46057400E-02  -1.57451000E-03  -2.13500000E-04
   -2.02230000E-04  +4.36640000E-04  +1.20745000E-03  +2.72378000E-03  -2.06367000E-03
   +2.63140000E-04  +3.30047000E-03  +1.47046430E-01  +3.68869800E-02  -2.02124200E-01
   +1.79223700E-02  +2.68118000E-03  -1.17483400E-02  +7.68350000E-04  +4.46299000E-03
   -2.15713000E-03  +3.33500000E-05  +4.89750000E-04  +5.20840000E-04  -6.51900000E-05
   +9.72700000E-05  -4.40000000E-06  -1.32044000E-03  -2.48706000E-03  +3.42870000E-04
   +1.36060000E-04  -1.04470000E-04  -2.39100000E-05  +1.60000000E-07  +8.12000000E-06
   -6.90000000E-07  +5.09000000E-06  -6.49000000E-06  -1.11900000E-05  -3.00300000E-05
   -3.12300000E-05  -8.32000000E-06  +1.34900000E-05  +1.89300000E-05  +6.60000000E-07
   +6.55000000E-06  +1.36600000E-05  +3.06000000E-05  +4.11500000E-05  +2.86400000E-05
   +3.80000000E-06  +7.15100000E-05  -5.92800000E-05  -6.32100000E-05  +1.98940000E-04
   +5.27800000E-05  +4.28450000E-04  -6.38000000E-06  -5.26000000E-06  -1.80000000E-06
   -1.45000000E-06  +1.97000000E-06  +1.55000000E-06  -5.34000000E-06  +5.00000000E-07
   -3.34000000E-06  +5.60000000E-07  -9.90000000E-07  -1.29000000E-06  +3.03000000E-06
   +4.50000000E-06  -3.57000000E-06  +1.68200000E-05  -4.67000000E-06  +2.55100000E-05
   +2.26300000E-05  +1.40900000E-05  +6.32000000E-06  -2.38400000E-05  +2.02000000E-05
   +1.49000000E-06  -6.86000000E-06  -5.52000000E-06  -4.62000000E-06  -6.58000000E-06
   +2.17000000E-06  -6.87000000E-06  -2.51000000E-06  +2.02300000E-05  +2.10200000E-05
   -1.12809000E-03  -2.12241000E-03  -7.60570000E-04  -1.60158250E-01  -4.07531200E-02
   +2.09627910E-01  -1.03548000E-03  +1.47080000E-04  +2.20080000E-04  +1.33480000E-04
   -2.67590000E-04  +8.06500000E-05  +1.16063000E-03  +1.08445000E-03  -7.39390000E-04
   -5.28723000E-03  +3.27677000E-03  +2.18084000E-03  -5.47986000E-03  +2.98158900E-02
   -3.35975400E-02  +1.20739000E-03  -6.24830000E-04  -1.10946000E-03  -2.04930000E-04
   -3.43700000E-05  +1.45900000E-04  +4.40500000E-05  +4.54000000E-06  +1.89000000E-06
   -3.50012700E-02  -9.63587000E-03  +3.86039200E-02  -1.85300000E-05  -4.34000000E-05
   -5.14000000E-06  +2.60000000E-07  -7.81000000E-06  +3.23200000E-05  +3.60800000E-05
   -3.31300000E-05  -2.08700000E-05  -1.24980000E-04  -8.17500000E-05  -1.25500000E-05
   +1.80100000E-05  +2.49600000E-05  +2.15200000E-05  -1.43100000E-05  +4.02000000E-06
   +2.67300000E-05  +1.37670000E-04  +8.79400000E-05  +1.34300000E-05  +9.29000000E-05
   -2.01900000E-05  -3.70900000E-05  +6.28740000E-04  -1.54540000E-04  -3.55560000E-04
   -2.94300000E-05  -1.49100000E-05  -1.11100000E-05  -6.26000000E-06  +1.30000000E-05
   -2.87000000E-06  -1.44500000E-05  +3.49000000E-06  -3.95400000E-05  -1.08100000E-05
   +1.67000000E-06  -4.96000000E-06  +6.69000000E-06  +3.24000000E-06  -7.00000000E-06
   +1.56100000E-05  -3.68900000E-05  +2.70800000E-05  -1.76100000E-05  +7.60000000E-07
   -4.69000000E-06  -8.92000000E-06  +9.93000000E-06  -2.24000000E-06  -1.62300000E-05
   +4.01900000E-05  +1.40500000E-05  -1.23600000E-05  +5.10000000E-06  +1.40600000E-05
   +2.49900000E-05  -3.19700000E-05  -8.21000000E-06  -3.27250000E-04  +1.38870000E-04
   +1.52800000E-05  -3.78500000E-05  -3.24970000E-04  -1.48670000E-04  +4.43362000E-02
   +4.77400000E-05  -7.86820000E-04  +2.01690000E-04  -1.22670000E-04  +1.66870000E-04
   -3.61300000E-04  +8.71900000E-05  +4.31830000E-04  +1.61378000E-03  +4.47054000E-03
   -1.70730000E-04  -1.27902000E-03  +6.66910000E-04  -2.03647500E-02  +2.21597100E-02
   -1.98553000E-03  +1.55622000E-03  -1.40228000E-03  +1.91390000E-04  -1.22820000E-04
   +2.76600000E-05  -9.49300000E-05  +4.80000000E-05  -4.51900000E-05  +2.09190500E-02
   -2.15326080E-01  +2.42107680E-01  +6.04000000E-06  +1.26320000E-04  -8.80000000E-07
   -1.10800000E-05  -1.09600000E-05  -8.41000000E-06  -3.75000000E-05  +1.27800000E-05
   +4.17700000E-05  +1.25610000E-04  +1.08440000E-04  +2.91700000E-05  -2.54000000E-05
   -5.35200000E-05  -2.30200000E-05  -5.86000000E-06  -2.51400000E-05  -3.81300000E-05
   -1.61220000E-04  -1.35180000E-04  -1.16300000E-05  -5.91600000E-05  -1.31000000E-06
   +2.62200000E-05  -5.58790000E-04  +1.08240000E-04  +3.83450000E-04  +1.39900000E-05
   +3.29200000E-05  +3.67000000E-06  -1.70100000E-05  -1.40800000E-05  -2.07200000E-05
   +2.87600000E-05  +3.58500000E-05  +3.89300000E-05  +1.83700000E-05  +3.23000000E-06
   -7.22000000E-06  -1.12100000E-05  -3.84000000E-06  +4.32000000E-06  -2.52200000E-05
   +3.07900000E-05  -1.55100000E-05  +5.16000000E-06  -2.00300000E-05  +1.22100000E-05
   +1.22400000E-05  -9.24000000E-06  -7.21000000E-06  +2.19800000E-05  -2.07600000E-05
   -1.13400000E-05  +1.69000000E-06  -3.88400000E-05  -1.17100000E-05  -4.24600000E-05
   +4.92800000E-05  +2.66200000E-05  +1.71860000E-04  -1.51070000E-04  -1.04630000E-04
   -3.26630000E-04  -2.06700000E-05  -5.23620000E-04  -2.34077700E-02  +2.34412810E-01
   +3.26290000E-04  +8.86900000E-05  -1.04639000E-03  -1.35450000E-04  -2.05650000E-04
   +1.74710000E-04  +4.53040000E-04  +7.63290000E-04  +5.09630000E-04  +7.75340000E-04
   -2.55180000E-04  +1.61116000E-03  +2.30544000E-03  -3.02126000E-03  -1.61000000E-04
   +5.74690000E-04  -2.55556000E-03  +1.74108000E-03  -8.17100000E-05  +1.07760000E-04
   -1.84780000E-04  +1.12990000E-04  -6.30000000E-05  +5.16200000E-05  +9.35600000E-04
   +2.68538230E-01  -3.35495790E-01  +4.64600000E-05  -7.55900000E-05  -4.73000000E-06
   +5.52000000E-06  +1.72800000E-05  +3.58000000E-05  +8.73000000E-06  -1.77600000E-05
   -1.09600000E-05  -4.26500000E-05  -4.17200000E-05  -1.19100000E-05  +2.34500000E-05
   +3.21400000E-05  -1.82000000E-06  -1.15000000E-05  +5.46000000E-06  +1.96500000E-05
   +5.95500000E-05  +4.19400000E-05  -1.88000000E-06  -3.07000000E-06  +1.48400000E-05
   -7.60000000E-06  +1.49020000E-04  +2.61700000E-05  -1.47270000E-04  -1.11500000E-05
   -6.82000000E-06  +1.56000000E-06  -5.78000000E-06  +2.24000000E-06  +7.90000000E-07
   -7.82000000E-06  -1.20000000E-07  -3.02700000E-05  +9.00000000E-07  -1.02800000E-05
   +1.09000000E-06  +7.95000000E-06  +1.00000000E-06  -1.91000000E-06  +1.48100000E-05
   -9.78000000E-06  -7.04000000E-06  -6.56000000E-06  +6.93000000E-06  -4.80000000E-07
   -7.82000000E-06  +1.50000000E-06  -1.05900000E-05  +8.20000000E-06  +7.79000000E-06
   -4.81000000E-06  -3.42000000E-06  +1.19100000E-05  +1.96100000E-05  +2.01100000E-05
   -3.43700000E-05  -4.81900000E-05  -2.29600000E-05  -7.95400000E-05  -1.90000000E-07
   -1.55140000E-04  -5.28400000E-04  +8.39800000E-05  -5.49140000E-03  -2.62705920E-01
   +3.32836910E-01  +5.78375000E-03  -2.71398800E-02  +2.35191300E-02  -3.71156000E-03
   +4.20640000E-04  +4.19102000E-03  +1.22381000E-03  -1.56030000E-04  +5.64600000E-04
   -5.53100000E-05  +8.33500000E-05  -1.69640000E-04  -1.13111000E-03  +3.41860000E-04
   +1.72810000E-04  +7.86480000E-04  -1.72046000E-03  +5.34980000E-04  -9.80300000E-05
   -8.37900000E-05  +5.79100000E-05  -6.39300000E-05  +1.60200000E-05  +5.48000000E-05
   +3.63430000E-04  -7.53200000E-05  -2.28690000E-04  +7.79400000E-05  +1.40910000E-04
   -1.82590000E-04  +1.23190000E-04  +2.91280000E-04  +4.82200000E-05  -1.84820000E-04
   -1.54050000E-04  +1.29930000E-04  +1.43800000E-04  -3.96600000E-05  -1.02820000E-04
   +9.78000000E-06  -6.13500000E-05  +6.86500000E-05  +3.71000000E-05  +5.15600000E-05
   -1.26050000E-04  -2.02580000E-04  -1.86340000E-04  +2.92000000E-05  -1.04100000E-04
   -3.23500000E-05  +1.77000000E-06  -8.14002400E-02  +1.48146250E-01  -9.35030500E-02
   -2.61600000E-05  +3.47200000E-05  -3.06400000E-05  -2.79400000E-05  +1.17000000E-06
   -3.88400000E-05  +1.05700000E-05  +3.45500000E-05  -2.32000000E-06  +4.89200000E-05
   +3.37700000E-05  -2.26400000E-05  -6.31700000E-05  +2.81500000E-05  -1.96500000E-05
   +1.38000000E-06  +3.07700000E-05  -2.99500000E-05  -1.86000000E-05  -2.42200000E-05
   +1.50600000E-05  +6.20000000E-07  +1.51400000E-05  -3.30700000E-05  +8.41100000E-05
   -1.70790000E-04  -2.77370000E-04  +5.20000000E-06  +3.08600000E-05  -1.11500000E-05
   -1.44700000E-05  +1.28820000E-04  -9.49700000E-05  -2.22420000E-04  -6.41000000E-05
   +1.75100000E-04  -8.79800000E-05  +1.45900000E-04  -1.81320000E-04  -1.94950000E-04
   +1.03930000E-04  +1.58340000E-04  +7.89072800E-02  +3.13778000E-03  -5.34557000E-03
   +1.92826000E-03  -3.96380000E-04  +2.03660000E-03  -3.88300000E-05  +6.99720000E-04
   +4.29560000E-04  +6.75030000E-04  -1.25190000E-04  +1.96720000E-04  -3.71690000E-04
   +4.52080000E-04  -1.00857000E-03  +3.43550000E-04  -1.85600000E-04  +1.27548000E-03
   -2.91559000E-03  +2.31140000E-04  +7.71300000E-05  -5.37880000E-04  -6.24200000E-05
   -1.52840000E-04  -3.61030000E-04  +3.17920000E-04  -1.23580000E-04  -1.02920000E-04
   +8.41900000E-05  -2.21600000E-05  +1.30770000E-04  +3.87900000E-05  -2.66000000E-05
   -6.00200000E-05  +4.36000000E-06  -6.73000000E-05  +5.28900000E-05  +5.62300000E-05
   +9.89800000E-05  +5.94400000E-05  -4.26400000E-05  -5.59700000E-05  -2.01400000E-05
   -6.40400000E-05  +1.93000000E-05  -2.94000000E-06  -1.15730000E-04  -1.37000000E-04
   +5.15000000E-06  -1.01950000E-04  -1.34900000E-05  +2.13600000E-05  +1.16211840E-01
   -3.16712690E-01  +2.40786280E-01  -1.69800000E-05  +3.61800000E-05  -2.53300000E-05
   -2.65800000E-05  +3.90000000E-07  -4.88800000E-05  +2.08900000E-05  +6.09300000E-05
   +9.64000000E-06  +1.67300000E-05  -2.03400000E-05  -4.80000000E-06  -1.10500000E-05
   +6.79000000E-06  -1.71000000E-06  -2.68900000E-05  +4.00400000E-05  -2.11700000E-05
   -2.51000000E-06  -3.16000000E-05  +1.34500000E-05  +1.43000000E-05  +5.64000000E-06
   -1.59400000E-05  +1.30570000E-04  -1.92150000E-04  +4.49150000E-04  +6.83000000E-06
   -1.21890000E-04  +8.14700000E-05  -6.05800000E-05  -1.84200000E-05  +8.96200000E-05
   -7.11200000E-05  -2.42000000E-05  -9.27200000E-05  -4.50000000E-07  -8.34700000E-05
   +4.30900000E-05  +5.81000000E-05  +1.52260000E-04  -5.62200000E-05  -1.20171350E-01
   +3.19721840E-01  -9.34163000E-03  +2.89353000E-02  -2.56516600E-02  +5.26197000E-03
   -6.67390000E-04  -1.77780000E-03  -4.18400000E-04  +1.63267000E-03  -2.37030000E-04
   -2.03270000E-04  -3.69410000E-04  +4.40510000E-04  +1.16750000E-04  +1.84730000E-04
   -8.18860000E-04  -1.42554000E-03  -1.43275000E-03  +1.64647000E-03  -1.94970000E-04
   -2.77600000E-04  +1.38600000E-04  +1.72840000E-04  -4.16960000E-04  -2.53200000E-05
   -6.37090000E-04  +2.69320000E-04  +2.69750000E-04  -1.55630000E-04  -8.78500000E-05
   -7.75500000E-05  +7.33800000E-05  +7.47500000E-05  +1.91900000E-05  +5.14300000E-05
   -1.33670000E-04  -1.33500000E-05  -2.40010000E-04  -1.20290000E-04  +3.75400000E-05
   +1.33900000E-05  +5.56800000E-05  -1.77800000E-05  +5.60000000E-07  +5.81500000E-05
   -7.82000000E-06  +2.19730000E-04  +1.49310000E-04  -1.09300000E-05  +1.23430000E-04
   -5.57700000E-05  -9.58400000E-05  -5.91266800E-02  +2.12517400E-01  -1.85201250E-01
   -4.45500000E-05  -2.79500000E-05  -4.88000000E-06  -1.15100000E-05  +1.95000000E-05
   -1.55900000E-05  -1.03500000E-05  +1.47800000E-05  -8.49400000E-05  -1.72100000E-05
   -4.86700000E-05  +1.58500000E-05  +4.22700000E-05  -1.00100000E-05  +2.64000000E-06
   +2.89300000E-05  -4.48000000E-05  +3.10300000E-05  -1.25000000E-05  +3.21000000E-06
   +1.00900000E-05  -1.88500000E-05  +1.36800000E-05  -8.36000000E-06  -3.93000000E-05
   +2.16270000E-04  +2.74390000E-04  -9.75000000E-06  -4.35600000E-05  +7.28000000E-05
   +2.60900000E-05  -1.32700000E-04  +5.06200000E-05  +2.36070000E-04  -6.37600000E-05
   -2.25800000E-04  +6.66000000E-06  -1.01150000E-04  +6.45000000E-06  +2.00520000E-04
   -9.91400000E-05  +9.00200000E-05  +6.53332100E-02  -2.40011340E-01  +2.11168810E-01
end_hess

