# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.28769490    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -4.41681082E+00  +2.41478879E+00  +1.54669415E+00
   006   -2.55874169E+00  +1.71811840E+00  -1.73402650E-01
   006   -3.11690558E+00  -2.54440990E-01  -1.82440381E+00
   006   -5.42266378E+00  -1.48050915E+00  -1.77193549E+00
   006   -7.25455437E+00  -7.49853414E-01  -3.58854837E-02
   006   -6.73981021E+00  +1.20606154E+00  +1.62688365E+00
   006   +6.51833008E-03  +3.04452422E+00  -3.74055001E-01
   006   +1.65137106E-03  +4.58136907E+00  -2.83835927E+00
   008   -9.55141695E+00  -1.88173739E+00  +1.14450909E-01
   006   +2.11355465E+00  +1.05564711E+00  -2.75144959E-01
   006   +2.02052610E+00  -6.87847693E-01  +1.72858865E+00
   006   +3.62753504E+00  -2.59138616E+00  +2.37756701E+00
   006   +5.97442164E+00  -3.48169889E+00  +1.24325370E+00
   006   +6.14602579E+00  -4.39034917E-01  -2.28660044E+00
   006   +4.08891056E+00  +1.06355898E+00  -2.07177798E+00
   008   +6.99913576E+00  -2.39125837E+00  -8.97881873E-01
   008   +7.14761496E+00  -5.21236932E+00  +2.10055535E+00
   006   +4.68888694E-01  +4.90533094E+00  +1.81127005E+00
   001   -9.66624893E+00  -3.20091945E+00  -1.11683020E+00
   001   -5.79534302E+00  -3.01539633E+00  -3.07641677E+00
   001   -1.70653939E+00  -8.70583232E-01  -3.17437017E+00
   001   -4.07764068E+00  +3.92829540E+00  +2.87571785E+00
   001   -8.16607508E+00  +1.76438317E+00  +2.97935664E+00
   001   -1.61545424E+00  +5.85583742E+00  -2.82710352E+00
   001   +1.70322091E+00  +5.73041208E+00  -3.02514589E+00
   001   -1.66860534E-01  +3.37420117E+00  -4.49899758E+00
   001   +3.54098772E-01  +3.98325123E+00  +3.64945647E+00
   001   +2.35203915E+00  +5.72037152E+00  +1.62998823E+00
   001   -8.93915026E-01  +6.45146488E+00  +1.77073909E+00
   001   +4.01255124E+00  +2.46385016E+00  -3.55536903E+00
   001   +7.44619907E+00  -1.19561320E-01  -3.83009768E+00
   001   +3.16383157E+00  -3.71115281E+00  +4.02136452E+00
   001   +3.90744219E-01  -5.10307489E-01  +2.95895343E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +7.00000000E-07  +1.53000000E-06  +5.00000000E-07
   +1.36000000E-06  -1.23000000E-06  +1.12000000E-06
   -1.02000000E-06  -5.00000000E-08  +2.60000000E-07
   -1.03000000E-06  +9.10000000E-07  +1.91000000E-06
   -9.60000000E-07  +1.51000000E-06  +1.90000000E-06
   +5.10000000E-07  +2.66000000E-06  +1.00000000E-06
   +2.46000000E-06  -9.30000000E-07  -7.10000000E-07
   -1.70000000E-07  -1.67000000E-06  -1.92000000E-06
   -1.20000000E-07  +2.58000000E-06  +2.59000000E-06
   +4.61000000E-06  -3.48000000E-06  +4.09000000E-06
   -3.07000000E-06  -4.72000000E-06  -8.38000000E-06
   +1.89000000E-06  +9.80000000E-06  -3.46000000E-06
   +1.81000000E-06  -1.74000000E-05  -4.63000000E-06
   +1.49500000E-05  -2.76800000E-05  -7.42000000E-06
   -1.08000000E-05  +1.29600000E-05  +1.54000000E-05
   -5.78000000E-06  +1.37400000E-05  +4.83000000E-06
   -8.41000000E-06  +9.22000000E-06  +4.00000000E-07
   +2.31000000E-06  -1.20000000E-07  -1.98000000E-06
   -1.13000000E-06  +1.94000000E-06  +3.09000000E-06
   -1.42000000E-06  +2.40000000E-07  +2.23000000E-06
   -8.70000000E-07  -9.30000000E-07  +1.29000000E-06
   +5.30000000E-07  +1.57000000E-06  -3.70000000E-07
   +9.00000000E-07  +3.00000000E-06  +9.60000000E-07
   +1.10000000E-07  -1.06000000E-06  -1.75000000E-06
   -1.07000000E-06  -1.76000000E-06  -2.60000000E-06
   -3.40000000E-07  +2.40000000E-07  -6.70000000E-07
   +1.54000000E-06  +1.57000000E-06  -1.72000000E-06
   +2.04000000E-06  +5.10000000E-07  -1.89000000E-06
   +2.48000000E-06  +1.20000000E-06  -2.75000000E-06
   -4.20000000E-07  -4.75000000E-06  -1.33000000E-06
   -1.46000000E-06  -1.73000000E-06  -2.61000000E-06
   +7.20000000E-07  +2.04000000E-06  +3.08000000E-06
   -8.50000000E-07  +3.30000000E-07  -4.80000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.13710840E-01  +1.42490100E-01  +4.87203900E-01  -1.18503540E-01  +2.64317450E-01
   +4.73531310E-01  -2.19441290E-01  +4.40846700E-02  +1.28564450E-01  +5.74259040E-01
   -2.63300000E-03  -1.18089240E-01  -5.07154400E-02  +9.15196200E-02  +4.51334550E-01
   +8.24375900E-02  -7.52406700E-02  -1.88029290E-01  -1.27544140E-01  +2.08004370E-01
   +4.63516800E-01  +4.93233600E-02  +1.92531500E-02  -2.52821000E-03  -1.27164190E-01
   -1.81640600E-02  +1.45644900E-02  +6.58872510E-01  +5.55646200E-02  -3.65499000E-03
   -4.21072200E-02  -6.48102600E-02  -2.09229970E-01  -1.01566240E-01  +1.21639710E-01
   +4.53494760E-01  +3.33289400E-02  -2.25331400E-02  -3.19446800E-02  -3.26428200E-02
   -1.26871390E-01  -1.78259180E-01  -1.58684760E-01  +2.37323420E-01  +4.63440170E-01
   -6.30573900E-02  -4.93606000E-03  +2.70810800E-02  +9.27568000E-03  -6.01787600E-02
   -6.17474700E-02  -2.98827220E-01  -8.78926100E-02  +4.46454500E-02  +6.25794360E-01
   -8.02024000E-03  -3.76182000E-03  +4.05695000E-03  -2.34530300E-02  -1.93536900E-02
   -1.41650600E-02  -1.35272390E-01  -1.50131500E-01  -1.54225100E-02  +1.54949430E-01
   +4.84739290E-01  +2.47729300E-02  +2.53551000E-03  -1.43972300E-02  -2.39177200E-02
   +5.62265000E-03  +2.78722500E-02  -2.26167000E-03  -4.13575000E-02  -9.92644800E-02
   -1.21759100E-01  +2.68665780E-01  +4.58485040E-01  +1.26702500E-02  -2.43248900E-02
   -2.97334900E-02  -2.93042000E-03  +1.85390000E-02  +1.76979900E-02  -4.87961100E-02
   -1.52448800E-02  +1.28604000E-02  -2.02497590E-01  +5.25442100E-02  +1.25658610E-01
   +6.34522610E-01  -6.40689300E-02  -2.21050600E-02  +1.09157800E-02  +1.75118000E-02
   -3.43219200E-02  -3.79538600E-02  +2.47393500E-02  +4.64190800E-02  +3.02459800E-02
   -4.29937000E-03  -1.28286590E-01  -5.59536700E-02  +1.36818230E-01  +4.89575490E-01
   -6.98545600E-02  -1.05457600E-02  +2.92759200E-02  +1.62309900E-02  -3.84146000E-02
   -5.32954000E-02  +5.25913600E-02  +5.18909000E-02  +2.51757500E-02  +6.97290000E-02
   -8.75546300E-02  -1.94244340E-01  -1.24949340E-01  +2.47873130E-01  +4.78751250E-01
   -2.94056770E-01  -1.30049270E-01  +4.64100000E-05  -4.49127700E-02  +2.07663800E-02
   +4.93176700E-02  -2.93273600E-02  -3.24439100E-02  -1.78934200E-02  +4.85921200E-02
   +1.86706800E-02  -3.77584000E-03  -1.23911200E-01  -3.05747000E-03  +2.63626200E-02
   +6.62481610E-01  -8.25950300E-02  -1.47685090E-01  -4.03530400E-02  -1.46627600E-02
   +4.25195600E-02  +4.24875200E-02  -2.99685800E-02  -3.92231900E-02  -1.97918400E-02
   +5.06309900E-02  -3.27300000E-05  -3.62605500E-02  -5.61896700E-02  -2.12928600E-01
   -1.09639510E-01  +1.29392280E-01  +4.54456520E-01  +4.70066600E-02  -1.45729100E-02
   -1.00969250E-01  +1.41679800E-02  +2.38419900E-02  +2.24880400E-02  -1.53893700E-02
   -1.83125200E-02  -1.28766600E-02  +2.81552100E-02  -1.86047600E-02  -2.57473500E-02
   -2.67094700E-02  -1.39309160E-01  -1.95126220E-01  -1.66848270E-01  +2.52154110E-01
   +4.73850470E-01  -1.93772000E-02  -9.52844000E-03  +3.22926000E-03  -1.50671840E-01
   -3.62595200E-02  +1.11337800E-02  -8.74451000E-03  -9.90020000E-03  -4.33778000E-03
   +4.39073000E-03  -2.73140000E-04  +4.31930000E-04  -2.34188000E-03  +6.26350000E-04
   +1.28619000E-03  +7.44380000E-04  -8.46100000E-05  +3.34877000E-03  +4.66362610E-01
   +4.21008000E-03  +8.46784000E-03  +2.96881000E-03  -4.04613800E-02  -9.76008300E-02
   -5.39542000E-03  -2.32104100E-02  -1.18325100E-02  +1.26413000E-03  -4.65790000E-04
   +1.44760000E-04  -4.63844000E-03  -1.94510000E-04  -9.84110000E-04  -4.44980000E-04
   +8.92820000E-04  +2.43234000E-03  -4.65908000E-03  +3.34259000E-03  +4.71735290E-01
   +1.55313800E-02  +1.04770000E-02  +2.64689000E-03  +7.64888000E-03  -7.17398000E-03
   -8.05428100E-02  -1.91897800E-02  -7.36676000E-03  +5.35788000E-03  +5.51280000E-04
   -5.69449000E-03  -6.07400000E-04  -3.82900000E-05  -9.06590000E-04  -1.33732000E-03
   +3.59673000E-03  -3.61953000E-03  +9.09090000E-04  -1.46196000E-03  -8.12807000E-03
   +4.77197590E-01  -7.73660000E-04  -1.96666000E-03  -6.80410000E-04  -5.61533000E-03
   -1.74430200E-02  +2.65728200E-02  -6.56970000E-04  -8.33420000E-04  +1.07182000E-03
   -1.15880000E-04  +7.85660000E-04  +1.16010000E-04  +7.80190000E-04  +7.69840000E-04
   +4.61370000E-04  -1.46641000E-03  +2.10510000E-04  -1.28101000E-03  -7.58425700E-02
   -1.76500000E-03  +3.34530000E-03  +5.87415320E-01  +1.35445000E-03  -1.06924000E-03
   -5.33980000E-04  -8.54979000E-03  -1.34034600E-02  +1.60998400E-02  -4.67540000E-04
   -3.02610000E-04  +1.09853000E-03  +1.67710000E-04  +6.41240000E-04  -7.97900000E-05
   +1.74410000E-04  +4.95240000E-04  +4.30220000E-04  -6.38810000E-04  -2.01720000E-04
   -7.61990000E-04  +2.52448000E-03  -1.01424240E-01  +4.49824500E-02  +1.51245000E-03
   +5.49146430E-01  -8.22170000E-04  +2.82300000E-05  -2.58800000E-05  +9.27287000E-03
   +8.31327000E-03  -5.16544000E-03  -1.75640000E-03  -9.00860000E-04  -1.75160000E-04
   +2.92010000E-04  -1.86070000E-04  -1.99320000E-04  +1.83110000E-04  +2.18930000E-04
   +3.25470000E-04  -1.12520000E-04  -3.20130000E-04  -2.16500000E-05  -1.81558000E-03
   +4.20831800E-02  -1.46105440E-01  -4.10509000E-03  +6.13223000E-02  +5.03543880E-01
   +2.08003000E-03  +1.12169000E-03  +2.68981000E-03  -3.34234000E-03  -2.26401000E-03
   -2.21813000E-03  +3.45073000E-03  +2.89068000E-03  +4.95138000E-03  -4.57768100E-02
   -2.43928000E-02  +6.69225000E-03  -2.68425500E-01  -7.78163900E-02  +4.70033400E-02
   -1.60660600E-02  -2.03125500E-02  -6.95771000E-03  +1.88322000E-03  +5.96570000E-04
   +5.87170000E-04  -1.45827000E-03  -4.64870000E-04  -4.78940000E-04  +3.67621510E-01
   +5.78088000E-03  +1.27235000E-03  -7.06637000E-03  -2.75863000E-03  +1.60086000E-03
   +3.80959000E-03  -3.02546000E-03  -7.84180000E-04  -6.33754000E-03  +2.52383000E-03
   +9.63748000E-03  -1.51471000E-03  -1.13117690E-01  -1.20165170E-01  -1.28574700E-02
   -4.65036900E-02  -2.26220500E-02  -4.24611000E-03  +9.72490000E-04  +1.40250000E-04
   +9.15290000E-04  -8.68140000E-04  -3.21500000E-04  -2.74340000E-04  +1.59898360E-01
   +4.17462270E-01  +7.55300000E-03  -4.44241000E-03  -3.39549000E-03  -1.72780000E-03
   +4.10262000E-03  +3.76478000E-03  -8.16740000E-04  -9.59379000E-03  -1.78980000E-03
   +3.31737100E-02  +1.34237000E-02  +4.71250000E-03  +1.25083500E-02  -3.21759600E-02
   -8.24982800E-02  -3.30773200E-02  -1.89127500E-02  +7.20846000E-03  -3.18660000E-04
   +4.24670000E-04  -1.52100000E-05  -5.20000000E-05  -5.71800000E-05  -7.30600000E-05
   -3.01844200E-02  +2.95498930E-01  +3.33826770E-01  -1.53006000E-03  -9.31870000E-04
   -1.97975000E-03  -3.40040200E-02  +1.59745700E-02  +4.29557000E-03  -7.46580000E-04
   +5.45190000E-04  -5.65220000E-04  +5.12990000E-04  +4.86450000E-04  +3.95460000E-04
   -3.02210000E-04  +8.42300000E-05  +3.80640000E-04  -2.08310000E-04  -5.69670000E-04
   +9.13860000E-04  -1.21257640E-01  +4.62710100E-02  +3.43636000E-03  +6.42300000E-05
   +4.01898000E-03  -5.44424000E-03  +2.71270000E-04  +1.31170000E-04  -7.17400000E-05
   +4.49263800E-01  -9.04940000E-04  -1.81759000E-03  -7.35730000E-04  -1.90697000E-03
   +1.14663400E-02  +2.62770000E-04  -3.12146000E-03  -4.79300000E-05  -2.93890000E-04
   +3.30500000E-04  -7.03600000E-05  -2.50230000E-04  +5.58040000E-04  +1.09959000E-03
   +6.30480000E-04  -9.48140000E-04  -8.75150000E-04  +3.36940000E-04  +4.38579700E-02
   -1.12991640E-01  +1.35341700E-02  +1.35332100E-02  -1.55186700E-02  +2.71552000E-03
   -1.05425000E-03  -7.17250000E-04  -5.44600000E-05  -1.13827330E-01  +3.92595230E-01
   +1.18060000E-04  +6.44490000E-04  +3.75650000E-04  +4.80778000E-03  -4.02561000E-03
   -1.10361000E-03  -1.23991000E-03  -6.90940000E-04  +4.51090000E-04  -7.34140000E-04
   +2.89240000E-04  +2.27470000E-04  +1.82510000E-04  -3.49200000E-04  -4.95390000E-04
   +2.99470000E-04  +3.98860000E-04  -1.29460000E-04  +1.00115000E-02  +1.02276300E-02
   -7.89889600E-02  -2.16814200E-02  +2.02260700E-02  +5.76310000E-04  -1.73160000E-04
   -1.08890000E-04  +1.66980000E-04  -1.46893630E-01  -1.43460400E-01  +4.43004100E-01
   +8.99640000E-04  +4.12160000E-04  -8.56660000E-04  -1.61789000E-03  +3.06235000E-03
   -2.32399000E-03  -1.28184000E-03  +4.98580000E-04  -7.81030000E-04  +4.20120000E-04
   +1.45350000E-04  -1.31260000E-04  -2.82500000E-05  +2.71000000E-04  +4.00130000E-04
   -3.45680000E-04  -6.63290000E-04  +1.71500000E-05  +3.44500000E-04  +1.68444900E-02
   -1.87396500E-02  -3.99915000E-03  +3.58682000E-03  +8.46260000E-04  -1.87580000E-04
   -1.49120000E-04  -2.05000000E-06  -1.07269020E-01  -1.99534200E-02  +6.72015100E-02
   +5.48171870E-01  -8.92150000E-04  -2.73410000E-04  +5.36850000E-04  +3.85020000E-04
   -5.82770000E-04  +9.71210000E-04  +4.65950000E-04  -7.87620000E-04  -2.39260000E-04
   -4.03490000E-04  -1.60800000E-05  +3.78650000E-04  -4.75200000E-05  -3.00640000E-04
   -3.19800000E-04  +1.56120000E-04  +2.75900000E-04  +2.76540000E-04  +8.77145000E-03
   -1.97082400E-02  +1.90590400E-02  +3.20635000E-03  -1.65713000E-03  -6.32460000E-04
   +6.63600000E-05  +9.13200000E-05  +6.69500000E-05  +3.32637200E-02  -1.35739210E-01
   +4.68030600E-02  -1.89271190E-01  +4.48116270E-01  +1.14909000E-03  +3.28610000E-04
   -1.05001000E-03  -1.04004000E-03  +8.10160000E-04  -3.84130000E-04  -1.03705000E-03
   +1.49345000E-03  -3.16140000E-04  +5.92480000E-04  +1.14160000E-04  -2.98020000E-04
   +1.15300000E-04  +2.83560000E-04  +4.37910000E-04  -9.19500000E-05  -1.75590000E-04
   -4.08660000E-04  -8.49209000E-03  +6.59403000E-03  +8.05600000E-04  +9.09570000E-04
   -7.77300000E-05  -4.10810000E-04  -7.95000000E-05  -6.88200000E-05  -9.87200000E-05
   +5.75019000E-03  +9.93458700E-02  -1.71724280E-01  -1.59351210E-01  -1.71579150E-01
   +4.64933830E-01  -4.76110000E-04  -3.24860000E-04  +8.32800000E-05  +3.19710000E-04
   +1.69920000E-04  -5.08680000E-04  +4.92150000E-04  +1.68300000E-05  +3.02730000E-04
   -5.20870000E-04  -4.21800000E-05  +3.55040000E-04  +6.14610000E-04  +2.77500000E-05
   -3.37690000E-04  +1.84900000E-04  +1.77240000E-04  +3.87000000E-05  +3.88999000E-03
   -1.44681000E-03  +2.68609000E-03  +4.48910000E-04  -4.87440000E-04  +5.32110000E-04
   -6.08380000E-04  -3.05630000E-04  +4.61400000E-05  +2.12007300E-02  +3.52982700E-02
   -5.51003300E-02  -2.03130670E-01  +1.13340290E-01  +1.62096800E-02  +4.81263940E-01
   +7.18680000E-04  +3.71240000E-04  -3.56460000E-04  -9.15490000E-04  -2.27970000E-04
   -5.00000000E-07  -4.15060000E-04  +3.85330000E-04  -2.85580000E-04  +4.68300000E-04
   +2.18690000E-04  -3.12740000E-04  -1.27510000E-04  +1.01590000E-04  +3.22950000E-04
   -1.41450000E-04  -1.81490000E-04  -1.40160000E-04  -3.09607000E-03  +2.19485000E-03
   +3.03692000E-03  +8.12780000E-04  -3.04850000E-04  -6.80120000E-04  +1.75800000E-04
   +1.00130000E-04  -4.17200000E-05  +4.70968000E-03  -4.66964000E-02  +5.81891200E-02
   +1.61255400E-01  -2.21871370E-01  +4.57450200E-02  -2.12829850E-01  +4.95214500E-01
   -2.31220000E-04  -1.35020000E-04  +3.79650000E-04  +7.61920000E-04  -6.28900000E-05
   +2.00840000E-04  -7.21000000E-06  -4.61320000E-04  -2.53700000E-05  +6.80700000E-05
   +5.69000000E-06  -1.11140000E-04  -3.10140000E-04  -1.16800000E-04  -2.01200000E-05
   -4.87300000E-05  +4.67800000E-05  +1.07020000E-04  +3.02343000E-03  +2.29618000E-03
   -2.23853000E-03  -8.19380000E-04  +5.89180000E-04  +4.19120000E-04  +3.13340000E-04
   +1.83130000E-04  +5.31000000E-06  -1.78312900E-02  +2.76782300E-02  -7.00829000E-03
   -3.73804300E-02  +8.93725100E-02  -1.13137710E-01  -1.08341470E-01  -2.42956810E-01
   +4.64499260E-01  -7.54700000E-05  +1.81530000E-04  +4.10380000E-04  +1.95900000E-04
   -6.06240000E-04  +4.10710000E-04  +7.81700000E-05  -3.12660000E-04  -3.50300000E-05
   +2.42570000E-04  -2.22140000E-04  -2.52020000E-04  -1.07891000E-03  -5.97680000E-04
   -6.31900000E-05  +2.46500000E-04  +3.21880000E-04  +1.53460000E-04  -2.29484000E-03
   +7.66140000E-04  -2.38800000E-05  +5.84800000E-04  -4.98100000E-05  -4.95220000E-04
   +1.24614000E-03  +6.72870000E-04  -1.58700000E-05  -2.63074000E-03  -1.61427500E-02
   +1.69175200E-02  -2.66361600E-02  +3.68131300E-02  -1.91722900E-02  -1.59013540E-01
   +1.23488300E-02  +6.06227300E-02  +5.80959600E-01  -1.18920000E-04  -1.66180000E-04
   -1.37760000E-04  +4.37710000E-04  +7.26420000E-04  +5.94400000E-05  -8.74200000E-05
   -2.44750000E-04  -1.52080000E-04  -2.13270000E-04  +1.39880000E-04  +2.58680000E-04
   +8.97470000E-04  +5.97280000E-04  +6.48300000E-05  -2.53410000E-04  -3.47690000E-04
   -9.26300000E-05  +1.03271000E-03  -4.72550000E-04  +7.37260000E-04  -5.00050000E-04
   +2.37000000E-04  +1.33140000E-04  -1.12205000E-03  -6.74220000E-04  +5.43000000E-05
   +1.34926000E-03  -1.49047000E-03  -6.35177000E-03  +2.18529200E-02  -9.54286000E-03
   -1.11860600E-02  +3.32022800E-02  -9.22269700E-02  -1.26637500E-02  -3.30912220E-01
   +6.48880170E-01  -2.50110000E-04  +9.10000000E-06  +7.60000000E-05  +2.27170000E-04
   -4.00140000E-04  -2.67450000E-04  +1.92300000E-05  +1.86560000E-04  +3.55250000E-04
   -6.69600000E-05  -9.55300000E-05  -7.92100000E-05  -1.57430000E-04  -2.40410000E-04
   -1.39060000E-04  +2.49210000E-04  +2.52010000E-04  +1.07100000E-05  +1.01402000E-03
   +1.34930000E-04  -5.44730000E-04  +2.63600000E-05  -2.05270000E-04  +3.17800000E-04
   +2.76800000E-04  +1.80400000E-04  -4.58700000E-05  -4.01025000E-03  +9.87696000E-03
   -1.39333600E-02  -1.89573000E-03  -2.43034000E-02  +2.71172500E-02  +3.81158800E-02
   +5.83226000E-03  -1.17143430E-01  +1.90152100E-02  -2.01632060E-01  +4.02618680E-01
   +1.10590000E-04  +8.68700000E-05  +1.50500000E-05  -3.12210000E-04  +1.17980000E-04
   +3.13420000E-04  -1.59400000E-05  +2.37910000E-04  +9.18000000E-05  +2.95020000E-04
   -1.54090000E-04  -2.59300000E-04  -4.37270000E-04  -2.41150000E-04  +7.89100000E-05
   +1.10650000E-04  +1.33190000E-04  +1.85200000E-05  -3.76000000E-05  -8.60340000E-04
   +2.60787000E-03  +3.63400000E-04  -7.16630000E-04  -1.64020000E-04  +5.75340000E-04
   +3.27060000E-04  -5.75200000E-05  -5.22718700E-02  +3.06128000E-03  +5.03770600E-02
   -8.70171000E-03  +1.83952000E-02  -1.26869800E-02  +4.45563000E-03  -7.63082000E-03
   +2.80440000E-03  +1.52338900E-02  -3.48247000E-03  -1.94543900E-02  +6.08556780E-01
   -8.22100000E-05  -1.50650000E-04  +4.65000000E-06  +6.20970000E-04  +5.05320000E-04
   -2.52440000E-04  +5.99400000E-05  -3.57700000E-04  -2.60760000E-04  -2.61150000E-04
   +1.34260000E-04  +2.73140000E-04  +6.43940000E-04  +3.92870000E-04  +2.14800000E-05
   -2.05370000E-04  -2.62250000E-04  -6.37500000E-05  +1.18264000E-03  +1.48012000E-03
   +3.49709000E-03  -1.62850000E-04  -4.22710000E-04  +2.88800000E-05  -8.47660000E-04
   -4.82150000E-04  +4.74500000E-05  +2.15600800E-02  +1.13932900E-02  -2.46927900E-02
   +5.30100000E-04  -1.29884000E-03  +9.18990000E-04  +6.72648000E-03  -9.86570000E-04
   -6.97214000E-03  -2.89934300E-02  -3.24526400E-02  +5.10960300E-02  -2.32629460E-01
   +4.57590450E-01  +5.54300000E-05  +1.73300000E-04  +3.40960000E-04  +6.59620000E-04
   -1.59374000E-03  -1.76840000E-04  +2.31840000E-04  -6.75600000E-05  -7.69200000E-05
   -2.08200000E-05  -1.81200000E-05  -2.49000000E-05  -3.64870000E-04  -3.79860000E-04
   -1.62830000E-04  +2.35380000E-04  +3.40990000E-04  -2.12000000E-06  +2.78427000E-03
   +3.87625000E-03  -2.26619000E-03  -5.02810000E-04  +5.94260000E-04  -4.60500000E-05
   +5.29510000E-04  +3.32060000E-04  +7.72000000E-06  +2.98195100E-02  -7.91831000E-03
   -1.22063800E-02  +7.33286000E-03  -1.56440600E-02  +1.06689500E-02  -1.31987000E-02
   +6.20018000E-03  +3.39106000E-03  +9.04276000E-03  +2.78490000E-02  -4.95167200E-02
   -1.90399400E-01  -1.63800350E-01  +4.73839420E-01  -9.10820000E-04  -6.57380000E-04
   +9.31600000E-05  -6.80250000E-04  +1.96814000E-03  -2.08700000E-04  +4.17850000E-04
   -2.06130000E-04  +2.61150000E-04  -5.14970000E-04  -8.72500000E-05  +3.48950000E-04
   +5.21660000E-04  +1.73130000E-04  -3.14400000E-04  +1.36000000E-06  -8.56700000E-05
   +2.29100000E-04  -1.51359100E-02  +4.90486000E-03  +1.43535000E-02  -2.15698000E-03
   +5.23800000E-04  +1.81592000E-03  -6.34800000E-04  -3.52430000E-04  +5.01500000E-05
   -1.62852250E-01  +4.72739800E-02  +4.88656700E-02  +2.24816500E-02  -4.87145200E-02
   +3.78786300E-02  -2.17429300E-02  +2.11281400E-02  -4.20049000E-03  +5.76670000E-04
   -6.47986000E-03  +4.87654000E-03  -2.79267670E-01  +1.43605300E-01  +4.80659500E-02
   +5.24115310E-01  +8.38510000E-04  +7.54990000E-04  +2.14230000E-04  +5.27110000E-04
   -3.39856000E-03  -4.07060000E-04  -1.39270000E-04  +1.03280000E-04  -2.24160000E-04
   +3.92550000E-04  +1.32940000E-04  -1.71740000E-04  -5.21120000E-04  -2.02330000E-04
   +9.79300000E-05  +1.33850000E-04  +1.43100000E-04  -2.21180000E-04  +1.59094100E-02
   +4.65610000E-03  -1.43139900E-02  +1.36463000E-03  -1.47765000E-03  -7.86510000E-04
   +6.12010000E-04  +3.40070000E-04  +2.62000000E-06  -1.46949000E-03  -9.38149700E-02
   +4.62273000E-02  -2.38644500E-02  +1.33120300E-02  +1.10944800E-02  +2.77373000E-03
   -3.45732000E-03  +6.06390000E-04  +6.41304000E-03  +3.89360000E-03  -1.24952200E-02
   +1.71201720E-01  -1.91497090E-01  -2.92404000E-03  -2.15848610E-01  +4.77740210E-01
   +1.99960000E-04  +9.52000000E-06  -6.67000000E-05  -1.85983000E-03  +1.27697000E-03
   +3.33290000E-04  -3.75450000E-04  -5.36200000E-05  -5.66840000E-04  +3.21360000E-04
   +1.15120000E-04  -3.45500000E-05  -2.69500000E-05  +2.05650000E-04  +2.56880000E-04
   -2.33030000E-04  -3.19260000E-04  +4.62300000E-05  +1.83266000E-03  -3.74649000E-03
   +5.04871000E-03  -1.00461000E-03  -2.19200000E-04  -5.92250000E-04  -1.15650000E-04
   -7.32900000E-05  -1.21900000E-05  +1.03507030E-01  +3.12701000E-03  -1.48696400E-01
   +1.05500700E-02  +3.29900500E-02  -4.18199200E-02  +1.53678200E-02  -1.54436600E-02
   +2.46939000E-03  -9.34366000E-03  -8.67850000E-04  +7.32248000E-03  +1.90924200E-02
   +2.11973100E-02  -9.32749800E-02  -1.39316400E-01  -2.06612680E-01  +4.68688960E-01
   +1.83300000E-05  -6.34600000E-05  -1.74760000E-04  -1.85800000E-05  +2.81240000E-04
   -9.21800000E-05  -1.18780000E-04  +6.68800000E-05  +5.20700000E-05  -6.36800000E-05
   +7.36400000E-05  +4.82800000E-05  +3.21130000E-04  +2.28830000E-04  +6.14000000E-05
   -1.06770000E-04  -1.45580000E-04  -6.98500000E-05  +4.08570000E-04  -7.24000000E-06
   -7.18700000E-05  -2.61740000E-04  +3.07270000E-04  +2.43770000E-04  -4.07750000E-04
   -2.26790000E-04  -7.59000000E-06  +8.47390000E-04  -1.19105000E-03  -3.91054000E-03
   +2.50720000E-03  -2.69891000E-03  +1.42700000E-05  -6.83099000E-03  -1.30777900E-02
   +3.42010000E-02  -1.21718070E-01  +1.17871000E-02  +5.65906100E-02  -1.15886100E-01
   +8.78122500E-02  -2.10956600E-02  +1.80527000E-03  +2.56099000E-02  -2.20251200E-02
   +2.08603510E-01  -9.65700000E-05  +1.17250000E-04  +2.22820000E-04  -2.34540000E-04
   -7.63940000E-04  -9.56600000E-05  +1.51460000E-04  +1.87510000E-04  +1.74930000E-04
   +9.28200000E-05  -1.32300000E-04  -1.80550000E-04  -6.67590000E-04  -5.53250000E-04
   -1.61870000E-04  +3.13800000E-04  +4.07090000E-04  +1.07350000E-04  -4.52360000E-04
   -1.89500000E-05  -1.01561000E-03  +5.47940000E-04  -2.26290000E-04  +1.21810000E-04
   +9.17470000E-04  +5.55870000E-04  -3.42900000E-05  -2.41836000E-03  +7.68379000E-03
   -1.07282200E-02  +5.01938000E-03  -1.77503200E-02  +1.43723700E-02  -1.57892300E-02
   +2.38463300E-02  +4.51162000E-03  +2.22155200E-02  -6.07466200E-02  -2.91510000E-03
   +7.88932900E-02  -1.93134260E-01  +1.06321750E-01  +1.49137000E-02  -2.55666200E-02
   +2.43894800E-02  -1.09817740E-01  +3.32565810E-01  +1.62380000E-04  -5.69000000E-05
   -1.81730000E-04  +1.81500000E-05  +7.23760000E-04  +1.75050000E-04  -1.06730000E-04
   -2.11580000E-04  -2.43850000E-04  -1.52000000E-05  +1.05430000E-04  +1.38880000E-04
   +4.69290000E-04  +4.48140000E-04  +1.62380000E-04  -2.97910000E-04  -3.73540000E-04
   -5.98000000E-05  -3.69000000E-04  -5.15840000E-04  +6.38820000E-04  -7.05600000E-05
   +2.96120000E-04  -1.96250000E-04  -6.79430000E-04  -4.26100000E-04  +4.51400000E-05
   -1.99672000E-03  -1.23007700E-02  +1.15257100E-02  -8.62272000E-03  +2.13150500E-02
   -1.68863500E-02  +3.72315400E-02  +1.91334000E-03  -2.10425500E-02  +4.49642100E-02
   +6.64340000E-03  -9.28462500E-02  -1.13146800E-02  +9.86209700E-02  -1.31160470E-01
   -1.01498500E-02  +1.45515900E-02  +1.75466000E-03  -4.11159200E-02  -2.36120510E-01
   +3.28540720E-01  +6.06900000E-05  -9.55000000E-05  -2.75630000E-04  -5.68000000E-06
   +4.23620000E-04  -1.83750000E-04  -2.91900000E-05  +1.51500000E-04  -7.42000000E-06
   -1.71240000E-04  +1.24670000E-04  +1.76750000E-04  +7.27320000E-04  +3.99110000E-04
   +3.80500000E-05  -1.48720000E-04  -2.13290000E-04  -1.11790000E-04  +9.97760000E-04
   -3.67340000E-04  -2.04800000E-05  -3.82690000E-04  +1.35330000E-04  +1.91070000E-04
   -8.45870000E-04  -4.60730000E-04  +1.43500000E-05  +1.74224000E-03  +3.64121000E-03
   -5.23090000E-03  +1.07218000E-03  -9.34988000E-03  +1.21482800E-02  -4.08554500E-02
   +6.11622100E-02  -7.55418000E-03  -2.85670500E-01  +2.81377000E-01  -1.22264890E-01
   +2.31241000E-03  +3.56961000E-03  -1.09915000E-03  -1.78137000E-03  -4.00960000E-04
   +1.97109000E-03  +2.67903800E-02  -6.71959000E-03  -2.77580000E-03  +2.98282950E-01
   +6.43000000E-06  +1.27240000E-04  +2.25300000E-04  -1.72320000E-04  -5.27440000E-04
   +9.39900000E-05  +7.05000000E-06  +7.10000000E-07  +4.81100000E-05  +2.10360000E-04
   -1.08890000E-04  -2.38130000E-04  -8.10680000E-04  -4.77640000E-04  -3.70800000E-05
   +1.79530000E-04  +2.62240000E-04  +1.05690000E-04  -9.83870000E-04  +4.04590000E-04
   -2.80730000E-04  +3.86540000E-04  -1.89520000E-04  -1.29480000E-04  +9.72690000E-04
   +5.72840000E-04  -3.89200000E-05  -2.95086000E-03  -1.67040000E-03  +6.22136000E-03
   -1.30879000E-03  +1.11263600E-02  -8.12998000E-03  +4.87414600E-02  -2.53601600E-02
   +1.23198200E-02  +2.84604330E-01  -4.68970430E-01  +1.78002650E-01  -7.15645000E-03
   +1.12547100E-02  +1.35700000E-05  +4.80548000E-03  -3.25558000E-03  -5.60720000E-04
   +6.36158000E-03  -5.35941800E-02  +7.10313500E-02  -3.33731800E-01  +5.35709370E-01
   +4.56200000E-05  -5.08800000E-05  -6.19300000E-05  +1.38000000E-06  +2.33000000E-04
   +4.30200000E-05  +1.85600000E-05  -5.67300000E-05  -9.93000000E-05  -4.68900000E-05
   +4.78100000E-05  +8.84500000E-05  +2.47530000E-04  +1.68670000E-04  +2.34000000E-05
   -1.04220000E-04  -1.19310000E-04  -1.30100000E-05  +8.49000000E-05  -2.63280000E-04
   +2.36140000E-04  -9.05200000E-05  +9.33300000E-05  -4.25100000E-05  -3.12590000E-04
   -1.81220000E-04  +2.82000000E-05  +2.60804000E-03  -2.58650000E-04  -1.03071000E-03
   +3.06806000E-03  -8.35230000E-04  +9.60940000E-04  +6.02314000E-03  +1.26083000E-03
   +1.88118000E-02  -1.25893610E-01  +1.80970160E-01  -1.62629890E-01  +1.07955000E-02
   -9.76069000E-03  +6.48615000E-03  -3.69584000E-03  +4.01935000E-03  -1.16014000E-03
   -1.72401100E-02  +8.29063300E-02  -6.09631000E-02  +1.28571200E-01  -2.57255010E-01
   +2.00370720E-01  -1.31141000E-03  -6.28790000E-04  -3.25780000E-04  -6.06226000E-03
   -2.13599500E-02  -2.42118700E-02  -5.44562000E-03  -1.58282000E-03  +1.59713000E-03
   +1.32450000E-04  -1.31151000E-03  -8.39010000E-04  +3.95010000E-04  +1.55680000E-04
   +5.85000000E-06  +2.04000000E-04  -5.47280000E-04  -7.62300000E-04  -7.68055200E-02
   -5.81423000E-03  -7.32320000E-03  +5.51210000E-04  +1.94600000E-04  -8.50470000E-04
   -5.59920000E-04  -2.92820000E-04  +1.63100000E-05  +1.76652000E-03  +1.65385100E-02
   +1.63588500E-02  -3.93820000E-04  +1.15400000E-04  +1.26310000E-03  -7.32060000E-04
   +3.20600000E-04  -1.71070000E-04  +9.80830000E-04  -7.67280000E-04  -9.76500000E-05
   +1.50000000E-05  -1.64241000E-03  +4.71100000E-05  -2.91028000E-03  +1.98564000E-03
   -3.97060000E-04  -4.44120000E-04  +7.91630000E-04  -2.28890000E-04  -4.77800000E-04
   +4.86860000E-04  -1.15940000E-04  +5.81046060E-01  +2.26510000E-04  -2.41710000E-04
   +7.57250000E-04  -7.86827000E-03  -1.23169900E-02  -1.26914800E-02  -2.27148000E-03
   +2.67710000E-04  +3.67920000E-04  +2.46270000E-04  -4.06540000E-04  -4.81840000E-04
   -2.38600000E-04  +1.15670000E-04  -2.30600000E-05  +4.27800000E-04  -5.40480000E-04
   -5.11000000E-04  -1.40737600E-02  -1.12809230E-01  -4.82738600E-02  +1.69868000E-03
   +1.01484800E-02  +1.06288000E-02  +1.04900000E-04  +2.19700000E-05  -2.62800000E-05
   +5.96127000E-03  -2.43778000E-02  -1.78725500E-02  +5.71830000E-04  -4.01720000E-04
   -1.19202000E-03  +2.39800000E-04  +3.59620000E-04  +9.17100000E-05  -2.35650000E-04
   +4.45810000E-04  -1.33570000E-04  +3.59030000E-04  +7.90550000E-04  +2.81400000E-05
   -3.95200000E-04  -1.13238000E-03  +6.83690000E-04  +1.11150000E-04  -5.02740000E-04
   +2.64380000E-04  +1.24000000E-04  -1.77270000E-04  +7.81800000E-05  -1.43801100E-02
   +5.29284000E-01  +1.26207000E-03  +7.48960000E-04  +1.56100000E-05  -3.87987000E-03
   +3.97890000E-04  +2.10388000E-03  +1.62069000E-03  +6.78250000E-04  -1.63960000E-04
   +4.72920000E-04  +2.11370000E-04  +1.46030000E-04  -2.43720000E-04  -1.10600000E-05
   +3.01450000E-04  +1.50230000E-04  -1.10000000E-07  -1.35350000E-04  -1.36132500E-02
   -4.19023200E-02  -1.28179730E-01  -5.07754000E-03  -1.78586200E-02  -3.71371400E-02
   +3.42380000E-04  +1.67680000E-04  -5.49200000E-05  +7.23276000E-03  -8.38926000E-03
   -1.38895000E-03  -1.42709000E-03  +1.17975000E-03  +1.73720000E-04  +1.14800000E-04
   +1.61370000E-04  -3.66590000E-04  +2.72330000E-04  -2.90090000E-04  +3.86250000E-04
   +5.73620000E-04  -8.49460000E-04  +3.41760000E-04  -1.78291000E-03  +8.99150000E-04
   +1.70350000E-04  -2.73030000E-04  +5.61680000E-04  -4.00150000E-04  -1.22250000E-04
   +1.33550000E-04  -1.20380000E-04  -1.87705600E-02  -6.47020400E-02  +5.21688420E-01
   +1.37373000E-03  -1.16319000E-03  -9.33150000E-04  +2.30100000E-05  +5.37760000E-04
   +6.15550000E-04  -6.57170000E-04  -2.45780000E-04  -2.55770000E-04  +1.97895000E-03
   -4.50190000E-04  -2.04217000E-03  -8.28743000E-03  -3.52931900E-02  -3.16835100E-02
   -6.10551000E-03  -2.58830000E-03  +2.02521000E-03  -1.93150000E-04  +5.45900000E-05
   +9.07600000E-05  +5.79900000E-05  -6.36000000E-06  -7.12000000E-06  -3.97565100E-02
   -4.94472000E-03  +1.49561100E-02  -5.47300000E-05  +6.08200000E-05  +2.92900000E-05
   -6.79000000E-06  +1.75900000E-05  +7.00000000E-06  +8.60600000E-05  -3.04000000E-06
   -2.86800000E-05  -1.83730000E-04  +1.35510000E-04  -3.01100000E-05  -8.25600000E-05
   +1.08300000E-04  -4.47100000E-05  +6.81400000E-05  -5.05100000E-05  +1.00900000E-05
   +5.67600000E-05  -1.03370000E-04  +6.96800000E-05  +1.22100000E-04  -1.16910000E-04
   +4.05700000E-05  +8.48500000E-05  +7.29000000E-06  -3.07300000E-05  +5.25240000E-02
   +1.14180000E-04  +1.59920000E-04  -1.61714000E-03  +1.37730000E-04  +4.72260000E-04
   +3.89190000E-04  -2.89600000E-05  -1.00835000E-03  -3.62980000E-04  +4.12167000E-03
   +3.03346000E-03  +1.60813000E-03  -2.20522000E-03  -1.97214100E-02  -1.54413100E-02
   -3.56067000E-03  +1.19638000E-03  +1.04904000E-03  -1.91210000E-04  -6.58600000E-05
   -1.95700000E-05  +9.90300000E-05  +2.97100000E-05  +3.45600000E-05  -4.08003900E-02
   -2.85398290E-01  -2.54041880E-01  -3.51500000E-05  +1.24660000E-04  +4.13700000E-05
   +1.76800000E-05  +2.38000000E-06  -1.25100000E-05  +7.93900000E-05  -3.93300000E-05
   -4.59800000E-05  -1.49720000E-04  +1.76870000E-04  -5.26800000E-05  -8.32100000E-05
   +1.21980000E-04  -7.15600000E-05  +8.39000000E-05  -7.41900000E-05  +1.06100000E-05
   +4.43500000E-05  -1.36890000E-04  +1.09870000E-04  +1.03870000E-04  -1.48260000E-04
   +4.58600000E-05  +6.13000000E-05  -1.39300000E-05  -2.25300000E-05  +4.28204000E-02
   +3.01214590E-01  +2.85130000E-04  -9.58890000E-04  +6.44800000E-04  +2.00360000E-04
   +5.56100000E-05  +1.43300000E-04  -3.27900000E-05  -2.02490000E-04  -8.40090000E-04
   +2.47228000E-03  +4.12084000E-03  +1.77313000E-03  +7.16170000E-04  +2.72576000E-03
   -5.65660000E-04  +1.00800000E-03  +4.71000000E-04  +2.06603000E-03  -1.22530000E-04
   -3.33300000E-05  -1.41970000E-04  +1.26700000E-04  +6.09300000E-05  +4.42500000E-05
   -2.01469900E-02  -2.73664930E-01  -2.61070260E-01  -2.06000000E-06  +4.17400000E-05
   -1.43800000E-05  +4.11000000E-06  -2.11500000E-05  +4.38100000E-05  +1.34900000E-05
   +9.96000000E-06  -9.41000000E-06  -5.18800000E-05  +6.92000000E-06  +2.96900000E-05
   -6.89000000E-06  +1.11900000E-05  -1.65900000E-05  +8.14000000E-06  -1.95700000E-05
   +4.10000000E-07  +2.77400000E-05  -1.19400000E-05  -1.23300000E-05  +3.04100000E-05
   -1.19600000E-05  -8.23000000E-06  +1.21200000E-05  -4.57000000E-06  -1.55200000E-05
   +1.56366300E-02  +2.67803040E-01  +2.58503170E-01  -1.55240000E-03  +1.56000000E-06
   +3.46050000E-04  -3.51742000E-03  -3.76888000E-03  +2.39448000E-03  -2.66590000E-04
   -2.14140700E-02  -1.95178700E-02  -6.50151900E-02  -4.14044800E-02  -2.34834900E-02
   +6.78376000E-03  +1.55343500E-02  +1.38105400E-02  -2.02467000E-03  +2.59080000E-04
   +4.41481000E-03  +4.28390000E-04  -8.49870000E-04  -9.35700000E-04  +1.36000000E-06
   +6.00300000E-05  -1.13100000E-04  +2.34964000E-03  +2.30061000E-03  -1.13463000E-03
   +1.78140000E-04  -1.03720000E-04  -4.64300000E-05  -8.08000000E-06  -2.56800000E-05
   +3.51700000E-05  -4.65500000E-05  +7.54500000E-05  +2.65300000E-05  +6.58700000E-05
   -9.86700000E-05  -1.13100000E-05  +4.84000000E-05  -7.57500000E-05  +5.88500000E-05
   -7.29400000E-05  +7.60100000E-05  +7.00000000E-06  -3.40500000E-05  +8.58600000E-05
   -4.97000000E-05  -4.62400000E-05  +7.97300000E-05  -9.46000000E-06  -4.28380000E-04
   -8.88900000E-05  +1.37850000E-04  -7.49070000E-04  -9.10110000E-04  -1.74240000E-04
   +6.34341000E-02  +3.21280000E-04  +3.30000000E-07  +6.98690000E-04  -4.06854000E-03
   +3.47365000E-03  -1.66274000E-03  -5.42850000E-04  -7.77763000E-03  -9.89565000E-03
   -4.16434400E-02  -2.03092820E-01  -1.43732990E-01  -6.63556000E-03  -4.49271000E-03
   -4.83273000E-03  +6.52810000E-04  +2.95544000E-03  -2.83301000E-03  +1.20450000E-04
   -9.97500000E-05  -6.98920000E-04  -6.40800000E-05  -1.15800000E-05  -1.13000000E-05
   +1.86916000E-03  +3.55060000E-04  +3.08861000E-03  +1.73130000E-04  -1.44320000E-04
   -1.51300000E-05  +3.36900000E-05  +7.21000000E-06  +4.89000000E-06  -6.09000000E-05
   +1.85500000E-05  +1.16800000E-05  +1.01850000E-04  -6.46900000E-05  -1.09100000E-05
   +4.75600000E-05  -5.84200000E-05  +3.35800000E-05  -6.57600000E-05  +7.02900000E-05
   +1.63000000E-05  -3.74700000E-05  +5.03500000E-05  -2.29400000E-05  -6.19000000E-05
   +5.92500000E-05  -1.20000000E-05  -2.61840000E-04  -1.15130000E-04  +1.16700000E-04
   +1.08508000E-03  +9.89700000E-05  -1.05014000E-03  +4.79228400E-02  +2.11054120E-01
   +6.10520000E-04  +8.94560000E-04  -3.33010000E-04  +1.81015000E-03  -2.11547000E-03
   +4.42247000E-03  +1.05058000E-03  +1.69351000E-03  +3.66523000E-03  -2.37775100E-02
   -1.43665660E-01  -1.61808800E-01  -7.83763000E-03  -1.71029300E-02  -8.37661000E-03
   +4.82031000E-03  -2.59669000E-03  +2.31790000E-04  +3.32540000E-04  -1.43370000E-04
   +1.76720000E-04  -3.37700000E-05  +5.82000000E-06  -5.18800000E-05  -1.66806000E-03
   +2.78841000E-03  -1.71170000E-04  -5.54900000E-05  -6.44000000E-06  -7.89000000E-06
   -4.05500000E-05  -2.59500000E-05  +1.93000000E-05  -8.77000000E-06  +4.31100000E-05
   +2.98600000E-05  +3.11200000E-05  -9.07900000E-05  +4.49400000E-05  +3.18600000E-05
   -5.90800000E-05  +3.84700000E-05  -2.12200000E-05  +1.73800000E-05  -3.55800000E-05
   -9.81000000E-06  +7.48400000E-05  -7.12700000E-05  -3.09300000E-05  +6.92200000E-05
   -2.43800000E-05  -1.75400000E-05  +6.04100000E-05  +6.61000000E-06  +1.78572000E-03
   +6.83300000E-05  -3.58380000E-04  +2.50331500E-02  +1.58254030E-01  +1.65151940E-01
   +1.57186000E-03  -2.47883000E-03  +1.18690000E-04  +7.64069000E-03  -1.94707000E-03
   -3.89466000E-03  -1.87978050E-01  +5.27174200E-02  +1.30938170E-01  -1.47848100E-02
   +9.58513000E-03  +1.95903900E-02  -1.96146000E-03  -4.90195000E-03  +4.89830000E-04
   -3.49300000E-04  -3.51800000E-04  -8.33980000E-04  -4.46020000E-04  +4.51250000E-04
   -8.05480000E-04  -6.70700000E-05  -2.14350000E-04  +6.38400000E-05  -1.47769000E-03
   +2.61100000E-04  +9.90410000E-04  -7.70680000E-04  -5.99500000E-04  -2.66190000E-04
   -3.72910000E-04  +2.15310000E-04  -4.82120000E-04  +3.26770000E-04  -2.61230000E-04
   +5.79200000E-05  -2.11300000E-04  +1.79690000E-04  -1.69700000E-05  -2.11460000E-04
   +2.33950000E-04  -1.32300000E-05  -2.71500000E-05  -8.79100000E-05  -1.14180000E-04
   +3.63500000E-05  -1.31800000E-04  +8.26100000E-05  +1.18290000E-04  -1.56700000E-04
   +5.14500000E-05  +1.36200000E-05  +1.39520000E-04  -6.21400000E-05  +1.65310000E-04
   +2.20010000E-04  +1.17330000E-04  +2.07710000E-04  +1.06900000E-03  -1.41632000E-03
   +1.98050550E-01  -3.02133000E-03  -7.79150000E-04  -5.48910000E-03  +1.75651900E-02
   -1.66079000E-03  -1.50648400E-02  +5.31232900E-02  -7.71449800E-02  -6.54889500E-02
   -1.15685000E-02  +7.99664000E-03  +1.01374600E-02  -4.57997000E-03  +2.17221000E-03
   -3.17236000E-03  -4.14780000E-04  -9.57390000E-04  +4.65760000E-04  +1.49581000E-03
   -8.55240000E-04  +1.27059000E-03  -1.89240000E-04  -5.54760000E-04  -3.88760000E-04
   -6.51750000E-04  +1.44450000E-04  +6.16220000E-04  -3.31290000E-04  +1.17400000E-05
   +2.38920000E-04  -1.49230000E-04  +5.34570000E-04  -4.91300000E-04  +2.37970000E-04
   -3.81900000E-04  +1.84300000E-05  -8.64700000E-05  +2.13900000E-04  -3.53400000E-05
   -2.13180000E-04  +2.65570000E-04  -3.40900000E-05  +1.19730000E-04  -1.22780000E-04
   -9.35700000E-05  +5.12400000E-05  -2.19900000E-04  +1.54520000E-04  +7.84700000E-05
   -1.57920000E-04  +5.64700000E-05  +1.05320000E-04  -2.40400000E-05  +1.00810000E-04
   +6.76000000E-05  +7.51600000E-05  +5.94400000E-05  +1.45755000E-03  -1.40652000E-03
   +2.22740000E-03  -5.37517700E-02  +7.37173500E-02  -1.56840000E-04  -5.93797000E-03
   +7.79160000E-04  +1.49572000E-02  -4.77578000E-03  -8.51268000E-03  +1.30728940E-01
   -6.46214500E-02  -1.71851600E-01  -6.84350000E-04  -1.39301000E-03  +3.04734000E-03
   +9.05520000E-04  -2.89839000E-03  +4.75728000E-03  -1.02095000E-03  +3.72960000E-04
   -3.10820000E-04  +1.87050000E-04  +1.85959000E-03  -1.40490000E-03  +1.26600000E-05
   +7.44400000E-05  -4.09600000E-05  +2.05200000E-04  +1.23290000E-04  -7.97100000E-05
   -5.33270000E-04  -2.30950000E-04  +3.64140000E-04  +1.14790000E-04  +1.36380000E-04
   -2.24110000E-04  +5.76700000E-05  +9.95100000E-05  -1.01600000E-05  -3.24800000E-04
   +2.43660000E-04  -6.25400000E-05  -2.85870000E-04  +2.00050000E-04  -3.47700000E-05
   -8.61000000E-06  +5.09700000E-05  +3.79700000E-05  +1.18700000E-04  -1.79880000E-04
   +1.22060000E-04  +1.72880000E-04  -1.80110000E-04  +5.68100000E-05  -2.55060000E-04
   +5.72300000E-05  -5.97700000E-05  -5.02800000E-05  -3.09700000E-05  -3.01200000E-05
   -1.14477000E-03  +2.46395000E-03  -1.54037000E-03  -1.43973360E-01  +7.41720500E-02
   +1.75739150E-01  -6.50658800E-02  -3.91399400E-02  -2.50849800E-02  +9.33716000E-03
   +1.57647800E-02  +1.29733900E-02  -2.15136000E-03  +7.59800000E-05  +4.88600000E-03
   -1.31992000E-03  +9.46000000E-05  +2.08720000E-04  -3.12095000E-03  -3.72106000E-03
   +2.47193000E-03  -9.86260000E-04  -2.17910200E-02  -1.89010400E-02  +2.20410000E-04
   +9.87390000E-04  -1.17866000E-03  +2.72690000E-04  -7.68100000E-05  -7.93600000E-05
   -1.64270000E-04  -1.14833000E-03  -1.03470000E-03  -1.48040000E-04  +3.84000000E-06
   -1.61840000E-04  -6.10900000E-05  -5.36800000E-05  +7.19200000E-05  +4.92900000E-05
   -3.47800000E-05  -5.70400000E-05  -8.69100000E-05  +1.03310000E-04  +1.91900000E-05
   -1.36200000E-05  +6.02200000E-05  -3.25900000E-05  +3.56900000E-05  -4.62000000E-05
   -7.55000000E-06  +3.27500000E-05  -6.73500000E-05  +3.64800000E-05  +6.65600000E-05
   -8.39700000E-05  +1.41600000E-05  -3.09105000E-03  -9.78910000E-04  +9.65770000E-04
   -3.78920000E-04  -1.63980000E-04  -6.98200000E-05  -3.85300000E-05  +1.69860000E-04
   -2.11810000E-04  +3.19980000E-04  +9.15940000E-04  +8.14260000E-04  +6.86867500E-02
   -3.88718300E-02  -2.05891380E-01  -1.45385440E-01  -2.20239000E-03  -2.46305000E-03
   -5.60012000E-03  +1.60190000E-04  +3.26973000E-03  -3.48025000E-03  +2.23730000E-04
   -7.95700000E-05  +9.12900000E-04  -3.81519000E-03  +3.79574000E-03  -2.14365000E-03
   -1.14181000E-03  -6.98275000E-03  -1.03375600E-02  +2.12410000E-04  -2.31711000E-03
   +1.38822000E-03  -4.22110000E-04  -1.33660000E-04  +1.06200000E-04  -2.58780000E-04
   -6.83840000E-04  -5.74010000E-04  +2.55290000E-04  +2.75850000E-04  -1.60700000E-04
   +1.50130000E-04  +6.15600000E-05  -1.66310000E-04  -1.61300000E-05  -2.34800000E-05
   +7.98400000E-05  +5.24000000E-06  +3.13700000E-05  -7.05600000E-05  -3.16700000E-05
   +5.04000000E-05  -5.09000000E-05  +1.25250000E-04  -1.28700000E-04  +5.87700000E-05
   +1.60000000E-06  -5.05600000E-05  +6.15700000E-05  -9.08000000E-06  -3.29000000E-06
   +2.45300000E-05  -2.48750000E-03  -2.26900000E-04  +3.11900000E-04  -9.24300000E-05
   -1.44640000E-04  +9.93900000E-05  +1.41430000E-04  -3.69290000E-04  +2.80250000E-04
   -2.13070000E-04  -2.33050000E-04  -1.90640000E-04  +4.87346300E-02  +2.14602850E-01
   -2.47409000E-02  -1.45480690E-01  -1.71173080E-01  -5.12962000E-03  -1.56340100E-02
   -8.49610000E-03  +5.00517000E-03  -3.20061000E-03  +6.74470000E-04  +2.71400000E-04
   +9.63740000E-04  -2.96460000E-04  +2.38516000E-03  -2.20427000E-03  +4.48985000E-03
   +1.71542000E-03  +1.06834000E-03  +4.16063000E-03  -2.14231000E-03  +8.24590000E-04
   -1.75930000E-03  +6.61540000E-04  +1.30370000E-04  -2.79100000E-05  -1.66870000E-04
   -9.41100000E-05  +2.99700000E-05  -1.89010000E-04  -9.44300000E-05  +1.40130000E-04
   -3.06400000E-05  -4.21300000E-05  +1.17250000E-04  -2.01300000E-05  +5.51500000E-05
   -2.31500000E-05  +2.56000000E-06  -6.89800000E-05  +2.18700000E-05  +4.97600000E-05
   -6.72400000E-05  +4.11000000E-05  -1.32820000E-04  +1.15320000E-04  -4.10000000E-06
   -1.23700000E-05  +6.34400000E-05  -5.19300000E-05  -7.25000000E-06  +3.58000000E-05
   -1.38800000E-05  -4.68960000E-04  -6.55670000E-04  +4.70060000E-04  +3.31000000E-06
   +1.42150000E-04  -5.94000000E-05  -2.41850000E-04  +2.56270000E-04  -3.33170000E-04
   -2.88470000E-04  -8.08300000E-04  -5.76890000E-04  +2.56388000E-02  +1.61143490E-01
   +1.73893170E-01  -1.36511300E-02  +9.52016000E-03  +1.84880300E-02  -2.37833000E-03
   -4.76323000E-03  +6.21900000E-04  -3.00820000E-04  -3.85070000E-04  -8.28950000E-04
   +1.23117000E-03  -2.43716000E-03  +7.91000000E-05  +6.86323000E-03  -3.39099000E-03
   -4.19806000E-03  -1.92591890E-01  +5.00282900E-02  +1.37529050E-01  -1.51760000E-04
   +6.34210000E-04  +8.34770000E-04  -2.23210000E-04  -5.56800000E-05  -8.70500000E-05
   +3.48970000E-04  +1.40775000E-03  -7.86760000E-04  -2.91900000E-05  -2.07930000E-04
   +3.87500000E-05  -2.27600000E-05  -3.63700000E-05  +5.64200000E-05  -5.93900000E-05
   +5.11400000E-05  -2.86000000E-06  +7.06700000E-05  -7.65800000E-05  +3.18600000E-05
   +4.01200000E-05  -6.58400000E-05  +5.07200000E-05  -1.00630000E-04  +1.09080000E-04
   -1.97000000E-05  -1.96900000E-05  +6.62300000E-05  -5.71400000E-05  -4.78400000E-05
   +6.22000000E-05  -2.94100000E-05  +6.27000000E-06  +1.08970000E-04  +4.33200000E-05
   -4.76600000E-05  +2.16920000E-04  -7.03000000E-05  +3.46790000E-04  -1.15060000E-04
   -3.70670000E-04  -1.09440000E-04  +2.29310000E-04  -1.06950000E-04  +1.58600000E-04
   +1.14388000E-03  -1.43892000E-03  +2.00676580E-01  -1.06786900E-02  +7.66420000E-03
   +1.11422500E-02  -4.38604000E-03  +2.05246000E-03  -2.60558000E-03  -6.58500000E-04
   -1.18585000E-03  +2.59330000E-04  -2.79712000E-03  -9.35930000E-04  -5.05059000E-03
   +1.81892500E-02  -6.69820000E-04  -1.61905600E-02  +4.88530400E-02  -7.19132200E-02
   -6.38389100E-02  -4.63760000E-04  +4.80880000E-04  +2.30810000E-04  -2.30900000E-05
   +4.68800000E-05  -4.34600000E-05  +1.21899000E-03  -2.17600000E-04  +2.66899000E-03
   -1.96300000E-04  -1.74770000E-04  +4.41300000E-05  -4.10000000E-07  +9.60000000E-07
   -2.07100000E-05  +5.31000000E-06  +5.05000000E-06  +1.82000000E-06  +2.11200000E-05
   -1.08100000E-05  -8.67000000E-06  +3.84000000E-06  -6.26000000E-06  +3.55800000E-05
   -2.97100000E-05  +4.74800000E-05  -1.01600000E-05  -1.97500000E-05  +1.63200000E-05
   -4.22000000E-06  -1.23700000E-05  +6.81000000E-06  +4.05000000E-06  +8.98300000E-05
   +2.13100000E-05  +6.07800000E-05  +1.41350000E-04  +5.09000000E-06  +4.87930000E-04
   +8.79640000E-04  -3.46040000E-04  -7.11070000E-04  +2.03290000E-04  -2.53260000E-04
   +3.29220000E-04  +1.54327000E-03  -1.42097000E-03  +2.22019000E-03  -5.18759400E-02
   +6.67850800E-02  -1.62785000E-03  -1.41020000E-04  +3.23936000E-03  +7.59000000E-04
   -2.40564000E-03  +4.34143000E-03  -1.17013000E-03  +7.61600000E-05  -3.65500000E-04
   -3.19260000E-04  -5.27647000E-03  +6.25360000E-04  +1.73424600E-02  -4.09973000E-03
   -8.38344000E-03  +1.36445000E-01  -6.45377800E-02  -1.75858020E-01  -4.88400000E-05
   -1.65360000E-04  +2.59140000E-04  -1.87100000E-05  -6.19400000E-05  +2.30000000E-07
   -9.96490000E-04  +2.54569000E-03  -4.85900000E-04  +1.16060000E-04  +6.94400000E-05
   -1.01700000E-05  +1.40000000E-06  -7.30000000E-06  +1.56700000E-05  +5.06000000E-06
   +4.66000000E-06  -1.21800000E-05  -3.83700000E-05  +2.79400000E-05  -5.60000000E-07
   -1.37300000E-05  +2.03300000E-05  -2.48400000E-05  +1.95100000E-05  -1.82700000E-05
   +1.41700000E-05  +1.87100000E-05  -2.49200000E-05  +1.43500000E-05  +2.55900000E-05
   -2.28700000E-05  +3.67000000E-06  -2.57000000E-06  +4.20200000E-05  -5.92400000E-05
   -1.40800000E-04  +4.47300000E-04  -3.44500000E-05  +6.34730000E-04  -1.67760000E-04
   -6.25220000E-04  -1.13090000E-04  +3.14240000E-04  -3.29920000E-04  -1.05060000E-03
   +2.44379000E-03  -1.46000000E-03  -1.49829160E-01  +7.10177500E-02  +1.79149280E-01
   +2.22530000E-04  +1.15020000E-04  +1.21650000E-04  +7.33170000E-04  -1.54906000E-03
   +2.30860000E-04  +3.66450000E-04  +1.67120000E-04  +1.44920000E-04  -2.22790000E-04
   +4.87800000E-05  -1.12600000E-05  -5.23000000E-06  -8.67400000E-05  -1.43480000E-04
   +8.72600000E-05  +7.15700000E-05  -6.21600000E-05  -6.48170000E-04  -9.79380000E-04
   +9.28170000E-04  -2.16282530E-01  +1.32686370E-01  +2.50455000E-03  +3.77000000E-05
   +6.22000000E-06  +2.44000000E-05  +3.42020000E-04  -3.03470000E-04  +5.26010000E-04
   +9.27900000E-05  -1.87020000E-04  +2.93410000E-04  -3.27200000E-05  +2.88100000E-05
   -7.64500000E-05  +4.35500000E-05  -2.64240000E-04  +2.46620000E-04  +2.64990000E-04
   -1.00400000E-05  -1.33330000E-04  -1.29400000E-04  -9.05000000E-06  +4.36140000E-04
   -1.39750000E-04  +2.99620000E-04  -2.95130000E-04  -8.89000000E-05  +1.84590000E-04
   -1.13280000E-04  -2.20380000E-04  -5.23600000E-05  +2.82880000E-04  -9.30000000E-06
   +4.90000000E-07  -2.25000000E-06  +9.00000000E-08  +8.98000000E-06  -6.20000000E-07
   +2.70900000E-05  -5.23400000E-05  +4.28300000E-05  +3.14500000E-05  +1.79300000E-05
   -3.83000000E-06  +2.28100000E-05  +9.59000000E-06  +5.12000000E-06  +2.31584300E-01
   -3.38840000E-04  +1.48670000E-04  +4.66200000E-05  +1.11748000E-03  +4.94020000E-04
   -2.03970000E-04  -1.84560000E-04  -3.71340000E-04  -5.76980000E-04  +7.70400000E-05
   +2.03600000E-05  -5.61200000E-05  -2.36140000E-04  -7.85900000E-05  +1.22360000E-04
   -1.53910000E-04  -7.67000000E-06  +8.50100000E-05  +1.34596500E-02  -1.28795500E-02
   +1.95500000E-04  +1.30814820E-01  -1.48587650E-01  -3.34133000E-03  +2.24090000E-04
   +1.50410000E-04  -1.09500000E-05  -1.12951000E-03  -8.54080000E-04  +3.48408000E-03
   +9.99420000E-04  -2.28470000E-04  -3.42140000E-04  +5.54700000E-05  -3.83820000E-04
   +2.22360000E-04  -2.75120000E-04  +2.33100000E-04  +4.61000000E-06  -1.21470000E-04
   +3.45070000E-04  -9.24600000E-05  -5.74200000E-05  +1.84080000E-04  +2.82350000E-04
   +2.59200000E-05  -1.86420000E-04  +5.76200000E-05  +1.69740000E-04  -1.78560000E-04
   +5.14200000E-05  -4.82790000E-04  +3.00130000E-04  -1.14954000E-03  -1.28500000E-05
   -3.81800000E-05  -5.14000000E-06  +1.50500000E-05  -8.87000000E-06  +1.58700000E-05
   +4.05600000E-05  +1.15770000E-04  +1.46070000E-04  +2.78800000E-05  -2.16300000E-05
   +4.95300000E-05  +1.41000000E-06  -1.00400000E-05  -9.00000000E-08  -1.43481820E-01
   +1.60566580E-01  -8.66900000E-05  -1.13230000E-04  +2.04090000E-04  -1.03681000E-03
   -1.00250000E-04  +6.53900000E-04  +4.18790000E-04  +4.09000000E-06  -9.33600000E-05
   -4.12820000E-04  +6.25600000E-05  +1.18110000E-04  +1.91960000E-04  -6.10400000E-05
   -2.26500000E-04  +1.99880000E-04  +8.32700000E-05  -4.47500000E-05  -2.19963500E-02
   +1.79784900E-02  -1.78237000E-03  +4.34099000E-03  -4.71608000E-03  -4.61455000E-02
   -2.18830000E-04  -1.17930000E-04  +1.73200000E-05  +1.45567000E-03  +1.93034000E-03
   -4.77358000E-03  -1.38271000E-03  +1.17639000E-03  +2.08180000E-04  +1.03470000E-04
   +2.44970000E-04  -2.80730000E-04  +2.27450000E-04  -5.34000000E-06  -2.15780000E-04
   -1.40090000E-04  -1.58300000E-05  +2.99950000E-04  +7.53460000E-04  +2.45350000E-04
   -4.42510000E-04  -3.80400000E-05  -1.73950000E-04  +9.85200000E-05  -8.95200000E-05
   +2.47600000E-05  +6.53900000E-05  -9.37700000E-04  +1.03579000E-03  +1.26556000E-03
   +1.83000000E-05  +1.54700000E-05  +1.74200000E-05  +1.08700000E-05  -1.89300000E-05
   +2.24000000E-06  +3.03000000E-05  -1.46800000E-05  +5.73800000E-05  +1.78900000E-05
   -1.39200000E-05  -1.08330000E-04  -1.92000000E-06  +1.12700000E-05  +7.34000000E-06
   -4.36734000E-03  +3.34260000E-04  +5.20868100E-02  +6.22990000E-04  -3.04550000E-04
   -2.04260000E-04  +3.88160000E-04  -7.75040000E-04  +8.16240000E-04  +2.74850000E-04
   +3.02990000E-04  +4.58980000E-04  -1.67850000E-04  +5.77100000E-05  +7.39000000E-05
   +3.46260000E-04  +1.95150000E-04  -1.76900000E-05  -1.10930000E-04  -1.17450000E-04
   -1.07240000E-04  +1.35340000E-04  +9.84400000E-04  -5.68120000E-04  -2.29435650E-01
   -1.22344480E-01  +1.71409500E-02  -3.94570000E-04  -2.21560000E-04  +8.64000000E-06
   -2.66440000E-04  +1.03240000E-04  +4.16660000E-04  +9.90200000E-05  -1.40060000E-04
   -2.61900000E-05  +4.42000000E-05  -3.71900000E-05  +2.55800000E-05  -1.56160000E-04
   -5.27200000E-05  +1.43280000E-04  +1.81480000E-04  +1.63810000E-04  -2.21110000E-04
   -4.11720000E-04  +9.59790000E-04  +5.05810000E-04  -1.05010000E-04  +7.17300000E-05
   -1.66590000E-04  +5.30000000E-05  +1.92800000E-05  -4.04300000E-05  +4.72260000E-04
   +3.12220000E-04  -4.52840000E-04  +3.53500000E-05  +4.60400000E-05  +1.87000000E-05
   -3.07100000E-05  -1.52500000E-05  -1.93500000E-05  -1.69200000E-05  +6.98000000E-06
   -3.74500000E-05  -3.50700000E-05  +6.56200000E-05  +1.94300000E-05  -2.74600000E-05
   +1.54000000E-06  -1.73000000E-06  -1.95357300E-02  -1.48898000E-02  +1.36399000E-03
   +2.49575260E-01  +3.49940000E-04  -4.69170000E-04  -2.49840000E-04  +1.52810000E-04
   -8.08060000E-04  +3.34704000E-03  -3.83930000E-04  -1.21170000E-04  +2.24420000E-04
   +3.27590000E-04  +1.00530000E-04  +6.29000000E-06  +1.93000000E-04  +4.78300000E-04
   +4.36050000E-04  -6.52140000E-04  -2.88970000E-04  -2.64360000E-04  -1.42041000E-02
   -9.36823000E-03  +2.64900000E-05  -1.21255090E-01  -1.28386840E-01  +1.16209900E-02
   -4.46110000E-04  -2.57090000E-04  -4.87900000E-05  -8.49200000E-04  +5.18490000E-04
   -8.81500000E-05  +2.28860000E-04  -1.90480000E-04  +1.71940000E-04  -7.18500000E-05
   +1.05830000E-04  -5.25500000E-05  -7.11100000E-05  -3.50570000E-04  +4.03240000E-04
   +4.02800000E-04  +5.71600000E-05  -2.92100000E-04  -3.57100000E-05  -4.81690000E-04
   +7.34670000E-04  -1.68140000E-04  +4.82420000E-04  -4.58150000E-04  -7.04200000E-05
   +2.34240000E-04  -1.72900000E-04  +3.43000000E-05  +4.49420000E-04  -1.42597000E-03
   +3.37700000E-05  +3.55300000E-05  +3.01700000E-05  -2.30500000E-05  -4.25800000E-05
   -1.36400000E-05  -4.13800000E-05  +2.32240000E-04  -1.18220000E-04  +4.63000000E-05
   -2.67100000E-05  +1.22680000E-04  -8.30900000E-05  +1.18300000E-05  -3.88600000E-05
   +1.66484700E-02  +1.22826000E-02  -1.63760000E-03  +1.32963220E-01  +1.36926690E-01
   +5.47210000E-04  +5.75120000E-04  +1.01790000E-04  -1.05136000E-03  +2.31551000E-03
   -4.26265000E-03  -5.87000000E-06  -3.86130000E-04  -7.32200000E-05  +6.03360000E-04
   -1.45400000E-04  +4.13200000E-05  -4.45740000E-04  -4.76000000E-05  +1.48330000E-04
   +1.91670000E-04  -1.86120000E-04  +3.04810000E-04  +2.35432100E-02  +1.41341300E-02
   -3.10307000E-03  +1.66451700E-02  +1.04677400E-02  -5.01856800E-02  +5.47710000E-04
   +3.37440000E-04  -2.41600000E-05  +1.55940000E-04  -5.83820000E-04  +6.47440000E-04
   -3.81200000E-05  +5.41000000E-05  -2.21650000E-04  +6.12900000E-05  -9.61900000E-05
   +2.54200000E-05  -2.37000000E-05  +7.24400000E-05  -1.26900000E-05  -1.87150000E-04
   +6.81900000E-05  +1.22500000E-05  -1.96870000E-04  -2.19610000E-04  +1.66720000E-04
   +1.98900000E-05  -2.77500000E-05  +6.31700000E-05  +1.90600000E-05  -4.70600000E-05
   +1.31200000E-05  +1.26886000E-03  +7.67360000E-04  +1.28397000E-03  -1.54700000E-05
   -3.85300000E-05  -4.94600000E-05  +4.48400000E-05  +2.74100000E-05  +1.80100000E-05
   -2.06780000E-04  +3.85650000E-04  -5.63800000E-05  -2.90100000E-05  +9.86800000E-05
   -1.73020000E-04  +7.44300000E-05  +2.02000000E-05  -8.30000000E-06  +6.08220000E-04
   +2.65920000E-04  -9.46280000E-04  -1.93235900E-02  -1.44012900E-02  +5.30117500E-02
   -2.25800000E-04  -4.93400000E-05  +9.46100000E-05  +1.61760000E-04  +7.48250000E-04
   +4.49960000E-04  -1.33810000E-04  -1.46920000E-04  +1.12940000E-04  -2.72470000E-04
   -2.93700000E-05  -4.35400000E-05  -3.46300000E-05  -1.42370000E-04  -1.07830000E-04
   +1.73240000E-04  +8.91100000E-05  +6.54100000E-05  -1.95194000E-03  -1.10920000E-04
   -3.61830000E-04  -4.89638800E-02  -1.39023100E-02  -1.73285000E-02  +8.22800000E-05
   +4.80500000E-05  -7.03000000E-06  +3.24360000E-04  -5.54340000E-04  -3.40350000E-04
   -7.35500000E-05  +1.80310000E-04  -1.34090000E-04  +9.05000000E-05  -1.21650000E-04
   +4.71700000E-05  -1.47300000E-05  +2.28400000E-04  -2.31360000E-04  -1.94410000E-04
   +1.43680000E-04  +1.85650000E-04  +3.01200000E-05  +3.92410000E-04  -5.45330000E-04
   +7.15000000E-05  -3.28680000E-04  +2.34780000E-04  +7.03000000E-05  -1.57110000E-04
   +1.09840000E-04  +5.56800000E-05  +3.21710000E-04  -2.80570000E-04  -1.58100000E-05
   -2.08000000E-05  +8.24000000E-06  +1.85900000E-05  -1.47500000E-05  +2.22300000E-05
   +1.65180000E-04  -3.61670000E-04  +1.60730000E-04  +1.73100000E-05  -1.72000000E-06
   -6.12200000E-05  +1.87000000E-06  +6.66000000E-06  -8.72000000E-06  +2.71432000E-03
   +1.48517200E-02  +2.13003800E-02  -1.38591000E-03  -1.51065500E-02  -2.20535300E-02
   +4.97354200E-02  -1.44540000E-04  +2.84400000E-05  -7.03200000E-05  +5.27800000E-04
   +7.62240000E-04  -1.49450000E-04  -3.79370000E-04  -1.16110000E-04  +6.41400000E-04
   +3.75400000E-05  -1.39380000E-04  -7.83000000E-05  -3.14800000E-05  -5.91700000E-05
   -1.25690000E-04  +1.05360000E-04  +9.87700000E-05  +9.96300000E-05  +1.12902000E-03
   +1.04981400E-02  +1.44653000E-02  -1.41590100E-02  -1.43504370E-01  -1.28944600E-01
   +1.44730000E-04  +6.41700000E-05  +5.09000000E-06  +3.52500000E-04  +8.67830000E-04
   -7.27610000E-04  -2.00730000E-04  -8.95400000E-05  +8.01600000E-05  -1.19770000E-04
   +1.48860000E-04  -3.79400000E-05  +1.23740000E-04  -1.95900000E-05  -9.63900000E-05
   +1.20590000E-04  -8.82200000E-05  +7.03800000E-05  +4.40090000E-04  +2.28080000E-04
   +2.28970000E-04  -5.08800000E-05  -1.02080000E-04  +1.84100000E-05  -4.46900000E-05
   +2.41400000E-05  +2.05800000E-05  -3.66000000E-05  -1.50829000E-03  +2.66498000E-03
   -1.60700000E-05  -7.58000000E-06  -1.46800000E-05  +1.62000000E-06  +4.18000000E-06
   +2.00900000E-05  -2.29460000E-04  -7.96470000E-04  +2.78500000E-04  +1.19700000E-05
   -1.42300000E-05  +2.59300000E-05  +1.05100000E-05  -5.57000000E-06  +3.53000000E-06
   -3.05976000E-03  -1.14606100E-02  -1.50564500E-02  +5.59030000E-04  -1.00488900E-02
   -1.29720600E-02  +1.44456900E-02  +1.54522770E-01  +8.11580000E-04  -4.85600000E-05
   -2.56870000E-04  -1.52965000E-03  -6.36890000E-04  +7.79970000E-04  +8.85600000E-05
   -7.12890000E-04  -1.30440000E-04  +6.11050000E-04  +2.58150000E-04  +1.81390000E-04
   -1.69950000E-04  +3.99440000E-04  +4.24690000E-04  -4.95020000E-04  -3.28500000E-04
   -7.21200000E-05  -2.07325000E-03  -1.68950200E-02  -2.05158800E-02  -1.68037100E-02
   -1.26941830E-01  -2.18187010E-01  -6.22000000E-05  -8.31000000E-06  -1.34300000E-05
   +9.24710000E-04  -1.15442000E-03  +9.70350000E-04  +1.92000000E-06  +4.83250000E-04
   -1.56940000E-04  +1.14720000E-04  -1.49650000E-04  +4.18400000E-05  +4.70500000E-05
   +1.17920000E-04  -2.46710000E-04  -3.34820000E-04  +1.89840000E-04  +3.11140000E-04
   +3.26860000E-04  +3.16000000E-04  -1.32700000E-05  -5.43000000E-06  -2.93240000E-04
   +1.71320000E-04  +2.77900000E-05  -8.43500000E-05  +1.08170000E-04  +4.80960000E-04
   +4.46309000E-03  -4.63964000E-03  +2.74000000E-05  +9.34000000E-06  -3.91000000E-06
   +3.93900000E-05  -4.90000000E-06  -4.69000000E-06  -1.37910000E-04  +6.56750000E-04
   +1.30780000E-04  -1.29710000E-04  +4.56900000E-05  +8.80800000E-05  -3.68000000E-06
   +1.67100000E-05  -2.29500000E-05  -2.18200000E-05  +5.37900000E-04  +2.18170000E-04
   +2.75860000E-04  +2.78924000E-03  +3.15364000E-03  +1.90513800E-02  +1.38189940E-01
   +2.38372280E-01  -1.23340000E-04  -3.76880000E-04  -5.78270000E-04  +4.20800000E-04
   +5.63630000E-04  -3.36720000E-04  -6.26900000E-05  -8.71500000E-05  -2.76700000E-05
   +1.55060000E-04  +8.61300000E-05  +7.22000000E-06  -9.77800000E-05  +4.40000000E-06
   +5.96900000E-05  -1.03260000E-04  +5.15200000E-05  +2.31790000E-04  -1.47025000E-03
   +3.01774000E-03  -4.69452000E-03  -1.71130000E-04  -9.41740000E-04  -8.93370000E-04
   +1.28600000E-04  +1.00570000E-04  +2.27200000E-05  -1.72590000E-04  -3.35650000E-04
   +5.42210000E-04  +1.37750000E-04  +8.68500000E-05  +8.49200000E-05  -2.39780000E-04
   +1.00560000E-04  -9.87300000E-05  -7.65800000E-05  +5.99300000E-05  +8.95800000E-05
   +8.16000000E-05  -2.66200000E-05  +4.54100000E-05  -6.27400000E-05  +9.05200000E-05
   +1.06220000E-04  +1.21900000E-05  +2.95200000E-05  -7.28100000E-05  +2.64800000E-05
   -2.64000000E-05  -2.93600000E-05  -4.78351900E-02  -6.99622000E-03  +1.42079600E-02
   -1.23400000E-05  -1.04500000E-05  -4.96000000E-06  +1.50300000E-05  +1.32500000E-05
   +9.84000000E-06  -1.26900000E-05  +6.07400000E-05  +4.20100000E-05  -1.44992000E-03
   +2.51420000E-04  -3.53230000E-04  -1.50700000E-05  +5.17000000E-06  -2.71000000E-05
   +2.38360000E-04  -2.58820000E-04  +3.01580000E-04  +2.14990000E-04  +2.64610000E-04
   -2.23800000E-04  +6.41670000E-04  +1.48370000E-04  -4.12840000E-04  +4.87334900E-02
   -4.96800000E-04  +4.65440000E-04  +2.47880000E-04  +2.43390000E-04  +9.15660000E-04
   +5.80830000E-04  +2.10160000E-04  -1.56210000E-04  -1.45900000E-05  +1.48350000E-04
   +3.91500000E-05  -5.75500000E-05  -1.10880000E-04  +5.41800000E-05  +1.87940000E-04
   -5.89800000E-05  -2.02840000E-04  -1.56430000E-04  +2.03050000E-03  +9.65072000E-03
   -1.86074500E-02  -5.06560000E-04  -2.51389000E-03  -2.85359000E-03  +5.57700000E-05
   -4.05000000E-06  -3.50000000E-05  -4.25710000E-04  +9.80730000E-04  +1.80800000E-05
   +4.17090000E-04  -3.75160000E-04  -9.32780000E-04  -9.24000000E-06  -2.13660000E-04
   +2.32340000E-04  +1.32190000E-04  -3.22800000E-05  +2.12400000E-05  -8.45600000E-05
   -3.49900000E-05  +5.19700000E-05  +2.24400000E-04  +2.46300000E-05  -3.90000000E-07
   -7.24500000E-05  +9.31700000E-05  -5.74700000E-05  -1.13700000E-04  +7.47400000E-05
   -1.64700000E-05  -6.63860000E-03  -1.04872840E-01  +1.10474740E-01  -1.13700000E-05
   -7.38000000E-06  -4.56000000E-06  +1.16900000E-05  +1.58500000E-05  -1.31900000E-05
   +2.31000000E-06  +1.85900000E-05  -3.48100000E-05  -2.00080000E-04  -2.32490000E-04
   -1.43970000E-04  -8.58000000E-06  +3.18300000E-05  -2.18700000E-05  -2.69810000E-04
   +3.57500000E-05  -1.54310000E-04  +2.22760000E-04  -5.63700000E-05  -1.18930000E-04
   -1.39260000E-04  +8.37870000E-04  -1.12653000E-03  +8.37018000E-03  +1.13037330E-01
   +3.21180000E-04  -3.64550000E-04  +5.43000000E-06  +1.09835000E-03  +8.55440000E-04
   +8.00670000E-04  -1.28360000E-04  -4.60760000E-04  +9.25000000E-06  +2.30770000E-04
   +1.24850000E-04  -1.78900000E-05  -6.29100000E-05  +1.87430000E-04  +1.28310000E-04
   -2.96120000E-04  -7.08700000E-05  +2.37940000E-04  +1.66456000E-03  +1.16815700E-02
   -2.02194700E-02  -6.52440000E-04  -4.76123000E-03  -3.35753000E-03  -1.42000000E-06
   +1.03700000E-05  +1.90500000E-05  -1.29108000E-03  +5.43810000E-04  +1.18737000E-03
   +1.37600000E-04  +1.37043000E-03  -7.92350000E-04  +4.60040000E-04  -7.34160000E-04
   +5.21350000E-04  -3.42200000E-05  -4.18200000E-05  -1.73450000E-04  -4.74260000E-04
   +2.44530000E-04  +1.50080000E-04  +9.64400000E-04  -2.10380000E-04  -4.39460000E-04
   +3.16100000E-05  -2.05700000E-05  +3.64100000E-05  -6.14600000E-05  +4.43700000E-05
   +6.74300000E-05  +1.40798600E-02  +1.08637720E-01  -2.58297690E-01  -5.08000000E-06
   +7.67000000E-06  -8.49000000E-06  -2.15500000E-05  +2.40600000E-05  -3.08400000E-05
   -1.85500000E-05  +1.04430000E-04  +2.59200000E-05  -3.64840000E-04  +3.70970000E-04
   +1.84600000E-04  -2.18200000E-05  -2.70700000E-05  -1.49000000E-06  -8.78000000E-06
   -2.63200000E-05  +2.58200000E-04  +9.56000000E-06  -1.03670000E-04  +3.94650000E-04
   -1.26590000E-04  +8.14630000E-04  -1.49607000E-03  -1.50082700E-02  -1.17849850E-01
   +2.81640520E-01  -6.23600000E-05  +1.91090000E-04  +3.62600000E-04  +8.06200000E-04
   -3.16490000E-04  -5.38650000E-04  -1.25420000E-04  +8.39300000E-05  +2.79780000E-04
   -1.08790000E-04  -1.22190000E-04  -1.05840000E-04  +1.57770000E-04  +6.85300000E-05
   -4.21300000E-05  +1.29680000E-04  -1.64750000E-04  -2.12650000E-04  -4.68618000E-03
   -1.24508000E-03  +1.02850000E-03  -5.47900000E-05  +2.03110000E-04  +5.60100000E-04
   -2.27270000E-04  -1.53960000E-04  -2.43900000E-05  +8.38320000E-04  +1.36197000E-03
   -2.45870000E-04  +2.66140000E-04  -4.95880000E-04  +3.75190000E-04  -2.02460000E-04
   +1.28480000E-04  -7.85000000E-05  -1.41900000E-05  -4.22300000E-05  -1.90000000E-05
   +1.52850000E-04  -9.29500000E-05  -1.43690000E-04  +5.11800000E-05  -2.04300000E-04
   +1.60880000E-04  +2.09200000E-05  -5.59000000E-06  +1.37500000E-05  +1.75300000E-05
   +1.93100000E-05  -5.20000000E-06  -2.73929370E-01  -9.64381000E-02  +2.38945700E-02
   +2.47000000E-05  +2.35500000E-05  +8.86000000E-06  -4.90200000E-05  -1.84200000E-05
   -1.76200000E-05  +6.38300000E-05  -6.08900000E-05  -5.80500000E-05  +1.36730000E-04
   -2.13670000E-04  -4.48380000E-04  -1.07600000E-05  -1.71000000E-06  +1.71300000E-05
   +4.15300000E-05  -1.04590000E-04  +7.11100000E-05  +3.33150000E-04  +2.92310000E-04
   -6.04010000E-04  +3.66680000E-04  +1.87880000E-04  -4.31300000E-05  -6.20350000E-04
   +5.37360000E-04  -1.67150000E-04  +2.94679090E-01  +5.69980000E-04  -7.45400000E-05
   -5.94460000E-04  +6.86930000E-04  -2.10490000E-03  -3.85998000E-03  -1.36273000E-03
   -6.72700000E-05  +2.51450000E-04  -8.36600000E-05  -3.33970000E-04  -1.19910000E-04
   +2.84950000E-04  +3.50200000E-05  -1.02250000E-04  -1.00420000E-04  +1.86040000E-04
   +9.86500000E-05  -1.93378100E-02  -1.06047000E-02  +1.75769000E-03  +4.32270000E-04
   +2.30590000E-04  +1.21007000E-03  -2.51660000E-04  -1.05300000E-04  +3.99600000E-05
   -1.09023000E-03  +5.91300000E-04  -2.93400000E-05  -6.89400000E-05  -4.37060000E-04
   +5.88190000E-04  -6.45100000E-05  +1.43280000E-04  -3.71900000E-05  +1.15650000E-04
   -2.80200000E-04  +1.46640000E-04  +4.57440000E-04  -3.65980000E-04  -8.14000000E-06
   -2.42610000E-04  +1.79490000E-04  +1.22490000E-04  -5.60800000E-05  +2.32500000E-04
   -1.99390000E-04  -8.47600000E-05  +1.60570000E-04  -8.18500000E-05  -9.49705700E-02
   -8.67418100E-02  +1.09951800E-02  +3.72200000E-05  +2.73800000E-05  +1.20400000E-05
   -1.00120000E-04  -1.03570000E-04  +3.01100000E-05  +4.21000000E-06  +3.98100000E-05
   -6.66200000E-05  +1.41050000E-04  +9.75000000E-06  +3.94490000E-04  -4.39300000E-05
   -2.80000000E-07  -9.26000000E-06  +1.23940000E-04  +5.86400000E-05  -2.25600000E-05
   +1.59170000E-04  +5.64770000E-04  -1.36830000E-04  +2.34420000E-04  -5.95500000E-05
   +7.57100000E-05  -1.33178200E-02  -6.03346000E-03  +6.94220000E-04  +1.05486250E-01
   +9.40963700E-02  +7.87860000E-04  -4.53330000E-04  -4.66190000E-04  +6.11400000E-04
   -2.75354000E-03  -3.88229000E-03  -1.46108000E-03  -6.41810000E-04  +4.29960000E-04
   +8.64900000E-05  -2.44320000E-04  -2.23010000E-04  +9.85400000E-05  +1.07520000E-04
   -1.34800000E-05  -1.89700000E-04  +3.08100000E-05  +2.44660000E-04  -2.28539600E-02
   -9.94385000E-03  +6.90530000E-04  -1.26790000E-03  -6.45180000E-04  +1.31574000E-03
   -1.07170000E-04  -1.74400000E-05  +3.57100000E-05  -6.20710000E-04  +5.33760000E-04
   +3.20630000E-04  +4.98800000E-04  -3.17480000E-04  +6.21400000E-05  -4.43070000E-04
   +2.22290000E-04  -1.76000000E-06  +1.43370000E-04  -1.51540000E-04  +3.10900000E-05
   +3.33270000E-04  -2.35910000E-04  -3.02000000E-06  -3.64100000E-04  +1.68410000E-04
   +3.06720000E-04  -8.82500000E-05  +1.59170000E-04  -1.32290000E-04  -1.09860000E-04
   +1.39790000E-04  -6.38900000E-05  +2.53752000E-02  +1.17469200E-02  -4.95581100E-02
   +1.91100000E-05  +1.49200000E-05  +1.74000000E-06  -1.24500000E-04  -4.61500000E-05
   -2.10800000E-05  +4.11000000E-06  +3.44800000E-05  +4.13000000E-06  +3.20000000E-06
   +5.70600000E-04  +2.02070000E-04  -2.26800000E-05  -2.94800000E-05  +1.27400000E-05
   +4.11200000E-05  -1.43500000E-05  -7.84200000E-05  +2.90090000E-04  +2.24520000E-04
   -7.04810000E-04  +3.03930000E-04  +1.17330000E-04  +2.19930000E-04  +2.68809400E-02
   +1.01160300E-02  -1.68563000E-03  -2.62947100E-02  -8.18083000E-03  +5.37601700E-02
   -6.97490000E-04  -6.78510000E-04  +4.89780000E-04  +1.16980000E-04  +7.76800000E-05
   +3.32310000E-04  +6.69300000E-05  +4.37200000E-05  -5.50700000E-05  +8.77100000E-05
   +4.20000000E-05  -2.44000000E-06  -1.83090000E-04  +1.07800000E-05  +2.98400000E-05
   +3.64500000E-05  -1.03200000E-04  -1.30650000E-04  +3.40582000E-03  -4.76807000E-03
   -1.13110000E-04  +3.49860000E-04  -3.16620000E-04  -6.68700000E-05  +1.20010000E-04
   +4.89800000E-05  -1.76600000E-05  +5.30830000E-04  +5.05990000E-04  -4.91580000E-04
   +2.60630000E-04  -6.02950000E-04  +5.39390000E-04  -2.78860000E-04  +2.20000000E-04
   -6.21400000E-05  +1.86980000E-04  -1.68630000E-04  +1.44300000E-05  +2.31010000E-04
   -1.84830000E-04  +2.83900000E-05  +1.85290000E-04  +4.46800000E-05  -1.56800000E-05
   -3.41100000E-05  +9.31400000E-05  -6.60600000E-05  -1.06550000E-04  +1.34800000E-04
   -4.53100000E-05  -1.65215640E-01  +1.32957230E-01  -5.48069000E-03  -2.00300000E-05
   -1.21700000E-05  -6.34000000E-06  +1.84800000E-05  +1.81400000E-05  -8.40000000E-07
   -1.31000000E-06  +1.50400000E-05  +1.58400000E-05  -1.33891000E-03  -1.70141000E-03
   +1.27610000E-04  +2.66200000E-05  -1.77200000E-05  +2.35300000E-05  +2.41860000E-04
   -3.61700000E-05  +1.78590000E-04  -2.12770000E-04  +1.51460000E-04  +6.37800000E-05
   +8.85400000E-05  -2.52290000E-04  +8.92000000E-05  +1.42181000E-03  -3.24964000E-03
   +1.59010000E-04  -1.80641700E-02  +2.24976800E-02  -1.57082000E-03  +1.78859570E-01
   +2.12740000E-04  -4.03200000E-04  -8.94560000E-04  +6.97930000E-04  +5.54220000E-04
   +2.96400000E-04  -3.25230000E-04  -8.84500000E-05  -1.53310000E-04  +1.90440000E-04
   +1.55310000E-04  +2.88500000E-05  -3.71300000E-05  +1.10000000E-07  +1.01380000E-04
   -3.13970000E-04  +3.00610000E-04  +3.81220000E-04  +1.41236400E-02  -1.55299300E-02
   +1.10175000E-03  +2.14640000E-04  +6.58030000E-04  +1.55113000E-03  +1.12360000E-04
   +1.26320000E-04  +4.97500000E-05  -8.71530000E-04  -1.86450000E-03  -3.52066000E-03
   +3.49870000E-04  -9.16000000E-06  -4.73620000E-04  +6.25300000E-05  -2.68500000E-05
   +4.31200000E-05  -3.70310000E-04  +3.92660000E-04  -7.24400000E-05  +2.36550000E-04
   +4.11840000E-04  -3.52740000E-04  -8.22900000E-05  -5.95890000E-04  +4.10410000E-04
   +1.62300000E-04  -4.31430000E-04  +2.75340000E-04  +2.38260000E-04  -2.69380000E-04
   +7.75900000E-05  +1.31776020E-01  -1.94814890E-01  +6.13480000E-03  -4.49000000E-06
   -1.51500000E-05  +1.08000000E-06  +1.22600000E-05  -6.46000000E-06  +2.32700000E-05
   +3.71800000E-05  +6.54600000E-05  +1.34330000E-04  -1.24354000E-03  -5.28330000E-04
   +9.08900000E-04  -2.23800000E-05  -3.11200000E-05  -1.30900000E-05  -2.81330000E-04
   +6.19990000E-04  -4.95430000E-04  -1.04240000E-04  -1.61500000E-05  -1.47560000E-04
   -3.32860000E-04  +1.40770000E-04  +1.69680000E-04  +9.08164000E-03  -1.02345800E-02
   -6.17510000E-04  -8.91612000E-03  +1.06401400E-02  -4.79920000E-04  -1.44755750E-01
   +2.10695900E-01  -2.85960000E-04  +4.65110000E-04  +4.58470000E-04  +1.41050000E-04
   +6.68930000E-04  +5.63720000E-04  -1.18000000E-05  +1.00200000E-05  -2.23190000E-04
   +1.34110000E-04  +5.45900000E-05  -4.30600000E-05  -1.13050000E-04  +7.88000000E-05
   +1.68510000E-04  -1.15660000E-04  -1.84030000E-04  -1.48450000E-04  +1.68530800E-02
   -1.85736800E-02  -1.25409000E-03  +9.83070000E-04  -8.53240000E-04  +1.06430000E-03
   +3.53200000E-05  -5.53000000E-06  -3.44600000E-05  -1.93445000E-03  -2.58622000E-03
   -2.09723000E-03  -5.86800000E-05  +1.21496000E-03  -8.37930000E-04  +7.88060000E-04
   -6.67950000E-04  +4.09110000E-04  -4.12010000E-04  +2.34980000E-04  +5.83000000E-06
   -3.60790000E-04  +6.54860000E-04  -5.20000000E-07  +1.38236000E-03  -7.22780000E-04
   -1.78300000E-04  +1.87210000E-04  -2.37590000E-04  +7.08900000E-05  +1.52900000E-04
   -1.59640000E-04  +6.57900000E-05  -5.42731000E-03  +7.11627000E-03  -4.77483000E-02
   -7.68000000E-06  -1.21200000E-05  -1.00000000E-07  +1.89900000E-05  -1.29800000E-05
   +8.25000000E-06  +3.62200000E-05  -2.10000000E-05  +3.43400000E-05  +2.65880000E-04
   +2.22700000E-04  +8.49700000E-05  +9.79000000E-06  -3.67000000E-06  +1.22400000E-05
   -5.25510000E-04  +2.79700000E-05  -7.03240000E-04  +1.09240000E-04  +1.13050000E-04
   -6.04600000E-05  -1.31840000E-04  +2.21590000E-04  +3.70440000E-04  -1.98699300E-02
   +2.05461700E-02  +4.23520000E-04  +2.32786000E-03  -2.72029000E-03  -7.82450000E-04
   +6.07022000E-03  -4.41753000E-03  +5.05028800E-02  -1.59600000E-05  +2.19500000E-05
   -5.37300000E-05  -2.13790000E-04  +1.03630000E-04  -1.88820000E-04  -3.54700000E-05
   +1.49660000E-04  +9.02500000E-05  +2.04000000E-06  -7.50000000E-06  -6.78100000E-05
   -5.60800000E-05  -4.99700000E-05  +7.82000000E-06  +4.27500000E-05  +1.77100000E-05
   +1.92800000E-05  -1.51740000E-04  -1.33459000E-03  -5.24490000E-04  -2.55564000E-03
   +1.81643000E-03  +9.49720000E-04  +8.95200000E-05  +4.83700000E-05  -1.09900000E-05
   +5.54045000E-03  -1.62595600E-02  +1.55420200E-02  -2.46273000E-03  +1.68441000E-03
   +4.32209000E-03  -2.82700000E-04  +3.81280000E-04  -3.87240000E-04  -9.47960000E-04
   -6.82300000E-05  +2.20213000E-03  -1.11589000E-03  +1.88207100E-02  -2.07444000E-02
   -5.08370100E-02  +1.41810400E-02  +7.17000000E-06  -5.23950000E-04  +5.74581000E-03
   +3.04582000E-03  +1.35800000E-04  +1.06330000E-04  -8.59660000E-04  +2.26020000E-04
   +6.83200000E-05  -1.33880000E-04  -1.20400000E-05  -1.53800000E-05  +3.38000000E-06
   +5.61000000E-06  +3.00000000E-07  +1.12800000E-05  +3.85600000E-05  -1.00880000E-04
   +2.52700000E-05  -4.88000000E-06  -1.18600000E-05  +3.40000000E-06  +1.01300000E-05
   -7.42000000E-06  +3.09000000E-06  +1.29150000E-04  -2.03540000E-04  -1.40260000E-04
   -4.97590000E-04  +1.37813000E-03  -5.33000000E-05  -1.50448000E-03  +3.64810000E-04
   -6.13270000E-04  +1.59000000E-06  -4.85000000E-05  -1.48820000E-04  +2.28900000E-05
   -4.82000000E-05  +9.84000000E-06  -5.84500000E-05  -5.06000000E-06  +2.53700000E-05
   +5.68103700E-02  -5.86600000E-05  -8.13100000E-05  -7.93200000E-05  -1.35270000E-04
   +3.18910000E-04  +2.46220000E-04  -1.04800000E-04  +9.71200000E-05  +1.39880000E-04
   +2.28000000E-06  -2.64200000E-05  -4.85300000E-05  +5.17900000E-05  +6.10000000E-05
   +2.60600000E-05  -3.72600000E-05  -3.56600000E-05  -1.64500000E-05  -4.76710000E-04
   -1.76630000E-03  -6.01100000E-04  +3.67311000E-03  -1.18093000E-03  -3.90140000E-04
   -6.86200000E-05  -5.30100000E-05  -1.20700000E-05  -1.56022000E-03  +3.03501000E-03
   +1.57627000E-03  +1.39072000E-03  +2.63927000E-03  +6.76360000E-04  +1.43530000E-04
   -2.74980000E-04  -1.08320000E-04  +8.23550000E-04  +1.03618000E-03  -3.71930000E-04
   -1.06770000E-03  -1.44922400E-02  +1.58370000E-02  +1.64143200E-02  -1.82136190E-01
   +1.49747270E-01  +5.68502000E-03  +3.49268000E-03  +1.79335000E-03  -3.14730000E-04
   -4.36820000E-04  +2.05100000E-05  +3.50450000E-04  -2.22690000E-04  -4.23000000E-06
   -2.10000000E-07  +6.55000000E-06  +8.69000000E-06  -1.34300000E-05  -1.33800000E-05
   +3.72000000E-06  -2.53900000E-05  -6.71100000E-05  +1.53600000E-05  +1.44400000E-05
   -4.14000000E-06  -8.00000000E-06  -1.12800000E-05  -9.08000000E-06  +2.06000000E-06
   +1.14570000E-04  -2.12950000E-04  -5.06340000E-04  +1.76280000E-03  -1.63107000E-03
   -4.12000000E-05  -1.06310000E-04  -2.66510000E-04  -2.38480000E-04  -3.34400000E-05
   -9.41000000E-06  +1.89500000E-05  -5.61900000E-05  -4.18000000E-06  -1.12300000E-05
   -5.59000000E-05  -3.36500000E-05  -8.76300000E-05  -2.46363300E-02  +1.94256630E-01
   -2.49900000E-05  -5.15500000E-05  -1.20000000E-07  -1.39500000E-04  +4.52300000E-05
   +1.06270000E-04  -1.15100000E-05  +1.13000000E-05  +7.36100000E-05  -1.93600000E-05
   -1.80200000E-05  +6.75000000E-06  +1.73000000E-05  +2.02600000E-05  -6.29000000E-06
   -9.79000000E-06  -2.10200000E-05  -6.36000000E-06  -1.71160000E-03  +4.13190000E-04
   -1.43729000E-03  -7.39910000E-04  +1.27775000E-03  +5.95380000E-04  -3.46500000E-05
   -2.79500000E-05  -5.70000000E-07  -8.93550000E-04  +1.48829700E-02  -1.26386200E-02
   +4.54122000E-03  +4.14190000E-04  -2.28490000E-04  -8.86900000E-05  -3.48000000E-04
   +2.12940000E-04  +1.19475000E-03  +4.33830000E-04  -2.02650000E-04  +1.11691000E-03
   -2.28530000E-03  +4.69690000E-04  -2.02367000E-03  +1.52069170E-01  -2.00355320E-01
   +3.13871000E-03  +1.77789000E-03  +4.93317000E-03  -3.95790000E-04  -3.54440000E-04
   +7.99700000E-05  +5.51540000E-04  -1.77380000E-04  +3.49400000E-05  -2.76000000E-06
   +6.46000000E-06  +1.90000000E-07  -7.34000000E-06  -3.02000000E-06  -3.02000000E-06
   +3.66000000E-06  +1.42900000E-05  -2.66800000E-05  +3.11000000E-06  +6.78000000E-06
   -1.70000000E-05  -6.27000000E-06  +1.33000000E-06  -2.25000000E-06  -6.14500000E-04
   -2.05380000E-04  +2.71120000E-04  -4.78630000E-04  -7.25340000E-04  +4.36960000E-04
   -4.48450000E-04  +2.54440000E-04  +1.70710000E-04  -7.73800000E-05  +7.73000000E-06
   +8.81200000E-05  -3.85200000E-05  -7.75700000E-05  -1.07470000E-04  -1.64600000E-05
   -1.37270000E-04  -1.09900000E-04  -1.10455000E-03  -1.64955490E-01  +2.09339880E-01
   -6.91800000E-05  -6.27300000E-05  -3.97900000E-05  -4.29000000E-06  +2.53640000E-04
   +3.85000000E-05  -1.28500000E-05  +2.34100000E-05  +5.46100000E-05  -3.38700000E-05
   -1.59000000E-05  +6.97000000E-06  +4.66200000E-05  +2.08800000E-05  -8.48000000E-06
   -7.27000000E-06  -1.19400000E-05  +1.37500000E-05  -4.16820000E-04  -6.64380000E-04
   +6.36360000E-04  -4.65500000E-05  -1.61100000E-05  +6.08000000E-06  -5.53500000E-05
   -3.35200000E-05  -3.77000000E-06  +1.82860000E-04  +5.50595000E-03  +5.75430000E-04
   +1.14990000E-04  -3.31000000E-06  -2.71180000E-04  -7.35600000E-05  +7.89000000E-05
   -4.28200000E-04  +1.44981000E-03  +1.97603000E-03  -1.40030000E-04  -1.73894970E-01
   -2.26990200E-02  +1.50916100E-01  -1.18129600E-02  -2.05681000E-03  +1.98494800E-02
   +1.01158800E-02  +5.98775000E-03  -1.28307200E-02  -4.22920000E-04  +4.98020000E-04
   -7.01300000E-04  -5.28900000E-05  +1.67500000E-05  -4.55000000E-05  +2.60000000E-06
   +6.42000000E-06  +5.10000000E-06  -1.28200000E-05  -8.91000000E-06  -4.70000000E-07
   +1.31300000E-05  +1.04800000E-05  -1.34000000E-06  +6.85000000E-06  +7.05000000E-06
   -8.33000000E-06  -8.77000000E-06  -5.57000000E-06  +1.53000000E-06  -2.23000000E-06
   +3.58600000E-05  -3.68000000E-06  +1.81500000E-05  +8.44000000E-06  -8.49000000E-06
   -1.16700000E-05  +3.50900000E-05  -6.00000000E-06  -1.16000000E-06  -2.64000000E-06
   -1.50000000E-06  +2.34100000E-05  +4.10000000E-06  +9.72000000E-06  -3.92000000E-06
   +6.14700000E-05  +1.39400000E-05  -1.75913000E-03  -1.59447000E-03  -1.46640000E-03
   +1.76748030E-01  +1.62000000E-05  +2.04700000E-05  -6.94000000E-06  +9.01400000E-05
   -1.60180000E-04  -2.04600000E-05  -4.75000000E-06  +2.96900000E-05  +4.27200000E-05
   -3.95000000E-06  +7.70000000E-07  -1.09600000E-05  -1.72900000E-05  -1.49900000E-05
   -6.75000000E-06  +1.50900000E-05  +1.89600000E-05  -9.42000000E-06  +1.80460000E-04
   +1.58280000E-04  -5.00800000E-04  -5.49500000E-05  -8.86000000E-06  -2.29200000E-05
   +2.96800000E-05  +1.39900000E-05  -1.48000000E-06  +4.41642000E-03  +1.22940000E-03
   +2.42397000E-03  +8.44900000E-05  -6.96570000E-04  +5.08680000E-04  -8.53970000E-04
   -1.02250000E-04  +3.94690000E-04  +3.43648000E-03  +2.63334000E-03  -1.92274000E-03
   -2.03596000E-02  -4.73112500E-02  +3.09055900E-02  +1.47110500E-02  +5.96909000E-03
   -1.18346300E-02  -1.35601000E-02  -1.66127900E-02  +3.45128600E-02  +1.91270000E-04
   -2.23822000E-03  +1.65770000E-03  +1.25740000E-04  -5.98000000E-06  +5.84700000E-05
   -3.38000000E-06  -2.63000000E-06  +1.33000000E-06  -1.97000000E-06  -2.00000000E-08
   +3.51000000E-06  +1.07000000E-05  -1.03000000E-06  +6.61000000E-06  -1.00000000E-08
   -8.19000000E-06  +1.35000000E-06  +5.54000000E-06  +1.14000000E-06  -1.69000000E-06
   +3.18100000E-05  +9.87000000E-06  +1.59900000E-05  +4.57700000E-05  -1.29000000E-06
   +1.28600000E-05  -1.74800000E-05  +2.06400000E-05  +2.39700000E-05  -5.27000000E-06
   -2.20000000E-06  -2.31100000E-05  -6.63000000E-06  -2.63000000E-06  -1.87000000E-06
   -2.25000000E-06  -1.04000000E-05  -4.25400000E-05  -1.05373000E-03  -1.82582000E-03
   -2.86012000E-03  +1.28441100E-02  +5.88789200E-02  +7.80000000E-07  +2.60000000E-07
   +3.85000000E-06  +6.92900000E-05  -4.40200000E-05  +8.36000000E-06  +2.69000000E-06
   +3.20000000E-06  +2.19600000E-05  -5.03000000E-06  -6.33000000E-06  -4.56000000E-06
   -1.41500000E-05  -7.72000000E-06  -4.98000000E-06  +4.76000000E-06  +7.48000000E-06
   +9.10000000E-07  -1.57910000E-04  -1.60600000E-05  -1.12570000E-04  -1.99900000E-05
   +1.10500000E-05  -7.69900000E-05  +1.91000000E-05  +6.63000000E-06  +8.50000000E-07
   +1.44922000E-03  +1.71370000E-03  +4.00304000E-03  -4.03320000E-04  +5.92460000E-04
   -4.88060000E-04  +6.00610000E-04  -4.49390000E-04  -4.94030000E-04  -1.69347000E-03
   -6.21760000E-04  +5.91477000E-03  +1.48450980E-01  +3.29467300E-02  -2.08482710E-01
   +1.25825000E-03  +3.55908000E-03  +2.32814000E-03  +8.79279000E-03  +1.66871300E-02
   -2.32204600E-02  -3.76660000E-04  +1.36838000E-03  -1.76474000E-03  +1.30100000E-04
   -1.18400000E-05  +2.89100000E-05  -4.03000000E-06  -4.00000000E-07  -1.40000000E-06
   -1.83000000E-06  +7.90000000E-07  -2.10000000E-07  +8.64000000E-06  +2.71000000E-06
   -6.08000000E-06  -9.30000000E-07  -4.10000000E-07  -2.16000000E-06  +1.08000000E-06
   +1.14000000E-06  -1.80000000E-06  +4.88000000E-06  +1.16500000E-05  +2.79100000E-05
   +2.45300000E-05  -1.33700000E-05  +2.09000000E-06  -6.61000000E-06  +3.36900000E-05
   +1.80900000E-05  -1.00500000E-05  -1.70000000E-07  -1.31200000E-05  +2.22000000E-06
   -9.30000000E-07  +6.51000000E-06  -4.51000000E-06  +6.01000000E-06  -4.31900000E-05
   -2.05858000E-03  -2.39221000E-03  -7.59600000E-04  -1.56129430E-01  -5.32135300E-02
   +2.23283940E-01  +4.14600000E-05  -4.40000000E-06  -5.05300000E-05  -3.62500000E-05
   +1.62100000E-05  -9.72000000E-06  +7.60000000E-07  +4.29500000E-05  +2.17700000E-05
   -1.25800000E-05  -2.71100000E-05  +2.83800000E-05  +2.95200000E-05  +4.13700000E-05
   +1.16100000E-05  -3.91500000E-05  -6.00500000E-05  +1.30000000E-07  +4.71920000E-04
   +3.35690000E-04  -6.41100000E-04  -2.40170000E-04  +9.27400000E-05  +8.69700000E-05
   -6.39400000E-05  -5.25300000E-05  +9.37000000E-06  -6.70200000E-05  +5.24872000E-03
   +9.61000000E-04  +6.69579000E-03  +1.33442700E-02  -1.61031700E-02  -6.46231200E-02
   -2.95547300E-02  +6.20783900E-02  -4.86309000E-03  -1.52809800E-02  +2.40250000E-02
   -4.52830000E-04  +2.12621000E-03  -1.75378000E-03  -3.23880000E-04  -1.27300000E-04
   +4.26760000E-04  -4.54538000E-03  +1.07532000E-03  +5.07866000E-03  +2.92510000E-04
   +4.80700000E-05  -1.69718000E-03  +2.33500000E-05  -1.17560000E-04  -7.53400000E-05
   -7.38000000E-06  +1.37100000E-05  -7.08000000E-06  -1.46300000E-05  -6.20000000E-07
   -1.52000000E-05  +1.24800000E-05  +1.65900000E-05  +2.77000000E-06  +4.87000000E-06
   +6.63000000E-06  -5.01000000E-06  -1.17700000E-05  +4.09000000E-06  -2.50000000E-06
   -1.78400000E-05  +4.80500000E-05  -8.69800000E-05  +1.08300000E-05  -7.60000000E-07
   +1.28400000E-05  +2.76000000E-06  -1.32600000E-05  -1.86000000E-05  +2.32000000E-05
   +3.50000000E-07  +5.30500000E-05  -6.24000000E-06  -9.49000000E-06  +1.78900000E-05
   -2.70100000E-05  +1.38100000E-05  +3.11800000E-05  +1.29600000E-05  -1.11720000E-04
   -1.61770000E-04  +1.84000000E-05  -2.52640000E-04  +7.07500000E-05  +6.85679600E-02
   +8.10300000E-05  +3.89700000E-05  -6.22100000E-05  -3.01480000E-04  -4.34900000E-05
   -1.91400000E-05  -2.91100000E-05  +8.27200000E-05  -4.35000000E-06  +3.14500000E-05
   +1.35000000E-06  +4.10000000E-07  -6.16000000E-06  +3.17100000E-05  +3.82900000E-05
   -1.60600000E-05  -2.94800000E-05  -3.21600000E-05  -2.92880000E-04  -1.01550000E-04
   +7.10480000E-04  +2.34420000E-04  -2.19450000E-04  -8.58900000E-05  +2.29000000E-06
   -7.17000000E-06  -7.39000000E-06  +5.04948000E-03  +1.02909000E-03  +2.33541000E-03
   -4.18370000E-03  -9.41605000E-03  +1.97267900E-02  -3.11907800E-02  -1.30958710E-01
   +1.37246730E-01  +4.64047000E-03  +6.02199000E-03  -7.18836000E-03  +1.95160000E-04
   -4.97470000E-04  +6.28490000E-04  +2.73520000E-04  +1.58770000E-04  -4.19570000E-04
   +2.84097000E-03  +1.06781000E-03  -1.15883000E-03  +1.02230000E-04  -4.57310000E-04
   -1.34578000E-03  +6.96500000E-05  -6.81900000E-05  +1.35300000E-05  -4.12000000E-06
   +3.65000000E-06  +6.50000000E-07  -5.80000000E-07  +1.29000000E-06  -4.45000000E-06
   +2.30000000E-07  -1.36100000E-05  -9.45000000E-06  -6.30000000E-07  -1.51500000E-05
   +7.02000000E-06  +9.68000000E-06  -2.65000000E-06  +2.15000000E-06  -1.11000000E-06
   -8.93600000E-05  +7.50300000E-05  -1.37400000E-05  +1.10000000E-07  +4.01000000E-06
   -9.44000000E-06  +1.39200000E-05  -1.68500000E-05  +1.43600000E-05  -2.45100000E-05
   +4.11000000E-06  -3.91000000E-06  -2.85000000E-06  +9.38000000E-06  -7.89000000E-06
   -3.96700000E-05  -2.69300000E-05  -1.63670000E-04  -1.32640000E-04  -4.22500000E-05
   -1.01760000E-04  -3.66000000E-05  -1.01230000E-04  +2.47134100E-02  +1.36120710E-01
   +6.16800000E-05  +1.01700000E-05  -7.88300000E-05  -1.58500000E-04  +2.10600000E-05
   -2.35400000E-05  +7.00000000E-07  +6.58100000E-05  +1.76600000E-05  +2.10000000E-07
   -3.29800000E-05  +2.86200000E-05  +1.04400000E-05  +3.98500000E-05  +3.27700000E-05
   -3.09500000E-05  -5.13900000E-05  -1.64000000E-05  +3.36460000E-04  +1.31900000E-04
   -3.30380000E-04  -1.25940000E-04  +2.74600000E-05  +5.04000000E-05  -4.31000000E-05
   -4.07100000E-05  +3.60000000E-07  +1.05056000E-03  +2.62364000E-03  +3.69329000E-03
   +3.13821000E-03  +3.54750000E-03  -1.61344000E-03  +6.36857800E-02  +1.35786550E-01
   -2.37569940E-01  +2.33623000E-03  +1.05848100E-02  -1.04717200E-02  +5.23000000E-04
   -1.27938000E-03  +1.17730000E-03  -2.23270000E-04  -2.60000000E-06  +1.94350000E-04
   +3.08773000E-03  +5.55050000E-04  -1.04641000E-03  -1.85255000E-03  -1.18883000E-03
   +1.37524000E-03  +4.69500000E-05  -9.15100000E-05  -5.42200000E-05  -9.51000000E-06
   +1.32100000E-05  -4.12000000E-06  -1.59900000E-05  +1.86000000E-06  -1.92000000E-05
   +1.03300000E-05  +1.42300000E-05  -1.26000000E-05  +2.53000000E-06  -3.33000000E-06
   -1.13000000E-06  -2.93000000E-06  -1.56000000E-06  -2.50000000E-07  -1.52300000E-05
   +6.70000000E-06  -4.11400000E-05  -1.16000000E-06  -1.02100000E-05  +6.24000000E-06
   +7.00000000E-06  -2.00000000E-06  -1.34600000E-05  +6.66000000E-06  -9.60000000E-06
   +3.68800000E-05  -5.20000000E-07  -4.00000000E-06  +1.09300000E-05  -1.51700000E-05
   -1.72000000E-06  +9.89000000E-06  -1.21310000E-04  -8.19300000E-05  -1.05190000E-04
   -9.28200000E-05  +3.30100000E-05  -1.62720000E-04  -6.94251300E-02  -1.48056570E-01
   +2.46107050E-01  -2.32580000E-04  +2.85610000E-04  -2.31340000E-04  -7.49070000E-04
   +1.13993000E-03  -1.20975000E-03  -4.65210000E-04  +2.86810000E-04  -5.17480000E-04
   +3.72940000E-04  +2.82300000E-05  -3.84200000E-05  -2.83940000E-04  -1.35200000E-05
   +2.09270000E-04  -1.66610000E-04  -1.56880000E-04  +2.86300000E-05  -1.05808000E-03
   +2.51520000E-04  -1.17098000E-03  -1.19690000E-04  -1.09640000E-04  -6.93000000E-05
   +1.67910000E-04  +8.74200000E-05  -2.20100000E-05  +9.75260000E-04  +5.30960000E-04
   +2.74498000E-03  -2.26964540E-01  +2.24149000E-02  +1.37151750E-01  -1.37172500E-02
   +4.08161000E-03  +1.40849500E-02  +3.51091000E-03  +5.36990000E-03  +1.46309000E-03
   -1.33070000E-04  +1.14000000E-05  -3.21110000E-04  +2.07644000E-03  +1.21032000E-03
   +1.04822000E-03  -3.89620000E-04  -4.79230000E-04  -1.25780000E-04  -1.80752000E-03
   -2.58770000E-04  -6.49640000E-04  -5.74000000E-05  +1.31860000E-04  +1.77760000E-04
   -2.34000000E-05  -2.32300000E-05  -4.77000000E-06  +5.31000000E-06  +7.95000000E-06
   +4.87000000E-06  +2.68500000E-05  -2.39600000E-05  +7.76400000E-05  +7.84700000E-05
   -1.17900000E-05  +6.56000000E-06  +3.73000000E-06  -1.92000000E-06  -8.29000000E-06
   +1.13540000E-04  +3.19000000E-06  -4.49300000E-05  -1.48300000E-05  -1.33600000E-05
   +5.93100000E-05  -2.89800000E-05  -8.43000000E-06  -5.74400000E-05  +2.74250000E-04
   -1.59120000E-04  -3.14770000E-04  +2.87900000E-05  -1.74000000E-06  +3.62000000E-06
   +6.91000000E-06  +8.25800000E-05  -3.11170000E-04  -3.23500000E-05  +4.20600000E-05
   -5.11500000E-05  -3.75600000E-05  -3.70000000E-05  -4.18000000E-06  -8.56480000E-04
   -1.93132000E-03  -2.17041000E-03  +2.39496890E-01  +1.67050000E-04  -1.27500000E-04
   +9.98100000E-05  +5.80850000E-04  -1.39220000E-04  +3.06280000E-04  +3.37670000E-04
   +2.96660000E-04  +3.06980000E-04  -4.25690000E-04  -2.27520000E-04  +1.66380000E-04
   +2.65360000E-04  -6.30700000E-05  -2.29920000E-04  +1.31990000E-04  +6.54300000E-05
   -1.83800000E-05  -1.35359000E-03  -1.01364000E-03  -1.84590000E-04  -8.35700000E-05
   -1.20200000E-05  -1.25060000E-04  -2.61720000E-04  -1.56950000E-04  +1.94500000E-05
   -1.59457000E-02  +5.96315000E-03  +1.34326000E-02  +2.20909400E-02  -5.47951300E-02
   -8.00897000E-03  +2.23149200E-02  +5.04250000E-04  -1.23015300E-02  +5.28776000E-03
   +2.43392000E-03  +6.10408000E-03  +5.55340000E-04  -8.93920000E-04  -4.40500000E-05
   +1.65175000E-03  -5.96300000E-04  +4.64844000E-03  -2.57860000E-04  -6.93500000E-05
   -9.90820000E-04  +5.86100000E-05  -1.79653000E-03  -1.32636000E-03  +3.57000000E-06
   -6.83130000E-04  +5.33690000E-04  +3.19000000E-06  +3.75500000E-05  -4.34000000E-06
   -3.54900000E-05  -1.07700000E-05  -2.51100000E-05  +2.13300000E-05  +2.64600000E-05
   -9.59200000E-05  +5.48000000E-05  -9.41500000E-05  -2.63300000E-05  -2.61700000E-05
   +1.59700000E-05  -3.12000000E-06  +2.36500000E-05  +3.27600000E-05  -1.42000000E-05
   +1.28000000E-05  +6.51700000E-05  -1.06600000E-05  -3.65500000E-05  +2.53500000E-05
   -1.02190000E-04  +1.53300000E-05  -1.26931000E-03  -4.27680000E-04  +7.98900000E-05
   +1.26630000E-04  -2.77000000E-05  +5.26800000E-05  +1.87830000E-04  -2.94660000E-04
   -8.74450000E-04  -2.68700000E-05  +6.53270000E-04  -9.72800000E-05  +5.73300000E-05
   -7.27200000E-05  -1.57505000E-03  -2.41618000E-03  -2.60448000E-03  -3.27363600E-02
   +5.45531000E-02  -4.64230000E-04  -8.99200000E-05  +3.51380000E-04  -3.50340000E-04
   +4.34910000E-04  +8.33600000E-05  -1.26780000E-04  -4.63880000E-04  -2.92530000E-04
   +1.16660000E-04  -9.66300000E-05  -9.08900000E-05  -4.13510000E-04  -1.00610000E-04
   +3.57700000E-05  -1.35000000E-06  +1.47420000E-04  +7.96500000E-05  +4.17450000E-04
   -1.42869000E-03  -1.07953000E-03  -2.45660000E-04  -1.46000000E-05  +1.15500000E-05
   +4.51990000E-04  +2.32890000E-04  -5.91000000E-06  +2.08208900E-02  -1.52935000E-03
   -1.14060500E-02  +1.35611740E-01  -7.97196000E-03  -1.54466830E-01  -4.94963000E-03
   +3.53489000E-03  +7.97113000E-03  +2.08139000E-03  +5.86159000E-03  +4.27947000E-03
   -1.13444000E-03  +5.53410000E-04  -9.91500000E-05  +1.08744000E-03  +5.09506000E-03
   -1.44692000E-03  -4.03940000E-04  -7.86010000E-04  +2.39600000E-05  -9.69130000E-04
   -1.15838000E-03  -8.88320000E-04  -3.10000000E-05  +2.17800000E-05  -3.78500000E-05
   -4.31600000E-05  -4.64000000E-05  -2.36400000E-05  +2.05100000E-05  +3.34100000E-05
   +9.40000000E-07  +4.94700000E-05  +5.74300000E-05  +1.46000000E-05  +1.27000000E-06
   -4.84900000E-05  -2.12100000E-05  +2.60100000E-05  -7.74000000E-06  -8.47000000E-06
   -4.68000000E-05  +7.69800000E-05  +4.86000000E-06  -3.50400000E-05  -1.35810000E-04
   +5.01500000E-05  +6.31200000E-05  +2.09200000E-05  +4.24200000E-05  +8.02400000E-05
   -2.75430000E-04  +3.17780000E-04  -1.45200000E-05  -1.65500000E-04  +6.85100000E-05
   -5.30000000E-07  +8.23300000E-05  +1.17100000E-05  +9.43210000E-04  -1.57080000E-04
   -8.12890000E-04  +5.98600000E-05  -1.23330000E-04  -9.96000000E-06  -2.86344000E-03
   -2.22104000E-03  -1.17630000E-03  -1.49737740E-01  +6.67830000E-04  +1.58519210E-01
end_hess

