# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -731.02880050    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.45754314E+00  +7.64984658E-01  +4.75299847E-01
   006   -4.30689315E+00  +2.53860785E-01  +2.25949490E+00
   006   -6.25813533E+00  -1.43479668E+00  +1.76922888E+00
   006   -6.39080036E+00  -2.65029430E+00  -5.44265062E-01
   006   -4.55314007E+00  -2.16953284E+00  -2.36010414E+00
   006   -2.62822964E+00  -4.91179323E-01  -1.83851416E+00
   001   -4.26170327E+00  +1.16468094E+00  +4.08706211E+00
   001   -7.67257658E+00  -1.79995125E+00  +3.20577059E+00
   008   -8.24736004E+00  -4.32140871E+00  -1.13915180E+00
   001   -4.65454865E+00  -3.13386553E+00  -4.15878958E+00
   001   -1.19405989E+00  -1.65655650E-01  -3.26217230E+00
   006   -3.17172713E-01  +2.66395163E+00  +9.02889973E-01
   006   +2.21408020E+00  +1.40805317E+00  +2.79549159E-01
   006   -8.35307783E-01  +4.97742381E+00  -7.73114652E-01
   006   -1.88629613E-01  +3.58140682E+00  +3.65421617E+00
   006   +4.01730231E+00  +2.47502830E+00  -1.29420861E+00
   006   +6.33211117E+00  +1.31316870E+00  -1.75775478E+00
   006   +6.92656865E+00  -9.87194492E-01  -6.39335534E-01
   006   +5.08958367E+00  -1.98847961E+00  +9.08590113E-01
   006   +2.80692880E+00  -9.23894974E-01  +1.40255397E+00
   001   +3.64934254E+00  +4.26043725E+00  -2.21366865E+00
   001   +7.68479206E+00  +2.21204222E+00  -3.01020351E+00
   008   +9.13698635E+00  -2.22970482E+00  -1.00203146E+00
   001   +1.44457637E+00  -1.85729847E+00  +2.61420935E+00
   001   +5.55550097E-01  +6.46548223E+00  -4.52895214E-01
   001   -8.25718338E-01  +4.48954008E+00  -2.77429503E+00
   001   -2.69390517E+00  +5.74129659E+00  -3.20840982E-01
   001   +1.41863171E+00  +4.85017000E+00  +3.87631865E+00
   001   -1.89142435E+00  +4.61891579E+00  +4.17885005E+00
   001   +5.80396798E-02  +2.01756522E+00  +4.97216164E+00
   001   +1.01841179E+01  -1.27424062E+00  -2.12536058E+00
   001   -9.37997847E+00  -4.49542365E+00  +2.59422845E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +7.00000000E-08  +1.20000000E-07  +1.40000000E-07
   -8.50000000E-07  +8.00000000E-07  -1.06000000E-06
   -6.30000000E-07  +8.00000000E-08  -2.06000000E-06
   -8.90000000E-07  +5.50000000E-07  -6.30000000E-07
   +8.70000000E-07  +4.30000000E-07  -1.54000000E-06
   +2.50000000E-07  +1.60000000E-07  -3.30000000E-07
   -1.01000000E-06  +1.30000000E-07  -1.37000000E-06
   -1.09000000E-06  +7.90000000E-07  -1.62000000E-06
   +6.80000000E-07  +7.00000000E-08  -1.61000000E-06
   +6.20000000E-07  +5.30000000E-07  -8.80000000E-07
   +1.27000000E-06  +9.00000000E-08  -3.30000000E-07
   +5.10000000E-07  -3.10000000E-07  +2.00000000E-07
   +3.27000000E-06  -2.23000000E-06  -1.70000000E-07
   +1.09000000E-06  +2.00000000E-08  -5.30000000E-07
   -5.80000000E-07  +4.90000000E-07  -4.80000000E-07
   +2.12000000E-06  -1.70000000E-06  +1.17000000E-06
   -2.76000000E-06  -3.38000000E-06  +4.97000000E-06
   -1.84000000E-06  +4.24000000E-06  -1.40000000E-07
   +1.81900000E-05  -8.18000000E-06  -3.07000000E-06
   -1.67800000E-05  +1.01400000E-05  +2.76000000E-06
   -2.60000000E-07  -3.00000000E-08  +1.09000000E-06
   +1.02000000E-06  -1.20000000E-06  +2.21000000E-06
   -2.08000000E-06  -2.47000000E-06  +4.74000000E-06
   -2.00000000E-08  -4.40000000E-07  +2.80000000E-07
   +6.80000000E-07  -6.00000000E-08  -1.80000000E-07
   +1.13000000E-06  -4.60000000E-07  -5.70000000E-07
   +5.70000000E-07  +2.30000000E-07  -1.05000000E-06
   -5.50000000E-07  -3.00000000E-08  +1.10000000E-07
   -7.40000000E-07  +5.60000000E-07  -7.20000000E-07
   -1.24000000E-06  +1.70000000E-07  +8.00000000E-08
   -1.40000000E-07  -8.20000000E-07  +3.16000000E-06
   -8.90000000E-07  +1.68000000E-06  -2.56000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.04723420E-01  +1.81950520E-01  +3.82809410E-01  -1.20664530E-01  +1.16138890E-01
   +6.04371400E-01  -2.11481610E-01  -6.77730300E-02  +8.34793000E-02  +5.12183700E-01
   -4.20490300E-02  -1.03346020E-01  -1.01759600E-02  +2.25724700E-01  +3.92632320E-01
   +1.36475240E-01  +2.76285900E-02  -2.18573670E-01  -1.06876730E-01  +1.72478280E-01
   +6.64615050E-01  -3.80364000E-02  -1.44104500E-02  +3.97407200E-02  -2.23633210E-01
   -1.43074630E-01  -4.21106600E-02  +5.43803160E-01  -3.41243400E-02  +6.36386000E-03
   +4.98272000E-02  -1.17067920E-01  -1.78307180E-01  -6.36186700E-02  +2.45486160E-01
   +3.77377180E-01  -1.03043000E-03  +2.05276800E-02  +4.95744500E-02  +1.08587200E-02
   -2.47604600E-02  -1.26244370E-01  -1.39407970E-01  +1.44628600E-01  +6.40847680E-01
   -1.12586200E-02  +1.05722400E-02  +3.16314900E-02  +2.75224200E-02  +2.37226000E-03
   -3.33820800E-02  -1.15301830E-01  -4.21509500E-02  -1.53572300E-02  +5.47750760E-01
   +9.51774000E-03  -3.77426000E-03  -1.00566200E-02  -1.94026300E-02  -2.14329200E-02
   -1.88431000E-02  -1.14535700E-02  -1.33883250E-01  -1.17078600E-01  +2.28892910E-01
   +4.04686990E-01  +2.90143500E-02  -1.18562700E-02  -7.47695800E-02  -7.95472500E-02
   -5.21443200E-02  +1.44215500E-02  +4.82227100E-02  -6.94470600E-02  -2.87948820E-01
   -1.18416590E-01  +1.47327970E-01  +6.49172220E-01  +2.26142000E-02  -2.20743300E-02
   -7.02280800E-02  -5.32548700E-02  -2.76194600E-02  +1.82542400E-02  +3.18158300E-02
   +4.03090000E-02  +4.72265500E-02  -1.91805730E-01  -5.33998600E-02  +7.53009400E-02
   +5.28134980E-01  -3.28602000E-03  -1.76842200E-02  -4.85598300E-02  -2.84921100E-02
   -1.85637200E-02  +1.07997300E-02  +2.25059600E-02  +3.08167300E-02  +1.15552800E-02
   -2.33463000E-02  -9.94623100E-02  -2.17117800E-02  +2.47225870E-01  +4.06031340E-01
   -2.88558600E-02  -1.86803300E-02  +1.52121800E-02  +1.77214900E-02  +1.01803300E-02
   -8.88524000E-03  +1.04331200E-02  -1.56945900E-02  -4.00287000E-02  +1.35716860E-01
   +2.37337900E-02  -2.29764730E-01  -9.74027400E-02  +1.87691840E-01  +6.60414810E-01
   -1.10911980E-01  -1.54736100E-02  +3.11421000E-02  +3.14996700E-02  +2.29905800E-02
   +1.35958200E-02  -1.70237500E-02  -1.92314700E-02  -1.88140000E-02  -4.22573700E-02
   -1.41729500E-02  +3.85430700E-02  -2.38303210E-01  -1.54554520E-01  -4.64321500E-02
   +5.67996320E-01  -4.05370800E-02  -1.36638980E-01  -7.10165700E-02  +4.29937600E-02
   +3.12616200E-02  -1.75935000E-02  -2.12389400E-02  -3.23977800E-02  -2.75094500E-02
   -3.59578000E-02  +3.44714000E-03  +5.68144000E-02  -1.28278900E-01  -1.89588630E-01
   -7.01097100E-02  +2.42052010E-01  +3.91642700E-01  -2.22972600E-02  -1.09728700E-01
   -2.61363250E-01  +5.45540100E-02  +1.25288500E-02  -4.81935300E-02  -2.28077000E-02
   -3.07798400E-02  -3.20394300E-02  -6.55324000E-03  +2.38477400E-02  +6.07796500E-02
   +7.09346000E-03  -3.04963900E-02  -1.33536140E-01  -1.34964630E-01  +1.35787130E-01
   +6.19724040E-01  +6.34347000E-03  +1.04124100E-02  +1.86536800E-02  -5.31427400E-02
   -1.14467800E-02  -8.72060000E-04  +2.86092000E-03  -1.10374500E-02  -2.17750300E-02
   -7.78490000E-04  -5.70061000E-03  +1.06807000E-03  -1.28898000E-03  -6.68600000E-05
   -1.24600000E-05  -1.11558000E-03  -3.60689000E-03  +4.75942000E-03  +5.21791300E-02
   +6.45930000E-04  +7.14958000E-03  +4.56572000E-03  -1.13968400E-02  -1.03348020E-01
   -1.18119740E-01  +3.19330000E-04  -5.38452000E-03  -1.87535200E-02  -5.82026000E-03
   +2.48488000E-03  -1.49538000E-03  -2.78600000E-05  -8.66630000E-04  +7.72390000E-04
   -3.50413000E-03  +4.08655000E-03  -4.61090000E-04  +1.97163600E-02  +1.04216840E-01
   -2.10657000E-03  -1.06936400E-02  -1.46859100E-02  -2.65800000E-04  -1.18115470E-01
   -2.83944590E-01  +1.57636000E-03  -1.44409000E-03  -1.92662000E-03  +7.19150000E-04
   -1.67387000E-03  +2.90586000E-03  +1.52830000E-04  +8.75140000E-04  +3.57450000E-04
   +4.88211000E-03  -1.83940000E-04  -1.02067000E-03  +8.53420000E-04  +1.31608040E-01
   +2.99339030E-01  -9.23600000E-05  -5.62271000E-03  -9.09820000E-04  -1.21988900E-02
   -2.03096000E-03  +1.79110700E-02  -1.80450540E-01  -4.37298800E-02  +1.38600480E-01
   +1.52886000E-03  -3.16940000E-03  -2.37311000E-03  +2.96965000E-03  -1.92013000E-03
   +3.05420000E-04  -3.35360000E-04  +9.65800000E-05  -8.92630000E-04  -6.77740000E-04
   +2.02567000E-03  -1.19937000E-03  +1.88466240E-01  -5.19275000E-03  +1.33838000E-03
   -2.99617000E-03  -1.34008800E-02  -2.07310000E-04  +1.60651500E-02  -4.37071700E-02
   -5.27699800E-02  +2.56414200E-02  +8.82413000E-03  +5.78451000E-03  -1.05251800E-02
   -2.14243000E-03  +2.04431000E-03  -4.24983000E-03  +4.46000000E-06  -1.20904000E-03
   -3.90190000E-04  +2.22520000E-03  -1.92322000E-03  +1.21366000E-03  +5.07543900E-02
   +4.77323500E-02  -5.00740000E-04  -2.56888000E-03  +2.23127000E-03  -5.55339000E-03
   -1.52894000E-03  +7.51661000E-03  +1.38778070E-01  +2.56331100E-02  -1.94562740E-01
   +2.25961700E-02  +8.26675000E-03  -1.36813200E-02  -2.34480000E-04  -4.67270000E-03
   -3.59173000E-03  -1.22145000E-03  -6.18450000E-04  -4.53890000E-04  -8.01850000E-04
   +1.52015000E-03  +2.54540000E-04  -1.51632750E-01  -2.68304100E-02  +2.02260400E-01
   -1.24888000E-03  -1.73631000E-03  -5.25275000E-03  +8.95880000E-04  -3.47712000E-03
   +3.25174000E-03  -6.25835000E-03  -1.47477200E-02  -5.54146000E-03  -1.93544000E-01
   -1.32105090E-01  -4.27334900E-02  -3.84386100E-02  -3.50462200E-02  -1.95130000E-03
   +3.88099000E-03  +2.30603000E-03  +6.25122000E-03  -2.76900000E-04  -3.29600000E-04
   -2.10780000E-04  +1.30140000E-03  +3.52073000E-03  -1.17413000E-03  +4.50914290E-01
   -1.50502000E-03  -2.00474000E-03  -5.33010000E-04  -4.95700000E-04  +5.65046000E-03
   -3.84458000E-03  -2.93117600E-02  -1.79278400E-02  -1.21576000E-02  -1.13298660E-01
   -1.60186190E-01  -6.60211500E-02  -2.02607200E-02  -7.04749000E-03  +1.87689000E-03
   -3.83980000E-04  +3.66107000E-03  -1.83059000E-03  -7.80190000E-04  -6.99090000E-04
   -3.21560000E-04  +3.19960000E-03  -7.61020000E-04  +1.95100000E-03  +2.11768470E-01
   +2.06944530E-01  -3.29821000E-03  +1.03924000E-03  +5.61485000E-03  +9.73561000E-03
   +8.72430000E-04  -5.22472000E-03  -3.58369600E-02  -3.48515600E-02  -6.94654000E-03
   -3.33744000E-03  -3.66110600E-02  -1.14676400E-01  +2.80115100E-02  +2.43412100E-02
   +1.43202800E-02  +8.32280000E-04  -5.85835000E-03  -8.43718000E-03  -1.18507000E-03
   -1.05073000E-03  -3.26880000E-04  -1.77125000E-03  +1.53075000E-03  +1.77066000E-03
   -2.17173570E-01  +4.47291600E-02  +4.58055670E-01  -7.66080000E-04  -5.97463000E-03
   +1.01351000E-03  -1.43138000E-03  -2.79360000E-04  +1.02390000E-04  -1.40499000E-03
   -3.12675000E-03  +3.97731000E-03  +6.23316000E-03  +1.07182700E-02  +1.99086500E-02
   -5.32492000E-02  -1.56002300E-02  -5.51516000E-03  +3.45696000E-03  -1.03000200E-02
   -2.16828700E-02  -1.68770000E-04  +3.15260000E-04  -1.98590000E-04  +6.65500000E-05
   +5.91100000E-04  +1.04921000E-03  +3.04340000E-04  +1.88424000E-03  -1.68084000E-03
   +4.74320300E-02  -5.91669000E-03  +2.66605000E-03  -1.54995000E-03  -7.62400000E-05
   -6.86280000E-04  +6.63700000E-04  -2.93454000E-03  +3.09005000E-03  -1.84470000E-04
   -1.45301000E-03  +6.45411000E-03  +4.95915000E-03  -1.49374400E-02  -1.08319550E-01
   -1.24376520E-01  +9.50700000E-04  -5.24847000E-03  -1.79522300E-02  +3.31600000E-04
   -4.12550000E-04  +1.29720000E-04  +5.53200000E-05  +1.59520000E-04  +4.03560000E-04
   +2.10772000E-03  -1.33831000E-03  +8.92870000E-04  +1.93876900E-02  +1.06498340E-01
   +6.89870000E-04  -2.01697000E-03  +2.84199000E-03  +3.79850000E-04  +9.27930000E-04
   +3.68610000E-04  +4.44792000E-03  +1.71250000E-04  -1.02372000E-03  -4.38615000E-03
   -1.33146100E-02  -1.52419900E-02  -4.44573000E-03  -1.23258030E-01  -2.78941610E-01
   +1.15788000E-03  -8.30910000E-04  -5.17350000E-04  -1.75090000E-04  +1.58950000E-04
   -1.40570000E-04  -9.72600000E-05  -4.32570000E-04  -8.30670000E-04  -1.42677000E-03
   +1.08107000E-03  +1.00675000E-03  +5.37074000E-03  +1.36020880E-01  +2.92454550E-01
   +4.43911000E-03  -2.30330000E-04  -1.04023000E-03  +2.78913000E-03  -2.21864000E-03
   +3.19860000E-04  -3.30650000E-04  +1.25860000E-04  -9.25220000E-04  +9.00230000E-04
   -5.64729000E-03  -4.81530000E-04  -1.17159600E-02  -3.05947000E-03  +1.77547300E-02
   -1.89609360E-01  -3.87633600E-02  +1.39954130E-01  +1.75420000E-04  -4.86500000E-05
   -1.82250000E-04  -2.48840000E-04  +2.75250000E-04  -7.77800000E-05  -9.69830000E-04
   -2.36250000E-04  +9.56640000E-04  -7.34260000E-04  +2.20247000E-03  -1.34039000E-03
   +1.97241750E-01  +1.06348100E-02  +7.25093000E-03  -9.65127000E-03  -2.66185000E-03
   +2.20086000E-03  -4.40371000E-03  +1.65650000E-04  -1.04251000E-03  -1.47480000E-04
   -5.65955000E-03  +2.47643000E-03  -3.69681000E-03  -1.51299800E-02  +8.12160000E-04
   +1.50585000E-02  -3.80114900E-02  -5.59691500E-02  +2.37362200E-02  +5.98350000E-04
   +1.80990000E-04  -5.75940000E-04  +3.09990000E-04  -3.64190000E-04  +2.34300000E-04
   -7.98590000E-04  -1.61520000E-04  +8.88970000E-04  +2.53241000E-03  -2.28238000E-03
   +1.38566000E-03  +4.72777000E-02  +5.01905300E-02  +2.06565300E-02  +5.79668000E-03
   -1.41505000E-02  +1.45560000E-04  -4.90433000E-03  -3.69925000E-03  -1.08303000E-03
   -2.80520000E-04  -1.14190000E-04  -2.00450000E-04  -3.45934000E-03  +2.09107000E-03
   -5.60103000E-03  -2.40328000E-03  +7.82927000E-03  +1.39306640E-01  +2.46876800E-02
   -1.92864800E-01  +1.08572000E-03  +3.81380000E-04  -8.82100000E-04  -6.23100000E-05
   +2.63090000E-04  -9.93600000E-05  +2.78000000E-06  +1.30950000E-04  +2.92840000E-04
   -9.57530000E-04  +1.77453000E-03  +2.12300000E-05  -1.52707970E-01  -2.33875700E-02
   +2.01194720E-01  -1.28812630E-01  -4.79511700E-02  -3.39370000E-03  -1.54257500E-02
   -1.52519700E-02  -1.90885000E-03  +1.45321000E-03  -2.36154000E-03  +3.74184000E-03
   -2.23085000E-03  -5.46330000E-04  +1.06622000E-03  +4.18777000E-03  +4.16700000E-05
   +1.47175000E-03  -1.90891000E-03  -5.73487000E-03  -7.24279000E-03  -5.12440000E-04
   +1.72601000E-03  -1.93895000E-03  -8.65800000E-05  -5.11420000E-04  -1.91360000E-04
   +1.45077000E-03  +1.51569000E-03  -2.47300000E-05  +5.19070000E-04  +8.21200000E-05
   +3.42960000E-04  -1.09012000E-03  +1.45347000E-03  +4.64250000E-04  +4.73251060E-01
   -4.93890200E-02  -1.14141490E-01  -1.30444000E-02  -7.04741000E-03  -1.61867000E-03
   +2.65571000E-03  -1.59215000E-03  +4.68358000E-03  -2.08410000E-03  -6.19080000E-04
   -7.58080000E-04  +1.96900000E-04  -2.59290000E-04  +3.49047000E-03  -2.56308000E-03
   -1.23944000E-02  -1.18202400E-02  -6.53698000E-03  +2.11757000E-03  -2.40879000E-03
   -1.00410000E-04  +1.73340000E-04  +4.42880000E-04  -1.78460000E-04  +8.63520000E-04
   +1.08770000E-04  +3.09560000E-04  -3.22640000E-04  +1.32570000E-04  -1.13300000E-05
   +7.94590000E-04  -1.48229000E-03  +1.71379000E-03  +2.67580000E-04  +4.80442980E-01
   -6.89985000E-03  -1.55995000E-02  -8.95558100E-02  +1.22745500E-02  +1.34427000E-02
   +9.03296000E-03  +4.15552000E-03  -7.66990000E-04  -1.41016000E-03  +3.31330000E-04
   -5.42190000E-04  -2.04824000E-03  +1.43370000E-03  -3.78506000E-03  -4.33430000E-03
   -2.27098000E-02  -1.89390600E-02  -4.80980000E-04  -8.79660000E-04  +7.53040000E-04
   -1.15875000E-03  +1.00003000E-03  +6.04660000E-04  +2.88510000E-04  +5.48890000E-04
   +9.43310000E-04  +4.33620000E-04  -9.80020000E-04  -8.60900000E-04  -1.31050000E-04
   -8.38630000E-04  +8.25160000E-04  -2.78560000E-04  +5.83570000E-04  -2.80380000E-04
   +4.80715530E-01  -3.45624200E-02  +2.00824000E-03  +6.89845000E-03  -8.33130000E-04
   +2.22340000E-04  -2.08256000E-03  -1.31200000E-05  -1.06314000E-03  +3.67660000E-04
   -2.24930000E-04  -4.77600000E-05  +4.77680000E-04  +3.05530000E-04  +5.35210000E-04
   +7.40460000E-04  -7.12070000E-04  +5.86580000E-04  -2.81590000E-04  -2.50300000E-04
   +2.66520000E-04  -1.13640000E-04  +5.69900000E-05  -1.95010000E-04  +4.05500000E-05
   +7.01300000E-05  +1.12280000E-04  -2.48400000E-05  +9.35800000E-05  +2.21130000E-04
   -2.10400000E-05  -5.84910000E-04  -4.18960000E-04  -3.31070000E-04  -1.47957220E-01
   +3.67775100E-02  +1.98210800E-02  +5.56235020E-01  -1.62174500E-02  +1.10583700E-02
   +7.44038000E-03  -1.54440000E-03  -2.35486000E-03  -1.92209000E-03  -4.91850000E-04
   -1.40515000E-03  +3.03630000E-04  +1.91270000E-04  +8.10750000E-04  +9.26590000E-04
   +2.98370000E-04  -2.89400000E-05  +9.92000000E-06  -2.12229000E-03  -4.31110000E-04
   -4.67600000E-04  -1.21320000E-04  +5.11490000E-04  -4.67600000E-05  -2.52090000E-04
   -3.29340000E-04  +1.49500000E-05  -8.41650000E-04  -7.66010000E-04  -3.38560000E-04
   -3.32000000E-05  -7.42700000E-05  -5.34300000E-05  -5.19600000E-04  +5.75600000E-05
   -4.14280000E-04  +3.31987300E-02  -9.97985700E-02  +5.50790000E-04  -5.87736900E-02
   +5.21896820E-01  +1.29744000E-03  +2.37633000E-03  +4.77340000E-04  -1.10310000E-04
   -7.80900000E-05  -1.25700000E-04  -1.00760000E-04  -6.53700000E-05  -7.11000000E-06
   +1.37250000E-04  +2.29570000E-04  +5.44100000E-05  -2.36450000E-04  +2.35090000E-04
   +5.88100000E-05  -2.16843000E-03  -1.11553000E-03  -1.44170000E-04  -1.35780000E-04
   -1.74560000E-04  +8.91400000E-05  -2.01100000E-05  -4.52100000E-05  +5.41000000E-06
   -2.97840000E-04  -3.31890000E-04  -1.88100000E-05  -9.09000000E-06  -3.37500000E-05
   -4.07000000E-06  -7.10230000E-04  -2.71610000E-04  +5.06000000E-06  +2.22743600E-02
   -1.26545000E-03  -7.94138100E-02  -1.60491420E-01  -1.74819650E-01  +3.69591220E-01
   +1.84404000E-03  -2.08321300E-02  +1.47290100E-02  -6.90390000E-04  -1.52981000E-03
   -1.16924000E-03  -1.44638000E-03  +2.72700000E-04  -1.04158000E-03  +4.10740000E-04
   +6.60470000E-04  +8.71940000E-04  -1.19980000E-04  +5.07660000E-04  +2.75110000E-04
   -4.20010000E-04  -1.14868000E-03  +3.58710000E-04  +4.15750000E-04  -5.30460000E-04
   +4.41230000E-04  -2.33360000E-04  -9.54800000E-05  -1.21500000E-05  -1.08337000E-03
   -1.03628000E-03  -3.09440000E-04  +4.65000000E-06  -4.35100000E-05  -4.75100000E-05
   -5.91000000E-06  -9.18300000E-05  -3.99700000E-05  -7.83592700E-02  +1.12080500E-02
   -8.40840000E-03  -7.61855000E-03  +2.56993100E-02  -1.76854300E-02  +5.80446860E-01
   -5.88273000E-03  -2.87967900E-02  +1.31901800E-02  +1.62823000E-03  -6.89260000E-04
   -1.16045000E-03  -9.88120000E-04  +1.29240000E-04  -9.72180000E-04  +5.74500000E-05
   +4.25940000E-04  +7.11810000E-04  -9.31700000E-05  +7.44890000E-04  +3.35630000E-04
   +1.14720000E-04  -5.36320000E-04  +1.04519000E-03  +1.19840000E-04  -3.59330000E-04
   +1.62110000E-04  -9.97300000E-05  +5.28500000E-05  -4.11200000E-05  -4.32230000E-04
   -4.82110000E-04  -1.48980000E-04  +1.10490000E-04  -1.29000000E-05  +1.19100000E-05
   -1.33730000E-04  -4.63720000E-04  -8.54700000E-05  +1.66041800E-02  -1.36678450E-01
   +4.71078100E-02  +9.29046000E-03  -1.51208500E-02  +8.40151000E-03  +2.06780900E-02
   +5.02982900E-01  +4.76144000E-03  +1.91445000E-03  +3.11516000E-03  -2.64550000E-04
   -3.74840000E-04  -3.50100000E-04  -3.16260000E-04  -2.83170000E-04  -5.39420000E-04
   +7.39800000E-05  +2.47610000E-04  +7.89400000E-04  +3.69620000E-04  +2.99610000E-04
   -1.94220000E-04  -1.58762000E-03  -1.44558000E-03  -1.95230000E-04  -9.27200000E-05
   -1.83900000E-05  +5.58300000E-05  -1.12710000E-04  -4.24300000E-05  -3.00000000E-05
   -5.47130000E-04  -4.90250000E-04  -2.24690000E-04  -7.84500000E-05  -1.51600000E-05
   -5.18700000E-05  +1.41380000E-04  -5.23760000E-04  -2.36260000E-04  -1.07799800E-02
   +4.33244400E-02  -1.08096920E-01  -1.65231000E-03  -5.22829000E-03  +4.92680000E-03
   -1.52293400E-02  +5.70336200E-02  +5.52880480E-01  -1.44319000E-03  -8.78838000E-03
   -2.55249000E-02  -1.22719000E-03  -6.09940000E-04  -1.01664000E-03  +7.16200000E-05
   -1.37220000E-04  -7.11150000E-04  +3.58560000E-04  +2.55540000E-04  +1.75490000E-04
   +3.98690000E-04  -6.78560000E-04  -1.12899000E-03  -4.04846000E-03  -3.14688000E-03
   +6.07290000E-04  -1.80944000E-03  -2.42870000E-03  -9.87850000E-04  -4.60000000E-05
   +4.34200000E-05  +2.75600000E-05  -4.79010000E-04  -4.29100000E-04  -9.27300000E-05
   -3.06230000E-04  -2.38110000E-04  -9.70300000E-05  -5.49600000E-05  +1.84730000E-04
   -1.74330000E-04  -7.55119500E-02  -5.02460000E-04  -5.16430000E-04  -3.78772000E-03
   +1.04930100E-02  +2.96752700E-02  +1.57730000E-04  -7.59410000E-04  -6.66950000E-03
   +5.86186730E-01  -3.88106000E-03  -9.54356000E-03  -2.35096000E-02  -5.62350000E-04
   -1.11760000E-03  +2.15100000E-04  +5.19650000E-04  -1.98030000E-04  -7.45650000E-04
   -2.60700000E-05  +1.55440000E-04  -1.30210000E-04  +1.83180000E-04  -4.60780000E-04
   -9.67440000E-04  -3.73651000E-03  -1.59623000E-03  +4.53280000E-04  -1.55612000E-03
   -7.93300000E-04  -1.21213000E-03  +6.64300000E-05  +1.17400000E-05  +6.55700000E-05
   -1.54240000E-04  -1.64050000E-04  -4.62500000E-05  -1.67790000E-04  -2.50110000E-04
   -2.60000000E-05  +1.52950000E-04  +1.58400000E-05  -4.15000000E-06  -3.36671000E-03
   -8.48420900E-02  -3.02636100E-02  +5.29742000E-03  -7.33021000E-03  -1.68371500E-02
   +1.17034000E-03  +6.12353000E-03  +2.79993400E-02  -1.48004000E-03  +5.74154830E-01
   -5.80315000E-03  -5.15418000E-03  -5.85387000E-03  +9.55870000E-04  +6.53500000E-04
   +4.56670000E-04  +3.83140000E-04  +6.97000000E-05  -3.43080000E-04  -2.70270000E-04
   -1.84520000E-04  +1.23370000E-04  +4.25080000E-04  +1.51040000E-04  -2.04300000E-05
   +2.91250000E-04  +6.85610000E-04  +3.38790000E-04  +5.20440000E-04  +2.08870000E-04
   +1.64840000E-04  +6.92000000E-05  +8.83700000E-05  -8.07000000E-06  +3.12530000E-04
   +2.59900000E-04  +2.09700000E-05  +6.89400000E-05  +5.04500000E-05  +4.71900000E-05
   -3.29100000E-05  +9.70300000E-05  +2.95600000E-05  -6.81879000E-03  -2.76448800E-02
   -1.63525830E-01  +1.08229000E-02  -9.23949000E-03  -1.30875000E-02  -2.53679000E-03
   -4.00330000E-04  -3.23697800E-02  -7.68984000E-03  -4.37165200E-02  +4.78229540E-01
   -1.32089000E-03  +1.51114000E-03  +9.91390000E-04  -8.12750000E-04  -9.17710000E-04
   -1.40690000E-04  +1.75390000E-04  +1.12500000E-04  +3.34520000E-04  +2.07960000E-04
   +9.83300000E-05  -3.97490000E-04  -3.30270000E-04  -4.29640000E-04  +1.19030000E-04
   +7.06590000E-04  -1.41600000E-05  +4.33480000E-04  -2.07000000E-05  +1.07030000E-04
   -2.36500000E-05  -7.39000000E-05  -3.67900000E-05  -3.50000000E-06  -1.36660000E-04
   -9.41300000E-05  -8.04000000E-06  -2.91000000E-06  -3.36800000E-05  +6.55000000E-06
   -7.67300000E-05  +1.31680000E-04  -3.47980000E-04  -1.75948500E-02  -7.79056000E-03
   +1.45903000E-02  -2.15447340E-01  -1.77370700E-02  +8.79566800E-02  -2.17622000E-03
   -1.39830000E-04  +1.51900000E-03  -8.70300000E-04  -1.10945000E-03  -1.22159000E-03
   +5.90883680E-01  +1.41485000E-03  -1.88891000E-03  -1.39922000E-03  +4.81970000E-04
   +6.26900000E-04  +2.18900000E-04  +1.20000000E-07  +1.50990000E-04  -1.56480000E-04
   -1.93610000E-04  -1.10680000E-04  +3.48300000E-05  +1.45250000E-04  +1.92260000E-04
   -3.34800000E-05  -1.05180000E-04  +3.74200000E-05  +1.16930000E-04  +6.02000000E-06
   -1.21930000E-04  +3.48000000E-05  +7.98600000E-05  +4.08200000E-05  +6.60000000E-07
   +2.18700000E-04  +1.75350000E-04  +6.12000000E-05  +1.99000000E-05  +2.57700000E-05
   +1.66700000E-05  -4.00700000E-05  -7.45300000E-05  +7.92400000E-05  +7.82092000E-03
   +1.12774000E-02  -8.25366000E-03  -7.01089100E-02  -1.48342570E-01  +8.60546700E-02
   +1.00783000E-03  -1.40800000E-04  -7.58950000E-04  +1.93834000E-03  -1.06472000E-03
   -4.79580000E-04  -1.12753800E-01  +6.05701140E-01  -1.86036000E-03  -1.87380000E-04
   +4.56300000E-05  +3.59990000E-04  +3.49850000E-04  -3.20500000E-05  -2.26550000E-04
   -4.43550000E-04  -1.90080000E-04  -7.59900000E-05  +9.38100000E-05  +4.36860000E-04
   +2.34260000E-04  +3.89490000E-04  +1.32710000E-04  -7.10260000E-04  -1.43100000E-05
   -7.06680000E-04  -5.26900000E-05  +4.35400000E-05  +2.37000000E-05  -3.15000000E-06
   -3.25000000E-05  +2.12200000E-05  -1.58750000E-04  -1.56330000E-04  -3.69800000E-05
   -6.09000000E-06  +3.99400000E-05  -3.66100000E-05  -5.37500000E-05  -1.56930000E-04
   +3.30070000E-04  +6.41785000E-03  -5.78210000E-04  -6.73830000E-04  +1.19646270E-01
   +6.09240500E-02  -1.64390060E-01  -9.08100000E-05  -7.60660000E-04  -5.80800000E-04
   -1.09690000E-04  +3.16270000E-04  +1.62610000E-04  -1.62033960E-01  -2.30733320E-01
   +3.65053860E-01  -4.32020000E-04  +6.01800000E-04  +3.18910000E-04  +2.24330000E-04
   +2.56020000E-04  -2.74790000E-04  -1.19310000E-04  -2.66810000E-04  -2.13400000E-04
   +1.27140000E-04  +1.94040000E-04  +3.59980000E-04  +1.93450000E-04  +1.34690000E-04
   -1.28230000E-04  -3.70660000E-04  +1.26770000E-04  +8.66900000E-05  +4.12200000E-05
   +2.00700000E-05  +9.20000000E-07  -1.17100000E-05  -3.70000000E-05  +1.29300000E-05
   -2.41240000E-04  -2.11590000E-04  -1.05120000E-04  -1.89700000E-05  -1.00400000E-05
   -1.58700000E-05  -1.35750000E-04  -1.57870000E-04  -3.55600000E-05  +1.21891000E-03
   -1.33471000E-03  +2.97559000E-03  -4.48390900E-02  -3.20758400E-02  +4.53199500E-02
   -9.08100000E-05  -4.85560000E-04  +8.93700000E-05  -1.50362000E-03  +6.45720000E-04
   +1.63700000E-04  -2.76450920E-01  +1.20173560E-01  +3.73170000E-02  +6.17449170E-01
   +6.88620000E-04  -4.72750000E-04  -4.06180000E-04  -2.50250000E-04  -2.93350000E-04
   +3.12720000E-04  +2.03620000E-04  +3.93910000E-04  +2.52340000E-04  -7.11100000E-05
   -2.61480000E-04  -4.77870000E-04  -2.21740000E-04  -2.23440000E-04  +8.63500000E-05
   +5.20960000E-04  +1.59000000E-05  -4.31000000E-06  -1.32300000E-05  -4.13400000E-05
   +1.20200000E-05  +1.71700000E-05  +4.94200000E-05  -1.40500000E-05  +2.89300000E-04
   +2.89440000E-04  +1.12560000E-04  +3.33900000E-05  -4.39000000E-06  +3.36200000E-05
   +8.20100000E-05  +1.37300000E-04  -1.29310000E-04  -2.16890000E-04  +5.65440000E-04
   +2.92892000E-03  +8.70203000E-03  +5.21594100E-02  -3.21088800E-02  +7.53520000E-04
   -5.63810000E-04  -2.02530000E-04  +1.92280000E-04  -5.08340000E-04  +2.15360000E-04
   +6.65120500E-02  -1.50444740E-01  +2.11158600E-02  -9.31597000E-02  +5.50244430E-01
   +1.04558000E-03  -6.15700000E-04  -4.99840000E-04  +1.87270000E-04  +1.55090000E-04
   +2.26150000E-04  -2.39700000E-05  +5.79600000E-05  -4.27600000E-05  +4.70000000E-07
   -2.70200000E-05  -3.27500000E-05  -2.43700000E-05  +2.01200000E-05  +5.72200000E-05
   +1.47490000E-04  -4.56700000E-05  -3.18200000E-04  +1.25100000E-05  -6.60000000E-06
   +4.04000000E-06  +7.49000000E-06  +2.74400000E-05  +3.25000000E-06  +1.69800000E-05
   +1.30800000E-05  +3.20800000E-05  +1.69800000E-05  +1.95000000E-05  -1.68000000E-06
   +5.13900000E-05  +1.75800000E-05  +7.57600000E-05  +2.79918000E-03  +4.42114000E-03
   +2.79358000E-03  +2.05072200E-02  -1.25115100E-02  +2.52273000E-03  -5.93160000E-04
   +3.57470000E-04  -2.01400000E-05  -1.25931000E-03  +5.90070000E-04  +2.31720000E-04
   +6.97209900E-02  -5.51186000E-03  -9.17096400E-02  -1.96382010E-01  -2.17881690E-01
   +3.57141150E-01  -2.31910000E-04  -5.15140000E-04  -8.10900000E-05  +8.36000000E-05
   +1.85410000E-04  +1.58430000E-04  +1.64360000E-04  +2.13240000E-04  +1.71290000E-04
   -7.84190000E-04  -6.40730000E-04  -1.75380000E-04  +2.96160000E-04  -1.49100000E-05
   -3.22220000E-04  -4.81200000E-05  +6.49400000E-05  +1.88780000E-04  -7.17900000E-05
   -3.94200000E-05  +8.68000000E-06  +1.08260000E-04  +6.32800000E-05  -4.20200000E-05
   +9.19950000E-04  +7.81850000E-04  +1.86280000E-04  +1.98300000E-05  +3.99900000E-05
   +4.03000000E-05  -2.50600000E-04  -1.30930000E-04  -3.69760000E-04  -2.68483000E-03
   -5.33080000E-04  +8.14120000E-04  -7.51120000E-04  -2.33897100E-02  +1.44510200E-02
   +5.77750000E-04  +2.30940000E-04  -3.60210000E-04  +6.61430000E-04  -1.10320000E-04
   +6.74900000E-05  +1.66790400E-02  +2.71057300E-02  -2.40893300E-02  -1.27348520E-01
   +7.82794400E-02  -1.73374300E-02  +6.44340870E-01  -5.25700000E-04  +9.05930000E-04
   +4.80990000E-04  +2.30380000E-04  +2.79650000E-04  -3.30770000E-04  -2.34450000E-04
   -4.91090000E-04  -3.24710000E-04  +3.43160000E-04  +4.72330000E-04  +5.36300000E-04
   +1.30170000E-04  +1.71430000E-04  +4.97000000E-06  -3.87460000E-04  -1.00000000E-07
   -1.27080000E-04  +4.71100000E-05  +6.56300000E-05  -1.46200000E-05  -5.31400000E-05
   -6.49500000E-05  +2.87400000E-05  -5.94040000E-04  -5.46840000E-04  -1.79850000E-04
   -3.74900000E-05  -3.60000000E-06  -5.05200000E-05  -4.21000000E-06  -1.28730000E-04
   +1.15670000E-04  -1.08880000E-04  -8.87830000E-04  +5.23210000E-04  -2.15559600E-02
   -4.48421700E-02  +3.73058500E-02  -5.79910000E-04  -1.87800000E-05  +1.66400000E-04
   -1.06220000E-03  +6.97980000E-04  -1.99150000E-04  +7.26471400E-02  -2.28861200E-02
   -2.12346500E-02  +3.04815000E-03  -2.57855500E-01  +1.16809890E-01  -1.06548320E-01
   +5.34864990E-01  +3.51320000E-04  -9.92400000E-05  -2.22720000E-04  -2.70720000E-04
   -2.85970000E-04  +1.34510000E-04  +1.12560000E-04  +1.85310000E-04  +1.13500000E-04
   +1.68420000E-04  +4.75600000E-05  -2.69580000E-04  -2.55000000E-04  -1.78880000E-04
   +1.33470000E-04  +3.48710000E-04  -1.11850000E-04  +8.23900000E-05  +2.09100000E-05
   -9.05000000E-06  -1.51300000E-05  -1.94800000E-05  +6.42000000E-06  +1.65000000E-06
   -9.24200000E-05  -6.59500000E-05  +5.37000000E-06  -4.60000000E-07  -2.03200000E-05
   +6.14000000E-06  +1.43200000E-04  +1.83790000E-04  +3.85900000E-05  +9.59820000E-04
   +5.72720000E-04  -1.32383000E-03  +1.30189400E-02  +3.83895400E-02  -3.20110000E-02
   +5.02700000E-05  +4.01000000E-06  +2.31870000E-04  +4.80090000E-04  -4.92440000E-04
   +1.69730000E-04  -5.27126600E-02  +1.13906000E-03  +2.69050200E-02  +2.91961800E-02
   +7.80812500E-02  -1.30108330E-01  -1.87030390E-01  -1.84180740E-01  +3.57126720E-01
   +9.38430000E-04  +1.41900000E-04  -2.82600000E-04  -3.93670000E-04  -5.09460000E-04
   +1.96490000E-04  +1.50940000E-04  +2.39330000E-04  +1.82950000E-04  +2.08940000E-04
   +5.35100000E-05  -3.50190000E-04  -3.37920000E-04  -2.85430000E-04  +2.03740000E-04
   +4.56990000E-04  -1.65000000E-04  +8.36700000E-05  -8.20000000E-07  +1.34500000E-05
   -1.78800000E-05  -5.13700000E-05  +7.14000000E-06  -8.80000000E-07  -1.55560000E-04
   -1.24940000E-04  +1.23800000E-05  -1.11600000E-05  -2.64100000E-05  -6.23000000E-06
   +2.37470000E-04  +3.38040000E-04  +8.41100000E-05  +3.95986000E-03  +1.94109000E-03
   -6.34780000E-04  -2.05411000E-03  +8.35510000E-02  -4.48574900E-02  -2.29940000E-04
   -8.95900000E-05  +5.24870000E-04  +1.53940000E-04  -3.60510000E-04  +3.59100000E-05
   -6.40889300E-02  -8.43160000E-04  +3.06519700E-02  +4.74129300E-02  -6.05794400E-02
   +1.90414200E-02  -2.02899000E-01  -3.93074000E-02  +9.95548400E-02  +6.02229630E-01
   -9.51520000E-04  -8.57400000E-05  -3.26660000E-04  +1.82320000E-04  +3.23170000E-04
   -1.97960000E-04  +2.45800000E-05  -3.77100000E-05  -8.41700000E-05  +1.37900000E-04
   +7.80600000E-05  +8.24900000E-05  +2.20900000E-05  +1.10670000E-04  +1.80700000E-05
   -1.61240000E-04  +2.53030000E-04  +5.77200000E-05  +1.51200000E-05  -3.69400000E-05
   +6.83000000E-06  +8.91000000E-06  -5.19000000E-06  +1.07000000E-05  -1.24950000E-04
   -8.49500000E-05  -3.43900000E-05  +2.55700000E-05  -8.83000000E-06  +1.34000000E-05
   +2.10000000E-06  -1.73720000E-04  +4.97700000E-05  +5.24530000E-04  -2.84364000E-03
   +5.15249000E-03  +3.23990000E-02  -1.93725700E-02  +2.96364000E-03  +1.47449000E-03
   -4.94200000E-04  -5.04290000E-04  -6.68740000E-04  +4.65770000E-04  +3.79490000E-04
   +4.58940000E-04  -4.40232000E-03  +6.82280000E-04  -1.51487400E-02  -1.63169100E-02
   +2.49695600E-02  -6.62935600E-02  -1.28942570E-01  +7.89114200E-02  -8.20893100E-02
   +2.84230730E-01  -1.19400000E-05  +3.42600000E-05  -6.99800000E-05  +3.11870000E-04
   +3.21170000E-04  -7.45900000E-05  -1.12620000E-04  -2.10850000E-04  -1.29200000E-04
   -1.45300000E-04  -1.77500000E-05  +2.41050000E-04  +2.60040000E-04  +2.29890000E-04
   -1.42090000E-04  -3.36190000E-04  +3.81100000E-05  -9.96200000E-05  -4.53300000E-05
   +2.21300000E-05  +2.57200000E-05  +1.51700000E-05  +9.83000000E-06  -4.38000000E-06
   +7.61000000E-05  +6.31400000E-05  -4.77000000E-06  +2.05400000E-05  +1.85000000E-06
   +1.51000000E-05  -5.63300000E-05  -1.86100000E-04  -4.99300000E-05  +2.54230000E-04
   +3.54075000E-03  +2.08838000E-03  -1.22519600E-02  -2.24719400E-02  +3.34356200E-02
   -3.84180000E-04  +2.21010000E-04  +9.80600000E-05  -1.38430000E-04  +2.86270000E-04
   -1.13710000E-04  +3.03320300E-02  +1.28935000E-03  -1.88653300E-02  -9.04566000E-03
   +4.77416300E-02  -1.34805200E-02  +1.15972550E-01  +6.49866600E-02  -1.54101370E-01
   -2.19290550E-01  -9.12446600E-02  +2.35044940E-01  -1.70589000E-03  +2.81083000E-03
   -7.17360000E-04  +7.24660000E-04  +8.08560000E-04  -6.68150000E-04  -1.94160000E-04
   -5.33960000E-04  -2.96800000E-04  +5.35900000E-05  +1.74880000E-04  +5.18700000E-04
   +3.37840000E-04  +2.69610000E-04  -1.29010000E-04  -1.28304000E-03  +3.94450000E-04
   -2.54780000E-04  -1.28800000E-05  +7.03000000E-05  +2.71800000E-05  -2.94100000E-05
   -1.88700000E-05  +4.63000000E-06  -2.40560000E-04  -2.46520000E-04  -9.40900000E-05
   -2.23300000E-05  +2.37300000E-05  -2.54500000E-05  -2.46480000E-04  -2.81500000E-04
   -5.84700000E-05  -8.60560000E-03  +2.60719600E-02  -1.13916700E-02  -1.13184190E-01
   +4.62107000E-03  +2.14461200E-02  -4.94388000E-03  +1.62714000E-03  +2.27355000E-03
   -7.53140000E-04  +8.71610000E-04  -1.33438000E-03  +4.74295000E-02  -1.39844200E-02
   -1.04808800E-02  -2.86255400E-02  +3.18899900E-02  -5.20411000E-03  -4.45983100E-02
   -2.62040200E-02  +3.86053600E-02  -3.17671970E-01  +1.23562690E-01  +5.98679000E-02
   +6.43869680E-01  -6.11570000E-04  -6.29300000E-04  +2.27560000E-04  -1.00000000E-08
   +2.56400000E-05  +2.86300000E-04  -1.47820000E-04  -2.38410000E-04  +1.14280000E-04
   -2.04710000E-04  -2.04320000E-04  +6.11900000E-05  +5.50400000E-05  +2.11720000E-04
   +1.86430000E-04  -4.94300000E-05  -2.86410000E-04  -9.22680000E-04  -1.49460000E-04
   +9.39000000E-05  +1.56800000E-05  +7.00000000E-06  +1.45200000E-05  -2.76000000E-06
   +1.77430000E-04  +1.67430000E-04  +8.95500000E-05  +6.44000000E-06  +4.90600000E-05
   -8.33000000E-06  -6.42700000E-05  +1.20430000E-04  +4.65880000E-04  +1.00212400E-02
   -1.32986300E-02  +4.81329000E-03  +6.86045000E-02  -2.33982990E-01  +6.57687900E-02
   +1.88487000E-03  +5.34430000E-04  -1.06435000E-03  +5.17140000E-04  -1.52820000E-04
   +1.02744000E-03  -5.58014800E-02  -2.18752100E-02  +4.62654900E-02  +3.87257600E-02
   -4.13736000E-02  +5.82955000E-03  +4.43768000E-03  +5.78354800E-02  -3.72649100E-02
   +9.81037800E-02  -1.33119980E-01  +2.45393000E-03  -7.50654500E-02  +5.00473270E-01
   -2.74190000E-04  +4.80900000E-05  +5.22360000E-04  +2.81040000E-04  +2.36240000E-04
   -4.10680000E-04  -8.72800000E-05  +7.77500000E-05  -1.48340000E-04  +8.26300000E-05
   +4.75500000E-05  +2.26760000E-04  +1.83640000E-04  +2.02510000E-04  -1.84300000E-05
   -6.95780000E-04  +4.30650000E-04  -1.17520000E-04  +5.53800000E-05  -9.22000000E-05
   +3.07200000E-05  +1.72900000E-05  -2.56200000E-05  +5.45000000E-06  -5.87500000E-05
   -4.27100000E-05  -4.03000000E-05  +3.88000000E-06  +1.24200000E-05  -3.57000000E-06
   -2.53570000E-04  -1.45930000E-04  -6.54500000E-05  -3.68790000E-04  -5.10139000E-03
   +5.72380000E-03  -1.87027600E-02  +9.76121300E-02  -1.17927540E-01  +1.65254000E-03
   -2.40550000E-04  -2.25400000E-04  +1.03202000E-03  -9.39530000E-04  -2.84610000E-04
   +1.53024100E-02  +2.53549000E-02  -1.49779100E-02  -9.27567000E-03  +9.79034000E-03
   -1.17130000E-03  +1.96636900E-02  -2.20358000E-02  +3.66750000E-03  +7.54466000E-02
   -1.04096400E-02  -7.97188100E-02  -2.07934300E-01  -1.83504590E-01  +3.44246750E-01
   -2.07640000E-04  +7.90800000E-05  -1.62900000E-04  -1.47300000E-05  +4.05400000E-05
   -1.52800000E-05  +4.16800000E-05  +2.11400000E-05  +3.04100000E-05  -5.95400000E-05
   -6.94300000E-05  -2.05500000E-05  +9.38000000E-06  +1.91500000E-05  -5.06700000E-05
   -3.94100000E-05  +6.67400000E-05  +9.69100000E-05  -6.30000000E-06  -1.36100000E-05
   -5.40000000E-07  +1.72500000E-05  -2.30000000E-07  -1.60000000E-06  +8.70600000E-05
   +8.19100000E-05  +1.44000000E-05  +5.78000000E-06  -1.20000000E-06  +7.71000000E-06
   +6.22100000E-05  -6.41200000E-05  -1.70000000E-05  +2.01420000E-04  -7.88390000E-04
   -1.55676000E-03  +9.33200000E-03  -1.77878200E-02  +8.44174000E-03  -6.42550000E-04
   -2.09500000E-04  +7.32760000E-04  +2.87940000E-04  +1.17700000E-04  -9.39300000E-05
   -6.32810300E-02  +4.80490100E-02  -1.64333000E-02  -1.77830000E-03  +2.48728800E-02
   -1.27103000E-02  -3.14418000E-03  +3.00275000E-03  +3.12278000E-03  -1.49153000E-03
   -2.04750000E-04  +4.73390000E-04  -1.36039000E-03  -1.44668000E-03  +4.66324000E-03
   +6.42412400E-02  -2.40660000E-04  +2.28980000E-04  +2.55430000E-04  -6.03600000E-05
   -4.69700000E-05  -9.86300000E-05  -2.23000000E-06  -2.45100000E-05  -9.42000000E-06
   +6.84000000E-06  +2.25000000E-05  +4.29500000E-05  +1.75100000E-05  +8.81000000E-06
   -6.25000000E-05  -1.17880000E-04  +2.81200000E-05  +1.47430000E-04  +1.04700000E-05
   -2.63000000E-06  -6.14000000E-06  -4.30000000E-06  -1.23800000E-05  -1.32000000E-06
   -2.03500000E-05  -1.97000000E-05  -2.20700000E-05  -5.01000000E-06  -1.46000000E-05
   +2.18000000E-06  +6.86000000E-06  -9.28300000E-05  -4.87000000E-06  +1.30850000E-04
   -1.77576000E-03  -1.47661000E-03  +3.23245000E-03  -7.62454000E-03  +5.75960000E-03
   +1.55237000E-03  +1.14910000E-04  -3.13230000E-04  +2.87120000E-04  -9.00500000E-05
   -1.23020000E-04  +4.77741900E-02  -2.71402670E-01  +1.20964410E-01  +6.58730000E-04
   -8.44707000E-03  +6.86576000E-03  +2.97289000E-03  +2.34387000E-03  +1.10682000E-03
   -3.94390000E-04  +5.12680000E-04  -6.18130000E-04  -1.03484000E-03  +1.30157000E-03
   +3.51215000E-03  -5.60272700E-02  +2.86783310E-01  -2.98790000E-04  +1.03910000E-04
   +3.16800000E-04  -6.42800000E-05  -8.78800000E-05  -7.97800000E-05  -4.99000000E-06
   -3.74000000E-05  -1.63100000E-05  +1.34300000E-05  +4.71400000E-05  +3.25900000E-05
   +1.86000000E-06  -2.00600000E-05  -2.28800000E-05  -5.43600000E-05  -2.10700000E-05
   +1.30270000E-04  +5.04000000E-06  +1.30800000E-05  -1.48900000E-05  -1.22800000E-05
   -7.42000000E-06  -1.89000000E-06  -4.82800000E-05  -5.53200000E-05  -2.33500000E-05
   -9.94000000E-06  -9.48000000E-06  -4.29000000E-06  -1.63000000E-06  +2.70000000E-07
   -2.15600000E-05  -2.24620000E-03  -9.14340000E-04  -2.23651000E-03  -4.90236000E-03
   +1.64079100E-02  -3.41104000E-03  -2.03870000E-04  +7.32440000E-04  +6.29630000E-04
   +7.70120000E-04  -1.33490000E-04  -1.17230000E-04  -1.60350600E-02  +1.21228050E-01
   -1.03997290E-01  +2.10324000E-03  -5.37334000E-03  +5.49363000E-03  +3.08231000E-03
   +1.00878000E-03  +4.35050000E-03  +6.33850000E-04  -7.30560000E-04  -6.86330000E-04
   +4.44273000E-03  +3.57085000E-03  +1.67546000E-03  +1.51752600E-02  -1.33051230E-01
   +1.00874800E-01  -4.69200000E-05  +2.56630000E-04  +1.54050000E-04  -5.17200000E-05
   -7.43500000E-05  -6.56800000E-05  -1.69700000E-05  -4.05400000E-05  -1.22700000E-05
   +8.56000000E-05  +7.52400000E-05  +2.95600000E-05  -3.50000000E-05  -1.84700000E-05
   +1.57000000E-05  -2.43000000E-05  -1.24900000E-05  +2.18700000E-05  +1.15500000E-05
   +1.70100000E-05  -6.12000000E-06  -1.76500000E-05  -1.31900000E-05  +2.77000000E-06
   -1.10470000E-04  -9.54400000E-05  -3.11600000E-05  -1.25600000E-05  -1.11900000E-05
   -7.34000000E-06  +9.54000000E-06  +1.85400000E-05  +2.85200000E-05  +3.57200000E-05
   -9.48140000E-04  +7.91650000E-04  -2.73779000E-03  +4.27896000E-03  +1.79892000E-03
   +2.06300000E-05  -1.04940000E-04  +1.76300000E-05  -2.83660000E-04  +1.04530000E-04
   -5.52300000E-05  -1.32696800E-02  -1.44928700E-02  +1.70420100E-02  -1.71017860E-01
   -7.35946800E-02  +1.17042030E-01  +4.32121000E-03  +6.45587000E-03  -3.30940000E-03
   +1.82174000E-03  +1.76430000E-03  +5.38590000E-04  -5.73290000E-04  +3.52610000E-04
   -6.81940000E-04  +2.92200000E-05  -7.29590000E-04  -1.62487000E-03  +1.79737830E-01
   +2.10280000E-04  -1.36330000E-04  -8.51300000E-05  +3.20000000E-06  +7.90000000E-07
   +2.03100000E-05  +1.10400000E-05  +4.09100000E-05  +4.60000000E-07  +1.24800000E-05
   -6.93000000E-06  -2.44100000E-05  -1.90000000E-05  -8.50000000E-07  +4.30000000E-07
   +7.77000000E-06  -3.51000000E-06  +2.59700000E-05  +8.27000000E-06  -9.61000000E-06
   -2.57000000E-06  +3.00000000E-06  +4.27000000E-06  -8.90000000E-07  +5.49000000E-06
   +4.85000000E-06  +1.44000000E-06  -3.23000000E-06  -2.45000000E-06  +1.58000000E-06
   +5.77000000E-06  +8.20000000E-06  +1.46300000E-05  +5.03430000E-04  +6.08240000E-04
   -1.77240000E-04  +3.61735000E-03  +9.18290000E-04  +1.06211000E-03  -1.06410000E-04
   +4.87100000E-05  +7.47000000E-06  +1.45000000E-06  +2.97700000E-05  +5.30000000E-05
   +9.68624000E-03  +9.55993000E-03  -9.39979000E-03  -7.46840300E-02  -1.06901730E-01
   +8.48432200E-02  -1.91827500E-02  -7.15335000E-03  +1.78332000E-02  +1.23566000E-03
   -4.09549000E-03  +4.91843000E-03  +1.07361000E-03  -4.97630000E-04  -1.10705000E-03
   -1.11944000E-03  -2.69020000E-04  -1.75181000E-03  +7.88804700E-02  +1.07649450E-01
   +2.36050000E-04  -1.32940000E-04  -7.34000000E-05  -4.89000000E-06  -2.08100000E-05
   +5.37100000E-05  +2.32300000E-05  +5.53500000E-05  +2.60100000E-05  -4.97200000E-05
   -5.91200000E-05  -4.54600000E-05  -2.30000000E-07  -5.59000000E-06  -2.23700000E-05
   +1.18500000E-05  -1.07700000E-05  +1.45900000E-05  +9.10000000E-07  -5.90000000E-06
   -3.05000000E-06  +7.30000000E-06  +1.08900000E-05  -4.93000000E-06  +7.88700000E-05
   +6.40100000E-05  +1.81600000E-05  -2.62000000E-06  +1.46000000E-06  +2.98000000E-06
   -1.01000000E-05  +2.23000000E-06  -8.02000000E-06  +3.82900000E-05  +3.96080000E-04
   +3.99750000E-04  +1.97250000E-03  +6.94000000E-04  +4.22373000E-03  +4.62200000E-05
   -4.70000000E-06  -8.01000000E-05  -2.32500000E-05  +9.21900000E-05  +5.57300000E-05
   +2.13677000E-03  +3.05530000E-03  -5.67040000E-04  +1.17762530E-01  +8.44222600E-02
   -1.44891270E-01  +1.26591300E-02  +4.52699000E-03  -3.63099000E-03  +7.92830000E-04
   +4.74617000E-03  +1.62223000E-03  -1.16363000E-03  -7.76460000E-04  -3.94660000E-04
   -1.38415000E-03  -1.96264000E-03  -2.08364000E-03  -1.30016690E-01  -9.37331700E-02
   +1.46872690E-01  -1.36580000E-04  +1.04237000E-03  +2.77060000E-04  +7.08000000E-06
   -5.40300000E-05  -3.61250000E-04  -2.37240000E-04  -4.26080000E-04  -2.96670000E-04
   +8.28410000E-04  +7.79520000E-04  +4.01230000E-04  -2.26550000E-04  +4.29800000E-05
   +2.84860000E-04  -1.52240000E-04  -8.17900000E-05  -1.50370000E-04  +8.58800000E-05
   +7.88700000E-05  -2.83100000E-05  -1.25850000E-04  -9.26400000E-05  +4.82400000E-05
   -1.08844000E-03  -9.52290000E-04  -2.49190000E-04  -4.94400000E-05  -3.88600000E-05
   -6.79800000E-05  +1.82710000E-04  +1.06830000E-04  +4.02990000E-04  +1.95189000E-03
   -6.87330000E-04  +4.49940000E-04  -1.95118000E-03  +4.81343000E-03  -3.24659000E-03
   -5.51160000E-04  -2.13580000E-04  +3.70890000E-04  -1.49466000E-03  +5.65850000E-04
   -3.38900000E-04  -2.68620000E-04  +8.19570000E-04  +3.42144000E-03  -1.78838700E-02
   +1.61293400E-02  +4.76774000E-03  -2.51581700E-01  +1.30488760E-01  +2.69798600E-02
   -4.64919600E-02  +1.09410900E-02  +1.86654800E-02  +4.37096000E-03  -3.09481000E-03
   +1.35310000E-03  -6.45920000E-04  +4.76010000E-04  +2.80600000E-05  +2.33351000E-03
   -1.71029000E-03  -2.38188000E-03  +5.05632740E-01  +8.84700000E-05  -6.06810000E-04
   -1.74460000E-04  -3.02200000E-05  +6.33000000E-06  +1.88330000E-04  +1.33260000E-04
   +2.63010000E-04  +1.70730000E-04  -3.89300000E-04  -4.01000000E-04  -2.43280000E-04
   +8.22600000E-05  -2.56800000E-05  -1.32600000E-04  +1.09600000E-04  +6.83700000E-05
   +9.16600000E-05  -4.05600000E-05  -5.45500000E-05  +1.97000000E-05  +6.51400000E-05
   +4.43600000E-05  -2.18000000E-05  +5.42830000E-04  +4.93950000E-04  +1.31540000E-04
   +3.76700000E-05  +1.48600000E-05  +4.24200000E-05  -7.77600000E-05  -6.53900000E-05
   -1.91190000E-04  -8.24030000E-04  +3.56150000E-04  -6.23130000E-04  +2.66765000E-03
   +1.46720000E-03  -2.24425000E-03  +3.47760000E-04  +5.90000000E-05  -1.90650000E-04
   +8.17390000E-04  -3.36080000E-04  +1.72450000E-04  -4.57622000E-03  -5.44700000E-04
   +7.37592000E-03  +4.81157200E-02  -2.08812100E-02  -5.22407000E-03  +8.12038100E-02
   -1.44471870E-01  +2.21200300E-02  -1.07335800E-02  +1.66170800E-02  -2.74393000E-03
   -3.36800000E-04  -5.18961000E-03  +5.47951000E-03  +1.36988000E-03  -7.30100000E-04
   -2.38950000E-04  -1.39879000E-03  +1.26211000E-03  -2.66671000E-03  +5.04200000E-03
   +3.34338260E-01  -3.81000000E-06  -2.14170000E-04  +6.65200000E-05  -5.60000000E-07
   -9.21000000E-06  +7.91500000E-05  +2.41000000E-05  +6.79200000E-05  +7.36200000E-05
   -1.87400000E-04  -1.65470000E-04  -6.78800000E-05  +7.03400000E-05  +1.01900000E-05
   -6.87600000E-05  +2.89700000E-05  +4.16000000E-06  -1.95800000E-05  -2.63500000E-05
   -9.98000000E-06  +1.14000000E-05  +2.23300000E-05  +1.70000000E-05  -9.29000000E-06
   +2.36040000E-04  +2.09370000E-04  +6.08100000E-05  +2.08900000E-05  +1.34400000E-05
   +1.59100000E-05  -4.99300000E-05  -4.07500000E-05  -8.37300000E-05  -6.23770000E-04
   -1.71460000E-04  -2.65890000E-04  -1.13937000E-03  -3.73597000E-03  +2.40155000E-03
   +1.33630000E-04  +6.86900000E-05  -1.03150000E-04  +2.97830000E-04  -6.92700000E-05
   +1.40500000E-05  +6.97399000E-03  +4.67003000E-03  +1.27802000E-03  -1.51729400E-02
   +1.13578800E-02  +1.13803500E-02  +5.73606800E-02  -3.07993000E-03  -6.87790700E-02
   +3.18425800E-02  -1.39754700E-02  -4.44923000E-03  -1.86820000E-04  +6.89649000E-03
   -6.36170000E-04  -5.49570000E-04  +2.23770000E-04  +1.32100000E-04  -2.51129000E-03
   -2.55057000E-03  -1.37424000E-03  -2.48149770E-01  -1.92872470E-01  +2.71204930E-01
   -6.69700000E-04  +7.71300000E-04  -2.43640000E-04  -1.32000000E-04  +1.97200000E-05
   +5.04900000E-05  -1.43270000E-04  -1.65920000E-04  +4.02000000E-06  -3.41450000E-04
   -1.85500000E-04  +1.48750000E-04  +3.17520000E-04  +1.58790000E-04  -6.75100000E-05
   -3.55190000E-04  +3.68100000E-05  -3.60760000E-04  +2.95900000E-05  +3.70700000E-05
   +4.66000000E-06  +1.78100000E-05  +6.85000000E-06  -1.50200000E-05  +2.50470000E-04
   +2.12240000E-04  +3.88600000E-05  +7.74000000E-06  +5.26000000E-06  +1.21500000E-05
   +2.99200000E-05  -3.14100000E-05  +5.92600000E-05  -7.08480000E-04  -2.23260000E-04
   -7.77440000E-04  +8.29593000E-03  +3.47495000E-03  -3.03987000E-03  +3.16000000E-06
   -1.27990000E-04  -1.24910000E-04  -7.59400000E-05  +1.43570000E-04  +7.50300000E-05
   +1.62374000E-03  +2.35444000E-03  +3.35330000E-04  -3.58150000E-04  +9.79600000E-04
   -6.52600000E-04  -2.45912000E-03  +2.56592000E-03  +2.55848000E-03  -1.71632100E-02
   -1.02221400E-02  +1.48217100E-02  -1.73124230E-01  -8.46509500E-02  +1.16562020E-01
   +3.10860000E-04  +2.44400000E-04  -2.92270000E-04  -6.92400000E-05  -6.17300000E-05
   -3.66000000E-05  -5.85450000E-04  -6.12190000E-04  +5.53590000E-04  +1.85357790E-01
   +4.05000000E-04  +3.38200000E-05  -3.15400000E-05  +1.16550000E-04  +7.60800000E-05
   -7.27200000E-05  +7.48200000E-05  +1.54200000E-05  -4.63000000E-05  +2.46940000E-04
   +1.17890000E-04  -9.17000000E-05  -1.95270000E-04  -2.27830000E-04  +5.67000000E-05
   +1.01100000E-04  +2.97020000E-04  +3.80190000E-04  +8.77200000E-05  -4.32000000E-05
   -3.39900000E-05  -3.77900000E-05  +1.58000000E-06  +7.60000000E-06  -2.55160000E-04
   -2.43430000E-04  -5.44300000E-05  -2.75700000E-05  -9.80000000E-06  -2.34700000E-05
   +5.39000000E-06  +2.87500000E-05  -6.03000000E-05  -1.35574000E-03  +6.89200000E-05
   -1.07503000E-03  -1.93934100E-02  -6.47529000E-03  +1.74885600E-02  -1.87420000E-04
   +2.45400000E-05  -2.86900000E-05  +2.32470000E-04  -6.05370000E-04  +2.06550000E-04
   +2.70788000E-03  -3.28595000E-03  +3.92034000E-03  +6.84710000E-04  -7.29260000E-04
   -1.91630000E-04  +4.45425000E-03  +3.92790000E-04  +9.74860000E-04  +7.03641000E-03
   +8.93526000E-03  -8.67445000E-03  -7.92425900E-02  -1.09634600E-01  +8.14728800E-02
   -1.02140000E-03  -4.66460000E-04  +7.75430000E-04  -1.08850000E-04  -4.35600000E-05
   -3.00300000E-05  +1.85820000E-04  +4.31440000E-04  -4.69420000E-04  +8.50565800E-02
   +1.11340610E-01  -1.84530000E-04  +1.32930000E-04  +2.59230000E-04  -3.40180000E-04
   -3.31370000E-04  +1.94230000E-04  +4.95500000E-05  +1.49970000E-04  +1.39110000E-04
   -1.86030000E-04  -1.38580000E-04  -1.66520000E-04  -7.94600000E-05  -2.17950000E-04
   -5.11500000E-05  +1.62290000E-04  -1.63020000E-04  -1.06410000E-04  +4.64500000E-05
   -4.48500000E-05  -5.06300000E-05  +1.91300000E-05  +3.84000000E-06  -9.06000000E-06
   +2.21970000E-04  +1.67420000E-04  +4.66500000E-05  -1.42100000E-05  +1.80300000E-05
   -8.30000000E-06  +3.75700000E-05  +1.02060000E-04  -2.45100000E-05  -1.47930000E-04
   -1.44871000E-03  -1.92179000E-03  +1.05568100E-02  +6.75491000E-03  -2.17246000E-03
   -2.02700000E-04  -8.02000000E-05  -8.36400000E-05  +1.43300000E-04  -2.75650000E-04
   +4.62600000E-05  +3.86950000E-04  +4.29199000E-03  +2.83799000E-03  -5.61750000E-04
   -3.19430000E-04  -5.71900000E-05  +1.52515000E-03  +1.87706000E-03  +4.07283000E-03
   +4.49209000E-03  +3.17000000E-06  -2.15181000E-03  +1.12771410E-01  +8.30005300E-02
   -1.40989420E-01  +4.48200000E-04  +1.19880000E-04  -4.07350000E-04  -6.60000000E-07
   -5.30100000E-05  -1.50870000E-04  +1.67220000E-04  -5.54000000E-05  -2.10020000E-04
   -1.29398610E-01  -9.30792700E-02  +1.41286740E-01  +3.65290000E-04  -1.01440000E-04
   -4.16900000E-04  +5.55660000E-04  +4.65200000E-05  -1.54810000E-04  +7.29300000E-05
   -2.93400000E-05  -3.08400000E-05  +2.27120000E-04  +1.70680000E-04  -5.92900000E-05
   -1.85140000E-04  -6.57400000E-05  +6.89200000E-05  +2.83600000E-04  +2.12450000E-04
   +4.71700000E-04  -6.63000000E-05  +6.71500000E-05  +7.14000000E-06  -8.96000000E-06
   -7.16000000E-06  +8.98000000E-06  -2.07310000E-04  -1.72690000E-04  -3.12100000E-05
   -1.95000000E-05  +2.78000000E-06  -1.12500000E-05  -1.68000000E-05  -1.52700000E-05
   -1.75100000E-05  +3.72339000E-03  +4.89648000E-03  +1.03065000E-03  +9.80700000E-05
   -1.36990000E-04  +2.95390000E-04  -1.70342200E-01  -1.29189740E-01  -2.98870900E-02
   +3.74950000E-04  +3.53410000E-04  +5.32300000E-05  -1.00119000E-03  +6.84050000E-04
   +7.45080000E-04  +9.15100000E-05  +1.81220000E-04  -1.20240000E-04  -1.88530000E-04
   +2.49100000E-05  +3.14900000E-05  +7.21800000E-05  -2.95900000E-05  -2.57400000E-05
   +9.10000000E-05  -1.03840000E-04  -4.75700000E-05  -1.06345000E-03  +1.49441000E-03
   +4.87980000E-04  +2.54700000E-05  +9.41000000E-06  +1.63100000E-05  +1.02290000E-04
   -3.46700000E-05  -4.13400000E-05  -8.51000000E-06  +1.30000000E-07  +1.58000000E-06
   +1.84700710E-01  +1.37709000E-03  -3.29920000E-03  +3.85549000E-03  +3.73960000E-04
   -4.33730000E-04  -5.51350000E-04  -6.67620000E-04  -2.29720000E-04  -4.95260000E-04
   +2.45720000E-04  +4.21330000E-04  +6.14170000E-04  +5.05100000E-05  +1.72260000E-04
   +3.68600000E-05  -3.01930000E-04  -1.12850000E-04  +3.25170000E-04  +6.90900000E-05
   -1.11440000E-04  +1.55210000E-04  -1.29820000E-04  -2.44800000E-05  -2.30900000E-05
   -5.73350000E-04  -5.30210000E-04  -1.74950000E-04  -2.26700000E-05  -4.20700000E-05
   -3.26000000E-05  +1.42500000E-05  +9.52900000E-05  -6.39000000E-05  -1.81853100E-02
   -1.80569000E-02  -4.78563000E-03  -8.45860000E-04  +7.29620000E-04  -1.68600000E-04
   -1.27852320E-01  -1.82224980E-01  -3.08659300E-02  -4.90100000E-04  +8.00770000E-04
   -1.63327000E-03  -9.82000000E-06  -3.87540000E-04  +5.54170000E-04  +3.55090000E-04
   +2.85920000E-04  -2.45840000E-04  +5.46700000E-05  +9.94600000E-05  -1.66140000E-04
   -2.32440000E-04  +1.33550000E-04  +3.02000000E-05  +3.06820000E-04  -1.27290000E-04
   +1.45430000E-04  +9.52420000E-04  -3.23450000E-04  -9.24220000E-04  +9.43000000E-06
   -2.63700000E-05  +6.77000000E-06  -1.37820000E-04  +1.19760000E-04  +5.10000000E-07
   -7.38500000E-05  +8.26700000E-05  -1.02170000E-04  +1.40905780E-01  +1.98282490E-01
   -1.44800000E-03  +2.36231000E-03  -1.78549000E-03  +5.53690000E-04  +4.66110000E-04
   +1.41790000E-04  +1.45000000E-05  -3.25990000E-04  +9.22000000E-05  -2.79730000E-04
   -8.65900000E-05  +2.08130000E-04  +6.13040000E-04  +4.71400000E-05  +3.91200000E-05
   +1.00000000E-06  -3.76410000E-04  -1.22750000E-04  -3.90100000E-05  +1.22590000E-04
   -7.11300000E-05  +3.26700000E-05  +3.78000000E-05  -1.14200000E-05  +2.68660000E-04
   +2.74410000E-04  +4.37200000E-05  +2.90900000E-05  +1.08900000E-05  +1.58800000E-05
   -3.05600000E-04  +3.72570000E-04  +8.05800000E-05  +1.34041000E-02  +1.34361200E-02
   +1.55614000E-03  +8.25900000E-05  -5.59150000E-04  +3.01890000E-04  -2.96560000E-02
   -3.19616900E-02  -5.56540900E-02  +1.00875000E-03  +8.02690000E-04  +9.46140000E-04
   -1.93600000E-04  -6.85640000E-04  +4.45610000E-04  -1.20400000E-05  +2.18930000E-04
   -1.51850000E-04  -9.31300000E-05  -3.41900000E-05  +8.50400000E-05  +8.86400000E-05
   +2.94000000E-06  -4.70800000E-05  +4.27500000E-05  +3.52000000E-05  -1.76220000E-04
   +5.19080000E-04  -3.53190000E-04  -2.05400000E-04  +3.45000000E-06  -5.17000000E-06
   +8.68000000E-06  +6.49000000E-06  +3.48400000E-05  -2.61200000E-05  +2.67900000E-05
   +3.43500000E-05  +8.56000000E-06  +3.24277000E-02  +3.19333500E-02  +5.73009000E-02
   -1.21550000E-04  +2.25150000E-04  +6.79470000E-04  -1.07000000E-04  -1.13900000E-04
   +5.25700000E-05  +1.00670000E-04  +4.99500000E-05  +4.77800000E-05  -1.94100000E-05
   -7.58000000E-05  -7.65100000E-05  -2.24550000E-04  -3.17600000E-05  -5.76000000E-06
   +4.55000000E-06  -1.47570000E-04  -1.04480000E-04  +2.45000000E-06  +2.89900000E-05
   -5.23800000E-05  -1.38000000E-06  +1.28800000E-05  -7.33000000E-06  +3.12800000E-05
   +3.97100000E-05  +4.45000000E-06  +2.21400000E-05  -1.84800000E-05  +6.74000000E-06
   +2.39530000E-04  -8.58100000E-05  +5.48800000E-05  -1.69014000E-03  -1.84508000E-03
   -5.84394000E-03  +4.64070000E-04  -4.81730000E-04  -5.22950000E-04  -4.70758400E-02
   +7.56000000E-05  +2.14142000E-03  -2.37010000E-04  +1.23613000E-03  -6.79920000E-04
   -1.98750000E-04  +4.82050000E-04  -3.71640000E-04  -1.23800000E-04  -6.53900000E-05
   +2.09570000E-04  -1.12720000E-04  -5.03100000E-05  +8.03900000E-05  +1.77510000E-04
   -7.87700000E-05  -2.84300000E-05  -6.32100000E-05  +7.14000000E-05  +1.43000000E-05
   -1.31567000E-03  -1.95080000E-04  -4.34820000E-04  -4.24000000E-06  +2.46000000E-06
   -2.80900000E-05  +1.44930000E-04  -1.02320000E-04  -1.70600000E-05  -2.53000000E-06
   -6.23500000E-05  +2.13800000E-05  +2.81620000E-04  -4.49397000E-03  -2.18313500E-02
   +4.80008400E-02  +7.03080000E-04  +1.36490000E-03  +1.69360000E-04  -4.52890000E-04
   -1.14100000E-04  +3.93600000E-05  +2.74700000E-04  +2.36120000E-04  +2.12720000E-04
   +6.22000000E-05  -8.96500000E-05  -3.49470000E-04  -1.96370000E-04  -2.04150000E-04
   -2.36040000E-04  -3.93950000E-04  -2.64930000E-04  +6.66500000E-04  +6.90600000E-05
   +1.61000000E-06  -3.38900000E-05  +2.03300000E-05  -6.39000000E-06  +3.60000000E-06
   +1.41130000E-04  +1.04110000E-04  +2.74100000E-05  -9.54000000E-06  -1.54500000E-05
   +1.86800000E-05  +1.41880000E-04  -1.10313000E-03  -2.17390000E-04  -9.13700000E-04
   +6.57356000E-03  +2.52859300E-02  -5.01530000E-04  +1.23414000E-03  -3.65700000E-04
   -3.06900000E-04  -6.46413300E-02  -6.64476200E-02  +7.78180000E-04  -4.29829000E-03
   +2.60380000E-03  +4.57000000E-04  +3.55990000E-04  -1.31990000E-04  +9.46600000E-05
   -1.97430000E-04  +3.08600000E-05  +1.41740000E-04  +9.57700000E-05  -1.52980000E-04
   -2.12880000E-04  +4.78700000E-05  +9.10500000E-05  -1.65270000E-04  -2.18470000E-04
   -5.02700000E-05  +2.26030000E-04  -1.41980000E-04  +5.96500000E-05  +1.62000000E-05
   +1.12600000E-05  +2.28000000E-05  -6.26600000E-05  +5.19000000E-06  +3.60700000E-05
   +1.24800000E-05  +3.26600000E-05  +4.33500000E-05  +1.97407000E-03  -5.35617000E-03
   -2.17672100E-02  -1.18985000E-03  +6.95436900E-02  -1.08927000E-03  -8.48360000E-04
   +5.07110000E-04  +6.88320000E-04  +2.66900000E-04  -2.49080000E-04  -3.70630000E-04
   -3.43530000E-04  -1.33150000E-04  -2.17650000E-04  +1.31860000E-04  +4.22080000E-04
   +5.14190000E-04  +2.56750000E-04  +2.09450000E-04  +1.37880000E-04  -7.10400000E-04
   -1.55700000E-04  -1.16380000E-04  -3.30200000E-05  +9.15000000E-05  -5.31000000E-06
   +1.67000000E-05  -1.28100000E-05  +1.06500000E-05  +1.85100000E-05  +2.91000000E-06
   +4.15400000E-05  +7.08000000E-06  +7.16000000E-06  -2.48400000E-04  +1.04290000E-04
   +3.26910000E-04  +4.19070000E-04  -5.59517000E-03  -1.72754800E-02  +1.06805000E-03
   -7.60280000E-04  +5.04780000E-04  +2.00685000E-03  -6.41898000E-02  -2.99072900E-01
   -6.46970000E-04  +4.58592000E-03  -1.52004000E-03  +4.35160000E-04  +2.87350000E-04
   +1.49680000E-04  -2.79540000E-04  +4.02400000E-05  +2.75850000E-04  -4.62300000E-05
   -2.42250000E-04  +8.95800000E-05  +2.09920000E-04  -1.02680000E-04  -8.52100000E-05
   -1.86170000E-04  +4.27370000E-04  +8.93900000E-05  -3.11120000E-04  -3.39700000E-04
   +3.41000000E-05  -1.69800000E-05  +2.51900000E-05  +9.22000000E-06  -1.12800000E-05
   -2.08800000E-05  -1.37000000E-06  -1.76200000E-05  -1.04980000E-04  -5.81000000E-06
   +5.75780000E-04  -5.33600000E-04  -3.28346000E-03  -1.81577000E-03  +6.93920600E-02
   +3.25486110E-01  +7.74170000E-04  -1.33602000E-03  -3.40250000E-04  +2.62020000E-04
   +1.08020000E-04  +1.53780000E-04  +1.07670000E-04  +1.35060000E-04  -3.73100000E-05
   +4.80700000E-05  +1.32600000E-05  -1.70230000E-04  -2.32870000E-04  -2.49000000E-05
   +6.39000000E-06  +3.24560000E-04  +2.29810000E-04  +3.28120000E-04  +1.72300000E-05
   +3.21700000E-05  -1.93100000E-05  +2.24900000E-05  +1.85100000E-05  +6.96000000E-06
   +2.33000000E-06  -2.36100000E-05  +1.56600000E-05  -5.09000000E-06  +1.01500000E-05
   -1.20000000E-07  +3.50400000E-05  -7.06300000E-05  -2.54000000E-05  -5.77042000E-03
   +1.33778000E-03  +1.76306000E-03  +7.77430000E-04  +5.47430000E-04  -6.38740000E-04
   -2.68280710E-01  +8.90475100E-02  +5.53627400E-02  -9.48200000E-05  -3.24220000E-04
   +5.36650000E-04  -5.58700000E-05  -1.70600000E-04  +2.65930000E-04  +1.29610000E-04
   +1.84190000E-04  -1.45470000E-04  +1.93480000E-04  -7.00900000E-05  -8.89200000E-05
   -1.57380000E-04  +1.92450000E-04  -7.58800000E-05  -1.82610000E-04  -1.11000000E-04
   +2.60030000E-04  +2.35600000E-04  +1.94040000E-04  -3.88240000E-04  -2.54400000E-05
   -1.94000000E-06  +2.87800000E-05  -2.60060000E-04  +1.52770000E-04  +3.26300000E-05
   +6.02200000E-05  +6.02100000E-05  -4.69500000E-05  -1.81108200E-02  +8.33649000E-03
   +5.15177000E-03  +7.84060000E-04  -9.76300000E-04  -5.93890000E-04  +2.88638940E-01
   +1.43702000E-03  +7.88550000E-04  -2.83110000E-04  -2.82740000E-04  +1.57630000E-04
   +6.08300000E-05  -1.74390000E-04  -9.47700000E-05  +6.56500000E-05  -2.27910000E-04
   -1.92550000E-04  +9.17600000E-05  +1.47880000E-04  +7.12300000E-05  -7.66900000E-05
   -1.79550000E-04  -1.46790000E-04  -5.41200000E-04  +3.42700000E-05  -3.29900000E-05
   +7.15600000E-05  +1.70900000E-05  -4.79000000E-06  -8.20000000E-06  +2.36850000E-04
   +2.30930000E-04  +5.30500000E-05  +6.86000000E-06  -6.42000000E-06  +9.50000000E-06
   +1.56900000E-05  +5.94600000E-05  +1.47930000E-04  +2.39782100E-02  -1.21755400E-02
   -5.78043000E-03  -5.24430000E-04  -3.57437000E-03  +3.88329000E-03  +8.68369700E-02
   -8.08149500E-02  -2.26912200E-02  -1.41830000E-04  +4.37450000E-04  -1.37086000E-03
   -6.89670000E-04  -2.79010000E-04  +6.17690000E-04  +2.11020000E-04  +2.23040000E-04
   -1.00160000E-04  -3.92010000E-04  +1.81750000E-04  +8.87700000E-05  +2.05590000E-04
   -4.71280000E-04  +1.01300000E-05  +1.53274000E-03  -3.56030000E-04  -3.07010000E-04
   -9.48500000E-05  +1.85820000E-04  -3.94290000E-04  +4.42100000E-05  +3.70000000E-06
   -1.69000000E-05  +2.63980000E-04  -1.20370000E-04  -1.03720000E-04  -3.82000000E-06
   +6.28900000E-05  +4.48000000E-05  -2.11826000E-02  +9.39923000E-03  +6.13647000E-03
   +6.87723000E-03  -3.51011000E-03  -1.42339000E-03  -9.72581700E-02  +8.94674800E-02
   -4.32490000E-04  -3.70310000E-04  +4.58770000E-04  -1.64880000E-04  -1.86110000E-04
   +1.48610000E-04  +9.60600000E-05  +1.05510000E-04  +2.26800000E-05  +1.00390000E-04
   +8.68000000E-06  -1.76980000E-04  -3.46720000E-04  -6.10700000E-05  +1.00870000E-04
   +3.31230000E-04  +7.08500000E-05  -2.92800000E-04  +2.84300000E-05  +1.75800000E-05
   -7.02100000E-05  -4.63000000E-06  +6.20000000E-07  +1.06900000E-05  -1.09140000E-04
   -7.52100000E-05  -1.00600000E-05  +2.02600000E-05  -1.56500000E-05  +4.10000000E-07
   +3.69800000E-05  +6.08000000E-06  +1.16150000E-04  -1.73413200E-02  +7.37004000E-03
   +2.61659000E-03  +2.37100000E-04  +2.72057000E-03  -2.16761000E-03  +5.64484500E-02
   -2.36163200E-02  -6.11757900E-02  -1.24828000E-03  +4.18610000E-04  +1.10966000E-03
   +6.22810000E-04  +4.30450000E-04  -2.06360000E-04  -2.10850000E-04  -4.94000000E-06
   +2.52940000E-04  +5.00700000E-05  -1.95290000E-04  +2.73500000E-05  +2.55500000E-05
   +1.97400000E-04  -1.50100000E-04  -1.01417000E-03  +6.60380000E-04  +4.09410000E-04
   -9.70000000E-05  -5.29740000E-04  -3.35000000E-05  -7.60000000E-07  +1.37300000E-05
   +2.47900000E-05  -1.63000000E-05  -2.36800000E-05  -2.40000000E-07  -3.15000000E-06
   -6.53000000E-05  +1.36300000E-05  -5.74110000E-03  +2.47863000E-03  +5.34770000E-04
   +2.89095800E-02  -1.06794200E-02  -5.79790000E-03  -6.06275500E-02  +2.13851600E-02
   +6.47478100E-02  +6.48470000E-04  +1.32820000E-04  +1.17800000E-04  -1.37890000E-04
   -6.49500000E-05  +4.78130000E-04  +1.77470000E-04  -6.28200000E-05  -2.73290000E-04
   +7.51300000E-05  +8.28500000E-05  -1.33000000E-06  -6.49900000E-05  -3.76700000E-05
   -1.07390000E-04  +9.11300000E-05  -6.63000000E-06  +2.82840000E-04  +1.04000000E-04
   +8.04200000E-05  -5.44690000E-04  -1.34700000E-05  -1.83300000E-05  +2.17500000E-05
   -1.57390000E-04  -1.47880000E-04  -8.06300000E-05  -3.18600000E-05  +1.05500000E-05
   -1.89400000E-05  +7.77700000E-05  -2.81500000E-05  -6.67800000E-05  -1.75462000E-03
   -8.06400000E-05  +8.87900000E-04  +7.39730000E-04  +1.30629000E-03  +4.50780000E-04
   -2.28280000E-04  -8.19000000E-05  +3.37970000E-04  -2.13254070E-01  -1.30549920E-01
   -2.12060700E-02  +2.04720000E-04  -1.48370000E-04  +8.72200000E-05  +1.08740000E-04
   -6.74300000E-05  -8.01100000E-05  -8.87000000E-06  +1.26860000E-04  -1.10270000E-04
   -2.33130000E-04  -3.92000000E-05  -4.08000000E-06  +3.49250000E-04  -2.01890000E-04
   +3.59500000E-05  +3.41900000E-05  -1.46600000E-05  -1.76500000E-05  +2.80900000E-05
   -1.00400000E-05  -3.89000000E-06  +5.19600000E-05  -2.42900000E-05  +9.01000000E-06
   +2.00900000E-05  +3.60300000E-05  +4.33400000E-05  +2.33150000E-04  +4.35070000E-04
   -4.65990000E-04  +2.47180000E-04  +2.76520000E-04  +5.26000000E-05  +2.70900000E-05
   -1.30730000E-04  +1.37600000E-05  +2.28293310E-01  +6.10580000E-04  +2.13270000E-04
   -2.27979000E-03  +1.18930000E-04  +2.82660000E-04  -1.94060000E-04  -2.25900000E-05
   +1.27680000E-04  -2.64500000E-05  +2.40920000E-04  +1.25390000E-04  -6.79800000E-05
   -6.61600000E-05  -2.27590000E-04  -1.47630000E-04  -7.17500000E-04  -1.32300000E-05
   +2.04530000E-04  +2.71230000E-04  -2.42770000E-04  +7.18600000E-05  -4.34900000E-05
   -5.31000000E-06  +1.47000000E-06  -2.10280000E-04  -2.00760000E-04  -3.27100000E-05
   -2.57900000E-05  -8.97700000E-05  +3.95000000E-06  +1.35100000E-05  +4.05700000E-05
   -7.39200000E-05  -7.92277000E-03  -8.28597000E-03  -1.11603000E-03  -8.59430000E-04
   +4.33750000E-04  +2.23580000E-04  +7.09710000E-04  +3.87410000E-04  +8.72870000E-04
   -1.29368300E-01  -1.48870490E-01  -1.54373800E-02  +3.41950000E-04  +1.40870000E-04
   -2.50100000E-05  +1.34170000E-04  +2.02100000E-05  -7.17500000E-05  +1.53690000E-04
   -6.44700000E-05  -9.87000000E-05  -1.09100000E-05  +1.18300000E-05  +2.07300000E-05
   +1.30260000E-04  -4.68780000E-04  +4.20960000E-04  -3.68700000E-05  -1.51000000E-05
   -4.11400000E-05  -3.53000000E-06  -6.09000000E-06  -3.54000000E-06  -1.56350000E-04
   +9.81700000E-05  +5.06300000E-05  -7.36000000E-05  +1.53140000E-04  -9.20000000E-05
   -9.07000000E-06  +4.64790000E-04  +1.80250000E-04  +1.89100000E-04  +1.50100000E-05
   -3.85100000E-05  +9.31500000E-05  +3.34500000E-05  +2.28100000E-05  +1.42289560E-01
   +1.59096450E-01  +1.29108000E-03  -7.99150000E-04  -5.93543000E-03  +1.01184000E-03
   +1.30800000E-04  -7.34770000E-04  -2.29330000E-04  -9.48800000E-05  +2.51110000E-04
   +1.61380000E-04  +1.90430000E-04  +4.96900000E-05  +1.40300000E-04  -2.03150000E-04
   -4.08570000E-04  -1.64997000E-03  -1.21265000E-03  +1.68260000E-04  -7.19700000E-05
   +3.43130000E-04  +5.04840000E-04  -3.14300000E-05  -3.87600000E-05  -2.16000000E-06
   -1.69890000E-04  -1.19200000E-04  +1.64500000E-05  -1.26740000E-04  -9.71600000E-05
   -3.42300000E-05  -2.62000000E-06  +4.91800000E-05  -5.11000000E-06  -2.45413200E-02
   -1.98627500E-02  -5.14262000E-03  -1.25808000E-03  +6.88600000E-05  +7.80430000E-04
   -7.65970000E-04  -1.29424000E-03  +1.28504000E-03  -1.91985800E-02  -1.40613600E-02
   -4.81807600E-02  -1.53800000E-05  +1.28220000E-04  +2.47220000E-04  +2.56350000E-04
   -8.01900000E-05  -9.78200000E-05  +2.34960000E-04  +9.32000000E-05  -2.29940000E-04
   -3.89900000E-04  -6.33000000E-05  +1.26340000E-04  +4.11950000E-04  -1.02880000E-04
   +2.53200000E-05  +1.47000000E-06  +3.59500000E-05  -1.08270000E-04  -8.48000000E-06
   -1.31500000E-05  +7.32000000E-06  -2.72620000E-04  +1.26430000E-04  +6.91600000E-05
   +1.32000000E-05  +2.81700000E-05  +2.44900000E-05  +1.97620000E-04  +7.39070000E-04
   -5.02080000E-04  +3.54220000E-04  +8.12200000E-05  +2.81020000E-04  +8.26500000E-05
   +6.56200000E-05  -6.00900000E-05  +2.19991100E-02  +1.89272900E-02  +5.55312500E-02
   -7.03600000E-05  -1.48750000E-04  +2.39180000E-04  -8.26940000E-04  -1.18215000E-03
   +4.46830000E-04  +1.90870000E-04  -7.49400000E-05  -3.34480000E-04  -1.74060000E-04
   -4.76000000E-05  +4.53000000E-06  +2.80000000E-05  +2.45000000E-06  -4.21000000E-06
   +1.30050000E-04  +1.49130000E-04  +4.08700000E-05  -9.20390000E-04  -1.78830000E-03
   -7.06750000E-04  +3.39000000E-05  -5.03000000E-06  +2.26400000E-05  +6.42600000E-05
   +3.73200000E-05  -3.76700000E-05  +9.81000000E-06  +2.00000000E-05  -1.20000000E-07
   -9.50000000E-06  -5.13000000E-06  -2.65500000E-05  +1.10242000E-03  -1.30834000E-03
   -1.01391000E-03  +3.90420000E-04  +4.08580000E-04  +6.39360000E-04  +4.36360000E-04
   -2.30490000E-04  -5.02700000E-04  -2.30522050E-01  +1.10846850E-01  +5.33512400E-02
   +5.86730000E-04  +3.07690000E-04  -1.10050000E-04  -6.96000000E-05  +1.15630000E-04
   -4.32800000E-05  +3.23280000E-04  -1.93500000E-04  -7.41000000E-05  -1.58650000E-04
   -3.77900000E-05  +6.55900000E-05  +2.86050000E-04  -3.61420000E-04  +2.98910000E-04
   -4.39000000E-05  -6.52100000E-05  -1.16600000E-05  -3.30700000E-05  -2.64000000E-06
   +6.36000000E-06  -3.60750000E-04  +1.74530000E-04  +8.08100000E-05  -3.49500000E-05
   -2.89300000E-05  -3.83700000E-05  -1.91600000E-04  +7.70200000E-05  +1.18680000E-04
   +2.15330000E-04  -2.19990000E-04  -1.16700000E-05  +3.23370000E-04  -2.05580000E-04
   +2.11040000E-04  -1.93437800E-02  +1.35806400E-02  +5.60832000E-03  +2.51021830E-01
   +5.32430000E-04  +3.59390000E-04  +2.06800000E-04  +1.06910000E-04  -4.25240000E-04
   -1.10866000E-03  -2.83430000E-04  +6.31200000E-05  +4.34440000E-04  -1.88400000E-05
   -2.73300000E-05  +5.63600000E-05  +1.10130000E-04  +1.18320000E-04  +7.67300000E-05
   -2.36830000E-04  -9.78300000E-05  -1.01610000E-04  -1.50409000E-03  -1.77387000E-03
   +3.96840000E-04  +1.00000000E-07  -2.15100000E-05  -2.67300000E-05  +9.13000000E-05
   +1.25100000E-04  +9.72900000E-05  +3.53000000E-06  -6.04000000E-06  +1.28900000E-05
   +9.94000000E-06  +2.80100000E-05  +1.24870000E-04  +8.60647000E-03  -5.78223000E-03
   -1.26634000E-03  -2.42800000E-05  +2.72710000E-04  -2.30963000E-03  -2.94740000E-04
   +3.30670000E-04  +1.16377000E-03  +1.09738230E-01  -1.14483470E-01  -3.21125700E-02
   -4.35090000E-04  -3.29970000E-04  +1.66850000E-04  +6.14670000E-04  -3.50410000E-04
   +7.72600000E-05  -7.76900000E-05  +5.55380000E-04  -3.50760000E-04  -5.30600000E-04
   +3.06600000E-05  +6.13300000E-05  +4.06800000E-04  -1.73830000E-04  -2.46070000E-04
   -3.99700000E-05  +8.80000000E-06  -8.27700000E-05  +7.84600000E-05  +9.43000000E-06
   +3.41300000E-05  +2.90700000E-04  -1.72750000E-04  -2.88600000E-05  +8.45800000E-05
   +2.59100000E-04  +1.85060000E-04  -1.64330000E-04  -3.33100000E-05  -9.16600000E-05
   -1.96510000E-04  -8.52700000E-05  -7.94000000E-06  -1.23940000E-04  +5.05480000E-04
   +8.07100000E-05  -1.67862000E-02  +1.11845600E-02  +5.43720000E-03  -1.19841790E-01
   +1.21324240E-01  +3.71070000E-04  +5.84970000E-04  +8.26400000E-04  -2.53890000E-04
   +1.13920000E-04  +1.99050000E-04  -2.03710000E-04  -9.06400000E-05  -1.37900000E-05
   -1.29410000E-04  -4.41900000E-05  +1.97400000E-04  +1.66370000E-04  +1.36560000E-04
   +1.54100000E-05  -1.37940000E-04  +5.30300000E-05  -2.76220000E-04  -2.18700000E-04
   -2.68650000E-04  +3.74140000E-04  +5.08000000E-06  -1.19300000E-05  -3.37000000E-06
   +7.81000000E-05  +7.41400000E-05  +7.78000000E-06  +2.33600000E-05  -1.67300000E-05
   +8.89000000E-06  +5.02200000E-05  -4.56000000E-06  +7.30600000E-05  +2.63111400E-02
   -1.46361800E-02  -8.13142000E-03  -1.32200000E-03  -1.16349000E-03  -5.43827000E-03
   +1.25049000E-03  -9.17080000E-04  +1.37486000E-03  +5.26308300E-02  -3.11553000E-02
   -6.32497400E-02  +4.65060000E-04  -6.46750000E-04  -2.89000000E-05  +3.49310000E-04
   -1.43600000E-05  +3.86340000E-04  -4.50840000E-04  +2.77420000E-04  -2.50000000E-07
   +4.98000000E-04  +1.23230000E-04  +5.74600000E-05  +4.87900000E-05  +2.86370000E-04
   +7.20600000E-05  -3.69000000E-05  -6.86500000E-05  -2.26740000E-04  +1.11170000E-04
   -1.00600000E-05  -9.42000000E-06  +6.77590000E-04  -3.65510000E-04  -1.59560000E-04
   -1.57660000E-04  -2.80960000E-04  -1.23730000E-04  +1.03400000E-05  +1.35310000E-04
   -6.17800000E-05  -2.76200000E-04  -9.18000000E-06  +4.39610000E-04  -6.86940000E-04
   +4.56530000E-04  -6.36460000E-04  -2.61235000E-03  +2.07158000E-03  -5.86900000E-05
   -5.87514300E-02  +3.63079400E-02  +6.88492000E-02  +2.82650000E-04  +5.70410000E-04
   -2.21930000E-04  +7.24600000E-05  -2.32490000E-04  -7.92640000E-04  -1.18270000E-04
   -5.85200000E-05  +2.93780000E-04  -6.75600000E-05  -1.47800000E-05  +3.71000000E-05
   +1.06730000E-04  +9.52700000E-05  +4.50500000E-05  -9.08800000E-05  -9.07600000E-05
   -6.92200000E-05  -1.29026000E-03  +1.82540000E-04  -1.55600000E-04  -5.46000000E-06
   +5.62000000E-06  -2.56900000E-05  +9.60900000E-05  +1.12000000E-04  +7.09100000E-05
   +5.50000000E-06  +4.61000000E-06  +1.06900000E-05  -2.25400000E-05  +3.11400000E-05
   +7.14700000E-05  -2.03171000E-03  +1.14484000E-03  -7.53870000E-04  +1.14320000E-04
   -8.23020000E-04  +3.65510000E-04  +8.92000000E-06  -3.81250000E-04  -5.38570000E-04
   -5.10583500E-02  +2.51387100E-02  -2.00562000E-02  -1.54060000E-04  +3.46500000E-05
   +8.30600000E-05  +1.46200000E-04  -7.76000000E-05  +2.53400000E-05  -4.85300000E-05
   +1.48260000E-04  -4.14500000E-05  -2.28240000E-04  +1.62800000E-05  +4.00000000E-07
   -1.02450000E-04  +1.64900000E-04  +1.60580000E-04  +1.29200000E-05  +8.30000000E-06
   -5.68200000E-05  +3.64000000E-06  -3.31000000E-06  -1.49100000E-05  +7.63200000E-05
   -4.17800000E-05  -2.12700000E-05  +1.81920000E-04  +2.55140000E-04  +2.12560000E-04
   +9.34300000E-05  +3.39270000E-04  -5.23800000E-05  +6.21920000E-04  +2.24640000E-04
   -1.60490000E-04  +3.64860000E-04  -3.02930000E-04  +2.22900000E-04  +3.68873000E-03
   -1.94000000E-02  +1.69292100E-02  -2.42879000E-03  +1.99598300E-02  -1.77309000E-02
   +5.18131500E-02  -2.81640000E-04  +4.87120000E-04  +2.63710000E-04  -7.71750000E-04
   +1.82420000E-04  +1.76610000E-04  +7.21900000E-05  -8.10000000E-06  -2.05250000E-04
   -7.74000000E-05  -1.07370000E-04  +6.39400000E-05  +4.81600000E-05  +3.15600000E-05
   -2.50100000E-05  +2.29330000E-04  +1.02480000E-04  +2.88800000E-05  -2.19980000E-04
   -1.83680000E-04  -3.70050000E-04  -1.03400000E-05  +4.00000000E-05  -5.34000000E-06
   +7.83400000E-05  +4.44100000E-05  -1.93000000E-05  +1.99000000E-05  +9.58000000E-06
   +5.99000000E-06  +5.19000000E-06  +5.54000000E-06  -3.35800000E-05  -1.12015000E-03
   +8.03077000E-03  -7.24946000E-03  -6.14300000E-05  +5.96740000E-04  +3.92300000E-05
   -1.72240000E-04  +1.42300000E-05  -1.56163000E-03  +2.53691100E-02  -2.06206320E-01
   +1.30757910E-01  -9.93200000E-05  -2.13400000E-05  +1.41590000E-04  +3.91800000E-05
   +2.68700000E-05  -7.12000000E-05  +6.71000000E-05  +8.76000000E-06  +1.76400000E-05
   -2.36310000E-04  -4.42000000E-05  +1.99100000E-05  +3.37850000E-04  -1.03390000E-04
   -6.82100000E-04  +2.15000000E-05  +6.81000000E-06  -4.86000000E-05  -1.17800000E-05
   -1.59000000E-06  +6.43000000E-06  -1.27940000E-04  +5.50100000E-05  +1.87200000E-05
   +2.06960000E-04  -5.01450000E-04  -3.80950000E-04  +2.03460000E-04  +2.16170000E-04
   -2.53850000E-04  -5.63600000E-05  +6.27230000E-04  -2.85530000E-04  -1.84700000E-04
   +6.79000000E-06  -1.67160000E-04  +3.69344000E-03  -1.43560500E-02  +1.15943100E-02
   +2.21500000E-05  -1.13830900E-02  +9.12211000E-03  -2.69923500E-02  +2.22418500E-01
   +8.91330000E-04  +9.35420000E-04  +1.38047000E-03  +1.23880000E-04  -1.38230000E-04
   +5.37300000E-05  -2.50580000E-04  -2.86400000E-04  +7.48700000E-05  -1.53520000E-04
   +6.46800000E-05  +2.91470000E-04  +2.51230000E-04  +2.14160000E-04  +2.59000000E-06
   +8.38500000E-05  -4.76990000E-04  -2.13540000E-04  -5.22700000E-04  +8.39300000E-05
   +1.34470000E-04  -2.05200000E-05  -1.04200000E-05  -1.80200000E-05  +3.60100000E-05
   +3.53600000E-05  +4.03000000E-06  -2.48900000E-05  +3.49300000E-05  -2.04000000E-05
   -4.18100000E-05  +8.34700000E-05  +5.40900000E-05  -3.27022000E-03  +2.41008100E-02
   -1.83230000E-02  -1.55660000E-03  +7.69550000E-04  +9.31600000E-04  +2.31190000E-04
   -3.45049000E-03  -6.07931000E-03  -1.94822000E-02  +1.28698650E-01  -1.53487560E-01
   +8.25230000E-04  +8.62100000E-05  -2.58830000E-04  -5.49100000E-04  +3.60100000E-04
   +3.22400000E-05  -1.48230000E-04  -4.89600000E-04  +3.41410000E-04  +7.24920000E-04
   -2.61550000E-04  +1.92600000E-05  +7.38300000E-05  +5.54430000E-04  +6.23000000E-06
   -1.41180000E-04  -5.34100000E-05  +7.31500000E-05  -1.31400000E-05  -1.30000000E-05
   -2.53200000E-05  -7.13100000E-05  +2.38900000E-05  +1.41000000E-06  -5.03300000E-05
   -7.90200000E-04  -1.48160000E-04  +1.59780000E-04  -1.92870000E-04  +2.59450000E-04
   -4.90040000E-04  +1.65844000E-03  -1.32464000E-03  -9.14500000E-05  -1.28170000E-04
   +1.78370000E-04  +7.65460000E-04  -3.28929000E-03  +2.15885000E-03  +5.51900000E-04
   -7.19901000E-03  +5.48754000E-03  +2.21615100E-02  -1.40910370E-01  +1.68429630E-01
   +5.08600000E-05  -1.39560000E-04  -6.10900000E-05  -1.52300000E-05  -6.67000000E-06
   +4.84800000E-05  +4.21700000E-05  +6.82900000E-05  +4.57100000E-05  -1.40830000E-04
   -1.28260000E-04  -6.15800000E-05  +3.34700000E-05  -1.69100000E-05  -4.54300000E-05
   +1.07400000E-05  -2.70000000E-07  +5.03900000E-05  -1.05000000E-05  -1.09000000E-05
   -4.00000000E-07  +1.92000000E-05  +1.39400000E-05  -9.40000000E-06  +1.77320000E-04
   +1.46590000E-04  +3.66500000E-05  -4.45000000E-06  +5.15000000E-06  +6.07000000E-06
   -2.70700000E-05  +1.85000000E-06  -5.10700000E-05  -1.71080000E-04  +1.52140000E-04
   -8.82000000E-05  +5.16940000E-04  +3.29960000E-04  -3.19370000E-04  +8.08200000E-05
   +5.53000000E-06  -3.02600000E-05  +1.49130000E-04  -4.92700000E-05  +2.69700000E-05
   -8.67980000E-04  -2.82270000E-04  +2.33240000E-04  +4.22672000E-03  -2.25801000E-03
   -1.01740000E-03  -3.13198100E-02  -2.18410500E-02  +2.82082900E-02  -4.01426000E-03
   +4.26464000E-03  +2.83930000E-04  -1.71000000E-05  -1.02861000E-03  +1.27777000E-03
   +1.95560000E-04  -1.62840000E-04  -3.97200000E-05  -1.51380000E-04  +1.62655000E-03
   -6.83530000E-04  -1.91857160E-01  -1.21645250E-01  +1.71031950E-01  -2.38920000E-04
   +1.53970000E-04  -6.67800000E-05  -1.19100000E-05  +3.90700000E-05  +1.17800000E-05
   -3.45500000E-05  +2.74000000E-06  -1.36000000E-05  +5.15500000E-05  -2.13600000E-05
   -1.08100000E-05  -1.18400000E-05  +2.07500000E-05  +3.29100000E-05  +4.79400000E-05
   -4.20400000E-05  -6.64200000E-05  -1.19600000E-05  +1.14300000E-05  +1.22200000E-05
   +2.23336320E-01  +2.62800000E-05  +5.90000000E-06  +2.26700000E-05  +1.18000000E-06
   -6.78000000E-06  -8.11000000E-06  -5.65000000E-06  -7.21000000E-06  -1.36200000E-05
   +3.40500000E-05  +3.12000000E-05  +1.24800000E-05  -4.87000000E-06  -5.14000000E-06
   +1.14900000E-05  +1.55000000E-06  +1.02000000E-06  +4.83000000E-06  +6.99000000E-06
   +5.20000000E-07  -2.96000000E-06  -3.95000000E-06  -1.30000000E-06  +9.90000000E-07
   -3.82200000E-05  -3.83100000E-05  -1.13000000E-05  -5.74000000E-06  -1.20000000E-07
   -4.08000000E-06  +1.39000000E-06  +1.32400000E-05  +2.10000000E-06  -5.67500000E-05
   -4.49600000E-05  +9.82000000E-06  -1.32050000E-04  -3.75280000E-04  +4.34740000E-04
   -1.50600000E-05  +2.98100000E-05  -9.64000000E-06  +3.68000000E-05  -1.40600000E-05
   +1.21600000E-05  +1.06940000E-04  -6.53830000E-04  -1.17850000E-04  +2.71291000E-03
   +1.49002000E-03  -2.60641000E-03  +1.75311200E-02  +9.31219000E-03  -1.61956000E-02
   +3.84448000E-03  -1.21969000E-03  -2.11860000E-04  +1.02860000E-04  +1.12186000E-03
   +8.21800000E-05  +2.03400000E-05  -4.49100000E-05  -3.18500000E-05  -7.05520000E-04
   -1.00501000E-03  +1.29978000E-03  -1.64363550E-01  -1.82028980E-01  +1.93878790E-01
   +8.77900000E-05  -1.25660000E-04  -9.80700000E-05  -4.08000000E-06  -2.95300000E-05
   -1.27600000E-05  +1.36400000E-05  +1.04500000E-05  +8.56000000E-06  -1.64200000E-05
   -3.15000000E-06  +9.70000000E-06  +2.99000000E-06  -8.36000000E-06  +2.71000000E-06
   -2.24000000E-06  +1.10500000E-05  -2.18500000E-05  +6.41000000E-06  +2.40000000E-06
   -8.66000000E-06  +1.40811320E-01  +1.73575370E-01  +2.08100000E-05  +6.24300000E-05
   +3.39000000E-06  -9.11000000E-06  -1.15100000E-05  -1.97300000E-05  -1.22800000E-05
   -2.33500000E-05  -2.54700000E-05  +4.85100000E-05  +4.76200000E-05  +2.98500000E-05
   -1.34200000E-05  -5.00000000E-07  +1.60800000E-05  -2.24900000E-05  -1.10100000E-05
   +7.47000000E-06  +1.11200000E-05  +4.26000000E-06  -7.05000000E-06  -5.87000000E-06
   -6.20000000E-06  +2.24000000E-06  -6.76700000E-05  -6.21500000E-05  -2.20900000E-05
   -1.17100000E-05  -5.62000000E-06  -6.11000000E-06  +1.34500000E-05  +1.87400000E-05
   +3.18700000E-05  +1.57660000E-04  -3.86400000E-05  +6.73800000E-05  -1.31620000E-04
   +1.64390000E-04  +3.53300000E-05  -3.99900000E-05  -1.03300000E-05  +2.92200000E-05
   -1.11760000E-04  +6.36400000E-05  -1.92200000E-05  -6.57000000E-06  +7.42700000E-05
   -8.09590000E-04  -4.04657000E-03  -7.27600000E-05  +1.67509000E-03  +3.90274000E-03
   +3.98885000E-03  -6.89391000E-03  +5.09220000E-04  -4.36660000E-04  +1.65264000E-03
   +6.26900000E-04  +6.05590000E-04  +5.95930000E-04  -1.48460000E-04  +5.70100000E-05
   -4.10100000E-05  +7.65060000E-04  +1.03780000E-04  +2.27600000E-05  +1.97357440E-01
   +1.72045040E-01  -2.10535690E-01  -3.72200000E-05  -1.23340000E-04  -1.03800000E-04
   +6.49000000E-06  -1.51500000E-05  +5.98000000E-06  +5.23000000E-06  -4.91000000E-06
   -6.92000000E-06  -1.46000000E-05  +1.98400000E-05  +1.16000000E-06  +3.44000000E-06
   -2.87100000E-05  -1.21400000E-05  -2.84900000E-05  +2.66500000E-05  +4.43000000E-05
   +1.27800000E-05  -6.40000000E-07  -1.16100000E-05  -1.98743600E-01  -1.76438520E-01
   +2.14292460E-01  +5.33490000E-04  +2.11600000E-05  -5.24350000E-04  -1.00952000E-03
   -3.12900000E-05  +3.96550000E-04  +3.49955000E-03  +3.40406000E-03  +2.16110000E-04
   -2.75778300E-02  -4.87964000E-03  +2.87155300E-02  -1.93538000E-03  -4.56347000E-03
   -3.00353000E-03  +1.67750000E-04  -8.39900000E-05  +1.99873000E-03  +1.54690000E-04
   +1.88570000E-04  +8.57400000E-05  +1.00240000E-04  -8.92520000E-04  -1.11493000E-03
   -2.15810000E-01  -5.00851500E-02  +2.25456570E-01  +5.80500000E-05  +2.78420000E-04
   -2.89160000E-04  -2.89550000E-04  -1.42140000E-04  -1.88940000E-04  -1.48050000E-04
   -8.04700000E-05  -1.58520000E-04  +1.90200000E-05  +1.37350000E-04  +4.10500000E-05
   +1.31390000E-04  +5.33100000E-05  +5.76800000E-05  +6.10400000E-05  +2.05400000E-05
   -2.16000000E-05  +3.19000000E-06  -2.12400000E-05  +2.65800000E-05  +4.97900000E-05
   -5.17400000E-05  -5.89000000E-06  -1.57370000E-04  +9.86800000E-05  +1.33700000E-05
   +1.22400000E-05  +3.32900000E-05  -6.91000000E-06  +2.81200000E-05  -3.63900000E-05
   +3.35700000E-05  -9.79000000E-06  +7.26000000E-06  +4.21000000E-06  +1.74900000E-05
   +8.70000000E-07  -1.37700000E-05  +1.80160000E-04  -8.29900000E-05  -3.81000000E-05
   -3.63900000E-05  +1.53700000E-05  -3.87800000E-05  +2.98200000E-05  +7.51400000E-05
   -2.83900000E-05  -5.71000000E-06  -1.48200000E-05  -1.05000000E-06  -3.68000000E-06
   -3.30500000E-05  +1.45100000E-05  +3.99800000E-05  +2.84600000E-05  +5.70000000E-06
   -2.22000000E-06  -3.37200000E-05  -1.16200000E-05  -3.06900000E-05  -1.58000000E-06
   -1.45200000E-05  -3.27300000E-05  +5.06000000E-06  +1.05700000E-05  +2.41962890E-01
   +3.49560000E-04  +2.46600000E-05  -5.64910000E-04  -1.92490000E-04  -7.14540000E-04
   +2.58450000E-04  +9.50280000E-04  +6.95950000E-04  +1.84792000E-03  -2.27259000E-02
   -7.09657000E-03  +2.57495800E-02  -3.89858000E-03  -2.09119000E-03  -2.78191000E-03
   -8.46520000E-04  +1.45917000E-03  +8.92260000E-04  +9.68500000E-05  +5.84400000E-05
   +5.88500000E-05  +2.07830000E-04  -5.10900000E-05  -1.60001000E-03  -3.08627200E-02
   -2.47978600E-02  +4.25627000E-03  +2.48920000E-04  -2.71540000E-04  +1.44300000E-04
   -8.92000000E-05  -3.17990000E-04  -3.47900000E-05  -4.68700000E-05  -8.16100000E-05
   -9.98900000E-05  -3.48200000E-05  +8.22600000E-05  +8.76000000E-06  +5.90500000E-05
   +3.55200000E-05  +3.10500000E-05  +4.47500000E-05  +3.28600000E-05  +3.12000000E-06
   +1.54200000E-05  -2.73000000E-05  +1.09000000E-05  +2.44600000E-05  -3.45400000E-05
   +5.56000000E-06  -1.13200000E-04  +7.45700000E-05  +1.11400000E-05  +2.03800000E-05
   +5.57000000E-06  -1.20700000E-05  +2.64700000E-05  -1.80300000E-05  +4.79000000E-06
   -1.55700000E-05  -1.44000000E-06  +7.72000000E-06  +1.19100000E-05  -4.10000000E-07
   -7.55000000E-06  +1.32900000E-04  -7.11400000E-05  -2.69500000E-05  -2.69700000E-05
   +3.73100000E-05  -1.43900000E-05  +1.96300000E-05  +4.59400000E-05  +4.53000000E-06
   -1.32500000E-05  -1.26900000E-05  +1.12400000E-05  -4.70000000E-07  -3.17400000E-05
   -7.34000000E-06  +2.83100000E-05  +2.55300000E-05  +1.02000000E-06  +7.84000000E-06
   -3.98500000E-05  -1.70600000E-05  -2.40300000E-05  +3.19000000E-06  -5.37000000E-06
   -2.06300000E-05  +7.26000000E-06  +7.89000000E-06  +5.66666600E-02  +3.30713000E-02
   -4.21600000E-05  -1.20450000E-04  -2.85870000E-04  +1.03680000E-04  +2.93800000E-05
   -8.00520000E-04  -4.87229000E-03  -1.94119000E-03  +2.61877000E-03  -8.45325000E-03
   -2.03015000E-03  +6.41681000E-03  -1.83550000E-03  -1.88148000E-03  +1.13165000E-03
   +5.00620000E-04  -1.96430000E-04  +4.30180000E-04  -9.86600000E-05  -7.51300000E-05
   -4.90300000E-05  +1.16132000E-03  +1.07200000E-04  -1.03675000E-03  +2.65623580E-01
   +3.42157500E-02  -3.45760850E-01  -3.68100000E-04  +8.35500000E-05  +1.85310000E-04
   -9.86700000E-05  +2.63000000E-05  -7.50000000E-06  +1.32440000E-04  +1.82800000E-05
   +1.25300000E-05  +4.92000000E-06  -1.96600000E-05  -2.66800000E-05  -7.91400000E-05
   -4.88100000E-05  -5.25300000E-05  -2.06800000E-05  -1.84000000E-06  +3.46000000E-05
   -1.21700000E-05  +5.85000000E-06  -2.24000000E-06  -3.55000000E-06  +7.46000000E-06
   -8.40000000E-07  +8.60000000E-06  -1.18200000E-05  +2.94000000E-06  -6.02000000E-06
   +1.22000000E-06  -2.74000000E-06  -2.15500000E-05  +4.38000000E-06  +9.18000000E-06
   +3.86000000E-06  +1.13000000E-06  -3.75000000E-06  -9.80000000E-07  +2.05000000E-06
   +2.43000000E-06  -1.72300000E-05  +1.04800000E-05  +1.04000000E-06  +1.08700000E-05
   -1.78900000E-05  +1.29200000E-05  -1.12600000E-05  -3.57900000E-05  +2.42800000E-05
   +4.70000000E-06  +3.20000000E-06  -1.96000000E-06  -3.90000000E-06  +1.67700000E-05
   +3.44000000E-06  +6.41000000E-06  -7.93000000E-06  -1.41000000E-05  +9.18000000E-06
   -1.45000000E-05  +4.84000000E-06  -1.09400000E-05  +1.30400000E-05  -4.44000000E-06
   +2.31000000E-06  +1.30000000E-07  +1.17000000E-06  -2.51616420E-01  -2.81431000E-02
   +3.37157730E-01
end_hess

