# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -731.03376190    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.67776002E+00  -6.04055361E-01  -1.70251024E+00
   006   -2.36249606E+00  +1.04169847E+00  +3.39700662E-01
   006   -4.34597078E+00  +1.03440274E+00  +2.00562734E+00
   006   -6.51379597E+00  -3.63752462E-01  +1.88726225E+00
   006   -6.75047192E+00  -1.97585670E+00  -1.81338100E-01
   006   -4.82023771E+00  -2.08214946E+00  -1.96760879E+00
   006   -5.08580775E-02  +2.75057426E+00  +5.86601863E-01
   006   -3.62729657E-01  +4.92877681E+00  -1.30417362E+00
   008   -8.88002526E+00  -3.39444331E+00  -3.56441463E-01
   006   +2.35536553E+00  +1.21952434E+00  +1.17448987E-01
   006   +2.76440926E+00  -9.94724079E-01  +1.48208465E+00
   006   +4.93256792E+00  -2.41866764E+00  +1.17613208E+00
   006   +6.77418913E+00  -1.65160744E+00  -5.33954924E-01
   006   +6.40683715E+00  +5.38772596E-01  -1.91743659E+00
   006   +4.21992070E+00  +1.94476571E+00  -1.58358924E+00
   008   +8.94152359E+00  -2.97445192E+00  -9.21081727E-01
   006   +7.37342851E-02  +3.88127368E+00  +3.25717659E+00
   001   +8.96327817E+00  -4.43148805E+00  +1.49089817E-01
   001   +5.19092996E+00  -4.13601705E+00  +2.26342408E+00
   001   +1.33978569E+00  -1.64061328E+00  +2.80191416E+00
   001   +3.99327465E+00  +3.64210378E+00  -2.69671974E+00
   001   +7.83862080E+00  +1.12744857E+00  -3.25130021E+00
   001   +1.72465208E+00  +5.10279738E+00  +3.42587841E+00
   001   -1.61336597E+00  +4.99937491E+00  +3.65275700E+00
   001   +2.14356167E-01  +2.40956627E+00  +4.69041621E+00
   001   -4.04207734E-01  +4.24796103E+00  -3.24868854E+00
   001   -2.14101681E+00  +5.90077875E+00  -9.37434553E-01
   001   +1.16158074E+00  +6.30495184E+00  -1.12041715E+00
   001   -7.99503896E+00  -2.65367650E-01  +3.29293510E+00
   001   -4.99064508E+00  -3.34121927E+00  -3.57398822E+00
   001   -1.18899519E+00  -7.44668999E-01  -3.10283000E+00
   001   -8.81496633E+00  -4.40895676E+00  -1.85210026E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -9.01000000E-06  -1.13400000E-05  +9.86000000E-06
   +1.19200000E-05  +4.94000000E-06  +7.92000000E-06
   +3.90000000E-07  +7.21000000E-06  +2.31000000E-06
   +4.16000000E-06  +9.63000000E-06  +6.07000000E-06
   -6.20000000E-07  -1.22500000E-05  -1.63000000E-05
   -5.78000000E-06  +6.90000000E-07  -8.45000000E-06
   +1.68000000E-06  +5.31000000E-06  +6.24000000E-06
   -4.00000000E-06  -3.81000000E-06  -1.43000000E-06
   +8.40000000E-07  +1.31000000E-06  -2.21000000E-06
   -6.18000000E-06  -5.08000000E-06  -2.51000000E-06
   +1.43000000E-06  -6.00000000E-07  +6.50000000E-07
   -9.60000000E-07  +8.40000000E-07  +4.00000000E-08
   +1.53000000E-06  +7.70000000E-07  -1.90000000E-07
   +2.00000000E-07  -2.30000000E-07  +2.48000000E-06
   +1.49000000E-06  -4.40000000E-07  +1.28000000E-06
   -9.40000000E-07  +6.10000000E-07  +1.70000000E-06
   +1.61000000E-06  +2.41000000E-06  +9.60000000E-07
   +1.00000000E-08  -1.00000000E-07  +1.40000000E-07
   -3.70000000E-07  +2.00000000E-08  +1.60000000E-07
   -7.60000000E-07  -9.80000000E-07  -2.00000000E-08
   +2.37000000E-06  -1.37000000E-06  +1.56000000E-06
   +8.10000000E-07  +6.60000000E-07  +1.41000000E-06
   -9.60000000E-07  -1.02000000E-06  +2.71000000E-06
   -3.80000000E-07  -9.30000000E-07  +7.10000000E-07
   -6.60000000E-07  -1.90000000E-06  +4.80000000E-07
   +5.80000000E-07  -1.09000000E-06  +9.70000000E-07
   +3.50000000E-07  -1.40000000E-07  +4.20000000E-07
   -5.13000000E-06  +1.62000000E-06  +1.61000000E-06
   -1.80000000E-07  -3.20000000E-07  -3.09000000E-06
   -6.20000000E-07  -1.61000000E-06  -3.61000000E-06
   +6.05000000E-06  +7.01000000E-06  -8.91000000E-06
   +1.11000000E-06  +1.80000000E-07  -2.95000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.15480160E-01  +1.73875810E-01  +3.84422460E-01  -1.52433110E-01  +1.94506520E-01
   +5.34736240E-01  -1.11671730E-01  -5.16977400E-02  -3.54307500E-02  +5.51586790E-01
   -9.16804000E-03  -1.64324620E-01  -1.25080160E-01  +1.45021440E-01  +3.78158290E-01
   +2.62370200E-02  -8.84841400E-02  -2.13031440E-01  -1.27342500E-01  +1.55232820E-01
   +4.93229640E-01  +3.53151700E-02  +5.48355000E-02  +5.96944600E-02  -2.35272850E-01
   -2.87986300E-02  +1.15081720E-01  +5.67063600E-01  +2.09908400E-02  +2.02067700E-02
   -7.55781000E-03  -1.12836000E-02  -7.58046400E-02  -2.05687500E-02  +1.87954140E-01
   +2.37773260E-01  +1.21355200E-02  -3.60656100E-02  -4.70697400E-02  +1.38510680E-01
   -7.61755000E-03  -1.81279550E-01  -1.55178190E-01  +6.58898300E-02  +3.00404570E-01
   -1.94345200E-02  -2.59945500E-02  -2.05191600E-02  -4.35001700E-02  -3.63725000E-03
   +3.64894500E-02  -2.79406050E-01  -1.43121270E-01  -3.14398000E-03  +6.25596540E-01
   -2.65075200E-02  -3.37976600E-02  -2.53535900E-02  -2.15475000E-02  +2.32266200E-02
   +4.29271800E-02  -1.27454590E-01  -1.47236780E-01  -2.86471700E-02  +1.83268860E-01
   +3.58055990E-01  -2.09585200E-02  -2.51019600E-02  -1.83091700E-02  +1.06219100E-02
   +2.86515600E-02  +3.52271200E-02  +1.79157000E-02  -1.66001200E-02  -8.60259400E-02
   -1.75440540E-01  +1.81628960E-01  +5.23634370E-01  -5.13590500E-02  -2.93232000E-02
   +3.60943000E-03  -6.00971000E-03  +1.75222300E-02  +2.92196500E-02  +1.68643500E-02
   -1.77676100E-02  -3.10008600E-02  -1.08755190E-01  -3.65370700E-02  -1.84076500E-02
   +5.89081530E-01  +1.72917000E-03  +2.52913400E-02  +3.10469400E-02  +1.60808200E-02
   -1.14704300E-02  -2.59222600E-02  -5.33487900E-02  -2.75510300E-02  -6.59977000E-03
   +8.75213000E-03  -1.54972770E-01  -1.26963320E-01  +1.77344280E-01  +4.15984440E-01
   +4.74339300E-02  +5.67308200E-02  +4.22795200E-02  +2.59768300E-02  -2.73106700E-02
   -6.37091800E-02  -8.18444200E-02  -3.61344800E-02  +2.61937900E-02  +4.53691100E-02
   -8.81436700E-02  -2.33389210E-01  -1.17589020E-01  +2.11303280E-01  +5.55629570E-01
   -2.65378730E-01  -1.07199340E-01  +2.33852900E-02  +2.16915300E-02  -3.83884200E-02
   -6.81192900E-02  -6.35039100E-02  -1.82953800E-02  +2.32864800E-02  +3.75156600E-02
   +4.54648900E-02  +3.93529300E-02  -2.05270620E-01  -3.06976700E-02  +7.33591800E-02
   +5.79562830E-01  -1.43598390E-01  -1.62745220E-01  -2.25175100E-02  -1.04313700E-02
   -2.21982200E-02  -3.37149300E-02  -2.04079100E-02  -1.07330200E-02  +7.37320000E-03
   +1.99772200E-02  +1.62321300E-02  -6.67420000E-03  +1.26553900E-02  -1.01040840E-01
   -5.52270000E-02  +1.93555900E-01  +4.16323920E-01  -2.78215300E-02  -5.31502100E-02
   -1.11588680E-01  -2.59425400E-02  -9.70051000E-03  +1.80978300E-02  +2.15008000E-02
   +6.12118000E-03  -1.33497300E-02  +3.68154000E-03  -2.82276500E-02  -3.38717600E-02
   +1.33221890E-01  -1.85888200E-02  -2.08381210E-01  -1.12776980E-01  +2.43175620E-01
   +5.59859800E-01  -1.85048000E-03  -7.18138000E-03  -5.93091000E-03  -1.35079570E-01
   -4.74670400E-02  -3.98816000E-03  -2.36421100E-02  -1.15758800E-02  +4.32324000E-03
   +5.05400000E-04  -1.55392000E-03  +2.07191000E-03  -2.39430000E-03  -6.93000000E-05
   +1.43096000E-03  +4.03990000E-03  +2.87000000E-04  +1.34498000E-03  +4.79772990E-01
   -1.67230800E-02  -1.08805900E-02  -4.34034000E-03  -4.63572700E-02  -1.06744460E-01
   -1.31912300E-02  -3.75303000E-03  +1.52872000E-03  +7.38814000E-03  +9.04930000E-04
   +3.04317000E-03  -3.87432000E-03  -6.37010000E-04  -6.75620000E-04  -2.29430000E-04
   -8.83300000E-05  +2.35996000E-03  -3.47983000E-03  -3.48968000E-03  +4.79950200E-01
   -2.09100100E-02  -1.48116000E-02  +2.15010000E-03  -4.13885000E-03  -1.24159600E-02
   -7.90656800E-02  +1.29459800E-02  +1.27109100E-02  +3.81700000E-03  +4.02728000E-03
   -1.39668000E-03  -8.90350000E-04  -3.08770000E-04  -9.46440000E-04  -1.29781000E-03
   +1.73959000E-03  -4.86551000E-03  -2.37255000E-03  -4.14292000E-03  -1.95644000E-03
   +4.78667060E-01  -4.16630000E-04  -1.15010000E-04  +6.12720000E-04  -1.72317000E-03
   -2.24192800E-02  +1.77326500E-02  +1.20510000E-04  -1.82572000E-03  -6.44640000E-04
   -1.05077000E-03  +1.79630000E-04  -8.24030000E-04  +8.76100000E-04  +5.44060000E-04
   +1.42150000E-04  -6.86370000E-04  +5.88640000E-04  +2.55350000E-04  -7.66286300E-02
   +5.74414000E-03  -4.13868000E-03  +5.85663880E-01  +1.05470000E-04  +4.04350000E-04
   +1.20298000E-03  -9.05955000E-03  -2.53407100E-02  +1.47440500E-02  +2.12929000E-03
   -1.03388000E-03  -9.03500000E-04  -6.14750000E-04  -1.87000000E-06  -6.69750000E-04
   +2.86760000E-04  +3.77810000E-04  +3.50060000E-04  -3.22980000E-04  +7.34970000E-04
   +1.84400000E-05  +1.13093200E-02  -1.30751340E-01  +5.04312000E-02  +1.11954700E-02
   +5.12802230E-01  -1.43284000E-03  -1.10047000E-03  -1.10350000E-04  +5.53015000E-03
   +3.77529000E-03  +1.25324000E-03  -4.53330000E-04  -2.28390000E-04  -7.69000000E-05
   -1.76690000E-04  -2.52370000E-04  -2.80790000E-04  +2.74800000E-04  +2.34140000E-04
   +2.94000000E-04  +4.58000000E-05  +1.36690000E-04  -1.42960000E-04  -7.86609000E-03
   +4.70545100E-02  -1.17789770E-01  -1.22253800E-02  +6.15578700E-02  +5.40310600E-01
   +3.80279000E-03  +2.14548000E-03  +5.87165000E-03  -2.56696000E-03  -1.93960000E-03
   -3.50240000E-03  +2.04050000E-04  -6.39660000E-04  +2.98392000E-03  -6.80767000E-03
   -1.55139200E-02  -9.15580000E-03  -2.39958740E-01  -1.01082650E-01  +2.57195000E-02
   -4.20909400E-02  -3.14962800E-02  +4.24100000E-05  +1.75963000E-03  +5.61020000E-04
   +7.91140000E-04  -1.37979000E-03  -4.78760000E-04  -6.28520000E-04  +3.26018070E-01
   -2.59866000E-03  +2.12262000E-03  -4.67756000E-03  -2.35887000E-03  +9.09400000E-05
   +2.77172000E-03  +2.17675000E-03  +2.45100000E-03  -5.26372000E-03  -3.54319000E-02
   -2.25092200E-02  -1.26502500E-02  -1.28568790E-01  -1.35269220E-01  -1.89016900E-02
   -1.07298000E-02  +2.34026000E-03  -1.05631000E-03  +1.28453000E-03  +4.29000000E-06
   +1.01919000E-03  -9.97930000E-04  -3.95640000E-04  -4.59290000E-04  +1.56890010E-01
   +3.24383140E-01  -6.98060000E-04  -8.56295000E-03  -4.45222000E-03  -2.37323000E-03
   +3.54574000E-03  +5.42970000E-03  +7.11379000E-03  -2.94255000E-03  -5.12475000E-03
   -3.72756500E-02  -2.97618300E-02  -2.00150000E-03  -1.32802200E-02  -4.27137700E-02
   -9.26539700E-02  +2.86103700E-02  +1.64910100E-02  +8.40275000E-03  -3.82000000E-05
   +3.11850000E-04  +2.24870000E-04  -2.34540000E-04  -1.14430000E-04  -1.63040000E-04
   -3.50152800E-02  +2.86831260E-01  +4.63748990E-01  -5.48840000E-04  +6.04150000E-04
   +1.02070000E-04  -3.56722900E-02  +7.09477000E-03  +6.94356000E-03  -1.04129000E-03
   -5.27600000E-05  -2.61255000E-03  -3.96230000E-04  -7.03480000E-04  +6.92740000E-04
   -2.41530000E-04  +1.71390000E-04  +4.21790000E-04  +4.07610000E-04  +6.51300000E-04
   +5.84920000E-04  -1.44824660E-01  +4.32271300E-02  +1.57782800E-02  -4.02892000E-03
   +7.71311000E-03  -2.88599000E-03  +7.75100000E-05  -4.61000000E-06  -2.65000000E-06
   +5.48552660E-01  -1.77129000E-03  -3.21160000E-04  -2.05340000E-04  -1.20250400E-02
   +1.23187300E-02  +4.88952000E-03  -1.96428000E-03  -1.88127000E-03  -1.33359000E-03
   -8.55630000E-04  -9.61240000E-04  +5.62430000E-04  +5.67760000E-04  +7.80410000E-04
   +4.25390000E-04  -1.15970000E-04  -1.25130000E-04  +5.80700000E-05  +4.10415600E-02
   -1.09135770E-01  +1.87254000E-03  +2.33269800E-02  -1.71920600E-02  -3.03407000E-03
   -9.01620000E-04  -7.26300000E-04  -1.99070000E-04  -8.94645100E-02  +5.19714930E-01
   -1.74090000E-03  -7.83180000E-04  +1.04600000E-05  +2.92287000E-03  +1.30556000E-03
   -4.32880000E-04  -3.20320000E-04  -2.11130000E-04  +2.85330000E-04  +1.59980000E-04
   +1.50990000E-04  +7.82600000E-05  +2.21260000E-04  -3.62800000E-05  -3.21070000E-04
   -4.82150000E-04  +1.66690000E-04  +1.73310000E-04  +1.83572500E-02  +1.12010000E-04
   -8.15886500E-02  -1.95204600E-02  +1.20415900E-02  +4.42672000E-03  -2.63110000E-04
   -2.39270000E-04  +6.77000000E-05  -1.64697700E-01  -1.85564910E-01  +4.23929380E-01
   -1.25677000E-03  +2.85890000E-04  -5.95720000E-04  -8.76920000E-04  +2.80554000E-03
   -9.85590000E-04  +6.65930000E-04  +5.24160000E-04  -5.60570000E-04  -2.91070000E-04
   -4.92270000E-04  -1.28910000E-04  -4.90600000E-05  +2.07510000E-04  +4.03200000E-04
   +3.70000000E-04  +2.19970000E-04  -1.45220000E-04  -5.57978000E-03  +2.46501800E-02
   -1.47096800E-02  -4.95703000E-03  +2.48416000E-03  +2.06989000E-03  -1.44270000E-04
   -1.67400000E-04  -2.88400000E-05  -1.20049640E-01  +1.00113900E-02  +2.44105300E-02
   +6.22320390E-01  -2.05700000E-04  -5.09150000E-04  -7.56130000E-04  -6.38870000E-04
   -6.54750000E-04  +6.22840000E-04  -1.39130000E-04  +5.52000000E-06  +1.65380000E-04
   -1.50530000E-04  -8.97900000E-05  +1.29860000E-04  -2.06510000E-04  -1.14900000E-04
   +4.77000000E-05  +4.89400000E-05  +1.98190000E-04  +1.97570000E-04  +1.03988200E-02
   -1.56788900E-02  +5.86733000E-03  +1.92426000E-03  +8.44300000E-05  -8.22440000E-04
   +1.00640000E-04  +8.10800000E-05  +7.31000000E-05  +6.07594700E-02  -2.44186030E-01
   +8.80693100E-02  -1.20960220E-01  +5.33850890E-01  -7.27150000E-04  +6.40040000E-04
   -1.16710000E-04  -2.58680000E-04  -2.30200000E-05  +1.99180000E-04  +4.46950000E-04
   +1.87520000E-04  -3.70320000E-04  -6.41600000E-05  -3.63400000E-05  -1.96240000E-04
   +1.15660000E-04  +1.40130000E-04  +2.46150000E-04  +2.23380000E-04  +2.18450000E-04
   -7.91600000E-05  -3.37110000E-03  -3.99105000E-03  +6.85503000E-03  +2.01504000E-03
   -5.80890000E-04  -3.73980000E-04  -9.06900000E-05  -5.78600000E-05  -5.06800000E-05
   -1.36809400E-02  +1.19309540E-01  -1.50081240E-01  -2.04684430E-01  -2.06684940E-01
   +4.19805630E-01  +3.99250000E-04  -1.01270000E-04  +2.15500000E-04  +3.64260000E-04
   -5.33700000E-05  -2.30230000E-04  -2.35760000E-04  -3.17550000E-04  +1.91350000E-04
   +1.41800000E-04  +1.92250000E-04  +7.09400000E-05  +2.71710000E-04  -3.61000000E-06
   -2.92470000E-04  -3.58570000E-04  -1.63520000E-04  +2.04540000E-04  +4.36292000E-03
   +1.26500000E-04  +9.12270000E-04  +2.28530000E-04  -2.84070000E-04  +3.74790000E-04
   -2.13440000E-04  -1.26820000E-04  -3.79000000E-06  +1.48534700E-02  +6.32872900E-02
   -5.17422200E-02  -2.73749580E-01  +9.40337600E-02  +6.43800100E-02  +5.83845090E-01
   -1.36670000E-04  +2.73290000E-04  -6.37500000E-05  -7.38150000E-04  +2.53600000E-05
   -3.05600000E-04  +2.92740000E-04  +2.88300000E-04  -2.34880000E-04  -4.38100000E-05
   -1.12580000E-04  -9.40200000E-05  +1.84400000E-04  +1.31620000E-04  +1.31020000E-04
   +5.73300000E-05  +1.57690000E-04  -1.30600000E-05  -3.31860000E-04  -1.31509000E-03
   +5.73286000E-03  +1.29866000E-03  -5.57210000E-04  -4.05230000E-04  -1.92730000E-04
   -1.33800000E-04  -3.33600000E-05  +2.34294200E-02  -2.82551400E-02  +1.19765900E-02
   +1.45819800E-01  -1.78068850E-01  -4.04710000E-03  -1.52814620E-01  +5.77898230E-01
   -2.42470000E-04  -8.36200000E-05  -1.97570000E-04  +4.28610000E-04  +5.98300000E-05
   -5.22900000E-05  +1.75440000E-04  +1.62720000E-04  -3.63000000E-06  -9.92000000E-05
   -1.11820000E-04  -3.38600000E-05  -2.31470000E-04  -4.92200000E-05  +1.60280000E-04
   +2.77340000E-04  +1.57470000E-04  -1.81550000E-04  +9.07760000E-04  +4.55007000E-03
   +6.90790000E-04  -6.61020000E-04  +4.72770000E-04  +1.85670000E-04  +2.00990000E-04
   +1.42870000E-04  +2.17000000E-05  -2.11907700E-02  -1.27190300E-02  +3.16146600E-02
   +2.65874200E-02  +2.81056000E-02  -9.67628500E-02  -1.73136380E-01  -2.34546610E-01
   +4.04995960E-01  -8.70900000E-05  +7.75800000E-05  +1.24590000E-04  +5.90400000E-05
   -4.30140000E-04  -8.57600000E-05  -5.00200000E-05  +1.36410000E-04  +9.54500000E-05
   +2.05080000E-04  +2.02850000E-04  +9.31800000E-05  -7.42070000E-04  -4.69350000E-04
   -4.00400000E-05  +3.47740000E-04  -7.07600000E-05  -2.99080000E-04  -2.40098000E-03
   +3.28100000E-04  +1.88860000E-04  +4.08850000E-04  +2.25010000E-04  -2.26860000E-04
   +8.66610000E-04  +6.12870000E-04  +1.07040000E-04  -5.78048000E-03  -2.25919600E-02
   +1.72417200E-02  -4.67408400E-02  +2.14939700E-02  +1.47740800E-02  -1.99944770E-01
   -5.85450100E-02  +1.24442410E-01  +5.93772670E-01  -2.50620000E-04  +5.98600000E-05
   -1.07160000E-04  -5.79070000E-04  +9.02490000E-04  +3.21690000E-04  +3.11530000E-04
   +2.28340000E-04  -3.98720000E-04  -3.08540000E-04  -4.41820000E-04  -1.87530000E-04
   +4.60860000E-04  +5.14380000E-04  +3.52820000E-04  +1.74000000E-05  +1.18770000E-04
   +6.28700000E-05  -4.03330000E-04  -1.23817000E-03  +1.02518000E-03  -2.41050000E-04
   +6.40900000E-05  +2.17800000E-05  -6.82000000E-04  -5.37480000E-04  -1.21940000E-04
   -2.09117300E-02  -4.01124600E-02  +3.83659900E-02  -2.23373900E-02  +5.75768500E-02
   -2.63412400E-02  +3.66338000E-03  -1.41017810E-01  +4.99631100E-02  -1.34416090E-01
   +5.75845500E-01  +3.49820000E-04  -1.59350000E-04  +8.85500000E-05  +4.68450000E-04
   -1.73990000E-04  -1.68100000E-04  -3.48870000E-04  -2.51670000E-04  +2.54050000E-04
   +1.67980000E-04  +2.27890000E-04  +1.15140000E-04  +1.17330000E-04  -9.75700000E-05
   -3.03360000E-04  -2.74610000E-04  -1.33070000E-04  +1.19740000E-04  +1.20064000E-03
   +3.81230000E-04  -1.31079000E-03  +1.43900000E-05  +1.26500000E-05  +3.07390000E-04
   -8.66000000E-06  +2.65800000E-05  +2.09600000E-05  +1.57321700E-02  +3.91164400E-02
   -4.47501300E-02  +4.68985400E-02  -5.33685300E-02  +1.25736000E-02  +7.93285200E-02
   +8.89690700E-02  -1.83654450E-01  -1.70629040E-01  -2.19538710E-01  +4.31461770E-01
   -2.66920000E-04  +2.04600000E-04  +4.63400000E-05  -3.77880000E-04  +5.49140000E-04
   +1.88610000E-04  +2.50280000E-04  +1.60710000E-04  -2.95550000E-04  -1.55430000E-04
   -2.38480000E-04  -1.21030000E-04  +1.59440000E-04  +2.24990000E-04  +2.59210000E-04
   +1.40880000E-04  +6.23400000E-05  -9.49800000E-05  +1.15457000E-03  -1.13814000E-03
   +3.93074000E-03  +1.21020000E-04  -5.37040000E-04  +7.56200000E-05  -2.53810000E-04
   -2.00270000E-04  -7.50700000E-05  -4.22545900E-02  -1.85909900E-02  +4.47099300E-02
   -2.40192500E-02  +3.32257100E-02  -1.13145900E-02  +4.19464400E-02  -2.14119500E-02
   -5.14896000E-03  -1.18470570E-01  -6.07287000E-03  +3.41511800E-02  +6.20396660E-01
   +4.77220000E-04  -1.76800000E-04  -1.23790000E-04  +1.00648000E-03  -6.31300000E-04
   -3.25520000E-04  -3.43410000E-04  -2.22390000E-04  +4.70110000E-04  +2.66180000E-04
   +3.73670000E-04  +1.63740000E-04  -1.98820000E-04  -3.77130000E-04  -3.60170000E-04
   -1.37990000E-04  -1.33440000E-04  +6.36600000E-05  -8.27300000E-05  +1.60965000E-03
   +3.31381000E-03  +5.65430000E-04  -5.79650000E-04  -9.61300000E-05  +4.04110000E-04
   +3.60900000E-04  +8.85700000E-05  +1.94737900E-02  +5.11575700E-02  -4.39718000E-02
   +3.08174700E-02  -5.01234500E-02  +1.55345200E-02  -5.70351200E-02  -1.86390000E-04
   +4.21307300E-02  +5.22947000E-02  -2.49873020E-01  +9.88017200E-02  -1.27973430E-01
   +5.41205420E-01  +3.73400000E-05  -1.15480000E-04  -2.41640000E-04  +9.40340000E-04
   -6.55300000E-04  -4.01060000E-04  +2.45940000E-04  +1.76950000E-04  +1.43530000E-04
   -2.17400000E-05  -6.60000000E-06  -1.00650000E-04  +1.47500000E-05  +3.38500000E-05
   +4.51400000E-05  +1.49900000E-05  +4.91900000E-05  +4.57400000E-05  +3.67303000E-03
   +4.57102000E-03  +1.75342000E-03  -6.11720000E-04  +5.29250000E-04  -5.53500000E-05
   -5.75400000E-05  -4.49000000E-05  +8.86000000E-06  +1.66617200E-02  -2.08089300E-02
   +1.17622100E-02  -9.58507000E-03  +1.39796200E-02  -7.46381000E-03  +2.10582700E-02
   +1.98108200E-02  -1.91351100E-02  -8.78131000E-03  +1.35433190E-01  -1.65737120E-01
   -2.13810330E-01  -2.23293760E-01  +4.28368690E-01  +7.91590000E-04  -4.72700000E-05
   +4.18980000E-04  -9.73990000E-04  +1.47953000E-03  +7.75570000E-04  -9.29740000E-04
   -6.34950000E-04  +1.05450000E-04  +1.59870000E-04  +1.62490000E-04  +3.06320000E-04
   +1.39700000E-04  -1.23430000E-04  -4.18530000E-04  -3.18090000E-04  -3.59500000E-04
   +1.05880000E-04  -1.77552300E-02  -3.60958000E-03  +1.50456400E-02  -1.35841000E-03
   -1.98260000E-04  +1.13362000E-03  +2.40200000E-05  +5.69600000E-05  +1.66200000E-05
   -2.16714100E-01  +3.02221000E-03  +9.16554100E-02  +4.27320100E-02  -6.28438000E-02
   +2.52504900E-02  -5.98060600E-02  +9.66984000E-03  +2.78314500E-02  +1.84561000E-02
   +6.76951400E-02  -6.01194900E-02  -2.68126540E-01  +8.77895300E-02  +6.54244800E-02
   +5.73673180E-01  -3.14980000E-04  +7.67600000E-05  +7.04300000E-05  +1.20292000E-03
   -2.18535000E-03  -1.16223000E-03  +6.18570000E-04  +5.25710000E-04  +1.08130000E-04
   +6.16700000E-05  +6.14900000E-05  -1.92450000E-04  -2.44260000E-04  -3.86000000E-05
   +1.15100000E-04  +2.48740000E-04  +2.09610000E-04  -7.20300000E-05  +1.08984800E-02
   +9.83750000E-03  -1.11462000E-02  +9.00870000E-04  -1.61350000E-04  -9.70680000E-04
   +2.12860000E-04  +1.27310000E-04  +4.17200000E-05  -4.79968600E-02  -1.29930430E-01
   +7.58496400E-02  -2.32033000E-02  -3.80320000E-03  +2.33091500E-02  +7.29402000E-03
   -4.06274000E-03  -4.22320000E-03  +2.38952000E-02  -3.06765400E-02  +9.22432000E-03
   +1.39427510E-01  -1.74419480E-01  -3.88341000E-03  -1.39334880E-01  +5.78674140E-01
   -6.51100000E-04  -5.85400000E-05  -4.67520000E-04  -2.46713000E-03  +1.76090000E-04
   +2.10380000E-04  +4.43690000E-04  +2.70830000E-04  -3.41740000E-04  -3.18600000E-04
   -3.76120000E-04  -6.58600000E-05  +5.45000000E-06  +2.48740000E-04  +3.36960000E-04
   +1.82870000E-04  +3.14410000E-04  +1.17610000E-04  +5.77404000E-03  -2.50281000E-03
   +4.76630000E-04  -5.10250000E-04  -7.15570000E-04  -3.00350000E-04  -2.73370000E-04
   -2.44360000E-04  -2.44400000E-05  +1.29145170E-01  +4.53758500E-02  -1.81104770E-01
   -3.56666000E-03  +4.76658900E-02  -2.42098700E-02  +2.89223200E-02  -5.51360000E-03
   -1.76111800E-02  -2.74649400E-02  -1.76117300E-02  +3.22554900E-02  +2.78916300E-02
   +2.78037100E-02  -9.87698700E-02  -1.67799050E-01  -2.33674970E-01  +4.21512590E-01
   -4.17900000E-05  +9.82000000E-06  -2.78000000E-06  -2.90430000E-04  +8.97580000E-04
   +1.44890000E-04  +1.78100000E-04  -8.23000000E-06  -3.39730000E-04  -2.98470000E-04
   -3.80210000E-04  -1.76280000E-04  +8.86810000E-04  +6.53470000E-04  +1.76220000E-04
   -3.51020000E-04  +5.37000000E-05  +2.85580000E-04  +1.78332000E-03  -9.01120000E-04
   +3.81430000E-04  -5.69470000E-04  -1.01040000E-04  +3.44250000E-04  -1.09986000E-03
   -8.13160000E-04  -1.55860000E-04  -2.54674000E-03  +2.91519000E-03  -2.14624000E-03
   +3.43590000E-03  -3.54322000E-03  +5.00072000E-03  -4.15025700E-02  +2.80161400E-02
   +1.14822200E-02  -2.43369260E-01  +8.34432000E-02  +6.41432800E-02  -1.03213200E-02
   +1.96325300E-02  -3.27166000E-03  +1.35442000E-03  -1.29894000E-03  +3.24025000E-03
   +3.29809870E-01  +7.22300000E-05  +1.50800000E-05  +8.18000000E-06  +2.55980000E-04
   -7.37710000E-04  -8.44000000E-05  -1.50560000E-04  -3.04800000E-05  +2.71250000E-04
   +2.25650000E-04  +3.14120000E-04  +1.38470000E-04  -5.79430000E-04  -4.73250000E-04
   -1.66400000E-04  +2.07760000E-04  -3.13700000E-05  -1.89330000E-04  -1.17656000E-03
   +5.34280000E-04  -9.22790000E-04  +3.70080000E-04  +3.35300000E-05  -2.11200000E-04
   +7.56480000E-04  +5.86910000E-04  +1.11350000E-04  +3.00947000E-03  +2.01949000E-03
   -3.82529000E-03  +2.86747000E-03  -2.89844000E-03  +5.60721000E-03  -1.56431000E-03
   +8.75437000E-03  +1.61781000E-03  +1.21273980E-01  -1.42466610E-01  -3.25526000E-03
   +4.84424700E-02  -3.12839700E-02  -1.72818000E-03  -6.28521000E-03  +5.37430000E-04
   +7.35638000E-03  -1.51391980E-01  +5.11582290E-01  +6.88000000E-06  -3.58500000E-05
   -4.77900000E-05  -2.10300000E-05  -1.13190000E-04  +1.13700000E-04  -2.14300000E-05
   -1.46800000E-05  +5.67100000E-05  +9.68000000E-06  +3.83100000E-05  +3.75700000E-05
   -1.37830000E-04  -8.80400000E-05  -1.52400000E-05  +6.80200000E-05  +4.91000000E-06
   -4.30700000E-05  -5.54520000E-04  -2.91010000E-04  -1.93560000E-04  +8.72000000E-05
   +4.20000000E-05  -8.65800000E-05  +1.60790000E-04  +1.21540000E-04  +3.14100000E-05
   -1.51753000E-03  -4.18619000E-03  +2.82480000E-03  +3.80510000E-04  +9.54339000E-03
   +1.96000000E-06  +3.29154400E-02  -1.69170400E-02  +1.36427000E-03  +3.59196100E-02
   +2.08022200E-02  -8.16209000E-02  -2.44534100E-02  +1.63269300E-02  +1.09601800E-02
   +7.04005000E-03  +4.28151000E-03  -2.29393000E-03  -7.86468700E-02  -2.64983050E-01
   +2.73381190E-01  -4.71511000E-03  -2.17077000E-03  +6.68610000E-04  -2.98157000E-03
   -1.33863900E-02  -2.80268000E-02  -6.76770000E-04  -1.71164000E-03  -1.78258000E-03
   +5.04900000E-05  -3.59480000E-04  -2.91100000E-04  +3.99050000E-04  +3.23040000E-04
   -7.65500000E-05  +2.95710000E-04  -1.08255000E-03  -7.93440000E-04  -7.58506900E-02
   -2.20260000E-04  -9.98140000E-04  +4.65110000E-04  -7.53540000E-04  -3.82768000E-03
   -5.65290000E-04  -3.43790000E-04  -3.54400000E-05  -2.69122000E-03  +1.25872400E-02
   +2.74860200E-02  -5.32460000E-04  +7.21840000E-04  +1.11355000E-03  -1.11130000E-04
   -7.40740000E-04  -4.01800000E-05  +6.53340000E-04  -8.80370000E-04  +3.42800000E-04
   -1.51693000E-03  -5.69000000E-06  -1.17754000E-03  -7.64670000E-04  +2.15180000E-03
   -3.60720000E-04  -1.29312000E-03  +9.66630000E-04  +1.20070000E-04  +5.85825350E-01
   -3.17475000E-03  -7.63310000E-04  +5.46150000E-04  -5.72650000E-03  -1.26042600E-02
   -2.32066600E-02  +2.64280000E-04  +5.94940000E-04  +1.05900000E-05  +3.94220000E-04
   -3.43700000E-04  -6.09000000E-04  +7.09000000E-06  +7.62100000E-05  +8.32700000E-05
   +1.61440000E-04  -6.53590000E-04  -7.23140000E-04  -4.11230000E-03  -9.02697200E-02
   -3.68864900E-02  +1.25980000E-03  +8.56343000E-03  +2.49614000E-02  -1.20390000E-04
   -1.08650000E-04  -6.09400000E-05  +5.36318000E-03  -1.01527000E-02  -1.85283000E-02
   +8.37550000E-04  -3.94230000E-04  -9.88290000E-04  -1.84660000E-04  +6.21830000E-04
   +2.04420000E-04  -1.74090000E-04  +6.08750000E-04  -4.41710000E-04  +7.36550000E-04
   -3.15700000E-04  +6.86190000E-04  -9.49670000E-04  -1.25268000E-03  +4.29330000E-04
   +5.06780000E-04  -4.30390000E-04  +4.80000000E-07  +7.23300000E-05  +5.65548960E-01
   +3.15220000E-04  +7.95220000E-04  +3.47370000E-04  -5.13555000E-03  -5.30859000E-03
   -6.18005000E-03  +9.98390000E-04  +6.51240000E-04  +8.19090000E-04  +4.12000000E-04
   -3.24000000E-06  -2.15620000E-04  -3.44990000E-04  +2.10000000E-07  +3.23890000E-04
   +4.94850000E-04  +1.26910000E-04  -7.75200000E-05  -7.79589000E-03  -3.41978800E-02
   -1.59242260E-01  -2.19939000E-03  -4.08779000E-03  -3.40674000E-02  +3.39890000E-04
   +2.31500000E-04  -4.46000000E-06  +9.62298000E-03  -9.30706000E-03  -9.27602000E-03
   -1.49949000E-03  +9.92010000E-04  -1.99040000E-04  +1.32410000E-04  +2.77670000E-04
   -1.42500000E-04  +2.06560000E-04  -7.76900000E-05  +1.20950000E-04  +1.52240000E-04
   +1.60820000E-04  +8.39300000E-05  -1.20650000E-03  -2.11740000E-04  +1.74130000E-04
   -4.10040000E-04  +2.83990000E-04  +1.68000000E-06  -4.59788000E-03  -4.95443700E-02
   +4.84992860E-01  -6.80000000E-06  -2.45100000E-05  +1.91700000E-05  -5.19000000E-06
   -4.04900000E-05  -5.26000000E-06  -3.13700000E-05  -1.21100000E-05  +2.55800000E-05
   +2.78500000E-05  +3.08500000E-05  +2.28700000E-05  -1.38890000E-04  -8.09100000E-05
   -8.97000000E-06  +4.81900000E-05  -2.29700000E-05  -3.46600000E-05  -1.95840000E-04
   -5.22000000E-05  +9.12400000E-05  +8.10100000E-05  -1.19300000E-05  -3.26200000E-05
   +1.48040000E-04  +9.17000000E-05  +1.97700000E-05  -1.60500000E-05  -5.61820000E-04
   +5.01790000E-04  -6.48570000E-04  +2.61540000E-04  -1.87390000E-04  +1.63825000E-03
   +7.56280000E-04  -2.11490000E-03  -5.46991000E-03  +3.67943700E-02  -2.56438200E-02
   -5.35496000E-03  +2.92024000E-03  +2.51546000E-03  +1.46251000E-03  +1.15476000E-03
   -6.40890000E-04  -3.63045800E-02  -1.45291600E-02  +3.16068700E-02  +5.28000000E-05
   +9.51000000E-06  -9.48000000E-06  +4.57989600E-02  +1.08000000E-06  +9.28000000E-06
   +8.29000000E-06  -3.73200000E-05  +1.17580000E-04  -4.20000000E-07  +2.98200000E-05
   +3.59000000E-06  -5.00800000E-05  -3.83600000E-05  -5.80000000E-05  -3.05900000E-05
   +1.33000000E-04  +1.02280000E-04  +3.04700000E-05  -5.02200000E-05  -9.10000000E-07
   +4.62000000E-05  +2.25320000E-04  -9.70000000E-05  +1.82000000E-05  -7.37500000E-05
   -1.07500000E-05  +2.96400000E-05  -1.62980000E-04  -1.31340000E-04  -2.37600000E-05
   -8.25900000E-05  +5.92260000E-04  -3.89270000E-04  -6.41000000E-06  -1.09900000E-03
   +3.24370000E-04  -4.22824000E-03  +4.09986000E-03  -1.01529000E-03  +1.22596000E-03
   -2.48892600E-02  +1.56477800E-02  +4.10039000E-03  +7.16680000E-04  -1.56274000E-03
   -2.76500000E-04  -2.70790000E-04  +1.63038000E-03  +2.39252300E-02  -3.47267860E-01
   +2.40788090E-01  -1.11600000E-04  +4.29700000E-05  -3.56500000E-05  -2.53430100E-02
   +3.67968420E-01  -1.86000000E-06  +1.54900000E-05  +2.86600000E-05  +1.84900000E-05
   -2.26000000E-05  -2.58200000E-05  -9.31000000E-06  -1.57000000E-06  -5.56000000E-06
   +1.40200000E-05  +7.76000000E-06  -7.90000000E-06  -8.24000000E-06  -3.78000000E-06
   +5.20000000E-06  +3.04000000E-06  -7.74000000E-06  -3.05000000E-06  -8.19100000E-05
   +5.36400000E-05  -1.38590000E-04  +1.81000000E-06  +6.10000000E-06  -9.63000000E-06
   +1.03100000E-05  +3.44000000E-06  -6.59000000E-06  +1.36770000E-04  -1.39500000E-05
   +9.68200000E-05  -2.43000000E-06  +1.79440000E-04  -7.73750000E-04  +1.57018000E-03
   -4.13944000E-03  +1.15418000E-03  +9.02200000E-04  -6.92592000E-03  +1.84042000E-03
   +1.65596000E-03  -8.06630000E-04  +1.63294000E-03  +3.90690000E-04  +7.39600000E-04
   +9.42370000E-04  +2.90176000E-03  +2.65172600E-01  -2.02600270E-01  +1.02090000E-04
   -6.20000000E-05  +3.26200000E-05  -7.52005000E-03  -2.54740310E-01  +1.98454640E-01
   -2.56000000E-06  +5.44000000E-06  +2.41400000E-05  +1.02710000E-04  +6.03000000E-05
   +3.12000000E-06  +1.96600000E-05  -7.64000000E-06  -2.95700000E-05  -2.77900000E-05
   -4.92000000E-05  -1.11700000E-05  +4.72700000E-05  +4.51600000E-05  +1.58700000E-05
   -2.68200000E-05  -4.10200000E-05  +2.51600000E-05  +5.44320000E-04  +9.13870000E-04
   -7.90280000E-04  -3.99770000E-04  +9.47700000E-05  +1.57740000E-04  -7.68200000E-05
   -7.55500000E-05  -8.22000000E-06  -2.53031000E-03  +4.08410000E-03  +3.32565000E-03
   +1.36567000E-03  +2.25337400E-02  -1.55941000E-02  -5.87960900E-02  +3.27545500E-02
   -8.09090000E-03  +5.93044000E-03  -1.75685100E-02  +1.15789200E-02  -1.75675000E-03
   -3.38850000E-04  +4.72097000E-03  -1.57119000E-03  +9.77100000E-05  +3.37840000E-04
   +1.86225000E-03  -2.39745000E-03  -1.78295000E-03  +1.51000000E-06  -4.47600000E-05
   -1.24370000E-04  -7.02070000E-04  +1.01108000E-03  +2.89600000E-05  +5.60018100E-02
   -2.78500000E-05  +1.85200000E-05  +8.30000000E-07  -1.36490000E-04  -1.32330000E-04
   -2.92400000E-05  +1.42000000E-06  +1.60900000E-05  +1.60400000E-05  +2.48100000E-05
   +2.99000000E-05  +3.04000000E-06  -9.10300000E-05  -5.33100000E-05  +3.58000000E-06
   +4.86100000E-05  +5.13000000E-06  -2.78500000E-05  -2.67110000E-04  -2.85680000E-04
   +7.52710000E-04  +2.95040000E-04  -1.25590000E-04  -1.64550000E-04  +1.05320000E-04
   +7.84200000E-05  +9.07000000E-06  +4.45584000E-03  +2.22738000E-03  +1.01016000E-03
   -1.33830000E-04  -1.09619900E-02  +9.95655000E-03  +3.29408200E-02  -2.44621210E-01
   +1.33186430E-01  +6.58756000E-03  -6.50836000E-03  +3.56173000E-03  -8.07280000E-04
   +2.39492000E-03  +2.69519000E-03  -2.31180000E-04  +2.31010000E-04  -6.73840000E-04
   -1.88064000E-03  +1.50153000E-03  -2.71303000E-03  +7.46200000E-05  -1.12800000E-05
   +1.84300000E-05  -1.22206000E-03  -3.80000000E-07  +1.16416000E-03  -3.85906100E-02
   +2.57606650E-01  -3.02700000E-05  +4.20700000E-05  +2.83600000E-05  -1.13040000E-04
   -2.13000000E-05  -1.01400000E-05  +4.15700000E-05  +2.31600000E-05  -5.55200000E-05
   -1.74300000E-05  -3.80900000E-05  -3.07700000E-05  +2.07100000E-05  +4.06400000E-05
   +4.34900000E-05  +5.42000000E-06  -2.21100000E-05  +1.65300000E-05  +3.00000000E-04
   +2.22200000E-05  +2.96380000E-04  +1.26100000E-05  -7.85500000E-05  -2.53500000E-05
   -4.75900000E-05  -4.87500000E-05  -1.47400000E-05  +2.82575000E-03  +1.51638000E-03
   +4.64865000E-03  +9.50880000E-04  -4.31074000E-03  +5.15715000E-03  -8.34309000E-03
   +1.33189240E-01  -1.25030750E-01  -5.84800000E-03  +1.86637100E-02  -5.89761000E-03
   +5.10166000E-03  +2.36003000E-03  +4.86290000E-04  +5.06800000E-04  -8.87760000E-04
   -5.48550000E-04  -2.24451000E-03  -2.37576000E-03  -7.21280000E-04  -2.56900000E-05
   +2.41000000E-06  -5.42100000E-05  +1.65705000E-03  -2.09270000E-04  -2.94510000E-04
   +7.67262000E-03  -1.46503640E-01  +1.24946810E-01  -4.09220000E-04  +9.55800000E-05
   -3.39870000E-04  -6.97720000E-04  +6.46860000E-04  -3.13320000E-04  +7.07000000E-05
   -8.39000000E-06  -1.97000000E-06  -1.44390000E-04  -9.87400000E-05  -1.24600000E-05
   -2.63710000E-04  -6.47500000E-05  +1.60580000E-04  +3.01440000E-04  +1.01000000E-04
   -7.37200000E-05  -7.90700000E-04  -2.93630000E-04  -1.01878000E-03  -2.26000000E-06
   -1.24410000E-04  -9.51400000E-05  +1.83470000E-04  +1.26140000E-04  +1.06000000E-05
   +6.57132000E-03  +1.42963000E-03  -2.52441000E-03  -1.89884190E-01  -5.66386200E-02
   +1.31629880E-01  -1.36498200E-02  -9.55296000E-03  +1.77846000E-02  -8.89620000E-04
   +5.10530000E-03  +1.66316000E-03  -3.23330000E-04  +3.84070000E-04  -8.30250000E-04
   +2.08117000E-03  +2.30336000E-03  +8.67930000E-04  -1.38308000E-03  -2.15220000E-04
   +9.30200000E-04  -6.35200000E-05  +1.80230000E-04  +1.48410000E-04  +1.29680000E-04
   -2.31440000E-04  +8.31600000E-05  -1.32120000E-04  -1.06865000E-03  -1.83455000E-03
   +1.98894440E-01  +2.02190000E-04  +3.55350000E-04  +3.32510000E-04  +4.18420000E-04
   -1.03340000E-04  +2.10300000E-05  +1.34390000E-04  +1.15400000E-05  -6.31400000E-05
   +8.16300000E-05  +5.60000000E-06  -2.90300000E-05  +2.37570000E-04  +6.23200000E-05
   -1.06160000E-04  -2.42150000E-04  -2.21610000E-04  +8.44800000E-05  -1.57425000E-03
   -3.66580000E-04  -9.76850000E-04  -7.91300000E-05  +1.45800000E-05  -1.08370000E-04
   -2.30190000E-04  -1.77480000E-04  -3.89100000E-05  -1.97031900E-02  -2.44101000E-03
   +1.67975000E-02  -5.68966300E-02  -8.33055000E-02  +6.57283700E-02  +1.34618400E-02
   +8.88062000E-03  -1.16734900E-02  +4.77589000E-03  +4.69550000E-04  +2.44382000E-03
   +4.59020000E-04  -8.99610000E-04  -4.68570000E-04  +2.82609000E-03  -2.75115000E-03
   +4.92747000E-03  +7.71350000E-04  +2.00870000E-04  -6.99320000E-04  +2.07270000E-04
   -6.51280000E-04  +3.65800000E-04  -6.82200000E-05  +1.05880000E-04  -5.73400000E-05
   -1.49408000E-03  -5.81180000E-04  -1.91497000E-03  +5.76769000E-02  +8.20487800E-02
   +1.42580000E-04  -2.36610000E-04  -1.29760000E-04  -1.69900000E-04  +1.91290000E-04
   +2.92530000E-04  -4.32980000E-04  -2.94670000E-04  +2.02020000E-04  +7.81400000E-05
   +1.64270000E-04  +1.24260000E-04  -2.44310000E-04  -1.41580000E-04  -1.24310000E-04
   -6.57600000E-05  -1.98890000E-04  -1.78300000E-05  -1.04800000E-04  -1.69937000E-03
   -1.88244000E-03  -2.48240000E-04  -2.68500000E-05  -4.87900000E-05  +2.76160000E-04
   +1.83630000E-04  +4.25900000E-05  +1.24882700E-02  +4.32523000E-03  -6.29459000E-03
   +1.30981330E-01  +6.48788800E-02  -1.65041120E-01  +1.63809000E-03  +2.45848000E-03
   +1.29781000E-03  +2.00000000E-03  +2.10005000E-03  +5.35375000E-03  -1.01554000E-03
   -3.32220000E-04  -3.45000000E-04  +8.28390000E-04  +5.39947000E-03  +2.13205000E-03
   +3.20170000E-04  -8.57900000E-05  -1.95670000E-04  +7.07600000E-05  -1.87250000E-04
   +3.52300000E-05  -5.65600000E-05  +5.52800000E-05  -3.94300000E-05  -1.64213000E-03
   -2.21152000E-03  -2.00448000E-03  -1.45571460E-01  -7.37881600E-02  +1.67639440E-01
   -2.56200000E-05  +7.03700000E-05  +7.12600000E-05  -1.83610000E-04  +1.09730000E-04
   -1.17840000E-04  -4.52900000E-05  +1.11100000E-05  -2.25100000E-05  +4.15500000E-05
   +2.18700000E-05  +3.12900000E-05  -6.76600000E-05  -5.83600000E-05  -7.70000000E-06
   +1.78400000E-05  +1.30800000E-05  -5.11400000E-05  -9.34300000E-05  -1.11080000E-03
   -1.51870000E-03  -2.72445000E-03  +1.04444000E-03  +1.31721000E-03  +9.37300000E-05
   +6.97000000E-05  +8.58000000E-06  +8.25543000E-03  -1.80136300E-02  +1.08771500E-02
   -1.79379000E-03  -1.22330000E-04  +5.35687000E-03  -1.31846000E-03  -2.76700000E-05
   +1.63080000E-04  -2.14556000E-03  +3.98433000E-03  +3.41726000E-03  +7.00120000E-04
   +2.30086800E-02  -1.48410900E-02  -5.92039600E-02  +3.04425700E-02  -1.01005600E-02
   -7.17700000E-05  +1.20724000E-03  -8.28080000E-04  +3.41850000E-04  +4.49600000E-05
   -8.71700000E-05  -3.53630000E-04  +1.97520000E-04  -4.28900000E-05  -8.94000000E-05
   -1.74410000E-04  -2.71050000E-04  +2.67240000E-04  -1.06041000E-03  +6.57390000E-04
   +6.12112700E-02  -8.11900000E-05  +7.67500000E-05  +1.15590000E-04  -2.72910000E-04
   +2.56600000E-04  +2.33630000E-04  -4.99600000E-05  -4.95400000E-05  -9.15600000E-05
   -1.95600000E-05  -2.48100000E-05  +3.03000000E-06  +2.73600000E-05  +3.26200000E-05
   +2.42300000E-05  -4.84000000E-06  -5.34000000E-06  -5.02300000E-05  -1.71720000E-04
   -1.97621000E-03  -1.33605000E-03  +2.65277000E-03  -5.92850000E-04  -6.26490000E-04
   -3.21000000E-05  -2.99100000E-05  -1.80600000E-05  +1.75541000E-03  -3.62753000E-03
   +4.90325000E-03  -2.15570000E-04  +2.48630000E-03  +3.24643000E-03  -1.43310000E-04
   +2.03830000E-04  -8.67610000E-04  +4.08427000E-03  +2.50736000E-03  +1.48187000E-03
   +4.19630000E-04  -1.02881700E-02  +1.02004000E-02  +3.00626500E-02  -2.48899020E-01
   +1.36276090E-01  +2.47350000E-04  -9.01560000E-04  +5.56460000E-04  +3.06510000E-04
   -1.25010000E-04  -1.11910000E-04  +1.13210000E-04  -1.42180000E-04  -1.03830000E-04
   -1.39620000E-04  -2.74990000E-04  -2.44400000E-04  +1.86990000E-04  -3.04300000E-04
   +1.25390000E-04  -3.95111000E-02  +2.63155050E-01  -1.13800000E-05  +2.76700000E-05
   +1.13140000E-04  -2.68590000E-04  +1.17160000E-04  +2.32500000E-04  -5.35600000E-05
   -8.00400000E-05  -4.78300000E-05  -8.49000000E-06  -1.85600000E-05  -1.04000000E-06
   +3.72200000E-05  +3.69200000E-05  -3.72000000E-06  -3.04000000E-05  -3.24800000E-05
   -5.34000000E-06  -2.36243000E-03  -6.34890000E-04  -1.94688000E-03  +2.32760000E-04
   +5.72970000E-04  +4.06740000E-04  -5.02900000E-05  -4.92500000E-05  -1.33100000E-05
   -3.82896000E-03  +1.72696600E-02  -5.96979000E-03  +5.40946000E-03  +3.03122000E-03
   +1.07925000E-03  +2.52960000E-04  -9.39510000E-04  -5.61730000E-04  +3.31125000E-03
   +1.53140000E-03  +4.74323000E-03  +1.74530000E-03  -3.86122000E-03  +5.71661000E-03
   -9.70133000E-03  +1.36228530E-01  -1.33952200E-01  -1.09810000E-04  -5.01600000E-05
   +1.59310000E-04  +6.99890000E-04  -1.72920000E-04  -5.23200000E-05  +1.79600000E-05
   -1.56060000E-04  -8.58500000E-05  -2.93500000E-04  -2.16590000E-04  -3.76550000E-04
   -2.28730000E-04  +9.02620000E-04  -4.98700000E-04  +7.52992000E-03  -1.50030730E-01
   +1.33131190E-01  -7.96000000E-06  +9.59000000E-06  +2.98800000E-05  -1.73300000E-05
   +2.02520000E-04  +9.17100000E-05  -4.16100000E-05  -5.15500000E-05  -3.68700000E-05
   -1.78900000E-05  -2.27900000E-05  +1.17000000E-06  +6.67800000E-05  +3.88100000E-05
   +2.19000000E-06  -4.46900000E-05  -1.73700000E-05  +9.33000000E-06  -1.03120000E-04
   -6.88930000E-04  +7.40370000E-04  -1.71700000E-05  -1.09420000E-04  +2.89600000E-05
   -7.68700000E-05  -5.68200000E-05  -1.64300000E-05  -1.40598000E-03  +5.02369000E-03
   +1.69493000E-03  -2.94430000E-04  +4.27730000E-04  -8.27480000E-04  +1.80963000E-03
   +2.21527000E-03  +8.19440000E-04  +5.64333000E-03  +3.17984000E-03  -2.54623000E-03
   -1.91819470E-01  -5.33521700E-02  +1.37795200E-01  -1.27994800E-02  -9.71401000E-03
   +1.67202600E-02  +4.88700000E-05  -1.40167000E-03  -1.26386000E-03  -2.34320000E-04
   +1.06680000E-04  -5.70700000E-05  -9.55500000E-05  -2.06560000E-04  -1.46410000E-04
   +2.82830000E-04  +1.09520000E-04  -2.93270000E-04  -1.64810000E-04  -2.29130000E-04
   -1.75250000E-04  -1.87280000E-04  -1.11017000E-03  -1.85674000E-03  +1.99471960E-01
   -3.40000000E-07  +1.86000000E-06  +9.49000000E-06  +2.11370000E-04  -1.77680000E-04
   -8.10000000E-05  +1.51200000E-05  +1.51000000E-06  +3.86200000E-05  +2.15500000E-05
   +3.22800000E-05  -9.30000000E-06  -1.20100000E-05  -1.98400000E-05  -1.31200000E-05
   -4.03000000E-06  +5.82000000E-06  -6.41000000E-06  +4.32680000E-04  +5.41090000E-04
   -3.17660000E-04  -6.92200000E-05  +5.42400000E-05  -4.41200000E-05  +2.68200000E-05
   +1.87000000E-05  +3.64000000E-06  +4.63668000E-03  +4.93870000E-04  +1.88722000E-03
   +6.84550000E-04  -1.24444000E-03  -3.06110000E-04  +2.65570000E-03  -2.68648000E-03
   +4.49266000E-03  -2.03342600E-02  -1.76099000E-03  +1.80065200E-02  -5.21449800E-02
   -7.82913500E-02  +6.46270200E-02  +1.23699200E-02  +8.89544000E-03  -1.25615500E-02
   -1.15817000E-03  +6.64570000E-04  -2.42787000E-03  +5.53600000E-05  +1.89800000E-05
   +5.47400000E-05  -1.33540000E-04  +1.59150000E-04  -4.49600000E-04  -9.77010000E-04
   -3.77520000E-04  +8.39030000E-04  -1.96840000E-04  -1.35740000E-04  -2.92080000E-04
   -1.56838000E-03  -5.73750000E-04  -1.88846000E-03  +5.54967200E-02  +7.44032200E-02
   +1.31000000E-06  -3.70000000E-07  +3.84000000E-06  +1.74820000E-04  -1.02890000E-04
   -4.11100000E-05  -3.07000000E-06  -1.64500000E-05  +3.94200000E-05  +2.17600000E-05
   +3.10600000E-05  +3.82000000E-06  -3.37300000E-05  -3.36800000E-05  -1.57000000E-05
   +2.50000000E-07  -5.74000000E-06  -1.49700000E-05  +3.28000000E-06  +2.50970000E-04
   +1.86530000E-04  -4.62000000E-06  -2.29800000E-05  -6.76200000E-05  +4.94200000E-05
   +3.30800000E-05  +6.64000000E-06  +1.79741000E-03  +1.61729000E-03  +4.77001000E-03
   -1.09292000E-03  -1.09820000E-04  -3.30650000E-04  +4.76440000E-04  +4.80921000E-03
   +1.84579000E-03  +1.48362100E-02  +3.12097000E-03  -6.30792000E-03  +1.36880190E-01
   +6.54613300E-02  -1.69401630E-01  +5.30280000E-04  +1.34110000E-03  +1.08771000E-03
   -1.45109000E-03  -2.25553000E-03  -1.03476000E-03  +1.30000000E-06  +7.43200000E-05
   +3.49800000E-05  -2.02180000E-04  -4.02050000E-04  -1.39880000E-04  +5.21040000E-04
   +1.68380000E-04  -5.02670000E-04  -1.74040000E-04  -2.71000000E-04  -3.99130000E-04
   -1.53349000E-03  -2.17913000E-03  -1.88660000E-03  -1.50788690E-01  -7.15744500E-02
   +1.72167620E-01  +1.64830000E-04  +1.86950000E-04  +3.25160000E-04  +7.01470000E-04
   -2.36120000E-04  -3.65370000E-04  +2.49800000E-05  +7.33200000E-05  +1.31580000E-04
   +6.39500000E-05  -1.26370000E-04  -2.72600000E-04  +1.28920000E-04  +1.23560000E-04
   +8.07800000E-05  -8.31800000E-05  -7.38100000E-05  -1.42010000E-04  -1.71874000E-03
   +1.59780000E-04  +1.07834000E-03  -1.03020000E-04  +6.18700000E-05  +3.53000000E-04
   -1.87360000E-04  -1.74810000E-04  -7.60200000E-05  +7.90090000E-04  +1.00332000E-03
   +1.04460000E-04  +2.65860000E-04  -1.91610000E-04  +4.30800000E-05  -1.63130000E-04
   -5.70000000E-07  -2.51500000E-05  -3.01400000E-05  +9.69000000E-05  -1.00800000E-04
   +8.89600000E-05  -7.05800000E-05  -5.02700000E-05  +1.65220000E-04  -2.13050000E-04
   +7.26900000E-05  +8.95700000E-05  -4.31300000E-05  +1.26200000E-05  -2.21081350E-01
   -1.27668950E-01  -1.59777000E-02  -1.18000000E-05  +4.19000000E-06  -6.37000000E-06
   +5.70000000E-07  -1.20500000E-05  -1.23000000E-06  +2.70600000E-05  +4.55400000E-05
   +3.18400000E-05  +2.57000000E-05  -7.56000000E-06  -2.43500000E-05  +2.25900000E-05
   -1.51000000E-05  -4.47000000E-06  +2.36762250E-01  -8.59720000E-04  +1.90420000E-04
   +1.81690000E-04  +5.70640000E-04  -2.10350000E-04  -2.67672000E-03  +5.08500000E-05
   -1.67190000E-04  -3.86860000E-04  +5.07800000E-05  +7.16200000E-05  +8.67600000E-05
   +2.88240000E-04  +8.09300000E-05  -1.88300000E-04  -1.51140000E-04  -3.05840000E-04
   -5.39400000E-05  -1.00152700E-02  -9.06296000E-03  -4.89670000E-04  +5.80070000E-04
   +3.59300000E-04  +9.47060000E-04  -2.65040000E-04  -1.65600000E-04  -1.18600000E-05
   -8.49050000E-04  +5.02470000E-04  +3.22560000E-04  +8.97900000E-05  -4.38840000E-04
   +4.86150000E-04  +1.70000000E-06  +3.45400000E-05  +7.92000000E-06  +1.48960000E-04
   -7.31500000E-05  -8.98900000E-05  +1.21190000E-04  -8.69000000E-06  -6.92200000E-05
   +3.07940000E-04  +9.58400000E-05  -3.96500000E-05  -1.09950000E-04  +1.10610000E-04
   +2.66700000E-05  -1.26331000E-01  -1.40630070E-01  -1.08931200E-02  +1.90000000E-07
   -2.96100000E-05  -5.81000000E-06  -1.59400000E-05  -1.15600000E-05  -1.54800000E-05
   -4.12000000E-05  +1.71620000E-04  -1.18450000E-04  -3.39500000E-05  -6.13000000E-06
   -4.05600000E-05  -4.50000000E-07  -9.34000000E-06  -6.15000000E-06  +1.40026150E-01
   +1.50165920E-01  -1.76629000E-03  -9.75820000E-04  +2.79820000E-04  +8.57490000E-04
   -1.71224000E-03  -5.47431000E-03  +5.66940000E-04  -1.54000000E-04  -3.98050000E-04
   -2.25850000E-04  +1.30000000E-07  +1.60520000E-04  +1.70740000E-04  +7.77700000E-05
   -4.68800000E-05  +1.05650000E-04  -2.89380000E-04  -2.82170000E-04  -2.43402800E-02
   -1.78615900E-02  -3.42417000E-03  -9.37300000E-04  -1.10839000E-03  +1.45644000E-03
   -1.86720000E-04  -9.10200000E-05  +2.67200000E-05  -1.13185000E-03  +4.76010000E-04
   +8.51820000E-04  +4.43610000E-04  -6.66600000E-05  +6.90000000E-06  -3.82050000E-04
   -4.33900000E-05  +1.19210000E-04  +1.80950000E-04  +6.55200000E-05  -2.22650000E-04
   +1.81830000E-04  -1.07590000E-04  -7.03300000E-05  +1.05000000E-05  +1.44910000E-04
   +2.08570000E-04  -1.85760000E-04  +1.25770000E-04  +4.33400000E-05  -1.36925600E-02
   -9.37814000E-03  -4.82429600E-02  +1.61800000E-05  -2.05100000E-05  +1.06600000E-05
   +9.98000000E-06  +1.33300000E-05  +6.80000000E-07  +2.12900000E-05  +4.09000000E-06
   +3.92000000E-05  +1.16400000E-05  +1.86200000E-05  -8.72100000E-05  -1.60000000E-07
   -1.18000000E-05  +6.13000000E-06  +1.68071900E-02  +1.40897600E-02  +5.37241000E-02
   +3.53640000E-04  +1.17310000E-04  +1.74190000E-04  +1.49620000E-04  -5.05490000E-04
   -8.60300000E-05  -4.96900000E-04  -3.35650000E-04  -1.20950000E-04  +5.26400000E-05
   -7.74300000E-05  -3.06980000E-04  -1.13420000E-04  -2.34900000E-05  +1.13720000E-04
   +2.01600000E-05  +1.27800000E-05  -2.12600000E-05  +6.13710000E-04  -1.50802000E-03
   -1.16080000E-03  +2.53250000E-04  -2.97340000E-04  -4.15570000E-04  +5.73100000E-05
   -5.15000000E-06  -3.74800000E-05  +4.79260000E-04  +5.72880000E-04  +4.23310000E-04
   +2.56410000E-04  -3.82130000E-04  +3.74140000E-04  -1.62490000E-04  -2.85500000E-05
   +7.76000000E-05  +2.88220000E-04  -1.88160000E-04  -5.82900000E-05  -6.94400000E-05
   +1.41310000E-04  -6.80300000E-05  +6.25600000E-04  +1.67760000E-04  -1.99350000E-04
   -3.14510000E-04  +2.17060000E-04  +4.81100000E-05  -2.26472790E-01  +1.17812310E-01
   +3.94567300E-02  +2.68700000E-05  -4.51400000E-05  +7.37000000E-06  -2.87500000E-05
   +1.62000000E-05  -1.69600000E-05  -2.60200000E-05  -5.48000000E-06  -3.47200000E-05
   -4.08300000E-05  -6.01200000E-05  +3.73000000E-06  -1.86700000E-05  -8.20000000E-07
   +1.40000000E-06  -1.89209900E-02  +1.47158700E-02  +4.16087000E-03  +2.44248890E-01
   -4.09410000E-04  -2.09260000E-04  -5.90100000E-05  +7.84900000E-04  +6.59980000E-04
   +7.35150000E-04  -7.81940000E-04  -1.15894000E-03  -1.03225000E-03  -1.66240000E-04
   +1.61690000E-04  +3.26300000E-04  -8.00800000E-05  -1.31370000E-04  -7.49400000E-05
   +1.34440000E-04  +1.55970000E-04  +9.86200000E-05  +1.05629600E-02  -7.58726000E-03
   -1.36595000E-03  -2.84020000E-04  +3.72120000E-04  +1.13861000E-03  +1.15830000E-04
   +1.45280000E-04  +9.76200000E-05  -9.49100000E-05  -1.10920000E-04  -2.86552000E-03
   +3.47220000E-04  -1.76470000E-04  -2.73970000E-04  -4.08490000E-04  +1.21090000E-04
   +6.42000000E-06  -9.52800000E-05  +5.28980000E-04  -3.75080000E-04  +5.80640000E-04
   -3.73910000E-04  +1.46870000E-04  -4.27820000E-04  -4.08120000E-04  +1.99830000E-04
   +3.57750000E-04  -2.54930000E-04  +5.93000000E-06  +1.17314910E-01  -1.25324610E-01
   -2.57931500E-02  -2.93900000E-05  +3.69100000E-05  -1.64700000E-05  +1.42300000E-05
   -4.43000000E-05  +6.83000000E-06  +1.04220000E-04  +2.75160000E-04  +1.63230000E-04
   -4.39000000E-05  +1.09000000E-05  -9.79700000E-05  +7.90500000E-05  +1.23000000E-06
   +3.58900000E-05  -1.61491300E-02  +1.17730800E-02  +3.96864000E-03  -1.29735200E-01
   +1.32895700E-01  -8.71000000E-05  -3.88700000E-05  -2.77160000E-04  +6.76740000E-04
   +8.39740000E-04  +1.26059000E-03  -6.11030000E-04  -1.80680000E-04  +1.63700000E-05
   -6.30800000E-05  -8.62400000E-05  -6.24300000E-05  -1.62340000E-04  +1.70000000E-06
   +1.48700000E-04  +1.61390000E-04  +1.21840000E-04  +3.22800000E-05  +2.51111200E-02
   -1.64042800E-02  -7.04954000E-03  +1.21297000E-03  -8.29930000E-04  +1.35223000E-03
   +8.31900000E-05  +5.44400000E-05  -8.83000000E-06  -1.37105000E-03  -1.39801000E-03
   -5.04137000E-03  +9.97300000E-05  +3.31710000E-04  -3.66000000E-05  +4.93970000E-04
   +1.05280000E-04  +5.78000000E-05  -4.10200000E-04  +1.53490000E-04  +8.74700000E-05
   +3.14000000E-04  +9.32000000E-05  +3.31040000E-04  +4.99780000E-04  -7.22350000E-04
   +2.61400000E-05  +5.32100000E-04  -4.05220000E-04  -8.42100000E-05  +3.81282900E-02
   -2.48856000E-02  -5.58671100E-02  -1.49900000E-05  +4.72100000E-05  -4.29800000E-05
   +4.10200000E-05  -4.06600000E-05  +1.33100000E-05  -2.23480000E-04  -3.24200000E-04
   -6.72700000E-05  -5.11400000E-05  -7.70400000E-05  -1.96370000E-04  +8.70100000E-05
   -2.94200000E-05  -1.06900000E-05  -1.97207000E-03  +1.81157000E-03  -4.99150000E-04
   -4.26918100E-02  +3.02185800E-02  +6.15598300E-02  -1.47560000E-04  -1.65740000E-04
   +1.41100000E-05  +3.11870000E-04  +7.93780000E-04  -3.77080000E-04  -2.79350000E-04
   -3.96840000E-04  -4.44940000E-04  -1.01540000E-04  +8.06100000E-05  +1.52200000E-04
   -7.57400000E-05  -8.84900000E-05  -3.25800000E-05  +9.88700000E-05  +8.92700000E-05
   +2.86200000E-05  -2.00298000E-03  +1.11337000E-03  -7.85060000E-04  +9.57000000E-06
   -3.16880000E-04  -3.93380000E-04  +1.00270000E-04  +9.75700000E-05  +6.06800000E-05
   +3.37200000E-05  -7.54900000E-04  +4.36210000E-04  -1.09720000E-04  +2.39600000E-04
   +1.45260000E-04  -2.33160000E-04  +3.07800000E-05  -1.74200000E-05  -4.71800000E-05
   +1.37800000E-04  -5.85400000E-05  +1.32610000E-04  -8.06100000E-05  +3.77700000E-05
   -1.50060000E-04  +4.11600000E-05  +8.39000000E-05  +7.95500000E-05  -5.85400000E-05
   -1.89000000E-05  -4.83562900E-02  +1.36419500E-02  -1.28551100E-02  -1.29800000E-05
   +2.13400000E-05  +1.13700000E-05  +2.55100000E-05  +8.66000000E-06  +2.31200000E-05
   +2.02210000E-04  +3.13370000E-04  +2.23590000E-04  +1.39700000E-05  +6.49000000E-06
   -5.36000000E-05  +1.55000000E-06  -6.20000000E-06  -1.13500000E-05  +2.50383000E-03
   -1.85880700E-02  +1.87355700E-02  -1.10725000E-03  +1.87361600E-02  -1.90072800E-02
   +4.80228300E-02  +1.80650000E-04  +1.03020000E-04  -5.10000000E-07  +1.78360000E-04
   +8.41890000E-04  +1.08280000E-04  -3.87490000E-04  +4.96000000E-06  +4.81500000E-05
   +8.97400000E-05  -6.05600000E-05  -6.32000000E-05  -1.00710000E-04  +7.66000000E-06
   +6.52900000E-05  +5.79700000E-05  +1.05900000E-05  -3.05900000E-05  -1.02442000E-03
   +8.87544000E-03  -9.97843000E-03  -4.74100000E-05  -4.64490000E-04  -2.06801000E-03
   +7.64500000E-05  +3.90700000E-05  -1.71300000E-05  -3.70100000E-05  +6.76300000E-04
   +6.25600000E-05  +4.01920000E-04  -3.35020000E-04  -8.51060000E-04  -1.86050000E-04
   -8.56700000E-05  +3.86500000E-05  +8.17100000E-05  +2.96700000E-05  +2.23600000E-05
   +3.60000000E-06  +1.70700000E-05  -7.74000000E-05  -6.77400000E-05  +1.64000000E-06
   +1.44360000E-04  -1.25160000E-04  +7.61400000E-05  +2.00900000E-05  +1.33039200E-02
   -1.89313030E-01  +1.35499730E-01  +1.07800000E-05  -1.01900000E-05  +1.25300000E-05
   -1.39500000E-05  +2.53000000E-06  -2.34800000E-05  +2.96700000E-04  -8.52930000E-04
   -5.27390000E-04  +4.26000000E-06  -1.41000000E-06  -3.25600000E-05  -1.05600000E-05
   -9.80000000E-07  +2.56000000E-06  +2.79276000E-03  -1.29402700E-02  +1.20810400E-02
   -2.73540000E-04  -1.18880000E-02  +1.10491900E-02  -1.51550800E-02  +2.04361250E-01
   -2.27400000E-05  -6.47990000E-04  -1.19670000E-04  +9.53970000E-04  +1.18812000E-03
   +1.49093000E-03  -1.70390000E-04  -1.83550000E-04  +2.76400000E-05  -2.76700000E-04
   -1.48080000E-04  -5.40200000E-05  -1.43770000E-04  +8.35400000E-05  +2.41520000E-04
   +2.64200000E-04  +1.92160000E-04  -3.52600000E-05  -1.80403000E-03  +2.19912500E-02
   -2.01842600E-02  -5.62800000E-05  -3.95711000E-03  -5.55515000E-03  +3.56600000E-05
   +1.12000000E-06  -1.30000000E-07  -1.49949000E-03  +9.27940000E-04  +1.06289000E-03
   +2.15620000E-04  +6.69340000E-04  -1.44190000E-04  +5.96130000E-04  -3.70480000E-04
   +1.36950000E-04  -1.75630000E-04  -4.86360000E-04  +4.19070000E-04  -5.14190000E-04
   +4.37390000E-04  -4.07200000E-05  +8.62070000E-04  +9.23000000E-06  -3.08890000E-04
   -1.26710000E-04  +5.74100000E-05  -5.43000000E-06  -1.23499300E-02  +1.32605460E-01
   -1.73500280E-01  +3.19700000E-05  -1.82300000E-05  -2.50000000E-06  +3.62400000E-05
   +6.36000000E-06  -1.12000000E-05  -1.24670000E-04  -8.85820000E-04  -3.78500000E-05
   -1.33460000E-04  -4.19100000E-05  +9.07500000E-05  -1.16200000E-05  -1.26800000E-05
   -2.34400000E-05  +5.00710000E-04  -2.86181000E-03  +2.15521000E-03  +8.86400000E-05
   -5.28975000E-03  +4.58324000E-03  +1.41282000E-02  -1.44600060E-01  +1.90812830E-01
   +3.44800000E-05  -1.24060000E-04  -8.50900000E-05  -2.51700000E-05  +4.21090000E-04
   +6.35040000E-04  -1.40300000E-04  -5.59800000E-05  +8.29200000E-05  +8.66400000E-05
   +5.79700000E-05  +3.66800000E-05  -2.70900000E-05  -8.87700000E-05  -5.51500000E-05
   -2.07850000E-04  -1.07200000E-05  -3.34400000E-05  -1.81868000E-03  -1.61833000E-03
   -3.35122000E-03  -4.72242300E-02  -2.19342000E-03  -4.54489000E-03  +5.44600000E-05
   +4.90100000E-05  +2.50000000E-07  +3.18260000E-04  -4.12130000E-04  -4.34990000E-04
   -6.70900000E-05  +8.84700000E-05  -1.83000000E-06  +1.27490000E-04  -9.74900000E-05
   -4.68000000E-06  -8.12600000E-05  +6.06000000E-06  +3.97900000E-05  -9.96900000E-05
   -1.06410000E-04  +2.53260000E-04  -9.53600000E-05  +5.60570000E-04  -5.70260000E-04
   +1.15210000E-04  -1.17330000E-04  +9.75000000E-06  -8.30600000E-05  +7.29860000E-04
   -4.44460000E-04  -1.02300000E-05  +1.05000000E-05  -3.02000000E-06  +1.16100000E-05
   -1.64400000E-05  +7.70000000E-06  -1.43100000E-05  -6.62800000E-05  +3.72300000E-05
   -1.31818000E-03  -1.85720000E-04  -3.19180000E-04  -1.57300000E-05  +3.81000000E-06
   -2.47700000E-05  +2.50510000E-04  +2.14650000E-04  +3.35730000E-04  +2.08440000E-04
   -2.10560000E-04  -2.72720000E-04  +6.55500000E-04  -5.78500000E-05  -2.93250000E-04
   +4.77459300E-02  -2.25350000E-04  +4.50000000E-06  +4.39200000E-04  +7.35370000E-04
   +1.24911000E-03  +1.76950000E-04  -3.47320000E-04  -1.11300000E-05  +2.07000000E-06
   +2.23030000E-04  +1.83670000E-04  +1.76340000E-04  +3.27500000E-05  -1.37990000E-04
   -2.58710000E-04  -1.51650000E-04  -1.76310000E-04  -1.36310000E-04  -2.38130000E-04
   +8.44746000E-03  +2.35080200E-02  -2.66910000E-03  -7.95496100E-02  -8.76424100E-02
   +1.61920000E-04  +9.95400000E-05  +3.27000000E-05  -3.33870000E-04  +1.11205000E-03
   -4.11700000E-04  -2.20710000E-04  -1.97610000E-04  -2.20300000E-05  -1.79360000E-04
   +7.36700000E-05  +7.50600000E-05  +1.33460000E-04  +8.57600000E-05  -1.99860000E-04
   +8.97500000E-05  -2.18820000E-04  +8.08900000E-05  +5.63120000E-04  +3.34440000E-04
   -1.52800000E-04  -7.50100000E-05  +1.58700000E-05  +3.37100000E-05  +4.48860000E-04
   -3.80213000E-03  +2.87206000E-03  +1.24000000E-05  -1.11100000E-05  +4.03000000E-06
   -8.11000000E-06  +2.04700000E-05  +1.86700000E-05  +7.18000000E-06  +3.65800000E-05
   +3.30500000E-05  +3.16680000E-04  -1.97070000E-04  +1.36750000E-04  +1.30800000E-05
   +2.35100000E-05  +2.57300000E-05  +2.63530000E-04  -1.70000000E-07  +8.15700000E-05
   -2.21190000E-04  -5.61900000E-05  +3.77600000E-05  +1.65700000E-04  +7.47420000E-04
   +1.50222000E-03  +1.51489000E-03  +8.49860000E-02  +2.32300000E-05  -4.47330000E-04
   -3.27400000E-05  -1.13082000E-03  -7.50380000E-04  +7.27330000E-04  +6.82830000E-04
   +9.52200000E-05  -2.22430000E-04  -3.97200000E-04  -3.17820000E-04  -1.34230000E-04
   -2.05150000E-04  +2.33960000E-04  +4.33510000E-04  +5.78570000E-04  +2.49940000E-04
   +1.34400000E-04  -7.05600000E-05  -8.23847000E-03  -1.91756000E-02  -4.61648000E-03
   -8.56130000E-02  -2.83272750E-01  -1.55900000E-05  -9.10000000E-07  -1.22500000E-05
   +9.93890000E-04  -8.61790000E-04  +6.24660000E-04  -1.30990000E-04  +5.04240000E-04
   +5.41100000E-05  +2.14680000E-04  -1.48610000E-04  -5.19200000E-05  -6.78800000E-05
   -1.95950000E-04  +9.89800000E-05  -2.76440000E-04  +5.51800000E-05  +2.72940000E-04
   +4.83350000E-04  +3.37740000E-04  +5.79200000E-05  -8.21000000E-06  -1.27600000E-05
   +2.06700000E-05  -3.93330000E-04  +4.93194000E-03  -2.17336000E-03  -4.54000000E-06
   -7.66000000E-06  -9.84000000E-06  -2.60300000E-05  -1.53600000E-05  -3.05300000E-05
   -2.49000000E-05  -1.05030000E-04  +2.19300000E-05  -3.68690000E-04  -3.73420000E-04
   +1.67160000E-04  -1.91700000E-05  +3.25400000E-05  +5.83000000E-06  +3.21900000E-05
   -1.20900000E-05  +3.02850000E-04  +6.57000000E-06  +9.86000000E-06  +4.23450000E-04
   -1.46270000E-04  -4.67290000E-04  -1.45675000E-03  +5.12936000E-03  +9.23017700E-02
   +3.08910750E-01  +3.07050000E-04  +2.51800000E-04  +2.67290000E-04  +8.51980000E-04
   -1.31466000E-03  -2.43930000E-04  +1.43040000E-04  +3.14000000E-05  +1.09540000E-04
   +1.65190000E-04  +1.50470000E-04  +2.22200000E-05  +4.55500000E-05  -6.61400000E-05
   -1.94490000E-04  -2.37290000E-04  -2.70100000E-05  +1.90000000E-07  -3.68630000E-03
   +6.64970000E-04  +1.13929000E-03  -2.50277470E-01  +1.09471260E-01  +4.32577500E-02
   +3.34200000E-05  +1.04600000E-05  +2.67800000E-05  +7.79750000E-04  +1.62300000E-04
   -2.80020000E-04  -3.72400000E-05  -1.25700000E-04  +2.80670000E-04  -9.17200000E-05
   +1.21030000E-04  -8.53700000E-05  +1.30310000E-04  -8.45200000E-05  -4.64400000E-05
   +1.41020000E-04  +2.01750000E-04  -1.86650000E-04  -6.49200000E-05  -2.15460000E-04
   +3.69060000E-04  -2.02290000E-04  +1.72940000E-04  +1.06000000E-06  -7.54900000E-05
   -3.13870000E-04  +4.33300000E-04  +1.99800000E-05  -2.47900000E-05  +3.83000000E-06
   -4.52600000E-05  +1.88000000E-05  -1.94900000E-05  +7.27000000E-05  +6.83000000E-05
   -4.80700000E-05  +1.04230000E-04  +2.40960000E-04  -4.60810000E-04  -8.15000000E-06
   +2.03000000E-06  +2.11700000E-05  -2.23800000E-05  +1.04530000E-04  +5.50000000E-05
   +3.15950000E-04  -1.16990000E-04  -5.79830000E-04  +3.09860000E-04  -2.16650000E-04
   -6.51500000E-05  +1.49906000E-03  -1.56465000E-03  -5.80080000E-04  +2.68828720E-01
   -3.28210000E-04  -3.26040000E-04  -5.91150000E-04  +1.39575000E-03  +6.50290000E-04
   -1.75380000E-04  -2.07710000E-04  +1.71140000E-04  -1.35700000E-05  -2.45060000E-04
   -1.41360000E-04  +3.53700000E-05  -2.99310000E-04  -8.69400000E-05  +2.17620000E-04
   +2.98430000E-04  +8.04200000E-05  -8.20300000E-05  +2.15742500E-02  -1.39379900E-02
   -4.48658000E-03  +1.07246110E-01  -1.03952030E-01  -2.39930700E-02  +2.42880000E-04
   +1.97920000E-04  +2.63700000E-05  -9.45640000E-04  -2.90408000E-03  +4.05881000E-03
   +1.52554000E-03  -2.46370000E-04  -4.20310000E-04  +3.50600000E-05  -4.02930000E-04
   +1.11940000E-04  -2.94550000E-04  +8.57600000E-05  +1.15870000E-04  +1.35320000E-04
   +1.65460000E-04  -8.49400000E-05  -6.48750000E-04  -1.31160000E-04  +6.60590000E-04
   +2.73710000E-04  -1.48620000E-04  -7.01000000E-05  -1.12910000E-04  +4.71430000E-04
   -1.35582000E-03  -3.86800000E-05  +3.65600000E-05  -7.17000000E-06  +1.10350000E-04
   -1.20330000E-04  -4.08100000E-05  -6.88000000E-06  +2.49500000E-05  +8.06500000E-05
   -1.89790000E-04  +1.45000000E-04  -3.64900000E-04  +4.79800000E-05  -1.16300000E-05
   +7.00000000E-07  -1.30690000E-04  +3.56700000E-05  +7.55400000E-05  -1.92580000E-04
   +5.48220000E-04  +4.40620000E-04  -3.19100000E-04  +1.54300000E-05  -1.24740000E-04
   +9.03759000E-03  -5.48318000E-03  -1.41655000E-03  -1.19060940E-01  +1.14104350E-01
   +3.69410000E-04  +4.95300000E-05  -1.57810000E-04  -6.05460000E-04  -3.26210000E-04
   +3.57170000E-04  -1.16810000E-04  -1.37930000E-04  +2.04420000E-04  +1.01480000E-04
   +1.14490000E-04  -4.03500000E-05  +1.32250000E-04  -2.99300000E-05  -1.71140000E-04
   -3.53710000E-04  -2.43600000E-05  +7.58600000E-05  -1.88887500E-02  +1.05138600E-02
   +2.35731000E-03  +4.46708600E-02  -2.51861500E-02  -5.65158900E-02  -1.28070000E-04
   -8.30100000E-05  -1.16200000E-05  +6.47110000E-04  +2.83883000E-03  -2.88017000E-03
   -1.17898000E-03  +7.09170000E-04  +5.12430000E-04  +1.11460000E-04  +1.97180000E-04
   -1.97430000E-04  +3.96600000E-05  -1.04150000E-04  -6.50000000E-06  -1.73910000E-04
   -2.51300000E-05  +2.51260000E-04  +7.64760000E-04  +4.25950000E-04  -3.86240000E-04
   -5.62600000E-05  -4.75000000E-06  +3.24100000E-05  -1.18640000E-03  +5.46640000E-04
   +1.14949000E-03  +1.12000000E-05  -1.10900000E-05  -2.63000000E-06  -1.05620000E-04
   +4.46300000E-05  -1.70800000E-05  +2.08000000E-06  -2.67300000E-05  +1.86900000E-05
   -1.07840000E-04  -5.84870000E-04  +9.52700000E-05  -1.23400000E-05  +2.95000000E-05
   +1.78100000E-05  +1.62500000E-05  -2.14500000E-05  -5.95200000E-05  +2.68010000E-04
   +2.40000000E-05  -6.68390000E-04  +2.23030000E-04  -1.64260000E-04  +2.05470000E-04
   +2.69386000E-02  -1.33603000E-02  -4.46673000E-03  -4.78436600E-02  +2.26198900E-02
   +6.04071900E-02  +3.16180000E-04  +2.74400000E-04  +5.47680000E-04  +5.47760000E-04
   -4.07740000E-04  -1.02960000E-04  +3.80870000E-04  -1.17720000E-04  -1.09550000E-04
   +5.90100000E-05  +3.01500000E-05  -3.78500000E-05  +3.00890000E-04  +1.19060000E-04
   -1.43670000E-04  -2.93880000E-04  -7.03900000E-05  +8.90800000E-05  +2.41757000E-03
   +3.18335000E-03  +2.28720000E-04  -1.94644530E-01  -1.30790100E-01  -1.97300500E-02
   -2.59740000E-04  -1.88360000E-04  -1.79900000E-05  -9.80000000E-07  -7.27400000E-05
   +2.86020000E-04  +1.17760000E-04  -1.22370000E-04  -4.16700000E-05  +4.76900000E-05
   -1.48500000E-05  -4.41000000E-06  -1.77340000E-04  +7.80000000E-07  +3.03600000E-05
   +1.11860000E-04  +2.10140000E-04  -1.85510000E-04  -9.31010000E-04  +8.04400000E-04
   +8.26370000E-04  +9.15700000E-05  -2.85100000E-05  -3.88300000E-05  +3.05420000E-04
   +3.34290000E-04  -5.00700000E-05  -2.05600000E-05  +1.14000000E-05  -4.98000000E-06
   +1.59300000E-05  -1.92700000E-05  -5.91000000E-06  -5.31000000E-06  +2.85000000E-06
   -4.46000000E-06  -1.46603000E-03  +1.90610000E-03  +4.46720000E-04  +3.30900000E-05
   +4.48000000E-06  +2.62600000E-05  +2.46140000E-04  +2.45000000E-05  +3.03820000E-04
   -1.46210000E-04  -1.40450000E-04  -8.10000000E-07  +1.42490000E-04  +2.13540000E-04
   +1.27090000E-04  -4.59300000E-05  +1.49474000E-03  +4.35600000E-04  -1.90191100E-02
   -1.89282700E-02  -3.58997000E-03  +2.11902500E-01  -3.07270000E-04  +8.65000000E-05
   +2.79710000E-04  +7.35950000E-04  -2.93432000E-03  +3.89597000E-03  +5.55470000E-04
   -4.73620000E-04  -3.04690000E-04  -6.15980000E-04  -2.58250000E-04  -3.98530000E-04
   +3.62140000E-04  +4.16030000E-04  +3.40420000E-04  -6.54100000E-05  +1.44790000E-04
   +4.25400000E-05  -1.86121100E-02  -1.58748600E-02  -3.05404000E-03  -1.29555980E-01
   -1.62847320E-01  -1.71391800E-02  -6.26630000E-04  -4.67550000E-04  -1.29320000E-04
   -7.35700000E-04  +7.56570000E-04  -2.04990000E-04  +3.06880000E-04  -1.40110000E-04
   +1.82180000E-04  -2.05590000E-04  +1.76790000E-04  +4.35000000E-06  +6.52700000E-05
   +1.51800000E-05  -1.23820000E-04  +3.33760000E-04  +2.77040000E-04  -3.08250000E-04
   -4.71000000E-06  -5.87570000E-04  +6.75840000E-04  -1.17360000E-04  +1.47020000E-04
   -2.04200000E-05  -2.39720000E-04  +7.48460000E-04  -1.57299000E-03  +5.09000000E-06
   -1.81400000E-05  -3.02000000E-06  -1.77100000E-05  -1.33000000E-06  -2.55200000E-05
   -4.11100000E-05  +8.51400000E-05  -1.18160000E-04  +1.45065000E-03  -7.37430000E-04
   -1.18819000E-03  +1.68900000E-05  -3.43600000E-05  +6.11000000E-06  +3.55180000E-04
   +5.15190000E-04  +6.15740000E-04  +1.16440000E-04  -3.04700000E-05  +1.11580000E-04
   +3.37890000E-04  +1.28310000E-04  -1.71190000E-04  -7.18743000E-03  -6.96206000E-03
   -1.32390000E-04  +1.14830200E-02  +1.10973700E-02  +1.97994000E-03  +1.42263680E-01
   +1.76737050E-01  -8.40700000E-05  -4.14210000E-04  -5.03500000E-05  -9.35160000E-04
   +2.80560000E-03  -2.21456000E-03  +3.97320000E-04  +4.46610000E-04  +8.17200000E-05
   -6.42700000E-05  -2.60330000E-04  +4.75600000E-05  -4.18450000E-04  +2.78000000E-05
   +3.76370000E-04  +7.68830000E-04  -1.07000000E-05  -9.76000000E-06  +1.64067000E-02
   +1.37450000E-02  +6.35330000E-04  -1.95997200E-02  -1.80495000E-02  -5.09673400E-02
   +3.74360000E-04  +2.84390000E-04  +2.12100000E-05  +8.92200000E-05  -5.82160000E-04
   +3.82030000E-04  +1.67000000E-05  +9.42000000E-06  -2.15470000E-04  +1.03750000E-04
   -2.84700000E-05  -5.26500000E-05  -1.05590000E-04  -7.77500000E-05  +1.41460000E-04
   -5.50900000E-05  +2.38670000E-04  -1.60370000E-04  -2.52380000E-04  -6.44040000E-04
   +5.16000000E-04  +2.58500000E-05  +1.89800000E-05  -3.85800000E-05  +1.13880000E-03
   +6.09280000E-04  +1.15383000E-03  -5.64000000E-06  +1.17100000E-05  +1.04000000E-06
   +1.82100000E-05  +1.06400000E-05  +7.59000000E-06  +3.24800000E-05  +2.66300000E-05
   +1.24900000E-05  +6.29900000E-04  -4.81390000E-04  -2.20840000E-04  +1.08700000E-05
   -7.19000000E-06  +8.94000000E-06  -4.94470000E-04  +4.08400000E-05  -5.59990000E-04
   +7.71500000E-05  -7.56600000E-05  -7.81100000E-05  -1.40210000E-04  -2.41810000E-04
   +2.79410000E-04  -2.31399400E-02  -1.93212000E-02  -1.31704000E-03  +4.63344000E-03
   +4.66753000E-03  -2.02680000E-04  +2.07265900E-02  +1.68299100E-02  +5.25036500E-02
   -1.93480000E-04  -3.73340000E-04  -1.05496000E-03  -1.59787000E-03  -3.69245000E-03
   +7.98230000E-04  -1.66060900E-02  +1.27573000E-03  +1.41110400E-02  -1.97266310E-01
   +6.41716000E-03  +1.50195740E-01  +5.51111000E-03  -2.77698000E-03  -1.73734000E-03
   +1.86373000E-03  -1.81062000E-03  +5.00700000E-05  +7.49800000E-05  +4.17750000E-04
   +6.52500000E-04  -1.50050000E-04  -6.24500000E-05  -7.89600000E-05  -1.42860000E-04
   +1.50319000E-03  -7.25520000E-04  +7.63000000E-06  -1.83560000E-04  -1.58100000E-05
   -1.54200000E-05  -9.71000000E-06  +2.60900000E-05  -3.03200000E-05  +1.11500000E-05
   +1.18100000E-05  +4.45800000E-05  -2.23700000E-05  -1.07300000E-05  -3.08000000E-06
   +1.11400000E-05  +9.36000000E-06  -4.70000000E-05  +5.67600000E-05  -1.14300000E-05
   -5.41200000E-05  +3.92300000E-05  +3.74000000E-06  +2.62000000E-06  +1.80400000E-05
   +5.04800000E-05  +3.37000000E-06  -7.47000000E-06  +4.00000000E-06  -1.15100000E-05
   +1.00400000E-05  -1.20000000E-07  +5.83000000E-06  -1.49500000E-05  +9.85000000E-06
   +7.53000000E-06  -5.06000000E-06  -8.95000000E-06  -7.50000000E-06  +4.14000000E-06
   +1.90000000E-06  -1.39200000E-05  -2.53700000E-05  -3.28000000E-05  +2.61000000E-06
   -1.52100000E-05  +1.18800000E-05  -2.22700000E-05  +8.89000000E-06  -2.11500000E-05
   +9.00000000E-08  +1.00700000E-05  -7.25000000E-06  +1.64400000E-05  +5.56000000E-06
   +3.29000000E-06  -8.35000000E-06  -7.74800000E-05  +2.90400000E-05  +2.08590960E-01
   -2.38470000E-04  -1.22487000E-03  -3.82700000E-04  -4.86244000E-03  +1.05198000E-03
   -1.64724000E-03  -9.73405000E-03  +1.59840000E-03  +1.36471900E-02  +2.48156000E-03
   -4.33465700E-02  -1.79725000E-02  +1.35989300E-02  +5.74362000E-03  -1.49143300E-02
   -2.06760000E-03  +4.21470000E-04  -4.51123000E-03  -1.70750000E-04  +4.95390000E-04
   +3.11160000E-04  -6.11100000E-05  +4.42600000E-05  -3.53400000E-05  +1.37522000E-03
   -7.72100000E-04  +2.64088000E-03  -2.41780000E-04  -2.08180000E-04  +4.03000000E-06
   -1.79700000E-05  -3.47000000E-06  -1.72100000E-05  +1.69500000E-05  -6.99000000E-06
   +5.21000000E-06  +1.80100000E-05  -4.43700000E-05  +1.95800000E-05  -3.04900000E-05
   +4.84300000E-05  +1.57500000E-05  +3.51000000E-06  +1.55000000E-05  -5.05400000E-05
   -4.16900000E-05  +2.69600000E-05  +4.11000000E-06  -1.37400000E-05  +8.10600000E-05
   +7.00900000E-05  +4.43000000E-06  -2.99000000E-06  +0.00000000E+00  +2.95000000E-06
   +1.31000000E-06  -2.64000000E-06  +9.40000000E-07  +8.39000000E-06  -3.15000000E-06
   -4.05000000E-06  -1.04900000E-05  -5.50000000E-07  -4.56000000E-06  +5.96000000E-06
   +6.18000000E-06  +5.59000000E-06  -1.36900000E-05  -2.70400000E-05  +2.25700000E-05
   -3.88900000E-05  -4.93000000E-06  +6.30000000E-06  +1.56100000E-05  -2.95000000E-06
   +1.00600000E-05  -5.06000000E-06  +9.76000000E-06  +1.28900000E-05  -1.03600000E-05
   +5.84000000E-06  -6.18000000E-06  -8.39000000E-06  +3.12900000E-05  -1.15209000E-03
   +3.65075700E-02  -1.00378000E-03  -3.11510000E-04  -4.02010000E-04  -1.07764000E-03
   -2.67200000E-03  +2.43005000E-03  -1.38547000E-03  +4.12054000E-03  +4.83578000E-03
   +1.44676240E-01  -2.13264900E-02  -1.85871310E-01  +2.14112400E-02  -8.26020000E-04
   -1.14114100E-02  -3.47220000E-04  -4.77711000E-03  -1.53585000E-03  -7.93000000E-05
   -2.39200000E-05  +2.97040000E-04  -3.38700000E-05  -6.00500000E-05  -2.64300000E-05
   -9.27520000E-04  +2.51216000E-03  +8.53450000E-04  +6.83900000E-05  -5.11000000E-06
   -1.25100000E-05  +3.78000000E-06  -1.02000000E-06  +6.72000000E-06  -1.24000000E-05
   +1.09100000E-05  -2.30000000E-06  -8.60000000E-06  +2.05400000E-05  -8.75000000E-06
   +1.39900000E-05  -1.67200000E-05  +4.33000000E-06  -1.94000000E-05  +1.18800000E-05
   +2.22800000E-05  +1.63600000E-05  -1.00400000E-05  -3.08000000E-06  +2.41000000E-05
   +4.02300000E-05  +1.51800000E-05  -3.51000000E-06  +2.12000000E-06  +8.90000000E-07
   -2.76000000E-06  +9.30000000E-07  +1.04000000E-06  -4.52000000E-06  +1.84000000E-06
   +1.95000000E-06  +1.91000000E-06  +5.40000000E-07  -3.19000000E-06  -5.40000000E-07
   -1.32000000E-06  -2.58000000E-06  +2.00500000E-05  -3.70000000E-06  -1.79800000E-05
   +1.44900000E-05  -3.55200000E-05  +1.73100000E-05  -3.40500000E-05  +1.68200000E-05
   -1.74000000E-05  -3.40000000E-06  +5.93000000E-06  -2.24400000E-05  +9.92000000E-06
   -1.33000000E-06  +1.29700000E-05  +4.55000000E-06  -3.56400000E-05  -7.77000000E-06
   -1.61941850E-01  +2.27788200E-02  +1.91599070E-01  +2.32551000E-03  -1.57318200E-02
   -2.17401300E-02  -2.44802000E-03  -4.91324000E-03  +9.59990000E-04  -1.94769000E-03
   -4.25020000E-04  +4.98560000E-04  -1.89207000E-03  -8.21740000E-04  +4.38725000E-03
   +5.07301000E-03  +1.34505100E-02  +1.75836100E-02  -5.61106600E-02  -2.12818700E-02
   -9.42553000E-03  +5.61030000E-04  -4.53140000E-04  -9.51470000E-04  -1.84900000E-05
   +7.01400000E-05  -8.43900000E-05  +1.72547000E-03  +2.74488000E-03  -8.66530000E-04
   +1.27560000E-04  -6.04400000E-05  -1.61100000E-05  -1.03200000E-05  -1.40000000E-07
   +1.93100000E-05  -1.10900000E-05  +2.56900000E-05  +2.93300000E-05  +4.32400000E-05
   -5.12100000E-05  +4.59000000E-06  -2.62800000E-05  +4.90900000E-05  +7.68000000E-06
   +1.32000000E-06  +2.37100000E-05  -1.69500000E-05  -7.48400000E-05  +6.93600000E-05
   +2.08200000E-05  -3.51920000E-04  -1.99260000E-04  +7.33200000E-05  -5.68000000E-06
   -1.64800000E-05  -9.17000000E-06  -2.02900000E-05  +7.14000000E-06  -1.78100000E-05
   +1.11300000E-05  -3.04600000E-05  -2.33000000E-06  +8.26000000E-06  -5.35000000E-06
   -1.00400000E-05  -1.35500000E-05  -1.44000000E-06  -1.72000000E-06  -4.02900000E-05
   -4.59700000E-05  -1.38510000E-04  +5.40000000E-07  +1.36200000E-05  +3.37500000E-05
   +4.14000000E-06  +2.32000000E-05  -1.99600000E-05  +2.14900000E-05  -5.53000000E-06
   +3.34200000E-05  -4.45000000E-06  +1.44700000E-05  +1.08400000E-05  -2.95600000E-05
   -3.40800000E-05  +3.10500000E-05  +2.45570000E-04  +7.36750000E-04  +7.88670000E-04
   +5.37588500E-02  +6.58190000E-04  -7.57664000E-03  -1.45592000E-02  -4.69828000E-03
   +2.50935000E-03  -1.69347000E-03  -1.67630000E-04  -1.40810000E-04  +8.33850000E-04
   -8.42600000E-04  +3.22974000E-03  -1.22968000E-03  -4.00771000E-03  +6.92930000E-04
   -9.33940000E-04  -2.13577600E-02  -1.48317040E-01  -1.43760830E-01  +1.89870000E-04
   +1.79800000E-05  -7.18270000E-04  -6.87900000E-05  -5.03000000E-06  -3.35200000E-05
   +2.39777000E-03  -3.03800000E-04  +2.95607000E-03  +1.69630000E-04  -1.12310000E-04
   -2.40100000E-05  +2.90100000E-05  +3.81800000E-05  -5.90000000E-06  -3.64400000E-05
   -1.39200000E-05  +1.76300000E-05  +7.30000000E-05  -3.14000000E-05  -2.27600000E-05
   -1.42100000E-05  +1.47100000E-05  +1.20200000E-05  -1.55200000E-05  +3.20500000E-05
   +6.80000000E-06  -8.30200000E-05  +5.08500000E-05  +1.82200000E-05  -3.21880000E-04
   -2.24440000E-04  +4.99900000E-05  +1.34300000E-05  -9.54000000E-06  -1.25000000E-06
   -3.00000000E-07  +6.19000000E-06  +5.60000000E-07  +6.66000000E-06  -1.40300000E-05
   +2.34100000E-05  +1.33000000E-06  -1.43700000E-05  -6.61000000E-06  -1.19700000E-05
   -2.60000000E-07  +1.77000000E-06  -1.13300000E-05  -1.06040000E-04  -8.96400000E-05
   +2.88700000E-05  +1.13600000E-05  -1.03000000E-06  +1.81800000E-05  +2.77000000E-06
   +4.60200000E-05  -1.38600000E-05  +2.08000000E-06  +1.10000000E-05  +1.22500000E-05
   -2.76000000E-06  -1.49600000E-05  -3.30000000E-06  -5.24900000E-05  +2.12000000E-05
   +1.57600000E-05  -4.74100000E-05  +1.16300000E-05  +2.60055200E-02  +1.51985820E-01
   +1.08188000E-03  -5.98120000E-04  +7.39250000E-04  +7.80020000E-04  -1.92253000E-03
   +3.35195000E-03  +7.69280000E-04  +1.00891000E-03  +1.46850000E-04  +4.43142000E-03
   -1.19280000E-03  -8.24820000E-04  -6.45948000E-03  -1.56672000E-02  -1.25137200E-02
   -9.64176000E-03  -1.43663090E-01  -2.23680660E-01  +3.62930000E-04  -6.47700000E-05
   -5.47900000E-05  -4.59200000E-05  +3.47000000E-06  -5.04500000E-05  -1.52837000E-03
   +2.58102000E-03  +9.79200000E-04  -3.37000000E-05  -4.12200000E-05  -4.61000000E-06
   -2.89400000E-05  -2.81600000E-05  +1.06600000E-05  +4.00000000E-08  +9.79000000E-06
   +2.56800000E-05  +5.04600000E-05  -6.50300000E-05  +2.03600000E-05  -2.26600000E-05
   +4.87700000E-05  -1.45500000E-05  +2.01800000E-05  +1.22100000E-05  -5.20000000E-05
   -8.08700000E-05  +7.00300000E-05  +1.16100000E-05  -6.12100000E-05  -1.82600000E-05
   +4.53200000E-05  -4.20000000E-07  -1.79000000E-05  -2.80000000E-06  -2.00000000E-05
   +7.96000000E-06  -1.69600000E-05  +1.30000000E-05  -2.55500000E-05  -3.13000000E-06
   +1.10300000E-05  +4.41000000E-06  -4.21000000E-06  -5.23000000E-06  +2.91000000E-06
   +2.17000000E-06  -2.58100000E-05  +1.89500000E-05  -3.12000000E-05  -1.28800000E-05
   +2.28100000E-05  +1.45400000E-05  +8.92000000E-06  +1.06500000E-05  -3.20800000E-05
   +1.38500000E-05  +2.02300000E-05  -2.00000000E-07  +1.10000000E-07  +1.45800000E-05
   -5.40000000E-07  -2.02200000E-05  -3.07000000E-05  +1.41900000E-05  -2.40400000E-04
   -6.04330000E-04  -7.11830000E-04  +1.00715600E-02  +1.57831410E-01  +2.33723990E-01
   -2.00515130E-01  +7.36156000E-03  +1.42234800E-01  +5.58076000E-03  -1.41879000E-03
   -2.28272000E-03  +2.05360000E-03  -1.62137000E-03  +6.68590000E-04  -3.61910000E-04
   -2.96000000E-06  -6.69580000E-04  -8.82270000E-04  -4.76249000E-03  -3.47380000E-04
   -1.32927600E-02  +2.88466000E-03  +1.85240100E-02  -1.02090000E-03  +6.98770000E-04
   -8.63060000E-04  +9.73200000E-05  +7.19100000E-05  +1.41480000E-04  -1.25390000E-03
   -7.28600000E-05  +9.13330000E-04  -5.11640000E-04  -7.41520000E-04  -6.43370000E-04
   -4.22730000E-04  +9.26000000E-06  -3.76740000E-04  +3.08720000E-04  -4.22100000E-05
   -1.07950000E-04  -2.92330000E-04  +2.55500000E-05  +1.81530000E-04  -1.49100000E-04
   +1.01000000E-04  +5.31000000E-05  -4.25800000E-05  -1.80200000E-05  +3.23300000E-05
   +2.12900000E-04  -1.34360000E-04  -4.10000000E-05  -5.53400000E-05  +1.57360000E-04
   -2.17100000E-05  -2.20100000E-05  +3.10900000E-05  -3.35000000E-06  +1.12400000E-05
   -1.30100000E-05  +9.56000000E-06  +4.48500000E-05  +1.05900000E-05  +6.98800000E-05
   +5.03800000E-05  +7.47000000E-06  -2.46000000E-06  +4.98000000E-06  +3.47000000E-06
   -1.07000000E-05  +3.56600000E-05  +5.51000000E-06  +1.68500000E-05  -1.74900000E-05
   +4.90900000E-05  +4.28200000E-05  +3.67000000E-06  -1.27400000E-05  -2.06400000E-05
   +1.52790000E-04  +7.39600000E-05  -1.39080000E-04  +1.61500000E-05  +2.03600000E-05
   +2.40000000E-05  -1.53700000E-05  +2.54200000E-05  -2.12800000E-04  -7.33700000E-05
   +7.52000000E-05  -7.97000000E-06  -1.32920000E-04  +1.47067000E-03  -1.34503000E-03
   +2.10340630E-01  +8.62727000E-03  -4.97148600E-02  -2.22075100E-02  +1.36857100E-02
   +3.72318000E-03  -1.40617000E-02  -1.26332000E-03  +9.38720000E-04  -5.72077000E-03
   -3.10450000E-04  -8.95420000E-04  +7.75820000E-04  -4.49008000E-03  +1.72354000E-03
   -3.24288000E-03  -1.36755500E-02  +5.04478000E-03  +1.25497500E-02  +1.56068000E-03
   -1.36308000E-03  +1.59585000E-03  -2.81220000E-04  -3.93120000E-04  -4.60400000E-04
   -9.34120000E-04  +4.28100000E-05  +7.32230000E-04  -3.37380000E-04  -6.25700000E-05
   -8.31900000E-05  -2.78940000E-04  +3.48940000E-04  -2.24530000E-04  +2.97520000E-04
   -2.32340000E-04  -1.88660000E-04  -1.87510000E-04  -6.85500000E-05  +1.69830000E-04
   -1.42310000E-04  +1.16610000E-04  +4.42800000E-05  +5.15700000E-05  -5.92200000E-05
   -2.36400000E-05  +1.70080000E-04  -1.29130000E-04  -3.07900000E-05  +1.80610000E-04
   -1.57900000E-05  +7.91300000E-05  +6.93000000E-06  +2.75600000E-05  +8.26000000E-06
   +3.32600000E-05  -1.34800000E-05  +2.49500000E-05  -4.35300000E-05  +1.47800000E-05
   +1.06590000E-04  -6.28700000E-05  -9.03600000E-05  -3.30000000E-07  +1.22200000E-05
   +4.75000000E-06  -1.29000000E-06  -9.22300000E-05  +3.96600000E-05  +7.43000000E-05
   -4.59300000E-05  +1.08000000E-04  +2.96400000E-05  +6.02700000E-05  +7.35000000E-06
   +8.48400000E-05  -1.19530000E-04  -6.01120000E-04  +3.31450000E-04  -5.46600000E-05
   +1.14010000E-04  +5.88000000E-06  -1.79000000E-06  +4.08300000E-05  +3.97650000E-04
   +1.06840000E-04  -9.51600000E-05  +8.48600000E-05  +1.85028000E-03  -1.94717000E-03
   +1.88907000E-03  -4.40140000E-03  +4.32292400E-02  +1.42562170E-01  -2.05852700E-02
   -1.82977780E-01  +1.82859700E-02  -2.08830000E-03  -1.19990500E-02  +1.74820000E-03
   -5.45692000E-03  -3.11271000E-03  -1.44759000E-03  +2.97480000E-04  +3.40020000E-04
   +1.01910000E-04  -2.79888000E-03  +2.97934000E-03  -3.67757000E-03  -1.06560000E-03
   +5.69561000E-03  +2.98390000E-04  +2.11052000E-03  -6.97030000E-04  -2.57000000E-06
   -3.55100000E-05  -7.61900000E-05  -6.24000000E-05  +7.53900000E-05  +2.68510000E-04
   -2.88620000E-04  -3.91050000E-04  +1.42510000E-04  +4.81200000E-05  +3.96220000E-04
   -8.77700000E-05  -3.44000000E-05  +1.48570000E-04  +1.37800000E-05  -3.11390000E-04
   +1.86130000E-04  -3.60800000E-05  +4.67400000E-05  -1.98130000E-04  +7.53800000E-05
   -4.75550000E-04  +1.53770000E-04  +3.44630000E-04  +3.41920000E-04  -2.23690000E-04
   -3.89500000E-05  -2.06370000E-04  -3.27900000E-05  -9.08000000E-06  -3.90900000E-05
   +4.20300000E-05  -1.29200000E-05  +6.74000000E-06  -2.96400000E-05  -5.83000000E-06
   +6.08500000E-05  -8.15900000E-05  -5.66200000E-05  +1.61000000E-06  +1.97600000E-05
   -2.59400000E-05  +1.74900000E-05  +1.04000000E-05  -5.10000000E-06  -8.17900000E-05
   -5.52000000E-05  +1.09500000E-05  -6.04500000E-05  +1.51410000E-04  +6.80900000E-05
   +6.79700000E-05  -3.43800000E-05  +2.91300000E-05  +5.81700000E-05  -4.37600000E-05
   +1.27950000E-04  +6.92000000E-06  +1.20220000E-04  +7.21700000E-05  -1.06800000E-05
   -5.93000000E-05  -4.97700000E-05  +1.48900000E-05  +1.00970000E-04  -9.88600000E-05
   -1.02110000E-03  +2.18830000E-03  -6.48690000E-04  -1.55976780E-01  +2.71944400E-02
   +1.89758740E-01  -9.54640000E-04  -1.61840000E-04  -3.24850000E-04  +2.43300000E-05
   +6.12630000E-04  +8.74060000E-04  +9.92230000E-04  -8.91310000E-04  -9.34900000E-04
   -4.76419000E-03  -3.77241000E-03  +8.39430000E-04  -3.50316000E-03  -2.60027800E-02
   -3.58605200E-02  +1.53331000E-03  -1.86180000E-04  -2.29882000E-03  -1.53230000E-04
   -5.13100000E-05  +1.14790000E-04  +3.54700000E-05  -7.04000000E-06  -6.69000000E-06
   -3.80705300E-02  +1.72017700E-02  +5.40772200E-02  +1.25000000E-06  +4.65100000E-05
   +1.33200000E-05  +2.30000000E-07  +1.28600000E-05  +2.57500000E-05  +3.29100000E-05
   +3.67500000E-05  -1.82600000E-05  -1.30130000E-04  +7.53900000E-05  +1.48200000E-05
   +2.15000000E-05  -2.90400000E-05  +1.50400000E-05  -1.43200000E-05  -1.16500000E-05
   +3.54700000E-05  +1.40860000E-04  -8.06200000E-05  -1.52100000E-05  +7.97900000E-05
   +3.07800000E-05  -1.98900000E-05  -3.08300000E-05  +1.49200000E-05  -6.02000000E-06
   -5.82000000E-06  -1.24600000E-05  -5.45000000E-06  -1.91100000E-05  +1.30000000E-06
   -3.71800000E-05  -1.01600000E-05  -1.29000000E-06  -3.56000000E-06  +5.93000000E-06
   -2.06000000E-06  -7.62000000E-06  +1.81400000E-05  +3.05800000E-05  +2.83000000E-05
   -1.73700000E-05  -5.99000000E-06  -1.08000000E-05  -5.92000000E-06  -8.10000000E-06
   -1.07300000E-05  -7.81000000E-06  -2.05200000E-05  +1.49700000E-05  -8.32000000E-06
   -1.43100000E-05  +1.34900000E-05  +2.71700000E-05  +3.05500000E-05  -2.51000000E-06
   -1.33530000E-04  +2.75130000E-04  -1.59880000E-04  -7.69000000E-04  +5.64460000E-04
   +1.95823000E-03  +1.48100000E-04  +7.95800000E-05  +2.82800000E-05  +4.55368300E-02
   +7.37000000E-06  -1.14854000E-03  -1.65310000E-04  +1.66880000E-04  +4.72050000E-04
   +6.50070000E-04  -7.00900000E-05  +1.46220000E-04  -1.53513000E-03  -4.42748000E-03
   +2.30700000E-04  +6.68080000E-04  -5.65130000E-04  -1.96048800E-02  -2.40151600E-02
   +3.44439000E-03  +2.14339000E-03  +1.34131000E-03  -2.47720000E-04  -3.88000000E-06
   -8.73400000E-05  +1.16670000E-04  +4.51600000E-05  +3.87600000E-05  -1.02741500E-02
   -1.71442100E-01  -2.29243330E-01  -1.96500000E-05  +9.42400000E-05  +5.44000000E-05
   +1.46500000E-05  +1.40000000E-07  +1.26000000E-06  +2.95900000E-05  +1.80800000E-05
   -3.51200000E-05  -1.25780000E-04  +9.86900000E-05  +2.02000000E-06  +2.51400000E-05
   -5.48700000E-05  +1.51700000E-05  -1.72000000E-06  -1.84400000E-05  +3.71000000E-05
   +1.55040000E-04  -1.17600000E-04  -2.39800000E-05  +7.11400000E-05  +9.56000000E-06
   -2.85300000E-05  -1.47000000E-05  +3.00700000E-05  +1.39000000E-06  +1.88000000E-05
   -1.52500000E-05  +1.33900000E-05  -2.54100000E-05  +3.40400000E-05  -2.67300000E-05
   -1.68800000E-05  -1.97000000E-06  +7.63000000E-06  +8.54000000E-06  -1.80000000E-06
   -5.12000000E-06  +1.84400000E-05  +3.26200000E-05  +2.44800000E-05  -9.96000000E-06
   -1.20300000E-05  -1.90800000E-05  -9.81000000E-06  -1.15900000E-05  +2.80000000E-07
   -2.22200000E-05  -1.25800000E-05  +1.22100000E-05  +4.85000000E-06  -3.81800000E-05
   -3.00000000E-08  +3.41800000E-05  +5.60100000E-05  -2.87400000E-05  +3.17660000E-04
   -2.26900000E-04  +4.87740000E-04  -1.00715000E-03  +3.25440000E-04  +3.82500000E-04
   +1.58820000E-04  +1.56610000E-04  -1.56100000E-05  +1.22457100E-02  +1.88817610E-01
   -7.31400000E-05  -3.82800000E-05  -1.02522000E-03  +2.63520000E-04  +1.28570000E-04
   +1.81380000E-04  +1.80190000E-04  -8.50220000E-04  -4.38900000E-05  -7.97600000E-05
   +1.16970000E-04  +2.63916000E-03  +3.02020000E-04  -2.00308000E-03  -5.37949000E-03
   +2.84103000E-03  +4.45093000E-03  +2.90161000E-03  -1.46390000E-04  -7.46500000E-05
   -1.02790000E-04  +1.24610000E-04  +5.45900000E-05  +7.00000000E-05  +1.50025400E-02
   -2.53005180E-01  -3.75612720E-01  +9.58000000E-06  +7.03600000E-05  +5.61000000E-06
   +5.11000000E-06  -2.08200000E-05  +2.46600000E-05  +1.29800000E-05  +1.74800000E-05
   -1.27700000E-05  -5.99200000E-05  +4.92500000E-05  +1.96000000E-06  +2.65900000E-05
   -3.40800000E-05  -5.30000000E-06  -1.45000000E-05  -1.33500000E-05  +1.59500000E-05
   +7.56400000E-05  -4.98200000E-05  -1.75300000E-05  +2.72500000E-05  -6.23000000E-06
   -2.63600000E-05  -1.21100000E-05  +9.13000000E-06  +4.05000000E-06  -2.64000000E-06
   -4.23000000E-06  +2.48000000E-06  -1.19400000E-05  +8.07000000E-06  -2.78300000E-05
   -2.76000000E-06  +8.96000000E-06  +4.46000000E-06  +8.55000000E-06  -1.50000000E-07
   -2.78000000E-06  +1.05600000E-05  +2.00000000E-05  +1.34500000E-05  -4.47000000E-06
   -1.36000000E-06  -2.20000000E-06  -4.74000000E-06  -4.73000000E-06  -5.84000000E-06
   +3.96000000E-06  -1.56300000E-05  -5.65000000E-06  -3.56000000E-06  -1.78400000E-05
   +1.47900000E-05  +2.07300000E-05  +5.60400000E-05  -3.75400000E-05  -9.66500000E-05
   +5.25820000E-04  +5.76500000E-05  -2.32010000E-04  -9.34800000E-04  -4.38540000E-04
   +1.60030000E-04  +6.68600000E-05  +1.15500000E-05  -1.83302900E-02  +2.51491400E-01
   +3.76797700E-01
end_hess

