# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -731.07547760    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   +8.78228319E+00  -3.21952013E+00  +2.37751758E-01
   006   +6.63809414E+00  -1.81258023E+00  +2.25686042E-01
   006   +4.70059248E+00  -2.16312152E+00  +1.96530736E+00
   006   +2.56117584E+00  -6.68938176E-01  +1.84921900E+00
   006   +2.27857406E+00  +1.20292163E+00  +2.08291594E-02
   006   +4.23615459E+00  +1.51699135E+00  -1.70111943E+00
   006   +6.39535904E+00  +3.68746657E-02  -1.61215828E+00
   006   -1.08501917E-01  +2.83831881E+00  +3.05748860E-02
   006   -9.51727255E-03  +4.56274182E+00  +2.36302128E+00
   006   -3.00545652E-01  +4.53879761E+00  -2.31953449E+00
   006   -2.41848278E+00  +1.11399867E+00  +1.73749094E-02
   006   -4.42736266E+00  +1.38034682E+00  +1.73038822E+00
   006   -6.50500499E+00  -1.57700399E-01  +1.61844745E+00
   006   -6.71982041E+00  -2.11766359E+00  -2.71845113E-01
   006   -4.62157039E+00  -2.35218207E+00  -2.01348719E+00
   006   -2.58109790E+00  -7.97206467E-01  -1.84564226E+00
   008   -8.59431916E+00  -3.52180446E+00  -3.89305933E-01
   001   +4.86048882E+00  -3.61085355E+00  +3.40565051E+00
   001   +8.71465141E+00  -4.42865775E+00  +1.58052757E+00
   001   +1.06475096E+00  -9.89764374E-01  +3.20916207E+00
   001   +4.10556209E+00  +2.93713877E+00  -3.16326799E+00
   001   +7.90298825E+00  +2.99135147E-01  -2.96610283E+00
   001   +1.72604701E+00  +5.66933446E+00  +2.30916212E+00
   001   -1.59690074E+00  +5.87761886E+00  +2.40061449E+00
   001   -9.12735987E-03  +3.48256617E+00  +4.11679632E+00
   001   -2.53565406E-01  +3.45044805E+00  -4.06691219E+00
   001   -2.07499454E+00  +5.58358209E+00  -2.27091853E+00
   001   +1.23814666E+00  +5.90926725E+00  -2.35953585E+00
   001   -4.34167908E+00  +2.82105805E+00  +3.17524321E+00
   001   -8.05341199E+00  +3.84262125E-02  +2.93885933E+00
   001   -4.74556438E+00  -3.81487192E+00  -3.43618164E+00
   001   -1.01924309E+00  -1.03040258E+00  -3.14724471E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -2.79000000E-06  +5.23000000E-06  +3.10000000E-06
   +6.31000000E-06  -1.38000000E-06  +2.21000000E-06
   -2.11000000E-06  +9.90000000E-07  +2.41000000E-06
   -4.30000000E-07  +5.10000000E-07  +1.02000000E-06
   +7.80000000E-07  +1.64000000E-06  -2.72000000E-06
   -1.20000000E-07  +5.30000000E-07  +3.02000000E-06
   +2.21000000E-06  +3.80000000E-07  +4.60000000E-06
   -5.30000000E-07  -1.30000000E-07  +1.65000000E-06
   -3.60000000E-06  -2.33000000E-06  +3.10000000E-07
   +1.15000000E-06  -4.70000000E-07  +2.45000000E-06
   +5.80000000E-07  +9.20000000E-07  -2.27000000E-06
   -3.87000000E-06  -3.94000000E-06  -2.55000000E-06
   +3.21000000E-06  +1.30000000E-06  -4.10000000E-06
   -8.05000000E-06  -7.86000000E-06  -5.30000000E-06
   +6.32000000E-06  +2.52000000E-06  -3.76000000E-06
   -7.80000000E-07  -3.60000000E-06  -1.67000000E-06
   +7.41000000E-06  +2.59000000E-06  -5.97000000E-06
   -8.10000000E-07  -6.00000000E-08  +1.64000000E-06
   -1.65000000E-06  +2.03000000E-06  +3.67000000E-06
   -3.30000000E-06  +1.60000000E-07  +1.01000000E-06
   -2.50000000E-07  +1.78000000E-06  +2.47000000E-06
   +2.37000000E-06  +2.62000000E-06  +3.83000000E-06
   -2.16000000E-06  -3.20000000E-07  +2.65000000E-06
   -2.45000000E-06  -7.10000000E-07  +8.50000000E-07
   -2.46000000E-06  -2.51000000E-06  +1.25000000E-06
   +2.95000000E-06  +1.77000000E-06  -7.00000000E-08
   +3.30000000E-07  +3.90000000E-07  +3.10000000E-07
   -3.00000000E-07  +1.63000000E-06  +2.71000000E-06
   -1.23000000E-06  -8.70000000E-07  -2.12000000E-06
   -2.05000000E-06  -2.93000000E-06  -5.09000000E-06
   +2.68000000E-06  -3.20000000E-07  -4.41000000E-06
   +2.68000000E-06  +4.20000000E-07  -1.14000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.32481200E-01  -1.49590390E-01  +4.02693180E-01  -5.28512300E-02  -2.98433940E-01
   +3.84049290E-01  -2.44646550E-01  +1.28769820E-01  +2.10232000E-03  +6.05007660E-01
   +9.60893500E-02  -1.41315550E-01  +3.72871600E-02  -1.58887230E-01  +4.83625600E-01
   +3.70070900E-02  +1.46031600E-02  -8.56351400E-02  -1.38585520E-01  -2.34335520E-01
   +5.15135150E-01  -4.30436000E-02  +6.60870000E-03  +3.00132000E-02  -2.10830510E-01
   +2.00993800E-02  +7.80833500E-02  +5.91360050E-01  +3.14743200E-02  +4.77979000E-03
   -1.67279700E-02  -3.25070400E-02  -1.14034800E-01  +7.10346900E-02  -1.75619160E-01
   +4.79173610E-01  +3.28035000E-03  +7.76580000E-04  +6.79631000E-03  +1.34499640E-01
   +3.39511800E-02  -2.00544360E-01  -1.36367010E-01  -2.56836530E-01  +4.98299140E-01
   +3.33440000E-03  +2.39736000E-03  +2.37400000E-04  -4.93533600E-02  -8.63044000E-03
   +4.55738100E-02  -2.70155610E-01  +1.49032200E-01  -1.32173600E-02  +6.32098780E-01
   -3.12020000E-03  +6.75490000E-04  +9.36062000E-03  +2.85523100E-02  +3.80518600E-02
   -5.85314400E-02  +1.05074920E-01  -1.73804310E-01  +4.96148100E-02  -1.54841200E-01
   +4.47395850E-01  +6.09971000E-03  +5.50995000E-03  -2.99774000E-03  +5.18530000E-03
   -3.27366000E-02  +3.40230100E-02  +3.42251600E-02  +1.89620600E-02  -1.03897230E-01
   -1.70940700E-01  -2.17508610E-01  +4.95743490E-01  -2.63625000E-03  +3.19075000E-03
   -2.60485000E-03  -8.52610000E-03  -1.94168400E-02  +2.33296200E-02  +2.04155900E-02
   +1.60568600E-02  -2.60541900E-02  -1.18838130E-01  +5.03261500E-02  -2.01470300E-02
   +5.56439900E-01  +2.64884000E-03  +2.45320000E-04  -3.50579000E-03  -2.02650700E-02
   -2.33804100E-02  +3.30870700E-02  +5.00465800E-02  -2.68417400E-02  +3.04020000E-03
   +6.96603000E-03  -1.97748310E-01  +1.32019240E-01  -1.13908270E-01  +4.40093840E-01
   -2.92094000E-03  -3.21950000E-03  +4.30135000E-03  +2.47845000E-02  +3.26342000E-02
   -5.85130200E-02  -6.42711800E-02  +2.67325300E-02  +2.41281000E-02  +2.78922800E-02
   +1.01824270E-01  -1.99026750E-01  -1.41563910E-01  -1.92038370E-01  +4.92656270E-01
   +1.11269000E-03  -5.22241000E-03  +8.58427000E-03  +2.45754900E-02  +5.24017500E-02
   -7.29578700E-02  -6.14295800E-02  +1.70234500E-02  +2.21227200E-02  +3.88421200E-02
   -5.81562900E-02  +4.24727100E-02  -2.26332810E-01  +2.24652600E-02  +8.86378200E-02
   +5.82669300E-01  -8.86500000E-04  +2.97606000E-03  +2.94425000E-03  +1.54944700E-02
   -3.06169300E-02  +2.45022600E-02  +1.41354100E-02  -7.17923000E-03  -5.99562000E-03
   -2.43092600E-02  +1.11811200E-02  +1.39339500E-02  -2.08193600E-02  -1.06369010E-01
   +5.74983300E-02  -1.61814400E-01  +4.78880770E-01  +3.63595000E-03  +6.11474000E-03
   -4.05595000E-03  -3.23051500E-02  -1.22617000E-03  +2.59432100E-02  +2.45189700E-02
   -7.75991000E-03  -1.23295300E-02  +5.77157000E-03  +3.72668300E-02  -3.59399400E-02
   +1.35645950E-01  +2.80144300E-02  -1.92707760E-01  -1.34331330E-01  -2.51708040E-01
   +5.13324900E-01  -7.49734000E-03  +4.18032200E-02  -3.46273100E-02  -1.18845690E-01
   -7.44070000E-03  +4.18205900E-02  +3.89732100E-02  -2.35103500E-02  +3.80814000E-03
   -2.12835800E-02  +2.86029900E-02  -1.82385100E-02  -4.53315300E-02  -5.80228000E-03
   +4.32951900E-02  -2.67625880E-01  +1.44157880E-01  -1.05122900E-02  +6.35581680E-01
   +1.75407600E-02  -2.78272000E-02  +2.61665600E-02  +4.17174700E-02  -1.96725770E-01
   +1.06479950E-01  -5.30037400E-02  +1.32945400E-02  +3.19632700E-02  +2.62695600E-02
   -4.24878300E-02  +2.47713200E-02  +2.70676700E-02  +3.51711700E-02  -4.88637700E-02
   +1.00203620E-01  -1.70405300E-01  +4.81149300E-02  -1.63433640E-01  +4.47894710E-01
   -8.28088000E-03  +8.93210000E-03  +3.71426000E-03  -1.17189300E-02  +1.41320520E-01
   -2.16521460E-01  +3.60789300E-02  +1.10842500E-02  -2.91663300E-02  -1.57211500E-02
   +2.30277100E-02  -1.71913500E-02  +7.60040000E-03  -2.63925900E-02  +2.99680700E-02
   +3.70166400E-02  +1.76124600E-02  -1.05639850E-01  -1.79906970E-01  -2.30588910E-01
   +5.07972050E-01  +1.44416000E-03  -1.01370000E-03  -2.63040000E-04  -2.23327000E-03
   -4.77620000E-04  +1.34851000E-03  +4.35221000E-03  -1.21090000E-04  +1.16204000E-03
   -4.44387000E-03  +8.31123000E-03  -5.17096000E-03  -1.42153370E-01  +4.19165600E-02
   +6.84323000E-03  -1.90819700E-02  +1.33422400E-02  +9.85260000E-04  +5.05800000E-04
   +6.85900000E-04  +3.96444000E-03  +4.72218990E-01  -7.72570000E-04  +2.59190000E-04
   -4.25710000E-04  +3.98330000E-04  -8.39520000E-04  +2.07900000E-04  -8.87000000E-06
   +1.08919000E-03  +4.46681000E-03  +2.06108800E-02  -1.47531100E-02  +1.40082000E-03
   +4.66815700E-02  -1.06422070E-01  +6.34803000E-03  +5.07930000E-04  +5.95975000E-03
   -3.34712000E-03  -2.96120000E-04  +3.16207000E-03  +3.95480000E-03  +2.12546000E-03
   +4.77124760E-01  +5.85290000E-04  -1.03627000E-03  +1.14330000E-04  +3.00000000E-06
   +8.52120000E-04  -1.42155000E-03  +1.31895000E-03  +5.40559000E-03  -1.43433000E-03
   -2.01363500E-02  +1.15569800E-02  +3.93501000E-03  +3.34441000E-03  +8.88076000E-03
   -8.10809500E-02  +1.37192400E-02  -1.23263400E-02  +4.33312000E-03  +4.05399000E-03
   +2.98398000E-03  +4.44600000E-04  +4.22400000E-04  +8.62516000E-03  +4.76346500E-01
   -1.25261000E-03  +9.56780000E-04  -1.49660000E-04  +6.56800000E-04  -7.40300000E-04
   +4.73340000E-04  -2.35480000E-04  -6.61880000E-04  +1.66900000E-04  -4.16920000E-04
   +8.06150000E-04  +9.07290000E-04  -3.48945000E-03  +1.84118200E-02  +2.32003800E-02
   -6.83860000E-04  +1.94163000E-03  -8.40840000E-04  -1.39234000E-03  -2.12630000E-04
   -1.15958000E-03  -7.65064100E-02  +2.36390000E-04  +2.72620000E-04  +5.87835830E-01
   +5.19260000E-04  -4.44250000E-04  +1.04490000E-04  -1.74270000E-04  +5.31840000E-04
   -4.99140000E-04  -3.89800000E-05  +7.22150000E-04  -2.30800000E-05  +3.83300000E-04
   -3.77450000E-04  -1.13175000E-03  +8.22517000E-03  -1.80061300E-02  -1.73543300E-02
   -1.42264000E-03  -1.09685000E-03  +6.88890000E-04  +7.55090000E-04  -1.59520000E-04
   +8.87680000E-04  -4.22776000E-03  -1.09207960E-01  -4.88360500E-02  -3.86406000E-03
   +5.40078960E-01  -5.30590000E-04  +3.93230000E-04  -1.17250000E-04  +2.10410000E-04
   -2.49450000E-04  +3.57930000E-04  +2.47830000E-04  +5.59500000E-05  -1.88680000E-04
   -1.65505000E-03  +1.10026000E-03  -1.76860000E-04  +7.52352000E-03  -7.35901000E-03
   -1.94611000E-03  -7.56910000E-04  +2.06850000E-04  -1.18170000E-04  -1.42750000E-04
   +2.99410000E-04  -1.59680000E-04  -4.20546000E-03  -4.53099800E-02  -1.39848570E-01
   -7.00562000E-03  -6.31098600E-02  +5.14225560E-01  -5.48040000E-04  +3.72650000E-04
   -2.35500000E-05  +4.22430000E-04  -1.74960000E-04  +1.76600000E-05  +2.38500000E-04
   +1.16958000E-03  -8.84350000E-04  -5.04136000E-03  +2.34170000E-03  +1.22557000E-03
   -2.07551000E-03  +1.84755300E-02  -2.45353200E-02  -1.47415000E-03  +8.63700000E-04
   -5.16840000E-04  +2.49230000E-04  +4.01520000E-04  -7.58880000E-04  -7.47787600E-02
   -9.68510000E-04  +4.93750000E-04  +5.55470000E-04  +3.38670000E-04  -1.20324000E-03
   +5.84830940E-01  -2.88800000E-05  -1.95300000E-05  +1.93700000E-05  +2.06090000E-04
   +1.26530000E-04  +2.73700000E-05  -3.11160000E-04  -4.77430000E-04  +6.45760000E-04
   +3.00762000E-03  -4.45890000E-04  -4.58260000E-04  +5.91174000E-03  -1.42647300E-02
   +1.68357500E-02  +3.12000000E-05  -4.54200000E-04  -6.35580000E-04  -4.90610000E-04
   -4.64680000E-04  +6.53110000E-04  +7.10857000E-03  -1.07232550E-01  +4.74322400E-02
   -5.34400000E-04  +1.06326400E-02  -1.46464200E-02  +5.58283000E-03  +5.39322610E-01
   +2.93830000E-04  -1.86240000E-04  -3.31500000E-05  -2.37380000E-04  +4.61100000E-05
   +2.78550000E-04  +4.68890000E-04  -1.54970000E-04  +9.34200000E-05  +1.14524000E-03
   -7.76440000E-04  +4.78100000E-05  -4.48678000E-03  +2.04204000E-03  -2.81390000E-04
   +1.15181000E-03  -8.70320000E-04  +1.91080000E-04  +2.10870000E-04  +7.17000000E-06
   -2.15450000E-04  -8.13485000E-03  +4.10200600E-02  -1.35816880E-01  -1.79015000E-03
   +1.43482000E-02  -3.71131500E-02  -1.05853600E-02  +6.55316000E-02  +5.09841470E-01
   +6.08660000E-04  -4.79590000E-04  -2.13600000E-05  -5.07040000E-04  +3.66730000E-04
   +1.18650000E-04  +3.80520000E-04  -4.41440000E-04  +5.19590000E-04  -2.59380000E-04
   -5.62940000E-04  -5.47990000E-04  -3.63504500E-02  -1.00382900E-02  +3.89376000E-03
   -1.40155000E-03  +8.57730000E-04  -1.67376000E-03  +1.07920000E-04  +3.94710000E-04
   +9.13730000E-04  -1.39587470E-01  -4.73945400E-02  +1.02278000E-03  -1.42247000E-03
   -5.79152000E-03  -5.09523000E-03  -1.04245000E-03  -7.53872000E-03  +9.48071000E-03
   +5.14745460E-01  +1.32650000E-03  -1.12073000E-03  +1.82480000E-04  -6.72450000E-04
   +1.27679000E-03  -6.37790000E-04  -1.48390000E-04  -2.68750000E-04  +1.68100000E-05
   +3.04270000E-03  -3.21060000E-04  +8.93500000E-05  +8.95119000E-03  +1.41017800E-02
   -1.02525000E-03  +1.40926000E-03  -2.31664000E-03  +1.26859000E-03  +7.98850000E-04
   -1.29294000E-03  -4.62390000E-04  -4.51700800E-02  -1.11024780E-01  -1.38587400E-02
   -1.76842100E-02  -1.60168000E-02  -2.15622000E-03  -1.59876600E-02  -1.87917600E-02
   +9.96433000E-03  +1.08231720E-01  +4.15215100E-01  +5.45000000E-06  +1.47000000E-06
   +8.91000000E-05  +1.49100000E-04  +2.78590000E-04  -4.42430000E-04  -4.83470000E-04
   -1.04160000E-04  +2.96900000E-05  -1.42873000E-03  +5.25960000E-04  +5.94780000E-04
   +3.64681000E-03  +2.24639000E-03  -9.45950000E-04  +1.64220000E-04  -5.75060000E-04
   +2.45950000E-04  +2.95350000E-04  -4.49080000E-04  -1.35460000E-04  +7.11025000E-03
   -9.79534000E-03  -8.21115700E-02  -2.38329400E-02  -1.79797400E-02  +4.10680000E-04
   +2.23937500E-02  +1.90077100E-02  -2.57776000E-03  -1.28314110E-01  +1.54935790E-01
   +4.36323500E-01  -5.13720000E-04  +3.51300000E-04  +1.00000000E-05  +5.09740000E-04
   -1.51980000E-04  -3.51900000E-04  -5.44270000E-04  +1.56650000E-04  +3.44630000E-04
   +5.10350000E-04  +1.05970000E-04  +1.95270000E-04  -4.29880000E-04  -1.24577000E-03
   -1.31700000E-05  -7.49240000E-04  +6.85330000E-04  +9.23300000E-05  +8.36200000E-05
   -5.39200000E-05  +1.93660000E-04  -1.60467700E-02  -3.19394000E-03  +1.46838500E-02
   -1.79481000E-03  -4.93500000E-05  +1.49708000E-03  -2.31519000E-03  +8.19350000E-04
   -1.51222000E-03  -1.82693880E-01  -3.00938800E-02  +5.45166800E-02  +5.23769000E-01
   -4.61890000E-04  +3.19540000E-04  -4.47900000E-05  +4.39210000E-04  -1.82070000E-04
   -1.23780000E-04  -3.91070000E-04  +2.25150000E-04  +1.53610000E-04  +2.57770000E-04
   +3.21600000E-05  +2.59660000E-04  -1.15362000E-03  -3.13804000E-03  +7.05380000E-04
   -8.00600000E-04  +8.22020000E-04  -2.88950000E-04  -6.39100000E-05  +1.04910000E-04
   +2.36930000E-04  -1.50320000E-02  +8.30214000E-03  +1.09951900E-02  -1.00174000E-03
   -6.92970000E-04  +1.09142000E-03  -1.28670000E-03  -7.67100000E-04  -4.10100000E-04
   +2.64703200E-02  -1.08241280E-01  -6.43454400E-02  +1.65003570E-01  +4.93082410E-01
   -2.85900000E-05  +2.22500000E-05  +9.16000000E-06  -1.14520000E-04  -4.73700000E-05
   +1.66420000E-04  +1.92650000E-04  -1.74220000E-04  +3.13300000E-05  -3.49200000E-04
   +1.82690000E-04  -6.91890000E-04  -1.67241000E-03  -5.96550000E-04  +1.06450000E-04
   +8.31000000E-05  +3.89000000E-06  +1.31640000E-04  -1.21980000E-04  +2.44540000E-04
   +6.33800000E-05  +2.65801000E-03  +1.90876000E-03  +6.63663000E-03  -7.86960000E-04
   +9.06330000E-04  -1.62100000E-05  -1.38109000E-03  -9.35330000E-04  -1.41000000E-04
   +1.13483500E-01  -2.51440200E-02  -1.71268910E-01  -1.12234630E-01  +2.58953940E-01
   +4.81898390E-01  +2.16110000E-04  -1.60040000E-04  -3.23300000E-05  -1.68180000E-04
   +9.38000000E-05  +9.90300000E-05  +2.40690000E-04  +7.00900000E-05  -2.02120000E-04
   -9.62800000E-05  -1.81820000E-04  +1.04900000E-04  -3.68430000E-04  -4.64970000E-04
   +2.41660000E-04  +9.09500000E-05  -4.20500000E-05  -7.51300000E-05  +1.76600000E-05
   +3.60000000E-07  -7.24000000E-06  +1.64410000E-04  +1.19959000E-03  +3.55383000E-03
   +3.78540000E-04  +5.28690000E-04  -1.24600000E-05  -5.92660000E-04  -5.40750000E-04
   +3.51750000E-04  -5.91638000E-02  +1.15772000E-03  +4.72267400E-02  -2.58754850E-01
   -1.56821430E-01  -1.76814300E-02  +6.37581350E-01  +9.90000000E-05  -3.80200000E-05
   -2.54000000E-05  -1.54050000E-04  -6.08000000E-05  +1.45090000E-04  +2.46790000E-04
   +2.38800000E-05  -1.65960000E-04  -2.48640000E-04  -8.85100000E-05  +1.88840000E-04
   -6.81030000E-04  -5.20590000E-04  +3.81130000E-04  +6.01500000E-05  -5.13800000E-05
   -2.04410000E-04  -6.02100000E-05  +1.35710000E-04  +1.68000000E-06  -2.01420000E-04
   +2.84785000E-03  -3.01931000E-03  -2.79730000E-04  -5.74240000E-04  -2.18900000E-04
   +7.60290000E-04  +6.32500000E-05  +1.98510000E-04  -3.50940100E-02  +2.37328700E-02
   +4.35544800E-02  -1.10658150E-01  -1.90430650E-01  -5.83167900E-02  +1.72926560E-01
   +4.11862380E-01  +2.16200000E-05  -9.70000000E-06  +2.03700000E-05  -3.52900000E-05
   +1.42200000E-05  +2.51000000E-05  +1.46200000E-05  -3.90000000E-05  +1.04900000E-05
   +9.22400000E-05  +1.46320000E-04  -1.70710000E-04  +7.72920000E-04  +7.75370000E-04
   -1.25690000E-04  +1.96740000E-04  -1.59720000E-04  +1.39450000E-04  -2.69900000E-05
   -1.82900000E-05  -7.59300000E-05  +3.81780000E-03  -3.75301000E-03  -3.46310000E-04
   -6.09560000E-04  -7.56120000E-04  -2.38250000E-04  -7.29900000E-04  -6.35740000E-04
   -1.33700000E-05  +9.41078000E-03  +1.86815800E-02  +1.68554300E-02  +2.95725300E-02
   -2.61516500E-02  -1.05144930E-01  -1.89521610E-01  +1.76570310E-01  +4.44001790E-01
   +1.24030000E-04  -2.91200000E-05  +9.95000000E-06  -2.26550000E-04  -5.40800000E-05
   +1.73190000E-04  +1.58740000E-04  -1.52800000E-05  -7.83300000E-05  -2.50250000E-04
   +2.80000000E-05  -1.09080000E-04  -1.70010000E-04  -1.57250000E-04  -1.75300000E-05
   +2.41480000E-04  -1.77220000E-04  -1.22280000E-04  -1.01210000E-04  +2.28910000E-04
   -4.18200000E-05  -2.21977000E-03  -6.55920000E-04  +8.86480000E-04  +1.90720000E-04
   -8.92500000E-05  -4.55400000E-05  -3.75170000E-04  -2.99280000E-04  -6.05170000E-04
   +9.77448000E-03  +2.18793900E-02  +9.92220000E-03  -1.44785600E-02  -2.73935800E-02
   -1.43926000E-02  -8.77312000E-02  +3.41068000E-02  +4.26879200E-02  +5.91798270E-01
   -4.08800000E-05  +3.68200000E-05  -1.09000000E-05  +1.96700000E-05  -8.19100000E-05
   +1.38690000E-04  +7.05000000E-05  -9.38100000E-05  -2.99800000E-05  -2.40240000E-04
   -3.66510000E-04  +1.60200000E-05  -4.14350000E-04  +2.83790000E-04  -3.42210000E-04
   +3.72010000E-04  -1.86330000E-04  -2.50490000E-04  -6.79200000E-05  +1.26190000E-04
   -1.07940000E-04  -7.15200000E-04  -1.02041000E-03  +1.05800000E-04  -4.36100000E-05
   +1.77630000E-04  +2.42400000E-05  -5.52100000E-05  +1.21920000E-04  -2.51490000E-04
   +1.98950200E-02  +2.55880000E-04  -3.15399000E-03  -4.16444300E-02  -2.25016100E-02
   +1.00842000E-03  +2.19868300E-02  -1.24172880E-01  -6.40655400E-02  +1.82744130E-01
   +4.60544460E-01  -1.27300000E-05  -4.51000000E-06  -1.49100000E-05  +8.75900000E-05
   +2.92600000E-05  -8.50300000E-05  -7.23300000E-05  +3.01000000E-05  -2.93000000E-06
   +1.69000000E-05  -1.35150000E-04  +1.87040000E-04  +2.24440000E-04  +3.40660000E-04
   -1.35870000E-04  -1.09430000E-04  +1.20000000E-06  +1.36700000E-05  +1.11230000E-04
   -1.38670000E-04  -1.72700000E-05  +3.13780000E-04  -1.12510000E-04  -9.82470000E-04
   +3.17000000E-05  -3.91200000E-05  +1.97520000E-04  +1.99480000E-04  +2.66550000E-04
   +3.87850000E-04  +7.06809000E-03  -5.03189000E-03  -1.98087000E-02  -2.93335700E-02
   -9.11287000E-03  +1.63620800E-02  +3.00520500E-02  -7.26222300E-02  -1.75279380E-01
   -1.03352650E-01  +1.58440920E-01  +4.21245670E-01  +2.72040000E-04  -2.75700000E-04
   +3.97800000E-05  -4.89000000E-06  +4.72820000E-04  -5.22230000E-04  -3.98280000E-04
   +2.44050000E-04  +1.56220000E-04  +6.92220000E-04  +6.30000000E-06  +3.47570000E-04
   +6.08380000E-04  +6.89400000E-04  -1.91900000E-04  -5.92200000E-04  +3.18900000E-04
   +4.07230000E-04  +4.05750000E-04  -6.47500000E-04  +1.78330000E-04  +3.64534000E-03
   +7.50190000E-04  +5.02450000E-04  +5.44290000E-04  +2.20730000E-04  +2.56510000E-04
   +7.32100000E-04  +5.86200000E-04  +9.62170000E-04  +1.23980000E-02  -4.90867500E-02
   -5.73654600E-02  -3.37186500E-02  -8.02318000E-03  +1.36130700E-02  +1.90233300E-02
   +1.36210700E-02  +1.03574600E-02  -1.15352750E-01  +3.95015700E-02  +6.83887800E-02
   +5.54659840E-01  +4.48240000E-04  -3.61130000E-04  +4.86800000E-05  -3.22280000E-04
   +4.25250000E-04  -3.65900000E-04  -2.09420000E-04  +2.57280000E-04  +8.23200000E-05
   +4.92000000E-04  +3.45520000E-04  +1.62660000E-04  +9.67990000E-04  +3.62570000E-04
   +3.28320000E-04  -5.12490000E-04  +3.04410000E-04  +4.90800000E-04  +2.00850000E-04
   -3.86680000E-04  +1.97760000E-04  +1.41503000E-03  +2.67980000E-04  -5.78036000E-03
   -9.79140000E-04  -6.03500000E-04  +2.50960000E-04  +1.13030000E-03  +1.02523000E-03
   +3.23390000E-04  -1.62888600E-02  -3.81817100E-02  -3.43362100E-02  -1.65361800E-02
   -6.10248000E-03  +6.96027000E-03  +2.16868200E-02  +1.05575200E-02  -1.87698700E-02
   +2.94816400E-02  -9.84027500E-02  -4.22183800E-02  +2.04024980E-01  +5.08509050E-01
   +2.35260000E-04  -1.64440000E-04  +1.57800000E-05  -2.88930000E-04  +4.97700000E-05
   +1.18010000E-04  +2.31050000E-04  -9.97400000E-05  -1.50720000E-04  -1.66900000E-04
   +3.14850000E-04  -1.72230000E-04  +7.32980000E-04  -3.27400000E-05  +1.25350000E-04
   +8.75000000E-05  +2.68100000E-05  +2.02130000E-04  -1.48040000E-04  +1.09180000E-04
   +2.89900000E-05  +1.66956000E-03  -3.98668000E-03  -2.29566000E-03  -9.86470000E-04
   -6.94490000E-04  +2.21180000E-04  +1.58790000E-04  +7.01000000E-05  -3.25470000E-04
   -2.14950700E-02  -1.06764100E-02  +1.09802300E-02  +5.35665000E-03  +1.35119000E-03
   -4.29180000E-03  +1.87722600E-02  -1.29398200E-02  -1.32476800E-02  +5.73475000E-02
   -4.95619800E-02  -1.70388650E-01  -9.39619800E-02  +2.53402460E-01  +4.53529270E-01
   -5.26690000E-04  +4.76130000E-04  -4.14400000E-05  +1.45700000E-04  -5.99660000E-04
   +6.35110000E-04  +5.09930000E-04  -2.86130000E-04  -1.26080000E-04  -1.55779000E-03
   -3.91100000E-04  -7.19230000E-04  -1.34411000E-03  -3.32153000E-03  -1.90945000E-03
   +9.61710000E-04  -5.05100000E-04  -9.57150000E-04  -4.66360000E-04  +9.50720000E-04
   -1.26740000E-04  -1.73320000E-03  -2.01338000E-02  -1.77729600E-02  -4.75941000E-03
   -3.09301000E-03  +1.29658000E-03  -1.38808000E-03  -1.23053000E-03  -2.11745000E-03
   -1.13358410E-01  +1.43609300E-02  +4.96645900E-02  +3.37432500E-02  +2.74394800E-02
   +1.08505400E-02  -1.34537200E-02  -1.10237600E-02  -3.29039000E-03  -4.43254100E-02
   -2.40324700E-02  +9.67234000E-03  -2.90367730E-01  -1.67896140E-01  -8.50028000E-03
   +6.45580920E-01  -6.24300000E-04  +5.64110000E-04  -8.23600000E-05  +4.04740000E-04
   -6.17470000E-04  +3.50170000E-04  +1.17220000E-04  +1.63300000E-05  -1.23350000E-04
   -5.12340000E-04  -5.15800000E-04  +4.13370000E-04  -4.39750000E-04  -1.16844000E-03
   -7.35290000E-04  +5.52210000E-04  -1.40040000E-04  -5.99880000E-04  -2.10830000E-04
   +4.62480000E-04  -3.18510000E-04  -8.88589000E-03  -1.47177700E-02  -1.23780300E-02
   -2.87469000E-03  -3.33900000E-04  +8.67260000E-04  -1.79836000E-03  -1.06587000E-03
   -1.77896000E-03  -3.69715300E-02  -1.57105780E-01  -6.52547700E-02  +5.25802400E-02
   +1.37425300E-02  -3.02100500E-02  -2.06537600E-02  -2.23926700E-02  -6.41418000E-03
   -3.99997200E-02  -1.88859000E-03  +2.10774700E-02  -1.24075860E-01  -1.91698670E-01
   -5.18030500E-02  +1.62535100E-01  +4.23013000E-01  -4.45630000E-04  +3.68160000E-04
   -8.71700000E-05  +3.50610000E-04  -4.63940000E-04  +4.13870000E-04  +3.14880000E-04
   -1.77070000E-04  -8.35400000E-05  -9.95520000E-04  -1.04821000E-03  -1.44040000E-04
   -1.16447000E-03  -1.05311000E-03  -2.04790000E-04  +7.52070000E-04  -2.89730000E-04
   -9.73680000E-04  -1.40630000E-04  +2.62360000E-04  -3.38770000E-04  -5.83149000E-03
   -2.48249000E-03  +5.60206000E-03  +1.46642000E-03  +4.90570000E-04  +2.83000000E-06
   -8.38500000E-05  +9.06600000E-05  -3.48480000E-04  -4.82724000E-03  -1.02647950E-01
   -1.69064650E-01  +3.68802200E-02  -1.29998100E-02  -3.13802300E-02  -1.34226200E-02
   -1.36744500E-02  -6.62286000E-03  -6.80042000E-03  +1.05450500E-02  +1.99866600E-02
   +3.64730900E-02  -2.09477700E-02  -1.04914880E-01  -1.87881500E-01  +1.81081320E-01
   +4.52094380E-01  -4.36840000E-04  +2.91040000E-04  -3.27800000E-05  +4.14240000E-04
   -2.08380000E-04  -4.11100000E-05  -1.79710000E-04  +1.01400000E-05  +1.10760000E-04
   +1.04320000E-04  -2.53700000E-05  +1.13830000E-04  +8.54100000E-05  -3.32110000E-04
   +5.40000000E-07  -1.40460000E-04  +1.39530000E-04  -9.49200000E-05  -3.40000000E-06
   +1.10400000E-05  -3.26200000E-05  +1.51838000E-03  +6.99310000E-04  -6.61300000E-05
   -3.41280000E-04  -7.47500000E-05  +1.26300000E-04  -3.27450000E-04  -6.72300000E-05
   +7.51700000E-05  -1.07730900E-02  -8.74173000E-03  -2.22608000E-03  +2.07063300E-02
   +5.16705000E-03  -7.27096000E-03  -2.06069400E-02  -5.80760400E-02  -3.31938100E-02
   -3.47105350E-01  -2.03248320E-01  -3.03386000E-03  -8.23051300E-02  -4.24358100E-02
   +2.72640400E-02  +8.09560000E-03  +1.97202600E-02  +1.68192600E-02  +4.32387320E-01
   -2.92780000E-04  +2.23590000E-04  -9.24000000E-06  +2.58480000E-04  -1.35720000E-04
   -5.53200000E-05  -1.52500000E-04  +4.67200000E-05  +1.09470000E-04  +1.25710000E-04
   +1.31870000E-04  +5.48600000E-05  +2.09910000E-04  -3.35210000E-04  +5.69900000E-05
   -1.93790000E-04  +1.56200000E-04  +1.38400000E-05  +8.80000000E-07  +1.10100000E-05
   +8.35000000E-06  +1.08362000E-03  +4.93300000E-04  +2.91820000E-04  -1.99790000E-04
   -1.19590000E-04  +8.51100000E-05  -2.60520000E-04  -1.00480000E-04  +2.51000000E-06
   -7.36580000E-03  -7.34266000E-03  -3.56985000E-03  +1.39435800E-02  +1.62961000E-03
   -1.14374000E-02  -5.48729400E-02  -5.03855800E-02  -3.13087000E-02  -2.05297230E-01
   -2.23581590E-01  -2.65276700E-02  -4.33020100E-02  +4.50980000E-03  +1.75980900E-02
   +9.01875000E-03  +1.55600600E-02  +6.51765000E-03  +2.87113510E-01  +2.61673960E-01
   +8.91000000E-06  -6.49000000E-06  +2.02300000E-05  -1.91300000E-05  +1.22600000E-05
   -2.90500000E-05  -2.11600000E-05  +9.58000000E-06  +3.03800000E-05  +7.88100000E-05
   +1.16730000E-04  -7.48400000E-05  +2.74600000E-05  -8.24900000E-05  +1.05250000E-04
   -4.58800000E-05  +5.40200000E-05  +5.93400000E-05  -2.21200000E-05  +9.67000000E-06
   +4.32800000E-05  -4.51000000E-05  +2.07230000E-04  +1.75790000E-04  +1.55600000E-05
   -2.15600000E-05  -3.30200000E-05  -4.60700000E-05  -3.74500000E-05  -1.11780000E-04
   +2.71240000E-04  -1.81477000E-03  -1.84939000E-03  +1.77840000E-03  -5.10429000E-03
   -3.70535000E-03  -2.98460600E-02  -2.90049300E-02  +8.63414000E-03  -5.36877000E-03
   -2.81789700E-02  -8.20005500E-02  +2.62142700E-02  +1.69456700E-02  +1.62774500E-02
   +5.81776000E-03  -9.23270000E-04  -2.17530000E-03  +6.27932000E-03  +4.14211300E-02
   +6.27658800E-02  +1.88466000E-03  -2.55807000E-03  -1.25355000E-03  +5.41358000E-03
   -1.57541800E-02  +1.59956700E-02  -5.69583600E-02  +2.06346000E-02  -5.90090000E-03
   +2.59282000E-03  +1.85203400E-02  -1.98793000E-02  -2.52767000E-03  +4.65487000E-03
   +2.03282000E-03  -1.59121000E-03  +2.29040000E-04  +2.19940000E-04  -2.24606000E-03
   +7.31310000E-04  +4.64381000E-03  +4.75170000E-04  +6.89810000E-04  -8.86040000E-04
   +7.20000000E-07  -6.66100000E-05  -1.04650000E-04  -3.84500000E-04  +1.30070000E-04
   +9.23900000E-05  +2.00450000E-04  +1.30490000E-04  +5.17000000E-06  -4.93500000E-05
   -4.80600000E-05  +5.04000000E-06  +1.33900000E-05  -7.15000000E-06  +6.09000000E-06
   -9.64000000E-06  +1.41800000E-05  -5.64000000E-06  +2.34500000E-05  +4.83000000E-06
   +1.92600000E-05  -4.89200000E-05  -6.03700000E-05  -1.86300000E-05  -2.51800000E-05
   -4.04200000E-05  +8.61000000E-06  +5.39452300E-02  -2.14517000E-03  +3.75710000E-04
   -3.01623000E-03  +4.81274000E-03  -1.41513000E-03  +2.60284000E-03  +2.08379500E-02
   -1.85164900E-01  +1.47908200E-01  -8.21280000E-04  -9.26975000E-03  +1.32787800E-02
   +4.93710000E-03  +2.72456000E-03  +1.57420000E-03  -9.30500000E-05  -1.24410000E-04
   -7.51140000E-04  +3.73260000E-04  +3.33307000E-03  +2.01406000E-03  -1.56920000E-04
   -9.65900000E-05  +8.32040000E-04  +5.78200000E-05  -9.09000000E-06  +2.21700000E-05
   +2.97690000E-04  -1.71710000E-04  -1.08230000E-04  -2.33290000E-04  -1.72440000E-04
   +2.04400000E-05  +6.50300000E-05  +7.11400000E-05  -2.21200000E-05  -2.19600000E-05
   -1.85900000E-05  -1.38600000E-05  -2.45800000E-05  +4.83000000E-06  +1.66800000E-05
   +1.38000000E-06  -2.68700000E-05  -1.44200000E-05  +2.34000000E-06  +4.96500000E-05
   +1.80100000E-05  +4.29700000E-05  +2.38000000E-05  -8.51000000E-06  -2.55286200E-02
   +1.91875260E-01  -1.78177000E-03  -2.67357000E-03  +2.71950000E-04  -5.89346000E-03
   +1.70388700E-02  -1.00098400E-02  -6.22509000E-03  +1.47873170E-01  -1.87936980E-01
   +8.71830000E-04  -3.35950000E-04  +2.31915000E-03  +1.52322000E-03  +2.10359000E-03
   +4.17170000E-03  +4.78440000E-04  -9.78430000E-04  -1.66700000E-04  +5.05413000E-03
   +1.74150000E-03  +4.11000000E-05  +3.48500000E-04  +1.35160000E-04  +1.00030000E-04
   -4.06100000E-05  -4.83000000E-06  -5.64100000E-05  -5.48100000E-05  -3.83600000E-05
   +1.65200000E-05  -6.09000000E-06  +5.98800000E-05  +4.58600000E-05  -1.64800000E-05
   -7.32000000E-06  -3.25600000E-05  +1.55000000E-05  -4.90000000E-06  -1.08300000E-05
   -2.33700000E-05  +8.85000000E-06  +1.57200000E-05  +4.77200000E-05  +1.92600000E-05
   +1.89700000E-05  -7.09800000E-05  -5.36700000E-05  -3.09100000E-05  -1.26300000E-05
   -3.01300000E-05  -4.55000000E-06  +5.97990000E-03  -1.62877790E-01  +1.93874820E-01
   -3.89810100E-02  -2.55007400E-02  +5.20542700E-02  -3.40595000E-03  +3.06317500E-02
   -3.24585300E-02  +1.55441000E-03  +5.16680000E-04  -2.28483000E-03  -6.20140000E-04
   +1.76020000E-04  -2.25270000E-04  -6.94800000E-05  -4.18300000E-04  +6.01440000E-04
   +1.48698000E-03  +9.18400000E-04  -8.02850000E-04  -5.30149000E-03  +3.53556000E-03
   +1.44763000E-03  -1.64660000E-04  -3.38000000E-05  +9.42600000E-05  +4.67200000E-05
   +4.62000000E-06  -1.12200000E-05  +7.59500000E-05  -2.00700000E-05  -2.12800000E-05
   -7.66200000E-05  -4.06800000E-05  +7.40000000E-06  +6.20500000E-05  +2.95900000E-05
   +6.04000000E-06  -3.59300000E-05  -2.93900000E-05  +1.01000000E-06  -4.73700000E-05
   +1.90000000E-06  +1.07500000E-05  -7.12000000E-06  -5.09600000E-05  -2.36700000E-05
   +2.11600000E-05  +1.61000000E-05  +4.36200000E-05  +6.73300000E-05  +2.73600000E-05
   -8.00000000E-08  -7.88980000E-04  -8.45690000E-04  +1.84697000E-03  +4.65224100E-02
   +7.72017000E-03  -2.40658850E-01  +2.48688090E-01  -6.64000000E-06  -2.23953300E-02
   +2.10578800E-02  -3.74746000E-03  +2.93091000E-03  -1.51155000E-03  -2.15700000E-05
   -9.88550000E-04  +4.03430000E-04  -5.83800000E-05  +5.00910000E-04  -4.82750000E-04
   -2.55490000E-04  +2.79390000E-04  +1.74041000E-03  +4.42595000E-03  +2.22970000E-04
   -1.03867000E-03  +1.65660000E-04  -8.44300000E-05  +9.76000000E-06  -8.85400000E-05
   +3.15000000E-05  -3.58600000E-05  -7.34100000E-05  -4.52000000E-06  +2.05900000E-05
   +9.68500000E-05  +1.81580000E-04  -1.60000000E-06  -8.00000000E-05  -5.87200000E-05
   -7.30000000E-07  +4.37100000E-05  +1.80700000E-05  -5.14000000E-06  +9.50000000E-06
   +2.78000000E-06  +2.87000000E-06  +4.96800000E-05  +6.58800000E-05  +3.63800000E-05
   -8.04100000E-05  -1.00160000E-04  -5.74500000E-05  -5.79500000E-05  -5.67800000E-05
   -1.68000000E-06  +1.01267000E-03  +1.78290000E-04  -3.16060000E-04  -8.81171000E-03
   +2.60027570E-01  +1.65221000E-02  +2.71778680E-01  -3.06375160E-01  +3.21630000E-04
   -2.90050000E-04  -2.74142000E-03  +2.29120000E-03  -4.48852000E-03  +2.28548000E-03
   -2.85000000E-06  +2.27140000E-04  -8.99370000E-04  +2.04420000E-04  -1.24610000E-04
   +1.96390000E-04  +4.26000000E-04  +9.67280000E-04  +4.08340000E-04  +4.41070000E-04
   -3.64940000E-04  +2.26302000E-03  -1.27790000E-04  +4.53300000E-05  -1.47390000E-04
   +1.25420000E-04  -7.17400000E-05  +5.71900000E-05  +2.15200000E-05  +6.70000000E-07
   -1.71100000E-05  -2.21500000E-05  -6.11400000E-05  +8.53000000E-06  +1.72700000E-05
   +2.49600000E-05  -6.27000000E-06  -2.60000000E-07  -4.60000000E-07  -1.17900000E-05
   -2.16300000E-05  +5.79000000E-06  +1.52600000E-05  -2.19000000E-06  -2.27000000E-05
   -1.48500000E-05  +8.73000000E-06  +2.36700000E-05  +4.05500000E-05  +3.19800000E-05
   +9.61000000E-06  -1.34600000E-05  -1.43710000E-04  +9.98810000E-04  -3.91400000E-04
   -2.00241400E-02  -2.67984040E-01  +3.05436900E-01  -1.43116000E-03  +1.32100000E-05
   +8.97840000E-04  -8.08610000E-04  +5.29684000E-03  +3.15680000E-04  -1.45440200E-02
   -5.30216000E-03  +1.84906300E-02  -2.03581100E-01  -2.59834500E-02  +1.40098220E-01
   +5.46096000E-03  +9.09040000E-04  -1.97800000E-03  +2.18455000E-03  +2.10665000E-03
   +6.57110000E-04  -2.23700000E-04  +1.84210000E-04  -9.05260000E-04  -6.10170000E-04
   -5.73510000E-04  -8.78170000E-04  -2.27400000E-05  +1.71270000E-04  +9.49000000E-05
   -2.39100000E-05  -1.39230000E-04  -6.46200000E-05  -5.87130000E-04  +5.10990000E-04
   -4.42910000E-04  -7.72600000E-05  +1.19420000E-04  -1.07990000E-04  -1.51280000E-04
   -1.01640000E-04  +2.20500000E-05  -1.47050000E-04  -7.73900000E-05  +1.65100000E-05
   +1.97780000E-04  +8.82600000E-05  -1.21400000E-05  -2.52610000E-04  +5.69000000E-06
   -2.28170000E-04  +1.06060000E-04  +8.99500000E-05  +1.08200000E-05  -5.80900000E-05
   -1.34661000E-03  -1.54289000E-03  +1.29260000E-04  -2.18650000E-04  +1.31110000E-04
   +2.14007190E-01  +8.72740000E-04  -1.22400000E-05  -7.27310000E-04  +4.99591000E-03
   +1.51929000E-03  +3.42289000E-03  +1.43319800E-02  +6.48603000E-03  -1.24772400E-02
   -2.64201800E-02  -5.84993200E-02  +3.86930200E-02  -1.72491700E-02  +1.90285000E-03
   +1.41518900E-02  +2.57205000E-03  -3.95420000E-04  +5.61149000E-03  +2.70030000E-04
   -1.11222000E-03  -2.81110000E-04  -1.52988000E-03  -8.75380000E-04  -1.26864000E-03
   +1.32270000E-04  -5.81170000E-04  +4.36450000E-04  -1.24490000E-04  +4.60000000E-07
   -9.80400000E-05  +3.96340000E-04  +5.06900000E-05  +1.20320000E-04  -1.29090000E-04
   -1.03690000E-04  +7.87600000E-05  +1.60950000E-04  +7.91500000E-05  -5.11000000E-05
   +6.19200000E-05  +1.19950000E-04  +1.62100000E-05  -1.84560000E-04  -2.30700000E-04
   +2.95900000E-05  +2.03280000E-04  +2.66260000E-04  +2.92990000E-04  -9.18000000E-05
   -1.40650000E-04  -3.90400000E-05  -1.69658000E-03  -1.45384000E-03  -2.07175000E-03
   -7.65600000E-05  +1.09140000E-04  -8.66300000E-05  +2.42087900E-02  +5.37631500E-02
   +8.42600000E-05  -1.58020000E-04  +1.60500000E-05  +7.29360000E-04  +3.16514000E-03
   +4.19240000E-03  -2.10937000E-03  +1.06768000E-03  +4.36975000E-03  +1.39875430E-01
   +3.78629900E-02  -1.75071820E-01  +1.72882000E-02  +1.99983000E-03  -9.81608000E-03
   +3.36830000E-04  +6.06192000E-03  -1.88650000E-04  -1.06263000E-03  -1.97430000E-04
   -2.89390000E-04  +5.12100000E-05  -2.00995000E-03  -1.11447000E-03  -4.42000000E-06
   -2.41700000E-05  -6.03400000E-05  -2.41570000E-04  -4.17300000E-05  -6.72300000E-05
   -6.35270000E-04  +5.15940000E-04  -6.43800000E-05  -1.64500000E-05  -8.45300000E-05
   +1.55680000E-04  -2.26350000E-04  -1.19020000E-04  +4.95200000E-05  +1.64600000E-05
   +7.92100000E-05  +4.70000000E-06  -1.74870000E-04  -2.32130000E-04  +8.51000000E-06
   +2.35600000E-04  -8.34100000E-05  -7.39600000E-05  +5.25500000E-05  +2.33400000E-05
   -2.62000000E-06  -1.26669000E-03  -2.32418000E-03  -1.19866000E-03  -3.56400000E-05
   +2.13800000E-05  -2.39600000E-05  -1.53886990E-01  -4.50421800E-02  +1.79774230E-01
   +2.23700000E-05  +9.68890000E-04  -1.04707000E-03  -2.20201000E-03  +4.64121000E-03
   +2.18174000E-03  -1.35905000E-03  +8.38700000E-05  +7.42700000E-05  -2.29168000E-03
   +1.00076000E-03  +5.14677000E-03  +7.38532000E-03  -1.61211700E-02  +1.54400200E-02
   -5.69387700E-02  +1.76345500E-02  -6.99477000E-03  +1.99481000E-03  +1.90729400E-02
   -1.92859600E-02  +9.73900000E-05  -1.34728000E-03  -1.22708000E-03  +3.14710000E-04
   +2.02500000E-05  -8.11700000E-05  -1.97414000E-03  +8.37370000E-04  +8.19190000E-04
   -2.01940000E-04  +9.48000000E-06  -1.28810000E-04  +3.63700000E-05  +1.24600000E-05
   -1.77000000E-05  +1.02600000E-05  -3.81000000E-06  +7.48000000E-06  -2.39600000E-05
   -2.21000000E-05  +3.77700000E-05  -1.30000000E-07  -2.62000000E-05  -6.62000000E-05
   -4.13600000E-05  +1.38560000E-04  +8.97200000E-05  +5.37800000E-05  +3.89600000E-05
   -1.53000000E-05  -7.17600000E-05  -2.18100000E-04  -2.18440000E-04  -3.42720000E-04
   +1.83220000E-04  -1.03070000E-04  +2.15700000E-04  -9.08670000E-04  +9.31460000E-04
   +5.76283800E-02  +1.41710000E-04  -7.64840000E-04  +7.67180000E-04  +4.72012000E-03
   +3.12780000E-03  +2.04597000E-03  -4.54700000E-05  -2.30100000E-04  -9.41540000E-04
   +9.36680000E-04  +3.66126000E-03  +2.59498000E-03  +5.61180000E-04  +1.18944000E-03
   +3.05607000E-03  +1.74650400E-02  -1.86744990E-01  +1.49081220E-01  -1.20700000E-05
   -8.50627000E-03  +1.36302600E-02  -7.19860000E-04  -2.30946000E-03  -1.22000000E-03
   +4.30180000E-04  -2.04880000E-04  -7.20100000E-05  +2.25368000E-03  -3.82980000E-04
   -2.46610000E-04  -2.20770000E-04  +4.26110000E-04  +2.51990000E-04  -9.61100000E-05
   -1.30270000E-04  -6.43900000E-05  +1.21900000E-05  -5.79000000E-06  +4.57000000E-06
   -4.67000000E-05  +1.36000000E-05  +5.72100000E-05  +8.79100000E-05  +4.23000000E-06
   -7.48300000E-05  -1.85480000E-04  +9.14000000E-06  +9.95600000E-05  +1.42500000E-05
   -1.08000000E-05  -2.75700000E-05  -1.92600000E-04  -3.64110000E-04  -2.50410000E-04
   +1.17430000E-04  -1.99100000E-04  -7.66100000E-05  +1.33130000E-04  -5.24100000E-05
   +4.63000000E-05  -2.55218600E-02  +1.94345710E-01  -1.71440000E-04  +1.96110000E-04
   -6.94400000E-05  +2.12077000E-03  +2.11677000E-03  +4.22099000E-03  +1.20800000E-04
   -1.00234000E-03  -1.12670000E-04  +5.25914000E-03  +2.30670000E-03  +3.71350000E-04
   -2.92464000E-03  +1.49559200E-02  -9.99726000E-03  -6.72182000E-03  +1.49189160E-01
   -1.97748400E-01  +1.53708000E-03  +1.98420000E-04  +2.77056000E-03  -2.16656000E-03
   -6.19930000E-04  -1.62400000E-03  +6.11840000E-04  -1.79590000E-04  +1.60800000E-05
   -6.32820000E-04  +8.29380000E-04  +3.84900000E-04  -1.87640000E-04  +2.25300000E-04
   +1.37850000E-04  -8.85000000E-05  -9.27000000E-05  -8.82000000E-06  +2.21400000E-05
   +3.32000000E-06  +3.50000000E-06  -3.49700000E-05  +1.86400000E-05  +1.05800000E-05
   +2.96600000E-05  -1.77000000E-06  -7.39000000E-06  -4.07700000E-05  -3.33200000E-05
   +5.56600000E-05  +5.50000000E-07  -2.14300000E-05  -7.46000000E-06  -2.47130000E-04
   -2.22120000E-04  -2.96250000E-04  -2.98400000E-05  -1.27420000E-04  -4.31700000E-05
   -1.94010000E-04  +7.84240000E-04  -6.38600000E-04  +6.20075000E-03  -1.65294090E-01
   +2.03333600E-01  +6.32100000E-05  -1.47903000E-03  -9.68190000E-04  +4.70402000E-03
   +2.43997000E-03  -2.17372000E-03  +1.81581000E-03  +2.05698000E-03  +5.32110000E-04
   -1.44510000E-04  +1.89210000E-04  -8.86000000E-04  -1.25977000E-03  +5.17178000E-03
   +3.89730000E-04  -1.34474000E-02  -5.47568000E-03  +1.72431100E-02  -2.07817770E-01
   -2.19854300E-02  +1.46156500E-01  -2.03130000E-04  -4.79620000E-04  +8.49610000E-04
   -2.16580000E-04  +8.50100000E-05  -9.26400000E-05  -1.51100000E-05  -1.06280000E-04
   +4.54000000E-05  +2.31600000E-05  +2.57050000E-04  +5.80100000E-05  -8.29200000E-05
   -9.32600000E-05  -2.02800000E-05  +1.62000000E-05  +5.48000000E-06  +1.05300000E-05
   +6.67000000E-06  +1.16100000E-05  +1.33700000E-05  +8.62000000E-06  +4.81000000E-06
   +1.11000000E-06  -5.77000000E-05  -2.86000000E-05  +9.64000000E-06  -2.87200000E-05
   -2.90800000E-05  -1.21300000E-05  +2.38220000E-04  +1.65800000E-05  -2.70050000E-04
   -8.39600000E-05  -2.08980000E-04  -1.11580000E-04  -1.60350000E-04  -2.47410000E-04
   -1.22190000E-04  -1.17900000E-04  -1.41315000E-03  -1.55623000E-03  +2.16748170E-01
   -1.29789000E-03  -3.31650000E-04  -2.59682000E-03  -1.75241600E-02  +2.76517000E-03
   +1.52673700E-02  +2.39342000E-03  -6.12980000E-04  +5.14804000E-03  +4.36650000E-04
   -1.28548000E-03  -8.13600000E-05  +4.81625000E-03  +1.35527000E-03  +2.86967000E-03
   +1.32760500E-02  +6.04507000E-03  -1.32845300E-02  -2.09558300E-02  -5.45893400E-02
   +3.57326000E-02  +5.96430000E-04  +4.54850000E-04  -3.31440000E-04  +5.64700000E-05
   +4.30500000E-05  +5.05200000E-05  -9.91800000E-05  +3.26700000E-05  -7.62200000E-05
   +1.51650000E-04  -2.62960000E-04  -4.07000000E-05  +1.81300000E-05  +5.96600000E-05
   -4.20000000E-07  +4.97000000E-06  +2.01500000E-05  -1.91300000E-05  +3.08000000E-06
   -1.99000000E-06  -1.47000000E-06  -2.55600000E-05  -1.53400000E-05  -8.26000000E-06
   +2.42100000E-05  +2.91000000E-05  +4.14700000E-05  +1.71600000E-05  +7.71000000E-06
   -3.88000000E-06  -9.04860000E-04  -1.74790000E-04  +6.94440000E-04  -1.39740000E-04
   -3.10500000E-05  -4.77470000E-04  -2.25660000E-04  -2.57420000E-04  -3.26930000E-04
   -1.77931000E-03  -1.45351000E-03  -2.06729000E-03  +2.11482200E-02  +4.82152600E-02
   -1.16815000E-03  -2.45252000E-03  -7.15800000E-05  +1.95517700E-02  +1.05559000E-03
   -9.64865000E-03  +1.34050000E-04  +5.41653000E-03  -2.79870000E-04  -1.20427000E-03
   +1.57830000E-04  -4.14150000E-04  +5.17120000E-04  +2.67121000E-03  +3.90832000E-03
   -3.07930000E-03  -2.41200000E-05  +4.68644000E-03  +1.45098020E-01  +3.65218600E-02
   -1.78098160E-01  -5.99700000E-05  +1.34450000E-04  +2.96770000E-04  -2.25900000E-05
   +6.62900000E-05  -1.00900000E-05  -3.75000000E-06  -5.50600000E-05  -4.73100000E-05
   +7.39900000E-05  -6.68100000E-05  -3.74000000E-06  +2.71000000E-06  +9.63000000E-06
   +5.32000000E-06  -6.90000000E-07  +3.70000000E-06  -3.52000000E-06  -2.30000000E-06
   +3.23000000E-06  +2.54000000E-06  -1.76600000E-05  -2.22700000E-05  -1.20700000E-05
   +1.06500000E-05  +2.20600000E-05  +2.78300000E-05  +1.45500000E-05  +4.09000000E-06
   -3.74000000E-06  +7.49280000E-04  +4.91100000E-05  -6.91560000E-04  -1.82750000E-04
   -4.30450000E-04  +3.99000000E-05  -1.31430000E-04  -3.11190000E-04  -2.80620000E-04
   -1.16728000E-03  -2.32623000E-03  -1.12866000E-03  -1.59126650E-01  -4.05079900E-02
   +1.81742110E-01  +3.60900000E-05  -4.23000000E-06  +2.44200000E-05  +1.09100000E-05
   +5.72400000E-05  -1.36090000E-04  -1.95340000E-04  -1.82900000E-05  -2.02400000E-05
   +3.03640000E-04  -2.09900000E-04  +1.98090000E-04  +8.15900000E-04  +1.35311000E-03
   +6.01200000E-05  +2.34260000E-04  -1.57580000E-04  +1.16070000E-04  +7.98300000E-05
   -7.67800000E-05  -5.86500000E-05  -1.39453000E-03  +3.54870000E-04  +8.19870000E-04
   -2.41819930E-01  -1.23084090E-01  +7.58442000E-03  -1.03730000E-04  +1.81830000E-04
   +3.42780000E-04  +5.82690000E-04  +2.42700000E-04  +2.32570000E-04  -2.41580000E-04
   +1.08840000E-04  +4.99640000E-04  +2.24570000E-04  -1.58440000E-04  -2.97700000E-04
   -6.72700000E-05  +9.99600000E-05  +1.06120000E-04  +3.40500000E-05  -3.84600000E-05
   -1.09370000E-04  +5.44900000E-05  +1.06830000E-04  +2.06500000E-04  -7.91600000E-05
   -1.32860000E-04  -7.33900000E-05  -2.25000000E-06  -1.05600000E-05  -1.08000000E-06
   -9.33000000E-06  -1.42000000E-06  -3.23000000E-06  +2.97200000E-05  +6.23300000E-05
   +2.16800000E-05  +2.63300000E-05  -2.00000000E-05  -5.70000000E-06  +2.11400000E-05
   -1.30600000E-05  +5.06000000E-06  +2.59234550E-01  -2.09000000E-04  +1.79850000E-04
   -1.00500000E-05  +2.30300000E-04  -1.20280000E-04  -1.02280000E-04  -8.13700000E-05
   +3.33200000E-05  +5.00500000E-05  +1.32740000E-04  -3.25010000E-04  +5.77620000E-04
   -1.18316000E-03  +5.77130000E-04  +2.27150000E-04  +3.19950000E-04  +1.24040000E-04
   -4.22400000E-05  +1.49560000E-04  -3.02200000E-05  -7.77100000E-05  -1.65370200E-02
   -1.26232200E-02  +2.43490000E-04  -1.21130180E-01  -1.22863160E-01  +5.95118000E-03
   +4.08610000E-04  +3.04700000E-04  +1.22641000E-03  +1.11273000E-03  -1.46692000E-03
   -3.70833000E-03  +2.49980000E-04  +6.55800000E-05  -4.77160000E-04  +3.84800000E-05
   +2.23490000E-04  +1.01930000E-04  +1.24580000E-04  -1.13100000E-05  -3.19800000E-05
   +7.59700000E-05  -2.74430000E-04  -2.21110000E-04  -1.23111000E-03  -3.30010000E-04
   +2.85680000E-04  -1.11360000E-04  -5.81100000E-05  +1.40800000E-05  -1.44600000E-05
   -7.03000000E-06  -1.50200000E-05  +9.22000000E-06  -3.86200000E-05  +9.63000000E-06
   -1.94900000E-05  +1.05190000E-04  -1.51470000E-04  -2.93900000E-05  -1.65100000E-05
   -5.51300000E-05  -4.47000000E-06  -9.23000000E-06  +2.70000000E-07  +1.33410440E-01
   +1.32887770E-01  -1.80300000E-04  +1.26110000E-04  +3.41000000E-06  +1.79010000E-04
   +2.71300000E-05  -2.13460000E-04  -4.11230000E-04  -9.33000000E-06  +1.05180000E-04
   +4.16290000E-04  -3.67300000E-05  -1.08750000E-04  -8.85310000E-04  +3.99980000E-04
   +6.25720000E-04  -8.30300000E-05  +1.39140000E-04  +1.89620000E-04  +1.67290000E-04
   -1.06940000E-04  -2.86200000E-05  -2.26005800E-02  -1.48094100E-02  -1.02545000E-03
   +9.37469000E-03  +7.05031000E-03  -4.67641500E-02  -1.13001000E-03  -8.25780000E-04
   +1.31368000E-03  +1.14907000E-03  -2.47386000E-03  -4.44363000E-03  +8.63080000E-04
   -3.31980000E-04  -5.07690000E-04  -1.78830000E-04  +9.30800000E-05  +3.03780000E-04
   +1.03380000E-04  +1.18300000E-05  -1.53380000E-04  +1.50880000E-04  -2.19250000E-04
   -2.67930000E-04  -1.47340000E-03  -9.64880000E-04  +4.00400000E-04  -6.80200000E-05
   +1.61600000E-05  +8.08500000E-05  +1.33800000E-05  +1.70400000E-05  +1.35000000E-06
   +1.52500000E-05  -1.29900000E-05  +1.78600000E-05  +3.13400000E-05  +3.53000000E-06
   +7.50800000E-05  +2.51000000E-05  +2.73000000E-06  -9.49300000E-05  -2.29000000E-06
   -9.31000000E-06  +8.35000000E-06  -9.41581000E-03  -2.84858000E-03  +5.18757700E-02
   -3.20760000E-04  +2.35730000E-04  -1.28100000E-05  +3.06960000E-04  -1.87390000E-04
   -3.80400000E-05  -2.15210000E-04  -1.61100000E-05  +6.93800000E-05  +2.56920000E-04
   -3.18170000E-04  +4.52890000E-04  +4.63780000E-04  +6.91710000E-04  +4.13910000E-04
   +6.06420000E-04  +1.53550000E-04  -1.83510000E-04  -3.58900000E-05  +8.92300000E-05
   -9.48700000E-05  +9.57470000E-04  -1.75365000E-03  -3.25990000E-04  -2.06486210E-01
   +1.30660970E-01  +1.24155000E-03  +3.43840000E-04  -3.27150000E-04  -2.97190000E-04
   -1.25800000E-04  -1.50100000E-05  +3.34330000E-04  -5.62850000E-04  -8.21260000E-04
   +5.62270000E-04  +8.00200000E-05  -1.81110000E-04  -2.61990000E-04  -1.38440000E-04
   +8.80100000E-05  +1.64100000E-05  +1.22500000E-05  -6.75000000E-06  +9.38000000E-06
   +1.26830000E-04  +1.31700000E-04  +4.62000000E-06  +3.67700000E-05  -3.47500000E-05
   -2.87100000E-05  -2.63100000E-05  +1.20500000E-05  -1.93600000E-05  +2.53100000E-05
   -4.38300000E-05  +2.05100000E-05  -5.10000000E-06  +2.42400000E-05  -2.37800000E-05
   -4.77600000E-05  -5.79400000E-05  +1.39400000E-05  -1.84000000E-05  +1.73000000E-06
   +1.47000000E-06  -1.93244100E-02  +1.80111000E-02  -4.03370000E-04  +2.24094430E-01
   +4.74940000E-04  -3.50760000E-04  +8.39000000E-05  -1.92160000E-04  +4.67510000E-04
   -4.49030000E-04  -2.30590000E-04  +1.41050000E-04  -3.07900000E-05  +3.27350000E-04
   -1.05820000E-04  -2.52680000E-04  -3.08080000E-04  -1.34392000E-03  -3.67530000E-03
   -3.97990000E-04  -4.91360000E-04  +3.04540000E-04  +6.14820000E-04  -3.09550000E-04
   +3.23330000E-04  +1.49840900E-02  -1.20315200E-02  +9.84870000E-04  +1.29474500E-01
   -1.53657940E-01  -1.30909000E-03  +2.18100000E-05  +5.42420000E-04  +1.49299000E-03
   +8.28440000E-04  +4.78370000E-04  +2.83870000E-04  +2.58500000E-04  -4.73190000E-04
   -9.25920000E-04  -3.76290000E-04  +3.18460000E-04  +5.19590000E-04  +1.36090000E-04
   -1.62730000E-04  -1.68790000E-04  +5.96800000E-05  +1.37410000E-04  +1.00920000E-04
   -2.73010000E-04  -1.10450000E-04  -1.16810000E-04  +4.69800000E-05  +1.86510000E-04
   +1.28510000E-04  +2.35000000E-05  -4.63800000E-05  +2.14200000E-05  -3.19400000E-05
   +4.28000000E-05  -3.98100000E-05  +4.89300000E-05  +2.05880000E-04  +9.74300000E-05
   -4.36500000E-05  -3.58700000E-05  -1.35730000E-04  +9.21900000E-05  +2.06000000E-06
   +4.00200000E-05  -1.35967400E-02  +1.22484600E-02  +6.48900000E-05  -1.42424350E-01
   +1.65085210E-01  +4.44200000E-04  -3.58220000E-04  +1.26600000E-05  -4.09150000E-04
   +6.75900000E-05  +1.61330000E-04  +6.18460000E-04  +6.05800000E-05  +5.68000000E-05
   +2.26100000E-05  +3.83010000E-04  -7.66200000E-05  -1.15446000E-03  -2.39806000E-03
   -3.83533000E-03  +5.30740000E-04  -5.96090000E-04  +1.46030000E-04  +1.63450000E-04
   +2.21500000E-04  +2.56640000E-04  +2.11023700E-02  -1.58720700E-02  -1.34581000E-03
   +9.03490000E-04  -1.53570000E-04  -4.85227200E-02  +1.16249000E-03  -7.92650000E-04
   +1.28344000E-03  +1.46330000E-04  +5.33730000E-04  +6.57000000E-04  -2.01680000E-04
   +3.78060000E-04  +3.90400000E-04  -1.59590000E-04  -2.01310000E-04  -1.33340000E-04
   -2.68300000E-05  +2.89800000E-05  +8.63900000E-05  +6.92200000E-05  +6.26500000E-05
   +6.16000000E-06  -2.10500000E-05  +1.99200000E-05  -2.03610000E-04  -1.05600000E-05
   -1.25100000E-05  -2.35300000E-05  +3.82000000E-05  -2.62400000E-05  +1.92500000E-05
   -6.45000000E-06  +2.98300000E-05  -4.82700000E-05  -2.54820000E-04  -3.78890000E-04
   -3.39600000E-05  -3.34400000E-05  -1.12570000E-04  -1.51630000E-04  +6.55600000E-05
   -3.07900000E-05  -6.56000000E-06  +1.14457000E-03  -8.78460000E-04  -9.67380000E-04
   -1.86213000E-03  +3.35735000E-03  +5.09941100E-02  +6.22400000E-05  -4.84800000E-05
   -2.62000000E-06  -1.33700000E-05  +1.29600000E-04  -1.04750000E-04  -2.70970000E-04
   +4.66600000E-05  -4.96300000E-05  -9.36300000E-05  +1.49680000E-04  +4.00900000E-05
   +4.81800000E-05  -6.45790000E-04  +5.13010000E-04  -2.04030000E-04  +7.82300000E-05
   +8.59800000E-05  +1.48860000E-04  -8.95500000E-05  +6.11700000E-05  -1.91154000E-03
   +8.45570000E-04  -1.36128000E-03  -4.71888400E-02  +4.63250000E-04  +2.99520000E-04
   -1.24000000E-06  -3.76100000E-04  -3.45790000E-04  +3.11470000E-04  +5.01070000E-04
   -4.18730000E-04  +2.17500000E-05  -4.15160000E-04  -6.44390000E-04  -1.57700000E-04
   +6.66700000E-05  +2.84590000E-04  +5.36400000E-05  -6.03200000E-05  -1.18520000E-04
   +3.30000000E-05  +7.86300000E-05  +5.80700000E-05  -5.25100000E-05  -5.66900000E-05
   -2.84200000E-05  +4.22600000E-05  +1.03720000E-04  +8.13700000E-05  +1.90800000E-05
   +1.44700000E-05  +1.88900000E-05  -1.24700000E-05  +2.24100000E-05  +7.60000000E-06
   +2.23670000E-04  +2.96210000E-04  +1.20140000E-04  +2.15800000E-05  -6.87000000E-06
   -6.25600000E-05  +2.40000000E-07  -6.98000000E-06  -7.61000000E-06  +7.84440000E-04
   -1.42622300E-02  +2.39484600E-02  +5.82110000E-04  +1.25492300E-02  -2.18650800E-02
   +4.78227200E-02  -1.49160000E-04  +8.88500000E-05  -1.31200000E-05  +1.29200000E-05
   -8.45100000E-05  +1.66850000E-04  +2.87000000E-06  -1.58100000E-04  +1.13890000E-04
   +4.04530000E-04  -2.08310000E-04  -6.58050000E-04  -5.22040000E-04  +9.91120000E-04
   +9.28600000E-05  +2.13800000E-04  +9.25000000E-06  +4.83800000E-05  -1.37650000E-04
   +1.30310000E-04  -1.22210000E-04  +5.08300000E-04  +1.05739500E-02  -1.70611600E-02
   +6.98540000E-04  -1.25372900E-01  +1.22937910E-01  -6.03300000E-05  -2.12305000E-03
   -2.84507000E-03  -1.39040000E-04  +9.41770000E-04  +5.58160000E-04  -4.65330000E-04
   +3.70630000E-04  +6.82500000E-05  -8.92600000E-05  -2.56890000E-04  -1.71080000E-04
   -1.52600000E-05  +2.36500000E-05  +1.36480000E-04  +7.27700000E-05  +5.85200000E-05
   -4.87000000E-06  +2.45640000E-04  -5.96100000E-05  -1.21500000E-05  -4.56000000E-06
   -2.47000000E-05  -3.47800000E-05  -2.90000000E-07  +2.00000000E-07  -2.33600000E-05
   +1.82200000E-05  -1.21400000E-05  +1.48500000E-05  +1.34880000E-04  -9.55720000E-04
   -1.91320000E-04  -2.65100000E-05  -1.55900000E-05  -8.64000000E-06  -1.22100000E-05
   -5.51000000E-06  -4.47000000E-06  +1.41145000E-03  -9.12249000E-03  +1.37135400E-02
   -1.93822000E-03  -1.03052300E-02  +1.61502400E-02  +2.39200000E-04  +1.34813930E-01
   -6.12900000E-05  +1.50000000E-05  -1.55300000E-05  -2.17330000E-04  -3.28770000E-04
   +4.33420000E-04  +5.56940000E-04  -3.01030000E-04  +2.19320000E-04  +1.46350000E-04
   +7.00910000E-04  -1.38390000E-04  -1.40626000E-03  +8.28410000E-04  +6.83000000E-04
   +7.94210000E-04  -6.52100000E-05  -2.36310000E-04  -4.35010000E-04  +3.65740000E-04
   -1.05640000E-04  +1.28950000E-04  +1.43996200E-02  -2.06068600E-02  +5.88290000E-04
   +1.20785850E-01  -2.39052690E-01  +4.13400000E-05  -4.71837000E-03  -4.04283000E-03
   +9.82820000E-04  +1.16988000E-03  +8.25270000E-04  +4.46520000E-04  -2.72530000E-04
   -5.26200000E-05  -3.67350000E-04  -8.12700000E-05  +2.81980000E-04  +2.06800000E-05
   +5.46600000E-05  -1.23330000E-04  +1.63030000E-04  +1.74370000E-04  +5.71700000E-05
   -9.17500000E-05  -4.93240000E-04  -5.15300000E-05  -1.53800000E-05  +3.68600000E-05
   +9.00600000E-05  +3.92900000E-05  +7.70000000E-07  -2.62000000E-06  +2.54600000E-05
   -1.29900000E-05  -2.33000000E-06  -2.16100000E-04  -5.57020000E-04  +2.37550000E-04
   -1.34830000E-04  -1.92900000E-05  +8.68400000E-05  -5.46000000E-06  -1.80900000E-05
   -2.13800000E-05  -1.61440000E-04  -2.22790000E-04  -1.29170000E-04  +9.05500000E-05
   -1.32331000E-03  +1.48019000E-03  -1.06710000E-04  -1.31233240E-01  +2.60879240E-01
   +1.08740000E-04  -1.12340000E-04  +3.86000000E-05  -8.25500000E-05  +2.09400000E-05
   +2.98700000E-05  +1.19170000E-04  -9.26300000E-05  +2.42400000E-05  -7.84400000E-05
   +5.82400000E-05  -3.03000000E-05  +3.16930000E-04  -4.79420000E-04  -3.62230000E-04
   -9.70300000E-05  +4.44940000E-04  -6.83170000E-04  -1.02830000E-04  -4.56600000E-05
   +2.47770000E-04  -1.91531000E-03  -1.54183000E-03  -1.87797000E-03  -3.78900000E-05
   +4.71160000E-04  -4.89520000E-04  -4.74589600E-02  +3.20306000E-03  +5.62901000E-03
   +5.38500000E-05  +5.45370000E-04  +6.29890000E-04  -1.44440000E-04  -9.87700000E-05
   +7.56600000E-05  +1.04690000E-04  +1.26700000E-05  -2.46000000E-06  +1.41200000E-05
   +4.11400000E-05  +8.55300000E-05  -2.84540000E-04  -1.08570000E-04  -7.23000000E-05
   -9.48000000E-06  -9.84600000E-05  +9.24100000E-05  -1.21000000E-06  -2.93700000E-05
   -5.48800000E-05  +1.25400000E-05  -1.08800000E-05  +1.37500000E-05  -9.67000000E-06
   +1.08900000E-05  -5.35000000E-06  -1.89200000E-05  -4.76700000E-05  +4.96000000E-05
   -1.26546000E-03  -2.37310000E-04  -3.31740000E-04  -1.36800000E-05  -1.43000000E-06
   -2.39600000E-05  +2.76800000E-04  +2.58910000E-04  +2.95580000E-04  +1.74500000E-04
   -3.03990000E-04  -1.96430000E-04  +6.55410000E-04  -1.20370000E-04  -2.01010000E-04
   +4.80277600E-02  -6.63900000E-05  +1.44500000E-05  +3.02000000E-05  +1.20240000E-04
   +5.16000000E-06  -1.71300000E-04  -1.32430000E-04  +5.12000000E-05  +4.32500000E-05
   -2.27300000E-04  -8.60800000E-05  +1.07400000E-05  -7.69500000E-05  +8.54320000E-04
   -4.95200000E-04  +6.66820000E-04  +3.23540000E-04  -1.83620000E-04  +1.45500000E-05
   -1.74780000E-04  +1.69820000E-04  -9.58690000E-04  +1.06165200E-02  +1.63672700E-02
   +1.41870000E-04  -2.02665000E-03  +2.81754000E-03  +2.94867000E-03  -1.26832470E-01
   -1.23645240E-01  +3.42210000E-04  +8.60270000E-04  -1.15900000E-05  -1.50750000E-04
   -3.62900000E-05  -4.98500000E-05  +7.42900000E-05  +5.23200000E-05  +5.84600000E-05
   +4.28800000E-05  +9.35700000E-05  -1.18200000E-05  -6.64000000E-05  -2.36890000E-04
   -1.56790000E-04  -3.83220000E-04  -2.27570000E-04  +8.32380000E-04  +6.05000000E-05
   -2.42000000E-06  -2.49500000E-05  -1.17500000E-05  +1.68100000E-05  +8.01000000E-06
   +1.06100000E-05  -1.00200000E-05  +5.21000000E-06  +2.70000000E-07  +2.05500000E-05
   +3.20200000E-05  +2.13400000E-04  -1.91470000E-04  +2.25490000E-04  +1.20200000E-05
   +3.56100000E-05  +2.11900000E-05  +2.36440000E-04  -2.83000000E-06  +1.46240000E-04
   -2.44230000E-04  +1.53700000E-05  +1.55390000E-04  +1.02940000E-04  +8.49760000E-04
   +9.82240000E-04  -3.94087000E-03  +1.36532820E-01  +7.58000000E-06  -1.48100000E-05
   +1.95600000E-05  -1.01280000E-04  -1.65020000E-04  +1.50550000E-04  +2.24740000E-04
   -1.60770000E-04  -2.54000000E-06  -5.20700000E-05  +4.78250000E-04  -3.24400000E-05
   +9.45200000E-04  -9.91190000E-04  +9.80220000E-04  +3.49960000E-04  +2.95400000E-04
   -2.47000000E-05  -2.93380000E-04  +1.34930000E-04  +2.25910000E-04  +9.07680000E-04
   -1.44073200E-02  -2.06541100E-02  -5.95700000E-05  +4.70573000E-03  -3.98843000E-03
   +5.67579000E-03  -1.21617430E-01  -2.38255440E-01  -1.42481000E-03  -8.19670000E-04
   +6.46450000E-04  +8.99730000E-04  +1.75540000E-04  -2.16820000E-04  -4.30860000E-04
   -2.29710000E-04  +6.92700000E-05  -1.53120000E-04  -9.02700000E-05  -1.74610000E-04
   +5.13340000E-04  +5.00440000E-04  +3.49170000E-04  +6.55800000E-05  -1.04217000E-03
   -3.40630000E-04  +1.47400000E-05  +1.21410000E-04  +1.40490000E-04  -2.22500000E-05
   -2.42600000E-05  -2.86400000E-05  -7.14000000E-06  -6.33000000E-06  -8.67000000E-06
   -2.71600000E-05  -1.03980000E-04  +3.49900000E-05  -4.95770000E-04  -2.74120000E-04
   +1.89900000E-04  -2.04300000E-05  +2.78900000E-05  -6.28000000E-06  -2.33700000E-05
   +5.89600000E-05  +2.55640000E-04  +3.88800000E-05  +1.18130000E-04  +3.63750000E-04
   -1.52610000E-04  -1.00915000E-03  -1.50842000E-03  -6.02537000E-03  +1.32091900E-01
   +2.59918390E-01  -1.64700000E-04  +1.51980000E-04  -4.70300000E-05  +1.03910000E-04
   -7.32700000E-05  -1.45900000E-05  -8.29000000E-05  +7.03200000E-05  -9.73000000E-05
   +6.14600000E-05  -8.59900000E-05  +2.39460000E-04  +6.94580000E-04  -7.97800000E-05
   +9.14900000E-05  -1.86090000E-04  -1.53610000E-04  +4.60880000E-04  +1.69930000E-04
   +1.47370000E-04  -2.38430000E-04  -1.63679000E-03  -2.15400000E-05  +6.95710000E-04
   -9.10000000E-05  -1.74150000E-04  +3.67190000E-04  -2.49682160E-01  +1.17706420E-01
   +7.45761000E-03  +6.64050000E-04  -1.25528000E-03  -8.48900000E-05  +1.54550000E-04
   +1.89530000E-04  +1.05240000E-04  +9.10800000E-05  +5.29700000E-05  -7.94300000E-05
   +3.35800000E-05  +3.18700000E-05  -2.55000000E-05  -1.99350000E-04  -5.61200000E-05
   -4.11300000E-05  +2.85430000E-04  +3.55350000E-04  +2.04420000E-04  +1.02800000E-05
   -2.18200000E-05  -5.07000000E-06  -3.08600000E-05  +5.28000000E-06  -2.14700000E-05
   +1.61400000E-05  -2.02200000E-05  +8.96000000E-06  +6.91800000E-05  +5.31400000E-05
   -5.03600000E-05  +1.79670000E-04  +1.49830000E-04  -5.17760000E-04  -4.22000000E-06
   +1.82000000E-06  +1.67800000E-05  +2.04500000E-05  +1.13680000E-04  +5.78600000E-05
   +2.94860000E-04  -2.76830000E-04  -5.21670000E-04  +2.98070000E-04  -2.30150000E-04
   -2.57500000E-05  +2.67850000E-04  -1.09556000E-03  -9.80600000E-05  +2.67914340E-01
   +2.46510000E-04  -1.51180000E-04  -1.58800000E-05  -2.86270000E-04  +7.23900000E-05
   +9.32300000E-05  +6.20800000E-05  -3.19840000E-04  +1.39050000E-04  +1.22523000E-03
   -1.63590000E-04  -1.94290000E-04  -1.04364000E-03  -1.43927000E-03  +3.62617000E-03
   -4.67970000E-04  +8.52900000E-05  +4.86740000E-04  +8.52500000E-05  +1.47700000E-04
   -6.02300000E-05  +1.62224900E-02  -1.18497400E-02  -4.75490000E-04  -4.26720000E-04
   +2.82560000E-04  -1.17204000E-03  +1.16388240E-01  -1.14242560E-01  -5.36822000E-03
   +1.32386000E-03  +1.39720000E-04  +3.70700000E-05  +7.70200000E-05  +2.01510000E-04
   -4.20000000E-05  -3.44130000E-04  -1.83360000E-04  +2.92100000E-05  +9.07500000E-05
   -9.73000000E-06  -2.11000000E-05  -1.45120000E-04  -2.26200000E-05  +1.80700000E-05
   +7.92500000E-05  -1.74090000E-04  -4.02840000E-04  -2.75000000E-05  +3.81700000E-05
   +2.91000000E-05  +8.03900000E-05  -1.12320000E-04  -1.86900000E-05  -3.38600000E-05
   +3.14100000E-05  -1.60400000E-05  -5.82000000E-06  +4.02200000E-05  +6.57000000E-05
   -1.61830000E-04  -6.92500000E-05  -3.25110000E-04  +4.18400000E-05  -9.90000000E-07
   +9.80000000E-06  -1.18200000E-04  +5.86400000E-05  +1.11100000E-05  -1.12640000E-04
   +5.87750000E-04  +9.12300000E-05  -2.52910000E-04  -2.48300000E-05  -5.82300000E-05
   +1.46933800E-02  -8.60743000E-03  +3.43250000E-04  -1.28222850E-01  +1.23542470E-01
   -1.25520000E-04  +4.49100000E-05  +3.11800000E-05  +1.10430000E-04  -1.25780000E-04
   -2.81000000E-06  +1.18730000E-04  +2.36360000E-04  -2.63070000E-04  -1.50604000E-03
   +8.71850000E-04  +3.44040000E-04  +1.19642000E-03  +2.44794000E-03  -4.37716000E-03
   +9.05620000E-04  +2.81790000E-04  -5.01520000E-04  -2.01940000E-04  +9.35000000E-06
   +2.43640000E-04  -2.30253000E-02  +1.35753500E-02  -7.36750000E-04  -1.17286000E-03
   +8.50670000E-04  +1.29961000E-03  +8.97485000E-03  -6.34588000E-03  -4.72870200E-02
   -8.49340000E-04  -2.02270000E-04  +4.72280000E-04  -3.54590000E-04  -1.75990000E-04
   +2.33510000E-04  +2.89250000E-04  +1.56210000E-04  -5.51800000E-05  +1.44400000E-05
   +2.12400000E-05  -2.10000000E-05  -2.89180000E-04  -4.73000000E-06  +6.78500000E-05
   +3.88590000E-04  +5.31000000E-05  -1.29020000E-04  -7.92700000E-05  -8.59900000E-05
   -3.72600000E-05  -1.25390000E-04  +6.88900000E-05  -2.66000000E-05  +2.02300000E-05
   -1.98300000E-05  +4.56000000E-06  +5.40000000E-07  -3.64300000E-05  +4.66000000E-06
   -1.16050000E-04  -5.09260000E-04  +2.59250000E-04  -2.26000000E-05  +3.20800000E-05
   +8.36000000E-06  +5.31100000E-05  -1.21500000E-05  -7.63300000E-05  +3.11580000E-04
   -3.65440000E-04  -7.06170000E-04  +3.08410000E-04  -1.35650000E-04  +2.45330000E-04
   +2.43294900E-02  -1.26021400E-02  +1.24260000E-04  -8.94138000E-03  +2.12874000E-03
   +5.18408700E-02  +1.07630000E-04  -4.84100000E-05  -1.89400000E-05  -1.96300000E-04
   +5.65000000E-06  +2.79600000E-05  +7.90800000E-05  -3.89500000E-05  -1.18700000E-05
   +9.24000000E-05  -4.95800000E-05  -3.42700000E-05  +2.82100000E-05  +1.05600000E-05
   +3.16890000E-04  -8.53110000E-04  +9.38340000E-04  +5.01660000E-04  +8.67500000E-05
   +1.19320000E-04  -2.12820000E-04  +1.72199000E-03  +2.32862000E-03  -4.68410000E-04
   +3.34900000E-04  +3.18950000E-04  -2.59310000E-04  -1.98079370E-01  -1.33220270E-01
   +1.75913000E-03  +2.87150000E-04  -4.22690000E-04  +9.91300000E-05  +3.37960000E-04
   -2.07730000E-04  -5.65900000E-05  +1.05480000E-04  +4.23000000E-05  -1.88900000E-05
   +1.28230000E-04  +9.54900000E-05  -9.90000000E-07  -1.22410000E-04  -1.63900000E-05
   +2.52400000E-05  +1.93470000E-04  +3.32230000E-04  +3.42660000E-04  -1.29840000E-04
   -1.09960000E-04  -1.35600000E-05  +1.43400000E-05  -2.37300000E-05  -3.35000000E-06
   -1.76000000E-05  +1.35300000E-05  -7.30000000E-06  -6.56000000E-06  -9.42000000E-06
   +5.71000000E-06  -1.17134000E-03  +1.77483000E-03  +5.80000000E-07  +3.27700000E-05
   +1.42900000E-05  +2.80400000E-05  +2.65640000E-04  +9.53400000E-05  +2.80510000E-04
   -2.06190000E-04  -1.19950000E-04  +7.19900000E-05  +1.59800000E-04  +2.56240000E-04
   +4.50100000E-05  +1.10544000E-03  +2.43632000E-03  +7.15900000E-05  -1.93164900E-02
   -1.90222900E-02  -2.86710000E-04  +2.15109050E-01  -1.14140000E-04  +1.46290000E-04
   -6.49800000E-05  +5.55600000E-05  -2.30900000E-05  -8.28100000E-05  -1.63760000E-04
   +1.71040000E-04  -4.99900000E-05  +2.76150000E-04  -1.03030000E-04  +1.55250000E-04
   -6.33720000E-04  +5.82750000E-04  -4.33410000E-04  -1.25820000E-04  -5.34250000E-04
   +9.28350000E-04  +3.35240000E-04  +2.38760000E-04  -3.90890000E-04  -1.46732400E-02
   -1.33078300E-02  +4.53000000E-06  +4.06000000E-06  +6.07040000E-04  -1.50369000E-03
   -1.32091030E-01  -1.63437280E-01  +1.07817000E-03  +7.11500000E-04  -9.70400000E-04
   +3.85988000E-03  +2.68260000E-04  -3.27750000E-04  -4.51110000E-04  -4.77360000E-04
   -1.40510000E-04  -1.55200000E-04  -4.06900000E-05  +1.17140000E-04  +1.31350000E-04
   +4.52780000E-04  +3.54670000E-04  +5.84900000E-05  -5.75390000E-04  -5.22080000E-04
   +3.28000000E-05  -1.95930000E-04  -1.34650000E-04  +8.70000000E-07  -1.44100000E-05
   -2.80000000E-06  -2.30200000E-05  +5.16000000E-06  -1.70800000E-05  +1.75000000E-06
   -2.07300000E-05  +6.01300000E-05  -1.34400000E-04  +1.44959000E-03  -9.77480000E-04
   -8.90330000E-04  +1.48400000E-05  -3.50200000E-05  +1.37700000E-05  +2.44780000E-04
   +6.09800000E-04  +3.53610000E-04  +1.32080000E-04  -1.06300000E-05  +1.31490000E-04
   +3.14590000E-04  +3.09300000E-05  -1.50030000E-04  -1.22643900E-02  -1.07561100E-02
   +1.29744000E-03  +1.27490700E-02  +1.20476800E-02  -1.55310000E-04  +1.44478890E-01
   +1.76237850E-01  +5.62500000E-05  -1.95200000E-05  -2.66000000E-05  -1.42260000E-04
   -4.96600000E-05  +1.77840000E-04  +1.44710000E-04  -9.38000000E-05  -2.81800000E-05
   -1.46900000E-05  -1.11400000E-05  -2.45100000E-04  +1.04760000E-04  -7.55570000E-04
   +7.34620000E-04  -2.95860000E-04  -3.73420000E-04  +4.08500000E-04  -1.26780000E-04
   +1.54970000E-04  -1.32040000E-04  +2.06198400E-02  +1.83797900E-02  -2.72509000E-03
   +1.09950000E-03  +7.70220000E-04  +1.25245000E-03  +1.69275000E-03  +7.59000000E-05
   -4.70466400E-02  -1.92502000E-03  +1.71437000E-03  -3.83579000E-03  +1.09489000E-03
   +5.51410000E-04  +2.99620000E-04  -9.18900000E-05  -3.41520000E-04  +2.20750000E-04
   -3.44700000E-05  -5.11600000E-05  -1.54190000E-04  +2.61340000E-04  -7.66800000E-05
   +1.46490000E-04  +2.84600000E-04  -3.54290000E-04  +4.48300000E-05  +1.82130000E-04
   +1.98640000E-04  +8.16200000E-05  +2.35400000E-05  +1.06500000E-05  +1.03300000E-05
   -7.51000000E-06  +1.58100000E-05  -1.88000000E-06  +4.06800000E-05  +1.10700000E-05
   +4.69100000E-05  +1.62110000E-04  -1.49090000E-04  +1.36000000E-04  +1.00900000E-05
   +9.34000000E-06  +1.26200000E-05  -5.31040000E-04  -1.27030000E-04  -7.24680000E-04
   +6.95300000E-05  -1.27830000E-04  -6.83000000E-05  -1.98900000E-04  -1.60620000E-04
   +4.07550000E-04  -2.12148600E-02  -1.69783800E-02  +1.43268000E-03  +1.11396000E-03
   +8.37130000E-04  -9.31400000E-04  -2.14580000E-03  -3.59920000E-03  +5.06713300E-02
   +1.00200000E-04  -7.26500000E-05  -2.21000000E-06  -6.37800000E-05  +6.63600000E-05
   -3.47000000E-06  +1.49400000E-05  +4.89000000E-06  -6.70300000E-05  -4.15200000E-05
   -1.14150000E-04  +9.05200000E-05  -1.39630000E-04  -5.29800000E-05  -1.89380000E-04
   -1.01000000E-05  -2.93800000E-05  -2.49200000E-05  +4.51400000E-05  -3.19200000E-05
   +2.08600000E-05  +1.97780000E-04  +1.25240000E-03  -9.64290000E-04  -2.26426000E-03
   -1.11088000E-03  +8.63020000E-04  +2.72310000E-04  -3.01100000E-05  -1.01510000E-04
   +6.20989000E-03  +1.70259700E-02  +1.58333800E-02  -5.64459300E-02  -1.35154100E-02
   -2.44256000E-03  +3.48014000E-03  -2.04292200E-02  -1.93115800E-02  -1.57620000E-03
   -3.70874000E-03  +4.58463000E-03  -9.12690000E-04  -1.88530000E-04  -4.93360000E-04
   -2.57565000E-03  -1.08188000E-03  +4.59503000E-03  -8.04860000E-04  -1.14245000E-03
   -1.69431000E-03  +7.28000000E-06  -2.44000000E-06  +1.19300000E-05  -1.18500000E-05
   +1.84800000E-05  -1.70000000E-07  +4.67400000E-05  +8.52800000E-05  +2.20000000E-06
   -5.51000000E-06  +1.42600000E-05  +3.24000000E-06  +1.21100000E-05  +3.92000000E-06
   +1.55000000E-06  +1.48500000E-04  +1.83610000E-04  -9.52000000E-05  -8.85490000E-04
   -1.37609000E-03  +1.72930000E-04  -1.35611000E-03  -3.01350000E-04  -5.48030000E-04
   +1.99900000E-05  +3.09500000E-05  -1.40510000E-04  +2.41300000E-05  +2.89000000E-05
   +2.69900000E-05  -4.59300000E-05  +3.09000000E-05  -1.88900000E-05  +5.68211700E-02
   +3.84900000E-05  -4.06800000E-05  +1.83700000E-05  -2.68300000E-05  +4.42200000E-05
   -2.67300000E-05  -9.63000000E-06  -2.22700000E-05  +5.55800000E-05  +1.13540000E-04
   +7.48200000E-05  -1.37760000E-04  +2.02190000E-04  +3.11440000E-04  -2.12000000E-04
   +6.78000000E-05  -8.34000000E-05  +7.96500000E-05  +1.48000000E-05  -2.90800000E-05
   +8.19000000E-06  +5.19800000E-04  -1.92260000E-03  +8.82320000E-04  -2.61701000E-03
   -6.51640000E-04  +2.72190000E-04  -3.30660000E-04  -1.66690000E-04  +6.38100000E-05
   -6.28300000E-05  +1.35308000E-03  -2.26300000E-03  -1.27711200E-02  -1.91885480E-01
   -1.49476450E-01  -4.62870000E-04  -9.05970000E-03  -1.55492200E-02  -5.13411000E-03
   +4.83588000E-03  -1.96525000E-03  +1.54970000E-04  -3.74600000E-04  +9.10660000E-04
   -8.76360000E-04  +3.06560000E-03  -1.85511000E-03  -1.93900000E-04  -1.93990000E-03
   -3.18310000E-04  +1.01400000E-05  -1.43600000E-05  -5.18000000E-06  +3.64000000E-06
   +1.49000000E-06  -9.19000000E-06  +2.09600000E-05  -7.34900000E-05  -1.45300000E-05
   -1.42600000E-05  -3.32000000E-06  +8.68000000E-06  +7.93000000E-06  -1.05700000E-05
   -9.50000000E-07  -1.73920000E-04  -5.87500000E-05  +5.22810000E-04  -1.73963000E-03
   -1.05998000E-03  +1.61810000E-04  +1.56840000E-04  -2.28660000E-04  +2.53170000E-04
   +1.01500000E-05  -1.59200000E-05  +1.27500000E-05  +2.96200000E-05  -1.40800000E-05
   -1.74000000E-06  +5.09000000E-05  -2.15300000E-05  +8.41100000E-05  +2.13507300E-02
   +1.99931630E-01  -4.02500000E-05  +3.89200000E-05  -4.63000000E-06  +2.16900000E-05
   -2.64900000E-05  -4.23000000E-06  -1.56500000E-05  +2.09400000E-05  +7.46000000E-06
   -8.54000000E-06  +3.40000000E-06  +6.67600000E-05  -1.65610000E-04  -8.85600000E-05
   +1.66900000E-04  -4.48800000E-05  +6.80700000E-05  -1.64200000E-05  -6.72000000E-06
   +1.77200000E-05  -9.50000000E-07  -1.86824000E-03  +2.68190000E-04  -1.47158000E-03
   -4.89480000E-04  -9.10840000E-04  +4.07600000E-04  +5.38330000E-04  +1.28360000E-04
   +2.74800000E-05  -2.27980000E-03  -1.45688200E-02  -1.01126100E-02  -1.39051000E-03
   -1.49134180E-01  -1.95108620E-01  +1.44185000E-03  -1.28169000E-03  +3.81965000E-03
   +3.11165000E-03  -2.96264000E-03  +4.85890000E-03  -1.15560000E-04  +1.15939000E-03
   -5.84600000E-05  +4.73537000E-03  -1.63936000E-03  +3.53610000E-04  -7.06020000E-04
   +3.70170000E-04  -6.04410000E-04  -8.80000000E-06  +4.47000000E-06  -4.54000000E-06
   -2.81000000E-06  -7.88000000E-06  +1.10000000E-06  +3.98000000E-06  -2.80300000E-05
   -2.30800000E-05  +5.17000000E-06  -8.90000000E-06  -1.48500000E-05  -8.62000000E-06
   +7.80000000E-07  -2.16000000E-06  -5.22670000E-04  +3.00950000E-04  +2.53700000E-04
   -1.16500000E-04  +8.61690000E-04  +1.57630000E-04  -4.01890000E-04  -2.51120000E-04
   +1.44810000E-04  -6.44300000E-05  +9.63000000E-06  +8.15000000E-05  -1.75500000E-05
   +6.61300000E-05  -1.01090000E-04  -2.22000000E-06  +1.19770000E-04  -1.30620000E-04
   +6.01720000E-04  +1.65664050E-01  +1.99634270E-01  -7.15200000E-05  +5.51400000E-05
   -1.10400000E-05  +5.67200000E-05  -4.63100000E-05  +6.96000000E-06  -2.54600000E-05
   +1.72000000E-05  +5.48000000E-06  -2.84300000E-05  -1.86900000E-05  +6.12200000E-05
   -7.48700000E-05  -2.90140000E-04  +7.52400000E-05  -6.16000000E-05  +7.34100000E-05
   -6.26800000E-05  -1.56200000E-05  +2.74500000E-05  +8.94000000E-06  -3.95160000E-04
   +8.69040000E-04  +5.09160000E-04  -3.39400000E-05  +6.86900000E-05  +3.81500000E-05
   -5.05600000E-05  -1.82000000E-05  -5.20100000E-05  -9.84740000E-04  -5.48574000E-03
   +1.06087000E-03  -1.11763600E-02  +4.00925000E-03  +1.68183100E-02  -2.16916170E-01
   +1.61109200E-02  +1.47033100E-01  +4.12401000E-03  -2.63836000E-03  -2.24076000E-03
   +9.40320000E-04  -1.25170000E-03  +2.05470000E-04  -1.00050000E-04  -8.21000000E-06
   -7.01300000E-04  +1.87910000E-04  +1.49065000E-03  -6.07910000E-04  -1.31900000E-05
   +1.13400000E-05  -3.31000000E-06  +4.02000000E-06  -9.07000000E-06  +7.10000000E-06
   +1.43000000E-05  -1.43700000E-05  +2.70000000E-07  +7.50000000E-06  -9.29000000E-06
   -7.45000000E-06  -9.53000000E-06  +9.32000000E-06  +1.97000000E-06  +3.00000000E-08
   -4.13300000E-05  -1.80900000E-05  +3.47800000E-05  -1.54300000E-05  +4.75000000E-06
   -1.55900000E-05  -2.12800000E-05  -1.29600000E-05  -5.30000000E-07  +7.20000000E-06
   -7.45000000E-06  +2.48200000E-05  -3.98000000E-06  +8.85000000E-06  -1.30900000E-05
   -6.11500000E-05  +2.04000000E-05  -4.63980000E-04  +1.62790000E-03  -1.84841000E-03
   +2.24924950E-01  -3.26000000E-05  +1.91500000E-05  -8.50000000E-07  +1.96600000E-05
   -1.26300000E-05  +4.48000000E-06  -5.22000000E-06  +2.09000000E-06  +1.36000000E-05
   +9.63000000E-06  +2.51600000E-05  -6.02900000E-05  -8.80100000E-05  -1.42020000E-04
   +8.96000000E-06  -9.28000000E-06  +2.15800000E-05  +1.20100000E-05  -9.53000000E-06
   +2.12800000E-05  +7.20000000E-06  -1.35570000E-04  +2.63200000E-05  +8.18990000E-04
   +8.21600000E-05  +7.50500000E-05  +7.39800000E-05  -2.54440000E-04  -5.30600000E-05
   -9.36700000E-05  -5.29648000E-03  +1.19266000E-03  -3.49551000E-03  -1.53520900E-02
   +7.36579000E-03  +1.20901500E-02  +1.61360800E-02  -5.22911200E-02  -2.83772400E-02
   +1.79348600E-02  +2.80037000E-03  -1.50470600E-02  -1.64663000E-03  -2.13263000E-03
   -4.18367000E-03  -1.56000000E-04  -9.56440000E-04  +1.75940000E-04  +2.50150000E-04
   +8.17400000E-04  +3.61328000E-03  +1.91000000E-06  +1.05000000E-06  -2.62000000E-06
   +4.15000000E-06  -2.67000000E-06  +6.00000000E-08  -1.44100000E-05  +1.43000000E-06
   +4.86000000E-06  +1.26000000E-06  -9.77000000E-06  -1.97000000E-06  -6.06000000E-06
   +9.70000000E-07  +1.10000000E-06  -9.69000000E-06  -1.09000000E-06  -3.42900000E-05
   -2.08500000E-05  -3.08700000E-05  -3.36000000E-06  +7.69000000E-06  +4.09300000E-05
   -3.65200000E-05  +5.23000000E-06  -9.70000000E-07  +2.25000000E-05  +9.15000000E-06
   -3.75000000E-06  -2.35000000E-06  +2.50000000E-07  -3.71200000E-05  +8.68100000E-05
   +2.02209000E-03  -1.67372000E-03  +2.43275000E-03  -1.44641900E-02  +4.49073400E-02
   +5.03000000E-06  +1.27000000E-06  -5.50000000E-07  -5.80000000E-06  -1.75000000E-06
   -2.77000000E-06  -5.58000000E-06  +1.16500000E-05  -4.27000000E-06  -5.94000000E-06
   -7.15000000E-06  +4.21100000E-05  +4.01000000E-06  -7.73300000E-05  +2.49200000E-05
   -2.70200000E-05  +2.09100000E-05  -1.66200000E-05  -6.20000000E-07  +3.65000000E-06
   +1.06100000E-05  -4.22500000E-04  +3.51120000E-04  -8.49700000E-05  -1.63400000E-05
   +2.83500000E-05  -3.86900000E-05  +1.41660000E-04  +6.09000000E-06  +8.76000000E-06
   +9.52150000E-04  -3.44343000E-03  +4.00784000E-03  -3.27028000E-03  -1.83868000E-03
   +6.77752000E-03  +1.47073290E-01  -2.84143600E-02  -1.71902960E-01  +1.93555000E-02
   -2.03610000E-04  -9.32271000E-03  -2.90710000E-04  -4.51062000E-03  -1.48180000E-03
   -9.01250000E-04  +5.79000000E-06  -3.92160000E-04  -1.94712000E-03  +2.72323000E-03
   +1.42860000E-03  -3.77000000E-06  +1.23000000E-06  -8.70000000E-07  -3.92000000E-06
   -2.30000000E-07  -3.80000000E-07  +1.18400000E-05  -4.74000000E-06  -1.02900000E-05
   -2.34000000E-06  -3.92000000E-06  -3.64000000E-06  -1.95000000E-06  +2.03000000E-06
   -9.80000000E-07  +1.68300000E-05  -1.86200000E-05  +1.08200000E-05  +3.87800000E-05
   -8.05000000E-06  +1.39100000E-05  -2.25800000E-05  -2.57900000E-05  +8.41000000E-06
   -1.02600000E-05  -1.80000000E-06  -1.27000000E-05  +9.24000000E-06  +4.22000000E-06
   +1.31700000E-05  -7.60000000E-06  -1.27600000E-05  -4.07700000E-05  -1.42756000E-03
   +2.73528000E-03  -1.50887000E-03  -1.60190400E-01  +3.26319400E-02  +1.73141320E-01
   -5.84500000E-05  +5.98600000E-05  +3.48000000E-06  +3.00800000E-05  -3.92200000E-05
   +9.10000000E-06  -1.46700000E-05  +2.81700000E-05  +2.13900000E-05  -1.02000000E-05
   -1.35600000E-05  +2.56000000E-05  +3.87100000E-05  -4.59900000E-05  -9.64000000E-06
   +2.33900000E-05  +7.46000000E-06  -3.53500000E-05  -2.26800000E-05  +5.41200000E-05
   -2.08000000E-06  +4.33210000E-04  -5.29260000E-04  -1.11249000E-03  -3.89380000E-04
   -1.26870000E-04  +1.09410000E-04  +8.88700000E-05  +1.54550000E-04  -1.05750000E-04
   -2.11533000E-03  -5.22382000E-03  +2.59604000E-03  -9.66180000E-04  -2.55000000E-05
   -3.32700000E-05  -3.38148000E-03  -7.47510000E-04  +3.78466000E-03  +5.91905000E-03
   +1.77858700E-02  +1.72948300E-02  -5.49871400E-02  -1.64959300E-02  -4.33912000E-03
   +4.02625000E-03  -1.87047500E-02  -1.76393700E-02  +1.69263000E-03  -1.77210000E-04
   -3.28699000E-03  -1.38200000E-05  +2.02000000E-06  -1.42400000E-05  -7.21000000E-06
   -1.36300000E-05  -5.51000000E-06  +4.52000000E-06  -1.92700000E-05  -2.20000000E-07
   +4.00000000E-06  -1.01100000E-05  -5.74000000E-06  -1.27700000E-05  -2.69000000E-06
   -2.84000000E-06  -2.05500000E-05  -8.36300000E-05  -1.25900000E-04  +1.32400000E-05
   -1.03000000E-06  +1.50600000E-05  +5.67000000E-06  +1.27100000E-05  -2.25400000E-05
   +1.70900000E-05  -7.40000000E-07  +4.81900000E-05  -2.58000000E-06  +7.57000000E-06
   +1.89300000E-05  -2.39500000E-05  -2.56000000E-06  +1.93600000E-05  -4.17700000E-05
   +1.87320000E-04  -2.53750000E-04  +2.95720000E-04  +8.13270000E-04  +1.05738000E-03
   +4.97208200E-02  -1.55700000E-05  +5.85000000E-06  +5.27000000E-06  +1.94300000E-05
   +6.15000000E-06  -2.13000000E-05  -1.99200000E-05  +6.68000000E-06  -1.33000000E-06
   +3.74200000E-05  +6.17500000E-05  -5.58000000E-06  +3.09010000E-04  -7.58900000E-05
   +3.98000000E-05  -5.35600000E-05  +4.92900000E-05  +4.34800000E-05  -2.11000000E-06
   -1.99700000E-05  +2.30200000E-05  +3.88150000E-04  -3.02290000E-04  -4.44450000E-04
   -1.86000000E-04  -1.78560000E-04  +1.05630000E-04  -1.30930000E-04  -1.09750000E-04
   -3.97000000E-06  -5.21973000E-03  +2.89013000E-03  -2.62242000E-03  +1.74040000E-04
   -1.67830000E-04  +6.81270000E-04  -3.70020000E-04  +1.61420000E-03  -1.17762000E-03
   -2.96374000E-03  +8.80420000E-04  -1.54012000E-03  -1.66038500E-02  -1.95696230E-01
   -1.52208810E-01  +7.85320000E-04  -6.41302000E-03  -1.38081100E-02  +1.19959000E-03
   -3.58790000E-04  +1.53341000E-03  -1.69000000E-06  +1.85000000E-06  +2.50000000E-07
   +5.22000000E-06  -7.40000000E-07  -1.48000000E-06  +4.50000000E-07  -1.20900000E-05
   +1.37500000E-05  +6.30000000E-07  -1.15900000E-05  -4.93000000E-06  -8.09000000E-06
   +6.00000000E-08  -9.60000000E-07  +2.54000000E-06  -8.42800000E-05  -4.95000000E-05
   +1.15600000E-05  -2.72000000E-06  -1.19700000E-05  +1.02700000E-05  +1.50100000E-05
   +1.84700000E-05  -1.85800000E-05  -9.12000000E-06  -2.28000000E-06  +6.25000000E-06
   -1.05500000E-05  -1.31300000E-05  +3.18000000E-06  -4.76000000E-05  +4.03100000E-05
   +1.99770000E-04  -3.28250000E-04  +2.14030000E-04  -1.82560000E-04  +1.95640000E-04
   -2.43380000E-04  +2.10596600E-02  +2.00080350E-01  -3.97800000E-05  +4.36900000E-05
   -4.66000000E-06  +1.45800000E-05  -3.19300000E-05  +2.19400000E-05  -6.68000000E-06
   +2.32800000E-05  +2.65800000E-05  -1.58700000E-05  -4.64600000E-05  +2.06900000E-05
   -1.85590000E-04  -1.20000000E-07  -2.00100000E-05  +3.64200000E-05  -1.90300000E-05
   -6.19400000E-05  -7.39000000E-06  +3.85800000E-05  -2.10100000E-05  +1.38440000E-04
   +1.01610000E-04  -2.24880000E-04  -7.00900000E-05  +6.23900000E-05  +1.63900000E-05
   +9.85500000E-05  +1.24650000E-04  -5.45500000E-05  +2.36127000E-03  -3.00424000E-03
   +4.30741000E-03  +2.09100000E-05  +7.82810000E-04  -1.62670000E-04  +4.23740000E-03
   -8.73570000E-04  -9.22990000E-04  -4.05982000E-03  -1.62215300E-02  -9.43190000E-03
   -4.52834000E-03  -1.52144200E-01  -1.91154540E-01  +2.45850000E-03  +3.36470000E-04
   +5.02205000E-03  -1.93209000E-03  +2.43133000E-03  +1.21593000E-03  -1.32000000E-05
   -2.30000000E-07  -1.50400000E-05  -7.75000000E-06  -1.16900000E-05  -6.80000000E-07
   +8.26000000E-06  -1.78100000E-05  -1.40200000E-05  +4.42000000E-06  +4.37000000E-06
   -1.43000000E-06  -1.71000000E-06  +1.66000000E-06  -1.60000000E-07  -1.36900000E-05
   +1.76700000E-05  -2.14500000E-05  -2.99000000E-06  +1.60500000E-05  +4.53000000E-06
   +9.58000000E-06  -8.76000000E-06  -1.94200000E-05  +6.84000000E-06  +1.76200000E-05
   +2.64700000E-05  -2.92000000E-06  +7.92000000E-06  +2.35000000E-06  -1.47000000E-05
   +1.63300000E-05  -1.84000000E-06  -2.55910000E-04  +2.22220000E-04  -2.61950000E-04
   +7.50000000E-07  -9.57700000E-04  -4.45260000E-04  +3.73742000E-03  +1.66613220E-01
   +1.93980670E-01  +1.50820000E-04  -1.07650000E-04  -4.51000000E-06  -2.43520000E-04
   +6.91500000E-05  +1.40870000E-04  +2.70170000E-04  -6.62000000E-05  -2.72600000E-05
   -3.03240000E-04  -1.77550000E-04  -3.01530000E-04  -6.84410000E-04  -7.41980000E-04
   -7.61380000E-04  -1.28310000E-04  -1.51240000E-04  -1.25090000E-04  -1.36840000E-04
   +1.47050000E-04  +2.01000000E-05  -7.16150000E-04  +1.54810000E-04  -7.54500000E-04
   -1.29100000E-05  +1.53120000E-04  -6.50300000E-05  -7.71400000E-05  -1.87930000E-04
   +1.71550000E-04  +4.30380000E-03  -3.53000000E-04  -1.22580000E-03  +1.85172000E-03
   -1.59163000E-03  +4.04050000E-04  -2.60280000E-04  +2.36400000E-05  -7.14560000E-04
   +1.77919000E-03  -5.75023000E-03  -2.63200000E-05  -1.49777600E-02  +3.39555000E-03
   +1.85308500E-02  -2.17325550E-01  +2.00897600E-02  +1.41564100E-01  -2.22003000E-03
   +1.50180000E-04  +6.14140000E-04  +5.23000000E-06  -7.14000000E-06  +8.70000000E-06
   -1.81700000E-05  +2.46800000E-05  -5.70000000E-06  +2.01100000E-05  +2.16400000E-05
   +5.58400000E-05  +5.73200000E-05  -1.68300000E-05  +6.86000000E-06  +4.07000000E-06
   +2.61000000E-06  -5.86000000E-06  +7.40600000E-05  +1.30200000E-05  +1.80000000E-07
   -1.16800000E-05  +2.70500000E-05  +4.69000000E-05  -1.62000000E-05  +9.30000000E-07
   -4.02700000E-05  +2.46060000E-04  -1.06910000E-04  -2.27790000E-04  +1.87700000E-05
   +2.29600000E-05  +1.96900000E-05  -8.12000000E-06  -6.91200000E-05  -2.52470000E-04
   +2.44950000E-04  -1.54600000E-04  -8.08100000E-05  -1.64690000E-04  +2.03500000E-04
   -1.02180000E-04  -2.45110000E-04  +1.56386000E-03  -1.97482000E-03  +2.28523850E-01
   +2.07460000E-04  -1.66610000E-04  +4.69000000E-06  -2.29030000E-04  -3.61000000E-06
   +1.64490000E-04  +2.91320000E-04  -2.42690000E-04  -1.05560000E-04  -2.12610000E-04
   +3.06870000E-04  -2.70680000E-04  -4.18350000E-04  -5.25000000E-05  -1.14290000E-04
   -8.25800000E-05  -2.80200000E-05  -2.72300000E-05  -1.09460000E-04  +6.44800000E-05
   +1.53300000E-05  +1.18242000E-03  -5.56630000E-04  +7.63370000E-04  +9.40000000E-05
   -3.29000000E-06  +1.00290000E-04  -5.90500000E-05  -5.64140000E-04  -4.52070000E-04
   +1.79595900E-02  +1.80082000E-03  -1.39753400E-02  -2.08486000E-03  -1.15536000E-03
   -4.73768000E-03  -2.41490000E-04  -8.78040000E-04  +6.99560000E-04  -4.47953000E-03
   +2.04326000E-03  -5.81638000E-03  -1.73082100E-02  +7.56191000E-03  +1.27555700E-02
   +2.01530700E-02  -5.62398400E-02  -2.90975900E-02  -8.90760000E-04  -7.82050000E-04
   +1.53741000E-03  +3.19400000E-05  -1.11100000E-05  +2.66300000E-05  +1.82000000E-06
   +3.41100000E-05  +2.00000000E-06  -1.41600000E-05  +2.53900000E-05  +7.79100000E-05
   -8.32300000E-05  -8.69200000E-05  +2.56700000E-05  +2.18200000E-05  +1.11600000E-05
   +1.30000000E-06  -4.91500000E-05  +2.54900000E-05  +3.36000000E-05  -6.20000000E-07
   +6.96700000E-05  -6.62000000E-06  +4.41700000E-05  +1.94300000E-05  +1.05970000E-04
   -2.23520000E-04  -1.12523000E-03  +5.73960000E-04  -5.64900000E-05  +1.23630000E-04
   +1.56200000E-05  -2.58700000E-05  +2.02180000E-04  +3.28400000E-04  +8.69660000E-04
   +6.05300000E-05  -8.40910000E-04  +2.02490000E-04  -1.66370000E-04  +2.89440000E-04
   +2.09071000E-03  -1.97813000E-03  +2.47541000E-03  -1.65815100E-02  +5.16916500E-02
   +3.46200000E-04  -2.28600000E-04  +2.44500000E-05  -3.47610000E-04  +1.32020000E-04
   -4.50000000E-06  +7.06500000E-05  +1.04410000E-04  -6.41900000E-05  +2.13200000E-05
   +4.07190000E-04  -2.25030000E-04  -2.16320000E-04  -3.56930000E-04  +1.31490000E-04
   -3.93750000E-04  +1.73430000E-04  +3.02720000E-04  -3.43700000E-05  -9.25500000E-05
   +9.12400000E-05  +3.29590000E-04  +1.40132000E-03  -8.85200000E-04  -1.99670000E-04
   +4.40200000E-05  -1.55500000E-05  -2.48700000E-05  +3.87600000E-05  -7.89100000E-05
   +1.74564000E-02  -1.26234000E-03  -9.97288000E-03  +3.17550000E-04  -5.15014000E-03
   -5.31160000E-04  -1.22482000E-03  +4.43670000E-04  -1.29500000E-04  +1.64133000E-03
   -5.02888000E-03  +4.72230000E-03  -1.67204000E-03  -1.45653000E-03  +6.63140000E-03
   +1.39917320E-01  -2.89645800E-02  -1.66484530E-01  -3.22360000E-04  +9.63600000E-04
   -4.72980000E-04  +7.28000000E-06  -2.90900000E-05  -1.79000000E-06  -3.86400000E-05
   +3.89100000E-05  -2.75200000E-05  +3.91400000E-05  -7.13600000E-05  +2.09000000E-06
   +9.27000000E-06  +2.90200000E-05  -2.84600000E-05  +1.79600000E-05  +4.21000000E-06
   -7.34000000E-06  -5.83700000E-05  -6.49700000E-05  +5.80000000E-06  -1.87400000E-05
   +1.29090000E-04  +3.30100000E-05  +5.51900000E-05  -2.68100000E-05  +2.89100000E-05
   +9.79900000E-05  +3.08090000E-04  +2.45230000E-04  +1.48000000E-06  +1.46280000E-04
   +5.74300000E-05  -1.28000000E-05  -8.67300000E-05  +8.97000000E-06  +9.72900000E-04
   -1.20230000E-04  -5.52300000E-04  -1.03230000E-04  +2.98520000E-04  -2.16740000E-04
   -1.74607000E-03  +2.82947000E-03  -1.80459000E-03  -1.54887930E-01  +3.54477300E-02
   +1.69218090E-01
end_hess

