# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.50264030    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.08790884E+00  -4.07004988E-01  -1.78904574E+00
   006   +1.72847322E+00  +1.43847335E+00  +1.40124100E-01
   006   +3.68355167E+00  +1.76187136E+00  +1.92840529E+00
   006   +5.84944216E+00  +3.91528671E-01  +1.84894312E+00
   006   +6.39608399E+00  -1.49666142E+00  -1.80906935E-01
   006   +4.21485058E+00  -1.79784206E+00  -1.96517562E+00
   006   -6.94890602E-01  +2.99027151E+00  +1.40645045E-01
   006   -9.72070893E-01  +4.62265412E+00  +2.52502837E+00
   008   +7.03493736E+00  -3.77869837E+00  +9.95821915E-01
   006   -2.95999737E+00  +1.19191917E+00  +2.51316592E-02
   006   -4.91750774E+00  +1.44441779E+00  -1.69811008E+00
   006   -6.96819928E+00  -1.95751144E-01  -1.69213542E+00
   006   -7.09099328E+00  -2.13715627E+00  +5.93529679E-02
   006   -5.14463322E+00  -2.42875884E+00  +1.80031090E+00
   006   -3.12288272E+00  -7.83548062E-01  +1.76615331E+00
   008   -9.04110851E+00  -3.80318755E+00  +1.60754140E-01
   006   -5.87659057E-01  +4.77969009E+00  -2.14803360E+00
   008   +8.60623160E+00  -7.76675846E-01  -1.56571449E+00
   001   -1.02489465E+01  -3.40680028E+00  -1.12502295E+00
   001   -8.46886508E+00  +4.64893006E-02  -3.06573206E+00
   001   -4.88211997E+00  +2.93346182E+00  -3.09582162E+00
   001   -1.60955502E+00  -1.05695026E+00  +3.11763727E+00
   001   -5.24000021E+00  -3.95535364E+00  +3.15511232E+00
   001   +1.10325889E+00  +5.94984753E+00  -2.02458912E+00
   001   -5.16737409E-01  +3.74690628E+00  -3.92877332E+00
   001   -2.22139916E+00  +6.03674880E+00  -2.18515115E+00
   001   -9.44421297E-01  +3.48166359E+00  +4.23953717E+00
   001   +5.26571401E-01  +6.03299185E+00  +2.65169203E+00
   001   -2.77473179E+00  +5.61663881E+00  +2.46118503E+00
   001   +3.45607367E+00  +3.12731284E+00  +3.43090824E+00
   001   +7.32407748E+00  +6.32098974E-01  +3.24377723E+00
   001   +4.44333387E+00  -3.20417442E+00  -3.43650945E+00
   001   +5.73708320E-01  -7.20451447E-01  -3.13069553E+00
   001   +7.74011359E+00  -4.86775461E+00  -2.71182892E-01
   001   +8.18238584E+00  +6.47886425E-01  -2.60042342E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +9.30000000E-07  -3.00000000E-08  +1.23000000E-06
   +1.80000000E-07  +5.30000000E-07  -5.20000000E-07
   +5.30000000E-07  +1.53000000E-06  +5.40000000E-07
   -2.40000000E-07  +8.00000000E-06  -6.86000000E-06
   -5.53000000E-06  +1.04600000E-05  -4.03000000E-06
   -1.43000000E-06  -3.70000000E-06  +4.03000000E-06
   -6.00000000E-08  -1.40000000E-07  -2.30000000E-07
   -7.00000000E-08  +6.00000000E-08  -4.30000000E-07
   +5.40000000E-06  -1.19700000E-05  -1.07100000E-05
   +9.00000000E-08  -2.60000000E-07  -3.20000000E-07
   -3.70000000E-07  -1.25000000E-06  +1.12000000E-06
   +0.00000000E+00  -1.11000000E-06  +1.67000000E-06
   -2.70000000E-07  -1.03000000E-06  +1.32000000E-06
   +1.10000000E-06  +1.50000000E-07  +1.11000000E-06
   -1.40000000E-07  -2.40000000E-07  +3.10000000E-07
   +1.03000000E-06  -7.80000000E-07  +1.97000000E-06
   -1.15000000E-06  -3.80000000E-07  +6.00000000E-08
   +1.30000000E-07  +9.00000000E-07  +4.11000000E-06
   +4.60000000E-07  -1.23000000E-06  +2.31000000E-06
   -8.40000000E-07  -1.30000000E-06  +1.13000000E-06
   -8.50000000E-07  -8.20000000E-07  +1.00000000E-07
   +1.35000000E-06  +4.80000000E-07  +9.60000000E-07
   +1.04000000E-06  -6.80000000E-07  +1.77000000E-06
   -8.80000000E-07  +0.00000000E+00  -7.30000000E-07
   -1.48000000E-06  -5.50000000E-07  -5.40000000E-07
   -4.30000000E-07  +3.00000000E-07  +2.00000000E-08
   +2.80000000E-07  -3.00000000E-08  -4.00000000E-08
   -3.20000000E-07  +6.60000000E-07  -7.00000000E-07
   -3.60000000E-07  +5.00000000E-08  -9.00000000E-08
   -1.50000000E-07  +4.40000000E-07  +7.00000000E-08
   +1.07000000E-06  +1.54000000E-06  -1.20000000E-07
   +1.49000000E-06  +7.20000000E-07  -3.40000000E-07
   -3.50000000E-07  -1.40000000E-07  -7.80000000E-07
   +3.60000000E-07  +1.70000000E-07  +4.50000000E-06
   -5.60000000E-07  -3.20000000E-07  -1.90000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.68335350E-01  -1.60867440E-01  +3.77284420E-01  +1.74371160E-01  +1.79274740E-01
   +4.52058760E-01  -1.10694290E-01  +4.07484100E-02  +1.37153600E-02  +5.07913850E-01
   -1.09219400E-02  -1.32571010E-01  -8.96082200E-02  -1.19658970E-01  +3.66234180E-01
   -4.92835500E-02  -5.36719300E-02  -1.56426330E-01  +1.09815180E-01  +1.48842090E-01
   +4.17586440E-01  +3.92117400E-02  -4.87860000E-02  -3.66777800E-02  -1.55831310E-01
   +3.42896700E-02  -3.08690800E-02  +5.22590160E-01  -2.45034900E-02  +8.18450000E-03
   -1.52062000E-02  -2.45501300E-02  -9.93045100E-02  -6.76692100E-02  -1.79956890E-01
   +4.45547730E-01  -7.38619000E-03  -3.17615700E-02  -3.66900600E-02  -1.01428300E-01
   -2.71481400E-02  -1.63091200E-01  +7.30554900E-02  +2.59286560E-01  +4.93029700E-01
   -1.51802800E-02  +2.22880900E-02  +1.65422000E-02  -6.57277400E-02  -5.78740000E-03
   -5.88446200E-02  -2.85535960E-01  +1.63234730E-01  +2.57017400E-02  +6.60287150E-01
   +9.68228000E-03  -1.56560800E-02  -1.12732800E-02  +2.64913300E-02  +2.34909100E-02
   +3.69323700E-02  +1.29437120E-01  -1.75766110E-01  -5.48508900E-02  -1.88721340E-01
   +3.87136270E-01  +1.52073000E-03  -2.13256000E-03  -2.57817000E-03  -2.06535600E-02
   +1.51950400E-02  +1.02327500E-02  -1.56338700E-02  -3.09844100E-02  -1.01636700E-01
   +1.53849580E-01  +1.60448070E-01  +4.59916320E-01  -2.14929400E-02  +7.06017000E-03
   -9.18812000E-03  +1.48958000E-03  -6.26892000E-03  -1.00761000E-03  -2.75029000E-03
   +1.94812600E-02  +1.81154400E-02  -8.59912800E-02  +1.24866300E-02  -5.06083000E-03
   +4.72408410E-01  +1.42390600E-02  +9.39304000E-03  +1.33754600E-02  -5.42049000E-03
   -5.06222000E-03  +1.93420000E-03  +1.10482100E-02  -7.02141000E-03  -8.59910000E-03
   +1.02618100E-02  -1.29949880E-01  -7.67165600E-02  -5.63747400E-02  +5.14038370E-01
   -2.66318000E-03  +8.65844000E-03  +1.44299200E-02  -1.30715000E-03  +3.44960000E-04
   -8.95426000E-03  +1.21090700E-02  -1.51337000E-03  +1.18243400E-02  -1.05612000E-02
   -6.82285500E-02  -1.58251320E-01  +4.87609500E-02  +6.24605400E-02  +5.12438020E-01
   -3.37838980E-01  +1.41231710E-01  -2.99743700E-02  +4.86002000E-03  +4.73038600E-02
   +5.56288600E-02  -2.88423600E-02  +4.90193000E-03  -1.39105600E-02  +1.95190300E-02
   -1.19578000E-02  -2.52908000E-03  -1.37012260E-01  -7.88372000E-03  -5.77985300E-02
   +6.10896690E-01  +1.71538820E-01  -1.70822680E-01  -2.12345900E-02  +2.11725900E-02
   -3.54559000E-02  -3.80304200E-02  +1.69815300E-02  -3.45243000E-03  +8.06056000E-03
   -2.42530800E-02  +4.09216000E-03  -1.49063400E-02  -1.30599700E-02  -8.85245900E-02
   -3.74829100E-02  -2.14981650E-01  +4.69869380E-01  +5.76632000E-03  -4.15352300E-02
   -9.64527000E-02  +2.23277900E-02  -1.90596600E-02  +1.72090000E-03  +3.87890000E-04
   -2.87150000E-04  -4.24400000E-04  -1.77192900E-02  -7.06739000E-03  -1.74440100E-02
   -6.40291200E-02  -3.38325100E-02  -1.41658050E-01  +5.75461500E-02  +2.27012140E-01
   +4.44658640E-01  -5.08645000E-03  +9.68893000E-03  +6.71723000E-03  -1.47040400E-01
   +4.68234700E-02  -9.41178000E-03  -1.68870800E-02  +1.24279100E-02  -2.22287000E-03
   +6.69680000E-04  -2.26490000E-04  -2.86223000E-03  -1.44342000E-03  +3.73820000E-04
   -8.08000000E-05  +3.52598000E-03  -1.84847000E-03  -1.65723000E-03  +4.71854060E-01
   +1.96889800E-02  -1.23898100E-02  -1.56870000E-03  +4.90384900E-02  -1.02284550E-01
   -1.16644700E-02  +1.50012000E-03  +7.78035000E-03  +2.60705000E-03  -1.57651000E-03
   +2.19546000E-03  -3.57617000E-03  +1.54910000E-04  -5.65100000E-04  -7.28800000E-05
   -7.16060000E-04  -4.06000000E-06  -3.25379000E-03  -5.13994000E-03  +4.75517580E-01
   +1.96669100E-02  -1.15176800E-02  +4.61755000E-03  -3.18539000E-03  -1.49978300E-02
   -8.10475900E-02  -1.43004400E-02  +1.09916800E-02  +6.63489000E-03  -3.63999000E-03
   -2.46081000E-03  -1.60301000E-03  +2.68410000E-04  -4.90740000E-04  -8.17940000E-04
   -3.83780000E-04  -4.69098000E-03  -3.00597000E-03  -3.13430000E-04  +8.35839000E-03
   +4.75612370E-01  -5.08494000E-03  +2.33554000E-03  -1.50917000E-03  -3.71365000E-03
   +1.79413800E-02  +2.52450200E-02  -1.37630000E-03  +6.46710000E-04  +6.98150000E-04
   +1.54200000E-04  +3.43550000E-04  +6.76380000E-04  +5.25430000E-04  -1.22410000E-04
   +4.98000000E-06  +3.09770000E-04  +1.00922000E-03  +1.06713000E-03  -7.70050400E-02
   +3.05298000E-03  +5.01949000E-03  +5.86092810E-01  +2.82909000E-03  -8.90300000E-05
   +3.67250000E-04  +6.64531000E-03  -1.36469400E-02  -1.65217900E-02  -6.58000000E-05
   -5.22550000E-04  +1.03307000E-03  -5.22510000E-04  -5.32900000E-04  -7.27340000E-04
   +1.08990000E-04  +9.71500000E-05  -4.68600000E-05  -1.42070000E-04  -4.36680000E-04
   -5.89550000E-04  +7.48234000E-03  -1.05525920E-01  -4.75023400E-02  +7.58115000E-03
   +5.44807260E-01  -1.29249000E-03  +6.70040000E-04  -1.40350000E-04  +5.30772000E-03
   -1.94588000E-03  +5.07310000E-04  -1.46793000E-03  +9.78080000E-04  +1.57650000E-04
   -1.23020000E-04  -1.07010000E-04  -3.00110000E-04  +2.31730000E-04  -1.45330000E-04
   +1.26040000E-04  -3.27320000E-04  +3.44720000E-04  +3.11160000E-04  +9.15212000E-03
   -4.33955300E-02  -1.42378320E-01  +1.34313300E-02  -6.13814200E-02  +5.09462440E-01
   -4.65040000E-04  -2.33782000E-03  -4.68986000E-03  +2.81790000E-04  +7.68310000E-04
   -1.00970000E-04  +1.07813000E-03  +5.32890000E-04  +1.39765000E-03  -1.90297000E-03
   +1.67928100E-02  -2.09901000E-03  -7.87566100E-02  +6.01308700E-02  -2.97220500E-02
   -1.06781500E-02  +3.18721700E-02  -1.73068200E-02  +6.85670000E-04  -1.13760000E-04
   -1.77900000E-04  -2.64160000E-04  +1.21400000E-05  -9.76200000E-05  +1.68721340E-01
   -8.93400000E-05  +2.04371000E-03  +3.04195000E-03  -1.00650000E-04  -8.99000000E-04
   +2.10220000E-04  -3.03048000E-03  -2.82452000E-03  -3.73403000E-03  +1.93610700E-02
   -4.14128300E-02  +6.84793000E-03  +3.36225600E-02  -1.78620910E-01  +6.79517300E-02
   +1.16386100E-02  -1.02330100E-02  +1.17041100E-02  -6.82030000E-04  +2.16520000E-04
   +4.24640000E-04  +3.07980000E-04  -3.25200000E-05  +7.99400000E-05  -1.81578500E-01
   +4.64915230E-01  -1.19560000E-03  -2.69791000E-03  -5.62786000E-03  +2.30020000E-04
   +7.40360000E-04  +4.05150000E-04  -8.18720000E-04  -1.68670000E-03  -2.73749000E-03
   +8.62804000E-03  -2.12065100E-02  +1.40910100E-02  -3.55070000E-03  +2.06003700E-02
   -1.22162490E-01  -1.76895400E-02  +3.23122600E-02  -1.14266800E-02  +2.76640000E-04
   +1.19100000E-05  +1.80630000E-04  -9.41700000E-05  +1.75100000E-05  -7.48400000E-05
   -1.27443770E-01  +9.97130000E-02  +4.36811980E-01  -1.38522000E-03  +3.76120000E-04
   +1.16786000E-03  -3.59915400E-02  -1.16213100E-02  -5.61790000E-03  -6.76170000E-04
   +9.06730000E-04  +2.04627000E-03  -5.96120000E-04  +6.24740000E-04  -7.78050000E-04
   +2.40610000E-04  +2.79490000E-04  -2.41810000E-04  +4.45960000E-04  -1.03944000E-03
   -6.46270000E-04  -1.34443100E-01  -4.84040000E-02  -6.30289000E-03  -1.00905000E-03
   -6.30531000E-03  -7.27608000E-03  -1.64730000E-04  -2.80000000E-06  -2.81800000E-05
   +5.39982500E-01  +3.07341000E-03  -4.73300000E-04  -6.46270000E-04  +6.81918000E-03
   +1.33645400E-02  +3.16305000E-03  +1.04687000E-03  -2.70164000E-03  -1.12874000E-03
   +9.02550000E-04  -4.17010000E-04  +8.29240000E-04  -5.98200000E-04  +6.79510000E-04
   +2.58870000E-04  -2.77490000E-04  +4.52600000E-05  -1.79220000E-04  -4.32599700E-02
   -1.13431070E-01  +6.85722000E-03  -1.63000600E-02  -1.88702100E-02  -8.93252000E-03
   +2.76520000E-04  -4.83110000E-04  +3.36000000E-05  +1.13864190E-01  +4.70299790E-01
   +1.92212000E-03  -4.01580000E-04  -8.59200000E-05  -4.33313000E-03  -1.46220000E-03
   -9.27660000E-04  -8.16500000E-05  +5.97320000E-04  +9.49200000E-05  -2.22460000E-04
   +2.12270000E-04  -1.02760000E-04  -1.09330000E-04  -5.07500000E-05  -1.36390000E-04
   +2.08550000E-04  +2.54660000E-04  +6.84400000E-05  -9.54773000E-03  +4.11016000E-03
   -8.08636500E-02  -2.25215200E-02  -1.97717800E-02  -3.59986000E-03  +9.08900000E-05
   -8.03000000E-05  +1.19730000E-04  +1.64487900E-01  -1.78383160E-01  +4.78465720E-01
   +9.83430000E-04  -5.16440000E-04  -7.77260000E-04  -1.24511000E-03  -1.13986000E-03
   -1.83830000E-04  -7.84060000E-04  +6.66900000E-04  -3.78600000E-05  +9.04100000E-05
   -1.12690000E-04  -1.76400000E-04  -1.43090000E-04  -1.67780000E-04  +7.82900000E-05
   -4.85280000E-04  +5.24690000E-04  -1.18100000E-05  -1.77251000E-02  -1.43409000E-03
   -1.32362000E-02  -6.25980000E-04  +1.47256000E-03  +8.08600000E-04  +1.12340000E-04
   -1.52100000E-05  +4.79900000E-05  -2.27724770E-01  -2.66160400E-02  -9.76717900E-02
   +5.53811300E-01  +5.58110000E-04  -2.77980000E-04  -4.02430000E-04  -8.95630000E-04
   -2.24022000E-03  -6.90620000E-04  -7.98450000E-04  +7.66840000E-04  +9.51600000E-05
   +1.80100000E-05  -4.61100000E-05  -1.94980000E-04  +7.50700000E-05  -1.91800000E-04
   -7.78000000E-06  -3.72250000E-04  +3.88740000E-04  +1.12400000E-04  -1.45740000E-02
   +5.79013000E-03  -1.31638600E-02  -1.85311000E-03  -1.09561000E-03  +1.41230000E-04
   -4.13000000E-06  +8.66500000E-05  +4.93000000E-06  +1.80606800E-02  -1.10362620E-01
   +5.48383600E-02  +1.58283830E-01  +5.19625200E-01  +9.31680000E-04  -4.85860000E-04
   -9.41530000E-04  +1.64650000E-03  +1.23069000E-03  +3.94410000E-04  -2.75430000E-04
   -2.08100000E-04  -8.65000000E-06  +2.32150000E-04  -2.58260000E-04  +1.09050000E-04
   -3.35980000E-04  +2.88400000E-05  -2.86800000E-05  -2.75570000E-04  +4.82530000E-04
   +2.52770000E-04  -1.91822000E-03  -3.32914000E-03  +3.26633000E-03  +6.45430000E-04
   +7.05550000E-04  -1.14300000E-05  +2.10690000E-04  -2.06800000E-04  +1.23640000E-04
   -1.39989550E-01  +2.22662400E-02  -1.93889490E-01  +1.63824970E-01  -2.40817040E-01
   +4.95345500E-01  -4.04780000E-04  +1.07910000E-04  +7.62900000E-05  +7.59100000E-05
   -7.42770000E-04  -2.79840000E-04  +1.67360000E-04  +4.05200000E-05  +1.95440000E-04
   -6.87200000E-05  +7.94400000E-05  +6.51000000E-06  +2.14870000E-04  -9.70300000E-05
   -1.01380000E-04  +2.74620000E-04  -1.35250000E-04  +1.27290000E-04  +8.03910000E-04
   +2.13120000E-04  -4.28185000E-03  -1.41059000E-03  -8.71330000E-04  +7.22200000E-05
   -1.11810000E-04  +1.04840000E-04  -6.54000000E-06  -4.34465600E-02  +2.84378000E-03
   -4.09943400E-02  -2.41999940E-01  -1.46738490E-01  +7.76220000E-04  +5.92345510E-01
   -9.44860000E-04  +3.35100000E-04  +1.83030000E-04  -4.56840000E-04  -1.39528000E-03
   -6.33490000E-04  +2.51530000E-04  +8.88900000E-05  +4.28650000E-04  -2.00650000E-04
   +1.98620000E-04  -4.09600000E-05  +3.62630000E-04  -2.40550000E-04  -1.12730000E-04
   +4.68980000E-04  -3.20070000E-04  +8.58500000E-05  -7.80700000E-04  +2.90406000E-03
   +2.74621000E-03  -3.99000000E-06  -2.88180000E-04  +3.71910000E-04  -2.11340000E-04
   +2.67920000E-04  -5.85800000E-05  -3.20263000E-02  +3.61983600E-02  -5.08880500E-02
   -1.01420270E-01  -1.86935260E-01  +4.34186700E-02  +1.63303850E-01  +4.84879340E-01
   +9.56400000E-05  -2.70890000E-04  -3.39680000E-04  -8.80240000E-04  -5.25090000E-04
   -1.56500000E-04  -2.41580000E-04  +2.12800000E-04  +5.30200000E-05  +4.17500000E-05
   -4.76900000E-05  -6.76600000E-05  -1.49920000E-04  +7.33200000E-05  -5.82000000E-05
   -9.49100000E-05  +1.57040000E-04  +8.01600000E-05  -4.21274000E-03  +3.88027000E-03
   +8.94870000E-04  +1.21338000E-03  +1.01148000E-03  -1.36690000E-04  +9.81000000E-05
   -1.18770000E-04  +7.49100000E-05  -7.97339000E-03  -2.54688100E-02  +2.47246300E-02
   -4.18787700E-02  +9.72246000E-03  -1.00153830E-01  +2.00060280E-01  -2.18669870E-01
   +4.84859930E-01  +4.00900000E-05  -1.33080000E-04  -1.61620000E-04  -4.02580000E-04
   +2.75150000E-04  -1.75650000E-04  +3.30970000E-04  -3.39410000E-04  -3.24700000E-05
   -3.58500000E-05  +4.67900000E-05  -1.13200000E-05  -7.30140000E-04  +2.96830000E-04
   -1.80100000E-05  +1.66870000E-04  +2.19200000E-04  +2.43660000E-04  -2.24440000E-03
   -3.50080000E-04  -3.61220000E-04  +4.30670000E-04  +6.66300000E-05  -7.38600000E-05
   +4.38280000E-04  -4.17740000E-04  +1.55900000E-04  -1.25525500E-02  +2.25020900E-02
   -2.72253400E-02  +3.10240200E-02  -1.12543300E-02  +3.21628800E-02  -1.20661930E-01
   -4.32770700E-02  +1.62888000E-03  +5.92080230E-01  +5.81730000E-04  -4.32730000E-04
   -3.39410000E-04  -2.36780000E-04  +1.26559000E-03  +3.84700000E-04  -6.72200000E-05
   -1.83840000E-04  -2.49650000E-04  +1.43570000E-04  -1.63620000E-04  +1.27200000E-05
   -6.62570000E-04  +3.74930000E-04  +2.89300000E-05  -2.54060000E-04  +3.31780000E-04
   +7.62600000E-05  +2.00240000E-04  -8.35970000E-04  +9.12310000E-04  +9.02580000E-04
   +7.03790000E-04  -3.21170000E-04  +3.86450000E-04  -4.46000000E-04  +1.38230000E-04
   +2.08411200E-02  -2.19277700E-02  +3.08136600E-02  -4.98582000E-02  -3.70322800E-02
   -3.38830000E-04  +1.07666900E-02  -2.11319850E-01  +1.43611970E-01  +1.56603870E-01
   +5.12346020E-01  -6.56520000E-04  +3.06490000E-04  +3.94170000E-04  -2.21850000E-04
   -7.90900000E-04  -5.29390000E-04  +4.58700000E-04  -1.12270000E-04  +2.71340000E-04
   -2.23960000E-04  +1.93630000E-04  -2.01100000E-05  +1.44150000E-04  -9.35000000E-05
   -2.36500000E-05  +4.11400000E-04  -2.95270000E-04  +5.74800000E-05  -1.18376000E-03
   +1.95290000E-04  -1.60971000E-03  -6.14050000E-04  -6.47490000E-04  +4.71960000E-04
   -7.80800000E-05  +1.15400000E-04  -4.32200000E-05  -2.53244900E-02  +3.21243000E-02
   -5.54020900E-02  +6.94134000E-02  +2.85495000E-02  +2.65449700E-02  -4.97332100E-02
   +1.02407770E-01  -2.04009100E-01  +1.75774800E-01  -2.12352370E-01  +4.97192040E-01
   +5.51850000E-04  -2.33440000E-04  -4.04110000E-04  +2.96820000E-04  +3.47490000E-04
   +6.24260000E-04  -5.38950000E-04  +3.18620000E-04  -1.68230000E-04  +2.60200000E-04
   -2.01040000E-04  +1.49000000E-05  +1.59270000E-04  -1.03950000E-04  -5.10000000E-06
   -4.03140000E-04  +2.30910000E-04  -1.36300000E-04  +4.07768000E-03  +3.20680000E-04
   -1.47448000E-03  -1.23310000E-04  +5.84100000E-05  -3.44090000E-04  -9.33000000E-05
   +1.04460000E-04  -2.42500000E-05  +2.49756500E-02  -4.84796000E-02  +6.00219700E-02
   -5.87100100E-02  -1.73267100E-02  -2.47738600E-02  +3.39129900E-02  +5.58401400E-02
   -3.36435000E-02  -2.06348720E-01  -1.71382300E-02  -8.60965400E-02  +5.72439380E-01
   +3.22670000E-04  -4.31300000E-05  -2.20380000E-04  +5.67350000E-04  +4.36000000E-06
   -9.22400000E-05  -2.10550000E-04  +2.10890000E-04  -1.77610000E-04  -2.92300000E-05
   -1.81000000E-05  -4.43000000E-05  -1.94310000E-04  -1.39300000E-05  +5.37100000E-05
   -2.39350000E-04  +2.88450000E-04  -7.13900000E-05  +5.10260000E-04  +5.21550000E-04
   +5.45336000E-03  +6.25970000E-04  +7.70230000E-04  +5.18100000E-05  +1.02860000E-04
   -2.56200000E-05  +2.03900000E-05  -1.43457700E-02  -3.21531500E-02  +2.71240500E-02
   -1.86110200E-02  -8.37734000E-03  -8.66896000E-03  +2.48070300E-02  +1.62416600E-02
   +1.11931000E-02  +3.48967300E-02  -1.15232090E-01  +6.76760700E-02  +1.81363260E-01
   +5.39433090E-01  +2.43530000E-04  -2.22040000E-04  -1.95370000E-04  -5.19730000E-04
   +5.33800000E-05  +1.80730000E-04  -3.61610000E-04  +1.56230000E-04  +6.56000000E-06
   +2.16280000E-04  -1.44060000E-04  +4.21100000E-05  +1.66730000E-04  -1.23130000E-04
   -3.50900000E-05  -2.30730000E-04  +1.32960000E-04  -1.16830000E-04  -1.43723000E-03
   +4.40671000E-03  -1.08075000E-03  -6.83700000E-05  +6.01300000E-05  -2.37840000E-04
   -9.58900000E-05  +1.55350000E-04  -2.24200000E-05  +2.63443200E-02  +1.45121000E-03
   +2.73320100E-02  -2.42735300E-02  -7.97912000E-03  -1.35006500E-02  -4.04023000E-03
   +3.47520400E-02  -2.77210700E-02  -1.34665130E-01  +2.83336000E-02  -1.99556130E-01
   +1.61108900E-01  -2.47771070E-01  +4.84051560E-01  -1.58163000E-03  +4.25440000E-04
   +1.06460000E-03  -3.17770000E-04  -3.23035000E-03  +1.25950000E-03  +6.52900000E-04
   -2.21380000E-04  +4.33300000E-04  -2.23760000E-04  +3.42280000E-04  -1.45850000E-04
   +1.08940000E-04  -6.90100000E-05  +1.31290000E-04  +5.94540000E-04  -4.08040000E-04
   +1.30000000E-05  -2.31061000E-03  -2.05700300E-02  +1.81823100E-02  -4.53830000E-04
   -4.65270000E-04  +1.56527000E-03  -7.09500000E-05  +8.83200000E-05  -1.02300000E-04
   -1.15472970E-01  -2.23450000E-04  -3.46103200E-02  +3.34434800E-02  +2.62789300E-02
   -6.74449000E-03  -1.81334800E-02  -2.47338300E-02  +1.23482000E-02  -4.73733000E-02
   +2.59127000E-03  -3.97056600E-02  -2.56999380E-01  -1.58116630E-01  +1.35751000E-03
   +6.13535130E-01  +2.33850000E-04  -4.20230000E-04  -9.53370000E-04  +4.30410000E-04
   -6.73140000E-04  +6.72280000E-04  -9.12600000E-05  +2.24500000E-05  +2.22390000E-04
   +1.77080000E-04  -1.39680000E-04  +8.94900000E-05  -9.46200000E-05  -2.58030000E-04
   -1.56150000E-04  +7.45400000E-05  +3.31790000E-04  +3.58970000E-04  -7.79664000E-03
   -1.71953200E-02  +1.18521400E-02  -8.32050000E-04  -4.88810000E-04  +1.24923000E-03
   +1.00060000E-04  -6.84000000E-06  +1.17990000E-04  -4.50059100E-02  -2.08661530E-01
   +9.55200100E-02  +6.11158100E-02  +1.48120200E-02  +3.91430400E-02  -2.82521000E-02
   -4.82532700E-02  +2.14623000E-02  -3.55646400E-02  +3.85642400E-02  -6.09633000E-02
   -1.12502200E-01  -2.00651260E-01  +4.74233900E-02  +1.61741670E-01  +4.89850590E-01
   +7.19880000E-04  +3.33370000E-04  -1.80430000E-04  +5.76840000E-04  +4.94200000E-04
   +4.76120000E-04  -1.63770000E-04  +1.52860000E-04  -5.71000000E-04  -1.55170000E-04
   +2.03220000E-04  -1.59510000E-04  -8.39600000E-05  -4.14100000E-05  +2.44350000E-04
   -3.73790000E-04  +1.68830000E-04  -9.10900000E-05  +4.82134000E-03  +5.80620000E-04
   +4.92159000E-03  -7.93150000E-04  -1.13075000E-03  -1.82520000E-04  +4.79100000E-05
   +5.04800000E-05  -1.06750000E-04  +8.80284000E-03  +1.28831640E-01  -1.85657940E-01
   -3.98349800E-02  +1.33280200E-02  -3.38175500E-02  +1.56517000E-02  +2.43012600E-02
   -1.46739600E-02  -3.34158000E-03  -3.25691000E-02  +3.03241300E-02  -4.16188500E-02
   +1.32752100E-02  -1.04218670E-01  +1.93819010E-01  -2.00334250E-01  +4.76795370E-01
   -4.15650000E-04  +3.11820000E-04  +2.12260000E-04  +4.16000000E-04  -1.06808000E-03
   -4.27900000E-05  -2.42380000E-04  +3.81630000E-04  +2.54090000E-04  -3.45600000E-05
   +5.13300000E-05  -1.54000000E-06  +9.04630000E-04  -4.72550000E-04  -3.17900000E-05
   +9.00000000E-06  -2.94430000E-04  -1.98210000E-04  +1.40249000E-03  +7.98450000E-04
   -3.72530000E-04  -1.14128000E-03  -5.53280000E-04  +4.68960000E-04  -5.32970000E-04
   +5.78650000E-04  -1.88050000E-04  -1.26324000E-03  -3.71495000E-03  +4.52640000E-03
   +1.19940000E-04  -1.73092000E-03  -3.99663000E-03  -7.74365000E-03  -1.54599800E-02
   +1.24357000E-03  -2.10101380E-01  -1.36842100E-01  +3.95147000E-03  -4.38158200E-02
   -3.27564200E-02  -7.68359000E-03  +3.78427000E-03  +4.85708000E-03  -5.39366000E-03
   +5.02919570E-01  -4.01570000E-04  +3.21970000E-04  +1.91520000E-04  +3.75270000E-04
   -9.72180000E-04  -6.54800000E-05  -1.45410000E-04  +2.91290000E-04  +2.16090000E-04
   -5.13200000E-05  +8.19900000E-05  -5.96000000E-06  +6.93210000E-04  -4.39600000E-04
   +1.14000000E-06  +5.56700000E-05  -2.33190000E-04  -1.60970000E-04  +1.13116000E-03
   +3.27940000E-04  -9.71770000E-04  -1.01658000E-03  -5.53530000E-04  +3.89380000E-04
   -4.04420000E-04  +5.13660000E-04  -1.57080000E-04  -2.80414000E-03  -6.15740000E-04
   -1.98458000E-03  +3.63469000E-03  +3.27892000E-03  +7.11155000E-03  -4.10609800E-02
   -2.89361300E-02  +5.63281000E-03  -1.03360160E-01  -1.74947430E-01  +4.56833300E-02
   -7.09770000E-03  +6.50146000E-03  -4.67509000E-03  +1.00480000E-04  -4.14840000E-04
   +5.09867000E-03  +1.00667230E-01  +2.55346160E-01  +2.10200000E-05  -4.42100000E-05
   -6.41300000E-05  +6.51500000E-05  +9.05800000E-05  +1.31690000E-04  -4.76300000E-05
   -6.25000000E-06  -6.70000000E-06  +5.03900000E-05  -3.10200000E-05  +2.22600000E-05
   +1.08100000E-05  +2.02000000E-06  -2.64100000E-05  -2.76300000E-05  +2.10500000E-05
   +4.16000000E-06  +4.54350000E-04  -3.53380000E-04  -2.88600000E-05  -2.91000000E-06
   +2.39500000E-05  -6.80100000E-05  -3.31000000E-06  +2.96000000E-06  +1.58900000E-05
   +2.74862000E-03  -3.39311000E-03  +4.05861000E-03  -9.32910000E-03  +2.97876000E-03
   -2.01723000E-03  +2.56318700E-02  +2.52204600E-02  +5.41213000E-03  -2.76845000E-02
   +2.03654100E-02  -8.41921300E-02  -3.17837000E-02  -2.40446100E-02  +5.91512000E-03
   -9.35950000E-04  +8.64465000E-03  -4.01085000E-03  +2.63686360E-01  -1.39517660E-01
   +3.58296190E-01  -1.22728000E-03  +1.07297000E-03  -3.95630000E-04  -3.51274000E-03
   +1.78439100E-02  -2.27893900E-02  -1.43878000E-03  +1.37809000E-03  +1.73704000E-03
   -1.20513000E-03  -5.02840000E-04  +3.36900000E-04  +8.02460000E-04  -5.84360000E-04
   -2.37370000E-04  +3.46190000E-04  -6.01850000E-04  -8.98900000E-05  -7.41443600E-02
   +2.01594000E-03  -2.18002000E-03  +5.18660000E-04  -1.45821000E-03  +3.04271000E-03
   -3.91170000E-04  +4.54890000E-04  -4.35000000E-05  -1.05453000E-03  -1.82863900E-02
   +2.24766500E-02  -1.59012000E-03  -1.06976000E-03  +5.41470000E-04  +2.12800000E-04
   -3.77970000E-04  +7.08800000E-04  +3.91650000E-04  +2.12380000E-04  -1.57400000E-05
   +3.40450000E-04  -1.17262000E-03  +8.08100000E-04  -4.55450000E-03  -2.50265000E-03
   -1.36966000E-03  -5.05540000E-04  -4.03900000E-04  -2.85900000E-05  +5.82644590E-01
   +9.04900000E-04  -5.36540000E-04  +1.49310000E-04  +9.29650000E-03  -1.73723200E-02
   +1.67727200E-02  -1.30420000E-03  -7.98180000E-04  -9.39200000E-04  +7.32300000E-04
   -1.55700000E-05  -2.86770000E-04  -8.96700000E-05  +2.94480000E-04  +1.35590000E-04
   -3.79710000E-04  +6.46380000E-04  +1.02220000E-04  -6.30253000E-03  -1.10299490E-01
   +4.79204700E-02  +1.17550000E-04  +1.05195700E-02  -1.29354500E-02  +5.85400000E-05
   -1.46580000E-04  -3.07600000E-05  -5.60812000E-03  -1.68005600E-02  +1.80844400E-02
   -3.26970000E-04  -7.16650000E-04  -5.80520000E-04  +5.77990000E-04  -4.77510000E-04
   +6.62570000E-04  -1.55730000E-04  +8.04500000E-05  +8.04500000E-05  +3.56380000E-04
   -5.99500000E-04  +6.68790000E-04  -3.28618000E-03  -7.34120000E-04  -6.22370000E-04
   -1.30800000E-05  -6.38900000E-05  +1.04100000E-05  -3.33620000E-03  +5.32753620E-01
   +1.97863000E-03  -1.12303000E-03  +4.54800000E-05  -9.37948000E-03  +8.80366000E-03
   -2.00033000E-03  +1.03953000E-03  -3.34450000E-04  -4.76950000E-04  -3.04000000E-06
   +5.14800000E-05  +1.22510000E-04  -2.25710000E-04  +3.04960000E-04  +3.39950000E-04
   -4.77440000E-04  +2.99400000E-05  -3.90820000E-04  +6.48753000E-03  +4.23154900E-02
   -1.32899330E-01  +1.57392000E-03  +1.60293500E-02  -3.69283000E-02  +1.13160000E-04
   -2.03610000E-04  -4.57700000E-05  +4.08080000E-03  +1.46537000E-03  +8.25170000E-04
   -1.18438000E-03  -9.51140000E-04  +1.15690000E-04  -2.06830000E-04  -7.60800000E-05
   -1.44230000E-04  +2.27340000E-04  +1.14250000E-04  +2.11580000E-04  -4.05150000E-04
   -2.56980000E-04  +1.36730000E-04  -1.30334000E-03  -9.48000000E-04  -5.24100000E-05
   -3.24910000E-04  -2.39010000E-04  -4.74600000E-05  +6.86522000E-03  +6.63761600E-02
   +5.13032330E-01  -1.23011000E-03  -5.53510000E-03  -5.44394000E-03  -1.37835000E-03
   -6.35780000E-04  +1.64733000E-03  +2.68719000E-03  -4.49500000E-05  +3.23249000E-03
   -2.03863500E-02  +2.15217000E-03  +2.17221100E-02  -1.60773260E-01  +1.52399000E-03
   +2.90945800E-02  -5.03630700E-02  -9.53928000E-03  +1.88300700E-02  +9.76510000E-04
   -3.89630000E-04  -2.76030000E-04  -4.15020000E-04  +7.17300000E-05  -1.91340000E-04
   +9.09037000E-03  -5.92544000E-03  +4.04771000E-03  -8.86900000E-05  +5.66560000E-04
   +4.51000000E-05  +5.76100000E-05  -6.77800000E-05  +2.51120000E-04  -1.56880000E-04
   -2.85940000E-04  +1.07990000E-04  +6.18680000E-04  +5.47110000E-04  -9.04700000E-05
   -1.54690000E-04  +1.30000000E-04  -1.43960000E-04  -4.76900000E-05  +1.94800000E-05
   +7.28400000E-05  -7.65040000E-04  -5.83110000E-04  -1.50300000E-05  -7.37370000E-04
   +1.15770000E-04  +1.57420000E-04  +2.92301690E-01  -1.71824000E-03  -1.45745000E-03
   -2.15371000E-03  -3.91120000E-04  +3.39900000E-05  -1.22430000E-04  -3.70300000E-05
   -1.05470000E-04  -1.06175000E-03  +1.52124700E-02  +8.70622000E-03  -8.41090000E-03
   -1.72468000E-02  -7.69122700E-02  +1.70762300E-02  -1.28100400E-02  +4.57896000E-03
   +5.25406000E-03  -4.79000000E-05  +9.78500000E-05  +2.54710000E-04  -2.82900000E-05
   -1.63200000E-05  -5.49000000E-06  -3.43599000E-02  -3.49993600E-02  +4.20578800E-02
   -4.13200000E-05  -1.38850000E-04  -9.80000000E-06  +1.54000000E-05  +4.00400000E-05
   +1.36000000E-06  +2.74500000E-05  +7.55800000E-05  -1.29300000E-05  -3.57500000E-05
   -7.85200000E-05  +2.93300000E-05  +1.49600000E-05  +1.46100000E-05  +3.34500000E-05
   +2.01200000E-05  +6.41300000E-05  +2.78000000E-06  +8.47000000E-05  +9.71300000E-05
   +5.17000000E-06  +8.99100000E-05  -1.16760000E-04  -1.47540000E-04  -7.30618200E-02
   +4.25014380E-01  -4.49070000E-04  -7.96950000E-04  -1.05337000E-03  +8.48460000E-04
   +7.67780000E-04  -4.20300000E-05  -2.36989000E-03  -1.50360000E-03  -5.01067000E-03
   +3.65051400E-02  +2.33553000E-03  -1.90848900E-02  +5.07962000E-02  +1.37889000E-02
   -8.88701600E-02  -8.45901000E-03  -2.08811000E-03  +1.18388400E-02  -2.37270000E-04
   +2.36170000E-04  +3.82410000E-04  +9.27700000E-05  -8.92500000E-05  +3.92100000E-05
   +2.39960100E-02  +3.16100000E-02  -2.29073800E-02  +7.39500000E-05  -3.13500000E-04
   +5.65400000E-05  -3.49700000E-05  +4.52200000E-05  -6.41600000E-05  +8.87800000E-05
   +1.46610000E-04  -4.11000000E-06  -2.03540000E-04  -1.99800000E-04  +2.66400000E-05
   +6.65800000E-05  -4.60900000E-05  +7.39200000E-05  -4.53400000E-05  +7.57100000E-05
   -1.16430000E-04  +2.76320000E-04  +2.10730000E-04  +2.42500000E-05  +3.31760000E-04
   -1.14810000E-04  -2.23380000E-04  -2.38373700E-02  -2.85806130E-01  +2.98080770E-01
   +5.23400000E-05  -5.32900000E-05  -6.63800000E-05  -3.77400000E-05  +1.65840000E-04
   +2.28200000E-05  +2.18900000E-05  -4.77400000E-05  -3.53600000E-05  +1.47000000E-05
   -1.19600000E-05  +2.00000000E-06  -1.64380000E-04  +6.32900000E-05  +2.16000000E-06
   -3.53000000E-06  +6.45300000E-05  +3.39600000E-05  -1.27230000E-04  -1.11050000E-04
   +1.35980000E-04  +1.38060000E-04  +6.63800000E-05  -4.88100000E-05  +9.80900000E-05
   -8.08400000E-05  +3.51600000E-05  +6.04400000E-04  -1.93410000E-04  +4.93180000E-04
   -1.04534000E-03  +1.24780000E-04  -4.04730000E-04  +4.01931000E-03  +3.18267000E-03
   +7.31110000E-04  -3.04980400E-02  +7.38573000E-03  -2.80704700E-02  -2.31389000E-03
   -5.32214000E-03  +1.58917000E-03  +2.05000000E-06  +7.17930000E-04  -1.89404000E-03
   -2.44501530E-01  +4.84046000E-02  -2.27435540E-01  +6.33200000E-05  +1.08700000E-05
   +2.40500000E-05  +1.38970000E-04  -2.60000000E-06  -4.32600000E-05  +2.73552380E-01
   +3.47100000E-05  -3.05100000E-05  -1.25000000E-05  -4.74700000E-05  +7.55200000E-05
   +3.22900000E-05  +1.61600000E-05  -3.06700000E-05  -2.03100000E-05  +1.03000000E-06
   -4.84000000E-06  -5.49000000E-06  -7.67800000E-05  +5.64800000E-05  -8.00000000E-07
   -7.87000000E-06  +2.32800000E-05  +1.90900000E-05  +2.10000000E-05  -9.02000000E-05
   +5.97400000E-05  +1.94700000E-05  +1.38100000E-05  -4.36000000E-06  +4.48200000E-05
   -6.41800000E-05  +1.53200000E-05  +3.00550000E-04  -2.47650000E-04  +5.30770000E-04
   -1.24840000E-04  -6.27670000E-04  -1.64580000E-04  -1.15808000E-03  +7.64890000E-04
   -2.48204000E-03  -2.43237500E-02  +3.37800000E-03  -2.39479500E-02  -4.28221000E-03
   -2.68543000E-03  +1.36878000E-03  -5.53970000E-04  +1.56072000E-03  -3.27040000E-04
   +8.26428300E-02  -5.83773400E-02  +1.14017970E-01  +3.52400000E-05  +3.12700000E-05
   -9.32000000E-06  +6.51000000E-05  -1.55600000E-05  -2.61100000E-05  -5.32462000E-02
   +5.72841900E-02  +4.06400000E-05  -1.89800000E-05  +1.61000000E-06  -3.52600000E-05
   +5.57400000E-05  -7.83000000E-06  +1.43200000E-05  -1.99500000E-05  -1.15400000E-05
   +1.12000000E-06  -4.52000000E-06  -4.02000000E-06  -3.30800000E-05  +2.11000000E-05
   +1.16600000E-05  -3.45000000E-06  +1.04300000E-05  +4.61000000E-06  -1.20230000E-04
   -3.56800000E-05  +3.14500000E-05  +8.82300000E-05  +6.47000000E-05  -4.08400000E-05
   +1.80000000E-05  -2.83800000E-05  +9.20000000E-07  +1.40130000E-04  +1.50190000E-04
   -6.71000000E-05  -1.51130000E-04  +2.72500000E-05  -8.51540000E-04  +4.84493000E-03
   +8.05800000E-04  +1.99881000E-03  +1.81564000E-03  -4.53700000E-05  -1.15034000E-03
   +6.70100000E-04  +5.95330000E-04  +2.14709000E-03  -7.29990000E-04  +6.01460000E-04
   +5.18540000E-04  -2.59743630E-01  +8.82084500E-02  -2.83145370E-01  +3.24000000E-05
   +8.00000000E-08  +2.90600000E-05  +3.07600000E-05  -9.61000000E-06  -2.16700000E-05
   +2.53561950E-01  -9.03222300E-02  +2.81011600E-01  -5.80900000E-05  +5.52000000E-06
   -2.72600000E-05  +4.45600000E-05  -2.59530000E-04  -6.93100000E-05  -8.48900000E-05
   +9.95100000E-05  +5.03400000E-05  -4.40000000E-07  -1.19000000E-06  -1.02900000E-05
   +9.38300000E-05  -5.73800000E-05  -2.09000000E-05  -1.67700000E-05  -1.85000000E-06
   +3.85000000E-06  -1.46180000E-04  +5.54950000E-04  -8.91770000E-04  -2.38470000E-04
   -1.10610000E-04  +9.10400000E-05  -5.11600000E-05  +6.22600000E-05  -1.01700000E-05
   -8.24400000E-04  -5.43757000E-03  -6.92710000E-04  -1.38516600E-02  +5.45596000E-03
   -1.73169100E-02  -1.98825810E-01  +1.72271200E-02  -1.43044050E-01  +1.07983000E-03
   -3.84551000E-03  +1.26145000E-03  +2.66467000E-03  -1.56562000E-03  -8.58420000E-04
   -2.35960000E-04  -2.67470000E-04  +8.70850000E-04  +1.92303000E-03  +2.13557000E-03
   +2.55546000E-03  -3.89600000E-05  +8.87500000E-05  -4.58200000E-05  -8.26200000E-05
   +1.52100000E-05  +4.34500000E-05  +4.30400000E-05  +6.70100000E-04  -1.03973000E-03
   +2.08983340E-01  -2.63300000E-05  +1.68000000E-05  +2.57200000E-05  -1.59300000E-04
   -2.89750000E-04  -7.77300000E-05  -8.68000000E-06  +5.78100000E-05  +3.47100000E-05
   -2.95900000E-05  +2.43400000E-05  -2.28500000E-05  +4.75000000E-05  -3.41400000E-05
   -1.43000000E-06  +1.10500000E-05  -7.56000000E-06  -8.20000000E-06  -6.07790000E-04
   +5.10250000E-04  -3.82730000E-04  -7.41800000E-05  +2.84100000E-05  +5.92500000E-05
   -2.51000000E-05  +2.95500000E-05  -1.00700000E-05  -4.86741000E-03  +2.55270000E-04
   +2.42973000E-03  -1.45561600E-02  +6.02009000E-03  -1.48287600E-02  +1.73239300E-02
   -5.47147200E-02  +3.42928000E-02  +1.73387800E-02  +1.95497000E-03  +1.53976700E-02
   -1.98693000E-03  -1.36601000E-03  +5.19492000E-03  -4.93000000E-04  -1.38536000E-03
   -1.86200000E-05  +2.65498000E-03  +3.99090000E-04  -2.27282000E-03  +7.80800000E-05
   +4.75400000E-05  -6.81500000E-05  -4.05800000E-05  +3.02000000E-06  +1.20900000E-05
   -1.25349000E-03  -6.24130000E-04  +1.87390000E-04  -1.61964700E-02  +5.02709000E-02
   -1.73200000E-05  +1.99500000E-05  +2.44300000E-05  -9.14900000E-05  -1.20760000E-04
   -3.09400000E-05  +1.38000000E-06  +1.86500000E-05  +2.99300000E-05  -1.43200000E-05
   +9.89000000E-06  -6.20000000E-06  +5.56900000E-05  -2.35700000E-05  -2.61000000E-06
   +1.10000000E-05  -2.26400000E-05  -1.77700000E-05  -5.70000000E-06  +2.17670000E-04
   +2.48850000E-04  -5.00000000E-08  +6.64000000E-05  +2.22000000E-06  -3.34200000E-05
   +2.63000000E-05  -9.47000000E-06  -9.41270000E-04  +2.06285000E-03  +4.10447000E-03
   +1.59668000E-03  +3.57860000E-04  +2.95372000E-03  -1.43189210E-01  +3.43137000E-02
   -1.74431890E-01  -1.89159600E-02  -8.53890000E-04  -9.37189000E-03  -4.19240000E-04
   +5.56681000E-03  +1.13480000E-04  +1.15704000E-03  +2.20270000E-04  -3.73050000E-04
   +2.06934000E-03  -2.63358000E-03  -1.41000000E-05  -2.64000000E-06  -4.76600000E-05
   -5.39900000E-05  -4.91500000E-05  +1.40000000E-07  +1.49300000E-05  +8.04290000E-04
   +1.65223000E-03  -4.06430000E-04  +1.57260170E-01  -3.84900700E-02  +1.79358920E-01
   -4.17000000E-05  -1.21480000E-04  -8.38200000E-05  -1.98880000E-04  -8.52900000E-05
   +1.27030000E-04  -4.24000000E-06  -1.32100000E-05  +1.31900000E-05  +2.72400000E-05
   -1.09600000E-05  -5.09000000E-06  -5.67500000E-05  +7.69200000E-05  -5.88200000E-05
   +7.83000000E-06  +9.30000000E-06  +7.62200000E-05  -1.60700000E-05  +1.53565000E-03
   +1.48835000E-03  +3.52210000E-04  +1.09800000E-05  +1.05510000E-04  +3.93300000E-05
   -7.06500000E-05  +3.62800000E-05  +6.46960000E-03  +1.71064500E-02  -1.47326700E-02
   -5.38771700E-02  -8.71621000E-03  -3.62270000E-03  +2.92679000E-03  -1.87465800E-02
   +1.73395000E-02  -1.66052000E-03  -4.71011000E-03  -2.53378000E-03  -1.32599000E-03
   -7.81100000E-05  -7.10000000E-06  -2.02623000E-03  -1.29864000E-03  -5.46420000E-03
   -2.90180000E-04  -1.16493000E-03  +8.89430000E-04  -6.51180000E-04  -2.24790000E-04
   -7.08260000E-04  +5.73000000E-05  -1.40400000E-05  +1.95000000E-06  +1.72110000E-04
   +4.30000000E-05  +1.16390000E-04  -2.91550000E-04  +1.66328000E-03  +1.38754000E-03
   +5.21925300E-02  +1.55360000E-04  +5.02400000E-05  +1.24920000E-04  +1.98100000E-04
   +4.09760000E-04  +2.89440000E-04  +8.56800000E-05  -1.17380000E-04  -9.29000000E-05
   +1.44800000E-05  -6.22000000E-06  +1.80100000E-05  -2.41500000E-05  +4.18200000E-05
   +5.98600000E-05  -4.70900000E-05  -2.20100000E-05  -7.99500000E-05  +8.36770000E-04
   -2.11272000E-03  -1.24269000E-03  -3.94010000E-04  -2.41570000E-04  -6.85400000E-05
   +8.38000000E-06  -1.73800000E-05  -1.95300000E-05  -1.83530000E-04  +1.53151000E-03
   +2.59833000E-03  -8.50020000E-03  -2.01005000E-01  +1.49401620E-01  +1.00148000E-03
   -1.05526000E-02  +1.40603700E-02  -4.94284000E-03  +2.08869000E-03  +1.47981000E-03
   +5.51800000E-05  -1.73340000E-04  -9.63900000E-04  -1.17312000E-03  +3.38251000E-03
   +2.48008000E-03  -3.56020000E-04  -9.94280000E-04  +7.25930000E-04  -1.67395000E-03
   -1.06490000E-04  -2.78640000E-04  +2.30800000E-05  -1.89400000E-05  -3.98000000E-05
   +2.01270000E-04  +2.22700000E-05  +8.60300000E-05  +1.32121000E-03  -9.51810000E-04
   -2.07978000E-03  +1.48554600E-02  +2.10735290E-01  +4.18100000E-05  -3.70000000E-07
   +8.13000000E-05  +2.04990000E-04  +1.93060000E-04  +1.94040000E-04  +7.74900000E-05
   -8.19000000E-05  -3.82800000E-05  -2.03000000E-06  -6.82000000E-06  +1.35600000E-05
   +4.45000000E-06  +6.81100000E-05  -7.00000000E-07  -1.46000000E-05  -2.96200000E-05
   -1.28500000E-05  +2.34308000E-03  -5.58070000E-04  -1.69473000E-03  -6.47440000E-04
   -2.36780000E-04  -6.31000000E-06  -1.66000000E-06  -3.84600000E-05  +1.44000000E-06
   +2.04215000E-03  +1.58665600E-02  -9.28845000E-03  -4.02399000E-03  +1.49482710E-01
   -1.84127100E-01  -1.42950000E-03  -8.36730000E-04  +3.21271000E-03  -2.29755000E-03
   +1.65480000E-03  +4.23251000E-03  -9.49300000E-05  -1.04670000E-03  -3.02290000E-04
   -5.59685000E-03  +2.13421000E-03  +5.88970000E-04  +1.18700000E-04  +1.03920000E-04
   +6.32000000E-06  +5.10950000E-04  +8.37860000E-04  +4.15550000E-04  +4.63000000E-06
   -2.49100000E-05  -1.04600000E-05  -2.99200000E-05  -2.73500000E-05  -3.68000000E-05
   +1.70249000E-03  -1.82003000E-03  -1.13568000E-03  +5.70590000E-03  -1.65162640E-01
   +1.88589690E-01  -3.04190000E-04  +5.72400000E-05  +2.88890000E-04  -5.36420000E-04
   -7.38150000E-04  +3.59930000E-04  -1.14790000E-04  -1.35300000E-04  +7.45000000E-05
   -1.42160000E-04  +1.06130000E-04  -2.34700000E-05  -1.57630000E-04  +5.61400000E-05
   +3.17100000E-05  +2.10630000E-04  -9.30600000E-05  -5.13500000E-05  -7.92590000E-04
   +4.84820000E-04  +9.70370000E-04  -5.43000000E-06  -1.03040000E-04  -1.37300000E-04
   +8.46700000E-05  -8.77800000E-05  +1.48600000E-05  +4.42106000E-03  -7.50080000E-04
   +9.80780000E-04  +2.42564000E-03  -1.84497000E-03  -1.02868000E-03  -2.08400000E-04
   -2.34020000E-04  +9.09120000E-04  +1.17300000E-04  -5.28938000E-03  -1.06888000E-03
   -1.35935100E-02  +4.45317000E-03  -1.74361700E-02  -2.06190060E-01  +2.21211400E-02
   -1.41789650E-01  -1.07316000E-03  +1.86610000E-04  -9.59460000E-04  -5.48100000E-05
   +1.46070000E-04  +7.48200000E-05  +1.12830000E-04  -1.04000000E-05  -4.22200000E-05
   -2.92020000E-04  -1.24960000E-04  +6.76800000E-05  -1.99720000E-04  +2.19800000E-04
   +1.52550000E-04  +1.74310000E-04  -1.21680000E-04  +1.57820000E-04  +2.16058820E-01
   -2.85750000E-04  +3.50050000E-04  +4.16800000E-04  -4.09150000E-04  -8.07800000E-05
   -5.55200000E-05  +1.11050000E-04  -1.37830000E-04  +7.70600000E-05  -1.80670000E-04
   +7.73800000E-05  -5.99800000E-05  -8.70600000E-05  +2.70700000E-04  -5.57000000E-06
   +2.37720000E-04  -2.85100000E-04  -2.40000000E-05  +1.46586000E-03  -5.82430000E-04
   -1.08827000E-03  -1.16440000E-04  -6.04480000E-04  +3.87530000E-04  +2.05200000E-05
   -1.94770000E-04  +4.20100000E-05  +1.80398200E-02  +2.33577000E-03  +1.49793300E-02
   -2.27132000E-03  -1.29147000E-03  +5.41035000E-03  -3.03560000E-04  -1.08847000E-03
   -2.32700000E-04  -5.16725000E-03  +7.05930000E-04  +3.32704000E-03  -1.60169600E-02
   +6.53113000E-03  -1.37478800E-02  +2.26357100E-02  -5.87506300E-02  +3.36114100E-02
   -7.45930000E-04  +2.51440000E-04  -8.06370000E-04  +1.12390000E-04  +3.40500000E-05
   -7.25000000E-05  +7.72400000E-05  -7.56900000E-05  -4.19200000E-05  -2.02270000E-04
   -2.64350000E-04  -1.20630000E-04  +2.49810000E-04  -1.94120000E-04  -2.85930000E-04
   +9.71570000E-04  -5.34500000E-05  +8.28840000E-04  -1.96999700E-02  +5.47567400E-02
   -1.90260000E-04  -1.06730000E-04  -1.61470000E-04  +4.58080000E-04  +3.55090000E-04
   +1.38220000E-04  +1.24590000E-04  -4.04400000E-05  +1.77340000E-04  +1.43810000E-04
   -2.05000000E-05  +3.20000000E-05  +2.78520000E-04  -8.64100000E-05  -2.64600000E-05
   +1.34860000E-04  -1.84630000E-04  +8.26000000E-06  +8.68100000E-05  -1.89017000E-03
   -1.22164000E-03  +6.19000000E-06  -4.46700000E-05  -2.64900000E-05  -1.62560000E-04
   +1.05890000E-04  -3.10700000E-05  -1.64541300E-02  +1.47880000E-03  -9.14995000E-03
   -8.73250000E-04  +5.86847000E-03  +2.32920000E-04  +1.05664000E-03  -1.50610000E-04
   -2.12260000E-04  -1.35079000E-03  +3.17463000E-03  +4.61925000E-03  +1.14359000E-03
   +1.37807000E-03  +4.02964000E-03  -1.41303110E-01  +3.26392100E-02  -1.73423260E-01
   -2.12880000E-04  -1.53980000E-04  -1.72200000E-05  +2.53560000E-04  -1.93900000E-05
   -6.48000000E-05  -2.24940000E-04  +1.13400000E-05  +8.04900000E-05  +1.41810000E-04
   -6.90900000E-05  -5.80000000E-05  +1.44370000E-04  -3.08690000E-04  -3.13810000E-04
   -8.68380000E-04  -2.70000000E-07  -6.27230000E-04  +1.56147940E-01  -3.94018700E-02
   +1.77379310E-01  -3.44900000E-05  +2.45800000E-05  -1.42100000E-05  +1.38060000E-04
   -7.43700000E-05  -2.07000000E-06  -8.94000000E-06  +3.58400000E-05  +1.49400000E-05
   -1.15900000E-05  +2.71000000E-05  -1.39100000E-05  +7.95000000E-06  -9.72100000E-05
   +4.18400000E-05  +4.66000000E-06  +3.12500000E-05  -1.84500000E-05  +4.83730000E-04
   -6.71080000E-04  +7.97920000E-04  +1.07800000E-05  +7.04100000E-05  +1.05940000E-04
   +4.30000000E-06  +7.92500000E-05  -2.72800000E-05  -1.67458000E-03  -4.94366000E-03
   -2.56928000E-03  -1.47629000E-03  -2.17820000E-04  -1.55640000E-04  -2.20602000E-03
   -1.20753000E-03  -4.62840000E-03  +6.24994000E-03  +1.79480900E-02  -1.58996100E-02
   -5.49897400E-02  -1.51005700E-02  -1.67180000E-04  +3.62872000E-03  -1.81868500E-02
   +1.75305900E-02  +7.28870000E-04  +1.01585000E-03  +2.10884000E-03  -3.27750000E-04
   -1.32950000E-04  -9.64000000E-05  -2.39000000E-06  +2.92900000E-05  -1.01300000E-05
   +1.20430000E-04  +7.14800000E-05  +4.15000000E-04  +6.96500000E-05  +9.68800000E-04
   -8.25450000E-04  -1.07760000E-04  +2.02020000E-04  +2.75480000E-04  -3.06150000E-04
   +1.85811000E-03  +1.59002000E-03  +4.97479600E-02  +9.52000000E-06  +1.95500000E-05
   -3.77000000E-06  +2.12670000E-04  -9.62900000E-05  +8.71000000E-06  -3.27500000E-05
   +5.09200000E-05  -4.60000000E-06  -4.40000000E-06  +1.88000000E-06  -1.39300000E-05
   +4.59900000E-05  -2.78500000E-05  +1.37200000E-05  -1.82500000E-05  -2.27000000E-06
   -3.80000000E-06  +1.84430000E-04  -1.69570000E-04  +7.72560000E-04  -5.47100000E-05
   -1.93600000E-05  +2.68700000E-05  -2.71300000E-05  +2.72100000E-05  -1.93600000E-05
   -5.04806000E-03  +2.11592000E-03  +1.53526000E-03  +1.06930000E-04  -2.03400000E-05
   -7.98530000E-04  -8.59460000E-04  +2.70361000E-03  +1.87997000E-03  -3.06537000E-03
   +3.43190000E-04  +2.16051000E-03  -1.40527600E-02  -2.08852210E-01  +1.51148510E-01
   +1.41609000E-03  -9.89412000E-03  +1.30314600E-02  +1.29086000E-03  -5.73110000E-04
   -1.63517000E-03  -2.59810000E-04  -1.82450000E-04  -1.16680000E-04  -3.59600000E-05
   +2.95000000E-06  +4.47000000E-06  +1.34730000E-04  -1.53410000E-04  -2.38260000E-04
   +1.33200000E-05  -2.66100000E-05  -4.82200000E-05  +2.26620000E-04  -3.08720000E-04
   -2.14590000E-04  +1.42115000E-03  -1.16085000E-03  -2.30838000E-03  +1.83670600E-02
   +2.16388340E-01  +5.34000000E-05  -2.15000000E-05  -2.61000000E-06  +6.94500000E-05
   +4.64300000E-05  +3.20600000E-05  -1.14400000E-05  -1.10000000E-06  -4.23700000E-05
   +2.24000000E-06  -1.40900000E-05  -4.66000000E-06  -1.30700000E-05  +6.12100000E-05
   -4.58000000E-06  -2.39100000E-05  -1.05100000E-05  +1.89800000E-05  -3.02790000E-04
   +4.90100000E-05  +1.62050000E-04  +2.54800000E-05  -6.01000000E-06  -5.29000000E-05
   +1.66000000E-06  -5.79600000E-05  +4.39000000E-06  -2.27579000E-03  +2.01685000E-03
   +4.31066000E-03  -3.54790000E-04  -1.03834000E-03  -2.50770000E-04  -4.98557000E-03
   +1.57780000E-03  +1.88440000E-04  +3.55239000E-03  +1.79665000E-02  -9.02423000E-03
   -1.00080000E-03  +1.50179460E-01  -1.77041600E-01  -7.89260000E-04  -1.79716000E-03
   +3.99401000E-03  +1.93846000E-03  -1.79135000E-03  -2.19850000E-04  +1.51400000E-05
   -5.81300000E-05  +6.37000000E-06  +1.31900000E-05  -2.13200000E-05  -9.09000000E-06
   +3.47900000E-04  -2.92140000E-04  +3.14000000E-06  +1.06780000E-04  +6.71390000E-04
   -6.53210000E-04  +2.56040000E-04  -2.43970000E-04  -3.05100000E-04  +1.85050000E-03
   -1.98656000E-03  -1.53023000E-03  +1.49261000E-03  -1.65187640E-01  +1.80464100E-01
   +3.07030000E-04  -3.19270000E-04  -1.61210000E-04  +7.33320000E-04  +1.39746000E-03
   +9.69900000E-05  +1.19430000E-04  -2.10850000E-04  -1.37070000E-04  +1.05010000E-04
   -5.34300000E-05  +8.47500000E-05  -7.14400000E-05  +5.94000000E-06  +1.93300000E-05
   -1.75930000E-04  +5.49500000E-05  +4.93900000E-05  -1.12143000E-03  +4.71940000E-04
   -7.33740000E-04  -1.53120000E-04  +1.31010000E-04  -3.11500000E-04  +4.05500000E-05
   -1.62500000E-05  +9.83000000E-06  +6.32790000E-04  +1.28340000E-04  -1.52890000E-04
   -2.31530000E-04  +9.05100000E-05  -4.33690000E-04  +1.90440000E-04  -1.40620000E-04
   +2.32480000E-04  +9.21400000E-05  +6.24300000E-05  +3.23900000E-05  -7.34200000E-05
   -6.72000000E-05  +8.75100000E-05  +8.59100000E-05  +1.02730000E-04  -2.43480000E-04
   -1.64890000E-04  -1.59620000E-04  +3.29300000E-05  -2.30572600E-01  -1.25432880E-01
   -1.49968100E-02  +6.14900000E-05  +7.13000000E-06  -2.43000000E-05  +4.24300000E-05
   +2.76900000E-05  +9.40000000E-07  -1.81200000E-05  -5.79000000E-06  -2.32900000E-05
   +2.47440000E-04  -6.33200000E-05  +4.93190000E-04  +7.28500000E-05  -5.11100000E-05
   +4.53200000E-05  -2.61300000E-05  +2.93000000E-06  +1.93000000E-05  +2.47246680E-01
   -1.06000000E-05  -2.87340000E-04  -4.49000000E-04  -1.12084000E-03  +4.34720000E-04
   -1.39100000E-04  -1.13520000E-04  +1.57560000E-04  -1.16100000E-05  +3.41250000E-04
   -1.41700000E-04  +5.03200000E-05  +3.15600000E-05  -2.21900000E-04  +1.94000000E-06
   +8.31500000E-05  +4.06000000E-05  +4.29400000E-05  -1.62573500E-02  -1.34609900E-02
   -1.27685000E-03  +3.61430000E-04  +3.42310000E-04  -1.21364000E-03  -3.97400000E-05
   +1.41230000E-04  -2.49500000E-05  +1.15786000E-03  -1.58946000E-03  +3.78647000E-03
   +5.10830000E-04  +1.12340000E-04  +4.70350000E-04  -9.29700000E-05  +1.32310000E-04
   -4.06000000E-05  +2.95300000E-04  +1.17940000E-04  +9.98400000E-05  -3.38300000E-05
   -3.53950000E-04  +1.48400000E-04  -1.26685000E-03  -2.45100000E-04  -2.59510000E-04
   -2.54500000E-04  -1.90360000E-04  -4.15100000E-05  -1.24159420E-01  -1.31056510E-01
   -1.14434500E-02  -3.02400000E-05  +9.88600000E-05  +3.21300000E-05  +2.71500000E-05
   +1.48400000E-05  +1.75800000E-05  -5.04900000E-05  -1.03000000E-05  -2.50000000E-07
   +1.53270000E-04  -6.14200000E-05  -2.96580000E-04  +3.76000000E-06  +3.30500000E-05
   +7.44800000E-05  -7.11800000E-05  -1.07510000E-04  -3.25500000E-05  +1.36573340E-01
   +1.42288860E-01  -4.23220000E-04  +1.30820000E-04  -6.27000000E-05  +8.00660000E-04
   -3.76930000E-04  +4.91540000E-04  +3.52250000E-04  -1.80040000E-04  +2.13230000E-04
   -2.60230000E-04  +1.15930000E-04  -7.03300000E-05  -1.39930000E-04  +6.65800000E-05
   +7.04000000E-05  +3.37310000E-04  -3.79300000E-05  +1.64800000E-05  +2.14268200E-02
   +1.49227700E-02  +1.25400000E-04  +1.08503000E-03  +8.79730000E-04  +1.30514000E-03
   +6.32600000E-05  -5.87700000E-05  -1.11200000E-05  -1.19355000E-03  +2.46899000E-03
   -4.18885000E-03  -9.04420000E-04  +2.33090000E-04  -4.69480000E-04  +2.09020000E-04
   +3.98800000E-05  +2.36080000E-04  -8.28200000E-05  -1.49870000E-04  +1.99500000E-05
   -1.57440000E-04  +2.42910000E-04  -2.64330000E-04  +1.39910000E-03  +9.47830000E-04
   +3.90530000E-04  +1.05460000E-04  +3.92100000E-05  +3.07800000E-05  -1.64568900E-02
   -1.25032800E-02  -4.81199900E-02  +1.60880000E-04  -4.18000000E-06  -1.04540000E-04
   +1.27000000E-06  +8.13000000E-06  -7.81000000E-06  +1.95400000E-05  +3.09800000E-05
   +9.48000000E-06  +1.44660000E-04  -5.10570000E-04  +2.24190000E-04  +5.83000000E-06
   -3.65400000E-05  +3.00000000E-06  +1.13930000E-04  +6.37400000E-05  -1.66500000E-05
   +1.73702500E-02  +8.79361000E-03  +5.25047700E-02  -5.01000000E-06  +7.15500000E-05
   -1.61130000E-04  +6.42100000E-05  -5.21890000E-04  -5.74170000E-04  -1.70650000E-04
   +1.16040000E-04  -8.52100000E-05  +1.24690000E-04  -3.46300000E-05  -1.12900000E-05
   -5.62700000E-05  +4.71300000E-05  -1.38610000E-04  -2.99080000E-04  +1.10610000E-04
   +1.25320000E-04  -1.96467000E-03  +7.46500000E-04  +1.10517000E-03  -2.40300000E-05
   -4.05130000E-04  +3.64660000E-04  +4.53900000E-05  -6.25600000E-05  +6.16800000E-05
   +2.84480000E-04  +4.60210000E-04  +4.21620000E-04  -2.82000000E-05  -4.56220000E-04
   +5.91260000E-04  -1.13570000E-04  +2.93700000E-05  -2.40320000E-04  -7.92900000E-05
   -3.36000000E-06  -4.27800000E-05  +1.11820000E-04  +9.28800000E-05  -1.25400000E-05
   -8.68400000E-05  -7.45400000E-05  +3.88200000E-05  +1.01230000E-04  +1.18370000E-04
   -2.77900000E-05  -4.76842700E-02  +5.03386000E-03  +7.74083000E-03  +4.27300000E-05
   +4.00000000E-07  +6.11100000E-05  -2.97500000E-05  -2.27600000E-05  +3.08000000E-06
   -3.35000000E-06  +3.00000000E-07  +2.57000000E-05  -1.31177000E-03  +1.17660000E-04
   +3.61170000E-04  -1.89600000E-05  +4.78300000E-05  -4.89000000E-05  +8.13000000E-06
   +6.21000000E-06  -1.02600000E-05  +1.72413000E-03  -1.32112200E-02  -2.37499300E-02
   +4.83383400E-02  +3.92060000E-04  -1.86430000E-04  +8.07360000E-04  -4.74850000E-04
   +7.70480000E-04  -1.80680000E-04  +2.41170000E-04  -7.74000000E-06  +3.10000000E-07
   -1.33830000E-04  +6.74200000E-05  +3.77100000E-05  +1.43790000E-04  +1.31300000E-05
   -8.30000000E-07  -2.28000000E-05  -2.31340000E-04  -1.80090000E-04  -4.29650000E-04
   +1.06842500E-02  +1.74020400E-02  -4.63800000E-05  -2.29716000E-03  +2.88444000E-03
   -8.32200000E-05  +5.94100000E-05  -3.66600000E-05  +9.51400000E-05  +9.39760000E-04
   -4.02640000E-04  -6.79590000E-04  +2.31540000E-04  -1.34270000E-04  -1.29100000E-05
   -1.66680000E-04  +1.35890000E-04  -1.31860000E-04  -6.47000000E-06  -1.70630000E-04
   +1.38120000E-04  +7.31500000E-05  +5.18700000E-05  +2.35290000E-04  -9.81100000E-05
   +1.00100000E-05  +8.13900000E-05  +3.06500000E-05  +3.15500000E-05  +5.38235000E-03
   -1.18671970E-01  -1.19391390E-01  -1.31790000E-04  -1.11800000E-05  +5.10900000E-05
   -4.64000000E-06  +7.03000000E-06  -9.31000000E-06  -1.38200000E-05  +2.93800000E-05
   +2.23300000E-05  -3.36530000E-04  -2.24240000E-04  +2.21680000E-04  -7.98000000E-06
   +2.22600000E-05  +2.90800000E-05  +1.02400000E-05  +1.77400000E-05  +9.26000000E-06
   +2.09232000E-03  -9.11468000E-03  -1.45560700E-02  -5.12945000E-03  +1.27870730E-01
   +1.13430000E-04  -1.17465000E-03  -5.06110000E-04  +1.43398000E-03  -5.81710000E-04
   +9.01540000E-04  -9.80190000E-04  +1.44590000E-04  -2.61180000E-04  +4.71160000E-04
   -2.16680000E-04  +6.91800000E-05  -5.45800000E-05  +1.68000000E-06  -2.66110000E-04
   -5.89020000E-04  +5.51000000E-04  +4.74180000E-04  +6.38870000E-04  -1.36094300E-02
   -2.06380600E-02  -1.71070000E-04  +4.84159000E-03  -3.81128000E-03  +6.57100000E-05
   -2.36100000E-05  +9.07600000E-05  -9.25750000E-04  -1.08686000E-03  +9.33420000E-04
   -3.41060000E-04  +2.22590000E-04  +4.04600000E-05  +2.86290000E-04  +1.90940000E-04
   +2.07450000E-04  +1.23870000E-04  -1.87190000E-04  +1.88780000E-04  -2.27660000E-04
   -1.63850000E-04  -3.52300000E-05  +2.77400000E-05  +5.05490000E-04  -1.63500000E-05
   -5.76000000E-06  -1.64100000E-05  +6.53000000E-06  +7.57943000E-03  -1.17472670E-01
   -2.44782800E-01  +1.28340000E-04  +5.49100000E-05  +8.93500000E-05  +1.39800000E-05
   +7.97000000E-06  -8.13000000E-06  +1.83400000E-05  +2.64900000E-05  -7.60000000E-06
   +4.75510000E-04  -2.26680000E-04  +1.15840000E-04  +3.69600000E-05  -9.91500000E-05
   +2.77900000E-05  +2.69800000E-05  -2.08200000E-05  -3.17600000E-05  +1.63440000E-04
   -2.29830000E-04  -8.97150000E-04  -8.55763000E-03  +1.27631410E-01  +2.67222250E-01
   +1.65080000E-04  -3.37650000E-04  -3.83700000E-04  +3.92130000E-04  +7.31620000E-04
   -5.31100000E-04  +4.17870000E-04  +2.18330000E-04  +1.84030000E-04  -1.59600000E-05
   -2.75500000E-05  -3.10000000E-07  +1.82830000E-04  -1.65160000E-04  -1.04200000E-05
   -1.00040000E-04  +2.59800000E-05  +2.61200000E-05  +9.84250000E-04  -1.54746000E-03
   +4.32780000E-04  +3.69230000E-04  -3.41410000E-04  +3.35210000E-04  -1.00120000E-04
   +1.43450000E-04  -3.85700000E-05  -3.54600000E-05  -4.28600000E-05  -3.02810000E-04
   -9.93140000E-04  -1.08148000E-03  -6.31080000E-04  +1.55080000E-04  -1.50690000E-04
   +2.42980000E-04  -1.89820000E-04  -3.83700000E-05  -1.05300000E-05  +5.29900000E-05
   +2.37900000E-05  +9.25000000E-06  +1.16860000E-04  +7.97300000E-05  +2.48400000E-05
   +9.32300000E-05  +3.92400000E-05  +3.33800000E-05  -2.15994710E-01  +1.28223080E-01
   -1.39883000E-03  -1.45470000E-04  +4.75100000E-05  +5.98200000E-05  -7.42000000E-06
   +7.21000000E-06  -6.03000000E-06  +3.35800000E-05  -2.37000000E-06  -2.36600000E-05
   -8.23220000E-04  -1.71398000E-03  -4.69000000E-06  -1.08300000E-05  -1.89000000E-06
   +1.12100000E-05  +1.08300000E-05  +2.06800000E-05  +6.81000000E-06  -1.96777400E-02
   +1.66603700E-02  +4.45420000E-04  -2.39360000E-04  -1.22828000E-03  -1.98320000E-04
   +2.35084360E-01  +5.50150000E-04  -3.23560000E-04  +8.59000000E-05  -3.04450000E-04
   -1.13206000E-03  +4.06743000E-03  -5.47720000E-04  -4.10840000E-04  -6.28710000E-04
   +7.15650000E-04  -1.60430000E-04  +8.14000000E-06  -3.31250000E-04  +2.61630000E-04
   +8.48600000E-05  -3.09250000E-04  +2.21140000E-04  +4.75700000E-05  +1.63119700E-02
   -1.25444300E-02  -2.58770000E-04  +4.33600000E-05  +5.94420000E-04  -1.51418000E-03
   +1.69290000E-04  -2.07660000E-04  +4.12100000E-05  +5.70290000E-04  +7.07320000E-04
   -4.43480000E-04  -2.32100000E-05  -6.18110000E-04  +7.47180000E-04  -3.51220000E-04
   +1.56440000E-04  -3.27190000E-04  -7.93900000E-05  +1.78900000E-05  -1.37280000E-04
   +1.67350000E-04  +1.80660000E-04  -2.39700000E-05  -2.71460000E-04  -1.44260000E-04
   +1.62010000E-04  +1.11910000E-04  +1.51050000E-04  -4.31000000E-05  +1.27112070E-01
   -1.44038680E-01  +7.74350000E-04  +3.03720000E-04  -3.48200000E-05  -1.32430000E-04
   -3.59600000E-05  -4.19800000E-05  -1.22000000E-06  +1.86000000E-06  -3.17700000E-05
   +1.45100000E-05  -1.28577000E-03  -1.13875000E-03  -8.32890000E-04  +2.58400000E-05
   +7.19200000E-05  -1.35580000E-04  +1.15000000E-05  -6.53000000E-06  -1.82000000E-05
   -1.50012400E-02  +1.22299100E-02  -2.02600000E-05  +1.23979200E-02  -9.59403000E-03
   +1.14787000E-03  -1.39242280E-01  +1.55216220E-01  -3.55200000E-05  -7.41340000E-04
   -2.85690000E-04  +1.31863000E-03  +2.19802000E-03  -3.46932000E-03  -8.11160000E-04
   +5.42660000E-04  +4.07830000E-04  -9.81200000E-05  -2.41410000E-04  +6.30000000E-05
   +2.85730000E-04  -2.02500000E-04  -2.14140000E-04  -4.75690000E-04  +1.82460000E-04
   +2.69120000E-04  -2.10919300E-02  +1.58771500E-02  -2.16548000E-03  -1.18868000E-03
   +6.72990000E-04  +1.22108000E-03  -1.14110000E-04  +1.53220000E-04  +2.40700000E-05
   -6.27400000E-05  -7.33480000E-04  +6.33900000E-04  +3.04320000E-04  -4.04360000E-04
   +4.09310000E-04  +1.03070000E-04  +1.72720000E-04  -1.22180000E-04  +1.40200000E-04
   -4.82700000E-05  +1.71850000E-04  -1.29550000E-04  -9.09500000E-05  -3.38000000E-05
   +2.35600000E-05  +6.04000000E-06  -2.38740000E-04  -4.46600000E-05  -1.02300000E-05
   -3.16800000E-05  -1.36170000E-03  -1.19570000E-04  -4.73771000E-02  -2.05950000E-04
   +6.65700000E-05  +1.69990000E-04  -4.70000000E-07  -8.10000000E-07  +1.00100000E-05
   -6.42000000E-06  +7.03000000E-06  +1.12400000E-05  -2.21350000E-04  -2.30020000E-04
   +1.30300000E-04  -4.36100000E-05  +4.12000000E-06  +4.57900000E-05  -2.10600000E-05
   +1.03900000E-05  +8.19000000E-06  -2.06321000E-03  +1.58318000E-03  -9.27060000E-04
   +2.27902500E-02  -1.57652400E-02  +1.39753000E-03  +2.15159000E-03  -3.07319000E-03
   +5.04412400E-02  -7.06200000E-05  +1.03550000E-04  +5.47000000E-05  +3.25040000E-04
   -5.21310000E-04  +2.98090000E-04  +4.59500000E-05  +3.67260000E-04  +6.82880000E-04
   -1.57000000E-04  -5.76300000E-05  -3.36210000E-04  -5.15100000E-05  +1.06930000E-04
   +1.56720000E-04  +7.66700000E-05  -1.03580000E-04  -5.18600000E-05  -1.71655000E-03
   -2.22793000E-03  +2.89331000E-03  -4.70995300E-02  +1.84949000E-03  -3.57801000E-03
   +4.71200000E-05  -1.12320000E-04  -3.65300000E-05  -5.51600000E-05  +5.53090000E-04
   -5.50960000E-04  -1.64130000E-04  -8.02400000E-05  -8.57000000E-05  +1.23990000E-04
   +7.89700000E-05  -4.25100000E-05  -1.72800000E-05  -1.15750000E-04  +6.77100000E-05
   -2.45490000E-04  -4.13400000E-05  +2.76100000E-05  -3.18900000E-05  -1.54360000E-04
   +1.10400000E-05  +4.76200000E-05  +4.59400000E-05  +8.32000000E-06  -5.61900000E-05
   +6.06170000E-04  +5.99660000E-04  +1.03370000E-04  -3.05300000E-05  -1.02130000E-04
   -8.32000000E-06  -1.18600000E-05  -9.79000000E-06  +2.30000000E-06  +8.15000000E-06
   +9.57000000E-06  +1.77300000E-05  +9.74000000E-06  +6.29700000E-05  +2.27760000E-04
   -1.49070000E-04  -8.24400000E-05  +1.89200000E-05  -1.59700000E-05  -1.50300000E-05
   +2.64580000E-04  +2.87690000E-04  -2.87810000E-04  +6.46600000E-04  -1.40100000E-04
   +2.68250000E-04  +1.99610000E-04  -3.09240000E-04  +2.02610000E-04  +4.77375200E-02
   -2.19710000E-04  -8.37600000E-05  -5.59100000E-05  +8.75300000E-05  +8.37910000E-04
   +6.33100000E-04  +4.15070000E-04  +4.47750000E-04  +1.57100000E-04  +8.68400000E-05
   -2.05250000E-04  -2.06540000E-04  +4.91000000E-05  -3.71600000E-05  +1.16090000E-04
   -6.91100000E-05  +6.71800000E-05  +1.98400000E-05  -8.91390000E-04  +1.05292100E-02
   -1.58130300E-02  +1.56500000E-03  -1.33952200E-01  +1.26607980E-01  -1.91300000E-05
   -1.56500000E-05  -3.67400000E-05  +3.77620000E-04  +1.00861000E-03  +3.06300000E-05
   -1.82600000E-04  -2.19200000E-05  +5.17000000E-05  +1.29210000E-04  +1.42480000E-04
   -1.13820000E-04  -8.88000000E-06  -9.80100000E-05  +1.55180000E-04  +7.10000000E-07
   -1.51920000E-04  +1.07010000E-04  -3.76970000E-04  -1.75830000E-04  -6.64130000E-04
   +1.40430000E-04  +9.64400000E-05  +2.01000000E-06  +2.63960000E-04  -1.81109000E-03
   -2.72521000E-03  -2.49600000E-05  +1.24000000E-06  -1.37800000E-05  -1.47700000E-05
   -5.23000000E-06  -3.28000000E-06  +1.62100000E-05  -1.57000000E-06  +5.00000000E-08
   +2.54800000E-05  -1.08500000E-05  -7.39000000E-06  -1.29000000E-06  -9.13550000E-04
   -2.32730000E-04  +1.09000000E-06  -3.98000000E-06  -2.17700000E-05  +2.50980000E-04
   +1.93600000E-05  -1.57580000E-04  +1.20040000E-04  +8.31620000E-04  -9.29610000E-04
   -2.37030000E-04  +1.65000000E-06  -1.67660000E-04  -2.76837000E-03  +1.43871270E-01
   +1.37770000E-04  -4.79970000E-04  -5.77300000E-05  -9.65080000E-04  +1.04304000E-03
   +9.68110000E-04  -5.33540000E-04  -2.52890000E-04  -1.32290000E-04  +4.09790000E-04
   -1.06400000E-04  +3.43210000E-04  +1.46200000E-05  +4.64400000E-05  -1.85940000E-04
   -1.77140000E-04  +1.47200000E-04  +7.22700000E-05  -6.90130000E-04  +1.54778800E-02
   -2.06937800E-02  -3.69956000E-03  +1.24417800E-01  -2.30261250E-01  -2.22200000E-05
   +3.68300000E-05  +6.28800000E-05  +1.32635000E-03  +9.46690000E-04  +7.45320000E-04
   -8.20210000E-04  -1.32410000E-04  -2.54600000E-04  +4.46470000E-04  +4.09200000E-04
   -7.60800000E-05  +2.28580000E-04  -3.27690000E-04  +4.00060000E-04  -5.37410000E-04
   -3.43220000E-04  +1.82460000E-04  -2.33210000E-04  +6.68480000E-04  -1.23550000E-04
   +3.96800000E-05  +1.79700000E-05  -3.11000000E-06  +3.80100000E-04  -4.62399000E-03
   -4.25986000E-03  -2.97500000E-05  +6.97000000E-06  +7.33700000E-05  -5.31000000E-06
   -1.21200000E-05  -7.39000000E-06  +1.06500000E-05  -1.43500000E-05  -2.06700000E-05
   +1.40570000E-04  -6.92000000E-06  +8.71600000E-05  +2.60340000E-04  -5.66600000E-04
   +1.57570000E-04  -4.23200000E-05  -6.85000000E-06  +2.20000000E-07  +4.62100000E-05
   -5.60300000E-05  +2.34510000E-04  +1.69380000E-04  +1.06984000E-03  -1.53170000E-03
   -5.19900000E-05  -1.66080000E-04  +3.87270000E-04  +3.47510000E-03  -1.35297490E-01
   +2.51434800E-01  +1.14330000E-04  -8.36800000E-05  +2.10800000E-05  -3.18800000E-05
   -2.53400000E-05  -3.39880000E-04  -6.49520000E-04  +8.17670000E-04  -5.13010000E-04
   +6.72100000E-05  +1.63280000E-04  +2.21470000E-04  -1.67210000E-04  -4.74900000E-05
   +9.74000000E-06  +2.62600000E-05  -1.24900000E-05  -4.03200000E-05  +2.28761000E-03
   +3.01932000E-03  +4.91160000E-04  -1.89408160E-01  -1.32503710E-01  -9.59753000E-03
   +4.94400000E-05  -1.85000000E-05  +1.33700000E-05  +4.23850000E-04  -5.05160000E-04
   -1.02610000E-04  +5.99670000E-04  -8.66700000E-05  +1.54940000E-04  +2.11700000E-05
   -7.33100000E-05  +6.12300000E-05  +2.67460000E-04  +1.74250000E-04  +6.56100000E-05
   -2.11090000E-04  -9.88000000E-06  -7.24400000E-05  +2.44200000E-04  +3.64060000E-04
   -4.06060000E-04  -2.73380000E-04  -2.09460000E-04  -1.65500000E-05  +3.14520000E-04
   +3.31920000E-04  +1.59890000E-04  +5.22000000E-05  +2.45400000E-05  +1.79000000E-05
   +3.85900000E-05  +1.37500000E-05  +1.96500000E-05  -1.91700000E-05  -3.99000000E-06
   -8.52000000E-06  -6.00200000E-05  +6.00100000E-05  +6.36000000E-06  -4.85000000E-06
   -2.72800000E-05  +1.35700000E-05  -2.02700000E-05  -3.49000000E-06  +1.39400000E-05
   +2.66110000E-04  +9.92100000E-05  -2.73940000E-04  +1.35570000E-04  +2.49810000E-04
   -4.94900000E-05  -1.96620000E-04  -1.40200000E-04  -6.48200000E-05  +6.81140000E-04
   +2.19012000E-03  +4.19100000E-05  +2.05681670E-01  +3.17200000E-04  -1.30960000E-04
   -1.22360000E-04  -8.10560000E-04  +4.50920000E-04  +2.38180000E-04  -2.97710000E-04
   -3.79900000E-04  -1.00540000E-03  +3.92330000E-04  +3.24960000E-04  +5.64530000E-04
   -6.33300000E-05  -2.41150000E-04  -1.85480000E-04  -1.00380000E-04  +1.38390000E-04
   +7.52100000E-05  -1.35438000E-02  -1.23602200E-02  +2.61850000E-04  -1.31179220E-01
   -1.70007870E-01  -8.99513000E-03  -2.98900000E-05  +1.72490000E-04  +4.24200000E-05
   +5.05730000E-04  -1.13225000E-03  -3.65941000E-03  +5.02460000E-04  -4.18880000E-04
   +2.98650000E-04  -6.23720000E-04  -4.13180000E-04  +3.32630000E-04  +1.23260000E-04
   +5.47280000E-04  -4.85320000E-04  +2.72680000E-04  +1.68690000E-04  +6.31000000E-06
   -3.20630000E-04  -1.37500000E-04  -2.82450000E-04  -4.52330000E-04  -3.92860000E-04
   +2.90200000E-05  -2.58500000E-05  +5.31500000E-04  +1.45189000E-03  -9.91900000E-05
   +8.89200000E-05  +1.58810000E-04  +6.28100000E-05  +2.88200000E-05  +3.43200000E-05
   -1.08530000E-04  -1.09100000E-05  +2.93100000E-05  +4.45200000E-05  -2.93200000E-05
   -1.40470000E-04  -7.56800000E-05  +1.93470000E-04  +1.08330000E-04  -1.24900000E-05
   -4.07300000E-05  +1.01200000E-05  +2.45360000E-04  +6.13550000E-04  -3.22350000E-04
   +3.02770000E-04  +4.15200000E-05  +1.06860000E-04  +1.13130000E-04  -1.43800000E-05
   -1.23360000E-04  -1.25907500E-02  -1.15380600E-02  -2.12002000E-03  +1.44347220E-01
   +1.83020120E-01  +4.76400000E-05  -5.82000000E-06  -2.36040000E-04  -2.20120000E-04
   +5.89450000E-04  +7.06250000E-04  +7.22800000E-05  +4.33040000E-04  +3.65540000E-04
   +2.12330000E-04  -1.57000000E-04  -1.07560000E-04  +1.91000000E-05  -4.73000000E-05
   +7.17300000E-05  -7.00800000E-05  +8.72700000E-05  +2.88800000E-05  -2.04346100E-02
   -1.76083300E-02  -2.45241000E-03  -9.32982000E-03  -7.93767000E-03  -4.88913400E-02
   -7.90000000E-06  +2.28200000E-05  -2.17000000E-05  +1.45090000E-03  -2.20450000E-03
   -4.02612000E-03  -4.59560000E-04  -6.24310000E-04  +1.07780000E-04  -2.05700000E-04
   +1.49420000E-04  +3.22030000E-04  +3.50420000E-04  +1.73870000E-04  +4.96700000E-05
   -5.54890000E-04  +3.05100000E-05  +6.66000000E-05  -9.50800000E-05  +3.44470000E-04
   -7.11700000E-05  -4.53750000E-04  -4.00960000E-04  -2.85600000E-05  -1.11962000E-03
   -8.60350000E-04  +1.27095000E-03  -6.91000000E-06  +2.13900000E-05  -1.29300000E-05
   +5.12100000E-05  -5.42000000E-06  +3.18600000E-05  -7.57800000E-05  -3.48100000E-05
   -1.21900000E-05  +4.16700000E-05  -1.11350000E-04  -1.67640000E-04  +2.66570000E-04
   -3.36070000E-04  -4.45600000E-05  -3.52600000E-05  -2.91400000E-05  +1.69300000E-05
   +5.37430000E-04  +1.92300000E-04  -6.92980000E-04  +1.96220000E-04  +1.58250000E-04
   +3.86790000E-04  -7.53200000E-05  +1.21410000E-04  -7.56700000E-05  +2.03322200E-02
   +1.70973700E-02  +2.54058000E-03  +1.09193900E-02  +1.18481600E-02  +5.17241200E-02
   -2.87700000E-05  -1.09630000E-04  -3.00770000E-04  +7.16430000E-04  +4.80000000E-07
   +2.54430000E-04  -1.53260000E-04  -8.96100000E-05  -4.42580000E-04  +1.91110000E-04
   +1.53430000E-04  +2.99720000E-04  +1.07060000E-04  -1.77870000E-04  -1.26420000E-04
   -2.97800000E-05  +9.80600000E-05  +1.25820000E-04  -3.23331000E-03  +7.23060000E-04
   -9.10140000E-04  -2.55879940E-01  +1.13999200E-01  -9.23822000E-03  -8.77200000E-05
   +1.51650000E-04  +1.01200000E-05  +8.09590000E-04  -1.34023000E-03  -1.01900000E-04
   +2.34700000E-04  +1.51040000E-04  -1.16610000E-04  +1.04050000E-04  +1.03270000E-04
   +6.27000000E-05  +3.85800000E-05  -6.18500000E-05  +1.49430000E-04  -2.16560000E-04
   -8.26000000E-06  +8.54000000E-06  +2.97090000E-04  +2.88030000E-04  -2.13370000E-04
   +2.04900000E-05  +2.19000000E-06  -2.17100000E-05  -8.30200000E-05  -1.65290000E-04
   -4.68030000E-04  -1.70210000E-04  +4.39200000E-05  +1.29050000E-04  -6.39000000E-06
   -3.18000000E-06  +1.74000000E-06  +2.44600000E-05  +1.73800000E-05  -1.41000000E-06
   +2.36300000E-05  +2.52100000E-05  +1.81700000E-05  +3.01300000E-05  -6.79700000E-05
   -1.36400000E-05  -4.63000000E-06  +9.36000000E-06  +3.24000000E-06  +1.85900000E-05
   +1.18700000E-04  -4.86700000E-05  +3.20570000E-04  -2.25170000E-04  +1.33900000E-05
   +3.02490000E-04  -3.00920000E-04  +5.60330000E-04  +4.55590000E-04  -1.10369000E-03
   +1.44610000E-04  -1.88834200E-02  +1.16482000E-02  -1.12174000E-03  +2.74916500E-01
   +1.17617000E-03  -1.13150000E-04  +3.30680000E-04  -8.73690000E-04  -1.37663000E-03
   -3.63441000E-03  -2.93340000E-04  +6.18900000E-05  -5.31650000E-04  +2.76100000E-05
   +1.90700000E-04  +1.09420000E-04  -2.53080000E-04  +8.96000000E-05  -1.93500000E-05
   +1.87200000E-05  -3.03400000E-04  -2.55590000E-04  +1.63858500E-02  -1.10673600E-02
   +3.14530000E-04  +1.12202670E-01  -1.07864240E-01  +6.14729000E-03  +9.76700000E-05
   -1.08360000E-04  +3.98000000E-05  +1.18888000E-03  +5.60890000E-04  +2.67810000E-04
   -3.18540000E-04  +1.28230000E-04  -3.49900000E-05  -1.57700000E-04  -3.79000000E-05
   -7.21400000E-05  -1.99530000E-04  -1.28880000E-04  -9.53100000E-05  +5.65000000E-05
   +3.33400000E-05  +4.98000000E-05  -7.07000000E-05  -3.44690000E-04  +5.38620000E-04
   +1.90400000E-04  +1.78900000E-04  +1.26800000E-05  -5.00630000E-04  +2.66470000E-04
   +1.16432000E-03  +1.45540000E-04  -5.65000000E-06  -3.12200000E-05  -2.77800000E-05
   -2.24000000E-05  -2.52700000E-05  +1.17100000E-05  -7.96000000E-06  +1.11000000E-06
   +3.79000000E-05  -1.32800000E-05  -5.85900000E-05  +1.44400000E-05  +1.17750000E-04
   -1.46720000E-04  +1.19300000E-05  -9.10000000E-06  -1.25200000E-05  -1.16140000E-04
   +5.37600000E-05  -1.66800000E-05  -2.34800000E-04  -3.96300000E-05  +5.05300000E-05
   -1.12270000E-04  +5.92860000E-04  -6.83100000E-05  +1.57573400E-02  -8.66115000E-03
   -1.65020000E-04  -1.98999700E-02  +1.18381900E-02  -1.01172000E-03  -1.24136880E-01
   +1.16150950E-01  +1.56681000E-03  -8.14290000E-04  +4.31230000E-04  -8.97070000E-04
   -2.46239000E-03  -4.57127000E-03  -9.10160000E-04  -3.63180000E-04  -6.63430000E-04
   +2.35670000E-04  +6.87500000E-05  +3.58780000E-04  -1.63530000E-04  +4.12000000E-05
   -1.72350000E-04  -9.06500000E-05  -2.45590000E-04  -2.95740000E-04  +2.40364900E-02
   -1.36104600E-02  -8.78860000E-04  -1.10742300E-02  +7.16084000E-03  -4.67977000E-02
   +3.92300000E-05  -2.03000000E-06  +6.73500000E-05  +9.14840000E-04  +4.52090000E-04
   +6.55340000E-04  +6.80000000E-05  +1.46760000E-04  +1.97850000E-04  -1.67170000E-04
   -1.21040000E-04  -3.87800000E-05  -1.86070000E-04  +1.98900000E-05  -2.11220000E-04
   +3.97940000E-04  +1.45200000E-05  +1.17240000E-04  -4.02580000E-04  -7.37700000E-05
   -9.11000000E-05  +1.85730000E-04  +1.33030000E-04  +1.52800000E-05  +1.15655000E-03
   -8.07140000E-04  +1.32725000E-03  +7.41900000E-05  +2.16200000E-05  +3.01100000E-05
   -2.41600000E-05  -5.30000000E-07  -1.61000000E-06  +7.47000000E-06  -8.60000000E-06
   +1.09900000E-05  -2.25500000E-05  +6.00000000E-06  -9.78200000E-05  -2.37800000E-05
   -1.66000000E-06  +6.29400000E-05  -1.58800000E-05  +1.16700000E-05  +2.84000000E-06
   -6.05500000E-05  +2.07300000E-05  -7.52400000E-05  -3.06930000E-04  +1.09290000E-04
   +2.70690000E-04  -2.96920000E-04  +3.89600000E-04  -6.97100000E-04  -2.42130200E-02
   +1.17313900E-02  -2.78780000E-04  -7.79910000E-04  +8.43350000E-04  -1.05488000E-03
   +1.07979400E-02  -3.12427000E-03  +5.20677600E-02  -2.56763000E-03  +7.20090000E-04
   -4.25097000E-03  +7.80920000E-03  -1.53238100E-02  -1.52217300E-02  -6.00082700E-02
   +2.60277600E-02  +1.71808500E-02  +6.61400000E-05  +1.98950400E-02  +2.19675100E-02
   -1.57540000E-03  +3.53721000E-03  -4.36195000E-03  -7.98050000E-04  +2.57780000E-04
   +2.46560000E-04  +2.69400000E-04  -9.62690000E-04  +7.52980000E-04  -3.21452000E-03
   +1.53239000E-03  -9.11410000E-04  -5.18190000E-04  +1.55628000E-03  +1.07220000E-03
   -1.04840000E-04  -2.49000000E-06  +1.91590000E-04  -5.74000000E-06  +2.94300000E-05
   +2.01800000E-05  +4.28800000E-05  +3.35400000E-05  -1.80600000E-05  -5.26000000E-05
   -6.31200000E-05  +1.45000000E-06  +1.00800000E-05  -5.69000000E-06  +5.44800000E-05
   -4.64900000E-05  +1.05230000E-04  -7.25900000E-05  +8.43900000E-05  +6.89700000E-05
   +9.01000000E-06  +2.11960000E-04  +7.10800000E-05  +9.56200000E-05  +2.86640000E-04
   -4.41830000E-04  +1.07700000E-05  -9.62000000E-06  -1.09900000E-05  -7.92000000E-06
   +1.55300000E-05  -6.20000000E-07  +9.80000000E-07  -4.53000000E-06  -1.30000000E-05
   -2.21000000E-06  +5.77200000E-05  -6.81100000E-05  -9.68000000E-06  +3.41000000E-06
   +3.40000000E-07  -7.28000000E-06  +2.06400000E-05  -2.91100000E-05  -1.95900000E-05
   +1.52000000E-05  -3.29800000E-05  +1.33450000E-04  -4.07200000E-05  -2.59100000E-05
   +5.20000000E-06  -1.30982000E-03  +1.87020000E-04  +4.64370000E-04  -1.35103000E-03
   +1.46045000E-03  -1.76330000E-04  +9.85900000E-05  -1.84590000E-04  +3.80800000E-05
   +6.27954500E-02  +6.39140000E-04  +2.99987000E-03  -1.65723000E-03  +9.71700000E-05
   +4.54900000E-04  -2.90251000E-03  +2.61840700E-02  -1.74967270E-01  -1.46601560E-01
   +1.34499000E-03  -8.49453000E-03  -1.41367500E-02  +4.00827000E-03  +5.14098000E-03
   -1.47277000E-03  -2.26400000E-05  -1.79790000E-04  +6.75480000E-04  -3.09560000E-04
   -1.84453000E-03  +7.28280000E-04  +2.84265000E-03  -6.42110000E-04  +2.61380000E-04
   -4.39840000E-04  +4.69910000E-04  +5.09570000E-04  -1.92830000E-04  +2.85160000E-04
   -1.79160000E-04  -6.37400000E-05  -8.60900000E-05  +6.98500000E-05  -6.14000000E-06
   -2.97100000E-05  +7.74000000E-06  +5.96000000E-06  +4.12900000E-05  -3.29100000E-05
   +2.09300000E-05  -2.19700000E-05  +6.24200000E-05  -1.30590000E-04  +7.89400000E-05
   -1.30260000E-04  -2.45000000E-05  -3.14400000E-05  +1.60000000E-05  +2.98060000E-04
   -1.03750000E-04  +7.89800000E-05  +1.51572000E-03  -6.75760000E-04  -2.06483000E-03
   +6.82000000E-06  -2.90000000E-07  -1.12000000E-06  -6.65000000E-06  -1.07700000E-05
   -1.65000000E-06  +1.55400000E-05  -3.41000000E-06  +8.39000000E-06  -9.82000000E-06
   -8.42700000E-05  -3.00500000E-05  -9.33000000E-06  -1.40600000E-05  -6.68000000E-06
   -2.16100000E-05  -2.00000000E-05  -4.00000000E-07  -8.10000000E-06  -2.07200000E-05
   +2.80900000E-05  -5.06400000E-05  -1.32500000E-05  +6.70600000E-05  -2.62180000E-04
   -2.22950000E-04  +2.77570000E-04  +1.80565000E-03  -9.37100000E-04  +1.56600000E-04
   +1.73130000E-04  -7.56300000E-05  +5.29840000E-04  -3.56338800E-02  +1.81555470E-01
   -4.41979000E-03  -1.43702000E-03  -2.59870000E-04  +4.14519000E-03  -1.40566300E-02
   -1.12228300E-02  +1.63056300E-02  -1.46673690E-01  -2.06582130E-01  -4.45070000E-04
   -4.66040000E-04  +2.82541000E-03  -2.64276000E-03  -2.87793000E-03  +3.90462000E-03
   -1.20310000E-04  +8.14790000E-04  +1.18840000E-04  +1.75654000E-03  +1.35820000E-04
   -1.14432000E-03  +6.08550000E-04  -8.85580000E-04  +3.85980000E-04  +6.56830000E-04
   -1.04097000E-03  -6.37010000E-04  +1.02960000E-04  -3.94200000E-05  +1.65350000E-04
   +3.32400000E-05  +6.55200000E-05  +2.50000000E-06  +2.10000000E-06  +1.34000000E-05
   -2.24000000E-06  -1.07700000E-05  -2.49500000E-05  -6.51000000E-06  +9.99000000E-06
   +2.27700000E-05  +1.00400000E-05  -1.80000000E-06  +8.09000000E-06  +5.54900000E-05
   +2.94700000E-05  +3.50900000E-05  +1.62000000E-06  -4.68920000E-04  +6.87800000E-05
   +2.99500000E-05  -7.05380000E-04  +6.80980000E-04  +1.17372000E-03  +0.00000000E+00
   -5.92000000E-06  -5.93000000E-06  +9.34000000E-06  -7.30000000E-07  -2.96000000E-06
   -5.25000000E-06  -9.25000000E-06  -1.43800000E-05  +3.06000000E-06  -3.27500000E-05
   -3.15200000E-05  +7.72000000E-06  +2.91000000E-06  -4.29000000E-06  +1.61300000E-05
   +6.21900000E-05  -9.56900000E-05  +6.25900000E-05  +9.17000000E-06  +9.49200000E-05
   -2.10900000E-05  +1.14510000E-04  -1.13970000E-04  +2.62080000E-04  -2.06020000E-04
   +2.11530000E-04  +4.97700000E-05  +9.06720000E-04  +1.51790000E-04  +5.13150000E-04
   +3.17780000E-04  +3.22990000E-04  -1.77001600E-02  +1.62781710E-01  +2.12688140E-01
   -1.62300000E-05  -7.63500000E-05  +5.17480000E-04  -1.30239000E-03  +5.46034000E-03
   -3.02690000E-04  -1.24013900E-02  -4.11792000E-03  -1.91008400E-02  -2.00668700E-01
   -1.79354500E-02  -1.47928620E-01  +4.62410000E-03  +2.98864000E-03  +5.59416000E-03
   +2.86470000E-04  +1.13403000E-03  +7.47460000E-04  -2.97390000E-04  -7.49450000E-04
   -7.26880000E-04  -1.24000000E-05  -8.26100000E-05  -4.05800000E-05  +1.21030000E-04
   -6.05650000E-04  +2.91720000E-04  -6.89800000E-05  +2.81320000E-04  -6.21700000E-05
   -5.44100000E-05  -7.94800000E-05  +5.09300000E-05  -1.47300000E-05  -3.01600000E-05
   -6.26000000E-06  +5.49100000E-05  +5.21200000E-05  -7.93000000E-06  -2.34800000E-05
   -1.58500000E-05  -8.44000000E-06  -2.83600000E-05  +1.36900000E-05  -4.86400000E-05
   -7.39900000E-05  -6.13800000E-05  +4.75000000E-06  -9.60100000E-05  +2.43900000E-05
   +5.62300000E-05  +1.33720000E-03  -1.67900000E-04  -1.42581000E-03  +1.13800000E-05
   +5.68000000E-06  +2.55000000E-06  -1.27800000E-05  -9.94000000E-06  -4.24000000E-06
   +8.34000000E-06  +1.07900000E-05  +8.15000000E-06  +1.50400000E-05  +1.88800000E-05
   -4.95000000E-06  -1.10300000E-05  -9.86000000E-06  +1.60000000E-06  +2.60700000E-05
   +4.78000000E-06  -3.84000000E-06  -8.70000000E-07  -7.60000000E-06  +2.90000000E-07
   -2.12800000E-05  +7.01900000E-05  -3.44000000E-05  -1.17500000E-05  +1.94600000E-05
   +1.13000000E-05  +3.30100000E-05  +1.20800000E-05  -3.11000000E-06  -1.04200000E-05
   +3.96800000E-05  +1.64900000E-05  -4.74170000E-04  -1.87330000E-03  +1.77336000E-03
   +2.08796790E-01  +1.85500000E-05  -8.66060000E-04  +4.21200000E-05  +5.16303000E-03
   +2.06734000E-03  -3.20681000E-03  +1.32554900E-02  +7.58925000E-03  +1.11485200E-02
   -1.75737600E-02  -4.90043800E-02  -3.55389900E-02  -1.68743800E-02  -1.09270000E-04
   -1.43681500E-02  +2.00180000E-03  -2.21279000E-03  -2.74312000E-03  +2.33480000E-04
   +1.68830000E-04  +5.99250000E-04  -8.95400000E-05  +4.56500000E-05  +7.45100000E-05
   -2.76900000E-04  +2.12760000E-03  +9.73760000E-04  +1.32650000E-04  -1.51290000E-04
   +1.90000000E-05  +1.79200000E-05  +2.72000000E-05  +1.71900000E-05  +9.29000000E-06
   +2.51300000E-05  +1.35200000E-05  -9.55000000E-06  -1.48300000E-05  +4.51000000E-06
   +1.17000000E-06  +2.61000000E-06  +8.96000000E-06  -1.77800000E-05  +3.34100000E-05
   -5.27100000E-05  +2.40700000E-05  +1.67800000E-05  +2.54000000E-06  +1.98160000E-04
   -8.60000000E-07  -8.79600000E-05  +9.46870000E-04  +1.98540000E-04  +6.58200000E-04
   -2.35000000E-06  -1.90000000E-06  -2.55000000E-06  +7.49000000E-06  +2.26000000E-06
   +2.29000000E-06  +2.37000000E-06  -1.04300000E-05  -2.83000000E-06  +1.46300000E-05
   +5.14000000E-06  -1.91000000E-06  -3.53000000E-06  -5.20000000E-07  -2.49000000E-06
   -7.41000000E-06  -3.18000000E-06  -9.30000000E-07  -3.39000000E-06  -3.42000000E-06
   +2.60600000E-05  -1.71000000E-06  -2.32100000E-05  +6.87300000E-05  -9.83000000E-06
   +4.07600000E-05  -3.25300000E-05  +2.68900000E-05  -2.40500000E-05  -6.20000000E-06
   +1.06600000E-05  +2.44000000E-06  -3.23100000E-05  -2.17614000E-03  -2.38793000E-03
   +2.74265000E-03  +1.58532000E-02  +4.20945800E-02  +6.45170000E-04  +9.92500000E-05
   -3.07220000E-04  -4.12180000E-04  -3.08933000E-03  +3.57663000E-03  +2.80807000E-03
   -2.15703000E-03  +6.13685000E-03  -1.48021370E-01  -3.43740800E-02  -1.85582700E-01
   -1.88930000E-02  -1.67700000E-03  -1.25582400E-02  +1.98207000E-03  -3.40956000E-03
   -1.74142000E-03  +2.52310000E-04  +1.66190000E-04  +9.12300000E-05  +2.80000000E-06
   +3.86300000E-05  -4.28000000E-05  +7.26020000E-04  +6.23870000E-04  +1.09988000E-03
   -3.50900000E-05  -4.18800000E-05  +1.45400000E-05  +1.65900000E-05  +1.40700000E-05
   -4.51000000E-06  -1.28000000E-06  -1.95000000E-06  +8.82000000E-06  +1.62600000E-05
   +9.25000000E-06  -2.03000000E-06  +1.00000000E-06  +1.19600000E-05  -3.74000000E-06
   +4.02000000E-06  -5.21000000E-06  +2.65500000E-05  -1.69400000E-05  -9.27000000E-06
   -6.90000000E-07  -8.40800000E-05  -3.18800000E-05  -4.20000000E-07  +4.00620000E-04
   +1.50227000E-03  +2.13265000E-03  +4.62000000E-06  +9.30000000E-07  -1.40000000E-07
   -1.60000000E-07  +3.40000000E-07  -1.80000000E-06  +2.04000000E-06  -3.61000000E-06
   -3.60000000E-06  -1.13200000E-05  -4.83000000E-06  -8.10000000E-06  +3.72000000E-06
   +3.80000000E-07  -1.08000000E-06  -6.58000000E-06  +1.56000000E-06  +7.98000000E-06
   +1.28500000E-05  -8.90000000E-07  -3.30000000E-06  +9.89000000E-06  -1.95000000E-05
   -1.80700000E-05  +2.00400000E-05  -2.26700000E-05  +7.39000000E-06  -3.40000000E-05
   -8.29000000E-06  +1.07400000E-05  -1.35100000E-05  -1.33600000E-05  +1.13900000E-05
   +1.38239000E-03  +2.93676000E-03  -1.24100000E-03  +1.60293710E-01  +3.97726600E-02
   +1.89197180E-01  +1.95915000E-03  +1.95188500E-02  +1.95556600E-02  -2.82593000E-03
   +4.64219000E-03  -2.47184000E-03  -7.31290000E-04  -1.72200000E-04  -9.01300000E-05
   -3.61736000E-03  +6.07100000E-04  -2.60342000E-03  +4.92667000E-03  -1.74124700E-02
   -1.73450700E-02  -5.68162500E-02  +2.63171000E-02  +1.33805800E-02  +4.79870000E-04
   +6.55300000E-04  +1.11856000E-03  -4.16640000E-04  +1.20290000E-04  -1.28820000E-04
   +8.32990000E-04  -1.62730000E-04  +1.51771000E-03  +8.21300000E-05  +4.73600000E-05
   +7.08000000E-06  +2.19100000E-05  -1.31800000E-05  +3.57100000E-05  -2.20100000E-05
   -5.89400000E-05  +3.28000000E-06  +3.79800000E-05  +5.75100000E-05  -1.45700000E-05
   -9.38000000E-06  -2.75700000E-05  -2.45100000E-05  -1.48200000E-05  +1.60300000E-05
   -2.41100000E-05  -7.16200000E-05  -7.50400000E-05  -9.05000000E-06  +5.48500000E-05
   -1.29730000E-04  +1.08270000E-04  +2.19895000E-03  +1.44767000E-03  +1.02360000E-03
   +2.00000000E-08  +1.00600000E-05  +1.14900000E-05  -1.67800000E-05  +3.10000000E-07
   +1.08000000E-06  +6.35000000E-06  +9.78000000E-06  +6.57000000E-06  +7.76000000E-06
   +2.34300000E-05  -4.97000000E-06  -1.50100000E-05  -2.85000000E-06  +1.43600000E-05
   +1.53000000E-06  -6.02000000E-06  -1.81000000E-05  +2.18400000E-05  -4.80000000E-07
   -3.80900000E-05  -2.65900000E-05  +1.72500000E-05  -2.54100000E-05  +5.27000000E-06
   -1.67200000E-05  +2.38100000E-05  +1.61400000E-05  +5.50000000E-06  -1.51100000E-05
   -3.15500000E-05  +8.89300000E-05  +1.35690000E-04  +2.80400000E-05  -1.30210000E-04
   +1.99720000E-04  +3.97940000E-04  -8.69540000E-04  -1.02926000E-03  +5.40973300E-02
   +3.29750000E-04  -6.04704000E-03  -1.43323100E-02  +4.99793000E-03  +3.76422000E-03
   -2.17522000E-03  -2.26450000E-04  -1.80160000E-04  +6.07380000E-04  -4.13700000E-04
   +1.36990000E-03  -2.86260000E-04  +3.88360000E-03  -1.98015000E-03  -1.32782000E-03
   +2.73826800E-02  -1.77602690E-01  -1.48705470E-01  -2.30950000E-04  -1.41990000E-04
   -6.49620000E-04  +2.35330000E-04  -1.74880000E-04  +1.07760000E-04  -1.44086000E-03
   +2.01760000E-03  -4.21850000E-04  -2.68630000E-04  -1.45590000E-04  +3.60000000E-06
   +4.56000000E-05  +4.87000000E-05  +3.41500000E-05  +6.08000000E-06  -4.20000000E-06
   +1.50500000E-05  -5.58800000E-05  -2.10600000E-05  -2.03100000E-05  +3.41700000E-05
   +1.31000000E-06  +6.50000000E-06  -4.11400000E-05  +5.35600000E-05  +1.52000000E-06
   +5.56200000E-05  +4.00600000E-05  +7.35000000E-06  +1.05550000E-04  -7.36200000E-05
   +8.16000000E-06  +2.42940000E-04  +3.19280000E-04  +1.41906000E-03  -8.07000000E-06
   -5.84000000E-06  -5.19000000E-06  +1.34100000E-05  +2.15000000E-06  +2.22000000E-06
   -2.22000000E-06  -1.25400000E-05  -4.68000000E-06  -1.13000000E-06  -1.35000000E-05
   +1.91100000E-05  +1.70000000E-07  +2.71000000E-06  +1.60000000E-07  -7.71000000E-06
   -8.95000000E-06  -1.74100000E-05  +1.47000000E-05  -3.27000000E-06  -8.49000000E-06
   +6.39000000E-06  -4.91600000E-05  +2.89900000E-05  -1.28900000E-05  +1.38200000E-05
   +1.80100000E-05  -1.62300000E-05  -1.40000000E-06  -1.09600000E-05  +1.20500000E-05
   -9.35600000E-05  -6.08500000E-05  -1.64270000E-04  -3.05240000E-04  +1.42180000E-04
   +1.17490000E-04  +1.91100000E-05  -2.07140000E-04  -3.27544500E-02  +1.81948860E-01
   -2.47670000E-03  -1.22058000E-03  +3.60104000E-03  -1.90739000E-03  -2.75848000E-03
   +4.42053000E-03  -6.41000000E-05  +5.79730000E-04  -1.93240000E-04  -3.98567000E-03
   +2.60580000E-04  -9.51930000E-04  +6.20828000E-03  -1.51102700E-02  -1.17416900E-02
   +1.49694500E-02  -1.49858400E-01  -1.94626590E-01  -2.52910000E-04  -8.54800000E-05
   -1.47670000E-04  +9.17400000E-05  +4.19000000E-05  +2.67900000E-05  +1.38471000E-03
   +1.13906000E-03  +2.04804000E-03  +1.40000000E-04  +7.61000000E-06  +2.60000000E-06
   -4.12500000E-05  -1.56300000E-05  -7.11700000E-05  +1.59400000E-05  +5.34400000E-05
   -2.59100000E-05  -2.95800000E-05  -5.92300000E-05  +3.42600000E-05  -1.90000000E-07
   +1.58700000E-05  +2.80900000E-05  +2.75100000E-05  -4.24000000E-05  +1.10100000E-05
   +6.37200000E-05  +6.59500000E-05  +1.60000000E-07  -5.11800000E-05  +8.90200000E-05
   -7.36400000E-05  -6.70630000E-04  +6.76130000E-04  +1.42578000E-03  -4.65000000E-06
   -7.71000000E-06  -5.19000000E-06  +5.99000000E-06  +2.99000000E-06  +1.52000000E-06
   -8.41000000E-06  +2.74000000E-06  -2.90000000E-06  -9.94000000E-06  -2.19900000E-05
   -5.77000000E-06  +1.48400000E-05  +1.02000000E-06  -1.62600000E-05  -1.88000000E-06
   +1.11900000E-05  +2.76000000E-06  -1.15400000E-05  +2.26700000E-05  +1.65900000E-05
   +1.70100000E-05  -4.27000000E-06  +6.43000000E-06  -1.46000000E-05  -8.17000000E-06
   -1.54300000E-05  +1.94000000E-06  +2.42700000E-05  +5.54000000E-06  +2.21300000E-05
   +8.07000000E-06  -2.49100000E-05  +2.03330000E-04  +1.85670000E-04  -1.86740000E-04
   +1.75010000E-04  -9.15460000E-04  -6.59240000E-04  -1.47550700E-02  +1.63613380E-01
   +1.99623250E-01  -2.06106740E-01  -2.69563300E-02  -1.39842480E-01  +5.68360000E-03
   +4.37760000E-04  +2.58302000E-03  +1.23430000E-03  +1.67237000E-03  +3.23840000E-04
   -1.68550000E-04  +1.14560000E-04  +4.69250000E-04  +1.49804000E-03  +5.30888000E-03
   +8.48290000E-04  -1.74921800E-02  -4.78103000E-03  -1.95058600E-02  -4.95980000E-04
   -7.58700000E-05  +5.02570000E-04  +1.50400000E-05  -1.66090000E-04  +5.67700000E-05
   -1.58211000E-03  +1.03844000E-03  -1.68302000E-03  -7.96160000E-04  +6.28610000E-04
   +7.51160000E-04  -1.18370000E-04  +1.40910000E-04  +1.28750000E-04  -1.16370000E-04
   -1.54200000E-04  -1.61500000E-05  -2.45850000E-04  -6.13900000E-05  -1.67160000E-04
   +2.77760000E-04  +9.04600000E-05  +5.12400000E-05  -3.42660000E-04  +1.12110000E-04
   +3.26060000E-04  +1.50680000E-04  +1.12740000E-04  +2.02900000E-05  -1.04890000E-04
   +2.07870000E-04  -1.69960000E-04  +4.27500000E-05  -4.18710000E-04  +2.27030000E-04
   -2.18900000E-05  -1.30300000E-05  -1.10800000E-05  +1.28100000E-05  +2.30000000E-07
   +1.07000000E-05  +5.40100000E-05  +1.35100000E-05  -6.59000000E-06  +2.11200000E-05
   -2.20700000E-05  -6.10100000E-05  +2.49000000E-06  +3.42000000E-06  -6.64000000E-06
   +1.31900000E-05  -2.41200000E-05  -1.18900000E-05  +1.97510000E-04  +1.81060000E-04
   +2.02660000E-04  -1.85900000E-05  +4.65500000E-05  +2.19240000E-04  -1.24500000E-05
   -3.21000000E-06  +3.51400000E-05  -8.67000000E-06  -3.02800000E-05  -4.62400000E-05
   +6.45400000E-05  -1.69700000E-05  -7.91000000E-06  +3.02840000E-04  +1.88380000E-04
   +1.71150000E-04  -9.36300000E-05  -1.55050000E-04  +2.18900000E-05  -1.50260000E-04
   -1.67526000E-03  +1.94205000E-03  +2.18198200E-01  -2.71586800E-02  -5.77762900E-02
   -3.80652200E-02  -1.68024800E-02  +1.04413000E-03  -1.29558100E-02  +2.07525000E-03
   -9.99890000E-04  -4.32564000E-03  +4.52310000E-04  -6.80010000E-04  +3.40230000E-04
   +3.90271000E-03  +2.86550000E-03  -5.25174000E-03  +1.46963300E-02  +6.60046000E-03
   +1.28719600E-02  -1.05153000E-03  -4.07800000E-04  +6.01280000E-04  -8.61300000E-05
   -2.55100000E-05  +9.43300000E-05  -1.21999000E-03  +2.95020000E-04  -5.77030000E-04
   +3.95860000E-04  +3.18000000E-05  -3.75900000E-05  +5.21300000E-05  +8.60000000E-07
   -7.88000000E-06  +1.08070000E-04  +6.03300000E-05  +2.05000000E-05  +1.84050000E-04
   -3.57000000E-06  +1.45810000E-04  -2.34310000E-04  -2.31880000E-04  -1.09580000E-04
   +1.49420000E-04  +3.16850000E-04  -2.27690000E-04  -1.72150000E-04  -1.57320000E-04
   -1.38900000E-05  +8.56200000E-05  -5.28370000E-04  -4.78200000E-04  +2.69292000E-03
   +7.78490000E-04  +5.89180000E-04  +6.24000000E-06  +2.16400000E-05  +2.01500000E-05
   -2.48700000E-05  +9.13000000E-06  +0.00000000E+00  +8.88200000E-05  -7.69000000E-05
   +1.72900000E-05  +1.18400000E-05  +1.76400000E-05  +7.62400000E-05  -2.61200000E-05
   -9.37000000E-06  +2.04300000E-05  +4.45500000E-05  +1.23470000E-04  +1.97600000E-05
   +3.11320000E-04  -1.04138000E-03  +5.18330000E-04  +7.04000000E-06  +1.80200000E-04
   +3.31520000E-04  -4.73100000E-05  +1.01200000E-05  +1.09100000E-04  -5.76000000E-06
   +6.86200000E-05  -8.93000000E-06  +5.27000000E-05  +1.85400000E-05  +3.60800000E-05
   -7.87600000E-04  +1.12450000E-04  -9.06580000E-04  -1.73250000E-04  -1.08870000E-04
   +2.03000000E-04  -2.06768000E-03  -2.62104000E-03  +2.91660000E-03  +2.44524600E-02
   +5.23143100E-02  -1.38834420E-01  -3.69443500E-02  -1.72786320E-01  -1.73467100E-02
   -2.00352000E-03  -1.10183900E-02  +5.72910000E-04  -4.68253000E-03  -1.03023000E-03
   +8.28150000E-04  +2.04850000E-04  +1.34020000E-04  -1.13643000E-03  -4.69547000E-03
   +3.86010000E-03  +2.80035000E-03  -3.80470000E-04  +5.18721000E-03  -5.92880000E-04
   +1.17820000E-03  -5.68980000E-04  +1.80660000E-04  +6.42000000E-05  -3.20000000E-07
   +1.46793000E-03  -4.81860000E-04  +1.23028000E-03  +2.33100000E-04  -3.35190000E-04
   +9.73000000E-05  +3.81170000E-04  +2.12950000E-04  +3.22800000E-04  +1.94300000E-05
   -1.15360000E-04  +1.00050000E-04  +3.19670000E-04  +1.75600000E-04  -3.58500000E-05
   -3.93700000E-05  +1.10930000E-04  -3.78800000E-05  -6.19100000E-05  +4.00140000E-04
   -2.10950000E-04  -3.30790000E-04  -2.41500000E-04  -3.46000000E-06  +8.60400000E-05
   -8.33000000E-06  -1.02850000E-04  -1.89207000E-03  -2.01420000E-04  -2.69090000E-04
   +4.98800000E-05  +1.67300000E-05  +2.25900000E-05  -2.75600000E-05  +5.00000000E-07
   -1.25300000E-05  -4.01000000E-06  +1.46000000E-05  -3.02000000E-05  -4.03200000E-05
   -8.01900000E-05  +3.23000000E-06  +1.60000000E-06  -2.03400000E-05  -8.37000000E-06
   -2.16000000E-06  +1.56280000E-04  +5.41500000E-05  -1.11840000E-04  +1.79930000E-04
   +2.96040000E-04  +2.85800000E-05  -8.46700000E-05  +5.13000000E-05  -6.09500000E-05
   -2.83700000E-05  +3.01800000E-05  +9.38000000E-06  +1.34390000E-04  +3.94600000E-05
   +7.39800000E-05  -5.93400000E-05  +5.37000000E-06  -9.95690000E-04  -1.81900000E-04
   -6.00800000E-04  +2.80500000E-05  +2.29070000E-04  -1.08150000E-04  +1.70629000E-03
   +3.18294000E-03  -1.71545000E-03  +1.52787050E-01  +4.40515000E-02  +1.77147810E-01
   +6.72800000E-05  -1.19230000E-04  +2.97900000E-04  -9.57300000E-05  -2.15500000E-05
   -1.81100000E-05  +6.35260000E-04  -1.55360000E-04  -1.12670000E-04  +1.63770000E-04
   +4.37010000E-04  -6.44170000E-04  -3.49790000E-03  +6.57516000E-03  +8.35053000E-03
   -2.76850000E-04  -1.17220000E-04  +1.07773000E-03  -5.32600000E-05  +1.48300000E-05
   -1.28720000E-04  +5.04000000E-05  -1.77100000E-05  +1.08700000E-05  -8.26231800E-02
   +1.29831390E-01  +1.30853460E-01  +2.60800000E-05  -5.20000000E-06  -6.52000000E-06
   -1.93000000E-05  -1.03300000E-05  -2.73000000E-05  +1.23800000E-05  +1.09300000E-05
   -1.90200000E-05  -9.80600000E-05  -5.64200000E-05  -2.62000000E-06  +2.23600000E-05
   -3.55800000E-05  +9.90000000E-07  +8.67000000E-06  -2.58800000E-05  -1.49400000E-05
   +9.62300000E-05  +5.20000000E-05  -3.19000000E-06  -1.16500000E-05  +3.40100000E-05
   +3.79800000E-05  -2.52020000E-04  -9.15400000E-04  -4.35600000E-04  -2.70700000E-05
   -4.21000000E-06  +1.44000000E-06  +5.74000000E-06  +4.39000000E-06  +8.96000000E-06
   -6.08000000E-06  +4.80000000E-06  +9.12000000E-06  -7.27000000E-06  +1.94300000E-05
   +2.68600000E-05  -1.87200000E-05  +7.58000000E-06  +1.58400000E-05  -1.18800000E-05
   -7.14000000E-06  -6.46000000E-06  -1.07200000E-05  +1.48100000E-05  -2.96900000E-05
   +1.13800000E-05  -9.13000000E-06  -1.83200000E-05  -3.02000000E-06  +4.60000000E-06
   +5.97000000E-06  -1.46800000E-05  -4.38000000E-06  -1.05000000E-06  +1.14200000E-05
   -1.53300000E-05  -8.18000000E-06  +7.42000000E-06  -5.44000000E-06  -7.11800000E-05
   -9.17000000E-06  +8.28300000E-05  +1.02370000E-04  -3.08380000E-04  +7.48700000E-05
   -1.09954000E-03  +1.44120000E-04  +1.01090000E-04  -1.40120000E-04  +8.63760300E-02
   -4.74900000E-04  -3.85500000E-05  -2.93030000E-04  +3.12470000E-04  -1.10530000E-04
   +2.32310000E-04  -1.18933000E-03  -7.48500000E-04  -1.22809000E-03  +3.52179000E-03
   -6.02337000E-03  +3.95129000E-03  +1.82120000E-02  -3.33659600E-02  -2.93881000E-02
   -8.79900000E-05  +1.33698000E-03  +1.01183000E-03  +6.80400000E-05  +6.17000000E-06
   +1.98700000E-05  -3.62900000E-05  +7.84000000E-06  -1.31100000E-05  +1.15271750E-01
   -2.00986220E-01  -1.73906250E-01  -1.44000000E-06  +3.70100000E-05  +2.21500000E-05
   +1.63800000E-05  +1.93000000E-06  +3.46800000E-05  -1.71800000E-05  -4.35900000E-05
   +2.31500000E-05  +9.74500000E-05  +8.92800000E-05  -1.44500000E-05  -2.18900000E-05
   +9.47000000E-06  -3.55900000E-05  -3.06000000E-06  +2.15000000E-05  +1.25300000E-05
   -1.14980000E-04  -1.04780000E-04  -4.66000000E-06  -2.07500000E-05  +1.93000000E-06
   -3.58000000E-06  -8.44470000E-04  +4.74327000E-03  -1.92944000E-03  +1.46400000E-05
   +1.58300000E-05  +6.48000000E-06  -1.05400000E-05  -2.14000000E-06  -4.69000000E-06
   +1.34600000E-05  -8.20000000E-07  +3.74000000E-06  +2.18000000E-05  +8.57000000E-06
   -2.76300000E-05  -9.33000000E-06  -1.17000000E-06  +1.27500000E-05  +1.06000000E-06
   -2.52100000E-05  -2.33000000E-06  +2.38000000E-05  -7.03000000E-06  +2.55100000E-05
   -2.11300000E-05  +1.93800000E-05  +5.93000000E-06  +2.74000000E-06  -1.14300000E-05
   +9.89000000E-06  +2.72000000E-06  -6.60000000E-06  -1.16400000E-05  -9.95000000E-06
   +1.93400000E-05  +1.52300000E-05  +4.52360000E-04  +1.74040000E-04  -2.36440000E-04
   -5.91100000E-05  +3.25330000E-04  -9.41100000E-05  +6.48140000E-04  +2.65760000E-04
   +2.86620000E-04  -1.44310000E-04  +3.87100000E-05  +4.52100000E-05  -1.35958400E-01
   +2.33202080E-01  -3.70800000E-04  -2.93160000E-04  -2.95480000E-04  +3.52440000E-04
   +8.78000000E-06  +7.48400000E-05  -5.43170000E-04  +7.36100000E-05  +3.39380000E-04
   +2.15510000E-04  +1.07677000E-03  -4.57960000E-04  -9.69163000E-03  +1.65800600E-02
   +1.18460700E-02  +4.07300000E-04  +2.02016000E-03  +1.38236000E-03  -1.86400000E-05
   +1.06800000E-05  -7.73500000E-05  +1.48500000E-05  -5.38000000E-06  +6.21000000E-06
   +1.47873670E-01  -2.20995710E-01  -2.89567640E-01  -1.53000000E-05  -5.46000000E-06
   -4.40000000E-06  +9.01000000E-06  +4.03000000E-06  -6.00000000E-06  -1.30000000E-06
   -3.50000000E-07  -1.01900000E-05  -2.30400000E-05  -1.60600000E-05  +2.11000000E-06
   +7.60000000E-06  -4.40000000E-06  +7.91000000E-06  +2.23000000E-06  -4.62000000E-06
   +4.21000000E-06  +2.60600000E-05  +2.04000000E-05  -4.54000000E-06  -1.21700000E-05
   +1.41800000E-05  +1.57800000E-05  +3.29800000E-05  -1.94360000E-04  -5.74460000E-04
   -6.10000000E-06  -1.48000000E-06  +2.51000000E-06  -4.90000000E-07  +2.27000000E-06
   +1.93000000E-06  -5.75000000E-06  +4.58000000E-06  +5.00000000E-07  -6.97000000E-06
   -7.23000000E-06  +2.58000000E-06  +4.66000000E-06  +2.14000000E-06  -1.19000000E-06
   -8.70000000E-07  +2.10000000E-06  +2.41000000E-06  -8.06000000E-06  -9.10000000E-07
   -1.07300000E-05  +4.11000000E-06  -2.98000000E-06  -9.25000000E-06  -7.30000000E-07
   +2.90000000E-06  -7.93000000E-06  -1.08000000E-06  +1.10000000E-06  +2.22000000E-06
   +1.77000000E-06  -4.14000000E-06  -6.54000000E-06  -1.18710000E-04  -5.61800000E-05
   +7.31700000E-05  +7.16500000E-05  +3.20560000E-04  +1.22280000E-04  -1.29570000E-04
   -4.22070000E-04  -7.63130000E-04  -1.00710000E-04  -3.59300000E-05  +8.09600000E-05
   -1.38146670E-01  +2.01590700E-01  +2.78234530E-01  -4.66600000E-04  +4.37700000E-04
   -8.88600000E-05  -3.56080000E-04  +2.17680000E-04  +1.75430000E-04  +3.77300000E-05
   +2.85740000E-04  +3.11670000E-04  -7.00600000E-05  -1.79140000E-04  +3.56710000E-04
   +6.59710000E-03  -2.76667100E-02  +1.95968800E-02  +7.05200000E-05  -3.82020000E-04
   -7.39530000E-04  -2.06230000E-04  +4.96300000E-05  +5.11300000E-05  +1.08120000E-04
   +5.58000000E-06  +3.52900000E-05  -3.37652000E-03  -6.06465000E-03  +5.67820000E-03
   +3.01200000E-05  -1.23710000E-04  -3.28500000E-05  -2.56900000E-05  +4.89000000E-06
   -7.21100000E-05  +4.11900000E-05  +8.27800000E-05  -3.91700000E-05  -1.67280000E-04
   -1.52720000E-04  +3.07100000E-05  +3.58900000E-05  -3.27300000E-05  +3.26700000E-05
   +4.03800000E-05  -2.08500000E-05  -1.48900000E-05  +2.08600000E-04  +1.59950000E-04
   +6.90000000E-07  +1.36120000E-04  -5.00000000E-05  -2.65200000E-05  -7.30172500E-02
   +1.24698940E-01  -7.69307200E-02  -3.93400000E-05  -1.77300000E-05  -6.84000000E-06
   +2.04600000E-05  +1.07500000E-05  +1.36600000E-05  -2.28800000E-05  -3.07000000E-06
   -3.68000000E-06  -2.47100000E-05  -1.55400000E-05  +5.81200000E-05  +2.63000000E-06
   +1.09100000E-05  -3.71000000E-06  -1.41500000E-05  +6.95000000E-05  -1.97000000E-06
   -5.57900000E-05  +1.63700000E-05  -5.37700000E-05  +6.52600000E-05  -5.82800000E-05
   +1.41900000E-05  -1.60700000E-05  +7.34000000E-06  -4.87000000E-06  -2.01700000E-05
   +1.30100000E-05  +1.06100000E-05  +3.33700000E-05  -4.00200000E-05  -1.99000000E-05
   -4.39300000E-05  +5.45200000E-05  -1.06090000E-04  -8.72000000E-06  +7.03000000E-05
   -1.49680000E-04  -1.02860000E-04  -2.38450000E-04  +1.01570000E-04  -3.76400000E-05
   -1.28800000E-05  +4.30300000E-05  -2.93620000E-04  +3.44430000E-04  +1.77940000E-04
   +7.09381000E-02  +3.47350000E-04  +5.43900000E-05  +1.81160000E-04  +5.96700000E-05
   +2.59840000E-04  +7.67900000E-05  +2.63810000E-04  -5.97280000E-04  +1.26570000E-04
   +2.48030000E-04  +8.80420000E-04  -2.04130000E-04  +7.92987000E-03  -9.79945000E-03
   +2.39668000E-03  +5.92810000E-04  +1.32862000E-03  -1.43285000E-03  -1.64860000E-04
   +6.34000000E-05  -2.25300000E-05  +9.88500000E-05  -1.87000000E-06  +5.10700000E-05
   -4.03438000E-03  -1.65920000E-03  +3.45745000E-03  +4.88400000E-05  -9.36500000E-05
   -3.54000000E-06  -2.73500000E-05  +5.89000000E-06  -6.17100000E-05  +3.01900000E-05
   +4.24300000E-05  -1.91400000E-05  -7.97800000E-05  -7.83200000E-05  +2.73400000E-05
   +9.65000000E-06  -3.58300000E-05  +1.47300000E-05  +1.84200000E-05  -2.00500000E-05
   -8.53000000E-06  +1.02820000E-04  +7.30800000E-05  -2.70000000E-06  +1.97600000E-04
   +4.42000000E-05  -1.34300000E-05  +8.61360800E-02  -3.30294880E-01  +2.43096120E-01
   -2.17000000E-05  -5.00000000E-06  -9.60000000E-07  +8.13000000E-06  +8.67000000E-06
   +8.14000000E-06  -1.06000000E-06  +1.76000000E-06  +7.23000000E-06  -1.58900000E-05
   -7.26000000E-06  +4.16900000E-05  -1.00000000E-07  +6.12000000E-06  +6.30000000E-07
   -1.62300000E-05  -5.61000000E-05  -5.18300000E-05  -1.43000000E-06  +3.53900000E-05
   -3.42700000E-05  -3.37000000E-06  -7.47700000E-05  +4.19100000E-05  -1.45400000E-05
   +2.10000000E-06  +7.65000000E-06  -1.78000000E-05  -1.01400000E-05  -1.38500000E-05
   +1.88100000E-05  -3.08300000E-05  -2.37800000E-05  -8.14000000E-06  -1.40440000E-04
   -2.51400000E-05  -5.15000000E-05  +1.31050000E-04  -2.09540000E-04  -3.33000000E-04
   -3.81160000E-04  +1.03540000E-04  -5.24200000E-05  -2.40080000E-04  +1.86790000E-04
   +2.14170000E-04  +1.15149000E-03  +3.15400000E-04  -9.14815300E-02  +3.39437490E-01
   -1.89650000E-04  +4.27080000E-04  +5.16200000E-05  +4.67700000E-04  -6.46900000E-05
   +3.56610000E-04  -2.16480000E-04  -2.03350000E-04  -1.34000000E-04  +3.25100000E-05
   -8.30330000E-04  +5.84400000E-05  -8.85150000E-03  +1.53584900E-02  -1.29717400E-02
   -3.20190000E-04  +1.17960000E-04  +1.13115000E-03  +1.44960000E-04  -1.25730000E-04
   -1.51200000E-04  -5.73100000E-05  +2.76000000E-05  -3.36900000E-05  +3.90571000E-03
   +3.05555000E-03  -1.02005000E-03  -2.07600000E-05  +1.60750000E-04  -1.80400000E-05
   +1.82600000E-05  -2.93300000E-05  +4.86600000E-05  -4.65300000E-05  -8.29700000E-05
   +1.05200000E-05  +1.10330000E-04  +1.16280000E-04  -2.51400000E-05  -2.71700000E-05
   +2.59200000E-05  -3.76100000E-05  -8.17000000E-06  -2.90500000E-05  +3.63900000E-05
   -1.53930000E-04  -1.24380000E-04  -1.06200000E-05  -1.55840000E-04  +8.91800000E-05
   +1.20070000E-04  -4.62714300E-02  +2.30429200E-01  -1.77334150E-01  +2.26800000E-05
   +1.53400000E-05  +1.22300000E-05  -2.38200000E-05  -7.63000000E-06  -7.35000000E-06
   +4.41000000E-06  +1.87200000E-05  +8.42000000E-06  +1.89000000E-05  +3.22500000E-05
   -4.65200000E-05  -4.09000000E-06  -4.18000000E-06  +8.42000000E-06  +1.54100000E-05
   -3.21200000E-05  +6.11400000E-05  -3.27800000E-05  -4.55900000E-05  -2.25900000E-05
   -3.76800000E-05  +6.14200000E-05  -8.02200000E-05  +3.54100000E-05  -4.60000000E-07
   -2.88000000E-05  +7.86000000E-06  -5.63800000E-05  -3.72000000E-06  -5.15100000E-05
   +2.81700000E-05  +1.93000000E-06  +4.32900000E-05  +7.45800000E-05  -6.39000000E-05
   +6.45000000E-05  +2.70840000E-04  -1.55890000E-04  -1.22350000E-04  -5.61860000E-04
   -2.75500000E-05  -4.14500000E-05  +1.84100000E-05  -1.23080000E-04  +1.34060000E-04
   -1.16740000E-04  -4.05140000E-04  +5.16066500E-02  -2.48012950E-01  +1.90795420E-01
end_hess

