# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.50690110    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -9.38223709E+00  -3.26794851E+00  -8.07286194E-01
   006   -7.31372596E+00  -1.78577578E+00  -4.63138648E-01
   006   -7.12573494E+00  -3.22703813E-02  +1.47050420E+00
   006   -4.95506002E+00  +1.42463553E+00  +1.72057458E+00
   006   -2.93882974E+00  +1.17213909E+00  +6.62145749E-02
   006   -3.17102584E+00  -6.13280551E-01  -1.86155301E+00
   006   -5.31195510E+00  -2.07446677E+00  -2.14028475E+00
   006   -5.41429923E-01  +2.78438917E+00  +2.20810454E-01
   006   -5.67279442E-01  +4.63747431E+00  -2.01102481E+00
   006   -4.16451778E-01  +4.35195987E+00  +2.66107441E+00
   006   +1.76332623E+00  +1.03403952E+00  +1.87051776E-01
   006   +1.86860086E+00  -9.27094301E-01  +2.03460016E+00
   006   +3.98599506E+00  -2.49278350E+00  +2.25815272E+00
   006   +5.97290982E+00  -2.22662288E+00  +6.44827504E-01
   006   +5.95163620E+00  -3.84285604E-01  -1.49957151E+00
   006   +3.69392889E+00  +1.30218094E+00  -1.47226665E+00
   008   +8.06459617E+00  -3.65913676E+00  +8.67631880E-01
   001   -1.06152462E+01  -2.89536325E+00  +4.61531466E-01
   001   -8.66923995E+00  +2.05712733E-01  +2.79669233E+00
   001   -4.87323795E+00  +2.77007379E+00  +3.25515075E+00
   001   -1.61795782E+00  -8.81145994E-01  -3.16779070E+00
   001   -5.46030580E+00  -3.45534917E+00  -3.63920155E+00
   001   -2.27733339E+00  +5.78249792E+00  -1.92398584E+00
   001   +1.05414382E+00  +5.90965037E+00  -1.94978501E+00
   001   -5.61119224E-01  +3.65505247E+00  -3.82097564E+00
   001   -5.12819883E-01  +3.17250334E+00  +4.34652019E+00
   001   +1.36407701E+00  +5.38657328E+00  +2.71469208E+00
   001   -1.94847814E+00  +5.72903940E+00  +2.74006785E+00
   001   +2.95053696E-01  -1.18480140E+00  +3.31121757E+00
   001   +4.08789800E+00  -3.90247992E+00  +3.73537171E+00
   001   +6.01141415E+00  -1.45686242E+00  -3.27827219E+00
   001   +3.67498280E+00  +2.74210831E+00  -2.92083073E+00
   001   +9.37060442E+00  -2.88656662E+00  -1.34593130E-01
   008   +8.30071237E+00  +9.82469846E-01  -1.56847714E+00
   001   +8.26399965E+00  +2.18671647E+00  -2.13130984E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.15000000E-06  +1.27000000E-06  -2.84000000E-06
   -2.14000000E-06  -2.74000000E-06  -3.73000000E-06
   +1.50000000E-06  +5.30000000E-07  -1.46000000E-06
   -6.10000000E-07  -2.32000000E-06  -2.47000000E-06
   +2.50000000E-07  +3.00000000E-08  -2.68000000E-06
   -1.59000000E-06  +9.80000000E-07  +5.20000000E-07
   +1.00000000E-07  +8.20000000E-07  -4.00000000E-08
   -1.50000000E-07  -5.30000000E-07  -1.20000000E-07
   +1.46000000E-06  -1.40000000E-07  +9.00000000E-07
   -1.28000000E-06  -9.10000000E-07  +6.60000000E-07
   +2.80000000E-06  +2.28000000E-06  -2.21000000E-06
   +2.49000000E-06  -2.09000000E-06  +1.52000000E-06
   -2.06000000E-06  +2.07000000E-06  -8.90000000E-07
   -5.87000000E-06  +3.27000000E-06  -5.00000000E-07
   +1.10000000E-06  +4.08000000E-06  +7.45000000E-06
   -3.87000000E-06  -1.62000000E-06  +2.86000000E-06
   +6.46000000E-06  -2.85000000E-06  +9.00000000E-07
   +7.80000000E-07  +3.00000000E-08  -3.36000000E-06
   -1.92000000E-06  -3.90000000E-07  -1.38000000E-06
   -9.10000000E-07  +8.70000000E-07  +1.20000000E-07
   +1.51000000E-06  -4.80000000E-07  -1.60000000E-06
   +1.03000000E-06  -7.50000000E-07  -3.73000000E-06
   +1.10000000E-07  +5.40000000E-07  +7.00000000E-08
   -4.00000000E-08  +9.30000000E-07  +1.07000000E-06
   +1.21000000E-06  +1.53000000E-06  +0.00000000E+00
   -6.70000000E-07  -4.30000000E-07  +5.30000000E-07
   -4.70000000E-07  -6.00000000E-08  +1.32000000E-06
   -1.48000000E-06  -3.40000000E-07  +7.30000000E-07
   -1.26000000E-06  -6.10000000E-07  +1.12000000E-06
   -7.60000000E-07  -1.65000000E-06  +1.68000000E-06
   +5.80000000E-07  -1.78000000E-06  -2.95000000E-06
   +8.30000000E-07  +1.50000000E-06  +3.30000000E-07
   +4.60000000E-07  +6.30000000E-07  +2.62000000E-06
   +4.00000000E-08  -1.52000000E-06  +3.39000000E-06
   +2.30000000E-07  -1.30000000E-07  +2.16000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.40199240E-01  +9.43334200E-02  +2.10944850E-01  -2.35138770E-01  +1.51889310E-01
   +3.64221390E-01  -2.28706140E-01  -9.78226700E-02  +9.88500000E-03  +6.31109050E-01
   -1.29070650E-01  -1.47995090E-01  -3.49756200E-02  +1.50250410E-01  +4.45386920E-01
   -2.68211600E-02  -5.60943300E-02  -9.15820000E-02  -1.38501220E-01  +2.29772570E-01
   +5.25256370E-01  -1.08007400E-02  -3.91954900E-02  -3.21383200E-02  -1.25243900E-01
   +6.80641000E-03  +4.61080800E-02  +6.34897770E-01  -1.51638900E-02  -2.11376300E-02
   -2.62319800E-02  -4.39113400E-02  -1.85345200E-01  -1.07010310E-01  +1.56221110E-01
   +4.15391480E-01  -3.82014000E-03  -9.85160000E-03  +7.50030000E-04  -1.34700300E-02
   -1.41457260E-01  -2.25832790E-01  -1.60839690E-01  +2.36482580E-01  +5.11486320E-01
   -4.19250000E-04  +3.32334000E-03  +9.50672000E-03  +3.10628500E-02  -4.80531600E-02
   -7.60556600E-02  -2.62295090E-01  -9.57216800E-02  +2.40879600E-02  +5.92703310E-01
   -1.67882000E-03  +4.08018000E-03  -3.25347000E-03  -1.20566600E-02  -2.93087800E-02
   -2.86636000E-02  -1.38058400E-01  -1.60692770E-01  -2.57327200E-02  +1.52596480E-01
   +4.46793210E-01  +3.39296000E-03  -6.66789000E-03  -2.35766000E-03  -3.31819100E-02
   -4.82662000E-03  +1.86813900E-02  -2.51242800E-02  -5.36676100E-02  -1.05510350E-01
   -1.26144340E-01  +2.57258470E-01  +5.29616530E-01  -1.27535000E-03  -2.47308000E-03
   -2.98949000E-03  -1.16223800E-02  +1.89247600E-02  +2.66084400E-02  -4.77806800E-02
   -2.82260300E-02  +3.86697000E-03  -2.39522680E-01  +1.78013400E-02  +1.37863970E-01
   +5.73466640E-01  -3.27453000E-03  -5.44210000E-04  +3.01467000E-03  +2.06257200E-02
   -1.96359000E-02  -2.99562100E-02  +4.19032000E-03  +3.14782100E-02  +2.56987300E-02
   -2.41172000E-02  -1.02333490E-01  -2.63782400E-02  +1.11394570E-01  +4.17626520E-01
   -4.90709000E-03  +1.84805000E-03  +4.19381000E-03  +2.89958000E-02  -2.87946600E-02
   -5.88521900E-02  +4.18502500E-02  +4.66756200E-02  +3.40250400E-02  +8.88922200E-02
   -5.33435700E-02  -1.90447840E-01  -1.35510770E-01  +1.91458510E-01  +4.99776520E-01
   +3.76934000E-03  -1.31720000E-04  +6.21580000E-04  -5.17702000E-02  +4.21084000E-03
   +4.09776100E-02  -2.10630000E-02  -2.42749300E-02  -1.67226200E-02  +3.78670700E-02
   +2.45553900E-02  +9.79879000E-03  -1.20296210E-01  -4.20567000E-03  +2.97518200E-02
   +6.55643690E-01  +4.25880000E-03  +3.72210000E-04  -8.07408000E-03  -3.15093100E-02
   +3.25208200E-02  +5.61438200E-02  -2.74462600E-02  -3.95855600E-02  -2.40855000E-02
   +5.69523800E-02  +1.27154500E-02  -3.25762300E-02  -4.55558000E-02  -1.83522660E-01
   -9.99150700E-02  +1.54632820E-01  +4.23608400E-01  +5.69270000E-03  -5.18453000E-03
   -5.00913000E-03  -1.06436000E-03  +3.26278200E-02  +4.09930700E-02  -2.03828800E-02
   -2.64252100E-02  -2.08049500E-02  +4.77279900E-02  -1.11620100E-02  -3.62136600E-02
   -1.99566600E-02  -1.27666400E-01  -2.05872800E-01  -1.54951730E-01  +2.18662750E-01
   +4.99993690E-01  -4.83000400E-02  -5.80059000E-03  +3.04124400E-02  -2.15327920E-01
   -1.56424300E-02  +7.87290400E-02  +3.81989800E-02  +5.21832800E-02  +4.11771400E-02
   -6.37084600E-02  -1.56645500E-02  +2.14691200E-02  +2.42267500E-02  -4.64111900E-02
   -6.68493200E-02  -2.78902910E-01  -1.06216310E-01  +2.19281900E-02  +6.14409180E-01
   -2.98760300E-02  +7.08068000E-03  +1.99449300E-02  +3.32559200E-02  -1.07511860E-01
   -6.44526600E-02  +2.28964200E-02  +1.39521700E-02  -8.95344000E-03  -1.66297800E-02
   -7.11317000E-03  +6.20624000E-03  -1.47942000E-02  -2.41460000E-02  -2.76118500E-02
   -1.48948990E-01  -1.71465680E-01  -3.03631000E-02  +1.74750990E-01  +4.60525980E-01
   +2.46687000E-03  +3.77571000E-03  +1.00713800E-02  +1.35147110E-01  -3.15789900E-02
   -1.98742290E-01  +6.73011000E-03  -2.86671600E-02  -2.97198700E-02  +2.10314400E-02
   +5.75070000E-03  -1.02826100E-02  -2.80818400E-02  -6.34591000E-03  +2.02328900E-02
   -2.79881600E-02  -5.88116400E-02  -1.10279450E-01  -1.18861230E-01  +2.67026990E-01
   +5.19927270E-01  +1.57990000E-03  +1.04697000E-03  -2.28840000E-04  -2.34781000E-03
   +1.52900000E-04  +1.09515000E-03  +4.08560000E-04  -7.93860000E-04  +3.78952000E-03
   -1.95793900E-02  -1.34221400E-02  +1.94070000E-04  -1.43616620E-01  -4.18420500E-02
   +2.78841000E-03  -2.94773000E-03  -8.03269000E-03  -6.55431000E-03  +3.92018000E-03
   +5.15630000E-04  +1.54044000E-03  +4.72658640E-01  +6.95660000E-04  +9.93200000E-05
   +4.39210000E-04  -2.59100000E-04  -7.94740000E-04  -2.69950000E-04  +2.81890000E-04
   +3.64879000E-03  -4.02623000E-03  -8.02010000E-04  +5.64460000E-03  +3.57548000E-03
   -4.54527300E-02  -1.05712150E-01  -1.04578800E-02  -1.94843100E-02  -1.34926900E-02
   -2.99531000E-03  +1.41860000E-04  +1.31795000E-03  -4.28592000E-03  -3.04540000E-04
   +4.82981570E-01  +6.09720000E-04  +1.01728000E-03  +1.14610000E-04  +2.80520000E-04
   -8.96940000E-04  -1.71268000E-03  +4.11239000E-03  -2.81714000E-03  +6.36980000E-04
   +1.32123200E-02  +1.15516900E-02  +5.69260000E-03  -8.99890000E-04  -1.25751100E-02
   -8.28334700E-02  -2.13035800E-02  -1.22244300E-02  +2.45762000E-03  +1.31350000E-03
   -5.44556000E-03  -1.90775000E-03  +1.13220000E-04  -1.07298000E-03  +4.84319550E-01
   -1.25180000E-03  -9.49660000E-04  -1.48210000E-04  +4.69650000E-04  +8.59330000E-04
   +7.58290000E-04  -1.41284000E-03  +2.18100000E-04  -1.36594000E-03  -5.59800000E-04
   -1.79900000E-03  -9.09050000E-04  -4.66929000E-03  -2.01925800E-02  +2.23302200E-02
   -5.11880000E-04  -8.73790000E-04  +8.16440000E-04  -7.95300000E-05  +7.05780000E-04
   +1.34890000E-04  -7.57003900E-02  -1.48631000E-03  +2.30317000E-03  +5.85738770E-01
   -4.43750000E-04  -3.92310000E-04  -7.90100000E-05  +3.64700000E-05  +5.43600000E-04
   +6.20830000E-04  -7.12220000E-04  -1.15930000E-04  -9.49200000E-04  +1.54167000E-03
   -9.86500000E-04  -6.66080000E-04  -9.23985000E-03  -1.91188000E-02  +1.60841600E-02
   -3.88850000E-04  -3.73980000E-04  +1.02081000E-03  +1.05240000E-04  +7.27690000E-04
   +2.92700000E-05  +3.01694000E-03  -1.15296100E-01  +5.01774100E-02  +2.25780000E-03
   +5.31801600E-01  -6.02490000E-04  -4.27450000E-04  -1.37310000E-04  +1.17490000E-04
   +3.38140000E-04  +5.62850000E-04  -1.92780000E-04  -3.14600000E-04  -3.11370000E-04
   -7.84240000E-04  -2.69730000E-04  -1.20290000E-04  +7.22173000E-03  +5.95531000E-03
   -6.11900000E-05  -1.73736000E-03  -1.17725000E-03  -2.28400000E-04  +3.28970000E-04
   +2.46700000E-05  -2.22630000E-04  -2.21189000E-03  +4.70640600E-02  -1.34453930E-01
   -4.13745000E-03  +6.40664900E-02  +5.21109540E-01  -5.71060000E-04  -3.92620000E-04
   -4.71000000E-05  +3.72460000E-04  +2.27550000E-04  +1.03780000E-04  +2.27190000E-04
   -4.50710000E-04  -8.12520000E-04  -2.00593000E-03  -1.13552000E-03  -7.95790000E-04
   -1.68560000E-03  -1.67651300E-02  -2.54949000E-02  -5.14475000E-03  -2.32711000E-03
   +1.00641000E-03  +3.35820000E-04  -1.12168000E-03  -9.80410000E-04  -7.56942800E-02
   +3.94200000E-05  -2.27740000E-04  +5.38620000E-04  +3.54850000E-04  -1.36650000E-04
   +5.84501200E-01  +1.93500000E-05  -3.17200000E-05  -1.35700000E-05  -1.58930000E-04
   +5.98100000E-05  -1.21510000E-04  +5.66090000E-04  -4.03040000E-04  -6.10410000E-04
   -5.79940000E-04  -8.17030000E-04  +5.76000000E-04  -5.15399000E-03  -1.32873800E-02
   -1.74431200E-02  -3.01398000E-03  -3.59340000E-04  +2.77990000E-04  +2.46250000E-04
   -4.94620000E-04  -6.34070000E-04  -3.81822000E-03  -1.04092680E-01  -4.64486400E-02
   +4.12860000E-04  +1.04811400E-02  +1.70591800E-02  -4.26120000E-03  +5.46434370E-01
   +3.39510000E-04  +2.08820000E-04  -9.60000000E-06  -2.67860000E-04  -9.64500000E-05
   +2.04470000E-04  +2.55710000E-04  +2.76000000E-06  -2.05740000E-04  +1.12513000E-03
   +7.39980000E-04  +1.67950000E-04  -5.03945000E-03  -3.13892000E-03  -1.89141000E-03
   +8.90010000E-04  +6.25830000E-04  +1.04370000E-04  +4.48370000E-04  +1.66570000E-04
   +9.35800000E-05  -5.39738000E-03  -4.19717100E-02  -1.44680720E-01  -9.05510000E-04
   -1.14894200E-02  -3.71373600E-02  -8.81825000E-03  -6.08100400E-02  +5.05361480E-01
   -1.10200000E-05  +5.24000000E-06  -6.53100000E-05  -2.77440000E-04  +2.13230000E-04
   +5.22040000E-04  -2.96340000E-04  -1.07190000E-03  +7.35020000E-04  -1.02908000E-03
   -6.82300000E-04  -2.27881000E-03  -3.68484400E-02  +1.10711600E-02  +2.91955000E-03
   -1.00576000E-03  +4.84120000E-04  -7.16180000E-04  +3.44300000E-04  +6.42880000E-04
   +6.56940000E-04  -1.36468300E-01  +4.54468600E-02  +3.45410000E-03  -6.24940000E-04
   +5.21033000E-03  -4.44382000E-03  -3.17920000E-03  +7.22714000E-03  +7.69858000E-03
   +5.69655160E-01  -1.29809000E-03  -9.82780000E-04  -2.43800000E-04  +3.78550000E-04
   +1.25313000E-03  +8.94440000E-04  -9.04790000E-04  -1.46863000E-03  +4.33440000E-04
   -1.59495000E-03  -2.39305000E-03  -1.33914000E-03  -9.74999000E-03  +1.49149200E-02
   +2.16823000E-03  -2.96436000E-03  -6.46660000E-04  -7.47490000E-04  +2.92220000E-04
   -7.12400000E-05  +1.24200000E-05  +4.23321000E-02  -1.14055210E-01  +9.51114000E-03
   +1.86743300E-02  -1.68873700E-02  +1.84239000E-03  +1.54254700E-02  -1.65371300E-02
   -9.33171000E-03  -1.05657050E-01  +4.07886410E-01  +1.33050000E-04  +1.16770000E-04
   +9.36300000E-05  +1.33200000E-04  -3.18740000E-04  -5.12840000E-04  +3.97850000E-04
   +5.99550000E-04  +1.64600000E-05  -6.73800000E-05  +3.56330000E-04  +1.38540000E-04
   +2.01924000E-03  -1.09700000E-03  -4.53410000E-04  -1.18086000E-03  -4.28480000E-04
   +5.95610000E-04  -4.40910000E-04  +5.40100000E-05  +6.02100000E-05  +5.82443000E-03
   +6.47253000E-03  -8.36953100E-02  -2.20596700E-02  +1.73228900E-02  +6.31970000E-04
   +2.54611800E-02  -2.15313100E-02  -2.08237000E-03  -1.77791060E-01  -1.46197350E-01
   +4.55047780E-01  -1.46780000E-04  -1.25300000E-04  -2.19100000E-05  -6.84800000E-05
   +1.93290000E-04  +3.49600000E-04  -2.58720000E-04  -5.31670000E-04  -2.99000000E-06
   +5.51850000E-04  +3.42340000E-04  -4.81570000E-04  -5.55070000E-04  +2.74841000E-03
   -1.49666000E-03  -9.71700000E-04  +3.55200000E-05  -5.69730000E-04  +3.65870000E-04
   +1.85800000E-04  -1.68290000E-04  -1.06579000E-03  +2.01137300E-02  -1.86716600E-02
   -4.71994000E-03  +3.08651000E-03  +1.44716000E-03  -5.16480000E-04  +8.32020000E-04
   -1.65074000E-03  -1.09019370E-01  +3.61478000E-03  +3.05445800E-02  +5.96076400E-01
   +3.17770000E-04  +2.78660000E-04  +8.39900000E-05  -7.82100000E-05  -3.16140000E-04
   -2.42990000E-04  +3.63800000E-05  +2.65990000E-04  +2.10120000E-04  -1.63250000E-04
   -9.07300000E-05  +3.33220000E-04  -7.63500000E-05  -1.33884000E-03  +6.18820000E-04
   +4.52310000E-04  -3.56460000E-04  -3.82590000E-04  -1.51220000E-04  +1.59620000E-04
   +1.50790000E-04  +7.44195000E-03  -1.57935200E-02  +1.13583600E-02  +2.71843000E-03
   -4.56950000E-04  -7.09390000E-04  +1.92941000E-03  -1.45092000E-03  +1.45607000E-03
   +5.06200000E-02  -1.57084940E-01  +5.73501900E-02  -1.29720460E-01  +3.77857290E-01
   -3.40530000E-04  -2.64810000E-04  -1.01210000E-04  +1.67310000E-04  +4.27040000E-04
   +5.19940000E-04  -2.23060000E-04  -3.42660000E-04  -3.28940000E-04  +7.88310000E-04
   +3.42980000E-04  -8.86410000E-04  -1.28660000E-03  +1.34739000E-03  +3.23100000E-05
   -9.12270000E-04  +7.19010000E-04  -9.20600000E-05  +4.19550000E-04  +2.18900000E-04
   -1.99710000E-04  -6.04762000E-03  +1.44866000E-03  +4.51038000E-03  +1.22824000E-03
   -4.86200000E-04  +2.84000000E-06  -4.74300000E-05  +5.85700000E-05  -6.04620000E-04
   -1.70131900E-02  +8.95833700E-02  -1.36773310E-01  -1.87963920E-01  -1.80455760E-01
   +4.12385630E-01  -1.01430000E-04  -2.29500000E-05  +2.64800000E-05  +2.83060000E-04
   -1.42480000E-04  -3.53680000E-04  +2.45460000E-04  +3.84730000E-04  +8.65600000E-05
   -3.26050000E-04  -2.33210000E-04  +1.75400000E-04  +3.06020000E-04  -5.69920000E-04
   -2.19570000E-04  +4.65850000E-04  +8.55600000E-05  +1.86020000E-04  -3.77020000E-04
   -1.12090000E-04  +2.23770000E-04  +2.59216000E-03  -7.18140000E-04  +6.02670000E-04
   +4.60620000E-04  -2.05030000E-04  +2.05900000E-04  +5.45010000E-04  -5.69950000E-04
   +7.56600000E-04  +2.25554700E-02  +3.50551200E-02  -5.01819300E-02  -2.05860810E-01
   +6.97006400E-02  +3.55993800E-02  +5.37187780E-01  -2.08540000E-04  -1.30920000E-04
   -4.20500000E-05  +1.56360000E-04  +1.68610000E-04  +1.99540000E-04  -5.54100000E-05
   -1.75220000E-04  -1.28540000E-04  +3.39570000E-04  +3.04790000E-04  -3.08930000E-04
   -7.84280000E-04  +1.48880000E-04  -2.61750000E-04  -2.13490000E-04  +2.58920000E-04
   -5.92300000E-05  +1.52280000E-04  +1.61570000E-04  -6.74300000E-05  -1.32792000E-03
   -4.51500000E-04  +4.36706000E-03  +9.88630000E-04  -4.54730000E-04  -3.18110000E-04
   -4.25510000E-04  +5.49890000E-04  +1.40130000E-04  +1.33144700E-02  -2.95805100E-02
   +2.74900300E-02  +1.25314810E-01  -1.51918190E-01  +2.47921100E-02  -1.32047140E-01
   +4.49480740E-01  +1.94760000E-04  +1.20370000E-04  +1.03000000E-05  -2.82550000E-04
   -2.36200000E-05  +1.23160000E-04  -1.43440000E-04  -1.55110000E-04  +1.96000000E-05
   +6.78600000E-05  -2.25800000E-05  +9.46100000E-05  +5.49140000E-04  +2.75300000E-04
   +9.34000000E-05  -1.64690000E-04  -2.58470000E-04  -1.01110000E-04  +2.13820000E-04
   +5.51400000E-05  -1.32610000E-04  +1.70548000E-03  +3.61276000E-03  -1.78050000E-03
   -1.00060000E-03  +6.12800000E-04  +3.70010000E-04  -1.76070000E-04  +8.07200000E-05
   -5.12630000E-04  -2.60891700E-02  +9.84578000E-03  +1.26717500E-02  -2.57416100E-02
   +6.52695600E-02  -1.00077370E-01  -1.43212700E-01  -2.73994240E-01  +5.05758080E-01
   +8.04010000E-04  +5.00160000E-04  +7.71300000E-05  -7.38190000E-04  -4.27340000E-04
   -7.84700000E-05  +1.21010000E-04  +1.16830000E-04  +1.50150000E-04  -1.81200000E-05
   +8.49500000E-05  +9.86300000E-05  -1.77800000E-04  -6.61700000E-05  +6.05600000E-05
   -4.35000000E-05  -3.92100000E-05  +1.00810000E-04  +2.05990000E-04  -1.64990000E-04
   -1.97420000E-04  -1.74168000E-03  +9.70000000E-06  +8.11250000E-04  +3.33610000E-04
   -1.06700000E-05  -1.07440000E-04  -2.23200000E-05  +1.76050000E-04  -2.87370000E-04
   -6.76255000E-03  -1.01199500E-02  +1.50870900E-02  -6.41071300E-02  +3.95268800E-02
   +3.38936000E-03  -2.26906370E-01  -4.34261300E-02  +1.61434000E-01  +6.84821600E-01
   -6.36450000E-04  -4.15740000E-04  -7.62500000E-05  +4.78710000E-04  +4.23950000E-04
   +2.03700000E-04  -1.68330000E-04  -2.79140000E-04  -1.42510000E-04  +9.67800000E-05
   +2.43900000E-05  -2.01820000E-04  -6.35600000E-05  +5.67910000E-04  +9.77400000E-05
   -1.01040000E-04  -2.06700000E-05  -1.12750000E-04  -2.47200000E-05  +1.22940000E-04
   +9.76100000E-05  +3.36900000E-05  -6.25380000E-04  -1.23300000E-04  -2.72470000E-04
   +8.17400000E-05  +5.40000000E-06  -3.16030000E-04  +7.16400000E-05  -3.11000000E-06
   -4.33561000E-03  -7.78699000E-03  +9.27316000E-03  +4.93171000E-03  +2.04636300E-02
   -2.08281200E-02  +4.22792000E-03  -1.03847470E-01  +4.81042400E-02  -1.28031580E-01
   +3.79606470E-01  +1.04010000E-04  +9.34800000E-05  +2.37700000E-05  +3.42000000E-05
   -1.48090000E-04  -2.04740000E-04  +1.50560000E-04  +2.40200000E-04  +5.96800000E-05
   -1.69360000E-04  -4.13600000E-05  +1.63240000E-04  +3.54210000E-04  -5.32640000E-04
   -1.08070000E-04  +2.07720000E-04  +1.17500000E-05  +5.16900000E-05  -1.28620000E-04
   -4.68500000E-05  +4.80800000E-05  +9.91990000E-04  +4.75820000E-04  -6.24310000E-04
   +1.22600000E-05  +2.68500000E-05  -1.85500000E-05  +3.47010000E-04  -2.94270000E-04
   +4.45630000E-04  +8.20224000E-03  +1.12629100E-02  -1.80400500E-02  +3.78676200E-02
   -4.23497300E-02  +2.38490200E-02  +1.11613750E-01  +8.06692800E-02  -2.16235850E-01
   -1.93615570E-01  -1.73817320E-01  +4.76559920E-01  +6.75290000E-04  +4.21900000E-04
   +5.39900000E-05  -5.04530000E-04  -3.98540000E-04  -1.45190000E-04  +1.88660000E-04
   +2.41340000E-04  +1.02840000E-04  -7.50000000E-05  +4.96900000E-05  +1.98580000E-04
   +2.63680000E-04  -4.44650000E-04  +2.27200000E-05  +5.98000000E-05  +4.05800000E-05
   +1.63200000E-04  +1.49030000E-04  -1.80980000E-04  -1.96570000E-04  +9.77720000E-04
   +3.57730000E-04  +2.47229000E-03  +7.63780000E-04  -5.27960000E-04  -1.55900000E-05
   -7.12000000E-05  +3.66880000E-04  +2.38360000E-04  -2.23204700E-02  +8.65581000E-03
   +1.32058000E-02  +1.51364000E-03  +1.28840000E-03  -6.82396000E-03  +2.07889000E-03
   -1.30166000E-02  +1.87605200E-02  -7.50824400E-02  +8.06372000E-03  +3.29793000E-03
   +4.51930510E-01  +2.55440000E-04  +1.46830000E-04  +4.03300000E-05  -1.81320000E-04
   -2.31190000E-04  -1.44080000E-04  +1.24060000E-04  +1.89860000E-04  +2.05800000E-05
   -8.97200000E-05  -3.76900000E-05  +3.55850000E-04  +1.38179000E-03  -7.87300000E-04
   -3.65770000E-04  -4.65000000E-06  -1.76520000E-04  -1.20220000E-04  -7.73600000E-05
   -9.43900000E-05  +3.33000000E-06  +2.49521000E-03  +4.75497000E-03  +6.64099000E-03
   +3.91720000E-04  -4.82960000E-04  +2.66700000E-05  -1.80941000E-03  +1.24637000E-03
   -3.40730000E-04  +3.48884000E-03  +1.27742300E-02  -1.27165400E-02  +3.03442000E-03
   -1.12227200E-02  +2.71035000E-03  -1.10914900E-02  +9.53266000E-03  +7.11448000E-03
   +1.56841000E-02  -1.20612210E-01  +5.96986500E-02  -6.31328500E-02  +5.04636140E-01
   -1.06300000E-05  -4.67000000E-06  +1.73000000E-06  +5.63000000E-05  -5.77100000E-05
   -4.81100000E-05  +8.14100000E-05  +1.48790000E-04  -1.28590000E-04  +1.70020000E-04
   +1.72180000E-04  +2.62760000E-04  +1.57578000E-03  -1.36200000E-03  -3.54560000E-04
   +7.81000000E-06  -9.23400000E-05  -1.64740000E-04  -3.46700000E-05  +3.30400000E-05
   +3.08100000E-05  +4.78442000E-03  +5.86941000E-03  +1.75996000E-03  -6.03140000E-04
   +6.82460000E-04  -8.95100000E-05  -9.31290000E-04  +6.88660000E-04  +3.08270000E-04
   +1.80288000E-02  -1.35477000E-02  +1.87093000E-03  -5.69297000E-03  -1.98838000E-03
   -2.41665000E-03  +9.60417000E-03  +9.26110000E-03  -1.07525300E-02  -4.42508000E-03
   +5.88622300E-02  -1.59316240E-01  -7.28099000E-03  +2.05183000E-02  +5.44571110E-01
   -2.96280000E-04  -1.51900000E-04  -1.62000000E-05  +3.81660000E-04  +3.77400000E-05
   -3.14010000E-04  +1.33170000E-04  +1.68220000E-04  +2.14640000E-04  -7.24450000E-04
   -6.83270000E-04  -2.28800000E-05  -4.27680000E-04  +1.30263000E-03  +1.84120000E-04
   +4.69710000E-04  +7.96300000E-05  +4.63950000E-04  -3.94440000E-04  -1.97550000E-04
   +1.88930000E-04  -1.85112700E-02  +2.42692000E-03  +1.56249300E-02  -2.22550000E-03
   +2.60220000E-04  +1.16926000E-03  -1.57555000E-03  -1.26451000E-03  -1.13471000E-03
   -2.79815890E-01  +1.76250300E-02  +1.46283490E-01  +1.45895300E-02  -4.08708200E-02
   +3.88762600E-02  -2.21846700E-02  +1.02880700E-02  +5.12759000E-03  +7.97878000E-03
   +1.20917400E-02  -1.59879600E-02  -1.49079730E-01  +6.51460500E-02  +1.84616000E-03
   +5.48320220E-01  +3.98000000E-04  +2.84480000E-04  +8.36000000E-05  -3.20180000E-04
   -2.05240000E-04  +5.23000000E-06  +2.92800000E-05  +1.93000000E-04  -1.47520000E-04
   +7.19830000E-04  +7.37570000E-04  +2.02790000E-04  +9.81920000E-04  -3.05296000E-03
   -7.85650000E-04  -1.35610000E-04  +5.78500000E-05  -2.60740000E-04  +1.80450000E-04
   +3.12510000E-04  +1.34000000E-05  +1.42154700E-02  +6.12824000E-03  -1.32327200E-02
   +1.59613000E-03  -1.18578000E-03  -9.77680000E-04  +2.58000000E-03  -1.71573000E-03
   +4.07880000E-04  -8.89621000E-03  -9.33528700E-02  +4.70825300E-02  -1.82263700E-02
   -3.72644000E-03  +2.69538100E-02  -3.56696000E-03  +1.20881000E-03  +7.61280000E-04
   +1.72965000E-02  -1.28487200E-02  -3.00817000E-03  +7.43057300E-02  -1.46835740E-01
   +1.45178300E-02  -9.51396800E-02  +4.38404740E-01  -4.46020000E-04  -3.08290000E-04
   -4.55000000E-06  +8.83900000E-05  +3.25410000E-04  +3.73430000E-04  -3.90780000E-04
   -5.53600000E-04  -1.81700000E-05  +2.71400000E-04  +3.44500000E-05  -1.10640000E-04
   -2.13053000E-03  +9.57040000E-04  +9.20100000E-05  -6.57630000E-04  -3.37400000E-04
   -9.88820000E-04  +9.06400000E-05  +4.32290000E-04  +2.31240000E-04  +3.53439000E-03
   -4.01007000E-03  +4.56942000E-03  -9.40670000E-04  -3.33350000E-04  -3.44920000E-04
   -1.43481000E-03  +1.29335000E-03  -4.15640000E-04  +1.73876990E-01  +2.95413600E-02
   -2.09349000E-01  +1.47445900E-02  +4.22601900E-02  -4.26285600E-02  +1.90370800E-02
   -8.20590000E-03  -5.09409000E-03  -2.79713000E-02  +9.77976000E-03  +8.63756000E-03
   +4.61837000E-03  +1.35794900E-02  -8.82497800E-02  -2.14796610E-01  -2.31439940E-01
   +5.21530630E-01  -1.11615000E-03  -7.32470000E-04  -1.21170000E-04  +8.88170000E-04
   +6.79620000E-04  +2.83880000E-04  -2.33390000E-04  -3.77070000E-04  -2.54080000E-04
   +1.78170000E-04  +2.89000000E-06  -3.50710000E-04  +3.39000000E-06  +6.84720000E-04
   +1.42600000E-05  -1.28030000E-04  +6.25300000E-05  -9.62900000E-05  -1.47610000E-04
   +1.82890000E-04  +1.90950000E-04  +9.81790000E-04  -5.78150000E-04  -1.69510000E-04
   -5.85220000E-04  +1.74930000E-04  +7.49700000E-05  -5.35250000E-04  +1.50930000E-04
   -2.31600000E-05  -9.36320000E-04  -3.87951000E-03  +3.74421000E-03  +1.13740000E-04
   -1.52062000E-03  +4.36633000E-03  -4.73813300E-02  +2.99431800E-02  +1.47404000E-03
   -2.53518310E-01  +1.42757840E-01  -1.52161300E-02  -2.08669700E-02  +1.43838700E-02
   -3.24572000E-03  +4.94092000E-03  +2.75376000E-03  -2.35382000E-03  +5.78427290E-01
   +7.74120000E-04  +5.28000000E-04  +8.11900000E-05  -5.86310000E-04  -4.90110000E-04
   -2.20990000E-04  +1.82050000E-04  +3.09930000E-04  +1.74610000E-04  -1.24770000E-04
   +2.87000000E-06  +2.44560000E-04  +5.82000000E-06  -5.68910000E-04  +2.25000000E-06
   +1.20520000E-04  +3.84000000E-06  +8.47500000E-05  +8.27600000E-05  -1.17730000E-04
   -1.41790000E-04  -6.85710000E-04  +2.98440000E-04  -3.12930000E-04  +3.77510000E-04
   -1.48150000E-04  -6.22300000E-05  +4.53440000E-04  -1.72310000E-04  +9.93700000E-05
   +6.29550000E-04  +2.57983000E-03  -3.60750000E-03  +2.22102000E-03  -4.15940000E-04
   +5.30298000E-03  +3.13709000E-03  +1.04458900E-02  -4.56803000E-03  +1.03194210E-01
   -1.54371150E-01  +5.27103700E-02  +2.92547400E-02  -2.09842000E-02  +6.46936000E-03
   -3.03731000E-03  -2.76182000E-03  +6.49774000E-03  -1.73037800E-02  +2.90502710E-01
   +2.05300000E-05  +8.00000000E-06  +1.50600000E-05  -3.80600000E-05  +1.80000000E-07
   -1.30000000E-06  -3.39300000E-05  -3.20700000E-05  +3.47200000E-05  -2.94400000E-05
   -5.19600000E-05  +2.17800000E-05  -6.55900000E-05  +1.40530000E-04  +1.04300000E-04
   +1.37500000E-05  -7.10900000E-05  -4.44600000E-05  +3.67000000E-06  -9.31000000E-06
   +3.01000000E-06  -4.11070000E-04  -3.42050000E-04  +9.32100000E-05  +1.78600000E-05
   +4.51000000E-06  +1.94300000E-05  -9.37900000E-05  +8.22300000E-05  -1.58890000E-04
   -6.71210000E-04  -3.73100000E-04  -5.70200000E-05  +6.50740000E-04  +7.08126000E-03
   -2.76717000E-03  +3.09708700E-02  -2.14699900E-02  +8.74409000E-03  +1.23007800E-02
   +3.97621400E-02  -7.82913500E-02  -2.54763900E-02  +1.98598700E-02  +2.44176000E-03
   +3.73395000E-03  +3.65315000E-03  -4.23258000E-03  -1.91469410E-01  -1.88303560E-01
   +2.39652380E-01  -2.55605510E-01  +4.64192200E-02  +2.24400500E-01  -3.29167700E-02
   +7.41345000E-03  +2.91777200E-02  +4.42933000E-03  +2.95537000E-03  -1.47830000E-04
   -1.06926000E-03  +1.22790000E-04  +4.07600000E-04  +6.26370000E-04  -2.16360000E-04
   -5.25520000E-04  -9.53300000E-05  +7.12810000E-04  +1.96692000E-03  -2.97240000E-03
   -5.06282000E-03  -2.42595000E-03  -1.43920000E-04  -1.05670000E-04  -1.61490000E-04
   +1.49270000E-04  +5.39400000E-05  +6.25800000E-05  +7.54300000E-05  +7.36000000E-06
   -2.31500000E-05  +2.28400000E-05  +1.86950000E-04  -2.42700000E-05  +8.89000000E-06
   -3.90600000E-05  +8.08800000E-05  +2.08000000E-05  +4.50900000E-05  -3.47700000E-05
   -1.53050000E-04  +1.14910000E-04  -1.07200000E-05  -1.17580000E-04  -5.70900000E-05
   +5.60000000E-06  +4.45100000E-05  -4.86600000E-05  +5.59300000E-05  +1.97730000E-04
   -1.27800000E-04  -8.61000000E-06  +2.87384320E-01  +7.83113000E-02  -4.97160000E-02
   -1.06849740E-01  -2.21412800E-02  +2.48117000E-03  +2.08051300E-02  -1.09959000E-03
   +4.46910000E-04  +2.33209000E-03  -1.14500000E-04  -6.47550000E-04  +1.40510000E-04
   +2.72160000E-04  -1.83990000E-04  -4.86130000E-04  -5.03080000E-04  +1.56307000E-03
   +2.39570000E-04  -4.05343000E-03  -1.69111000E-03  -1.78863000E-03  +1.57300000E-05
   -7.92700000E-05  -5.06500000E-05  +1.64600000E-05  +1.15100000E-05  +5.65000000E-06
   +3.18800000E-05  +2.85200000E-05  +8.75000000E-06  -2.67300000E-05  +7.40200000E-05
   -4.17700000E-05  +8.40000000E-06  -2.20900000E-05  +1.72200000E-05  +7.52000000E-06
   +8.98000000E-06  -1.89500000E-05  -6.24100000E-05  +4.69800000E-05  -7.27000000E-06
   -4.00600000E-05  -6.36000000E-06  +7.74000000E-06  +1.24700000E-05  -3.75900000E-05
   +2.68700000E-05  +8.50300000E-05  -6.52300000E-05  +2.24000000E-06  -5.13401800E-02
   +4.86452000E-02  +2.61833910E-01  -8.53488100E-02  -2.80572730E-01  -5.45574000E-03
   +8.64140000E-04  +2.16399000E-03  -4.89549000E-03  -3.87510000E-04  +1.95033000E-03
   +1.24810000E-04  -2.09000000E-05  -8.13440000E-04  -8.06100000E-05  -1.54260000E-04
   -1.50540000E-04  +5.88690000E-04  -5.38840000E-04  +5.97630000E-04  -1.34836000E-03
   -1.13495000E-03  +1.76239000E-03  +1.15910000E-04  +1.21700000E-05  +2.66400000E-05
   -8.19000000E-05  -4.90700000E-05  -4.73500000E-05  -2.63400000E-05  +4.84000000E-06
   +2.93500000E-05  +1.17300000E-05  -5.15200000E-05  -4.64000000E-06  -2.18000000E-05
   +2.15600000E-05  -1.74000000E-06  +3.57000000E-06  -3.61000000E-06  +5.10000000E-07
   +2.72000000E-06  -9.45000000E-06  +9.34000000E-06  +1.11000000E-05  +2.28000000E-06
   +7.56000000E-06  -7.56000000E-06  +2.08000000E-05  -1.57100000E-05  -1.98000000E-05
   +1.96000000E-05  -7.41000000E-06  -2.51270740E-01  +8.68191400E-02  +2.75697370E-01
   +2.50781000E-03  +2.05497000E-03  -2.06617000E-03  +1.25840000E-03  -3.65411000E-03
   -2.28478000E-03  -2.08996280E-01  +1.77021700E-02  +1.40377630E-01  -1.52365800E-02
   +5.44533000E-03  +1.81351200E-02  -1.67110000E-03  -5.17095000E-03  -2.66520000E-04
   -2.02140000E-04  -2.76220000E-04  -8.91070000E-04  +2.34178000E-03  -1.60940000E-03
   +4.01380000E-04  -1.92550000E-04  +5.51190000E-04  +9.43800000E-04  -2.46050000E-04
   -7.31800000E-05  -1.15590000E-04  -2.68700000E-05  +8.73800000E-05  +6.29400000E-05
   -2.81500000E-05  -3.41540000E-04  +7.81300000E-05  -4.60100000E-05  +3.15800000E-05
   -4.60000000E-06  -1.22300000E-05  -3.70000000E-07  +4.53000000E-06  +7.43300000E-05
   -6.22600000E-05  +1.66900000E-05  +7.33700000E-05  +2.05500000E-05  +2.05500000E-05
   -7.69400000E-05  +1.13180000E-04  -6.78400000E-05  -1.10770000E-04  +8.18600000E-05
   -9.55000000E-06  -1.23000000E-05  +6.06680000E-04  +1.10606000E-03  +2.20618100E-01
   +2.55197000E-03  -4.81340000E-04  +2.56429000E-03  +1.61492100E-02  +2.19497000E-03
   -1.33794200E-02  +1.77869900E-02  -5.10399500E-02  -3.38516300E-02  -1.32709100E-02
   +5.41181000E-03  +1.29182700E-02  -4.61430000E-03  +1.55573000E-03  -2.94015000E-03
   -4.77700000E-04  -1.30966000E-03  -3.36300000E-05  -2.01228000E-03  -3.73700000E-05
   -5.35486000E-03  -5.27790000E-04  +5.23120000E-04  +3.30770000E-04  -5.00100000E-05
   +5.22600000E-05  -4.88100000E-05  +6.84300000E-05  +2.65300000E-05  +6.99600000E-05
   -2.17310000E-04  -2.93910000E-04  +4.09700000E-05  -2.71000000E-06  +3.15200000E-05
   -5.43500000E-05  +1.84400000E-05  -8.05000000E-06  +6.50000000E-07  +2.39200000E-05
   -2.99600000E-05  +1.71200000E-05  +3.24100000E-05  +3.53600000E-05  +3.26900000E-05
   -2.42400000E-05  +4.68600000E-05  -3.22700000E-05  -4.63800000E-05  +2.91400000E-05
   +5.30000000E-07  -1.19968000E-03  -3.97570000E-04  -3.28790000E-04  -1.68478300E-02
   +4.56218000E-02  -1.50924000E-03  +2.85565000E-03  +2.80030000E-04  +2.10615200E-02
   +1.60190000E-04  -9.86484000E-03  +1.40519890E-01  -3.38732000E-02  -1.67672640E-01
   -3.77403000E-03  +2.55430000E-04  +4.93812000E-03  +6.89600000E-05  -2.62951000E-03
   +3.65289000E-03  -1.20115000E-03  -2.20800000E-04  -4.76760000E-04  -1.06650000E-04
   -5.66685000E-03  -8.85920000E-04  -9.47600000E-05  -1.71850000E-04  +2.87130000E-04
   -1.76800000E-05  -6.50600000E-05  -1.32100000E-05  +1.97300000E-05  +5.72500000E-05
   -3.86700000E-05  +1.00120000E-04  +8.49900000E-05  -1.62100000E-05  -5.82000000E-06
   -1.56300000E-05  +3.34000000E-05  -1.88000000E-06  +1.59000000E-05  -1.35300000E-05
   -4.03600000E-05  +3.30000000E-05  -5.05000000E-06  -3.58200000E-05  -2.45800000E-05
   -8.28000000E-06  +6.50000000E-06  -6.01000000E-06  +3.14900000E-05  +5.49300000E-05
   -3.34600000E-05  -2.61000000E-06  -1.01792000E-03  -1.55044000E-03  -5.76450000E-04
   -1.53885830E-01  +3.83095600E-02  +1.72190310E-01  -3.55770000E-04  -1.10284000E-03
   -1.06070000E-03  -2.59138000E-03  -4.42088000E-03  +1.66479000E-03  +2.24474000E-03
   -1.78901400E-02  -2.01295000E-02  -5.54623400E-02  -1.21330400E-02  -2.87133000E-03
   +7.10595000E-03  +1.57969700E-02  +1.68268400E-02  -2.70490000E-03  -1.20223000E-03
   +5.00232000E-03  -1.31650000E-03  -3.97700000E-05  +3.80100000E-05  +3.78980000E-04
   +1.49220000E-03  -1.11097000E-03  +2.89070000E-04  -4.16000000E-05  -9.78500000E-05
   -3.58570000E-04  +3.77200000E-05  +6.27840000E-04  -2.00230000E-04  -5.01600000E-05
   -1.77190000E-04  -5.47900000E-05  -1.25630000E-04  +6.46000000E-05  +1.62700000E-05
   +8.22000000E-06  -6.50400000E-05  -7.97100000E-05  +5.19800000E-05  +1.18500000E-05
   -1.58900000E-05  +3.84400000E-05  +6.26100000E-05  +1.84600000E-05  -7.96000000E-05
   -6.24400000E-05  +1.07420000E-04  -7.09500000E-05  -1.48400000E-05  +1.90670000E-04
   +3.72900000E-05  -1.09410000E-04  +6.98200000E-05  +1.58415000E-03  -1.01750000E-03
   +5.42356900E-02  -3.63840000E-04  -7.82070000E-04  -7.42290000E-04  -4.62732000E-03
   +3.19532000E-03  -2.02407000E-03  +5.49650000E-04  -7.77977000E-03  -1.35435100E-02
   -1.19829700E-02  -1.70920230E-01  -1.48760750E-01  -2.91400000E-04  +1.77094000E-03
   -2.91573000E-03  -1.06628000E-03  +4.05614000E-03  -2.63541000E-03  +6.05800000E-05
   -3.60000000E-04  +9.63410000E-04  +8.08570000E-04  -2.48377000E-03  +1.33424000E-03
   -5.02420000E-04  -2.30790000E-04  +3.18800000E-05  -1.30723000E-03  +2.14240000E-04
   +1.13560000E-04  +3.55660000E-04  +5.21230000E-04  -3.23860000E-04  +1.37480000E-04
   +2.59000000E-06  -7.46800000E-05  -6.45500000E-05  -2.46600000E-05  +8.43300000E-05
   +2.51900000E-05  +1.46800000E-05  -4.56000000E-05  -1.77600000E-05  +8.82000000E-06
   -5.60000000E-05  +5.69300000E-05  -1.45100000E-04  +1.40170000E-04  -5.70000000E-07
   -1.92500000E-05  +3.01900000E-05  +1.86100000E-04  +5.65000000E-06  -6.28100000E-05
   +1.26451000E-03  -1.57629000E-03  +2.21153000E-03  +1.80143200E-02  +1.76497070E-01
   -1.68270000E-04  -2.19990000E-04  -1.23220000E-04  +1.38386000E-03  -2.14728000E-03
   +4.07404000E-03  +1.48327000E-03  -1.18031000E-03  +1.09674000E-03  -2.44292000E-03
   -1.48919190E-01  -2.12478610E-01  -2.43605000E-03  -1.38456500E-02  -1.03343600E-02
   +5.14169000E-03  -2.38177000E-03  +6.03430000E-04  +1.67730000E-04  +1.03160000E-03
   -1.13460000E-04  -2.13760000E-03  +7.16480000E-04  -1.69699000E-03  +6.34530000E-04
   +1.57150000E-04  +3.76500000E-05  -8.28800000E-04  -8.73020000E-04  +4.19330000E-04
   -2.69010000E-04  -1.88570000E-04  +1.75460000E-04  -1.62200000E-05  +4.32400000E-05
   +4.47400000E-05  +2.04600000E-05  +1.49400000E-05  -1.34700000E-05  -1.63000000E-05
   -1.13000000E-06  +1.43100000E-05  -8.79000000E-06  -2.94300000E-05  +1.89000000E-06
   -1.72700000E-05  +1.12090000E-04  -1.89500000E-05  -1.87000000E-06  +1.27100000E-05
   -7.62000000E-06  +5.88300000E-05  +3.02400000E-05  -4.47900000E-05  -1.38183000E-03
   +1.98663000E-03  -8.72360000E-04  +2.40282000E-03  +1.65234430E-01  +2.19922370E-01
   -1.16846000E-03  +1.85170000E-04  +9.76020000E-04  -7.58050000E-04  -5.03184000E-03
   +8.66100000E-05  -1.60410000E-04  -2.32330000E-04  -9.06620000E-04  +2.01199000E-03
   -1.86626000E-03  +4.51340000E-04  +5.04631000E-03  -5.10980000E-04  -1.27470000E-03
   -2.15652590E-01  +2.26327300E-02  +1.39500310E-01  -1.50841900E-02  +4.46551000E-03
   +1.79740100E-02  -8.07150000E-04  +3.71300000E-04  -8.20070000E-04  -4.88100000E-05
   -1.51410000E-04  +1.27120000E-04  -1.14700000E-05  +1.48440000E-04  -8.47100000E-05
   -6.59820000E-04  -6.50520000E-04  -7.72370000E-04  -1.42960000E-04  -5.37100000E-05
   -1.49460000E-04  +1.68540000E-04  -4.21100000E-05  -8.35000000E-06  -1.88640000E-04
   +1.35970000E-04  +5.32800000E-05  -2.06390000E-04  -8.63600000E-05  -1.48700000E-05
   -1.38120000E-04  +6.69600000E-05  +4.52100000E-05  +1.70850000E-04  -1.20840000E-04
   -1.28500000E-05  -3.07990000E-04  -1.14040000E-04  -8.38700000E-05  -1.53330000E-04
   +2.05730000E-04  -1.02190000E-04  +2.09450000E-04  -1.18080000E-04  -1.86800000E-04
   +2.27403150E-01  -6.73380000E-04  +2.16580000E-04  +7.02670000E-04  -4.91430000E-03
   +2.21760000E-03  -3.89601000E-03  -2.73720000E-04  -1.05484000E-03  +2.15280000E-04
   -2.32473000E-03  +1.05230000E-04  -5.63433000E-03  +1.69681400E-02  +2.61163000E-03
   -1.29938500E-02  +2.30081000E-02  -5.59728400E-02  -3.29196100E-02  -1.46702900E-02
   +6.23619000E-03  +1.17110000E-02  +1.43770000E-03  -1.09997000E-03  +1.23549000E-03
   -1.61090000E-04  -5.43070000E-04  -4.69470000E-04  +1.05470000E-04  +1.95100000E-05
   +1.01330000E-04  -3.41710000E-04  +7.51100000E-05  -2.59950000E-04  -1.11110000E-04
   +1.92340000E-04  -2.57740000E-04  +1.36970000E-04  -1.92100000E-04  -2.50500000E-05
   -8.63900000E-05  +2.49600000E-05  +6.75000000E-06  -8.26500000E-05  +1.20130000E-04
   +1.43860000E-04  -7.06000000E-06  -8.37400000E-05  +8.04600000E-05  +1.08300000E-04
   -1.03880000E-04  +8.14000000E-06  -1.91960000E-04  -2.52690000E-04  +9.59600000E-05
   +2.43540000E-04  -2.94530000E-04  +3.14190000E-04  +9.17690000E-04  -5.11300000E-05
   -7.14730000E-04  -2.05132000E-02  +5.03710800E-02  +1.09880000E-04  +1.59090000E-04
   +1.28080000E-04  +3.50900000E-04  -3.72917000E-03  +4.03314000E-03  -1.07740000E-03
   +1.13690000E-04  -2.77350000E-04  +3.16400000E-04  -6.02456000E-03  -8.13680000E-04
   +1.87257600E-02  -1.99228000E-03  -1.00799400E-02  +1.38848500E-01  -3.21054400E-02
   -1.66611110E-01  -3.61890000E-03  -8.22460000E-04  +5.80458000E-03  +3.79380000E-04
   +1.87391000E-03  -1.05685000E-03  -1.17500000E-05  -9.83000000E-06  -8.08100000E-05
   -2.31190000E-04  +5.40800000E-05  -1.19600000E-05  -2.87910000E-04  -3.15140000E-04
   -3.08570000E-04  +9.11100000E-05  +2.51520000E-04  -1.13100000E-04  +4.33000000E-06
   +6.76100000E-05  -2.00300000E-05  -2.68270000E-04  +1.37690000E-04  -1.44000000E-05
   -3.06720000E-04  +1.70500000E-05  +9.72300000E-05  -2.11880000E-04  +2.59090000E-04
   +5.00340000E-04  +2.80750000E-04  -1.88490000E-04  -1.30000000E-06  -1.65360000E-04
   +5.23800000E-05  -5.05000000E-05  -8.76500000E-05  +3.37090000E-04  -2.67340000E-04
   +9.92020000E-04  -1.48300000E-05  -6.78980000E-04  -1.52905850E-01  +3.93237500E-02
   +1.70750260E-01  +1.08312000E-03  +9.78460000E-04  -1.81743000E-03  +6.80271000E-03
   +1.66362600E-02  +1.80785100E-02  -2.79079000E-03  -1.10116000E-03  +4.22418000E-03
   -1.50049000E-03  -1.73310000E-04  +1.37760000E-04  -2.64595000E-03  -4.63840000E-03
   +1.69400000E-03  +3.11572000E-03  -1.73730000E-02  -2.02730400E-02  -5.74657700E-02
   -1.88932600E-02  -7.70259000E-03  +4.91230000E-04  -6.33190000E-04  -9.22300000E-04
   +1.94200000E-05  +7.83400000E-05  -1.02040000E-04  -3.58570000E-04  -1.22820000E-04
   +8.70700000E-05  +1.19260000E-04  -1.00660000E-04  +3.83100000E-05  -7.98000000E-06
   +4.84900000E-05  +1.01000000E-06  +1.39700000E-05  +2.39500000E-05  +1.66000000E-06
   +1.52000000E-06  -7.17000000E-06  +1.70900000E-05  +1.32000000E-06  -3.91800000E-05
   -2.04700000E-05  -1.07600000E-05  +5.83200000E-05  -8.66000000E-06  -2.54500000E-05
   +3.04000000E-05  +5.11000000E-06  +1.69560000E-04  +6.65400000E-05  -3.83050000E-04
   +1.12230000E-04  +8.97670000E-04  +9.52620000E-04  -5.11600000E-05  +1.92490000E-04
   -2.30590000E-04  +8.79800000E-05  +1.79465000E-03  -1.14845000E-03  +5.29028400E-02
   +1.26157000E-03  -1.08201000E-03  +1.79321000E-03  -3.09010000E-03  +9.39080000E-04
   -2.74485000E-03  -7.51660000E-04  +3.22509000E-03  -2.00233000E-03  +1.25450000E-04
   -1.87970000E-04  +8.08760000E-04  -4.75508000E-03  +3.27526000E-03  -2.09487000E-03
   +9.81710000E-04  -7.41908000E-03  -1.25654000E-02  -1.78336100E-02  -1.77174120E-01
   -1.51566840E-01  +1.74200000E-04  -4.93200000E-05  -7.31480000E-04  -5.57900000E-05
   -1.86000000E-05  -1.69900000E-05  -2.47130000E-04  -1.63210000E-04  +8.86900000E-05
   +1.84780000E-04  -1.03330000E-04  -9.05000000E-06  +5.94000000E-06  +2.16700000E-05
   -8.15000000E-06  -1.08400000E-05  -9.87000000E-06  +3.68000000E-06  +4.34900000E-05
   -2.88000000E-05  -2.70000000E-06  +3.25500000E-05  +9.27000000E-06  -4.76000000E-06
   -4.35200000E-05  +4.62000000E-05  +2.00300000E-05  -5.07200000E-05  +2.98500000E-05
   +7.91000000E-06  +1.26290000E-04  -2.22420000E-04  +2.59280000E-04  +6.43000000E-06
   -4.33600000E-05  +2.57800000E-05  +2.18020000E-04  -3.92700000E-04  +2.43750000E-04
   +1.35706000E-03  -1.85261000E-03  +2.49393000E-03  +2.23524500E-02  +1.81365360E-01
   -1.60575000E-03  +1.92538000E-03  -4.92500000E-05  -4.53349000E-03  -1.59283900E-02
   -1.03208000E-02  +4.66141000E-03  -1.74372000E-03  +2.48300000E-04  +3.93100000E-04
   +9.95180000E-04  -5.77200000E-05  +1.31597000E-03  -2.51218000E-03  +4.12528000E-03
   +1.00399000E-03  -2.03980000E-04  +1.94818000E-03  -6.64690000E-03  -1.50701230E-01
   -2.05810680E-01  +3.17760000E-04  -1.19170000E-04  +5.64200000E-05  -2.82400000E-05
   +1.41000000E-05  -6.29200000E-05  -5.68000000E-05  +3.84600000E-05  +2.36500000E-05
   -8.29200000E-05  -7.86400000E-05  +6.37700000E-05  -1.27700000E-05  +3.54800000E-05
   -1.08900000E-05  +1.71700000E-05  +1.63800000E-05  +7.47000000E-06  +2.62000000E-06
   -1.72000000E-05  +2.38400000E-05  +1.60700000E-05  -1.55800000E-05  -5.10000000E-07
   +1.94900000E-05  +1.79500000E-05  -7.10800000E-05  -3.46400000E-05  +3.74600000E-05
   -6.19000000E-06  -3.05610000E-04  +3.04090000E-04  +2.16100000E-05  -1.13820000E-04
   -5.72470000E-04  -6.71050000E-04  -2.05230000E-04  +2.68250000E-04  -2.84320000E-04
   -1.51363000E-03  +2.19341000E-03  -1.23629000E-03  +7.41428000E-03  +1.66009890E-01
   +2.12111880E-01  +5.76500000E-05  +2.51400000E-05  +2.49600000E-05  +8.97000000E-06
   -6.68100000E-05  -1.39000000E-04  +9.94800000E-05  +9.72400000E-05  -3.32400000E-05
   +1.98640000E-04  +1.40900000E-04  +1.35190000E-04  +8.43480000E-04  -1.27494000E-03
   -6.73000000E-05  +2.78810000E-04  +2.14370000E-04  +1.98810000E-04  -1.85610000E-04
   +6.86000000E-06  -2.97400000E-05  -9.33250000E-04  -8.89720000E-04  +7.50720000E-04
   -2.34999420E-01  +1.24553830E-01  +1.10838000E-02  -7.91100000E-05  -2.00630000E-04
   +3.44290000E-04  +5.26330000E-04  -2.95780000E-04  +3.09860000E-04  +1.25480000E-04
   -1.18130000E-04  +2.37420000E-04  -4.11400000E-05  +4.63000000E-05  -4.88800000E-05
   +6.27000000E-05  -9.80200000E-05  +4.86100000E-05  +3.03010000E-04  +1.47620000E-04
   -2.75430000E-04  -1.75460000E-04  +5.75400000E-05  +3.41750000E-04  -2.00190000E-04
   +1.76190000E-04  -5.15700000E-05  -1.16900000E-05  -3.90000000E-06  -2.20000000E-07
   +2.74600000E-05  +1.44800000E-05  +2.47000000E-06  +2.79000000E-05  +2.32500000E-05
   -4.35000000E-06  +2.45700000E-05  -6.27800000E-05  +1.37000000E-05  -3.41000000E-06
   +1.05500000E-05  -1.25000000E-06  +2.52109400E-01  +2.11300000E-04  +1.68150000E-04
   +1.02300000E-05  -2.29670000E-04  -1.06910000E-04  +1.12490000E-04  -1.97050000E-04
   -5.48600000E-05  +6.38300000E-05  -3.11210000E-04  +1.57570000E-04  -5.51000000E-06
   +1.24216000E-03  +6.79760000E-04  -2.13060000E-04  -1.39530000E-04  -3.15460000E-04
   -5.85690000E-04  +1.23540000E-04  +3.09500000E-05  -4.60200000E-05  +1.75289600E-02
   -1.38468500E-02  -9.82010000E-04  +1.22594200E-01  -1.27538250E-01  -8.32824000E-03
   -2.49310000E-04  +3.56250000E-04  -1.29485000E-03  -1.23076000E-03  -1.74315000E-03
   +3.63675000E-03  +1.34918000E-03  -3.47660000E-04  -2.29450000E-04  -5.42900000E-05
   -2.94070000E-04  +2.78760000E-04  -2.36060000E-04  +1.17790000E-04  +4.01100000E-05
   -8.45200000E-05  +1.34770000E-04  -2.41100000E-05  -4.28020000E-04  +1.02540000E-04
   +5.76740000E-04  +2.19100000E-04  -1.32710000E-04  -2.71500000E-05  -3.12200000E-05
   -2.12400000E-05  +2.12400000E-05  +8.40000000E-06  -1.12900000E-05  -2.60000000E-06
   +2.67200000E-05  -2.39000000E-05  +7.61700000E-05  +1.94600000E-05  +1.22520000E-04
   +1.50500000E-04  +9.03000000E-06  -1.04100000E-05  +1.15500000E-05  -1.35275410E-01
   +1.38473930E-01  -1.75480000E-04  -1.01950000E-04  -3.83000000E-06  +1.75600000E-04
   -2.97800000E-05  -2.01720000E-04  +1.65220000E-04  +1.14010000E-04  -1.38400000E-05
   -1.19990000E-04  -1.39000000E-04  +1.88200000E-04  -7.92550000E-04  -4.18860000E-04
   +5.28600000E-04  +4.07150000E-04  +3.05700000E-05  -1.08820000E-04  -4.00470000E-04
   +9.79000000E-06  +9.04600000E-05  -2.12697600E-02  +1.44846000E-02  -5.87720000E-04
   +1.26422300E-02  -9.44948000E-03  -4.72099000E-02  -1.22876000E-03  +8.62620000E-04
   +1.19897000E-03  +1.28473000E-03  +2.54239000E-03  -4.00721000E-03  -1.37757000E-03
   +9.23990000E-04  +3.51310000E-04  +1.69330000E-04  +2.34450000E-04  -3.04660000E-04
   +1.33650000E-04  -6.54300000E-05  -3.21500000E-05  -4.54500000E-05  -7.22400000E-05
   +3.01890000E-04  +7.79540000E-04  +2.16340000E-04  -3.86550000E-04  -6.34700000E-05
   +1.54000000E-06  +5.36200000E-05  +2.11700000E-05  -3.36000000E-06  +1.71000000E-06
   -5.31000000E-06  +6.71000000E-06  +1.22000000E-05  +3.17000000E-05  -1.63000000E-06
   -9.02000000E-05  +2.19500000E-05  +3.11000000E-06  +8.16400000E-05  +1.44400000E-05
   -1.41100000E-05  +2.81000000E-06  -1.32885500E-02  +5.55909000E-03  +5.18999800E-02
   -3.42210000E-04  -2.24380000E-04  -2.25700000E-05  +3.12690000E-04  +1.86280000E-04
   -1.02700000E-05  -3.41000000E-05  -5.88400000E-05  -9.03000000E-05  +5.44270000E-04
   -2.10620000E-04  -1.64720000E-04  +5.14900000E-04  -7.15480000E-04  +5.86370000E-04
   +2.21030000E-04  +3.13490000E-04  +4.62150000E-04  -2.18020000E-04  +3.15000000E-06
   +5.77600000E-05  +1.77800000E-05  +9.42560000E-04  -1.26560000E-04  -2.13079950E-01
   -1.28387520E-01  -8.54708000E-03  +2.74920000E-04  +2.95820000E-04  -3.48710000E-04
   -6.15000000E-05  +1.13200000E-04  +1.68680000E-04  +1.35030000E-04  -1.18500000E-04
   +2.19800000E-05  +4.63000000E-06  -5.03000000E-06  +3.07400000E-05  -1.52560000E-04
   +3.52800000E-05  +3.11000000E-05  +1.15190000E-04  +1.32270000E-04  -2.39040000E-04
   -8.36480000E-04  +1.05277000E-03  +5.37930000E-04  +6.19100000E-05  -6.31000000E-06
   -3.78600000E-05  +4.69800000E-05  +1.49600000E-05  -1.95000000E-05  -3.55100000E-05
   -6.24000000E-06  +4.45000000E-06  -5.06700000E-05  +5.23600000E-05  +1.62100000E-05
   +2.00000000E-06  -2.18800000E-05  -2.56900000E-05  -2.45300000E-05  -6.16000000E-06
   -1.77400000E-05  -1.94334100E-02  -1.70724700E-02  -1.63518000E-03  +2.31681850E-01
   -4.91940000E-04  -3.62530000E-04  -8.70500000E-05  +1.40060000E-04  +4.86060000E-04
   +5.42760000E-04  -6.52230000E-04  -3.04970000E-04  -4.24730000E-04  +3.87870000E-04
   -4.59590000E-04  -3.17320000E-04  +2.66470000E-04  -1.70741000E-03  +3.89351000E-03
   -3.68340000E-04  -1.39230000E-04  +2.30130000E-04  +2.59930000E-04  +1.54860000E-04
   +6.41000000E-06  -1.66606100E-02  -1.26737600E-02  -1.92555000E-03  -1.27059410E-01
   -1.46501950E-01  -6.51953000E-03  -1.94200000E-05  +5.19720000E-04  -1.45279000E-03
   -7.76170000E-04  +6.04330000E-04  -3.42030000E-04  +2.62430000E-04  -1.06160000E-04
   +1.67590000E-04  -1.47860000E-04  +1.06450000E-04  +1.99000000E-06  +3.44300000E-05
   -5.93500000E-05  +3.36700000E-05  +2.38940000E-04  +2.20310000E-04  -4.19140000E-04
   +2.89450000E-04  -3.61860000E-04  +5.81700000E-04  -1.65910000E-04  +1.81490000E-04
   -7.22100000E-05  +6.64600000E-05  +2.37700000E-05  -2.96200000E-05  -1.11250000E-04
   -1.30000000E-06  -3.40800000E-05  +3.80000000E-05  -6.36800000E-05  +1.52670000E-04
   -3.11800000E-05  +1.75100000E-04  -9.59700000E-05  -1.54500000E-05  -4.02700000E-05
   -1.58600000E-05  +1.44038800E-02  +1.22231100E-02  +9.01260000E-04  +1.40005130E-01
   +1.58004450E-01  +4.26580000E-04  +3.21980000E-04  +1.96300000E-05  -3.41600000E-04
   -9.06800000E-05  +7.88900000E-05  +1.08010000E-04  -2.36780000E-04  +2.70740000E-04
   +5.87720000E-04  +5.24790000E-04  +1.41160000E-04  -1.03676000E-03  +2.44276000E-03
   -3.47986000E-03  +3.48000000E-05  -3.43730000E-04  -5.34400000E-05  +5.75660000E-04
   -7.17700000E-05  +8.90100000E-05  +2.05811900E-02  +1.48149300E-02  -1.67550000E-04
   -8.81897000E-03  -7.62622000E-03  -4.88078300E-02  +1.12226000E-03  +7.43440000E-04
   +1.20762000E-03  +2.06530000E-04  -5.69350000E-04  +5.43550000E-04  +2.07100000E-05
   -5.41400000E-05  -2.31870000E-04  +6.42200000E-05  -5.05100000E-05  -9.26000000E-06
   -1.42350000E-04  +1.36600000E-05  +7.53800000E-05  -2.53500000E-05  +6.58800000E-05
   -9.89400000E-05  -4.01950000E-04  -3.53700000E-04  +5.28350000E-04  +4.26300000E-05
   -8.36000000E-06  -4.07400000E-05  -4.41500000E-05  +9.94000000E-06  +2.61800000E-05
   +6.68900000E-05  +2.93000000E-05  -9.52000000E-06  -2.08800000E-05  +1.28920000E-04
   -1.42180000E-04  -2.37560000E-04  +3.86510000E-04  -3.29700000E-05  +3.32100000E-05
   +2.14200000E-05  +1.87300000E-05  +1.67069000E-03  +1.32426000E-03  -9.38950000E-04
   +8.81447000E-03  +5.19759000E-03  +5.11406300E-02  +6.23300000E-05  +4.85800000E-05
   -6.10000000E-07  -1.16600000E-05  -1.27160000E-04  -1.13540000E-04  +1.57320000E-04
   +9.02800000E-05  +7.35200000E-05  -2.31390000E-04  -7.67200000E-05  +7.51100000E-05
   +1.03290000E-04  +6.33080000E-04  +5.70360000E-04  -9.60500000E-05  -1.64140000E-04
   +3.02000000E-05  -2.72000000E-04  -4.63800000E-05  -5.91900000E-05  -1.87640000E-03
   -2.56300000E-04  -3.44240000E-04  -4.70222800E-02  -1.75090000E-04  +7.32570000E-04
   -7.58100000E-05  +1.59610000E-04  -1.07870000E-04  +2.93200000E-04  -3.87490000E-04
   -4.86180000E-04  -6.69800000E-05  +4.95600000E-05  -4.37900000E-05  +7.05100000E-05
   -7.58200000E-05  +9.67000000E-06  -5.55000000E-06  +5.20700000E-05  -3.50400000E-05
   -1.46030000E-04  -9.57200000E-05  +2.58330000E-04  -1.74660000E-04  +4.77690000E-04
   -5.47320000E-04  +1.09510000E-04  -1.13730000E-04  +5.38500000E-05  -1.07600000E-05
   -1.22600000E-05  +8.69000000E-06  +4.21000000E-06  +7.85000000E-06  -7.93000000E-06
   +3.44600000E-05  +1.32100000E-05  -6.32100000E-05  +2.03930000E-04  -2.82480000E-04
   +9.62400000E-05  +1.41100000E-05  -2.04900000E-05  +1.61800000E-05  +5.67070000E-04
   +1.27274700E-02  +2.43203900E-02  +6.98690000E-04  -1.17193000E-02  -2.29601000E-02
   +4.79838400E-02  +1.49880000E-04  +8.43300000E-05  +1.27800000E-05  +7.47000000E-06
   -9.44400000E-05  -1.82000000E-04  +1.55660000E-04  +1.39350000E-04  +1.36950000E-04
   -2.18580000E-04  -1.61000000E-06  -6.09300000E-05  +5.26860000E-04  +9.74300000E-04
   +6.22200000E-05  -4.55030000E-04  -1.71930000E-04  +6.71790000E-04  -1.41600000E-05
   -1.62150000E-04  -1.34740000E-04  -5.50740000E-04  +1.02617700E-02  +1.83977800E-02
   -3.87610000E-04  -1.12074870E-01  -1.16232050E-01  -8.80000000E-07  -2.42106000E-03
   +2.88494000E-03  -2.88300000E-05  +9.17610000E-04  -3.76080000E-04  -2.82960000E-04
   -9.23100000E-05  +2.16200000E-05  -8.20600000E-05  +7.17700000E-05  -1.33400000E-05
   +1.30120000E-04  -2.24200000E-05  -7.41500000E-05  +2.17600000E-05  -8.94600000E-05
   +9.78600000E-05  +7.53340000E-04  +1.23040000E-04  -1.40420000E-04  -3.76900000E-05
   +8.59000000E-06  +3.36900000E-05  -1.50900000E-05  -3.72000000E-06  +1.80000000E-06
   +1.71800000E-05  -5.23000000E-06  +2.82000000E-06  +3.33100000E-05  -1.41800000E-05
   +5.75000000E-06  -9.63900000E-05  -9.82920000E-04  +1.04980000E-04  -4.39000000E-06
   -3.10000000E-06  +1.99400000E-05  -1.32044000E-03  -8.64225000E-03  -1.46973400E-02
   +1.88333000E-03  -9.27596000E-03  -1.61112600E-02  -6.12790000E-04  +1.20860910E-01
   -3.45600000E-05  -1.30800000E-05  -8.84000000E-06  -2.27660000E-04  +3.16720000E-04
   +4.30000000E-04  -4.73790000E-04  -3.72180000E-04  -1.34740000E-04  +8.50340000E-04
   +9.09400000E-05  -2.33370000E-04  -1.45988000E-03  -7.88680000E-04  +6.52300000E-04
   +1.24030000E-04  -6.94620000E-04  -1.00880000E-04  +5.68140000E-04  +2.73910000E-04
   +2.22740000E-04  +2.65010000E-04  -1.30292700E-02  -2.08536500E-02  +1.08385000E-03
   -1.13841140E-01  -2.51928880E-01  +2.31320000E-04  +4.91609000E-03  -3.59593000E-03
   +9.88250000E-04  -1.09872000E-03  +7.55720000E-04  -1.87500000E-05  +4.80580000E-04
   -2.73400000E-05  +1.88330000E-04  -9.66300000E-05  -7.08000000E-06  -2.58500000E-05
   -1.85100000E-05  +3.25400000E-05  -1.75140000E-04  -9.07700000E-05  +3.36270000E-04
   +2.36580000E-04  +2.49550000E-04  +2.45530000E-04  +5.46400000E-05  -6.25500000E-05
   +3.55400000E-05  +6.66000000E-06  +1.19400000E-05  -6.02000000E-06  -7.02000000E-06
   +1.56300000E-05  -1.93700000E-05  -1.46280000E-04  +7.58000000E-06  +8.03400000E-05
   -2.14130000E-04  +4.71870000E-04  +2.26840000E-04  +4.32200000E-05  +3.08000000E-06
   +3.52000000E-06  -1.92970000E-04  +1.17600000E-05  -4.74390000E-04  +1.54640000E-04
   +4.89560000E-04  +2.15360000E-04  -1.06914000E-03  +1.23826860E-01  +2.74971140E-01
   +1.17670000E-04  +1.09470000E-04  +4.09500000E-05  -8.82900000E-05  -1.21500000E-05
   +4.24800000E-05  -1.07350000E-04  +1.55000000E-05  +2.15830000E-04  -4.51100000E-05
   -3.24230000E-04  -5.92390000E-04  +3.08390000E-04  +5.06930000E-04  -3.31280000E-04
   -6.46000000E-05  -4.58600000E-05  -4.65400000E-05  +1.20810000E-04  +7.94600000E-05
   +2.29000000E-05  -1.81382000E-03  +1.03176000E-03  -1.39744000E-03  -6.50600000E-05
   -2.51110000E-04  -4.63660000E-04  -4.78008900E-02  -7.32281000E-03  +1.05968500E-02
   +7.25000000E-05  -5.93230000E-04  +5.84480000E-04  -2.05170000E-04  +1.95800000E-04
   -1.73500000E-05  -1.83130000E-04  +5.94300000E-05  -8.69400000E-05  -1.13010000E-04
   +1.00700000E-04  +1.48200000E-05  -1.34300000E-05  -3.28000000E-05  +4.55300000E-05
   -6.72200000E-05  +1.33090000E-04  +5.86400000E-05  +1.17990000E-04  -6.62100000E-05
   -3.48400000E-05  -3.11300000E-05  -1.88600000E-05  -5.28000000E-06  -1.13000000E-06
   +6.77000000E-06  -2.66600000E-05  -1.15238000E-03  +2.65550000E-04  -4.36370000E-04
   -1.26700000E-05  +4.42900000E-05  +4.56100000E-05  +1.04300000E-05  +5.31000000E-06
   +1.25000000E-05  +2.71310000E-04  -2.97970000E-04  +2.64680000E-04  +1.86780000E-04
   +3.14220000E-04  -1.99110000E-04  +6.58940000E-04  +1.12150000E-04  -1.15390000E-04
   +4.83517100E-02  +7.67100000E-05  +1.87500000E-05  -2.90600000E-05  -1.22760000E-04
   -2.64000000E-05  +1.45040000E-04  +1.65200000E-05  -1.34150000E-04  -1.78900000E-04
   -6.59350000E-04  +3.16830000E-04  +1.66380000E-04  +1.20600000E-05  +7.79440000E-04
   +4.26750000E-04  +2.33500000E-04  -7.48700000E-05  -6.13000000E-06  +1.20290000E-04
   +4.89200000E-05  -3.80700000E-05  +1.15024000E-03  +1.09070300E-02  -1.44103000E-02
   -5.48100000E-05  -1.58957000E-03  -2.57536000E-03  -7.13358000E-03  -1.39503950E-01
   +1.28158930E-01  -2.76300000E-04  +7.35690000E-04  +3.89510000E-04  +5.43800000E-04
   -5.86560000E-04  -8.61620000E-04  +2.38000000E-06  -1.24650000E-04  +9.13100000E-05
   +9.46000000E-06  -1.36700000E-05  +7.00300000E-05  +4.35600000E-05  -5.96700000E-05
   -5.19800000E-05  +1.07530000E-04  +5.56500000E-05  -9.01000000E-06  -1.24410000E-04
   +7.07500000E-05  -6.00000000E-07  -1.27000000E-06  +8.11000000E-06  +1.10200000E-05
   -8.30000000E-06  +3.29700000E-05  -1.65000000E-05  -1.35820000E-04  -1.66460000E-04
   -2.21360000E-04  -4.49000000E-06  +1.10000000E-05  -3.30400000E-05  +1.24600000E-05
   +1.65600000E-05  -6.65000000E-06  -2.47890000E-04  +1.86300000E-05  -1.71500000E-04
   +2.51120000E-04  +2.41800000E-05  -1.60320000E-04  -4.07400000E-05  +7.97770000E-04
   -8.69230000E-04  +8.22104000E-03  +1.50739270E-01  +6.60000000E-06  +1.32600000E-05
   +5.66000000E-06  -1.25030000E-04  +1.80270000E-04  +2.15720000E-04  -3.09670000E-04
   -2.00240000E-04  +1.59360000E-04  +2.53470000E-04  -2.24080000E-04  +6.66700000E-05
   +9.65010000E-04  +1.02402000E-03  +1.05556000E-03  -5.59700000E-05  -5.10420000E-04
   -6.86100000E-05  +2.52830000E-04  +1.54790000E-04  -1.03400000E-05  +1.42364000E-03
   +1.67630000E-02  -2.05754300E-02  -5.49200000E-05  -4.69948000E-03  -4.42835000E-03
   +1.06910200E-02  +1.26077790E-01  -2.23963370E-01  -1.30302000E-03  +8.40990000E-04
   +4.97100000E-04  +3.97660000E-04  +8.59870000E-04  -3.06160000E-04  +3.23940000E-04
   -3.95490000E-04  +3.67760000E-04  +5.25200000E-05  -1.98510000E-04  +2.48800000E-05
   -2.82400000E-05  +1.78980000E-04  -9.59000000E-06  +5.08980000E-04  -1.15950000E-04
   -1.87590000E-04  -2.81830000E-04  +1.08100000E-04  +8.93500000E-05  -1.35500000E-05
   -5.53000000E-06  -9.06000000E-06  -2.18300000E-05  -2.08600000E-05  -1.26300000E-05
   -5.36470000E-04  +2.19030000E-04  +3.15900000E-05  -2.94400000E-05  +1.02820000E-04
   +3.88300000E-05  -2.30400000E-05  +2.62000000E-05  -3.07600000E-05  -4.23000000E-05
   -8.85400000E-05  +2.62120000E-04  +7.06900000E-05  -1.17560000E-04  +3.50150000E-04
   -5.50900000E-05  +1.13379000E-03  -1.57534000E-03  -1.14001300E-02  -1.37603440E-01
   +2.44616800E-01  -2.03650000E-04  -1.61440000E-04  -5.57400000E-05  +1.29630000E-04
   +6.91400000E-05  -3.19500000E-05  +1.85710000E-04  -1.23350000E-04  -2.34090000E-04
   -2.24110000E-04  +6.70500000E-05  +3.82550000E-04  +7.04010000E-04  +8.31600000E-05
   +2.21000000E-05  +3.73600000E-05  +1.34060000E-04  +2.96020000E-04  -8.76800000E-05
   -8.13000000E-05  -1.01900000E-04  -1.83413000E-03  +9.53300000E-05  +8.83190000E-04
   -8.13600000E-05  +1.57100000E-04  +3.69470000E-04  -2.50356580E-01  -1.16940100E-01
   -4.42482000E-03  +7.91850000E-04  +1.33916000E-03  +1.49450000E-04  +1.72080000E-04
   -3.41040000E-04  +2.16280000E-04  -1.30250000E-04  +1.77200000E-05  -3.06700000E-05
   -2.26200000E-05  +5.01600000E-05  -5.05200000E-05  -5.37400000E-05  -9.74400000E-05
   -1.17370000E-04  +3.47480000E-04  -1.31310000E-04  +1.56300000E-04  +8.08000000E-05
   -3.40800000E-05  +4.29000000E-06  +4.82000000E-05  +2.56800000E-05  +2.05000000E-06
   -2.45900000E-05  -8.23000000E-06  +2.23200000E-05  +2.96270000E-04  -4.58400000E-05
   -4.63420000E-04  +8.29500000E-05  -5.47900000E-05  -6.36700000E-05  -2.80100000E-05
   -1.69000000E-06  -1.73500000E-05  +4.23000000E-06  -1.24980000E-04  +4.82500000E-05
   +3.23090000E-04  +2.92020000E-04  -4.75290000E-04  +2.91340000E-04  +2.30580000E-04
   -1.62200000E-05  -4.21550000E-04  +6.75480000E-04  -9.81800000E-05  +2.69170400E-01
   -2.47530000E-04  -1.59530000E-04  +1.31900000E-05  +2.87910000E-04  +8.96600000E-05
   -6.95200000E-05  -8.39000000E-05  +1.43300000E-04  +4.60200000E-05  +4.79720000E-04
   +1.33510000E-04  -4.44690000E-04  +1.05179000E-03  -1.14993000E-03  -3.51902000E-03
   -1.17291000E-03  -9.49500000E-05  +1.60890000E-04  -5.21500000E-05  -3.11550000E-04
   -1.59410000E-04  -1.54623700E-02  -1.11313300E-02  -6.05980000E-04  +4.22930000E-04
   +2.66170000E-04  +1.12505000E-03  -1.15419800E-01  -1.12862650E-01  -1.20973000E-03
   -1.48095000E-03  +1.99050000E-04  +3.46140000E-04  -2.21100000E-05  -1.76290000E-04
   +4.40290000E-04  +4.38400000E-05  +2.02800000E-05  -7.90000000E-06  +1.51730000E-04
   -8.38000000E-05  -1.71000000E-06  +8.23400000E-05  -1.01040000E-04  -1.03190000E-04
   +5.77260000E-04  +3.28840000E-04  +7.68000000E-06  -1.17300000E-04  +1.20090000E-04
   -7.43000000E-06  +2.60900000E-05  +1.26900000E-05  -1.42300000E-05  -4.81600000E-05
   -4.29000000E-06  -4.70000000E-06  +1.26860000E-04  -1.30530000E-04  +3.20000000E-04
   +9.37000000E-06  +3.37900000E-05  -7.52800000E-05  -7.01100000E-05  -1.00240000E-04
   +2.10700000E-05  +1.21400000E-04  +4.82100000E-05  -1.30200000E-05  +9.91000000E-05
   +5.84530000E-04  -3.74900000E-05  +2.30880000E-04  -3.62300000E-05  +5.37400000E-05
   -1.60947600E-02  -9.19693000E-03  -1.23797000E-03  +1.27373240E-01  +1.21481150E-01
   -1.37080000E-04  -5.26900000E-05  +2.07100000E-05  +1.20200000E-04  +1.49820000E-04
   +3.02700000E-05  -2.21290000E-04  -3.96300000E-05  +2.12770000E-04  +9.49710000E-04
   -2.32710000E-04  -4.70470000E-04  +1.30560000E-03  -2.30426000E-03  -4.66250000E-03
   -1.58221000E-03  -8.65590000E-04  +2.78290000E-04  +1.41510000E-04  -2.57530000E-04
   -3.02770000E-04  -2.40461900E-02  -1.42840300E-02  -2.28660000E-03  -1.20984000E-03
   -8.50510000E-04  +1.23773000E-03  -2.50101000E-03  -2.60570000E-04  -4.64289000E-02
   -1.07690000E-03  +3.36730000E-04  +7.68100000E-04  +3.08560000E-04  -5.82700000E-05
   -9.62700000E-05  -2.68760000E-04  -1.18300000E-05  +5.42400000E-05  +8.57700000E-05
   -3.56800000E-05  -2.96100000E-05  +1.74130000E-04  -6.47000000E-05  -9.97200000E-05
   +8.49400000E-05  +3.39110000E-04  +2.00630000E-04  -1.32390000E-04  +9.89900000E-05
   -1.49600000E-05  +2.77000000E-06  -5.44000000E-06  -9.51000000E-06  -2.60700000E-05
   -3.12800000E-05  +6.68000000E-06  -1.06530000E-04  +4.66850000E-04  +2.59580000E-04
   +3.19000000E-06  +3.17000000E-05  -7.84000000E-06  -1.24360000E-04  -6.13000000E-05
   -2.68700000E-05  +6.62700000E-05  +1.93300000E-05  -6.42400000E-05  +3.48480000E-04
   +4.24080000E-04  -7.04400000E-04  +3.07540000E-04  +1.30550000E-04  +2.86400000E-04
   +2.35880200E-02  +1.19409400E-02  +1.26964000E-03  +3.73518000E-03  +4.95082000E-03
   +5.15622800E-02  +9.96400000E-05  +4.12500000E-05  -1.97400000E-05  -1.83270000E-04
   -1.41400000E-05  +3.38000000E-06  +1.31580000E-04  -1.20260000E-04  -2.10500000E-04
   -9.73310000E-04  -1.03914000E-03  +3.74210000E-04  -7.92000000E-06  -1.03270000E-04
   +2.54580000E-04  +1.02620000E-04  +9.63000000E-05  -6.70000000E-07  +5.80400000E-05
   +2.18600000E-05  -4.20000000E-06  +9.05640000E-04  -1.65436000E-03  -2.82340000E-04
   +2.75390000E-04  -2.63070000E-04  -3.37670000E-04  -1.96055670E-01  +1.32296270E-01
   +5.35113000E-03  +3.48560000E-04  +2.35010000E-04  +5.37870000E-04  +1.26270000E-04
   -2.04410000E-04  +3.04330000E-04  -9.90900000E-05  -3.12000000E-06  -5.29000000E-06
   +2.10210000E-04  -1.12880000E-04  -2.47100000E-05  +1.41870000E-04  -5.44300000E-05
   -3.38400000E-05  +5.78770000E-04  +3.17510000E-04  -1.44810000E-04  -2.17540000E-04
   +1.55250000E-04  +7.78000000E-06  -9.33000000E-06  +4.01000000E-06  +5.44000000E-06
   +3.09300000E-05  -1.06700000E-05  +2.32000000E-05  -9.38950000E-04  -1.65465000E-03
   -1.91340000E-04  -1.11700000E-05  -1.54000000E-06  -7.18000000E-06  +1.24300000E-05
   +1.85000000E-05  -1.87000000E-06  +3.13070000E-04  -1.26410000E-04  +3.10370000E-04
   -2.02940000E-04  +1.23570000E-04  +5.42300000E-05  +1.62050000E-04  -2.60940000E-04
   +3.87600000E-05  +1.61311000E-03  -2.82001000E-03  -1.74090000E-04  -1.93125400E-02
   +1.92621700E-02  +2.68970000E-04  +2.13052030E-01  +1.08010000E-04  +1.29870000E-04
   +6.61400000E-05  -5.54500000E-05  +6.67000000E-06  +1.15580000E-04  -3.48740000E-04
   +1.80440000E-04  +3.38270000E-04  +1.01910000E-04  -4.32500000E-04  -8.19500000E-04
   +6.33750000E-04  +5.52340000E-04  +4.52080000E-04  -2.74270000E-04  -1.05180000E-04
   -1.63330000E-04  +1.63300000E-04  +1.44800000E-04  +4.92200000E-05  +1.34888600E-02
   -1.21149100E-02  +3.47490000E-04  -7.87700000E-05  +5.02440000E-04  +1.49797000E-03
   +1.31173600E-01  -1.64543530E-01  -4.73006000E-03  -4.09570000E-04  -5.85060000E-04
   -4.04782000E-03  +2.85150000E-04  -6.18000000E-04  +9.82500000E-05  -3.88310000E-04
   +1.76670000E-04  +2.69300000E-05  -9.12500000E-05  +2.34870000E-04  -1.75280000E-04
   -2.51900000E-05  +2.56170000E-04  +1.25850000E-04  +3.45000000E-06  -5.60180000E-04
   +5.63530000E-04  +3.79070000E-04  -2.54360000E-04  +5.17000000E-06  -3.80300000E-05
   -3.79000000E-05  -5.94000000E-06  -3.58000000E-06  -2.76300000E-05  -2.04100000E-05
   -1.23685000E-03  -1.01130000E-03  +6.00930000E-04  +2.71900000E-05  +6.36700000E-05
   +1.30860000E-04  +6.26000000E-06  -1.01800000E-05  +1.83100000E-05  -2.32330000E-04
   +6.48670000E-04  -2.68990000E-04  -1.18880000E-04  -2.50300000E-05  -1.20260000E-04
   -3.05380000E-04  +1.57200000E-05  +9.69900000E-05  +1.35134600E-02  -1.17971200E-02
   -1.59334000E-03  -1.25054900E-02  +1.19874200E-02  +5.32090000E-04  -1.44101590E-01
   +1.77126910E-01  +5.88800000E-05  +2.08100000E-05  -2.36100000E-05  -1.46890000E-04
   +3.52500000E-05  +1.61240000E-04  -1.16360000E-04  -1.27850000E-04  -1.29530000E-04
   -3.70850000E-04  +2.87680000E-04  +4.28540000E-04  +2.32410000E-04  +6.72880000E-04
   +7.31730000E-04  -1.67100000E-05  +2.02400000E-05  -2.56480000E-04  +1.39020000E-04
   +7.75400000E-05  -1.32000000E-05  +2.14472900E-02  -1.80445300E-02  -2.02980000E-03
   +1.11628000E-03  -9.64120000E-04  +1.26484000E-03  +4.94008000E-03  -3.45802000E-03
   -4.76294300E-02  -1.24486000E-03  -1.62611000E-03  -5.13293000E-03  +2.80540000E-04
   +1.66200000E-04  +2.12550000E-04  +1.16270000E-04  -6.19300000E-05  +2.91460000E-04
   +1.43400000E-05  -2.04800000E-05  -1.05090000E-04  -1.57300000E-05  +6.88720000E-04
   +2.25760000E-04  +6.53360000E-04  -8.93850000E-04  +3.54780000E-04  +5.79200000E-05
   -1.17220000E-04  +6.68800000E-05  -3.63000000E-06  -1.29000000E-06  +9.74000000E-06
   +5.25000000E-06  -8.22000000E-06  +9.35000000E-06  +4.14000000E-06  -4.06600000E-05
   +1.86260000E-04  +4.66600000E-05  +8.00000000E-08  +4.84000000E-05  +1.91400000E-05
   -1.39900000E-05  +9.33000000E-06  -5.12370000E-04  +2.30260000E-04  -7.39870000E-04
   +5.18500000E-05  +1.18200000E-04  -5.33600000E-05  -2.05960000E-04  +1.27920000E-04
   +3.94620000E-04  -2.04830200E-02  +1.63064600E-02  +1.70486000E-03  -7.07700000E-05
   +2.94320000E-04  -9.82560000E-04  -6.03998000E-03  +7.00961000E-03  +5.11849200E-02
   +1.31910000E-04  +8.04500000E-05  -2.54000000E-06  -2.28690000E-04  -4.61800000E-05
   +1.34260000E-04  -1.26550000E-04  -1.56040000E-04  -5.32000000E-06  -6.29600000E-05
   +1.48030000E-04  -1.15070000E-04  -6.30250000E-04  +6.93810000E-04  -7.12040000E-04
   -2.55480000E-04  +1.86430000E-04  -2.37860000E-04  +2.41850000E-04  +4.63100000E-05
   -1.50800000E-05  -5.82340000E-04  -1.72600000E-05  -4.11610000E-04  +1.54200000E-05
   -1.71930000E-04  -8.87000000E-05  -1.68090000E-04  +2.79360000E-04  +1.96470000E-04
   +3.80389000E-03  +2.93610000E-04  -1.12874000E-03  -2.22304430E-01  -1.94320300E-02
   +1.46596980E-01  -1.27924400E-02  -4.48717000E-03  +1.61333400E-02  -1.47536000E-03
   +3.95384000E-03  -4.87740000E-04  +1.02040000E-04  -1.66040000E-04  -6.40040000E-04
   +1.21091000E-03  +1.25670000E-03  -6.99700000E-05  -9.06870000E-04  -2.59180000E-04
   +9.35850000E-04  -2.27100000E-05  -9.93000000E-06  +4.61000000E-06  +9.17000000E-06
   +5.30000000E-07  -9.54000000E-06  +5.68300000E-05  +2.64900000E-05  +6.95000000E-06
   +8.86000000E-06  -2.08300000E-05  +3.94800000E-05  -1.00000000E-06  +2.06000000E-06
   +4.02000000E-06  +6.83000000E-05  -3.08600000E-05  +1.05900000E-05  -1.44500000E-05
   -2.56000000E-05  +4.34300000E-05  -1.06100000E-05  -6.60000000E-07  -4.85100000E-05
   +2.74090000E-04  +2.41250000E-04  -2.40560000E-04  +1.38600000E-05  -2.54700000E-05
   +1.38000000E-05  -8.89000000E-06  +9.73400000E-05  -2.43420000E-04  +2.33409330E-01
   -1.80730000E-04  -1.39430000E-04  -6.41000000E-06  +2.02810000E-04  -1.35000000E-05
   -1.59190000E-04  +1.27030000E-04  +6.14500000E-05  -1.06400000E-05  +8.41700000E-05
   -6.19000000E-06  +2.93000000E-05  +3.57700000E-04  -7.32900000E-05  +3.79600000E-05
   +1.72770000E-04  +3.09740000E-04  +2.99410000E-04  -2.78300000E-04  -2.30230000E-04
   +7.79800000E-05  -1.16089000E-03  -1.21310000E-04  -4.81570000E-04  -5.48100000E-05
   -3.04800000E-05  -1.24200000E-04  +5.94500000E-05  -6.26170000E-04  +4.24540000E-04
   -1.78338500E-02  +1.97874000E-03  +1.27679700E-02  -1.96782400E-02  -5.14409800E-02
   +3.68659100E-02  +1.49266400E-02  +6.27133000E-03  -1.23904200E-02  +3.68316000E-03
   -2.91520000E-04  +2.59237000E-03  +2.94470000E-04  -8.64260000E-04  -4.41720000E-04
   +1.70003000E-03  -2.29788000E-03  +4.05466000E-03  +1.19409000E-03  +5.04150000E-04
   -5.97870000E-04  +8.86000000E-06  +2.17100000E-05  -1.81200000E-05  -2.39000000E-05
   +1.25600000E-05  +3.50000000E-07  +8.38400000E-05  -8.09600000E-05  -2.38200000E-05
   +1.36000000E-06  +1.11700000E-05  -9.22700000E-05  -2.40000000E-05  -5.44000000E-06
   -2.03400000E-05  +5.05600000E-05  -1.40000000E-07  -2.41600000E-05  -1.34000000E-06
   +6.95800000E-05  +1.17000000E-05  -3.79700000E-05  +2.56100000E-05  -1.20500000E-04
   +3.26880000E-04  -1.30184000E-03  -5.92510000E-04  +5.46200000E-05  +1.28960000E-04
   -7.21000000E-06  +3.46600000E-05  +2.11210000E-04  -3.13590000E-04  +1.81853000E-02
   +4.87629600E-02  +3.17310000E-04  +1.89330000E-04  +3.07100000E-05  -3.11950000E-04
   -1.28480000E-04  -4.68200000E-05  -3.69300000E-05  +6.94000000E-05  +9.49600000E-05
   -3.40710000E-04  -1.87070000E-04  +2.62920000E-04  -2.68990000E-04  +4.00100000E-04
   +1.66900000E-05  +2.92300000E-05  -3.30110000E-04  -2.18470000E-04  +3.85600000E-05
   -1.09700000E-04  -3.86500000E-05  +5.55600000E-04  -1.16319000E-03  -7.37040000E-04
   -2.07100000E-04  -6.54600000E-05  -1.70200000E-05  -4.62400000E-05  -5.54400000E-05
   -9.37400000E-05  +1.69934200E-02  +1.17839000E-03  -9.66842000E-03  +1.46198790E-01
   +3.62635900E-02  -1.57829430E-01  -2.98679000E-03  +8.31870000E-04  +5.32773000E-03
   -3.46030000E-04  +2.10013000E-03  +2.57250000E-03  -5.51260000E-04  -2.32260000E-04
   -3.17650000E-04  -7.00070000E-04  +4.50340000E-03  -8.16690000E-04  +3.56000000E-05
   +2.07060000E-04  +3.42040000E-04  -4.96000000E-05  -1.16000000E-05  +1.56500000E-05
   +2.45300000E-05  -4.50000000E-07  -1.19000000E-05  +1.21800000E-05  -1.42600000E-05
   -3.09000000E-05  +4.27400000E-05  +7.81800000E-05  +1.25600000E-05  -1.93000000E-06
   +2.01500000E-05  -8.25000000E-06  -6.46300000E-05  +6.68900000E-05  +4.01000000E-06
   -2.19400000E-05  -1.24560000E-04  +3.39900000E-05  +5.71500000E-05  +1.87600000E-05
   +2.22100000E-05  +1.61360000E-04  -4.59210000E-04  +3.04310000E-04  -1.82100000E-05
   -1.70650000E-04  +4.20200000E-05  -3.82000000E-05  +8.01200000E-05  +4.81000000E-05
   -1.58518120E-01  -4.10386200E-02  +1.61976580E-01  -4.82500000E-05  -4.87000000E-05
   +3.65000000E-06  +2.23500000E-05  +2.98300000E-05  +7.61000000E-06  -2.11200000E-05
   -3.99600000E-05  +4.39000000E-06  -2.28000000E-06  -2.30500000E-05  -3.80000000E-06
   +1.54760000E-04  +4.50400000E-05  +1.07900000E-05  +1.66000000E-06  -1.49800000E-05
   +1.27300000E-05  -1.40200000E-05  -2.89500000E-05  +1.59400000E-05  +5.90300000E-04
   +7.59950000E-04  -8.75440000E-04  -3.70520000E-04  +1.50940000E-04  +1.11250000E-04
   +1.95000000E-05  -6.72300000E-05  -1.09570000E-04  -2.73912000E-03  +4.24760000E-03
   +1.40853000E-03  +4.53595000E-03  +1.60916300E-02  -1.91704300E-02  -5.78041400E-02
   +1.54239800E-02  -2.76533000E-03  +6.63487000E-03  -1.77248000E-02  +1.87454600E-02
   -1.86238000E-03  +2.84443000E-03  +3.76332000E-03  -1.14022000E-03  -5.17000000E-05
   +3.59170000E-04  +1.01538000E-03  -1.08529000E-03  -2.34787000E-03  -3.69000000E-06
   +9.85000000E-06  -1.00800000E-05  -1.51600000E-05  +3.54000000E-06  -3.14000000E-06
   +4.79000000E-06  +1.31200000E-05  -6.40000000E-06  +5.43000000E-06  +2.72300000E-05
   +5.55000000E-06  -1.28500000E-05  +8.00000000E-07  -1.35300000E-05  -2.22500000E-05
   +9.54000000E-05  -1.14990000E-04  +1.29300000E-05  -1.08000000E-05  +1.61700000E-05
   +9.95000000E-06  -1.24000000E-05  -1.66200000E-05  +1.17800000E-05  -2.70000000E-07
   +5.25400000E-05  -4.27000000E-06  -1.14300000E-05  +1.25700000E-05  -2.36700000E-05
   +1.33300000E-05  +3.83700000E-05  +2.07970000E-04  -1.50304000E-03  -8.13000000E-04
   +5.08442000E-02  +5.13200000E-05  +3.08700000E-05  -1.60000000E-07  -4.13200000E-05
   -2.37900000E-05  +9.00000000E-08  +1.79000000E-05  +1.65200000E-05  -6.38000000E-06
   +6.37000000E-06  +3.17300000E-05  -3.01000000E-06  -1.67280000E-04  -1.04150000E-04
   -2.55400000E-05  -1.26000000E-05  +3.49900000E-05  +9.20000000E-06  +1.62900000E-05
   -1.00000000E-05  -4.69000000E-06  -1.85150000E-04  -1.68140000E-04  +6.65670000E-04
   +2.27310000E-04  -1.61400000E-04  -1.01000000E-04  +4.77400000E-05  -2.41000000E-05
   +2.22700000E-05  +4.22146000E-03  +2.33510000E-03  +9.21580000E-04  -7.97150000E-04
   -9.02055000E-03  +1.26639500E-02  +1.24735300E-02  -1.81910260E-01  +1.51464170E-01
   +3.01422000E-03  +1.11568000E-03  +2.04198000E-03  +2.07006000E-03  +3.22995000E-03
   +3.74938000E-03  -6.78980000E-04  +2.26340000E-04  -2.89690000E-04  -1.58129000E-03
   -1.53014000E-03  -2.38198000E-03  -7.61000000E-06  -3.42000000E-06  +4.26000000E-06
   +1.23800000E-05  +1.19000000E-06  -6.60000000E-07  +1.69000000E-06  -1.48600000E-05
   +2.30000000E-06  -3.94000000E-06  -3.94000000E-06  -1.80000000E-05  -7.80000000E-07
   +2.81000000E-06  -8.60000000E-07  +1.80000000E-06  -9.26700000E-05  +5.11800000E-05
   -1.51500000E-05  -2.48000000E-06  +1.11200000E-05  -9.53000000E-06  +1.56500000E-05
   -2.08200000E-05  +2.29700000E-05  -1.61000000E-06  -1.26000000E-06  -1.16700000E-05
   -1.25700000E-05  +1.51400000E-05  +2.15000000E-06  -3.35300000E-05  -2.59500000E-05
   -9.74860000E-04  -9.66140000E-04  -1.93381000E-03  -1.77322600E-02  +1.87322060E-01
   -5.95500000E-05  -5.38500000E-05  -6.85000000E-06  +3.06700000E-05  +4.31500000E-05
   +2.98700000E-05  -1.46700000E-05  -3.56800000E-05  -2.02800000E-05  +1.44500000E-05
   +4.80000000E-06  -3.83500000E-05  -3.84900000E-05  +2.35700000E-05  -2.23000000E-06
   -1.35700000E-05  +2.04200000E-05  +1.15700000E-05  -5.91000000E-06  -2.21400000E-05
   +2.14500000E-05  +3.40440000E-04  +1.25130000E-04  +3.81200000E-05  -7.01200000E-05
   -3.02500000E-05  +2.71600000E-05  -3.64000000E-05  -1.84000000E-06  -5.80000000E-05
   +1.03373000E-03  +1.77876000E-03  +3.02741000E-03  +8.63420000E-04  -4.22850000E-04
   +1.97130000E-03  -2.26235000E-03  +1.50503560E-01  -1.99654230E-01  -2.60608000E-03
   +1.69372400E-02  -1.23071500E-02  +4.08385000E-03  +7.12540000E-04  +3.88484000E-03
   -2.94910000E-04  -4.20200000E-04  +1.59550000E-04  -2.06694000E-03  -2.56937000E-03
   -4.37470000E-04  +3.76000000E-06  +8.35000000E-06  -3.80000000E-06  -6.45000000E-06
   -1.98000000E-06  +8.90000000E-07  +9.99000000E-06  -2.24000000E-06  -3.74000000E-06
   +1.08400000E-05  +2.39200000E-05  +1.12000000E-06  -1.35500000E-05  +1.72000000E-06
   -1.64700000E-05  -1.65200000E-05  -4.10000000E-06  -2.67100000E-05  -1.75000000E-06
   -1.82100000E-05  +7.92000000E-06  +1.10000000E-05  +5.50000000E-06  -2.17200000E-05
   +1.45900000E-05  -1.87400000E-05  +6.18000000E-06  -1.88000000E-06  -1.40000000E-05
   -2.00000000E-07  -1.71000000E-05  +1.80800000E-05  +2.29800000E-05  -1.16631000E-03
   -1.46902000E-03  -8.74410000E-04  +1.60049000E-03  -1.65936110E-01  +2.05901760E-01
   -1.54590000E-04  -1.13060000E-04  -3.68900000E-05  +9.34600000E-05  +1.20820000E-04
   +8.07000000E-05  -3.83000000E-05  -9.95400000E-05  -3.94500000E-05  -2.38800000E-05
   -6.37700000E-05  -1.61550000E-04  -2.50960000E-04  +4.34080000E-04  +7.81000000E-06
   -1.58470000E-04  +5.42800000E-05  +1.83590000E-04  +7.71000000E-06  -2.37000000E-06
   -2.13100000E-05  -6.41620000E-04  -1.12388000E-03  -5.20570000E-04  -9.40300000E-05
   -2.72200000E-05  +1.27490000E-04  +6.10800000E-05  -1.25620000E-04  -7.93300000E-05
   -8.88000000E-06  +2.56464000E-03  -9.86550000E-04  -2.33965000E-03  +8.23130000E-04
   +5.38430000E-04  +2.76361000E-03  +1.51790000E-04  -1.86782000E-03  -6.38260000E-04
   -8.70910000E-04  +2.88091000E-03  -3.78974300E-02  +1.58699300E-02  +1.40118000E-02
   -6.55690000E-03  +1.52310500E-02  +2.26396800E-02  +2.43616000E-03  -9.41890000E-04
   -9.70630000E-04  +2.72800000E-05  +7.23000000E-06  -2.06000000E-06  -1.91300000E-05
   -1.95800000E-05  +7.27000000E-06  +2.07000000E-05  +4.26000000E-06  -1.34200000E-05
   -2.04000000E-06  +4.56100000E-05  +2.20500000E-05  -2.84200000E-05  -2.05700000E-05
   -4.75000000E-06  -2.49000000E-06  +4.55800000E-05  -7.05100000E-05  +4.24900000E-05
   +8.78000000E-06  +2.98100000E-05  -4.40700000E-05  -8.17000000E-06  -5.84300000E-05
   +2.08800000E-05  -5.79000000E-06  -5.34600000E-05  +2.91500000E-05  -2.69900000E-05
   -2.10500000E-05  -3.31200000E-05  +3.47000000E-05  -2.09000000E-05  +6.38100000E-05
   +3.19800000E-05  +4.10000000E-06  +2.87680000E-04  +3.65000000E-05  -9.26000000E-06
   +6.07710800E-02  +5.20800000E-05  +3.57500000E-05  +8.60000000E-06  -3.16600000E-05
   -3.28200000E-05  -7.06000000E-06  +1.40300000E-05  +2.82700000E-05  -1.34300000E-05
   +6.65300000E-05  +6.73900000E-05  +4.97100000E-05  +1.77880000E-04  -2.54290000E-04
   -3.58000000E-05  +4.74400000E-05  -1.17200000E-05  -6.84900000E-05  +2.44700000E-05
   +7.24000000E-06  -1.14000000E-06  +6.07970000E-04  +8.74920000E-04  +1.91430000E-04
   -5.07000000E-06  +4.47700000E-05  -9.14500000E-05  -7.56800000E-05  +6.30900000E-05
   +9.88800000E-05  -3.59250000E-04  -4.17135000E-03  +2.43456000E-03  -6.40320000E-04
   +1.32463000E-03  -1.13703000E-03  +1.10642000E-03  -1.97838000E-03  +4.48060000E-04
   -1.02620000E-04  +1.05877700E-02  +2.03647000E-02  +9.03591000E-03  -1.04835830E-01
   -9.66964400E-02  +7.84479000E-03  -7.49619000E-03  -1.79732900E-02  -2.14975000E-03
   +8.27110000E-04  -1.31493000E-03  -7.66000000E-06  -1.52000000E-06  +1.04000000E-06
   +1.08000000E-05  +8.82000000E-06  -2.89000000E-06  -8.60000000E-07  -1.20400000E-05
   +7.68000000E-06  -1.26800000E-05  +3.77000000E-06  -2.09100000E-05  +6.46000000E-06
   +8.73000000E-06  +2.70000000E-07  -1.51000000E-06  -1.82400000E-05  +3.18900000E-05
   -2.34700000E-05  -1.08400000E-05  -1.88100000E-05  +3.27000000E-05  +1.37100000E-05
   +2.69700000E-05  +1.09400000E-05  -3.70000000E-06  -3.10000000E-05  -1.51300000E-05
   +1.64900000E-05  +5.15000000E-06  +2.03900000E-05  +5.26000000E-06  -1.83500000E-05
   +4.20100000E-05  +1.50900000E-04  +3.91600000E-05  -6.67350000E-04  -6.96490000E-04
   -3.85490000E-04  +6.27690000E-04  +1.23671400E-01  +7.67600000E-05  +5.38900000E-05
   +1.29600000E-05  -6.31800000E-05  -4.40500000E-05  -1.84400000E-05  +3.04000000E-06
   +8.57000000E-06  +3.70100000E-05  -2.32600000E-05  -3.50000000E-06  +2.15200000E-05
   -1.28000000E-04  +6.76600000E-05  +2.90200000E-05  +3.30900000E-05  -8.37000000E-06
   -5.33100000E-05  +1.46700000E-05  -9.68000000E-06  -1.39000000E-05  -3.12200000E-04
   -2.12140000E-04  -1.60360000E-04  +5.40800000E-05  -3.49200000E-05  +2.45900000E-05
   +2.78200000E-05  +4.90000000E-06  -7.36900000E-05  -1.05177000E-03  -5.52080000E-04
   +5.33140000E-04  +2.45261000E-03  -1.23545000E-03  -4.15160000E-04  -5.52534000E-03
   +2.81526000E-03  -2.97380000E-04  +7.33549000E-03  -5.99240000E-03  -3.01685500E-02
   +4.05600000E-04  -1.04620240E-01  -2.24537580E-01  +5.33714000E-03  -1.97141000E-03
   +3.11355000E-03  +1.85850000E-04  +4.72340000E-04  +3.31981000E-03  -1.39100000E-05
   -6.09000000E-06  -3.70000000E-07  +4.87000000E-06  +1.66000000E-06  -2.05000000E-06
   -1.74800000E-05  +9.41000000E-06  +1.08000000E-06  -2.52100000E-05  -4.62200000E-05
   -3.57000000E-06  +1.24000000E-05  +7.14000000E-06  +4.04000000E-06  +2.46200000E-05
   -1.98800000E-05  -8.84000000E-06  +1.01000000E-06  +3.88500000E-05  -1.25800000E-05
   -1.69700000E-05  +9.00000000E-08  -2.53100000E-05  -1.32100000E-05  +5.19000000E-06
   +4.04600000E-05  -3.73000000E-06  +5.15000000E-06  +1.21800000E-05  +4.48000000E-06
   -3.49500000E-05  +2.20000000E-05  -1.81900000E-05  -9.46200000E-05  +1.27900000E-05
   +7.46050000E-04  +5.98740000E-04  +1.16210000E-04  -6.23574000E-03  +1.14155560E-01
   +2.47225090E-01  +6.93900000E-05  +4.50000000E-05  -5.16000000E-06  -5.03600000E-05
   -3.69800000E-05  +1.40000000E-06  +3.42000000E-05  +5.05000000E-06  +3.14500000E-05
   -4.45400000E-05  -1.09700000E-05  -7.96900000E-05  -3.58520000E-04  +2.34690000E-04
   -6.50100000E-05  -4.89000000E-05  +1.21210000E-04  +1.51300000E-04  +9.74000000E-06
   -8.83000000E-06  -6.78100000E-05  -2.48030000E-04  -2.20034000E-03  -1.95318000E-03
   -5.66460000E-04  +2.45480000E-04  +7.72990000E-04  +5.31640000E-04  -8.66800000E-05
   -1.06900000E-04  +6.02796000E-03  -1.66050700E-02  +1.66548300E-02  -2.27774000E-03
   +2.11861000E-03  +4.99393000E-03  -4.23610000E-04  +2.68600000E-05  -2.75690000E-04
   -3.80459000E-03  +2.19568000E-03  +2.53085000E-03  -1.19910000E-04  +1.85419800E-02
   -1.81195600E-02  -4.86584300E-02  +1.02849900E-02  +4.14802000E-03  -5.54610000E-04
   +1.13381000E-03  -1.59264000E-03  -7.73000000E-06  -1.07300000E-05  +5.17000000E-06
   +9.96000000E-06  -9.04000000E-06  +1.05000000E-06  -5.31000000E-06  -9.39000000E-06
   -6.80000000E-07  +5.54600000E-05  -8.76100000E-05  -1.08400000E-05  +1.39000000E-06
   -3.61000000E-06  +8.02000000E-06  +1.94430000E-04  -2.10040000E-04  -1.57070000E-04
   -7.60840000E-04  +1.05654000E-03  +1.92450000E-04  -1.43356000E-03  +4.32040000E-04
   -5.29470000E-04  +1.25600000E-05  -2.48500000E-05  -1.35350000E-04  +2.91900000E-05
   -4.58500000E-05  +1.20300000E-05  -5.31500000E-05  -6.39700000E-05  -8.31100000E-05
   +2.47550000E-04  -8.49260000E-04  +9.61230000E-04  -2.88900000E-05  -2.16040000E-04
   -1.93520000E-04  +4.10860000E-04  -4.12400000E-05  +3.58220000E-04  +4.86011400E-02
   -2.31800000E-05  -3.07400000E-05  -2.14200000E-05  +6.50000000E-07  +4.46000000E-05
   +3.21800000E-05  -5.97000000E-06  -3.48500000E-05  +1.91000000E-06  -1.01590000E-04
   -1.13180000E-04  -1.17750000E-04  -3.86400000E-04  +4.29540000E-04  +3.38040000E-04
   -1.14050000E-04  +8.04800000E-05  +1.98630000E-04  +2.36000000E-05  -3.50400000E-05
   -7.24900000E-05  -1.27787000E-03  -2.79180000E-03  -1.93305000E-03  +1.66714000E-03
   -4.43000000E-06  -2.75350000E-04  +6.94920000E-04  -4.09270000E-04  -3.88400000E-05
   -2.30700000E-05  +2.12441000E-03  +3.60395000E-03  +1.77878000E-03  +3.92402000E-03
   +2.17530000E-03  -1.36610000E-04  -4.51100000E-04  -2.27790000E-04  +3.77791000E-03
   +4.95660000E-04  -2.07614000E-03  -2.51111000E-03  -1.22645900E-02  +1.44065900E-02
   +1.01041600E-02  -1.87692030E-01  +1.52642320E-01  -4.59900000E-05  -6.90040000E-04
   +1.38988000E-03  +5.25000000E-06  -3.60000000E-07  -7.20000000E-07  -1.09500000E-05
   -1.29500000E-05  -6.80000000E-07  +1.22900000E-05  +1.27000000E-06  -1.01800000E-05
   -3.46200000E-05  -9.90600000E-05  -1.76400000E-05  -9.49000000E-06  -1.39400000E-05
   +6.03000000E-06  +3.47300000E-05  -9.87700000E-05  -5.03150000E-04  +1.62167000E-03
   -1.24909000E-03  -2.39240000E-04  +3.13900000E-05  -1.93480000E-04  -2.45210000E-04
   -2.88200000E-05  -6.50000000E-07  +1.04000000E-05  -8.83000000E-06  -7.29000000E-06
   -6.95000000E-06  -4.75800000E-05  -6.47300000E-05  -2.16650000E-04  +1.95410000E-04
   +1.01980000E-04  +1.30810000E-04  -1.61560000E-04  -2.43360000E-04  -1.21510000E-04
   -5.41790000E-04  +3.34650000E-04  -4.65200000E-05  -1.47848300E-02  +1.97236290E-01
   -2.04400000E-05  -2.63900000E-05  -6.60000000E-06  -5.85000000E-06  +2.96200000E-05
   +5.97000000E-06  -5.00000000E-06  -3.12500000E-05  +6.77000000E-06  -5.78000000E-05
   -8.30200000E-05  -5.77600000E-05  -3.83850000E-04  +1.96610000E-04  +2.33840000E-04
   -1.08100000E-05  +2.09300000E-05  +1.14020000E-04  -1.20000000E-06  -2.50700000E-05
   -6.67000000E-06  -2.84103000E-03  -1.08220000E-03  -2.50385000E-03  -5.89790000E-04
   +9.10950000E-04  +4.81630000E-04  +8.80080000E-04  -3.42160000E-04  +8.25000000E-06
   -1.61224000E-03  +1.52141500E-02  -9.10251000E-03  +5.59586000E-03  +2.28564000E-03
   +1.49458000E-03  -8.10200000E-05  -8.36390000E-04  +8.61800000E-05  +1.47946000E-03
   +6.39290000E-04  +1.06458000E-03  +9.36860000E-04  -1.33456000E-03  +2.85508000E-03
   +6.91583000E-03  +1.52734720E-01  -1.92245720E-01  -3.30400000E-04  -1.56650000E-04
   +3.24570000E-04  -6.40000000E-07  +3.14000000E-06  -5.23000000E-06  -8.37000000E-06
   -3.78000000E-06  -2.23000000E-06  -1.09000000E-06  +1.17500000E-05  -1.23200000E-05
   +2.29000000E-06  +4.45000000E-06  -3.61500000E-05  -5.60000000E-06  -3.25000000E-06
   -1.56000000E-06  -5.06300000E-04  -3.28140000E-04  +2.15690000E-04  -4.87900000E-05
   -7.98990000E-04  +3.10900000E-05  -5.01150000E-04  +3.10510000E-04  +1.15390000E-04
   -6.81700000E-05  -7.73000000E-06  +7.60200000E-05  -1.49000000E-06  -4.37600000E-05
   -8.25500000E-05  +1.51000000E-05  -1.64650000E-04  -2.40590000E-04  -7.43700000E-05
   +9.05040000E-04  -4.90790000E-04  -2.28360000E-04  -1.80240000E-04  -2.22250000E-04
   -8.74940000E-04  +5.38680000E-04  +4.42970000E-04  -7.47768000E-03  -1.67874780E-01
   +1.97851310E-01  +1.98860000E-04  +1.23400000E-04  +1.89400000E-05  -1.59870000E-04
   -1.19200000E-04  -4.26000000E-05  +4.77200000E-05  +6.77900000E-05  +3.58200000E-05
   -2.34600000E-05  +4.98000000E-06  +5.33300000E-05  +3.53500000E-05  -1.38430000E-04
   -1.79100000E-05  +1.06800000E-05  +4.00000000E-08  +3.89500000E-05  +3.18700000E-05
   -3.54100000E-05  -3.58400000E-05  -9.71200000E-05  +1.36250000E-04  -3.58600000E-05
   +8.83300000E-05  -3.34300000E-05  -1.45900000E-05  +8.82700000E-05  -2.48700000E-05
   +2.28900000E-05  +4.70000000E-06  +1.73590000E-04  -1.96840000E-04  -4.77600000E-05
   -1.40510000E-04  +1.48076000E-03  -1.90015000E-03  +4.10294000E-03  -2.51726000E-03
   -4.08142900E-02  -1.11599000E-02  +2.49106100E-02  +5.26700000E-04  -5.73140000E-04
   -3.40230000E-04  -9.78360000E-04  -1.16338000E-03  +8.50830000E-04  -2.70908720E-01
   -1.20014740E-01  +1.76238970E-01  -3.72600000E-05  -1.35800000E-05  +2.96000000E-06
   +2.07800000E-05  +8.28000000E-06  -1.07900000E-05  -1.38000000E-05  -5.85000000E-06
   -8.90000000E-07  -2.87700000E-05  -7.96000000E-06  -4.93400000E-05  -4.14000000E-06
   +8.82000000E-06  +2.39000000E-06  +5.19800000E-05  -2.89300000E-05  -6.03000000E-06
   -3.50000000E-06  +4.81100000E-05  +3.90000000E-07  -3.45600000E-05  +1.14000000E-06
   -2.16100000E-05  -1.47600000E-05  +1.44400000E-05  +1.37100000E-05  -1.26100000E-05
   +2.84200000E-05  +2.41700000E-05  +3.85600000E-05  -4.91500000E-05  -2.47200000E-05
   -2.01760000E-04  +1.97290000E-04  -1.10850000E-04  +3.07400000E-05  -2.30950000E-04
   -3.73500000E-04  -2.02050000E-04  +3.83800000E-04  -9.67850000E-04  +4.17740000E-04
   -2.81890000E-04  -4.78200000E-05  +3.13997380E-01  -9.54100000E-05  -7.18900000E-05
   -8.24000000E-06  +7.07000000E-05  +6.11200000E-05  +2.05800000E-05  -2.30300000E-05
   -3.86800000E-05  -1.77500000E-05  -3.29000000E-06  -2.00400000E-05  -1.48500000E-05
   +2.99800000E-05  +6.83700000E-05  +6.75000000E-06  -1.24300000E-05  -1.80400000E-05
   -7.21000000E-06  -2.00900000E-05  +1.79000000E-06  +2.49200000E-05  +6.08600000E-05
   -1.02700000E-05  +1.92310000E-04  -5.11000000E-06  +7.88000000E-06  +1.51700000E-05
   -8.16100000E-05  +7.21100000E-05  -6.01300000E-05  -7.67200000E-05  +4.14360000E-04
   -3.82100000E-04  +7.13680000E-04  +1.15827000E-03  -5.30400000E-04  +5.40406000E-03
   -2.73494000E-03  +1.98494000E-03  +2.15485200E-02  +9.50833000E-03  -1.73589100E-02
   +8.08025000E-03  +1.03320000E-04  +1.26786000E-03  -1.22284000E-03  -9.11220000E-04
   +1.25600000E-05  -1.58876610E-01  -1.23458690E-01  +1.39922320E-01  +1.31000000E-05
   +1.12700000E-05  -3.78000000E-06  -1.17700000E-05  -2.36000000E-06  +2.72000000E-06
   +1.19800000E-05  +8.23000000E-06  -7.36000000E-06  +9.99000000E-06  +2.64900000E-05
   +2.01800000E-05  -8.93000000E-06  -1.71000000E-06  -9.42000000E-06  -2.48300000E-05
   +1.24700000E-05  +5.10000000E-06  -3.87000000E-06  -3.96100000E-05  -1.26000000E-06
   +1.83000000E-05  -7.30000000E-07  +1.89000000E-06  +2.69000000E-06  -7.90000000E-06
   +1.99100000E-05  -4.97000000E-06  -3.36100000E-05  -1.01400000E-05  -2.15100000E-05
   +2.78300000E-05  +4.03300000E-05  +1.74250000E-04  -3.38050000E-04  -6.58500000E-05
   -1.61700000E-04  -1.47980000E-04  -7.48400000E-05  -4.86530000E-04  +7.53500000E-05
   -4.82640000E-04  +2.19780000E-04  -6.13000000E-06  +8.93700000E-05  +1.29529810E-01
   +1.13550450E-01  -7.77500000E-05  -5.15500000E-05  -1.54100000E-05  +6.03700000E-05
   +4.89000000E-05  +2.83200000E-05  -1.31700000E-05  -2.52400000E-05  -2.99300000E-05
   +1.99100000E-05  +8.68000000E-06  -2.48100000E-05  +1.95900000E-05  +2.11800000E-05
   -2.14000000E-05  -2.52600000E-05  +1.42300000E-05  +6.46000000E-06  -3.79000000E-06
   +1.74800000E-05  +7.89000000E-06  +1.45920000E-04  -6.25000000E-06  -4.12200000E-05
   -4.80600000E-05  +1.75000000E-05  -6.00000000E-06  -2.06400000E-05  +1.02000000E-05
   +2.77500000E-05  -4.76100000E-05  -6.51430000E-04  +7.90310000E-04  +8.83780000E-04
   +4.66050000E-04  +6.29980000E-04  -1.78993000E-03  +1.64101000E-03  +2.36113000E-03
   +1.21761000E-03  -5.41021000E-03  +9.57430000E-04  -4.64383000E-03  +1.95105000E-03
   +6.56320000E-04  +5.78520000E-04  +3.83950000E-04  -6.04030000E-04  +2.02089080E-01
   +1.27252690E-01  -1.69853100E-01  +1.48900000E-05  +4.60000000E-06  +2.15000000E-06
   -4.03000000E-06  -4.26000000E-06  +4.27000000E-06  +1.29900000E-05  -6.64000000E-06
   -6.70000000E-07  +1.78400000E-05  +1.20300000E-05  +2.44400000E-05  -7.02000000E-06
   -7.18000000E-06  -9.90000000E-07  -7.22000000E-06  +1.75000000E-05  -7.47000000E-06
   +6.10000000E-06  -4.18000000E-06  +1.27400000E-05  -2.48000000E-06  -7.44000000E-06
   -2.16000000E-06  +2.32400000E-05  -1.24000000E-06  -4.42300000E-05  +2.63000000E-06
   -1.80900000E-05  +3.02000000E-06  -2.04700000E-05  +3.26700000E-05  -1.57000000E-05
   -3.80600000E-05  -1.02360000E-04  -1.02810000E-04  -3.66450000E-04  -2.58780000E-04
   -1.15390000E-04  +1.27970000E-04  -2.55870000E-04  -9.91240000E-04  -8.09600000E-05
   -1.53770000E-04  -9.39000000E-05  -1.99077380E-01  -1.22148190E-01  +1.68258230E-01
   -7.09230000E-04  -4.41640000E-04  -6.82000000E-05  +5.72500000E-04  +3.87100000E-04
   +1.25680000E-04  -1.42440000E-04  -2.01840000E-04  -1.29140000E-04  +4.63800000E-05
   -5.81100000E-05  -1.35740000E-04  +3.36700000E-04  +3.97370000E-04  -4.23600000E-05
   -3.36300000E-05  -2.65700000E-05  -2.00180000E-04  -1.60430000E-04  +9.89900000E-05
   +1.59420000E-04  +1.52113000E-03  +9.09490000E-04  +2.93499000E-03  -2.97290000E-04
   -1.45720000E-04  +2.28210000E-04  -1.39461000E-03  +5.19010000E-04  -3.25400000E-04
   -1.48017000E-03  +4.58523000E-03  -8.90021000E-03  -3.60022000E-03  -2.07830000E-04
   +1.06994000E-03  +7.20443000E-03  -4.28847000E-03  -1.53877000E-03  -2.69328300E-02
   -1.50886800E-02  +1.34637400E-02  -1.46400820E-01  -3.74112900E-02  +1.75964700E-02
   -4.84104300E-02  -1.75324700E-02  +7.54033000E-03  +1.01652700E-02  +1.76361000E-03
   -1.14435000E-03  +1.25800000E-04  +4.70900000E-05  -1.03200000E-05  -7.83500000E-05
   -2.70300000E-05  +3.48400000E-05  +6.86300000E-05  +1.90800000E-05  -5.60000000E-07
   +8.88400000E-05  +8.80000000E-05  +2.23160000E-04  -8.94000000E-06  -3.68300000E-05
   -1.75700000E-05  -1.39870000E-04  +1.95620000E-04  -5.96300000E-05  +7.22900000E-05
   -5.25500000E-05  +2.87100000E-05  +1.11960000E-04  -8.02600000E-05  +2.08600000E-05
   +6.12600000E-05  -1.00440000E-04  -2.96200000E-05  +7.23100000E-05  -7.53800000E-05
   -1.39990000E-04  -1.39600000E-04  +3.57680000E-04  +4.38790000E-04  -9.40700000E-05
   -2.45840000E-04  +4.53700000E-05  -2.50470000E-04  +3.92940000E-04  +1.25101000E-03
   -1.24758200E-02  -1.14398700E-02  -2.36585000E-03  +3.20141000E-03  +6.17400000E-04
   +3.89210000E-04  -5.10270000E-04  -4.88014000E-03  +1.73500000E-04  +2.58504390E-01
   -1.29710000E-04  -5.18900000E-05  -1.90700000E-05  +1.24410000E-04  +7.10100000E-05
   +3.63000000E-05  -3.44000000E-05  -2.95100000E-05  -2.79900000E-05  +6.21400000E-05
   +5.27200000E-05  -6.47700000E-05  -2.32190000E-04  +1.02640000E-04  +1.59200000E-05
   +5.73300000E-05  +5.62200000E-05  -6.05900000E-05  -5.15000000E-06  +6.53700000E-05
   +1.28500000E-05  -1.97760000E-04  -4.05650000E-04  -8.19740000E-04  -2.67870000E-04
   +1.56100000E-05  -1.48500000E-05  +1.33020000E-04  -2.18950000E-04  +1.41740000E-04
   +1.53700000E-05  -1.99960000E-03  +2.12106000E-03  -1.44840000E-03  +1.05536000E-03
   -1.17655000E-03  +3.44615000E-03  -5.08316000E-03  +1.64846000E-03  -2.54966700E-02
   -2.23570600E-02  +9.66045000E-03  -6.23216000E-02  -1.02043740E-01  -5.62168000E-03
   +1.32453900E-02  +1.48339300E-02  -6.62670000E-04  -7.99251000E-03  +6.68430000E-04
   +2.70656000E-03  +3.49500000E-05  -1.90000000E-06  +6.71000000E-06  -4.51000000E-06
   -1.08400000E-05  +1.46500000E-05  -3.58000000E-06  -1.85500000E-05  +2.32300000E-05
   +4.76300000E-05  -5.82200000E-05  +3.10300000E-05  +2.91400000E-05  -9.92000000E-06
   +1.67000000E-05  -6.92000000E-06  +4.05800000E-05  -1.10700000E-05  +5.95000000E-06
   +5.39400000E-05  +3.75300000E-05  +7.47000000E-06  -1.35800000E-05  +3.12800000E-05
   +4.71800000E-05  +1.35100000E-05  -1.15730000E-04  +5.26800000E-05  +6.52000000E-06
   +1.19800000E-05  -2.17700000E-05  +3.17000000E-06  -1.12700000E-04  -1.56270000E-04
   +2.07820000E-04  -1.26510000E-04  -4.87470000E-04  +8.58890000E-04  +1.53340000E-03
   -2.83458100E-02  -1.77721800E-02  -3.54516000E-03  -1.43059000E-03  +1.65468000E-03
   -9.99250000E-04  -6.27700000E-04  +3.91502000E-03  -1.94870000E-03  +9.19062100E-02
   +3.61198100E-01  +6.89000000E-05  +3.72900000E-05  +2.18500000E-05  -5.59600000E-05
   -3.51700000E-05  -2.59000000E-05  -3.66000000E-06  +8.10000000E-06  +3.64000000E-05
   -1.51800000E-05  -2.08200000E-05  +3.43300000E-05  -5.34400000E-05  +1.44800000E-05
   +7.27000000E-05  +5.51000000E-05  -3.53600000E-05  -2.80800000E-05  +5.85000000E-06
   -2.37100000E-05  +5.40000000E-07  -3.11440000E-04  -6.33100000E-05  +6.84400000E-05
   +1.17530000E-04  -1.27900000E-05  -1.81800000E-05  +4.09000000E-06  +3.23200000E-05
   -4.77100000E-05  -1.00602000E-03  +5.04800000E-05  +6.38270000E-04  +1.40525000E-03
   -3.71200000E-04  -1.08500000E-04  -3.69627000E-03  +3.32318000E-03  -5.49400000E-04
   +2.57742600E-02  +2.10813800E-02  -1.45357000E-03  -5.76504000E-03  -1.68191500E-02
   -7.25555900E-02  +4.73047000E-03  -1.39470000E-04  +5.08085000E-03  +3.34746000E-03
   -1.95510000E-04  +1.50379000E-03  -1.71800000E-05  +1.09000000E-06  -6.90000000E-06
   -5.30000000E-07  +6.38000000E-06  -5.32000000E-06  -1.75900000E-05  +1.71800000E-05
   -3.02000000E-06  -2.44300000E-05  -1.40700000E-05  -3.76300000E-05  +8.46000000E-06
   +1.50500000E-05  -6.15000000E-06  -8.15000000E-06  -3.89000000E-05  +2.50900000E-05
   -3.71000000E-06  -4.23100000E-05  -3.82600000E-05  +2.33800000E-05  +2.97700000E-05
   +7.74000000E-06  -4.91700000E-05  -7.37000000E-06  +7.94100000E-05  -7.30000000E-06
   +1.49700000E-05  -3.06100000E-05  +2.01000000E-05  -3.39600000E-05  +3.23100000E-05
   +1.33200000E-04  -1.95100000E-05  +2.05410000E-04  -8.94900000E-05  -9.91640000E-04
   -1.30208000E-03  -2.74380300E-02  -1.98724500E-02  +4.19430000E-04  +6.10890000E-04
   -8.18790000E-04  +1.82000000E-05  +7.73200000E-05  -2.07907000E-03  -2.75114000E-03
   -4.09597400E-02  +2.61976280E-01  +3.74066960E-01  +2.27560000E-04  +1.48390000E-04
   +2.27200000E-05  -1.72270000E-04  -1.34880000E-04  -4.74800000E-05  +5.11500000E-05
   +7.95300000E-05  +4.03800000E-05  -1.53000000E-06  +3.09400000E-05  +6.99000000E-05
   -3.46000000E-06  -1.84740000E-04  -1.83000000E-06  +5.44400000E-05  +5.83000000E-06
   +1.25100000E-05  +4.66400000E-05  -2.36600000E-05  -4.33700000E-05  -1.80430000E-04
   +1.62190000E-04  -1.88340000E-04  +7.04400000E-05  -3.50000000E-05  -4.40800000E-05
   +1.16750000E-04  -1.17070000E-04  +9.31200000E-05  -7.92990000E-04  -5.99250000E-04
   +1.62986000E-03  +6.92400000E-05  -2.91700000E-05  -3.97040000E-04  -4.59220000E-04
   +3.43000000E-06  +3.48480000E-04  +2.25025000E-03  -2.98280000E-04  -1.82130000E-04
   -5.03054000E-03  -2.89804200E-02  -2.98937400E-02  +3.44531000E-03  +1.18528000E-03
   -9.72440000E-04  -1.62373000E-03  +8.04940000E-04  -4.43500000E-04  -3.96000000E-05
   -1.57300000E-05  +4.73000000E-06  +2.68400000E-05  +1.15900000E-05  -1.09800000E-05
   -2.37100000E-05  -1.06600000E-05  +6.58000000E-06  -2.72400000E-05  -3.42300000E-05
   -6.67700000E-05  +8.99000000E-06  +1.18300000E-05  +8.91000000E-06  +6.30300000E-05
   -3.73900000E-05  +9.79000000E-06  -1.87900000E-05  +7.17200000E-05  -1.66900000E-05
   -2.43500000E-05  +1.52500000E-05  -3.18000000E-06  -9.50000000E-06  +2.92600000E-05
   -8.20000000E-07  -1.22000000E-05  +8.21300000E-05  +4.02500000E-05  +6.93900000E-05
   -6.03000000E-05  -6.13100000E-05  +2.11700000E-05  +9.44600000E-05  -4.46400000E-05
   -2.69800000E-05  +4.99800000E-05  +6.30000000E-07  -5.42585000E-03  -4.53821000E-03
   -2.95930000E-04  -4.09450000E-04  -2.91500000E-05  -4.30470000E-04  +4.03570000E-04
   +1.33410000E-04  +8.80160000E-04  -3.88938400E-02  +1.99958200E-02  +4.31400700E-02
   +4.62509400E-02  +2.98000000E-05  +8.32000000E-06  +4.93000000E-06  -2.74700000E-05
   -1.20100000E-05  -1.15300000E-05  +9.39000000E-06  +3.96000000E-06  +7.82000000E-06
   -2.06200000E-05  -1.77500000E-05  +1.04300000E-05  -1.26400000E-05  -1.47400000E-05
   +1.68800000E-05  -8.90000000E-06  -4.97000000E-06  +4.13400000E-05  +4.90000000E-07
   -2.49800000E-05  -6.18000000E-06  -2.73640000E-04  -1.50410000E-04  -2.28990000E-04
   +1.27900000E-04  +5.65600000E-05  -4.28000000E-06  +2.14920000E-04  -8.42000000E-06
   +7.47000000E-06  +5.93210000E-04  +3.55620000E-04  -7.00920000E-04  -1.52440000E-04
   -1.53200000E-04  +3.52230000E-04  +6.86000000E-06  +4.53550000E-04  -1.80190000E-04
   -6.70110000E-04  +1.84650000E-04  -3.63200000E-05  -1.94280000E-04  -1.56692800E-02
   -1.65833400E-02  -3.71360000E-04  +2.18049000E-03  +8.88130000E-04  +1.81798000E-03
   -8.26490000E-04  +3.56780000E-04  -8.86000000E-06  +2.41000000E-06  -2.90000000E-06
   +1.40000000E-07  +3.25000000E-06  -4.09000000E-06  +2.29000000E-06  +6.04000000E-06
   -8.20000000E-06  -8.92000000E-06  +7.65000000E-06  -2.31300000E-05  -6.06000000E-06
   +2.73000000E-06  -4.22000000E-06  -6.59000000E-06  -3.70600000E-05  +6.44000000E-06
   -1.22700000E-05  -4.68200000E-05  +8.15000000E-06  -2.06700000E-05  -8.49000000E-06
   -1.50200000E-05  -3.67900000E-05  -5.37000000E-06  +3.86800000E-05  -2.54900000E-05
   -7.88000000E-06  -1.29600000E-05  +6.87000000E-06  -5.29700000E-05  -3.09900000E-05
   +7.71100000E-05  -2.09000000E-06  +3.98900000E-05  +7.62600000E-05  -5.01800000E-05
   -1.37730000E-04  -3.26857000E-03  -8.54420000E-04  +7.15920000E-04  +7.42200000E-05
   +7.93100000E-05  +4.27420000E-04  -1.80090000E-04  -1.18082000E-03  -8.38340000E-04
   -9.94385000E-03  -2.34798770E-01  -2.44973370E-01  +1.22121800E-02  +2.50582570E-01
   +2.20300000E-05  +1.74000000E-05  -3.53000000E-06  -1.51100000E-05  -1.14900000E-05
   +1.32000000E-06  +9.39000000E-06  +7.76000000E-06  -3.17000000E-06  +3.90000000E-06
   +2.15600000E-05  -3.20000000E-06  -5.33300000E-05  -1.26100000E-05  -4.31400000E-05
   -1.07800000E-05  +2.14900000E-05  +1.99300000E-05  +8.54000000E-06  +0.00000000E+00
   -1.50300000E-05  -6.95400000E-05  -1.40110000E-04  -2.45320000E-04  -4.12500000E-05
   -4.65900000E-05  -2.43100000E-05  +1.38150000E-04  -2.06800000E-05  +3.97000000E-05
   +3.38260000E-04  -2.10530000E-04  +2.84080000E-04  -1.87580000E-04  +3.16100000E-04
   -2.14600000E-05  +5.83990000E-04  -7.08400000E-05  -8.25720000E-04  +5.19700000E-04
   -5.41700000E-05  +2.34135000E-03  +2.77783000E-03  +2.80545000E-03  -4.65620000E-04
   +3.41400000E-04  +1.23453000E-03  +1.33700000E-04  -6.61900000E-05  +6.70980000E-04
   -9.41180000E-04  -1.23000000E-06  -3.79000000E-06  +4.05000000E-06  +6.47000000E-06
   -9.90000000E-07  +1.16000000E-06  +3.58000000E-06  -7.73000000E-06  +1.37000000E-06
   +7.69000000E-06  -1.59200000E-05  -7.10000000E-06  +1.67000000E-06  -2.40000000E-06
   +3.94000000E-06  +3.68300000E-05  +1.07900000E-05  -1.12400000E-05  -3.18000000E-06
   +6.17000000E-05  +3.05800000E-05  -2.43900000E-05  -8.91000000E-06  -1.91700000E-05
   +3.44900000E-05  +2.57900000E-05  -4.09300000E-05  -5.51000000E-06  -4.15500000E-05
   +5.60400000E-05  -1.99300000E-05  -2.76300000E-05  -5.84800000E-05  +1.87900000E-05
   +8.14700000E-05  -2.22000000E-05  +1.99200000E-05  -4.04400000E-05  -1.17020000E-04
   -1.17497000E-03  -4.57520000E-04  +1.39450000E-03  -4.99540000E-04  +8.25700000E-05
   -3.15490000E-04  +1.19860000E-04  -3.64740000E-04  +9.51160000E-04  +1.03434100E-02
   -2.64699100E-01  -3.03343680E-01  -1.31633600E-02  +2.60880160E-01  +3.01264100E-01
end_hess

