# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.49916700    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.58350026E+00  -8.29349523E-02  +1.98606925E+00
   006   +2.16481209E+00  +1.32754877E+00  -4.66689730E-01
   006   +3.85581796E+00  +1.01136816E+00  -2.39162993E+00
   006   +5.81707831E+00  -7.68876141E-01  -2.29558864E+00
   006   +6.01963815E+00  -2.42948986E+00  -2.02010434E-01
   006   +4.43247590E+00  -2.20698741E+00  +1.78620325E+00
   006   -1.95022060E-01  +2.96880925E+00  -6.87687492E-01
   006   -1.35206463E-01  +5.10662916E+00  +1.27848513E+00
   008   +7.87022340E+00  -4.20801364E+00  -3.78900335E-01
   006   -2.49326501E+00  +1.23002459E+00  -3.37919054E-01
   006   -2.71758114E+00  -9.25974192E-01  -1.83093489E+00
   006   -4.76323829E+00  -2.53902039E+00  -1.62048056E+00
   006   -6.66296381E+00  -2.02383731E+00  +1.17963144E-01
   006   -6.47622884E+00  +1.06136297E-01  +1.62891373E+00
   006   -4.41078955E+00  +1.70027235E+00  +1.39495282E+00
   008   -8.71722896E+00  -3.53563135E+00  +4.15504680E-01
   006   -4.20272017E-01  +4.21994222E+00  -3.29873925E+00
   008   +3.38136644E+00  +1.59835054E+00  +3.97801709E+00
   001   -8.61729542E+00  -4.93017094E+00  -7.30804469E-01
   001   -4.87788587E+00  -4.20600615E+00  -2.80621323E+00
   001   -1.24507838E+00  -1.37625614E+00  -3.17947347E+00
   001   -4.31739019E+00  +3.33672063E+00  +2.61251316E+00
   001   -7.95249020E+00  +4.96446878E-01  +2.98687451E+00
   001   -2.17207155E+00  +5.29997008E+00  -3.37793923E+00
   001   +1.14422317E+00  +5.51955586E+00  -3.64051356E+00
   001   -4.71609679E-01  +2.83782189E+00  -4.82427375E+00
   001   -1.15355286E-01  +4.40246461E+00  +3.20694348E+00
   001   +1.57041492E+00  +6.23082080E+00  +1.01288897E+00
   001   -1.75873049E+00  +6.35267029E+00  +1.02644399E+00
   001   +3.66966743E+00  +2.10636099E+00  -4.10610134E+00
   001   +7.13455187E+00  -9.68554931E-01  -3.84292321E+00
   001   +4.58721063E+00  -3.44529273E+00  +3.41045856E+00
   001   +7.70648092E-01  -7.92764349E-01  +2.67064146E+00
   001   +7.88376316E+00  -5.21094496E+00  +1.12647862E+00
   001   +5.04332896E+00  +2.17773875E+00  +3.54899234E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -4.15000000E-06  +1.55000000E-05  +1.63000000E-05
   -5.90000000E-07  -1.83000000E-06  -4.14000000E-06
   -2.89000000E-06  +1.63000000E-06  +3.20000000E-07
   +1.07000000E-06  -3.45000000E-06  +2.26000000E-06
   -1.82000000E-06  -2.90000000E-07  +1.61000000E-06
   +6.72000000E-06  -9.76000000E-06  -4.63000000E-06
   +1.68000000E-06  +4.10000000E-07  -8.20000000E-07
   +1.25000000E-06  +0.00000000E+00  -7.50000000E-07
   -2.20000000E-06  -3.00000000E-07  +3.50000000E-07
   +6.20000000E-07  +8.00000000E-08  +3.50000000E-07
   -3.50000000E-07  -8.00000000E-08  +9.80000000E-07
   -7.80000000E-07  +4.60000000E-07  +1.48000000E-06
   -3.90000000E-07  +1.05000000E-06  +1.59000000E-06
   +2.70000000E-07  +1.78000000E-06  +1.18000000E-06
   +4.40000000E-07  +1.10000000E-06  +4.70000000E-07
   -6.00000000E-07  +1.69000000E-06  +2.50000000E-06
   +2.10000000E-07  -6.50000000E-07  -5.70000000E-07
   -2.50000000E-07  -4.30000000E-06  -1.06200000E-05
   -1.02000000E-06  +1.29000000E-06  +2.78000000E-06
   -1.24000000E-06  +1.00000000E-07  +2.00000000E-06
   -8.40000000E-07  -5.20000000E-07  +8.30000000E-07
   +8.80000000E-07  +1.37000000E-06  -1.10000000E-07
   +4.50000000E-07  +2.21000000E-06  +1.30000000E-06
   +3.50000000E-07  -5.60000000E-07  -8.60000000E-07
   +2.00000000E-08  -1.09000000E-06  -1.48000000E-06
   -1.40000000E-07  -1.32000000E-06  -6.00000000E-07
   +1.18000000E-06  +8.50000000E-07  -8.70000000E-07
   +1.18000000E-06  +2.50000000E-07  -1.89000000E-06
   +1.38000000E-06  +6.90000000E-07  -1.45000000E-06
   -6.00000000E-07  -1.73000000E-06  -1.03000000E-06
   -1.23000000E-06  -2.71000000E-06  -1.13000000E-06
   +4.30000000E-07  +2.40000000E-07  -2.80000000E-07
   +8.50000000E-07  -2.24000000E-06  -4.63000000E-06
   -7.80000000E-07  -1.11000000E-06  +4.60000000E-07
   +8.90000000E-07  +1.23000000E-06  -9.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.92636290E-01  +1.78178000E-03  +4.49970070E-01  -6.69948400E-02  -6.65852500E-02
   +4.36029530E-01  -9.29686800E-02  +1.84312000E-02  +1.75480000E-04  +4.93458900E-01
   +1.63760700E-02  -1.12764870E-01  +5.08262000E-02  -1.46622960E-01  +3.24998340E-01
   -6.90116000E-03  +5.98400300E-02  -1.42737050E-01  -1.48543720E-01  -6.04515500E-02
   +5.56346330E-01  +8.88321000E-03  -1.57568000E-03  +7.12077000E-03  -1.77484080E-01
   +4.20201200E-02  +1.02571450E-01  +4.22754450E-01  -9.25140000E-03  +7.76378000E-03
   +8.08582000E-03  +1.76911400E-02  -8.38013900E-02  +2.87279400E-02  -1.85864270E-01
   +3.89241120E-01  +2.17462600E-02  +5.41440000E-04  -2.44744700E-02  +1.41211680E-01
   -7.94780000E-03  -2.57061410E-01  -1.06458940E-01  -1.95949580E-01  +6.31438090E-01
   -3.15135000E-03  -2.95615000E-03  -5.62611000E-03  -5.51023700E-02  +2.31222100E-02
   +4.81166200E-02  -1.63839810E-01  +1.14861520E-01  -3.12609300E-02  +4.70510140E-01
   -3.35802000E-03  -4.92628000E-03  -2.15710000E-04  +4.72028600E-02  -2.72822000E-03
   -5.03574000E-02  +7.79871300E-02  -1.57502550E-01  +6.68484900E-02  -2.07042700E-01
   +3.78713690E-01  -1.52188000E-03  -1.75940000E-04  +3.76240000E-03  +8.40008000E-03
   -1.67465300E-02  +2.58378200E-02  +4.41420800E-02  +1.20515000E-03  -1.21190630E-01
   -1.94015820E-01  -1.16974470E-01  +5.45730380E-01  -1.93038200E-02  +8.14579000E-03
   +1.71699900E-02  -6.99604000E-03  -2.08746000E-03  +8.65230000E-03  +1.86073700E-02
   +5.84334000E-03  -2.98064700E-02  -9.79083500E-02  +4.86754100E-02  -2.18404700E-02
   +4.90669720E-01  +1.52272900E-02  +2.10950000E-03  -1.70880400E-02  -1.04346400E-02
   +7.14120000E-04  +1.08105200E-02  +2.77445700E-02  -2.98346100E-02  +9.87402000E-03
   +7.06271000E-03  -1.38362210E-01  +9.98520300E-02  -2.26608270E-01  +4.55234890E-01
   +5.24407000E-03  -1.28273600E-02  -4.58919000E-03  +2.45044100E-02  -1.29068000E-03
   -3.33704000E-02  -7.00901800E-02  +4.37050100E-02  +3.39811900E-02  +4.54640900E-02
   +3.53245800E-02  -1.69035470E-01  -1.73644170E-01  -1.07083930E-01  +5.56228350E-01
   -1.41275880E-01  +7.33848100E-02  +8.03536000E-03  +5.32625000E-03  +4.43312000E-03
   -1.31595600E-02  -1.99949700E-02  +1.16243600E-02  +9.00079000E-03  +1.92321300E-02
   -3.00686300E-02  +3.31302700E-02  -2.01929310E-01  +5.56162300E-02  +1.31503570E-01
   +4.18161170E-01  +7.19663500E-02  -1.48630130E-01  +1.88647300E-02  +1.17302500E-02
   -1.33089700E-02  +5.80140000E-03  +3.67729000E-03  -2.26479000E-03  -1.87540000E-03
   -1.34900800E-02  +1.25310800E-02  +1.54802000E-02  +3.24663100E-02  -9.92650400E-02
   +1.35800100E-02  -1.80946260E-01  +4.28271020E-01  +9.65800000E-03  +1.51610500E-02
   -8.00835100E-02  -2.74248400E-02  +2.00323100E-02  +1.41741000E-02  +2.27357600E-02
   -1.28104300E-02  -1.10286700E-02  +6.53724000E-03  +3.94111600E-02  -5.91732300E-02
   +1.76265180E-01  -2.49075500E-02  -2.75089550E-01  -2.06875630E-01  -1.39162590E-01
   +6.58504190E-01  -1.75617000E-03  +2.99397000E-03  -5.89136000E-03  -1.36545120E-01
   +4.90540000E-02  +4.03910000E-04  -1.46041900E-02  +1.43549200E-02  +2.47909000E-03
   +2.01318000E-03  +1.62746000E-03  +2.38636000E-03  -9.68790000E-04  +1.58150000E-04
   +8.49210000E-04  +8.24930000E-04  -8.70140000E-04  +8.66640000E-04  +4.53869230E-01
   +1.07028100E-02  -7.49230000E-03  +3.37328000E-03  +4.82578200E-02  -1.02437040E-01
   +9.18410000E-03  +1.21400800E-02  +1.52902000E-03  -3.68098000E-03  +2.89300000E-04
   +7.03969000E-03  +2.40212000E-03  -3.70330000E-04  -1.00545000E-03  +1.54868000E-03
   +8.13680000E-04  -5.85000000E-06  +1.50111000E-03  -1.01143600E-02  +4.76683190E-01
   -2.14147200E-02  +1.77751200E-02  +3.53812000E-03  -9.27871000E-03  +1.40039800E-02
   -8.67298300E-02  +1.97508200E-02  -1.43315800E-02  +6.05371000E-03  +3.14151000E-03
   +3.26365000E-03  -3.66393000E-03  -2.24830000E-04  +6.64200000E-05  +3.79090000E-04
   +9.56690000E-04  +1.48435000E-03  -5.04528000E-03  -2.62504000E-03  +1.64152000E-03
   +4.80223610E-01  -1.28630000E-04  -5.86500000E-04  -6.46460000E-04  -1.40791000E-03
   +2.00283400E-02  +2.05297300E-02  -3.66447000E-03  +2.20261000E-03  -1.32643000E-03
   -1.16216000E-03  -1.45399000E-03  +4.85760000E-04  +5.14970000E-04  -3.46630000E-04
   -3.67720000E-04  -1.77040000E-04  +1.65430000E-04  +4.91150000E-04  -7.43182800E-02
   +3.30733000E-03  +1.66596000E-03  +5.85103460E-01  +5.55500000E-05  +1.02597000E-03
   +9.17170000E-04  +7.21327000E-03  -1.87578000E-02  -1.41484200E-02  -6.42510000E-04
   -8.77730000E-04  +1.26167000E-03  +8.10460000E-04  +3.49680000E-04  +6.91600000E-05
   -9.17800000E-05  +1.17860000E-04  -9.20100000E-05  +1.28200000E-05  +5.48800000E-05
   -4.51170000E-04  -4.47511000E-03  -1.27118350E-01  -5.05966900E-02  -1.80679000E-03
   +5.09262160E-01  -8.69780000E-04  +1.47010000E-03  +6.97490000E-04  +7.52175000E-03
   -3.76319000E-03  +1.74750000E-03  -2.48811000E-03  +6.18440000E-04  +2.76100000E-04
   +1.99570000E-04  -7.16690000E-04  +6.64370000E-04  +2.91520000E-04  -1.22460000E-04
   -4.69560000E-04  -8.64300000E-05  +1.73520000E-04  -4.69400000E-05  -5.01007000E-03
   -4.34389900E-02  -1.21032490E-01  -2.67400000E-04  -6.87511300E-02  +5.49513590E-01
   +8.69573000E-03  -4.90708000E-03  +4.78389000E-03  -7.51890000E-04  +7.97270000E-04
   +2.76760000E-04  +1.44390000E-03  +6.49710000E-04  +2.20570000E-04  -6.11059000E-03
   +1.52155200E-02  -4.91762000E-03  -1.89571370E-01  +1.12465780E-01  +4.96221400E-02
   -3.04273400E-02  +3.71736500E-02  +4.12446000E-03  +5.87320000E-04  -2.49710000E-04
   -2.31580000E-04  -2.89140000E-04  -3.08100000E-05  -7.53400000E-05  +2.49216120E-01
   +2.51185000E-03  +8.81947000E-03  +4.65890000E-04  +1.32573000E-03  -1.10021000E-03
   -2.01507000E-03  -3.76789000E-03  +2.44961000E-03  +6.33849000E-03  +3.29168800E-02
   -3.37804400E-02  +8.04518000E-03  +1.37329570E-01  -1.75716970E-01  -1.85260400E-02
   +1.83826900E-02  -7.25332000E-03  +1.15157000E-03  -6.54360000E-04  +8.97400000E-05
   -7.55200000E-05  +3.36850000E-04  -2.44900000E-05  +6.25800000E-05  -1.87965690E-01
   +3.82913920E-01  +5.26060000E-03  +5.67365000E-03  -5.41250000E-04  -1.95433000E-03
   -3.26680000E-04  +2.21483000E-03  +7.61513000E-03  -2.42820000E-04  -6.96165000E-03
   -3.13985800E-02  +3.52065800E-02  -9.10040000E-04  +1.20646700E-02  +1.91574400E-02
   -9.12472200E-02  +3.25343500E-02  -2.79738000E-02  +1.88860000E-04  -2.66020000E-04
   -3.36110000E-04  +2.08680000E-04  -1.92200000E-05  +3.36400000E-05  +2.12000000E-06
   -5.30220500E-02  -2.42770540E-01  +4.80850080E-01  -4.13600000E-04  +4.49960000E-04
   -1.42508000E-03  -3.76896800E-02  -8.45325000E-03  +5.99885000E-03  +7.17400000E-05
   +1.23510000E-04  -1.91936000E-03  -2.88700000E-05  +1.49032000E-03  +5.66050000E-04
   -4.65400000E-05  -1.82380000E-04  +3.30180000E-04  +1.60930000E-04  -4.29200000E-04
   +5.61060000E-04  -1.30680220E-01  -4.60708400E-02  +1.21965000E-02  -1.23915000E-03
   -6.12986000E-03  -2.99780000E-03  -6.18400000E-05  +5.53200000E-05  -5.03100000E-05
   +5.27313860E-01  +1.94704000E-03  +1.09940000E-04  +2.61100000E-05  +6.82743000E-03
   +1.27775400E-02  -3.51283000E-03  +7.52210000E-04  -2.66440000E-03  +4.80360000E-04
   +4.72690000E-04  -1.04119000E-03  -9.89950000E-04  -4.05360000E-04  +5.67850000E-04
   -4.64300000E-05  +2.70000000E-05  -3.21690000E-04  +9.86900000E-05  -3.68840400E-02
   -1.09926390E-01  -3.24520000E-03  -2.18610000E-02  -1.89679400E-02  +1.46404000E-03
   +4.11600000E-04  -4.81290000E-04  +5.38200000E-05  +9.64741400E-02  +5.07728540E-01
   -2.05287000E-03  +4.88760000E-04  -6.14570000E-04  +2.60910000E-03  -7.33420000E-04
   -2.76810000E-04  -7.59190000E-04  -8.64700000E-05  +7.27700000E-05  +1.80970000E-04
   -4.21680000E-04  +1.11610000E-04  +1.40530000E-04  -3.15600000E-05  -3.00680000E-04
   -2.01480000E-04  -1.58810000E-04  +2.07820000E-04  +1.44871400E-02  -1.28500000E-04
   -7.97008100E-02  -1.95399500E-02  -1.46033300E-02  +2.98913000E-03  -1.73190000E-04
   +2.21780000E-04  +1.09990000E-04  -1.69922000E-01  +1.77802740E-01  +4.43676780E-01
   -6.49200000E-05  -2.76140000E-04  -7.92740000E-04  -4.42530000E-04  -2.56602000E-03
   -1.42834000E-03  -6.13490000E-04  -4.50690000E-04  -2.58570000E-04  +4.03090000E-04
   -9.20900000E-05  +2.78300000E-04  +1.74230000E-04  +3.04100000E-05  -1.47230000E-04
   +1.02110000E-04  -5.13000000E-06  -3.92000000E-06  -2.71361000E-03  -2.24946800E-02
   -1.55622400E-02  -4.60054000E-03  -2.87928000E-03  +1.74552000E-03  -8.50700000E-05
   +7.06800000E-05  +3.59100000E-05  -1.15491450E-01  -1.51185000E-03  +3.13192300E-02
   +5.99856100E-01  -2.16400000E-04  -5.18830000E-04  +9.34460000E-04  -9.77400000E-05
   -1.24561000E-03  -1.40190000E-04  -2.33060000E-04  -6.69600000E-05  -4.21510000E-04
   +1.86970000E-04  -3.81680000E-04  +9.52600000E-05  +1.17630000E-04  +1.35100000E-05
   -2.04880000E-04  +5.48900000E-05  +3.00510000E-04  -1.14060000E-04  -9.07813000E-03
   -1.74618000E-02  -8.32085000E-03  -2.38001000E-03  -4.85760000E-04  +7.42860000E-04
   +8.84400000E-05  -1.08590000E-04  -6.47700000E-05  -4.97176800E-02  -2.37184140E-01
   -9.26545100E-02  +1.38489160E-01  +5.31796060E-01  +1.29100000E-05  +1.25200000E-05
   +1.17470000E-04  -8.76200000E-04  -6.94370000E-04  +4.99020000E-04  -1.71480000E-04
   -1.91850000E-04  -4.93770000E-04  +2.39460000E-04  -4.89600000E-04  -8.63700000E-05
   +1.95680000E-04  -2.78300000E-05  -9.58900000E-05  -5.79300000E-05  -4.27700000E-05
   +7.69700000E-05  -4.16335000E-03  +2.58220000E-03  +6.24686000E-03  +1.79104000E-03
   +7.71710000E-04  -2.68960000E-04  -1.85700000E-05  -9.16000000E-06  -3.22500000E-05
   -6.48327000E-03  -1.25852850E-01  -1.62184810E-01  -2.12104230E-01  +1.97161940E-01
   +4.42273620E-01  -7.19200000E-05  +1.85860000E-04  +3.23360000E-04  +4.23100000E-05
   -2.59060000E-04  -1.35520000E-04  -3.58210000E-04  +3.05850000E-04  -4.82800000E-05
   +1.05130000E-04  -1.60570000E-04  +4.62300000E-05  +1.35390000E-04  -1.23230000E-04
   -1.47290000E-04  -1.94630000E-04  +2.23000000E-06  +9.64800000E-05  +4.18609000E-03
   +3.51490000E-04  +1.43520000E-03  +2.56160000E-04  +3.92830000E-04  +3.85000000E-04
   -1.63790000E-04  +1.79090000E-04  +2.30000000E-05  +2.20958900E-02  -5.61748200E-02
   -5.38462400E-02  -2.51957870E-01  -1.03230510E-01  +5.73347700E-02  +5.59198610E-01
   -3.21050000E-04  -1.46890000E-04  -9.93400000E-05  +7.04890000E-04  -2.55420000E-04
   +2.46880000E-04  +2.05850000E-04  +3.18610000E-04  +1.68590000E-04  -2.68590000E-04
   +1.72320000E-04  +8.76000000E-06  -2.13060000E-04  +1.06960000E-04  +1.10360000E-04
   +6.27800000E-05  +7.43400000E-05  -2.90500000E-05  +3.92850000E-04  -5.60530000E-04
   -5.47273000E-03  -1.18681000E-03  -5.65940000E-04  +3.22830000E-04  +1.23520000E-04
   -1.06700000E-04  +0.00000000E+00  -1.77774200E-02  -3.45030800E-02  -2.01750900E-02
   -1.52455670E-01  -1.96439500E-01  +2.97769000E-03  +1.60550220E-01  +5.76602530E-01
   +5.33100000E-05  -1.77330000E-04  -1.82480000E-04  +6.52020000E-04  +4.22950000E-04
   +1.01900000E-05  +2.42370000E-04  -2.39890000E-04  +4.19000000E-05  -1.21230000E-04
   +1.93460000E-04  -4.18600000E-05  -1.49430000E-04  +1.03190000E-04  +1.06780000E-04
   +1.21150000E-04  -1.16200000E-05  -8.33200000E-05  +1.59394000E-03  -4.62418000E-03
   +4.21900000E-05  -7.15880000E-04  -6.28740000E-04  +1.83910000E-04  +1.29590000E-04
   -1.80750000E-04  -1.36800000E-05  -2.34746100E-02  +6.67956000E-03  +3.03797300E-02
   +1.93225100E-02  -3.16365900E-02  -9.75822400E-02  -1.83343730E-01  +2.30514550E-01
   +4.30968920E-01  -4.01390000E-04  -4.36350000E-04  -4.95800000E-05  -3.75220000E-04
   +5.52830000E-04  +2.07710000E-04  +3.64230000E-04  -3.28420000E-04  -6.24800000E-05
   -1.99100000E-05  -8.77000000E-06  -8.10000000E-06  -5.44650000E-04  +5.43680000E-04
   +1.42010000E-04  +3.20350000E-04  +1.36520000E-04  -1.32500000E-04  -2.05151000E-03
   -3.98540000E-04  +1.83130000E-04  +3.59650000E-04  -2.19610000E-04  -1.93310000E-04
   +6.18690000E-04  -6.59410000E-04  -3.91300000E-05  -9.74868000E-03  +2.37523600E-02
   +2.15167400E-02  -4.63852000E-02  -3.03815700E-02  +1.10018000E-02  -2.05439590E-01
   +4.62092400E-02  +1.31791700E-01  +5.74059430E-01  -3.00290000E-04  -1.30500000E-04
   +1.04150000E-04  -3.81850000E-04  +7.15470000E-04  +8.77100000E-05  +3.26200000E-04
   -1.41920000E-04  -1.14980000E-04  -9.18200000E-05  -9.21000000E-06  -1.43400000E-04
   -5.25330000E-04  +4.38700000E-04  +1.50730000E-04  +1.29880000E-04  -4.08500000E-05
   -6.93400000E-05  +4.49460000E-04  -8.25130000E-04  -9.04230000E-04  +1.54400000E-04
   +1.24880000E-04  -2.73700000E-05  +4.90620000E-04  -5.28360000E-04  -1.38400000E-05
   +2.28267500E-02  -3.20784800E-02  -3.62003100E-02  +1.15298800E-02  +5.14680700E-02
   +2.96313900E-02  -1.33961400E-02  -1.30021160E-01  -3.69936100E-02  +1.43934300E-01
   +5.72298150E-01  -6.81300000E-05  +1.10370000E-04  +1.84830000E-04  +4.71100000E-05
   +3.20400000E-05  -4.33100000E-05  -3.75100000E-05  +1.68530000E-04  +4.73000000E-06
   -5.49300000E-05  +1.95000000E-06  -7.46600000E-05  -4.01300000E-05  -4.60000000E-06
   -3.56000000E-06  -1.17700000E-04  -6.18300000E-05  +1.88100000E-05  +1.17122000E-03
   -1.33960000E-04  -1.30822000E-03  +2.66700000E-05  +1.76500000E-05  +3.37630000E-04
   -1.40200000E-05  +1.41800000E-05  +2.74000000E-06  +2.05824800E-02  -3.67308100E-02
   -4.89705800E-02  +4.33738800E-02  +5.88740000E-02  +1.74060400E-02  +8.63089800E-02
   -7.92790600E-02  -1.90694160E-01  -1.80649580E-01  +2.12757790E-01  +4.54806040E-01
   -2.62900000E-05  +2.05700000E-05  +8.26700000E-05  +1.73620000E-04  -3.65060000E-04
   +6.46800000E-05  -1.27050000E-04  +3.04000000E-06  -1.67600000E-05  +1.01690000E-04
   -6.26300000E-05  +1.07360000E-04  +1.73050000E-04  -8.63600000E-05  -6.76000000E-05
   +4.44200000E-05  +8.15500000E-05  -4.86200000E-05  +9.73120000E-04  +5.71900000E-04
   +4.16352000E-03  +2.18580000E-04  +5.43390000E-04  +8.82700000E-05  -8.09700000E-05
   +6.92000000E-05  -2.29200000E-05  -4.20271000E-02  +8.51257000E-03  +4.13710300E-02
   -1.90818500E-02  -2.96474500E-02  -1.16727300E-02  +3.52898400E-02  +2.45817300E-02
   -1.42990000E-04  -1.15452710E-01  +1.51758600E-02  +4.31434800E-02  +6.01189710E-01
   -8.77300000E-05  -1.04960000E-04  -6.30800000E-05  -2.82800000E-04  -6.64480000E-04
   +5.91000000E-05  -2.57780000E-04  +4.91200000E-05  -2.87100000E-05  +1.05860000E-04
   -2.80500000E-05  +2.08030000E-04  +2.85100000E-04  -1.79780000E-04  -1.48450000E-04
   +1.07900000E-05  +9.59900000E-05  +1.99300000E-05  -2.82390000E-04  +1.87531000E-03
   -2.96118000E-03  -5.32340000E-04  -5.28110000E-04  -1.76400000E-05  -2.08770000E-04
   +2.28580000E-04  -2.11000000E-06  -2.85190900E-02  +4.61749000E-02  +4.96648100E-02
   -2.77577800E-02  -5.28325200E-02  -1.89718000E-02  +5.85028700E-02  +9.86944000E-03
   -4.04469000E-02  -4.08166600E-02  -2.37739700E-01  -9.92652700E-02  +1.46254380E-01
   +5.37221480E-01  +2.39900000E-04  -3.90000000E-07  -2.92950000E-04  +9.68640000E-04
   +7.83370000E-04  -4.76510000E-04  +8.17100000E-05  -1.97810000E-04  +1.58760000E-04
   +5.28000000E-06  -4.36400000E-05  -9.50000000E-05  +5.92100000E-05  -7.28700000E-05
   -7.58000000E-06  -2.72600000E-05  -1.40400000E-05  +3.32200000E-05  +4.13878000E-03
   -3.98772000E-03  +1.26679000E-03  -7.00620000E-04  -6.38340000E-04  -1.32460000E-04
   -9.82400000E-05  +1.10280000E-04  +2.66200000E-05  +1.30790200E-02  +2.40812500E-02
   +1.62907200E-02  -1.01093800E-02  -1.76068200E-02  -9.50873000E-03  +2.60765300E-02
   -1.63446600E-02  -2.25833400E-02  -4.15900000E-05  -1.39200780E-01  -1.78636970E-01
   -2.22521360E-01  +2.10907400E-01  +4.51566190E-01  -8.92200000E-05  -6.94200000E-05
   +3.89130000E-04  -1.23422000E-03  -1.65668000E-03  +8.23350000E-04  -2.34250000E-04
   +6.44510000E-04  -1.19560000E-04  -1.24370000E-04  +1.97660000E-04  +1.28580000E-04
   -6.19900000E-05  -7.36600000E-05  +9.21800000E-05  +3.48000000E-05  +1.18720000E-04
   +2.87000000E-06  -1.74029300E-02  +2.88410000E-04  +1.38497000E-02  -1.54702000E-03
   +1.85010000E-04  +9.23300000E-04  +2.96000000E-05  -1.33800000E-05  -1.78200000E-05
   -2.17787270E-01  -1.53358900E-02  +9.58644700E-02  +3.54302500E-02  +6.39325400E-02
   +3.06164300E-02  -5.80124000E-02  -1.58503400E-02  +2.62661100E-02  +2.55579700E-02
   -5.95473200E-02  -6.25803800E-02  -2.50801450E-01  -9.84332900E-02  +5.87774900E-02
   +5.51890700E-01  -9.50000000E-05  +1.93860000E-04  +2.80850000E-04  -1.17682000E-03
   -2.30955000E-03  +1.20345000E-03  -4.43450000E-04  +6.59170000E-04  -1.83320000E-04
   -6.60800000E-05  +1.74520000E-04  +2.49120000E-04  +7.07000000E-05  -1.04330000E-04
   +4.50000000E-07  +2.77000000E-05  +1.06590000E-04  -6.91700000E-05  -1.34700200E-02
   +7.73922000E-03  +1.25553400E-02  -1.03300000E-03  -3.22110000E-04  +1.10150000E-03
   -6.22200000E-05  +7.09600000E-05  -2.11900000E-05  +3.30423100E-02  -1.20131050E-01
   -6.45070500E-02  +2.65251900E-02  +7.03784000E-03  -1.96484200E-02  -1.32717000E-02
   -6.91922000E-03  +6.86272000E-03  -1.77502800E-02  -3.75783500E-02  -1.80639000E-02
   -1.48001690E-01  -1.92658370E-01  +3.47543000E-03  +1.48759850E-01  +5.75040500E-01
   +1.16530000E-04  +5.09890000E-04  -3.70890000E-04  -9.59610000E-04  -5.40780000E-04
   -5.73370000E-04  +1.34100000E-05  +2.02320000E-04  +3.82900000E-04  +1.17460000E-04
   +1.84050000E-04  +1.29180000E-04  +1.61000000E-04  -1.49730000E-04  -6.86800000E-05
   -1.30970000E-04  -1.77560000E-04  +8.98600000E-05  +3.82477000E-03  +2.58159000E-03
   +1.58775000E-03  -3.08180000E-04  +6.45300000E-04  -1.92600000E-04  -2.28610000E-04
   +2.72100000E-04  +5.26000000E-05  +1.33210200E-01  -3.10510900E-02  -1.86114100E-01
   +1.73170000E-03  -4.56915100E-02  -2.83203600E-02  +2.80135100E-02  +8.62699000E-03
   -1.66292100E-02  -3.01597300E-02  +1.16132200E-02  +3.23698500E-02  +2.04477300E-02
   -3.17638000E-02  -1.00059790E-01  -1.75242690E-01  +2.29952740E-01  +4.48546720E-01
   +3.08950000E-04  +3.84090000E-04  +1.01980000E-04  +4.25290000E-04  -9.62020000E-04
   -2.53800000E-04  -5.45750000E-04  +3.55900000E-04  +3.01000000E-05  +1.22890000E-04
   -6.44200000E-05  +1.28630000E-04  +6.90980000E-04  -6.14370000E-04  -2.31230000E-04
   -3.03150000E-04  -3.70900000E-05  +1.40950000E-04  +1.22208000E-03  +8.14820000E-04
   +3.12120000E-04  -4.82760000E-04  +6.88900000E-05  +2.63250000E-04  -7.07880000E-04
   +7.63840000E-04  +3.91600000E-05  -2.18864000E-03  -2.88117000E-03  -2.21659000E-03
   +3.29199000E-03  +3.65406000E-03  +5.66291000E-03  -3.91558600E-02  -3.25239500E-02
   +9.70479000E-03  -2.26822760E-01  -9.36075900E-02  +5.81795000E-02  -5.06143000E-03
   -1.73979400E-02  -4.40479000E-03  +8.88810000E-04  +1.17371000E-03  +3.70828000E-03
   +3.07513060E-01  +2.01380000E-04  +2.34430000E-04  +1.36600000E-05  +3.91530000E-04
   -8.20360000E-04  -2.37870000E-04  -5.06510000E-04  +2.80620000E-04  +5.30300000E-05
   +1.23140000E-04  -5.77200000E-05  +1.52840000E-04  +5.64180000E-04  -4.91240000E-04
   -2.15980000E-04  -2.11700000E-04  +2.39600000E-05  +1.39590000E-04  +1.00375000E-03
   +4.84810000E-04  +9.27750000E-04  -3.69080000E-04  +1.09700000E-05  +1.79680000E-04
   -5.63140000E-04  +6.39900000E-04  +3.66700000E-05  -3.40690000E-03  +1.22750000E-03
   +3.82157000E-03  -2.47102000E-03  -1.87811000E-03  -5.30808000E-03  -4.19139000E-03
   +5.28241000E-03  -3.83020000E-04  -1.30203060E-01  -1.59020250E-01  +3.78226000E-03
   -4.49921000E-02  -3.56365800E-02  -1.25733000E-03  +6.01997000E-03  +1.74534000E-03
   -7.06952000E-03  +1.39187390E-01  +5.06409800E-01  +1.45600000E-05  -5.26400000E-05
   -9.33200000E-05  -3.50800000E-05  +6.03200000E-05  +8.81100000E-05  +1.40490000E-04
   -1.39800000E-05  +2.40900000E-05  -6.80900000E-05  +8.00800000E-05  -2.99600000E-05
   -7.61700000E-05  +3.71700000E-05  +6.26500000E-05  +3.61700000E-05  -7.56000000E-06
   -3.15300000E-05  -5.03320000E-04  +2.88550000E-04  -1.06860000E-04  +4.82600000E-05
   -2.70100000E-05  -6.95900000E-05  +5.53300000E-05  -6.40800000E-05  +3.00000000E-06
   -2.05144000E-03  +3.94211000E-03  +3.27261000E-03  +1.01175000E-03  -9.60643000E-03
   -7.86340000E-04  +3.12829300E-02  +1.97118800E-02  +2.55954000E-03  +3.00053700E-02
   -2.22893200E-02  -8.21551200E-02  -2.56838500E-02  -2.09350400E-02  +9.71594000E-03
   +7.66378000E-03  -3.46691000E-03  -2.94782000E-03  -9.23103400E-02  +2.70697880E-01
   +3.01180530E-01  -4.03294000E-03  +3.18612000E-03  +2.07336000E-03  -4.02643000E-03
   +1.40804500E-02  -2.74872900E-02  -2.39862000E-03  +8.83440000E-04  -7.40810000E-04
   +2.23500000E-04  +1.63820000E-04  -8.19660000E-04  +3.06980000E-04  -1.71070000E-04
   -2.69500000E-05  +1.20820000E-04  +5.83520000E-04  -1.42847000E-03  -7.53260800E-02
   +1.80641000E-03  -4.05995000E-03  +6.29860000E-04  -4.28100000E-05  -1.83382000E-03
   -3.99890000E-04  +4.06620000E-04  +3.69400000E-05  -1.80684000E-03  -1.31861900E-02
   +2.53825000E-02  -4.22470000E-04  -9.07800000E-04  +9.84710000E-04  -1.27090000E-04
   +6.68940000E-04  +1.87600000E-05  +5.32360000E-04  +8.62830000E-04  +3.80980000E-04
   -1.45852000E-03  -5.38200000E-05  -1.07758000E-03  -7.24940000E-04  -2.05953000E-03
   -5.01530000E-04  -1.13511000E-03  -1.00452000E-03  +5.12000000E-05  +5.85312170E-01
   +2.50380000E-03  -8.77930000E-04  -1.35300000E-03  +6.00349000E-03  -1.12130500E-02
   +1.88268300E-02  +9.27100000E-05  -1.23789000E-03  +3.41900000E-05  -3.82620000E-04
   -2.49470000E-04  +7.37470000E-04  +8.51800000E-05  +4.34400000E-05  +2.71900000E-05
   -5.10700000E-05  -1.43710000E-04  +7.33240000E-04  +5.08666000E-03  -9.25772400E-02
   +3.89695200E-02  -1.03571000E-03  +8.57424000E-03  -2.37034100E-02  +9.26300000E-05
   -1.22760000E-04  -9.97000000E-06  -5.48923000E-03  -1.37567700E-02  +2.05838000E-02
   -7.23200000E-04  -5.64460000E-04  +1.15012000E-03  +8.48100000E-05  +7.21350000E-04
   -1.29660000E-04  +1.69740000E-04  +6.47920000E-04  +4.80920000E-04  -8.25250000E-04
   -3.31820000E-04  -8.43260000E-04  +1.09414000E-03  -1.25733000E-03  -5.25520000E-04
   -5.62500000E-04  -5.47070000E-04  -2.09500000E-05  +4.39174000E-03  +5.60809030E-01
   +1.09407000E-03  -1.18462000E-03  +4.18400000E-04  -5.97979000E-03  +4.75755000E-03
   -3.07685000E-03  +1.25344000E-03  -1.38483000E-03  +5.02000000E-05  +1.65640000E-04
   +1.42020000E-04  -5.66710000E-04  -1.85010000E-04  +1.38590000E-04  +3.09700000E-04
   +1.60350000E-04  -1.44970000E-04  +1.14780000E-04  -8.17038000E-03  +3.58157500E-02
   -1.53951490E-01  -1.92804000E-03  +4.83507000E-03  -3.62859400E-02  +1.29540000E-04
   -1.11560000E-04  -6.26400000E-05  +8.36375000E-03  +9.77223000E-03  -8.20298000E-03
   -1.45004000E-03  -9.86870000E-04  -1.57350000E-04  +9.08300000E-05  -2.74550000E-04
   -1.42600000E-04  +2.31720000E-04  +7.39700000E-05  +1.05820000E-04  +1.58840000E-04
   -1.51790000E-04  +7.49500000E-05  -1.08702000E-03  +3.23300000E-05  +8.95800000E-05
   -3.88920000E-04  -3.15100000E-04  -1.67100000E-05  -1.22039900E-02  +5.55621400E-02
   +4.92388310E-01  -8.94844100E-02  -3.86801700E-02  -2.75564800E-02  +1.42265000E-03
   -4.61104000E-03  -8.10012000E-03  -1.21968000E-03  +9.80390000E-04  -1.09724000E-03
   +4.01530000E-04  +6.25170000E-04  -2.32280000E-03  +2.16901000E-03  -4.54490000E-04
   +1.68935000E-03  +8.52313000E-03  +1.38890700E-02  +1.52877300E-02  +3.90200000E-04
   +1.66020000E-04  +9.13640000E-04  -3.30358000E-03  +2.21549000E-03  +1.22767000E-03
   -2.39592000E-03  +9.22210000E-04  -8.43630000E-04  -2.40050000E-04  -7.58900000E-05
   -2.01520000E-04  -2.96770000E-04  +3.70510000E-04  +2.32500000E-05  +9.74900000E-05
   +1.35710000E-04  -7.98000000E-06  +3.98970000E-04  +3.88430000E-04  +1.16720000E-04
   -3.87100000E-05  -2.38870000E-04  -1.70650000E-04  +3.53540000E-04  +1.67790000E-04
   -2.55390000E-04  -4.47980000E-04  -3.63220000E-04  +1.05400000E-05  +6.20900000E-05
   -6.81300000E-05  -6.40900000E-05  +5.44833490E-01  -2.07637300E-02  -9.80545800E-02
   -5.47334200E-02  +1.42843000E-03  +1.06564700E-02  -6.35628000E-03  -3.97202000E-03
   +2.16089000E-03  +2.87552000E-03  +2.23279000E-03  -3.04374000E-03  +5.92430000E-04
   -5.73101000E-03  -2.38076000E-03  +1.87621000E-03  +2.29995000E-03  -3.18384900E-02
   -3.66933300E-02  +3.90920000E-04  -1.42888000E-03  -1.91713000E-03  +3.00456000E-03
   -1.96972000E-03  -8.65200000E-04  +7.20806000E-03  -2.06876000E-03  +3.81230000E-04
   -6.56470000E-04  +5.03570000E-04  +2.39670000E-04  -4.70900000E-05  +6.87500000E-05
   -2.24320000E-04  +1.74670000E-04  +3.73650000E-04  -4.78000000E-06  +7.82800000E-05
   +2.06910000E-04  +1.67600000E-04  -2.14990000E-04  -1.53920000E-04  +8.69700000E-05
   +2.91310000E-04  -1.70510000E-04  -4.54540000E-04  -1.54290000E-04  -6.87100000E-05
   +2.40600000E-05  -5.46520000E-04  +5.69180000E-04  +4.81740000E-04  +1.86330360E-01
   +2.02080750E-01  -3.37840000E-03  -4.49042700E-02  -1.17690860E-01  -1.12634700E-02
   -2.11438200E-02  -4.32108600E-02  -6.67530000E-03  +4.76043000E-03  -4.55390000E-04
   +1.30017000E-03  -1.29240000E-03  -2.28401000E-03  -4.44560000E-03  -1.73857000E-03
   +5.56394000E-03  +5.74128000E-03  -2.54772800E-02  -1.46364100E-02  +1.93034000E-03
   -7.61480000E-04  +5.18830000E-04  -1.58183000E-03  +1.42735000E-03  +1.39780000E-04
   +3.62043000E-03  -6.19760000E-04  +8.63300000E-05  +4.15710000E-04  +5.12320000E-04
   +4.17600000E-05  +1.03010000E-04  -2.01650000E-04  -1.87750000E-04  -1.16320000E-04
   +1.39600000E-04  +1.81700000E-04  +2.94500000E-04  +2.27300000E-04  -3.17600000E-05
   -1.54900000E-04  -1.49570000E-04  +8.35400000E-05  +3.11100000E-05  -2.45180000E-04
   -1.17710000E-04  -3.89020000E-04  -2.77160000E-04  +8.84000000E-05  -2.31560000E-04
   +6.79220000E-04  +2.23240000E-04  -8.91127300E-02  +7.50164700E-02  +2.36259910E-01
   -8.61900000E-05  -6.88500000E-05  -3.44500000E-05  -2.89500000E-05  +4.48500000E-05
   +1.27300000E-05  +3.59900000E-05  -6.07000000E-06  +1.54600000E-05  -1.27900000E-05
   +9.50000000E-06  +1.73600000E-05  -9.96700000E-05  +8.81400000E-05  +1.51300000E-05
   +6.08500000E-05  +3.54900000E-05  -5.02000000E-06  -1.64880000E-04  +4.71400000E-05
   +9.43400000E-05  +6.56300000E-05  +1.92400000E-05  -2.73800000E-05  +1.05030000E-04
   -8.69700000E-05  +6.10000000E-07  -7.06800000E-05  +4.87000000E-04  +5.11900000E-04
   -6.23150000E-04  -2.08610000E-04  -1.78680000E-04  +1.35661000E-03  -8.42300000E-04
   -2.22435000E-03  -2.47472000E-03  -3.36807900E-02  -2.61712500E-02  -4.73938000E-03
   -3.49477000E-03  +2.18437000E-03  +1.51824000E-03  -9.79270000E-04  -5.93630000E-04
   -3.78005600E-02  +3.79418500E-02  +5.36504500E-02  +4.03600000E-05  -8.73000000E-06
   -1.35300000E-05  +6.18500000E-05  +4.54800000E-05  +5.89300000E-05  +4.40020000E-02
   -4.68700000E-05  -4.26800000E-05  -1.10700000E-05  -6.74800000E-05  +1.27830000E-04
   +4.64100000E-05  +1.06270000E-04  -4.91900000E-05  -9.47000000E-06  -3.36100000E-05
   +2.70700000E-05  -2.62400000E-05  -1.25990000E-04  +1.08300000E-04  +4.72100000E-05
   +4.30600000E-05  -9.81000000E-06  -3.33000000E-05  -1.77460000E-04  -8.33600000E-05
   -2.79000000E-06  +6.87900000E-05  -3.19000000E-06  -2.09500000E-05  +1.17030000E-04
   -1.43040000E-04  -8.20000000E-06  +3.16700000E-05  +5.97570000E-04  +4.30330000E-04
   +5.28900000E-05  -1.08692000E-03  -3.62310000E-04  +3.93155000E-03  +4.06734000E-03
   +1.01579000E-03  +6.48630000E-04  -2.71471600E-02  -1.92635000E-02  -4.61547000E-03
   -2.15200000E-05  +1.65106000E-03  +3.93930000E-04  -1.90590000E-04  -1.73200000E-03
   +8.41870000E-04  -3.18659230E-01  -2.43576670E-01  +1.02640000E-04  +4.52200000E-05
   +3.36400000E-05  +6.78500000E-05  +7.15000000E-06  +5.61500000E-05  -4.64000000E-04
   +3.42246760E-01  -3.98000000E-05  -2.09700000E-05  +2.09200000E-05  -5.52000000E-06
   +3.73000000E-05  +1.07400000E-05  -2.27400000E-05  -6.15000000E-06  -4.09000000E-06
   +1.35900000E-05  -3.06900000E-05  +9.37000000E-06  -1.62000000E-05  +2.93400000E-05
   -8.74000000E-06  +1.68700000E-05  +1.45800000E-05  +8.29000000E-06  -7.37200000E-05
   -5.73700000E-05  -1.37560000E-04  +4.94000000E-06  -4.34000000E-06  -1.46100000E-05
   +2.81300000E-05  -2.47700000E-05  -7.40000000E-06  +1.58750000E-04  +3.39000000E-05
   +7.68000000E-05  +6.66000000E-06  -1.75300000E-04  -8.06340000E-04  +1.44675000E-03
   +4.39634000E-03  +1.43846000E-03  +3.33780000E-04  +5.23783000E-03  +1.07346000E-03
   +1.32462000E-03  +8.29610000E-04  +1.81302000E-03  +4.40550000E-04  -7.82190000E-04
   +8.21110000E-04  +2.49923900E-02  -2.70028940E-01  -2.29466030E-01  +9.98600000E-05
   +7.46700000E-05  +3.54000000E-05  +2.24800000E-05  +1.51300000E-05  -1.30400000E-05
   -2.86728100E-02  +2.60955600E-01  +2.25749780E-01  -3.32400000E-05  -2.15500000E-05
   -1.67700000E-05  +1.77140000E-04  -6.89300000E-05  -2.69400000E-05  -9.55400000E-05
   +5.08700000E-05  +2.35600000E-05  +2.23000000E-05  -2.12500000E-05  +5.19700000E-05
   +3.75100000E-05  -3.20300000E-05  -3.03100000E-05  +2.25300000E-05  +5.16100000E-05
   +1.44000000E-05  +5.32110000E-04  -7.98940000E-04  -7.27090000E-04  -3.64190000E-04
   -1.20370000E-04  +1.10150000E-04  -2.81500000E-05  +6.51000000E-05  +1.47100000E-05
   -1.80526000E-03  -4.55588000E-03  +3.07921000E-03  +3.06613000E-03  -2.04786600E-02
   -1.59796000E-02  -5.46561300E-02  -1.69080500E-02  +2.11503000E-03  +4.97894000E-03
   +1.78165700E-02  +1.29013100E-02  -1.84788000E-03  -3.15020000E-04  +4.94871000E-03
   -1.57174000E-03  -2.68010000E-04  +2.67750000E-04  +1.51133000E-03  +2.49611000E-03
   -1.88273000E-03  +4.26000000E-06  +5.30300000E-05  -1.25870000E-04  -1.53200000E-05
   +4.38100000E-05  +1.32000000E-06  -7.23080000E-04  -1.07535000E-03  +6.98000000E-05
   +5.10574400E-02  +3.44300000E-05  +1.56400000E-05  -6.96000000E-06  +2.35260000E-04
   -1.10980000E-04  -2.40600000E-05  -6.45500000E-05  +6.06900000E-05  +1.51000000E-05
   +1.49800000E-05  -2.13000000E-06  +2.29600000E-05  +7.16100000E-05  -6.39300000E-05
   -2.85900000E-05  -2.66700000E-05  +5.59000000E-06  +9.56000000E-06  +3.05000000E-04
   -3.22150000E-04  -8.61300000E-04  -3.14420000E-04  -1.52790000E-04  +1.61480000E-04
   -7.58500000E-05  +8.35500000E-05  +9.90000000E-06  -4.99669000E-03  +1.65953000E-03
   -8.64440000E-04  +1.29431000E-03  -1.22677100E-02  -1.21233700E-02  -1.70870000E-02
   -2.33063750E-01  -1.39798680E-01  -5.38320000E-03  -4.24733000E-03  -2.51264000E-03
   +1.42800000E-04  +2.70537000E-03  -2.18598000E-03  +8.01700000E-05  +1.41970000E-04
   +7.18710000E-04  +2.01040000E-03  +1.54881000E-03  +2.70063000E-03  -6.62900000E-05
   -6.07000000E-06  -2.69600000E-05  -5.16900000E-05  +5.55000000E-06  -2.22100000E-05
   +1.04480000E-03  +4.71600000E-05  -1.13362000E-03  +2.14490800E-02  +2.45291080E-01
   -2.92500000E-05  -1.70300000E-05  +3.11000000E-06  -6.48100000E-05  -2.09600000E-05
   -2.45000000E-06  -7.28300000E-05  +5.50000000E-06  -1.19700000E-05  +2.72800000E-05
   -4.53200000E-05  +3.57700000E-05  +3.14700000E-05  -1.28900000E-05  -2.04100000E-05
   +2.15700000E-05  +4.25400000E-05  +2.15200000E-05  +2.94550000E-04  -2.05200000E-05
   +2.75320000E-04  -9.50000000E-06  +5.94000000E-05  -2.80300000E-05  -1.43400000E-05
   +3.88500000E-05  +1.96000000E-06  +2.67234000E-03  -1.46140000E-03  +4.48150000E-03
   +6.12150000E-04  +3.41955000E-03  +4.62161000E-03  +1.85866000E-03  -1.39794420E-01
   -1.40824450E-01  -4.58074000E-03  -1.89616400E-02  -7.11544000E-03  +5.30399000E-03
   -1.84480000E-03  +3.03790000E-04  +4.21300000E-04  +9.61220000E-04  -4.60710000E-04
   -2.32722000E-03  +2.33045000E-03  -4.63590000E-04  -3.28100000E-05  -7.13000000E-06
   -5.49300000E-05  -3.21000000E-06  +1.91000000E-05  -1.52300000E-05  +1.68674000E-03
   +3.64200000E-04  -3.38820000E-04  -3.35515000E-03  +1.53696840E-01  +1.42317380E-01
   -6.03600000E-05  -2.11100000E-05  -8.07000000E-05  -4.89910000E-04  -1.14553000E-03
   -5.87840000E-04  -8.27280000E-04  -1.62710000E-04  -1.56200000E-05  -1.64100000E-05
   +7.49000000E-06  +4.75000000E-05  -1.43840000E-04  +1.32500000E-04  +5.74700000E-05
   +1.01360000E-04  -2.91600000E-05  -1.48400000E-05  -1.24496000E-03  +5.00710000E-04
   -9.68450000E-04  -2.45000000E-05  +1.39820000E-04  -1.68730000E-04  +1.21530000E-04
   -1.42810000E-04  -6.91000000E-06  +5.17899000E-03  -4.16200000E-04  -1.08036000E-03
   -1.97471870E-01  +3.91471400E-02  +1.38852780E-01  -1.32652100E-02  +6.70742000E-03
   +1.70732200E-02  -9.02500000E-05  -5.25394000E-03  +1.52167000E-03  -2.30970000E-04
   -2.65220000E-04  -9.04910000E-04  +2.45525000E-03  -2.01614000E-03  +1.22481000E-03
   -1.30322000E-03  +3.60500000E-05  +8.74540000E-04  -7.98100000E-05  -1.22750000E-04
   +1.97130000E-04  +2.97900000E-05  +8.10000000E-05  +1.17250000E-04  +9.55100000E-05
   +2.24970000E-04  +9.14900000E-05  -3.22250000E-04  +1.19995000E-03  -1.90847000E-03
   +2.07157100E-01  +1.00640000E-04  +4.83800000E-05  -2.85900000E-04  -2.09070000E-04
   +2.57700000E-05  -1.87200000E-04  -3.38400000E-05  -1.09760000E-04  -4.37800000E-05
   -2.02750000E-04  +2.41590000E-04  -1.19930000E-04  -1.25060000E-04  +4.84000000E-06
   +1.93000000E-04  -6.92000000E-06  -1.48930000E-04  -2.43200000E-05  +1.46552000E-03
   -3.12010000E-04  +1.04813000E-03  +8.23200000E-05  +1.42500000E-05  +9.52600000E-05
   +6.84100000E-05  -1.11580000E-04  -1.06700000E-05  +1.95296100E-02  +2.88470000E-04
   -1.65640000E-02  +3.92827700E-02  -6.85729400E-02  -4.90780200E-02  -1.52062700E-02
   +7.71931000E-03  +1.34292500E-02  -4.95433000E-03  -2.05200000E-05  -2.53848000E-03
   -3.75950000E-04  -1.06861000E-03  +3.54970000E-04  -2.43893000E-03  -2.52747000E-03
   -5.18606000E-03  -9.16860000E-04  +9.25300000E-05  +7.73370000E-04  -1.61290000E-04
   -6.73470000E-04  -3.71030000E-04  -4.22100000E-05  +2.95000000E-06  +1.88840000E-04
   +7.04100000E-05  +1.28720000E-04  +7.32600000E-05  +1.60362000E-03  -5.84900000E-04
   +1.82612000E-03  -3.83905300E-02  +6.64394400E-02  -1.30080000E-04  -1.42070000E-04
   -3.02420000E-04  -1.96200000E-04  -2.63860000E-04  +1.82810000E-04  +4.08590000E-04
   +1.22670000E-04  +1.64430000E-04  -3.80670000E-04  +3.15540000E-04  -7.05000000E-05
   -2.93190000E-04  +1.24210000E-04  +2.12080000E-04  +1.36330000E-04  +5.75400000E-05
   -1.02830000E-04  -2.86940000E-04  +1.81630000E-03  -1.66698000E-03  -2.29750000E-04
   +1.17900000E-05  -4.55700000E-05  +1.65960000E-04  -1.43700000E-04  -9.28000000E-06
   +1.39311000E-02  -2.85604000E-03  -7.52077000E-03  +1.38347900E-01  -4.84360000E-02
   -1.70928410E-01  +8.73680000E-04  -1.90475000E-03  +1.91319000E-03  +1.86574000E-03
   -2.24702000E-03  +5.04852000E-03  -1.04833000E-03  +2.42810000E-04  -3.20420000E-04
   +1.11200000E-03  -5.63650000E-03  +1.55849000E-03  +2.68820000E-04  +1.23600000E-04
   -1.38780000E-04  +3.05300000E-05  +1.43020000E-04  -3.82000000E-06  +2.61500000E-05
   +2.22280000E-04  +1.75230000E-04  -5.11300000E-05  -5.09000000E-05  -3.80100000E-05
   -1.70728000E-03  +2.13452000E-03  -1.75685000E-03  -1.53647130E-01  +5.56620400E-02
   +1.74589060E-01  -1.07900000E-05  +1.50340000E-04  +1.98460000E-04  -2.61460000E-04
   -1.22550000E-04  -5.09300000E-05  -1.36000000E-06  -2.23300000E-05  -4.76100000E-05
   +4.67300000E-05  -2.08200000E-05  +2.57000000E-05  -4.51200000E-05  +6.44300000E-05
   -1.08700000E-05  +4.19000000E-06  -2.02500000E-05  -3.51100000E-05  -2.10000000E-04
   +1.30460000E-03  -1.52550000E-03  -2.07803000E-03  -1.18878000E-03  +1.14493000E-03
   +7.65400000E-05  -8.27100000E-05  -9.44000000E-06  +6.82935000E-03  +1.79716500E-02
   +1.23555200E-02  -1.84732000E-03  -5.06590000E-04  +5.57847000E-03  -1.33112000E-03
   -1.11860000E-04  +8.54400000E-05  -1.43332000E-03  -4.53035000E-03  +3.24302000E-03
   +2.50034000E-03  -2.09874300E-02  -1.51718700E-02  -5.56428300E-02  -1.52239200E-02
   -4.80920000E-04  +5.20100000E-05  -1.06934000E-03  -8.30370000E-04  +3.72570000E-04
   -9.28000000E-06  -1.18340000E-04  +1.31420000E-04  -2.49750000E-04  -5.81600000E-05
   -3.25750000E-04  -2.07570000E-04  -6.59300000E-05  -1.19640000E-04  +2.02490000E-04
   -2.77300000E-04  +1.95910000E-04  +1.06949000E-03  +7.36700000E-04  +5.56934500E-02
   +1.30980000E-04  +4.60000000E-06  -1.43770000E-04  +2.04650000E-04  +3.07840000E-04
   -2.70480000E-04  +1.38830000E-04  -1.06210000E-04  +5.53200000E-05  -2.20200000E-05
   +2.82100000E-05  -6.97700000E-05  -2.38100000E-05  +1.34000000E-06  +3.56200000E-05
   -9.64000000E-06  -3.46400000E-05  +2.02400000E-05  +4.35010000E-04  -1.88036000E-03
   +1.20600000E-03  -2.77723000E-03  -8.30080000E-04  +6.32780000E-04  -6.81000000E-06
   +8.31000000E-06  +1.27600000E-05  -6.68570000E-04  -1.05134000E-03  -3.78448000E-03
   -5.34630000E-04  +2.73636000E-03  -2.70322000E-03  +3.91400000E-05  +1.06060000E-04
   +9.07060000E-04  -4.61449000E-03  +2.02908000E-03  -1.45808000E-03  +3.80180000E-04
   -1.13533200E-02  -1.22818000E-02  -1.45963100E-02  -2.35957540E-01  -1.43516080E-01
   -1.33820000E-04  -9.34720000E-04  -6.64920000E-04  -3.03080000E-04  -2.04630000E-04
   +1.02010000E-04  -2.19100000E-05  +1.44300000E-05  +1.14080000E-04  -1.24390000E-04
   -1.85870000E-04  +9.71900000E-05  +1.74070000E-04  -2.71810000E-04  +2.34600000E-04
   -1.34190000E-04  -1.54360000E-04  -4.62000000E-05  +2.31070100E-02  +2.49623710E-01
   -9.39900000E-05  -1.13840000E-04  -4.14000000E-06  -2.48750000E-04  -1.83400000E-04
   +2.75600000E-04  -1.22300000E-04  +9.62300000E-05  -3.10400000E-05  +3.70000000E-07
   -1.44500000E-05  +6.05300000E-05  +1.78500000E-05  -8.32000000E-06  -3.39100000E-05
   +1.27400000E-05  +5.18500000E-05  +1.07700000E-05  -2.36968000E-03  +4.76410000E-04
   -1.75084000E-03  -1.47570000E-04  -6.14880000E-04  +4.70180000E-04  -6.48000000E-06
   +1.37900000E-05  -2.95000000E-06  -2.28786000E-03  -1.71581300E-02  -7.40213000E-03
   +5.58376000E-03  -2.40428000E-03  +7.74040000E-04  +1.13680000E-04  +9.73890000E-04
   -4.19630000E-04  +3.23744000E-03  -1.48965000E-03  +4.55139000E-03  +1.54822000E-03
   +3.07555000E-03  +5.40810000E-03  -3.24600000E-05  -1.43592050E-01  -1.52116870E-01
   -1.26900000E-04  +3.13000000E-06  +1.26610000E-04  +6.36660000E-04  +2.25020000E-04
   -5.40900000E-05  +5.27000000E-06  +1.24930000E-04  -3.14000000E-05  -3.81000000E-06
   +1.56980000E-04  -7.59700000E-05  -3.03160000E-04  +1.98500000E-04  -3.51440000E-04
   -1.73810000E-04  -8.94160000E-04  -5.43120000E-04  -2.57314000E-03  +1.58078580E-01
   +1.52796700E-01  -3.75900000E-05  +3.87400000E-05  +6.23400000E-05  +1.94500000E-05
   -1.97480000E-04  +6.49300000E-05  -8.06700000E-05  +7.70000000E-05  -2.04000000E-05
   +6.90000000E-06  -1.21900000E-05  +3.27100000E-05  +3.68800000E-05  -2.33500000E-05
   -2.51500000E-05  -9.94000000E-06  +6.11000000E-06  +1.24000000E-06  -1.42980000E-04
   +5.74030000E-04  +7.41350000E-04  -2.90100000E-05  +1.15460000E-04  +7.29000000E-06
   -3.17400000E-05  +3.56400000E-05  -2.75000000E-06  -6.25450000E-04  -5.18317000E-03
   +1.58996000E-03  -1.95750000E-04  -3.26310000E-04  -8.76480000E-04  +2.16229000E-03
   -1.88264000E-03  +1.06441000E-03  +4.21446000E-03  -2.64451000E-03  -1.23028000E-03
   -2.00089420E-01  +3.50510800E-02  +1.44811240E-01  -1.24431100E-02  +6.95829000E-03
   +1.61410200E-02  -1.50480000E-04  +1.40645000E-03  -1.36285000E-03  -2.20530000E-04
   -1.12910000E-04  -5.81600000E-05  -1.60300000E-05  -1.95700000E-05  -7.50600000E-05
   -1.17360000E-04  +1.93060000E-04  -1.68890000E-04  +2.06930000E-04  -4.72600000E-05
   -2.33570000E-04  -2.00740000E-04  +2.34260000E-04  -1.83340000E-04  -4.12370000E-04
   +1.27418000E-03  -1.93805000E-03  +2.08112210E-01  +6.46000000E-06  +1.43800000E-05
   +2.33000000E-06  -1.08730000E-04  -2.19580000E-04  +4.80800000E-05  -1.40600000E-05
   +4.61900000E-05  +4.77000000E-06  -4.64000000E-06  +3.33200000E-05  +3.06200000E-05
   +1.85000000E-05  -2.59300000E-05  +3.13000000E-06  +3.90000000E-07  +1.21900000E-05
   -6.82000000E-06  -5.80200000E-04  +4.39830000E-04  +3.89630000E-04  +9.42300000E-05
   +6.40900000E-05  +6.38300000E-05  -1.91300000E-05  +2.03200000E-05  +8.00000000E-07
   -4.87393000E-03  +2.97900000E-05  -2.07076000E-03  -5.59540000E-04  -1.29903000E-03
   +2.00910000E-04  -2.28929000E-03  -2.52174000E-03  -4.67110000E-03  +1.99092100E-02
   +8.12400000E-04  -1.77382700E-02  +3.38833400E-02  -6.45291500E-02  -4.68064300E-02
   -1.42107700E-02  +7.78979000E-03  +1.41693400E-02  +1.16473000E-03  +6.17410000E-04
   +2.40341000E-03  -7.86200000E-05  +1.26500000E-05  -5.52400000E-05  +1.30000000E-06
   -3.13700000E-05  -1.33900000E-05  +1.22100000E-04  +1.39040000E-04  +4.50500000E-04
   +1.00224000E-03  -2.55110000E-04  -8.35320000E-04  +2.02850000E-04  -1.34620000E-04
   +2.91090000E-04  +1.68675000E-03  -6.23130000E-04  +1.82942000E-03  -3.53462700E-02
   +5.96493400E-02  -2.65000000E-05  -1.03100000E-05  +6.38000000E-06  +8.86000000E-05
   +1.01090000E-04  -1.15700000E-05  +7.10000000E-06  -1.03900000E-05  +3.65000000E-06
   +2.03000000E-06  -1.94800000E-05  -1.15800000E-05  -3.12200000E-05  +3.49700000E-05
   -4.70000000E-07  +1.28200000E-05  -5.80000000E-07  -3.72000000E-06  +4.11700000E-05
   -1.54950000E-04  +1.95990000E-04  -2.14800000E-05  +2.93800000E-05  -7.41700000E-05
   +3.38800000E-05  -3.17600000E-05  -9.00000000E-07  +1.64468000E-03  -1.83442000E-03
   +4.60892000E-03  -1.12085000E-03  -7.85600000E-05  -3.26900000E-04  +7.45420000E-04
   -4.99527000E-03  +1.26448000E-03  +1.62033500E-02  -1.49697000E-03  -7.40785000E-03
   +1.43969710E-01  -4.78073700E-02  -1.75287800E-01  -1.37150000E-04  -8.73330000E-04
   +2.00172000E-03  -1.54748000E-03  +2.22280000E-03  -7.52360000E-04  +2.98000000E-06
   -6.81800000E-05  +2.17900000E-05  +1.00900000E-05  +1.28600000E-05  +3.90000000E-06
   -2.21660000E-04  +4.00330000E-04  -8.64100000E-05  +5.88370000E-04  -1.05480000E-04
   -5.61460000E-04  -1.87440000E-04  +2.69220000E-04  -3.66260000E-04  -1.62281000E-03
   +2.15024000E-03  -1.67930000E-03  -1.58443280E-01  +5.23291900E-02  +1.78460190E-01
   +2.79600000E-05  +1.72630000E-04  +5.29140000E-04  +6.10170000E-04  -4.54000000E-06
   -2.84480000E-04  -9.23700000E-05  +3.17300000E-05  +4.28950000E-04  +1.83020000E-04
   +2.69000000E-06  -1.93340000E-04  +7.27600000E-05  -5.30700000E-05  -6.96000000E-05
   -1.29800000E-05  +8.72900000E-05  -8.66700000E-05  -2.86706000E-03  +7.35400000E-04
   +7.27270000E-04  -8.76000000E-05  -8.55300000E-05  +6.70880000E-04  -1.06190000E-04
   +1.34200000E-04  -3.28000000E-05  +7.98790000E-04  -1.14195000E-03  +1.87160000E-04
   +2.88880000E-04  +2.49610000E-04  +1.25460000E-04  -1.83290000E-04  -8.40000000E-07
   -2.34200000E-05  +4.58000000E-06  -7.46600000E-05  -1.18880000E-04  +7.93000000E-05
   +7.03800000E-05  -7.09300000E-05  +2.06160000E-04  +2.09750000E-04  +8.39600000E-05
   +5.01100000E-05  +1.68800000E-05  +2.07800000E-05  -2.44269830E-01  +1.20552630E-01
   -6.98626000E-03  +3.19300000E-05  -2.07130000E-04  -1.96720000E-04  -1.04100000E-05
   -8.00000000E-08  -4.35000000E-06  -2.76000000E-06  +1.13000000E-05  -2.54000000E-06
   +3.58000000E-05  -6.27300000E-05  +2.73100000E-05  +2.95600000E-05  +1.31400000E-05
   -1.24600000E-05  +2.06100000E-05  +1.64400000E-05  -1.00000000E-06  +2.62026340E-01
   +8.73290000E-04  -2.98360000E-04  -4.89930000E-04  -4.36900000E-04  -6.32700000E-04
   +2.92921000E-03  +3.65000000E-05  +1.89390000E-04  +3.04610000E-04  -1.05100000E-05
   +2.07450000E-04  -7.23300000E-05  -1.71870000E-04  +8.92600000E-05  +1.18600000E-04
   -7.71000000E-06  -1.22060000E-04  +2.06260000E-04  +1.21762800E-02  -9.42109000E-03
   +7.56880000E-04  -5.78980000E-04  +2.63160000E-04  -1.30298000E-03  +1.19210000E-04
   -1.24210000E-04  -2.25300000E-05  +9.54060000E-04  +4.91860000E-04  -2.67050000E-04
   -4.78100000E-05  -4.00480000E-04  -5.10420000E-04  -2.95000000E-06  +3.18000000E-05
   -2.33000000E-05  -1.65450000E-04  -1.12840000E-04  +8.11200000E-05  -1.12490000E-04
   -2.01000000E-06  +8.00200000E-05  -3.22230000E-04  +8.11700000E-05  +4.87700000E-05
   +1.41640000E-04  +1.50860000E-04  -1.98700000E-05  +1.19353090E-01  -1.19870860E-01
   +3.43768000E-03  -6.41000000E-06  +2.11020000E-04  +2.55330000E-04  -7.90000000E-07
   -3.35900000E-05  +1.16000000E-06  +1.63600000E-05  -6.81000000E-06  +1.46600000E-05
   +4.26200000E-05  +1.53480000E-04  +1.41690000E-04  +3.15900000E-05  -1.14000000E-06
   +4.19200000E-05  +4.51000000E-06  -9.42000000E-06  +4.91000000E-06  -1.31681780E-01
   +1.28190290E-01  -1.35823000E-03  +1.11026000E-03  +6.14840000E-04  +8.90730000E-04
   +1.73686000E-03  -5.65480000E-03  +8.87140000E-04  +3.00600000E-05  -7.54720000E-04
   -1.77550000E-04  +2.41300000E-05  +3.65160000E-04  +1.37840000E-04  -1.40610000E-04
   -5.92100000E-05  +1.25900000E-05  +1.42960000E-04  -4.96010000E-04  -2.53109400E-02
   +1.58432600E-02  -3.34321000E-03  -1.28689000E-03  +1.18989000E-03  +1.19874000E-03
   -1.05140000E-04  +6.53800000E-05  +7.00400000E-05  -1.00820000E-03  -4.25130000E-04
   +7.67080000E-04  +4.23030000E-04  +8.52700000E-05  -2.75200000E-05  -4.02030000E-04
   -2.10000000E-06  +1.17900000E-04  +2.00000000E-04  -3.26500000E-05  -2.22370000E-04
   +1.63110000E-04  +1.14190000E-04  -6.02900000E-05  -2.11400000E-05  -1.35200000E-04
   +1.80750000E-04  -1.93750000E-04  -1.56030000E-04  +3.47900000E-05  -4.89809000E-03
   +2.20805000E-03  -4.57109100E-02  +6.77900000E-05  -2.17860000E-04  -3.94600000E-05
   +1.56600000E-05  +2.20000000E-05  +1.37700000E-05  +9.22000000E-06  -1.56400000E-05
   -6.20000000E-07  +2.63200000E-05  -5.54000000E-06  +5.20600000E-05  +2.21700000E-05
   -7.51000000E-06  -8.85700000E-05  -3.84000000E-06  +9.52000000E-06  +8.31000000E-06
   +6.68617000E-03  -6.07584000E-03  +5.28312800E-02  +6.92600000E-05  -2.63150000E-04
   -7.17000000E-05  +4.90900000E-05  +2.18520000E-04  +2.42810000E-04  -3.61280000E-04
   +8.71350000E-04  +3.31470000E-04  +8.76300000E-05  +1.01560000E-04  -2.43030000E-04
   -1.31590000E-04  +4.08200000E-05  +4.44600000E-05  +3.62300000E-05  +5.04000000E-06
   +3.12400000E-05  +1.74860000E-03  +2.34745000E-03  -9.08320000E-04  +2.29580000E-04
   +2.89040000E-04  -2.37640000E-04  +5.62600000E-05  -3.48400000E-05  -3.10100000E-05
   +5.07530000E-04  -4.72960000E-04  +2.79020000E-04  +2.67930000E-04  +4.06890000E-04
   +3.64830000E-04  -2.07410000E-04  -3.19000000E-06  +8.60400000E-05  +2.81140000E-04
   +1.61520000E-04  -9.36700000E-05  -5.37000000E-06  -7.68400000E-05  -5.41500000E-05
   +5.60700000E-04  -1.17400000E-04  -1.70600000E-04  -2.79650000E-04  -2.25600000E-04
   +3.60700000E-05  -2.01760940E-01  -1.27149890E-01  +3.11733500E-02  +2.71600000E-05
   +1.20340000E-04  -3.30000000E-06  +2.30700000E-05  +4.44900000E-05  +9.17000000E-06
   -2.68100000E-05  -1.68200000E-05  -1.64900000E-05  -2.32200000E-05  -1.75000000E-05
   -1.77800000E-05  -4.96400000E-05  +5.39800000E-05  +5.40000000E-07  -1.60000000E-05
   -1.52000000E-06  +3.36000000E-06  -1.91776600E-02  -1.80370600E-02  +3.74054000E-03
   +2.18603290E-01  +8.69000000E-05  -3.32500000E-05  +1.83460000E-04  -7.70020000E-04
   +4.11470000E-04  -1.54520000E-04  -5.08300000E-05  -2.77980000E-04  +9.11340000E-04
   +2.68650000E-04  +7.38700000E-05  -4.11580000E-04  -3.00400000E-05  +2.26300000E-05
   -4.77600000E-05  -8.07000000E-06  +1.03220000E-04  +4.79000000E-06  -1.07724600E-02
   -9.26345000E-03  +9.43480000E-04  +1.78700000E-04  +3.64000000E-04  -1.26753000E-03
   -3.64100000E-05  +9.57600000E-05  -6.56100000E-05  +1.67770000E-04  -4.61770000E-04
   +3.12242000E-03  -2.98600000E-04  -1.58730000E-04  +3.18340000E-04  +3.41940000E-04
   +1.56810000E-04  +6.54000000E-06  +1.02010000E-04  +5.28830000E-04  +3.89590000E-04
   -5.59300000E-04  -4.13160000E-04  -1.93400000E-04  +5.07800000E-04  -4.05280000E-04
   -2.40160000E-04  -3.81940000E-04  -3.19330000E-04  -1.79400000E-05  -1.26035550E-01
   -1.51709880E-01  +2.53226100E-02  +6.01400000E-05  -4.19100000E-05  -1.62020000E-04
   +2.87400000E-05  +4.34100000E-05  +2.24500000E-05  -1.39200000E-05  -4.76500000E-05
   -1.03300000E-05  -1.19390000E-04  +2.58720000E-04  -1.53980000E-04  +3.94700000E-05
   +6.04000000E-06  +1.04330000E-04  -8.45200000E-05  -2.10000000E-06  -3.81200000E-05
   +1.32529700E-02  +1.18934700E-02  -3.00583000E-03  +1.38659920E-01  +1.62720170E-01
   +8.07500000E-05  -7.63200000E-05  -8.06600000E-05  +3.97570000E-04  -6.64750000E-04
   +7.84940000E-04  -1.36890000E-04  -1.89730000E-04  +3.55200000E-04  -2.09540000E-04
   +1.77860000E-04  -9.36000000E-05  -8.30800000E-05  -1.12900000E-05  +1.70140000E-04
   +3.11500000E-05  -8.85700000E-05  -3.05900000E-05  +2.29528600E-02  +1.77224000E-02
   -5.30716000E-03  +1.04482000E-03  +1.00212000E-03  +1.37680000E-03  +3.78600000E-05
   -2.85600000E-05  -1.59900000E-05  -1.45380000E-03  +1.56469000E-03  -4.81634000E-03
   +9.39700000E-05  -3.63160000E-04  -4.45500000E-05  +5.69490000E-04  -4.14600000E-05
   +4.65200000E-05  -4.19510000E-04  -1.44550000E-04  +1.32320000E-04  +2.81620000E-04
   -1.31790000E-04  +3.06610000E-04  +4.90140000E-04  +7.51940000E-04  +5.19800000E-05
   +4.84100000E-04  +4.37000000E-04  -6.34000000E-05  +3.06504600E-02  +2.42843200E-02
   -5.42384000E-02  -1.65400000E-05  -1.36390000E-04  -2.50900000E-05  -1.10800000E-05
   -4.48200000E-05  -4.46200000E-05  +4.04900000E-05  +4.14400000E-05  +1.57900000E-05
   -2.57930000E-04  +3.29440000E-04  -5.94300000E-05  -5.40400000E-05  +9.49600000E-05
   -1.83070000E-04  +8.26000000E-05  +3.59200000E-05  -9.29000000E-06  -5.79310000E-04
   -7.07410000E-04  -7.96210000E-04  -3.43286600E-02  -2.95660300E-02  +5.83099900E-02
   +2.77800000E-05  +1.76000000E-06  -1.54150000E-04  +3.81710000E-04  -4.73310000E-04
   -2.55780000E-04  -4.54780000E-04  +3.43760000E-04  -9.10110000E-04  -9.67100000E-05
   +4.59700000E-05  +2.28720000E-04  -3.38600000E-05  +1.01000000E-06  +3.74200000E-05
   +2.31700000E-05  -6.94100000E-05  +1.41800000E-05  -1.99756000E-03  -2.12907000E-03
   -1.54767000E-03  -1.55060000E-04  +4.25850000E-04  -3.46240000E-04  +4.75200000E-05
   -8.17400000E-05  +3.94100000E-05  -4.59800000E-05  +6.95360000E-04  +5.10140000E-04
   -8.32900000E-05  -2.71230000E-04  +8.79900000E-05  -2.35500000E-04  -3.86200000E-05
   -1.76000000E-05  -2.67600000E-05  -1.19830000E-04  -5.27100000E-05  +1.06740000E-04
   +7.30400000E-05  +3.66100000E-05  -1.45210000E-04  -6.63200000E-05  +7.54800000E-05
   +5.17000000E-05  +4.85900000E-05  -1.43200000E-05  -4.69220200E-02  -4.80319000E-03
   -4.69129000E-03  -9.62000000E-06  +8.36900000E-05  +1.70790000E-04  -8.37000000E-06
   -2.06400000E-05  +1.17700000E-05  +2.31100000E-05  -1.11400000E-05  +2.01500000E-05
   +2.43030000E-04  -2.45540000E-04  +2.01130000E-04  +1.95700000E-05  +1.67000000E-06
   -5.35000000E-05  -1.15000000E-06  +4.72000000E-06  -9.12000000E-06  +1.47016000E-03
   +1.86189100E-02  +2.09413700E-02  -1.00680000E-04  -1.60753800E-02  -1.88531500E-02
   +4.88093400E-02  -2.74520000E-04  +3.76900000E-05  -6.56600000E-05  +2.13740000E-04
   +4.55390000E-04  -4.07070000E-04  +1.02991000E-03  +2.83840000E-04  -2.39660000E-04
   +7.08000000E-06  -1.51250000E-04  +3.26360000E-04  +9.01500000E-05  -6.99500000E-05
   -1.47510000E-04  -3.01800000E-05  +2.02700000E-05  +4.23000000E-06  -1.45770000E-04
   +9.61612000E-03  +1.05895100E-02  +2.17420000E-04  -5.91830000E-04  +1.96732000E-03
   -4.51600000E-05  +4.58000000E-06  +4.61200000E-05  +8.61600000E-05  +8.25000000E-04
   +1.63900000E-05  -4.16110000E-04  -4.49920000E-04  +8.52930000E-04  +1.46100000E-04
   -8.79900000E-05  -5.08600000E-05  -7.74100000E-05  -5.50000000E-06  -4.79600000E-05
   +2.81500000E-05  +4.20200000E-05  +8.55400000E-05  +5.05000000E-06  +4.21000000E-06
   -1.34830000E-04  +1.31310000E-04  +9.41800000E-05  -1.48700000E-05  -5.24403000E-03
   -1.72776140E-01  -1.35024460E-01  -3.55800000E-05  +3.93800000E-05  -9.15000000E-06
   -1.26900000E-05  -1.28900000E-05  -1.24400000E-05  +1.38800000E-05  +3.81000000E-06
   +2.49500000E-05  -2.24100000E-04  -1.03425000E-03  +5.22590000E-04  +8.00000000E-07
   -6.00000000E-06  +2.40800000E-05  +1.20700000E-05  -9.80000000E-07  -1.41000000E-06
   -1.70457000E-03  -1.11184800E-02  -1.13347800E-02  +1.46468000E-03  -1.27508700E-02
   -1.37479100E-02  +4.21612000E-03  +1.86983380E-01  +3.75100000E-05  -1.32000000E-05
   -2.81330000E-04  +1.12350000E-03  -1.01843000E-03  +8.92160000E-04  +4.14960000E-04
   +1.33690000E-04  -5.03800000E-05  -3.44700000E-04  +3.08440000E-04  +2.42730000E-04
   -4.32800000E-05  -1.38060000E-04  +1.63340000E-04  +7.39300000E-05  +6.40000000E-07
   -4.40500000E-05  -9.16000000E-06  -2.04909000E-02  -1.95820200E-02  -2.52790000E-04
   +4.15252000E-03  -5.74968000E-03  -2.08300000E-05  -3.30000000E-07  +2.57400000E-05
   -1.46463000E-03  -9.94480000E-04  +8.74090000E-04  +2.69840000E-04  -6.42270000E-04
   -1.35080000E-04  +5.73830000E-04  +4.04990000E-04  +1.60600000E-04  -2.27350000E-04
   +4.23780000E-04  +4.34080000E-04  -4.55900000E-04  -4.52740000E-04  -6.11500000E-05
   +8.44250000E-04  +7.37900000E-05  -2.82460000E-04  -9.72200000E-05  -4.71600000E-05
   -1.01000000E-05  -4.27979000E-03  -1.32590020E-01  -1.91169730E-01  -8.63400000E-05
   +3.70180000E-04  +3.27530000E-04  +2.78700000E-05  +1.80200000E-05  -2.94000000E-06
   +3.93000000E-05  +8.90000000E-07  -9.54000000E-06  -1.96910000E-04  +8.20290000E-04
   +4.68600000E-05  -1.51340000E-04  +1.41400000E-05  +8.89200000E-05  -9.29000000E-06
   +1.41700000E-05  -2.32900000E-05  +1.42040000E-04  +1.43774000E-03  +1.06079000E-03
   -1.93500000E-04  +4.63231000E-03  +4.44766000E-03  +4.94304000E-03  +1.45228880E-01
   +2.08915650E-01  +4.22330000E-04  +1.67914000E-03  +1.30253000E-03  +2.42540000E-04
   -5.64350000E-04  +2.93780000E-04  -2.92210000E-04  +2.30370000E-04  +2.66900000E-05
   +1.36480000E-04  -2.20450000E-04  +1.62300000E-04  -1.01940000E-04  +1.60980000E-04
   -1.70560000E-04  -1.41980000E-04  -1.49900000E-04  -2.64250000E-04  -1.89049000E-03
   -6.40000000E-05  -3.79600000E-04  -4.60654400E-02  +1.27250000E-03  -3.08475000E-03
   +2.39310000E-04  -1.79170000E-04  -8.25000000E-06  +1.16770000E-04  +4.02760000E-04
   -3.49930000E-04  -7.21600000E-05  -3.05500000E-05  -1.65900000E-05  +1.23190000E-04
   +1.29470000E-04  +7.80000000E-06  -8.32100000E-05  -3.50500000E-05  +4.97200000E-05
   -1.01850000E-04  +9.90600000E-05  +2.39830000E-04  -1.07780000E-04  -5.15700000E-04
   -6.89130000E-04  +1.16080000E-04  +1.40330000E-04  +1.42800000E-05  -1.29000000E-04
   -2.68800000E-05  -1.97940000E-04  -1.25705000E-03  -1.70570000E-04  -1.39045000E-03
   -9.04000000E-06  -1.47500000E-05  -9.60000000E-07  +1.68500000E-05  +1.95300000E-05
   +1.39200000E-05  +1.09000000E-06  +5.25700000E-05  +5.34600000E-05  -1.65640000E-03
   -2.21740000E-04  -3.75310000E-04  -1.01200000E-05  -6.41000000E-06  -2.25400000E-05
   +3.27470000E-04  -2.51810000E-04  +2.69540000E-04  +1.54550000E-04  +2.64630000E-04
   -3.05110000E-04  +6.92910000E-04  +6.00100000E-05  -2.96900000E-05  +4.87786300E-02
   +8.13640000E-04  -1.10314000E-03  -7.60440000E-04  -3.41820000E-04  +1.11992000E-03
   +3.20630000E-04  +2.34250000E-04  -8.83700000E-05  -3.79700000E-05  -1.27320000E-04
   +1.18220000E-04  -7.45300000E-05  +2.80000000E-05  -1.08090000E-04  +7.91000000E-05
   -1.23150000E-04  -7.60700000E-05  +1.24110000E-04  -2.83190000E-04  +1.04441500E-02
   -2.31787500E-02  +5.40710000E-04  -8.38265400E-02  +9.32746300E-02  -1.39980000E-04
   +1.30980000E-04  +3.25500000E-05  +3.31170000E-04  +1.16550000E-03  +3.56500000E-04
   +2.22850000E-04  -1.78640000E-04  +8.69000000E-06  +1.59540000E-04  +7.09000000E-05
   -5.36600000E-05  -1.16000000E-04  +7.09400000E-05  +1.98660000E-04  -6.74400000E-05
   -2.53590000E-04  -9.61700000E-05  -7.04640000E-04  +1.93570000E-04  +1.44240000E-04
   +4.23600000E-05  -3.25000000E-06  -2.85800000E-05  -5.03500000E-05  -3.82883000E-03
   -3.03014000E-03  +1.85375000E-03  -2.04879000E-03  +1.10862000E-03  -1.10700000E-05
   -6.60000000E-06  -6.26000000E-06  +6.80000000E-07  +1.71800000E-05  -1.97300000E-05
   -2.61400000E-05  +4.63700000E-05  -3.88300000E-05  -5.36460000E-04  -1.93530000E-04
   -2.66250000E-04  -2.56000000E-05  +2.65300000E-05  -2.77700000E-05  -2.62700000E-04
   -6.62800000E-05  -2.71200000E-05  +2.69840000E-04  -1.42800000E-05  -7.63500000E-05
   -1.19090000E-04  +7.31120000E-04  -1.63456000E-03  -8.56320000E-04  +9.05072200E-02
   +6.61260000E-04  -9.64080000E-04  -5.35750000E-04  -5.45510000E-04  +3.06800000E-04
   +2.83290000E-04  +4.12970000E-04  -1.05980000E-04  -1.77100000E-04  -1.88930000E-04
   +2.14870000E-04  -8.18300000E-05  -3.83600000E-05  -9.73700000E-05  +2.05080000E-04
   +4.34500000E-05  -1.09950000E-04  +1.16000000E-06  -1.27140000E-04  +8.40677000E-03
   -1.82480300E-02  -6.21520000E-04  +9.02287500E-02  -2.91329000E-01  -4.93100000E-05
   +5.52200000E-05  +7.49000000E-06  +7.61910000E-04  +9.66970000E-04  +6.57630000E-04
   -4.18700000E-05  -4.20350000E-04  +3.51500000E-05  +1.90450000E-04  +1.81140000E-04
   -1.73800000E-05  -1.00380000E-04  +1.44430000E-04  +7.53400000E-05  -2.68720000E-04
   -3.00000000E-07  +3.06860000E-04  +6.23630000E-04  -2.55080000E-04  +1.32000000E-05
   +3.16700000E-05  +5.77500000E-05  +2.25100000E-05  +1.03560000E-04  -4.37221000E-03
   -2.29713000E-03  -2.99292000E-03  +2.82198000E-03  -7.11000000E-04  -6.38000000E-06
   -2.40000000E-07  -5.91000000E-06  -1.84100000E-05  +1.98700000E-05  -2.26600000E-05
   -1.55300000E-05  +1.00350000E-04  +3.84600000E-05  -4.74610000E-04  +2.56950000E-04
   +2.80580000E-04  -2.35000000E-06  -3.98700000E-05  +9.46000000E-06  +2.26800000E-05
   -3.09400000E-05  +2.51030000E-04  +3.59600000E-05  -2.52400000E-05  +3.22080000E-04
   -1.24130000E-04  +5.11610000E-04  -1.27971000E-03  +3.07435000E-03  -9.87537600E-02
   +3.15816940E-01  -7.87700000E-05  -1.27680000E-04  +2.02900000E-05  +7.09430000E-04
   +9.21580000E-04  -1.73270000E-04  +3.33150000E-04  -2.80440000E-04  +3.82900000E-05
   -8.43000000E-06  -2.14600000E-05  -9.98900000E-05  -4.22200000E-05  +4.89400000E-05
   -1.12000000E-06  +4.82000000E-06  +1.19000000E-06  +1.06300000E-05  -6.14730000E-04
   +1.09943000E-03  +7.65870000E-04  -2.33514920E-01  -1.21298300E-01  +3.03669600E-02
   +4.62900000E-05  -3.16000000E-05  +4.86000000E-06  +6.57020000E-04  +1.41690000E-04
   +2.34560000E-04  +1.59220000E-04  +1.75610000E-04  +2.47350000E-04  -1.16370000E-04
   -7.81900000E-05  -7.78600000E-05  +1.14630000E-04  +6.84000000E-05  -4.75100000E-05
   +1.96310000E-04  -1.65690000E-04  -1.98730000E-04  -1.81920000E-04  +1.57320000E-04
   +4.54350000E-04  -1.64360000E-04  -1.70090000E-04  -1.53800000E-05  -1.58060000E-04
   +2.03830000E-04  +2.67210000E-04  +1.43020000E-04  +3.73850000E-04  -1.23200000E-04
   +1.53900000E-05  +2.35800000E-05  +3.47000000E-06  -3.04900000E-05  -6.68000000E-06
   -2.34500000E-05  +7.79700000E-05  -6.33400000E-05  -4.14100000E-05  +1.30950000E-04
   -1.71340000E-04  -5.11730000E-04  -2.80000000E-06  +5.60000000E-07  +1.92000000E-05
   -5.23000000E-06  -1.22090000E-04  +8.32400000E-05  +2.91570000E-04  +1.37470000E-04
   -5.46510000E-04  +2.72820000E-04  +2.37310000E-04  -1.06270000E-04  +3.63950000E-04
   +1.28455000E-03  -4.72930000E-04  +2.50865330E-01  -3.29420000E-04  -6.63980000E-04
   -3.76630000E-04  -1.14887000E-03  +6.18360000E-04  +6.73910000E-04  +8.09000000E-05
   +2.06760000E-04  +2.48700000E-05  +1.44340000E-04  -2.28420000E-04  +2.71500000E-05
   +1.33560000E-04  -7.04200000E-05  -1.50610000E-04  +9.05000000E-06  +1.38810000E-04
   +1.89070000E-04  -2.00635400E-02  -1.51852300E-02  +3.44335000E-03  -1.19629840E-01
   -1.23596360E-01  +2.01668500E-02  -8.33200000E-05  +9.01500000E-05  +1.83000000E-06
   +1.28264000E-03  -2.72218000E-03  -4.04046000E-03  -1.46943000E-03  -3.88820000E-04
   +4.12720000E-04  -1.97100000E-05  -3.93550000E-04  -1.63270000E-04  +2.92570000E-04
   +1.06010000E-04  -1.00760000E-04  -1.15470000E-04  +1.15070000E-04  +4.65100000E-05
   +5.72860000E-04  +2.70800000E-05  -5.83800000E-04  -2.69040000E-04  -1.87310000E-04
   +5.50900000E-05  +9.41500000E-05  +3.34210000E-04  +1.32843000E-03  +2.28520000E-04
   +9.56350000E-04  -1.70290000E-04  +3.64500000E-05  +4.03800000E-05  +8.79000000E-06
   -1.02060000E-04  -1.32320000E-04  +3.15800000E-05  +1.29500000E-05  +2.20000000E-05
   -8.06600000E-05  +2.02210000E-04  +6.63900000E-05  +2.99630000E-04  -4.99200000E-05
   -8.25000000E-06  -5.30000000E-06  +1.31920000E-04  +3.83700000E-05  -6.85400000E-05
   +1.59170000E-04  +6.04710000E-04  -4.12580000E-04  +3.30920000E-04  +6.09400000E-05
   +7.47700000E-05  -9.27671000E-03  -6.24616000E-03  +9.04930000E-04  +1.31880090E-01
   +1.35195590E-01  +3.21380000E-04  +2.89350000E-04  +2.79640000E-04  -4.83600000E-04
   +5.77080000E-04  +7.07830000E-04  -1.87990000E-04  +2.62050000E-04  +7.91100000E-05
   +1.08890000E-04  -1.97500000E-04  +5.24600000E-05  +3.52000000E-05  +3.26000000E-05
   -1.66190000E-04  -1.36780000E-04  -6.02700000E-05  +6.62000000E-06  -1.86514700E-02
   -1.22116100E-02  +1.24941000E-03  +3.16759900E-02  +2.13688800E-02  -5.15554600E-02
   +5.91000000E-06  +1.62000000E-05  +7.17000000E-06  +9.66750000E-04  -2.69878000E-03
   -3.10951000E-03  -1.14270000E-03  -8.10000000E-04  +5.03190000E-04  +1.15700000E-04
   -1.75700000E-04  -2.15690000E-04  +5.65900000E-05  +1.00610000E-04  -1.09700000E-05
   -1.73490000E-04  +3.01900000E-05  +2.62970000E-04  +8.44960000E-04  -2.69870000E-04
   -4.29740000E-04  -6.60800000E-05  -3.82000000E-06  +3.66100000E-05  -1.13870000E-03
   -7.02470000E-04  +1.08793000E-03  -3.71200000E-05  -1.14831000E-03  -4.84000000E-05
   +1.25700000E-05  +1.35800000E-05  -1.41000000E-06  -1.05540000E-04  -5.39800000E-05
   -2.02600000E-05  +1.16600000E-05  +2.39000000E-05  +1.86800000E-05  -1.97640000E-04
   +5.28610000E-04  +1.33250000E-04  -1.13300000E-05  -2.98200000E-05  +1.37500000E-05
   +1.76000000E-05  -5.00000000E-07  -6.27200000E-05  +2.75440000E-04  +5.06200000E-05
   -6.85170000E-04  +2.35180000E-04  +2.12900000E-04  +2.22500000E-04  +2.59833700E-02
   +1.57256200E-02  -2.84693000E-03  -3.39640900E-02  -1.84649100E-02  +5.49473900E-02
   -1.94850000E-04  -3.73150000E-04  -1.14670000E-04  +5.95310000E-04  +3.05600000E-04
   +5.20750000E-04  +4.94450000E-04  +1.24630000E-04  -2.37820000E-04  -1.08950000E-04
   +7.38000000E-06  +4.13900000E-05  +1.74750000E-04  -1.57840000E-04  -3.44900000E-05
   -2.47000000E-06  +8.02800000E-05  +7.50600000E-05  +1.47250000E-04  -1.00175000E-03
   -1.21040000E-04  -2.13005720E-01  +1.25470220E-01  -2.73617200E-02  -1.66160000E-04
   +1.64450000E-04  +1.02300000E-05  +8.38400000E-05  -9.93300000E-05  +2.16170000E-04
   +1.40200000E-04  +1.07900000E-04  -1.83700000E-05  +3.44900000E-05  +5.74000000E-06
   -1.99100000E-05  -1.61170000E-04  -7.98000000E-06  -9.04000000E-06  +1.28530000E-04
   -1.31980000E-04  -1.74640000E-04  -5.04140000E-04  -7.09460000E-04  +7.77490000E-04
   +9.32800000E-05  +4.04200000E-05  -2.80400000E-05  +2.73270000E-04  -4.86200000E-04
   -5.22440000E-04  -5.24500000E-05  +7.19450000E-04  -2.75660000E-04  -1.60000000E-05
   -1.07200000E-05  -6.37000000E-06  +1.13500000E-05  +2.32300000E-05  -7.39000000E-06
   -1.55300000E-05  -5.35000000E-06  -9.92000000E-06  -6.93850000E-04  -1.52953000E-03
   +1.79300000E-04  +3.87500000E-05  -3.78000000E-06  +2.78400000E-05  +4.25480000E-04
   -1.26490000E-04  +3.32750000E-04  -1.84720000E-04  +1.43450000E-04  +3.44500000E-05
   +2.59750000E-04  -2.66300000E-04  +6.64000000E-05  +4.27830000E-04  -1.68847000E-03
   +3.13420000E-04  -1.95821900E-02  +1.65826000E-02  -4.13883000E-03  +2.31143490E-01
   -7.89800000E-05  +3.05370000E-04  -9.57300000E-05  -1.46962000E-03  -1.88644000E-03
   -4.01766000E-03  +7.33080000E-04  -6.46880000E-04  +4.52640000E-04  +4.42380000E-04
   +2.03340000E-04  -2.37910000E-04  -2.16560000E-04  +2.32960000E-04  +4.11200000E-05
   +1.67000000E-05  -1.04620000E-04  -8.20000000E-06  +2.00635700E-02  -1.58536000E-02
   +2.99882000E-03  +1.24099890E-01  -1.41407630E-01  +2.13236700E-02  +1.78730000E-04
   -1.97840000E-04  +2.51000000E-06  +6.50960000E-04  +8.75190000E-04  +4.35200000E-04
   -3.07860000E-04  -1.39100000E-04  -2.01670000E-04  +1.93930000E-04  +1.92370000E-04
   -3.49000000E-06  -9.16200000E-05  +1.92100000E-05  +1.34390000E-04  -3.30840000E-04
   +1.67380000E-04  +2.47810000E-04  -5.47000000E-06  -4.14830000E-04  -5.29490000E-04
   +1.02570000E-04  +1.39360000E-04  +2.16500000E-05  +3.59310000E-04  +6.22600000E-04
   +1.71527000E-03  +5.46970000E-04  +1.67180000E-04  +1.75310000E-04  -3.93000000E-06
   -1.94100000E-05  +2.09000000E-06  +2.21000000E-05  -4.16000000E-06  +2.81600000E-05
   +4.63200000E-05  +7.65500000E-05  +1.20390000E-04  -1.03658000E-03  -1.05382000E-03
   +9.90040000E-04  -6.92000000E-06  -3.88600000E-05  +1.69000000E-06  -4.14580000E-04
   +6.04840000E-04  -6.04360000E-04  -1.35610000E-04  -1.55700000E-05  -1.21200000E-04
   -3.79530000E-04  +1.02360000E-04  +2.27800000E-04  +8.04734000E-03  -6.69376000E-03
   +1.57860000E-04  -1.41113400E-02  +1.15628900E-02  -2.74115000E-03  -1.36957980E-01
   +1.53577170E-01  +5.63200000E-05  -9.52190000E-04  -8.16590000E-04  -1.33080000E-03
   -2.33446000E-03  -2.96550000E-03  +1.24645000E-03  -7.00300000E-04  +1.15080000E-04
   +9.66300000E-05  +5.93220000E-04  -2.80210000E-04  -1.50130000E-04  -1.20100000E-05
   +3.46650000E-04  +1.87000000E-04  -1.69200000E-05  +3.07300000E-05  +1.81028700E-02
   -1.40916100E-02  +6.44350000E-04  -2.79221500E-02  +2.26334000E-02  -5.24429200E-02
   -2.14600000E-05  -1.40400000E-05  -1.54000000E-05  -2.60000000E-05  +6.72030000E-04
   +5.13190000E-04  +2.23600000E-05  +4.98000000E-06  -2.46160000E-04  +1.00860000E-04
   +4.02700000E-05  -4.69000000E-05  -1.31070000E-04  +6.70900000E-05  +1.31340000E-04
   -2.83300000E-05  -2.29270000E-04  -1.63240000E-04  -3.67210000E-04  +4.45860000E-04
   +5.45860000E-04  +3.92500000E-05  -8.25000000E-06  -3.96100000E-05  +1.35578000E-03
   -9.96100000E-04  +7.97030000E-04  -1.34692000E-03  +1.84921000E-03  +2.96200000E-05
   -5.98000000E-06  -1.34600000E-05  +4.00000000E-08  +2.37200000E-05  -9.54000000E-06
   +1.01800000E-05  +3.82300000E-05  -2.44000000E-05  +1.03900000E-05  +3.53260000E-04
   +4.37580000E-04  -1.76570000E-04  +1.53700000E-05  +2.66000000E-06  +1.47300000E-05
   -4.45130000E-04  -2.27060000E-04  -8.16540000E-04  +5.24000000E-05  +1.09940000E-04
   -6.41400000E-05  -1.07070000E-04  +2.22080000E-04  +3.51460000E-04  -2.40420900E-02
   +1.65068400E-02  -8.01010000E-04  +3.94081000E-03  -3.15082000E-03  -3.70010000E-04
   +3.03154500E-02  -2.05201600E-02  +5.57605300E-02  -3.55150000E-04  +4.93028000E-03
   +2.14052000E-03  +9.55749000E-03  -1.17229400E-02  +1.50377800E-02  -5.91639800E-02
   +2.37970100E-02  -1.51255600E-02  +3.33579000E-03  +1.12460200E-02  -1.98411200E-02
   -4.34980000E-04  +4.63984000E-03  +7.67150000E-04  -8.84320000E-04  -7.67200000E-05
   +6.23890000E-04  -7.52460000E-04  -2.57184000E-03  -1.04792000E-03  +5.22500000E-04
   -5.00800000E-05  -1.98350000E-04  +6.04500000E-05  +8.63070000E-04  -9.01310000E-04
   -4.01440000E-04  +2.25820000E-04  -6.88200000E-05  -9.51100000E-05  +1.66810000E-04
   +8.46100000E-05  +3.54300000E-05  -1.72900000E-05  -6.70300000E-05  -5.33200000E-05
   -2.27000000E-05  +2.76700000E-05  +2.48100000E-05  -1.17900000E-05  +2.92700000E-05
   -2.84700000E-05  -1.52400000E-05  -8.85400000E-05  +6.38500000E-05  +4.07200000E-05
   -1.68600000E-05  -2.25939000E-03  +1.46457000E-03  +8.08900000E-04  +6.82290000E-04
   -2.36220000E-04  +2.15807000E-03  -1.29100000E-05  -1.34100000E-05  +3.71000000E-06
   +2.31000000E-06  +3.03000000E-06  +6.51000000E-06  +6.00800000E-05  -9.36700000E-05
   +1.54400000E-05  -5.01000000E-06  -5.41000000E-06  -1.28000000E-06  +6.84000000E-06
   -9.53000000E-06  +3.77000000E-06  +8.42800000E-05  -2.84280000E-04  -3.48200000E-05
   -6.83540000E-04  +9.95200000E-04  -2.75900000E-05  -2.07806000E-03  +5.04250000E-04
   -5.61590000E-04  +4.64000000E-05  -8.46500000E-05  -9.54900000E-05  +3.36600000E-05
   -1.90700000E-05  +4.19300000E-05  -2.76000000E-05  -7.67100000E-05  -5.10600000E-05
   +5.39251900E-02  +3.95890000E-03  +4.70639000E-03  -1.42280000E-04  +9.28680000E-04
   +5.60173000E-03  -4.84221000E-03  +1.77827600E-02  -1.26862480E-01  +1.34385990E-01
   +3.19058000E-03  -1.03749200E-02  +1.88268000E-02  +5.42744000E-03  +1.88685000E-03
   -4.92170000E-04  -4.74360000E-04  -1.54140000E-04  -2.88820000E-04  -1.44904000E-03
   -3.05877000E-03  -9.15930000E-04  +6.11520000E-04  -3.09870000E-04  +9.50000000E-07
   +2.42450000E-04  -7.59490000E-04  +1.03691000E-03  -3.71610000E-04  +5.29310000E-04
   +2.61340000E-04  -1.34360000E-04  +1.05000000E-04  +1.59930000E-04  +2.65500000E-05
   -5.20800000E-05  -5.40600000E-05  +2.55300000E-05  +7.30700000E-05  +1.87100000E-05
   -1.55700000E-05  -5.22900000E-05  +1.34100000E-05  -1.13840000E-04  -1.47680000E-04
   -1.01720000E-04  -5.21200000E-05  -6.48100000E-05  -1.28000000E-05  +2.58827000E-03
   -3.38410000E-04  -2.77020000E-04  +2.88270000E-04  -9.57500000E-05  +1.74913000E-03
   -6.97000000E-06  +4.64000000E-06  +9.98000000E-06  -1.28800000E-05  -1.60200000E-05
   +6.66000000E-06  -4.79300000E-05  -9.76800000E-05  +3.59000000E-05  +1.65900000E-05
   +4.50000000E-06  -1.63700000E-05  -1.17400000E-05  -1.69800000E-05  +5.40000000E-06
   -6.31300000E-05  -2.63820000E-04  -4.60410000E-04  +1.35477000E-03  -1.38822000E-03
   +6.31700000E-05  +8.37700000E-05  -2.51400000E-04  -2.14970000E-04  -8.43000000E-06
   -1.18000000E-06  +2.41100000E-05  -4.34000000E-06  -4.06000000E-06  -7.23000000E-06
   -3.75600000E-05  -8.96300000E-05  -1.73890000E-04  -3.15658800E-02  +1.32694080E-01
   +5.74575000E-03  +1.61346000E-03  +2.56740000E-04  -1.91211000E-03  +1.33158300E-02
   -1.89424900E-02  -1.82173300E-02  +1.33567320E-01  -2.53578710E-01  +2.15459000E-03
   -1.39319000E-03  +2.33552000E-03  +1.54268000E-03  +4.40260000E-04  +1.82581000E-03
   +1.58500000E-05  -6.46810000E-04  +2.91360000E-04  -2.35831000E-03  -5.96220000E-04
   -1.32239000E-03  +5.13050000E-04  -1.37800000E-04  +7.74900000E-05  -1.16520000E-04
   +1.96880000E-04  +4.45000000E-06  -2.31430000E-04  +1.84830000E-04  +1.98250000E-04
   +3.05900000E-05  -3.58000000E-05  +8.49000000E-06  -4.21000000E-06  -9.57000000E-06
   +3.96900000E-05  +1.55500000E-05  +4.34700000E-05  -1.37000000E-06  -2.67800000E-05
   -4.06500000E-05  +1.43500000E-05  -3.29300000E-05  -6.95900000E-05  -1.73500000E-05
   -5.16200000E-05  -5.01800000E-05  +7.94000000E-06  -1.07186000E-03  +8.46160000E-04
   +3.48490000E-04  -2.36780000E-04  -4.52920000E-04  +2.53780000E-04  -2.00000000E-06
   +1.07600000E-05  -2.62000000E-06  -8.78000000E-06  -3.45000000E-06  -8.89000000E-06
   +7.35000000E-06  +6.31100000E-05  -3.44300000E-05  -3.09000000E-06  +1.51200000E-05
   -1.25800000E-05  -1.12700000E-05  -3.13000000E-06  -4.40000000E-07  -5.39720000E-04
   -1.16250000E-04  +4.88950000E-04  -3.10310000E-04  -6.63100000E-04  +1.90400000E-04
   -4.66870000E-04  +5.49040000E-04  +4.08230000E-04  -7.49900000E-05  +3.52800000E-05
   +7.52300000E-05  +4.57000000E-06  -3.90700000E-05  -5.38100000E-05  +5.84900000E-05
   -1.40990000E-04  -9.61700000E-05  +1.70871200E-02  -1.46290760E-01  +2.68310980E-01
   -4.06810000E-04  -2.09090000E-04  -4.37310000E-04  -9.82670000E-04  +4.38173000E-03
   -1.08380000E-04  -7.73517000E-03  +3.02320000E-04  +1.67691800E-02  -1.65855300E-01
   +2.94131900E-02  +1.49609550E-01  +4.59278000E-03  +1.96448000E-03  -2.05708000E-03
   +1.54127000E-03  +1.34663000E-03  -3.47590000E-04  -7.44400000E-05  -3.96210000E-04
   +6.98370000E-04  -9.77300000E-05  +6.55600000E-05  -9.73000000E-06  -1.86890000E-04
   -1.31301000E-03  -6.82810000E-04  -1.62100000E-05  +1.94550000E-04  +1.13600000E-05
   -4.01500000E-05  +3.47700000E-05  +7.05700000E-05  -1.64400000E-05  -1.73300000E-05
   +1.49000000E-06  +3.67300000E-05  +3.52300000E-05  +9.80000000E-07  -5.85000000E-06
   -1.95500000E-05  +2.58000000E-06  -3.99200000E-05  -5.55100000E-05  -5.04500000E-05
   -4.86500000E-05  -4.60600000E-05  -2.58000000E-06  -1.69200000E-05  -3.48200000E-05
   +3.84400000E-05  +8.28200000E-05  +4.26000000E-06  -5.16400000E-05  -1.00000000E-07
   +7.43000000E-06  +6.16000000E-06  -1.54000000E-05  -1.34700000E-05  +5.50000000E-07
   +2.20700000E-05  +2.54300000E-05  +1.39000000E-06  +9.30000000E-06  +5.01000000E-06
   -8.03000000E-06  -5.10000000E-06  -7.73000000E-06  +2.94000000E-06  -7.05000000E-06
   +2.41800000E-05  -1.90900000E-05  +2.27000000E-05  +5.05000000E-06  -8.00000000E-08
   -1.62900000E-05  +1.64700000E-05  -1.21200000E-05  +2.40000000E-06  -5.39000000E-06
   -7.33000000E-06  +1.27800000E-05  +6.21000000E-06  +1.42000000E-06  -2.64100000E-05
   +6.54900000E-05  +1.78400000E-05  -5.52420000E-04  -1.59643000E-03  -9.60350000E-04
   +1.69806620E-01  -2.61100000E-04  -6.80080000E-04  +1.36300000E-05  +4.87053000E-03
   -6.71670000E-04  +2.12581000E-03  +1.23907700E-02  +3.25807000E-03  -1.70677100E-02
   +3.05941400E-02  -4.85462000E-02  -1.08574200E-02  -1.22172600E-02  +7.00489000E-03
   +1.42290100E-02  +1.85866000E-03  -1.89067000E-03  +3.77326000E-03  +2.42680000E-04
   +5.25500000E-05  -8.88600000E-04  +2.63640000E-04  -9.25000000E-06  +1.23310000E-04
   -1.19111000E-03  +2.25900000E-04  -1.44274000E-03  +7.32300000E-05  -1.88690000E-04
   +2.88200000E-05  -1.23300000E-05  +3.66900000E-05  +4.87400000E-05  +2.00300000E-05
   +5.14000000E-06  -2.40500000E-05  -4.03300000E-05  -2.43300000E-05  +8.56000000E-06
   +7.66000000E-06  +2.19900000E-05  -1.73000000E-05  +2.48300000E-05  +4.38800000E-05
   -2.39800000E-05  +5.40100000E-05  +3.79000000E-05  -7.00000000E-06  -6.01600000E-05
   +6.82000000E-05  -8.61000000E-05  -4.20300000E-05  +1.58970000E-04  -2.20230000E-04
   -7.23000000E-06  -6.17000000E-06  +6.40000000E-07  -7.90000000E-07  +3.62000000E-06
   +3.67000000E-06  +9.74000000E-06  -5.60000000E-07  -3.13000000E-06  +2.80000000E-07
   -1.16300000E-05  +6.83000000E-06  +9.74000000E-06  +1.22000000E-06  -1.54000000E-06
   +1.04600000E-05  -1.50500000E-05  +3.48400000E-05  -1.77000000E-06  -2.89900000E-05
   +1.98000000E-06  -1.46000000E-06  +3.79400000E-05  +2.84000000E-05  +5.90000000E-06
   -5.08000000E-06  -1.23900000E-05  -2.10700000E-05  -7.90000000E-07  +3.99000000E-06
   +4.23000000E-06  -7.49400000E-05  -6.83400000E-05  -1.84656000E-03  -1.15566000E-03
   -8.30520000E-04  -3.39664000E-02  +4.21384600E-02  -7.98630000E-04  +2.23100000E-04
   +2.22950000E-04  -4.45780000E-04  +1.76905000E-03  +2.06361000E-03  -2.33152000E-03
   +1.44877000E-03  +5.18796000E-03  +1.49096140E-01  -9.35398000E-03  -2.21566500E-01
   +1.85106700E-02  -5.60634000E-03  -1.29566600E-02  -6.94140000E-04  +4.07747000E-03
   -2.24348000E-03  -1.83160000E-04  -1.30170000E-04  +7.52200000E-05  +6.16500000E-05
   +3.83400000E-05  +2.85900000E-05  -1.01179000E-03  -1.16681000E-03  +1.14284000E-03
   -1.21000000E-06  +2.76300000E-05  +2.61500000E-05  +1.28000000E-06  +1.47000000E-05
   +2.43400000E-05  +8.29000000E-06  -1.34700000E-05  -8.47000000E-06  -2.41900000E-05
   -1.09900000E-05  +3.39000000E-06  +6.00000000E-08  +3.21000000E-06  +5.83000000E-06
   -9.50000000E-06  -4.61000000E-06  -8.11000000E-06  +2.52300000E-05  +1.65200000E-05
   -3.03000000E-06  +2.54600000E-05  -1.56800000E-05  -2.00200000E-05  +8.94600000E-05
   -1.32110000E-04  -7.64900000E-05  -5.82000000E-06  -3.89000000E-06  -9.60000000E-07
   -1.17000000E-06  +1.36000000E-06  -1.40000000E-07  +4.52000000E-06  -2.41000000E-06
   -1.27500000E-05  -1.90000000E-06  +1.33000000E-06  -1.08000000E-06  +1.03000000E-06
   -1.48000000E-06  -4.50000000E-07  +1.25100000E-05  -1.49000000E-06  +1.38000000E-06
   +1.31500000E-05  +1.21400000E-05  +1.36000000E-06  -1.72300000E-05  +6.93000000E-06
   -6.31000000E-06  -8.02000000E-06  +1.97000000E-06  -8.91000000E-06  -1.36000000E-06
   +5.65000000E-06  +5.37000000E-06  -8.39000000E-06  +3.65000000E-06  -1.44200000E-05
   -6.36510000E-04  -1.46020000E-03  +2.19940000E-04  -1.62181000E-01  +1.06030800E-02
   +2.28410700E-01  +1.13600000E-05  +1.15936800E-02  -1.85245800E-02  -2.17952000E-03
   +3.51502000E-03  +2.36285000E-03  -2.75550000E-04  +2.00490000E-04  -8.69750000E-04
   -2.95220000E-04  +3.81919000E-03  +4.53269000E-03  +5.49555000E-03  -1.00570300E-02
   +1.82034700E-02  -4.51601900E-02  +2.45712500E-02  -8.62179000E-03  +4.77710000E-04
   +5.13210000E-04  -1.10778000E-03  +5.61000000E-05  -9.37300000E-05  -1.12000000E-05
   -2.13050000E-04  -4.41397000E-03  -2.05912000E-03  +1.91570000E-04  +6.78100000E-05
   -1.84200000E-05  +2.08200000E-05  -5.84000000E-06  +2.36100000E-05  -1.44600000E-05
   -4.65800000E-05  +3.79200000E-05  +3.13300000E-05  +3.67500000E-05  +2.06000000E-06
   -1.36600000E-05  -3.27500000E-05  +3.26000000E-06  +9.75000000E-06  -2.29600000E-05
   +2.40000000E-06  -5.57600000E-05  -6.95300000E-05  +1.85800000E-05  -3.86570000E-04
   +1.58560000E-04  +4.64400000E-05  +2.40580000E-04  -4.46780000E-04  +6.19410000E-04
   -1.31900000E-05  +1.63100000E-05  -1.27500000E-05  -2.23200000E-05  -5.57000000E-06
   -2.35100000E-05  +1.44800000E-05  +3.82100000E-05  -1.69400000E-05  +1.15600000E-05
   +5.51000000E-06  -8.83000000E-06  -1.42000000E-05  +3.01000000E-06  -4.11000000E-06
   -4.40300000E-05  +5.49600000E-05  -1.30930000E-04  +7.19000000E-06  -2.18800000E-05
   +2.72600000E-05  +1.45400000E-05  -5.00000000E-06  -2.44500000E-05  +2.33000000E-05
   +2.31000000E-06  +5.58000000E-06  -6.63000000E-06  +1.55000000E-06  +1.16800000E-05
   -1.73900000E-05  +1.85500000E-05  -7.69000000E-06  -1.26510000E-04  -2.99530000E-04
   -2.10170000E-04  +1.28040000E-04  -7.15090000E-04  +6.26610000E-04  +4.14650400E-02
   +6.25740000E-04  -1.06831000E-02  +1.89788400E-02  +3.50884000E-03  -1.37299000E-03
   -1.71948000E-03  +1.31020000E-04  -6.44600000E-05  -8.70190000E-04  +2.26739000E-03
   +3.49674000E-03  +4.40360000E-04  +3.72074000E-03  +4.02130000E-03  -1.01508000E-03
   +2.25029400E-02  -1.47672660E-01  +1.40921040E-01  -3.46590000E-04  -1.04390000E-04
   +1.20117000E-03  -7.10100000E-05  +1.66760000E-04  +7.67900000E-05  -3.16859000E-03
   -4.73570000E-04  -2.85562000E-03  -9.43800000E-05  -1.01340000E-04  +3.91000000E-06
   +1.56600000E-05  -4.32000000E-06  -4.49000000E-06  +2.86400000E-05  -1.51100000E-05
   -2.15100000E-05  -9.36600000E-05  -7.73300000E-05  +6.06000000E-06  +2.59300000E-05
   +4.76500000E-05  -6.80000000E-07  -1.46400000E-05  +2.82200000E-05  +4.54800000E-05
   +1.15610000E-04  +9.13900000E-05  -1.56900000E-05  +4.07340000E-04  -1.82360000E-04
   -1.19570000E-04  -1.29401000E-03  +2.42063000E-03  -8.13080000E-04  -1.49100000E-05
   -1.64200000E-05  -1.53000000E-06  +3.11000000E-06  +1.08300000E-05  +1.51000000E-06
   -5.55000000E-06  -1.14900000E-05  -2.66600000E-05  -1.10000000E-06  -1.17000000E-05
   +3.25000000E-06  +1.35300000E-05  +3.12000000E-06  -3.39000000E-06  +2.24200000E-05
   -9.18400000E-05  +1.37190000E-04  -2.46500000E-05  -7.98000000E-06  +9.32000000E-06
   -9.17000000E-06  +1.88000000E-05  -3.03000000E-06  +3.12000000E-05  +6.36000000E-06
   -2.97200000E-05  -1.55900000E-05  -3.17900000E-05  +1.39500000E-05  +7.22000000E-06
   -3.46600000E-05  -4.01000000E-05  -1.64910000E-04  -2.16470000E-04  -3.14000000E-06
   -3.59600000E-05  +1.40450000E-04  -1.62410000E-04  -2.82629200E-02  +1.50460300E-01
   +6.51390000E-04  -4.05764000E-03  +2.75074000E-03  +3.97200000E-04  -3.62550000E-04
   +1.10631000E-03  +3.71290000E-04  -5.45230000E-04  -2.47850000E-04  +5.04952000E-03
   +2.40230000E-04  -1.45298000E-03  -5.79756000E-03  +1.88864900E-02  -1.27539200E-02
   -5.55289000E-03  +1.41592020E-01  -2.29820030E-01  +2.55760000E-04  +7.37500000E-05
   +7.99200000E-05  -5.07600000E-05  +4.43500000E-05  +2.70600000E-05  -2.17212000E-03
   -2.11122000E-03  +1.06600000E-03  +4.08200000E-05  +2.76400000E-05  -8.04000000E-06
   +2.48700000E-05  +6.53000000E-06  +7.22000000E-06  -8.39000000E-06  -2.59600000E-05
   +3.04500000E-05  +2.38800000E-05  +3.10800000E-05  +8.65000000E-06  -2.39000000E-06
   -1.40800000E-05  -8.64000000E-06  -4.35000000E-06  -7.58000000E-06  -1.18300000E-05
   -4.00700000E-05  -4.81400000E-05  +7.49000000E-06  -1.40000000E-05  -3.69000000E-06
   +1.04800000E-05  +1.45880000E-04  +1.33889000E-03  +9.15360000E-04  -6.79000000E-06
   +1.37400000E-05  -5.55000000E-06  -1.72300000E-05  -4.07000000E-06  -1.89700000E-05
   +1.87000000E-05  +2.50800000E-05  -9.19000000E-06  +1.11000000E-05  -4.12000000E-06
   -3.30000000E-06  -3.04000000E-06  -7.20000000E-07  -2.00000000E-07  -1.57000000E-05
   -1.06000000E-06  +5.41000000E-06  -4.49000000E-06  -2.35300000E-05  +8.61000000E-06
   +1.47300000E-05  +8.66000000E-06  -7.32000000E-06  +2.77400000E-05  -7.75000000E-06
   -1.42000000E-06  -8.72000000E-06  -1.59400000E-05  +3.15000000E-06  -1.98100000E-05
   +1.89400000E-05  -6.98000000E-06  -1.36370000E-04  -1.06350000E-04  -9.63300000E-05
   -2.85320000E-04  +8.00090000E-04  -8.79250000E-04  +5.60062000E-03  -1.54900000E-01
   +2.39815830E-01  -2.44266310E-01  -7.45188800E-02  +7.76038400E-02  +5.50525000E-03
   +8.95300000E-04  +1.55943000E-03  +2.91790000E-04  -6.07620000E-04  -1.20118000E-03
   -1.25950000E-04  +1.88390000E-04  -4.17100000E-05  -1.68969000E-03  +1.44950000E-03
   -2.97618000E-03  -1.76841000E-02  -1.61883000E-03  +1.01926700E-02  -2.53260000E-04
   +1.58710000E-04  +5.84500000E-05  +6.66700000E-05  -7.06400000E-05  +8.81300000E-05
   -5.40940000E-04  +8.80430000E-04  +1.09862000E-03  -1.47672000E-03  +9.10960000E-04
   -1.44863000E-03  -6.80470000E-04  +4.76480000E-04  -7.30200000E-04  +3.22230000E-04
   +9.69300000E-05  +3.68500000E-05  -1.15520000E-04  -1.94000000E-05  +1.94150000E-04
   -5.09100000E-05  -1.55790000E-04  +1.87400000E-05  -2.64110000E-04  +3.11240000E-04
   -5.21720000E-04  +2.66300000E-05  +3.95700000E-05  -3.29700000E-05  +2.09500000E-05
   -1.29960000E-04  -2.24000000E-06  -1.28318400E-02  -1.03200300E-02  -1.92838000E-03
   +2.47000000E-06  -1.26500000E-05  +1.27400000E-05  +1.43200000E-05  +2.46000000E-06
   +1.50400000E-05  +4.24600000E-05  -5.44900000E-05  +9.78900000E-05  +5.27600000E-05
   -4.72000000E-05  +3.93400000E-05  +1.25800000E-05  -7.50000000E-06  +1.26000000E-06
   +5.66000000E-05  -2.51200000E-05  +2.04000000E-06  -1.23000000E-06  -5.70000000E-07
   +1.75600000E-05  -1.98100000E-05  -1.73500000E-05  -1.38800000E-05  -2.65200000E-05
   -1.27770000E-04  +9.78000000E-06  +1.38200000E-05  +3.62900000E-05  -3.83000000E-05
   +2.16100000E-05  -1.43800000E-05  -1.22000000E-05  -5.79300000E-05  -2.17800000E-04
   -3.27030000E-04  -1.30000000E-06  -4.38000000E-06  +2.25400000E-05  +8.70740000E-04
   +3.95060000E-04  -5.34000000E-05  +2.71869270E-01  -6.77503500E-02  -7.54375400E-02
   +3.42609900E-02  -1.40152700E-02  -3.40399000E-03  +7.92469000E-03  -1.25430000E-04
   -1.64152000E-03  +2.65902000E-03  +8.40800000E-04  -1.03865000E-03  +5.94020000E-04
   +2.61226000E-03  -9.80280000E-04  +7.63810000E-04  +2.40047500E-02  +7.63013000E-03
   -1.03448800E-02  -6.27540000E-04  +1.47240000E-04  +4.23470000E-04  -7.57600000E-05
   -4.45200000E-05  +1.19640000E-04  +5.44830000E-04  -2.21743000E-03  -1.45219000E-03
   +2.40330000E-04  +1.64690000E-04  -1.88500000E-05  +6.96000000E-05  +4.67320000E-04
   +9.49200000E-05  -1.76050000E-04  -2.01120000E-04  +1.47400000E-04  +2.24720000E-04
   +8.25800000E-05  -4.32900000E-05  +9.85700000E-05  -2.80000000E-07  -8.34400000E-05
   +2.48540000E-04  +4.74000000E-06  -1.96270000E-04  -2.74750000E-04  -2.53030000E-04
   +2.94400000E-05  +1.48600000E-05  +3.97400000E-05  +2.06500000E-05  -2.73388500E-02
   -1.39747800E-02  -1.91521000E-03  -4.86000000E-06  +4.31700000E-05  -3.64000000E-06
   -3.68000000E-05  -2.23200000E-05  -3.62800000E-05  +2.32700000E-05  -2.01500000E-05
   -4.80700000E-05  +4.59500000E-05  -7.63900000E-05  +1.00600000E-05  -2.06300000E-05
   -1.80000000E-07  +1.91000000E-06  +3.00100000E-05  +4.86000000E-06  -2.81100000E-05
   +2.24100000E-05  +6.04600000E-05  -2.69400000E-05  -2.96800000E-05  -1.22800000E-05
   -5.53800000E-05  -1.22780000E-04  -2.56060000E-04  -1.45220000E-04  +9.00000000E-06
   +1.54000000E-04  -1.23020000E-04  +4.00700000E-05  +8.24900000E-05  -1.26000000E-05
   -3.17280000E-04  +4.62360000E-04  +7.20900000E-04  -1.58800000E-05  +5.89600000E-05
   +6.40000000E-06  -9.03030000E-04  +4.39690000E-04  +8.00400000E-05  +8.38451600E-02
   +9.22467600E-02  +8.73854600E-02  +4.15478600E-02  -7.60344500E-02  +2.38986700E-02
   +9.98612000E-03  -1.36788400E-02  -2.00761000E-03  +3.17714000E-03  -2.23392000E-03
   +4.91590000E-04  +2.23890000E-04  -3.79620000E-04  -2.74890000E-04  -3.99500000E-05
   +1.25609000E-03  +3.30168000E-03  -1.30868000E-03  +1.39000000E-06  +6.26300000E-04
   -5.42060000E-04  +3.87050000E-04  -2.22270000E-04  +5.25400000E-05  +1.97000000E-05
   +3.09100000E-05  -8.62000000E-05  -9.68500000E-05  -5.75650000E-04  +5.19090000E-04
   -7.56900000E-05  -1.07060000E-04  -4.02990000E-04  -3.96830000E-04  -6.95400000E-05
   -2.08880000E-04  +5.22300000E-05  -3.59660000E-04  -2.94150000E-04  -7.65200000E-05
   +1.11380000E-04  +2.74390000E-04  +6.06800000E-05  -6.41540000E-04  -1.63050000E-04
   +3.41400000E-04  +3.96470000E-04  +3.11380000E-04  -2.86800000E-05  -5.19300000E-05
   -2.00210000E-04  -7.55800000E-05  -2.91021400E-02  -1.78203000E-02  +1.85695000E-03
   -4.23500000E-05  -5.71800000E-05  -1.59100000E-05  +1.28700000E-05  +4.06900000E-05
   -3.29000000E-06  +6.89900000E-05  +9.14400000E-05  -4.82000000E-05  +3.56500000E-05
   -4.46900000E-05  -2.74500000E-05  +2.98300000E-05  -9.33000000E-06  -2.23000000E-06
   -6.97200000E-05  +3.93000000E-05  +6.58000000E-05  -3.68600000E-05  -1.45460000E-04
   +7.43000000E-05  +7.53300000E-05  +3.51500000E-05  +4.23500000E-05  +8.70000000E-07
   +1.27300000E-05  +9.48600000E-05  -2.55900000E-05  -9.70100000E-05  -6.22500000E-05
   +9.97000000E-06  +8.84600000E-05  +6.28800000E-05  +1.63460000E-04  -6.92620000E-04
   -1.26220000E-03  +8.81500000E-05  +4.66700000E-05  +9.29400000E-05  -4.61990000E-04
   -4.35030000E-04  +3.34980000E-04  -7.99707100E-02  -2.96989800E-02  +9.28563900E-02
   -4.26530000E-04  -3.57200000E-05  +7.19310000E-04  -9.81100000E-05  -1.91370000E-04
   +1.46480000E-04  +1.45493000E-03  +5.30270000E-04  -1.07842000E-03  -3.29506000E-03
   +4.68001000E-03  +1.12032000E-03  -3.86458000E-03  +2.23713600E-02  -2.91175800E-02
   +1.07543000E-03  -7.63410000E-04  -2.33111000E-03  -1.35710000E-04  -1.33400000E-05
   +5.69800000E-05  +6.18600000E-05  +2.98000000E-06  +3.86500000E-05  -2.84539500E-02
   +2.05766000E-03  +3.28676600E-02  +1.52900000E-05  -5.13500000E-05  +7.33000000E-06
   +2.23500000E-05  -5.37000000E-06  +3.29600000E-05  +2.82500000E-05  -3.98700000E-05
   -6.54000000E-06  -1.10210000E-04  -8.43600000E-05  +3.32000000E-06  +2.64600000E-05
   +3.59000000E-05  +1.39000000E-05  -1.85700000E-05  +4.73000000E-06  +3.32600000E-05
   +1.22600000E-04  +7.96300000E-05  -7.96000000E-06  +6.26600000E-05  -1.36400000E-05
   -2.76600000E-05  -1.28570000E-04  -4.28940000E-04  -5.02600000E-04  -3.21000000E-05
   -1.25800000E-05  -8.01000000E-06  -1.30600000E-05  +1.06800000E-05  -9.86000000E-06
   -1.30300000E-05  +7.03000000E-06  -4.28800000E-05  -6.84000000E-06  -2.70000000E-06
   -2.65000000E-06  +4.70000000E-06  +3.73000000E-06  -8.31000000E-06  +1.62100000E-05
   -2.62600000E-05  +2.21900000E-05  -1.77600000E-05  -2.52000000E-06  -3.10000000E-06
   -7.83000000E-06  +9.64000000E-06  -5.11000000E-06  -1.44500000E-05  +1.99200000E-05
   +5.40000000E-07  -1.29000000E-05  +8.29000000E-06  +7.09000000E-06  +2.54300000E-05
   -3.49900000E-05  -1.66100000E-05  -2.23660000E-04  +1.18960000E-04  +1.24100000E-05
   -1.31130000E-04  -1.41810000E-04  -1.83290000E-04  -3.44060000E-04  -2.99100000E-04
   +1.65566000E-03  +3.99000000E-06  +1.28950000E-04  -4.00000000E-05  +3.43150800E-02
   -5.30770000E-04  -9.55820000E-04  -1.62310000E-04  -3.28000000E-05  +1.68400000E-04
   -5.63600000E-05  -3.72410000E-04  +2.04720000E-04  +1.64358000E-03  +5.18628000E-03
   -2.04010000E-03  -1.24980000E-03  +2.08714000E-03  -2.32480800E-02  +3.01353700E-02
   -3.15456000E-03  +2.94827000E-03  -7.13240000E-04  +1.46750000E-04  -3.34700000E-05
   -4.43800000E-05  -5.71300000E-05  -1.60000000E-07  -2.86200000E-05  +2.39827700E-02
   -1.71504720E-01  +2.15905740E-01  -4.41000000E-06  +9.65300000E-05  -4.52400000E-05
   -1.20300000E-05  +2.19800000E-05  -2.54000000E-06  -3.77100000E-05  +1.56500000E-05
   +4.78100000E-05  +1.43660000E-04  +1.25170000E-04  +1.33000000E-06  -1.89500000E-05
   -5.56600000E-05  -2.36800000E-05  +2.89000000E-06  -1.51100000E-05  -5.46400000E-05
   -1.67940000E-04  -1.52290000E-04  +1.93600000E-05  -8.39000000E-05  +1.76700000E-05
   +2.61700000E-05  -1.04310000E-04  +3.38380000E-04  +1.26220000E-04  +1.31600000E-05
   +3.79000000E-05  -5.90000000E-07  -1.85700000E-05  -1.66900000E-05  -1.74700000E-05
   +2.78300000E-05  +2.61500000E-05  +2.95100000E-05  +1.86100000E-05  -2.18000000E-06
   -5.34000000E-06  -7.88000000E-06  -3.36000000E-06  +6.17000000E-06  -1.93300000E-05
   +2.83500000E-05  -3.30800000E-05  +1.13200000E-05  -6.32000000E-06  +1.55600000E-05
   +6.78000000E-06  -1.59000000E-05  -1.04900000E-05  +4.26500000E-05  -2.93300000E-05
   -1.04100000E-05  +3.52000000E-06  -2.65200000E-05  +1.60000000E-06  -3.68000000E-05
   +4.12100000E-05  +5.40000000E-07  +2.60670000E-04  -2.49990000E-04  -8.50000000E-05
   -1.98940000E-04  +3.81200000E-05  -3.01910000E-04  +1.00413000E-03  +2.27140000E-04
   -8.26430000E-04  -2.28020000E-04  +2.94360000E-04  +7.36400000E-05  -2.79566300E-02
   +1.93962920E-01  -4.29910000E-04  +6.94420000E-04  -1.15358000E-03  -6.46900000E-05
   +1.48100000E-05  +1.18320000E-04  +3.30560000E-04  +3.36530000E-04  +4.05630000E-04
   +7.85280000E-04  -5.64400000E-04  +1.89391000E-03  +1.30364000E-03  -1.73417000E-03
   -9.62700000E-05  +2.17897000E-03  -4.64045000E-03  +3.25332000E-03  -1.08800000E-05
   -1.16600000E-05  -4.71300000E-05  +8.96000000E-06  -6.06000000E-06  -4.69000000E-06
   -7.27490000E-04  +2.50594720E-01  -3.86066230E-01  +1.52300000E-05  +3.02000000E-06
   +2.19000000E-06  -6.32000000E-06  -2.77000000E-06  +1.62900000E-05  +6.37000000E-06
   -1.00500000E-05  +4.43000000E-06  -2.74700000E-05  -1.27000000E-05  +8.91000000E-06
   +3.22000000E-06  +3.20000000E-06  -3.86000000E-06  -1.20300000E-05  -7.70000000E-06
   +8.80000000E-07  +2.11800000E-05  +1.04100000E-05  -6.59000000E-06  -2.00000000E-08
   -4.75000000E-06  +5.54000000E-06  +2.28890000E-04  -6.68430000E-04  -3.68700000E-04
   -8.85000000E-06  +9.00000000E-08  +2.58000000E-06  -1.21700000E-05  -8.50000000E-07
   -6.00000000E-06  -4.70000000E-07  +1.72700000E-05  -1.48900000E-05  +6.70000000E-07
   -2.53000000E-06  -2.06000000E-06  +3.05000000E-06  -2.30000000E-06  -5.20000000E-07
   +2.52000000E-06  -1.77000000E-06  -1.54000000E-06  -2.54000000E-06  -2.95000000E-06
   -4.00000000E-07  +1.02000000E-06  +1.34000000E-06  -4.45000000E-06  -8.06000000E-06
   +6.10000000E-06  +3.50000000E-06  -2.38000000E-06  -1.21000000E-06  +1.26000000E-06
   +3.81000000E-06  -6.70000000E-07  +3.38000000E-06  -6.22600000E-05  -6.91900000E-05
   -1.17600000E-05  -9.35100000E-05  -3.81300000E-04  +2.66340000E-04  -1.70260000E-04
   +8.87780000E-04  -8.04480000E-04  +1.04430000E-04  -1.28460000E-04  +2.86500000E-05
   -3.41866000E-03  -2.44370410E-01  +3.82503040E-01  -1.19570400E-02  -2.40405000E-03
   +5.58455000E-03  +3.68220000E-04  +1.32756000E-03  -3.89760000E-04  -2.70460000E-04
   -1.10130000E-04  +3.00190000E-04  +3.30430000E-04  -9.87200000E-05  +1.95550000E-04
   +6.63900000E-05  -3.92420000E-04  +6.48970000E-04  +2.47739000E-03  +3.29780000E-04
   -1.10440000E-04  -2.56370000E-04  -1.17150000E-04  +1.90300000E-05  -3.42170000E-04
   -7.23800000E-05  +1.94940000E-04  -5.71560000E-04  -4.35400000E-05  -2.77490000E-04
   -1.29930000E-04  -3.75900000E-05  +2.51700000E-05  +4.17600000E-05  +6.41200000E-05
   +1.60800000E-05  +3.78900000E-05  +8.36000000E-06  -1.18900000E-05  -8.33400000E-05
   -6.31900000E-05  +1.07800000E-05  +1.48500000E-05  +3.76400000E-05  +1.16200000E-05
   +3.20600000E-05  +1.11300000E-05  -2.34000000E-05  +1.02380000E-04  +8.53500000E-05
   -1.27500000E-05  +1.00180000E-04  -1.56000000E-06  +2.13400000E-05  -4.48344990E-01
   -1.60746090E-01  +1.05391990E-01  -1.37400000E-05  -1.73700000E-05  +3.80000000E-07
   +8.71000000E-06  +1.18000000E-05  +6.21000000E-06  -9.08000000E-06  -2.36400000E-05
   -1.71500000E-05  -2.53900000E-05  -1.45200000E-05  +2.66000000E-05  +9.94000000E-06
   +1.07000000E-06  -3.61000000E-06  +2.02800000E-05  -2.81800000E-05  +1.71700000E-05
   +4.04000000E-06  +2.05900000E-05  -3.12400000E-05  -5.29000000E-06  +8.49000000E-06
   +2.96600000E-05  -2.72450000E-04  -1.06020000E-04  -9.93800000E-05  +7.78800000E-05
   +3.49150000E-04  -2.55630000E-04  +2.40520000E-04  +8.56200000E-05  +4.72900000E-05
   -2.45120000E-04  -1.61490000E-04  -1.35300000E-05  +2.08700000E-05  +9.03900000E-05
   +4.60000000E-05  +1.12630000E-04  +9.43700000E-05  -9.57600000E-05  +8.92490000E-04
   -1.20917000E-03  -2.66806000E-03  +1.12890000E-04  +1.04940000E-04  +6.01800000E-05
   +4.57455120E-01  -2.62392600E-02  -1.18142500E-02  +5.34697000E-03  +4.27630000E-04
   +1.00670000E-03  +4.19400000E-05  +3.13830000E-04  -4.62510000E-04  -4.62000000E-04
   -4.42250000E-04  +1.08162000E-03  -1.21622000E-03  +1.17059000E-03  -8.12140000E-04
   +3.48290000E-04  -1.97310000E-04  +9.69590000E-04  +2.22504000E-03  -7.25900000E-05
   +2.15990000E-04  +2.87800000E-05  +7.39470000E-04  -2.72000000E-06  -1.15900000E-04
   -1.21644000E-03  +9.52040000E-04  +2.72300000E-05  +3.20300000E-05  -2.31510000E-04
   -1.21990000E-04  -6.00800000E-05  +6.24800000E-05  +6.23500000E-05  +9.05000000E-06
   -3.32200000E-05  -9.22000000E-06  +1.59200000E-05  +1.55000000E-06  -3.33000000E-06
   +2.62100000E-05  -6.42000000E-06  -2.74700000E-05  +1.86300000E-05  +2.66800000E-05
   +8.32000000E-06  -5.37000000E-06  -1.81600000E-05  -2.72000000E-06  +1.01980000E-04
   -3.53100000E-05  -5.30700000E-05  -1.35809140E-01  -6.35714900E-02  +1.36003100E-02
   -7.17000000E-06  +5.97000000E-06  -1.59000000E-06  -1.31800000E-05  -5.71000000E-06
   -4.34000000E-06  -1.92500000E-05  -6.21000000E-06  -3.91200000E-05  +1.54200000E-05
   +7.49000000E-06  -2.32900000E-05  -1.30000000E-06  +8.18000000E-06  -5.59000000E-06
   +2.47700000E-05  -3.85700000E-05  +2.24500000E-05  -2.42900000E-05  +3.15000000E-06
   +4.76600000E-05  -3.75500000E-05  -2.54300000E-05  -5.93900000E-05  +7.71300000E-05
   +3.78570000E-04  +1.27900000E-05  -7.86600000E-05  -4.51910000E-04  +4.47190000E-04
   -1.96190000E-04  -2.96720000E-04  +9.80000000E-06  +6.89000000E-05  -4.61200000E-05
   +5.72000000E-06  +3.38200000E-05  -2.32000000E-05  +1.06660000E-04  -2.18300000E-04
   -4.05380000E-04  -1.21440000E-04  -1.48814000E-03  -2.80301000E-03  -4.27373000E-03
   +3.42200000E-05  -2.37230000E-04  +5.50900000E-05  +1.63016840E-01  +7.66071900E-02
   -3.22718400E-02  -1.47859000E-02  +1.97588000E-03  -1.27302000E-03  -2.76430000E-04
   +1.46856000E-03  +3.34000000E-05  +3.53400000E-04  -3.97800000E-05  +5.53170000E-04
   -6.23600000E-04  -1.42500000E-04  +5.60780000E-04  -5.59120000E-04  -4.37340000E-04
   -2.24160000E-04  +6.16670000E-04  +9.25370000E-04  -3.93970000E-04  +1.41180000E-04
   -2.86800000E-05  -1.81560000E-04  -9.01800000E-05  -7.49000000E-06  -2.40680000E-04
   +3.16770000E-04  -8.78100000E-05  -1.22730000E-04  -5.54700000E-05  -6.08900000E-05
   -6.27500000E-05  +8.25500000E-05  +6.30000000E-06  +1.01550000E-04  +3.13400000E-05
   -5.74100000E-05  -1.04610000E-04  -4.70400000E-05  +4.89400000E-05  +2.17000000E-06
   -6.07000000E-06  -1.90000000E-07  +1.00440000E-04  +5.51400000E-05  -4.22000000E-05
   +1.14230000E-04  +8.86000000E-05  -2.14200000E-05  +6.50600000E-05  -1.96600000E-05
   +6.25000000E-06  +1.43689690E-01  +3.33088700E-02  -6.68062000E-02  -1.72100000E-05
   -1.89100000E-05  +3.23000000E-06  +6.31000000E-06  +9.39000000E-06  +8.23000000E-06
   -1.75700000E-05  -4.84300000E-05  -1.73700000E-05  -3.01400000E-05  +2.48000000E-06
   +1.48100000E-05  +1.10000000E-05  +4.64000000E-06  -6.11000000E-06  +4.86100000E-05
   -2.91300000E-05  +6.61000000E-06  +4.18000000E-06  +6.07500000E-05  -3.65900000E-05
   -2.35500000E-05  +1.94000000E-06  -5.12000000E-06  -1.01960000E-04  +1.82360000E-04
   -1.36070000E-04  -2.02400000E-05  +2.26710000E-04  +2.02200000E-05  +1.25590000E-04
   +3.51900000E-05  -5.08000000E-06  -3.73100000E-05  +2.06100000E-05  +8.54200000E-05
   -6.60000000E-06  +5.10100000E-05  +2.81200000E-05  +1.59820000E-04  +3.13770000E-04
   -4.13900000E-05  -1.87479000E-03  -3.49655000E-03  -3.13011000E-03  +7.22800000E-05
   +9.35000000E-06  +7.49400000E-05  -1.08643610E-01  -1.58562100E-02  +6.64368400E-02
end_hess

