# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.50146820    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.14994315E+00  -1.72253869E+00  -1.02218376E+00
   006   +2.11662748E+00  +1.11358278E+00  -8.94214499E-01
   006   +4.72090540E+00  +2.14750817E+00  -4.27141805E-01
   006   +6.78463495E+00  +6.84218339E-01  -6.23838565E-02
   006   +6.59825094E+00  -1.97534144E+00  -9.84282955E-02
   006   +4.25912273E+00  -3.12634188E+00  -6.42213902E-01
   006   +1.62903726E-01  +2.06916048E+00  +1.15844839E+00
   006   +1.19040929E+00  +1.37248299E+00  +3.77479615E+00
   008   +8.73487439E+00  -3.31966466E+00  +3.22748273E-01
   006   -2.42427652E+00  +8.62709157E-01  +6.82825988E-01
   006   -3.96556406E+00  +1.68631852E+00  -1.28773056E+00
   006   -6.29694435E+00  +5.99360918E-01  -1.76220095E+00
   006   -7.16477680E+00  -1.36947671E+00  -2.61334355E-01
   006   -5.67009191E+00  -2.22713897E+00  +1.70933170E+00
   006   -3.34273947E+00  -1.11599431E+00  +2.15750850E+00
   008   -9.43831128E+00  -2.50583957E+00  -6.37108610E-01
   006   -7.60524943E-02  +4.96159278E+00  +1.05012690E+00
   008   +1.22591079E+00  +2.08958687E+00  -3.27185726E+00
   001   -1.02746199E+01  -1.73335857E+00  -2.04164087E+00
   001   -7.44366870E+00  +1.29005256E+00  -3.31377032E+00
   001   -3.33024626E+00  +3.18815140E+00  -2.51231551E+00
   001   -2.23129200E+00  -1.84043342E+00  +3.70908766E+00
   001   -6.34478848E+00  -3.75802709E+00  +2.88290832E+00
   001   -1.54543940E+00  +5.57285296E+00  +2.35880388E+00
   001   +1.68318659E+00  +5.86950070E+00  +1.61874857E+00
   001   -5.55989387E-01  +5.63589058E+00  -8.29251874E-01
   001   +1.63577740E+00  -6.31966893E-01  +3.93626884E+00
   001   +2.92357103E+00  +2.41555060E+00  +4.15440744E+00
   001   -1.79956796E-01  +1.85828150E+00  +5.23447209E+00
   001   +4.91024733E+00  +4.18175904E+00  -4.59328910E-01
   001   +8.62577711E+00  +1.52266954E+00  +2.38097784E-01
   001   +4.15611725E+00  -5.17010885E+00  -7.82083979E-01
   001   +3.76465366E-01  -2.62834973E+00  -1.47736280E+00
   001   +8.37346653E+00  -5.09015405E+00  +2.32616933E-01
   001   +2.33190457E+00  +1.45713506E+00  -4.55657319E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.50000000E-07  -2.12000000E-06  -4.37000000E-06
   -3.71000000E-06  +4.14000000E-06  +7.41000000E-06
   +2.30000000E-06  +2.02000000E-06  -2.04000000E-06
   +3.02000000E-06  -3.71000000E-06  -1.00000000E-08
   -1.90000000E-06  +1.02000000E-06  -1.14000000E-06
   -1.14000000E-06  -1.12000000E-06  +2.87000000E-06
   +7.29000000E-06  -5.69000000E-06  -4.96000000E-06
   -4.57000000E-06  +6.00000000E-07  +8.50000000E-07
   +0.00000000E+00  +1.68000000E-06  +1.23000000E-06
   -3.61000000E-06  -2.09000000E-06  +4.48000000E-06
   -1.61100000E-05  +4.63000000E-06  +5.49000000E-06
   -5.40000000E-07  -3.60000000E-06  +7.74000000E-06
   +4.40000000E-07  +1.78000000E-06  -1.65000000E-06
   -8.60000000E-07  -1.53000000E-06  -1.82000000E-06
   -2.58000000E-06  +3.34000000E-06  -5.50000000E-06
   -9.60000000E-07  -1.25000000E-06  +2.90000000E-06
   -1.42000000E-06  -2.20000000E-07  +2.80000000E-07
   -2.90000000E-05  +4.78000000E-06  +1.19000000E-05
   +6.70000000E-07  +8.90000000E-07  -2.19000000E-06
   -1.06000000E-06  -3.10000000E-07  +3.00000000E-08
   +4.62400000E-05  -4.05000000E-06  -1.51200000E-05
   +5.14000000E-06  +1.40000000E-06  +2.40000000E-07
   +2.00000000E-08  +1.16000000E-06  -1.29000000E-06
   -1.00000000E-06  -2.80000000E-07  +6.40000000E-07
   -4.24000000E-06  +1.15000000E-06  +2.20000000E-07
   +7.59000000E-06  -5.41000000E-06  -5.00000000E-06
   +1.72000000E-06  +3.04000000E-06  +8.80000000E-07
   -7.30000000E-07  +4.00000000E-07  +2.10000000E-06
   +6.60000000E-07  -3.90000000E-07  -2.00000000E-06
   +0.00000000E+00  -1.00000000E-08  -2.32000000E-06
   -4.10000000E-07  -6.50000000E-07  -1.15000000E-06
   -1.60000000E-07  +1.60000000E-07  +6.00000000E-08
   +3.03000000E-06  -8.60000000E-07  +5.40000000E-07
   +1.20000000E-07  -1.28000000E-06  +9.00000000E-08
   -3.71000000E-06  +2.38000000E-06  +6.10000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.39474850E-01  -4.31779700E-02  +5.74639770E-01  +1.28867680E-01  +1.78486700E-02
   +1.73901310E-01  -9.73057700E-02  -1.51781800E-02  -4.13128000E-03  +4.75349850E-01
   -1.50329000E-02  -1.92906400E-01  -2.19539800E-02  +2.92321400E-02  +5.05815560E-01
   -3.76122000E-03  -1.38138000E-02  -6.66792700E-02  +1.72698400E-02  +1.04795700E-02
   +3.91511700E-01  +1.24282900E-02  -1.58926400E-02  +4.47947000E-03  -1.68167550E-01
   -4.53256600E-02  -1.32488700E-02  +6.23686100E-01  -4.11432500E-02  -9.92027000E-03
   -8.03759000E-03  -4.50306000E-02  -1.22999370E-01  -1.12802100E-02  -9.43215200E-02
   +7.15970440E-01  +1.59296000E-03  -5.83618000E-03  +1.50159000E-03  -5.16003000E-03
   -6.96753000E-03  -6.49857500E-02  +8.00461900E-02  -2.78861800E-02  +1.62095830E-01
   -9.55741000E-03  +6.39562000E-03  -1.49702000E-03  -2.61633800E-02  +1.27621000E-02
   -4.90882000E-03  -3.30673230E-01  +1.56438410E-01  -4.85840200E-02  +7.61682260E-01
   +3.16609400E-02  -2.15066300E-02  +6.31879000E-03  +7.73606000E-03  +2.28243200E-02
   +3.92799000E-03  +1.04217180E-01  -2.00131890E-01  +1.87367100E-02  +2.63210000E-04
   +6.17399160E-01  -1.21677000E-03  +1.07621000E-03  -1.16500000E-04  -7.15966000E-03
   +1.26834000E-03  +4.65454000E-03  -4.78936900E-02  +2.82541200E-02  -5.76936000E-02
   +1.10715600E-01  -1.14336000E-03  +1.40659450E-01  -7.91807900E-02  +2.63247600E-02
   -1.68038100E-02  -4.21607000E-03  -9.31667000E-03  -7.19250000E-04  +3.35102800E-02
   +1.35065100E-02  +4.32937000E-03  -1.29701910E-01  +2.70862600E-02  -1.17792800E-02
   +6.35100820E-01  -3.48914000E-02  +5.25600600E-02  -4.76523000E-03  -1.00079300E-02
   -1.15482400E-02  -1.30010000E-03  +7.20981500E-02  -6.57526200E-02  +1.26558600E-02
   -8.85486100E-02  -2.30635660E-01  -1.49363900E-02  -5.50453200E-02  +6.30767410E-01
   -1.94047300E-02  +8.26494000E-03  +3.05809000E-03  +2.67637000E-03  -3.51390000E-03
   -8.40787000E-03  +4.25762000E-03  +1.66287000E-03  +7.46425000E-03  -1.28319500E-02
   +4.69984000E-03  -6.08155000E-02  +1.08145930E-01  -5.33201000E-03  +1.39752360E-01
   -2.91095290E-01  +1.09566740E-01  -4.62984700E-02  +9.18328000E-03  +2.22071500E-02
   -2.36420000E-04  -3.17555200E-02  +2.25074100E-02  -6.02239000E-03  +2.24578500E-02
   -8.02320000E-02  +3.67460000E-04  -1.93173960E-01  +1.11091600E-02  -2.82416000E-02
   +6.02604930E-01  +1.62590280E-01  -2.21710880E-01  +2.55654700E-02  +2.63011500E-02
   -1.35971500E-02  +3.65152000E-03  -2.00122000E-03  +8.06130000E-04  -8.49070000E-04
   -3.08033400E-02  -2.08227700E-02  -7.04713000E-03  -1.12595800E-01  -1.71003120E-01
   -2.86233000E-02  -5.00177200E-02  +7.42089840E-01  -4.37598100E-02  +1.35639000E-02
   -5.68861100E-02  +2.33702000E-03  +5.23580000E-03  +5.89075000E-03  -6.55274000E-03
   +4.40819000E-03  -1.11461000E-03  +2.33972000E-03  -1.53845700E-02  +6.59478000E-03
   -3.48172600E-02  -3.95766000E-03  -6.37827000E-02  +1.00727060E-01  +2.08888100E-02
   +1.38552710E-01  +1.78660000E-04  +1.22106700E-02  +8.24300000E-04  -8.69928500E-02
   +3.21770000E-04  +2.08518500E-02  -3.09187500E-02  +8.67252000E-03  +1.55159000E-02
   -1.01900000E-04  -5.60720000E-03  +1.34002000E-03  -2.64320000E-04  +2.10842000E-03
   -2.06640000E-04  +1.97590000E-04  -1.75836000E-03  +9.46420000E-04  +4.57922480E-01
   +2.42881100E-02  -1.65149300E-02  -1.91327000E-02  +7.84335000E-03  -7.79261800E-02
   -1.74386100E-02  -3.52575000E-03  +8.41156000E-03  +8.31831000E-03  -1.90582000E-03
   -2.72466000E-03  -7.55040000E-04  +1.44774000E-03  +1.42989000E-03  +3.08230000E-04
   -4.39652000E-03  -2.93703000E-03  -1.60242000E-03  +1.19765200E-02  +4.79846180E-01
   +3.36867000E-03  -9.35915000E-03  -6.71200000E-05  +8.31826000E-03  -3.87655000E-03
   -7.51254500E-02  +5.84069000E-03  +3.28037000E-03  +5.04242000E-03  -1.94601000E-03
   +5.03790000E-04  -1.88680000E-03  +1.23193000E-03  -9.96820000E-04  +7.67620000E-04
   -1.17243000E-03  +9.10030000E-04  -1.68312000E-03  +4.16535100E-02  -2.29092800E-02
   +4.69194850E-01  +1.29000000E-05  -3.56440000E-04  +9.15520000E-04  +9.58606000E-03
   -6.33580000E-03  +1.47391300E-02  -7.03760000E-04  -1.97100000E-05  +2.92642000E-03
   +3.64400000E-05  -1.57060000E-04  +2.51610000E-04  +5.28210000E-04  -7.90700000E-05
   -1.41790000E-04  +4.77800000E-05  +7.69100000E-05  +1.68300000E-04  -9.07634500E-02
   +9.53868000E-03  -3.10301900E-02  +5.76445200E-01  -3.31930000E-04  -4.55500000E-05
   -1.81575000E-03  -4.76008000E-03  +2.45318000E-03  -6.22484000E-03  +1.41020000E-04
   -1.52700000E-04  -1.44250000E-04  +2.93820000E-04  +2.62520000E-04  -1.02092000E-03
   +1.85200000E-05  +6.08830000E-04  +1.65830000E-04  +1.34210000E-04  -1.88060000E-04
   +4.42880000E-04  +7.99304000E-03  -8.44299900E-02  +2.12294200E-02  +9.31486000E-03
   +5.84890680E-01  +1.95000000E-04  -1.80710000E-04  -1.09075000E-03  -3.78668000E-03
   +4.31465000E-03  -2.71636000E-02  +1.09444000E-03  -1.44720000E-04  -1.73743000E-03
   -5.44000000E-05  +7.56100000E-05  -8.57110000E-04  -5.60070000E-04  +2.68920000E-04
   +2.19740000E-04  +6.55400000E-05  +1.06100000E-04  -4.24420000E-04  -3.27801600E-02
   +2.35053500E-02  -1.60738440E-01  -4.06187300E-02  +2.08254500E-02  +4.88597650E-01
   -1.77001000E-03  -7.11489000E-03  -1.72310000E-03  +1.18241000E-03  -1.41850000E-03
   +2.20124000E-03  -3.67104000E-03  +1.18406000E-03  -1.12926000E-03  +2.46951000E-03
   +2.26828000E-03  -4.33510000E-04  -2.67053420E-01  +7.68940800E-02  -4.91204700E-02
   -4.27279800E-02  +3.44010100E-02  -9.35141000E-03  +3.86700000E-05  +4.30360000E-04
   -1.54580000E-03  -4.00820000E-04  +1.37530000E-04  +5.75500000E-05  +3.79350170E-01
   +5.22629000E-03  -5.36046000E-03  +6.75430000E-04  -8.39450000E-04  +1.34761000E-03
   -1.38664000E-03  -8.28663000E-03  -2.55493000E-03  -1.30213000E-03  +5.28192800E-02
   -3.72764900E-02  +1.02748400E-02  +1.29614980E-01  -1.62069000E-01  +2.54579000E-02
   -1.87285100E-02  +8.12546000E-03  -3.72858000E-03  -6.01800000E-05  -3.50550000E-04
   +1.14319000E-03  +2.39700000E-04  -2.53390000E-04  -4.01000000E-05  -2.71753700E-02
   +7.03225750E-01  -1.10695000E-03  -1.78779000E-03  +3.63556000E-03  +5.43790000E-04
   -3.34760000E-04  -7.28790000E-04  -1.14308000E-03  +2.23980000E-04  +1.94280000E-03
   +1.74950000E-04  +2.04750000E-04  +2.90197000E-03  -4.78241500E-02  +1.42236000E-02
   -3.58956400E-02  -1.12112600E-02  +7.37095000E-03  +4.55316000E-03  +3.42300000E-05
   +8.65600000E-05  -2.75430000E-04  -5.76700000E-05  +3.82200000E-05  +4.86300000E-05
   +7.39090400E-02  +3.15610000E-04  +3.51795100E-02  -1.12402000E-03  +1.38775000E-03
   +7.56490000E-04  -3.00986300E-02  -4.74553000E-03  +6.27115000E-03  -8.68700000E-05
   +1.41487000E-03  +1.76758000E-03  -4.30350000E-04  -4.23380000E-04  -1.60910000E-04
   -6.54300000E-05  +4.39440000E-04  -3.52200000E-05  -7.99940000E-04  -1.01548000E-03
   +6.45000000E-06  -1.48970410E-01  -3.74371700E-02  -2.20694200E-02  -1.53109200E-02
   -4.20374000E-03  -7.63648000E-03  +2.56850000E-04  -2.81920000E-04  -1.76000000E-06
   +5.44523220E-01  +2.43085000E-03  -8.62480000E-04  -9.14870000E-04  +3.78423000E-03
   +4.80035000E-03  +6.19905000E-03  +1.26804000E-03  -1.12121000E-03  -2.02337000E-03
   +2.62760000E-04  +7.59100000E-04  +7.87900000E-05  -3.58590000E-04  +3.80100000E-05
   -8.01900000E-05  +2.13500000E-04  +1.03000000E-06  -2.80600000E-05  -3.35386700E-02
   -9.70623400E-02  +1.38049000E-03  +6.01534000E-03  +4.47754000E-03  -1.37940000E-03
   +3.79180000E-04  -2.59070000E-04  +7.22300000E-05  +1.18329280E-01  +4.52807490E-01
   +1.67220000E-04  -4.41300000E-04  +1.03560000E-04  +1.87882300E-02  +1.00681500E-02
   +3.82895000E-03  +2.02104000E-03  -2.55592000E-03  -2.78466000E-03  +6.62010000E-04
   +1.13666000E-03  +1.99070000E-04  -7.29650000E-04  -2.58260000E-04  -2.09060000E-04
   +8.13530000E-04  +1.02080000E-04  +2.45000000E-04  -1.48083700E-02  +4.30615000E-03
   -8.75265000E-02  -2.93620900E-02  -1.35797600E-02  -6.80439000E-03  +5.86010000E-04
   -4.12380000E-04  +1.33860000E-04  +1.16803070E-01  -2.01685990E-01  +4.84303190E-01
   +4.14420000E-04  -2.01030000E-04  -3.88310000E-04  +1.12168000E-03  -4.30140000E-04
   -6.68190000E-04  -1.74340000E-04  -3.21800000E-05  -1.97460000E-04  +2.37310000E-04
   -2.64740000E-04  +6.35600000E-05  +2.60600000E-04  +1.96740000E-04  +9.77200000E-05
   -1.24040000E-04  +1.89660000E-04  -1.39800000E-04  -1.88261200E-02  +6.51314000E-03
   -2.20791800E-02  -3.63754000E-03  -2.87549000E-03  +7.35670000E-04  -7.20100000E-05
   +8.12600000E-05  +1.54700000E-05  -1.81184220E-01  -3.24360000E-03  -7.28498700E-02
   +5.95991000E-01  +2.16390000E-04  -3.31720000E-04  +8.67700000E-05  -4.14160000E-04
   +4.03980000E-04  -1.09248000E-03  -3.75800000E-05  -1.17300000E-05  +6.00960000E-04
   +5.29100000E-05  -6.41500000E-05  +2.02400000E-05  +9.64400000E-05  +5.03200000E-05
   +4.26200000E-05  -1.15670000E-04  +2.17100000E-05  -2.43700000E-05  -5.53359000E-03
   +8.24525000E-03  -1.19885000E-02  -3.61687000E-03  -1.47776000E-03  -2.05980000E-04
   -2.71300000E-05  +1.67900000E-05  +1.81000000E-06  +3.92540400E-02  -1.24163830E-01
   +8.45027000E-02  +1.78660450E-01  +4.87487960E-01  +3.74590000E-04  -6.98960000E-04
   -6.47550000E-04  +1.23884000E-03  -7.01950000E-04  -1.43200000E-05  -5.12170000E-04
   +1.93490000E-04  -4.05310000E-04  +2.11210000E-04  -3.35680000E-04  +7.99400000E-05
   +8.28900000E-05  +2.88420000E-04  +7.14700000E-05  +1.46500000E-05  +3.83170000E-04
   -5.75300000E-05  -7.95421000E-03  -3.71228000E-03  -1.71920000E-04  +2.29980000E-04
   +4.77680000E-04  +2.05640000E-04  +1.67100000E-04  -6.94400000E-05  +4.92800000E-05
   -1.19541560E-01  +5.53834500E-02  -2.12035050E-01  +1.21644170E-01  -2.44860350E-01
   +4.99742650E-01  -3.00980000E-04  -4.51800000E-05  +3.59420000E-04  -4.16690000E-04
   +2.38980000E-04  -4.89150000E-04  +1.21550000E-04  +1.10300000E-04  +2.22020000E-04
   -1.25060000E-04  +1.20980000E-04  -9.79000000E-06  +1.73400000E-05  -2.41020000E-04
   -3.36600000E-05  +1.45920000E-04  -7.61200000E-05  +1.15580000E-04  +3.40493000E-03
   +1.11039000E-03  -3.67109000E-03  -8.63730000E-04  -5.15210000E-04  +1.76660000E-04
   -8.12300000E-05  +5.79500000E-05  -1.70100000E-05  -3.34691500E-02  +2.74367600E-02
   -5.91798600E-02  -2.94379240E-01  -1.24644400E-01  -2.96922600E-02  +6.13572980E-01
   -2.41360000E-04  -6.10600000E-05  +2.87300000E-04  -1.62758000E-03  -3.94710000E-04
   -7.23330000E-04  -6.20600000E-05  +2.97950000E-04  +4.08230000E-04  -1.99580000E-04
   +4.10000000E-07  -3.85400000E-05  +1.34220000E-04  -1.96290000E-04  -9.12000000E-06
   -4.27400000E-05  -4.73200000E-05  +5.06200000E-05  +4.89210000E-04  +1.86986000E-03
   +4.64985000E-03  +8.03670000E-04  +5.35270000E-04  +3.10380000E-04  -1.81040000E-04
   +1.41390000E-04  -4.22100000E-05  -5.24441000E-03  +4.19348400E-02  -4.07477200E-02
   -8.07975000E-02  -1.39117200E-01  +2.78674000E-02  +1.54547040E-01  +4.47836720E-01
   -1.26380000E-04  -8.79800000E-05  +1.38800000E-04  -3.73990000E-04  +3.33000000E-06
   -8.78220000E-04  -6.06300000E-05  +4.89000000E-05  +1.49160000E-04  +5.19100000E-05
   -7.42600000E-05  +1.05800000E-05  -9.87300000E-05  +1.20870000E-04  -1.88800000E-05
   +4.52300000E-05  +2.54500000E-05  +2.52500000E-05  -3.37931000E-03  +4.27419000E-03
   -9.68530000E-04  -7.80600000E-04  -3.68530000E-04  -3.41400000E-05  +1.44640000E-04
   -9.96400000E-05  +3.71700000E-05  -2.29536200E-02  -1.63606600E-02  +1.04901500E-02
   -7.76307600E-02  -4.02225000E-03  -1.11798690E-01  +1.77021130E-01  -2.36820120E-01
   +5.05776280E-01  -1.48240000E-04  -9.76200000E-05  -2.86210000E-04  +2.52990000E-04
   +5.77140000E-04  +5.09340000E-04  -1.05830000E-04  -8.95500000E-05  -4.94740000E-04
   +2.71360000E-04  -2.54840000E-04  +3.61000000E-05  -7.22670000E-04  +6.52450000E-04
   -1.18720000E-04  +1.96550000E-04  +1.92410000E-04  +6.12000000E-06  -1.61267000E-03
   -4.57120000E-04  -4.57760000E-04  +2.10860000E-04  +2.56960000E-04  -1.84150000E-04
   +9.74760000E-04  -6.76000000E-04  +1.61370000E-04  +6.73820000E-04  +1.19722800E-02
   -7.53639000E-03  -4.24879000E-03  -2.71430900E-02  +2.47167400E-02  -1.35620860E-01
   -8.18238000E-02  +4.13071500E-02  +6.14390070E-01  +9.30000000E-05  -5.57700000E-05
   -2.78570000E-04  +5.35250000E-04  +1.54510000E-04  +6.23560000E-04  -2.14800000E-05
   -1.69990000E-04  -3.27060000E-04  +1.71150000E-04  -7.16300000E-05  +1.75900000E-05
   -2.23170000E-04  +3.21130000E-04  -1.36200000E-05  -7.01000000E-06  +9.19000000E-05
   -4.96500000E-05  -1.00897000E-03  -1.33113000E-03  +4.71800000E-04  +6.94100000E-05
   +2.67560000E-04  -1.62510000E-04  +3.21560000E-04  -2.31850000E-04  +6.02700000E-05
   +1.21758100E-02  -3.55088900E-02  +4.05026900E-02  -6.46453500E-02  -1.85481600E-02
   -2.36126600E-02  -2.86003600E-02  -2.11431270E-01  +1.32319280E-01  +1.47971090E-01
   +4.72751670E-01  -3.20580000E-04  +1.79710000E-04  +2.16060000E-04  -2.04850000E-04
   +4.07100000E-04  -1.70410000E-04  +2.45800000E-05  +4.44000000E-05  -7.97500000E-05
   -3.95700000E-05  +1.47700000E-05  -6.10000000E-06  -2.90250000E-04  +5.17900000E-05
   -1.00420000E-04  +1.26040000E-04  -8.59700000E-05  +4.81800000E-05  +5.16500000E-05
   +5.63030000E-04  -1.15503000E-03  -1.27410000E-04  +9.55500000E-05  +1.28800000E-04
   +2.80820000E-04  -2.11780000E-04  +3.70100000E-05  -8.03407000E-03  +4.00394000E-02
   -5.47155000E-02  +6.43866800E-02  +3.26200000E-03  +4.53880200E-02  -1.53818300E-02
   +9.50709600E-02  -1.82643680E-01  +1.57446550E-01  -2.27745400E-01  +5.18497580E-01
   +3.06780000E-04  -2.39580000E-04  -4.10710000E-04  +3.39690000E-04  -4.02380000E-04
   +5.29720000E-04  +3.18200000E-05  -1.69200000E-05  +8.73400000E-05  +2.79000000E-06
   +2.13300000E-05  -1.90800000E-05  +3.15440000E-04  -1.13910000E-04  +1.13290000E-04
   -8.54400000E-05  +1.50870000E-04  -3.26000000E-05  +3.40531000E-03  -1.61441000E-03
   -5.64510000E-04  -1.26770000E-04  -2.28800000E-05  +2.37330000E-04  -3.12020000E-04
   +2.61190000E-04  -5.52000000E-05  -4.60056000E-03  -5.89453700E-02  +5.39780000E-02
   -5.38309000E-02  -1.38158000E-03  -3.48945100E-02  +5.33332500E-02  +4.17645700E-02
   -1.35812600E-02  -1.69425920E-01  -1.56103000E-03  -6.66698000E-02  +6.07343100E-01
   -3.63000000E-05  -2.33460000E-04  -2.73700000E-04  -5.22130000E-04  -9.50580000E-04
   +1.73150000E-04  -2.05600000E-04  +3.21290000E-04  +1.61120000E-04  -2.50000000E-06
   -2.37680000E-04  -1.74900000E-05  +2.79700000E-05  +1.39950000E-04  +5.69800000E-05
   -8.19600000E-05  +1.78370000E-04  -6.08200000E-05  -1.51074000E-03  +6.51980000E-04
   +4.98692000E-03  +8.43540000E-04  +3.93000000E-06  +3.34980000E-04  +5.24300000E-05
   +1.26700000E-05  +4.80000000E-06  -2.62167400E-02  -1.47267300E-02  +6.30858000E-03
   -2.56092000E-03  -2.86221000E-03  -2.67299000E-03  +1.12676300E-02  -5.34908000E-03
   +2.33627900E-02  +4.80215400E-02  -1.35490820E-01  +1.02305330E-01  +1.84392660E-01
   +4.85687420E-01  +8.85100000E-05  -2.42670000E-04  -2.08880000E-04  -7.57150000E-04
   -6.67420000E-04  -2.14410000E-04  -8.90000000E-05  +1.82690000E-04  +3.13660000E-04
   -3.84400000E-05  -6.82800000E-05  +9.76000000E-06  +3.04790000E-04  -7.69500000E-05
   +9.68200000E-05  -1.35050000E-04  +2.02100000E-05  -2.56000000E-05  -1.41764000E-03
   +5.39246000E-03  +3.04280000E-04  -9.57260000E-04  -3.41430000E-04  -3.25100000E-04
   -2.82760000E-04  +2.25110000E-04  -3.47500000E-05  +2.01837900E-02  -1.74469300E-02
   +3.94960700E-02  -3.28388400E-02  -1.52091000E-03  -2.50631700E-02  +1.88878000E-02
   +4.50606500E-02  -2.56294800E-02  -1.20587060E-01  +6.73585900E-02  -2.28412080E-01
   +1.38054000E-01  -2.53448780E-01  +4.99170430E-01  -4.25400000E-04  +1.74080000E-04
   +1.22492000E-03  -1.31016000E-03  -7.95840000E-04  -1.39221000E-03  -2.65920000E-04
   +5.13940000E-04  +4.77790000E-04  -1.01770000E-04  -1.97610000E-04  -3.81000000E-06
   +1.47280000E-04  +5.57500000E-05  -3.84800000E-05  -2.00990000E-04  -6.43500000E-05
   -8.12800000E-05  -8.68607000E-03  -2.26151100E-02  +1.46668600E-02  -2.18688000E-03
   -1.17596000E-03  +5.84000000E-04  -2.45800000E-05  -6.74000000E-06  -1.34100000E-05
   -1.42822920E-01  -4.46911300E-02  -2.99801000E-03  +5.58658600E-02  +1.25812500E-02
   +2.01368900E-02  -3.81011300E-02  -3.31567400E-02  +1.13968200E-02  -3.64769100E-02
   +3.34678100E-02  -6.34970100E-02  -2.93457420E-01  -1.25359300E-01  -2.85463600E-02
   +6.11017880E-01  +5.20490000E-04  -4.69060000E-04  -5.62910000E-04  +1.03705000E-03
   -9.77480000E-04  -1.86400000E-03  -4.03110000E-04  +2.06460000E-04  -6.39900000E-05
   +2.37200000E-04  -2.73030000E-04  +1.76210000E-04  -4.40700000E-05  +2.00830000E-04
   +2.81900000E-05  +2.06840000E-04  +2.22820000E-04  +8.69800000E-05  -1.05880300E-02
   -7.78342000E-03  +4.04155000E-03  -1.64968000E-03  -1.03488000E-03  +4.01800000E-04
   +2.44540000E-04  -1.39250000E-04  +7.12600000E-05  -8.81834900E-02  -2.07591770E-01
   +9.06040400E-02  +4.60726700E-02  -8.86662000E-03  +5.18773000E-02  -3.52471300E-02
   -3.70054000E-02  +1.04305900E-02  -3.61999000E-03  +4.63788500E-02  -4.98872800E-02
   -8.11603300E-02  -1.41079610E-01  +2.85983300E-02  +1.40412820E-01  +4.50282330E-01
   +6.88130000E-04  +2.20600000E-05  -4.82020000E-04  -8.28100000E-04  -9.39840000E-04
   -1.83060000E-04  -1.61980000E-04  +1.82550000E-04  +3.67320000E-04  -1.12690000E-04
   -1.20910000E-04  -1.41700000E-05  +6.84700000E-05  -5.29200000E-05  +4.02900000E-05
   -1.98480000E-04  +1.49040000E-04  -1.16300000E-04  +1.94588000E-03  -3.98668000E-03
   +7.66054000E-03  -3.75590000E-04  -1.52299000E-03  +2.04150000E-04  -1.15100000E-04
   +1.24190000E-04  -6.03500000E-05  +4.21237400E-02  +1.20293490E-01  -1.67556250E-01
   -1.49625500E-02  +2.76197600E-02  -3.17933200E-02  +1.29355400E-02  +1.13309200E-02
   -7.06001000E-03  -2.37652800E-02  -2.26628400E-02  +1.03530100E-02  -7.51724000E-02
   -2.68201000E-03  -1.11346660E-01  +1.74456720E-01  -2.28397970E-01  +5.14149830E-01
   +1.23070000E-04  -1.06600000E-05  +3.74460000E-04  -3.59170000E-04  -8.71720000E-04
   -1.10285000E-03  -1.98000000E-06  +2.75860000E-04  +7.20790000E-04  -3.12410000E-04
   +1.51880000E-04  -3.12500000E-05  +8.81320000E-04  -7.12950000E-04  +1.44440000E-04
   -2.42170000E-04  -1.41700000E-04  -5.24000000E-06  +1.57736000E-03  +9.25890000E-04
   +8.75430000E-04  -4.61670000E-04  -4.57830000E-04  +3.13530000E-04  -1.10629000E-03
   +7.85590000E-04  -1.84640000E-04  -3.05571000E-03  -2.28030000E-03  +1.26900000E-05
   +2.85442000E-03  -1.99658000E-03  -1.03713000E-03  -2.69166400E-02  -1.91114400E-02
   -5.10099000E-03  -2.54676640E-01  -1.16196830E-01  -2.32527300E-02  -4.04606500E-02
   -1.46873500E-02  -1.74532700E-02  +4.57244000E-03  +1.61078000E-03  -2.01975000E-03
   +4.50497280E-01  +2.99700000E-05  -1.03900000E-05  +1.77340000E-04  -9.28000000E-06
   -3.80440000E-04  -3.68930000E-04  -6.00000000E-06  +1.29970000E-04  +2.90270000E-04
   -1.27010000E-04  +4.77400000E-05  -7.24000000E-06  +3.97180000E-04  -3.12260000E-04
   +6.22500000E-05  -1.14140000E-04  -5.58700000E-05  +1.11000000E-06  +1.11592000E-03
   +2.42320000E-04  -2.30290000E-04  -1.93380000E-04  -2.20270000E-04  +1.65700000E-04
   -4.88150000E-04  +3.61380000E-04  -8.21400000E-05  -1.90585000E-03  +1.33947000E-03
   -4.68983000E-03  +3.64299000E-03  +1.41771000E-03  +9.18896000E-03  -4.45966900E-02
   -1.53499800E-02  -4.28913000E-03  -8.33165800E-02  -1.23514220E-01  +2.67782400E-02
   +9.74131000E-03  +1.45478000E-02  -5.30740000E-04  -2.62464000E-03  -2.34968000E-03
   +6.17378000E-03  +4.88124200E-02  +2.50061840E-01  +3.75600000E-05  -2.57000000E-05
   +1.01560000E-04  -3.22700000E-05  -1.49260000E-04  -2.87940000E-04  +2.26000000E-06
   +5.17700000E-05  +1.67240000E-04  -4.27800000E-05  +2.21300000E-05  +2.38000000E-06
   +1.98670000E-04  -1.37400000E-04  +3.54200000E-05  -5.73500000E-05  -2.89600000E-05
   +1.26500000E-05  +6.60970000E-04  -2.64170000E-04  +7.45000000E-05  -1.10710000E-04
   -7.96600000E-05  +3.67900000E-05  -2.35670000E-04  +1.70560000E-04  -2.89700000E-05
   +5.69850000E-04  -4.46738000E-03  +3.63613000E-03  -7.00802000E-03  +5.09450000E-03
   -3.01514000E-03  +2.19004100E-02  +1.33015300E-02  +1.09088600E-02  -5.80461100E-02
   +4.00736000E-03  -8.87309300E-02  -4.42093300E-02  -1.77898100E-02  -4.33004000E-03
   +2.49027000E-03  +9.27972000E-03  -2.87065000E-03  +2.42974880E-01  -2.03337000E-01
   +4.12770570E-01  -3.22962000E-03  +6.64600000E-05  +2.72119000E-03  -3.21693000E-03
   +2.30945700E-02  +1.81500000E-03  +6.37700000E-05  +7.01280000E-04  -1.13400000E-04
   -8.04700000E-05  +7.16110000E-04  +1.43800000E-05  +1.50340000E-04  -8.66520000E-04
   +1.20530000E-04  +8.69170000E-04  +8.37830000E-04  +9.57500000E-05  -7.62180700E-02
   +6.71583000E-03  -1.57241000E-03  -2.06885000E-03  +1.25455800E-02  -3.42427000E-03
   -6.17800000E-04  +4.19920000E-04  -9.82300000E-05  -4.72630000E-04  -3.20196600E-02
   +2.49139000E-03  -9.85820000E-04  -1.51342000E-03  -1.34520000E-03  +3.84540000E-04
   -1.15930000E-04  +6.18460000E-04  +7.76420000E-04  -1.77780000E-04  +6.46760000E-04
   -1.58507000E-03  +3.26100000E-05  +8.96840000E-04  -3.24855000E-03  -6.73990000E-04
   -2.47092000E-03  -1.13332000E-03  -4.23170000E-04  -2.90730000E-04  +5.84099790E-01
   +7.01400000E-04  +1.48450000E-04  -2.85800000E-05  +7.50411000E-03  -1.46587000E-02
   -5.76678000E-03  +1.08180000E-03  +1.07319000E-03  -5.06610000E-04  -5.70550000E-04
   -6.66230000E-04  -1.27320000E-04  +9.53800000E-05  +4.45800000E-05  +1.55520000E-04
   -5.78000000E-05  -2.41500000E-05  -2.67550000E-04  +7.95203000E-03  -1.70773740E-01
   +6.41278000E-03  +4.39342000E-03  -1.72738500E-02  +7.77006000E-03  +3.24100000E-05
   -1.09870000E-04  +6.82000000E-06  -8.18570000E-03  -2.09959400E-02  -1.05923000E-03
   +5.22100000E-04  -8.67800000E-05  -1.77390000E-04  +3.89560000E-04  -1.18030000E-04
   +6.51940000E-04  -8.41000000E-05  -1.41440000E-04  +2.16810000E-04  -5.07460000E-04
   +1.35940000E-04  +3.09860000E-04  +4.08380000E-04  +2.41400000E-05  -1.46488000E-03
   +1.19190000E-04  +3.55300000E-05  +1.63900000E-05  +1.16684300E-02  +4.62168230E-01
   +3.39989000E-03  -8.21800000E-05  -2.81627000E-03  +4.20684000E-03  -2.45002000E-02
   -9.05160000E-04  +4.27180000E-04  +7.29120000E-04  -1.87560000E-04  -1.57310000E-04
   -1.15084000E-03  +7.41000000E-06  -7.18300000E-05  +6.73360000E-04  -5.83700000E-05
   -4.73690000E-04  -1.00100000E-03  +4.73600000E-05  -2.41770000E-03  +2.33623000E-03
   -7.68368000E-02  -6.25317000E-03  +3.56166800E-02  -5.73365000E-03  +5.80450000E-04
   -5.14430000E-04  +1.36740000E-04  +1.14101000E-03  -6.60568000E-03  +6.66940000E-04
   -8.04060000E-04  -1.00889000E-03  +8.25610000E-04  +4.57660000E-04  +2.61530000E-04
   -2.13450000E-04  +3.33050000E-04  -2.35190000E-04  +2.37760000E-04  -3.73620000E-04
   +1.05730000E-04  +4.53700000E-05  -3.11510000E-04  +5.60500000E-05  -6.67450000E-04
   -2.79110000E-04  -2.26100000E-05  -9.28300000E-05  +4.37316000E-03  -6.23995000E-03
   +5.95270120E-01  +2.46913000E-03  +1.01848300E-02  -7.80743000E-03  -8.40629500E-02
   +2.22315100E-02  -1.53415800E-02  -2.53188900E-02  +1.51772600E-02  -4.02141400E-02
   -3.63640000E-04  -8.26721000E-03  -1.21943000E-03  +3.18800000E-03  +2.22890000E-03
   -9.36900000E-05  -8.62180000E-04  +1.05100000E-04  -4.07930000E-04  +6.27076000E-03
   -5.77064000E-03  +2.09012600E-02  -3.53347000E-03  +1.77763000E-03  +2.85823000E-03
   -1.92360000E-03  +1.51839000E-03  -6.02540000E-04  +9.49200000E-05  -1.22038000E-03
   +9.50960000E-04  -4.75329000E-03  +1.63658000E-03  +5.55650000E-04  +7.62150000E-04
   +6.47860000E-04  +8.81410000E-04  +6.08530000E-04  -5.28550000E-04  +6.17210000E-04
   -9.35280000E-04  -4.19950000E-04  -2.46120000E-04  +8.88510000E-04  +9.81670000E-04
   -2.93140000E-04  -4.41290000E-04  -3.02630000E-04  -9.68300000E-05  +3.84300000E-04
   +5.75590000E-04  -2.31170000E-04  +3.27139800E-01  +2.26019400E-02  -2.67376500E-02
   +4.06314700E-02  +2.46366100E-02  -7.92710300E-02  +2.22179500E-02  +6.69940000E-04
   +1.02752300E-02  -2.67476000E-03  +3.03700000E-05  -3.16472000E-03  -1.02620000E-04
   +2.00722000E-03  +4.77091000E-03  +1.38357000E-03  -9.28334000E-03  -4.10872000E-03
   -8.80410000E-04  -1.37124000E-03  +3.80045000E-03  -7.85676000E-03  +1.75775000E-03
   -2.75910000E-04  -1.48238000E-03  +1.91951000E-03  -1.25161000E-03  +4.66290000E-04
   -7.40100000E-04  +5.28670000E-04  +2.52610000E-04  +4.21020000E-04  -6.07770000E-04
   +7.53140000E-04  +5.87900000E-05  +4.26280000E-04  -2.13250000E-04  +1.56380000E-04
   +8.40000000E-06  +9.92800000E-05  +4.86600000E-05  +1.33920000E-04  -3.55900000E-05
   +3.79000000E-06  +8.02500000E-05  -5.18100000E-05  -4.03000000E-06  +9.38100000E-05
   -2.73600000E-05  +1.27068000E-03  -1.50352000E-03  -3.53430000E-04  -1.74734500E-01
   +1.72930560E-01  -8.00886000E-03  +1.80537400E-02  -1.23079700E-02  -3.84745400E-02
   +3.95773300E-02  -1.49487190E-01  -2.25751000E-02  +8.98953000E-03  -2.27656300E-02
   -1.01808000E-03  -5.62940000E-03  -8.47780000E-04  +1.40295000E-03  +4.05410000E-04
   -1.71798000E-03  +2.78078000E-03  +1.93895000E-03  -1.00500000E-05  -7.40556000E-03
   +1.10633900E-02  -4.01152900E-02  +6.38682000E-03  -2.85853000E-03  -3.31646000E-03
   -1.97209000E-03  +1.44271000E-03  -2.60420000E-04  -2.66301000E-03  -1.35874000E-03
   +3.62600000E-04  +1.60545000E-03  +6.63240000E-04  -3.91140000E-04  +5.45380000E-04
   +3.68160000E-04  +3.35530000E-04  -3.13570000E-04  -1.63240000E-04  +3.77500000E-05
   -1.31330000E-04  -2.01730000E-04  +1.18100000E-04  +4.28120000E-04  +3.07640000E-04
   -9.17700000E-05  +5.58090000E-04  +2.13100000E-04  +2.09690000E-04  -2.62520000E-04
   +4.60930000E-04  -3.21200000E-05  -1.67460290E-01  +6.27140800E-02  +5.07147860E-01
   -2.71600000E-05  -3.30700000E-05  -3.69200000E-05  -2.37900000E-05  +8.67500000E-05
   +3.29000000E-05  -1.89800000E-05  -8.99000000E-06  -5.36400000E-05  +4.33400000E-05
   -4.36300000E-05  +7.22000000E-06  -1.33840000E-04  +1.28210000E-04  -2.36600000E-05
   +1.75800000E-05  +2.83300000E-05  +2.35000000E-06  -1.99780000E-04  -1.37640000E-04
   +7.70800000E-05  +6.30700000E-05  +5.91300000E-05  -2.44600000E-05  +1.80950000E-04
   -1.21530000E-04  +3.28400000E-05  +4.31390000E-04  -3.76400000E-04  +6.92240000E-04
   -9.07030000E-04  +2.40320000E-04  -4.39660000E-04  +3.34225000E-03  +2.27116000E-03
   +5.53060000E-04  -2.62992200E-02  +1.86610100E-02  -3.64074800E-02  -4.78189000E-03
   -4.95974000E-03  +4.54030000E-04  +5.79480000E-04  +9.91910000E-04  -1.83556000E-03
   -1.32727150E-01  +6.83813800E-02  -1.62695310E-01  +1.04160000E-04  +5.78000000E-06
   -5.91000000E-06  +1.36910000E-04  +7.23000000E-06  -7.35000000E-06  +1.60578350E-01
   +1.44600000E-05  +1.63000000E-06  -2.13900000E-05  -7.40400000E-05  +3.01100000E-05
   -3.33100000E-05  +2.18000000E-06  -3.29000000E-06  -6.50000000E-07  +1.00000000E-06
   -4.45000000E-06  -4.15000000E-06  -3.85300000E-05  +2.39800000E-05  -4.87000000E-06
   +1.30800000E-05  +3.53000000E-06  -3.49000000E-06  +4.37200000E-05  -8.26900000E-05
   +1.01730000E-04  +3.73100000E-05  +6.77000000E-06  +3.59000000E-06  +4.23100000E-05
   -3.66700000E-05  +4.60000000E-06  -8.00000000E-07  -1.53070000E-04  +2.09620000E-04
   +5.97300000E-05  -6.55120000E-04  +3.16800000E-05  -1.99054000E-03  +7.09670000E-04
   -3.15673000E-03  -1.21902300E-02  +6.47637000E-03  -1.81661300E-02  -3.90827000E-03
   -4.68740000E-04  +8.14400000E-05  -2.40940000E-04  +1.33033000E-03  +2.26800000E-04
   +1.01613150E-01  -1.24516440E-01  +1.99326620E-01  -4.75200000E-05  +3.60000000E-07
   -3.60300000E-05  +7.38700000E-05  -4.12700000E-05  +3.00000000E-08  -8.37510300E-02
   +1.18327970E-01  -5.01000000E-06  +1.50100000E-05  -4.69200000E-05  +4.73400000E-05
   +6.08800000E-05  +1.23880000E-04  +5.75000000E-06  -2.81300000E-05  -7.13600000E-05
   +1.91600000E-05  -1.13000000E-06  +2.40000000E-07  -5.72400000E-05  +3.87000000E-05
   -9.28000000E-06  +2.68300000E-05  +5.44000000E-06  -3.49000000E-06  -1.29860000E-04
   -7.68700000E-05  -1.01460000E-04  +2.53900000E-05  +3.89700000E-05  -1.26100000E-05
   +6.83800000E-05  -5.11000000E-05  +6.35000000E-06  +2.07780000E-04  -5.77000000E-06
   +3.69860000E-04  -2.42680000E-04  +1.47560000E-04  -1.01780000E-03  +5.14625000E-03
   -1.41590000E-04  +2.82761000E-03  -3.64757000E-03  +3.26224000E-03  -8.66617000E-03
   -7.08380000E-04  -6.87650000E-04  +2.33654000E-03  -5.16930000E-04  +1.11500000E-03
   +1.36070000E-04  -1.97959130E-01  +1.76204360E-01  -3.28874450E-01  +5.60800000E-05
   -1.75400000E-05  +3.11100000E-05  +1.32400000E-05  -8.51000000E-06  -1.01470000E-04
   +1.98067530E-01  -1.79655940E-01  +3.33242660E-01  -1.20800000E-05  -2.87100000E-05
   +7.85500000E-05  +6.47500000E-05  -5.29700000E-05  -2.61990000E-04  -2.52000000E-06
   +3.31100000E-05  +9.75600000E-05  -1.53100000E-05  -5.26000000E-06  +6.44000000E-06
   +7.55200000E-05  -4.32500000E-05  +8.47000000E-06  -2.90000000E-05  -6.10000000E-07
   +5.71000000E-06  +1.86100000E-05  +7.29240000E-04  -1.12489000E-03  -4.44620000E-04
   -2.39220000E-04  +6.33900000E-05  -8.15000000E-05  +5.90100000E-05  -8.09000000E-06
   -2.57326000E-03  -4.86173000E-03  -1.60997000E-03  -1.13576100E-02  +1.15533100E-02
   -2.23356700E-02  -1.38071240E-01  +4.42210600E-02  -1.21545980E-01  +5.81854000E-03
   -5.49563000E-03  +7.14786000E-03  +1.41864000E-03  -3.10531000E-03  +5.16220000E-04
   -8.42450000E-04  -6.53670000E-04  +7.22490000E-04  +2.45800000E-03  +1.85651000E-03
   +2.49283000E-03  +4.24000000E-06  +1.35140000E-04  -7.37000000E-06  +2.18600000E-05
   +1.35900000E-05  +2.71510000E-04  -1.67310000E-04  +4.12910000E-04  -9.47060000E-04
   +1.43673690E-01  +3.84000000E-06  +1.44000000E-06  -1.44800000E-05  +2.97000000E-06
   +7.47000000E-06  -3.78700000E-05  +1.51000000E-05  +6.60000000E-06  +2.46200000E-05
   -1.12800000E-05  +8.45000000E-06  -8.12000000E-06  -4.68000000E-06  -1.47000000E-05
   +4.13000000E-06  +1.08100000E-05  -5.31000000E-06  -2.45000000E-06  -2.37960000E-04
   +5.44980000E-04  -4.00440000E-04  -9.10100000E-05  -1.17120000E-04  +4.71300000E-05
   -7.20000000E-07  -1.11000000E-06  -3.61000000E-06  -4.55187000E-03  +2.53674000E-03
   +1.97661000E-03  -7.71634000E-03  +8.08588000E-03  -1.11967600E-02  +4.43881800E-02
   -8.11658000E-02  +8.28260000E-02  +1.51481000E-02  -2.70091000E-03  +1.78934300E-02
   -3.59602000E-03  -1.15231000E-03  +4.49286000E-03  -8.31210000E-04  -1.03772000E-03
   -4.41930000E-04  +2.28903000E-03  -1.59240000E-04  -2.40378000E-03  +1.16700000E-05
   -7.56000000E-06  +3.26700000E-05  +6.51600000E-05  -8.08900000E-05  -6.94000000E-06
   -1.51645000E-03  -5.72260000E-04  +1.62780000E-04  -4.60812100E-02  +7.79833900E-02
   +1.05000000E-05  -1.53000000E-06  +7.94000000E-06  +1.87500000E-05  -4.76200000E-05
   -5.04700000E-05  +1.19200000E-05  +1.21900000E-05  +4.66000000E-05  -2.28600000E-05
   +2.05400000E-05  -4.45000000E-06  +5.77800000E-05  -5.36500000E-05  +1.06500000E-05
   -1.14300000E-05  -9.65000000E-06  +3.80000000E-07  +7.40300000E-05  +4.29890000E-04
   -1.09900000E-04  -5.66400000E-05  -8.89400000E-05  +6.92100000E-05  -7.05600000E-05
   +4.79500000E-05  -1.12600000E-05  -2.11342000E-03  +1.51926000E-03  +4.17062000E-03
   -1.64872000E-03  +2.65777000E-03  -1.34905000E-03  -1.21693930E-01  +8.28367300E-02
   -2.08121860E-01  -1.49423000E-02  +3.26277000E-03  -9.98866000E-03  +9.86400000E-04
   +4.84249000E-03  +8.63280000E-04  +9.55720000E-04  -1.78970000E-04  +4.66000000E-06
   +1.95788000E-03  -2.72743000E-03  +4.00960000E-04  -8.73100000E-05  -4.23800000E-05
   +4.50000000E-05  -2.31800000E-05  -4.43000000E-05  +1.24700000E-05  +1.13561000E-03
   +1.51173000E-03  -2.71480000E-04  +1.34633830E-01  -9.14588100E-02  +2.16432020E-01
   +3.31300000E-05  -2.86900000E-05  +1.79260000E-04  -1.00322000E-03  +2.72560000E-04
   -1.38218000E-03  -5.63200000E-05  +4.74600000E-05  +2.49690000E-04  +5.25000000E-06
   -9.62000000E-06  +2.02000000E-06  -1.64900000E-04  +1.00740000E-04  -3.07200000E-05
   +2.20900000E-05  -7.46400000E-05  +1.60300000E-05  -3.09450000E-04  +1.06868000E-03
   +1.12458000E-03  +1.29690000E-04  +1.23000000E-05  +7.47800000E-05  +1.81070000E-04
   -1.40750000E-04  +4.09500000E-05  +1.09309200E-02  +1.36510200E-02  -1.06846300E-02
   -8.14425800E-02  -7.28814300E-02  +4.81783700E-02  -5.06921000E-03  -2.13994600E-02
   +1.70563900E-02  -2.69107000E-03  -3.34639000E-03  -3.62345000E-03  -9.51980000E-04
   +3.72590000E-04  -2.92840000E-04  -8.80730000E-04  -1.23310000E-04  -4.78495000E-03
   -7.65930000E-04  -1.23725000E-03  +7.74260000E-04  -9.38270000E-04  -3.79140000E-04
   -9.43570000E-04  +4.77200000E-05  -6.33800000E-05  +3.22680000E-04  +1.76300000E-04
   -2.26200000E-05  +1.70230000E-04  -3.49000000E-05  +1.62364000E-03  +1.22427000E-03
   +8.32168000E-02  +4.95600000E-05  +1.06570000E-04  -9.18500000E-05  +7.10280000E-04
   -9.68400000E-05  +1.15075000E-03  +6.85000000E-05  -4.79900000E-05  -3.12650000E-04
   -1.69100000E-05  +3.44200000E-05  -7.88000000E-06  +4.41000000E-05  -5.66000000E-05
   +6.89000000E-06  +5.76000000E-06  +2.19000000E-06  -2.21500000E-05  +8.29270000E-04
   -1.85630000E-03  -1.58407000E-03  +2.54000000E-05  -1.49780000E-04  -1.17650000E-04
   -6.89600000E-05  +4.82000000E-05  -2.04600000E-05  -4.54366000E-03  -3.32373000E-03
   +5.52134000E-03  -7.08032700E-02  -2.07438960E-01  +1.35400530E-01  -2.91437000E-03
   -5.37006000E-03  +9.00014000E-03  -3.92507000E-03  +4.13643000E-03  +1.69809000E-03
   +5.01710000E-04  -2.75300000E-05  -9.20120000E-04  -1.03100000E-05  +3.19882000E-03
   +3.82174000E-03  -4.62680000E-04  -7.22300000E-04  +2.78090000E-04  -1.10893000E-03
   -4.17700000E-04  -5.01440000E-04  -1.50291000E-03  +3.70790000E-04  -4.13680000E-04
   +1.28780000E-04  -2.40700000E-05  +8.92400000E-05  +1.45789000E-03  -1.55326000E-03
   -2.39244000E-03  +8.34666500E-02  +2.14626220E-01  +6.47400000E-05  +1.10270000E-04
   -5.58600000E-05  -3.87500000E-05  +2.01430000E-04  +3.97050000E-04  +9.30400000E-05
   -5.80300000E-05  -7.87600000E-05  -1.20500000E-05  +3.59100000E-05  -3.89000000E-06
   -3.79600000E-05  -1.48900000E-05  -1.36200000E-05  +3.79900000E-05  -5.03700000E-05
   +2.32000000E-06  +1.92332000E-03  -6.00190000E-04  -9.08750000E-04  -1.79200000E-05
   -2.82450000E-04  -5.17200000E-05  +8.85000000E-06  -2.49900000E-05  -1.17000000E-06
   +8.89847000E-03  +1.76367300E-02  -8.51455000E-03  +4.63889300E-02  +1.36919050E-01
   -1.57656580E-01  -3.70127000E-03  -5.40631000E-03  +7.62350000E-03  -3.59875000E-03
   +1.67329000E-03  +3.29810000E-03  -4.11440000E-04  -8.80820000E-04  -4.85110000E-04
   -4.95553000E-03  +3.58066000E-03  -8.18120000E-04  -1.09410000E-04  -3.95590000E-04
   +2.15950000E-04  -1.03960000E-04  +1.11370000E-04  -5.79970000E-04  +5.77360000E-04
   -2.61210000E-04  -6.04200000E-04  +3.96500000E-05  +5.90000000E-07  +1.12200000E-05
   +1.55040000E-03  -1.98719000E-03  -1.06373000E-03  -4.67540600E-02  -1.49326540E-01
   +1.59092320E-01  +1.20390000E-04  -5.26700000E-05  -4.74200000E-05  -2.95850000E-04
   -2.35310000E-04  +1.14710000E-04  -6.44600000E-05  +5.61800000E-05  +3.73700000E-05
   +2.79000000E-06  -5.32500000E-05  +9.10000000E-07  -9.70700000E-05  +8.63800000E-05
   -8.88000000E-06  -2.98500000E-05  +3.44800000E-05  -9.23500000E-05  -9.73510000E-04
   +1.23007000E-03  +7.63970000E-04  -2.01920000E-03  -2.44733000E-03  -2.01640000E-04
   +7.93300000E-05  -5.15400000E-05  +7.64000000E-06  +1.01447800E-02  -2.92675000E-03
   +7.12126000E-03  +1.26448000E-03  -3.70559000E-03  +2.71860000E-04  -6.85880000E-04
   -4.93540000E-04  +7.82510000E-04  -1.99310000E-03  -4.88051000E-03  -1.82863000E-03
   -1.16567900E-02  +1.06788600E-02  -2.24579500E-02  -1.38740380E-01  +4.96790300E-02
   -1.22450030E-01  -8.71120000E-04  +5.40860000E-04  -1.25732000E-03  +3.73610000E-04
   +1.08270000E-04  -2.10280000E-04  -1.37900000E-05  +2.81500000E-05  -1.56380000E-04
   -3.79580000E-04  -9.87700000E-05  -4.12700000E-05  -1.43930000E-04  +2.42030000E-04
   +1.48250000E-04  +3.90270000E-04  -2.12920000E-04  +5.29620000E-04  +1.48392770E-01
   +1.52900000E-05  +1.07640000E-04  +2.64000000E-05  +1.79440000E-04  +3.72750000E-04
   +2.88940000E-04  +6.81900000E-05  -1.13920000E-04  -1.04410000E-04  -4.18200000E-05
   +4.37400000E-05  -5.45300000E-05  -1.03140000E-04  +2.95400000E-05  -1.11400000E-05
   +2.59700000E-05  -1.28500000E-05  +5.82000000E-06  +2.46908000E-03  -1.09531000E-03
   -1.09628000E-03  -6.41950000E-04  -4.40830000E-04  +2.72320000E-04  +7.37700000E-05
   -8.29200000E-05  +9.18000000E-06  +1.39172500E-02  -2.74289000E-03  +1.70676100E-02
   -3.95120000E-03  -8.89290000E-04  +5.24292000E-03  -5.52040000E-04  -9.00940000E-04
   -5.48590000E-04  -4.81686000E-03  +2.81764000E-03  +2.28006000E-03  -8.75178000E-03
   +8.18084000E-03  -1.02596300E-02  +4.90682100E-02  -8.68516000E-02  +8.48447600E-02
   -2.25200000E-04  +3.60740000E-04  -5.08220000E-04  -3.97460000E-04  -1.19990000E-04
   -2.04450000E-04  -5.84600000E-05  -2.47800000E-05  -2.46790000E-04  -1.61680000E-04
   -1.60930000E-04  -1.62350000E-04  +2.75200000E-04  -2.77280000E-04  -2.73870000E-04
   +8.88530000E-04  -3.02970000E-04  +9.32530000E-04  -4.80096400E-02  +8.39142900E-02
   -6.10300000E-05  +1.19230000E-04  +2.38180000E-04  +1.94850000E-04  +5.88890000E-04
   -8.16600000E-05  +1.35770000E-04  -1.65310000E-04  -8.24800000E-05  -7.25000000E-06
   +1.76790000E-04  -7.43000000E-06  +4.63800000E-05  -1.46480000E-04  -1.68700000E-05
   +1.23020000E-04  -1.26080000E-04  +8.23700000E-05  -1.27300000E-05  -1.80915000E-03
   -2.01228000E-03  -1.72102000E-03  -7.55020000E-04  +2.25730000E-04  -9.95300000E-05
   +4.18500000E-05  -1.28400000E-05  -1.12583700E-02  +5.10339000E-03  -9.16738000E-03
   +3.99130000E-04  +5.28111000E-03  +1.10082000E-03  +8.57530000E-04  -4.63120000E-04
   +3.33900000E-05  -1.90199000E-03  +2.21809000E-03  +4.35427000E-03  -1.84622000E-03
   +3.19725000E-03  -4.19970000E-04  -1.22000610E-01  +8.57860900E-02  -2.16506120E-01
   -3.68880000E-04  +5.90300000E-05  -2.82300000E-04  -2.35910000E-04  -2.22380000E-04
   +5.85000000E-06  +1.80120000E-04  -1.11480000E-04  +1.64870000E-04  +4.59800000E-05
   -1.06390000E-04  -5.47900000E-05  +1.08230000E-04  -2.96840000E-04  -3.13900000E-04
   -6.22800000E-04  +2.14210000E-04  -5.65140000E-04  +1.37340030E-01  -9.44289900E-02
   +2.23997080E-01  +1.44600000E-05  -1.54400000E-05  +3.00000000E-07  +2.89300000E-05
   -1.45680000E-04  -1.25920000E-04  -2.98800000E-05  +6.61500000E-05  +6.00100000E-05
   -8.07000000E-06  -3.45100000E-05  +0.00000000E+00  +4.89000000E-05  -1.30000000E-05
   +1.12000000E-05  -3.13300000E-05  +9.37000000E-06  -1.80800000E-05  +2.76260000E-04
   -8.42510000E-04  +7.24340000E-04  +5.94600000E-05  +2.67600000E-05  +1.15420000E-04
   -4.84400000E-05  +4.92600000E-05  -1.51200000E-05  -2.93858000E-03  -3.36709000E-03
   -3.34159000E-03  -1.23233000E-03  +3.35860000E-04  -4.87200000E-04  -8.46680000E-04
   -1.69530000E-04  -4.31297000E-03  +9.93890000E-03  +1.32543100E-02  -1.09106500E-02
   -8.43697300E-02  -7.57434800E-02  +4.66040500E-02  -4.14394000E-03  -2.06852800E-02
   +1.76823600E-02  +6.66360000E-04  +9.37540000E-04  +1.97667000E-03  -3.88360000E-04
   -5.83700000E-05  -7.61100000E-05  -1.58100000E-05  +2.76000000E-05  +3.56000000E-05
   +3.80900000E-05  +5.02000000E-05  +3.59500000E-04  +3.65300000E-04  +7.93520000E-04
   -6.02820000E-04  -8.33500000E-05  +1.74780000E-04  +2.58570000E-04  -1.02210000E-04
   +1.73123000E-03  +1.28680000E-03  +8.28409000E-02  +1.31100000E-05  +3.02000000E-06
   +2.08400000E-05  -9.09200000E-05  -9.73700000E-05  -7.16400000E-05  -2.58000000E-06
   +1.70700000E-05  +5.20500000E-05  -2.43000000E-05  +9.97000000E-06  -3.20000000E-06
   +5.28400000E-05  -4.49300000E-05  +7.55000000E-06  -1.22000000E-05  -2.99000000E-06
   -3.87000000E-06  +1.45440000E-04  -1.04440000E-04  +5.22390000E-04  +8.48000000E-06
   -5.15800000E-05  +2.06400000E-05  -6.70600000E-05  +4.58900000E-05  -1.47300000E-05
   -3.81270000E-03  +3.67262000E-03  +1.16757000E-03  +6.17110000E-04  +5.77000000E-06
   -6.74510000E-04  +2.50750000E-04  +2.63872000E-03  +3.30822000E-03  -6.93151000E-03
   -4.34760000E-03  +5.36580000E-03  -7.45283500E-02  -2.08032700E-01  +1.33953780E-01
   -1.94122000E-03  -5.76881000E-03  +7.44354000E-03  +1.13991000E-03  -8.79930000E-04
   -2.07403000E-03  -9.94700000E-05  +7.69300000E-05  +2.34100000E-05  -2.00900000E-05
   +5.50000000E-06  +2.33400000E-05  +1.14310000E-04  -1.71170000E-04  -3.33950000E-04
   -1.44880000E-04  -2.88650000E-04  +2.15910000E-04  +1.78710000E-04  -3.72210000E-04
   -2.54760000E-04  +1.36932000E-03  -1.52026000E-03  -2.34719000E-03  +8.37727500E-02
   +2.15244460E-01  +2.44700000E-05  +2.68000000E-06  +1.61000000E-06  -1.07460000E-04
   +9.70000000E-07  +3.92000000E-06  +9.48000000E-06  -2.05600000E-05  +7.13000000E-06
   -5.87000000E-06  +1.38500000E-05  -5.01000000E-06  -4.89000000E-06  -2.96000000E-06
   -1.35000000E-06  +3.52000000E-06  +3.46000000E-06  -2.41000000E-06  -1.74690000E-04
   -1.06140000E-04  +3.57850000E-04  +7.13900000E-05  -2.22800000E-05  -2.72400000E-05
   +3.36000000E-06  -1.04300000E-05  -1.99000000E-06  -3.16604000E-03  +1.51186000E-03
   +3.36881000E-03  -6.92490000E-04  -8.70720000E-04  -6.18050000E-04  -4.77181000E-03
   +2.93749000E-03  -9.43270000E-04  +1.08478400E-02  +1.95883500E-02  -8.32148000E-03
   +4.55739600E-02  +1.33304850E-01  -1.46464330E-01  -2.77798000E-03  -5.97714000E-03
   +6.88544000E-03  +1.64114000E-03  -2.27406000E-03  +4.85700000E-05  +3.34800000E-05
   +5.44700000E-05  +1.07000000E-05  +1.85100000E-05  -1.86300000E-05  +2.45000000E-06
   +3.01840000E-04  -3.74730000E-04  +6.85800000E-05  +4.00610000E-04  +8.62290000E-04
   -6.34740000E-04  +2.18970000E-04  -2.80250000E-04  -2.46440000E-04  +1.71257000E-03
   -2.07415000E-03  -1.15365000E-03  -4.91536400E-02  -1.46308360E-01  +1.47668810E-01
   +3.76500000E-05  -1.17430000E-04  +1.00580000E-04  +4.64140000E-04  +1.59340000E-04
   -9.10300000E-04  -1.56640000E-04  -2.68070000E-04  +1.79670000E-04  +1.62090000E-04
   +1.20190000E-04  +2.08900000E-05  +1.07840000E-04  +1.76500000E-05  +1.39200000E-05
   -5.92600000E-05  +1.01960000E-04  -2.60300000E-05  -2.58082000E-03  -1.54580000E-04
   +1.53611000E-03  -1.97390000E-04  -2.28530000E-04  +1.41480000E-04  -1.11910000E-04
   +1.29440000E-04  -2.50600000E-05  +5.00570000E-04  -1.29494000E-03  -8.85020000E-04
   +3.33700000E-05  -2.10240000E-04  +2.86500000E-05  +3.98500000E-05  +1.58940000E-04
   +5.05000000E-05  -1.74600000E-05  -1.08220000E-04  +1.03890000E-04  -1.40680000E-04
   +7.39300000E-05  -7.08200000E-05  +4.07500000E-04  +1.94430000E-04  -5.02100000E-05
   +5.55300000E-05  +1.88400000E-05  -2.05300000E-05  -1.84439040E-01  +5.59270900E-02
   +1.23142770E-01  +2.00380000E-04  -2.25000000E-04  -5.60000000E-06  -1.56600000E-05
   -4.34000000E-06  -5.40000000E-07  +1.00200000E-05  +7.68000000E-06  +4.93000000E-06
   +9.76600000E-05  +9.08600000E-05  -8.28600000E-05  +2.30700000E-05  +1.07400000E-05
   -2.20500000E-05  +7.74000000E-06  +2.33300000E-05  +1.21300000E-05  +1.97415650E-01
   +1.52790000E-03  -5.99000000E-05  -1.24625000E-03  -6.43060000E-04  -6.20027000E-03
   +1.60288000E-03  -9.69700000E-04  -1.05340000E-04  +7.30400000E-05  +2.48540000E-04
   -1.60740000E-04  +1.06110000E-04  -1.21900000E-04  +4.73250000E-04  -7.43800000E-05
   -4.26950000E-04  -4.26560000E-04  -5.86900000E-05  +2.35439700E-02  -1.25671900E-02
   -2.15011700E-02  +6.38200000E-05  +1.16211000E-03  -1.08543000E-03  +3.51580000E-04
   -2.34250000E-04  +5.31000000E-05  +1.25831000E-03  +1.18034000E-03  -3.92590000E-04
   -2.06110000E-04  +1.40750000E-04  -1.39190000E-04  -1.27650000E-04  -2.00700000E-05
   -6.70200000E-05  -2.40180000E-04  +7.70000000E-07  -2.12370000E-04  +2.55920000E-04
   -6.60600000E-05  +1.47220000E-04  -3.51990000E-04  -1.18890000E-04  +3.80310000E-04
   +2.89500000E-04  +1.31300000E-04  +9.55500000E-05  +5.43009200E-02  -6.64241500E-02
   -4.78727600E-02  -3.28310000E-04  +6.49850000E-04  +2.96820000E-04  -2.82400000E-05
   -2.17000000E-06  -2.78800000E-05  +1.49900000E-05  -1.74000000E-05  +4.91000000E-06
   +4.50300000E-05  -5.42900000E-05  -2.17000000E-06  -1.51000000E-06  -2.34000000E-05
   -1.50900000E-05  +2.39900000E-05  -1.07600000E-05  -2.37700000E-05  -6.01164700E-02
   +7.64077600E-02  -1.41000000E-05  +4.71600000E-05  +2.01720000E-04  -7.92910000E-04
   +8.77120000E-04  -3.63420000E-04  -1.93480000E-04  +1.33670000E-04  +1.48840000E-04
   +3.88900000E-05  +4.76200000E-05  +4.58500000E-05  -1.03310000E-04  +9.64200000E-05
   -4.36100000E-05  -4.74100000E-05  -2.78400000E-05  -8.75000000E-06  -1.35375000E-03
   +6.50560000E-04  -2.41490000E-04  -5.28240000E-04  +3.57630000E-04  +6.19590000E-04
   +1.39830000E-04  -1.07150000E-04  +2.24900000E-05  +3.63350000E-04  +9.07900000E-05
   +4.06790000E-04  -1.48780000E-04  +2.37600000E-04  -3.10800000E-05  -3.30710000E-04
   -1.03810000E-04  +1.21640000E-04  -9.21600000E-05  +7.00400000E-05  -2.31100000E-04
   +2.29100000E-04  +2.50600000E-05  +9.82400000E-05  -3.89650000E-04  -3.18980000E-04
   +3.15900000E-05  +4.29200000E-05  +1.63400000E-05  +2.31200000E-05  +1.22579580E-01
   -4.87917100E-02  -1.56733540E-01  +5.11660000E-04  -1.05623000E-03  -1.08080000E-04
   -6.98000000E-06  -1.62900000E-05  -1.06000000E-05  +4.70000000E-07  -1.59700000E-05
   -1.50500000E-05  +3.59700000E-04  +2.01700000E-05  -1.45760000E-04  +1.68700000E-05
   +5.30900000E-05  -1.16800000E-05  -7.34000000E-06  -4.14000000E-06  -1.85000000E-06
   -1.34756520E-01  +5.31449600E-02  +1.66235070E-01  +8.35800000E-05  -9.24500000E-05
   -1.38950000E-04  -2.89400000E-04  -4.46330000E-04  +1.41560000E-04  -1.41410000E-03
   +3.63710000E-04  +7.22870000E-04  +1.99420000E-04  +2.80460000E-04  +1.82100000E-05
   -9.71500000E-05  +7.01200000E-05  -9.39800000E-05  -8.36000000E-05  -1.25100000E-05
   -8.31000000E-06  +2.48373000E-03  +2.01497000E-03  +8.81710000E-04  +4.37990000E-04
   +8.71900000E-04  -5.41300000E-05  +1.13550000E-04  -1.75700000E-05  +1.95500000E-05
   +1.97250000E-04  -2.84380000E-04  -2.00480000E-04  +1.24150000E-04  -2.01330000E-04
   +6.63000000E-06  +2.37460000E-04  -1.36000000E-05  +4.29300000E-05  +3.24510000E-04
   -4.37300000E-05  +2.79280000E-04  -3.52290000E-04  -5.45500000E-05  -1.71750000E-04
   +6.21360000E-04  +4.33860000E-04  -4.66940000E-04  -3.47330000E-04  -1.39870000E-04
   -6.98600000E-05  -2.44317400E-01  -9.94143300E-02  -6.41999600E-02  +1.53340000E-04
   -5.16800000E-05  -7.78800000E-05  +4.86300000E-05  +9.97000000E-06  +2.51800000E-05
   -2.57600000E-05  +3.51000000E-06  -2.11200000E-05  -7.23800000E-05  +4.67000000E-05
   +2.70290000E-04  +1.22100000E-05  -4.34800000E-05  +8.98200000E-05  -2.76500000E-05
   +1.15000000E-05  +2.00600000E-05  -1.86807100E-02  -9.55758000E-03  -7.68720000E-03
   +2.67081660E-01  +2.43260000E-04  -4.08200000E-05  +1.33560000E-04  -8.28150000E-04
   +7.91950000E-04  -1.37850000E-04  -1.31890000E-04  -3.48780000E-04  -9.42200000E-05
   +3.67910000E-04  -2.69000000E-05  +1.57610000E-04  +2.73200000E-04  +2.51410000E-04
   -4.97000000E-06  -3.72150000E-04  +5.55700000E-05  -7.94700000E-05  -2.86434400E-02
   -1.39809100E-02  -7.83733000E-03  -1.65546000E-03  +9.99680000E-04  -1.27544000E-03
   -1.13570000E-04  +1.42700000E-04  -1.80100000E-05  +1.99640000E-03  -5.93753000E-03
   +1.03864000E-03  +6.38300000E-05  -6.49200000E-05  +6.75120000E-04  -8.76700000E-05
   +5.44300000E-05  +3.56000000E-05  +4.59490000E-04  +5.02000000E-06  +1.82490000E-04
   -5.08460000E-04  +1.45000000E-06  +2.69800000E-04  -1.07554000E-03  -2.82360000E-04
   -9.48760000E-04  -5.42190000E-04  -2.14450000E-04  -1.54750000E-04  -9.67461400E-02
   -9.58720200E-02  -3.14717500E-02  +2.69110000E-04  -9.02900000E-05  -2.30800000E-05
   +4.41300000E-05  -1.85900000E-05  +3.27400000E-05  -6.41100000E-05  -1.65000000E-06
   -2.56500000E-05  +7.03900000E-05  +1.27480000E-04  -2.13060000E-04  +7.85700000E-05
   -1.54810000E-04  -4.10800000E-05  -1.58300000E-04  -2.94800000E-05  +1.81200000E-05
   +8.24309000E-03  +3.71057000E-03  +3.66313000E-03  +1.06807910E-01  +1.06229180E-01
   +2.96210000E-04  -5.62400000E-05  -1.73700000E-05  -7.29770000E-04  -2.04930000E-04
   -3.50900000E-05  -1.57180000E-04  -8.83750000E-04  -4.92100000E-05  +2.04490000E-04
   +2.15540000E-04  +1.82400000E-05  +8.82400000E-05  +9.96300000E-05  -2.34000000E-06
   -2.16320000E-04  +2.60600000E-05  -6.12800000E-05  +7.47740000E-04  +1.09459000E-03
   -1.33786000E-03  +8.98720000E-04  +1.15609000E-03  +1.80870000E-04  -6.30700000E-05
   +1.14180000E-04  -2.48000000E-05  -3.78060000E-04  +6.97000000E-04  +4.90340000E-04
   -1.45310000E-04  +4.49900000E-05  -3.08840000E-04  +8.50000000E-05  -2.37490000E-04
   +7.29500000E-05  -4.43100000E-05  -3.45000000E-06  -4.40500000E-05  +8.68400000E-05
   -1.77950000E-04  +4.16900000E-05  -3.70600000E-05  +3.36000000E-06  -1.04600000E-05
   -8.37000000E-06  +1.33000000E-06  +5.82000000E-05  -6.41400100E-02  -3.25919700E-02
   -6.85580700E-02  +4.47390000E-04  +1.08250000E-04  -1.51770000E-04  +2.11300000E-05
   +1.88900000E-05  -4.61000000E-06  -7.31000000E-06  -6.62000000E-06  -2.15300000E-05
   +1.74010000E-04  +4.45100000E-05  +5.20220000E-04  +8.32000000E-06  +3.76800000E-05
   +8.51000000E-05  -1.36300000E-05  +7.02000000E-06  +8.50000000E-06  +1.79438100E-02
   +9.85661000E-03  +6.44689000E-03  +6.97903300E-02  +3.41300100E-02  +6.96437600E-02
   +9.90000000E-06  +2.06900000E-05  +1.50250000E-04  +7.40700000E-05  +6.87540000E-04
   -1.43031000E-03  -2.29000000E-05  +1.60250000E-04  +2.38060000E-04  +1.21500000E-05
   -1.19060000E-04  +3.10700000E-05  -3.68600000E-05  +4.83000000E-05  -2.93000000E-05
   +2.41400000E-05  -1.03710000E-04  +2.36800000E-05  -2.31586000E-03  +1.03986000E-03
   -2.05074000E-03  -2.77830000E-04  +1.13906000E-03  -2.12900000E-05  +5.98000000E-05
   -6.93000000E-05  +1.87400000E-05  +2.10000000E-06  +3.73220000E-04  +2.95940000E-04
   -8.66410000E-04  -1.11747000E-03  -2.80300000E-05  -9.54800000E-05  +7.51000000E-06
   +1.76200000E-05  -1.20780000E-04  +3.29600000E-05  -7.57300000E-05  +1.57370000E-04
   +4.81600000E-05  +1.60900000E-05  -1.12740000E-04  -2.22300000E-05  -4.62700000E-05
   +1.04850000E-04  +5.12200000E-05  +1.15400000E-05  -6.27814900E-02  +1.94301400E-02
   -5.97316500E-02  +8.86800000E-05  -4.12880000E-04  +5.70550000E-04  -2.34200000E-05
   -1.72900000E-05  -7.41000000E-06  +1.71100000E-05  -1.90900000E-05  -6.37000000E-06
   -1.13258000E-03  -1.77138000E-03  -1.07888000E-03  -1.43500000E-05  +2.65000000E-05
   -2.38900000E-05  +7.08000000E-06  +9.31000000E-06  -5.29000000E-06  +6.33228000E-03
   -8.50057000E-03  +2.21164600E-02  -5.73217000E-03  +9.63079000E-03  -2.62085200E-02
   +6.56248100E-02  -1.56740000E-04  +1.03370000E-04  -6.41800000E-05  +2.09680000E-04
   +6.82370000E-04  +1.93507000E-03  +1.21920000E-04  -8.11500000E-05  -2.19690000E-04
   -2.74900000E-05  +5.13600000E-05  -4.75400000E-05  +4.70700000E-05  -5.44200000E-05
   +1.76100000E-05  -2.52000000E-05  +1.03270000E-04  -3.22600000E-05  +7.99356000E-03
   -8.02580000E-03  +2.99397900E-02  +3.63070000E-04  -6.93613000E-03  -9.46650000E-04
   -1.12030000E-04  +8.39500000E-05  -3.83500000E-05  +9.17270000E-04  +1.24889000E-03
   -3.55900000E-05  -3.17840000E-04  -7.62490000E-04  +3.48570000E-04  -3.27120000E-04
   +1.68270000E-04  -2.52630000E-04  -3.56900000E-05  +2.11480000E-04  -1.80310000E-04
   +2.79170000E-04  +1.39490000E-04  +4.47800000E-05  -3.48070000E-04  -1.70290000E-04
   +1.96800000E-04  +7.85900000E-05  +3.24700000E-05  -3.99900000E-05  +1.88881600E-02
   -7.52755100E-02  +7.92959500E-02  -7.32300000E-05  +7.23000000E-05  -1.07740000E-03
   -3.43200000E-05  -1.00600000E-05  +2.05000000E-06  -1.42100000E-05  -2.36500000E-05
   +8.90000000E-06  -1.82244000E-03  -9.53190000E-04  -1.28188000E-03  +1.11240000E-04
   +1.29210000E-04  -6.92600000E-05  +1.13400000E-05  -1.86200000E-05  -1.34700000E-05
   -3.18328000E-03  +2.46369000E-03  -8.93738000E-03  -2.32541000E-03  +4.26872000E-03
   -1.35038400E-02  -2.06707400E-02  +8.26026100E-02  -3.04200000E-04  -1.75000000E-06
   +6.62100000E-05  +5.27570000E-04  +5.07510000E-04  -4.88140000E-04  +4.30000000E-05
   +1.09650000E-04  +1.94000000E-06  -2.91200000E-05  +7.77000000E-06  +1.85900000E-05
   +5.89200000E-05  -8.05000000E-05  +8.02000000E-06  +5.14100000E-05  +8.08400000E-05
   +9.23000000E-06  -1.09540000E-04  +1.57360000E-04  +6.18840000E-04  +1.22700000E-04
   +6.86510000E-04  +6.78060000E-04  -6.12700000E-05  +4.42300000E-05  -8.90000000E-06
   -5.06280000E-04  +3.36100000E-04  -1.09000000E-05  -7.82280000E-04  -7.21920000E-04
   -1.11206000E-03  +2.14140000E-04  -2.23510000E-04  +2.16100000E-04  -1.30650000E-04
   +1.80800000E-05  +6.08900000E-05  -4.75400000E-05  -1.03410000E-04  +2.65400000E-05
   +1.05610000E-04  +1.21790000E-04  +3.40600000E-05  +3.73900000E-05  -2.09700000E-05
   +5.25900000E-05  -6.06610800E-02  +8.26307800E-02  -2.80555490E-01  +1.31491000E-03
   -2.50236000E-03  -1.46895000E-03  +1.31900000E-05  +2.13000000E-05  -4.16000000E-06
   +2.35400000E-05  -8.16000000E-06  -2.24300000E-05  -1.30383000E-03  -1.35445000E-03
   +4.55730000E-04  -3.69300000E-05  -6.56700000E-05  +2.76000000E-05  +1.21700000E-05
   +1.25000000E-06  +2.48000000E-06  -5.74225000E-03  +5.79779000E-03  -1.66431500E-02
   -6.99970000E-04  +1.89626000E-03  -6.58074000E-03  +6.79353100E-02  -8.68612300E-02
   +3.04327660E-01  +1.24050000E-04  +6.62300000E-05  +3.20710000E-04  +3.27840000E-04
   -3.52300000E-04  +6.55080000E-04  +1.98310000E-04  -3.01650000E-04  -2.22580000E-04
   -1.09130000E-04  +8.53000000E-05  -2.09840000E-04  -1.14860000E-04  +1.11970000E-04
   +7.80000000E-06  -1.55000000E-05  +2.19590000E-04  +4.19480000E-04  -3.07584000E-03
   +1.08492800E-02  +9.66700000E-04  -5.92615300E-02  +5.51360000E-02  -4.52922000E-03
   -3.18000000E-06  -2.05800000E-05  -2.98500000E-05  +5.14000000E-04  +2.21900000E-04
   +3.43290000E-04  -7.89000000E-05  -1.62700000E-04  -3.36600000E-05  +1.36940000E-04
   +1.91500000E-05  +7.76900000E-05  -1.88800000E-05  -3.59400000E-05  +5.16000000E-06
   +3.27800000E-05  -2.50980000E-04  +2.64830000E-04  -8.89650000E-04  +4.10250000E-04
   -7.50110000E-04  +1.07830000E-04  +5.33000000E-06  +6.43300000E-05  -7.76730000E-04
   -2.50170000E-04  -2.17454000E-03  -1.93820000E-04  +4.65600000E-05  -3.47600000E-05
   -6.47000000E-06  -1.82000000E-06  -2.97000000E-06  +4.80000000E-06  +1.04000000E-06
   +1.45800000E-05  +6.72300000E-05  -7.94000000E-06  +9.86000000E-05  -2.16077000E-03
   -6.83010000E-04  -4.08200000E-05  -3.39100000E-05  +1.33400000E-05  -4.68000000E-06
   +1.62640000E-04  -3.89490000E-04  -1.39500000E-05  +3.14410000E-04  +3.02810000E-04
   +9.69200000E-05  +5.43410000E-04  +7.80020000E-04  -5.39100000E-05  +6.17121500E-02
   +3.24250000E-04  -5.53200000E-05  -6.62390000E-04  +8.02570000E-04  -3.08440000E-04
   -3.28730000E-04  -3.66500000E-05  -9.75700000E-05  -3.73000000E-05  -1.06080000E-04
   -6.65500000E-05  +1.15700000E-04  -2.56110000E-04  -8.08800000E-05  +7.06300000E-05
   +2.28250000E-04  +2.46000000E-05  -8.22280000E-04  +5.03630000E-04  -6.65965000E-03
   +2.82760000E-04  +5.58608300E-02  -3.01464590E-01  +1.85552500E-02  -6.19600000E-05
   +9.41000000E-05  -3.47000000E-05  -5.72660000E-04  -2.02090000E-04  +1.80890000E-04
   +1.97700000E-04  +1.21410000E-04  +7.81000000E-05  -3.57300000E-05  +2.59400000E-05
   -5.83800000E-05  -9.71700000E-05  -1.52660000E-04  -7.64000000E-06  -5.22200000E-05
   +4.15200000E-04  -4.46940000E-04  -1.06317000E-03  -7.28770000E-04  +6.62510000E-04
   +2.87500000E-05  +7.38400000E-05  -5.16400000E-05  +7.02770000E-04  +2.51230000E-04
   +2.75665000E-03  -1.92890000E-04  +1.78490000E-04  +1.58120000E-04  -1.95200000E-05
   -9.81000000E-06  -1.07600000E-05  +2.17400000E-05  +5.03000000E-06  -2.22000000E-06
   -5.98700000E-05  -4.73000000E-06  -9.20300000E-05  -1.10828000E-03  +5.81960000E-04
   -7.87040000E-04  +2.01500000E-05  +1.96300000E-05  +3.32700000E-05  -9.66800000E-05
   +1.99080000E-04  -1.87420000E-04  +1.43770000E-04  +4.27820000E-04  -1.48010000E-04
   +2.66930000E-04  -6.10070000E-04  -3.10100000E-05  -5.96702700E-02  +3.28749950E-01
   -2.52470000E-04  -9.06000000E-05  -7.68520000E-04  -1.81840000E-04  +1.03853000E-03
   +3.61450000E-04  +1.93100000E-04  -1.97180000E-04  -7.21700000E-05  -7.12400000E-05
   +3.60070000E-04  +7.79000000E-06  +2.55280000E-04  -5.12700000E-04  -3.34700000E-05
   +7.00550000E-04  -5.04740000E-04  -1.35030000E-04  -4.31026000E-03  +2.97664000E-02
   +1.94960000E-04  -3.87059000E-03  +1.66172800E-02  -4.92873900E-02  -3.71930000E-04
   +2.40390000E-04  -8.51300000E-05  +6.93240000E-04  +2.84100000E-05  +6.71030000E-04
   -2.60900000E-05  -3.34400000E-05  -2.46150000E-04  +1.14700000E-04  +4.69100000E-05
   +1.54800000E-05  +2.21000000E-06  -7.49300000E-05  +1.47970000E-04  -1.59070000E-04
   -5.18400000E-05  -6.08200000E-05  -4.52500000E-05  -5.07040000E-04  +2.27960000E-04
   -1.51600000E-05  -6.55000000E-06  -1.75700000E-05  -1.96997000E-03  +5.37550000E-04
   -5.97998000E-03  +1.07800000E-05  -2.99730000E-04  +5.23100000E-04  -2.65000000E-06
   +4.65000000E-06  -1.89000000E-06  -1.47800000E-05  +1.67000000E-05  +3.19000000E-06
   +4.00300000E-05  +4.74800000E-05  +8.98300000E-05  -4.60950000E-04  -1.15150000E-04
   +3.47160000E-04  -7.16000000E-06  -7.79000000E-06  +1.18000000E-06  -2.49490000E-04
   +3.69200000E-05  +5.93800000E-05  +1.48040000E-04  -1.83080000E-04  -5.54400000E-05
   -4.61860000E-04  +2.05521000E-03  -9.42000000E-06  +5.45318000E-03  -2.04074300E-02
   +5.26958800E-02  -2.45300000E-05  +3.97200000E-05  -1.06360000E-04  -2.22020000E-04
   +2.18140000E-04  +4.63910000E-04  -4.97400000E-04  +1.73290000E-04  +1.14820000E-03
   -4.18270000E-04  +2.12580000E-04  +1.01508000E-03  -6.57000000E-05  -3.25570000E-04
   -8.98100000E-05  -1.84200000E-05  +1.13600000E-04  +3.78000000E-06  -1.03994700E-02
   -5.38087000E-03  -1.67042000E-03  -2.37557230E-01  -1.16728760E-01  -4.06862400E-02
   +9.71200000E-05  -1.66200000E-05  +2.07500000E-05  +4.98100000E-05  +9.62090000E-04
   -2.36368000E-03  -1.46260000E-04  -7.09360000E-04  +1.79510000E-04  -3.44720000E-04
   +1.84200000E-05  -7.23300000E-05  +2.36140000E-04  +2.44980000E-04  -1.03050000E-04
   +1.48780000E-04  -9.49000000E-06  -7.43000000E-05  +2.62030000E-04  +1.03050000E-04
   -1.59080000E-04  -3.27740000E-04  -1.49920000E-04  -5.96700000E-05  +2.88200000E-05
   -1.03255000E-03  +7.36400000E-04  +6.53100000E-05  +2.29100000E-05  -1.42290000E-04
   +4.42000000E-05  +1.29200000E-05  +2.79600000E-05  -1.07350000E-04  -8.10000000E-07
   +7.80000000E-07  +1.17700000E-05  +1.93400000E-05  -8.35300000E-05  -1.72740000E-04
   +2.75850000E-04  +2.10400000E-05  -1.87900000E-05  -2.81400000E-05  +1.05000000E-06
   -8.70300000E-05  -4.90100000E-05  -6.96900000E-05  +4.90150000E-04  +8.71640000E-04
   -2.20960000E-04  +4.70280000E-04  +1.22020000E-04  +1.92910000E-04  +6.90829000E-03
   +4.18214000E-03  +1.63177000E-03  +2.57910670E-01  +3.37630000E-04  -1.79230000E-04
   -1.11370000E-04  -6.97440000E-04  +1.87100000E-04  -3.20400000E-04  -4.18080000E-04
   +6.83000000E-04  +2.13240000E-04  +1.80020000E-04  -1.29100000E-04  +5.16420000E-04
   +7.27300000E-05  -3.13380000E-04  -7.46900000E-05  -2.72450000E-04  -3.23000000E-06
   -3.07060000E-04  +7.47014000E-03  +2.39311000E-03  +1.64600000E-03  -1.17476910E-01
   -1.18746790E-01  -2.53844400E-02  +5.55800000E-05  +4.73500000E-05  +4.55100000E-05
   +3.16880000E-04  -4.95690000E-04  +1.89754000E-03  +3.55220000E-04  +3.62340000E-04
   +1.64710000E-04  +9.89400000E-05  -3.63600000E-05  -5.30600000E-05  +1.59300000E-05
   -1.05630000E-04  +1.01310000E-04  -1.42230000E-04  +2.69070000E-04  -3.36300000E-04
   -1.86980000E-04  -4.61880000E-04  +5.56500000E-04  -9.02800000E-05  +1.13100000E-05
   -6.86600000E-05  +1.60851000E-03  +6.86530000E-04  +7.77830000E-04  +2.75010000E-04
   -1.72000000E-04  -1.04830000E-04  +1.40000000E-07  -1.58000000E-06  +1.34000000E-06
   +3.78600000E-05  -8.95000000E-06  -2.12800000E-05  -3.45600000E-05  +9.10600000E-05
   -7.84000000E-06  +1.23040000E-04  +3.33150000E-04  -5.46700000E-04  -5.90000000E-07
   +3.10000000E-06  +1.78800000E-05  +3.67700000E-05  -6.34800000E-05  -6.39500000E-05
   +8.83200000E-05  -2.87600000E-04  +6.21090000E-04  +6.39300000E-05  +8.60300000E-05
   -1.32320000E-04  -2.72410600E-02  -1.50781400E-02  -5.06905000E-03  +1.27714280E-01
   +1.26743150E-01  +3.88210000E-04  -1.31080000E-04  +5.50400000E-05  -9.58240000E-04
   -3.02800000E-04  +4.46510000E-04  +1.98390000E-04  +6.06600000E-05  -9.05440000E-04
   +7.15560000E-04  -5.24270000E-04  -8.20900000E-05  +5.62790000E-04  +2.78400000E-04
   +1.08570000E-04  -5.78080000E-04  -8.50000000E-06  -1.73930000E-04  -2.59221200E-02
   -1.54275700E-02  -5.78594000E-03  -3.84574300E-02  -2.34373600E-02  -5.46191000E-02
   -2.97940000E-04  +2.46070000E-04  -7.04900000E-05  -3.69320000E-04  +2.40663000E-03
   -5.08023000E-03  -1.57552000E-03  -1.01136000E-03  +1.14210000E-04  -1.65190000E-04
   +2.98110000E-04  -2.62660000E-04  +2.36710000E-04  +3.36900000E-05  +2.39500000E-05
   -1.74640000E-04  -1.82670000E-04  +1.52500000E-04  +2.81640000E-04  +1.06172000E-03
   -3.43950000E-04  -2.06190000E-04  -1.31380000E-04  -1.79600000E-05  -3.40580000E-04
   -1.61516000E-03  +8.87390000E-04  +2.16150000E-04  +6.47700000E-05  +2.64270000E-04
   +3.44300000E-05  +1.10700000E-05  +1.84400000E-05  -1.52410000E-04  -6.24600000E-05
   -4.15500000E-05  +3.06700000E-05  -9.72000000E-06  -2.09800000E-05  +3.80190000E-04
   -2.52720000E-04  +2.83900000E-04  -5.51400000E-05  -5.41000000E-06  +1.17200000E-05
   +1.40820000E-04  +1.05700000E-04  +1.40200000E-05  +1.85190000E-04  +8.97440000E-04
   +6.87500000E-05  +3.57530000E-04  -1.81130000E-04  +7.66300000E-05  +2.03369000E-03
   +6.45040000E-04  -4.36450000E-04  +4.48654000E-02  +2.37888900E-02  +6.10544600E-02
   +5.77200000E-05  -7.69300000E-05  +1.24040000E-04  -1.40828000E-03  +7.40440000E-04
   -1.56017000E-03  -3.71630000E-04  +4.16920000E-04  +5.40710000E-04  +2.68390000E-04
   -2.38170000E-04  +3.51830000E-04  +3.51580000E-04  -1.95590000E-04  -3.80800000E-05
   -2.07040000E-04  -7.68200000E-05  -1.19320000E-04  +7.46263000E-03  -3.02943000E-03
   -9.65311000E-03  -1.68046740E-01  +4.41550900E-02  +1.28301120E-01  -2.01300000E-04
   +1.81990000E-04  -3.36500000E-05  +6.75180000E-04  -3.07720000E-04  -4.08000000E-04
   +1.79430000E-04  +1.35680000E-04  -4.77000000E-06  +4.15800000E-05  +4.61000000E-05
   -4.17000000E-06  -1.27340000E-04  -4.16800000E-05  +4.70700000E-05  +1.33000000E-06
   +2.37000000E-05  -5.70400000E-05  -3.15380000E-04  -8.44140000E-04  -3.65960000E-04
   +1.34640000E-04  +6.92800000E-05  +1.93100000E-05  +3.21850000E-04  -4.98340000E-04
   -8.30800000E-05  +6.12800000E-04  -2.53990000E-04  -8.82250000E-04  -1.93100000E-05
   +1.22000000E-06  -5.88000000E-06  +2.10500000E-05  +1.76000000E-05  +1.97900000E-05
   +1.68000000E-05  -2.38000000E-05  -7.95000000E-06  -4.29460000E-04  -5.12850000E-04
   -4.68000000E-04  +3.52900000E-05  -2.06900000E-05  -2.41800000E-05  +1.21570000E-04
   -7.52100000E-05  +1.40110000E-04  -1.25610000E-04  +8.01000000E-05  +1.23530000E-04
   +4.91300000E-05  -2.23140000E-04  -2.89000000E-05  -4.45707000E-03  +1.12460000E-04
   +3.27595000E-03  -1.64186100E-02  +7.76828000E-03  +1.83953200E-02  +1.81658210E-01
   +4.00910000E-04  -7.48100000E-05  -2.23680000E-04  +6.61960000E-04  -6.61520000E-04
   +8.58640000E-04  -9.09100000E-05  +2.42980000E-04  +1.27400000E-04  +8.25000000E-06
   -2.89320000E-04  +2.25170000E-04  -1.56100000E-04  +9.82300000E-05  +5.95700000E-05
   -3.21580000E-04  +2.34270000E-04  -3.05470000E-04  -5.84112000E-03  +6.53300000E-04
   +5.59090000E-03  +4.33951000E-02  -6.27621000E-02  -4.50548200E-02  +9.08800000E-05
   -2.67800000E-05  +1.04200000E-05  +1.62910000E-04  +1.37550000E-04  -5.39870000E-04
   -8.91700000E-05  -1.84530000E-04  -5.28200000E-05  +6.84300000E-05  +4.06000000E-06
   +6.31400000E-05  -3.37000000E-06  -1.70100000E-05  -6.67900000E-05  -9.15000000E-06
   -1.41640000E-04  +2.76150000E-04  -3.44320000E-04  +5.36690000E-04  -6.22900000E-04
   +8.02900000E-05  -5.46000000E-06  +5.48000000E-05  -7.04080000E-04  +5.53650000E-04
   +4.43720000E-04  -2.94780000E-04  +2.27550000E-04  +5.24950000E-04  -4.66000000E-06
   -1.66000000E-06  -1.75000000E-06  -2.80000000E-06  +2.40000000E-06  +1.71800000E-05
   +3.60400000E-05  -1.72700000E-05  +6.04900000E-05  -1.10060000E-04  -1.12792000E-03
   -3.23470000E-04  -2.34500000E-05  +4.89000000E-06  -5.97000000E-06  +3.74160000E-04
   -1.36920000E-04  +2.36900000E-04  -1.26520000E-04  -2.50800000E-05  -1.66000000E-06
   +6.19000000E-06  +5.39000000E-05  -2.18700000E-04  +2.11278600E-02  -5.75213000E-03
   -2.25281100E-02  -1.09495500E-02  +4.17877000E-03  +1.31339400E-02  -4.74172500E-02
   +6.41917300E-02  +9.05000000E-06  +5.23880000E-04  +5.61900000E-05  -3.84543000E-03
   +2.43480000E-03  -2.51059000E-03  -6.30460000E-04  -7.92400000E-05  +2.37800000E-05
   +3.79500000E-05  +1.51130000E-04  +2.28340000E-04  -1.69220000E-04  +6.27100000E-05
   -4.94000000E-05  -1.27360000E-04  -1.68120000E-04  +5.32300000E-05  +2.07234900E-02
   -8.07726000E-03  -2.15885300E-02  +1.26001530E-01  -4.46479800E-02  -1.77893770E-01
   +2.16100000E-04  -1.48560000E-04  +4.30000000E-05  +1.35600000E-03  +1.74660000E-04
   +1.15523000E-03  -5.72690000E-04  +2.70800000E-04  -1.73380000E-04  +3.80260000E-04
   +2.03890000E-04  -2.62500000E-05  -3.39500000E-05  -3.09500000E-04  +2.50830000E-04
   -3.79470000E-04  -1.35380000E-04  +9.60500000E-05  -9.09500000E-05  +1.95490000E-04
   +1.11740000E-04  +1.45640000E-04  +7.37200000E-05  +3.30100000E-05  +7.53850000E-04
   -1.11298000E-03  +8.28910000E-04  +1.27995000E-03  -5.84380000E-04  -2.37467000E-03
   -1.70200000E-05  -1.48500000E-05  -2.05500000E-05  +3.61400000E-05  -3.20700000E-05
   -2.51600000E-05  +7.08100000E-05  -5.72000000E-05  +1.91200000E-05  -2.12800000E-05
   -6.24980000E-04  -1.59400000E-05  -1.19700000E-05  -8.14000000E-06  -2.21200000E-05
   -4.33390000E-04  +7.98790000E-04  +1.55100000E-04  -6.77200000E-05  +6.47900000E-05
   -4.86000000E-05  -3.31530000E-04  -9.81800000E-05  +2.38060000E-04  -2.64128000E-03
   +6.13080000E-04  +1.89384000E-03  -4.40962000E-03  +2.15178000E-03  +4.52644000E-03
   -1.37176210E-01  +4.81660500E-02  +1.95623610E-01  -5.20023000E-03  -8.30500000E-04
   -1.25771000E-03  +1.07517000E-03  -2.81785600E-02  +1.28423000E-03  -5.92393800E-02
   -2.97578400E-02  -4.30594000E-03  +5.85768000E-03  +2.69011900E-02  -4.50180000E-04
   -3.17942000E-03  +2.39202000E-03  -1.88880000E-03  -1.19589000E-03  +7.81000000E-05
   -9.67000000E-05  +9.94910000E-04  -6.50690000E-04  -4.19130000E-04  -8.80000000E-05
   +1.20930000E-04  -5.90000000E-07  +1.80490000E-04  +1.52301000E-03  -4.34300000E-05
   -7.51600000E-05  +2.94600000E-04  -6.08500000E-05  +2.80600000E-05  -2.15600000E-05
   +9.51100000E-05  -1.40000000E-05  +1.64200000E-05  -1.87600000E-05  -1.28100000E-05
   -5.05000000E-06  -1.72600000E-05  +4.02500000E-05  +3.23500000E-05  -1.05200000E-05
   +6.20400000E-05  +3.76400000E-05  +3.09400000E-05  +2.83300000E-05  +2.20300000E-05
   +7.46000000E-06  -1.07094000E-03  +6.59900000E-05  +2.10320000E-04  +1.77091000E-03
   +1.38773000E-03  +8.61790000E-04  -4.48000000E-06  -7.63000000E-06  -4.52000000E-06
   +2.81000000E-06  -4.94000000E-06  +4.70000000E-07  -1.82700000E-05  -3.94000000E-06
   -5.81000000E-05  +1.58000000E-06  -9.99000000E-06  -7.99000000E-06  +1.15300000E-05
   -6.20000000E-07  -6.68000000E-06  +3.21850000E-04  +1.78700000E-04  -2.57800000E-05
   -1.34663000E-03  +1.14771000E-03  +1.28980000E-03  -1.12640000E-04  +7.13100000E-05
   -7.35400000E-05  +2.35900000E-05  +1.03820000E-04  -1.22860000E-04  +8.53800000E-05
   -4.40700000E-05  +1.47440000E-04  +3.88500000E-05  +2.88000000E-05  +1.02640000E-04
   +6.02543500E-02  -2.25643000E-03  +4.34250000E-04  -2.75700000E-04  +1.64988000E-03
   -9.24091000E-03  +2.02536000E-03  -2.78489000E-02  -3.41161220E-01  +4.54585000E-03
   -4.25177000E-03  -1.37568500E-02  -2.08520000E-04  +2.96209000E-03  +1.63714000E-03
   +1.08327000E-03  -4.10850000E-04  +4.64690000E-04  -1.08800000E-04  +4.41000000E-05
   -6.09510000E-04  -5.99390000E-04  -1.91670000E-04  -6.92400000E-05  -8.95200000E-05
   -1.86270000E-04  -1.07044000E-03  -4.13800000E-05  -9.13500000E-05  +1.45010000E-04
   +1.95690000E-04  +1.64700000E-05  -1.09500000E-05  +4.57600000E-05  -1.62700000E-05
   -1.33300000E-05  +1.80000000E-07  +3.38900000E-05  +1.23300000E-05  +2.80000000E-06
   +3.03000000E-06  +9.32000000E-06  -8.73000000E-06  -1.63900000E-05  +3.57000000E-06
   -1.13900000E-05  -3.60200000E-05  -8.67000000E-06  -8.03000000E-06  +6.47700000E-04
   -7.42820000E-04  -8.81550000E-04  +5.28790000E-04  +1.52105000E-03  -7.85350000E-04
   +6.26000000E-06  -4.07000000E-06  +1.86000000E-06  -1.78000000E-06  -3.16000000E-06
   -3.77000000E-06  -7.69000000E-06  +2.21000000E-06  -1.87200000E-05  -1.65000000E-06
   -1.06400000E-05  -7.13000000E-06  +1.88000000E-06  -2.84000000E-06  -3.85000000E-06
   +3.26270000E-04  +2.71690000E-04  +7.03700000E-05  +1.75850000E-03  +2.09290000E-04
   -3.76200000E-04  -6.80000000E-05  -3.59400000E-05  +7.02800000E-05  +7.02500000E-05
   +7.94400000E-05  -6.17300000E-05  +3.70600000E-05  -7.51200000E-05  +1.67530000E-04
   +2.05600000E-05  +3.13400000E-05  +6.06000000E-05  +2.68098000E-02  +3.62199090E-01
   -9.80060000E-04  -8.66450000E-04  +1.38213000E-03  -1.29862000E-03  -3.40990000E-03
   +1.26249000E-03  -3.37206000E-03  +5.20783000E-03  -3.24826700E-02  +4.82900000E-04
   +3.95471000E-03  +5.88474000E-03  -1.80257000E-03  +7.51720000E-04  +8.06707000E-03
   -1.57570000E-04  +1.64150000E-04  -8.32520000E-04  -8.65640000E-04  -7.53500000E-05
   +4.35910000E-04  +2.90600000E-05  +9.88700000E-05  +5.96700000E-05  -5.71100000E-05
   +8.13500000E-05  +6.69710000E-04  +6.92800000E-05  +7.33400000E-05  +7.93000000E-05
   -8.52000000E-06  -8.03700000E-05  +2.20600000E-05  -2.82200000E-05  -1.09100000E-05
   -2.57000000E-05  +4.78200000E-05  +2.93300000E-05  +9.30000000E-06  -5.02000000E-06
   +5.04000000E-06  -8.91000000E-06  -7.75800000E-05  -7.11200000E-05  -2.22900000E-05
   -6.39000000E-05  -2.78500000E-05  -2.11000000E-05  +6.47420000E-04  +5.98600000E-05
   +6.36300000E-05  +1.74551000E-03  -2.18680000E-04  +1.40791000E-03  +4.12000000E-06
   +3.09000000E-06  +8.15000000E-06  -1.76000000E-05  -1.77000000E-06  -4.45000000E-06
   -3.02800000E-05  +2.92200000E-05  +1.95300000E-05  +2.79000000E-06  +2.79500000E-05
   -1.09900000E-05  -8.31000000E-06  -4.03000000E-06  +1.27000000E-06  -1.22430000E-04
   -2.96500000E-05  -1.10560000E-04  +1.23636000E-03  -6.75640000E-04  -3.51040000E-04
   -2.25520000E-04  +4.70800000E-05  -6.66500000E-05  -4.14800000E-05  -8.66800000E-05
   +4.67000000E-05  +1.07600000E-05  +6.90700000E-05  -3.08700000E-04  -1.06720000E-04
   -8.93000000E-05  -5.17700000E-05  +3.93188000E-03  -4.40362000E-03  +2.20269200E-02
   +2.47810000E-04  +3.66240000E-04  +1.40240000E-04  +9.87400000E-04  +3.53559000E-03
   -6.49700000E-04  -1.92967300E-02  -1.21632600E-02  -3.68572000E-03  -2.84567910E-01
   -1.07835360E-01  -4.07061100E-02  -7.45010000E-04  +1.60112000E-03  -6.88300000E-04
   +1.11943000E-03  +1.03590000E-04  -3.01580000E-04  -1.75260000E-04  -2.93850000E-04
   -3.50020000E-04  -8.92700000E-05  -4.94500000E-05  -1.42400000E-05  +1.07198000E-03
   -2.52750000E-04  +5.54570000E-04  +2.52400000E-05  +8.80700000E-05  +2.00730000E-04
   +4.51000000E-06  +1.71500000E-05  -1.90200000E-05  -6.90000000E-06  -2.62800000E-05
   +1.76300000E-05  +7.39500000E-05  +2.55300000E-05  +1.72200000E-05  -2.94200000E-05
   -1.33500000E-05  -1.54000000E-05  -1.83300000E-05  +1.63900000E-05  -2.97600000E-05
   -8.51200000E-05  -3.59800000E-05  -1.46000000E-05  -4.82600000E-05  -5.54500000E-05
   +2.63200000E-05  -1.15801000E-03  -3.72700000E-05  -1.19995000E-03  +1.41400000E-05
   +1.37000000E-06  +4.47000000E-06  -6.10000000E-06  -1.22000000E-06  -7.07000000E-06
   +1.73300000E-05  -8.86000000E-06  +6.44000000E-06  +2.22000000E-06  -2.93000000E-06
   +5.01000000E-06  -5.32000000E-06  -6.55000000E-06  -1.80000000E-06  -1.62900000E-05
   +4.22100000E-05  +1.63800000E-05  +7.07000000E-06  +1.99000000E-05  -3.69000000E-06
   +2.22700000E-05  -1.62700000E-05  -7.42000000E-06  +1.45000000E-05  -6.90000000E-07
   -1.55500000E-05  +6.06000000E-06  +4.15900000E-05  +2.57600000E-05  +1.55900000E-05
   +1.20200000E-05  +5.86300000E-05  +7.93640000E-04  +3.88090000E-04  +1.18186000E-03
   +3.01785390E-01  +1.07086000E-03  -3.48490000E-04  +2.09470000E-04  +1.80336000E-03
   -2.22127000E-03  -6.61000000E-06  +1.83599500E-02  +1.26103000E-02  +2.89044000E-03
   -1.05761930E-01  -1.10905420E-01  -1.67227500E-02  -3.03413400E-02  -6.67446000E-03
   -5.07492000E-03  +6.60660000E-04  -5.76204000E-03  +1.27450000E-04  +2.77450000E-04
   +3.47920000E-04  +1.62340000E-04  +3.55100000E-05  -4.30100000E-05  +3.64400000E-05
   +3.60170000E-04  +2.21556000E-03  +3.13400000E-05  +2.93400000E-05  -8.24000000E-05
   -1.42440000E-04  -7.19000000E-06  -4.83000000E-06  +1.44800000E-05  +6.35000000E-06
   +2.01900000E-05  -3.70000000E-07  -8.80000000E-06  -1.05300000E-05  +3.31000000E-06
   +4.07000000E-06  +2.27500000E-05  +1.13100000E-05  +1.76900000E-05  +7.02000000E-06
   +2.11700000E-05  +2.28300000E-05  +1.00600000E-05  +4.02000000E-06  +6.50000000E-07
   +6.79800000E-05  +4.93300000E-05  +4.73000000E-04  +1.42970000E-04  +5.54240000E-04
   -1.35000000E-06  +3.60000000E-07  -2.84000000E-06  +2.46000000E-06  +5.60000000E-07
   +5.90000000E-07  +1.60000000E-07  -8.50000000E-07  -5.42000000E-06  +4.18000000E-06
   -5.27000000E-06  -1.55700000E-05  +5.46000000E-06  +9.90000000E-07  -2.26000000E-06
   -6.31000000E-06  -1.96400000E-05  -8.49000000E-06  -1.64200000E-05  -2.51400000E-05
   -2.06000000E-05  -5.41000000E-06  -1.00000000E-08  +5.27000000E-06  -8.47000000E-06
   +2.99000000E-06  -3.09900000E-05  -2.10800000E-05  +2.47100000E-05  -2.46400000E-05
   -6.69000000E-06  +1.50300000E-05  -2.50100000E-05  -1.77410000E-04  +8.80520000E-04
   -9.55900000E-05  +1.14526900E-01  +1.09868390E-01  -2.29130000E-04  +5.14220000E-04
   -7.48820000E-04  -4.02582000E-03  +2.37650000E-04  +9.08975000E-03  -2.32775000E-03
   -1.84268000E-03  +3.18155000E-03  -4.07869700E-02  -1.57716100E-02  -4.40459000E-02
   -8.99420000E-04  -1.13597000E-03  +3.39845000E-03  -1.73000000E-05  +3.44860000E-04
   +3.67240000E-03  -1.16671000E-03  -9.62930000E-04  -5.84070000E-04  -2.01400000E-05
   +6.00200000E-05  -1.82810000E-04  +6.21540000E-04  +1.42290000E-04  -2.16101000E-03
   -1.90050000E-04  +2.76170000E-04  +3.27350000E-04  +1.79900000E-05  -7.01200000E-05
   +6.45800000E-05  -4.85000000E-05  -7.10600000E-05  -1.87500000E-05  +7.76100000E-05
   +6.00200000E-05  -7.10000000E-07  +1.36000000E-06  -1.84100000E-05  -4.40700000E-05
   -8.53000000E-05  +8.23000000E-06  -3.72300000E-05  -1.12170000E-04  -4.77300000E-05
   -2.63600000E-05  +3.29800000E-05  -1.10530000E-04  -6.67500000E-05  +2.47959000E-03
   +9.81600000E-05  +1.61218000E-03  +8.57000000E-06  +1.46000000E-06  +1.15100000E-05
   -1.60900000E-05  -3.03000000E-06  -7.46000000E-06  -3.23900000E-05  +4.18800000E-05
   +1.09900000E-05  -1.20000000E-06  +1.54000000E-05  +1.07900000E-05  -8.13000000E-06
   -7.01000000E-06  +7.30000000E-07  +2.16300000E-05  +3.12200000E-05  +2.27000000E-06
   +4.62700000E-05  +3.00000000E-05  +3.33900000E-05  -2.12200000E-05  +4.30700000E-05
   +6.10000000E-07  -2.23000000E-06  -3.33000000E-06  +3.37500000E-05  +3.86100000E-05
   -2.87700000E-05  -1.17200000E-05  +4.50000000E-06  -6.77000000E-06  +2.99000000E-06
   +1.10347000E-03  -2.99220000E-04  -6.15308000E-03  +4.53038800E-02  +1.85199500E-02
   +3.32061400E-02  +5.97260000E-03  +2.90044800E-02  +2.25867000E-03  -3.21566000E-03
   -3.75810000E-04  -2.06077000E-03  -7.29190000E-04  +7.25470000E-04  -3.21000000E-06
   -4.59267000E-03  -1.97914000E-03  -1.74819000E-03  +2.92996000E-03  -2.64513100E-02
   -1.48789000E-03  -6.06324900E-02  -1.73130800E-02  -6.87403000E-03  +2.99800000E-04
   +3.19220000E-04  -1.25210000E-04  -9.28400000E-05  +1.60700000E-05  -1.59000000E-06
   +2.76149000E-03  -1.06916000E-03  +1.24815000E-03  +1.28920000E-04  +3.60100000E-05
   +1.71300000E-05  -3.80000000E-06  +5.27000000E-06  -2.19000000E-06  -4.88000000E-06
   -2.91000000E-05  +1.42700000E-05  +1.73100000E-05  +2.23700000E-05  -8.54000000E-06
   -1.96500000E-05  -5.26900000E-05  -2.36500000E-05  -4.99000000E-06  +1.43900000E-05
   -4.30400000E-05  -4.90300000E-05  -3.74200000E-05  -1.21500000E-05  -1.36240000E-04
   -1.11600000E-05  +1.26230000E-04  -2.01540000E-04  +1.47364000E-03  -9.14800000E-04
   +5.70000000E-07  +6.11000000E-06  +6.82000000E-06  -6.83000000E-06  +1.91000000E-06
   +4.20000000E-07  +3.19400000E-05  -1.05000000E-05  +9.29000000E-06  +8.25000000E-06
   +2.20600000E-05  +3.51500000E-05  -2.35500000E-05  +1.54000000E-06  +1.52700000E-05
   -1.83500000E-05  +7.27700000E-05  +2.10600000E-05  +9.42000000E-06  +2.00000000E-07
   +9.50000000E-07  +2.34100000E-05  -2.32900000E-05  -2.23100000E-05  +2.21700000E-05
   -1.47800000E-05  +2.29700000E-05  +1.01200000E-05  -4.70000000E-06  -5.30000000E-07
   +8.75000000E-06  +1.98000000E-06  +5.79000000E-05  +1.23630000E-04  +3.21800000E-05
   +8.60000000E-05  +1.08190000E-04  -1.38337000E-03  +2.17900000E-05  +5.80065900E-02
   -2.04900000E-03  -1.53119100E-02  -1.49318000E-03  +2.41162000E-03  +2.09058000E-03
   -6.15100000E-04  +1.66470000E-04  +5.94860000E-04  +9.94000000E-05  -2.64546000E-03
   +8.93030000E-04  -8.50210000E-04  +5.53835000E-03  -1.30187800E-02  +2.84940000E-04
   -1.73503600E-02  -3.29004970E-01  -2.05566800E-02  -3.26890000E-04  -5.73620000E-04
   +3.13040000E-04  +7.56700000E-05  -7.10300000E-05  +2.91000000E-06  -4.51950000E-04
   +3.62236000E-03  +2.65430000E-04  -1.23250000E-04  -4.66800000E-05  -6.19700000E-05
   +5.12000000E-06  +1.40900000E-05  -1.41100000E-05  +1.57200000E-05  +3.68100000E-05
   -2.81900000E-05  -1.10760000E-04  -4.35000000E-05  -1.23100000E-05  +4.50700000E-05
   +2.14700000E-05  +2.76500000E-05  +1.09800000E-05  -4.30500000E-05  +6.30000000E-05
   +1.32430000E-04  +7.06300000E-05  +2.66600000E-05  +1.82450000E-04  +2.97600000E-05
   -2.22060000E-04  +1.58460000E-04  -6.54060000E-04  +5.88060000E-04  -1.45300000E-05
   -9.98000000E-06  -1.09400000E-05  +1.30700000E-05  +4.00000000E-07  +8.08000000E-06
   -3.17300000E-05  +6.28000000E-06  -1.20600000E-05  -3.82000000E-06  -2.47300000E-05
   -2.13400000E-05  +1.89200000E-05  +7.57000000E-06  -6.27000000E-06  +3.03800000E-05
   -1.01890000E-04  -1.75300000E-05  -1.05600000E-05  +1.24700000E-05  +1.22300000E-05
   -1.83400000E-05  +1.78700000E-05  +2.26200000E-05  -2.44100000E-05  +5.21000000E-06
   +5.84000000E-06  -7.47000000E-06  +2.79200000E-05  +2.62300000E-05  +1.83500000E-05
   +5.59000000E-06  -5.59600000E-05  -1.77600000E-05  -9.25700000E-05  +6.11900000E-05
   +1.82500000E-05  -6.27840000E-04  +5.70300000E-05  +1.62635200E-02  +3.51511070E-01
   +8.88330000E-04  +3.79194000E-03  +3.91362000E-03  -2.96020000E-03  +1.95851000E-03
   +8.83919000E-03  -5.88540000E-04  +4.39780000E-04  -8.27410000E-04  -2.06112000E-03
   -1.06916000E-03  +3.38433000E-03  +1.31240000E-03  -5.67361000E-03  +2.76368000E-03
   -7.87657000E-03  -2.10719600E-02  -3.81991700E-02  +4.36850000E-04  +1.49538000E-03
   -2.34980000E-04  -1.46600000E-05  +1.38900000E-05  -1.50010000E-04  +1.05127000E-03
   -2.09500000E-05  -2.57071000E-03  +1.72680000E-04  -1.59900000E-05  -5.83300000E-05
   -4.98800000E-05  -3.33300000E-05  -3.92800000E-05  +8.92000000E-06  +2.82600000E-05
   -2.36000000E-05  +4.27300000E-05  -1.14600000E-05  +5.47200000E-05  -5.15900000E-05
   -2.04000000E-06  -4.65700000E-05  +7.64600000E-05  -5.00100000E-05  +4.31700000E-05
   -4.30400000E-05  -1.72800000E-05  -2.77100000E-05  -3.50540000E-04  -2.34700000E-05
   +3.55930000E-04  +5.94090000E-04  -2.39186000E-03  +1.07593000E-03  +7.70000000E-07
   +4.92000000E-06  +9.72000000E-06  -1.05100000E-05  +2.90000000E-06  -4.59000000E-06
   -2.30600000E-05  +1.98300000E-05  +1.13700000E-05  +1.39100000E-05  -9.68000000E-06
   -2.36100000E-05  +7.85000000E-06  +2.20000000E-06  +2.34000000E-06  -2.39600000E-05
   +1.74590000E-04  -2.01800000E-05  +1.25000000E-05  -8.29000000E-06  +1.05100000E-05
   -2.33500000E-05  +2.87900000E-05  -1.61200000E-05  +1.33500000E-05  -5.80900000E-05
   -1.26800000E-05  -1.22500000E-05  +3.75100000E-05  +2.49100000E-05  -9.30000000E-07
   -1.41800000E-05  +6.09000000E-06  +7.22300000E-05  -3.52700000E-05  -4.09560000E-04
   -4.61100000E-05  -4.26830000E-04  +3.55010000E-04  +8.35031000E-03  +2.22897900E-02
   +2.72244800E-02  -2.71449400E-01  -1.11914240E-01  -6.20946300E-02  +2.31105000E-03
   +1.79140000E-03  -5.35960000E-04  +3.82710000E-04  +4.00270000E-04  -1.24680000E-04
   +3.59490000E-04  -4.97000000E-05  +2.74760000E-04  -5.64430000E-04  +4.26016000E-03
   -1.76370000E-03  -1.70757100E-02  -1.29574700E-02  -5.76226000E-03  -1.50990000E-04
   -4.37220000E-04  +1.72300000E-05  -2.69900000E-05  -6.35300000E-05  +7.20300000E-05
   -1.29955000E-03  -5.47190000E-04  -3.30680000E-04  -1.40987000E-03  +1.94126000E-03
   +1.09450000E-03  +1.78990000E-04  +3.05970000E-04  +4.76070000E-04  -1.33260000E-04
   -2.64350000E-04  -8.38400000E-05  -2.82920000E-04  +2.07300000E-05  -3.78740000E-04
   +2.81240000E-04  -5.95000000E-06  +2.30890000E-04  -1.22289000E-03  +6.77990000E-04
   +8.58230000E-04  +1.53100000E-04  +6.11400000E-05  +6.71700000E-05  +6.00000000E-08
   -5.85100000E-05  -1.65180000E-04  +4.45740000E-04  +4.97900000E-05  +8.37890000E-04
   -2.16200000E-05  -8.95000000E-06  -1.69100000E-05  +8.73000000E-06  -4.97000000E-06
   +1.70800000E-05  +4.40600000E-05  -6.71100000E-05  -1.46500000E-05  +4.77900000E-05
   -8.01400000E-05  -2.01270000E-04  +1.91800000E-05  -4.84000000E-06  -1.67300000E-05
   +8.62000000E-06  -3.41000000E-05  +6.52000000E-06  -7.76000000E-06  -3.92500000E-05
   -5.32000000E-06  +1.16700000E-05  -1.90000000E-06  +2.32000000E-06  -3.39600000E-05
   -2.08000000E-05  -1.04200000E-05  -1.16300000E-05  +7.12000000E-06  -1.37200000E-05
   +1.61600000E-05  -3.02000000E-06  +1.62400000E-05  +1.42000000E-04  +8.86600000E-05
   +1.70000000E-05  -5.30400000E-05  -4.39500000E-05  +6.27000000E-05  +4.78990000E-04
   +1.17130000E-04  +1.43833000E-03  +2.88939070E-01  -1.13014590E-01  -1.15869750E-01
   -3.00793000E-02  -2.69649900E-02  -9.62846000E-03  -8.09328000E-03  +1.57931000E-03
   -5.59658000E-03  -6.15000000E-05  +5.84840000E-04  -1.03779000E-03  +1.44140000E-04
   +3.53503000E-03  -1.07081000E-03  +9.01100000E-05  +1.69995400E-02  +1.10888200E-02
   +3.94779000E-03  -1.22012000E-03  +3.54000000E-04  +5.23590000E-04  +1.54000000E-04
   +1.66900000E-05  -1.43000000E-06  +1.23257000E-03  +2.26240000E-04  +2.21150000E-04
   +2.51970000E-04  -4.10540000E-04  -6.05310000E-04  +4.36180000E-04  -8.79300000E-05
   +4.30490000E-04  -4.93300000E-05  -8.74100000E-05  +1.03040000E-04  +3.16120000E-04
   +1.76700000E-04  -1.19230000E-04  +4.61000000E-05  -2.47300000E-05  -5.27200000E-05
   +3.87870000E-04  +5.06380000E-04  -1.97380000E-04  -3.62060000E-04  -1.73560000E-04
   -5.94700000E-05  +2.15930000E-04  +5.79500000E-05  -6.32000000E-06  +7.88250000E-04
   +2.75138000E-03  +1.71600000E-05  +4.73400000E-05  +1.57200000E-05  +2.75400000E-05
   -2.10600000E-05  -9.39000000E-06  -2.14700000E-05  -1.99300000E-05  -2.30100000E-05
   -4.07000000E-05  -2.35000000E-06  -2.61800000E-05  +2.41800000E-05  -3.39900000E-05
   -4.66000000E-06  +3.70500000E-05  +8.25000000E-05  -7.68100000E-05  -4.15800000E-05
   +1.75500000E-05  +1.25470000E-04  +6.66400000E-05  -3.19200000E-05  -3.04200000E-05
   +8.58000000E-06  -6.07700000E-05  -1.31000000E-05  -1.48200000E-05  +2.97400000E-05
   +4.79500000E-05  +9.45400000E-05  +3.77000000E-06  -1.20600000E-05  -9.80600000E-05
   -1.73443000E-03  -6.11290000E-04  -1.65050000E-04  -7.20100000E-05  +1.15060000E-04
   +4.72400000E-05  -3.14630000E-04  +1.03321000E-03  +4.81060000E-04  +1.17471870E-01
   +1.18315370E-01  -6.13232800E-02  -3.05821900E-02  -4.67238600E-02  -2.84632000E-03
   +8.64620000E-04  +7.18450000E-04  +5.76830000E-04  -2.09380000E-04  +1.54410000E-03
   +2.33500000E-04  -9.12100000E-05  -7.73670000E-04  -1.57135000E-03  +4.99580000E-04
   +7.39861000E-03  -3.84781000E-03  -2.92584000E-03  +4.84339000E-03  -4.49330000E-04
   +6.39810000E-04  +5.56090000E-04  +1.82440000E-04  -3.85200000E-05  -1.03500000E-04
   -2.66130000E-04  -1.34420000E-04  +2.88740000E-04  +2.07620000E-04  -8.21590000E-04
   -3.47860000E-04  +3.50880000E-04  +4.71000000E-05  +2.60690000E-04  -2.49920000E-04
   -2.07070000E-04  -1.45330000E-04  +2.47890000E-04  +1.14030000E-04  -1.63200000E-05
   +1.74880000E-04  +2.28350000E-04  +4.75100000E-05  +4.72820000E-04  -1.84550000E-04
   -2.61630000E-04  -2.62120000E-04  -1.10630000E-04  -8.83200000E-05  +1.13180000E-04
   +7.30000000E-06  +2.89200000E-05  +8.57540000E-04  -1.46617000E-03  +1.41894000E-03
   +1.55200000E-05  +1.82000000E-05  +3.39500000E-05  -4.86900000E-05  +2.56100000E-05
   -5.13000000E-06  -5.50300000E-05  +6.83500000E-05  -2.00200000E-05  +9.14000000E-06
   -4.40100000E-05  -1.85970000E-04  +1.15300000E-05  -6.34000000E-06  -3.80000000E-06
   -4.06000000E-06  -1.24200000E-05  -2.47900000E-05  +4.22000000E-06  +6.39500000E-05
   +2.18000000E-05  -4.51300000E-05  +4.38100000E-05  -5.54000000E-06  -1.22540000E-04
   -8.30000000E-07  -1.29450000E-04  +1.25800000E-05  +1.25940000E-04  +5.03500000E-05
   -1.34400000E-05  +2.29700000E-05  -6.39700000E-05  -1.68740000E-04  -8.78500000E-05
   -1.21810000E-04  +1.07700000E-05  -3.09000000E-06  -3.69070000E-04  +1.36331000E-03
   +4.84060000E-04  -5.68621000E-03  +6.61080400E-02  +3.33112800E-02  +3.78833300E-02
   -1.22901000E-03  -2.13910000E-04  -1.11540000E-04  +2.93040000E-04  +3.53060000E-04
   -3.18000000E-05  +1.16569000E-03  +7.71040000E-04  -3.88100000E-05  -5.70790000E-03
   +2.65755000E-03  -1.69249000E-03  +2.59867000E-03  +4.33822600E-02  +1.28963000E-03
   +2.86330000E-03  +3.12826000E-03  +1.06999000E-03  -1.19960000E-04  -5.87000000E-05
   +4.83900000E-05  +2.52300000E-05  +5.19700000E-05  -4.03800000E-05  -6.75578300E-02
   -1.34456290E-01  -1.40214300E-02  -7.40000000E-07  -3.82600000E-05  -1.54000000E-05
   -2.02300000E-05  +7.70000000E-07  -3.78500000E-05  +3.42600000E-05  +3.28500000E-05
   -2.28700000E-05  -1.46930000E-04  -6.02500000E-05  -1.90600000E-05  +1.68100000E-05
   -4.05200000E-05  +1.80500000E-05  +1.85400000E-05  -3.15200000E-05  -1.82700000E-05
   +1.60050000E-04  +6.32600000E-05  +3.15700000E-05  +6.09600000E-05  +1.54000000E-05
   -2.97500000E-05  +7.63500000E-05  -3.23990000E-04  +1.61550000E-04  -3.04100000E-05
   -4.14000000E-06  -8.63000000E-06  +1.09900000E-05  +1.71000000E-06  +1.28600000E-05
   -1.75800000E-05  +6.69000000E-06  +2.79000000E-06  -2.05200000E-05  +6.79000000E-06
   +3.46200000E-05  -5.39000000E-06  +1.00700000E-05  +3.26000000E-06  +1.14800000E-05
   -3.01400000E-05  -1.10800000E-05  -2.01700000E-05  +3.06000000E-06  -4.19000000E-06
   -2.89000000E-06  +4.20000000E-07  +1.61700000E-05  -1.31900000E-05  -2.65900000E-05
   +4.60300000E-05  -1.00000000E-06  -9.80000000E-06  +9.02000000E-06  +2.33500000E-05
   -2.82400000E-05  -2.26900000E-05  -3.24000000E-04  +1.52130000E-04  +4.02100000E-05
   +4.27500000E-05  +1.24590000E-04  +6.30100000E-05  -1.08049000E-03  -2.06656000E-03
   -5.34650000E-04  +1.03660000E-04  -5.25000000E-05  +2.26800000E-05  +6.87623200E-02
   -1.87290000E-04  -1.31566000E-03  -1.05970000E-04  +1.88140000E-04  -3.71100000E-05
   +2.20330000E-04  -8.99500000E-04  -7.24870000E-04  -8.29900000E-05  +4.23247000E-03
   +2.15810000E-04  +6.05070000E-04  -4.28672000E-03  -2.94412800E-02  -1.23601000E-03
   -3.74947000E-03  +6.49904000E-03  -5.20990000E-04  +3.65100000E-05  +3.95300000E-05
   -2.01900000E-04  -6.38600000E-05  +4.78000000E-06  +1.59600000E-05  -8.26395900E-02
   -5.08588260E-01  -2.12715300E-02  +4.83700000E-05  +6.64700000E-05  +8.04400000E-05
   -1.17700000E-05  -7.13000000E-06  +2.91100000E-05  -2.06000000E-05  -3.54400000E-05
   +2.58700000E-05  +1.74170000E-04  +6.39400000E-05  +4.36800000E-05  -5.03300000E-05
   +9.56000000E-06  -5.36900000E-05  -1.61000000E-06  +3.46800000E-05  -1.59800000E-05
   -2.00740000E-04  -9.32300000E-05  -4.46600000E-05  -1.04570000E-04  +2.80000000E-06
   +7.05400000E-05  -2.96430000E-04  +2.80560000E-04  -2.66720000E-04  +3.12300000E-05
   +1.03400000E-05  +1.35600000E-05  -1.49100000E-05  +2.20000000E-07  -1.25100000E-05
   +3.16500000E-05  -1.26100000E-05  +3.25000000E-06  +2.07600000E-05  +2.15000000E-05
   -1.77400000E-05  -1.23200000E-05  -9.48000000E-06  +4.70000000E-06  -1.60500000E-05
   +5.59200000E-05  +2.40400000E-05  +1.83300000E-05  -2.15300000E-05  -4.66000000E-06
   +8.85000000E-06  -1.23700000E-05  -1.42400000E-05  +2.90900000E-05  +1.65700000E-05
   -6.12600000E-05  +9.12000000E-06  -1.95000000E-05  -4.14600000E-05  -4.11400000E-05
   +2.84400000E-05  +3.07800000E-05  +2.56710000E-04  -1.07960000E-04  +6.10100000E-05
   +1.93100000E-05  +4.56590000E-04  -1.94000000E-05  +1.08997000E-03  -3.94140000E-04
   +1.72580000E-04  -2.25040000E-04  +1.59340000E-04  -2.05300000E-05  +8.65940400E-02
   +5.32920830E-01  -9.84200000E-05  -1.56220000E-04  -6.57080000E-04  +4.58000000E-05
   +1.64280000E-04  +3.07800000E-04  -5.85200000E-05  +1.66990000E-04  +9.72810000E-04
   -1.66633000E-03  +5.22140000E-04  +2.43210000E-03  +1.13269000E-03  +8.37492000E-03
   -1.86948000E-03  +8.75650000E-04  +9.55650000E-04  -1.11432000E-03  -5.75600000E-05
   +1.99700000E-05  +7.37100000E-05  +7.35000000E-06  -6.41600000E-05  -4.41000000E-05
   -1.37315500E-02  -3.18400800E-02  -7.66962000E-03  +9.26000000E-06  +3.59000000E-06
   -3.92700000E-05  +1.13000000E-06  -7.11000000E-06  -1.10700000E-05  -6.16000000E-06
   +3.22000000E-06  -1.65200000E-05  -3.20000000E-06  -1.80000000E-06  +1.07300000E-05
   -3.40000000E-07  +1.70000000E-06  -9.11000000E-06  +1.43300000E-05  -3.00200000E-05
   +3.50000000E-05  +4.43000000E-06  -1.10000000E-07  -1.25300000E-05  -1.23000000E-06
   +2.42000000E-06  -4.02600000E-05  +4.12600000E-05  -1.01870000E-04  -3.69600000E-05
   -3.82000000E-06  +3.34000000E-06  +5.93000000E-06  -5.56000000E-06  +4.22000000E-06
   +1.09000000E-06  -8.39000000E-06  +9.88000000E-06  +2.60000000E-06  +2.63000000E-06
   -5.00000000E-08  -4.90000000E-06  +7.21000000E-06  +3.95000000E-06  +3.58000000E-06
   +9.49000000E-06  -1.11700000E-05  -4.52000000E-06  -6.50000000E-07  -2.47000000E-06
   +7.81000000E-06  -1.06000000E-05  +1.94400000E-05  -3.63000000E-06  +4.02600000E-05
   +2.31800000E-05  +3.17900000E-05  -3.96000000E-06  -2.22900000E-05  +1.44700000E-05
   +3.37000000E-06  +6.40000000E-06  -1.46100000E-05  -9.06000000E-06  +1.12300000E-05
   -3.02670000E-04  +5.09000000E-05  -1.36500000E-05  -3.71750000E-04  -4.38620000E-04
   -5.37510000E-04  +4.62630000E-04  -4.58000000E-06  -1.24000000E-06  +6.52300000E-05
   +1.38763600E-02  +2.24487300E-02  +7.78185000E-03  -2.94400000E-05  -9.00500000E-05
   -7.36180000E-04  +6.12600000E-03  -4.04811000E-03  -1.60620000E-02  +2.15530000E-03
   -5.62740000E-04  -6.10460000E-04  -1.03735000E-03  +1.27223000E-03  +2.16800000E-04
   -6.34300000E-04  -4.46550000E-04  -4.76860000E-04  +6.95980000E-04  +3.50420000E-04
   +1.63290000E-04  -8.76150000E-04  +6.66680000E-04  -1.49440000E-03  +5.76600000E-04
   -1.02450000E-04  -4.67460000E-04  +6.63500000E-05  -1.49210000E-04  +4.11600000E-05
   +3.40410000E-04  +9.45900000E-05  -5.38000000E-06  -2.86790000E-04  +3.41390000E-04
   -2.43830000E-04  -2.80200000E-05  -1.78120000E-04  +6.78500000E-05  -1.56600000E-05
   -7.90600000E-05  +9.92000000E-06  -5.29300000E-05  -2.84500000E-05  +3.36000000E-06
   +3.72500000E-05  +4.69600000E-05  -3.63700000E-05  -3.32400000E-05  -3.92300000E-05
   -2.07500000E-05  +1.31820000E-04  +3.20100000E-05  -1.60680000E-04  -2.21648530E-01
   +1.28861560E-01  +2.36937070E-01  -1.23100000E-05  +1.19700000E-05  +2.40900000E-05
   -7.29000000E-05  +4.22900000E-05  +2.19000000E-05  +2.12680000E-04  -1.62740000E-04
   +3.08730000E-04  +1.02000000E-06  -1.04500000E-05  -3.14000000E-06  -5.07000000E-06
   +4.29000000E-06  +1.31000000E-06  -2.70000000E-07  -1.99800000E-05  -9.84000000E-06
   +2.30000000E-07  -7.20000000E-06  +7.96500000E-05  +1.39000000E-05  -2.56450000E-04
   -7.02300000E-05  +2.84500000E-05  -7.63000000E-06  +3.17500000E-05  +1.39900000E-05
   -4.87700000E-05  +6.21700000E-05  +1.58900000E-05  +6.43600000E-05  -2.63950000E-04
   +4.47800000E-05  -1.92540000E-04  -2.63760000E-04  -5.84900000E-05  +4.09000000E-06
   +8.50000000E-05  -1.29910000E-04  +3.09400000E-05  +1.77980000E-04  -1.88310000E-04
   -2.25810000E-04  +2.98540000E-04  +3.07600000E-05  +3.32100000E-05  -1.35800000E-05
   +2.14618240E-01  -1.84154000E-03  +1.87639000E-03  +1.72110000E-04  -9.54187000E-03
   +2.14064000E-03  +1.55497400E-02  +6.29710000E-04  -5.51590000E-04  +2.97030000E-04
   -3.05440000E-04  +1.40268000E-03  +6.64000000E-05  -3.90460000E-04  -1.15805000E-03
   +1.39690000E-04  +2.12953000E-03  -3.00200000E-04  +4.84000000E-05  +1.04955000E-03
   -1.44094000E-03  +2.34519000E-03  -5.43610000E-04  +5.15000000E-04  +5.17950000E-04
   -3.64630000E-04  +1.39500000E-04  -9.82300000E-05  +3.79910000E-04  +1.27600000E-05
   +8.85300000E-05  +1.02450000E-04  -1.29850000E-04  +4.46200000E-05  -7.93100000E-05
   -1.05000000E-06  -9.87400000E-05  -2.56100000E-05  -1.65000000E-06  -4.14000000E-06
   -2.99000000E-06  -3.85500000E-05  +4.95000000E-06  -3.42000000E-06  +2.04200000E-05
   +8.30000000E-06  +3.44800000E-05  -1.54000000E-06  -9.79000000E-06  +3.70570000E-04
   -1.45250000E-04  -3.18040000E-04  +1.34313970E-01  -8.12646900E-02  -1.35224510E-01
   -2.06300000E-05  +1.09400000E-05  +5.46000000E-06  -5.78000000E-06  +1.47600000E-05
   +9.60000000E-06  -1.83240000E-04  +7.56000000E-05  -4.83500000E-05  +4.08000000E-06
   +1.67300000E-05  +1.27300000E-05  -7.52000000E-06  +2.34000000E-06  +4.70000000E-06
   -9.74600000E-05  +4.31100000E-05  -1.64220000E-04  -8.87800000E-05  +9.67000000E-06
   -1.38310000E-04  -1.04030000E-04  +4.80870000E-04  -1.83790000E-04  -3.43900000E-05
   +1.20100000E-05  -4.41800000E-05  +2.62900000E-05  +1.98000000E-06  +2.92800000E-05
   +9.20500000E-05  +3.58400000E-05  +3.00900000E-04  -2.38800000E-05  -2.73410000E-04
   -4.12830000E-04  +4.82200000E-05  -7.87400000E-05  -1.30310000E-04  -3.90500000E-05
   +1.75400000E-05  -8.46000000E-06  -3.61230000E-04  -1.95810000E-04  +3.81660000E-04
   +8.55300000E-05  -6.63300000E-05  +4.44700000E-05  -1.25201440E-01  +7.88188600E-02
   +5.11290000E-04  +3.08840000E-04  +1.74171000E-03  +2.24804100E-02  -1.27188400E-02
   -2.86755900E-02  +1.04530000E-04  -9.93850000E-04  +1.35278000E-03  +6.05000000E-06
   +2.17570000E-04  +1.99100000E-05  -9.39240000E-04  +5.44190000E-04  -2.15260000E-04
   +1.67710000E-04  -1.63720000E-04  -1.83000000E-06  -2.80839000E-03  +2.52881000E-03
   -5.82586000E-03  +1.54548000E-03  -6.27600000E-04  -6.76790000E-04  +8.92060000E-04
   -6.85030000E-04  +2.16290000E-04  -5.23210000E-04  -1.10230000E-04  +3.45070000E-04
   -2.46770000E-04  +5.15100000E-05  +3.15500000E-05  +4.19800000E-05  -7.62500000E-05
   +4.65700000E-05  +1.65630000E-04  -3.92100000E-05  +1.27450000E-04  -1.54130000E-04
   -1.76100000E-05  -8.77400000E-05  +8.99500000E-05  +2.61990000E-04  -4.30000000E-05
   -1.88380000E-04  -8.80400000E-05  -6.33900000E-05  -5.41760000E-04  +7.61560000E-04
   +5.62960000E-04  +1.96984680E-01  -1.06045820E-01  -2.78503770E-01  +2.03600000E-05
   +9.62000000E-06  +3.12500000E-05  -5.02800000E-05  +1.73200000E-05  -1.21000000E-06
   +2.64480000E-04  -4.97600000E-05  +6.45300000E-05  +7.98000000E-06  -1.90300000E-05
   -2.72200000E-05  +2.19000000E-06  -1.03800000E-05  -7.92000000E-06  -2.01500000E-05
   +6.54800000E-05  +1.16590000E-04  +1.78700000E-05  -9.43700000E-05  -4.59300000E-05
   +8.00800000E-05  -1.45940000E-04  +7.64200000E-05  +3.27700000E-05  +8.96600000E-05
   -2.09000000E-05  -4.32100000E-05  -7.95600000E-05  -3.53200000E-05  -3.04840000E-04
   +1.77470000E-04  -4.66230000E-04  -9.06400000E-05  +3.49300000E-05  -1.62020000E-04
   +1.35220000E-04  -1.90600000E-05  -1.84880000E-04  +1.11010000E-04  -1.22740000E-04
   -1.86900000E-04  -7.37100000E-05  +8.32900000E-05  -8.38500000E-05  -8.52900000E-05
   +1.42610000E-04  +1.32800000E-05  -2.17591690E-01  +1.16812200E-01  +3.10569240E-01
end_hess

