# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -731.72296220    # Total energy in hartree
   pointgroup    C2              # Point group
   rotsigma      2               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   +9.18644284E-03  +8.81793278E+00  -3.34147978E+00
   006   +4.05211533E-02  +6.68957021E+00  -1.90296592E+00
   006   +1.80278588E+00  +4.77184763E+00  -2.24867135E+00
   006   +1.73215805E+00  +2.64777710E+00  -7.29757848E-01
   006   -6.81509564E-02  +2.36036755E+00  +1.16908578E+00
   006   -1.81064342E+00  +4.30042740E+00  +1.47736561E+00
   006   -1.77219452E+00  +6.44319751E+00  -3.20475860E-02
   006   +4.37437676E-18  +4.37437676E-18  +2.84268939E+00
   006   +2.33396588E+00  +2.01580374E-01  +4.55785581E+00
   006   -2.33396588E+00  -2.01580374E-01  +4.55785581E+00
   006   +6.81509564E-02  -2.36036755E+00  +1.16908578E+00
   006   +1.81064342E+00  -4.30042740E+00  +1.47736561E+00
   006   +1.77219452E+00  -6.44319751E+00  -3.20475860E-02
   006   -4.05211533E-02  -6.68957021E+00  -1.90296592E+00
   006   -1.80278588E+00  -4.77184763E+00  -2.24867135E+00
   006   -1.73215805E+00  -2.64777710E+00  -7.29757848E-01
   008   -9.18644284E-03  -8.81793278E+00  -3.34147978E+00
   001   +1.35079175E+00  +8.75227249E+00  -4.55158279E+00
   001   +3.22472980E+00  +4.93464335E+00  -3.71495941E+00
   001   +3.10000485E+00  +1.15965079E+00  -1.05153431E+00
   001   -3.25319441E+00  +4.16876355E+00  +2.91744222E+00
   001   -3.14581804E+00  +7.93371769E+00  +2.27633445E-01
   001   +2.24087791E+00  +1.95714195E+00  +5.63125413E+00
   001   +2.41694535E+00  -1.35888151E+00  +5.90307255E+00
   001   +4.08306228E+00  +2.21627962E-01  +3.46972924E+00
   001   -4.08306228E+00  -2.21627962E-01  +3.46972924E+00
   001   -2.24087791E+00  -1.95714195E+00  +5.63125413E+00
   001   -2.41694535E+00  +1.35888151E+00  +5.90307255E+00
   001   +3.25319441E+00  -4.16876355E+00  +2.91744222E+00
   001   +3.14581804E+00  -7.93371769E+00  +2.27633445E-01
   001   -3.22472980E+00  -4.93464335E+00  -3.71495941E+00
   001   -3.10000485E+00  -1.15965079E+00  -1.05153431E+00
   001   -1.35079175E+00  -8.75227249E+00  -4.55158279E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.36000000E-06  +1.40000000E-06  -1.14000000E-06
   +1.17000000E-06  -1.27000000E-06  +1.76000000E-06
   +1.87000000E-06  -2.26000000E-06  +7.00000000E-07
   -1.62000000E-06  +1.57000000E-06  +1.50000000E-07
   +1.19000000E-06  +3.60000000E-07  -1.10000000E-07
   +2.91000000E-06  +3.30000000E-07  -1.61000000E-06
   +2.28000000E-06  +2.30000000E-07  -2.40000000E-07
   +0.00000000E+00  +0.00000000E+00  -5.00000000E-07
   -6.40000000E-07  -2.69000000E-06  -9.30000000E-07
   +6.40000000E-07  +2.69000000E-06  -9.30000000E-07
   -1.19000000E-06  -3.60000000E-07  -1.10000000E-07
   -2.91000000E-06  -3.30000000E-07  -1.61000000E-06
   -2.28000000E-06  -2.30000000E-07  -2.40000000E-07
   -1.17000000E-06  +1.27000000E-06  +1.76000000E-06
   -1.87000000E-06  +2.26000000E-06  +7.00000000E-07
   +1.62000000E-06  -1.57000000E-06  +1.50000000E-07
   -2.36000000E-06  -1.40000000E-06  -1.14000000E-06
   +3.29000000E-06  +8.50000000E-07  -1.48000000E-06
   +2.96000000E-06  -6.80000000E-07  -1.85000000E-06
   +2.16000000E-06  -2.35000000E-06  -1.08000000E-06
   -7.00000000E-08  -1.80000000E-06  +3.67000000E-06
   +4.40000000E-07  +2.53000000E-06  +7.20000000E-07
   +7.90000000E-07  +3.90000000E-07  +9.70000000E-07
   +2.20000000E-07  -1.89000000E-06  +5.90000000E-07
   +1.81000000E-06  -1.43000000E-06  +1.50000000E-07
   -1.81000000E-06  +1.43000000E-06  +1.50000000E-07
   -7.90000000E-07  -3.90000000E-07  +9.70000000E-07
   -2.20000000E-07  +1.89000000E-06  +5.90000000E-07
   +7.00000000E-08  +1.80000000E-06  +3.67000000E-06
   -4.40000000E-07  -2.53000000E-06  +7.20000000E-07
   -2.96000000E-06  +6.80000000E-07  -1.85000000E-06
   -2.16000000E-06  +2.35000000E-06  -1.08000000E-06
   -3.29000000E-06  -8.50000000E-07  -1.48000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.84056960E-01  -5.76305100E-02  +3.23798970E-01  -2.94787660E-01  -1.50628510E-01
   +4.06254410E-01  -8.56101000E-02  +4.04916200E-02  +1.15050800E-02  +5.14933510E-01
   +5.93246000E-03  -2.38209330E-01  +1.28599690E-01  -1.44089730E-01  +5.94022350E-01
   +3.53997600E-02  +9.62740300E-02  -1.42969680E-01  -2.31809830E-01  -1.61118060E-01
   +4.91804530E-01  +6.02924000E-03  +3.81853000E-03  +8.67060000E-04  -2.02144780E-01
   +1.35079080E-01  +3.23172200E-02  +4.95773260E-01  +3.03018600E-02  -4.16126900E-02
   +6.43574000E-03  +7.93442500E-02  -2.08192820E-01  +2.13752700E-02  -1.43012290E-01
   +5.83493240E-01  -1.76004800E-02  +3.17844400E-02  +4.24359000E-03  +7.11701200E-02
   -3.19206100E-02  -1.14678040E-01  -2.51982250E-01  -1.78492290E-01  +4.87670030E-01
   -2.94065000E-03  +5.94944000E-03  +5.52179000E-03  +3.24355300E-02  +6.22053000E-03
   -3.26279800E-02  -1.03680150E-01  +3.81098100E-02  +1.55428900E-02  +4.93902360E-01
   +2.82720000E-04  +3.15165000E-03  +2.66189000E-03  +4.58994200E-02  -4.82780200E-02
   -8.64372000E-03  -8.45047000E-03  -2.67395780E-01  +1.50439840E-01  -1.77230330E-01
   +6.26100400E-01  +9.40515000E-03  -2.82480000E-03  +2.15860000E-04  -5.94807700E-02
   +2.88166900E-02  +3.93389400E-02  +4.74643300E-02  +1.06167960E-01  -1.77195110E-01
   -2.13510590E-01  -1.57158110E-01  +4.56030360E-01  +4.22018000E-03  -3.05481000E-03
   -3.14167000E-03  -5.86115400E-02  +2.44671600E-02  +3.29485200E-02  +2.60913700E-02
   -6.34087300E-02  +2.65094700E-02  -1.95533700E-01  +2.77093600E-02  +9.97697900E-02
   +4.91565080E-01  -2.46982000E-03  -2.12113000E-03  +2.76922000E-03  +2.27965800E-02
   -8.63796000E-03  -1.90343600E-02  -2.59465300E-02  +2.03433000E-02  +1.63093800E-02
   -1.92264300E-02  -1.18339200E-01  +5.08167500E-02  -1.46483610E-01  +5.49323830E-01
   -3.54990000E-03  +2.46769000E-03  +4.33820000E-04  +3.37392600E-02  -2.02785900E-02
   -2.38895600E-02  +1.85427000E-03  +4.99931900E-02  -2.79713700E-02  +1.31008200E-01
   +7.68824000E-03  -2.01163180E-01  -1.88258890E-01  -1.16301600E-01  +4.50073170E-01
   -4.05814000E-03  +3.87179000E-03  +5.95958000E-03  +2.74979700E-02  -3.20969100E-02
   -1.69161000E-03  -1.33309600E-02  +2.48946000E-02  -7.94922000E-03  -3.59239200E-02
   +5.25661000E-03  +3.84654100E-02  -1.94898130E-01  +1.36250730E-01  +2.67694900E-02
   +5.10936340E-01  +8.47305000E-03  +6.42140000E-04  -4.78000000E-03  -7.23337600E-02
   +2.44631600E-02  +5.25481700E-02  +2.34985600E-02  -6.08773000E-02  +1.69132500E-02
   +4.08543900E-02  +3.89095300E-02  -5.86340900E-02  +8.99603100E-02  -2.24458120E-01
   +2.41089500E-02  -1.41190080E-01  +5.73292160E-01  +2.94182000E-03  -6.09180000E-04
   +2.83743000E-03  +2.48935300E-02  +1.53586600E-02  -3.17261900E-02  -6.73345000E-03
   +1.48154700E-02  -7.45289000E-03  +1.42035100E-02  -2.48519400E-02  +1.18621400E-02
   +5.70805000E-02  -1.94693500E-02  -1.08063800E-01  -2.47305080E-01  -1.64311150E-01
   +4.88733780E-01  +4.76652000E-03  -7.43978000E-03  +7.76048000E-03  -2.15196950E-01
   -1.15775500E-02  +1.42892500E-01  -2.94731900E-02  +3.53187800E-02  +1.16269900E-02
   -1.64040300E-02  -1.54198900E-02  +2.27767600E-02  +2.84077900E-02  +8.91818000E-03
   -2.67833100E-02  -1.05077730E-01  +4.07501100E-02  +1.41837100E-02  +5.09102420E-01
   -3.35668700E-02  -6.95701000E-03  +4.15202600E-02  +4.13655300E-02  -1.18024290E-01
   -6.53119000E-03  +2.90160000E-03  +3.83706500E-02  -2.32013900E-02  -1.73917000E-02
   -2.11188000E-02  +2.87617300E-02  +4.36861100E-02  -4.39730100E-02  -5.88380000E-03
   -5.60982000E-03  -2.62144250E-01  +1.44677700E-01  -1.86052430E-01  +6.23480020E-01
   +2.58153400E-02  +1.70023300E-02  -2.83305500E-02  +1.06280870E-01  +4.31899400E-02
   -2.00897640E-01  +3.38818800E-02  -5.37457700E-02  +1.36397200E-02  +2.43913500E-02
   +2.68861600E-02  -4.41789000E-02  -4.97366200E-02  +2.67287900E-02  +3.62939700E-02
   +4.55588200E-02  +1.00583080E-01  -1.73843270E-01  -2.27581880E-01  -1.65884020E-01
   +4.57233770E-01  +8.85400000E-05  +5.70280000E-04  -1.06837000E-03  -1.49035000E-03
   +9.96500000E-05  +9.40750000E-04  -1.33418000E-03  +1.28145000E-03  +5.64713000E-03
   +4.56043000E-03  -1.94133700E-02  +1.13788600E-02  -8.22500500E-02  +5.33897000E-03
   +8.73930000E-03  +4.19327000E-03  +1.41554000E-02  -1.25292600E-02  +3.89110000E-04
   +4.11449000E-03  +2.86717000E-03  +4.81561320E-01  -2.57690000E-04  +1.59051000E-03
   -1.17358000E-03  +1.19863000E-03  -2.28549000E-03  -2.12070000E-04  +1.28864000E-03
   +4.08106000E-03  -3.63700000E-04  -5.51596000E-03  -3.70949000E-03  +8.65908000E-03
   +8.30044000E-03  -1.40466760E-01  +4.35465000E-02  +2.24641000E-03  -1.80098500E-02
   +1.31431200E-02  +3.78224000E-03  +7.93450000E-04  +6.52150000E-04  +6.89500000E-05
   +4.74802120E-01  -4.02730000E-04  -7.87830000E-04  +2.94200000E-04  +3.00040000E-04
   +3.59770000E-04  -9.38560000E-04  +4.40360000E-03  +4.28500000E-05  +8.24900000E-04
   +1.18097000E-03  +2.05603100E-02  -1.51438700E-02  +6.74916000E-03  +4.58559400E-02
   -1.09233850E-01  -3.86297000E-03  +3.45100000E-04  +6.33297000E-03  +4.15007000E-03
   -4.24370000E-04  +3.13647000E-03  +0.00000000E+00  +0.00000000E+00  +4.81467390E-01
   -1.02820000E-04  -5.07760000E-04  +3.88260000E-04  +3.48520000E-04  +1.78770000E-04
   -2.39730000E-04  -2.03800000E-04  +2.89950000E-04  +5.66800000E-05  -1.97820000E-04
   -1.67132000E-03  +1.18273000E-03  -2.99679000E-03  +7.62698000E-03  -8.23261000E-03
   -2.05200000E-05  -8.22830000E-04  +1.60110000E-04  -1.24520000E-04  -7.95500000E-05
   +2.99170000E-04  -1.38908100E-01  -7.19189000E-03  -4.48030300E-02  +5.12503840E-01
   -1.17430000E-04  -1.25506000E-03  +9.95140000E-04  +4.80070000E-04  +6.14860000E-04
   -7.61980000E-04  +1.27100000E-04  -1.88930000E-04  -7.04700000E-04  +8.46280000E-04
   -5.19840000E-04  +9.15380000E-04  +2.29267900E-02  -2.24086000E-03  +1.80467200E-02
   -7.68880000E-04  -7.10490000E-04  +1.86145000E-03  -1.18810000E-03  -1.38419000E-03
   -1.75650000E-04  -2.54531000E-03  -7.59946700E-02  -2.13153000E-03  -1.03606400E-02
   +5.85746610E-01  +9.40200000E-05  +5.36540000E-04  -4.79300000E-04  -5.28910000E-04
   -1.64280000E-04  +5.71360000E-04  +2.58700000E-05  -5.54400000E-05  +7.73120000E-04
   -1.16051000E-03  +4.54110000E-04  -4.29540000E-04  -1.83140900E-02  +7.48437000E-03
   -1.87311700E-02  +7.23960000E-04  -1.42496000E-03  -1.06909000E-03  +9.31610000E-04
   +7.85320000E-04  -1.79550000E-04  -4.80843700E-02  -6.52841000E-03  -1.08852700E-01
   -6.30075600E-02  -6.10299000E-03  +5.39645900E-01  -3.61500000E-05  +3.36480000E-04
   -2.25780000E-04  +2.91360000E-04  -2.74190000E-04  +5.44700000E-05  +1.22850000E-04
   +4.33880000E-04  -2.57100000E-04  -4.01600000E-05  +1.29518000E-03  -8.68480000E-04
   +8.93390000E-04  -4.69060000E-03  +1.63308000E-03  +8.65100000E-05  +1.15825000E-03
   -8.68410000E-04  -1.81940000E-04  +1.84550000E-04  +1.13900000E-05  -1.38908100E-01
   -7.19188000E-03  +4.48030300E-02  -3.72790300E-02  -2.46497000E-03  +1.43640300E-02
   +5.12503840E-01  -8.93000000E-06  -5.52300000E-04  +3.92210000E-04  +8.63600000E-05
   +3.83960000E-04  -2.57900000E-04  -8.46560000E-04  +3.25380000E-04  +1.12307000E-03
   +1.34016000E-03  -4.88263000E-03  +2.43793000E-03  -2.37975100E-02  -2.73811000E-03
   +1.78676500E-02  -7.57370000E-04  -1.25918000E-03  +8.05830000E-04  -6.93020000E-04
   +1.31040000E-04  +4.20120000E-04  -2.54530000E-03  -7.59946800E-02  +2.13153000E-03
   -2.46497000E-03  +3.61980000E-04  +8.23690000E-04  -1.03606400E-02  +5.85746610E-01
   +2.35400000E-05  -1.23300000E-05  -1.50200000E-05  +7.90300000E-05  +1.61880000E-04
   +7.24500000E-05  +6.17690000E-04  -2.37860000E-04  -5.68300000E-04  -5.43890000E-04
   +3.04943000E-03  -3.90260000E-04  +1.72998400E-02  +6.18488000E-03  -1.50525000E-02
   -7.16650000E-04  +1.16220000E-04  -4.92450000E-04  +6.21580000E-04  -5.61750000E-04
   -4.75850000E-04  +4.80843800E-02  +6.52841000E-03  -1.08852690E-01  -1.43640300E-02
   -8.23690000E-04  +1.06847100E-02  +6.30075600E-02  +6.10299000E-03  +5.39645900E-01
   +1.22380000E-04  -2.49200000E-05  +7.28100000E-05  -2.05170000E-04  +3.65000000E-05
   +1.49750000E-04  +1.11700000E-05  -3.15740000E-04  -3.27700000E-04  +1.42670000E-04
   -1.52161000E-03  +8.05200000E-04  -7.92780000E-04  +4.40478000E-03  +1.94546000E-03
   +2.22120000E-04  +3.50840000E-04  -6.58300000E-04  -1.60540000E-04  +9.97600000E-05
   -2.71040000E-04  -8.22500500E-02  +8.30044000E-03  -6.74916000E-03  +8.93390000E-04
   -2.37975100E-02  -1.72998400E-02  -2.99679000E-03  +2.29267900E-02  +1.83140900E-02
   +4.91565080E-01  -5.34400000E-05  -1.17400000E-05  +5.11700000E-05  +5.56200000E-04
   -1.81480000E-04  -2.72960000E-04  +5.09750000E-04  +4.58910000E-04  -7.43960000E-04
   -5.58060000E-04  -9.90860000E-04  -5.57760000E-04  +4.40478000E-03  -3.55333300E-02
   -9.80549000E-03  -2.24950000E-03  -9.95740000E-04  +7.12320000E-04  +7.30160000E-04
   -2.66400000E-04  +9.44410000E-04  +5.33896000E-03  -1.40466760E-01  -4.58559400E-02
   -4.69060000E-03  -2.73811000E-03  -6.18488000E-03  +7.62698000E-03  -2.24086000E-03
   -7.48437000E-03  -1.46483610E-01  +5.49323830E-01  +1.08350000E-04  +9.80730000E-04
   -8.51610000E-04  -4.85580000E-04  -4.41020000E-04  +9.93010000E-04  +1.81700000E-05
   -1.00430000E-04  -1.65400000E-05  +3.19130000E-04  +2.64454000E-03  -5.73700000E-04
   -1.94546000E-03  +9.80549000E-03  +1.35513500E-02  +9.88040000E-04  +1.54113000E-03
   -2.48029000E-03  -5.94090000E-04  +6.74000000E-04  -9.52290000E-04  -8.73930000E-03
   -4.35464900E-02  -1.09233860E-01  -1.63308000E-03  -1.78676500E-02  -1.50525000E-02
   +8.23261000E-03  -1.80467200E-02  -1.87311700E-02  +1.88258890E-01  +1.16301600E-01
   +4.50073170E-01  -4.64000000E-06  -3.11460000E-04  +2.60630000E-04  +3.42010000E-04
   +4.35000000E-05  -3.16990000E-04  +6.28300000E-05  +2.08650000E-04  -3.01270000E-04
   -6.66940000E-04  -6.59520000E-04  +1.48710000E-04  +2.22120000E-04  -2.24950000E-03
   -9.88040000E-04  -1.78220000E-04  +1.64860000E-04  -2.71700000E-05  +1.24800000E-05
   -2.70580000E-04  +4.89240000E-04  +4.19327000E-03  +2.24641000E-03  +3.86297000E-03
   +8.65100000E-05  -7.57370000E-04  +7.16650000E-04  -2.05200000E-05  -7.68880000E-04
   -7.23960000E-04  -1.94898130E-01  +1.36250730E-01  -2.67694900E-02  +5.10936340E-01
   +2.04400000E-05  +1.53600000E-05  -4.81200000E-05  -4.60670000E-04  +1.13760000E-04
   +1.77370000E-04  +2.20170000E-04  -3.56460000E-04  +3.46120000E-04  +4.68690000E-04
   +7.34070000E-04  -3.23100000E-05  +3.50840000E-04  -9.95740000E-04  -1.54113000E-03
   +1.64860000E-04  -8.95340000E-04  +7.43080000E-04  +3.26230000E-04  +2.09790000E-04
   -2.71600000E-04  +1.41554100E-02  -1.80098500E-02  -3.45100000E-04  +1.15825000E-03
   -1.25918000E-03  -1.16220000E-04  -8.22830000E-04  -7.10490000E-04  +1.42496000E-03
   +8.99603100E-02  -2.24458120E-01  -2.41089500E-02  -1.41190080E-01  +5.73292160E-01
   -2.19900000E-05  -1.61650000E-04  +8.34300000E-05  -2.28190000E-04  +2.43510000E-04
   +6.56100000E-05  +9.82900000E-05  -3.14080000E-04  +2.86050000E-04  +1.48430000E-04
   +4.34090000E-04  +5.89100000E-05  +6.58300000E-04  -7.12320000E-04  -2.48029000E-03
   +2.71700000E-05  -7.43080000E-04  +7.65100000E-04  +2.52700000E-04  +7.41100000E-05
   -1.13400000E-04  +1.25292600E-02  -1.31431200E-02  +6.33297000E-03  +8.68410000E-04
   -8.05830000E-04  -4.92450000E-04  -1.60110000E-04  -1.86145000E-03  -1.06909000E-03
   -5.70805000E-02  +1.94693500E-02  -1.08063800E-01  +2.47305080E-01  +1.64311150E-01
   +4.88733780E-01  +4.72000000E-06  -1.38450000E-04  +1.14800000E-04  +1.46540000E-04
   +6.15600000E-05  -1.36670000E-04  -1.02300000E-05  +7.74200000E-05  -9.93900000E-05
   -2.47410000E-04  -5.16800000E-05  +1.17730000E-04  -1.60540000E-04  +7.30160000E-04
   +5.94090000E-04  +1.24800000E-05  +3.26230000E-04  -2.52700000E-04  -1.33850000E-04
   -1.06020000E-04  +1.27270000E-04  +3.89110000E-04  +3.78224000E-03  -4.15007000E-03
   -1.81940000E-04  -6.93020000E-04  -6.21580000E-04  -1.24520000E-04  -1.18810000E-03
   -9.31610000E-04  +2.84077900E-02  +8.91818000E-03  +2.67833100E-02  -1.05077730E-01
   +4.07501100E-02  -1.41837100E-02  +5.09102420E-01  -5.26000000E-05  -2.38340000E-04
   +1.92390000E-04  +2.42130000E-04  +1.53490000E-04  -2.44170000E-04  -1.23920000E-04
   +1.76040000E-04  -4.03800000E-05  -1.59000000E-06  -2.76110000E-04  -1.76950000E-04
   +9.97600000E-05  -2.66400000E-04  -6.74000000E-04  -2.70580000E-04  +2.09790000E-04
   -7.41100000E-05  -1.06020000E-04  -1.23310000E-04  +2.48980000E-04  +4.11449000E-03
   +7.93450000E-04  +4.24370000E-04  +1.84550000E-04  +1.31040000E-04  +5.61750000E-04
   -7.95500000E-05  -1.38419000E-03  -7.85320000E-04  +4.36861100E-02  -4.39730100E-02
   +5.88380000E-03  -5.60982000E-03  -2.62144250E-01  -1.44677700E-01  -1.86052430E-01
   +6.23480020E-01  -5.28800000E-05  -3.91260000E-04  +3.61970000E-04  +3.87840000E-04
   +1.62050000E-04  -4.67040000E-04  -1.39560000E-04  +2.56910000E-04  -1.43590000E-04
   +5.21700000E-05  -5.97600000E-04  -1.47980000E-04  +2.71040000E-04  -9.44410000E-04
   -9.52290000E-04  -4.89240000E-04  +2.71600000E-04  -1.13400000E-04  -1.27270000E-04
   -2.48980000E-04  +4.82020000E-04  -2.86717000E-03  -6.52150000E-04  +3.13648000E-03
   -1.13900000E-05  -4.20120000E-04  -4.75850000E-04  -2.99170000E-04  +1.75650000E-04
   -1.79550000E-04  +4.97366200E-02  -2.67287900E-02  +3.62939700E-02  -4.55588200E-02
   -1.00583080E-01  -1.73843270E-01  +2.27581880E-01  +1.65884020E-01  +4.57233770E-01
   +3.82500000E-05  +1.70370000E-04  -1.69500000E-04  -3.98280000E-04  -9.82000000E-06
   +2.94420000E-04  +1.54510000E-04  -3.22750000E-04  +1.53450000E-04  +1.74390000E-04
   +4.26290000E-04  +1.54320000E-04  -2.05170000E-04  +5.56200000E-04  +4.85580000E-04
   +3.42010000E-04  -4.60670000E-04  +2.28190000E-04  +1.46540000E-04  +2.42130000E-04
   -3.87840000E-04  -1.49035000E-03  +1.19863000E-03  -3.00040000E-04  +2.91360000E-04
   +8.63600000E-05  -7.90300000E-05  +3.48520000E-04  +4.80070000E-04  +5.28910000E-04
   -5.86115400E-02  +2.27965800E-02  -3.37392600E-02  +2.74979700E-02  -7.23337600E-02
   -2.48935300E-02  -2.15196950E-01  +4.13655300E-02  -1.06280870E-01  +5.14933510E-01
   +8.68000000E-06  +8.22880000E-04  -5.87470000E-04  -9.82000000E-06  -6.91640000E-04
   +4.62560000E-04  -2.62700000E-04  +2.72430000E-04  +1.44500000E-04  +1.76180000E-04
   -5.51200000E-05  -1.78360000E-04  +3.65000000E-05  -1.81480000E-04  +4.41020000E-04
   +4.35000000E-05  +1.13760000E-04  -2.43510000E-04  +6.15600000E-05  +1.53490000E-04
   -1.62050000E-04  +9.96500000E-05  -2.28549000E-03  -3.59780000E-04  -2.74190000E-04
   +3.83960000E-04  -1.61880000E-04  +1.78770000E-04  +6.14860000E-04  +1.64280000E-04
   +2.44671600E-02  -8.63796000E-03  +2.02785900E-02  -3.20969100E-02  +2.44631600E-02
   -1.53586600E-02  -1.15775500E-02  -1.18024290E-01  -4.31899400E-02  -1.44089730E-01
   +5.94022350E-01  +4.64000000E-05  +6.93390000E-04  -5.51000000E-04  -2.94420000E-04
   -4.62560000E-04  +5.78550000E-04  -3.22800000E-05  -6.90400000E-05  +1.41100000E-04
   +1.81240000E-04  +2.78660000E-04  -6.02600000E-05  -1.49750000E-04  +2.72960000E-04
   +9.93010000E-04  +3.16990000E-04  -1.77370000E-04  +6.56100000E-05  +1.36670000E-04
   +2.44170000E-04  -4.67040000E-04  -9.40750000E-04  +2.12070000E-04  -9.38560000E-04
   -5.44700000E-05  +2.57900000E-04  +7.24500000E-05  +2.39730000E-04  +7.61980000E-04
   +5.71360000E-04  -3.29485200E-02  +1.90343600E-02  -2.38895600E-02  +1.69161000E-03
   -5.25481700E-02  -3.17261900E-02  -1.42892500E-01  +6.53119000E-03  -2.00897640E-01
   +2.31809830E-01  +1.61118060E-01  +4.91804530E-01  -4.89000000E-06  +2.25100000E-04
   -1.62310000E-04  +1.54510000E-04  -2.62700000E-04  +3.22800000E-05  -1.92190000E-04
   +2.67480000E-04  -9.63400000E-05  -1.12010000E-04  -2.01380000E-04  +1.30430000E-04
   +1.11700000E-05  +5.09750000E-04  -1.81700000E-05  +6.28300000E-05  +2.20170000E-04
   -9.82900000E-05  -1.02300000E-05  -1.23920000E-04  +1.39560000E-04  -1.33418000E-03
   +1.28865000E-03  -4.40359000E-03  +1.22850000E-04  -8.46560000E-04  -6.17690000E-04
   -2.03800000E-04  +1.27100000E-04  -2.58700000E-05  +2.60913700E-02  -2.59465300E-02
   -1.85427000E-03  -1.33309600E-02  +2.34985600E-02  +6.73345000E-03  -2.94731900E-02
   +2.90160000E-03  -3.38818800E-02  -2.02144780E-01  +1.35079080E-01  -3.23172200E-02
   +4.95773260E-01  +2.79000000E-05  -2.13180000E-04  +1.21620000E-04  -3.22750000E-04
   +2.72430000E-04  +6.90400000E-05  +2.67480000E-04  -3.98250000E-04  +1.28760000E-04
   +1.87390000E-04  +4.37100000E-04  +1.00320000E-04  -3.15740000E-04  +4.58910000E-04
   +1.00430000E-04  +2.08650000E-04  -3.56460000E-04  +3.14080000E-04  +7.74200000E-05
   +1.76040000E-04  -2.56910000E-04  +1.28145000E-03  +4.08105000E-03  -4.28500000E-05
   +4.33880000E-04  +3.25380000E-04  +2.37860000E-04  +2.89950000E-04  -1.88930000E-04
   +5.54400000E-05  -6.34087300E-02  +2.03433000E-02  -4.99931900E-02  +2.48946000E-02
   -6.08773000E-02  -1.48154700E-02  +3.53187800E-02  +3.83706500E-02  +5.37457700E-02
   +7.93442500E-02  -2.08192820E-01  -2.13752700E-02  -1.43012290E-01  +5.83493240E-01
   +2.06600000E-05  +1.46830000E-04  -1.04800000E-04  -1.53450000E-04  -1.44500000E-04
   +1.41100000E-04  +9.63400000E-05  -1.28760000E-04  +1.75840000E-04  +1.12890000E-04
   +2.21580000E-04  +2.84680000E-04  +3.27700000E-04  +7.43960000E-04  -1.65400000E-05
   +3.01270000E-04  -3.46120000E-04  +2.86050000E-04  +9.93900000E-05  +4.03800000E-05
   -1.43590000E-04  -5.64713000E-03  +3.63700000E-04  +8.24900000E-04  +2.57100000E-04
   -1.12307000E-03  -5.68300000E-04  -5.66800000E-05  +7.04700000E-04  +7.73120000E-04
   -2.65094700E-02  -1.63093800E-02  -2.79713700E-02  +7.94922000E-03  -1.69132500E-02
   -7.45289000E-03  -1.16269900E-02  +2.32013900E-02  +1.36397200E-02  -7.11701200E-02
   +3.19206100E-02  -1.14678040E-01  +2.51982250E-01  +1.78492290E-01  +4.87670030E-01
   -5.47100000E-05  -1.23030000E-04  +1.00240000E-04  +1.74390000E-04  +1.76180000E-04
   -1.81240000E-04  -1.12010000E-04  +1.87390000E-04  -1.12890000E-04  -3.42800000E-05
   -6.67590000E-04  -8.06080000E-04  +1.42670000E-04  -5.58060000E-04  -3.19130000E-04
   -6.66940000E-04  +4.68690000E-04  -1.48430000E-04  -2.47410000E-04  -1.59000000E-06
   -5.21700000E-05  +4.56043000E-03  -5.51596000E-03  -1.18097000E-03  -4.01600000E-05
   +1.34016000E-03  +5.43890000E-04  -1.97820000E-04  +8.46280000E-04  +1.16051000E-03
   -1.95533700E-01  -1.92264300E-02  -1.31008200E-01  -3.59239200E-02  +4.08543900E-02
   -1.42035100E-02  -1.64040300E-02  -1.73917000E-02  -2.43913500E-02  +3.24355300E-02
   +6.22053000E-03  +3.26279800E-02  -1.03680150E-01  +3.81098100E-02  -1.55428900E-02
   +4.93902360E-01  -1.63700000E-05  -1.52710000E-04  +1.70170000E-04  +4.26290000E-04
   -5.51200000E-05  -2.78660000E-04  -2.01380000E-04  +4.37100000E-04  -2.21580000E-04
   -6.67590000E-04  -1.30433000E-03  -2.25700000E-04  -1.52161000E-03  -9.90860000E-04
   -2.64454000E-03  -6.59520000E-04  +7.34070000E-04  -4.34090000E-04  -5.16800000E-05
   -2.76110000E-04  +5.97600000E-04  -1.94133600E-02  -3.70949000E-03  -2.05603100E-02
   +1.29518000E-03  -4.88263000E-03  -3.04943000E-03  -1.67132000E-03  -5.19840000E-04
   -4.54110000E-04  +2.77093600E-02  -1.18339200E-01  -7.68824000E-03  +5.25661000E-03
   +3.89095300E-02  +2.48519400E-02  -1.54198900E-02  -2.11188000E-02  -2.68861600E-02
   +4.58994200E-02  -4.82780200E-02  +8.64372000E-03  -8.45047000E-03  -2.67395780E-01
   -1.50439840E-01  -1.77230330E-01  +6.26100400E-01  -4.97500000E-05  -9.54500000E-05
   +9.28100000E-05  -1.54320000E-04  +1.78360000E-04  -6.02600000E-05  -1.30430000E-04
   -1.00320000E-04  +2.84680000E-04  +8.06080000E-04  +2.25700000E-04  -5.04520000E-04
   -8.05200000E-04  +5.57760000E-04  -5.73700000E-04  -1.48710000E-04  +3.23100000E-05
   +5.89100000E-05  -1.17730000E-04  +1.76950000E-04  -1.47980000E-04  -1.13788600E-02
   -8.65908000E-03  -1.51438700E-02  +8.68480000E-04  -2.43793000E-03  -3.90260000E-04
   -1.18273000E-03  -9.15380000E-04  -4.29540000E-04  -9.97697900E-02  -5.08167500E-02
   -2.01163180E-01  -3.84654100E-02  +5.86340900E-02  +1.18621400E-02  -2.27767600E-02
   -2.87617300E-02  -4.41789000E-02  +5.94807700E-02  -2.88166900E-02  +3.93389400E-02
   -4.74643300E-02  -1.06167960E-01  -1.77195110E-01  +2.13510590E-01  +1.57158110E-01
   +4.56030360E-01  +5.02000000E-06  -3.46100000E-05  +2.73900000E-05  +3.82500000E-05
   +8.68000000E-06  -4.64000000E-05  -4.89000000E-06  +2.79000000E-05  -2.06600000E-05
   -5.47100000E-05  -1.63700000E-05  +4.97500000E-05  +1.22380000E-04  -5.34400000E-05
   -1.08350000E-04  -4.64000000E-06  +2.04400000E-05  +2.19900000E-05  +4.72000000E-06
   -5.26000000E-05  +5.28800000E-05  +8.85400000E-05  -2.57690000E-04  +4.02730000E-04
   -3.61500000E-05  -8.93000000E-06  -2.35400000E-05  -1.02820000E-04  -1.17430000E-04
   -9.40200000E-05  +4.22018000E-03  -2.46982000E-03  +3.54990000E-03  -4.05814000E-03
   +8.47305000E-03  -2.94182000E-03  +4.76652000E-03  -3.35668700E-02  -2.58153400E-02
   -8.56101000E-02  +5.93246000E-03  -3.53997600E-02  +6.02924000E-03  +3.03018600E-02
   +1.76004800E-02  -2.94065000E-03  +2.82720000E-04  -9.40515000E-03  +3.84056960E-01
   -3.46100000E-05  -1.06474000E-03  +8.01680000E-04  +1.70370000E-04  +8.22880000E-04
   -6.93390000E-04  +2.25100000E-04  -2.13180000E-04  -1.46830000E-04  -1.23030000E-04
   -1.52710000E-04  +9.54500000E-05  -2.49200000E-05  -1.17400000E-05  -9.80730000E-04
   -3.11460000E-04  +1.53600000E-05  +1.61650000E-04  -1.38450000E-04  -2.38340000E-04
   +3.91260000E-04  +5.70280000E-04  +1.59050000E-03  +7.87830000E-04  +3.36480000E-04
   -5.52300000E-04  +1.23300000E-05  -5.07760000E-04  -1.25506000E-03  -5.36540000E-04
   -3.05481000E-03  -2.12113000E-03  -2.46769000E-03  +3.87179000E-03  +6.42140000E-04
   +6.09180000E-04  -7.43978000E-03  -6.95701000E-03  -1.70023300E-02  +4.04916200E-02
   -2.38209330E-01  -9.62740300E-02  +3.81853000E-03  -4.16126900E-02  -3.17844400E-02
   +5.94944000E-03  +3.15165000E-03  +2.82480000E-03  -5.76305100E-02  +3.23798970E-01
   -2.73900000E-05  -8.01680000E-04  +6.33300000E-04  +1.69500000E-04  +5.87470000E-04
   -5.51000000E-04  +1.62310000E-04  -1.21620000E-04  -1.04800000E-04  -1.00240000E-04
   -1.70170000E-04  +9.28100000E-05  -7.28100000E-05  -5.11700000E-05  -8.51610000E-04
   -2.60630000E-04  +4.81200000E-05  +8.34300000E-05  -1.14800000E-04  -1.92390000E-04
   +3.61970000E-04  +1.06837000E-03  +1.17359000E-03  +2.94200000E-04  +2.25780000E-04
   -3.92210000E-04  -1.50200000E-05  -3.88260000E-04  -9.95140000E-04  -4.79300000E-04
   +3.14167000E-03  -2.76922000E-03  +4.33820000E-04  -5.95958000E-03  +4.78000000E-03
   +2.83743000E-03  -7.76048000E-03  -4.15202600E-02  -2.83305500E-02  -1.15050800E-02
   -1.28599690E-01  -1.42969680E-01  -8.67060000E-04  -6.43574000E-03  +4.24359000E-03
   -5.52179000E-03  -2.66189000E-03  +2.15860000E-04  +2.94787660E-01  +1.50628510E-01
   +4.06254410E-01  -3.06685640E-01  +1.65272200E-02  +2.72360150E-01  -2.18799000E-03
   +4.80370000E-04  -8.41490000E-04  +2.30999000E-03  +2.22616000E-03  -4.56052000E-03
   -8.88100000E-04  +1.99900000E-05  +2.20920000E-04  +2.25720000E-04  +1.31680000E-04
   -9.84900000E-05  +3.94380000E-04  +5.16060000E-04  +8.99980000E-04  +2.14088000E-03
   +4.80240000E-04  -4.11420000E-04  -1.50650000E-04  -1.17950000E-04  +4.09200000E-05
   +5.30300000E-05  +1.22370000E-04  -7.29200000E-05  -1.64300000E-05  +2.19300000E-05
   +4.37000000E-06  -1.26400000E-05  +6.37000000E-06  -5.27700000E-05  +7.92000000E-06
   -1.22300000E-05  +7.77000000E-06  -3.02000000E-06  +2.15800000E-05  +2.48500000E-05
   -6.73000000E-06  -3.57200000E-05  -3.17900000E-05  -7.03000000E-06  +6.71000000E-06
   -1.42000000E-05  +3.17300000E-05  +2.54000000E-06  +1.71600000E-05  -4.99000000E-06
   +4.62900000E-05  +3.05200000E-05  +3.05310490E-01  +5.16627200E-02  -3.81689200E-02
   -2.43454100E-02  -3.20162700E-02  -3.33998000E-03  +3.03617600E-02  -2.29324000E-03
   +1.53817000E-03  +5.24680000E-04  -2.19990000E-04  -6.42440000E-04  +1.93060000E-04
   +5.84690000E-04  -5.52300000E-05  -4.23630000E-04  -7.75010000E-04  +1.49254000E-03
   +9.26830000E-04  +1.55664000E-03  -5.21266000E-03  +3.55561000E-03  +1.00360000E-04
   -1.79550000E-04  -3.08100000E-05  -1.23400000E-05  +4.43400000E-05  +5.12000000E-06
   -2.63100000E-05  +7.59700000E-05  -2.16700000E-05  +4.00000000E-06  -1.42400000E-05
   -3.68300000E-05  +3.33800000E-05  -1.29800000E-05  +3.00000000E-06  +2.19700000E-05
   +1.85100000E-05  +2.28500000E-05  -4.05000000E-06  -1.28820000E-04  -7.97400000E-05
   -2.53300000E-05  +3.59200000E-05  -3.02900000E-05  +2.39000000E-05  -1.95000000E-06
   -1.72000000E-05  +6.75000000E-06  +1.38800000E-04  +8.60400000E-05  -2.02069800E-02
   +4.55550200E-02  +2.48144020E-01  +8.46775000E-03  -2.41318580E-01  +2.15922300E-02
   +8.20000000E-06  -2.29700900E-02  -1.45865000E-03  -3.71499000E-03  +3.06268000E-03
   +3.77390000E-04  -3.36600000E-05  -9.83670000E-04  -4.95260000E-04  -7.54000000E-06
   +4.91230000E-04  +1.78983000E-03  -3.09190000E-04  +2.41720000E-04  -1.17160000E-03
   +4.55778000E-03  +2.14500000E-05  +1.00600000E-05  +1.89610000E-04  -8.44600000E-05
   -3.47200000E-05  -8.95300000E-05  +3.34800000E-05  +2.74700000E-05  -7.16400000E-05
   -1.51000000E-06  -2.40200000E-05  -2.15000000E-06  +1.23540000E-04  -4.44000000E-05
   +3.40000000E-06  -1.39600000E-05  -2.62700000E-05  -2.62000000E-05  -5.74200000E-05
   +2.48700000E-05  +1.28760000E-04  +1.08450000E-04  +4.01400000E-05  -3.25700000E-05
   +1.16200000E-05  -4.64000000E-06  -1.64200000E-05  -2.85000000E-06  -4.64000000E-06
   -1.61700000E-04  -1.33700000E-04  -2.67887920E-01  -9.69814000E-03  +2.61357750E-01
   +2.63860000E-04  -1.84858000E-03  -2.64341000E-03  -1.00432800E-02  -5.95400000E-03
   +1.75170700E-02  -1.83766620E-01  -5.87016000E-03  +1.47139870E-01  +2.66127000E-03
   +8.77760000E-04  -6.53770000E-04  +4.19742000E-03  +1.64883000E-03  +2.02715000E-03
   -1.69430000E-04  +4.63930000E-04  -9.88900000E-04  -8.99400000E-05  +5.15421000E-03
   +1.64012000E-03  +7.53100000E-05  +3.65570000E-04  +1.16490000E-04  -5.66600000E-05
   -4.04100000E-05  -4.78000000E-06  +2.85400000E-05  -5.89200000E-05  -4.25700000E-05
   -7.20000000E-07  -6.43500000E-05  +2.22000000E-05  -5.55900000E-05  +2.23100000E-05
   +8.59000000E-06  -2.51300000E-05  -1.79300000E-05  -4.37900000E-05  +3.47600000E-05
   +4.33200000E-05  +5.73200000E-05  +2.62400000E-05  -3.00000000E-08  -2.03700000E-05
   +1.01700000E-05  -2.73400000E-05  +3.27900000E-05  -5.05000000E-06  -7.37500000E-05
   -7.10100000E-05  -4.09220000E-04  +1.85126000E-03  -3.31670000E-04  +1.89597350E-01
   -1.29401000E-03  +1.81961000E-03  -2.65583000E-03  +1.55543600E-02  +5.31283000E-03
   -1.57058100E-02  -5.58128000E-03  -5.65145800E-02  +2.11446000E-02  -1.95003800E-02
   +2.60261000E-03  +1.85678100E-02  +2.21741000E-03  -2.40966000E-03  +4.77118000E-03
   +2.35270000E-04  -1.59373000E-03  +2.38580000E-04  +4.69232000E-03  -2.08075000E-03
   +7.24920000E-04  -9.27010000E-04  +5.58930000E-04  +6.99500000E-04  -1.06440000E-04
   +1.70000000E-06  -6.98300000E-05  +1.24020000E-04  -3.77570000E-04  +1.35440000E-04
   -2.65000000E-06  +1.29950000E-04  +5.99400000E-05  -1.93200000E-05  +1.50000000E-06
   -1.97600000E-05  -1.03000000E-06  -2.35700000E-05  -4.83900000E-05  +1.27100000E-05
   +4.13000000E-05  +4.64500000E-05  +2.54900000E-05  -1.40700000E-05  -3.17800000E-05
   +1.29400000E-05  -9.55000000E-06  -3.81000000E-06  +4.76000000E-06  -7.23800000E-05
   -7.27400000E-05  -1.54140000E-04  -7.56480000E-04  +1.03613000E-03  +5.61277000E-03
   +5.33746300E-02  -2.99887000E-03  -2.24513000E-03  +5.53020000E-04  +2.49617000E-03
   +4.96095000E-03  -1.75595000E-03  +1.47195210E-01  +2.12859000E-02  -1.88104980E-01
   +1.35076900E-02  -7.89990000E-04  -9.71109000E-03  +1.50168000E-03  +5.01836000E-03
   +2.54294000E-03  -7.73320000E-04  -4.33300000E-05  -1.24880000E-04  +1.96898000E-03
   +3.30660000E-04  +3.30207000E-03  +8.40300000E-04  -2.33610000E-04  -1.16770000E-04
   +2.58100000E-05  +6.62100000E-05  -1.29500000E-05  -1.24060000E-04  +2.98980000E-04
   -1.88500000E-04  -8.11000000E-06  -1.81050000E-04  -1.40270000E-04  +4.38000000E-06
   +1.41000000E-05  +4.08200000E-05  -5.31000000E-06  +1.82200000E-05  +2.43000000E-05
   +6.51000000E-06  -7.92100000E-05  -4.94500000E-05  -1.74100000E-05  +3.52300000E-05
   -9.73000000E-06  +6.40000000E-06  -2.06800000E-05  +3.79200000E-05  -3.42000000E-06
   +9.40400000E-05  +6.81900000E-05  +1.04391000E-03  -8.71000000E-04  +1.70000000E-04
   -1.62206160E-01  -2.60943900E-02  +1.95543230E-01  +2.00300000E-05  +1.16890000E-04
   -1.28220000E-04  +4.33214000E-03  +8.79540000E-04  +3.03539000E-03  +4.02990000E-03
   -1.73057000E-03  +1.13939000E-03  -1.76861650E-01  +1.40316880E-01  +3.79966900E-02
   -9.82444000E-03  +1.69306500E-02  +2.28788000E-03  -1.15680000E-04  +5.38990000E-04
   +6.03631000E-03  -2.88020000E-04  -1.11298000E-03  -1.26690000E-04  -1.27488000E-03
   +1.64450000E-04  -1.89009000E-03  -5.81900000E-05  +1.19100000E-05  -3.79000000E-05
   -1.66900000E-05  -2.32940000E-04  -2.18700000E-05  +1.82110000E-04  -2.42090000E-04
   +3.39880000E-04  +3.14730000E-04  -4.20940000E-04  -2.34940000E-04  +1.12840000E-04
   -4.30000000E-07  +1.47340000E-04  -5.92400000E-05  -2.99270000E-04  -1.63940000E-04
   -3.20500000E-05  -3.50000000E-07  -1.39960000E-04  -1.52270000E-04  +8.66100000E-05
   -3.68620000E-04  +2.03700000E-05  +3.23120000E-04  +2.24370000E-04  -3.11600000E-05
   -3.75800000E-05  +1.89300000E-05  -1.23380000E-03  -1.32863000E-03  -2.34096000E-03
   +1.81717740E-01  +8.78100000E-04  -1.39238000E-03  +2.66200000E-05  +4.89880000E-04
   -6.49900000E-04  +5.25607000E-03  +1.82721100E-02  -1.40168200E-02  -5.18459000E-03
   +1.41146730E-01  -2.02151420E-01  -2.62178900E-02  -1.71842000E-03  +5.54326000E-03
   +6.23360000E-04  +6.02470000E-04  +2.18044000E-03  +2.11299000E-03  -9.02900000E-04
   -2.39470000E-04  +2.01950000E-04  -9.71660000E-04  -8.61810000E-04  -4.18280000E-04
   +1.30920000E-04  -3.19100000E-05  +1.32900000E-04  -6.69700000E-05  -1.48700000E-05
   -1.36570000E-04  -6.04490000E-04  -7.06890000E-04  +6.81110000E-04  -5.57000000E-05
   -5.97800000E-05  +7.07500000E-05  +1.18300000E-05  -1.39610000E-04  -1.28580000E-04
   +1.53580000E-04  -2.49680000E-04  -5.77900000E-05  -5.67000000E-05  +2.75340000E-04
   +7.26600000E-05  -2.88940000E-04  -3.21750000E-04  +1.13660000E-04  -9.13000000E-06
   +1.69650000E-04  +1.21430000E-04  +1.31880000E-04  +1.16530000E-04  -2.10980000E-04
   -1.58412000E-03  -1.04280000E-04  -1.35394000E-03  -1.54840910E-01  +2.12230240E-01
   -7.38620000E-04  +9.01690000E-04  +5.76000000E-06  +3.40961000E-03  +5.01397000E-03
   +1.25682000E-03  -1.28798000E-02  +1.46034700E-02  +6.44738000E-03  +3.89251800E-02
   -2.67279900E-02  -5.91492700E-02  +1.46295000E-02  -1.74120300E-02  +2.05960000E-03
   +5.55152000E-03  +2.66699000E-03  -6.12330000E-04  -2.88920000E-04  +2.21150000E-04
   -1.04344000E-03  -1.18030000E-03  -1.54816000E-03  -8.94170000E-04  +4.21470000E-04
   +1.67540000E-04  -5.94310000E-04  -1.08720000E-04  -1.26630000E-04  +1.83200000E-05
   +1.20520000E-04  +4.54660000E-04  -5.13000000E-05  +3.60800000E-05  -9.80000000E-07
   -5.78100000E-05  -8.67000000E-06  +1.16200000E-04  +9.97000000E-05  -1.71120000E-04
   +2.02800000E-04  -2.38800000E-05  +1.13660000E-04  -2.73660000E-04  -2.46970000E-04
   +2.78980000E-04  +2.31010000E-04  +2.95700000E-04  -6.90000000E-07  -1.75440000E-04
   -1.42310000E-04  -9.36300000E-05  -7.70200000E-05  +1.07590000E-04  -2.04150000E-03
   -1.75885000E-03  -1.36313000E-03  -4.52498500E-02  +2.43672400E-02  +5.47228500E-02
   -2.99400000E-05  -1.54090000E-04  +1.89180000E-04  +4.23087000E-03  +2.22584000E-03
   +1.93326000E-03  -1.59230000E-04  +2.22050000E-04  -1.01933000E-03  +2.69060000E-04
   +5.33276000E-03  +2.37562000E-03  -9.87750000E-03  -3.02422000E-03  +1.54525400E-02
   -1.93745330E-01  -6.24243000E-03  +1.48869450E-01  +3.11293000E-03  +1.51184000E-03
   -2.62050000E-04  -1.65324000E-03  -2.20329000E-03  -5.18450000E-04  -2.19000000E-06
   +6.33630000E-04  -1.97220000E-04  +3.97840000E-04  -3.90300000E-04  +8.31380000E-04
   +1.71360000E-04  -2.10660000E-04  +1.09160000E-04  -2.19200000E-05  -4.73900000E-05
   -6.91700000E-05  -2.90000000E-07  -3.12000000E-06  -2.26200000E-05  -5.20000000E-06
   +1.81300000E-05  +3.06200000E-05  +6.68000000E-06  -1.34200000E-05  -2.24200000E-05
   +8.21000000E-05  -1.28900000E-05  +3.48000000E-06  -3.81000000E-06  -3.92700000E-05
   -4.11100000E-05  -3.84700000E-05  -1.97300000E-05  -1.25170000E-04  -3.00500000E-04
   -2.58640000E-04  -2.19660000E-04  -6.82470000E-04  -2.03670000E-04  +7.89520000E-04
   +1.99008850E-01  -1.03313000E-03  +8.19000000E-06  +9.85750000E-04  +2.37077000E-03
   -2.03587000E-03  +4.67218000E-03  +9.16800000E-05  -1.32364000E-03  +7.79900000E-05
   +5.27693000E-03  -2.13030000E-03  +1.04423000E-03  +1.50923800E-02  +7.37195000E-03
   -1.61783600E-02  -6.77183000E-03  -5.69674400E-02  +1.83621800E-02  -1.88956000E-02
   +1.90436000E-03  +1.92163600E-02  -1.21972000E-03  +1.64300000E-05  -1.41997000E-03
   -8.68200000E-05  +3.25070000E-04  +6.55000000E-06  +9.07390000E-04  -2.51908000E-03
   +1.24126000E-03  -1.60710000E-04  -1.94880000E-04  +6.84700000E-05  -3.23400000E-05
   -1.65700000E-05  +2.28000000E-05  +2.32600000E-05  +4.20400000E-05  +2.50800000E-05
   -3.13000000E-06  -5.80600000E-05  -6.07500000E-05  -5.96500000E-05  +8.44000000E-06
   -8.00000000E-07  +8.49900000E-05  -4.04700000E-05  +1.07720000E-04  -3.73000000E-06
   +8.99500000E-05  +6.62800000E-05  -9.63900000E-05  -3.41040000E-04  +1.93210000E-04
   -2.30770000E-04  -8.41900000E-05  -2.27500000E-04  +8.93630000E-04  +2.26290000E-04
   -9.43900000E-04  +5.52050000E-03  +5.83579200E-02  +7.90880000E-04  +1.75630000E-04
   -7.93350000E-04  +1.89669000E-03  +4.76064000E-03  +2.91451000E-03  -9.53350000E-04
   -1.04800000E-05  -1.85700000E-04  +2.59477000E-03  +9.51630000E-04  +3.62688000E-03
   +3.17748000E-03  +5.24010000E-04  +1.18327000E-03  +1.48790450E-01  +1.81679600E-02
   -1.90877040E-01  +1.37348500E-02  -4.44000000E-05  -8.98094000E-03  -1.21531000E-03
   -6.47390000E-04  -2.30442000E-03  -7.98700000E-05  +4.22290000E-04  -2.16240000E-04
   -3.41480000E-04  +2.63873000E-03  -6.36380000E-04  +2.22040000E-04  -2.75410000E-04
   +3.71430000E-04  -8.76200000E-05  -8.04700000E-05  -9.00000000E-05  -1.22000000E-06
   -1.32800000E-05  -3.49800000E-05  +2.64800000E-05  +2.81100000E-05  +4.83100000E-05
   -5.44100000E-05  +8.05000000E-06  -1.66800000E-05  +1.31850000E-04  -1.18950000E-04
   +7.71900000E-05  -1.73700000E-05  -4.46600000E-05  -4.60400000E-05  -7.22600000E-05
   +1.23960000E-04  -1.99010000E-04  -2.47670000E-04  -1.96650000E-04  -3.61130000E-04
   +1.70500000E-05  +1.28400000E-04  -9.20300000E-05  -1.64901640E-01  -2.68689200E-02
   +1.99514130E-01  -1.07460000E-04  -1.26151000E-03  -2.41149000E-03  -9.76117000E-03
   +1.92674000E-02  +8.41420000E-04  -1.84090000E-04  +1.49490000E-04  +5.40064000E-03
   -3.53840000E-04  -1.20383000E-03  +1.29420000E-04  +3.94580000E-03  +6.90390000E-04
   +2.49762000E-03  +4.19656000E-03  -2.60399000E-03  +1.27490000E-04  -1.81237700E-01
   +1.45364880E-01  +3.65628300E-02  +2.45580000E-04  -9.25300000E-05  +1.67490000E-04
   -4.92000000E-06  -8.13000000E-06  +6.18600000E-05  -4.72300000E-05  +9.25000000E-06
   -4.79200000E-05  -6.12000000E-06  +1.14710000E-04  -6.58800000E-05  +2.90100000E-05
   -7.04000000E-06  -9.06000000E-06  +5.68000000E-06  +1.61900000E-05  +2.65200000E-05
   -1.55800000E-05  -2.71700000E-05  -3.18000000E-05  -1.10800000E-05  -5.67000000E-06
   -1.17900000E-05  +1.71800000E-05  +4.14000000E-06  +1.19000000E-06  +2.06000000E-06
   +4.09700000E-05  +2.70200000E-05  +3.38100000E-05  -1.87120000E-04  -4.30000000E-04
   -6.83140000E-04  +7.48220000E-04  +8.29700000E-05  -2.87280000E-04  -1.33220000E-04
   -3.06200000E-04  -1.11798000E-03  -1.21517000E-03  -2.28989000E-03  +1.85367800E-01
   -1.02522000E-03  +3.79100000E-05  -1.55136000E-03  -2.10591000E-03  +4.59690000E-03
   +2.47779000E-03  +5.78940000E-04  +1.93342000E-03  +2.05595000E-03  -8.96090000E-04
   -2.00850000E-04  +2.15000000E-04  +5.56040000E-04  -1.15567000E-03  +5.27617000E-03
   +1.73307300E-02  -1.31455400E-02  -5.52194000E-03  +1.46467840E-01  -2.03503730E-01
   -2.11482800E-02  +8.37010000E-04  -1.57830000E-04  -5.20490000E-04  -8.84400000E-05
   -2.11820000E-04  +8.59300000E-05  +4.98700000E-05  -1.88000000E-05  -9.73700000E-05
   +5.04200000E-05  +1.64000000E-06  +2.36770000E-04  -3.08400000E-05  -5.58600000E-05
   -7.61000000E-05  +5.97000000E-06  -9.46000000E-06  -1.85700000E-05  -8.80000000E-07
   +6.31500000E-05  +4.14200000E-05  +1.06100000E-05  -3.47400000E-05  -1.29600000E-05
   +3.03000000E-05  -2.39300000E-05  +2.25000000E-06  -7.74000000E-06  -7.78400000E-05
   -6.02000000E-05  -1.20020000E-04  -9.59300000E-05  -2.15110000E-04  -2.51350000E-04
   +2.41490000E-04  +3.18000000E-05  -1.31200000E-04  -1.68480000E-04  -2.52010000E-04
   -1.62299000E-03  -1.84680000E-04  -1.42342000E-03  -1.59666200E-01  +2.12153420E-01
   -2.59189000E-03  -1.35631000E-03  -2.50680000E-04  +1.56679400E-02  -1.75208200E-02
   +2.73102000E-03  +5.09538000E-03  +2.42574000E-03  -7.89510000E-04  -6.14500000E-05
   +4.18430000E-04  -1.31405000E-03  +2.74473000E-03  +4.87307000E-03  +1.07631000E-03
   -1.37266100E-02  +1.32715000E-02  +6.12895000E-03  +3.57278300E-02  -2.00910700E-02
   -5.47450800E-02  -3.87700000E-04  +4.76870000E-04  +5.14430000E-04  +5.11500000E-05
   +5.97000000E-05  +4.04100000E-05  -6.87100000E-05  -6.50200000E-05  +4.40400000E-05
   -4.00700000E-05  +2.11430000E-04  -2.40070000E-04  +3.42400000E-05  +1.73900000E-05
   +2.06400000E-05  -1.07100000E-05  +2.20200000E-05  +4.48000000E-05  -2.10500000E-05
   -1.82300000E-05  -3.35100000E-05  -8.46000000E-06  -1.03300000E-05  +1.35000000E-06
   +2.59100000E-05  +1.02500000E-05  +3.18000000E-06  +3.00000000E-06  +4.02800000E-05
   +2.77300000E-05  -4.76600000E-04  -1.52020000E-04  -1.36100000E-05  +7.50360000E-04
   -8.88900000E-04  -1.56140000E-04  -3.26050000E-04  -2.16040000E-04  -2.44080000E-04
   -1.99786000E-03  -1.81315000E-03  -1.34220000E-03  -4.03953000E-02  +2.03061000E-02
   +4.85179700E-02  +6.71000000E-06  -1.77010000E-04  +1.25170000E-04  -2.21940000E-04
   +1.75190000E-04  +3.39700000E-05  +1.09690000E-04  -4.04960000E-04  +8.10000000E-07
   -1.06730000E-04  +4.10920000E-04  -4.29000000E-05  +6.14240000E-04  -8.89890000E-04
   +3.56990000E-04  +2.01780000E-04  -9.77600000E-05  +1.46190000E-04  -2.67000000E-05
   +1.73930000E-04  -1.21420000E-04  -3.78840000E-04  -2.27836100E-02  -1.42804900E-02
   -4.73025900E-02  +1.38532800E-02  +9.61780000E-03  +1.28178000E-03  -1.13359000E-03
   -8.52350000E-04  -4.34476000E-03  +1.00672000E-03  -2.42630000E-03  -5.43150000E-04
   +9.13370000E-04  -3.04010000E-04  +2.46800000E-04  -2.08710000E-04  -1.37200000E-05
   +1.70000000E-06  +9.64700000E-05  +1.36450000E-04  -2.56420000E-04  +1.29450000E-04
   -2.35350000E-04  +3.70130000E-04  -1.47244000E-03  -8.95540000E-04  +3.37200000E-05
   -1.21630000E-04  -4.68100000E-05  +1.68900000E-05  +1.55200000E-05  -1.23300000E-05
   +1.32000000E-06  +1.32000000E-05  +1.77300000E-05  +6.62800000E-05  +2.92500000E-05
   +8.90000000E-07  -9.81100000E-05  +2.23700000E-05  +6.36000000E-06  +9.37000000E-06
   -2.15000000E-06  -8.68000000E-06  +5.22616100E-02  +2.48000000E-05  +4.28800000E-05
   -9.40000000E-06  -1.54310000E-04  +1.85500000E-05  +7.06800000E-05  -1.34400000E-05
   -2.12940000E-04  -3.73000000E-06  +2.04100000E-04  +3.27450000E-04  -2.47880000E-04
   +4.75200000E-05  +8.07100000E-04  +1.38088000E-03  +1.29280000E-04  +2.23550000E-04
   -1.49530000E-04  -5.25900000E-05  +1.05130000E-04  -9.81500000E-05  +9.19710000E-04
   -2.50200000E-03  -2.84950000E-04  +1.21993200E-02  -2.44865940E-01  -1.19674600E-01
   +3.98310000E-04  -1.35580000E-04  +1.32540000E-04  -9.92400000E-05  +7.13960000E-04
   +5.94600000E-05  +4.41170000E-04  -1.34820000E-04  +1.44350000E-04  -2.41370000E-04
   +1.61190000E-04  -1.56290000E-04  -2.16100000E-05  +1.16010000E-04  +9.18800000E-05
   -9.94100000E-05  -8.37500000E-05  -9.23400000E-05  +2.72360000E-04  +1.55300000E-05
   +1.04100000E-04  -4.32200000E-05  -1.86730000E-04  -1.72920000E-04  -4.05000000E-06
   -1.00200000E-05  -2.23000000E-06  -1.02000000E-06  -2.49000000E-06  -1.24000000E-05
   +1.57300000E-05  +2.63600000E-05  +6.51800000E-05  -1.67800000E-05  +2.33700000E-05
   -2.29500000E-05  +3.52000000E-06  +2.34000000E-05  -1.51000000E-05  -1.42010300E-02
   +2.62967220E-01  -2.48000000E-06  -1.98590000E-04  +1.77820000E-04  -1.23450000E-04
   +2.23010000E-04  -1.08310000E-04  +5.58300000E-05  -9.07800000E-05  +3.64300000E-05
   +5.74320000E-04  +1.33000000E-04  -3.24730000E-04  +2.30240000E-04  -1.21235000E-03
   +5.73610000E-04  -3.14500000E-05  +3.12650000E-04  +1.37610000E-04  -7.02800000E-05
   +1.72500000E-04  -4.92600000E-05  +8.51030000E-04  -1.66421100E-02  -1.23312100E-02
   +8.56018000E-03  -1.17866340E-01  -1.17761400E-01  +1.15569000E-03  +4.29190000E-04
   +2.83920000E-04  -3.76015000E-03  +9.36290000E-04  -1.43077000E-03  -5.24440000E-04
   +4.85040000E-04  +8.51700000E-05  +5.63800000E-05  -8.97200000E-05  +1.46890000E-04
   -9.93900000E-05  +2.94390000E-04  +9.22000000E-05  -1.31390000E-04  -5.73600000E-05
   -3.42420000E-04  +2.46140000E-04  -1.23580000E-03  -1.72300000E-04  +2.04800000E-05
   -2.65760000E-04  -1.72370000E-04  +7.79000000E-06  +7.65000000E-06  -3.81500000E-05
   -1.50400000E-05  -1.43900000E-05  -5.79000000E-06  -1.45410000E-04  -3.01200000E-05
   +1.17990000E-04  -6.03500000E-05  -3.40200000E-05  -1.75500000E-05  +1.00000000E-08
   -4.56000000E-06  -1.06800000E-05  -5.71022000E-03  +1.30202860E-01  +1.27388900E-01
   +1.28000000E-06  +4.57820000E-04  -3.79670000E-04  +1.69800000E-04  -4.06550000E-04
   +7.50600000E-05  +4.59900000E-05  +6.17500000E-04  +6.88900000E-05  -6.19500000E-05
   +4.65000000E-05  +3.58150000E-04  -3.81742000E-03  -1.34302000E-03  -2.37716000E-03
   +1.24960000E-04  +5.40210000E-04  -5.89790000E-04  +2.64970000E-04  +1.55060000E-04
   +2.22740000E-04  -1.92242000E-03  +2.07326900E-02  -1.63609000E-02  -4.83912200E-02
   +5.46323000E-03  -3.83978000E-03  +1.24106000E-03  +1.16160000E-03  -8.04530000E-04
   +5.52990000E-04  +2.21040000E-04  +6.03310000E-04  +4.49300000E-04  -3.15820000E-04
   +3.79120000E-04  -1.27840000E-04  -1.09970000E-04  -1.51520000E-04  +1.67270000E-04
   -1.19340000E-04  +3.67200000E-05  -3.10800000E-05  +1.33840000E-04  +7.39000000E-05
   -2.35950000E-04  -3.40400000E-05  +1.37500000E-05  -2.79700000E-05  +4.68500000E-05
   +1.85200000E-05  -4.77200000E-05  -7.21000000E-06  +3.23600000E-05  +1.98100000E-05
   +3.82900000E-05  -3.03500000E-05  -4.32000000E-05  -2.52690000E-04  -3.74630000E-04
   -1.58070000E-04  -3.54000000E-05  -1.06890000E-04  -1.12800000E-05  +6.48500000E-05
   -3.19900000E-05  -1.02545000E-03  +1.54391000E-03  -1.34904000E-03  +5.10458200E-02
   -2.00000000E-06  -2.98010000E-04  +2.21050000E-04  -7.17700000E-05  +2.96320000E-04
   -1.63050000E-04  +7.78400000E-05  -2.16650000E-04  +1.99000000E-06  +4.45300000E-04
   +2.79470000E-04  -3.26780000E-04  +2.64260000E-04  +4.89620000E-04  +5.54800000E-04
   -1.71960000E-04  +5.63930000E-04  +1.55210000E-04  -5.97800000E-05  -4.50000000E-07
   +5.91100000E-05  -3.09620000E-04  +1.55121000E-03  -2.24475000E-03  +5.69904000E-03
   -2.01255710E-01  +1.31073830E-01  -2.75570000E-04  +3.67700000E-04  -3.24270000E-04
   +2.77370000E-04  -3.01400000E-05  -1.59800000E-05  +6.18740000E-04  -8.72940000E-04
   -9.08070000E-04  -2.31890000E-04  +1.32770000E-04  -1.65050000E-04  +1.91500000E-05
   -1.74450000E-04  -1.02800000E-05  -3.11000000E-06  +4.20700000E-05  +1.14700000E-05
   -1.91000000E-06  +1.15700000E-04  +1.27280000E-04  -2.97000000E-05  +8.82000000E-05
   +3.31100000E-05  +1.61900000E-05  +2.54000000E-05  -4.25400000E-05  -2.01000000E-05
   -2.78600000E-05  +1.30800000E-05  -2.13400000E-05  -1.14100000E-05  +1.67200000E-05
   +5.14000000E-06  -4.99600000E-05  -6.46900000E-05  +4.36000000E-06  -1.75600000E-05
   +3.18000000E-06  +1.44720000E-04  -1.92953300E-02  +1.85269600E-02  -6.76941000E-03
   +2.19116210E-01  +7.50100000E-05  +4.99140000E-04  -3.85380000E-04  -4.72570000E-04
   -1.91170000E-04  +5.12530000E-04  -1.23300000E-05  -2.57400000E-04  +1.63900000E-04
   -2.74850000E-04  +3.53390000E-04  -1.30560000E-04  -3.73899000E-03  -4.49870000E-04
   -1.35922000E-03  +3.33240000E-04  -4.39010000E-04  -4.60770000E-04  +3.43200000E-04
   +6.39850000E-04  -3.54370000E-04  +5.62190000E-04  +1.49018800E-02  -1.23184500E-02
   -4.90154000E-03  +1.29836540E-01  -1.58499900E-01  +1.50650000E-03  +5.16100000E-05
   +5.49490000E-04  +2.65640000E-04  +7.01650000E-04  +5.70380000E-04  -9.09780000E-04
   +1.41030000E-04  -5.39310000E-04  +3.94350000E-04  -3.34640000E-04  +2.38780000E-04
   +8.45600000E-05  -4.09600000E-05  -1.87200000E-05  +4.63300000E-05  +1.70970000E-04
   +1.65230000E-04  -1.55830000E-04  -3.00450000E-04  -1.18600000E-04  +6.23400000E-05
   +9.94800000E-05  +1.41260000E-04  -3.93300000E-05  -3.22900000E-05  +4.61100000E-05
   +2.30500000E-05  +2.36900000E-05  -5.20500000E-05  +1.05430000E-04  +5.09500000E-05
   +1.91120000E-04  -1.42950000E-04  -4.72700000E-05  -3.38900000E-05  +3.47900000E-05
   +9.51500000E-05  -1.29000000E-06  +4.33950000E-04  -1.30162600E-02  +1.21096800E-02
   +7.35692000E-03  -1.42637140E-01  +1.70685810E-01  -1.73100000E-05  -5.73100000E-05
   +1.75000000E-05  +4.74700000E-04  -2.29820000E-04  -3.61600000E-04  +1.86520000E-04
   +6.05440000E-04  -3.22650000E-04  -1.07860000E-04  +1.51760000E-04  +7.01760000E-04
   +7.86160000E-04  -1.45376000E-03  +8.75830000E-04  -2.90100000E-04  +8.43250000E-04
   -9.05600000E-05  -1.11610000E-04  -4.68320000E-04  +4.08290000E-04  -2.09702100E-02
   +4.93600000E-05  +1.48564100E-02  -2.37242400E-01  -1.58415000E-03  +1.21058240E-01
   -4.01857000E-03  -8.67900000E-05  -4.81831000E-03  +9.80370000E-04  +1.02326000E-03
   +1.00306000E-03  +2.82100000E-05  +3.15500000E-04  -2.75840000E-04  +2.06980000E-04
   -2.95550000E-04  -1.69280000E-04  +1.84450000E-04  -1.07560000E-04  +1.78680000E-04
   -2.62500000E-05  +2.50620000E-04  +1.76710000E-04  -5.29000000E-05  -6.53800000E-05
   -5.35080000E-04  +1.43900000E-05  +5.70000000E-06  +1.05500000E-05  -3.51000000E-06
   +2.45500000E-05  -1.32500000E-05  -3.91000000E-06  +4.11900000E-05  -2.59000000E-06
   +1.81300000E-04  -2.19940000E-04  -5.69770000E-04  +9.34400000E-05  -1.34650000E-04
   -1.93900000E-05  -2.05700000E-05  -5.83000000E-06  -1.60600000E-05  -6.76160000E-04
   -1.66620000E-04  +6.69800000E-05  +1.99917000E-03  +6.72300000E-05  -1.66969000E-03
   +2.59205590E-01  -3.96000000E-06  +5.94400000E-05  -5.07900000E-05  -9.97500000E-05
   -1.45400000E-05  +1.29250000E-04  -3.56000000E-05  -2.64020000E-04  +4.35900000E-05
   +1.21400000E-05  -5.24500000E-05  +1.42310000E-04  +5.30200000E-04  +2.16600000E-05
   -6.05920000E-04  +9.72500000E-05  -1.91770000E-04  +7.72100000E-05  +5.98700000E-05
   +1.42430000E-04  -8.98100000E-05  -2.06510000E-03  -1.82519000E-03  +1.49819000E-03
   -1.75958000E-03  -4.71854100E-02  +1.73973000E-03  -5.26710000E-04  -3.56500000E-05
   -5.22250000E-04  -3.73920000E-04  +3.16240000E-04  +4.96050000E-04  -6.54290000E-04
   -8.37600000E-05  -4.35400000E-04  +2.47700000E-04  -1.05550000E-04  +3.94700000E-05
   +3.65200000E-05  -8.45100000E-05  -1.43400000E-05  +1.89600000E-05  +1.25150000E-04
   +9.84500000E-05  -4.05400000E-05  -7.55100000E-05  -8.09100000E-05  +3.58500000E-05
   +1.08370000E-04  +1.13140000E-04  +7.95000000E-06  -1.05800000E-05  +2.19200000E-05
   +1.91700000E-05  +2.07500000E-05  +1.36500000E-05  +9.45200000E-05  +2.25110000E-04
   +2.11250000E-04  -6.41500000E-05  +1.65500000E-05  -6.92000000E-06  -8.97000000E-06
   +1.40000000E-07  -8.14000000E-06  +2.40840900E-02  +1.04930000E-03  -1.45667700E-02
   -2.14586200E-02  +2.49300000E-04  +1.24538300E-02  +2.26513000E-03  +4.78279300E-02
   -1.10300000E-05  -1.54490000E-04  +9.57200000E-05  +1.66520000E-04  +1.14500000E-05
   -9.27700000E-05  +1.09330000E-04  +6.24000000E-06  -1.57300000E-04  -6.43030000E-04
   +3.65520000E-04  -1.56850000E-04  +2.26200000E-05  -4.64150000E-04  +9.87740000E-04
   +4.94000000E-05  +1.97990000E-04  +2.10000000E-06  -1.23400000E-04  -1.36030000E-04
   +1.35890000E-04  -1.66701100E-02  +3.14080000E-04  +1.03818000E-02  +1.23203700E-01
   +2.05128000E-03  -1.26071630E-01  -2.83967000E-03  -1.78280000E-04  -1.99865000E-03
   +4.85980000E-04  +4.03600000E-05  +8.76130000E-04  +1.61230000E-04  -6.62790000E-04
   +3.35030000E-04  -1.64540000E-04  -1.54100000E-05  -1.66220000E-04  +1.72090000E-04
   -1.21020000E-04  +1.27000000E-06  -4.77500000E-05  +1.29130000E-04  +5.63400000E-05
   -3.36000000E-06  +2.44350000E-04  -7.33200000E-05  -3.04100000E-05  +7.67600000E-05
   +2.40300000E-05  +1.47700000E-05  +1.85300000E-05  -1.23800000E-05  -2.31500000E-05
   -1.34000000E-06  +3.89000000E-06  -2.09540000E-04  +6.68800000E-05  -9.01890000E-04
   -9.65000000E-06  -2.32700000E-05  -1.38200000E-05  -3.26000000E-06  -1.30500000E-05
   -4.56000000E-06  +1.30668400E-02  +1.50695000E-03  -8.91855000E-03  +1.65795200E-02
   -1.70406000E-03  -1.06252600E-02  -1.31672990E-01  -1.15959000E-03  +1.35601740E-01
   +1.43900000E-05  +5.70000000E-06  -1.05500000E-05  +1.84450000E-04  -1.07560000E-04
   -1.78680000E-04  -2.62500000E-05  +2.50620000E-04  -1.76710000E-04  -5.29000000E-05
   -6.53800000E-05  +5.35080000E-04  +9.80370000E-04  +1.02326000E-03  -1.00306000E-03
   +2.82100000E-05  +3.15500000E-04  +2.75840000E-04  +2.06980000E-04  -2.95550000E-04
   +1.69280000E-04  -2.09702100E-02  +4.93600000E-05  -1.48564100E-02  -4.01857000E-03
   -8.67900000E-05  +4.81831000E-03  -2.37242400E-01  -1.58415000E-03  -1.21058240E-01
   +7.86160000E-04  -1.45376000E-03  -8.75830000E-04  -2.90100000E-04  +8.43250000E-04
   +9.05600000E-05  -1.11610000E-04  -4.68320000E-04  -4.08290000E-04  +4.74700000E-04
   -2.29820000E-04  +3.61600000E-04  +1.86520000E-04  +6.05440000E-04  +3.22650000E-04
   -1.07860000E-04  +1.51760000E-04  -7.01760000E-04  -1.73100000E-05  -5.73100000E-05
   -1.75000000E-05  -9.28000000E-06  -7.53000000E-06  -7.15000000E-06  -3.06500000E-05
   -2.38500000E-05  -2.59900000E-05  +3.26200000E-05  -3.27800000E-05  -9.91700000E-05
   +1.57610000E-04  -4.80020000E-04  -2.76990000E-04  -7.20000000E-06  -2.18600000E-05
   +2.64400000E-05  +2.57610000E-04  -3.15500000E-05  +5.42600000E-05  +3.88100000E-04
   +5.92200000E-05  +1.29310000E-04  -1.58873000E-03  -2.28960000E-04  -9.83750000E-04
   +2.59205590E-01  +3.58500000E-05  +1.08370000E-04  -1.13140000E-04  +3.65200000E-05
   -8.45100000E-05  +1.43400000E-05  +1.89600000E-05  +1.25150000E-04  -9.84500000E-05
   -4.05400000E-05  -7.55100000E-05  +8.09100000E-05  -3.73920000E-04  +3.16240000E-04
   -4.96050000E-04  -6.54290000E-04  -8.37600000E-05  +4.35400000E-04  +2.47700000E-04
   -1.05550000E-04  -3.94700000E-05  -2.06510000E-03  -1.82519000E-03  -1.49819000E-03
   -5.26710000E-04  -3.56500000E-05  +5.22250000E-04  -1.75958000E-03  -4.71854100E-02
   -1.73973000E-03  +5.30200000E-04  +2.16600000E-05  +6.05920000E-04  +9.72500000E-05
   -1.91770000E-04  -7.72100000E-05  +5.98700000E-05  +1.42430000E-04  +8.98100000E-05
   -9.97500000E-05  -1.45400000E-05  -1.29250000E-04  -3.56000000E-05  -2.64020000E-04
   -4.35900000E-05  +1.21400000E-05  -5.24500000E-05  -1.42310000E-04  -3.96000000E-06
   +5.94400000E-05  +5.07900000E-05  -5.17000000E-06  -9.42000000E-06  +9.93000000E-06
   +1.30600000E-05  +1.25300000E-05  -1.30700000E-05  +5.08300000E-05  -1.79100000E-05
   -5.27400000E-05  -3.33130000E-04  -1.31373000E-03  -2.21610000E-04  -2.45900000E-05
   -1.31900000E-05  -1.42000000E-06  +3.00090000E-04  +2.97780000E-04  +2.57210000E-04
   -1.90320000E-04  +1.61210000E-04  -3.04110000E-04  -2.28960000E-04  +6.49300000E-04
   -1.37010000E-04  +2.26513000E-03  +4.78279300E-02  +3.04100000E-05  -7.67600000E-05
   +2.40300000E-05  -1.72090000E-04  +1.21020000E-04  +1.27000000E-06  +4.77500000E-05
   -1.29130000E-04  +5.63400000E-05  +3.36000000E-06  -2.44350000E-04  -7.33200000E-05
   -4.85980000E-04  -4.03600000E-05  +8.76130000E-04  -1.61230000E-04  +6.62790000E-04
   +3.35030000E-04  +1.64540000E-04  +1.54100000E-05  -1.66220000E-04  +1.66701000E-02
   -3.14080000E-04  +1.03817900E-02  +2.83967000E-03  +1.78280000E-04  -1.99865000E-03
   -1.23203700E-01  -2.05128000E-03  -1.26071630E-01  -2.26200000E-05  +4.64150000E-04
   +9.87740000E-04  -4.94000000E-05  -1.97990000E-04  +2.10000000E-06  +1.23400000E-04
   +1.36030000E-04  +1.35890000E-04  -1.66520000E-04  -1.14500000E-05  -9.27700000E-05
   -1.09330000E-04  -6.24000000E-06  -1.57300000E-04  +6.43030000E-04  -3.65520000E-04
   -1.56850000E-04  +1.10300000E-05  +1.54490000E-04  +9.57200000E-05  +4.90000000E-06
   +1.09500000E-05  -1.18000000E-05  +6.36000000E-06  -1.42600000E-05  +1.85900000E-05
   +3.15800000E-05  +1.30000000E-06  +1.92800000E-05  +2.32210000E-04  +2.54440000E-04
   -2.35800000E-04  +2.13700000E-05  +1.04300000E-05  +3.47200000E-05  +1.37540000E-04
   +2.41620000E-04  -8.69000000E-06  +1.62390000E-04  -2.45450000E-04  +2.47800000E-05
   +9.83750000E-04  +1.37010000E-04  +8.50460000E-04  +1.31672990E-01  +1.15959000E-03
   +1.35601740E-01  +3.37200000E-05  -1.21630000E-04  +4.68100000E-05  +1.70000000E-06
   +9.64700000E-05  -1.36450000E-04  -2.56420000E-04  +1.29450000E-04  +2.35350000E-04
   +3.70130000E-04  -1.47244000E-03  +8.95540000E-04  -4.34476000E-03  +1.00672000E-03
   +2.42630000E-03  -5.43150000E-04  +9.13370000E-04  +3.04010000E-04  +2.46800000E-04
   -2.08710000E-04  +1.37200000E-05  -3.78840000E-04  -2.27836200E-02  +1.42804900E-02
   +1.28178000E-03  -1.13359000E-03  +8.52350000E-04  -4.73025900E-02  +1.38532800E-02
   -9.61780000E-03  +6.14240000E-04  -8.89890000E-04  -3.56990000E-04  +2.01780000E-04
   -9.77600000E-05  -1.46190000E-04  -2.67000000E-05  +1.73930000E-04  +1.21420000E-04
   -2.21940000E-04  +1.75190000E-04  -3.39700000E-05  +1.09690000E-04  -4.04960000E-04
   -8.10000000E-07  -1.06730000E-04  +4.10920000E-04  +4.29000000E-05  +6.71000000E-06
   -1.77010000E-04  -1.25170000E-04  +4.24000000E-06  +1.92700000E-05  -1.95000000E-05
   -2.63100000E-05  -1.23840000E-04  +7.12600000E-05  +3.80000000E-07  -9.40000000E-07
   -3.61600000E-05  +2.73220000E-04  -8.28800000E-05  -5.45940000E-04  +1.08100000E-05
   -2.15300000E-05  +3.54300000E-05  -7.36000000E-05  +5.89700000E-05  -1.29200000E-05
   -6.87540000E-04  +2.75150000E-04  -3.61590000E-04  +2.57610000E-04  +3.00090000E-04
   -1.37540000E-04  -6.76160000E-04  +2.40840900E-02  -1.30668400E-02  +5.22616100E-02
   -4.32200000E-05  -1.86730000E-04  +1.72920000E-04  -2.16100000E-05  +1.16010000E-04
   -9.18800000E-05  -9.94100000E-05  -8.37500000E-05  +9.23400000E-05  +2.72360000E-04
   +1.55300000E-05  -1.04100000E-04  -9.92400000E-05  +7.13960000E-04  -5.94600000E-05
   +4.41170000E-04  -1.34820000E-04  -1.44350000E-04  -2.41370000E-04  +1.61190000E-04
   +1.56290000E-04  +9.19710000E-04  -2.50200000E-03  +2.84950000E-04  +3.98310000E-04
   -1.35580000E-04  -1.32540000E-04  +1.21993200E-02  -2.44865940E-01  +1.19674600E-01
   +4.75200000E-05  +8.07100000E-04  -1.38088000E-03  +1.29280000E-04  +2.23550000E-04
   +1.49530000E-04  -5.25900000E-05  +1.05130000E-04  +9.81500000E-05  -1.54310000E-04
   +1.85500000E-05  -7.06800000E-05  -1.34400000E-05  -2.12940000E-04  +3.73000000E-06
   +2.04100000E-04  +3.27450000E-04  +2.47880000E-04  +2.48000000E-05  +4.28800000E-05
   +9.40000000E-06  +9.37000000E-06  +1.79100000E-05  -2.23400000E-05  -2.36500000E-05
   -3.76400000E-05  +1.24500000E-05  -5.84900000E-05  +7.73100000E-05  +5.59100000E-05
   -5.08950000E-04  +1.44870000E-04  +1.62560000E-04  +2.04300000E-05  -6.74000000E-06
   +5.29000000E-06  +5.89700000E-05  +2.59900000E-05  +1.16490000E-04  -5.51170000E-04
   +2.89110000E-04  -2.88590000E-04  -3.15500000E-05  +2.97780000E-04  -2.41620000E-04
   -1.66620000E-04  +1.04930000E-03  -1.50695000E-03  -1.42010300E-02  +2.62967220E-01
   -2.04800000E-05  +2.65760000E-04  -1.72370000E-04  +9.93900000E-05  -2.94390000E-04
   +9.22000000E-05  +1.31390000E-04  +5.73600000E-05  -3.42420000E-04  -2.46140000E-04
   +1.23580000E-03  -1.72300000E-04  +3.76015000E-03  -9.36290000E-04  -1.43077000E-03
   +5.24440000E-04  -4.85040000E-04  +8.51700000E-05  -5.63800000E-05  +8.97200000E-05
   +1.46890000E-04  -8.51030000E-04  +1.66421100E-02  -1.23312100E-02  -1.15569000E-03
   -4.29190000E-04  +2.83920000E-04  -8.56018000E-03  +1.17866340E-01  -1.17761400E-01
   -2.30240000E-04  +1.21235000E-03  +5.73610000E-04  +3.14500000E-05  -3.12650000E-04
   +1.37610000E-04  +7.02800000E-05  -1.72500000E-04  -4.92600000E-05  +1.23450000E-04
   -2.23010000E-04  -1.08310000E-04  -5.58300000E-05  +9.07800000E-05  +3.64300000E-05
   -5.74320000E-04  -1.33000000E-04  -3.24730000E-04  +2.48000000E-06  +1.98590000E-04
   +1.77820000E-04  -1.64100000E-05  -3.52300000E-05  +3.35700000E-05  -1.67500000E-05
   +8.39800000E-05  -1.18350000E-04  +8.06400000E-05  -8.57000000E-06  +3.46400000E-05
   -3.25260000E-04  -1.90090000E-04  -5.31000000E-05  +5.83000000E-06  +4.42300000E-05
   -5.73000000E-06  +1.29200000E-05  -1.16490000E-04  +5.25500000E-05  +1.15250000E-04
   -1.05770000E-04  +5.98340000E-04  -5.42600000E-05  -2.57210000E-04  -8.69000000E-06
   -6.69800000E-05  +1.45667700E-02  -8.91855000E-03  +5.71022000E-03  -1.30202860E-01
   +1.27388900E-01  -2.79700000E-05  +4.68500000E-05  -1.85200000E-05  +1.67270000E-04
   -1.19340000E-04  -3.67200000E-05  -3.10800000E-05  +1.33840000E-04  -7.39000000E-05
   -2.35950000E-04  -3.40400000E-05  -1.37500000E-05  +5.52990000E-04  +2.21040000E-04
   -6.03310000E-04  +4.49300000E-04  -3.15820000E-04  -3.79120000E-04  -1.27840000E-04
   -1.09970000E-04  +1.51520000E-04  -1.92242000E-03  +2.07326900E-02  +1.63609000E-02
   +1.24106000E-03  +1.16160000E-03  +8.04530000E-04  -4.83912200E-02  +5.46323000E-03
   +3.83978000E-03  -3.81742000E-03  -1.34302000E-03  +2.37716000E-03  +1.24960000E-04
   +5.40210000E-04  +5.89790000E-04  +2.64970000E-04  +1.55060000E-04  -2.22740000E-04
   +1.69800000E-04  -4.06550000E-04  -7.50600000E-05  +4.59900000E-05  +6.17500000E-04
   -6.88900000E-05  -6.19500000E-05  +4.65000000E-05  -3.58150000E-04  +1.28000000E-06
   +4.57820000E-04  +3.79670000E-04  -2.00000000E-06  -6.03000000E-06  +1.45900000E-05
   +9.68000000E-06  +1.95500000E-05  +1.22300000E-05  +3.40600000E-05  +4.23700000E-05
   +8.57000000E-06  +1.40120000E-04  +2.32380000E-04  -2.11400000E-04  +7.87000000E-06
   +6.51000000E-06  +2.01000000E-06  -6.87540000E-04  -5.51170000E-04  -1.15250000E-04
   -7.11500000E-05  +7.53700000E-05  -1.25620000E-04  +3.88100000E-04  -1.90320000E-04
   -1.62390000E-04  +1.99917000E-03  -2.14586200E-02  -1.65795200E-02  -1.02545000E-03
   +1.54391000E-03  +1.34904000E-03  +5.10458200E-02  -2.97000000E-05  +8.82000000E-05
   -3.31100000E-05  +1.91500000E-05  -1.74450000E-04  +1.02800000E-05  -3.11000000E-06
   +4.20700000E-05  -1.14700000E-05  -1.91000000E-06  +1.15700000E-04  -1.27280000E-04
   +2.77370000E-04  -3.01400000E-05  +1.59800000E-05  +6.18740000E-04  -8.72940000E-04
   +9.08070000E-04  -2.31890000E-04  +1.32770000E-04  +1.65050000E-04  -3.09620000E-04
   +1.55121000E-03  +2.24475000E-03  -2.75570000E-04  +3.67700000E-04  +3.24270000E-04
   +5.69904000E-03  -2.01255710E-01  -1.31073830E-01  +2.64260000E-04  +4.89620000E-04
   -5.54800000E-04  -1.71960000E-04  +5.63930000E-04  -1.55210000E-04  -5.97800000E-05
   -4.50000000E-07  -5.91100000E-05  -7.17700000E-05  +2.96320000E-04  +1.63050000E-04
   +7.78400000E-05  -2.16650000E-04  -1.99000000E-06  +4.45300000E-04  +2.79470000E-04
   +3.26780000E-04  -2.00000000E-06  -2.98010000E-04  -2.21050000E-04  -7.75000000E-06
   -1.98600000E-05  +1.02000000E-05  -1.71000000E-06  +1.41700000E-05  -1.96000000E-05
   -1.17700000E-05  -8.86000000E-06  +4.15000000E-06  -8.46600000E-05  -1.32752000E-03
   +1.96447000E-03  +2.49500000E-05  +3.24000000E-05  +6.65000000E-06  +2.75150000E-04
   +2.89110000E-04  +1.05770000E-04  +7.53700000E-05  -2.08070000E-04  -1.25950000E-04
   +5.92200000E-05  +1.61210000E-04  +2.45450000E-04  +6.72300000E-05  +2.49300000E-04
   +1.70406000E-03  +1.44720000E-04  -1.92953300E-02  -1.85269600E-02  -6.76941000E-03
   +2.19116210E-01  -6.23400000E-05  -9.94800000E-05  +1.41260000E-04  -8.45600000E-05
   +4.09600000E-05  -1.87200000E-05  -4.63300000E-05  -1.70970000E-04  +1.65230000E-04
   +1.55830000E-04  +3.00450000E-04  -1.18600000E-04  -2.65640000E-04  -7.01650000E-04
   +5.70380000E-04  +9.09780000E-04  -1.41030000E-04  -5.39310000E-04  -3.94350000E-04
   +3.34640000E-04  +2.38780000E-04  -5.62190000E-04  -1.49018800E-02  -1.23184500E-02
   -1.50650000E-03  -5.16100000E-05  +5.49490000E-04  +4.90154000E-03  -1.29836540E-01
   -1.58499900E-01  +3.73899000E-03  +4.49870000E-04  -1.35922000E-03  -3.33240000E-04
   +4.39010000E-04  -4.60770000E-04  -3.43200000E-04  -6.39850000E-04  -3.54370000E-04
   +4.72570000E-04  +1.91170000E-04  +5.12530000E-04  +1.23300000E-05  +2.57400000E-04
   +1.63900000E-04  +2.74850000E-04  -3.53390000E-04  -1.30560000E-04  -7.50100000E-05
   -4.99140000E-04  -3.85380000E-04  +6.90000000E-07  +2.85000000E-06  -1.46800000E-05
   -2.20600000E-05  -1.06900000E-05  -2.71000000E-06  -1.29540000E-04  -2.93000000E-05
   +6.72500000E-05  -9.12600000E-04  +1.57350000E-03  -1.09614000E-03  +1.52300000E-05
   +1.76800000E-05  -3.45500000E-05  +3.61590000E-04  +2.88590000E-04  +5.98340000E-04
   +1.25620000E-04  +1.25950000E-04  -1.88200000E-05  -1.29310000E-04  +3.04110000E-04
   +2.47800000E-05  +1.66969000E-03  -1.24538300E-02  -1.06252600E-02  -4.33950000E-04
   +1.30162600E-02  +1.21096800E-02  -7.35692000E-03  +1.42637140E-01  +1.70685810E-01
   -3.81000000E-06  -3.92700000E-05  +4.11100000E-05  -5.20000000E-06  +1.81300000E-05
   -3.06200000E-05  +6.68000000E-06  -1.34200000E-05  +2.24200000E-05  +8.21000000E-05
   -1.28900000E-05  -3.48000000E-06  +1.71360000E-04  -2.10660000E-04  -1.09160000E-04
   -2.19200000E-05  -4.73900000E-05  +6.91700000E-05  -2.90000000E-07  -3.12000000E-06
   +2.26200000E-05  -1.65323000E-03  -2.20329000E-03  +5.18440000E-04  +3.97840000E-04
   -3.90300000E-04  -8.31380000E-04  -2.19000000E-06  +6.33630000E-04  +1.97220000E-04
   -9.87750000E-03  -3.02422000E-03  -1.54525400E-02  -1.93745330E-01  -6.24243000E-03
   -1.48869450E-01  +3.11293000E-03  +1.51184000E-03  +2.62050000E-04  +4.23087000E-03
   +2.22584000E-03  -1.93326000E-03  -1.59230000E-04  +2.22050000E-04  +1.01933000E-03
   +2.69060000E-04  +5.33276000E-03  -2.37562000E-03  -2.99400000E-05  -1.54090000E-04
   -1.89180000E-04  +9.70000000E-07  -4.02000000E-06  -7.77000000E-06  -3.82000000E-06
   -7.71000000E-06  +4.85000000E-06  -2.98800000E-05  +1.55000000E-06  -2.15600000E-05
   -1.54200000E-05  +2.58000000E-06  -8.09000000E-06  -1.71000000E-06  -8.49000000E-06
   +1.51000000E-06  +2.73220000E-04  -5.08950000E-04  +3.25260000E-04  +1.40120000E-04
   -8.46600000E-05  +9.12600000E-04  +1.57610000E-04  -3.33130000E-04  -2.32210000E-04
   +9.34400000E-05  -6.41500000E-05  +9.65000000E-06  -9.81100000E-05  -1.67800000E-05
   +6.03500000E-05  -1.58070000E-04  +5.14000000E-06  +1.42950000E-04  +1.99008850E-01
   -3.73000000E-06  +8.99500000E-05  -6.62800000E-05  -3.13000000E-06  -5.80600000E-05
   +6.07500000E-05  -5.96500000E-05  +8.44000000E-06  +8.00000000E-07  +8.49900000E-05
   -4.04700000E-05  -1.07720000E-04  -1.60710000E-04  -1.94880000E-04  -6.84700000E-05
   -3.23400000E-05  -1.65700000E-05  -2.28000000E-05  +2.32600000E-05  +4.20400000E-05
   -2.50800000E-05  -1.21972000E-03  +1.64300000E-05  +1.41997000E-03  +9.07390000E-04
   -2.51908000E-03  -1.24126000E-03  -8.68200000E-05  +3.25070000E-04  -6.55000000E-06
   +1.50923800E-02  +7.37195000E-03  +1.61783600E-02  -6.77183000E-03  -5.69674400E-02
   -1.83621800E-02  -1.88956000E-02  +1.90436000E-03  -1.92163600E-02  +2.37077000E-03
   -2.03587000E-03  -4.67218000E-03  +9.16800000E-05  -1.32364000E-03  -7.79900000E-05
   +5.27693000E-03  -2.13030000E-03  -1.04423000E-03  -1.03313000E-03  +8.19000000E-06
   -9.85750000E-04  +4.80000000E-07  -1.10400000E-05  +1.67000000E-05  +1.13600000E-05
   +7.50000000E-06  -2.83000000E-06  +1.01400000E-05  +5.06100000E-05  +7.96000000E-05
   +2.58000000E-06  -6.23000000E-06  +1.22300000E-05  +1.09000000E-06  +1.11300000E-05
   +4.29000000E-06  -8.28800000E-05  +1.44870000E-04  +1.90090000E-04  +2.32380000E-04
   -1.32752000E-03  -1.57350000E-03  -4.80020000E-04  -1.31373000E-03  -2.54440000E-04
   -1.34650000E-04  +1.65500000E-05  +2.32700000E-05  +2.23700000E-05  +2.33700000E-05
   +3.40200000E-05  -3.54000000E-05  -4.99600000E-05  +4.72700000E-05  +5.52050000E-03
   +5.83579200E-02  +1.73700000E-05  +4.46600000E-05  -4.60400000E-05  -2.64800000E-05
   -2.81100000E-05  +4.83100000E-05  +5.44100000E-05  -8.05000000E-06  -1.66800000E-05
   -1.31850000E-04  +1.18950000E-04  +7.71900000E-05  -2.22040000E-04  +2.75410000E-04
   +3.71430000E-04  +8.76200000E-05  +8.04700000E-05  -9.00000000E-05  +1.22000000E-06
   +1.32800000E-05  -3.49800000E-05  +1.21531000E-03  +6.47390000E-04  -2.30442000E-03
   +3.41480000E-04  -2.63873000E-03  -6.36380000E-04  +7.98700000E-05  -4.22290000E-04
   -2.16240000E-04  -3.17748000E-03  -5.24010000E-04  +1.18327000E-03  -1.48790450E-01
   -1.81679600E-02  -1.90877040E-01  -1.37348500E-02  +4.44000000E-05  -8.98094000E-03
   -1.89669000E-03  -4.76064000E-03  +2.91451000E-03  +9.53350000E-04  +1.04800000E-05
   -1.85700000E-04  -2.59477000E-03  -9.51630000E-04  +3.62688000E-03  -7.90880000E-04
   -1.75630000E-04  -7.93350000E-04  -9.62000000E-06  +2.73000000E-06  +1.84000000E-06
   -5.50000000E-06  +8.53000000E-06  -1.57000000E-05  -2.45500000E-05  +8.38000000E-06
   -8.07300000E-05  +8.09000000E-06  -1.22300000E-05  -2.47000000E-06  -2.20000000E-06
   +8.81000000E-06  -1.22300000E-05  +5.45940000E-04  -1.62560000E-04  -5.31000000E-05
   +2.11400000E-04  -1.96447000E-03  -1.09614000E-03  +2.76990000E-04  +2.21610000E-04
   -2.35800000E-04  +1.93900000E-05  +6.92000000E-06  -1.38200000E-05  -6.36000000E-06
   +2.29500000E-05  -1.75500000E-05  +1.06890000E-04  +6.46900000E-05  -3.38900000E-05
   +1.64901640E-01  +2.68689200E-02  +1.99514130E-01  +2.06000000E-06  +4.09700000E-05
   -2.70200000E-05  -1.55800000E-05  -2.71700000E-05  +3.18000000E-05  -1.10800000E-05
   -5.67000000E-06  +1.17900000E-05  +1.71800000E-05  +4.14000000E-06  -1.19000000E-06
   -6.12000000E-06  +1.14710000E-04  +6.58800000E-05  +2.90100000E-05  -7.04000000E-06
   +9.06000000E-06  +5.68000000E-06  +1.61900000E-05  -2.65200000E-05  +2.45580000E-04
   -9.25300000E-05  -1.67490000E-04  -4.72300000E-05  +9.25000000E-06  +4.79200000E-05
   -4.92000000E-06  -8.13000000E-06  -6.18600000E-05  +3.94580000E-03  +6.90390000E-04
   -2.49762000E-03  +4.19656000E-03  -2.60399000E-03  -1.27490000E-04  -1.81237700E-01
   +1.45364880E-01  -3.65628300E-02  -9.76117000E-03  +1.92674000E-02  -8.41420000E-04
   -1.84090000E-04  +1.49490000E-04  -5.40064000E-03  -3.53840000E-04  -1.20383000E-03
   -1.29420000E-04  -1.07460000E-04  -1.26151000E-03  +2.41149000E-03  -1.74000000E-06
   -6.91000000E-06  +4.69000000E-06  +1.23000000E-06  -2.14000000E-06  -1.64000000E-06
   -8.46000000E-06  -7.01000000E-06  -4.00000000E-08  -1.71000000E-06  +1.09000000E-06
   +2.20000000E-06  -4.23000000E-06  +1.18000000E-06  -4.11000000E-06  +1.08100000E-05
   +2.04300000E-05  -5.83000000E-06  +7.87000000E-06  +2.49500000E-05  -1.52300000E-05
   -7.20000000E-06  -2.45900000E-05  -2.13700000E-05  -2.05700000E-05  -8.97000000E-06
   +3.26000000E-06  +9.37000000E-06  +3.52000000E-06  -1.00000000E-08  -1.12800000E-05
   +4.36000000E-06  -3.47900000E-05  -1.11798000E-03  -1.21517000E-03  +2.28989000E-03
   +1.85367800E-01  -7.74000000E-06  -7.78400000E-05  +6.02000000E-05  -8.80000000E-07
   +6.31500000E-05  -4.14200000E-05  +1.06100000E-05  -3.47400000E-05  +1.29600000E-05
   +3.03000000E-05  -2.39300000E-05  -2.25000000E-06  +5.04200000E-05  +1.64000000E-06
   -2.36770000E-04  -3.08400000E-05  -5.58600000E-05  +7.61000000E-05  +5.97000000E-06
   -9.46000000E-06  +1.85700000E-05  +8.37010000E-04  -1.57830000E-04  +5.20490000E-04
   +4.98700000E-05  -1.88000000E-05  +9.73700000E-05  -8.84400000E-05  -2.11820000E-04
   -8.59300000E-05  +5.56040000E-04  -1.15567000E-03  -5.27617000E-03  +1.73307300E-02
   -1.31455400E-02  +5.52194000E-03  +1.46467840E-01  -2.03503730E-01  +2.11482800E-02
   -2.10591000E-03  +4.59690000E-03  -2.47779000E-03  +5.78940000E-04  +1.93342000E-03
   -2.05595000E-03  -8.96090000E-04  -2.00850000E-04  -2.15000000E-04  -1.02522000E-03
   +3.79100000E-05  +1.55136000E-03  +7.01000000E-06  +5.95000000E-06  -1.02800000E-05
   -4.40000000E-06  -1.44100000E-05  +1.32500000E-05  +1.38700000E-05  +6.89000000E-06
   -1.89100000E-05  -8.49000000E-06  +1.11300000E-05  -8.81000000E-06  +1.18000000E-06
   -1.07900000E-05  +6.00000000E-06  -2.15300000E-05  -6.74000000E-06  -4.42300000E-05
   +6.51000000E-06  +3.24000000E-05  -1.76800000E-05  -2.18600000E-05  -1.31900000E-05
   -1.04300000E-05  -5.83000000E-06  +1.40000000E-07  +1.30500000E-05  -2.15000000E-06
   +2.34000000E-05  +4.56000000E-06  +6.48500000E-05  -1.75600000E-05  -9.51500000E-05
   -1.62299000E-03  -1.84680000E-04  +1.42342000E-03  -1.59666200E-01  +2.12153420E-01
   -3.00000000E-06  -4.02800000E-05  +2.77300000E-05  +2.10500000E-05  +1.82300000E-05
   -3.35100000E-05  +8.46000000E-06  +1.03300000E-05  +1.35000000E-06  -2.59100000E-05
   -1.02500000E-05  +3.18000000E-06  +4.00700000E-05  -2.11430000E-04  -2.40070000E-04
   -3.42400000E-05  -1.73900000E-05  +2.06400000E-05  +1.07100000E-05  -2.20200000E-05
   +4.48000000E-05  +3.87710000E-04  -4.76870000E-04  +5.14430000E-04  +6.87100000E-05
   +6.50200000E-05  +4.40400000E-05  -5.11500000E-05  -5.97000000E-05  +4.04100000E-05
   -2.74473000E-03  -4.87307000E-03  +1.07631000E-03  +1.37266100E-02  -1.32715000E-02
   +6.12895000E-03  -3.57278300E-02  +2.00910700E-02  -5.47450800E-02  -1.56679400E-02
   +1.75208200E-02  +2.73102000E-03  -5.09538000E-03  -2.42574000E-03  -7.89510000E-04
   +6.14500000E-05  -4.18430000E-04  -1.31405000E-03  +2.59189000E-03  +1.35631000E-03
   -2.50680000E-04  +5.10000000E-07  +3.54000000E-06  -3.24000000E-06  -2.83000000E-06
   +2.04000000E-06  +1.44000000E-06  -5.05000000E-06  -3.95000000E-06  +7.57000000E-06
   -1.51000000E-06  -4.29000000E-06  -1.22300000E-05  +4.11000000E-06  -6.00000000E-06
   +6.66000000E-06  -3.54300000E-05  -5.29000000E-06  -5.73000000E-06  -2.01000000E-06
   -6.65000000E-06  -3.45500000E-05  -2.64400000E-05  +1.42000000E-06  +3.47200000E-05
   +1.60600000E-05  +8.14000000E-06  -4.56000000E-06  +8.68000000E-06  +1.51000000E-05
   -1.06800000E-05  +3.19900000E-05  -3.18000000E-06  -1.29000000E-06  +1.99786000E-03
   +1.81315000E-03  -1.34220000E-03  +4.03953000E-02  -2.03061000E-02  +4.85179700E-02
   -5.05000000E-06  -7.37500000E-05  +7.10100000E-05  +3.47600000E-05  +4.33200000E-05
   -5.73200000E-05  +2.62400000E-05  -3.00000000E-08  +2.03700000E-05  +1.01700000E-05
   -2.73400000E-05  -3.27900000E-05  -7.20000000E-07  -6.43500000E-05  -2.22000000E-05
   -5.55900000E-05  +2.23100000E-05  -8.59000000E-06  -2.51300000E-05  -1.79300000E-05
   +4.37900000E-05  +7.53100000E-05  +3.65570000E-04  -1.16490000E-04  +2.85400000E-05
   -5.89200000E-05  +4.25700000E-05  -5.66600000E-05  -4.04100000E-05  +4.78000000E-06
   +4.19742000E-03  +1.64883000E-03  -2.02715000E-03  -1.69430000E-04  +4.63930000E-04
   +9.88900000E-04  -8.99400000E-05  +5.15421000E-03  -1.64012000E-03  -1.00432800E-02
   -5.95400000E-03  -1.75170700E-02  -1.83766620E-01  -5.87016000E-03  -1.47139870E-01
   +2.66127000E-03  +8.77760000E-04  +6.53770000E-04  +2.63860000E-04  -1.84858000E-03
   +2.64341000E-03  -5.70000000E-07  -2.80000000E-06  -1.81100000E-05  -2.03600000E-05
   -1.89600000E-05  +3.33000000E-06  -2.27000000E-06  +1.07700000E-05  -2.47800000E-05
   -3.82000000E-06  +1.13600000E-05  +5.50000000E-06  +1.23000000E-06  -4.40000000E-06
   +2.83000000E-06  -2.63100000E-05  -2.36500000E-05  +1.67500000E-05  +9.68000000E-06
   -1.71000000E-06  +2.20600000E-05  -3.06500000E-05  +1.30600000E-05  -6.36000000E-06
   -3.91000000E-06  +1.91700000E-05  +2.31500000E-05  +1.32000000E-06  -1.02000000E-06
   +1.50400000E-05  +1.98100000E-05  -2.01000000E-05  -2.30500000E-05  -3.00500000E-04
   -2.30770000E-04  +2.47670000E-04  -6.83140000E-04  -2.51350000E-04  -7.50360000E-04
   +1.89597350E-01  +4.76000000E-06  -7.23800000E-05  +7.27400000E-05  +1.27100000E-05
   +4.13000000E-05  -4.64500000E-05  +2.54900000E-05  -1.40700000E-05  +3.17800000E-05
   +1.29400000E-05  -9.55000000E-06  +3.81000000E-06  -2.65000000E-06  +1.29950000E-04
   -5.99400000E-05  -1.93200000E-05  +1.50000000E-06  +1.97600000E-05  -1.03000000E-06
   -2.35700000E-05  +4.83900000E-05  -9.27010000E-04  +5.58930000E-04  -6.99500000E-04
   +1.24020000E-04  -3.77570000E-04  -1.35440000E-04  -1.06440000E-04  +1.70000000E-06
   +6.98300000E-05  +2.21741000E-03  -2.40966000E-03  -4.77118000E-03  +2.35270000E-04
   -1.59373000E-03  -2.38580000E-04  +4.69232000E-03  -2.08075000E-03  -7.24920000E-04
   +1.55543600E-02  +5.31283000E-03  +1.57058100E-02  -5.58128000E-03  -5.65145800E-02
   -2.11446000E-02  -1.95003800E-02  +2.60261000E-03  -1.85678100E-02  -1.29401000E-03
   +1.81961000E-03  +2.65583000E-03  -6.25000000E-06  -5.65000000E-06  -1.72300000E-05
   -1.89600000E-05  -1.84400000E-05  +3.37000000E-06  +3.77000000E-06  +7.79000000E-06
   -3.07800000E-05  -7.71000000E-06  +7.50000000E-06  -8.53000000E-06  -2.14000000E-06
   -1.44100000E-05  -2.04000000E-06  -1.23840000E-04  -3.76400000E-05  -8.39800000E-05
   +1.95500000E-05  +1.41700000E-05  +1.06900000E-05  -2.38500000E-05  +1.25300000E-05
   +1.42600000E-05  +4.11900000E-05  +2.07500000E-05  +1.34000000E-06  +1.32000000E-05
   -2.49000000E-06  +1.43900000E-05  +3.82900000E-05  -2.78600000E-05  -2.36900000E-05
   -2.58640000E-04  -8.41900000E-05  +1.96650000E-04  +7.48220000E-04  +2.41490000E-04
   +8.88900000E-04  +5.61277000E-03  +5.33746300E-02  +3.42000000E-06  -9.40400000E-05
   +6.81900000E-05  -6.51000000E-06  +7.92100000E-05  -4.94500000E-05  +1.74100000E-05
   -3.52300000E-05  -9.73000000E-06  -6.40000000E-06  +2.06800000E-05  +3.79200000E-05
   +8.11000000E-06  +1.81050000E-04  -1.40270000E-04  -4.38000000E-06  -1.41000000E-05
   +4.08200000E-05  +5.31000000E-06  -1.82200000E-05  +2.43000000E-05  -8.40300000E-04
   +2.33610000E-04  -1.16770000E-04  +1.24060000E-04  -2.98980000E-04  -1.88500000E-04
   -2.58100000E-05  -6.62100000E-05  -1.29500000E-05  -1.50168000E-03  -5.01836000E-03
   +2.54294000E-03  +7.73320000E-04  +4.33300000E-05  -1.24880000E-04  -1.96898000E-03
   -3.30660000E-04  +3.30207000E-03  -2.49617000E-03  -4.96095000E-03  -1.75595000E-03
   -1.47195210E-01  -2.12859000E-02  -1.88104980E-01  -1.35076900E-02  +7.89990000E-04
   -9.71109000E-03  +2.99887000E-03  +2.24513000E-03  +5.53020000E-04  +1.62000000E-06
   +1.32200000E-05  -1.28700000E-05  -3.33000000E-06  -3.37000000E-06  +7.89000000E-06
   +2.99400000E-05  +9.29000000E-06  -1.18700000E-05  -4.85000000E-06  +2.83000000E-06
   -1.57000000E-05  +1.64000000E-06  -1.32500000E-05  +1.44000000E-06  -7.12600000E-05
   -1.24500000E-05  -1.18350000E-04  -1.22300000E-05  +1.96000000E-05  -2.71000000E-06
   +2.59900000E-05  +1.30700000E-05  +1.85900000E-05  +2.59000000E-06  -1.36500000E-05
   +3.89000000E-06  -1.77300000E-05  +1.24000000E-05  -5.79000000E-06  +3.03500000E-05
   -1.30800000E-05  -5.20500000E-05  +2.19660000E-04  +2.27500000E-04  -3.61130000E-04
   -8.29700000E-05  -3.18000000E-05  -1.56140000E-04  +1.62206160E-01  +2.60943900E-02
   +1.95543230E-01  +2.03700000E-05  +3.23120000E-04  -2.24370000E-04  -5.92400000E-05
   -2.99270000E-04  +1.63940000E-04  -3.20500000E-05  -3.50000000E-07  +1.39960000E-04
   -1.52270000E-04  +8.66100000E-05  +3.68620000E-04  +1.82110000E-04  -2.42090000E-04
   -3.39880000E-04  +3.14730000E-04  -4.20940000E-04  +2.34940000E-04  +1.12840000E-04
   -4.30000000E-07  -1.47340000E-04  -1.27487000E-03  +1.64450000E-04  +1.89009000E-03
   -1.66900000E-05  -2.32940000E-04  +2.18700000E-05  -5.81900000E-05  +1.19100000E-05
   +3.79000000E-05  -9.82444000E-03  +1.69306500E-02  -2.28788000E-03  -1.15680000E-04
   +5.38990000E-04  -6.03631000E-03  -2.88020000E-04  -1.11298000E-03  +1.26690000E-04
   +4.33214000E-03  +8.79540000E-04  -3.03539000E-03  +4.02990000E-03  -1.73057000E-03
   -1.13939000E-03  -1.76861650E-01  +1.40316880E-01  -3.79966900E-02  +2.00300000E-05
   +1.16890000E-04  +1.28220000E-04  -2.52800000E-05  -3.62600000E-05  +3.64200000E-05
   -2.27000000E-06  +3.77000000E-06  -2.99400000E-05  -1.75900000E-05  +5.42200000E-05
   -8.87800000E-05  -2.98800000E-05  +1.01400000E-05  +2.45500000E-05  -8.46000000E-06
   +1.38700000E-05  +5.05000000E-06  +3.80000000E-07  -5.84900000E-05  -8.06400000E-05
   +3.40600000E-05  -1.17700000E-05  +1.29540000E-04  +3.26200000E-05  +5.08300000E-05
   -3.15800000E-05  +1.81300000E-04  +9.45200000E-05  +2.09540000E-04  +6.62800000E-05
   +1.57300000E-05  +1.45410000E-04  -4.32000000E-05  -2.13400000E-05  -1.05430000E-04
   -6.82470000E-04  +8.93630000E-04  -1.70500000E-05  -2.87280000E-04  -1.31200000E-04
   +3.26050000E-04  -1.23380000E-03  -1.32863000E-03  +2.34096000E-03  +1.81717740E-01
   -9.13000000E-06  +1.69650000E-04  -1.21430000E-04  +1.53580000E-04  -2.49680000E-04
   +5.77900000E-05  -5.67000000E-05  +2.75340000E-04  -7.26600000E-05  -2.88940000E-04
   -3.21750000E-04  -1.13660000E-04  -6.04490000E-04  -7.06890000E-04  -6.81110000E-04
   -5.57000000E-05  -5.97800000E-05  -7.07500000E-05  +1.18300000E-05  -1.39610000E-04
   +1.28580000E-04  -9.71660000E-04  -8.61810000E-04  +4.18270000E-04  -6.69700000E-05
   -1.48700000E-05  +1.36570000E-04  +1.30920000E-04  -3.19100000E-05  -1.32900000E-04
   -1.71842000E-03  +5.54326000E-03  -6.23360000E-04  +6.02470000E-04  +2.18044000E-03
   -2.11299000E-03  -9.02900000E-04  -2.39470000E-04  -2.01950000E-04  +4.89880000E-04
   -6.49900000E-04  -5.25607000E-03  +1.82721100E-02  -1.40168200E-02  +5.18459000E-03
   +1.41146730E-01  -2.02151420E-01  +2.62178900E-02  +8.78100000E-04  -1.39238000E-03
   -2.66200000E-05  -5.49000000E-06  -1.77500000E-05  +2.64700000E-05  +1.07700000E-05
   +7.79000000E-06  -9.29000000E-06  +5.42200000E-05  +2.91700000E-05  +2.28600000E-05
   +1.55000000E-06  +5.06100000E-05  -8.38000000E-06  -7.01000000E-06  +6.89000000E-06
   +3.95000000E-06  -9.40000000E-07  +7.73100000E-05  +8.57000000E-06  +4.23700000E-05
   -8.86000000E-06  +2.93000000E-05  -3.27800000E-05  -1.79100000E-05  -1.30000000E-06
   -2.19940000E-04  +2.25110000E-04  -6.68800000E-05  +2.92500000E-05  +2.63600000E-05
   +3.01200000E-05  -2.52690000E-04  -1.14100000E-05  -5.09500000E-05  -2.03670000E-04
   +2.26290000E-04  -1.28400000E-04  -1.33220000E-04  -1.68480000E-04  +2.16040000E-04
   -1.58412000E-03  -1.04280000E-04  +1.35394000E-03  -1.54840910E-01  +2.12230240E-01
   +6.90000000E-07  +1.75440000E-04  -1.42310000E-04  +1.71120000E-04  -2.02800000E-04
   -2.38800000E-05  -1.13660000E-04  +2.73660000E-04  -2.46970000E-04  -2.78980000E-04
   -2.31010000E-04  +2.95700000E-04  -1.20520000E-04  -4.54660000E-04  -5.13000000E-05
   -3.60800000E-05  +9.80000000E-07  -5.78100000E-05  +8.67000000E-06  -1.16200000E-04
   +9.97000000E-05  +1.18030000E-03  +1.54816000E-03  -8.94170000E-04  +1.08720000E-04
   +1.26630000E-04  +1.83200000E-05  -4.21470000E-04  -1.67540000E-04  -5.94310000E-04
   -1.46295000E-02  +1.74120300E-02  +2.05960000E-03  -5.55152000E-03  -2.66699000E-03
   -6.12330000E-04  +2.88920000E-04  -2.21150000E-04  -1.04344000E-03  -3.40961000E-03
   -5.01397000E-03  +1.25682000E-03  +1.28798000E-02  -1.46034700E-02  +6.44738000E-03
   -3.89251800E-02  +2.67279900E-02  -5.91492700E-02  +7.38620000E-04  -9.01690000E-04
   +5.76000000E-06  +2.61000000E-06  +3.29000000E-06  +2.88400000E-05  +2.47800000E-05
   +3.07800000E-05  -1.18700000E-05  +8.87800000E-05  -2.28600000E-05  +2.91600000E-05
   +2.15600000E-05  -7.96000000E-05  -8.07300000E-05  +4.00000000E-08  +1.89100000E-05
   +7.57000000E-06  +3.61600000E-05  -5.59100000E-05  +3.46400000E-05  -8.57000000E-06
   -4.15000000E-06  +6.72500000E-05  +9.91700000E-05  +5.27400000E-05  +1.92800000E-05
   +5.69770000E-04  -2.11250000E-04  -9.01890000E-04  -8.90000000E-07  -6.51800000E-05
   +1.17990000E-04  +3.74630000E-04  -1.67200000E-05  +1.91120000E-04  -7.89520000E-04
   +9.43900000E-04  -9.20300000E-05  +3.06200000E-04  +2.52010000E-04  -2.44080000E-04
   +2.04150000E-03  +1.75885000E-03  -1.36313000E-03  +4.52498500E-02  -2.43672400E-02
   +5.47228500E-02  -4.99000000E-06  +4.62900000E-05  -3.05200000E-05  -6.73000000E-06
   -3.57200000E-05  +3.17900000E-05  -7.03000000E-06  +6.71000000E-06  +1.42000000E-05
   +3.17300000E-05  +2.54000000E-06  -1.71600000E-05  -1.26400000E-05  +6.37000000E-06
   +5.27700000E-05  +7.92000000E-06  -1.22300000E-05  -7.77000000E-06  -3.02000000E-06
   +2.15800000E-05  -2.48500000E-05  -1.50650000E-04  -1.17950000E-04  -4.09200000E-05
   -1.64300000E-05  +2.19300000E-05  -4.37000000E-06  +5.30300000E-05  +1.22370000E-04
   +7.29200000E-05  +2.25720000E-04  +1.31680000E-04  +9.84900000E-05  +3.94380000E-04
   +5.16060000E-04  -8.99980000E-04  +2.14088000E-03  +4.80240000E-04  +4.11420000E-04
   -2.18799000E-03  +4.80370000E-04  +8.41490000E-04  +2.30999000E-03  +2.22616000E-03
   +4.56052000E-03  -8.88100000E-04  +1.99900000E-05  -2.20920000E-04  -3.06685640E-01
   +1.65272200E-02  -2.72360150E-01  +2.11000000E-06  -1.02700000E-05  +4.08000000E-06
   -5.70000000E-07  -6.25000000E-06  -1.62000000E-06  -2.52800000E-05  -5.49000000E-06
   -2.61000000E-06  +9.70000000E-07  +4.80000000E-07  +9.62000000E-06  -1.74000000E-06
   +7.01000000E-06  -5.10000000E-07  +4.24000000E-06  +9.37000000E-06  +1.64100000E-05
   -2.00000000E-06  -7.75000000E-06  -6.90000000E-07  -9.28000000E-06  -5.17000000E-06
   -4.90000000E-06  -3.51000000E-06  +7.95000000E-06  -1.47700000E-05  +1.68900000E-05
   -4.05000000E-06  -7.79000000E-06  -4.77200000E-05  +1.61900000E-05  +3.93300000E-05
   -3.84700000E-05  -9.63900000E-05  +7.22600000E-05  +3.38100000E-05  -1.20020000E-04
   +4.76600000E-04  -4.09220000E-04  -1.54140000E-04  -1.04391000E-03  -3.11600000E-05
   +1.31880000E-04  +9.36300000E-05  +3.05310490E-01  +6.75000000E-06  +1.38800000E-04
   -8.60400000E-05  -4.05000000E-06  -1.28820000E-04  +7.97400000E-05  -2.53300000E-05
   +3.59200000E-05  +3.02900000E-05  +2.39000000E-05  -1.95000000E-06  +1.72000000E-05
   +4.00000000E-06  -1.42400000E-05  +3.68300000E-05  +3.33800000E-05  -1.29800000E-05
   -3.00000000E-06  +2.19700000E-05  +1.85100000E-05  -2.28500000E-05  +1.00360000E-04
   -1.79550000E-04  +3.08100000E-05  -2.63100000E-05  +7.59700000E-05  +2.16700000E-05
   -1.23400000E-05  +4.43400000E-05  -5.12000000E-06  +5.84690000E-04  -5.52300000E-05
   +4.23630000E-04  -7.75010000E-04  +1.49254000E-03  -9.26830000E-04  +1.55664000E-03
   -5.21266000E-03  -3.55561000E-03  -3.20162700E-02  -3.33998000E-03  -3.03617600E-02
   -2.29324000E-03  +1.53817000E-03  -5.24680000E-04  -2.19990000E-04  -6.42440000E-04
   -1.93060000E-04  +5.16627200E-02  -3.81689200E-02  +2.43454100E-02  -1.02700000E-05
   -3.05400000E-05  +1.43800000E-05  -2.80000000E-06  -5.65000000E-06  -1.32200000E-05
   -3.62600000E-05  -1.77500000E-05  -3.29000000E-06  -4.02000000E-06  -1.10400000E-05
   -2.73000000E-06  -6.91000000E-06  +5.95000000E-06  -3.54000000E-06  +1.92700000E-05
   +1.79100000E-05  +3.52300000E-05  -6.03000000E-06  -1.98600000E-05  -2.85000000E-06
   -7.53000000E-06  -9.42000000E-06  -1.09500000E-05  +2.45500000E-05  -1.05800000E-05
   -1.85300000E-05  +1.55200000E-05  -1.00200000E-05  -7.65000000E-06  -7.21000000E-06
   +2.54000000E-05  +3.22900000E-05  -1.97300000E-05  -3.41040000E-04  -1.23960000E-04
   -1.87120000E-04  -9.59300000E-05  +1.52020000E-04  +1.85126000E-03  -7.56480000E-04
   +8.71000000E-04  -3.75800000E-05  +1.16530000E-04  +7.70200000E-05  -2.02069800E-02
   +4.55550200E-02  +4.64000000E-06  +1.61700000E-04  -1.33700000E-04  -2.48700000E-05
   -1.28760000E-04  +1.08450000E-04  -4.01400000E-05  +3.25700000E-05  +1.16200000E-05
   +4.64000000E-06  +1.64200000E-05  -2.85000000E-06  +2.40200000E-05  +2.15000000E-06
   +1.23540000E-04  +4.44000000E-05  -3.40000000E-06  -1.39600000E-05  +2.62700000E-05
   +2.62000000E-05  -5.74200000E-05  -1.00500000E-05  -1.89620000E-04  -8.44700000E-05
   -2.74700000E-05  +7.16400000E-05  -1.51000000E-06  +3.47200000E-05  +8.95300000E-05
   +3.34800000E-05  +4.95260000E-04  +7.54000000E-06  +4.91230000E-04  -1.78983000E-03
   +3.09190000E-04  +2.41720000E-04  +1.17160000E-03  -4.55778000E-03  +2.14500000E-05
   -2.15922300E-02  -8.20000000E-06  -2.29700900E-02  +1.45865000E-03  +3.71499000E-03
   +3.06268000E-03  -3.77390000E-04  +3.36600000E-05  -9.83670000E-04  -2.48144020E-01
   -8.46775000E-03  -2.41318580E-01  -4.08000000E-06  -1.43800000E-05  +3.21100000E-05
   +1.81100000E-05  +1.72300000E-05  -1.28700000E-05  -3.64200000E-05  -2.64700000E-05
   +2.88400000E-05  +7.77000000E-06  -1.67000000E-05  +1.84000000E-06  -4.69000000E-06
   +1.02800000E-05  -3.24000000E-06  +1.95000000E-05  +2.23400000E-05  +3.35700000E-05
   -1.45900000E-05  -1.02000000E-05  -1.46800000E-05  +7.15000000E-06  -9.93000000E-06
   -1.18000000E-05  +1.32500000E-05  -2.19200000E-05  -1.23800000E-05  +1.23300000E-05
   +2.23000000E-06  -3.81500000E-05  -3.23600000E-05  +4.25400000E-05  +4.61100000E-05
   +1.25170000E-04  -1.93210000E-04  -1.99010000E-04  +4.30000000E-04  +2.15110000E-04
   -1.36100000E-05  +3.31670000E-04  -1.03613000E-03  +1.70000000E-04  -1.89300000E-05
   +2.10980000E-04  +1.07590000E-04  +2.67887920E-01  +9.69814000E-03  +2.61357750E-01
end_hess

