# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.91636870    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.59854958E+00  +9.21732305E-01  +2.17474867E+00
   006   +3.47468161E+00  -7.50627630E-01  -1.20709275E-01
   006   +2.81791459E+00  +7.22469276E-01  -2.46456233E+00
   006   +2.15231826E+00  +3.14163186E+00  -2.46814161E+00
   006   +2.02486839E+00  +4.62746248E+00  -1.11043601E-01
   006   +2.95053206E+00  +3.34525745E+00  +2.19029501E+00
   006   +1.54568074E+00  -3.01370759E+00  +2.53787067E-01
   006   +2.00384063E+00  -4.98505273E+00  -1.82717353E+00
   008   +1.26910788E+00  +6.79008492E+00  -7.02675996E-02
   008   +5.90060529E+00  -1.89108951E+00  -4.46032202E-01
   006   -1.15401096E+00  -1.97742549E+00  +1.67398005E-01
   006   -2.64927090E+00  -2.16968689E+00  -1.99338757E+00
   006   -5.05231613E+00  -1.15122171E+00  -2.11966094E+00
   006   -6.04341692E+00  +1.18414924E-01  -5.27106855E-02
   006   -4.60456218E+00  +3.26486629E-01  +2.12906383E+00
   006   -2.20597157E+00  -7.15203801E-01  +2.22176433E+00
   008   -8.40399119E+00  +1.09646415E+00  -2.61835920E-01
   006   +2.06513627E+00  -4.36293284E+00  +2.77180955E+00
   001   -8.84347250E+00  +1.96431306E+00  +1.26249741E+00
   001   -5.35233991E+00  +1.30488855E+00  +3.76588417E+00
   001   -1.14784937E+00  -5.00160557E-01  +3.95381384E+00
   001   -1.94238942E+00  -3.13303267E+00  -3.64832208E+00
   001   -6.17625988E+00  -1.32320016E+00  -3.81729542E+00
   001   +9.00182590E-01  -6.05808595E+00  +2.88070975E+00
   001   +4.04254607E+00  -4.92649917E+00  +2.88136671E+00
   001   +1.63269972E+00  -3.21665452E+00  +4.42141637E+00
   001   +1.91989173E+00  -4.21174541E+00  -3.73073410E+00
   001   +3.85783364E+00  -5.83674355E+00  -1.59222082E+00
   001   +5.79851600E-01  -6.46697927E+00  -1.68620912E+00
   001   +4.32380352E+00  +3.08699632E-02  +3.86820954E+00
   001   +3.07867876E+00  +4.49340181E+00  +3.87811412E+00
   001   +1.66840009E+00  +4.13052141E+00  -4.19114991E+00
   001   +2.92255624E+00  -3.18136235E-01  -4.22297646E+00
   001   +7.12315580E+00  -5.67977634E-01  -6.21236003E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.00000000E-08  +3.00000000E-07  -5.40000000E-07
   -5.50000000E-07  -1.50000000E-07  -1.00000000E-07
   +5.20000000E-07  -9.20000000E-07  -6.50000000E-07
   +8.60000000E-07  -9.20000000E-07  -1.47000000E-06
   +8.10000000E-07  -7.70000000E-07  -1.98000000E-06
   +4.90000000E-07  +2.60000000E-07  -1.54000000E-06
   -1.60000000E-07  -1.00000000E-07  +1.00000000E-06
   -4.60000000E-07  -8.80000000E-07  +1.48000000E-06
   +8.40000000E-07  +1.10000000E-07  -2.68000000E-06
   -3.00000000E-08  -9.80000000E-07  +3.40000000E-07
   -4.00000000E-07  +2.00000000E-07  +5.00000000E-07
   -2.20000000E-07  -8.60000000E-07  +6.70000000E-07
   -1.60000000E-07  -1.80000000E-07  +1.10000000E-07
   -9.00000000E-08  +8.10000000E-07  -3.70000000E-07
   +1.90000000E-07  +1.33000000E-06  -2.00000000E-07
   -3.90000000E-07  +9.50000000E-07  +8.00000000E-08
   +3.70000000E-07  +8.40000000E-07  -6.50000000E-07
   -3.00000000E-07  +7.10000000E-07  +1.30000000E-06
   +4.30000000E-07  +1.50000000E-06  -9.50000000E-07
   +3.10000000E-07  +1.93000000E-06  -8.30000000E-07
   +6.60000000E-07  +1.66000000E-06  -1.00000000E-07
   -4.00000000E-07  -1.01000000E-06  +9.40000000E-07
   -3.00000000E-08  -6.10000000E-07  +3.30000000E-07
   -5.80000000E-07  +9.90000000E-07  +1.95000000E-06
   -5.80000000E-07  +6.10000000E-07  +1.51000000E-06
   -5.20000000E-07  +1.24000000E-06  +8.20000000E-07
   -3.70000000E-07  -1.68000000E-06  +1.35000000E-06
   -6.60000000E-07  -9.90000000E-07  +1.83000000E-06
   -8.80000000E-07  -5.80000000E-07  +2.04000000E-06
   +9.00000000E-08  +9.80000000E-07  -5.00000000E-07
   +6.30000000E-07  +9.40000000E-07  -1.95000000E-06
   +5.90000000E-07  -1.83000000E-06  -1.63000000E-06
   +3.00000000E-08  -1.82000000E-06  -1.00000000E-08
   -6.00000000E-08  -1.08000000E-06  -9.00000000E-08
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.55216020E-01  -1.82408930E-01  +8.12803350E-01  +1.15790520E-01  -3.21551100E-02
   +5.70355570E-01  -7.21612200E-02  -1.35031000E-03  -8.77750000E-03  +4.17000800E-01
   -1.17514200E-02  -1.13811120E-01  -4.37729400E-02  -2.90340600E-02  +4.64067510E-01
   -2.19144100E-02  -5.00449400E-02  -1.76091930E-01  +2.30303500E-02  +9.42747000E-03
   +5.33579840E-01  +3.33566000E-03  -2.21726000E-03  -5.74619000E-03  -7.32908000E-02
   +2.69244000E-03  -1.47548800E-02  +2.18728480E-01  -6.31703000E-03  +1.36660800E-02
   -1.39278400E-02  +1.30229000E-02  -1.07842530E-01  +4.16983500E-02  -1.68242000E-01
   +8.20353610E-01  -7.00508000E-03  +1.11637600E-02  -3.51769700E-02  -2.68596800E-02
   +3.80655800E-02  -1.81728020E-01  +2.39275000E-02  +7.32828000E-02  +5.94630150E-01
   -1.64980000E-04  +8.16200000E-04  +1.31093000E-03  +5.09239000E-03  +1.09422200E-02
   -4.02203000E-03  -8.83905700E-02  +1.29000530E-01  -7.09554000E-03  +1.85420360E-01
   +3.86940000E-04  -3.32992000E-03  -4.56132000E-03  +4.72752000E-03  -1.57114700E-02
   +2.51744000E-03  +1.26999110E-01  -5.19080640E-01  -6.06851000E-03  -1.99883990E-01
   +8.06276110E-01  +1.09955000E-03  -1.77882000E-03  -1.11212000E-03  -5.35476000E-03
   +2.31891200E-02  +5.64481000E-03  -1.02569200E-02  +8.42801000E-03  -1.26266270E-01
   +7.77542200E-02  -5.27210700E-02  +6.18624530E-01  -3.01060000E-04  +1.26008200E-02
   -3.27776000E-03  -1.43603700E-02  -7.19931000E-03  +4.59226000E-03  +2.58808000E-03
   +7.38360000E-03  +8.14618000E-03  -8.24757200E-02  -3.01300000E-04  -8.34758000E-03
   +2.94256880E-01  +1.38697500E-02  -2.45652500E-02  +2.45129200E-02  -1.82848000E-03
   +3.12420000E-04  +1.03688000E-03  +5.55846000E-03  -2.88339900E-02  -2.40241100E-02
   +4.50770000E-04  -9.91704800E-02  -3.56567500E-02  -2.29550880E-01  +8.76617460E-01
   -8.71810000E-04  +1.75763200E-02  +1.64486600E-02  +4.96371000E-03  +1.06164000E-03
   +1.09929400E-02  +4.48970000E-03  -1.77077800E-02  +1.67217600E-02  -9.24226000E-03
   -2.66469200E-02  -2.13536470E-01  +5.23372000E-02  +2.73070800E-02  +5.33759750E-01
   -8.92775900E-02  +1.21558180E-01  -1.78201100E-02  +8.09771000E-03  +3.56144000E-03
   +3.42198000E-03  -9.87030000E-04  +1.27814000E-03  -1.43628000E-03  +1.50715400E-02
   +1.44030000E-03  -3.84568000E-03  -9.18016600E-02  +9.31849000E-03  -3.51966900E-02
   +1.89515610E-01  +1.24570640E-01  -5.22486450E-01  -2.15708000E-03  +4.47958000E-03
   -1.92475500E-02  -2.75000000E-03  +1.64681000E-03  -2.78860000E-03  +4.30203000E-03
   -1.99819000E-03  +1.98452300E-02  -1.15787200E-02  +5.25307000E-03  -9.41511000E-02
   +1.51749400E-02  -1.68496350E-01  +8.23462060E-01  -1.43607600E-02  -1.62670300E-02
   -1.23273330E-01  +4.19718000E-03  -2.30716200E-02  +5.24260000E-03  -1.11253000E-03
   +1.50427000E-03  -5.82300000E-04  -1.19089400E-02  +7.55623000E-03  -2.93639100E-02
   -3.51556200E-02  +2.27879100E-02  -2.07439120E-01  +9.19285900E-02  +9.94091000E-02
   +5.96760810E-01  +1.64568000E-03  -9.18147000E-03  -7.64317000E-03  -6.93555700E-02
   +1.01694000E-03  -1.62070000E-04  +8.59274000E-03  -2.20538000E-03  +7.00661000E-03
   -2.98160000E-03  +1.55318000E-03  -3.64040000E-04  +1.94726000E-03  -1.76619000E-03
   -4.21600000E-05  -3.09828000E-03  +2.12475000E-03  +1.08750000E-04  +4.57647240E-01
   -1.12766400E-02  -2.19173000E-02  -4.66451000E-03  -2.96938500E-02  -9.25081800E-02
   +5.36828000E-03  -7.49342000E-03  -1.91948800E-02  +1.05241400E-02  -6.95350000E-04
   +1.54593000E-03  +1.02488000E-03  -1.30350000E-04  -1.59418000E-03  -2.09130000E-04
   -1.35481000E-03  +1.28260000E-03  -1.22082000E-03  -4.34779000E-02  +4.50500010E-01
   -1.58253600E-02  -1.79204500E-02  +7.28396000E-03  +2.06840000E-03  +1.77556000E-03
   -7.70706800E-02  +1.70185100E-02  +2.27074300E-02  -2.88627000E-03  -7.04620000E-04
   +9.63240000E-04  -3.02093000E-03  -7.45890000E-04  +9.75000000E-05  -3.16655000E-03
   +3.63760000E-04  -1.88976000E-03  -2.89512000E-03  +5.65035000E-03  +1.07133900E-02
   +4.88937880E-01  -3.17864000E-03  -2.15214000E-03  +2.86485000E-03  +8.71770000E-04
   -1.74349100E-02  -1.57191300E-02  +7.75500000E-05  +4.33400000E-04  -2.97370000E-04
   +1.54210000E-04  -2.11110000E-04  -4.41120000E-04  -9.15030000E-04  +6.13900000E-04
   -7.34260000E-04  +5.37090000E-04  -1.01731000E-03  -6.00630000E-04  -7.85732800E-02
   +1.07694700E-02  +9.33074000E-03  +5.94888930E-01  -2.28243000E-03  -1.81405000E-03
   +2.51891000E-03  -4.17947000E-03  -2.44876400E-02  -1.90210000E-02  +3.14190000E-04
   -7.69250000E-04  +1.76420000E-04  -2.34850000E-04  +1.64240000E-04  -5.42820000E-04
   -5.12350000E-04  +2.72320000E-04  -8.22140000E-04  +1.87780000E-04  -6.25070000E-04
   -4.32990000E-04  +1.24013800E-02  -1.19234860E-01  -4.79545900E-02  +1.13592100E-02
   +5.19732520E-01  +1.34024000E-03  +6.86840000E-04  -1.04358000E-03  -3.86349000E-03
   -1.93467000E-03  +2.69732000E-03  -9.81800000E-05  +1.81320000E-04  +1.99861000E-03
   -2.17590000E-04  -1.22390000E-04  -9.69820000E-04  +4.03680000E-04  -1.97560000E-04
   +6.99070000E-04  -2.76860000E-04  +4.14400000E-04  +2.30340000E-04  +1.01289200E-02
   -4.41423200E-02  -1.28142850E-01  +1.49080900E-02  -6.27024600E-02  +5.41144970E-01
   +6.90030000E-04  -1.60410000E-03  -4.84581000E-03  +2.19323000E-03  +5.83030000E-04
   -1.07897000E-03  +2.29323000E-03  -1.57507000E-03  +1.57319000E-03  +1.66231900E-02
   +1.94842000E-02  +6.12375000E-03  -1.39446790E-01  +2.03377670E-01  -3.13526000E-03
   +8.72272000E-03  +3.43423600E-02  -8.86271000E-03  -9.46460000E-04  -2.71310000E-04
   +3.10730000E-04  +4.38060000E-04  +2.48830000E-04  -8.44300000E-05  +1.17242060E-01
   +1.12777000E-03  +7.10687000E-03  +8.06493000E-03  -1.14534000E-03  +1.09670000E-04
   -1.87040000E-04  -1.66072000E-03  +6.75150000E-03  -9.17824000E-03  +2.32243400E-02
   -5.65884700E-02  -2.29032200E-02  +2.03931810E-01  -6.49119180E-01  -1.27354400E-02
   +2.88772700E-02  -5.09940400E-02  +1.97451800E-02  +2.03206000E-03  +1.03501000E-03
   -2.35670000E-04  -7.64850000E-04  -3.95010000E-04  +7.39900000E-05  -2.53221340E-01
   +7.47424690E-01  -2.65823000E-03  +8.07200000E-05  -7.74030000E-03  -1.21106000E-03
   -1.15970000E-04  -4.24361000E-03  -4.35260000E-04  -7.10930000E-04  -8.41683000E-03
   +1.44649200E-02  -4.73459300E-02  +1.12295200E-02  -3.31579000E-03  -1.23911700E-02
   -1.07849280E-01  -1.68930700E-02  +4.36269800E-02  +1.34397000E-02  +3.34600000E-05
   +1.02840000E-04  +9.76910000E-04  +2.04710000E-04  +2.41780000E-04  -2.66510000E-04
   +6.44843000E-03  +1.59833000E-02  +9.09064500E-02  -1.90369700E-02  +1.53861200E-02
   +7.28226000E-03  -1.73195700E-01  +6.57417100E-02  +1.51641200E-02  -2.83022200E-02
   +1.92953500E-02  -2.84400000E-05  -1.79470000E-04  +5.87800000E-04  -4.25679000E-03
   -2.14818000E-03  -1.55125000E-03  -1.22438000E-03  +1.48889000E-03  -1.11420000E-04
   +3.78074000E-03  -3.87767000E-02  +8.84676000E-03  +4.77888000E-03  -5.01800000E-04
   -3.05790000E-04  +2.81220000E-04  +5.37200000E-05  +8.66610000E-04  +4.88670000E-04
   +5.15844110E-01  +3.26667000E-02  -1.89833400E-02  -9.80280000E-03  +3.18957100E-02
   -1.08489620E-01  -4.33640000E-03  +3.05427400E-02  -1.59982900E-02  +3.85940000E-04
   +1.32330000E-04  +6.70940000E-04  +3.66245000E-03  +2.08092000E-03  +2.32949000E-03
   -8.78480000E-04  -1.08433000E-03  +1.80020000E-04  -3.70846000E-03  -2.53479000E-02
   +8.46447000E-03  +2.92143000E-03  -7.53990000E-04  -2.27811000E-03  -6.43920000E-04
   +1.23330000E-04  -1.27164000E-03  +1.72780000E-04  +1.65180640E-01  +4.58678480E-01
   +3.35251100E-02  -1.87722200E-02  -3.02587000E-03  +1.45737400E-02  -8.62055000E-03
   -6.63347700E-02  -2.69926300E-02  +1.39240000E-02  +7.83362000E-03  -8.05510000E-04
   +3.39053000E-03  -3.23180000E-04  -1.68345000E-03  -4.16040000E-04  -1.03306900E-02
   +3.25360000E-04  -3.69992000E-03  -1.07281000E-03  +6.57676000E-03  -2.01339000E-03
   +1.66142000E-03  -1.19440000E-03  -1.32963000E-03  -1.59370000E-04  +5.99690000E-04
   +4.85600000E-05  +3.26042000E-03  -6.28557400E-02  -2.28454300E-02  +6.77584800E-02
   -1.48130000E-04  -2.61300000E-05  -6.79560000E-04  -2.78881200E-02  +8.17720000E-04
   +5.48610000E-04  -3.19030000E-04  -1.11069000E-03  +1.23047000E-03  -1.36195000E-03
   +2.61240000E-04  +1.22490000E-04  +6.94880000E-04  -2.24390000E-04  +1.59800000E-04
   +9.12000000E-06  +6.22690000E-04  -3.27000000E-05  -1.60972990E-01  +3.62666400E-02
   -4.10414000E-03  -7.93200000E-03  +6.74341000E-03  +4.64716000E-03  -2.77960000E-04
   +4.74740000E-04  -1.36500000E-05  -1.92847000E-03  -2.69850000E-03  +2.99380000E-04
   +5.69249690E-01  -6.47860000E-04  +1.05750000E-04  +2.19010000E-04  -1.40144900E-02
   +1.26323400E-02  -1.76374000E-03  -1.54221000E-03  -3.36270000E-04  +3.85360000E-04
   -1.19214000E-03  -1.06507000E-03  +1.41840000E-04  -4.24290000E-04  +7.52110000E-04
   +2.09590000E-04  -3.03370000E-04  -4.60300000E-04  +7.50200000E-05  +3.08252700E-02
   -8.74035400E-02  -6.09599000E-03  +2.31768800E-02  -1.10364700E-02  -1.50105000E-03
   +2.96820000E-04  -6.55380000E-04  -2.98900000E-05  -5.90549000E-03  -3.94032000E-03
   +1.01401000E-03  -1.35508290E-01  +2.95485160E-01  -6.97920000E-04  -3.28700000E-05
   -2.32610000E-04  +2.52818000E-03  -1.85415000E-03  -1.06581000E-03  +1.56590000E-03
   +1.42811000E-03  -7.90200000E-05  +1.06004000E-03  +3.67230000E-04  -4.63900000E-05
   -2.66800000E-05  -1.70050000E-04  -7.18150000E-04  -2.11700000E-04  +1.51380000E-04
   +2.36010000E-04  -5.37874000E-03  -5.74521000E-03  -9.03652800E-02  +2.41999800E-02
   -8.80570000E-03  +1.40036000E-03  -4.04600000E-05  +2.83000000E-05  +2.56000000E-04
   +9.92960000E-04  +8.21730000E-04  +7.39110000E-04  +5.78481300E-02  +1.44086890E-01
   +6.16829720E-01  -8.06700000E-05  -1.95000000E-06  -1.70300000E-04  +2.21000000E-06
   +1.39999000E-03  -3.27970000E-04  -1.59044000E-03  -1.07049000E-03  +3.94400000E-05
   -5.08910000E-04  -1.58400000E-04  -2.00800000E-05  +1.34190000E-04  -8.39400000E-05
   +7.05610000E-04  +3.54400000E-05  -7.52900000E-05  -3.44200000E-04  -1.75784900E-02
   +3.25310000E-04  -2.33888200E-02  -2.42372000E-03  -7.97000000E-06  -5.02050000E-04
   -7.36600000E-05  +7.76000000E-06  -2.33270000E-04  -2.93290000E-04  -3.53440000E-04
   +3.43400000E-05  -1.81113500E-01  +2.28667900E-02  -6.40089600E-02  +6.24339500E-01
   +8.94300000E-05  +8.59900000E-05  -1.04190000E-04  -1.60420000E-04  -1.47336000E-03
   +5.98270000E-04  -1.11328000E-03  -5.19130000E-04  +3.49530000E-04  -5.52970000E-04
   -2.31100000E-05  -1.67560000E-04  +1.06720000E-04  +1.54230000E-04  +2.86460000E-04
   +8.18300000E-05  +1.85310000E-04  -1.17870000E-04  +6.74530000E-03  +2.82003000E-03
   +1.01514500E-02  +1.58709000E-03  -3.35640000E-04  +1.34273000E-03  +9.69000000E-06
   -6.28200000E-05  -6.21200000E-05  +2.25310000E-04  +3.35910000E-04  -6.31400000E-05
   +3.30020000E-04  -8.42882600E-02  -4.57601200E-02  -1.92406870E-01  +3.01201910E-01
   -1.16900000E-05  -2.44810000E-04  -2.49470000E-04  +9.18620000E-04  -8.63000000E-05
   -8.08700000E-05  +8.55400000E-05  +5.45540000E-04  +6.54890000E-04  +7.82480000E-04
   +2.75100000E-04  -9.26900000E-05  +1.17490000E-04  -6.18980000E-04  -1.81600000E-04
   -4.03100000E-05  -9.49000000E-05  -1.07480000E-04  -5.57773000E-03  +3.65893000E-03
   +5.33204000E-03  -5.49590000E-04  -2.59780000E-04  +3.99590000E-04  -1.63180000E-04
   +3.75240000E-04  +1.22900000E-05  +9.62270000E-04  +2.17540000E-04  -3.40860000E-04
   -1.24388020E-01  -1.82634000E-02  -2.48793130E-01  +4.32294400E-02  +1.82169770E-01
   +6.53251610E-01  -1.05420000E-04  +1.13620000E-04  +3.72290000E-04  +1.16000000E-06
   +1.58350000E-04  -4.93270000E-04  +2.60140000E-04  +3.53650000E-04  -1.43520000E-04
   +4.42210000E-04  +3.71300000E-05  +1.74310000E-04  -1.98690000E-04  +3.07360000E-04
   -7.55970000E-04  -3.97300000E-05  -6.84000000E-06  +2.55630000E-04  +2.53333000E-03
   +7.73220000E-04  -3.16758000E-03  +1.40830000E-04  -3.49940000E-04  -1.42360000E-04
   +1.47370000E-04  -2.19410000E-04  +2.22920000E-04  -3.69640000E-04  -1.10420000E-04
   +2.78760000E-04  -3.08068400E-02  -9.87557000E-03  -6.84606400E-02  -3.13324570E-01
   +1.15426620E-01  +1.17537700E-02  +6.49245250E-01  -1.60000000E-06  -2.18130000E-04
   -3.75720000E-04  +1.05083000E-03  -8.39100000E-04  +4.93440000E-04  -1.20540000E-04
   -5.07050000E-04  +8.11400000E-05  -3.77220000E-04  +1.84200000E-05  -7.00300000E-05
   +1.88360000E-04  -2.11620000E-04  +5.91080000E-04  -7.57700000E-05  +1.22210000E-04
   -1.63020000E-04  +8.33210000E-04  +5.13164000E-03  -2.96595000E-03  +4.59680000E-04
   -1.89350000E-04  +9.94100000E-05  -1.44050000E-04  +1.77000000E-04  -1.94250000E-04
   +7.16040000E-04  +5.00190000E-04  -2.03910000E-04  +7.46230000E-03  +1.92131600E-02
   +4.01329900E-02  +9.23390400E-02  -1.12628860E-01  -3.02889000E-02  -1.89857240E-01
   +2.80522740E-01  -1.58500000E-05  -2.22550000E-04  -1.19590000E-04  -1.04940000E-04
   +2.23140000E-04  -2.56670000E-04  -1.08610000E-04  -1.17350000E-04  -6.21000000E-05
   +1.30200000E-05  +6.45800000E-05  +1.44050000E-04  -5.45000000E-05  -2.44280000E-04
   -4.15290000E-04  -1.77760000E-04  +2.86600000E-05  +8.53500000E-05  -2.32123000E-03
   -2.52016000E-03  -3.17271000E-03  +1.17037000E-03  -4.43510000E-04  -4.04230000E-04
   -8.73000000E-06  +2.15850000E-04  +1.46420000E-04  +1.41410000E-04  +1.57000000E-05
   +1.19830000E-04  -2.31469000E-02  +1.83950200E-02  +3.11483000E-02  -5.05679900E-02
   -1.90303000E-03  -1.25527130E-01  +1.06639260E-01  +1.66144080E-01  +6.66701380E-01
   +1.84190000E-04  +1.41990000E-04  -3.32730000E-04  -4.35590000E-04  -8.99010000E-04
   +1.22030000E-04  +2.22400000E-05  -2.86000000E-06  +3.22780000E-04  +3.23100000E-04
   +2.34040000E-04  +3.12010000E-04  +1.23610000E-04  -1.56252000E-03  -2.07850000E-04
   +2.09160000E-04  +8.59100000E-05  -1.76600000E-04  -1.81218000E-03  +8.63860000E-04
   -1.62100000E-05  +4.29180000E-04  +4.83500000E-05  +3.30810000E-04  -3.41110000E-04
   +1.24875000E-03  +2.78200000E-05  +1.30021000E-03  +3.46620000E-04  -1.32440000E-04
   +2.89477000E-03  -6.90253000E-03  -6.00593000E-03  -1.26803600E-02  +1.82754100E-02
   +2.97581300E-02  -1.37910250E-01  +5.99016100E-02  +7.57659300E-02  +6.32981420E-01
   -2.59200000E-05  +2.35490000E-04  +2.28170000E-04  -2.49300000E-05  +5.71700000E-04
   -2.27300000E-04  +1.85580000E-04  +2.29690000E-04  -1.46430000E-04  +1.16340000E-04
   -1.54810000E-04  -1.23500000E-04  -1.35660000E-04  +7.43080000E-04  -4.96500000E-05
   +1.05590000E-04  -6.40100000E-05  +5.11500000E-05  +4.80450000E-04  -9.07440000E-04
   -4.41930000E-04  -2.76400000E-05  +6.05300000E-05  -1.95460000E-04  +2.56320000E-04
   -5.86940000E-04  +3.08400000E-05  -5.89270000E-04  -2.72950000E-04  +1.27860000E-04
   -6.68972000E-03  -1.29792900E-02  -2.57672600E-02  +3.88790000E-02  -1.40907700E-02
   +4.62656000E-03  +3.25521000E-02  -1.30147470E-01  -1.10438060E-01  -1.86411500E-01
   +3.16365920E-01  -1.24080000E-04  +2.06360000E-04  +3.20250000E-04  -1.15460000E-04
   -5.40820000E-04  -2.08780000E-04  -2.09770000E-04  +4.32700000E-05  +5.72300000E-05
   +2.23770000E-04  +2.08420000E-04  +1.08940000E-04  -1.97850000E-04  +1.66420000E-04
   -2.88970000E-04  +3.55700000E-05  +3.45900000E-05  +6.49300000E-05  -3.24810000E-04
   -1.14410000E-04  -1.66188000E-03  +1.33260000E-04  +7.22400000E-05  +2.11530000E-04
   +1.43630000E-04  -4.62000000E-06  +3.94600000E-05  +3.97000000E-05  +1.21780000E-04
   +1.09010000E-04  -6.01989000E-03  -2.61486500E-02  -7.86060300E-02  +8.14430200E-02
   -1.98836500E-02  +4.68382200E-02  +6.45445000E-03  -7.96778500E-02  -2.62218050E-01
   +6.39698600E-02  +1.69695320E-01  +6.61064740E-01  +1.02630000E-04  -1.69590000E-04
   -1.61030000E-04  +2.09440000E-04  +7.85680000E-04  +1.01200000E-04  +2.48530000E-04
   +8.30700000E-05  -2.19290000E-04  -2.24590000E-04  -3.66260000E-04  -1.83810000E-04
   -2.23430000E-04  +3.66230000E-04  +5.27660000E-04  -7.50600000E-05  -1.57430000E-04
   -1.07700000E-04  +3.47065000E-03  +1.44411000E-03  +8.61270000E-04  -7.58870000E-04
   -3.17000000E-06  -2.91420000E-04  +1.45760000E-04  -3.95210000E-04  -1.58740000E-04
   -3.64250000E-04  -3.12730000E-04  -1.40590000E-04  -1.19503500E-02  +3.80967500E-02
   +7.22802500E-02  -5.41588600E-02  +1.04842300E-02  -3.34680900E-02  +5.69374000E-02
   -3.10847400E-02  -2.46021900E-02  -1.70494370E-01  +2.45464900E-02  -5.18312100E-02
   +6.24301600E-01  +8.17800000E-05  -2.76750000E-04  -3.62000000E-06  +6.23460000E-04
   -8.08630000E-04  -2.90280000E-04  +2.18930000E-04  +2.21600000E-05  +7.14600000E-05
   +2.73740000E-04  +2.06700000E-04  +7.07000000E-05  +3.98230000E-04  -3.28980000E-04
   -6.91300000E-04  -4.29700000E-04  +1.08300000E-04  +2.76110000E-04  +1.30406000E-03
   +3.95699000E-03  -3.59522000E-03  +2.20070000E-04  +1.60210000E-04  -1.32000000E-06
   -2.97400000E-04  +2.29420000E-04  +2.02780000E-04  +3.37430000E-04  +4.35800000E-04
   +1.11430000E-04  +1.82676700E-02  -8.10001000E-03  -2.03436900E-02  +1.12773000E-02
   -5.83601000E-03  +7.81142000E-03  -1.48608800E-02  +1.12359600E-02  -1.02119800E-02
   -3.78049000E-03  -8.94493500E-02  -5.58231600E-02  -2.03496200E-01  +2.89150090E-01
   +6.01000000E-05  -8.60800000E-05  -1.41010000E-04  -4.14200000E-04  +5.92770000E-04
   +4.18600000E-05  +2.88600000E-05  -9.25600000E-05  -1.65740000E-04  -2.53430000E-04
   -6.36100000E-05  +1.43370000E-04  -2.19420000E-04  +5.21830000E-04  -2.19310000E-04
   -3.50200000E-05  -1.41650000E-04  +3.56360000E-04  +8.42300000E-05  -4.23783000E-03
   -3.67508000E-03  +1.34845000E-03  -5.54810000E-04  +1.63730000E-04  +1.91070000E-04
   -4.65460000E-04  +3.59900000E-05  -5.23700000E-04  -2.43450000E-04  +9.81200000E-05
   +2.55564300E-02  +1.70139000E-03  +3.78756300E-02  -2.90207000E-02  +6.09810000E-03
   -2.17451100E-02  +1.68565400E-02  -2.85327400E-02  -4.52416200E-02  -1.25321550E-01
   -2.35208800E-02  -2.71646750E-01  +5.35890500E-02  +1.84021110E-01  +6.56284580E-01
   -2.04017000E-03  -1.01112000E-03  +6.60160000E-04  +1.87910000E-04  +5.73210000E-04
   +2.24340000E-04  -1.06210000E-04  +2.36960000E-04  +3.58300000E-05  +5.87310000E-04
   +1.51440000E-04  -7.27000000E-06  +2.60110000E-04  -5.03030000E-04  -6.22620000E-04
   -1.26553000E-03  -1.73740000E-04  +2.17750000E-04  -1.19996100E-02  +1.63182700E-02
   +2.33218800E-02  -4.81199000E-03  +7.24040000E-04  -1.80708000E-03  -2.83580000E-04
   +2.84260000E-04  +1.79430000E-04  -7.00100000E-05  -6.06900000E-05  -3.04200000E-05
   -1.51320470E-01  +4.25583500E-02  +2.11459700E-02  +5.87483000E-02  -1.59882700E-02
   +1.93660500E-02  -4.22836400E-02  +2.64809000E-02  +2.29397400E-02  -3.30613700E-02
   -1.40725400E-02  -7.72997700E-02  -3.06256660E-01  +1.16634960E-01  +1.43451600E-02
   +6.31699220E-01  -1.15553000E-03  -5.59290000E-04  +4.43770000E-04  -6.71800000E-04
   -1.01412000E-03  -1.18550000E-04  -6.90500000E-05  -4.46740000E-04  -9.40000000E-05
   -7.88320000E-04  -8.72000000E-05  -7.32800000E-05  -2.22020000E-04  +5.03900000E-04
   +6.28270000E-04  -8.01910000E-04  +9.66000000E-05  +8.56900000E-05  +8.63153000E-03
   -5.36723000E-03  -6.63337000E-03  +1.78675000E-03  -2.19010000E-04  -9.17000000E-05
   +1.84430000E-04  -2.46040000E-04  -2.24850000E-04  -3.20690000E-04  +1.91640000E-04
   -1.55310000E-04  +6.73819200E-02  -1.25961570E-01  -7.48347300E-02  -3.43446300E-02
   +1.09305700E-02  -3.44082500E-02  +2.80925100E-02  -2.19553200E-02  -1.58655100E-02
   +5.95450000E-03  +1.82699400E-02  +4.86806800E-02  +9.13218800E-02  -1.13550380E-01
   -3.10697700E-02  -1.74460490E-01  +2.82945190E-01  +1.48010000E-04  +7.45830000E-04
   +3.75040000E-04  -7.54730000E-04  +4.87480000E-04  +2.28580000E-04  +1.45280000E-04
   -1.15980000E-04  -4.96370000E-04  -5.32640000E-04  -3.87730000E-04  -3.86960000E-04
   +4.99490000E-04  -1.28590000E-04  +1.80411000E-03  +9.38600000E-04  +2.88020000E-04
   -1.04442000E-03  +5.56465000E-03  -5.56400000E-04  +7.00673000E-03  -2.37994000E-03
   +9.00140000E-04  +7.92700000E-05  -1.57510000E-04  +1.72050000E-04  -5.23970000E-04
   -6.87160000E-04  -5.21980000E-04  -2.16780000E-04  +8.09772500E-02  -1.01227210E-01
   -2.41296650E-01  -2.76963400E-02  -1.18813300E-02  -5.59567100E-02  +2.54986300E-02
   -1.68568700E-02  -1.69325900E-02  -2.53610500E-02  +2.45363900E-02  +3.58077900E-02
   -4.70354900E-02  -3.14403000E-03  -1.21424060E-01  +1.01953770E-01  +1.56146000E-01
   +6.62715350E-01  -1.23990000E-04  +1.02540000E-04  +4.85840000E-04  +3.73730000E-04
   +1.45268000E-03  -1.93260000E-04  +6.33000000E-06  +2.04370000E-04  -4.68160000E-04
   -2.20790000E-04  -3.42520000E-04  -2.79680000E-04  -3.69400000E-04  +1.79675000E-03
   +1.04570000E-04  -4.07300000E-05  -2.15460000E-04  +2.66010000E-04  +1.82571000E-03
   -1.52118000E-03  -1.09430000E-04  -7.50300000E-04  -7.18400000E-05  -4.48940000E-04
   +5.04990000E-04  -1.44301000E-03  -1.76200000E-05  -1.64965000E-03  -6.25340000E-04
   +2.10430000E-04  -3.84998000E-03  +2.24829000E-03  -3.68680000E-04  +4.30290000E-03
   +3.80000000E-05  -4.87540000E-04  -2.97333400E-02  +2.04008500E-02  +8.73664000E-03
   -2.76212490E-01  +8.31177700E-02  -5.05254300E-02  -4.03721800E-02  +1.96525400E-02
   -7.55730000E-03  +3.94359000E-03  +1.74800000E-04  -3.35293000E-03  +4.03592060E-01
   +5.82200000E-05  -9.69500000E-05  -2.44220000E-04  -1.47640000E-04  -6.37890000E-04
   +1.00550000E-04  -4.38300000E-05  -1.65100000E-04  +1.97550000E-04  +5.89700000E-05
   +2.28610000E-04  +1.99100000E-04  +3.24410000E-04  -1.10840000E-03  -5.68200000E-05
   +2.74000000E-06  +1.57270000E-04  -1.41130000E-04  -1.14331000E-03  +7.13100000E-05
   +4.01390000E-04  +3.38480000E-04  +2.28900000E-05  +1.69910000E-04  -4.31060000E-04
   +8.68080000E-04  +1.02800000E-05  +6.44230000E-04  +3.30040000E-04  -8.95000000E-05
   +1.44987000E-03  -1.23273000E-03  +2.96559000E-03  -2.27919000E-03  +4.16797000E-03
   -5.26754000E-03  +3.40017400E-02  -9.29042000E-03  -3.70907000E-03  +1.03253390E-01
   -9.22558000E-02  -2.72318000E-03  +6.45945000E-03  +7.22900000E-03  +2.22950000E-04
   +2.99646000E-03  +4.67540000E-03  -3.90330000E-03  -1.96110780E-01  +2.17602500E-01
   +1.62500000E-05  -4.84300000E-05  -1.36800000E-05  +5.90100000E-05  +2.47600000E-05
   -4.09800000E-05  +2.93500000E-05  -3.22000000E-06  -1.93400000E-05  -2.89000000E-06
   -5.04000000E-06  +2.72000000E-06  -4.40800000E-05  +9.16900000E-05  -1.45130000E-04
   -4.58400000E-05  -3.24600000E-05  +7.25400000E-05  +2.04630000E-04  +3.22550000E-04
   +2.69170000E-04  -5.16000000E-06  -1.94300000E-05  -6.09000000E-05  +4.70400000E-05
   -7.75900000E-05  +7.18600000E-05  +2.18000000E-06  +6.60000000E-07  +4.06200000E-05
   +5.61620000E-04  +2.79873000E-03  +6.52892000E-03  -6.86271000E-03  -2.09592000E-03
   -8.33122000E-03  +4.28427100E-02  -1.91732800E-02  +7.50461000E-03  -6.04932000E-03
   -2.26739000E-02  -1.04722300E-01  -4.23660600E-02  +1.55904300E-02  +1.60264000E-03
   +4.18916000E-03  -7.69365000E-03  -6.80968000E-03  -5.58608100E-02  +2.30395410E-01
   +4.99264630E-01  -7.37900000E-04  -7.59960000E-04  +1.25730000E-04  +3.98543000E-03
   -1.15733100E-02  +1.87131400E-02  -3.65872000E-03  -2.35523000E-03  -1.10586000E-03
   +5.87650000E-04  -7.33020000E-04  +6.07680000E-04  -2.60710000E-04  +6.75780000E-04
   +4.96710000E-04  +3.75650000E-04  -6.45200000E-05  +4.82900000E-04  -7.89393600E-02
   +9.29858000E-03  -1.48747200E-02  +1.26980000E-03  -1.82392000E-03  +4.95236000E-03
   +2.62330000E-04  -7.14980000E-04  -1.29380000E-04  -3.06790000E-04  +8.34430000E-04
   -5.18350000E-04  -1.02957200E-02  +1.54087900E-02  -3.01782900E-02  -2.83185000E-03
   +2.89690000E-03  +1.64615000E-03  -1.65079000E-03  -7.53220000E-04  -2.01530000E-04
   +5.84430000E-04  -4.61390000E-04  -6.27430000E-04  +3.08790000E-04  -4.08400000E-04
   -6.51660000E-04  -7.33370000E-04  +1.63594000E-03  -3.19460000E-04  -1.01967000E-03
   +4.38710000E-04  +6.37200000E-05  +5.84753510E-01  -4.04960000E-04  -2.14424000E-03
   +6.71720000E-04  -5.11200000E-04  -1.82706500E-02  +2.49300300E-02  -3.84936000E-03
   -2.59552000E-03  -1.50255000E-03  +4.52720000E-04  -6.70770000E-04  +6.51240000E-04
   -2.14990000E-04  +4.09110000E-04  +1.23879000E-03  -4.87100000E-05  +3.73390000E-04
   +3.96810000E-04  +9.26290000E-03  -9.57096900E-02  +3.88527000E-02  -2.70783000E-03
   +9.27723000E-03  -1.92574100E-02  +1.64680000E-04  -4.17690000E-04  -3.63390000E-04
   +7.10480000E-04  +1.55700000E-05  +8.34210000E-04  +5.83861000E-03  -6.38732000E-03
   +1.04639200E-02  +1.39650000E-04  -9.39800000E-04  -5.18870000E-04  +1.07680000E-04
   +3.25510000E-04  +2.17100000E-05  -7.55200000E-05  -7.42200000E-05  -2.97400000E-05
   -7.46700000E-05  +2.35910000E-04  +3.40800000E-04  +2.72170000E-04  +2.79510000E-04
   +3.29800000E-04  +3.52600000E-05  -1.13000000E-06  -2.01700000E-05  +1.12477600E-02
   +5.52177170E-01  +8.29960000E-04  -1.90740000E-04  +1.86090000E-03  +3.49340000E-03
   +6.19892000E-03  -4.56763000E-03  -9.81530000E-04  -1.73870000E-04  +3.27000000E-06
   +3.00580000E-04  -2.12010000E-04  +3.78100000E-05  -2.34490000E-04  +5.88200000E-05
   +5.63480000E-04  -6.51900000E-05  -1.22790000E-04  -7.95570000E-04  -1.36337100E-02
   +3.56175900E-02  -1.50593210E-01  -3.41586000E-03  +6.96476000E-03  -3.74472600E-02
   -3.96000000E-06  -1.13400000E-05  -1.87720000E-04  -2.70210000E-04  +1.08728000E-03
   -5.78880000E-04  -8.26890000E-03  +3.60081000E-03  -1.69572000E-03  +1.31624000E-03
   +8.65600000E-05  -9.53800000E-05  +1.49860000E-04  +2.84000000E-05  -9.84300000E-05
   -4.59910000E-04  +7.33700000E-05  +4.42600000E-05  +1.74060000E-04  -2.43340000E-04
   -4.31650000E-04  +9.17460000E-04  -1.30000000E-06  +3.76020000E-04  +5.36030000E-04
   -2.52300000E-04  -6.20400000E-05  -2.19561500E-02  +6.08167600E-02  +5.09497450E-01
   +1.96000000E-05  +4.91400000E-05  -3.17400000E-05  -1.33430000E-04  -6.44200000E-05
   +3.42100000E-05  +1.22500000E-05  +2.61800000E-05  +2.72800000E-05  +4.74100000E-05
   -5.83000000E-06  +1.79500000E-05  -7.84900000E-05  -5.16700000E-05  +3.02500000E-05
   +5.29900000E-05  -2.02400000E-05  -3.99600000E-05  -1.87600000E-04  +1.73400000E-05
   -1.10680000E-04  +7.88300000E-05  -4.21000000E-06  +3.97000000E-05  +8.43100000E-05
   +7.58000000E-05  -2.33800000E-05  +1.84970000E-04  -7.57000000E-06  -2.92000000E-05
   +2.28050000E-04  -3.82140000E-04  -7.54550000E-04  +9.89180000E-04  +9.00190000E-04
   +1.63036000E-03  -5.95453000E-03  +2.63159000E-03  -2.77125000E-03  -1.72782100E-02
   +2.41479600E-02  +4.04159400E-02  +2.48568000E-03  -9.02980000E-04  +1.73205000E-03
   -7.79790000E-04  +1.41450000E-04  +3.92530000E-04  -6.16319800E-02  +5.39259400E-02
   +6.28772600E-02  +8.12000000E-05  +8.49000000E-06  +1.53000000E-06  +8.25762100E-02
   -2.58600000E-05  +1.74900000E-05  +4.68800000E-05  +1.88300000E-05  +1.15150000E-04
   -2.91300000E-05  -6.28000000E-06  +4.02700000E-05  -4.17100000E-05  -9.30000000E-06
   -7.55100000E-05  -5.63000000E-05  -1.50970000E-04  +4.07570000E-04  -3.32000000E-06
   +3.50000000E-07  -5.90900000E-05  +6.24400000E-05  +1.34900000E-04  -1.01110000E-04
   +4.89000000E-05  -7.68400000E-05  +8.00000000E-06  -2.61400000E-05  +1.97540000E-04
   -3.02130000E-04  -1.26100000E-05  -1.00500000E-04  -8.60800000E-05  +1.92900000E-05
   -8.58300000E-05  +3.35180000E-04  +3.78620000E-04  +1.78020000E-04  +1.08485000E-03
   -1.37545000E-03  +3.10385000E-03  +1.25771000E-03  +1.06387000E-03  +5.32575000E-03
   -1.22210600E-02  -1.65869100E-02  -3.37467000E-03  +9.54080000E-04  +8.97450000E-04
   +1.26670000E-04  -8.24200000E-04  -3.53810000E-04  +7.42911700E-02  -1.26187580E-01
   -2.01642940E-01  -3.24800000E-05  -9.58000000E-06  +2.05700000E-05  -7.99149600E-02
   +1.35779060E-01  +6.36000000E-06  +1.61300000E-05  +1.53100000E-05  +3.18000000E-06
   +9.81200000E-05  +2.15600000E-05  +1.11200000E-05  -1.74000000E-06  -3.87200000E-05
   -2.28400000E-05  -1.25700000E-05  +5.02000000E-06  +4.12500000E-05  -1.71400000E-05
   +7.16500000E-05  +1.37600000E-05  +1.59900000E-05  -8.39000000E-06  +1.26910000E-04
   -1.37840000E-04  -9.56700000E-05  -1.37700000E-05  -1.76000000E-06  -3.43000000E-05
   -4.44200000E-05  +1.44000000E-06  -4.29400000E-05  -1.06340000E-04  -3.05300000E-05
   -9.13000000E-06  -2.57070000E-04  +2.10320000E-04  -2.67600000E-05  +4.73300000E-05
   -7.39950000E-04  +7.44500000E-05  -1.41854000E-03  +4.99170000E-04  +2.05389000E-03
   -1.47903000E-03  +2.40147000E-03  +9.62190000E-04  -4.14319000E-03  +3.55755000E-03
   +3.26692000E-03  +1.72270000E-04  -1.30370000E-04  -9.37350000E-04  +1.08191470E-01
   -2.22144690E-01  -3.98525840E-01  -7.81200000E-05  +2.65500000E-05  +6.47700000E-05
   -1.01374670E-01  +2.16761120E-01  +3.93923870E-01  -3.20400000E-05  +4.79900000E-05
   +6.57300000E-05  +7.91200000E-05  +1.77350000E-04  +1.30100000E-05  -4.03000000E-05
   +2.15400000E-05  -6.88100000E-05  -2.12100000E-05  -7.79100000E-05  -4.69000000E-05
   -1.34870000E-04  +2.86850000E-04  +1.35470000E-04  +4.50500000E-05  -3.11400000E-05
   +3.76900000E-05  +3.39090000E-04  +5.96290000E-04  +1.11538000E-03  -5.00020000E-04
   +5.87900000E-05  -9.95700000E-05  +1.54550000E-04  -1.95610000E-04  -9.44800000E-05
   -1.07410000E-04  -1.11450000E-04  -2.37000000E-05  -3.47959000E-03  +3.79426000E-03
   -2.10307000E-03  -1.21781000E-03  -1.07080000E-04  -6.53690000E-04  -4.98300000E-04
   +1.15927000E-03  -3.97314000E-03  +7.74176000E-03  -7.07274000E-03  -1.40213900E-02
   -9.08576700E-02  +5.55761500E-02  +7.49877600E-02  -6.14516000E-03  +1.37338300E-02
   +2.51320700E-02  +2.41003000E-03  -2.77326000E-03  +3.34290000E-04  +2.48500000E-05
   -7.19600000E-05  +1.12840000E-04  -4.36610000E-04  +7.12910000E-04  +5.37130000E-04
   +9.23175600E-02  -3.62100000E-05  -2.47100000E-05  -1.05900000E-05  -7.29500000E-05
   -1.18090000E-04  +1.64200000E-05  -1.48000000E-05  -1.94300000E-05  +2.26700000E-05
   +4.41000000E-06  -7.61000000E-06  +1.70000000E-05  -1.03220000E-04  +9.68000000E-05
   -3.40000000E-06  -2.46000000E-06  -1.69100000E-05  +2.49300000E-05  -5.33400000E-05
   +1.35940000E-04  -7.72230000E-04  +1.34870000E-04  +3.33400000E-05  +1.32150000E-04
   +1.03460000E-04  -3.91500000E-05  -2.46500000E-05  +1.21450000E-04  +1.45300000E-05
   -5.64000000E-06  +4.29565000E-03  +4.96515000E-03  -8.54060000E-04  -1.70230000E-04
   -5.84290000E-04  +6.20480000E-04  +8.27040000E-04  +4.56263000E-03  -1.42594000E-03
   +4.17629000E-03  +1.69738000E-03  -1.61330000E-03  +5.58108400E-02  -1.02634230E-01
   -1.13171090E-01  +2.88047000E-03  -2.95427000E-03  -1.05887400E-02  -2.50398000E-03
   -1.89596000E-03  +2.24460000E-03  +4.43200000E-05  +3.21000000E-05  +5.28700000E-05
   -2.82880000E-04  +3.46530000E-04  -8.50670000E-04  -6.33214600E-02  +1.00252660E-01
   +2.42400000E-05  -2.15700000E-05  -4.05800000E-05  -1.10000000E-05  -2.26900000E-05
   +1.04800000E-05  +1.78000000E-05  -1.82300000E-05  +2.28500000E-05  +8.58000000E-06
   +4.96300000E-05  +1.99200000E-05  +1.50960000E-04  -3.01850000E-04  -2.72800000E-05
   +4.77000000E-06  +4.69600000E-05  -4.93400000E-05  -2.62450000E-04  -5.45000000E-05
   +1.66420000E-04  +6.64000000E-05  +3.39000000E-06  -1.23200000E-05  -1.68050000E-04
   +1.97020000E-04  +3.83800000E-05  +4.25300000E-05  +4.29200000E-05  -5.08000000E-06
   -1.55432000E-03  -1.10516000E-03  +2.64607000E-03  -1.05540000E-03  +8.24700000E-04
   -8.81300000E-05  -4.56512000E-03  -1.26888000E-03  -2.87928000E-03  +1.48088400E-02
   -1.44496300E-02  -1.56446500E-02  +7.52441600E-02  -1.13193380E-01  -2.35972020E-01
   -1.83806000E-03  +1.55575000E-03  +4.40088000E-03  +9.25810000E-04  +1.87588000E-03
   +1.94761000E-03  +5.84900000E-05  +1.46600000E-05  -2.70000000E-05  -2.02498000E-03
   +4.02990000E-04  -9.31850000E-04  -8.15162300E-02  +1.24428190E-01  +2.47157430E-01
   -1.38017000E-03  -1.11243000E-03  +8.52950000E-04  -2.58390000E-04  +1.92470000E-04
   +2.40490000E-04  +9.72000000E-06  -1.65900000E-05  -1.16100000E-05  -7.00000000E-08
   +3.18200000E-05  -3.58600000E-05  +4.62500000E-05  -6.07000000E-05  +3.33700000E-05
   -8.79360000E-04  -2.64600000E-04  +2.62990000E-04  -6.49040000E-04  -1.13371000E-03
   +2.55370000E-04  +2.30600000E-04  -4.49900000E-05  -2.66000000E-05  -5.57600000E-05
   +1.12360000E-04  -3.76500000E-05  +2.62100000E-05  -6.73400000E-05  -9.90800000E-05
   +1.09010400E-02  +7.12560000E-04  +9.24505000E-03  +6.95930000E-04  +3.27701000E-03
   +1.91992000E-03  -7.77890000E-04  +1.42350000E-04  +7.98620000E-04  -2.79963000E-03
   +4.69918000E-03  +2.13850000E-04  -1.16367200E-02  -3.45781000E-03  -2.59870900E-02
   -1.31632010E-01  -8.76844000E-03  -1.27234520E-01  -1.24070000E-03  +6.78100000E-05
   -1.32501000E-03  -8.48930000E-04  +8.23400000E-04  +4.29260000E-04  +1.81800000E-04
   -1.69970000E-04  -1.48550000E-04  +9.68800000E-05  -1.60042000E-03  +8.65860000E-04
   +1.40849940E-01  -9.31290000E-04  -1.73860000E-04  +1.41640000E-04  -1.06470000E-04
   +4.55550000E-04  +1.54720000E-04  -1.78670000E-04  -1.45900000E-05  -5.92800000E-05
   +2.96900000E-05  -2.79800000E-05  +2.57400000E-05  -4.58500000E-05  +5.65500000E-05
   +1.04800000E-04  -3.16270000E-04  -3.04470000E-04  +2.86010000E-04  -1.64037000E-03
   -2.17584000E-03  +1.03565000E-03  +9.49000000E-05  -2.87000000E-04  +2.20390000E-04
   +5.74500000E-05  -8.15700000E-05  -7.20000000E-05  -8.11800000E-05  -2.90100000E-04
   -4.13100000E-05  -8.62100000E-03  +3.09398000E-03  -1.21288800E-02  +3.44811000E-03
   +3.41427000E-03  -4.24860000E-03  +4.74300000E-05  -1.15668000E-03  +1.77940000E-04
   +4.77563000E-03  +4.79573000E-03  -2.23801000E-03  +7.62499000E-03  +5.19014000E-03
   +1.09376600E-02  -9.14137000E-03  -4.70009600E-02  -3.24704900E-02  +4.18750000E-04
   -7.98700000E-05  +6.59950000E-04  +2.92730000E-04  -7.26270000E-04  -7.05290000E-04
   -7.46900000E-05  +3.97700000E-05  +4.78800000E-05  -1.78748000E-03  -3.03900000E-03
   +1.46189000E-03  +5.11323000E-03  +3.94338400E-02  +2.31400000E-04  -4.89300000E-04
   +1.00420000E-04  +3.63890000E-04  -4.61970000E-04  -4.38170000E-04  +1.00600000E-05
   -5.42800000E-05  +3.92000000E-05  +7.07500000E-05  +1.01690000E-04  +1.29870000E-04
   -3.13200000E-04  +3.77260000E-04  -9.73770000E-04  -6.35940000E-04  -2.26200000E-05
   +6.70890000E-04  -7.06710000E-04  +1.81016000E-03  -7.57750000E-04  +9.47600000E-05
   +4.87700000E-05  +1.02290000E-04  +1.74200000E-04  -2.80190000E-04  +2.55670000E-04
   +1.22620000E-04  +2.58350000E-04  +1.65840000E-04  -1.51699800E-02  -1.01973000E-03
   -1.56537700E-02  +2.33158000E-03  -4.47112000E-03  -2.37063000E-03  +9.30060000E-04
   +1.92670000E-04  +2.72030000E-04  -1.54630000E-04  -2.06204000E-03  +2.73707000E-03
   +1.01491000E-03  -1.40914000E-03  +2.14089000E-03  -1.26548760E-01  -3.18546300E-02
   -2.63013130E-01  -2.61920000E-04  +1.62610000E-04  -9.70900000E-05  -6.53510000E-04
   +2.94620000E-04  -1.18240000E-04  +5.86200000E-05  -4.03600000E-05  -3.52000000E-05
   +5.54900000E-04  +1.68476000E-03  +3.11230000E-04  +1.39551820E-01  +3.61709600E-02
   +2.75853310E-01  +5.44900000E-05  -3.63900000E-05  -5.96000000E-06  -2.10210000E-04
   +1.24190000E-04  -1.21070000E-04  +4.23100000E-05  -9.06200000E-05  -1.93390000E-04
   +1.17400000E-05  +1.29750000E-04  +2.02260000E-04  +9.57000000E-06  -1.46180000E-04
   -1.94440000E-04  -3.08100000E-05  +2.84500000E-05  +3.31600000E-05  -1.83470000E-04
   -1.41959000E-03  +8.47560000E-04  -2.40099000E-03  +1.39947000E-03  -1.46936000E-03
   -4.57000000E-05  +1.57850000E-04  +6.52000000E-05  -6.98000000E-05  -1.12500000E-05
   +8.45300000E-05  +1.10974500E-02  -7.90693000E-03  -1.26751100E-02  -8.98403200E-02
   +5.22742100E-02  +7.67042900E-02  -6.61174000E-03  +1.43727800E-02  +2.47273900E-02
   -3.04918000E-03  +4.20150000E-03  -2.07811000E-03  -1.17146000E-03  -2.33230000E-04
   -5.68040000E-04  -6.40930000E-04  +1.44795000E-03  -4.36877000E-03  -4.72300000E-04
   +8.07710000E-04  +1.31689000E-03  +3.34780000E-04  +1.70400000E-04  +1.27150000E-04
   -4.03180000E-04  +1.06370000E-04  +4.01100000E-05  -6.86300000E-05  -2.19660000E-04
   +1.38940000E-04  +4.46820000E-04  -4.90550000E-04  -8.41920000E-04  +9.63704400E-02
   -5.51600000E-05  -2.37300000E-05  +1.68300000E-04  -4.11970000E-04  +5.08250000E-04
   -3.58780000E-04  +4.13900000E-05  +2.49000000E-06  -2.11820000E-04  +1.88150000E-04
   +1.20810000E-04  +2.11600000E-04  -3.94100000E-05  -1.64780000E-04  -4.51610000E-04
   +1.54500000E-05  -7.29600000E-05  +7.83600000E-05  -9.66640000E-04  -2.99171000E-03
   +8.26760000E-04  +1.98187000E-03  -2.99490000E-04  +4.37050000E-04  -1.60600000E-05
   +1.15500000E-04  +1.56020000E-04  -1.91930000E-04  -2.45790000E-04  +8.60200000E-05
   +1.78078000E-03  +2.53387000E-03  -1.77044000E-03  +5.18955300E-02  -1.07600220E-01
   -1.15641550E-01  +4.10920000E-03  -1.64184000E-03  -1.08297500E-02  +4.24780000E-03
   +5.96855000E-03  -1.23500000E-03  -4.09330000E-04  -7.13100000E-04  +6.62370000E-04
   +1.42373000E-03  +5.07797000E-03  -1.76221000E-03  +2.81480000E-04  -3.81160000E-04
   -5.55920000E-04  +3.91310000E-04  -1.62800000E-04  +7.19000000E-06  +5.23600000E-05
   -2.16100000E-04  +7.47300000E-05  -2.08370000E-04  -5.31110000E-04  +1.67700000E-04
   +6.94500000E-05  +8.29800000E-05  -8.27600000E-05  -6.37200900E-02  +1.04690080E-01
   +7.15100000E-05  -2.49000000E-05  -3.26000000E-05  +1.60180000E-04  -2.24300000E-05
   +7.69000000E-06  +6.43800000E-05  -1.05030000E-04  -1.54530000E-04  -3.45200000E-05
   +5.99500000E-05  +1.60270000E-04  +2.51900000E-05  -9.09700000E-05  -2.16770000E-04
   -5.12700000E-05  +3.79100000E-05  +7.28800000E-05  +2.01531000E-03  +1.53370000E-04
   -6.84830000E-04  +1.02410000E-03  -5.43080000E-04  +1.94570000E-04  -4.46400000E-05
   +1.01960000E-04  +7.57500000E-05  -1.42700000E-05  +1.09350000E-04  +8.41700000E-05
   +1.08009900E-02  -1.25408100E-02  -1.57326000E-02  +7.64749600E-02  -1.14532650E-01
   -2.44980800E-01  -2.51448000E-03  +1.10757000E-03  +4.35673000E-03  -2.07818000E-03
   -1.43210000E-03  +2.47460000E-03  -5.40740000E-04  +7.77030000E-04  +2.21060000E-04
   -4.70261000E-03  -1.69020000E-03  -2.90519000E-03  +2.59220000E-04  -9.44500000E-05
   +3.06100000E-05  -2.85680000E-04  +8.44100000E-05  +1.11330000E-04  -5.00600000E-05
   +1.20930000E-04  +1.96000000E-05  +1.89990000E-04  +1.59240000E-04  -1.09810000E-04
   +6.41930000E-04  -6.57590000E-04  -9.49690000E-04  -8.28252200E-02  +1.26998770E-01
   +2.56269690E-01  +1.75000000E-06  +2.96900000E-05  +5.70700000E-05  +2.21200000E-05
   +2.15310000E-04  -7.06100000E-05  +1.03200000E-05  +3.31400000E-05  -5.41500000E-05
   +1.67200000E-05  -6.31000000E-06  -7.43000000E-06  -4.47400000E-05  +7.19800000E-05
   -7.66400000E-05  +1.11900000E-05  -4.13500000E-05  +4.03200000E-05  +3.91300000E-05
   -2.04400000E-04  -1.13387000E-03  +2.35600000E-05  -1.09850000E-04  -5.53500000E-05
   +4.39200000E-05  -6.42300000E-05  +3.94200000E-05  -1.05210000E-04  -8.55500000E-05
   +5.16700000E-05  -2.93753000E-03  +4.50483000E-03  +2.59850000E-04  -1.05148600E-02
   -3.96805000E-03  -2.47103800E-02  -1.39496520E-01  -6.03127000E-03  -1.32722330E-01
   +9.57108000E-03  +2.16248000E-03  +1.02719800E-02  +3.84590000E-04  +2.95581000E-03
   +1.58671000E-03  -7.00110000E-04  +2.10790000E-04  +8.51650000E-04  +5.12600000E-04
   -1.83121000E-03  -5.81000000E-06  -4.13660000E-04  +5.36400000E-05  +8.42200000E-05
   -1.08300000E-05  -2.63380000E-04  -8.43700000E-05  +4.17720000E-04  +2.32400000E-05
   +6.54040000E-04  -9.00300000E-05  -2.70640000E-04  +2.10000000E-06  +5.20000000E-05
   -1.73438000E-03  +9.15770000E-04  +1.43280910E-01  +1.47800000E-05  -3.84300000E-05
   -9.37000000E-06  +1.62900000E-05  -7.27900000E-05  +1.43500000E-05  +7.77000000E-06
   +2.05600000E-05  +2.73400000E-05  +2.97600000E-05  +1.75300000E-05  -2.78400000E-05
   -2.22900000E-05  +1.79100000E-05  -7.68800000E-05  -2.25200000E-05  -1.97100000E-05
   +3.06900000E-05  +1.93670000E-04  +4.58220000E-04  +4.64550000E-04  -4.54800000E-05
   -1.56200000E-05  +4.32000000E-05  +3.16800000E-05  -1.44700000E-05  +4.18400000E-05
   +9.69100000E-05  +6.81000000E-06  -6.77000000E-06  +4.58509000E-03  +4.64329000E-03
   -1.93706000E-03  +6.45034000E-03  +4.11160000E-03  +1.12975900E-02  -5.42524000E-03
   -4.42734800E-02  -2.85327000E-02  -9.23644000E-03  +4.18870000E-03  -1.30397400E-02
   +3.19022000E-03  +2.59214000E-03  -3.80088000E-03  +4.10200000E-04  -1.13736000E-03
   +6.54500000E-05  -1.61547000E-03  -1.97839000E-03  +1.89834000E-03  +2.70000000E-06
   +4.25500000E-05  -7.11000000E-05  -2.16970000E-04  -3.02120000E-04  +3.61790000E-04
   -4.88820000E-04  -1.07420000E-04  -6.38160000E-04  -2.44690000E-04  -5.01140000E-04
   +2.37360000E-04  -1.93767000E-03  -3.20361000E-03  +1.55207000E-03  +4.23282000E-03
   +3.55872300E-02  -8.24000000E-06  +5.91000000E-06  +1.37600000E-05  +6.37000000E-06
   +4.60400000E-05  -1.42100000E-05  -2.00000000E-07  +1.17600000E-05  -4.63000000E-06
   -6.66000000E-06  -1.28700000E-05  -1.53100000E-05  +8.70000000E-07  +4.33300000E-05
   +5.92000000E-06  +1.40000000E-06  -3.41000000E-06  +1.76000000E-06  +1.55580000E-04
   -1.54950000E-04  +5.72500000E-05  -5.41400000E-05  +1.01200000E-05  -1.49600000E-05
   +4.51000000E-06  -3.93900000E-05  +4.03000000E-06  -6.33100000E-05  -1.76700000E-05
   +8.41000000E-06  -2.34660000E-04  -1.74877000E-03  +2.65417000E-03  +1.81416000E-03
   -4.40730000E-04  +3.46799000E-03  -1.31343530E-01  -2.91340500E-02  -2.56187860E-01
   -1.79259100E-02  -4.93600000E-04  -1.61807900E-02  +2.13852000E-03  -4.03262000E-03
   -2.20224000E-03  +1.19501000E-03  -1.30140000E-04  +8.59000000E-05  +2.84530000E-04
   +1.77088000E-03  +1.25578000E-03  +1.85100000E-05  -4.30500000E-05  +2.86500000E-05
   +9.66000000E-06  +3.17050000E-04  +2.49500000E-04  -6.40610000E-04  -3.78300000E-05
   -9.14040000E-04  +3.33400000E-05  +2.28700000E-04  -1.10710000E-04  +4.35620000E-04
   +1.74762000E-03  +2.47800000E-04  +1.44151310E-01  +3.20996300E-02  +2.67574750E-01
   +1.11900000E-05  +1.77850000E-04  -2.84390000E-04  -5.12790000E-04  +1.05530000E-03
   -1.35285000E-03  +3.18550000E-04  +2.80320000E-04  -1.91300000E-05  -2.89000000E-06
   +1.05930000E-04  -4.42000000E-06  -5.82500000E-05  +1.95300000E-05  -2.29650000E-04
   +5.64900000E-05  -1.03340000E-04  +1.85280000E-04  +2.70767000E-03  +6.03620000E-03
   -1.12250000E-03  +2.57390000E-04  +1.91510000E-04  -5.75100000E-05  +3.72800000E-05
   -6.92300000E-05  +7.27600000E-05  +3.61990000E-04  -6.20230000E-04  +5.99780000E-04
   +7.20390000E-04  +5.58000000E-04  +1.19600000E-04  +7.64900000E-05  -1.63630000E-04
   -8.83200000E-05  +4.73300000E-05  -3.28100000E-05  +5.95000000E-06  -1.16900000E-04
   +6.65800000E-05  +8.05000000E-06  -5.68800000E-05  -8.90800000E-05  +5.35600000E-05
   -3.60900000E-05  -3.01900000E-05  +9.23200000E-05  +1.51410000E-04  -4.61700000E-05
   -4.37000000E-06  -1.34565870E-01  -1.26900930E-01  +7.22655000E-03  -1.82400000E-05
   +9.23000000E-06  +8.99000000E-06  +6.36000000E-06  -8.49000000E-06  -2.62000000E-06
   +1.29360000E-04  +4.01200000E-05  +1.08900000E-05  +2.03100000E-05  +1.11000000E-05
   +2.37300000E-05  +1.72500000E-05  -4.82000000E-06  +3.96000000E-06  +1.41627300E-01
   -1.78000000E-04  +3.42540000E-04  +2.23470000E-04  +1.88503000E-03  -7.43640000E-04
   +2.28626000E-03  -8.03790000E-04  -4.75400000E-04  -2.92110000E-04  +1.27060000E-04
   -5.85400000E-05  +2.63920000E-04  -1.97600000E-04  +2.70310000E-04  -8.84400000E-05
   +6.46000000E-05  -7.27600000E-05  +1.65980000E-04  -8.84877000E-03  -1.40699700E-02
   +1.28335000E-03  -2.71200000E-05  +5.87150000E-04  -1.73745000E-03  +1.27990000E-04
   -2.82840000E-04  +3.18400000E-05  -1.63200000E-04  +4.19440000E-04  -2.17180000E-04
   -7.11100000E-04  +5.52650000E-04  -3.69120000E-04  +4.67480000E-04  +1.27900000E-05
   +1.81950000E-04  -1.60920000E-04  +1.02710000E-04  +1.33400000E-04  +9.83500000E-05
   -1.63430000E-04  -1.73560000E-04  +2.35840000E-04  +8.94000000E-06  +1.00930000E-04
   +2.30510000E-04  -5.14500000E-05  -4.21050000E-04  -9.24200000E-05  +8.10900000E-05
   +1.64600000E-05  -1.26180770E-01  -2.28415770E-01  +8.86872000E-03  +4.50000000E-07
   -2.56600000E-05  -6.40000000E-07  -7.49000000E-06  -2.46100000E-05  +1.00700000E-05
   -2.10380000E-04  -2.37400000E-05  +1.36040000E-04  +1.71000000E-06  -1.17900000E-05
   -1.34000000E-06  -3.84000000E-06  -2.10000000E-05  +7.11000000E-06  +1.38229310E-01
   +2.46750050E-01  -7.38950000E-04  -7.04210000E-04  -9.98640000E-04  -1.72540000E-03
   +2.44403000E-03  -5.16711000E-03  +1.48949000E-03  +8.77940000E-04  +6.68160000E-04
   -2.34070000E-04  +3.83930000E-04  -1.40080000E-04  +1.90220000E-04  -2.31700000E-04
   -7.69560000E-04  +7.97300000E-05  +1.31900000E-05  +4.76130000E-04  +1.60620700E-02
   +2.36603000E-02  -3.67648000E-03  +8.65650000E-04  +1.33110000E-03  +7.23220000E-04
   -5.32300000E-05  +1.59950000E-04  +2.53260000E-04  -7.63000000E-05  -3.54030000E-04
   +2.79340000E-04  +8.20810000E-04  -6.04810000E-04  +9.04240000E-04  -2.01510000E-04
   -1.93000000E-04  -2.58900000E-05  +7.09500000E-05  -2.54800000E-05  -1.11440000E-04
   -8.44900000E-05  +5.10100000E-05  +2.20900000E-05  +1.28190000E-04  +1.19770000E-04
   +9.51100000E-05  -7.49800000E-05  -5.63500000E-05  -7.00500000E-05  +1.53150000E-04
   -9.22800000E-05  +5.19000000E-06  +5.96464000E-03  +7.46756000E-03  -4.60176400E-02
   -1.08900000E-05  +1.01200000E-05  +1.26000000E-05  +4.50000000E-06  -2.28000000E-06
   -1.46100000E-05  -1.67950000E-04  -2.39200000E-05  +2.22500000E-05  -3.56300000E-05
   +2.46800000E-05  -4.26600000E-05  +1.46700000E-05  +2.19800000E-05  -2.16000000E-06
   -5.87533000E-03  -1.16514500E-02  +5.30530300E-02  +4.65100000E-05  +5.76100000E-05
   -2.59850000E-04  -7.33640000E-04  -1.13780000E-04  -2.92260000E-04  +4.81700000E-05
   +2.07370000E-04  +9.26100000E-05  +1.43900000E-05  +1.28000000E-05  -4.43800000E-05
   -8.16500000E-05  -4.14500000E-05  -9.99200000E-05  +7.10600000E-05  -5.18900000E-05
   +1.70260000E-04  -5.05063000E-03  +1.71394000E-03  +3.53800000E-05  +9.51400000E-05
   -6.45600000E-05  +6.47830000E-04  +5.32800000E-05  -1.41300000E-05  +3.87500000E-05
   -3.09990000E-04  -1.48421000E-03  +1.40797000E-03  +4.27520000E-04  +4.69980000E-04
   -1.27967000E-03  +3.22110000E-04  +3.56760000E-04  +4.32180000E-04  -3.11460000E-04
   +8.31500000E-05  +7.72200000E-05  +2.95480000E-04  -1.88650000E-04  -1.91660000E-04
   +8.86600000E-05  -1.08600000E-05  -6.01900000E-05  +1.09380000E-04  -1.45890000E-04
   -2.81730000E-04  -3.72060000E-04  +1.55840000E-04  +1.12000000E-05  -2.97575010E-01
   +7.08502900E-02  -1.25336300E-02  +3.98300000E-05  -2.44700000E-05  -2.38100000E-05
   -3.15900000E-05  +1.28100000E-05  +1.81200000E-05  -2.00100000E-05  -1.53450000E-04
   +8.70000000E-07  +1.15000000E-05  -2.31600000E-05  -8.06600000E-05  -5.20800000E-05
   -1.49500000E-05  +8.60000000E-06  -1.54124200E-02  +5.76752000E-03  -4.15880000E-04
   +3.21955370E-01  +4.19100000E-05  -1.46940000E-04  +3.20560000E-04  +1.67469000E-03
   -4.48570000E-04  +1.84000000E-05  -2.63600000E-05  +5.50700000E-05  +4.40700000E-05
   -6.11600000E-05  +8.98500000E-05  -8.29100000E-05  +1.01420000E-04  -1.36520000E-04
   +1.41200000E-04  -1.57710000E-04  +1.74620000E-04  -2.88570000E-04  +1.55093800E-02
   -5.57273000E-03  +4.06000000E-04  -5.89050000E-04  -2.17900000E-05  -1.02322000E-03
   -1.11860000E-04  +2.01420000E-04  -5.95700000E-05  -7.24970000E-04  +2.62210000E-04
   -2.67180000E-04  +4.01460000E-04  -6.05410000E-04  +2.96041000E-03  +5.60150000E-04
   -5.23270000E-04  -2.45890000E-04  +2.54130000E-04  +7.48100000E-05  +1.57890000E-04
   -1.37280000E-04  +5.41300000E-05  +1.03280000E-04  -3.89000000E-05  -4.13600000E-05
   +1.80190000E-04  +2.14150000E-04  -4.01900000E-05  +1.36940000E-04  +2.55180000E-04
   -7.45900000E-05  +4.00000000E-08  +6.90074600E-02  -6.73965300E-02  +2.29705000E-03
   -3.14600000E-05  +1.46900000E-05  +9.91000000E-06  +3.16400000E-05  -2.55100000E-05
   -1.89100000E-05  -1.65830000E-04  +3.58430000E-04  +1.03410000E-04  -3.64300000E-05
   +9.62000000E-06  +6.83000000E-05  +9.07700000E-05  +5.86000000E-06  -7.44000000E-06
   -2.61577900E-02  +8.97863000E-03  -1.30923000E-03  -7.76994400E-02  +6.99547800E-02
   +4.02010000E-04  +1.76090000E-04  +2.44540000E-04  -8.99650000E-04  +3.02740000E-04
   +8.98510000E-04  -4.68200000E-05  -2.18050000E-04  -6.36100000E-05  +4.48300000E-05
   -9.44600000E-05  +2.70400000E-05  -3.88200000E-05  +1.07450000E-04  +9.56700000E-05
   -3.24400000E-05  -2.27600000E-05  -1.18980000E-04  -2.77187300E-02  +7.16869000E-03
   -1.96633000E-03  -1.36017000E-03  +7.52230000E-04  +1.10301000E-03  +3.68500000E-05
   -8.19900000E-05  -4.08400000E-05  +5.88060000E-04  -1.10600000E-05  -3.53180000E-04
   +5.00950000E-04  +1.81878000E-03  -5.19868000E-03  -1.02310000E-03  +8.09660000E-04
   +3.38360000E-04  -3.39930000E-04  -2.55330000E-04  -4.14000000E-06  +3.21050000E-04
   -9.33100000E-05  -4.60200000E-05  -2.31920000E-04  -4.53500000E-05  +1.83440000E-04
   +1.80170000E-04  -6.85590000E-04  -3.85150000E-04  -3.39520000E-04  +1.97720000E-04
   +3.22100000E-05  -9.91029000E-03  +1.35335000E-03  -4.83258800E-02  +6.49000000E-06
   -6.98000000E-06  -3.56300000E-05  -4.39200000E-05  +1.93000000E-06  +1.36900000E-05
   +8.71600000E-05  +4.14870000E-04  +3.30620000E-04  +5.68800000E-05  +1.30980000E-04
   -6.67200000E-05  -1.21320000E-04  +1.68700000E-05  +2.00000000E-08  +8.71060000E-04
   -5.17370000E-04  -1.07128000E-03  +1.30788800E-02  -4.66680000E-03  +5.30537400E-02
   +3.56650000E-04  -5.74390000E-04  +8.53400000E-04  -5.38900000E-05  +4.95040000E-04
   +5.04240000E-04  -1.69800000E-05  -1.77120000E-04  -1.29470000E-04  -2.99400000E-05
   -3.32200000E-05  -4.09500000E-05  +9.39400000E-05  -9.33600000E-05  +4.48000000E-04
   -2.50950000E-04  +1.81180000E-04  -4.83270000E-04  -4.63490000E-04  -4.48463000E-03
   -4.57276000E-03  -2.63520000E-04  +8.03930000E-04  -1.24754000E-03  -1.05220000E-04
   +1.72780000E-04  -1.61680000E-04  -1.96300000E-04  -3.86110000E-04  -2.49700000E-05
   +1.71690000E-04  -6.12260000E-04  +1.72720000E-04  -1.37040000E-04  +1.35300000E-05
   -9.40000000E-06  +1.99900000E-04  -5.49000000E-05  -1.11800000E-05  -1.37510000E-04
   +8.39000000E-05  +1.31660000E-04  -1.27340000E-04  +1.29800000E-05  +5.47500000E-05
   -1.53548000E-03  +9.14260000E-04  -9.00230000E-04  +1.56380000E-04  -6.98600000E-05
   +1.77700000E-05  -5.98887400E-02  +3.44506400E-02  +4.70003800E-02  -2.92900000E-05
   +2.45000000E-05  -1.46000000E-06  +1.87900000E-05  +2.72200000E-05  -2.23500000E-05
   -1.30025000E-03  +2.00362000E-03  -4.44580000E-04  +4.81100000E-05  +3.02000000E-06
   +6.15400000E-05  +1.30500000E-05  -2.18000000E-06  +6.76000000E-06  +4.17559000E-03
   -1.05327900E-02  -1.56629500E-02  -4.47203000E-03  +1.80918200E-02  +2.50723800E-02
   +6.34195200E-02  -1.31616000E-03  -1.28269000E-03  -6.81300000E-05  -1.38400000E-04
   +9.51640000E-04  -7.58540000E-04  +2.04700000E-04  +8.82800000E-05  -3.02000000E-05
   -6.11700000E-05  +6.73000000E-06  -4.25100000E-05  +2.32520000E-04  -7.96100000E-05
   +2.80500000E-05  +1.44910000E-04  +3.27500000E-05  +6.03400000E-05  -4.47823000E-03
   +1.01465400E-02  +1.24617500E-02  +6.21800000E-04  -1.02599000E-03  +2.02777000E-03
   -6.35700000E-05  +6.46500000E-05  -4.30000000E-07  -7.51800000E-05  -7.97100000E-05
   -2.62100000E-05  +5.98800000E-05  +4.27440000E-04  -1.03251000E-03  +3.48000000E-06
   +1.41980000E-04  +6.99000000E-06  -8.72400000E-05  +2.55000000E-06  +6.84000000E-05
   +1.10910000E-04  +2.81900000E-05  -1.09490000E-04  -8.76100000E-05  -4.31300000E-05
   +9.42000000E-05  +1.20562000E-03  -1.15497000E-03  +6.01360000E-04  -8.87000000E-05
   +4.75200000E-05  +2.22100000E-05  +3.41840000E-02  -1.35588090E-01  -1.23922820E-01
   +3.77000000E-06  +3.25000000E-06  -1.70200000E-05  -1.21000000E-05  -2.64600000E-05
   +1.44400000E-05  +2.07070000E-03  -1.05953000E-03  +6.08400000E-04  -1.37500000E-05
   -2.20000000E-06  -4.21000000E-06  -1.90900000E-05  -5.06000000E-06  +5.36000000E-06
   +7.21104000E-03  -1.45790100E-02  -2.06019700E-02  +4.54140000E-04  -5.39855000E-03
   -5.72371000E-03  -3.88172600E-02  +1.49233730E-01  -4.20650000E-04  -1.67420000E-04
   -5.70560000E-04  -1.69450000E-04  -1.04705000E-03  +9.21700000E-05  +9.51100000E-05
   -1.72960000E-04  +2.09400000E-04  -4.92100000E-05  +2.34310000E-04  +2.55470000E-04
   +4.72300000E-05  +2.63100000E-05  -8.58160000E-04  +8.86300000E-05  -2.85700000E-05
   +7.00630000E-04  +5.60684000E-03  -1.74522900E-02  -1.92159700E-02  -9.51490000E-04
   +4.22634000E-03  -5.11782000E-03  +2.65800000E-05  -7.03300000E-05  +2.94140000E-04
   +2.58800000E-05  +2.64100000E-04  +2.57200000E-04  +1.52138000E-03  -6.46770000E-04
   +6.12560000E-04  -4.50120000E-04  -1.10400000E-05  -1.94880000E-04  +3.21830000E-04
   -1.11010000E-04  +4.06100000E-05  +1.16480000E-04  +8.15100000E-05  +2.63620000E-04
   -3.53800000E-04  +1.87670000E-04  +5.47490000E-04  +3.52950000E-04  -9.07000000E-04
   -4.37470000E-04  +7.95200000E-05  +3.29300000E-05  +5.25200000E-05  +4.54513800E-02
   -1.21302450E-01  -2.19663360E-01  -4.23000000E-05  +7.50000000E-06  -8.27000000E-06
   -3.64100000E-05  -1.65800000E-05  -1.61300000E-05  -7.86900000E-05  +5.63850000E-04
   +1.10754000E-03  +1.57090000E-04  -3.77600000E-05  +1.47850000E-04  -4.60000000E-07
   +2.15000000E-05  -8.66000000E-06  -6.67380000E-04  +1.33992000E-03  +1.56186000E-03
   -3.74260000E-04  +1.82500000E-03  +1.92427000E-03  -5.04323800E-02  +1.34356850E-01
   +2.37924400E-01  -5.25400000E-05  -7.57400000E-05  +3.48200000E-05  +5.27110000E-04
   -3.86500000E-05  -8.09970000E-04  -3.53700000E-05  -4.26960000E-04  -2.99110000E-04
   -5.06500000E-05  +1.50330000E-04  +1.95500000E-04  +7.59800000E-05  -9.05700000E-05
   -1.17230000E-04  -2.82600000E-05  +4.69500000E-05  +1.82700000E-05  -1.51347000E-03
   -3.44347000E-03  +3.66281000E-03  -4.68794000E-02  +5.32870000E-03  -1.08131000E-02
   -6.30200000E-05  +1.16030000E-04  +4.92600000E-05  -8.99700000E-05  +1.74540000E-04
   +4.88260000E-04  +2.20760000E-04  -3.00930000E-04  -7.17000000E-05  -1.09128000E-03
   +4.91030000E-04  +7.44720000E-04  -1.10000000E-05  -6.43500000E-05  -1.65240000E-04
   -6.77100000E-05  +5.82700000E-05  -2.52000000E-05  +9.74100000E-05  -6.25300000E-05
   -4.97100000E-05  -5.24000000E-05  +3.69700000E-05  -1.01040000E-04  +1.12030000E-04
   -6.42900000E-05  -3.06400000E-05  -1.13220000E-04  +3.29710000E-04  +3.42600000E-04
   -1.20000000E-05  +1.14600000E-05  +1.36000000E-06  +9.67000000E-06  -8.47000000E-06
   -9.91000000E-06  +1.45900000E-05  -4.76100000E-05  -5.77900000E-05  -2.67696000E-03
   +1.02849000E-03  +3.08800000E-04  -1.98600000E-05  -6.65000000E-06  +1.67500000E-05
   +1.98800000E-05  +3.52130000E-04  -1.46120000E-04  +3.33850000E-04  -9.09600000E-05
   +3.47060000E-04  +6.78670000E-04  +3.62900000E-05  +1.24390000E-04  +4.86909700E-02
   +2.82990000E-04  +5.87300000E-05  +2.82000000E-05  -2.27230000E-04  +1.24041000E-03
   +3.46120000E-04  -3.75290000E-04  -1.70214000E-03  -4.03160000E-04  +9.70000000E-06
   +2.50800000E-04  +3.34540000E-04  -5.45000000E-06  -2.15100000E-04  -3.92460000E-04
   -3.91000000E-06  +1.81700000E-05  +8.80000000E-05  -2.07162000E-03  +1.10752600E-02
   -2.01684400E-02  +4.64907000E-03  -8.88203600E-02  +9.73499000E-02  -4.46200000E-05
   +2.05710000E-04  +1.29660000E-04  -9.15900000E-05  -1.86790000E-04  -2.24600000E-05
   -2.20100000E-04  +5.78320000E-04  +5.10090000E-04  +8.32460000E-04  -1.08170000E-04
   +7.48600000E-04  +8.98500000E-05  -1.61770000E-04  -2.79160000E-04  +1.08580000E-04
   +4.80900000E-05  +1.76500000E-04  -1.11110000E-04  +9.29000000E-06  -3.48100000E-05
   -7.82100000E-05  -1.22410000E-04  -1.03280000E-04  -2.51000000E-05  -1.52000000E-05
   -4.42400000E-05  +7.85660000E-04  -3.06415000E-03  -2.75309000E-03  +1.33800000E-05
   -5.59000000E-06  -5.57000000E-06  +5.10000000E-07  +8.98000000E-06  -1.33200000E-05
   -1.79800000E-05  +5.27500000E-05  -9.87000000E-06  +1.28539000E-03  -1.53600000E-04
   -4.48500000E-04  -1.75000000E-06  +1.07000000E-05  +6.74000000E-06  +3.27280000E-04
   +1.84760000E-04  -1.84310000E-04  -1.25240000E-04  -1.24460000E-04  -3.65400000E-05
   -1.43540000E-04  +8.17110000E-04  -1.34280000E-03  -6.14629000E-03  +9.71138800E-02
   -8.99000000E-05  +1.11220000E-04  +1.91330000E-04  +4.40920000E-04  +7.13790000E-04
   -5.85260000E-04  +1.13300000E-04  +7.37520000E-04  -8.32200000E-04  +1.46030000E-04
   +1.91870000E-04  +8.80850000E-04  -2.27190000E-04  -1.95300000E-05  -7.26970000E-04
   +8.15800000E-05  -1.54840000E-04  +2.22410000E-04  -2.04070000E-03  +1.07162400E-02
   -1.84617200E-02  -1.01568800E-02  +9.51218600E-02  -2.77010710E-01  +1.30800000E-05
   +1.33060000E-04  +2.84690000E-04  -2.38470000E-04  -5.39200000E-05  +5.25080000E-04
   -9.53980000E-04  +3.41130000E-04  +1.22380000E-04  -8.97870000E-04  -1.96350000E-04
   -6.35940000E-04  +1.73580000E-04  +1.39050000E-04  +6.08710000E-04  -1.02700000E-04
   +1.06650000E-04  -4.48300000E-05  -7.78900000E-05  +6.72600000E-05  +8.62500000E-05
   +2.32740000E-04  -2.22620000E-04  +3.54700000E-05  +4.48800000E-05  +3.61000000E-06
   +8.91100000E-05  +1.43214000E-03  -4.65612000E-03  -3.31243000E-03  -1.46700000E-05
   +1.32100000E-05  -7.50000000E-07  +2.74300000E-05  +0.00000000E+00  -3.70000000E-06
   -7.19500000E-05  +1.45260000E-04  +8.99800000E-05  +1.48000000E-04  +3.47260000E-04
   +1.07605000E-03  +3.27600000E-05  -3.21900000E-05  -8.43000000E-06  -1.65000000E-05
   -1.87240000E-04  +4.43620000E-04  +2.37400000E-05  -2.10000000E-07  +2.62590000E-04
   -4.14330000E-04  +6.68160000E-04  -1.50052000E-03  +1.23733500E-02  -1.06228240E-01
   +3.01213660E-01  -3.38400000E-05  +1.61350000E-04  -1.45150000E-04  -4.97710000E-04
   +1.01570000E-04  +4.07530000E-04  -5.12800000E-05  -1.38800000E-05  +7.69700000E-05
   +3.30600000E-05  +2.15500000E-05  -7.97000000E-06  +1.04100000E-05  -4.47000000E-05
   -2.37100000E-05  +1.99300000E-05  +1.09100000E-05  +8.02400000E-05  -4.24468000E-03
   +1.82843000E-03  -2.78380000E-04  -2.73591190E-01  +1.04767430E-01  -3.03966400E-02
   +1.36000000E-06  +3.38900000E-05  +7.02000000E-06  -1.66766000E-03  -3.32400000E-03
   -7.93490000E-04  +4.65910000E-04  +5.23720000E-04  +7.05160000E-04  +1.41780000E-04
   +3.63300000E-05  -1.20650000E-04  +1.59030000E-04  +8.11700000E-05  +6.68500000E-05
   +2.18020000E-04  -3.44400000E-05  +1.57400000E-04  -2.39030000E-04  +5.27500000E-05
   +3.74100000E-05  +9.98800000E-05  +2.75300000E-05  -4.87730000E-04  -2.63480000E-04
   +1.05700000E-04  +3.03000000E-06  +5.47940000E-04  -4.03090000E-04  -9.19330000E-04
   +2.95600000E-05  -2.29300000E-05  -1.21600000E-05  -5.45500000E-05  -7.72000000E-06
   +1.50500000E-05  +3.01900000E-05  +4.00600000E-05  +8.18700000E-05  -1.38990000E-04
   -5.81800000E-05  +3.49350000E-04  -1.14100000E-05  +1.04300000E-05  -1.40700000E-05
   -2.87810000E-04  +4.12900000E-05  +1.33400000E-04  +4.85880000E-04  -9.12000000E-05
   +3.08060000E-04  +3.27940000E-04  -2.03180000E-04  -1.10220000E-04  +3.23960000E-04
   -7.93620000E-04  +2.61200000E-04  +2.95771260E-01  -2.54530000E-04  +5.77600000E-05
   -1.04030000E-04  +2.28203000E-03  -4.20760000E-04  +7.88000000E-05  -2.72820000E-04
   -2.05180000E-04  +1.86590000E-04  -6.75500000E-05  +6.04900000E-05  -9.92300000E-05
   +1.40010000E-04  -1.24650000E-04  +1.31920000E-04  -6.08900000E-05  +1.49250000E-04
   +1.68400000E-05  +2.04783800E-02  -9.96822000E-03  +2.94336000E-03  +1.01318570E-01
   -9.29176700E-02  +1.40366700E-02  -8.47500000E-05  +1.17440000E-04  -4.09800000E-05
   -1.56314000E-03  -5.36350000E-04  +5.93800000E-05  -6.10820000E-04  -2.17924000E-03
   -3.26636000E-03  -2.24880000E-04  +3.26910000E-04  -5.47100000E-04  +2.01150000E-04
   -6.89700000E-05  -7.45000000E-05  -1.90060000E-04  +4.66200000E-05  +1.14380000E-04
   +1.80800000E-05  -6.12400000E-05  -3.59690000E-04  +1.29328000E-03  -2.74320000E-04
   +4.10350000E-04  +2.29500000E-04  -1.03340000E-04  +4.30000000E-06  +1.13220000E-04
   +5.94920000E-04  +1.50440000E-03  -2.58400000E-05  +2.14400000E-05  +9.41000000E-06
   +1.12640000E-04  -6.29300000E-05  -3.95000000E-06  -4.05600000E-05  -1.42300000E-05
   -5.75100000E-05  -3.83680000E-04  -8.13000000E-06  +1.05520000E-04  +4.44900000E-05
   +1.17600000E-05  +4.00000000E-07  -2.15830000E-04  +1.22000000E-05  -1.10490000E-04
   -2.80880000E-04  +5.13000000E-04  -5.07160000E-04  -3.05610000E-04  -1.07950000E-04
   +2.19780000E-04  +1.16291500E-02  -5.72479000E-03  +1.39578000E-03  -1.12002760E-01
   +9.92621200E-02  +1.29510000E-04  +2.74400000E-05  -5.34000000E-06  +1.12900000E-04
   +4.25470000E-04  +4.61310000E-04  +1.26980000E-04  +1.33080000E-04  -2.02040000E-04
   -3.08500000E-05  +3.84000000E-05  +1.12440000E-04  -3.68000000E-05  -7.59800000E-05
   -4.84200000E-05  -1.89100000E-05  +4.03200000E-05  -2.43100000E-05  +2.19295600E-02
   -9.14729000E-03  +1.40179000E-03  -3.21286400E-02  +1.57695400E-02  -5.19057900E-02
   -1.19000000E-05  +8.70000000E-05  +1.96300000E-05  -6.08970000E-04  -8.32440000E-04
   -3.24630000E-04  -6.16400000E-04  -3.27332000E-03  -3.79487000E-03  -5.85040000E-04
   -4.56400000E-05  -1.00827000E-03  +1.42100000E-05  +1.28760000E-04  +4.32040000E-04
   -2.29190000E-04  -3.33000000E-06  -1.92660000E-04  +2.55940000E-04  +2.64000000E-05
   -2.32370000E-04  +1.16253000E-03  -5.26470000E-04  +5.75810000E-04  +1.62360000E-04
   -4.76400000E-05  +8.50300000E-05  +1.52982000E-03  -7.50340000E-04  +7.13340000E-04
   -2.55600000E-05  +2.09600000E-05  +7.91000000E-06  +1.30860000E-04  -1.40500000E-05
   -1.40900000E-05  -4.76100000E-05  -7.93300000E-05  +4.25000000E-05  +8.64000000E-05
   +3.29580000E-04  +5.60740000E-04  +3.03900000E-05  -1.26100000E-05  -8.00000000E-07
   +2.66200000E-05  +1.44700000E-04  +6.19300000E-05  -3.29960000E-04  -2.84880000E-04
   -9.20070000E-04  -1.61240000E-04  +1.67560000E-04  +2.79800000E-04  -2.76830200E-02
   +1.15126400E-02  -3.02235000E-03  +3.39276300E-02  -1.24006900E-02  +5.76589400E-02
   +3.75960000E-04  +2.08390000E-04  -8.42700000E-05  -7.55470000E-04  +1.67116000E-03
   +1.04246000E-03  +1.04000000E-06  +1.76330000E-04  +3.75000000E-05  +5.62400000E-05
   -2.71700000E-05  +1.95600000E-05  +3.97600000E-05  +8.07600000E-05  +1.17920000E-04
   -2.45800000E-05  +7.25600000E-05  -1.43300000E-05  +2.93140000E-03  +5.05980000E-03
   +5.20290000E-04  -1.77038570E-01  -1.35336420E-01  +1.38784600E-02  -2.21000000E-06
   -5.13500000E-05  -3.69400000E-05  -1.83600000E-04  -1.27339000E-03  -4.72610000E-04
   +4.98720000E-04  +8.66670000E-04  -8.26000000E-06  -2.84860000E-04  +6.54260000E-04
   -1.71290000E-04  +6.23300000E-05  -3.28400000E-05  -3.04800000E-05  -1.17300000E-04
   +3.54700000E-05  +3.11600000E-05  +1.49200000E-05  -1.44300000E-05  -1.46000000E-06
   +2.44970000E-04  -7.18300000E-05  -2.87100000E-05  +1.42760000E-04  -6.30800000E-05
   -4.32000000E-06  -2.18790000E-04  +8.93900000E-05  +2.10600000E-05  -1.65800000E-05
   +3.71000000E-06  +9.80000000E-06  +1.36500000E-05  -3.67100000E-05  +1.91000000E-06
   +1.35800000E-05  +9.28000000E-06  -2.84700000E-05  -3.66130000E-04  +6.02650000E-04
   -1.82160000E-04  +2.63100000E-05  +2.16300000E-05  -8.85000000E-06  +2.74770000E-04
   +1.00140000E-04  -4.04160000E-04  -1.23800000E-05  -1.21010000E-04  +8.29700000E-05
   +1.41960000E-04  +2.81250000E-04  -1.21190000E-04  +1.19517000E-03  +2.80831000E-03
   -4.26560000E-04  -1.75379400E-02  -2.13613600E-02  +3.04003000E-03  +1.90550270E-01
   -9.26680000E-04  -5.45110000E-04  +8.91570000E-04  +1.65437000E-03  -2.22152000E-03
   -3.63047000E-03  -1.88830000E-04  +3.84410000E-04  -3.26920000E-04  +6.68500000E-05
   -1.28680000E-04  -1.41810000E-04  -3.39890000E-04  +2.97190000E-04  -8.06500000E-05
   +1.16930000E-04  -2.44400000E-04  -2.77920000E-04  -1.52204900E-02  -1.84095100E-02
   +1.37230000E-03  -1.33498610E-01  -1.83109330E-01  +1.52434600E-02  +1.86640000E-04
   -3.47620000E-04  +1.60600000E-05  +4.23690000E-04  +7.63370000E-04  +1.58390000E-04
   -1.03035000E-03  +8.41690000E-04  +5.22240000E-04  +1.44230000E-04  +2.39500000E-05
   -4.17570000E-04  +3.78300000E-04  +7.67200000E-05  +1.52560000E-04  +1.47780000E-04
   -7.60000000E-06  +3.10530000E-04  -4.01380000E-04  +1.19940000E-04  -6.84000000E-05
   +4.87110000E-04  -7.70700000E-05  -3.64130000E-04  -2.05180000E-04  +1.07330000E-04
   +9.06000000E-06  +5.26400000E-05  +2.37330000E-04  +1.34525000E-03  +1.75300000E-05
   -3.23200000E-05  -3.27000000E-06  -3.52900000E-05  -2.86800000E-05  +2.51400000E-05
   -1.93600000E-05  -2.50000000E-06  +9.41000000E-05  +1.85960000E-04  -6.69420000E-04
   +7.23360000E-04  +9.20000000E-06  -2.47600000E-05  -9.68000000E-06  +3.44000000E-05
   +7.65990000E-04  -3.04590000E-04  +1.14900000E-04  +3.76600000E-05  +3.69300000E-05
   +3.45810000E-04  +2.24480000E-04  +5.64600000E-05  -8.12763000E-03  -8.83391000E-03
   +3.74350000E-04  +9.43404000E-03  +1.11070700E-02  -1.50014000E-03  +1.45874840E-01
   +1.99576500E-01  -8.86510000E-04  -5.93940000E-04  +9.40580000E-04  +6.19790000E-04
   -2.66232000E-03  -3.70799000E-03  +5.45900000E-05  +4.11770000E-04  -8.56030000E-04
   +1.18200000E-04  +5.23600000E-05  +4.19330000E-04  -2.65200000E-04  +1.77790000E-04
   -5.42730000E-04  +1.39490000E-04  -3.31630000E-04  -7.86600000E-05  -1.59132800E-02
   -1.71074900E-02  +2.04100000E-05  +1.44351800E-02  +1.62459700E-02  -4.85175800E-02
   +7.49600000E-05  -1.12990000E-04  +1.91290000E-04  +3.49700000E-04  +4.07080000E-04
   +4.04440000E-04  -4.03820000E-04  +6.54410000E-04  +7.50080000E-04  +2.82200000E-05
   +3.63100000E-05  +7.03720000E-04  +8.83600000E-05  -1.25770000E-04  -1.62700000E-04
   +1.12970000E-04  +7.10700000E-05  +1.81620000E-04  -1.58560000E-04  +6.93000000E-06
   -9.62300000E-05  +6.46400000E-05  +1.49590000E-04  -2.91810000E-04  -7.80600000E-05
   +2.40600000E-05  -4.72900000E-05  -8.63320000E-04  -1.07571000E-03  +8.40000000E-04
   +9.68000000E-06  -1.33500000E-05  -4.68000000E-06  -2.97600000E-05  -2.32000000E-05
   +8.55000000E-06  -4.46000000E-06  -5.21100000E-05  -8.02000000E-06  +4.60100000E-05
   +3.33210000E-04  -3.95010000E-04  -2.21200000E-05  -1.55000000E-05  +9.15000000E-06
   +1.93840000E-04  +1.90090000E-04  -9.53100000E-04  +3.36000000E-05  -2.05200000E-05
   -5.66100000E-05  +2.41210000E-04  +3.03830000E-04  +2.57510000E-04  +2.14779500E-02
   +2.08146700E-02  -1.33228000E-03  -3.05501000E-03  -3.56654000E-03  -7.28300000E-04
   -1.65825300E-02  -1.39606600E-02  +5.26549500E-02  -7.92427500E-02  +4.64995200E-02
   -8.66940100E-02  +1.47300000E-04  +2.72191000E-03  -1.97338000E-03  +7.64440000E-04
   -9.70650000E-04  +2.55710000E-04  -2.00254000E-03  -3.13360000E-04  +5.24300000E-04
   +1.23592900E-02  +3.41568000E-03  -2.22446000E-03  +7.16458000E-03  +4.74073000E-03
   -8.76342000E-03  +5.38230000E-04  +1.11056000E-03  +3.02890000E-04  +3.67000000E-05
   -1.29810000E-04  +9.80900000E-05  -2.63928000E-03  -3.36550000E-04  +5.16030000E-04
   +1.34183000E-03  -1.27140000E-03  -1.56620000E-04  -9.03500000E-05  -1.32410000E-04
   -7.94000000E-06  -1.13700000E-05  -2.12200000E-05  +7.78700000E-05  +9.52000000E-06
   +1.70600000E-05  +4.36200000E-05  -5.95900000E-05  -1.11700000E-05  -6.28900000E-05
   +7.36000000E-05  +4.35300000E-05  +1.73590000E-04  +3.48000000E-06  -1.56300000E-05
   -3.48590000E-04  +8.38000000E-05  -3.66200000E-05  +3.81200000E-05  +1.42040000E-04
   -6.11460000E-04  -4.69130000E-04  -2.05100000E-05  +1.73900000E-05  -8.21000000E-06
   -1.47000000E-06  +1.21400000E-05  -1.54800000E-05  -1.43590000E-04  +4.44500000E-05
   +1.03420000E-04  +1.43700000E-05  +1.37800000E-05  +2.52800000E-05  +7.50000000E-06
   +1.45100000E-05  +2.36000000E-06  -1.08300000E-05  +2.22120000E-04  +2.72110000E-04
   +7.23000000E-06  +8.00400000E-05  -2.62000000E-06  -8.42940000E-04  -1.19756000E-03
   +3.45590000E-04  +1.67200000E-05  +4.07200000E-05  +1.01610000E-04  +1.41500000E-05
   +2.42800000E-05  -2.03400000E-05  -1.87400000E-05  -1.71700000E-05  -1.41400000E-05
   +6.80873400E-02  +4.66146900E-02  -1.07372910E-01  +9.91836900E-02  -5.93693000E-03
   +9.46935000E-03  -1.59155600E-02  +3.22570000E-04  -2.80343000E-03  -2.52381000E-03
   -5.34350000E-04  +8.66000000E-06  +3.36470000E-04  +3.14925000E-03  -1.95276000E-03
   -5.26116000E-03  +1.30208800E-02  -9.72782000E-03  +2.84432000E-02  +1.73750000E-04
   +1.02676000E-03  +2.95750000E-04  +1.54250000E-04  -1.70500000E-05  +1.29270000E-04
   +5.11060000E-04  -2.35101000E-03  +2.22812000E-03  -9.71700000E-04  +8.71760000E-04
   +1.31580000E-03  -1.01200000E-04  -7.86200000E-05  +3.61500000E-05  +3.33400000E-05
   -5.58900000E-05  -9.96000000E-06  +2.27600000E-05  +4.01000000E-06  +2.15000000E-06
   -3.16500000E-05  +7.99000000E-06  -1.82000000E-06  +8.20000000E-06  +1.81300000E-05
   +2.28700000E-05  +7.58200000E-05  -5.81900000E-05  -5.74000000E-06  +4.23400000E-05
   -1.76600000E-05  +1.92000000E-06  -1.51138000E-03  -1.32999000E-03  +2.30310000E-04
   -7.93000000E-06  +3.77000000E-06  +4.06000000E-06  +1.19700000E-05  -3.46000000E-06
   +1.10000000E-07  +6.32600000E-05  +8.02200000E-05  +6.73600000E-05  -3.52000000E-06
   +1.40000000E-05  -1.77000000E-06  +7.30000000E-06  +1.52000000E-06  -1.80000000E-07
   +1.58490000E-04  -1.67200000E-05  -1.20790000E-04  +2.12950000E-04  -4.24240000E-04
   +2.07400000E-05  -1.27207000E-03  -1.79804000E-03  -6.62000000E-05  +2.29900000E-05
   +5.77400000E-05  +1.08080000E-04  +2.02900000E-05  -2.61300000E-05  -3.50800000E-05
   -2.16600000E-05  -2.39600000E-05  +3.20500000E-05  -5.23512900E-02  +1.15364880E-01
   -8.69202500E-02  +1.00400070E-01  -2.52232460E-01  -1.02780100E-02  +1.26811700E-02
   -1.79455100E-02  +3.92560000E-04  -4.64197000E-03  -2.67352000E-03  +6.28460000E-04
   +2.78090000E-04  +7.92250000E-04  -3.13770000E-03  -2.24331000E-03  +1.16979000E-03
   -7.89750000E-04  -3.42416000E-03  +5.35686000E-03  +4.25980000E-04  +7.40920000E-04
   -7.52040000E-04  -1.26190000E-04  -1.17300000E-04  +1.52820000E-04  +6.15390000E-04
   +5.67460000E-04  +1.07500000E-05  +4.93840000E-04  +8.44920000E-04  +3.16870000E-03
   +1.03850000E-04  -4.42500000E-05  +1.24200000E-04  +8.86000000E-06  -3.12300000E-05
   -8.54000000E-06  +3.80500000E-05  -1.73500000E-05  +3.38200000E-05  +2.69200000E-05
   +7.67000000E-06  +8.11000000E-06  -2.49300000E-05  +1.76800000E-05  +5.81900000E-05
   +1.06400000E-05  -4.47800000E-05  -1.80370000E-04  -4.61000000E-06  -1.04000000E-06
   +1.26000000E-05  +6.64060000E-04  +6.85600000E-04  -3.19780000E-04  -3.10000000E-07
   +5.49000000E-06  -4.65000000E-06  +1.84000000E-06  +3.08000000E-06  -3.35000000E-06
   -1.15960000E-04  +4.92100000E-05  +7.33700000E-05  +1.18900000E-05  +2.67100000E-05
   +1.24100000E-05  +9.43000000E-06  +4.93000000E-06  -1.37000000E-06  +1.62230000E-04
   +2.11950000E-04  +4.89830000E-04  +7.95700000E-05  -3.58080000E-04  -8.42600000E-05
   +7.46300000E-05  +8.64480000E-04  +9.51400000E-04  +1.94000000E-05  +8.09200000E-05
   +1.03170000E-04  +2.55900000E-05  -4.37900000E-05  -2.46000000E-05  -1.24800000E-05
   -1.19360000E-04  -2.35700000E-05  +9.57724700E-02  -1.08087100E-01  +2.63032420E-01
   +4.93950000E-03  +4.72230000E-03  +6.52170000E-03  +1.03232600E-02  +5.86901000E-03
   -1.91877000E-03  -5.26790000E-04  +1.44580000E-04  +3.37300000E-05  +6.82130000E-04
   +2.11992000E-03  -1.85149000E-03  +3.60146000E-03  -7.58300000E-03  -8.68126000E-03
   -4.31804000E-02  -5.79440000E-03  -2.08123200E-02  -4.99340000E-04  +8.57260000E-04
   +2.19655000E-03  +5.93510000E-04  +4.08800000E-04  -2.89450000E-04  -1.27146000E-03
   -1.56580000E-04  +2.00935000E-03  +1.28838000E-03  -2.29681000E-03  -1.97294000E-03
   -1.82100000E-04  +1.90100000E-05  +5.15000000E-06  +4.15100000E-05  -3.33200000E-05
   +7.93900000E-05  -2.11700000E-05  +1.08600000E-05  +5.11600000E-05  -1.06430000E-04
   +5.15000000E-06  -1.05490000E-04  +8.25200000E-05  +3.13500000E-05  +5.75200000E-05
   -3.23600000E-05  +9.46100000E-05  -1.37580000E-04  +9.30000000E-05  -2.28400000E-05
   +2.59400000E-05  -1.77190000E-04  -1.93340000E-04  +1.94180000E-04  -3.06400000E-05
   +4.10000000E-07  -7.41000000E-06  -4.16100000E-05  -1.91100000E-05  +1.04700000E-05
   +1.02560000E-04  -6.95500000E-05  +6.89700000E-05  +1.75000000E-06  +2.17400000E-05
   +9.46000000E-06  +7.06000000E-06  +7.56000000E-06  +7.46000000E-06  +8.59000000E-06
   -9.89000000E-06  -4.31600000E-05  -9.13000000E-06  +5.50500000E-05  -2.86300000E-05
   +4.14400000E-05  -9.90000000E-05  -8.45700000E-05  +1.73200000E-05  -2.56000000E-05
   +3.68800000E-05  -1.89700000E-05  +4.28900000E-05  -7.82000000E-06  -5.94000000E-05
   +1.88000000E-04  +1.88490000E-04  -6.61580000E-03  -2.10885000E-03  +2.27432000E-03
   +3.10596700E-02  -2.32444000E-03  -1.39403400E-02  -2.77571900E-02  +3.33611000E-03
   -7.74500000E-04  +3.09771000E-03  +3.24000000E-06  -2.23260000E-04  +2.71860000E-04
   +1.26912000E-03  -1.51118000E-03  +2.16437000E-03  +1.92585000E-03  +9.83678000E-03
   +1.33842500E-02  -6.27091000E-03  -1.41872940E-01  -1.32780080E-01  +1.43020000E-04
   +1.08610000E-04  -2.42040000E-04  -1.04000000E-04  -5.09700000E-05  +6.12400000E-05
   -1.40275000E-03  +8.82950000E-04  -1.80094000E-03  +1.33629000E-03  -1.44111000E-03
   -1.56784000E-03  +7.69200000E-05  -8.57100000E-05  +3.93800000E-05  -7.31000000E-06
   +1.10400000E-05  +5.10400000E-05  -2.59300000E-05  +3.91200000E-05  +4.27600000E-05
   -1.04800000E-05  -2.10500000E-05  -4.72900000E-05  +1.10800000E-05  +3.09600000E-05
   +4.16600000E-05  -8.11200000E-05  +5.22900000E-05  -1.58920000E-04  -2.06000000E-05
   +1.38200000E-05  +1.86100000E-05  -5.89100000E-05  -1.45800000E-05  -3.15000000E-05
   -9.36000000E-06  +2.63000000E-06  -9.89000000E-06  -3.34100000E-05  +2.47000000E-06
   -1.80000000E-07  +3.35400000E-05  -8.96700000E-05  +3.13200000E-05  +1.36100000E-05
   -7.12000000E-06  +2.04300000E-05  -5.38000000E-06  +5.50000000E-06  +1.67000000E-06
   -7.82000000E-06  -3.20700000E-05  +2.62300000E-05  +3.49000000E-06  +4.01700000E-05
   -2.05100000E-05  +2.65000000E-06  -3.67600000E-05  +1.52700000E-05  +1.40900000E-05
   +4.73000000E-06  -5.84000000E-06  +1.38300000E-05  +4.17100000E-05  -2.19000000E-06
   -1.77700000E-05  -4.83600000E-05  -2.75400000E-05  -1.95135000E-03  +1.94000000E-04
   +8.26620000E-04  +4.41864000E-03  +1.48457800E-01  -5.65500000E-04  +3.67820000E-03
   +5.91374000E-03  -2.93551000E-03  -6.22000000E-06  +1.03609000E-03  +1.23750000E-04
   +5.74660000E-04  +2.66140000E-04  -2.08087000E-03  +3.43630000E-03  -2.72185000E-03
   -2.84500000E-05  -1.95988900E-02  -1.83188800E-02  -2.03997500E-02  -1.33274720E-01
   -2.54338290E-01  +2.01540000E-04  -1.70580000E-04  -3.83840000E-04  -1.14720000E-04
   -3.25700000E-05  +3.24900000E-05  +1.02056000E-03  +1.70246000E-03  +4.02773000E-03
   -3.64120000E-04  +6.75330000E-04  +9.19220000E-04  +3.82100000E-05  -6.90000000E-06
   +2.85300000E-05  -2.65600000E-05  -5.86000000E-06  +2.16900000E-05  +1.79100000E-05
   -1.53600000E-05  +2.83000000E-05  +3.04900000E-05  -8.01000000E-06  -6.14000000E-06
   -2.07700000E-05  +3.25500000E-05  -1.20000000E-06  +2.76200000E-05  -2.16100000E-05
   -8.24200000E-05  -3.39400000E-05  +2.02900000E-05  +7.99000000E-06  -1.33000000E-05
   -5.40000000E-06  -4.82100000E-05  -1.37000000E-06  -7.51000000E-06  -4.69000000E-06
   -2.16100000E-05  -5.20000000E-06  +1.14800000E-05  -1.91600000E-05  -5.30000000E-05
   +3.51100000E-05  +1.02800000E-05  +1.81300000E-05  +1.24300000E-05  +3.28000000E-06
   +5.70000000E-06  -3.30000000E-07  +8.90000000E-07  -2.96000000E-06  +2.57900000E-05
   -2.68000000E-06  -3.68000000E-06  +1.08200000E-05  -1.40000000E-07  +1.03300000E-05
   +3.52400000E-05  +3.12000000E-06  +1.89500000E-05  +1.62300000E-05  +1.83000000E-06
   -1.67600000E-05  +7.49000000E-06  +1.01500000E-05  -3.65200000E-05  -1.97500000E-05
   +2.12287000E-03  +2.20380000E-04  +4.86120000E-04  +2.27392000E-02  +1.43733210E-01
   +2.64127470E-01  -4.97430000E-04  +2.89300000E-05  +2.28700000E-04  +1.05971100E-02
   +5.28394000E-03  -1.68447000E-03  +2.85706000E-03  +3.18209000E-03  -6.51651000E-03
   -5.64522200E-02  +3.73604000E-02  -5.86824100E-02  +3.93061000E-03  -4.91970000E-04
   +1.14202000E-03  +1.56940000E-03  +9.44040000E-04  +3.35830000E-04  -9.23890000E-04
   +5.57680000E-04  -2.19035000E-03  -1.24900000E-05  -1.38120000E-04  -7.17600000E-05
   -1.61503000E-03  -8.26120000E-04  +8.96500000E-05  +1.75537000E-03  -2.11386000E-03
   +1.83909000E-03  -2.78840000E-04  +4.71700000E-05  +3.04000000E-06  +3.88000000E-05
   -1.69600000E-05  -5.03900000E-05  +5.96000000E-06  +5.45100000E-05  -4.55600000E-05
   -6.33200000E-05  +4.70100000E-05  +8.00700000E-05  -2.32900000E-05  -3.67000000E-06
   -1.76100000E-05  +3.94800000E-05  -3.74600000E-05  +1.04300000E-05  +4.97000000E-05
   -1.27000000E-06  -2.16400000E-05  +5.42360000E-04  +5.41880000E-04  +1.88110000E-04
   -2.21600000E-05  -1.44000000E-06  +1.25300000E-05  +5.55000000E-06  -8.63000000E-06
   -4.13000000E-06  -2.51000000E-06  +1.45100000E-05  -1.49900000E-05  +1.72600000E-05
   -4.14000000E-06  +8.71000000E-06  -1.98000000E-05  -3.29000000E-05  -1.30000000E-06
   -5.60100000E-05  +1.35050000E-04  -2.30000000E-04  -2.78700000E-05  +1.67000000E-05
   -6.15000000E-06  +9.68000000E-06  -1.91800000E-05  -1.67400000E-05  +4.47000000E-06
   +1.03200000E-05  +7.06000000E-05  -1.19500000E-05  +3.62800000E-05  +2.51800000E-05
   -4.41000000E-06  +1.52100000E-05  +2.22600000E-05  -1.39790000E-04  -3.84300000E-05
   +4.42900000E-05  +3.03710000E-04  -5.76400000E-05  +1.31720000E-04  +4.57843400E-02
   -8.23400000E-05  -2.80610000E-04  -2.29920000E-04  +2.40178000E-03  -1.19566000E-03
   -3.85376000E-03  +7.72463000E-03  -1.17302200E-02  +2.82988800E-02  +3.67425900E-02
   -1.18842550E-01  +1.15131060E-01  -3.68503000E-03  +1.02380100E-02  -1.58199600E-02
   +6.27070000E-04  -2.03286000E-03  -2.61938000E-03  +2.08350000E-04  +1.45310000E-04
   +1.42720000E-04  -2.34900000E-05  +2.54700000E-05  +4.67100000E-05  -6.47250000E-04
   +9.11680000E-04  +2.49698000E-03  +1.78392000E-03  -1.33939000E-03  +1.27849000E-03
   +7.98300000E-05  -3.65800000E-05  -1.79100000E-05  +2.49300000E-05  +4.02400000E-05
   +1.67300000E-05  -3.59300000E-05  +8.19600000E-05  -3.55500000E-05  -3.10300000E-05
   +1.87600000E-05  +4.93000000E-05  -1.60600000E-05  -1.49000000E-06  -3.21600000E-05
   -2.51400000E-05  +2.50000000E-06  -3.30600000E-05  -2.00400000E-05  +5.94000000E-06
   -1.34100000E-05  -1.05940000E-04  -6.73600000E-05  -2.59800000E-05  -5.28000000E-06
   +2.83000000E-06  -1.17000000E-06  -6.02000000E-06  +1.55000000E-06  -4.28000000E-06
   +7.14000000E-06  -1.33600000E-05  -7.07000000E-06  +1.90300000E-05  -5.95000000E-05
   +5.69000000E-06  -3.58000000E-05  -1.90300000E-05  +4.80000000E-07  -1.14700000E-05
   -3.36300000E-05  +4.64600000E-05  +6.65000000E-06  +3.59000000E-05  -2.98500000E-05
   +7.80000000E-07  +1.90000000E-06  +2.29400000E-05  +1.60900000E-05  -7.21000000E-06
   +2.19000000E-06  +2.44000000E-06  +3.60600000E-05  +3.68000000E-06  -1.73700000E-05
   -3.95000000E-05  -1.23900000E-05  -5.17000000E-06  +7.38700000E-05  +1.51580000E-04
   -3.22160000E-04  +4.93890000E-04  -7.57090000E-04  -4.21678500E-02  +1.23579350E-01
   +1.82200000E-04  -5.42010000E-04  +2.74300000E-04  -8.41050000E-04  -1.80775000E-03
   +1.00561000E-03  +1.06819000E-03  -3.31337000E-03  +5.77063000E-03  -5.86386500E-02
   +1.15489830E-01  -2.64772390E-01  -8.10462000E-03  +1.80760100E-02  -1.90956000E-02
   +5.76490000E-04  -3.98998000E-03  -3.03332000E-03  +1.10500000E-05  -8.03500000E-05
   +3.91160000E-04  +6.41200000E-05  +5.61300000E-05  +1.48600000E-05  +1.07854000E-03
   -1.18054000E-03  +4.25598000E-03  -1.59150000E-04  +2.59250000E-04  +9.88900000E-05
   +2.92300000E-05  -1.97000000E-05  +2.87500000E-05  -7.17800000E-05  +1.79200000E-05
   +6.56000000E-06  +4.68100000E-05  -6.62500000E-05  +4.82100000E-05  +8.14000000E-06
   -3.22000000E-06  -1.60000000E-05  -1.77000000E-05  +9.38000000E-06  +1.01700000E-05
   +5.54000000E-06  -3.71000000E-06  -6.70600000E-05  +1.28000000E-05  -2.22500000E-05
   +1.63700000E-05  -6.87200000E-05  -1.32030000E-04  -3.26400000E-05  +8.37000000E-06
   +1.02500000E-05  -1.18100000E-05  -4.52000000E-06  +3.79000000E-06  -2.42000000E-06
   -7.97000000E-06  -1.64000000E-05  +4.63800000E-05  -2.24000000E-06  +1.93400000E-05
   +3.17000000E-06  +1.28600000E-05  +1.78800000E-05  +2.54000000E-06  +1.51800000E-05
   -1.25900000E-05  +5.79100000E-05  +1.11600000E-05  -1.19700000E-05  -2.17000000E-06
   -2.45700000E-05  +7.20000000E-07  +2.45400000E-05  -7.55000000E-06  +8.16000000E-06
   -4.21000000E-06  +4.19000000E-06  -1.15600000E-05  -6.28000000E-06  -3.20000000E-06
   +1.55900000E-05  +6.17000000E-06  -4.85700000E-05  +1.50190000E-04  +5.33700000E-05
   -5.82180000E-04  +6.66780000E-04  -1.04567000E-03  +6.45273600E-02  -1.24184560E-01
   +2.75086440E-01  +2.55690000E-04  +5.39570000E-04  -1.39694000E-03  +2.27238000E-03
   -2.45718000E-03  -5.11514000E-03  -4.36777700E-02  +1.00682000E-02  +1.01170600E-02
   +9.86629000E-03  +6.80140000E-03  +6.99295000E-03  +1.26466100E-02  +4.24584000E-03
   -2.23272000E-03  -2.05962000E-03  -4.15800000E-04  +4.24170000E-04  +2.55450000E-04
   +4.20060000E-04  -6.36080000E-04  -6.99000000E-05  -1.90360000E-04  +3.47260000E-04
   -2.70731000E-03  -4.78520000E-04  +5.48540000E-04  +1.38486000E-03  -1.41536000E-03
   +1.28219000E-03  +1.61560000E-04  -1.97100000E-05  -1.43790000E-04  -3.10100000E-05
   +1.35000000E-04  +1.42990000E-04  -6.02800000E-05  +9.33900000E-05  -1.02740000E-04
   -1.27560000E-04  +2.59900000E-05  -5.03700000E-05  +1.42180000E-04  -7.19300000E-05
   +1.31200000E-05  -1.65350000E-04  +1.00930000E-04  +1.24270000E-04  +1.09820000E-04
   -5.93700000E-05  -1.06800000E-05  +7.50600000E-05  +1.34800000E-05  +2.30900000E-05
   -1.75100000E-05  +1.09900000E-05  +4.56000000E-06  +1.08600000E-05  -6.20000000E-07
   -1.08900000E-05  -1.69300000E-05  -2.11400000E-05  -3.90400000E-05  -1.07720000E-04
   -2.40410000E-04  -1.40000000E-05  -2.00300000E-05  -1.18000000E-06  +5.33000000E-06
   -1.71000000E-06  +2.62500000E-05  -4.48000000E-06  -1.96800000E-05  +2.20200000E-05
   -2.48300000E-05  -5.65000000E-06  +1.67800000E-05  -1.44000000E-05  +4.33010000E-04
   -6.41790000E-04  +5.70400000E-05  -2.90900000E-05  +1.41420000E-04  -1.08200000E-04
   -5.47600000E-05  +3.06500000E-05  -4.43600000E-05  +1.05535000E-03  +7.28800000E-05
   -5.24780000E-04  -1.26750000E-04  -4.40700000E-05  +1.04430000E-04  -7.11934000E-03
   -2.22416000E-03  +8.75800000E-04  +2.78966700E-02  +1.02716000E-03  -2.22951000E-03
   +2.26590000E-03  -1.11990000E-04  +9.83173000E-03  +1.42045600E-02  +1.06472000E-02
   -1.26909510E-01  -1.22236160E-01  +2.77658000E-03  -1.21074400E-02  -2.99354300E-02
   +4.93922000E-03  -1.39788000E-03  +4.01190000E-03  -6.30720000E-04  -4.37200000E-05
   -6.37600000E-05  -1.50210000E-04  +7.44230000E-04  -5.25790000E-04  -2.46580000E-04
   -1.77588000E-03  +7.37970000E-04  -2.63910000E-04  -2.56182000E-03  -2.06025000E-03
   -1.15675000E-03  +7.01180000E-04  -9.10750000E-04  -8.54300000E-05  -7.48200000E-05
   -1.71160000E-04  -5.71800000E-05  -1.30000000E-05  +5.69100000E-05  -6.58000000E-06
   -4.03700000E-05  -3.37600000E-05  -3.00200000E-05  +2.87000000E-06  -5.42700000E-05
   +5.61600000E-05  -1.68700000E-05  +2.18000000E-05  +1.35000000E-06  +5.51500000E-05
   +5.96000000E-05  +5.36500000E-05  -2.57600000E-05  +5.00000000E-06  +1.71800000E-04
   -3.64000000E-05  -1.58990000E-04  -7.96000000E-06  +1.45000000E-06  +1.33000000E-06
   +5.20000000E-06  -7.99000000E-06  +2.88000000E-06  +2.22000000E-06  +8.60000000E-07
   -2.66000000E-06  -8.15900000E-05  +4.20000000E-07  -2.30000000E-05  +1.91500000E-05
   +1.71500000E-05  +1.60000000E-07  -3.32500000E-05  -2.14400000E-05  -2.11200000E-05
   -1.57000000E-06  +1.71100000E-05  +2.15400000E-05  +1.08100000E-05  +2.51400000E-05
   -1.13970000E-04  -7.67080000E-04  -2.55265000E-03  +3.69310000E-04  +3.18600000E-05
   -1.63500000E-05  -1.68400000E-05  +3.31400000E-05  +7.77400000E-05  -1.51530000E-04
   +3.88120000E-04  +7.45060000E-04  +6.96560000E-04  -8.05900000E-05  +5.36000000E-05
   -1.36920000E-04  -2.14714000E-03  +1.33600000E-04  +5.73880000E-04  -1.44202100E-02
   +1.37371990E-01  -1.46396000E-03  +4.64703000E-03  -2.58814000E-03  +3.20855000E-03
   -1.54557500E-02  -1.95532300E-02  +1.06834200E-02  -1.24341470E-01  -2.68832280E-01
   -1.30284000E-03  +2.72986000E-03  +4.71748000E-03  -1.63555000E-03  +1.05953000E-03
   +3.70740000E-04  +4.61100000E-04  -7.88000000E-05  +8.25020000E-04  -6.27550000E-04
   -1.11574000E-03  -2.70940000E-04  -2.13130000E-04  -3.35480000E-04  -5.64870000E-04
   +4.27970000E-04  -1.94420000E-04  +2.54940000E-04  -9.69800000E-05  -5.09000000E-06
   +2.85169000E-03  +6.81000000E-06  +1.35860000E-04  +1.28290000E-04  -7.56400000E-05
   -9.76600000E-05  -2.30980000E-04  +1.18000000E-04  -9.39500000E-05  +9.91400000E-05
   +7.32600000E-05  +1.59200000E-05  +8.33900000E-05  -1.41630000E-04  +8.38400000E-05
   +3.28800000E-05  +3.88100000E-05  -7.58000000E-05  -1.25420000E-04  -5.85200000E-05
   +4.11800000E-05  +8.43000000E-06  +8.57600000E-05  +2.31850000E-04  +1.66820000E-04
   +5.50000000E-06  -1.04100000E-05  -8.70000000E-07  -1.77200000E-05  +3.64000000E-06
   +5.34000000E-06  -2.62400000E-05  -4.12000000E-06  +5.59700000E-05  +1.42740000E-04
   +1.04890000E-04  +1.45580000E-04  +1.36000000E-06  -6.58000000E-06  -1.60000000E-06
   +4.25100000E-05  +1.16980000E-04  -5.79300000E-05  +6.17000000E-06  -4.81700000E-05
   -2.16500000E-05  -6.03900000E-05  -4.25000000E-05  +1.40010000E-04  +1.49520000E-04
   +2.57730000E-04  +1.28280000E-03  +3.33500000E-05  -9.56200000E-05  +8.86300000E-05
   -5.02000000E-06  -1.69740000E-04  +5.05610000E-04  -2.84650000E-04  -9.37360000E-04
   -1.15395000E-03  +1.62800000E-05  -1.46720000E-04  +5.09600000E-05  +7.54000000E-04
   +4.66200000E-05  +1.02436000E-03  -1.01754300E-02  +1.33796570E-01  +2.80925450E-01
   +1.35996000E-03  -5.59890000E-04  +8.49510000E-04  -2.81412700E-02  -2.70666300E-02
   +3.84453000E-03  +7.76650000E-04  -8.57130000E-04  -9.71480000E-04  +3.81300000E-05
   -1.36370000E-04  -6.69900000E-05  +8.01500000E-05  +1.21847000E-03  +2.21320000E-04
   -1.40500000E-05  -1.11310000E-04  -5.00600000E-05  -5.72345000E-03  +3.49681000E-03
   +3.40660000E-04  +4.78540000E-04  +8.04220000E-04  +2.55470000E-04  +1.83140000E-04
   -9.86910000E-04  -8.61400000E-05  -2.55177430E-01  -2.18162100E-01  +3.57490900E-02
   -6.07610000E-04  -1.30353000E-03  +2.90100000E-04  -8.14600000E-05  +9.72100000E-05
   +1.38590000E-04  -2.59600000E-05  +1.51630000E-04  -4.50300000E-05  -7.57000000E-06
   -2.75700000E-05  +5.74500000E-05  -1.03350000E-04  +1.56820000E-04  -7.52800000E-05
   +2.86700000E-05  +3.13200000E-05  -1.62790000E-04  -4.77900000E-05  +3.41500000E-05
   -8.40000000E-07  +3.60440000E-04  +5.04770000E-04  -2.56570000E-04  -3.03200000E-05
   -1.41700000E-05  -4.18000000E-06  -2.26600000E-05  -2.86000000E-06  +4.02000000E-06
   -4.35100000E-05  -7.73600000E-05  +9.37100000E-05  -4.43900000E-05  -8.00600000E-05
   -1.19000000E-05  -2.21200000E-05  +1.90000000E-06  +8.90000000E-07  +1.11120000E-04
   +1.52500000E-05  -6.41100000E-05  +8.62900000E-05  -1.66540000E-04  +1.84000000E-04
   +3.25000000E-06  -6.44200000E-05  +1.28500000E-05  -1.44700000E-05  -9.41800000E-05
   -8.12500000E-05  -6.60000000E-07  -1.59420000E-04  -4.04800000E-05  +1.11900000E-04
   +1.01800000E-04  +2.19900000E-05  -2.79300000E-05  +1.91930000E-04  +5.07300000E-05
   -2.87850000E-04  -1.68220000E-04  +4.05700000E-05  -2.40510000E-04  -1.77700000E-04
   +4.44400000E-05  -1.47820000E-04  +1.15150000E-04  -6.98700000E-05  +2.87193970E-01
   +1.57023000E-03  +1.78157000E-03  +1.89600000E-05  +2.06987900E-02  +1.08716800E-02
   -3.10257000E-03  +1.10876000E-03  +1.54704000E-03  -6.98140000E-04  -2.55500000E-04
   -8.69640000E-04  +1.49770000E-04  +5.24620000E-04  -1.60740000E-04  +9.92500000E-05
   -3.41600000E-04  -9.03030000E-04  +8.40000000E-06  +2.49937000E-03  -1.52249000E-03
   -4.23770000E-04  -1.93100000E-05  -6.18290000E-04  +1.42720000E-04  -1.08090000E-04
   +1.16230000E-04  -4.29000000E-05  -2.68396690E-01  -3.19732270E-01  +3.89063900E-02
   +5.27100000E-04  +7.46830000E-04  -3.17800000E-05  -3.11300000E-05  +3.30600000E-05
   -1.22550000E-04  +6.44500000E-05  -1.18620000E-04  -2.08500000E-05  -4.41000000E-05
   +6.28400000E-05  +6.24200000E-05  -4.42500000E-05  -3.26300000E-05  +1.78100000E-05
   +1.57900000E-05  +2.16200000E-05  +1.05420000E-04  +1.05700000E-04  -6.08300000E-05
   -5.13000000E-06  +5.47000000E-05  +2.22400000E-05  +1.68100000E-05  +4.79000000E-06
   +1.24000000E-05  +7.84000000E-06  +1.44100000E-05  +1.75000000E-06  -9.62000000E-06
   -2.27000000E-05  +7.27000000E-06  -5.46000000E-05  +4.80000000E-06  +3.55900000E-05
   +2.71900000E-05  +1.18500000E-05  -4.66000000E-06  +3.41000000E-06  -1.71100000E-05
   +5.42400000E-05  -4.62600000E-05  -4.16400000E-05  +1.02690000E-04  -3.13740000E-04
   -7.91700000E-05  +2.38800000E-05  +1.19700000E-05  -8.10400000E-05  +6.28600000E-05
   -4.97700000E-05  -3.46880000E-04  +4.61690000E-04  +1.92720000E-04  -2.03320000E-04
   +1.52870000E-04  -5.80100000E-05  -3.37000000E-05  +1.16160000E-04  +2.86000000E-05
   -2.02120000E-04  -1.22450000E-04  +3.92500000E-05  -1.68930000E-04  -1.29850000E-04
   +2.31300000E-05  -6.30300000E-05  +5.21200000E-05  -1.61300000E-05  +2.43294940E-01
   +3.07988870E-01  +7.22170000E-04  +7.85450000E-04  +3.50420000E-04  +3.56751000E-03
   +3.72539000E-03  -2.86015000E-03  -7.97890000E-04  -7.73200000E-04  +6.60890000E-04
   +2.59140000E-04  -1.34550000E-04  -6.87350000E-04  +5.38610000E-04  -2.18200000E-05
   +3.16518000E-03  -4.88220000E-04  +2.14300000E-04  -5.89870000E-04  +8.23890000E-04
   -7.37070000E-04  -5.89020000E-04  -2.54070000E-04  -5.20670000E-04  +3.24840000E-04
   -2.06910000E-04  +1.00720000E-04  -1.02923000E-03  +3.60372800E-02  +3.20170800E-02
   -7.30836000E-03  +7.04200000E-05  +2.51980000E-04  +2.92150000E-04  +5.72100000E-05
   +3.27300000E-05  -5.56700000E-05  +2.60600000E-05  -2.18300000E-05  -2.95800000E-05
   +1.02000000E-05  +2.46200000E-05  +8.47900000E-05  -3.84600000E-05  -1.30500000E-05
   -5.03100000E-05  -8.07000000E-06  -7.62300000E-05  +9.26700000E-05  -6.91000000E-06
   -2.48000000E-06  -2.56700000E-05  +1.42550000E-04  -4.98800000E-05  +1.10560000E-04
   +8.18000000E-06  -7.10000000E-07  +8.28000000E-06  +1.46600000E-05  +3.73000000E-06
   -4.64000000E-06  +1.39500000E-05  +2.32200000E-05  -5.62500000E-05  -3.10000000E-06
   -1.96700000E-05  -1.37400000E-05  -6.01000000E-06  -1.56900000E-05  +7.60000000E-07
   +1.24000000E-06  -4.06300000E-05  -3.69400000E-05  +9.64100000E-05  -7.54400000E-05
   +2.42670000E-04  +1.66440000E-04  +9.05000000E-06  -8.84400000E-05  +2.93900000E-05
   +5.87900000E-05  -5.20700000E-05  -3.18610000E-04  +8.81000000E-05  -5.41500000E-05
   -1.85990000E-04  +6.44500000E-05  -7.10800000E-05  +3.18530000E-04  +1.37860000E-04
   -6.82220000E-04  -3.14000000E-06  +1.04240000E-04  -1.29780000E-04  +4.04400000E-05
   -6.30000000E-05  -1.36810000E-04  -4.13940000E-04  -2.09530000E-04  -3.61680000E-04
   -4.02129500E-02  -3.48662500E-02  +9.57980000E-03
end_hess

