# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.92297260    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.70257432E+00  +1.16498611E+00  -1.53070379E+00
   006   +1.81097442E+00  +9.98454595E-01  +1.28605846E-01
   006   +1.91079738E+00  -9.95672843E-01  +2.05100342E+00
   006   +3.92129962E+00  -2.48953138E+00  +2.42660287E+00
   006   +6.18758101E+00  -2.12540121E+00  +8.90429683E-01
   006   +5.78828541E+00  -7.34338713E-01  -1.58673201E+00
   006   -4.50407757E-01  +2.78434771E+00  +2.26893383E-01
   006   -2.72404009E-01  +4.29892957E+00  +2.69781145E+00
   008   +8.27437308E+00  -2.88871883E+00  +1.44679623E+00
   008   +8.03979761E+00  +2.60068220E-01  -2.52478949E+00
   006   -2.87092282E+00  +1.20317446E+00  +7.02575671E-02
   006   -4.86090643E+00  +1.43665272E+00  +1.77002937E+00
   006   -7.04412272E+00  +8.91244298E-03  +1.53772136E+00
   006   -7.28195684E+00  -1.70701025E+00  -4.26351799E-01
   006   -5.31446318E+00  -1.97707244E+00  -2.14557665E+00
   006   -3.14978257E+00  -5.36775228E-01  -1.88440056E+00
   008   -9.45127398E+00  -3.06751629E+00  -5.76594297E-01
   006   -4.43874190E-01  +4.67317876E+00  -1.97161043E+00
   001   -9.38234048E+00  -4.17514540E+00  -2.00416182E+00
   001   -5.47117149E+00  -3.31920421E+00  -3.68536490E+00
   001   -1.63093706E+00  -7.88061411E-01  -3.23348773E+00
   001   -4.73777191E+00  +2.75333367E+00  +3.32660144E+00
   001   -8.57585610E+00  +2.09774025E-01  +2.87512384E+00
   001   -2.11574976E+00  +5.86927437E+00  -1.84853716E+00
   001   +1.21870837E+00  +5.89065889E+00  -1.90618970E+00
   001   -4.86027732E-01  +3.72048822E+00  -3.79699296E+00
   001   -3.60147511E-01  +3.09391957E+00  +4.36682118E+00
   001   +1.51733847E+00  +5.31662869E+00  +2.74606493E+00
   001   -1.79203583E+00  +5.68442653E+00  +2.82688667E+00
   001   +3.76469803E+00  +2.59056178E+00  -2.99282184E+00
   001   +5.09891866E+00  -2.26937242E+00  -2.84262071E+00
   001   +4.01028455E+00  -3.82720789E+00  +3.96880205E+00
   001   +2.76905007E-01  -1.20535116E+00  +3.26832505E+00
   001   +9.37441024E+00  -6.17166339E-01  -1.64670098E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -2.09000000E-06  +3.70000000E-07  +1.86000000E-06
   -2.20000000E-07  +1.41000000E-06  -1.48000000E-06
   +9.30000000E-07  -2.29000000E-06  +2.66000000E-06
   -2.41000000E-06  +9.30000000E-07  -1.50000000E-06
   +1.18000000E-06  -1.18000000E-06  -8.00000000E-07
   +1.75000000E-05  +5.54000000E-06  -9.14000000E-06
   -8.30000000E-07  -1.93000000E-06  +9.90000000E-07
   -1.42000000E-06  -2.00000000E-07  +2.43000000E-06
   +1.24000000E-06  +1.15000000E-06  +3.10000000E-07
   -1.44000000E-05  -6.00000000E-06  +5.81000000E-06
   -4.80000000E-07  +4.40000000E-07  -2.26000000E-06
   -6.00000000E-07  -2.79000000E-06  -1.26000000E-06
   +1.20000000E-06  -1.44000000E-06  -1.66000000E-06
   -1.85000000E-06  -1.42000000E-06  -1.35000000E-06
   +5.50000000E-07  +6.70000000E-07  -2.60000000E-07
   -1.32000000E-06  -4.00000000E-08  +6.30000000E-07
   +2.91000000E-06  +8.00000000E-07  -1.53000000E-06
   +5.10000000E-07  +7.90000000E-07  +6.50000000E-07
   +1.80000000E-07  -1.01000000E-06  -3.38000000E-06
   +7.00000000E-07  +7.00000000E-08  -2.69000000E-06
   +9.90000000E-07  +2.00000000E-08  -9.30000000E-07
   -1.23000000E-06  -6.70000000E-07  +1.08000000E-06
   -1.05000000E-06  -1.47000000E-06  -3.30000000E-07
   -5.10000000E-07  +7.30000000E-07  +1.64000000E-06
   +1.20000000E-07  +6.10000000E-07  +1.79000000E-06
   +3.70000000E-07  +2.42000000E-06  +6.60000000E-07
   -2.10000000E-07  -1.26000000E-06  +1.04000000E-06
   -6.70000000E-07  -5.90000000E-07  +2.00000000E-06
   +1.60000000E-07  -1.50000000E-07  +1.84000000E-06
   +4.00000000E-08  +2.96000000E-06  +3.60000000E-07
   +1.74000000E-06  +4.80000000E-06  +1.50000000E-06
   +1.00000000E-07  -1.61000000E-06  -1.10000000E-07
   -9.10000000E-07  -1.31000000E-06  +7.10000000E-07
   -1.80000000E-07  +1.66000000E-06  +7.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.81391340E-01  -9.22826300E-02  +4.62431470E-01  -2.60745710E-01  -2.16700900E-01
   +5.69892220E-01  -3.27769000E-01  -3.67732000E-03  +2.15155610E-01  +6.13496500E-01
   +2.82824000E-03  -9.97746900E-02  +3.33124800E-02  -9.63785400E-02  +3.99967110E-01
   +2.08134380E-01  +4.23782000E-02  -2.65644350E-01  -2.45458560E-01  -1.39171830E-01
   +5.19492750E-01  +1.08554500E-02  -2.11106700E-02  +1.68014200E-02  -1.02640240E-01
   +5.62146000E-03  +1.96777600E-02  +7.22072750E-01  -1.78158500E-02  +3.40002000E-03
   +2.34605500E-02  +2.44378100E-02  -1.53391220E-01  +6.52984200E-02  -2.11223700E-01
   +4.51157500E-01  +1.86314400E-02  +1.92956000E-02  -3.04968600E-02  -5.25770000E-04
   +7.83000600E-02  -1.46562730E-01  -1.30658430E-01  -1.81546450E-01  +4.19407090E-01
   -1.01615100E-02  +4.39769000E-03  +8.99909000E-03  +1.31146800E-02  +1.41131300E-02
   -2.24486100E-02  -3.55504100E-01  +1.88453010E-01  -1.17135700E-02  +6.33391860E-01
   +9.23194000E-03  -1.61455000E-03  -6.42344000E-03  +1.45654900E-02  -2.27417900E-02
   +2.13834900E-02  +2.01157280E-01  -2.19120730E-01  +5.02924500E-02  -2.16805330E-01
   +4.72664170E-01  +3.11292000E-03  -2.65586000E-03  -2.95095000E-03  -2.33596400E-02
   +1.70553500E-02  +4.93202000E-03  -3.64858000E-02  +7.08475800E-02  -1.13627300E-01
   -4.59855800E-02  -2.81686090E-01  +4.66038870E-01  +8.35770000E-04  +6.55818000E-03
   -2.38499700E-02  -5.04082000E-03  -4.01748000E-03  +7.10229000E-03  -3.89138500E-02
   +1.63391400E-02  -2.17108000E-03  -1.44934870E-01  -2.56654400E-02  +6.76237000E-02
   +8.95563640E-01  +1.47810000E-02  -1.68682000E-02  +1.89308600E-02  -6.15773000E-03
   -5.26568000E-03  +4.05390000E-04  +1.91790300E-02  +9.61168000E-03  -1.86021000E-02
   -2.31305900E-02  -1.03953850E-01  +3.50568000E-02  -1.79230600E-01  +3.61863140E-01
   -1.61948400E-02  +5.37053000E-03  +1.02607100E-02  +4.36900000E-03  -2.58812000E-03
   -7.74493000E-03  +5.12010000E-04  -1.48018100E-02  +2.21592500E-02  +6.08443900E-02
   +4.31540100E-02  -1.61184170E-01  +4.69874300E-02  -1.58429460E-01  +4.64387150E-01
   -1.44463590E-01  +8.11652600E-02  +1.98495000E-03  -1.68943000E-02  +1.67600000E-02
   +5.76225000E-03  -2.19877000E-03  -3.48083000E-03  -1.99709000E-03  +4.64448000E-03
   -1.23025800E-02  +2.43751500E-02  -7.44936800E-02  -5.07185000E-03  +1.49585100E-02
   +5.68291060E-01  +5.76330400E-02  -1.49307300E-01  +2.10803500E-02  +8.40949000E-03
   +1.54546300E-02  -1.56857000E-02  +1.33431000E-03  -1.43335400E-02  +6.27546000E-03
   -5.36525000E-03  +1.42087400E-02  +1.88374600E-02  +9.40050000E-03  -9.84983000E-02
   +3.69317800E-02  -1.46826900E-02  +4.83831310E-01  +5.01976000E-03  +1.45864900E-02
   -7.93528300E-02  +2.04705500E-02  -9.50499000E-03  -4.56962000E-03  +6.22480000E-04
   -9.23364000E-03  -3.76120000E-04  +1.12786000E-03  +1.04450600E-02  -5.42390000E-03
   +6.10507000E-03  +3.63981900E-02  -1.45691310E-01  -1.00956100E-02  -2.96762600E-02
   +4.63955110E-01  -1.83077600E-02  +1.52155100E-02  +4.83155000E-03  -1.36989500E-01
   +4.64610700E-02  +6.96384000E-03  -3.76850000E-04  +5.64805000E-03  -6.35983000E-03
   +2.00130000E-03  -2.06513000E-03  +1.84884000E-03  -1.74941000E-03  -4.44810000E-04
   +8.07890000E-04  +2.63801000E-03  +2.77661000E-03  +4.57921000E-03  +4.72158180E-01
   +3.11059000E-03  +6.14658000E-03  -4.06083000E-03  +4.93991000E-02  -1.17502360E-01
   +4.18914000E-03  +1.90377200E-02  -1.69464200E-02  +1.67595000E-03  -1.48930000E-03
   -8.05400000E-04  +3.06864000E-03  +4.56340000E-04  -9.62460000E-04  +6.61040000E-04
   +2.00653000E-03  +5.34007000E-03  +5.47578000E-03  -3.00075000E-03  +4.85639590E-01
   +1.72631000E-02  -1.37656100E-02  +3.43849000E-03  +4.07883000E-03  +6.02612000E-03
   -8.09232000E-02  -1.91506400E-02  +1.46015000E-02  +2.55069000E-03  +9.18320000E-04
   +3.18449000E-03  -2.75072000E-03  +1.07096000E-03  +3.03540000E-04  -1.28457000E-03
   +3.71660000E-03  +6.88546000E-03  +2.30901000E-03  -8.96820000E-04  -2.64439000E-03
   +4.87073530E-01  -1.85171000E-03  +2.53633000E-03  -9.26980000E-04  -2.07977000E-03
   +1.53951300E-02  +2.50576900E-02  -1.57880000E-04  +5.13610000E-04  +3.25400000E-04
   +1.19250000E-04  -4.94500000E-05  +3.77700000E-05  +3.06910000E-04  -3.89260000E-04
   +7.03330000E-04  -6.06090000E-04  -1.53188000E-03  -1.10780000E-03  -7.58987000E-02
   -7.43740000E-04  -1.96427000E-03  +5.86629190E-01  -7.03700000E-04  -1.50687000E-03
   +1.10574000E-03  +5.99712000E-03  -1.67893800E-02  -2.19276400E-02  +4.24340000E-04
   -5.99270000E-04  -4.43740000E-04  -3.44710000E-04  +3.75600000E-04  +9.51000000E-06
   +2.07180000E-04  +3.40640000E-04  -5.78870000E-04  +5.77360000E-04  +9.80540000E-04
   +7.70230000E-04  -4.40757000E-03  -1.02911190E-01  -4.49267900E-02  -5.39841000E-03
   +5.48973540E-01  -1.85873000E-03  +1.73310000E-04  +1.99160000E-04  +8.28777000E-03
   -9.18038000E-03  -4.09771000E-03  -1.40044000E-03  +6.36910000E-04  +7.29750000E-04
   +6.18470000E-04  +1.96750000E-04  -7.55440000E-04  -2.86170000E-04  -1.51970000E-04
   +1.05016000E-03  +3.84540000E-04  -5.15000000E-05  +1.71670000E-04  -6.93812000E-03
   -4.01886200E-02  -1.46379890E-01  -1.13408900E-02  -5.84987400E-02  +5.02455750E-01
   +1.41450000E-03  +2.78916000E-03  -1.30221000E-03  +3.12745000E-03  +1.09518000E-03
   -4.83846000E-03  +2.28231000E-03  -1.20519500E-02  +1.50401200E-02  -7.58551700E-02
   +2.49654900E-02  -1.33320000E-03  -6.11672990E-01  +1.98035820E-01  -1.41790340E-01
   -3.17763300E-02  +1.31976800E-02  -2.93530600E-02  +1.15062000E-03  -6.38310000E-04
   -4.41750000E-04  -4.77220000E-04  -1.26000000E-05  +1.54990000E-04  +7.00009620E-01
   -4.39500000E-04  +2.23840000E-04  +9.13310000E-04  -2.56790000E-04  -5.56330000E-04
   +1.67212000E-03  -3.89642000E-03  +4.11936000E-03  +7.52770000E-04  +1.34575800E-02
   +2.04687500E-02  -3.55582000E-03  +1.89299250E-01  -1.52967010E-01  +7.23653600E-02
   +2.52370000E-02  +2.54038000E-03  +2.21099700E-02  -3.43350000E-04  +3.61130000E-04
   -1.94160000E-04  +2.48570000E-04  -1.22490000E-04  +4.38400000E-05  -2.32463010E-01
   +1.30626230E-01  +4.13510000E-03  +4.89140000E-04  -8.19580000E-03  -8.15250000E-04
   +7.45670000E-04  +7.29590000E-04  +4.50558000E-03  +3.10126000E-03  -4.07274000E-03
   +1.94351500E-02  -7.97871000E-03  +2.39594100E-02  -1.34391390E-01  +6.71720500E-02
   -1.31688980E-01  -3.82596900E-02  +2.93018800E-02  -1.10901800E-02  -1.36860000E-04
   -3.38820000E-04  +5.78240000E-04  -3.89700000E-04  +2.55690000E-04  -3.54030000E-04
   +1.62607460E-01  -9.06475300E-02  +1.27196970E-01  -3.83827400E-02  -1.50955000E-02
   +1.77671000E-02  -4.33353000E-03  +4.01484000E-03  -2.30241000E-03  +3.49790000E-04
   +1.44054000E-03  -2.11564000E-03  +3.47435000E-03  -3.38553000E-03  +3.11480000E-04
   -2.11053000E-02  -4.52983000E-03  +8.32445000E-03  -2.12265340E-01  -6.79627300E-02
   +6.78491900E-02  +5.78340000E-04  -5.29100000E-05  +2.34024000E-03  -1.10237000E-03
   +4.91860000E-04  -3.47780000E-04  +1.07850500E-02  +6.14436000E-03  -8.60439000E-03
   +5.68427590E-01  +1.95957100E-02  +1.57703100E-02  -7.15037000E-03  +1.87463000E-03
   -3.35745000E-03  +1.81837000E-03  +1.85400000E-04  +3.59240000E-04  +1.03685000E-03
   +7.41730000E-04  -4.55090000E-04  +2.40231000E-03  -1.89342100E-02  -1.11255000E-02
   +8.84232000E-03  -3.46315400E-02  -1.04733560E-01  +4.50774400E-02  -6.18540000E-04
   -7.91430000E-04  -1.72964000E-03  +3.95730000E-04  -3.72520000E-04  +1.26710000E-04
   -3.65996000E-03  +2.00843000E-03  +2.47039000E-03  -7.70945000E-02  +2.45731110E-01
   +4.06278000E-03  -2.81908000E-03  +1.14783000E-03  -2.41655000E-03  -6.01740000E-04
   +3.47961000E-03  -1.33394000E-03  +2.96557000E-03  -2.02239000E-03  -6.17630000E-04
   +2.78087000E-03  -6.66162000E-03  +3.15458100E-02  +2.00707400E-02  -1.74728300E-02
   +2.65313100E-02  +4.61030300E-02  -9.43344700E-02  -1.64280000E-04  +1.23110000E-04
   +2.91700000E-04  -1.41800000E-04  +1.23580000E-04  -8.54400000E-05  +6.97342000E-03
   -1.77900000E-04  -9.00270000E-04  +8.71074200E-02  -1.97332990E-01  +2.37908950E-01
   -6.14960000E-04  +8.62290000E-04  -1.94415000E-03  -3.74703200E-02  -8.91375000E-03
   +1.80375000E-03  -1.36450000E-04  -2.77890000E-04  -1.08152000E-03  -7.08100000E-05
   -7.18350000E-04  +6.86590000E-04  +1.27350000E-04  +2.86000000E-05  +3.89750000E-04
   +1.01281000E-03  +1.73520000E-03  +1.57362000E-03  -1.43238180E-01  -4.45052500E-02
   -1.19779000E-03  -2.28358000E-03  -5.38854000E-03  -5.03178000E-03  -4.20000000E-05
   -1.12600000E-05  -8.99600000E-05  +2.85900000E-05  -4.19880000E-04  +1.46700000E-05
   +5.65558460E-01  +1.71853000E-03  -2.91141000E-03  +2.19670000E-04  +1.10487000E-02
   +1.41764100E-02  +3.03410000E-04  +2.47121000E-03  +9.40800000E-05  +6.18780000E-04
   -6.22500000E-05  -1.89280000E-04  +1.44880000E-04  -3.42190000E-04  +5.53210000E-04
   -7.29140000E-04  -9.03820000E-04  -1.16154000E-03  -1.23519000E-03  -4.08005800E-02
   -1.03679780E-01  -1.23103100E-02  -1.66709900E-02  -1.25465600E-02  -3.11077000E-03
   +5.03980000E-04  -3.05850000E-04  +3.51480000E-04  +5.62430000E-04  +1.38060000E-04
   -2.15000000E-05  +1.16135160E-01  +4.08604900E-01  +2.64680000E-04  -9.27690000E-04
   +5.69400000E-05  +3.39244000E-03  +2.63000000E-03  -3.48370000E-04  -1.75881000E-03
   +4.34560000E-04  -6.03710000E-04  -1.84010000E-04  -1.71770000E-04  +3.33010000E-04
   +3.75700000E-05  +2.87900000E-04  -2.98320000E-04  -5.58000000E-05  -3.70760000E-04
   -2.26670000E-04  +2.88986000E-03  -1.02264300E-02  -8.33141200E-02  -2.61602800E-02
   -1.69476200E-02  -1.92810000E-03  -2.95000000E-06  -6.24800000E-05  +1.41210000E-04
   +6.50400000E-05  +7.93000000E-06  +5.72900000E-05  -1.27959220E-01  +1.92267070E-01
   +5.13099220E-01  -5.18850000E-04  +8.04170000E-04  +1.76140000E-04  -1.38379000E-03
   -1.63030000E-03  +2.20580000E-04  +5.90700000E-05  +6.12200000E-05  +3.58070000E-04
   +7.90900000E-05  +1.20810000E-04  -1.06080000E-04  -2.17630000E-04  -1.33240000E-04
   +5.51000000E-05  -1.13770000E-04  -7.47400000E-05  +6.43300000E-05  -1.93965300E-02
   -8.83940000E-04  +1.34716600E-02  -2.05476000E-03  -5.57710000E-04  +1.17551000E-03
   +1.03140000E-04  +1.52100000E-05  -2.27000000E-06  +2.74000000E-05  +5.59100000E-05
   +6.53000000E-06  -2.30235930E-01  -2.56613400E-02  +8.50540300E-02  +5.93204760E-01
   -5.35040000E-04  +7.25480000E-04  -6.50800000E-05  -8.62560000E-04  -2.29806000E-03
   +4.47550000E-04  +8.22700000E-05  -7.94000000E-06  +2.72560000E-04  -4.03000000E-05
   +2.25890000E-04  -1.32650000E-04  +5.13800000E-05  -1.15530000E-04  +1.44030000E-04
   +6.25000000E-06  -4.33700000E-05  +2.76400000E-05  -1.27962400E-02  +5.49815000E-03
   +1.18449300E-02  -1.10558000E-03  -7.49060000E-04  +7.65330000E-04  -7.37300000E-05
   +5.68900000E-05  -7.83800000E-05  -7.95200000E-05  +5.43900000E-05  +9.99000000E-06
   +1.49582100E-02  -1.00893350E-01  -5.21323900E-02  +1.62280110E-01  +4.38852490E-01
   -2.12950000E-04  +1.06320000E-04  +7.74500000E-05  -2.03645000E-03  -1.28778000E-03
   -2.75360000E-04  -1.81210000E-04  -4.02300000E-05  -5.64120000E-04  -2.69670000E-04
   -1.11830000E-04  +2.68940000E-04  +4.01610000E-04  +3.35900000E-05  +2.68800000E-05
   +3.34190000E-04  +4.06830000E-04  +3.32250000E-04  +1.19540000E-04  +3.56689000E-03
   +5.85548000E-03  -7.33520000E-04  +5.87720000E-04  +2.55960000E-04  -3.44110000E-04
   +7.82500000E-05  -4.50300000E-05  -1.37730000E-04  -8.97800000E-05  +3.87000000E-05
   +1.34659500E-01  -2.48120300E-02  -1.92981260E-01  -1.16943130E-01  +2.53138610E-01
   +5.42130770E-01  -1.64500000E-05  -4.81400000E-05  -2.57290000E-04  -1.50070000E-04
   -7.96740000E-04  +8.44600000E-05  +3.71000000E-05  -1.65970000E-04  +2.79490000E-04
   +3.15400000E-05  +7.04100000E-05  -1.46510000E-04  +2.13680000E-04  -1.10210000E-04
   +1.67360000E-04  +2.36360000E-04  +1.45270000E-04  +5.27900000E-05  +4.87380000E-04
   +2.74120000E-04  +4.07165000E-03  +2.81390000E-04  +4.70590000E-04  +2.27430000E-04
   -1.54770000E-04  +8.08300000E-05  -9.70700000E-05  -1.42110000E-04  -1.96600000E-05
   -2.35000000E-06  -4.68529200E-02  +3.80554000E-03  +4.26619300E-02  -2.72849540E-01
   -1.40695350E-01  -2.44336900E-02  +6.49452010E-01  -8.76100000E-05  +4.70500000E-05
   -3.29830000E-04  -7.68280000E-04  -1.17049000E-03  +8.47400000E-05  -1.09550000E-04
   -2.47250000E-04  +2.53140000E-04  +1.51000000E-06  +3.67100000E-05  -9.55000000E-05
   +2.70890000E-04  -1.32160000E-04  +1.86210000E-04  +3.37690000E-04  +2.55480000E-04
   +1.78960000E-04  -7.85830000E-04  +3.65224000E-03  -2.82229000E-03  -4.10760000E-04
   -4.32810000E-04  -4.44400000E-05  -2.22790000E-04  +1.23790000E-04  -1.15980000E-04
   -1.88020000E-04  -2.86300000E-05  +5.33000000E-06  -2.69573800E-02  +3.07377200E-02
   +4.71390200E-02  -9.93815900E-02  -1.61033160E-01  -5.37154200E-02  +1.65931210E-01
   +4.09985250E-01  +1.56230000E-04  -2.51250000E-04  +2.55700000E-05  +8.33230000E-04
   +4.84590000E-04  -1.32470000E-04  +2.45640000E-04  +1.35000000E-06  -1.47920000E-04
   -1.45600000E-04  -1.22200000E-05  +1.20040000E-04  +2.67480000E-04  +1.80600000E-05
   -9.98300000E-05  +9.65100000E-05  +5.81000000E-06  -5.46100000E-05  +3.68979000E-03
   -3.94098000E-03  +1.43940000E-04  -8.25850000E-04  -6.67670000E-04  -2.54570000E-04
   -2.00140000E-04  +4.84900000E-05  +1.53500000E-05  -7.80500000E-05  -1.13100000E-05
   +4.21500000E-05  +4.63526000E-03  +2.66119900E-02  +3.59225500E-02  +2.63701100E-02
   -2.51487200E-02  -1.10114940E-01  -1.61702760E-01  +2.30838440E-01  +5.31350510E-01
   +2.84950000E-04  -2.99860000E-04  +6.80000000E-07  -2.58580000E-04  +4.81600000E-04
   +2.84080000E-04  -1.79140000E-04  +9.91800000E-05  +6.92800000E-05  +6.23560000E-04
   -2.84900000E-05  -4.47510000E-04  -1.08104000E-03  +1.31660000E-04  +1.20480000E-04
   -4.49640000E-04  -1.11650000E-04  +8.48700000E-05  -2.36675000E-03  -3.13450000E-04
   -2.07000000E-05  +4.11150000E-04  -2.07250000E-04  -3.03700000E-04  +9.32700000E-04
   -3.08240000E-04  +8.39700000E-05  +5.12960000E-04  +7.11800000E-05  -1.60720000E-04
   -8.85529000E-03  +1.88186700E-02  +2.65206100E-02  +2.56531000E-02  -1.38588300E-02
   -3.34917100E-02  -1.19926790E-01  -4.00164000E-02  -1.51410600E-02  +6.16555240E-01
   +1.62970000E-04  -3.53700000E-05  +1.61460000E-04  -1.28800000E-05  +9.91330000E-04
   +6.54300000E-05  -2.10830000E-04  +1.24910000E-04  -1.08510000E-04  +3.16670000E-04
   -4.31300000E-05  -1.31720000E-04  -7.11010000E-04  +1.69850000E-04  -3.53600000E-05
   -4.32640000E-04  -2.28570000E-04  -5.49600000E-05  +2.48090000E-04  -7.96830000E-04
   -8.07360000E-04  +1.65390000E-04  +1.39870000E-04  -5.88600000E-05  +6.00480000E-04
   -2.34230000E-04  +1.07550000E-04  +3.47170000E-04  +4.64200000E-05  -7.91200000E-05
   +1.81629900E-02  -1.99439600E-02  -2.99180100E-02  -4.83008500E-02  -2.76871200E-02
   -3.07730000E-03  +6.29410000E-03  -1.79127530E-01  -1.38280990E-01  +1.59962550E-01
   +4.45082230E-01  -1.05900000E-04  +1.90560000E-04  +2.30010000E-04  +2.51390000E-04
   +6.58460000E-04  -1.70170000E-04  -1.71460000E-04  +1.09750000E-04  -4.63000000E-05
   +3.22000000E-05  +2.49400000E-05  +3.85200000E-05  -2.54730000E-04  +6.49000000E-05
   -5.76900000E-05  -2.31630000E-04  -1.79300000E-04  -9.34800000E-05  +1.22890000E-03
   -2.62760000E-04  -1.51139000E-03  +6.49200000E-05  -3.20100000E-05  +3.03180000E-04
   +1.72560000E-04  -6.63800000E-05  +4.40500000E-05  +1.09570000E-04  +3.22300000E-05
   -1.36100000E-05  +2.51246400E-02  -3.05769000E-02  -6.15452500E-02  -7.69313200E-02
   -2.70750800E-02  +2.17656400E-02  +4.23969000E-02  -1.05396590E-01  -2.32198220E-01
   -1.21741120E-01  +2.35842520E-01  +5.42069480E-01  -2.20180000E-04  +2.82020000E-04
   +3.38000000E-05  +1.46270000E-04  +1.21670000E-04  -3.10750000E-04  +3.09400000E-05
   -9.45400000E-05  +9.97100000E-05  -2.42180000E-04  +1.51950000E-04  +2.16300000E-04
   +2.18170000E-04  -3.14300000E-05  -3.06000000E-05  +7.78200000E-05  -1.29780000E-04
   -1.08740000E-04  +4.14085000E-03  -9.26900000E-05  +1.37797000E-03  +2.44280000E-04
   +2.71600000E-04  +5.14310000E-04  -2.55010000E-04  +9.04700000E-05  -2.43300000E-05
   -1.56310000E-04  +1.64300000E-05  +5.97800000E-05  +2.14419800E-02  -4.59866200E-02
   -6.79057200E-02  -6.30670600E-02  -1.47890200E-02  +2.27646800E-02  +3.94062000E-02
   +5.07129800E-02  +4.10729400E-02  -2.15423590E-01  -2.27328700E-02  +7.54188500E-02
   +6.03068080E-01  -1.63490000E-04  +3.77070000E-04  +4.86710000E-04  +6.49580000E-04
   -9.06200000E-05  +3.24600000E-05  -5.12600000E-05  +4.70900000E-05  -6.59400000E-05
   -1.96800000E-05  +1.46590000E-04  +5.41000000E-05  -2.15880000E-04  +3.09100000E-05
   -1.80700000E-05  -2.14520000E-04  -7.31100000E-05  +1.70100000E-05  +3.04390000E-04
   +1.65853000E-03  -5.35834000E-03  -1.11597000E-03  -4.24730000E-04  +1.69200000E-04
   +1.31150000E-04  -3.05800000E-05  +2.08400000E-05  +9.69600000E-05  +5.32500000E-05
   -2.42400000E-05  -1.45663200E-02  -2.34222300E-02  -2.88099100E-02  -1.74835100E-02
   -7.57582000E-03  +6.89009000E-03  +2.28434900E-02  +1.45111600E-02  -8.37530000E-03
   +2.67446800E-02  -1.07229090E-01  -6.56440900E-02  +1.75378980E-01  +4.36223540E-01
   +7.31100000E-05  -8.05700000E-05  +1.93490000E-04  +7.44970000E-04  +1.14840000E-04
   +1.70060000E-04  +2.82000000E-06  +2.60260000E-04  -1.27080000E-04  +2.24980000E-04
   -1.36840000E-04  -1.35680000E-04  -2.88520000E-04  +3.31900000E-05  -2.87200000E-05
   -1.74540000E-04  +3.97000000E-05  +6.91300000E-05  +1.46600000E-03  -4.31429000E-03
   -2.09604000E-03  -9.70600000E-04  -6.71230000E-04  +5.33100000E-05  +2.56720000E-04
   -1.02690000E-04  +5.67700000E-05  +1.66240000E-04  +1.02500000E-05  -3.79700000E-05
   -2.71729500E-02  -6.91573000E-03  +1.97280600E-02  +2.00048000E-02  +5.28976000E-03
   -1.08761200E-02  +6.41330000E-03  -2.80187900E-02  -3.10209500E-02  +1.36134000E-01
   -3.08260000E-02  -2.03434410E-01  -1.18408320E-01  +2.59170020E-01  +5.28889830E-01
   +1.18920000E-04  -5.04020000E-04  -7.77060000E-04  -8.83110000E-04  -2.70959000E-03
   -1.39633000E-03  -4.50020000E-04  +2.28460000E-04  -4.87500000E-04  +1.44180000E-04
   -1.73030000E-04  -9.26300000E-05  +8.16800000E-05  +1.15200000E-05  +1.25400000E-05
   +1.85120000E-04  +5.86700000E-05  +1.45390000E-04  -3.85448000E-03  -1.91829000E-02
   -2.18810100E-02  -5.17352000E-03  -2.98830000E-03  +8.73220000E-04  -1.20700000E-05
   -6.38000000E-06  +8.86000000E-06  +1.62300000E-05  +2.98700000E-05  +1.37600000E-05
   -1.20712680E-01  -8.08935000E-03  +2.66604400E-02  +3.94285200E-02  +2.37748200E-02
   +8.37202000E-03  -2.17514400E-02  -2.51599300E-02  -1.80639900E-02  -5.10601700E-02
   +6.62555000E-03  +4.55522800E-02  -2.74318280E-01  -1.44464940E-01  -2.77142400E-02
   +6.44286680E-01  +1.69230000E-04  +1.50110000E-04  -3.18090000E-04  +3.55810000E-04
   -7.06440000E-04  -4.48250000E-04  -2.88600000E-05  -2.72260000E-04  +1.04877000E-03
   +3.89210000E-04  +2.04160000E-04  -4.84440000E-04  -3.16140000E-04  -2.52420000E-04
   +2.41170000E-04  -4.25000000E-05  -1.95830000E-04  -2.01830000E-04  -8.31969000E-03
   -1.29342900E-02  -1.22614000E-02  -2.25761000E-03  -4.10290000E-04  +5.91070000E-04
   +1.82640000E-04  +5.30500000E-05  -9.94500000E-05  -1.24700000E-05  +1.05440000E-04
   -5.63900000E-05  -4.76574000E-02  -1.81095040E-01  -1.02390040E-01  +5.49813600E-02
   +1.27264500E-02  -3.26388000E-02  -2.69429500E-02  -3.78966900E-02  -2.45606100E-02
   -2.81727300E-02  +3.21542900E-02  +5.64329000E-02  -1.03807290E-01  -1.63293280E-01
   -5.53251600E-02  +1.57876380E-01  +4.11269320E-01  +3.40920000E-04  -1.59310000E-04
   -9.62840000E-04  -6.25840000E-04  -8.71840000E-04  +4.41080000E-04  -3.66220000E-04
   -3.54120000E-04  +3.14730000E-04  +2.26560000E-04  -1.21300000E-05  -2.04150000E-04
   +5.95500000E-05  -1.50830000E-04  +2.65150000E-04  +1.90470000E-04  -1.34410000E-04
   -2.48300000E-04  -6.88215000E-03  -2.87451000E-03  +2.50366000E-03  +1.06633000E-03
   +2.75140000E-04  +5.89400000E-05  -3.37200000E-05  +6.19400000E-05  -1.19240000E-04
   -2.61750000E-04  -2.62400000E-05  -7.53000000E-06  -2.40313300E-02  -1.30185900E-01
   -2.14101950E-01  +4.75148500E-02  -1.11659600E-02  -3.83609200E-02  -2.07667600E-02
   -2.62367600E-02  -2.10873800E-02  +2.17441000E-03  +3.27464800E-02  +4.12345500E-02
   +2.33940900E-02  -2.67380300E-02  -1.08835910E-01  -1.53481510E-01  +2.18039370E-01
   +5.18410750E-01  -3.02510000E-04  +2.72130000E-04  -2.52500000E-04  +1.43440000E-04
   -1.13000000E-03  -3.13780000E-04  +1.76200000E-04  -2.31520000E-04  +1.13070000E-04
   -6.45740000E-04  +1.14960000E-04  +3.86420000E-04  +1.22203000E-03  -2.10670000E-04
   -1.25700000E-05  +6.51250000E-04  +1.96940000E-04  -3.68400000E-05  +1.57215000E-03
   +6.72390000E-04  +6.77070000E-04  -5.64620000E-04  +2.23200000E-05  +3.48270000E-04
   -1.06161000E-03  +3.79980000E-04  -1.49960000E-04  -6.26210000E-04  -7.10900000E-05
   +1.71370000E-04  -2.67300000E-03  -2.25730000E-03  -3.22858000E-03  +9.23030000E-04
   +6.98860000E-04  +3.67777000E-03  -7.69311000E-03  -1.65614800E-02  -9.75686000E-03
   -2.49113260E-01  -9.55417100E-02  +2.69854400E-02  -4.43718200E-02  -3.09871300E-02
   +9.44000000E-06  +3.23136000E-03  +2.78226000E-03  +6.35962000E-03  +3.39480410E-01
   -2.23540000E-04  +1.54230000E-04  -2.12010000E-04  +8.05900000E-05  -8.87170000E-04
   -2.30650000E-04  +1.24280000E-04  -1.46340000E-04  +9.56000000E-05  -4.20890000E-04
   +1.01940000E-04  +2.54640000E-04  +7.85360000E-04  -1.64450000E-04  +1.67800000E-05
   +4.36240000E-04  +1.25960000E-04  -1.40800000E-05  +1.07044000E-03  +1.13140000E-04
   +1.04839000E-03  -3.69310000E-04  -2.60600000E-05  +2.19260000E-04  -6.98060000E-04
   +2.76430000E-04  -1.14790000E-04  -3.97140000E-04  -1.85900000E-05  +1.00080000E-04
   -3.05816000E-03  +8.62200000E-05  +2.87422000E-03  +4.79116000E-03  +3.44082000E-03
   -5.53348000E-03  -3.94001100E-02  -2.40978100E-02  -1.14727500E-02  -1.25767830E-01
   -1.32781080E-01  -2.10089800E-02  -7.56043000E-03  +4.50046000E-03  -1.19222000E-03
   -2.39019000E-03  +1.62013000E-03  -5.42179000E-03  +1.48217790E-01  +3.52672880E-01
   -3.49400000E-05  +6.29100000E-05  +3.77600000E-05  +4.72000000E-06  -2.32180000E-04
   +4.62000000E-06  +6.79600000E-05  -5.72000000E-06  -4.79400000E-05  -9.29200000E-05
   -2.80000000E-07  +6.29000000E-05  +1.72490000E-04  -1.23200000E-05  -3.95100000E-05
   +7.72000000E-05  +4.98900000E-05  +2.56700000E-05  -1.22510000E-04  +4.34970000E-04
   +2.25410000E-04  -7.43200000E-05  -2.19200000E-05  -9.07000000E-06  -1.39310000E-04
   +3.75400000E-05  +3.66000000E-06  -7.37600000E-05  -1.51700000E-05  +3.54400000E-05
   -2.92419000E-03  +3.21997000E-03  +4.56790000E-03  +8.97567000E-03  -2.60848000E-03
   -4.39172000E-03  -3.81107200E-02  -2.76909000E-02  +2.67020000E-04  -1.06653200E-02
   -4.25819900E-02  -8.92537700E-02  +2.87145700E-02  +1.53050900E-02  +8.46924000E-03
   +2.51900000E-05  -8.93040000E-03  -3.85621000E-03  -3.74731400E-02  +2.99799090E-01
   +4.26661300E-01  -1.39238000E-03  +1.16447000E-03  -6.80140000E-04  -4.29330000E-04
   +1.91301400E-02  -2.14820200E-02  -4.49819000E-03  +2.93057000E-03  +1.48404000E-03
   +2.20360000E-04  +9.49670000E-04  -1.12655000E-03  +5.80550000E-04  +9.68000000E-06
   -3.07100000E-05  +6.74120000E-04  +2.83490000E-04  -5.23690000E-04  -7.56526400E-02
   -2.11329000E-03  +3.00619000E-03  +5.47970000E-04  +7.75740000E-04  -1.39025000E-03
   -5.60380000E-04  +1.41920000E-04  -4.97300000E-05  -2.26940000E-04  -1.96640000E-04
   +1.01420000E-04  -4.91189000E-03  -2.08720000E-02  +2.21858400E-02  -5.27040000E-04
   -1.85619000E-03  -1.00781000E-03  -1.40512000E-03  +2.88430000E-04  -1.25581000E-03
   +6.71070000E-04  +7.44010000E-04  +5.76130000E-04  -2.32910000E-04  +7.22720000E-04
   +1.73900000E-04  -4.47330000E-04  -8.19880000E-04  +9.34910000E-04  -1.29408000E-03
   -9.59640000E-04  -2.40130000E-04  +5.87526930E-01  -3.30350000E-04  -7.16250000E-04
   -2.53700000E-04  +5.26463000E-03  -1.82372000E-02  +1.78043900E-02  +3.23006000E-03
   -5.82490000E-04  -5.17810000E-04  -1.89110000E-04  -4.63610000E-04  +6.47700000E-04
   -1.38720000E-04  -6.29400000E-05  +7.65700000E-05  -4.35010000E-04  -3.27620000E-04
   +6.24200000E-04  +2.56251000E-03  -1.17852390E-01  +5.09336600E-02  +4.09550000E-04
   +1.04613300E-02  -1.06735800E-02  +2.03640000E-04  -4.00300000E-05  +2.96400000E-05
   -1.70510000E-04  +4.39100000E-05  -7.80900000E-05  -9.33955000E-03  -1.86087000E-02
   +1.50000600E-02  +1.54904000E-03  -9.20390000E-04  -7.02600000E-04  -7.07150000E-04
   -1.30370000E-04  -8.81200000E-04  +1.12460000E-04  +4.79390000E-04  +5.57670000E-04
   +8.67100000E-05  +7.16320000E-04  +4.91700000E-05  -3.56500000E-04  -2.86120000E-04
   +1.02005000E-03  -4.27240000E-04  -3.65820000E-04  -1.27840000E-04  -1.16290000E-04
   +5.31446610E-01  +1.00665000E-03  -1.15204000E-03  -7.11700000E-05  -4.07319000E-03
   +2.09633000E-03  +5.56590000E-04  +1.63216000E-03  -1.12503000E-03  +2.56950000E-04
   +5.39400000E-05  -3.15960000E-04  +4.33450000E-04  -1.82680000E-04  +7.56500000E-05
   -1.81170000E-04  +1.92000000E-05  -1.02360000E-04  -1.52000000E-05  -1.65428000E-03
   +4.85019500E-02  -1.33774300E-01  -2.48100000E-04  +1.78257300E-02  -3.67868400E-02
   +1.65600000E-04  -4.26100000E-05  +6.89600000E-05  +1.64370000E-04  -4.40000000E-07
   -3.28100000E-05  +7.14363000E-03  +5.37390000E-03  +1.33870000E-04  -7.69280000E-04
   -3.08350000E-04  -1.44320000E-04  -1.62250000E-04  -2.19940000E-04  -2.50180000E-04
   +2.72160000E-04  +2.28730000E-04  +3.50010000E-04  +1.53610000E-04  +4.21000000E-06
   -1.71440000E-04  -1.66001000E-03  -1.08648000E-03  -2.34480000E-04  -6.12500000E-04
   -4.33870000E-04  -1.60030000E-04  -2.22799000E-03  +6.33751600E-02  +5.23807370E-01
   +1.54000000E-05  -2.10000000E-06  +4.59200000E-05  -2.47000000E-05  +4.01900000E-05
   +7.39000000E-06  -2.87800000E-05  +2.68100000E-05  -9.20000000E-06  +8.73900000E-05
   +1.18800000E-05  -4.75800000E-05  -1.96780000E-04  +2.76400000E-05  +1.15600000E-05
   -9.65000000E-05  -3.01300000E-05  +2.40800000E-05  -1.81270000E-04  +2.88300000E-05
   +1.02230000E-04  +7.55400000E-05  +2.24500000E-05  -2.35700000E-05  +1.60920000E-04
   -4.59700000E-05  +1.65200000E-05  +1.02500000E-04  +2.58900000E-05  -3.03900000E-05
   -8.15500000E-05  +4.00250000E-04  +6.31990000E-04  +1.50141000E-03  -8.64120000E-04
   -8.62060000E-04  -5.48242000E-03  -3.51772000E-03  +1.05753000E-03  -3.33840000E-03
   -2.84280000E-02  -3.50063400E-02  +1.62823000E-03  -4.21300000E-04  -2.29683000E-03
   -6.14510000E-04  -1.74970000E-04  -2.43210000E-04  -3.98487500E-02  +2.27043700E-02
   +5.40188200E-02  +4.45200000E-05  -8.59000000E-06  -1.10000000E-05  +4.74650200E-02
   +3.99800000E-05  -2.75500000E-05  +4.64500000E-05  -1.67300000E-05  +1.36610000E-04
   +4.01000000E-05  -2.46000000E-05  +3.92300000E-05  -4.19200000E-05  +8.52100000E-05
   -3.26400000E-05  -5.35900000E-05  -1.54140000E-04  +4.05700000E-05  -6.54000000E-06
   -7.60300000E-05  -6.53000000E-06  +1.78500000E-05  -1.71510000E-04  -7.68900000E-05
   -6.23000000E-06  +6.68400000E-05  -4.65000000E-06  -2.71000000E-05  +1.38670000E-04
   -6.48400000E-05  +2.64600000E-05  +7.34100000E-05  -6.22000000E-06  -1.53100000E-05
   +5.00100000E-05  +4.30010000E-04  +4.89020000E-04  +2.38420000E-04  +4.61320000E-04
   -1.72308000E-03  -4.37685000E-03  +2.86450000E-04  +7.80510000E-04  -2.47800000E-05
   -2.02766200E-02  -2.17402000E-02  +3.54403000E-03  +2.44094000E-03  +1.65151000E-03
   +3.08300000E-05  -9.44000000E-04  -3.80600000E-04  -8.07297000E-03  -2.02839750E-01
   -2.42164720E-01  +8.39000000E-05  +2.12600000E-05  +3.78700000E-05  +9.33355000E-03
   +2.20377660E-01  +1.03400000E-05  -1.26500000E-05  -8.30000000E-07  -6.45000000E-06
   +6.91300000E-05  +2.26700000E-05  -2.70000000E-05  +4.37000000E-06  +2.93300000E-05
   +5.10200000E-05  +8.04000000E-06  -3.26200000E-05  -9.65900000E-05  -1.40000000E-07
   +2.90300000E-05  -4.54800000E-05  -1.95000000E-05  -5.17000000E-06  -1.36800000E-04
   -3.11700000E-05  -1.58570000E-04  +3.06200000E-05  -2.63000000E-06  -1.90800000E-05
   +7.62200000E-05  -1.40400000E-05  -7.37000000E-06  +4.33200000E-05  +1.19700000E-05
   -2.51900000E-05  +1.96890000E-04  +1.24110000E-04  +2.68140000E-04  +4.67100000E-04
   -9.70220000E-04  +2.14490000E-04  -2.04900000E-05  +1.44910000E-04  +2.35391000E-03
   +4.02650000E-04  -1.47313000E-03  -4.91269000E-03  +2.62820000E-03  +4.45411000E-03
   +2.72107000E-03  -2.10000000E-06  -2.42500000E-04  -9.48790000E-04  +1.56570500E-02
   -2.64085110E-01  -3.43412040E-01  +1.34410000E-04  +6.37800000E-05  +6.68900000E-05
   -1.90650200E-02  +2.62241310E-01  +3.44222570E-01  -3.83200000E-05  +2.69200000E-05
   -1.29700000E-05  +1.44970000E-04  -8.68700000E-05  +1.36000000E-06  +8.29000000E-06
   -1.68500000E-05  +3.25100000E-05  -3.70800000E-05  +5.21100000E-05  +2.09400000E-05
   +3.27500000E-05  -7.85000000E-06  -1.07900000E-05  +2.50000000E-06  -3.87900000E-05
   -1.18800000E-05  +5.44710000E-04  -6.44360000E-04  -9.69590000E-04  -3.87040000E-04
   -1.27950000E-04  +9.71800000E-05  -3.69000000E-05  +2.18900000E-05  -9.60000000E-07
   -5.63000000E-06  +2.96300000E-05  +8.28000000E-06  -2.79761000E-03  -4.61899000E-03
   +1.57761000E-03  -1.58962000E-03  -2.38550000E-04  +1.81230000E-04  -2.46764000E-03
   -9.02990000E-04  +4.50173000E-03  +5.37747000E-03  +1.48179400E-02  +1.73504100E-02
   -5.74109900E-02  -1.93697100E-02  -7.29194000E-03  +2.65357000E-03  -1.73165300E-02
   -2.13818700E-02  +2.03520000E-03  +2.55747000E-03  -9.69030000E-04  +3.03000000E-06
   +7.46500000E-05  -1.03820000E-04  -8.29310000E-04  -9.81050000E-04  -2.55950000E-04
   +5.46128800E-02  -3.06500000E-05  +3.85700000E-05  +3.38000000E-06  +1.84230000E-04
   -1.23120000E-04  -1.33700000E-05  +2.20100000E-05  +2.70000000E-06  -5.39000000E-06
   -5.34200000E-05  -1.70000000E-06  +2.67000000E-05  +1.03220000E-04  -7.31000000E-06
   -2.78700000E-05  +4.97600000E-05  +1.19300000E-05  +3.75000000E-06  +2.06010000E-04
   -3.70000000E-05  -8.46970000E-04  -2.95090000E-04  -1.78670000E-04  +1.04010000E-04
   -8.39300000E-05  +2.11800000E-05  +2.88000000E-06  -4.78300000E-05  -7.97000000E-06
   +2.52700000E-05  -4.91251000E-03  +3.15819000E-03  -1.81128000E-03  +5.28800000E-05
   -2.35160000E-04  +7.58020000E-04  -5.53530000E-04  +3.63920000E-03  -1.88332000E-03
   -4.49401000E-03  -3.80960000E-04  -2.41046000E-03  -1.95028600E-02  -1.63829170E-01
   -1.46481840E-01  +8.13030000E-04  -8.03884000E-03  -1.35505500E-02  +2.17549000E-03
   -1.17980000E-04  +3.06400000E-03  -5.65800000E-05  -3.55000000E-06  -1.67600000E-05
   +7.62420000E-04  +2.31990000E-04  -9.35870000E-04  +2.40671100E-02  +1.68375920E-01
   -1.84500000E-05  +4.79000000E-06  -5.91900000E-05  -3.55600000E-05  -6.52700000E-05
   +8.28000000E-06  +1.45600000E-05  -4.14100000E-05  +5.12900000E-05  -3.47900000E-05
   +5.39800000E-05  +2.20000000E-05  +4.28000000E-05  -2.78800000E-05  +2.27300000E-05
   +2.76200000E-05  -1.62100000E-05  -1.66700000E-05  +3.66190000E-04  -1.52690000E-04
   +1.67000000E-05  -7.88000000E-05  +2.57200000E-05  +3.20700000E-05  -4.89900000E-05
   +3.42700000E-05  -1.98200000E-05  -2.63800000E-05  +1.71100000E-05  -8.20000000E-07
   +9.88100000E-04  -2.27294000E-03  +3.99033000E-03  +4.84270000E-04  +9.48400000E-04
   -4.83800000E-05  +4.95165000E-03  -1.61956000E-03  -6.60000000E-07  -6.24945000E-03
   -1.59910200E-02  -1.11195800E-02  -7.53444000E-03  -1.46459590E-01  -2.08190680E-01
   +9.45320000E-04  -7.28530000E-04  +9.27050000E-04  -1.53708000E-03  +2.75535000E-03
   +6.10740000E-04  -4.55700000E-05  +8.93000000E-06  -6.32400000E-05  +1.89697000E-03
   +2.87330000E-04  -4.06740000E-04  +7.75703000E-03  +1.61502530E-01  +2.16236220E-01
   -4.46950000E-04  -5.02100000E-05  -1.00150000E-04  -6.93270000E-04  -7.26490000E-04
   -7.57640000E-04  -3.82000000E-05  +4.06500000E-05  -1.37060000E-04  +1.55820000E-04
   -8.16400000E-05  +7.41000000E-06  -2.24350000E-04  +5.35600000E-05  +3.41600000E-05
   -1.48470000E-04  -1.01150000E-04  -2.48300000E-05  -9.54060000E-04  +5.05570000E-04
   -8.29770000E-04  -8.04000000E-06  +1.61550000E-04  -9.55300000E-05  +1.83900000E-04
   -7.18300000E-05  +1.61300000E-05  +9.97600000E-05  +4.37800000E-05  -2.72200000E-05
   +5.54261000E-03  -3.15780000E-04  -1.49023000E-03  +2.04692000E-03  -2.09047000E-03
   +3.90100000E-04  -1.94580000E-04  -1.45400000E-04  -9.21780000E-04  -9.73200000E-04
   -5.16220000E-03  -1.58160000E-04  -1.48602800E-02  +4.30145000E-03  +1.85088900E-02
   -2.08205210E-01  +1.97418900E-02  +1.40657520E-01  -1.45282000E-03  -3.75100000E-05
   +8.42400000E-04  -5.85600000E-05  -1.61150000E-04  +9.81000000E-05  +1.22930000E-04
   +1.98760000E-04  +1.55400000E-04  +4.88600000E-05  +1.37642000E-03  -1.40390000E-03
   +2.19655490E-01  -1.63460000E-04  -1.04270000E-04  +1.04800000E-05  -2.49200000E-04
   +1.01060000E-04  -1.51340000E-04  -1.74500000E-05  +2.70900000E-04  -2.88750000E-04
   +1.21870000E-04  -2.56830000E-04  +7.82000000E-06  -5.18800000E-05  +2.80000000E-07
   +5.01000000E-06  +3.90700000E-05  +2.07330000E-04  +1.55170000E-04  +1.44713000E-03
   -1.28613000E-03  +1.27603000E-03  +1.18540000E-04  +5.40000000E-06  +9.11500000E-05
   +7.31900000E-05  -5.22400000E-05  +2.97600000E-05  -7.24000000E-06  -8.69100000E-05
   -6.23000000E-06  +1.63811700E-02  +2.89555000E-03  -1.30161100E-02  -2.55826000E-03
   +4.47750000E-04  -5.66653000E-03  -2.04750000E-04  -1.11924000E-03  +2.55550000E-04
   -4.86834000E-03  +2.20440000E-03  -3.68694000E-03  -1.39228200E-02  +5.78205000E-03
   +1.18861300E-02  +1.99602800E-02  -5.43657100E-02  -3.21238200E-02  -8.53850000E-04
   -3.60600000E-05  +6.63000000E-04  -1.96680000E-04  -5.25740000E-04  -5.13420000E-04
   +7.33300000E-05  +9.21000000E-05  +9.82100000E-05  +1.71946000E-03  -1.81482000E-03
   +2.09215000E-03  -1.75198100E-02  +4.87249300E-02  -2.01670000E-04  +3.48130000E-04
   +6.23710000E-04  -1.61210000E-04  -2.27210000E-04  -2.91760000E-04  -5.00000000E-08
   +2.15580000E-04  -3.86120000E-04  +8.01900000E-05  +1.21600000E-05  +9.79000000E-06
   -3.23420000E-04  +8.10300000E-05  -6.67700000E-05  -3.00470000E-04  +2.80500000E-05
   +1.05940000E-04  +4.11400000E-04  +1.90400000E-03  -1.03282000E-03  -2.42470000E-04
   +6.18800000E-05  -6.65000000E-06  +2.55960000E-04  -9.53300000E-05  +5.79700000E-05
   +2.10460000E-04  +1.94700000E-05  -4.69500000E-05  +1.86604900E-02  -1.65138000E-03
   -1.06666900E-02  +1.69680000E-04  -6.05922000E-03  -9.82350000E-04  -1.09047000E-03
   +1.23800000E-04  -3.31100000E-04  +1.91200000E-04  -3.40774000E-03  +3.74866000E-03
   -3.58309000E-03  -7.76700000E-04  +5.48987000E-03  +1.40329370E-01  -3.15523000E-02
   -1.74487980E-01  -1.67100000E-05  +1.31160000E-04  +1.07190000E-04  -1.52700000E-05
   -1.77600000E-05  -7.59700000E-05  -2.59500000E-05  -4.51000000E-06  -1.84200000E-05
   -1.06540000E-03  +2.34204000E-03  -9.41810000E-04  -1.54224280E-01  +3.81963500E-02
   +1.79712740E-01  +1.42800000E-05  -5.20100000E-05  -5.43800000E-05  -2.07900000E-04
   -5.04200000E-05  -1.81700000E-04  -7.92700000E-05  -7.33400000E-05  +7.29000000E-05
   +7.63700000E-05  -1.13900000E-05  -9.30600000E-05  -1.06730000E-04  +1.61300000E-05
   +7.27200000E-05  +1.13100000E-05  +4.87900000E-05  +4.65700000E-05  +3.72120000E-04
   +1.46524000E-03  -1.04250000E-03  -4.08920000E-04  +5.44600000E-05  +6.21810000E-04
   +9.87000000E-05  -3.45400000E-05  -1.42900000E-05  +4.34200000E-05  -1.70400000E-05
   -2.70000000E-05  +7.34353000E-03  +1.51579400E-02  +1.67406100E-02  -5.62259600E-02
   -1.54110700E-02  -7.49422000E-03  +1.95402000E-03  -1.78681400E-02  -2.06509000E-02
   -2.42382000E-03  -4.62194000E-03  +1.69278000E-03  -1.34410000E-03  -8.27000000E-05
   +5.73700000E-05  -2.55869000E-03  -1.19658000E-03  +4.99440000E-03  +3.56900000E-05
   -8.75340000E-04  -1.10732000E-03  +2.80630000E-04  -4.98600000E-05  -9.58300000E-05
   -3.42910000E-04  -1.76390000E-04  -1.20400000E-04  -5.76200000E-05  +2.26860000E-04
   -1.96240000E-04  +2.33970000E-04  +8.75580000E-04  +1.01008000E-03  +5.50732100E-02
   +1.09720000E-04  -1.37950000E-04  +9.73200000E-05  +3.17950000E-04  +4.50810000E-04
   -2.15100000E-04  +1.52540000E-04  +9.42700000E-05  -1.62440000E-04  -8.20500000E-05
   -4.03200000E-05  +1.09800000E-04  +4.13000000E-05  +5.57200000E-05  -1.15680000E-04
   -3.89800000E-05  -1.49400000E-05  -2.78200000E-05  +7.79570000E-04  -2.44661000E-03
   +1.22876000E-03  -1.27436000E-03  +1.90460000E-04  +1.22370000E-04  -2.08700000E-05
   -2.16900000E-05  +5.22300000E-05  +3.24200000E-05  -1.67300000E-05  +1.87400000E-05
   -4.07590000E-04  +1.97394000E-03  -2.58574000E-03  -1.53322600E-02  -1.66014930E-01
   -1.47352980E-01  -2.02500000E-05  -7.11731000E-03  -1.38156700E-02  -4.66018000E-03
   +3.62065000E-03  -2.27464000E-03  +9.99000000E-06  -3.59610000E-04  +9.34410000E-04
   -1.10174000E-03  +4.04611000E-03  -2.44700000E-03  -1.30450000E-04  -6.60740000E-04
   -7.77100000E-04  -4.90130000E-04  -2.08360000E-04  +3.65400000E-05  -1.11030000E-04
   -2.06650000E-04  +6.64200000E-05  +1.99310000E-04  -4.11610000E-04  +2.57340000E-04
   -1.22870000E-04  -2.15000000E-05  -1.39700000E-05  +2.20032200E-02  +1.70555730E-01
   -3.85400000E-05  +8.55700000E-05  -1.28600000E-05  -2.41050000E-04  -1.43640000E-04
   +1.52840000E-04  -1.99900000E-05  -1.21700000E-05  +4.03200000E-05  +2.11400000E-05
   +2.05400000E-05  -1.32700000E-05  -2.77900000E-05  -2.65600000E-05  +1.85300000E-05
   -9.18000000E-06  -1.65100000E-05  -1.82000000E-06  -2.07148000E-03  +6.39050000E-04
   -1.55302000E-03  -8.79770000E-04  -8.51900000E-04  +3.78510000E-04  +8.66000000E-06
   +1.33300000E-05  -9.39000000E-06  +6.00000000E-07  +2.25200000E-05  -1.76000000E-06
   -2.76523000E-03  -1.37532100E-02  -1.09022600E-02  -7.26363000E-03  -1.47457730E-01
   -2.18141950E-01  +1.51427000E-03  -1.26120000E-03  +1.44591000E-03  +1.63418000E-03
   -2.32668000E-03  +4.02870000E-03  +1.36640000E-04  +9.84700000E-04  +1.33500000E-05
   +5.07236000E-03  -2.22572000E-03  +2.66690000E-04  -1.73740000E-04  -2.42900000E-04
   -1.56080000E-04  +5.92490000E-04  +1.34730000E-04  +3.79300000E-05  -4.14300000E-05
   +1.12930000E-04  -3.36300000E-05  -2.30140000E-04  +2.32600000E-04  -2.78120000E-04
   -1.93320000E-04  -7.17650000E-04  -6.82070000E-04  +7.48137000E-03  +1.63775950E-01
   +2.25869440E-01  -6.35900000E-05  +8.88600000E-05  -3.28400000E-05  -1.47300000E-05
   -2.49480000E-04  +2.05300000E-05  -3.77600000E-05  -2.62200000E-05  +5.24200000E-05
   -2.72400000E-05  +3.13700000E-05  -2.28000000E-06  +5.76800000E-05  -2.30200000E-05
   +3.33700000E-05  +3.74600000E-05  +8.25000000E-06  +3.60000000E-06  -1.75190000E-04
   +4.61590000E-04  +8.69290000E-04  -1.29300000E-05  +9.49300000E-05  +6.24700000E-05
   -5.67800000E-05  +2.85400000E-05  -2.67800000E-05  -4.19800000E-05  +4.24000000E-06
   +2.48000000E-06  -1.46073000E-03  -5.08481000E-03  -1.19190000E-04  -1.38924900E-02
   +4.68859000E-03  +1.74635100E-02  -2.13185810E-01  +1.59715400E-02  +1.46063970E-01
   +4.58572000E-03  -2.31975000E-03  -2.33126000E-03  +1.72112000E-03  -1.99952000E-03
   +3.39480000E-04  -1.13490000E-04  -1.60010000E-04  -8.84530000E-04  +1.75110000E-04
   +1.47683000E-03  -8.09580000E-04  -2.15030000E-04  -6.44700000E-05  -1.01060000E-04
   -7.28600000E-05  +2.05160000E-04  -9.20800000E-05  +2.43860000E-04  -7.90000000E-06
   -2.62900000E-04  -1.48860000E-04  +2.44470000E-04  -9.47500000E-05  -1.88500000E-05
   +1.42352000E-03  -1.40819000E-03  +2.22716430E-01  -3.74400000E-05  +2.70400000E-05
   -5.02000000E-06  -2.04530000E-04  -2.62670000E-04  -8.82000000E-06  +2.22100000E-05
   -6.25000000E-06  -1.73300000E-05  -1.00600000E-05  +2.21000000E-06  +1.37000000E-06
   +3.03800000E-05  -1.61500000E-05  +1.04100000E-05  +4.10500000E-05  +4.48600000E-05
   +3.75500000E-05  -5.26260000E-04  +4.62600000E-04  +3.33250000E-04  +9.24800000E-05
   +1.87000000E-05  +8.02900000E-05  -2.83300000E-05  +7.37000000E-06  -4.42000000E-06
   -1.92200000E-05  -9.60000000E-06  +6.04000000E-06  -4.72735000E-03  +1.95155000E-03
   -3.12655000E-03  -1.29262900E-02  +5.33508000E-03  +1.27015100E-02  +1.50169200E-02
   -5.08239200E-02  -2.97616900E-02  +1.64128700E-02  +3.49682000E-03  -1.39813300E-02
   -2.33045000E-03  +1.86140000E-04  -5.15375000E-03  -3.79660000E-04  -1.25283000E-03
   +1.16100000E-05  +1.30747000E-03  -7.28240000E-04  +2.59152000E-03  -4.67100000E-05
   +5.66900000E-05  -4.63200000E-05  +1.42280000E-04  -9.58500000E-05  +4.74130000E-04
   +8.57060000E-04  -1.42150000E-04  -6.38120000E-04  +2.14750000E-04  -3.11230000E-04
   +3.33440000E-04  +1.76593000E-03  -1.82616000E-03  +2.09448000E-03  -1.46353900E-02
   +4.38600200E-02  +5.38000000E-06  +9.70000000E-06  +1.15800000E-05  +8.56600000E-05
   +4.61900000E-05  +1.07800000E-05  -2.08700000E-05  +2.28000000E-06  +1.45300000E-05
   +1.44900000E-05  +7.87000000E-06  -1.51700000E-05  -3.59200000E-05  +9.53000000E-06
   +4.30000000E-06  -3.05600000E-05  -2.28000000E-05  -1.04400000E-05  -1.09140000E-04
   -1.06970000E-04  +3.17010000E-04  +4.48000000E-06  +6.14400000E-05  -3.79200000E-05
   +3.08800000E-05  -8.23000000E-06  +1.30000000E-07  +2.01100000E-05  +9.66000000E-06
   -6.99000000E-06  +5.50200000E-05  -2.95249000E-03  +3.53172000E-03  -4.35363000E-03
   +2.22040000E-04  +5.86608000E-03  +1.44883960E-01  -3.04904800E-02  -1.76358860E-01
   +2.10068900E-02  -6.03110000E-04  -1.03152800E-02  -7.77500000E-05  -5.42036000E-03
   -9.96000000E-04  -1.22917000E-03  -1.96880000E-04  -4.55220000E-04  -1.02667000E-03
   +2.45148000E-03  +2.25640000E-04  -3.01500000E-05  -6.37600000E-05  -1.61500000E-05
   -1.71850000E-04  +4.26800000E-04  +9.65500000E-05  +8.24960000E-04  -3.10100000E-05
   -7.29190000E-04  -1.07710000E-04  +3.16200000E-04  -2.39790000E-04  -9.95110000E-04
   +2.33731000E-03  -8.92950000E-04  -1.58757750E-01  +3.40876400E-02  +1.80010540E-01
   -1.50510000E-04  +1.10600000E-05  +3.58350000E-04  +5.75200000E-04  -2.68510000E-04
   +2.62790000E-04  +1.79260000E-04  -2.14290000E-04  +4.22330000E-04  -7.13600000E-05
   +7.41200000E-05  -6.18300000E-05  +1.46820000E-04  -1.90900000E-05  +1.40820000E-04
   +2.19260000E-04  +2.62300000E-05  -3.08300000E-04  -5.22400000E-04  -1.24540000E-03
   +5.67260000E-04  -5.16600000E-05  -2.14000000E-04  +3.15280000E-04  -1.97720000E-04
   +8.59100000E-05  -1.06110000E-04  -1.05350000E-04  +1.61500000E-05  +3.32000000E-05
   +8.72570000E-04  -1.11391000E-03  -1.57560000E-04  +1.74600000E-04  +1.75480000E-04
   +1.27740000E-04  +8.18400000E-05  +8.31000000E-05  -2.90900000E-05  -1.10800000E-05
   -6.53600000E-05  -1.28190000E-04  -1.65020000E-04  +7.73000000E-06  -3.41200000E-05
   +2.67890000E-04  +1.80130000E-04  +1.54710000E-04  +7.28900000E-05  +3.10400000E-05
   +2.83500000E-05  -2.27504350E-01  +1.27833070E-01  +1.47441300E-02  -1.05100000E-05
   -2.27000000E-06  -6.31000000E-06  -1.34000000E-06  +1.18200000E-05  +1.21000000E-06
   +2.87500000E-05  -5.52000000E-05  +1.78300000E-05  +3.00700000E-05  +1.86800000E-05
   -8.00000000E-08  +2.19300000E-05  +1.26100000E-05  +4.57000000E-06  +2.43546290E-01
   -4.80790000E-04  +1.12890000E-04  +4.91020000E-04  -1.19475000E-03  -1.88278000E-03
   +3.66461000E-03  +1.36965000E-03  -3.22740000E-04  -2.71190000E-04  -3.67200000E-05
   -3.42750000E-04  +3.03510000E-04  -2.38030000E-04  +7.55400000E-05  +3.25900000E-05
   -6.92000000E-05  +1.07970000E-04  -1.02100000E-05  +1.74090200E-02  -1.45666300E-02
   -1.45052000E-03  -2.18130000E-04  +4.11540000E-04  -1.29810000E-03  +2.00980000E-04
   -7.12200000E-05  +1.34900000E-05  +1.59950000E-04  +7.40000000E-06  -3.02800000E-05
   +1.16684000E-03  +7.89200000E-04  -2.70650000E-04  -2.89730000E-04  +1.35500000E-04
   -3.60000000E-06  -1.89450000E-04  -6.65100000E-05  +6.26100000E-05  -2.36510000E-04
   -8.97300000E-05  +1.37780000E-04  +1.56950000E-04  +3.55400000E-05  -3.87500000E-05
   -2.01650000E-04  -3.02100000E-04  -5.91800000E-04  +1.92050000E-04  +1.63730000E-04
   +1.86300000E-05  +1.25899960E-01  -1.35474660E-01  -1.11981400E-02  -7.69000000E-06
   -3.56000000E-05  -1.12500000E-05  +1.14000000E-05  -7.82000000E-06  +1.18400000E-05
   +2.76500000E-05  +1.21590000E-04  +1.47360000E-04  +2.14600000E-05  -2.07800000E-05
   +7.16300000E-05  +1.26000000E-06  -1.27300000E-05  -5.50000000E-07  -1.38755300E-01
   +1.47136800E-01  +7.14380000E-04  +6.16800000E-05  -3.85070000E-04  +1.26634000E-03
   +2.61525000E-03  -3.95248000E-03  -1.24885000E-03  +1.02976000E-03  +4.10980000E-04
   +6.90000000E-05  +2.07510000E-04  -3.20700000E-04  +1.84630000E-04  -1.51500000E-05
   -1.14540000E-04  -3.04400000E-05  +9.66000000E-06  +3.34780000E-04  -2.07105300E-02
   +1.49433000E-02  -1.82860000E-04  -1.16622000E-03  +8.43790000E-04  +1.21896000E-03
   -5.64700000E-05  -2.34300000E-05  +7.33800000E-05  -3.70800000E-05  -1.20700000E-05
   +1.12500000E-05  -7.48910000E-04  -4.49180000E-04  +5.40220000E-04  -1.23870000E-04
   -1.32500000E-04  +1.78120000E-04  +1.51830000E-04  +1.07810000E-04  -6.67000000E-06
   +1.60300000E-04  -2.99600000E-05  -2.04890000E-04  -3.93060000E-04  +6.74000000E-06
   +8.88700000E-05  +4.06820000E-04  +7.61000000E-06  -1.18940000E-04  -1.55810000E-04
   -9.99900000E-05  -5.08000000E-06  +1.62656900E-02  -1.24352100E-02  -4.78045000E-02
   +1.47100000E-05  +7.98000000E-06  +1.66000000E-05  +1.18200000E-05  -1.66200000E-05
   +5.30000000E-07  +2.97200000E-05  +1.05000000E-05  +8.52300000E-05  +3.28500000E-05
   +2.23000000E-06  -8.66400000E-05  -3.90000000E-07  +6.07000000E-06  +1.06000000E-05
   -1.72028000E-02  +8.83312000E-03  +5.24258000E-02  -4.63130000E-04  +7.98200000E-04
   +4.64440000E-04  +4.19700000E-05  +1.56740000E-04  +9.30100000E-05  +9.17000000E-05
   -1.67170000E-04  +6.29000000E-06  +2.70600000E-05  -1.47400000E-05  +2.53100000E-05
   -1.07840000E-04  +2.02500000E-05  +6.45300000E-05  +5.96200000E-05  +5.89300000E-05
   -2.16800000E-04  -1.52080000E-04  +7.83090000E-04  -1.01860000E-04  +2.44860000E-04
   +3.38160000E-04  -3.74670000E-04  +3.98700000E-05  -4.21000000E-06  -3.47700000E-05
   +6.81100000E-05  +8.68000000E-06  -1.10000000E-05  +5.79540000E-04  -6.53590000E-04
   +5.21160000E-04  +4.89390000E-04  -1.94710000E-04  -1.71410000E-04  -2.70500000E-05
   -3.77900000E-05  -6.26400000E-05  +3.16840000E-04  +1.53280000E-04  -4.94500000E-05
   -2.39970000E-04  -9.49000000E-06  +6.68000000E-05  +2.72790000E-04  +2.93840000E-04
   +4.59130000E-04  -3.12100000E-04  -2.13650000E-04  -3.13600000E-05  -2.21726440E-01
   -1.26285980E-01  -9.13796000E-03  +2.66200000E-05  +4.02100000E-05  +2.21000000E-05
   -2.99400000E-05  -1.17200000E-05  -2.12500000E-05  -5.79000000E-06  -1.25000000E-05
   -2.37500000E-05  -4.78200000E-05  +5.15600000E-05  +1.73300000E-05  -2.33600000E-05
   -3.94000000E-06  -4.00000000E-07  -1.93968000E-02  -1.60518600E-02  -1.67884000E-03
   +2.40133430E-01  +4.22300000E-05  -3.31330000E-04  +5.85070000E-04  -6.91390000E-04
   +7.28770000E-04  -3.95320000E-04  +1.38550000E-04  -1.85770000E-04  +3.61170000E-04
   -1.16300000E-04  +1.43970000E-04  -5.57000000E-05  +8.36300000E-05  -1.20900000E-05
   +1.72330000E-04  +1.52510000E-04  +6.14000000E-05  -5.25810000E-04  -1.73392300E-02
   -1.24741400E-02  -1.94832000E-03  -1.70900000E-05  +4.90190000E-04  -1.39521000E-03
   -1.91150000E-04  +1.14260000E-04  -1.43810000E-04  -4.38000000E-05  +6.00600000E-05
   +3.46900000E-05  +2.47370000E-04  -1.81013000E-03  +3.81371000E-03  +3.42780000E-04
   -4.97810000E-04  -3.23720000E-04  -6.18860000E-04  -2.55660000E-04  -3.84460000E-04
   +1.99240000E-04  +4.31350000E-04  +4.72810000E-04  +2.03430000E-04  +1.46710000E-04
   +2.66700000E-05  -3.42240000E-04  -1.21290000E-04  +2.44910000E-04  -4.90840000E-04
   -3.50700000E-04  -1.17030000E-04  -1.25068500E-01  -1.38293750E-01  -6.41669000E-03
   +2.84800000E-05  +3.90100000E-05  +4.51200000E-05  -2.32100000E-05  -4.53000000E-05
   -2.43800000E-05  -2.06600000E-05  +1.72600000E-04  -9.49200000E-05  +3.82600000E-05
   -6.23700000E-05  +1.43370000E-04  -9.27900000E-05  +5.06000000E-06  -4.03400000E-05
   +1.54227400E-02  +1.22991400E-02  +1.01857000E-03  +1.37958380E-01  +1.48961340E-01
   -5.10360000E-04  -1.97980000E-04  +5.94900000E-04  +2.45070000E-04  -6.12330000E-04
   +4.69440000E-04  +3.93800000E-05  -1.09850000E-04  -2.33820000E-04  +3.55700000E-05
   -5.14500000E-05  +5.85000000E-06  -8.84300000E-05  +3.12000000E-06  +1.27730000E-04
   +1.32000000E-06  +5.54700000E-05  -1.11440000E-04  +2.08150500E-02  +1.41163400E-02
   -2.13350000E-04  +1.15843000E-03  +6.95330000E-04  +1.17959000E-03  +2.34600000E-05
   +2.24000000E-06  -6.51200000E-05  +3.34000000E-06  +1.20500000E-05  -4.24600000E-05
   -1.01171000E-03  +2.46699000E-03  -3.32903000E-03  +5.99870000E-04  +5.28660000E-04
   +1.54900000E-04  +9.61500000E-05  -2.73530000E-04  +2.05370000E-04  -3.95170000E-04
   -2.66500000E-05  +2.00230000E-04  +6.45800000E-04  -6.95400000E-05  +6.78500000E-05
   -1.65000000E-05  -3.51320000E-04  -6.73900000E-05  +4.03500000E-04  +3.16560000E-04
   +3.17600000E-05  -9.59575000E-03  -7.59595000E-03  -4.90202300E-02  -3.49000000E-06
   -2.34700000E-05  -4.51700000E-05  +3.52800000E-05  +2.12500000E-05  +1.89800000E-05
   -2.33660000E-04  +4.03970000E-04  -2.86900000E-05  -1.92000000E-05  +1.22530000E-04
   -1.28710000E-04  +5.73900000E-05  +3.08600000E-05  -7.70000000E-06  +2.14725000E-03
   +1.63001000E-03  -8.88720000E-04  +9.59938000E-03  +4.99896000E-03  +5.13300800E-02
   -3.95400000E-05  +3.10150000E-04  -6.47220000E-04  +2.89220000E-04  -3.77870000E-04
   -5.03710000E-04  -1.23900000E-05  +8.39300000E-05  -1.00670000E-04  +4.55100000E-05
   -9.05900000E-05  +4.20000000E-05  -4.59500000E-05  +2.73700000E-05  -1.59260000E-04
   -9.71500000E-05  +3.60000000E-06  +3.44870000E-04  -1.99312000E-03  -6.43200000E-05
   +2.02530000E-04  -1.06050000E-04  +1.09620000E-04  -8.45800000E-05  +1.29890000E-04
   -7.68900000E-05  +1.15510000E-04  +9.86600000E-05  -1.26800000E-05  +7.10000000E-06
   +1.03980000E-04  +6.73850000E-04  +5.89430000E-04  -2.16970000E-04  -6.84300000E-05
   +7.08300000E-05  +1.41880000E-04  +8.03100000E-05  +7.65200000E-05  -1.90100000E-05
   -1.23710000E-04  -1.13690000E-04  -2.59450000E-04  -4.44600000E-05  -6.05800000E-05
   -1.14600000E-04  -1.88570000E-04  +3.66300000E-05  +6.96300000E-05  +5.28400000E-05
   +2.34000000E-06  -4.70775400E-02  -3.32033000E-03  -5.12121000E-03  -1.28300000E-05
   -2.31400000E-05  +4.65000000E-06  +1.75400000E-05  -1.65300000E-05  +1.83800000E-05
   +1.98160000E-04  -3.13710000E-04  +9.19200000E-05  +3.35300000E-05  +1.34700000E-05
   -6.03600000E-05  +4.20000000E-07  +6.15000000E-06  -6.47000000E-06  +1.22028000E-03
   +1.20070200E-02  +2.40377800E-02  +2.91120000E-04  -1.15919700E-02  -2.36756900E-02
   +4.77606700E-02  +8.02590000E-04  +8.32900000E-05  -2.03710000E-04  -1.71670000E-04
   +9.01080000E-04  -2.24770000E-04  -3.31370000E-04  -2.53600000E-05  -6.90500000E-05
   -3.72900000E-05  +7.62700000E-05  -2.34200000E-05  +1.14360000E-04  -1.03300000E-05
   -6.75100000E-05  +5.55000000E-06  -5.11500000E-05  +7.99800000E-05  +5.94000000E-05
   +1.00862500E-02  +1.90290700E-02  -2.17400000E-05  -2.54709000E-03  +2.92600000E-03
   -4.89200000E-05  -1.74000000E-06  +3.12900000E-05  -5.11300000E-05  -4.90000000E-07
   +3.68900000E-05  +5.25970000E-04  +9.69260000E-04  +7.38600000E-05  -2.07220000E-04
   +1.64500000E-05  -6.31300000E-05  +1.43980000E-04  +1.21690000E-04  +1.34340000E-04
   -8.16000000E-06  -7.87500000E-05  -1.68730000E-04  +2.15000000E-06  -1.60190000E-04
   -1.42390000E-04  -4.51940000E-04  -2.03700000E-04  +6.86940000E-04  +1.58760000E-04
   +8.90400000E-05  +1.97200000E-05  -3.52217000E-03  -1.08315060E-01  -1.13737160E-01
   -1.96600000E-05  -1.13000000E-05  -1.66400000E-05  -1.88000000E-06  +1.22000000E-06
   +2.27900000E-05  -1.15660000E-04  -1.00889000E-03  +1.01320000E-04  +3.41000000E-05
   -1.51700000E-05  +4.32000000E-06  +1.24200000E-05  -6.53000000E-06  +4.20000000E-06
   -1.82806000E-03  -8.72459000E-03  -1.56269500E-02  +1.45226000E-03  -8.64795000E-03
   -1.55741600E-02  +2.95822000E-03  +1.16866540E-01  +1.35650000E-04  +1.36180000E-04
   +1.75950000E-04  +1.01068000E-03  -1.07982000E-03  +6.97390000E-04  +1.15370000E-04
   +4.30520000E-04  -4.33900000E-05  +7.15500000E-05  -1.19480000E-04  +5.19000000E-05
   +2.27000000E-06  -4.08100000E-05  -8.66800000E-05  -1.39510000E-04  +5.19000000E-06
   +3.71140000E-04  -3.20130000E-04  -1.25061800E-02  -2.08836300E-02  +2.56050000E-04
   +4.91639000E-03  -3.42372000E-03  +7.47300000E-05  -4.57400000E-05  +8.45900000E-05
   +1.53100000E-05  +2.60000000E-05  -9.40000000E-07  -1.45589000E-03  -7.82100000E-04
   +6.52010000E-04  +8.41990000E-04  +7.76200000E-05  -2.53120000E-04  -4.57430000E-04
   -3.79850000E-04  -1.60920000E-04  -2.21940000E-04  +3.34460000E-04  +4.85440000E-04
   +6.00720000E-04  +2.72410000E-04  +2.31500000E-04  +6.90000000E-05  -6.88310000E-04
   -8.15300000E-05  -7.06600000E-05  -2.48000000E-05  -2.58300000E-05  -4.56984000E-03
   -1.11338980E-01  -2.55413510E-01  +2.41300000E-05  +1.34400000E-05  +3.40000000E-07
   +3.90700000E-05  -1.02000000E-06  -2.19000000E-06  -2.00050000E-04  +4.81010000E-04
   +2.25600000E-04  -1.44900000E-04  +8.42000000E-06  +8.54400000E-05  -4.27000000E-06
   +1.72700000E-05  -1.95200000E-05  -2.24460000E-04  -2.43930000E-04  -9.76220000E-04
   +1.85630000E-04  +4.84660000E-04  +1.85950000E-04  +5.13133000E-03  +1.21083700E-01
   +2.78799490E-01  -9.65300000E-05  +7.69700000E-05  +2.21000000E-06  +1.23240000E-04
   -4.61250000E-04  +4.80790000E-04  -4.49600000E-05  +2.55190000E-04  +2.61560000E-04
   -1.33380000E-04  +4.16900000E-05  -1.79240000E-04  -1.60110000E-04  +2.53200000E-05
   +1.68700000E-04  -2.93300000E-05  -6.46000000E-05  -2.52500000E-05  -1.97393000E-03
   +1.40460000E-03  -1.75401000E-03  -4.76994700E-02  -6.88907000E-03  +9.70533000E-03
   +8.79000000E-05  -1.72600000E-05  -6.48300000E-05  +4.01700000E-05  +4.31100000E-05
   -3.97500000E-05  +3.30730000E-04  +5.37460000E-04  -3.11630000E-04  -8.93600000E-05
   -3.27480000E-04  -6.13310000E-04  -9.57200000E-05  +1.92800000E-05  +2.23640000E-04
   -8.58300000E-05  -2.25600000E-05  +2.80600000E-05  +1.22240000E-04  +7.94200000E-05
   +3.09300000E-05  -6.84200000E-05  -4.30800000E-05  -2.76000000E-05  +1.09310000E-04
   +1.05530000E-04  +4.39500000E-05  -5.60200000E-05  -2.87790000E-04  -5.03900000E-04
   -9.56000000E-06  -1.08800000E-05  -6.25000000E-06  +1.23900000E-05  +1.02800000E-05
   +1.42100000E-05  -1.02000000E-05  +4.50900000E-05  +4.43000000E-05  -1.15347000E-03
   +3.02540000E-04  -3.95260000E-04  -1.19300000E-05  +4.18000000E-06  -2.27300000E-05
   +2.52270000E-04  -3.11830000E-04  +2.53480000E-04  +2.08920000E-04  +3.13000000E-04
   -2.06300000E-04  +6.70820000E-04  +1.18630000E-04  -1.37330000E-04  +4.80634000E-02
   -1.48000000E-06  -4.20000000E-06  +6.32300000E-05  -1.02890000E-04  +8.16220000E-04
   +4.60810000E-04  +5.63960000E-04  -7.57100000E-04  -7.56520000E-04  -1.05120000E-04
   -7.64500000E-05  +1.01130000E-04  +9.00800000E-05  +7.78500000E-05  +1.48180000E-04
   +2.19000000E-05  -4.84200000E-05  -5.50500000E-05  +9.70800000E-04  +1.13056800E-02
   -1.37683500E-02  -6.46847000E-03  -1.43147740E-01  +1.28067690E-01  -1.00170000E-04
   +3.13000000E-06  -6.24000000E-05  -8.16500000E-05  +2.28000000E-05  -4.53000000E-06
   +8.32300000E-05  +7.20460000E-04  +4.83040000E-04  -6.40780000E-04  +3.49490000E-04
   +2.15320000E-04  -5.00000000E-08  -1.57880000E-04  -1.90890000E-04  -1.16910000E-04
   -1.44400000E-05  +1.79920000E-04  +1.37970000E-04  +5.01100000E-05  -4.79200000E-05
   +2.18970000E-04  -1.00020000E-04  -3.68000000E-05  +7.45600000E-05  +2.26200000E-05
   -3.03900000E-05  -1.21190000E-04  -1.51177000E-03  -2.54900000E-03  -1.06100000E-05
   -1.04000000E-05  -6.32000000E-06  +1.35800000E-05  +1.97200000E-05  -6.88000000E-06
   -7.40000000E-06  +8.95000000E-06  -3.23300000E-05  -1.33250000E-04  -1.57670000E-04
   -2.23620000E-04  -7.20000000E-06  +3.97600000E-05  -1.90600000E-05  -2.52780000E-04
   +4.10300000E-05  -1.85660000E-04  +2.35210000E-04  +1.58400000E-05  -1.67400000E-04
   -5.39500000E-05  +8.14370000E-04  -8.22120000E-04  +7.52485000E-03  +1.54752020E-01
   +4.42700000E-04  -2.14910000E-04  -1.37790000E-04  -1.08272000E-03  +8.76400000E-04
   +4.32990000E-04  +8.54580000E-04  +5.12590000E-04  -5.28350000E-04  -2.70860000E-04
   -3.55660000E-04  +6.32770000E-04  +3.37920000E-04  -3.50400000E-05  -5.69810000E-04
   -7.19000000E-06  +2.24750000E-04  +1.52090000E-04  +1.31358000E-03  +1.73861700E-02
   -2.01476100E-02  +9.43019000E-03  +1.26662910E-01  -2.19531160E-01  -2.72800000E-04
   +1.51300000E-05  +1.92700000E-04  -9.04000000E-06  -1.05390000E-04  +5.11100000E-05
   +9.63390000E-04  +9.77540000E-04  +9.99040000E-04  +2.49080000E-04  -2.60890000E-04
   +3.82200000E-05  -2.92290000E-04  -1.74830000E-04  +1.62650000E-04  -1.02610000E-04
   +1.63630000E-04  +1.70080000E-04  +2.28940000E-04  +1.46320000E-04  +1.46200000E-05
   -5.69300000E-05  -4.89550000E-04  -6.08900000E-05  -8.75000000E-06  -5.18000000E-06
   +1.41300000E-05  -2.01990000E-04  -4.63928000E-03  -4.45486000E-03  -6.87000000E-06
   +8.87000000E-06  -7.97000000E-06  -2.46400000E-05  +2.60200000E-05  -3.09400000E-05
   -2.48200000E-05  +1.05490000E-04  +3.78400000E-05  -5.04940000E-04  +2.24210000E-04
   +8.54200000E-05  -2.43700000E-05  -2.29700000E-05  -9.06000000E-06  -4.06900000E-05
   -9.54800000E-05  +2.60480000E-04  +6.89800000E-05  -1.19020000E-04  +3.34930000E-04
   -2.51900000E-05  +1.15694000E-03  -1.54823000E-03  -1.03502600E-02  -1.38342540E-01
   +2.39716790E-01  +3.86150000E-04  -1.44970000E-04  +7.32500000E-05  +7.86610000E-04
   +1.18078000E-03  +2.84090000E-04  +9.44200000E-05  -2.35060000E-04  +1.16350000E-04
   -3.79200000E-05  -6.85000000E-06  -6.33800000E-05  -8.24000000E-05  +2.60000000E-06
   -1.60100000E-05  -5.56400000E-05  -6.50700000E-05  -1.01440000E-04  -2.12582000E-03
   -6.79200000E-05  +8.40810000E-04  -2.53553460E-01  -1.16167730E-01  -3.82839000E-03
   +5.95000000E-05  +8.50000000E-07  +1.01500000E-05  +5.93100000E-05  +2.09500000E-05
   -1.33000000E-05  +7.13020000E-04  +5.27900000E-05  +2.19400000E-05  -1.92250000E-04
   +7.50400000E-05  +3.89990000E-04  +1.59660000E-04  -1.29180000E-04  -2.33730000E-04
   +1.16840000E-04  +8.21000000E-05  -9.90000000E-06  -8.06200000E-05  -7.15500000E-05
   -1.09930000E-04  +4.29700000E-05  +1.00240000E-04  +2.79090000E-04  -1.76870000E-04
   -1.52830000E-04  -6.00400000E-05  -4.45300000E-05  +1.91620000E-04  +3.99240000E-04
   +1.73500000E-05  +2.02800000E-05  +1.14800000E-05  -3.30400000E-05  -7.87000000E-06
   -2.12100000E-05  +8.07800000E-05  -5.44500000E-05  -6.22700000E-05  +2.74620000E-04
   -4.46700000E-05  -4.66170000E-04  -6.90000000E-06  -5.17000000E-06  +1.63100000E-05
   -1.78600000E-05  -1.26510000E-04  +3.32500000E-05  +3.19600000E-04  +2.75470000E-04
   -4.66310000E-04  +2.93620000E-04  +2.22490000E-04  +4.75000000E-06  -9.96700000E-05
   +8.38510000E-04  -7.39000000E-05  +2.72123510E-01  +5.58830000E-04  +1.96090000E-04
   -4.91800000E-05  -1.41275000E-03  +2.56340000E-04  +4.25550000E-04  -2.88950000E-04
   -4.00310000E-04  +3.51680000E-04  +1.60270000E-04  +7.81500000E-05  -1.62400000E-05
   +5.02500000E-05  -1.09570000E-04  +6.37000000E-05  +6.67600000E-05  -5.61500000E-05
   -1.08170000E-04  -1.49171100E-02  -1.06270200E-02  -6.53760000E-04  -1.14650780E-01
   -1.11436810E-01  -9.01750000E-04  -3.32600000E-05  +7.15800000E-05  -3.38200000E-05
   -6.03200000E-05  +3.87000000E-05  +4.45900000E-05  +9.61590000E-04  -1.05321000E-03
   -3.38789000E-03  +4.52470000E-04  +1.38460000E-04  -4.47470000E-04  -6.99000000E-05
   +1.58770000E-04  +6.93500000E-05  +2.77920000E-04  +5.88300000E-05  -8.74300000E-05
   -7.16800000E-05  -2.92090000E-04  -1.44310000E-04  -1.10707000E-03  -7.25000000E-05
   +1.62510000E-04  -2.28770000E-04  -1.34410000E-04  +2.03000000E-06  +4.25840000E-04
   +2.84270000E-04  +1.11174000E-03  +3.15700000E-05  +2.64500000E-05  +1.77900000E-05
   -7.15000000E-05  -1.07920000E-04  +1.40500000E-05  +9.07000000E-06  +3.66100000E-05
   -7.22600000E-05  +1.10930000E-04  -1.42560000E-04  +3.15100000E-04  -3.89400000E-05
   +2.20000000E-06  -1.17900000E-05  +1.25250000E-04  +4.57500000E-05  -2.50300000E-05
   +9.99600000E-05  +5.70000000E-04  -1.21100000E-05  +2.22930000E-04  -4.98900000E-05
   +5.97700000E-05  -1.65111700E-02  -9.27913000E-03  -1.15124000E-03  +1.26467340E-01
   +1.19636720E-01  +2.13430000E-04  +2.57150000E-04  +1.07330000E-04  -1.10609000E-03
   +4.42830000E-04  +9.45930000E-04  +2.99780000E-04  -7.92200000E-05  -2.44100000E-05
   -2.57300000E-04  +3.18700000E-05  +4.13200000E-05  +1.24970000E-04  -1.75800000E-05
   +4.92800000E-05  +5.11000000E-05  -1.10940000E-04  -1.59450000E-04  -2.45529300E-02
   -1.42783800E-02  -2.28697000E-03  -1.80208000E-03  +1.03070000E-04  -4.66916200E-02
   -1.61500000E-04  +6.30100000E-05  -6.41700000E-05  -8.09900000E-05  +3.38300000E-05
   +2.44000000E-06  +1.23606000E-03  -2.27750000E-03  -4.80158000E-03  +9.47180000E-04
   -2.52570000E-04  -5.19810000E-04  -2.04140000E-04  -1.83400000E-05  +2.29820000E-04
   +1.32470000E-04  +1.30800000E-04  -2.08000000E-06  +1.11100000E-04  -2.48010000E-04
   -2.91690000E-04  -1.61085000E-03  -8.50320000E-04  +2.84670000E-04  -1.47880000E-04
   -5.96500000E-05  +2.27800000E-05  -1.20756000E-03  -8.46040000E-04  +1.23113000E-03
   +2.27200000E-05  +2.07800000E-05  +8.35000000E-06  -1.30960000E-04  -7.60300000E-05
   -3.13700000E-05  +7.34000000E-06  +3.07400000E-05  -8.85000000E-06  -1.03570000E-04
   +4.58710000E-04  +2.86310000E-04  -2.62000000E-05  -3.28000000E-05  +5.71000000E-06
   +6.37500000E-05  +3.66000000E-05  -6.14900000E-05  +3.54080000E-04  +4.14250000E-04
   -7.24300000E-04  +3.01460000E-04  +1.23290000E-04  +2.91120000E-04  +2.34577200E-02
   +1.15838500E-02  +1.14169000E-03  +3.11820000E-03  +4.43009000E-03  +5.20152000E-02
   +6.69240000E-04  +2.30690000E-04  -1.51160000E-04  +2.43770000E-04  +1.39970000E-04
   +4.10030000E-04  -3.91000000E-06  -3.28880000E-04  +2.35800000E-04  -6.85000000E-05
   +5.83600000E-05  -1.33800000E-05  +1.71300000E-04  -7.31100000E-05  +3.08300000E-05
   +1.29710000E-04  -8.73000000E-06  -2.26600000E-05  +1.50593000E-03  -2.18751000E-03
   -4.07820000E-04  -1.94786040E-01  +1.33355430E-01  +1.01823700E-02  -1.44330000E-04
   +7.54600000E-05  -2.98800000E-05  -9.98600000E-05  -1.16000000E-06  +2.96700000E-05
   +4.75400000E-05  -7.69700000E-05  +3.29700000E-04  -9.52530000E-04  -1.03749000E-03
   +3.72430000E-04  +8.48200000E-05  -1.10470000E-04  -2.26220000E-04  -1.97970000E-04
   +1.12500000E-05  +2.33900000E-05  +8.03000000E-05  +3.85200000E-05  -2.14500000E-05
   +9.54500000E-05  +6.19100000E-05  -1.64600000E-05  +1.12670000E-04  +4.63700000E-05
   -1.30600000E-05  +2.51360000E-04  -2.55410000E-04  -2.75100000E-04  -1.79600000E-05
   -1.30900000E-05  -8.41000000E-06  +1.61700000E-05  +2.06200000E-05  +1.95000000E-06
   -7.85000000E-06  -2.80000000E-07  +1.57000000E-06  -9.60900000E-04  -1.67271000E-03
   -1.77390000E-04  +3.21500000E-05  -1.82800000E-05  +2.82200000E-05  +2.94240000E-04
   -1.16400000E-04  +3.01670000E-04  -1.83860000E-04  +1.31550000E-04  +4.82700000E-05
   +1.45600000E-04  -2.50600000E-04  +3.94300000E-05  +1.46647000E-03  -2.77089000E-03
   -1.57870000E-04  -1.90771800E-02  +1.95386200E-02  +9.12780000E-04  +2.11262280E-01
   +2.18700000E-04  -4.62080000E-04  +3.17400000E-04  -7.34650000E-04  -7.66580000E-04
   -3.52721000E-03  -4.09000000E-05  +7.59200000E-05  -1.40830000E-04  +2.20500000E-05
   +2.29900000E-05  -8.80800000E-05  -2.64190000E-04  +1.41540000E-04  -7.81400000E-05
   +6.28300000E-05  +2.24980000E-04  +1.24760000E-04  +1.28457100E-02  -1.19598500E-02
   -1.57100000E-04  +1.32159570E-01  -1.66963450E-01  -9.27139000E-03  +2.77460000E-04
   -9.91000000E-05  +7.51000000E-05  +2.96870000E-04  -7.66600000E-05  +2.09900000E-05
   +6.00720000E-04  +5.34020000E-04  +4.72670000E-04  +1.17910000E-04  -4.42550000E-04
   -8.73900000E-04  -3.23760000E-04  +1.98530000E-04  +3.67120000E-04  -4.79500000E-05
   -1.86400000E-05  +7.57100000E-05  +1.57050000E-04  +1.54810000E-04  +6.54300000E-05
   -2.84260000E-04  -8.23500000E-05  -1.39300000E-04  +9.60600000E-05  +1.22570000E-04
   +7.35200000E-05  -1.22870000E-04  +4.77700000E-04  +1.45053000E-03  -4.21000000E-06
   -1.36500000E-05  -2.60000000E-06  +1.02200000E-05  -5.53000000E-06  +2.10100000E-05
   +3.12000000E-05  +5.93900000E-05  +1.32070000E-04  -1.25330000E-03  -9.62180000E-04
   +6.20280000E-04  -1.56500000E-05  -3.10900000E-05  -1.57700000E-05  -1.92790000E-04
   +6.42800000E-04  -2.34790000E-04  -1.16800000E-04  -2.86900000E-05  -1.07260000E-04
   -2.86660000E-04  +9.33000000E-06  +8.75800000E-05  +1.37788600E-02  -1.23268500E-02
   -1.85303000E-03  -1.22567400E-02  +1.19995500E-02  +9.70380000E-04  -1.44790520E-01
   +1.79522210E-01  +7.90150000E-04  -8.56760000E-04  +2.31220000E-04  -1.40320000E-03
   -1.90230000E-03  -5.07441000E-03  +2.46810000E-04  +4.58290000E-04  -3.15520000E-04
   -2.19900000E-05  -1.69420000E-04  +3.98710000E-04  +8.70700000E-05  +1.09530000E-04
   -5.91410000E-04  +1.23850000E-04  +5.75880000E-04  +3.71420000E-04  +2.15823100E-02
   -1.86081500E-02  -2.67883000E-03  +9.71948000E-03  -7.99130000E-03  -4.75757500E-02
   +3.69400000E-05  -8.98100000E-05  +2.43330000E-04  +3.69430000E-04  -1.83510000E-04
   +6.25400000E-05  +2.25180000E-04  +6.84540000E-04  +7.96930000E-04  -3.38380000E-04
   +3.05150000E-04  +4.04640000E-04  -1.38380000E-04  -1.27700000E-04  -1.19440000E-04
   -1.33810000E-04  +3.73300000E-05  +1.71970000E-04  +1.41440000E-04  +9.13800000E-05
   -1.30300000E-05  -2.68400000E-05  +1.83300000E-05  -2.60880000E-04  +5.28100000E-05
   +2.08100000E-05  -1.84700000E-05  +1.10297000E-03  -9.64060000E-04  +1.31196000E-03
   -7.17000000E-06  -1.30800000E-05  -4.72000000E-06  +2.05200000E-05  -1.41000000E-05
   +9.36000000E-06  +5.06600000E-05  -2.60000000E-06  +5.43500000E-05  +3.74000000E-06
   -2.96900000E-05  +2.09420000E-04  +6.41000000E-06  -8.81000000E-06  +1.01000000E-05
   -5.08210000E-04  +2.83960000E-04  -7.25550000E-04  +4.78300000E-05  +9.67000000E-05
   -6.41900000E-05  -2.05540000E-04  +1.26080000E-04  +3.94370000E-04  -2.01702100E-02
   +1.66163100E-02  +2.08002000E-03  -5.46200000E-05  +2.72460000E-04  -9.53960000E-04
   -1.13434500E-02  +1.18265700E-02  +5.18362500E-02  -5.04953600E-02  +2.37267000E-03
   +1.04862600E-02  +5.76752000E-03  -1.55419800E-02  +1.80286800E-02  -1.49264000E-03
   +3.68295000E-03  +5.27140000E-03  +7.85200000E-04  -1.21660000E-04  -4.40700000E-04
   -3.74374000E-03  +2.01798000E-03  +4.20600000E-03  +2.17301000E-03  +1.71720100E-02
   -1.68646200E-02  -8.82020000E-04  -2.50275000E-03  -2.51096000E-03  +7.12930000E-04
   -2.35740000E-04  -9.62000000E-05  -3.49830000E-04  +6.17620000E-04  -2.07238000E-03
   +2.62391000E-03  -1.55824000E-03  -1.46570000E-04  -4.93220000E-04  +3.01890000E-04
   -2.03300000E-05  -3.75000000E-05  -5.07000000E-06  -1.08410000E-04  +3.04200000E-05
   -6.97000000E-06  +3.06900000E-05  -5.79700000E-05  -3.44000000E-05  +5.52000000E-06
   +2.17400000E-05  -1.08600000E-05  -7.54600000E-05  -5.72900000E-05  +1.35690000E-04
   +1.86190000E-04  +7.77300000E-05  +4.68300000E-05  -3.88000000E-06  -2.06967000E-03
   +1.26365000E-03  +9.02920000E-04  -1.57900000E-05  -1.56200000E-05  +4.70000000E-07
   +5.84000000E-06  -5.40000000E-07  +1.22600000E-05  +5.14100000E-05  -9.67900000E-05
   -3.10600000E-05  -9.53000000E-06  -9.07000000E-06  +1.30000000E-07  +6.33000000E-06
   -1.18500000E-05  +2.02000000E-06  +1.34200000E-04  -2.00680000E-04  -1.76570000E-04
   -5.31980000E-04  +1.01825000E-03  +1.75290000E-04  -1.43236000E-03  +4.77740000E-04
   -4.98580000E-04  +1.19500000E-05  -1.75600000E-05  -1.27280000E-04  +3.11800000E-05
   -3.12000000E-05  +2.69500000E-05  -4.41600000E-05  -1.06620000E-04  -1.49890000E-04
   +4.91708800E-02  -3.71360000E-04  -1.90653460E-01  +1.50971130E-01  +1.44187000E-03
   +5.09440000E-03  +2.79430000E-03  +2.51994000E-03  +3.78623000E-03  +3.71024000E-03
   -2.71100000E-05  +7.22430000E-04  -8.41200000E-05  +1.07521000E-03  +5.91670000E-04
   -4.92190000E-03  -4.74110000E-04  -1.33984100E-02  +1.75104500E-02  -1.58810000E-03
   -3.03228000E-03  -2.31863000E-03  +8.73620000E-04  -5.78980000E-04  +3.00000000E-07
   +1.84484000E-03  -5.52310000E-04  +2.10324000E-03  -8.40770000E-04  +1.43040000E-03
   -9.31680000E-04  -4.79400000E-04  +4.07250000E-04  +3.32690000E-04  -1.07820000E-04
   -9.23800000E-05  -1.23680000E-04  +1.10000000E-05  -1.26100000E-05  +1.67300000E-05
   -8.13000000E-06  +1.22500000E-05  -5.90000000E-07  +1.52900000E-05  -4.61100000E-05
   -6.42000000E-05  -7.01900000E-05  +9.17300000E-05  +2.15260000E-04  +1.08200000E-05
   -4.32000000E-06  -1.79200000E-05  +2.84828000E-03  -9.00290000E-04  -4.91760000E-04
   -1.35100000E-05  -6.27000000E-06  +6.15000000E-06  -2.34000000E-06  -9.98000000E-06
   +1.15400000E-05  -3.70800000E-05  -9.48400000E-05  -4.70400000E-05  +5.66000000E-06
   -3.84000000E-06  -4.17000000E-06  -6.96000000E-06  -1.21100000E-05  -1.08000000E-06
   +6.29600000E-05  -9.59200000E-05  -4.73190000E-04  +1.36128000E-03  -1.20859000E-03
   -2.53990000E-04  +1.37060000E-04  -2.22270000E-04  -2.43540000E-04  -1.70100000E-05
   +1.13100000E-05  +1.76000000E-05  -7.34000000E-06  +2.27200000E-05  +1.23000000E-05
   -4.11900000E-05  -1.12360000E-04  -2.89090000E-04  -7.17334000E-03  +1.99163060E-01
   +1.27730400E-02  +1.50420910E-01  -1.97208280E-01  +8.73000000E-05  +1.60348500E-02
   -8.11443000E-03  +6.43165000E-03  +3.05524000E-03  +2.51490000E-03  +1.57290000E-04
   -1.38920000E-04  +1.66180000E-04  +2.84330000E-04  +4.23180000E-04  -1.25240000E-04
   +1.87475000E-03  -1.80304000E-03  +4.00027000E-03  -3.21906000E-03  -1.43832000E-03
   -2.87987000E-03  +9.83260000E-04  -4.67530000E-04  -1.92900000E-05  +7.66820000E-04
   -1.26060000E-04  +7.29700000E-04  -3.24940000E-04  -6.87700000E-04  +1.79480000E-04
   -5.10090000E-04  +2.96000000E-04  +2.55100000E-04  -5.62800000E-05  -6.64800000E-05
   -1.01690000E-04  -1.60200000E-05  -5.07800000E-05  +8.58000000E-06  +1.38400000E-05
   +4.10500000E-05  +9.89000000E-06  -4.48000000E-06  -2.19400000E-05  +8.05000000E-06
   -5.41000000E-06  +2.93900000E-05  +1.08010000E-04  -4.49800000E-05  -4.05800000E-05
   -1.34100000E-05  -5.29840000E-04  +8.66920000E-04  +4.09230000E-04  -5.37000000E-06
   +5.80000000E-06  +3.70000000E-06  -4.03000000E-06  -5.06000000E-06  -9.70000000E-07
   +1.98300000E-05  +1.51500000E-05  -3.39900000E-05  -4.21000000E-06  +1.32000000E-05
   -7.38000000E-06  -9.44000000E-06  -8.23000000E-06  -2.00000000E-08  -4.90370000E-04
   -2.86320000E-04  +2.11260000E-04  -7.61400000E-05  -7.80570000E-04  +1.26000000E-06
   -3.59450000E-04  +2.64770000E-04  +1.79940000E-04  -5.04200000E-05  -1.93000000E-06
   +7.74200000E-05  +1.05000000E-05  -3.11700000E-05  -5.91600000E-05  +2.43000000E-06
   -1.79330000E-04  -2.72200000E-04  -1.61530100E-02  -1.66340790E-01  +2.01671950E-01
   +4.66403000E-03  +1.54420700E-02  +1.29434600E-02  -2.29621000E-03  -1.10911000E-03
   +3.87163000E-03  -8.95970000E-04  +4.77800000E-03  -2.11644000E-03  +1.70219000E-03
   +2.49840000E-04  -2.07548000E-03  -2.46054000E-03  -5.11385000E-03  -8.35994000E-03
   -5.19192800E-02  -3.71893600E-02  -3.59396400E-02  -8.01500000E-04  -1.16638000E-03
   -6.68060000E-04  -9.88600000E-05  +2.79800000E-05  -2.66190000E-04  +1.74658000E-03
   +1.00445000E-03  -8.71600000E-05  -2.83394300E-02  -2.84863500E-02  -9.33332000E-03
   -3.80500000E-04  +6.38510000E-04  +2.49800000E-05  -1.90300000E-05  -3.47400000E-05
   -1.96580000E-04  -5.34600000E-05  -1.46360000E-04  -4.14000000E-05  +8.26300000E-05
   +1.33200000E-04  +9.62800000E-05  +2.47500000E-05  -3.06200000E-05  -3.88200000E-05
   -1.55000000E-04  +2.59200000E-05  +2.02190000E-04  -1.49950000E-04  -1.19530000E-04
   -4.58500000E-05  -1.24420000E-04  -6.90000000E-05  +1.37900000E-04  +1.49000000E-06
   +1.40000000E-05  +1.61600000E-05  -2.70200000E-05  -2.02600000E-05  -7.57000000E-06
   -9.57000000E-06  +4.50000000E-05  -4.10800000E-05  +1.74600000E-05  +1.59000000E-05
   -2.05400000E-05  -1.32100000E-05  -2.41900000E-05  +7.58000000E-06  +1.65800000E-05
   +4.08900000E-05  -7.95700000E-05  +4.09200000E-05  +4.86300000E-05  +2.17500000E-05
   -5.08200000E-05  -3.52000000E-06  -8.43800000E-05  +3.46300000E-05  -2.86600000E-05
   -6.05900000E-05  +2.55800000E-05  -5.21900000E-05  -1.05900000E-05  -5.02900000E-05
   +5.92700000E-05  +4.44600000E-05  -6.84600000E-05  -4.49670000E-04  -9.28910000E-04
   +8.02405500E-02  +3.08638000E-03  -2.16698300E-02  -2.14225100E-02  +4.99900000E-05
   -2.90868000E-03  +3.40350000E-03  -8.61750000E-04  -5.33800000E-05  -4.89880000E-04
   -2.28331000E-03  -8.41210000E-04  -1.47250000E-03  +4.87398000E-03  +8.49891000E-03
   +4.08372000E-03  -4.31780400E-02  -1.47766500E-01  -9.64585100E-02  +1.05076000E-03
   +1.33251000E-03  +6.90280000E-04  -1.80440000E-04  +1.57090000E-04  +2.07170000E-04
   +1.31721000E-03  -1.81389000E-03  +4.83960000E-04  -2.05495000E-02  -8.55265000E-03
   -8.91160000E-04  +3.40200000E-04  -4.43270000E-04  -5.15200000E-05  +6.86100000E-05
   +7.92200000E-05  +1.43330000E-04  +4.66400000E-05  +9.67600000E-05  +7.29000000E-06
   -2.59400000E-05  -8.49200000E-05  -6.27500000E-05  -8.82000000E-06  +5.60000000E-06
   +2.78600000E-05  +1.99820000E-04  -2.04400000E-05  -1.77470000E-04  +8.23200000E-05
   +8.19900000E-05  +2.31200000E-05  +1.57900000E-05  +4.49200000E-05  -1.38200000E-04
   +6.22000000E-06  -1.16500000E-05  -7.90000000E-06  +2.80800000E-05  +1.51800000E-05
   +1.05400000E-05  +5.57000000E-05  -5.10900000E-05  -2.38300000E-05  -5.15000000E-06
   -2.16600000E-05  +1.99500000E-05  +1.24000000E-05  +1.96500000E-05  -3.70000000E-06
   +1.72800000E-05  -1.72500000E-05  +4.03400000E-05  -2.18200000E-05  +2.47600000E-05
   -1.05000000E-05  +2.45300000E-05  +7.10000000E-07  +3.50600000E-05  +1.57200000E-05
   +3.31000000E-06  -6.55600000E-05  -1.87000000E-05  +2.84800000E-05  +1.87000000E-05
   +2.86500000E-05  +2.97100000E-05  -1.88800000E-05  +2.94530000E-04  +5.03150000E-04
   +9.80880000E-04  +5.49105100E-02  +1.75029900E-01  +4.58230000E-04  -1.08292000E-03
   +1.17270000E-03  +8.54180000E-04  +5.98680000E-04  +5.14510000E-04  +2.29020000E-04
   -7.15870000E-04  +4.20200000E-04  +1.50445000E-03  +4.05622000E-03  +1.28291000E-03
   -1.13560100E-02  -2.33323500E-02  -2.25971600E-02  -4.39197500E-02  -1.05789310E-01
   -1.39775040E-01  -7.86700000E-05  -1.81460000E-04  -2.34820000E-04  +7.10100000E-05
   -5.18800000E-05  +9.82000000E-06  +4.91150000E-04  +4.80833000E-03  +9.44540000E-04
   +7.90953000E-03  +1.22703500E-02  +1.39169100E-02  -3.52400000E-05  +4.59000000E-05
   +3.38500000E-05  -1.59100000E-05  -5.63000000E-06  +1.09100000E-05  +7.77000000E-06
   +1.26800000E-05  +1.66000000E-05  +3.26700000E-05  -3.10000000E-06  -2.08100000E-05
   -9.72000000E-06  +8.66000000E-06  +1.50600000E-05  +6.00300000E-05  +1.29100000E-05
   -7.36200000E-05  -2.03400000E-05  +3.19000000E-06  -1.81000000E-06  -1.21000000E-05
   -4.50000000E-06  -2.94000000E-06  +1.12400000E-05  -3.25000000E-06  +3.94000000E-06
   +1.36000000E-05  -3.42000000E-06  +1.10200000E-05  +4.13400000E-05  -4.67500000E-05
   +2.94400000E-05  -4.83000000E-06  -2.03000000E-06  +7.29000000E-06  -1.75000000E-06
   +1.43000000E-06  +5.60000000E-07  +3.20000000E-06  -1.14000000E-06  -6.07000000E-06
   +1.27800000E-05  +1.36100000E-05  +1.42000000E-06  -1.19300000E-05  +1.70000000E-06
   +1.07000000E-06  -4.06000000E-06  -1.13000000E-06  +7.87000000E-06  +2.30000000E-06
   +3.77000000E-06  -2.92000000E-06  -1.22100000E-05  -1.65500000E-05  -1.48000000E-05
   +6.71000000E-06  -5.92870000E-04  -3.21910000E-04  +4.35958400E-02  +1.10180340E-01
   +1.45645050E-01  -1.51972000E-03  +7.05960000E-04  +2.22060000E-04  -1.71744000E-03
   +4.71595000E-03  +2.67201000E-03  +3.71707000E-03  +1.76007800E-02  -1.98263500E-02
   -5.66041300E-02  +1.02612900E-02  -3.14633000E-03  +7.10962000E-03  -1.72665100E-02
   +2.09070500E-02  -3.47605000E-03  +1.24530000E-04  +9.85030000E-04  +7.05010000E-04
   +7.60540000E-04  -1.01047000E-03  +6.16500000E-05  -1.17870000E-04  -1.29090000E-04
   +1.42719000E-03  +1.60021000E-03  -3.04358000E-03  -7.82740000E-04  -8.65610000E-04
   +1.81885000E-03  +1.04160000E-04  +2.84500000E-05  -7.81000000E-06  +2.05300000E-05
   -1.72500000E-05  -2.75900000E-05  -2.57700000E-05  -4.70200000E-05  -7.99000000E-06
   +5.81000000E-05  +4.45400000E-05  +1.09300000E-05  -2.14100000E-05  -2.15600000E-05
   +2.60400000E-05  -3.97000000E-06  +1.09200000E-05  +2.12300000E-05  -8.36400000E-05
   -7.01600000E-05  -4.30000000E-06  -4.17960000E-04  +1.68050000E-04  +1.22290000E-04
   -5.40000000E-07  +1.60700000E-05  -2.29000000E-06  -1.33900000E-05  -3.36000000E-06
   -1.32800000E-05  +9.38000000E-06  +2.47000000E-05  +9.15000000E-06  +5.93000000E-06
   +1.14100000E-05  -3.55000000E-06  -1.50300000E-05  +3.71000000E-06  -2.78000000E-06
   -2.77400000E-05  +1.00160000E-04  -1.29000000E-04  +1.51200000E-05  -1.79000000E-05
   +2.15000000E-05  +9.70000000E-06  -1.22800000E-05  -1.69800000E-05  +1.58200000E-05
   -1.45600000E-05  +5.28100000E-05  -2.03000000E-06  -1.19300000E-05  +1.16300000E-05
   -2.43500000E-05  +4.23000000E-06  +2.86800000E-05  -1.07100000E-04  -3.18840000E-04
   -3.52770000E-04  +3.06330000E-04  +5.41800000E-05  +1.38320000E-04  +5.10359300E-02
   -1.74686000E-03  +6.63480000E-04  +2.18530000E-04  +5.74943000E-03  +5.74451000E-03
   +2.17655000E-03  +1.14980000E-03  -8.68397000E-03  +1.57004400E-02  +8.27152000E-03
   -1.67515770E-01  +1.52137620E-01  +4.45524000E-03  +2.06248000E-03  +9.57900000E-05
   +1.21593000E-03  +1.73290000E-04  +1.26703000E-03  +2.81800000E-05  -8.12800000E-05
   +4.29950000E-04  +1.05950000E-04  -1.14120000E-04  -2.82000000E-05  -1.68544000E-03
   -8.70400000E-04  -1.00708000E-03  +5.13400000E-05  +7.19200000E-05  +2.78500000E-05
   -2.54720000E-04  -9.87400000E-05  -6.35900000E-05  +3.90800000E-05  +3.60700000E-05
   -3.49000000E-05  +3.94000000E-06  -9.02000000E-06  -2.67500000E-05  +1.64200000E-05
   +1.31000000E-05  +1.86600000E-05  +6.66000000E-06  -7.64000000E-06  +1.52500000E-05
   -2.24000000E-05  +7.67400000E-05  +1.79100000E-05  -1.90800000E-05  -1.73200000E-05
   -8.27000000E-06  +1.32570000E-04  -1.54840000E-04  -1.01860000E-04  -1.75000000E-06
   +5.41000000E-06  +1.77000000E-06  -3.49000000E-06  +1.00000000E-08  -4.91000000E-06
   +5.37000000E-06  +3.17000000E-06  -1.36800000E-05  +5.44000000E-06  -1.62500000E-05
   +3.59000000E-06  +4.47000000E-06  +9.10000000E-07  +1.05000000E-06  -1.94900000E-05
   -8.39000000E-05  +1.99900000E-05  -1.05500000E-05  -1.53900000E-05  +2.27900000E-05
   -5.45000000E-06  +1.60000000E-05  -2.65800000E-05  +3.61100000E-05  -3.15000000E-05
   +1.65600000E-05  -8.53000000E-06  -2.30200000E-05  +1.10900000E-05  -1.50400000E-05
   -4.72700000E-05  -2.85500000E-05  -4.60270000E-04  -5.06470000E-04  -4.23650000E-04
   +4.32700000E-05  -7.36000000E-06  -8.69600000E-05  -1.50850600E-02  +1.72510210E-01
   -9.23860000E-04  -3.45160000E-04  +6.88800000E-04  +2.01249000E-03  +4.07450000E-03
   +4.10423000E-03  +3.16021000E-03  -4.70700000E-04  +2.97040000E-03  -4.77296000E-03
   +1.55784470E-01  -2.14138110E-01  -3.55675000E-03  +1.34016400E-02  -1.33152500E-02
   +4.03732000E-03  -6.54590000E-04  +1.89634000E-03  +5.00030000E-04  +2.42270000E-04
   -1.46210000E-04  +1.32200000E-05  -5.54300000E-05  -1.17400000E-04  -4.88310000E-04
   -2.76338000E-03  +1.95714000E-03  +5.60560000E-04  +6.12380000E-04  -1.18622000E-03
   -9.98400000E-05  +1.59000000E-06  -2.23300000E-05  +2.01700000E-05  +2.81000000E-06
   -4.90900000E-05  -1.41000000E-05  -3.08400000E-05  -2.04500000E-05  +4.32900000E-05
   +3.75500000E-05  +2.27700000E-05  -1.65900000E-05  -3.08700000E-05  +3.08900000E-05
   -3.80000000E-06  +4.40300000E-05  +2.05100000E-05  -6.64400000E-05  -6.00300000E-05
   -8.74000000E-06  -1.29530000E-04  -2.80600000E-05  +4.89900000E-05  -3.80000000E-06
   +1.65600000E-05  -1.15000000E-06  -1.45100000E-05  +6.40000000E-07  -1.80300000E-05
   +9.20000000E-06  +2.11900000E-05  -4.68000000E-06  +6.69000000E-06  -3.17000000E-06
   -2.04000000E-06  -5.60000000E-06  -7.90000000E-07  -1.40000000E-07  -2.13600000E-05
   -2.13000000E-06  -5.06100000E-05  +1.79000000E-06  -2.04500000E-05  +1.24300000E-05
   +1.08900000E-05  +6.41000000E-06  -2.84000000E-05  +1.20200000E-05  -4.00700000E-05
   +4.30800000E-05  -1.88000000E-06  -1.50900000E-05  -4.30000000E-07  -2.02000000E-05
   -5.54000000E-06  +3.63100000E-05  -3.53950000E-04  -2.56970000E-04  -3.97090000E-04
   -1.81140000E-04  -3.95900000E-05  -3.23580000E-04  +2.53896000E-03  -1.66466220E-01
   +2.20108340E-01  +2.09560000E-04  +6.46180000E-04  +2.84100000E-04  +4.05977000E-03
   +1.42361000E-03  -1.07506000E-03  -2.31991230E-01  -2.04959800E-02  +1.36716330E-01
   -1.58190400E-02  -1.17047000E-03  +1.76648600E-02  +1.01361000E-03  +6.88116000E-03
   +1.15028000E-03  +2.46940000E-04  -7.68330000E-04  -3.55890000E-04  -3.26110000E-04
   +3.43350000E-04  -1.01610000E-04  -1.93870000E-04  +2.95300000E-04  +2.42750000E-04
   -1.55860000E-03  -1.24099000E-03  -2.16350000E-04  -1.62200000E-05  -1.83400000E-04
   +2.06270000E-04  -5.72770000E-04  +7.40630000E-04  -7.93500000E-04  -1.09060000E-04
   +1.91480000E-04  -1.07750000E-04  -1.53260000E-04  -1.76400000E-04  -3.10000000E-06
   -2.39960000E-04  -6.53200000E-05  +1.39950000E-04  +2.68830000E-04  +7.02300000E-05
   -7.53000000E-06  -2.72290000E-04  +1.87260000E-04  -2.72480000E-04  +1.39370000E-04
   +9.72200000E-05  +4.25000000E-06  +1.49900000E-05  -1.86970000E-04  -7.99600000E-05
   -1.80600000E-05  -2.27900000E-05  -6.57000000E-06  +4.97000000E-06  +6.76000000E-06
   +9.18000000E-06  +3.57000000E-06  -2.35900000E-05  +5.10100000E-05  +5.60300000E-05
   +3.65300000E-05  +1.00100000E-05  +3.87000000E-06  +1.50000000E-07  -6.23000000E-06
   +6.40800000E-05  -2.63500000E-05  +1.28200000E-05  -1.31800000E-05  -2.42000000E-05
   +4.46100000E-05  -1.46700000E-05  -2.92000000E-06  -4.92400000E-05  +2.79330000E-04
   +2.55100000E-04  -2.29590000E-04  +8.71000000E-06  -2.20400000E-05  -4.71000000E-06
   -1.44600000E-05  +1.03890000E-04  -2.06540000E-04  +8.63900000E-05  -1.02780000E-04
   -3.13600000E-04  -9.29400000E-05  +1.62270000E-04  -2.05200000E-04  -1.68450000E-04
   -2.00202000E-03  -2.05278000E-03  +2.45087240E-01  +7.32770000E-04  -2.71382000E-03
   +4.28754000E-03  -1.65280900E-02  +3.59505000E-03  +1.27148300E-02  -2.06174200E-02
   -5.78750500E-02  +2.44941400E-02  +1.77994700E-02  +9.79864000E-03  -1.07102300E-02
   +4.67046000E-03  +3.79392000E-03  +7.18001000E-03  +4.31370000E-04  -1.59226000E-03
   -5.25760000E-04  -8.91580000E-04  +1.73250000E-04  +3.15500000E-05  +6.82700000E-05
   -7.33130000E-04  +3.90800000E-04  +1.87513000E-03  -9.63790000E-04  -2.00044000E-03
   -2.16410000E-04  -3.06000000E-05  +7.84100000E-05  +3.46510000E-04  -6.24600000E-05
   -4.29800000E-05  +2.07080000E-04  +3.17500000E-05  -2.06700000E-05  +1.06140000E-04
   +1.34800000E-05  -4.24600000E-05  +2.68640000E-04  +3.14200000E-05  -1.41050000E-04
   -2.88490000E-04  -2.21390000E-04  +8.20500000E-05  +1.53920000E-04  +3.70330000E-04
   +3.03540000E-04  -2.59520000E-04  -1.97730000E-04  -2.73800000E-05  -3.16500000E-05
   -4.04000000E-05  -1.11960000E-04  +2.59000000E-06  +3.85900000E-05  +4.88000000E-06
   -2.99300000E-05  -1.34800000E-05  -2.56600000E-05  -2.56000000E-06  +6.20000000E-07
   -8.16900000E-05  +8.25100000E-05  -8.68600000E-05  -2.56400000E-05  -2.54100000E-05
   +1.85100000E-05  -2.98000000E-06  +4.51400000E-05  -7.20000000E-07  -1.73300000E-05
   +7.56000000E-06  +7.74900000E-05  +8.29000000E-06  -4.48800000E-05  +3.06100000E-05
   -1.18540000E-04  +2.36620000E-04  -1.44972000E-03  -6.19770000E-04  +4.78200000E-05
   +1.50950000E-04  -3.19000000E-05  +3.46400000E-05  +1.92090000E-04  -2.40290000E-04
   -1.01728000E-03  -2.45600000E-04  +5.34010000E-04  -9.87700000E-05  +2.56750000E-04
   -3.39460000E-04  -2.15120000E-03  -3.12242000E-03  -3.07873000E-03  +1.50391200E-02
   +5.08822000E-02  -1.32742000E-03  +4.56059000E-03  -1.15111000E-03  +1.86515900E-02
   +2.20343000E-03  -8.97364000E-03  +1.37268050E-01  +2.25246800E-02  -1.53296360E-01
   -4.48792000E-03  +4.63918000E-03  +8.79958000E-03  +1.69081000E-03  +7.02097000E-03
   +5.30809000E-03  -4.78800000E-04  -1.05718000E-03  +3.70980000E-04  +7.65280000E-04
   -7.17490000E-04  -3.37050000E-04  -3.69400000E-05  -9.21600000E-05  -1.32510000E-04
   +2.64580000E-04  -1.63395000E-03  -1.03772000E-03  +1.86700000E-04  -3.32840000E-04
   +2.59920000E-04  -2.79030000E-04  +3.88230000E-04  +1.02000000E-05  -3.37680000E-04
   -1.23770000E-04  +2.51530000E-04  -5.57700000E-05  +3.15100000E-05  +7.69900000E-05
   -3.45010000E-04  -1.03920000E-04  +1.71300000E-05  +1.06550000E-04  -6.51100000E-05
   -6.03900000E-05  -3.07700000E-05  -3.82750000E-04  -2.98390000E-04  +3.19670000E-04
   +1.97570000E-04  +4.32200000E-05  -1.46560000E-04  -8.98600000E-05  -1.99000000E-05
   -3.58000000E-05  -3.21400000E-05  -2.93400000E-05  +8.40000000E-06  +2.81500000E-05
   -1.52000000E-06  +4.04200000E-05  +7.02600000E-05  +3.54900000E-05  +7.65000000E-06
   -2.66800000E-05  -2.45300000E-05  +1.64000000E-05  +5.70000000E-07  -8.92000000E-06
   -7.07400000E-05  +6.12500000E-05  +2.93900000E-05  -1.89800000E-05  -1.34020000E-04
   +2.92700000E-05  +6.17900000E-05  +1.38800000E-05  +3.96400000E-05  +1.06540000E-04
   -5.81340000E-04  +4.41450000E-04  -2.55500000E-05  -1.75030000E-04  +8.38000000E-06
   -3.99600000E-05  +1.29700000E-05  +1.46680000E-04  +6.16540000E-04  -4.63340000E-04
   -9.91610000E-04  -1.30310000E-04  +1.29850000E-04  -3.59410000E-04  -1.91593000E-03
   -3.81193000E-03  -2.11499000E-03  -1.50367220E-01  -3.20382400E-02  +1.53034320E-01
   -3.54433000E-03  -3.48953000E-03  +1.10432000E-03  -7.84000000E-04  +7.68690000E-04
   -1.54340000E-04  -2.73760000E-04  +2.80130000E-04  -2.88360000E-04  -5.11170000E-04
   +5.82000000E-04  -1.15292000E-03  -1.34351000E-03  +6.94310000E-04  +1.53280000E-03
   -4.22069000E-02  +1.55113200E-02  -1.40022100E-02  +6.37000000E-05  +1.85610000E-04
   +3.74950000E-04  -7.85800000E-05  +6.31800000E-05  -1.56200000E-05  +4.71860000E-04
   +6.86560000E-04  -2.22671000E-03  -2.79604090E-01  +1.43611470E-01  -1.44228290E-01
   +7.75000000E-05  -8.55000000E-05  -1.42800000E-05  -2.13100000E-05  -7.50000000E-07
   +4.81900000E-05  +2.97100000E-05  +4.11200000E-05  +2.56900000E-05  -1.20850000E-04
   -8.62400000E-05  -2.79300000E-05  +2.73700000E-05  -2.48300000E-05  -3.39800000E-05
   +1.22000000E-06  -1.74200000E-05  +2.26300000E-05  +1.42600000E-04  +8.99600000E-05
   +1.77500000E-05  +5.72000000E-05  -4.96600000E-05  +4.23000000E-06  -2.53500000E-05
   -1.64800000E-05  -9.89000000E-06  -2.50000000E-06  +9.70000000E-06  +4.18000000E-06
   -2.20500000E-05  +1.38000000E-06  -3.12400000E-05  -8.43000000E-06  -4.00000000E-07
   -2.37000000E-06  +6.68000000E-06  +4.95000000E-06  -5.63000000E-06  +3.46500000E-05
   -1.36500000E-05  -8.65000000E-06  -6.16000000E-06  +4.56400000E-05  +4.92000000E-06
   -2.77700000E-05  -2.42000000E-06  -2.20700000E-05  -1.16900000E-05  +6.84000000E-06
   +1.40400000E-05  -7.23000000E-06  +1.99400000E-05  +1.46200000E-05  +2.51200000E-05
   -7.30000000E-07  +2.74900000E-05  +1.98000000E-04  -7.07800000E-05  +5.37600000E-05
   -8.97280000E-04  +3.91710000E-04  +2.44330000E-04  +4.09920000E-04  +1.94300000E-05
   -1.99450000E-04  +2.68900000E-05  +4.74200000E-05  +1.94300000E-05  +3.27924550E-01
   +5.91280000E-04  -1.70839000E-03  +4.31980000E-04  -4.05630000E-04  +2.98390000E-04
   +4.36680000E-04  +2.77000000E-05  +7.74260000E-04  -1.00781000E-03  +2.28786000E-03
   -7.82100000E-04  +1.79040000E-04  -8.67642000E-03  +2.61605000E-03  +2.61693000E-03
   -1.25787100E-02  +8.26825000E-03  -7.27523000E-03  -6.69900000E-05  +6.40000000E-07
   +1.23200000E-04  +1.94700000E-05  +5.09700000E-05  -3.15500000E-05  +4.57975000E-03
   -2.30807000E-03  -4.23837000E-03  +1.77174360E-01  -1.36271260E-01  +1.30494470E-01
   +9.23000000E-06  +5.46000000E-06  +7.65000000E-06  -8.64000000E-06  -5.04000000E-06
   +1.64400000E-05  -4.70000000E-07  -5.22000000E-06  +6.00000000E-06  -2.14100000E-05
   -6.19000000E-06  -2.58000000E-06  +3.48000000E-06  -1.11700000E-05  +1.80000000E-07
   +4.18000000E-06  -2.14200000E-05  -6.49000000E-06  +1.85000000E-05  +2.44000000E-06
   +5.00000000E-06  +4.32300000E-05  -1.00600000E-05  -9.97000000E-06  -7.42000000E-06
   +3.45000000E-06  -4.55000000E-06  -3.96000000E-06  +4.23000000E-06  -4.62000000E-06
   +2.54000000E-06  +8.50000000E-07  -5.92000000E-06  -4.00000000E-08  +6.76000000E-06
   -5.36000000E-06  -9.10000000E-07  +2.34000000E-06  -2.05000000E-06  +5.94000000E-06
   -8.02000000E-06  +5.15000000E-06  -7.07000000E-06  -1.01000000E-06  +2.08000000E-06
   -6.92000000E-06  -1.66000000E-06  -7.87000000E-06  -1.04500000E-05  -1.37000000E-06
   +2.92200000E-05  -7.73000000E-06  -1.60400000E-05  +5.96000000E-06  -3.30000000E-06
   -9.28000000E-06  +1.48100000E-05  -2.43320000E-04  -4.71900000E-05  -8.29700000E-05
   -3.33490000E-03  -1.94480000E-03  +2.42800000E-04  -2.14570000E-04  +2.93600000E-05
   +1.21760000E-04  +3.43200000E-05  -1.06270000E-04  -2.13600000E-05  -1.59202960E-01
   +1.31201100E-01  +4.42901000E-03  +2.68494000E-03  -2.53590000E-03  +1.54571000E-03
   -9.15760000E-04  -2.89760000E-04  +9.65000000E-05  -1.41476000E-03  +1.65277000E-03
   -3.18226000E-03  +1.40028000E-03  +6.15640000E-04  +1.27806900E-02  +9.42330000E-04
   -4.70100000E-04  +1.12288800E-02  -1.11262700E-02  +7.09095000E-03  +1.74320000E-04
   -5.61600000E-05  -5.34000000E-04  +1.68200000E-04  -9.48200000E-05  +1.09340000E-04
   -6.59297000E-03  -3.37037000E-03  +5.92180000E-04  -1.79124520E-01  +1.32817300E-01
   -1.34605030E-01  -1.77200000E-05  -5.97700000E-05  -4.79500000E-05  +1.47600000E-05
   +1.90300000E-05  -2.07800000E-05  +7.56000000E-06  +7.01000000E-06  -2.77800000E-05
   +5.77900000E-05  +2.84800000E-05  +9.29000000E-06  -1.24300000E-05  +1.20100000E-05
   +5.08000000E-06  -9.95000000E-06  +4.39900000E-05  +3.67800000E-05  -5.57000000E-05
   -3.13200000E-05  -1.66800000E-05  -5.90100000E-05  +6.56300000E-05  -2.01000000E-05
   +1.11200000E-05  +4.19000000E-06  +1.19200000E-05  -3.42000000E-06  -1.03100000E-05
   +2.62000000E-06  +2.15000000E-05  -1.19000000E-06  +9.66000000E-06  +1.30600000E-05
   -1.67600000E-05  +2.39000000E-06  +3.87000000E-06  -2.49000000E-06  +3.49000000E-06
   -2.57000000E-06  +4.04000000E-06  -5.40000000E-06  +7.10000000E-07  -6.82000000E-06
   +1.84200000E-05  -1.03800000E-05  -9.86000000E-06  -5.02000000E-06  +2.89000000E-05
   +1.27700000E-05  -6.07000000E-05  -3.65000000E-06  -2.04500000E-05  +1.28000000E-05
   -1.38500000E-05  -2.33100000E-05  -8.64100000E-05  -1.28170000E-04  +2.18640000E-04
   +1.16500000E-05  -2.48660000E-04  +8.48570000E-04  -3.10760000E-04  +5.35500000E-05
   -4.92800000E-05  +4.71000000E-06  -8.15200000E-05  +1.33120000E-04  -6.48400000E-05
   +1.58910620E-01  -1.22032630E-01  +1.28911520E-01
end_hess

