# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.15553750    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -4.09062788E+00  -1.62153951E+00  -2.14264801E+00
   006   -5.91868525E+00  -1.57906805E+00  -2.60806051E-01
   006   -5.75751030E+00  +2.05666798E-01  +1.65045396E+00
   006   -3.76597995E+00  +1.89913155E+00  +1.69247201E+00
   006   -1.90647615E+00  +1.87770166E+00  -1.63497566E-01
   006   -2.11978552E+00  +8.83238817E-02  -2.07966344E+00
   008   -7.87965114E+00  -3.22417559E+00  -2.00290523E-01
   006   +3.40848804E-01  +3.70850070E+00  -1.75751108E-01
   006   +1.93281556E-01  +5.36081609E+00  -2.55158057E+00
   006   +2.72696183E+00  +2.06205442E+00  -8.70464837E-02
   006   +4.40881624E+00  +2.03389202E+00  -1.98028279E+00
   006   +6.73285320E+00  +5.40420986E-01  -2.08328693E+00
   008   +2.53786372E+00  -4.08991461E+00  -8.52649595E-01
   006   +1.39493623E+00  -3.63434568E+00  +1.33837132E+00
   008   -4.41690274E-01  -4.78341335E+00  +2.00173125E+00
   006   +3.41157108E-01  +5.48492369E+00  +2.11961318E+00
   006   +3.11850850E+00  +7.12383775E-01  +2.34291686E+00
   006   +2.55071063E+00  -1.64264417E+00  +2.98163194E+00
   008   +7.01647292E+00  -1.57261524E+00  -1.24364928E+00
   001   -7.65435859E+00  -4.48742439E+00  -1.47452215E+00
   001   -4.17199064E+00  -3.02924479E+00  -3.62656384E+00
   001   -6.85497981E-01  -2.86388751E-02  -3.53344238E+00
   001   -3.68478416E+00  +3.24368654E+00  +3.22703962E+00
   001   -7.18027456E+00  +2.24291143E-01  +3.11632473E+00
   001   -1.57056403E+00  +6.42147969E+00  -2.50875186E+00
   001   +1.75041717E+00  +6.71125273E+00  -2.63023637E+00
   001   +1.94235714E-01  +4.24738152E+00  -4.28245865E+00
   001   +2.90555491E-01  +4.47099605E+00  +3.90817119E+00
   001   +2.03281112E+00  +6.66267512E+00  +2.09083991E+00
   001   -1.29701856E+00  +6.73053429E+00  +2.04803484E+00
   001   +4.16884462E+00  +3.30514189E+00  -3.56440386E+00
   001   +8.32594887E+00  +1.45514537E+00  -3.07305370E+00
   001   +2.78596364E+00  -2.22130475E+00  +4.92948374E+00
   001   +3.82093937E+00  +1.93373974E+00  +3.83490625E+00
   001   +4.15499839E+00  -3.19588246E+00  -9.36525777E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +4.20000000E-07  -4.40000000E-06  +1.45000000E-06
   +2.70000000E-07  +2.00000000E-08  +2.25000000E-06
   +2.60000000E-06  +3.68000000E-06  -6.60000000E-07
   -1.20000000E-06  -1.29000000E-06  +1.12000000E-06
   +3.48000000E-06  -1.39000000E-06  -8.80000000E-06
   -7.80000000E-07  +6.70000000E-07  +4.93000000E-06
   +6.70000000E-07  +0.00000000E+00  -1.04000000E-06
   +3.83000000E-06  +8.45000000E-06  +3.62000000E-06
   +4.09000000E-06  -2.81000000E-06  -5.11000000E-06
   +1.72000000E-06  -1.61800000E-05  +1.43200000E-05
   -3.17600000E-05  -1.69600000E-05  -1.92000000E-05
   +1.41000000E-06  +3.12000000E-06  +1.06300000E-05
   -1.80000000E-06  +1.92500000E-05  +1.58700000E-05
   +1.02800000E-05  -4.49500000E-05  -4.27400000E-05
   -5.26000000E-06  +7.60000000E-06  +4.02000000E-06
   -5.67000000E-06  +7.80000000E-07  -1.42000000E-06
   +1.66500000E-05  -1.71000000E-06  +3.96000000E-06
   -1.59300000E-05  +4.07400000E-05  +4.17300000E-05
   +1.13000000E-05  +4.31000000E-06  +8.66000000E-06
   -2.10000000E-07  +1.40000000E-07  -6.70000000E-07
   -4.40000000E-07  +1.00000000E-06  -1.26000000E-06
   -2.68000000E-06  -7.60000000E-07  -7.10000000E-07
   -2.48000000E-06  -2.57000000E-06  -8.00000000E-07
   +5.00000000E-07  -4.20000000E-07  -4.60000000E-07
   +4.90000000E-07  +9.10000000E-07  -5.50000000E-07
   +7.80000000E-07  -1.50000000E-06  -1.70000000E-07
   +1.64000000E-06  +2.57000000E-06  +8.90000000E-07
   +3.67000000E-06  -4.53000000E-06  -4.10000000E-07
   -3.30000000E-07  +1.00000000E-07  +1.01000000E-06
   -1.21000000E-06  -1.70000000E-07  +4.70000000E-07
   +1.69900000E-05  +1.01800000E-05  +1.63000000E-06
   -8.97000000E-06  +1.70000000E-07  +3.60000000E-07
   +1.11000000E-06  +7.00000000E-07  -4.90000000E-07
   +2.94000000E-06  +2.41000000E-06  -2.56000000E-06
   -6.12000000E-06  -7.16000000E-06  -2.98700000E-05
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.31592570E-01  +2.06780890E-01  +5.05475980E-01  -1.60367230E-01  +2.28118420E-01
   +5.43033440E-01  -1.95943550E-01  +1.21157400E-02  +1.39127940E-01  +5.48015760E-01
   -3.59231700E-02  -1.10030330E-01  -1.28767500E-02  +1.89789290E-01  +5.11167300E-01
   +8.54273500E-02  -5.91435100E-02  -2.22476810E-01  -1.62271760E-01  +2.02634550E-01
   +5.53647540E-01  +3.39531000E-02  +2.52874500E-02  +3.73549000E-03  -1.12738480E-01
   +4.34977000E-03  +4.73046700E-02  +5.71706980E-01  +5.02611700E-02  +2.37028000E-02
   -3.05915000E-02  -3.74004700E-02  -1.88751480E-01  -9.69504500E-02  +2.06961080E-01
   +4.69236350E-01  +3.53319600E-02  -6.81579000E-03  -3.36713900E-02  -4.90726000E-03
   -1.41552670E-01  -2.28977330E-01  -1.99022800E-01  +1.92353300E-01  +5.55380460E-01
   -5.38230700E-02  -2.26705000E-02  +2.21958900E-02  +2.36078200E-02  -4.21488000E-02
   -7.17617700E-02  -2.41850280E-01  -1.16798820E-01  +4.21369700E-02  +5.29859040E-01
   -1.96859000E-02  -1.19726500E-02  +8.60633000E-03  -9.80376000E-03  -3.59199300E-02
   -3.45903900E-02  -1.54588880E-01  -1.95324930E-01  -7.27656000E-03  +1.94703880E-01
   +4.89831960E-01  +2.62453400E-02  +1.24817600E-02  -1.47012800E-02  -3.25279300E-02
   -2.03769000E-03  +3.18262300E-02  -5.15044000E-03  -4.66990700E-02  -1.11835510E-01
   -1.49662290E-01  +2.24911780E-01  +5.58258700E-01  +2.05683400E-02  -1.16641500E-02
   -2.56312100E-02  -9.36448000E-03  +1.79765300E-02  +2.42056500E-02  -3.95047000E-02
   -3.29154900E-02  +7.68108000E-03  -2.07169780E-01  -9.14800000E-05  +1.38150960E-01
   +5.08253190E-01  -4.22200200E-02  -3.12218400E-02  -5.60514000E-03  +1.80899400E-02
   -1.53506300E-02  -2.91942900E-02  -2.67686000E-03  +2.67743700E-02  +2.59056000E-02
   -3.81525200E-02  -1.02200470E-01  -6.89209000E-03  +1.41155970E-01  +4.35237840E-01
   -6.28500700E-02  -3.53276400E-02  +2.65960400E-02  +2.49149700E-02  -2.80344700E-02
   -6.44124600E-02  +4.23205200E-02  +5.47837700E-02  +3.05643200E-02  +9.34852800E-02
   -4.43151300E-02  -2.09863680E-01  -1.52232480E-01  +1.68735590E-01  +5.33668060E-01
   -2.40006060E-01  -1.59142580E-01  -5.78352000E-03  -4.34794600E-02  -9.50400000E-04
   +4.50329300E-02  -1.79338800E-02  -2.36113600E-02  -1.41458800E-02  +3.27245700E-02
   +2.48159900E-02  +5.86391000E-03  -1.11834240E-01  -8.70988000E-03  +3.13108000E-02
   +5.76089720E-01  -1.17777770E-01  -2.01128110E-01  -4.74939600E-02  -3.33566400E-02
   +2.81548500E-02  +6.50644400E-02  -2.65707400E-02  -4.40438200E-02  -2.28803300E-02
   +5.44241900E-02  +2.13232100E-02  -3.78744600E-02  -4.72255400E-02  -1.89120490E-01
   -9.84324000E-02  +1.91173650E-01  +4.65415100E-01  +4.05874200E-02  -1.01752200E-02
   -1.07962230E-01  +4.90611000E-03  +3.32016000E-02  +3.61229500E-02  -1.73367700E-02
   -2.64832600E-02  -1.74001500E-02  +4.15516400E-02  -8.32752000E-03  -4.26443600E-02
   -1.44655400E-02  -1.33344900E-01  -2.13926580E-01  -1.88272370E-01  +1.86435710E-01
   +5.41064790E-01  -3.60750100E-02  -3.60712500E-02  +6.12282000E-03  -2.16772150E-01
   -1.04049400E-01  +4.26273700E-02  -3.23645000E-03  -1.80025600E-02  -7.46577000E-03
   +2.36463000E-03  +8.76290000E-04  +3.68810000E-03  -3.12076000E-03  -3.12569000E-03
   -2.30198000E-03  +4.24765000E-03  +3.13682000E-03  +6.49233000E-03  +2.97521860E-01
   -1.40018500E-02  -2.64335000E-03  +1.09558000E-03  -1.41145320E-01  -1.73291780E-01
   -5.83790000E-03  -3.82044900E-02  -3.38653200E-02  -7.87709000E-03  +4.32928000E-03
   +3.87093000E-03  -6.04251000E-03  -3.44400000E-03  -1.44768000E-03  +2.58928000E-03
   -1.67153000E-03  +2.96899000E-03  -3.69616000E-03  +1.33526150E-01  +4.69218410E-01
   +3.10222700E-02  +2.24720800E-02  +5.87211000E-03  +1.32554900E-02  -3.03431900E-02
   -8.67355400E-02  -3.21180200E-02  -3.06948100E-02  +4.18928000E-03  +8.85162000E-03
   -1.19082000E-03  -5.20316000E-03  -2.89415000E-03  +2.99444000E-03  +5.20763000E-03
   +8.27270000E-04  -9.39622000E-03  -4.28512000E-03  -9.67639100E-02  +2.83217970E-01
   +3.57341070E-01  +5.22828000E-03  -2.05200000E-05  +1.23312000E-03  -2.10891000E-03
   +7.69700000E-05  +1.69852000E-03  +1.01052000E-03  -1.00107000E-03  +4.50945000E-03
   -1.77188800E-02  -1.52844700E-02  +4.71600000E-04  -1.29266510E-01  -3.96305200E-02
   +8.75934000E-03  -4.08063000E-03  -8.58268000E-03  -6.13578000E-03  +1.22717000E-03
   +1.26399000E-03  -3.85770000E-04  +4.40375320E-01  +1.57580000E-04  +1.53859000E-03
   -4.57423000E-03  -5.08040000E-04  -6.30010000E-04  +3.17140000E-04  -8.38780000E-04
   +3.08830000E-03  -3.04005000E-03  -3.51151000E-03  +2.60096000E-03  +2.88203000E-03
   -5.26194200E-02  -1.10136450E-01  -4.65089000E-03  -1.86972400E-02  -1.62376900E-02
   -1.32372000E-03  +8.88930000E-04  +3.95210000E-04  +3.62340000E-04  -7.49960000E-04
   +4.74816600E-01  +1.41365000E-03  -4.91152000E-03  -2.27893000E-03  +2.30150000E-04
   -7.24050000E-04  -1.67899000E-03  +4.48645000E-03  -2.19160000E-03  -4.29740000E-04
   +1.31991900E-02  +1.44006100E-02  +4.89476000E-03  +5.31289000E-03  -7.92958000E-03
   -8.21628200E-02  -1.96057100E-02  -1.33401500E-02  +4.62271000E-03  +2.64360000E-04
   +7.67580000E-04  +1.73300000E-04  -1.29147000E-03  -1.82115000E-03  +4.92537350E-01
   -1.44810000E-04  +4.96960000E-04  +2.75810000E-04  +4.70320000E-04  +8.44050000E-04
   +5.34550000E-04  -1.55106000E-03  -6.01900000E-05  -8.48530000E-04  -5.51410000E-04
   -2.08710000E-03  -1.12857000E-03  -2.71229000E-03  -1.70906100E-02  +2.26202100E-02
   -2.12930000E-04  -8.41020000E-04  +8.21550000E-04  -1.03581000E-03  -9.59940000E-04
   -1.38540000E-04  -7.39532600E-02  +7.64360000E-04  -1.61397000E-03  +5.87300130E-01
   +8.83400000E-05  +7.18930000E-04  +2.37780000E-04  +1.07770000E-04  +5.41340000E-04
   +6.00330000E-04  -9.45490000E-04  -2.61550000E-04  -7.96030000E-04  +1.32623000E-03
   -1.24448000E-03  -9.18760000E-04  -7.09936000E-03  -1.81620400E-02  +1.86424100E-02
   -4.62150000E-04  -6.06470000E-04  +9.62890000E-04  -4.92550000E-04  -4.58320000E-04
   -1.23440000E-04  +4.83213000E-03  -1.07792660E-01  +4.74237400E-02  +4.82968000E-03
   +5.42217350E-01  +1.64320000E-04  -1.76250000E-04  -2.16250000E-04  +2.61110000E-04
   +2.16150000E-04  +2.79930000E-04  -1.06950000E-04  -2.64350000E-04  -1.26220000E-04
   -7.33870000E-04  -2.43510000E-04  -2.55330000E-04  +6.60166000E-03  +7.11207000E-03
   -2.05267000E-03  -1.56879000E-03  -7.98000000E-04  +1.70100000E-05  -4.44980000E-04
   -3.79790000E-04  -1.08020000E-04  -5.02003000E-03  +4.40928600E-02  -1.44713450E-01
   -8.49481000E-03  +6.27202300E-02  +5.16024350E-01  -3.51750000E-04  +4.40080000E-04
   +8.12240000E-04  -6.99680000E-04  -1.43249000E-03  -8.25200000E-04  +8.44670000E-04
   +4.28960000E-04  +1.04820000E-03  -1.43689000E-03  -9.85540000E-04  +2.22820000E-04
   -3.62797600E-02  +2.08158000E-03  +1.71037000E-03  +5.27400000E-04  -2.66250000E-04
   -1.30716000E-03  +1.12207000E-03  +1.07747000E-03  +1.90780000E-04  -1.18966640E-01
   +4.72070200E-02  -1.03145000E-02  -5.32580000E-03  +6.49120000E-03  -4.87215000E-03
   +5.02931410E-01  -1.16190000E-04  -6.77330000E-04  +4.44410000E-04  +5.22440000E-04
   +5.74690000E-04  -9.94000000E-05  -7.94100000E-05  -8.61750000E-04  +8.68590000E-04
   -1.99029000E-03  -2.53750000E-03  -9.49580000E-04  -1.04228600E-02  +1.41070900E-02
   +4.74510000E-04  -2.22822000E-03  -9.32770000E-04  -8.72980000E-04  -8.87060000E-04
   -7.81070000E-04  -1.03330000E-04  +3.45143100E-02  -1.01354740E-01  +9.14019000E-03
   +1.81074500E-02  -1.35808900E-02  +3.21604000E-03  -8.72669500E-02  +3.21350570E-01
   -2.10110000E-04  -3.10360000E-04  +1.40990000E-04  +6.22270000E-04  +7.21300000E-04
   +1.99900000E-05  -2.64700000E-05  -4.04510000E-04  -4.97910000E-04  +4.90810000E-04
   +8.39330000E-04  -1.38248000E-03  -6.91000000E-05  +6.48250000E-04  -2.07230000E-04
   -1.61696000E-03  +2.40190000E-04  +1.28907000E-03  -7.92490000E-04  -6.91420000E-04
   -1.55930000E-04  +1.17928000E-03  -2.35654000E-03  -8.46956300E-02  -2.51992800E-02
   +1.66365800E-02  -3.47490000E-04  -2.01357380E-01  -8.31442300E-02  +6.44499080E-01
   -2.09020000E-04  +9.35400000E-05  +1.43630000E-04  +1.06851000E-03  +1.60517000E-03
   +6.49410000E-04  -5.49960000E-04  -1.33222000E-03  -2.45420000E-04  -6.11100000E-05
   -3.49540000E-04  -1.43616000E-03  -1.72433000E-03  +3.83304000E-03  -2.51990000E-04
   -1.30190000E-03  +5.14190000E-04  +9.19520000E-04  -1.61603000E-03  -1.58695000E-03
   -1.57390000E-04  -2.00659000E-02  +3.97997000E-03  +2.25833700E-02  -2.97790000E-03
   -3.83480000E-04  +1.30455000E-03  -2.48994470E-01  +2.96663900E-02  +1.96972990E-01
   +5.47983760E-01  +2.33610000E-04  +5.27520000E-04  -1.85390000E-04  -5.27310000E-04
   -5.19040000E-04  +3.70200000E-05  +4.72200000E-05  +4.37970000E-04  -1.20340000E-04
   +6.72850000E-04  +7.37940000E-04  +6.04530000E-04  +1.45277000E-03  -3.73665000E-03
   -5.72540000E-04  -2.75200000E-04  -1.03650000E-04  -5.93270000E-04  +6.77390000E-04
   +5.99980000E-04  +1.11440000E-04  +1.47125600E-02  +7.29671000E-03  -1.38204200E-02
   +1.23850000E-03  -1.43507000E-03  -1.41576000E-03  +1.66995000E-02  -8.64451800E-02
   +2.39683000E-02  -1.54205220E-01  +3.72412520E-01  -1.44320000E-04  +4.58360000E-04
   +4.18600000E-05  -4.75440000E-04  -8.01780000E-04  -3.14970000E-04  +2.01240000E-04
   +6.01460000E-04  +1.85860000E-04  +1.88460000E-04  -8.97000000E-06  +1.30421000E-03
   +6.90700000E-04  -2.75491000E-03  -5.51800000E-04  -7.17400000E-05  -6.70070000E-04
   -1.36104000E-03  +6.79180000E-04  +5.96830000E-04  +2.03390000E-04  +1.10193000E-02
   +4.32073000E-03  +6.20439000E-03  -9.86890000E-04  +6.95050000E-04  -8.68860000E-04
   +2.03424190E-01  +5.47498000E-03  -3.18964590E-01  -2.13558940E-01  -1.94078820E-01
   +6.17710800E-01  +2.00860000E-04  -2.49560000E-04  -3.71710000E-04  -1.06536000E-03
   -1.55651000E-03  -6.21290000E-04  +5.94100000E-04  +1.24074000E-03  +2.84340000E-04
   -1.56350000E-04  +3.00000000E-05  +1.45466000E-03  +2.55049000E-03  -2.88229000E-03
   -4.12090000E-04  +7.33830000E-04  -2.48330000E-04  -3.24930000E-04  +1.63762000E-03
   +1.52123000E-03  +1.42100000E-04  +5.12777000E-03  +7.97345000E-03  +3.83121000E-03
   +1.15874000E-03  -3.63180000E-04  -3.39150000E-04  -3.44151100E-02  +5.13121000E-03
   +1.84506500E-02  -2.00072240E-01  +6.16230700E-02  +8.03810000E-04  +5.42726280E-01
   -2.11750000E-04  +4.18600000E-05  +2.20210000E-04  +6.05790000E-04  +9.07910000E-04
   +3.70000000E-04  -3.50030000E-04  -6.94350000E-04  -2.62430000E-04  +1.81680000E-04
   -4.01900000E-05  -4.45560000E-04  +1.49612000E-03  +8.61180000E-04  -4.53060000E-04
   -5.10980000E-04  -1.22930000E-04  +1.27690000E-04  -9.72000000E-04  -1.03251000E-03
   -4.17000000E-05  +2.53321000E-03  +6.04920000E-03  +7.67972000E-03  -1.04450000E-04
   -3.13570000E-04  +3.65460000E-04  +1.42227300E-02  +9.85329000E-03  -1.85741200E-02
   +3.50631500E-02  -1.12751690E-01  +2.12564000E-02  -6.07440900E-02  +8.33542510E-01
   -1.51200000E-05  +7.69400000E-05  -4.38900000E-05  -9.99800000E-05  -2.82650000E-04
   -1.48670000E-04  +1.25420000E-04  +3.47440000E-04  -5.07900000E-05  +1.56180000E-04
   +1.61540000E-04  +4.32880000E-04  +1.22541000E-03  -1.45223000E-03  -3.54420000E-04
   +1.24010000E-04  -9.66000000E-05  -2.59160000E-04  +2.40470000E-04  +2.70700000E-04
   +2.35100000E-05  +3.92876000E-03  +5.62567000E-03  -1.95963000E-03  -9.75630000E-04
   +6.37930000E-04  -3.31720000E-04  +1.84732600E-02  -1.76165100E-02  +8.68382000E-03
   +3.33095600E-02  +5.25613000E-03  -1.04683380E-01  -1.00112370E-01  -2.72185780E-01
   +3.67371650E-01  +3.09790000E-04  +4.04690000E-04  -4.03800000E-05  +1.34650000E-04
   -1.65170000E-04  +1.45960000E-04  +5.70100000E-05  +4.58770000E-04  -1.81330000E-04
   -2.04600000E-04  -1.52070000E-04  +2.36930000E-04  +9.24000000E-06  -8.59530000E-04
   -1.35830000E-04  -7.97940000E-04  +3.73380000E-04  -1.53570000E-04  +1.21100000E-04
   +4.51510000E-04  -1.65460000E-04  -1.92920000E-04  +3.67630000E-04  -5.09460000E-04
   +3.33250000E-04  +5.26000000E-05  -1.63600000E-05  -1.38943000E-03  -1.17799000E-03
   +2.55616000E-03  +4.67318000E-03  -1.75747000E-03  -3.49114000E-03  -9.13111000E-03
   +1.27678500E-02  -3.22550000E-03  +5.13831570E-01  -5.32400000E-05  -3.02700000E-05
   -2.33060000E-04  -2.44060000E-04  -5.66940000E-04  -2.88190000E-04  +2.46630000E-04
   +2.45130000E-04  +1.02150000E-04  -9.67000000E-05  +2.39700000E-05  +1.46950000E-04
   +1.16400000E-05  -1.64450000E-04  +2.99700000E-05  +2.11330000E-04  -4.99140000E-04
   +4.85900000E-04  +4.54040000E-04  +5.61170000E-04  -3.47000000E-06  -5.86190000E-04
   -2.29700000E-05  +3.72600000E-05  +2.65590000E-04  -5.10300000E-05  -6.10800000E-05
   -2.41850000E-04  -1.05594000E-03  +2.90600000E-04  +1.85590000E-04  -1.28624000E-03
   -7.05040000E-04  -1.51110000E-04  +1.93844000E-03  -8.88110000E-04  +2.09033610E-01
   +2.13378410E-01  -1.65620000E-04  +1.19560000E-04  +1.19860000E-04  +3.02380000E-04
   +3.69450000E-04  -3.10190000E-04  -3.54120000E-04  -3.07890000E-04  +6.98490000E-04
   +2.86610000E-04  +1.74350000E-04  +2.60250000E-04  -7.10380000E-04  +1.73780000E-04
   +3.00000000E-07  +5.66800000E-04  +5.03550000E-04  -1.32643000E-03  -3.23530000E-04
   -5.25510000E-04  +3.37600000E-04  -8.26140000E-04  -6.68090000E-04  +1.18405000E-03
   +3.87800000E-04  -2.75180000E-04  -1.33010000E-04  +3.85073000E-03  +8.18480000E-04
   -5.50956000E-03  -3.21056000E-03  +1.63375000E-03  +4.80412000E-03  +4.01396000E-03
   -8.89691000E-03  +1.94949000E-03  -1.56243370E-01  +8.72968800E-02  +3.68257810E-01
   -9.17540000E-04  -9.76280000E-04  +8.74100000E-05  -4.23080000E-04  +4.58260000E-04
   -1.29960000E-04  -4.34050000E-04  -6.90130000E-04  +6.15870000E-04  +1.50200000E-04
   +2.20430000E-04  -5.08500000E-05  +2.23950000E-04  +1.71407000E-03  -3.83800000E-05
   +7.08150000E-04  +1.27655000E-03  -1.54766000E-03  -3.16330000E-04  -9.56690000E-04
   +3.73010000E-04  +1.78057000E-03  +3.19980000E-04  -8.98760000E-04  -1.24869000E-03
   +1.14840000E-04  +9.21700000E-05  -4.33395000E-03  +1.48106000E-03  +1.63192000E-03
   -1.95641000E-03  +3.61810000E-04  +2.15171000E-03  +1.41002000E-03  -6.14122000E-03
   +1.78349000E-03  -1.20105000E-01  -1.41184800E-02  +5.55215100E-02  +7.49595850E-01
   +1.63240000E-04  -1.05930000E-03  +5.54800000E-04  +3.82320000E-04  +1.63058000E-03
   +7.15920000E-04  -5.38890000E-04  -7.61470000E-04  -3.69840000E-04  +5.43480000E-04
   +2.89740000E-04  -7.94970000E-04  +3.17260000E-04  +9.81900000E-05  +1.86430000E-04
   +1.60118000E-03  +6.24000000E-06  +1.13994000E-03  -1.14300000E-03  -1.63271000E-03
   +5.22100000E-05  +1.58516000E-03  -5.54190000E-04  -3.33520000E-04  -9.60450000E-04
   +1.73850000E-04  +6.24400000E-05  +2.87888000E-03  -1.99578000E-03  +1.30757000E-03
   +1.12465000E-03  +3.44140000E-04  -3.10839000E-03  -3.48978000E-03  +4.00829000E-03
   +9.00000000E-08  +6.55513000E-03  -1.04103380E-01  -8.45251500E-02  +3.29664250E-01
   +5.26269020E-01  -4.67930000E-04  +1.18700000E-05  -2.39030000E-04  -2.39630000E-04
   -8.27430000E-04  +5.56100000E-05  +7.61960000E-04  +4.58790000E-04  -7.73470000E-04
   -3.38740000E-04  -2.81900000E-04  -4.01210000E-04  +5.70600000E-04  +5.27140000E-04
   -1.90980000E-04  -1.45250000E-03  +6.66880000E-04  +8.05110000E-04  +3.78870000E-04
   +6.29130000E-04  -3.89370000E-04  +9.20580000E-04  +4.91190000E-04  -9.12180000E-04
   -5.69630000E-04  +2.44210000E-04  +6.32100000E-05  +1.64160000E-04  -1.33741000E-03
   +7.23052000E-03  +3.87769000E-03  -1.32627000E-03  -6.36170000E-03  -5.75805000E-03
   +1.14078100E-02  -2.00656000E-03  +9.13408400E-02  -6.53726800E-02  -2.71086340E-01
   -1.96187580E-01  +2.90056100E-02  +5.67257280E-01  +1.64500000E-05  +1.60748000E-03
   -6.40380000E-04  +6.99500000E-05  -6.51800000E-04  -2.70710000E-04  +4.16120000E-04
   +5.75570000E-04  -4.93010000E-04  -1.95780000E-04  -3.20610000E-04  +2.17820000E-04
   -1.20690000E-04  -1.01325000E-03  -3.05800000E-05  -1.61656000E-03  -2.89440000E-04
   -5.48600000E-05  +5.86480000E-04  +1.08332000E-03  -2.37320000E-04  -1.05260000E-03
   +1.93250000E-04  -9.55000000E-06  +7.80900000E-04  +5.82000000E-06  +1.21300000E-05
   -2.19756000E-03  +1.18286000E-03  -1.28140000E-04  +1.30226000E-03  -1.10193000E-03
   -4.90100000E-04  -8.13860000E-04  +3.56536000E-03  -1.23747000E-03  -5.21304900E-02
   -1.66441000E-02  +6.04886200E-02  -5.24267490E-01  -2.92345560E-01  +1.38579510E-01
   +5.95017590E-01  +3.83680000E-04  -2.87400000E-05  -2.03580000E-04  -1.09626000E-03
   -1.43222000E-03  +2.82700000E-05  +1.25030000E-04  +3.51410000E-04  +2.13810000E-04
   -1.57070000E-04  +2.13500000E-05  +3.47580000E-04  +1.17040000E-04  -1.69940000E-04
   +1.81890000E-04  +9.20000000E-05  -7.66670000E-04  +2.60410000E-04  +1.00792000E-03
   +1.46666000E-03  -1.72850000E-04  -1.04501000E-03  +1.77310000E-04  +1.93120000E-04
   +5.59000000E-04  -1.10010000E-04  -5.86500000E-05  -2.02568000E-03  +1.27839000E-03
   -8.48270000E-04  -1.91290000E-04  -5.15490000E-04  +1.25758000E-03  +1.17198000E-03
   -2.99010000E-04  -4.36090000E-04  -8.24111000E-03  +2.15238200E-02  +2.00705100E-02
   -2.95884550E-01  -2.74186660E-01  +8.12955400E-02  +3.47283060E-01  +2.68069690E-01
   -1.27510000E-04  +8.14670000E-04  -3.50220000E-04  +4.32900000E-04  +4.62700000E-04
   -4.17520000E-04  -1.67240000E-04  -3.28410000E-04  +1.52730000E-04  +2.59710000E-04
   +1.12610000E-04  +1.90270000E-04  -2.43820000E-04  -2.24310000E-04  -1.00360000E-04
   -6.93690000E-04  +2.72870000E-04  -7.72990000E-04  -2.49500000E-04  -2.94080000E-04
   +1.78270000E-04  -2.92070000E-04  -2.69170000E-04  +3.96710000E-04  +2.33300000E-04
   -5.71200000E-05  -1.20700000E-05  +5.57680000E-04  +6.09070000E-04  -2.13883000E-03
   -1.05232000E-03  +3.83800000E-04  +1.72082000E-03  +1.79019000E-03  -3.45182000E-03
   +6.06380000E-04  +7.43827900E-02  +3.29781600E-02  -2.58330600E-02  +1.39286060E-01
   +8.06011700E-02  -1.44240170E-01  -2.05072670E-01  -9.60901100E-02  +1.57746700E-01
   +1.32970000E-04  -9.42130000E-04  -1.03809000E-03  +3.68780000E-04  +8.79100000E-05
   -4.86600000E-05  +2.72060000E-04  -2.92300000E-04  -7.84340000E-04  -1.31764000E-03
   -9.51240000E-04  -1.90760000E-04  +1.38870000E-04  -1.82823700E-02  -2.30302300E-02
   -4.45669000E-03  -2.69165000E-03  +1.58556000E-03  -4.14920000E-04  -3.62280000E-04
   -5.20000000E-07  -7.47021200E-02  +4.22345000E-03  +3.60006000E-03  +5.62440000E-04
   -2.89610000E-04  -1.02947000E-03  -2.30021000E-03  +1.85162300E-02  +2.44514700E-02
   -4.27886000E-03  +2.52065000E-03  -1.97136000E-03  -8.47590000E-04  -3.18927000E-03
   -1.92750000E-04  +3.75710000E-04  +2.20770000E-04  -1.31590000E-04  -5.09190000E-04
   -5.63290000E-04  -1.43520000E-04  +6.28840000E-04  +4.41940000E-04  +5.39300000E-05
   +5.87840850E-01  +3.95720000E-04  -2.92600000E-04  -8.92850000E-04  -1.91620000E-04
   +1.64450000E-04  +7.29800000E-05  +3.82160000E-04  -2.72520000E-04  -6.53370000E-04
   +3.75460000E-04  -3.50320000E-04  +3.68900000E-04  -4.00443000E-03  -1.61154500E-02
   -1.77719500E-02  -3.19392000E-03  -1.20214000E-03  +7.68950000E-04  +3.64900000E-05
   -1.06000000E-05  +4.59000000E-06  -1.04562000E-03  -1.13332970E-01  -4.85669600E-02
   -4.69330000E-04  +1.06201200E-02  +1.28251700E-02  +5.22531000E-03  -1.67960400E-02
   -1.74552800E-02  +3.33090000E-04  -1.30330000E-03  +1.62929000E-03  +8.16400000E-04
   +1.34730000E-03  +2.26630000E-04  -9.46300000E-05  -4.14600000E-05  +1.96720000E-04
   +1.68500000E-05  -9.93800000E-05  -2.32930000E-04  -3.31100000E-05  +1.14000000E-06
   +9.82400000E-05  -2.13010000E-03  +5.35654350E-01  +4.48670000E-04  +1.77850000E-04
   +6.63300000E-05  -2.32360000E-04  -1.85170000E-04  +2.90730000E-04  +2.45610000E-04
   +1.52500000E-05  -3.21900000E-04  +5.36180000E-04  +1.11371000E-03  +3.55880000E-04
   -3.77383000E-03  -2.37683000E-03  -3.56730000E-04  +1.08357000E-03  +4.21770000E-04
   -6.81900000E-05  +3.01840000E-04  +2.34440000E-04  -4.07200000E-05  -2.99837000E-03
   -4.32948000E-02  -1.38258130E-01  -4.53300000E-04  -1.55645900E-02  -3.67460200E-02
   +8.49808000E-03  -6.44471000E-03  -8.31530000E-04  -3.46549000E-03  +6.03950000E-04
   +9.30520000E-04  +1.03454000E-03  -1.58740000E-03  +5.18160000E-04  +2.89130000E-04
   +4.01900000E-05  -4.20580000E-04  -3.48720000E-04  +3.03850000E-04  +6.64180000E-04
   +3.29100000E-05  -1.23780000E-04  -1.95990000E-04  -2.68068000E-03  -6.66010200E-02
   +5.21628380E-01  -4.33580000E-04  -2.44670000E-04  +1.94820000E-04  +2.61080000E-04
   +9.22500000E-05  -3.57590000E-04  +2.36880000E-04  +9.45300000E-05  +4.13400000E-05
   -4.49890000E-04  +2.13030000E-04  -4.56110000E-04  -8.26270000E-04  +1.16286000E-03
   -1.75083000E-03  +1.80010000E-04  +3.33070000E-04  +2.83640000E-04  -2.02820000E-04
   -1.88940000E-04  +9.82000000E-06  -1.11098000E-03  +1.37954900E-02  -2.02488900E-02
   -3.52072000E-03  +2.17976000E-03  +1.46094000E-03  -8.30944500E-02  +9.86951000E-03
   -1.95259400E-02  +7.03951000E-03  -8.73350000E-03  +1.85588700E-02  -1.84762000E-03
   -4.28895000E-03  -5.82500000E-05  -4.69110000E-04  +1.17690000E-04  -6.88600000E-04
   -1.85850000E-04  -1.46853300E-02  +2.74527000E-03  -1.29250000E-04  -4.40000000E-05
   -2.02190000E-03  -1.50505000E-03  +1.56617000E-03  +5.25730000E-04  +2.28815660E-01
   +3.48430000E-04  +1.96310000E-04  -5.77900000E-05  -2.76990000E-04  -4.38300000E-05
   +2.58050000E-04  -1.72830000E-04  -3.40350000E-04  +4.81700000E-05  +1.51980000E-04
   +1.13040000E-04  +3.29500000E-05  -3.79100000E-05  +3.01990000E-04  +6.71910000E-04
   -2.45280000E-04  -4.42650000E-04  -2.81600000E-04  +1.42470000E-04  +1.52060000E-04
   -1.00400000E-05  +8.00229000E-03  -1.22473200E-02  +1.83523200E-02  +3.55686000E-03
   -5.04240000E-04  -2.36570000E-04  +1.13876200E-02  -1.19312870E-01  +4.92049200E-02
   -2.30088000E-03  +1.14783300E-02  +5.37055000E-03  -3.48644000E-03  -4.57388000E-03
   -3.50437000E-03  +5.89940000E-04  +1.04757000E-03  +5.30220000E-04  -9.31477000E-03
   -2.01725500E-02  +6.28827000E-03  -8.07620000E-04  +4.04750000E-04  -3.23806000E-03
   +1.04820000E-03  -8.17670000E-04  +9.28170000E-04  +1.53753620E-01  +8.05081470E-01
   +5.24700000E-05  +1.02500000E-05  -1.77600000E-05  -1.54380000E-04  -2.33350000E-04
   -5.93900000E-05  +9.66100000E-05  +2.03030000E-04  -7.40800000E-05  +1.23120000E-04
   +1.00750000E-04  +1.45690000E-04  -3.57320000E-04  +2.92890000E-04  -5.33970000E-04
   -1.67900000E-05  +2.00430000E-04  -1.11810000E-04  +3.16300000E-04  +3.48460000E-04
   -1.50200000E-05  -9.85805000E-03  +8.14960000E-03  +2.27374000E-03  +2.44827000E-03
   -7.33190000E-04  +1.19560000E-04  -1.31489300E-02  +5.43222800E-02  -1.90409210E-01
   +3.60390000E-04  +1.50600200E-02  -2.61090400E-02  -1.93258000E-03  -2.00877000E-03
   -2.07396000E-03  -5.15920000E-04  +1.57656000E-03  -5.32833000E-03  +1.97259000E-03
   -1.11844600E-02  +1.72139700E-02  -7.68446000E-03  -6.09105000E-03  -1.70119000E-03
   -1.00713000E-03  +8.84710000E-04  +1.19814000E-03  +7.75357500E-02  -7.82838800E-02
   +5.43025710E-01  -6.28800000E-05  -1.86610000E-04  +6.03000000E-05  +4.74700000E-05
   -1.27630000E-04  -4.30000000E-05  +7.72400000E-05  +1.89820000E-04  -2.08300000E-05
   -1.86920000E-04  -4.50800000E-05  -2.38300000E-04  -5.35770000E-04  +7.76190000E-04
   -7.23200000E-04  -5.47500000E-05  +4.98220000E-04  +6.15200000E-05  -3.86400000E-05
   +1.67000000E-05  -3.23200000E-05  -2.24129000E-03  -1.85390000E-04  -9.89370000E-04
   -2.12060000E-04  +2.95300000E-05  -1.83000000E-04  +6.47864000E-03  +2.87343000E-03
   -6.30720000E-04  -5.76720000E-04  +2.26498000E-03  -3.34800000E-05  -2.66340000E-04
   +5.82760000E-04  +6.04410000E-04  +1.17273900E-02  +4.45566000E-03  +1.58960600E-02
   -9.17115100E-02  -2.61456900E-02  -3.20438000E-02  -2.23293500E-02  -4.45087500E-02
   -9.65987000E-03  -6.56000000E-06  -2.08200000E-05  +1.14790000E-04  -7.81804000E-02
   -1.11663560E-01  +1.44681800E-02  +2.17423070E-01  -4.05780000E-04  +1.62900000E-05
   +1.00340000E-04  +1.82180000E-04  +2.61300000E-05  -3.00890000E-04  +1.31210000E-04
   +5.54700000E-05  -4.01600000E-05  -9.80000000E-06  +2.03680000E-04  -1.09870000E-04
   -2.25660000E-04  -1.00030000E-04  -1.32920000E-04  +2.54500000E-04  +8.00500000E-05
   +1.96020000E-04  -9.14800000E-05  -3.33100000E-05  -4.86000000E-06  -1.98974000E-03
   +1.87791000E-03  -5.58800000E-05  +3.03070000E-04  -2.72000000E-05  -6.15800000E-05
   -3.01435000E-03  -9.12804000E-03  +1.08374600E-02  +6.08170000E-04  -1.61561000E-03
   -1.36337000E-03  +1.28248000E-03  -1.99317000E-03  +2.71660000E-04  -9.24003000E-03
   +7.28535000E-03  -1.83382400E-02  -1.49420800E-02  -1.38994870E-01  -4.55514400E-02
   -3.88341100E-02  -1.64925800E-02  -1.01888800E-02  +5.38000000E-06  +1.70660000E-04
   -1.07290000E-04  -1.07679140E-01  -5.08398380E-01  +1.00756440E-01  +1.81488000E-01
   +7.56765890E-01  +1.26180000E-04  -9.86400000E-05  +7.38300000E-05  -1.93320000E-04
   +8.11200000E-05  +1.50830000E-04  -1.73540000E-04  -1.33000000E-04  -7.86000000E-06
   +3.02900000E-05  -6.81900000E-05  -7.57100000E-05  -1.44330000E-04  +3.31580000E-04
   -5.99700000E-05  -2.13200000E-05  +2.13700000E-05  -1.23630000E-04  +4.31600000E-05
   -2.39000000E-06  +3.53000000E-06  +1.96067000E-03  +6.17580000E-04  -3.37185000E-03
   -1.29801000E-03  +3.64970000E-04  +3.14130000E-04  +2.09276000E-03  +3.00734300E-02
   -3.71359000E-03  -8.00930000E-04  -9.02070000E-04  -4.02460000E-04  +1.66010000E-04
   +1.88827000E-03  +1.10170000E-04  +9.99980000E-04  -3.30990000E-02  -2.74724300E-02
   -3.65571400E-02  -4.37252500E-02  -1.44773180E-01  +8.87488000E-03  +2.84481000E-03
   +1.79598600E-02  +6.65630000E-04  -7.32250000E-04  -6.14300000E-04  +1.60199700E-02
   +1.21060250E-01  -1.35673890E-01  +4.99999400E-02  -1.23428850E-01  +6.12301470E-01
   -9.05800000E-05  +1.41780000E-04  +1.17810000E-04  +4.78730000E-04  +4.97540000E-04
   +1.17050000E-04  -1.49300000E-04  -2.83520000E-04  -1.18800000E-04  +7.83100000E-05
   +9.27000000E-06  -3.81410000E-04  -7.35680000E-04  +6.04710000E-04  +9.91900000E-05
   -1.77460000E-04  +1.26260000E-04  +2.65900000E-05  -5.73230000E-04  -4.44440000E-04
   -6.12400000E-05  -8.07130000E-04  -1.94506000E-03  -1.04756000E-03  -4.38990000E-04
   +1.80380000E-04  +1.71420000E-04  +4.65565000E-03  -6.74420000E-04  -3.06171000E-03
   +5.42967000E-03  +4.11050400E-02  -1.37092600E-02  -1.14449710E-01  +7.02948600E-02
   -1.45308600E-02  -1.64352000E-02  -9.17921000E-03  +7.63842000E-03  +3.62239000E-03
   -2.62130000E-03  -9.22512000E-03  -3.14011000E-03  -5.60650000E-04  +3.31386000E-03
   +1.58020000E-04  -2.27080000E-04  -1.63690000E-04  +5.25440000E-04  +1.10699000E-03
   +1.22599000E-03  -6.28070000E-04  +4.25040000E-04  +9.37770000E-04  +1.10856370E-01
   +1.82210000E-04  +4.42500000E-05  -2.72820000E-04  -5.40540000E-04  -9.55270000E-04
   -3.77940000E-04  +3.58400000E-04  +8.16110000E-04  +1.91090000E-04  -9.17800000E-05
   +8.80500000E-05  +8.00950000E-04  +4.60790000E-04  -1.62579000E-03  -1.59050000E-04
   +3.52080000E-04  -7.90000000E-06  -3.17640000E-04  +9.65040000E-04  +1.04780000E-03
   +5.16900000E-05  +1.19448000E-03  +1.54201000E-03  -1.54388000E-03  +5.50870000E-04
   -1.96600000E-05  -2.83660000E-04  -1.36171600E-02  -4.40967000E-03  +1.35203600E-02
   +4.47152800E-02  -4.20473500E-02  +7.29232000E-03  +5.43819000E-02  -6.29390050E-01
   +2.30086840E-01  -2.38790900E-02  -3.15113000E-03  +1.22232500E-02  +6.49221000E-03
   -5.61017000E-03  -1.56807500E-02  -4.79252000E-03  +1.20060000E-04  +5.21882000E-03
   +8.07810000E-04  -1.30940000E-04  +9.35720000E-04  +2.04330000E-04  -6.88600000E-05
   +4.79370000E-04  -2.59570000E-04  +1.23025000E-03  -9.28170000E-04  -8.55658700E-02
   +7.10658860E-01  +2.51700000E-05  +3.88000000E-05  +6.40900000E-05  +1.66970000E-04
   +4.03930000E-04  +2.24800000E-04  -2.18130000E-04  -4.03800000E-04  -3.27200000E-05
   +1.52000000E-05  -5.46200000E-05  -3.84900000E-04  -4.64980000E-04  +8.75520000E-04
   +2.44550000E-04  -2.24480000E-04  +1.72000000E-06  +7.44700000E-05  -3.54500000E-04
   -3.78600000E-04  -1.50500000E-05  -1.51864000E-03  -1.93227000E-03  +6.19200000E-04
   +1.66430000E-04  -1.99900000E-04  +2.61940000E-04  +4.39513000E-03  +3.85621000E-03
   -1.00180100E-02  -2.10347100E-02  +1.25073800E-02  +2.86923800E-02  -5.52184000E-03
   +2.26709830E-01  -1.62318770E-01  +3.98622000E-03  +1.43429000E-03  +2.30724000E-03
   -2.44027000E-03  -7.64230000E-04  +1.05045000E-03  +8.61100000E-04  +4.95150000E-04
   -2.10020000E-04  -1.81270000E-04  -7.90000000E-06  -6.20870000E-04  +2.02065000E-03
   +2.45958000E-03  +2.36240000E-04  +1.47179000E-03  -2.24048000E-03  -6.26290000E-04
   +1.43805500E-02  -2.70172970E-01  +1.43655180E-01  +8.83370000E-04  -6.36910000E-04
   -2.40310000E-03  -8.69960000E-04  -3.05571800E-02  -2.85792300E-02  -4.18438000E-03
   -4.20946000E-03  +1.73877000E-03  +1.24989000E-03  -8.30880000E-04  -8.92020000E-04
   +5.05700000E-05  +2.93520000E-04  +5.04940000E-04  -6.73910000E-04  +9.35300000E-05
   -1.83010000E-04  -4.42613000E-02  +5.70270000E-02  +8.14040900E-02  -1.14900000E-04
   +1.89000000E-05  +7.87000000E-05  +3.79100000E-05  +9.73000000E-06  -5.19000000E-06
   -7.76500000E-05  +3.83000000E-06  +5.45600000E-05  +9.73700000E-05  -6.56000000E-06
   -2.56100000E-05  -1.49390000E-04  -4.00000000E-07  +2.88600000E-05  +3.05180000E-04
   +4.06000000E-05  -1.50210000E-04  -5.86270000E-04  -3.34840000E-04  +1.31040000E-04
   +5.72760000E-04  +2.12750000E-04  +1.51900000E-04  +4.30700000E-05  +2.09300000E-05
   -2.29500000E-05  +1.58300000E-05  +3.50000000E-06  +3.64400000E-05  +2.53700000E-05
   +6.70300000E-05  -5.58300000E-05  +1.29540000E-04  +3.49000000E-05  -3.07000000E-06
   +4.85292600E-02  +3.66784000E-03  +3.42188000E-03  +9.27110000E-04  +2.90801000E-03
   -2.58472700E-02  -2.38344700E-02  -4.59829000E-03  -8.16900000E-04  +1.35110000E-03
   +3.63090000E-04  +5.42870000E-04  -1.72650000E-03  -2.50300000E-05  +5.41960000E-04
   +6.34040000E-04  -1.09630000E-04  -8.97630000E-04  -7.59940000E-04  +2.05076600E-02
   -2.64266960E-01  -2.42346110E-01  -1.45910000E-04  -9.01700000E-05  +7.44400000E-05
   +7.30600000E-05  +1.16100000E-05  +2.09600000E-05  -1.67150000E-04  +1.09020000E-04
   +6.85400000E-05  +2.59420000E-04  -9.03800000E-05  -6.97700000E-05  -2.63090000E-04
   +2.10980000E-04  -4.58200000E-05  -8.64700000E-05  -1.38790000E-04  +1.45340000E-04
   +2.08880000E-04  +3.28820000E-04  -1.61750000E-04  -2.06930000E-04  -3.86380000E-04
   +4.29900000E-05  +7.47900000E-05  +9.85000000E-06  -2.29300000E-05  +2.94200000E-05
   -3.04300000E-05  -6.84500000E-05  -1.20000000E-05  -1.07200000E-05  -7.24000000E-06
   +7.13900000E-05  -2.06910000E-04  +7.07700000E-05  -2.18699700E-02  +2.87642710E-01
   +1.85149000E-03  +4.74406000E-03  +2.19539000E-03  -1.13315000E-03  +1.50950000E-04
   -2.01074000E-03  +6.14460000E-04  +5.40650000E-04  +2.45548000E-03  +2.15160000E-04
   -1.20430000E-03  +3.06890000E-04  +4.08390000E-04  +2.84130000E-04  +3.16200000E-05
   -2.19040000E-04  -2.09810000E-04  -9.02840000E-04  +5.13921400E-02  -2.68216590E-01
   -2.77331330E-01  -1.26260000E-04  -1.08400000E-04  -1.50690000E-04  +1.16650000E-04
   +9.03600000E-05  +6.52900000E-05  -8.39100000E-05  +5.48400000E-05  +1.33750000E-04
   +1.09920000E-04  -5.30000000E-05  -9.27800000E-05  -1.21200000E-04  +2.30400000E-05
   +3.23000000E-06  +2.16900000E-04  +2.02700000E-05  -3.22360000E-04  -5.01530000E-04
   -2.01850000E-04  +3.80760000E-04  +4.50440000E-04  +2.17850000E-04  -7.67000000E-05
   +3.38000000E-06  -7.77000000E-06  -2.62300000E-05  +2.07300000E-05  +1.33000000E-06
   +1.68200000E-05  +3.25300000E-05  +4.54700000E-05  -2.59600000E-05  +7.42200000E-05
   -1.74200000E-05  -2.08000000E-06  -5.33695600E-02  +2.64338220E-01  +2.75847030E-01
   -5.25498300E-02  -1.45038600E-02  +2.65141000E-03  +5.01572000E-03  +1.48285700E-02
   +1.57404900E-02  -1.26287000E-03  -1.83378000E-03  +4.79012000E-03  -1.39852000E-03
   -2.34700000E-04  +1.96390000E-04  -1.21203000E-03  -5.18755000E-03  +2.33038000E-03
   +2.91762000E-03  -1.66341800E-02  -1.90702600E-02  +8.45890000E-04  +2.60427000E-03
   -1.79718000E-03  +4.18180000E-04  -6.64980000E-04  -8.13360000E-04  +4.92000000E-06
   +8.48200000E-05  -1.22460000E-04  +2.24550000E-04  -8.42600000E-05  -3.48600000E-05
   -1.97630000E-04  +9.90200000E-05  +7.16200000E-05  +1.27540000E-04  -2.20920000E-04
   +4.72000000E-05  +1.84810000E-04  +1.28680000E-04  +2.73700000E-04  -8.91200000E-05
   -3.66920000E-04  -4.03010000E-04  +1.52630000E-04  +1.22630000E-04  +2.79960000E-04
   -3.56670000E-04  -1.37640000E-04  +6.69500000E-05  -2.39800000E-05  +2.00600000E-05
   +8.13700000E-05  -2.56500000E-05  +6.05300000E-05  -3.28000000E-06  +3.61300000E-05
   +2.17950000E-04  -5.13300000E-05  -5.12370000E-04  -1.03535000E-03  +1.72570000E-04
   +4.84314200E-02  -1.52171200E-02  -1.80191980E-01  -1.48239500E-01  -4.19993000E-03
   +8.13190000E-04  +1.55890000E-04  -1.39977000E-03  +3.23209000E-03  -1.12458000E-03
   -5.96900000E-05  -2.76770000E-04  +7.38640000E-04  -5.42702000E-03  +1.79298000E-03
   -1.11136000E-03  +1.46337000E-03  -1.04606000E-02  -1.56773700E-02  +2.56289000E-03
   +1.02684000E-03  +2.78259000E-03  +1.25060000E-04  -1.39050000E-04  -1.00250000E-03
   -4.38800000E-05  +1.33700000E-05  -5.52000000E-06  +3.16070000E-04  -1.18470000E-04
   -9.96300000E-05  -1.74850000E-04  +9.44500000E-05  +1.00320000E-04  +1.58670000E-04
   -9.16800000E-05  +1.36600000E-05  -7.50200000E-05  -9.31000000E-06  +1.09720000E-04
   +1.60670000E-04  +2.34000000E-05  -1.37830000E-04  -1.46410000E-04  +8.76000000E-06
   -4.46600000E-05  -2.96550000E-04  -1.76290000E-04  +1.18680000E-04  -1.92400000E-05
   +4.13000000E-06  +1.54700000E-05  -1.66300000E-05  -1.22400000E-05  +1.93600000E-05
   -6.57900000E-05  +7.68200000E-05  -2.29600000E-05  +5.47070000E-04  +7.52000000E-06
   -1.06819000E-03  +1.98521100E-02  +1.86209190E-01  +1.77274000E-03  -1.47321780E-01
   -1.99626000E-01  -4.62620000E-03  -1.82665600E-02  -1.13455300E-02  +5.25696000E-03
   -1.10071000E-03  -7.98500000E-04  +5.49000000E-04  +1.12346000E-03  -1.80730000E-04
   +1.89846000E-03  -1.74167000E-03  +3.86702000E-03  +6.90170000E-04  +9.56050000E-04
   +2.82502000E-03  -2.23316000E-03  +2.01344000E-03  +5.39050000E-04  +3.13180000E-04
   -9.98100000E-05  +1.51490000E-04  -4.89300000E-05  +3.66000000E-06  -6.14900000E-05
   +1.75100000E-05  -3.36900000E-05  +3.12100000E-05  -1.22670000E-04  +3.58700000E-05
   -1.42000000E-06  +1.07540000E-04  -1.61220000E-04  +4.60800000E-05  +2.81220000E-04
   +1.38910000E-04  -8.82800000E-05  -4.96860000E-04  -5.05940000E-04  -3.00700000E-05
   +4.81790000E-04  +2.82710000E-04  +2.82030000E-04  -5.48200000E-05  +2.70000000E-05
   -1.20000000E-07  -2.52000000E-06  +2.49700000E-05  +8.37400000E-05  +6.50000000E-06
   +7.33300000E-05  -4.00400000E-05  +3.70800000E-05  +1.73940000E-04  -5.74600000E-05
   +1.78146000E-03  +8.37540000E-04  -5.42830000E-04  -3.28366000E-03  +1.62282180E-01
   +2.06831420E-01  -1.25897500E-02  +2.41579000E-03  +1.84985300E-02  +3.52590000E-04
   -5.55596000E-03  +6.54360000E-04  -3.85740000E-04  -4.30600000E-05  -9.31620000E-04
   +2.65186000E-03  -2.26209000E-03  +6.88070000E-04  +5.03137000E-03  -8.44300000E-05
   -1.26230000E-03  -1.90337990E-01  +3.63020000E-03  +1.45632930E-01  -1.26084000E-03
   -1.92300000E-04  +8.76240000E-04  -1.36808000E-03  +7.48780000E-04  -7.71870000E-04
   -1.53680000E-04  -3.25460000E-04  +2.30780000E-04  -5.65890000E-04  -9.65140000E-04
   -8.34230000E-04  -4.34810000E-04  -4.85500000E-05  -1.34180000E-04  -3.36650000E-04
   +5.55800000E-05  -8.96000000E-06  -1.15660000E-04  +1.31000000E-05  +1.66900000E-05
   +1.10130000E-04  -1.48400000E-05  +4.31300000E-05  -1.40400000E-05  -5.97100000E-05
   +2.28000000E-05  +2.60100000E-05  +1.85060000E-04  -1.61610000E-04  -4.73600000E-05
   +1.61000000E-05  +2.04000000E-05  +2.31900000E-05  -1.02000000E-06  +1.11400000E-05
   +9.56600000E-05  -9.40200000E-05  +2.88100000E-05  +7.79400000E-05  +2.34350000E-04
   +1.13420000E-04  -5.46760000E-04  +1.61605000E-03  -1.68805000E-03  +1.99364880E-01
   -1.54233000E-02  +4.73974000E-03  +1.53515100E-02  -5.54024000E-03  +7.03100000E-04
   -3.11912000E-03  -7.05000000E-05  -1.23590000E-03  +1.62950000E-04  -2.63520000E-03
   -2.11670000E-04  -5.26116000E-03  +1.57787100E-02  +4.06547000E-03  -1.41632400E-02
   +4.46128000E-03  -5.20864000E-02  -2.09366400E-02  -8.68240000E-04  -2.43700000E-04
   +9.78760000E-04  +1.52964000E-03  -8.31220000E-04  +1.10693000E-03  -1.39070000E-04
   -7.65250000E-04  -4.29730000E-04  -1.55410000E-04  +2.13440000E-04  -3.08940000E-04
   -1.34110000E-04  -1.96700000E-04  -1.23050000E-04  -1.99850000E-04  +4.69950000E-04
   -8.90000000E-07  -2.52830000E-04  +7.46100000E-05  -9.29990000E-04  -3.80170000E-04
   +3.04860000E-04  +1.08505000E-03  +1.45360000E-04  -1.17100000E-05  -3.28780000E-04
   +1.07040000E-04  -1.07600000E-05  +1.14250000E-04  +6.38400000E-05  +3.94700000E-05
   -1.15950000E-04  +4.65200000E-05  -8.67400000E-05  +3.53300000E-05  -6.19600000E-05
   -4.70070000E-04  +6.99200000E-05  +6.12500000E-05  +1.59560000E-04  +4.65800000E-05
   +1.90104000E-03  -1.23353000E-03  +1.79516000E-03  +9.88170000E-04  +4.78985200E-02
   -1.37565000E-03  -1.32890000E-03  +3.93113000E-03  +1.24998000E-03  -2.94618000E-03
   +3.89067000E-03  -1.11748000E-03  +1.56260000E-04  -1.22040000E-04  +4.89800000E-04
   -5.94407000E-03  -8.38850000E-04  +1.72226100E-02  +6.77160000E-04  -1.16237500E-02
   +1.44569750E-01  -1.95299300E-02  -1.95002160E-01  +8.10400000E-05  +2.11560000E-04
   -7.13300000E-05  -1.72240000E-04  +1.88941000E-03  -1.06871000E-03  +4.35000000E-05
   +1.20780000E-04  -1.39040000E-04  -1.33360000E-04  -5.06350000E-04  -6.97870000E-04
   +2.19860000E-04  +3.13970000E-04  +5.76710000E-04  -4.51260000E-04  +3.48250000E-04
   +7.39000000E-05  +1.87040000E-04  -5.11540000E-04  +1.01740000E-03  +7.84630000E-04
   +1.50270000E-04  -1.28172000E-03  -4.92450000E-04  -1.78930000E-04  +2.76430000E-04
   -1.87850000E-04  +4.80300000E-05  -8.84000000E-06  -7.42100000E-05  +7.12500000E-05
   -9.04700000E-05  -5.26500000E-05  -5.18000000E-05  +9.41000000E-06  +1.84740000E-04
   -1.70240000E-04  +1.07340000E-04  -3.25100000E-05  -3.50200000E-05  -3.87000000E-06
   -1.52307000E-03  +2.01434000E-03  -8.76700000E-04  -1.60129530E-01  +2.43419200E-02
   +2.02252730E-01  -1.41922000E-03  -1.60110000E-04  +4.86000000E-05  -7.65360000E-04
   -5.34373000E-03  +2.48179000E-03  +2.82180000E-03  -1.67341200E-02  -1.89309000E-02
   -5.46689700E-02  -1.46342800E-02  -1.62996000E-03  +6.54830000E-03  +1.45549000E-02
   +1.49842600E-02  -1.37109000E-03  -1.85435000E-03  +5.33399000E-03  +9.13700000E-05
   -9.40350000E-04  -9.84840000E-04  -3.50840000E-04  +1.70302000E-03  -1.34964000E-03
   +4.28200000E-04  +1.31800000E-05  -1.28600000E-04  -2.90930000E-04  -1.93790000E-04
   +6.96600000E-05  +3.56700000E-05  -2.30200000E-05  -6.70300000E-05  -6.47000000E-06
   +7.66900000E-05  +3.54300000E-05  -2.21900000E-05  -4.17800000E-05  -1.59390000E-04
   +1.00700000E-04  +2.06190000E-04  +2.53190000E-04  -9.99100000E-05  -1.17650000E-04
   -8.85400000E-05  -2.61751000E-03  -1.82889000E-03  +1.03506000E-03  +1.01320000E-04
   -1.04010000E-04  +2.98500000E-05  +9.09400000E-05  -1.64400000E-05  -8.56200000E-05
   +1.42200000E-05  -3.84300000E-05  -2.10700000E-05  -3.42630000E-04  -1.66020000E-04
   -1.17830000E-04  -1.45870000E-04  +2.48750000E-04  -2.35090000E-04  +2.31640000E-04
   +7.50270000E-04  +9.45180000E-04  +5.53424300E-02  +1.12130000E-04  -3.73320000E-04
   +8.91910000E-04  -5.60125000E-03  +2.31811000E-03  -1.60092000E-03  -3.19000000E-06
   -9.65017000E-03  -1.65786700E-02  -1.41497100E-02  -1.73022600E-01  -1.47736200E-01
   -3.57480000E-04  +3.16615000E-03  -4.09530000E-04  -1.90354000E-03  +3.48946000E-03
   -1.72522000E-03  -1.01900000E-05  -8.55960000E-04  -8.11570000E-04  +1.20000000E-03
   -2.05895000E-03  +8.89170000E-04  -3.13560000E-04  -2.35590000E-04  +7.41600000E-05
   +1.89980000E-04  +4.64360000E-04  -2.54100000E-04  +2.74440000E-04  -1.72890000E-04
   -2.94100000E-05  -1.61670000E-04  +1.21470000E-04  -8.92600000E-05  -5.28800000E-05
   +1.75000000E-06  +1.39650000E-04  +3.91300000E-05  -6.18400000E-05  -2.15640000E-04
   -1.00100000E-05  +2.76300000E-05  +1.37660000E-04  -3.12036000E-03  -1.23124000E-03
   +3.53850000E-04  -4.21300000E-05  +1.11360000E-04  -2.69800000E-05  -7.86000000E-05
   -4.34200000E-05  +3.67600000E-05  +2.69400000E-05  -1.30590000E-04  +8.69900000E-05
   -1.20410000E-04  -2.19260000E-04  +4.59300000E-05  +2.45070000E-04  -3.23320000E-04
   +2.08670000E-04  -1.27990000E-04  +1.47170000E-04  +2.64700000E-05  +2.40504900E-02
   +1.81529290E-01  -1.09770000E-04  +9.44050000E-04  +5.56100000E-05  +2.49864000E-03
   -1.66546000E-03  +3.68387000E-03  +1.73737000E-03  +4.11970000E-04  +2.95892000E-03
   -1.66028000E-03  -1.47746740E-01  -2.14319990E-01  -2.45690000E-03  -1.52938600E-02
   -1.20720900E-02  +5.54034000E-03  -1.17973000E-03  -4.67620000E-04  -2.22830000E-04
   -2.50860000E-04  -1.04790000E-04  -2.26206000E-03  +2.20640000E-04  -1.38569000E-03
   +4.90530000E-04  +2.02590000E-04  +2.94200000E-05  -2.13900000E-04  -2.51740000E-04
   +1.38520000E-04  -1.53590000E-04  +1.51020000E-04  +4.32900000E-05  +5.75000000E-05
   -1.19590000E-04  +3.50300000E-05  +9.14000000E-05  +7.64000000E-06  +6.90800000E-05
   -1.39500000E-04  -8.75800000E-05  -1.25420000E-04  +1.12130000E-04  +4.95800000E-05
   +3.46500000E-05  -7.37970000E-04  -7.46960000E-04  +2.33950000E-04  +2.74700000E-05
   -2.91900000E-05  -1.61100000E-05  +5.82000000E-06  +3.14600000E-05  +2.53900000E-05
   +1.19100000E-05  +1.05860000E-04  -3.24900000E-05  -5.43900000E-05  +1.27650000E-04
   -2.99700000E-05  -2.65640000E-04  +1.61820000E-04  -2.41880000E-04  -1.57430000E-04
   -8.61440000E-04  -6.90010000E-04  +7.59050000E-04  +1.63417700E-01  +2.22092680E-01
   +2.24054000E-03  -2.15949000E-03  +9.63480000E-04  +4.31212000E-03  -2.54221000E-03
   -1.73382000E-03  -1.88322430E-01  -4.27639000E-03  +1.50097650E-01  -1.16326900E-02
   +2.40741000E-03  +1.72031100E-02  +2.68300000E-05  -5.54119000E-03  +5.82210000E-04
   -9.12400000E-05  +7.24900000E-05  -8.51590000E-04  -5.10050000E-04  +1.67602000E-03
   -1.17747000E-03  -1.28460000E-04  +2.59650000E-04  +8.53880000E-04  -2.39940000E-04
   -1.21950000E-04  -7.48800000E-05  +2.11800000E-05  -2.04440000E-04  +4.10800000E-05
   -1.02200000E-04  +9.30900000E-05  +7.42000000E-06  +7.58800000E-05  -7.82800000E-05
   +3.06900000E-05  +1.14700000E-04  +4.19000000E-05  -1.50500000E-04  -2.23360000E-04
   -1.59640000E-04  +1.63010000E-04  +2.10840000E-04  +9.09300000E-05  -1.14520000E-04
   -3.96300000E-05  +1.14310000E-04  +2.48100000E-05  -1.36400000E-05  -6.15000000E-06
   +4.62100000E-05  +2.08200000E-05  +6.26000000E-06  -1.84000000E-06  -1.02000000E-05
   +8.27400000E-05  -3.29900000E-05  -1.03110000E-04  +2.41700000E-04  -1.21790000E-04
   +1.21830000E-04  +7.56200000E-05  -2.77130000E-04  -2.17360000E-04  +2.66500000E-04
   -1.36890000E-04  -7.40980000E-04  +1.80982000E-03  -1.74314000E-03  +1.95287230E-01
   -2.26938000E-03  -6.75820000E-04  -4.98629000E-03  +1.54863300E-02  +5.54984000E-03
   -1.57433900E-02  -5.77704000E-03  -5.04337700E-02  -1.17734100E-02  -1.38503900E-02
   +4.13623000E-03  +1.59976700E-02  -5.27121000E-03  +7.85930000E-04  -2.54076000E-03
   -3.75760000E-04  -1.38743000E-03  -9.69400000E-05  +1.54477000E-03  -1.43470000E-04
   +2.31380000E-03  -7.87520000E-04  +3.55050000E-04  +4.46880000E-04  -7.79700000E-05
   +3.32200000E-05  -6.65300000E-05  +7.13200000E-05  -2.67280000E-04  -8.74600000E-05
   -1.93020000E-04  +1.00810000E-04  +1.48130000E-04  +1.78270000E-04  -5.86100000E-05
   +5.63400000E-05  -3.98700000E-05  -7.13000000E-06  +1.21860000E-04  +1.07700000E-04
   +3.77500000E-05  -1.49900000E-04  -1.14000000E-04  -3.86500000E-05  +9.21000000E-05
   +1.20010000E-04  +3.98800000E-05  +9.81000000E-05  +7.52000000E-06  -1.23200000E-05
   +1.49500000E-05  -2.69600000E-05  +9.38000000E-06  -1.01200000E-05  -4.94900000E-05
   +8.62100000E-05  -4.94000000E-05  +1.32740000E-04  -6.98700000E-05  +4.44870000E-04
   +8.82660000E-04  -6.44200000E-05  -7.17850000E-04  +2.28670000E-04  -2.19890000E-04
   +2.82330000E-04  +2.09752000E-03  -1.33985000E-03  +1.77505000E-03  +8.03199000E-03
   +4.36598100E-02  +3.39040000E-04  -5.22708000E-03  -7.86750000E-04  +1.93073000E-02
   +1.99154000E-03  -1.18598500E-02  +1.49495520E-01  -1.25496400E-02  -2.02135130E-01
   -2.89023000E-03  -7.37630000E-04  +4.59965000E-03  +8.39370000E-04  -2.41205000E-03
   +3.40036000E-03  -1.11296000E-03  -2.91850000E-04  -2.66540000E-04  -1.41018000E-03
   +2.13524000E-03  +3.37770000E-04  -1.86100000E-05  -1.50990000E-04  +2.61300000E-04
   -2.33900000E-05  -7.11500000E-05  +1.14000000E-06  -2.64200000E-05  +5.29100000E-05
   +5.00700000E-05  +8.77000000E-05  -2.43100000E-05  -5.35400000E-05  -9.32100000E-05
   +2.57600000E-05  -1.58100000E-05  +2.77700000E-05  +2.47000000E-06  -1.71600000E-05
   -5.81900000E-05  -1.88900000E-05  +1.50100000E-05  +5.42400000E-05  -1.82400000E-05
   +9.78000000E-06  -9.79000000E-06  +4.40800000E-05  -4.93100000E-05  +2.92000000E-06
   -3.92000000E-06  +1.80000000E-07  +1.13500000E-05  +8.98000000E-06  -6.93000000E-06
   +3.67200000E-05  -3.02500000E-05  +1.87700000E-05  -1.68560000E-04  +3.99250000E-04
   +1.15030000E-04  +6.97210000E-04  +1.09250000E-04  -7.76660000E-04  -1.34510000E-04
   +2.66220000E-04  -2.24010000E-04  -1.33204000E-03  +2.07666000E-03  -6.86020000E-04
   -1.63625380E-01  +1.44700200E-02  +2.08055980E-01  -1.50760000E-04  +3.04700000E-05
   -3.61900000E-05  -1.57100000E-05  -1.90300000E-05  -8.63400000E-05  +2.93800000E-05
   +3.97000000E-05  -8.02500000E-05  +2.27070000E-04  +2.20180000E-04  +8.03900000E-05
   +8.18750000E-04  -1.09436000E-03  +6.93300000E-05  +2.50310000E-04  +1.59060000E-04
   +1.72680000E-04  +3.91300000E-05  -6.40000000E-07  +1.96300000E-05  -2.15204000E-03
   +1.75270000E-04  +5.48980000E-04  -2.48518080E-01  +1.20290720E-01  +6.64560000E-03
   +4.20880000E-04  -2.20640000E-04  +2.97880000E-04  -6.27700000E-05  +1.08820000E-04
   +2.25680000E-04  +4.28120000E-04  -1.61630000E-04  -1.54420000E-04  +8.73800000E-05
   +6.62900000E-05  -5.76600000E-05  -1.45550000E-04  -7.09700000E-05  +7.74300000E-05
   +9.48600000E-05  +7.57000000E-05  -2.39800000E-05  -3.76000000E-06  -2.34180000E-04
   +6.03630000E-04  +1.40210000E-04  +3.88200000E-05  +1.88480000E-04  +3.66100000E-05
   -3.63100000E-05  -1.03860000E-04  -1.74920000E-04  +3.50130000E-04  -5.95000000E-05
   -1.18000000E-05  -1.80000000E-06  -3.22000000E-06  -1.84000000E-06  +9.18000000E-06
   -9.90000000E-07  +5.23900000E-05  -6.51500000E-05  +8.49000000E-06  +2.92700000E-05
   -1.41000000E-06  -4.60000000E-07  +1.52100000E-05  +1.53600000E-05  +1.16000000E-06
   +2.66252420E-01  -1.95300000E-05  +2.44200000E-05  -1.26600000E-05  -1.68840000E-04
   -1.91530000E-04  +2.68000000E-05  -5.78800000E-05  +3.94500000E-05  +1.10990000E-04
   -3.65850000E-04  +3.33500000E-05  +9.64300000E-05  +9.88610000E-04  +7.39070000E-04
   -3.05750000E-04  -8.42900000E-05  -3.21170000E-04  -5.88900000E-04  +1.77000000E-04
   +1.94540000E-04  +1.54500000E-05  +1.60020400E-02  -1.18267900E-02  -8.52500000E-05
   +1.18621130E-01  -1.17047680E-01  -4.67168000E-03  -3.27580000E-04  -1.43120000E-03
   +3.44450000E-03  +1.00700000E-04  +2.18260000E-04  +3.15070000E-04  -2.61280000E-04
   +3.44690000E-04  -4.60000000E-07  -1.30130000E-04  -8.71300000E-05  -5.90500000E-05
   +4.07200000E-04  +2.80740000E-04  +9.89400000E-05  -2.60370000E-04  -1.69400000E-04
   -4.86100000E-05  -3.09550000E-04  +3.52370000E-04  -1.32800000E-03  +8.35640000E-04
   -3.84120000E-04  -4.77780000E-04  +4.63600000E-05  -5.88000000E-05  +2.56290000E-04
   +3.56400000E-05  -1.91560000E-04  +3.74600000E-05  -7.20000000E-07  -3.44200000E-05
   -9.70000000E-06  +1.84300000E-05  -6.20000000E-06  +1.53800000E-05  +3.54400000E-05
   +9.18000000E-05  +1.80560000E-04  +2.03200000E-05  -9.58000000E-06  +3.63700000E-05
   +8.74000000E-06  -9.32000000E-06  +1.17000000E-06  -1.30755660E-01  +1.25938080E-01
   -3.91890000E-04  -1.48500000E-05  +1.24320000E-04  +1.57120000E-04  +4.27300000E-05
   -1.84170000E-04  +1.07490000E-04  +6.13200000E-05  -4.83600000E-05  +1.84700000E-05
   -1.43620000E-04  +1.12150000E-04  -7.68960000E-04  -5.76080000E-04  +6.92350000E-04
   +3.72620000E-04  +4.51600000E-05  -1.20380000E-04  -1.76340000E-04  -1.66280000E-04
   +8.34000000E-06  -2.31695400E-02  +1.46626100E-02  -1.67295000E-03  +8.50858000E-03
   -5.81958000E-03  -4.55619400E-02  +5.32260000E-04  +2.46892000E-03  -5.03442000E-03
   +6.74510000E-04  +8.11500000E-05  -3.17580000E-04  -2.36500000E-05  -3.67800000E-05
   +3.72610000E-04  +2.11900000E-05  +3.95300000E-05  +1.82780000E-04  -2.23020000E-04
   -2.29140000E-04  -2.35900000E-04  +1.28340000E-04  +1.23980000E-04  +7.88300000E-05
   -1.33092000E-03  +8.62010000E-04  +1.00896000E-03  -1.08277000E-03  +1.13556000E-03
   +6.78540000E-04  -7.93000000E-05  +5.84400000E-05  -3.63880000E-04  +2.25200000E-05
   -1.70520000E-04  -6.93800000E-05  +1.12400000E-05  +1.82600000E-05  +1.73600000E-05
   +9.67000000E-06  -1.66400000E-05  -4.50000000E-06  +3.98700000E-05  -5.04000000E-06
   +9.96200000E-05  +2.57600000E-05  +1.56500000E-05  -7.44000000E-05  -9.13000000E-06
   +9.28000000E-06  +5.83000000E-06  -8.21369000E-03  +2.14952000E-03  +5.21119400E-02
   -1.86010000E-04  -1.70000000E-05  +7.19400000E-05  +2.61620000E-04  +2.21570000E-04
   -4.08800000E-05  -5.38000000E-05  -8.75700000E-05  -8.01200000E-05  +5.30990000E-04
   -7.86200000E-05  -2.24430000E-04  +7.11020000E-04  -4.75220000E-04  +3.87230000E-04
   +2.73110000E-04  +3.26650000E-04  +4.23460000E-04  -2.76910000E-04  -2.47540000E-04
   -9.12000000E-06  +7.61260000E-04  +2.19817000E-03  -2.71980000E-04  -1.99778110E-01
   -1.30707820E-01  +5.35252000E-03  +1.06810000E-04  +2.52040000E-04  +3.17880000E-04
   -6.65300000E-05  +8.63380000E-04  +1.06500000E-04  -6.18400000E-05  +1.32380000E-04
   -1.51750000E-04  +6.74900000E-05  -1.17300000E-05  -3.25000000E-06  -1.24090000E-04
   -1.98400000E-05  -8.29000000E-06  +9.86800000E-05  +6.02000000E-06  +1.89000000E-05
   +1.87800000E-04  +2.43950000E-04  -2.17240000E-04  +7.99700000E-05  -2.59620000E-04
   -1.52000000E-04  +3.29600000E-05  +1.57900000E-05  +6.31000000E-05  -3.16000000E-06
   -7.60000000E-07  +4.74800000E-05  +2.23500000E-05  +4.03800000E-05  +2.19500000E-05
   -2.65200000E-05  -1.47500000E-05  -1.67200000E-05  -2.38200000E-05  -8.34000000E-06
   -2.98000000E-05  -3.84500000E-05  +4.69400000E-05  +3.33400000E-05  -2.13500000E-05
   -4.16000000E-06  +5.40000000E-07  -1.89583500E-02  -1.88380200E-02  +2.07840000E-04
   +2.16340460E-01  +1.90240000E-04  +1.28520000E-04  +7.46700000E-05  +1.65550000E-04
   +4.29340000E-04  +4.09050000E-04  -5.59210000E-04  -3.18940000E-04  -2.26710000E-04
   +4.20680000E-04  -5.52710000E-04  -3.47570000E-04  +1.62910000E-04  -1.35219000E-03
   +3.57216000E-03  -2.64400000E-04  -5.02900000E-05  +3.00200000E-04  -4.15650000E-04
   -3.52140000E-04  -7.25600000E-05  -1.38315100E-02  -1.21550300E-02  -8.40870000E-04
   -1.29560120E-01  -1.59233570E-01  +4.55263000E-03  -1.30012000E-03  +3.07610000E-04
   +1.63600000E-04  +2.66210000E-04  -1.56220000E-04  +2.49220000E-04  +3.26480000E-04
   -1.38770000E-04  -3.19660000E-04  +2.16590000E-04  +7.39400000E-05  -7.96600000E-05
   -3.64260000E-04  -1.63500000E-04  +4.01300000E-05  +2.74460000E-04  +9.79100000E-05
   +1.50200000E-05  +5.06500000E-05  +3.95380000E-04  -1.26381000E-03  +1.95900000E-04
   +2.55300000E-05  +5.09200000E-05  -1.61200000E-05  +6.64800000E-05  -7.92300000E-05
   -1.38920000E-04  +5.08350000E-04  -4.52400000E-05  +3.06900000E-05  +4.16600000E-05
   +3.87000000E-05  -1.97400000E-05  -4.36100000E-05  -2.09300000E-05  -9.90500000E-05
   +2.55500000E-04  -6.86300000E-05  +4.91600000E-05  -4.55000000E-06  +1.21150000E-04
   -1.01060000E-04  +1.87000000E-06  -3.87400000E-05  +1.27752800E-02  +1.21271500E-02
   -5.17660000E-04  +1.42995110E-01  +1.71747160E-01  +5.64160000E-04  +3.04700000E-05
   +4.97100000E-05  -3.56410000E-04  -1.69600000E-04  +1.23400000E-04  +2.70930000E-04
   -1.37540000E-04  +2.24560000E-04  +4.07980000E-04  +7.36320000E-04  +2.28640000E-04
   -1.08886000E-03  +2.15595000E-03  -4.06905000E-03  +7.34700000E-05  -5.69530000E-04
   -1.12150000E-04  +3.72090000E-04  +3.78410000E-04  +1.78100000E-05  +2.08570400E-02
   +1.67127800E-02  -1.48446000E-03  +4.92914000E-03  +3.34217000E-03  -4.90536200E-02
   +5.10170000E-04  -5.52040000E-04  +4.52420000E-04  -2.66080000E-04  -1.18150000E-04
   +5.15760000E-04  -1.19110000E-04  +6.54300000E-05  -6.50200000E-05  -6.30500000E-05
   -2.03600000E-05  +2.80000000E-05  +1.40950000E-04  +6.14000000E-05  +7.53000000E-06
   -1.04400000E-04  -3.47800000E-05  -1.35700000E-05  +1.02363000E-03  +9.15300000E-04
   +1.22300000E-03  -1.56500000E-05  -2.90120000E-04  -1.17720000E-04  +4.27300000E-05
   -2.92000000E-05  +3.77900000E-05  +1.80200000E-05  -1.62500000E-05  +4.65100000E-05
   -6.54000000E-06  -1.88200000E-05  -5.35200000E-05  +3.49900000E-05  +2.45600000E-05
   +1.76500000E-05  -3.27440000E-04  +3.69400000E-04  +4.22200000E-05  -6.76300000E-05
   +1.06950000E-04  -1.31960000E-04  +7.42500000E-05  +3.64000000E-05  -5.90000000E-07
   +1.01241000E-03  +8.29960000E-04  -1.05242000E-03  -6.15128000E-03  -6.99187000E-03
   +5.14050200E-02  -2.26620000E-04  -5.82400000E-05  -4.20900000E-05  -2.22700000E-05
   -1.00350000E-04  -5.69300000E-05  +1.07060000E-04  +5.39100000E-05  +2.60500000E-05
   -1.16690000E-04  -1.05690000E-04  +4.20300000E-05  -4.02300000E-05  +6.44990000E-04
   +5.67440000E-04  -1.85530000E-04  -2.62270000E-04  +8.48100000E-05  +4.51600000E-05
   +4.38500000E-05  -1.22300000E-05  -2.04864000E-03  -1.34451000E-03  -1.47030000E-03
   -4.66985900E-02  -4.28770000E-04  +1.39620000E-04  +5.04310000E-04  -4.22570000E-04
   -3.80860000E-04  -7.22510000E-04  +4.46460000E-04  -5.19500000E-04  -1.57840000E-04
   +1.79040000E-04  +1.58850000E-04  -1.21210000E-04  -5.58800000E-05  +5.73100000E-05
   +2.18920000E-04  +1.16930000E-04  -3.86200000E-05  -1.63970000E-04  -8.08000000E-05
   -2.68000000E-06  -1.35520000E-04  +2.94640000E-04  -1.35590000E-04  +2.39500000E-05
   +6.80000000E-05  +7.23000000E-06  -1.14100000E-05  -4.40100000E-05  +5.21100000E-05
   +7.44200000E-05  -2.97820000E-04  +2.43500000E-05  -7.03000000E-06  -2.36300000E-05
   +1.10800000E-05  +2.13200000E-05  -1.45300000E-05  +1.59300000E-05  +2.98300000E-04
   -4.08810000E-04  +1.38520000E-04  +2.23100000E-05  +9.50000000E-06  -5.03900000E-05
   -3.44000000E-06  +4.45000000E-06  -8.56000000E-06  +6.68240000E-04  +1.51808200E-02
   +2.40371100E-02  +5.02900000E-04  -1.26762900E-02  -2.11982700E-02  +4.94029800E-02
   +6.75400000E-05  -1.37750000E-04  -1.49690000E-04  -5.39000000E-05  -5.07000000E-05
   -1.21770000E-04  +1.19530000E-04  +9.51400000E-05  +9.30600000E-05  -1.63310000E-04
   +1.09000000E-05  -5.76300000E-05  +3.01020000E-04  +1.02039000E-03  -2.26110000E-04
   -5.49530000E-04  -5.85860000E-04  +8.90020000E-04  +1.42430000E-04  +1.05180000E-04
   -1.77000000E-06  -7.39570000E-04  +1.10253000E-02  +1.56901400E-02  -5.95060000E-04
   -1.30451210E-01  -1.25771650E-01  +2.07300000E-04  +6.77850000E-04  -4.73820000E-04
   +1.20541000E-03  +6.77000000E-06  -1.50910000E-04  -5.62600000E-05  -3.60000000E-06
   +2.56250000E-04  -5.04000000E-05  +1.08100000E-05  -2.03200000E-05  +2.30200000E-05
   +1.53700000E-05  +3.37000000E-05  -3.44800000E-05  +5.28000000E-06  -1.68200000E-05
   +1.78550000E-04  -1.86466000E-03  +2.60634000E-03  -2.94140000E-04  +1.11500000E-05
   -4.98200000E-05  +8.49000000E-06  -3.49000000E-06  -7.32000000E-06  -1.92000000E-06
   -1.52560000E-04  -7.50900000E-05  -1.89200000E-05  -1.84600000E-05  -1.28900000E-05
   +7.66000000E-06  -6.42000000E-06  +2.77500000E-05  -3.30850000E-04  -1.61793000E-03
   +3.55190000E-04  +4.11000000E-05  -9.33000000E-06  -7.94000000E-06  +1.31200000E-05
   -1.94000000E-06  +6.30000000E-07  -1.19329000E-03  -9.12478000E-03  -1.30938000E-02
   +2.03649000E-03  -1.08560100E-02  -1.62294600E-02  -1.18264000E-03  +1.41359880E-01
   +4.47280000E-04  +3.54650000E-04  +2.98860000E-04  -1.99440000E-04  +2.35340000E-04
   +3.91900000E-04  -3.66880000E-04  -3.39090000E-04  -6.26300000E-05  +6.67990000E-04
   +9.19100000E-05  -2.32720000E-04  -1.34785000E-03  -9.53830000E-04  +6.26560000E-04
   +2.01350000E-04  -8.19320000E-04  -2.00330000E-04  -8.98800000E-05  -2.79400000E-05
   -2.58000000E-06  +5.82960000E-04  -1.55300400E-02  -2.05824500E-02  +8.93410000E-04
   -1.23097200E-01  -2.35465600E-01  +1.25436000E-03  -9.30230000E-04  +1.57440000E-04
   +3.26150000E-04  +2.65080000E-04  +4.85430000E-04  -2.74770000E-04  +8.50000000E-05
   +4.64790000E-04  -2.91600000E-05  -1.28000000E-05  +1.76840000E-04  +1.03600000E-05
   -1.10500000E-04  -2.54480000E-04  +3.10500000E-05  +3.41000000E-05  +9.48700000E-05
   -1.20860000E-04  +4.69141000E-03  -4.34156000E-03  -3.05500000E-05  +2.17950000E-04
   +8.41000000E-05  -2.34800000E-05  +7.67000000E-06  +3.67300000E-05  +1.04920000E-04
   -3.01210000E-04  -5.14100000E-05  +2.69500000E-05  +2.14000000E-05  -2.99000000E-06
   +3.80100000E-05  -5.27000000E-06  -4.26000000E-06  -3.24470000E-04  +5.66400000E-04
   +4.65850000E-04  -1.39820000E-04  -9.10000000E-07  +1.03440000E-04  -8.92000000E-06
   +1.70700000E-05  -1.64000000E-05  -1.36200000E-04  +1.16020000E-04  -2.24700000E-04
   -4.27000000E-05  +1.78729000E-03  +2.15769000E-03  -6.81160000E-04  +1.34783550E-01
   +2.56365380E-01  +9.34000000E-05  +9.14600000E-05  +4.76000000E-05  -4.64400000E-05
   -6.25700000E-05  +2.22500000E-05  -9.12600000E-05  +7.09900000E-05  +2.77230000E-04
   -1.97610000E-04  -4.93650000E-04  -9.68090000E-04  +1.41890000E-04  +3.64020000E-04
   -2.40430000E-04  -1.02560000E-04  -1.56900000E-05  +2.13300000E-05  +9.12900000E-05
   +1.36080000E-04  +3.81300000E-05  -1.85674000E-03  +1.44270000E-04  +2.00610000E-04
   -1.43650000E-04  -1.00760000E-04  -3.82750000E-04  +7.38900000E-05  -5.78520000E-04
   +4.83300000E-04  -1.27000000E-06  +1.11120000E-04  -8.44400000E-05  +2.60000000E-07
   -2.84200000E-05  +5.18000000E-05  -5.17600000E-05  -7.22800000E-05  -1.74060000E-04
   +2.92290000E-04  +3.35890000E-04  +3.27320000E-04  -2.86910000E-04  -2.30930000E-04
   -8.92200000E-05  -4.72488200E-02  -3.26470000E-03  +5.95850000E-03  -5.58290000E-04
   +1.15391000E-03  +6.07460000E-04  -1.10940000E-04  -1.73190000E-04  -2.95530000E-04
   +9.27000000E-06  +3.77200000E-05  -6.04000000E-05  -2.11000000E-06  -1.51800000E-05
   +1.10000000E-06  +1.35300000E-05  +1.00200000E-05  +1.85800000E-05  -5.69000000E-06
   +4.24200000E-05  +5.35500000E-05  -2.58016000E-03  -8.97050000E-04  -4.87220000E-04
   -1.45800000E-05  -5.57000000E-06  -2.31600000E-05  +3.29450000E-04  -2.83180000E-04
   +2.71140000E-04  +1.30240000E-04  +2.91950000E-04  -2.25040000E-04  +6.59300000E-04
   +6.93200000E-05  -8.62200000E-05  +5.14351000E-02  +1.56480000E-04  +8.81400000E-05
   -3.06700000E-05  -1.45890000E-04  -1.60500000E-05  +2.12610000E-04  -1.43100000E-05
   -2.45030000E-04  -2.04440000E-04  -9.00820000E-04  +1.08060000E-04  +2.32420000E-04
   +6.94700000E-05  +8.86890000E-04  +5.30490000E-04  +2.06760000E-04  -1.06240000E-04
   -8.25700000E-05  +7.26600000E-05  +2.89200000E-05  -3.56000000E-05  +2.89520000E-04
   +1.20134500E-02  -1.75247100E-02  +7.53700000E-05  -2.40182000E-03  -2.56594000E-03
   -2.46700000E-05  +8.02830000E-04  +5.96790000E-04  -2.63800000E-05  +7.13300000E-05
   +3.77000000E-06  +1.68100000E-05  -8.23500000E-05  +1.80000000E-07  +5.33000000E-06
   +4.38800000E-05  +1.16820000E-04  -2.31000000E-04  -5.45500000E-05  -6.98100000E-05
   +1.49300000E-05  +1.06200000E-05  +2.30200000E-05  -3.01159000E-03  -1.17264590E-01
   +1.19357040E-01  +1.77819000E-03  -1.32395000E-03  -2.26940000E-04  -5.92200000E-05
   -1.55070000E-04  -3.24600000E-05  -1.59000000E-05  +2.20700000E-05  +4.46000000E-06
   -1.57700000E-05  -1.24000000E-05  -7.95000000E-06  +8.95000000E-06  +1.88200000E-05
   -9.77000000E-06  -2.22900000E-05  +4.00000000E-05  -1.99700000E-05  -1.17164000E-03
   -5.44490000E-04  -5.24050000E-04  -2.09200000E-05  +3.60500000E-05  -1.93800000E-05
   -2.60180000E-04  -3.30500000E-05  -1.35330000E-04  +2.66710000E-04  +2.21100000E-05
   -1.59910000E-04  -4.83900000E-05  +7.73250000E-04  -1.13902000E-03  +2.49821000E-03
   +1.27016860E-01  +1.40000000E-04  +1.33240000E-04  +5.63000000E-05  -5.33400000E-05
   +1.42680000E-04  +6.23600000E-05  -2.71650000E-04  -5.30800000E-05  +3.81160000E-04
   +6.33710000E-04  -2.57980000E-04  -2.32690000E-04  +7.78040000E-04  +9.62580000E-04
   +6.70380000E-04  +1.07200000E-05  -3.50380000E-04  +2.20000000E-05  -1.13700000E-05
   +2.02900000E-05  +4.43300000E-05  +2.35310000E-04  +1.39737800E-02  -1.99730900E-02
   +2.67790000E-04  -4.81348000E-03  -3.83194000E-03  -4.68500000E-04  +7.84490000E-04
   -2.89150000E-04  +3.03030000E-04  -8.76000000E-05  -2.70000000E-07  -1.63650000E-04
   +3.46320000E-04  -5.49000000E-05  -1.42090000E-04  +4.48000000E-05  +3.78350000E-04
   +1.50800000E-04  -5.26480000E-04  -6.86380000E-04  +1.40110000E-04  +3.38930000E-04
   +1.70060000E-04  +5.89266000E-03  +1.16690760E-01  -2.50851300E-01  -6.48760000E-04
   +2.99790000E-04  -5.07180000E-04  -2.18290000E-04  +1.05670000E-04  +6.82470000E-04
   -1.83100000E-05  -3.22640000E-04  +1.72360000E-04  -5.43000000E-06  +7.54000000E-06
   -7.12000000E-06  -3.06400000E-05  +1.74100000E-05  -2.63600000E-05  -2.70100000E-05
   +1.30810000E-04  +5.49800000E-05  -5.84410000E-04  +2.48990000E-04  +5.77830000E-04
   -1.23900000E-05  -3.85600000E-05  -3.49000000E-06  +2.04300000E-05  -1.08950000E-04
   +3.13330000E-04  +6.77400000E-05  -6.82500000E-05  +3.27830000E-04  -6.00900000E-05
   +9.65550000E-04  -1.48913000E-03  -6.10777000E-03  -1.28214440E-01  +2.72571470E-01
   -1.27700000E-04  -5.28900000E-05  -7.65100000E-05  +1.10270000E-04  +8.75500000E-05
   -4.10300000E-05  +2.08750000E-04  -1.20110000E-04  -2.18230000E-04  -1.77050000E-04
   +8.97200000E-05  +5.16010000E-04  +6.48100000E-04  +2.06020000E-04  +4.08590000E-04
   +2.32960000E-04  +1.25480000E-04  +2.79910000E-04  -1.54470000E-04  -1.68110000E-04
   -4.17100000E-05  +2.25310000E-04  +1.54953000E-03  +8.13120000E-04  -9.62300000E-05
   +1.78700000E-04  +2.07010000E-04  +4.97520000E-04  +8.40100000E-04  -4.37100000E-05
   +5.22390000E-04  -3.25990000E-04  -1.64230000E-04  -2.14250000E-04  +5.25200000E-05
   -1.26930000E-04  +5.29600000E-05  +2.70000000E-07  +2.90000000E-06  -1.65280000E-04
   -3.16000000E-06  +2.91000000E-06  +8.29900000E-05  -9.98000000E-06  +1.28000000E-05
   -2.29534160E-01  -1.24845120E-01  +4.56413000E-03  +2.13920000E-04  -1.70340000E-04
   +5.59600000E-05  +5.47100000E-05  +6.01800000E-05  +1.27900000E-05  +7.85300000E-05
   -7.58100000E-05  +7.20100000E-05  +1.14500000E-05  +2.56600000E-05  +5.67000000E-06
   -2.86700000E-05  +5.30000000E-06  -2.23700000E-05  +7.15300000E-05  -4.64600000E-05
   -5.47600000E-05  +4.86300000E-05  -1.09640000E-04  -5.80860000E-04  -1.03000000E-06
   -1.52000000E-06  +1.68000000E-05  -2.05200000E-05  -1.32620000E-04  +6.38400000E-05
   +2.76320000E-04  +1.90910000E-04  -4.69980000E-04  +2.50600000E-04  +2.33310000E-04
   -6.63200000E-05  +2.33510000E-04  +1.27583000E-03  -2.17000000E-05  +2.46228530E-01
   -1.56800000E-05  -2.72800000E-04  -2.47070000E-04  +2.35330000E-04  +1.16400000E-04
   -5.44300000E-05  -8.78400000E-05  +5.90600000E-05  -1.60600000E-05  +3.52620000E-04
   +2.01060000E-04  -4.30610000E-04  +1.29316000E-03  -1.49818000E-03  -3.61924000E-03
   -1.22610000E-03  -3.43750000E-04  +3.22620000E-04  -2.16410000E-04  -1.87460000E-04
   +9.34000000E-06  -1.62550700E-02  -1.33321600E-02  +6.10150000E-04  +2.77130000E-04
   +3.15990000E-04  +1.21774000E-03  -1.53782000E-03  -8.10000000E-06  +2.73580000E-04
   +2.62700000E-04  +2.91200000E-04  -3.60000000E-06  +1.81340000E-04  -3.25760000E-04
   -8.80300000E-05  +1.44990000E-04  +5.84600000E-05  -3.11000000E-05  -2.68590000E-04
   -9.20300000E-05  -5.04300000E-05  +2.39010000E-04  +1.05690000E-04  +2.42800000E-05
   -1.24114960E-01  -1.32170630E-01  +4.37569000E-03  -1.20670000E-04  -2.04980000E-04
   -2.60030000E-04  +1.38430000E-04  +1.70090000E-04  +1.79570000E-04  -7.13000000E-06
   +2.05320000E-04  -4.47400000E-05  +2.56200000E-05  +3.50900000E-05  +1.28500000E-05
   -7.65900000E-05  -1.17420000E-04  +1.40800000E-05  +2.80600000E-05  +2.71900000E-05
   -6.69500000E-05  +2.16110000E-04  -9.33400000E-05  +1.90320000E-04  -4.53700000E-05
   +7.10000000E-07  -7.08000000E-06  +1.30470000E-04  +4.63900000E-05  -3.67300000E-05
   +1.03860000E-04  +6.25680000E-04  -2.17290000E-04  +2.90210000E-04  +4.21000000E-06
   +6.18000000E-05  -1.29873300E-02  -8.93877000E-03  -7.04150000E-04  +1.36801640E-01
   +1.43211980E-01  +5.69100000E-05  -1.84930000E-04  -3.00410000E-04  +1.36980000E-04
   +1.08500000E-04  -5.32400000E-05  -1.66480000E-04  +2.66500000E-05  +3.28640000E-04
   +9.01250000E-04  -1.17080000E-04  -6.89590000E-04  +1.53536000E-03  -2.41703000E-03
   -4.36974000E-03  -1.33922000E-03  -9.52940000E-04  +4.98740000E-04  -1.13900000E-04
   -4.44800000E-05  +4.67100000E-05  -2.16253600E-02  -1.47477200E-02  -6.89020000E-04
   -1.14319000E-03  -8.49810000E-04  +1.19350000E-03  -9.29300000E-04  +2.57230000E-04
   +1.11053000E-03  +6.96900000E-05  +3.21080000E-04  -6.56900000E-05  +1.18010000E-04
   -2.65120000E-04  -5.59900000E-05  +5.14300000E-05  +2.77800000E-05  -1.44200000E-05
   -8.68300000E-05  -4.13700000E-05  +2.06400000E-05  +2.63200000E-05  +1.32500000E-05
   +2.05000000E-06  +5.93873000E-03  +5.35212000E-03  -4.77047700E-02  +2.00660000E-04
   +7.53000000E-06  +7.98000000E-06  -7.64300000E-05  -7.11800000E-05  -4.96900000E-05
   -4.29700000E-05  +1.64440000E-04  -4.23400000E-05  +1.87500000E-05  +2.17400000E-05
   +3.63000000E-06  -1.23410000E-04  -7.20100000E-05  -2.39500000E-05  +3.38900000E-05
   +2.43200000E-05  +1.13200000E-05  -8.23700000E-05  +5.87130000E-04  +3.79300000E-04
   -1.95900000E-05  -3.19100000E-05  +4.17000000E-06  +3.19400000E-05  +2.04200000E-05
   -6.59800000E-05  +3.36290000E-04  +2.89620000E-04  -7.11230000E-04  +2.80740000E-04
   +1.82740000E-04  +2.42180000E-04  +2.39018500E-02  +1.45597000E-02  +7.88030000E-04
   -6.18834000E-03  -1.13298000E-03  +5.12450300E-02  +6.38500000E-05  +4.46200000E-05
   -4.31900000E-05  -1.53560000E-04  -1.44600000E-05  +1.33800000E-05  +5.91500000E-05
   -3.22500000E-05  -1.44750000E-04  -2.93770000E-04  -6.25930000E-04  +4.93930000E-04
   +2.87910000E-04  -1.77550000E-04  +1.31370000E-04  +1.02020000E-04  +9.88000000E-06
   -3.46400000E-05  +1.00390000E-04  +6.08800000E-05  -4.92000000E-06  -7.14000000E-06
   -5.83050000E-04  -1.88130000E-04  +2.21800000E-04  -3.70630000E-04  -5.31460000E-04
   +3.26930000E-04  -1.51400000E-05  +1.97310000E-04  +2.33460000E-04  +2.95180000E-04
   -5.88200000E-05  +2.44850000E-04  -2.31100000E-04  +2.29700000E-05  +4.96100000E-05
   +7.10100000E-05  +2.14900000E-05  -1.68280000E-04  -1.39160000E-04  -7.72600000E-05
   +1.27860000E-04  +1.08900000E-04  +1.07900000E-05  -2.19640840E-01  +1.30591360E-01
   -9.59166000E-03  +1.79000000E-05  -2.43380000E-04  +1.32020000E-04  +4.32000000E-05
   +9.29100000E-05  +7.03200000E-05  -6.40900000E-05  +1.25390000E-04  -4.68400000E-05
   -1.45000000E-05  -9.82000000E-06  -1.10900000E-05  +5.32000000E-06  +2.59900000E-05
   -6.60000000E-06  -9.09000000E-06  +3.15000000E-06  +6.72000000E-06  -3.58670000E-04
   -1.10424000E-03  -1.54100000E-05  +3.60100000E-05  -1.17800000E-05  +2.32000000E-05
   +4.01980000E-04  -1.38670000E-04  +2.89650000E-04  -1.91890000E-04  +1.19600000E-04
   +5.25000000E-05  +2.50260000E-04  -2.61490000E-04  +1.20500000E-05  +1.33891000E-03
   -2.14646000E-03  +1.76010000E-04  -1.96061500E-02  +1.63923300E-02  -1.67920000E-03
   +2.36566810E-01  +1.81130000E-04  +1.71850000E-04  +3.24300000E-05  -7.89300000E-05
   -2.27400000E-05  +1.30150000E-04  -3.41980000E-04  +1.24300000E-04  +3.06840000E-04
   +6.53300000E-05  -3.24130000E-04  -7.88570000E-04  +5.88680000E-04  +7.21920000E-04
   +5.92290000E-04  -2.74260000E-04  -9.28400000E-05  -1.91040000E-04  +1.06480000E-04
   +1.51410000E-04  +4.38700000E-05  +1.67159000E-02  -1.34732200E-02  +9.67190000E-04
   +6.25200000E-05  +5.18920000E-04  +1.56098000E-03  -1.36057000E-03  -1.45584000E-03
   -3.51544000E-03  +1.13924000E-03  -6.31530000E-04  +2.79120000E-04  -4.39200000E-05
   +7.45360000E-04  -1.38190000E-04  -1.56920000E-04  -1.01230000E-04  -1.89100000E-05
   +3.36560000E-04  +3.49180000E-04  +1.17700000E-04  -3.06380000E-04  -2.24490000E-04
   -3.97300000E-05  +1.29101700E-01  -1.43735160E-01  +7.54700000E-03  +1.10370000E-04
   +2.69610000E-04  -1.60370000E-04  +8.16500000E-05  -2.37600000E-05  -8.20200000E-05
   +1.74800000E-05  -2.89530000E-04  +1.13860000E-04  +1.75000000E-06  -2.34100000E-05
   +2.87000000E-06  +2.16200000E-05  -4.96000000E-06  +2.51100000E-05  +2.57200000E-05
   +3.85400000E-05  +1.19040000E-04  -7.13530000E-04  -1.01413000E-03  +8.83640000E-04
   -9.10000000E-07  -4.00300000E-05  -5.26000000E-06  -2.78810000E-04  +6.71140000E-04
   -3.01150000E-04  -1.49800000E-04  -1.43900000E-05  -1.09020000E-04  -3.39010000E-04
   +1.02700000E-05  +1.75590000E-04  +1.24366800E-02  -9.51253000E-03  -1.91760000E-04
   -1.54547300E-02  +1.23905500E-02  -1.03617000E-03  -1.41581720E-01  +1.55096830E-01
   +1.51870000E-04  +9.29200000E-05  -4.74400000E-05  -1.59500000E-04  +5.86000000E-05
   +1.99340000E-04  -1.00590000E-04  -2.00860000E-04  -1.93210000E-04  -3.19530000E-04
   +2.61530000E-04  +5.96800000E-04  +6.42000000E-06  +9.40570000E-04  +8.63330000E-04
   -4.75100000E-05  +2.75600000E-05  -3.12810000E-04  +4.94100000E-05  +7.58000000E-06
   -3.65900000E-05  +2.15843100E-02  -1.68571800E-02  -1.07919000E-03  +1.28694000E-03
   -9.25650000E-04  +8.97330000E-04  -1.66698000E-03  -2.11259000E-03  -4.69313000E-03
   +1.64923000E-03  -8.18360000E-04  +3.06600000E-04  -4.04700000E-05  +1.24821000E-03
   -4.54800000E-05  -1.78580000E-04  -2.58700000E-05  +2.70950000E-04  +2.06330000E-04
   -2.26520000E-04  -4.48970000E-04  +1.76600000E-05  +1.43440000E-04  +1.17370000E-04
   -1.03352300E-02  +8.92991000E-03  -4.66689000E-02  -6.27950000E-04  +4.13850000E-04
   -5.16240000E-04  -9.88300000E-05  +6.75700000E-05  +4.43430000E-04  -2.92700000E-05
   -4.91750000E-04  +2.31960000E-04  -8.32000000E-06  -1.32700000E-05  -3.94000000E-06
   +2.72900000E-05  -1.21500000E-05  +8.90000000E-06  +4.36500000E-05  -1.61100000E-05
   +2.65000000E-05  +4.35100000E-05  +1.18740000E-04  -1.00850000E-04  +1.91900000E-05
   -1.26700000E-05  +1.74700000E-05  -4.63340000E-04  +4.57600000E-05  -9.25190000E-04
   +1.88400000E-05  +1.04160000E-04  -5.54600000E-05  -1.86310000E-04  +1.52190000E-04
   +3.97020000E-04  -2.30887100E-02  +1.58321700E-02  -1.83050000E-04  +1.08911000E-03
   -6.24680000E-04  -9.12930000E-04  +1.05927500E-02  -6.00496000E-03  +5.18607100E-02
   +4.62400000E-05  -1.64200000E-05  -7.37300000E-05  +2.53300000E-05  +9.03500000E-05
   +9.15700000E-05  -2.28300000E-05  -1.20650000E-04  +1.41000000E-06  -4.26000000E-05
   +1.30700000E-05  -2.81630000E-04  -7.81450000E-04  +5.50180000E-04  +1.77320000E-04
   -1.38060000E-04  +2.18520000E-04  +2.11260000E-04  -5.34200000E-05  -5.17900000E-05
   -3.74400000E-05  -1.39732000E-03  -3.19516000E-03  -1.11279000E-03  -2.34905000E-03
   +1.52976000E-03  +1.32273000E-03  +8.23627000E-03  -1.38350700E-02  +1.68351800E-02
   -6.02877500E-02  +2.75628600E-02  -2.28699200E-02  +3.39901000E-03  +1.54241400E-02
   -2.29498100E-02  +5.70840000E-04  -2.17440000E-04  -6.07830000E-04  -1.97570000E-04
   +6.65840000E-04  +8.86110000E-04  -1.00610000E-04  -3.21070000E-04  -2.78700000E-04
   +4.93220000E-04  +1.83100000E-05  -3.55700000E-04  +5.91860000E-04  +6.01324000E-03
   +3.87333000E-03  +8.15200000E-05  -3.67740000E-04  -5.32030000E-04  -4.30868000E-03
   +5.27242000E-03  +2.46355000E-03  +4.10000000E-07  -3.14000000E-06  +1.72800000E-05
   -4.29000000E-06  -1.16000000E-05  +4.82000000E-06  +6.30100000E-05  -1.28990000E-04
   -3.03800000E-05  +2.82000000E-06  +2.51000000E-06  -4.08000000E-06  +6.20000000E-06
   -3.31000000E-05  +1.16700000E-05  +2.74100000E-05  -2.91840000E-04  -2.39340000E-04
   -5.32310000E-04  +8.15510000E-04  +7.08900000E-05  -2.49334000E-03  +8.11510000E-04
   -7.55110000E-04  +3.87100000E-05  -6.46200000E-05  -1.63480000E-04  +6.18000000E-05
   -2.42500000E-05  +4.89500000E-05  -4.75400000E-05  -1.55000000E-05  -2.65600000E-05
   +5.97964200E-02  +6.28800000E-05  -5.69800000E-05  -6.58800000E-05  +9.18600000E-05
   +2.27730000E-04  +1.21740000E-04  -7.70400000E-05  -2.07060000E-04  -2.63700000E-05
   -1.06900000E-04  -1.15410000E-04  -3.65660000E-04  -8.66040000E-04  +8.79640000E-04
   +4.82860000E-04  -2.05330000E-04  +1.18200000E-04  +3.54530000E-04  -1.76770000E-04
   -1.83100000E-04  -5.43400000E-05  -1.98929000E-03  -4.82267000E-03  -1.69418000E-03
   +2.92188000E-03  -3.44910000E-04  -4.75350000E-04  +1.86273000E-03  +3.94841000E-03
   -2.15115000E-03  +2.43829200E-02  -1.52353420E-01  +1.49874500E-01  +1.04922000E-03
   -1.17767200E-02  +1.33912100E-02  +2.73260000E-04  -1.47400000E-04  -3.96210000E-04
   -1.03480000E-04  +1.56800000E-05  +2.40280000E-04  +8.08700000E-05  -1.57900000E-05
   -1.24590000E-04  +7.98280000E-04  -4.27990000E-04  -1.20950000E-04  +4.70923000E-03
   +6.75141000E-03  +2.37973000E-03  -2.58150000E-04  +1.75420000E-04  -1.18918000E-03
   +4.51419000E-03  +7.00440000E-04  -6.25190000E-04  -1.62000000E-06  +1.77900000E-05
   +2.53300000E-05  -2.54000000E-05  -3.06200000E-05  -1.27000000E-06  -9.68900000E-05
   -9.98600000E-05  -3.26900000E-05  +1.49200000E-05  +2.63000000E-05  -2.55600000E-05
   -1.40400000E-05  -4.35000000E-05  +1.18500000E-05  -6.17400000E-05  -2.18670000E-04
   -4.65970000E-04  +1.16158000E-03  -1.36148000E-03  -1.77920000E-04  +5.55280000E-04
   -2.89130000E-04  -2.10930000E-04  -2.75000000E-06  -1.12200000E-05  +2.48500000E-05
   +1.61900000E-05  +5.48000000E-06  +1.38000000E-06  -4.57200000E-05  -5.76800000E-05
   -2.41190000E-04  -3.81577900E-02  +1.60627890E-01  +2.02000000E-05  -2.40800000E-05
   +4.13500000E-05  +7.68700000E-05  +1.74970000E-04  +8.38000000E-05  -7.64400000E-05
   -1.85640000E-04  -1.59100000E-05  -2.13000000E-05  -6.05500000E-05  -2.29300000E-04
   -7.06870000E-04  +5.37350000E-04  +3.00510000E-04  -6.62100000E-05  +5.70800000E-05
   +9.17000000E-05  -1.66950000E-04  -1.65570000E-04  -2.46900000E-05  -3.61969000E-03
   -1.78449000E-03  -1.93725000E-03  -7.87430000E-04  +8.25780000E-04  +6.67050000E-04
   +1.09780000E-04  +1.52536800E-02  -1.89246400E-02  -2.49688500E-02  +1.44358660E-01
   -2.13304710E-01  +4.44478000E-03  -4.02489000E-03  +3.12948000E-03  +2.05450000E-04
   -2.46700000E-05  +1.05090000E-04  -1.07140000E-04  -6.20290000E-04  -3.92540000E-04
   +2.86670000E-04  +3.28110000E-04  +6.90700000E-05  +7.76470000E-04  -2.53310000E-04
   -1.04010000E-04  +5.99745000E-03  +4.02987000E-03  +1.84081000E-03  -5.19100000E-04
   +2.15940000E-04  -1.45910000E-03  +4.05180000E-04  +6.26160000E-04  -5.88830000E-04
   -2.51000000E-06  +2.51400000E-05  +1.01300000E-05  -2.19000000E-05  -1.52300000E-05
   -1.56900000E-05  +8.56000000E-06  +4.72700000E-05  -5.03000000E-06  -5.51000000E-06
   +3.20200000E-05  -1.70000000E-05  -1.64700000E-05  -2.42700000E-05  +7.53000000E-06
   -5.45080000E-04  -2.19840000E-04  +2.52330000E-04  -4.80400000E-05  -7.60810000E-04
   +9.28100000E-05  -8.09790000E-04  +4.03020000E-04  +2.92010000E-04  -4.88000000E-05
   -5.61000000E-06  +6.49700000E-05  +3.25200000E-05  -4.35200000E-05  -4.92700000E-05
   +1.44900000E-05  -1.14510000E-04  -1.62460000E-04  +2.15004700E-02  -1.58410410E-01
   +2.29808970E-01  -5.60000000E-05  -4.80000000E-06  +3.54000000E-05  +1.19190000E-04
   +9.77900000E-05  +4.30000000E-07  -1.62000000E-05  -4.71300000E-05  -1.33500000E-05
   -2.73500000E-05  -5.91100000E-05  -4.70200000E-05  -6.12000000E-06  +2.55130000E-04
   +1.03700000E-05  -1.91400000E-05  -1.53000000E-06  -3.60000000E-07  -1.42550000E-04
   -1.15400000E-04  -1.45900000E-05  +1.25460000E-04  -1.57090000E-04  +1.32806000E-03
   -7.14600000E-05  -1.01670000E-04  +1.05580000E-04  -4.55950000E-03  +3.71172000E-03
   -1.76819000E-03  -1.44506100E-02  -9.88044000E-03  +1.89701100E-02  -2.09647950E-01
   -6.09124300E-02  +7.83539400E-02  +2.10390000E-04  +2.07900000E-05  -3.26320000E-04
   +2.29710000E-04  +3.97120000E-04  +2.29470000E-04  -9.04200000E-05  -1.95810000E-04
   -8.27600000E-05  -4.69090000E-04  +1.25240000E-04  -1.36940000E-04  +1.69260000E-04
   -1.19360000E-04  -5.58730000E-04  -6.99000000E-06  -8.21000000E-06  +1.28050000E-04
   +1.88236400E-02  -7.92215000E-03  +4.12003000E-03  +2.14100000E-05  +1.79800000E-05
   +1.63800000E-05  -8.14000000E-06  -1.94700000E-05  -1.36000000E-06  +1.98000000E-05
   +2.06500000E-05  +3.01400000E-05  +1.38300000E-05  +1.13300000E-05  -7.08000000E-06
   -9.76000000E-06  -1.01900000E-05  +5.95000000E-06  -2.29800000E-05  +5.46500000E-05
   -3.74200000E-05  +1.60400000E-05  +3.11000000E-05  +6.87000000E-06  +1.30600000E-05
   -1.53600000E-05  -2.05100000E-05  +1.70200000E-05  -1.55400000E-05  +4.80000000E-06
   +3.41800000E-05  +3.90000000E-07  -9.93000000E-06  -3.31800000E-05  +1.25940000E-04
   +1.34320000E-04  +2.38960000E-04  +4.45940000E-04  -5.06850000E-04  +2.09565200E-01
   +3.55000000E-06  +4.15000000E-06  +2.16000000E-06  +2.39000000E-05  +2.34600000E-05
   +3.83000000E-06  -2.88000000E-06  -1.40600000E-05  +3.43000000E-06  -2.37800000E-05
   -1.41900000E-05  -7.14400000E-05  -3.95800000E-04  +1.45960000E-04  +1.00200000E-04
   +1.70000000E-06  +4.06300000E-05  +5.23800000E-05  -2.04800000E-05  -4.12000000E-06
   -1.06300000E-05  -7.62120000E-04  -1.57218000E-03  -1.27866000E-03  -7.38000000E-06
   +6.32200000E-05  -2.98400000E-05  +2.11536000E-03  +1.70260000E-04  +7.64160000E-04
   +1.50607900E-02  +1.13585000E-02  -2.23684000E-03  -6.49024300E-02  -8.20809400E-02
   +3.50984400E-02  -1.88948000E-03  -4.04010000E-04  +4.57810000E-04  +8.19840000E-04
   -1.49710000E-04  -1.02055000E-03  -4.21030000E-04  -1.26890000E-04  +3.40430000E-04
   +5.39750000E-04  -2.37340000E-04  +1.78490000E-04  +1.58290000E-04  -5.38500000E-05
   +3.63310000E-04  -2.96020000E-04  +3.00490000E-04  -3.72800000E-05  -2.61859300E-02
   -3.51120300E-02  +3.16512500E-02  +1.23900000E-05  -2.87000000E-06  +9.97000000E-06
   +1.34500000E-05  -4.38000000E-06  +1.30400000E-05  +1.72400000E-05  -2.81400000E-05
   -2.27400000E-05  -5.78000000E-06  -2.30000000E-06  +5.81000000E-06  +4.11000000E-06
   -9.37000000E-06  +4.64000000E-06  -2.33000000E-06  -1.50200000E-05  +1.01300000E-05
   +1.01400000E-05  -1.63800000E-05  -1.88000000E-06  -1.72600000E-05  +1.37300000E-05
   +2.21800000E-05  -1.40000000E-06  +6.22000000E-06  -3.16000000E-05  +8.30000000E-07
   +1.61200000E-05  +2.13900000E-05  +8.38000000E-06  -1.12230000E-04  -1.72160000E-04
   -8.04480000E-04  -3.29930000E-04  -4.37000000E-06  +7.39870700E-02  +1.06717860E-01
   +1.85300000E-05  -5.20700000E-05  -1.50500000E-05  -9.25700000E-05  -8.29400000E-05
   -3.00800000E-05  +3.00700000E-05  +3.65400000E-05  +3.86200000E-05  -5.84900000E-05
   -3.61800000E-05  +2.75000000E-06  -2.78450000E-04  +9.69800000E-05  +1.36080000E-04
   +7.54600000E-05  -9.28000000E-06  +7.44100000E-05  +1.08540000E-04  +8.39200000E-05
   +6.66000000E-06  -9.10240000E-04  -1.54262000E-03  -8.60680000E-04  +9.24500000E-05
   +5.74100000E-05  -1.22660000E-04  -1.37180000E-03  +1.65378000E-03  +2.57085000E-03
   +6.96637000E-03  +6.61248000E-03  +1.27847900E-02  +8.14525800E-02  +3.49745700E-02
   -1.07902840E-01  +1.94428000E-03  +7.24360000E-04  -1.26449000E-03  -5.72590000E-04
   +3.88990000E-04  +1.49354000E-03  +5.30870000E-04  +8.67100000E-05  -5.14860000E-04
   +5.52910000E-04  -1.80460000E-04  +2.14650000E-04  +2.32790000E-04  +5.39320000E-04
   +1.69380000E-04  -3.47400000E-04  +1.03250000E-04  -9.56900000E-05  +1.33885600E-02
   +2.43910400E-02  +3.80995000E-03  -2.75800000E-05  -1.47700000E-05  -1.22300000E-05
   -2.41000000E-06  +1.33700000E-05  -2.91000000E-06  +2.00000000E-07  +1.09100000E-05
   -9.34800000E-05  -1.13900000E-05  -1.36000000E-06  -2.64000000E-06  +2.18000000E-06
   +1.08000000E-06  -5.08000000E-06  +1.10800000E-05  -3.59200000E-05  +1.49900000E-05
   -1.21000000E-05  -2.14700000E-05  -1.44100000E-05  -1.94600000E-05  +3.75300000E-05
   -1.45900000E-05  -7.85000000E-06  +3.69000000E-06  -1.55100000E-05  -1.32300000E-05
   +2.09700000E-05  +3.26000000E-05  +1.15500000E-05  -9.72600000E-05  -1.87790000E-04
   +1.22671000E-03  -1.58597000E-03  -1.13720000E-04  -1.00611580E-01  -6.49512900E-02
   +8.88975100E-02  +5.14900000E-05  +8.00400000E-05  +5.61000000E-06  -5.20300000E-05
   -3.72400000E-05  -6.80000000E-07  -1.83800000E-05  -7.15200000E-05  +2.44000000E-05
   +1.02730000E-04  +4.07900000E-05  -1.08900000E-05  -2.78840000E-04  -6.19400000E-05
   -2.73700000E-05  -4.26300000E-05  +2.46300000E-05  -4.41300000E-05  +5.50800000E-05
   +6.34500000E-05  +1.39900000E-05  -6.62270000E-04  -9.69510000E-04  +2.26897000E-03
   +6.78640000E-04  -2.89990000E-04  -2.10610000E-04  +1.19470500E-02  -4.15581000E-03
   -3.62057000E-03  -7.97730000E-04  +1.12633000E-03  -1.29048000E-03  +3.12550000E-04
   -1.50970000E-04  +2.30100000E-05  +6.47600000E-05  -1.37886000E-03  -1.68551000E-03
   +4.15893000E-03  +5.49741000E-03  -1.10137400E-02  -6.43890000E-04  -9.47760000E-04
   +1.63684000E-03  -1.81360000E-04  +1.34890000E-04  +1.49320000E-04  +6.28072000E-03
   -2.37985000E-03  +6.66674000E-03  -4.55449900E-02  +1.38209000E-03  -3.63781200E-02
   -1.71850000E-04  +6.19200000E-04  +1.66700000E-05  +7.23000000E-06  -1.71700000E-05
   -1.42000000E-06  +2.50600000E-05  +6.12000000E-06  +2.26500000E-05  +4.55000000E-06
   -4.50300000E-05  +3.24100000E-05  -3.09300000E-05  +4.67600000E-05  +7.19000000E-06
   -2.05400000E-05  +1.64800000E-05  -8.88000000E-06  +1.14100000E-05  -1.56440000E-04
   +2.20880000E-04  -2.05800000E-05  -1.64700000E-05  -5.79000000E-06  -8.31000000E-06
   +2.44200000E-05  +3.41800000E-05  +1.34700000E-05  +1.39100000E-04  -6.64800000E-05
   +1.23400000E-05  -4.69000000E-05  +2.46300000E-05  +9.54000000E-06  -1.21300000E-05
   -4.83200000E-05  +2.86300000E-05  -2.83010000E-04  -3.76070000E-04  -5.55600000E-05
   +3.79500000E-05  +1.28500000E-05  +3.33003200E-02  +9.55000000E-06  +3.13000000E-06
   -2.74200000E-05  +4.11400000E-05  +1.66600000E-05  +4.85000000E-06  +2.20800000E-05
   +6.73400000E-05  -2.60400000E-05  -3.13200000E-05  +1.10400000E-05  +4.51100000E-05
   +3.53100000E-05  -1.00770000E-04  -1.64200000E-05  -2.41000000E-06  -2.50000000E-06
   +3.01000000E-06  -1.85000000E-06  -4.37000000E-06  -2.31000000E-06  -6.52400000E-05
   +2.48850000E-04  -4.74600000E-05  +8.20600000E-05  +7.67000000E-06  +2.11000000E-06
   -4.90559000E-03  -1.84472000E-03  +2.07000000E-05  +3.17100000E-05  -4.77750000E-04
   +1.20821000E-03  +4.19330000E-04  -9.16510000E-04  +1.86000000E-06  +6.73140000E-04
   -4.59221000E-03  -2.99484000E-03  -3.76612000E-03  +9.45337000E-03  -2.12105000E-02
   +1.17402000E-03  -1.23885000E-03  +1.74879000E-03  +4.64600000E-05  +1.81900000E-05
   +4.85800000E-05  +2.53681000E-03  -9.88262000E-03  +3.08655200E-02  +1.73493000E-03
   -7.01369700E-02  +7.31219900E-02  +1.49010000E-04  +6.12020000E-04  -1.97860000E-04
   +1.03900000E-05  +4.59000000E-06  -3.70000000E-07  +9.89000000E-06  -2.09000000E-06
   +6.56000000E-06  -8.93000000E-06  -3.17100000E-05  -1.01000000E-06  +1.84100000E-05
   -3.81400000E-05  +4.91000000E-06  +1.41300000E-05  +2.43000000E-06  +4.76000000E-06
   +3.34400000E-05  -1.30300000E-05  +5.81000000E-06  +3.90000000E-07  +3.92200000E-05
   -6.43000000E-06  -2.10000000E-05  -1.12200000E-05  -1.62800000E-05  +2.06400000E-05
   -7.52800000E-05  -1.15600000E-05  -9.00000000E-06  +2.46600000E-05  -1.17600000E-05
   +7.75000000E-06  -1.92200000E-05  -2.08500000E-05  -8.82200000E-05  +2.26190000E-04
   +4.37180000E-04  -3.36600000E-05  +5.55500000E-05  +5.20400000E-05  -9.02000000E-06
   +7.87435700E-02  +6.69000000E-06  +2.12600000E-05  +1.02400000E-05  +2.48400000E-05
   +3.57000000E-05  +9.72000000E-06  -3.31500000E-05  -4.89600000E-05  +4.19000000E-06
   +5.01000000E-05  +9.01000000E-06  -2.59200000E-05  -5.77000000E-06  -3.85100000E-05
   +1.58200000E-05  -6.05000000E-06  +1.02700000E-05  -8.98000000E-06  -3.53000000E-05
   -3.32600000E-05  +4.37000000E-06  +2.14270000E-04  +2.42640000E-04  -5.55460000E-04
   -1.49460000E-04  +4.14100000E-05  +5.79100000E-05  -1.81046000E-03  +7.35980000E-04
   +2.14633000E-03  +1.84520000E-04  -1.47560000E-04  +2.64550000E-04  -1.13860000E-04
   +9.94200000E-05  -1.23000000E-05  -4.37560000E-04  -3.32042000E-03  -1.88333000E-03
   +5.45600000E-04  +7.68543000E-03  -1.51304900E-02  +2.85050000E-04  -8.37520000E-04
   +2.24809000E-03  +3.99000000E-05  -2.77100000E-05  -5.48800000E-05  -1.92027000E-03
   -6.66860000E-04  -3.41384000E-03  -3.86625600E-02  +7.95917900E-02  -3.17942830E-01
   +2.66270000E-04  -2.36100000E-05  +1.45210000E-04  +3.34000000E-06  +6.45000000E-06
   -2.38000000E-06  +4.56000000E-06  -1.45000000E-06  +2.00000000E-08  +3.54000000E-06
   -9.48000000E-06  +2.43700000E-05  -9.55000000E-06  +1.73900000E-05  +4.18000000E-06
   -8.40000000E-06  +1.96000000E-06  +3.90000000E-07  -1.53400000E-05  +2.72900000E-05
   -4.19200000E-05  +6.79000000E-06  -1.45000000E-06  +3.16000000E-06  +1.65000000E-06
   -2.02000000E-06  -1.03000000E-06  -4.69000000E-06  +1.32900000E-05  +2.72200000E-05
   -3.61000000E-06  -1.50000000E-06  +9.74000000E-06  -4.97000000E-06  -1.36000000E-06
   +1.75700000E-05  -3.64100000E-05  -8.60000000E-07  +4.04800000E-05  +1.14200000E-05
   -2.35000000E-05  -6.40500000E-05  +4.07962200E-02  -8.30167100E-02  +3.32914560E-01
   -1.66800000E-05  +7.36000000E-06  +9.67200000E-05  +2.52000000E-06  +7.63200000E-05
   +3.49600000E-05  -6.65400000E-05  -1.57870000E-04  +1.55000000E-06  +2.16370000E-04
   +8.47600000E-05  -2.36260000E-04  -4.14080000E-04  +2.34980000E-04  -1.42450000E-04
   +4.55800000E-05  +1.48890000E-04  +9.35000000E-06  -4.91700000E-05  -3.75200000E-05
   -2.13000000E-06  +3.95890000E-04  +9.18000000E-06  +7.29200000E-04  +5.74100000E-05
   +2.04510000E-04  +1.14260000E-04  +3.51322000E-03  -3.57910000E-03  -1.27104000E-03
   -2.53050000E-04  -4.88750000E-04  -9.81960000E-04  +2.37300000E-05  +3.90330000E-04
   -3.61200000E-05  -1.51593000E-03  -1.39890000E-04  -1.88902000E-03  +1.23236700E-02
   -4.98755000E-03  -2.41150000E-03  +1.62480000E-04  +3.36642000E-03  +8.25750000E-04
   -3.62610000E-04  +7.56800000E-04  -4.22120000E-04  -7.14100400E-02  -5.59469900E-02
   -7.43683200E-02  +4.57202000E-03  -9.81971000E-03  -3.75441000E-03  -5.86440000E-04
   -2.58510000E-04  +2.60280000E-04  -6.75000000E-06  +1.29000000E-06  +4.19000000E-06
   +7.51000000E-06  +4.66000000E-06  +9.20000000E-07  -1.64200000E-05  +1.74000000E-06
   +1.50000000E-06  -8.71100000E-05  +5.37400000E-05  +3.51200000E-05  -7.28000000E-06
   -5.74000000E-06  -1.44000000E-06  -3.35100000E-05  -8.16000000E-06  -7.30000000E-06
   +8.36000000E-06  -1.90100000E-05  -2.02600000E-05  +6.64000000E-06  -1.87000000E-05
   +9.00000000E-05  -1.59672000E-03  +1.29648000E-03  +8.30100000E-05  -1.61200000E-05
   +3.77200000E-05  -3.77000000E-05  +1.29940000E-04  -1.10510000E-04  +3.04840000E-04
   +7.00400000E-05  -1.25460000E-04  -1.26730000E-04  -2.97200000E-05  +2.96400000E-05
   +1.27630000E-04  -7.87147000E-03  +2.94669000E-03  +1.81499000E-03  +6.27690200E-02
   +1.16600000E-05  +3.80900000E-05  -5.88600000E-05  +1.27500000E-05  -2.73000000E-05
   -1.61500000E-05  +3.06700000E-05  +3.90000000E-05  -1.53400000E-05  -3.14100000E-05
   -2.75000000E-05  +7.43800000E-05  -1.17000000E-05  -1.66980000E-04  -1.09800000E-05
   -6.70300000E-05  -3.60300000E-05  +5.51600000E-05  +2.03200000E-05  +3.99900000E-05
   -8.82000000E-06  -3.08080000E-04  -5.18800000E-05  -6.67470000E-04  -1.22830000E-04
   -1.78370000E-04  -1.00170000E-04  +3.83115000E-03  +1.07735500E-02  +9.85688000E-03
   -7.33250000E-04  -7.52490000E-04  +1.98594000E-03  +1.48596000E-03  -4.73440000E-04
   +6.25770000E-04  +7.79760000E-04  +1.28100000E-05  -1.26081000E-03  -1.47301000E-03
   +4.29490000E-04  +5.91206000E-03  -2.51602000E-03  -2.47698000E-03  -1.06663000E-03
   +2.03765000E-03  -1.03109000E-03  -2.93170000E-04  -5.76257600E-02  -1.46192640E-01
   -1.13851620E-01  -1.31619100E-02  -1.98023200E-02  -2.47596100E-02  +3.46000000E-05
   +8.97030000E-04  -7.02330000E-04  +2.51700000E-05  -1.12300000E-05  +1.47000000E-05
   +1.46300000E-05  -7.44000000E-06  +2.49700000E-05  -5.40000000E-06  -5.05100000E-05
   -7.44000000E-06  +8.00000000E-06  -1.22000000E-06  -1.94100000E-05  +3.34000000E-06
   -4.00000000E-08  +1.16000000E-06  +4.22400000E-05  -8.27000000E-06  -6.64800000E-05
   +1.75400000E-05  +2.33500000E-05  +5.40800000E-05  -5.00900000E-05  +1.81900000E-05
   -8.45800000E-05  +1.38713000E-03  -1.21022000E-03  +4.41530000E-04  -2.16070000E-04
   -2.26850000E-04  +3.40200000E-05  -1.60370000E-04  -2.16520000E-04  +1.63840000E-04
   -9.64500000E-04  -9.35310000E-04  -5.36850000E-04  -2.33900000E-05  +3.12700000E-05
   -4.76700000E-05  +2.22051000E-03  -7.73400000E-05  -4.11550000E-04  +6.62172000E-02
   +1.61985770E-01  +2.03400000E-05  +4.29500000E-05  +4.04300000E-05  -1.48600000E-05
   -3.71000000E-06  +2.83900000E-05  -4.71700000E-05  -6.76000000E-06  +3.56000000E-05
   +2.83700000E-05  -3.73700000E-05  -3.45800000E-05  +3.29500000E-04  +7.98900000E-05
   +1.32730000E-04  +8.40700000E-05  -6.21600000E-05  -1.03880000E-04  +4.17000000E-06
   +1.33600000E-05  +8.93000000E-06  +4.60840000E-04  -1.46470000E-04  -1.02450000E-03
   -1.28570000E-04  +3.08240000E-04  +1.31420000E-04  -8.15265000E-03  -1.43839300E-02
   -2.25451900E-02  -1.36512000E-03  +2.71803000E-03  -7.18020000E-04  -1.29594000E-03
   -2.06790000E-04  -5.91110000E-04  +1.74680000E-04  +1.42160000E-04  +1.25698000E-03
   -2.53351000E-03  +2.28562000E-03  +3.33880000E-04  +2.08660000E-04  -5.29820000E-04
   +2.42000000E-05  +5.83840000E-04  -4.61320000E-04  -2.04690000E-04  -7.67424500E-02
   -1.23783550E-01  -2.00578840E-01  +2.21499000E-03  +8.85196000E-03  +7.39810000E-03
   +5.88080000E-04  -6.78080000E-04  +4.07670000E-04  +2.30000000E-07  +1.40000000E-06
   -4.15000000E-06  +1.45000000E-06  +6.01000000E-06  -5.65000000E-06  +1.80200000E-05
   +4.59300000E-05  +5.75600000E-05  -5.06800000E-05  -4.00000000E-07  +4.07300000E-05
   -1.33000000E-06  -1.49000000E-06  -3.30000000E-07  -5.70100000E-05  +1.13380000E-04
   -1.96400000E-05  -2.42600000E-05  -2.78000000E-05  -6.00800000E-05  +5.26900000E-05
   -7.46000000E-06  +1.52580000E-04  +3.60400000E-05  -4.54880000E-04  +9.17770000E-04
   -1.80000000E-05  +3.51970000E-04  -1.40340000E-04  +1.69210000E-04  -1.10360000E-04
   +4.18250000E-04  +1.39743000E-03  +1.23768000E-03  +4.35640000E-04  +1.08420000E-04
   -7.65200000E-05  -6.98800000E-05  +2.54432000E-03  -9.20200000E-05  +9.98880000E-04
   +8.11302500E-02  +1.24461930E-01  +2.13482590E-01  -8.30000000E-07  -2.60360000E-04
   +2.07400000E-05  -2.01950000E-04  +5.81900000E-05  +8.61700000E-05  -2.22400000E-05
   -2.53200000E-04  +2.67900000E-05  -8.56200000E-05  -5.41900000E-05  -2.58960000E-04
   -8.08100000E-05  +7.43690000E-04  +5.60600000E-05  -1.18270000E-04  -4.76100000E-05
   +3.77000000E-04  +1.39800000E-05  -1.61100000E-04  +1.18400000E-05  -3.21520000E-04
   -7.08180000E-04  +7.64480000E-04  -1.00140000E-04  -6.68500000E-05  +7.91200000E-05
   +2.84722000E-03  +2.42533000E-03  -4.08065000E-03  -6.62407000E-03  +3.05774000E-03
   +4.03005000E-03  +1.28880700E-02  -1.93273200E-02  +5.15218000E-03  -3.30598460E-01
   -1.72352410E-01  +1.85326800E-02  -2.68168600E-02  -3.44474000E-03  +1.89258100E-02
   +9.07182000E-03  +5.53030000E-04  -3.00919000E-03  -2.99810000E-04  +8.80300000E-05
   -3.53190000E-04  -6.84250000E-04  +1.33940000E-04  -5.90570000E-04  +1.99608000E-03
   +5.33990000E-04  -1.85562000E-03  -2.12116000E-03  +2.00281600E-02  -2.28838000E-03
   -1.62870000E-04  +3.16700000E-05  -6.00500000E-05  -1.63210000E-04  +1.46600000E-05
   -1.39370000E-04  -4.52000000E-05  +3.96100000E-04  -2.55340000E-04  +1.38400000E-05
   +4.65300000E-05  -8.49000000E-05  -3.61200000E-05  -2.10900000E-05  -1.29500000E-05
   -8.78900000E-05  +5.79300000E-05  +3.31600000E-05  -4.46800000E-05  -1.87030000E-04
   +2.35600000E-05  +9.34100000E-05  +6.95900000E-05  +2.32900000E-05  -1.60400000E-05
   +2.47900000E-05  +1.71190000E-04  -1.56800000E-05  -1.20400000E-04  -4.81600000E-05
   -2.90100000E-05  +1.00880000E-04  +2.00330000E-04  -1.02186000E-03  -3.43790000E-04
   -3.31180000E-04  +1.05570000E-04  +2.89419000E-03  -2.44845000E-03  -6.63140000E-04
   -1.07494000E-03  -1.00235000E-03  +3.52400000E-05  -7.09450000E-04  +2.75930000E-04
   +3.43296480E-01  -1.17180000E-04  -8.92800000E-05  +1.47460000E-04  +1.19650000E-04
   +2.81950000E-04  +1.09580000E-04  -1.04870000E-04  -2.64910000E-04  -3.48400000E-05
   +3.54100000E-05  -1.28900000E-05  -2.12200000E-04  -1.01390000E-04  +5.43010000E-04
   +4.56300000E-05  +1.27210000E-04  -1.15700000E-05  -8.21200000E-05  -3.01170000E-04
   -3.90180000E-04  +1.78600000E-05  +2.42840000E-04  -3.63120000E-04  +6.00380000E-04
   -1.96570000E-04  -1.00000000E-05  +5.66100000E-05  +1.89490000E-03  +3.63820000E-04
   -2.72834000E-03  -3.09459000E-03  +6.14220000E-04  +2.98709000E-03  +7.12500000E-05
   -1.32827000E-02  +4.73939000E-03  -1.84847080E-01  -1.29819950E-01  -5.87382000E-03
   +5.38750000E-03  +5.63337000E-03  +1.50729000E-02  +3.42430000E-03  +5.02001000E-03
   -8.16461000E-03  -3.79960000E-04  +1.41410000E-04  -2.58440000E-04  +1.58960000E-04
   -9.80690000E-04  -2.30205000E-03  +1.83703000E-03  -1.31684000E-03  -1.61041000E-03
   +8.68749000E-03  +5.31439000E-03  -2.89954000E-03  -6.96500000E-05  +8.85700000E-05
   -3.47300000E-05  -1.16190000E-04  -7.70000000E-07  -1.22570000E-04  +9.96600000E-05
   +1.62770000E-04  +1.15610000E-04  +1.89000000E-05  +3.30500000E-05  -3.91300000E-05
   -4.18300000E-05  -1.24700000E-05  -1.40000000E-07  -1.02990000E-04  +8.02600000E-05
   +5.60000000E-06  -1.83000000E-05  -1.46980000E-04  +3.05700000E-05  +9.44800000E-05
   +2.13800000E-05  +4.47400000E-05  +1.13200000E-05  -1.91000000E-06  +1.00900000E-04
   +1.81000000E-06  -9.91200000E-05  -4.45100000E-05  -6.44000000E-05  +1.29700000E-04
   +1.68230000E-04  -2.74850000E-04  +1.08270000E-04  -7.33300000E-05  +3.39920000E-04
   +1.34254000E-03  -1.22969000E-03  -4.30550000E-04  -6.91800000E-05  +7.50000000E-05
   -1.65260000E-04  -3.26550000E-04  +4.10360000E-04  +1.67874220E-01  +1.27320360E-01
   -8.84000000E-06  -3.15500000E-05  -7.84600000E-05  +6.55000000E-05  +1.83000000E-06
   -7.65500000E-05  +6.35500000E-05  +7.85200000E-05  -2.34500000E-05  -2.24700000E-05
   -9.00000000E-08  +1.62300000E-05  +1.83680000E-04  -1.24140000E-04  -1.09380000E-04
   -1.62520000E-04  +3.20400000E-05  +2.31400000E-04  -5.61000000E-06  +1.66500000E-05
   -2.44400000E-05  +3.01780000E-04  +3.37630000E-04  -3.93500000E-04  -1.28780000E-04
   +8.65400000E-05  +2.41800000E-05  -1.18190000E-03  -1.22132000E-03  +2.40178000E-03
   +1.37810000E-03  -7.59790000E-04  -2.60364000E-03  -6.07800000E-05  +5.48057000E-03
   -8.46780000E-04  -1.16105900E-02  -2.10005300E-02  -4.23947300E-02  +3.75640700E-02
   +2.28726100E-02  -6.63152000E-03  +5.12578000E-03  -3.18367000E-03  -5.78163000E-03
   +3.96600000E-05  -4.47700000E-05  +1.56710000E-04  +3.74410000E-04  -1.56081000E-03
   +2.53440000E-04  -3.14960000E-04  +7.53420000E-04  -2.64785000E-03  -7.76690000E-04
   -4.30297000E-03  -7.29970000E-03  +2.43400000E-05  -1.50200000E-05  +2.22700000E-05
   +3.11200000E-05  -2.64200000E-05  +6.74000000E-05  -9.18000000E-05  +5.99400000E-05
   -8.02500000E-05  +3.66100000E-05  -3.22400000E-05  -6.97000000E-06  +9.02000000E-06
   +3.08000000E-06  +3.15000000E-06  +2.23200000E-05  +1.47900000E-05  -5.65900000E-05
   +1.64000000E-06  +2.43900000E-05  -6.26000000E-06  -2.47100000E-05  -1.38000000E-06
   -4.67800000E-05  +5.66000000E-05  -2.29900000E-05  -1.31640000E-04  -4.57000000E-06
   +1.52600000E-05  +1.38000000E-05  -2.77000000E-06  +8.41000000E-06  -9.99100000E-05
   +2.14200000E-04  +2.95870000E-04  +1.04100000E-05  +5.43250000E-04  +8.66230000E-04
   +1.15586000E-03  +2.88190000E-04  +1.17850000E-04  +1.90410000E-04  +4.42200000E-05
   +2.79500000E-04  -2.01450000E-04  -3.19710500E-02  +9.82560000E-04  +6.49944200E-02
end_hess

