# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.15555570    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -6.97227870E+00  +1.12722861E+00  +1.65054635E+00
   006   -4.74075940E+00  +2.49541339E+00  +1.58203559E+00
   006   -2.77082588E+00  +1.83870375E+00  -2.69828564E-02
   006   -3.11948338E+00  -2.59259214E-01  -1.57666904E+00
   006   -5.33202413E+00  -1.64740762E+00  -1.53137057E+00
   006   -7.27776470E+00  -9.55180825E-01  +9.13343546E-02
   006   -3.02449941E-01  +3.33772731E+00  -2.09864158E-01
   006   +6.97843572E-03  +5.25441031E+00  +1.95197387E+00
   008   -9.49090759E+00  -2.24396260E+00  +2.30095063E-01
   006   -3.35441557E-01  +4.82326348E+00  -2.70008447E+00
   006   +1.91058874E+00  +1.47930518E+00  -5.41068142E-02
   006   +3.82901962E+00  +1.49854453E+00  -1.68094912E+00
   006   +6.10577779E+00  -1.82357713E-01  -1.53458364E+00
   008   +5.52743248E+00  -2.81385344E+00  -1.55087980E+00
   006   +4.29761952E+00  -4.00458981E+00  +3.47838693E-01
   008   +4.35675767E+00  -6.27135135E+00  +3.99974837E-01
   006   +1.80781287E+00  -2.92415262E-01  +2.07121463E+00
   006   +2.87299444E+00  -2.56446145E+00  +2.26970993E+00
   008   +7.57621484E+00  +4.81285943E-01  +5.43127931E-01
   001   -9.45527483E+00  -3.64557083E+00  -9.11875275E-01
   001   -5.53863741E+00  -3.28141509E+00  -2.74911806E+00
   001   -1.61655541E+00  -8.45266484E-01  -2.83730225E+00
   001   -4.56315728E+00  +4.10308343E+00  +2.82963532E+00
   001   -8.48812529E+00  +1.65497816E+00  +2.91496640E+00
   001   -2.01228081E+00  +6.01741363E+00  -2.74896846E+00
   001   +1.31538670E+00  +6.04582543E+00  -2.87675650E+00
   001   -4.08330103E-01  +3.56953701E+00  -4.33256002E+00
   001   -1.07703550E-01  +4.38048136E+00  +3.81297549E+00
   001   +1.84204908E+00  +6.17471289E+00  +1.79231434E+00
   001   -1.44389963E+00  +6.71325778E+00  +1.84556849E+00
   001   +3.84662682E+00  +2.82285499E+00  -3.23459993E+00
   001   +7.18685618E+00  +9.13444569E-03  -3.28112504E+00
   001   +2.51048814E+00  -3.68477844E+00  +3.93959185E+00
   001   +6.18524240E-01  +2.81559182E-01  +3.63622688E+00
   001   +9.14159930E+00  -4.25904294E-01  +4.55164163E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -3.10000000E-07  +2.20000000E-07  -7.20000000E-07
   -3.10000000E-07  +2.00000000E-07  -7.40000000E-07
   -4.90000000E-07  +4.60000000E-07  -3.90000000E-07
   +6.10000000E-07  +5.00000000E-08  +1.00000000E-08
   +1.00000000E-07  -2.00000000E-07  -5.70000000E-07
   +1.70000000E-07  -2.00000000E-08  -1.07000000E-06
   -1.24000000E-06  -1.00000000E-06  -1.09000000E-06
   +6.00000000E-08  -3.80000000E-07  -4.60000000E-07
   -1.70000000E-07  +1.00000000E-07  -9.80000000E-07
   +1.15000000E-06  -6.00000000E-07  -2.20000000E-07
   +7.84000000E-06  -5.00000000E-08  -6.02000000E-06
   +7.10000000E-06  -3.98000000E-06  +1.16400000E-05
   -8.93000000E-06  +2.52200000E-05  -1.28500000E-05
   +6.77000000E-06  -1.47300000E-05  +6.69000000E-06
   -3.25000000E-06  -2.94000000E-06  +1.20400000E-05
   -1.05000000E-06  -2.10000000E-07  -2.64000000E-06
   -1.19000000E-06  -7.60000000E-07  +1.98000000E-06
   -1.36000000E-06  +8.50000000E-07  -3.00000000E-08
   -1.52400000E-05  -7.85000000E-06  -4.72000000E-06
   +5.00000000E-08  +1.10000000E-07  -8.70000000E-07
   +3.10000000E-07  -1.30000000E-07  -3.60000000E-07
   +3.70000000E-07  -2.70000000E-07  -2.60000000E-07
   -4.00000000E-07  +2.90000000E-07  -1.02000000E-06
   -4.00000000E-07  +4.10000000E-07  -1.22000000E-06
   +5.00000000E-07  -2.30000000E-07  -6.70000000E-07
   +7.30000000E-07  -5.30000000E-07  -2.70000000E-07
   +4.90000000E-07  -2.90000000E-07  -2.10000000E-07
   -2.60000000E-07  -3.50000000E-07  +1.20000000E-07
   -3.40000000E-07  -1.40000000E-07  -3.30000000E-07
   -3.60000000E-07  -2.00000000E-08  -5.50000000E-07
   +1.02000000E-06  +1.90000000E-06  +1.19000000E-06
   +1.37000000E-06  +1.89000000E-06  +1.63000000E-06
   -8.00000000E-07  +8.70000000E-07  +7.60000000E-07
   -1.10000000E-06  +2.23000000E-06  +6.10000000E-07
   +8.55000000E-06  -1.20000000E-07  +1.55000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.59412150E-01  +1.23585050E-01  +5.01872580E-01  -1.84754290E-01  +2.41689040E-01
   +4.30723840E-01  -2.81353970E-01  -8.84567500E-02  +4.59015900E-02  +6.03819100E-01
   -1.39462840E-01  -1.67235220E-01  -1.28579400E-02  +1.32324350E-01  +5.37639780E-01
   +3.78547000E-03  -3.99944700E-02  -9.60632000E-02  -1.39160740E-01  +2.56965010E-01
   +4.33016660E-01  -4.74442900E-02  -2.25674700E-02  +1.08327500E-02  -2.29210710E-01
   +4.72958800E-02  +1.27272780E-01  +5.73576390E-01  +1.56985200E-02  +4.63094100E-02
   +2.39458300E-02  -2.86055000E-03  -1.21974580E-01  -4.49228500E-02  +8.40527200E-02
   +4.87741130E-01  +4.25706100E-02  +4.35226600E-02  +2.06990300E-02  +8.61046000E-02
   -7.08074900E-02  -1.72801800E-01  -1.43388440E-01  +2.01585820E-01  +4.29052740E-01
   -2.40824500E-02  -2.90725600E-02  -1.29104600E-02  +4.26534400E-02  +2.34321600E-02
   +1.71853000E-03  -1.22950570E-01  -5.92911000E-03  +2.52164000E-02  +6.55205600E-01
   -3.16620500E-02  -4.55578100E-02  -1.82190000E-02  +6.23692900E-02  -1.68874000E-03
   -4.15459100E-02  -5.57068600E-02  -2.28458950E-01  -9.99647000E-02  +1.16439290E-01
   +4.98566040E-01  -1.53165500E-02  -2.01434800E-02  -1.16735700E-02  +3.43711300E-02
   -2.07991600E-02  -2.69601800E-02  -1.79032700E-02  -1.26827740E-01  -1.65362360E-01
   -1.74833090E-01  +2.27354310E-01  +4.23591620E-01  +4.21696200E-02  +5.67837000E-02
   +2.90022700E-02  -6.37815600E-02  -7.55054000E-03  +2.53957200E-02  +1.86544800E-02
   -6.06138700E-02  -5.77147600E-02  -2.83176900E-01  -9.29354100E-02  +4.40282200E-02
   +6.13912390E-01  +2.25515100E-02  +2.36528000E-03  -1.72938900E-02  -1.09626500E-02
   -4.38995000E-03  +5.08612000E-03  -2.15390100E-02  -2.59323800E-02  -1.65541200E-02
   -1.44056430E-01  -1.70472870E-01  -1.34136400E-02  +1.43969930E-01  +5.39627030E-01
   +3.13770000E-04  -3.57402000E-02  -2.14725800E-02  +2.32510200E-02  +3.35519000E-03
   -1.31412500E-02  -2.33223300E-02  +4.16991000E-03  +2.53744300E-02  +1.69641000E-03
   -4.05980700E-02  -9.45142500E-02  -1.43907730E-01  +2.60397080E-01  +4.17438050E-01
   -1.21227610E-01  -4.58049600E-02  -1.10237800E-02  +2.28134800E-02  -2.24378700E-02
   -2.94055500E-02  -7.23792000E-03  +2.30248900E-02  +2.09673300E-02  -5.16148500E-02
   -2.40178600E-02  +8.89661000E-03  -2.13769310E-01  +5.81399700E-02  +1.25594070E-01
   +6.25671470E-01  +1.13424500E-02  -2.30684130E-01  -1.37907310E-01  -6.52659500E-02
   -2.86336500E-02  +9.29556000E-03  +2.23657100E-02  -3.56336400E-02  -3.65251500E-02
   +1.92292700E-02  +5.12085100E-02  +3.04733900E-02  -3.10766000E-03  -1.33410010E-01
   -5.06893400E-02  +1.27555460E-01  +5.38909320E-01  +3.66812200E-02  -1.06496830E-01
   -1.79523180E-01  -6.55972900E-02  -1.34098400E-02  +2.57050500E-02  +1.95951800E-02
   -3.68340600E-02  -4.75381100E-02  +4.49900500E-02  +5.30422600E-02  +2.27652300E-02
   +7.57910800E-02  -8.39659200E-02  -1.79300220E-01  -1.44865620E-01  +2.39546820E-01
   +4.39943820E-01  +4.97190000E-04  +2.52580000E-04  +3.72219000E-03  -2.00059200E-02
   -1.17458500E-02  +2.66370000E-03  -1.48002680E-01  -3.93367700E-02  +1.16299100E-02
   -4.89261000E-03  -9.54216000E-03  -4.38269000E-03  +3.97577000E-03  +3.30420000E-04
   +1.15067000E-03  -2.26444000E-03  +4.71290000E-04  +1.01545000E-03  +4.71249770E-01
   +1.21422000E-03  +2.09973000E-03  -4.51768000E-03  +3.08235000E-03  +8.89652000E-03
   +3.01361000E-03  -4.23673000E-02  -1.05045600E-01  -5.21247000E-03  -2.37613000E-02
   -1.43279600E-02  +1.22281000E-03  +2.41000000E-06  -4.59300000E-04  -4.66092000E-03
   -2.24590000E-04  -1.06855000E-03  -4.31470000E-04  +1.58808000E-03  +4.81887300E-01
   +3.80397000E-03  -3.24527000E-03  +1.67247000E-03  +1.35445100E-02  +1.09671200E-02
   +2.53408000E-03  +8.72298000E-03  -7.29543000E-03  -7.96419800E-02  -1.77636500E-02
   -8.17471000E-03  +4.93970000E-03  +1.15789000E-03  -5.78479000E-03  +1.26160000E-04
   +1.23000000E-05  -9.87000000E-04  -1.29357000E-03  -8.21830000E-04  -4.59910000E-03
   +4.81712000E-01  +2.78410000E-04  -5.82390000E-04  -7.27570000E-04  -1.49093000E-03
   -7.65680000E-04  -4.27320000E-04  -3.65962000E-03  -2.11248800E-02  -2.30772600E-02
   -5.30762000E-03  -1.73161000E-03  +1.42323000E-03  +2.35120000E-04  -1.34935000E-03
   -6.50400000E-04  +4.22390000E-04  +1.87960000E-04  +5.11000000E-06  -7.60651300E-02
   -3.09489000E-03  -4.33008000E-03  +5.84991190E-01  +4.81290000E-04  -5.53880000E-04
   -5.67140000E-04  -2.68900000E-05  -1.14050000E-04  +8.09170000E-04  -6.89484000E-03
   -1.44926900E-02  -1.33692200E-02  -2.56436000E-03  -5.16600000E-05  +2.37070000E-04
   +3.33740000E-04  -4.84450000E-04  -4.80150000E-04  -2.81950000E-04  +9.67900000E-05
   -1.37400000E-05  -8.73830000E-03  -1.17277530E-01  -4.95253300E-02  -9.98999000E-03
   +5.25465570E-01  +1.35430000E-04  +3.99000000E-06  -1.36630000E-04  +1.30698000E-03
   +7.83580000E-04  +6.89500000E-05  -3.92377000E-03  +1.31760000E-04  +1.88701000E-03
   +1.52988000E-03  +6.89890000E-04  -2.11490000E-04  +4.63510000E-04  +2.89340000E-04
   +1.19480000E-04  -2.65170000E-04  +1.21000000E-06  +3.09030000E-04  -9.44483000E-03
   -4.33023600E-02  -1.28042370E-01  -1.48326100E-02  -6.35878500E-02  +5.26088690E-01
   -9.73652000E-03  -1.91168300E-02  -6.17413000E-03  +1.22413000E-03  +1.49109000E-03
   +3.24060000E-03  -3.04836000E-03  -2.76769000E-03  -2.70698000E-03  +3.42381000E-03
   +4.14044000E-03  +5.47983000E-03  -4.55729100E-02  -2.86974800E-02  +6.68527000E-03
   -2.56161460E-01  -8.32705600E-02  +4.57889200E-02  +1.67004000E-03  +7.04580000E-04
   +5.69010000E-04  -5.84390000E-04  +1.25490000E-04  +3.46080000E-04  +3.49138890E-01
   -4.72576300E-02  -2.89781100E-02  -4.43745000E-03  +6.54041000E-03  +1.09148000E-03
   -6.88434000E-03  -3.52700000E-03  +1.68900000E-03  +3.49593000E-03  -2.34969000E-03
   -1.41700000E-03  -6.03499000E-03  +2.29380000E-04  +8.46498000E-03  -1.13585000E-03
   -1.21604900E-01  -1.37780030E-01  -1.09586800E-02  +1.00569000E-03  +3.30460000E-04
   +1.00595000E-03  -3.64150000E-04  +3.51100000E-05  +1.97890000E-04  +1.38081420E-01
   +4.78406310E-01  -2.95780800E-02  -2.00374600E-02  +7.12405000E-03  +7.68424000E-03
   -4.05214000E-03  -2.34486000E-03  -2.13064000E-03  +3.94371000E-03  +3.17260000E-03
   +2.23990000E-04  -9.51301000E-03  -6.68500000E-04  +3.02410000E-02  +1.45144000E-02
   +5.48774000E-03  +1.53386300E-02  -3.09818300E-02  -7.75582500E-02  -3.11960000E-04
   +4.23780000E-04  -7.69500000E-05  +7.28000000E-06  -2.37000000E-05  -5.33300000E-05
   -6.04133100E-02  +2.88803910E-01  +2.91358760E-01  -1.33048000E-03  +1.98100000E-05
   -1.31517000E-03  -5.35610000E-04  -1.91933000E-03  -5.76490000E-04  -4.63139000E-03
   -1.66874300E-02  +2.56943800E-02  -4.97840000E-04  -5.17680000E-04  +1.08147000E-03
   -3.09320000E-04  +7.60680000E-04  +2.03300000E-05  +7.51680000E-04  +8.05480000E-04
   +3.63160000E-04  -7.57721300E-02  -1.04414000E-03  +2.26907000E-03  +4.63550000E-04
   +9.72760000E-04  -2.97102000E-03  -1.39331000E-03  -9.80150000E-04  -2.97900000E-05
   +5.86384440E-01  -6.48390000E-04  -3.53570000E-04  -8.56990000E-04  +1.50235000E-03
   -1.00435000E-03  -5.01680000E-04  -8.21191000E-03  -1.43081500E-02  +1.72055600E-02
   -5.18090000E-04  -1.66460000E-04  +1.11830000E-03  +3.58100000E-05  +6.84310000E-04
   -1.50860000E-04  +2.02150000E-04  +5.98850000E-04  +4.30100000E-04  +2.61672000E-03
   -1.00144590E-01  +4.52620300E-02  +1.25500000E-04  +9.99753000E-03  -1.88306800E-02
   -5.54980000E-04  -4.42740000E-04  -5.32400000E-05  +1.63753000E-03  +5.52647900E-01
   -8.32300000E-05  -2.87870000E-04  -1.03300000E-05  -9.18710000E-04  -6.55300000E-05
   +3.83000000E-06  +8.69575000E-03  +8.47165000E-03  -4.86214000E-03  -1.63481000E-03
   -1.07556000E-03  -2.62030000E-04  +2.41290000E-04  -1.48410000E-04  -1.49260000E-04
   +1.69250000E-04  +2.33000000E-04  +2.69420000E-04  -3.07980000E-03  +4.27094100E-02
   -1.48845930E-01  -8.48260000E-04  +9.33002000E-03  -3.68415000E-02  -4.87070000E-04
   -3.29720000E-04  -6.31500000E-05  -4.73932000E-03  +5.92005700E-02  +5.01334040E-01
   -8.06500000E-05  -3.65100000E-04  +1.10391000E-03  -1.84208000E-03  -1.38138000E-03
   -1.75983000E-03  -3.59212600E-02  +1.37387400E-02  +2.27454000E-03  -8.93870000E-04
   +1.37080000E-04  -6.05290000E-04  +1.07370000E-04  +6.04380000E-04  +6.88530000E-04
   -3.31970000E-04  -1.05900000E-04  +7.01200000E-05  -1.27901920E-01  +4.50404900E-02
   -4.10174000E-03  +2.06500000E-05  +6.29088000E-03  +7.57837000E-03  +2.73920000E-04
   +1.78110000E-04  -1.06500000E-05  -7.59380000E-04  +5.44010000E-03  -4.88087000E-03
   +6.01482050E-01  -7.98510000E-04  -1.03345000E-03  +6.55830000E-04  -1.63600000E-03
   -2.31585000E-03  -9.21130000E-04  -7.59133000E-03  +1.39099700E-02  -2.96170000E-04
   -2.98405000E-03  -5.10570000E-04  -7.15200000E-05  -3.28500000E-05  -1.69580000E-04
   +1.43640000E-04  +5.54530000E-04  +1.10615000E-03  +3.23600000E-04  +4.42261800E-02
   -1.12589360E-01  +1.17318100E-02  +1.76684800E-02  -2.25048300E-02  -7.65435000E-03
   -1.20479000E-03  -9.32650000E-04  -2.95100000E-05  +1.44274700E-02  -1.47521600E-02
   +3.88713000E-03  -9.29080100E-02  +3.83189880E-01  +1.80620000E-04  +1.27120000E-04
   -2.86720000E-04  +6.09700000E-04  +6.94670000E-04  -1.59840000E-04  +4.12864000E-03
   -2.42729000E-03  -3.71220000E-04  -1.38627000E-03  +9.01600000E-05  +8.75220000E-04
   -1.62450000E-04  +4.89400000E-05  -8.66100000E-05  +2.06520000E-04  -5.98100000E-05
   -1.50910000E-04  -1.46792000E-03  +6.57957000E-03  -8.53739100E-02  +2.05172400E-02
   -1.94620400E-02  -2.02960000E-04  -1.27130000E-04  -8.96400000E-05  +2.85800000E-05
   -2.40809300E-02  +2.03646900E-02  -2.12273000E-03  -2.53849610E-01  -1.27498950E-01
   +5.56336360E-01  -1.26040000E-04  -2.36600000E-04  +1.41320000E-04  -5.24270000E-04
   -6.60040000E-04  -2.70700000E-04  -9.16230000E-04  +2.31254000E-03  -1.89720000E-04
   +1.06680000E-04  +2.30070000E-04  +3.94980000E-04  -2.65540000E-04  -9.04000000E-05
   +9.91400000E-05  +5.01050000E-04  +3.60930000E-04  -6.98300000E-05  -1.99817500E-02
   +5.57017000E-03  +1.66210000E-02  -2.72491000E-03  -9.63800000E-04  -2.20733000E-03
   -6.15360000E-04  -4.34630000E-04  +4.16000000E-06  -2.23650000E-03  +2.19480000E-04
   +1.44188000E-03  -3.43553880E-01  +1.76868300E-02  +2.17527850E-01  +6.25064350E-01
   +8.92000000E-05  +2.30630000E-04  -2.38580000E-04  +8.88070000E-04  +7.96040000E-04
   +2.93300000E-04  +1.36517000E-03  -3.88685000E-03  -2.26250000E-04  -1.70940000E-04
   -1.38870000E-04  -4.42140000E-04  +2.25070000E-04  +3.84860000E-04  -9.81000000E-05
   -4.30940000E-04  -2.59260000E-04  +4.28200000E-05  +1.69520400E-02  +5.03140000E-03
   -1.35870800E-02  +2.58574000E-03  -1.43600000E-03  +8.09250000E-04  +5.15770000E-04
   +3.58940000E-04  +5.49400000E-05  +1.38154000E-03  -1.41470000E-03  -9.59100000E-04
   +1.15681500E-02  -9.31932000E-02  +3.00075400E-02  -1.16926730E-01  +4.07552320E-01
   -1.02680000E-04  -2.90700000E-05  +1.55050000E-04  -6.96000000E-05  -7.91300000E-05
   +2.58480000E-04  -1.74712000E-03  +3.94920000E-04  +3.82180000E-04  -2.95270000E-04
   -6.47300000E-04  -8.38920000E-04  -1.56000000E-06  +3.46010000E-04  +1.80140000E-04
   -1.52780000E-04  -7.79100000E-05  +2.54700000E-05  +3.86397000E-03  -3.84251000E-03
   +5.44345000E-03  -2.92340000E-04  +1.04244000E-03  +6.16070000E-04  +1.76700000E-05
   +2.72400000E-05  +7.68600000E-05  -8.98930000E-04  +1.48420000E-04  -3.69050000E-04
   +2.19805800E-01  +2.31093600E-02  -2.65302820E-01  -2.43511180E-01  -2.03687850E-01
   +5.89305370E-01  +3.16700000E-04  +4.29240000E-04  +5.51000000E-05  -1.57040000E-04
   +1.25710000E-04  +4.08260000E-04  +6.03760000E-04  -9.76160000E-04  +2.43530000E-04
   +9.46400000E-05  +8.59500000E-05  +2.05290000E-04  +2.32310000E-04  -3.42270000E-04
   -2.12320000E-04  -7.72920000E-04  -6.35250000E-04  -1.03530000E-04  +1.34944000E-03
   +1.07069000E-03  +2.92959000E-03  +4.78310000E-04  +2.27210000E-04  +6.91030000E-04
   +1.02017000E-03  +6.34690000E-04  -3.39400000E-05  +1.08338000E-03  -5.69520000E-04
   -1.21150000E-04  -2.31922100E-02  +1.61409500E-02  +2.25906000E-03  -1.72021140E-01
   +7.09633400E-02  +9.14023000E-03  +5.57885950E-01  -7.97200000E-05  -2.39690000E-04
   -7.76300000E-05  -1.59460000E-04  -1.53940000E-04  +5.03200000E-05  +1.21166000E-03
   +2.34990000E-04  -4.57950000E-04  -3.18900000E-04  -3.21370000E-04  +6.39200000E-05
   -2.00880000E-04  -6.77800000E-05  +1.46240000E-04  +2.88480000E-04  +2.83960000E-04
   +3.14600000E-05  +3.08005000E-03  +5.21288000E-03  +7.24761000E-03  -2.83357000E-03
   +1.68016000E-03  -1.27561000E-03  -4.87470000E-04  -4.16690000E-04  +2.18900000E-05
   -1.06410000E-04  -3.72480000E-04  +3.96390000E-04  +1.04959000E-03  +5.19908000E-03
   -9.32834000E-03  +6.46837200E-02  -1.24404400E-01  +1.69429800E-02  -5.46141300E-02
   +4.20900900E-01  +1.50410000E-04  +2.07210000E-04  -1.64220000E-04  +2.69570000E-04
   +3.12670000E-04  +3.00460000E-04  +1.43373000E-03  -1.92023000E-03  -1.74390000E-04
   -1.19810000E-04  +3.25400000E-05  -1.02420000E-04  +1.22240000E-04  -2.09800000E-05
   -1.23600000E-04  -2.44150000E-04  -2.29480000E-04  +5.91000000E-06  +5.39583000E-03
   +6.00772000E-03  +3.16130000E-04  -4.98360000E-04  +8.88580000E-04  +4.08380000E-04
   +3.52820000E-04  +2.31950000E-04  -2.72300000E-05  -4.32180000E-04  +6.47250000E-04
   -8.35100000E-05  +1.88576500E-02  -1.68033600E-02  +6.05796000E-03  +1.09707200E-02
   +1.34309700E-02  -9.32744400E-02  -8.04884000E-02  -3.73380800E-02  +6.06995710E-01
   -7.94800000E-05  -9.06900000E-05  -7.14400000E-05  +1.99660000E-04  +4.82900000E-05
   -1.76850000E-04  -3.09540000E-04  +7.60100000E-05  -7.39600000E-05  +1.39000000E-05
   +1.61080000E-04  -1.39260000E-04  -4.39000000E-06  +1.48990000E-04  +5.79000000E-06
   +2.81770000E-04  +1.74370000E-04  +5.63800000E-05  +1.34750000E-04  -3.69290000E-04
   -9.97830000E-04  +2.97400000E-05  -1.31580000E-04  +9.21700000E-05  -2.98320000E-04
   -1.28410000E-04  -2.62800000E-05  -2.11370000E-04  +1.28920000E-04  +3.10400000E-05
   +2.40629000E-03  -2.17440000E-03  +2.28799000E-03  +8.90895000E-03  +2.21389600E-02
   -6.02713000E-03  -7.00891600E-02  -4.15577000E-03  +2.26318200E-02  +1.66531300E-01
   +1.50870000E-04  +3.13540000E-04  +2.08000000E-06  +1.72690000E-04  +2.26310000E-04
   +1.93190000E-04  +1.15060000E-04  -1.00701000E-03  +6.06200000E-05  +1.22900000E-04
   +1.73930000E-04  -1.16910000E-04  +1.62450000E-04  +2.27900000E-05  -2.03850000E-04
   -3.43750000E-04  -3.89380000E-04  -5.83800000E-05  +7.70790000E-04  +7.37160000E-04
   -7.25490000E-04  +5.82210000E-04  -2.64760000E-04  +7.67400000E-04  +5.64040000E-04
   +4.84510000E-04  -3.98800000E-05  +2.13940000E-04  -1.04670000E-04  -2.09600000E-04
   -4.61640000E-04  +1.34155000E-03  +1.18289000E-03  -1.12852000E-03  -3.60005300E-02
   +1.25105000E-03  -1.09876700E-02  -1.61463190E-01  +1.53586000E-03  +1.01887390E-01
   +4.39492430E-01  -8.47300000E-05  -1.04240000E-04  +1.16270000E-04  -1.95540000E-04
   -1.12540000E-04  +5.03600000E-05  -1.03930000E-04  +6.19590000E-04  +1.33460000E-04
   +2.62380000E-04  -3.41480000E-04  -2.05630000E-04  -1.49360000E-04  -4.89700000E-05
   +2.13540000E-04  +6.52600000E-05  +8.90400000E-05  -4.86100000E-05  -4.13240000E-04
   -4.96160000E-04  +1.16659000E-03  -5.52090000E-04  +2.51250000E-04  -6.74630000E-04
   -1.72170000E-04  -1.72930000E-04  +7.86200000E-05  +5.18100000E-05  -2.04420000E-04
   +6.29200000E-05  +2.31920000E-04  +2.36681000E-03  -1.53615000E-03  -7.18040000E-04
   +4.17480000E-04  +1.01231000E-02  +1.99349000E-02  -6.14539000E-03  -9.06201500E-02
   -1.33416830E-01  -7.10908400E-02  +2.90151170E-01  +1.63090000E-04  +2.17590000E-04
   +2.08040000E-04  -5.76810000E-04  -6.77900000E-05  +4.27150000E-04  +6.75010000E-04
   +1.69980000E-04  +4.27890000E-04  +2.11690000E-04  -6.52140000E-04  +1.74750000E-04
   -3.52000000E-05  -3.18080000E-04  -1.97600000E-05  -6.57970000E-04  -4.19830000E-04
   -1.55640000E-04  -5.40540000E-04  +4.78050000E-04  +1.34147000E-03  -5.58370000E-04
   +4.75320000E-04  -4.06650000E-04  +6.86650000E-04  +3.81190000E-04  +4.17500000E-05
   +2.39350000E-04  -1.92380000E-04  +4.92400000E-05  -8.01602000E-03  -2.87209000E-03
   -2.47567000E-03  +3.37243000E-03  +5.29020000E-04  +2.53255000E-03  -1.07697100E-02
   -3.02737000E-02  -3.76566000E-03  -1.04626980E-01  -1.66948700E-02  +8.21027700E-02
   +3.13904320E-01  -3.37850000E-04  -5.47870000E-04  -1.62040000E-04  +1.08570000E-04
   -3.04390000E-04  -3.66460000E-04  +1.28580000E-04  +1.06301000E-03  -1.86950000E-04
   -7.78300000E-05  -4.46800000E-05  -1.35850000E-04  -1.95010000E-04  +1.76890000E-04
   +4.49030000E-04  +9.75360000E-04  +8.85710000E-04  +2.18950000E-04  +1.17891000E-03
   -7.82100000E-04  +3.12610000E-04  -8.99060000E-04  +4.21520000E-04  -3.50130000E-04
   -1.33176000E-03  -1.03387000E-03  +6.05000000E-05  -7.28660000E-04  +2.40470000E-04
   +1.72880000E-04  -6.24160000E-04  +7.70810000E-04  -4.56871000E-03  -2.92200000E-04
   +1.86840000E-03  +3.17893000E-03  -2.16495500E-02  -3.76919500E-02  +2.49044400E-02
   -7.01926000E-03  -1.04979650E-01  +8.40115000E-03  -4.56562600E-02  +9.88396000E-01
   -2.07700000E-05  -1.13640000E-04  -2.50720000E-04  +3.92400000E-04  +2.09400000E-05
   -3.13610000E-04  +1.39420000E-04  -3.40510000E-04  -3.56730000E-04  -4.74500000E-04
   +5.98550000E-04  +3.97220000E-04  +1.50550000E-04  +1.20290000E-04  -1.73540000E-04
   +3.64520000E-04  +2.83980000E-04  +1.68490000E-04  +8.00510000E-04  -1.31800000E-04
   -2.07813000E-03  +4.88350000E-04  -3.47120000E-04  +9.70200000E-04  -3.55030000E-04
   -2.06120000E-04  -9.91600000E-05  -3.97820000E-04  +3.37370000E-04  -3.44100000E-05
   +1.24850000E-04  -2.67719000E-03  +2.70730000E-04  -3.02497000E-03  +2.97440000E-04
   -4.58470000E-03  -1.29237000E-03  +4.49611500E-02  +7.99315000E-03  +9.00822500E-02
   +2.32290100E-02  -1.86189930E-01  -1.51796640E-01  +1.09915600E-02  +4.45149540E-01
   -5.37300000E-05  -7.41700000E-05  -7.37200000E-05  +1.84560000E-04  +3.21200000E-05
   -1.45820000E-04  -1.70090000E-04  -2.16600000E-05  -1.07060000E-04  -4.26900000E-05
   +1.79100000E-04  -3.38900000E-05  -3.24000000E-05  +1.07230000E-04  -6.22000000E-06
   +3.13580000E-04  +1.65320000E-04  +2.24100000E-05  +2.09930000E-04  -1.33520000E-04
   -4.74880000E-04  +1.24710000E-04  -1.16030000E-04  +1.36340000E-04  -3.04320000E-04
   -1.49100000E-04  -1.62600000E-05  -1.20940000E-04  +9.94500000E-05  -6.42000000E-06
   +1.48179000E-03  +4.79000000E-05  +8.40800000E-04  -8.60530000E-04  -4.22420000E-04
   -1.04066000E-03  +3.63992000E-03  +4.68431000E-03  +5.37488000E-03  +7.66788000E-03
   -4.35031100E-02  +1.19342100E-02  -8.16794400E-02  +3.33579200E-02  +8.12764000E-03
   +5.61009400E-02  +2.17050000E-04  +3.99950000E-04  +1.61050000E-04  -1.16400000E-04
   +2.32030000E-04  +3.63840000E-04  -3.41800000E-05  -7.54130000E-04  +2.31980000E-04
   +5.43000000E-05  -1.34740000E-04  -3.05000000E-05  +2.14640000E-04  -1.04340000E-04
   -3.43710000E-04  -8.70130000E-04  -6.97030000E-04  -1.31530000E-04  -8.35500000E-04
   +8.38330000E-04  -4.00200000E-05  +5.61660000E-04  -1.78410000E-04  +1.37130000E-04
   +1.11475000E-03  +8.46160000E-04  -3.97300000E-05  +5.48320000E-04  -1.75990000E-04
   -1.27170000E-04  -2.38654000E-03  -1.63010000E-03  +3.27144000E-03  +1.15599000E-03
   -2.95033000E-03  -1.81942000E-03  +4.24667000E-03  +1.88079400E-02  +8.83222000E-03
   -3.78809600E-02  -8.38999100E-02  +5.32345700E-02  +3.66251400E-02  -7.42754570E-01
   -1.65257300E-02  -2.02245800E-02  +8.73631480E-01  -1.95000000E-06  +4.94600000E-05
   +9.53800000E-05  -8.50000000E-05  +1.16700000E-05  +1.32080000E-04  -5.91300000E-05
   +1.49900000E-05  +1.28990000E-04  +1.33260000E-04  -1.72420000E-04  -1.07750000E-04
   -1.40600000E-05  -4.18400000E-05  -1.70000000E-06  -1.31500000E-04  -1.01300000E-04
   -6.07500000E-05  -2.69420000E-04  -2.18100000E-05  +5.72240000E-04  -8.52500000E-05
   +9.89100000E-05  -2.38750000E-04  +1.62190000E-04  +1.11040000E-04  +3.87000000E-05
   +1.75640000E-04  -1.09120000E-04  -1.63400000E-05  -5.16300000E-05  +1.14721000E-03
   -1.11093000E-03  +4.10370000E-04  -1.93110000E-04  +1.15488000E-03  +2.19979000E-03
   -9.03072000E-03  -4.92001000E-03  +1.03983500E-02  +6.93116500E-02  +2.95420000E-04
   +9.94716000E-03  -8.71539000E-03  -9.51766000E-02  -3.64334800E-02  -2.05976100E-02
   +8.64708300E-02  +1.23350000E-04  +9.06800000E-05  +2.83740000E-04  -2.70050000E-04
   +2.30100000E-05  -2.86970000E-04  -3.40050000E-04  +2.35634000E-03  -2.06049000E-03
   -1.22472000E-03  -6.96500000E-05  -9.28450000E-04  +2.23050000E-04  +1.27490000E-04
   -1.39120000E-04  -1.33300000E-05  -2.04420000E-04  -4.27600000E-05  +2.15544000E-03
   +1.59973900E-02  -2.02725100E-02  +1.23920000E-04  -1.47820000E-04  -1.09234000E-03
   +6.90200000E-05  +6.19900000E-05  +3.81600000E-05  -4.28890000E-03  +3.58930000E-03
   +1.25055000E-03  -9.03243100E-02  +5.83210000E-03  +2.20764100E-02  +4.96792000E-03
   -1.86244900E-02  +2.28774500E-02  -1.94688000E-03  -1.54532000E-03  -2.08320000E-04
   +3.48410000E-04  -2.11599000E-03  +7.27690000E-04  -2.36897000E-03  +1.71471700E-02
   -6.46255000E-03  -5.40600000E-05  +1.74808000E-03  +3.90706000E-03  +3.85795550E-01
   +1.61300000E-04  +1.55220000E-04  +2.49400000E-05  -3.86630000E-04  -1.47580000E-04
   -5.68000000E-06  +3.83110000E-04  +1.69940000E-04  +5.76550000E-04  +6.31700000E-04
   +1.03300000E-05  +8.72500000E-05  -5.57580000E-04  -2.05900000E-04  +3.82560000E-04
   +2.84640000E-04  -1.25750000E-04  -2.17180000E-04  +3.60564000E-03  -1.83962100E-02
   +1.75609100E-02  +5.43660000E-04  -3.59670000E-04  +4.78250000E-04  -2.30210000E-04
   -1.19420000E-04  +3.30000000E-06  +2.94843000E-03  -9.04010000E-04  -1.01019000E-03
   +1.61760100E-02  -1.44129950E-01  +6.19874200E-02  -1.03614500E-02  +7.80550000E-03
   +1.49329300E-02  -3.83710000E-03  -2.25590000E-04  -5.48190000E-03  +1.72850000E-04
   -5.94749000E-03  +4.57710000E-03  +1.71475700E-02  -2.01596000E-02  -1.17365100E-02
   -1.59500000E-03  +8.96187000E-03  -8.99910000E-04  -2.63808690E-01  +6.99115400E-01
   +3.93020000E-04  +3.74500000E-04  -1.19880000E-04  +2.76700000E-05  +1.53650000E-04
   -3.73860000E-04  -6.61530000E-04  +4.39630000E-04  -4.85070000E-04  -4.10500000E-04
   +8.25170000E-04  -1.05130000E-04  -1.10810000E-04  -1.34190000E-04  -9.65700000E-05
   +1.64290000E-04  -2.25890000E-04  -1.85870000E-04  -4.80200000E-03  +6.90394000E-03
   +2.05817000E-03  -1.72500000E-04  +4.31390000E-04  +4.27570000E-04  +9.29600000E-05
   +7.28500000E-05  -3.80700000E-05  +1.32399000E-03  -4.40440000E-04  +3.86360000E-04
   +8.06917000E-03  +7.72073700E-02  -1.77784030E-01  +1.29151700E-02  +1.82778100E-02
   -2.47753600E-02  +1.18630000E-04  -7.40973000E-03  -1.50376000E-03  -8.87000000E-06
   +5.92350000E-03  -5.33098000E-03  -3.01630000E-04  -1.74784300E-02  +1.96403000E-02
   +4.08760000E-03  -9.80308000E-03  -4.94212000E-03  -1.60954660E-01  -8.20576200E-02
   +5.21043950E-01  -1.13410000E-04  -1.94470000E-04  -1.40870000E-04  +3.65040000E-04
   -9.81400000E-05  -2.14430000E-04  -4.97970000E-04  +3.41400000E-05  -4.03180000E-04
   -2.77370000E-04  +6.07370000E-04  +7.40300000E-05  +1.19200000E-04  +1.22600000E-04
   +1.80200000E-05  +3.72210000E-04  +3.57750000E-04  +1.67400000E-04  -5.06800000E-05
   -1.04721000E-03  +1.38755000E-03  +3.67800000E-05  +3.06100000E-05  +5.48820000E-04
   -4.38000000E-04  -3.03700000E-04  -1.84300000E-05  +4.19360000E-04  -3.10790000E-04
   -1.00460000E-04  +1.36554500E-02  +3.60988000E-03  -1.06006500E-02  -4.04652000E-03
   +1.61846000E-03  +2.80032000E-03  -1.86063000E-03  +3.95253000E-03  -5.01620000E-04
   +2.14280000E-03  -9.65780000E-04  +2.38629500E-02  -1.16935800E-01  +2.67689000E-02
   +4.74154000E-02  +1.58482100E-02  +1.90437400E-02  +1.06149700E-02  -1.53154060E-01
   +1.69233020E-01  +1.80577500E-02  +2.97592240E-01  -4.42500000E-05  -1.53100000E-05
   +7.55300000E-05  +1.89420000E-04  +2.33070000E-04  -1.04920000E-04  -6.47270000E-04
   -2.24870000E-04  +1.72800000E-05  -2.91720000E-04  -7.95300000E-05  -3.90240000E-04
   +3.41520000E-04  +2.34560000E-04  -2.34190000E-04  -1.82800000E-04  -7.87500000E-05
   +1.05670000E-04  -1.69212000E-03  +1.42536000E-03  +2.81053000E-03  -1.34840000E-04
   +3.86780000E-04  -1.74590000E-04  +2.50670000E-04  +1.94490000E-04  +1.78000000E-06
   +8.64570000E-04  -3.55160000E-04  -2.34640000E-04  +4.03707000E-03  -2.22272700E-02
   +1.69279300E-02  +5.23228000E-03  -1.60425000E-03  -4.44034000E-03  +2.55652000E-03
   -2.13256000E-03  +1.48046000E-03  -1.26744400E-02  +1.69009900E-02  +1.13734100E-02
   +2.25585400E-02  -1.03279760E-01  -2.31883500E-02  +3.00308800E-02  -6.12291800E-02
   -3.42734200E-02  +1.91138650E-01  -4.44747060E-01  +3.06972300E-02  -2.16863530E-01
   +7.62388780E-01  -1.63630000E-04  -9.22800000E-05  +7.53400000E-05  -3.88300000E-05
   -1.25870000E-04  +1.66620000E-04  +3.58540000E-04  +1.83440000E-04  +9.87200000E-05
   -2.53510000E-04  -2.94690000E-04  -6.75200000E-05  +2.16840000E-04  +8.90700000E-05
   -1.51000000E-04  -2.92050000E-04  -1.66000000E-06  +9.98600000E-05  +1.50144000E-03
   +2.36938000E-03  -3.95813000E-03  +2.81130000E-04  -4.20440000E-04  -6.36140000E-04
   +2.24680000E-04  +1.43000000E-04  -1.23000000E-06  -1.16813000E-03  +7.14360000E-04
   +3.16910000E-04  -1.38053300E-02  +2.52264200E-02  +2.98688000E-03  -2.11630000E-04
   -2.23940000E-04  +3.84290000E-04  -1.22770000E-04  -1.69333000E-03  -1.49439000E-03
   +2.57401500E-02  -4.62117000E-03  -2.06183900E-02  +4.77435600E-02  -3.84562700E-02
   -1.65966610E-01  +1.16572000E-02  -1.19950200E-02  +1.22220300E-02  +6.16046000E-03
   +5.01848000E-02  -1.10901210E-01  -1.43972240E-01  -1.31456460E-01  +5.28836960E-01
   -1.61830000E-04  -1.98030000E-04  -6.99000000E-05  +1.40970000E-04  -5.68900000E-05
   -1.47440000E-04  +2.36190000E-04  +2.47480000E-04  -1.38030000E-04  -3.62600000E-05
   -7.78500000E-05  -1.98900000E-04  -1.28010000E-04  +1.67580000E-04  +1.12700000E-04
   +4.91480000E-04  +3.42590000E-04  +4.80100000E-05  +1.82799000E-03  +1.58370000E-03
   +1.91948000E-03  -1.31085000E-03  +5.36730000E-04  -4.16610000E-04  -6.00170000E-04
   -3.57520000E-04  +1.52700000E-05  -4.78640000E-04  +2.08000000E-06  +2.58220000E-04
   +2.00901000E-03  -1.16430000E-04  -2.94633000E-03  -2.94832500E-02  -2.99643000E-03
   -3.08982900E-02  -1.29824410E-01  -7.38770000E-03  -8.39721100E-02  -1.02065200E-02
   -2.74192400E-02  -1.35316800E-02  +1.90067000E-03  +5.59673000E-03  -6.37272000E-03
   +9.93200000E-05  -4.42148000E-03  +2.00860000E-03  -1.80355000E-03  -2.46243000E-03
   -8.27750000E-04  -2.88401000E-03  -1.16550000E-03  +9.20140000E-04  +5.60406910E-01
   +8.13000000E-06  +5.19400000E-05  +1.23000000E-05  +6.19000000E-05  +2.65300000E-05
   -2.40100000E-05  -2.87130000E-04  -1.37800000E-05  +8.66800000E-05  +9.04100000E-05
   +1.01210000E-04  -5.11700000E-05  +4.49900000E-05  +3.90400000E-05  -3.02000000E-05
   -1.82500000E-05  -4.63500000E-05  -2.42000000E-06  -8.27800000E-04  -9.86180000E-04
   -1.19542000E-03  +4.51600000E-04  -3.78750000E-04  +3.02000000E-04  +6.81900000E-05
   +8.31300000E-05  -9.59000000E-06  +4.03000000E-06  +1.16900000E-05  -1.00580000E-04
   -1.08770000E-04  +3.53370000E-04  +1.85514000E-03  +1.17167500E-02  +7.86003000E-03
   +1.46274800E-02  +1.44316300E-02  -7.91966900E-02  -2.21421700E-02  -3.62841000E-02
   -3.23692100E-02  -3.32175600E-02  +7.04325000E-03  +8.22274000E-03  -1.28344200E-02
   -6.76110000E-04  -3.38568000E-03  +2.81092000E-03  -2.23610000E-04  -1.13969000E-03
   +2.32050000E-03  -2.68187000E-03  +1.01613000E-03  -7.86100000E-05  -2.01761650E-01
   +2.44117880E-01  -8.43500000E-05  -8.50200000E-05  +2.09900000E-05  +5.26000000E-06
   -6.58200000E-05  -5.69600000E-05  -3.00000000E-07  +2.94780000E-04  +5.06100000E-05
   +8.76100000E-05  -1.03660000E-04  -1.08790000E-04  -8.24800000E-05  +6.09200000E-05
   +8.34800000E-05  +2.03500000E-04  +1.38140000E-04  -1.01700000E-05  +1.35160000E-04
   +1.51620000E-04  +7.41910000E-04  -5.47190000E-04  +1.03850000E-04  -2.87450000E-04
   -2.50940000E-04  -1.46480000E-04  +2.76500000E-05  -1.22460000E-04  -3.58500000E-05
   +7.51600000E-05  +1.22233000E-03  +1.02320000E-03  -1.77663000E-03  -1.39872800E-02
   +2.76464000E-03  -2.52140000E-04  -3.81216900E-02  -3.68158000E-02  -2.01393390E-01
   -1.87911000E-02  -2.81046800E-02  +5.29426000E-03  +4.64459000E-03  +3.89454000E-03
   -1.02358100E-02  -9.17570000E-04  -4.86766000E-03  +3.48017000E-03  +3.68730000E-04
   +1.28230000E-03  -4.95710000E-04  +1.56777000E-03  -8.42020000E-04  +1.52844000E-03
   +9.07594000E-02  +9.72857800E-02  +2.77411920E-01  -5.73170000E-03  -3.02633000E-03
   +1.82293000E-03  +1.43960000E-03  -1.07439000E-03  -7.36170000E-04  -4.62700000E-05
   +5.23180000E-04  +5.46630000E-04  -6.26440000E-04  -1.89910000E-04  -2.20140000E-04
   +1.68193000E-03  -8.79400000E-04  -2.10914000E-03  -4.34974000E-03  -3.63141900E-02
   -2.83563200E-02  -1.73490000E-04  +5.35700000E-05  +9.35800000E-05  +7.73300000E-05
   +1.36600000E-05  -2.93700000E-05  -3.95909900E-02  +2.79289600E-02  +4.14848000E-02
   +4.65600000E-05  -7.11000000E-06  -7.01000000E-06  -4.73600000E-05  +2.63500000E-05
   +2.02000000E-06  +4.57100000E-05  -5.22000000E-06  +1.47700000E-05  -1.58330000E-04
   -6.10000000E-06  -3.33500000E-05  +8.35100000E-05  +7.84000000E-06  -2.33500000E-05
   -1.35270000E-04  +5.97400000E-05  +6.85500000E-05  +7.93500000E-05  -6.16500000E-05
   -1.17100000E-05  +1.60800000E-05  +7.09000000E-06  +2.46000000E-06  +5.32100000E-05
   +1.12700000E-05  -1.94700000E-05  +1.03300000E-04  +1.59700000E-05  +4.43600000E-05
   +4.83902400E-02  -4.03236000E-03  +8.19630000E-04  +1.09709000E-03  +2.92230000E-04
   -5.68300000E-05  -1.61022000E-03  +1.16360000E-04  +5.28660000E-04  +4.29100000E-04
   -1.44000000E-06  -1.07433000E-03  -3.94970000E-04  +4.10869000E-03  +3.66283000E-03
   +1.49350000E-03  -4.20900000E-04  -2.33176400E-02  -1.63830200E-02  -1.94270000E-04
   -7.88800000E-05  -1.92300000E-05  +7.18800000E-05  -1.67500000E-05  -2.86600000E-05
   -1.10097100E-02  -3.21371790E-01  -2.48692760E-01  +1.15710000E-04  +4.24800000E-05
   +3.85900000E-05  -3.49100000E-05  +1.54280000E-04  +1.39000000E-05  +8.28000000E-05
   -6.62100000E-05  +6.89000000E-06  -1.25410000E-04  +1.11160000E-04  -4.51400000E-05
   +9.10000000E-06  -1.36570000E-04  +6.67600000E-05  -7.09200000E-05  +3.00280000E-04
   +2.16700000E-05  +1.90000000E-05  -2.36970000E-04  -2.52000000E-05  -3.86000000E-06
   +3.56800000E-05  -2.86000000E-05  +6.85600000E-05  -4.84000000E-05  -3.65100000E-05
   +7.04700000E-05  -2.62900000E-05  +3.03600000E-05  +1.16771900E-02  +3.40671570E-01
   +9.01140000E-04  +4.88150000E-04  +2.10597000E-03  +3.43350000E-04  -9.51000000E-04
   +7.70620000E-04  +2.16400000E-04  +5.64800000E-05  +1.50000000E-04  -3.43300000E-05
   -2.14100000E-04  -8.20950000E-04  +1.94246000E-03  +4.16675000E-03  +1.40236000E-03
   +2.28780000E-04  +2.54592000E-03  -8.77410000E-04  -1.06540000E-04  -4.12300000E-05
   -1.51390000E-04  +1.82800000E-05  -5.68000000E-06  -1.18300000E-05  +1.04832300E-02
   -2.69122480E-01  -2.24896450E-01  +1.19410000E-04  +6.94000000E-05  +4.33100000E-05
   -1.86700000E-05  +3.67400000E-05  +2.08400000E-05  +2.17800000E-05  -2.04700000E-05
   -2.81500000E-05  -4.22400000E-05  -1.20000000E-07  +6.55000000E-06  +4.23000000E-05
   +1.75000000E-05  -5.82200000E-05  -6.92200000E-05  -1.40700000E-05  +8.63200000E-05
   +3.26000000E-05  +1.31000000E-06  -3.68100000E-05  -1.68600000E-05  +1.04300000E-05
   +2.26800000E-05  +2.25700000E-05  -5.81000000E-06  -3.19000000E-06  +2.51800000E-05
   +6.66000000E-06  -4.96000000E-06  -1.39870100E-02  +2.63374260E-01  +2.22790500E-01
   -2.43551000E-03  +2.25300000E-04  +4.48332000E-03  -1.58275000E-03  -1.34630000E-04
   +2.48060000E-04  -3.09099000E-03  -4.01128000E-03  +2.42628000E-03  +1.98375000E-03
   -2.19532100E-02  -1.75202600E-02  -5.89019000E-02  -2.56101500E-02  -7.40289000E-03
   +5.76108000E-03  +1.78627200E-02  +1.36804800E-02  +4.92730000E-04  -8.52540000E-04
   -8.49250000E-04  -3.92300000E-04  -9.46700000E-05  +1.31730000E-04  +2.14753000E-03
   +2.22728000E-03  -1.40758000E-03  -1.10500000E-05  +5.42200000E-05  -1.08220000E-04
   +1.72070000E-04  -1.04550000E-04  +6.20000000E-07  -7.49300000E-05  +8.54100000E-05
   +1.63800000E-05  +1.36400000E-05  -1.69500000E-04  -4.13000000E-06  +4.59800000E-05
   +1.45630000E-04  -3.71200000E-05  -2.41400000E-05  -2.64160000E-04  -4.71600000E-05
   +4.43700000E-05  +1.91520000E-04  +5.94200000E-05  -2.54000000E-06  -4.93400000E-05
   +3.99600000E-05  -3.34400000E-05  +7.86700000E-05  +1.20100000E-05  -6.38000000E-06
   +4.90100000E-05  +1.34200000E-05  -8.11980000E-04  -9.73370000E-04  -4.55900000E-05
   +5.64055600E-02  +6.38510000E-04  +2.70982000E-03  -2.58753000E-03  +2.10800000E-04
   +1.20480000E-04  +7.05200000E-04  -4.32998000E-03  +2.62221000E-03  -1.52459000E-03
   +5.73600000E-04  -9.81517000E-03  -1.04548500E-02  -2.59370000E-02  -2.26108490E-01
   -1.42513940E-01  -6.03538000E-03  -4.94805000E-03  -4.20484000E-03  +2.31580000E-04
   -2.05440000E-04  -7.45800000E-04  -2.91960000E-04  -1.28910000E-04  +1.29770000E-04
   +1.75773000E-03  +1.02333000E-03  +3.01101000E-03  -6.28200000E-05  -9.19000000E-06
   -3.42300000E-05  +1.64290000E-04  -1.41380000E-04  -4.61000000E-06  -6.89900000E-05
   +6.34800000E-05  +2.17100000E-05  +8.37500000E-05  -5.62600000E-05  +1.43800000E-05
   -3.09500000E-05  +3.64900000E-05  +2.13800000E-05  +6.64100000E-05  -7.87500000E-05
   -7.41700000E-05  -3.18600000E-05  +7.15300000E-05  +2.60700000E-05  +1.10500000E-05
   -6.58000000E-06  +1.10400000E-05  -4.34800000E-05  +2.60400000E-05  +1.11100000E-05
   -4.84600000E-05  +9.08000000E-06  -8.56000000E-06  +1.18632000E-03  +5.64900000E-05
   -1.04796000E-03  +3.08628200E-02  +2.36494000E-01  +4.86141000E-03  -2.39700000E-03
   +8.90160000E-04  +4.97600000E-04  +9.03750000E-04  -4.10080000E-04  +1.91936000E-03
   -2.00921000E-03  +4.79316000E-03  +7.95100000E-04  +1.65649000E-03  +3.56401000E-03
   -7.74045000E-03  -1.42296760E-01  -1.45473300E-01  -5.56425000E-03  -1.71637200E-02
   -6.75659000E-03  +3.02150000E-04  -1.12040000E-04  +2.06800000E-04  -3.46000000E-06
   +6.51300000E-05  +3.04000000E-06  -1.93722000E-03  +2.65701000E-03  -6.61310000E-04
   -3.88200000E-05  +1.35000000E-06  -4.68700000E-05  -4.99200000E-05  -3.16300000E-05
   +3.19500000E-05  -1.62900000E-05  +2.22800000E-05  -4.69400000E-05  +1.73600000E-05
   -8.76200000E-05  +2.01400000E-05  +4.14900000E-05  +1.13910000E-04  -9.56200000E-05
   -5.10100000E-05  -2.34230000E-04  +6.26300000E-05  +4.61500000E-05  +1.63020000E-04
   +3.84000000E-06  +3.70000000E-06  -4.61400000E-05  +4.26200000E-05  -1.11100000E-05
   +5.49400000E-05  +2.01000000E-05  -8.09000000E-06  +2.76300000E-05  -1.00400000E-05
   +1.70453000E-03  +1.60170000E-04  -2.39550000E-04  +7.32970000E-03  +1.56797840E-01
   +1.47044290E-01  -2.28830000E-04  -3.62290000E-04  -8.39880000E-04  +1.85473000E-03
   -2.09826000E-03  +5.93990000E-04  +6.20332000E-03  -1.16412000E-03  -2.16171000E-03
   -2.05667760E-01  +5.40772100E-02  +1.30950280E-01  -1.50903500E-02  +8.90235000E-03
   +1.75553100E-02  -1.32875000E-03  -4.97557000E-03  +8.20580000E-04  -6.58870000E-04
   +3.68830000E-04  -8.87390000E-04  -3.57000000E-05  +1.29270000E-04  -1.06240000E-04
   -1.46244000E-03  +2.07360000E-04  +8.44550000E-04  -1.95400000E-05  -9.36800000E-05
   +8.56800000E-05  -6.40500000E-04  -6.35580000E-04  -6.50540000E-04  -4.00430000E-04
   -3.38100000E-05  -1.23500000E-05  -2.57640000E-04  -1.03720000E-04  -1.04950000E-04
   +1.14310000E-04  -9.32200000E-05  +1.43740000E-04  +4.64000000E-06  +3.69690000E-04
   -6.49700000E-05  -1.24700000E-05  -2.29440000E-04  -2.61600000E-05  -1.69140000E-04
   -9.09600000E-05  -2.79290000E-04  +1.26350000E-04  -1.54340000E-04  +3.79100000E-05
   +6.50000000E-05  +2.68300000E-05  +3.96300000E-05  +1.32360000E-04  +2.27260000E-04
   +1.09140000E-04  +1.28240000E-04  +1.00682000E-03  -1.57147000E-03  +2.16852800E-01
   -4.55860000E-04  -9.70420000E-04  +4.14690000E-04  -2.57148000E-03  -1.82532000E-03
   -5.43569000E-03  +1.96053900E-02  -1.47276000E-03  -1.48804100E-02  +5.43749800E-02
   -7.68543500E-02  -5.89642300E-02  -1.36691600E-02  +8.36024000E-03  +1.06700700E-02
   -4.64920000E-03  +1.09629000E-03  -3.07197000E-03  +1.53512000E-03  -6.19450000E-04
   +1.27650000E-03  +7.91900000E-05  +5.83100000E-05  +5.52700000E-05  -7.86500000E-04
   +1.46880000E-04  +6.52000000E-04  -1.88290000E-04  -5.43660000E-04  -3.68470000E-04
   -2.73820000E-04  +2.29700000E-05  -3.74040000E-04  -1.08950000E-04  -5.23400000E-05
   +2.12560000E-04  -1.21690000E-04  +4.40740000E-04  -8.65000000E-06  -1.32410000E-04
   -3.02020000E-04  +7.58100000E-05  +1.30230000E-04  +4.35200000E-04  +1.01980000E-04
   -7.26500000E-05  -3.23100000E-04  -7.78200000E-05  +3.24000000E-06  +3.26710000E-04
   -3.31550000E-04  +2.60400000E-05  -2.31780000E-04  +3.39800000E-05  +8.54000000E-05
   -1.23520000E-04  +2.79600000E-05  +6.61700000E-05  +1.00940000E-04  +6.14500000E-05
   +1.39469000E-03  -9.45380000E-04  +2.14145000E-03  -5.51948900E-02  +7.39775300E-02
   -1.02216000E-03  +3.18150000E-04  -4.25160000E-04  +5.03500000E-04  -5.86623000E-03
   +1.50218000E-03  +1.46122100E-02  -4.28684000E-03  -6.96036000E-03  +1.30369780E-01
   -5.79918000E-02  -1.55082290E-01  -5.84010000E-04  -1.28810000E-03  +3.36276000E-03
   +1.12483000E-03  -2.83494000E-03  +5.13575000E-03  +1.18010000E-04  +1.85577000E-03
   -1.65123000E-03  -2.72850000E-04  +5.79000000E-05  -3.87700000E-05  +1.52790000E-04
   +1.25650000E-04  -7.34600000E-05  +2.62600000E-05  +8.41100000E-05  +6.71000000E-06
   -4.14660000E-04  -5.04960000E-04  -1.58510000E-04  -2.77700000E-05  +3.58250000E-04
   +2.56290000E-04  -4.52760000E-04  +1.07940000E-04  +4.00900000E-05  +1.51280000E-04
   -6.01000000E-05  +1.28000000E-05  -3.10380000E-04  +2.65540000E-04  -2.20000000E-06
   +8.62600000E-05  -1.57290000E-04  -1.60600000E-05  +1.01840000E-04  -9.35300000E-05
   -3.35080000E-04  +7.45300000E-05  +1.91920000E-04  +1.53400000E-05  +2.28020000E-04
   -9.33000000E-06  +6.74500000E-05  -4.01600000E-05  -2.81200000E-05  -2.84100000E-05
   -1.34378000E-03  +2.35347000E-03  -1.93042000E-03  -1.43935010E-01  +6.71300700E-02
   +1.57067950E-01  +1.27695000E-03  -2.22154100E-02  -1.69416300E-02  -5.86074700E-02
   -2.30858200E-02  -9.05366000E-03  +7.86813000E-03  +1.77988000E-02  +1.28991200E-02
   -2.56370000E-03  +1.05220000E-04  +5.00613000E-03  -1.34929000E-03  -3.87900000E-05
   +9.71500000E-05  -2.72728000E-03  -3.96205000E-03  +2.55582000E-03  +4.13950000E-04
   +1.02352000E-03  -1.30708000E-03  -1.92176000E-03  -5.16960000E-04  +7.18940000E-04
   -7.93000000E-06  -1.14894000E-03  -9.19670000E-04  +2.52360000E-04  -6.66000000E-05
   -7.10800000E-05  -1.83080000E-04  -4.47000000E-05  -1.80250000E-04  +5.89400000E-05
   -7.53500000E-05  -6.09700000E-05  -8.64000000E-06  +1.25880000E-04  +4.95200000E-05
   -9.70000000E-07  -6.15900000E-05  -1.23100000E-05  -2.36300000E-05  +1.29930000E-04
   +8.22400000E-05  +1.51000000E-05  -1.21450000E-04  -3.55600000E-05  -3.74200000E-05
   -5.66000000E-06  +1.17030000E-04  +5.33200000E-05  -6.22300000E-05  -7.58300000E-05
   +4.01200000E-05  -3.29100000E-05  -6.92000000E-06  -3.56560000E-04  -1.88150000E-04
   -7.97200000E-05  -4.54300000E-05  +1.68750000E-04  -2.29500000E-04  +2.73910000E-04
   +1.03081000E-03  +7.93530000E-04  +5.95359900E-02  -4.44800000E-05  -9.16908000E-03
   -1.09262300E-02  -2.29345100E-02  -2.27115850E-01  -1.44720600E-01  -1.47353000E-03
   -2.67365000E-03  -5.03067000E-03  +2.06750000E-04  +2.93241000E-03  -3.22397000E-03
   +1.03060000E-04  +3.95100000E-05  +9.10210000E-04  -4.06315000E-03  +2.99762000E-03
   -2.06263000E-03  +2.54200000E-04  -2.09729000E-03  +1.33380000E-03  -2.24948000E-03
   -3.71700000E-04  +2.15420000E-04  -2.00400000E-04  -8.26320000E-04  -6.00140000E-04
   -3.50780000E-04  -1.33760000E-04  +7.45400000E-05  +2.90350000E-04  +3.75730000E-04
   -2.25830000E-04  +1.11290000E-04  -1.20250000E-04  +7.68900000E-05  -5.45200000E-05
   +4.11800000E-05  -8.97600000E-05  -1.65200000E-05  -5.20400000E-05  +7.58300000E-05
   +5.72300000E-05  +2.18400000E-05  -1.08230000E-04  -1.79600000E-05  +1.12800000E-05
   +3.94800000E-05  +7.66400000E-05  -1.64500000E-05  -1.68690000E-04  -4.51400000E-05
   +2.33100000E-05  +9.13800000E-05  +2.46200000E-05  -1.01600000E-05  +3.64500000E-05
   -1.11530000E-04  -1.47460000E-04  +9.36600000E-05  +1.39130000E-04  -3.16070000E-04
   +2.72990000E-04  -1.85820000E-04  -2.34290000E-04  -1.56070000E-04  +3.09237900E-02
   +2.38666310E-01  +1.54807000E-03  +1.05242000E-03  +4.10161000E-03  -8.86658000E-03
   -1.44934670E-01  -1.55402080E-01  -3.23173000E-03  -1.55899500E-02  -7.00426000E-03
   +5.11535000E-03  -2.92113000E-03  +1.41363000E-03  +1.32820000E-04  +9.67840000E-04
   -3.81410000E-04  +2.49138000E-03  -2.12813000E-03  +4.94469000E-03  -2.10434000E-03
   +8.21700000E-04  -1.97149000E-03  -7.18790000E-04  -7.76050000E-04  +4.67010000E-04
   -1.52160000E-04  -1.07090000E-04  +2.02600000E-05  +6.87830000E-04  +1.58380000E-04
   -1.49000000E-05  -2.87830000E-04  -2.09840000E-04  +1.86990000E-04  -8.62400000E-05
   +1.52000000E-04  -4.44000000E-06  +1.19000000E-06  -1.18160000E-04  +2.02100000E-05
   +4.43000000E-05  +9.25600000E-05  -5.29100000E-05  -9.03600000E-05  -6.80400000E-05
   +5.04800000E-05  +3.27000000E-05  +4.24200000E-05  -8.46000000E-06  -3.93200000E-05
   -1.21600000E-05  +5.57700000E-05  +2.62100000E-05  +2.97900000E-05  -1.97900000E-05
   +1.78000000E-06  +3.82900000E-05  -1.84000000E-06  -1.58700000E-05  +1.39230000E-04
   -7.72800000E-05  -2.57850000E-04  +2.44650000E-04  -3.85320000E-04  -1.91990000E-04
   -8.18840000E-04  -4.90480000E-04  +8.27899000E-03  +1.60554000E-01  +1.56325980E-01
   -2.10236350E-01  +5.10901200E-02  +1.37585210E-01  -1.40836700E-02  +8.98671000E-03
   +1.64847500E-02  -1.77790000E-03  -4.92259000E-03  +8.45110000E-04  -1.33010000E-04
   -3.61260000E-04  -8.12380000E-04  +1.56103000E-03  -1.98774000E-03  +5.94900000E-04
   +5.13901000E-03  -2.94147000E-03  -2.31482000E-03  -1.88400000E-04  +6.53890000E-04
   +7.68040000E-04  -3.23000000E-06  +1.05850000E-04  +4.81400000E-05  +2.45780000E-04
   +1.26800000E-03  -1.02300000E-03  -2.05950000E-04  -6.25600000E-05  -9.08200000E-05
   -4.71900000E-05  -2.64420000E-04  +6.36000000E-05  -8.86200000E-05  +1.08060000E-04
   -2.48800000E-05  +6.32300000E-05  -5.11300000E-05  +5.64200000E-05  -8.00000000E-08
   +5.81600000E-05  -4.22100000E-05  +1.07300000E-05  -9.40000000E-05  +1.47900000E-05
   -6.34000000E-06  +7.45000000E-05  -4.20000000E-06  -3.26800000E-05  -8.25000000E-06
   +4.86500000E-05  -1.91700000E-05  +2.68900000E-05  -8.46000000E-06  -3.76400000E-05
   +1.02800000E-05  -2.70000000E-05  -5.92700000E-05  +1.87890000E-04  -1.16420000E-04
   +2.71460000E-04  -7.74400000E-05  -2.76280000E-04  -1.30290000E-04  +2.16940000E-04
   -1.33590000E-04  +6.59900000E-05  +1.06117000E-03  -1.60697000E-03  +2.19703320E-01
   +4.98589900E-02  -7.18724100E-02  -5.75736700E-02  -1.27737300E-02  +8.15521000E-03
   +1.16890300E-02  -4.49944000E-03  +1.11148000E-03  -2.55322000E-03  -6.92440000E-04
   -1.23829000E-03  +2.03350000E-04  -2.38637000E-03  -1.93169000E-03  -4.97427000E-03
   +2.03007200E-02  -6.41960000E-04  -1.60574300E-02  -5.42060000E-04  +5.14580000E-04
   +2.46610000E-04  +9.31700000E-05  +4.13100000E-05  +5.90600000E-05  +1.06453000E-03
   +2.92370000E-04  +2.59876000E-03  -3.81100000E-05  +3.70300000E-05  -4.78300000E-05
   -1.80930000E-04  -2.31910000E-04  +2.51900000E-05  -5.48900000E-05  +6.52700000E-05
   +1.40800000E-05  +3.64600000E-05  -1.00900000E-05  +3.88800000E-05  -1.01300000E-05
   +2.46700000E-05  +1.22000000E-06  -1.59000000E-06  -2.07900000E-05  -1.09400000E-05
   +3.40000000E-07  +1.49200000E-05  +1.15400000E-05  +7.56000000E-06  -1.72100000E-05
   -4.39000000E-06  +3.57000000E-06  +8.03000000E-06  -4.49000000E-06  -9.94000000E-06
   +1.14000000E-06  -3.59000000E-06  +1.04890000E-04  +8.18100000E-05  +4.77340000E-04
   +9.92990000E-04  -3.31280000E-04  -7.16090000E-04  +1.86720000E-04  -1.87950000E-04
   +3.24310000E-04  +1.49308000E-03  -9.73600000E-04  +2.15383000E-03  -5.29342900E-02
   +6.71257500E-02  +1.36677810E-01  -5.82520800E-02  -1.58211640E-01  -1.62834000E-03
   -1.78200000E-04  +3.20885000E-03  +9.36370000E-04  -2.41946000E-03  +4.69205000E-03
   -1.09653000E-03  +2.65700000E-05  -4.43170000E-04  +1.94080000E-04  -5.21651000E-03
   +1.23502000E-03  +1.70307200E-02  -3.37671000E-03  -6.74440000E-03  +1.23600000E-05
   -1.61860000E-04  +3.01090000E-04  -1.31500000E-05  +4.22200000E-05  -6.03400000E-05
   -1.22530000E-03  +2.46270000E-03  -8.43390000E-04  -1.61500000E-05  -6.23500000E-05
   -2.07000000E-06  +1.10370000E-04  +9.46800000E-05  -4.73000000E-06  +2.82600000E-05
   -2.04400000E-05  -5.11000000E-06  -4.75300000E-05  +2.20000000E-07  -2.32800000E-05
   +2.18000000E-05  -8.77000000E-06  -5.32000000E-06  -1.99300000E-05  +1.12400000E-05
   +1.26500000E-05  +1.40300000E-05  -1.19200000E-05  -5.69000000E-06  -1.18800000E-05
   +1.69500000E-05  +1.89700000E-05  -1.77000000E-06  +2.16000000E-06  -1.30100000E-05
   +2.13500000E-05  +2.86000000E-06  +7.18000000E-06  -1.75180000E-04  +4.38880000E-04
   -9.75800000E-05  +6.26410000E-04  -1.34930000E-04  -5.64870000E-04  -1.36990000E-04
   +3.06820000E-04  -3.76920000E-04  -1.25366000E-03  +2.39428000E-03  -1.84225000E-03
   -1.50063300E-01  +6.41273800E-02  +1.59768240E-01  +1.01270000E-04  +9.26800000E-05
   -4.98200000E-05  +1.78850000E-04  +1.39640000E-04  +1.26490000E-04  +8.37500000E-04
   -1.38513000E-03  +1.77620000E-04  +3.07270000E-04  +2.23900000E-04  +1.40750000E-04
   -1.98860000E-04  +7.66000000E-06  -2.32300000E-05  +1.60000000E-07  -1.09020000E-04
   -1.35050000E-04  -1.01993000E-03  -7.95760000E-04  +8.46540000E-04  -1.28150000E-04
   -8.88200000E-05  +3.70520000E-04  +5.85300000E-05  +2.69500000E-05  +2.27400000E-05
   -2.28663790E-01  +1.28666530E-01  -3.80409000E-03  +4.88100000E-04  -3.24360000E-04
   +4.35380000E-04  -1.71650000E-04  +7.08600000E-05  +2.76320000E-04  +2.68860000E-04
   -9.96600000E-05  -1.02000000E-04  -1.19700000E-05  +2.41000000E-04  -1.09900000E-04
   -3.54400000E-05  -2.47550000E-04  +9.32200000E-05  +7.95000000E-06  +1.75640000E-04
   -1.51200000E-05  +1.21330000E-04  -3.63400000E-05  +3.27510000E-04  +7.61000000E-06
   +1.42200000E-05  -1.08900000E-04  -1.23080000E-04  +4.65400000E-05  -7.67800000E-05
   -1.05300000E-05  -2.13000000E-06  -4.39000000E-06  -1.92000000E-06  +1.21400000E-05
   -2.80000000E-06  +2.27900000E-05  -5.08500000E-05  +3.26400000E-05  +3.22000000E-05
   +2.69400000E-05  -1.03000000E-05  +2.36000000E-05  +1.17100000E-05  +4.91000000E-06
   +2.45045770E-01  -1.90530000E-04  -4.15000000E-05  +5.67700000E-05  -3.03180000E-04
   +1.40570000E-04  +1.90600000E-05  +1.03320000E-03  +6.13660000E-04  -2.64620000E-04
   -1.55780000E-04  -4.19160000E-04  -5.37240000E-04  +1.18650000E-04  +3.00800000E-05
   -4.83800000E-05  -2.32120000E-04  -5.78600000E-05  +1.40230000E-04  +1.35101000E-02
   -1.19533900E-02  +5.93130000E-04  -4.86880000E-04  +2.91820000E-04  -1.11119000E-03
   +1.95350000E-04  +1.53210000E-04  -1.41600000E-05  +1.26890800E-01  -1.35888290E-01
   +1.53283000E-03  -8.18020000E-04  -9.34840000E-04  +3.25130000E-03  -3.04200000E-04
   +1.29880000E-04  +3.79070000E-04  -1.53860000E-04  +2.52540000E-04  -8.52000000E-05
   +9.93000000E-06  -2.70800000E-05  +1.91800000E-05  -7.21000000E-05  +2.87560000E-04
   +1.23320000E-04  +4.50700000E-05  -2.12060000E-04  -5.14000000E-05  +1.18185000E-03
   -1.86130000E-04  -2.56980000E-04  -8.09500000E-05  -2.54050000E-04  +2.65630000E-04
   +1.72740000E-04  -2.59200000E-05  +6.24500000E-05  -8.69000000E-06  -3.79300000E-05
   -2.23000000E-06  +1.55300000E-05  -5.95000000E-06  +1.49100000E-05  +2.94300000E-05
   +1.37970000E-04  +1.25880000E-04  +2.94600000E-05  -1.88900000E-05  +6.26300000E-05
   +2.17000000E-06  -1.00800000E-05  +1.82000000E-06  -1.39394550E-01  +1.46544530E-01
   +2.06270000E-04  +1.05150000E-04  -3.82600000E-05  -1.01240000E-04  -9.77700000E-05
   +2.15980000E-04  -9.39210000E-04  -3.08620000E-04  +6.69860000E-04  +4.24320000E-04
   +7.65700000E-05  -3.79400000E-05  -4.23720000E-04  +2.05500000E-05  +9.55800000E-05
   +2.13930000E-04  -6.87400000E-05  -2.26380000E-04  -2.32608100E-02  +1.70067500E-02
   -2.64942000E-03  -1.04852000E-03  +1.04253000E-03  +1.30358000E-03  -2.09830000E-04
   -1.30610000E-04  +1.56900000E-05  -1.90642000E-03  +3.01320000E-04  -4.60398400E-02
   +1.31307000E-03  +1.91615000E-03  -5.04592000E-03  +6.78660000E-04  +2.12510000E-04
   -2.26540000E-04  +1.59400000E-05  -1.04250000E-04  +2.01390000E-04  -4.41800000E-05
   -4.71500000E-05  +5.40900000E-05  +8.49000000E-05  -8.51100000E-05  -1.41110000E-04
   -3.89800000E-05  +7.56100000E-05  +6.08900000E-05  -1.46293000E-03  +1.05729000E-03
   +2.91740000E-04  +1.56480000E-04  +2.13040000E-04  -3.61000000E-04  -1.89400000E-05
   -9.52000000E-06  +1.41200000E-05  +1.73900000E-05  +1.85400000E-05  +1.61400000E-05
   +8.07000000E-06  -1.63400000E-05  +1.75000000E-06  +2.42700000E-05  -3.78000000E-06
   +5.32400000E-05  +2.48400000E-05  -2.34500000E-05  -1.11350000E-04  -2.14000000E-06
   +1.00500000E-05  +9.06000000E-06  +2.74766000E-03  -4.86917000E-03  +5.19419100E-02
   -3.49100000E-05  -5.85900000E-05  -6.09200000E-05  +5.26140000E-04  -2.75610000E-04
   -1.28870000E-04  +5.30900000E-04  -6.58540000E-04  +7.15650000E-04  +2.67620000E-04
   +3.93560000E-04  +4.23090000E-04  -2.35220000E-04  +1.50900000E-05  +6.61900000E-05
   +3.32850000E-04  +1.46920000E-04  -7.37300000E-05  +1.52910000E-04  +1.04436000E-03
   -2.19360000E-04  +3.79620000E-04  +2.43510000E-04  -4.53540000E-04  -3.40360000E-04
   -2.17890000E-04  +1.19000000E-05  -2.19102370E-01  -1.26232990E-01  +1.58185200E-02
   -1.96040000E-04  +9.62000000E-05  +1.82780000E-04  -6.36700000E-04  +1.05849000E-03
   +2.77670000E-04  +3.95900000E-05  +6.20300000E-05  -2.20630000E-04  +3.25300000E-05
   +1.25080000E-04  -4.05600000E-05  -1.10670000E-04  -1.77700000E-05  +9.87000000E-05
   +4.39300000E-05  +6.73000000E-06  -2.77500000E-05  +1.03390000E-04  -1.86290000E-04
   -2.59800000E-05  +2.97500000E-05  -1.28600000E-05  +4.91400000E-05  +4.31700000E-05
   +2.49700000E-05  +1.81500000E-05  +2.99300000E-05  +4.54200000E-05  +1.45500000E-05
   -3.16500000E-05  -1.59700000E-05  -1.84300000E-05  -3.08000000E-06  -1.34400000E-05
   -2.55000000E-05  -4.39900000E-05  +6.38800000E-05  +1.35000000E-06  -2.57200000E-05
   -2.84000000E-06  +2.50000000E-07  -1.95482500E-02  -1.63583600E-02  +1.44570000E-03
   +2.38474370E-01  -6.26390000E-04  -3.81770000E-04  -2.98130000E-04  +4.82660000E-04
   -4.17340000E-04  -2.25340000E-04  +1.29830000E-04  -7.57340000E-04  +3.35302000E-03
   -3.57790000E-04  -1.11760000E-04  +2.52880000E-04  +3.20370000E-04  +1.34790000E-04
   -6.81000000E-06  +1.48170000E-04  +5.37390000E-04  +4.18720000E-04  -1.34570200E-02
   -9.89001000E-03  -1.95000000E-05  +1.26100000E-04  +4.16600000E-04  -1.34609000E-03
   -4.34560000E-04  -3.04360000E-04  -4.74600000E-05  -1.25172060E-01  -1.39678380E-01
   +1.15282100E-02  -7.15920000E-04  +5.24910000E-04  -2.66990000E-04  +1.07010000E-04
   -3.66870000E-04  +5.01770000E-04  +1.87810000E-04  -6.27700000E-05  -2.52710000E-04
   +5.38300000E-05  +3.47600000E-04  -1.33070000E-04  -8.70300000E-05  -3.21450000E-04
   +9.86700000E-05  +3.10800000E-05  +2.36040000E-04  -1.82100000E-05  +1.58230000E-04
   -8.80200000E-05  +2.25660000E-04  -3.64500000E-05  +1.24560000E-04  -7.26400000E-05
   -7.82800000E-05  +7.79200000E-05  -7.56000000E-05  +2.84300000E-05  +4.15400000E-05
   +3.03600000E-05  -1.99800000E-05  -4.21900000E-05  -1.26800000E-05  -5.58000000E-05
   +1.91830000E-04  -1.41670000E-04  +3.90500000E-05  -2.06200000E-05  +1.32310000E-04
   -7.84400000E-05  +4.05000000E-06  -4.01900000E-05  +1.52796700E-02  +1.22821200E-02
   -1.57343000E-03  +1.37413940E-01  +1.49450960E-01  +1.88580000E-04  -1.41390000E-04
   +3.19920000E-04  +4.74780000E-04  +5.86050000E-04  +9.74600000E-05  -1.05090000E-03
   +2.19672000E-03  -4.31485000E-03  +3.78700000E-05  -3.52950000E-04  -6.68300000E-05
   +6.30020000E-04  -1.04870000E-04  +6.74300000E-05  -4.50900000E-04  -7.20300000E-05
   +1.42550000E-04  +2.34141500E-02  +1.55033800E-02  -2.93304000E-03  +1.18413000E-03
   +8.47490000E-04  +1.25820000E-03  +5.30770000E-04  +3.76370000E-04  -2.73200000E-05
   +1.52257200E-02  +1.03163400E-02  -4.98365200E-02  +3.03340000E-04  -5.17360000E-04
   +5.94870000E-04  -4.85100000E-04  -1.93740000E-04  +3.98210000E-04  -3.37400000E-05
   +6.63500000E-05  +7.57300000E-05  +3.95000000E-06  -4.73300000E-05  +2.18000000E-06
   -2.15000000E-06  +9.12600000E-05  +2.28500000E-05  -2.50000000E-06  -6.72600000E-05
   -1.19600000E-05  -2.06300000E-05  -1.26230000E-04  -1.76110000E-04  +1.91900000E-05
   -6.54800000E-05  +3.07100000E-05  -5.60000000E-07  -3.52600000E-05  -3.38900000E-05
   -1.22700000E-05  -4.32800000E-05  -4.79600000E-05  +4.31700000E-05  +3.26600000E-05
   +1.77700000E-05  -2.04350000E-04  +3.47220000E-04  -1.00810000E-04  -2.48400000E-05
   +8.35000000E-05  -1.80890000E-04  +7.12800000E-05  +2.32600000E-05  -7.17000000E-06
   -1.34230000E-04  -3.25970000E-04  -9.16470000E-04  -1.77901500E-02  -1.44087400E-02
   +5.26267300E-02  +1.44230000E-04  +8.85100000E-05  +5.98400000E-05  -2.21850000E-04
   -4.52300000E-05  +9.56700000E-05  +1.23160000E-04  +7.49470000E-04  +4.13050000E-04
   -7.61000000E-05  -1.28270000E-04  +4.30300000E-05  -2.60210000E-04  -4.91700000E-05
   -4.72500000E-05  -1.72200000E-05  -1.37590000E-04  -8.35500000E-05  -1.98411000E-03
   -1.09250000E-04  -3.32940000E-04  -7.39700000E-05  +2.36210000E-04  -2.40080000E-04
   +6.50800000E-05  +4.65100000E-05  -8.70000000E-06  -4.75306100E-02  -6.70156000E-03
   -7.30229000E-03  +4.00960000E-04  -5.36700000E-04  -6.21080000E-04  -1.23520000E-04
   +3.04840000E-04  -4.06290000E-04  -1.46710000E-04  +7.72200000E-05  +5.03000000E-05
   -3.15000000E-05  -1.76050000E-04  +1.29680000E-04  +7.58800000E-05  +2.19510000E-04
   -1.10340000E-04  -1.97900000E-05  -1.50510000E-04  +2.16800000E-05  -1.92000000E-06
   +4.62000000E-05  -7.58800000E-05  -4.58000000E-06  -7.91400000E-05  +4.62000000E-05
   +1.36790000E-04  -3.00100000E-05  +1.09010000E-04  -1.17500000E-05  -2.05100000E-05
   +9.36000000E-06  +1.72500000E-05  -1.30700000E-05  +2.09500000E-05  +1.91900000E-04
   -2.29380000E-04  +1.39560000E-04  +2.91400000E-05  -8.50000000E-07  -6.85500000E-05
   +7.00000000E-08  +5.54000000E-06  -8.23000000E-06  +1.60848000E-03  +1.59647400E-02
   +2.16650400E-02  -1.87180000E-04  -1.53323400E-02  -2.11975400E-02  +4.83542100E-02
   +7.19600000E-05  +8.44400000E-05  +9.05700000E-05  -8.40900000E-05  +3.14000000E-06
   -1.05230000E-04  +3.99750000E-04  +8.22780000E-04  +6.38600000E-05  -3.60640000E-04
   -3.31900000E-05  +6.05940000E-04  +8.02000000E-05  -1.34110000E-04  -8.19000000E-05
   -3.56400000E-05  -5.07200000E-05  -7.90300000E-05  +3.23930000E-04  +1.01147800E-02
   +1.35929800E-02  +8.48500000E-05  -1.23490000E-03  +2.48279000E-03  +1.45410000E-04
   +7.73600000E-05  -2.10000000E-07  -6.86008000E-03  -1.51051410E-01  -1.32039220E-01
   +2.84800000E-05  +7.37580000E-04  -7.43800000E-05  +7.27320000E-04  +1.71280000E-04
   +5.58400000E-05  +8.12000000E-06  -7.25200000E-05  +2.99100000E-05  -3.74000000E-05
   -1.69200000E-05  +1.04500000E-05  +2.84900000E-05  -1.92700000E-05  -2.02700000E-05
   -1.62600000E-05  +1.62500000E-05  +1.06300000E-05  -3.32590000E-04  +2.99100000E-05
   -9.78100000E-05  +1.24300000E-05  +2.01900000E-05  -1.08400000E-05  -2.74600000E-05
   +1.93600000E-05  +1.83300000E-05  -1.63100000E-05  -1.09500000E-05  -1.39200000E-05
   +1.51000000E-06  +8.32000000E-06  +1.69700000E-05  -6.36300000E-05  -6.14820000E-04
   +1.87700000E-04  +4.69000000E-06  -1.04900000E-05  +2.58300000E-05  +9.86000000E-06
   -4.58000000E-06  +1.58000000E-06  -2.10545000E-03  -1.10782400E-02  -1.37071100E-02
   +1.29475000E-03  -1.09432300E-02  -1.36320500E-02  +6.25444000E-03  +1.62544990E-01
   -4.82540000E-04  -4.04140000E-04  -9.81800000E-05  +8.64570000E-04  -3.79000000E-06
   -2.51420000E-04  -1.52880000E-03  -7.09530000E-04  +7.94400000E-04  +1.22860000E-04
   -6.29750000E-04  -6.08000000E-05  +5.99130000E-04  +3.08860000E-04  +1.56610000E-04
   -1.93390000E-04  +4.44670000E-04  +4.18920000E-04  -8.67030000E-04  -1.76260200E-02
   -2.10044600E-02  +3.06490000E-04  +4.41815000E-03  -4.75457000E-03  -9.08000000E-05
   -4.31000000E-05  -1.93100000E-05  -6.85621000E-03  -1.29632520E-01  -2.12644970E-01
   +1.20246000E-03  -1.16313000E-03  +7.76090000E-04  -1.68920000E-04  +2.03520000E-04
   +4.56060000E-04  -1.77810000E-04  -7.78100000E-05  +1.39790000E-04  +1.21400000E-05
   -2.81000000E-06  +3.78000000E-05  -3.80200000E-05  +6.66600000E-05  -3.31600000E-05
   +1.81800000E-05  -3.06300000E-05  +2.27900000E-05  +2.05610000E-04  +3.27220000E-04
   -1.02250000E-04  +9.79000000E-06  -7.07500000E-05  +6.19100000E-05  +1.11520000E-04
   +9.53000000E-06  +7.61800000E-05  +2.55000000E-05  +1.44400000E-05  -6.00000000E-07
   +3.60300000E-05  -1.07000000E-06  -6.83000000E-06  -1.47670000E-04  +5.94540000E-04
   +6.02500000E-05  -1.32630000E-04  +4.07700000E-05  +7.75000000E-05  -5.31000000E-06
   +1.30700000E-05  -2.21100000E-05  +3.55800000E-05  +1.21199000E-03  +1.04435000E-03
   -3.46700000E-05  +2.77056000E-03  +2.99904000E-03  +8.12024000E-03  +1.41232620E-01
   +2.32745110E-01  -1.06750000E-04  +4.26100000E-05  +2.13470000E-04  -8.33100000E-05
   -4.07950000E-04  -4.82930000E-04  +3.95330000E-04  +5.20370000E-04  -4.28680000E-04
   -6.65200000E-05  -6.67200000E-05  -3.08300000E-05  +1.43900000E-04  +8.59400000E-05
   +9.18000000E-06  -9.98700000E-05  -1.99000000E-06  +4.50200000E-05  -1.90008000E-03
   +1.85637000E-03  -3.19109000E-03  -4.80964800E-02  -6.86925000E-03  +1.42582400E-02
   +1.17590000E-04  +1.10570000E-04  +1.85600000E-05  -7.74900000E-05  -6.84980000E-04
   -7.05990000E-04  +7.44400000E-05  -3.68430000E-04  +5.89270000E-04  -5.29600000E-05
   +6.53500000E-05  -2.25000000E-05  +2.28400000E-05  +1.90500000E-05  +9.11200000E-05
   +2.26300000E-05  -1.30100000E-05  -6.32800000E-05  -4.40100000E-05  +1.19880000E-04
   +1.44250000E-04  +2.30300000E-05  -1.00040000E-04  -5.12300000E-05  -1.89190000E-04
   +3.32120000E-04  +1.56210000E-04  -2.00400000E-05  -1.45600000E-05  -1.30090000E-04
   +4.92000000E-06  -2.77000000E-06  -7.90800000E-05  -1.04600000E-05  -1.27400000E-05
   -4.19000000E-06  +1.43200000E-05  +1.22600000E-05  +1.18700000E-05  -1.01900000E-05
   +5.41400000E-05  +3.22400000E-05  -1.28121000E-03  +2.10980000E-04  -4.21470000E-04
   -1.20400000E-05  +5.20000000E-07  -2.37800000E-05  +2.57870000E-04  -2.47160000E-04
   +3.12470000E-04  +1.91250000E-04  +2.76690000E-04  -2.33990000E-04  +6.45570000E-04
   +1.35380000E-04  -2.92870000E-04  +4.82852800E-02  -5.42100000E-05  -2.13820000E-04
   -1.21510000E-04  -5.35140000E-04  +4.05100000E-04  +1.78930000E-04  +3.14190000E-04
   +1.01213000E-03  +5.19990000E-04  +2.04030000E-04  -1.93530000E-04  -8.92000000E-06
   +1.77140000E-04  +5.03000000E-05  -6.19900000E-05  -1.30840000E-04  +6.59300000E-05
   +1.96000000E-04  +1.49540000E-03  +1.07873200E-02  -1.89170500E-02  -6.54565000E-03
   -9.94665600E-02  +1.05845510E-01  +7.00800000E-05  +8.19000000E-06  -3.19200000E-05
   -2.67440000E-04  -2.72653000E-03  -2.76200000E-03  -1.72430000E-04  +8.91240000E-04
   +3.83160000E-04  +8.01600000E-05  -2.17900000E-05  +7.03000000E-05  +1.29240000E-04
   -8.30400000E-05  -2.90600000E-05  -8.50100000E-05  +2.61700000E-05  +2.84700000E-05
   +2.03370000E-04  -8.19000000E-05  -1.02760000E-04  -7.95300000E-05  +1.38920000E-04
   +4.91400000E-05  +5.30320000E-04  -1.25103000E-03  -9.48390000E-04  -1.30710000E-04
   +4.66300000E-05  +2.58910000E-04  -1.06530000E-04  +6.23000000E-06  -4.08400000E-05
   -1.22600000E-05  -8.69000000E-06  -6.01000000E-06  +8.65000000E-06  +1.90500000E-05
   -1.72900000E-05  -9.71000000E-06  +1.57800000E-05  -3.21000000E-05  -2.41980000E-04
   -2.25400000E-04  -1.54340000E-04  -9.26000000E-06  +2.90300000E-05  -2.57400000E-05
   -2.57140000E-04  +3.94000000E-06  -1.32680000E-04  +2.54370000E-04  -2.49200000E-05
   -1.24010000E-04  -7.67800000E-05  +7.66280000E-04  -1.20887000E-03  +7.35286000E-03
   +1.08461730E-01  -2.87810000E-04  -1.01340000E-04  +2.12420000E-04  +2.80990000E-04
   -3.38260000E-04  +5.18900000E-05  +1.00741000E-03  +9.62480000E-04  +7.58180000E-04
   -1.21160000E-04  -4.69310000E-04  +4.99300000E-05  +2.10360000E-04  +1.28550000E-04
   -1.35600000E-05  -8.07900000E-05  +1.89970000E-04  +1.04930000E-04  +1.40381000E-03
   +1.14897500E-02  -1.94549200E-02  +1.37839000E-02  +1.04398340E-01  -2.64221470E-01
   -1.76300000E-05  -3.76000000E-06  +1.93100000E-05  -3.07730000E-04  -4.85938000E-03
   -3.11701000E-03  -8.01290000E-04  +9.03350000E-04  -2.21280000E-04  +3.28320000E-04
   -2.65410000E-04  -3.15700000E-05  -4.03700000E-05  +2.69200000E-04  -1.49630000E-04
   -1.50630000E-04  -2.10540000E-04  +3.27080000E-04  +1.77440000E-04  -2.22000000E-05
   -6.07890000E-04  -9.66700000E-05  +1.25910000E-04  +1.79800000E-04  +7.75610000E-04
   +6.53310000E-04  -6.24080000E-04  -3.97000000E-04  +8.64000000E-06  +7.16580000E-04
   +1.64800000E-05  -9.05700000E-05  +1.00670000E-04  -5.99000000E-06  +8.67000000E-06
   -9.36000000E-06  -2.67900000E-05  +1.67600000E-05  -3.41900000E-05  -1.33500000E-05
   +1.06190000E-04  +1.72900000E-05  -4.28990000E-04  +3.08450000E-04  +7.18200000E-05
   -2.46200000E-05  -2.76300000E-05  -1.29000000E-06  -5.86000000E-06  -2.45700000E-05
   +2.74170000E-04  +2.02300000E-05  -8.08800000E-05  +3.92500000E-04  -8.38300000E-05
   +7.52420000E-04  -1.49603000E-03  -1.48889800E-02  -1.14143780E-01  +2.87730890E-01
   +1.35590000E-04  -1.65340000E-04  -2.03710000E-04  -1.33380000E-04  +1.76380000E-04
   +3.21390000E-04  +7.79580000E-04  -5.11800000E-05  -2.19500000E-04  -5.51600000E-05
   +1.43350000E-04  +2.41100000E-04  -7.56500000E-05  -1.06740000E-04  -1.03330000E-04
   +1.28270000E-04  +7.93500000E-05  -2.52200000E-05  -3.29002000E-03  -6.20500000E-04
   +9.58800000E-04  -2.63961160E-01  -1.07383620E-01  +2.04425000E-02  -1.88260000E-04
   -1.58840000E-04  -2.38400000E-05  -9.62800000E-05  +2.09460000E-04  +4.06220000E-04
   +6.20690000E-04  +1.22680000E-03  +3.34650000E-04  +5.16420000E-04  +1.41900000E-05
   +6.94400000E-05  -2.22600000E-05  -9.47200000E-05  -1.13390000E-04  +4.05900000E-05
   +2.27200000E-05  -3.82800000E-05  -7.18200000E-05  -1.43700000E-05  +5.65900000E-05
   +3.63600000E-05  -6.55000000E-06  -1.41400000E-05  +5.69000000E-06  -1.73420000E-04
   +7.96000000E-05  -1.55000000E-05  +2.33500000E-05  -4.51700000E-05  +3.38100000E-05
   +1.69800000E-05  +1.66400000E-05  +1.98400000E-05  +2.23000000E-05  +7.91000000E-06
   -3.68100000E-05  -1.86700000E-05  -1.29100000E-05  +7.43200000E-05  -6.39300000E-05
   -4.84900000E-05  +2.10510000E-04  -2.01910000E-04  -4.10190000E-04  -9.77000000E-06
   -1.24000000E-06  +1.55800000E-05  +2.38800000E-05  -1.10590000E-04  +6.48600000E-05
   +3.15220000E-04  +2.33370000E-04  -5.58720000E-04  +3.15400000E-04  +2.09740000E-04
   -3.90000000E-05  -2.53090000E-04  +6.22720000E-04  -2.02550000E-04  +2.83564830E-01
   -1.01610000E-04  +1.92820000E-04  +9.55300000E-05  +6.27700000E-04  -9.12000000E-05
   -5.44700000E-04  +9.88780000E-04  -2.20937000E-03  -3.90391000E-03  -1.38261000E-03
   -1.08110000E-04  +2.23900000E-04  -6.91000000E-05  -3.70750000E-04  -8.84100000E-05
   +3.05430000E-04  +4.76900000E-05  -1.15390000E-04  -1.94031300E-02  -1.21927800E-02
   +1.46894000E-03  -1.05409280E-01  -9.84081300E-02  +1.12675300E-02  -2.58810000E-04
   -1.26320000E-04  +3.72300000E-05  +3.40270000E-04  +2.79060000E-04  +1.21265000E-03
   -1.80970000E-03  +1.80300000E-04  +4.69520000E-04  +5.03190000E-04  +4.01590000E-04
   +4.34400000E-05  +9.66100000E-05  -3.96780000E-04  -1.58440000E-04  +6.63500000E-05
   +2.75060000E-04  -1.39690000E-04  -1.01070000E-04  -2.91740000E-04  +1.45990000E-04
   +3.20100000E-05  +1.83280000E-04  -2.78900000E-05  -1.28130000E-04  -3.03380000E-04
   +3.93890000E-04  +1.08420000E-04  +2.77200000E-05  -7.69700000E-05  -6.17000000E-05
   +1.38220000E-04  +3.86500000E-05  +3.59300000E-05  +3.23600000E-05  +1.30600000E-05
   -9.66200000E-05  -1.09280000E-04  +3.38200000E-05  -4.85000000E-06  +3.44100000E-05
   -7.54000000E-05  +8.65400000E-05  +5.45100000E-05  +3.86710000E-04  -4.19000000E-05
   -6.05000000E-06  -7.87000000E-06  +1.25870000E-04  +5.67400000E-05  -2.20100000E-05
   +1.40450000E-04  +5.92510000E-04  -1.84480000E-04  +2.41870000E-04  -2.37700000E-05
   +8.84700000E-05  -1.23429500E-02  -6.42321000E-03  +4.70470000E-04  +1.16791230E-01
   +1.07110520E-01  -1.94270000E-04  -8.95000000E-06  +2.09010000E-04  +7.95490000E-04
   -4.15120000E-04  -3.50790000E-04  +8.69540000E-04  -2.70519000E-03  -3.65323000E-03
   -1.40801000E-03  -7.08340000E-04  +3.89350000E-04  +1.35700000E-04  -2.49520000E-04
   -1.99110000E-04  +7.18000000E-05  +1.21590000E-04  -1.35000000E-06  -2.18677400E-02
   -1.11192000E-02  +3.63620000E-04  +2.21980300E-02  +1.21563300E-02  -4.96407200E-02
   -1.00920000E-04  -2.35300000E-05  +2.61100000E-05  -1.24765000E-03  -6.77480000E-04
   +1.19253000E-03  -9.32230000E-04  +3.51220000E-04  +9.36160000E-04  +5.81600000E-05
   +2.43000000E-04  +1.62040000E-04  +2.38440000E-04  -1.51790000E-04  +3.47400000E-05
   -4.47700000E-05  +7.93000000E-05  -6.46400000E-05  +4.66000000E-06  -9.58800000E-05
   +6.23000000E-06  -6.55000000E-06  +1.06270000E-04  +4.90000000E-06  +1.22080000E-04
   +4.03700000E-05  -2.54710000E-04  -1.48560000E-04  +7.10800000E-05  +9.39700000E-05
   -1.46990000E-04  +1.28200000E-05  -1.35170000E-04  +1.60800000E-05  +1.49300000E-05
   +1.76000000E-06  -1.14730000E-04  -5.57100000E-05  -1.94700000E-05  -6.47000000E-06
   +3.38900000E-05  -6.03000000E-06  -5.01600000E-05  +5.48170000E-04  +1.30830000E-04
   -1.94900000E-05  -2.90200000E-05  +1.40500000E-05  +4.93700000E-05  -1.18200000E-05
   -7.08500000E-05  +2.92760000E-04  +2.09080000E-04  -7.17960000E-04  +2.76810000E-04
   +1.65910000E-04  +2.18960000E-04  +2.66897600E-02  +1.16642100E-02  -1.25380000E-03
   -2.31366100E-02  -8.34497000E-03  +5.33966400E-02  +5.02600000E-05  -1.26350000E-04
   -1.60340000E-04  -7.84830000E-04  -8.11560000E-04  +5.06140000E-04  +6.72100000E-05
   +7.17400000E-05  +4.04970000E-04  +6.44400000E-05  +3.20300000E-05  -4.01500000E-05
   +1.00750000E-04  +4.61600000E-05  -2.53500000E-05  -2.02640000E-04  +1.98900000E-05
   +3.37700000E-05  +2.47882000E-03  -3.25030000E-03  +7.84900000E-05  -1.81670460E-01
   +1.34446580E-01  -1.19856700E-02  +1.23810000E-04  +5.13800000E-05  -1.81400000E-05
   +3.54590000E-04  -3.36330000E-04  -2.12080000E-04  -5.48000000E-06  -2.96900000E-05
   +2.76130000E-04  +6.77930000E-04  +3.27310000E-04  -1.21810000E-04  +1.63810000E-04
   -1.62200000E-04  +1.91000000E-06  -1.03200000E-05  +1.35640000E-04  -7.39500000E-05
   +3.45800000E-05  -1.89070000E-04  +4.92800000E-05  -1.50000000E-05  +1.45320000E-04
   -1.22000000E-06  -5.16600000E-05  -3.07860000E-04  +1.60350000E-04  +2.03000000E-06
   +4.86900000E-05  -5.48900000E-05  -5.23600000E-05  +4.69900000E-05  +1.47900000E-05
   -1.89000000E-05  -1.54200000E-05  -5.29000000E-06  +1.68700000E-05  +1.99200000E-05
   -2.16000000E-06  -7.02000000E-06  +1.12600000E-05  +1.11800000E-05  -1.00248000E-03
   -1.66406000E-03  +2.22530000E-04  +2.91100000E-05  -1.44300000E-05  +2.85400000E-05
   +2.77960000E-04  -5.17600000E-05  +2.35790000E-04  -2.23660000E-04  +1.40310000E-04
   +5.90800000E-05  +1.15880000E-04  -2.49200000E-04  +8.17600000E-05  +1.60926000E-03
   -3.05067000E-03  +3.16710000E-04  -1.86371600E-02  +2.08545000E-02  -2.50310000E-03
   +1.96645810E-01  -3.32820000E-04  +2.78650000E-04  +3.43110000E-04  +1.93300000E-04
   -4.79530000E-04  -7.26250000E-04  +6.28650000E-04  +6.29910000E-04  +3.97310000E-04
   -2.82290000E-04  -1.08240000E-04  -1.32230000E-04  +1.62010000E-04  +1.66250000E-04
   +3.29200000E-05  -4.92500000E-05  +6.10000000E-07  +8.60800000E-05  +1.57332100E-02
   -1.59170100E-02  +1.37139000E-03  +1.33306880E-01  -1.79257500E-01  +1.17853700E-02
   +1.03510000E-04  +1.38700000E-04  +4.43000000E-05  +1.62110000E-04  +6.76160000E-04
   +1.66871000E-03  -1.51135000E-03  -1.63715000E-03  -3.71470000E-03  +6.04170000E-04
   -5.67860000E-04  +1.62060000E-04  -2.32000000E-04  +7.58010000E-04  +1.90500000E-05
   +1.51000000E-05  -2.19850000E-04  +1.33850000E-04  +8.79600000E-05  +4.32020000E-04
   -7.32000000E-06  +6.20000000E-07  -3.16870000E-04  -2.41000000E-05  +5.44500000E-05
   +1.37280000E-04  -1.01170000E-04  +2.90900000E-05  -6.05600000E-05  -9.13600000E-05
   +3.96100000E-04  -1.20170000E-04  +1.54790000E-04  -3.87000000E-06  -1.55700000E-05
   +4.80000000E-07  +1.26400000E-05  -2.92000000E-06  +2.21400000E-05  +4.05000000E-05
   +8.68300000E-05  +1.24220000E-04  -1.15896000E-03  -5.47360000E-04  +8.19140000E-04
   -1.63000000E-05  -3.31200000E-05  -8.94000000E-06  -3.13460000E-04  +5.99070000E-04
   -5.06380000E-04  -9.91900000E-05  -2.74300000E-05  -1.35670000E-04  -3.21980000E-04
   +8.02300000E-05  +1.83970000E-04  +9.42853000E-03  -9.62028000E-03  +1.57020000E-04
   -1.05714600E-02  +1.13636200E-02  -1.13982000E-03  -1.46075910E-01  +1.93680650E-01
   -8.24800000E-05  -1.83330000E-04  -1.37260000E-04  -3.16060000E-04  +5.36200000E-04
   +4.38930000E-04  +9.76800000E-05  +6.34540000E-04  +5.56310000E-04  +3.08600000E-05
   -3.19800000E-05  -2.14530000E-04  +1.02570000E-04  +5.29600000E-05  -3.45200000E-05
   -1.18030000E-04  +6.62100000E-05  +1.40240000E-04  +1.81229700E-02  -1.77179900E-02
   -4.68310000E-04  -1.20829700E-02  +1.29750300E-02  -4.75349700E-02  +3.68800000E-05
   -6.03000000E-06  -2.84500000E-05  +1.07649000E-03  -8.99010000E-04  +1.09419000E-03
   -1.50114000E-03  -2.12037000E-03  -4.18186000E-03  +8.77300000E-04  -9.19100000E-04
   +1.53300000E-05  -2.24970000E-04  +1.03622000E-03  +3.42500000E-05  -8.64200000E-05
   -3.13610000E-04  +3.65010000E-04  +2.42040000E-04  +2.08680000E-04  -5.33450000E-04
   -8.69200000E-05  -7.91100000E-05  +1.32240000E-04  +4.52020000E-04  +3.14010000E-04
   -2.70330000E-04  -1.87640000E-04  +4.50600000E-05  +3.71520000E-04  +4.04850000E-04
   -2.14270000E-04  +2.08010000E-04  -6.85000000E-06  -1.07200000E-05  -2.38000000E-06
   +1.68200000E-05  -1.06500000E-05  +6.19000000E-06  +4.41900000E-05  -8.20000000E-07
   +3.18300000E-05  +2.89430000E-04  +1.65040000E-04  +1.15500000E-04  +8.54000000E-06
   +3.40000000E-07  +1.17500000E-05  -5.06530000E-04  -3.38000000E-06  -6.93130000E-04
   +9.88500000E-05  +1.03900000E-04  -4.62200000E-05  -1.14590000E-04  +1.98650000E-04
   +3.67780000E-04  -2.14522600E-02  +1.99189800E-02  -8.44340000E-04  +2.27556000E-03
   -2.42770000E-03  -7.45120000E-04  +1.28225900E-02  -1.06389200E-02  +5.16496600E-02
   +1.97000000E-05  -9.39000000E-06  +3.98100000E-05  -6.09700000E-05  -3.95100000E-05
   -1.16000000E-04  -4.41330000E-04  +3.73080000E-04  -1.18030000E-04  -4.18900000E-05
   +1.48160000E-04  +1.24580000E-04  -1.30100000E-05  -4.74000000E-06  -5.10200000E-05
   -1.40200000E-05  -8.68000000E-06  +7.40000000E-06  -1.05735000E-03  -2.90805000E-03
   -1.71662000E-03  +5.31540000E-04  -1.66780000E-04  -1.12250000E-04  +2.47900000E-05
   +9.33000000E-06  -9.54000000E-06  -1.62628000E-03  +9.62570000E-04  +7.09700000E-04
   +5.00658000E-03  -1.61631900E-02  +1.96665400E-02  -5.11193200E-02  +6.28394000E-03
   +5.85208000E-03  +3.24508000E-03  +1.59377200E-02  -1.75368000E-02  -1.35842000E-03
   +3.12364000E-03  -1.03892000E-03  -1.28382000E-03  -2.49300000E-04  +1.87474000E-03
   +4.54760000E-04  +2.57000000E-04  -5.29300000E-04  -1.59059000E-03  +5.12755000E-03
   +5.57284000E-03  +1.37470000E-04  +8.21200000E-05  -6.65920000E-04  -2.50162000E-03
   +5.11200000E-04  -6.45800000E-05  -7.26000000E-06  -6.98000000E-06  +5.81000000E-06
   +1.12000000E-06  -4.30000000E-06  +8.96000000E-06  +7.09500000E-05  -7.20500000E-05
   +3.89400000E-05  -5.84000000E-06  -6.98000000E-06  +1.96000000E-06  +2.33000000E-06
   -1.32500000E-05  +6.84000000E-06  +2.08950000E-04  -1.95420000E-04  -1.30720000E-04
   -7.74190000E-04  +1.31764000E-03  -5.98500000E-05  -1.51222000E-03  +3.54780000E-04
   -6.11020000E-04  +2.14200000E-05  -5.15500000E-05  -1.47350000E-04  +3.94000000E-05
   -4.65800000E-05  +1.84000000E-05  -7.36000000E-05  -7.39500000E-05  -7.23600000E-05
   +5.43935100E-02  -1.34100000E-05  -3.40200000E-05  +2.17400000E-05  -1.37940000E-04
   -1.42990000E-04  -1.37630000E-04  -5.39480000E-04  +6.09210000E-04  +3.09600000E-04
   -9.35600000E-05  +1.56180000E-04  +2.03630000E-04  -1.70500000E-05  -4.39600000E-05
   -4.10000000E-05  +5.00500000E-05  +5.90100000E-05  +2.73000000E-06  -2.03297000E-03
   -3.89991000E-03  -2.58273000E-03  +1.02964000E-03  -6.50810000E-04  +9.66800000E-05
   -6.71100000E-05  -6.29300000E-05  -1.29400000E-05  +2.52151000E-03  -3.37070000E-04
   -3.30500000E-04  +1.79053000E-03  +5.01147000E-03  +2.07541000E-03  +4.24709000E-03
   -1.68030520E-01  +1.50787080E-01  -1.69818000E-03  -5.75006000E-03  +1.40221200E-02
   +1.78129000E-03  -3.24341000E-03  -5.77900000E-05  +1.56433000E-03  +9.27110000E-04
   -1.11567000E-03  -4.81510000E-04  -4.76130000E-04  +2.22290000E-04  +2.80457000E-03
   +6.01128000E-03  +4.60843000E-03  -1.27550000E-04  +4.70290000E-04  -8.84580000E-04
   +1.58746000E-03  -1.43161000E-03  -6.21780000E-04  -5.21000000E-06  +6.88000000E-06
   +9.23000000E-06  -1.07200000E-05  -1.41600000E-05  +6.40000000E-06  +5.55000000E-06
   -7.82900000E-05  +2.46000000E-06  +6.27000000E-06  -3.53000000E-06  -6.95000000E-06
   -1.45500000E-05  -1.60500000E-05  +4.22000000E-06  -6.50000000E-07  -2.32620000E-04
   -4.90740000E-04  +1.77501000E-03  -1.54199000E-03  +9.97500000E-05  -4.36500000E-05
   -2.51080000E-04  -1.76950000E-04  -2.61500000E-05  +5.49000000E-06  +1.98600000E-05
   -4.00600000E-05  -1.15800000E-05  +8.50000000E-06  -9.15700000E-05  -1.86960000E-04
   -2.84740000E-04  -1.30746700E-02  +1.73803050E-01  -6.68000000E-06  -4.95700000E-05
   +1.78500000E-05  -7.79100000E-05  -8.16600000E-05  -7.84900000E-05  -4.60970000E-04
   +3.02150000E-04  +1.20390000E-04  -2.26800000E-05  +5.79400000E-05  +1.29820000E-04
   -3.62100000E-05  -1.84500000E-05  +1.46500000E-05  +4.01500000E-05  +4.81900000E-05
   -9.57000000E-06  -3.26100000E-03  -1.42649000E-03  -2.68778000E-03  +9.92640000E-04
   -4.54040000E-04  +1.36800000E-05  -7.23900000E-05  -6.21400000E-05  -4.10000000E-07
   -9.22860000E-04  +1.06738000E-03  +5.05810000E-04  +1.87057000E-03  +1.54892000E-02
   -1.17327100E-02  +7.10219000E-03  +1.50691650E-01  -2.16087120E-01  +4.55449000E-03
   +2.26530000E-04  +1.84166000E-03  -3.54250000E-04  -1.32854000E-03  +3.43440000E-04
   +9.17900000E-04  -1.13400000E-05  -2.38660000E-04  -2.64630000E-04  -6.38200000E-05
   +1.68560000E-04  +5.12627000E-03  +2.99266000E-03  +2.88453000E-03  -1.86040000E-04
   +1.79180000E-04  -6.13100000E-04  -5.15970000E-04  -5.53480000E-04  -4.42000000E-05
   -3.44000000E-06  +1.18700000E-05  +1.74000000E-06  -9.77000000E-06  -6.72000000E-06
   -4.84000000E-06  +2.98800000E-05  +1.33700000E-05  -1.91700000E-05  -1.70000000E-06
   +6.84000000E-06  -1.83900000E-05  -1.01100000E-05  -7.09000000E-06  +2.54000000E-06
   -4.94180000E-04  -2.81600000E-04  +2.59990000E-04  -3.82130000E-04  -4.51650000E-04
   +3.37370000E-04  -5.77060000E-04  +2.84030000E-04  -3.41600000E-05  -6.54500000E-05
   +5.26000000E-06  +7.62200000E-05  -9.76000000E-06  -1.04320000E-04  -9.67600000E-05
   -5.03100000E-05  -2.23200000E-04  -2.17240000E-04  -1.16195900E-02  -1.65805290E-01
   +2.24769960E-01  -3.55200000E-05  -6.08300000E-05  +1.25200000E-05  -5.78800000E-05
   -8.49400000E-05  -8.04900000E-05  -2.08050000E-04  +4.29490000E-04  -1.17100000E-05
   -3.96700000E-05  +2.73700000E-05  +3.50500000E-05  -3.92000000E-05  +8.43000000E-06
   +1.83100000E-05  +1.08870000E-04  +8.32500000E-05  +1.01600000E-05  -6.64720000E-04
   -9.92340000E-04  +3.97210000E-04  -6.97400000E-05  -2.35400000E-05  -9.24500000E-05
   -1.42490000E-04  -9.28000000E-05  -5.31000000E-06  -4.72500000E-05  -1.39400000E-05
   +9.31300000E-05  -3.04789000E-03  +4.04457000E-03  -1.12258000E-03  -1.48511800E-02
   +9.16000000E-05  +2.32579500E-02  -1.35246550E-01  -7.72565000E-03  +1.20703760E-01
   -2.35342000E-03  -8.30922000E-03  +7.96718000E-03  +1.73824000E-03  +1.76020000E-04
   -1.28569000E-03  -2.76970000E-04  -7.51950000E-04  +3.53580000E-04  +2.92410000E-04
   +6.00250000E-04  -4.41930000E-04  +2.21140000E-04  +1.18710000E-04  -1.65560000E-04
   +9.75594000E-03  -1.44812000E-03  -2.93776700E-02  +1.49200000E-05  +1.61400000E-05
   +1.06000000E-05  -1.25000000E-05  -1.76500000E-05  -1.00000000E-07  +2.50800000E-05
   +1.22100000E-05  +3.03300000E-05  +8.06000000E-06  +1.30300000E-05  -8.96000000E-06
   -1.45700000E-05  -1.10300000E-05  +7.18000000E-06  -9.31000000E-06  +4.36700000E-05
   -5.31300000E-05  +2.79100000E-05  +2.30400000E-05  +3.10000000E-06  -2.01500000E-05
   -1.37200000E-05  -2.19100000E-05  +1.05000000E-06  -1.01700000E-05  +1.34000000E-06
   +2.32900000E-05  -4.30000000E-06  -6.10000000E-07  -2.27500000E-05  +6.01900000E-05
   +3.69900000E-05  +2.76600000E-04  +5.38100000E-05  -3.48470000E-04  +1.42212000E-01
   +9.10000000E-06  +1.63300000E-05  -1.33400000E-05  +4.62900000E-05  +4.05700000E-05
   +1.79000000E-06  +3.13800000E-05  -1.76380000E-04  -1.07300000E-05  +2.81000000E-06
   +2.27600000E-05  -2.83000000E-06  +1.73200000E-05  +1.38000000E-05  -1.73600000E-05
   -2.24600000E-05  -1.80700000E-05  +2.56000000E-06  +2.02710000E-04  +2.36750000E-04
   -6.14250000E-04  +1.27520000E-04  -4.59600000E-05  +8.00100000E-05  +3.68400000E-05
   +2.90600000E-05  -2.45000000E-06  -9.77000000E-06  +4.77600000E-05  -9.77000000E-06
   +2.76486000E-03  -2.06361000E-03  +7.98100000E-04  +1.41174100E-02  +2.90609000E-03
   -1.50085500E-02  -2.84839000E-03  -4.47432900E-02  +1.55393300E-02  -2.91844500E-02
   -2.94831500E-02  +3.49609900E-02  +1.61165000E-03  -8.22250000E-04  -4.72936000E-03
   -9.00950000E-04  -3.28216000E-03  +1.93446000E-03  -2.65340000E-04  -3.35760000E-04
   +7.00730000E-04  -1.49360000E-04  +1.39520000E-04  +4.30090000E-04  +1.72070000E-04
   +5.04555000E-03  -1.35237800E-02  +6.90000000E-07  -7.40000000E-06  +1.74000000E-06
   +9.72000000E-06  +2.42000000E-06  +8.29000000E-06  +1.06000000E-06  -2.23000000E-05
   +1.07900000E-05  -4.88000000E-06  -8.94000000E-06  +7.94000000E-06  +7.32000000E-06
   +2.84000000E-06  -7.50000000E-07  +9.49000000E-06  -1.95900000E-05  +1.06500000E-05
   +3.10000000E-07  -8.61000000E-06  -7.80000000E-07  -6.05000000E-06  -3.82000000E-06
   +1.23600000E-05  -3.02000000E-06  -3.30000000E-06  -1.99400000E-05  -8.24000000E-06
   +1.21100000E-05  -3.58000000E-06  +1.05400000E-05  -4.71200000E-05  -4.54800000E-05
   +2.43370000E-04  +2.15170000E-04  -5.39640000E-04  +1.43148500E-02  +7.25710500E-02
   -3.43000000E-06  -6.06000000E-06  +9.52000000E-06  -9.51000000E-06  -9.64000000E-06
   -1.08000000E-06  -3.68800000E-05  +5.20800000E-05  +8.08000000E-06  +5.28000000E-06
   -1.39600000E-05  +1.09800000E-05  +2.25000000E-06  -4.99000000E-06  +4.61000000E-06
   -1.35400000E-05  -8.30000000E-07  -1.65000000E-06  -2.72240000E-04  -1.49390000E-04
   -1.76350000E-04  +6.39000000E-05  -5.78800000E-05  -7.91000000E-06  +9.49000000E-06
   +1.72000000E-06  +3.93000000E-06  +2.52700000E-05  +3.23900000E-05  -2.34500000E-05
   -5.79650000E-04  +2.71900000E-05  +7.56480000E-04  -1.18870000E-03  +1.78534000E-03
   +3.44908000E-03  +1.18101830E-01  +2.01676200E-02  -2.27828840E-01  +4.30778000E-03
   +5.43734000E-03  +6.44200000E-05  -5.86590000E-04  -1.11151000E-03  +2.96538000E-03
   +1.31600000E-05  +5.03890000E-04  -3.75660000E-04  -1.39700000E-04  +1.64820000E-04
   -4.58000000E-06  -2.52100000E-05  -2.07180000E-04  +2.48180000E-04  -2.86150000E-04
   -4.26777000E-03  -3.71655400E-02  -4.54000000E-06  +7.10000000E-07  -4.00000000E-06
   -9.00000000E-07  +2.84000000E-06  -3.23000000E-06  -5.40000000E-07  +7.49000000E-06
   -1.34200000E-05  -6.48000000E-06  +5.72000000E-06  -2.81000000E-06  -1.90000000E-06
   -2.10000000E-07  -9.50000000E-07  -1.59500000E-05  -4.41000000E-06  +9.59000000E-06
   -7.52000000E-06  -2.38800000E-05  -1.55600000E-05  +1.34700000E-05  +1.24700000E-05
   +7.22000000E-06  -1.96800000E-05  +1.64000000E-06  +2.49000000E-05  -5.79000000E-06
   +1.51700000E-05  -1.60100000E-05  +5.99000000E-06  -1.59300000E-05  -3.25000000E-06
   +3.43000000E-06  -4.31810000E-04  +9.66680000E-04  -1.19849260E-01  -2.08462800E-02
   +2.56708620E-01  -1.82100000E-05  -5.16700000E-05  +1.04000000E-06  +4.63000000E-05
   +2.40600000E-05  -6.97100000E-05  -2.82580000E-04  -4.06800000E-05  -2.91000000E-06
   +2.63000000E-06  +6.17000000E-05  -1.15900000E-05  -1.27800000E-05  -4.28800000E-05
   +3.92800000E-05  -3.40500000E-05  +8.14000000E-06  +1.22000000E-05  +2.43400000E-05
   -1.03240000E-04  +7.65300000E-05  +1.65710000E-04  -1.87100000E-04  -9.18900000E-05
   -5.94000000E-06  -2.64200000E-05  +1.17100000E-05  +3.23000000E-06  -1.24780000E-04
   -4.04900000E-05  +6.80703000E-03  +5.16507000E-03  +3.90105000E-03  -2.41600000E-05
   +2.62760000E-04  -9.25770000E-04  +7.26510000E-04  +2.00060000E-03  +1.92430000E-04
   -2.17869000E-03  +1.85538000E-03  +3.87390000E-03  -1.37698000E-03  -9.06953000E-03
   +1.63843800E-02  -4.28180000E-04  -6.77280000E-04  -2.20152000E-03  +5.67527000E-03
   +1.28582800E-02  -1.04946900E-02  -4.98248300E-02  -2.65880700E-02  +5.13274200E-02
   -2.31240000E-04  -2.14740000E-04  -4.21730000E-04  -2.21400000E-05  +5.36000000E-06
   -1.33100000E-05  -9.25000000E-06  +5.47000000E-06  -1.98600000E-05  +9.71000000E-06
   +5.80000000E-06  -7.25000000E-06  +0.00000000E+00  -1.10000000E-06  -1.38000000E-06
   -7.40000000E-06  +3.96000000E-06  -4.64000000E-06  -3.90000000E-05  -5.14600000E-05
   +5.94000000E-06  -7.95000000E-06  -3.41500000E-05  +2.48600000E-05  +9.03000000E-06
   +1.61100000E-05  -1.99300000E-05  +5.96000000E-06  -3.16000000E-05  +7.33300000E-05
   -1.35900000E-05  -2.51600000E-05  +9.22000000E-06  -3.00200000E-05  -4.70400000E-05
   +1.79100000E-05  -2.22430000E-04  -5.54770000E-04  -5.73300000E-04  -7.28800000E-05
   -1.73380000E-04  -8.60200000E-05  +4.60551000E-02  +1.82700000E-05  +1.37500000E-05
   -2.12000000E-05  +3.96500000E-05  +4.46900000E-05  -2.96500000E-05  -3.26230000E-04
   -1.00550000E-04  -2.57000000E-05  -9.68000000E-06  +5.36800000E-05  -2.36100000E-05
   +2.26900000E-05  +1.42600000E-05  -6.53000000E-06  -2.95900000E-05  -1.07800000E-05
   +1.46900000E-05  -6.20550000E-04  -4.80840000E-04  +1.24983000E-03  +7.44400000E-05
   -2.33000000E-06  +3.31800000E-05  +4.65000000E-05  +2.70400000E-05  -5.37000000E-06
   +4.43520000E-04  -2.85270000E-04  -1.50430000E-04  +6.29284000E-03  -8.25950000E-04
   +1.01200000E-04  +1.70430000E-04  +2.40020000E-04  -4.07970000E-04  +2.89300000E-05
   -8.63160000E-04  +9.82900000E-05  +2.82422000E-03  -5.30150000E-04  -2.70827000E-03
   +3.79344000E-03  +9.16530000E-03  -1.34173900E-02  +2.25810000E-04  -7.92200000E-05
   -4.13500000E-05  -4.44887000E-03  -1.31653200E-02  +2.50028300E-02  -2.41918200E-02
   -1.37616460E-01  +1.32637710E-01  -1.37520000E-04  +2.45720000E-04  -8.14300000E-05
   -5.22000000E-06  -3.74000000E-06  -2.30000000E-07  +9.15000000E-06  +5.15000000E-06
   +1.73000000E-06  -1.07000000E-06  -3.08600000E-05  -5.70000000E-06  -6.39000000E-06
   -1.66700000E-05  +1.08200000E-05  +1.36500000E-05  -2.10000000E-07  +1.95000000E-06
   +8.94000000E-06  -1.25210000E-04  +1.46480000E-04  -1.92300000E-05  +2.04000000E-06
   -1.98000000E-06  -1.26500000E-05  +2.24500000E-05  -3.28000000E-06  -6.39000000E-06
   -3.02600000E-05  -3.89000000E-06  -5.28000000E-06  -4.78000000E-06  -4.59000000E-06
   +2.06000000E-06  -6.16000000E-05  -2.43400000E-05  -2.42550000E-04  -2.01020000E-04
   -9.76200000E-05  -6.43800000E-05  +6.39000000E-05  -3.61100000E-05  +1.87468800E-02
   +1.45863270E-01  +1.25000000E-06  -9.97000000E-06  -9.80000000E-07  -6.00000000E-07
   +1.66600000E-05  -3.60800000E-05  -1.75800000E-04  -2.68500000E-05  +2.95000000E-06
   +3.92700000E-05  +1.80500000E-05  -1.62800000E-05  -1.32500000E-05  -4.37300000E-05
   +3.29300000E-05  -4.38600000E-05  -8.11000000E-06  +1.32800000E-05  +6.43000000E-05
   -1.19010000E-04  +2.63980000E-04  +3.57300000E-05  -4.92300000E-05  -5.44300000E-05
   +1.81300000E-05  -4.40000000E-06  +4.88000000E-06  +6.21400000E-05  -1.13010000E-04
   -9.58000000E-06  +3.61498000E-03  +1.43587000E-03  +3.20072000E-03  +2.43940000E-04
   -1.88110000E-04  -8.50100000E-05  -4.86060000E-04  -1.35294000E-03  +2.66820000E-04
   +3.11764000E-03  -1.79859000E-03  -2.78868000E-03  +4.28610000E-03  +1.66514100E-02
   -1.54189000E-02  -1.10051000E-03  -1.32964000E-03  +2.36917000E-03  +1.81030000E-03
   +3.41820000E-04  +3.02062000E-03  +4.94177100E-02  +1.29569130E-01  -2.49476770E-01
   +8.82000000E-05  +2.82880000E-04  +1.95280000E-04  -1.79800000E-05  +3.72000000E-06
   -9.67000000E-06  -8.59000000E-06  +6.08000000E-06  -2.09100000E-05  +1.60200000E-05
   +4.00000000E-07  -5.44000000E-06  -1.00000000E-08  -6.03000000E-06  -8.50000000E-07
   +9.20000000E-07  -1.02000000E-06  -1.07000000E-06  -1.62800000E-05  -4.68800000E-05
   +2.28100000E-05  -1.00000000E-05  -1.59200000E-05  +8.24000000E-06  +8.10000000E-06
   +1.02100000E-05  -1.52800000E-05  -5.60000000E-06  -1.65500000E-05  +3.90400000E-05
   -6.81000000E-06  -1.22300000E-05  -2.96000000E-06  -1.16900000E-05  -1.91100000E-05
   +2.31300000E-05  -2.17770000E-04  -2.20280000E-04  -2.56090000E-04  -1.82600000E-05
   +1.34480000E-04  -3.46000000E-05  -5.73354800E-02  -1.41026890E-01  +2.59283380E-01
   -9.06500000E-05  -1.04650000E-04  +3.67400000E-05  -6.03300000E-05  +9.93000000E-05
   -8.10100000E-05  -4.21520000E-04  +4.33920000E-04  -7.51130000E-04  -5.45900000E-05
   +6.83000000E-05  -1.38580000E-04  +1.14470000E-04  +8.10000000E-06  +1.71600000E-05
   -1.64730000E-04  -4.26900000E-05  +6.60100000E-05  -2.38200000E-04  +1.06990000E-04
   -3.49220000E-04  -2.71930000E-04  +5.28400000E-04  -9.31400000E-05  +9.60600000E-05
   +5.80000000E-05  -5.20000000E-06  -6.41600000E-05  -1.48400000E-04  -1.65200000E-05
   +1.37626000E-03  +1.78820000E-04  +3.98369000E-03  +1.76337000E-03  +5.63270000E-04
   -1.80380000E-04  +4.35600000E-04  +7.88900000E-05  +6.92700000E-05  -9.68570000E-04
   -1.67720000E-04  -8.47750000E-04  +9.70802000E-03  +4.95166000E-03  +2.20350000E-03
   -2.69344000E-03  +1.23777000E-03  +2.53680000E-04  -1.42192670E-01  +5.34716300E-02
   +1.28313740E-01  -1.48221000E-03  +3.12189000E-03  +1.48830200E-02  -1.42300000E-04
   -3.85300000E-05  -1.35620000E-04  -2.12900000E-05  -1.45400000E-05  -3.81000000E-06
   -1.43000000E-06  +7.52000000E-06  -1.07000000E-06  -5.21000000E-06  +7.37000000E-06
   +1.44500000E-05  +3.77200000E-05  +5.85500000E-05  -9.40000000E-06  -7.10000000E-07
   +8.00000000E-08  -5.11000000E-06  +7.27100000E-05  -1.80100000E-05  -1.92900000E-05
   -7.31000000E-06  -1.02600000E-05  +5.10900000E-05  -1.04800000E-05  +3.42000000E-06
   -5.16200000E-05  +4.77670000E-04  +4.00330000E-04  -2.95520000E-04  -8.28000000E-06
   -7.07100000E-05  +7.77800000E-05  -2.62900000E-05  +8.29600000E-05  -2.41370000E-04
   -8.98000000E-06  -2.26760000E-04  -1.00140000E-04  -7.07200000E-05  -5.37700000E-05
   -2.22100000E-05  -4.74665000E-03  -2.55186000E-03  -3.29600000E-03  +1.39680820E-01
   +3.21100000E-05  -4.39700000E-05  -1.51900000E-05  +1.00710000E-04  +4.35300000E-05
   +1.22730000E-04  +3.62840000E-04  +6.91000000E-05  -8.09000000E-05  +6.44200000E-05
   +1.10680000E-04  +1.21420000E-04  -1.86930000E-04  -1.62180000E-04  +5.85300000E-05
   +9.23100000E-05  -1.95700000E-05  -1.01320000E-04  -2.26380000E-04  +3.40360000E-04
   +8.80900000E-05  +6.83200000E-05  -1.18882000E-03  +9.90780000E-04  -9.97500000E-05
   -8.45300000E-05  +1.36700000E-05  -1.59130000E-04  -1.28660000E-04  -1.45280000E-04
   -1.15905300E-02  +7.78564000E-03  +1.73656100E-02  +1.03572000E-03  -2.47836000E-03
   +2.51704000E-03  +5.32830000E-04  -7.89100000E-04  +2.59660000E-04  -1.28550000E-04
   +7.81330000E-04  -1.70706000E-03  +6.10329000E-03  -1.31030000E-04  +5.53839000E-03
   -1.07321000E-03  -1.40489000E-03  -1.42573000E-03  +4.90552700E-02  -7.08007400E-02
   -5.50495600E-02  +2.16820100E-02  -9.46483000E-03  -2.19403500E-02  -6.42400000E-05
   +1.42970000E-04  +2.75600000E-05  -7.41000000E-06  +1.54300000E-05  -9.82000000E-06
   -1.55700000E-05  -7.16000000E-06  -1.24700000E-05  -1.87100000E-05  -9.42000000E-06
   -5.89500000E-05  +7.33400000E-05  -5.38600000E-05  -4.11000000E-05  -1.69500000E-05
   +1.53400000E-05  -6.13000000E-06  +3.61700000E-05  +2.16800000E-05  -3.38800000E-05
   -1.69000000E-05  +4.96800000E-05  +1.29600000E-05  -4.02000000E-05  +2.33300000E-05
   -1.56490000E-04  +5.51840000E-04  -2.37568000E-03  -3.28070000E-04  +2.30000000E-05
   +8.64600000E-05  -8.77700000E-05  +1.08100000E-05  +2.27590000E-04  -3.07910000E-04
   -1.19046000E-03  -7.02980000E-04  +1.81680000E-04  -2.48900000E-05  +8.74800000E-05
   -2.13600000E-05  -2.91323000E-03  -1.25729000E-03  -2.00757000E-03  -6.20031200E-02
   +8.13384200E-02  -1.32130000E-04  -1.84900000E-05  +7.16200000E-05  -1.60790000E-04
   -5.71300000E-05  +2.12930000E-04  -2.50610000E-04  +2.59330000E-04  +3.84900000E-05
   -2.34600000E-05  -4.78820000E-04  -1.97180000E-04  +1.84240000E-04  +3.01600000E-05
   -7.80500000E-05  -3.31410000E-04  -3.31000000E-05  +9.07000000E-05  +1.12499000E-03
   -7.56490000E-04  -3.48460000E-04  +1.08880000E-04  -1.46530000E-04  -2.40230000E-04
   +2.97560000E-04  +1.82630000E-04  +3.04000000E-06  -1.44930000E-04  +1.72000000E-06
   +5.52600000E-05  +1.52526400E-02  -7.01446000E-03  -1.48142900E-02  -6.16190000E-04
   +3.60358000E-03  -3.12207000E-03  -8.14450000E-04  +5.62050000E-04  -1.79810000E-04
   -7.45030000E-04  -3.61700000E-04  -1.59800000E-05  +5.08842000E-03  +3.53206000E-03
   +2.99674000E-03  -1.55886000E-03  +9.84200000E-05  -1.30590000E-04  +1.27977670E-01
   -5.58905900E-02  -2.20891140E-01  +6.88380000E-04  +1.95336000E-03  +6.17417000E-03
   +1.26620000E-04  -1.35670000E-04  +2.02500000E-04  -2.74900000E-05  -3.52300000E-05
   -1.79500000E-05  +1.78500000E-05  +2.45200000E-05  -3.00000000E-07  +4.53200000E-05
   +6.24000000E-05  +7.16900000E-05  -4.40100000E-05  +1.82400000E-05  -1.14700000E-05
   +1.49900000E-05  -5.13000000E-06  -6.04000000E-06  -7.79600000E-05  +6.38800000E-05
   +9.49000000E-06  -2.08500000E-05  -1.33250000E-04  +3.93800000E-05  +5.88800000E-05
   +2.49500000E-05  +8.68500000E-05  +1.64000000E-05  -2.35160000E-04  +9.31880000E-04
   -6.51600000E-05  -1.86800000E-04  +5.33100000E-05  -5.24000000E-05  -7.28800000E-05
   +3.23770000E-04  +1.23720000E-03  +2.25900000E-04  -3.47040000E-04  +4.49900000E-05
   -7.89600000E-05  +1.08400000E-05  -3.82109000E-03  -1.22009000E-03  -4.61220000E-04
   -1.43391310E-01  +5.62275600E-02  +2.29455620E-01  +2.03800000E-05  +2.29900000E-05
   +1.18100000E-05  -2.06100000E-05  +5.51000000E-06  +3.22400000E-05  +5.83900000E-05
   -5.97600000E-05  -4.05000000E-06  -1.28800000E-05  -1.78500000E-05  +2.17700000E-05
   +2.06300000E-05  -2.92300000E-05  -1.31000000E-05  -9.92600000E-05  -5.60300000E-05
   -2.55000000E-06  +1.98900000E-05  +2.34550000E-04  +1.17450000E-04  -3.22600000E-05
   +8.78000000E-06  -3.37000000E-05  +1.05710000E-04  +5.45400000E-05  +1.57000000E-06
   +1.20700000E-05  -1.32100000E-05  +8.22000000E-06  +6.02430000E-04  -1.42050000E-04
   -3.99170000E-04  -1.08432000E-03  -3.70320000E-04  -4.01011000E-03  -2.52095300E-02
   +1.33239800E-02  +1.57146000E-03  +3.73472000E-03  +1.98396000E-03  +3.76850000E-04
   -2.85371000E-03  -2.33121000E-03  +2.54938000E-03  +3.94710000E-04  +1.24982000E-03
   -5.96420000E-04  +3.58400000E-05  +3.66170000E-04  -5.00570000E-04  +4.76050000E-04
   -1.18260000E-04  +1.42600000E-04  -3.97283460E-01  +2.09966740E-01  +3.84436000E-03
   -2.41200000E-05  -8.74000000E-06  -7.25000000E-06  -9.05000000E-06  +8.26000000E-06
   -5.13000000E-06  -2.22000000E-05  +1.55600000E-05  -2.38000000E-05  -5.71000000E-06
   +1.10000000E-06  -6.17000000E-06  +4.35000000E-06  +1.90000000E-06  -5.41000000E-06
   +1.02400000E-05  -9.06000000E-06  +1.44700000E-05  -1.18400000E-05  -7.80000000E-07
   -2.69000000E-06  +8.30000000E-07  +6.83000000E-06  +8.28000000E-06  -1.06600000E-05
   +1.57600000E-05  +2.90000000E-05  -1.54900000E-05  +1.30700000E-05  +4.78000000E-06
   +2.15100000E-05  -1.21500000E-05  +2.60700000E-05  -7.21040000E-04  +8.04100000E-05
   -2.07100000E-04  +2.59789000E-03  -1.07290000E-04  +6.10540000E-04  +5.81100000E-05
   -8.21400000E-05  -6.01500000E-05  -1.00500000E-05  -4.88300000E-05  -6.90000000E-06
   +4.19252470E-01  +1.43800000E-05  +1.22800000E-05  +6.35000000E-06  -2.14100000E-05
   -3.68000000E-06  +1.99100000E-05  +1.46600000E-05  -1.39000000E-05  +1.92600000E-05
   +4.58000000E-06  -8.39000000E-06  +3.20300000E-05  +5.64000000E-06  -2.40700000E-05
   -2.84000000E-06  -3.56400000E-05  -2.27000000E-05  -7.00000000E-06  -1.69770000E-04
   -4.05200000E-05  -6.16400000E-05  +8.48400000E-05  -2.24600000E-05  +2.84400000E-05
   +4.21900000E-05  +1.60400000E-05  +2.31000000E-06  +3.37600000E-05  +1.80300000E-05
   -2.04900000E-05  -1.42850000E-04  +2.68870000E-04  +4.74450000E-04  +6.76070000E-04
   +1.12687000E-03  -8.10440000E-04  -1.31706500E-02  +5.58988000E-03  -3.92832000E-03
   +8.37650000E-04  -7.47550000E-04  -4.39300000E-05  -1.79220000E-03  -2.69250000E-04
   +8.17200000E-04  +5.31490000E-04  -1.64180000E-04  -1.11000000E-06  -7.66000000E-05
   +1.94300000E-05  -3.36100000E-05  -3.81600000E-05  -1.66700000E-05  -6.17900000E-05
   +2.37969530E-01  -1.48315860E-01  -2.19737200E-02  -1.24700000E-05  +3.90000000E-07
   -5.81000000E-06  -6.34000000E-06  +4.72000000E-06  -5.34000000E-06  -9.40000000E-06
   +9.39000000E-06  -3.30000000E-05  -3.20000000E-07  +7.00000000E-08  -6.05000000E-06
   +1.09000000E-06  +2.44000000E-06  -3.71000000E-06  -5.68000000E-06  -1.66000000E-05
   +1.75300000E-05  -1.86000000E-05  -2.54900000E-05  -2.47000000E-06  +5.87000000E-06
   +1.13400000E-05  -7.70000000E-07  -7.34000000E-06  +1.04900000E-05  +2.02000000E-05
   -1.82800000E-05  +8.23000000E-06  +5.61000000E-06  +5.27000000E-06  -2.84700000E-05
   -1.63400000E-05  -2.03700000E-04  +6.85000000E-05  +8.73000000E-06  -4.67150000E-04
   -3.61440000E-04  -1.00926000E-03  -6.12600000E-05  -6.95900000E-05  -5.46200000E-05
   -1.61500000E-05  -3.59500000E-05  -1.02700000E-05  -2.23953020E-01  +1.43019830E-01
   +2.72000000E-06  +4.31000000E-06  -7.99000000E-06  -2.21000000E-06  +1.78000000E-06
   +1.01500000E-05  +7.66300000E-05  -3.60400000E-05  -3.71300000E-05  -1.11800000E-05
   -5.86000000E-06  +1.79000000E-06  -3.38000000E-06  +1.87000000E-06  -4.44000000E-06
   -7.09000000E-06  -4.70000000E-06  +3.63000000E-06  +2.91800000E-04  +3.86800000E-04
   +3.89420000E-04  -2.33380000E-04  +9.03500000E-05  -5.04100000E-05  +4.09000000E-06
   +3.49000000E-06  -5.91000000E-06  -2.99400000E-05  -3.40000000E-05  +4.91500000E-05
   -4.42700000E-05  +4.37120000E-04  -6.35080000E-04  -3.08532000E-03  -2.40488000E-03
   -3.80795000E-03  -3.82985700E-02  +1.91671800E-02  -2.69603000E-03  +2.08621000E-03
   +1.52070000E-04  -5.86680000E-04  -3.53070000E-04  -1.34885000E-03  +1.64243000E-03
   -1.25700000E-05  +7.11770000E-04  -3.72720000E-04  -1.25850000E-04  -4.19560000E-04
   -9.73700000E-05  -2.06300000E-05  -1.19740000E-04  -1.67100000E-04  +4.34306500E-02
   -4.46794600E-02  -3.75732500E-02  -7.90000000E-07  -1.61000000E-06  +5.31000000E-06
   -5.12000000E-06  -4.01000000E-06  +2.22000000E-06  +8.20000000E-07  +1.01700000E-05
   +1.26000000E-05  +3.92000000E-06  -3.36000000E-06  +3.50000000E-07  +2.56000000E-06
   -1.29000000E-06  +9.50000000E-07  +6.14000000E-06  +1.51500000E-05  -7.18000000E-06
   +5.09000000E-06  +1.96900000E-05  +2.44000000E-06  -2.69000000E-06  -1.26700000E-05
   -3.49000000E-06  +5.93000000E-06  +4.50000000E-07  +8.80000000E-07  -8.26000000E-06
   +1.62000000E-05  -5.50000000E-06  +8.56000000E-06  +5.20800000E-05  +6.96900000E-05
   -3.51590000E-04  +4.75350000E-04  +3.08300000E-05  -9.92900000E-05  +8.33530000E-04
   +4.30400000E-04  +1.91360000E-04  +4.49400000E-05  -5.24400000E-05  +6.52800000E-05
   +1.12400000E-05  +3.35500000E-05  -3.48658000E-03  +2.66405000E-02  +4.34248900E-02
end_hess

