# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.88870950    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.67980442E+00  +5.82671451E-01  +2.45956469E+00
   006   +2.06213397E+00  +1.00224746E+00  +5.52240726E-01
   006   +2.33084639E+00  -2.08821358E-01  -1.93937339E+00
   006   +4.36219247E+00  -2.81757306E-02  -3.42330071E+00
   006   +6.26721925E+00  -3.09347470E+00  +1.03203471E+00
   006   +5.79320833E+00  -1.18860258E+00  +2.56894548E+00
   006   -2.26042743E-01  +2.76184781E+00  +8.16770381E-01
   006   -4.44862034E-01  +3.96308651E+00  +3.44686040E+00
   008   +6.79535172E+00  -4.79020402E+00  -2.26682295E-01
   006   -2.61877702E+00  +1.19280719E+00  +3.49870498E-01
   006   -3.01918769E+00  -9.95025353E-01  +1.75575827E+00
   006   -5.16247920E+00  -2.45776052E+00  +1.44423393E+00
   006   -6.98406064E+00  -1.75404031E+00  -3.12134205E-01
   006   -6.62248002E+00  +4.11662052E-01  -1.73806675E+00
   006   -4.46157028E+00  +1.85390812E+00  -1.40118572E+00
   008   -9.12645553E+00  -3.11296298E+00  -7.07714139E-01
   006   +6.94479072E-02  +4.91386893E+00  -1.10700521E+00
   008   +6.53313347E+00  +1.18591127E+00  -2.89342404E+00
   001   -9.14274822E+00  -4.55486642E+00  +3.82960099E-01
   001   -5.41459724E+00  -4.15553070E+00  +2.56317799E+00
   001   -1.60781004E+00  -1.59029331E+00  +3.11333054E+00
   001   -4.23389880E+00  +3.52474119E+00  -2.55313883E+00
   001   -8.03839341E+00  +9.48829812E-01  -3.11001803E+00
   001   +1.39556746E-01  +4.21227304E+00  -3.04067231E+00
   001   -1.47585572E+00  +6.26880172E+00  -9.51908822E-01
   001   +1.82831683E+00  +5.92238171E+00  -7.36851756E-01
   001   +1.18437382E+00  +5.15717619E+00  +3.86421656E+00
   001   -2.13036221E+00  +5.14520706E+00  +3.51086766E+00
   001   -6.22559256E-01  +2.54825364E+00  +4.93287879E+00
   001   +6.99233990E-01  -1.15751000E+00  -2.72838033E+00
   001   +4.41780860E+00  -8.87476997E-01  -5.27689768E+00
   001   +7.08892886E+00  -1.09806581E+00  +4.14925764E+00
   001   +3.42463462E+00  +1.60507607E+00  +4.20963789E+00
   001   +6.42592215E+00  +1.89242625E+00  -1.22098859E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +9.60000000E-07  -3.00000000E-08  +4.40000000E-07
   -8.00000000E-07  +8.00000000E-07  -1.81000000E-06
   -1.14000000E-06  -1.01000000E-06  +1.23000000E-06
   +1.62000000E-06  +2.00000000E-08  -5.40000000E-07
   -5.20000000E-07  -5.80000000E-07  -1.60000000E-07
   -2.40000000E-07  +1.17000000E-06  +2.00000000E-07
   -2.60000000E-07  +1.50000000E-07  -4.10000000E-07
   +5.70000000E-07  +6.90000000E-07  -1.54000000E-06
   +2.80000000E-07  +6.70000000E-07  +6.80000000E-07
   +4.60000000E-07  +1.00000000E-07  +5.90000000E-07
   -1.80000000E-07  +3.80000000E-07  +4.90000000E-07
   +2.10000000E-07  +2.50000000E-07  +1.55000000E-06
   -7.50000000E-07  -9.90000000E-07  +1.60000000E-06
   -2.60000000E-07  -8.90000000E-07  +8.90000000E-07
   -2.20000000E-07  -9.40000000E-07  +3.50000000E-07
   +3.90000000E-07  -1.80000000E-07  +2.40000000E-06
   -6.70000000E-07  -8.80000000E-07  -1.19000000E-06
   -1.37000000E-06  -1.77000000E-06  -1.09000000E-06
   +4.80000000E-07  +3.30000000E-07  +2.50000000E-06
   +3.10000000E-07  +2.70000000E-07  +2.30000000E-06
   +4.70000000E-07  +4.70000000E-07  +1.09000000E-06
   +7.00000000E-08  -1.40000000E-07  -4.80000000E-07
   -6.30000000E-07  -1.00000000E-06  +6.30000000E-07
   -3.60000000E-07  -9.80000000E-07  -1.26000000E-06
   -4.60000000E-07  -2.70000000E-07  -1.53000000E-06
   -9.00000000E-08  -1.20000000E-07  -1.88000000E-06
   +5.90000000E-07  +1.21000000E-06  -1.47000000E-06
   +1.30000000E-07  +1.08000000E-06  -1.06000000E-06
   +5.90000000E-07  +1.65000000E-06  -2.50000000E-07
   -4.50000000E-07  -7.20000000E-07  +1.10000000E-07
   -5.40000000E-07  -1.68000000E-06  -3.40000000E-07
   +7.90000000E-07  +1.29000000E-06  -2.30000000E-07
   +3.50000000E-07  +1.52000000E-06  -3.90000000E-07
   +6.30000000E-07  +1.00000000E-07  -1.41000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +4.91190840E-01  -2.14101940E-01  +3.54466430E-01  +1.95837850E-01  +1.12513830E-01
   +6.96299080E-01  -2.43852010E-01  +6.11035400E-02  -1.96321020E-01  +5.18546930E-01
   +6.12590100E-02  -8.69517600E-02  +3.20884400E-02  -1.44678510E-01  +3.11583260E-01
   -1.84373650E-01  +3.23430200E-02  -3.26578750E-01  +1.92759610E-01  +4.96687600E-02
   +6.60220810E-01  +1.05011400E-02  -6.00501000E-03  -1.89635600E-02  -9.83912900E-02
   +2.30744000E-03  +4.19977000E-03  +7.36772480E-01  -3.88297000E-03  +7.89631000E-03
   -2.20285000E-03  +7.46627000E-03  -1.00922350E-01  -6.26472600E-02  +1.45635170E-01
   +2.62831430E-01  -1.28403900E-02  -1.56445300E-02  -3.38788900E-02  +1.30867600E-02
   -6.41803000E-02  -1.94716900E-01  -1.44022120E-01  +1.53598670E-01  +5.73275300E-01
   -3.73116000E-03  -8.04998000E-03  -8.37805000E-03  +3.58982000E-03  +7.00831000E-03
   +2.53558100E-02  -3.55573520E-01  -2.94729600E-02  +1.92555230E-01  +6.93420560E-01
   +3.14323000E-03  -4.23277000E-03  -1.14188000E-03  +1.10653800E-02  +5.67022000E-03
   -1.08251300E-02  -3.46200500E-02  -6.97618000E-02  -7.83525000E-03  +1.50769570E-01
   +3.01251090E-01  +5.42369000E-03  -3.08177000E-03  +1.44581000E-03  +2.50158300E-02
   -2.55921000E-03  -2.39972700E-02  +2.07886810E-01  -8.74207000E-03  -2.62467420E-01
   -1.82829240E-01  +1.85280830E-01  +7.08864100E-01  -6.47485000E-03  +2.10562900E-02
   +2.29696700E-02  +2.40650000E-03  +2.20992000E-03  +1.77752000E-03  -2.41751000E-03
   -3.14353000E-03  +3.38731000E-03  +7.64822000E-03  +2.80015000E-03  -4.57700000E-04
   +2.18742680E-01  +1.67465300E-02  -3.83318000E-02  -1.78203700E-02  -5.37612000E-03
   +7.09546000E-03  -6.04070000E-04  -2.50900000E-05  -2.12515000E-03  +2.76436000E-03
   -1.27547000E-03  -2.38602000E-03  -8.64400000E-05  -2.78800920E-01  +9.92794360E-01
   +2.13087000E-02  -2.02495700E-02  -7.97958000E-03  -6.85615000E-03  +1.00777600E-02
   +3.49938000E-03  +5.71230000E-04  -8.23310000E-04  +6.04128000E-03  -1.88240000E-03
   +9.63590000E-04  -6.49890000E-03  -1.74477140E-01  +6.61254950E-01  +6.25953060E-01
   -1.64186330E-01  +1.00394680E-01  -7.62992000E-03  -2.34091900E-02  +1.94560400E-02
   -1.07894600E-02  -1.18071000E-03  -3.65870000E-04  +5.03274000E-03  -3.42949000E-03
   -1.77843000E-03  -2.56127000E-03  -9.92361400E-02  +8.08545900E-02  +2.37461500E-02
   +4.14642290E-01  +9.20730600E-02  -1.28230750E-01  -1.62421500E-02  +1.54511400E-02
   -5.94682000E-03  +7.38324000E-03  -3.00917000E-03  -3.66325000E-03  -4.32260000E-03
   -1.92400000E-04  +1.71150000E-03  +4.14219000E-03  +8.23816500E-02  -2.99723130E-01
   -1.86453740E-01  -2.13593570E-01  +5.07253210E-01  -2.86027400E-02  +1.48670000E-03
   -7.60263900E-02  -1.74129200E-02  +1.30170200E-02  +4.31381000E-03  +1.43340000E-04
   +3.08332000E-03  -1.35382000E-03  +2.29340000E-03  +1.55476000E-03  +7.84130000E-04
   +2.65200500E-02  -1.96557290E-01  -2.16411510E-01  +1.32588440E-01  +2.58368720E-01
   +5.19321270E-01  -1.66057800E-02  +1.57011300E-02  -3.53486000E-03  -1.26127550E-01
   +4.04274600E-02  -9.85490000E-04  -2.67746000E-03  +6.65622000E-03  +1.04648400E-02
   +1.73530000E-04  -5.05190000E-04  -2.93247000E-03  -4.03100000E-04  +1.94095000E-03
   +1.62677000E-03  +3.98434000E-03  +1.65600000E-03  -2.66357000E-03  +4.56606080E-01
   +1.17408300E-02  -1.98205000E-03  +6.47759000E-03  +4.49463900E-02  -1.05745110E-01
   -1.11507600E-02  +1.26439200E-02  -7.77846000E-03  -4.39249000E-03  -4.99260000E-04
   -1.58385000E-03  -7.87520000E-04  +3.70260000E-04  -1.62338000E-03  -2.24135000E-03
   +1.67729000E-03  +8.53704000E-03  -2.52101000E-03  +6.10000000E-07  +4.77511680E-01
   -1.80987100E-02  +1.40194100E-02  +5.07898000E-03  +8.21668000E-03  -1.28468900E-02
   -8.19861700E-02  +2.48220000E-02  -1.70739900E-02  -5.37626000E-03  -3.54314000E-03
   -3.33180000E-03  -3.30857000E-03  +2.94560000E-04  -2.42063000E-03  -2.77579000E-03
   -4.13913000E-03  -1.12674000E-03  -1.11358000E-03  -2.45693000E-03  -2.31053000E-03
   +4.89409010E-01  -2.19206000E-03  +8.36120000E-04  +1.06079000E-03  -3.14155000E-03
   +1.25096100E-02  +2.53471500E-02  -4.61290000E-03  +2.72267000E-03  -3.88400000E-04
   +1.55839000E-03  +1.23252000E-03  +9.69200000E-04  -1.07600000E-05  -4.62000000E-04
   -2.82720000E-04  -8.97000000E-06  +4.22550000E-04  +6.40590000E-04  -7.48514600E-02
   +2.03742000E-03  +3.79466000E-03  +5.83582010E-01  +2.69210000E-04  -1.60948000E-03
   -4.57110000E-04  +4.91646000E-03  -1.09099100E-02  -1.97502500E-02  +3.49713000E-03
   -4.73110000E-04  +1.33700000E-05  -6.93670000E-04  -8.38760000E-04  -7.45290000E-04
   +1.30520000E-04  +1.39000000E-06  -1.56370000E-04  -3.71250000E-04  -1.26220000E-04
   -4.11880000E-04  +5.20015000E-03  -9.24551400E-02  -3.81663000E-02  +4.76318000E-03
   +5.61926630E-01  -5.69920000E-04  +6.01620000E-04  -2.46740000E-04  +5.26147000E-03
   -4.01593000E-03  -3.06935000E-03  -1.13668000E-03  +5.51410000E-04  +3.97670000E-04
   +1.29140000E-04  +1.72840000E-04  +3.63090000E-04  +7.16200000E-05  -5.18450000E-04
   -6.57220000E-04  -6.29690000E-04  +6.85950000E-04  +5.10100000E-05  +8.66030000E-03
   -3.52747600E-02  -1.57575500E-01  +1.10197900E-02  -5.24032700E-02  +4.90815300E-01
   +1.07320000E-03  -2.53617000E-03  -6.72402000E-03  -8.36610000E-04  -1.07200000E-04
   +9.08630000E-04  +1.13431000E-03  +2.87318000E-03  -3.25281000E-03  -5.54010000E-03
   -2.43960000E-04  -8.07700000E-04  -1.16396220E-01  +1.88508400E-01  +1.36050760E-01
   +2.71058500E-02  +5.88884000E-03  +1.95435800E-02  +2.69160000E-04  -5.44690000E-04
   -3.22470000E-04  -1.15760000E-04  -2.18800000E-05  -1.13070000E-04  +9.08762600E-02
   -4.70550000E-03  +1.22629300E-02  +1.52113000E-03  +1.25805000E-03  -4.08161000E-03
   -2.39448000E-03  -2.48920000E-04  -5.76990000E-04  +8.77320000E-04  +5.20443000E-03
   +1.63824000E-03  +1.21914000E-03  +1.87234560E-01  -6.49604380E-01  -4.39697450E-01
   +5.45181000E-03  -3.24537500E-02  -4.01828200E-02  -1.40391000E-03  +1.13986000E-03
   +1.69302000E-03  +4.55320000E-04  -5.07600000E-05  +3.78620000E-04  -1.97863670E-01
   +6.73590100E-01  -8.25817000E-03  +6.45714000E-03  +3.60505000E-03  +1.28364000E-03
   -4.25319000E-03  -4.24708000E-03  -1.30653000E-03  +1.19397000E-03  -9.65820000E-04
   +2.56799000E-03  +1.89972000E-03  +2.07811000E-03  +1.34854140E-01  -4.42500530E-01
   -3.81911300E-01  +1.80810500E-02  -4.22839200E-02  -1.05578300E-02  -1.05529000E-03
   +1.18642000E-03  +1.48461000E-03  +2.58660000E-04  +1.23900000E-05  +3.69900000E-04
   -1.46890940E-01  +4.77392460E-01  +3.86906250E-01  -3.94260000E-04  -2.55090000E-04
   +2.29403000E-03  -3.65045600E-02  -6.81332000E-03  -6.82862000E-03  -2.81000000E-06
   +5.80810000E-04  +1.57366000E-03  -5.00740000E-04  -8.59730000E-04  -1.06536000E-03
   +1.23690000E-04  -2.17650000E-04  -5.77550000E-04  +3.11550000E-04  +1.67418000E-03
   -4.46160000E-04  -1.38008520E-01  -4.42070500E-02  -1.60045500E-02  -2.07352000E-03
   -5.41047000E-03  -8.83889000E-03  -1.00890000E-04  +1.14030000E-04  +2.48450000E-04
   +5.35354550E-01  +7.74360000E-04  -1.81520000E-03  -8.52390000E-04  +1.03106100E-02
   +1.31467500E-02  +5.30982000E-03  +1.60899000E-03  +1.85770000E-04  -8.61910000E-04
   -3.96740000E-04  -1.73750000E-04  -6.06800000E-05  -2.28630000E-04  +1.96319000E-03
   +2.12383000E-03  +6.53480000E-04  -2.61737000E-03  +1.48800000E-04  -3.68263900E-02
   -1.06605920E-01  +2.22652000E-03  -1.30525700E-02  -1.18281800E-02  -9.80972000E-03
   +4.22840000E-04  -1.48468000E-03  -1.27118000E-03  +9.44421300E-02  +5.11115190E-01
   +3.54410000E-04  +1.06230000E-04  +7.90500000E-05  -3.08265000E-03  +8.77350000E-04
   -3.06660000E-04  +2.07061000E-03  -6.69900000E-04  -4.75400000E-04  +2.64480000E-04
   +8.81600000E-05  +2.08760000E-04  -4.05500000E-05  +2.73550000E-04  +1.68420000E-04
   +1.52210000E-04  +8.84300000E-05  +2.12500000E-05  -1.78125700E-02  -3.78180000E-04
   -8.10692300E-02  -2.67811600E-02  -1.91423600E-02  -9.92579000E-03  +7.45000000E-05
   -2.07470000E-04  -1.49900000E-04  +1.64225970E-01  -1.84416540E-01  +4.38604690E-01
   -1.60000000E-05  -1.00160000E-03  +6.79830000E-04  -8.83600000E-04  -2.64632000E-03
   +8.03690000E-04  -2.89620000E-04  -2.09810000E-04  +6.27490000E-04  +8.87000000E-06
   -2.02750000E-04  -1.44780000E-04  +6.44300000E-05  -1.67690000E-04  -2.12140000E-04
   +4.93200000E-05  +4.46740000E-04  -5.17200000E-05  -5.38092000E-03  -2.39668900E-02
   +1.49856200E-02  -5.50240000E-04  -7.62700000E-04  +1.49925000E-03  -1.04340000E-04
   +2.01650000E-04  +1.82170000E-04  -1.19531620E-01  -1.10944800E-02  -2.45174700E-02
   +6.09825610E-01  +2.40600000E-04  -1.81240000E-04  +6.31340000E-04  -1.06830000E-04
   -1.15080000E-03  -2.71990000E-04  +3.53950000E-04  -6.76990000E-04  -7.77330000E-04
   -8.05900000E-05  -2.04100000E-05  +4.44990000E-04  -4.55000000E-06  -2.20770000E-04
   -3.26070000E-04  -8.07600000E-05  -1.57800000E-05  +1.90060000E-04  -1.06129700E-02
   -1.55246800E-02  +6.34605000E-03  -8.15610000E-04  -4.20210000E-04  +8.91140000E-04
   -4.01000000E-06  +1.52230000E-04  +1.65990000E-04  -6.04706500E-02  -2.41642570E-01
   +9.03916600E-02  +1.30176590E-01  +5.29221110E-01  -1.04300000E-04  +1.78600000E-04
   -5.55680000E-04  +6.26600000E-04  +7.06010000E-04  +6.87050000E-04  +9.31000000E-06
   +2.67160000E-04  -1.41910000E-04  -8.36000000E-05  +6.31700000E-05  -2.71200000E-05
   -1.67680000E-04  -6.01400000E-05  +3.27200000E-05  -2.90700000E-05  +4.21510000E-04
   -1.57720000E-04  +3.82133000E-03  -4.01216000E-03  +6.92165000E-03  -1.12835000E-03
   -1.09571000E-03  -1.85440000E-04  +3.70000000E-07  +6.05600000E-05  +3.56900000E-05
   +1.38796900E-02  +1.22038620E-01  -1.55022520E-01  +2.06939610E-01  -2.04781960E-01
   +4.36194790E-01  -1.35100000E-04  +1.68200000E-04  +8.92700000E-05  +6.02400000E-05
   -1.49200000E-04  +1.02800000E-04  -8.42900000E-05  +2.31840000E-04  -3.72070000E-04
   +2.01900000E-04  +2.56980000E-04  -2.73100000E-05  +5.82400000E-05  -2.27700000E-04
   -1.51580000E-04  -6.81200000E-05  +3.90200000E-05  +2.16500000E-05  +4.25677000E-03
   -5.58900000E-05  -9.38460000E-04  -1.13330000E-04  +1.40920000E-04  -1.08290000E-04
   -6.08700000E-05  +1.78930000E-04  +1.15840000E-04  +1.53229800E-02  -6.14159400E-02
   +5.26042700E-02  -2.67213350E-01  -9.66931200E-02  -6.46924700E-02  +5.72412690E-01
   -7.76100000E-05  +5.64020000E-04  -4.11010000E-04  +8.86620000E-04  -7.74700000E-05
   -3.54100000E-05  -1.37830000E-04  +2.32540000E-04  -2.39490000E-04  -1.81060000E-04
   +5.18000000E-05  +4.99400000E-05  -1.27730000E-04  +7.79000000E-05  +1.41990000E-04
   -6.69200000E-05  -5.33500000E-05  -7.41500000E-05  +1.76460000E-04  -1.03168000E-03
   +5.61944000E-03  +7.06340000E-04  +6.62620000E-04  +3.11980000E-04  +6.66400000E-05
   -8.97500000E-05  -8.49800000E-05  -2.23386200E-02  -2.95184600E-02  +1.38833300E-02
   -1.46675560E-01  -1.80630460E-01  -5.40452000E-03  +1.59267200E-01  +5.72346690E-01
   -3.44000000E-06  +4.19000000E-05  +1.74840000E-04  -6.87380000E-04  -4.10670000E-04
   -2.09220000E-04  -6.13500000E-05  +2.19080000E-04  -6.12500000E-05  +1.08680000E-04
   +1.29520000E-04  -1.43700000E-05  +8.71600000E-05  -4.13020000E-04  -3.34490000E-04
   -6.44200000E-05  +1.25070000E-04  +1.12910000E-04  -1.17495000E-03  +4.64134000E-03
   +4.09420000E-04  +1.36800000E-05  +1.72050000E-04  -1.30450000E-04  -7.69700000E-05
   +3.14040000E-04  +2.21030000E-04  +2.17273600E-02  -1.19321100E-02  +3.24347900E-02
   -2.64079600E-02  +2.77279100E-02  -9.86826000E-02  +1.76428580E-01  -2.33445670E-01
   +4.21556480E-01  -7.67900000E-05  +1.81780000E-04  -7.74200000E-05  -1.39180000E-04
   +5.38330000E-04  +1.94100000E-05  +3.30540000E-04  -3.67460000E-04  -3.03860000E-04
   -8.10530000E-04  -3.17140000E-04  +3.25070000E-04  -3.64160000E-04  +1.06677000E-03
   +8.46920000E-04  +3.43830000E-04  -6.43190000E-04  -2.55830000E-04  -2.13732000E-03
   -3.33140000E-04  -2.05730000E-04  +6.43710000E-04  +1.84280000E-04  -1.95870000E-04
   +3.30880000E-04  -8.57280000E-04  -5.89720000E-04  -6.08390000E-03  +2.18666900E-02
   -1.73278500E-02  -4.55957000E-02  -2.21778200E-02  -1.50586700E-02  -1.97677950E-01
   +5.37605000E-02  -1.27055730E-01  +5.85220080E-01  -2.19670000E-04  +4.95330000E-04
   -1.68420000E-04  +6.75100000E-05  +7.74580000E-04  +3.46560000E-04  +2.20990000E-04
   -2.65800000E-05  -3.85450000E-04  -5.13330000E-04  -9.20500000E-05  +1.66450000E-04
   -2.98340000E-04  +1.05491000E-03  +9.61860000E-04  +2.75640000E-04  -8.18290000E-04
   -2.80870000E-04  +4.54020000E-04  -1.01606000E-03  +9.58720000E-04  +8.80430000E-04
   +6.16590000E-04  -3.12700000E-05  +2.96730000E-04  -8.52690000E-04  -6.40190000E-04
   +2.07201700E-02  -3.80312700E-02  +3.83515600E-02  +2.04586400E-02  +5.54618000E-02
   -2.70010800E-02  -6.63179000E-03  -1.37378860E-01  +4.74032800E-02  +1.41717020E-01
   +5.69462520E-01  +1.54640000E-04  -3.04040000E-04  +9.50000000E-05  -1.70170000E-04
   -9.63500000E-05  -1.80990000E-04  +3.29300000E-05  -1.25210000E-04  +1.63860000E-04
   -1.02620000E-04  -1.48110000E-04  +1.21500000E-05  +1.74800000E-05  -6.25800000E-05
   -1.11090000E-04  +1.02300000E-05  +1.36180000E-04  +3.13100000E-05  -1.19676000E-03
   +2.71970000E-04  -1.33486000E-03  -3.42470000E-04  -4.43200000E-04  +9.63100000E-05
   -1.71800000E-05  +6.00300000E-05  +6.52200000E-05  -1.63484700E-02  +3.90521000E-02
   -4.70726100E-02  -4.78104100E-02  -5.50577200E-02  +1.32506600E-02  -8.11548700E-02
   +8.79403000E-02  -1.90764920E-01  +1.74117800E-01  -2.16815200E-01  +4.46492730E-01
   +1.32980000E-04  -3.35030000E-04  +2.06200000E-04  -6.78300000E-05  -4.34890000E-04
   -3.49830000E-04  -1.44900000E-05  -2.06850000E-04  +1.86920000E-04  +1.22570000E-04
   -3.74800000E-05  +5.98800000E-05  +1.15990000E-04  -3.94750000E-04  -4.59290000E-04
   -8.26900000E-05  +3.53500000E-04  +1.43220000E-04  +1.21795000E-03  +8.07780000E-04
   -3.95773000E-03  -1.50227000E-03  -7.57900000E-04  -1.94900000E-04  -1.05630000E-04
   +3.26910000E-04  +2.82120000E-04  -4.15353100E-02  +1.66545100E-02  -4.54207800E-02
   -2.36410700E-02  -3.26072400E-02  +1.15616000E-02  +4.11766800E-02  +2.17621400E-02
   +5.12196000E-03  -1.17383720E-01  +4.99789000E-03  -3.48787300E-02  +6.10777940E-01
   +1.62390000E-04  -3.68950000E-04  +2.84410000E-04  -5.27570000E-04  -7.21590000E-04
   -4.53750000E-04  -1.48300000E-04  -1.43750000E-04  +2.52090000E-04  +1.52020000E-04
   -8.08000000E-05  -7.55700000E-05  +1.54980000E-04  -6.99220000E-04  -7.15710000E-04
   -1.81090000E-04  +6.14680000E-04  +1.73450000E-04  -2.04060000E-04  +1.64642000E-03
   +3.26878000E-03  -4.05900000E-05  -3.50260000E-04  +1.53820000E-04  -1.77340000E-04
   +5.57590000E-04  +4.56480000E-04  -2.08969900E-02  +4.97541100E-02  -4.59336000E-02
   -3.06043100E-02  -5.00919800E-02  +1.58855700E-02  +5.63192600E-02  +2.29912000E-03
   +4.25997600E-02  -5.16473000E-02  -2.44283750E-01  +9.82538500E-02  +1.38394650E-01
   +5.34200180E-01  -1.51400000E-04  +1.82770000E-04  +1.89780000E-04  -9.76340000E-04
   -7.48400000E-04  -5.86360000E-04  -1.89000000E-06  -1.83860000E-04  -1.20840000E-04
   -1.17760000E-04  -5.65800000E-05  +1.00490000E-04  -3.21500000E-05  +1.87200000E-05
   -9.02300000E-05  +8.71000000E-06  +8.99400000E-05  -4.07300000E-05  -3.82777000E-03
   +4.39835000E-03  +1.33896000E-03  +1.10194000E-03  +7.54310000E-04  +1.40820000E-04
   +2.75300000E-05  -2.83000000E-05  +2.58500000E-05  -1.67679700E-02  -2.15291400E-02
   +1.24256000E-02  +9.90805000E-03  +1.43956500E-02  -7.75046000E-03  -2.15108600E-02
   +1.94489900E-02  -2.07065000E-02  +8.78885000E-03  +1.36565460E-01  -1.70762790E-01
   +2.16803730E-01  -2.19087430E-01  +4.45426800E-01  -3.43800000E-04  +6.44670000E-04
   +4.75600000E-05  -1.36580000E-03  -1.69309000E-03  -9.34470000E-04  +9.76800000E-05
   +1.66040000E-04  -5.86000000E-04  -3.17800000E-05  +1.50340000E-04  +1.40350000E-04
   -5.67300000E-05  -1.33900000E-04  -1.16610000E-04  -7.61200000E-05  +2.59350000E-04
   -1.24110000E-04  -1.75433900E-02  +2.83450000E-03  -1.50390700E-02  -7.88370000E-04
   +1.09675000E-03  +1.10457000E-03  -3.96000000E-06  +9.11100000E-05  +7.41600000E-05
   -2.11728360E-01  -6.76491000E-03  -9.24537100E-02  +4.20494400E-02  +6.17385900E-02
   -2.56831800E-02  -5.85329700E-02  -1.10465300E-02  -2.80630300E-02  +1.81083200E-02
   -6.53390000E-02  +6.10478500E-02  -2.64818570E-01  -9.18549700E-02  -6.59675400E-02
   +5.63932870E-01  -2.93400000E-04  +3.46270000E-04  +2.23000000E-04  -1.34777000E-03
   -2.11621000E-03  -1.36633000E-03  +3.30300000E-05  +4.42000000E-06  +7.92100000E-05
   +8.66900000E-05  +9.83400000E-05  +1.08660000E-04  +2.58500000E-05  -4.23440000E-04
   -4.53190000E-04  -1.42760000E-04  +5.64800000E-04  -1.78500000E-05  -1.12303800E-02
   +9.23159000E-03  -1.18049000E-02  -2.05397000E-03  -1.13927000E-03  -1.50520000E-04
   -8.56400000E-05  +3.39850000E-04  +2.84170000E-04  +4.27146800E-02  -1.26271180E-01
   +7.40136800E-02  +2.32763400E-02  -1.38063000E-03  +2.30132000E-02  -8.39973000E-03
   -4.72890000E-03  -4.83925000E-03  -2.28059100E-02  -3.19123400E-02  +1.10423300E-02
   -1.41990250E-01  -1.77424850E-01  -5.59367000E-03  +1.48046570E-01  +5.71562230E-01
   -1.55500000E-04  +2.91200000E-04  +1.64220000E-04  +1.34007000E-03  +4.59300000E-04
   -3.44100000E-04  +3.28500000E-04  -2.91020000E-04  -6.76700000E-04  -2.66170000E-04
   +2.54600000E-05  +3.21480000E-04  -1.13810000E-04  +4.43670000E-04  +4.22540000E-04
   +4.29900000E-05  -5.75790000E-04  -5.84700000E-05  -5.18373000E-03  -2.30784000E-03
   +7.10770000E-04  +4.52450000E-04  +5.02000000E-04  +1.47930000E-04  +1.43940000E-04
   -3.77320000E-04  -2.98450000E-04  -1.30482710E-01  +4.19547400E-02  -1.87516730E-01
   +3.85667000E-03  +4.83757900E-02  -2.62699700E-02  -2.97929600E-02  -6.56198000E-03
   -1.84764000E-02  +2.80395800E-02  -1.72707000E-02  +3.43240900E-02  -2.74010500E-02
   +2.79469200E-02  -1.01095820E-01  +1.68431540E-01  -2.32785320E-01  +4.38557570E-01
   +1.79660000E-04  -4.30350000E-04  +3.03430000E-04  +3.22000000E-06  -1.05455000E-03
   -2.44410000E-04  -4.09490000E-04  +3.35140000E-04  +3.35830000E-04  +8.80070000E-04
   +3.21090000E-04  -3.06650000E-04  +4.40940000E-04  -1.48654000E-03  -1.27352000E-03
   -4.36800000E-04  +9.94020000E-04  +3.64640000E-04  +1.44589000E-03  +8.48830000E-04
   -2.59460000E-04  -1.26965000E-03  -5.35390000E-04  +3.55430000E-04  -4.26890000E-04
   +1.19386000E-03  +8.63350000E-04  -2.59824000E-03  -2.65250000E-03  +1.82221000E-03
   +3.48817000E-03  +3.27641000E-03  -5.06505000E-03  -4.04210000E-02  -2.86015700E-02
   -1.17143900E-02  -2.39377640E-01  -8.63682000E-02  -6.49750000E-02  -9.95571000E-03
   -1.96934500E-02  +3.33394000E-03  +1.53225000E-03  +1.17805000E-03  -3.19519000E-03
   +3.23745400E-01  +1.40720000E-04  -3.67830000E-04  +2.24120000E-04  -1.10900000E-05
   -7.99870000E-04  -1.83950000E-04  -3.26400000E-04  +2.45850000E-04  +2.20150000E-04
   +5.65860000E-04  +2.01190000E-04  -2.26860000E-04  +3.16370000E-04  -1.18463000E-03
   -1.01272000E-03  -3.19070000E-04  +8.07650000E-04  +2.83470000E-04  +1.02496000E-03
   +4.78340000E-04  -8.29070000E-04  -9.79040000E-04  -4.60160000E-04  +2.46150000E-04
   -3.16840000E-04  +9.46090000E-04  +6.88880000E-04  -3.07542000E-03  +1.90158000E-03
   -4.02510000E-03  -2.93391000E-03  -2.51777000E-03  +5.56509000E-03  +1.06740000E-04
   +8.08281000E-03  +1.25550000E-03  -1.23607950E-01  -1.45372390E-01  -4.95914000E-03
   -4.76538100E-02  -3.20066200E-02  -1.61396000E-03  +6.08852000E-03  +8.90490000E-04
   +7.42966000E-03  +1.54142710E-01  +5.08983440E-01  +7.03000000E-06  -1.20510000E-04
   +1.17170000E-04  -3.38000000E-05  -1.22580000E-04  -1.70000000E-05  -7.10200000E-05
   +2.20900000E-05  +9.10000000E-06  +1.13280000E-04  +3.99900000E-05  -3.85900000E-05
   +7.37900000E-05  -2.59970000E-04  -2.45710000E-04  -5.05200000E-05  +1.35780000E-04
   +8.45900000E-05  +5.46100000E-04  -2.78320000E-04  -1.33080000E-04  -1.19310000E-04
   -3.23000000E-06  -3.49000000E-06  -6.18200000E-05  +2.03640000E-04  +1.60140000E-04
   +1.58769000E-03  -4.18130000E-03  +3.09074000E-03  -3.61890000E-04  +9.69880000E-03
   -3.78240000E-04  -3.35354800E-02  -1.80146800E-02  +9.39520000E-04  -3.66255300E-02
   +1.98970200E-02  -8.34376600E-02  +2.48714600E-02  +1.72837700E-02  +1.10222400E-02
   -7.15806000E-03  +4.05247000E-03  -2.75189000E-03  +8.07915200E-02  -2.65133530E-01
   +2.83582130E-01  -1.85384000E-03  +1.55765000E-03  +1.13474000E-03  -6.87420000E-04
   +2.18366700E-02  -1.85110800E-02  -1.26803000E-03  +1.36509000E-03  -6.17650000E-04
   +9.69660000E-04  +1.29295000E-03  -2.90760000E-04  +3.41560000E-04  -1.75665000E-03
   -1.82906000E-03  -2.28564000E-03  -4.19400000E-05  +7.05420000E-04  -7.60487400E-02
   -4.80788000E-03  +5.03939000E-03  +1.74470000E-04  -1.45476000E-03  +3.05000000E-03
   -3.56180000E-04  +1.39863000E-03  +1.07256000E-03  -4.06055000E-03  -2.31709500E-02
   +1.99189900E-02  -4.83023000E-03  -1.86160000E-03  -2.02854000E-03  +2.21450000E-04
   -1.25121000E-03  +6.65330000E-04  +3.92010000E-04  +1.92550000E-04  -2.28000000E-05
   +1.75740000E-04  -5.65740000E-04  +6.66930000E-04  -1.70228000E-03  -1.12861000E-03
   +4.00990000E-04  -5.38020000E-04  -3.57970000E-04  -7.33400000E-05  +5.83408340E-01
   -8.86530000E-04  -9.91350000E-04  -1.32688000E-03  +6.62896000E-03  -2.37749500E-02
   +1.50775800E-02  +1.22488000E-03  -1.15175000E-03  +6.73830000E-04  +1.62180000E-04
   +1.09220000E-04  +6.01600000E-04  -1.72720000E-04  +7.13880000E-04  +6.85380000E-04
   +1.19085000E-03  +3.11250000E-04  -3.63580000E-04  -9.75524000E-03  -1.29642330E-01
   +5.00580400E-02  +5.60620000E-04  +8.57064000E-03  -4.62635000E-03  +8.93100000E-05
   -4.89240000E-04  -3.59950000E-04  -7.47125000E-03  -1.73125200E-02  +1.22382300E-02
   -2.52292000E-03  -1.52840000E-04  -6.29800000E-04  +3.33020000E-04  -5.03930000E-04
   +5.53370000E-04  -2.65810000E-04  +1.22820000E-04  -4.17100000E-05  +4.49480000E-04
   -5.76990000E-04  +5.96990000E-04  +2.81700000E-05  -2.45050000E-04  -7.54500000E-04
   +1.15580000E-04  +3.60800000E-05  +3.88000000E-05  -1.32016300E-02  +5.14813120E-01
   +1.09196000E-03  +3.08300000E-05  -2.77700000E-05  -5.99773000E-03  +4.60330000E-03
   +1.86242000E-03  +3.49140000E-04  -7.44990000E-04  +9.47200000E-05  +3.49310000E-04
   +5.47710000E-04  -7.00400000E-05  -9.34000000E-05  +9.19640000E-04  +1.33771000E-03
   +4.91490000E-04  -6.10800000E-04  -2.48480000E-04  +8.59498000E-03  +4.57610800E-02
   -1.20524890E-01  +4.14798000E-03  +2.37816600E-02  -3.44126100E-02  +1.69040000E-04
   -7.59660000E-04  -7.61210000E-04  +2.70982000E-03  -3.00956000E-03  +4.21420000E-03
   -2.04152000E-03  -7.21270000E-04  -4.34860000E-04  -3.81790000E-04  -4.04280000E-04
   +1.91340000E-04  +2.20950000E-04  +2.08400000E-05  +3.12830000E-04  -7.51800000E-05
   -7.71500000E-05  -6.15600000E-05  -1.20324000E-03  -1.04428000E-03  -2.36520000E-04
   -3.34220000E-04  -2.09410000E-04  -8.47300000E-05  +1.04159800E-02  +6.26956000E-02
   +5.42270610E-01  -3.04896000E-03  +5.55262000E-03  +4.46467000E-03  +1.08763000E-03
   -1.99957000E-03  -1.14904500E-02  -5.23200800E-02  -3.40431100E-02  -2.59437000E-03
   -2.64974880E-01  -1.01925350E-01  -1.04865400E-02  -4.42003000E-03  +2.21845000E-03
   +2.12868000E-03  +3.24599000E-03  +7.41290000E-04  -3.35964000E-03  +7.60440000E-04
   -3.43450000E-04  +1.80105000E-03  -9.72420000E-04  +4.13460000E-04  -1.62860000E-04
   +2.76269000E-03  -3.71757000E-03  -2.95651000E-03  -9.39800000E-05  +3.12520000E-04
   +6.09800000E-05  -1.52690000E-04  +4.04880000E-04  +5.97800000E-05  -1.06090000E-04
   +2.62320000E-04  -1.14460000E-04  +8.90430000E-04  +5.90050000E-04  +2.79200000E-05
   -1.19280000E-04  -2.30420000E-04  +1.68060000E-04  +3.00520000E-04  -5.06700000E-05
   +5.19260000E-04  -9.65440000E-04  -6.26990000E-04  -1.07690000E-04  -7.85900000E-05
   -1.72000000E-04  -1.58990000E-04  +3.68258100E-01  +3.65061000E-03  +2.66122000E-03
   +3.68654000E-03  +2.56667000E-03  -4.83424000E-03  -5.04689000E-03  -2.27152000E-02
   +1.09491000E-03  +2.08279000E-03  -1.16522090E-01  -1.20001200E-01  -3.88526500E-02
   -9.91820000E-04  +2.85300000E-05  -3.82200000E-04  -1.23993000E-03  -7.17380000E-04
   +1.09326000E-03  +4.04000000E-05  -3.85280000E-04  +6.88500000E-04  -5.47500000E-04
   +3.16290000E-04  -1.00370000E-04  +2.84900000E-05  -7.51460000E-04  -1.51340000E-04
   +2.75300000E-05  +3.18610000E-04  -4.49800000E-05  +1.06610000E-04  +2.71040000E-04
   +9.78000000E-06  -1.33600000E-04  +9.07300000E-05  -9.49700000E-05  +4.41830000E-04
   +2.09960000E-04  +7.54900000E-05  -3.23000000E-06  +3.38000000E-06  +7.31100000E-05
   +6.52200000E-05  -8.70800000E-05  +2.93500000E-04  -4.37870000E-04  -2.61280000E-04
   -4.43700000E-05  -9.07510000E-04  -2.90240000E-04  -3.95890000E-04  +1.44884270E-01
   +2.05562260E-01  -3.33170000E-04  +4.10425000E-03  +4.25030000E-04  -4.39370000E-04
   +3.34732000E-03  -3.84746000E-03  +1.29808900E-02  +6.50703000E-03  +2.02634100E-02
   -4.70155200E-02  -5.34669800E-02  -1.19264000E-01  -1.76246000E-03  -6.42910000E-04
   -8.35420000E-04  +3.93782000E-03  -2.64210000E-04  -3.08136000E-03  +6.57430000E-04
   +9.94530000E-04  +1.13259000E-03  -3.67770000E-04  +1.72360000E-04  -2.17600000E-05
   +1.28927000E-03  -1.37117000E-03  -3.42600000E-04  +3.32550000E-04  -2.61810000E-04
   -7.44200000E-05  +2.73400000E-05  +5.02500000E-05  -5.59600000E-05  -9.14000000E-06
   -2.02300000E-05  +3.19100000E-05  +2.24600000E-05  -2.97900000E-05  +2.87600000E-05
   +4.61800000E-05  +7.50100000E-05  +4.96500000E-05  -1.54900000E-05  +3.68100000E-05
   -6.20200000E-05  +2.38800000E-05  +3.78100000E-05  +2.96200000E-05  +1.20000000E-05
   -1.91800000E-04  -2.48620000E-04  -3.68187000E-03  +2.24315860E-01  +5.44940240E-01
   -2.46300000E-05  +6.89000000E-05  -4.11400000E-05  +2.82000000E-06  +4.45300000E-05
   +1.58900000E-05  +2.65700000E-05  -1.05900000E-05  -5.77100000E-05  -1.55800000E-04
   -5.33400000E-05  +3.70600000E-05  -6.29800000E-05  +1.05200000E-04  +9.34200000E-05
   +4.48600000E-05  -6.26100000E-05  -3.80600000E-05  -1.82210000E-04  +5.17800000E-05
   -9.63700000E-05  +5.13000000E-05  -7.77000000E-06  +1.20000000E-05  +5.08100000E-05
   -8.98900000E-05  -6.19800000E-05  -2.17400000E-05  +5.39400000E-04  -5.20760000E-04
   -6.51540000E-04  -2.44330000E-04  +2.00670000E-04  +1.55883000E-03  -6.77000000E-04
   +2.14038000E-03  -5.34454000E-03  -3.60857500E-02  +2.58699400E-02  -5.16709000E-03
   -3.04888000E-03  -2.56206000E-03  +1.46102000E-03  -1.11021000E-03  +6.74370000E-04
   -3.57562400E-02  +1.48243500E-02  -3.28366100E-02  +7.45100000E-05  +1.40200000E-05
   +3.22700000E-05  +1.62450000E-04  +8.14500000E-05  +1.21200000E-05  +4.49950300E-02
   -3.64400000E-05  +8.73300000E-05  -5.07800000E-05  +1.00100000E-05  +1.31890000E-04
   +3.75300000E-05  +6.40800000E-05  -5.31900000E-05  -3.61000000E-05  -1.11670000E-04
   -4.11400000E-05  +4.53700000E-05  -7.45000000E-05  +2.81360000E-04  +2.31490000E-04
   +6.35000000E-05  -1.67560000E-04  -7.21200000E-05  -1.85960000E-04  -8.71500000E-05
   -1.69000000E-06  +1.10540000E-04  +4.25900000E-05  -3.05600000E-05  +6.97500000E-05
   -2.22340000E-04  -1.58110000E-04  +7.44600000E-05  +5.78290000E-04  -3.84980000E-04
   +6.71000000E-06  -1.09306000E-03  +3.44750000E-04  +4.18400000E-03  +4.04566000E-03
   -9.59640000E-04  -1.14091000E-03  -2.52262900E-02  +1.64108500E-02  -4.16150000E-03
   +5.74790000E-04  -1.63345000E-03  +2.67150000E-04  -2.11870000E-04  +1.65748000E-03
   -2.29708100E-02  -3.40633520E-01  +2.42009560E-01  +7.07100000E-05  -1.34000000E-05
   +2.81400000E-05  +1.24620000E-04  +4.89200000E-05  -9.12000000E-06  +2.44322600E-02
   +3.61801100E-01  +8.71000000E-06  +4.71000000E-06  -1.64000000E-05  +8.07000000E-06
   -3.13400000E-05  +2.45700000E-05  +1.13400000E-05  +1.08900000E-05  +1.79300000E-05
   +2.42300000E-05  +1.41900000E-05  -4.17000000E-06  -3.26000000E-06  +3.20300000E-05
   +3.92600000E-05  -5.07000000E-06  +8.10000000E-06  -2.28100000E-05  +7.39400000E-05
   +5.95100000E-05  -1.40500000E-04  -1.01300000E-04  -6.90700000E-05  +2.87500000E-05
   -3.14000000E-06  -1.97600000E-05  -2.20400000E-05  -1.61600000E-04  +3.59000000E-06
   +5.28800000E-05  +1.00500000E-05  +1.51920000E-04  -7.80790000E-04  -1.57438000E-03
   -4.20031000E-03  +1.25901000E-03  -8.06190000E-04  -6.97690000E-03  +2.03751000E-03
   -1.68416000E-03  -8.50100000E-04  +1.64254000E-03  -3.64330000E-04  +7.58720000E-04
   +9.05530000E-04  -3.98448000E-03  +2.67259010E-01  -2.10373630E-01  -4.15000000E-06
   +5.45000000E-06  -1.01400000E-05  -3.66200000E-05  -2.40200000E-05  -1.61700000E-05
   +8.54389000E-03  -2.56676610E-01  +2.06002900E-01  +2.81000000E-05  -6.95200000E-05
   +2.81900000E-05  +1.14180000E-04  -6.19900000E-05  -3.62700000E-05  -5.68600000E-05
   +6.19900000E-05  -3.77200000E-05  -5.80000000E-07  +1.72200000E-05  -7.45000000E-06
   +1.90500000E-05  -2.18430000E-04  -1.63090000E-04  -4.63600000E-05  +1.52270000E-04
   +3.46800000E-05  +5.11700000E-04  -8.80310000E-04  +7.80440000E-04  -5.61000000E-06
   +4.77900000E-05  +1.28350000E-04  -3.76100000E-05  +1.72530000E-04  +1.19820000E-04
   -2.27790000E-03  -4.21197000E-03  -3.33785000E-03  +1.36993000E-03  -2.19323400E-02
   +1.58728300E-02  -5.79660700E-02  -3.20834200E-02  +7.93578000E-03  +5.89525000E-03
   +1.71778300E-02  -1.18197500E-02  -1.58281000E-03  +1.07160000E-04  -4.80332000E-03
   -1.54424000E-03  -1.22350000E-04  -3.46200000E-04  +1.69696000E-03  +2.47392000E-03
   +1.82217000E-03  -3.80050000E-04  -9.18700000E-05  -1.51160000E-04  -1.10400000E-05
   +7.19000000E-06  +1.12900000E-05  -6.61180000E-04  -1.00571000E-03  -4.15900000E-05
   +5.50053200E-02  +1.99700000E-05  -3.62300000E-05  +2.10500000E-05  +1.61170000E-04
   -1.02210000E-04  -2.17200000E-05  -4.71300000E-05  +2.76200000E-05  +2.58200000E-05
   +8.22100000E-05  +3.63200000E-05  -2.26600000E-05  +3.49800000E-05  -1.32070000E-04
   -1.06790000E-04  -4.20100000E-05  +1.06470000E-04  +1.82700000E-05  +2.56500000E-04
   -2.99770000E-04  +7.93720000E-04  -7.04700000E-05  -6.58000000E-06  +2.02300000E-05
   -4.17200000E-05  +1.10940000E-04  +7.77700000E-05  -4.60858000E-03  +2.18759000E-03
   +8.91980000E-04  +1.57200000E-04  -1.11421600E-02  +1.04651600E-02  -3.22593700E-02
   -2.40118740E-01  +1.35257910E-01  -6.35866000E-03  -5.83838000E-03  +3.28650000E-03
   +5.67580000E-04  +2.52015000E-03  +2.59065000E-03  +2.10540000E-04  +1.91450000E-04
   -6.58880000E-04  +1.97743000E-03  +1.44092000E-03  -2.69893000E-03  -2.91150000E-04
   -1.23810000E-04  -1.69810000E-04  -9.21400000E-05  -3.80300000E-05  -6.81000000E-06
   +1.14679000E-03  +1.77100000E-05  +1.17521000E-03  +3.79337900E-02  +2.52648620E-01
   -2.57300000E-05  +7.27500000E-05  -5.80600000E-05  +1.16690000E-04  +2.37200000E-05
   +6.06900000E-05  +2.99300000E-05  -3.65600000E-05  +3.10900000E-05  +1.13500000E-05
   -8.50000000E-07  +3.58000000E-06  -2.90500000E-05  +1.73530000E-04  +1.48970000E-04
   +2.78000000E-05  -8.24200000E-05  -5.40600000E-05  -2.74340000E-04  +8.50000000E-07
   +3.00690000E-04  +3.21100000E-05  +7.05000000E-06  -4.88000000E-05  +2.56500000E-05
   -1.30350000E-04  -9.75600000E-05  -2.87848000E-03  +1.46698000E-03  +4.45031000E-03
   -9.57750000E-04  -4.43196000E-03  +5.22294000E-03  +8.19624000E-03  +1.35196820E-01
   -1.30278090E-01  +5.87212000E-03  +1.90785600E-02  -6.45572000E-03  -5.16585000E-03
   +2.26474000E-03  +2.59020000E-04  -5.08730000E-04  -8.82120000E-04  -5.34770000E-04
   +2.28274000E-03  -2.33033000E-03  -5.79210000E-04  -1.78700000E-05  -7.19200000E-05
   -2.98100000E-05  -8.55000000E-06  -1.17500000E-05  -2.19800000E-05  -1.67727000E-03
   -2.69750000E-04  -3.46450000E-04  -7.47629000E-03  -1.48697600E-01  +1.30806680E-01
   -7.13700000E-04  +5.07400000E-05  -9.97100000E-05  -5.40210000E-04  -1.09636000E-03
   +7.24500000E-04  +2.39400000E-05  +2.20200000E-05  -1.79210000E-04  -1.66360000E-04
   -2.47700000E-05  -3.79800000E-05  -8.19700000E-05  +3.55510000E-04  +3.21280000E-04
   +2.74100000E-05  -1.68530000E-04  -1.04660000E-04  -1.22509000E-03  +4.38900000E-04
   +9.59890000E-04  -8.10900000E-05  -1.29650000E-04  -1.86590000E-04  +6.42500000E-05
   -2.51080000E-04  -1.88200000E-04  +6.69075000E-03  -8.76460000E-04  +2.31472000E-03
   -1.86202010E-01  +5.09501400E-02  -1.33869420E-01  -1.32342600E-02  +8.71599000E-03
   -1.79177600E-02  -6.68850000E-04  -5.15706000E-03  -1.66549000E-03  -3.30680000E-04
   -3.39430000E-04  +8.42540000E-04  +2.14217000E-03  -2.41212000E-03  -8.90210000E-04
   -1.31998000E-03  +1.68650000E-04  -9.32750000E-04  -3.35500000E-05  +1.37350000E-04
   +1.57450000E-04  +1.43670000E-04  +5.52700000E-05  -5.90000000E-07  +1.14720000E-04
   +2.26580000E-04  -8.49100000E-05  -2.30550000E-04  +1.14259000E-03  +1.86092000E-03
   +1.95144530E-01  -3.99510000E-04  +3.26410000E-04  -2.78800000E-04  -5.59600000E-05
   +4.56300000E-05  +4.80400000E-04  +2.49600000E-05  +1.14000000E-05  +1.75770000E-04
   -8.58000000E-06  -6.17400000E-05  -1.03850000E-04  -1.02900000E-05  +4.31770000E-04
   +3.71260000E-04  +7.04400000E-05  -2.73480000E-04  -1.40890000E-04  +1.59767000E-03
   -4.71680000E-04  -9.50740000E-04  -2.07010000E-04  -6.54710000E-04  +3.44240000E-04
   +7.98900000E-05  -3.65720000E-04  -2.78640000E-04  +1.92685800E-02  -1.62868000E-03
   +1.70896400E-02  +5.11017400E-02  -7.87729400E-02  +6.25492300E-02  -1.34892200E-02
   +8.53121000E-03  -1.22736100E-02  -4.86367000E-03  +4.80540000E-04  +2.39196000E-03
   -4.42400000E-04  -9.76940000E-04  -4.46440000E-04  -2.83558000E-03  -2.56573000E-03
   +4.98808000E-03  -7.79050000E-04  +1.74940000E-04  -7.21860000E-04  +5.88700000E-05
   +2.59300000E-05  -1.02210000E-04  +4.75000000E-06  -2.95500000E-05  -4.35900000E-05
   +6.92800000E-05  +1.08710000E-04  -5.76100000E-05  +1.55247000E-03  -6.31330000E-04
   -1.87917000E-03  -5.15182900E-02  +7.71817100E-02  +8.43100000E-05  -5.76250000E-04
   +4.42530000E-04  -5.13700000E-05  +1.85140000E-04  -6.31800000E-05  +1.96800000E-05
   -2.24310000E-04  -4.79000000E-05  +1.99430000E-04  +5.99000000E-06  -3.26600000E-05
   +1.91010000E-04  -1.24860000E-04  -2.41940000E-04  +2.27400000E-05  +8.91200000E-05
   +7.54300000E-05  +8.95000000E-05  -1.69558000E-03  -1.79299000E-03  -4.70000000E-05
   -1.63920000E-04  -1.25900000E-05  -9.46200000E-05  +1.43320000E-04  +1.44020000E-04
   -1.27735400E-02  +4.17493000E-03  -6.99391000E-03  -1.33180530E-01  +6.17859500E-02
   -1.72368880E-01  -1.60755000E-03  +2.40981000E-03  +1.09911000E-03  -2.01350000E-03
   +2.06690000E-03  +5.17607000E-03  +1.00669000E-03  -3.19880000E-04  -3.11810000E-04
   -8.42280000E-04  +5.44316000E-03  +1.90803000E-03  -3.31100000E-04  -8.65200000E-05
   -1.95970000E-04  +2.48170000E-04  -3.74400000E-05  -3.90000000E-06  -2.05780000E-04
   -7.75300000E-05  +3.90600000E-05  +5.97000000E-05  +5.69900000E-05  -3.92800000E-05
   +1.65801000E-03  -2.18688000E-03  -1.84541000E-03  +1.48284090E-01  -7.03592000E-02
   +1.76110950E-01  -3.79100000E-05  -1.12000000E-05  +6.95400000E-05  -2.56140000E-04
   -1.36190000E-04  +1.94400000E-05  +1.45050000E-04  -1.25930000E-04  -1.28800000E-05
   -1.10310000E-04  -7.29900000E-05  +8.44200000E-05  -3.67600000E-05  +1.24210000E-04
   +4.81500000E-05  +6.87000000E-05  -4.91200000E-05  -2.53800000E-05  -7.72200000E-05
   +1.19490000E-03  +1.55329000E-03  +3.50300000E-04  -5.59400000E-05  +1.11470000E-04
   +4.13000000E-05  -1.02060000E-04  -4.88400000E-05  +8.13099000E-03  +1.75939600E-02
   -1.11996700E-02  -1.60807000E-03  -8.55300000E-05  -5.41659000E-03  -1.31354000E-03
   +5.42000000E-06  -1.70780000E-04  -1.85654000E-03  -4.14719000E-03  -3.44820000E-03
   +7.49930000E-04  -2.23520700E-02  +1.50743700E-02  -5.81009700E-02  -3.01099200E-02
   +1.07853300E-02  -5.68600000E-05  -1.15021000E-03  +8.21060000E-04  -1.81596000E-03
   -6.63980000E-04  -1.13880000E-03  +8.17600000E-05  +2.34600000E-05  +2.05000000E-05
   -3.46310000E-04  -1.92300000E-04  +4.71900000E-05  -1.05370000E-04  +1.88960000E-04
   +2.78050000E-04  +2.73520000E-04  +1.03599000E-03  -6.64680000E-04  +5.83906600E-02
   +6.87000000E-05  -3.70300000E-05  -1.09570000E-04  +2.71480000E-04  +3.10460000E-04
   +3.66160000E-04  -1.10000000E-07  +1.15190000E-04  +1.12300000E-05  +4.84000000E-05
   +4.17300000E-05  -5.08900000E-05  -2.48000000E-06  +8.04100000E-05  +1.35610000E-04
   +2.90500000E-05  -8.60900000E-05  -1.86400000E-05  +3.32430000E-04  -1.98574000E-03
   -1.25604000E-03  -3.01250000E-04  -1.55990000E-04  -1.28850000E-04  +8.41000000E-06
   -6.03500000E-05  -7.24300000E-05  -1.52228000E-03  -2.81692000E-03  +4.62806000E-03
   -6.78000000E-05  +2.60034000E-03  +3.13034000E-03  +1.38310000E-04  +1.53460000E-04
   -8.60320000E-04  -4.25883000E-03  +2.51276000E-03  +1.45920000E-03  -5.70810000E-04
   -1.03893500E-02  +1.07930000E-02  -2.97269300E-02  -2.42579420E-01  +1.38647130E-01
   -2.29380000E-04  -8.91380000E-04  +5.73780000E-04  -2.22286000E-03  -4.38310000E-04
   -5.82770000E-04  -5.08400000E-05  -4.34100000E-05  -4.07600000E-05  -1.12310000E-04
   -1.51390000E-04  -1.03660000E-04  +1.59990000E-04  -2.83100000E-04  -2.47860000E-04
   -1.63820000E-04  -2.54910000E-04  +1.04840000E-04  +3.85742400E-02  +2.55871940E-01
   +2.15900000E-05  -5.48700000E-05  -6.94000000E-05  +2.93840000E-04  +1.33390000E-04
   +3.43170000E-04  +3.13100000E-05  +3.32000000E-05  +6.48000000E-05  +4.08100000E-05
   +2.05200000E-05  +1.25000000E-06  -2.61000000E-06  +1.33620000E-04  +1.28710000E-04
   +5.23500000E-05  -1.09110000E-04  -1.96200000E-05  +2.38739000E-03  -5.53430000E-04
   -1.80917000E-03  -6.51490000E-04  -1.97900000E-04  -7.25400000E-05  +2.21800000E-05
   -1.03110000E-04  -8.39100000E-05  +3.82867000E-03  +1.75381600E-02  -6.71347000E-03
   -5.47380000E-03  +2.85244000E-03  +7.46370000E-04  -2.16280000E-04  -9.35370000E-04
   -5.02200000E-04  -3.39961000E-03  +1.51175000E-03  +4.54569000E-03  -1.87791000E-03
   -3.93992000E-03  +5.85981000E-03  +1.05042800E-02  +1.38835390E-01  -1.40573680E-01
   +1.22120000E-04  -4.89200000E-05  +1.58030000E-04  -3.85800000E-05  +6.11560000E-04
   +4.20930000E-04  -6.42200000E-05  -6.40600000E-05  -2.34400000E-05  -1.61900000E-05
   -1.61190000E-04  -8.21700000E-05  +3.02760000E-04  -2.13690000E-04  -3.60370000E-04
   +2.43650000E-04  +9.18910000E-04  -5.18070000E-04  -8.48429000E-03  -1.52844690E-01
   +1.40353220E-01  -1.50900000E-05  +1.89900000E-05  +5.16200000E-05  -1.95000000E-05
   -2.03470000E-04  -1.31510000E-04  -4.69200000E-05  +5.83000000E-06  +1.83700000E-05
   +4.15200000E-05  +1.17100000E-05  -8.02000000E-06  +2.09200000E-05  -1.25870000E-04
   -1.27940000E-04  -4.24800000E-05  +9.44900000E-05  +2.80000000E-05  -1.07630000E-04
   +6.44430000E-04  -7.40270000E-04  -2.27100000E-04  -9.30300000E-05  +5.64300000E-05
   -2.58100000E-05  +9.72600000E-05  +8.06800000E-05  -1.18740000E-03  -5.07533000E-03
   -1.75615000E-03  -3.08710000E-04  -4.13290000E-04  +8.25740000E-04  +1.87901000E-03
   -2.24019000E-03  -8.28580000E-04  +5.63704000E-03  -3.11587000E-03  +2.60213000E-03
   -1.88426190E-01  +4.75354300E-02  -1.40058760E-01  -1.24399200E-02  +8.94925000E-03
   -1.70438100E-02  -3.84900000E-05  +1.43804000E-03  +1.27916000E-03  -1.78700000E-05
   +1.09140000E-04  -2.46400000E-05  -3.75600000E-05  -1.36400000E-05  +1.96500000E-05
   -1.04000000E-04  +2.11290000E-04  +1.46250000E-04  +2.71730000E-04  -9.58200000E-05
   +3.02690000E-04  -1.77610000E-04  +2.36380000E-04  +1.75680000E-04  -3.12490000E-04
   +1.20856000E-03  +1.88608000E-03  +1.95670780E-01  +3.10000000E-07  -1.09700000E-05
   +8.54000000E-06  -1.50550000E-04  -2.02420000E-04  -7.65000000E-05  -2.98000000E-06
   +1.52000000E-06  +1.23200000E-05  +2.41000000E-05  +1.48300000E-05  +2.72000000E-06
   +7.76000000E-06  -5.18200000E-05  -5.41800000E-05  -1.41400000E-05  +8.18500000E-05
   -1.71000000E-06  -4.90700000E-04  +4.87120000E-04  -3.42860000E-04  -5.97600000E-05
   +2.27200000E-05  +5.10400000E-05  -1.55900000E-05  +4.44000000E-05  +3.52200000E-05
   -4.71314000E-03  +5.48120000E-04  +1.91845000E-03  -6.55390000E-04  -1.23609000E-03
   -2.86750000E-04  -2.67369000E-03  -2.54628000E-03  +4.50461000E-03  +1.97585800E-02
   -1.04664000E-03  +1.82995600E-02  +4.63315000E-02  -7.39428700E-02  +6.11607800E-02
   -1.25020200E-02  +8.57671000E-03  -1.31075800E-02  +1.22303000E-03  +5.80990000E-04
   -2.38154000E-03  +8.45500000E-05  +4.89700000E-05  -4.65900000E-05  -2.25300000E-05
   -1.93000000E-05  -1.90000000E-07  +1.31020000E-04  +1.39120000E-04  -4.53860000E-04
   +9.58590000E-04  -3.45640000E-04  +8.38070000E-04  +2.00890000E-04  -1.40980000E-04
   -2.90320000E-04  +1.62527000E-03  -6.71110000E-04  -1.88156000E-03  -4.90384600E-02
   +6.97047800E-02  +8.11000000E-06  -3.30400000E-05  +1.79100000E-05  -1.23460000E-04
   -1.19310000E-04  -4.17700000E-05  -9.46000000E-06  +1.00600000E-05  +1.30300000E-05
   +4.81400000E-05  +2.12200000E-05  -1.13900000E-05  +2.16900000E-05  -5.88800000E-05
   -5.57300000E-05  -1.81600000E-05  +6.46700000E-05  +8.39000000E-06  -4.34000000E-05
   +2.13900000E-04  +1.73780000E-04  -8.48000000E-06  +6.41200000E-05  +2.56200000E-05
   -2.19400000E-05  +4.96700000E-05  +3.66200000E-05  -1.81536000E-03  +1.65092000E-03
   +4.67036000E-03  +1.09164000E-03  -3.94000000E-05  -2.89290000E-04  -4.95990000E-04
   +4.81716000E-03  +1.59339000E-03  -1.50775500E-02  +2.72420000E-03  -6.94943000E-03
   -1.39173310E-01  +6.21085600E-02  -1.77507020E-01  -5.71070000E-04  +1.36404000E-03
   +1.09924000E-03  +1.46242000E-03  -2.21208000E-03  -8.84660000E-04  +1.78700000E-05
   -2.50700000E-05  -6.71300000E-05  -4.68900000E-05  -2.71900000E-05  -3.49000000E-06
   +2.06660000E-04  -3.99770000E-04  -1.08410000E-04  -5.20650000E-04  +1.45620000E-04
   -5.25910000E-04  +1.77110000E-04  -2.67240000E-04  -3.78100000E-04  +1.56947000E-03
   -2.18769000E-03  -1.74764000E-03  +1.53323030E-01  -6.79242900E-02  +1.80924090E-01
   -3.88000000E-05  +1.58730000E-04  +9.45600000E-05  -8.52900000E-05  -1.17620000E-04
   -8.44620000E-04  -3.25600000E-05  +4.38960000E-04  -2.92300000E-05  -2.10870000E-04
   +3.78710000E-04  +2.05170000E-04  -8.39700000E-05  +9.39900000E-05  -5.57200000E-05
   +5.29100000E-05  -3.96300000E-05  +8.33000000E-06  -1.82422000E-03  +1.24240000E-03
   +3.33136000E-03  -2.54050000E-04  -6.77530000E-04  +5.99120000E-04  +6.45700000E-05
   -7.82500000E-05  +3.10000000E-06  +3.20820000E-04  +4.79800000E-04  +3.74270000E-04
   -8.52400000E-05  -7.93800000E-05  +2.34000000E-06  +1.43400000E-04  +1.15330000E-04
   +7.57000000E-06  -8.21600000E-05  -1.96000000E-06  -5.18200000E-05  -1.06770000E-04
   +9.39000000E-05  -2.59760000E-04  -1.31190000E-04  -5.96030000E-04  +6.25390000E-04
   +1.11430000E-04  +1.19760000E-04  -9.26000000E-06  -4.75231900E-02  +2.93705000E-03
   +8.00323000E-03  -4.68700000E-05  -2.69310000E-04  +4.76300000E-05  -9.49000000E-06
   -1.12700000E-05  +2.16000000E-06  +1.32800000E-05  +1.59700000E-05  -1.00100000E-05
   +1.26000000E-06  +6.53100000E-05  -3.94200000E-05  -1.47488000E-03  +1.18490000E-04
   +2.78080000E-04  -1.55700000E-05  -5.09000000E-06  +2.32000000E-05  +4.88634800E-02
   +1.30130000E-04  -6.40300000E-05  -3.95900000E-05  -2.82150000E-04  +9.18530000E-04
   +1.33380000E-04  +5.87650000E-04  -1.01610000E-03  +4.12360000E-04  +9.70770000E-04
   -2.52680000E-04  -2.46330000E-04  +8.29500000E-05  -1.20040000E-04  -1.69200000E-05
   -9.50000000E-05  +4.36100000E-05  +7.96000000E-06  -5.29300000E-04  +9.78071000E-03
   +2.27157700E-02  -2.42170000E-04  -3.68866000E-03  +2.62659000E-03  -5.64300000E-05
   +9.34300000E-05  +2.43900000E-05  +3.23410000E-04  +1.10992000E-03  -3.30600000E-04
   +2.14080000E-04  -2.13130000E-04  -1.52400000E-05  +1.64020000E-04  +6.06900000E-05
   +6.63500000E-05  -1.15650000E-04  +8.10400000E-05  -1.98440000E-04  -7.75600000E-05
   -2.42020000E-04  +9.50500000E-05  -6.18810000E-04  +3.19170000E-04  -2.06040000E-04
   +5.39800000E-05  +6.70000000E-07  +3.21300000E-05  +3.07746000E-03  -8.12574400E-02
   -9.03374400E-02  -7.37830000E-04  -3.12930000E-04  -1.43950000E-04  -1.21300000E-05
   -7.90000000E-06  +5.45000000E-06  +1.98000000E-06  +1.89300000E-05  +2.19600000E-05
   -2.27500000E-05  +4.00800000E-05  +3.38200000E-05  -3.70250000E-04  -1.72950000E-04
   +1.68890000E-04  -1.73300000E-05  +2.54200000E-05  +2.43000000E-05  -2.75046000E-03
   +8.73317800E-02  -1.75930000E-04  +6.70000000E-07  -1.61100000E-05  +6.68810000E-04
   -7.09300000E-04  -3.63490000E-04  +8.49840000E-04  -8.53230000E-04  +1.06420000E-04
   -6.77010000E-04  -8.27300000E-04  +6.76180000E-04  -1.14780000E-04  -1.75230000E-04
   -4.39400000E-04  -2.19000000E-05  +1.04310000E-04  +2.06150000E-04  +4.01070000E-04
   -8.37391000E-03  -1.89773000E-02  +3.56340000E-04  +4.74918000E-03  -2.33645000E-03
   +3.91700000E-05  +1.31350000E-04  +2.46430000E-04  -8.93200000E-04  -8.97500000E-04
   +5.57580000E-04  +9.48100000E-05  +4.35360000E-04  +6.34100000E-05  -1.83340000E-04
   -1.41910000E-04  -2.88600000E-05  +5.22200000E-05  -1.80000000E-04  +7.40500000E-05
   +2.55800000E-04  +2.13400000E-05  +2.81010000E-04  -4.97340000E-04  +3.60320000E-04
   -1.75200000E-05  +1.72700000E-05  -8.15000000E-06  +2.51500000E-05  +7.70237000E-03
   -8.77338100E-02  -2.84496740E-01  +3.61930000E-04  +4.37630000E-04  +1.28670000E-04
   +3.15000000E-06  -8.46000000E-06  -7.99000000E-06  +2.59900000E-05  -1.30800000E-05
   -2.74300000E-05  +1.31600000E-05  -1.04240000E-04  +2.29800000E-05  +3.51170000E-04
   -3.42890000E-04  +2.42440000E-04  +1.48600000E-05  +3.39300000E-05  +8.35000000E-06
   -9.04338000E-03  +9.57298400E-02  +3.09679380E-01  +8.37390000E-04  -7.49100000E-05
   +3.23710000E-04  +2.48340000E-04  +2.46140000E-04  -2.42660000E-04  +6.86500000E-05
   -1.70830000E-04  -2.51100000E-04  -6.00000000E-05  -2.01300000E-04  -9.42000000E-05
   +1.01920000E-04  -3.65160000E-04  -3.25630000E-04  -1.58930000E-04  +2.51640000E-04
   +9.36300000E-05  +2.45455000E-03  -2.96118000E-03  -6.87600000E-05  +2.61700000E-04
   -3.87830000E-04  +1.93620000E-04  -9.65900000E-05  +2.76950000E-04  +2.06040000E-04
   +9.53200000E-05  +5.47000000E-06  -3.21800000E-04  +1.14090000E-04  +7.50800000E-05
   +4.18200000E-05  +7.06700000E-05  +2.26700000E-05  +3.81800000E-05  -1.86430000E-04
   +2.58900000E-05  -3.82400000E-05  +6.54700000E-05  -1.80730000E-04  +1.94110000E-04
   -7.01240000E-04  -6.82890000E-04  -7.88810000E-04  +1.03110000E-04  +3.37200000E-05
   +3.50300000E-05  -1.98948130E-01  +1.31626680E-01  +1.73274300E-02  +2.65900000E-05
   +1.79710000E-04  +4.05100000E-05  -1.86500000E-05  -1.29400000E-05  +4.08000000E-06
   +1.49300000E-05  +1.94600000E-05  +5.46000000E-06  -8.42000000E-06  -6.51000000E-06
   +9.50000000E-07  -8.87460000E-04  -1.57115000E-03  -3.37730000E-04  +3.49800000E-05
   -8.59000000E-06  -2.79200000E-05  -3.12450000E-04  -1.15385000E-03  -3.34090000E-04
   +2.15828980E-01  +2.98780000E-04  -3.61890000E-04  -4.26620000E-04  -1.12143000E-03
   -2.67708000E-03  +3.83964000E-03  +3.93280000E-04  +6.38600000E-05  +3.66530000E-04
   -6.27680000E-04  -2.47720000E-04  +4.56400000E-05  -1.85980000E-04  +7.51690000E-04
   +7.53870000E-04  +7.24460000E-04  -2.63660000E-04  -1.49230000E-04  +1.86287800E-02
   -1.55369900E-02  -3.11177000E-03  +4.04920000E-04  +5.56020000E-04  -1.54319000E-03
   +1.67910000E-04  -5.77060000E-04  -4.44660000E-04  +7.64900000E-04  +8.06310000E-04
   -3.75080000E-04  -3.12940000E-04  -1.51480000E-04  +1.72910000E-04  +2.04980000E-04
   +1.83370000E-04  +9.68000000E-06  -7.36500000E-05  +1.64100000E-05  -1.21690000E-04
   -3.37870000E-04  +2.78130000E-04  -3.32160000E-04  +7.18800000E-05  -5.74410000E-04
   +7.47640000E-04  +1.22550000E-04  +1.50190000E-04  -2.25800000E-05  +1.30104320E-01
   -1.59686480E-01  -1.43597200E-02  +3.06630000E-04  +3.20300000E-04  -6.20000000E-07
   -5.69000000E-06  -1.86400000E-05  -1.94000000E-06  +1.80800000E-05  -2.47000000E-06
   -2.56600000E-05  +5.65500000E-05  +8.60800000E-05  -1.13670000E-04  -1.13733000E-03
   -6.29470000E-04  -1.15935000E-03  -1.44500000E-05  -3.64500000E-05  +3.43000000E-06
   +7.62366000E-03  -7.08854000E-03  +4.72700000E-05  -1.43027970E-01  +1.73144920E-01
   -3.75990000E-04  +3.23290000E-04  +2.78170000E-04  +1.16559000E-03  +2.63402000E-03
   -3.42061000E-03  +6.19030000E-04  -7.28020000E-04  -1.24890000E-04  -5.03400000E-04
   -3.65530000E-04  +4.31350000E-04  +8.08000000E-06  -6.55960000E-04  -8.81860000E-04
   -6.38670000E-04  +1.61020000E-04  +3.55980000E-04  -1.70037200E-02  +1.40597500E-02
   +3.64250000E-04  -1.13308000E-03  +8.21030000E-04  +8.72100000E-04  -7.84000000E-05
   +5.05540000E-04  +5.04760000E-04  -7.16300000E-05  -6.69590000E-04  +4.71320000E-04
   -2.64300000E-05  +2.22300000E-05  -2.38600000E-04  -8.99600000E-05  -2.71500000E-05
   -4.54600000E-05  +1.07400000E-04  -7.79000000E-05  +1.35580000E-04  +5.15500000E-05
   +2.38140000E-04  -1.65690000E-04  +3.05370000E-04  -6.28220000E-04  +5.55840000E-04
   -2.39200000E-05  +2.20900000E-05  -3.64300000E-05  +1.75170200E-02  -1.55882500E-02
   -4.93449600E-02  +1.54700000E-04  +1.53790000E-04  +1.28240000E-04  +5.91000000E-06
   +1.08900000E-05  -4.70000000E-07  -1.91100000E-05  +1.11400000E-05  +6.35000000E-06
   -4.10300000E-05  +1.90800000E-05  +1.01400000E-05  -4.60400000E-04  -4.01780000E-04
   -1.78290000E-04  -1.15300000E-05  -5.44000000E-06  +1.09300000E-05  +2.34592300E-02
   -1.86834000E-02  -5.82100000E-04  -1.85672900E-02  +1.38446300E-02  +5.19005000E-02
   +4.40980000E-04  -1.06740000E-04  -9.46000000E-06  +6.40690000E-04  +1.26991000E-03
   -2.21000000E-05  +2.38390000E-04  -3.52590000E-04  -1.66450000E-04  -2.26340000E-04
   -2.92920000E-04  +4.48500000E-05  -3.57900000E-05  -2.43500000E-05  -4.22000000E-06
   -2.13000000E-06  -8.02700000E-05  +8.88800000E-05  -3.35806000E-03  -4.94150000E-04
   -1.28779000E-03  -1.30010000E-04  +2.05050000E-04  -4.01800000E-04  +2.18600000E-05
   +4.18000000E-06  +7.81000000E-06  +7.39270000E-04  -2.57170000E-04  +3.17340000E-04
   -1.76500000E-05  +1.38070000E-04  -3.13720000E-04  -1.03500000E-04  -1.25970000E-04
   +1.00180000E-04  +1.36950000E-04  +8.61300000E-05  +5.16800000E-05  +1.54280000E-04
   -2.00380000E-04  +2.07680000E-04  -9.66900000E-05  +2.13970000E-04  -4.19390000E-04
   -2.06080000E-04  -1.81780000E-04  -1.80000000E-07  -2.43606470E-01  -1.10891450E-01
   -4.27485300E-02  +2.20800000E-05  +2.20730000E-04  +3.85500000E-05  +2.08700000E-05
   +2.61500000E-05  -3.81000000E-06  -4.67900000E-05  -2.03600000E-05  +1.91200000E-05
   +8.12300000E-05  -7.37500000E-05  +5.77200000E-05  +1.58460000E-04  -2.06190000E-04
   +5.05370000E-04  -7.58000000E-06  -1.85000000E-06  -2.10500000E-05  +1.74109000E-03
   +1.70047000E-03  +5.06150000E-04  -1.93919000E-02  -1.22334200E-02  -4.87342000E-03
   +2.62169170E-01  +7.10370000E-04  +5.79800000E-05  +1.51990000E-04  -1.45587000E-03
   +7.46720000E-04  -6.80220000E-04  +2.60200000E-04  -1.01840000E-04  -2.58070000E-04
   -5.35540000E-04  -4.83530000E-04  -7.96700000E-05  +3.88700000E-05  -4.17110000E-04
   -3.81170000E-04  -1.30160000E-04  +1.95280000E-04  +1.89300000E-04  -2.10623500E-02
   -1.41256100E-02  -4.57086000E-03  +1.72560000E-04  +4.02260000E-04  -1.36070000E-03
   -8.05100000E-05  +3.27700000E-04  +2.52020000E-04  +9.75160000E-04  -2.87290000E-03
   +4.09536000E-03  -1.50329000E-03  -2.51010000E-04  -4.52390000E-04  -4.09800000E-05
   -3.98590000E-04  +1.32430000E-04  +2.94350000E-04  +8.23100000E-05  +1.18100000E-04
   -1.22600000E-04  +1.52390000E-04  -8.23700000E-05  +6.19540000E-04  -8.17300000E-05
   +6.47640000E-04  -2.71030000E-04  -1.55140000E-04  -6.86100000E-05  -1.09526250E-01
   -1.07878540E-01  -2.49958300E-02  +3.92120000E-04  +5.40570000E-04  +1.22330000E-04
   +3.80000000E-05  +3.69100000E-05  -7.45000000E-06  -1.06930000E-04  -1.22620000E-04
   -4.19500000E-05  +2.60000000E-06  +1.54800000E-05  +8.61100000E-05  +1.90740000E-04
   +1.09830000E-04  -3.38890000E-04  -4.84200000E-05  -9.14000000E-06  +2.86000000E-06
   -9.43709000E-03  -5.67612000E-03  -1.37142000E-03  +1.83703300E-02  +1.12488000E-02
   +4.60788000E-03  +1.21448730E-01  +1.18142100E-01  -1.15490000E-04  -1.48600000E-04
   -3.11700000E-05  +6.88060000E-04  -5.30710000E-04  +8.56460000E-04  +7.48000000E-05
   +1.01900000E-04  -1.70830000E-04  -5.14880000E-04  -3.99820000E-04  -6.23500000E-05
   -4.88000000E-06  +1.53640000E-04  +2.07570000E-04  +9.76700000E-05  -4.78700000E-05
   -1.36950000E-04  +1.88945200E-02  +1.10059900E-02  +2.37367000E-03  +1.20341000E-03
   +6.02740000E-04  +1.14964000E-03  +3.27400000E-05  -1.38290000E-04  -1.33010000E-04
   -6.47720000E-04  +2.84716000E-03  -3.04027000E-03  +1.18885000E-03  +7.19380000E-04
   +5.24720000E-04  -1.10680000E-04  +1.87990000E-04  -2.02760000E-04  -4.82200000E-05
   -1.00560000E-04  -9.29000000E-06  +1.71590000E-04  -3.31300000E-05  +2.63190000E-04
   -7.83350000E-04  +3.96340000E-04  -4.44680000E-04  +6.04200000E-05  -3.60000000E-06
   +3.48300000E-05  -4.44516800E-02  -2.61203200E-02  -5.66034000E-02  +4.09560000E-04
   +5.49220000E-04  +8.02000000E-05  -1.22100000E-05  -1.15000000E-05  -1.81000000E-06
   +1.04140000E-04  +4.84100000E-05  -1.23300000E-05  -3.26000000E-06  -2.33700000E-05
   +1.40700000E-05  +1.37700000E-04  -5.65100000E-04  +1.27920000E-04  +1.24300000E-05
   +2.86800000E-05  +1.54500000E-05  -2.68478800E-02  -1.35623200E-02  -4.22039000E-03
   +3.17962000E-03  +1.74876000E-03  -2.96840000E-04  +4.76751500E-02  +2.36550800E-02
   +6.01121500E-02  -4.44130000E-04  +1.09854000E-03  -3.66910000E-04  +7.98500000E-05
   +1.68780000E-04  -9.29400000E-05  +1.59960000E-04  -2.00210000E-04  +2.17200000E-05
   -9.64200000E-05  -6.51100000E-05  -3.10000000E-06  -9.06000000E-05  +1.12860000E-04
   +9.84500000E-05  +1.43150000E-04  -3.10800000E-05  +1.64120000E-04  +1.61977000E-03
   +2.05409000E-03  +9.17320000E-04  -2.14138870E-01  -1.21205410E-01  -4.00223600E-02
   +4.35000000E-05  -5.65600000E-05  -3.74200000E-05  +4.80550000E-04  -4.52600000E-04
   -3.87870000E-04  +2.90490000E-04  +3.98250000E-04  -3.66610000E-04  -1.77470000E-04
   +1.26000000E-05  -9.34300000E-05  +2.95160000E-04  +1.60990000E-04  +8.76900000E-05
   -3.82100000E-05  -8.70700000E-05  +4.44200000E-05  +5.61560000E-04  -1.97650000E-04
   +1.91900000E-04  -3.08970000E-04  -2.13170000E-04  -4.83200000E-05  +2.83080000E-04
   +2.82890000E-04  +3.17750000E-04  +1.07950000E-04  +7.44600000E-05  +1.20800000E-05
   +2.88500000E-05  +4.49800000E-05  -7.10000000E-06  -3.03300000E-05  -1.82900000E-05
   +1.57600000E-05  -3.47200000E-05  +9.24000000E-06  +3.04900000E-05  -4.45600000E-05
   +6.26500000E-05  -3.87000000E-06  -2.16000000E-05  -1.05000000E-06  -1.49000000E-06
   +1.81650000E-04  +2.52840000E-04  -3.43500000E-05  -1.72040000E-04  -1.20970000E-04
   -7.40700000E-05  +3.00540000E-04  +1.65370000E-04  -2.50820000E-04  +2.32434240E-01
   +2.61660000E-04  -2.80310000E-04  -7.04570000E-04  -7.65190000E-04  +3.92250000E-04
   +2.77900000E-05  +2.13350000E-04  -4.62600000E-05  +4.02000000E-06  +1.35700000E-05
   -2.28600000E-05  +6.80700000E-05  -1.15980000E-04  -2.07340000E-04  -1.90030000E-04
   +9.83000000E-05  +2.30910000E-04  +4.09980000E-04  -1.08826900E-02  -8.33976000E-03
   -1.26669000E-03  -1.20177850E-01  -1.35354190E-01  -2.87172600E-02  -5.77000000E-06
   +2.24450000E-04  +1.73490000E-04  +1.51900000E-04  -2.91320000E-04  -2.99330000E-03
   -3.25080000E-04  -1.55520000E-04  -3.06570000E-04  +3.86760000E-04  +1.34150000E-04
   +1.86400000E-05  +1.15570000E-04  +5.35820000E-04  -3.86770000E-04  -5.92290000E-04
   -3.96000000E-04  +1.63060000E-04  +4.78690000E-04  -4.06600000E-04  +2.37980000E-04
   -3.73380000E-04  -2.74350000E-04  +3.96000000E-06  +2.00640000E-04  +3.36080000E-04
   +1.16244000E-03  +2.11000000E-05  +2.03300000E-05  +3.76200000E-05  +2.98500000E-05
   +3.84100000E-05  -1.93800000E-05  -1.37100000E-05  -4.39600000E-05  +6.89000000E-06
   -1.09320000E-04  +2.55720000E-04  +1.61170000E-04  +4.23300000E-05  +7.82000000E-06
   -1.02950000E-04  -8.02500000E-05  +2.75000000E-06  +3.60200000E-05  +2.34310000E-04
   -3.27500000E-05  +4.12100000E-05  +1.50640000E-04  -3.40900000E-05  -7.35100000E-05
   +1.51740000E-04  +5.87910000E-04  -1.52500000E-05  +1.32206090E-01  +1.44745780E-01
   +4.19470000E-04  +2.22300000E-05  +4.85390000E-04  -4.98570000E-04  +6.64080000E-04
   +5.44170000E-04  +9.25000000E-06  +2.07640000E-04  -1.05990000E-04  -3.79800000E-05
   -3.78100000E-05  +8.23000000E-06  +2.57000000E-06  -9.60100000E-05  -9.84700000E-05
   +3.45700000E-05  +7.23000000E-05  +4.98200000E-05  -2.41104300E-02  -1.62682300E-02
   -6.17646000E-03  -3.94541700E-02  -2.76660400E-02  -5.76364600E-02  -2.19400000E-05
   +7.75200000E-05  +6.97100000E-05  +1.47934000E-03  -1.58091000E-03  -4.88657000E-03
   -7.78100000E-05  +3.73780000E-04  -6.39500000E-05  -5.64560000E-04  +8.62400000E-05
   +3.28600000E-05  +4.37300000E-04  +1.36710000E-04  +1.36980000E-04  -2.94100000E-04
   +1.10720000E-04  +3.16240000E-04  -4.78390000E-04  -7.19970000E-04  +4.05800000E-05
   -5.35690000E-04  -4.18550000E-04  -9.09700000E-05  -1.17591000E-03  -9.26460000E-04
   +1.22918000E-03  +3.54700000E-05  +9.07800000E-05  -7.01000000E-06  +1.68600000E-05
   +4.84700000E-05  -4.41500000E-05  -4.39300000E-05  -4.09800000E-05  +1.33500000E-05
   +2.30150000E-04  -3.34590000E-04  -6.25500000E-05  +4.85600000E-05  -8.23400000E-05
   -1.90770000E-04  -8.47300000E-05  -2.88800000E-05  -1.18500000E-05  +2.73880000E-04
   +8.07000000E-05  +3.88120000E-04  -1.97900000E-05  +9.66500000E-05  -6.63500000E-05
   +6.23860000E-04  +4.28950000E-04  -6.54910000E-04  +4.41832400E-02  +3.31943300E-02
   +6.19998300E-02  +1.07390000E-04  -3.09000000E-06  -3.31870000E-04  +6.29310000E-04
   -1.72360000E-04  -3.15500000E-05  +3.38500000E-05  +2.87800000E-05  -7.17300000E-05
   +2.48300000E-04  +8.83600000E-05  +7.52500000E-05  -2.04700000E-05  -2.20720000E-04
   -2.34960000E-04  +4.05000000E-05  +2.06950000E-04  +2.48090000E-04  -2.77076000E-03
   +7.32960000E-04  -5.63790000E-04  -2.29292970E-01  +1.27124050E-01  +4.83894000E-03
   -4.75900000E-05  +2.20190000E-04  +1.81780000E-04  +7.93870000E-04  -1.20729000E-03
   -2.06530000E-04  +3.27120000E-04  +2.23590000E-04  -8.82200000E-05  -2.06710000E-04
   +1.06500000E-05  +1.74400000E-05  -1.86000000E-06  -9.41200000E-05  +1.23530000E-04
   +8.48200000E-05  +7.68400000E-05  +7.02000000E-05  +1.89760000E-04  +1.96150000E-04
   -7.80100000E-05  +5.45400000E-05  +2.02500000E-05  -1.88500000E-05  -1.26680000E-04
   -1.04500000E-05  -5.42810000E-04  -1.58190000E-04  -6.64800000E-05  -1.88800000E-05
   -9.64000000E-06  -1.13000000E-06  +3.56000000E-06  -7.30000000E-07  +1.05100000E-05
   +1.43000000E-06  +3.74700000E-05  -5.48800000E-05  -3.81700000E-05  +2.99300000E-05
   +1.09200000E-05  +1.37600000E-05  +2.18600000E-05  +1.42200000E-05  +7.70000000E-07
   +2.79930000E-04  -2.56440000E-04  -1.71000000E-05  +3.45940000E-04  -3.90100000E-04
   +4.74690000E-04  -5.55000000E-06  +1.36830000E-04  -1.22800000E-05  -1.93072300E-02
   +1.49832000E-02  +4.69780000E-04  +2.45698280E-01  -2.01990000E-04  +4.89810000E-04
   -3.24340000E-04  -5.14490000E-04  -3.43840000E-04  -2.43644000E-03  +9.71550000E-04
   -5.10700000E-05  +4.27600000E-05  -2.54670000E-04  -2.43000000E-04  -2.29010000E-04
   -4.90600000E-05  +3.71490000E-04  +2.68860000E-04  +1.70850000E-04  -1.40640000E-04
   -9.52800000E-05  +1.10675600E-02  -9.89095000E-03  -4.28630000E-04  +1.25917850E-01
   -1.34580140E-01  -2.68977000E-03  +7.25600000E-05  -2.84120000E-04  -1.83970000E-04
   +9.09540000E-04  +5.32400000E-04  +3.12710000E-04  -1.01630000E-04  -4.41170000E-04
   +5.04110000E-04  +1.35300000E-05  +3.34200000E-05  +2.35400000E-05  -1.71240000E-04
   -8.84700000E-05  -1.00330000E-04  -1.23330000E-04  -1.75000000E-06  -8.17300000E-05
   -3.21290000E-04  +9.41300000E-05  -5.70100000E-05  +1.45200000E-04  +1.35880000E-04
   +2.93400000E-05  -5.89740000E-04  +3.52180000E-04  +1.09846000E-03  +1.50500000E-04
   +7.54100000E-05  -9.03000000E-06  -2.85000000E-06  -3.29500000E-05  -2.50000000E-06
   +1.63400000E-05  -8.39000000E-06  -1.41600000E-05  +5.43900000E-05  +1.60580000E-04
   -1.32570000E-04  +3.35400000E-05  -5.04000000E-06  -3.91300000E-05  +2.28000000E-06
   -9.79000000E-06  -4.80000000E-06  -2.41480000E-04  -4.23200000E-05  -3.61000000E-06
   -6.76600000E-05  +5.67900000E-04  +1.31860000E-04  -1.16240000E-04  +3.43200000E-05
   -1.42000000E-05  -1.61147800E-02  +1.19352200E-02  +5.47530000E-04  -1.38679560E-01
   +1.44205950E-01  -8.38350000E-04  +1.78790000E-04  -6.73080000E-04  -1.07964000E-03
   -1.54953000E-03  -5.50529000E-03  +1.75861000E-03  -9.31870000E-04  +1.13460000E-04
   -5.06080000E-04  -4.98880000E-04  -3.32950000E-04  -1.45450000E-04  +1.48930000E-04
   +9.42800000E-05  +1.49480000E-04  -1.02360000E-04  +2.89000000E-04  +2.47253400E-02
   -1.78652400E-02  -2.99668000E-03  +3.06837000E-03  -1.43570000E-03  -4.55085500E-02
   +7.56800000E-05  -6.87100000E-05  -4.49100000E-05  +1.03539000E-03  +3.11190000E-04
   +8.02190000E-04  -4.19050000E-04  -7.97100000E-05  -1.54800000E-05  +4.03850000E-04
   -2.02300000E-05  +1.30640000E-04  -2.11520000E-04  +4.87000000E-05  -2.33210000E-04
   -1.78570000E-04  -1.02940000E-04  -6.75600000E-05  +3.31100000E-05  +1.48120000E-04
   +1.93090000E-04  +2.21580000E-04  +1.54030000E-04  +4.62300000E-05  +1.01291000E-03
   -1.08845000E-03  +1.19871000E-03  +3.37480000E-04  +2.21730000E-04  +1.59970000E-04
   -1.93400000E-05  -2.38100000E-05  +1.29400000E-05  -6.27000000E-06  +1.78700000E-05
   -5.70000000E-07  -2.25700000E-05  +1.14300000E-05  +4.54000000E-05  -1.58600000E-05
   +1.61100000E-05  -9.62800000E-05  +4.89000000E-06  -9.84000000E-06  +8.38000000E-06
   -2.98650000E-04  +5.50900000E-05  +2.89550000E-04  -2.22120000E-04  +5.62710000E-04
   -7.13180000E-04  -8.00400000E-05  +6.60300000E-05  -7.10400000E-05  -4.47725000E-03
   +3.95527000E-03  -7.92690000E-04  -4.63855000E-03  +5.13227000E-03  +5.26244000E-02
   -2.81290000E-04  +2.21850000E-04  +7.70470000E-04  +3.79960000E-04  -4.32050000E-04
   +2.88530000E-04  +3.68900000E-05  +8.68400000E-05  -6.57200000E-05  -1.26970000E-04
   -8.97600000E-05  -6.94700000E-05  +5.87600000E-05  +1.91860000E-04  +1.67390000E-04
   +2.51300000E-05  -1.01300000E-04  -3.26820000E-04  -2.08084000E-03  -1.97339000E-03
   +1.27801000E-03  -4.85956600E-02  -1.68666100E-02  +1.64423600E-02  +1.24300000E-05
   -1.91860000E-04  -1.36870000E-04  +8.23000000E-06  +7.31640000E-04  -4.87290000E-04
   -1.13190000E-04  -2.78720000E-04  -1.30280000E-04  -2.14080000E-04  -2.58500000E-05
   +1.26000000E-05  -4.33600000E-05  -1.07820000E-04  +3.95000000E-05  +1.01260000E-04
   +5.86600000E-05  -3.59700000E-05  -1.30310000E-04  -5.32200000E-05  -7.63900000E-05
   +5.85300000E-05  +4.74100000E-05  +1.87200000E-05  -1.48870000E-04  +4.40620000E-04
   +4.13050000E-04  +7.34100000E-05  +6.56900000E-05  -2.22500000E-05  -9.33000000E-06
   -1.98300000E-05  -1.17600000E-05  +2.34900000E-05  -1.27000000E-05  -2.09900000E-05
   +2.23470000E-04  -2.53550000E-04  -2.11900000E-04  +1.50000000E-05  -2.90000000E-06
   +5.42800000E-05  -1.37000000E-06  +5.18000000E-06  +1.03600000E-05  +6.39640000E-04
   -1.36100000E-04  +1.80990000E-04  +1.66250000E-04  -3.33880000E-04  +1.08400000E-04
   +3.04000000E-04  +3.13620000E-04  -2.21040000E-04  -1.54606000E-03  -1.71383800E-02
   +1.90702100E-02  +2.96291000E-03  +1.83918800E-02  -1.97676300E-02  +5.01571200E-02
   +1.01966000E-03  +1.01140000E-04  +2.10110000E-04  +2.30080000E-04  +4.14590000E-04
   +3.26050000E-04  -4.03460000E-04  +3.90700000E-05  +8.98300000E-05  +1.87600000E-05
   +8.45000000E-05  +1.23700000E-05  +9.99300000E-05  -6.88800000E-05  -9.10100000E-05
   -1.01960000E-04  +5.23400000E-05  -1.50390000E-04  +7.57350000E-04  +9.59186000E-03
   -9.82686000E-03  -1.71987500E-02  -1.77760600E-01  +1.33924360E-01  -4.68900000E-05
   +2.01400000E-05  +3.62200000E-05  +8.77100000E-05  +7.37820000E-04  -1.55400000E-05
   -3.85120000E-04  -3.06760000E-04  -8.36620000E-04  +1.67650000E-04  -9.49700000E-05
   +5.44300000E-05  -7.63500000E-05  +1.34400000E-05  +2.67100000E-05  +1.37400000E-05
   +3.14600000E-05  -7.60400000E-05  +2.71400000E-05  -1.54000000E-06  +1.42510000E-04
   +1.32910000E-04  +8.07200000E-05  +2.10900000E-05  +2.36890000E-04  -4.67610000E-04
   -1.86196000E-03  -1.98400000E-05  +9.25000000E-06  -1.56100000E-05  -1.33500000E-05
   -1.09100000E-05  +1.24700000E-05  +1.27100000E-05  +6.75000000E-06  -2.06100000E-05
   -2.24820000E-04  -8.83630000E-04  -4.96660000E-04  -2.79000000E-06  -3.97000000E-06
   -2.89000000E-05  +1.16200000E-05  -1.98000000E-06  +1.76000000E-06  +1.28370000E-04
   +6.43000000E-04  -5.08400000E-04  -2.24520000E-04  +1.12000000E-04  -2.40440000E-04
   +2.34460000E-04  +3.23600000E-05  -1.90490000E-04  +3.68690000E-04  -1.19975200E-02
   +1.21074000E-02  -2.83041000E-03  -1.24244000E-02  +1.22465200E-02  +1.74425000E-02
   +1.92367200E-01  -9.92600000E-05  -2.57170000E-04  +2.62260000E-04  -1.09225000E-03
   +8.46770000E-04  +7.78370000E-04  -1.37600000E-05  -3.10960000E-04  +1.34890000E-04
   -2.64200000E-05  +1.34900000E-05  +1.20360000E-04  -9.25300000E-05  +2.35000000E-05
   -1.40900000E-05  +1.27050000E-04  -5.70000000E-05  +2.72710000E-04  +1.75313000E-03
   +2.14189400E-02  -1.97258900E-02  +1.56504400E-02  +1.31699540E-01  -1.83108430E-01
   +3.72200000E-05  +2.70100000E-05  +2.39100000E-05  +1.49153000E-03  +8.55560000E-04
   +9.28130000E-04  -2.18630000E-04  +6.62520000E-04  -1.38490000E-04  -6.14440000E-04
   -3.73330000E-04  +1.26550000E-04  +1.81520000E-04  -4.74690000E-04  +4.32720000E-04
   +5.01130000E-04  +4.40860000E-04  -3.82100000E-05  -8.57890000E-04  -8.37000000E-06
   -3.19760000E-04  +1.13730000E-04  +5.33700000E-05  -4.92000000E-06  +1.84250000E-04
   -4.15634000E-03  -5.55721000E-03  -9.48000000E-06  -3.22300000E-05  +7.07300000E-05
   -2.98500000E-05  -1.80900000E-05  -3.90000000E-06  -3.62600000E-05  +3.05000000E-06
   -1.23200000E-05  +1.50540000E-04  -8.55810000E-04  +5.73000000E-06  +1.45140000E-04
   -3.69800000E-05  +9.60300000E-05  +9.47000000E-06  -1.27200000E-05  -2.25200000E-05
   +3.03900000E-04  +1.54265000E-03  -1.41879000E-03  -1.17970000E-04  -1.82010000E-04
   +3.29940000E-04  +8.75300000E-05  -9.65400000E-05  +2.15350000E-04  -1.98280000E-04
   -5.51151000E-03  +5.19866000E-03  -2.21640000E-04  -1.22870000E-03  +7.21250000E-04
   -1.77627100E-02  -1.44343430E-01  +2.00399400E-01  +5.25920000E-04  -3.42790000E-04
   +1.81344000E-03  +5.75532000E-03  +1.51574000E-03  -1.57424000E-03  -2.33675050E-01
   -1.10355550E-01  -8.09264900E-02  -1.81724300E-02  -1.26766300E-02  -1.41148300E-02
   +1.20390000E-04  -7.94090000E-04  -1.38850000E-04  -7.06900000E-05  +6.30250000E-04
   -3.56500000E-05  -6.82600000E-05  -2.11180000E-04  -4.64130000E-04  -2.39600000E-05
   -2.08470000E-04  +2.68600000E-05  +3.62100000E-05  +3.99790000E-04  +1.09190000E-04
   -1.31024000E-03  +8.50540000E-04  +1.19406000E-03  -4.27400000E-04  +3.44000000E-04
   +5.55770000E-04  +2.05180000E-04  -2.17300000E-05  -7.69800000E-05  -1.91630000E-04
   -9.79600000E-05  -1.25720000E-04  -6.37100000E-05  -1.31440000E-04  -8.04300000E-05
   -1.28140000E-04  +1.91330000E-04  +3.40460000E-04  +9.28900000E-05  +8.52700000E-05
   +3.14900000E-05  -2.64800000E-05  -4.75600000E-05  -1.14380000E-04  -1.00294000E-03
   -2.70725000E-03  +4.90963000E-03  -1.47000000E-05  -2.36100000E-05  -3.71000000E-06
   +1.74700000E-05  +1.55800000E-05  -1.04600000E-05  +5.31500000E-05  -1.93100000E-05
   -5.47900000E-05  +3.81200000E-05  -3.09800000E-05  -2.13800000E-05  +1.01000000E-06
   -1.25000000E-06  +7.06000000E-06  +8.65000000E-06  -9.80000000E-07  +2.49300000E-05
   -3.83000000E-06  +2.47000000E-05  +2.39700000E-05  -4.20000000E-07  -2.89700000E-05
   +1.45500000E-05  -6.07000000E-06  -3.61600000E-05  -3.94300000E-05  +1.52800000E-05
   -2.52900000E-05  -4.29200000E-05  -5.50000000E-07  -1.54300000E-05  +2.43500000E-05
   +2.48281820E-01  +5.33100000E-05  -1.76843000E-03  -2.17543000E-03  -9.31767000E-03
   -1.18262000E-03  -6.54120000E-04  -1.09751310E-01  -9.85712600E-02  -6.35692500E-02
   -3.34007000E-03  -2.44620000E-03  +6.68460000E-04  -1.98040000E-04  -3.64460000E-04
   -1.51565000E-03  -1.13970000E-04  +1.37560000E-04  +7.74490000E-04  -3.28620000E-04
   +7.04770000E-04  -6.82500000E-05  +3.62500000E-05  -2.22700000E-05  -4.08800000E-05
   -1.56780000E-04  +4.12140000E-04  +9.15850000E-04  +2.23240000E-04  -2.11490000E-04
   -4.03800000E-05  +1.56390000E-04  +5.36700000E-04  -1.81140000E-04  -1.72120000E-04
   -2.27730000E-04  -1.26300000E-04  +2.22630000E-04  +4.52800000E-05  +4.81400000E-05
   +1.63060000E-04  +8.63800000E-05  +1.40520000E-04  +1.05860000E-04  +2.47700000E-05
   +1.82790000E-04  -2.37540000E-04  -2.00120000E-04  -2.28200000E-05  +3.94400000E-05
   -4.40000000E-06  -2.79980000E-04  -1.80997000E-03  +1.06482400E-02  -3.35050000E-03
   -4.28000000E-06  +3.89700000E-05  +4.40000000E-07  -4.29800000E-05  -2.39200000E-05
   +3.06500000E-05  +6.77000000E-06  -4.53800000E-05  +1.04070000E-04  +7.66800000E-05
   -1.20770000E-04  -2.37600000E-05  -1.18000000E-06  -4.40000000E-07  -5.83000000E-06
   -2.54900000E-05  -3.48500000E-04  +1.83800000E-04  +5.48000000E-06  +1.23600000E-05
   +1.38100000E-04  +1.06300000E-05  +1.76150000E-04  +1.05090000E-04  +4.35900000E-05
   +9.13600000E-05  +3.32600000E-05  +6.27000000E-05  -1.16800000E-05  +3.60300000E-05
   -5.83000000E-05  -2.19300000E-05  +9.84900000E-05  +1.21774990E-01  +9.65950600E-02
   +3.12786000E-03  -3.84315000E-03  -1.89034000E-03  -2.29694200E-02  -1.16929500E-02
   -1.14941300E-02  -8.98763400E-02  -6.30849700E-02  -8.85609300E-02  +1.71412900E-02
   +1.09173000E-02  +7.87401000E-03  +1.06870000E-04  -1.75153000E-03  -1.23896000E-03
   -1.01800000E-03  +7.98840000E-04  +8.50610000E-04  -8.97840000E-04  +2.92800000E-04
   +5.02000000E-05  +2.23630000E-04  +1.24960000E-04  -9.00700000E-05  -1.54720000E-04
   +1.20301000E-03  +7.31310000E-04  +2.29220000E-04  -3.81530000E-04  -3.13800000E-05
   -5.80000000E-07  +2.63150000E-04  -1.96790000E-04  +1.66610000E-04  +2.52820000E-04
   +1.16560000E-04  +2.82000000E-04  +2.38620000E-04  -8.88400000E-05  -1.44510000E-04
   -2.56740000E-04  -4.48000000E-06  +5.58700000E-04  +1.22510000E-04  +3.37140000E-04
   -3.06040000E-04  -2.03310000E-04  -4.09300000E-05  +1.01870000E-04  +3.81300000E-05
   +7.98800000E-05  +5.47990000E-03  -3.26763000E-03  +3.99400000E-05  +4.38200000E-05
   +3.86000000E-05  -7.76000000E-06  +4.29000000E-06  -2.67800000E-05  -1.38000000E-05
   -5.68500000E-05  -1.00740000E-04  -1.29190000E-04  -4.52400000E-05  +5.67100000E-05
   -2.97900000E-05  -2.57000000E-05  +1.30100000E-05  -3.50000000E-07  -3.50300000E-05
   -6.31000000E-06  +3.24400000E-05  +2.03200000E-05  -6.72500000E-05  -1.18000000E-06
   +2.63600000E-05  +7.54300000E-05  -3.70800000E-05  +2.61700000E-05  +1.32360000E-04
   +9.23400000E-05  +8.15200000E-05  -4.88700000E-05  +2.61000000E-06  -6.07600000E-05
   -4.21300000E-05  +2.78000000E-06  +8.83727900E-02  +6.65359900E-02  +9.63305900E-02
   -2.74300000E-04  +1.26953000E-03  +4.06450000E-04  -1.50686000E-03  -4.19798000E-03
   +2.55219000E-03  +2.51408000E-03  +9.53826000E-03  +2.33597600E-02  -5.29787100E-02
   +4.46718000E-03  +2.01179500E-02  +4.47100000E-05  -1.79960000E-04  +4.49630000E-04
   +1.54290000E-04  -5.13290000E-04  -8.77100000E-05  +1.17500000E-04  -1.23280000E-04
   +1.03520000E-04  -5.89100000E-05  +9.75700000E-05  -3.00900000E-05  +2.27000000E-05
   -9.21100000E-05  -1.11510000E-04  +1.00940000E-04  +5.67000000E-05  -1.08800000E-05
   +2.23400000E-05  -2.41100000E-05  +1.56700000E-05  -9.34000000E-06  +6.07000000E-06
   -2.12900000E-05  +8.67000000E-06  +1.74000000E-06  +1.01100000E-05  -1.17500000E-05
   -1.71600000E-05  -2.62200000E-05  +5.05000000E-06  -2.30200000E-05  +6.51000000E-06
   -2.12300000E-05  -1.82100000E-05  -1.58400000E-05  -4.29900000E-05  +2.36900000E-05
   -5.55000000E-06  -5.13228000E-03  -1.86278900E-02  -3.31813200E-02  -3.14000000E-06
   +3.79000000E-06  +6.46000000E-06  -2.91000000E-06  +1.03000000E-06  +5.07000000E-06
   +1.08600000E-05  +2.03800000E-05  -1.42000000E-05  -7.93000000E-06  +2.03600000E-05
   +6.36000000E-06  -1.37700000E-05  +3.58000000E-06  +3.97000000E-06  -1.43300000E-05
   +1.92500000E-05  -3.18900000E-05  +2.07000000E-06  +3.49300000E-05  -3.13400000E-05
   -7.37000000E-06  +4.50000000E-06  +6.41000000E-06  -2.42000000E-06  -1.55700000E-05
   +1.33700000E-05  -1.28800000E-05  +4.91900000E-05  +5.64000000E-06  +2.11500000E-05
   +1.91000000E-06  -3.89300000E-05  -1.87620000E-04  +2.13919000E-03  -6.55370000E-04
   +6.10163600E-02  -4.31490000E-04  -1.22647000E-03  -8.67190000E-04  -4.16129000E-03
   +7.61840000E-03  -2.80710000E-03  -9.41150000E-04  +7.09035000E-03  +2.45900000E-03
   +1.99401000E-03  -9.44517500E-02  -1.10897790E-01  -4.90500000E-05  +2.66040000E-04
   -5.49820000E-04  +4.11840000E-04  +5.71750000E-04  -1.31800000E-04  +3.44890000E-04
   +7.22270000E-04  +1.49773000E-03  -4.27830000E-04  +1.74570000E-04  -9.65000000E-05
   -1.26390000E-04  -2.26400000E-05  +4.09000000E-05  +1.36440000E-04  -2.62700000E-05
   +3.94100000E-05  -3.07300000E-05  +9.68000000E-06  -3.01000000E-05  +5.00000000E-07
   -2.15000000E-05  +6.81000000E-06  +2.59400000E-05  +3.12900000E-05  -5.86000000E-06
   -3.84000000E-06  -1.95600000E-05  +1.76400000E-05  +1.80000000E-07  +1.40200000E-05
   -2.16900000E-05  -3.22200000E-05  -3.42000000E-05  -1.90000000E-06  -3.05200000E-05
   -2.02260000E-04  +7.13100000E-05  -4.44629000E-03  -8.27347000E-03  -1.77565700E-02
   -9.10000000E-07  +8.31000000E-06  +7.40000000E-07  -9.47000000E-06  -6.42000000E-06
   +4.59000000E-06  -1.14800000E-05  -9.40000000E-07  +1.84800000E-05  +1.33000000E-05
   -1.31000000E-05  -1.67000000E-06  +2.23000000E-06  +1.39000000E-06  -1.10000000E-06
   +6.62000000E-05  -2.43000000E-06  -3.39000000E-05  +5.20000000E-06  -5.10000000E-07
   +1.95000000E-05  +1.79600000E-05  +4.02900000E-05  -1.27200000E-05  +2.40600000E-05
   +2.87200000E-05  -6.26000000E-06  -4.85000000E-06  +5.51900000E-05  +1.67870000E-04
   -9.77000000E-06  -2.23300000E-05  +4.69600000E-05  +1.72798000E-03  -4.31458000E-03
   +2.30587000E-03  +9.77357000E-03  +9.10551700E-02  +2.81300000E-04  +3.31870000E-04
   +5.01730000E-04  +3.76075000E-03  -2.46629000E-03  +2.33471000E-03  -1.28297000E-03
   -8.88928000E-03  -1.07322600E-02  +1.47091200E-02  -1.12218230E-01  -2.94110860E-01
   +2.35960000E-04  -1.27532000E-03  -6.63960000E-04  -1.26740000E-04  +3.02890000E-04
   +2.74760000E-04  -2.94880000E-04  -3.15920000E-04  -1.22914000E-03  +3.38870000E-04
   -2.00940000E-04  +1.11070000E-04  -6.19300000E-05  +6.55330000E-04  +6.57920000E-04
   -1.42180000E-04  -4.69000000E-05  -2.83600000E-05  +2.17200000E-05  +1.02300000E-05
   +9.39000000E-06  +1.51000000E-06  +3.91000000E-06  +1.14000000E-05  -3.06600000E-05
   -3.52100000E-05  +3.17000000E-06  +2.00800000E-05  +3.50800000E-05  +6.34000000E-06
   -1.11500000E-05  +1.69400000E-05  -5.09000000E-06  +5.00500000E-05  +4.31500000E-05
   +1.19900000E-05  -1.88900000E-05  +6.55400000E-05  -1.16710000E-04  -4.36549000E-03
   -5.50329000E-03  -5.45354000E-03  -4.00000000E-08  -1.00900000E-05  -3.50000000E-06
   +9.61000000E-06  +5.14000000E-06  -7.15000000E-06  -2.12000000E-06  -1.73600000E-05
   -2.00000000E-07  -6.50000000E-07  -9.64000000E-06  -6.66000000E-06  +8.61000000E-06
   -7.40000000E-07  -7.80000000E-07  -1.32000000E-06  -1.36100000E-05  +3.01800000E-05
   +1.24900000E-05  -1.23800000E-05  +2.39600000E-05  -7.99000000E-06  +1.41700000E-05
   +1.85900000E-05  -1.45300000E-05  -2.86000000E-06  +2.25000000E-06  +1.31600000E-05
   -7.13700000E-05  -1.24470000E-04  -4.95000000E-06  +1.69500000E-05  -3.67000000E-06
   -3.99230000E-04  +2.53682000E-03  -4.97950000E-04  -1.23713400E-02  +1.27763520E-01
   +3.06338610E-01  -9.95104000E-03  -1.20821000E-03  -1.91270100E-02  -2.27427000E-03
   +2.79168000E-03  +9.79770000E-04  -2.44760000E-04  +2.20280000E-04  +1.27627000E-03
   +2.35830000E-04  -3.10760000E-04  +8.25300000E-05  +4.06360000E-03  -2.96691000E-03
   +2.03116000E-03  -1.50109440E-01  +1.84382000E-03  -1.48957110E-01  +3.06090000E-04
   +1.42940000E-04  -9.19730000E-04  +3.28700000E-05  -4.43400000E-05  -8.10700000E-05
   -5.44420000E-04  +4.00793000E-03  -2.92000000E-06  +6.15700000E-05  +1.43310000E-04
   +3.41200000E-05  -4.54100000E-05  -2.91000000E-06  -2.17800000E-05  -1.55900000E-05
   -1.71000000E-06  -8.30000000E-06  +4.48300000E-05  +4.39400000E-05  -7.25000000E-06
   -1.77000000E-05  -3.55000000E-05  -1.77000000E-06  -2.70200000E-05  -4.59400000E-05
   +1.63500000E-05  -6.81700000E-05  -5.62700000E-05  -6.34000000E-06  -3.55670000E-04
   +2.01210000E-04  +1.74520000E-04  +1.75840000E-04  -1.92600000E-05  +5.36100000E-05
   +1.83000000E-06  +1.17000000E-05  -3.82000000E-06  -1.90300000E-05  -1.28600000E-05
   +3.09000000E-06  +2.19500000E-05  +3.06100000E-05  -3.61400000E-05  +1.07000000E-05
   +7.06000000E-06  +1.32800000E-05  -7.99000000E-06  -4.75000000E-06  -2.39000000E-06
   -5.32000000E-06  -2.02700000E-05  -4.78000000E-06  -2.86500000E-05  +1.40190000E-04
   -9.38200000E-05  +9.83000000E-06  -2.42200000E-05  +8.39000000E-06  +1.53600000E-05
   +2.88300000E-05  -7.06000000E-06  -4.31000000E-06  +6.11000000E-06  +5.33200000E-05
   -3.78600000E-05  -3.07900000E-05  +4.31900000E-05  -6.88500000E-05  +1.30200000E-05
   -8.09600000E-05  +4.90600000E-05  -3.77500000E-05  -5.18500000E-05  +1.57842690E-01
   +1.40382700E-02  +3.44417000E-03  +1.57413700E-02  +2.55151000E-03  -1.68656000E-03
   -1.52044000E-03  -1.49420000E-04  +3.76630000E-04  -2.24400000E-05  +9.83600000E-05
   -2.13570000E-04  +1.96710000E-04  -1.60877100E-02  -5.24928000E-03  -2.34201500E-02
   -7.96450000E-04  -3.47868400E-02  -2.30560400E-02  +1.53110000E-04  -2.44500000E-05
   +6.11860000E-04  +7.67000000E-06  +5.11000000E-05  -2.01000000E-06  +4.59267000E-03
   +3.76210000E-04  +1.92814000E-03  +2.40400000E-05  -9.64800000E-05  -3.90600000E-05
   -1.69500000E-05  +1.56800000E-05  -2.10800000E-05  +1.56600000E-05  +8.56000000E-06
   +1.89200000E-05  -1.65100000E-05  +1.13000000E-06  -1.15700000E-05  -3.86000000E-06
   +1.55000000E-06  +1.11000000E-05  +1.78000000E-05  +1.22000000E-05  +1.47000000E-05
   +1.85000000E-05  +8.36000000E-06  +5.21000000E-06  +1.12790000E-04  +1.88500000E-05
   -1.11800000E-05  -1.64900000E-04  -1.20400000E-04  +1.26490000E-04  -2.86000000E-06
   -1.11000000E-06  -2.53000000E-06  -3.00000000E-06  -1.13000000E-06  -3.47000000E-06
   +9.64000000E-06  -6.00000000E-08  -2.34000000E-05  +2.68000000E-06  -6.15000000E-06
   -9.20000000E-07  +4.21000000E-06  -8.40000000E-07  +3.90000000E-07  -3.98000000E-06
   -8.21000000E-06  +1.92600000E-05  -1.11400000E-05  -2.63900000E-05  +3.39700000E-05
   -1.22200000E-05  -1.32300000E-05  +9.20000000E-07  -1.20900000E-05  -3.06800000E-05
   -9.60000000E-06  -3.74000000E-06  -3.65900000E-05  -8.31000000E-06  -8.75000000E-06
   -7.77000000E-06  +2.70000000E-07  -5.85300000E-05  +9.82900000E-05  +2.85200000E-05
   -1.49000000E-06  -8.75000000E-06  -2.58000000E-05  -4.30240000E-03  +3.76265300E-02
   +5.13850000E-04  -7.79770000E-04  +3.67586000E-03  +5.35900000E-04  -9.11370000E-04
   +1.03697000E-03  +2.16690000E-04  -1.68630000E-04  -7.56430000E-04  -5.18980000E-04
   +9.99200000E-05  +4.17400000E-05  -1.19607400E-02  -4.56186000E-03  -1.95955700E-02
   -1.52888070E-01  -2.35390400E-02  -2.18231300E-01  -1.60890000E-04  -5.47300000E-05
   +1.30990000E-04  -1.67000000E-05  +1.02500000E-05  +3.82100000E-05  -3.07670000E-04
   +4.40920000E-04  +3.52899000E-03  -2.07300000E-05  -4.22000000E-05  -5.78000000E-06
   +2.56900000E-05  -1.04000000E-06  +1.34000000E-06  +7.80000000E-07  -9.92000000E-06
   -5.06000000E-06  -1.86300000E-05  -2.73000000E-05  +1.03700000E-05  +1.58000000E-05
   +2.12400000E-05  -1.40000000E-06  -9.30000000E-07  +1.26100000E-05  -1.55800000E-05
   +3.18200000E-05  +2.42200000E-05  +1.09000000E-06  +1.03770000E-04  -9.88000000E-05
   -9.11300000E-05  +2.36520000E-04  +1.02920000E-04  +3.01800000E-05  -3.57000000E-06
   -3.95000000E-06  +3.81000000E-06  +5.59000000E-06  +6.97000000E-06  +1.39000000E-06
   -1.92700000E-05  -5.99000000E-06  +3.34800000E-05  -3.95000000E-06  -2.07000000E-06
   -4.24000000E-06  +1.84000000E-06  +3.32000000E-06  +2.52000000E-06  +3.29000000E-06
   +1.24500000E-05  -4.13000000E-06  +2.99600000E-05  -5.80100000E-05  +3.92900000E-05
   -9.00000000E-07  +2.05800000E-05  -1.94000000E-06  -1.33500000E-05  -2.24000000E-05
   +1.35500000E-05  +1.37000000E-06  +5.05000000E-06  -2.79700000E-05  +3.13400000E-05
   +2.90000000E-05  -2.31700000E-05  +4.53800000E-05  +8.90000000E-06  +9.28000000E-06
   -2.50000000E-05  +4.60400000E-05  +2.50000000E-05  +1.64183000E-01  +2.90522300E-02
   +2.29702750E-01  -5.41018100E-02  +2.59762400E-02  +2.75365800E-02  +8.21475000E-03
   -9.12854000E-03  -1.63818300E-02  +2.36098000E-03  +5.39683000E-03  -5.10049000E-03
   -1.79011000E-03  -1.37859000E-03  -9.85380000E-04  -4.16859000E-03  +3.17766000E-03
   +3.25150000E-04  -3.72366000E-03  +1.42098000E-02  +1.74847300E-02  -1.92990000E-03
   -3.50390000E-03  +1.12719000E-03  -1.75338000E-03  +1.60227000E-03  -8.89120000E-04
   +1.08443000E-03  +4.95640000E-04  +5.04560000E-04  -5.88300000E-04  +4.17340000E-04
   -6.16800000E-05  -4.18900000E-05  +2.06140000E-04  -1.24690000E-04  +3.13900000E-05
   -4.70800000E-05  +7.79300000E-05  -7.26900000E-05  -4.37100000E-05  -1.50900000E-05
   +3.94000000E-05  +1.44600000E-05  -4.68400000E-05  -9.12800000E-05  -6.69700000E-05
   +8.94100000E-05  +9.96500000E-05  +6.06100000E-05  +2.93800000E-05  +7.87970000E-04
   -2.29730000E-04  +1.13550000E-04  +6.11270000E-04  +8.10970000E-04  +3.78950000E-04
   -1.82200000E-05  -1.84600000E-05  -6.20000000E-06  +7.32000000E-06  +5.55000000E-06
   -1.18500000E-05  +4.29800000E-05  -1.34860000E-04  +1.56100000E-05  -7.43000000E-06
   -7.20000000E-06  -6.80000000E-07  +6.00000000E-06  -1.28200000E-05  -4.10000000E-06
   +1.28800000E-05  -6.98200000E-05  +1.32870000E-04  -2.39800000E-05  -1.59880000E-04
   +1.37770000E-04  +4.71100000E-05  -2.82400000E-05  -4.05700000E-05  -5.57700000E-04
   +8.18680000E-04  +5.82800000E-05  +1.74700000E-05  -3.30890000E-04  +7.84200000E-05
   -1.90448000E-03  +5.73010000E-04  +5.97070000E-04  -5.45300000E-05  -1.94300000E-05
   +3.23500000E-04  +3.81890000E-04  -4.02100000E-04  +1.31800000E-04  +8.61100000E-04
   -4.30150000E-04  +3.67100000E-04  +5.60724000E-02  +2.25652300E-02  -1.15265360E-01
   -1.28272740E-01  +3.30500000E-05  +6.89492000E-03  +5.02294000E-03  +6.21567000E-03
   +5.84835000E-03  -2.46970000E-03  -9.53660000E-04  -9.68100000E-04  -9.70650000E-04
   +3.68175000E-03  -1.25740000E-04  +7.66500000E-05  +6.34140000E-03  -1.11301100E-02
   -1.58032900E-02  -2.31902000E-03  -4.05816000E-03  +1.61870000E-03  +2.59081000E-03
   -3.76760000E-04  +4.78840000E-04  -7.42590000E-04  -4.35530000E-04  -5.55740000E-04
   -4.87540000E-04  +6.12040000E-04  -3.54920000E-04  -8.45200000E-05  +1.43220000E-04
   -2.07020000E-04  +3.36200000E-05  -7.66100000E-05  +6.90700000E-05  -1.80100000E-05
   +3.44900000E-05  -5.80000000E-06  -1.35000000E-06  -2.40700000E-05  -2.58300000E-05
   -1.44600000E-04  -1.60590000E-04  +8.40500000E-05  +7.63000000E-06  -1.72100000E-05
   +1.95600000E-05  +1.01674000E-03  -5.83200000E-04  -7.46200000E-05  -1.67070000E-04
   +4.43650000E-04  +3.03330000E-04  -1.52200000E-05  -4.34000000E-06  -9.01000000E-06
   -3.80000000E-06  -7.35000000E-06  -1.32000000E-05  -6.28600000E-05  -1.31460000E-04
   +6.50000000E-07  +7.46000000E-06  -2.40000000E-07  +1.34900000E-05  -9.73000000E-06
   -1.52000000E-05  -3.63000000E-06  -2.35700000E-05  +1.42500000E-05  -2.49800000E-05
   -3.93600000E-05  -2.09030000E-04  +3.13770000E-04  -7.49000000E-06  +4.59000000E-06
   -1.40000000E-06  +1.27449000E-03  -1.63425000E-03  -7.98200000E-05  -1.74410000E-04
   -3.46640000E-04  +3.73250000E-04  +1.53690000E-04  -2.18440000E-04  +1.67220000E-04
   -2.90750000E-04  +5.55630000E-04  +1.34305000E-03  +2.41240000E-04  -3.60910000E-04
   +1.48300000E-04  -7.69150000E-04  +6.89300000E-05  +5.80700000E-04  -3.81456900E-02
   +1.21367520E-01  +2.71108400E-02  -1.26515870E-01  -2.62546020E-01  +2.13234000E-03
   -1.28091900E-02  -2.03064300E-02  -5.80346000E-03  -1.63317000E-03  +4.85820000E-04
   -4.53520000E-04  -2.56360000E-04  +5.64920000E-04  -8.95580000E-04  +8.73530000E-04
   +1.08373000E-03  -2.77096000E-03  +1.86278000E-03  +2.42780000E-03  +2.80610000E-03
   +5.86680000E-04  -1.61112000E-03  +1.11346000E-03  -1.03431000E-03  +4.97020000E-04
   +3.38260000E-04  +1.26840000E-04  +1.12110000E-04  +2.52320000E-04  -1.88550000E-04
   +1.93480000E-04  -3.88300000E-05  +2.69000000E-05  +8.32000000E-06  +2.58000000E-06
   +6.15000000E-06  +3.77300000E-05  -8.97000000E-06  -3.05000000E-05  -3.67000000E-06
   +2.38400000E-05  +3.00500000E-05  +1.85600000E-05  +3.73200000E-05  +6.70500000E-05
   -1.32700000E-05  +3.87900000E-05  +3.28800000E-05  +8.30000000E-06  -6.41920000E-04
   +2.24330000E-04  +3.57600000E-05  +6.46560000E-04  +4.22140000E-04  +6.20200000E-05
   +2.06000000E-06  -7.85000000E-06  -2.93000000E-06  +5.65000000E-06  +1.10000000E-06
   -6.50000000E-06  -1.18000000E-05  -5.48900000E-05  -3.53800000E-05  +6.96000000E-06
   -1.34800000E-05  -1.02300000E-05  +9.58000000E-06  +2.16000000E-06  -1.80000000E-07
   +5.15300000E-05  -2.53100000E-05  +8.13000000E-05  -4.45800000E-05  +1.73000000E-04
   -1.22790000E-04  +2.17000000E-06  +3.90700000E-05  -4.78400000E-05  +3.73700000E-04
   +5.57110000E-04  +2.74280000E-04  +5.53900000E-04  +5.56700000E-05  +4.98590000E-04
   +4.81310000E-04  -5.22160000E-04  +3.58390000E-04  +2.85240000E-04  -2.49970000E-04
   -1.53286000E-03  +7.48300000E-05  +5.57800000E-05  -5.07400000E-05  +2.41320000E-04
   +2.05870000E-04  +7.01870000E-04  -2.57098100E-02  +1.38329070E-01  +2.78964450E-01
   +3.77606000E-03  -1.52859000E-03  +1.42237000E-03  -1.67068000E-03  +1.53367000E-03
   -1.98952000E-03  -1.14615000E-03  -9.23950000E-04  -5.05100000E-05  -4.12140000E-04
   -2.03391500E-02  -4.32378600E-02  -1.10100000E-05  -2.77010000E-04  -6.45260000E-04
   -1.68622000E-03  -1.24445000E-03  +1.37727000E-03  -3.15360000E-04  +4.95430000E-04
   +1.01220000E-04  +1.10100000E-04  -4.19000000E-06  +5.20000000E-07  -1.94960000E-04
   +8.74890000E-04  +5.47800000E-04  +6.77500000E-05  -1.80370000E-04  -5.59300000E-05
   +8.06900000E-05  +5.00600000E-05  -4.08900000E-05  +5.42000000E-05  -4.93400000E-05
   +5.83900000E-05  -1.82760000E-04  -1.46370000E-04  -2.41000000E-06  +5.65000000E-05
   +9.50400000E-05  -1.22500000E-05  +2.50000000E-06  +3.75200000E-05  -5.17800000E-05
   +2.42210000E-04  +1.70260000E-04  +3.87100000E-05  -9.33700000E-05  -1.72560000E-04
   -6.79600000E-05  -4.50694800E-02  +1.18720200E-02  +6.19734700E-02  -3.30200000E-05
   -3.52200000E-05  +1.63000000E-06  +1.73200000E-05  +2.34400000E-05  -1.29700000E-05
   -4.82700000E-05  -7.41100000E-05  +6.28100000E-05  -2.77000000E-05  -1.09100000E-05
   -1.95300000E-05  +1.78100000E-05  +5.77000000E-06  +1.11700000E-05  -9.77900000E-05
   -1.37100000E-05  -2.38200000E-05  +1.57750000E-04  -8.27000000E-06  -2.15200000E-05
   +1.55500000E-05  +2.68580000E-04  +1.04960000E-04  -8.27000000E-06  +4.44100000E-05
   +3.83300000E-05  +4.70400000E-05  -6.67000000E-05  +5.77000000E-06  -3.33800000E-05
   +9.40000000E-06  +2.91100000E-05  +3.46100000E-04  +4.44480000E-04  +1.06500000E-05
   -4.18292000E-03  -3.38716000E-03  -4.06130000E-04  +9.23400000E-05  +4.39230000E-04
   -3.90320000E-04  +1.48950000E-04  +2.97650000E-04  -2.11230000E-04  +4.99806000E-02
   -4.12989000E-03  +9.14560000E-04  +8.92300000E-05  -5.24200000E-05  -1.51623000E-03
   +2.56394000E-03  +2.27531000E-03  +1.07466000E-03  +8.33460000E-04  -3.48983000E-03
   -1.23052700E-02  -2.52342300E-02  -8.54300000E-05  -2.85372000E-03  +7.90310000E-04
   +1.56912000E-03  -5.42000000E-06  -7.70720000E-04  -7.98400000E-05  +3.62540000E-04
   -3.81030000E-04  +2.69020000E-04  -8.20600000E-05  +1.01520000E-04  +8.44000000E-06
   +1.66780000E-04  +1.72200000E-05  +1.34870000E-04  -2.52520000E-04  +6.41700000E-05
   -3.02800000E-05  -2.13600000E-05  -5.34800000E-05  -8.78000000E-06  -6.14500000E-05
   +1.03600000E-05  -5.77800000E-05  -4.89600000E-05  +1.04500000E-05  +3.61200000E-05
   +2.10000000E-05  +2.32600000E-05  -2.70100000E-05  +4.03800000E-05  -9.66000000E-05
   +6.69400000E-05  +3.02900000E-05  +9.72000000E-06  +5.21020000E-04  +3.27580000E-04
   +7.83800000E-05  -5.75903000E-03  -8.64983600E-02  -1.62605360E-01  -1.68700000E-05
   -3.28000000E-06  +3.63000000E-06  -1.40700000E-05  +8.40000000E-07  +4.53000000E-06
   -2.57800000E-05  +1.36800000E-05  +3.85200000E-05  +3.18700000E-05  -7.77000000E-06
   +3.20800000E-05  +5.18000000E-06  +7.28000000E-06  +6.41000000E-06  +4.72200000E-05
   +6.55100000E-05  +1.58300000E-05  -1.46530000E-04  -1.75990000E-04  +7.34900000E-05
   -4.89000000E-05  -3.46820000E-04  -2.32070000E-04  -3.94400000E-05  -1.99100000E-05
   -8.28100000E-05  +2.28500000E-05  -6.09000000E-05  -6.63400000E-05  -5.67000000E-05
   -4.44100000E-05  +5.56700000E-05  +5.65740000E-04  -2.77480000E-04  -7.77000000E-06
   -3.93960000E-03  +1.32065000E-03  -8.34610000E-04  +2.61400000E-04  +2.10290000E-04
   -1.90230000E-04  +3.92880000E-04  +1.61720000E-04  -3.36570000E-04  +1.18002000E-02
   +9.98641400E-02  -6.32170000E-04  -1.68265000E-03  -2.74348000E-03  +8.31490000E-04
   +7.21160000E-04  +4.71964000E-03  +5.53412000E-03  +4.55903000E-03  -4.78320000E-04
   -8.45491000E-03  -1.04478600E-02  -1.36590900E-02  -2.25720000E-04  +3.43235000E-03
   +1.92359000E-03  -1.22244000E-03  +7.76720000E-04  -2.01628000E-03  +1.07140000E-04
   -5.87740000E-04  -2.22380000E-04  +2.88800000E-05  +5.58500000E-05  -6.22000000E-05
   +2.32820000E-04  -1.60158000E-03  -1.39198000E-03  -1.30970000E-04  +2.90610000E-04
   -6.07400000E-05  -1.18000000E-06  -1.25050000E-04  +5.57200000E-05  -1.52000000E-06
   +4.77600000E-05  -3.68400000E-05  -2.57000000E-06  +4.88000000E-05  -2.00000000E-05
   -7.38500000E-05  -5.87200000E-05  -5.54600000E-05  -2.48600000E-05  -8.47600000E-05
   +2.33700000E-05  -4.60200000E-05  -3.43700000E-05  -2.37400000E-05  -2.48330000E-04
   -2.29900000E-05  +1.84130000E-04  +2.29578800E-02  -1.80175680E-01  -4.34280990E-01
   +3.00000000E-06  +7.51000000E-06  +7.84000000E-06  -2.67000000E-06  +1.03000000E-06
   +1.12400000E-05  +3.43700000E-05  +6.08300000E-05  -5.30700000E-05  -3.56100000E-05
   +3.62900000E-05  +3.54000000E-06  -1.55400000E-05  -6.88000000E-06  -2.45000000E-06
   -1.71240000E-04  +3.63800000E-05  -2.03090000E-04  +5.57500000E-05  +9.52100000E-05
   -1.99000000E-04  +4.80000000E-07  +8.08200000E-05  +1.85070000E-04  +9.27000000E-06
   -7.83400000E-05  -6.40000000E-06  -5.42400000E-05  +4.32600000E-05  -2.67800000E-05
   +4.53000000E-05  +9.47000000E-06  -8.68000000E-05  +4.44440000E-04  -2.37680000E-04
   -6.62890000E-04  -4.85440000E-04  -1.34019000E-03  +2.67400000E-03  +2.20170000E-04
   +1.82080000E-04  -2.64970000E-04  -1.31520000E-04  -7.02900000E-05  -1.24490000E-04
   -1.85442900E-02  +1.86069650E-01  +4.46893310E-01
end_hess

