# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.89487050    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.47769546E+00  +1.03430181E+00  -2.15791075E+00
   006   -1.80180174E+00  +1.09985361E+00  -2.49210674E-01
   006   -2.04508476E+00  -5.98159565E-01  +1.91437325E+00
   006   -4.17903327E+00  -1.47989166E+00  +2.88115539E+00
   006   -7.07313299E+00  -1.31541535E+00  -3.56460905E-01
   006   -5.72350229E+00  -5.20925188E-01  -2.33496554E+00
   006   +5.37268680E-01  +2.80050605E+00  -2.33084481E-01
   006   +7.36007482E-01  +4.46098016E+00  -2.60132009E+00
   008   -9.17912036E+00  -2.70607741E+00  -5.87062502E-01
   006   +2.90626428E+00  +1.13503298E+00  -1.11132466E-01
   006   +4.82659391E+00  +1.47893145E+00  +1.64812359E+00
   006   +6.96855338E+00  -3.03497656E-02  +1.66437528E+00
   006   +7.23303452E+00  -1.94181390E+00  -1.04424714E-01
   006   +5.33409764E+00  -2.32609247E+00  -1.87800929E+00
   006   +3.21078017E+00  -8.02978407E-01  -1.86506680E+00
   008   +9.35999081E+00  -3.37873651E+00  -1.74709179E-02
   006   +3.15868402E-01  +4.56566898E+00  +2.06168417E+00
   008   -6.56242973E+00  -6.93265806E-01  +2.09358686E+00
   001   +9.30878298E+00  -4.62007640E+00  -1.33095338E+00
   001   +8.44507000E+00  +2.58968681E-01  +3.04715992E+00
   001   +4.67810138E+00  +2.94811907E+00  +3.05914467E+00
   001   +1.73618881E+00  -1.15077868E+00  -3.24104003E+00
   001   +5.51054796E+00  -3.82413009E+00  -3.26474056E+00
   001   -1.43839046E+00  +5.63672813E+00  +1.92659651E+00
   001   +2.79114577E-01  +3.52112787E+00  +3.83710247E+00
   001   +1.87713060E+00  +5.91005025E+00  +2.12727170E+00
   001   -8.91425668E-01  +5.71546325E+00  -2.77267588E+00
   001   +2.43143529E+00  +5.62397197E+00  -2.47270447E+00
   001   +8.84045674E-01  +3.33729582E+00  -4.32097538E+00
   001   -3.17490282E-01  -1.26771714E+00  +2.78808126E+00
   001   -4.25331584E+00  -2.82887526E+00  +4.41625476E+00
   001   -6.42979390E+00  -1.01674057E+00  -4.18586044E+00
   001   -3.12196336E+00  +2.19494657E+00  -3.80428695E+00
   001   -9.91293059E+00  -2.87678245E+00  +1.06133291E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +3.10000000E-07  -1.06000000E-06  +3.50000000E-07
   -1.41000000E-06  -7.90000000E-07  -9.00000000E-07
   +2.40000000E-07  -7.10000000E-07  -3.10000000E-07
   -8.30000000E-07  +3.44000000E-06  +2.30000000E-07
   +2.40000000E-07  +1.57000000E-06  -1.25000000E-06
   -5.00000000E-08  -1.71000000E-06  +2.19000000E-06
   -2.10000000E-07  +5.00000000E-08  +2.00000000E-08
   -1.40000000E-07  -4.10000000E-07  -1.40000000E-06
   +1.18000000E-06  -8.30000000E-07  +6.20000000E-07
   +1.80000000E-07  +3.90000000E-07  +1.12000000E-06
   +7.00000000E-08  +6.80000000E-07  -3.70000000E-07
   +2.00000000E-08  +6.60000000E-07  -3.60000000E-07
   +8.60000000E-07  +6.10000000E-07  +1.15000000E-06
   +4.00000000E-08  +3.30000000E-07  +8.50000000E-07
   +3.60000000E-07  -2.20000000E-07  +2.00000000E-08
   -4.10000000E-07  +1.09000000E-06  +1.12000000E-06
   -6.80000000E-07  +8.80000000E-07  -1.08000000E-06
   +8.90000000E-07  -3.51000000E-06  +8.30000000E-07
   +6.50000000E-07  +1.00000000E-07  +1.16000000E-06
   +1.80000000E-07  +1.38000000E-06  +4.20000000E-07
   -1.20000000E-07  +8.90000000E-07  -1.70000000E-07
   -4.10000000E-07  -1.70000000E-07  -1.40000000E-07
   +4.10000000E-07  -4.90000000E-07  +8.90000000E-07
   -4.00000000E-07  +3.20000000E-07  -1.40000000E-06
   -2.00000000E-08  +7.10000000E-07  -5.90000000E-07
   -7.80000000E-07  +1.02000000E-06  -1.50000000E-06
   -4.40000000E-07  -6.50000000E-07  -1.35000000E-06
   -2.40000000E-07  -4.20000000E-07  -1.23000000E-06
   +7.00000000E-08  -1.77000000E-06  -7.30000000E-07
   +6.20000000E-07  +5.50000000E-07  +2.50000000E-07
   +1.20000000E-07  +8.20000000E-07  +1.11000000E-06
   +3.20000000E-07  -1.81000000E-06  +1.50000000E-07
   -2.70000000E-07  -7.80000000E-07  -4.90000000E-07
   -3.40000000E-07  -1.60000000E-07  +8.30000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.44363380E-01  +1.85076350E-01  +3.56247110E-01  +1.86028280E-01  -1.58462660E-01
   +6.72567170E-01  -2.54456450E-01  -2.46978000E-02  -2.00977620E-01  +5.42318340E-01
   -3.18494800E-02  -8.18374300E-02  +1.02141300E-02  +1.19967240E-01  +3.47795020E-01
   -1.74826420E-01  +1.75581600E-02  -3.14120020E-01  +2.12906540E-01  -1.18827610E-01
   +6.03195240E-01  +1.53006000E-02  +1.10156100E-02  -1.56956600E-02  -1.02388600E-01
   -3.55364000E-03  -6.40914000E-03  +8.24846690E-01  +1.63003200E-02  +5.27172000E-03
   +1.15038300E-02  -2.13073700E-02  -1.34210120E-01  +7.59379500E-02  +8.49532900E-02
   +3.45653200E-01  -1.91447700E-02  +1.88853900E-02  -3.24766600E-02  +1.15926300E-02
   +7.93268700E-02  -1.67144990E-01  -4.92468100E-02  -2.51990130E-01  +4.52039340E-01
   +4.67480000E-04  +1.01266200E-02  -6.12059000E-03  +2.11394000E-03  -1.76642100E-02
   +1.79912300E-02  -4.12922290E-01  -1.36630360E-01  +1.51614510E-01  +7.17941910E-01
   -1.62606100E-02  -6.50816000E-03  -4.52352000E-03  -1.54412800E-02  -9.81736000E-03
   +3.16538200E-02  -1.34797950E-01  -1.30093400E-01  +8.46714700E-02  +1.07682040E-01
   +3.76925880E-01  -5.22790000E-04  +2.95764000E-03  -2.57255000E-03  +2.22767000E-02
   +1.22157200E-02  -3.50352000E-03  +1.58512080E-01  +9.92581200E-02  -1.64562880E-01
   -1.23239200E-01  -2.94642790E-01  +4.87867580E-01  -2.05299700E-02  -1.62142500E-02
   +2.05741000E-02  +3.63649000E-03  +7.36870000E-04  +1.30851000E-03  -3.92146000E-03
   +1.43846000E-03  -2.45107000E-03  -1.56570500E-02  -4.50851000E-03  -3.38738300E-02
   +6.04199160E-01  -3.22407900E-02  -1.87966700E-02  +1.02361600E-02  +5.45467000E-03
   -2.83898000E-03  +1.57617100E-02  +5.56464000E-03  +9.85323000E-03  -7.23277000E-03
   -7.44477000E-03  -9.67549000E-03  +5.28919000E-03  +2.51896910E-01  +3.22524480E-01
   +3.22308000E-02  +2.34769000E-02  +1.04003500E-02  -1.07220400E-02  -8.49241000E-03
   -1.37036600E-02  +1.40055400E-02  -1.21377100E-02  +9.75951000E-03  -6.28246400E-02
   +2.41475700E-02  -3.34793400E-02  -1.60347940E-01  -5.26118400E-02  +7.28759070E-01
   -1.90222930E-01  -9.93665900E-02  -2.52923000E-03  -2.65036200E-02  -1.34221200E-02
   -2.60402000E-02  -4.80433000E-03  -7.43841000E-03  +9.21542000E-03  -3.40911000E-03
   +7.62996000E-03  +2.47402000E-03  -2.04159950E-01  -6.80093400E-02  +1.49198290E-01
   +5.25343070E-01  -9.44114300E-02  -1.26762330E-01  +8.95757000E-03  -1.02385500E-02
   +3.20777000E-03  -1.62240800E-02  +9.11000000E-04  -7.17767000E-03  +3.60433000E-03
   -8.11000000E-05  +8.67198000E-03  +2.11415000E-03  -8.60440900E-02  -1.01811490E-01
   +8.05592900E-02  +2.68762560E-01  +2.86502820E-01  -2.75227000E-02  -1.16299000E-02
   -1.03676560E-01  -1.86221800E-02  -1.47744800E-02  +1.13297000E-02  +1.97880000E-04
   +2.42599000E-03  -5.65326000E-03  +1.74625400E-02  -6.14965000E-03  +7.30080000E-04
   +1.67452100E-01  +8.57529000E-02  -3.35217920E-01  -6.52288100E-02  -3.16074300E-02
   +7.77029860E-01  -1.81787500E-02  -1.36637700E-02  -5.14148000E-03  -1.34517710E-01
   -4.29142700E-02  -5.65539000E-03  -3.81093000E-03  -8.25540000E-03  +7.92856000E-03
   +1.36040000E-03  +1.79388000E-03  -1.69594000E-03  -1.44171000E-03  +6.49500000E-05
   +9.59780000E-04  +4.53200000E-03  -2.32715000E-03  -4.65323000E-03  +4.64430460E-01
   -5.29837000E-03  +3.08002000E-03  -5.40885000E-03  -4.70305400E-02  -1.09399790E-01
   +7.86861000E-03  -1.66563900E-02  -1.20503900E-02  +2.38005000E-03  +8.86320000E-04
   -1.63539000E-03  +1.29465000E-03  -1.00049000E-03  -1.57834000E-03  +1.34207000E-03
   -1.54165000E-03  +6.03735000E-03  +4.63259000E-03  +3.35235000E-03  +4.80814420E-01
   -1.88886600E-02  -1.34499200E-02  +3.67972000E-03  -1.27380000E-03  +8.66376000E-03
   -8.14117400E-02  +2.37863400E-02  +1.60853700E-02  -6.43950000E-04  -3.42389000E-03
   +3.18008000E-03  -4.59046000E-03  +8.06170000E-04  +4.65100000E-05  -3.00575000E-03
   -4.42979000E-03  +3.69494000E-03  +5.43810000E-04  -2.10968000E-03  -2.17804000E-03
   +4.88837250E-01  -1.62801000E-03  -1.16136000E-03  +4.06330000E-04  -2.79624000E-03
   -1.72939500E-02  +2.32017000E-02  -4.71925000E-03  -2.86303000E-03  -1.18333000E-03
   +8.61970000E-04  -8.79630000E-04  +1.29648000E-03  +4.43520000E-04  +2.61250000E-04
   -9.81200000E-05  -1.32660000E-04  -3.26290000E-04  +9.10860000E-04  -7.51506000E-02
   -2.27663000E-03  +2.69663000E-03  +5.84941040E-01  +1.71520000E-04  -1.35112000E-03
   -5.60100000E-05  -5.55085000E-03  -1.45548100E-02  +1.78426600E-02  -3.15856000E-03
   -4.69640000E-04  -4.10630000E-04  +4.69460000E-04  -5.69780000E-04  +7.45160000E-04
   +3.51900000E-05  -3.78900000E-05  +3.84010000E-04  +5.21200000E-04  -9.19300000E-05
   +4.08970000E-04  -6.72390000E-03  -1.07981780E-01  +4.78870100E-02  -6.82789000E-03
   +5.40982660E-01  -7.75240000E-04  -1.17436000E-03  -3.80600000E-04  +4.85207000E-03
   +2.34333000E-03  +3.40520000E-04  -1.65853000E-03  -8.94300000E-04  +2.97770000E-04
   -9.27400000E-05  -2.74000000E-04  +3.95180000E-04  +1.63970000E-04  +1.65250000E-04
   -3.21590000E-04  -3.71350000E-04  -6.69400000E-05  +1.16600000E-05  +7.02646000E-03
   +4.49308200E-02  -1.42601200E-01  +9.21825000E-03  +6.14129400E-02  +5.11933960E-01
   +9.07598000E-03  +3.73014000E-03  +3.38292000E-03  -2.96998000E-03  +4.58480000E-04
   -3.74306000E-03  -2.48341000E-03  -3.69104000E-03  +3.51782000E-03  +2.32264000E-03
   -3.72902000E-03  -5.67520000E-04  -2.45692550E-01  -1.32187000E-01  -2.41963600E-02
   -3.50407200E-02  -3.15272700E-02  +1.08148300E-02  +1.34906000E-03  +7.66890000E-04
   -1.15902000E-03  -5.68020000E-04  -3.57000000E-06  -2.46100000E-04  +4.00243030E-01
   +8.67500000E-04  +8.66363000E-03  -9.55510000E-04  -1.96254000E-03  -2.50538000E-03
   +6.41200000E-05  -1.03026000E-03  +1.72000000E-06  -5.08410000E-04  -3.93646000E-03
   -3.20857000E-03  +8.72750000E-04  -1.23877350E-01  -1.31172030E-01  -3.00005600E-02
   -3.01779400E-02  -5.59609000E-03  +1.04616600E-02  +1.63471000E-03  +1.98800000E-05
   -1.27489000E-03  -3.25980000E-04  +3.89700000E-05  -2.46940000E-04  +2.13585540E-01
   +1.53250310E-01  -2.87137000E-03  -2.19680000E-03  -4.87376000E-03  +1.20929000E-03
   +9.48050000E-04  +8.36350000E-04  -3.14433000E-03  +2.36852000E-03  -1.85304000E-03
   +8.19945000E-03  -9.66232000E-03  +2.45224000E-03  +2.29856500E-02  +4.99668000E-03
   -1.10065740E-01  +3.55289300E-02  +2.37417300E-02  +9.62921000E-03  -3.11000000E-05
   -1.40150000E-04  +6.05360000E-04  +3.15400000E-05  -4.11700000E-05  +4.74600000E-05
   -1.59571630E-01  -1.12567600E-02  +5.77667990E-01  -7.26030000E-04  -2.19600000E-04
   +2.15146000E-03  -3.60491600E-02  +9.11523000E-03  -4.68989000E-03  -7.33480000E-04
   -3.48130000E-04  +1.33849000E-03  -2.23370000E-04  +1.00843000E-03  -8.23350000E-04
   +1.83460000E-04  +3.14470000E-04  -3.43480000E-04  +3.99490000E-04  -1.30701000E-03
   -9.95280000E-04  -1.37423430E-01  +4.53867400E-02  -6.13637000E-03  -2.24286000E-03
   +7.16064000E-03  -7.84704000E-03  -1.28540000E-04  +5.56300000E-05  +4.96000000E-06
   +5.43206010E-01  -1.32903000E-03  -2.41546000E-03  +2.53930000E-04  -8.55817000E-03
   +1.38471500E-02  -2.25783000E-03  -2.17313000E-03  -2.60590000E-04  +7.62880000E-04
   -5.12640000E-04  +1.41100000E-04  +7.79900000E-05  +1.00926000E-03  +8.41140000E-04
   -1.40233000E-03  -4.43930000E-04  -1.24343000E-03  -5.52900000E-04  +4.00173900E-02
   -1.07893380E-01  -7.68300000E-03  +1.77371400E-02  -1.74461600E-02  +8.37993000E-03
   -1.10063000E-03  -6.71210000E-04  +2.26060000E-04  -1.13536350E-01  +4.55337850E-01
   -1.57170000E-04  -4.85300000E-04  +1.05610000E-04  -4.16716000E-03  +1.94209000E-03
   -1.05598000E-03  +2.07150000E-03  +6.14690000E-04  -5.16190000E-04  +7.74100000E-05
   -1.64150000E-04  +2.80500000E-04  +5.27300000E-05  +9.20700000E-05  -4.01640000E-04
   +3.30400000E-05  -4.80450000E-04  -1.45980000E-04  -9.54072000E-03  -5.34381000E-03
   -8.15102200E-02  -2.35362700E-02  +1.80166400E-02  -4.11294000E-03  -7.50000000E-05
   -1.81800000E-05  +9.47400000E-05  +1.47737880E-01  +1.88389870E-01  +4.87548180E-01
   -6.08940000E-04  -6.86560000E-04  -1.09010000E-04  -1.26974000E-03  +1.79919000E-03
   -5.05690000E-04  +3.03500000E-04  -7.98000000E-05  -6.53180000E-04  -5.76800000E-05
   -2.52210000E-04  +1.57700000E-05  -1.29500000E-05  -1.21100000E-05  -8.12200000E-05
   +4.61000000E-05  -1.03980000E-04  -2.26430000E-04  -1.79711200E-02  +3.03300000E-05
   -1.41320600E-02  -6.05070000E-04  -1.38731000E-03  +9.25180000E-04  +4.88000000E-05
   -2.20000000E-07  +3.01400000E-05  -2.20854800E-01  +2.22372300E-02  -9.03786500E-02
   +5.70459770E-01  +5.64100000E-04  +5.93720000E-04  -1.24030000E-04  +1.01069000E-03
   -2.43929000E-03  +9.26700000E-04  -1.13850000E-04  +8.56000000E-06  +1.74150000E-04
   +1.50480000E-04  +1.74420000E-04  -1.21680000E-04  -1.61310000E-04  -9.28300000E-05
   +3.30910000E-04  +5.01800000E-05  +2.09050000E-04  +1.11690000E-04  +1.27574000E-02
   +6.77701000E-03  +1.24947800E-02  +1.87559000E-03  -1.02796000E-03  -1.09340000E-04
   +1.74710000E-04  +1.42860000E-04  -7.05800000E-05  -2.16720200E-02  -1.09731390E-01
   -5.88217400E-02  -1.64621430E-01  +4.99920870E-01  -8.26200000E-05  -4.30900000E-05
   +1.03450000E-04  +1.80031000E-03  -9.05780000E-04  -9.15200000E-05  +3.70450000E-04
   +3.53580000E-04  -6.66170000E-04  -1.52690000E-04  -3.22810000E-04  +1.45810000E-04
   -2.90130000E-04  -2.80750000E-04  +4.66400000E-05  +5.62400000E-05  +3.51440000E-04
   +4.16100000E-05  -2.64903000E-03  +3.56724000E-03  +3.62868000E-03  +7.44820000E-04
   -6.61340000E-04  +4.13000000E-05  +3.71160000E-04  +2.19500000E-04  +1.31300000E-05
   -1.35230670E-01  -2.81849900E-02  -1.95174520E-01  +1.44052980E-01  +2.46030280E-01
   +5.03853880E-01  +1.58250000E-04  +1.74130000E-04  +2.39590000E-04  -1.36830000E-04
   +6.13820000E-04  -2.87500000E-04  -4.10300000E-05  +1.51310000E-04  +6.82700000E-05
   -3.58300000E-05  +3.72200000E-05  +1.16440000E-04  +2.47580000E-04  +1.86350000E-04
   -3.50150000E-04  -1.19940000E-04  -1.52650000E-04  +1.43520000E-04  +9.71950000E-04
   -4.27300000E-04  -4.11044000E-03  -1.45137000E-03  +7.61150000E-04  -2.11800000E-05
   -3.01900000E-04  -1.97800000E-04  +5.56100000E-05  -4.34790300E-02  -6.94668000E-03
   -4.41468100E-02  -2.62571550E-01  +1.45325430E-01  +1.16608000E-03  +6.20527780E-01
   -1.92190000E-04  -1.30400000E-04  -3.15250000E-04  +6.55010000E-04  -9.06330000E-04
   +3.65600000E-04  +2.29500000E-04  -1.76410000E-04  -1.20060000E-04  +5.15600000E-05
   -1.40920000E-04  -4.61000000E-05  -3.92950000E-04  -3.10360000E-04  +4.13360000E-04
   +1.98090000E-04  +2.74010000E-04  -1.44920000E-04  +6.31310000E-04  +2.89002000E-03
   -2.90508000E-03  -7.84000000E-05  -2.30130000E-04  -2.18310000E-04  +4.60740000E-04
   +2.95870000E-04  -5.62100000E-05  +2.63688800E-02  +3.79037200E-02  +4.95961200E-02
   +1.00626750E-01  -1.75578770E-01  -4.32211100E-02  -1.64359380E-01  +4.67368550E-01
   -2.57520000E-04  -2.27190000E-04  +8.58000000E-05  -8.55410000E-04  +7.06660000E-04
   -2.79850000E-04  -3.41100000E-05  +1.46350000E-04  -2.30520000E-04  -1.80730000E-04
   -4.67700000E-05  +2.59100000E-05  -1.15950000E-04  -1.05260000E-04  -1.25070000E-04
   +7.91700000E-05  -1.82400000E-05  -1.13410000E-04  -3.84060000E-03  -4.18539000E-03
   +5.00180000E-04  +1.22660000E-03  -8.81990000E-04  -5.95400000E-05  +1.40290000E-04
   +9.12100000E-05  +3.12400000E-05  -1.01151700E-02  +2.62747300E-02  +2.62454700E-02
   -4.43673000E-02  -1.11058700E-02  -1.04519440E-01  +1.90998850E-01  +2.26366540E-01
   +5.02827400E-01  -3.61100000E-05  +7.90500000E-05  -2.54100000E-05  -1.56840000E-04
   -4.83860000E-04  -7.74100000E-05  +1.38410000E-04  +4.09190000E-04  -1.49710000E-04
   -4.74320000E-04  -6.43600000E-05  +6.97100000E-05  -8.81490000E-04  -5.93100000E-04
   +1.29320000E-04  +3.67860000E-04  +1.49900000E-04  -2.38350000E-04  -2.23312000E-03
   +3.44100000E-04  -1.14160000E-04  +6.19310000E-04  -1.36080000E-04  -2.18030000E-04
   +8.94050000E-04  +6.16840000E-04  -4.81000000E-06  -8.29099000E-03  -2.03810600E-02
   -2.33089900E-02  +2.32591600E-02  +1.64722200E-02  +3.18247500E-02  -1.17680530E-01
   +4.42328900E-02  +1.13695600E-02  +5.92085920E-01  +2.04760000E-04  +1.59850000E-04
   +1.53700000E-04  -6.10100000E-05  +8.70400000E-04  -2.27890000E-04  -1.05910000E-04
   -1.04670000E-04  +2.27640000E-04  +2.33080000E-04  +1.09630000E-04  +3.39900000E-05
   +7.22710000E-04  +5.36510000E-04  -3.54210000E-04  -3.14600000E-04  -3.08810000E-04
   +2.46350000E-04  -1.92500000E-04  -8.82710000E-04  -9.26310000E-04  -8.47180000E-04
   +5.74010000E-04  +1.51260000E-04  -7.90970000E-04  -5.30870000E-04  +4.25900000E-05
   -1.94700700E-02  -2.53689300E-02  -3.37609000E-02  +5.40880400E-02  -3.22779900E-02
   +3.66127000E-03  -6.23134000E-03  -2.05832470E-01  -1.42552420E-01  -1.60168560E-01
   +5.01900440E-01  +2.77350000E-04  +2.69680000E-04  +1.83230000E-04  -2.48600000E-04
   +3.62780000E-04  -2.76450000E-04  -2.07200000E-05  +9.71300000E-05  +2.33450000E-04
   -4.22000000E-06  +1.38810000E-04  +4.86000000E-05  +1.22810000E-04  +1.51450000E-04
   -1.79250000E-04  -9.48800000E-05  -1.57410000E-04  +9.91500000E-05  -1.12988000E-03
   -2.62270000E-04  -1.49409000E-03  -5.29420000E-04  +5.39510000E-04  +2.23790000E-04
   -1.92410000E-04  -1.15050000E-04  +1.77400000E-05  -2.20671800E-02  -3.44122100E-02
   -5.75053500E-02  +7.09478700E-02  -2.34739000E-02  +2.92461000E-02  -4.04308000E-02
   -1.05468870E-01  -2.09533880E-01  +1.49351680E-01  +2.29808310E-01  +5.07859380E-01
   -1.89630000E-04  -2.10630000E-04  +4.27900000E-05  +9.05000000E-05  +6.11100000E-05
   +2.49620000E-04  -4.33000000E-06  -1.90490000E-04  -3.96140000E-04  +8.05700000E-05
   -1.74730000E-04  -7.73400000E-05  +2.36010000E-04  +9.20900000E-05  +1.73800000E-05
   -3.75300000E-05  +7.04900000E-05  +2.40900000E-05  +4.04640000E-03  +4.85800000E-05
   -1.21563000E-03  -1.24020000E-04  -8.89200000E-05  -1.42150000E-04  -1.87190000E-04
   -1.51410000E-04  +4.21000000E-06  +1.97001600E-02  +5.12585100E-02  +6.20172600E-02
   -6.02257100E-02  +1.40829700E-02  -2.59708600E-02  +3.87572900E-02  -5.40542000E-02
   -3.33529500E-02  -2.06327050E-01  +1.96852900E-02  -8.02192200E-02  +5.79589400E-01
   +2.05040000E-04  +4.57610000E-04  +4.43060000E-04  -8.11420000E-04  -7.70300000E-05
   +7.82400000E-05  +7.08500000E-05  +2.12010000E-04  +1.84310000E-04  +1.12300000E-04
   +1.02670000E-04  +6.07300000E-05  +1.47300000E-04  +8.14200000E-05  -7.81400000E-05
   +6.61000000E-06  -1.72200000E-05  +1.09640000E-04  -2.60100000E-04  +6.34610000E-04
   -5.66899000E-03  -7.42100000E-04  +7.64820000E-04  -1.20070000E-04  -1.70230000E-04
   -9.32500000E-05  +8.20000000E-07  +1.70143300E-02  -2.85960500E-02  -2.51545500E-02
   +1.64700500E-02  -7.22277000E-03  +8.11462000E-03  -2.32652100E-02  +1.25724000E-02
   -1.29100700E-02  -3.43426400E-02  -1.17003360E-01  -7.34873900E-02  -1.77217410E-01
   +4.99242740E-01  -3.72500000E-05  +5.00000000E-07  +1.78700000E-04  -7.61560000E-04
   +3.23760000E-04  +5.95700000E-05  -2.21600000E-05  -8.08000000E-05  -1.38690000E-04
   +2.40000000E-06  -8.25100000E-05  -2.02100000E-05  +2.61290000E-04  +1.25420000E-04
   -7.63800000E-05  -1.40900000E-05  +7.84000000E-06  +8.55700000E-05  -1.43806000E-03
   -4.51328000E-03  -1.17978000E-03  -5.89900000E-05  -6.32600000E-05  -1.74530000E-04
   -2.43920000E-04  -1.86430000E-04  +1.96300000E-05  +2.55252800E-02  -4.37750000E-04
   +2.72021300E-02  -2.41114800E-02  +6.61264000E-03  -1.41745200E-02  -1.80559000E-03
   -3.53420700E-02  -2.88580100E-02  -1.34840110E-01  -3.41412200E-02  -2.02532840E-01
   +1.48673180E-01  +2.50206710E-01  +4.88377880E-01  +1.58150000E-04  +6.64750000E-04
   +8.54430000E-04  -8.45830000E-04  +2.53377000E-03  +1.08606000E-03  -3.97850000E-04
   +1.23730000E-04  +7.36120000E-04  +5.16000000E-05  +2.23800000E-04  +1.53800000E-05
   +6.41400000E-05  +1.17050000E-04  -1.34800000E-05  +3.04200000E-05  -2.34370000E-04
   -1.97000000E-05  -3.85267000E-03  +2.09036700E-02  +1.88581600E-02  -5.76300000E-04
   +5.10020000E-04  +1.57134000E-03  -1.79450000E-04  -9.23200000E-05  -1.83400000E-05
   -1.18617580E-01  +8.60973000E-03  -2.68985800E-02  +3.93960100E-02  -2.48334800E-02
   -3.74901000E-03  -2.15884200E-02  +2.73358100E-02  +1.46459700E-02  -4.79443800E-02
   -9.94308000E-03  -4.67375600E-02  -2.65781730E-01  +1.50126950E-01  +3.37840000E-03
   +6.21241160E-01  -1.71190000E-04  -3.88500000E-05  -4.41990000E-04  -2.67590000E-04
   -1.05950000E-03  -3.10790000E-04  -2.92320000E-04  -6.76340000E-04  +9.33940000E-04
   +2.44200000E-04  +3.21800000E-04  -2.66190000E-04  -8.59500000E-05  +2.83800000E-05
   +4.69930000E-04  +6.77900000E-05  -4.65200000E-05  -2.11370000E-04  +9.41370000E-03
   -1.50914600E-02  -1.05466900E-02  +9.36780000E-04  -4.32410000E-04  -1.08978000E-03
   +8.56800000E-05  +7.42700000E-05  -1.05830000E-04  +5.19087000E-02  -2.06368000E-01
   -1.00084290E-01  -5.87859400E-02  +1.04744600E-02  -4.00587300E-02  +2.91590100E-02
   -4.50325000E-02  -2.18072000E-02  +2.79319200E-02  +4.11713300E-02  +5.92851300E-02
   +1.05616830E-01  -1.78771990E-01  -4.43415400E-02  -1.55375430E-01  +4.66163330E-01
   -2.97580000E-04  -2.94180000E-04  -6.80330000E-04  +5.54190000E-04  -1.01284000E-03
   +3.67670000E-04  +3.18500000E-05  -4.13750000E-04  +8.11700000E-05  +7.99900000E-05
   -9.24000000E-06  -9.59800000E-05  -1.93850000E-04  -6.59800000E-05  +2.94440000E-04
   +7.08700000E-05  -2.31170000E-04  -2.81560000E-04  +5.85995000E-03  -4.86650000E-04
   +5.11693000E-03  -9.60160000E-04  +1.07788000E-03  -2.27540000E-04  +1.62930000E-04
   +9.50700000E-05  -5.35400000E-05  +1.86836900E-02  -1.30709220E-01  -1.90733720E-01
   -3.85989800E-02  -1.57584300E-02  -3.53828800E-02  +1.67400300E-02  -2.34184400E-02
   -1.51071000E-02  -7.91857000E-03  +3.23391500E-02  +2.97509500E-02  -4.22363700E-02
   -1.22606800E-02  -1.02857990E-01  +1.82246210E-01  +2.12449680E-01  +4.89391870E-01
   +1.53580000E-04  +4.49200000E-05  +2.45830000E-04  +2.86900000E-05  +1.03334000E-03
   -1.58700000E-05  -2.17530000E-04  -3.44770000E-04  +1.23230000E-04  +4.20360000E-04
   +7.33100000E-05  -2.13300000E-05  +1.11036000E-03  +7.59530000E-04  -3.66570000E-04
   -4.57200000E-04  -2.99100000E-04  +3.43300000E-04  +1.51864000E-03  -7.65580000E-04
   -5.13470000E-04  -1.28126000E-03  +4.96430000E-04  +4.79040000E-04  -1.16418000E-03
   -7.95100000E-04  +4.06400000E-05  -2.33877000E-03  +2.44331000E-03  +2.78218000E-03
   +8.83550000E-04  -7.12650000E-04  -3.71422000E-03  -7.48135000E-03  +1.75125800E-02
   +6.96598000E-03  -2.38072870E-01  +9.58640900E-02  -4.43023200E-02  -4.13381100E-02
   +3.15531200E-02  -5.09164000E-03  +3.28180000E-03  -2.89880000E-03  -5.89445000E-03
   +3.22982850E-01  -1.20480000E-04  -6.51800000E-05  -2.08030000E-04  -1.30000000E-07
   -8.41460000E-04  +2.13300000E-05  +1.84560000E-04  +2.52500000E-04  -7.97600000E-05
   -2.52730000E-04  -6.50700000E-05  +4.25900000E-05  -8.28010000E-04  -5.77600000E-04
   +3.21020000E-04  +3.36250000E-04  +2.74370000E-04  -2.63510000E-04  -1.14900000E-03
   +2.92050000E-04  +1.01780000E-03  +1.03398000E-03  -4.54360000E-04  -3.58290000E-04
   +8.72600000E-04  +6.09320000E-04  -4.18500000E-05  +2.94026000E-03  +6.23030000E-04
   +3.29377000E-03  -4.99716000E-03  +2.63568000E-03  -6.25246000E-03  +4.24160400E-02
   -2.91533100E-02  -6.59782000E-03  +1.28732810E-01  -1.44324130E-01  -8.78234000E-03
   +5.90753000E-03  +4.66419000E-03  -7.11480000E-04  +2.66592000E-03  -1.05100000E-05
   -5.53319000E-03  -1.52724330E-01  +4.20254800E-01  -1.54000000E-05  +4.44500000E-05
   +6.90000000E-05  -2.32400000E-05  -5.35400000E-05  +5.26400000E-05  -3.47000000E-06
   +3.82300000E-05  -6.66800000E-05  -4.96500000E-05  -1.28000000E-05  -6.23000000E-06
   +2.85000000E-06  -1.84000000E-05  -5.49300000E-05  +1.65000000E-05  +1.99300000E-05
   +2.01200000E-05  +3.03150000E-04  +3.74020000E-04  +5.95400000E-05  +8.75600000E-05
   -7.81400000E-05  -7.36000000E-05  +7.18000000E-06  -1.13000000E-06  +1.48400000E-05
   +2.36019000E-03  +3.64526000E-03  +4.15478000E-03  -8.30183000E-03  -3.09307000E-03
   -4.03878000E-03  +3.24917200E-02  -2.48881400E-02  +5.89675000E-03  -1.05018800E-02
   -3.29925200E-02  -8.52178600E-02  -3.09878400E-02  +1.79766500E-02  +5.32529000E-03
   -2.90010000E-04  -9.50327000E-03  -2.66475000E-03  +6.04354100E-02  +2.92234290E-01
   +3.71578490E-01  -1.20041000E-03  -1.99877000E-03  +9.69720000E-04  -1.96345000E-03
   -1.88222300E-02  -2.37805000E-02  -4.98020000E-04  -9.73290000E-04  -6.89180000E-04
   -1.89260000E-04  -2.76300000E-05  -4.32020000E-04  +9.10700000E-04  +6.93310000E-04
   -2.22513000E-03  -2.63785000E-03  +9.77150000E-04  +1.67808000E-03  -7.55619100E-02
   +2.43065000E-03  +3.36330000E-03  +2.40140000E-04  +6.10900000E-04  +2.79896000E-03
   -1.35085000E-03  -1.16780000E-03  +3.59050000E-04  -2.97559000E-03  +1.87930200E-02
   +2.35870100E-02  -1.19826000E-03  +7.54420000E-04  +6.96050000E-04  +1.76530000E-04
   +4.26570000E-04  +6.99260000E-04  +4.20620000E-04  -2.21100000E-04  -6.31500000E-05
   +2.79840000E-04  +1.15642000E-03  +8.33230000E-04  -4.90237000E-03  +2.28018000E-03
   -1.49755000E-03  -5.63020000E-04  +3.91890000E-04  +1.06000000E-06  +5.86055280E-01
   +1.06885000E-03  -1.19103000E-03  +1.27881000E-03  -6.89157000E-03  -1.90231300E-02
   -1.95670400E-02  -5.15130000E-04  -8.70120000E-04  -6.03520000E-04  -4.84400000E-04
   +6.45770000E-04  -5.23080000E-04  +4.37750000E-04  +5.15100000E-04  -1.35068000E-03
   -1.64062000E-03  +5.04640000E-04  +1.12711000E-03  +6.71906000E-03  -1.11611270E-01
   -4.79947300E-02  -1.08754000E-03  +1.06220300E-02  +1.30736300E-02  -6.09840000E-04
   -5.85450000E-04  +2.02880000E-04  +6.30533000E-03  -1.53909300E-02  -1.64434600E-02
   +1.38000000E-05  -4.06560000E-04  +7.25040000E-04  -4.96930000E-04  -4.84940000E-04
   -6.40350000E-04  +1.98910000E-04  +1.13650000E-04  -3.70500000E-05  -2.74170000E-04
   -5.40400000E-04  -6.46710000E-04  +3.02617000E-03  -4.44440000E-04  +5.45750000E-04
   -3.32400000E-05  -1.02000000E-05  -2.12500000E-05  +8.02145000E-03  +5.37067420E-01
   +1.19261000E-03  +2.10300000E-05  +2.59730000E-04  -7.33859000E-03  -7.84233000E-03
   -2.27831000E-03  +6.99820000E-04  +1.01667000E-03  +7.22470000E-04  +8.94330000E-04
   -4.96960000E-04  -2.42270000E-04  -3.71560000E-04  -3.58710000E-04  +1.37418000E-03
   +3.53980000E-04  +9.79000000E-05  -3.38310000E-04  +8.00371000E-03  -4.44443300E-02
   -1.37395200E-01  +3.06709000E-03  -1.54305400E-02  -3.67637100E-02  +5.85970000E-04
   +4.60290000E-04  -2.30290000E-04  +4.19114000E-03  -9.84480000E-04  +1.30923000E-03
   -1.17371000E-03  +8.94910000E-04  +7.90400000E-05  -1.57320000E-04  -1.59000000E-05
   -1.78590000E-04  +2.71480000E-04  -3.82200000E-05  +3.15170000E-04  -4.42300000E-04
   +2.87540000E-04  +1.22370000E-04  -1.37653000E-03  +7.60720000E-04  -1.31370000E-04
   -3.38060000E-04  +2.25150000E-04  -4.46900000E-05  +1.11971800E-02  -6.29879200E-02
   +5.14944530E-01  -1.61103900E-02  -9.17433000E-03  -1.12864000E-03  +7.66321000E-03
   +3.53348000E-03  +5.93734000E-03  -5.43935800E-02  +2.64949700E-02  -2.68213400E-02
   -2.16601130E-01  +5.80625100E-02  -2.46722100E-02  -9.50433200E-02  -2.12056500E-02
   +6.44280000E-03  +2.31366600E-02  +1.23862300E-02  -4.89667000E-03  +9.59470000E-04
   -9.04020000E-04  +8.31490000E-04  -3.20620000E-04  -3.11080000E-04  -5.48000000E-06
   -1.78834100E-02  -1.71893600E-02  -5.54382400E-02  -3.59500000E-05  +4.16740000E-04
   +3.82860000E-04  +2.23690000E-04  -1.73800000E-04  +3.69390000E-04  +1.09900000E-04
   -4.64100000E-05  +2.24120000E-04  +6.81860000E-04  -2.97650000E-04  +4.68700000E-05
   -1.91200000E-04  -8.60500000E-05  -1.54230000E-04  +4.90000000E-06  -5.39390000E-04
   -1.68600000E-04  -6.37460000E-04  +4.12190000E-04  +4.63700000E-05  +5.88860000E-04
   +6.45820000E-04  -9.72000000E-04  +3.75187410E-01  +2.08901900E-02  +5.57075000E-03
   +6.25542000E-03  -2.28383000E-03  +3.83355000E-03  -2.27799200E-02  -1.12767300E-02
   -1.27758000E-03  +7.88336000E-03  +7.12362700E-02  -6.25214800E-02  +2.70042900E-02
   -1.23376400E-02  -6.30396800E-02  -6.54327500E-02  -1.18906500E-02  -7.46690000E-04
   +9.49011000E-03  -2.06343000E-03  +1.07664000E-03  +8.03860000E-04  -1.54000000E-05
   +5.09600000E-05  +1.33780000E-04  -1.68063700E-02  +1.69262000E-03  -2.68234100E-02
   -4.72410000E-04  -2.57200000E-04  -2.77000000E-06  +1.25010000E-04  -8.80300000E-05
   +1.35370000E-04  -6.34000000E-05  +1.49450000E-04  +3.20800000E-05  -5.89100000E-05
   -7.48100000E-05  -1.39020000E-04  +1.55230000E-04  -1.00700000E-05  +7.60100000E-05
   -1.94780000E-04  -1.19010000E-04  +9.22000000E-06  +1.17500000E-05  +1.84500000E-05
   +1.75900000E-05  +4.34460000E-04  -1.20570000E-04  +4.11360000E-04  -5.10586000E-02
   +1.05550540E-01  -7.86464000E-03  -9.05757000E-03  +4.70790000E-03  +2.22669000E-03
   +6.24851000E-03  -6.55178000E-03  -1.08355300E-02  -4.87274000E-03  +9.51917000E-03
   -2.72471800E-02  +2.73868400E-02  -7.80935100E-02  -4.97733000E-03  -5.64230200E-02
   -2.41400760E-01  -9.08787000E-03  -1.36330100E-02  -6.36693400E-02  -6.79430000E-04
   -3.48680000E-04  +2.65419000E-03  -3.12460000E-04  -2.93200000E-04  +1.57160000E-04
   -2.55473100E-02  -1.22083200E-02  -2.43768100E-02  +1.03790000E-04  +7.73110000E-04
   +1.19420000E-04  +1.65980000E-04  -2.00170000E-04  +1.15080000E-04  +1.11350000E-04
   -1.37410000E-04  +1.72310000E-04  +1.53390000E-04  -1.16400000E-05  -1.50500000E-05
   +5.00400000E-05  -4.70400000E-05  +4.06600000E-05  -1.14570000E-04  -4.01360000E-04
   -1.73410000E-04  -5.92800000E-05  -7.71000000E-06  +6.85200000E-05  +1.08840000E-03
   +7.42180000E-04  -8.40890000E-04  +1.05117230E-01  +4.85921000E-02  +4.04477090E-01
   -3.59200000E-05  -3.59800000E-05  -4.37500000E-05  +5.06000000E-06  -4.47300000E-05
   +1.18100000E-05  +3.83000000E-06  +2.06900000E-05  -2.87800000E-05  -9.57900000E-05
   -6.20000000E-06  -1.42900000E-05  -1.52890000E-04  -9.81700000E-05  +3.04400000E-05
   +6.42900000E-05  +9.29000000E-06  -5.25100000E-05  -1.83980000E-04  -3.23400000E-05
   -9.89100000E-05  +4.40600000E-05  +6.64000000E-06  +1.16800000E-05  +1.55810000E-04
   +9.81600000E-05  -2.50000000E-07  -4.97300000E-05  -4.41550000E-04  -5.75310000E-04
   +1.49049000E-03  +9.52970000E-04  +7.74150000E-04  -5.16970000E-03  +3.52059000E-03
   -1.72073000E-03  -3.68386000E-03  +3.11065700E-02  +3.12837300E-02  +1.52455000E-03
   +5.20540000E-04  +2.26823000E-03  -6.28350000E-04  +1.94410000E-04  +2.22380000E-04
   -3.74630800E-02  -2.25687600E-02  -4.82032900E-02  +7.74500000E-05  -2.22100000E-05
   +2.68300000E-05  +1.09670000E-04  -1.68500000E-05  +3.26000000E-05  +4.51437600E-02
   +2.68100000E-05  +2.31600000E-05  +4.56500000E-05  -7.11000000E-06  +1.34320000E-04
   -5.70000000E-06  -2.96300000E-05  -4.66300000E-05  -1.74000000E-06  +4.38100000E-05
   +7.20000000E-06  -1.13600000E-05  +1.72870000E-04  +1.17140000E-04  -6.66400000E-05
   -6.17300000E-05  -5.05800000E-05  +6.12100000E-05  +1.83770000E-04  -8.17100000E-05
   -4.20000000E-06  -9.70600000E-05  +3.16200000E-05  +3.36700000E-05  -1.76520000E-04
   -1.29830000E-04  +1.07900000E-05  -2.95000000E-05  +5.00830000E-04  +4.81930000E-04
   -2.96120000E-04  +1.75590000E-04  -1.78191000E-03  +4.52256000E-03  +7.95900000E-05
   +1.25924000E-03  +2.51820000E-04  -2.34460200E-02  -2.10862200E-02  -3.79128000E-03
   +3.19862000E-03  +1.39933000E-03  -3.16400000E-05  -1.00742000E-03  -3.82000000E-04
   +1.07965200E-02  -2.53499880E-01  -2.49153280E-01  -7.33400000E-05  -4.12000000E-06
   -2.84600000E-05  -7.85000000E-05  -1.13000000E-06  +8.43000000E-06  -1.21660100E-02
   +2.73876030E-01  +1.65500000E-05  -4.62000000E-06  -7.58000000E-06  +6.17000000E-06
   +4.52500000E-05  +1.18200000E-05  -1.72000000E-06  -2.34100000E-05  +3.42800000E-05
   +5.27200000E-05  +2.21000000E-06  +7.77000000E-06  +3.62600000E-05  +3.06400000E-05
   +3.08500000E-05  -1.88300000E-05  -1.22100000E-05  +8.80000000E-07  +1.07760000E-04
   -4.00400000E-05  -1.53650000E-04  -1.22290000E-04  +6.98200000E-05  +4.88900000E-05
   -4.24700000E-05  -2.37500000E-05  -1.02400000E-05  -1.51330000E-04  +8.12100000E-05
   +1.86930000E-04  -4.77960000E-04  -8.85390000E-04  +4.66710000E-04  -6.83510000E-04
   +4.90260000E-04  +2.10081000E-03  -4.70760000E-04  +1.65238000E-03  -1.37334000E-03
   -2.15288000E-03  +4.54639000E-03  +2.16342000E-03  -1.06000000E-06  -2.17120000E-04
   -8.79260000E-04  -1.38563900E-02  -2.73700090E-01  -2.95059520E-01  -2.09300000E-05
   -4.96000000E-06  -1.43800000E-05  -6.13100000E-05  +1.91000000E-06  -4.90500000E-05
   +1.76395700E-02  +2.68377260E-01  +2.93036200E-01  -3.83700000E-05  -5.43100000E-05
   +3.42600000E-05  -8.00000000E-06  +2.30200000E-04  -7.41800000E-05  -4.40900000E-05
   -2.50000000E-06  -1.84700000E-05  -1.63300000E-05  -9.60000000E-07  +5.31000000E-06
   +7.72700000E-05  +4.62300000E-05  -8.08400000E-05  -3.49000000E-05  -3.35300000E-05
   +1.99100000E-05  -1.25990000E-04  -5.43870000E-04  -8.23110000E-04  -2.16170000E-04
   +8.03500000E-05  +7.80100000E-05  -8.20300000E-05  -5.92700000E-05  +1.50900000E-05
   -1.14296000E-03  +5.28143000E-03  -7.32160000E-04  -1.29731900E-02  -5.87424000E-03
   -1.74002900E-02  -2.00696560E-01  -2.39479300E-02  -1.46211370E-01  +4.78945000E-03
   +2.53819000E-03  +2.20557000E-03  +1.92636000E-03  +2.10085000E-03  -5.92680000E-04
   -2.09630000E-04  +2.56770000E-04  +8.89910000E-04  +1.33100000E-05  -1.54580000E-03
   +1.05517000E-03  -2.24500000E-05  -9.91800000E-05  -4.77900000E-05  +2.80000000E-07
   +3.46000000E-06  +4.64100000E-05  -9.82400000E-05  -2.16110000E-04  +1.22720000E-04
   +2.09034310E-01  +9.73000000E-06  +1.17400000E-05  -1.08800000E-05  +1.83890000E-04
   -2.48800000E-04  +5.45900000E-05  -7.96000000E-06  +1.33500000E-05  -1.08900000E-05
   -7.26000000E-06  -3.60000000E-07  -7.18000000E-06  -3.57500000E-05  -3.66600000E-05
   +3.38400000E-05  +1.59600000E-05  +4.72600000E-05  +7.34000000E-06  +5.07510000E-04
   +4.86060000E-04  +3.74790000E-04  +6.00100000E-05  +4.14200000E-05  -5.33600000E-05
   +4.63000000E-05  +2.85200000E-05  -3.82000000E-06  +4.89879000E-03  +1.01649000E-03
   -2.65977000E-03  +1.32317000E-02  +6.43911000E-03  +1.37874500E-02  -2.28806100E-02
   -5.64278700E-02  -3.86039900E-02  -1.77850600E-02  +2.35371000E-03  -1.61274500E-02
   +2.47645000E-03  -1.03768000E-03  -5.04214000E-03  +4.55200000E-04  -1.28356000E-03
   +8.44600000E-05  -1.33843000E-03  -1.28980000E-04  +2.57016000E-03  -8.00600000E-05
   +3.97800000E-05  +6.68700000E-05  +1.45000000E-06  +5.50000000E-06  -2.46000000E-06
   -1.51580000E-04  +8.92000000E-06  +4.74200000E-04  +2.33162900E-02  +5.03736600E-02
   +1.18800000E-05  +1.69600000E-05  +1.85400000E-05  -1.06960000E-04  +8.51300000E-05
   -1.75400000E-05  +7.88000000E-06  -1.67500000E-05  +7.17000000E-06  +2.54200000E-05
   +3.94000000E-06  -6.40000000E-07  +4.55600000E-05  +3.70500000E-05  -1.42200000E-05
   -2.00400000E-05  -2.07200000E-05  +6.89000000E-06  +4.71100000E-05  -1.53520000E-04
   +2.39280000E-04  +6.32000000E-06  -6.37900000E-05  +4.81000000E-06  -4.93100000E-05
   -3.04800000E-05  +3.80000000E-07  -8.53150000E-04  -2.41261000E-03  +4.06515000E-03
   +2.10316000E-03  -2.26950000E-04  +3.79618000E-03  -1.45133490E-01  -3.94767000E-02
   -1.82700410E-01  -1.87071500E-02  -1.08286000E-03  -9.55030000E-03  -1.92350000E-04
   -5.35047000E-03  +1.83300000E-05  +1.19159000E-03  -1.37270000E-04  -3.30410000E-04
   +1.28123000E-03  +2.39284000E-03  -1.83530000E-04  +2.93000000E-06  +4.70100000E-05
   -5.09200000E-05  -2.39000000E-05  -1.86000000E-06  -8.79000000E-06  +1.88630000E-04
   +4.26490000E-04  +1.78000000E-05  +1.59481070E-01  +4.35370400E-02  +1.86857070E-01
   -2.72800000E-05  +3.43800000E-05  +6.36500000E-05  -2.15620000E-04  +1.11700000E-04
   +1.13720000E-04  +3.21700000E-05  +1.06720000E-04  -4.36400000E-05  -1.11620000E-04
   +1.81800000E-05  +4.11500000E-05  -8.33900000E-05  -7.08200000E-05  -5.71600000E-05
   +7.22300000E-05  -1.90000000E-07  -3.70700000E-05  -6.94800000E-05  -1.41551000E-03
   +1.21161000E-03  +3.22320000E-04  +2.18100000E-05  +9.44800000E-05  +9.00800000E-05
   +6.59100000E-05  +1.23700000E-05  +7.50683000E-03  -1.63039600E-02  -1.45195300E-02
   -5.73269700E-02  +2.03604900E-02  +8.01033000E-03  +1.74484000E-03  +1.95976200E-02
   +1.84371800E-02  -1.97341000E-03  +4.66007000E-03  -2.52964000E-03  -1.33355000E-03
   +7.31600000E-05  -1.09440000E-04  -2.02512000E-03  +9.33580000E-04  -5.34901000E-03
   +7.00000000E-08  +1.00871000E-03  +1.01004000E-03  -2.53337000E-03  +1.27005000E-03
   -9.19460000E-04  +9.74600000E-05  -3.88000000E-06  +6.73400000E-05  -3.42410000E-04
   +1.93940000E-04  +8.92500000E-05  -2.19530000E-04  -1.81565000E-03  +1.27365000E-03
   +5.87854300E-02  -8.34900000E-05  -7.94200000E-05  +9.97200000E-05  -2.74120000E-04
   +3.94690000E-04  -2.99690000E-04  -6.61600000E-05  +1.15660000E-04  -7.77000000E-05
   -1.13310000E-04  -9.60000000E-07  +3.42500000E-05  +4.96400000E-05  +2.33000000E-05
   -1.73980000E-04  -3.07600000E-05  -4.13600000E-05  +1.81100000E-05  -6.06220000E-04
   -2.23714000E-03  +1.25633000E-03  +4.04080000E-04  -1.96390000E-04  +8.63500000E-05
   -5.52900000E-05  -3.77100000E-05  +3.30200000E-05  +6.59940000E-04  +7.43370000E-04
   -3.33804000E-03  +2.00232600E-02  -1.97240830E-01  -1.48676320E-01  +1.40430000E-04
   -9.19963000E-03  -1.34425900E-02  +4.74684000E-03  +2.86657000E-03  -1.84238000E-03
   -4.57200000E-05  -1.36460000E-04  +9.36930000E-04  +8.93120000E-04  +3.49808000E-03
   -2.63853000E-03  +1.76270000E-04  -8.07350000E-04  -7.62900000E-04  +2.66609000E-03
   -6.74680000E-04  +4.05510000E-04  +1.22140000E-04  -1.39500000E-05  +1.27880000E-04
   +1.21310000E-04  -1.95740000E-04  +7.92800000E-05  -1.42411000E-03  -1.26745000E-03
   +2.28903000E-03  -2.91247200E-02  +2.06529170E-01  +2.30100000E-05  +8.11600000E-05
   -3.53900000E-05  +2.40450000E-04  -1.25460000E-04  +2.43020000E-04  +1.62500000E-05
   -3.16500000E-05  +6.22100000E-05  +4.67800000E-05  +9.53000000E-06  +1.22200000E-05
   -3.41400000E-05  -3.12300000E-05  +6.68100000E-05  +3.75700000E-05  +3.01200000E-05
   -1.69700000E-05  +2.26943000E-03  +5.15120000E-04  -1.62512000E-03  -6.26590000E-04
   +1.67720000E-04  -1.81400000E-05  +3.96800000E-05  +3.41900000E-05  -1.27400000E-05
   +3.12890000E-03  -1.58388100E-02  -9.72869000E-03  +7.51569000E-03  -1.48711600E-01
   -1.87734140E-01  -1.57852000E-03  +7.66380000E-04  +3.66635000E-03  -2.43696000E-03
   -1.89656000E-03  +4.24549000E-03  -1.97490000E-04  +1.01588000E-03  -1.79790000E-04
   -5.39043000E-03  -2.39358000E-03  +2.54620000E-04  +1.53330000E-04  -1.49670000E-04
   +5.02000000E-06  +3.59870000E-04  -7.42830000E-04  +4.36920000E-04  -6.05000000E-05
   +1.38600000E-05  -5.40400000E-05  +1.54900000E-05  +1.33320000E-04  -4.40300000E-05
   +1.66770000E-03  +1.99405000E-03  -1.19337000E-03  -6.57981000E-03  +1.64529160E-01
   +1.92286850E-01  -6.48950000E-04  -1.03000000E-06  -7.72200000E-05  -5.17650000E-04
   +9.88980000E-04  +8.29220000E-04  -4.60000000E-06  +1.21100000E-05  -9.51000000E-06
   -5.48400000E-05  +5.13500000E-05  -8.24100000E-05  -2.22130000E-04  -1.34420000E-04
   +1.09470000E-04  +1.61800000E-05  +3.22000000E-05  -8.92700000E-05  -1.23120000E-03
   -4.31270000E-04  +9.29020000E-04  -4.93800000E-05  +1.09130000E-04  -1.74260000E-04
   +2.13880000E-04  +1.62400000E-04  -8.26000000E-06  +5.93081000E-03  +2.55760000E-04
   +1.54577000E-03  +2.12602000E-03  +2.25555000E-03  -6.03360000E-04  -2.39550000E-04
   +2.02000000E-04  +8.96690000E-04  -6.10300000E-04  +5.25440000E-03  -6.79760000E-04
   -1.37004200E-02  -5.41896000E-03  -1.81101900E-02  -1.99024770E-01  -2.86800000E-02
   -1.40946750E-01  -1.34007000E-03  -5.30000000E-07  -8.70290000E-04  -3.55900000E-05
   -1.60720000E-04  +1.21880000E-04  +8.23900000E-05  -8.88800000E-05  -1.71700000E-05
   +1.03600000E-04  -2.06830000E-04  -1.27960000E-04  -1.73450000E-04  -2.10360000E-04
   +1.40800000E-04  +2.53150000E-04  +1.23510000E-04  +2.27690000E-04  +2.08947540E-01
   +2.98880000E-04  +8.72900000E-05  +9.71800000E-05  +1.80960000E-04  +8.04400000E-05
   -2.73870000E-04  +1.20200000E-05  +1.14310000E-04  -2.77190000E-04  -8.69500000E-05
   -1.84680000E-04  +6.61000000E-05  +1.24090000E-04  +2.58300000E-05  -9.77700000E-05
   -2.18000000E-05  -6.64600000E-05  +1.45760000E-04  -1.55037000E-03  -8.92390000E-04
   +1.16461000E-03  +2.27830000E-04  -5.92840000E-04  -4.25480000E-04  -1.70050000E-04
   -1.41570000E-04  +3.36200000E-05  -1.76139800E-02  +1.81773000E-03  -1.51505300E-02
   +2.67643000E-03  -8.94140000E-04  -5.53546000E-03  +2.61520000E-04  -1.06576000E-03
   +2.97870000E-04  +5.04388000E-03  +1.12577000E-03  -3.25029000E-03  +1.44509700E-02
   +6.69590000E-03  +1.29517900E-02  -2.90379200E-02  -6.08272500E-02  -4.13416200E-02
   +8.90340000E-04  +1.88800000E-05  +7.46480000E-04  -1.08140000E-04  +2.91000000E-05
   +9.36400000E-05  +1.42100000E-05  +8.36300000E-05  +7.03600000E-05  -7.48900000E-05
   +1.10080000E-04  +8.99100000E-05  -2.49800000E-04  -2.29910000E-04  +2.99730000E-04
   -9.57440000E-04  -9.93400000E-05  -8.20120000E-04  +2.70704200E-02  +5.67316400E-02
   +2.95030000E-04  +4.11680000E-04  +5.45980000E-04  -2.14500000E-05  -1.05690000E-04
   -1.04670000E-04  +3.10600000E-05  +1.94530000E-04  -1.98350000E-04  +4.73500000E-05
   +2.67600000E-05  +3.42200000E-05  +2.88770000E-04  +1.52000000E-04  -2.16880000E-04
   -6.89200000E-05  +6.09000000E-06  +2.20110000E-04  -2.17040000E-04  +1.87498000E-03
   -1.37447000E-03  +3.83000000E-06  +5.92300000E-05  -1.91200000E-05  -3.16300000E-04
   -2.23350000E-04  +2.38500000E-05  -1.63472500E-02  -2.73266000E-03  -9.69624000E-03
   -5.63610000E-04  -5.98052000E-03  +1.38490000E-04  +1.09557000E-03  +1.56640000E-04
   -2.75880000E-04  -1.03770000E-03  -2.91648000E-03  +4.43573000E-03  +1.26969000E-03
   -1.23380000E-03  +3.66664000E-03  -1.40090680E-01  -4.04624900E-02  -1.78461590E-01
   -1.35500000E-04  +1.24780000E-04  -5.92000000E-06  +2.37470000E-04  +2.99700000E-05
   +5.61000000E-06  -4.32400000E-05  +5.38600000E-05  +6.52500000E-05  +3.85000000E-05
   -2.28400000E-05  -3.32000000E-05  +1.35890000E-04  +3.21790000E-04  -2.95990000E-04
   -8.63180000E-04  -3.00200000E-05  -6.64820000E-04  +1.54994210E-01  +4.78224000E-02
   +1.83437800E-01  +8.99000000E-06  -1.74000000E-06  +1.66600000E-05  +1.19880000E-04
   +6.84200000E-05  -2.82000000E-05  -2.76800000E-05  -3.72500000E-05  -3.95200000E-05
   -8.95000000E-06  -1.65200000E-05  -8.24000000E-06  +5.34800000E-05  +4.56700000E-05
   -2.22200000E-05  -2.81100000E-05  -4.66000000E-05  +2.54800000E-05  +5.57120000E-04
   +7.16440000E-04  +9.11550000E-04  -3.74000000E-06  -7.06500000E-05  +1.14630000E-04
   -6.90900000E-05  -6.11000000E-05  +4.69000000E-06  -2.34757000E-03  +4.74215000E-03
   -2.38403000E-03  -1.58243000E-03  +2.23660000E-04  -2.61960000E-04  -1.97702000E-03
   +6.59780000E-04  -4.74563000E-03  +5.42058000E-03  -1.58636900E-02  -1.50667800E-02
   -5.66155800E-02  +2.26875600E-02  +6.27362000E-03  +2.38926000E-03  +1.89972100E-02
   +1.90743000E-02  +1.78202000E-03  -2.65355000E-03  +1.38527000E-03  -3.79390000E-04
   +1.29120000E-04  -1.26900000E-04  -1.17900000E-05  -5.81000000E-06  +3.28000000E-06
   -7.43380000E-04  +1.03606000E-03  +1.23550000E-04  +2.45860000E-04  -9.02930000E-04
   -7.15830000E-04  -9.30100000E-05  -1.97950000E-04  +2.69050000E-04  -1.26270000E-04
   -1.76189000E-03  +1.37743000E-03  +5.34686300E-02  -5.76000000E-06  +2.16100000E-05
   -4.85000000E-06  -1.84340000E-04  -1.00780000E-04  +7.54000000E-06  +1.67000000E-05
   +2.72200000E-05  -1.85200000E-05  -5.71100000E-05  +4.63000000E-06  -6.84000000E-06
   -8.77100000E-05  -6.03800000E-05  -1.13000000E-06  +3.58100000E-05  +2.49400000E-05
   -1.81900000E-05  -2.62130000E-04  -1.57310000E-04  -8.65850000E-04  +6.46200000E-05
   -6.72000000E-06  -2.18900000E-05  +9.75700000E-05  +6.60100000E-05  +4.53000000E-06
   +5.04083000E-03  +2.46093000E-03  -1.38138000E-03  -6.86000000E-05  -6.81700000E-05
   +7.60560000E-04  +2.58360000E-04  +3.22155000E-03  -2.05163000E-03  +5.10730000E-03
   -2.16359000E-03  -2.60738000E-03  +2.28164300E-02  -1.94735250E-01  -1.46755770E-01
   -6.47150000E-04  -1.00242600E-02  -1.32009200E-02  -2.22853000E-03  +6.67870000E-04
   +2.96512000E-03  +3.06310000E-04  -1.83080000E-04  +1.39380000E-04  +7.41800000E-05
   -7.98000000E-06  +3.36700000E-05  -8.93970000E-04  +1.49070000E-04  -1.06506000E-03
   +3.62200000E-05  -1.79550000E-04  -8.87500000E-05  -2.26870000E-04  -3.53930000E-04
   +2.20940000E-04  -1.36442000E-03  -1.25548000E-03  +2.31983000E-03  -2.78112900E-02
   +2.02837350E-01  -2.50400000E-05  -3.84500000E-05  -6.18200000E-05  +8.56100000E-05
   -5.64400000E-05  +4.23500000E-05  +1.61200000E-05  +1.92900000E-05  +4.17700000E-05
   +2.61000000E-05  +6.89000000E-06  +1.28000000E-05  -7.44200000E-05  -5.54200000E-05
   +6.48400000E-05  +3.01300000E-05  +3.55400000E-05  -3.86600000E-05  -3.37820000E-04
   -9.29400000E-05  +1.19600000E-04  +4.49200000E-05  +2.91000000E-06  -5.77400000E-05
   +7.98000000E-05  +6.49300000E-05  -1.40400000E-05  -1.85316000E-03  -1.93223000E-03
   +4.21159000E-03  -4.78080000E-04  +9.79430000E-04  -2.16990000E-04  -5.18563000E-03
   -1.72289000E-03  -8.77300000E-05  +5.95918000E-03  -1.78750700E-02  -9.68242000E-03
   +6.53642000E-03  -1.46688760E-01  -1.77113120E-01  -8.36470000E-04  +1.17355000E-03
   +3.14654000E-03  +1.91960000E-03  +2.61330000E-03  +1.70490000E-04  +4.22900000E-05
   +4.85600000E-05  +1.81500000E-05  -7.76000000E-06  +9.65000000E-06  -3.74700000E-05
   -1.82990000E-03  +3.30200000E-04  -4.15410000E-04  +2.64580000E-04  -7.64170000E-04
   -6.72100000E-04  +2.40730000E-04  +2.52530000E-04  -3.07580000E-04  +1.62585000E-03
   +2.01834000E-03  -1.30149000E-03  -6.23694000E-03  +1.61649540E-01  +1.82233950E-01
   +3.53150000E-04  +1.32860000E-04  -4.24600000E-05  +7.04900000E-04  -1.28573000E-03
   -1.21790000E-04  +2.47200000E-04  +3.30790000E-04  -1.31280000E-04  -1.69650000E-04
   +2.31600000E-05  +1.64600000E-05  -4.65600000E-05  -7.07500000E-05  +5.29000000E-06
   +5.69000000E-06  +5.60400000E-05  +8.82000000E-05  -2.54979000E-03  +3.76060000E-04
   -9.32030000E-04  -1.11550000E-04  -1.85780000E-04  -3.68980000E-04  +6.92600000E-05
   +2.64400000E-05  -2.40000000E-07  +6.79960000E-04  +1.58200000E-05  +1.01800000E-04
   -1.09980000E-04  -1.29980000E-04  -4.06330000E-04  +1.54230000E-04  +1.54880000E-04
   +2.23300000E-04  +1.11620000E-04  -8.78100000E-05  +2.28500000E-05  -7.93500000E-05
   +8.41200000E-05  +1.06580000E-04  +2.23500000E-05  -1.08700000E-04  -2.84860000E-04
   -1.77680000E-04  +1.65230000E-04  +3.59000000E-05  -2.44410240E-01  +1.19174380E-01
   -1.67714500E-02  +2.36200000E-05  +5.72100000E-05  +5.90700000E-05  +1.74000000E-05
   -2.18600000E-05  -7.97000000E-06  -6.53000000E-06  +4.66000000E-06  -1.94400000E-05
   +1.37350000E-04  +1.37000000E-04  +4.82850000E-04  +8.23900000E-05  +5.86600000E-05
   +5.68300000E-05  -3.76300000E-05  +1.28300000E-05  +2.19000000E-05  +2.62349640E-01
   -6.16130000E-04  +1.24260000E-04  -1.19840000E-04  +1.29894000E-03  +3.92060000E-04
   +5.66990000E-04  +7.60200000E-05  -2.14340000E-04  +2.76780000E-04  +1.64090000E-04
   -1.42600000E-04  +9.77300000E-05  -2.14650000E-04  -2.18150000E-04  +1.47640000E-04
   +1.41400000E-04  +9.87000000E-06  -1.80010000E-04  +1.71141400E-02  -1.25354800E-02
   +1.30228000E-03  -3.36100000E-04  +3.29190000E-04  +1.16371000E-03  +2.11210000E-04
   +1.70800000E-04  -1.68500000E-05  -9.49020000E-04  -1.61471000E-03  -3.80125000E-03
   -5.04270000E-04  +7.43700000E-05  -5.37780000E-04  +9.07700000E-05  +1.49510000E-04
   +6.31200000E-05  -2.91300000E-04  +8.50800000E-05  -1.02470000E-04  +5.62000000E-05
   -3.44030000E-04  -1.40910000E-04  +1.25792000E-03  -1.74450000E-04  +2.75810000E-04
   +2.56910000E-04  -1.64010000E-04  +2.77500000E-05  +1.17491550E-01  -1.17557510E-01
   +1.13312600E-02  -2.02900000E-04  +2.05990000E-04  -1.43060000E-04  -3.51400000E-05
   +3.30900000E-05  +1.49100000E-05  +4.42500000E-05  -4.43000000E-06  -7.00000000E-06
   -1.78290000E-04  -4.00200000E-05  +3.27260000E-04  -1.94000000E-06  +2.73500000E-05
   -8.08400000E-05  +8.44700000E-05  -1.19920000E-04  +2.26500000E-05  -1.29948130E-01
   +1.27206360E-01  -1.95890000E-04  +2.04350000E-04  +1.21100000E-05  +9.21430000E-04
   +4.68580000E-04  +9.09380000E-04  -3.20770000E-04  -9.84100000E-05  -4.69700000E-05
   +1.26590000E-04  +9.13300000E-05  -1.58300000E-05  -1.23480000E-04  -2.12700000E-05
   +2.49860000E-04  +7.59000000E-05  -3.65400000E-05  -1.91370000E-04  +2.24624800E-02
   -1.40876000E-02  +2.00850000E-04  +1.11366000E-03  -7.32680000E-04  +1.25051000E-03
   +1.53380000E-04  +1.29750000E-04  -4.52600000E-05  -9.54650000E-04  -2.54724000E-03
   -4.23644000E-03  -8.94100000E-04  -3.07910000E-04  -5.31070000E-04  +1.98420000E-04
   -1.08400000E-05  +2.47840000E-04  -9.46600000E-05  +1.31750000E-04  -2.22000000E-06
   -1.24110000E-04  -2.34180000E-04  -2.57770000E-04  +1.45099000E-03  -8.70700000E-04
   +4.06180000E-04  +1.16840000E-04  -4.24300000E-05  +3.48100000E-05  -1.84720000E-02
   +1.24433000E-02  -4.81063100E-02  +9.38700000E-05  -1.92800000E-04  -1.80690000E-04
   -1.88900000E-05  +1.87100000E-05  +3.59000000E-06  +2.13600000E-05  -3.34100000E-05
   +1.06400000E-05  +8.32500000E-05  +5.44490000E-04  +2.48720000E-04  -1.40000000E-07
   +3.05200000E-05  -1.99000000E-06  +1.22140000E-04  -7.22300000E-05  -2.15400000E-05
   +1.91748100E-02  -8.71738000E-03  +5.27866400E-02  -8.87200000E-05  -1.04350000E-04
   +5.38300000E-05  -1.61000000E-06  +4.02700000E-04  -7.09750000E-04  +1.07040000E-04
   -3.80810000E-04  -2.20790000E-04  -4.11030000E-04  -3.40700000E-05  +1.34670000E-04
   -9.24000000E-05  -9.36000000E-05  -2.29420000E-04  +7.14400000E-05  +9.45000000E-06
   +1.18400000E-05  -1.91147000E-03  -1.39254000E-03  +2.30144000E-03  -1.55170000E-04
   +4.44320000E-04  +6.29450000E-04  +8.33200000E-05  +4.59900000E-05  +5.05800000E-05
   +3.01240000E-04  -4.93600000E-04  +3.72390000E-04  -1.22140000E-04  +4.31090000E-04
   +6.15660000E-04  -1.03490000E-04  -3.69400000E-05  -2.39670000E-04  -8.63700000E-05
   +1.25700000E-05  -4.14200000E-05  +1.32330000E-04  -1.00680000E-04  -1.46500000E-05
   -7.80100000E-05  +7.45400000E-05  +2.43300000E-05  +1.07890000E-04  -1.13950000E-04
   -3.05500000E-05  -4.71713900E-02  -2.59193000E-03  +3.47940000E-03  +1.17140000E-04
   +6.86900000E-05  +2.03390000E-04  -9.34000000E-06  +1.07400000E-05  +4.60000000E-06
   -1.34900000E-05  +1.00000000E-07  +2.35600000E-05  -1.41233000E-03  -1.46380000E-04
   +3.53670000E-04  -4.46000000E-06  -5.43200000E-05  -4.35700000E-05  +1.24100000E-05
   -1.35500000E-05  -1.26300000E-05  +1.36604000E-03  +1.40188800E-02  -2.44653500E-02
   +4.81039700E-02  -1.08820000E-04  -3.46900000E-05  +3.31300000E-05  +3.12940000E-04
   +9.72930000E-04  +1.50540000E-04  -8.00980000E-04  -6.85140000E-04  -5.50500000E-04
   -6.63500000E-05  -3.27400000E-04  +5.73000000E-06  -1.06120000E-04  -1.23320000E-04
   +1.24230000E-04  +1.53770000E-04  +9.18000000E-06  -1.25380000E-04  +6.14200000E-05
   +1.10609900E-02  -1.72277000E-02  +1.59710000E-04  -2.25959000E-03  -2.72590000E-03
   +1.55640000E-04  +1.15130000E-04  -1.10600000E-05  -1.19860000E-04  +9.01680000E-04
   +4.07480000E-04  +6.81670000E-04  +3.20790000E-04  +1.83320000E-04  +2.75200000E-05
   -1.86600000E-04  -1.63110000E-04  +1.13640000E-04  +1.10600000E-05  +1.88290000E-04
   -1.37470000E-04  +5.94500000E-05  -5.35900000E-05  -2.35630000E-04  -1.18430000E-04
   -1.59100000E-05  -6.94900000E-05  +1.85500000E-05  -3.26900000E-05  -2.81770000E-03
   -1.20106030E-01  +1.19621070E-01  +1.60300000E-04  +6.89100000E-05  +3.66300000E-05
   +1.10500000E-05  -1.05100000E-05  -5.25000000E-06  +1.19800000E-05  +3.48200000E-05
   -2.21900000E-05  +3.10110000E-04  -2.32580000E-04  -2.29480000E-04  +1.43100000E-05
   +2.11300000E-05  -3.06500000E-05  -1.07800000E-05  +2.09100000E-05  -1.10100000E-05
   -1.64343000E-03  -8.59828000E-03  +1.32554700E-02  +2.25399000E-03  +1.29249710E-01
   -4.77030000E-04  -9.06000000E-05  -1.36150000E-04  +1.01711000E-03  +8.62480000E-04
   +3.83090000E-04  -3.33400000E-05  +3.77860000E-04  -2.49790000E-04  -8.49200000E-04
   -3.24500000E-05  +2.74890000E-04  -1.40000000E-05  -2.36870000E-04  -5.07120000E-04
   +1.99390000E-04  +5.36700000E-05  +1.00640000E-04  +1.95490000E-04  +1.42418600E-02
   -2.05873200E-02  +2.65570000E-04  -4.85748000E-03  -3.77247000E-03  +6.61600000E-05
   -5.91000000E-06  +1.18310000E-04  -9.52730000E-04  +9.96840000E-04  +8.37150000E-04
   -3.29120000E-04  -2.70170000E-04  +4.61900000E-05  +2.82390000E-04  -1.51380000E-04
   +2.08170000E-04  +9.01400000E-05  +1.80660000E-04  +1.57180000E-04  -2.23540000E-04
   +1.59460000E-04  -1.84100000E-05  +5.84300000E-05  -5.06010000E-04  -1.74800000E-05
   +1.12100000E-05  -2.78000000E-06  +1.64000000E-05  +3.45829000E-03  +1.17703570E-01
   -2.43472020E-01  +4.98720000E-04  +7.05100000E-05  +5.98530000E-04  +6.38000000E-06
   +8.93000000E-06  -8.45000000E-06  +2.19400000E-05  -2.84100000E-05  -3.47000000E-06
   +4.50480000E-04  +2.53440000E-04  +1.50390000E-04  +2.71500000E-05  +1.02850000E-04
   +3.02400000E-05  +2.70900000E-05  +2.19200000E-05  -3.19200000E-05  +2.02800000E-04
   +3.80670000E-04  -1.17766000E-03  -4.19255000E-03  -1.28186040E-01  +2.65896430E-01
   +8.63070000E-04  -8.86600000E-05  +3.29520000E-04  +2.72640000E-04  -3.73240000E-04
   -5.14160000E-04  +4.19200000E-05  +2.29310000E-04  -2.77030000E-04  -4.67400000E-05
   +7.45600000E-05  -2.59700000E-05  +3.09420000E-04  +2.40700000E-04  -2.27740000E-04
   -2.62770000E-04  -1.05020000E-04  +1.54840000E-04  +1.79052000E-03  +2.44187000E-03
   +3.89980000E-04  +2.95850000E-04  +3.36690000E-04  +2.82810000E-04  -2.85730000E-04
   -2.15610000E-04  +1.92000000E-05  +3.22200000E-05  +2.63400000E-05  -3.27420000E-04
   -8.75070000E-04  +9.13050000E-04  -6.64310000E-04  +1.04400000E-04  +1.69010000E-04
   +2.43410000E-04  -1.90650000E-04  -1.31400000E-05  -3.08400000E-05  +6.32400000E-05
   -2.54100000E-05  +2.71400000E-05  +1.17970000E-04  -9.72700000E-05  +1.91100000E-05
   +9.94600000E-05  -3.50200000E-05  +2.96800000E-05  -2.01940560E-01  -1.31668760E-01
   -4.12695000E-03  +1.77800000E-05  -4.82300000E-05  +1.15170000E-04  -1.88300000E-05
   +1.24100000E-05  +6.78000000E-06  +3.55400000E-05  +9.63000000E-06  -2.75600000E-05
   -1.32564000E-03  +1.98951000E-03  -2.44600000E-05  -1.17600000E-05  +9.64000000E-06
   +5.89000000E-06  +1.59100000E-05  -1.93600000E-05  +9.50000000E-07  -1.92160400E-02
   -1.85211800E-02  +1.64860000E-04  +4.71900000E-05  +1.54205000E-03  -1.21020000E-04
   +2.19771440E-01  +8.16300000E-05  -4.44580000E-04  +4.24870000E-04  +6.80330000E-04
   -1.60203000E-03  -4.10175000E-03  -1.91320000E-04  +2.75500000E-05  -2.28350000E-04
   +2.04080000E-04  +7.30500000E-05  -1.79500000E-05  +4.32970000E-04  +3.91110000E-04
   -6.54710000E-04  -8.27460000E-04  +2.65300000E-05  +3.89380000E-04  -1.54157500E-02
   -1.28390900E-02  +7.44320000E-04  -8.65300000E-05  +4.90180000E-04  +1.55493000E-03
   -5.49060000E-04  -4.05250000E-04  +9.23400000E-05  -7.04970000E-04  +6.13590000E-04
   +3.69110000E-04  -8.37400000E-05  -5.05590000E-04  -8.14970000E-04  +3.30630000E-04
   +2.28450000E-04  +3.66410000E-04  +5.76000000E-05  -1.17500000E-05  +9.21700000E-05
   -1.75620000E-04  +1.72170000E-04  +3.65700000E-05  +3.00420000E-04  -1.24220000E-04
   -1.49970000E-04  -1.07100000E-04  +1.42420000E-04  +5.64000000E-05  -1.30314650E-01
   -1.58531620E-01  -3.62773000E-03  +7.01900000E-05  +1.13600000E-05  +1.59560000E-04
   +4.20000000E-06  -1.58500000E-05  -1.19000000E-06  +1.57100000E-05  -3.51600000E-05
   -1.23900000E-05  +1.53928000E-03  -1.12094000E-03  +9.32660000E-04  -4.86600000E-05
   +7.44600000E-05  +1.24970000E-04  -1.28500000E-05  -3.44000000E-06  +2.27700000E-05
   +1.30347300E-02  +1.21267600E-02  +2.22070000E-04  -1.19784500E-02  -1.03035000E-02
   -1.42545000E-03  +1.42984290E-01  +1.70958650E-01  -4.54300000E-04  -6.04230000E-04
   +2.23990000E-04  +1.25327000E-03  -2.47975000E-03  -4.40170000E-03  +3.52820000E-04
   +5.13260000E-04  -2.94680000E-04  -8.60120000E-04  +3.33900000E-05  +1.14140000E-04
   +3.30010000E-04  +1.26550000E-04  -1.04734000E-03  -7.18520000E-04  +2.76020000E-04
   +5.71110000E-04  -2.03637500E-02  -1.61856700E-02  -1.62241000E-03  -1.26916000E-03
   -9.15030000E-04  +1.15445000E-03  -4.26420000E-04  -4.11590000E-04  +1.80230000E-04
   -1.91100000E-04  +6.54280000E-04  +6.14700000E-04  +3.23400000E-04  +4.20540000E-04
   +4.63660000E-04  +1.04810000E-04  -1.59010000E-04  -1.26810000E-04  +1.19850000E-04
   +4.54500000E-05  +1.59560000E-04  -1.21070000E-04  +6.94900000E-05  -3.11200000E-05
   +1.76500000E-05  -2.25000000E-06  -2.48440000E-04  -4.47800000E-05  +1.16800000E-05
   -2.75000000E-05  -3.78091000E-03  -2.52606000E-03  -4.75642600E-02  +4.41670000E-04
   +1.57140000E-04  +7.61740000E-04  +6.54000000E-06  -1.33200000E-05  -2.89000000E-06
   -6.98000000E-06  -2.02000000E-06  +9.10000000E-06  -2.98510000E-04  +2.75770000E-04
   +1.32850000E-04  -5.28600000E-05  -3.37000000E-06  +3.19100000E-05  -1.97200000E-05
   -1.25500000E-05  +8.48000000E-06  -2.03305000E-03  -1.83459000E-03  -1.02079000E-03
   +2.18281600E-02  +1.69381000E-02  +1.85547000E-03  +4.95926000E-03  +5.81497000E-03
   +5.07427200E-02  -3.81080000E-04  -8.88680000E-04  -4.47760000E-04  +1.60260000E-04
   -1.99820000E-04  +1.01950000E-04  +1.44850000E-04  +2.22230000E-04  -3.02100000E-05
   -4.87900000E-05  -2.95200000E-05  -4.29200000E-05  -6.74100000E-05  -1.14690000E-04
   +7.66300000E-05  +1.45600000E-04  -1.85300000E-05  +1.08750000E-04  +1.50355000E-03
   -2.06598000E-03  +3.86170000E-04  -2.14596900E-01  +1.27962410E-01  -1.51716700E-02
   +6.92000000E-05  +5.89900000E-05  +2.02000000E-06  +4.53380000E-04  +4.89810000E-04
   -3.00640000E-04  +4.92820000E-04  +1.69400000E-04  +1.79390000E-04  +1.41000000E-06
   +3.36000000E-05  +2.90800000E-05  +2.96510000E-04  -1.33020000E-04  +9.24700000E-05
   -2.26190000E-04  +2.58300000E-05  -9.13500000E-05  +3.01690000E-04  -3.74200000E-04
   -4.28100000E-04  -2.80120000E-04  +1.99760000E-04  -5.34000000E-06  +2.31830000E-04
   -3.38720000E-04  +2.45560000E-04  +1.18100000E-05  +3.53200000E-05  +7.20000000E-06
   +2.63800000E-05  -4.06500000E-05  -1.33300000E-05  -2.01200000E-05  +3.75000000E-06
   -2.88000000E-06  -4.61600000E-05  -6.08300000E-05  -3.31000000E-06  -2.15600000E-05
   -4.94000000E-06  +2.07200000E-05  -3.01200000E-05  +1.48200000E-05  +1.87700000E-05
   +2.72440000E-04  -1.02530000E-04  -2.81040000E-04  +1.74170000E-04  -2.33470000E-04
   -8.40100000E-05  -1.81170000E-04  +1.16460000E-04  -5.39900000E-05  +2.32305460E-01
   -1.74470000E-04  -2.41010000E-04  +5.88510000E-04  +7.87850000E-04  +5.65410000E-04
   -2.95260000E-04  -1.88300000E-04  -8.97000000E-05  +2.21100000E-04  +7.98900000E-05
   +9.33200000E-05  -7.31000000E-05  -1.49990000E-04  +1.49500000E-05  +1.15600000E-04
   -1.90320000E-04  +1.64180000E-04  -3.87880000E-04  +1.49650500E-02  -1.15892800E-02
   +2.29390000E-04  +1.26678290E-01  -1.44145000E-01  +1.14090100E-02  +1.89610000E-04
   +9.99500000E-05  -6.16900000E-05  -3.90180000E-04  -1.28141000E-03  +3.69346000E-03
   -4.48780000E-04  -4.41850000E-04  -3.04120000E-04  +6.39450000E-04  -3.65990000E-04
   -3.31240000E-04  -1.63200000E-04  +5.13450000E-04  +4.68680000E-04  -2.92520000E-04
   +1.71380000E-04  -7.57000000E-06  +3.46480000E-04  -1.61850000E-04  +2.85200000E-04
   +4.64260000E-04  -3.62350000E-04  -6.17000000E-05  -2.62900000E-05  +4.28690000E-04
   -1.27051000E-03  +7.98000000E-06  -4.41500000E-05  -1.01370000E-04  -2.93600000E-05
   +4.30000000E-05  +3.61900000E-05  +9.16500000E-05  +1.56000000E-06  -3.56700000E-05
   -4.99500000E-05  -3.37400000E-05  +1.39300000E-04  +6.29200000E-05  +1.86730000E-04
   -1.16710000E-04  +1.89200000E-05  -4.91700000E-05  -1.81500000E-05  -2.21850000E-04
   +5.86050000E-04  +2.60400000E-04  -2.80770000E-04  -6.13000000E-06  -9.22900000E-05
   -1.42210000E-04  -3.46600000E-05  +8.84400000E-05  -1.39671080E-01  +1.55089020E-01
   +3.34550000E-04  -1.23090000E-04  +6.29160000E-04  -3.44060000E-04  -7.35510000E-04
   +5.26820000E-04  -7.05000000E-06  -1.75890000E-04  -2.60680000E-04  +8.54000000E-06
   -4.09000000E-05  +2.59100000E-05  +3.15400000E-05  +4.81500000E-05  +8.38700000E-05
   +1.99400000E-05  +5.23300000E-05  -6.38600000E-05  -2.17157600E-02  +1.56469400E-02
   -2.84117000E-03  -1.48941700E-02  +1.03570800E-02  -4.97185500E-02  -1.58400000E-05
   -3.41700000E-05  -2.58000000E-05  +1.40263000E-03  +2.22870000E-03  -3.84938000E-03
   -5.48590000E-04  +6.06830000E-04  +9.06500000E-05  -1.58610000E-04  -2.25940000E-04
   +2.59820000E-04  +4.15780000E-04  -6.69500000E-05  +1.91340000E-04  -6.44030000E-04
   -6.50300000E-05  +3.65400000E-05  -2.33300000E-05  -3.54600000E-04  -4.69800000E-05
   -4.59250000E-04  +3.80440000E-04  -1.56400000E-05  -1.12273000E-03  +7.25670000E-04
   +1.19631000E-03  -2.66100000E-05  +4.00000000E-06  -4.95500000E-05  +9.33000000E-06
   -3.45200000E-05  -4.63900000E-05  -6.63000000E-05  +3.16200000E-05  -1.20400000E-05
   +3.70700000E-05  +1.03920000E-04  -1.55590000E-04  +2.38850000E-04  +3.70500000E-04
   -5.64300000E-05  -3.89800000E-05  +3.14700000E-05  +1.84600000E-05  +5.36190000E-04
   -1.90090000E-04  -7.02150000E-04  +2.30530000E-04  -1.43180000E-04  +3.67950000E-04
   -3.70400000E-05  -9.07900000E-05  -7.64300000E-05  +1.70023000E-02  -1.45624900E-02
   +5.24500200E-02  +4.58700000E-05  +2.17000000E-06  -3.66340000E-04  +6.74140000E-04
   +3.96100000E-05  +1.90060000E-04  +4.94300000E-05  +2.65300000E-05  -3.59100000E-04
   +6.64700000E-05  -1.21800000E-04  +1.00600000E-04  +2.44460000E-04  +3.50100000E-05
   -1.34480000E-04  +6.06100000E-05  -1.39110000E-04  +2.51520000E-04  -2.63610000E-03
   -3.83030000E-04  -6.64890000E-04  -2.31165270E-01  -1.25124630E-01  -1.58192700E-02
   -2.55130000E-04  -1.52930000E-04  +4.16600000E-05  +7.53080000E-04  +1.18615000E-03
   +4.91400000E-05  +1.67470000E-04  -1.65050000E-04  -1.15470000E-04  +1.03750000E-04
   -9.63200000E-05  +3.79400000E-05  +1.05800000E-05  +8.08600000E-05  +1.50270000E-04
   -2.10210000E-04  +7.16000000E-06  +1.43900000E-05  +3.09990000E-04  -2.41010000E-04
   -1.44750000E-04  +5.58700000E-05  -2.13800000E-05  -2.39500000E-05  -7.17400000E-05
   +1.31030000E-04  -5.29220000E-04  -9.55500000E-05  +8.26300000E-05  +6.06900000E-05
   -9.65000000E-06  +5.00000000E-08  +4.77000000E-06  +2.20900000E-05  -1.47600000E-05
   -2.04000000E-06  +2.80100000E-05  -2.10600000E-05  +1.81600000E-05  +3.33500000E-05
   +5.97900000E-05  -2.58200000E-05  -1.72000000E-06  -1.11400000E-05  -2.20000000E-07
   -1.76500000E-05  -1.27160000E-04  -4.68100000E-05  +2.96210000E-04  +2.73480000E-04
   +5.06000000E-06  +3.31290000E-04  +3.11660000E-04  +5.56550000E-04  -1.91448600E-02
   -1.47818500E-02  -1.97625000E-03  +2.47838250E-01  +3.49750000E-04  +2.96920000E-04
   +4.74730000E-04  +8.71500000E-04  -1.18010000E-03  +3.15160000E-03  -1.23771000E-03
   -3.13270000E-04  -1.45380000E-04  +1.60440000E-04  -2.28220000E-04  +3.10930000E-04
   +2.22950000E-04  +1.69530000E-04  -1.64200000E-04  -2.15290000E-04  +4.63000000E-06
   +9.46900000E-05  -1.56554200E-02  -1.27364700E-02  -1.22821000E-03  -1.23555950E-01
   -1.30651160E-01  -1.14590600E-02  -2.37400000E-04  -1.74270000E-04  +2.81500000E-05
   -1.07227000E-03  +6.26690000E-04  -2.85170000E-04  +2.97640000E-04  +1.22400000E-04
   +8.68000000E-06  +1.86320000E-04  -5.79700000E-05  +7.20500000E-05  +2.12620000E-04
   -8.10500000E-05  +1.39350000E-04  -1.19080000E-04  +4.11000000E-05  -3.89900000E-05
   +1.58310000E-04  -3.73120000E-04  -5.50320000E-04  -1.72980000E-04  +1.61460000E-04
   -4.72000000E-06  +4.23480000E-04  +4.27120000E-04  -1.26354000E-03  -2.40300000E-05
   -3.92000000E-06  +2.06500000E-05  +4.69000000E-06  -3.53600000E-05  -5.93000000E-06
   -1.93000000E-06  -1.26000000E-05  +1.70000000E-06  -3.02000000E-05  -1.44000000E-05
   +6.79300000E-05  -3.53800000E-05  +1.47990000E-04  +1.40590000E-04  -1.39500000E-05
   -6.48000000E-06  +1.24800000E-05  +1.25650000E-04  +4.00200000E-05  +3.14600000E-05
   +3.01480000E-04  +1.06000000E-06  -7.92200000E-05  +1.11980000E-04  +6.36190000E-04
   +1.50850000E-04  +1.66759000E-02  +1.23733600E-02  +1.62299000E-03  +1.36598730E-01
   +1.41036190E-01  -7.83230000E-04  +2.36400000E-05  -6.76780000E-04  -1.12472000E-03
   +2.44816000E-03  -4.62236000E-03  +1.48819000E-03  +9.96110000E-04  +3.95480000E-04
   -2.28040000E-04  +2.73990000E-04  -3.84820000E-04  -9.13800000E-05  -1.41810000E-04
   -1.09930000E-04  +1.35590000E-04  -5.71500000E-05  +3.50380000E-04  +2.25306500E-02
   +1.57993600E-02  -2.76720000E-04  -1.73987400E-02  -1.27952300E-02  -4.72944800E-02
   +3.15700000E-05  +5.86300000E-05  +5.51100000E-05  +8.46280000E-04  -3.86740000E-04
   +5.66300000E-04  +9.37000000E-05  -1.33880000E-04  +2.01880000E-04  -1.60210000E-04
   +1.13880000E-04  -3.29100000E-05  -1.78230000E-04  -3.48400000E-05  -2.18250000E-04
   +3.96770000E-04  -7.00000000E-07  +1.10390000E-04  -3.94550000E-04  +2.51800000E-05
   -9.64400000E-05  +1.80370000E-04  -1.26840000E-04  +1.21700000E-05  +1.20547000E-03
   +1.00041000E-03  +1.22352000E-03  +1.21530000E-04  -1.44800000E-05  +1.47430000E-04
   -1.69700000E-05  +1.39000000E-05  +1.58000000E-05  +1.42000000E-06  +7.11000000E-06
   +1.13700000E-05  -2.50100000E-05  -5.92000000E-06  -9.15900000E-05  -1.96700000E-05
   +5.49000000E-06  +6.93700000E-05  -1.01400000E-05  -1.70200000E-05  -6.40000000E-07
   -4.26000000E-05  -5.69900000E-05  -6.53000000E-05  -2.62810000E-04  -1.35530000E-04
   +2.86060000E-04  -2.64650000E-04  -3.40550000E-04  -7.53700000E-04  -1.21831000E-03
   -1.35321000E-03  -1.17964000E-03  +1.79038000E-02  +9.50682000E-03  +5.33400800E-02
   -4.55440000E-04  -3.97480000E-04  +7.79260000E-04  +2.85530000E-04  +3.87590000E-04
   +1.39070000E-04  +2.27900000E-05  -1.23060000E-04  +3.07600000E-05  +1.92500000E-05
   +1.01500000E-04  -5.25000000E-05  -1.20680000E-04  +2.15300000E-05  +1.37250000E-04
   -2.04000000E-06  +5.86800000E-05  -2.91330000E-04  -2.01473000E-03  +1.66211000E-03
   +1.54268000E-03  -4.82944200E-02  +1.11302500E-02  +1.59345000E-02  +1.56850000E-04
   +8.67600000E-05  -5.63700000E-05  -8.53000000E-06  -6.08170000E-04  -6.73170000E-04
   -1.34860000E-04  +5.39400000E-05  -6.84300000E-05  +9.58100000E-05  -5.30900000E-05
   -4.75900000E-05  -3.95500000E-05  +1.03120000E-04  +5.81500000E-05  -2.16460000E-04
   +2.56300000E-05  +2.27600000E-05  -6.70700000E-05  +2.66730000E-04  -3.01500000E-05
   +5.77100000E-05  -5.11400000E-05  +7.81000000E-06  -1.03470000E-04  -4.73170000E-04
   +2.86200000E-04  +2.05500000E-05  -6.90400000E-05  -1.02870000E-04  -8.88000000E-06
   +2.16900000E-05  -7.76000000E-06  -1.02000000E-06  -7.53000000E-06  +9.49000000E-06
   +1.91300000E-05  -5.67000000E-06  +5.63600000E-05  +1.91190000E-04  +1.97510000E-04
   -1.07490000E-04  +2.37800000E-05  +1.44000000E-05  -1.89400000E-05  +2.87400000E-04
   -2.65600000E-04  -2.85810000E-04  +6.50630000E-04  +1.14860000E-04  +1.68420000E-04
   +1.79040000E-04  +3.15300000E-04  +1.78430000E-04  -1.12356000E-03  +1.34074600E-02
   +2.18821200E-02  +2.50855000E-03  -1.46289600E-02  -2.29475400E-02  +5.02193900E-02
   -9.85570000E-04  +4.82200000E-05  -2.81560000E-04  -8.67700000E-05  +6.31050000E-04
   -4.91160000E-04  +3.35510000E-04  +4.70000000E-06  -5.20900000E-05  -3.54800000E-05
   +8.83400000E-05  -3.44800000E-05  -4.31700000E-05  -6.08600000E-05  -8.13000000E-05
   +5.19700000E-05  -1.04010000E-04  +1.74470000E-04  -6.67870000E-04  +1.06945800E-02
   +1.55995000E-02  +1.15517000E-02  -1.30914560E-01  -1.24812210E-01  +7.78000000E-06
   +4.22300000E-05  +3.34000000E-05  -3.35100000E-04  +9.49970000E-04  +7.81400000E-05
   +1.19420000E-04  -6.92000000E-06  -6.82100000E-05  -1.11520000E-04  +1.09060000E-04
   +1.09810000E-04  +3.04000000E-05  -7.52400000E-05  -1.27290000E-04  -4.06400000E-05
   -1.49730000E-04  -9.87300000E-05  +4.22260000E-04  -2.16600000E-04  +7.34070000E-04
   -1.56000000E-04  +9.81400000E-05  +2.42000000E-06  -2.43130000E-04  -1.76765000E-03
   +2.71742000E-03  +6.28100000E-05  -5.36700000E-05  +3.94200000E-05  +1.84700000E-05
   -1.26200000E-05  -1.46900000E-05  -1.13100000E-05  -1.29000000E-06  -1.19000000E-06
   -1.83000000E-05  -1.21600000E-05  +1.08900000E-05  +8.94300000E-05  -9.77900000E-04
   +2.50410000E-04  -3.90000000E-06  +4.74000000E-06  +2.31600000E-05  -2.28890000E-04
   -1.68400000E-05  +1.48180000E-04  -1.38120000E-04  +8.04270000E-04  +9.19780000E-04
   +2.46290000E-04  +3.89600000E-05  +1.74060000E-04  -5.87060000E-04  -1.02899400E-02
   -1.51154800E-02  +2.53839000E-03  -1.00150400E-02  -1.41438000E-02  -1.09409800E-02
   +1.41381990E-01  -3.52980000E-04  +2.02530000E-04  +1.98870000E-04  -1.09835000E-03
   -8.18800000E-04  +6.36130000E-04  +3.60100000E-05  +2.99870000E-04  +5.12200000E-05
   -9.62200000E-05  -4.24400000E-05  +6.47700000E-05  -1.94900000E-05  -1.13640000E-04
   -9.83100000E-05  +1.37230000E-04  -2.40600000E-05  +3.64000000E-04  +1.16242000E-03
   -1.57795100E-02  -2.09640300E-02  +1.53683900E-02  -1.22464630E-01  -2.30837500E-01
   -2.78500000E-05  +9.64000000E-06  +5.26600000E-05  +1.47941000E-03  -9.34220000E-04
   +8.44640000E-04  -8.66430000E-04  +6.84400000E-05  -3.02350000E-04  +4.87270000E-04
   -4.25970000E-04  -1.19090000E-04  +2.12800000E-04  +4.00730000E-04  +4.87820000E-04
   -6.30430000E-04  +3.32730000E-04  +1.71620000E-04  -1.59330000E-04  -6.60920000E-04
   -5.79000000E-05  +8.48800000E-05  -4.15200000E-05  -1.89300000E-05  +1.18310000E-04
   +4.84361000E-03  -4.26363000E-03  +1.84600000E-05  +4.01200000E-05  +8.31600000E-05
   -2.58100000E-05  +1.71000000E-05  -2.43000000E-06  +8.26000000E-06  +1.57200000E-05
   -2.10800000E-05  +1.36890000E-04  +1.90600000E-05  +9.65400000E-05  +2.19610000E-04
   +6.11690000E-04  +1.37810000E-04  -3.87600000E-05  +1.36000000E-06  -6.92000000E-06
   +3.29300000E-05  +5.98100000E-05  +2.57240000E-04  +2.32130000E-04  -1.08822000E-03
   -1.58053000E-03  -6.72300000E-05  +1.41280000E-04  +3.89370000E-04  -2.10190000E-04
   +2.41739000E-03  +3.16622000E-03  +2.22220000E-04  -5.28720000E-04  -1.33199000E-03
   -1.69410600E-02  +1.33830570E-01  +2.52275280E-01  -4.70000000E-07  -8.01000000E-05
   +1.39588000E-03  +5.49220000E-03  -4.40630000E-04  +6.05270000E-04  -2.55553760E-01
   +7.40812400E-02  -1.01009730E-01  -1.88355500E-02  +1.19945200E-02  -1.38987500E-02
   +1.26870000E-04  +6.21430000E-04  +1.37864000E-03  -1.36400000E-04  -2.59830000E-04
   -1.46210000E-04  -1.23690000E-04  -4.13400000E-04  -2.88880000E-04  -1.68900000E-05
   +2.03980000E-04  +6.78900000E-05  -2.36590000E-04  -4.88500000E-04  -3.73380000E-04
   -9.69560000E-04  -1.03914000E-03  +1.08273000E-03  -2.25030000E-04  -2.82910000E-04
   +2.09080000E-04  -1.17350000E-04  +1.76200000E-04  -4.63000000E-05  -2.80220000E-04
   +1.11220000E-04  -1.67740000E-04  +3.24880000E-04  -4.76400000E-05  +9.30000000E-06
   -5.43910000E-04  -2.61930000E-04  +5.78580000E-04  +1.72770000E-04  -1.41030000E-04
   +1.73700000E-05  -8.57700000E-05  -4.82300000E-05  -2.46620000E-04  -3.50877000E-03
   -2.87578000E-03  +8.79060000E-04  -1.83400000E-05  +3.23100000E-05  +3.58000000E-06
   +9.27000000E-06  +5.60000000E-07  +7.64000000E-06  +6.13800000E-05  +1.82500000E-05
   -9.09000000E-06  +2.33300000E-05  +2.97300000E-05  -6.98700000E-05  +1.52100000E-05
   -1.36800000E-05  -1.51200000E-05  -1.17500000E-05  -3.00000000E-07  +4.23300000E-05
   +1.09070000E-04  -3.01100000E-05  +1.60890000E-04  -1.28600000E-05  -5.61800000E-05
   +1.10680000E-04  -1.36700000E-05  +3.46100000E-05  -4.01900000E-05  +5.38100000E-05
   +2.16900000E-05  -1.15000000E-05  -1.32300000E-05  +1.64600000E-05  +5.29800000E-05
   +2.73616340E-01  -4.79060000E-04  -2.19736000E-03  +3.63897000E-03  +1.62495700E-02
   +9.32900000E-05  +4.20852000E-03  +7.57578600E-02  -7.79969100E-02  +5.12740000E-02
   -7.80690000E-03  +6.34525000E-03  -5.33338000E-03  +9.99460000E-04  +1.54301000E-03
   +2.03796000E-03  -6.08310000E-04  -5.61280000E-04  -4.42000000E-04  +8.49010000E-04
   +2.26780000E-04  +4.94200000E-05  -1.72200000E-05  -2.87400000E-05  -1.42000000E-05
   +3.90800000E-04  +4.10820000E-04  +1.48520000E-04  -3.55930000E-04  -1.29730000E-04
   +3.48700000E-05  -1.83330000E-04  +2.85100000E-05  -1.10510000E-04  -1.41780000E-04
   +8.12700000E-05  -7.79200000E-05  -2.65240000E-04  +2.24200000E-05  -1.18780000E-04
   +2.67860000E-04  -2.44000000E-04  +1.18130000E-04  -2.00250000E-04  +4.81920000E-04
   +2.81330000E-04  +2.66410000E-04  -2.19400000E-04  -4.51000000E-06  +4.08000000E-06
   -2.63600000E-04  +3.09290000E-04  -3.66794000E-03  +4.27151000E-03  +4.06584000E-03
   +2.08000000E-06  +4.11900000E-05  +2.76000000E-06  +1.44100000E-05  +7.01000000E-06
   +2.54000000E-06  -7.50200000E-05  -1.07040000E-04  -3.05000000E-06  -2.14000000E-06
   -1.55300000E-05  -8.44400000E-05  +3.63300000E-05  -1.86000000E-05  -3.00600000E-05
   -3.73000000E-05  +1.76310000E-04  -3.36600000E-05  -5.24000000E-05  -6.63320000E-04
   -3.20530000E-04  -2.90500000E-05  +8.80500000E-05  -2.04940000E-04  -3.04300000E-05
   +8.65200000E-05  -5.90000000E-06  -4.84500000E-05  -1.22000000E-05  -3.05100000E-05
   +4.77800000E-05  -3.00000000E-07  -1.04540000E-04  -8.11264900E-02  +7.09140600E-02
   +2.86500000E-03  +3.97496000E-03  -7.90200000E-04  -2.10108500E-02  +8.66780000E-03
   -1.07490100E-02  -1.05439760E-01  +4.74305600E-02  -9.50034600E-02  +1.06854500E-02
   -3.23961000E-03  +5.08030000E-03  +1.63795000E-03  +1.21853000E-03  -1.70044000E-03
   -1.20103000E-03  -2.91810000E-04  +9.18190000E-04  -7.26840000E-04  -5.46210000E-04
   -8.68000000E-05  +1.36050000E-04  -1.43960000E-04  -9.16900000E-05  -2.11730000E-04
   -2.97500000E-05  +8.37010000E-04  +2.61840000E-04  +3.88520000E-04  +4.96700000E-05
   +5.99030000E-04  -1.86870000E-04  +3.44280000E-04  -1.19770000E-04  +2.69250000E-04
   +7.58300000E-05  +3.18330000E-04  -2.32230000E-04  -1.07440000E-04  +8.56000000E-05
   -2.32670000E-04  +1.45800000E-05  +3.62300000E-05  -3.21830000E-04  -2.97180000E-04
   -3.62050000E-04  +2.51350000E-04  +8.73000000E-06  +1.53190000E-04  -3.51900000E-05
   +7.77200000E-05  +3.79419000E-03  +4.51655000E-03  +5.03151000E-03  +4.32900000E-05
   -4.16100000E-05  -2.35600000E-05  -2.90200000E-05  -7.25000000E-06  -5.23000000E-06
   -4.75600000E-05  -7.00200000E-05  -3.31900000E-05  -6.11400000E-05  +1.08480000E-04
   -5.90100000E-05  -7.60000000E-07  +3.26800000E-05  -7.12000000E-06  +7.59000000E-06
   -1.11540000E-04  -1.62500000E-05  -9.68100000E-05  -1.69560000E-04  +1.21340000E-04
   +2.25000000E-05  +7.69300000E-05  +3.90000000E-07  +2.97700000E-05  -1.37820000E-04
   +6.23100000E-05  +7.12500000E-05  +4.30000000E-05  +3.35400000E-05  -5.90400000E-05
   +3.00900000E-05  +7.84000000E-06  +1.08678120E-01  -5.72338200E-02  +9.95408700E-02
   -1.07770000E-03  -4.86010000E-04  +8.98600000E-05  -3.63156000E-03  -2.18630000E-04
   -4.00940000E-04  +2.90180000E-03  -1.78057000E-02  +2.14908100E-02  -4.99432900E-02
   -1.55619200E-02  +1.63759700E-02  -8.60900000E-04  +4.74959000E-03  +4.56392000E-03
   +6.93190000E-04  -5.37740000E-04  -2.21867000E-03  +2.69710000E-04  -4.80450000E-04
   +1.16575000E-03  -3.63790000E-04  -2.00120000E-04  -1.17000000E-04  +7.50500000E-05
   +5.42200000E-05  -4.93520000E-04  +1.73760000E-04  -2.57400000E-05  +2.12500000E-05
   +2.74000000E-06  +1.07300000E-05  +1.15300000E-05  -1.33000000E-06  +1.81700000E-05
   -3.20000000E-07  +4.62000000E-05  -2.42200000E-05  +1.04900000E-05  -2.43700000E-05
   +1.48400000E-05  -1.96700000E-05  +6.62000000E-06  -7.95000000E-06  -2.01400000E-05
   -5.72700000E-05  +5.12200000E-05  -5.91000000E-06  +6.86100000E-05  +1.14990000E-04
   +1.89000000E-05  -1.47756800E-02  +2.10054200E-02  -3.18287200E-02  -9.20000000E-07
   -1.08600000E-05  +2.36000000E-06  -1.12000000E-05  -3.54000000E-06  +2.07000000E-06
   +4.84000000E-06  -5.52000000E-06  +1.81000000E-06  +1.41000000E-06  -1.63400000E-05
   -5.90000000E-07  -9.89000000E-06  +4.38000000E-06  +7.77000000E-06  +3.85000000E-06
   -1.54900000E-05  -1.48200000E-05  +1.60100000E-05  -1.93000000E-06  -1.73900000E-05
   -1.68000000E-06  -1.29200000E-05  +1.13700000E-05  +1.53500000E-05  -9.30000000E-07
   -1.25000000E-06  -1.85100000E-05  -1.00630000E-04  +1.08170000E-04  +8.17000000E-06
   +1.52900000E-05  +2.98000000E-06  +5.19800000E-04  -1.02210000E-04  +1.47290000E-04
   +6.52551700E-02  -2.34145000E-03  -2.16198000E-03  -7.08450000E-04  -3.35380000E-04
   +5.45773000E-03  +6.30647000E-03  +1.47075000E-03  +7.55260000E-04  +7.26625000E-03
   -1.51031800E-02  -1.69804140E-01  +1.52045840E-01  -1.08106000E-03  -2.50019000E-03
   +1.89622000E-03  +2.49071000E-03  +2.11323000E-03  -1.88320000E-04  +8.62000000E-05
   +4.32940000E-04  -1.89920000E-04  +1.14470000E-04  -2.97100000E-05  -3.71300000E-05
   +2.76790000E-04  -2.89960000E-04  -1.85320000E-04  +9.13800000E-05  -5.82300000E-05
   -5.23000000E-06  -1.62600000E-05  +3.54200000E-05  -9.46000000E-06  +3.60000000E-07
   -8.86000000E-06  -2.82100000E-05  +2.23000000E-05  +7.61000000E-06  +3.35000000E-05
   -3.85300000E-05  -1.55800000E-05  -2.71100000E-05  +4.87900000E-05  +4.70900000E-05
   +2.27700000E-05  -2.36000000E-05  +1.05300000E-05  -1.28000000E-05  -4.20900000E-05
   -1.08750000E-04  -1.03050000E-04  +4.92040000E-03  +1.13011000E-03  +5.98149000E-03
   +6.65000000E-06  -1.93000000E-06  +2.58000000E-06  -1.12700000E-05  -2.40000000E-06
   +2.33000000E-06  -8.87000000E-06  -1.80800000E-05  +2.01000000E-06  +2.80700000E-05
   -2.30800000E-05  -3.34700000E-05  +4.52000000E-06  -3.00000000E-08  -1.82000000E-06
   -6.61000000E-06  +6.30000000E-06  +4.40700000E-05  -5.86300000E-05  -2.12400000E-05
   -3.08900000E-05  -5.57000000E-06  -1.53700000E-05  -4.95700000E-05  -5.86000000E-06
   +2.39000000E-05  +1.96400000E-05  -2.77000000E-06  -2.02500000E-05  -6.30400000E-05
   +2.57200000E-05  +1.06300000E-05  -5.53700000E-05  -3.95800000E-05  -3.15159000E-03
   -3.00178000E-03  +9.48380000E-03  +1.68418900E-01  -2.30444000E-03  -1.90359000E-03
   -2.53000000E-05  +2.56762000E-03  +4.54673000E-03  +6.85771000E-03  -2.90221000E-03
   +9.37836000E-03  -3.01731000E-03  +1.84711500E-02  +1.49996480E-01  -2.10072170E-01
   -5.60540000E-04  +1.30768000E-03  +5.41720000E-03  +1.82180000E-03  +1.22122000E-03
   -1.50554000E-03  -7.32100000E-05  +2.17010000E-04  -1.07776000E-03  +3.62710000E-04
   +9.16800000E-05  +1.02620000E-04  -1.02660000E-04  -2.94910000E-04  -7.34250000E-04
   +2.92300000E-05  +1.29810000E-04  +3.17000000E-06  -1.57500000E-05  -1.20200000E-05
   -4.92300000E-05  +3.20100000E-05  -6.53600000E-05  -1.26100000E-05  -3.17700000E-05
   +6.28100000E-05  +3.94700000E-05  -1.25200000E-05  -2.30400000E-05  +9.37000000E-06
   +4.72900000E-05  +1.47100000E-05  +2.15400000E-05  +6.78900000E-05  -7.03000000E-05
   -1.88000000E-06  -8.82000000E-06  -9.46100000E-05  -2.45820000E-04  -9.84616000E-03
   +7.20831000E-03  -7.89343000E-03  +5.44000000E-06  +1.61000000E-05  -2.42000000E-06
   +7.80000000E-06  -3.90000000E-06  +1.29000000E-06  -6.96000000E-06  +6.11000000E-06
   -7.57000000E-06  +1.04700000E-05  +1.43500000E-05  -1.23400000E-05  +1.78600000E-05
   -3.93000000E-06  -1.77200000E-05  -1.56400000E-05  -1.90500000E-05  +2.44800000E-05
   -2.39300000E-05  -3.31200000E-05  +3.25900000E-05  +2.06900000E-05  +2.67300000E-05
   +2.91100000E-05  -1.97900000E-05  +5.62000000E-06  +1.02800000E-05  +1.24800000E-05
   +7.17900000E-05  -1.23940000E-04  +4.93000000E-06  +6.80000000E-07  -3.90300000E-05
   +7.14500000E-04  -2.98673000E-03  -2.05400000E-03  -8.77799000E-03  -1.68796610E-01
   +2.14532670E-01  -9.38535000E-03  -5.19323000E-03  -2.42769000E-02  -1.56354000E-03
   -3.99393000E-03  +2.04769000E-03  +5.11430000E-04  +1.55650000E-04  -2.62980000E-04
   -9.40150000E-04  -5.03590000E-04  +3.45230000E-04  +6.78937000E-03  +3.71226000E-03
   +1.46192600E-02  -7.72304100E-02  -3.53418200E-02  -9.29646300E-02  -5.87160000E-04
   +7.37050000E-04  -4.41910000E-04  +3.77600000E-05  +3.57800000E-05  -6.08100000E-05
   -3.38710000E-04  +1.95174000E-03  +1.02590000E-04  -6.73400000E-05  -2.76220000E-04
   -3.83400000E-05  -6.72300000E-05  +7.97200000E-05  +5.44000000E-05  -4.72000000E-06
   +2.66600000E-05  -7.06000000E-06  +2.52900000E-05  -3.01900000E-05  -6.90000000E-06
   -1.52900000E-05  +2.42700000E-05  -1.80000000E-07  -7.08400000E-05  -1.32700000E-05
   -9.04900000E-05  -4.49000000E-05  +4.47600000E-05  +9.34000000E-06  +5.31000000E-06
   +4.06700000E-05  +6.33900000E-05  +1.56776000E-03  -4.09519000E-03  +5.22385000E-03
   -5.74000000E-06  -7.13000000E-06  -6.44000000E-06  -8.72000000E-06  +8.77000000E-06
   -5.80000000E-07  +7.82000000E-06  -8.65000000E-06  +1.25000000E-05  -2.34000000E-06
   -4.22700000E-05  -6.17000000E-06  -2.34300000E-05  +1.35300000E-05  +3.80000000E-06
   +1.64700000E-05  -1.63000000E-06  +8.20000000E-07  -7.79000000E-06  -2.28000000E-06
   -1.96000000E-05  -8.34000000E-06  -3.39500000E-05  -1.56000000E-05  +1.24600000E-05
   +1.34200000E-05  +1.23000000E-06  -2.16600000E-05  -2.07700000E-05  +2.24700000E-05
   -1.66500000E-05  -7.84000000E-06  +2.29800000E-05  +2.58000000E-06  +7.73900000E-05
   +2.21900000E-05  +3.58960000E-04  -2.46110000E-04  -1.58700000E-05  +8.13192000E-02
   -1.01059000E-03  +2.03330000E-04  -1.52206500E-02  -3.29489000E-03  -1.26028000E-03
   -7.14580000E-04  +1.90680000E-04  -1.25682000E-03  +1.08145000E-03  -1.70895000E-03
   +2.09207000E-03  -1.67834000E-03  +6.31728000E-03  +6.20347000E-03  +7.07228000E-03
   -3.86345300E-02  -5.76218000E-02  -6.01567500E-02  -4.48460000E-04  +1.13583000E-03
   -7.54500000E-05  -3.14300000E-05  +5.50300000E-05  -9.69100000E-05  -1.63510000E-04
   -3.05889000E-03  +5.48490000E-04  -3.11120000E-04  -4.10440000E-04  -4.58800000E-05
   -3.44600000E-05  +6.73600000E-05  +6.91000000E-05  -5.25200000E-05  +8.33100000E-05
   -9.22000000E-06  +8.76800000E-05  -1.00420000E-04  -3.76300000E-05  -6.70000000E-06
   -2.02600000E-05  -1.01900000E-05  -5.14700000E-05  +3.61000000E-06  +3.81000000E-06
   -1.31020000E-04  +9.52400000E-05  +4.55000000E-06  -8.86200000E-05  -1.09900000E-05
   +1.32130000E-04  -3.76953000E-03  +4.01160000E-03  +3.03378000E-03  +1.80500000E-05
   -1.40800000E-05  -6.55000000E-06  -1.31400000E-05  +1.36500000E-05  -9.43000000E-06
   -6.30000000E-07  -1.80800000E-05  +7.33000000E-06  +2.58900000E-05  +1.49300000E-05
   -3.19900000E-05  -1.75000000E-06  +1.24600000E-05  +5.09000000E-06  +2.52100000E-05
   +2.57700000E-05  +4.85000000E-06  +6.24000000E-06  +1.32900000E-05  +1.82000000E-06
   -4.04100000E-05  -4.55300000E-05  -5.40300000E-05  +3.86700000E-05  -4.70300000E-05
   -1.66800000E-05  +1.02700000E-05  -3.83600000E-05  +5.20500000E-05  -2.74200000E-05
   +2.74200000E-05  +3.17500000E-05  +4.06000000E-06  +7.07900000E-05  -1.78750000E-04
   -1.40910000E-04  +3.93960000E-04  +1.80850000E-04  +4.14632500E-02  +5.02043800E-02
   +1.13809000E-03  +9.89510000E-04  +3.17975000E-03  +8.88140000E-04  -3.75620000E-04
   +8.68920000E-04  +2.70400000E-05  +1.27500000E-04  -1.34170000E-04  +1.25601000E-03
   -6.73240000E-04  +5.41420000E-04  -1.25991000E-02  -8.91525000E-03  -1.99032700E-02
   -8.69114800E-02  -5.93874100E-02  -2.96234060E-01  +1.89780000E-04  +2.24700000E-05
   +6.82000000E-06  -6.16600000E-05  -8.67000000E-06  -6.86000000E-06  -4.83110000E-04
   -5.07350000E-04  +1.47749000E-03  +2.02200000E-05  -7.20000000E-06  +1.01100000E-05
   +1.37000000E-06  +1.01000000E-06  +2.28300000E-05  -4.69000000E-06  +1.05300000E-05
   +1.06900000E-05  +3.53800000E-05  -2.73900000E-05  -4.15000000E-06  -1.18200000E-05
   -3.22000000E-06  -9.37000000E-06  -1.52300000E-05  -5.47000000E-06  -2.09900000E-05
   -4.26100000E-05  +3.39700000E-05  +1.15000000E-06  -3.56600000E-05  -6.42000000E-06
   -1.05200000E-05  +2.17889000E-03  +2.35381000E-03  -3.76126000E-03  +4.34000000E-06
   -7.51000000E-06  -2.23000000E-06  -1.67000000E-06  +1.60000000E-06  -1.56000000E-06
   +6.97000000E-06  +1.51000000E-06  +1.31000000E-06  +6.30000000E-06  -1.83700000E-05
   -5.02000000E-06  -6.35000000E-06  +4.44000000E-06  +3.89000000E-06  +2.40000000E-06
   +6.97000000E-06  +2.09000000E-06  +1.04500000E-05  +2.90000000E-06  +8.61000000E-06
   -6.78000000E-06  -1.34800000E-05  -5.26000000E-06  +1.96000000E-06  +1.01600000E-05
   -5.54000000E-06  -6.69000000E-06  -1.52900000E-05  +5.80000000E-07  +1.10200000E-05
   -3.57000000E-06  -1.10800000E-05  -3.10400000E-05  -2.05200000E-05  +1.44000000E-05
   -1.67320000E-04  +1.07710000E-04  -6.00000000E-08  +9.51287000E-02  +6.65834900E-02
   +3.13080510E-01  -5.59340900E-02  -3.48391400E-02  +3.81606300E-02  +6.44251000E-03
   +1.07122400E-02  -1.91389700E-02  +1.16193000E-03  -4.33558000E-03  -4.65084000E-03
   -2.00366000E-03  +1.81790000E-03  -6.21380000E-04  -1.40793000E-03  -3.15910000E-03
   -4.46177000E-03  -6.52990000E-03  -1.70640500E-02  +2.22760500E-02  -1.46188000E-03
   +2.93840000E-03  +1.54985000E-03  -1.31534000E-03  -1.31457000E-03  -1.18121000E-03
   -1.73921000E-03  -1.72140000E-04  +1.44063000E-03  -6.13020000E-04  -4.16260000E-04
   -1.26680000E-04  -8.38900000E-05  +6.74500000E-05  +1.10010000E-04  +1.83900000E-05
   +1.43700000E-05  -4.20200000E-05  -4.25200000E-05  +1.73400000E-05  -2.22500000E-05
   +3.75900000E-05  +2.72000000E-05  +8.90400000E-05  -6.70000000E-05  -1.93750000E-04
   -1.57080000E-04  +5.94100000E-05  -3.51000000E-05  +1.63900000E-05  +6.41830000E-04
   +1.09480000E-04  +2.18210000E-04  +2.10850000E-03  -1.51035000E-03  +1.17940000E-03
   -1.33100000E-05  +1.39600000E-05  -3.77000000E-06  +2.07000000E-06  +1.60900000E-05
   -4.53000000E-06  -4.13000000E-06  +3.22000000E-06  +3.73000000E-06  +4.22500000E-05
   +1.39440000E-04  +1.69200000E-05  +2.62000000E-06  -8.70000000E-07  -9.55000000E-06
   +5.16600000E-05  +3.28500000E-05  -1.97500000E-05  +6.99000000E-06  +4.75900000E-05
   +1.60630000E-04  -5.18200000E-05  +6.30900000E-05  +1.14800000E-04  -4.19380000E-04
   -5.79590000E-04  -4.13600000E-05  -2.88900000E-05  +3.65590000E-04  +1.37580000E-04
   -2.11712000E-03  -8.49900000E-04  +5.08650000E-04  +4.83400000E-05  +2.51830000E-04
   -1.20440000E-04  +2.22470000E-04  +4.88230000E-04  +4.67700000E-04  +9.09500000E-05
   +8.77830000E-04  -4.27820000E-04  +6.33659600E-02  -3.75008800E-02  -1.38684120E-01
   +1.31370550E-01  +1.90307000E-03  +5.48399000E-03  +4.43585000E-03  -5.01536000E-03
   +6.44139000E-03  +2.26763000E-03  +6.34130000E-04  -2.36329000E-03  -4.68900000E-05
   -1.75019000E-03  -2.35899000E-03  +1.27989000E-03  -2.08514000E-03  -4.15903000E-03
   +1.30716600E-02  +2.06009000E-03  -4.33559000E-03  -2.27226000E-03  -2.28780000E-03
   -5.30840000E-04  -6.41070000E-04  -7.62400000E-05  +1.86990000E-04  +5.22910000E-04
   +6.19770000E-04  +7.51540000E-04  +4.16280000E-04  +1.39300000E-04  -1.65120000E-04
   -1.70870000E-04  +3.13500000E-05  -8.52300000E-05  +1.49300000E-05  -1.64400000E-05
   +9.36200000E-05  +5.48500000E-05  -6.27500000E-05  -5.76300000E-05  -1.03850000E-04
   +1.52780000E-04  +1.31290000E-04  +2.64000000E-04  +4.95800000E-05  -6.42700000E-05
   -3.02200000E-05  -8.22190000E-04  -4.97320000E-04  -1.01580000E-04  -1.54815000E-03
   +2.31816000E-03  -1.18100000E-04  +1.15700000E-05  +1.72000000E-06  +1.24600000E-05
   +1.40300000E-05  -2.51100000E-05  +6.03000000E-06  -1.37400000E-05  +8.24000000E-06
   -1.95900000E-05  +6.77700000E-05  -1.43370000E-04  +3.00000000E-07  +1.43900000E-05
   -1.72700000E-05  +7.85000000E-06  -2.06800000E-05  +3.18000000E-06  +1.00600000E-05
   +1.04000000E-06  -2.17000000E-06  -1.25800000E-05  +6.53000000E-05  -6.52800000E-05
   -2.80480000E-04  -1.15169000E-03  -1.23278000E-03  -2.59630000E-04  +4.49500000E-05
   -1.39710000E-04  -4.82910000E-04  -3.83300000E-04  -2.55550000E-04  -2.56830000E-04
   +1.26030000E-04  +7.10140000E-04  -6.92710000E-04  -5.74100000E-05  -7.12400000E-04
   -5.68150000E-04  +6.34580000E-04  +1.98880000E-04  -1.01890000E-04  +4.63966300E-02
   +1.39552430E-01  +3.23416900E-02  +1.30152570E-01  -2.36876460E-01  +4.74246000E-03
   +1.63329400E-02  -1.59014700E-02  -5.98538000E-03  +2.04137000E-03  -4.46520000E-04
   +7.29300000E-05  -1.17950000E-03  +3.11890000E-04  -1.62326000E-03  -7.79430000E-04
   +2.61369000E-03  +4.67300000E-05  -3.23430000E-04  +2.94756000E-03  +2.80588000E-03
   -6.00280000E-04  -1.56161000E-03  +8.95740000E-04  +8.25510000E-04  +5.48430000E-04
   +4.37510000E-04  +3.46450000E-04  -1.16140000E-04  +3.02700000E-04  +2.73670000E-04
   +2.47400000E-04  +3.36200000E-05  -8.46100000E-05  -3.07100000E-05  +3.90300000E-05
   -6.07900000E-05  +5.05000000E-06  -2.99100000E-05  +6.57900000E-05  +1.80700000E-05
   -6.87000000E-06  -1.26300000E-05  +3.93500000E-05  -5.49900000E-05  -3.81400000E-05
   -1.10100000E-05  +7.60000000E-05  -6.40300000E-05  -2.82000000E-06  -5.46520000E-04
   -2.14010000E-04  -1.47100000E-05  -5.47030000E-04  +1.13287000E-03  -3.05590000E-04
   -8.70000000E-07  +1.34600000E-05  +7.30000000E-07  +1.31100000E-05  -4.93000000E-06
   +5.70000000E-07  +3.60000000E-06  +1.84400000E-05  -1.18100000E-05  -9.21000000E-06
   +6.66100000E-05  -2.83200000E-05  +8.19000000E-06  -3.59000000E-06  -8.72000000E-06
   -5.52000000E-06  -2.27800000E-05  -5.08200000E-05  +3.26300000E-05  -7.20000000E-06
   +9.15700000E-05  -2.22500000E-05  -1.08980000E-04  -1.49050000E-04  +9.61800000E-05
   -7.74860000E-04  -1.30500000E-05  +5.48080000E-04  -1.61020000E-04  +4.40900000E-04
   +4.25780000E-04  +4.52250000E-04  +3.77510000E-04  +3.87780000E-04  +8.92410000E-04
   -1.18280000E-03  +8.57500000E-05  -2.04870000E-04  -2.64790000E-04  +7.47430000E-04
   -3.04810000E-04  +7.13600000E-04  -3.52182400E-02  -1.47649120E-01  +2.48516010E-01
   +1.01250000E-03  -1.51661000E-03  +1.16306000E-03  -1.58400000E-05  -2.33510000E-04
   +2.99270000E-04  +1.15262000E-03  -2.49530000E-04  +1.60810000E-04  -3.45019000E-03
   +1.81820000E-03  -1.12399000E-03  -2.82375600E-02  -9.44334000E-03  +4.28779500E-02
   -3.23447000E-03  -2.82356000E-03  -3.76073000E-03  -2.51820000E-04  +3.78200000E-05
   +2.65700000E-05  +7.89100000E-05  +1.60100000E-05  +2.23200000E-05  -1.03890300E-01
   -3.72567200E-02  +1.51873520E-01  -2.12000000E-06  +6.65100000E-05  -2.83100000E-05
   -2.34900000E-05  +4.51000000E-06  -5.74100000E-05  +2.53800000E-05  -4.47500000E-05
   -3.69700000E-05  -1.62830000E-04  +1.13720000E-04  +1.55800000E-05  +3.88300000E-05
   +3.37200000E-05  +3.24000000E-05  +2.52100000E-05  +2.66600000E-05  -2.08900000E-05
   +1.86540000E-04  -1.25610000E-04  -6.32000000E-06  +9.79400000E-05  +2.95100000E-05
   +2.07900000E-05  +6.89594000E-03  +3.13052000E-03  +1.78003000E-03  -3.40000000E-05
   +2.25500000E-05  +1.20100000E-05  +7.17000000E-06  -5.37000000E-06  +9.22000000E-06
   -2.00900000E-05  -4.65000000E-06  +1.32000000E-06  -2.82000000E-05  +4.77000000E-06
   +4.32200000E-05  +1.03000000E-06  -1.78400000E-05  -2.85000000E-06  -1.22200000E-05
   -2.78500000E-05  -1.08700000E-05  -3.38900000E-05  -2.16200000E-05  -6.02000000E-05
   +4.07500000E-05  +5.66400000E-05  +1.56000000E-06  -1.80600000E-05  -6.20000000E-06
   +1.08100000E-05  +2.36500000E-05  +3.31900000E-05  -2.52700000E-05  -8.05000000E-06
   -1.46100000E-05  -1.07100000E-05  +1.27970000E-04  +1.45800000E-05  -1.08070000E-04
   +1.34390000E-04  -1.92330000E-04  +5.66900000E-05  -3.35070000E-04  +8.96970000E-04
   -9.40500000E-05  -4.70370000E-04  -1.74380000E-04  -9.27400000E-05  +1.30379770E-01
   -9.35610000E-04  +2.07883000E-03  +7.72140000E-04  -2.71380000E-04  +1.42810000E-04
   -5.83840000E-04  +4.22290000E-04  -7.82660000E-04  +8.86050000E-04  -4.86600000E-04
   +1.49015000E-03  -1.71817000E-03  -1.58245200E-02  -7.57868000E-03  +2.89476500E-02
   -3.54107000E-03  -1.67512000E-03  -1.89695000E-03  -5.62200000E-05  -1.30210000E-04
   -1.03510000E-04  +3.20200000E-05  +2.26400000E-05  +9.30000000E-07  -2.94664700E-02
   -1.73095700E-02  +1.66907500E-02  +1.81500000E-05  +6.04200000E-05  +3.30000000E-07
   +2.45000000E-06  -1.19800000E-05  -2.68000000E-05  +1.34000000E-05  -3.23000000E-05
   -1.45200000E-05  -9.21300000E-05  +7.16900000E-05  +5.76000000E-06  +2.57200000E-05
   +1.67000000E-06  +3.02700000E-05  +8.80000000E-07  +7.14000000E-06  +4.84000000E-06
   +1.08070000E-04  -8.94100000E-05  +1.78000000E-06  -3.48700000E-05  -8.89000000E-06
   +2.11000000E-06  +2.89179000E-03  -1.66981000E-03  +6.86430000E-04  -1.02000000E-05
   +2.22300000E-05  +6.10000000E-07  +7.25000000E-06  -7.50000000E-07  +2.79000000E-06
   -1.16600000E-05  +3.10000000E-07  -5.20000000E-06  -2.06300000E-05  +1.64800000E-05
   +1.51400000E-05  +9.47000000E-06  -7.86000000E-06  -1.12200000E-05  +1.76000000E-06
   -2.75400000E-05  -6.00000000E-08  -1.67100000E-05  -4.92000000E-06  -7.26000000E-06
   +2.55200000E-05  +4.37000000E-06  -1.15600000E-05  +4.74000000E-06  -2.54500000E-05
   +1.05400000E-05  +2.39600000E-05  +9.30000000E-06  -3.59000000E-06  -7.96000000E-06
   -3.42000000E-06  -3.98000000E-06  +1.73150000E-04  +1.07300000E-05  -1.03720000E-04
   +2.94520000E-04  +1.00170000E-04  +3.78280000E-04  +7.98590000E-04  -1.02343000E-03
   -1.59690000E-04  +6.96600000E-05  +1.35200000E-05  -1.53400000E-05  +4.58526300E-02
   +2.63295600E-02  +1.10218000E-03  +5.14450000E-04  +2.41100000E-04  -4.44070000E-04
   -1.46470000E-04  -4.46370000E-04  +1.09850000E-04  -4.89600000E-04  +3.59990000E-04
   -1.77180000E-03  -2.74300000E-05  -7.85820000E-04  +1.66121000E-03  +1.85370000E-03
   +2.46823000E-03  -2.79569000E-03  -2.25205000E-03  +2.14625000E-03  +1.46340000E-04
   +8.94200000E-05  -1.88760000E-04  -3.37000000E-05  +9.00000000E-06  -2.67000000E-05
   +1.97426820E-01  +4.54252300E-02  -4.51763330E-01  -1.63100000E-05  -1.20370000E-04
   -2.95800000E-05  +5.29000000E-06  +2.64100000E-05  +2.67200000E-05  -3.67800000E-05
   +4.81800000E-05  +1.25000000E-06  +6.32200000E-05  -6.61400000E-05  -1.93200000E-05
   -9.14000000E-06  -1.48300000E-05  -1.95200000E-05  -1.03800000E-05  +2.66100000E-05
   +2.59700000E-05  -8.91800000E-05  +6.97600000E-05  -5.48000000E-06  -1.74000000E-04
   -9.76400000E-05  +1.01260000E-04  -1.67189000E-03  -1.02012000E-03  -1.25770000E-03
   +1.09200000E-05  -1.44400000E-05  +1.56000000E-06  -1.06500000E-05  +3.38000000E-06
   -2.99000000E-06  +2.25000000E-06  -1.27700000E-05  +5.27000000E-06  +1.64500000E-05
   -1.42200000E-05  -3.12700000E-05  -3.82000000E-06  +4.51000000E-06  +8.23000000E-06
   +5.89000000E-06  +1.70800000E-05  +2.54700000E-05  -8.83000000E-06  +2.04400000E-05
   -1.84000000E-05  -2.63900000E-05  -6.02000000E-05  -7.05800000E-05  +5.93000000E-06
   +1.72300000E-05  +3.21000000E-06  -2.33500000E-05  -2.06500000E-05  -8.70000000E-07
   +1.50800000E-05  -3.00000000E-06  -7.90000000E-06  -2.79300000E-05  +9.54600000E-05
   -1.11500000E-05  -3.38100000E-05  +1.51000000E-06  +7.56700000E-05  -2.13410000E-04
   -1.64970000E-04  +1.71250000E-04  -2.02580000E-04  +7.35000000E-05  +1.04080000E-04
   -1.92967730E-01  -4.37709800E-02  +4.48920220E-01
end_hess

