# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.89221970    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.18751111E+00  -1.91177243E-01  +2.09074444E+00
   006   +1.88845292E+00  +1.49955238E+00  -6.86967824E-02
   006   +3.77827104E+00  +1.72510537E+00  -1.74660255E+00
   006   +6.02512515E+00  +1.17234399E-01  -1.59258201E+00
   006   +6.27184277E+00  -1.65772438E+00  +5.74251590E-01
   006   +4.25334540E+00  -1.58740310E+00  +2.47798481E+00
   006   -5.41260419E-01  +3.05185643E+00  -1.72349650E-01
   006   -5.08847448E-01  +4.91510766E+00  +2.05612280E+00
   008   +8.55685092E+00  -2.43881092E+00  +1.53253132E+00
   006   -2.78933462E+00  +1.23142640E+00  -6.18130863E-02
   006   -2.81857487E+00  -8.80399664E-01  -1.63183741E+00
   006   -4.83618653E+00  -2.54102484E+00  -1.65904914E+00
   006   -6.90088341E+00  -2.12082483E+00  -9.18531175E-02
   006   -6.91007839E+00  -3.38451449E-02  +1.48999641E+00
   006   -4.87192596E+00  +1.61084706E+00  +1.49412741E+00
   008   -8.93452102E+00  -3.68642870E+00  -2.90807094E-02
   006   -7.59784503E-01  +4.59831491E+00  -2.61596080E+00
   008   +5.64759354E+00  -2.58214288E+00  -1.83009018E+00
   001   -8.68905344E+00  -5.04925461E+00  -1.19168406E+00
   001   -4.79688066E+00  -4.17591788E+00  -2.89301705E+00
   001   -1.21311850E+00  -1.25892326E+00  -2.84374796E+00
   001   -4.93770379E+00  +3.21558803E+00  +2.75631291E+00
   001   -8.51595217E+00  +2.81962884E-01  +2.71348781E+00
   001   -2.57078230E+00  +5.57891927E+00  -2.64127387E+00
   001   +7.31143579E-01  +6.01702935E+00  -2.74596586E+00
   001   -6.70568978E-01  +3.39383602E+00  -4.28431719E+00
   001   -5.18933565E-01  +3.95718301E+00  +3.87904223E+00
   001   +1.19268201E+00  +6.07125999E+00  +1.95439442E+00
   001   -2.13415044E+00  +6.17966827E+00  +1.98546692E+00
   001   +3.71071351E+00  +3.11490555E+00  -3.24179186E+00
   001   +7.73331874E+00  +7.59067682E-01  -2.52697858E+00
   001   +4.52057442E+00  -2.67796272E+00  +4.18515260E+00
   001   +6.82774611E-01  -2.35935182E-01  +3.47534829E+00
   001   +9.61775932E+00  -2.91631813E+00  +1.44325570E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +4.00000000E-08  -3.70000000E-07  +3.60000000E-07
   -3.30000000E-07  +5.90000000E-07  +3.00000000E-08
   +4.30000000E-07  -3.50000000E-07  -2.40000000E-07
   -1.60000000E-07  +2.50000000E-06  +1.90000000E-07
   +2.45000000E-06  +1.37000000E-06  +1.50000000E-06
   +2.00000000E-06  +5.10000000E-07  +8.20000000E-07
   -2.90000000E-07  +6.00000000E-08  +5.00000000E-08
   -5.70000000E-07  +2.90000000E-07  +6.80000000E-07
   -3.62000000E-06  -1.50000000E-06  +2.00000000E-06
   -1.90000000E-07  -7.30000000E-07  -3.50000000E-07
   +4.90000000E-07  +4.00000000E-08  -1.70000000E-07
   -1.50000000E-07  -4.70000000E-07  -2.10000000E-07
   -1.78000000E-06  -2.49000000E-06  -7.50000000E-07
   +1.60000000E-07  -5.10000000E-07  -4.90000000E-07
   -1.20000000E-07  -4.00000000E-08  +4.00000000E-08
   +2.38000000E-06  +1.09000000E-06  -6.70000000E-07
   -2.90000000E-07  +2.50000000E-07  -5.30000000E-07
   +2.26000000E-06  -2.20000000E-07  +2.60000000E-07
   +9.40000000E-07  -2.40000000E-07  -6.90000000E-07
   +6.20000000E-07  +7.00000000E-08  -2.50000000E-07
   +1.70000000E-07  +4.00000000E-08  +1.70000000E-07
   -8.70000000E-07  -1.09000000E-06  -6.70000000E-07
   +6.00000000E-08  -9.00000000E-07  -8.30000000E-07
   +8.00000000E-08  -2.10000000E-07  +1.40000000E-07
   -3.60000000E-07  -9.00000000E-08  +3.00000000E-07
   +2.00000000E-08  +3.70000000E-07  +3.70000000E-07
   -5.70000000E-07  -1.90000000E-07  -1.60000000E-07
   -7.50000000E-07  -7.00000000E-08  +2.80000000E-07
   -4.00000000E-08  -2.90000000E-07  +1.20000000E-07
   -2.50000000E-07  +1.50000000E-07  +5.00000000E-07
   -2.80000000E-07  +0.00000000E+00  +2.50000000E-07
   +1.00000000E-08  +3.00000000E-07  -2.30000000E-07
   -1.10000000E-07  -2.10000000E-07  -4.00000000E-07
   -1.38000000E-06  +2.35000000E-06  -1.39000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.15929090E-01  -2.46383060E-01  +3.90341780E-01  -1.23190270E-01  -1.67198560E-01
   +4.96599050E-01  -1.03277360E-01  +2.99626100E-02  -1.03208000E-02  +6.20954900E-01
   +1.14953700E-02  -1.30248090E-01  +7.84777200E-02  -9.09599200E-02  +3.54967920E-01
   +1.57670600E-02  +6.14357400E-02  -1.74625500E-01  -2.04084900E-01  -1.48335720E-01
   +5.47167880E-01  +1.80115000E-02  -2.05350500E-02  +2.13457300E-02  -3.07817330E-01
   +2.74897000E-03  +1.83448160E-01  +5.92278260E-01  -1.88458800E-02  +5.90223000E-03
   +1.62583200E-02  -1.30509700E-02  -9.73656600E-02  +5.09553900E-02  -1.08188340E-01
   +4.31408200E-01  +1.51415100E-02  +2.23095200E-02  -3.00298300E-02  +1.99018210E-01
   +4.07647700E-02  -2.57885490E-01  -2.14166800E-01  -2.38042840E-01  +5.64879670E-01
   -9.69298000E-03  +7.69248000E-03  -9.59039000E-03  -3.55878800E-02  +5.86878000E-03
   +1.67733600E-02  -1.98213240E-01  +8.06343700E-02  -5.74363000E-03  +6.01925940E-01
   +6.60967000E-03  -1.24458500E-02  +8.73840000E-03  +1.22263400E-02  +1.64799700E-02
   -2.22713500E-02  +5.85610000E-02  -1.24784640E-01  +2.78862100E-02  -8.49424000E-03
   +4.62128430E-01  -1.09149500E-02  +6.62237000E-03  -1.49956500E-02  +1.15905600E-02
   -2.40253200E-02  +1.85218900E-02  +1.59290000E-02  +1.09543100E-02  -8.87565200E-02
   -1.34985820E-01  -1.54231690E-01  +3.66515390E-01  -2.88658900E-02  +1.07467700E-02
   +8.64612000E-03  -4.91970000E-03  -7.11221000E-03  +6.88893000E-03  +4.06696000E-03
   -1.50158000E-03  -2.34300600E-02  -6.30657600E-02  +2.19049500E-02  -1.31123600E-02
   +5.83343030E-01  +6.80929000E-03  +1.25432800E-02  -2.55967300E-02  -1.12197300E-02
   -1.34195800E-02  +9.01869000E-03  +2.52352600E-02  -2.19640900E-02  +8.48555000E-03
   -1.46142100E-02  -6.62190200E-02  +6.89399100E-02  -1.08469660E-01  +3.13699490E-01
   +1.70105000E-02  -1.99274000E-02  +2.74450400E-02  +7.75339000E-03  +1.06678900E-02
   -1.75957400E-02  -2.02548600E-02  +1.15107000E-02  +2.17202000E-03  +1.85723600E-02
   +1.33532040E-01  -1.31509760E-01  -2.56908900E-02  -6.80474600E-02  +5.95339700E-01
   -3.77270320E-01  +1.94444150E-01  -2.23152600E-02  +8.44271000E-03  +2.13807900E-02
   -3.04020300E-02  -1.71442700E-02  +5.07352000E-03  +8.41393000E-03  +1.32966300E-02
   -1.12623800E-02  +2.13140700E-02  -1.61686730E-01  +1.82844600E-02  +5.71558700E-02
   +6.46541950E-01  +2.04844620E-01  -2.02863310E-01  +4.90313700E-02  +1.51723200E-02
   -1.59724600E-02  +2.26664000E-02  +7.45258000E-03  -4.76600000E-04  -3.52639000E-03
   -2.03614700E-02  -1.56552000E-03  +1.47367500E-02  +2.03580000E-04  -8.34537500E-02
   +1.89027800E-02  -2.69866980E-01  +4.12841600E-01  -4.44468400E-02  +6.09636800E-02
   -1.19190720E-01  -2.54997100E-02  +1.46808000E-02  +4.02388000E-03  +5.35541000E-03
   -6.99850000E-04  -1.32171000E-03  +1.74537000E-03  +5.40041000E-03  -2.61861700E-02
   +9.30927100E-02  +1.51188000E-03  -1.53451980E-01  -2.58402500E-02  -2.16576480E-01
   +5.68804550E-01  -2.88478000E-03  +5.89728000E-03  -6.40354000E-03  -1.46251870E-01
   +4.36044500E-02  +2.03040000E-04  -1.87251000E-02  +1.38652800E-02  +3.42938000E-03
   +9.19990000E-04  +1.82502000E-03  +4.02058000E-03  -8.12750000E-04  +6.98100000E-05
   +4.35570000E-04  +1.84170000E-03  -1.21688000E-03  +1.93319000E-03  +4.74869120E-01
   +1.80616000E-02  -1.23573000E-02  +2.74235000E-03  +4.45516700E-02  -1.06584650E-01
   +8.47369000E-03  +3.63731000E-03  +7.12687000E-03  -3.52438000E-03  +1.86615000E-03
   +5.71372000E-03  +5.76478000E-03  +9.70280000E-04  -5.98220000E-04  -2.19670000E-04
   -7.97550000E-04  +2.52000000E-06  +3.26309000E-03  -5.78340000E-03  +4.83883840E-01
   -2.18268100E-02  +1.45596300E-02  +2.10674000E-03  -3.83863000E-03  +1.03527900E-02
   -8.37016800E-02  +1.84692300E-02  -1.16018100E-02  +4.74203000E-03  +4.56385000E-03
   +5.85693000E-03  +1.42172000E-03  +1.08006000E-03  +1.06915000E-03  -2.01288000E-03
   +5.81240000E-04  +2.95325000E-03  -3.91875000E-03  -3.41400000E-05  -2.87328000E-03
   +4.82738840E-01  -4.20420000E-04  +1.02600000E-03  -4.88300000E-05  -3.24754000E-03
   +1.95007300E-02  +2.37231800E-02  -2.97351000E-03  +1.96489000E-03  -8.22670000E-04
   -8.46580000E-04  -2.00699000E-03  -1.54651000E-03  -3.24100000E-05  -9.51130000E-04
   +9.91640000E-04  +2.27380000E-04  -1.07170000E-04  +1.74480000E-04  -7.56271800E-02
   +2.77683000E-03  +2.26603000E-03  +5.85268260E-01  +3.28900000E-04  -5.27170000E-04
   +3.52600000E-05  +7.93158000E-03  -1.80584500E-02  -1.69258200E-02  -8.29670000E-04
   -1.09862000E-03  +8.73020000E-04  +5.38590000E-04  +7.75890000E-04  +9.64790000E-04
   +2.30810000E-04  +5.03360000E-04  -5.46770000E-04  -2.27160000E-04  +3.29380000E-04
   -2.64270000E-04  -1.93784000E-03  -1.15246500E-01  -4.92953800E-02  -2.36984000E-03
   +5.29814380E-01  -1.40969000E-03  +5.53520000E-04  +2.55360000E-04  +8.49142000E-03
   -6.90503000E-03  -5.85250000E-04  -2.01019000E-03  +1.96190000E-04  +2.84590000E-04
   +2.30570000E-04  -4.15700000E-04  -2.46200000E-04  -4.16000000E-05  -4.05050000E-04
   +9.48500000E-04  +4.26790000E-04  +1.02170000E-04  -5.04310000E-04  -3.16440000E-03
   -4.44369100E-02  -1.32175710E-01  -5.37553000E-03  -6.49290700E-02  +5.20894380E-01
   -2.23342000E-03  -1.14838000E-03  +5.99277000E-03  +6.48530000E-04  -1.66450000E-04
   -3.28800000E-04  +1.03336000E-03  +8.20980000E-04  -2.49309000E-03  -6.17789000E-03
   +7.59041000E-03  -3.89241000E-03  -2.34778160E-01  +6.61793600E-02  -6.63002900E-02
   -3.91776400E-02  +1.76728500E-02  -1.25108400E-02  +6.06160000E-04  -4.47470000E-04
   +6.95300000E-05  -5.10450000E-04  +8.51900000E-05  -1.45390000E-04  +4.95170060E-01
   +1.35069000E-03  +3.57650000E-04  +6.52740000E-04  +4.33280000E-04  +6.62300000E-05
   -6.84880000E-04  -1.03975000E-03  +2.90391000E-03  +4.61096000E-03  +2.98016200E-02
   -7.73911000E-03  +5.50538000E-03  +7.43939200E-02  -8.42583500E-02  +3.14231100E-02
   +8.16008000E-03  +2.43749000E-03  +3.21653000E-03  -4.49060000E-04  +7.32100000E-05
   -4.96930000E-04  +4.40710000E-04  -1.68260000E-04  +1.97190000E-04  -1.78607710E-01
   +1.12145290E-01  +1.94223000E-03  +2.47426000E-03  -5.43419000E-03  -8.83170000E-04
   +2.18300000E-05  +4.16460000E-04  +1.09585000E-03  -1.85719000E-03  -1.55000000E-03
   -1.97718400E-02  +1.72538000E-03  -1.10964600E-02  -2.71269000E-02  +9.95520000E-03
   -1.16246630E-01  +2.47737100E-02  -9.10930000E-03  +1.21260100E-02  +1.79940000E-04
   -4.60200000E-05  +6.79360000E-04  -4.47580000E-04  +1.98620000E-04  -3.26260000E-04
   -1.28652910E-01  +7.34442300E-02  +4.84621160E-01  -7.41750000E-04  -5.09380000E-04
   -1.05504000E-03  -3.70571800E-02  -1.39643600E-02  +4.13571000E-03  -5.31340000E-04
   +1.32096000E-03  -1.99461000E-03  +2.94350000E-04  +1.67468000E-03  +9.93670000E-04
   +3.01960000E-04  -1.37800000E-04  +6.75630000E-04  +2.67330000E-04  -7.32870000E-04
   +5.43190000E-04  -1.35517720E-01  -4.61977400E-02  +7.32266000E-03  -1.05790000E-04
   -4.94035000E-03  -4.19046000E-03  -1.88560000E-04  +3.36300000E-05  -1.26040000E-04
   +5.57527650E-01  +2.42617000E-03  +1.77630000E-04  +5.12190000E-04  +6.70533000E-03
   +1.43548000E-02  -1.59551000E-03  +1.93034000E-03  -3.04928000E-03  +2.27400000E-04
   -2.26410000E-04  -4.36120000E-04  -6.26710000E-04  -3.52680000E-04  +1.00959000E-03
   -7.11080000E-04  -2.74820000E-04  -1.62340000E-04  +3.34190000E-04  -4.24853500E-02
   -1.15955740E-01  -7.54482000E-03  -1.85465200E-02  -1.77187500E-02  -1.20831000E-03
   +5.16330000E-04  -4.02120000E-04  +2.94990000E-04  +8.84076400E-02  +5.07827650E-01
   -2.26003000E-03  +2.22950000E-04  -4.48820000E-04  +2.34360000E-03  +7.16700000E-04
   -6.41130000E-04  -6.76700000E-05  -5.81840000E-04  +1.71180000E-04  -1.41200000E-05
   -2.56000000E-04  -3.88560000E-04  -5.06100000E-05  -9.96000000E-05  +1.02100000E-04
   +5.05100000E-05  -2.20030000E-04  +4.09400000E-05  +1.03993800E-02  -4.98438000E-03
   -7.88794100E-02  -2.17505900E-02  -1.71863600E-02  +1.01775000E-03  -2.90600000E-05
   +7.76900000E-05  +2.83800000E-05  -1.63803190E-01  +1.83890800E-01  +4.23167700E-01
   -9.70180000E-04  +1.24100000E-04  -7.78380000E-04  -9.01360000E-04  -3.14081000E-03
   -1.34920000E-03  +2.68200000E-04  -4.39740000E-04  -3.72630000E-04  -1.55810000E-04
   +8.30100000E-05  -3.89400000E-04  -2.68100000E-05  -4.00350000E-04  +1.43900000E-04
   +2.64020000E-04  -2.62970000E-04  -1.47450000E-04  -9.08000000E-06  -2.15752500E-02
   -1.66571800E-02  -4.63909000E-03  -3.20890000E-03  +1.23214000E-03  +1.04300000E-05
   +7.39500000E-05  +3.82000000E-05  -1.18213930E-01  +1.21394300E-02  +3.94693400E-02
   +6.34975240E-01  -1.81300000E-05  -1.02000000E-04  +8.49010000E-04  +5.27500000E-05
   -1.07309000E-03  -1.32190000E-04  +1.36400000E-04  -1.32370000E-04  -7.45530000E-04
   +1.75200000E-04  -2.46440000E-04  -6.52300000E-05  -3.22300000E-05  -1.72430000E-04
   +1.00390000E-04  +1.89420000E-04  +1.64230000E-04  -2.61550000E-04  -7.43323000E-03
   -1.82456900E-02  -1.07663200E-02  -2.35231000E-03  -6.49460000E-04  +9.03080000E-04
   -3.92000000E-06  +5.11100000E-05  -9.45400000E-05  -3.80455600E-02  -2.32612270E-01
   -9.76086500E-02  +1.26886950E-01  +5.26761590E-01  -6.03530000E-04  -3.11890000E-04
   -4.75000000E-05  -7.35760000E-04  -5.55530000E-04  +8.29060000E-04  +3.79370000E-04
   -3.65310000E-04  -9.07970000E-04  +4.17600000E-05  -4.56000000E-06  -1.72320000E-04
   +1.90410000E-04  +6.82100000E-05  +5.09920000E-04  +1.94580000E-04  -1.63420000E-04
   -6.77000000E-05  -4.80946000E-03  -1.90670000E-04  +4.37902000E-03  +1.18068000E-03
   +3.26710000E-04  -1.60020000E-04  -1.80480000E-04  +6.99000000E-06  -1.65050000E-04
   -2.54020000E-04  -1.27904400E-01  -1.66424460E-01  -1.96024390E-01  +2.07554830E-01
   +4.15630760E-01  +2.46630000E-04  -5.43800000E-05  +1.52140000E-04  -2.42000000E-06
   -9.41700000E-05  -2.54690000E-04  -3.45350000E-04  +1.55690000E-04  -1.09630000E-04
   +2.15150000E-04  -2.05910000E-04  +8.34100000E-05  +2.03260000E-04  -2.40500000E-05
   -4.84700000E-05  -2.01590000E-04  +1.93670000E-04  +1.81060000E-04  +3.66292000E-03
   +6.87500000E-04  +1.96735000E-03  +3.75230000E-04  +4.05710000E-04  +4.26380000E-04
   -2.04970000E-04  +9.52000000E-05  -4.51200000E-05  +3.09967400E-02  -5.29452400E-02
   -5.54140700E-02  -2.52068320E-01  -1.02101950E-01  +3.99542900E-02  +5.85766560E-01
   +1.51820000E-04  +8.18900000E-05  +3.70000000E-05  +7.51430000E-04  -1.07730000E-04
   +2.28000000E-06  -1.92210000E-04  +4.29500000E-04  +3.87160000E-04  -1.16850000E-04
   -1.08040000E-04  +1.21420000E-04  -2.31850000E-04  +9.02500000E-05  -1.82950000E-04
   -1.11350000E-04  +2.12490000E-04  +9.77700000E-05  +9.16930000E-04  -1.92790000E-04
   -5.64114000E-03  -1.22638000E-03  -6.62230000E-04  +3.20540000E-04  +1.49980000E-04
   -4.30900000E-05  +5.06400000E-05  -1.36292700E-02  -3.55465400E-02  -2.46665800E-02
   -1.53423720E-01  -2.01309210E-01  -1.29260200E-02  +1.43034990E-01  +5.71198970E-01
   -9.75700000E-05  +1.34770000E-04  -1.42780000E-04  +6.56750000E-04  +2.39610000E-04
   -2.66700000E-05  +1.07280000E-04  -4.32900000E-05  +2.42860000E-04  -1.50950000E-04
   +9.49300000E-05  -2.52000000E-05  -1.92780000E-04  +2.95600000E-05  -3.89600000E-05
   +1.70510000E-04  -1.48100000E-04  -8.33900000E-05  +1.89532000E-03  -4.39405000E-03
   +2.15450000E-04  -5.28750000E-04  -5.06100000E-04  +1.05980000E-04  +1.78380000E-04
   -8.82100000E-05  +6.77200000E-05  -2.38726900E-02  -9.93780000E-04  +2.29591100E-02
   +1.09180000E-03  -4.38121100E-02  -9.39173100E-02  -1.69969900E-01  +2.44792340E-01
   +4.11697350E-01  +3.83000000E-05  -2.75200000E-05  +2.03640000E-04  -3.46200000E-04
   +4.43480000E-04  +2.25630000E-04  +4.21640000E-04  -2.40260000E-04  -3.83700000E-05
   -2.05960000E-04  +1.03150000E-04  +1.37840000E-04  -7.20560000E-04  +3.39250000E-04
   -1.45020000E-04  +1.79550000E-04  +5.04200000E-05  -1.35530000E-04  -2.24903000E-03
   -3.63330000E-04  +1.42460000E-04  +4.15560000E-04  -2.06270000E-04  -2.70820000E-04
   +6.32670000E-04  -2.92800000E-04  +1.31240000E-04  -1.53322400E-02  +2.65358100E-02
   +2.66553900E-02  -5.03409100E-02  -3.86834900E-02  +2.43071000E-03  -2.26191470E-01
   +4.77693200E-02  +1.30492960E-01  +6.00424660E-01  +1.98170000E-04  -6.01200000E-05
   +1.54900000E-04  -2.46010000E-04  +1.05737000E-03  -1.15400000E-04  +2.00630000E-04
   -3.55000000E-05  +5.08600000E-05  -1.66230000E-04  -9.58100000E-05  +3.09780000E-04
   -6.05840000E-04  +5.70140000E-04  -3.75300000E-04  -4.98500000E-05  +1.24750000E-04
   +1.29470000E-04  +2.33940000E-04  -1.02253000E-03  -1.00554000E-03  +2.39050000E-04
   +6.89000000E-05  -5.72000000E-06  +5.64940000E-04  -3.14130000E-04  +1.63480000E-04
   +2.58781100E-02  -2.88084900E-02  -3.26844100E-02  +5.04098000E-03  +4.82772200E-02
   +3.17421400E-02  -1.43692600E-02  -1.26515900E-01  -3.37682900E-02  +1.29091410E-01
   +5.66968720E-01  +1.72440000E-04  +3.14700000E-05  +9.73300000E-05  +8.83600000E-05
   +3.10110000E-04  -2.08360000E-04  -1.96130000E-04  +1.28580000E-04  +6.74300000E-05
   +4.90500000E-05  -1.27390000E-04  +1.98120000E-04  -7.11500000E-05  +2.18120000E-04
   -1.92040000E-04  -1.53620000E-04  +1.27900000E-04  +1.38180000E-04  +9.31130000E-04
   -3.24640000E-04  -1.28000000E-03  +2.23800000E-05  -4.89800000E-05  +2.94510000E-04
   +7.07600000E-05  -5.91000000E-05  +3.01300000E-05  +2.55807700E-02  -3.30332800E-02
   -4.67579000E-02  +3.57810300E-02  +5.74846700E-02  +2.48130100E-02  +8.46758200E-02
   -7.15461400E-02  -1.74038430E-01  -1.68529510E-01  +2.24584520E-01  +4.35080030E-01
   -1.30730000E-04  -5.26000000E-05  +1.33760000E-04  -3.33100000E-05  -6.56650000E-04
   +2.44570000E-04  +1.43000000E-06  -3.22100000E-05  -1.63980000E-04  +6.78100000E-05
   +1.09000000E-04  -9.18100000E-05  +1.81650000E-04  -1.87780000E-04  +2.38970000E-04
   +1.04630000E-04  -2.63900000E-05  -1.88770000E-04  +1.64700000E-04  +1.10951000E-03
   +4.11550000E-03  +2.85010000E-04  +6.33250000E-04  +1.43230000E-04  -1.50670000E-04
   +7.86100000E-05  -8.99200000E-05  -4.59273200E-02  +2.88384000E-03  +3.47231600E-02
   -1.59292000E-02  -2.70003700E-02  -1.29121900E-02  +3.03322700E-02  +2.63576300E-02
   +6.53258000E-03  -1.20106530E-01  +2.92777400E-02  +5.19937800E-02  +6.35834130E-01
   -4.05420000E-04  -3.79200000E-05  +4.62600000E-05  -2.69010000E-04  -9.57510000E-04
   +2.12700000E-04  +1.98000000E-06  -3.04100000E-05  -1.96250000E-04  +5.92900000E-05
   +1.54590000E-04  -2.62210000E-04  +2.52420000E-04  -4.23730000E-04  +4.12550000E-04
   +2.07340000E-04  -1.26230000E-04  -2.26790000E-04  +1.79870000E-04  +2.28757000E-03
   -2.65967000E-03  -4.60120000E-04  -5.65120000E-04  -2.91000000E-06  -2.72430000E-04
   +1.84330000E-04  -1.25770000E-04  -3.58383800E-02  +4.33269200E-02  +4.79109200E-02
   -2.47202000E-02  -5.27483100E-02  -2.30815800E-02  +6.14787400E-02  +1.34999200E-02
   -3.37484800E-02  -2.87795200E-02  -2.30985810E-01  -1.02512760E-01  +1.34947640E-01
   +5.31343880E-01  +1.02160000E-04  +7.09900000E-05  -2.24750000E-04  +9.83110000E-04
   +8.51810000E-04  -2.44930000E-04  +1.74480000E-04  -2.38640000E-04  +1.32940000E-04
   -3.48700000E-05  -5.80100000E-05  -2.01940000E-04  +8.79700000E-05  -8.34400000E-05
   -1.55800000E-05  -2.80000000E-07  -4.66800000E-05  +2.03500000E-05  +4.34064000E-03
   -3.97876000E-03  +1.82254000E-03  -6.57130000E-04  -6.49930000E-04  -1.48050000E-04
   -7.93700000E-05  +4.52300000E-05  +1.95400000E-05  +5.37637000E-03  +2.55004100E-02
   +2.26657200E-02  -1.10122000E-02  -2.11542100E-02  -1.28796800E-02  +3.32465700E-02
   -1.23570900E-02  -2.08584500E-02  +8.01975000E-03  -1.38305330E-01  -1.80714750E-01
   -2.06986380E-01  +2.21426840E-01  +4.23798850E-01  +4.79860000E-04  +3.20200000E-05
   +4.39780000E-04  -1.41533000E-03  -1.88817000E-03  +4.63460000E-04  -5.96140000E-04
   +7.94680000E-04  -8.71000000E-06  +9.53500000E-05  -1.45080000E-04  +3.93500000E-04
   -1.41000000E-04  +3.79200000E-05  -2.79410000E-04  -1.54320000E-04  +2.62810000E-04
   +1.03790000E-04  -1.90564100E-02  -7.50890000E-04  +1.14283400E-02  -1.57552000E-03
   -4.75110000E-04  +1.28189000E-03  +1.07910000E-04  -2.34800000E-05  +3.02800000E-05
   -2.39333550E-01  -1.79162200E-02  +9.22303200E-02  +2.99712000E-02  +6.74275400E-02
   +3.90261000E-02  -6.20170100E-02  -1.84987000E-02  +2.13295500E-02  +3.60130600E-02
   -5.68274700E-02  -6.36983100E-02  -2.51442830E-01  -9.81528500E-02  +4.18785300E-02
   +5.77757430E-01  +1.75350000E-04  +1.98100000E-05  +1.57790000E-04  -1.28040000E-03
   -3.04938000E-03  +7.93710000E-04  -8.14240000E-04  +8.37600000E-04  -8.46300000E-05
   +1.27130000E-04  -9.96600000E-05  +2.97510000E-04  +1.38520000E-04  -1.23950000E-04
   -7.22900000E-05  -1.74580000E-04  +2.33610000E-04  -5.81200000E-05  -1.59543600E-02
   +7.23833000E-03  +1.21876100E-02  -1.06953000E-03  -3.93080000E-04  +8.45870000E-04
   -8.28900000E-05  +7.60100000E-05  -4.00900000E-05  +3.28570200E-02  -1.17412130E-01
   -5.72518600E-02  +2.82101800E-02  +1.06767000E-02  -1.50454400E-02  -1.55741600E-02
   -7.77785000E-03  +6.30567000E-03  -1.33300100E-02  -3.86929500E-02  -2.28648900E-02
   -1.49733460E-01  -1.97648710E-01  -1.21451300E-02  +1.31566500E-01  +5.67530860E-01
   -4.54170000E-04  -1.03270000E-04  -6.43710000E-04  -1.73559000E-03  -1.10724000E-03
   -9.04100000E-05  -7.18900000E-05  +9.58500000E-05  +1.66090000E-04  +4.10900000E-05
   +2.96150000E-04  -9.76200000E-05  +2.03260000E-04  -2.86240000E-04  +2.19650000E-04
   +9.55600000E-05  -2.40650000E-04  +6.14900000E-05  +1.76854000E-03  +3.33211000E-03
   +2.98229000E-03  -6.62770000E-04  +7.15130000E-04  +1.25050000E-04  -2.25710000E-04
   +1.28670000E-04  -3.71400000E-05  +1.30256690E-01  -2.78788100E-02  -1.67646270E-01
   +9.05596000E-03  -3.84736500E-02  -2.60317600E-02  +2.27541100E-02  +7.82401000E-03
   -1.16251600E-02  -3.01028400E-02  +3.14360000E-03  +2.29020400E-02  +3.22216000E-03
   -4.28755200E-02  -9.51744000E-02  -1.66090270E-01  +2.41335930E-01  +4.28372430E-01
   -1.78620000E-04  +2.70400000E-05  -1.26690000E-04  +3.43790000E-04  -1.06151000E-03
   -8.57100000E-05  -4.07340000E-04  +1.78610000E-04  -1.67410000E-04  +2.84040000E-04
   -5.46200000E-05  -2.81970000E-04  +8.36100000E-04  -5.81300000E-04  +3.44600000E-04
   -9.92800000E-05  -5.08200000E-05  +1.98000000E-06  +1.44129000E-03  +7.84880000E-04
   +4.89690000E-04  -5.52000000E-04  +2.65700000E-05  +3.07370000E-04  -7.67080000E-04
   +3.93500000E-04  -1.98920000E-04  -1.75708000E-03  -3.25264000E-03  -3.32239000E-03
   +2.76765000E-03  +4.82195000E-03  +6.39823000E-03  -4.17893100E-02  -3.57323700E-02
   +4.76429000E-03  -2.28369870E-01  -9.39910500E-02  +4.15719000E-02  -5.75990000E-04
   -1.44057200E-02  -5.78839000E-03  -4.46190000E-04  +1.28028000E-03  +4.23961000E-03
   +3.19721880E-01  -1.80820000E-04  +7.09100000E-05  -1.32190000E-04  +3.02990000E-04
   -1.05249000E-03  -5.89300000E-05  -3.50310000E-04  +1.43800000E-04  -1.29570000E-04
   +2.27080000E-04  -4.59300000E-05  -2.84850000E-04  +6.61310000E-04  -5.79040000E-04
   +3.12870000E-04  -5.56700000E-05  -3.66600000E-05  -1.44000000E-05  +1.15122000E-03
   +5.07950000E-04  +1.13628000E-03  -4.45490000E-04  -2.16200000E-05  +2.29230000E-04
   -6.28750000E-04  +3.65600000E-04  -1.69520000E-04  -3.89888000E-03  +8.19380000E-04
   +2.97684000E-03  -1.74364000E-03  -1.10052000E-03  -5.35131000E-03  -6.23160000E-03
   +3.68323000E-03  -6.21090000E-04  -1.32296200E-01  -1.64093550E-01  -9.66653000E-03
   -4.30099200E-02  -3.63828700E-02  -6.76448000E-03  +6.27292000E-03  +2.14293000E-03
   -6.09065000E-03  +1.10325200E-01  +4.99556900E-01  +1.40200000E-05  +5.20000000E-06
   -5.92400000E-05  +1.13500000E-05  -6.24900000E-05  +2.54300000E-05  -8.61000000E-06
   +6.00200000E-05  +7.57300000E-05  -2.60300000E-05  -1.00000000E-07  -1.10100000E-05
   +6.70000000E-06  -2.00700000E-05  -3.34400000E-05  +6.10000000E-06  -1.66700000E-05
   +1.03000000E-06  -3.02810000E-04  +4.03800000E-04  -7.06200000E-05  -6.84000000E-06
   -2.38200000E-05  -3.97800000E-05  -1.59000000E-06  -7.70000000E-07  +2.05900000E-05
   -2.78141000E-03  +3.49751000E-03  +3.03145000E-03  +1.53693000E-03  -9.23130000E-03
   -5.58910000E-04  +2.65399500E-02  +1.72206300E-02  +6.54857000E-03  +1.31668800E-02
   -3.26641400E-02  -7.63541600E-02  -2.74198200E-02  -2.44560600E-02  +5.89722000E-03
   +8.23212000E-03  -2.98484000E-03  -2.07473000E-03  -9.48332700E-02  +2.85235310E-01
   +2.96863380E-01  -5.00093000E-03  +2.52881000E-03  +1.37968000E-03  -3.26483000E-03
   +1.70680500E-02  -2.62733100E-02  -2.33129000E-03  +1.13633000E-03  -1.00263000E-03
   +6.48500000E-04  +5.09800000E-05  -7.43660000E-04  +4.18750000E-04  -2.48610000E-04
   -1.31440000E-04  +2.12260000E-04  +8.82140000E-04  -1.37034000E-03  -7.63788400E-02
   +2.33342000E-03  -3.03413000E-03  +5.34380000E-04  -2.49550000E-04  -2.73710000E-04
   -4.41290000E-04  +2.27390000E-04  -3.80700000E-05  -1.64591000E-03  -1.58566200E-02
   +2.26869800E-02  -3.98130000E-04  -5.34140000E-04  +8.83880000E-04  -4.23140000E-04
   +6.52280000E-04  -8.47000000E-06  +6.08860000E-04  +7.59300000E-04  +2.97170000E-04
   -1.14197000E-03  -3.72000000E-05  -1.24588000E-03  -4.63510000E-04  -1.78983000E-03
   -4.79150000E-04  -1.17049000E-03  -1.06815000E-03  -5.45400000E-05  +5.85057200E-01
   +2.93137000E-03  -1.75010000E-04  -3.05260000E-04  +6.52060000E-03  -1.26843400E-02
   +1.68552300E-02  +1.30470000E-04  -8.72400000E-04  -1.74060000E-04  -4.28510000E-04
   -4.50220000E-04  +7.23790000E-04  +1.06100000E-05  +1.00570000E-04  +2.82100000E-05
   -2.08250000E-04  -3.35630000E-04  +7.05470000E-04  +6.26630000E-03  -1.02876410E-01
   +4.66398200E-02  -9.14350000E-04  +1.03787500E-02  -1.76052600E-02  +7.26400000E-05
   -5.43300000E-05  -2.46700000E-05  -6.68652000E-03  -1.83678900E-02  +1.99996800E-02
   -5.21580000E-04  -2.48570000E-04  +1.20419000E-03  -1.37520000E-04  +7.67710000E-04
   -1.98320000E-04  +1.84050000E-04  +6.75170000E-04  +4.46500000E-04  -6.81140000E-04
   -3.71230000E-04  -1.01324000E-03  +1.52924000E-03  -9.86180000E-04  -5.12080000E-04
   -6.05600000E-04  -6.19980000E-04  -6.75600000E-05  +5.12960000E-03  +5.49594220E-01
   +1.23398000E-03  -8.93220000E-04  +3.57120000E-04  -5.13401000E-03  +3.29964000E-03
   -1.71511000E-03  +1.47236000E-03  -8.40610000E-04  -1.08960000E-04  +1.35390000E-04
   +1.62010000E-04  +1.41000000E-06  -5.53400000E-05  +2.11530000E-04  -2.03350000E-04
   +9.26300000E-05  -1.61000000E-04  +3.57600000E-04  -8.25422000E-03  +4.33292100E-02
   -1.46329760E-01  -1.95158000E-03  +1.08642800E-02  -3.68631200E-02  +9.64900000E-05
   -9.21000000E-05  +7.87300000E-05  +7.45389000E-03  +9.11483000E-03  -3.91978000E-03
   -1.43551000E-03  -1.37505000E-03  -3.10170000E-04  +2.37060000E-04  -5.42600000E-05
   -1.42890000E-04  +1.28310000E-04  +2.66840000E-04  +2.76880000E-04  -5.25500000E-05
   -2.94840000E-04  -6.06600000E-05  -8.78720000E-04  -2.19510000E-04  +2.77900000E-05
   -4.73130000E-04  -4.22800000E-04  -7.57600000E-05  -1.14575500E-02  +5.94174800E-02
   +5.04492000E-01  +1.78780000E-03  -7.62890000E-04  +4.63716000E-03  +3.43091000E-03
   +3.35186000E-03  -2.09963000E-03  +6.11987000E-03  +2.74324000E-02  +1.36927300E-02
   -5.72547400E-02  -4.46960900E-02  +1.25236900E-02  -7.22006900E-02  +3.55469000E-03
   -3.24939600E-02  +6.15178000E-03  +1.65132100E-02  +1.49945100E-02  -2.78150000E-04
   -1.83704000E-03  -1.38016000E-03  +2.25460000E-04  -2.07270000E-04  -5.15300000E-05
   -1.90174200E-02  -1.79943100E-02  -4.14379500E-02  -5.35180000E-04  +3.93450000E-04
   +5.36900000E-05  +1.78920000E-04  +1.51700000E-05  -2.07240000E-04  -1.23670000E-04
   +1.55480000E-04  +1.17300000E-04  +3.74480000E-04  +3.12090000E-04  +2.98100000E-05
   -1.11740000E-04  -1.48170000E-04  -3.97000000E-06  +5.97300000E-05  -6.45600000E-05
   -1.28040000E-04  -4.42560000E-04  -3.40920000E-04  +5.57000000E-06  -1.68700000E-04
   +1.20100000E-05  +4.98100000E-05  +1.27320680E-01  +3.57154000E-03  -3.47023000E-03
   +3.52103000E-03  -9.30540000E-04  +2.39651000E-03  +2.11893000E-03  +6.30405000E-03
   -2.79497000E-02  -7.88705000E-03  -2.66569500E-02  -1.98415710E-01  +9.51029000E-03
   -6.64817000E-03  -5.95836700E-02  -1.00116610E-01  -3.27159000E-03  +6.29686000E-03
   +4.10236000E-03  +5.52250000E-04  +1.38528000E-03  -1.54130000E-04  +5.60070000E-04
   -8.58300000E-05  +6.08610000E-04  -4.69645000E-03  +1.61967100E-02  +1.47971600E-02
   +3.12510000E-04  -1.10590000E-03  +2.36160000E-04  +5.01650000E-04  +2.19800000E-05
   -2.35700000E-04  +9.50800000E-05  -6.31900000E-05  -7.86800000E-05  -3.83820000E-04
   -5.87280000E-04  -2.01490000E-04  +1.46180000E-04  +4.38170000E-04  +1.07000000E-04
   -1.94100000E-05  +2.37050000E-04  +4.24650000E-04  +6.51310000E-04  +6.58470000E-04
   +3.69000000E-05  +3.47080000E-04  -1.27900000E-04  -3.53450000E-04  +4.12855900E-02
   +2.91890440E-01  +4.50500000E-05  +1.82149000E-03  -7.53800000E-05  +2.01097000E-03
   +1.58482000E-03  -4.53052000E-03  -4.11356000E-03  +9.39699000E-03  +6.12519000E-03
   +1.06758300E-02  -5.24402500E-02  -1.28382000E-02  -3.03412400E-02  -3.96891200E-02
   -1.95151690E-01  -1.04020000E-04  -2.08389000E-02  -3.26028000E-02  -5.74610000E-04
   -4.66400000E-05  -3.48300000E-05  +2.04330000E-04  -4.71000000E-05  +8.88000000E-06
   -2.97675900E-02  -4.07964000E-03  -2.75070100E-02  +7.27700000E-05  -2.18370000E-04
   +2.62660000E-04  +4.69150000E-04  -1.37640000E-04  -3.01680000E-04  -5.65000000E-05
   -3.00200000E-05  +4.08300000E-05  -1.34830000E-04  -2.64330000E-04  -1.52260000E-04
   +3.16000000E-05  +2.00870000E-04  +1.26370000E-04  -9.54900000E-05  +2.11100000E-05
   +2.81100000E-04  +2.51360000E-04  +2.66590000E-04  +5.59700000E-05  +2.62420000E-04
   -5.77800000E-05  -1.09050000E-04  +4.65113500E-02  +8.45556100E-02  +2.62147720E-01
   +1.09400000E-05  +1.34300000E-05  +1.38200000E-05  -3.34800000E-05  +1.57300000E-05
   -1.24000000E-06  +3.18600000E-05  +1.46900000E-05  +3.05600000E-05  -4.43900000E-05
   -5.59000000E-06  +2.20200000E-05  -1.39850000E-04  +3.30800000E-05  -4.59900000E-05
   +1.60900000E-05  +2.80100000E-05  -1.36000000E-06  -1.53450000E-04  +4.01400000E-05
   +9.98800000E-05  +6.54500000E-05  +2.55700000E-05  -2.33400000E-05  +1.15560000E-04
   -3.31900000E-05  +2.82700000E-05  -1.42800000E-04  +4.32910000E-04  +4.74850000E-04
   -6.00970000E-04  -1.32030000E-04  -1.58030000E-04  +1.34417000E-03  -1.29783000E-03
   -2.30528000E-03  +7.93450000E-04  -3.27601700E-02  -2.65438200E-02  -4.79839000E-03
   -3.75424000E-03  +1.41230000E-03  +1.51631000E-03  -8.40770000E-04  -4.96480000E-04
   -4.95844100E-02  +6.88207000E-02  +7.90567000E-02  +2.89200000E-05  -1.04000000E-05
   -1.27600000E-05  +7.86300000E-05  -1.53500000E-05  +3.66000000E-06  +5.27419400E-02
   +3.06300000E-05  -8.49000000E-06  +1.03800000E-05  -4.91100000E-05  +1.57750000E-04
   +3.63000000E-06  +5.95000000E-05  -1.47200000E-05  +3.89900000E-05  -4.94700000E-05
   +1.72900000E-05  +5.75700000E-05  -1.40410000E-04  +1.18810000E-04  -5.88000000E-05
   +1.51400000E-05  +6.30000000E-07  -1.25000000E-06  -2.02670000E-04  -9.13000000E-05
   -1.88300000E-05  +7.99600000E-05  -3.11000000E-06  -2.96200000E-05  +1.29690000E-04
   -8.02300000E-05  +3.66700000E-05  -6.78000000E-06  +5.86250000E-04  +4.97200000E-04
   +8.04500000E-05  -1.08621000E-03  -3.97750000E-04  +3.72920000E-03  +3.99175000E-03
   +1.37640000E-03  +3.14641000E-03  -2.74661500E-02  -2.03814500E-02  -4.85598000E-03
   -2.69680000E-04  +1.17421000E-03  +5.71760000E-04  -1.12940000E-04  -1.70689000E-03
   +2.99468000E-02  -3.04820070E-01  -2.42295110E-01  +1.10710000E-04  +5.27100000E-05
   +3.95100000E-05  +7.11900000E-05  -1.29700000E-04  -4.51500000E-05  -3.16893700E-02
   +3.28980450E-01  -5.86000000E-06  +3.94000000E-06  +3.46200000E-05  -1.96700000E-05
   +3.36100000E-05  +2.34900000E-05  +1.87100000E-05  -1.13900000E-05  -2.02900000E-05
   -7.23000000E-06  +7.50000000E-06  +1.24000000E-05  -3.44800000E-05  +1.79300000E-05
   +1.44300000E-05  +3.35000000E-06  +1.60800000E-05  -2.33000000E-06  -1.03390000E-04
   -4.38200000E-05  -1.47720000E-04  +2.44500000E-05  -2.27000000E-06  -1.10500000E-05
   +2.63500000E-05  -6.35000000E-06  -8.70000000E-06  +1.60240000E-04  +9.55500000E-05
   +1.90330000E-04  +1.25200000E-05  -2.30870000E-04  -8.41660000E-04  +1.44831000E-03
   +4.42151000E-03  +1.48722000E-03  +1.41220000E-04  +1.29963000E-03  -1.83579000E-03
   +5.37130000E-04  +4.46820000E-04  +2.13877000E-03  +5.43280000E-04  -8.94540000E-04
   +7.20860000E-04  +5.01667800E-02  -2.65693540E-01  -2.31629180E-01  +1.08990000E-04
   +7.70300000E-05  +4.60200000E-05  +1.66200000E-05  -3.48400000E-05  -3.89400000E-05
   -5.29038200E-02  +2.60877260E-01  +2.30336630E-01  -1.28000000E-05  +1.77800000E-05
   +1.66700000E-05  +1.55790000E-04  -7.64500000E-05  +1.13300000E-05  -5.10300000E-05
   +2.97100000E-05  +9.10000000E-07  +3.36000000E-06  -6.03700000E-05  -5.30400000E-05
   -1.01500000E-05  -9.87200000E-05  -2.61000000E-05  -5.34000000E-06  +3.95400000E-05
   -6.86000000E-06  +5.72820000E-04  -7.28840000E-04  -7.55170000E-04  -3.30020000E-04
   -1.27590000E-04  +1.09790000E-04  -5.06000000E-06  +4.05600000E-05  +6.72000000E-06
   -2.05077000E-03  -4.61610000E-03  +2.35406000E-03  +4.97361000E-03  -1.99296800E-02
   -1.61643700E-02  -5.57517300E-02  +4.30870000E-04  +1.35232200E-02  +3.70223000E-03
   +1.93423800E-02  +1.45789900E-02  -2.74047000E-03  -4.18630000E-04  +4.67548000E-03
   -1.60277000E-03  -3.92820000E-04  +1.21580000E-04  +1.76154000E-03  +2.30477000E-03
   -1.66224000E-03  -1.02800000E-05  +5.24700000E-05  -9.54300000E-05  +2.92300000E-05
   +1.48410000E-04  +9.20000000E-05  -8.72020000E-04  -1.11022000E-03  +2.72400000E-05
   +5.22788000E-02  -5.86000000E-06  +1.71000000E-05  -1.17700000E-05  +2.14230000E-04
   -1.33740000E-04  +3.97000000E-06  -7.07100000E-05  +4.27500000E-05  +3.75000000E-06
   +3.07800000E-05  -3.51100000E-05  -3.36700000E-05  +7.27600000E-05  -7.63800000E-05
   -1.24000000E-06  -1.08200000E-05  +1.49000000E-06  -5.73000000E-06  +3.60300000E-04
   -2.58870000E-04  -8.34620000E-04  -3.22340000E-04  -1.97650000E-04  +1.34600000E-04
   -6.28300000E-05  +4.12900000E-05  -5.23000000E-06  -4.93195000E-03  +1.47748000E-03
   -1.36183000E-03  +2.77140000E-03  -1.23474600E-02  -1.27711300E-02  +2.03890000E-04
   -2.26317230E-01  -1.42810370E-01  -4.86117000E-03  -3.23262000E-03  -2.54551000E-03
   +2.60100000E-05  +2.78793000E-03  -1.98678000E-03  -4.26800000E-05  +8.28800000E-05
   +7.37210000E-04  +1.81405000E-03  +1.52664000E-03  +2.90182000E-03  -6.65100000E-05
   -1.28900000E-05  -5.26100000E-05  -3.23400000E-05  +1.06030000E-04  +6.65000000E-05
   +1.11224000E-03  +7.63200000E-05  -1.02690000E-03  +2.55803000E-03  +2.37748880E-01
   -1.54600000E-05  -2.22000000E-06  +2.71200000E-05  -5.43900000E-05  -5.39300000E-05
   +4.01200000E-05  -8.50000000E-07  -9.79000000E-06  -5.97600000E-05  +1.19100000E-05
   -8.92000000E-06  -4.03800000E-05  +1.38000000E-05  -7.56800000E-05  +3.64800000E-05
   -5.18000000E-06  +3.84400000E-05  -2.40000000E-06  +3.38400000E-04  -9.36300000E-05
   +1.58350000E-04  -2.43800000E-05  +6.01500000E-05  +1.68100000E-05  -3.28800000E-05
   +3.99200000E-05  -2.06800000E-05  +1.90565000E-03  -1.93909000E-03  +4.87708000E-03
   +6.33100000E-04  +9.92300000E-04  +3.00571000E-03  +1.31927000E-02  -1.42657750E-01
   -1.47314430E-01  -3.10672000E-03  -1.72294600E-02  -6.72653000E-03  +5.05560000E-03
   -1.70077000E-03  +1.12933000E-03  +3.03430000E-04  +9.47500000E-04  -3.56540000E-04
   -2.16505000E-03  +2.52023000E-03  -7.12840000E-04  -3.76100000E-05  -1.90000000E-06
   -4.83400000E-05  -2.48000000E-06  +7.68000000E-05  +1.87800000E-05  +1.67076000E-03
   +3.31630000E-04  -1.95440000E-04  -1.55409000E-02  +1.57245420E-01  +1.49174770E-01
   -1.24550000E-04  -1.05750000E-04  -1.85980000E-04  -6.18720000E-04  -9.95850000E-04
   -7.00620000E-04  -4.46140000E-04  -1.40700000E-04  -7.18600000E-05  -2.34700000E-04
   -1.53620000E-04  -1.28560000E-04  -2.14630000E-04  -4.97000000E-05  -6.95300000E-05
   +1.45850000E-04  -4.30400000E-05  +6.94100000E-05  -8.83290000E-04  +2.88510000E-04
   -1.01456000E-03  -9.04400000E-05  +1.14660000E-04  -1.04970000E-04  +1.62180000E-04
   -3.68500000E-05  +7.72400000E-05  +3.54390000E-03  -3.37760000E-04  +2.27800000E-05
   -2.26706570E-01  +3.63910700E-02  +1.36323440E-01  -1.42956700E-02  +5.73217000E-03
   +1.52243600E-02  -1.32010000E-04  -4.95562000E-03  +9.76840000E-04  -4.70300000E-05
   -2.34610000E-04  -8.58930000E-04  +2.21691000E-03  -1.46167000E-03  +1.24026000E-03
   -1.31898000E-03  +6.81000000E-06  +6.92920000E-04  -8.53000000E-06  +3.76200000E-05
   +1.22220000E-04  +2.47880000E-04  +6.71300000E-05  +1.38250000E-04  +7.69800000E-05
   +2.12340000E-04  +1.07680000E-04  -6.40700000E-05  +1.05166000E-03  -1.72772000E-03
   +2.38450940E-01  -7.20900000E-05  +1.83350000E-04  -3.44200000E-04  -3.38750000E-04
   -6.84800000E-05  -4.73450000E-04  -1.69820000E-04  -1.86200000E-05  +2.82100000E-04
   -1.78270000E-04  +3.15000000E-04  +1.21960000E-04  -1.03270000E-04  +2.31500000E-04
   +1.90390000E-04  +1.32040000E-04  -2.34490000E-04  +5.82600000E-05  +1.49986000E-03
   -4.26760000E-04  +1.21278000E-03  +7.99600000E-05  +9.85600000E-05  +4.05100000E-05
   +6.88800000E-05  -1.25340000E-04  -1.41000000E-06  +2.05180700E-02  +1.22466000E-03
   -1.44189000E-02  +3.66734500E-02  -6.48383800E-02  -3.99027700E-02  -1.70078900E-02
   +7.28117000E-03  +1.24356600E-02  -4.72437000E-03  -1.46330000E-04  -3.11853000E-03
   -3.50240000E-04  -1.08326000E-03  +2.71830000E-04  -1.84110000E-03  -2.23644000E-03
   -5.41919000E-03  -1.03937000E-03  +3.21900000E-05  +7.21610000E-04  -1.44660000E-04
   -4.93430000E-04  -3.54430000E-04  -7.36800000E-05  -3.85350000E-04  -2.37670000E-04
   +6.44400000E-05  +1.39260000E-04  +8.46100000E-05  +1.46112000E-03  -6.49560000E-04
   +1.96371000E-03  -3.55893900E-02  +6.17255700E-02  +5.82700000E-05  +7.76000000E-05
   -2.68580000E-04  -2.59250000E-04  -5.02320000E-04  -1.68700000E-04  -8.31700000E-05
   +4.56850000E-04  +3.55890000E-04  -1.98270000E-04  -1.44500000E-05  +1.98090000E-04
   -2.72850000E-04  +1.61050000E-04  -3.14850000E-04  -7.68800000E-05  +1.48320000E-04
   +5.74200000E-05  -1.15680000E-04  +1.88725000E-03  -1.71427000E-03  -2.71310000E-04
   +6.29000000E-06  -3.93600000E-05  +2.28390000E-04  -9.28700000E-05  +1.02190000E-04
   +1.55600700E-02  -2.52830000E-03  -6.52820000E-03  +1.35089480E-01  -3.88539200E-02
   -1.47516090E-01  -1.18543000E-03  -1.12828000E-03  +3.98540000E-03  +1.30762000E-03
   -2.89470000E-03  +5.15004000E-03  -1.04160000E-03  +1.75780000E-04  -4.65520000E-04
   +1.29008000E-03  -5.83359000E-03  +1.50212000E-03  +8.08600000E-05  +1.33530000E-04
   -1.89000000E-05  +3.23800000E-05  +7.55600000E-05  +4.07200000E-05  +2.26760000E-04
   -1.71820000E-04  -3.85700000E-05  -2.98700000E-05  -1.97900000E-05  -2.96100000E-05
   -1.57565000E-03  +2.22134000E-03  -2.00653000E-03  -1.49530400E-01  +4.63107800E-02
   +1.48646680E-01  -5.03200000E-05  -9.53300000E-05  +1.06950000E-04  -1.86330000E-04
   -7.22900000E-05  -1.89060000E-04  +5.95200000E-05  -6.13200000E-05  -6.38100000E-05
   +2.03900000E-05  +8.26300000E-05  +6.74000000E-05  -4.27900000E-05  +8.03000000E-05
   +4.39200000E-05  +2.03300000E-05  -1.15900000E-05  -5.57100000E-05  +3.54910000E-04
   +1.32653000E-03  -1.37857000E-03  -8.99240000E-04  -2.05390000E-04  +5.90470000E-04
   +5.35800000E-05  -4.31800000E-05  -7.33000000E-06  +5.31412000E-03  +1.93632800E-02
   +1.41031000E-02  -2.83334000E-03  -5.94320000E-04  +5.28308000E-03  -1.32547000E-03
   -2.39260000E-04  -3.60400000E-05  -1.74555000E-03  -4.52446000E-03  +2.56737000E-03
   +4.29039000E-03  -2.03771400E-02  -1.55386900E-02  -5.56073100E-02  +3.45207000E-03
   +1.24678500E-02  +1.75150000E-04  -1.00154000E-03  -8.40130000E-04  +2.61850000E-04
   -2.62000000E-05  -7.99900000E-05  -2.82000000E-06  -9.33700000E-05  -7.07300000E-05
   -3.10190000E-04  -2.17010000E-04  -9.92700000E-05  -7.67600000E-05  +1.99290000E-04
   -2.55090000E-04  +1.56710000E-04  +1.10834000E-03  +8.19000000E-04  +5.38671900E-02
   +1.18450000E-04  +3.75900000E-05  -1.20190000E-04  +2.00240000E-04  +3.99540000E-04
   -2.55630000E-04  +9.87100000E-05  -9.16600000E-05  +8.42900000E-05  -1.42300000E-05
   -5.80000000E-06  -5.95000000E-06  -1.99600000E-05  +5.02700000E-05  -9.26900000E-05
   -3.81800000E-05  -1.72500000E-05  +7.36800000E-05  +5.65160000E-04  -1.87422000E-03
   +1.18935000E-03  -1.88981000E-03  -3.58170000E-04  +2.28000000E-04  +2.77000000E-05
   -2.17300000E-05  +3.85900000E-05  -1.91810000E-04  -6.62600000E-05  -3.28956000E-03
   -4.89690000E-04  +2.92953000E-03  -2.57118000E-03  -1.13320000E-04  +2.24300000E-05
   +9.22620000E-04  -4.62987000E-03  +1.90185000E-03  -1.87581000E-03  +2.03082000E-03
   -1.17168200E-02  -1.30929800E-02  +3.56683000E-03  -2.27035860E-01  -1.45166940E-01
   -6.03100000E-05  -9.68000000E-04  -7.36230000E-04  -3.10310000E-04  -1.87240000E-04
   +4.41700000E-05  +1.99600000E-05  -3.70300000E-05  +2.19100000E-05  -1.37440000E-04
   -1.94020000E-04  +7.53700000E-05  +1.65740000E-04  -2.80090000E-04  +2.49960000E-04
   -1.25120000E-04  -1.19700000E-04  -3.24600000E-05  +1.56596000E-03  +2.39461300E-01
   -5.29600000E-05  +1.27900000E-05  +6.50600000E-05  -2.58540000E-04  -2.29290000E-04
   +1.82940000E-04  -7.44600000E-05  +9.73800000E-05  -1.97100000E-05  +9.40000000E-07
   -3.11700000E-05  -1.96900000E-05  -2.37700000E-05  -6.42600000E-05  +2.40500000E-05
   +2.07800000E-05  +2.89600000E-05  -2.06700000E-05  -2.12995000E-03  +5.82670000E-04
   -2.02888000E-03  -6.05110000E-04  -8.59520000E-04  +4.52590000E-04  +3.10000000E-07
   +2.35600000E-05  -1.19800000E-05  -9.13310000E-04  -1.53325100E-02  -6.77758000E-03
   +5.35097000E-03  -2.27177000E-03  +1.63731000E-03  +1.97300000E-05  +9.83740000E-04
   -3.61530000E-04  +2.48754000E-03  -1.91874000E-03  +5.05933000E-03  +1.40772000E-03
   +5.34380000E-04  +3.57932000E-03  +1.27884400E-02  -1.45457540E-01  -1.57706520E-01
   -1.26160000E-04  -1.63130000E-04  -4.40000000E-06  +6.82870000E-04  +2.34130000E-04
   +2.34000000E-06  +1.89000000E-05  +7.18400000E-05  +1.92900000E-05  -3.74700000E-05
   +1.27610000E-04  -7.64900000E-05  -2.78770000E-04  +2.17010000E-04  -3.99390000E-04
   -1.00570000E-04  -7.97250000E-04  -4.97420000E-04  -1.54646700E-02  +1.61089990E-01
   +1.58708480E-01  -4.48400000E-05  +4.95000000E-06  +2.99100000E-05  +7.76000000E-06
   -2.62730000E-04  +6.71300000E-05  -8.15200000E-05  +7.88300000E-05  -3.78600000E-05
   +2.56800000E-05  -1.37900000E-05  +1.48000000E-06  +5.75600000E-05  -4.11000000E-05
   +3.62100000E-05  -1.25600000E-05  +1.60200000E-05  -1.69600000E-05  -2.32510000E-04
   +5.83980000E-04  +7.16010000E-04  -2.43000000E-05  +8.97000000E-05  +4.48900000E-05
   -5.19800000E-05  +3.10700000E-05  -2.41900000E-05  -5.94950000E-04  -5.09762000E-03
   +9.89230000E-04  +1.08500000E-05  -2.13300000E-04  -8.26030000E-04  +2.03676000E-03
   -1.31762000E-03  +1.22228000E-03  +2.24940000E-03  -2.45270000E-03  +3.02300000E-05
   -2.28553490E-01  +3.13398000E-02  +1.42067490E-01  -1.35953900E-02  +6.11523000E-03
   +1.44625000E-02  +5.44200000E-05  +1.19458000E-03  -1.31333000E-03  -1.81850000E-04
   -8.20400000E-05  -8.75500000E-05  -3.11800000E-05  +5.20700000E-05  +4.12000000E-06
   -8.56100000E-05  +1.55410000E-04  -1.75370000E-04  +1.36270000E-04  -1.91300000E-05
   -1.47980000E-04  -1.69380000E-04  +2.09860000E-04  -1.68040000E-04  -1.75050000E-04
   +1.10788000E-03  -1.81864000E-03  +2.39236210E-01  +1.16000000E-06  -6.65000000E-06
   -1.61600000E-05  -1.61870000E-04  -2.95570000E-04  +4.12400000E-05  -4.65500000E-05
   +5.01000000E-05  +6.20000000E-07  +1.32300000E-05  +1.96700000E-05  +6.49000000E-06
   +1.58100000E-05  -4.35800000E-05  +1.50600000E-05  +5.58000000E-06  +4.85000000E-06
   -6.61000000E-06  -6.37740000E-04  +5.08650000E-04  +3.30590000E-04  +8.04800000E-05
   +6.89300000E-05  +6.46700000E-05  -2.03000000E-05  +1.35000000E-05  -5.45000000E-06
   -4.63948000E-03  -1.08790000E-04  -2.60985000E-03  -5.12220000E-04  -1.34333000E-03
   +7.79100000E-05  -1.74477000E-03  -2.32579000E-03  -4.93334000E-03  +2.10095000E-02
   +1.81788000E-03  -1.55349600E-02  +3.00945800E-02  -6.04297900E-02  -3.76271400E-02
   -1.58929500E-02  +7.18184000E-03  +1.33197100E-02  +9.73630000E-04  +5.37640000E-04
   +2.50101000E-03  -6.31200000E-05  +2.21300000E-05  -5.55800000E-05  -1.14500000E-05
   +5.19000000E-05  +2.64600000E-05  +7.71400000E-05  +1.12960000E-04  +4.62380000E-04
   +1.06218000E-03  -1.98450000E-04  -7.27970000E-04  +1.74030000E-04  -1.41710000E-04
   +3.15200000E-04  +1.55093000E-03  -6.69840000E-04  +1.97740000E-03  -3.13273200E-02
   +5.52143400E-02  -1.11200000E-05  +5.96000000E-06  +2.21200000E-05  +1.09860000E-04
   +9.66300000E-05  -5.62000000E-06  +8.18000000E-06  +1.99000000E-06  +6.28000000E-06
   -1.06400000E-05  -2.08200000E-05  +6.85000000E-06  -2.77600000E-05  +2.86800000E-05
   -1.70000000E-05  -5.30000000E-06  +9.04000000E-06  -5.81000000E-06  -1.99000000E-06
   -1.34020000E-04  +3.12400000E-04  -1.26800000E-05  +4.25600000E-05  -5.64300000E-05
   +2.97200000E-05  -1.10600000E-05  +5.68000000E-06  +1.04518000E-03  -2.44436000E-03
   +4.72233000E-03  -1.09478000E-03  -1.30530000E-04  -4.99980000E-04  +8.48310000E-04
   -5.23495000E-03  +1.17371000E-03  +1.78326600E-02  -1.07404000E-03  -6.44169000E-03
   +1.41221500E-01  -3.84273500E-02  -1.50867580E-01  -2.16093000E-03  -1.70030000E-04
   +3.65201000E-03  -1.51407000E-03  +2.33076000E-03  -8.76010000E-04  -8.50000000E-06
   -6.00600000E-05  -7.18000000E-06  +1.88100000E-05  -2.24200000E-05  -1.36600000E-05
   -2.29320000E-04  +4.19620000E-04  -9.86400000E-05  +6.84440000E-04  -7.23700000E-05
   -5.48620000E-04  -1.65270000E-04  +2.94220000E-04  -3.82750000E-04  -1.48872000E-03
   +2.26161000E-03  -1.88751000E-03  -1.55085650E-01  +4.23939300E-02  +1.51820360E-01
   -3.14400000E-05  -4.42300000E-05  +3.42210000E-04  +6.25330000E-04  -1.04910000E-04
   -1.09600000E-05  -1.34150000E-04  -4.95900000E-05  +2.63520000E-04  +1.80060000E-04
   -8.33000000E-06  -2.97610000E-04  +1.42580000E-04  -1.20870000E-04  +9.17000000E-05
   -1.42000000E-06  +8.15500000E-05  -1.39810000E-04  -2.73338000E-03  +3.67290000E-04
   +7.96170000E-04  -5.71100000E-05  -1.39070000E-04  +4.83050000E-04  -1.76520000E-04
   +1.07620000E-04  -6.34800000E-05  +8.86250000E-04  -1.31777000E-03  +1.09670000E-04
   +2.88960000E-04  +3.37030000E-04  +2.13510000E-04  -2.27240000E-04  -4.27100000E-05
   -1.74800000E-05  +5.87800000E-05  -1.11530000E-04  -1.65710000E-04  +1.30320000E-04
   +1.34700000E-04  -3.72000000E-05  +1.72710000E-04  +1.34610000E-04  +1.40070000E-04
   +4.01200000E-05  +2.15100000E-05  +2.53400000E-05  -2.57907140E-01  +1.13202530E-01
   -1.12597000E-03  -6.41600000E-05  +2.01450000E-04  +1.64200000E-05  -9.34000000E-06
   +1.52000000E-06  -5.25000000E-06  -6.02000000E-06  +1.36000000E-05  -4.60000000E-06
   +1.81900000E-05  -6.24200000E-05  +1.32400000E-05  +2.47400000E-05  +3.93700000E-05
   -2.35000000E-05  +2.26700000E-05  +1.70000000E-05  +4.62000000E-06  +2.77130240E-01
   +1.20250000E-03  -9.44400000E-05  -2.11720000E-04  -7.73640000E-04  -1.18104000E-03
   +3.45161000E-03  -3.58020000E-04  +9.61000000E-05  +4.87960000E-04  -1.40500000E-05
   +2.11470000E-04  -7.61000000E-06  -1.75660000E-04  +1.37840000E-04  +6.31900000E-05
   +1.09200000E-05  -2.59960000E-04  +3.10380000E-04  +1.54892900E-02  -1.06043400E-02
   +2.18070000E-04  -4.72720000E-04  +2.11050000E-04  -1.09295000E-03  +1.46720000E-04
   -8.21800000E-05  +2.71400000E-05  +1.13838000E-03  +6.35660000E-04  -2.59850000E-04
   -9.26700000E-05  -4.08960000E-04  -5.01270000E-04  +1.43450000E-04  +5.18900000E-05
   -5.43400000E-05  -2.33880000E-04  -6.62700000E-05  +1.49520000E-04  -2.12430000E-04
   -9.06100000E-05  +2.86800000E-05  -2.68630000E-04  +1.36870000E-04  +2.99000000E-06
   +1.72070000E-04  +1.70830000E-04  -7.29000000E-06  +1.11335640E-01  -1.06149960E-01
   -4.04760000E-04  +3.21300000E-05  -9.06000000E-05  -9.61600000E-05  -4.71000000E-06
   -3.72500000E-05  -3.08000000E-06  +1.32000000E-05  -1.71000000E-06  +1.29100000E-05
   +2.03600000E-05  +1.44710000E-04  +1.12300000E-04  +3.57400000E-05  -1.25300000E-05
   +7.86700000E-05  +5.53000000E-06  -1.01600000E-05  +3.21000000E-06  -1.23060760E-01
   +1.14189700E-01  -1.50259000E-03  +9.29210000E-04  +3.29780000E-04  +1.07022000E-03
   +2.19868000E-03  -4.86485000E-03  +7.00890000E-04  +2.38800000E-04  -3.08430000E-04
   -8.55600000E-05  -3.07800000E-05  +1.64790000E-04  +7.35200000E-05  -1.29390000E-04
   +4.83500000E-05  +1.26430000E-04  +2.00040000E-04  -4.16790000E-04  -2.47184400E-02
   +1.36715200E-02  -2.02623000E-03  -1.19802000E-03  +8.73170000E-04  +1.29075000E-03
   -3.32400000E-05  +1.41300000E-05  +9.67000000E-06  -8.80780000E-04  -5.00860000E-04
   +6.32810000E-04  +4.11840000E-04  +1.45000000E-04  -2.42900000E-05  -4.25540000E-04
   -4.51900000E-05  +8.38700000E-05  +2.22880000E-04  -5.75600000E-05  -2.30860000E-04
   +1.97090000E-04  +1.47110000E-04  -2.43500000E-05  -1.22070000E-04  -1.00560000E-04
   +2.26020000E-04  -1.78210000E-04  -1.41290000E-04  +8.18000000E-06  +8.39780000E-04
   -1.42005000E-03  -4.62122300E-02  -3.46000000E-05  +1.04600000E-04  +8.80200000E-05
   +1.46400000E-05  +1.75300000E-05  +1.57500000E-05  +9.96000000E-06  -1.43600000E-05
   +2.02000000E-06  +2.00000000E-05  +4.53000000E-06  +5.00100000E-05  +3.22500000E-05
   -2.25500000E-05  -1.16640000E-04  -1.66000000E-06  +9.44000000E-06  +1.11000000E-05
   +3.50170000E-04  -2.94955000E-03  +5.16504300E-02  +1.02510000E-04  -7.71700000E-05
   -5.81100000E-05  -5.00000000E-05  +3.37800000E-05  +3.21890000E-04  -6.53160000E-04
   +8.31210000E-04  +2.61950000E-04  +5.33000000E-05  +1.09100000E-04  -1.76310000E-04
   -1.23240000E-04  +7.70000000E-06  +4.38000000E-05  +4.83900000E-05  -2.13100000E-05
   +4.75200000E-05  +1.57986000E-03  +2.45109000E-03  -3.29930000E-04  +3.08010000E-04
   +2.45790000E-04  -2.27710000E-04  +6.10300000E-05  -9.37000000E-06  +5.91000000E-06
   +5.18460000E-04  -5.41390000E-04  +2.39430000E-04  +2.42650000E-04  +4.55590000E-04
   +4.08440000E-04  -2.99670000E-04  -4.24100000E-05  +6.90400000E-05  +3.17130000E-04
   +1.14860000E-04  -1.28590000E-04  +6.20200000E-05  -1.52000000E-06  -2.21200000E-05
   +5.02230000E-04  -1.58730000E-04  -9.68800000E-05  -2.70630000E-04  -2.22770000E-04
   +9.10000000E-06  -1.87239670E-01  -1.32171400E-01  +9.95402000E-03  +4.31700000E-05
   +8.95000000E-06  -3.09100000E-05  +2.07800000E-05  +4.42400000E-05  +1.19500000E-05
   -2.76500000E-05  -1.47300000E-05  -1.94200000E-05  +6.55000000E-06  -3.87100000E-05
   -1.67000000E-06  -6.01400000E-05  +6.01800000E-05  -2.33500000E-05  -1.50700000E-05
   -4.36000000E-06  +5.76000000E-06  -1.89488500E-02  -2.01907500E-02  +9.63330000E-04
   +2.03039270E-01  +1.69380000E-04  -5.61500000E-05  +1.78780000E-04  -8.67440000E-04
   +4.48930000E-04  -9.97600000E-05  -5.02300000E-05  -3.08560000E-04  +7.16150000E-04
   +2.20150000E-04  +9.77000000E-05  -4.76330000E-04  +6.20300000E-05  -8.44000000E-05
   +2.79500000E-05  -6.46200000E-05  +1.16090000E-04  -5.72400000E-05  -1.27646400E-02
   -1.19098300E-02  -3.54550000E-04  +7.97100000E-05  +4.78900000E-04  -1.37025000E-03
   -1.28110000E-04  +1.13470000E-04  -5.67900000E-05  +3.84550000E-04  -9.58140000E-04
   +3.58002000E-03  -3.25400000E-04  -1.18860000E-04  +3.08260000E-04  +2.54980000E-04
   +1.87460000E-04  -1.26500000E-05  +1.18790000E-04  +5.88100000E-04  +4.16060000E-04
   -5.74310000E-04  -4.69890000E-04  -3.57420000E-04  +6.11690000E-04  -3.67470000E-04
   -2.34610000E-04  -4.53280000E-04  -4.18040000E-04  -5.87700000E-05  -1.31100230E-01
   -1.71245610E-01  +9.21467000E-03  -1.69400000E-05  +2.36780000E-04  -1.02700000E-05
   +2.47900000E-05  +5.27800000E-05  +3.48300000E-05  -1.87100000E-05  -5.12500000E-05
   -1.63100000E-05  -6.95000000E-05  +1.48400000E-04  -1.38290000E-04  +3.27100000E-05
   -1.85000000E-05  +1.44990000E-04  -8.25600000E-05  -8.10000000E-06  -3.94400000E-05
   +1.14104100E-02  +1.16940700E-02  -9.56920000E-04  +1.44559580E-01  +1.84235280E-01
   +3.18700000E-05  -1.01710000E-04  -1.75510000E-04  +4.29680000E-04  -5.09280000E-04
   +5.62500000E-04  -4.29530000E-04  -2.92540000E-04  +4.36580000E-04  -8.90200000E-05
   +6.12300000E-05  -3.12800000E-05  -4.59500000E-05  +2.65000000E-05  +4.33000000E-05
   +1.66600000E-05  -6.44300000E-05  +3.19500000E-05  +2.09085800E-02  +1.81571500E-02
   -2.40569000E-03  +1.04552000E-03  +8.89140000E-04  +1.28899000E-03  +1.71200000E-05
   -1.60200000E-05  -3.61000000E-06  -1.35495000E-03  +2.13890000E-03  -4.11221000E-03
   +8.05200000E-05  -2.89690000E-04  -5.50900000E-05  +6.47370000E-04  -2.45300000E-05
   +8.86600000E-05  -4.33650000E-04  -9.41000000E-05  +1.53260000E-04  +1.59400000E-04
   -1.55150000E-04  +3.04030000E-04  +4.38020000E-04  +6.03960000E-04  +9.15600000E-05
   +4.60470000E-04  +4.22130000E-04  -1.41300000E-05  +9.52206000E-03  +8.03703000E-03
   -4.89527700E-02  +3.30200000E-05  -6.63900000E-05  -2.88700000E-05  -5.46000000E-06
   -4.17100000E-05  -4.56800000E-05  +3.80100000E-05  +3.85800000E-05  +1.90900000E-05
   -2.29330000E-04  +3.10440000E-04  -1.20940000E-04  -2.34400000E-05  +8.14800000E-05
   -1.76940000E-04  +6.29500000E-05  +3.18900000E-05  -9.57000000E-06  +1.84160000E-04
   -2.08700000E-05  -9.85930000E-04  -1.11224900E-02  -1.21353100E-02  +5.16918600E-02
   +1.00300000E-05  -5.58000000E-06  -5.78000000E-05  +4.29350000E-04  -5.01890000E-04
   -6.14220000E-04  -2.30340000E-04  +3.72100000E-04  -4.70920000E-04  -6.89200000E-05
   +3.62800000E-05  +2.17800000E-04  -8.75900000E-05  +4.39200000E-05  -3.90000000E-05
   +4.94000000E-05  -8.14500000E-05  +5.10300000E-05  -1.72740000E-03  -1.61683000E-03
   -1.94227000E-03  -1.12580000E-04  +3.95570000E-04  -5.15270000E-04  +1.18160000E-04
   -7.25600000E-05  +5.49200000E-05  -1.60400000E-05  +6.13570000E-04  +4.49910000E-04
   +9.71000000E-06  -1.42550000E-04  -4.80300000E-05  -2.52930000E-04  -5.95600000E-05
   -4.35100000E-05  +1.04000000E-06  -1.28550000E-04  -6.76100000E-05  +1.10870000E-04
   +8.85900000E-05  +5.12800000E-05  -2.07520000E-04  -5.72600000E-05  +1.01910000E-04
   +4.33200000E-05  +4.58500000E-05  -7.45000000E-06  -4.75787600E-02  +6.44409000E-03
   +9.83619000E-03  +1.06200000E-05  -7.88400000E-05  +2.30300000E-05  -6.53000000E-06
   -2.05900000E-05  +1.02200000E-05  +1.87300000E-05  -1.08600000E-05  +1.85300000E-05
   +1.89550000E-04  -8.17500000E-05  +8.81300000E-05  +3.27400000E-05  +5.51000000E-06
   -7.29800000E-05  -5.50000000E-07  +5.52000000E-06  -7.24000000E-06  -3.67280000E-04
   +1.66133600E-02  +2.36692700E-02  +1.47185000E-03  -1.33125300E-02  -1.97939200E-02
   +4.82313400E-02  -3.24990000E-04  +1.41400000E-05  -1.14220000E-04  -9.02900000E-05
   +6.46220000E-04  -1.47020000E-04  +7.13390000E-04  +2.88010000E-04  -1.54630000E-04
   -3.00700000E-05  -6.19600000E-05  +9.73200000E-05  +1.54100000E-05  -4.77300000E-05
   +6.23300000E-05  +4.06300000E-05  +2.69700000E-05  -4.76500000E-05  -1.32026000E-03
   +1.00281500E-02  +1.43881900E-02  +2.36420000E-04  -1.38424000E-03  +2.58562000E-03
   +1.70000000E-06  -8.09000000E-06  -4.75000000E-06  +2.80920000E-04  +9.85450000E-04
   +2.36430000E-04  -3.59250000E-04  -7.33100000E-05  +5.72110000E-04  +4.83500000E-05
   -1.34580000E-04  -8.42700000E-05  -1.67300000E-05  -8.34800000E-05  -9.30900000E-05
   +7.75100000E-05  +1.13710000E-04  +1.02770000E-04  -1.06970000E-04  -2.55100000E-05
   -9.74000000E-05  +1.43020000E-04  +1.03900000E-04  +3.95000000E-06  +6.25952000E-03
   -1.43427710E-01  -1.29848080E-01  -3.32600000E-05  +4.48300000E-05  +8.99000000E-06
   -1.59300000E-05  -1.51300000E-05  -1.31500000E-05  +1.41000000E-06  +9.06000000E-06
   +1.87100000E-05  +1.06110000E-04  -5.63260000E-04  +1.95580000E-04  +1.11500000E-05
   -8.58000000E-06  +1.47600000E-05  +9.98000000E-06  -2.69000000E-06  +2.40000000E-07
   -7.05840000E-04  -8.88739000E-03  -1.11740200E-02  +2.81123000E-03  -1.20930400E-02
   -1.65752600E-02  -7.97329000E-03  +1.53888330E-01  +1.34620000E-04  +4.61010000E-04
   -5.77500000E-05  +1.19486000E-03  -1.03993000E-03  +7.82520000E-04  -8.77100000E-05
   +1.93880000E-04  +3.70990000E-04  -1.84710000E-04  +4.18400000E-05  +1.56620000E-04
   -1.01110000E-04  -1.08700000E-04  +9.49600000E-05  +1.36890000E-04  -1.28570000E-04
   +5.21500000E-05  +1.47119000E-03  -1.68077300E-02  -2.12330500E-02  -2.28100000E-04
   +4.58258000E-03  -4.52598000E-03  +7.71400000E-05  -2.21300000E-05  +3.05900000E-05
   -1.43269000E-03  -9.14980000E-04  +7.98510000E-04  +1.74010000E-04  -5.52850000E-04
   -2.51900000E-05  +5.86390000E-04  +3.81950000E-04  +1.38440000E-04  -2.67790000E-04
   +4.35880000E-04  +4.35730000E-04  -4.36140000E-04  -4.85890000E-04  -1.28890000E-04
   +8.97660000E-04  +1.26890000E-04  -2.49110000E-04  -7.89800000E-05  -6.00200000E-05
   -2.35800000E-05  +9.92351000E-03  -1.27394880E-01  -2.20118190E-01  +2.73000000E-05
   +6.46400000E-05  +5.93100000E-05  +2.11000000E-05  +1.71800000E-05  -2.70000000E-07
   +3.59000000E-05  +4.85000000E-06  -5.84000000E-06  -2.06510000E-04  +5.26490000E-04
   +3.01000000E-06  -1.40210000E-04  +1.78400000E-05  +7.43900000E-05  -5.88000000E-06
   +1.14400000E-05  -2.13300000E-05  -1.13880000E-04  +1.03668000E-03  +8.69320000E-04
   -2.75040000E-04  +2.28386000E-03  +2.47671000E-03  -1.04853300E-02  +1.38694960E-01
   +2.40888850E-01  -2.43580000E-04  +2.90790000E-04  +2.41320000E-04  +1.77930000E-04
   -4.99590000E-04  +5.51620000E-04  -8.74200000E-05  +9.92200000E-05  -1.33800000E-05
   +6.37500000E-05  -2.71200000E-05  +9.35500000E-05  -6.78400000E-05  +1.15230000E-04
   +4.03200000E-05  -1.90590000E-04  +4.57800000E-05  -1.22900000E-04  -2.00319000E-03
   +1.84300000E-05  -5.77590000E-04  -4.72076700E-02  -4.25180000E-04  +1.45730000E-03
   +6.18500000E-05  -3.56300000E-05  -2.81200000E-05  +2.96000000E-04  +4.39160000E-04
   -5.28850000E-04  -8.48200000E-05  -5.06400000E-05  -4.13900000E-05  +1.11520000E-04
   +9.31200000E-05  +1.94700000E-05  -8.62900000E-05  -1.48600000E-05  +1.57200000E-05
   -1.11960000E-04  +4.25800000E-05  +2.22050000E-04  +1.18770000E-04  -4.19540000E-04
   -4.51900000E-04  +9.26000000E-05  +1.19420000E-04  +2.54400000E-05  -8.12000000E-06
   -2.48680000E-04  -3.41990000E-04  +2.47400000E-05  -7.12400000E-05  -1.17160000E-04
   -7.55000000E-06  -1.19900000E-05  -3.88000000E-06  +1.20200000E-05  +1.14800000E-05
   +1.50900000E-05  -9.18000000E-06  +4.83800000E-05  +3.52800000E-05  -1.06202000E-03
   +1.83670000E-04  -3.71860000E-04  -8.01000000E-06  -4.67000000E-06  -1.88800000E-05
   +3.16620000E-04  -2.19520000E-04  +3.16380000E-04  +1.21950000E-04  +2.93390000E-04
   -2.14850000E-04  +6.42970000E-04  +1.13600000E-04  -1.07500000E-04  +4.72881200E-02
   +6.97940000E-04  -8.24880000E-04  -8.53260000E-04  -3.16220000E-04  +8.34320000E-04
   +4.29630000E-04  +6.55200000E-05  -1.55000000E-05  +7.91100000E-05  -2.94000000E-05
   -2.74300000E-05  -1.35130000E-04  +7.75700000E-05  -1.53800000E-05  +1.08000000E-04
   -1.10320000E-04  -1.08450000E-04  +1.80540000E-04  -4.94700000E-05  +1.10304000E-02
   -1.83311800E-02  -2.30160000E-04  -1.09263010E-01  +1.13662850E-01  -1.04030000E-04
   +4.11300000E-05  -2.27400000E-05  +1.54230000E-04  +1.07408000E-03  +3.98040000E-04
   +2.21130000E-04  -1.50610000E-04  -3.43000000E-06  +1.71350000E-04  +7.89400000E-05
   -5.82900000E-05  -1.43890000E-04  +3.55300000E-05  +1.83950000E-04  -3.45900000E-05
   -1.86740000E-04  -9.19500000E-05  -5.32240000E-04  +2.75150000E-04  +7.59800000E-05
   +8.46900000E-05  +3.72700000E-05  -2.45500000E-05  +9.50700000E-05  -2.59102000E-03
   -2.88156000E-03  -3.77500000E-05  +8.28700000E-05  +6.73100000E-05  -1.09100000E-05
   -1.20600000E-05  -6.37000000E-06  +9.79000000E-06  +2.16600000E-05  -1.21100000E-05
   -1.37400000E-05  +1.72300000E-05  -3.04700000E-05  -2.49830000E-04  -2.13630000E-04
   -1.58980000E-04  -1.29000000E-05  +2.80300000E-05  -2.90400000E-05  -2.18240000E-04
   -4.89100000E-05  -9.82800000E-05  +2.65680000E-04  +4.87900000E-05  -1.48780000E-04
   -9.81500000E-05  +8.06430000E-04  -1.17454000E-03  +1.57380000E-04  +1.18529640E-01
   +4.72400000E-04  +8.26410000E-04  -4.67500000E-04  -1.06333000E-03  +7.41600000E-04
   -5.35000000E-06  +4.28620000E-04  -1.73470000E-04  -2.11300000E-05  -1.93740000E-04
   +2.06470000E-04  -1.10600000E-04  +1.33100000E-05  -2.11050000E-04  -1.80680000E-04
   +5.16800000E-05  -2.34430000E-04  +4.94430000E-04  -6.28000000E-06  +1.27360500E-02
   -2.00567500E-02  +1.40614000E-03  +1.11894610E-01  -2.55302390E-01  -9.93200000E-05
   +6.81000000E-06  +1.04350000E-04  +8.82260000E-04  +1.14355000E-03  +8.74560000E-04
   -5.19200000E-05  -5.22590000E-04  +2.87600000E-05  +2.24800000E-04  +1.70930000E-04
   -2.74000000E-05  -1.32550000E-04  +1.86010000E-04  +1.39160000E-04  -2.79940000E-04
   -1.80700000E-04  +1.78650000E-04  +2.67800000E-04  -2.58290000E-04  +8.28200000E-05
   -4.64000000E-06  -1.51000000E-06  +1.32400000E-05  +3.27410000E-04  -4.85561000E-03
   -3.39309000E-03  -2.28900000E-05  +1.25900000E-05  +1.68810000E-04  -8.24000000E-06
   +6.15000000E-06  -1.00900000E-05  -2.59600000E-05  +1.71100000E-05  -3.60400000E-05
   -3.10200000E-05  +9.46100000E-05  +1.64300000E-05  -4.65900000E-04  +2.23920000E-04
   +7.27000000E-06  -2.13700000E-05  -2.78100000E-05  -4.80000000E-06  -1.03700000E-05
   -3.61600000E-05  +2.71880000E-04  +4.01100000E-05  -7.91300000E-05  +3.82940000E-04
   -1.69010000E-04  +8.00300000E-04  -1.53562000E-03  -1.25090000E-03  -1.22021000E-01
   +2.78216480E-01  +1.42590000E-04  -1.94570000E-04  +1.21410000E-04  +7.47940000E-04
   +1.34542000E-03  +1.65370000E-04  +3.87410000E-04  -8.64600000E-05  +5.70100000E-05
   +5.49000000E-06  -3.48200000E-05  -6.77900000E-05  -6.89900000E-05  +3.95000000E-05
   -4.75800000E-05  -8.12000000E-05  -1.47300000E-05  -3.22700000E-05  -7.14440000E-04
   +9.65610000E-04  +8.85690000E-04  -2.33419100E-01  -1.25278700E-01  +1.24528400E-02
   +5.65900000E-05  -9.78000000E-06  +1.32700000E-05  +5.89820000E-04  +2.89960000E-04
   +3.08840000E-04  +8.96700000E-05  +1.83070000E-04  +2.02010000E-04  -5.51600000E-05
   -6.71200000E-05  -9.44100000E-05  +7.93700000E-05  +8.83500000E-05  -5.28000000E-06
   +1.78410000E-04  -1.71170000E-04  -2.32250000E-04  -2.79790000E-04  +1.42060000E-04
   +3.81630000E-04  -1.39840000E-04  -1.68860000E-04  -3.44400000E-05  -1.57430000E-04
   +1.40350000E-04  +2.20640000E-04  +4.21000000E-05  -5.32200000E-05  -1.03400000E-05
   +1.33700000E-05  +2.00200000E-05  +7.01000000E-06  -2.28400000E-05  -1.03100000E-05
   -1.83700000E-05  +8.28700000E-05  -6.01200000E-05  -3.49400000E-05  +3.05800000E-04
   -1.43120000E-04  -4.36940000E-04  -5.99000000E-06  -2.90000000E-07  +1.68600000E-05
   +2.35000000E-05  -1.15190000E-04  +6.81500000E-05  +2.70820000E-04  +2.09660000E-04
   -5.12880000E-04  +2.50990000E-04  +2.41660000E-04  -5.41200000E-05  +8.37380000E-04
   +1.47065000E-03  -1.87540000E-04  +2.50391820E-01  -1.42970000E-04  -2.31260000E-04
   +3.80620000E-04  -1.64751000E-03  +2.03890000E-04  +4.73420000E-04  +5.02590000E-04
   +3.43280000E-04  +1.32000000E-06  +1.53000000E-04  -1.47500000E-04  -1.96360000E-04
   +7.94300000E-05  -1.94540000E-04  +9.59600000E-05  +1.53390000E-04  +4.55200000E-05
   -4.48700000E-05  -1.72777200E-02  -1.41295100E-02  +9.89880000E-04  -1.23463160E-01
   -1.29080300E-01  +9.74748000E-03  -7.92500000E-05  +1.00750000E-04  -5.75500000E-05
   +1.34932000E-03  -1.83296000E-03  -3.88964000E-03  -1.30322000E-03  -2.24020000E-04
   +2.06910000E-04  -4.70500000E-05  -3.92450000E-04  -7.92600000E-05  +3.27000000E-04
   +9.45300000E-05  -1.23800000E-04  -9.18700000E-05  +1.71630000E-04  +6.61600000E-05
   +6.12470000E-04  +2.25200000E-05  -4.62210000E-04  -2.72180000E-04  -1.89510000E-04
   +2.51300000E-05  +2.92820000E-04  +3.14050000E-04  +1.20062000E-03  -4.64900000E-05
   +2.16300000E-04  +7.69500000E-05  +3.38900000E-05  +4.00100000E-05  +1.61500000E-05
   -8.31400000E-05  -1.24480000E-04  +2.82700000E-05  -6.48000000E-06  +2.80800000E-05
   -8.54900000E-05  +7.24200000E-05  -2.30000000E-07  +3.27350000E-04  -4.17100000E-05
   -1.12400000E-05  -5.98000000E-06  +1.19920000E-04  +5.71500000E-05  -1.28900000E-05
   +1.02540000E-04  +6.21850000E-04  -2.19150000E-04  +2.67530000E-04  +3.27100000E-05
   +7.15400000E-05  -1.23708200E-02  -8.45123000E-03  +2.32200000E-05  +1.35948990E-01
   +1.40445800E-01  +2.23300000E-04  +2.58100000E-05  -2.11400000E-04  -9.86960000E-04
   +2.45320000E-04  +9.36910000E-04  -5.50000000E-06  +2.43360000E-04  +1.22420000E-04
   +1.42660000E-04  -1.52160000E-04  -7.62700000E-05  +7.28700000E-05  -1.32900000E-05
   +2.56400000E-05  -2.25850000E-04  -2.27000000E-06  +4.76900000E-05  -2.08839200E-02
   -1.44275900E-02  -2.31390000E-04  +1.40766100E-02  +1.07927600E-02  -4.81491100E-02
   -1.01560000E-04  +4.88100000E-05  -4.47700000E-05  +1.26843000E-03  -2.49833000E-03
   -3.82406000E-03  -1.34892000E-03  -9.04290000E-04  +3.34560000E-04  +1.84680000E-04
   -2.42580000E-04  -1.91400000E-04  +5.41700000E-05  +1.43500000E-04  +5.25000000E-06
   -1.99320000E-04  -5.33700000E-05  +1.84930000E-04  +8.57320000E-04  -3.07730000E-04
   -3.15080000E-04  -1.09330000E-04  -4.86800000E-05  +2.13800000E-05  -1.12070000E-03
   -8.06370000E-04  +1.20739000E-03  -5.01800000E-05  +1.00330000E-04  -2.06900000E-05
   +1.50700000E-05  +1.79100000E-05  +3.47000000E-06  -1.07030000E-04  -7.58000000E-05
   -2.17700000E-05  -1.70300000E-05  +3.55900000E-05  -1.19000000E-05  -9.49300000E-05
   +5.35360000E-04  +1.28870000E-04  -1.69100000E-05  -3.21600000E-05  +1.46900000E-05
   +5.72000000E-05  -1.58000000E-06  -7.04400000E-05  +2.85970000E-04  +2.94980000E-04
   -6.96750000E-04  +2.70290000E-04  +1.92460000E-04  +2.34740000E-04  +2.44866900E-02
   +1.47515000E-02  -4.89370000E-04  -1.49604500E-02  -6.78346000E-03  +5.20002100E-02
   +3.20200000E-05  -2.17670000E-04  +2.27860000E-04  +2.71740000E-04  +2.62820000E-04
   +7.35740000E-04  +5.37840000E-04  +3.64860000E-04  -1.65690000E-04  +1.08630000E-04
   -9.35300000E-05  -1.03920000E-04  +1.65220000E-04  -1.75300000E-04  +9.48200000E-05
   -1.84000000E-06  +1.39800000E-05  -4.21200000E-05  +2.98190000E-04  -9.05320000E-04
   -1.07590000E-04  -2.15068580E-01  +1.29409520E-01  -9.71892000E-03  -1.51500000E-04
   +1.03590000E-04  -6.21300000E-05  -7.74800000E-05  -4.75000000E-05  +3.40650000E-04
   +9.91000000E-05  +7.41500000E-05  -1.02300000E-05  +6.61900000E-05  +2.86000000E-05
   -2.62300000E-05  -1.94930000E-04  -1.02400000E-05  +1.80800000E-05  +1.39680000E-04
   -1.67500000E-04  -2.20410000E-04  -8.96870000E-04  -9.69840000E-04  +5.51370000E-04
   +1.02630000E-04  +4.14300000E-05  -2.43300000E-05  +3.65710000E-04  -3.39960000E-04
   -4.24060000E-04  -9.32000000E-05  +1.66730000E-04  +7.53000000E-05  -1.75200000E-05
   -1.53400000E-05  -6.01000000E-06  +1.28700000E-05  +2.12200000E-05  -3.52000000E-06
   -1.55500000E-05  -6.39000000E-06  -1.00100000E-05  -6.02880000E-04  -1.63083000E-03
   +4.43700000E-05  +3.05200000E-05  -2.48000000E-06  +2.81700000E-05  +3.41960000E-04
   -1.06760000E-04  +3.12950000E-04  -2.14600000E-04  +1.17020000E-04  +7.40900000E-05
   +1.87510000E-04  -2.32100000E-04  +5.24300000E-05  +7.45500000E-04  -1.84205000E-03
   +2.02320000E-04  -1.96027300E-02  +1.69331000E-02  -1.84009000E-03  +2.33520590E-01
   +1.23300000E-04  -7.55600000E-05  -7.12900000E-05  -1.12875000E-03  -1.48870000E-03
   -3.72464000E-03  +6.22900000E-04  -3.83620000E-04  +2.15950000E-04  +2.46300000E-04
   +3.78330000E-04  +3.63840000E-04  -8.73100000E-05  +3.97440000E-04  -2.95050000E-04
   -9.99900000E-05  +9.40000000E-06  -1.75200000E-05  +1.71149900E-02  -1.32174000E-02
   +1.38369000E-03  +1.28216910E-01  -1.45802040E-01  +7.35079000E-03  +2.36400000E-04
   -1.66400000E-04  +1.21090000E-04  +5.81350000E-04  +6.94590000E-04  +4.41020000E-04
   -2.61850000E-04  -1.42650000E-04  -1.19700000E-04  +1.47190000E-04  +1.84910000E-04
   +3.73300000E-05  -6.63700000E-05  -6.16000000E-06  +8.12000000E-05  -3.58400000E-04
   +2.18150000E-04  +3.25980000E-04  +1.27120000E-04  -6.38090000E-04  -6.80160000E-04
   +8.83800000E-05  +1.51610000E-04  +4.72700000E-05  +8.33900000E-05  +6.16960000E-04
   +1.60626000E-03  -2.07900000E-05  -2.55560000E-04  -1.24640000E-04  -3.70000000E-06
   -1.53900000E-05  -8.40000000E-07  +1.06900000E-05  +2.11000000E-06  +2.00000000E-05
   +3.69600000E-05  +9.38300000E-05  +1.19080000E-04  -1.16468000E-03  -8.22490000E-04
   +7.54530000E-04  -1.03200000E-05  -3.61200000E-05  -7.58000000E-06  -3.34200000E-04
   +5.69220000E-04  -4.39840000E-04  -1.29650000E-04  -2.36900000E-05  -1.29350000E-04
   -3.00720000E-04  -5.07000000E-06  +1.67380000E-04  +1.16668700E-02  -9.19139000E-03
   -1.81280000E-04  -1.46613300E-02  +1.22416200E-02  -1.07028000E-03  -1.40704080E-01
   +1.56811420E-01  +2.42840000E-04  +4.70750000E-04  -1.91180000E-04  -1.37454000E-03
   -2.29268000E-03  -4.24698000E-03  +1.05656000E-03  -6.41050000E-04  +1.71530000E-04
   +6.43500000E-05  +6.67990000E-04  +3.56340000E-04  +1.99700000E-05  +1.64540000E-04
   -4.36720000E-04  +1.06620000E-04  -8.79300000E-05  +2.90750000E-04  +2.08900500E-02
   -1.54324100E-02  -5.53020000E-04  -9.97562000E-03  +8.51714000E-03  -4.75707000E-02
   +1.04110000E-04  -1.40540000E-04  +2.01360000E-04  +6.11400000E-05  +6.40190000E-04
   +5.82720000E-04  +3.30300000E-05  -2.89900000E-05  -2.05900000E-04  +9.90200000E-05
   +6.90800000E-05  -3.02400000E-05  -1.23960000E-04  +4.36100000E-05  +1.39580000E-04
   -6.89800000E-05  -1.72200000E-04  -1.21340000E-04  -3.84510000E-04  +4.57480000E-04
   +3.94070000E-04  +4.06700000E-05  +6.98000000E-06  -2.52500000E-05  +1.18798000E-03
   -7.57150000E-04  +1.17436000E-03  -5.53500000E-05  -2.12550000E-04  +9.44000000E-06
   -5.05000000E-06  -1.20600000E-05  -2.85000000E-06  +1.72200000E-05  -8.06000000E-06
   +6.59000000E-06  +4.75900000E-05  +8.35000000E-06  +3.31700000E-05  +2.19190000E-04
   +1.23250000E-04  +2.09950000E-04  +5.93000000E-06  +5.50000000E-07  +9.63000000E-06
   -5.10660000E-04  -1.42200000E-05  -6.99170000E-04  +7.22300000E-05  +1.18130000E-04
   -5.41000000E-05  -1.54930000E-04  +1.63270000E-04  +3.75350000E-04  -2.33460000E-02
   +1.64153700E-02  -1.66310000E-04  +1.86137000E-03  -1.47232000E-03  -8.67130000E-04
   +1.00565800E-02  -5.96148000E-03  +5.11628600E-02  -1.44424000E-03  +2.30085000E-03
   +6.03909000E-03  +8.15507000E-03  -1.46521000E-02  +1.63203500E-02  -5.60974500E-02
   +1.38238900E-02  -2.00727000E-03  +4.52381000E-03  +1.51839300E-02  -1.59609900E-02
   -8.46780000E-04  +3.82205000E-03  -1.32776000E-03  -2.22129000E-03  +2.58700000E-05
   +8.63800000E-04  -3.23430000E-04  -2.44010000E-03  -1.74832000E-03  +5.34090000E-04
   -1.17970000E-04  -6.69400000E-05  -1.12596000E-03  +7.77040000E-04  -4.94540000E-04
   -3.44190000E-04  +1.90320000E-04  -1.21950000E-04  -6.64000000E-06  +1.06940000E-04
   +1.15090000E-04  -4.24000000E-06  -1.49100000E-05  -4.27000000E-05  -4.31300000E-05
   -5.29600000E-05  -9.61000000E-06  +3.20900000E-05  +2.62400000E-05  +4.12800000E-05
   -5.56800000E-05  -2.91400000E-05  -6.72000000E-05  +6.82600000E-05  +5.63900000E-05
   -5.66000000E-06  -1.89649000E-03  +5.54500000E-04  +6.72390000E-04  -1.20299000E-03
   +3.37670000E-04  -1.02623000E-03  -9.65000000E-06  -1.45200000E-05  +1.96000000E-06
   +6.52000000E-06  +1.77000000E-06  +1.20100000E-05  +9.10700000E-05  -4.15800000E-05
   +9.16000000E-06  -8.45000000E-06  -8.88000000E-06  +4.22000000E-06  +6.65000000E-06
   -7.94000000E-06  +3.29000000E-06  +2.21520000E-04  -1.31800000E-04  -7.15400000E-05
   -8.79970000E-04  +1.27297000E-03  +3.47200000E-05  -1.14575000E-03  +1.28060000E-04
   -4.49360000E-04  +2.29300000E-05  -2.80700000E-05  -1.05140000E-04  +3.54100000E-05
   -3.24700000E-05  +2.28600000E-05  -4.10100000E-05  -1.04760000E-04  -6.71000000E-05
   +5.31621400E-02  +2.36357000E-03  +3.63348000E-03  +4.88837000E-03  +2.76485000E-03
   +4.24446000E-03  +6.76260000E-04  +8.88212000E-03  -1.78018970E-01  +1.53573360E-01
   +1.70783000E-03  -9.11441000E-03  +1.65905100E-02  +3.30621000E-03  +4.45628000E-03
   -5.49477000E-03  -2.31784000E-03  +3.74160000E-04  +1.43820000E-04  -1.16500000E-03
   -3.64026000E-03  -2.20643000E-03  +9.42040000E-04  -4.28430000E-04  +5.04200000E-05
   +4.44540000E-04  -8.53740000E-04  +8.70730000E-04  -4.77690000E-04  +4.13430000E-04
   +2.93640000E-04  -6.15400000E-05  +1.34030000E-04  +1.84570000E-04  -1.11300000E-05
   -5.23600000E-05  -5.11200000E-05  +1.25700000E-05  +9.45000000E-06  -1.81200000E-05
   +1.25800000E-05  +1.27100000E-05  +2.68200000E-05  -1.27920000E-04  -1.58470000E-04
   -8.24000000E-05  -3.85000000E-06  -1.59500000E-05  -1.44200000E-05  +2.12553000E-03
   -4.05700000E-05  -2.17730000E-04  -3.20210000E-04  -4.11177000E-03  -3.10070000E-04
   -8.16000000E-06  -4.66000000E-06  +8.43000000E-06  -1.90000000E-07  -1.24000000E-05
   +1.57900000E-05  +3.69200000E-05  -9.97700000E-05  +5.79000000E-06  +7.39000000E-06
   -6.37000000E-06  -2.71000000E-06  -9.15000000E-06  -1.28700000E-05  +2.50000000E-07
   +9.79500000E-05  -1.79660000E-04  -4.85830000E-04  +1.55314000E-03  -9.32430000E-04
   +4.03500000E-05  -3.42790000E-04  -2.03280000E-04  -2.71490000E-04  -2.47800000E-05
   +4.63000000E-06  +1.11400000E-05  -2.47000000E-05  -1.63400000E-05  +4.78000000E-06
   -5.29900000E-05  -1.70330000E-04  -2.41380000E-04  -1.91600600E-02  +1.85249780E-01
   +6.34115000E-03  +2.16898000E-03  +3.71937000E-03  +6.03100000E-04  +1.70659500E-02
   -1.34249500E-02  -2.80268000E-03  +1.51997810E-01  -2.00260900E-01  +3.68876000E-03
   -2.15395000E-03  +5.11515000E-03  +1.85241000E-03  +2.52037000E-03  -2.47368000E-03
   -2.12647000E-03  -1.16790000E-04  +8.63160000E-04  -2.79720000E-03  -1.86214000E-03
   -2.63542000E-03  +1.02530000E-03  -3.28360000E-04  +5.34700000E-05  -4.41790000E-04
   -1.19120000E-04  +2.04510000E-04  -3.73640000E-04  +2.04080000E-04  +2.01920000E-04
   +1.32800000E-05  +4.89700000E-05  +1.49860000E-04  -3.62500000E-05  -4.47800000E-05
   +4.26000000E-06  +1.42300000E-05  +4.67000000E-06  -3.60300000E-05  +1.85000000E-05
   +6.01000000E-06  +2.98400000E-05  -1.07660000E-04  -1.18140000E-04  -3.49800000E-05
   -1.62000000E-05  -2.59200000E-05  -1.80000000E-06  -6.72520000E-04  +9.30200000E-04
   +4.17440000E-04  -5.49000000E-04  -1.80930000E-03  -1.54220000E-04  -7.60000000E-06
   +3.43000000E-06  -1.50000000E-07  -4.32000000E-06  -5.11000000E-06  +1.30000000E-06
   +2.75300000E-05  +5.20000000E-06  -4.15800000E-05  +6.70000000E-07  +4.81000000E-06
   -1.68800000E-05  -8.64000000E-06  -5.69000000E-06  -1.70000000E-06  -4.83280000E-04
   -3.66450000E-04  +2.44480000E-04  -2.27200000E-04  -7.27090000E-04  +2.35480000E-04
   -4.04550000E-04  +1.89700000E-04  +6.33600000E-05  -7.85800000E-05  +1.13200000E-05
   +9.99900000E-05  +4.76000000E-06  -8.66500000E-05  -9.81300000E-05  +1.23200000E-05
   -2.35160000E-04  -2.25550000E-04  -1.38925000E-03  -1.67005190E-01  +2.09189590E-01
   +5.26510000E-04  -4.76000000E-06  -7.14760000E-04  -3.31314000E-03  +3.38353000E-03
   -2.26911000E-03  -1.43054700E-02  -8.59956000E-03  +1.38970900E-02  -2.50873120E-01
   -6.05184700E-02  +1.10393840E-01  +6.64833000E-03  +2.42340000E-03  -5.27604000E-03
   -3.12890000E-04  +1.14342000E-03  +1.07000000E-06  +5.33100000E-05  -2.17670000E-04
   +1.12256000E-03  -3.99670000E-04  +1.19280000E-04  -1.57210000E-04  +9.42450000E-04
   -9.39480000E-04  +7.67290000E-04  -5.76100000E-05  +2.75370000E-04  +1.94300000E-05
   -1.02100000E-05  -2.44200000E-05  -4.26800000E-05  -4.90300000E-05  +6.38000000E-06
   +3.16700000E-05  +9.73100000E-05  +8.28000000E-05  +7.11000000E-06  -2.82200000E-05
   -4.66100000E-05  +7.01000000E-06  -3.80000000E-05  -7.51600000E-05  -3.65800000E-05
   -1.27120000E-04  -1.04310000E-04  -4.20000000E-06  -2.45600000E-05  -1.05250000E-04
   +1.18600000E-04  +2.78900000E-04  -7.36680000E-03  +1.72616000E-03  +1.53800000E-05
   +1.87300000E-05  +7.56000000E-06  -8.51000000E-06  -1.65700000E-05  -5.43000000E-06
   +1.02800000E-05  +2.60800000E-05  +4.71700000E-05  +1.25200000E-05  +1.51300000E-05
   -7.00000000E-06  -1.40100000E-05  -8.51000000E-06  +4.92000000E-06  -2.12000000E-05
   +4.86300000E-05  -3.77400000E-05  +2.38300000E-05  +2.59100000E-05  +8.78000000E-06
   +8.18000000E-06  -2.32000000E-05  -1.56800000E-05  +3.74000000E-06  -1.34500000E-05
   +2.29400000E-05  +2.28800000E-05  -1.15500000E-05  -1.55700000E-05  -3.93600000E-05
   +1.17490000E-04  +1.34440000E-04  +4.83640000E-04  +1.16480000E-04  -4.50320000E-04
   +2.60321570E-01  -6.06010000E-04  +6.11010000E-04  +5.45800000E-05  +2.82183000E-03
   -2.24466000E-03  +2.57347000E-03  +1.69274600E-02  +8.95877000E-03  -9.45674000E-03
   -6.30104700E-02  -6.35458900E-02  +3.81999800E-02  -4.44147000E-03  -8.43984000E-03
   -2.32437000E-03  +6.41720000E-04  +9.04740000E-04  -1.25539000E-03  -1.36010000E-04
   -3.72840000E-04  -1.09525000E-03  +3.73530000E-04  -1.08320000E-04  +1.09830000E-04
   +1.11068000E-03  +6.33760000E-04  +5.16330000E-04  -1.22840000E-04  -8.98700000E-05
   +2.64000000E-06  +5.71000000E-06  +4.83500000E-05  +7.00000000E-08  +2.52600000E-05
   +1.88300000E-05  -1.93200000E-05  -2.01600000E-05  -1.07400000E-05  +5.73000000E-06
   -1.55000000E-06  +4.56000000E-06  -2.27000000E-06  +3.75600000E-05  +4.44200000E-05
   -1.73300000E-05  +3.18000000E-05  +3.17100000E-05  -2.50000000E-07  -1.37300000E-05
   +8.27500000E-05  -5.04500000E-05  -2.34089200E-02  -2.33498800E-02  +1.94349500E-02
   +1.81000000E-06  -6.99000000E-06  +2.80000000E-07  +1.45000000E-05  +6.36000000E-06
   +9.05000000E-06  +2.37300000E-05  -6.12700000E-05  +1.21900000E-05  -1.10200000E-05
   -7.53000000E-06  +8.19000000E-06  +7.02000000E-06  +1.93000000E-06  +1.26000000E-06
   +1.86000000E-05  -3.03600000E-05  +1.19900000E-05  -1.35000000E-06  -5.31000000E-06
   +5.40000000E-06  -2.35300000E-05  +2.76000000E-06  +8.52000000E-06  +9.40000000E-07
   +5.50000000E-06  -3.69600000E-05  -8.28000000E-06  +4.57000000E-06  +1.53200000E-05
   +1.80900000E-05  -9.23500000E-05  -1.19060000E-04  -6.38410000E-04  +1.03620000E-04
   -1.69600000E-04  +7.06514600E-02  +8.77740800E-02  -7.96700000E-05  +7.26700000E-05
   -1.29401000E-03  -5.92620000E-04  +1.20809000E-03  +1.62001000E-03  -3.07060000E-03
   -1.48825000E-03  +3.39495000E-03  +1.12788620E-01  +4.71472700E-02  -1.08349940E-01
   +2.64729700E-02  +4.82216000E-03  -7.46817000E-03  -4.09710000E-04  +2.80913000E-03
   -1.18170000E-04  -1.39700000E-04  +1.71010000E-04  +3.12620000E-04  -7.46900000E-05
   +1.03660000E-04  -8.07700000E-05  -1.92642000E-03  -3.00655000E-03  +2.48726000E-03
   +6.98000000E-05  -1.53400000E-05  +8.81000000E-06  -2.06000000E-06  -1.39200000E-05
   -1.78600000E-05  +1.85000000E-06  -1.32700000E-05  -1.13100000E-05  -4.49200000E-05
   -4.58200000E-05  -1.15300000E-05  +7.34000000E-06  +2.34300000E-05  +1.35600000E-05
   -2.28600000E-05  -1.12600000E-05  +3.96200000E-05  +5.54800000E-05  +4.34500000E-05
   +4.15000000E-06  +5.08800000E-05  -3.90000000E-05  +1.17600000E-05  -1.42655200E-02
   -5.24471000E-03  +7.03263000E-03  -8.36000000E-06  -8.62000000E-06  -3.61000000E-06
   +5.00000000E-08  +4.96000000E-06  +3.70000000E-07  -9.27000000E-06  -2.02600000E-05
   +8.99000000E-06  -3.24000000E-06  +3.79000000E-06  -4.80000000E-06  +1.57000000E-06
   +2.27000000E-06  -3.33000000E-06  +2.37300000E-05  -3.44000000E-06  -1.86000000E-06
   +9.12000000E-06  +2.27600000E-05  +7.61000000E-06  -2.38700000E-05  -3.62000000E-06
   -2.01900000E-05  -1.48200000E-05  -1.76000000E-06  +1.74100000E-05  -2.60000000E-06
   -9.23000000E-06  +5.99000000E-06  -1.40000000E-06  +2.77900000E-05  +3.76900000E-05
   +8.01800000E-05  -1.00864000E-03  -1.64880000E-04  -1.19245580E-01  -4.66973300E-02
   +1.03093360E-01  +2.80752000E-03  +1.46769600E-02  -2.12849200E-02  -1.51305000E-03
   +5.91091000E-03  +1.97498000E-03  -2.22141000E-03  +3.53670000E-04  -1.78460000E-04
   -9.44370000E-04  -1.00689000E-03  +4.62940000E-03  +6.85698000E-03  -9.51389000E-03
   +1.51543400E-02  -5.91348700E-02  +2.56669500E-02  -2.45126100E-02  +5.60980000E-04
   +6.48460000E-04  -1.14470000E-03  +1.26250000E-04  -1.52350000E-04  -9.41200000E-05
   +1.13634000E-03  -6.44150000E-04  -4.77270000E-04  +9.72500000E-05  +9.87000000E-06
   -1.09200000E-05  +7.64000000E-06  +1.32800000E-05  +3.97500000E-05  -2.00800000E-05
   -3.72000000E-05  +2.55000000E-05  +1.70200000E-05  +1.01900000E-05  -8.99000000E-06
   -3.30000000E-06  -2.19200000E-05  +6.83000000E-06  -2.27000000E-06  -2.26700000E-05
   -8.40000000E-06  -3.18300000E-05  -3.91700000E-05  +7.39000000E-06  -3.88850000E-04
   +1.08510000E-04  +1.05060000E-04  -1.12957000E-03  -7.65320000E-04  +9.92030000E-04
   -9.06000000E-06  +7.67000000E-06  -7.23000000E-06  -1.20200000E-05  -4.10000000E-06
   -1.18900000E-05  +5.41000000E-06  +3.02100000E-05  -2.02100000E-05  +2.84000000E-06
   +6.59000000E-06  -4.93000000E-06  -1.17100000E-05  +2.15000000E-06  -5.16000000E-06
   -3.10200000E-05  +6.63100000E-05  -1.27240000E-04  +1.42300000E-05  -5.75000000E-06
   +1.53800000E-05  +1.10300000E-05  -7.79000000E-06  -1.79400000E-05  +8.51000000E-06
   +3.70000000E-07  +7.53600000E-05  -5.14000000E-06  -7.12000000E-06  +1.83400000E-05
   -1.92100000E-05  -1.38200000E-05  +3.04200000E-05  -1.98850000E-04  -3.92100000E-04
   -4.90910000E-04  +2.29810000E-04  +8.13300000E-05  +7.82020000E-04  +5.40983900E-02
   +3.74177000E-03  -5.12627000E-03  +1.72182800E-02  +6.51673000E-03  +7.39033000E-03
   +1.61977000E-03  -2.81863000E-03  +2.60930000E-04  -1.66430000E-04  +2.90900000E-03
   -1.97281000E-03  +3.45696000E-03  +3.03317000E-03  +7.17553000E-03  -4.30148000E-03
   +2.37831400E-02  -1.22867920E-01  +1.36820600E-01  -7.24700000E-05  -1.97500000E-04
   +3.38550000E-04  +2.00090000E-04  -1.53230000E-04  -2.10200000E-05  -9.23370000E-04
   -6.87960000E-04  +2.93400000E-05  -2.69260000E-04  -1.71540000E-04  -2.58900000E-05
   -2.64600000E-05  +6.74600000E-05  +1.21600000E-05  +6.02000000E-06  -1.98900000E-05
   +1.95300000E-05  -2.68700000E-05  -2.79200000E-05  -2.63000000E-06  +2.34000000E-05
   +1.26900000E-05  -1.30200000E-05  +9.75000000E-06  +2.78600000E-05  -2.39900000E-05
   +3.18800000E-05  +2.15000000E-05  -2.89000000E-06  +1.91040000E-04  -1.93220000E-04
   -7.21400000E-05  -8.45260000E-04  -1.29766000E-03  -2.04119000E-03  -1.01300000E-05
   -2.79000000E-06  -1.90000000E-06  -1.64000000E-06  +3.63000000E-06  -3.42000000E-06
   +7.68000000E-06  -3.32000000E-06  -3.69500000E-05  +1.34000000E-06  -1.57800000E-05
   +6.23000000E-06  +6.60000000E-06  +2.24000000E-06  -1.22000000E-06  -1.43000000E-06
   -9.70000000E-05  +4.52600000E-05  -1.28400000E-05  -1.13200000E-05  +1.77300000E-05
   -5.27000000E-06  +1.76100000E-05  -3.14000000E-05  +2.38900000E-05  -2.20100000E-05
   +5.91100000E-05  -1.27500000E-05  -2.21400000E-05  +1.84900000E-05  -6.14000000E-06
   -8.09100000E-05  -1.16800000E-05  -5.51730000E-04  -6.39500000E-04  -5.61660000E-04
   -1.01920000E-04  +5.12200000E-05  +1.29700000E-04  -3.22445700E-02  +1.22860630E-01
   +3.13938000E-03  +2.08620000E-04  +2.35894000E-03  +1.53527000E-03  +3.42512000E-03
   +2.44210000E-03  -1.18142000E-03  -5.17220000E-04  +6.10750000E-04  +4.10847000E-03
   -1.89455000E-03  +9.73960000E-04  -5.47101000E-03  +1.48771000E-02  -1.37387700E-02
   -2.56448700E-02  +1.37887640E-01  -2.56264520E-01  +3.52420000E-04  +1.41910000E-04
   -1.21990000E-04  -1.94000000E-06  -4.43600000E-05  -8.77800000E-05  -8.88920000E-04
   -1.10703000E-03  +1.64352000E-03  -5.40600000E-05  -1.99000000E-06  -2.54000000E-06
   +2.18000000E-06  +1.89800000E-05  +9.00000000E-07  -1.83800000E-05  -2.89100000E-05
   +3.51900000E-05  +1.51200000E-05  +1.80000000E-05  +3.72000000E-06  -1.03000000E-06
   -1.48500000E-05  -3.77000000E-06  -7.86000000E-06  -1.21600000E-05  -2.34600000E-05
   -3.20100000E-05  -3.93000000E-05  +3.35000000E-06  -7.68100000E-05  -4.05000000E-05
   +5.80300000E-05  +1.37730000E-04  -8.31770000E-04  -2.77732000E-03  -6.94000000E-06
   +1.01600000E-05  -5.40000000E-06  -1.17200000E-05  -1.68000000E-06  -1.67400000E-05
   +1.17400000E-05  +1.77500000E-05  -1.02500000E-05  +4.02000000E-06  -1.55000000E-06
   -2.86000000E-06  -4.21000000E-06  -1.46000000E-06  -7.70000000E-07  -1.47000000E-05
   -1.00800000E-05  -3.16200000E-05  +6.90000000E-07  -1.35200000E-05  +6.63000000E-06
   +1.21200000E-05  +2.56000000E-06  -2.22000000E-05  +2.92000000E-06  -2.07100000E-05
   +5.08500000E-05  -2.67000000E-06  -1.18700000E-05  -2.30000000E-06  -1.54300000E-05
   -3.70000000E-07  +4.49700000E-05  -2.87890000E-04  -1.91510000E-04  -2.89720000E-04
   -2.78160000E-04  -7.40000000E-05  -4.30480000E-04  +2.64750500E-02  -1.48992940E-01
   +2.66216630E-01  -2.05640010E-01  +1.21740000E-03  +1.44437440E-01  +5.35264000E-03
   -5.49900000E-05  -3.26818000E-03  +3.08210000E-04  +1.76278000E-03  -6.11120000E-04
   +1.06180000E-04  -9.89300000E-05  -4.67880000E-04  +4.32160000E-04  +6.13240000E-03
   -8.57890000E-04  -1.50928300E-02  -4.98830000E-04  +2.00629400E-02  -2.69990000E-04
   +9.50800000E-05  -2.22390000E-04  -3.61100000E-04  +5.62580000E-04  +8.14600000E-05
   -9.49040000E-04  +1.97700000E-05  +5.98860000E-04  -5.30130000E-04  +3.85830000E-04
   -6.52780000E-04  -2.56350000E-04  +9.11000000E-06  -3.14920000E-04  +2.52990000E-04
   +8.95700000E-05  -3.36700000E-05  -2.36730000E-04  -5.18500000E-05  +1.36580000E-04
   -1.24070000E-04  -1.40200000E-04  +1.43300000E-05  -5.82700000E-05  +8.18000000E-05
   -3.20000000E-05  +1.41280000E-04  +1.15400000E-04  -1.00300000E-05  +3.49800000E-05
   -1.60230000E-04  -4.58200000E-05  -3.47040000E-04  -3.00700000E-04  +1.12846000E-03
   -1.54800000E-05  -2.49200000E-05  -3.68000000E-06  +3.81000000E-06  +9.30000000E-06
   +6.68000000E-06  +1.49600000E-05  -7.00000000E-08  +4.81400000E-05  +4.18000000E-05
   +3.57400000E-05  -1.78000000E-06  +4.60000000E-06  -1.17000000E-06  -7.11000000E-06
   +5.55600000E-05  -2.01200000E-05  +1.59900000E-05  -1.31400000E-05  -3.78700000E-05
   +5.13200000E-05  -1.15000000E-06  -5.22000000E-06  -2.99200000E-05  +2.40890000E-04
   +5.90400000E-04  -2.75210000E-04  +1.12000000E-05  -5.41700000E-05  +3.41000000E-05
   -2.56500000E-05  +7.90200000E-05  -2.37510000E-04  +4.11210000E-04  +2.61370000E-04
   -1.66010000E-04  -1.31400000E-05  -6.85700000E-05  -1.13000000E-06  -6.00770000E-04
   -2.59680000E-03  -1.69795000E-03  +2.17334930E-01  -3.18900000E-05  -4.66580300E-02
   +1.15798400E-02  -1.33050900E-02  +2.69933000E-03  +1.24890700E-02  +1.03427000E-03
   -9.50340000E-04  +2.92183000E-03  +6.65770000E-04  -7.31710000E-04  -1.14200000E-05
   +5.56145000E-03  +5.41655000E-03  +5.34101000E-03  +1.61479400E-02  +4.32813000E-03
   -1.31221500E-02  -7.68100000E-04  -5.39000000E-06  -7.69600000E-05  +1.25360000E-04
   -8.04520000E-04  +5.52650000E-04  +1.35954000E-03  -4.81230000E-04  -1.29616000E-03
   +3.16860000E-04  +1.23660000E-04  -7.79800000E-05  +7.74900000E-05  +2.46420000E-04
   +1.43180000E-04  -1.94450000E-04  -2.19590000E-04  +9.05200000E-05  +1.25500000E-04
   -1.56000000E-05  -1.06950000E-04  +6.94600000E-05  +1.16200000E-05  -1.65400000E-05
   +4.17900000E-05  +1.24100000E-05  +5.51500000E-05  -1.17720000E-04  -1.25540000E-04
   +7.77000000E-06  -9.71100000E-05  -1.01790000E-04  -1.43290000E-04  -1.25066000E-03
   +3.25000000E-06  +1.41201000E-03  -1.32400000E-05  +2.09300000E-05  -1.00500000E-05
   -2.53100000E-05  -1.16600000E-05  -2.44000000E-05  +2.79000000E-06  +2.43000000E-06
   -7.24200000E-05  +8.48100000E-05  -5.63400000E-05  -2.24400000E-05  -1.81500000E-05
   +1.07600000E-05  -6.61000000E-06  +3.47700000E-05  +1.35000000E-05  -2.21400000E-05
   -1.38800000E-05  +3.74900000E-05  +1.62900000E-05  -3.08100000E-05  +1.85100000E-05
   -1.29510000E-04  +6.47600000E-04  -1.81701000E-03  -3.34550000E-04  +2.80900000E-05
   +8.85900000E-05  -4.52400000E-05  -8.69000000E-06  +2.03000000E-04  -2.83260000E-04
   -7.64020000E-04  -1.07100000E-04  +4.25340000E-04  -8.16500000E-05  -2.74300000E-05
   -3.76300000E-05  -2.79543000E-03  -4.27888000E-03  -2.56246000E-03  -7.25894000E-03
   +4.32353200E-02  +1.45042590E-01  +1.18986700E-02  -1.85406120E-01  +1.89313400E-02
   -1.21874000E-03  -1.31886000E-02  -1.66926000E-03  +4.64907000E-03  -2.52743000E-03
   -6.15310000E-04  +7.70800000E-05  +7.89900000E-05  +9.61500000E-04  +5.35171000E-03
   +2.75357000E-03  -4.38926000E-03  +1.64703000E-03  +7.26334000E-03  +9.51040000E-04
   -8.33090000E-04  -2.86400000E-04  +3.93400000E-05  -8.50400000E-05  -1.74240000E-04
   +2.24530000E-04  -3.17860000E-04  -1.52590000E-04  -2.91140000E-04  +3.14710000E-04
   +1.80900000E-05  +5.62900000E-05  -4.45590000E-04  -2.03480000E-04  +8.76200000E-05
   -5.27000000E-05  -3.28900000E-05  -3.24800000E-04  -1.57470000E-04  -1.98000000E-06
   -5.93900000E-05  +8.12900000E-05  +9.32200000E-05  -3.56950000E-04  -1.53640000E-04
   +2.60490000E-04  +3.08690000E-04  +2.48710000E-04  +1.80300000E-05  -1.53400000E-04
   -4.84600000E-05  +2.20100000E-05  -7.20980000E-04  -4.19150000E-04  +1.29759000E-03
   -2.93500000E-05  -4.18200000E-05  -2.32200000E-05  +7.58000000E-06  +2.91900000E-05
   -4.05000000E-06  +5.65400000E-05  +9.15000000E-05  +3.08500000E-05  -1.12300000E-05
   -2.99000000E-06  -2.12200000E-05  +1.57100000E-05  -3.48000000E-06  -6.97000000E-06
   -9.39900000E-05  +5.75900000E-05  +1.50400000E-05  -9.73000000E-06  -1.49860000E-04
   +4.73200000E-05  +6.81800000E-05  +2.59800000E-05  +6.40600000E-05  +1.05150000E-04
   -2.60950000E-04  +6.68230000E-04  -3.08900000E-05  -1.90930000E-04  +4.29400000E-05
   -4.78400000E-05  -2.10000000E-06  +2.03540000E-04  +1.17769000E-03  +1.94840000E-04
   -6.84290000E-04  +1.00400000E-04  -1.47130000E-04  +2.98800000E-05  -1.71793000E-03
   -3.36021000E-03  -7.74090000E-04  -1.57607730E-01  -1.67738700E-02  +1.90530040E-01
   -8.66130000E-04  -7.85110000E-04  +1.62331000E-03  +9.26600000E-05  -1.49610000E-04
   -8.98300000E-05  -1.33030000E-04  +1.27930000E-04  -7.22200000E-05  +5.27930000E-04
   +2.73663000E-03  +8.03160000E-04  -3.48022000E-02  +1.36265900E-02  +3.42066900E-02
   -5.02101000E-03  +2.98716000E-03  -4.15113000E-03  -9.39300000E-05  +9.71700000E-05
   -1.24110000E-04  +1.35210000E-04  -4.50400000E-05  +8.22100000E-05  -1.94809250E-01
   +8.36690500E-02  +1.90231560E-01  +6.77100000E-05  -1.23950000E-04  +1.92000000E-06
   -6.14000000E-06  +1.66500000E-05  +6.74200000E-05  +3.80900000E-05  -3.92400000E-05
   -3.18300000E-05  -1.23080000E-04  -1.16310000E-04  -1.70000000E-05  +4.18000000E-05
   +6.33400000E-05  +1.04700000E-05  -2.58100000E-05  +1.48800000E-05  +3.57100000E-05
   +1.54560000E-04  +1.19410000E-04  +2.20000000E-07  +5.93100000E-05  +6.80000000E-07
   -2.28800000E-05  +6.59893000E-03  -3.95793000E-03  +1.70895000E-03  -2.91200000E-05
   -2.29900000E-05  -6.44000000E-06  -7.29000000E-06  +1.09000000E-05  +2.27000000E-06
   -4.07800000E-05  +3.26000000E-06  -5.88100000E-05  -5.91000000E-06  -1.07600000E-05
   -6.00000000E-08  +1.05900000E-05  +4.27000000E-06  -7.18000000E-06  +3.61600000E-05
   -2.29000000E-05  +1.50000000E-06  -1.22200000E-05  +2.44200000E-05  -4.22000000E-06
   -2.40500000E-05  +5.10000000E-06  -1.43700000E-05  -9.55000000E-06  +1.36500000E-05
   -9.89000000E-06  -1.27900000E-05  +3.04700000E-05  +1.36900000E-05  +3.69900000E-05
   -4.85500000E-05  -4.71100000E-05  +1.41800000E-04  -1.34970000E-04  +3.20200000E-05
   -4.34100000E-05  -2.80710000E-04  -4.04560000E-04  +2.97190000E-04  +4.20300000E-05
   -9.91200000E-05  -2.12480000E-04  +4.51650000E-04  -5.04000000E-06  +2.28039240E-01
   -3.86150000E-04  +1.37689000E-03  -5.49660000E-04  -4.93530000E-04  -3.61960000E-04
   +5.25480000E-04  +2.18100000E-04  -1.23076000E-03  +8.76300000E-05  +1.45407000E-03
   +2.00265000E-03  -2.98321000E-03  +8.18529000E-03  -6.80323000E-03  -1.00265000E-02
   +2.71720000E-04  +2.56500000E-05  +6.66980000E-04  +6.22500000E-05  +2.15200000E-05
   +1.50250000E-04  -9.47000000E-05  +5.00000000E-05  -5.60000000E-05  +9.01938200E-02
   -4.03151600E-02  -9.18484500E-02  +1.26700000E-05  +7.39100000E-05  -7.53000000E-06
   -2.04000000E-05  -4.45000000E-06  -5.18000000E-06  -1.94600000E-05  +7.12000000E-06
   +2.45500000E-05  +6.98700000E-05  +7.77200000E-05  +1.77200000E-05  -1.78700000E-05
   -4.37300000E-05  -1.56700000E-05  +7.27000000E-06  -1.81500000E-05  -2.79100000E-05
   -9.33100000E-05  -9.26700000E-05  -6.10000000E-07  -2.93300000E-05  +8.49000000E-06
   +1.64000000E-05  -1.00022000E-03  +7.83540000E-04  +1.75239000E-03  +4.57000000E-06
   +2.29900000E-05  +9.90000000E-07  -1.47300000E-05  -1.00800000E-05  -1.34600000E-05
   +8.84000000E-06  +2.95200000E-05  +2.16100000E-05  +1.30500000E-05  +3.15000000E-06
   -6.87000000E-06  -6.39000000E-06  -2.68000000E-06  +1.93000000E-06  -1.95500000E-05
   +1.32800000E-05  -8.93000000E-06  -2.31000000E-06  -2.55000000E-05  +6.08000000E-06
   +1.35100000E-05  -1.73000000E-06  -6.82000000E-06  +1.33200000E-05  -1.23300000E-05
   -6.05000000E-06  +2.12000000E-06  -2.51400000E-05  -1.11000000E-06  -2.04300000E-05
   +4.13400000E-05  +2.23600000E-05  +1.82940000E-04  +1.83610000E-04  +1.54280000E-04
   -1.94750000E-04  -8.95670000E-04  +1.07653000E-03  +8.08300000E-05  -2.05000000E-06
   -1.93040000E-04  -7.39700000E-05  -7.97400000E-05  -2.28000000E-06  -9.83071500E-02
   +4.52036600E-02  -2.43870000E-04  +1.70240000E-04  +5.72480000E-04  +1.98300000E-05
   -1.45980000E-04  +1.80670000E-04  +3.05040000E-04  -3.03700000E-05  -7.50990000E-04
   -1.93222000E-03  +2.21000000E-03  +1.43206000E-03  -1.35866100E-02  +7.35224000E-03
   +1.13042000E-02  -2.03890000E-03  +3.76740000E-04  -5.16700000E-04  -8.67000000E-06
   -2.76000000E-06  -2.69300000E-05  +1.05300000E-05  +3.29000000E-06  +8.93000000E-06
   +2.41016040E-01  -1.09100810E-01  -3.40272100E-01  +1.38900000E-05  -1.84600000E-05
   -3.22000000E-06  -1.16700000E-05  +5.74000000E-06  +1.51900000E-05  +5.04000000E-06
   -3.85000000E-06  -6.20000000E-06  -1.89300000E-05  -1.65500000E-05  -1.41000000E-06
   +8.25000000E-06  +8.17000000E-06  -5.40000000E-07  -9.93000000E-06  +3.26000000E-06
   -6.20000000E-07  +2.05300000E-05  +1.68000000E-05  -3.97000000E-06  -3.60000000E-06
   +7.87000000E-06  -1.18000000E-06  +4.08730000E-04  -2.60941000E-03  -1.36688000E-03
   -3.84000000E-06  -4.20000000E-06  +3.13000000E-06  -3.57000000E-06  -1.52000000E-06
   +2.41000000E-06  -6.67000000E-06  +5.16000000E-06  -7.00000000E-06  +1.50000000E-06
   -3.27000000E-06  -6.00000000E-08  +2.62000000E-06  -5.60000000E-07  -2.00000000E-07
   +3.68000000E-06  +4.80000000E-07  +1.40000000E-06  -8.00000000E-07  +3.05000000E-06
   +5.80000000E-07  -4.92000000E-06  +9.60000000E-07  -2.42000000E-06  +2.25000000E-06
   +1.47000000E-06  -9.15000000E-06  -1.10000000E-06  +6.80000000E-07  +4.88000000E-06
   +2.87000000E-06  -1.89000000E-06  -7.47000000E-06  -1.48620000E-04  +2.19500000E-05
   -4.83100000E-05  +1.38030000E-04  +4.95680000E-04  -1.45750000E-04  -2.08010000E-04
   -1.19630000E-04  +1.57040000E-04  -7.16100000E-05  +1.41400000E-04  +5.03500000E-05
   -2.23655260E-01  +1.01234080E-01  +3.29437780E-01
end_hess

