# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.35538420    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.56113569E+00  +1.41214727E+00  -2.75848492E+00
   006   +2.27240356E+00  +2.89528363E+00  -3.48263891E-01
   006   +3.26468242E+00  +1.42538038E+00  +1.86662888E+00
   006   +3.78151340E+00  -1.01547982E+00  +1.79599452E+00
   006   +3.58602281E+00  -2.60303652E+00  -5.55169958E-01
   006   +3.09269816E+00  -1.02384103E+00  -2.85894739E+00
   006   -6.05384473E-01  +3.66461654E+00  +1.08167214E-01
   006   -7.88992554E-01  +5.31196381E+00  +2.49010628E+00
   008   +1.66935369E+00  -4.40214283E+00  -4.09610868E-01
   006   -2.23188316E+00  +1.28633447E+00  +3.43659511E-01
   006   -3.29411712E+00  +1.25157347E-01  -1.76286349E+00
   006   -4.68918346E+00  -2.07978487E+00  -1.57825762E+00
   006   -5.06067093E+00  -3.20406517E+00  +7.57985349E-01
   006   -4.04319247E+00  -2.07937495E+00  +2.89375127E+00
   006   -2.65542396E+00  +1.22330959E-01  +2.66882850E+00
   008   -6.39470896E+00  -5.37695406E+00  +1.06089926E+00
   006   -1.52206553E+00  +5.33025358E+00  -2.08921461E+00
   008   +5.88064961E+00  -3.97425506E+00  -8.64991055E-01
   001   -6.94155374E+00  -5.98035954E+00  -5.53347704E-01
   001   -5.47005724E+00  -2.93454336E+00  -3.26811122E+00
   001   -3.02784540E+00  +9.22158835E-01  -3.62312396E+00
   001   -1.87884066E+00  +9.27874897E-01  +4.37547599E+00
   001   -4.34403732E+00  -2.94752571E+00  +4.71917953E+00
   001   -4.95250782E-01  +7.11792015E+00  -2.12351986E+00
   001   -1.32688273E+00  +4.44907187E+00  -3.93659449E+00
   001   -3.51470756E+00  +5.77962751E+00  -1.82677036E+00
   001   -1.63799818E-01  +4.35531191E+00  +4.19714049E+00
   001   +3.69195155E-01  +6.99767741E+00  +2.27247522E+00
   001   -2.74574465E+00  +5.88831099E+00  +2.78049534E+00
   001   +3.53212382E+00  +2.48878912E+00  +3.59252183E+00
   001   +4.45272767E+00  -1.99801969E+00  +3.46553935E+00
   001   +3.24340316E+00  -2.02160335E+00  -4.63862232E+00
   001   +2.28432453E+00  +2.45094851E+00  -4.50367417E+00
   001   +1.94732695E+00  -5.42062761E+00  +1.06326706E+00
   001   +7.25618750E+00  -2.79672567E+00  -8.11591081E-01
   008   +3.80699676E+00  +5.10984631E+00  -4.64423801E-01
   001   +3.46778084E+00  +5.97720675E+00  -2.01467836E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -9.00000000E-07  +1.31000000E-06  +3.14000000E-06
   -3.85000000E-06  -1.37600000E-05  +4.26000000E-06
   -9.00000000E-08  +3.66000000E-06  -3.98000000E-06
   -5.90000000E-07  +4.18000000E-06  +1.89000000E-06
   +1.58000000E-06  -4.20000000E-07  +2.80000000E-06
   +3.20000000E-06  +5.10000000E-07  -2.37000000E-06
   +7.50000000E-07  +5.09000000E-06  +1.47000000E-06
   +1.60000000E-07  +4.20000000E-07  -1.53000000E-06
   +6.20000000E-07  -2.03000000E-06  -3.52000000E-06
   +3.09000000E-06  -1.15000000E-06  -1.08000000E-06
   -1.23000000E-06  -2.01000000E-06  -1.90000000E-07
   +1.00000000E-07  +3.80000000E-07  +8.70000000E-07
   -2.19000000E-06  +6.50000000E-07  -8.00000000E-08
   -3.10000000E-07  -7.60000000E-07  +9.20000000E-07
   +1.30000000E-07  +1.62000000E-06  +1.02000000E-06
   +2.50000000E-07  -1.80000000E-07  +9.70000000E-07
   +7.10000000E-07  +3.50000000E-07  +6.20000000E-07
   -3.93000000E-06  -3.22000000E-06  +1.02000000E-06
   +7.00000000E-08  -2.80000000E-07  +6.30000000E-07
   -6.00000000E-08  -3.30000000E-07  +4.20000000E-07
   -2.20000000E-07  -3.30000000E-07  +7.60000000E-07
   +1.02000000E-06  +2.90000000E-07  -4.30000000E-07
   -1.10000000E-07  +3.70000000E-07  +8.70000000E-07
   +5.20000000E-07  -2.40000000E-07  -1.13000000E-06
   -8.30000000E-07  +8.20000000E-07  +6.30000000E-07
   +8.90000000E-07  +8.50000000E-07  +1.30000000E-07
   -1.42000000E-06  +3.70000000E-07  -7.20000000E-07
   +7.40000000E-07  -6.00000000E-08  -7.90000000E-07
   -6.00000000E-08  -6.30000000E-07  -3.50000000E-07
   -4.70000000E-07  -1.90000000E-07  +3.80000000E-07
   -2.10000000E-07  +2.20000000E-07  -1.23000000E-06
   -1.70000000E-07  +6.50000000E-07  -1.86000000E-06
   -3.90000000E-07  +4.10000000E-07  +6.30000000E-07
   +2.30000000E-07  +3.10000000E-07  +1.55000000E-06
   +4.91000000E-06  -2.30000000E-07  -1.53000000E-06
   +1.77000000E-06  +1.38000000E-06  -2.70000000E-06
   -3.72000000E-06  +1.99000000E-06  -1.50000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +1.99717140E-01  -1.55168540E-01  +8.51812440E-01  +1.88039800E-02  -4.11789000E-02
   +5.89175160E-01  -7.41514500E-02  +1.00671900E-02  +4.01558000E-03  +3.67253430E-01
   +1.44078600E-02  -1.05449150E-01  -4.64655400E-02  -3.18152000E-03  +4.96265870E-01
   +1.50275900E-02  -3.45096500E-02  -1.82868570E-01  +3.25881300E-02  -1.73610500E-02
   +5.61262100E-01  +1.96468000E-03  -1.49202000E-03  +2.65000000E-06  -8.73137300E-02
   +3.00824300E-02  -4.63686200E-02  +2.23479880E-01  -4.67332000E-03  +1.46140300E-02
   -9.82856000E-03  +1.82049100E-02  -1.07205150E-01  +3.48545400E-02  -1.29467970E-01
   +8.64117570E-01  -1.13578900E-02  +1.09327100E-02  -3.52671400E-02  -3.39100500E-02
   +4.36423100E-02  -1.73047910E-01  +9.76330800E-02  +8.65204800E-02  +5.74589300E-01
   +3.39190000E-04  +1.33060000E-04  +6.50780000E-04  +4.86469000E-03  +1.07799700E-02
   +8.25320000E-04  -7.81679600E-02  +1.07955110E-01  -1.25847700E-02  +2.27152160E-01
   +2.74570000E-04  -2.68580000E-03  -2.67167000E-03  +9.37693000E-03  -1.65923300E-02
   +7.74509000E-03  +1.06039310E-01  -5.59127160E-01  -2.06083900E-02  -1.63141670E-01
   +8.52658850E-01  -2.15980000E-04  -1.10932000E-03  +6.42540000E-04  -5.08108000E-03
   +2.32677500E-02  +7.86877000E-03  -1.56375400E-02  -1.41490100E-02  -1.18031220E-01
   +1.08781860E-01  -2.19467400E-02  +5.68863810E-01  +3.72041000E-03  +5.68916000E-03
   -3.35465000E-03  -1.22938900E-02  -1.04054000E-03  +2.71603000E-03  +6.52616000E-03
   +1.83273000E-03  +5.56617000E-03  -6.95537700E-02  +1.60412000E-03  -1.08672300E-02
   +4.32126680E-01  +6.41936000E-03  -1.80034000E-02  +2.19308200E-02  -4.79860000E-03
   -7.62410000E-04  +3.67310000E-04  -3.13760000E-04  -1.85644000E-02  -2.24289400E-02
   -3.90514000E-03  -1.10518980E-01  -4.76736400E-02  +2.32965100E-02  +5.50539520E-01
   -2.98932000E-03  +6.27068000E-03  +1.32669200E-02  +2.23967000E-03  -4.23000000E-06
   +5.44468000E-03  +5.39585000E-03  -8.77311000E-03  +1.17696500E-02  -1.79318100E-02
   -3.43463700E-02  -1.88014470E-01  +2.36898900E-02  -2.35723100E-02  +5.71090910E-01
   -7.51334100E-02  +1.10223510E-01  -3.99290000E-04  +6.46984000E-03  +3.60028000E-03
   -2.91720000E-04  +1.63280000E-04  +6.38740000E-04  -6.32030000E-04  +4.05404000E-03
   -7.89090000E-04  -4.20630000E-03  -7.03120100E-02  +1.11108900E-02  -1.75809900E-02
   +1.96298150E-01  +1.11937040E-01  -5.58586070E-01  -1.53266300E-02  +5.95568000E-03
   -1.66896100E-02  -1.08843100E-02  +9.37460000E-04  -2.44112000E-03  +2.45544000E-03
   -3.76544000E-03  +1.57626500E-02  -1.10990300E-02  +9.69183000E-03  -1.12032360E-01
   +3.92242500E-02  -1.49507650E-01  +8.61725520E-01  +2.69446000E-03  -2.15412700E-02
   -1.22553550E-01  +6.52445000E-03  -2.43669700E-02  +6.94266000E-03  +2.79120000E-04
   +1.09671000E-03  +1.11113000E-03  -6.50512000E-03  +1.16980800E-02  -3.17992600E-02
   -1.98903200E-02  +5.31713400E-02  -1.92383540E-01  +3.41094000E-03  +6.98742900E-02
   +6.12384750E-01  -4.54829000E-03  +1.09134300E-02  +1.02405800E-02  -8.23871300E-02
   +3.49803000E-03  +2.56679000E-03  -1.58971600E-02  +1.38058800E-02  -7.44792000E-03
   -1.50245000E-03  -2.87719000E-03  +1.15790000E-04  +6.57720000E-04  +1.82406000E-03
   -2.54280000E-04  -1.63042000E-03  -2.65125000E-03  -5.48930000E-04  +4.04707110E-01
   +1.58310800E-02  -4.82806000E-03  -4.34070000E-03  +2.96144400E-02  -7.31949000E-02
   -3.67646000E-03  +1.68180200E-02  -5.41977000E-03  -7.60320000E-04  -5.40860000E-04
   -4.37920000E-04  +1.14350000E-03  +1.69695000E-03  +9.64860000E-04  -2.72790000E-04
   -7.58520000E-04  -3.29630000E-04  -8.62270000E-04  +2.08717800E-02  +4.93755250E-01
   +2.63195100E-02  -1.08810900E-02  -3.84684000E-03  +2.08780000E-04  -4.50600000E-04
   -7.83524600E-02  -2.25328000E-02  +6.53216000E-03  +6.95105000E-03  -2.32540000E-04
   +7.69970000E-04  -3.18441000E-03  -3.28490000E-04  -1.34570000E-04  -1.91091000E-03
   -1.61750000E-04  +2.23820000E-04  -3.30790000E-03  +1.40063200E-02  -1.15221000E-03
   +4.89810910E-01  -6.15705000E-03  +7.43430000E-04  -1.62425000E-03  -6.97096000E-03
   +1.96053500E-02  +2.82814600E-02  -7.92200000E-04  +8.50100000E-04  +4.77780000E-04
   +1.41150000E-04  +1.99420000E-04  +4.74090000E-04  -4.28170000E-04  -9.92250000E-04
   +8.51210000E-04  +1.20990000E-04  +5.66100000E-04  +1.24191000E-03  -7.53150700E-02
   +3.85378000E-03  +5.60649000E-03  +5.88336120E-01  +8.56080000E-04  -1.88170000E-04
   +3.88030000E-04  +6.96441000E-03  -5.18275000E-03  -9.98618000E-03  +5.72430000E-04
   -8.36610000E-04  -2.80260000E-04  +1.29500000E-05  +3.06970000E-04  -6.27300000E-05
   -1.92880000E-04  -1.53940000E-04  -3.73530000E-04  +5.75900000E-05  +1.37730000E-04
   -2.03780000E-04  +1.81650000E-03  -1.07676650E-01  -4.49239300E-02  +1.02031600E-02
   +5.40929940E-01  -3.79650000E-04  -1.89900000E-04  +1.50410000E-04  +7.48482000E-03
   -4.51163000E-03  -6.03059000E-03  +8.87840000E-04  +3.80210000E-04  +1.80916000E-03
   -1.32580000E-04  +8.44400000E-05  -8.92860000E-04  -5.95900000E-05  -4.43700000E-05
   +2.72490000E-04  +1.52050000E-04  +9.99100000E-05  +1.15780000E-04  +3.07036000E-03
   -4.16093600E-02  -1.44111630E-01  +1.12814700E-02  -6.46657100E-02  +5.20696130E-01
   -2.80970000E-04  +2.32640000E-04  +4.79300000E-04  -1.40589000E-03  +6.65690000E-04
   +1.00100000E-05  -1.03509000E-03  +5.42030000E-04  -3.31980000E-03  -8.66498000E-03
   -1.95825700E-02  -2.01783000E-03  -1.43442620E-01  -6.15358400E-02  -2.58339400E-02
   +2.46402000E-03  -6.50890000E-03  +4.83261000E-03  -5.22920000E-04  -5.78810000E-04
   +7.49800000E-05  +4.23180000E-04  +1.97350000E-04  -1.57110000E-04  +2.77371050E-01
   -1.37010000E-04  +6.59000000E-04  +3.60647000E-03  -3.17747000E-03  +1.14104000E-03
   +8.91000000E-05  -1.75085000E-03  +1.32517000E-03  -4.88487000E-03  -2.63664100E-02
   -2.83932500E-02  -6.71170000E-04  -9.99259900E-02  -1.62047390E-01  +1.25328000E-03
   -2.15196700E-02  -2.98074100E-02  +9.39608000E-03  -9.97200000E-04  -4.17470000E-04
   +1.81740000E-04  +5.09450000E-04  +1.59590000E-04  -1.41960000E-04  +9.62045700E-02
   +3.75132010E-01  -8.67400000E-05  -2.00210000E-04  -4.75197000E-03  +4.32440000E-04
   -1.14720000E-04  -2.55579000E-03  -1.71550000E-03  +7.99980000E-04  -3.57079000E-03
   -2.13413900E-02  -2.59552600E-02  +6.75630000E-03  +2.95069000E-03  +2.57874400E-02
   -9.55494400E-02  +2.43870800E-02  +3.22535500E-02  -1.29675000E-03  +4.37300000E-05
   +7.85700000E-05  +5.57580000E-04  -2.85900000E-04  +1.02900000E-04  -8.73900000E-05
   +8.12114300E-02  -2.51293460E-01  +4.44838200E-01  -9.57500000E-04  +1.15800000E-05
   +9.11370000E-04  -2.09040300E-02  -2.25623600E-02  +3.01417000E-03  -1.83427000E-03
   -8.12600000E-05  -5.75870000E-04  -1.00373000E-03  -8.20240000E-04  +7.12300000E-05
   +5.93440000E-04  +5.65190000E-04  -1.59610000E-04  -6.39970000E-04  -5.54230000E-04
   +1.70640000E-04  -1.02328380E-01  -5.05360900E-02  +1.71732000E-03  -5.54300000E-04
   -1.50277000E-03  -3.60068000E-03  -1.24301000E-03  +1.11792000E-03  +1.81090000E-04
   +3.30440810E-01  +8.50100000E-04  +3.74000000E-06  +1.86010000E-04  -1.13801400E-02
   +6.38840000E-03  +1.68763000E-03  +5.95640000E-04  +1.58960000E-04  -3.88820000E-04
   +1.05508000E-03  -2.05210000E-04  +1.36400000E-04  +1.10760000E-03  +1.11356000E-03
   -1.96720000E-04  +8.84930000E-04  -1.59150000E-04  -4.36460000E-04  -4.17560900E-02
   -1.41969120E-01  +6.07268000E-03  -1.22444600E-02  -2.07647100E-02  -4.28636000E-03
   -1.85300000E-05  -1.44136000E-03  +7.83600000E-05  +2.01340280E-01  +4.87539810E-01
   +1.63234000E-03  -2.30410000E-04  -5.23930000E-04  +3.17608000E-03  +3.69234000E-03
   -1.95358000E-03  -1.35455000E-03  +1.69970000E-04  +1.92680000E-04  -4.75240000E-04
   -4.43350000E-04  +7.29800000E-05  -1.26340000E-04  -6.07900000E-05  -4.04710000E-04
   +6.77770000E-04  +6.70700000E-04  -1.28490000E-04  +1.59044000E-03  +7.33102000E-03
   -9.33457400E-02  -1.69158500E-02  -2.39977200E-02  +3.29707000E-03  +2.45410000E-04
   -1.74030000E-04  -1.56220000E-04  +5.12520400E-02  -2.75048000E-02  +6.66771770E-01
   -3.08646000E-03  -9.12700000E-05  +7.89000000E-06  +1.36690000E-04  -3.43000000E-05
   +2.92230000E-04  +3.19490000E-04  -1.88170000E-04  -6.50400000E-05  +2.41310000E-04
   +3.93400000E-04  +6.56000000E-06  -1.92700000E-05  +1.10100000E-04  +3.57500000E-04
   -1.34809000E-03  -6.56470000E-04  +1.76990000E-04  -5.88132000E-03  -9.74745000E-03
   -1.38113600E-02  -1.13324000E-03  -7.57760000E-04  +1.45378000E-03  -6.95100000E-04
   +2.61570000E-04  -4.98580000E-04  -1.19220500E-01  -6.59898400E-02  -4.98379700E-02
   +3.13998370E-01  -1.03430000E-04  +2.40470000E-04  -6.01200000E-05  +1.53213000E-03
   -1.26648000E-03  -4.70600000E-04  +4.54930000E-04  -2.55660000E-04  -1.04100000E-04
   +1.16850000E-04  +5.17660000E-04  +4.90900000E-05  +2.21010000E-04  +7.07730000E-04
   +1.65830000E-04  -8.75300000E-05  +1.74600000E-05  +2.64560000E-04  -1.20177100E-02
   -1.34113600E-02  -2.00407100E-02  -2.87561000E-03  -2.97144000E-03  +1.23499000E-03
   +7.57600000E-05  -8.33190000E-04  -2.35800000E-05  -5.89731000E-02  -1.46563610E-01
   -3.29025300E-02  +2.50379880E-01  +5.41079390E-01  +7.16320000E-04  +1.46020000E-04
   +5.48240000E-04  +8.33860000E-04  +3.70910000E-04  -3.53800000E-05  +3.62300000E-04
   -1.39720000E-04  -3.24800000E-04  +2.40340000E-04  +4.20790000E-04  -1.30370000E-04
   -4.91520000E-04  -2.20810000E-04  +6.69610000E-04  +1.89520000E-04  -3.79100000E-05
   -3.46170000E-04  -2.09989000E-03  -4.18716000E-03  +9.08502000E-03  +1.49563000E-03
   +2.05724000E-03  -4.63440000E-04  +1.83250000E-04  -2.86900000E-05  -2.27340000E-04
   -8.84848400E-02  -9.12358700E-02  -2.53839650E-01  +4.11476300E-02  -6.27005500E-02
   +7.23103280E-01  +1.00010000E-04  +2.13900000E-04  -2.07400000E-05  +3.04400000E-04
   +5.83280000E-04  -1.73730000E-04  -1.80590000E-04  +1.38090000E-04  +8.35300000E-05
   -1.99910000E-04  -2.31750000E-04  +6.23800000E-05  +3.96700000E-05  -1.15400000E-05
   -2.68460000E-04  -1.64300000E-04  -1.58500000E-05  +8.94700000E-05  +4.98027000E-03
   -1.88411000E-03  -3.01725000E-03  -9.37300000E-04  -1.07528000E-03  +3.83510000E-04
   -7.26220000E-04  +7.24100000E-05  -2.59300000E-05  -1.00407000E-02  -1.91245600E-02
   -3.70442900E-02  -1.44154350E-01  -1.35043450E-01  +2.16461700E-02  +3.07635430E-01
   +5.42050000E-04  -2.70470000E-04  -4.63400000E-05  +1.39940000E-04  -1.14626000E-03
   -8.96380000E-04  -4.68700000E-04  +1.46910000E-04  +3.91990000E-04  -2.26650000E-04
   -4.40920000E-04  -9.47500000E-05  -6.52580000E-04  -8.33180000E-04  -4.09520000E-04
   +3.88530000E-04  +5.47060000E-04  -3.33300000E-05  -2.11730000E-03  +3.61624000E-03
   -1.10269000E-03  -3.81050000E-04  -3.94300000E-05  +2.08100000E-04  +8.38150000E-04
   +3.66170000E-04  +4.77960000E-04  -2.51993900E-02  -1.68477100E-02  -6.60780400E-02
   -1.28260590E-01  -2.67537550E-01  +4.81138200E-02  +2.68107140E-01  +5.49295880E-01
   -2.14100000E-04  -6.86300000E-05  -6.98100000E-05  -9.10100000E-05  +1.65290000E-04
   +1.21090000E-04  +4.88000000E-06  +7.76400000E-05  -1.59200000E-04  +3.70700000E-05
   +1.64600000E-05  +1.02800000E-04  -3.94100000E-04  -2.27000000E-06  -7.37200000E-05
   +6.07000000E-06  -1.71000000E-05  +1.92340000E-04  -1.75926000E-03  -1.29153000E-03
   -4.10045000E-03  -4.96580000E-04  -6.04400000E-04  +3.80900000E-05  +4.87140000E-04
   -2.99300000E-05  -4.60700000E-05  -8.74676000E-03  -1.96568200E-02  +4.52548400E-02
   -1.71808200E-02  -1.34336400E-02  -1.29797010E-01  +7.44002600E-02  -1.56249600E-02
   +7.15473140E-01  +3.24900000E-04  -1.62780000E-04  +1.74680000E-04  -5.31120000E-04
   +2.57200000E-05  -6.34000000E-06  +1.26420000E-04  -1.17990000E-04  -1.68030000E-04
   +1.55490000E-04  +1.72750000E-04  -1.22060000E-04  -9.87280000E-04  +8.57000000E-05
   +1.40200000E-04  +2.47610000E-04  +2.62400000E-04  +1.52800000E-05  -6.62370000E-04
   -7.06640000E-04  -2.25400000E-04  +8.18400000E-05  +1.59540000E-04  -2.33610000E-04
   +7.02300000E-05  -4.65680000E-04  -3.22700000E-05  -5.11573000E-03  +4.94589000E-03
   -1.26510400E-02  +4.63097000E-03  -1.15604000E-03  +2.32870800E-02  -9.10727200E-02
   -4.14534500E-02  +3.36923500E-02  +3.28885100E-01  +2.41060000E-04  -1.48690000E-04
   +2.76880000E-04  -1.16400000E-03  +6.95480000E-04  +1.87100000E-04  +8.95000000E-05
   -1.34530000E-04  -3.29890000E-04  +8.79300000E-05  +9.89500000E-05  -1.46500000E-05
   -6.85060000E-04  +9.75740000E-04  +1.26600000E-04  +1.00950000E-04  +1.35690000E-04
   -5.68300000E-05  -3.26650000E-04  -1.79314000E-03  -4.60800000E-05  +2.32380000E-04
   +2.48150000E-04  -4.06150000E-04  +7.58040000E-04  -1.48566000E-03  -5.11800000E-04
   +4.93610000E-03  +2.33679000E-03  -1.39374000E-03  -9.52691000E-03  -1.91768800E-02
   +2.83997000E-02  -3.15165700E-02  -1.41795290E-01  +1.05884890E-01  +2.46583910E-01
   +5.59638100E-01  +3.92990000E-04  -9.01800000E-05  +6.07700000E-05  +6.00600000E-05
   -6.25700000E-05  -6.27980000E-04  -3.70810000E-04  +2.67700000E-05  +2.86860000E-04
   -2.80200000E-04  -3.13970000E-04  -1.34800000E-05  +2.40000000E-06  -4.75000000E-05
   -4.03820000E-04  +2.51960000E-04  +3.62780000E-04  -8.34200000E-05  -2.28340000E-04
   +2.94780000E-04  -1.77702000E-03  -3.09710000E-04  -2.76540000E-04  +3.30240000E-04
   +3.04480000E-04  -4.13000000E-06  -5.50720000E-04  -1.22235400E-02  -1.41857000E-03
   -8.60006200E-02  +5.58055600E-02  +8.03623100E-02  +3.57606900E-02  -1.23681400E-02
   +3.39616400E-02  -3.00427090E-01  +6.24253500E-02  -2.48119800E-02  +7.20834150E-01
   -2.02840000E-04  +1.31380000E-04  -7.08400000E-05  +3.27990000E-04  +4.95850000E-04
   +1.27580000E-04  +1.57510000E-04  +2.76610000E-04  -6.69400000E-05  -1.61790000E-04
   -2.21300000E-05  +5.50800000E-05  +6.93300000E-05  -3.38030000E-04  +1.10340000E-04
   -1.86240000E-04  -2.55800000E-04  +4.34300000E-05  +5.41974000E-03  -1.46736000E-03
   +8.84700000E-05  -1.30480000E-04  +1.28730000E-04  -1.07240000E-04  -1.32375000E-03
   +4.33790000E-04  +8.02990000E-04  +6.61509000E-03  -1.23713100E-02  +4.76321500E-02
   -2.35748900E-02  -2.76448900E-02  -1.76540800E-02  +2.43782200E-02  +2.90791400E-02
   -2.44932700E-02  -1.12563680E-01  -5.63102100E-02  -4.44744600E-02  +3.06464810E-01
   -5.61150000E-04  +2.04870000E-04  -2.13630000E-04  +2.82800000E-04  -1.18802000E-03
   +8.43080000E-04  +5.95150000E-04  -3.09630000E-04  -1.10870000E-04  +4.88500000E-04
   +5.98720000E-04  -8.66500000E-05  -5.12450000E-04  -7.81350000E-04  +6.63920000E-04
   -1.76490000E-04  -4.85080000E-04  +1.38050000E-04  -1.52583000E-03  +3.44060000E-03
   +1.65355000E-03  +8.36000000E-06  +2.30610000E-04  +1.35700000E-04  +1.42483000E-03
   +1.15910000E-04  -1.07990000E-03  -5.20680000E-03  -1.65663700E-02  +6.99404000E-02
   -2.73682100E-02  -4.17171900E-02  -2.48144100E-02  +2.30092500E-02  +4.97591300E-02
   -2.37015900E-02  -4.60008500E-02  -1.37866260E-01  -2.47173200E-02  +2.66082180E-01
   +5.58204330E-01  -4.40000000E-06  -7.14700000E-05  -1.09890000E-04  -1.79100000E-05
   -2.89150000E-04  +7.94400000E-05  +1.64170000E-04  +7.31000000E-06  -1.52680000E-04
   +1.00110000E-04  +6.25000000E-06  +1.91010000E-04  +4.18230000E-04  +2.43780000E-04
   -2.60950000E-04  +4.60500000E-05  +2.43500000E-05  +1.04130000E-04  -1.05360000E-03
   +1.66279000E-03  -4.77559000E-03  -8.68650000E-04  -9.58560000E-04  -4.93060000E-04
   -2.48000000E-05  -1.83370000E-04  +1.18210000E-04  +2.05864100E-02  +2.48368400E-02
   +2.94751100E-02  -1.65356900E-02  -2.23097900E-02  -1.67452500E-02  +2.54747000E-03
   +1.67232400E-02  -5.08935600E-02  -8.82346100E-02  -9.22217800E-02  -2.79561720E-01
   +4.36966000E-02  -6.34040900E-02  +7.30821150E-01  +1.81980000E-04  -1.29630000E-04
   -6.85200000E-05  -2.62870000E-04  -1.78720000E-04  -3.02530000E-04  -2.78166000E-03
   -1.04760000E-04  +9.96560000E-04  -1.40550000E-03  -6.75870000E-04  +1.09810000E-04
   +7.12100000E-05  +2.02880000E-04  -2.05400000E-04  +1.33950000E-04  +2.65580000E-04
   -6.72300000E-05  -4.07990000E-04  -8.15673000E-03  +1.64731400E-02  +6.19400000E-05
   -4.38440000E-04  +2.11350000E-04  -1.10734000E-03  +4.09290000E-04  +9.82020000E-04
   -9.22242900E-02  -3.69889100E-02  +2.04473000E-03  +2.37190800E-02  +2.38062400E-02
   +1.29581000E-03  -1.42196800E-02  -1.90096000E-02  +1.49602400E-02  -1.46840400E-02
   -1.77026300E-02  -3.95724600E-02  -1.46431920E-01  -1.38953550E-01  +2.18278700E-02
   +3.26441290E-01  +4.12590000E-04  -2.30100000E-04  -2.78200000E-05  +1.65046000E-03
   -1.28845000E-03  -1.68500000E-05  -7.87800000E-05  +1.97910000E-04  +1.22870000E-04
   -1.54050000E-04  +2.95100000E-05  -2.02020000E-04  +2.79460000E-04  +8.21390000E-04
   -2.65300000E-04  +6.23300000E-05  +5.24860000E-04  -4.01800000E-05  -6.17587000E-03
   -1.32605800E-02  +2.24233600E-02  -2.12638000E-03  -1.63352000E-03  +1.05652000E-03
   -6.81000000E-05  -1.00794000E-03  +5.97000000E-05  -4.66538000E-02  -1.45719870E-01
   +4.59894800E-02  +3.09696600E-02  +5.34068500E-02  +1.96761200E-02  -2.05761400E-02
   -4.21105800E-02  +2.85421000E-02  -2.46459400E-02  -2.00695000E-02  -7.48402100E-02
   -1.28830740E-01  -2.71656040E-01  +5.20815200E-02  +2.59287680E-01  +5.44765590E-01
   -4.99430000E-04  +2.33630000E-04  -1.99640000E-04  -7.83300000E-04  -3.63410000E-04
   +3.26170000E-04  +3.28160000E-04  -1.53340000E-04  +4.54440000E-04  +1.21890000E-04
   +2.26680000E-04  -2.76500000E-04  +7.00750000E-04  +1.39240000E-04  +5.13120000E-04
   -3.28020000E-04  -5.42180000E-04  -3.92500000E-05  +4.96446000E-03  +6.86132000E-03
   +3.90583000E-03  +1.11084000E-03  -1.36080000E-04  +6.73120000E-04  +1.12080000E-04
   -1.92200000E-04  -4.72950000E-04  +3.96951300E-02  +1.03746470E-01  -2.76292890E-01
   -2.69622900E-02  -2.77018600E-02  -6.26843200E-02  +1.70497400E-02  +3.19884300E-02
   -2.64385700E-02  -7.41170000E-03  -2.34904900E-02  +5.56903800E-02  -1.65252800E-02
   -8.38216000E-03  -1.33002670E-01  +7.59255300E-02  -7.56156000E-03  +7.09417100E-01
   -1.54460000E-04  +5.25800000E-05  -2.52740000E-04  +8.87070000E-04  -5.42740000E-04
   -1.46680000E-04  -3.08900000E-05  +1.28100000E-05  +2.75560000E-04  -8.30100000E-05
   -6.64300000E-05  +3.09000000E-05  +5.85820000E-04  -5.57360000E-04  -1.07390000E-04
   -8.52000000E-05  -9.23000000E-05  +1.33000000E-05  -2.89420000E-04  +1.52775000E-03
   +1.59200000E-04  -3.42120000E-04  -2.72630000E-04  +3.32030000E-04  -1.81650000E-04
   +5.76360000E-04  +1.16080000E-04  -1.30783000E-03  -1.81267000E-03  +1.79952000E-03
   +5.44516000E-03  -2.97231000E-03  -1.10976000E-03  -8.83620000E-04  -1.86633500E-02
   +3.18864000E-03  -1.17563270E-01  -1.19858950E-01  +2.30610600E-02  -1.12048600E-02
   -2.88684100E-02  -4.25301000E-03  +5.05077000E-03  +5.65360000E-04  -2.53798000E-03
   +1.82740830E-01  -2.71460000E-04  +1.31770000E-04  -4.23280000E-04  +1.48390000E-03
   -8.61360000E-04  -2.31230000E-04  -7.43900000E-05  +5.21400000E-05  +4.89080000E-04
   -5.48200000E-05  -5.03600000E-05  +2.01000000E-05  +3.53910000E-04  -1.66327000E-03
   -4.49600000E-05  -1.08650000E-04  -1.30490000E-04  +3.15100000E-05  +8.29900000E-04
   +1.81349000E-03  -6.96200000E-05  -5.80930000E-04  -4.68860000E-04  +5.33120000E-04
   +1.14670000E-04  +1.82901000E-03  +1.80010000E-04  -6.53660000E-04  -4.19985000E-03
   +5.45320000E-04  -1.62463000E-03  +4.85932000E-03  +2.37840000E-03  -2.33663500E-02
   -2.98349700E-02  +7.77493000E-03  -1.16056290E-01  -2.37158080E-01  +4.96389300E-02
   -2.37061800E-02  -2.92456000E-02  -6.81147000E-03  -4.29230000E-04  +4.63864000E-03
   -8.49240000E-04  +2.26938210E-01  +3.72589630E-01  -7.71000000E-06  -1.66400000E-05
   +7.33000000E-06  -9.58000000E-05  +4.50200000E-05  +2.18100000E-05  +2.99300000E-05
   +1.79800000E-05  -5.68100000E-05  +1.57700000E-05  +1.31100000E-05  +1.32300000E-05
   -6.37800000E-05  +5.58400000E-05  -4.66700000E-05  +4.50000000E-07  +4.23000000E-06
   +2.01700000E-05  +1.00510000E-04  -1.50420000E-04  +3.70170000E-04  +2.49000000E-05
   +4.23800000E-05  -1.21870000E-04  -8.02000000E-06  -3.09600000E-05  +1.04460000E-04
   +1.33319000E-03  +2.92470000E-04  +7.13303000E-03  -5.62739000E-03  -5.42127000E-03
   -8.12335000E-03  +2.49988100E-02  +4.16391200E-02  -1.11337000E-03  -5.30721000E-03
   +4.98132000E-03  -1.14303290E-01  -2.53708300E-02  -4.03012800E-02  +9.51457000E-03
   +1.13659000E-03  +5.33836000E-03  -9.96146000E-03  +1.24777120E-01  +1.07256290E-01
   +5.60440040E-01  -6.09450000E-04  +4.87820000E-04  +5.34580000E-04  -1.75832900E-02
   +1.96508100E-02  -2.47528200E-02  -4.91305000E-03  +6.66560000E-04  +3.22328000E-03
   -2.21150000E-04  +6.02700000E-04  -1.09507000E-03  -5.87070000E-04  -8.97520000E-04
   -5.65020000E-04  -8.10700000E-05  +1.63890000E-04  -7.96940000E-04  -8.37588900E-02
   +1.69674900E-02  -2.46385700E-02  +1.31425000E-03  -1.55258000E-03  -1.42274000E-03
   +4.79820000E-04  +5.88100000E-04  +1.03800000E-04  +5.48612000E-03  -1.02307400E-02
   +1.54874300E-02  -1.69060000E-04  -2.09969000E-03  -7.66200000E-04  +3.11000000E-05
   -2.26100000E-05  +6.59690000E-04  +2.47790000E-04  +3.29840000E-04  +2.54350000E-04
   -7.44860000E-04  -3.83290000E-04  +7.60420000E-04  -1.90864000E-03  -2.92552000E-03
   -1.06379000E-03  -4.39180000E-04  -6.81400000E-04  +4.07200000E-05  +5.67094820E-01
   +3.58100000E-04  -7.90340000E-04  +4.93300000E-05  +9.51523000E-03  -4.52655000E-03
   +7.05717000E-03  +5.84260000E-04  -2.26080000E-04  -5.38940000E-04  +1.02740000E-04
   +1.78690000E-04  +1.61930000E-04  -7.16600000E-05  -1.62280000E-04  +3.86600000E-04
   +6.00000000E-06  +2.87440000E-04  +5.06300000E-05  +1.55583300E-02  -1.07880820E-01
   +4.15362600E-02  -5.43886000E-03  +9.12173000E-03  -1.22719700E-02  +1.36730000E-04
   +1.07170000E-04  -1.73110000E-04  +5.81981000E-03  -2.16297200E-02  +2.34314800E-02
   -3.07950000E-04  -1.61128000E-03  +3.54130000E-04  +4.03190000E-04  +2.51400000E-04
   +8.28390000E-04  +2.41610000E-04  +2.24980000E-04  +2.14570000E-04  -8.81780000E-04
   -2.59400000E-05  +8.86080000E-04  -1.22114000E-03  -2.96768000E-03  -1.77088000E-03
   -3.26560000E-04  -4.20160000E-04  +7.76000000E-06  +2.54513600E-02  +5.37244400E-01
   +5.05100000E-05  -8.21860000E-04  +2.07168000E-03  -3.49729000E-03  -1.57268000E-03
   +4.14510000E-03  +1.85373000E-03  +1.56700000E-05  -1.01976000E-03  -4.60400000E-05
   -3.06350000E-04  +4.79750000E-04  +2.98400000E-04  +3.17300000E-04  +4.36420000E-04
   -1.27240000E-04  -1.26270000E-04  -7.78210000E-04  -2.18177000E-02  +3.75113500E-02
   -1.32253590E-01  -1.06042600E-02  +1.41992300E-02  -3.76103000E-02  -1.45300000E-05
   -7.50300000E-05  -2.01640000E-04  +2.54774000E-03  +7.58582000E-03  -2.90943000E-03
   -4.58700000E-05  -6.44310000E-04  +1.12671000E-03  -3.49000000E-06  -1.74190000E-04
   -6.59610000E-04  +2.42760000E-04  +3.14600000E-04  +8.21400000E-05  -1.03350000E-04
   -8.81200000E-05  -5.32000000E-05  -9.54570000E-04  -3.26780000E-04  +2.92540000E-04
   -2.51010000E-04  -3.31380000E-04  -5.51100000E-05  -2.90342500E-02  +5.85192200E-02
   +5.31073540E-01  +1.21750000E-04  +4.22860000E-04  -4.56659000E-03  -2.18482000E-03
   -1.39945000E-03  -1.17710000E-04  +1.12467000E-03  +2.81190000E-04  +4.07854000E-03
   -1.38160100E-02  +1.81652800E-02  +4.30029000E-03  -1.45763980E-01  +7.33985000E-02
   +1.49936900E-02  -2.21117200E-02  +2.17760400E-02  -5.61460000E-04  +5.87010000E-04
   +1.13900000E-04  +4.32500000E-05  -2.52760000E-04  +3.19800000E-05  -3.64500000E-05
   -6.81358100E-02  -1.56485000E-03  +7.86449000E-03  +4.49400000E-05  -4.63800000E-05
   +2.00000000E-05  -3.37900000E-05  -1.12390000E-04  +1.01910000E-04  -1.12070000E-04
   +1.46460000E-04  +3.30130000E-04  +5.89430000E-04  +6.39510000E-04  -6.66000000E-05
   -6.91200000E-05  +6.01600000E-05  -3.31790000E-04  -1.29000000E-05  -1.21590000E-04
   -1.85260000E-04  -4.44720000E-04  -5.24590000E-04  +5.52300000E-05  -1.86040000E-04
   -1.08400000E-05  +5.53000000E-05  +5.60949280E-01  +4.79580000E-04  +6.45750000E-04
   +4.08803000E-03  +3.04845000E-03  +1.94780000E-03  -3.73130000E-04  -8.72360000E-04
   +9.25370000E-04  -4.41129000E-03  +3.14460200E-02  -2.00576100E-02  -8.03347000E-03
   +3.62846300E-02  -1.35425890E-01  -1.12323400E-02  +3.06480500E-02  -1.82747200E-02
   -7.81970000E-04  -1.07019000E-03  -6.41670000E-04  +1.30720000E-04  +5.44400000E-04
   +4.55300000E-05  +8.72000000E-06  -3.34160300E-02  +1.61644900E-02  +3.99735000E-03
   -1.99900000E-04  -4.97790000E-04  +5.14000000E-06  -1.50300000E-05  -1.97750000E-04
   -1.10000000E-07  +4.86600000E-05  +2.45020000E-04  -1.68480000E-04  -3.66420000E-04
   -6.77360000E-04  +4.40300000E-05  +1.42340000E-04  +2.25860000E-04  +9.88200000E-05
   -1.26200000E-05  -2.09060000E-04  +4.49300000E-05  +4.40230000E-04  +8.86750000E-04
   -4.80800000E-05  +5.30460000E-04  +5.79800000E-05  -1.47620000E-04  +1.54732860E-01
   +4.15414520E-01  -2.65020000E-04  +8.56820000E-04  -2.97293000E-03  -2.94010000E-04
   +3.32100000E-04  -4.81953000E-03  -9.69730000E-04  -7.87820000E-04  -4.29039000E-03
   +3.19219200E-02  -2.55635000E-02  -3.41628000E-03  +7.56667000E-03  -1.28651800E-02
   -7.28956000E-02  -2.54733600E-02  +1.76795800E-02  +7.13189000E-03  +4.64700000E-05
   -2.13300000E-05  +1.27273000E-03  -3.50990000E-04  +1.57890000E-04  -1.23180000E-04
   +5.20497000E-03  +1.21173000E-03  +8.28541000E-03  +2.15000000E-05  +1.40200000E-05
   +2.31790000E-04  -1.71210000E-04  -1.14850000E-04  -2.70420000E-04  +9.15400000E-05
   +2.30450000E-04  +1.64700000E-05  -6.20000000E-05  -9.56700000E-05  +1.23090000E-04
   -2.16600000E-05  -2.61040000E-04  +9.80000000E-05  +9.74400000E-05  +1.15300000E-04
   -2.71530000E-04  +6.80600000E-05  +8.16100000E-05  +3.82000000E-05  +3.65220000E-04
   -1.43800000E-04  -2.43040000E-04  -1.17431000E-02  +3.49760300E-02  +6.50112600E-02
   +2.36300000E-05  -1.47000000E-05  +1.21500000E-05  -9.47000000E-05  -4.28500000E-05
   +1.25400000E-05  +1.61900000E-05  -7.68000000E-06  -5.96000000E-06  +6.43800000E-05
   +4.90600000E-05  -2.64200000E-05  -3.61560000E-04  -3.03270000E-04  +7.37500000E-05
   +4.33300000E-05  +3.20000000E-05  +1.17000000E-06  -5.95300000E-05  -9.46100000E-05
   +6.18600000E-05  +1.78300000E-05  +1.74100000E-05  -3.83800000E-05  +3.33960000E-04
   +3.59530000E-04  -2.77500000E-05  +2.46810000E-04  +2.21740000E-04  +4.32460000E-04
   -8.23220000E-04  -7.45800000E-05  -2.40470000E-04  +6.81390000E-04  +2.58219000E-03
   -2.21240000E-04  -1.19652500E-02  -1.07922900E-02  -2.41996200E-02  -6.97700000E-05
   -4.09682000E-03  +1.85885000E-03  +1.10156000E-03  -5.26380000E-04  -1.36634000E-03
   -5.66407800E-02  -6.46507500E-02  -1.18163310E-01  +4.82900000E-05  +4.87900000E-05
   +6.79000000E-06  +1.99170000E-04  +1.43700000E-05  -1.00400000E-05  +6.75226100E-02
   +6.52300000E-05  -3.23500000E-05  +3.00300000E-05  -1.79680000E-04  +4.50200000E-05
   +2.75600000E-05  +4.39200000E-05  -1.43600000E-05  -6.24300000E-05  +2.54900000E-05
   +1.99100000E-05  -1.13900000E-05  -1.13090000E-04  +2.26080000E-04  -1.15000000E-06
   +3.48600000E-05  +4.34200000E-05  +1.92300000E-05  -2.48900000E-05  -1.70810000E-04
   +1.23030000E-04  +7.45400000E-05  +7.07500000E-05  -5.10700000E-05  +4.26500000E-05
   -2.73100000E-04  -4.38700000E-05  +1.98480000E-04  +2.46560000E-04  +7.81120000E-04
   -2.42660000E-04  -7.75940000E-04  -4.34560000E-04  +1.92163000E-03  +2.43345000E-03
   -1.32539000E-03  -1.48164700E-02  -1.92303600E-02  -3.92048300E-02  -3.82037000E-03
   -4.49130000E-03  +2.87143000E-03  -7.12630000E-04  +1.06038000E-03  -1.73021000E-03
   -6.03345300E-02  -8.13646800E-02  -1.14383540E-01  +5.43400000E-05  +2.20300000E-05
   -4.54000000E-06  +1.17490000E-04  -1.47200000E-04  -1.48400000E-05  +7.74424800E-02
   +1.02679190E-01  -2.43000000E-06  +1.09000000E-06  +2.33200000E-05  -7.61600000E-05
   +9.28700000E-05  +2.48000000E-05  -1.00000000E-05  -3.50000000E-07  -3.08700000E-05
   +1.34000000E-06  -1.78000000E-06  +5.56000000E-06  -2.87100000E-05  +3.82000000E-05
   +2.27300000E-05  -5.22000000E-06  +2.24000000E-06  +8.00000000E-06  -1.01700000E-05
   -1.82800000E-04  -7.94100000E-05  +1.26800000E-05  +3.08400000E-05  -4.19500000E-05
   +2.83800000E-05  -3.98000000E-05  -5.66000000E-05  +3.01000000E-05  +3.05290000E-04
   +3.28500000E-05  -1.80110000E-04  -1.96260000E-04  -9.82980000E-04  +3.42478000E-03
   +4.56457000E-03  +3.69180000E-03  +2.21552000E-03  +2.80897000E-03  +2.72044000E-03
   +9.13880000E-04  +1.50729000E-03  +1.80777000E-03  -2.55820000E-04  -1.35930000E-04
   -9.95700000E-05  -1.46645870E-01  -1.59691800E-01  -4.48529370E-01  +3.49000000E-05
   +3.47500000E-05  +5.13900000E-05  +2.32300000E-05  -2.79300000E-05  -2.59000000E-05
   +1.40749590E-01  +1.51309330E-01  +4.42288770E-01  -2.15900000E-05  -1.28200000E-05
   -2.54800000E-05  +1.38670000E-04  -9.30700000E-05  -6.90100000E-05  -1.99100000E-05
   +8.29000000E-06  +5.63100000E-05  +2.15300000E-05  +1.47000000E-06  -8.81000000E-06
   -1.31010000E-04  -2.55290000E-04  -5.93000000E-06  +3.02000000E-05  +2.44000000E-06
   -5.91600000E-05  +2.60270000E-04  -1.49200000E-04  -7.02040000E-04  -2.72490000E-04
   -2.71810000E-04  +7.75400000E-05  +1.44560000E-04  +2.41670000E-04  +1.21680000E-04
   +3.61592000E-03  -5.33632000E-03  +5.44370000E-04  -3.39154000E-03  -5.78662000E-03
   -1.49977600E-02  -7.95941900E-02  -5.43248500E-02  -8.85293300E-02  +4.35151000E-03
   -7.08890000E-04  +4.14913000E-03  +4.11918000E-03  -2.25986000E-03  +6.02540000E-04
   -7.16960000E-04  +1.24430000E-04  +6.02120000E-04  -1.75026000E-03  +3.35906000E-03
   +9.69120000E-04  -3.22900000E-05  +7.23400000E-05  -7.34100000E-05  +5.01300000E-05
   +7.90600000E-05  +3.62700000E-05  +3.57690000E-04  -1.83700000E-04  -6.56930000E-04
   +7.61787100E-02  -5.50000000E-06  +5.42000000E-06  -4.34800000E-05  +2.05900000E-04
   -1.27430000E-04  -5.75700000E-05  -9.30000000E-07  -1.18300000E-05  +4.63300000E-05
   -2.57300000E-05  -1.10100000E-05  +1.53200000E-05  +9.26100000E-05  +3.91000000E-06
   -5.02400000E-05  -5.11000000E-06  -4.35000000E-06  +1.39400000E-05  -2.46230000E-04
   +2.05300000E-04  -1.21678000E-03  -2.38850000E-04  -1.77870000E-04  +1.74870000E-04
   -7.65300000E-05  -1.17000000E-05  -1.97000000E-06  -5.44450000E-03  -1.60199000E-03
   +1.96455000E-03  -9.18570000E-03  -6.86494000E-03  -2.40496200E-02  -5.45222100E-02
   -9.84834600E-02  -9.15514000E-02  +3.27411000E-03  +6.85532000E-03  +1.14581700E-02
   -2.28623000E-03  +1.08226000E-03  +3.21946000E-03  -2.68200000E-05  -1.10881000E-03
   +7.31550000E-04  +3.54002000E-03  +1.60242000E-03  +2.04030000E-04  -3.43200000E-05
   +4.87800000E-05  -3.21300000E-05  -6.96100000E-05  +3.71200000E-05  +2.18000000E-05
   -5.71150000E-04  -2.42670000E-04  -7.38560000E-04  +6.27478600E-02  +9.95482900E-02
   -1.27100000E-05  +2.88000000E-06  -1.20800000E-05  +6.61400000E-05  -2.12500000E-05
   -7.56000000E-06  -2.50000000E-06  +4.05000000E-06  +2.20500000E-05  +1.05000000E-06
   +5.83000000E-06  -1.42000000E-06  +1.65900000E-05  -1.15890000E-04  +1.03800000E-05
   -1.69500000E-05  -1.29600000E-05  -1.12200000E-05  +1.18380000E-04  +2.00220000E-04
   +8.36100000E-05  -2.55700000E-05  +1.90700000E-05  +1.81200000E-05  +5.93000000E-06
   +1.28890000E-04  +5.21600000E-05  +1.69580000E-04  +1.25469000E-03  +2.00775000E-03
   +1.99414000E-03  +2.47858000E-03  +5.29996000E-03  -8.89402900E-02  -9.16862700E-02
   -2.50155230E-01  -1.36933100E-02  -1.67670400E-02  -1.77203300E-02  +1.09929000E-03
   +3.81966000E-03  -4.02955000E-03  +7.88150000E-04  +1.07901000E-03  -4.00700000E-05
   +6.37180000E-04  -4.80980000E-04  +2.62831000E-03  -6.86400000E-05  -4.10300000E-05
   +2.08100000E-05  -2.60100000E-05  +5.45700000E-05  +8.30000000E-06  +8.89140000E-04
   +1.89481000E-03  -1.12735000E-03  +9.71890600E-02  +9.96285100E-02  +2.63173340E-01
   -3.20880000E-04  -1.50000000E-05  -1.72790000E-04  +1.04000000E-06  -7.24570000E-04
   -3.50800000E-04  +5.73000000E-06  +4.58300000E-05  +7.56600000E-05  -8.12000000E-06
   -4.72400000E-05  +2.97500000E-05  -7.05500000E-05  +2.07580000E-04  -3.07760000E-04
   -8.18000000E-06  +1.32470000E-04  +5.54400000E-05  -2.68034000E-03  +1.78993000E-03
   +5.51850000E-04  +2.67690000E-04  +2.99800000E-04  +6.36000000E-06  -6.93100000E-05
   -1.08730000E-04  +1.52420000E-04  +6.42663000E-03  +5.75132000E-03  -1.04276400E-02
   -4.93407800E-02  -2.38281500E-02  +3.12108400E-02  +1.62103000E-03  -7.09758000E-03
   +1.61074100E-02  +3.92583000E-03  -5.80016000E-03  -1.01583000E-03  -1.22450000E-03
   -1.30200000E-05  -1.60690000E-04  +3.58371000E-03  -3.89831000E-03  -3.03499000E-03
   -2.99040000E-04  -5.52660000E-04  +8.26780000E-04  -1.66550000E-04  -1.05418000E-03
   -4.28220000E-04  +9.06000000E-05  -1.19300000E-04  +1.19050000E-04  +5.61300000E-05
   +1.19150000E-04  +9.73800000E-05  -2.80578000E-03  +2.35701000E-03  +3.77290000E-04
   +4.20947600E-02  -2.01060000E-04  +2.23270000E-04  -1.26060000E-04  -1.75780000E-04
   +4.41980000E-04  +2.31450000E-04  +7.27500000E-05  +2.26900000E-05  -8.89100000E-05
   +7.40000000E-06  -6.90000000E-07  +2.00300000E-05  +6.90000000E-05  -2.08300000E-05
   +1.36000000E-04  -1.82260000E-04  -1.98770000E-04  +7.03300000E-05  +1.90414000E-03
   -6.08620000E-04  -2.15100000E-05  +1.45720000E-04  -2.45660000E-04  +1.25240000E-04
   +3.19000000E-06  -3.67200000E-05  -8.68600000E-05  +2.08475000E-03  +9.47585000E-03
   -1.14689000E-02  -2.34375200E-02  -9.55903600E-02  +1.01773760E-01  -3.85116000E-03
   -6.86948000E-03  +2.56201000E-02  -6.03322000E-03  -1.24226000E-03  -3.85430000E-04
   +1.00000000E-04  -8.96870000E-04  -6.91090000E-04  -3.90512000E-03  +1.23222000E-03
   -2.39517000E-03  -2.76470000E-04  -1.03258000E-03  +1.31794000E-03  -1.14242000E-03
   -2.15063000E-03  -7.00960000E-04  -2.11200000E-05  -4.67000000E-06  -7.32600000E-05
   +1.20830000E-04  +1.78930000E-04  +1.34670000E-04  +2.35528000E-03  -7.07640000E-04
   -5.34280000E-04  +3.32650800E-02  +1.00667420E-01  +3.19280000E-04  -3.11210000E-04
   -2.69000000E-06  +5.80000000E-06  -1.39670000E-04  -1.76530000E-04  +1.77800000E-05
   +6.10800000E-05  +1.74000000E-06  -5.37000000E-05  -9.53700000E-05  +6.11300000E-05
   +9.19800000E-05  +3.02700000E-04  -4.04900000E-04  +3.46930000E-04  +3.18870000E-04
   +1.95180000E-04  +9.86810000E-04  +1.32271000E-03  -4.54050000E-04  -8.90500000E-05
   -1.61000000E-04  +1.72620000E-04  -1.80710000E-04  -1.44160000E-04  +1.85430000E-04
   +4.87156000E-03  +1.21390500E-02  -1.80531400E-02  +3.09219100E-02  +1.01505100E-01
   -2.95671740E-01  -9.41360000E-04  -9.03940000E-04  +6.88570000E-04  -7.21450000E-04
   -1.03660000E-04  +2.14641000E-03  -2.44050000E-04  -7.27550000E-04  +4.69000000E-04
   -3.28421000E-03  -2.87169000E-03  -3.09482000E-03  +1.88460000E-04  +3.38140000E-04
   -1.50630000E-04  +8.09110000E-04  +9.14560000E-04  -2.43320000E-04  +2.84700000E-05
   -1.31340000E-04  +1.49010000E-04  -4.52400000E-05  -7.59000000E-05  -4.92100000E-05
   +5.88440000E-04  -1.09300000E-04  +9.00530000E-04  -3.40677600E-02  -1.12463780E-01
   +3.12371070E-01  -1.08000000E-05  +4.63200000E-05  -6.66200000E-05  +4.19800000E-05
   -6.39920000E-04  +2.88040000E-04  -2.77490000E-04  +2.12200000E-05  +2.92840000E-04
   -6.83500000E-05  +3.32600000E-05  +2.54700000E-05  -3.22200000E-05  +1.13730000E-04
   +1.95320000E-04  -4.08000000E-06  -2.27900000E-05  -8.97000000E-06  -2.85991000E-03
   +1.26441000E-03  +1.90490000E-04  -3.71360000E-04  -1.27586000E-03  +4.88490000E-04
   -4.62700000E-05  -8.23400000E-05  -9.79600000E-05  +5.96075000E-03  +2.08024000E-03
   +3.14491000E-03  +4.70366000E-03  -2.77562000E-03  +7.56080000E-04  -9.27300000E-04
   +8.62000000E-05  +6.61400000E-04  +4.55661000E-03  -5.63917000E-03  +2.60980000E-04
   -2.32605000E-03  -6.71002000E-03  -1.51665000E-02  -8.58927300E-02  -5.12588600E-02
   -9.22464900E-02  -3.62780000E-04  -4.62910000E-04  -8.33990000E-04  +2.70480000E-04
   +3.28770000E-04  -6.64100000E-05  +5.70500000E-05  -7.43000000E-05  -9.60700000E-05
   -2.65150000E-04  -9.91600000E-05  +2.96700000E-05  -4.92440000E-04  +3.02460000E-04
   +3.12000000E-05  +1.79600000E-04  +7.28500000E-05  +2.76310000E-04  +8.19002200E-02
   +1.01650000E-04  +4.39000000E-06  +5.51800000E-05  -2.27880000E-04  +4.42010000E-04
   -1.53080000E-04  -1.19420000E-04  +2.52620000E-04  +1.62520000E-04  -2.22110000E-04
   -2.13430000E-04  -4.00000000E-07  +4.11200000E-05  -1.75300000E-05  -1.43090000E-04
   +4.77000000E-06  +4.64000000E-06  -2.57800000E-05  +1.70585000E-03  -6.88230000E-04
   -5.47750000E-04  -9.27340000E-04  -2.29545000E-03  +1.16045000E-03  -7.24000000E-06
   -3.33700000E-05  +7.38600000E-05  +5.19306000E-03  +9.54925000E-03  +1.03718000E-02
   -2.99146000E-03  +1.09512000E-03  +3.41915000E-03  +2.18830000E-04  -8.87410000E-04
   +6.11010000E-04  -5.75372000E-03  -1.02635000E-03  +1.98074000E-03  -1.10249000E-02
   -6.89945000E-03  -2.34877200E-02  -5.10272800E-02  -9.67005300E-02  -9.22701800E-02
   -4.92410000E-04  -5.93210000E-04  -1.28327000E-03  +1.28870000E-04  -2.48130000E-04
   -1.89580000E-04  -2.00000000E-06  -1.13600000E-05  +7.91200000E-05  -9.55500000E-05
   -3.79940000E-04  -1.47500000E-05  +3.20310000E-04  -1.85080000E-04  -1.00460000E-04
   +2.79830000E-04  +4.53950000E-04  +6.75280000E-04  +6.34636600E-02  +1.01348800E-01
   -1.18900000E-05  -7.37500000E-05  +3.47900000E-05  -5.64800000E-05  +3.04700000E-04
   -2.52320000E-04  -1.42970000E-04  +3.08940000E-04  -4.67300000E-05  -2.35510000E-04
   -3.02880000E-04  +2.73910000E-04  -1.90760000E-04  -3.18910000E-04  -4.03530000E-04
   +5.65200000E-05  +1.01050000E-04  +4.93400000E-05  -3.25060000E-04  -1.79234000E-03
   -3.16970000E-04  -9.56200000E-04  -6.86530000E-04  -1.46670000E-04  +2.03740000E-04
   +2.18000000E-04  +1.31230000E-04  -1.18097300E-02  -1.32032700E-02  -1.76827800E-02
   +9.51330000E-04  +3.77391000E-03  -4.27691000E-03  +6.70380000E-04  +7.01720000E-04
   +2.62060000E-04  +1.45900000E-04  +1.79827000E-03  +1.76104000E-03  +1.93954000E-03
   +2.86383000E-03  +5.11800000E-03  -9.22058400E-02  -9.16493200E-02  -2.59247190E-01
   -1.40760000E-04  -2.34010000E-04  +9.45100000E-05  +6.02700000E-05  +5.76300000E-05
   +1.60990000E-04  -1.51800000E-05  +1.43870000E-04  +1.84710000E-04  +8.79900000E-05
   +8.75000000E-05  +4.30800000E-05  -8.70000000E-07  -1.39510000E-04  -3.71500000E-05
   -6.56010000E-04  -7.03690000E-04  -1.09963000E-03  +1.01303970E-01  +9.99313200E-02
   +2.72225460E-01  -2.57400000E-05  +1.18900000E-05  -3.24900000E-05  +9.98100000E-05
   -8.16400000E-05  +2.31500000E-05  +6.45000000E-06  -3.34200000E-05  +2.89400000E-05
   +8.23800000E-05  +2.73800000E-05  +3.38000000E-05  -1.68430000E-04  -2.02750000E-04
   +6.34600000E-05  +1.36200000E-05  -5.01000000E-06  +7.22000000E-06  +3.75800000E-04
   -2.00410000E-04  +5.63000000E-04  +2.96300000E-05  +8.54800000E-05  +7.69200000E-05
   +1.79220000E-04  +1.71580000E-04  -1.62440000E-04  +3.59907000E-03  -5.52292000E-03
   -9.28620000E-04  -1.06110000E-03  -8.99000000E-05  -2.74810000E-04  +2.87797000E-03
   -3.50470000E-03  -2.53176000E-03  +6.53421000E-03  +4.72848000E-03  -1.14579800E-02
   -4.78686000E-02  -2.78635300E-02  +3.39284600E-02  +8.80020000E-04  -5.98062000E-03
   +1.56819400E-02  -1.93108000E-03  +2.26485000E-03  +9.92910000E-04  -2.22000000E-04
   -2.53910000E-04  +1.19900000E-05  +5.69700000E-05  +5.18900000E-05  -4.81600000E-05
   -3.11370000E-04  +3.17780000E-04  +2.09710000E-04  +8.00000000E-05  +3.24810000E-04
   -6.16730000E-04  -4.66610000E-04  +3.43690000E-04  +1.19970000E-04  -2.94442000E-03
   +2.55186000E-03  +4.70670000E-04  +4.05319100E-02  -5.59000000E-06  -9.34000000E-06
   -3.55300000E-05  +1.63470000E-04  -1.30260000E-04  -2.05000000E-06  +2.24000000E-05
   -3.46000000E-06  +3.06600000E-05  -1.29500000E-05  +2.24000000E-06  -1.78700000E-05
   +8.51700000E-05  +3.97400000E-05  +1.54300000E-05  -1.65100000E-05  -5.38000000E-06
   -5.34000000E-06  +7.96000000E-05  +1.56580000E-04  +1.16660000E-03  -1.47800000E-05
   +5.16600000E-05  +4.44800000E-05  -7.33100000E-05  -5.08400000E-05  +3.92100000E-05
   -5.84772000E-03  -1.40012000E-03  -3.20310000E-04  -1.30410000E-04  -1.00403000E-03
   -7.28200000E-04  -3.30508000E-03  +7.67310000E-04  -2.20650000E-03  +9.83320000E-04
   +9.38116000E-03  -1.21449300E-02  -2.76927300E-02  -1.01839350E-01  +1.08093140E-01
   -2.23215000E-03  -6.45138000E-03  +2.45877200E-02  +2.25970000E-03  -5.22000000E-06
   +3.72880000E-04  -2.49310000E-04  -1.50670000E-04  -8.94500000E-05  -4.67100000E-05
   +1.31300000E-05  -3.78000000E-06  +3.22470000E-04  -8.88800000E-05  +1.51400000E-04
   +1.26860000E-04  +3.58350000E-04  -7.31050000E-04  +3.37510000E-04  -1.89750000E-04
   +4.04100000E-05  +2.44842000E-03  -7.43560000E-04  -5.74710000E-04  +3.28088000E-02
   +1.01462610E-01  +1.25400000E-05  -7.74000000E-06  +2.58000000E-05  -6.87400000E-05
   +3.97700000E-05  +2.90000000E-06  -4.80000000E-07  +1.56300000E-05  -1.82500000E-05
   -2.07900000E-05  -8.47000000E-06  -2.19200000E-05  +6.39400000E-05  +1.56100000E-04
   -1.02600000E-05  -8.50000000E-06  -5.12000000E-06  -7.11000000E-06  -1.82460000E-04
   -1.40750000E-04  +2.36700000E-05  +6.29400000E-05  +1.98000000E-05  -1.89600000E-05
   -9.14300000E-05  -1.48060000E-04  +8.69400000E-05  -6.70680000E-04  +9.68900000E-05
   +2.16542000E-03  -5.03450000E-04  -1.08755000E-03  +2.89050000E-04  -2.93969000E-03
   -2.77610000E-03  -2.87876000E-03  +6.42161000E-03  +1.53130600E-02  -1.87147400E-02
   +3.28156000E-02  +1.06898460E-01  -2.88835720E-01  -7.92820000E-04  -1.25642000E-03
   +2.43873000E-03  +7.49790000E-04  +2.86900000E-05  +1.79881000E-03  +7.20400000E-05
   +3.65100000E-05  +3.75000000E-06  -2.50000000E-06  -5.54500000E-05  +1.52500000E-05
   +1.54080000E-04  +6.22700000E-05  +3.36580000E-04  +1.85920000E-04  +5.32750000E-04
   -1.03011000E-03  +9.29600000E-05  +9.92000000E-06  -4.80100000E-05  +7.35490000E-04
   -6.08100000E-05  +8.25490000E-04  -3.62722500E-02  -1.17684740E-01  +3.03656750E-01
   -4.56000000E-06  -1.28700000E-05  +5.99000000E-05  +8.35000000E-05  +1.76600000E-04
   +5.22130000E-04  +1.16460000E-04  -1.52670000E-04  -1.78070000E-04  +3.47500000E-05
   -2.75900000E-05  +8.07800000E-05  -4.13500000E-05  +5.22500000E-05  +4.06700000E-05
   +2.48300000E-05  -4.61900000E-05  -4.52000000E-06  +5.19712000E-03  +9.25240000E-03
   +2.34120000E-04  +4.03140000E-04  +2.22320000E-04  +2.13520000E-04  +2.27500000E-05
   -4.62800000E-05  -2.08100000E-05  -3.99690000E-04  +3.25220000E-04  -1.14805000E-03
   +2.06480000E-04  -1.49200000E-04  -1.01770000E-04  +1.94790000E-04  +1.69930000E-04
   -4.61400000E-05  +9.52900000E-05  +1.65170000E-04  +2.39250000E-04  -1.40540000E-04
   -2.29360000E-04  -1.88630000E-04  +5.98410000E-04  +6.04970000E-04  -3.33200000E-04
   -1.04310000E-04  -1.48360000E-04  +2.17000000E-06  -1.14047000E-01  -1.15139790E-01
   +1.66243000E-03  +6.08200000E-05  -5.75500000E-05  -2.50800000E-05  +1.73500000E-05
   +2.36700000E-05  +7.17000000E-06  +4.74000000E-06  -8.65000000E-06  -1.00900000E-05
   -2.46940000E-04  -5.87600000E-05  +1.84170000E-04  -3.42000000E-06  +3.48000000E-06
   +5.09900000E-05  -6.93000000E-06  +3.22400000E-05  +1.93000000E-06  +1.23830290E-01
   +4.38220000E-04  +1.44000000E-06  +8.93700000E-05  -1.92515000E-03  -2.16985000E-03
   +3.41970000E-04  +2.27220000E-04  +1.29420000E-04  -8.87700000E-05  +2.15000000E-05
   +5.27300000E-05  -2.85900000E-05  -2.20600000E-04  -1.36830000E-04  +1.89500000E-05
   +5.62000000E-05  +1.42900000E-04  -2.26400000E-05  -9.76528000E-03  -1.62973000E-02
   -3.94400000E-04  -3.18570000E-04  +5.04150000E-04  -1.78375000E-03  +1.80290000E-04
   +9.82200000E-05  -3.26500000E-05  +1.76729000E-03  -9.75140000E-04  +3.01248000E-03
   -3.42500000E-05  +2.27970000E-04  +2.36050000E-04  +7.47600000E-05  -7.42900000E-05
   +1.97440000E-04  +2.34850000E-04  +2.58980000E-04  +5.85200000E-05  -2.21220000E-04
   -1.60550000E-04  +2.76980000E-04  -3.35340000E-04  -7.35580000E-04  -6.50750000E-04
   -2.78400000E-04  -3.94400000E-04  +3.91500000E-05  -1.15273890E-01  -2.44562890E-01
   +1.60196000E-03  +5.73900000E-05  +4.14400000E-05  -9.70000000E-06  +3.85300000E-05
   +5.05300000E-05  +1.73300000E-05  -4.21200000E-05  -4.53100000E-05  -2.63800000E-05
   +5.38900000E-05  +2.89250000E-04  +2.12900000E-04  +6.79500000E-05  +1.33100000E-05
   +1.21430000E-04  -9.45500000E-05  -7.24000000E-05  +2.22800000E-05  +1.26823740E-01
   +2.65432870E-01  +2.97400000E-05  -1.61000000E-05  +6.09300000E-05  +5.84320000E-04
   +2.26820000E-04  +3.55530000E-04  +1.24490000E-04  -2.38400000E-05  +3.80000000E-05
   -1.12000000E-05  -3.06300000E-05  -1.69700000E-05  +1.06900000E-05  +8.09300000E-05
   -3.78500000E-05  -2.07000000E-06  +3.93000000E-05  -4.07500000E-05  +1.34508500E-02
   +2.03383000E-02  -1.32693000E-03  +9.51030000E-04  +1.66921000E-03  +6.55580000E-04
   -5.95500000E-05  -5.72800000E-05  +4.29100000E-05  -2.70690000E-03  +1.87299000E-03
   -4.11452000E-03  -1.03280000E-04  -5.56270000E-04  -9.25420000E-04  +9.02600000E-05
   -3.38700000E-05  +3.57470000E-04  -2.35430000E-04  -2.38850000E-04  -1.75600000E-04
   +3.75520000E-04  +8.43900000E-05  -1.64520000E-04  +4.92190000E-04  +1.09004000E-03
   +4.98250000E-04  +1.63770000E-04  +2.57540000E-04  +6.37100000E-05  +8.37940000E-04
   -7.47200000E-04  -4.74630000E-02  -1.48000000E-06  -3.13600000E-05  +3.85000000E-06
   -9.42000000E-06  +7.50000000E-06  -2.83400000E-05  +3.11800000E-05  +2.15100000E-05
   -8.10000000E-07  +2.86900000E-05  +5.07100000E-05  +6.11090000E-04  -1.13280000E-04
   +7.66800000E-05  +9.11000000E-06  +9.64300000E-05  +7.52000000E-05  -1.62000000E-05
   +3.50800000E-04  -2.96684000E-03  +5.09184800E-02  -9.02930000E-04  +8.40830000E-04
   -4.64760000E-04  +7.30810000E-04  -6.54500000E-04  -3.45350000E-04  +8.79700000E-05
   +1.20270000E-04  +7.39700000E-05  -1.63000000E-05  -7.97800000E-05  +5.40600000E-05
   +4.01200000E-05  +2.68610000E-04  -3.59560000E-04  +7.81100000E-05  -9.12400000E-05
   +3.41900000E-04  -2.26940000E-04  -6.12243000E-03  -9.28629000E-03  -8.04410000E-04
   +1.37206000E-03  -1.67546000E-03  -1.26890000E-04  -1.72800000E-04  +1.49140000E-04
   +2.99000000E-05  +6.52000000E-06  +1.81460000E-04  -2.68740000E-04  -3.56540000E-04
   +9.04350000E-04  -5.32700000E-05  +3.44600000E-05  -1.80200000E-04  +2.31400000E-05
   -5.38300000E-05  +2.60200000E-05  +1.86000000E-05  +5.73600000E-05  -5.17600000E-05
   -4.95300000E-05  -8.30400000E-05  -1.10790000E-04  +3.39600000E-05  +7.93200000E-05
   -4.53200000E-05  -4.90622400E-02  +1.15131000E-02  +2.42705600E-02  +7.71900000E-05
   -1.52570000E-04  +1.27130000E-04  -4.07000000E-06  -3.07900000E-05  +9.26000000E-06
   +2.90000000E-07  -1.60000000E-06  +1.50700000E-05  -1.70700000E-05  -1.61790000E-03
   +4.08400000E-05  -6.97000000E-06  -1.24400000E-05  -3.94700000E-05  +8.50000000E-07
   +3.19000000E-06  -1.21100000E-05  +1.76223000E-03  -6.84376000E-03  -1.59391700E-02
   +5.15969500E-02  +1.07803000E-03  -3.89780000E-04  -4.97930000E-04  -2.81230000E-04
   +9.43720000E-04  -8.47390000E-04  -2.72950000E-04  -3.27200000E-05  +4.18600000E-05
   -5.03000000E-06  +2.12300000E-05  -2.80400000E-05  +3.51000000E-06  -1.16400000E-04
   +8.14200000E-05  -4.86800000E-05  -1.69730000E-04  +1.35550000E-04  -3.51990000E-03
   +1.05109300E-02  +1.60590900E-02  +9.65230000E-04  -2.16741000E-03  +2.33393000E-03
   -3.05800000E-05  +2.05600000E-05  -1.48700000E-05  -2.93910000E-04  +7.57570000E-04
   -7.96730000E-04  -5.69290000E-04  -1.66984000E-03  +2.06760000E-04  -3.34500000E-05
   -7.46600000E-05  +1.12110000E-04  -1.43950000E-04  -7.91900000E-05  -1.66090000E-04
   +1.26830000E-04  +1.37540000E-04  +2.33000000E-06  -9.91300000E-05  -4.06200000E-05
   +9.16500000E-05  +7.46900000E-05  +9.40200000E-05  +9.64000000E-06  +1.17963800E-02
   -1.00863440E-01  -1.06455300E-01  -6.08400000E-05  +6.70800000E-05  -3.59400000E-05
   -1.47000000E-05  -1.33300000E-05  -5.81000000E-06  +1.49400000E-05  -1.24900000E-05
   +2.60000000E-06  -1.72495000E-03  -3.06680000E-03  +7.96740000E-04  +3.64000000E-06
   +5.46000000E-05  -5.88600000E-05  +1.53000000E-05  +2.74000000E-06  -1.52000000E-06
   +4.99068000E-03  -1.14326200E-02  -2.43065900E-02  -1.35481900E-02  +1.10874650E-01
   +6.12290000E-04  -2.95720000E-04  -7.51730000E-04  +9.91910000E-04  -6.03180000E-04
   -3.14230000E-04  -7.76000000E-06  -6.40900000E-05  +1.33980000E-04  -2.14600000E-05
   -6.31000000E-06  +8.79400000E-05  -2.23180000E-04  -2.03800000E-05  -4.81110000E-04
   +1.70740000E-04  +1.32170000E-04  +6.27960000E-04  +3.23793000E-03  -1.23433100E-02
   -1.85600100E-02  -2.17089000E-03  +4.45870000E-03  -3.81562000E-03  +4.61000000E-06
   -6.80600000E-05  +2.33560000E-04  -6.80530000E-04  -9.20120000E-04  +2.60350000E-04
   -3.83450000E-04  -7.53700000E-04  -8.99070000E-04  +2.53780000E-04  +1.27350000E-04
   +6.57100000E-04  -6.83300000E-05  -1.39560000E-04  +7.12400000E-05  -6.45200000E-05
   -1.33520000E-04  +1.07430000E-04  +1.50770000E-04  +2.78200000E-04  -8.01700000E-05
   -5.09000000E-06  +1.85100000E-05  +9.93300000E-05  +2.38877300E-02  -1.04453850E-01
   -2.63084860E-01  +6.41400000E-05  -4.25400000E-05  +1.98470000E-04  +2.29500000E-05
   +2.86500000E-05  -1.85000000E-05  +2.42100000E-05  +2.27700000E-05  -2.51600000E-05
   +1.23120000E-04  +1.55100000E-04  +1.37137000E-03  -1.98400000E-05  -1.62120000E-04
   +1.44580000E-04  +9.72000000E-06  +1.68500000E-05  -6.30000000E-07  -3.47930000E-04
   +7.44150000E-04  +1.46825000E-03  -2.57938900E-02  +1.17203880E-01  +2.85638050E-01
   +2.15050000E-04  -3.18950000E-04  -2.31750000E-04  +3.22500000E-04  +4.00080000E-04
   -1.70382000E-03  -3.88740000E-04  +3.17900000E-05  +4.45280000E-04  +3.96900000E-05
   +5.98000000E-05  -2.09490000E-04  -1.25830000E-04  -2.98270000E-04  +3.75100000E-05
   -2.40000000E-07  +5.67600000E-05  +1.20000000E-07  -1.02177300E-02  +2.28822000E-03
   +1.66189000E-03  +7.03700000E-05  -3.00670000E-04  +8.15400000E-04  +1.14580000E-04
   +1.67030000E-04  -1.88200000E-05  +7.19700000E-04  -1.21094000E-03  +4.91220000E-04
   +1.53130000E-04  -1.93700000E-04  +1.34160000E-04  +1.58070000E-04  +2.30810000E-04
   -9.93400000E-05  +4.57500000E-05  +3.02200000E-05  +2.76250000E-04  -1.88100000E-04
   -1.84140000E-04  -8.84400000E-05  +3.74870000E-04  +3.62340000E-04  -2.95180000E-04
   -5.05000000E-06  -2.63500000E-05  -2.29900000E-05  -3.00521550E-01  +5.62217300E-02
   +3.61506500E-02  -8.67700000E-05  +1.73090000E-04  +8.33000000E-06  -8.30000000E-06
   +6.37000000E-06  +1.09000000E-06  -1.78000000E-06  +1.63200000E-05  -5.75000000E-06
   -1.10330000E-04  +6.87100000E-05  +4.41000000E-06  +1.65100000E-05  +7.46000000E-06
   +9.33000000E-06  -3.04400000E-05  +3.12100000E-05  +3.03000000E-06  -1.45570400E-02
   +3.71734000E-03  +2.37693000E-03  -1.84721000E-03  -1.69110000E-04  -2.80900000E-05
   +3.24306040E-01  +1.44220000E-04  +2.49220000E-04  +2.51830000E-04  -4.40600000E-04
   -3.17503000E-03  +3.53835000E-03  +1.07488000E-03  -1.26600000E-05  -6.40550000E-04
   +6.44500000E-05  -1.54900000E-04  +2.63120000E-04  +2.09840000E-04  +3.09950000E-04
   +7.26700000E-05  +1.19900000E-05  -1.32300000E-05  +6.26700000E-05  +1.94905700E-02
   -6.49249000E-03  -1.73928000E-03  -4.02380000E-04  +1.29320000E-04  -1.00227000E-03
   -1.77560000E-04  -1.72850000E-04  +5.92000000E-06  +1.03518000E-03  +6.96920000E-04
   -3.82640000E-04  -1.96640000E-04  -8.13500000E-05  +6.49500000E-05  -2.64990000E-04
   -1.28520000E-04  -3.21900000E-05  -9.69100000E-05  -2.01900000E-04  -2.26460000E-04
   +1.89410000E-04  +2.53650000E-04  +6.81100000E-05  -1.96680000E-04  -1.82060000E-04
   +3.05350000E-04  +1.38770000E-04  +2.27400000E-04  -1.44900000E-05  +5.47700700E-02
   -5.63400000E-02  -8.88889000E-03  +4.42400000E-05  -1.58740000E-04  -5.28900000E-05
   -1.15400000E-05  -3.99500000E-05  -9.29000000E-06  +2.25100000E-05  -6.58000000E-06
   +1.21800000E-05  +3.49740000E-04  -8.35100000E-05  -2.68220000E-04  +1.50500000E-05
   -6.54000000E-06  -6.09600000E-05  +2.03100000E-05  +6.28000000E-06  -1.21100000E-05
   -2.80933300E-02  +6.54863000E-03  +4.50799000E-03  +1.44072400E-02  -3.61300000E-03
   -1.61258000E-03  -6.15171700E-02  +6.11734500E-02  +4.76760000E-04  -2.33180000E-04
   -9.84840000E-04  -7.87360000E-04  +2.57211000E-03  -4.25617000E-03  -1.21646000E-03
   +1.88920000E-04  +8.74900000E-04  -9.02800000E-05  +1.30670000E-04  -2.47130000E-04
   -2.18410000E-04  -1.98120000E-04  -3.98370000E-04  +7.46000000E-05  +8.48100000E-05
   +4.25820000E-04  -2.43242600E-02  +5.93067000E-03  +1.70068000E-03  -1.12553000E-03
   +3.91380000E-04  +1.00584000E-03  +6.02600000E-05  +3.63700000E-05  +1.59100000E-04
   -1.61770000E-04  -7.83060000E-04  +9.44860000E-04  -1.01820000E-04  +1.61980000E-04
   +3.59010000E-04  -5.58300000E-05  +4.66200000E-05  -1.74600000E-05  +1.00210000E-04
   +6.80300000E-05  +9.72400000E-05  -1.01970000E-04  -7.58500000E-05  -9.31500000E-05
   +1.69000000E-04  -1.41480000E-04  -2.27040000E-04  -7.63800000E-05  -1.32320000E-04
   -2.29800000E-05  +3.72537700E-02  -9.09566000E-03  -5.08364900E-02  -4.18000000E-06
   +7.69600000E-05  +1.83990000E-04  +5.76000000E-06  +2.90000000E-07  +1.67200000E-05
   -2.09100000E-05  -2.47000000E-06  -4.66000000E-06  +2.69950000E-04  +9.22900000E-05
   -2.44890000E-04  -1.69200000E-05  +4.83200000E-05  -2.20500000E-05  -3.49800000E-05
   +2.19000000E-06  +7.06000000E-06  -7.87180000E-04  -2.41300000E-05  -8.67310000E-04
   +2.84772900E-02  -4.97045000E-03  -3.48426000E-03  -3.86631400E-02  +6.28227000E-03
   +5.61002000E-02  +4.13100000E-05  +1.45100000E-04  -8.14700000E-05  +4.35640000E-04
   -5.41350000E-04  +1.03710000E-04  -9.93390000E-04  +9.51020000E-04  +6.28550000E-04
   -4.35700000E-05  -1.37160000E-04  -1.72050000E-04  +1.74640000E-04  +2.42800000E-04
   +1.68600000E-04  -1.27200000E-05  -6.85300000E-05  -1.75000000E-05  -6.80910000E-04
   -2.04389000E-03  +2.94811000E-03  -7.18215200E-02  +3.98554000E-02  -6.93699500E-02
   -1.53910000E-04  -1.58270000E-04  -2.17000000E-05  +1.64130000E-04  +3.21560000E-04
   -1.52280000E-04  -6.47400000E-05  -1.63210000E-04  +9.91100000E-05  +7.07200000E-05
   +1.02680000E-04  +7.05500000E-05  +2.50000000E-05  -5.08200000E-05  -4.23700000E-05
   -8.23000000E-06  +2.90200000E-05  +4.06860000E-04  -5.26450000E-04  -1.40970000E-04
   -1.09389000E-03  +6.33400000E-05  +9.30700000E-05  +5.96200000E-05  +1.75880000E-04
   -1.85930000E-04  +2.77620000E-04  +3.39000000E-05  -1.25500000E-04  -9.23800000E-05
   +2.87000000E-06  -8.85000000E-06  +1.60000000E-07  +5.58000000E-06  +5.18000000E-06
   +1.46800000E-05  +2.45100000E-05  +3.73000000E-05  +8.14300000E-05  +3.78100000E-05
   -1.46058000E-03  +3.33670000E-04  -1.68800000E-05  -1.43600000E-05  -1.46400000E-05
   -3.23600000E-05  +3.37990000E-04  -4.81000000E-05  +6.69190000E-04  +1.36150000E-04
   +2.45800000E-05  +4.47100000E-04  -1.62880000E-04  +3.48050000E-04  +7.61137000E-02
   -2.39230000E-04  -2.21000000E-06  +2.40300000E-05  -5.25600000E-05  +8.16440000E-04
   +9.41840000E-04  +1.29451000E-03  -3.52660000E-04  +1.17350000E-04  -9.80100000E-05
   -1.60850000E-04  -1.54160000E-04  -1.57200000E-05  -9.21200000E-05  -2.82800000E-05
   +3.37000000E-06  +1.72900000E-05  +3.69600000E-05  -6.94754000E-03  +1.09923800E-02
   -1.47415200E-02  +4.09520500E-02  -1.09398260E-01  +1.08047940E-01  -5.31800000E-05
   +5.30000000E-06  +1.67400000E-05  -1.44900000E-04  +7.46150000E-04  +1.05751000E-03
   -9.35300000E-05  +5.50000000E-07  -6.99600000E-05  +1.40650000E-04  +1.41520000E-04
   -3.45400000E-05  -9.98300000E-05  -9.59900000E-05  +1.92480000E-04  -5.10100000E-05
   -6.70200000E-05  -8.93400000E-05  -6.65400000E-04  -1.48639000E-03  -2.26900000E-04
   +7.46700000E-05  +1.17960000E-04  -2.45500000E-05  +1.86420000E-04  -2.11409000E-03
   -2.61765000E-03  -5.46900000E-05  +6.02100000E-05  +3.59600000E-05  -1.18100000E-05
   -2.24800000E-05  -5.81000000E-06  +2.06300000E-05  +1.17300000E-05  +4.20000000E-07
   +1.68700000E-05  +5.39500000E-05  +5.65500000E-05  -1.80228000E-03  -2.33166000E-03
   -4.81010000E-04  +1.16500000E-05  -1.41600000E-05  -4.40000000E-06  +2.55060000E-04
   +2.72590000E-04  -2.57690000E-04  -2.02640000E-04  +8.71680000E-04  -1.01177000E-03
   -1.02590000E-04  -1.57210000E-04  -5.67600000E-05  -4.49471400E-02  +1.19567940E-01
   +3.53400000E-05  -3.16000000E-06  +1.40440000E-04  -9.81440000E-04  +7.79580000E-04
   -3.29000000E-05  -5.67550000E-04  +6.91300000E-05  -6.77530000E-04  +1.76700000E-05
   -8.41100000E-05  +6.58370000E-04  +6.41100000E-05  -1.01800000E-05  -6.00550000E-04
   +4.76000000E-05  +2.95300000E-05  +7.53100000E-05  -7.95544000E-03  +1.43665100E-02
   -1.90489300E-02  -6.88014400E-02  +1.05372990E-01  -2.32807870E-01  +8.83300000E-05
   +1.87840000E-04  +2.51020000E-04  +7.41320000E-04  +1.04934000E-03  +1.86200000E-04
   -1.52620000E-04  -2.38480000E-04  -7.19900000E-05  +1.07640000E-04  +1.27970000E-04
   +8.28600000E-05  +6.57100000E-05  +1.27390000E-04  +2.89000000E-05  -3.05200000E-05
   -1.10880000E-04  +7.00130000E-04  +3.00160000E-04  +9.32550000E-04  -7.62330000E-04
   +1.98200000E-05  -2.25000000E-05  +9.00900000E-05  +1.14510000E-03  -4.39235000E-03
   -4.66040000E-03  -3.78900000E-05  +5.26300000E-05  +2.48580000E-04  +8.06000000E-06
   +1.50500000E-05  -5.00000000E-07  -9.13000000E-06  -1.46300000E-05  +1.20000000E-07
   +4.52500000E-05  +1.51360000E-04  +1.23580000E-04  +2.58610000E-04  +1.06390000E-04
   +1.48637000E-03  -3.19400000E-05  -2.37600000E-05  -1.36800000E-05  +1.25010000E-04
   -1.98930000E-04  +3.14240000E-04  -7.74490000E-04  +1.00246000E-03  -1.49317000E-03
   -4.05900000E-05  -7.94400000E-05  +2.63820000E-04  +7.52249400E-02  -1.17529040E-01
   +2.52396850E-01  +4.56900000E-05  -2.45460000E-04  +1.41550000E-04  -2.81700000E-05
   +5.18850000E-04  -2.53160000E-04  -4.31600000E-05  -4.21300000E-05  -1.22900000E-05
   +1.08400000E-05  -5.47400000E-05  -4.15700000E-05  -1.98500000E-05  +6.75600000E-05
   -1.98100000E-05  +7.65000000E-06  -3.59600000E-05  -1.18970000E-04  +1.16605000E-03
   +2.33905000E-03  -8.30850000E-04  -1.34195520E-01  -1.26899400E-01  +1.69255400E-02
   -2.83000000E-06  -5.37000000E-05  +1.72000000E-06  +3.26600000E-04  +1.39400000E-04
   +5.50900000E-05  +4.85410000E-04  +2.70510000E-04  +2.59440000E-04  -1.36630000E-04
   -1.77860000E-04  +1.70370000E-04  +5.32900000E-05  +1.63780000E-04  -2.54570000E-04
   +1.59210000E-04  +1.47710000E-04  +1.36220000E-04  +1.66890000E-04  +1.68100000E-04
   -2.19430000E-04  -8.23500000E-05  -1.40000000E-04  +3.86900000E-05  -1.63560000E-04
   -2.01260000E-04  +1.33420000E-04  +5.28400000E-05  -5.91100000E-05  +1.21000000E-06
   +1.55700000E-05  +2.05400000E-05  +9.44000000E-06  -2.11500000E-05  +1.00000000E-05
   +3.42000000E-06  +9.66000000E-06  -1.20500000E-05  -4.09900000E-05  -1.87940000E-04
   -8.74900000E-05  +1.23960000E-04  +4.60000000E-07  -5.86000000E-06  +1.34000000E-06
   +3.20400000E-04  +1.30560000E-04  -5.36170000E-04  +8.43500000E-05  +3.13500000E-04
   +3.25100000E-05  -8.34600000E-05  -1.66810000E-04  +2.90600000E-05  +6.39974000E-03
   +1.00487000E-02  -1.05408000E-03  +1.42613500E-01  +2.05890000E-04  +6.37000000E-05
   +7.14000000E-06  -1.73203000E-03  -1.91819000E-03  +1.09490000E-04  +2.42770000E-04
   -5.39400000E-05  -1.66990000E-04  +6.84700000E-05  +1.43210000E-04  +5.54200000E-05
   -1.91920000E-04  -1.44920000E-04  +6.42800000E-05  -2.01000000E-06  +7.19300000E-05
   +3.02300000E-05  -9.98343000E-03  -1.62197000E-02  +2.43603000E-03  -1.24539440E-01
   -2.29249100E-01  +2.55547600E-02  +1.63640000E-04  +1.00470000E-04  -5.84800000E-05
   +5.68010000E-04  -9.17320000E-04  -3.33462000E-03  -2.25180000E-04  -7.75430000E-04
   +6.33500000E-04  -2.59820000E-04  -1.23870000E-04  -2.13960000E-04  +1.78930000E-04
   +2.11280000E-04  -8.31100000E-05  -8.80000000E-06  -9.89700000E-05  -2.17700000E-04
   -1.01610000E-04  +1.65500000E-04  -1.61760000E-04  -2.28600000E-04  -3.44890000E-04
   +1.05600000E-05  +3.40510000E-04  +4.54720000E-04  +1.59560000E-03  +3.65300000E-05
   +5.63500000E-05  -8.03000000E-06  +1.83900000E-05  +4.52500000E-05  +1.82400000E-05
   -9.73700000E-05  -8.54700000E-05  -5.43000000E-06  +2.99200000E-05  +1.83700000E-05
   -1.23930000E-04  +1.87400000E-05  +2.65070000E-04  -2.59590000E-04  -2.33600000E-05
   -3.00300000E-05  +2.53200000E-05  -8.00000000E-06  +8.73280000E-04  -2.36950000E-04
   +3.63030000E-04  +2.31630000E-04  +6.50900000E-05  +9.56200000E-05  +1.08400000E-05
   -3.30800000E-05  -8.57601000E-03  -1.22072900E-02  +1.29446000E-03  +1.38371390E-01
   +2.48083680E-01  -1.18750000E-04  +1.49800000E-04  -3.68300000E-05  -4.26000000E-04
   -5.19280000E-04  +7.87770000E-04  +1.14710000E-04  +2.01200000E-05  +1.31300000E-04
   -2.06200000E-05  -1.31500000E-05  -7.99100000E-05  -7.57000000E-06  -1.17420000E-04
   +2.95800000E-05  -7.93000000E-06  +5.48400000E-05  +5.00700000E-05  -1.59274600E-02
   -2.16665100E-02  +2.16892000E-03  +1.78057600E-02  +2.81371700E-02  -5.10346600E-02
   +5.31200000E-05  +7.90300000E-05  -5.33000000E-06  +1.29355000E-03  -1.86537000E-03
   -4.97450000E-03  -5.11690000E-04  -1.23020000E-03  +5.50580000E-04  -3.66220000E-04
   -3.19100000E-05  -9.23400000E-05  +1.45220000E-04  +1.64830000E-04  -2.10220000E-04
   -2.65200000E-05  +1.43200000E-05  +3.89620000E-04  -1.70100000E-04  +6.31290000E-04
   -8.89640000E-04  -9.32300000E-05  -2.09820000E-04  +8.90600000E-05  -7.58300000E-04
   -1.65358000E-03  +1.05027000E-03  -2.39900000E-05  +5.78500000E-05  -1.85800000E-05
   +1.57600000E-05  +2.87300000E-05  +1.40300000E-05  -1.02340000E-04  -8.67000000E-05
   +5.12000000E-06  +1.16560000E-04  -6.22900000E-05  -5.30000000E-06  +1.94170000E-04
   -6.35600000E-05  +6.25130000E-04  -3.41500000E-05  -1.91600000E-05  +6.44000000E-06
   -5.32100000E-05  +3.88760000E-04  -1.01698000E-03  +2.04720000E-04  +1.63660000E-04
   +2.86430000E-04  +3.39000000E-05  +9.63500000E-05  -4.20500000E-05  +1.60774600E-02
   +2.10968500E-02  -2.60081000E-03  -1.99775300E-02  -2.69942100E-02  +5.78136700E-02
   -9.09000000E-06  -6.65800000E-05  -1.57710000E-04  +6.13920000E-04  -5.25610000E-04
   -3.61000000E-05  +3.54600000E-05  -2.52100000E-04  -8.69000000E-05  +2.58900000E-05
   +5.37800000E-05  +1.36800000E-04  -9.02800000E-05  -2.29470000E-04  -1.31480000E-04
   +7.44400000E-05  +1.60900000E-05  +1.01370000E-04  -2.33808000E-03  +1.10200000E-04
   -5.63840000E-04  -2.90955710E-01  +7.07558700E-02  +3.38873700E-02  +1.14230000E-04
   +1.72090000E-04  +3.79700000E-05  +5.72580000E-04  -7.25690000E-04  -2.51110000E-04
   +2.91180000E-04  +3.62350000E-04  +1.00120000E-04  -8.81500000E-05  -1.12750000E-04
   +7.21400000E-05  -5.49600000E-05  -1.04000000E-06  -1.69430000E-04  +1.52480000E-04
   +1.74230000E-04  +5.96800000E-05  +1.45250000E-04  -1.02320000E-04  -1.02670000E-04
   +4.61400000E-05  +3.65500000E-05  +7.80000000E-06  +3.78390000E-04  -4.44890000E-04
   -6.89190000E-04  -7.68400000E-05  +1.45730000E-04  +7.26700000E-05  -1.21100000E-05
   +5.31000000E-06  -1.81000000E-06  -9.54000000E-06  +2.77500000E-05  +5.59000000E-06
   +6.86000000E-06  -8.20000000E-07  -1.06100000E-05  -1.55100000E-04  +3.38000000E-05
   +3.40300000E-05  +1.66000000E-06  +1.91900000E-05  +4.20000000E-07  -1.63170000E-04
   +9.15700000E-05  +7.21400000E-05  +3.57120000E-04  -1.23390000E-04  -2.22000000E-06
   +4.14320000E-04  -1.77590000E-04  +2.30170000E-04  -8.43491000E-03  +1.42843000E-03
   +1.57797000E-03  -1.50128800E-02  +5.91959000E-03  +1.41886000E-03  +3.14136220E-01
   +1.22961000E-03  -6.43600000E-05  +2.58280000E-04  -1.51904000E-03  -2.94249000E-03
   -3.05278000E-03  +2.11000000E-06  +1.96780000E-04  -2.64540000E-04  -6.34000000E-06
   -2.52800000E-05  -6.20400000E-05  +1.68550000E-04  +3.24520000E-04  -1.04250000E-04
   -1.79400000E-05  -1.04060000E-04  -2.82680000E-04  +1.88168600E-02  -7.50699000E-03
   -3.51747000E-03  +6.95380800E-02  -6.61876000E-02  -8.62010000E-03  -1.73240000E-04
   -1.81470000E-04  +4.63000000E-05  +9.96970000E-04  +7.64000000E-04  +1.71880000E-04
   -3.25190000E-04  -1.77610000E-04  -2.28640000E-04  +1.63360000E-04  +2.43340000E-04
   -1.19170000E-04  -1.24200000E-05  -1.84480000E-04  +2.37870000E-04  -2.45290000E-04
   -1.25430000E-04  +7.83400000E-05  -2.41970000E-04  -1.38900000E-05  +7.79000000E-06
   +1.10090000E-04  +1.97570000E-04  -1.35400000E-05  +3.32500000E-05  +3.22880000E-04
   +1.13930000E-03  +5.82700000E-05  -1.64900000E-04  +1.74600000E-05  -3.70000000E-06
   -3.30400000E-05  -1.26800000E-05  +3.09500000E-05  +4.70000000E-06  +6.45000000E-06
   +2.77600000E-05  -9.79000000E-06  +5.08200000E-05  +4.19560000E-04  -3.29000000E-05
   +1.37050000E-04  +1.12500000E-05  -1.41200000E-05  -1.04800000E-05  -2.15260000E-04
   -1.80200000E-05  -6.66900000E-05  -1.84040000E-04  -1.68270000E-04  +1.60040000E-04
   -2.60660000E-04  +5.25310000E-04  -5.83900000E-05  +1.50104800E-02  -4.88089000E-03
   -2.71630000E-03  -2.53748400E-02  +9.34916000E-03  +3.04327000E-03  -7.73036400E-02
   +6.97916100E-02  +1.58500000E-03  -2.19730000E-04  +5.61050000E-04  -6.96290000E-04
   -2.76631000E-03  -4.55347000E-03  -8.68950000E-04  +3.36950000E-04  -8.01830000E-04
   +5.00900000E-05  -1.10890000E-04  +3.92340000E-04  +1.39400000E-04  +3.07210000E-04
   -4.45210000E-04  -3.44000000E-06  -1.21070000E-04  -3.30020000E-04  +2.56986600E-02
   -7.79698000E-03  -5.27373000E-03  +3.25792300E-02  -8.58558000E-03  -5.09263600E-02
   -4.32600000E-05  -3.38400000E-05  +1.62320000E-04  +2.24190000E-04  +1.08384000E-03
   +9.22340000E-04  -3.52850000E-04  +1.47500000E-05  -1.84810000E-04  +1.11940000E-04
   +1.22400000E-04  -1.51040000E-04  -4.20400000E-05  -4.60100000E-05  +2.01440000E-04
   -2.88000000E-06  -1.21570000E-04  -3.46700000E-05  +1.72210000E-04  -9.19500000E-05
   +2.72470000E-04  +4.83400000E-05  +1.11600000E-04  -3.31300000E-05  +1.30539000E-03
   -2.95760000E-04  +7.93940000E-04  +6.62900000E-05  -1.40810000E-04  +1.73180000E-04
   -2.52000000E-06  -1.53500000E-05  -6.64000000E-06  +4.06000000E-05  -1.10800000E-05
   -3.17000000E-06  +8.62000000E-06  -4.58300000E-05  -2.37200000E-05  -2.85230000E-04
   -1.44530000E-04  -1.37760000E-04  +1.99100000E-05  -7.87000000E-06  -1.06700000E-05
   +1.47000000E-05  +7.49200000E-05  -3.87000000E-06  -2.96170000E-04  +8.91700000E-05
   +4.23010000E-04  -5.78330000E-04  +1.13000000E-05  -8.44680000E-04  -2.59637700E-02
   +6.50924000E-03  +4.32032000E-03  +3.55215000E-03  -1.24864000E-03  -1.70839000E-03
   -3.63226100E-02  +1.31614900E-02  +5.66228100E-02  -4.69290000E-04  +2.30104000E-03
   -6.37860000E-04  +1.28384000E-03  -6.79748000E-03  -9.83865000E-03  -4.60484500E-02
   -1.70087200E-02  -3.72157600E-02  +5.37293000E-03  +6.07048000E-03  +5.32834000E-03
   +1.00949800E-02  +3.57522000E-03  -3.68903000E-03  -4.59520000E-04  -3.16170000E-04
   +1.69800000E-04  +8.89940000E-04  -7.32320000E-04  +1.77690000E-04  -7.26110000E-04
   +6.56990000E-04  -3.90650000E-04  +1.30906000E-03  +3.15824000E-03  +2.77406000E-03
   -1.24390000E-04  +8.60800000E-05  +1.09310000E-04  -6.07000000E-06  +3.11200000E-05
   -1.59300000E-05  +5.65900000E-05  +2.91200000E-05  +5.43900000E-05  -5.45100000E-05
   -5.78400000E-05  -1.82900000E-05  +6.38100000E-05  -1.85600000E-05  +1.47980000E-04
   +5.94000000E-06  -3.66700000E-05  -3.12900000E-04  +4.34100000E-05  +7.11300000E-05
   +2.06600000E-05  +1.35900000E-05  +1.65870000E-04  +1.58920000E-04  +7.79200000E-04
   -2.30154000E-03  -1.72166000E-03  -1.30500000E-05  -1.22300000E-05  -1.08000000E-06
   +7.70000000E-06  +7.77000000E-06  +5.63000000E-06  +1.76800000E-05  +2.95000000E-06
   +4.40400000E-05  -1.57330000E-04  -1.01800000E-05  +1.78550000E-04  +5.90000000E-07
   -1.14600000E-05  -7.14000000E-06  +8.14000000E-06  -2.94600000E-05  -1.89300000E-05
   +6.91200000E-05  -2.70500000E-05  +1.31630000E-04  -5.45800000E-05  +8.10000000E-06
   +1.10300000E-05  -1.87503000E-03  +1.09933000E-03  +4.50190000E-04  +3.70400000E-05
   -3.26800000E-05  +3.04000000E-05  +1.54460000E-04  -1.26220000E-04  +2.55320000E-04
   +3.62933100E-02  +1.08417000E-03  -1.98445000E-03  +2.16792000E-03  +1.95402000E-03
   +9.00732000E-03  +1.39204900E-02  -1.62606600E-02  -1.29674290E-01  -1.24094520E-01
   -3.67597000E-03  -1.40513000E-02  -2.98613800E-02  +3.44714000E-03  -1.36853000E-03
   +3.32655000E-03  -1.11030000E-04  -1.56310000E-04  +2.19050000E-04  -2.16220000E-04
   +3.01830000E-04  -8.26000000E-05  +1.04246000E-03  -2.97650000E-04  -4.24160000E-04
   -6.79150000E-04  -3.32720000E-04  -1.89140000E-04  +3.17100000E-05  -4.16000000E-06
   -2.19700000E-05  -1.80800000E-05  -2.86300000E-05  +3.22500000E-05  +4.17000000E-06
   +1.23500000E-05  +2.71900000E-05  -1.94900000E-05  -2.57200000E-05  -2.86700000E-05
   +3.54800000E-05  +1.10200000E-05  +4.09500000E-05  +8.93000000E-06  -1.10710000E-04
   -1.50170000E-04  +1.30200000E-05  +3.65200000E-05  +1.30300000E-05  -5.25900000E-05
   -2.04700000E-05  -8.71600000E-05  +1.23725000E-03  -1.33709000E-03  -1.66314000E-03
   +6.10000000E-06  -5.65000000E-06  -1.07000000E-06  +6.74000000E-06  -2.99000000E-06
   +5.56000000E-06  -5.75000000E-06  +4.71000000E-06  +1.45700000E-05  -1.21780000E-04
   +4.69500000E-05  +4.07000000E-05  -8.88000000E-06  -1.21200000E-05  -2.37000000E-06
   -1.59000000E-06  -3.24600000E-05  +1.61700000E-05  -3.43900000E-05  +1.40500000E-05
   -4.03000000E-05  +3.27900000E-05  -2.93100000E-05  -2.11600000E-05  +1.39711000E-03
   -4.08460000E-04  +9.31700000E-05  +3.81000000E-06  -2.19090000E-04  +3.91400000E-05
   -3.78900000E-05  -1.08730000E-04  +9.70600000E-05  +1.24643700E-02  +1.38085400E-01
   -1.83711000E-03  +3.75581000E-03  -2.01110000E-03  -2.74524000E-03  -1.46485400E-02
   -1.78780300E-02  -3.72309300E-02  -1.25798590E-01  -2.60764270E-01  -1.08850000E-03
   +1.95312000E-03  +3.80729000E-03  -3.16460000E-03  +2.62150000E-04  +1.56193000E-03
   +2.60070000E-04  +2.66730000E-04  +3.69560000E-04  +6.50030000E-04  -2.56800000E-04
   -7.22090000E-04  +6.87840000E-04  -1.75520000E-04  -5.28370000E-04  -4.07910000E-04
   -9.39830000E-04  -5.02650000E-04  +3.73800000E-05  +1.15290000E-04  +7.84600000E-05
   -1.61000000E-05  +2.08600000E-05  -2.30900000E-05  +2.39900000E-05  +4.92700000E-05
   +3.76700000E-05  +1.97100000E-05  +2.34800000E-05  +1.46100000E-05  -2.22600000E-05
   -4.97800000E-05  +5.45200000E-05  +4.30000000E-06  -1.07800000E-05  -2.23680000E-04
   -1.49000000E-05  -1.04500000E-05  +1.38400000E-05  -2.35920000E-04  +5.07700000E-05
   +1.83100000E-04  -2.25270000E-04  +6.62610000E-04  +8.04150000E-04  +1.20300000E-05
   +1.47000000E-06  -5.30000000E-07  +1.25400000E-05  +9.20000000E-07  -8.00000000E-08
   +3.69600000E-05  -9.82000000E-06  +2.29900000E-05  -5.82300000E-05  -5.96100000E-05
   +1.19170000E-04  +2.43000000E-06  -5.48000000E-06  -5.20000000E-07  +1.44800000E-05
   +4.58800000E-05  -3.16600000E-05  +7.87700000E-05  -3.32000000E-05  +1.01540000E-04
   -8.38700000E-05  +1.01220000E-04  -4.74100000E-05  +6.27980000E-04  -6.29670000E-04
   +1.05208000E-03  -1.16260000E-04  +1.18140000E-04  -5.41600000E-05  +2.16550000E-04
   -1.17390000E-04  +4.44890000E-04  +4.13417500E-02  +1.36388400E-01  +2.72423090E-01
   -3.11020000E-04  +8.38400000E-05  +2.26440000E-04  +1.14723600E-02  +1.33012000E-03
   -9.33410000E-04  +2.35490000E-03  +3.60963000E-03  -6.56690000E-03  -6.93474300E-02
   +4.61070100E-02  -8.09765000E-02  +4.79040000E-04  +4.09557000E-03  -2.27947000E-03
   +6.30740000E-04  -1.06992000E-03  -1.18750000E-04  +3.30820000E-04  -8.87590000E-04
   +1.85494000E-03  -1.98640000E-04  +5.05000000E-05  +1.54580000E-04  +1.44340000E-04
   +5.93380000E-04  +1.19991000E-03  -7.02600000E-05  -5.00600000E-05  -1.90000000E-06
   +2.43900000E-05  +7.85900000E-05  +6.99600000E-05  -2.11100000E-05  -5.39300000E-05
   +1.02080000E-04  -8.72900000E-05  -5.58600000E-05  -1.58760000E-04  +1.27120000E-04
   -7.33600000E-05  +4.57200000E-05  +4.32500000E-05  -6.18900000E-05  -6.52900000E-05
   +2.97200000E-05  +9.75000000E-06  +3.03200000E-05  +5.29610000E-04  -6.57200000E-05
   -2.29930000E-04  +7.61930000E-04  -1.07310000E-03  +4.24750000E-04  -9.92000000E-06
   -8.48000000E-06  -3.19000000E-06  +2.21000000E-06  +8.60000000E-07  +9.79000000E-06
   +1.48500000E-05  -4.17000000E-06  +2.58200000E-05  -6.40000000E-07  +1.30800000E-04
   +4.32000000E-05  -6.90900000E-05  -2.92000000E-06  +2.85900000E-05  -5.76000000E-06
   -6.50400000E-05  +5.60000000E-06  +9.90000000E-06  +2.72400000E-05  +1.24200000E-05
   +4.23100000E-05  -1.31270000E-04  +1.49570000E-04  +1.31000000E-06  +6.70000000E-05
   -9.20400000E-05  +1.36500000E-05  -4.92600000E-05  -3.18600000E-05  -2.20000000E-05
   +2.64200000E-05  -1.77600000E-05  -7.04675000E-03  -1.61156000E-03  +2.57391000E-03
   +6.04887300E-02  -1.38000000E-04  -7.33700000E-05  -3.78010000E-04  +2.74005000E-03
   -2.44364000E-03  -3.71423000E-03  +1.19485500E-02  -1.22745100E-02  +2.79087700E-02
   +4.53043200E-02  -1.16637440E-01  +1.04507070E-01  -4.90258000E-03  +8.80882000E-03
   -1.58870200E-02  +2.61660000E-04  -2.18554000E-03  -2.41020000E-03  -3.15900000E-05
   -4.21960000E-04  +1.22906000E-03  -3.83600000E-05  +7.19700000E-05  +1.06800000E-04
   +1.17186000E-03  +1.38441000E-03  +9.04350000E-04  -9.20800000E-05  -1.84440000E-04
   -6.18000000E-06  +1.59700000E-05  +2.66700000E-05  -3.46700000E-05  -2.70000000E-07
   +2.76400000E-05  -3.23000000E-05  -2.53200000E-05  -4.26600000E-05  +1.82500000E-05
   +1.47000000E-05  +3.88300000E-05  -1.14000000E-06  +7.67000000E-06  +4.90800000E-05
   +6.98700000E-05  +5.16400000E-05  +7.37000000E-05  -1.14500000E-05  +4.44570000E-04
   -1.47400000E-05  -2.13860000E-04  -1.50243000E-03  +8.97180000E-04  +1.19893000E-03
   -6.71000000E-06  -7.95000000E-06  -5.11000000E-06  +6.98000000E-06  +9.91000000E-06
   +1.56000000E-06  +2.57000000E-06  -2.25000000E-05  -7.87000000E-06  +3.29600000E-05
   -5.13600000E-05  -3.71000000E-06  +1.70300000E-05  +1.52700000E-05  -4.50000000E-06
   -3.17800000E-05  +8.52000000E-06  -2.24000000E-06  -1.14900000E-05  +9.69000000E-06
   +2.50600000E-05  +8.16000000E-05  -1.05770000E-04  +1.21850000E-04  -1.19400000E-05
   +1.88000000E-06  -3.85200000E-05  -1.89200000E-05  +1.54100000E-05  +4.47000000E-06
   +3.19400000E-05  -2.27800000E-05  -3.56200000E-05  -1.93251000E-03  +2.81230000E-04
   +4.50500000E-04  -5.31650900E-02  +1.22942310E-01  +2.40300000E-04  -2.79570000E-04
   +2.27410000E-04  -2.51611000E-03  -1.39446000E-03  +1.10885000E-03  +8.30840000E-04
   -3.80750000E-03  +4.89383000E-03  -7.91994500E-02  +1.07465220E-01  -2.42666050E-01
   -8.47728000E-03  +1.69852500E-02  -1.89095300E-02  +1.29190000E-04  -4.23285000E-03
   -2.44951000E-03  +1.48700000E-05  +2.92730000E-04  -4.22930000E-04  -4.08400000E-05
   -1.89500000E-05  -3.17100000E-05  -3.96000000E-06  -1.36923000E-03  +1.70852000E-03
   +3.17800000E-05  +2.95700000E-05  +1.59400000E-05  -2.49000000E-05  -6.43000000E-06
   -1.20800000E-05  +6.12000000E-06  +1.91000000E-05  +2.43700000E-05  +3.01000000E-05
   +3.85600000E-05  -8.51000000E-06  -1.15400000E-05  -6.79500000E-05  +5.48000000E-06
   +2.07900000E-05  +4.85100000E-05  -6.42300000E-05  -2.89400000E-05  -6.12400000E-05
   +1.30900000E-05  -1.41190000E-04  -2.78000000E-05  +4.34100000E-05  +5.13340000E-04
   +3.64130000E-04  +3.36686000E-03  +2.24000000E-06  +1.11900000E-05  -2.27000000E-06
   +3.29000000E-06  -2.13000000E-06  -1.91000000E-06  +2.71000000E-05  -1.06100000E-05
   +2.80800000E-05  -2.06500000E-05  +2.50400000E-05  +2.03600000E-05  -2.20900000E-05
   +3.50000000E-07  +1.46300000E-05  +1.64000000E-06  +8.76000000E-06  +5.63000000E-06
   +2.52100000E-05  -1.10000000E-05  +2.33400000E-05  -2.59700000E-05  +4.15700000E-05
   -1.89900000E-05  +8.98000000E-06  +1.62000000E-06  +3.40400000E-05  +5.93000000E-06
   -4.03000000E-06  +6.21000000E-06  -6.23000000E-06  +1.55100000E-05  +2.38900000E-05
   +2.21246000E-03  +6.99720000E-04  +5.28580000E-04  +8.73264200E-02  -1.14434700E-01
   +2.53887500E-01  +4.44377000E-03  +4.64096000E-03  +7.19700000E-03  +1.15941700E-02
   +1.77509000E-03  -2.58089000E-03  -3.38270000E-04  +1.21160000E-04  -4.47000000E-05
   +2.26910000E-04  +1.72730000E-04  -8.06540000E-04  +2.42484000E-03  -6.72390000E-04
   -4.52552000E-03  -4.03162800E-02  +1.26043500E-02  +1.83201400E-02  -3.67370000E-04
   -9.40900000E-04  -1.89459000E-03  +6.21770000E-04  -7.52900000E-05  +6.98300000E-05
   +6.17200000E-05  +5.64750000E-04  -2.73860000E-04  -1.08190000E-04  -7.84300000E-05
   +3.92400000E-05  +3.49700000E-05  -8.54700000E-05  +4.92200000E-05  +8.96300000E-05
   -2.32100000E-05  -7.04300000E-05  -4.02500000E-05  -6.34500000E-05  +1.54670000E-04
   -4.45000000E-05  -5.78900000E-05  -8.11400000E-05  +8.79000000E-06  +7.63500000E-05
   -7.46600000E-05  +3.20700000E-05  +2.50600000E-05  -3.38200000E-05  -2.12080000E-04
   +8.83500000E-05  -9.92100000E-05  +7.33640000E-04  -1.29104000E-03  +6.44590000E-04
   -3.01900000E-05  -1.60800000E-05  +1.61800000E-05  -6.12300000E-05  -7.00000000E-07
   -3.89000000E-06  +3.20000000E-06  +1.14320000E-04  -3.88600000E-05  -2.00000000E-08
   -8.10000000E-07  -1.65900000E-05  -1.86000000E-06  -1.44000000E-06  -8.23000000E-06
   +9.08000000E-06  -6.35000000E-05  +3.11400000E-05  +2.02300000E-05  +5.54300000E-05
   +9.25400000E-05  -1.06900000E-05  +1.04000000E-05  +2.57400000E-05  +2.23000000E-06
   +2.36600000E-05  -2.63000000E-06  +1.31600000E-05  -5.48900000E-05  -1.25200000E-05
   -8.90000000E-07  -1.39980000E-04  -1.67380000E-04  +4.61700000E-05  -1.99600000E-05
   +8.89400000E-05  +2.87430000E-04  -1.03210000E-04  -2.33000000E-04  +2.83508000E-02
   +3.06176000E-03  -1.18949500E-02  -2.90830800E-02  +3.91971000E-03  -1.97688000E-03
   +2.70418000E-03  -4.45200000E-05  -7.08500000E-05  +4.05010000E-04  +8.46160000E-04
   -2.36547000E-03  +2.15933000E-03  -4.98830000E-04  +9.32429000E-03  +1.71068300E-02
   +1.33577700E-02  -1.20506910E-01  -1.19211820E-01  -3.58280000E-04  -3.98990000E-04
   -1.20109000E-03  +4.62960000E-04  -2.90700000E-05  +7.41400000E-05  +5.43340000E-04
   +9.06180000E-04  -1.24594000E-03  -7.74000000E-05  -1.72570000E-04  +3.46600000E-05
   -3.87000000E-06  +5.31800000E-05  -7.28800000E-05  +1.94500000E-05  +2.85300000E-05
   -7.50000000E-07  -1.40500000E-05  -1.95300000E-05  +1.00000000E-05  -6.80000000E-07
   +1.58300000E-05  +2.00900000E-05  +2.06100000E-05  +3.68000000E-05  +2.19200000E-05
   +3.89500000E-05  +3.77400000E-05  -1.13000000E-06  -7.92000000E-05  +7.17500000E-05
   -9.07200000E-05  -1.36156000E-03  +8.25770000E-04  -1.02393000E-03  -1.11500000E-05
   +3.15000000E-06  -4.09000000E-06  +6.62000000E-06  +1.64000000E-05  -3.89000000E-06
   +3.69800000E-05  -4.64200000E-05  -3.40000000E-07  +6.88000000E-06  -2.19400000E-05
   +2.85000000E-06  +5.10000000E-06  +7.41000000E-06  -1.63000000E-06  -1.42500000E-05
   +7.94000000E-06  +6.83000000E-06  +3.98000000E-06  -2.62000000E-06  +4.16500000E-05
   +3.36800000E-05  -1.68900000E-05  +2.31400000E-05  -8.96000000E-06  +9.94000000E-06
   -2.48000000E-05  -3.18600000E-05  +7.15000000E-06  +2.03800000E-05  +3.23700000E-05
   -9.91600000E-05  -1.37630000E-04  -5.83300000E-05  +6.66000000E-05  -1.09570000E-04
   +1.61610000E-04  +6.54070000E-04  +8.43380000E-04  -1.77290200E-02  +1.25847160E-01
   -6.96180000E-04  +3.06985000E-03  +3.84772000E-03  -6.74090000E-04  +1.00604000E-03
   +8.91000000E-04  -5.75400000E-05  +3.11630000E-04  +2.42360000E-04  -8.82340000E-04
   +4.19242000E-03  -2.17952000E-03  +2.73652000E-03  -1.62782200E-02  -2.09687700E-02
   +1.70491300E-02  -1.20542250E-01  -2.75685480E-01  -6.74200000E-05  +3.44000000E-06
   +1.99280000E-04  -5.40100000E-05  +4.81100000E-05  -1.80600000E-05  +6.30100000E-05
   +1.41400000E-04  +1.55773000E-03  +6.54000000E-06  +1.15900000E-05  +1.82200000E-05
   -5.23400000E-05  -3.09400000E-05  -7.15600000E-05  -1.51400000E-05  +7.53600000E-05
   +2.91400000E-05  -1.30600000E-05  -1.18000000E-05  -4.48200000E-05  +1.37100000E-05
   -1.24300000E-05  +4.26900000E-05  +2.21300000E-05  -1.75300000E-05  +2.65000000E-06
   +1.27200000E-05  +4.00200000E-05  +1.70400000E-05  +9.13100000E-05  -3.97000000E-06
   -9.54000000E-06  -6.50000000E-06  -2.20420000E-04  +3.18774000E-03  +1.72000000E-05
   -4.10000000E-06  -1.02900000E-05  +4.24300000E-05  +1.40000000E-07  +9.27000000E-06
   +3.06300000E-05  -5.87500000E-05  +2.86200000E-05  -1.86100000E-05  +1.20500000E-05
   +3.72300000E-05  -5.30000000E-06  +6.00000000E-07  +3.72000000E-06  -5.12000000E-06
   +1.50700000E-05  +1.53000000E-06  -2.38000000E-06  -2.00500000E-05  +6.31000000E-06
   +1.09400000E-05  -1.82700000E-05  +1.26100000E-05  -1.64500000E-05  +1.40000000E-07
   +3.10900000E-05  -3.10000000E-07  +7.50000000E-06  +2.95000000E-06  +1.48100000E-05
   +2.76000000E-06  +2.86900000E-05  -9.27000000E-06  -1.40310000E-04  +5.67700000E-05
   -1.86750000E-04  -7.80120000E-04  -1.08791000E-03  -1.78352900E-02  +1.29456780E-01
   +2.88516940E-01  -4.36161100E-02  +2.25616000E-02  -3.17214400E-02  +2.67737000E-03
   -2.84308000E-03  +2.97423000E-03  +1.44420000E-04  +1.11147000E-03  -1.15000000E-06
   -5.27760000E-04  -3.10610000E-04  +6.56400000E-05  +1.11404900E-02  +3.40505000E-03
   +5.57000000E-04  +4.10716000E-03  +4.76278000E-03  -5.91157000E-03  +5.07200000E-04
   -5.47500000E-04  -5.76180000E-04  +6.90000000E-05  +1.32200000E-04  -1.05630000E-04
   -1.61090000E-04  +2.27149000E-03  -2.88694000E-03  -1.28350000E-04  +3.17100000E-05
   -1.98100000E-05  +6.98500000E-05  -4.54800000E-05  +2.32740000E-04  +3.56500000E-05
   -6.82000000E-06  -1.41990000E-04  -5.11300000E-05  -6.27900000E-05  +2.81100000E-05
   +2.11000000E-05  +1.85800000E-05  -5.09600000E-05  -8.43000000E-06  +1.83700000E-05
   +3.84000000E-06  +4.20800000E-05  +8.37300000E-05  -2.71900000E-05  -8.33600000E-04
   +6.56350000E-04  +4.06980000E-04  +1.31893000E-03  -2.28811000E-03  +1.64164000E-03
   -1.63500000E-05  -2.57700000E-05  +3.11000000E-06  +5.07000000E-06  -4.33000000E-06
   +1.01800000E-05  -1.61600000E-04  +1.81500000E-05  -9.31700000E-05  -1.98000000E-06
   +5.16000000E-06  -3.48400000E-05  +2.48000000E-06  +1.95000000E-06  -4.82000000E-06
   +3.75400000E-05  -1.07340000E-04  -9.48100000E-05  -1.81676000E-03  +1.44076000E-03
   +5.23460000E-04  +3.33100000E-05  -7.46600000E-05  -8.76600000E-05  +1.19800000E-05
   -1.79500000E-05  -9.04600000E-05  +1.56200000E-05  -3.16900000E-05  +2.10000000E-07
   -3.50000000E-05  -1.32400000E-05  -1.86300000E-05  +6.91390000E-04  -3.08600000E-05
   +2.06000000E-05  +7.16000000E-06  -4.66700000E-05  +1.07500000E-05  -7.66358000E-03
   -1.91822000E-03  +3.45120000E-04  +3.36729300E-02  +2.15327600E-02  -1.23648570E-01
   +1.16095960E-01  -2.72992000E-03  +7.53400000E-03  -1.36293700E-02  +3.21370000E-04
   -1.74365000E-03  -2.44179000E-03  -1.75970000E-04  -1.69840000E-04  -2.09690000E-04
   +2.22219000E-03  -1.60014000E-03  -4.30092000E-03  +5.78514000E-03  -1.47773400E-02
   +3.09940000E-02  -1.12150000E-04  +2.09610000E-04  +1.45380000E-04  -5.85600000E-05
   -1.04100000E-05  +1.00170000E-04  -2.98230000E-04  -2.72730000E-04  +5.19150000E-04
   +2.07900000E-05  +5.37000000E-06  -2.59000000E-06  +4.77100000E-05  -9.20900000E-05
   +1.50080000E-04  +1.67300000E-05  +1.71900000E-05  -5.18700000E-05  +1.49000000E-06
   -1.65700000E-05  +2.98200000E-05  -5.85000000E-06  +1.71000000E-05  -3.47600000E-05
   -2.44300000E-05  -1.40700000E-05  -2.73400000E-05  +7.30000000E-07  +3.60900000E-05
   -1.63100000E-05  +1.09968000E-03  -3.42740000E-04  +1.89490000E-04  +1.73504000E-03
   -1.38710000E-03  +1.30321000E-03  +7.95000000E-06  -1.07200000E-05  +6.50000000E-06
   -4.68000000E-06  -1.21900000E-05  +6.13000000E-06  -1.24670000E-04  +3.38800000E-05
   -6.49000000E-06  -3.85000000E-06  -1.15000000E-06  -1.39600000E-05  +8.98000000E-06
   -5.03000000E-06  -7.85000000E-06  -6.08700000E-05  -1.35810000E-04  +2.50100000E-05
   +1.38678000E-03  -6.77480000E-04  -6.00630000E-04  -3.48800000E-05  -7.26900000E-05
   -1.43110000E-04  -2.04800000E-05  +7.90000000E-06  +2.55200000E-05  +1.00000000E-06
   -6.52000000E-06  -8.86000000E-06  +3.88300000E-05  -1.76500000E-05  +2.11400000E-05
   -2.15550000E-04  +5.69870000E-04  -6.66620000E-04  +1.64000000E-05  +6.84600000E-05
   +1.69810000E-04  -1.85893000E-03  +2.42970000E-04  -2.28570000E-04  -2.90727800E-02
   +1.34114450E-01  -3.19253000E-02  +1.19820800E-01  -2.59958320E-01  -3.61008000E-03
   +1.70011000E-02  -1.92866700E-02  +1.23115000E-03  -4.48345000E-03  -2.66969000E-03
   +4.14800000E-05  -8.13500000E-05  +4.58490000E-04  +9.20600000E-05  -1.28613000E-03
   +6.43510000E-04  +8.01850000E-04  -3.05854000E-03  +3.99961000E-03  -1.19145000E-03
   +3.83170000E-04  -4.08280000E-04  +3.28150000E-04  -1.33930000E-04  +1.70930000E-04
   +1.61750000E-04  +1.97780000E-04  +2.87540000E-04  +2.24500000E-05  -1.35630000E-04
   +1.14410000E-04  -1.06670000E-04  +1.28000000E-05  -3.16320000E-04  +3.95700000E-05
   +4.79700000E-05  +9.98000000E-05  -1.13400000E-05  -1.56100000E-05  +1.49100000E-05
   -1.62800000E-05  -6.24600000E-05  +6.43300000E-05  +1.21500000E-05  -3.14200000E-05
   -2.96900000E-05  +1.04700000E-05  -1.18400000E-05  +2.12100000E-05  -7.00960000E-04
   -6.08700000E-05  -5.73480000E-04  -1.24700000E-04  +1.39620000E-04  +2.05840000E-04
   -5.41000000E-06  +1.24200000E-05  -5.16000000E-06  -7.79000000E-06  +8.76000000E-06
   -3.34000000E-06  +1.54330000E-04  +6.69500000E-05  +1.42300000E-04  -3.14900000E-05
   +1.05700000E-05  +4.77400000E-05  -1.52900000E-05  -9.30000000E-07  +5.78000000E-06
   +4.84300000E-05  -5.07700000E-05  -3.12100000E-05  +3.56770000E-04  +2.27630000E-04
   +1.20377000E-03  -7.72000000E-05  +1.39430000E-04  +5.90870000E-04  -5.78000000E-05
   +3.89800000E-05  +1.66960000E-04  -2.99200000E-05  -2.25400000E-05  -3.20100000E-05
   +8.88200000E-05  -1.15890000E-04  -9.04300000E-05  -5.71040000E-04  +8.24280000E-04
   -1.13282000E-03  -1.01740000E-04  +1.37570000E-04  +5.16000000E-05  +6.53000000E-05
   +1.22900000E-04  +1.22648000E-03  +3.55000800E-02  -1.27822460E-01  +2.73011120E-01
   +1.57620000E-04  -2.25500000E-04  +8.05600000E-04  -6.83900000E-05  -4.58000000E-05
   +1.96350000E-04  -1.27090000E-04  +1.11560000E-04  -2.20840000E-04  +6.33600000E-05
   -2.66400000E-05  +6.82540000E-04  +1.15686000E-03  -2.59095200E-02  +3.05354500E-02
   -2.96582000E-03  -3.64712000E-03  -7.08980000E-04  +1.86020000E-04  +1.77070000E-04
   -4.57800000E-05  -9.23600000E-05  -5.10000000E-05  +1.69200000E-05  -4.52222600E-02
   +4.59919800E-02  -9.79260700E-02  +1.95400000E-05  -6.88000000E-06  +3.46800000E-05
   -5.82700000E-05  -1.58610000E-04  +8.88800000E-05  +4.50400000E-05  +1.06020000E-04
   -6.70000000E-05  -1.12500000E-05  +3.41060000E-04  -3.25890000E-04  +1.58980000E-04
   -5.21390000E-04  +1.35200000E-04  +3.90310000E-04  +3.90070000E-04  -1.00110000E-04
   +1.46000000E-05  -4.58170000E-04  +6.93800000E-05  -1.15270000E-04  -4.21500000E-05
   +1.88200000E-05  +1.46955000E-03  +1.74187000E-03  -7.55120000E-04  -1.36700000E-04
   +1.47600000E-05  -3.89600000E-05  +2.13800000E-05  +6.73000000E-06  +1.75400000E-05
   +2.87300000E-05  -3.82200000E-05  +5.46700000E-05  -9.57000000E-06  +2.99800000E-05
   -3.24000000E-05  -1.87710000E-04  +7.57800000E-05  +1.53410000E-04  -9.11000000E-06
   -4.79500000E-05  +1.79400000E-05  +2.39600000E-05  +2.54000000E-06  -1.23900000E-05
   -2.55400000E-05  +4.09200000E-05  -2.32800000E-05  +4.38100000E-05  +1.09100000E-05
   -6.10000000E-06  -2.00000000E-06  -4.27600000E-05  -6.24000000E-06  -2.63900000E-05
   +4.03400000E-05  +9.91000000E-06  +8.56300000E-05  +4.71900000E-05  -1.72500000E-05
   -6.54100000E-05  -1.05580000E-04  -8.79320000E-04  +2.83800000E-05  +8.73600000E-05
   +8.09700000E-05  +4.33860000E-04  -1.02200000E-04  -3.17300000E-05  +4.48396600E-02
   -3.35750000E-04  +4.78580000E-04  +1.12383000E-03  -1.09440000E-04  -2.91630000E-04
   +9.08090000E-04  +2.14240000E-04  -4.89000000E-06  +3.61620000E-04  +1.58171000E-03
   +8.15410000E-04  -4.97600000E-04  +4.02671000E-03  -2.14475200E-02  +2.93323300E-02
   -4.35770000E-03  -3.86289000E-03  -8.42230000E-04  +2.69500000E-05  +3.37000000E-06
   -2.36100000E-04  +2.97300000E-05  -2.95500000E-05  +3.57100000E-05  +1.60325300E-02
   -1.73144960E-01  +2.16240220E-01  -9.90600000E-05  -7.88300000E-05  +1.21900000E-05
   +5.06900000E-05  +1.03790000E-04  +7.61300000E-05  -7.03000000E-05  -1.64220000E-04
   +1.07340000E-04  +5.45560000E-04  +8.40280000E-04  +5.06200000E-05  -3.31200000E-05
   +1.91130000E-04  -2.83650000E-04  -1.49940000E-04  -1.38770000E-04  +2.68300000E-05
   -2.44420000E-04  -7.66200000E-04  +4.00000000E-08  -1.17790000E-04  +5.13200000E-05
   +6.91700000E-05  +1.25294000E-03  +1.56412000E-03  -1.44457000E-03  -5.75200000E-05
   +1.46720000E-04  +6.81000000E-06  -2.90500000E-05  -9.75000000E-06  -4.68900000E-05
   -8.39000000E-06  +2.00000000E-08  -3.79000000E-05  +6.61600000E-05  -6.37400000E-05
   -7.71600000E-05  +6.19400000E-05  +7.43000000E-06  +3.70000000E-06  +2.14400000E-05
   +1.29000000E-05  -8.97000000E-06  -1.79100000E-05  -7.60000000E-06  -4.38300000E-05
   -2.12100000E-05  +2.48500000E-05  -4.56000000E-05  +2.37100000E-05  -2.09500000E-05
   -9.51400000E-05  +1.41200000E-05  +1.54300000E-05  -6.62000000E-06  -3.93600000E-05
   +1.43400000E-05  -4.13000000E-05  -4.35200000E-04  +1.03940000E-04  +6.96000000E-05
   -6.66880000E-04  -3.98410000E-04  -7.65850000E-04  +8.84500000E-05  +1.32800000E-05
   +1.44010000E-04  +5.67710000E-04  -8.06700000E-05  -1.51710000E-04  -1.81230800E-02
   +1.96079670E-01  +4.94120000E-04  -3.62090000E-04  -2.89970000E-04  -4.19130000E-04
   +6.67700000E-05  +4.83840000E-04  -4.47200000E-05  -4.09800000E-05  -9.69740000E-04
   +3.73390000E-04  -1.93365000E-03  +3.33609000E-03  -1.87057000E-03  +1.17863000E-03
   -3.98786000E-03  +6.40450000E-04  +2.13587000E-03  +1.19728000E-03  +1.35200000E-05
   +2.89500000E-05  -1.24270000E-04  +2.71400000E-05  -1.87000000E-06  +9.00000000E-06
   -6.48529100E-02  +2.43731920E-01  -3.58845520E-01  -1.27200000E-05  -2.14700000E-05
   -4.82800000E-05  +2.16200000E-05  +5.85900000E-05  -6.49800000E-05  -3.99000000E-06
   -8.34800000E-05  +6.10000000E-06  +1.15500000E-04  +2.77260000E-04  +1.16990000E-04
   -1.46530000E-04  +1.60690000E-04  -8.97000000E-06  -1.57650000E-04  -1.12920000E-04
   +8.43900000E-05  -5.88400000E-05  -2.06350000E-04  -5.30900000E-05  -6.90000000E-06
   +3.65000000E-06  +1.67300000E-05  -1.76643000E-03  -1.31533000E-03  -1.83090000E-04
   -5.21000000E-05  +5.97400000E-05  +1.70600000E-05  -1.93900000E-05  +5.71000000E-06
   -3.00800000E-05  -3.34000000E-06  -9.10000000E-07  -1.77400000E-05  +1.70900000E-05
   -6.64400000E-05  -1.57800000E-05  +1.31110000E-04  -2.26400000E-05  -7.66100000E-05
   +5.13000000E-06  +1.25900000E-05  -3.88000000E-06  -1.13300000E-05  +2.43000000E-06
   -1.37500000E-05  +4.50000000E-07  -3.34000000E-06  -1.11000000E-05  -9.58000000E-06
   -5.00000000E-06  -1.02900000E-05  +4.10000000E-07  +1.09700000E-05  -1.90000000E-07
   +1.01000000E-06  -5.08000000E-06  -2.42000000E-06  +2.10470000E-04  -5.66200000E-05
   -5.02400000E-05  -5.35590000E-04  +5.96910000E-04  -3.04700000E-04  -1.55080000E-04
   -3.49910000E-04  +2.85820000E-04  -1.34810000E-04  +2.39100000E-05  -5.73000000E-06
   +6.88106800E-02  -2.43441730E-01  +3.59276220E-01  +6.74800000E-05  +2.10850000E-04
   +2.45150000E-04  +5.64890000E-04  +6.90520000E-04  -1.97950000E-04  -1.17700000E-05
   +3.38560000E-04  -4.55900000E-04  +1.97161000E-03  -5.59810000E-04  +8.99460000E-04
   -2.50956500E-02  -2.74441200E-02  -1.89378000E-03  +7.90600000E-04  -1.60790000E-04
   -9.65060000E-04  -3.69950000E-04  -2.68820000E-04  +8.80200000E-05  +1.90830000E-04
   +2.99100000E-05  -3.99000000E-06  -9.28200000E-03  +2.21583000E-03  +1.89484000E-03
   -6.15000000E-05  -2.00160000E-04  +9.06000000E-06  +2.43000000E-06  -7.66600000E-05
   -2.65000000E-06  +3.24700000E-05  +8.84200000E-05  -5.21800000E-05  -1.16250000E-04
   -2.24110000E-04  +2.22100000E-05  +5.86700000E-05  +7.18600000E-05  +2.50500000E-05
   +2.01000000E-06  -7.84300000E-05  -4.76000000E-06  +1.67300000E-04  +2.95790000E-04
   -1.89800000E-05  +2.14120000E-04  +2.32500000E-05  -5.99900000E-05  -3.16264000E-01
   -2.16857550E-01  -6.49858000E-03  -1.12700000E-05  -4.46800000E-05  -7.75000000E-06
   +1.76800000E-05  +1.70900000E-05  +1.79500000E-05  -4.49000000E-05  +3.02000000E-06
   -4.35000000E-05  -3.32000000E-05  +2.30000000E-06  +6.01700000E-05  +9.80000000E-06
   +8.26000000E-06  -1.61100000E-05  -2.43600000E-05  +5.95000000E-06  -1.57000000E-05
   -5.23400000E-05  +2.58600000E-05  -1.66600000E-05  +6.60100000E-05  -6.08800000E-05
   +3.74000000E-05  -4.54400000E-05  +2.70300000E-05  +3.45900000E-05  -2.08400000E-05
   +1.13800000E-05  +2.68100000E-05  +5.66200000E-05  -6.02000000E-05  -4.83200000E-05
   -3.14170000E-04  -1.48480000E-04  +5.58800000E-05  -1.07110000E-04  +1.90790000E-04
   +1.02280000E-04  -1.47680000E-04  +6.74700000E-05  +2.25200000E-05  -2.10660000E-04
   -1.31980000E-04  +7.89300000E-05  +9.14400000E-05  +3.00000000E-04  -6.54640000E-04
   +3.48007720E-01  -1.71440000E-04  -6.54930000E-04  +1.78220000E-04  +3.81980000E-04
   -5.45400000E-05  -6.28900000E-05  -8.02700000E-05  -7.83200000E-04  -4.95000000E-05
   +1.17306000E-03  +2.88340000E-04  -6.92340000E-04  +1.94953300E-02  +1.04053300E-02
   +4.36960000E-04  +8.83470000E-04  +2.11140000E-04  +2.08900000E-05  +4.63200000E-05
   +9.61000000E-06  -1.03000000E-05  -4.77000000E-05  -1.71000000E-06  +1.05000000E-06
   +4.33146000E-03  +1.98885000E-03  -5.91200000E-04  -4.19000000E-05  +6.26700000E-05
   +9.62000000E-06  -7.75000000E-06  +2.40900000E-05  +2.50800000E-05  -9.83000000E-06
   -2.00200000E-05  +2.47400000E-05  +7.82700000E-05  +9.97900000E-05  -6.49000000E-06
   -2.06100000E-05  -1.01900000E-05  -2.11700000E-05  -2.46500000E-05  +2.34300000E-05
   -2.30100000E-05  -7.32800000E-05  -1.25500000E-04  +8.55000000E-06  -5.15800000E-05
   +4.80000000E-07  +1.47400000E-05  -2.68013320E-01  -2.60388260E-01  -1.35561400E-02
   +6.71000000E-06  +2.10600000E-05  +3.34000000E-06  -6.93000000E-06  -7.48000000E-06
   -7.38000000E-06  +1.52100000E-05  -1.06000000E-06  +1.53100000E-05  +1.14400000E-05
   -6.50000000E-07  -2.01700000E-05  -3.73000000E-06  -3.88000000E-06  +6.41000000E-06
   +9.90000000E-06  -1.18800000E-05  +5.38000000E-06  +1.53500000E-05  -4.11000000E-06
   +7.05000000E-06  -2.10900000E-05  +1.19800000E-05  -3.47000000E-06  +1.20100000E-05
   -3.20000000E-06  -1.07300000E-05  +1.23400000E-05  -1.21000000E-05  -9.92000000E-06
   -2.08600000E-05  +1.35800000E-05  +8.35000000E-06  -8.37000000E-05  -9.22600000E-05
   +1.54700000E-05  -1.22100000E-05  +1.55410000E-04  +7.49000000E-05  +1.50000000E-05
   +7.63200000E-05  +2.10300000E-05  -6.03000000E-05  -1.10560000E-04  +4.87000000E-06
   +2.90380000E-04  -1.18660000E-04  -1.94020000E-04  +2.42150910E-01  +2.48994030E-01
   +1.59410000E-04  +5.77790000E-04  +4.14400000E-05  +1.66850000E-04  -1.32450000E-04
   +1.38770000E-03  -1.25540000E-04  -4.88550000E-04  +2.08100000E-05  -3.82560000E-04
   -5.87810000E-04  +6.13380000E-04  +3.26101000E-03  +3.86285000E-03  -1.92492000E-03
   +1.49150000E-04  +1.65250000E-04  +2.04180000E-04  +5.54000000E-06  +1.89200000E-05
   -3.43460000E-04  +9.12000000E-05  -5.69400000E-05  +4.10000000E-05  +2.96911000E-03
   -3.41240000E-04  +1.33333000E-03  -6.07000000E-06  +2.00200000E-05  -8.68500000E-05
   +7.48100000E-05  +5.93400000E-05  +8.03300000E-05  -2.66200000E-05  -1.05630000E-04
   -1.65300000E-05  +1.45000000E-05  +3.08000000E-05  -3.30200000E-05  +1.75000000E-06
   +8.50000000E-05  -2.24500000E-05  -5.18300000E-05  -2.28000000E-05  +1.00500000E-04
   -2.44300000E-05  -4.22500000E-05  -1.51100000E-05  -1.23170000E-04  +4.35000000E-05
   +7.19500000E-05  -1.28223300E-02  -1.77096200E-02  -3.64702000E-03  -5.33000000E-06
   +5.32000000E-06  +9.45000000E-06  -1.87400000E-05  -6.31000000E-06  -4.27000000E-06
   -3.46400000E-05  +2.47000000E-05  -4.40100000E-05  +3.34200000E-05  -2.87700000E-05
   -6.65600000E-05  +1.46500000E-05  +3.17000000E-06  -3.26000000E-06  +7.62000000E-06
   -3.90000000E-07  -5.60000000E-07  -3.39500000E-05  +6.08000000E-06  -6.58500000E-05
   -4.78000000E-06  +2.20200000E-05  -5.76500000E-05  +2.96400000E-05  -5.65000000E-06
   -8.63300000E-05  +7.10000000E-07  +9.10000000E-07  +3.24000000E-06  -2.70100000E-05
   +9.00000000E-07  -5.13600000E-05  +5.58000000E-05  +6.08400000E-05  -1.28830000E-04
   +4.66880000E-04  +1.50280000E-04  -8.62910000E-04  -4.77380000E-04  -1.60980000E-04
   -3.34580000E-04  -6.51400000E-05  -6.36200000E-05  -1.22210000E-04  -4.82160000E-04
   +7.00500000E-05  +3.50410000E-04  +7.27217000E-03  +1.43201100E-02  +4.40365000E-03
   -5.17630000E-04  -1.16160100E-02  -8.42540000E-04  -1.07217930E-01  -5.26678200E-02
   -2.38454600E-02  +6.42410000E-03  +2.63881000E-03  +1.60431000E-03  -3.91480000E-04
   +3.88140000E-04  -4.86350000E-04  -6.72640000E-04  -5.70410000E-04  -1.31460000E-04
   -3.40300000E-05  +1.10280000E-04  -1.92471000E-03  -3.01555400E-02  -3.63878300E-02
   +3.86156000E-03  +7.87290000E-04  +8.85000000E-06  -2.17850000E-04  +7.83010000E-04
   +4.91910000E-04  -8.94500000E-05  -6.18174000E-03  +5.24468000E-03  +1.28577000E-03
   -1.16570000E-04  -5.79790000E-04  +7.34620000E-04  +1.95540000E-04  -9.46650000E-04
   +4.12320000E-04  +7.07470000E-04  +1.39665000E-03  -1.46980000E-04  +8.09900000E-05
   -9.90120000E-04  -3.70740000E-04  -4.61970000E-04  -5.87820000E-04  -7.58120000E-04
   -1.16184000E-03  -1.76069000E-03  +1.18130000E-04  +6.80660000E-04  +4.24020000E-04
   +4.12770000E-04  +5.38540000E-04  -2.02070000E-04  +1.33400000E-05  +9.91400000E-05
   +1.95140000E-04  +1.17620000E-04  -1.24840000E-04  -2.02250000E-04  -7.88100000E-05
   -3.14530000E-04  +2.85380000E-04  -5.31900000E-05  -2.94880000E-04  +2.84170000E-04
   +1.44400000E-04  -7.85200000E-05  -1.73730000E-04  +7.91000000E-05  -1.55527000E-03
   -9.12320000E-04  +7.69000000E-05  -2.89880000E-04  -8.61000000E-05  -4.55850000E-04
   +6.23200000E-05  -7.04490000E-04  +2.29930000E-04  -3.32200000E-04  -1.40160000E-04
   +5.91480000E-04  -1.92598000E-03  -5.72630000E-04  +7.13200000E-04  -8.65000000E-05
   -5.09690000E-04  -2.23110000E-04  +2.21100000E-05  +2.20460000E-04  +3.59390000E-04
   -6.35400000E-04  -7.67900000E-05  +1.33900000E-04  +2.37210000E-04  -4.85240000E-04
   +2.65700000E-05  -2.49240000E-04  +9.43430000E-04  +1.36430000E-04  -1.91470000E-04
   +4.31400000E-05  +7.85600000E-05  -1.30930000E-04  -2.23310000E-04  +9.00000000E-06
   +1.83046800E-01  -2.12813600E-02  -4.04256200E-02  -1.03230000E-03  -8.08082300E-02
   -1.54217430E-01  -8.43910000E-03  -1.66063800E-02  -3.63955600E-02  +1.01070500E-02
   +6.88520000E-04  +6.66900000E-04  +3.51885000E-03  -2.70012000E-03  +1.76895000E-03
   -6.33140000E-04  -3.38880000E-04  +1.05506000E-03  -5.92367000E-03  -8.39115000E-03
   -6.67482000E-03  +1.90146000E-03  +2.48490000E-04  -2.08986000E-03  -1.52977000E-03
   -4.32370000E-04  -1.65091000E-03  +6.26940000E-04  -1.02872000E-03  +2.27254000E-03
   -7.46000000E-06  -2.38910000E-04  +2.42720000E-04  +3.99860000E-04  +2.94800000E-05
   -1.73860000E-04  +2.33600000E-04  +4.51890000E-04  +5.68920000E-04  -1.07720000E-04
   -1.89400000E-05  -1.71360000E-04  -1.88780000E-04  -2.80310000E-04  +2.56260000E-04
   -3.67930000E-04  -5.41020000E-04  -6.68300000E-04  +6.54000000E-05  +1.24701000E-03
   -2.68505000E-03  +8.70960000E-04  +9.16830000E-04  -9.39210000E-04  +2.51270000E-04
   +1.29570000E-04  +6.60100000E-05  +4.02400000E-05  +3.40200000E-05  -7.85400000E-05
   -3.03300000E-05  +7.19300000E-05  -1.10320000E-04  -5.73300000E-05  +6.33100000E-05
   -9.34000000E-05  +8.74900000E-05  +3.62300000E-05  -5.89300000E-05  +1.24100000E-05
   +3.95350000E-04  +2.56475000E-03  -9.76700000E-04  +1.43570000E-04  +1.81570000E-04
   +8.34400000E-05  +5.21730000E-04  +1.34158000E-03  -5.33500000E-05  +2.27130000E-04
   +2.45550000E-04  -2.40080000E-04  +8.75330000E-04  +2.19022000E-03  +6.23180000E-04
   +6.50280000E-04  +1.37397000E-03  +1.19310000E-04  +4.40510000E-04  +1.53430000E-03
   -7.38240000E-04  +2.07466000E-03  -4.44190000E-04  -3.58920000E-04  +3.17028000E-03
   -7.38930000E-04  -1.33520000E-04  +9.24910000E-04  +2.98057000E-03  +1.11590000E-04
   +4.58500000E-05  +3.42500000E-05  -1.44700000E-04  -5.52630000E-04  +7.82800000E-05
   -2.39500000E-05  +8.04833800E-02  +3.63051940E-01  -1.89636200E-02  -3.02676000E-02
   +2.27173000E-03  +3.09210000E-04  +2.46321400E-02  -9.12868600E-02  +1.94656900E-02
   +3.55534200E-02  -2.24128000E-03  -2.06533000E-03  +8.47640000E-04  -3.63387000E-03
   -3.09180000E-04  +3.21330000E-04  -5.55769000E-03  +3.43630000E-04  -2.21740000E-04
   -2.93448000E-03  +4.72933000E-03  +4.88394000E-03  +2.21235000E-03  +1.08724000E-03
   -9.52630000E-04  +7.51500000E-05  +1.15830000E-04  +3.61950000E-04  +2.09584000E-03
   +1.09374000E-03  -8.75450000E-04  +1.32519000E-03  +9.92000000E-06  -1.96900000E-05
   -4.93780000E-04  +1.34590000E-04  +5.59410000E-04  -7.61200000E-05  -9.07900000E-05
   -2.75120000E-04  +3.33310000E-04  -1.64140000E-04  -2.08160000E-04  +1.28600000E-04
   -3.09600000E-05  +2.41910000E-04  -2.15610000E-04  +2.28620000E-04  +3.57990000E-04
   -1.25200000E-05  -5.88880000E-04  +4.35280000E-04  +1.52260000E-04  +1.36820000E-04
   -1.68770000E-04  +2.37237000E-03  -1.19500000E-05  -3.81600000E-05  -3.56000000E-05
   +5.73200000E-05  +7.01700000E-05  +1.52900000E-05  +1.58280000E-04  -9.41600000E-05
   +1.21670000E-04  -1.45400000E-05  -4.31700000E-05  +1.08800000E-04  -3.86000000E-06
   +1.25000000E-06  -1.22400000E-05  -4.11500000E-04  -8.45550000E-04  +1.90000000E-04
   +4.07260000E-04  +1.00900000E-05  +3.06820000E-04  -1.18980000E-04  -5.39650000E-04
   +1.95330000E-04  -2.52000000E-04  -5.21300000E-05  +6.08800000E-05  +1.65215000E-03
   +1.25950000E-03  -7.20910000E-04  +4.78280000E-04  +8.70110000E-04  +1.83320000E-04
   +6.50250000E-04  -9.04470000E-04  +1.97255000E-03  -2.42427000E-03  +5.85570000E-04
   +8.08620000E-04  +2.49567000E-03  -2.64610000E-04  +1.29150000E-04  +2.71490000E-04
   +8.73500000E-05  +2.90698000E-03  -2.42700000E-05  -5.72640000E-04  -6.54200000E-05
   +4.11300000E-05  +6.24400000E-05  -7.85890000E-04  +1.04747300E-01  -2.22884970E-01
   +4.94818700E-01  +2.69300000E-05  -5.92880000E-04  +2.83380000E-04  +3.09376000E-03
   -1.36892100E-02  +2.27453100E-02  -1.85890000E-03  -2.18415000E-03  -6.23570000E-04
   +3.20960000E-04  -3.41100000E-04  +6.26190000E-04  +2.96010000E-04  +1.94000000E-04
   -2.10110000E-04  -2.59270000E-04  +1.98430000E-04  -2.81570000E-04  -1.76960000E-04
   -1.76439000E-03  +1.95674000E-03  -4.85240000E-04  +1.78870000E-04  -5.81000000E-05
   -1.85830000E-04  -4.56800000E-05  +1.04510000E-04  -4.13680000E-04  +1.07060000E-04
   -5.50770000E-04  -1.54800000E-05  +1.20310000E-04  +1.00310000E-04  -1.59100000E-05
   +3.24000000E-05  -1.01600000E-04  -1.16770000E-04  -2.23350000E-04  -3.08400000E-05
   +7.19000000E-05  +1.25100000E-04  -1.05300000E-05  +1.41710000E-04  +1.40030000E-04
   +1.19380000E-04  +1.65430000E-04  +2.93590000E-04  -2.24400000E-05  -3.87050000E-04
   -2.07331000E-03  -4.13470000E-04  -1.46200000E-04  +2.58000000E-06  +1.25390000E-04
   -1.45900000E-05  -4.97500000E-05  -1.09700000E-05  +3.39400000E-05  +2.04800000E-05
   +1.82800000E-05  -2.23000000E-06  -1.16450000E-04  -1.00350000E-04  +7.72000000E-06
   -4.41400000E-05  +1.94000000E-06  +2.79300000E-05  +2.74600000E-05  -1.78800000E-05
   -1.68632000E-03  +2.25348000E-03  -3.03050000E-04  -1.68470000E-04  -1.82500000E-05
   -6.90000000E-05  +6.61730000E-04  +8.28470000E-04  -5.02200000E-05  +9.78600000E-05
   +7.92200000E-05  -3.20530000E-04  -7.12800000E-05  +1.28710000E-04  +4.31820000E-04
   -5.60000000E-06  +4.89800000E-05  +5.15900000E-05  +2.61000000E-06  +1.74400000E-05
   +1.38780000E-04  +2.02070000E-04  -8.35100000E-05  -4.60900000E-05  +7.29300000E-05
   -1.73500000E-05  +1.18400000E-05  +4.37040000E-04  -1.51030000E-04  -5.53990000E-04
   +5.58900000E-05  -3.16100000E-05  -2.44000000E-05  +3.23500000E-05  +4.53400000E-05
   -7.15300000E-05  -4.05441700E-02  +3.93488000E-02  -1.13139480E-01  +4.08051700E-02
   +1.74183000E-03  +1.02207000E-03  +9.72240000E-04  +6.68168000E-03  -2.08683000E-02
   +3.28098800E-02  -4.32985000E-03  -6.19087000E-03  -9.91360000E-04  +4.17860000E-04
   +1.37780000E-04  +1.38877000E-03  -1.95080000E-04  -4.40740000E-04  +1.95669000E-03
   -9.33100000E-05  +2.35360000E-04  -2.76650000E-04  -7.62600000E-05  +7.60970000E-04
   -7.46000000E-05  +4.50320000E-04  +8.76000000E-05  +3.72800000E-05  +5.07600000E-05
   +9.15000000E-05  -6.71480000E-04  +3.26670000E-04  -2.19090000E-04  -6.48400000E-05
   +4.00800000E-05  -3.80000000E-07  +4.90500000E-05  -2.25000000E-06  -4.29800000E-05
   -5.58000000E-05  -7.84800000E-05  -9.92000000E-05  -5.57000000E-06  +2.17400000E-05
   +7.45800000E-05  +2.32200000E-05  +1.63900000E-05  -7.23100000E-05  +6.34500000E-05
   +8.72600000E-05  +1.03790000E-04  -1.81600000E-05  +2.54310000E-04  +1.28791000E-03
   +4.04100000E-05  -3.12360000E-04  +3.98940000E-04  -8.23850000E-04  -3.03400000E-05
   -1.37300000E-05  -1.60000000E-07  -1.98500000E-05  +9.67000000E-06  +5.86000000E-06
   -6.77000000E-05  +3.94600000E-05  -2.41400000E-05  +1.65000000E-06  -4.33000000E-06
   -2.58800000E-05  -6.94000000E-06  +1.10400000E-05  -3.91000000E-06  +9.77950000E-04
   -2.76500000E-04  +1.05540000E-04  -3.43790000E-04  -1.91100000E-04  -2.53100000E-04
   +2.50300000E-05  -2.64150000E-04  -1.87220000E-04  -1.00880000E-04  -1.25030000E-04
   +4.91600000E-05  -8.84000000E-06  +3.41600000E-05  -2.55510000E-04  +5.80800000E-05
   -3.78500000E-05  -5.03600000E-05  +7.55400000E-05  +2.27010000E-04  -9.18000000E-05
   +6.44940000E-04  -2.09220000E-04  -2.81700000E-04  -2.69760000E-04  +1.08710000E-04
   -5.86900000E-05  -5.03790000E-04  -6.31750000E-04  -1.78365000E-03  +2.10000000E-07
   +1.28440000E-04  +1.39400000E-05  +9.42700000E-05  -6.02500000E-05  +2.49070000E-04
   +1.72375100E-02  -1.34858030E-01  +1.88087170E-01  -2.27646100E-02  +1.59846800E-01
   -1.42200000E-05  -2.83847000E-03  +4.05414000E-03  -2.86053000E-03  -2.44992000E-03
   -2.91768000E-03  +4.98600000E-04  +1.16963000E-03  +6.17670000E-04  +4.21360000E-04
   -1.63770000E-04  -8.00600000E-05  -3.19210000E-04  -1.12790000E-04  +3.42460000E-04
   +5.30200000E-05  +2.43900000E-05  -1.03006000E-03  -4.57720000E-04  -1.48850000E-04
   -2.94170000E-04  +2.40740000E-04  +1.47430000E-04  -2.26160000E-04  +1.16040000E-04
   +2.97200000E-05  -7.06100000E-05  -1.84320000E-04  +3.13540000E-04  +1.40400000E-05
   +3.67000000E-06  -1.15240000E-04  +1.09770000E-04  -4.78000000E-06  -9.50900000E-05
   +3.02300000E-05  +7.83600000E-05  +1.54970000E-04  -1.84500000E-05  +3.27000000E-06
   -7.71500000E-05  -5.16100000E-05  -7.30400000E-05  -8.38500000E-05  -5.58600000E-05
   -1.33630000E-04  -2.17070000E-04  +6.73000000E-06  -1.67700000E-04  +6.10620000E-04
   +3.98510000E-04  -9.69000000E-06  +9.40300000E-05  -1.33650000E-04  +7.15000000E-06
   +2.46600000E-05  +1.67100000E-05  -2.70400000E-05  -2.73900000E-05  -9.54000000E-06
   -4.22300000E-05  +4.17300000E-05  -6.04000000E-06  -2.21900000E-05  +4.55800000E-05
   -1.10600000E-05  -1.35600000E-05  -1.72600000E-05  +1.09100000E-05  -2.05750000E-04
   -4.12710000E-04  +6.71830000E-04  -3.21360000E-04  -3.29320000E-04  -3.62710000E-04
   -1.64370000E-04  -2.63780000E-04  -2.09370000E-04  -1.28380000E-04  -1.48790000E-04
   +1.55020000E-04  +2.31560000E-04  -1.24080000E-04  -4.87570000E-04  -5.56400000E-05
   -3.75300000E-05  +9.13500000E-05  -7.04900000E-05  -2.57820000E-04  +4.52740000E-04
   -2.67800000E-05  -1.54100000E-05  +3.01000000E-06  +1.46000000E-04  -6.52700000E-05
   -2.23000000E-06  -5.27970000E-04  +3.84200000E-04  -7.68820000E-04  -2.50500000E-05
   +1.19000000E-06  +3.77000000E-06  +2.28500000E-05  -5.74000000E-06  +4.22700000E-05
   -8.62619900E-02  +2.24818890E-01  -4.04712640E-01  +9.02950200E-02  -2.19853280E-01
   +4.04427150E-01
end_hess

