# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.18688740    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.23888805E+00  -5.65127829E-01  +1.96626199E+00
   006   +1.76473449E+00  +1.26492218E+00  +1.20050502E-01
   006   +3.58488523E+00  +1.56781969E+00  -1.75319734E+00
   006   +6.19364400E+00  -1.66459620E+00  +5.70423895E-03
   006   +4.42885708E+00  -2.01059577E+00  +1.90271154E+00
   006   -6.56998253E-01  +2.85203686E+00  +1.87592287E-01
   006   -5.95193715E-01  +4.54426147E+00  +2.54848451E+00
   008   +8.38787229E+00  -3.01228563E+00  -1.87651763E-01
   006   -2.96786968E+00  +1.10688873E+00  +1.13004444E-01
   006   -3.07492864E+00  -8.21126243E-01  -1.66985324E+00
   006   -5.16047876E+00  -2.38558383E+00  -1.88129074E+00
   006   -7.21785188E+00  -2.04509384E+00  -2.88280318E-01
   006   -7.15245108E+00  -1.34647077E-01  +1.50113032E+00
   006   -5.04769997E+00  +1.41189643E+00  +1.68604383E+00
   008   -9.31964788E+00  -3.52402867E+00  -3.99340110E-01
   006   -8.60001083E-01  +4.61314816E+00  -2.11532306E+00
   008   +5.04468396E-01  -9.06491616E-01  +3.84081349E+00
   001   -9.12758579E+00  -4.74642432E+00  -1.71719249E+00
   001   -5.18283092E+00  -3.87687082E+00  -3.28671720E+00
   001   -1.48147075E+00  -1.12917015E+00  -2.91726879E+00
   001   -5.04810758E+00  +2.86889153E+00  +3.11720781E+00
   001   -8.75415647E+00  +1.20314028E-01  +2.74465331E+00
   001   -2.64230494E+00  +5.64015444E+00  -2.01209358E+00
   001   +6.69855256E-01  +5.99565791E+00  -2.14826513E+00
   001   -8.46357982E-01  +3.56762941E+00  -3.88995611E+00
   001   -6.31619534E-01  +3.44373084E+00  +4.28345289E+00
   001   +1.13147964E+00  +5.66817882E+00  +2.52809659E+00
   001   -2.18887983E+00  +5.85195655E+00  +2.55974431E+00
   001   +3.32846732E+00  +2.94671334E+00  -3.23519700E+00
   001   +4.76347646E+00  -3.41808436E+00  +3.35691399E+00
   001   +8.51996818E+00  -4.20105844E+00  +1.16552206E+00
   001   +9.46895469E-01  -2.34913314E+00  +4.83311765E+00
   006   +5.77584662E+00  +1.46505673E-01  -1.84251578E+00
   008   +7.47326610E+00  +5.36131443E-01  -3.73316843E+00
   001   +8.86319953E+00  -6.02825889E-01  -3.49594575E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -4.00000000E-07  +5.70000000E-07  +4.30000000E-07
   -3.40000000E-07  -3.20000000E-07  +1.15000000E-06
   +7.80000000E-07  -5.80000000E-07  -1.00000000E-08
   -1.10000000E-07  -1.09000000E-06  +1.53000000E-06
   -6.00000000E-08  -4.30000000E-07  +2.80000000E-07
   +3.10000000E-07  -1.00000000E-07  -2.70000000E-07
   +1.60000000E-07  +4.60000000E-07  -3.20000000E-07
   -5.50000000E-07  -5.30000000E-07  +1.44000000E-06
   +1.70000000E-07  +2.20000000E-07  -5.60000000E-07
   -1.50000000E-07  +0.00000000E+00  -5.30000000E-07
   +1.10000000E-07  +2.30000000E-07  -2.00000000E-07
   -3.70000000E-07  +7.60000000E-07  -5.40000000E-07
   -4.00000000E-07  +6.60000000E-07  -9.20000000E-07
   +1.00000000E-07  +4.40000000E-07  -3.00000000E-07
   -4.00000000E-08  +4.50000000E-07  -4.20000000E-07
   +7.70000000E-07  -2.70000000E-07  -3.60000000E-07
   -1.19000000E-06  -2.30000000E-07  -1.80000000E-07
   -3.70000000E-07  +7.90000000E-07  -7.00000000E-07
   +1.00000000E-08  +1.00000000E-07  -1.30000000E-07
   +2.30000000E-07  -1.40000000E-07  +2.00000000E-08
   -2.50000000E-07  +7.20000000E-07  -8.60000000E-07
   -3.50000000E-07  +1.00000000E-06  -1.00000000E-06
   +7.20000000E-07  +5.00000000E-08  -7.90000000E-07
   +7.80000000E-07  -2.20000000E-07  -4.50000000E-07
   +6.30000000E-07  -4.00000000E-07  -4.40000000E-07
   +4.00000000E-08  +4.30000000E-07  -4.10000000E-07
   +0.00000000E+00  +3.00000000E-07  -3.80000000E-07
   +6.00000000E-08  +2.10000000E-07  -6.30000000E-07
   +5.80000000E-07  -6.40000000E-07  +1.70000000E-07
   -8.20000000E-07  -6.00000000E-08  +9.40000000E-07
   -3.80000000E-07  -6.40000000E-07  +1.25000000E-06
   -4.90000000E-07  +8.00000000E-07  +6.70000000E-07
   +1.20000000E-07  -2.20000000E-07  +2.30000000E-07
   +3.10000000E-07  -1.02000000E-06  +1.09000000E-06
   +3.90000000E-07  -1.29000000E-06  +1.22000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.83698920E-01  -1.77439150E-01  +4.54094840E-01  -1.40968800E-01  -2.06538230E-01
   +5.20908280E-01  -1.24780180E-01  +6.95862300E-02  -4.01620400E-02  +5.41658560E-01
   +2.57298700E-02  -1.85782340E-01  +1.14160040E-01  -1.27056230E-01  +4.16988040E-01
   +1.14960600E-02  +7.93993100E-02  -1.79526310E-01  -1.43330490E-01  -1.83342710E-01
   +5.21753120E-01  +4.59419900E-02  -5.93901900E-02  +3.71555900E-02  -2.11412400E-01
   +2.57192300E-02  +9.59406900E-02  +5.84154740E-01  -2.75187400E-02  +1.30077700E-02
   +1.20952400E-02  -1.07158700E-02  -9.90434700E-02  +6.04202800E-02  -1.86520660E-01
   +4.54869860E-01  -6.09470000E-04  +3.81646400E-02  -4.13480200E-02  +1.40713820E-01
   +3.05984300E-02  -2.11203860E-01  -1.47385620E-01  -2.41240020E-01  +5.49360960E-01
   -4.05824300E-02  +1.60729400E-02  +1.29849300E-02  -9.53220000E-04  -1.06385200E-02
   +1.42547700E-02  +7.91903000E-03  +1.79445400E-02  -2.60688900E-02  +5.95408910E-01
   -1.76239500E-02  +4.17992700E-02  -3.81305800E-02  -1.20066100E-02  -2.26759800E-02
   +3.76537100E-02  +5.20291500E-02  -2.65684500E-02  -7.56022000E-03  -1.74255810E-01
   +4.50322720E-01  +5.38993200E-02  -6.62331700E-02  +3.39736300E-02  +1.58848000E-02
   +3.70204200E-02  -5.72953300E-02  -6.80355200E-02  +2.06296400E-02  +3.34450500E-02
   -1.66509460E-01  -2.29110770E-01  +5.59731820E-01  -2.46905570E-01  +9.05295600E-02
   +4.35915500E-02  +1.05862300E-02  +4.59255500E-02  -5.86999800E-02  -5.30203600E-02
   +1.57606800E-02  +2.48687200E-02  -2.07128350E-01  +2.66361100E-02  +9.41854200E-02
   +5.79466230E-01  +1.38198160E-01  -1.65004320E-01  +9.78729000E-03  +1.57183600E-02
   -2.18516000E-02  +2.29795000E-02  +1.69276900E-02  -6.91907000E-03  -4.77926000E-03
   -2.02276000E-02  -1.03998800E-01  +7.62586400E-02  -1.89828620E-01  +4.39027870E-01
   -1.39586800E-02  +4.88135800E-02  -1.09445360E-01  -2.23883100E-02  -2.07103000E-03
   +2.79854000E-02  +2.41870500E-02  -4.25835000E-03  -1.40995800E-02  +1.51871710E-01
   +3.75480000E-02  -2.27511900E-01  -1.59658430E-01  -2.43112530E-01  +5.43266190E-01
   -1.94142000E-03  +8.88284000E-03  -7.59337000E-03  -1.39223370E-01  +4.20069600E-02
   +7.12372000E-03  -1.90045200E-02  +1.11174000E-02  +4.84924000E-03  -1.51694000E-03
   +3.65850000E-04  -7.71100000E-05  +2.37932000E-03  +2.73650000E-04  +1.66214000E-03
   +4.71817950E-01  +1.88987100E-02  -1.20000600E-02  +2.20743000E-03  +4.50004600E-02
   -1.04537220E-01  +6.75648000E-03  +7.68050000E-04  +5.68191000E-03  -4.58511000E-03
   +9.41400000E-05  -1.41302000E-03  +4.11550000E-04  +9.08160000E-04  +5.50250000E-04
   +3.83440000E-03  -2.70960000E-03  +4.75921940E-01  -1.90235100E-02  +1.08961400E-02
   +5.94300000E-03  +3.32211000E-03  +9.68741000E-03  -8.35880600E-02  +1.62919500E-02
   -1.26540000E-02  +3.80744000E-03  +7.17900000E-05  +5.21640000E-04  -1.62063000E-03
   +4.47190000E-04  +5.12631000E-03  -2.05455000E-03  -6.63130000E-04  +6.51117000E-03
   +4.77430850E-01  -8.07030000E-04  +2.94120000E-04  +7.26200000E-04  -3.56758000E-03
   +1.73998000E-02  +2.36156100E-02  -1.19659000E-03  +2.07130000E-03  -8.22920000E-04
   +5.22430000E-04  -5.50450000E-04  +4.46170000E-04  -1.55950000E-04  -9.90440000E-04
   -7.49600000E-05  -7.58822800E-02  +5.26550000E-04  +1.22375000E-03  +5.83242020E-01
   +6.30500000E-04  -4.05080000E-04  -1.01969000E-03  +6.93946000E-03  -1.63074100E-02
   -1.73125600E-02  -8.39600000E-04  -1.12010000E-03  +7.08620000E-04  -2.48160000E-04
   +2.88160000E-04  -1.93600000E-04  +1.89210000E-04  +8.89970000E-04  -1.09730000E-04
   -2.61424000E-03  -1.07533890E-01  -4.78209100E-02  -2.68153000E-03  +5.41394200E-01
   -2.69658000E-03  +1.44625000E-03  +1.92907000E-03  +7.01680000E-03  -6.74855000E-03
   -1.90839000E-03  -6.64250000E-04  +3.20800000E-05  -1.85910000E-04  +5.54100000E-05
   -4.42120000E-04  +5.34050000E-04  +8.68350000E-04  -1.81890000E-04  -4.06710000E-04
   -3.59338000E-03  -4.31833300E-02  -1.40530680E-01  -5.37743000E-03  -6.89542700E-02
   +5.17381800E-01  +8.94260000E-04  +2.60700000E-03  +2.10319000E-03  -4.03758000E-03
   -2.75220000E-04  +2.48093000E-03  +6.84682000E-03  -2.05374000E-03  +3.89820000E-04
   -2.37403470E-01  +9.50736300E-02  +5.06299900E-02  -3.30102300E-02  +2.43425800E-02
   +2.50487000E-03  +1.42299000E-03  -9.65760000E-04  +7.05570000E-04  -1.16550000E-03
   +4.83430000E-04  -5.69410000E-04  +3.21196670E-01  +4.71462000E-03  -2.19134000E-03
   +7.16723000E-03  +2.22616000E-03  +1.36964000E-03  -5.22073000E-03  -6.05336000E-03
   +2.63457000E-03  +7.30089000E-03  +1.22438400E-01  -1.28638750E-01  +7.48802000E-03
   +8.51550000E-04  +5.49928000E-03  -1.02040000E-04  -9.82030000E-04  +5.84920000E-04
   -8.19970000E-04  +8.51160000E-04  -3.82040000E-04  +3.89630000E-04  -1.82441230E-01
   +3.84407350E-01  -7.24570000E-04  +8.98446000E-03  -3.42567000E-03  -5.04330000E-04
   -3.15806000E-03  +2.77581000E-03  +5.13552000E-03  +4.04676000E-03  -4.65613000E-03
   +1.68169900E-02  +3.07723200E-02  -9.01494600E-02  +3.14567800E-02  -1.98108400E-02
   +3.75002000E-03  -2.35420000E-04  -1.73910000E-04  +1.31190000E-04  +2.81900000E-05
   -2.87900000E-05  -5.43700000E-05  -2.66643900E-02  -2.90978640E-01  +4.03258590E-01
   -3.87800000E-05  -9.42600000E-05  -3.76570000E-04  -3.42107900E-02  -1.14231000E-02
   +3.31843000E-03  -1.22629000E-03  +5.67490000E-04  -1.91098000E-03  -1.36900000E-05
   -2.19100000E-04  +1.43830000E-04  +4.15090000E-04  -3.29000000E-04  +9.60870000E-04
   -1.38256040E-01  -4.57724100E-02  +2.61073000E-03  -5.96000000E-04  -4.93594000E-03
   -4.53551000E-03  -1.65250000E-04  +4.92100000E-05  -5.69200000E-05  +5.64880780E-01
   +3.16159000E-03  +3.48600000E-05  -1.25539000E-03  +8.11567000E-03  +1.30111800E-02
   -8.43920000E-04  +1.28803000E-03  -2.12040000E-03  +6.43460000E-04  -3.54510000E-04
   +1.10789000E-03  -6.46770000E-04  -8.53580000E-04  -1.07740000E-04  +1.53280000E-04
   -4.27733000E-02  -1.10888430E-01  -1.20229100E-02  -1.63278800E-02  -1.50492400E-02
   -2.22954000E-03  +1.10281000E-03  -8.27630000E-04  +4.76300000E-05  +1.01772280E-01
   +4.63229500E-01  -4.38460000E-04  +4.91950000E-04  -4.80880000E-04  +3.18585000E-03
   +1.66862000E-03  -4.10700000E-04  +2.35480000E-04  -5.68540000E-04  +1.65520000E-04
   +3.86000000E-05  +2.25080000E-04  -2.91170000E-04  -1.21890000E-04  +1.29900000E-05
   +2.38370000E-04  +4.77392000E-03  -9.83680000E-03  -8.04035800E-02  -2.31448600E-02
   -1.78618600E-02  -3.09110000E-04  +2.84800000E-05  -5.22200000E-05  +4.96100000E-05
   -1.45438120E-01  +1.96025170E-01  +4.62965510E-01  -5.86440000E-04  -2.83710000E-04
   -7.11900000E-04  -7.37090000E-04  -2.44417000E-03  -1.72335000E-03  +4.34120000E-04
   -4.63240000E-04  -5.20700000E-04  +3.32300000E-05  -8.68500000E-05  +1.70310000E-04
   +3.23080000E-04  -5.89600000E-05  +3.33000000E-05  -1.04088000E-03  -2.07156000E-02
   -1.90762300E-02  -4.77187000E-03  -3.10672000E-03  +1.04213000E-03  -2.07520000E-04
   +1.17640000E-04  +1.37300000E-05  -1.19998370E-01  +5.10066000E-03  +3.53039000E-02
   +6.43411420E-01  -1.08671000E-03  -6.84170000E-04  +1.27493000E-03  +1.49410000E-04
   -4.30780000E-04  -9.18730000E-04  +1.59690000E-04  +3.28100000E-05  -3.58870000E-04
   +9.62200000E-05  -4.66300000E-05  -1.30000000E-06  +8.25000000E-05  +1.04680000E-04
   -1.24810000E-04  -7.29682000E-03  -1.60466900E-02  -1.20265100E-02  -2.36133000E-03
   -5.34490000E-04  +7.16550000E-04  -1.09450000E-04  +1.06900000E-04  -2.98200000E-05
   -4.31595200E-02  -2.07574110E-01  -1.05609290E-01  +1.39989760E-01  +4.69245290E-01
   -9.97530000E-04  -8.73080000E-04  +6.68470000E-04  -6.58190000E-04  -8.30110000E-04
   -1.65710000E-04  +3.31440000E-04  -2.02540000E-04  -6.99900000E-04  +2.22270000E-04
   -8.48900000E-05  +9.35600000E-05  +1.97100000E-04  -1.67870000E-04  -7.33700000E-05
   -5.65078000E-03  -2.46948000E-03  +3.02093000E-03  +8.84630000E-04  +3.50710000E-04
   -7.98000000E-06  -1.64840000E-04  +8.24100000E-05  -3.97700000E-05  -1.05980500E-02
   -1.33858550E-01  -1.91698020E-01  -1.71517800E-01  +2.24145500E-01  +4.60412730E-01
   +2.47210000E-04  -4.22200000E-05  +9.30200000E-05  +1.39390000E-04  -1.08360000E-04
   -2.87920000E-04  -2.83350000E-04  +2.93070000E-04  -4.80000000E-07  +2.05610000E-04
   -2.22200000E-05  -1.41480000E-04  -2.99970000E-04  +1.51510000E-04  +1.39420000E-04
   +3.55492000E-03  +4.64780000E-04  +1.79538000E-03  +4.16180000E-04  +3.39510000E-04
   +4.59240000E-04  -1.97930000E-04  +1.26770000E-04  +1.48600000E-05  +3.01178300E-02
   -5.02762700E-02  -6.18723500E-02  -2.61028560E-01  -1.01887910E-01  +2.73515200E-02
   +5.99068610E-01  +4.25300000E-05  +1.81000000E-04  +5.42500000E-05  +6.54450000E-04
   -8.97700000E-05  +2.71350000E-04  -2.15570000E-04  +2.64590000E-04  +3.13230000E-04
   -1.63590000E-04  +1.06840000E-04  -8.51800000E-05  -1.15780000E-04  +9.07200000E-05
   -1.67900000E-05  +6.33840000E-04  +7.77530000E-04  -5.68315000E-03  -1.13495000E-03
   -5.90480000E-04  +2.58340000E-04  +1.71360000E-04  -8.52800000E-05  +9.77000000E-06
   -1.29076800E-02  -3.03585100E-02  -2.80563100E-02  -1.48854920E-01  -1.81185600E-01
   -2.54970900E-02  +1.54951640E-01  +5.00625130E-01  -9.86700000E-05  +1.35330000E-04
   -3.37710000E-04  +6.99860000E-04  +3.05390000E-04  +6.09500000E-05  +9.74100000E-05
   -4.64600000E-05  +1.85430000E-04  -1.78140000E-04  +1.04600000E-04  -4.59000000E-06
   +9.97900000E-05  -5.71800000E-05  -9.73000000E-06  +1.92597000E-03  -4.34497000E-03
   -8.46250000E-04  -6.68420000E-04  -5.97290000E-04  +1.12340000E-04  +1.98510000E-04
   -1.55370000E-04  +6.47000000E-06  -2.61384400E-02  -5.33083000E-03  +1.88826900E-02
   -1.76599800E-02  -5.43760100E-02  -9.98750400E-02  -1.44120080E-01  +2.62902930E-01
   +4.64016330E-01  -6.07030000E-04  -3.39580000E-04  +4.73360000E-04  -2.23400000E-04
   +5.98350000E-04  -8.12800000E-05  +1.25070000E-04  -2.73100000E-04  +1.25560000E-04
   -5.38550000E-04  +5.55120000E-04  -2.04540000E-04  +1.55360000E-04  -2.37500000E-05
   -6.07200000E-05  -2.18437000E-03  -2.89710000E-04  +5.45100000E-05  +3.78080000E-04
   -1.94000000E-04  -2.98030000E-04  +7.46760000E-04  -5.08180000E-04  -8.50000000E-06
   -1.43682200E-02  +2.37351600E-02  +2.80082600E-02  -5.16104200E-02  -3.48056600E-02
   -1.07140000E-04  -2.27908360E-01  +3.83559600E-02  +1.34943120E-01  +6.11739930E-01
   +9.24300000E-05  -1.23590000E-04  +1.30000000E-04  +1.19090000E-04  +8.18790000E-04
   -2.68830000E-04  -1.85540000E-04  +5.49700000E-05  +3.19110000E-04  -3.93650000E-04
   +6.32610000E-04  -4.55230000E-04  -2.57990000E-04  +9.62800000E-05  +1.08820000E-04
   +1.45250000E-04  -7.51270000E-04  -9.53150000E-04  +2.71710000E-04  +8.62000000E-05
   +2.05500000E-05  +7.04460000E-04  -5.08230000E-04  +1.75500000E-05  +2.29488400E-02
   -2.46929800E-02  -3.17642600E-02  +5.44979000E-03  +4.04631000E-02  +3.30671600E-02
   -1.89482600E-02  -1.15671740E-01  -3.30747000E-02  +1.39849620E-01  +5.03380950E-01
   +2.10930000E-04  +5.37500000E-05  +1.21980000E-04  +2.62630000E-04  +3.61530000E-04
   -2.51130000E-04  -3.62330000E-04  +1.67600000E-04  +2.37510000E-04  -7.14000000E-05
   +3.00740000E-04  -3.33820000E-04  -3.22880000E-04  +1.26370000E-04  +1.00490000E-04
   +9.23120000E-04  -2.32570000E-04  -1.38457000E-03  +9.25300000E-05  -1.51100000E-05
   +2.99650000E-04  +2.39850000E-04  -1.81490000E-04  +1.12200000E-05  +2.77762700E-02
   -3.25646900E-02  -5.34006500E-02  +3.84809700E-02  +5.75447500E-02  +3.39824800E-02
   +8.04391200E-02  -6.84575800E-02  -1.83566600E-01  -1.44735510E-01  +2.40611430E-01
   +4.81663020E-01  -5.34200000E-04  -2.13700000E-04  +6.22940000E-04  -3.57060000E-04
   -4.69410000E-04  +1.12140000E-04  +2.07420000E-04  -8.10400000E-05  -2.61020000E-04
   +8.89800000E-05  -2.62570000E-04  +2.71340000E-04  +3.23840000E-04  -1.53800000E-04
   -2.11510000E-04  +2.86400000E-04  +7.96710000E-04  +4.01763000E-03  +1.89490000E-04
   +5.51530000E-04  +1.30900000E-04  -2.24980000E-04  +1.73270000E-04  -2.65000000E-05
   -4.77229800E-02  +3.02130000E-03  +3.62371200E-02  -1.78810300E-02  -2.62926800E-02
   -1.59999300E-02  +3.32135900E-02  +2.43661800E-02  +8.05902000E-03  -1.20442370E-01
   +2.06421700E-02  +5.05939500E-02  +6.49291210E-01  -5.05500000E-04  -2.32740000E-04
   +3.98490000E-04  -5.57300000E-04  -7.19700000E-04  +2.79410000E-04  +2.25030000E-04
   -1.47230000E-04  -3.82860000E-04  +1.56690000E-04  -4.22180000E-04  +3.75730000E-04
   +4.37930000E-04  -1.02140000E-04  -1.44710000E-04  -3.04780000E-04  +2.73706000E-03
   -2.71532000E-03  -4.32950000E-04  -5.40510000E-04  -1.03330000E-04  -4.10880000E-04
   +3.06790000E-04  -3.32900000E-05  -3.30861200E-02  +3.77963600E-02  +4.89249600E-02
   -2.53408600E-02  -4.62851000E-02  -2.59627300E-02  +5.78570700E-02  +1.40714800E-02
   -3.04535900E-02  -3.34618900E-02  -2.04993310E-01  -1.07451150E-01  +1.47968010E-01
   +4.70647850E-01  +3.11250000E-04  +1.46310000E-04  -4.94290000E-04  +8.41740000E-04
   +6.59390000E-04  -5.38300000E-05  +3.00360000E-04  -1.75690000E-04  +2.05100000E-05
   +7.11300000E-05  -1.53490000E-04  +1.61980000E-04  +4.78200000E-05  -4.84400000E-05
   -4.00100000E-05  +4.09774000E-03  -4.09907000E-03  +1.12383000E-03  -5.97660000E-04
   -6.55590000E-04  -2.09040000E-04  -1.31530000E-04  +9.96900000E-05  +9.53000000E-06
   +2.20415000E-03  +2.75174700E-02  +3.11790900E-02  -1.50503200E-02  -2.50443600E-02
   -1.78929000E-02  +3.99848400E-02  -9.83699000E-03  -2.55391200E-02  -1.13402000E-03
   -1.41269990E-01  -2.05487280E-01  -1.80554820E-01  +2.36276150E-01  +4.68599060E-01
   -3.96540000E-04  +4.92000000E-05  +4.36450000E-04  -1.08443000E-03  -1.80173000E-03
   +1.83140000E-04  -6.51330000E-04  +6.42200000E-04  +2.84700000E-05  +2.58900000E-05
   +1.16530000E-04  -2.66920000E-04  -3.10880000E-04  +2.15330000E-04  +1.74120000E-04
   -1.95039000E-02  -8.22890000E-04  +1.21356600E-02  -9.72960000E-04  -1.72280000E-04
   +1.22000000E-03  +4.64000000E-06  +2.38000000E-06  +2.78100000E-05  -2.41237290E-01
   -2.25933600E-02  +8.67501000E-02  +3.39648600E-02  +6.31712400E-02  +4.49157200E-02
   -6.42934000E-02  -1.80143300E-02  +2.02679400E-02  +3.42848000E-02  -5.29924300E-02
   -7.07637500E-02  -2.62188750E-01  -9.92661200E-02  +2.96926100E-02  +5.93439770E-01
   -3.43840000E-04  +2.53500000E-05  +8.46290000E-04  -1.34886000E-03  -2.22938000E-03
   +3.81200000E-04  -5.11610000E-04  +6.24440000E-04  -1.01440000E-04  +8.38400000E-05
   -1.15230000E-04  +4.65000000E-06  -4.58100000E-05  +6.16300000E-05  -1.04560000E-04
   -1.46153300E-02  +6.29010000E-03  +1.16718700E-02  -7.09400000E-04  -2.50530000E-04
   +7.00570000E-04  -1.65540000E-04  +1.41520000E-04  +1.93000000E-06  +2.49200700E-02
   -1.09555910E-01  -5.56425600E-02  +2.68192600E-02  +1.29748100E-02  -1.18196600E-02
   -1.63282600E-02  -8.37054000E-03  +5.51307000E-03  -1.24998300E-02  -3.36873300E-02
   -2.66215100E-02  -1.46494010E-01  -1.79714870E-01  -2.39193000E-02  +1.44971600E-01
   +5.01690960E-01  -3.07100000E-05  +1.99710000E-04  -5.53160000E-04  -1.88008000E-03
   -1.44730000E-03  +3.25310000E-04  -9.62000000E-06  +3.82700000E-05  -1.42860000E-04
   +8.59600000E-05  -3.13410000E-04  +3.00100000E-04  +2.69080000E-04  -4.22600000E-05
   +7.04400000E-05  +2.31560000E-04  +3.61935000E-03  +5.10839000E-03  -8.13240000E-04
   +8.45340000E-04  +2.19880000E-04  -3.41950000E-04  +2.24870000E-04  -1.41500000E-05
   +1.32498760E-01  -2.69651600E-02  -1.74523600E-01  +1.07571900E-02  -3.46942800E-02
   -3.13168900E-02  +2.17256100E-02  +6.91982000E-03  -1.03678000E-02  -3.19133800E-02
   -1.56645000E-03  +2.05571500E-02  -1.59750700E-02  -5.40218700E-02  -1.02226930E-01
   -1.39140240E-01  +2.58257330E-01  +4.81757360E-01  +2.44470000E-04  +1.60310000E-04
   -1.22470000E-04  +6.49900000E-05  -1.08640000E-03  +1.12660000E-04  +4.45200000E-05
   +1.71150000E-04  -4.07970000E-04  +6.62430000E-04  -8.08230000E-04  +4.39600000E-04
   +7.45200000E-05  +5.14000000E-06  -2.25800000E-05  +1.47854000E-03  +5.60520000E-04
   +6.93560000E-04  -5.69570000E-04  +3.37500000E-05  +2.93390000E-04  -1.02747000E-03
   +7.16860000E-04  -8.12000000E-06  -1.25170000E-03  -2.67107000E-03  -2.83515000E-03
   +2.38998000E-03  +3.29229000E-03  +6.23891000E-03  -4.30351200E-02  -3.37915500E-02
   +1.93180000E-04  -2.35189880E-01  -9.33032500E-02  +3.04450200E-02  -2.49890000E-03
   -1.39831900E-02  -7.26065000E-03  -9.15410000E-04  +7.59480000E-04  +4.20399000E-03
   +3.26778560E-01  +6.55400000E-05  +1.05310000E-04  -7.71300000E-05  +2.33000000E-05
   -9.14220000E-04  +5.89700000E-05  +7.24800000E-05  +1.01370000E-04  -3.33860000E-04
   +4.92950000E-04  -6.48390000E-04  +3.88310000E-04  +1.19750000E-04  +1.19700000E-05
   -2.01800000E-05  +1.10996000E-03  +1.58690000E-04  +1.21620000E-03  -4.10400000E-04
   -8.85000000E-06  +1.92890000E-04  -8.11550000E-04  +5.89600000E-04  -8.06000000E-06
   -3.01216000E-03  +6.62860000E-04  +3.45405000E-03  -2.43533000E-03  -3.56710000E-04
   -5.85539000E-03  -6.35055000E-03  +3.88269000E-03  -1.33435000E-03  -1.27721210E-01
   -1.46537640E-01  -1.97890500E-02  -4.06254200E-02  -2.96796600E-02  -1.02851800E-02
   +5.17494000E-03  +2.77379000E-03  -5.65535000E-03  +1.23185120E-01  +4.16701530E-01
   +1.33350000E-04  +9.24700000E-05  -1.77460000E-04  +1.09800000E-05  -1.75000000E-04
   +1.30480000E-04  +1.59100000E-05  +4.52000000E-05  -6.01000000E-06  +5.77500000E-05
   -1.06170000E-04  +6.32700000E-05  +1.23300000E-05  -2.41000000E-06  -3.06000000E-06
   -1.60410000E-04  +4.15490000E-04  +9.28500000E-05  -4.97200000E-05  -2.96400000E-05
   -1.59100000E-05  -1.03430000E-04  +7.16100000E-05  +8.87000000E-06  -2.97977000E-03
   +3.40376000E-03  +3.69709000E-03  +8.43930000E-04  -9.21715000E-03  -2.03504000E-03
   +2.60799100E-02  +1.55827600E-02  +8.08086000E-03  -3.30382000E-03  -4.19150300E-02
   -8.15142700E-02  -3.28112500E-02  -2.68173200E-02  +2.14334000E-03  +8.58733000E-03
   -2.81174000E-03  -2.95959000E-03  -6.94454600E-02  +3.03331030E-01  +3.66757890E-01
   -5.38871000E-03  +2.04641000E-03  +2.28949000E-03  -4.36828000E-03  +1.94661100E-02
   -2.37654600E-02  -2.55485000E-03  +1.50257000E-03  -6.39560000E-04  +2.41260000E-04
   -3.58330000E-04  +3.49630000E-04  +4.22350000E-04  +9.82530000E-04  -1.28263000E-03
   -7.49603600E-02  +1.89749000E-03  -1.98757000E-03  +5.57630000E-04  +6.50800000E-05
   -1.37344000E-03  -5.48030000E-04  +3.99500000E-04  -1.09500000E-05  -2.23910000E-03
   -1.84444800E-02  +2.17683900E-02  -5.94830000E-04  -9.74400000E-04  +8.51480000E-04
   -2.60190000E-04  +7.36280000E-04  +6.34900000E-05  +5.78090000E-04  +7.00050000E-04
   +4.21740000E-04  -1.10241000E-03  +1.49830000E-04  -1.30465000E-03  -6.27320000E-04
   -1.66223000E-03  -6.59220000E-04  -1.23289000E-03  -1.02363000E-03  -1.78670000E-04
   +5.86393080E-01  +2.50932000E-03  -1.46340000E-04  -9.61330000E-04  +6.77150000E-03
   -1.47685700E-02  +1.58864000E-02  +5.98290000E-04  -1.33162000E-03  -3.08510000E-04
   +1.66110000E-04  +1.37090000E-04  +4.00000000E-06  -1.81030000E-04  -4.91850000E-04
   +6.83510000E-04  +6.80934000E-03  -1.09516820E-01  +4.79252900E-02  -4.62340000E-04
   +1.05876300E-02  -1.37482900E-02  -3.31600000E-05  -3.34500000E-05  +3.33800000E-05
   -8.60766000E-03  -2.09471500E-02  +1.85952700E-02  -4.80190000E-04  -4.20710000E-04
   +1.24312000E-03  -8.52500000E-05  +8.08730000E-04  -8.70400000E-05  +1.56360000E-04
   +5.51090000E-04  +4.61690000E-04  -6.05820000E-04  -1.41590000E-04  -1.01123000E-03
   +1.46314000E-03  -9.93620000E-04  -5.99530000E-04  -5.54740000E-04  -5.22050000E-04
   -1.18930000E-04  +7.68347000E-03  +5.36066410E-01  +1.69218000E-03  -6.69360000E-04
   -5.05830000E-04  -4.47214000E-03  +1.47587000E-03  +8.85860000E-04  +7.65410000E-04
   -8.52630000E-04  -2.07060000E-04  -1.76810000E-04  +7.66600000E-05  +2.43470000E-04
   +1.91920000E-04  -1.51490000E-04  +1.76220000E-04  -6.73328000E-03  +4.43215200E-02
   -1.35333450E-01  -1.71982000E-03  +1.48088300E-02  -3.83516200E-02  +3.15860000E-04
   -1.85590000E-04  -6.67400000E-05  +7.47401000E-03  +7.82800000E-03  -1.81056000E-03
   -1.56905000E-03  -1.30508000E-03  -4.19540000E-04  +1.95720000E-04  -3.85000000E-06
   -1.39520000E-04  +1.77130000E-04  +2.21320000E-04  +2.96710000E-04  -2.72700000E-05
   -2.38490000E-04  -1.40610000E-04  -9.35030000E-04  -1.87660000E-04  -1.17850000E-04
   -5.44860000E-04  -4.40080000E-04  -1.29220000E-04  -1.15405900E-02  +6.48870200E-02
   +5.15165840E-01  -1.85487810E-01  +2.24366200E-02  +1.03139430E-01  +8.07422000E-03
   -4.18349000E-03  +3.57859000E-03  -3.47382000E-03  +4.83760000E-03  -6.60900000E-05
   +1.17629000E-03  +5.93591000E-03  -2.33700000E-03  -3.67075300E-02  -2.80883000E-03
   +4.15298500E-02  -2.62020000E-03  -1.33600000E-04  -1.43690000E-03  +1.36826000E-03
   +1.66060000E-04  +1.25253000E-03  -1.86565000E-03  +2.63410000E-04  +1.81323000E-03
   -2.32844000E-03  -8.07050000E-04  -2.50370000E-03  -2.66210000E-04  +1.85354000E-03
   +5.84590000E-04  -2.10150000E-04  -2.22700000E-05  +1.32850000E-04  +8.96190000E-04
   -2.75000000E-06  -1.41170000E-04  +8.27520000E-04  +7.04870000E-04  -2.29640000E-04
   -4.25800000E-04  +7.63100000E-04  -1.40279000E-03  -4.64330000E-04  -2.45150000E-04
   -1.61320000E-04  +5.55210000E-04  -8.29300000E-05  -2.01290000E-04  +2.85102520E-01
   -1.01705900E-02  -8.44403600E-02  +5.58764000E-02  -2.45217000E-02  -1.82535000E-03
   +3.12450800E-02  +7.36708000E-03  -2.52694000E-03  +2.29212000E-03  +2.35239000E-03
   -2.34362000E-03  +8.78333000E-03  +1.91163000E-02  +9.17838000E-03  -1.65271400E-02
   -2.64973000E-03  -4.03180000E-04  -2.30457000E-03  +1.85934000E-03  -2.82491000E-03
   -1.77473000E-03  +7.82370000E-04  +1.04672000E-03  -1.08390000E-03  -5.24390000E-04
   +2.26310000E-04  +1.03080000E-04  -4.12800000E-04  -1.29050000E-04  +1.47190000E-04
   +5.09240000E-04  +3.90750000E-04  -2.64080000E-04  -1.03890000E-04  +1.71540000E-04
   +2.64180000E-04  -9.95000000E-06  -5.48200000E-05  -7.29900000E-05  +6.17340000E-04
   -1.16210000E-04  +9.99700000E-05  +1.91130000E-04  +1.80540000E-04  -4.13200000E-05
   -1.32430000E-04  +4.01990000E-04  -5.55700000E-05  -1.24589350E-01  +4.36449560E-01
   +1.32490450E-01  +2.59748200E-02  -1.83813620E-01  +2.70273400E-02  +1.50693900E-02
   -3.41232400E-02  -2.43285000E-03  +3.48887000E-03  +2.18213000E-03  +1.82177000E-03
   +6.75040000E-03  -2.56882000E-03  +1.44828700E-02  +8.13990000E-04  -5.58917000E-03
   +2.59390000E-03  -4.37410000E-03  +3.37290000E-04  -5.25510000E-04  +1.14359000E-03
   -1.15590000E-03  +9.47870000E-04  -6.50880000E-04  +6.25300000E-04  -1.56765000E-03
   +1.49901000E-03  -8.38700000E-04  -5.22100000E-05  +2.26170000E-04  -6.06980000E-04
   -1.59760000E-04  +9.29300000E-05  +5.05150000E-04  +1.69280000E-04  +1.26900000E-05
   -1.43160000E-04  -2.74500000E-04  -4.01630000E-04  +3.48960000E-04  -2.57840000E-04
   -3.04070000E-04  -5.84440000E-04  -4.59730000E-04  -3.40540000E-04  +8.44200000E-05
   -2.74870000E-04  -2.58300000E-05  +5.44240000E-04  -1.01485260E-01  -2.89001970E-01
   +3.93888080E-01  -6.16800000E-05  -2.01200000E-05  +5.07800000E-05  -4.43000000E-06
   +4.73600000E-05  -2.15100000E-05  -5.56000000E-06  -3.93000000E-06  +5.18100000E-05
   -1.02160000E-04  +9.17900000E-05  -3.40900000E-05  +2.02600000E-05  +1.93500000E-05
   +1.20000000E-07  -1.66370000E-04  +3.33700000E-05  +1.04540000E-04  +6.89300000E-05
   +2.31600000E-05  -2.36800000E-05  +1.27210000E-04  -7.35300000E-05  +1.73000000E-06
   -1.60620000E-04  +4.47010000E-04  +5.80490000E-04  -6.53880000E-04  -2.16570000E-04
   -2.06060000E-04  +1.53027000E-03  -9.30490000E-04  -2.33505000E-03  -2.77900000E-04
   -3.02629600E-02  -3.10528400E-02  -5.18490000E-03  -3.62630000E-03  +9.89810000E-04
   +1.51070000E-03  -8.08060000E-04  -6.72790000E-04  -4.61129300E-02  +4.99920800E-02
   +7.59944400E-02  +2.78700000E-05  -1.06400000E-05  -1.53500000E-05  +1.01200000E-04
   +4.20900000E-05  -5.55000000E-06  +5.05908000E-02  -6.17000000E-06  -6.40000000E-06
   -9.20000000E-06  +6.08000000E-06  +1.40820000E-04  -6.50000000E-06  -1.51100000E-05
   -1.45700000E-05  +6.70700000E-05  -1.02660000E-04  +1.27690000E-04  -7.44000000E-05
   -2.09400000E-05  -7.31000000E-06  +3.74000000E-06  -1.87470000E-04  -5.72800000E-05
   -3.39700000E-05  +7.39100000E-05  -7.89000000E-06  -2.23600000E-05  +1.59650000E-04
   -1.24220000E-04  +2.04000000E-06  -7.37400000E-05  +4.99860000E-04  +4.45280000E-04
   +8.89700000E-05  -9.84590000E-04  -3.23200000E-04  +3.55452000E-03  +3.22564000E-03
   +1.70201000E-03  +2.10452000E-03  -2.38447500E-02  -2.19544900E-02  -4.80048000E-03
   -1.78250000E-04  +8.59780000E-04  +5.30720000E-04  +1.62630000E-04  -1.78482000E-03
   +1.51151900E-02  -2.46288270E-01  -2.47354090E-01  +9.63200000E-05  +3.84000000E-05
   +3.88700000E-05  +3.71900000E-05  -4.18100000E-05  +6.71400000E-05  -1.57090200E-02
   +2.67279610E-01  -9.08900000E-05  -4.10900000E-05  +1.06320000E-04  -1.71200000E-05
   +6.37700000E-05  -1.89400000E-05  -4.42000000E-06  -1.48500000E-05  +8.42000000E-06
   -4.15000000E-05  +4.36600000E-05  -1.39800000E-05  +1.56400000E-05  -1.55000000E-06
   -7.35000000E-06  -1.11320000E-04  -2.29100000E-05  -1.50440000E-04  +2.73400000E-05
   -1.53000000E-06  -1.50700000E-05  +5.34300000E-05  -3.04000000E-05  -7.62000000E-06
   +7.06900000E-05  +1.11450000E-04  +2.21240000E-04  +7.21900000E-05  -2.04630000E-04
   -8.82550000E-04  +2.01184000E-03  +4.51475000E-03  +2.24005000E-03  +7.55650000E-04
   -1.25248000E-03  -4.29452000E-03  -8.81800000E-05  +1.41670000E-04  +2.16558000E-03
   +6.70020000E-04  -9.14650000E-04  +4.32200000E-04  +4.16882500E-02  -2.69695900E-01
   -2.93683310E-01  +1.18990000E-04  +7.30600000E-05  +5.51100000E-05  +1.18180000E-04
   +4.28000000E-05  -4.79700000E-05  -4.49306200E-02  +2.67530800E-01  +2.94282320E-01
   -2.46300000E-05  -1.27700000E-05  +2.33600000E-05  +1.10860000E-04  -5.09200000E-05
   +1.98000000E-05  +1.93500000E-05  +2.00500000E-05  -2.90600000E-05  +2.33200000E-05
   -5.84300000E-05  +4.84000000E-05  +2.54300000E-05  +3.10500000E-05  -1.00800000E-05
   +5.88870000E-04  -6.88220000E-04  -8.63320000E-04  -3.48740000E-04  -1.37690000E-04
   +1.04160000E-04  -6.60600000E-05  +6.63500000E-05  +7.63000000E-06  -2.46503000E-03
   -4.65153000E-03  +1.76440000E-03  +4.35010000E-03  -1.84951900E-02  -1.88660100E-02
   -5.58213000E-02  -6.84833000E-03  +7.54784000E-03  +4.15200000E-03  +1.74260000E-02
   +1.64609300E-02  -2.84200000E-03  -6.42260000E-04  +4.51802000E-03  -1.60980000E-03
   -3.55680000E-04  +1.01730000E-04  +1.99267000E-03  +2.50545000E-03  -1.23777000E-03
   -4.71000000E-06  +6.82800000E-05  -9.48600000E-05  +3.17000000E-06  +5.86600000E-05
   -1.86300000E-05  -8.77990000E-04  -1.08225000E-03  -1.82100000E-04  +5.27025700E-02
   +7.28400000E-05  +4.02700000E-05  -4.60900000E-05  +1.72870000E-04  -1.25600000E-04
   +3.38400000E-05  -6.56000000E-06  +4.77000000E-05  -2.39900000E-05  +6.93400000E-05
   -7.39200000E-05  +3.08000000E-05  -5.74000000E-06  +9.46000000E-06  +3.72000000E-06
   +3.22530000E-04  -1.59830000E-04  -8.39670000E-04  -3.07940000E-04  -1.89130000E-04
   +1.15020000E-04  -1.03120000E-04  +6.93500000E-05  +6.84000000E-06  -4.95937000E-03
   +2.23537000E-03  -1.74377000E-03  +2.27775000E-03  -1.03470800E-02  -1.34644000E-02
   -6.96084000E-03  -1.92975230E-01  -1.48131490E-01  -4.72303000E-03  -2.05536000E-03
   -2.85191000E-03  -1.25890000E-04  +3.30622000E-03  -1.97234000E-03  -7.63600000E-05
   -1.05660000E-04  +8.07390000E-04  +2.00822000E-03  +6.94800000E-04  +3.18106000E-03
   -6.30000000E-05  -9.66000000E-06  -4.26000000E-05  -7.01400000E-05  -2.49400000E-05
   -3.03000000E-06  +9.66770000E-04  +1.64120000E-04  -9.86570000E-04  +1.02030600E-02
   +2.01332660E-01  -7.49300000E-05  -5.28400000E-05  +7.13100000E-05  -7.31200000E-05
   -4.54300000E-05  +1.35000000E-05  +3.78000000E-05  -1.44200000E-05  -7.24300000E-05
   +3.28600000E-05  -7.24900000E-05  +6.83100000E-05  +4.14500000E-05  +1.83000000E-05
   -1.14900000E-05  +4.04570000E-04  -1.56640000E-04  +4.68400000E-05  -7.80500000E-05
   +2.81900000E-05  +3.37600000E-05  -8.02100000E-05  +7.55600000E-05  -2.68000000E-06
   +1.20889000E-03  -2.30500000E-03  +4.49743000E-03  +9.12710000E-04  -4.90230000E-04
   +1.24363000E-03  +7.43031000E-03  -1.48164970E-01  -1.78257580E-01  -4.57131000E-03
   -1.64529500E-02  -8.85707000E-03  +4.96969000E-03  -1.69073000E-03  +7.80570000E-04
   +3.33900000E-04  +9.65030000E-04  -2.05550000E-04  -1.78076000E-03  +2.86881000E-03
   -1.18050000E-04  -4.70800000E-05  +4.15000000E-06  -5.88600000E-05  +4.82200000E-05
   +8.85300000E-05  -4.76100000E-05  +1.78897000E-03  +2.48760000E-04  -2.71650000E-04
   -8.51641000E-03  +1.63484490E-01  +1.83674760E-01  -1.74030000E-04  -2.80830000E-04
   -3.14840000E-04  -7.08130000E-04  -9.21810000E-04  -9.42730000E-04  -3.34350000E-04
   -1.60620000E-04  -7.40500000E-05  -1.47030000E-04  +1.84520000E-04  +1.49900000E-05
   +1.28050000E-04  -2.49700000E-05  +3.95100000E-05  -9.46040000E-04  +3.42730000E-04
   -9.61600000E-04  -2.38000000E-05  +1.32250000E-04  -1.04170000E-04  +1.55420000E-04
   -1.24260000E-04  -1.11900000E-05  +3.79361000E-03  -3.10780000E-04  -1.39310000E-04
   -2.23218320E-01  +2.77823900E-02  +1.37863370E-01  -1.50365700E-02  +5.13641000E-03
   +1.62996300E-02  -5.09030000E-04  -5.01688000E-03  +2.07620000E-04  -4.51400000E-05
   -1.73860000E-04  -8.81870000E-04  +2.16565000E-03  -1.59581000E-03  +9.81200000E-04
   -1.42218000E-03  -7.11100000E-05  +7.59220000E-04  +8.00000000E-07  -1.10400000E-05
   +1.78910000E-04  -3.68400000E-05  +5.95200000E-05  +2.36500000E-04  +9.67400000E-05
   +2.11260000E-04  +1.35280000E-04  +6.44500000E-05  +1.13550000E-03  -1.53761000E-03
   +2.35997310E-01  +9.53600000E-05  +3.40740000E-04  -5.42250000E-04  -2.33040000E-04
   -3.90500000E-05  -2.21620000E-04  -2.58330000E-04  -9.33800000E-05  +7.30600000E-05
   -1.11160000E-04  +6.83500000E-05  -1.05500000E-05  +8.15600000E-05  -1.76930000E-04
   +2.84700000E-05  +1.50960000E-03  -8.43140000E-04  +1.32597000E-03  +1.12860000E-04
   +5.00900000E-05  +9.33600000E-05  +1.80230000E-04  -1.63750000E-04  +1.91000000E-06
   +1.88236100E-02  +2.26956000E-03  -1.35048100E-02  +2.80191000E-02  -5.88207200E-02
   -3.53683300E-02  -1.57900300E-02  +6.28602000E-03  +1.20732600E-02  -4.70811000E-03
   +9.73430000E-04  -3.61627000E-03  -2.66590000E-04  -1.13172000E-03  +2.36080000E-04
   -2.12427000E-03  -8.14750000E-04  -5.77573000E-03  -1.00315000E-03  +3.09200000E-05
   +6.24560000E-04  -1.65130000E-04  -4.89930000E-04  -4.19380000E-04  -3.10000000E-04
   -2.22440000E-04  +3.18050000E-04  +6.92500000E-05  +1.07460000E-04  +1.06620000E-04
   +1.57844000E-03  -1.20213000E-03  +2.08961000E-03  -2.64832500E-02  +5.44784700E-02
   +2.22290000E-04  +3.48380000E-04  -5.38910000E-04  -1.01030000E-04  -3.50830000E-04
   +1.28700000E-04  -3.86890000E-04  +2.46360000E-04  +4.17850000E-04  -2.87070000E-04
   +1.51410000E-04  -8.70900000E-05  -6.78300000E-05  +1.54120000E-04  -2.16200000E-05
   +1.10160000E-04  +1.91642000E-03  -1.42137000E-03  -2.54220000E-04  +1.09100000E-05
   -1.86200000E-05  +3.48040000E-04  -2.03260000E-04  -1.99000000E-06  +1.77299100E-02
   -2.13089000E-03  -8.17363000E-03  +1.37191540E-01  -3.47301900E-02  -1.54282090E-01
   -3.10108000E-03  -7.21130000E-04  +4.81746000E-03  +5.69700000E-04  -3.28893000E-03
   +4.45897000E-03  -1.09236000E-03  +9.90200000E-05  -4.71330000E-04  +9.43820000E-04
   -6.16763000E-03  +2.35040000E-04  +3.74300000E-05  +9.28300000E-05  +1.06100000E-04
   -1.33500000E-05  +3.21700000E-05  -1.25700000E-05  -2.53480000E-04  +7.73000000E-06
   +2.68420000E-04  -3.31200000E-05  -3.76000000E-06  -2.89600000E-05  -1.24868000E-03
   +2.37036000E-03  -1.46746000E-03  -1.51103420E-01  +4.17652200E-02  +1.56918220E-01
   -1.06030000E-04  -6.07000000E-05  +2.44640000E-04  -1.37970000E-04  -8.25300000E-05
   -2.33850000E-04  -1.82100000E-05  -4.86700000E-05  -1.80200000E-05  -4.63700000E-05
   +7.28000000E-05  -4.15200000E-05  +2.64400000E-05  -8.00000000E-06  -2.89000000E-05
   +1.77810000E-04  +1.39819000E-03  -1.02699000E-03  -2.05977000E-03  -1.03412000E-03
   +5.72720000E-04  +8.30500000E-05  -6.24200000E-05  -9.76000000E-06  +6.00061000E-03
   +1.74546300E-02  +1.62405900E-02  -2.93106000E-03  -8.40430000E-04  +5.05106000E-03
   -1.34284000E-03  -2.04140000E-04  -3.29000000E-05  -2.12591000E-03  -4.55826000E-03
   +1.96690000E-03  +3.48660000E-03  -1.90901500E-02  -1.83132200E-02  -5.64527900E-02
   -4.89604000E-03  +6.01286000E-03  +1.28820000E-04  -9.49760000E-04  -9.58290000E-04
   +2.49540000E-04  -6.32000000E-06  -7.66000000E-05  +1.58460000E-04  -1.52740000E-04
   -1.55570000E-04  -3.13940000E-04  -2.12090000E-04  -1.13590000E-04  -5.20400000E-05
   +2.07290000E-04  -2.12930000E-04  +1.25770000E-04  +1.04985000E-03  +9.22610000E-04
   +5.72034700E-02  +2.78080000E-04  +1.58600000E-04  -4.23680000E-04  +3.06500000E-04
   +3.40980000E-04  -1.55940000E-04  +6.03100000E-05  -7.36300000E-05  +6.97900000E-05
   -1.88100000E-05  +4.17300000E-05  -4.11800000E-05  -1.01270000E-04  +1.17800000E-05
   +7.85500000E-05  +5.56130000E-04  -2.13640000E-03  +1.27517000E-03  -2.41375000E-03
   -7.70670000E-04  +1.97470000E-04  +5.02600000E-05  -4.24500000E-05  +1.57600000E-05
   -3.80350000E-04  +9.20870000E-04  -3.41546000E-03  -7.64050000E-04  +3.47259000E-03
   -2.69985000E-03  -2.21000000E-05  -1.05890000E-04  +9.36740000E-04  -4.73215000E-03
   +2.80942000E-03  -2.21120000E-03  +1.27362000E-03  -9.57175000E-03  -1.39159900E-02
   -4.38364000E-03  -1.94676420E-01  -1.49793500E-01  -1.11700000E-04  -8.39500000E-04
   -8.20050000E-04  -4.07780000E-04  -2.20810000E-04  +3.81800000E-05  -4.10230000E-04
   -4.83700000E-05  +3.73620000E-04  -1.36860000E-04  -2.07100000E-04  +6.49900000E-05
   +1.82670000E-04  -3.50380000E-04  +2.62150000E-04  -9.45100000E-05  -1.29690000E-04
   +5.79000000E-06  +1.19266500E-02  +2.04217020E-01  -1.15760000E-04  -6.08400000E-05
   +1.02300000E-04  -2.01060000E-04  -8.36000000E-05  +1.35390000E-04  -3.73900000E-05
   +6.65400000E-05  -7.49000000E-06  +4.28000000E-06  -1.95000000E-05  +4.47000000E-06
   +1.24500000E-05  +1.41000000E-06  -1.12600000E-05  -2.05673000E-03  +5.05660000E-04
   -1.88914000E-03  -7.25710000E-04  -1.04368000E-03  +4.59080000E-04  -2.96500000E-05
   +3.48100000E-05  +1.35000000E-06  -1.54948000E-03  -1.43047100E-02  -8.60319000E-03
   +5.07290000E-03  -2.31910000E-03  +1.16996000E-03  +6.60400000E-05  +9.50030000E-04
   -1.69830000E-04  +1.88023000E-03  -2.26790000E-03  +4.56073000E-03  +1.65862000E-03
   -8.88780000E-04  +2.10528000E-03  +6.51098000E-03  -1.50408930E-01  -1.90934650E-01
   -1.44110000E-04  -2.42090000E-04  -8.83500000E-05  +6.59540000E-04  +2.01270000E-04
   +2.12800000E-05  +2.25590000E-04  +6.28900000E-05  -3.18900000E-05  -3.51200000E-05
   +1.15220000E-04  -5.31200000E-05  -2.46430000E-04  +2.30570000E-04  -3.44880000E-04
   -1.32120000E-04  -7.10820000E-04  -6.13890000E-04  -7.93747000E-03  +1.67003660E-01
   +1.95335090E-01  -7.30800000E-05  -2.41400000E-05  +1.57990000E-04  -3.81700000E-05
   -2.36390000E-04  +4.85900000E-05  -4.02500000E-05  +5.87100000E-05  -4.92900000E-05
   +4.45600000E-05  -6.06200000E-05  +2.98000000E-05  +2.30100000E-05  +9.17000000E-06
   -1.90900000E-05  -2.33250000E-04  +5.45930000E-04  +7.68260000E-04  -2.62600000E-05
   +8.83200000E-05  +5.04200000E-05  -8.11400000E-05  +5.91300000E-05  -6.24000000E-06
   -1.05922000E-03  -5.09957000E-03  +4.15130000E-04  -6.10900000E-05  -2.55690000E-04
   -8.97710000E-04  +1.98598000E-03  -1.48190000E-03  +8.44720000E-04  +2.63085000E-03
   -2.43524000E-03  -7.69440000E-04  -2.27345950E-01  +2.36881100E-02  +1.42620920E-01
   -1.40547600E-02  +5.46486000E-03  +1.55906500E-02  +2.38360000E-04  +1.35731000E-03
   -1.06041000E-03  -1.78590000E-04  -6.63400000E-05  -8.93200000E-05  +8.79300000E-05
   +5.22900000E-05  -1.97150000E-04  -7.49800000E-05  +1.71510000E-04  -1.41690000E-04
   +1.78720000E-04  -3.35200000E-05  -1.49250000E-04  -1.55950000E-04  +2.22020000E-04
   -1.23320000E-04  -2.69800000E-05  +1.24484000E-03  -1.60099000E-03  +2.38318090E-01
   -3.82900000E-05  +7.44000000E-06  -1.15700000E-05  -2.07690000E-04  -2.32320000E-04
   +3.22300000E-05  -3.47000000E-06  +2.27200000E-05  -2.92000000E-05  +1.60000000E-05
   -4.37000000E-05  +3.85200000E-05  +2.41200000E-05  -9.61000000E-06  -5.86000000E-06
   -5.21660000E-04  +4.70410000E-04  +3.51370000E-04  +5.38500000E-05  +5.06200000E-05
   +6.25100000E-05  -4.53800000E-05  +3.15900000E-05  +1.91000000E-06  -4.65669000E-03
   +9.31540000E-04  -3.13286000E-03  -4.38610000E-04  -1.31835000E-03  +6.05800000E-05
   -1.96349000E-03  -1.10018000E-03  -5.18826000E-03  +1.91300400E-02  +2.62884000E-03
   -1.44234800E-02  +2.26105100E-02  -5.50281800E-02  -3.33072000E-02  -1.47877000E-02
   +6.25158000E-03  +1.28325800E-02  +1.12516000E-03  -9.57600000E-05  +2.64688000E-03
   -5.72000000E-05  +3.81200000E-05  -5.00900000E-05  +2.25000000E-06  -1.89700000E-05
   +2.35900000E-05  +1.08260000E-04  +1.63900000E-05  +4.84970000E-04  +9.61630000E-04
   -1.48610000E-04  -7.13750000E-04  +1.85490000E-04  -2.17710000E-04  +3.29540000E-04
   +1.64730000E-03  -1.28726000E-03  +2.10651000E-03  -2.31534800E-02  +4.90328500E-02
   -9.10000000E-06  -1.23000000E-05  +5.98500000E-05  +1.03660000E-04  +5.78000000E-05
   -9.68000000E-06  -1.42800000E-05  +8.78000000E-06  +2.57100000E-05  -2.45600000E-05
   +3.50600000E-05  -2.75700000E-05  -5.53000000E-06  +1.35600000E-05  -3.26000000E-06
   -1.20130000E-04  -9.96000000E-05  +2.82090000E-04  +1.05000000E-05  +4.94000000E-05
   -4.06800000E-05  +3.97900000E-05  -2.43500000E-05  -1.32000000E-06  +4.03340000E-04
   -2.91721000E-03  +4.21137000E-03  -1.16877000E-03  -1.55270000E-04  -5.14280000E-04
   +4.56340000E-04  -5.47833000E-03  +4.39000000E-05  +1.99737100E-02  -7.90180000E-04
   -8.00857000E-03  +1.41518650E-01  -3.41587500E-02  -1.56183560E-01  -3.71051000E-03
   +1.59730000E-04  +4.99296000E-03  -1.30630000E-03  +2.46219000E-03  -3.86950000E-04
   -2.61000000E-06  -5.30600000E-05  -8.69000000E-06  +4.39300000E-05  +9.00000000E-06
   -5.65300000E-05  -2.07700000E-04  +4.40250000E-04  -3.96000000E-06  +8.08410000E-04
   -1.07690000E-04  -6.05460000E-04  -1.31730000E-04  +3.14730000E-04  -3.14270000E-04
   -1.20994000E-03  +2.44788000E-03  -1.42434000E-03  -1.55459310E-01  +3.79070200E-02
   +1.57975700E-01  -2.77640000E-04  +1.43800000E-05  +5.06050000E-04  +6.96800000E-04
   -7.81200000E-05  -1.00600000E-04  -1.11850000E-04  +4.77100000E-05  +3.15830000E-04
   +5.89000000E-05  -1.34690000E-04  +1.05550000E-04  +1.60100000E-05  +7.80800000E-05
   -1.45020000E-04  -2.93558000E-03  +5.28960000E-04  +8.08650000E-04  -7.91000000E-05
   -1.86760000E-04  +5.83540000E-04  -1.97550000E-04  +1.68830000E-04  -4.71800000E-05
   +8.02330000E-04  -1.47275000E-03  +3.76800000E-05  +3.40570000E-04  +3.10890000E-04
   +2.66190000E-04  -2.65790000E-04  -2.68600000E-05  -2.14200000E-05  +6.86200000E-05
   -9.81200000E-05  -1.94660000E-04  +1.36900000E-04  +1.39810000E-04  -1.50600000E-05
   +1.61060000E-04  +6.12000000E-05  +1.74250000E-04  +3.15400000E-05  +9.02000000E-06
   +2.98300000E-05  -2.51227910E-01  +1.16406010E-01  +1.35185200E-02  +2.64080000E-04
   +3.20100000E-05  -2.81280000E-04  -8.27000000E-06  +4.03000000E-06  -4.39000000E-06
   -5.40000000E-06  +1.29400000E-05  -2.38000000E-06  +2.73700000E-05  -6.47300000E-05
   +1.99400000E-05  +2.96500000E-05  +4.19800000E-05  -1.96200000E-05  +2.31500000E-05
   +1.38200000E-05  +7.23000000E-06  +2.69842540E-01  +1.48538000E-03  -6.40500000E-05
   -5.96880000E-04  -6.00100000E-04  -1.78357000E-03  +3.62029000E-03  -4.86910000E-04
   +2.10780000E-04  +5.90650000E-04  -1.96010000E-04  +1.57010000E-04  -2.99700000E-05
   -8.66400000E-05  -2.70530000E-04  +3.00210000E-04  +1.72511700E-02  -1.21852800E-02
   -7.45870000E-04  -3.79110000E-04  +3.01620000E-04  -1.34732000E-03  +2.30750000E-04
   -1.54090000E-04  -2.95700000E-05  +1.26958000E-03  +5.76800000E-04  -1.00380000E-04
   -1.62410000E-04  -3.91520000E-04  -5.86540000E-04  +2.11740000E-04  +7.04000000E-05
   -6.10600000E-05  -2.80070000E-04  -5.58800000E-05  +1.93040000E-04  -2.69070000E-04
   -1.23890000E-04  +3.35000000E-06  -2.23510000E-04  +1.78900000E-04  -4.71000000E-06
   +2.09830000E-04  +1.85620000E-04  +1.06200000E-05  +1.14444710E-01  -1.11743400E-01
   -8.64266000E-03  -2.87550000E-04  -3.11100000E-05  +2.15220000E-04  -8.09000000E-06
   -3.93100000E-05  -8.70000000E-06  +1.36100000E-05  -7.20000000E-07  +1.49200000E-05
   +8.04000000E-06  +1.37150000E-04  +1.39630000E-04  +3.27300000E-05  -2.35700000E-05
   +8.97800000E-05  +6.24000000E-06  -1.22500000E-05  -4.40000000E-07  -1.26623360E-01
   +1.20931060E-01  -1.36916000E-03  +6.52760000E-04  +6.60520000E-04  +6.68820000E-04
   +2.75611000E-03  -4.32253000E-03  +1.01537000E-03  +1.49510000E-04  -5.45530000E-04
   +1.35630000E-04  -1.18190000E-04  -1.81700000E-05  +1.16540000E-04  +2.17340000E-04
   -3.39210000E-04  -2.23360600E-02  +1.34887600E-02  -7.47210000E-04  -1.32031000E-03
   +9.16380000E-04  +1.17415000E-03  -1.02710000E-04  +2.18500000E-05  +5.66400000E-05
   -8.34810000E-04  -3.52750000E-04  +4.25630000E-04  +4.23240000E-04  +8.24500000E-05
   -7.24300000E-05  -4.39630000E-04  -3.53200000E-05  +7.88200000E-05  +2.07900000E-04
   -6.22100000E-05  -2.42460000E-04  +1.95030000E-04  +1.51200000E-04  +2.60000000E-07
   -1.70260000E-04  -1.09180000E-04  +2.32610000E-04  -1.73070000E-04  -1.20480000E-04
   -3.87000000E-06  +1.52791400E-02  -9.86945000E-03  -4.70319100E-02  +7.12600000E-05
   -7.49500000E-05  -2.68800000E-05  +1.53700000E-05  +1.12900000E-05  +1.68700000E-05
   +1.12700000E-05  -1.71700000E-05  +2.05000000E-06  +1.51500000E-05  +4.79000000E-06
   +6.75600000E-05  +2.89500000E-05  -1.47700000E-05  -1.10530000E-04  -5.10000000E-07
   +7.42000000E-06  +1.40700000E-05  -1.57503500E-02  +5.96716000E-03  +5.26634200E-02
   +1.23380000E-04  -1.56750000E-04  -7.73200000E-05  +1.32020000E-04  +5.76100000E-05
   +2.31780000E-04  -6.45870000E-04  +1.09291000E-03  +5.55920000E-04  -1.30460000E-04
   +9.95000000E-06  -9.64000000E-06  +8.24000000E-06  +1.26900000E-05  +2.58500000E-05
   +1.42489000E-03  +2.44381000E-03  -3.51170000E-04  +3.03850000E-04  +3.36880000E-04
   -2.35710000E-04  +8.37700000E-05  -3.16300000E-05  -2.69400000E-05  +4.57630000E-04
   -7.08410000E-04  +2.35230000E-04  +3.03090000E-04  +4.37640000E-04  +5.13350000E-04
   -3.34480000E-04  -4.10900000E-05  +7.60900000E-05  +3.48900000E-04  +1.04530000E-04
   -1.38420000E-04  +7.92700000E-05  +1.87100000E-05  -1.57100000E-05  +4.92600000E-04
   -1.90380000E-04  -1.36880000E-04  -3.02870000E-04  -2.25890000E-04  -1.50900000E-05
   -1.94924260E-01  -1.32006690E-01  +7.61150000E-04  +6.65600000E-05  +6.99700000E-05
   +4.87700000E-05  +2.37300000E-05  +4.40600000E-05  +1.70300000E-05  -2.97000000E-05
   -1.45600000E-05  -2.39200000E-05  +2.90000000E-06  -3.52600000E-05  -1.35600000E-05
   -5.78300000E-05  +6.68900000E-05  -9.57000000E-06  -1.75200000E-05  -4.70000000E-06
   +7.62000000E-06  -1.89509500E-02  -1.91906600E-02  -5.02540000E-04  +2.11282250E-01
   -1.14790000E-04  -8.40800000E-05  +4.64160000E-04  -8.40580000E-04  +5.67110000E-04
   -2.58950000E-04  +3.57400000E-05  -1.74460000E-04  +5.37820000E-04  -4.44800000E-05
   -8.40800000E-05  +4.55900000E-05  -1.96000000E-05  +1.00810000E-04  -1.08720000E-04
   -1.48037000E-02  -1.30279500E-02  -9.62770000E-04  -2.69200000E-05  +5.43290000E-04
   -1.58099000E-03  -9.62400000E-05  +1.41460000E-04  -6.81700000E-05  +3.29920000E-04
   -1.59969000E-03  +3.90693000E-03  -4.14410000E-04  -1.73510000E-04  +2.90240000E-04
   +2.54430000E-04  +2.07790000E-04  +6.56000000E-06  +1.55770000E-04  +5.56490000E-04
   +4.94610000E-04  -6.16780000E-04  -4.13340000E-04  -4.53860000E-04  +5.43240000E-04
   -3.67320000E-04  -3.44360000E-04  -5.26360000E-04  -4.38530000E-04  -1.09330000E-04
   -1.30627570E-01  -1.64492470E-01  +7.96230000E-04  +3.18990000E-04  +1.50800000E-04
   -3.46580000E-04  +2.64000000E-05  +5.09300000E-05  +4.38300000E-05  -2.22300000E-05
   -5.55900000E-05  -2.65400000E-05  -3.83900000E-05  +1.38110000E-04  -1.12230000E-04
   +3.91100000E-05  -4.93800000E-05  +1.66170000E-04  -8.99700000E-05  -4.28000000E-06
   -3.61600000E-05  +1.22741800E-02  +1.19290100E-02  -5.31900000E-05  +1.44079390E-01
   +1.77441050E-01  +3.31300000E-05  -6.10000000E-06  -2.97110000E-04  +3.39700000E-04
   -6.77290000E-04  +5.37690000E-04  -3.25910000E-04  -2.72740000E-04  +4.85110000E-04
   -9.77100000E-05  -3.32900000E-05  +1.27200000E-04  +1.04580000E-04  -5.02100000E-05
   -9.55000000E-06  +1.98203300E-02  +1.65198200E-02  -1.25562000E-03  +1.03326000E-03
   +8.30540000E-04  +1.32495000E-03  +3.28300000E-05  -4.93000000E-06  -3.27000000E-05
   -1.36362000E-03  +2.33877000E-03  -3.56835000E-03  +3.64000000E-05  -3.23490000E-04
   +1.44600000E-05  +6.98710000E-04  -4.54000000E-05  +8.00000000E-05  -4.35420000E-04
   -7.30000000E-06  +2.22640000E-04  +5.05400000E-05  -2.78960000E-04  +2.30510000E-04
   +6.16590000E-04  +5.33640000E-04  +1.15130000E-04  +4.37160000E-04  +3.67410000E-04
   +1.68100000E-05  +6.65640000E-04  -2.97810000E-04  -4.85097400E-02  -3.85700000E-05
   -7.15400000E-05  +1.33300000E-05  -3.65000000E-06  -3.26900000E-05  -4.44200000E-05
   +3.60200000E-05  +3.20800000E-05  +2.10100000E-05  -2.47660000E-04  +3.55120000E-04
   -9.47000000E-05  -1.95300000E-05  +1.00400000E-04  -1.57060000E-04  +5.49800000E-05
   +3.02600000E-05  -1.36800000E-05  +1.67068000E-03  +1.55832000E-03  -9.83510000E-04
   -1.32920000E-03  -2.82795000E-03  +5.07845500E-02  +1.98250000E-04  +9.45200000E-05
   -1.96060000E-04  +3.51920000E-04  -5.16490000E-04  -2.81970000E-04  -5.02370000E-04
   +3.38040000E-04  -6.22520000E-04  -1.01300000E-05  +6.03800000E-05  -5.09600000E-05
   -1.15700000E-05  -6.39800000E-05  +6.11500000E-05  -1.82143000E-03  -1.51795000E-03
   -2.11885000E-03  -5.14900000E-05  +4.87240000E-04  -3.93240000E-04  +1.02650000E-04
   -1.09090000E-04  +4.04000000E-05  -9.70000000E-06  +5.58100000E-04  +6.72780000E-04
   +8.23000000E-06  -1.76800000E-04  -6.82500000E-05  -2.57530000E-04  -4.39400000E-05
   -5.17400000E-05  -1.25600000E-05  -1.23480000E-04  -7.95200000E-05  +1.05360000E-04
   +8.01200000E-05  +5.95600000E-05  -1.91980000E-04  -6.19600000E-05  +1.01710000E-04
   +5.63300000E-05  +5.36400000E-05  -1.51000000E-06  -4.70302500E-02  +7.01590000E-04
   +1.96509000E-03  -2.04950000E-04  -1.03180000E-04  +2.22470000E-04  -8.03000000E-06
   -2.25900000E-05  +7.47000000E-06  +2.12000000E-05  -1.30500000E-05  +2.03300000E-05
   +1.77110000E-04  -9.94300000E-05  +8.12800000E-05  +3.11700000E-05  +8.69000000E-06
   -7.14800000E-05  +7.00000000E-07  +8.55000000E-06  -9.06000000E-06  +5.00200000E-04
   +1.41817000E-02  +2.47078600E-02  +5.71760000E-04  -1.16661600E-02  -2.12890700E-02
   +4.89959700E-02  -2.45090000E-04  -1.30450000E-04  +8.55300000E-05  -1.32180000E-04
   +8.88270000E-04  -5.02290000E-04  +9.88340000E-04  +2.04220000E-04  -1.39060000E-04
   +9.64800000E-05  -6.33000000E-06  -1.69770000E-04  -7.25800000E-05  +5.27400000E-05
   +3.90700000E-05  -9.21920000E-04  +1.01224700E-02  +1.69912700E-02  +2.03040000E-04
   -2.04771000E-03  +2.78306000E-03  -4.96900000E-05  -1.73000000E-06  +4.37700000E-05
   +5.22130000E-04  +1.07711000E-03  +2.62150000E-04  -3.97820000E-04  -9.05800000E-05
   +5.87320000E-04  -2.59800000E-05  -1.68760000E-04  -1.07750000E-04  +1.05400000E-05
   -1.17540000E-04  -1.63750000E-04  +1.23970000E-04  +1.47700000E-04  +1.38340000E-04
   -1.69610000E-04  -3.86000000E-05  -4.68900000E-05  +1.59620000E-04  +1.06460000E-04
   +2.11200000E-05  +3.00130000E-04  -1.20372510E-01  -1.20406230E-01  -2.35400000E-05
   +2.23800000E-05  -3.71600000E-05  -1.82200000E-05  -1.36500000E-05  -1.54700000E-05
   -1.68000000E-06  +7.24000000E-06  +2.23100000E-05  +7.23100000E-05  -6.84710000E-04
   +1.46300000E-04  +1.90300000E-05  -1.14100000E-05  +8.26000000E-06  +9.14000000E-06
   -1.04000000E-06  -1.83000000E-06  -1.16158000E-03  -8.31526000E-03  -1.27733200E-02
   +2.11811000E-03  -1.04147900E-02  -1.72288000E-02  -1.98482000E-03  +1.29209990E-01
   +1.29900000E-04  +3.89630000E-04  -2.94250000E-04  +1.06993000E-03  -9.27240000E-04
   +7.29360000E-04  +5.48260000E-04  +2.07720000E-04  +2.06560000E-04  -8.47000000E-06
   -1.25850000E-04  +6.54900000E-05  +1.24500000E-04  -1.30040000E-04  +2.96400000E-05
   +7.14150000E-04  -1.41891300E-02  -2.07094300E-02  -8.65500000E-05  +4.91906000E-03
   -4.18168000E-03  -1.66700000E-05  -1.96100000E-05  +4.19200000E-05  -1.61590000E-03
   -9.42260000E-04  +7.69920000E-04  +1.00190000E-04  -6.58570000E-04  +2.21600000E-05
   +6.53320000E-04  +3.44670000E-04  +1.82920000E-04  -2.78830000E-04  +4.10420000E-04
   +4.97040000E-04  -4.72520000E-04  -4.62140000E-04  -1.84920000E-04  +9.46060000E-04
   +1.20900000E-04  -2.76640000E-04  -6.48500000E-05  -4.08800000E-05  -2.97100000E-05
   +2.07726000E-03  -1.17962220E-01  -2.43067660E-01  -1.13710000E-04  +8.23600000E-05
   +3.21400000E-04  +2.07600000E-05  +1.45800000E-05  -5.90000000E-07  +3.93900000E-05
   +4.50000000E-06  -3.17000000E-06  -2.36070000E-04  +4.80180000E-04  +8.37900000E-05
   -1.36530000E-04  +1.14200000E-05  +8.96900000E-05  -6.18000000E-06  +1.50500000E-05
   -2.17900000E-05  -2.21540000E-04  -2.34130000E-04  -8.05880000E-04  +9.78500000E-05
   +1.25285000E-03  +1.47250000E-03  -2.22719000E-03  +1.28624470E-01  +2.65383640E-01
   -6.25420000E-04  +2.83050000E-04  +9.55950000E-04  +1.21910000E-04  -4.52820000E-04
   +2.42240000E-04  -1.47810000E-04  +4.00000000E-05  +2.04900000E-05  -6.41400000E-05
   +1.43230000E-04  -9.27200000E-05  -5.66200000E-05  -3.36000000E-06  -1.27600000E-05
   -1.66567000E-03  +2.60590000E-04  -7.92400000E-04  -4.87476700E-02  -2.45331000E-03
   +4.29397000E-03  +7.05000000E-05  -5.50700000E-05  -2.10000000E-05  +2.23850000E-04
   +5.01520000E-04  -3.88870000E-04  -8.86400000E-05  -7.63400000E-05  -6.20900000E-05
   +1.39990000E-04  +1.14140000E-04  +2.14300000E-05  -9.56000000E-05  -2.03000000E-06
   +4.14600000E-05  -1.22170000E-04  +8.53000000E-06  +2.27450000E-04  +1.62980000E-04
   -3.61640000E-04  -5.33130000E-04  +1.00880000E-04  +1.13150000E-04  +3.67000000E-05
   -4.39400000E-05  -2.33040000E-04  -4.08960000E-04  +1.69730000E-04  -4.57000000E-06
   -4.95310000E-04  -8.81000000E-06  -1.04700000E-05  -4.74000000E-06  +1.38500000E-05
   +1.13000000E-05  +1.76200000E-05  -1.38200000E-05  +4.71100000E-05  +4.74200000E-05
   -1.09948000E-03  +2.38490000E-04  -3.34300000E-04  -7.73000000E-06  -8.10000000E-07
   -2.24500000E-05  +3.45240000E-04  -2.88080000E-04  +2.83290000E-04  +1.43890000E-04
   +3.32050000E-04  -2.05400000E-04  +6.85160000E-04  +9.46200000E-05  -1.32540000E-04
   +4.87227300E-02  +1.49293000E-03  +4.78120000E-04  -1.74004000E-03  -6.90190000E-04
   +7.23300000E-04  +7.64460000E-04  +1.66940000E-04  +1.72000000E-05  +1.47700000E-05
   +6.65300000E-05  -1.99390000E-04  +1.36140000E-04  -2.19900000E-04  -1.23200000E-05
   +2.05750000E-04  +3.21030000E-04  +1.16846700E-02  -1.66437900E-02  -2.20571000E-03
   -1.28904940E-01  +1.28425710E-01  -1.64150000E-04  +7.63400000E-05  +1.67000000E-05
   +1.54800000E-04  +8.57890000E-04  +3.29830000E-04  +2.06140000E-04  -1.42560000E-04
   +1.55700000E-05  +1.36410000E-04  +3.56500000E-05  -4.19200000E-05  -1.30780000E-04
   +2.85600000E-05  +1.63810000E-04  -1.37400000E-05  -2.27110000E-04  -1.36510000E-04
   -5.06140000E-04  +3.35140000E-04  +1.25690000E-04  +5.86300000E-05  +6.67000000E-06
   -2.58500000E-05  -1.25540000E-04  -2.17783000E-03  -3.00956000E-03  -7.28600000E-05
   -2.90763000E-03  +4.84550000E-04  -1.38200000E-05  -5.73000000E-06  -9.06000000E-06
   +5.03000000E-06  +1.71100000E-05  -1.25700000E-05  -1.90500000E-05  +2.32500000E-05
   -4.38300000E-05  -1.66270000E-04  -1.33070000E-04  -2.04660000E-04  -1.25300000E-05
   +3.14400000E-05  -2.15500000E-05  -2.33350000E-04  -3.62000000E-05  -8.75400000E-05
   +2.35670000E-04  -6.47000000E-06  -9.00400000E-05  -1.23260000E-04  +8.29140000E-04
   -1.16482000E-03  +3.14698000E-03  +1.38655560E-01  +1.42250000E-03  -1.41000000E-04
   -1.44088000E-03  -5.93460000E-04  +4.32840000E-04  +5.72880000E-04  +3.00580000E-04
   +7.82000000E-06  -5.81600000E-05  +3.27800000E-05  -1.04120000E-04  +1.03740000E-04
   -7.21700000E-05  -1.70200000E-04  +1.22200000E-04  +1.29960000E-04  +1.49197900E-02
   -2.06831900E-02  +4.60721000E-03  +1.23772120E-01  -2.41097120E-01  -3.43500000E-05
   +2.04600000E-05  +4.17000000E-05  +7.57850000E-04  +1.09699000E-03  +9.87980000E-04
   -1.38600000E-05  -4.42620000E-04  -3.38800000E-05  +2.10740000E-04  +1.65920000E-04
   +6.91000000E-06  -9.92800000E-05  +1.49720000E-04  +1.38520000E-04  -2.52920000E-04
   -1.20490000E-04  +1.66290000E-04  +1.57270000E-04  -2.50560000E-04  -5.28800000E-05
   -9.40000000E-07  +5.48000000E-06  +1.43100000E-05  +1.98100000E-04  -4.55209000E-03
   -4.11337000E-03  -8.77640000E-04  +1.97303000E-03  +5.92250000E-04  -5.97000000E-06
   +6.17000000E-06  -7.46000000E-06  -1.62300000E-05  +2.36800000E-05  -2.71600000E-05
   -2.32400000E-05  +8.55700000E-05  +2.68800000E-05  -5.14230000E-04  +1.73720000E-04
   +4.36900000E-05  -1.98700000E-05  -2.08300000E-05  -1.03400000E-05  -2.23000000E-05
   -9.37900000E-05  +2.46220000E-04  +8.93800000E-05  -9.44600000E-05  +3.23900000E-04
   -1.64270000E-04  +1.01324000E-03  -1.49659000E-03  -4.53505000E-03  -1.35888960E-01
   +2.62654240E-01  +3.20400000E-05  -1.52560000E-04  +3.43390000E-04  +7.42070000E-04
   +1.40469000E-03  +2.46890000E-04  +3.76060000E-04  -2.18290000E-04  -1.51400000E-05
   -4.20100000E-05  +3.48300000E-05  -2.57100000E-05  +1.99000000E-06  -2.05100000E-05
   +3.25000000E-06  -1.18104000E-03  +6.86420000E-04  +1.00522000E-03  -2.37508560E-01
   -1.22941220E-01  +3.59870000E-03  +5.53100000E-05  -2.41900000E-05  +8.40000000E-07
   +6.13850000E-04  +1.67540000E-04  +1.88600000E-04  +7.43700000E-05  +1.77350000E-04
   +2.42850000E-04  -8.28300000E-05  -8.33700000E-05  -9.74100000E-05  +1.05860000E-04
   +8.11000000E-05  -1.48600000E-05  +1.91380000E-04  -1.49320000E-04  -2.47690000E-04
   -2.51710000E-04  +1.55740000E-04  +4.46150000E-04  -1.66080000E-04  -1.70530000E-04
   -5.46800000E-05  -1.66240000E-04  +1.53090000E-04  +3.28100000E-04  +5.11200000E-05
   +5.27000000E-06  -2.01690000E-04  +1.61600000E-05  +2.00900000E-05  +9.48000000E-06
   -2.70700000E-05  -1.16600000E-05  -2.30500000E-05  +8.54400000E-05  -6.06100000E-05
   -4.85000000E-05  +2.37330000E-04  -1.76380000E-04  -5.04170000E-04  -8.20000000E-06
   -1.96000000E-06  +1.93700000E-05  +2.82000000E-05  -1.27910000E-04  +5.33600000E-05
   +2.87040000E-04  +2.78120000E-04  -5.15100000E-04  +2.79890000E-04  +2.46340000E-04
   -4.01700000E-05  +5.48170000E-04  +1.13967000E-03  +2.86100000E-05  +2.55515960E-01
   -3.85670000E-04  -2.18990000E-04  +7.46650000E-04  -1.19190000E-03  +4.14560000E-04
   +3.04060000E-04  +4.11630000E-04  +1.18850000E-04  -9.00000000E-05  +1.13960000E-04
   -1.55560000E-04  +1.81200000E-05  +1.30210000E-04  -7.06600000E-05  +2.15900000E-05
   -1.62241800E-02  -1.26172200E-02  +5.28500000E-05  -1.21426030E-01  -1.24202050E-01
   +3.83248000E-03  -1.82670000E-04  +1.63560000E-04  +1.04600000E-05  +1.31735000E-03
   -1.34550000E-03  -3.62417000E-03  -1.22264000E-03  -2.10760000E-04  +1.63790000E-04
   -4.37700000E-05  -3.38080000E-04  -1.21410000E-04  +3.04540000E-04  +9.52500000E-05
   -8.01300000E-05  -9.00800000E-05  +1.41570000E-04  +6.22700000E-05  +5.41950000E-04
   +8.28800000E-05  -4.33370000E-04  -2.71510000E-04  -1.79410000E-04  +1.83000000E-06
   +3.58760000E-04  +2.53840000E-04  +1.18398000E-03  +4.88140000E-04  -2.81170000E-04
   -2.52870000E-04  +3.36900000E-05  +3.51500000E-05  +1.79900000E-05  -8.32500000E-05
   -1.17980000E-04  +8.31000000E-06  +9.01000000E-06  +3.06500000E-05  -8.23700000E-05
   +1.29840000E-04  -3.38600000E-05  +3.24690000E-04  -4.32000000E-05  -7.89000000E-06
   -6.96000000E-06  +1.19740000E-04  +5.79800000E-05  -1.87900000E-05  +8.84900000E-05
   +6.11930000E-04  -1.02460000E-04  +2.63070000E-04  +2.18000000E-06  +3.60900000E-05
   -1.46294600E-02  -8.83633000E-03  -1.04297000E-03  +1.33628300E-01  +1.34528200E-01
   +8.63500000E-05  +1.74000000E-05  +1.65890000E-04  -1.05946000E-03  +5.60080000E-04
   +9.12090000E-04  +1.40670000E-04  +1.89920000E-04  +4.21100000E-05  +5.89600000E-05
   -7.35500000E-05  +1.13500000E-05  -1.23720000E-04  -1.95700000E-05  +6.01500000E-05
   -2.27425000E-02  -1.51622500E-02  -1.59263000E-03  +5.98553000E-03  +4.92444000E-03
   -4.69890400E-02  -1.67670000E-04  +1.09280000E-04  -1.29000000E-05  +1.23856000E-03
   -2.26581000E-03  -4.39700000E-03  -1.47863000E-03  -8.70310000E-04  +2.65040000E-04
   +1.52250000E-04  -2.59230000E-04  -2.16910000E-04  +1.06360000E-04  +1.43230000E-04
   -3.11000000E-06  -1.97220000E-04  -2.20200000E-05  +1.89720000E-04  +8.59420000E-04
   -2.75200000E-04  -4.47000000E-04  -1.49530000E-04  -7.43200000E-05  +1.79400000E-05
   -1.13250000E-03  -9.01720000E-04  +1.24544000E-03  -1.00910000E-04  +3.25430000E-04
   -2.24450000E-04  +2.00500000E-05  +2.15400000E-05  +7.93000000E-06  -1.17660000E-04
   -8.19200000E-05  -3.13700000E-05  +3.80000000E-07  +3.64600000E-05  -1.95900000E-05
   -1.02720000E-04  +4.65910000E-04  +2.05800000E-04  -2.49300000E-05  -3.30700000E-05
   +1.02900000E-05  +5.52300000E-05  +5.35000000E-06  -7.22000000E-05  +2.92450000E-04
   +3.83060000E-04  -7.28080000E-04  +3.09100000E-04  +1.64560000E-04  +2.75030000E-04
   +2.41266200E-02  +1.29262700E-02  +1.09128000E-03  -5.39761000E-03  -1.94340000E-04
   +5.13311800E-02  -1.07480000E-04  -2.43850000E-04  +5.78460000E-04  +4.38310000E-04
   +6.19150000E-04  +6.66440000E-04  +6.61270000E-04  +1.74870000E-04  -2.79590000E-04
   +2.05820000E-04  -2.69630000E-04  +1.21710000E-04  +2.29500000E-05  -7.88600000E-05
   -8.59000000E-06  +2.68830000E-04  -1.13640000E-03  -2.47650000E-04  -2.07383540E-01
   +1.30308620E-01  -1.18533000E-03  -3.12840000E-04  +2.22900000E-04  +1.29900000E-05
   -9.81000000E-05  -3.33800000E-05  +3.27570000E-04  +1.03720000E-04  +7.52400000E-05
   +4.30000000E-06  +7.36400000E-05  +2.57400000E-05  -2.27300000E-05  -2.02550000E-04
   +1.35800000E-05  +4.24200000E-05  +1.20020000E-04  -2.07640000E-04  -2.86630000E-04
   -1.00663000E-03  -9.12160000E-04  +5.95010000E-04  +9.53200000E-05  +2.38800000E-05
   -2.57500000E-05  +3.41760000E-04  -3.26730000E-04  -5.25710000E-04  +2.45810000E-04
   -1.17560000E-04  -2.13500000E-04  -1.90700000E-05  -1.26200000E-05  -7.82000000E-06
   +1.34900000E-05  +2.10500000E-05  -2.59000000E-06  -1.24200000E-05  -4.53000000E-06
   -1.69400000E-05  -1.27374000E-03  -2.13665000E-03  -2.88740000E-04  +2.83700000E-05
   -1.85000000E-06  +2.38900000E-05  +3.91410000E-04  -1.51010000E-04  +2.95070000E-04
   -2.19440000E-04  +1.18330000E-04  +8.25900000E-05  +2.20770000E-04  -2.73770000E-04
   +1.91000000E-05  +1.06404000E-03  -2.02068000E-03  -1.14660000E-04  -1.98349600E-02
   +1.77978300E-02  -7.20980000E-04  +2.26363280E-01  +1.73150000E-04  +7.23600000E-05
   +1.62230000E-04  -8.45900000E-04  -9.50590000E-04  -3.67618000E-03  -3.46000000E-06
   -5.14560000E-04  +2.91790000E-04  -2.43250000E-04  +3.64740000E-04  -3.14550000E-04
   -3.23400000E-05  +1.98640000E-04  +9.17600000E-05  +1.53770100E-02  -1.22183000E-02
   +8.03390000E-04  +1.29020250E-01  -1.52256150E-01  +9.82500000E-04  +4.55430000E-04
   -3.30250000E-04  -7.49000000E-06  +7.05850000E-04  +5.67470000E-04  +4.62460000E-04
   -3.10130000E-04  -1.71530000E-04  -1.60580000E-04  +1.82620000E-04  +1.87860000E-04
   +5.04300000E-05  -6.74800000E-05  -2.66000000E-06  +9.72500000E-05  -3.59920000E-04
   +1.93990000E-04  +3.42140000E-04  +1.35130000E-04  -5.99860000E-04  -8.28730000E-04
   +9.02100000E-05  +1.38400000E-04  +6.31700000E-05  +6.90200000E-05  +4.85980000E-04
   +1.63739000E-03  -2.42920000E-04  -6.50350000E-04  +2.46600000E-05  -3.76000000E-06
   -1.36700000E-05  -8.00000000E-07  +7.53000000E-06  -3.10000000E-07  +2.10800000E-05
   +2.23300000E-05  +7.54100000E-05  +1.31210000E-04  -1.62318000E-03  -1.17613000E-03
   +6.89050000E-04  -1.42100000E-05  -3.33200000E-05  -1.60200000E-05  -3.33080000E-04
   +6.62740000E-04  -3.06820000E-04  -1.33380000E-04  -1.26800000E-05  -1.27770000E-04
   -3.38060000E-04  +2.64500000E-05  +1.29680000E-04  +1.32007900E-02  -1.01116100E-02
   -1.40650000E-03  -1.39910000E-02  +1.22294100E-02  -1.15850000E-04  -1.41510500E-01
   +1.64058300E-01  +1.36691000E-03  +1.30710000E-04  -1.48158000E-03  -7.12830000E-04
   -2.73271000E-03  -4.14598000E-03  +2.69170000E-04  -5.48000000E-04  +2.88220000E-04
   -1.61560000E-04  +2.12350000E-04  -1.87360000E-04  -1.17620000E-04  +2.01540000E-04
   +1.25160000E-04  +2.13809500E-02  -1.58686100E-02  -1.30761000E-03  -2.30396000E-03
   +2.33453000E-03  -4.78151200E-02  +4.33460000E-04  -3.07510000E-04  +1.03300000E-05
   +1.40630000E-04  +5.63570000E-04  +6.62700000E-04  +6.50000000E-06  +3.58000000E-06
   -2.22980000E-04  +1.15400000E-04  +7.44400000E-05  -2.25000000E-05  -1.33740000E-04
   +2.76400000E-05  +1.43320000E-04  -8.07800000E-05  -1.48390000E-04  -1.23810000E-04
   -3.83230000E-04  +3.51890000E-04  +4.00530000E-04  +5.84000000E-05  +2.76500000E-05
   -2.18700000E-05  +1.31827000E-03  -9.85370000E-04  +1.04771000E-03  -8.88640000E-04
   +6.39860000E-04  +9.52480000E-04  -6.68000000E-06  -1.49200000E-05  -3.85000000E-06
   +1.88800000E-05  -7.50000000E-06  +9.32000000E-06  +4.21400000E-05  -5.15000000E-06
   +3.99400000E-05  +6.95300000E-05  +3.86000000E-06  +2.23200000E-04  +8.66000000E-06
   -1.10000000E-06  +8.39000000E-06  -5.19110000E-04  +8.03700000E-05  -8.50250000E-04
   +6.00500000E-05  +1.43000000E-04  -5.87700000E-05  -1.82630000E-04  +1.53880000E-04
   +4.10810000E-04  -2.21958900E-02  +1.52211600E-02  +1.58451000E-03  +7.89440000E-04
   -4.60850000E-04  -1.02132000E-03  +1.29193000E-03  +9.88830000E-04  +5.11280500E-02
   -1.23863000E-03  +1.48765000E-03  +4.25070000E-03  +8.15443000E-03  -1.44091700E-02
   +1.37664500E-02  -5.89319600E-02  +3.25890200E-02  -2.14833100E-02  -2.41209000E-03
   +3.94814000E-03  +2.26536000E-03  -1.57612000E-03  -2.86960000E-04  +4.24120000E-04
   -2.12750000E-04  -1.62227000E-03  -1.35923000E-03  +3.96410000E-04  +7.09900000E-05
   -1.44330000E-04  -2.90990000E-04  +1.00265000E-03  -1.16482000E-03  -2.93180000E-04
   +1.29120000E-04  -7.76400000E-05  -4.33100000E-05  +1.31180000E-04  +8.97600000E-05
   +1.43600000E-05  -2.38000000E-06  -7.60300000E-05  -7.16900000E-05  -7.86400000E-05
   -9.40000000E-06  +3.09100000E-05  +3.74900000E-05  +3.79500000E-05  -4.28700000E-05
   -1.89900000E-05  -2.68000000E-05  +1.13680000E-04  +8.76000000E-05  +3.27000000E-06
   -1.68615000E-03  +9.22650000E-04  +1.12600000E-03  +1.20570000E-04  -9.37220000E-04
   +1.13202000E-03  -1.33800000E-05  -2.17100000E-05  -6.20000000E-07  +8.57000000E-06
   +4.92000000E-06  +1.54500000E-05  +7.41600000E-05  -9.54300000E-05  +1.85300000E-05
   -6.70000000E-06  -1.07200000E-05  +2.79000000E-06  +1.06500000E-05  -6.61000000E-06
   +1.19000000E-06  +1.36030000E-04  -2.25220000E-04  -1.32760000E-04  -6.73930000E-04
   +8.88300000E-04  +1.99440000E-04  -2.14433000E-03  +5.32270000E-04  -4.97560000E-04
   +2.17100000E-05  -7.08500000E-05  -1.48690000E-04  +3.34400000E-05  -3.36300000E-05
   +2.87500000E-05  -4.21000000E-05  -4.70900000E-05  -3.84200000E-05  +5.84706700E-02
   +1.38580000E-03  +3.67827000E-03  +1.91093000E-03  -2.40260000E-04  +1.61850000E-03
   +2.34656000E-03  +3.26892200E-02  -1.79768610E-01  +1.49227170E-01  +4.30622000E-03
   +2.12467000E-03  +1.32972000E-03  -1.45190000E-04  -3.94080000E-04  -1.18837000E-03
   -7.96870000E-04  -2.69770000E-03  -1.30370000E-03  +5.27630000E-04  -2.72450000E-04
   -5.21900000E-05  +1.58610000E-04  -7.63990000E-04  +5.38230000E-04  -2.85410000E-04
   +4.11760000E-04  +3.13470000E-04  -1.28660000E-04  +1.00350000E-04  +1.86550000E-04
   +1.02100000E-05  -3.98400000E-05  -6.95600000E-05  +3.15500000E-05  +4.75000000E-05
   +1.70400000E-05  -8.32000000E-06  -1.40100000E-05  +1.87000000E-06  -1.14710000E-04
   -1.43550000E-04  -9.61700000E-05  -3.92900000E-05  -5.06100000E-05  -2.14300000E-05
   +2.37788000E-03  -8.29700000E-05  -3.64120000E-04  +1.37820000E-04  +3.67500000E-05
   +1.17560000E-04  -7.20000000E-06  +2.60000000E-06  +8.56000000E-06  -1.27200000E-05
   -1.71900000E-05  +5.06000000E-06  -5.90000000E-07  -1.04390000E-04  +1.89300000E-05
   +1.54100000E-05  +2.20000000E-07  -1.24700000E-05  -1.10300000E-05  -1.50800000E-05
   +9.10000000E-07  +2.59300000E-05  -1.50510000E-04  -4.97580000E-04  +1.48457000E-03
   -1.17824000E-03  -3.48820000E-04  +1.81040000E-04  -1.84480000E-04  -2.75750000E-04
   -1.85200000E-05  -1.13900000E-05  +2.71000000E-06  -1.50000000E-05  -6.01000000E-06
   -1.14500000E-05  -4.37000000E-05  -4.33100000E-05  -1.60560000E-04  -4.07766500E-02
   +1.86923440E-01  +4.55903000E-03  +1.51527000E-03  +5.28290000E-04  -3.71363000E-03
   +1.44937200E-02  -1.14051900E-02  -2.19819300E-02  +1.49575760E-01  -2.01810180E-01
   +1.90925000E-03  +1.83007000E-03  +2.22108000E-03  -2.17200000E-05  -1.00229000E-03
   -1.97540000E-04  -2.41001000E-03  -6.25310000E-04  -1.56387000E-03  +6.06270000E-04
   -1.61030000E-04  +1.99400000E-05  -1.08990000E-04  -1.97960000E-04  +1.20020000E-04
   -2.61190000E-04  +1.69620000E-04  +1.78560000E-04  -4.85000000E-06  +2.31100000E-05
   +8.91800000E-05  -1.75400000E-05  -2.56500000E-05  +6.50000000E-06  +3.23800000E-05
   +3.23200000E-05  -4.76000000E-06  -1.88000000E-06  -1.64900000E-05  +2.72000000E-06
   -6.10900000E-05  -8.86800000E-05  -3.46500000E-05  -4.86700000E-05  -4.58800000E-05
   -1.02700000E-05  -7.68770000E-04  +8.73200000E-04  +5.75240000E-04  -1.22810000E-04
   +1.10971000E-03  -8.87370000E-04  -1.97000000E-06  +7.27000000E-06  +3.13000000E-06
   -7.97000000E-06  -7.45000000E-06  -3.27000000E-06  +1.05700000E-05  +1.68600000E-05
   -2.83800000E-05  +2.65000000E-06  +8.25000000E-06  -1.51900000E-05  -9.02000000E-06
   -3.94000000E-06  -1.06000000E-06  -5.00830000E-04  -2.79730000E-04  +2.62980000E-04
   +4.43600000E-05  -7.65250000E-04  +7.53000000E-05  -6.51710000E-04  +2.73090000E-04
   +2.45040000E-04  -5.51000000E-05  +3.78000000E-06  +5.06700000E-05  +1.02000000E-06
   -4.17900000E-05  -6.79900000E-05  +2.78300000E-05  -1.16190000E-04  -1.57800000E-04
   +2.27289800E-02  -1.65079880E-01  +2.09219030E-01  +1.18248000E-03  +1.71723200E-02
   -1.88033000E-02  -3.28513000E-03  +4.07928000E-03  +1.63813000E-03  -1.54434000E-03
   -2.82510000E-04  +4.68280000E-04  +6.89328000E-03  -1.44258900E-02  +1.47962300E-02
   -6.10765900E-02  +4.04758900E-02  -2.24737700E-02  +5.44180000E-04  +6.15540000E-04
   -1.02078000E-03  +2.21900000E-05  -9.24700000E-05  -9.22300000E-05  +1.54610000E-03
   -2.68449000E-03  -1.66065000E-03  +1.70430000E-04  +1.19230000E-04  +2.06500000E-05
   -5.87000000E-06  -4.42000000E-05  +1.18500000E-05  -1.42700000E-05  -3.13700000E-05
   +1.34800000E-05  +1.61100000E-05  +2.56900000E-05  +6.58000000E-06  -1.53600000E-05
   -2.45400000E-05  +5.10000000E-06  -1.86400000E-05  -4.06300000E-05  +1.47000000E-06
   -3.89600000E-05  -4.58300000E-05  +1.68000000E-06  -4.06220000E-04  +1.33960000E-04
   +1.38630000E-04  +1.17433000E-03  -1.47521000E-03  -2.72699000E-03  -6.55000000E-06
   +1.16800000E-05  -5.88000000E-06  -1.55200000E-05  -3.60000000E-06  -1.69100000E-05
   +1.15000000E-06  +3.18000000E-05  -2.66000000E-06  +4.29000000E-06  +1.25800000E-05
   -8.69000000E-06  -1.01700000E-05  -9.50000000E-07  -2.51000000E-06  -3.06500000E-05
   +8.65900000E-05  -1.40290000E-04  +9.43000000E-06  -1.05700000E-05  +2.01400000E-05
   +1.45400000E-05  -1.54200000E-05  -2.95800000E-05  +3.42000000E-06  +3.85000000E-05
   +3.29700000E-05  -4.38000000E-06  -1.10000000E-05  +1.70900000E-05  -2.12300000E-05
   +1.48900000E-05  +3.91400000E-05  +8.34300000E-05  +8.49400000E-05  +1.79200000E-05
   +5.80558300E-02  -9.31050000E-04  -8.25254000E-03  +1.55260100E-02  +4.70346000E-03
   +1.14148000E-03  +3.41660000E-04  -1.33300000E-04  -2.75020000E-04  -1.14706000E-03
   +4.08077000E-03  -1.55586000E-03  +2.60193000E-03  +4.06084000E-02  -1.72197420E-01
   +1.43480790E-01  -3.71660000E-04  -1.13520000E-04  +8.19030000E-04  +7.67000000E-05
   -1.20600000E-05  +1.11410000E-04  -2.34369000E-03  -3.79340000E-04  -2.87887000E-03
   -1.36090000E-04  -1.46640000E-04  -2.28800000E-05  +2.77000000E-06  +3.08800000E-05
   +2.75600000E-05  +1.06100000E-05  -1.60300000E-05  -1.31600000E-05  -5.26500000E-05
   -5.05100000E-05  -9.99000000E-06  +3.48100000E-05  +3.88500000E-05  -6.51000000E-06
   -5.10000000E-07  +3.97800000E-05  +5.26000000E-06  +7.62300000E-05  +5.58500000E-05
   +2.02000000E-06  +3.15900000E-04  -1.57840000E-04  -1.32160000E-04  -2.63259000E-03
   -4.32070000E-04  -2.76876000E-03  -1.16800000E-05  -9.53000000E-06  -1.71000000E-06
   +7.80000000E-07  +6.35000000E-06  +1.98000000E-06  -7.98000000E-06  -8.40000000E-06
   -3.31500000E-05  +3.01000000E-06  -1.72600000E-05  +2.26000000E-06  +1.30600000E-05
   +1.40000000E-06  -4.00000000E-08  +5.88000000E-06  -1.22790000E-04  +6.85900000E-05
   -2.64200000E-05  -7.13000000E-06  +1.56800000E-05  -9.70000000E-06  +1.51900000E-05
   -2.89500000E-05  +2.16200000E-05  +1.30700000E-05  -4.95300000E-05  -1.59500000E-05
   -8.18000000E-06  +1.80700000E-05  +1.65400000E-05  -3.86600000E-05  -6.10600000E-05
   +7.04700000E-05  +7.40100000E-05  +1.54960000E-04  -4.49954100E-02  +1.78634130E-01
   +2.96598000E-03  +3.06320000E-04  +9.48960000E-04  +9.64820000E-04  +9.27670000E-04
   +2.68729000E-03  +3.76070000E-04  -1.00473000E-03  -3.77150000E-04  -8.12646000E-03
   +1.79943200E-02  -1.19575000E-02  -2.23096100E-02  +1.43837140E-01  -1.86605930E-01
   +3.32530000E-04  -2.08100000E-05  +8.35300000E-05  -4.18600000E-05  +5.20000000E-07
   -1.76900000E-05  -1.91761000E-03  -2.68204000E-03  +6.47350000E-04  -1.63500000E-05
   +5.94500000E-05  +2.88400000E-05  +6.58000000E-06  -2.98700000E-05  +2.64000000E-06
   -1.81100000E-05  -1.77100000E-05  +2.60500000E-05  +3.18500000E-05  +4.31600000E-05
   +2.10600000E-05  -1.07400000E-05  -3.23300000E-05  -1.01000000E-05  -1.75100000E-05
   -9.32000000E-06  -2.60100000E-05  -6.00100000E-05  -6.35000000E-05  -2.97000000E-06
   -7.77300000E-05  -2.46800000E-05  +2.34300000E-05  -1.48032000E-03  -3.33320000E-03
   +6.59190000E-04  -4.19000000E-06  +1.70100000E-05  -4.00000000E-06  -1.58900000E-05
   -2.82000000E-06  -2.14700000E-05  +1.48200000E-05  +3.47600000E-05  +2.12000000E-06
   +8.35000000E-06  +3.59000000E-06  -6.97000000E-06  -5.96000000E-06  -2.47000000E-06
   +6.30000000E-07  -3.62900000E-05  -8.82000000E-06  -2.30200000E-05  -5.39000000E-06
   -3.60700000E-05  +1.39100000E-05  +2.26700000E-05  +5.61000000E-06  -1.93500000E-05
   +1.13600000E-05  +2.42600000E-05  +3.50000000E-06  -7.19000000E-06  -3.06000000E-05
   +3.50000000E-06  -2.30400000E-05  +3.00300000E-05  +2.37600000E-05  +4.92700000E-05
   +1.28230000E-04  +3.67900000E-05  +2.34404400E-02  -1.58568180E-01  +1.95008080E-01
   -1.22820000E-03  +4.35600000E-04  +4.88000000E-06  +1.96500000E-04  -2.89520000E-04
   +3.57520000E-04  +1.01422000E-03  +9.97730000E-04  -1.02673000E-03  -7.33926000E-03
   +3.00015700E-02  -3.30395000E-02  +2.03329000E-03  -6.08730000E-04  -1.45216000E-03
   -1.64160000E-04  -2.78000000E-06  +9.59900000E-05  +4.20400000E-05  -5.90000000E-07
   +2.90000000E-07  -3.49297100E-02  +1.50094900E-02  +1.04183600E-02  -5.92000000E-06
   -4.97000000E-05  -6.99000000E-06  +1.04000000E-06  -8.20000000E-06  +3.44600000E-05
   +3.62000000E-05  -3.37000000E-05  -2.13500000E-05  -1.24820000E-04  -8.54200000E-05
   -1.59800000E-05  +1.85400000E-05  +2.71200000E-05  +2.15300000E-05  -1.32900000E-05
   +2.80000000E-06  +2.85800000E-05  +1.39080000E-04  +9.21700000E-05  +1.51200000E-05
   +6.68400000E-05  -1.61800000E-05  -2.59000000E-05  +6.35800000E-04  -2.28090000E-04
   -3.73100000E-04  -2.93900000E-05  -1.57100000E-05  -1.12300000E-05  -6.59000000E-06
   +1.30300000E-05  -2.28000000E-06  -1.56300000E-05  +4.08000000E-06  -4.08500000E-05
   -1.03200000E-05  +1.53000000E-06  -4.95000000E-06  +7.06000000E-06  +3.46000000E-06
   -7.24000000E-06  +1.83600000E-05  -3.22800000E-05  +1.99100000E-05  -1.68300000E-05
   +3.03000000E-06  -5.15000000E-06  -9.95000000E-06  +1.12900000E-05  -3.10000000E-06
   -1.71200000E-05  +4.20600000E-05  +1.36500000E-05  -1.17400000E-05  +6.32000000E-06
   +1.50800000E-05  +2.70400000E-05  -3.03900000E-05  -8.07000000E-06  -4.15100000E-04
   +1.06360000E-04  -1.70900000E-05  -6.22130000E-04  -5.17310000E-04  +1.76105000E-03
   +4.61542200E-02  +1.85000000E-05  -5.45840000E-04  -8.12000000E-05  -2.67100000E-04
   +2.75810000E-04  +9.03800000E-05  +4.15100000E-04  -2.22140000E-04  +1.35572000E-03
   +2.30166000E-03  -2.01342100E-02  +1.93450500E-02  -2.99351000E-03  +2.65795000E-03
   -1.46102000E-03  +1.82820000E-04  -9.75500000E-05  +5.17100000E-05  -1.02400000E-04
   +4.95300000E-05  -4.91600000E-05  +4.40375400E-02  -2.34458410E-01  +2.50992480E-01
   +1.11500000E-05  +1.17160000E-04  +4.14000000E-06  -1.22100000E-05  -1.22700000E-05
   -9.38000000E-06  -3.39500000E-05  +1.04000000E-05  +3.89500000E-05  +1.14920000E-04
   +1.03830000E-04  +3.08100000E-05  -2.32700000E-05  -5.13700000E-05  -2.35700000E-05
   -5.51000000E-06  -2.22900000E-05  -3.54300000E-05  -1.49600000E-04  -1.29820000E-04
   -1.35800000E-05  -6.79100000E-05  -7.19000000E-06  +2.09200000E-05  -5.85170000E-04
   +3.41100000E-05  +2.59920000E-04  +1.23100000E-05  +3.12100000E-05  +3.92000000E-06
   -1.65400000E-05  -1.35600000E-05  -2.04200000E-05  +2.54800000E-05  +3.40200000E-05
   +3.68500000E-05  +1.70900000E-05  +2.44000000E-06  -7.26000000E-06  -1.04000000E-05
   -3.89000000E-06  +4.15000000E-06  -2.36200000E-05  +3.11400000E-05  -1.77800000E-05
   +8.88000000E-06  -1.71800000E-05  +1.36200000E-05  +1.01500000E-05  -8.74000000E-06
   -9.01000000E-06  +2.26500000E-05  -1.93000000E-05  -1.26900000E-05  +2.34000000E-06
   -3.77700000E-05  -9.95000000E-06  -4.33800000E-05  +5.26000000E-05  +2.90500000E-05
   +1.56120000E-04  -2.16180000E-04  -2.05450000E-04  +9.48370000E-04  +2.54600000E-04
   -2.41080000E-04  -4.72153300E-02  +2.51612290E-01  +4.90370000E-04  -4.04380000E-04
   -5.07430000E-04  +2.74180000E-04  +1.28860000E-04  -2.09270000E-04  -3.25700000E-04
   +8.39010000E-04  +4.41510000E-04  +1.15751000E-03  -4.07145000E-03  +1.27238000E-03
   +1.48196000E-03  -3.46928000E-03  +2.48084000E-03  -7.58000000E-05  +9.75600000E-05
   -1.47830000E-04  +1.02400000E-04  -5.56800000E-05  +5.36800000E-05  -2.54621600E-02
   +2.75619620E-01  -3.18527000E-01  +4.82100000E-05  -8.22700000E-05  -5.28000000E-06
   +7.89000000E-06  +1.42900000E-05  +3.08100000E-05  +3.90000000E-06  -1.55300000E-05
   -5.99000000E-06  -3.34700000E-05  -3.71500000E-05  -1.39300000E-05  +2.32000000E-05
   +3.15400000E-05  -2.13000000E-06  -1.18600000E-05  +6.14000000E-06  +1.97800000E-05
   +4.93900000E-05  +3.55300000E-05  -1.12000000E-06  +1.56000000E-05  +1.68000000E-06
   -2.02300000E-05  +5.34000000E-05  -1.42000000E-06  -1.92340000E-04  -9.54000000E-06
   -5.16000000E-06  +1.52000000E-06  -5.80000000E-06  +1.50000000E-06  +1.10000000E-07
   -4.69000000E-06  +3.93000000E-06  -2.62400000E-05  +2.26000000E-06  -1.01500000E-05
   +7.20000000E-07  +7.38000000E-06  +1.41000000E-06  -1.81000000E-06  +1.14000000E-05
   -1.22900000E-05  +1.91000000E-06  -7.16000000E-06  +2.29000000E-06  -5.80000000E-07
   -5.65000000E-06  +4.84000000E-06  -6.71000000E-06  +8.03000000E-06  +5.52000000E-06
   -6.03000000E-06  -3.59000000E-06  +7.84000000E-06  +1.71800000E-05  +1.79200000E-05
   -2.95500000E-05  -4.64700000E-05  -6.49800000E-05  -1.73550000E-04  -1.60800000E-05
   -5.64900000E-05  +9.66330000E-04  -5.05410000E-04  +2.06856600E-02  -2.67972200E-01
   +3.14321660E-01  +4.44989000E-03  -2.77153300E-02  +2.04301000E-02  -3.47593000E-03
   -2.94900000E-05  +4.10018000E-03  +1.24862000E-03  -6.49000000E-06  +4.03070000E-04
   -1.21782000E-03  -4.01110000E-04  +9.42090000E-04  +1.52112000E-03  -2.34719000E-03
   +1.21971000E-03  -2.02220000E-04  -1.01760000E-04  +1.16740000E-04  -6.93200000E-05
   +7.61900000E-05  +4.74500000E-05  +4.14100000E-04  -3.60900000E-05  -3.85450000E-04
   +2.29280000E-04  +9.19500000E-05  -6.53300000E-05  +1.24880000E-04  +2.72010000E-04
   +2.44200000E-05  -1.94610000E-04  -1.68870000E-04  +1.35160000E-04  +1.31860000E-04
   -5.22500000E-05  -1.17450000E-04  +3.38000000E-06  -7.22200000E-05  +7.95500000E-05
   +1.14300000E-05  +6.13400000E-05  -9.72900000E-05  -1.97010000E-04  -1.87440000E-04
   +2.89200000E-05  -7.87700000E-05  -4.58900000E-05  -2.78200000E-05  -6.61234900E-02
   +1.36311030E-01  -7.26549000E-02  -2.89800000E-05  +3.36400000E-05  -3.17300000E-05
   -2.74600000E-05  +2.30000000E-06  -3.86200000E-05  +1.32000000E-05  +3.90600000E-05
   +4.09000000E-06  +5.01700000E-05  +3.93100000E-05  -2.73700000E-05  -6.62200000E-05
   +2.93000000E-05  -2.06600000E-05  -8.55000000E-06  +2.99000000E-05  -1.84100000E-05
   -2.26100000E-05  -3.09300000E-05  +1.58500000E-05  +1.78000000E-06  +2.02300000E-05
   -3.72400000E-05  +1.14560000E-04  -2.38180000E-04  -2.93780000E-04  +2.77000000E-06
   +3.68700000E-05  -1.61600000E-05  -1.75700000E-05  +1.51300000E-04  -1.13790000E-04
   -1.69110000E-04  -3.61600000E-05  +1.65170000E-04  -1.21798000E-03  +1.60983000E-03
   -4.83660000E-04  -2.22090000E-04  +1.14510000E-04  +1.43620000E-04  +6.54336900E-02
   +2.89406000E-03  -6.93483000E-03  +2.13852000E-03  -5.66250000E-04  +2.01886000E-03
   -4.35540000E-04  +9.54880000E-04  +2.70540000E-04  +4.67730000E-04  +2.77090000E-04
   -6.57990000E-04  +1.07100000E-04  +1.43845000E-03  +2.15210000E-03  -4.55023000E-03
   +1.24030000E-04  +9.25300000E-05  -4.44210000E-04  -4.12700000E-05  -1.77860000E-04
   -3.85920000E-04  +2.18440000E-04  -1.83730000E-04  -2.08620000E-04  +1.16900000E-04
   -4.07200000E-05  +1.65800000E-04  +4.94800000E-05  -2.65100000E-05  -6.44600000E-05
   +1.01900000E-05  -7.27200000E-05  +4.58900000E-05  +3.03200000E-05  +8.09900000E-05
   +5.46700000E-05  -3.51600000E-05  -3.87300000E-05  -1.76900000E-05  -7.49600000E-05
   +1.91700000E-05  +6.70000000E-06  -8.15500000E-05  -1.11950000E-04  +4.57000000E-06
   -4.94600000E-05  -2.00800000E-05  +1.76000000E-06  +1.02844940E-01  -3.51330880E-01
   +2.44083940E-01  -1.95100000E-05  +3.03900000E-05  -2.46600000E-05  -2.35900000E-05
   +3.07000000E-06  -4.53800000E-05  +1.69700000E-05  +5.47600000E-05  +4.36000000E-06
   +1.04400000E-05  -2.47500000E-05  -3.43000000E-06  -6.50000000E-06  +6.03000000E-06
   -1.04000000E-06  -1.90800000E-05  +2.57600000E-05  -1.24400000E-05  -4.57000000E-06
   -2.76800000E-05  +9.08000000E-06  +1.04000000E-05  +1.02900000E-05  -1.27200000E-05
   +8.91000000E-05  -1.73400000E-04  +4.49010000E-04  +6.67000000E-06  -1.11490000E-04
   +8.01400000E-05  -5.47700000E-05  -2.72300000E-05  +1.03800000E-04  -7.83100000E-05
   -2.49700000E-05  -6.09800000E-05  -7.27300000E-05  +1.22850000E-04  +7.29240000E-04
   +2.26600000E-05  +1.08170000E-04  -2.00100000E-05  -1.08000590E-01  +3.54596260E-01
   -7.90500000E-03  +2.96696200E-02  -2.58677200E-02  +5.28847000E-03  -6.68090000E-04
   -1.55525000E-03  -8.40600000E-04  +1.72103000E-03  -2.86380000E-04  +6.21700000E-05
   -3.21400000E-04  -9.10400000E-04  -2.75499000E-03  -1.17154000E-03  +2.79203000E-03
   -7.08000000E-06  -2.14040000E-04  -4.28100000E-05  +1.83360000E-04  -4.86900000E-04
   -1.95900000E-05  -6.04520000E-04  +9.70000000E-05  +2.03220000E-04  -7.81800000E-05
   -8.38300000E-05  -5.81600000E-05  +9.04000000E-05  +8.29700000E-05  +1.34900000E-05
   +2.62500000E-05  -1.59050000E-04  +2.85000000E-06  -2.21180000E-04  -1.18230000E-04
   +2.41800000E-05  +1.99200000E-05  +5.48100000E-05  -1.38700000E-05  -3.59100000E-05
   +6.64500000E-05  -1.87600000E-05  +1.92030000E-04  +1.29730000E-04  -8.84000000E-06
   +3.19400000E-05  -3.38600000E-05  -4.40600000E-05  -4.20210400E-02  +2.13931010E-01
   -1.68694460E-01  -4.47300000E-05  -2.37000000E-05  -6.46000000E-06  -1.56100000E-05
   +1.90700000E-05  -2.10800000E-05  -8.35000000E-06  +2.45300000E-05  -8.43300000E-05
   -1.03200000E-05  -5.13000000E-05  +1.33300000E-05  +4.04300000E-05  -9.53000000E-06
   +2.85000000E-06  +2.14500000E-05  -1.95700000E-05  +3.05000000E-06  -1.04800000E-05
   -3.40000000E-07  +9.98000000E-06  -1.39400000E-05  +1.33200000E-05  -1.26700000E-05
   -7.04200000E-05  +2.56590000E-04  +2.58210000E-04  -8.40000000E-06  -3.81700000E-05
   +7.04900000E-05  +2.50100000E-05  -1.14030000E-04  +5.80900000E-05  +2.63210000E-04
   -4.47600000E-05  -2.56730000E-04  +1.32554000E-03  -1.98640000E-04  +5.33540000E-04
   +2.06980000E-04  -7.00300000E-05  +5.04900000E-05  +4.68837100E-02  -2.41918680E-01
   +1.93242560E-01  -2.79209200E-02  +3.59607300E-02  -2.02387200E-02  -3.93075300E-02
   -1.15432500E-02  +4.77595500E-02  -2.57018100E-01  +1.42624880E-01  -1.21033900E-02
   -1.06490250E-01  +2.44013000E-03  +2.58963600E-02  +4.42894300E-02  -2.48122800E-02
   -2.71908000E-03  +1.34242000E-03  +6.10930000E-04  +3.49516000E-03  -1.13797000E-03
   +7.11680000E-04  -2.24570000E-04  -2.61615300E-02  +4.66059600E-02  -2.68498500E-02
   -7.12900000E-05  +1.70950000E-04  +9.89500000E-05  -1.08180000E-04  +8.86400000E-05
   +1.79890000E-04  +2.83080000E-04  -1.49650000E-04  -2.18970000E-04  -3.43290000E-04
   -1.32900000E-04  +8.76600000E-05  -2.39000000E-05  -3.19800000E-05  +4.00000000E-06
   +5.68400000E-05  +1.86400000E-05  -6.09000000E-06  +3.74140000E-04  +2.36640000E-04
   +1.96700000E-05  +4.84090000E-04  -6.51700000E-04  +3.34160000E-04  +3.48421000E-03
   -2.14087000E-03  -1.77118000E-03  -7.51000000E-05  -4.81300000E-05  -3.62600000E-05
   -6.82000000E-06  +5.40300000E-05  -5.85000000E-06  -2.35830000E-04  -1.70060000E-04
   -2.22710000E-04  +1.58000000E-06  +1.60900000E-05  -1.17800000E-05  +1.83600000E-05
   -4.82000000E-06  -8.62000000E-06  +3.17100000E-04  -7.37000000E-06  -2.13890000E-04
   +1.08170000E-04  +3.85260000E-04  -1.17110000E-04  -1.17610000E-04  -3.55000000E-05
   -3.54940000E-04  +4.76400000E-05  +6.98000000E-06  -1.11520000E-04  -7.93100000E-05
   +1.06410000E-04  +9.67900000E-05  -2.22000000E-06  +2.84680000E-04  +3.71610000E-04
   +1.37888000E-03  +1.92412000E-03  +2.12042000E-03  -1.69636000E-03  +5.75920000E-04
   +4.69926000E-03  -6.05430000E-03  +2.76977000E-03  +3.10471000E-03  -4.75100000E-05
   -3.63410000E-04  +5.12210000E-04  +6.26796710E-01  +3.65801200E-02  -4.95329200E-02
   +2.96510900E-02  +1.84887400E-02  +3.66386000E-02  -5.74183600E-02  +9.48872800E-02
   -1.68527670E-01  +4.94341200E-02  +6.01961200E-02  -1.87931250E-01  +8.95758500E-02
   -5.58227200E-02  +1.27450600E-02  +3.68463600E-02  +1.94340000E-04  +3.65066000E-03
   +3.21255000E-03  -3.82200000E-04  +1.06800000E-04  +4.23500000E-04  +2.22347200E-02
   -2.61468800E-02  +2.43792500E-02  +8.99970000E-04  -1.12321000E-03  -4.22950000E-04
   +4.21990000E-04  -1.79130000E-04  -4.22600000E-05  -1.72740000E-04  -9.08300000E-05
   +3.51000000E-05  -2.86890000E-04  -5.47970000E-04  -3.49920000E-04  +2.66420000E-04
   +4.41490000E-04  +1.03140000E-04  -1.07740000E-04  +9.52800000E-05  +4.83210000E-04
   +5.42930000E-04  +4.71190000E-04  +9.29100000E-05  +7.94240000E-04  -2.89850000E-04
   -7.65600000E-05  -2.12862000E-03  +2.65378000E-03  -3.91658000E-03  -4.90200000E-05
   -7.89800000E-05  -3.47000000E-05  +5.42600000E-05  +4.71600000E-05  +5.99300000E-05
   -1.96100000E-05  +4.30500000E-05  -1.85610000E-04  -4.02200000E-05  -3.14600000E-05
   +1.11300000E-05  +4.09200000E-05  +5.78900000E-05  -3.50900000E-05  +1.55230000E-04
   +1.75000000E-05  +3.88600000E-05  +4.09600000E-05  +1.72790000E-04  +8.45100000E-05
   -3.46600000E-05  -1.42790000E-04  +1.14180000E-04  -1.25000000E-04  +1.67140000E-04
   +1.51190000E-04  -3.43100000E-05  +2.81000000E-05  +1.18300000E-05  +2.03180000E-04
   -2.06180000E-04  +2.83800000E-05  +1.94404600E-02  -7.85316000E-03  +6.75130000E-04
   +1.41148000E-03  +3.46942000E-03  +7.81190000E-04  +2.95208000E-03  +4.99020000E-04
   -9.91680000E-04  +5.38680000E-04  +4.12220000E-04  -1.11610000E-04  -2.05178000E-01
   +4.58678890E-01  -2.12827200E-02  +3.07935600E-02  -1.96033000E-02  +1.15732000E-02
   -3.33103400E-02  +3.23475500E-02  +4.62739900E-02  +9.84393000E-03  -1.13605860E-01
   -4.46126000E-02  +1.37537870E-01  -2.01852070E-01  +3.53212000E-02  +1.09861800E-02
   -3.78392300E-02  +4.15640000E-03  +3.41588000E-03  -2.10450000E-04  -1.11902000E-03
   +6.59040000E-04  -2.40350000E-04  +2.47097000E-03  +4.33002000E-03  +2.10357000E-03
   +7.48280000E-04  +6.67700000E-05  -1.33130000E-04  -8.28800000E-05  -1.54160000E-04
   -2.37840000E-04  -6.30600000E-05  +2.26650000E-04  +1.10790000E-04  +5.85530000E-04
   +6.24290000E-04  +3.13740000E-04  -2.35200000E-04  -3.52170000E-04  -2.90710000E-04
   +3.46830000E-04  +9.19700000E-05  -1.44860000E-04  -8.47620000E-04  -6.48990000E-04
   -1.13450000E-04  -1.41340000E-03  +8.25330000E-04  -1.06300000E-04  -1.70563000E-03
   -3.80760000E-03  +4.73594000E-03  +1.17400000E-04  +1.20660000E-04  +6.57000000E-05
   -5.34100000E-05  -9.98500000E-05  -5.21100000E-05  +2.05760000E-04  +1.60140000E-04
   +3.44510000E-04  +9.94800000E-05  -2.53000000E-06  -4.36000000E-06  -3.60800000E-05
   -2.89600000E-05  +4.06700000E-05  -3.88760000E-04  +1.37380000E-04  +2.18540000E-04
   -1.42210000E-04  -4.22660000E-04  -6.11700000E-05  +2.32320000E-04  +1.44840000E-04
   +3.12450000E-04  +1.69230000E-04  -2.32980000E-04  -1.16770000E-04  -3.82100000E-05
   -2.47430000E-04  -1.44940000E-04  -3.08050000E-04  +3.96580000E-04  +3.46800000E-04
   -1.97406100E-02  +1.56603000E-02  +3.66818000E-03  +3.92622000E-03  +1.34848000E-03
   +2.90600000E-05  +2.87629000E-03  -8.29630000E-04  +3.13680000E-04  -5.47590000E-04
   +2.50650000E-04  -2.21400000E-05  -1.54926020E-01  -2.15312030E-01  +5.31282550E-01
   +2.96155000E-03  -1.09157000E-03  -2.31730000E-03  +6.09850000E-04  +3.23395000E-03
   -1.16643000E-03  -3.54240000E-02  -2.51352000E-03  +3.74538900E-02  -9.70345000E-03
   +3.34747000E-03  +1.11013400E-02  -7.38950000E-04  +4.62020000E-03  -7.07000000E-05
   +5.59030000E-04  -8.65270000E-04  +1.00189000E-03  -4.19130000E-04  +8.15000000E-06
   -8.92900000E-05  +8.94733000E-03  -3.02804000E-03  -6.89796000E-03  +1.04080000E-04
   +5.42090000E-04  +1.29840000E-04  -1.49700000E-05  +7.85000000E-06  -1.15590000E-04
   -1.90940000E-04  +1.16410000E-04  +1.53860000E-04  +6.06570000E-04  +4.61660000E-04
   +1.21360000E-04  -1.02360000E-04  -1.76930000E-04  -1.21280000E-04  +1.91000000E-06
   -1.12830000E-04  -1.96380000E-04  -7.41630000E-04  -5.40430000E-04  -9.78800000E-05
   -3.76980000E-04  -3.72300000E-05  +1.76200000E-05  -5.01016000E-03  -1.27759000E-03
   +6.24285000E-03  +1.10440000E-04  +9.89100000E-05  +6.17400000E-05  -3.28400000E-05
   -8.90800000E-05  -3.07800000E-05  +1.49050000E-04  +1.24860000E-04  +2.08290000E-04
   +7.71300000E-05  -3.20000000E-06  +3.54000000E-06  -4.45800000E-05  -2.85100000E-05
   +3.16600000E-05  -1.74030000E-04  +1.83470000E-04  -3.60500000E-05  +8.10300000E-05
   -1.04970000E-04  +4.55600000E-05  +8.75900000E-05  -3.48000000E-06  +6.23700000E-05
   +1.24920000E-04  -2.29720000E-04  -7.84900000E-05  +9.53600000E-05  -6.87800000E-05
   -7.48900000E-05  -1.67330000E-04  +2.69970000E-04  +7.18500000E-05  +1.14135000E-03
   -2.36837000E-03  -1.35472000E-03  +1.43700000E-05  -1.11190000E-04  +2.55010000E-04
   +7.55310000E-04  +6.41840000E-04  -1.21337000E-03  -3.40640000E-04  +4.28410000E-04
   -6.42750000E-04  -1.81207380E-01  -1.56743700E-02  +1.38708530E-01  +5.29858490E-01
   -2.34153000E-03  +2.70266000E-03  -2.94677000E-03  +2.48720000E-03  -3.35528000E-03
   +7.08516000E-03  +2.05393900E-02  +1.07069200E-02  -2.27726900E-02  -1.90582800E-02
   -2.69707000E-03  +2.96839900E-02  +7.37377000E-03  -1.13143000E-03  +2.04754000E-03
   +6.24120000E-04  +5.18940000E-04  -5.12060000E-04  -2.87800000E-05  +4.83000000E-05
   +2.41000000E-06  -3.85195000E-03  +9.75000000E-06  -1.10850000E-03  +9.24000000E-05
   -1.58500000E-04  -3.77500000E-05  -1.34000000E-05  +3.32600000E-05  -4.23000000E-05
   +1.41200000E-05  +3.81000000E-05  -1.01400000E-05  +3.26600000E-05  +3.51000000E-05
   +2.72200000E-05  -1.43900000E-05  -1.11400000E-05  -2.85200000E-05  +6.88300000E-05
   +6.31800000E-05  -1.17800000E-05  -3.67000000E-05  -1.52600000E-05  -5.89000000E-06
   -2.13790000E-04  +2.80000000E-07  -8.22800000E-05  -6.95280000E-04  -7.08600000E-05
   +7.51400000E-04  +1.66500000E-05  -1.25000000E-06  +6.08000000E-06  +1.26500000E-05
   -1.28000000E-06  +5.12000000E-06  +1.31300000E-05  -2.62300000E-05  +4.43600000E-05
   +3.61000000E-06  -1.24400000E-05  +1.20500000E-05  +5.50000000E-06  -9.50000000E-07
   +6.15000000E-06  +1.61200000E-05  +2.17800000E-05  +1.19000000E-06  +2.32900000E-05
   +4.23100000E-05  +2.98600000E-05  -3.42700000E-05  +2.14400000E-05  +2.13700000E-05
   +3.78700000E-05  -6.03200000E-05  -5.49000000E-05  +8.56000000E-06  -5.76000000E-06
   -6.80000000E-06  -3.55600000E-05  +3.34000000E-05  -3.19000000E-06  -2.43379000E-03
   -8.14890000E-04  -1.76095000E-03  -8.57900000E-04  -8.76300000E-05  +9.82900000E-04
   -1.27574000E-03  +6.40410000E-04  +4.67810000E-04  +9.37300000E-05  -7.33500000E-05
   -1.65060000E-04  +1.48826900E-02  -8.06537400E-02  +3.98297700E-02  -2.45865950E-01
   +2.96448310E-01  -8.89000000E-04  -3.97014000E-03  +4.23804000E-03  -1.89630000E-04
   +6.56835000E-03  -3.26197000E-03  +9.65892000E-03  -3.66598000E-03  +2.64225000E-03
   +3.83995800E-02  +1.08588800E-02  -3.65968500E-02  -3.45649000E-03  +4.25170000E-03
   +3.06801000E-03  -8.86380000E-04  +6.40380000E-04  +2.16190000E-04  +1.99480000E-04
   -7.60000000E-07  +5.98000000E-05  -5.78033000E-03  -1.82674000E-03  +3.45056000E-03
   -5.00400000E-05  -4.52390000E-04  -3.46300000E-05  +9.41700000E-05  -3.13000000E-05
   +5.27700000E-05  +1.36040000E-04  -1.43960000E-04  -9.72500000E-05  -5.33700000E-04
   -4.48560000E-04  -1.64810000E-04  +1.04670000E-04  +1.91150000E-04  +1.58530000E-04
   -5.44400000E-05  +6.48100000E-05  +2.03980000E-04  +6.82130000E-04  +5.02040000E-04
   +1.10630000E-04  +4.32440000E-04  -2.16420000E-04  -9.19300000E-05  +5.04395000E-03
   +1.26695000E-03  -6.30283000E-03  -9.76100000E-05  -8.64200000E-05  -7.19300000E-05
   +4.40300000E-05  +1.00010000E-04  +2.00200000E-05  -1.73800000E-04  -9.45900000E-05
   -2.47240000E-04  -8.12000000E-05  +2.08000000E-05  -2.32000000E-06  +3.03100000E-05
   +3.41300000E-05  -3.47900000E-05  +1.53060000E-04  -1.40970000E-04  +7.21300000E-05
   -1.32600000E-05  +9.35400000E-05  -6.27100000E-05  -3.37900000E-05  +6.82100000E-05
   -2.39000000E-05  -1.54930000E-04  +2.47480000E-04  +1.27870000E-04  -5.96700000E-05
   +1.04420000E-04  +5.57500000E-05  +1.77940000E-04  -2.03680000E-04  -1.56700000E-05
   -1.27494000E-03  -1.87922000E-03  -6.41290000E-04  +1.13103000E-03  +4.08810000E-04
   -1.24598000E-03  +1.04360000E-03  -1.09310000E-03  +6.26130000E-04  +1.29070000E-04
   -4.89290000E-04  +6.92510000E-04  +1.01039200E-01  +6.54987100E-02  -2.01851350E-01
   -1.18705330E-01  -1.26486980E-01  +2.78963440E-01  -8.05600000E-05  -5.52020000E-04
   +7.20200000E-04  -1.65380000E-04  +1.80921000E-03  -6.58760000E-04  -1.44503000E-03
   -2.03150000E-03  +4.14988000E-03  +2.33187000E-03  +4.97380000E-04  -8.76060000E-04
   -1.26356000E-03  +6.14490000E-04  -2.39050000E-04  -1.83370000E-04  -3.78100000E-05
   +1.63050000E-04  +3.31600000E-05  -3.37000000E-06  +1.05700000E-05  -8.04160000E-04
   +1.47370000E-04  -4.68330000E-04  +6.61000000E-06  -5.20100000E-05  -9.34000000E-06
   -1.41700000E-05  +1.00600000E-05  +5.08200000E-05  +3.13500000E-05  -3.82100000E-05
   -3.20100000E-05  -1.29090000E-04  -1.05900000E-04  -3.14700000E-05  +3.36600000E-05
   +4.54800000E-05  +2.92000000E-05  -3.26300000E-05  -3.03000000E-06  +2.99000000E-05
   +1.58080000E-04  +1.11390000E-04  +1.49000000E-05  +8.24600000E-05  -3.81700000E-05
   +4.26000000E-06  +6.62220000E-04  +1.25830000E-04  -8.31040000E-04  -2.93700000E-05
   -2.10900000E-05  -9.13000000E-06  -4.94000000E-06  +1.17100000E-05  +5.27000000E-06
   -2.30800000E-05  -5.70000000E-06  -4.39900000E-05  -9.91000000E-06  -4.40000000E-07
   -4.27000000E-06  +8.30000000E-06  +4.14000000E-06  -8.25000000E-06  +3.72400000E-05
   -2.00700000E-05  -2.33000000E-06  -7.67000000E-06  +3.23700000E-05  -1.05000000E-06
   -2.66900000E-05  +5.28000000E-06  -2.29200000E-05  -2.05200000E-05  +3.84100000E-05
   +1.13200000E-05  -9.67000000E-06  +2.16500000E-05  +1.74600000E-05  +3.53600000E-05
   -3.01000000E-05  -5.96000000E-06  +7.51300000E-05  -3.98630000E-04  -1.04360000E-04
   +2.94790000E-04  +7.04100000E-05  -2.82130000E-04  +9.10300000E-05  -2.61320000E-04
   -4.08710000E-04  -2.28500000E-05  -5.17100000E-05  +1.20430000E-04  -3.08772400E-02
   +1.97119700E-02  -2.68530000E-04  -3.11595960E-01  +2.30411030E-01  -2.60650900E-02
   +3.42864590E-01  +2.31590000E-04  +5.35800000E-05  -3.02700000E-04  +5.52800000E-04
   +7.06280000E-04  +6.32540000E-04  -1.67988000E-03  +5.70090000E-04  +1.38195000E-03
   -5.36590000E-03  +3.13164000E-03  +3.08933000E-03  +5.89420000E-04  -6.93800000E-04
   -3.83090000E-04  -3.45700000E-05  +2.65000000E-06  +4.72000000E-05  +3.35800000E-05
   -7.99000000E-06  +1.76900000E-05  +1.11019000E-03  -1.76380000E-03  -3.16580000E-04
   +6.14400000E-05  +2.01000000E-06  +5.63000000E-06  +4.37000000E-06  -1.54000000E-06
   +1.49900000E-05  -1.62300000E-05  -1.84000000E-06  +1.63700000E-05  +3.65200000E-05
   +2.58100000E-05  +3.80000000E-06  +3.57000000E-06  -6.00000000E-06  -1.14800000E-05
   -5.98000000E-06  -9.08000000E-06  -4.38000000E-06  -4.34600000E-05  -4.16600000E-05
   -6.11000000E-06  -1.34200000E-05  +8.74000000E-06  -2.11000000E-05  -4.56110000E-04
   -2.18580000E-04  +6.32500000E-04  +2.30000000E-07  +1.16700000E-05  +2.76000000E-06
   -1.22300000E-05  -6.71000000E-06  -7.94000000E-06  +1.79900000E-05  +2.76200000E-05
   +1.89000000E-06  +9.07000000E-06  -2.01000000E-06  -4.19000000E-06  -2.35000000E-06
   +4.90000000E-07  -7.40000000E-07  -1.06600000E-05  +8.65000000E-06  +6.24000000E-06
   -4.62000000E-06  -2.50300000E-05  +8.46000000E-06  +5.66000000E-06  +7.82000000E-06
   +4.17000000E-06  +7.74000000E-06  -1.46800000E-05  -3.76000000E-06  -1.34000000E-06
   -9.43000000E-06  -5.60000000E-06  -5.66000000E-06  +9.59000000E-06  -1.51700000E-05
   -3.43380000E-04  -1.70470000E-04  -2.77200000E-04  -1.48000000E-04  -9.46000000E-06
   +2.02850000E-04  +6.77300000E-04  -5.17010000E-04  -8.83940000E-04  -8.11800000E-05
   +5.48700000E-05  -4.37600000E-05  -5.20520000E-03  +2.93998000E-03  -2.00096000E-03
   +2.60105810E-01  -2.22186760E-01  +5.03101600E-02  -2.50017110E-01  +2.18124370E-01
   -2.26470000E-04  +3.80190000E-04  -2.86430000E-04  +8.08220000E-04  -4.27400000E-04
   +1.47399000E-03  +3.72969000E-03  +1.69863000E-03  -4.64976000E-03  +6.21854000E-03
   -1.77529000E-03  -9.94200000E-04  -2.04360000E-04  -4.17520000E-04  +1.47400000E-05
   +2.22540000E-04  +7.69600000E-05  -1.41060000E-04  -4.82100000E-05  +4.63700000E-05
   -3.15800000E-05  -1.64303000E-03  +5.10790000E-04  -3.10790000E-04  +3.81500000E-05
   +3.04900000E-05  -2.12300000E-05  -2.96300000E-05  +1.64000000E-06  -5.12000000E-06
   -1.82900000E-05  +2.13900000E-05  +9.94000000E-06  +5.93200000E-05  +5.41400000E-05
   +2.02900000E-05  -1.16900000E-05  -2.66000000E-05  -2.13300000E-05  +4.36000000E-06
   -8.10000000E-07  -2.26300000E-05  -8.22600000E-05  -6.19300000E-05  -1.55400000E-05
   -6.81000000E-05  +2.68300000E-05  +6.74000000E-06  -6.76900000E-05  +6.43400000E-05
   -1.22230000E-04  +1.15700000E-05  +1.02000000E-05  +1.17600000E-05  -8.36000000E-06
   -1.46700000E-05  -2.26000000E-06  +2.33700000E-05  +1.62300000E-05  +3.87100000E-05
   +1.14900000E-05  -2.11000000E-06  -2.89000000E-06  -2.48000000E-06  -4.31000000E-06
   +4.09000000E-06  -1.43300000E-05  +1.70900000E-05  -1.86000000E-06  +7.33000000E-06
   -1.82900000E-05  +8.73000000E-06  +9.22000000E-06  -2.24000000E-06  -4.41000000E-06
   +1.48300000E-05  -1.43400000E-05  -1.39000000E-05  -2.43000000E-06  -2.87400000E-05
   -9.66000000E-06  -3.18800000E-05  +2.91100000E-05  +1.96200000E-05  -1.63090000E-04
   -2.34200000E-04  -2.01030000E-04  -1.18500000E-05  +1.98000000E-05  +4.03500000E-05
   -1.53730000E-03  -1.15740000E-04  +6.09490000E-04  +1.08370000E-04  -7.66000000E-06
   -4.71700000E-05  +3.03209600E-02  -2.27947800E-02  +3.96640000E-04  -6.24620200E-02
   +7.50322000E-02  -4.40111500E-02  +2.50455300E-02  -5.20898100E-02  +4.82611600E-02
end_hess

