# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.19470960    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -9.34561251E+00  -3.84780285E+00  -6.04300234E-01
   006   -7.34568863E+00  -2.25508547E+00  -3.52049458E-01
   006   -5.45789133E+00  -2.05273276E+00  -2.16881561E+00
   006   -3.46622035E+00  -4.03523313E-01  -1.80062052E+00
   006   -3.28479903E+00  +1.09002093E+00  +3.59650913E-01
   006   -5.19134096E+00  +8.53950267E-01  +2.14923726E+00
   006   -7.20241421E+00  -7.94614678E-01  +1.81420225E+00
   006   -1.07100209E+00  +2.93403140E+00  +6.23603570E-01
   006   -1.46299467E+00  +5.06778987E+00  -1.30538410E+00
   006   -9.51602533E-01  +4.14556388E+00  +3.25948944E+00
   006   +1.41654906E+00  +1.51144594E+00  +2.02637602E-01
   006   +3.28350583E+00  +2.38408103E+00  -1.41481635E+00
   006   +5.54581398E+00  +1.07610696E+00  -1.67893464E+00
   006   +5.96421493E+00  -1.12276502E+00  -3.23028467E-01
   006   +4.09757642E+00  -2.00335482E+00  +1.29385578E+00
   006   +1.84814001E+00  -7.06724489E-01  +1.55899698E+00
   008   +8.20852882E+00  -2.34890440E+00  -6.51574560E-01
   001   -9.22704839E+00  -4.72639434E+00  -2.17995528E+00
   001   -5.54088079E+00  -3.19365662E+00  -3.86880831E+00
   001   -1.99678264E+00  -2.96587814E-01  -3.22141380E+00
   001   -5.13822048E+00  +1.96582861E+00  +3.86200405E+00
   001   -8.67040467E+00  -9.59018569E-01  +3.22633140E+00
   001   -3.30227345E+00  +5.93972139E+00  -9.89704655E-01
   001   -2.57027774E-02  +6.53234030E+00  -1.10936712E+00
   001   -1.42051347E+00  +4.36515336E+00  -3.24092620E+00
   001   -8.08037730E-01  +2.72891636E+00  +4.74798990E+00
   001   +7.12304808E-01  +5.35359182E+00  +3.37791625E+00
   001   -2.61084233E+00  +5.31434376E+00  +3.62314340E+00
   001   +3.04892037E+00  +4.08465802E+00  -2.51667128E+00
   001   +3.98641581E-01  -1.44854572E+00  +2.80185043E+00
   001   +8.21590415E+00  -3.83240292E+00  +3.89550856E-01
   008   +4.66566823E+00  -4.19303374E+00  +2.53929177E+00
   001   +3.26966601E+00  -4.69360031E+00  +3.57177011E+00
   008   +7.33665122E+00  +1.96210849E+00  -3.27794514E+00
   001   +8.75684277E+00  +8.33997073E-01  -3.22874874E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.00000000E-08  +4.90000000E-07  -1.27000000E-06
   -1.20000000E-07  +4.50000000E-07  -8.00000000E-07
   +0.00000000E+00  +7.00000000E-07  -7.10000000E-07
   +1.90000000E-07  +3.20000000E-07  -1.40000000E-07
   -1.00000000E-07  -2.00000000E-08  -2.00000000E-08
   -2.90000000E-07  -1.90000000E-07  -1.90000000E-07
   -9.00000000E-08  -2.40000000E-07  -5.80000000E-07
   +8.00000000E-08  +1.10000000E-07  +6.20000000E-07
   +5.00000000E-08  +3.30000000E-07  +8.30000000E-07
   +2.70000000E-07  -8.50000000E-07  +6.90000000E-07
   -8.00000000E-08  -6.00000000E-08  +7.00000000E-08
   +3.70000000E-07  +3.30000000E-07  +1.90000000E-07
   -2.80000000E-07  -3.80000000E-07  +9.10000000E-07
   -7.00000000E-08  +1.70000000E-07  -2.50000000E-07
   -1.60000000E-07  -7.20000000E-07  -1.30000000E-07
   +5.00000000E-08  -5.20000000E-07  +2.00000000E-08
   +2.20000000E-07  -3.20000000E-07  -4.40000000E-07
   -1.00000000E-07  +7.90000000E-07  -1.45000000E-06
   +3.00000000E-08  +1.02000000E-06  -9.80000000E-07
   +1.20000000E-07  +7.60000000E-07  -2.60000000E-07
   -1.70000000E-07  -7.50000000E-07  +5.00000000E-08
   -1.50000000E-07  -3.50000000E-07  -6.80000000E-07
   +1.30000000E-07  +3.50000000E-07  +9.60000000E-07
   +2.40000000E-07  +3.60000000E-07  +1.32000000E-06
   +3.50000000E-07  +8.50000000E-07  +7.60000000E-07
   -2.10000000E-07  -1.01000000E-06  +5.50000000E-07
   +2.20000000E-07  -8.00000000E-07  +1.15000000E-06
   +1.10000000E-07  -4.40000000E-07  +8.30000000E-07
   +2.20000000E-07  +4.80000000E-07  +9.30000000E-07
   -2.80000000E-07  -5.80000000E-07  -3.20000000E-07
   -3.40000000E-07  -7.00000000E-08  -5.80000000E-07
   -3.60000000E-07  -5.10000000E-07  -9.60000000E-07
   -3.80000000E-07  -8.50000000E-07  -8.30000000E-07
   +3.50000000E-07  +9.20000000E-07  +2.10000000E-07
   +2.30000000E-07  +2.40000000E-07  +5.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.94299160E-01  +1.64991020E-01  +3.07883980E-01  -4.36069300E-02  +2.65996000E-01
   +5.12015160E-01  -2.17320740E-01  -1.34594530E-01  -1.63987000E-02  +5.56984220E-01
   -1.11202980E-01  -1.51194460E-01  -4.57117800E-02  +2.04519700E-01  +4.30601260E-01
   +2.21924900E-02  -1.77969900E-02  -9.83255900E-02  -1.23044570E-01  +1.93889440E-01
   +6.12486860E-01  -3.71764500E-02  -1.61108700E-02  +2.71990000E-02  -2.01493260E-01
   -4.67611300E-02  +7.65454800E-02  +5.43568840E-01  -3.49928200E-02  -3.27598000E-03
   +1.92697800E-02  -7.12520000E-03  -1.00853270E-01  -4.16940000E-02  +2.21300320E-01
   +4.20848850E-01  -2.36954000E-03  -2.07036000E-03  +9.12285000E-03  +1.38660050E-01
   +3.12906000E-03  -2.21677530E-01  -1.20595330E-01  +2.15782910E-01  +6.02900980E-01
   +3.32221000E-03  -2.67300000E-03  +3.48750000E-04  -4.47683100E-02  -6.82694000E-03
   +4.24577500E-02  -2.44920580E-01  -1.52907580E-01  -3.31887300E-02  +5.88433710E-01
   +1.44270000E-03  +3.04842000E-03  -8.08158000E-03  -3.45594900E-02  +1.68426200E-02
   +6.11350100E-02  -1.19896340E-01  -1.84183550E-01  -6.18678700E-02  +2.12827320E-01
   +4.04701630E-01  +6.71839000E-03  -3.59518000E-03  -5.98784000E-03  -1.46099000E-03
   +2.99968300E-02  +5.14524600E-02  +1.85422500E-02  -2.48521700E-02  -1.20012960E-01
   -1.55717800E-01  +1.70920310E-01  +5.83845190E-01  -1.76784000E-03  -2.21431000E-03
   -3.09187000E-03  -1.05039800E-02  +1.35570400E-02  +2.74904000E-02  +2.28770800E-02
   -7.17505000E-03  -2.79016100E-02  -1.13252290E-01  -4.32370500E-02  -2.03890900E-02
   +5.21884350E-01  -1.86563000E-03  -1.17258000E-03  +2.19640000E-03  +1.43908300E-02
   -9.18866000E-03  -2.12730200E-02  -3.17045300E-02  -2.33359700E-02  -1.39462800E-02
   -1.14399800E-02  -1.57987160E-01  -1.23772340E-01  +1.59509120E-01  +4.00455710E-01
   -3.67623000E-03  +1.73576000E-03  +5.48453000E-03  +2.94151000E-02  -2.04625000E-02
   -7.15660600E-02  -6.91642300E-02  -4.25534400E-02  +1.90200000E-02  +3.16468500E-02
   -8.73758900E-02  -2.43619860E-01  -1.31478110E-01  +1.50017240E-01  +5.70661820E-01
   +5.13990000E-04  +2.46373000E-03  +9.24841000E-03  +2.66603400E-02  -3.15788900E-02
   -7.83096800E-02  -5.63547700E-02  -2.53791800E-02  +1.93106500E-02  +3.30675000E-02
   +4.94095000E-02  +5.14419000E-02  -2.16959340E-01  -5.32740600E-02  +8.60048100E-02
   +5.36321920E-01  -6.02640000E-04  +4.58592000E-03  -3.30440000E-04  -4.19878000E-03
   -2.77697300E-02  -4.30391200E-02  -2.36124400E-02  -1.48064200E-02  +9.10788000E-03
   +2.43664100E-02  +2.70885500E-02  +2.23474000E-03  -2.10808700E-02  -9.99542100E-02
   -2.77332700E-02  +2.05407840E-01  +4.21854440E-01  +4.20441000E-03  -3.77851000E-03
   -5.72788000E-03  -3.38370300E-02  -1.21609800E-02  +2.12647600E-02  +2.09629900E-02
   +1.03902200E-02  -1.09316700E-02  +1.19976600E-02  -2.57264300E-02  -4.55148900E-02
   +1.37523470E-01  +7.46504000E-03  -2.10895880E-01  -1.22073530E-01  +2.08730800E-01
   +6.15111430E-01  -3.41361000E-03  -3.21303900E-02  -3.87710200E-02  -1.14214390E-01
   -7.47430000E-04  +4.78300800E-02  +3.29681200E-02  +2.31552900E-02  +9.07225000E-03
   -1.74495600E-02  -2.34151500E-02  -2.08077400E-02  -4.02795300E-02  -8.60796000E-03
   +4.06015100E-02  -2.39830670E-01  -1.47381430E-01  -2.94760900E-02  +5.83265020E-01
   -1.38321800E-02  -2.39180300E-02  -3.44896400E-02  -3.77648500E-02  -1.53458610E-01
   -8.80825700E-02  +4.56808200E-02  +2.70517500E-02  -2.26448900E-02  -2.19155100E-02
   -3.72512600E-02  -2.96126900E-02  -3.26319200E-02  +1.68397900E-02  +5.19298800E-02
   -1.14421160E-01  -1.80471400E-01  -5.86645600E-02  +2.22453980E-01  +4.02002120E-01
   -9.73411000E-03  -1.37655400E-02  -3.11873000E-03  -1.09615100E-02  -1.30065880E-01
   -2.66496940E-01  +4.49767900E-02  +3.09844000E-03  -3.75994500E-02  -1.85304700E-02
   -2.79113000E-02  -2.67858600E-02  +1.95284000E-03  +2.51603000E-02  +4.41010400E-02
   +2.20059900E-02  -2.23537400E-02  -1.20157950E-01  -1.63095210E-01  +1.80938350E-01
   +6.03582360E-01  +1.43591000E-03  +1.35439000E-03  -4.92400000E-05  -2.23883000E-03
   -1.80930000E-04  +1.25383000E-03  +4.17023000E-03  +1.53860000E-04  +1.54681000E-03
   -2.07245000E-03  -6.63053000E-03  -6.71228000E-03  -1.33226650E-01  -4.71055700E-02
   +3.46620000E-04  -1.62511200E-02  -1.48593200E-02  -6.11160000E-04  +1.04793000E-03
   -1.77393000E-03  +3.80598000E-03  +4.74304280E-01  +7.86540000E-04  +1.62090000E-04
   +3.68180000E-04  -5.08120000E-04  -7.60940000E-04  -1.19900000E-05  -2.45300000E-04
   +2.79342000E-03  -3.38583000E-03  -1.52304100E-02  -1.36650300E-02  -5.20128000E-03
   -4.85073800E-02  -1.12895480E-01  -1.11075400E-02  -4.99174000E-03  +1.24897000E-03
   +3.59302000E-03  -8.00280000E-04  +4.28941000E-03  -2.93484000E-03  +7.57810000E-04
   +4.81733880E-01  +6.13480000E-04  +1.09011000E-03  +3.99540000E-04  +1.00180000E-04
   -7.64530000E-04  -1.74091000E-03  +1.53316000E-03  -4.61380000E-03  -3.35185000E-03
   -2.19868500E-02  -1.67806400E-02  +1.37896000E-03  -2.91053000E-03  -1.34732200E-02
   -8.67682100E-02  +1.29718100E-02  +1.35612600E-02  +7.52876000E-03  +4.26946000E-03
   -1.62338000E-03  -1.03380000E-03  +5.76080000E-04  -7.84930000E-04  +4.81002030E-01
   -1.14352000E-03  -1.02687000E-03  -3.04460000E-04  +5.50470000E-04  +6.70700000E-04
   +6.02060000E-04  -2.09990000E-04  +5.71460000E-04  +2.66450000E-04  -4.15240000E-04
   -1.13543000E-03  +5.01130000E-04  +3.90400000E-04  -2.02433600E-02  +1.75525400E-02
   -7.33360000E-04  -1.65202000E-03  -1.05335000E-03  -1.37934000E-03  +2.80370000E-04
   -1.03139000E-03  -7.73841200E-02  +6.86660000E-03  -6.39053000E-03  +5.83385840E-01
   -4.81010000E-04  -4.84030000E-04  -1.71690000E-04  +1.36730000E-04  +4.67200000E-04
   +5.87300000E-04  -7.35700000E-05  +7.89100000E-04  +2.11810000E-04  -6.00300000E-05
   -5.53210000E-04  +1.14367000E-03  -6.70842000E-03  -2.58873800E-02  +1.56297700E-02
   +1.56317000E-03  -8.61120000E-04  -1.00377000E-03  -8.84150000E-04  +4.27400000E-05
   -9.61330000E-04  +1.22855000E-02  -1.27656060E-01  +4.98680200E-02  +1.53064700E-02
   +5.15794890E-01  -5.62710000E-04  -4.89990000E-04  -2.13950000E-04  +1.81470000E-04
   +2.69530000E-04  +5.37550000E-04  +3.15530000E-04  +1.75320000E-04  -1.82420000E-04
   -1.62530000E-03  -1.39405000E-03  -2.03830000E-04  +5.56071000E-03  +4.52496000E-03
   +1.61654000E-03  -4.64870000E-04  -3.74920000E-04  -2.37190000E-04  -2.38230000E-04
   -2.86910000E-04  -3.82380000E-04  -9.88266000E-03  +4.64403800E-02  -1.19094430E-01
   -1.44979700E-02  +6.20075900E-02  +5.39984000E-01  -5.16500000E-04  -4.32260000E-04
   -9.24100000E-05  +3.62200000E-04  +2.56380000E-04  +1.52200000E-04  +3.63100000E-04
   -8.45100000E-04  -1.01502000E-03  -4.31713000E-03  -2.97855000E-03  +8.13840000E-04
   -1.51183000E-03  -1.18507000E-02  -2.52470500E-02  -1.38171000E-03  -7.90140000E-04
   -8.28990000E-04  +1.27850000E-04  -2.53060000E-04  -7.77650000E-04  -7.56479400E-02
   -2.98490000E-04  -2.20600000E-05  +2.84620000E-04  -1.03427000E-03  -4.74272000E-03
   +5.85704180E-01  -9.97100000E-05  -1.00140000E-04  -3.33300000E-05  -7.55300000E-05
   +1.24260000E-04  -1.03990000E-04  +2.01910000E-04  -5.07150000E-04  -8.27560000E-04
   -3.53732000E-03  -1.16926000E-03  +5.13300000E-04  -4.41720000E-03  -1.19770400E-02
   -2.18359300E-02  -4.29620000E-04  -1.02792000E-03  +3.41810000E-04  +5.34460000E-04
   -2.88530000E-04  -7.16690000E-04  -3.80372000E-03  -9.17905800E-02  -3.82786800E-02
   +6.63340000E-04  +8.63736000E-03  +2.36147700E-02  -2.24803000E-03  +5.62932560E-01
   +3.17260000E-04  +2.56520000E-04  +7.88000000E-06  -2.82940000E-04  -1.28450000E-04
   +2.40080000E-04  +4.51000000E-04  +1.68120000E-04  +2.53500000E-05  +6.29920000E-04
   +8.05750000E-04  +2.40460000E-04  -5.51003000E-03  -4.41299000E-03  -3.47951000E-03
   +1.03054000E-03  +7.89180000E-04  +3.14450000E-04  +3.01100000E-04  +9.82000000E-06
   -2.95970000E-04  -6.02675000E-03  -3.54964500E-02  -1.56077520E-01  -2.00716000E-03
   -4.81628000E-03  -3.50981000E-02  -7.71679000E-03  -5.29835300E-02  +4.88415560E-01
   +1.72110000E-04  +1.28700000E-04  -9.91000000E-06  -2.80360000E-04  -3.58800000E-05
   +4.27180000E-04  +3.59770000E-04  +5.53920000E-04  +6.53120000E-04  -7.54780000E-04
   +5.79990000E-04  -3.34540000E-04  -3.49310100E-02  +4.59629000E-03  +6.24633000E-03
   -9.62440000E-04  -1.52060000E-04  -2.11974000E-03  -6.11600000E-05  -9.26640000E-04
   +5.33330000E-04  -1.45982480E-01  +4.00049200E-02  +1.37632800E-02  -5.62361000E-03
   +8.36395000E-03  -3.02312000E-03  -3.31241000E-03  +6.42513000E-03  +9.83771000E-03
   +5.61069380E-01  -8.06370000E-04  -8.08440000E-04  -2.53370000E-04  +2.49330000E-04
   +8.41280000E-04  +6.13450000E-04  +1.17330000E-04  -1.70030000E-04  +1.01510000E-04
   -2.14933000E-03  -6.66920000E-04  -4.49630000E-04  -1.45329700E-02  +1.23983300E-02
   +5.56990000E-03  -1.65990000E-03  -2.66107000E-03  -1.52275000E-03  -5.69230000E-04
   -1.19473000E-03  +5.20800000E-04  +3.71575600E-02  -1.03857990E-01  +3.79063000E-03
   +2.34812700E-02  -1.55242900E-02  -2.98647000E-03  +1.37070600E-02  -1.10106000E-02
   -9.88476000E-03  -6.81809000E-02  +5.19473460E-01  -2.88760000E-04  -3.41140000E-04
   -1.16200000E-05  +2.36970000E-04  +1.77050000E-04  +4.87000000E-06  -2.39450000E-04
   +3.27300000E-04  -7.61300000E-05  -2.18316000E-03  -8.63090000E-04  +1.96880000E-04
   +2.12713000E-03  +1.11138000E-03  -4.34770000E-04  +1.22210000E-04  +2.53360000E-04
   -9.77300000E-05  -2.86700000E-05  +5.30100000E-05  -1.08620000E-04  +1.68141900E-02
   +1.79872000E-03  -7.94210700E-02  -2.05285200E-02  +1.13578400E-02  +4.14476000E-03
   +2.75224800E-02  -1.82667900E-02  -9.30888000E-03  -1.54423690E-01  -1.95272050E-01
   +4.10076980E-01  -4.43330000E-04  -3.32920000E-04  -7.89300000E-05  +4.69090000E-04
   +2.66330000E-04  -2.87020000E-04  -3.54360000E-04  -3.22950000E-04  +2.23320000E-04
   +6.02170000E-04  +6.73000000E-05  +4.68810000E-04  -1.20609000E-03  +1.79066000E-03
   +6.27320000E-04  -6.98150000E-04  -7.85700000E-04  -1.98450000E-04  +9.61300000E-05
   +2.72600000E-05  +2.25790000E-04  -1.82798400E-02  -5.12391000E-03  +1.50878000E-02
   -2.30370000E-03  +2.23150000E-04  +1.41657000E-03  -1.25009000E-03  -1.25138000E-03
   -1.01126000E-03  -2.23579070E-01  -1.17838700E-02  +9.52312700E-02  +6.01095890E-01
   +3.41570000E-04  +2.80060000E-04  +8.07500000E-05  -3.20470000E-04  -1.74840000E-04
   +5.80300000E-05  +2.20730000E-04  +2.24120000E-04  -6.19100000E-05  -1.73930000E-04
   +1.01800000E-04  -2.84000000E-05  +1.37841000E-03  -2.34478000E-03  -1.23430000E-03
   +5.55150000E-04  +7.38380000E-04  +2.12540000E-04  +2.85900000E-05  +1.34170000E-04
   -1.72310000E-04  +9.98944000E-03  +1.07466500E-02  -9.44775000E-03  +1.29813000E-03
   -5.32230000E-04  -6.13900000E-04  +1.66750000E-03  -1.04530000E-03  -2.38150000E-04
   -6.00448400E-02  -1.35100620E-01  +8.42952900E-02  -1.17520810E-01  +5.72042750E-01
   -1.11340000E-04  -1.29790000E-04  +8.78000000E-06  -1.32540000E-04  +1.10070000E-04
   +3.23230000E-04  +1.99810000E-04  +2.99680000E-04  +2.01140000E-04  -4.90160000E-04
   -1.37250000E-04  -8.64750000E-04  -1.77996000E-03  -5.94200000E-05  +2.71480000E-04
   +2.59510000E-04  +2.11380000E-04  +3.37000000E-06  -2.12170000E-04  -4.05350000E-04
   -6.99000000E-05  +5.56364000E-03  -1.70912000E-03  +1.13209000E-03  -3.98560000E-04
   -7.60460000E-04  -5.34220000E-04  -3.58000000E-04  +4.42610000E-04  +7.10300000E-05
   +1.29558850E-01  +6.00426300E-02  -1.72856310E-01  -1.70812890E-01  -2.59610250E-01
   +4.02042180E-01  +6.69030000E-04  +5.26030000E-04  +9.94400000E-05  -6.00790000E-04
   -4.12650000E-04  +4.86000000E-05  +3.64550000E-04  -7.89000000E-06  -3.41050000E-04
   -2.23540000E-04  +7.02800000E-05  +9.05900000E-05  -3.71540000E-04  -3.32200000E-05
   +1.72520000E-04  +1.09770000E-04  +1.77840000E-04  +6.45100000E-05  +4.44500000E-05
   +1.17100000E-05  +5.52900000E-05  -3.44760000E-04  -3.56770000E-04  +3.50163000E-03
   +6.88000000E-04  -6.91690000E-04  -1.32900000E-05  -8.87840000E-04  +7.12960000E-04
   +1.83000000E-05  -4.66336400E-02  -2.57113700E-02  +4.37902300E-02  -2.55341790E-01
   +1.33717390E-01  +6.69205000E-03  +6.58603680E-01  +3.37120000E-04  +3.13970000E-04
   +1.19470000E-04  -1.40740000E-04  -3.53050000E-04  -4.94110000E-04  -2.52910000E-04
   -2.80280000E-04  +1.28090000E-04  +5.73570000E-04  -1.42530000E-04  +6.31500000E-05
   +7.24430000E-04  -4.42120000E-04  -4.02850000E-04  -3.55430000E-04  -3.48320000E-04
   +3.94380000E-04  +2.20230000E-04  +4.03030000E-04  +2.53960000E-04  +2.02000000E-06
   +1.22998000E-03  +3.67301000E-03  +7.99910000E-04  -6.06340000E-04  -7.08000000E-05
   -1.19920000E-04  -3.56270000E-04  +1.17010000E-04  +1.56477100E-02  +5.60123800E-02
   -4.70764100E-02  +7.42084700E-02  -1.72666370E-01  +3.75806700E-02  -1.41322170E-01
   +5.68188590E-01  -5.25400000E-04  -4.15190000E-04  -1.24870000E-04  +3.94040000E-04
   +3.58600000E-04  +2.81540000E-04  -4.58000000E-06  +1.78000000E-04  +8.33900000E-05
   -1.41310000E-04  +6.92000000E-06  -2.44600000E-04  +8.21210000E-04  -3.20930000E-04
   -4.11350000E-04  +3.50430000E-04  +3.26120000E-04  -6.13900000E-05  -1.25270000E-04
   -1.69820000E-04  -2.90000000E-04  +4.09504000E-03  +4.53562000E-03  +2.17971000E-03
   -9.92890000E-04  +5.88380000E-04  +8.79200000E-05  -1.41768000E-03  +6.96840000E-04
   +2.66540000E-04  +1.40849000E-02  -2.58396400E-02  +1.13721800E-02  +4.86493300E-02
   +6.65862000E-03  -9.44224700E-02  -1.68716110E-01  -2.23517360E-01  +4.03926650E-01
   +6.71990000E-04  +5.79090000E-04  +1.05390000E-04  -5.45770000E-04  -4.51900000E-04
   -1.12910000E-04  +2.19090000E-04  -4.59200000E-05  -2.49310000E-04  -5.37500000E-05
   +1.48680000E-04  +1.99060000E-04  -1.44560000E-04  -4.45590000E-04  -5.37200000E-05
   +6.50600000E-05  +1.94140000E-04  +7.82100000E-05  +1.38620000E-04  +1.86160000E-04
   +8.31000000E-05  -2.28209000E-03  +1.03340000E-04  -1.83130000E-04  +2.39380000E-04
   +2.51630000E-04  -2.17680000E-04  +6.97490000E-04  -2.51550000E-04  +7.96600000E-05
   -3.35579000E-03  -1.89568200E-02  +1.66736300E-02  +1.51550600E-02  +2.41409800E-02
   -2.31744100E-02  -1.13022100E-01  +8.06240100E-02  -3.32111300E-02  +6.36095390E-01
   -5.30240000E-04  -4.68960000E-04  -1.46980000E-04  +3.17950000E-04  +4.68070000E-04
   +4.57460000E-04  +1.49670000E-04  +2.04910000E-04  -1.63700000E-05  -3.52890000E-04
   +6.15000000E-06  -2.00390000E-04  -4.34630000E-04  +7.93210000E-04  +3.89710000E-04
   +2.66390000E-04  +2.21780000E-04  -2.94030000E-04  -2.23850000E-04  -4.34760000E-04
   -2.55380000E-04  -6.04310000E-04  -1.17553000E-03  +3.72330000E-04  -3.39570000E-04
   +7.86400000E-05  -5.98500000E-05  -5.88650000E-04  +4.80280000E-04  -9.85200000E-05
   -1.67463800E-02  -3.74238100E-02  +3.63929500E-02  +6.10271400E-02  -2.08119300E-02
   -1.43516700E-02  +4.69865000E-03  -2.51919390E-01  +1.30693080E-01  -1.25093170E-01
   +5.86623950E-01  +2.26400000E-05  +2.35100000E-05  +4.62600000E-05  +6.86300000E-05
   -7.80200000E-05  -3.32590000E-04  -2.62830000E-04  -2.05430000E-04  +1.44630000E-04
   +3.84340000E-04  -1.26610000E-04  +8.57700000E-05  +2.84630000E-04  -5.05400000E-05
   -2.01770000E-04  -3.50680000E-04  -2.92270000E-04  +1.87280000E-04  +1.45590000E-04
   +2.12160000E-04  +1.71100000E-04  +7.35820000E-04  -3.91000000E-05  -1.34479000E-03
   +4.75300000E-05  -6.78800000E-05  +2.43120000E-04  +3.06270000E-04  -3.65980000E-04
   +1.00710000E-04  +1.45852800E-02  +3.73394300E-02  -3.39543000E-02  -5.01639700E-02
   +4.58094000E-03  +2.62591100E-02  +2.14546300E-02  +8.96251600E-02  -1.43047910E-01
   -1.81814310E-01  -2.60631340E-01  +4.11066260E-01  +3.69550000E-04  +3.49040000E-04
   +1.18250000E-04  -2.09100000E-04  -3.95670000E-04  -5.43500000E-04  -3.16810000E-04
   -3.27060000E-04  +1.17240000E-04  +5.65620000E-04  -1.71910000E-04  +2.33370000E-04
   +4.55350000E-04  -1.11970000E-04  -4.83970000E-04  -4.70530000E-04  -4.73910000E-04
   +3.67990000E-04  +2.74130000E-04  +4.40890000E-04  +3.02430000E-04  +3.19186000E-03
   -7.59800000E-05  +1.20954000E-03  +7.17430000E-04  -3.23050000E-04  +3.55770000E-04
   -2.33600000E-05  -1.02560000E-04  +1.78320000E-04  +1.30496900E-02  +7.02871800E-02
   -5.78272000E-02  -6.08451200E-02  +1.92881000E-03  +3.01826300E-02  +5.08166000E-02
   -7.32512100E-02  +2.38494700E-02  -2.18406330E-01  +2.19104000E-03  +8.03159000E-02
   +6.60908250E-01  -9.70240000E-04  -9.43120000E-04  -1.67390000E-04  +7.85180000E-04
   +7.06510000E-04  +3.85980000E-04  -8.84500000E-05  +8.24100000E-05  +2.56420000E-04
   -1.33190000E-04  +2.75380000E-04  -9.41900000E-05  -7.85600000E-04  +6.22980000E-04
   -1.73360000E-04  +3.82300000E-04  +3.09790000E-04  -5.31890000E-04  -1.63920000E-04
   -4.40690000E-04  -2.65160000E-04  +8.81660000E-04  -1.95719000E-03  +5.10947000E-03
   +8.02560000E-04  -2.70660000E-04  -3.20750000E-04  -9.93870000E-04  +6.74680000E-04
   +3.53750000E-04  +2.61146200E-02  -2.53168800E-02  +4.79309000E-03  +3.40178000E-03
   +2.21827000E-03  -3.12202000E-03  -2.39871400E-02  -1.25302000E-02  +1.97099500E-02
   -7.71484100E-02  -1.19546480E-01  +7.99184500E-02  -1.25494890E-01  +5.50342830E-01
   +4.28080000E-04  +4.06650000E-04  +2.73700000E-05  -4.18590000E-04  -2.43700000E-04
   +1.40270000E-04  +3.23030000E-04  +2.21560000E-04  -3.15520000E-04  -3.40550000E-04
   -4.14900000E-05  +1.13000000E-06  +3.82500000E-04  -5.05000000E-05  -1.24540000E-04
   +2.06900000E-04  +2.26010000E-04  +6.67600000E-05  -3.74600000E-05  -3.44800000E-05
   -5.27200000E-05  -5.28800000E-05  +4.33565000E-03  +6.95160000E-04  -4.59790000E-04
   +3.87100000E-04  +1.55940000E-04  +1.20710000E-04  +1.27320000E-04  -7.76300000E-05
   -2.44485700E-02  -1.82724000E-02  +2.87933300E-02  +2.98719000E-02  -2.30214000E-03
   -1.34919000E-02  -1.14636800E-02  +4.58754900E-02  -2.97519800E-02  +1.36014170E-01
   +3.73207100E-02  -1.63957270E-01  -1.81199280E-01  -2.19105510E-01  +3.97217050E-01
   -5.78980000E-04  -5.76690000E-04  -1.44920000E-04  +2.74480000E-04  +5.16100000E-04
   +7.08200000E-04  +4.40810000E-04  +3.82230000E-04  -7.79800000E-05  -1.48657000E-03
   +4.22890000E-04  -5.71830000E-04  -1.71678000E-03  +3.06764000E-03  -9.56420000E-04
   +9.07230000E-04  +7.91020000E-04  -8.53950000E-04  -3.40320000E-04  -8.04990000E-04
   -3.30380000E-04  -5.74508000E-03  +2.46358600E-02  -1.45615600E-02  -5.18210000E-03
   +2.19881000E-03  +1.87494000E-03  -7.87810000E-04  +8.70380000E-04  -1.40006000E-03
   -1.17650600E-01  +1.16613000E-02  +2.10218100E-02  +3.87374600E-02  -1.84272100E-02
   -2.02288000E-03  -2.14418500E-02  +3.51666600E-02  -1.33397900E-02  -4.27551600E-02
   -2.33074900E-02  +4.14292100E-02  -2.85599900E-01  +1.31694370E-01  +2.59296600E-02
   +6.40329410E-01  +2.75330000E-04  +2.88350000E-04  +9.15400000E-05  -2.82530000E-04
   -2.12460000E-04  +1.41740000E-04  +2.02650000E-04  +3.94430000E-04  +3.26500000E-05
   -2.44380000E-04  -3.01060000E-04  -8.30630000E-04  -3.63610000E-04  -9.20190000E-04
   +4.29510000E-04  +6.95300000E-05  +1.08860000E-04  +2.61840000E-04  -1.57680000E-04
   -1.85320000E-04  +1.26710000E-04  +1.02748200E-02  -1.39456600E-02  +5.61930000E-03
   +1.78562000E-03  +1.91060000E-04  -6.28480000E-04  +9.40000000E-04  -4.70470000E-04
   +1.05435000E-03  +6.01297800E-02  -2.43044630E-01  +9.53399400E-02  -5.55986100E-02
   -1.05668100E-02  +4.26489300E-02  +3.57349200E-02  -4.79058700E-02  +1.59235400E-02
   +1.60112100E-02  +5.16589800E-02  -4.18433100E-02  +6.69595000E-02  -1.56176460E-01
   +3.34878100E-02  -1.08455660E-01  +5.31748160E-01  -5.10700000E-05  -5.12000000E-05
   -2.86900000E-05  +4.64000000E-05  +1.33110000E-04  +2.96470000E-04  +2.64980000E-04
   +2.98230000E-04  -3.37100000E-05  -7.71160000E-04  +5.35220000E-04  -2.78650000E-04
   -8.22370000E-04  +1.99540000E-04  +5.23770000E-04  +4.70690000E-04  +2.36510000E-04
   -5.56710000E-04  -1.59220000E-04  -2.81600000E-05  -1.63070000E-04  -3.04503000E-03
   -3.28896000E-03  +6.36727000E-03  +1.77901000E-03  -3.24810000E-04  -4.00620000E-04
   +1.10894000E-03  -8.53890000E-04  -6.26170000E-04  -1.47520900E-02  +1.20347730E-01
   -1.42473440E-01  +2.49928900E-02  +2.31931400E-02  -2.10134200E-02  -1.43249700E-02
   +1.66822300E-02  -3.50785000E-03  +1.33408800E-02  -2.13192400E-02  +1.24395400E-02
   +7.14432100E-02  -1.08380000E-04  -9.71271800E-02  -1.92047670E-01  -2.32823040E-01
   +3.82212610E-01  -9.90310000E-04  -8.69600000E-04  -1.94800000E-04  +7.56000000E-04
   +7.09470000E-04  +3.28130000E-04  -1.99830000E-04  +7.72800000E-05  +2.40290000E-04
   -1.65920000E-04  -7.86300000E-05  -1.36980000E-04  -8.21000000E-05  +9.69120000E-04
   +1.83250000E-04  +4.11200000E-05  -7.02700000E-05  -3.52310000E-04  -2.15880000E-04
   -3.88760000E-04  -2.28160000E-04  +1.75905000E-03  -6.63030000E-04  +6.82400000E-04
   -5.31070000E-04  -1.33680000E-04  +3.33610000E-04  -1.41852000E-03  +5.97380000E-04
   -3.86970000E-04  -3.77970000E-03  +5.89910000E-04  -2.82030000E-04  +4.20102000E-03
   -2.36757000E-03  +1.99827000E-03  -2.42216700E-02  +1.46984400E-02  +6.71873000E-03
   -2.54493820E-01  +8.03606500E-02  +5.95554000E-02  -4.24272800E-02  +3.08984700E-02
   +3.91413000E-03  +1.73357000E-03  -1.77831000E-03  +3.25283000E-03  +3.42963580E-01
   +6.36410000E-04  +5.89850000E-04  +1.26770000E-04  -4.57380000E-04  -4.74820000E-04
   -2.45320000E-04  +9.63300000E-05  -4.42400000E-05  -1.56730000E-04  +1.33610000E-04
   +9.31200000E-05  +1.09800000E-04  +1.14820000E-04  -7.54080000E-04  -1.27740000E-04
   -4.87900000E-05  +2.95200000E-05  +2.31970000E-04  +1.51070000E-04  +3.12860000E-04
   +1.57600000E-04  -9.33140000E-04  +4.77180000E-04  -6.34540000E-04  +3.75420000E-04
   +1.33900000E-05  -1.97970000E-04  +8.51670000E-04  -3.78790000E-04  +2.53870000E-04
   +2.26332000E-03  +6.51410000E-04  -2.16336000E-03  -4.35367000E-03  -4.59460000E-04
   +5.94248000E-03  +4.82177400E-02  -2.59523700E-02  -1.76337000E-03  +1.18833950E-01
   -1.33488820E-01  +5.97152000E-03  -1.11399000E-03  -1.10541000E-03  +5.22660000E-03
   +4.33140000E-04  -1.73752000E-03  +4.98940000E-03  -1.40096740E-01  +5.08464700E-01
   +1.10430000E-04  +9.73800000E-05  +3.23500000E-05  -9.05300000E-05  -7.12700000E-05
   -2.58100000E-05  +3.27600000E-05  -2.60000000E-07  -2.56600000E-05  +4.57200000E-05
   -3.44900000E-05  -4.71200000E-05  +7.41200000E-05  -1.43420000E-04  +1.12270000E-04
   -2.25000000E-06  -3.72900000E-05  +6.90300000E-05  -1.14300000E-05  +2.70500000E-05
   +3.90500000E-05  -1.98780000E-04  -9.12700000E-05  -3.22300000E-05  +7.15400000E-05
   +5.48700000E-05  -5.86800000E-05  +4.71300000E-05  +2.02100000E-05  -8.13000000E-06
   -6.10160000E-04  -1.83170000E-03  +1.69010000E-04  +3.54915000E-03  +4.90299000E-03
   -7.36750000E-04  -1.74116000E-02  +1.64925000E-02  +5.39128000E-03  +3.26041100E-02
   +2.61782200E-02  -7.18044600E-02  +2.62816800E-02  -1.17599600E-02  -1.38440000E-04
   +1.85160000E-03  +6.12779000E-03  +3.28920000E-04  -7.04182400E-02  -2.66890340E-01
   +2.50392690E-01  -3.73989900E-02  +1.71710900E-02  +6.78989100E-02  -1.93753000E-03
   -2.12203200E-02  -3.56053000E-02  +1.26567000E-03  -7.08000000E-06  -2.41238000E-03
   -6.20210000E-04  -1.34160000E-04  -2.30640000E-04  -7.12300000E-05  +2.50210000E-04
   +6.10590000E-04  +1.54051000E-03  -6.95430000E-04  -7.94560000E-04  -4.43725000E-03
   -4.14743000E-03  +7.83420000E-04  -1.66810000E-04  +2.90000000E-06  +1.05710000E-04
   +4.02000000E-05  +1.30000000E-07  -1.61000000E-05  +6.72800000E-05  +3.22900000E-05
   -1.91700000E-05  -3.47400000E-05  -7.00000000E-08  +2.69800000E-05  +4.73400000E-05
   -1.70900000E-05  +1.37400000E-05  -1.13840000E-04  -4.56300000E-05  +8.81900000E-05
   -9.20200000E-05  +6.79200000E-05  -4.07000000E-06  -4.14700000E-05  +6.15300000E-05
   -2.88400000E-05  +3.77100000E-05  +2.30100000E-05  +2.67700000E-05  +1.20890000E-04
   -5.97700000E-05  -8.66000000E-06  +4.28200500E-02  -6.62112000E-03  -1.32656360E-01
   -2.03496980E-01  +8.06690000E-04  -1.95967400E-02  -2.83372200E-02  +3.10944000E-03
   +2.02403000E-03  +1.10304000E-03  +5.40100000E-05  -8.69760000E-04  -3.77150000E-04
   -4.73100000E-05  +3.75860000E-04  +5.70590000E-04  +2.24150000E-04  +7.41840000E-04
   -1.78780000E-03  -4.93308000E-03  -9.70120000E-04  +7.94300000E-04  -1.71220000E-04
   -9.01200000E-05  +1.43700000E-05  +6.67000000E-05  +1.85800000E-05  +2.50800000E-05
   +7.11300000E-05  +1.25300000E-05  -2.53000000E-05  -2.28000000E-05  +1.08240000E-04
   +4.52800000E-05  +5.85300000E-05  -4.60700000E-05  +3.09100000E-05  -9.98300000E-05
   -3.46100000E-05  +6.54400000E-05  -1.19680000E-04  +7.50900000E-05  +8.28000000E-06
   -5.88000000E-05  +2.01730000E-04  -9.98300000E-05  +9.36000000E-05  -4.46000000E-05
   +3.85000000E-06  +1.60550000E-04  -1.16270000E-04  -1.60600000E-05  +8.16144000E-03
   +1.50979230E-01  +2.87105000E-02  -2.31739640E-01  -4.16170350E-01  +6.66450000E-04
   -2.18183000E-03  -7.02343000E-03  +2.61228000E-03  +4.68966000E-03  +3.60110000E-03
   +4.99700000E-05  -2.24900000E-04  -1.02060000E-03  +1.11180000E-04  +1.39530000E-04
   +3.66110000E-04  +6.33370000E-04  -7.35230000E-04  -1.63040000E-04  -4.08500000E-04
   -8.74600000E-05  +2.36555000E-03  -1.55190000E-04  -3.79600000E-05  -1.57000000E-04
   +1.32210000E-04  +7.50400000E-05  +7.30200000E-05  +3.53600000E-05  +4.23000000E-06
   -2.26200000E-05  -1.29200000E-05  +5.41000000E-05  +3.26400000E-05  +3.44400000E-05
   -2.34300000E-05  -8.82000000E-06  -6.14600000E-05  -4.43200000E-05  +6.16300000E-05
   -4.61600000E-05  +5.35300000E-05  -1.38500000E-05  -3.25400000E-05  +3.15100000E-05
   +4.30000000E-07  +3.37400000E-05  -1.71700000E-05  +1.35000000E-05  +7.75200000E-05
   -4.44800000E-05  -1.68100000E-05  -3.20574100E-02  +2.30361090E-01  +4.18542900E-01
   +1.31816000E-03  +3.06844000E-03  -9.32690000E-04  +4.67368000E-03  +1.20608100E-02
   +1.82346500E-02  -5.36263600E-02  -1.46175000E-02  -3.68120000E-04  +3.49072000E-03
   -1.31331500E-02  -2.16032900E-02  -1.42720000E-03  -5.58852000E-03  +1.34627000E-03
   -1.55612000E-03  -3.76050000E-04  +1.32040000E-04  -1.65975000E-03  -2.18636000E-03
   +4.54558000E-03  +5.73690000E-04  -4.42840000E-04  -9.82340000E-04  -5.50000000E-07
   +9.16100000E-05  -8.75900000E-05  -3.40610000E-04  -1.66820000E-04  +8.78200000E-05
   +1.18570000E-04  -5.08800000E-05  -1.22500000E-05  -2.12600000E-05  +3.93800000E-05
   -4.00000000E-08  +1.84400000E-05  +1.34700000E-05  -2.21900000E-05  +4.13600000E-05
   -2.32000000E-05  +3.95000000E-06  +1.46400000E-05  -7.29500000E-05  +3.99900000E-05
   -4.04300000E-05  +4.07100000E-05  +2.08200000E-05  -7.22600000E-05  +6.05400000E-05
   +1.51300000E-05  -6.97730000E-04  -1.05172000E-03  -2.99910000E-04  +4.96906500E-02
   +2.76968000E-03  -1.59060000E-04  +2.68742000E-03  -3.32738000E-03  +2.79021000E-03
   +1.79155000E-03  -1.46755100E-02  -1.29841500E-01  -1.35166750E-01  +1.24849000E-03
   -7.57798000E-03  -1.74893500E-02  -5.70712000E-03  +2.42622000E-03  -1.51619000E-03
   -1.38100000E-04  -5.25230000E-04  +7.22480000E-04  -1.92477000E-03  +3.56898000E-03
   -7.06120000E-04  +1.87960000E-04  +6.13400000E-05  -9.24410000E-04  -5.85500000E-05
   -8.88000000E-06  -2.19900000E-05  -2.89090000E-04  -2.47190000E-04  +8.36500000E-05
   +2.22770000E-04  -1.01330000E-04  -5.08600000E-05  -7.42200000E-05  +5.10100000E-05
   +4.31600000E-05  +8.36500000E-05  +1.94200000E-05  -5.84600000E-05  +5.67700000E-05
   -3.59800000E-05  -4.74000000E-06  +1.08800000E-05  -3.75900000E-05  +6.11000000E-06
   -6.02000000E-06  +3.86600000E-05  +1.58400000E-05  -8.00700000E-05  +4.49800000E-05
   +1.59700000E-05  +3.62870000E-04  +2.53170000E-04  -9.15980000E-04  +1.91834200E-02
   +1.31766110E-01  -1.53974000E-03  +2.29563000E-03  +1.49859000E-03  -5.76165000E-03
   -1.55608800E-02  -1.39637000E-02  -6.57090000E-04  -1.35191750E-01  -2.45208910E-01
   +1.07602000E-03  -1.07263000E-03  -2.68890000E-04  +8.16070000E-04  -2.08729000E-03
   +3.36356000E-03  +3.95270000E-04  +9.58850000E-04  +1.93090000E-04  +5.02074000E-03
   -3.08940000E-04  -7.81990000E-04  +4.02630000E-04  -7.29900000E-05  -1.22390000E-04
   -5.42200000E-05  +1.02400000E-05  -5.71000000E-05  -1.17340000E-04  -1.73500000E-05
   +5.21800000E-05  -1.44600000E-05  -6.60200000E-05  +7.33000000E-06  -9.68000000E-06
   +2.78200000E-05  -5.16100000E-05  +3.49700000E-05  +2.66200000E-05  -2.92800000E-05
   +6.11800000E-05  -4.50300000E-05  +4.33000000E-06  +3.56600000E-05  -1.25560000E-04
   +7.07900000E-05  -6.67700000E-05  +2.76300000E-05  +3.10000000E-07  -9.43900000E-05
   +7.45300000E-05  +9.39000000E-06  +1.94533000E-03  +6.54150000E-04  -5.51020000E-04
   +4.02640000E-04  +1.49169670E-01  +2.57274580E-01  -1.26411000E-03  -2.99980000E-04
   +8.05630000E-04  +2.87700000E-04  -5.49966000E-03  -2.65100000E-04  -1.25805600E-02
   -3.02620000E-04  +1.79256100E-02  -1.97309460E-01  -1.76389300E-02  +1.44067640E-01
   +4.67042000E-03  -3.38800000E-04  -1.07610000E-03  +2.61282000E-03  -2.22206000E-03
   +5.27370000E-04  -2.64180000E-04  +7.86000000E-05  -9.27890000E-04  -1.00203000E-03
   +6.82240000E-04  -9.55940000E-04  -2.61700000E-05  -1.52020000E-04  +1.18110000E-04
   -4.73300000E-05  +1.40980000E-04  -4.65500000E-05  -5.44440000E-04  -4.65640000E-04
   -7.52650000E-04  +5.31100000E-05  -1.16900000E-05  +8.19200000E-05  -3.51510000E-04
   +8.46000000E-05  +1.03510000E-04  -2.19530000E-04  +2.29900000E-05  +1.46730000E-04
   +1.76060000E-04  +1.65030000E-04  -1.47380000E-04  -1.92470000E-04  -1.60560000E-04
   -2.20970000E-04  +1.54490000E-04  -1.00050000E-04  -2.31900000E-05  +9.48700000E-05
   +1.75350000E-04  +1.60190000E-04  -4.80280000E-04  +1.85095000E-03  -1.41808000E-03
   +2.05736210E-01  -9.83210000E-04  -2.78930000E-04  +7.83090000E-04  -5.34538000E-03
   +1.82513000E-03  -3.74475000E-03  -1.52107800E-02  +2.69423000E-03  +1.45910100E-02
   -1.70771200E-02  -5.04390800E-02  +1.88720000E-03  +1.32415200E-02  +6.14720000E-03
   -1.17333200E-02  -2.70572000E-03  +1.37948000E-03  -5.07789000E-03  +9.62100000E-05
   -1.08440000E-03  +3.40100000E-05  +1.53377000E-03  -1.35592000E-03  +1.01820000E-03
   -1.26340000E-04  -5.46540000E-04  -5.03930000E-04  +1.61890000E-04  +6.28000000E-06
   +1.06140000E-04  -3.65430000E-04  +1.83560000E-04  -3.81570000E-04  +1.24150000E-04
   -1.38980000E-04  +1.72000000E-06  -2.20340000E-04  +2.33950000E-04  +2.75800000E-05
   -1.56690000E-04  -1.27960000E-04  +1.56220000E-04  +2.69050000E-04  +1.56500000E-05
   -2.05510000E-04  -2.29360000E-04  -7.49000000E-06  -2.07590000E-04  +1.16580000E-04
   -9.95200000E-05  -8.85000000E-06  +8.60800000E-05  +1.07820000E-04  +1.33620000E-04
   +2.18523000E-03  -1.94494000E-03  +1.67150000E-03  +2.38242000E-02  +4.47102300E-02
   -8.04500000E-05  +8.34000000E-05  +1.96390000E-04  +1.16040000E-04  -3.34252000E-03
   +2.84661000E-03  -4.47753000E-03  -1.57063000E-03  +6.50951000E-03  +1.43290020E-01
   +2.62936000E-03  -1.90580490E-01  +1.98769800E-02  +2.69881000E-03  -1.29843800E-02
   +4.00850000E-04  -5.57353000E-03  -2.55753000E-03  -1.13493000E-03  -1.44930000E-04
   -2.03510000E-04  +3.05090000E-04  +1.86939000E-03  -5.82430000E-04  -7.85000000E-06
   -5.09300000E-05  -1.60250000E-04  -1.98460000E-04  +9.99000000E-06  +1.07600000E-05
   -4.02550000E-04  -4.80120000E-04  +2.14600000E-05  -2.44640000E-04  +1.10750000E-04
   +2.79300000E-04  -2.85920000E-04  -1.68240000E-04  +2.50150000E-04  -2.96650000E-04
   +1.25650000E-04  -2.25400000E-05  -1.06000000E-04  +2.83860000E-04  -1.26830000E-04
   +1.42900000E-04  +4.44970000E-04  +1.12300000E-05  +3.48970000E-04  -2.06700000E-04
   -2.20400000E-05  -1.91100000E-05  +3.74000000E-06  -1.04400000E-05  -1.10494000E-03
   +2.00839000E-03  -3.08240000E-04  -1.57332690E-01  +8.16650000E-04  +1.98033870E-01
   +6.38800000E-05  -6.84630000E-04  -1.13203000E-03  -1.06347000E-03  -5.51210000E-03
   +1.51612000E-03  -1.32144000E-03  -1.59220000E-04  +1.91600000E-05  -1.58959000E-03
   -2.68777000E-03  +5.11440000E-03  +6.38720000E-03  +1.25336100E-02  +1.77976000E-02
   -5.43641000E-02  -1.10629200E-02  -5.83080000E-04  +2.95083000E-03  -1.40011400E-02
   -2.10594900E-02  -2.70730000E-04  +1.86452000E-03  -1.00217000E-03  +3.72770000E-04
   +6.32400000E-05  -9.69400000E-05  -1.61401000E-03  -1.18779000E-03  +6.51990000E-04
   -2.32320000E-04  -1.09700000E-04  -1.02580000E-04  +2.38400000E-05  -2.03300000E-05
   -6.88600000E-05  -5.21900000E-05  -2.33200000E-05  +8.92700000E-05  -4.98800000E-05
   +4.83200000E-05  -4.89000000E-06  -5.26400000E-05  +8.54400000E-05  -5.97800000E-05
   +9.60000000E-07  -1.55380000E-04  +1.09600000E-05  +8.83500000E-05  -5.03500000E-05
   -1.39200000E-05  -3.14610000E-04  -1.76790000E-04  -1.31860000E-04  -1.40540000E-04
   +3.03800000E-04  -1.95640000E-04  +1.80000000E-04  +7.41210000E-04  +1.04696000E-03
   +5.33346400E-02  -9.72200000E-05  -6.17740000E-04  -1.00187000E-03  -5.53795000E-03
   +2.84270000E-03  -1.78624000E-03  -7.96200000E-05  -5.99020000E-04  +8.55890000E-04
   -2.62951000E-03  +4.07175000E-03  -1.22734000E-03  +2.22190000E-04  +5.59658000E-03
   +1.53250000E-03  -1.10345500E-02  -1.31820860E-01  -1.35409870E-01  +2.95920000E-04
   -6.90697000E-03  -1.74531500E-02  +1.30412000E-03  -2.35684000E-03  +9.22050000E-04
   -4.90420000E-04  -3.04360000E-04  +1.80800000E-05  -2.25829000E-03  -5.14370000E-04
   +2.29620000E-04  +2.58110000E-04  +4.89320000E-04  -2.16760000E-04  +8.55800000E-05
   -1.22670000E-04  +6.99000000E-05  +1.16900000E-05  -8.16000000E-06  -2.87400000E-05
   -4.47300000E-05  +4.06500000E-05  +1.13800000E-05  -5.50000000E-07  +2.77500000E-05
   -1.40700000E-05  +1.04270000E-04  +6.37500000E-05  -7.53400000E-05  +6.15600000E-05
   -5.89600000E-05  +5.28000000E-06  -1.21910000E-04  -2.57610000E-04  +2.12300000E-05
   +2.78600000E-04  -4.06950000E-04  +1.94030000E-04  -6.56500000E-05  +1.04210000E-04
   +2.34470000E-04  +1.89961000E-02  +1.34659030E-01  -1.60110000E-04  -3.05820000E-04
   -2.44890000E-04  +1.40953000E-03  -1.87125000E-03  +3.34478000E-03  +1.52910000E-04
   +9.45580000E-04  +2.49960000E-04  +5.15958000E-03  -9.98050000E-04  -7.26020000E-04
   -2.09438000E-03  -1.27032500E-02  -1.35013400E-02  -1.41210000E-04  -1.35405950E-01
   -2.54879100E-01  +1.56364000E-03  -1.29567000E-03  +7.73000000E-05  -2.11253000E-03
   +1.18750000E-04  -1.27706000E-03  +5.04680000E-04  +1.85980000E-04  +4.93600000E-05
   -9.49750000E-04  -1.04123000E-03  +2.96340000E-04  -1.51900000E-04  -1.02000000E-04
   +1.14140000E-04  -3.15000000E-05  +6.32900000E-05  +2.34700000E-05  +2.23000000E-06
   -3.60000000E-06  -4.52000000E-06  +1.58300000E-05  -6.41000000E-06  -1.31300000E-05
   -1.67100000E-05  -1.81700000E-05  +2.25100000E-05  +2.04800000E-05  +3.24100000E-05
   +6.78100000E-05  -3.13100000E-05  +2.73500000E-05  +4.20000000E-06  -4.71400000E-05
   +8.04100000E-05  -2.73000000E-06  -2.29720000E-04  +1.64550000E-04  -2.01360000E-04
   -1.90140000E-04  -6.58670000E-04  -8.34700000E-04  +4.25500000E-05  +1.50604550E-01
   +2.66926840E-01  -2.70860000E-04  +1.85435000E-03  -8.55780000E-04  +3.86359000E-03
   -2.11730000E-03  -1.71292000E-03  +2.32897000E-03  -2.11632000E-03  +4.83140000E-04
   -2.21660000E-04  +7.59700000E-05  -9.02230000E-04  -2.40730000E-04  -5.49005000E-03
   -2.82830000E-04  -1.19936800E-02  +4.19130000E-04  +1.70628600E-02  -1.97583480E-01
   -2.35989900E-02  +1.47810230E-01  -1.28910000E-04  +2.69820000E-04  +8.91440000E-04
   -2.03810000E-04  -9.00700000E-05  -1.00050000E-04  -3.02700000E-05  +8.13100000E-05
   +6.10500000E-05  +4.25100000E-05  -2.29900000E-04  +1.29700000E-05  -7.98700000E-05
   +8.57200000E-05  -8.62000000E-06  +4.76900000E-05  -6.71000000E-06  -3.00000000E-06
   +5.99600000E-05  -1.78200000E-05  -2.07100000E-05  -4.20000000E-07  -9.12500000E-05
   +5.92400000E-05  -5.85500000E-05  +2.13500000E-05  +1.98000000E-05  -7.27600000E-05
   +5.31200000E-05  +1.39000000E-06  -1.37900000E-04  +2.42590000E-04  -1.06750000E-04
   +1.84430000E-04  +3.87400000E-05  -2.09900000E-04  -2.16270000E-04  +2.90470000E-04
   -1.00470000E-04  -5.51340000E-04  +1.88201000E-03  -1.43870000E-03  +2.05282430E-01
   +1.70175000E-03  -9.92420000E-04  +2.25617000E-03  +1.27370300E-02  +6.49946000E-03
   -1.26378300E-02  -2.38764000E-03  +1.04032000E-03  -4.70021000E-03  -6.09000000E-05
   -1.27736000E-03  -2.14660000E-04  -5.16115000E-03  +1.38210000E-03  -3.07496000E-03
   -1.35916900E-02  +2.18614000E-03  +1.51969700E-02  -2.43555600E-02  -4.83753900E-02
   +6.44847000E-03  -5.00570000E-04  +4.44410000E-04  +5.19320000E-04  -8.01800000E-05
   +4.95000000E-05  -4.60000000E-05  +6.04800000E-05  +2.77300000E-05  +8.64800000E-05
   -1.93590000E-04  -2.83580000E-04  -1.88000000E-05  -4.20500000E-05  +3.81800000E-05
   -1.79800000E-05  +1.39600000E-05  +4.74200000E-05  -1.08900000E-05  +2.15900000E-05
   -4.43700000E-05  +1.63900000E-05  +2.66600000E-05  -4.20000000E-07  +4.97000000E-06
   -2.06100000E-05  +1.22500000E-05  -2.75800000E-05  -5.47600000E-05  +3.07100000E-05
   +5.97000000E-06  +2.01740000E-04  -1.57970000E-04  +4.16850000E-04  +7.19890000E-04
   +6.02700000E-05  -6.32730000E-04  +2.58420000E-04  -3.31000000E-04  +2.95020000E-04
   +2.19043000E-03  -1.87710000E-03  +1.61327000E-03  +2.85413700E-02  +4.15542900E-02
   -1.12214000E-03  +2.07114000E-03  +9.53740000E-04  +2.20757300E-02  +4.42348000E-03
   -1.28058700E-02  +2.76100000E-05  -5.08315000E-03  -2.42098000E-03  -1.24631000E-03
   -4.34130000E-04  -3.81770000E-04  -7.14000000E-05  -2.81462000E-03  +2.75096000E-03
   -5.07865000E-03  -7.54120000E-04  +6.98417000E-03  +1.46497780E-01  +5.51866000E-03
   -1.93329570E-01  -1.72120000E-04  -1.44910000E-04  +2.95150000E-04  -1.47000000E-05
   -4.93600000E-05  -2.45200000E-05  +1.98400000E-05  +6.15100000E-05  -2.08400000E-05
   +5.95600000E-05  +1.61700000E-05  +1.20300000E-05  +3.71000000E-06  +3.64000000E-06
   +1.60700000E-05  -1.67300000E-05  -2.25000000E-05  +2.45200000E-05  -1.80000000E-05
   +2.47600000E-05  -7.96000000E-06  -2.06800000E-05  +1.75000000E-05  -7.85000000E-06
   +1.03100000E-05  -2.96000000E-06  +6.68000000E-06  +3.20500000E-05  -1.67000000E-05
   -3.53000000E-06  -1.78980000E-04  +3.65020000E-04  +2.18810000E-04  +9.05590000E-04
   +1.43790000E-04  -8.42950000E-04  -1.10250000E-04  +2.75110000E-04  -1.52560000E-04
   -9.74730000E-04  +1.95107000E-03  -2.27640000E-04  -1.60636880E-01  -5.49554000E-03
   +1.99020510E-01  +1.79700000E-05  -1.72100000E-05  +2.02200000E-05  +4.11400000E-05
   -1.55100000E-05  -1.72300000E-04  -2.23210000E-04  -1.41200000E-05  -2.61000000E-06
   +3.26180000E-04  +2.42850000E-04  +3.06070000E-04  +7.83470000E-04  -1.37439000E-03
   -2.07480000E-04  +2.51260000E-04  +1.23580000E-04  +1.46050000E-04  +1.10260000E-04
   +1.18010000E-04  -4.21200000E-05  -4.43435000E-03  +9.20740000E-04  +1.34978000E-03
   -2.63640910E-01  +1.01087510E-01  +3.87084800E-02  -1.14530000E-04  -2.42340000E-04
   +4.88790000E-04  +6.87390000E-04  +1.44510000E-04  -3.47270000E-04  -1.49940000E-04
   -7.87300000E-05  +2.76090000E-04  +3.75430000E-04  +1.60960000E-04  -3.16290000E-04
   +1.02730000E-04  -7.62900000E-05  -1.94700000E-05  +7.34600000E-05  -1.20950000E-04
   +5.36500000E-05  -2.09090000E-04  +1.99200000E-05  +1.83570000E-04  -2.09460000E-04
   +1.80660000E-04  -1.58400000E-05  -9.57000000E-06  +6.04000000E-06  -1.05000000E-06
   -4.56000000E-06  +1.23000000E-05  +0.00000000E+00  +2.91900000E-05  -7.31300000E-05
   -1.36300000E-05  +1.79600000E-05  +3.19000000E-05  -1.73900000E-05  +2.08100000E-05
   +1.70400000E-05  +6.51000000E-06  +2.83616470E-01  +2.20900000E-04  +2.18820000E-04
   +4.50700000E-05  -2.34440000E-04  -1.63310000E-04  +1.13050000E-04  +1.27570000E-04
   +5.98900000E-05  -7.26400000E-05  -1.59690000E-04  -1.86210000E-04  -5.64550000E-04
   +1.40095000E-03  +6.53610000E-04  -2.35480000E-04  -2.93120000E-04  +1.39080000E-04
   +4.78900000E-05  -1.74080000E-04  -8.11600000E-05  +6.60000000E-05  +2.18265600E-02
   -1.25950200E-02  -3.75893000E-03  +9.88268100E-02  -9.21441200E-02  -1.86975100E-02
   -2.31140000E-04  +3.41730000E-04  -1.32811000E-03  -7.74770000E-04  -3.00020000E-03
   +4.05915000E-03  -5.84170000E-04  -1.30050000E-04  +5.53610000E-04  -7.03100000E-05
   +1.81360000E-04  +1.52700000E-05  -2.68570000E-04  +6.51100000E-05  +1.10020000E-04
   -3.88600000E-05  -2.01710000E-04  +9.27300000E-05  +1.49481000E-03  -2.06970000E-04
   -3.71530000E-04  +2.58450000E-04  -1.36950000E-04  -6.44100000E-05  -8.55000000E-06
   -3.79100000E-05  -1.97000000E-05  +1.18200000E-05  -3.22000000E-06  +1.41000000E-05
   +2.62700000E-05  +7.84700000E-05  +1.48320000E-04  +3.44600000E-05  -2.51100000E-05
   +6.91900000E-05  +7.88000000E-06  -9.32000000E-06  -4.22000000E-06  -1.10097090E-01
   +1.01142860E-01  -1.25300000E-04  -9.84300000E-05  -1.03900000E-05  +1.22850000E-04
   -1.93000000E-06  -1.96440000E-04  -3.72370000E-04  -4.51600000E-05  +9.93300000E-05
   +3.59230000E-04  +5.26700000E-05  -2.29730000E-04  -5.96990000E-04  -3.64130000E-04
   +5.10880000E-04  -1.40460000E-04  -1.68590000E-04  +1.70770000E-04  +1.24250000E-04
   +1.17210000E-04  +8.77000000E-06  -1.97329600E-02  +9.56728000E-03  +1.81686000E-03
   +4.00962800E-02  -1.96859200E-02  -5.41498500E-02  -1.23502000E-03  +5.42100000E-04
   +1.19003000E-03  +5.17820000E-04  +2.93017000E-03  -3.11727000E-03  +6.93180000E-04
   +3.19550000E-04  -1.57550000E-04  -1.89680000E-04  +4.30000000E-05  +1.69070000E-04
   +3.04700000E-05  -1.16640000E-04  +7.37000000E-06  +1.81480000E-04  +2.94190000E-04
   -1.80940000E-04  -1.16743000E-03  +5.45530000E-04  +5.00880000E-04  -6.55500000E-05
   -5.15000000E-06  +3.12000000E-05  +1.32100000E-05  +2.14000000E-06  +1.56000000E-05
   +1.74100000E-05  -1.79400000E-05  +1.00000000E-07  +4.13400000E-05  +6.30000000E-06
   +9.46700000E-05  +2.64700000E-05  +9.29000000E-06  -8.35400000E-05  -2.20000000E-06
   +4.46000000E-06  +9.59000000E-06  -4.27624900E-02  +1.67960000E-02  +5.78612500E-02
   -2.21900000E-04  -1.92790000E-04  -3.14200000E-05  +2.43330000E-04  +1.60440000E-04
   -6.54700000E-05  -1.98960000E-04  -4.13800000E-05  +6.91600000E-05  +2.68070000E-04
   +2.52930000E-04  +4.61470000E-04  +3.98870000E-04  -3.13410000E-04  -2.02580000E-04
   +5.50520000E-04  -1.99100000E-05  -1.66790000E-04  +4.83600000E-05  -3.19500000E-05
   -3.97300000E-05  +2.93032000E-03  +3.88485000E-03  +4.61210000E-04  -1.78969460E-01
   -1.32092640E-01  -1.97728900E-02  +3.85550000E-04  +3.44800000E-04  -6.08500000E-05
   +5.50400000E-05  -9.94300000E-05  +3.11400000E-04  -1.04473000E-03  +7.59680000E-04
   +6.64350000E-04  +2.23200000E-05  +1.83700000E-04  -1.35120000E-04  -1.57360000E-04
   +5.00000000E-08  +4.81500000E-05  +4.85000000E-06  +2.17300000E-05  -2.20000000E-06
   +1.28680000E-04  -8.64700000E-05  -3.02700000E-05  +8.58700000E-05  -2.38800000E-05
   -3.68500000E-05  +1.85400000E-05  +3.52100000E-05  +1.88000000E-05  -2.33900000E-05
   -5.89000000E-06  -1.78200000E-05  -8.82000000E-06  -2.13600000E-05  -1.94000000E-05
   -5.99900000E-05  +6.20600000E-05  +6.34000000E-06  -7.53000000E-06  -3.91000000E-06
   +5.85000000E-06  -1.85434300E-02  -2.07389000E-02  -3.84718000E-03  +1.94208930E-01
   -5.52510000E-04  -4.85770000E-04  -1.62970000E-04  +2.52140000E-04  +4.41690000E-04
   +5.18940000E-04  +1.02440000E-04  +1.71170000E-04  +4.34400000E-05  -3.25390000E-04
   -1.28860000E-04  +2.89700000E-04  +1.02012000E-03  -2.59493000E-03  +3.92048000E-03
   +3.87830000E-04  -4.58140000E-04  -4.70780000E-04  -6.33490000E-04  -2.69050000E-04
   -4.31620000E-04  -1.72544700E-02  -1.63389100E-02  -3.26017000E-03  -1.30501200E-01
   -1.79098240E-01  -1.95005400E-02  -3.37500000E-04  +7.02080000E-04  -1.60074000E-03
   -9.33220000E-04  +3.30490000E-04  +3.90000000E-06  +2.08200000E-05  -3.36620000E-04
   +5.79920000E-04  +4.86130000E-04  +2.49100000E-04  -3.44370000E-04  +2.46400000E-05
   +1.72100000E-05  -8.70800000E-05  -6.40000000E-05  -1.70490000E-04  +1.69180000E-04
   +1.97430000E-04  +1.39050000E-04  +2.91000000E-05  -9.64500000E-05  +1.54460000E-04
   -4.93500000E-05  +3.05600000E-05  +4.57100000E-05  +5.79000000E-05  -2.87800000E-05
   -5.25900000E-05  -3.85800000E-05  -1.59600000E-05  +1.28250000E-04  -6.75200000E-05
   +5.44400000E-05  -7.90300000E-05  +1.53010000E-04  -1.06390000E-04  -1.01400000E-05
   -3.12900000E-05  +9.82968000E-03  +1.06642900E-02  +1.81862000E-03  +1.43818130E-01
   +1.94030750E-01  +3.18670000E-04  +3.19210000E-04  +4.64900000E-05  -3.47710000E-04
   -5.92000000E-05  +2.54400000E-04  +6.40910000E-04  +9.45000000E-06  +3.53600000E-05
   +1.21000000E-05  -3.52490000E-04  -8.80100000E-05  -1.46545000E-03  +2.47535000E-03
   -2.47115000E-03  +5.69850000E-04  +5.11400000E-04  +1.42970000E-04  +5.58300000E-05
   -3.15680000E-04  +1.30030000E-04  +1.59690200E-02  +1.50774800E-02  +7.47150000E-04
   -1.97624400E-02  -2.06492000E-02  -5.13273700E-02  +1.06378000E-03  +8.22660000E-04
   +1.03382000E-03  +1.50220000E-04  -5.23660000E-04  +4.11770000E-04  -2.45500000E-04
   -5.88780000E-04  +4.39160000E-04  -7.80200000E-05  +1.48120000E-04  -1.14350000E-04
   -9.95100000E-05  -4.69000000E-05  +1.13090000E-04  +8.34300000E-05  -3.65100000E-05
   -4.37600000E-05  +3.31600000E-05  -1.50000000E-07  -2.01110000E-04  +1.70500000E-05
   +2.67800000E-05  -3.29100000E-05  +1.18000000E-06  -1.39700000E-05  -4.22900000E-05
   +3.12300000E-05  +1.81100000E-05  +1.77400000E-05  -2.91640000E-04  +3.85380000E-04
   +2.95800000E-05  -3.41700000E-05  +1.20660000E-04  -9.92100000E-05  +4.06400000E-05
   +3.76700000E-05  -1.17500000E-05  +3.87375000E-03  +4.33925000E-03  -3.01620000E-04
   +2.13240600E-02  +1.93035100E-02  +5.32676000E-02  +4.36500000E-05  +4.79000000E-05
   +4.34000000E-06  -8.85000000E-06  -9.96200000E-05  -1.06450000E-04  -2.53360000E-04
   -4.21000000E-05  -2.55400000E-05  -1.64400000E-05  -1.29490000E-04  -5.50800000E-05
   -7.73900000E-05  +3.78240000E-04  +6.01980000E-04  -1.54360000E-04  -1.11620000E-04
   +7.95000000E-05  +1.23620000E-04  +7.59600000E-05  +6.37500000E-05  -1.65404000E-03
   -1.94994000E-03  -4.37475000E-03  -4.71031700E-02  +1.73672000E-03  +6.08642000E-03
   -1.41180000E-04  +9.44950000E-04  -6.56690000E-04  +4.43050000E-04  -3.57750000E-04
   -6.50160000E-04  -1.92920000E-04  +4.71540000E-04  -3.37630000E-04  -2.05500000E-04
   -7.00000000E-08  +2.27180000E-04  -8.33700000E-05  -3.13100000E-05  +4.68500000E-05
   +7.17100000E-05  +9.16200000E-05  -1.20420000E-04  -1.46600000E-05  -3.33800000E-05
   +2.58500000E-05  +1.14280000E-04  -1.19980000E-04  +2.09800000E-05  -6.94000000E-06
   -2.28900000E-05  +4.51000000E-06  +2.24500000E-05  -1.52800000E-05  +1.37900000E-05
   +2.45050000E-04  -1.60730000E-04  +5.75900000E-05  +9.14000000E-06  +2.28800000E-05
   -5.88400000E-05  -1.63000000E-06  +1.04100000E-05  -7.53000000E-06  +3.08120000E-04
   +9.78687000E-03  +2.77167000E-02  +7.75220000E-04  -7.10419000E-03  -2.18932200E-02
   +4.79679700E-02  +1.52460000E-04  +1.04120000E-04  +3.23000000E-05  +4.86200000E-05
   -1.08710000E-04  -3.06850000E-04  -1.45250000E-04  -1.98920000E-04  -1.90010000E-04
   -3.64510000E-04  -1.89390000E-04  +6.43300000E-04  +6.60950000E-04  +1.24120000E-03
   +7.09900000E-05  -3.93220000E-04  -6.34000000E-05  +1.94300000E-05  +2.27960000E-04
   +2.14850000E-04  +1.88310000E-04  -1.18508000E-03  +8.39007000E-03  +2.27125900E-02
   +1.39324000E-03  -8.15627600E-02  -9.04426800E-02  +5.08210000E-04  -3.51175000E-03
   +2.83196000E-03  -3.12880000E-04  +1.17573000E-03  -3.59270000E-04  +5.51830000E-04
   +2.97850000E-04  -1.16460000E-04  +9.21900000E-05  -1.97090000E-04  +2.66000000E-06
   +1.31030000E-04  +8.26200000E-05  -1.43930000E-04  -1.71590000E-04  +3.63800000E-05
   +6.46600000E-05  -2.11250000E-04  -1.77530000E-04  -2.36700000E-05  -5.90900000E-05
   +6.00000000E-06  +2.71800000E-05  -2.27000000E-05  -1.50300000E-05  -1.52400000E-05
   -5.03000000E-06  -4.41000000E-06  +2.47100000E-05  +3.55300000E-05  -1.11697000E-03
   -4.05700000E-05  +5.53200000E-05  -1.01600000E-05  -1.99200000E-05  +1.47800000E-05
   -8.28000000E-06  +5.76000000E-06  -9.29220000E-04  -5.15352000E-03  -1.17473300E-02
   +2.34541000E-03  -7.57594000E-03  -2.05017800E-02  -2.85466000E-03  +8.77957900E-02
   -2.18600000E-05  +6.53000000E-06  -1.07900000E-05  -2.37850000E-04  +2.07840000E-04
   +4.74240000E-04  +5.49160000E-04  +2.82680000E-04  +2.11640000E-04  +1.31360000E-04
   -7.02410000E-04  -1.37550000E-04  -1.20954000E-03  -8.58130000E-04  +5.82770000E-04
   +7.46010000E-04  +2.07850000E-04  -2.62930000E-04  -3.86750000E-04  -3.70780000E-04
   -1.44700000E-04  +6.46970000E-04  -8.47911000E-03  -1.92072700E-02  +5.87063000E-03
   -8.81140600E-02  -2.82400770E-01  -4.57590000E-04  +4.81358000E-03  -2.38317000E-03
   +1.15069000E-03  -7.55950000E-04  +4.14380000E-04  +3.56990000E-04  +1.83430000E-04
   +2.85110000E-04  -3.48650000E-04  +1.06760000E-04  +2.53600000E-04  -5.90900000E-05
   -1.74140000E-04  +9.58200000E-05  +2.04370000E-04  +5.83900000E-05  -1.20820000E-04
   -8.13800000E-05  +3.23620000E-04  +1.67010000E-04  -1.88800000E-05  -3.03700000E-05
   +2.28000000E-05  +1.93500000E-05  +1.30100000E-05  -4.56000000E-06  +3.93100000E-05
   +5.07000000E-06  +1.44000000E-06  -2.50630000E-04  +2.72110000E-04  +3.08870000E-04
   -1.27640000E-04  -1.49400000E-05  +9.32300000E-05  -4.63000000E-06  +1.88300000E-05
   -1.59800000E-05  -3.70280000E-04  -1.20817000E-03  -3.57979000E-03  +4.28400000E-04
   -2.16390000E-04  -1.58000000E-03  -6.03860000E-03  +9.54931900E-02  +3.07628040E-01
   +9.35800000E-05  +1.06870000E-04  +5.62600000E-05  -8.12900000E-05  -2.50200000E-05
   +3.39900000E-05  +1.14350000E-04  +1.04110000E-04  +3.79300000E-05  -9.23100000E-05
   -8.31300000E-05  -5.42600000E-05  +2.80730000E-04  +5.40700000E-04  -2.62610000E-04
   -1.10910000E-04  -3.60100000E-04  -7.27860000E-04  -1.00200000E-04  -2.82200000E-05
   +2.41250000E-04  -1.97782000E-03  +1.11646000E-03  -9.49670000E-04  +7.85000000E-06
   -3.96280000E-04  -5.25010000E-04  -4.84845100E-02  +1.32052000E-02  -1.31697900E-02
   +5.56300000E-05  -8.84470000E-04  +5.74130000E-04  -8.94100000E-05  +9.94200000E-05
   +7.42000000E-05  +5.47100000E-05  -1.13130000E-04  +1.42020000E-04  -1.25500000E-05
   +1.36740000E-04  -7.91400000E-05  -2.97830000E-04  +7.41700000E-05  +2.64000000E-05
   -1.24940000E-04  +2.14640000E-04  -1.03090000E-04  +6.95500000E-05  -4.05200000E-05
   -1.81800000E-05  -8.60000000E-06  -8.72000000E-06  -6.66000000E-06  +1.07400000E-05
   +1.01400000E-05  +1.49600000E-05  -2.03500000E-05  +3.87500000E-05  +6.32000000E-05
   -1.41445000E-03  +1.33900000E-04  -2.86190000E-04  -1.25700000E-05  +3.90000000E-06
   -2.21800000E-05  +3.41610000E-04  -2.84470000E-04  +2.57800000E-04  +1.06900000E-04
   +3.33880000E-04  -9.85200000E-05  +6.20030000E-04  +1.93530000E-04  -1.60180000E-04
   +4.93503100E-02  +7.91100000E-05  +4.26900000E-05  -2.39700000E-05  -9.63900000E-05
   -7.52900000E-05  +1.20820000E-04  +7.93800000E-05  +3.75300000E-05  -3.23300000E-05
   +2.45480000E-04  +6.00900000E-05  +1.19300000E-05  -2.13970000E-04  +6.01090000E-04
   +3.29700000E-04  -8.30540000E-04  +2.12740000E-04  +1.70400000E-04  +4.64300000E-05
   -7.45700000E-05  -2.15600000E-04  -6.62390000E-04  +9.43887000E-03  -1.03477200E-02
   -1.14740000E-04  -5.46610000E-04  -2.04413000E-03  +1.34781700E-02  -1.78379360E-01
   +1.34677820E-01  -2.19570000E-04  +6.34480000E-04  +1.72000000E-05  +3.40600000E-05
   +2.64500000E-05  +8.58800000E-05  -3.03000000E-06  +2.40400000E-05  -6.48100000E-05
   +4.06100000E-05  +2.03000000E-06  +2.89500000E-05  -9.82600000E-05  -1.28970000E-04
   +8.39100000E-05  +3.00190000E-04  -1.54770000E-04  -7.23670000E-04  -1.37520000E-04
   +7.57300000E-05  +6.15000000E-06  -8.66000000E-06  -1.42200000E-05  -5.91000000E-06
   +1.85900000E-05  +1.49900000E-05  +3.51000000E-06  +3.08000000E-06  +8.87000000E-06
   -3.31100000E-05  -2.90980000E-04  -2.32430000E-04  -3.24320000E-04  -9.91000000E-06
   +4.19700000E-05  -1.18300000E-05  -2.02850000E-04  -4.44000000E-06  -1.64830000E-04
   +2.33340000E-04  +1.58030000E-04  -2.44280000E-04  -7.85900000E-05  +7.26490000E-04
   -4.94420000E-04  -1.38462500E-02  +1.92425470E-01  +1.80200000E-05  +1.34600000E-05
   +1.10900000E-05  -1.38000000E-04  +1.16460000E-04  +2.48050000E-04  +2.52420000E-04
   +2.09960000E-04  +2.86000000E-06  +2.34300000E-05  -5.21920000E-04  -1.64850000E-04
   +9.55570000E-04  +1.01064000E-03  +1.26633000E-03  +2.04890000E-04  -1.97150000E-04
   +2.78800000E-05  -2.70280000E-04  -2.59060000E-04  +1.29940000E-04  -1.70046000E-03
   +2.11783900E-02  -1.99492700E-02  +2.17310000E-04  -4.07897000E-03  -5.44197000E-03
   -1.26347600E-02  +1.32386400E-01  -1.83416140E-01  -1.46661000E-03  +1.05327000E-03
   +5.31740000E-04  +6.15190000E-04  -2.52000000E-05  -1.23390000E-04  -2.69190000E-04
   +5.97320000E-04  -2.84060000E-04  -1.87140000E-04  -4.95320000E-04  +4.14970000E-04
   +8.74600000E-04  -3.90680000E-04  +8.18500000E-05  -2.37700000E-05  +5.73480000E-04
   +2.95470000E-04  -1.05850000E-04  +4.09000000E-06  +8.15000000E-06  -1.00500000E-05
   +6.38000000E-06  -8.86000000E-06  -2.39600000E-05  +3.21900000E-05  -2.43100000E-05
   -3.64400000E-05  +9.64700000E-05  +4.86800000E-05  -5.39760000E-04  +1.49970000E-04
   +1.70940000E-04  -2.23600000E-05  -1.80700000E-05  -1.46300000E-05  -7.78400000E-05
   -1.00210000E-04  +2.05850000E-04  +1.13850000E-04  -1.83120000E-04  +3.08050000E-04
   -3.96420000E-04  +1.44113000E-03  -1.46232000E-03  +1.46771600E-02  -1.44771820E-01
   +2.01047970E-01  -1.50480000E-04  -1.54730000E-04  -7.17200000E-05  +8.71400000E-05
   +9.26400000E-05  +1.99000000E-06  -7.25800000E-05  -5.11700000E-05  -1.03480000E-04
   +8.47900000E-05  +4.52900000E-05  +2.73080000E-04  +6.59160000E-04  +1.43250000E-04
   +1.23840000E-04  -1.50700000E-04  -1.12400000E-05  +4.50030000E-04  +1.64120000E-04
   -9.31900000E-05  -2.52220000E-04  -1.64572000E-03  +4.62400000E-05  +8.75460000E-04
   -2.05580000E-04  -7.44000000E-06  +3.48690000E-04  -2.25322730E-01  -1.28515810E-01
   -1.10124300E-02  +7.40670000E-04  +1.30040000E-03  +3.49110000E-04  +2.23330000E-04
   -1.13920000E-04  +1.02940000E-04  +3.24200000E-05  -1.26620000E-04  -1.22400000E-05
   +1.23400000E-05  +1.19830000E-04  -1.31700000E-04  -2.83330000E-04  +1.35800000E-05
   +7.35000000E-06  +3.51210000E-04  -2.51220000E-04  +5.40300000E-05  +5.59100000E-05
   -1.80300000E-05  +1.28100000E-05  +1.37200000E-05  +1.87600000E-05  +1.17400000E-05
   -3.32600000E-05  -8.90000000E-07  -2.47500000E-05  +7.70400000E-05  -3.81800000E-05
   -6.07700000E-05  +1.41510000E-04  +2.55700000E-05  -5.08520000E-04  -2.79000000E-06
   -1.06700000E-05  +1.85900000E-05  +3.45700000E-05  -1.25830000E-04  +2.96000000E-05
   +2.55420000E-04  +3.79460000E-04  -4.96010000E-04  +2.59450000E-04  +2.66450000E-04
   +2.27500000E-05  +2.56967000E-03  +2.72610000E-03  +3.11000000E-04  +2.41381980E-01
   -2.31370000E-04  -1.91240000E-04  -2.53900000E-05  +2.60970000E-04  +1.10790000E-04
   -7.91000000E-05  -6.32400000E-05  -2.71900000E-04  -1.43580000E-04  -8.90750000E-04
   -9.23300000E-05  +1.89920000E-04  +7.51600000E-04  -2.39380000E-04  -2.89515000E-03
   +2.38910000E-04  +2.61740000E-04  -3.07540000E-04  -4.30500000E-05  +1.24410000E-04
   +4.66000000E-06  -1.10061300E-02  -1.00982200E-02  -8.91660000E-04  +6.38880000E-04
   +3.16680000E-04  +9.77390000E-04  -1.27124660E-01  -1.38543100E-01  -6.63756000E-03
   -1.04492000E-03  +3.23660000E-04  +1.95690000E-04  +3.33130000E-04  +2.28170000E-04
   +2.69500000E-05  +2.45180000E-04  -5.90300000E-05  -1.39520000E-04  +1.84270000E-04
   -4.25800000E-05  -1.05260000E-04  -4.42700000E-05  -1.39050000E-04  +7.14900000E-05
   +1.50470000E-04  -2.68300000E-04  +5.10250000E-04  -1.53420000E-04  +1.29870000E-04
   +2.29900000E-05  +2.89700000E-05  +2.88800000E-05  +2.12800000E-05  -4.98300000E-05
   -1.07310000E-04  -1.63000000E-06  +7.99000000E-06  +3.81500000E-05  -7.46900000E-05
   +2.33660000E-04  -2.14990000E-04  +1.57070000E-04  -3.95300000E-05  -8.10000000E-07
   -5.43000000E-06  +9.97600000E-05  +4.86900000E-05  +1.97500000E-05  +2.40700000E-05
   +5.32850000E-04  +9.98200000E-05  +2.08500000E-04  -1.05000000E-06  -3.77000000E-06
   -1.80616700E-02  -1.25588300E-02  -1.96117000E-03  +1.39913110E-01  +1.48508370E-01
   -1.64400000E-04  -1.02550000E-04  +2.05200000E-05  +1.40110000E-04  +1.64960000E-04
   +1.64800000E-05  +1.28630000E-04  -2.18930000E-04  -3.37550000E-04  -1.59138000E-03
   -1.11884000E-03  +2.25930000E-04  +1.27058000E-03  -1.45864000E-03  -5.44743000E-03
   +9.97810000E-04  -3.69800000E-05  -6.76520000E-04  -2.17910000E-04  -5.91500000E-05
   +2.49620000E-04  -2.43205700E-02  -1.81320000E-02  -3.45551000E-03  -9.29830000E-04
   -1.16768000E-03  +1.30487000E-03  -9.01056000E-03  -5.32102000E-03  -4.64482300E-02
   -1.19987000E-03  -2.53400000E-05  +7.68370000E-04  -6.01900000E-05  +2.28940000E-04
   +2.35590000E-04  +3.88450000E-04  -1.54010000E-04  -7.65800000E-05  +1.92440000E-04
   +8.97500000E-05  -2.28570000E-04  -3.46100000E-04  -2.10510000E-04  +2.21140000E-04
   +3.33520000E-04  +6.49600000E-05  -8.19100000E-05  -2.08790000E-04  +1.41270000E-04
   +1.99800000E-05  +2.37000000E-05  +2.60200000E-05  +1.24100000E-05  -1.30510000E-04
   -9.74300000E-05  -4.04100000E-05  -6.17000000E-06  +4.08900000E-05  -2.93000000E-06
   -1.01360000E-04  +4.01640000E-04  +4.15340000E-04  -2.68000000E-05  -3.88300000E-05
   +1.86000000E-06  +8.01300000E-05  +4.78400000E-05  -7.28700000E-05  +2.24540000E-04
   +6.28540000E-04  -5.82410000E-04  +3.34550000E-04  +1.09100000E-04  +2.72140000E-04
   +1.96336600E-02  +1.25124600E-02  +1.46324000E-03  +1.08633100E-02  +1.00626700E-02
   +5.30260700E-02  +7.87000000E-05  +4.14600000E-05  -2.31100000E-05  -1.57990000E-04
   -2.58500000E-05  +5.47000000E-06  +2.97800000E-05  +3.46000000E-06  -3.00000000E-06
   +1.25950000E-04  +1.48530000E-04  +3.11800000E-05  -7.11000000E-05  -1.63250000E-04
   +1.89310000E-04  -6.35900000E-04  -1.01446000E-03  +4.04700000E-04  +1.46760000E-04
   -8.25400000E-05  -2.42110000E-04  +1.02433000E-03  -1.42788000E-03  -7.59390000E-04
   +4.09080000E-04  -2.71070000E-04  -4.54650000E-04  -2.20743280E-01  +1.21486030E-01
   +3.52387200E-02  +4.32990000E-04  +4.85350000E-04  +4.85660000E-04  +4.70230000E-04
   +3.02090000E-04  -5.98300000E-05  +1.86180000E-04  +8.88400000E-05  -1.93880000E-04
   +2.83510000E-04  -1.42760000E-04  -6.91600000E-05  -9.90000000E-05  -2.08920000E-04
   +1.43100000E-04  +2.44690000E-04  -2.95500000E-04  +3.96720000E-04  -3.24140000E-04
   +2.01550000E-04  +3.53500000E-05  -1.80300000E-05  -8.51000000E-06  -9.00000000E-06
   +1.12100000E-05  +2.12300000E-05  +1.04000000E-06  -1.04400000E-05  -4.59000000E-06
   -2.01500000E-05  -5.98660000E-04  -1.46817000E-03  -3.97380000E-04  +3.29100000E-05
   -8.70000000E-06  +2.29000000E-05  +3.14910000E-04  -1.79780000E-04  +2.39540000E-04
   -2.08720000E-04  +8.89600000E-05  +1.11910000E-04  +1.98770000E-04  -2.34730000E-04
   +2.99000000E-06  -1.16343000E-03  -6.40730000E-04  +9.60600000E-05  -1.94200800E-02
   +1.56141100E-02  +3.75066000E-03  +2.39705020E-01  +8.61800000E-05  +1.28260000E-04
   +8.77100000E-05  -3.12800000E-05  -4.04400000E-05  +4.39600000E-05  +1.31130000E-04
   +1.42970000E-04  +7.62300000E-05  -2.68700000E-04  -1.00200000E-04  -1.18340000E-04
   +5.62090000E-04  +4.06870000E-04  +2.81170000E-04  +2.05540000E-04  -4.11560000E-04
   -9.95110000E-04  -2.89180000E-04  +1.28090000E-04  +4.25840000E-04  +1.11677500E-02
   -8.03069000E-03  -1.06598000E-03  -1.62960000E-04  +4.02300000E-04  +1.29989000E-03
   +1.20337990E-01  -1.31911200E-01  -2.45327100E-02  -2.43990000E-04  -3.35310000E-04
   -2.73695000E-03  -2.52210000E-04  -2.99320000E-04  +1.70480000E-04  +3.31490000E-04
   -5.08050000E-04  +3.38870000E-04  -1.01700000E-04  +5.18540000E-04  -3.74510000E-04
   -6.20200000E-04  +3.15440000E-04  +1.39000000E-06  +5.13440000E-04  -2.45840000E-04
   -4.01650000E-04  +4.03390000E-04  -2.33640000E-04  +4.74000000E-06  -2.57000000E-06
   -1.23300000E-05  -3.68000000E-06  +8.69000000E-06  -2.25000000E-06  +1.94800000E-05
   +1.70100000E-05  +3.96200000E-05  +1.27300000E-04  -1.18413000E-03  -1.32874000E-03
   +5.61590000E-04  -1.20500000E-05  -3.05400000E-05  -1.96200000E-05  -1.91570000E-04
   +5.65520000E-04  -7.43400000E-05  -1.57620000E-04  -2.10100000E-05  -1.08870000E-04
   -2.42820000E-04  -6.10200000E-05  +4.59000000E-05  +1.75349200E-02  -1.18161800E-02
   -4.89446000E-03  -1.55947400E-02  +1.19901200E-02  +3.47998000E-03  -1.32273560E-01
   +1.40506370E-01  +6.18100000E-05  +5.43200000E-05  -5.28000000E-06  -1.23570000E-04
   -1.54600000E-05  +1.85080000E-04  +1.56820000E-04  +1.21490000E-04  -8.30000000E-07
   -1.05790000E-04  +3.23500000E-05  -2.62990000E-04  +3.00060000E-04  +5.95490000E-04
   +7.57010000E-04  -2.67690000E-04  +1.93690000E-04  +3.07150000E-04  -1.68830000E-04
   -1.02770000E-04  -6.66500000E-05  +2.47060100E-02  -1.59203000E-02  -5.81548000E-03
   +1.21666000E-03  -8.80010000E-04  +1.29074000E-03  +3.46637900E-02  -2.34193600E-02
   -5.50000100E-02  -1.39807000E-03  -1.55070000E-03  -4.97921000E-03  +5.45220000E-04
   -5.74470000E-04  +4.99600000E-05  +1.37870000E-04  +2.21550000E-04  +3.42100000E-04
   -4.32900000E-04  +2.78800000E-05  +1.30170000E-04  +5.93540000E-04  +1.93930000E-04
   -5.44700000E-05  +8.26000000E-05  +2.22190000E-04  +2.25700000E-04  +5.77170000E-04
   -3.78960000E-04  -5.57000000E-05  -4.80000000E-06  -1.71700000E-05  -5.48000000E-06
   +2.30500000E-05  -1.40500000E-05  +1.10600000E-05  +4.82800000E-05  -2.59000000E-06
   +5.81600000E-05  -1.17220000E-04  -9.87500000E-05  +3.24280000E-04  +4.17000000E-06
   -1.00800000E-05  +2.98000000E-06  -6.36130000E-04  +3.16050000E-04  -6.79140000E-04
   +4.25700000E-05  +1.38620000E-04  -5.78500000E-05  -2.48590000E-04  +6.39200000E-05
   +4.25300000E-04  -1.94311700E-02  +1.18545200E-02  +4.50669000E-03  -1.15330000E-03
   +1.10636000E-03  -6.75290000E-04  -3.89235500E-02  +2.83759100E-02  +5.93920300E-02
   +8.94200000E-05  +7.90200000E-05  +1.08200000E-05  -5.65700000E-05  -6.72800000E-05
   -1.61500000E-05  +7.65000000E-06  +1.73300000E-05  -5.98600000E-05  -3.98000000E-05
   +7.63300000E-05  +1.04030000E-04  -1.91210000E-04  +7.71300000E-05  -1.89520000E-04
   -1.33200000E-05  +3.54800000E-05  -2.07600000E-05  +4.12400000E-05  +2.43300000E-05
   +2.80300000E-05  +2.51260000E-04  -9.70020000E-04  -1.59972000E-03  -1.13921000E-03
   +1.41270000E-04  +8.50580000E-04  +3.01060000E-04  +9.31900000E-05  -9.20000000E-05
   +8.55261000E-03  -1.86083900E-02  +9.84730000E-03  -5.81150900E-02  +3.42057500E-02
   -1.10540000E-02  +6.95910000E-04  +2.44713900E-02  -1.55117100E-02  -3.02401000E-03
   +2.11410000E-03  +2.94205000E-03  -1.76678000E-03  -1.24750000E-04  +3.09360000E-04
   -1.98360000E-03  -4.27090000E-04  +4.67275000E-03  -2.11150000E-04  +1.47437000E-03
   -8.54370000E-04  -9.23000000E-06  -1.85200000E-05  -3.19000000E-06  +8.03000000E-06
   +1.12000000E-06  +1.23900000E-05  +5.36600000E-05  -7.38000000E-05  -1.55000000E-06
   -5.62000000E-06  -1.39800000E-05  +5.70000000E-07  +1.28900000E-05  -2.91000000E-06
   +3.00000000E-07  +2.57830000E-04  -7.44000000E-05  -7.90900000E-05  -1.14167000E-03
   +1.13039000E-03  +4.40500000E-04  -1.39229000E-03  +2.22770000E-04  -3.85980000E-04
   +1.38200000E-05  +1.02900000E-05  -1.51050000E-04  +3.39700000E-05  -4.34300000E-05
   +1.90000000E-06  -4.90900000E-05  -3.92400000E-05  -3.35800000E-05  +5.69210300E-02
   -2.45500000E-05  -3.23000000E-05  -2.21400000E-05  +1.66300000E-05  +3.45600000E-05
   +3.14400000E-05  +1.19400000E-05  -3.65000000E-06  -6.49600000E-05  -1.10780000E-04
   +3.60000000E-05  +1.54750000E-04  -2.58490000E-04  +2.85090000E-04  +2.76200000E-04
   -6.91900000E-05  -7.51500000E-05  -9.69900000E-05  -8.82000000E-06  -2.54400000E-05
   -2.49000000E-06  -2.03300000E-04  -2.15870000E-03  -1.49133000E-03  +1.80360000E-03
   +8.40000000E-06  -3.46380000E-04  +3.85900000E-04  -1.33780000E-04  -1.00900000E-04
   +7.98570000E-04  -4.71324000E-03  +4.44697000E-03  +3.51629600E-02  -2.50943220E-01
   +1.39197020E-01  +1.29470000E-04  -1.06761600E-02  +1.07737500E-02  +3.00413000E-03
   +1.58175000E-03  +1.07830000E-03  +1.24670000E-04  -7.55400000E-05  -1.03006000E-03
   -4.37470000E-04  +2.67607000E-03  +2.88452000E-03  +2.96940000E-04  -6.39820000E-04
   +4.53120000E-04  -4.05000000E-06  -1.63000000E-06  +7.90000000E-06  -7.15000000E-06
   -1.49200000E-05  +2.86000000E-06  -1.11200000E-05  -8.75300000E-05  +2.76000000E-06
   +1.08500000E-05  -1.90000000E-07  -7.77000000E-06  -6.46000000E-06  -1.20100000E-05
   -1.03000000E-06  +1.95540000E-04  +6.46700000E-05  -5.45460000E-04  +1.72540000E-03
   -4.65770000E-04  -3.38040000E-04  -2.00080000E-04  -1.71520000E-04  -3.59910000E-04
   -6.87000000E-06  -4.99000000E-06  -3.55500000E-05  -2.24800000E-05  -1.85300000E-05
   +1.46800000E-05  -5.99100000E-05  -8.24000000E-06  -9.96200000E-05  -4.07252800E-02
   +2.65623090E-01  -4.23600000E-05  -5.13900000E-05  -1.88000000E-05  +2.31100000E-05
   +4.07300000E-05  +5.85000000E-06  -1.39200000E-05  -2.61100000E-05  -2.21000000E-05
   -4.14800000E-05  -9.32000000E-06  +1.40490000E-04  -2.81350000E-04  +1.65030000E-04
   +2.50030000E-04  -6.90800000E-05  -1.01570000E-04  -5.84000000E-05  -1.32000000E-06
   -2.65700000E-05  -2.63000000E-06  -2.36577000E-03  -9.46510000E-04  -2.31481000E-03
   -2.62000000E-04  +8.11090000E-04  +6.51330000E-04  +7.84780000E-04  -1.60470000E-04
   -7.28500000E-05  -4.27506000E-03  +1.47217000E-02  -6.33840000E-03  -1.15267700E-02
   +1.40019530E-01  -1.27014110E-01  +1.90559000E-03  -2.04432000E-03  +4.91044000E-03
   +2.24047000E-03  +1.46057000E-03  +3.01119000E-03  +1.25570000E-04  -8.59440000E-04
   -8.34540000E-04  +4.69818000E-03  +2.72536000E-03  +1.88591000E-03  +2.15000000E-06
   -1.67050000E-04  +3.20690000E-04  -5.55000000E-06  +5.81000000E-06  +5.50000000E-06
   -1.01100000E-05  -1.03400000E-05  -3.42000000E-06  -7.77000000E-06  -7.57000000E-06
   -1.84500000E-05  +5.49000000E-06  +1.23500000E-05  -1.78500000E-05  -1.01600000E-05
   -5.69000000E-06  -2.08000000E-06  -4.33520000E-04  -3.98510000E-04  +9.45000000E-06
   +2.82520000E-04  -9.75270000E-04  -1.59900000E-05  -4.26680000E-04  +5.80600000E-05
   +3.19000000E-05  -7.02800000E-05  -3.96700000E-05  +7.21100000E-05  -7.57000000E-06
   -6.49700000E-05  -1.26560000E-04  -1.25400000E-05  -1.10950000E-04  -2.15120000E-04
   +1.17228200E-02  -1.52876760E-01  +1.27734430E-01  +2.36080000E-04  +2.00410000E-04
   +2.93100000E-05  -3.33780000E-04  -1.51290000E-04  +1.67950000E-04  +3.36250000E-04
   +1.38160000E-04  -6.73300000E-05  -4.07640000E-04  +8.71300000E-05  -3.63030000E-04
   -8.75710000E-04  +9.22850000E-04  -4.84840000E-04  -1.05820000E-04  +8.32700000E-05
   -2.64000000E-06  -1.50800000E-04  -1.71810000E-04  +5.60000000E-07  -8.07580000E-04
   -1.20080000E-04  -9.13220000E-04  -1.60800000E-05  -1.22020000E-04  -1.01230000E-04
   -7.51700000E-05  +1.19120000E-04  +1.47110000E-04  +6.86491000E-03  +5.25570000E-04
   -3.20178000E-03  +1.79714000E-03  +2.18645000E-03  +2.78260000E-04  -7.00410000E-04
   +6.48850000E-04  -9.38000000E-04  -1.57919000E-03  +4.28003000E-03  +4.80640000E-04
   -1.50571100E-02  -1.27538000E-02  +1.83470800E-02  -1.93760380E-01  -6.39164600E-02
   +1.27605690E-01  -1.39390000E-03  -1.04940000E-04  +9.52500000E-04  -2.15400000E-05
   -3.70600000E-05  -1.71700000E-05  +1.21600000E-05  +1.21700000E-05  +1.78200000E-05
   +3.33600000E-05  -3.09900000E-05  +5.80500000E-05  +4.63100000E-05  +2.33700000E-05
   +7.00000000E-07  +1.22500000E-05  -2.27000000E-06  -9.71000000E-06  +6.97900000E-05
   -1.71000000E-06  -5.48000000E-06  -1.22700000E-05  -6.00400000E-05  +3.70600000E-05
   -3.65000000E-06  +6.08000000E-06  -2.64200000E-05  +2.03910000E-04  +1.64860000E-04
   -1.49070000E-04  +1.46500000E-05  -5.76000000E-05  +1.68500000E-05  -2.20100000E-05
   +8.42100000E-05  -2.06960000E-04  +3.84170000E-04  +3.28520000E-04  -1.84400000E-05
   +2.04212630E-01  -1.62530000E-04  -1.44100000E-04  -3.12900000E-05  +2.10840000E-04
   +1.02400000E-05  -1.92690000E-04  -2.57940000E-04  -2.77190000E-04  +6.47700000E-05
   +2.00940000E-04  +3.11620000E-04  +3.68430000E-04  +4.65580000E-04  -1.00040000E-04
   +5.23000000E-06  +4.20100000E-05  +9.70000000E-07  +5.88000000E-06  +1.34080000E-04
   +1.21670000E-04  +3.45000000E-06  -1.66581000E-03  -3.41620000E-04  -1.03584000E-03
   -5.52600000E-05  +1.80600000E-05  -1.15720000E-04  +2.34760000E-04  -6.08830000E-04
   +3.70860000E-04  -2.09724700E-02  -4.29864000E-03  +1.48055000E-02  +2.82174000E-03
   -2.62611000E-03  +4.42492000E-03  +6.82510000E-04  -1.28592000E-03  -6.42370000E-04
   +3.40951000E-03  -3.12970000E-04  +2.04200000E-03  +1.27481700E-02  +6.72146000E-03
   -8.94983000E-03  -6.39564400E-02  -8.66286500E-02  +7.18490800E-02  +8.84880000E-04
   +4.71050000E-04  -5.28500000E-04  -3.44000000E-06  +2.40900000E-05  +8.20000000E-06
   -2.68000000E-05  -1.16000000E-05  -2.01800000E-05  +1.91000000E-06  +2.92000000E-05
   -9.41500000E-05  +8.55900000E-05  -7.00300000E-05  -3.14900000E-05  -1.17600000E-05
   +5.02000000E-06  +4.43000000E-06  +7.33800000E-05  +1.20000000E-05  -3.04800000E-05
   -9.37000000E-06  +8.81600000E-05  +2.42300000E-05  -6.30000000E-05  +2.99000000E-05
   -1.04570000E-04  +2.30670000E-04  -5.67980000E-04  -7.45080000E-04  +3.92700000E-05
   +1.46510000E-04  +2.38600000E-05  +6.70000000E-06  +2.28120000E-04  -3.53440000E-04
   -9.09180000E-04  -7.20200000E-05  +1.05564000E-03  +6.79054400E-02  +8.76173500E-02
   +2.42500000E-04  +1.79970000E-04  +5.39000000E-05  -2.13310000E-04  -1.56250000E-04
   -1.63250000E-04  -1.00430000E-04  -2.50770000E-04  -3.91300000E-05  +1.91220000E-04
   -2.64970000E-04  -1.31560000E-04  -8.66700000E-05  +3.01580000E-04  +2.64920000E-04
   -4.39200000E-04  -3.57450000E-04  +2.88490000E-04  +4.33800000E-05  +1.71420000E-04
   +1.44100000E-04  +6.88500000E-05  -1.68062000E-03  -1.91257000E-03  -2.98850000E-04
   -5.00600000E-05  -2.96700000E-05  +3.71600000E-05  -2.07550000E-04  +1.10990000E-04
   +1.17888300E-02  +4.32868000E-03  -7.36483000E-03  +3.82300000E-05  +4.96157000E-03
   +2.29156000E-03  -1.03464000E-03  -5.73080000E-04  -8.11500000E-04  +1.14681000E-03
   +1.41606000E-03  +3.70513000E-03  +1.23222000E-03  +4.02093000E-03  -3.06400000E-04
   +1.26511880E-01  +7.08670700E-02  -1.42383820E-01  +4.24580000E-04  +5.71000000E-06
   +2.18270000E-04  -3.72000000E-05  -2.13300000E-05  -3.11400000E-05  -1.22700000E-05
   +2.63800000E-05  -7.89000000E-06  +5.02500000E-05  +1.21620000E-04  -3.12600000E-05
   +5.10200000E-05  -3.81200000E-05  -5.45100000E-05  +8.06000000E-06  -2.50000000E-07
   -7.99000000E-06  -5.84600000E-05  +9.12500000E-05  -9.17000000E-06  -4.03000000E-06
   -1.18530000E-04  +1.95900000E-05  +4.52300000E-05  +3.35100000E-05  -4.54000000E-06
   +1.93860000E-04  -3.40180000E-04  -1.41060000E-04  +3.40900000E-05  -1.09400000E-04
   +2.80700000E-05  -4.00300000E-05  +2.04490000E-04  -1.36100000E-04  +8.60530000E-04
   +3.97580000E-04  -3.47200000E-05  -1.39364180E-01  -7.95510800E-02  +1.47333290E-01
   +1.30830000E-04  +9.08200000E-05  +2.56900000E-05  -1.24070000E-04  -8.78200000E-05
   -2.16600000E-05  +3.69600000E-05  -2.63300000E-05  -2.88400000E-05  +4.96000000E-06
   -2.71400000E-05  +1.33400000E-05  +1.09100000E-05  -2.82800000E-05  +5.20000000E-07
   -1.24500000E-05  -1.07500000E-05  +3.78700000E-05  +1.51400000E-05  +1.30200000E-05
   +3.07500000E-05  -1.11660000E-04  -2.06400000E-05  +8.50400000E-05  +5.71900000E-05
   -3.64000000E-06  -1.71800000E-05  +1.85400000E-05  +2.38800000E-05  -2.04200000E-05
   -1.87320000E-04  -1.57800000E-04  +2.07670000E-04  +1.18091000E-03  +9.41790000E-04
   -7.43830000E-04  -7.12090000E-03  +2.47689000E-03  +2.37033000E-03  -5.77822000E-03
   +3.77832500E-02  -2.46818600E-02  -1.76725000E-03  +5.52759000E-03  -1.67651000E-03
   +2.93440000E-04  -1.06580000E-04  -4.24100000E-04  -3.78496100E-02  -1.77421400E-02
   +3.11574500E-02  -3.13700000E-05  -1.33100000E-05  -1.49200000E-05  -8.01000000E-06
   +1.40900000E-05  -1.68000000E-06  -1.88400000E-05  +1.32400000E-05  -3.13300000E-05
   -1.22800000E-05  +6.59000000E-06  -4.35000000E-06  +2.46000000E-06  +6.57000000E-06
   -6.87000000E-06  +1.81800000E-05  -2.93000000E-05  +8.89000000E-06  -2.11900000E-05
   -1.14000000E-06  -5.64000000E-06  -7.18000000E-06  +1.02400000E-05  -3.76000000E-06
   -1.25500000E-05  +9.88000000E-06  +3.38800000E-05  -1.15700000E-05  +2.25000000E-06
   +1.39000000E-05  +2.45800000E-05  -2.33600000E-05  -6.20000000E-07  -3.99030000E-04
   +1.60890000E-04  +6.07000000E-05  +3.41400000E-05  -4.33600000E-05  +2.88400000E-05
   +4.91835500E-02  -1.68670000E-04  -1.64060000E-04  -3.19200000E-05  +1.32210000E-04
   +1.26620000E-04  +5.37900000E-05  -3.37500000E-05  -1.82000000E-06  +4.76100000E-05
   -1.59000000E-05  -9.27000000E-06  -1.85100000E-05  -7.72000000E-06  +1.46390000E-04
   +1.65100000E-05  +7.20000000E-06  -3.64000000E-06  -5.27900000E-05  -2.94000000E-05
   -6.83200000E-05  -3.96500000E-05  +2.49440000E-04  -9.95500000E-05  +1.12820000E-04
   -6.06300000E-05  -2.40600000E-05  +3.20900000E-05  -1.63800000E-04  +7.62500000E-05
   -4.23000000E-05  -3.19050000E-04  +1.35630000E-04  -7.43600000E-05  +2.46320000E-04
   -5.73570000E-04  +1.02632000E-03  +1.41232000E-03  +4.37890000E-04  -7.12950000E-04
   +4.81774000E-03  -2.32826200E-02  +1.24492500E-02  -1.48686000E-03  +4.02667000E-03
   -3.50300000E-04  -2.12990000E-04  -1.17466000E-03  +5.01060000E-04  +2.06519800E-02
   -3.53124040E-01  +2.35838940E-01  +1.22800000E-05  +3.66100000E-05  +9.17000000E-06
   -1.78400000E-05  -9.09000000E-06  -2.35900000E-05  +2.56800000E-05  +2.55500000E-05
   +4.84200000E-05  +1.72800000E-05  +1.01700000E-05  -8.14000000E-06  -1.36900000E-05
   -4.75000000E-06  +4.06000000E-06  -2.99500000E-05  +3.52000000E-05  -6.21000000E-06
   +9.92000000E-06  -2.20900000E-05  +5.01000000E-06  +1.79000000E-05  -6.73000000E-06
   -7.71000000E-06  +1.90900000E-05  -1.33400000E-05  -1.41100000E-05  +2.05000000E-06
   -3.81000000E-05  -2.64900000E-05  -5.09400000E-05  +5.21200000E-05  +6.82800000E-05
   +1.37840000E-04  +4.20000000E-06  -1.11230000E-04  -2.94230000E-04  +2.08160000E-04
   +5.97800000E-05  -2.53917500E-02  +3.74805160E-01  +3.89500000E-05  +3.39400000E-05
   -2.00000000E-06  -2.68500000E-05  -2.92800000E-05  -1.33200000E-05  +5.61000000E-06
   -8.81000000E-06  -9.05000000E-06  -2.53000000E-06  +1.41700000E-05  +3.75400000E-05
   +2.85700000E-05  -6.69600000E-05  -3.35800000E-05  -1.47700000E-05  +1.01000000E-05
   +9.61000000E-06  +2.28600000E-05  +3.37200000E-05  -2.55000000E-06  -1.04750000E-04
   +1.03550000E-04  -1.01260000E-04  +1.74700000E-05  +1.30200000E-05  -2.17700000E-05
   +1.27870000E-04  -7.46300000E-05  +4.55000000E-05  +3.31870000E-04  -4.91700000E-05
   -5.46600000E-05  -2.45480000E-04  +6.81940000E-04  +6.81300000E-04  +3.08427000E-03
   -1.16785000E-03  -2.21800000E-04  -1.39785000E-03  -5.10193000E-03  +2.33470000E-03
   +3.27366000E-03  -4.13718000E-03  +3.46969000E-03  -3.61770000E-04  +4.46000000E-04
   -7.33050000E-04  +4.11047000E-03  +2.56200180E-01  -1.85751930E-01  -7.36000000E-06
   -5.37000000E-06  +4.06000000E-06  -6.66000000E-06  -9.20000000E-07  +7.30000000E-07
   -5.55000000E-06  +7.44000000E-06  -2.17700000E-05  +4.04000000E-06  -1.34500000E-05
   -9.00000000E-07  +9.31000000E-06  +7.80000000E-07  -1.05000000E-06  +1.25500000E-05
   -1.30100000E-05  -1.50000000E-06  -5.17000000E-06  +4.10000000E-06  +4.71000000E-06
   -1.02200000E-05  +2.91000000E-06  -1.10400000E-05  +9.72000000E-06  +1.81800000E-05
   -7.33000000E-06  -4.84000000E-06  +2.51000000E-06  +1.84600000E-05  +1.67300000E-05
   -2.68500000E-05  -5.86400000E-05  +7.28800000E-05  -1.23880000E-04  -1.00000000E-05
   +2.24910000E-04  -8.45500000E-05  -7.18000000E-06  -6.09892000E-03  -2.47619820E-01
   +1.82237240E-01  -2.83960000E-04  -2.30790000E-04  -5.93800000E-05  +2.42010000E-04
   +2.02330000E-04  +8.81100000E-05  -4.54400000E-05  +4.01700000E-05  +4.92500000E-05
   -7.02400000E-05  +2.95200000E-05  +1.72400000E-05  +1.21330000E-04  +1.23120000E-04
   +5.68100000E-05  +6.24900000E-05  +2.25600000E-05  -1.25860000E-04  -5.18300000E-05
   -8.89500000E-05  -8.82200000E-05  +6.37820000E-04  +1.12196000E-03  -1.15046000E-03
   -6.04100000E-04  +1.52810000E-04  +2.21200000E-04  +1.63100000E-05  -1.03270000E-04
   -1.08380000E-04  -4.22268000E-03  -1.65392000E-03  +7.64183000E-03  +2.42283000E-03
   +7.56530000E-04  -2.55753000E-03  -7.12821000E-03  +4.18935000E-03  +3.34023000E-03
   +4.74798000E-03  -2.55167100E-02  +2.03180300E-02  -1.12106570E-01  +3.23934000E-02
   +1.32242700E-02  -2.80579000E-03  +3.98575600E-02  -2.29021200E-02  +6.01956000E-03
   -7.24803000E-03  +8.46800000E-05  +4.33900000E-05  +3.81300000E-05  +2.74600000E-05
   -9.61000000E-06  -2.73800000E-05  -1.30000000E-05  +1.54300000E-05  +3.15000000E-06
   +5.18100000E-05  +2.48200000E-05  +2.25000000E-06  +3.86000000E-06  -1.79000000E-05
   -1.27400000E-05  +8.71000000E-06  -9.32100000E-05  +1.58260000E-04  -1.49160000E-04
   +3.81800000E-05  -1.89800000E-05  +3.49000000E-06  +2.87300000E-05  -6.88000000E-06
   -2.57600000E-05  +2.93000000E-05  -4.25200000E-05  -6.27400000E-05  +3.60200000E-05
   +1.68700000E-05  +1.89000000E-06  -4.52600000E-05  +7.78300000E-05  +9.68000000E-06
   +2.67800000E-04  -7.99200000E-05  -2.36620000E-04  +1.98484000E-03  -1.30083000E-03
   -2.39625000E-03  +8.05920000E-04  +8.23700000E-05  -1.04821000E-03  +4.54884360E-01
   +8.61490000E-04  +8.74580000E-04  +1.31660000E-04  -6.61790000E-04  -6.53920000E-04
   -2.78140000E-04  +1.40680000E-04  +6.52200000E-05  -2.71520000E-04  -4.33200000E-05
   +5.05000000E-05  +1.25090000E-04  -2.85660000E-04  -6.98850000E-04  -1.94890000E-04
   -1.51580000E-04  +4.67500000E-05  +2.55390000E-04  +1.95760000E-04  +3.95820000E-04
   +1.71420000E-04  -1.44276000E-03  -2.73070000E-04  +1.26089000E-03  +8.67990000E-04
   -2.91670000E-04  -2.37040000E-04  +3.31070000E-04  -3.43500000E-05  -1.26400000E-05
   +2.43245000E-03  +2.44245000E-03  +2.38857000E-03  +4.46581000E-03  -5.61659000E-03
   +8.29520000E-04  -1.62778000E-03  +8.77092000E-03  -2.16259000E-03  +7.10234000E-03
   -3.49557400E-02  +2.70975900E-02  +6.93723600E-02  -2.30042930E-01  +9.75910000E-02
   +8.63332000E-03  -2.79686600E-02  +1.98820500E-02  -5.83959000E-03  +6.43276000E-03
   -3.78877000E-03  -3.57100000E-05  -2.01690000E-04  -1.19500000E-05  +9.63000000E-05
   +2.77100000E-05  +1.42100000E-04  -1.89300000E-04  -2.03370000E-04  -2.25380000E-04
   -7.98700000E-05  -7.16500000E-05  +3.24700000E-05  +1.05890000E-04  +5.50000000E-07
   -8.54000000E-06  +2.67460000E-04  -3.07630000E-04  +1.94200000E-05  -5.72300000E-05
   +2.99320000E-04  +8.39000000E-06  -1.84680000E-04  +3.05300000E-05  -1.51940000E-04
   -6.49700000E-05  +4.78600000E-05  +7.91100000E-05  -3.15000000E-05  +1.47460000E-04
   +1.63170000E-04  +1.88310000E-04  -2.35730000E-04  -1.09400000E-04  -1.42600000E-04
   -3.50700000E-05  -1.49350000E-04  -1.73884000E-03  +1.50137000E-03  -3.03026000E-03
   -1.42283000E-03  -1.52152000E-03  +9.30960000E-04  +3.08074500E-02  +3.47717130E-01
   -4.65670000E-04  -4.35170000E-04  -5.73300000E-05  +3.54210000E-04  +3.45240000E-04
   +1.47780000E-04  -5.15100000E-05  +3.81200000E-05  +1.59190000E-04  -2.63500000E-05
   -2.16700000E-05  -1.31650000E-04  -1.10970000E-04  +2.61280000E-04  +1.27500000E-04
   +1.41990000E-04  -3.98000000E-06  -1.60960000E-04  -1.32830000E-04  -2.49910000E-04
   -8.77500000E-05  +1.10212000E-03  -1.88900000E-05  +1.58400000E-05  -2.52310000E-04
   +2.50300000E-05  +6.72100000E-05  -1.96140000E-04  +9.87300000E-05  -8.32300000E-05
   +4.34875000E-03  +4.80418000E-03  +1.61089000E-03  -5.38614000E-03  +2.60019000E-03
   -5.69830000E-04  +7.47511000E-03  -5.27985000E-03  +4.60987000E-03  -2.50517000E-03
   +4.46135400E-02  -2.10582300E-02  -1.26330300E-02  +1.15163980E-01  -1.15593960E-01
   -8.04000000E-04  +3.57853000E-03  +5.55631000E-03  -9.71860000E-04  -3.21070000E-03
   -6.10660000E-04  +4.41000000E-05  +9.16200000E-05  +7.72000000E-06  -1.95600000E-05
   -1.91800000E-05  -4.82700000E-05  +1.15340000E-04  +8.28500000E-05  +1.42260000E-04
   +2.10400000E-05  +5.82500000E-05  -4.87000000E-06  -6.57900000E-05  -4.40000000E-07
   +5.25000000E-06  -1.78820000E-04  +3.78800000E-05  -9.20000000E-07  +2.43700000E-05
   -2.04010000E-04  +9.30000000E-07  +1.29130000E-04  -9.69000000E-06  +8.73800000E-05
   -1.36600000E-05  -6.14000000E-05  -5.65000000E-06  +1.00700000E-05  -7.86500000E-05
   -1.23390000E-04  -1.16160000E-04  +7.34600000E-05  +1.15250000E-04  -2.19510000E-04
   -1.66620000E-04  -8.66400000E-05  -1.97705000E-03  -3.48037000E-03  -1.18229000E-03
   +5.11100000E-05  +1.68680000E-04  -1.49389000E-03  -2.33801060E-01  -2.39133430E-01
   +3.07101910E-01  +5.57500000E-05  +6.03000000E-06  +2.35200000E-05  -8.66400000E-05
   -3.46800000E-05  +1.80000000E-06  +3.30300000E-05  -4.96500000E-05  -2.87000000E-06
   +3.33400000E-05  -4.80500000E-05  -4.87800000E-05  +7.25700000E-05  +5.53000000E-05
   +3.48800000E-05  +1.96500000E-05  -1.28500000E-05  +4.97500000E-05  -2.55200000E-05
   -6.64600000E-05  +3.70500000E-05  +6.63800000E-05  +1.07380000E-04  -8.46400000E-05
   -5.03900000E-05  +1.69200000E-05  -1.42600000E-05  -1.81500000E-05  +2.19700000E-05
   -1.94700000E-05  -7.84500000E-04  +2.74920000E-04  -2.46880000E-04  -6.59780000E-04
   +4.49020000E-04  +5.53100000E-05  +9.62060000E-04  -4.36310000E-04  +5.39050000E-04
   -9.84620000E-04  +3.88126000E-03  -1.26592000E-03  +7.56904000E-03  +4.13014000E-03
   -7.64449000E-03  +2.77629000E-03  +2.56578000E-03  -3.50336000E-03  +6.80680000E-04
   -1.24271000E-03  +5.53890000E-04  -3.26100000E-05  +5.56000000E-06  -2.32200000E-05
   -1.26100000E-05  +1.60800000E-05  -1.69700000E-05  +1.12500000E-05  +3.08300000E-05
   +7.09000000E-06  -4.44000000E-06  +2.71200000E-05  -9.65000000E-06  -1.76200000E-05
   +1.33600000E-05  -7.07000000E-06  -1.42400000E-05  +1.49500000E-05  +9.31000000E-06
   -1.11000000E-05  -4.60100000E-05  +6.60000000E-06  +1.67400000E-05  +2.27000000E-06
   +1.72800000E-05  +2.45900000E-05  +2.92300000E-05  +4.19100000E-05  -1.16200000E-05
   -4.86200000E-05  +5.80000000E-06  -4.76000000E-06  +3.27000000E-06  +1.33000000E-06
   -5.64000000E-05  -2.22000000E-05  +9.73000000E-05  -1.08248000E-03  -4.14100000E-04
   +1.04565000E-03  +1.00262000E-03  -9.75000000E-05  -9.11440000E-04  -3.45979530E-01
   -1.11504730E-01  +2.46556700E-01  +3.36736110E-01  -2.46740000E-04  -2.69690000E-04
   -3.94700000E-05  +2.18010000E-04  +1.94060000E-04  +6.52400000E-05  -5.86600000E-05
   -5.22000000E-05  +6.19200000E-05  +6.18000000E-06  +4.30700000E-05  +1.73500000E-05
   +4.85600000E-05  +1.47970000E-04  +1.29000000E-06  +2.01600000E-05  +1.62800000E-05
   -7.58000000E-05  -2.19400000E-05  -7.64100000E-05  -5.53900000E-05  +2.24310000E-04
   +6.28500000E-05  -9.01500000E-05  -1.66030000E-04  +7.16000000E-06  +3.92800000E-05
   -1.06820000E-04  -3.78500000E-05  +2.65800000E-05  -3.31280000E-04  -9.35980000E-04
   +2.90050000E-04  +6.08640000E-04  +2.29820000E-04  -4.50960000E-04  -1.82412000E-03
   +9.38590000E-04  +1.38204000E-03  +3.66435000E-03  -4.97036000E-03  +2.82634000E-03
   -3.34105400E-02  -1.64616800E-02  +2.65093700E-02  -1.40087000E-03  +2.36251000E-03
   -1.47758000E-03  +1.07328000E-03  +8.56730000E-04  -1.18003000E-03  +1.95000000E-06
   +6.46000000E-05  -1.75000000E-06  -2.98400000E-05  -5.69000000E-06  -4.48700000E-05
   +1.93500000E-05  +2.67700000E-05  +4.31200000E-05  +3.83200000E-05  -2.70000000E-06
   -1.29500000E-05  -2.41900000E-05  +3.06000000E-06  +4.62000000E-06  -3.80400000E-05
   +6.56300000E-05  -2.24900000E-05  +9.37000000E-06  -2.87800000E-05  +5.43000000E-06
   +1.93700000E-05  +2.27000000E-06  -1.94000000E-05  +6.85300000E-05  -1.99000000E-05
   -7.20800000E-05  +6.70000000E-06  -2.77800000E-05  -1.52100000E-05  -5.26900000E-05
   +8.08700000E-05  +9.07000000E-06  +1.33610000E-04  +7.05000000E-05  -4.33200000E-05
   +1.89888000E-03  -2.84580000E-04  -3.32350000E-04  -1.42440000E-03  -3.28710000E-04
   +4.54660000E-04  -7.17750800E-02  -6.42249300E-02  +7.84469800E-02  +1.02369590E-01
   +8.29616500E-02  +1.39420000E-04  +9.58700000E-05  +7.75000000E-06  -1.34810000E-04
   -9.46700000E-05  -1.16300000E-05  +2.08500000E-05  -9.32900000E-05  -3.22900000E-05
   +4.69200000E-05  +8.44000000E-06  +5.38500000E-05  +2.72200000E-05  -6.96700000E-05
   -3.81100000E-05  -6.32200000E-05  +7.10000000E-06  +4.63600000E-05  +3.78000000E-05
   +6.84300000E-05  +1.09800000E-05  -1.72700000E-04  -5.24800000E-05  +1.18990000E-04
   +1.04570000E-04  -4.08400000E-05  -5.77500000E-05  +5.75000000E-05  -7.29400000E-05
   +7.44100000E-05  +1.14070000E-04  -1.69160000E-04  -8.65030000E-04  +4.41300000E-05
   -3.91290000E-04  +3.39840000E-04  +1.54940000E-03  +6.93010000E-04  +1.26920000E-04
   -1.02697000E-03  +2.75557000E-03  +4.92680000E-04  +1.84090300E-02  +8.33534000E-03
   -1.71735300E-02  -7.83020000E-04  -3.41504000E-03  +2.04518000E-03  -1.13138000E-03
   +2.33870000E-04  +4.97610000E-04  -3.80100000E-05  -1.11300000E-05  -8.61000000E-06
   -2.20700000E-05  +1.58200000E-05  -1.81000000E-05  -1.56600000E-05  +3.18200000E-05
   -6.01600000E-05  +8.57000000E-06  -3.20200000E-05  -8.90000000E-06  +2.57000000E-05
   -1.55000000E-06  -2.37000000E-06  +4.13500000E-05  -3.06300000E-05  +1.85000000E-05
   -1.70600000E-05  +1.82300000E-05  +7.90000000E-06  -2.17400000E-05  +1.06500000E-05
   -2.57600000E-05  +1.99300000E-05  +2.90000000E-05  +6.19000000E-06  -1.19100000E-05
   +2.91000000E-06  +2.23900000E-05  +2.79200000E-05  -2.05000000E-05  -4.71000000E-05
   -8.20000000E-07  +4.56700000E-05  +8.51800000E-05  -4.39140000E-04  +8.46950000E-04
   +3.09690000E-04  -2.70600000E-05  -2.89440000E-04  -5.79980000E-04  +2.18842020E-01
   +9.75617000E-02  -1.77020720E-01  -2.35200370E-01  -1.06017440E-01  +1.91880310E-01
   -7.98690000E-04  -6.41350000E-04  -1.73450000E-04  +6.60780000E-04  +5.51900000E-04
   +2.27690000E-04  -1.61810000E-04  +9.18100000E-05  +1.77190000E-04  -8.53800000E-05
   +6.73300000E-05  -6.01000000E-05  -8.40100000E-05  +6.70970000E-04  +2.04860000E-04
   +5.63100000E-05  -3.60900000E-05  -3.01710000E-04  -1.39310000E-04  -2.29470000E-04
   -1.85440000E-04  +4.94860000E-04  -1.27553000E-03  +6.48010000E-04  -3.61470000E-04
   -6.27400000E-05  +9.23100000E-05  -4.02920000E-04  -5.55600000E-05  +4.06700000E-05
   +8.81620000E-04  +5.34740000E-03  -2.03312000E-03  -4.11519800E-02  -1.31844200E-02
   +3.47898500E-02  -2.00406240E-01  -5.89646900E-02  +1.26529350E-01  -1.41120600E-02
   -4.14531000E-03  +1.66839000E-02  +3.64056000E-03  +5.59770000E-03  -2.05895000E-03
   -4.59582000E-03  -2.59024000E-03  +3.80645000E-03  +1.05633300E-02  -4.30540000E-04
   -7.51006000E-03  +1.21700000E-04  +1.05170000E-04  +8.11900000E-05  -3.06500000E-05
   -8.82400000E-05  -4.48100000E-05  +1.54870000E-04  +6.31400000E-05  +2.20250000E-04
   +8.33200000E-05  +6.37000000E-06  -2.81000000E-06  -4.71100000E-05  -4.06500000E-05
   +2.71000000E-05  -1.92660000E-04  +1.90040000E-04  -7.97000000E-06  +1.16990000E-04
   -1.12230000E-04  +2.98400000E-05  +9.87400000E-05  -3.37900000E-05  +4.97400000E-05
   +7.25100000E-05  -1.07500000E-05  -2.02870000E-04  +8.92700000E-05  -7.12700000E-05
   -1.14340000E-04  -1.87310000E-04  +2.59710000E-04  +9.80500000E-05  +1.55325000E-03
   -1.58661000E-03  -1.65715000E-03  +1.63600000E-04  -3.12790000E-04  +7.83100000E-05
   +5.75170000E-04  +6.92870000E-04  -7.46340000E-04  +6.76270000E-04  -1.11488000E-03
   +2.50260000E-04  -2.32330000E-04  +4.64770000E-04  -4.38850000E-04  +5.65430040E-01
   -1.89760000E-04  -1.36670000E-04  -4.42000000E-05  +1.59170000E-04  +1.36230000E-04
   +9.46200000E-05  -8.27000000E-06  +8.90000000E-05  +1.73300000E-05  -7.16200000E-05
   +6.08400000E-05  -4.32100000E-05  +8.39500000E-05  -4.15000000E-05  -6.21800000E-05
   +1.06320000E-04  +1.00310000E-04  -7.67800000E-05  -4.69600000E-05  -5.21900000E-05
   -8.12100000E-05  +7.71130000E-04  +4.60910000E-04  -3.98760000E-04  -2.90130000E-04
   +6.33000000E-05  -2.73100000E-05  -1.18040000E-04  +5.58600000E-05  +9.41300000E-05
   +2.91000000E-03  -5.66013000E-03  +5.24124000E-03  +1.51547600E-02  +1.75636700E-02
   -1.60857100E-02  -1.77921400E-02  -1.20681110E-01  +6.52981000E-02  -3.25246100E-02
   -1.52099100E-02  +3.65234000E-02  +1.20384400E-02  -1.02140000E-03  -4.25080000E-04
   -4.75207000E-03  +2.88341000E-03  -5.78110000E-04  -1.66358000E-03  +6.93870000E-04
   -2.59435000E-03  +4.30100000E-05  +1.64100000E-05  +2.42600000E-05  +7.31000000E-06
   -2.34700000E-05  -1.26000000E-06  +4.80500000E-05  -3.99200000E-05  +9.25200000E-05
   +2.43900000E-05  -1.97000000E-05  +9.12000000E-06  +1.04000000E-06  -9.72000000E-06
   +1.06600000E-05  -2.50600000E-05  +4.83900000E-05  +8.80000000E-07  +2.67400000E-05
   +4.36000000E-06  +3.77400000E-05  -1.24600000E-05  -7.24000000E-06  +2.43900000E-05
   +3.93100000E-05  +7.69000000E-06  -1.76300000E-04  +2.80800000E-05  -1.90700000E-05
   -1.53500000E-05  -6.48500000E-05  +1.21630000E-04  -1.73400000E-05  -1.95297000E-03
   +4.86200000E-05  -1.63874000E-03  -1.08280000E-04  +1.69940000E-04  -4.86700000E-05
   -1.47209000E-03  +9.14050000E-04  +3.21370000E-04  -2.20365000E-03  -1.30389000E-03
   +1.83335000E-03  -1.75900000E-05  -3.81360000E-04  -3.18600000E-05  -1.90911420E-01
   +3.49792190E-01  +5.82770000E-04  +4.66980000E-04  +1.46510000E-04  -4.56520000E-04
   -4.10360000E-04  -2.28980000E-04  +6.70700000E-05  -1.09120000E-04  -1.02180000E-04
   +1.61510000E-04  -7.77500000E-05  +1.23300000E-05  +1.50550000E-04  -4.25170000E-04
   -2.83600000E-05  -9.97700000E-05  -7.29800000E-05  +2.45760000E-04  +1.05500000E-04
   +1.97840000E-04  +1.90130000E-04  -7.06490000E-04  +4.68840000E-04  +1.91840000E-04
   +3.32960000E-04  -1.08350000E-04  -1.37610000E-04  +1.98440000E-04  +3.89500000E-05
   -6.77700000E-05  -4.43470000E-04  +4.12799000E-03  +1.43221000E-03  +1.46184200E-02
   -9.12610000E-04  -5.81580000E-04  +9.68846600E-02  +8.72905800E-02  -1.58296750E-01
   +3.71611100E-02  +2.12589600E-02  -2.40209400E-02  -6.76341000E-03  +3.00187000E-03
   +8.84475000E-03  +5.04124000E-03  -1.78900000E-03  -3.12521000E-03  -6.74575000E-03
   -3.15197000E-03  +1.83145000E-03  -8.59100000E-05  -7.00300000E-05  -7.15800000E-05
   +3.21100000E-05  +7.73800000E-05  +2.92700000E-05  -1.29700000E-04  -2.51600000E-05
   -1.93570000E-04  -7.21000000E-05  +1.04300000E-05  +6.59000000E-06  +2.18500000E-05
   +3.45100000E-05  -2.27600000E-05  +1.40090000E-04  -1.11360000E-04  +4.87500000E-05
   -3.95400000E-05  +8.67100000E-05  -4.76400000E-05  -3.43100000E-05  +7.98400000E-05
   +1.48000000E-06  -9.02100000E-05  -5.41000000E-06  +2.19580000E-04  -5.03400000E-05
   +8.09200000E-05  +6.45000000E-05  +1.51990000E-04  -1.65020000E-04  -2.43300000E-05
   -1.38874000E-03  -1.83691000E-03  -1.58448000E-03  +9.00000000E-06  +9.16800000E-05
   +6.49200000E-05  +8.74800000E-04  -8.80360000E-04  +3.99480000E-04  +1.08051000E-03
   +1.33282000E-03  -1.81366000E-03  -1.15310000E-04  -3.07160000E-04  -2.23860000E-04
   -1.49837240E-01  -1.27663000E-01  +2.02212360E-01  +1.58250000E-04  +1.24510000E-04
   +2.88200000E-05  -1.30430000E-04  -1.13000000E-04  -5.11400000E-05  +2.55300000E-05
   -3.31500000E-05  -3.90200000E-05  +7.60000000E-06  -9.62000000E-06  +5.08300000E-05
   +2.50000000E-07  -3.97900000E-05  +2.20000000E-06  -4.10500000E-05  -2.82200000E-05
   +3.84600000E-05  +3.41900000E-05  +4.83900000E-05  +4.39200000E-05  -2.32910000E-04
   -1.63840000E-04  +1.01500000E-04  +8.37200000E-05  -3.18400000E-05  -9.95000000E-06
   +6.16600000E-05  -1.10700000E-05  -1.22400000E-05  -6.12900000E-04  +1.63961000E-03
   +1.51190000E-04  -7.69010000E-04  -3.28309000E-03  +3.53185000E-03  -3.45229200E-02
   +1.98382500E-02  +3.21432000E-03  +2.62221000E-03  +7.08590000E-04  -1.13746000E-03
   -2.12797000E-03  +1.54700000E-05  +7.57830000E-04  +8.14910000E-04  -2.22680000E-04
   -3.65750000E-04  -7.47850000E-04  +1.06920000E-04  -2.78330000E-04  -2.96900000E-05
   -2.17000000E-05  -1.30000000E-05  -3.72000000E-06  +1.14100000E-05  +7.48000000E-06
   -2.87400000E-05  +3.67000000E-06  -4.68100000E-05  -1.32500000E-05  +3.90000000E-07
   -2.68000000E-06  +6.76000000E-06  +5.97000000E-06  -7.21000000E-06  +4.04200000E-05
   -1.74200000E-05  -6.51000000E-06  -1.14400000E-05  +3.48900000E-05  +3.54000000E-06
   -2.98200000E-05  +1.10500000E-05  -2.05200000E-05  -1.60600000E-05  +8.88000000E-06
   +3.33400000E-05  -7.93000000E-06  +2.10400000E-05  +2.63500000E-05  +3.96000000E-05
   -3.27800000E-05  -1.59100000E-05  +1.48470000E-04  -3.11270000E-04  -1.73190000E-04
   -6.60000000E-07  -1.29100000E-05  -3.59700000E-05  +7.80100000E-05  -1.39850000E-04
   -3.93050000E-04  +3.58900000E-04  +7.50940000E-04  -6.96720000E-04  +9.24000000E-06
   +1.73200000E-05  +2.83700000E-05  -3.22443450E-01  +2.22783880E-01  +9.44424000E-03
   +3.57280090E-01  -2.07500000E-05  -2.70300000E-05  -5.92000000E-06  +2.02100000E-05
   +1.63500000E-05  +2.13000000E-06  -6.14000000E-06  -1.02700000E-05  +8.22000000E-06
   +6.68000000E-06  -1.13000000E-06  +2.05300000E-05  +2.90800000E-05  +1.41600000E-05
   +1.25600000E-05  -3.25000000E-06  -1.33600000E-05  -5.77000000E-06  +1.79000000E-06
   -2.30000000E-06  -5.24000000E-06  -1.38930000E-04  -9.68800000E-05  +2.20500000E-05
   +4.62000000E-06  +4.20000000E-06  -1.70300000E-05  +7.01800000E-05  -2.77700000E-05
   +2.37800000E-05  +3.90420000E-04  +9.08010000E-04  +4.27950000E-04  -2.65397000E-03
   -3.85820000E-04  +2.63767000E-03  -1.31956600E-02  +9.90260000E-03  -1.38839000E-03
   -7.92081000E-03  +1.33319000E-03  +4.39672000E-03  +1.08946000E-03  -1.10700000E-05
   -1.08481000E-03  -5.28810000E-04  -2.21610000E-04  +3.93550000E-04  +1.72272000E-03
   -7.23470000E-04  -1.19102000E-03  -3.40000000E-06  +8.65000000E-06  +1.53000000E-06
   -9.54000000E-06  -1.93000000E-06  -6.17000000E-06  +5.83000000E-06  +1.99500000E-05
   -3.89000000E-06  +5.41000000E-06  +4.10000000E-07  -3.93000000E-06  -3.14000000E-06
   +1.80000000E-06  -1.44000000E-06  -5.39000000E-06  +1.57000000E-06  +6.49000000E-06
   -1.70000000E-06  -2.06300000E-05  +3.86000000E-06  +1.75000000E-06  +7.60000000E-06
   +2.98000000E-06  -1.10000000E-06  +4.78000000E-06  -8.41000000E-06  +8.70000000E-07
   -4.76000000E-06  -1.77000000E-06  +2.76000000E-06  +5.48000000E-06  -3.11600000E-05
   -2.51870000E-04  -6.35200000E-05  -2.50730000E-04  +5.60600000E-05  -8.46200000E-05
   -5.66800000E-05  +9.51670000E-04  -5.70730000E-04  -7.55870000E-04  +2.34040000E-04
   -2.09670000E-04  +5.20700000E-05  +2.05000000E-05  -2.57900000E-05  +7.36000000E-05
   +2.61789380E-01  -2.28623390E-01  +1.94754000E-02  -2.41658950E-01  +2.18897020E-01
   -7.17100000E-05  -5.95000000E-05  -2.07200000E-05  +5.68000000E-05  +4.83400000E-05
   +2.07400000E-05  -2.17800000E-05  +1.03200000E-05  +1.26500000E-05  -2.30000000E-05
   -4.20000000E-07  +1.34800000E-05  +4.65600000E-05  +2.79500000E-05  -2.52500000E-05
   +1.15000000E-06  +2.38000000E-06  -2.23400000E-05  -7.91000000E-06  -1.41800000E-05
   -2.52100000E-05  +1.83600000E-04  +8.18100000E-05  -1.09490000E-04  -6.62100000E-05
   +2.48500000E-05  +8.10000000E-06  -4.20900000E-05  +4.59100000E-05  -9.34000000E-06
   +9.34930000E-04  -3.27460000E-04  +1.34730000E-03  +3.00877000E-03  +3.04197000E-03
   -2.45714000E-03  +2.71046300E-02  -1.91127900E-02  -2.63623000E-03  +5.05952000E-03
   -2.70570000E-04  -1.04493000E-03  +3.04000000E-06  -5.01940000E-04  -3.27890000E-04
   -1.27860000E-04  +2.12380000E-04  -2.09960000E-04  -1.42374000E-03  -3.32350000E-04
   -1.27500000E-04  +1.00600000E-05  +8.80000000E-06  +1.22300000E-05  -9.37000000E-06
   -1.28200000E-05  -4.65000000E-06  +1.85900000E-05  +1.04700000E-05  +3.26000000E-05
   +1.25700000E-05  -2.00000000E-06  -4.83000000E-06  -1.09000000E-06  -4.03000000E-06
   +2.37000000E-06  -1.41100000E-05  +1.63100000E-05  +1.81000000E-06  +7.34000000E-06
   -2.15600000E-05  +7.10000000E-06  +4.52000000E-06  +1.23000000E-06  -5.16000000E-06
   +1.22300000E-05  -1.02000000E-06  -2.38100000E-05  +1.31000000E-06  -2.81700000E-05
   -1.08300000E-05  -2.80000000E-05  +3.11400000E-05  +1.60100000E-05  -2.15220000E-04
   -2.20730000E-04  -3.22550000E-04  -8.78100000E-05  -3.50000000E-06  -4.23400000E-05
   -1.19126000E-03  -1.31930000E-04  -1.04750000E-04  -3.46350000E-04  -2.37450000E-04
   +3.78610000E-04  +3.04800000E-05  +7.50800000E-05  +2.91700000E-05  -1.86598100E-02
   +4.03863400E-02  -2.53706400E-02  -1.41587900E-02  -2.27428700E-02  +3.10234000E-02
end_hess

