# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.18843350    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.41094309E+00  -2.82251219E-01  +1.47424568E+00
   006   +1.94908931E+00  +1.53582410E+00  -3.90280725E-01
   006   +3.76736530E+00  +1.76272245E+00  -2.27332425E+00
   006   +5.92467431E+00  +2.77958927E-01  -2.38266174E+00
   006   +6.33866091E+00  -1.51449712E+00  -5.27373530E-01
   006   -4.53544751E-01  +3.14700248E+00  -3.06505173E-01
   006   -3.57668724E-01  +4.84262077E+00  +2.05080940E+00
   008   +8.41683533E+00  -3.00223790E+00  -5.94067450E-01
   006   -2.78216556E+00  +1.42374735E+00  -3.52786676E-01
   006   -2.91686898E+00  -5.23800797E-01  -2.11253614E+00
   006   -5.01749172E+00  -2.07159369E+00  -2.29337702E+00
   006   -7.06216690E+00  -1.69431526E+00  -6.92107164E-01
   006   -6.96952149E+00  +2.36613267E-01  +1.07419543E+00
   006   -4.85010044E+00  +1.76605502E+00  +1.22863332E+00
   008   -9.17668141E+00  -3.15563263E+00  -7.72540919E-01
   006   -6.52632803E-01  +4.90171854E+00  -2.61373195E+00
   008   +7.40763571E-01  -6.47277532E-01  +3.37673900E+00
   001   -8.99846720E+00  -4.40447875E+00  -2.06742022E+00
   001   -5.06062562E+00  -3.58025294E+00  -3.67945526E+00
   001   -1.33297948E+00  -8.62109657E-01  -3.36424508E+00
   001   -4.82870236E+00  +3.23962201E+00  +2.64260405E+00
   001   -8.56090366E+00  +5.19291005E-01  +2.32486737E+00
   001   -2.41850497E+00  +5.95557127E+00  -2.49893117E+00
   001   +8.97778163E-01  +6.26081575E+00  -2.66674759E+00
   001   -6.71324865E-01  +3.84799889E+00  -4.38354046E+00
   001   -3.96022423E-01  +3.74487992E+00  +3.78830680E+00
   001   +1.38094562E+00  +5.94788874E+00  +2.01789410E+00
   001   -1.93671791E+00  +6.16754286E+00  +2.07316718E+00
   001   +3.49545557E+00  +3.13739946E+00  -3.75672905E+00
   001   +7.27756295E+00  +4.87974458E-01  -3.89741852E+00
   001   +8.24118940E+00  -4.26582526E+00  +6.97158947E-01
   001   +1.20984134E+00  -2.17085972E+00  +4.24552837E+00
   006   +4.58870603E+00  -1.74704299E+00  +1.41273941E+00
   008   +4.95196472E+00  -3.57795620E+00  +3.26287156E+00
   001   +5.83901115E+00  -2.84353037E+00  +4.66272032E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.60000000E-07  -2.30000000E-07  +5.00000000E-08
   +7.00000000E-08  -2.50000000E-07  +1.60000000E-07
   +4.10000000E-07  -9.30000000E-07  -5.30000000E-07
   -6.10000000E-07  -6.00000000E-07  -5.70000000E-07
   -5.00000000E-08  -1.30000000E-06  +2.00000000E-08
   +3.20000000E-07  -1.60000000E-07  -4.20000000E-07
   +7.30000000E-07  +2.60000000E-07  -4.70000000E-07
   -5.30000000E-07  -1.18000000E-06  -4.40000000E-07
   +1.20000000E-07  +2.70000000E-07  +1.90000000E-07
   -4.80000000E-07  +4.40000000E-07  +1.40000000E-07
   -5.50000000E-07  +5.20000000E-07  +5.50000000E-07
   -2.20000000E-07  +6.10000000E-07  +9.60000000E-07
   +1.00000000E-07  +9.90000000E-07  +6.60000000E-07
   +5.00000000E-07  +6.30000000E-07  +3.80000000E-07
   -9.10000000E-07  +1.58000000E-06  +5.80000000E-07
   +5.10000000E-07  -3.00000000E-07  -4.10000000E-07
   -6.00000000E-08  +1.50000000E-07  +2.00000000E-07
   -5.70000000E-07  +5.70000000E-07  +1.58000000E-06
   -8.40000000E-07  +2.50000000E-07  +8.00000000E-07
   -5.10000000E-07  -2.10000000E-07  +3.30000000E-07
   +5.40000000E-07  +9.10000000E-07  +4.00000000E-08
   +1.70000000E-07  +1.35000000E-06  +6.80000000E-07
   +4.40000000E-07  -1.10000000E-07  -4.80000000E-07
   +3.60000000E-07  -2.70000000E-07  -6.10000000E-07
   +2.70000000E-07  -4.00000000E-07  -3.10000000E-07
   +5.60000000E-07  +4.60000000E-07  -3.70000000E-07
   +8.70000000E-07  +0.00000000E+00  -6.90000000E-07
   +9.90000000E-07  +5.20000000E-07  -4.70000000E-07
   -1.20000000E-07  -8.70000000E-07  -5.10000000E-07
   -2.40000000E-07  -1.48000000E-06  -5.70000000E-07
   -5.50000000E-07  -9.40000000E-07  -5.00000000E-08
   +1.00000000E-08  +2.60000000E-07  +2.10000000E-07
   -5.10000000E-07  +4.10000000E-07  -8.20000000E-07
   -2.20000000E-07  -9.10000000E-07  +2.50000000E-07
   -2.60000000E-07  -2.00000000E-08  -8.00000000E-08
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.81015740E-01  -1.79516530E-01  +4.69949270E-01  -1.43861220E-01  -2.16223640E-01
   +5.46113120E-01  -1.24160120E-01  +7.08592300E-02  -3.90472000E-02  +5.38398900E-01
   +2.91834600E-02  -1.86464620E-01  +1.16288880E-01  -1.35043590E-01  +4.16453120E-01
   +1.24071900E-02  +8.10078600E-02  -1.81481450E-01  -1.45487420E-01  -1.77042290E-01
   +5.25164960E-01  +4.52155900E-02  -5.88777100E-02  +3.64028600E-02  -2.11705440E-01
   +2.91153000E-02  +9.29985900E-02  +5.59536560E-01  -2.94467300E-02  +1.45599300E-02
   +1.14259500E-02  -6.25708000E-03  -1.00672800E-01  +5.46200600E-02  -1.90851710E-01
   +4.64254730E-01  -7.70450000E-04  +3.81315700E-02  -4.36334500E-02  +1.39324540E-01
   +2.27738800E-02  -2.13162990E-01  -1.34182360E-01  -2.29910090E-01  +5.49589640E-01
   -2.35780300E-02  +3.36550100E-02  -2.07596900E-02  -3.73740000E-02  -6.84815000E-03
   +4.83926500E-02  -2.60347570E-01  +1.43439070E-01  +2.65525000E-03  +5.86390140E-01
   +3.28823000E-02  -4.18381300E-02  +2.32920700E-02  +2.01353300E-02  +3.05234000E-02
   -4.76649000E-02  +1.06587270E-01  -1.66969740E-01  +3.62697000E-02  -1.90834300E-01
   +4.32856070E-01  -2.02824300E-02  +2.24484800E-02  -1.03934000E-02  +1.47803000E-02
   -2.36142200E-02  +2.41559300E-02  +5.06666900E-02  +2.44890000E-03  -1.09576900E-01
   -1.88908630E-01  -2.13226670E-01  +5.61403850E-01  -4.48158500E-02  +2.24807600E-02
   +1.10066900E-02  -3.78025000E-03  -1.31106600E-02  +1.97470700E-02  +1.45209700E-02
   +1.66735600E-02  -3.20791800E-02  -1.17853160E-01  +5.34620500E-02  -2.17254200E-02
   +5.75467560E-01  -1.42740400E-02  +3.50157800E-02  -3.45212700E-02  -1.29129400E-02
   -1.58773900E-02  +3.06700100E-02  +4.71301900E-02  -3.12325800E-02  -1.07039000E-03
   +1.10326100E-02  -1.93348670E-01  +1.46344250E-01  -1.98694720E-01  +4.91968400E-01
   +5.48956300E-02  -6.75351900E-02  +3.12397900E-02  +1.95747000E-02  +3.17792200E-02
   -5.78892100E-02  -7.21680000E-02  +2.66941200E-02  +3.29528000E-02  +3.31568600E-02
   +1.06808960E-01  -2.28097670E-01  -1.40509860E-01  -2.27292560E-01  +5.65127950E-01
   -2.12781000E-03  +9.19519000E-03  -7.99309000E-03  -1.39022850E-01  +4.31695600E-02
   +7.92838000E-03  -1.83148200E-02  +1.15390800E-02  +4.29233000E-03  +2.03010000E-03
   +3.01060000E-04  +3.33094000E-03  -1.77197000E-03  +3.03770000E-04  +4.16930000E-04
   +4.71566550E-01  +1.91981300E-02  -1.29889700E-02  +2.39589000E-03  +4.62280200E-02
   -1.05722490E-01  +6.58486000E-03  +1.27745000E-03  +5.10783000E-03  -5.24320000E-03
   -7.67500000E-05  +3.86417000E-03  +3.79303000E-03  +2.36390000E-04  -1.62570000E-03
   +4.96600000E-04  -3.73691000E-03  +4.77270690E-01  -1.99361200E-02  +1.23739500E-02
   +5.34459000E-03  +4.03691000E-03  +8.92753000E-03  -8.34176200E-02  +1.58759900E-02
   -1.34133600E-02  +4.46735000E-03  +4.07190000E-03  +2.65121000E-03  -5.28950000E-04
   -6.71200000E-05  +7.33700000E-04  -1.78771000E-03  -2.86310000E-04  +6.06786000E-03
   +4.77855650E-01  -7.05000000E-04  +1.03960000E-04  +9.28300000E-04  -3.22220000E-03
   +1.75361800E-02  +2.34243600E-02  -9.93330000E-04  +2.18285000E-03  -8.81810000E-04
   -1.54976000E-03  -2.27520000E-04  -9.24430000E-04  +5.79250000E-04  -7.23440000E-04
   +5.56100000E-04  -7.59684100E-02  -3.44080000E-04  -6.79000000E-06  +5.83130260E-01
   +6.42800000E-04  -2.77110000E-04  -1.26508000E-03  +6.63855000E-03  -1.67466000E-02
   -1.75836400E-02  -9.03830000E-04  -1.18690000E-03  +8.12490000E-04  +7.62240000E-04
   +6.61000000E-06  +6.85580000E-04  -2.61400000E-04  +4.21590000E-04  -3.66410000E-04
   -3.24385000E-03  -1.07740930E-01  -4.78365700E-02  -3.63729000E-03  +5.41498940E-01
   -2.70202000E-03  +1.41851000E-03  +2.12561000E-03  +6.84255000E-03  -6.77592000E-03
   -2.17666000E-03  -6.40220000E-04  +3.44200000E-05  -2.39510000E-04  -3.05660000E-04
   +4.82050000E-04  -1.95460000E-04  +3.14400000E-05  -5.15640000E-04  +6.43400000E-04
   -4.41640000E-03  -4.33306200E-02  -1.40504410E-01  -6.83086000E-03  -6.82910200E-02
   +5.16856230E-01  +5.84855000E-03  -2.67477000E-03  +4.35063000E-03  -2.33149000E-03
   +2.83866000E-03  -2.63020000E-03  +1.46570000E-03  -2.25820000E-04  +4.07012000E-03
   -6.56648000E-03  +1.69666300E-02  -7.46175000E-03  -2.38934280E-01  +1.01686150E-01
   +4.45599700E-02  +1.46827000E-03  -9.45030000E-04  +5.42250000E-04  -1.10653000E-03
   +4.73380000E-04  -5.03300000E-04  +3.27979600E-01  +1.00597000E-03  +1.67168000E-03
   +5.75366000E-03  +1.96228000E-03  -1.24194000E-03  -2.19247000E-03  -2.83998000E-03
   +2.61810000E-03  +5.56083000E-03  +3.81195600E-02  -2.48144100E-02  +4.03956000E-03
   +1.37896990E-01  -1.54131070E-01  +7.82341000E-03  -1.14467000E-03  +6.47270000E-04
   -7.30080000E-04  +9.37580000E-04  -4.30400000E-04  +4.08760000E-04  -1.38803800E-01
   +4.31441810E-01  -6.16980000E-04  +9.79252000E-03  -5.02173000E-03  -2.09304000E-03
   -2.72361000E-03  +3.89941000E-03  +7.39747000E-03  +2.47209000E-03  -4.83015000E-03
   -3.35275900E-02  +2.40208700E-02  +7.79597000E-03  +1.33363500E-02  +3.08938300E-02
   -8.77930800E-02  -7.09100000E-05  -3.04140000E-04  +2.43050000E-04  -1.24330000E-04
   +6.50000000E-05  -1.42560000E-04  -8.63884300E-02  -2.76114310E-01  +3.54195130E-01
   +3.09400000E-05  -1.25550000E-04  -4.02730000E-04  -3.43233100E-02  -1.09327400E-02
   +3.69035000E-03  -1.21216000E-03  +4.85680000E-04  -2.10647000E-03  +4.68100000E-05
   +9.86160000E-04  +5.97120000E-04  -5.02400000E-05  -3.45180000E-04  +3.54280000E-04
   -1.38693790E-01  -4.51972200E-02  +3.22804000E-03  -1.15012000E-03  -5.30084000E-03
   -4.56500000E-03  -1.57870000E-04  +4.72900000E-05  -1.18490000E-04  +5.65497130E-01
   +3.06445000E-03  +2.07390000E-04  -1.29885000E-03  +8.64680000E-03  +1.29024400E-02
   -9.43540000E-04  +1.24403000E-03  -2.02357000E-03  +7.91100000E-04  +6.10510000E-04
   -1.24115000E-03  -3.94780000E-04  -4.16140000E-04  +1.17414000E-03  -6.72550000E-04
   -4.23721000E-02  -1.10345910E-01  -1.14333200E-02  -1.67001300E-02  -1.50760700E-02
   -2.08203000E-03  +1.05785000E-03  -8.86210000E-04  +2.11950000E-04  +9.92929600E-02
   +4.66439140E-01  -4.93180000E-04  +4.89390000E-04  -5.28040000E-04  +3.43853000E-03
   +1.72890000E-03  -3.89520000E-04  +2.97800000E-04  -6.01440000E-04  +1.27910000E-04
   +1.82520000E-04  -3.41170000E-04  -1.55340000E-04  +3.16300000E-05  +1.89100000E-04
   -2.55730000E-04  +5.39328000E-03  -9.32698000E-03  -8.03488600E-02  -2.33253800E-02
   -1.76751500E-02  -1.16200000E-04  +2.38000000E-06  -3.63700000E-05  +5.39800000E-05
   -1.45029590E-01  +1.96826800E-01  +4.60920300E-01  -5.80630000E-04  -2.99180000E-04
   -6.75520000E-04  -9.12130000E-04  -2.53771000E-03  -1.66906000E-03  +4.74340000E-04
   -5.68560000E-04  -6.63960000E-04  -1.06480000E-04  +4.90150000E-04  +4.81100000E-05
   +8.62000000E-06  -9.46500000E-05  +1.99940000E-04  -1.44322000E-03  -2.10310100E-02
   -1.89239700E-02  -4.80115000E-03  -3.07098000E-03  +1.07285000E-03  -1.83250000E-04
   +1.22260000E-04  -1.34200000E-05  -1.20422700E-01  +4.03316000E-03  +3.41289900E-02
   +6.44368690E-01  -1.05252000E-03  -7.32200000E-04  +1.32678000E-03  +1.31920000E-04
   -4.02700000E-04  -1.05109000E-03  +1.13280000E-04  +2.05600000E-05  -2.95680000E-04
   +1.04030000E-04  -1.43740000E-04  -1.83820000E-04  +1.32890000E-04  -9.34800000E-05
   -2.12900000E-05  -7.61115000E-03  -1.58561100E-02  -1.15923000E-02  -2.26747000E-03
   -4.61070000E-04  +7.23660000E-04  -1.16680000E-04  +1.30190000E-04  -4.99900000E-05
   -4.44385100E-02  -2.10025430E-01  -1.05424490E-01  +1.37495860E-01  +4.71999300E-01
   -9.28080000E-04  -8.71440000E-04  +7.03950000E-04  -7.03300000E-04  -9.11860000E-04
   -2.40370000E-04  +3.21550000E-04  -1.11760000E-04  -6.52420000E-04  +3.88900000E-05
   -1.56440000E-04  -2.24770000E-04  +2.56730000E-04  -8.77800000E-05  +9.92600000E-05
   -5.64920000E-03  -2.02528000E-03  +3.31263000E-03  +9.45610000E-04  +3.63630000E-04
   -3.98600000E-05  -1.50110000E-04  +9.01100000E-05  -5.38400000E-05  -1.14574400E-02
   -1.33424100E-01  -1.89172950E-01  -1.72040060E-01  +2.24762600E-01  +4.56680890E-01
   +2.21360000E-04  -1.06770000E-04  +1.15730000E-04  +1.39660000E-04  -7.78300000E-05
   -3.55980000E-04  -2.63850000E-04  +2.91190000E-04  +3.04900000E-05  +1.06980000E-04
   -1.72540000E-04  +5.69600000E-05  +2.53430000E-04  -2.10100000E-05  -2.19080000E-04
   +3.57913000E-03  +4.17910000E-04  +1.72692000E-03  +4.12340000E-04  +3.23880000E-04
   +4.56210000E-04  -2.14430000E-04  +1.52600000E-04  +1.10600000E-05  +2.89459900E-02
   -5.15059800E-02  -6.15455600E-02  -2.63430890E-01  -1.01176110E-01  +2.92545500E-02
   +6.00583140E-01  -1.27700000E-05  +1.73430000E-04  +2.35600000E-05  +7.03720000E-04
   -5.88400000E-05  +2.93040000E-04  -2.38610000E-04  +2.93210000E-04  +3.17750000E-04
   -3.35400000E-05  -4.34700000E-05  +8.39500000E-05  -1.76480000E-04  +7.50300000E-05
   -3.72500000E-05  +6.16540000E-04  +6.46150000E-04  -5.74719000E-03  -1.15952000E-03
   -6.04520000E-04  +2.68450000E-04  +1.63810000E-04  -9.39700000E-05  +1.77500000E-05
   -1.39159000E-02  -3.00840300E-02  -2.68589400E-02  -1.48488150E-01  -1.80095380E-01
   -2.39992300E-02  +1.53937240E-01  +5.04835620E-01  -1.18360000E-04  +2.00450000E-04
   -3.72550000E-04  +7.02350000E-04  +2.84710000E-04  +1.45600000E-04  +9.91200000E-05
   -6.70700000E-05  +1.37370000E-04  -7.42200000E-05  +6.91000000E-05  +3.45200000E-05
   -2.40210000E-04  +1.02320000E-04  +7.13900000E-05  +1.83404000E-03  -4.40552000E-03
   -7.38810000E-04  -6.51500000E-04  -5.76090000E-04  +1.08970000E-04  +2.09550000E-04
   -1.75180000E-04  +1.49200000E-05  -2.59270400E-02  -4.28868000E-03  +1.97226100E-02
   -1.53933600E-02  -5.26395800E-02  -9.91448400E-02  -1.44376610E-01  +2.62753570E-01
   +4.59195680E-01  -6.60430000E-04  -2.31750000E-04  +3.88270000E-04  -1.87290000E-04
   +5.33790000E-04  -1.67700000E-05  +3.19700000E-05  -1.97920000E-04  +1.27510000E-04
   +1.98380000E-04  -1.93320000E-04  +4.18700000E-05  -6.38730000E-04  +4.63880000E-04
   +4.31700000E-05  -2.20078000E-03  -2.63400000E-04  +4.99100000E-05  +3.76120000E-04
   -1.98970000E-04  -3.00270000E-04  +7.41680000E-04  -5.50970000E-04  +2.76400000E-05
   -1.35784200E-02  +2.37388800E-02  +2.71930600E-02  -5.15080700E-02  -3.36499200E-02
   +9.70780000E-04  -2.26398220E-01  +4.04828500E-02  +1.34190260E-01  +6.12806140E-01
   +1.21900000E-05  -2.56500000E-05  +4.34200000E-05  +1.57800000E-04  +7.69630000E-04
   -2.23460000E-04  -2.53280000E-04  +1.38150000E-04  +3.26850000E-04  +2.73050000E-04
   -4.67170000E-04  +1.56420000E-04  -4.54780000E-04  +5.58690000E-04  -2.61030000E-04
   +1.47230000E-04  -7.74940000E-04  -9.70310000E-04  +2.74740000E-04  +8.14000000E-05
   +2.07100000E-05  +6.68920000E-04  -5.31300000E-04  +6.92700000E-05  +2.28784500E-02
   -2.58643700E-02  -3.23620600E-02  +7.00331000E-03  +4.16948300E-02  +3.28602100E-02
   -1.71804800E-02  -1.17540680E-01  -3.52416500E-02  +1.38685890E-01  +5.07675590E-01
   +1.51090000E-04  +6.12500000E-05  +6.64000000E-05  +2.80920000E-04  +3.51940000E-04
   -2.54200000E-04  -3.83590000E-04  +2.11300000E-04  +2.58360000E-04  +1.86200000E-04
   -3.03280000E-04  +1.17840000E-04  -7.02200000E-05  +2.46280000E-04  -2.73380000E-04
   +9.30210000E-04  -2.54500000E-04  -1.38709000E-03  +8.92900000E-05  -2.13900000E-05
   +2.99250000E-04  +1.99990000E-04  -1.68320000E-04  +3.45500000E-05  +2.68559800E-02
   -3.32335600E-02  -5.29063200E-02  +3.93861800E-02  +5.72223500E-02  +3.27459000E-02
   +8.02875600E-02  -7.03780100E-02  -1.83772600E-01  -1.45210970E-01  +2.40825730E-01
   +4.77518020E-01  -4.52840000E-04  -2.19940000E-04  +6.68690000E-04  -3.72780000E-04
   -4.70960000E-04  +8.34200000E-05  +2.04040000E-04  -1.11100000E-04  -2.67700000E-04
   -1.13930000E-04  +2.41970000E-04  -1.25990000E-04  +1.12490000E-04  -2.50310000E-04
   +2.49700000E-04  +3.19790000E-04  +8.56870000E-04  +4.03192000E-03  +1.94600000E-04
   +5.55770000E-04  +1.27560000E-04  -2.11670000E-04  +1.81870000E-04  -5.67000000E-05
   -4.77295500E-02  +4.44350000E-03  +3.71892300E-02  -1.83837100E-02  -2.69254300E-02
   -1.61625300E-02  +3.43259000E-02  +2.42740600E-02  +7.14966000E-03  -1.20350310E-01
   +1.96791000E-02  +4.90679800E-02  +6.49918300E-01  -4.20450000E-04  -2.97770000E-04
   +4.12020000E-04  -5.64120000E-04  -6.78430000E-04  +2.58450000E-04  +2.54730000E-04
   -1.89880000E-04  -3.88770000E-04  -1.89340000E-04  +4.13260000E-04  -1.57960000E-04
   +1.79910000E-04  -4.08840000E-04  +3.16100000E-04  -2.09990000E-04  +2.66428000E-03
   -2.76204000E-03  -4.52360000E-04  -5.67280000E-04  -9.57600000E-05  -3.83420000E-04
   +3.20800000E-04  -8.00400000E-05  -3.19727500E-02  +3.89005900E-02  +4.85121500E-02
   -2.57722700E-02  -4.63097900E-02  -2.54056500E-02  +5.78704700E-02  +1.29107600E-02
   -3.11907000E-02  -3.46341200E-02  -2.07811020E-01  -1.07510210E-01  +1.45856990E-01
   +4.73799130E-01  +3.43030000E-04  +1.39830000E-04  -4.63110000E-04  +8.62010000E-04
   +6.62040000E-04  -5.45700000E-05  +3.22970000E-04  -2.11060000E-04  +1.81600000E-05
   -1.00550000E-04  +6.12800000E-05  -9.84900000E-05  +7.88100000E-05  -8.83900000E-05
   +7.48300000E-05  +4.07574000E-03  -4.18311000E-03  +1.10889000E-03  -6.16970000E-04
   -6.63910000E-04  -2.00880000E-04  -1.10850000E-04  +8.91200000E-05  +1.20900000E-05
   +3.34962000E-03  +2.72805900E-02  +2.99654300E-02  -1.49825100E-02  -2.42810900E-02
   -1.70885400E-02  +3.87327100E-02  -1.08223800E-02  -2.52194600E-02  -2.25379000E-03
   -1.41251950E-01  -2.02867980E-01  -1.81493740E-01  +2.36950560E-01  +4.65541580E-01
   -4.61460000E-04  -1.08500000E-05  +4.11920000E-04  -1.12629000E-03  -1.74336000E-03
   +2.07150000E-04  -6.65160000E-04  +6.62130000E-04  +7.90000000E-06  +6.40800000E-05
   -3.01900000E-05  +2.62540000E-04  +2.75700000E-05  +3.46500000E-05  -2.11840000E-04
   -1.96253800E-02  -4.75520000E-04  +1.22825900E-02  -1.35185000E-03  -4.45900000E-04
   +1.25494000E-03  -1.84100000E-05  +2.70000000E-05  +1.96200000E-05  -2.39834340E-01
   -2.05202000E-02  +8.67297100E-02  +3.51027000E-02  +6.32266100E-02  +4.37584300E-02
   -6.43155000E-02  -1.72396000E-02  +2.06776700E-02  +3.30241900E-02  -5.43820500E-02
   -7.03983500E-02  -2.64609650E-01  -9.86620000E-02  +3.15687600E-02  +5.94650630E-01
   -3.12350000E-04  +3.13900000E-05  +8.68680000E-04  -1.39667000E-03  -2.16812000E-03
   +3.51610000E-04  -5.24920000E-04  +5.89470000E-04  -1.32670000E-04  -5.65900000E-05
   +1.54210000E-04  +1.74850000E-04  +1.22190000E-04  -1.38240000E-04  +7.83000000E-06
   -1.43191900E-02  +6.61736000E-03  +1.16989300E-02  -9.88050000E-04  -3.90570000E-04
   +6.75240000E-04  -1.73590000E-04  +1.63660000E-04  -2.28200000E-05  +2.74121900E-02
   -1.10860030E-01  -5.74773000E-02  +2.63649000E-02  +1.15828700E-02  -1.26806100E-02
   -1.53793300E-02  -7.71818000E-03  +5.51729000E-03  -1.36232000E-02  -3.33649300E-02
   -2.52839900E-02  -1.46072510E-01  -1.78570720E-01  -2.25443600E-02  +1.44232570E-01
   +5.05115560E-01  +1.84100000E-05  +1.29950000E-04  -5.48730000E-04  -1.91882000E-03
   -1.39952000E-03  +3.49420000E-04  +3.55600000E-05  -1.91000000E-05  -1.73610000E-04
   -1.82000000E-04  +4.56440000E-04  +4.73100000E-05  +9.13300000E-05  -2.85120000E-04
   +2.32900000E-04  +5.33910000E-04  +3.66435000E-03  +4.94433000E-03  -8.63330000E-04
   +8.48720000E-04  +2.27430000E-04  -3.19650000E-04  +2.29320000E-04  -4.53500000E-05
   +1.32277490E-01  -2.90005900E-02  -1.74966530E-01  +9.53024000E-03  -3.56027200E-02
   -3.07777100E-02  +2.22339500E-02  +6.99732000E-03  -1.05066000E-02  -3.16894500E-02
   -3.72820000E-04  +2.13674400E-02  -1.37546000E-02  -5.23646500E-02  -1.01571280E-01
   -1.38929140E-01  +2.58120940E-01  +4.76723140E-01  +3.50950000E-04  -3.29000000E-06
   +7.42000000E-06  +1.11300000E-05  -1.00040000E-03  +5.30000000E-06  +1.47480000E-04
   +6.83200000E-05  -4.04530000E-04  -2.85970000E-04  +4.31040000E-04  -1.50110000E-04
   +7.89160000E-04  -7.07330000E-04  +1.34880000E-04  +1.52356000E-03  +5.53980000E-04
   +6.81630000E-04  -5.77820000E-04  +3.39800000E-05  +3.03920000E-04  -1.00647000E-03
   +7.72130000E-04  -7.37100000E-05  -1.43893000E-03  -2.67028000E-03  -2.77980000E-03
   +2.47312000E-03  +3.34034000E-03  +6.14836000E-03  -4.33048000E-02  -3.33364400E-02
   +9.94150000E-04  -2.37405880E-01  -9.22839200E-02  +3.22724000E-02  -3.20440000E-03
   -1.46407500E-02  -7.19103000E-03  -6.80360000E-04  +8.72390000E-04  +4.14315000E-03
   +3.29108950E-01  +1.43720000E-04  -2.72400000E-05  +2.69200000E-05  -1.88400000E-05
   -8.27910000E-04  -1.92500000E-05  +1.38980000E-04  +1.28200000E-05  -3.28060000E-04
   -2.33920000E-04  +3.98510000E-04  -1.25970000E-04  +5.86930000E-04  -5.73140000E-04
   +1.48780000E-04  +1.11973000E-03  +1.56230000E-04  +1.18892000E-03  -4.13760000E-04
   -1.10700000E-05  +1.97540000E-04  -7.82420000E-04  +6.24830000E-04  -6.30900000E-05
   -3.05682000E-03  +7.69510000E-04  +3.46421000E-03  -2.42772000E-03  -4.61240000E-04
   -5.88503000E-03  -5.71600000E-03  +4.38370000E-03  -1.20057000E-03  -1.27407660E-01
   -1.45847030E-01  -1.86136800E-02  -4.13900300E-02  -2.97449000E-02  -9.57153000E-03
   +5.29812000E-03  +2.58581000E-03  -5.80550000E-03  +1.23971650E-01  +4.26450190E-01
   +1.39000000E-04  +7.83000000E-05  -1.66200000E-04  +4.52000000E-06  -1.51450000E-04
   +1.36200000E-04  +3.78900000E-05  +2.74400000E-05  -1.05900000E-05  -6.46100000E-05
   +7.09400000E-05  +7.61000000E-06  +4.77300000E-05  -7.14000000E-05  +2.36400000E-05
   -1.69990000E-04  +4.13980000E-04  +6.80200000E-05  -4.49700000E-05  -3.20400000E-05
   -1.79600000E-05  -8.03200000E-05  +6.02900000E-05  +6.10000000E-06  -2.91644000E-03
   +3.46678000E-03  +3.65798000E-03  +7.95910000E-04  -9.27862000E-03  -1.92296000E-03
   +2.66376800E-02  +1.56289900E-02  +7.80807000E-03  -9.85050000E-04  -4.04118000E-02
   -8.06765700E-02  -3.25128000E-02  -2.61060000E-02  +2.80440000E-03  +8.50917000E-03
   -2.94852000E-03  -2.94041000E-03  -6.89045300E-02  +3.02695630E-01  +3.56134710E-01
   -5.43127000E-03  +2.24094000E-03  +2.25249000E-03  -4.18311000E-03  +1.93359200E-02
   -2.37162900E-02  -2.27376000E-03  +1.31517000E-03  -5.73970000E-04  -1.80400000E-05
   +5.74120000E-04  -9.18280000E-04  +2.47980000E-04  -2.59650000E-04  +2.07210000E-04
   -7.49239400E-02  +2.00970000E-03  -2.06686000E-03  +4.99770000E-04  +3.60000000E-04
   -1.79105000E-03  -4.82290000E-04  +4.23260000E-04  -4.75700000E-05  -2.30048000E-03
   -1.85381400E-02  +2.20118900E-02  -5.96420000E-04  -8.86620000E-04  +8.97230000E-04
   -2.94970000E-04  +7.42980000E-04  +4.37100000E-05  +6.07280000E-04  +6.95840000E-04
   +3.94210000E-04  -1.10436000E-03  +1.49950000E-04  -1.30189000E-03  -6.18610000E-04
   -1.68446000E-03  -6.50960000E-04  -1.25097000E-03  -1.01961000E-03  -1.59230000E-04
   +5.85654130E-01  +2.64167000E-03  -3.06130000E-04  -1.01280000E-03  +6.72031000E-03
   -1.50059900E-02  +1.62848400E-02  +4.57450000E-04  -1.00786000E-03  -5.01590000E-04
   -4.85940000E-04  -3.65500000E-04  +6.56110000E-04  +1.77770000E-04  +5.39000000E-05
   +7.83600000E-05  +6.84311000E-03  -1.09576200E-01  +4.81623700E-02  -4.22550000E-04
   +1.06082600E-02  -1.38906900E-02  -3.93200000E-05  -1.49300000E-05  +2.19300000E-05
   -8.57039000E-03  -2.04483600E-02  +1.83912600E-02  -4.67540000E-04  -3.39010000E-04
   +1.21568000E-03  -9.61300000E-05  +7.97490000E-04  -1.10550000E-04  +1.63000000E-04
   +5.45150000E-04  +4.48960000E-04  -6.00910000E-04  -1.57930000E-04  -9.87500000E-04
   +1.46700000E-03  -9.74510000E-04  -5.97530000E-04  -5.44150000E-04  -5.04480000E-04
   -1.07240000E-04  +7.06524000E-03  +5.36014380E-01  +1.79623000E-03  -7.75490000E-04
   -4.81730000E-04  -4.39699000E-03  +1.55727000E-03  +9.43050000E-04  +8.56230000E-04
   -9.91730000E-04  -4.70500000E-05  +2.55080000E-04  -1.46170000E-04  -1.56830000E-04
   -1.59430000E-04  +1.88160000E-04  +1.34580000E-04  -6.78022000E-03  +4.45304100E-02
   -1.35926410E-01  -1.85681000E-03  +1.47081900E-02  -3.81458200E-02  +3.36260000E-04
   -2.34490000E-04  +1.77000000E-06  +7.56375000E-03  +7.85760000E-03  -2.13053000E-03
   -1.56717000E-03  -1.26913000E-03  -4.18010000E-04  +1.86110000E-04  -1.87300000E-05
   -1.41580000E-04  +1.76600000E-04  +2.14070000E-04  +2.80300000E-04  -2.00200000E-05
   -2.38910000E-04  -1.14230000E-04  -9.18820000E-04  -1.63100000E-04  -1.11870000E-04
   -5.34370000E-04  -4.22060000E-04  -1.17910000E-04  -1.09383800E-02  +6.46978800E-02
   +5.14843550E-01  -1.87687600E-01  +2.05888400E-02  +1.10169980E-01  +8.18016000E-03
   -5.49665000E-03  +4.23251000E-03  -1.20666000E-03  +4.47046000E-03  -1.18328000E-03
   -1.33319000E-03  -3.24301000E-03  +4.00598000E-03  +3.00587000E-03  +7.77320000E-03
   -6.35448000E-03  -2.56905000E-03  -4.29190000E-04  -1.12354000E-03  +1.26315000E-03
   +1.65200000E-05  +1.18234000E-03  -2.61480000E-03  +3.54010000E-04  +2.00962000E-03
   -2.74816000E-03  -2.99340000E-04  -2.87227000E-03  -2.70050000E-04  +1.80301000E-03
   +5.41450000E-04  -1.64510000E-04  +2.40900000E-05  +1.19860000E-04  +8.90720000E-04
   +3.60700000E-05  -9.32400000E-05  +7.46120000E-04  +6.13180000E-04  -2.58630000E-04
   -2.61780000E-04  +6.75520000E-04  -1.33192000E-03  -4.93020000E-04  -2.65450000E-04
   -1.56870000E-04  +5.71230000E-04  -1.28880000E-04  -2.11880000E-04  +2.91598230E-01
   -1.17867100E-02  -9.16878700E-02  +5.68639600E-02  -2.48451000E-02  -4.79000000E-05
   +3.03475400E-02  +7.65822000E-03  -2.60141000E-03  +2.64522000E-03  -3.13804000E-03
   +1.76119000E-03  -1.32810000E-03  +4.03324000E-03  -1.54119000E-03  +7.32600000E-03
   -2.72639000E-03  -2.13550000E-04  -2.59036000E-03  +1.76130000E-03  -2.52576000E-03
   -1.68478000E-03  +3.57940000E-04  +6.78430000E-04  -1.78779000E-03  -1.28560000E-04
   -1.82320000E-04  +5.45680000E-04  -3.91320000E-04  -1.40210000E-04  +1.34260000E-04
   +5.32920000E-04  +3.82840000E-04  -2.88960000E-04  -1.69280000E-04  +1.25120000E-04
   +2.61720000E-04  -3.04100000E-05  -5.02600000E-05  -6.17500000E-05  +6.07100000E-04
   -1.27330000E-04  +1.24640000E-04  +2.66470000E-04  +2.37040000E-04  -3.78200000E-05
   -1.18130000E-04  +4.00630000E-04  -4.99700000E-05  -1.28198550E-01  +4.61306900E-01
   +1.34308010E-01  +2.48779700E-02  -1.95891990E-01  +2.67397700E-02  +1.43038600E-02
   -3.39355900E-02  -3.94345000E-03  +4.10446000E-03  +3.31725000E-03  +4.14549000E-03
   -7.81350000E-04  -4.14976000E-03  -1.87006000E-03  +4.09180000E-03  +3.53688000E-03
   +2.61620000E-03  -4.54294000E-03  +5.60420000E-04  -6.06450000E-04  +1.14449000E-03
   -1.09128000E-03  +1.07642000E-03  -1.39560000E-03  +2.06230000E-04  -1.92845000E-03
   +1.90581000E-03  -1.21888000E-03  -2.48000000E-05  +1.58140000E-04  -5.49540000E-04
   -1.70100000E-04  +1.00980000E-04  +4.80620000E-04  +2.08670000E-04  +6.38900000E-05
   -1.09050000E-04  -3.03560000E-04  -3.98160000E-04  +3.20420000E-04  -2.13180000E-04
   -3.45970000E-04  -5.22800000E-04  -5.10220000E-04  -3.81740000E-04  +8.61800000E-05
   -2.89830000E-04  -2.36800000E-05  +5.18500000E-04  -1.18700850E-01  -2.58075450E-01
   +3.66922490E-01  -7.69700000E-05  -8.35000000E-06  +3.82200000E-05  +2.47000000E-06
   +4.28900000E-05  -9.65000000E-06  -2.29800000E-05  +6.12000000E-06  +5.09200000E-05
   +2.57700000E-05  -2.15800000E-05  +2.21200000E-05  -1.12760000E-04  +7.27900000E-05
   +3.19000000E-06  -1.68050000E-04  +3.43900000E-05  +1.02460000E-04  +6.95800000E-05
   +2.21400000E-05  -2.43000000E-05  +1.23330000E-04  -7.85700000E-05  +7.20000000E-06
   -1.47320000E-04  +4.51460000E-04  +5.75160000E-04  -6.50380000E-04  -2.04640000E-04
   -2.11490000E-04  +1.52636000E-03  -9.25740000E-04  -2.29958000E-03  -6.46830000E-04
   -3.11180800E-02  -3.07446800E-02  -5.25086000E-03  -3.57104000E-03  +1.10856000E-03
   +1.49585000E-03  -8.40230000E-04  -6.98210000E-04  -4.54224200E-02  +4.89260700E-02
   +7.23365100E-02  +2.96100000E-05  -9.81000000E-06  -1.36800000E-05  +1.04780000E-04
   +3.34600000E-05  +3.80000000E-07  +5.03228800E-02  -2.21700000E-05  +1.97800000E-05
   -3.22400000E-05  +1.15800000E-05  +1.24140000E-04  +1.55400000E-05  -2.37000000E-05
   +3.10000000E-07  +6.11100000E-05  +3.70300000E-05  -6.71100000E-05  +3.07000000E-05
   -1.28220000E-04  +1.16700000E-04  -2.46400000E-05  -1.89780000E-04  -5.77000000E-05
   -3.11300000E-05  +7.39200000E-05  -8.21000000E-06  -2.36100000E-05  +1.57850000E-04
   -1.33740000E-04  +1.22500000E-05  -5.98400000E-05  +5.04550000E-04  +4.47050000E-04
   +8.15300000E-05  -9.90070000E-04  -3.46960000E-04  +3.61926000E-03  +3.30322000E-03
   +1.68738000E-03  +1.89302000E-03  -2.39400700E-02  -2.13155600E-02  -4.72809000E-03
   -7.35600000E-05  +9.06620000E-04  +5.12360000E-04  +1.45020000E-04  -1.77394000E-03
   +1.33528600E-02  -2.57125530E-01  -2.48902320E-01  +9.72700000E-05  +3.71100000E-05
   +3.78600000E-05  +4.23800000E-05  -5.34000000E-05  +7.80500000E-05  -1.38621900E-02
   +2.78055070E-01  -9.46900000E-05  -3.45300000E-05  +1.04040000E-04  -1.06700000E-05
   +6.16200000E-05  -2.23700000E-05  -2.06400000E-05  -5.32000000E-06  +1.36900000E-05
   +2.19700000E-05  -2.31000000E-05  -8.55000000E-06  -3.76100000E-05  +2.70900000E-05
   +6.21000000E-06  -1.10830000E-04  -2.38600000E-05  -1.49850000E-04  +2.72900000E-05
   -2.34000000E-06  -1.49200000E-05  +4.66200000E-05  -2.85100000E-05  -7.33000000E-06
   +9.15100000E-05  +1.05010000E-04  +2.04580000E-04  +5.59500000E-05  -1.93220000E-04
   -8.75610000E-04  +2.00078000E-03  +4.47831000E-03  +2.13683000E-03  +6.13920000E-04
   -8.61280000E-04  -3.85452000E-03  +1.75200000E-05  +1.84820000E-04  +2.17131000E-03
   +6.29170000E-04  -9.33990000E-04  +4.66730000E-04  +3.85165100E-02  -2.70949050E-01
   -2.84277650E-01  +1.19590000E-04  +7.18000000E-05  +5.38800000E-05  +1.16200000E-04
   +3.90800000E-05  -5.04200000E-05  -4.17060500E-02  +2.68415760E-01  +2.84520570E-01
   -1.87800000E-05  -3.19600000E-05  +3.68200000E-05  +1.08970000E-04  -3.87300000E-05
   +1.09500000E-05  +2.28900000E-05  +4.33000000E-06  -3.23000000E-05  -3.32000000E-05
   +6.75500000E-05  +9.50000000E-07  +3.53600000E-05  -5.84700000E-05  +2.13200000E-05
   +5.86460000E-04  -7.12030000E-04  -8.68000000E-04  -3.51200000E-04  -1.35420000E-04
   +1.09860000E-04  -6.75600000E-05  +7.34000000E-05  +2.22000000E-06  -2.54921000E-03
   -4.60540000E-03  +1.84041000E-03  +4.10202000E-03  -1.88873500E-02  -1.87630700E-02
   -5.60619100E-02  -8.81196000E-03  +5.70588000E-03  +4.35667000E-03  +1.74947200E-02
   +1.61477600E-02  -2.79474000E-03  -5.56310000E-04  +4.53338000E-03  -1.61113000E-03
   -3.30230000E-04  +1.26250000E-04  +2.00849000E-03  +2.46959000E-03  -1.27941000E-03
   -8.26000000E-06  +6.70000000E-05  -9.65800000E-05  +2.69000000E-06  +6.50900000E-05
   -2.47000000E-05  -8.65120000E-04  -1.07860000E-03  -1.59270000E-04  +5.29761800E-02
   +8.13000000E-05  +2.37600000E-05  -3.19200000E-05  +1.62570000E-04  -1.14570000E-04
   +2.62200000E-05  +1.34900000E-05  +3.04000000E-05  -2.90700000E-05  -2.90000000E-05
   +4.00900000E-05  +5.19000000E-06  +7.70800000E-05  -5.69300000E-05  -5.04000000E-06
   +3.15080000E-04  -1.65150000E-04  -8.32450000E-04  -3.07620000E-04  -1.87590000E-04
   +1.15830000E-04  -9.85500000E-05  +7.34900000E-05  +1.29000000E-06  -4.89799000E-03
   +2.26744000E-03  -1.71042000E-03  +2.06726000E-03  -1.03376300E-02  -1.31398300E-02
   -8.96037000E-03  -1.96750120E-01  -1.47835130E-01  -4.86149000E-03  -2.35284000E-03
   -3.02404000E-03  -4.36700000E-05  +3.25838000E-03  -2.04117000E-03  -4.88900000E-05
   -7.31200000E-05  +8.00210000E-04  +1.99532000E-03  +7.50330000E-04  +3.17531000E-03
   -6.26300000E-05  -8.63000000E-06  -4.27800000E-05  -7.15700000E-05  -1.65300000E-05
   -1.05700000E-05  +9.95280000E-04  +1.48220000E-04  -9.95600000E-04  +1.23957700E-02
   +2.05330620E-01  -7.16700000E-05  -7.35800000E-05  +8.84300000E-05  -7.71100000E-05
   -3.14400000E-05  -5.25000000E-06  +3.21400000E-05  -2.02900000E-05  -6.57700000E-05
   -2.68300000E-05  +5.67200000E-05  -2.88800000E-05  +5.08500000E-05  -7.40700000E-05
   +4.29600000E-05  +3.96780000E-04  -1.55520000E-04  +6.44600000E-05  -6.82100000E-05
   +3.39500000E-05  +3.35500000E-05  -7.92800000E-05  +8.05300000E-05  -1.07900000E-05
   +1.28714000E-03  -2.26489000E-03  +4.52767000E-03  +8.59710000E-04  -2.54730000E-04
   +1.55022000E-03  +5.55212000E-03  -1.47815790E-01  -1.74551830E-01  -4.68401000E-03
   -1.65819700E-02  -8.66067000E-03  +4.97757000E-03  -1.77455000E-03  +7.60990000E-04
   +3.61010000E-04  +9.67000000E-04  -2.17270000E-04  -1.81400000E-03  +2.83464000E-03
   -1.78310000E-04  -4.65400000E-05  +3.80000000E-06  -5.65600000E-05  +5.01300000E-05
   +9.55400000E-05  -5.51000000E-05  +1.78329000E-03  +2.53380000E-04  -2.66610000E-04
   -6.53860000E-03  +1.63085660E-01  +1.79546910E-01  -2.12720000E-04  -2.45100000E-04
   -3.82310000E-04  -7.77290000E-04  -9.91050000E-04  -8.61350000E-04  -3.95390000E-04
   -2.25800000E-04  -1.68150000E-04  -5.65200000E-05  +7.38400000E-05  +7.66800000E-05
   -2.11770000E-04  +1.50580000E-04  +8.02600000E-05  -9.61620000E-04  +3.57100000E-04
   -9.59480000E-04  -2.54200000E-05  +1.33520000E-04  -1.04550000E-04  +1.67410000E-04
   -1.43560000E-04  -2.02000000E-06  +4.05554000E-03  -2.80240000E-04  -2.81660000E-04
   -2.21341850E-01  +3.08103000E-02  +1.37542740E-01  -1.50368500E-02  +5.50224000E-03
   +1.64466500E-02  -6.02910000E-04  -5.00784000E-03  +2.73190000E-04  -6.30400000E-05
   -2.01130000E-04  -8.77820000E-04  +2.13129000E-03  -1.64421000E-03  +9.13690000E-04
   -1.42994000E-03  -4.21000000E-05  +7.73170000E-04  +9.56000000E-06  +2.52000000E-06
   +1.76120000E-04  -3.64100000E-05  +4.54100000E-05  +2.65350000E-04  +9.92100000E-05
   +2.14660000E-04  +1.32810000E-04  +7.94700000E-05  +1.12187000E-03  -1.53832000E-03
   +2.34067850E-01  +5.55400000E-05  +4.24870000E-04  -6.16460000E-04  -2.57940000E-04
   -8.13800000E-05  -9.52600000E-05  -2.73940000E-04  -5.67700000E-05  +1.38100000E-05
   -6.82800000E-05  +2.59200000E-05  +5.46100000E-05  -1.88020000E-04  +5.99100000E-05
   +9.62700000E-05  +1.50905000E-03  -8.43150000E-04  +1.28890000E-03  +1.17760000E-04
   +5.67300000E-05  +8.91900000E-05  +1.98550000E-04  -1.91640000E-04  +1.01300000E-05
   +1.89612200E-02  +1.96038000E-03  -1.36932300E-02  +3.10855300E-02  -6.02473600E-02
   -3.80226500E-02  -1.55652900E-02  +6.54286000E-03  +1.19833600E-02  -4.72080000E-03
   +9.78250000E-04  -3.55413000E-03  -2.93760000E-04  -1.11234000E-03  +2.59200000E-04
   -2.18421000E-03  -9.45270000E-04  -5.75715000E-03  -9.77870000E-04  +4.97900000E-05
   +6.32390000E-04  -1.83420000E-04  -4.75370000E-04  -4.05990000E-04  -3.06680000E-04
   -2.27680000E-04  +3.40620000E-04  +6.91100000E-05  +1.07070000E-04  +1.00400000E-04
   +1.57084000E-03  -1.17223000E-03  +2.09998000E-03  -2.98015000E-02  +5.58916300E-02
   +1.48560000E-04  +3.64540000E-04  -5.97740000E-04  -4.39900000E-05  -3.10800000E-04
   +2.34640000E-04  -4.26240000E-04  +2.76500000E-04  +4.43640000E-04  -3.53000000E-06
   -1.29380000E-04  +1.00090000E-04  -3.23830000E-04  +1.28150000E-04  -1.78900000E-05
   +1.29000000E-04  +1.92127000E-03  -1.45013000E-03  -2.57540000E-04  +6.83000000E-06
   -1.68700000E-05  +3.35560000E-04  -2.23010000E-04  +2.59300000E-05  +1.73946200E-02
   -2.40018000E-03  -8.05094000E-03  +1.36799560E-01  -3.73367900E-02  -1.54699360E-01
   -2.74592000E-03  -7.39850000E-04  +4.61002000E-03  +6.28200000E-04  -3.22196000E-03
   +4.56078000E-03  -1.10038000E-03  +1.08190000E-04  -4.60890000E-04  +8.96880000E-04
   -6.15954000E-03  +3.42830000E-04  +6.00500000E-05  +9.96600000E-05  +8.66300000E-05
   -1.44300000E-05  +3.43400000E-05  -2.23000000E-06  -2.20260000E-04  +2.73000000E-06
   +2.83700000E-04  -3.50600000E-05  -6.74000000E-06  -2.94900000E-05  -1.26051000E-03
   +2.37420000E-03  -1.51787000E-03  -1.50808520E-01  +4.45871800E-02  +1.57233690E-01
   -9.12900000E-05  -2.74200000E-05  +2.28970000E-04  -1.41510000E-04  -9.20300000E-05
   -2.47120000E-04  -3.24700000E-05  -4.09400000E-05  -1.18100000E-05  +6.76900000E-05
   -3.31000000E-05  +8.01000000E-06  -5.30900000E-05  +5.89500000E-05  -4.10000000E-07
   +2.30360000E-04  +1.39324000E-03  -1.03641000E-03  -1.77155000E-03  -8.16390000E-04
   +6.30570000E-04  +8.05000000E-05  -6.80300000E-05  -8.09000000E-06  +6.31613000E-03
   +1.76916100E-02  +1.60410100E-02  -2.91420000E-03  -7.35320000E-04  +5.06903000E-03
   -1.35464000E-03  -1.93160000E-04  -9.49000000E-06  -2.19143000E-03  -4.51280000E-03
   +2.03745000E-03  +3.27256000E-03  -1.94308200E-02  -1.82418700E-02  -5.63443800E-02
   -6.77263000E-03  +3.93555000E-03  +1.18050000E-04  -9.79070000E-04  -9.57010000E-04
   +2.42100000E-04  -1.57000000E-05  -7.62300000E-05  +1.35310000E-04  -1.69350000E-04
   -1.33290000E-04  -3.21270000E-04  -2.09750000E-04  -1.10840000E-04  -5.39900000E-05
   +2.05590000E-04  -2.17040000E-04  +1.47840000E-04  +1.05845000E-03  +9.19220000E-04
   +5.63194800E-02  +2.55540000E-04  +1.59880000E-04  -4.24060000E-04  +3.12410000E-04
   +3.27030000E-04  -1.38170000E-04  +7.11400000E-05  -7.06400000E-05  +6.48700000E-05
   +8.42000000E-06  -4.81000000E-05  +2.26100000E-05  -2.64100000E-05  +6.07700000E-05
   -5.98700000E-05  +5.56520000E-04  -2.14111000E-03  +1.26014000E-03  -2.11517000E-03
   -5.63930000E-04  +2.17090000E-04  +4.89900000E-05  -4.68100000E-05  +2.85100000E-05
   -4.18960000E-04  +7.04270000E-04  -3.53851000E-03  -6.60690000E-04  +3.42850000E-03
   -2.77556000E-03  -7.15000000E-06  -8.19100000E-05  +9.38060000E-04  -4.68763000E-03
   +2.83571000E-03  -2.19729000E-03  +1.09304000E-03  -9.59024000E-03  -1.36574900E-02
   -6.35318000E-03  -1.97670460E-01  -1.49392680E-01  -1.21460000E-04  -8.45490000E-04
   -7.98780000E-04  -4.06410000E-04  -2.12870000E-04  +4.72200000E-05  -3.72110000E-04
   -2.52400000E-05  +3.57770000E-04  -1.35150000E-04  -2.01390000E-04  +6.81500000E-05
   +1.81420000E-04  -3.50660000E-04  +2.66480000E-04  -1.01680000E-04  -1.40730000E-04
   -1.31100000E-05  +1.33208300E-02  +2.06935200E-01  -1.16200000E-04  -7.09700000E-05
   +1.11040000E-04  -1.99930000E-04  -7.40900000E-05  +1.42250000E-04  -3.85600000E-05
   +5.93200000E-05  -1.27100000E-05  -6.51000000E-06  +3.38900000E-05  -6.19000000E-06
   +1.02400000E-05  -3.26500000E-05  +1.00200000E-05  -2.03249000E-03  +5.14810000E-04
   -1.93241000E-03  -5.59790000E-04  -9.31280000E-04  +4.46720000E-04  -3.22000000E-05
   +4.03800000E-05  -4.95000000E-06  -1.80626000E-03  -1.44685800E-02  -8.46712000E-03
   +5.09960000E-03  -2.37787000E-03  +1.16534000E-03  +7.28100000E-05  +9.51050000E-04
   -1.83060000E-04  +1.96071000E-03  -2.23884000E-03  +4.59627000E-03  +1.63203000E-03
   -6.74950000E-04  +2.36680000E-03  +4.40720000E-03  -1.50072390E-01  -1.87146470E-01
   -1.48330000E-04  -2.33310000E-04  -7.60700000E-05  +6.65860000E-04  +1.95980000E-04
   +1.84300000E-05  +2.21700000E-04  +5.85700000E-05  -3.94100000E-05  -3.33200000E-05
   +1.19210000E-04  -5.55500000E-05  -2.49710000E-04  +2.33650000E-04  -3.50540000E-04
   -1.36710000E-04  -7.28760000E-04  -6.09210000E-04  -5.92419000E-03  +1.66431030E-01
   +1.91208190E-01  -6.12300000E-05  -3.96100000E-05  +1.66280000E-04  -4.45800000E-05
   -2.25240000E-04  +3.32900000E-05  -3.97800000E-05  +5.44100000E-05  -4.59400000E-05
   -1.89200000E-05  +4.14300000E-05  -5.99000000E-06  +5.72700000E-05  -6.24000000E-05
   +1.59100000E-05  -2.30190000E-04  +5.60640000E-04  +7.72400000E-04  -2.43900000E-05
   +8.89900000E-05  +5.16100000E-05  -8.02300000E-05  +6.56500000E-05  -1.51100000E-05
   -1.13793000E-03  -5.09870000E-03  +4.72440000E-04  -6.16000000E-05  -2.70090000E-04
   -8.86860000E-04  +1.94128000E-03  -1.53771000E-03  +8.11110000E-04  +2.92257000E-03
   -2.45504000E-03  -9.24180000E-04  -2.25248510E-01  +2.65041600E-02  +1.42557940E-01
   -1.40638800E-02  +5.79344000E-03  +1.57444300E-02  +2.29590000E-04  +1.34716000E-03
   -1.06025000E-03  -1.78850000E-04  -6.27100000E-05  -8.78400000E-05  +7.90100000E-05
   +5.65800000E-05  -1.96600000E-04  -7.32000000E-05  +1.74710000E-04  -1.37910000E-04
   +1.90620000E-04  -3.62900000E-05  -1.62760000E-04  -1.54730000E-04  +2.21340000E-04
   -1.25770000E-04  -1.49200000E-05  +1.23924000E-03  -1.60906000E-03  +2.36043840E-01
   -3.36100000E-05  +4.03000000E-06  -4.87000000E-06  -2.13900000E-04  -2.27570000E-04
   +3.56200000E-05  +8.30000000E-07  +1.32600000E-05  -3.76700000E-05  -2.89800000E-05
   +5.65600000E-05  +7.87000000E-06  +1.49900000E-05  -3.94700000E-05  +3.29100000E-05
   -5.19530000E-04  +4.77330000E-04  +3.45280000E-04  +5.62400000E-05  +5.18400000E-05
   +6.16900000E-05  -4.08500000E-05  +3.13300000E-05  -2.92000000E-06  -4.65674000E-03
   +9.57170000E-04  -3.06028000E-03  -4.71730000E-04  -1.31629000E-03  +6.84700000E-05
   -2.00648000E-03  -1.21971000E-03  -5.19161000E-03  +1.92688600E-02  +2.33847000E-03
   -1.46606700E-02  +2.53594200E-02  -5.63589000E-02  -3.58801300E-02  -1.45494600E-02
   +6.50497000E-03  +1.27781300E-02  +1.12256000E-03  -3.67000000E-05  +2.65338000E-03
   -5.41800000E-05  +3.89400000E-05  -4.90700000E-05  -6.20000000E-07  -1.76200000E-05
   +2.13000000E-05  +1.10920000E-04  +2.25200000E-05  +4.84500000E-04  +9.71160000E-04
   -1.69890000E-04  -7.18690000E-04  +1.83470000E-04  -2.14460000E-04  +3.27980000E-04
   +1.64648000E-03  -1.25996000E-03  +2.11358000E-03  -2.62083200E-02  +5.04073100E-02
   -1.06800000E-05  -7.24000000E-06  +5.51800000E-05  +1.09570000E-04  +5.99800000E-05
   -1.37200000E-05  -2.02500000E-05  +1.45600000E-05  +3.14900000E-05  +2.05300000E-05
   -2.76100000E-05  +4.79000000E-06  -2.48400000E-05  +2.88600000E-05  -1.79400000E-05
   -1.11900000E-04  -1.03450000E-04  +2.81110000E-04  +1.09800000E-05  +4.88200000E-05
   -4.23800000E-05  +3.74100000E-05  -2.47100000E-05  +1.26000000E-06  +4.60020000E-04
   -2.85053000E-03  +4.27324000E-03  -1.16975000E-03  -1.44490000E-04  -4.95800000E-04
   +4.21310000E-04  -5.46882000E-03  +1.48160000E-04  +1.96492900E-02  -1.07470000E-03
   -7.91713000E-03  +1.41494220E-01  -3.67432400E-02  -1.57269290E-01  -3.41545000E-03
   +1.54980000E-04  +4.78819000E-03  -1.31533000E-03  +2.47324000E-03  -4.17300000E-04
   -2.05000000E-06  -5.22400000E-05  -7.66000000E-06  +4.17100000E-05  +6.00000000E-06
   -5.33200000E-05  -1.97230000E-04  +4.44730000E-04  -1.34400000E-05  +7.94630000E-04
   -1.15530000E-04  -6.04040000E-04  -1.32210000E-04  +3.12720000E-04  -3.22490000E-04
   -1.21447000E-03  +2.44907000E-03  -1.46138000E-03  -1.55420780E-01  +4.06906400E-02
   +1.59078720E-01  -2.31520000E-04  -3.23100000E-05  +5.45650000E-04  +7.42250000E-04
   -5.51700000E-05  -1.65620000E-04  -9.47700000E-05  -1.03280000E-04  +4.64470000E-04
   +1.18360000E-04  +1.97510000E-04  -2.62270000E-04  +9.92700000E-05  -1.13680000E-04
   +1.80200000E-05  -2.89236000E-03  +5.42580000E-04  +7.71900000E-04  -7.85500000E-05
   -1.82200000E-04  +5.66910000E-04  -1.89320000E-04  +1.74290000E-04  -5.79000000E-05
   +8.14220000E-04  -1.44217000E-03  +2.70800000E-05  +3.38260000E-04  +3.02620000E-04
   +2.42250000E-04  -2.62720000E-04  -2.70100000E-05  -2.01000000E-05  +6.30200000E-05
   -1.03140000E-04  -1.90680000E-04  +1.34440000E-04  +1.38050000E-04  -1.72600000E-05
   +1.51260000E-04  +6.62800000E-05  +1.76740000E-04  +3.59800000E-05  +1.32000000E-05
   +2.94400000E-05  -2.47294020E-01  +1.18310380E-01  +1.46900200E-02  +2.54990000E-04
   +5.21800000E-05  -2.95820000E-04  -8.26000000E-06  +3.19000000E-06  -4.64000000E-06
   -5.15000000E-06  +1.29200000E-05  -2.35000000E-06  +2.64600000E-05  -5.98400000E-05
   +2.29600000E-05  +3.06300000E-05  +3.95700000E-05  -1.89100000E-05  +2.33800000E-05
   +1.37500000E-05  +7.00000000E-06  +2.65539260E-01  +1.49575000E-03  -9.61700000E-05
   -6.07400000E-04  -6.20500000E-04  -1.75463000E-03  +3.64441000E-03  -4.74030000E-04
   +1.86270000E-04  +5.86110000E-04  +1.53040000E-04  +5.58500000E-05  -1.71100000E-05
   -2.13740000E-04  +1.43660000E-04  +2.47000000E-06  +1.70486100E-02  -1.24252900E-02
   -8.83540000E-04  -3.90920000E-04  +3.27680000E-04  -1.34271000E-03  +2.19940000E-04
   -1.79640000E-04  -5.94000000E-06  +1.24240000E-03  +6.10830000E-04  -1.44960000E-04
   -1.85880000E-04  -4.06230000E-04  -5.80600000E-04  +2.27240000E-04  +7.03100000E-05
   -6.11200000E-05  -2.80460000E-04  -4.38400000E-05  +2.03380000E-04  -2.75610000E-04
   -1.27920000E-04  +3.07000000E-06  -2.20770000E-04  +1.77450000E-04  -6.54000000E-06
   +2.06550000E-04  +1.79630000E-04  +6.06000000E-06  +1.16371140E-01  -1.15117070E-01
   -9.56988000E-03  -2.85650000E-04  -2.99000000E-05  +2.22980000E-04  -8.19000000E-06
   -3.86700000E-05  -7.98000000E-06  +1.33900000E-05  -9.50000000E-07  +1.41000000E-05
   +9.18000000E-06  +1.40590000E-04  +1.33960000E-04  +3.22500000E-05  -2.46200000E-05
   +9.07600000E-05  +5.43000000E-06  -1.26200000E-05  -2.70000000E-07  -1.28686770E-01
   +1.24646880E-01  -1.43133000E-03  +7.40580000E-04  +6.31730000E-04  +6.53440000E-04
   +2.74218000E-03  -4.31115000E-03  +9.80210000E-04  +2.01240000E-04  -6.84760000E-04
   -1.99390000E-04  +1.01000000E-06  +3.17480000E-04  +9.16900000E-05  -1.35260000E-04
   +2.33000000E-06  -2.22508100E-02  +1.38981400E-02  -6.41370000E-04  -1.29850000E-03
   +9.39110000E-04  +1.18293000E-03  -1.00680000E-04  +3.10200000E-05  +3.29100000E-05
   -8.46410000E-04  -3.79610000E-04  +4.46510000E-04  +4.19770000E-04  +8.16200000E-05
   -6.46200000E-05  -4.36590000E-04  -3.24400000E-05  +8.07000000E-05  +2.06760000E-04
   -6.64400000E-05  -2.42420000E-04  +1.95360000E-04  +1.49000000E-04  -2.49000000E-06
   -1.70420000E-04  -1.06630000E-04  +2.30410000E-04  -1.73230000E-04  -1.17960000E-04
   -1.81000000E-06  +1.64234600E-02  -1.08513300E-02  -4.71289300E-02  +8.10200000E-05
   -7.79200000E-05  -9.92000000E-06  +1.57000000E-05  +1.14500000E-05  +1.64400000E-05
   +1.07400000E-05  -1.67600000E-05  +2.06000000E-06  +1.40500000E-05  +5.05000000E-06
   +6.47300000E-05  +3.28400000E-05  -1.16500000E-05  -1.16150000E-04  -4.10000000E-07
   +7.39000000E-06  +1.42700000E-05  -1.69918500E-02  +7.07610000E-03  +5.28844300E-02
   +1.14880000E-04  -1.86960000E-04  -7.45400000E-05  +1.20040000E-04  +7.27100000E-05
   +2.14750000E-04  -5.13930000E-04  +8.84240000E-04  +6.67060000E-04  +1.27120000E-04
   +9.32600000E-05  -1.78220000E-04  -1.34870000E-04  +1.70900000E-05  -2.25200000E-05
   +1.44367000E-03  +2.40999000E-03  -4.51240000E-04  +3.00890000E-04  +3.36710000E-04
   -2.25160000E-04  +7.84800000E-05  -4.09200000E-05  -1.99300000E-05  +4.65600000E-04
   -7.18140000E-04  +2.55650000E-04  +3.09970000E-04  +4.38820000E-04  +5.13850000E-04
   -3.33290000E-04  -3.96900000E-05  +8.22300000E-05  +3.53430000E-04  +1.07220000E-04
   -1.37670000E-04  +7.33700000E-05  +1.04400000E-05  -1.87800000E-05  +5.01410000E-04
   -1.95370000E-04  -1.42310000E-04  -3.11690000E-04  -2.27350000E-04  -1.24200000E-05
   -1.98418500E-01  -1.31018000E-01  +2.74081000E-03  +8.02700000E-05  +6.54500000E-05
   +4.84900000E-05  +2.50300000E-05  +4.48100000E-05  +1.69500000E-05  -3.05100000E-05
   -1.49600000E-05  -2.38100000E-05  -1.22000000E-06  -2.85600000E-05  -1.49000000E-05
   -5.79200000E-05  +6.84700000E-05  -1.00800000E-05  -1.82600000E-05  -4.16000000E-06
   +7.23000000E-06  -1.90534100E-02  -1.87509700E-02  -2.45200000E-04  +2.14952770E-01
   -8.92100000E-05  -1.48940000E-04  +5.22430000E-04  -7.42420000E-04  +6.46290000E-04
   -3.26520000E-04  -7.31500000E-05  -4.18450000E-04  +8.58700000E-04  +2.71850000E-04
   +2.57570000E-04  -4.23320000E-04  +1.57400000E-05  -5.93400000E-05  -4.61600000E-05
   -1.50132200E-02  -1.27571300E-02  -8.55070000E-04  -2.16400000E-05  +5.24270000E-04
   -1.53030000E-03  -1.05500000E-04  +1.53390000E-04  -6.81600000E-05  +3.55590000E-04
   -1.56627000E-03  +3.89215000E-03  -4.10980000E-04  -1.61240000E-04  +3.01110000E-04
   +2.53100000E-04  +2.05330000E-04  -4.10000000E-07  +1.66930000E-04  +5.64630000E-04
   +4.85130000E-04  -6.24100000E-04  -4.15030000E-04  -4.46800000E-04  +5.45560000E-04
   -3.75360000E-04  -3.41980000E-04  -5.32570000E-04  -4.36880000E-04  -1.01410000E-04
   -1.29766100E-01  -1.60174540E-01  +2.40037000E-03  +3.22760000E-04  +1.57280000E-04
   -3.74320000E-04  +2.72000000E-05  +5.14600000E-05  +4.35300000E-05  -2.32800000E-05
   -5.52700000E-05  -2.54400000E-05  -3.59100000E-05  +1.33900000E-04  -1.17230000E-04
   +3.98700000E-05  -4.90300000E-05  +1.66670000E-04  -8.98500000E-05  -3.66000000E-06
   -3.59000000E-05  +1.26349300E-02  +1.19793300E-02  -2.08640000E-04  +1.43179100E-01
   +1.72738130E-01  +2.40400000E-05  -2.60000000E-07  -3.11390000E-04  +2.95260000E-04
   -7.55340000E-04  +5.90630000E-04  -2.86750000E-04  -2.99050000E-04  +5.18840000E-04
   -9.34200000E-05  +1.28050000E-04  -1.26620000E-04  -1.00440000E-04  -2.33000000E-05
   +1.51950000E-04  +2.01360000E-02  +1.62387300E-02  -1.45361000E-03  +1.04066000E-03
   +7.98730000E-04  +1.30858000E-03  +4.43300000E-05  -1.51400000E-05  -2.71600000E-05
   -1.35812000E-03  +2.36063000E-03  -3.56331000E-03  +3.43600000E-05  -3.26680000E-04
   +4.73000000E-06  +7.05800000E-04  -4.81800000E-05  +7.41400000E-05  -4.41110000E-04
   -5.45000000E-06  +2.27090000E-04  +5.36500000E-05  -2.71530000E-04  +2.32350000E-04
   +6.01020000E-04  +5.30330000E-04  +1.15000000E-04  +4.46350000E-04  +3.66560000E-04
   +1.05700000E-05  +2.61350000E-03  +1.30546000E-03  -4.86687900E-02  -4.65300000E-05
   -6.92200000E-05  +3.04100000E-05  -5.20000000E-06  -3.36100000E-05  -4.46100000E-05
   +3.77300000E-05  +3.20700000E-05  +2.10200000E-05  -2.39910000E-04  +3.51670000E-04
   -9.96300000E-05  -1.63500000E-05  +9.79900000E-05  -1.58510000E-04  +5.54200000E-05
   +2.94800000E-05  -1.42800000E-05  +1.80456000E-03  +1.65837000E-03  -1.01021000E-03
   -3.45270000E-03  -4.63197000E-03  +5.08338100E-02  +1.85560000E-04  +1.21310000E-04
   -2.22260000E-04  +3.03840000E-04  -4.98070000E-04  -2.09010000E-04  -3.77210000E-04
   +4.35940000E-04  -7.72840000E-04  -4.88700000E-05  -7.79800000E-05  +2.76920000E-04
   -4.66900000E-05  +5.37200000E-05  -1.03400000E-05  -1.81813000E-03  -1.54563000E-03
   -2.00760000E-03  -4.38500000E-05  +4.95150000E-04  -3.73420000E-04  +1.05720000E-04
   -1.20190000E-04  +4.66600000E-05  -1.62400000E-05  +5.66700000E-04  +6.91370000E-04
   +5.86000000E-06  -1.85130000E-04  -6.82200000E-05  -2.45670000E-04  -3.86400000E-05
   -4.97200000E-05  -1.97800000E-05  -1.19130000E-04  -6.99700000E-05  +9.78300000E-05
   +7.25100000E-05  +5.58000000E-05  -1.82740000E-04  -5.29900000E-05  +9.86400000E-05
   +5.81200000E-05  +5.42000000E-05  -2.98000000E-06  -4.69315200E-02  -1.70403000E-03
   -1.76884000E-03  -2.02750000E-04  -1.11660000E-04  +2.35490000E-04  -7.96000000E-06
   -2.26800000E-05  +7.64000000E-06  +2.18400000E-05  -1.27800000E-05  +2.02300000E-05
   +1.82370000E-04  -9.85600000E-05  +9.40000000E-05  +3.10600000E-05  +6.98000000E-06
   -7.05200000E-05  +5.50000000E-07  +8.11000000E-06  -8.99000000E-06  +9.41450000E-04
   +1.41601800E-02  +2.44311300E-02  +2.21570000E-04  -1.18375000E-02  -2.14688800E-02
   +4.85498500E-02  -2.61010000E-04  -1.24680000E-04  +8.03900000E-05  -1.00010000E-04
   +8.68650000E-04  -5.14990000E-04  +9.24030000E-04  +2.75400000E-04  -2.46910000E-04
   +5.15000000E-06  -1.55070000E-04  +2.00670000E-04  +9.17700000E-05  -2.78500000E-05
   -1.51800000E-04  -6.01010000E-04  +1.02510900E-02  +1.69150100E-02  +1.95070000E-04
   -2.02707000E-03  +2.78464000E-03  -6.46800000E-05  +9.79000000E-06  +3.12500000E-05
   +5.01990000E-04  +1.05097000E-03  +2.88230000E-04  -3.82950000E-04  -7.04800000E-05
   +5.78720000E-04  -1.92200000E-05  -1.63160000E-04  -1.03200000E-04  +3.10000000E-06
   -1.15990000E-04  -1.53600000E-04  +1.20530000E-04  +1.41220000E-04  +1.32600000E-04
   -1.58210000E-04  -3.42800000E-05  -5.04200000E-05  +1.60840000E-04  +1.05330000E-04
   +1.86900000E-05  -2.06257000E-03  -1.21465880E-01  -1.20979000E-01  -1.52500000E-05
   +2.55300000E-05  -4.24400000E-05  -1.83400000E-05  -1.35700000E-05  -1.54100000E-05
   -1.28000000E-06  +8.06000000E-06  +2.14500000E-05  +6.80000000E-05  -6.13330000E-04
   +1.06860000E-04  +1.80200000E-05  -1.17200000E-05  +9.48000000E-06  +8.81000000E-06
   -9.60000000E-07  -2.33000000E-06  -1.39519000E-03  -8.56875000E-03  -1.31121300E-02
   +1.80190000E-03  -1.03036600E-02  -1.68432800E-02  +6.27180000E-04  +1.30242640E-01
   +1.03520000E-04  +4.18500000E-04  -3.31130000E-04  +9.77430000E-04  -9.10400000E-04
   +8.08360000E-04  +5.70870000E-04  +2.94190000E-04  -2.80100000E-05  -2.70650000E-04
   +1.07010000E-04  +3.24170000E-04  -5.94800000E-05  -1.55980000E-04  +1.28070000E-04
   +3.50650000E-04  -1.44123800E-02  -2.06940800E-02  -6.05600000E-05  +4.91433000E-03
   -4.18153000E-03  -1.12800000E-05  -2.82100000E-05  +2.81600000E-05  -1.62045000E-03
   -9.31080000E-04  +7.83480000E-04  +9.50400000E-05  -6.37900000E-04  +3.04600000E-05
   +6.62870000E-04  +3.44050000E-04  +1.70570000E-04  -2.71250000E-04  +4.19500000E-04
   +4.96080000E-04  -4.78400000E-04  -4.59690000E-04  -1.79700000E-04  +9.49560000E-04
   +1.08520000E-04  -2.86840000E-04  -6.55600000E-05  -4.14600000E-05  -2.91900000E-05
   -1.47649000E-03  -1.18589570E-01  -2.41956340E-01  -1.16200000E-04  +7.72900000E-05
   +3.22580000E-04  +2.04000000E-05  +1.44600000E-05  -8.30000000E-07  +3.95400000E-05
   +5.16000000E-06  -3.61000000E-06  -2.09820000E-04  +4.92710000E-04  +1.00370000E-04
   -1.38000000E-04  +1.38700000E-05  +9.24900000E-05  -5.55000000E-06  +1.40600000E-05
   -2.13400000E-05  -2.05590000E-04  -3.49690000E-04  -1.04137000E-03  +1.24470000E-04
   +1.47758000E-03  +1.75374000E-03  +1.66309000E-03  +1.29271590E-01  +2.64219800E-01
   -5.97080000E-04  +3.50020000E-04  +9.77980000E-04  +1.10760000E-04  -4.22640000E-04
   +2.38960000E-04  -2.03360000E-04  +4.67700000E-05  +4.18600000E-05  +1.63030000E-04
   -6.47600000E-05  -7.01000000E-06  -5.60500000E-05  +8.66600000E-05  -2.78000000E-05
   -1.70368000E-03  +5.50120000E-04  -1.10700000E-03  -4.87896700E-02  -2.52582000E-03
   +4.57224000E-03  +5.61200000E-05  -4.86900000E-05  -2.50800000E-05  +2.53390000E-04
   +5.16270000E-04  -3.73350000E-04  -9.07800000E-05  -7.84400000E-05  -6.30600000E-05
   +1.42430000E-04  +1.12220000E-04  +1.97200000E-05  -9.58300000E-05  -1.02000000E-06
   +4.07800000E-05  -1.24840000E-04  +1.62900000E-05  +2.33340000E-04  +1.02080000E-04
   -4.21450000E-04  -5.79560000E-04  +1.02160000E-04  +1.13120000E-04  +3.55200000E-05
   -5.12700000E-05  -2.92420000E-04  -4.91850000E-04  +6.78000000E-05  +2.36810000E-04
   -5.10980000E-04  -8.80000000E-06  -1.04500000E-05  -4.78000000E-06  +1.35400000E-05
   +1.11000000E-05  +1.70600000E-05  -1.34900000E-05  +4.95100000E-05  +4.68800000E-05
   -1.07315000E-03  +3.14690000E-04  -3.25880000E-04  -9.18000000E-06  -1.17000000E-06
   -2.27200000E-05  +3.38330000E-04  -2.92240000E-04  +2.82990000E-04  +1.49060000E-04
   +3.24090000E-04  -2.07330000E-04  +6.79960000E-04  +1.02980000E-04  -1.67370000E-04
   +4.90014100E-02  +1.49449000E-03  +2.78220000E-04  -1.72222000E-03  -6.07060000E-04
   +7.31430000E-04  +6.43030000E-04  +2.36810000E-04  -1.39400000E-05  -3.28300000E-05
   -1.94210000E-04  +6.21100000E-05  +5.26000000E-05  +8.28200000E-05  -8.76900000E-05
   -9.35000000E-06  +3.84190000E-04  +1.15988200E-02  -1.67547800E-02  -2.30075000E-03
   -1.28643440E-01  +1.27796590E-01  -1.43410000E-04  +7.73400000E-05  +2.79300000E-05
   +1.55160000E-04  +8.51860000E-04  +3.14190000E-04  +2.07150000E-04  -1.41330000E-04
   +1.13700000E-05  +1.37460000E-04  +3.56500000E-05  -4.48200000E-05  -1.32110000E-04
   +2.87900000E-05  +1.65610000E-04  -1.50100000E-05  -2.26210000E-04  -1.42780000E-04
   -5.37820000E-04  +3.57050000E-04  +1.44680000E-04  +6.23100000E-05  +7.94000000E-06
   -2.63900000E-05  -1.79750000E-04  -2.16820000E-03  -2.95452000E-03  +1.81110000E-04
   -2.92213000E-03  +7.08860000E-04  -1.36800000E-05  -6.54000000E-06  -8.67000000E-06
   +6.10000000E-06  +1.70800000E-05  -1.22000000E-05  -1.83900000E-05  +1.98600000E-05
   -4.26300000E-05  -1.26150000E-04  -1.45240000E-04  -2.18440000E-04  -1.13200000E-05
   +3.17400000E-05  -2.15200000E-05  -2.44040000E-04  -2.49000000E-05  -9.94900000E-05
   +2.37280000E-04  -8.87000000E-06  -9.67900000E-05  -1.28270000E-04  +8.26100000E-04
   -1.14970000E-03  +2.83030000E-03  +1.38730410E-01  +1.42421000E-03  -1.54180000E-04
   -1.49206000E-03  -6.75010000E-04  +4.24930000E-04  +7.15400000E-04  +3.99480000E-04
   -2.45000000E-06  -1.19940000E-04  -1.96660000E-04  +8.92900000E-05  +3.56400000E-05
   -1.61000000E-06  -4.94900000E-05  +6.47100000E-05  +1.26670000E-04  +1.49116600E-02
   -2.06124300E-02  +4.77173000E-03  +1.23317650E-01  -2.40878150E-01  -1.72400000E-05
   +4.50000000E-06  +5.12100000E-05  +8.01990000E-04  +1.08304000E-03  +9.67800000E-04
   -2.53900000E-05  -4.51590000E-04  -2.54400000E-05  +2.17550000E-04  +1.65330000E-04
   -1.99000000E-06  -9.90700000E-05  +1.53780000E-04  +1.40630000E-04  -2.58860000E-04
   -1.14960000E-04  +1.77560000E-04  +1.70620000E-04  -2.87920000E-04  -9.60400000E-05
   +1.83000000E-06  +8.19000000E-06  +1.46100000E-05  +1.07330000E-04  -4.56659000E-03
   -4.06781000E-03  -8.78770000E-04  +1.93613000E-03  +5.83620000E-04  -6.22000000E-06
   +5.98000000E-06  -7.76000000E-06  -1.72400000E-05  +2.36400000E-05  -2.79600000E-05
   -2.33600000E-05  +8.38200000E-05  +2.54300000E-05  -5.27940000E-04  +2.02510000E-04
   +5.88200000E-05  -2.02300000E-05  -2.14700000E-05  -1.01100000E-05  -1.59000000E-05
   -9.35700000E-05  +2.44620000E-04  +9.18600000E-05  -8.69600000E-05  +3.20990000E-04
   -1.63320000E-04  +1.00264000E-03  -1.50117000E-03  -4.67556000E-03  -1.35353810E-01
   +2.62486170E-01  +2.69100000E-05  -1.58870000E-04  +3.31440000E-04  +7.62060000E-04
   +1.41043000E-03  +2.63220000E-04  +3.77370000E-04  -2.11950000E-04  +1.85000000E-06
   +2.64000000E-06  -1.24000000E-06  -1.11530000E-04  -4.54900000E-05  +1.16600000E-05
   +6.78000000E-06  -1.55759000E-03  +4.43280000E-04  +1.03260000E-03  -2.40027310E-01
   -1.21638950E-01  +5.05197000E-03  +4.97100000E-05  -2.40000000E-05  -5.00000000E-07
   +6.37640000E-04  +1.13330000E-04  +8.71700000E-05  +4.78900000E-05  +1.72930000E-04
   +2.45140000E-04  -8.16300000E-05  -9.06700000E-05  -1.01560000E-04  +1.09850000E-04
   +8.66600000E-05  -1.44500000E-05  +1.88200000E-04  -1.62480000E-04  -2.62240000E-04
   -2.67990000E-04  +1.78520000E-04  +4.69890000E-04  -1.76140000E-04  -1.77950000E-04
   -5.31000000E-05  -1.62790000E-04  +1.53740000E-04  +3.35510000E-04  +5.74000000E-05
   +3.43000000E-06  -1.88500000E-04  +1.72000000E-05  +2.10800000E-05  +9.69000000E-06
   -2.93600000E-05  -1.48000000E-05  -2.25500000E-05  +8.57400000E-05  -6.26200000E-05
   -5.08500000E-05  +2.59740000E-04  -1.86100000E-04  -5.08260000E-04  -8.76000000E-06
   -1.76000000E-06  +1.98600000E-05  +2.37200000E-05  -1.28640000E-04  +5.38500000E-05
   +2.83070000E-04  +2.70100000E-04  -5.13420000E-04  +2.83520000E-04  +2.42730000E-04
   -4.37400000E-05  +5.63460000E-04  +1.11835000E-03  +2.83200000E-05  +2.58289640E-01
   -3.74360000E-04  -2.73520000E-04  +7.63690000E-04  -1.14348000E-03  +5.13530000E-04
   +3.15260000E-04  +4.17740000E-04  +7.57900000E-05  -1.06050000E-04  +3.18700000E-05
   +5.91900000E-05  -1.46210000E-04  +1.37260000E-04  -1.83330000E-04  -3.54000000E-06
   -1.64116300E-02  -1.25035800E-02  +1.85580000E-04  -1.20096980E-01  -1.21589630E-01
   +4.80501000E-03  -1.85850000E-04  +1.81070000E-04  -1.26000000E-05  +1.25355000E-03
   -1.36747000E-03  -3.65234000E-03  -1.22273000E-03  -1.80920000E-04  +1.72150000E-04
   -5.31000000E-05  -3.45430000E-04  -1.09930000E-04  +3.10740000E-04  +9.03900000E-05
   -9.10100000E-05  -8.74600000E-05  +1.51920000E-04  +6.77600000E-05  +5.52980000E-04
   +6.72700000E-05  -4.46010000E-04  -2.74940000E-04  -1.77090000E-04  +6.26000000E-06
   +3.58840000E-04  +2.55870000E-04  +1.15808000E-03  +4.60090000E-04  -2.47770000E-04
   -2.56530000E-04  +3.42300000E-05  +3.52700000E-05  +1.78500000E-05  -8.39000000E-05
   -1.17490000E-04  +1.17900000E-05  +8.42000000E-06  +3.16400000E-05  -8.33200000E-05
   +1.30230000E-04  -3.64100000E-05  +3.26650000E-04  -4.30800000E-05  -7.73000000E-06
   -6.61000000E-06  +1.20570000E-04  +5.65200000E-05  -2.36500000E-05  +8.50900000E-05
   +6.06830000E-04  -9.45400000E-05  +2.59500000E-04  -3.90000000E-06  +3.41700000E-05
   -1.46826900E-02  -8.72082000E-03  -9.33640000E-04  +1.32312250E-01  +1.31693660E-01
   +1.14630000E-04  -4.41000000E-05  +1.83300000E-04  -1.02413000E-03  +6.22930000E-04
   +8.77880000E-04  +1.42600000E-04  +1.56290000E-04  +4.94200000E-05  +2.79700000E-05
   +9.83000000E-06  -9.53900000E-05  +9.55900000E-05  -7.11100000E-05  -3.52500000E-05
   -2.28921100E-02  -1.49104500E-02  -1.44237000E-03  +7.41324000E-03  +5.89190000E-03
   -4.70648500E-02  -1.68720000E-04  +1.24910000E-04  -2.34800000E-05  +1.17280000E-03
   -2.26722000E-03  -4.35239000E-03  -1.47882000E-03  -8.48250000E-04  +2.79660000E-04
   +1.52070000E-04  -2.62800000E-04  -2.10810000E-04  +1.04970000E-04  +1.43240000E-04
   -5.18000000E-06  -1.98280000E-04  -2.12000000E-05  +1.93700000E-04  +8.61030000E-04
   -3.03520000E-04  -4.48610000E-04  -1.48940000E-04  -7.13000000E-05  +1.93300000E-05
   -1.11396000E-03  -8.69040000E-04  +1.23484000E-03  -8.42000000E-05  +3.10850000E-04
   -2.39650000E-04  +1.99900000E-05  +2.12300000E-05  +7.61000000E-06  -1.17770000E-04
   -8.08800000E-05  -2.85000000E-05  -2.50000000E-07  +3.91700000E-05  -2.02500000E-05
   -1.00150000E-04  +4.77580000E-04  +2.05490000E-04  -2.50100000E-05  -3.33100000E-05
   +1.09500000E-05  +5.43700000E-05  +8.32000000E-06  -7.03100000E-05  +3.01530000E-04
   +3.76500000E-04  -7.02460000E-04  +3.09770000E-04  +1.60840000E-04  +2.67850000E-04
   +2.42538800E-02  +1.26847500E-02  +8.86460000E-04  -6.92715000E-03  -1.24463000E-03
   +5.13912500E-02  -7.79700000E-05  -3.11330000E-04  +5.87760000E-04  +4.37730000E-04
   +6.41710000E-04  +6.10360000E-04  +7.12530000E-04  +1.37230000E-04  -3.05950000E-04
   -1.60590000E-04  +1.74910000E-04  -1.16130000E-04  +2.22450000E-04  -2.61160000E-04
   +7.75300000E-05  +5.81600000E-04  -1.37468000E-03  -2.39770000E-04  -2.04217900E-01
   +1.31115890E-01  -9.35400000E-05  -2.94660000E-04  +2.36040000E-04  -2.12500000E-05
   -8.40800000E-05  -3.80000000E-06  +3.36160000E-04  +9.86000000E-05  +7.34100000E-05
   +2.81000000E-06  +7.16300000E-05  +2.63500000E-05  -2.02000000E-05  -1.94270000E-04
   +1.23000000E-05  +3.46300000E-05  +1.05460000E-04  -1.88750000E-04  -2.46450000E-04
   -8.19370000E-04  -8.17190000E-04  +5.84930000E-04  +9.74300000E-05  +2.97500000E-05
   -2.25200000E-05  +3.48530000E-04  -3.34120000E-04  -4.85930000E-04  +2.21220000E-04
   -9.40400000E-05  -2.21760000E-04  -1.90400000E-05  -1.23600000E-05  -7.76000000E-06
   +1.32400000E-05  +2.05400000E-05  -2.16000000E-06  -1.20600000E-05  -4.06000000E-06
   -1.43600000E-05  -9.13490000E-04  -1.87268000E-03  -2.08330000E-04  +2.74700000E-05
   -3.78000000E-06  +2.29800000E-05  +3.80590000E-04  -1.47800000E-04  +2.84710000E-04
   -2.14700000E-04  +1.24650000E-04  +8.15200000E-05  +2.08950000E-04  -2.71610000E-04
   +1.77000000E-05  +1.05850000E-03  -2.03560000E-03  -9.99300000E-05  -1.97500000E-02
   +1.80925000E-02  -6.04680000E-04  +2.22250300E-01  +1.21140000E-04  +1.83330000E-04
   +9.66000000E-05  -8.31750000E-04  -1.00385000E-03  -3.67763000E-03  -1.01850000E-04
   -5.37780000E-04  +3.29400000E-04  +5.27170000E-04  -1.67890000E-04  +1.63690000E-04
   -2.61770000E-04  +3.60370000E-04  -2.65570000E-04  +1.52224900E-02  -1.23197500E-02
   +8.36290000E-04  +1.29823980E-01  -1.55120490E-01  +4.22600000E-05  +4.23690000E-04
   -3.54460000E-04  +3.82600000E-05  +7.12930000E-04  +5.97440000E-04  +4.42000000E-04
   -3.18210000E-04  -1.70320000E-04  -1.50400000E-04  +1.80250000E-04  +1.84790000E-04
   +5.18700000E-05  -5.02900000E-05  -4.69000000E-06  +8.46400000E-05  -3.72140000E-04
   +2.48270000E-04  +4.04800000E-04  +3.42210000E-04  -6.34270000E-04  -9.63990000E-04
   +9.22500000E-05  +1.46480000E-04  +6.71900000E-05  +7.09400000E-05  +4.84520000E-04
   +1.62304000E-03  -2.40730000E-04  -6.14770000E-04  +6.11500000E-05  -2.95000000E-06
   -1.29100000E-05  -5.10000000E-07  +5.97000000E-06  +5.00000000E-08  +2.09000000E-05
   +2.44200000E-05  +7.90400000E-05  +1.31400000E-04  -1.42631000E-03  -8.95490000E-04
   +8.00160000E-04  -1.64800000E-05  -3.49600000E-05  -1.73500000E-05  -3.26250000E-04
   +6.59700000E-04  -3.20110000E-04  -1.31670000E-04  -1.92500000E-05  -1.19530000E-04
   -3.34770000E-04  +3.37300000E-05  +1.30080000E-04  +1.30366800E-02  -1.02798500E-02
   -1.44809000E-03  -1.36260700E-02  +1.21750600E-02  -6.44200000E-05  -1.42735030E-01
   +1.66861600E-01  +1.30176000E-03  +1.94080000E-04  -1.55871000E-03  -7.55690000E-04
   -2.81680000E-03  -4.03617000E-03  +2.66860000E-04  -5.91460000E-04  +2.99480000E-04
   +4.29220000E-04  -3.35700000E-05  +3.40270000E-04  -1.83730000E-04  +3.06020000E-04
   -2.58680000E-04  +2.11562700E-02  -1.59857500E-02  -1.32712000E-03  -1.12092000E-03
   +1.43367000E-03  -4.77372900E-02  +4.15780000E-04  -3.46970000E-04  +8.41400000E-05
   +1.71870000E-04  +5.42130000E-04  +6.29290000E-04  +1.21000000E-06  -3.42000000E-06
   -2.20400000E-04  +1.16290000E-04  +7.16700000E-05  -2.40400000E-05  -1.29540000E-04
   +3.04100000E-05  +1.44850000E-04  -8.51100000E-05  -1.46150000E-04  -1.20330000E-04
   -3.61220000E-04  +3.83550000E-04  +3.84900000E-04  +5.69800000E-05  +2.57400000E-05
   -2.22600000E-05  +1.32695000E-03  -1.00033000E-03  +1.05112000E-03  -8.34790000E-04
   +5.59180000E-04  +9.29030000E-04  -6.62000000E-06  -1.45000000E-05  -3.68000000E-06
   +1.80300000E-05  -7.83000000E-06  +8.71000000E-06  +4.30400000E-05  -4.73000000E-06
   +3.82400000E-05  +1.22690000E-04  +4.06100000E-05  +2.15510000E-04  +8.30000000E-06
   -2.30000000E-07  +7.45000000E-06  -5.31630000E-04  +8.04200000E-05  -8.24190000E-04
   +5.92600000E-05  +1.31260000E-04  -6.00900000E-05  -1.81740000E-04  +1.64250000E-04
   +4.04790000E-04  -2.20412500E-02  +1.56076400E-02  +1.59166000E-03  +9.05420000E-04
   -6.29330000E-04  -1.02070000E-03  -4.40600000E-05  +1.92558000E-03  +5.11149100E-02
   -1.12963000E-03  +1.93741000E-03  +4.39583000E-03  +7.74775000E-03  -1.40762700E-02
   +1.47661300E-02  -5.82502900E-02  +3.17539800E-02  -2.20103700E-02  +2.01580000E-04
   +1.81315800E-02  -1.93882400E-02  -1.87364000E-03  +4.90413000E-03  +2.16101000E-03
   -1.51510000E-04  -1.71766000E-03  -1.43959000E-03  +4.05010000E-04  +5.56200000E-05
   -1.55140000E-04  +5.70000000E-06  +1.03915000E-03  -1.02331000E-03  -2.86540000E-04
   +1.37800000E-04  -7.92500000E-05  -3.82900000E-05  +1.23450000E-04  +8.73200000E-05
   +1.12700000E-05  -2.92000000E-06  -7.33900000E-05  -6.82100000E-05  -7.51000000E-05
   -6.38000000E-06  +3.09900000E-05  +3.48900000E-05  +3.64900000E-05  -4.05000000E-05
   -1.91600000E-05  -2.38800000E-05  +1.07780000E-04  +8.11600000E-05  +1.66000000E-06
   -1.81910000E-03  +9.94990000E-04  +1.09403000E-03  +1.58940000E-04  -1.08948000E-03
   +1.09480000E-03  -1.32000000E-05  -2.00000000E-05  -7.00000000E-07  +8.48000000E-06
   +5.02000000E-06  +1.40600000E-05  +7.64300000E-05  -8.62300000E-05  +1.21700000E-05
   -6.93000000E-06  -9.34000000E-06  +2.43000000E-06  +9.60000000E-06  -6.20000000E-06
   +9.40000000E-07  +1.12750000E-04  -2.50450000E-04  -9.15500000E-05  -5.20400000E-04
   +9.48810000E-04  +1.01290000E-04  -1.94385000E-03  +5.11630000E-04  -4.89850000E-04
   +1.78900000E-05  -6.60100000E-05  -1.50960000E-04  +3.01800000E-05  -3.23000000E-05
   +2.60900000E-05  -4.03200000E-05  -4.38700000E-05  -4.60500000E-05  +5.97073400E-02
   +1.61828000E-03  +3.75223000E-03  +2.14924000E-03  +4.29420000E-04  +1.87245000E-03
   +2.59421000E-03  +3.08344400E-02  -1.78246200E-01  +1.48066930E-01  +1.84884000E-03
   -8.29661000E-03  +1.38666400E-02  +4.92415000E-03  +2.67322000E-03  +1.18588000E-03
   -8.99520000E-04  -2.65724000E-03  -1.11396000E-03  +4.63080000E-04  -2.61390000E-04
   -7.61300000E-05  +1.54820000E-04  -7.05040000E-04  +7.80950000E-04  -2.92020000E-04
   +4.09250000E-04  +3.06700000E-04  -1.26400000E-04  +1.03380000E-04  +1.67360000E-04
   +5.86000000E-06  -3.63600000E-05  -6.90500000E-05  +2.83000000E-05  +4.19800000E-05
   +1.59400000E-05  -7.89000000E-06  -1.41500000E-05  +5.67000000E-06  -1.20220000E-04
   -1.36990000E-04  -9.18200000E-05  -3.58000000E-05  -4.42900000E-05  -2.07500000E-05
   +2.49863000E-03  -3.56470000E-04  -4.00310000E-04  +4.98000000E-05  -6.85900000E-05
   +9.93600000E-05  -6.21000000E-06  +7.50000000E-07  +9.34000000E-06  -1.07100000E-05
   -1.71400000E-05  +6.91000000E-06  +1.10500000E-05  -1.08530000E-04  +2.83600000E-05
   +1.58300000E-05  -1.92000000E-06  -1.03600000E-05  -1.06300000E-05  -1.49800000E-05
   +1.66000000E-06  +1.06090000E-04  -1.05850000E-04  -5.65780000E-04  +1.49010000E-03
   -1.08804000E-03  -2.50700000E-04  +8.14500000E-05  -2.38450000E-04  -3.21760000E-04
   -9.01000000E-06  -1.34400000E-05  -7.16000000E-06  -7.90000000E-06  -6.44000000E-06
   -4.63000000E-06  -4.97000000E-05  -2.50300000E-05  -1.43390000E-04  -4.10139300E-02
   +1.85651180E-01  +4.83920000E-03  +1.67066000E-03  +2.37500000E-04  -3.81576000E-03
   +1.59171000E-02  -1.23781900E-02  -2.13900100E-02  +1.47736690E-01  -2.04730750E-01
   +1.86285000E-03  -1.51314000E-03  +4.28505000E-03  +2.26760000E-03  +1.43872000E-03
   +3.27806000E-03  -2.45378000E-03  -4.53170000E-04  -1.58602000E-03  +5.83010000E-04
   -1.88970000E-04  +3.84100000E-05  -1.01510000E-04  +1.21720000E-04  +4.82600000E-05
   -2.22380000E-04  +1.41740000E-04  +1.93170000E-04  +8.91000000E-06  +1.63600000E-05
   +8.72300000E-05  -1.83200000E-05  -2.76400000E-05  +1.10400000E-05  +3.28700000E-05
   +3.47500000E-05  -7.52000000E-06  -5.20000000E-07  -1.66000000E-05  +2.02000000E-06
   -5.61300000E-05  -8.39300000E-05  -2.84500000E-05  -5.03600000E-05  -4.77300000E-05
   -8.15000000E-06  -7.36770000E-04  +9.75900000E-04  +4.97980000E-04  -1.79250000E-04
   +1.17766000E-03  -1.02629000E-03  -2.10000000E-06  +8.79000000E-06  +1.81000000E-06
   -8.09000000E-06  -6.14000000E-06  -4.45000000E-06  +9.99000000E-06  +2.92200000E-05
   -3.93200000E-05  +3.39000000E-06  +8.75000000E-06  -1.63800000E-05  -9.55000000E-06
   -2.24000000E-06  -2.02000000E-06  -5.90780000E-04  -2.87140000E-04  +3.47660000E-04
   -1.20310000E-04  -9.79920000E-04  +6.12700000E-05  -4.84130000E-04  +3.62980000E-04
   +3.62600000E-04  -5.31100000E-05  +7.97000000E-06  +6.92600000E-05  -3.18000000E-06
   -3.32100000E-05  -6.39200000E-05  +3.80000000E-05  -1.18270000E-04  -1.63270000E-04
   +2.19144200E-02  -1.62925010E-01  +2.11873390E-01  -4.90250000E-04  +1.51480000E-04
   -9.19420000E-04  -1.20583000E-03  +5.05682000E-03  +3.69820000E-04  -1.20735400E-02
   -5.09502000E-03  +1.89032200E-02  -1.75553290E-01  -1.21713100E-02  +1.48899490E-01
   +6.28114000E-03  +2.49292000E-03  -4.76882000E-03  +7.40000000E-06  -3.07630000E-04
   +9.36980000E-04  -2.52090000E-04  +1.00690000E-04  -9.01200000E-05  -2.96020000E-04
   -2.18445000E-03  -7.34580000E-04  +3.64900000E-05  +1.90600000E-04  +2.99700000E-05
   -4.22300000E-05  +7.60000000E-06  +1.70500000E-05  -2.80900000E-05  -1.24900000E-05
   +6.95000000E-06  +4.83500000E-05  +3.15000000E-05  +3.47000000E-06  -4.66000000E-06
   -1.53700000E-05  +3.91000000E-06  -4.96200000E-05  -6.05200000E-05  -2.75800000E-05
   -6.35800000E-05  -5.20700000E-05  -1.11100000E-05  -1.79100000E-05  -1.13150000E-04
   +3.31900000E-05  +1.18710000E-04  -1.64150000E-04  -4.53200000E-05  +2.73000000E-06
   +8.36000000E-06  +7.00000000E-06  -1.53800000E-05  -1.42700000E-05  -4.60000000E-06
   +9.51000000E-06  +2.32800000E-05  +1.90300000E-05  +1.31600000E-05  +8.42000000E-06
   -8.72000000E-06  -9.11000000E-06  -4.96000000E-06  +1.60000000E-07  -3.91000000E-06
   +4.34000000E-05  -1.71800000E-05  +3.69200000E-05  +1.87800000E-05  +7.41000000E-06
   -1.94300000E-05  +1.78400000E-05  -1.71400000E-05  +8.50000000E-07  -6.80000000E-06
   -5.80000000E-07  +1.76200000E-05  -2.14000000E-06  -8.90000000E-06  -2.54600000E-05
   +9.25400000E-05  +8.06400000E-05  -4.43760000E-04  -1.71895000E-03  -1.57226000E-03
   +1.82298710E-01  +4.56140000E-04  -1.75917000E-03  +1.92590000E-04  +4.64666000E-03
   +1.07777000E-03  +2.04883000E-03  +1.12388500E-02  +5.20055000E-03  -1.51800200E-02
   -1.09126700E-02  -5.03525600E-02  +3.41270700E-02  -1.60002900E-02  +2.78016000E-03
   +1.66483400E-02  +4.54090000E-04  +6.84900000E-04  -3.39070000E-04  +4.79800000E-05
   +3.76200000E-05  +5.35000000E-05  -1.57182000E-03  -3.96120000E-04  -2.85930000E-03
   +2.05120000E-04  -2.45630000E-04  -5.77600000E-05  -4.72000000E-06  +7.81000000E-06
   +2.07500000E-05  +3.00000000E-08  +3.53000000E-06  -1.10800000E-05  -2.70000000E-05
   -3.58700000E-05  -1.36600000E-05  +2.51100000E-05  +3.43500000E-05  -1.44000000E-05
   +2.93000000E-05  +3.91800000E-05  +3.94000000E-05  +4.58400000E-05  +3.12200000E-05
   +4.15000000E-06  -7.31300000E-05  +2.17500000E-05  -8.67700000E-05  -1.73090000E-04
   +1.29730000E-04  -1.50100000E-04  -5.85000000E-06  -4.21000000E-06  -4.00000000E-07
   -2.96000000E-06  +1.95000000E-06  +3.02000000E-06  +1.44000000E-06  +1.09200000E-05
   +2.52000000E-06  +3.14000000E-06  -9.86000000E-06  -4.10000000E-07  +7.96000000E-06
   +6.68000000E-06  -4.06000000E-06  +7.22000000E-06  -6.02000000E-06  +3.67100000E-05
   +1.28600000E-05  -3.13700000E-05  +4.15000000E-06  -6.11000000E-06  +4.17200000E-05
   +3.66600000E-05  +6.20000000E-07  -1.07900000E-05  -9.10000000E-06  -1.76800000E-05
   -4.78000000E-06  -1.23600000E-05  +3.02000000E-06  -1.19600000E-05  -2.19100000E-05
   -2.01830000E-03  -1.54666000E-03  -1.83319000E-03  +1.12226300E-02  +4.47210700E-02
   -9.92480000E-04  +2.84600000E-05  -4.48810000E-04  +7.18160000E-04  +1.74187000E-03
   +3.23122000E-03  -1.94820000E-03  +1.67060000E-04  +3.13606000E-03  +1.48011670E-01
   +3.45110500E-02  -2.11233950E-01  +1.79520600E-02  +5.06220000E-04  -1.28703400E-02
   -2.25900000E-05  +3.28220000E-04  +2.08990000E-04  -7.45000000E-06  +4.78900000E-05
   +1.32000000E-06  -1.37561000E-03  -2.38467000E-03  +3.07800000E-04  +1.07610000E-04
   -9.48500000E-05  -2.24600000E-05  -1.22000000E-06  +8.41000000E-06  +8.04000000E-06
   +2.61000000E-06  -9.05000000E-06  -1.02500000E-05  -2.94600000E-05  -3.13700000E-05
   -1.04000000E-05  +1.55800000E-05  +2.01300000E-05  +3.60000000E-07  +4.00000000E-06
   +1.21600000E-05  +2.75600000E-05  +4.14200000E-05  +2.87700000E-05  +3.41000000E-06
   +1.30100000E-05  -5.20900000E-05  -5.45600000E-05  +4.30300000E-05  -1.68270000E-04
   +9.75000000E-05  -6.76000000E-06  -5.35000000E-06  -1.62000000E-06  -1.29000000E-06
   +2.14000000E-06  +1.65000000E-06  -6.04000000E-06  -3.50000000E-07  -9.03000000E-06
   +9.30000000E-07  -2.21000000E-06  -1.54000000E-06  +3.35000000E-06  +3.97000000E-06
   -3.41000000E-06  +1.97600000E-05  +3.75000000E-06  +9.89000000E-06  +2.61100000E-05
   +1.46400000E-05  +9.04000000E-06  -2.64100000E-05  +1.99800000E-05  -1.39000000E-06
   -2.75000000E-06  -5.20000000E-06  -9.13000000E-06  -4.92000000E-06  +2.58000000E-06
   -4.80000000E-07  -1.33000000E-06  +1.59600000E-05  +1.62000000E-06  -1.19958000E-03
   -2.11391000E-03  -7.18350000E-04  -1.61091290E-01  -3.72864800E-02  +2.19025470E-01
   -5.65880000E-04  +1.94860000E-04  -7.80460000E-04  -6.45500000E-05  -1.99770000E-04
   +4.30120000E-04  +1.06549000E-03  +9.22030000E-04  -9.43720000E-04  -5.36153000E-03
   +3.43768000E-03  +2.16284000E-03  -1.11287000E-03  +3.19998700E-02  -3.08727200E-02
   -1.46260000E-04  -2.44000000E-05  +5.34500000E-05  +3.24600000E-05  +5.43000000E-06
   -1.73500000E-05  -4.35696800E-02  -4.52731700E-02  +6.81380100E-02  -8.92000000E-06
   -1.05300000E-05  +9.30000000E-07  +4.98000000E-06  -2.03200000E-05  +3.27700000E-05
   +3.33400000E-05  -3.55500000E-05  -1.66000000E-05  -1.18860000E-04  -7.37700000E-05
   -9.89000000E-06  +1.13900000E-05  +1.62100000E-05  +2.34500000E-05  -1.41200000E-05
   -5.15000000E-06  +2.53800000E-05  +1.25780000E-04  +7.69200000E-05  +1.49600000E-05
   +4.74500000E-05  -7.75000000E-06  -1.47100000E-05  +5.48140000E-04  -4.46880000E-04
   +1.49770000E-04  -2.99200000E-05  -1.21700000E-05  -1.31800000E-05  -8.49000000E-06
   +1.30400000E-05  -6.61000000E-06  -1.34500000E-05  +1.13300000E-05  -3.98400000E-05
   -1.06900000E-05  +5.77000000E-06  -7.14000000E-06  +3.58000000E-06  +3.32000000E-06
   -7.75000000E-06  +1.10100000E-05  -2.41800000E-05  +1.63300000E-05  -1.73500000E-05
   -6.17000000E-06  -6.75000000E-06  -2.62000000E-06  +1.22300000E-05  +1.06000000E-06
   -1.93000000E-05  +4.22300000E-05  +2.32800000E-05  -1.16500000E-05  +7.60000000E-07
   +1.04800000E-05  +2.15300000E-05  -2.61200000E-05  +2.46000000E-06  -3.63680000E-04
   +1.66800000E-04  +5.82000000E-06  -3.50700000E-05  -1.94460000E-04  -2.39900000E-05
   +4.96360400E-02  +5.47190000E-04  -1.34820000E-03  +5.16730000E-04  -7.95600000E-05
   +2.16940000E-04  -2.97410000E-04  +1.04170000E-04  +4.32110000E-04  +1.53482000E-03
   +3.50165000E-03  +4.73300000E-05  -1.76140000E-03  +1.86519000E-03  -2.56597900E-02
   +2.18260400E-02  +1.63580000E-04  -1.27750000E-04  -1.30000000E-06  -7.42600000E-05
   +3.13600000E-05  -2.86200000E-05  -1.02613600E-02  -2.55484950E-01  +2.36939480E-01
   +6.02000000E-06  +1.14150000E-04  +3.38000000E-06  -7.73000000E-06  -6.37000000E-06
   -6.90000000E-06  -3.82400000E-05  +1.20800000E-05  +4.22900000E-05  +1.25390000E-04
   +1.06140000E-04  +2.70700000E-05  -2.14300000E-05  -4.87700000E-05  -2.38700000E-05
   -6.10000000E-06  -2.32000000E-05  -3.81200000E-05  -1.57980000E-04  -1.33550000E-04
   -1.18000000E-05  -5.58300000E-05  -1.40000000E-06  +2.17200000E-05  -8.95380000E-04
   +2.05170000E-04  +4.82920000E-04  +1.35500000E-05  +3.26900000E-05  +3.95000000E-06
   -1.69700000E-05  -1.40200000E-05  -2.05400000E-05  +2.83000000E-05  +3.53000000E-05
   +3.53000000E-05  +1.77200000E-05  +5.60000000E-07  -6.62000000E-06  -1.03600000E-05
   -3.71000000E-06  +4.37000000E-06  -2.51300000E-05  +2.71500000E-05  -1.33600000E-05
   +4.50000000E-06  -2.11800000E-05  +1.02300000E-05  +1.29700000E-05  -7.54000000E-06
   -7.73000000E-06  +2.34700000E-05  -2.55900000E-05  -1.32900000E-05  +2.86000000E-06
   -3.40900000E-05  -1.22500000E-05  -3.94900000E-05  +4.53500000E-05  +1.79400000E-05
   +1.62930000E-04  -1.11070000E-04  -9.36100000E-05  -2.23670000E-04  -9.92100000E-05
   -3.60880000E-04  +7.81412000E-03  +2.81079630E-01  -8.93430000E-04  +2.89180000E-04
   -1.05310000E-04  +3.57140000E-04  -2.65220000E-04  -1.76620000E-04  +2.34200000E-05
   +1.31575000E-03  +2.69290000E-04  +1.38283000E-03  -9.92100000E-04  +2.08577000E-03
   -5.81793000E-03  +3.15177000E-03  -1.12831000E-03  -1.65750000E-04  +9.33300000E-05
   -1.96660000E-04  +1.57840000E-04  -9.33000000E-05  +8.68900000E-05  +3.81525600E-02
   +2.58801880E-01  -2.72596610E-01  +5.40400000E-05  -1.22390000E-04  -5.31000000E-06
   +6.98000000E-06  +3.28100000E-05  +4.24700000E-05  +6.97000000E-06  -1.54200000E-05
   -1.28100000E-05  -4.07800000E-05  -5.01300000E-05  -1.68900000E-05  +3.37900000E-05
   +4.70500000E-05  -8.14000000E-06  -1.06200000E-05  +1.24400000E-05  +2.19800000E-05
   +6.61900000E-05  +5.20900000E-05  -5.54000000E-06  +1.07100000E-05  +1.91200000E-05
   -3.35100000E-05  +2.00320000E-04  +4.45000000E-04  -6.83000000E-04  -9.54000000E-06
   -9.39000000E-06  +5.31000000E-06  -4.86000000E-06  +1.02000000E-06  +4.64000000E-06
   -7.89000000E-06  -2.68000000E-06  -3.54600000E-05  +2.90000000E-06  -1.68900000E-05
   +3.49000000E-06  +1.17100000E-05  +7.10000000E-07  -1.24000000E-06  +1.42400000E-05
   -1.56400000E-05  +1.92000000E-06  -8.36000000E-06  +5.61000000E-06  +7.20000000E-07
   -1.02100000E-05  +3.23000000E-06  -6.59000000E-06  +1.56400000E-05  -3.49000000E-06
   -1.90500000E-05  -1.96000000E-06  +1.79300000E-05  +2.27400000E-05  +2.72400000E-05
   -4.34600000E-05  -7.68400000E-05  -5.50800000E-05  -8.41600000E-05  -3.49000000E-06
   -7.17600000E-05  -3.30220000E-04  -2.59000000E-05  -3.54655900E-02  -2.57797950E-01
   +2.71851600E-01  +8.48816000E-03  -2.77242300E-02  +1.52513900E-02  -3.64395000E-03
   +1.71700000E-04  +4.53567000E-03  +1.53498000E-03  +1.48760000E-04  +1.78590000E-04
   -7.96110000E-04  +3.21360000E-04  +6.19000000E-05  +4.92930000E-04  -6.16860000E-04
   +2.07130000E-04  -2.47200000E-04  +1.38400000E-05  -1.07400000E-05  -3.18400000E-05
   +5.31900000E-05  +1.05100000E-05  +1.13580000E-04  +4.65820000E-04  -7.40120000E-04
   +1.76670000E-04  +1.36500000E-04  -8.42600000E-05  +1.37550000E-04  +2.04960000E-04
   -4.40000000E-07  -1.54290000E-04  -1.79910000E-04  +1.14530000E-04  +3.14000000E-05
   -8.96300000E-05  -1.14700000E-04  +2.10000000E-06  -6.40800000E-05  +1.01110000E-04
   -9.88000000E-06  +6.60800000E-05  -5.86600000E-05  -9.84900000E-05  -1.13500000E-04
   +4.10300000E-05  -9.27800000E-05  -2.29700000E-05  -3.55200000E-05  -6.87710100E-02
   +1.36597380E-01  -5.84911700E-02  -4.05100000E-05  +1.94300000E-05  -3.89400000E-05
   -2.27200000E-05  +1.20800000E-05  -3.59300000E-05  +1.03800000E-05  +3.27000000E-05
   -4.25000000E-06  +3.83200000E-05  +3.56600000E-05  -2.84000000E-05  -5.73500000E-05
   +3.03000000E-05  -2.26500000E-05  -7.66000000E-06  +2.86100000E-05  -1.71100000E-05
   -2.89800000E-05  -4.06100000E-05  +1.85200000E-05  +3.43000000E-06  +2.31700000E-05
   -2.53200000E-05  +6.52500000E-05  -1.53280000E-04  -2.29980000E-04  -3.50000000E-06
   +1.93000000E-05  -4.69000000E-06  -7.90000000E-06  +1.24190000E-04  -8.92700000E-05
   -2.05910000E-04  -6.37500000E-05  +1.66170000E-04  -5.07800000E-05  +7.28000000E-05
   -1.43910000E-04  -6.85110000E-04  +1.51780000E-04  +7.80520000E-04  +6.49263200E-02
   -1.66733000E-03  -7.58171000E-03  +8.18045000E-03  +7.88000000E-06  +1.99441000E-03
   -1.54783000E-03  +3.03390000E-04  +3.82010000E-04  +7.39730000E-04  +2.96810000E-04
   +2.22500000E-05  -3.16770000E-04  -6.22960000E-04  -8.84070000E-04  +8.80660000E-04
   +2.37800000E-04  -5.95300000E-05  -2.55150000E-04  -5.45000000E-05  -9.42700000E-05
   -3.63260000E-04  +7.54310000E-04  -5.20520000E-04  -6.47400000E-05  +1.55880000E-04
   -1.54200000E-05  +1.37800000E-04  +5.95600000E-05  +4.22100000E-05  -2.03600000E-05
   -5.35500000E-05  -8.85000000E-05  +7.88800000E-05  +1.44350000E-04  +1.29030000E-04
   +4.09000000E-05  -9.27000000E-06  -2.96100000E-05  -3.66100000E-05  -7.47700000E-05
   +1.01700000E-05  -3.95300000E-05  -1.93140000E-04  -1.97350000E-04  -2.16000000E-06
   -6.45700000E-05  -2.08800000E-05  +2.68900000E-05  +1.05816080E-01  -3.69510300E-01
   +2.11825200E-01  -1.01900000E-05  +4.81100000E-05  -2.08100000E-05  -3.29600000E-05
   -6.99000000E-06  -5.52800000E-05  +2.51200000E-05  +6.23200000E-05  +1.83000000E-06
   +2.74100000E-05  -3.45400000E-05  -3.29000000E-06  -1.33600000E-05  +4.68000000E-06
   +1.72000000E-06  -2.38800000E-05  +3.57300000E-05  -2.10600000E-05  +3.00000000E-06
   -2.05400000E-05  +6.97000000E-06  +1.17900000E-05  +7.37000000E-06  -2.30400000E-05
   +9.50900000E-05  -2.58270000E-04  +3.43400000E-04  +1.32000000E-05  -8.02300000E-05
   +5.49400000E-05  -6.06900000E-05  +1.03400000E-05  +7.88100000E-05  -1.02100000E-05
   +2.26400000E-05  -9.36900000E-05  -5.52000000E-06  -4.71700000E-05  +1.88400000E-05
   +2.38880000E-04  +1.57260000E-04  -3.94520000E-04  -1.05966860E-01  +3.75593270E-01
   -4.02071000E-03  +3.37752600E-02  -2.81669600E-02  +5.07379000E-03  -8.41430000E-04
   -1.19599000E-03  -4.04970000E-04  +1.70328000E-03  -6.39620000E-04  -2.43790000E-04
   -3.15140000E-04  +6.14340000E-04  +3.00000000E-04  +2.71320000E-04  -1.55564000E-03
   +6.50000000E-07  -1.47550000E-04  -2.41500000E-05  +1.96550000E-04  -4.32990000E-04
   -1.24950000E-04  -6.19590000E-04  +2.97310000E-04  +3.28090000E-04  -7.20700000E-05
   -7.82700000E-05  -3.70300000E-05  +8.22100000E-05  +5.55700000E-05  -4.83000000E-06
   +3.90000000E-05  -1.54780000E-04  +2.10000000E-07  -2.53970000E-04  -1.29330000E-04
   +2.72400000E-05  +2.40200000E-05  +6.09700000E-05  -9.94000000E-06  -5.04400000E-05
   +5.76100000E-05  -6.89000000E-06  +2.25880000E-04  +1.58080000E-04  -1.18000000E-05
   +3.86800000E-05  -1.51300000E-05  -4.38300000E-05  -3.44749400E-02  +1.81137970E-01
   -1.29466270E-01  -4.55600000E-05  -3.00600000E-05  -3.54000000E-06  -1.35800000E-05
   +2.12600000E-05  -1.81500000E-05  -9.73000000E-06  +2.37000000E-05  -9.14400000E-05
   -1.99600000E-05  -4.61500000E-05  +1.25700000E-05  +4.33000000E-05  -1.18100000E-05
   +2.65000000E-06  +1.88000000E-05  -2.08000000E-05  +4.02000000E-06  -1.23900000E-05
   -9.10000000E-07  +5.56000000E-06  -1.27100000E-05  +1.67600000E-05  -2.79000000E-06
   -6.94600000E-05  +2.37870000E-04  +3.13840000E-04  -1.06100000E-05  -5.04500000E-05
   +8.05000000E-05  +2.16400000E-05  -1.32300000E-04  +8.85200000E-05  +2.41800000E-04
   -7.23900000E-05  -2.90870000E-04  -5.94000000E-06  -7.59700000E-05  -2.73700000E-05
   +1.36710000E-04  -1.54290000E-04  +8.73900000E-05  +3.70942100E-02  -2.15220010E-01
   +1.60030920E-01  -2.41098110E-01  +8.28633400E-02  +4.80288100E-02  +1.47961300E-02
   +4.12650800E-02  -6.29106600E-02  -5.55947600E-02  +1.79708200E-02  +2.70667700E-02
   +4.29958700E-02  -5.08818100E-02  +3.10603400E-02  -1.92295210E-01  +3.19118400E-02
   +8.08727200E-02  +2.42926000E-03  +4.46150000E-04  +1.60899000E-03  -2.64140000E-04
   +2.87160000E-04  +8.84670000E-04  -4.34026200E-02  +1.58064400E-02  +3.06684900E-02
   +3.65770000E-04  -8.41740000E-04  -1.23520000E-04  +3.40630000E-04  -2.37900000E-05
   +1.56030000E-04  -2.85460000E-04  -9.36200000E-05  +1.26270000E-04  +1.08030000E-04
   -2.59280000E-04  -2.84150000E-04  +2.86570000E-04  +4.05980000E-04  +3.25400000E-05
   -2.87780000E-04  -5.76100000E-05  +2.99550000E-04  +7.89200000E-05  +1.12580000E-04
   +1.48400000E-05  +7.36400000E-04  -3.11040000E-04  +3.93600000E-05  -4.02836200E-02
   +1.64923400E-02  +2.59913000E-02  +1.20200000E-05  -1.62700000E-05  +1.05700000E-05
   +1.65700000E-05  -5.40000000E-06  +3.00600000E-05  +1.90410000E-04  +1.74150000E-04
   -3.55900000E-05  +1.42300000E-05  -8.49300000E-05  +5.67000000E-06  +2.05800000E-05
   +2.30800000E-05  -8.13000000E-06  -1.72000000E-05  -1.38390000E-04  +2.61580000E-04
   -1.36300000E-05  -9.10700000E-05  +1.16070000E-04  +1.36100000E-05  -6.41700000E-05
   +2.04880000E-04  -6.63800000E-05  -1.89720000E-04  +8.96000000E-06  -1.30600000E-05
   +6.77900000E-05  -1.50360000E-04  -4.20000000E-07  -1.13300000E-05  -5.58500000E-05
   -1.56530000E-03  -2.45980000E-04  +2.99630000E-04  +1.39853000E-03  +3.16729000E-03
   -7.43040000E-04  -2.75925000E-03  -1.11323000E-03  +5.04113000E-03  -3.25406000E-03
   +3.38090000E-03  -6.17750000E-04  +5.92122870E-01  +1.38631400E-01  -1.56013700E-01
   -6.32661000E-03  +1.19991400E-02  -2.28428900E-02  +2.43963900E-02  +1.72822400E-02
   -6.84495000E-03  -7.19403000E-03  -2.14705300E-02  +1.33081900E-02  +1.03884300E-02
   -2.22894100E-02  -9.44987000E-02  +5.78662500E-02  +1.00290000E-03  +1.07114000E-03
   +3.95494000E-03  -1.09628000E-03  +8.29610000E-04  -3.61770000E-04  +3.45285800E-02
   -2.81286000E-03  -1.48101800E-02  +2.82900000E-05  +2.80430000E-04  +9.72200000E-05
   -1.15800000E-05  -1.69600000E-05  -2.17500000E-04  +7.08000000E-05  +9.80200000E-05
   +5.47800000E-05  +2.52340000E-04  +3.60670000E-04  +2.12850000E-04  -2.64880000E-04
   -2.43940000E-04  -9.71600000E-05  +2.63940000E-04  -5.95000000E-05  -9.04500000E-05
   -3.80930000E-04  -3.22790000E-04  -1.04400000E-05  +3.26810000E-04  -1.88160000E-04
   -5.00000000E-05  -5.02730000E-04  +7.90964000E-03  +5.47258000E-03  +4.22300000E-05
   +7.39700000E-05  -1.27100000E-05  -1.14900000E-05  -1.77700000E-05  -4.70400000E-05
   +8.60500000E-05  -3.75000000E-05  +2.33040000E-04  +2.05900000E-05  +4.31500000E-05
   -1.72900000E-05  -3.43600000E-05  -1.31300000E-05  +1.42500000E-05  -4.22200000E-05
   -5.82200000E-05  +1.00880000E-04  +2.83700000E-05  -3.54300000E-05  -3.84400000E-05
   +3.12000000E-05  +4.07100000E-05  -4.93300000E-05  +1.69900000E-05  -6.72300000E-05
   -1.01890000E-04  -5.70000000E-06  -1.35290000E-04  -6.15000000E-05  -1.60470000E-04
   +2.92430000E-04  +2.83420000E-04  -7.48200000E-05  -3.03830000E-04  -9.38170000E-04
   +2.37726000E-03  +2.02810000E-04  +4.29066000E-03  +4.46109000E-03  +1.23667000E-03
   -5.33368000E-03  -3.93172000E-03  +2.31267000E-03  +4.53540000E-04  -1.90634460E-01
   +4.16272890E-01  -1.80165900E-02  +4.19406600E-02  -9.88905700E-02  -2.54287800E-02
   -3.21116000E-03  +2.98897700E-02  +2.86816500E-02  -8.22049000E-03  -1.54086500E-02
   -6.97829000E-03  +3.65150600E-02  -3.59737400E-02  +1.47662240E-01  +8.52035000E-03
   -2.13724490E-01  +7.38330000E-04  +3.88079000E-03  -1.69703000E-03  +1.04810000E-04
   -9.26500000E-05  -1.97600000E-04  +7.31246000E-03  +1.86099000E-03  +1.76366000E-03
   +8.10420000E-04  -3.28300000E-04  +5.38300000E-05  -4.94500000E-05  +7.18500000E-05
   +9.51800000E-05  +2.49220000E-04  -8.63500000E-05  -1.89660000E-04  -4.34810000E-04
   -2.62290000E-04  +8.83000000E-06  -5.90800000E-05  +9.09200000E-05  -1.81200000E-05
   +1.41480000E-04  -5.60000000E-07  +1.85500000E-04  +5.08800000E-04  +4.14050000E-04
   +3.21000000E-06  -7.98200000E-04  +5.09550000E-04  +1.55260000E-04  +4.61211400E-02
   -9.83222000E-03  -1.67508000E-02  -5.27600000E-05  -9.55100000E-05  -1.30000000E-06
   +2.66300000E-05  +3.88900000E-05  +5.69500000E-05  -1.00030000E-04  -1.51730000E-04
   -1.82310000E-04  -5.28100000E-05  +2.31900000E-05  +6.80000000E-06  +4.24800000E-05
   -1.83000000E-06  -9.15000000E-06  +6.44600000E-05  +1.48250000E-04  -2.88450000E-04
   +2.88400000E-05  +1.19080000E-04  -6.36700000E-05  -6.69300000E-05  +2.84300000E-05
   -1.08370000E-04  -6.04000000E-06  +2.68220000E-04  +4.38000000E-06  -2.76300000E-05
   +1.39500000E-04  +1.67400000E-04  +1.20990000E-04  -4.51600000E-05  -2.20800000E-05
   +3.44490000E-04  -9.79850000E-04  -2.82430000E-04  +5.89720000E-04  +3.41407000E-03
   +5.75130000E-04  -1.78277000E-03  +7.72770000E-04  +2.51056000E-03  +7.54088000E-03
   -4.31367000E-03  +6.19180000E-04  -1.60441280E-01  -1.86391180E-01  +5.46937270E-01
   -7.35268000E-03  +2.48734400E-02  -1.88264600E-02  -3.20840000E-03  +3.02409000E-03
   +3.11570000E-03  -9.08810000E-04  +1.09200000E-04  -4.05580000E-04  -3.63310000E-04
   +2.22848000E-03  +4.14931000E-03  -5.50930000E-04  -8.18447000E-03  +1.47515300E-02
   +7.85250000E-04  +5.85020000E-04  -1.23239000E-03  -4.51000000E-06  -1.64880000E-04
   +5.92200000E-05  +5.08412000E-03  -8.14609000E-03  +5.49772000E-03  +2.42540000E-04
   +8.05200000E-05  +1.44800000E-05  -4.63800000E-05  +1.01840000E-04  +5.05600000E-05
   -1.00410000E-04  +1.36600000E-05  +5.31300000E-05  +3.00920000E-04  +1.87520000E-04
   +2.75400000E-05  +5.29000000E-06  -3.18900000E-05  -8.27200000E-05  +8.30000000E-06
   -2.62300000E-05  -1.03310000E-04  -3.24930000E-04  -2.32690000E-04  -4.61800000E-05
   -5.51350000E-04  +1.75510000E-04  +1.72570000E-04  +4.07070000E-04  +4.77244000E-03
   -1.02228200E-02  +4.88300000E-05  +4.44500000E-05  +3.06400000E-05  -1.99000000E-05
   -3.84600000E-05  -1.23900000E-05  +1.74500000E-05  +2.40200000E-05  +2.91500000E-05
   +4.91000000E-05  -2.90100000E-05  +8.18000000E-06  -1.07300000E-05  -1.26200000E-05
   +1.54200000E-05  -3.98800000E-05  +1.35920000E-04  -1.76360000E-04  +4.25000000E-05
   +1.58800000E-05  +1.49100000E-05  +1.21300000E-05  -2.62100000E-05  -5.46300000E-05
   +6.05500000E-05  -1.42500000E-04  -1.29920000E-04  +3.62600000E-05  +5.17700000E-05
   -2.86200000E-05  -4.00800000E-05  +8.79300000E-05  -4.53400000E-05  +1.31730000E-04
   -1.55210000E-04  -2.33630000E-04  +3.42180000E-04  -5.75860000E-04  +4.69960000E-04
   +2.37287000E-03  -2.73898000E-03  -5.24305000E-03  +5.02082000E-03  -1.71336000E-03
   -9.96130000E-04  -7.04682700E-02  +2.83158300E-02  -2.52487500E-02  +1.96383760E-01
   +6.02125000E-03  -2.29474100E-02  +2.92936300E-02  +5.91700000E-03  +4.01057000E-03
   +5.11600000E-05  +4.62900000E-05  -2.18526000E-03  +6.61810000E-04  +5.10860000E-04
   +5.13437000E-03  +2.17304000E-03  +8.88893000E-03  -1.41279200E-02  +1.55675200E-02
   -1.07998000E-03  -9.61900000E-05  +1.36683000E-03  +2.34360000E-04  +1.51200000E-05
   +1.62240000E-04  -4.42731000E-03  +3.80635000E-03  -6.60795000E-03  -3.85470000E-04
   -4.69100000E-04  -8.18800000E-05  -4.88600000E-05  +8.05500000E-05  +6.22200000E-05
   +1.39210000E-04  -3.08900000E-05  -1.58960000E-04  -4.56270000E-04  -3.88840000E-04
   -9.16600000E-05  +1.20550000E-04  +1.98440000E-04  +6.02700000E-05  -3.59500000E-05
   +1.10840000E-04  +1.08980000E-04  +5.87370000E-04  +4.89310000E-04  +1.80800000E-05
   +7.27000000E-04  -3.42640000E-04  -2.02330000E-04  -2.17338000E-03  -6.91260000E-04
   -2.70625000E-03  -5.11300000E-05  -1.13100000E-04  +5.01000000E-06  +4.56900000E-05
   +4.22000000E-05  +7.37300000E-05  -1.14820000E-04  -1.41010000E-04  -1.26780000E-04
   -4.89000000E-05  -3.13500000E-05  +1.84100000E-05  +5.89400000E-05  +3.16000000E-06
   -7.17000000E-06  +1.17340000E-04  -2.77110000E-04  +1.17530000E-04  -3.34400000E-05
   +1.28100000E-04  -5.90000000E-07  -9.96700000E-05  +2.21500000E-05  -9.33400000E-05
   -4.27600000E-05  +1.09670000E-04  -3.64400000E-05  -3.04200000E-05  +6.50700000E-05
   +7.19400000E-05  +1.13000000E-04  -1.63570000E-04  -9.67900000E-05  -2.51940000E-04
   -1.60730000E-04  -3.60000000E-05  +3.06100000E-04  -3.87480000E-04  +6.50300000E-04
   -2.74091000E-03  -5.98280000E-04  +2.17560000E-03  -3.26250000E-04  -2.10113000E-03
   -3.51820000E-04  +1.22663900E-02  -1.66144870E-01  +8.31208100E-02  +7.91220800E-02
   +3.22633540E-01  +2.80960000E-03  +1.62215600E-02  -1.72007100E-02  +3.60530000E-04
   +8.85570000E-04  +3.90165000E-03  -4.21830000E-04  +9.84880000E-04  -1.75750000E-03
   +6.28792000E-03  -8.46070000E-04  -9.07470000E-04  -7.48016000E-03  +3.50782400E-02
   -3.12397800E-02  +1.11982000E-03  -5.52700000E-05  -6.98400000E-04  -2.21740000E-04
   +4.24500000E-05  -2.91480000E-04  -1.86680000E-03  -5.32100000E-04  +9.84150000E-04
   +1.05220000E-04  +5.06120000E-04  +1.86970000E-04  +5.08000000E-05  -2.19230000E-04
   -1.68920000E-04  -7.99400000E-05  +6.31100000E-05  +1.56110000E-04  +3.28790000E-04
   +3.42530000E-04  +9.14600000E-05  -1.73130000E-04  -2.42470000E-04  -8.66000000E-06
   +4.91500000E-05  -1.21760000E-04  -9.31100000E-05  -4.80410000E-04  -4.01040000E-04
   +9.95000000E-06  -5.69150000E-04  +1.99150000E-04  +1.03940000E-04  +5.78770000E-04
   -6.95466000E-03  +8.86915000E-03  +4.37900000E-05  +9.25600000E-05  -1.93900000E-05
   -2.61400000E-05  -2.43700000E-05  -6.19500000E-05  +1.23080000E-04  +1.52930000E-04
   +1.47740000E-04  +1.39700000E-05  +7.37200000E-05  -2.53700000E-05  -6.74600000E-05
   -8.00000000E-07  +1.48000000E-06  -1.97440000E-04  +1.52890000E-04  -8.39500000E-05
   +2.60000000E-07  -2.20080000E-04  +3.02300000E-05  +1.39390000E-04  +1.41500000E-05
   +1.08880000E-04  -2.36200000E-05  -4.02000000E-06  +1.13530000E-04  +1.50900000E-05
   -1.14030000E-04  -8.11600000E-05  -1.21290000E-04  +1.42960000E-04  +1.75610000E-04
   -5.94600000E-05  -1.40100000E-05  -5.64900000E-05  -5.33790000E-04  +1.54211000E-03
   -1.24827000E-03  -1.70477000E-03  -3.83740000E-04  -1.89910000E-04  -5.58056000E-03
   -2.20690000E-04  -1.57005000E-03  -1.57621600E-02  +1.17662050E-01  -1.72359200E-01
   +2.25161810E-01  +1.36669900E-02  +5.24851410E-01  +1.16651000E-03  +1.21669000E-03
   -3.34723000E-03  -7.45100000E-05  +4.62720000E-04  +5.73170000E-04  +1.80130000E-04
   -2.65410000E-04  -7.25300000E-05  -1.01961000E-03  +1.26990000E-04  +5.73700000E-05
   +2.13652000E-03  -2.60437000E-03  +2.60108000E-03  -1.27800000E-05  +6.63500000E-05
   -4.39000000E-05  +4.51500000E-05  +2.50900000E-05  -7.10000000E-05  -1.64042000E-03
   -3.96500000E-04  -1.38299000E-03  -1.45200000E-05  +6.10000000E-06  +1.69600000E-05
   +1.11800000E-05  -5.43700000E-05  -9.29000000E-06  +3.78900000E-05  -9.66000000E-06
   -1.48900000E-05  -1.04470000E-04  -6.31700000E-05  -1.37000000E-05  -9.58000000E-06
   -3.20000000E-07  +3.69400000E-05  +7.80000000E-07  -1.02400000E-05  +3.42700000E-05
   +1.09160000E-04  +7.40700000E-05  +2.07800000E-05  +1.05400000E-05  +7.84000000E-06
   +3.38000000E-06  +1.50780000E-04  -2.97300000E-05  +2.01175000E-03  -1.97900000E-05
   -1.34800000E-05  -1.38200000E-05  +3.14000000E-06  +1.34600000E-05  +2.62000000E-06
   -1.02500000E-05  -8.00000000E-07  -1.00600000E-05  -1.93700000E-05  +2.09700000E-05
   -6.90000000E-06  -2.98000000E-06  +5.59000000E-06  -8.10000000E-06  -9.00000000E-07
   -1.78500000E-05  -8.61000000E-06  -1.13600000E-05  -1.16400000E-05  +4.51000000E-06
   +1.00000000E-07  +4.77000000E-06  +6.23000000E-06  -4.37000000E-05  +7.01000000E-05
   +3.99100000E-05  -1.45600000E-05  -1.08500000E-05  +1.57300000E-05  +1.45800000E-05
   -3.12000000E-05  +2.97900000E-05  -2.37000000E-06  +4.68900000E-05  +7.00600000E-05
   +6.77300000E-05  -6.41600000E-05  +1.99050000E-04  +1.00519000E-03  +1.22032000E-03
   +1.46064000E-03  -2.83186000E-03  -9.94320000E-04  -1.58297000E-03  -4.25711000E-03
   +1.14554000E-03  -1.54486000E-03  -1.27361100E-01  -1.02874890E-01  -2.01818170E-01
   +1.32511870E-01  -2.82920000E-04  -1.51576000E-03  +3.56987000E-03  -3.56500000E-05
   -1.09116000E-03  -8.70510000E-04  -1.36100000E-05  +6.78200000E-05  +1.50340000E-04
   -5.88490000E-04  -7.27530000E-04  -2.27930000E-04  +7.64380000E-04  -8.66940000E-04
   +1.16654000E-03  -5.06800000E-05  -5.88900000E-05  +1.84520000E-04  -1.47100000E-05
   +2.32600000E-05  +3.54500000E-05  +3.44120000E-04  +3.40470000E-04  +1.42310000E-04
   +1.46400000E-05  -5.80000000E-07  -3.29400000E-05  -9.15000000E-06  +1.53500000E-05
   +1.12900000E-05  -2.38300000E-05  +1.14000000E-06  +5.81000000E-06  +7.52400000E-05
   +4.66000000E-05  +3.50000000E-06  +6.14000000E-06  -1.39200000E-05  -1.59800000E-05
   -2.30000000E-06  +1.27800000E-05  -2.90000000E-06  -7.49600000E-05  -6.20400000E-05
   -4.89000000E-06  +5.14400000E-05  -2.50000000E-05  -1.83200000E-05  -1.28820000E-04
   +2.23490000E-04  -9.37110000E-04  +1.00800000E-05  +1.38400000E-05  +1.04000000E-06
   -2.02000000E-06  -6.57000000E-06  -3.57000000E-06  -4.18000000E-06  -2.25000000E-06
   +6.46000000E-06  +1.76700000E-05  -5.36000000E-06  -3.53000000E-06  -3.34000000E-06
   +2.31000000E-06  +2.17000000E-06  +9.63000000E-06  +8.20000000E-07  +2.12000000E-05
   -1.20000000E-06  +3.00000000E-06  +4.19000000E-06  -5.14000000E-06  -4.11000000E-06
   -1.24600000E-05  +5.98000000E-05  +4.10000000E-07  -2.38900000E-05  -6.75000000E-06
   -4.31600000E-05  +2.77300000E-05  -2.29600000E-05  +8.79000000E-06  -3.32400000E-05
   +4.16700000E-05  +3.83900000E-05  +2.87300000E-05  +2.25000000E-06  -8.49000000E-05
   +9.16100000E-05  -3.21240000E-04  -3.12400000E-05  -8.93910000E-04  +5.64030000E-04
   +7.16560000E-04  +1.10600000E-05  +1.84225100E-02  +6.32471000E-03  +3.21355300E-02
   -1.21731150E-01  -1.25451290E-01  -1.77469610E-01  +1.02939490E-01  +1.22150940E-01
   +5.32500000E-04  -1.00289000E-03  +1.08108000E-03  +5.45420000E-04  +7.21100000E-04
   -4.47300000E-05  -1.34880000E-04  -4.83830000E-04  +1.43640000E-04  +8.12240000E-04
   +8.65570000E-04  +2.87740000E-04  -2.30692000E-03  +1.55820000E-03  -8.76650000E-04
   -9.97500000E-05  +1.29770000E-04  +8.60100000E-05  +7.85800000E-05  -5.05900000E-05
   +6.13500000E-05  +3.25240000E-04  -7.88160000E-04  +4.38260000E-04  +3.47000000E-06
   -1.21380000E-04  -2.73000000E-05  +2.12000000E-06  +2.38100000E-05  +3.48500000E-05
   +1.87600000E-05  -3.60500000E-05  -2.66400000E-05  -1.02970000E-04  -8.59500000E-05
   -1.93900000E-05  +3.95000000E-05  +5.38200000E-05  +5.23000000E-06  -2.59300000E-05
   +2.76100000E-05  +3.35000000E-05  +1.29230000E-04  +9.52900000E-05  +5.00000000E-08
   +8.60500000E-05  -4.46100000E-05  -2.50200000E-05  -5.93870000E-04  -1.08777000E-03
   -1.22192000E-03  -1.98800000E-05  -1.85900000E-05  +2.00000000E-08  -1.97000000E-06
   +7.79000000E-06  +3.89000000E-06  -2.06900000E-05  -1.39200000E-05  -4.59100000E-05
   -3.06000000E-06  -1.68300000E-05  +2.79000000E-06  +1.73000000E-05  +6.30000000E-07
   -1.48000000E-06  +3.00900000E-05  -4.05000000E-05  +7.06000000E-06  -8.80000000E-06
   +2.67500000E-05  +3.68000000E-06  -2.11000000E-05  +2.66000000E-06  -2.81600000E-05
   +8.69000000E-06  +3.23300000E-05  +2.70000000E-06  -1.16800000E-05  +1.33600000E-05
   +2.73800000E-05  +2.84500000E-05  -4.14600000E-05  -3.42400000E-05  -2.19000000E-06
   -2.00400000E-05  +1.16600000E-05  +2.10900000E-05  +1.12390000E-04  +5.21800000E-05
   +4.86030000E-04  -1.20532000E-03  -1.66759000E-03  -3.45510000E-04  +5.95450000E-04
   +1.07710000E-03  -1.16967300E-02  -3.33194000E-03  -2.68652900E-02  -1.90533560E-01
   -1.38828140E-01  -3.11670490E-01  +2.02764750E-01  +1.42951450E-01  +3.39194650E-01
end_hess

