# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.95895720    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -8.90740321E+00  -3.59170402E+00  -7.50456877E-01
   006   -6.88481084E+00  -2.02490349E+00  -5.20643161E-01
   006   -4.99438875E+00  -1.87504363E+00  -2.33954740E+00
   006   -2.97890709E+00  -2.50026300E-01  -1.99317315E+00
   006   -2.77542262E+00  +1.27071089E+00  +1.46246336E-01
   006   -4.68568571E+00  +1.08686655E+00  +1.93849733E+00
   006   -6.72031807E+00  -5.36695837E-01  +1.62543398E+00
   006   -5.33406052E-01  +3.08509426E+00  +3.85421428E-01
   006   -9.03760314E-01  +5.20999737E+00  -1.55752951E+00
   006   -3.85454217E-01  +4.31391483E+00  +3.01186686E+00
   006   +1.92928058E+00  +1.62654929E+00  -4.46831121E-02
   006   +3.80637848E+00  +2.41610839E+00  -1.69064650E+00
   006   +6.04323099E+00  +1.05987108E+00  -1.96206326E+00
   006   +6.44479953E+00  -1.11599391E+00  -5.87112300E-01
   006   +4.56411082E+00  -1.93164319E+00  +1.07624855E+00
   006   +2.35377868E+00  -5.82154317E-01  +1.33592576E+00
   008   +8.61766062E+00  -2.44316344E+00  -8.56684967E-01
   001   -8.80080770E+00  -4.49632297E+00  -2.31221951E+00
   001   -5.09335144E+00  -3.03819269E+00  -4.02350729E+00
   001   -1.50776023E+00  -1.84598577E-01  -3.41468854E+00
   001   -4.61757569E+00  +2.22062264E+00  +3.63631364E+00
   001   -8.19033800E+00  -6.60922815E-01  +3.03953402E+00
   001   -2.72343539E+00  +6.11935699E+00  -1.23368914E+00
   001   +5.62924074E-01  +6.64861912E+00  -1.38659720E+00
   001   -8.92420021E-01  +4.49021304E+00  -3.48736938E+00
   001   -2.50587204E-01  +2.90632933E+00  +4.51018856E+00
   001   +1.29344697E+00  +5.50263057E+00  +3.11294021E+00
   001   -2.02828289E+00  +5.50459730E+00  +3.37893690E+00
   001   +3.56203752E+00  +4.10832362E+00  -2.80529803E+00
   001   +7.49643212E+00  +1.68503408E+00  -3.25606727E+00
   001   +9.06097190E-01  -1.27596664E+00  +2.61172092E+00
   001   +8.54360316E+00  -3.88752087E+00  +2.37909179E-01
   008   +5.08864492E+00  -4.11064549E+00  +2.36175300E+00
   001   +3.69187848E+00  -4.56240862E+00  +3.41522068E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.33000000E-06  +2.45000000E-06  +1.82000000E-06
   -1.24000000E-06  +2.17000000E-06  +2.07000000E-06
   +5.10000000E-07  +1.25000000E-06  +1.25000000E-06
   -1.67000000E-06  -3.80000000E-07  +3.75000000E-06
   -2.60000000E-07  +1.96000000E-06  -2.33000000E-06
   +8.10000000E-07  +8.00000000E-07  -2.15000000E-06
   +1.20000000E-06  +1.92000000E-06  +5.40000000E-07
   +2.06000000E-06  -1.99000000E-06  -7.30000000E-07
   +1.25000000E-06  -1.14000000E-06  +6.30000000E-07
   +5.70000000E-07  -5.00000000E-08  -1.63000000E-06
   -8.00000000E-08  -2.10000000E-07  -2.50000000E-06
   +6.80000000E-07  -3.15000000E-06  +6.00000000E-08
   -1.42000000E-06  -1.95000000E-06  +3.80000000E-07
   -4.10000000E-07  -9.10000000E-07  -6.20000000E-07
   -1.40000000E-07  -3.41000000E-06  +4.06000000E-06
   -4.30000000E-07  +1.97000000E-06  -1.49000000E-06
   +1.35000000E-06  -3.31000000E-06  -3.00000000E-07
   -2.45000000E-06  +2.70000000E-07  +9.40000000E-07
   -1.58000000E-06  -1.46000000E-06  -8.80000000E-07
   +9.40000000E-07  -1.90000000E-06  -1.68000000E-06
   +1.11000000E-06  +5.16000000E-06  +2.03000000E-06
   -2.32000000E-06  +3.56000000E-06  +3.11000000E-06
   +2.20000000E-07  +1.26000000E-06  -1.18000000E-06
   +6.26000000E-06  -1.41000000E-06  -2.34000000E-06
   +2.21000000E-06  +1.00000000E-07  -3.18000000E-06
   +1.71000000E-06  +2.00000000E-08  +9.80000000E-07
   +3.04000000E-06  +1.50000000E-06  -1.01000000E-06
   -2.20000000E-07  +1.61000000E-06  -2.20000000E-07
   -4.24000000E-06  +1.89000000E-06  -1.89000000E-06
   +2.37000000E-06  -1.99000000E-06  -3.14000000E-06
   -3.14000000E-06  -3.90000000E-07  +2.77000000E-06
   +8.00000000E-08  -3.35000000E-06  +1.40000000E-07
   -3.21000000E-06  +1.20000000E-07  +8.20000000E-07
   -2.26000000E-06  -1.00000000E-06  +1.95000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.99310210E-01  +1.64550800E-01  +3.11554150E-01  -4.22761200E-02  +2.69909630E-01
   +5.03909050E-01  -2.20959260E-01  -1.33964640E-01  -1.51445800E-02  +5.63317900E-01
   -1.09914990E-01  -1.48705460E-01  -4.47975500E-02  +2.00996880E-01  +4.30244660E-01
   +2.34721800E-02  -1.74825900E-02  -9.73381700E-02  -1.23636870E-01  +1.97974470E-01
   +6.07171510E-01  -3.79452100E-02  -1.52394300E-02  +2.77150100E-02  -2.02339020E-01
   -4.43511500E-02  +7.66370000E-02  +5.49860900E-01  -3.45569300E-02  -2.31172000E-03
   +1.90535300E-02  -3.80107000E-03  -1.00819860E-01  -4.45354500E-02  +2.17727730E-01
   +4.20397220E-01  -1.87430000E-03  -1.86337000E-03  +8.91683000E-03  +1.38908960E-01
   -5.41060000E-04  -2.21332290E-01  -1.20422990E-01  +2.19946130E-01  +5.96595700E-01
   +3.33230000E-03  -2.67397000E-03  +2.54410000E-04  -4.54582100E-02  -5.23506000E-03
   +4.35728600E-02  -2.48626590E-01  -1.52360740E-01  -3.22992500E-02  +5.94460140E-01
   +1.54258000E-03  +2.92214000E-03  -8.21242000E-03  -3.36311100E-02  +1.86348300E-02
   +6.08487700E-02  -1.18683410E-01  -1.81310020E-01  -6.05664800E-02  +2.07731110E-01
   +4.03020650E-01  +6.64534000E-03  -3.80366000E-03  -5.82258000E-03  -5.53080000E-04
   +3.04307300E-02  +5.00932800E-02  +1.96208900E-02  -2.43746400E-02  -1.18773440E-01
   -1.55866860E-01  +1.75707810E-01  +5.79095980E-01  -1.88745000E-03  -2.29148000E-03
   -3.05498000E-03  -1.01678000E-02  +1.39305800E-02  +2.71108000E-02  +2.23674400E-02
   -8.14520000E-03  -2.78565500E-02  -1.14057060E-01  -4.39437900E-02  -2.14889100E-02
   +5.25512370E-01  -1.87657000E-03  -1.02301000E-03  +2.34421000E-03  +1.47318000E-02
   -1.01910700E-02  -2.24699300E-02  -3.32894000E-02  -2.34930400E-02  -1.29531200E-02
   -1.15161400E-02  -1.60043280E-01  -1.24562070E-01  +1.55522390E-01  +3.99606760E-01
   -3.62884000E-03  +1.86755000E-03  +5.43772000E-03  +2.88915600E-02  -2.16798100E-02
   -7.08690300E-02  -6.92772400E-02  -4.09059700E-02  +1.96319100E-02  +3.05657800E-02
   -8.90155100E-02  -2.40618530E-01  -1.31364580E-01  +1.54481880E-01  +5.66009630E-01
   +5.72940000E-04  +2.67276000E-03  +9.23887000E-03  +2.60976200E-02  -3.34552600E-02
   -7.84880000E-02  -5.70631900E-02  -2.46307800E-02  +1.95169000E-02  +3.42260500E-02
   +4.99642800E-02  +5.06973500E-02  -2.17807790E-01  -5.05131200E-02  +8.61608300E-02
   +5.42148940E-01  -4.78650000E-04  +4.49892000E-03  -5.79630000E-04  -5.44190000E-03
   -2.79941600E-02  -4.12046100E-02  -2.27454300E-02  -1.37709300E-02  +8.87593000E-03
   +2.43157200E-02  +2.55673700E-02  +5.94920000E-04  -1.76068200E-02  -9.94992300E-02
   -3.05535500E-02  +2.02413260E-01  +4.21929880E-01  +4.14983000E-03  -3.96909000E-03
   -5.65716000E-03  -3.38904200E-02  -1.10507600E-02  +2.18863500E-02  +2.13424600E-02
   +1.02586100E-02  -1.08008900E-02  +1.10748100E-02  -2.68425600E-02  -4.49902700E-02
   +1.37536190E-01  +3.79471000E-03  -2.10467220E-01  -1.21010860E-01  +2.13038100E-01
   +6.08272210E-01  -4.10260000E-03  -3.29801900E-02  -3.88083200E-02  -1.14830650E-01
   -5.72790000E-04  +4.68577500E-02  +3.39879700E-02  +2.31940600E-02  +8.44524000E-03
   -1.81435400E-02  -2.39497100E-02  -2.08969900E-02  -4.08414100E-02  -7.12437000E-03
   +4.14280200E-02  -2.43592150E-01  -1.46913850E-01  -2.86334200E-02  +5.89663680E-01
   -1.42980300E-02  -2.39434900E-02  -3.36643200E-02  -3.83569800E-02  -1.55686510E-01
   -8.99936400E-02  +4.62679900E-02  +2.57523200E-02  -2.36166600E-02  -2.24381500E-02
   -3.72937500E-02  -2.92165500E-02  -3.17697400E-02  +1.85275000E-02  +5.16175300E-02
   -1.13274570E-01  -1.77737030E-01  -5.74713500E-02  +2.17482770E-01  +4.00399830E-01
   -9.73524000E-03  -1.33320900E-02  -2.48017000E-03  -1.19333200E-02  -1.31200490E-01
   -2.63360910E-01  +4.43428400E-02  +1.58023000E-03  -3.72800000E-02  -1.85363400E-02
   -2.74248200E-02  -2.60908100E-02  +2.64661000E-03  +2.55113000E-02  +4.30188900E-02
   +2.29399200E-02  -2.19766900E-02  -1.18899100E-01  -1.63430370E-01  +1.85793280E-01
   +5.98493130E-01  +1.47685000E-03  +1.34281000E-03  -5.56700000E-05  -2.24727000E-03
   -1.63430000E-04  +1.21934000E-03  +4.12586000E-03  +1.58600000E-04  +1.50336000E-03
   -2.39251000E-03  -6.91083000E-03  -6.76957000E-03  -1.34028210E-01  -4.65171300E-02
   +8.01580000E-04  -1.65049600E-02  -1.45476300E-02  -3.72270000E-04  +1.03986000E-03
   -1.64026000E-03  +3.78090000E-03  +4.74221610E-01  +7.61620000E-04  +1.35790000E-04
   +3.69980000E-04  -4.72950000E-04  -7.59980000E-04  -5.52300000E-05  -2.58910000E-04
   +2.69838000E-03  -3.47740000E-03  -1.56657100E-02  -1.35774100E-02  -4.87135000E-03
   -4.79642600E-02  -1.11466220E-01  -1.08898500E-02  -4.50688000E-03  +1.79525000E-03
   +3.70962000E-03  -6.83750000E-04  +4.26659000E-03  -3.08908000E-03  -3.93490000E-04
   +4.81861970E-01  +6.17640000E-04  +1.08406000E-03  +3.77160000E-04  +8.86500000E-05
   -7.82010000E-04  -1.72805000E-03  +1.49767000E-03  -4.72648000E-03  -3.22444000E-03
   -2.19892000E-02  -1.62589300E-02  +1.67278000E-03  -2.51784000E-03  -1.31340500E-02
   -8.62053300E-02  +1.31890200E-02  +1.34767700E-02  +7.32950000E-03  +4.25123000E-03
   -1.75440000E-03  -9.80580000E-04  +4.03020000E-04  -3.49570000E-04  +4.81029540E-01
   -1.16703000E-03  -1.02535000E-03  -2.91580000E-04  +5.69050000E-04  +6.73510000E-04
   +5.93850000E-04  -2.24070000E-04  +6.02140000E-04  +2.48410000E-04  -4.40650000E-04
   -1.09736000E-03  +5.56990000E-04  +7.40600000E-05  -2.05322500E-02  +1.79200300E-02
   -7.23180000E-04  -1.67960000E-03  -1.04204000E-03  -1.38387000E-03  +2.99630000E-04
   -1.05872000E-03  -7.72284000E-02  +6.52492000E-03  -6.07016000E-03  +5.83492980E-01
   -4.73630000E-04  -4.69330000E-04  -1.61960000E-04  +1.40760000E-04  +4.65400000E-04
   +5.78700000E-04  -7.31600000E-05  +7.91110000E-04  +1.78430000E-04  -8.26300000E-05
   -5.02720000E-04  +1.14355000E-03  -6.99195000E-03  -2.52940300E-02  +1.55617900E-02
   +1.55670000E-03  -8.63690000E-04  -9.73700000E-04  -8.64350000E-04  +3.70500000E-05
   -9.55440000E-04  +1.17846900E-02  -1.27302340E-01  +5.00615200E-02  +1.37729000E-02
   +5.15860600E-01  -5.58960000E-04  -4.75240000E-04  -2.02290000E-04  +1.83850000E-04
   +2.63120000E-04  +5.11950000E-04  +2.99890000E-04  +1.58490000E-04  -1.88670000E-04
   -1.63270000E-03  -1.34431000E-03  -2.03000000E-04  +5.71089000E-03  +4.77837000E-03
   +1.31276000E-03  -4.87370000E-04  -3.60220000E-04  -2.12290000E-04  -2.16550000E-04
   -2.84170000E-04  -3.58500000E-04  -9.56268000E-03  +4.66077400E-02  -1.19616020E-01
   -1.36654500E-02  +6.22290600E-02  +5.38659390E-01  -5.23800000E-04  -4.22850000E-04
   -8.12700000E-05  +3.74480000E-04  +2.54050000E-04  +1.41620000E-04  +3.63320000E-04
   -8.76080000E-04  -9.93670000E-04  -4.39708000E-03  -2.89572000E-03  +8.61190000E-04
   -1.84552000E-03  -1.21947000E-02  -2.54862000E-02  -1.20053000E-03  -6.18280000E-04
   -8.63180000E-04  +1.18590000E-04  -2.48640000E-04  -7.38550000E-04  -7.57228400E-02
   -7.69380000E-04  -1.22922000E-03  +2.48830000E-04  -9.36070000E-04  -4.60996000E-03
   +5.85898100E-01  -9.28200000E-05  -9.32000000E-05  -3.36600000E-05  -8.40700000E-05
   +1.17810000E-04  -1.07600000E-04  +1.92160000E-04  -5.20910000E-04  -8.00850000E-04
   -3.48034000E-03  -1.05519000E-03  +5.22300000E-04  -4.69097000E-03  -1.19450700E-02
   -2.13622300E-02  -3.77150000E-04  -8.33140000E-04  +4.87230000E-04  +5.39910000E-04
   -3.22940000E-04  -7.22770000E-04  -4.21857000E-03  -9.23082400E-02  -3.86365000E-02
   +9.72520000E-04  +8.79692000E-03  +2.33770400E-02  -2.57692000E-03  +5.62237890E-01
   +3.26010000E-04  +2.55330000E-04  +2.80000000E-06  -2.92630000E-04  -1.20810000E-04
   +2.51350000E-04  +4.53140000E-04  +1.77810000E-04  +3.07500000E-05  +6.79490000E-04
   +8.26830000E-04  +2.10720000E-04  -5.50943000E-03  -4.15312000E-03  -3.04960000E-03
   +1.06264000E-03  +7.96340000E-04  +3.72930000E-04  +2.96410000E-04  -9.29000000E-06
   -3.06790000E-04  -6.93445000E-03  -3.58383700E-02  -1.55506290E-01  -2.28446000E-03
   -5.13129000E-03  -3.52321400E-02  -8.79478000E-03  -5.28892700E-02  +4.88749360E-01
   +1.08230000E-04  +6.84300000E-05  -2.81600000E-05  -2.50600000E-04  +3.17400000E-05
   +5.06420000E-04  +3.92450000E-04  +6.24180000E-04  +6.41940000E-04  -9.78690000E-04
   +5.48850000E-04  -3.93510000E-04  -3.51658200E-02  +5.34443000E-03  +6.36894000E-03
   -9.22620000E-04  -1.47660000E-04  -2.19578000E-03  -1.15860000E-04  -9.81160000E-04
   +5.22980000E-04  -1.45546030E-01  +4.13484500E-02  +1.47089600E-02  -5.14203000E-03
   +8.21726000E-03  -3.06479000E-03  -3.07308000E-03  +6.23875000E-03  +9.58703000E-03
   +5.59595510E-01  -7.66060000E-04  -7.46580000E-04  -2.44260000E-04  +2.24070000E-04
   +8.17360000E-04  +6.63110000E-04  +1.74270000E-04  -8.76600000E-05  +3.47400000E-05
   -2.30250000E-03  -5.85540000E-04  -4.89090000E-04  -1.38621100E-02  +1.25048900E-02
   +5.50612000E-03  -1.58513000E-03  -2.53635000E-03  -1.52142000E-03  -5.96580000E-04
   -1.16743000E-03  +5.00320000E-04  +3.84984400E-02  -1.05270330E-01  +3.31684000E-03
   +2.33000900E-02  -1.60566700E-02  -2.78812000E-03  +1.37900800E-02  -1.15368200E-02
   -9.85784000E-03  -7.70135500E-02  +5.12726940E-01  -3.31020000E-04  -3.75350000E-04
   +9.82000000E-06  +2.45710000E-04  +1.76770000E-04  -3.09000000E-05  -3.07890000E-04
   +3.06510000E-04  +2.93100000E-05  -2.10009000E-03  -9.51990000E-04  +3.40600000E-05
   +2.62448000E-03  +1.00694000E-03  -3.85250000E-04  +8.84700000E-05  +1.87700000E-04
   -3.36700000E-05  -5.15300000E-05  +5.71000000E-05  -8.53000000E-05  +1.76475900E-02
   +1.49765000E-03  -8.00023400E-02  -2.05871400E-02  +1.18802200E-02  +4.18590000E-03
   +2.72395200E-02  -1.86439400E-02  -9.28932000E-03  -1.59978670E-01  -1.90708390E-01
   +4.16808290E-01  -2.51120000E-04  -1.77630000E-04  -2.38900000E-05  +3.15260000E-04
   +1.15790000E-04  -3.93010000E-04  -3.51420000E-04  -3.79080000E-04  +2.12190000E-04
   +6.98090000E-04  +1.50200000E-05  +4.58710000E-04  -1.10334000E-03  +1.62854000E-03
   +6.68070000E-04  -7.81890000E-04  -8.20630000E-04  -9.08100000E-05  +1.41700000E-04
   +1.06210000E-04  +3.03600000E-04  -1.79183500E-02  -4.20655000E-03  +1.46764400E-02
   -1.75298000E-03  -2.60700000E-05  +1.35822000E-03  -9.37860000E-04  -1.28167000E-03
   -1.05251000E-03  -2.23163410E-01  -5.31222000E-03  +9.37151200E-02  +5.82486790E-01
   +2.47320000E-04  +1.85050000E-04  +5.52800000E-05  -2.58760000E-04  -8.53700000E-05
   +1.03240000E-04  +2.23430000E-04  +2.35930000E-04  -5.28100000E-05  -2.37240000E-04
   +7.31600000E-05  +2.13400000E-05  +1.27720000E-03  -2.33310000E-03  -1.21681000E-03
   +5.80290000E-04  +7.36920000E-04  +1.57360000E-04  +3.31000000E-06  +7.76400000E-05
   -2.09260000E-04  +1.07635000E-02  +1.03272400E-02  -1.03873900E-02  +1.01430000E-03
   -1.82820000E-04  -7.31100000E-04  +1.85161000E-03  -1.11211000E-03  -2.05630000E-04
   -5.47383200E-02  -1.31214130E-01  +7.85969600E-02  -1.28499410E-01  +5.70462070E-01
   -1.49580000E-04  -1.61840000E-04  -1.26700000E-05  -1.13690000E-04  +1.60610000E-04
   +3.89200000E-04  +2.51970000E-04  +3.37660000E-04  +1.40250000E-04  -6.85300000E-04
   -9.93900000E-05  -7.85650000E-04  -2.04971000E-03  +1.36900000E-04  +2.54830000E-04
   +2.79490000E-04  +2.37620000E-04  -7.45700000E-05  -2.30750000E-04  -4.66750000E-04
   -9.45400000E-05  +5.06466000E-03  -2.32637000E-03  +1.25407000E-03  -4.26560000E-04
   -8.30790000E-04  -3.94240000E-04  -3.67960000E-04  +4.82950000E-04  +9.40300000E-05
   +1.29962290E-01  +5.20970500E-02  -1.77718640E-01  -1.60731870E-01  -2.48063840E-01
   +4.10294440E-01  -1.01890000E-04  -9.14700000E-05  -6.64000000E-05  +3.64800000E-05
   +1.18680000E-04  +2.72870000E-04  +2.06710000E-04  +8.65600000E-05  -1.64920000E-04
   -3.08330000E-04  +1.41700000E-04  +2.08500000E-05  -3.97320000E-04  +5.96380000E-04
   +2.68890000E-04  +1.92620000E-04  +1.55860000E-04  -2.19590000E-04  -9.77600000E-05
   -2.08240000E-04  -1.32010000E-04  +5.11270000E-04  -1.20194000E-03  +3.88482000E-03
   +1.89300000E-04  -5.55390000E-04  +4.61700000E-05  -1.37153000E-03  +7.23460000E-04
   +5.76300000E-05  -4.56693500E-02  -2.01991400E-02  +4.45022600E-02  -2.67788520E-01
   +1.32626750E-01  +2.16062000E-02  +6.29511860E-01  +1.60080000E-04  +1.92680000E-04
   +7.31400000E-05  +1.94000000E-05  -2.37390000E-04  -3.93100000E-04  -2.54560000E-04
   -1.77380000E-04  +1.49630000E-04  +5.44750000E-04  -4.54000000E-05  -1.96500000E-05
   +7.88300000E-04  -5.05070000E-04  -3.93070000E-04  -2.26550000E-04  -2.36570000E-04
   +3.29070000E-04  +1.78040000E-04  +3.66740000E-04  +1.67390000E-04  +1.44500000E-05
   +1.53361000E-03  +3.30061000E-03  +4.90280000E-04  -6.01910000E-04  -1.11100000E-04
   -3.54800000E-05  -4.09340000E-04  +2.82220000E-04  +1.83745300E-02  +4.78744900E-02
   -4.02851800E-02  +8.21757800E-02  -1.64520140E-01  +3.01224600E-02  -1.18162590E-01
   +5.41901080E-01  +1.60900000E-05  +1.78900000E-05  +2.02100000E-05  -2.23100000E-05
   -2.86000000E-05  +4.25700000E-05  +1.97200000E-05  +6.28100000E-05  +1.32200000E-05
   +8.54600000E-05  -9.35100000E-05  -2.63650000E-04  +9.31400000E-04  -7.04730000E-04
   -3.95640000E-04  +2.29880000E-04  +2.09370000E-04  +1.79080000E-04  -3.68100000E-05
   +2.98700000E-05  -9.11500000E-05  +3.68041000E-03  +4.70428000E-03  +1.90386000E-03
   -6.28070000E-04  +4.80750000E-04  -3.45700000E-05  -1.25522000E-03  +7.77070000E-04
   +1.44460000E-04  +1.60094800E-02  -1.92279900E-02  +1.08806500E-02  +5.82501200E-02
   +2.14476000E-03  -9.34682500E-02  -1.99015300E-01  -2.38089860E-01  +4.17528480E-01
   +8.99920000E-04  +7.54710000E-04  +1.31090000E-04  -7.36500000E-04  -5.90330000E-04
   -1.41020000E-04  +2.86030000E-04  -6.05200000E-05  -3.33550000E-04  -5.90400000E-05
   +1.59540000E-04  +2.21940000E-04  -1.62570000E-04  -5.68480000E-04  -7.24100000E-05
   +6.48200000E-05  +2.46990000E-04  +1.29660000E-04  +1.81260000E-04  +2.32090000E-04
   +1.14860000E-04  -2.63147000E-03  +3.36580000E-04  -1.21100000E-05  +3.53500000E-04
   +2.39380000E-04  -2.49900000E-04  +7.67990000E-04  -2.20040000E-04  +8.73700000E-05
   -6.82037000E-03  -2.40186600E-02  +2.12441300E-02  +2.27518200E-02  +2.39722200E-02
   -2.91805000E-02  -1.25575190E-01  +6.16361200E-02  -9.95653000E-03  +6.08341580E-01
   -4.52350000E-04  -4.12450000E-04  -1.15130000E-04  +2.42720000E-04  +4.12110000E-04
   +4.01670000E-04  +1.44160000E-04  +1.53250000E-04  -2.07400000E-05  -3.30330000E-04
   -5.03700000E-05  -2.12850000E-04  -4.63670000E-04  +8.80410000E-04  +3.80890000E-04
   +1.89300000E-04  +1.66730000E-04  -2.51660000E-04  -2.10380000E-04  -4.32810000E-04
   -1.97370000E-04  -5.77040000E-04  -1.18368000E-03  +8.58360000E-04  -2.15290000E-04
   -9.90000000E-07  +3.20400000E-05  -8.38150000E-04  +6.67530000E-04  -2.18230000E-04
   -2.04476200E-02  -3.42465200E-02  +3.51637300E-02  +6.40422000E-02  -2.92917500E-02
   -1.29182500E-02  +2.61759000E-03  -2.62490770E-01  +1.45193100E-01  -1.44988620E-01
   +6.00355280E-01  -1.61490000E-04  -1.22960000E-04  +7.33000000E-06  +2.24390000E-04
   +4.46100000E-05  -2.88270000E-04  -3.00210000E-04  -1.71390000E-04  +1.92460000E-04
   +3.69440000E-04  -1.29280000E-04  +9.99600000E-05  +4.25110000E-04  -8.83000000E-05
   -2.19270000E-04  -3.17390000E-04  -2.70400000E-04  +1.42300000E-04  +1.26090000E-04
   +1.81640000E-04  +1.14020000E-04  +1.17713000E-03  +1.54840000E-04  -1.38161000E-03
   -3.97600000E-05  +2.53100000E-05  +2.57210000E-04  +3.64210000E-04  -4.90630000E-04
   +2.29720000E-04  +1.81132800E-02  +3.71971000E-02  -4.00622000E-02  -5.94083800E-02
   +9.13861000E-03  +2.79172100E-02  +3.37243200E-02  +1.11164040E-01  -1.64991550E-01
   -1.54750650E-01  -2.47607090E-01  +4.19579000E-01  +5.70100000E-05  +7.22900000E-05
   +5.28000000E-05  +2.90400000E-05  -1.66810000E-04  -4.13920000E-04  -3.57320000E-04
   -2.70740000E-04  +1.95050000E-04  +4.99190000E-04  -1.96060000E-04  +1.88840000E-04
   +4.94360000E-04  +3.25500000E-05  -4.02580000E-04  -4.08440000E-04  -4.66820000E-04
   +2.72730000E-04  +1.96980000E-04  +3.21030000E-04  +2.05480000E-04  +3.79163000E-03
   -3.50940000E-04  +1.37248000E-03  +5.79620000E-04  -3.40750000E-04  +3.38890000E-04
   -2.15100000E-04  -7.12800000E-05  +2.27170000E-04  +1.60798700E-02  +6.83592400E-02
   -5.99383700E-02  -6.50779000E-02  +3.87067000E-03  +3.20854100E-02  +4.99456200E-02
   -5.96622000E-02  +1.70787600E-02  -1.98677420E-01  +4.15974000E-03  +6.83819600E-02
   +6.49892700E-01  -9.94860000E-04  -9.35560000E-04  -1.56390000E-04  +8.13170000E-04
   +7.08640000E-04  +3.70610000E-04  -9.48600000E-05  +9.23100000E-05  +2.61970000E-04
   -1.29420000E-04  +2.88670000E-04  -1.07030000E-04  -7.09410000E-04  +5.85800000E-04
   -2.00980000E-04  +3.97850000E-04  +2.96740000E-04  -5.21100000E-04  -1.70740000E-04
   -4.29180000E-04  -2.64500000E-04  +8.38740000E-04  -1.58610000E-03  +4.98055000E-03
   +7.26530000E-04  -2.72480000E-04  -3.14360000E-04  -9.51110000E-04  +6.48710000E-04
   +3.81910000E-04  +2.54016500E-02  -2.54931600E-02  +5.04591000E-03  +2.51463000E-03
   +2.10961000E-03  -4.27018000E-03  -1.96147400E-02  -1.03181800E-02  +2.08673100E-02
   -6.89190300E-02  -1.15212780E-01  +6.97190500E-02  -1.44808500E-01  +5.49057610E-01
   +6.38980000E-04  +5.75870000E-04  +6.10500000E-05  -5.77580000E-04  -3.82910000E-04
   +7.45700000E-05  +3.48350000E-04  +1.88890000E-04  -3.73620000E-04  -3.06630000E-04
   -3.81900000E-05  -1.00900000E-05  +4.06710000E-04  -2.03220000E-04  -1.40940000E-04
   +1.67620000E-04  +2.22030000E-04  +1.52760000E-04  +3.97000000E-06  +4.35800000E-05
   -1.98000000E-06  -2.11790000E-04  +4.52036000E-03  +6.43160000E-04  -3.98800000E-04
   +3.77370000E-04  +1.38390000E-04  +1.59620000E-04  +1.57490000E-04  -1.29500000E-04
   -2.65647200E-02  -1.90784900E-02  +3.18168000E-02  +3.39187200E-02  -5.00423000E-03
   -1.68561800E-02  -1.24593600E-02  +4.35644200E-02  -2.22902300E-02  +1.21154170E-01
   +2.79049100E-02  -1.62799750E-01  -1.77797530E-01  -2.11866160E-01  +3.99504080E-01
   -3.91530000E-04  -3.99690000E-04  -9.59600000E-05  +1.48500000E-04  +3.66510000E-04
   +5.72930000E-04  +4.21030000E-04  +3.13330000E-04  -1.06260000E-04  -1.38438000E-03
   +4.35110000E-04  -5.32290000E-04  -1.64114000E-03  +2.98626000E-03  -1.02384000E-03
   +8.26190000E-04  +7.13240000E-04  -7.74120000E-04  -2.78260000E-04  -6.92180000E-04
   -2.45240000E-04  -5.84037000E-03  +2.43864700E-02  -1.50046100E-02  -5.08015000E-03
   +2.30600000E-03  +1.92092000E-03  -5.94530000E-04  +7.41640000E-04  -1.43495000E-03
   -1.17016830E-01  +1.15321800E-02  +2.24719100E-02  +4.05114600E-02  -1.94315500E-02
   -3.07326000E-03  -2.41700100E-02  +2.66422500E-02  -6.32116000E-03  -4.51223800E-02
   -1.76271800E-02  +4.01917800E-02  -2.87716900E-01  +1.40400660E-01  +2.62308800E-02
   +6.36191580E-01  +1.25180000E-04  +1.37960000E-04  +6.62400000E-05  -2.02740000E-04
   -1.10200000E-04  +1.66060000E-04  +1.48590000E-04  +3.33480000E-04  +1.18670000E-04
   -2.37560000E-04  -3.90170000E-04  -8.76850000E-04  -4.04230000E-04  -6.72480000E-04
   +5.13680000E-04  +1.16400000E-05  +5.23700000E-05  +2.23290000E-04  -1.86080000E-04
   -2.49800000E-04  +1.08770000E-04  +1.02764300E-02  -1.49532300E-02  +6.24828000E-03
   +1.84093000E-03  +1.28160000E-04  -7.35070000E-04  +6.92470000E-04  -3.58670000E-04
   +9.64420000E-04  +6.04583800E-02  -2.39169750E-01  +9.32113600E-02  -5.80856800E-02
   -8.73434000E-03  +4.49076700E-02  +3.29842400E-02  -4.30322100E-02  +1.25073100E-02
   +2.29220900E-02  +4.99096600E-02  -4.69136900E-02  +7.49579700E-02  -1.64983810E-01
   +3.49141600E-02  -1.21718650E-01  +5.33599940E-01  -1.89500000E-05  -1.12000000E-05
   -3.07100000E-05  +5.12000000E-05  +9.45400000E-05  +2.29340000E-04  +2.41300000E-04
   +2.39840000E-04  -4.74500000E-05  -7.26370000E-04  +6.02550000E-04  -1.71740000E-04
   -7.88470000E-04  +1.15200000E-04  +4.05930000E-04  +4.28300000E-04  +2.53190000E-04
   -5.43520000E-04  -8.12400000E-05  +4.57700000E-05  -1.62910000E-04  -3.33520000E-03
   -3.18182000E-03  +6.03276000E-03  +1.78630000E-03  -3.76050000E-04  -3.76880000E-04
   +1.17456000E-03  -1.02725000E-03  -4.28040000E-04  -1.44599000E-02  +1.20435750E-01
   -1.44502960E-01  +2.54082200E-02  +2.32965300E-02  -2.29996700E-02  -1.11142300E-02
   +1.65308700E-02  -6.52887000E-03  +1.02252100E-02  -2.42888000E-02  +1.51752100E-02
   +7.36715300E-02  -1.42571000E-03  -1.00102130E-01  -1.92497850E-01  -2.25300780E-01
   +3.96496030E-01  -1.03615000E-03  -8.84830000E-04  -1.83100000E-04  +7.99480000E-04
   +7.19490000E-04  +2.96470000E-04  -2.29510000E-04  +7.18200000E-05  +2.71650000E-04
   -1.40170000E-04  -8.89700000E-05  -1.36780000E-04  -7.11100000E-05  +9.76030000E-04
   +1.60260000E-04  +1.38100000E-05  -1.08250000E-04  -3.44670000E-04  -2.18400000E-04
   -3.80470000E-04  -2.11530000E-04  +1.89976000E-03  -7.37100000E-04  +4.86100000E-04
   -5.28130000E-04  -1.31990000E-04  +3.60050000E-04  -1.37136000E-03  +5.70180000E-04
   -3.71660000E-04  -1.78454000E-03  +4.74681000E-03  -4.08651000E-03  -1.05969000E-03
   -1.44899000E-03  +4.67248000E-03  -6.89839000E-03  +1.65416100E-02  -4.43601000E-03
   -2.54345930E-01  +8.74895200E-02  +5.74355200E-02  -4.95987500E-02  +3.31864700E-02
   +9.56052000E-03  +4.79960000E-03  -6.15293000E-03  +4.97457000E-03  +3.45925110E-01
   +7.10850000E-04  +6.40070000E-04  +1.28370000E-04  -5.14180000E-04  -5.13180000E-04
   -2.44310000E-04  +1.24710000E-04  -4.50400000E-05  -1.82090000E-04  +1.36030000E-04
   +1.13300000E-04  +1.21700000E-04  +1.01900000E-04  -8.30470000E-04  -1.12520000E-04
   -2.83800000E-05  +5.44000000E-05  +2.40340000E-04  +1.64030000E-04  +3.32930000E-04
   +1.57690000E-04  -1.19214000E-03  +4.95480000E-04  -7.61980000E-04  +3.88390000E-04
   +5.02300000E-05  -2.44710000E-04  +1.00759000E-03  -4.63860000E-04  +2.76560000E-04
   +2.76517000E-03  -8.80950000E-04  -1.03715000E-03  -3.59941000E-03  +6.95010000E-04
   +5.48022000E-03  +4.56316900E-02  -2.65697300E-02  -1.73141000E-03  +1.27824000E-01
   -1.45345740E-01  +3.13753000E-03  +6.08898000E-03  -1.86886000E-03  +4.62817000E-03
   -1.15961000E-03  +7.62000000E-06  +4.78363000E-03  -1.34294200E-01  +4.98829530E-01
   +9.69900000E-05  +8.32100000E-05  +2.59900000E-05  -8.84600000E-05  -5.70100000E-05
   -3.45000000E-06  +4.36500000E-05  +6.48000000E-06  -2.90900000E-05  +1.85400000E-05
   -2.88300000E-05  -4.78400000E-05  -2.24000000E-06  -7.14600000E-05  +1.24890000E-04
   +5.56000000E-06  -2.63200000E-05  +4.59200000E-05  -2.09100000E-05  +3.30000000E-06
   +3.08200000E-05  -2.75660000E-04  -2.25280000E-04  -7.12600000E-05  +5.78900000E-05
   +3.99600000E-05  -4.62400000E-05  +8.74000000E-06  +5.42200000E-05  -4.87500000E-05
   -1.81163000E-03  -2.79517000E-03  +2.05248000E-03  +6.48859000E-03  +4.26169000E-03
   -1.36749000E-03  -2.58789100E-02  +1.50818900E-02  +1.03249000E-02  +2.80639000E-02
   +2.59121100E-02  -7.64212800E-02  +2.90449900E-02  -1.07169000E-02  +6.41420000E-04
   +1.43829000E-03  +7.58063000E-03  -6.74990000E-04  -8.28488800E-02  -2.66642310E-01
   +2.69846820E-01  -3.73635600E-02  +1.68840400E-02  +6.48620100E-02  -2.24058000E-03
   -2.20365900E-02  -3.56800400E-02  +1.31393000E-03  -2.60700000E-05  -2.39962000E-03
   -6.25270000E-04  -1.39670000E-04  -2.32230000E-04  -7.02200000E-05  +2.67220000E-04
   +6.18280000E-04  +1.53898000E-03  -7.12480000E-04  -8.13210000E-04  -4.56520000E-03
   -4.09655000E-03  +8.47240000E-04  -1.69880000E-04  +4.72000000E-06  +1.04960000E-04
   +4.06200000E-05  -4.30000000E-07  -1.55300000E-05  +6.94900000E-05  +3.13700000E-05
   -2.05200000E-05  -2.33900000E-05  +4.26000000E-06  +2.67600000E-05  +1.63700000E-05
   -8.01000000E-06  +1.81700000E-05  +2.97000000E-06  -2.24000000E-06  +1.00600000E-05
   -1.22120000E-04  +4.80700000E-05  +2.34700000E-05  -4.15000000E-06  +6.92500000E-05
   -5.34800000E-05  +1.61600000E-05  +2.66400000E-05  +2.37700000E-05  +1.28150000E-04
   -6.86800000E-05  -7.85000000E-06  +4.31750300E-02  -7.56805000E-03  -1.39703970E-01
   -2.08799490E-01  +5.92490000E-04  -1.97180800E-02  -2.75908400E-02  +3.15663000E-03
   +2.06204000E-03  +1.16164000E-03  +4.92100000E-05  -8.75550000E-04  -3.78710000E-04
   -3.63300000E-05  +3.80680000E-04  +5.65910000E-04  +2.23740000E-04  +7.19910000E-04
   -1.78311000E-03  -4.87545000E-03  -8.22580000E-04  +8.21210000E-04  -1.73900000E-04
   -8.76200000E-05  +1.25200000E-05  +6.80800000E-05  +1.85900000E-05  +2.54700000E-05
   +7.12700000E-05  +1.09700000E-05  -2.64900000E-05  -1.58600000E-05  +9.27800000E-05
   +6.14700000E-05  +3.80800000E-05  -2.99100000E-05  +2.89100000E-05  +1.51000000E-06
   -2.06600000E-05  +3.52000000E-06  -1.56960000E-04  +7.06100000E-05  +3.50400000E-05
   -5.62000000E-06  +2.01960000E-04  -1.33000000E-04  +6.09300000E-05  -1.39500000E-05
   -7.63000000E-06  +1.67170000E-04  -1.27480000E-04  -1.54300000E-05  +9.20573000E-03
   +1.57976930E-01  +2.56336900E-02  -2.36434340E-01  -4.09495980E-01  +6.09650000E-04
   -1.99556000E-03  -6.57242000E-03  +2.62812000E-03  +4.66855000E-03  +3.51273000E-03
   +4.08400000E-05  -2.26960000E-04  -1.01273000E-03  +1.21250000E-04  +1.34020000E-04
   +3.55360000E-04  +6.14320000E-04  -7.60290000E-04  -1.25540000E-04  -3.34140000E-04
   -3.82100000E-05  +2.35567000E-03  -1.53090000E-04  -3.48400000E-05  -1.57190000E-04
   +1.33290000E-04  +7.34900000E-05  +7.16000000E-05  +3.51200000E-05  +2.82000000E-06
   -2.25200000E-05  -3.87000000E-06  +5.72500000E-05  +2.50700000E-05  +8.59000000E-06
   -1.40900000E-05  +8.40000000E-07  +1.78800000E-05  -1.94500000E-05  -8.33000000E-06
   -5.94600000E-05  +3.78500000E-05  +5.59000000E-06  -7.66000000E-06  +3.11400000E-05
   -1.39800000E-05  +1.82600000E-05  -1.19700000E-05  +1.70800000E-05  +7.62400000E-05
   -4.75800000E-05  -1.48600000E-05  -2.90057200E-02  +2.34871290E-01  +4.11493920E-01
   +1.38779000E-03  +3.02877000E-03  -9.33920000E-04  +4.79778000E-03  +1.22903600E-02
   +1.81037000E-02  -5.40611800E-02  -1.55969900E-02  -1.94702000E-03  +3.29616000E-03
   -1.36093800E-02  -2.16632800E-02  -1.59011000E-03  -5.49918000E-03  +1.41330000E-03
   -1.55740000E-03  -3.54310000E-04  +1.46490000E-04  -1.70180000E-03  -2.06035000E-03
   +4.54031000E-03  +5.76150000E-04  -4.62170000E-04  -9.88570000E-04  -2.04000000E-06
   +8.97400000E-05  -8.88300000E-05  -3.44340000E-04  -1.63810000E-04  +9.40400000E-05
   +1.16620000E-04  -3.88800000E-05  -2.04800000E-05  -1.57000000E-05  +2.57400000E-05
   -7.03000000E-06  -1.19800000E-05  +2.87300000E-05  +1.34100000E-05  +5.48600000E-05
   -2.99500000E-05  -1.09900000E-05  -8.57000000E-06  -6.98800000E-05  +5.85800000E-05
   -2.69100000E-05  +1.44000000E-05  +2.38800000E-05  -7.48100000E-05  +6.84700000E-05
   +1.46500000E-05  -7.05900000E-04  -1.04331000E-03  -2.94310000E-04  +5.02734400E-02
   +2.73077000E-03  -1.71090000E-04  +2.72273000E-03  -3.44381000E-03  +2.47055000E-03
   +1.30018000E-03  -1.56890500E-02  -1.33124520E-01  -1.36648020E-01  +1.11346000E-03
   -7.65385000E-03  -1.70598300E-02  -5.62795000E-03  +2.53745000E-03  -1.53290000E-03
   -1.14630000E-04  -4.98090000E-04  +7.24280000E-04  -1.78857000E-03  +3.61767000E-03
   -8.32760000E-04  +1.87710000E-04  +5.30800000E-05  -9.10960000E-04  -5.80100000E-05
   -8.68000000E-06  -2.12300000E-05  -2.88850000E-04  -2.42690000E-04  +8.56700000E-05
   +2.11290000E-04  -1.00220000E-04  -4.32200000E-05  -4.55800000E-05  +4.05200000E-05
   +3.22200000E-05  -4.03000000E-06  -2.63000000E-06  +1.65600000E-05  +7.53700000E-05
   -1.98600000E-05  -2.83400000E-05  -1.83400000E-05  -4.10500000E-05  +2.48500000E-05
   +1.16200000E-05  +3.21100000E-05  +1.37600000E-05  -8.26300000E-05  +5.04800000E-05
   +1.49600000E-05  +4.01850000E-04  +2.53500000E-04  -9.21760000E-04  +2.02727300E-02
   +1.35303020E-01  -1.52978000E-03  +2.33497000E-03  +1.40957000E-03  -5.92427000E-03
   -1.56848500E-02  -1.37484800E-02  -2.25683000E-03  -1.36660450E-01  -2.41330340E-01
   +1.06759000E-03  -9.86590000E-04  -3.36900000E-05  +8.51510000E-04  -2.09392000E-03
   +3.41130000E-03  +4.09560000E-04  +9.51300000E-04  +1.59160000E-04  +5.02619000E-03
   -4.51480000E-04  -7.46280000E-04  +4.02730000E-04  -7.97000000E-05  -1.10740000E-04
   -5.32300000E-05  +1.01700000E-05  -5.62800000E-05  -1.10840000E-04  -1.12600000E-05
   +5.28700000E-05  -2.26100000E-05  -4.97300000E-05  -9.13000000E-06  -2.51000000E-06
   +1.71100000E-05  -5.07700000E-05  -8.36000000E-06  +2.89400000E-05  -4.24000000E-06
   +7.94600000E-05  -4.92700000E-05  -6.48000000E-06  +6.48000000E-06  -1.21770000E-04
   +9.03200000E-05  -4.80300000E-05  -3.10000000E-06  +9.05000000E-06  -9.58100000E-05
   +8.10500000E-05  +7.89000000E-06  +1.94268000E-03  +6.13470000E-04  -5.47830000E-04
   +2.11819000E-03  +1.50782980E-01  +2.53016680E-01  -1.27880000E-03  -2.66280000E-04
   +8.12300000E-04  +1.38240000E-04  -5.46126000E-03  -2.35320000E-04  -1.27944200E-02
   +1.50840000E-04  +1.81103000E-02  -1.97835670E-01  -1.34734500E-02  +1.44343200E-01
   +4.85435000E-03  -2.80150000E-04  -1.20560000E-03  +2.52581000E-03  -2.22565000E-03
   +4.80840000E-04  -2.69040000E-04  +5.02600000E-05  -9.26730000E-04  -1.00683000E-03
   +6.65950000E-04  -9.52110000E-04  -1.74200000E-05  -1.30150000E-04  +1.26650000E-04
   -4.78500000E-05  +1.42980000E-04  -4.70800000E-05  -6.19150000E-04  -5.56050000E-04
   -7.02840000E-04  -4.91000000E-06  -3.48800000E-05  -1.58200000E-05  -1.74800000E-04
   +1.52900000E-04  +3.27100000E-05  -2.97520000E-04  -6.60000000E-06  +1.88350000E-04
   +2.53950000E-04  +1.77810000E-04  -2.03120000E-04  -2.41850000E-04  -1.07430000E-04
   -2.58900000E-04  +1.85640000E-04  -1.21400000E-04  -2.62300000E-05  +9.78600000E-05
   +1.76040000E-04  +1.59700000E-04  -4.26640000E-04  +1.80048000E-03  -1.41339000E-03
   +2.06579800E-01  -9.66050000E-04  -2.47240000E-04  +7.75040000E-04  -5.30460000E-03
   +1.88443000E-03  -3.73875000E-03  -1.50724800E-02  +3.06726000E-03  +1.43697300E-02
   -1.28735000E-02  -4.98978000E-02  -2.11403000E-03  +1.35553300E-02  +5.86114000E-03
   -1.19844700E-02  -2.72474000E-03  +1.31135000E-03  -5.11578000E-03  +7.74600000E-05
   -1.07986000E-03  +6.56900000E-05  +1.52892000E-03  -1.35049000E-03  +1.02575000E-03
   -1.44570000E-04  -5.22580000E-04  -5.04710000E-04  +1.64320000E-04  +9.55000000E-06
   +1.04970000E-04  -3.96200000E-04  +8.38900000E-05  -2.51730000E-04  +1.17350000E-04
   -9.55300000E-05  -6.80100000E-05  -1.62960000E-04  +1.65050000E-04  +4.92000000E-06
   -2.14090000E-04  -1.16250000E-04  +2.09640000E-04  +3.33060000E-04  +4.52000000E-06
   -2.55730000E-04  -2.59000000E-04  +1.20200000E-04  -2.23910000E-04  +1.45240000E-04
   -1.19480000E-04  -1.70900000E-05  +8.51200000E-05  +1.05380000E-04  +1.28990000E-04
   +2.13827000E-03  -1.95571000E-03  +1.72010000E-03  +1.92235800E-02  +4.39855600E-02
   -6.42400000E-05  +9.08000000E-05  +1.82770000E-04  +1.44100000E-04  -3.32479000E-03
   +2.95620000E-03  -4.28423000E-03  -1.46721000E-03  +6.29887000E-03  +1.43534110E-01
   -1.34278000E-03  -1.90693080E-01  +1.97005600E-02  +2.12965000E-03  -1.28549200E-02
   +3.61300000E-04  -5.61468000E-03  -2.38154000E-03  -1.13163000E-03  -1.16810000E-04
   -2.13230000E-04  +3.42560000E-04  +1.86712000E-03  -6.63810000E-04  -1.34200000E-05
   -4.84700000E-05  -1.52090000E-04  -2.07070000E-04  +5.14000000E-06  +1.25000000E-05
   -3.39760000E-04  -4.39010000E-04  +1.13930000E-04  -3.31220000E-04  +1.40930000E-04
   +3.04120000E-04  -4.66800000E-05  -9.99500000E-05  +7.42300000E-05  -3.64970000E-04
   +1.09630000E-04  +3.41700000E-05  -2.55000000E-06  +2.91790000E-04  -1.82210000E-04
   +7.23500000E-05  +4.82490000E-04  -6.35800000E-05  +3.61360000E-04  -2.38160000E-04
   -1.84100000E-05  -2.04900000E-05  +2.20000000E-06  -1.24200000E-05  -1.11166000E-03
   +2.04601000E-03  -3.62240000E-04  -1.57628100E-01  +5.17573000E-03  +1.98099790E-01
   +4.98900000E-05  -7.16010000E-04  -1.14194000E-03  -1.22718000E-03  -5.42674000E-03
   +1.58802000E-03  -1.31254000E-03  -1.38680000E-04  +3.10000000E-05  -1.65942000E-03
   -2.53624000E-03  +5.10911000E-03  +6.60710000E-03  +1.27708600E-02  +1.75717200E-02
   -5.52588100E-02  -1.26129800E-02  -2.37216000E-03  +2.75222000E-03  -1.44759700E-02
   -2.11578300E-02  -2.29210000E-04  +1.82372000E-03  -9.87510000E-04  +3.66790000E-04
   +5.59500000E-05  -9.63600000E-05  -2.50441000E-03  -1.76476000E-03  +5.62140000E-04
   -2.28490000E-04  -1.03140000E-04  -1.25560000E-04  +5.33000000E-06  -1.06700000E-05
   -5.94900000E-05  +2.56500000E-05  -2.36000000E-06  +1.20200000E-05  -6.46800000E-05
   +3.17700000E-05  +2.52200000E-05  -1.61600000E-05  +8.67300000E-05  -7.79800000E-05
   -1.61100000E-05  -1.35660000E-04  +3.43200000E-05  +8.67900000E-05  -5.40500000E-05
   -1.56800000E-05  -3.19700000E-04  -1.76650000E-04  -1.29010000E-04  -1.30780000E-04
   +2.98040000E-04  -1.98890000E-04  +1.93920000E-04  +7.46200000E-04  +1.03164000E-03
   +5.55250100E-02  -1.09810000E-04  -6.31670000E-04  -9.86500000E-04  -5.47918000E-03
   +2.96381000E-03  -1.80387000E-03  -6.29600000E-05  -5.77470000E-04  +8.59180000E-04
   -2.47001000E-03  +4.13598000E-03  -1.36471000E-03  +1.84270000E-04  +5.18571000E-03
   +9.54050000E-04  -1.25334300E-02  -1.35474670E-01  -1.36886380E-01  +1.93840000E-04
   -6.99403000E-03  -1.71407500E-02  +1.27437000E-03  -2.40678000E-03  +9.10700000E-04
   -4.93970000E-04  -2.92460000E-04  +2.68300000E-05  -2.86595000E-03  -9.55150000E-04
   +1.95830000E-04  +2.68840000E-04  +4.63030000E-04  -1.98250000E-04  +9.21300000E-05
   -1.16780000E-04  +6.96900000E-05  +1.76500000E-05  -3.52600000E-05  -1.04100000E-05
   -4.88200000E-05  +6.18100000E-05  -4.22000000E-06  +6.12000000E-06  +2.07400000E-05
   -1.15600000E-05  +1.00930000E-04  +9.00900000E-05  -9.83400000E-05  +5.93200000E-05
   -6.29300000E-05  +9.39000000E-06  -1.21630000E-04  -2.52570000E-04  +2.70700000E-05
   +2.74420000E-04  -4.13010000E-04  +2.01920000E-04  -7.27300000E-05  +8.62900000E-05
   +2.04790000E-04  +2.14542500E-02  +1.39286370E-01  -1.67520000E-04  -3.06140000E-04
   -2.37390000E-04  +1.44444000E-03  -1.89290000E-03  +3.40592000E-03  +1.64890000E-04
   +9.43550000E-04  +2.13680000E-04  +5.16471000E-03  -1.13808000E-03  -6.70040000E-04
   -2.39427000E-03  -1.30046100E-02  -1.32925500E-02  -1.89040000E-03  -1.36870110E-01
   -2.50905050E-01  +1.58153000E-03  -1.27489000E-03  +2.43040000E-04  -2.04837000E-03
   +1.30630000E-04  -1.38240000E-03  +5.26380000E-04  +1.86870000E-04  +4.58800000E-05
   -9.92550000E-04  -1.12281000E-03  +3.07920000E-04  -1.43720000E-04  -8.10400000E-05
   +1.23020000E-04  -3.20500000E-05  +5.62100000E-05  +1.36000000E-05  +6.40000000E-07
   +1.33000000E-05  +3.34000000E-06  +2.05500000E-05  -1.74300000E-05  -1.60400000E-05
   -2.30000000E-05  -1.68700000E-05  +2.66800000E-05  +1.99000000E-05  +1.57500000E-05
   +6.62000000E-05  -3.38500000E-05  +3.36100000E-05  +4.19000000E-06  -4.57400000E-05
   +8.44000000E-05  -4.51000000E-06  -2.32230000E-04  +1.72220000E-04  -2.08650000E-04
   -1.96030000E-04  -6.64710000E-04  -8.23590000E-04  +2.03622000E-03  +1.52421510E-01
   +2.62619660E-01  -2.23810000E-04  +1.82386000E-03  -8.51120000E-04  +4.01955000E-03
   -2.10633000E-03  -1.86497000E-03  +2.25239000E-03  -2.13023000E-03  +4.50870000E-04
   -2.21450000E-04  +4.57300000E-05  -9.04190000E-04  -3.81340000E-04  -5.46778000E-03
   -2.54390000E-04  -1.21791800E-02  +8.50520000E-04  +1.72559700E-02  -1.98250950E-01
   -1.94899900E-02  +1.48108100E-01  -1.29060000E-04  +2.94650000E-04  +8.93140000E-04
   -2.04380000E-04  -8.53200000E-05  -9.81000000E-05  -2.95200000E-05  +8.09800000E-05
   +6.27800000E-05  +3.91000000E-05  -2.17830000E-04  +5.40000000E-07  -7.57300000E-05
   +7.98200000E-05  -6.33000000E-06  +4.00000000E-06  -3.24000000E-06  +1.51400000E-05
   +7.87000000E-05  -2.15100000E-05  -2.90800000E-05  -2.25200000E-05  -8.89100000E-05
   +7.55300000E-05  -4.52300000E-05  +6.10000000E-07  +2.94800000E-05  -7.82200000E-05
   +5.93100000E-05  +5.60000000E-07  -1.32140000E-04  +2.40570000E-04  -1.04010000E-04
   +1.94060000E-04  +3.46800000E-05  -2.20900000E-04  -2.06990000E-04  +2.86950000E-04
   -9.95100000E-05  -5.02420000E-04  +1.84038000E-03  -1.43735000E-03  +2.06083640E-01
   +1.67694000E-03  -9.84400000E-04  +2.28351000E-03  +1.30872700E-02  +6.23430000E-03
   -1.28862500E-02  -2.40432000E-03  +9.63700000E-04  -4.75277000E-03  -9.01800000E-05
   -1.27801000E-03  -1.84570000E-04  -5.12310000E-03  +1.46034000E-03  -3.05661000E-03
   -1.34629100E-02  +2.55904000E-03  +1.50003400E-02  -2.02919500E-02  -4.76577100E-02
   +2.48496000E-03  -4.87860000E-04  +4.54720000E-04  +5.01900000E-04  -7.53200000E-05
   +5.13000000E-05  -4.44100000E-05  +6.01100000E-05  +2.74300000E-05  +8.53700000E-05
   -2.06470000E-04  -2.79240000E-04  -1.45700000E-05  -2.78500000E-05  +3.11200000E-05
   -2.83500000E-05  -2.47700000E-05  +4.03300000E-05  +2.01900000E-05  +2.69400000E-05
   -4.04800000E-05  +1.34900000E-05  +1.45000000E-05  +1.24000000E-06  +9.21000000E-06
   -1.24600000E-05  +4.64000000E-06  -2.38900000E-05  -5.25200000E-05  +3.29700000E-05
   +2.91000000E-06  +1.95920000E-04  -1.55300000E-04  +4.24060000E-04  +7.28500000E-04
   +4.15900000E-05  -6.35100000E-04  +2.52940000E-04  -3.28790000E-04  +2.98610000E-04
   +2.14905000E-03  -1.89153000E-03  +1.66216000E-03  +2.40652800E-02  +4.07322000E-02
   -1.10943000E-03  +2.09983000E-03  +8.78690000E-04  +2.19650000E-02  +3.85600000E-03
   -1.26962500E-02  -1.10800000E-05  -5.11294000E-03  -2.26566000E-03  -1.24874000E-03
   -4.06460000E-04  -3.81170000E-04  -3.27300000E-05  -2.79125000E-03  +2.82997000E-03
   -4.91235000E-03  -6.39590000E-04  +6.76874000E-03  +1.46781370E-01  +1.55584000E-03
   -1.93493390E-01  -1.67970000E-04  -1.43860000E-04  +2.91390000E-04  -1.49100000E-05
   -4.94200000E-05  -2.35800000E-05  +1.70000000E-05  +6.07900000E-05  -2.19100000E-05
   +6.81200000E-05  +2.08600000E-05  +9.96000000E-06  -4.29000000E-06  +6.18000000E-06
   +2.04500000E-05  +1.01100000E-05  -1.29000000E-05  +3.21000000E-06  -2.32800000E-05
   +2.11200000E-05  -3.56000000E-06  -1.23000000E-05  +1.84900000E-05  -1.13300000E-05
   +5.38000000E-06  -1.01000000E-06  +7.11000000E-06  +3.25000000E-05  -1.88800000E-05
   -2.66000000E-06  -1.79720000E-04  +3.69680000E-04  +2.09000000E-04  +8.89950000E-04
   +1.21300000E-04  -8.29040000E-04  -1.08470000E-04  +2.78770000E-04  -1.59740000E-04
   -9.79250000E-04  +1.98931000E-03  -2.73500000E-04  -1.60974110E-01  -1.15367000E-03
   +1.99183690E-01  +2.48200000E-05  -9.70000000E-06  +2.23600000E-05  +3.85400000E-05
   -2.56300000E-05  -1.76890000E-04  -2.27430000E-04  -1.50500000E-05  -3.34000000E-06
   +3.30490000E-04  +2.46330000E-04  +2.84280000E-04  +7.94360000E-04  -1.35203000E-03
   -2.13840000E-04  +2.33980000E-04  +1.22390000E-04  +1.51170000E-04  +1.12940000E-04
   +1.20370000E-04  -3.72400000E-05  -4.19746000E-03  +8.79270000E-04  +1.30341000E-03
   -2.59082160E-01  +1.04337410E-01  +3.92892500E-02  -1.17320000E-04  -2.31860000E-04
   +4.73680000E-04  +7.54650000E-04  +1.89120000E-04  -4.05410000E-04  -1.15260000E-04
   -2.08980000E-04  +3.53710000E-04  +1.54160000E-04  +1.72760000E-04  -1.85610000E-04
   +1.64810000E-04  -5.29100000E-05  -8.42600000E-05  -1.02900000E-05  -1.25800000E-04
   +9.73000000E-05  -1.48680000E-04  -5.42600000E-05  +2.31130000E-04  -2.15020000E-04
   +1.85320000E-04  -1.29100000E-05  -9.52000000E-06  +5.17000000E-06  -1.83000000E-06
   -4.18000000E-06  +1.22900000E-05  +3.00000000E-07  +2.84000000E-05  -7.10700000E-05
   -7.59000000E-06  +1.98100000E-05  +3.01900000E-05  -1.78600000E-05  +2.14100000E-05
   +1.67100000E-05  +6.39000000E-06  +2.78634950E-01  +2.18920000E-04  +2.12720000E-04
   +3.99100000E-05  -2.39390000E-04  -1.51340000E-04  +1.29820000E-04  +1.47440000E-04
   +6.02300000E-05  -7.11100000E-05  -1.80910000E-04  -2.07240000E-04  -5.72180000E-04
   +1.37972000E-03  +7.14730000E-04  -2.56690000E-04  -2.84030000E-04  +1.47040000E-04
   +3.87800000E-05  -1.84520000E-04  -8.92000000E-05  +6.10600000E-05  +2.14894200E-02
   -1.29734400E-02  -3.87575000E-03  +1.02212400E-01  -9.62995500E-02  -1.99620200E-02
   -2.38590000E-04  +3.47040000E-04  -1.32312000E-03  -8.21100000E-04  -2.92507000E-03
   +4.09395000E-03  -5.84010000E-04  -1.75920000E-04  +5.83400000E-04  +1.01090000E-04
   +2.29380000E-04  -8.74800000E-05  -3.13680000E-04  +6.64700000E-05  +1.31410000E-04
   +7.46000000E-06  -1.81970000E-04  +4.92600000E-05  +1.47849000E-03  -2.01730000E-04
   -3.74910000E-04  +2.74420000E-04  -1.67990000E-04  -5.60700000E-05  -8.55000000E-06
   -3.77800000E-05  -1.87900000E-05  +1.16600000E-05  -3.58000000E-06  +1.35700000E-05
   +2.47600000E-05  +8.52100000E-05  +1.46870000E-04  +3.04000000E-05  -3.00000000E-05
   +7.61400000E-05  +7.28000000E-06  -1.00400000E-05  -3.93000000E-06  -1.13661060E-01
   +1.05595210E-01  -1.27600000E-04  -9.67800000E-05  -9.19000000E-06  +1.25110000E-04
   -5.27000000E-06  -1.97970000E-04  -3.71780000E-04  -3.99400000E-05  +1.00490000E-04
   +3.65090000E-04  +4.80600000E-05  -2.23610000E-04  -6.20130000E-04  -3.76100000E-04
   +5.26260000E-04  -1.45100000E-04  -1.59680000E-04  +1.72940000E-04  +1.24870000E-04
   +1.17320000E-04  +7.51000000E-06  -1.97104500E-02  +1.00663800E-02  +1.91165000E-03
   +4.06800000E-02  -2.09903200E-02  -5.44704400E-02  -1.22425000E-03  +5.91380000E-04
   +1.19833000E-03  +5.53670000E-04  +2.87081000E-03  -3.10393000E-03  +7.15810000E-04
   +3.92300000E-04  -2.85150000E-04  -1.77600000E-04  +5.30000000E-06  +2.33170000E-04
   +8.67000000E-06  -1.29820000E-04  +2.06500000E-05  +1.94310000E-04  +2.73950000E-04
   -2.02740000E-04  -1.19060000E-03  +6.19520000E-04  +4.82480000E-04  -5.87500000E-05
   +2.00000000E-06  +2.16900000E-05  +1.36500000E-05  +2.42000000E-06  +1.55000000E-05
   +1.69500000E-05  -1.77900000E-05  +3.00000000E-07  +3.74700000E-05  +8.19000000E-06
   +9.40700000E-05  +2.82100000E-05  +8.32000000E-06  -8.25800000E-05  -1.93000000E-06
   +4.16000000E-06  +9.99000000E-06  -4.34243800E-02  +1.81815600E-02  +5.83358800E-02
   -2.34160000E-04  -1.96420000E-04  -3.05400000E-05  +2.54570000E-04  +1.61200000E-04
   -6.88700000E-05  -2.06450000E-04  -4.30800000E-05  +7.46000000E-05  +2.79020000E-04
   +2.55920000E-04  +4.68160000E-04  +4.26090000E-04  -3.50600000E-04  -1.67870000E-04
   +5.51940000E-04  -3.55000000E-05  -1.71090000E-04  +4.47400000E-05  -3.45200000E-05
   -3.98600000E-05  +2.86816000E-03  +3.68333000E-03  +3.03660000E-04  -1.83879450E-01
   -1.31777860E-01  -1.78410800E-02  +3.74170000E-04  +3.54050000E-04  -8.08500000E-05
   +8.97000000E-06  -7.49800000E-05  +2.88150000E-04  -1.02698000E-03  +7.31140000E-04
   +7.26930000E-04  +8.21900000E-05  +2.45890000E-04  -1.79600000E-04  -1.85440000E-04
   -1.16700000E-05  +5.33000000E-05  +3.96300000E-05  +2.08900000E-05  -2.45200000E-05
   +1.15170000E-04  -9.07400000E-05  -3.75600000E-05  +9.61100000E-05  -3.45000000E-05
   -3.65200000E-05  +2.00600000E-05  +3.63700000E-05  +1.91500000E-05  -2.44800000E-05
   -6.51000000E-06  -1.84500000E-05  -1.28600000E-05  -1.63700000E-05  -1.81800000E-05
   -5.79100000E-05  +6.55600000E-05  +6.54000000E-06  -8.79000000E-06  -3.75000000E-06
   +5.61000000E-06  -1.87589900E-02  -2.02235400E-02  -3.46333000E-03  +2.00080420E-01
   -5.60540000E-04  -4.81990000E-04  -1.56900000E-04  +2.56960000E-04  +4.48630000E-04
   +5.17480000E-04  +1.07190000E-04  +1.75820000E-04  +3.80800000E-05  -3.25310000E-04
   -1.27210000E-04  +2.94690000E-04  +9.82900000E-04  -2.58073000E-03  +3.95151000E-03
   +3.84290000E-04  -4.69950000E-04  -4.67520000E-04  -6.43300000E-04  -2.67630000E-04
   -4.34130000E-04  -1.75250000E-02  -1.60547800E-02  -2.99764000E-03  -1.30363770E-01
   -1.74068720E-01  -1.68471200E-02  -3.27500000E-04  +6.87860000E-04  -1.58061000E-03
   -7.90720000E-04  +5.30330000E-04  -1.25460000E-04  -2.31100000E-05  -5.69240000E-04
   +7.38810000E-04  +3.52730000E-04  +2.82130000E-04  -3.07570000E-04  +1.01070000E-04
   +5.67500000E-05  -1.63840000E-04  -1.55110000E-04  -1.65380000E-04  +2.18040000E-04
   +2.35550000E-04  +1.80400000E-05  +9.01100000E-05  -1.16070000E-04  +1.51170000E-04
   -3.63300000E-05  +3.12100000E-05  +4.61600000E-05  +5.76200000E-05  -2.91900000E-05
   -5.26200000E-05  -3.74000000E-05  -1.35800000E-05  +1.27400000E-04  -7.11000000E-05
   +5.78900000E-05  -7.73600000E-05  +1.58270000E-04  -1.06160000E-04  -8.81000000E-06
   -3.13800000E-05  +1.03998300E-02  +1.08849100E-02  +1.68210000E-03  +1.43356840E-01
   +1.88763030E-01  +3.30720000E-04  +3.20660000E-04  +4.22300000E-05  -3.55980000E-04
   -5.34300000E-05  +2.59940000E-04  +6.53460000E-04  +1.80000000E-06  +3.12100000E-05
   +2.40000000E-07  -3.60650000E-04  -8.62300000E-05  -1.44494000E-03  +2.49794000E-03
   -2.50116000E-03  +5.76700000E-04  +5.12050000E-04  +1.43580000E-04  +5.27900000E-05
   -3.16520000E-04  +1.33140000E-04  +1.63386200E-02  +1.48714700E-02  +5.13020000E-04
   -1.78626900E-02  -1.79823500E-02  -5.07381000E-02  +1.08334000E-03  +7.93960000E-04
   +1.02793000E-03  +1.29410000E-04  -5.72230000E-04  +4.18270000E-04  -2.18240000E-04
   -6.42290000E-04  +4.85770000E-04  -7.20000000E-05  +2.10200000E-04  -1.61700000E-04
   -9.90900000E-05  -5.57500000E-05  +1.31160000E-04  +1.02030000E-04  -3.24700000E-05
   -6.09700000E-05  +2.44200000E-05  +7.43000000E-06  -1.96910000E-04  +2.74500000E-05
   +1.43600000E-05  -3.21100000E-05  -3.00000000E-08  -1.54900000E-05  -4.27400000E-05
   +3.21800000E-05  +1.82100000E-05  +1.80300000E-05  -2.82890000E-04  +3.89760000E-04
   +1.94600000E-05  -3.52000000E-05  +1.16450000E-04  -1.05370000E-04  +4.17700000E-05
   +3.69800000E-05  -1.21700000E-05  +4.03997000E-03  +4.34331000E-03  -3.55800000E-04
   +1.90668200E-02  +1.64881100E-02  +5.26779200E-02  +4.60400000E-05  +4.91300000E-05
   +3.79000000E-06  -1.33800000E-05  -9.97500000E-05  -1.00690000E-04  -2.47210000E-04
   -3.80800000E-05  -2.53600000E-05  -1.53500000E-05  -1.38680000E-04  -5.80300000E-05
   -7.28400000E-05  +3.98110000E-04  +6.34330000E-04  -1.52630000E-04  -1.02500000E-04
   +7.89500000E-05  +1.20160000E-04  +7.09000000E-05  +6.23300000E-05  -1.69368000E-03
   -1.87472000E-03  -4.07512000E-03  -4.69458300E-02  +2.58940000E-04  +2.09990000E-03
   -1.27440000E-04  +8.99080000E-04  -6.16870000E-04  +3.92080000E-04  -4.26500000E-04
   -5.13660000E-04  -1.08520000E-04  +5.10470000E-04  -4.55160000E-04  -1.19870000E-04
   -4.46000000E-05  +2.22140000E-04  -1.28690000E-04  -2.96400000E-05  +8.39200000E-05
   +1.18940000E-04  +9.04400000E-05  -1.41520000E-04  -3.79900000E-05  +2.63400000E-05
   +1.42000000E-06  +1.25250000E-04  -1.24380000E-04  +1.48900000E-05  -7.11000000E-06
   -2.29000000E-05  +4.48000000E-06  +2.28300000E-05  -1.53600000E-05  +1.41300000E-05
   +2.33460000E-04  -1.48060000E-04  +5.44300000E-05  +9.77000000E-06  +2.16300000E-05
   -5.92700000E-05  -1.42000000E-06  +1.01700000E-05  -7.53000000E-06  +7.19920000E-04
   +9.90727000E-03  +2.73515600E-02  +4.34300000E-04  -7.42604000E-03  -2.22037200E-02
   +4.76847800E-02  +1.55520000E-04  +1.04310000E-04  +3.08500000E-05  +4.17000000E-05
   -1.11740000E-04  -2.93930000E-04  -1.34340000E-04  -1.96620000E-04  -1.84860000E-04
   -3.66190000E-04  -1.67890000E-04  +6.36820000E-04  +6.55700000E-04  +1.20683000E-03
   +1.03610000E-04  -3.74070000E-04  -5.12800000E-05  +1.25700000E-05  +2.23950000E-04
   +2.04180000E-04  +1.83520000E-04  -8.03320000E-04  +8.62836000E-03  +2.25035800E-02
   -1.25940000E-04  -8.30743000E-02  -9.21499300E-02  +4.65170000E-04  -3.47326000E-03
   +2.85740000E-03  -3.06490000E-04  +1.13951000E-03  -4.02050000E-04  +4.95630000E-04
   +3.68030000E-04  -1.48830000E-04  +8.86000000E-05  -2.14430000E-04  +7.83700000E-05
   +1.43280000E-04  +7.63100000E-05  -1.69860000E-04  -1.90090000E-04  +3.24600000E-05
   +8.26000000E-05  -2.06840000E-04  -1.82050000E-04  -2.41200000E-05  -7.71600000E-05
   +2.13300000E-05  +2.62400000E-05  -2.27500000E-05  -1.46000000E-05  -1.55100000E-05
   -5.17000000E-06  -3.04000000E-06  +2.41900000E-05  +4.86000000E-05  -1.05994000E-03
   -3.98000000E-05  +5.23600000E-05  -1.04200000E-05  -1.81800000E-05  +1.41800000E-05
   -7.74000000E-06  +5.21000000E-06  -1.13089000E-03  -5.43520000E-03  -1.22450700E-02
   +2.01527000E-03  -7.65374000E-03  -2.00308900E-02  -1.17600000E-03  +8.93318400E-02
   -2.44500000E-05  +3.68000000E-06  -1.30600000E-05  -2.37230000E-04  +2.24770000E-04
   +4.87200000E-04  +5.69930000E-04  +2.85790000E-04  +2.05830000E-04  +1.23130000E-04
   -6.97120000E-04  -1.23960000E-04  -1.23046000E-03  -8.59800000E-04  +5.87430000E-04
   +7.67130000E-04  +1.99590000E-04  -2.75670000E-04  -4.02840000E-04  -3.76180000E-04
   -1.49240000E-04  +3.71030000E-04  -8.76514000E-03  -1.93325300E-02  +2.00516000E-03
   -8.98504400E-02  -2.80519090E-01  -4.10470000E-04  +4.84036000E-03  -2.42270000E-03
   +1.07861000E-03  -8.30730000E-04  +5.63980000E-04  +3.74650000E-04  +2.84160000E-04
   +1.39620000E-04  -2.82140000E-04  +1.03690000E-04  +2.53550000E-04  -1.03940000E-04
   -2.10460000E-04  +1.40670000E-04  +2.40430000E-04  +4.63300000E-05  -1.55630000E-04
   -9.98100000E-05  +3.93690000E-04  +1.17540000E-04  -3.10000000E-06  -2.27900000E-05
   +1.12000000E-05  +1.94100000E-05  +1.30100000E-05  -4.45000000E-06  +3.95600000E-05
   +5.45000000E-06  +1.01000000E-06  -2.44740000E-04  +2.96090000E-04  +2.75010000E-04
   -1.25290000E-04  -1.02000000E-05  +9.72600000E-05  -4.27000000E-06  +1.83900000E-05
   -1.62900000E-05  -4.25040000E-04  -1.27935000E-03  -3.77424000E-03  +3.82410000E-04
   -1.12630000E-04  -1.19350000E-03  -1.79787000E-03  +9.73897000E-02  +3.05718390E-01
   +9.75600000E-05  +1.11100000E-04  +5.93000000E-05  -7.67200000E-05  -2.09700000E-05
   +2.85500000E-05  +1.17020000E-04  +1.03640000E-04  +3.83500000E-05  -8.94900000E-05
   -8.82000000E-05  -5.58300000E-05  +2.89890000E-04  +5.62440000E-04  -2.87720000E-04
   +6.26900000E-05  -2.99880000E-04  -7.35540000E-04  -1.11890000E-04  -1.21000000E-05
   +2.78370000E-04  -1.97786000E-03  +1.36199000E-03  -1.17289000E-03  -7.11000000E-06
   -4.20210000E-04  -5.62440000E-04  -4.81474600E-02  +1.25392900E-02  -1.23576000E-02
   +6.77800000E-05  -8.01740000E-04  +4.93050000E-04  -1.40280000E-04  +7.04300000E-05
   +8.40400000E-05  +1.27890000E-04  -7.11700000E-05  +4.17500000E-05  -1.79800000E-05
   +1.17380000E-04  -6.03700000E-05  -2.77310000E-04  +8.48900000E-05  +1.35000000E-05
   -1.01410000E-04  +1.99810000E-04  -2.20300000E-05  +6.16000000E-05  -4.25700000E-05
   -1.49400000E-05  -8.38000000E-06  -8.48000000E-06  -6.76000000E-06  +1.03700000E-05
   +1.05200000E-05  +1.47000000E-05  -1.92000000E-05  +4.11500000E-05  +6.29100000E-05
   -1.37332000E-03  +1.64300000E-04  -2.13610000E-04  -1.32700000E-05  +2.37000000E-06
   -2.32300000E-05  +3.36420000E-04  -2.91930000E-04  +2.53980000E-04  +1.19210000E-04
   +3.33150000E-04  -1.06700000E-04  +6.28090000E-04  +1.95760000E-04  -1.82560000E-04
   +4.87207700E-02  +8.01900000E-05  +4.27400000E-05  -2.40000000E-05  -9.59600000E-05
   -6.95300000E-05  +1.23740000E-04  +8.12700000E-05  +3.90900000E-05  -3.42700000E-05
   +2.49380000E-04  +5.11300000E-05  +7.10000000E-06  -1.98710000E-04  +6.36460000E-04
   +3.69140000E-04  -6.98590000E-04  +3.01960000E-04  +2.11820000E-04  +4.14900000E-05
   -7.84900000E-05  -2.05140000E-04  -5.93660000E-04  +9.52116000E-03  -1.05434400E-02
   -1.34200000E-04  -5.89170000E-04  -2.10823000E-03  +1.28102900E-02  -1.76450560E-01
   +1.34192120E-01  -2.09580000E-04  +6.98140000E-04  +4.34200000E-05  +2.95200000E-05
   +1.17000000E-05  +1.02660000E-04  -2.50600000E-05  +5.85000000E-05  -8.81500000E-05
   +5.77600000E-05  -1.88500000E-05  +4.88400000E-05  -9.83700000E-05  -1.26120000E-04
   +9.30600000E-05  +3.01090000E-04  -1.87320000E-04  -7.00290000E-04  -1.41560000E-04
   +8.41400000E-05  -1.10000000E-06  -8.68000000E-06  -1.39200000E-05  -5.77000000E-06
   +1.88600000E-05  +1.53800000E-05  +3.26000000E-06  +3.02000000E-06  +8.01000000E-06
   -3.21700000E-05  -2.63190000E-04  -2.75270000E-04  -3.22630000E-04  -8.96000000E-06
   +4.12600000E-05  -1.25400000E-05  -2.13510000E-04  +4.25000000E-06  -1.67710000E-04
   +2.30670000E-04  +1.41740000E-04  -2.42310000E-04  -8.89900000E-05  +7.41740000E-04
   -5.05990000E-04  -1.32271000E-02  +1.90335460E-01  +1.94000000E-05  +1.38800000E-05
   +1.14000000E-05  -1.36130000E-04  +1.20850000E-04  +2.46340000E-04  +2.56410000E-04
   +2.07100000E-04  -7.00000000E-07  +1.64700000E-05  -5.24990000E-04  -1.60200000E-04
   +9.68980000E-04  +1.01066000E-03  +1.24062000E-03  +2.01470000E-04  -2.17770000E-04
   +5.52000000E-06  -2.76790000E-04  -2.49720000E-04  +1.35490000E-04  -1.56904000E-03
   +2.10104600E-02  -1.99680500E-02  +1.00800000E-04  -4.13482000E-03  -5.41680000E-03
   -1.19137600E-02  +1.32127180E-01  -1.84813210E-01  -1.51317000E-03  +9.28580000E-04
   +7.31520000E-04  +7.66790000E-04  +2.00000000E-08  -2.22530000E-04  -4.69620000E-04
   +3.48550000E-04  -8.98000000E-06  -2.12440000E-04  -3.75090000E-04  +3.55300000E-04
   +7.78050000E-04  -4.23290000E-04  +1.11210000E-04  +5.51100000E-05  +6.15400000E-04
   +1.38240000E-04  -5.71900000E-05  -9.26000000E-06  +4.32000000E-06  -1.02000000E-05
   +6.26000000E-06  -9.01000000E-06  -2.38100000E-05  +3.31600000E-05  -2.50400000E-05
   -3.64500000E-05  +9.38800000E-05  +4.66400000E-05  -5.02140000E-04  +1.79750000E-04
   +1.89480000E-04  -2.29500000E-05  -1.78600000E-05  -1.48300000E-05  -7.56000000E-05
   -9.75400000E-05  +2.06780000E-04  +1.16100000E-04  -1.84400000E-04  +3.15220000E-04
   -3.77640000E-04  +1.43324000E-03  -1.48037000E-03  +1.38069500E-02  -1.44462460E-01
   +2.02595160E-01  -1.59320000E-04  -1.60750000E-04  -7.24100000E-05  +8.94900000E-05
   +9.61600000E-05  +3.61000000E-06  -7.10600000E-05  -5.71500000E-05  -1.08930000E-04
   +6.07900000E-05  +4.17900000E-05  +2.76470000E-04  +6.68950000E-04  +1.23720000E-04
   +5.29300000E-05  -1.42130000E-04  +3.54800000E-05  +4.86760000E-04  +1.64710000E-04
   -1.06170000E-04  -2.68720000E-04  -1.94405000E-03  -1.70010000E-04  +8.63830000E-04
   -1.91350000E-04  +8.10000000E-06  +3.69730000E-04  -2.28349300E-01  -1.27545160E-01
   -9.17197000E-03  +7.61590000E-04  +1.32874000E-03  +3.51920000E-04  +2.22220000E-04
   -1.44110000E-04  +1.05680000E-04  +1.00420000E-04  -7.29200000E-05  -7.74200000E-05
   +1.33600000E-05  +9.22500000E-05  -1.25840000E-04  -2.61380000E-04  +1.01500000E-05
   -5.95000000E-06  +3.43210000E-04  -2.39220000E-04  +6.92600000E-05  +4.41000000E-05
   -1.16900000E-05  +1.93000000E-05  +1.46100000E-05  +1.93300000E-05  +1.20800000E-05
   -3.48900000E-05  -3.48000000E-06  -2.51200000E-05  +7.77900000E-05  -4.00900000E-05
   -6.28700000E-05  +1.18760000E-04  -3.77000000E-05  -5.48210000E-04  -3.57000000E-06
   -1.04500000E-05  +1.92400000E-05  +2.78900000E-05  -1.26980000E-04  +3.03200000E-05
   +2.59930000E-04  +3.70690000E-04  -4.88750000E-04  +2.67570000E-04  +2.63370000E-04
   +2.14200000E-05  +2.50337000E-03  +2.61323000E-03  +2.67660000E-04  +2.44741010E-01
   -2.35260000E-04  -1.87140000E-04  -2.05600000E-05  +2.67440000E-04  +1.06920000E-04
   -8.57700000E-05  -6.78600000E-05  -2.77960000E-04  -1.38280000E-04  -9.06290000E-04
   -8.09900000E-05  +1.94500000E-04  +7.39050000E-04  -2.93360000E-04  -2.96719000E-03
   +2.77200000E-04  +2.50130000E-04  -3.40340000E-04  -4.54800000E-05  +1.32370000E-04
   +2.02800000E-05  -1.12959100E-02  -1.00809400E-02  -7.84430000E-04  +6.30230000E-04
   +3.18000000E-04  +9.83670000E-04  -1.26110700E-01  -1.35646260E-01  -5.16846000E-03
   -1.00623000E-03  +4.32400000E-04  +2.31180000E-04  +3.25350000E-04  +1.78220000E-04
   +2.82000000E-06  +1.62550000E-04  -3.38900000E-05  -6.63400000E-05  +2.16170000E-04
   -6.77900000E-05  -1.22180000E-04  -7.22400000E-05  -1.26820000E-04  +1.02110000E-04
   +1.43510000E-04  -3.54810000E-04  +5.07840000E-04  -1.69660000E-04  +1.48940000E-04
   +1.93300000E-05  +2.98000000E-05  +2.90600000E-05  +2.11000000E-05  -5.19000000E-05
   -1.07860000E-04  +4.10000000E-07  +7.31000000E-06  +3.83100000E-05  -7.64300000E-05
   +2.15460000E-04  -2.09470000E-04  +1.81280000E-04  -3.95100000E-05  -8.00000000E-07
   -5.78000000E-06  +1.02100000E-04  +4.69800000E-05  +1.26400000E-05  +2.13800000E-05
   +5.38250000E-04  +9.70400000E-05  +2.11520000E-04  -8.42000000E-06  -8.40000000E-07
   -1.81109100E-02  -1.23131200E-02  -1.75272000E-03  +1.38885120E-01  +1.45369430E-01
   -1.65390000E-04  -9.88700000E-05  +2.22300000E-05  +1.39920000E-04  +1.63420000E-04
   +1.33800000E-05  +1.29140000E-04  -2.28280000E-04  -3.29950000E-04  -1.60768000E-03
   -1.09084000E-03  +2.38520000E-04  +1.20689000E-03  -1.54859000E-03  -5.46618000E-03
   +9.89600000E-04  -8.74500000E-05  -6.94700000E-04  -2.18970000E-04  -5.38600000E-05
   +2.55420000E-04  -2.44546900E-02  -1.77840200E-02  -3.21827000E-03  -9.34610000E-04
   -1.12643000E-03  +1.32964000E-03  -7.22738000E-03  -3.92360000E-03  -4.63141800E-02
   -1.14741000E-03  +1.39780000E-04  +7.66540000E-04  -6.07500000E-05  +1.70680000E-04
   +2.44710000E-04  +2.54750000E-04  -1.35900000E-04  -4.92700000E-05  +2.58750000E-04
   +8.18800000E-05  -2.75540000E-04  -4.19610000E-04  -1.98770000E-04  +2.71670000E-04
   +3.74320000E-04  -2.40200000E-05  -5.16200000E-05  -2.34680000E-04  +1.63710000E-04
   +2.73500000E-05  +2.39300000E-05  +2.57700000E-05  +1.20100000E-05  -1.31200000E-04
   -9.63600000E-05  -3.84800000E-05  -5.95000000E-06  +4.21400000E-05  -6.83000000E-06
   -4.88000000E-05  +4.60200000E-04  +4.34240000E-04  -2.72100000E-05  -3.88000000E-05
   +2.31000000E-06  +7.91600000E-05  +4.63600000E-05  -6.93900000E-05  +2.38290000E-04
   +6.21380000E-04  -6.00170000E-04  +3.36350000E-04  +9.92600000E-05  +2.77510000E-04
   +1.98893500E-02  +1.23794500E-02  +1.28300000E-03  +8.91061000E-03  +8.45666000E-03
   +5.28143100E-02  +7.98200000E-05  +3.88600000E-05  -2.67800000E-05  -1.66100000E-04
   -2.28400000E-05  +1.17300000E-05  +3.20800000E-05  +5.51000000E-06  -4.63000000E-06
   +1.25670000E-04  +1.43520000E-04  +2.71400000E-05  -5.51200000E-05  -9.54700000E-05
   +2.71060000E-04  -6.59340000E-04  -9.53180000E-04  +5.07030000E-04  +1.50490000E-04
   -1.07660000E-04  -2.67860000E-04  +1.23029000E-03  -1.62368000E-03  -7.54270000E-04
   +4.02180000E-04  -2.75900000E-04  -4.15010000E-04  -2.17362950E-01  +1.22561640E-01
   +3.51782400E-02  +4.49180000E-04  +5.10660000E-04  +4.66920000E-04  +5.37770000E-04
   +2.63920000E-04  -9.68800000E-05  -7.57000000E-06  +5.48000000E-05  -4.91400000E-05
   +3.32110000E-04  -1.44150000E-04  -1.03980000E-04  -1.75100000E-04  -2.02790000E-04
   +1.87520000E-04  +2.75030000E-04  -3.66790000E-04  +3.81020000E-04  -3.29990000E-04
   +2.28410000E-04  +2.76100000E-05  -1.88000000E-05  -8.91000000E-06  -9.12000000E-06
   +1.21500000E-05  +2.06000000E-05  +9.40000000E-07  -9.81000000E-06  -5.34000000E-06
   -1.86700000E-05  -9.10660000E-04  -1.80330000E-03  -4.73350000E-04  +3.34600000E-05
   -8.52000000E-06  +2.37100000E-05  +3.10240000E-04  -1.66670000E-04  +2.47520000E-04
   -2.02860000E-04  +9.71300000E-05  +1.05850000E-04  +1.90640000E-04  -2.36050000E-04
   +9.00000000E-06  -1.04362000E-03  -6.85700000E-04  +1.04450000E-04  -1.94051900E-02
   +1.60042200E-02  +3.80185000E-03  +2.36293200E-01  +8.86400000E-05  +1.31550000E-04
   +9.17300000E-05  -2.22300000E-05  -3.87900000E-05  +3.96900000E-05  +1.32670000E-04
   +1.44450000E-04  +7.85900000E-05  -2.73290000E-04  -1.04500000E-04  -1.18560000E-04
   +6.09240000E-04  +4.38190000E-04  +2.53250000E-04  +2.50090000E-04  -4.29340000E-04
   -1.09160000E-03  -3.04460000E-04  +1.57350000E-04  +4.63280000E-04  +1.11640800E-02
   -8.18797000E-03  -9.71810000E-04  -1.61550000E-04  +4.01870000E-04  +1.30085000E-03
   +1.21355610E-01  -1.35110260E-01  -2.52360700E-02  -2.19450000E-04  -3.24870000E-04
   -2.86036000E-03  -3.82060000E-04  -3.64800000E-04  +1.94060000E-04  +5.84180000E-04
   -3.46620000E-04  +1.61830000E-04  -1.23700000E-04  +4.92680000E-04  -3.53540000E-04
   -4.99270000E-04  +3.19400000E-04  -4.12000000E-05  +4.20440000E-04  -1.59330000E-04
   -3.68340000E-04  +3.73950000E-04  -2.64290000E-04  +2.11600000E-05  -2.15000000E-06
   -1.19200000E-05  -3.45000000E-06  +8.05000000E-06  -2.15000000E-06  +1.94500000E-05
   +1.99800000E-05  +4.38000000E-05  +1.29090000E-04  -1.42764000E-03  -1.44221000E-03
   +6.20190000E-04  -1.38700000E-05  -3.07700000E-05  -2.13400000E-05  -1.89420000E-04
   +5.82540000E-04  -7.78600000E-05  -1.52130000E-04  -2.58300000E-05  -1.03540000E-04
   -2.44950000E-04  -5.29400000E-05  +4.68900000E-05  +1.72496000E-02  -1.19951100E-02
   -4.87557000E-03  -1.51552000E-02  +1.19958600E-02  +3.43452000E-03  -1.33252360E-01
   +1.44060430E-01  +6.23600000E-05  +5.40900000E-05  -4.77000000E-06  -1.19320000E-04
   -1.30200000E-05  +1.82010000E-04  +1.55610000E-04  +1.18270000E-04  -1.99000000E-06
   -1.01870000E-04  +3.05300000E-05  -2.57990000E-04  +3.27200000E-04  +5.94440000E-04
   +7.33120000E-04  -2.49940000E-04  +2.06050000E-04  +2.93500000E-04  -1.70090000E-04
   -9.67200000E-05  -5.36700000E-05  +2.43806000E-02  -1.60621000E-02  -5.66849000E-03
   +1.22346000E-03  -8.97330000E-04  +1.28480000E-03  +3.46581300E-02  -2.41610200E-02
   -5.51681900E-02  -1.38470000E-03  -1.70401000E-03  -4.90691000E-03  +5.01130000E-04
   -6.21760000E-04  +4.01900000E-05  +2.57380000E-04  +9.33100000E-05  +3.65150000E-04
   -4.85060000E-04  +1.75590000E-04  +8.71000000E-05  +6.40900000E-04  +1.68130000E-04
   -6.78400000E-05  +3.72700000E-05  +3.46560000E-04  +7.46900000E-05  +5.90550000E-04
   -4.54680000E-04  -3.52000000E-05  -5.04000000E-06  -1.68300000E-05  -5.41000000E-06
   +2.22400000E-05  -1.37300000E-05  +1.08800000E-05  +4.95000000E-05  -2.58000000E-06
   +5.75300000E-05  -5.68700000E-05  -1.04640000E-04  +2.93950000E-04  +3.17000000E-06
   -9.38000000E-06  +2.29000000E-06  -6.33030000E-04  +3.40360000E-04  -6.69430000E-04
   +3.99600000E-05  +1.29960000E-04  -5.91400000E-05  -2.49580000E-04  +7.55400000E-05
   +4.20860000E-04  -1.93960500E-02  +1.22643900E-02  +4.53576000E-03  -9.18860000E-04
   +9.44540000E-04  -7.10920000E-04  -3.90129100E-02  +2.91098700E-02  +5.95505300E-02
   +8.41700000E-05  +7.17400000E-05  +8.97000000E-06  -5.25200000E-05  -6.30900000E-05
   -1.45500000E-05  +5.76000000E-06  +1.39300000E-05  -5.68100000E-05  -3.77600000E-05
   +7.81900000E-05  +9.99800000E-05  -1.90700000E-04  +8.49300000E-05  -1.63470000E-04
   -1.48400000E-05  +2.83900000E-05  -2.28300000E-05  +4.03300000E-05  +2.37800000E-05
   +2.71100000E-05  +1.02330000E-04  -1.06616000E-03  -1.53030000E-03  -1.73718000E-03
   +4.56190000E-04  +9.41610000E-04  +3.08030000E-04  +6.60600000E-05  -8.68900000E-05
   +8.04181000E-03  -1.85577500E-02  +1.09599200E-02  -5.83629400E-02  +3.28057200E-02
   -1.12188200E-02  -6.04200000E-05  +2.31382000E-02  -1.54455100E-02  -2.62374000E-03
   +3.22128000E-03  +2.98711000E-03  -1.55447000E-03  +1.96000000E-05  +3.78040000E-04
   -1.86577000E-03  -2.25130000E-04  +4.90591000E-03  -3.29900000E-05  +1.33930000E-03
   -8.31530000E-04  -9.36000000E-06  -1.68000000E-05  -2.92000000E-06  +7.53000000E-06
   +1.23000000E-06  +1.12800000E-05  +5.52500000E-05  -6.91000000E-05  -4.65000000E-06
   -5.90000000E-06  -1.24400000E-05  +5.60000000E-07  +1.15700000E-05  -3.18000000E-06
   +2.30000000E-07  +1.91680000E-04  -1.44240000E-04  -8.30100000E-05  -1.47710000E-03
   +1.42965000E-03  +5.13150000E-04  -1.33178000E-03  +2.70950000E-04  -3.63460000E-04
   +1.28000000E-05  +6.89000000E-06  -1.41600000E-04  +3.10500000E-05  -3.79400000E-05
   +4.70000000E-06  -4.57400000E-05  -4.06600000E-05  -4.18900000E-05  +6.03484400E-02
   -2.64300000E-05  -2.98800000E-05  -2.19200000E-05  +1.78100000E-05  +3.15100000E-05
   +3.26900000E-05  +9.67000000E-06  +1.10000000E-06  -6.18200000E-05  -1.15710000E-04
   +4.43900000E-05  +1.36240000E-04  -2.63680000E-04  +2.93900000E-04  +2.43890000E-04
   -6.81100000E-05  -6.65400000E-05  -9.32200000E-05  -8.03000000E-06  -2.64200000E-05
   -3.42000000E-06  -1.30490000E-04  -2.08359000E-03  -1.44763000E-03  +2.06825000E-03
   -2.68860000E-04  -4.28610000E-04  +3.34390000E-04  -1.23820000E-04  -1.21320000E-04
   +1.55390000E-03  -4.59591000E-03  +4.91636000E-03  +3.24086200E-02  -2.47518110E-01
   +1.38656700E-01  +1.14570000E-04  -9.94791000E-03  +9.15560000E-03  +3.56019000E-03
   +2.41485000E-03  +1.21548000E-03  -2.98500000E-05  +1.06780000E-04  -7.37020000E-04
   -4.05230000E-04  +2.54074000E-03  +3.23054000E-03  +2.97180000E-04  -8.19560000E-04
   +6.34300000E-04  -2.53000000E-06  -2.83000000E-06  +8.74000000E-06  -5.31000000E-06
   -1.56900000E-05  +4.15000000E-06  -4.60000000E-07  -9.19200000E-05  +1.39200000E-05
   +1.04000000E-05  -2.67000000E-06  -6.22000000E-06  -5.51000000E-06  -1.24000000E-05
   -1.00000000E-08  +2.45520000E-04  +1.24470000E-04  -5.73460000E-04  +1.90564000E-03
   -5.62670000E-04  -3.50640000E-04  -2.33340000E-04  -2.18060000E-04  -3.76080000E-04
   +1.85000000E-06  -2.59000000E-06  -4.99400000E-05  -1.66400000E-05  -1.83600000E-05
   +2.27700000E-05  -6.76900000E-05  +1.31000000E-06  -8.17800000E-05  -4.04753800E-02
   +2.61786650E-01  -4.11900000E-05  -4.95100000E-05  -1.62300000E-05  +2.04000000E-05
   +3.82600000E-05  +5.41000000E-06  -1.29300000E-05  -2.52000000E-05  -1.61600000E-05
   -3.29500000E-05  -1.08000000E-05  +1.22100000E-04  -2.53690000E-04  +1.32050000E-04
   +2.57220000E-04  -6.47300000E-05  -9.43300000E-05  -4.98900000E-05  -2.68000000E-06
   -2.45000000E-05  -3.84000000E-06  -2.36315000E-03  -8.39720000E-04  -2.14676000E-03
   -2.87100000E-05  +7.32130000E-04  +5.37170000E-04  +7.43690000E-04  -1.81200000E-04
   -7.36700000E-05  -4.13363000E-03  +1.63643000E-02  -6.58654000E-03  -1.07456000E-02
   +1.38769080E-01  -1.31897570E-01  +1.42091000E-03  -3.83996000E-03  +4.65106000E-03
   +2.69590000E-03  +1.34348000E-03  +4.22520000E-03  +4.10720000E-04  -7.39010000E-04
   -5.96520000E-04  +5.04759000E-03  +2.94220000E-03  +1.55545000E-03  -4.74500000E-05
   +4.54800000E-05  +2.54830000E-04  -5.72000000E-06  +6.63000000E-06  +4.40000000E-06
   -9.25000000E-06  -8.46000000E-06  -3.72000000E-06  -5.00000000E-06  +3.02000000E-06
   -2.12500000E-05  +4.10000000E-06  +1.07000000E-05  -1.68900000E-05  -1.02000000E-05
   -4.33000000E-06  -2.18000000E-06  -4.52060000E-04  -3.95210000E-04  +6.69400000E-05
   +3.69170000E-04  -1.12034000E-03  -1.08860000E-04  -4.03630000E-04  +1.16960000E-04
   +9.72500000E-05  -6.48000000E-05  -3.85400000E-05  +8.55000000E-05  -1.56200000E-05
   -5.14300000E-05  -1.11430000E-04  -5.39000000E-06  -1.10230000E-04  -2.10990000E-04
   +9.97996000E-03  -1.51803030E-01  +1.32297580E-01  -7.34700000E-05  -6.26100000E-05
   -1.83800000E-05  +5.94000000E-05  +4.52500000E-05  +5.73000000E-06  -3.38600000E-05
   -1.88000000E-05  +9.13000000E-06  -2.11900000E-05  -6.64000000E-06  +2.86700000E-05
   -2.30400000E-05  +2.34090000E-04  +1.03780000E-04  -5.46700000E-05  -7.29900000E-05
   -4.62400000E-05  -7.91000000E-06  -2.23700000E-05  +4.44000000E-06  -1.50890000E-04
   -7.24090000E-04  +7.11830000E-04  -3.77000000E-06  -1.03380000E-04  +3.65100000E-05
   -2.15900000E-04  +8.47300000E-05  -7.02500000E-05  -2.15616000E-03  +4.71499000E-03
   +1.42764000E-03  -1.28750100E-02  -1.04391000E-02  +1.64397300E-02  -1.96425990E-01
   -5.81968600E-02  +1.35238470E-01  +6.12589000E-03  +3.33062000E-03  -2.80252000E-03
   +1.39877000E-03  +2.49466000E-03  +1.28583000E-03  -1.78500000E-04  +3.70440000E-04
   -1.00457000E-03  +2.17700000E-05  -1.65176000E-03  -1.12759000E-03  +5.36000000E-06
   +8.99000000E-06  +8.70000000E-06  -1.32900000E-05  -1.27200000E-05  -6.61000000E-06
   +3.61000000E-06  +1.63600000E-05  +1.59400000E-05  +9.41000000E-06  +1.18500000E-05
   -6.79000000E-06  -1.04900000E-05  -7.21000000E-06  +2.10000000E-07  -8.04000000E-06
   +4.84200000E-05  -1.38700000E-05  +2.97500000E-05  +2.14100000E-05  +9.30000000E-06
   -1.35000000E-05  +1.13200000E-05  -2.01800000E-05  +3.20000000E-07  -9.81000000E-06
   -4.64000000E-06  +2.44100000E-05  -1.27000000E-06  -1.82000000E-06  -2.10300000E-05
   +7.78100000E-05  +8.30200000E-05  +3.06000000E-05  -9.48590000E-04  -1.67159000E-03
   +2.04397740E-01  +2.35200000E-05  +1.77800000E-05  +5.30000000E-06  -5.77000000E-06
   -1.90100000E-05  -2.28600000E-05  -1.29500000E-05  +1.92000000E-06  -2.94000000E-06
   +1.06800000E-05  -7.70000000E-07  +2.35600000E-05  +1.96540000E-04  -1.80450000E-04
   -7.45200000E-05  +1.32800000E-05  +1.27500000E-05  +2.64600000E-05  +1.46600000E-05
   +3.90700000E-05  -2.40000000E-06  +4.45060000E-04  +5.10120000E-04  -2.87700000E-04
   -7.03900000E-05  +6.23300000E-05  -3.91300000E-05  +4.70600000E-05  +2.55300000E-05
   +5.48200000E-05  +4.41623000E-03  +5.97980000E-04  +1.59710000E-03  +1.16291100E-02
   +9.09730000E-03  -1.16482700E-02  -5.66801300E-02  -8.11198500E-02  +6.64036300E-02
   -2.07720200E-02  -2.49806000E-03  +1.78425400E-02  +3.29623000E-03  -1.46582000E-03
   +4.25757000E-03  +4.47200000E-04  -1.39660000E-03  -2.84970000E-04  -1.10722000E-03
   +6.81730000E-04  -2.87171000E-03  -1.40000000E-06  -1.34000000E-06  -7.00000000E-08
   -2.46000000E-06  -3.80000000E-07  +2.05000000E-06  +5.07000000E-06  +8.86000000E-06
   +9.43000000E-06  +5.29000000E-06  -1.00900000E-05  -1.05000000E-06  +4.09000000E-06
   +6.09000000E-06  -2.09000000E-06  +4.00000000E-08  -8.91000000E-06  +3.05700000E-05
   +3.74000000E-06  -3.58800000E-05  -5.39000000E-06  +2.51000000E-06  +2.27900000E-05
   +3.22400000E-05  -7.24000000E-06  -9.00000000E-08  -1.27000000E-05  -1.32000000E-05
   -8.74000000E-06  -1.30500000E-05  +9.90000000E-07  +3.23000000E-06  -2.59500000E-05
   -1.44571000E-03  -5.89820000E-04  -1.79646000E-03  +6.09506300E-02  +7.72916600E-02
   +4.64400000E-05  +3.54100000E-05  +8.55000000E-06  -2.77200000E-05  -3.54500000E-05
   -2.85800000E-05  -8.62000000E-06  -9.57000000E-06  -1.41800000E-05  +8.43000000E-06
   -8.80000000E-07  +2.15300000E-05  +1.67690000E-04  -9.79700000E-05  -3.20900000E-05
   -5.88000000E-06  -1.12100000E-05  +3.21400000E-05  +1.90100000E-05  +3.56800000E-05
   +1.23600000E-05  -3.86100000E-05  +2.19790000E-04  +2.02990000E-04  +4.21000000E-06
   -1.87500000E-05  -5.87800000E-05  +6.47000000E-06  +6.38400000E-05  +2.15300000E-05
   +1.43539000E-03  +1.43691000E-03  +4.39011000E-03  +1.69040000E-04  +1.06035000E-03
   +1.48856000E-03  +1.34195180E-01  +6.72726000E-02  -1.61854440E-01  +1.50729600E-02
   +3.95854000E-03  -6.03025000E-03  +6.47180000E-04  +4.70340000E-03  +3.01522000E-03
   -1.12381000E-03  -2.17760000E-04  -6.45070000E-04  -1.58657000E-03  -2.51593000E-03
   -1.32091000E-03  -6.68000000E-06  -5.62000000E-06  -2.60000000E-06  -2.21000000E-06
   +1.25000000E-06  +2.53000000E-06  -8.94000000E-06  +1.72000000E-06  -6.53000000E-06
   +2.16000000E-06  -4.16000000E-06  -2.19000000E-06  +1.94000000E-06  +6.20000000E-06
   -3.72000000E-06  +2.18400000E-05  +2.85000000E-06  +1.94300000E-05  +2.28700000E-05
   +9.45000000E-06  +8.60000000E-06  -2.56400000E-05  +2.52400000E-05  +4.10000000E-06
   -1.09600000E-05  +2.71000000E-06  -2.47400000E-05  +1.56000000E-06  -2.13000000E-06
   +7.43000000E-06  +3.01000000E-06  +3.73700000E-05  -1.35000000E-05  -1.31695000E-03
   -2.08676000E-03  -1.82880000E-03  -1.47919140E-01  -7.38234100E-02  +1.63954730E-01
   +2.43130000E-04  +2.01410000E-04  +2.79000000E-05  -3.31460000E-04  -1.45800000E-04
   +1.62540000E-04  +3.31810000E-04  +1.31710000E-04  -7.27000000E-05  -3.89840000E-04
   +8.17100000E-05  -3.47750000E-04  -7.14990000E-04  +7.87850000E-04  -4.27910000E-04
   -9.69500000E-05  +6.34200000E-05  +1.47300000E-05  -1.48530000E-04  -1.52640000E-04
   +6.94000000E-06  -8.11530000E-04  -1.25750000E-04  -9.18980000E-04  -1.49800000E-05
   -1.20360000E-04  -9.84000000E-05  -6.37300000E-05  +1.23220000E-04  +1.29370000E-04
   +6.65801000E-03  +4.96430000E-04  -2.72714000E-03  +2.00485000E-03  +2.16022000E-03
   +3.47850000E-04  -5.06200000E-04  +5.92010000E-04  -9.60790000E-04  -1.39625000E-03
   +4.63329000E-03  +9.53000000E-04  -1.44969600E-02  -1.18595200E-02  +1.91212400E-02
   -1.92110670E-01  -5.86334700E-02  +1.27983090E-01  -1.47865000E-03  -2.06840000E-04
   +7.12100000E-04  -2.14200000E-05  -3.74000000E-05  -1.69800000E-05  +1.31400000E-05
   +1.16900000E-05  +1.85300000E-05  +3.27700000E-05  -3.30300000E-05  +5.84700000E-05
   +4.26700000E-05  +1.91900000E-05  +5.50000000E-07  +1.25400000E-05  -2.15000000E-06
   -9.58000000E-06  +7.34600000E-05  -3.02000000E-06  -4.14000000E-06  -1.17900000E-05
   -5.52900000E-05  +3.68400000E-05  -7.64000000E-06  +5.98000000E-06  -2.64900000E-05
   +2.08340000E-04  +1.81420000E-04  -1.31770000E-04  +1.73300000E-05  -5.97900000E-05
   +2.09100000E-05  -2.16100000E-05  +8.13300000E-05  -2.08540000E-04  +3.34100000E-04
   +2.79050000E-04  -1.01690000E-04  -6.96200000E-05  -7.81600000E-05  -3.06800000E-05
   +2.01912360E-01  -1.78670000E-04  -1.54290000E-04  -3.29700000E-05  +2.19460000E-04
   +1.94800000E-05  -1.76950000E-04  -2.53010000E-04  -2.62170000E-04  +6.92700000E-05
   +1.87480000E-04  +3.11540000E-04  +3.57210000E-04  +4.30250000E-04  -5.70800000E-05
   +6.36000000E-06  +5.88900000E-05  +2.13000000E-06  -6.16000000E-06  +1.25740000E-04
   +1.06760000E-04  -8.88000000E-06  -1.63512000E-03  -3.09240000E-04  -9.74260000E-04
   -5.61400000E-05  +1.58500000E-05  -1.14140000E-04  +2.19130000E-04  -6.19790000E-04
   +3.71020000E-04  -2.06277400E-02  -3.25090000E-03  +1.54912500E-02  +2.79966000E-03
   -2.76017000E-03  +4.68495000E-03  +4.14350000E-04  -1.02747000E-03  -5.33430000E-04
   +4.09055000E-03  +3.78900000E-05  +2.29062000E-03  +1.28840500E-02  +7.09244000E-03
   -8.75505000E-03  -5.87741100E-02  -8.33681300E-02  +6.69628300E-02  +6.45920000E-04
   +2.02840000E-04  -8.00120000E-04  -1.56000000E-06  +2.61700000E-05  +9.18000000E-06
   -2.73100000E-05  -1.26200000E-05  -2.07800000E-05  +2.32000000E-06  +2.71100000E-05
   -9.28600000E-05  +8.10500000E-05  -6.93500000E-05  -3.14900000E-05  -1.33200000E-05
   +5.70000000E-06  +3.93000000E-06  +7.28200000E-05  +1.43800000E-05  -2.79100000E-05
   -4.38000000E-06  +9.05700000E-05  +2.28600000E-05  -6.69100000E-05  +3.09300000E-05
   -1.04690000E-04  +2.33930000E-04  -6.29110000E-04  -7.36720000E-04  +4.44000000E-05
   +1.49360000E-04  +2.00700000E-05  +8.04000000E-06  +2.33800000E-04  -3.48170000E-04
   -9.88430000E-04  -2.13110000E-04  +1.02102000E-03  -1.25530000E-04  -2.58100000E-05
   -8.34200000E-05  +6.19054800E-02  +8.30807900E-02  +2.40620000E-04  +1.74400000E-04
   +5.10100000E-05  -2.15230000E-04  -1.51170000E-04  -1.45230000E-04  -8.57900000E-05
   -2.24650000E-04  -3.58800000E-05  +1.74400000E-04  -2.68190000E-04  -1.28460000E-04
   -5.98200000E-05  +2.76430000E-04  +2.89560000E-04  -4.24420000E-04  -3.37150000E-04
   +2.74370000E-04  +3.52700000E-05  +1.59310000E-04  +1.38550000E-04  +7.30700000E-05
   -1.68278000E-03  -1.77609000E-03  -2.86790000E-04  -3.86400000E-05  -2.39600000E-05
   +2.17400000E-05  -1.73560000E-04  +8.40100000E-05  +1.23940400E-02  +4.30008000E-03
   -7.13663000E-03  +1.93390000E-04  +5.23373000E-03  +2.04599000E-03  -9.77270000E-04
   -6.23840000E-04  -5.28110000E-04  +1.44383000E-03  +1.88273000E-03  +4.40960000E-03
   +1.98609000E-03  +4.71225000E-03  +1.57690000E-04  +1.26953120E-01  +6.60593200E-02
   -1.49558720E-01  +2.45020000E-04  -3.38470000E-04  -2.60020000E-04  -3.59600000E-05
   -2.09400000E-05  -3.04500000E-05  -1.01000000E-05  +2.61700000E-05  -7.44000000E-06
   +5.41600000E-05  +1.14960000E-04  -2.32300000E-05  +3.93900000E-05  -3.48100000E-05
   -5.06900000E-05  +6.48000000E-06  +1.10000000E-07  -8.31000000E-06  -5.80400000E-05
   +9.21400000E-05  -7.00000000E-07  -4.22000000E-06  -1.21490000E-04  +1.63900000E-05
   +4.42100000E-05  +3.27500000E-05  +3.56000000E-06  +1.90840000E-04  -3.29860000E-04
   -8.06900000E-05  +3.35100000E-05  -1.13370000E-04  +2.65200000E-05  -3.72200000E-05
   +1.93440000E-04  -1.06660000E-04  +8.05760000E-04  +3.04090000E-04  -2.87940000E-04
   -3.28000000E-06  -1.02640000E-04  -1.56060000E-04  -1.41214120E-01  -7.56075000E-02
   +1.53607600E-01  +1.28210000E-04  +8.41900000E-05  +2.41200000E-05  -1.23840000E-04
   -8.29200000E-05  -1.83000000E-05  +3.57000000E-05  -2.83500000E-05  -2.77400000E-05
   +5.25000000E-06  -3.17700000E-05  +1.34300000E-05  +7.50000000E-07  -1.25800000E-05
   +5.88000000E-06  -1.45800000E-05  -1.28800000E-05  +3.63800000E-05  +1.34800000E-05
   +8.73000000E-06  +3.05800000E-05  -1.31090000E-04  -5.22900000E-05  +7.16600000E-05
   +5.96600000E-05  -7.98000000E-06  -1.54000000E-05  +1.58200000E-05  +2.87300000E-05
   -2.85900000E-05  -3.28700000E-04  -1.66180000E-04  +2.49010000E-04  +1.43613000E-03
   +9.12530000E-04  -4.47120000E-04  -6.15579000E-03  +2.91312000E-03  +1.96781000E-03
   -3.34343000E-03  +3.62515100E-02  -2.59932600E-02  -2.52041000E-03  +6.19021000E-03
   -1.98860000E-03  +4.28980000E-04  -1.83470000E-04  -4.53820000E-04  -4.09728200E-02
   -3.43379900E-02  +4.53069800E-02  -3.20000000E-05  -1.18400000E-05  -1.51300000E-05
   -8.56000000E-06  +1.44800000E-05  -3.11000000E-06  -1.82900000E-05  +1.40100000E-05
   -3.06300000E-05  -1.23400000E-05  +8.33000000E-06  -5.02000000E-06  +1.62000000E-06
   +6.13000000E-06  -6.86000000E-06  +1.70800000E-05  -2.88500000E-05  +8.04000000E-06
   -2.12100000E-05  -1.66000000E-06  -6.05000000E-06  -6.21000000E-06  +1.02500000E-05
   -4.62000000E-06  -1.26800000E-05  +8.89000000E-06  +3.74500000E-05  -1.17700000E-05
   -1.30000000E-07  +1.27900000E-05  +2.23100000E-05  -2.34900000E-05  +3.66000000E-06
   -3.44550000E-04  +1.69560000E-04  +5.89500000E-05  -7.30900000E-05  -1.76280000E-04
   -1.30750000E-04  +2.30800000E-05  -1.70500000E-05  +5.18500000E-05  +5.00770200E-02
   -1.74120000E-04  -1.63950000E-04  -3.01100000E-05  +1.37480000E-04  +1.26750000E-04
   +4.96200000E-05  -3.73200000E-05  -7.80000000E-07  +5.00200000E-05  -1.32800000E-05
   -1.03800000E-05  -1.41500000E-05  -1.68600000E-05  +1.52890000E-04  +1.24000000E-05
   +3.03000000E-06  -8.15000000E-06  -5.28800000E-05  -2.94200000E-05  -6.67400000E-05
   -3.76100000E-05  +2.47760000E-04  -1.30540000E-04  +4.56300000E-05  -6.26100000E-05
   -2.00400000E-05  +3.53700000E-05  -1.44560000E-04  +6.46100000E-05  -3.79000000E-05
   -1.51770000E-04  +4.97050000E-04  -4.78900000E-04  -1.77060000E-04  -2.24410000E-04
   +1.57863000E-03  +3.19739000E-03  +6.66420000E-04  -1.61149000E-03  +4.24596000E-03
   -2.63566300E-02  +1.49794200E-02  -1.94669000E-03  +3.38812000E-03  +1.09000000E-05
   +1.25280000E-04  -1.63660000E-03  +7.00940000E-04  +4.07664000E-03  -3.31972520E-01
   +2.35555540E-01  +1.34900000E-05  +3.68400000E-05  +9.22000000E-06  -1.80000000E-05
   -9.77000000E-06  -2.32700000E-05  +2.98500000E-05  +2.73300000E-05  +4.92800000E-05
   +1.65800000E-05  +8.87000000E-06  -8.66000000E-06  -1.37800000E-05  -4.87000000E-06
   +4.26000000E-06  -2.95200000E-05  +3.65500000E-05  -7.33000000E-06  +1.03900000E-05
   -2.22100000E-05  +6.84000000E-06  +1.69900000E-05  -9.14000000E-06  -7.36000000E-06
   +1.91400000E-05  -1.27000000E-05  -1.12300000E-05  +3.00000000E-07  -3.91700000E-05
   -2.83100000E-05  -5.15000000E-05  +4.72700000E-05  +6.45700000E-05  +1.66090000E-04
   -2.46400000E-05  -8.02300000E-05  -1.41300000E-04  +5.90000000E-05  -3.59640000E-04
   -2.78940000E-04  +2.32950000E-04  +8.38800000E-05  -8.51226000E-03  +3.56990850E-01
   +4.03000000E-05  +3.44600000E-05  -2.98000000E-06  -2.79400000E-05  -2.90600000E-05
   -1.05900000E-05  +7.83000000E-06  -6.86000000E-06  -1.16300000E-05  -2.84000000E-06
   +1.53000000E-05  +4.15800000E-05  +1.02200000E-05  -5.70900000E-05  -2.89300000E-05
   -1.33800000E-05  +1.14500000E-05  +6.43000000E-06  +2.28400000E-05  +3.23300000E-05
   -3.87000000E-06  -1.61830000E-04  +6.20600000E-05  -1.57450000E-04  +1.60900000E-05
   +1.65700000E-05  -2.22000000E-05  +1.51630000E-04  -8.96700000E-05  +4.69700000E-05
   +2.56900000E-04  -3.69790000E-04  +1.26200000E-04  +3.46010000E-04  +9.86810000E-04
   +8.82690000E-04  +1.70718000E-03  -1.35838000E-03  +1.06844000E-03  -2.60487000E-03
   -3.29021000E-03  +1.39792000E-03  +3.92465000E-03  -4.63058000E-03  +2.92625000E-03
   -6.94920000E-04  +8.87250000E-04  -8.24590000E-04  +1.72588700E-02  +2.57390260E-01
   -2.02924570E-01  -7.43000000E-06  -5.70000000E-06  +4.39000000E-06  -6.32000000E-06
   -8.50000000E-07  +1.16000000E-06  -6.10000000E-06  +4.65000000E-06  -2.41100000E-05
   +3.46000000E-06  -1.38700000E-05  -4.40000000E-07  +9.69000000E-06  +1.50000000E-07
   -9.00000000E-07  +1.17900000E-05  -1.52000000E-05  -3.04000000E-06  -6.22000000E-06
   +4.11000000E-06  +3.92000000E-06  -1.10100000E-05  +3.13000000E-06  -1.17000000E-05
   +1.05000000E-05  +1.94900000E-05  -1.20300000E-05  -3.59000000E-06  +4.42000000E-06
   +2.05000000E-05  +1.84300000E-05  -2.96100000E-05  -6.98100000E-05  +5.83500000E-05
   -8.23000000E-05  +1.06100000E-05  -1.59480000E-04  -3.36370000E-04  -1.85530000E-04
   +2.60270000E-04  -7.87800000E-05  +1.88200000E-05  -1.85535500E-02  -2.50364000E-01
   +1.99729020E-01  -2.49560000E-04  -1.91260000E-04  -5.00600000E-05  +2.17780000E-04
   +1.70750000E-04  +7.16000000E-05  -3.91900000E-05  +4.17600000E-05  +3.91900000E-05
   -6.59600000E-05  +3.72900000E-05  +2.17100000E-05  +1.12330000E-04  +8.54400000E-05
   +4.10300000E-05  +5.89100000E-05  +2.40500000E-05  -1.14260000E-04  -4.31100000E-05
   -7.11200000E-05  -7.85400000E-05  +5.93070000E-04  +1.13042000E-03  -1.12309000E-03
   -5.67360000E-04  +1.55250000E-04  +2.11360000E-04  +4.02000000E-05  -1.10020000E-04
   -1.03410000E-04  -3.66325000E-03  -1.45821000E-03  +7.90829000E-03  +2.21284000E-03
   +1.01877000E-03  -2.70452000E-03  -5.84408000E-03  +2.42404000E-03  +4.10275000E-03
   +2.66166000E-03  -2.42117400E-02  +2.08552900E-02  -1.08557030E-01  +3.18032600E-02
   +1.40339600E-02  -2.96507000E-03  +3.94181000E-02  -2.32348400E-02  +5.63251000E-03
   -8.13499000E-03  +9.34700000E-04  +4.15800000E-05  +3.01500000E-05  +2.56800000E-05
   -6.10000000E-06  -2.50600000E-05  -7.25000000E-06  +8.18000000E-06  -4.43000000E-06
   +4.12900000E-05  +2.07800000E-05  -1.14000000E-06  +5.11000000E-06  -1.39800000E-05
   -1.13600000E-05  +8.10000000E-06  -8.17700000E-05  +1.45510000E-04  -1.47800000E-04
   +3.58000000E-05  -9.63000000E-06  +4.10000000E-06  +2.05600000E-05  -4.87000000E-06
   -3.01800000E-05  +2.63800000E-05  -4.05300000E-05  -6.10800000E-05  +3.37000000E-05
   +2.24300000E-05  +8.46000000E-06  -3.49400000E-05  +6.67900000E-05  -2.34000000E-06
   +2.22840000E-04  -1.37530000E-04  -3.42810000E-04  +3.19970000E-04  -1.17089000E-03
   +6.03880000E-04  +1.84182000E-03  -1.28062000E-03  -2.58771000E-03  +8.24840000E-04
   -2.95420000E-04  -9.08430000E-04  +4.52497760E-01  +8.97800000E-04  +8.83270000E-04
   +1.23770000E-04  -6.89090000E-04  -6.64150000E-04  -2.73550000E-04  +1.47610000E-04
   +5.82600000E-05  -2.85860000E-04  -4.13100000E-05  +4.93300000E-05  +1.28190000E-04
   -2.90520000E-04  -7.11110000E-04  -1.80630000E-04  -1.57010000E-04  +5.18500000E-05
   +2.59580000E-04  +2.05030000E-04  +4.00090000E-04  +1.72210000E-04  -1.41987000E-03
   -2.62590000E-04  +1.35966000E-03  +8.73410000E-04  -3.14010000E-04  -2.48750000E-04
   +3.15810000E-04  -1.72500000E-05  -2.55300000E-05  +2.37195000E-03  +2.79212000E-03
   +2.57342000E-03  +4.67465000E-03  -5.65391000E-03  +7.53440000E-04  -2.42876000E-03
   +7.81377000E-03  -1.25737000E-03  +6.64383000E-03  -3.28656200E-02  +2.60850800E-02
   +6.77909800E-02  -2.26939980E-01  +9.82134600E-02  +8.14203000E-03  -2.90785800E-02
   +2.09368900E-02  -5.58420000E-03  +6.56052000E-03  -3.75598000E-03  -4.14200000E-05
   -2.05290000E-04  -1.12900000E-05  +9.85800000E-05  +2.95000000E-05  +1.43800000E-04
   -2.04410000E-04  -2.11660000E-04  -2.30100000E-04  -7.86200000E-05  -6.61600000E-05
   +3.52200000E-05  +1.06610000E-04  -6.30000000E-07  -8.99000000E-06  +2.68780000E-04
   -3.18470000E-04  +2.02500000E-05  -5.11800000E-05  +3.08760000E-04  +7.92000000E-06
   -1.89610000E-04  +3.46400000E-05  -1.53240000E-04  -6.94700000E-05  +4.84100000E-05
   +8.21600000E-05  -2.77600000E-05  +1.48460000E-04  +1.63610000E-04  +1.91000000E-04
   -2.42770000E-04  -1.06210000E-04  -1.85820000E-04  -1.60370000E-04  -2.06780000E-04
   +7.05900000E-05  -6.71300000E-04  +3.29990000E-04  -1.88645000E-03  +1.42891000E-03
   -3.04455000E-03  -1.36531000E-03  -1.32590000E-03  +7.72120000E-04  +2.18941100E-02
   +3.36435280E-01  -5.17570000E-04  -4.70260000E-04  -5.83100000E-05  +3.94060000E-04
   +3.74510000E-04  +1.56020000E-04  -5.90200000E-05  +4.15600000E-05  +1.76020000E-04
   -2.73200000E-05  -2.41500000E-05  -1.36580000E-04  -1.05980000E-04  +2.92070000E-04
   +1.32450000E-04  +1.50280000E-04  -1.48700000E-05  -1.74020000E-04  -1.47830000E-04
   -2.65330000E-04  -9.32700000E-05  +1.18154000E-03  -2.95900000E-05  +1.43600000E-05
   -2.68210000E-04  +3.39800000E-05  +7.12700000E-05  -2.16040000E-04  +1.05450000E-04
   -8.28100000E-05  +4.74361000E-03  +4.99288000E-03  +1.49713000E-03  -5.58726000E-03
   +2.65824000E-03  -2.22240000E-04  +7.59573000E-03  -4.06636000E-03  +3.14453000E-03
   -1.26950000E-03  +4.37160200E-02  -2.24588300E-02  -1.18880500E-02  +1.16523370E-01
   -1.17863980E-01  -4.98840000E-04  +3.49006000E-03  +4.86965000E-03  -9.59400000E-04
   -2.49187000E-03  -7.22620000E-04  +4.95200000E-05  +1.00100000E-04  +8.53000000E-06
   -2.44900000E-05  -2.18400000E-05  -5.39900000E-05  +1.30800000E-04  +9.69400000E-05
   +1.55460000E-04  +2.33800000E-05  +5.84800000E-05  -7.47000000E-06  -6.99400000E-05
   -2.40000000E-07  +5.84000000E-06  -1.92340000E-04  +4.98100000E-05  +5.06000000E-06
   +2.34000000E-05  -2.22620000E-04  +1.73000000E-06  +1.37320000E-04  -9.47000000E-06
   +9.57900000E-05  -1.11800000E-05  -6.58900000E-05  -7.52000000E-06  +9.65000000E-06
   -8.59500000E-05  -1.32960000E-04  -1.25890000E-04  +8.83100000E-05  +1.25060000E-04
   -3.26320000E-04  -2.36730000E-04  -2.24690000E-04  -3.26650000E-04  +9.82950000E-04
   -7.46660000E-04  -2.05988000E-03  -3.60044000E-03  -1.03129000E-03  -1.08270000E-04
   +2.25330000E-04  -1.37469000E-03  -2.40960630E-01  -2.33979270E-01  +3.18956010E-01
   +4.98200000E-05  -3.40000000E-07  +2.22600000E-05  -8.20500000E-05  -2.92100000E-05
   +2.90000000E-06  +2.92600000E-05  -5.22100000E-05  +5.10000000E-07  +3.45100000E-05
   -4.76800000E-05  -4.49500000E-05  +7.28300000E-05  +5.69100000E-05  +3.02200000E-05
   +1.99800000E-05  -1.14400000E-05  +4.85100000E-05  -2.61600000E-05  -6.58800000E-05
   +3.54900000E-05  +6.50700000E-05  +1.08630000E-04  -1.02550000E-04  -5.30600000E-05
   +1.83000000E-05  -1.43800000E-05  -1.55600000E-05  +1.87100000E-05  -1.82400000E-05
   -7.97440000E-04  +1.87840000E-04  -7.50800000E-05  -4.28800000E-04  +4.50670000E-04
   +2.17200000E-05  +5.93850000E-04  -5.53260000E-04  +6.11880000E-04  -7.67600000E-04
   +4.04737000E-03  -1.51469000E-03  +6.57888000E-03  +3.41197000E-03  -7.02944000E-03
   +2.89779000E-03  +2.54981000E-03  -3.61055000E-03  +6.44960000E-04  -1.24737000E-03
   +7.02030000E-04  -3.24500000E-05  +6.97000000E-06  -2.30300000E-05  -1.32400000E-05
   +1.57600000E-05  -1.82800000E-05  +1.30100000E-05  +3.23600000E-05  +7.13000000E-06
   -3.87000000E-06  +2.54700000E-05  -1.08200000E-05  -1.75600000E-05  +1.35000000E-05
   -7.08000000E-06  -1.39200000E-05  +1.64100000E-05  +9.49000000E-06  -1.17300000E-05
   -4.65300000E-05  +7.14000000E-06  +1.66800000E-05  +2.58000000E-06  +1.72800000E-05
   +2.75000000E-05  +2.82000000E-05  +3.99300000E-05  -1.22600000E-05  -4.97700000E-05
   +6.38000000E-06  -6.16000000E-06  +5.40000000E-06  -6.00000000E-08  -8.05200000E-05
   -3.60900000E-05  +6.30900000E-05  +2.43000000E-06  +3.18900000E-05  -1.86140000E-04
   -1.05657000E-03  -3.73630000E-04  +1.01318000E-03  +1.04143000E-03  -2.11950000E-04
   -9.47090000E-04  -3.45292090E-01  -9.99819800E-02  +2.51311310E-01  +3.36623040E-01
   -2.46900000E-04  -2.62710000E-04  -3.54700000E-05  +2.19010000E-04  +1.88630000E-04
   +5.93800000E-05  -6.09100000E-05  -5.17800000E-05  +6.25000000E-05  +7.94000000E-06
   +4.55500000E-05  +1.98100000E-05  +4.73900000E-05  +1.45150000E-04  -6.23000000E-06
   +1.87500000E-05  +1.43700000E-05  -7.35300000E-05  -2.03200000E-05  -7.24600000E-05
   -5.35600000E-05  +2.10660000E-04  +5.37400000E-05  -1.01810000E-04  -1.62180000E-04
   +7.95000000E-06  +3.86400000E-05  -9.94200000E-05  -4.33100000E-05  +3.47200000E-05
   -1.64140000E-04  -7.82830000E-04  +2.37520000E-04  +4.19750000E-04  +3.53000000E-04
   -3.58590000E-04  -1.35831000E-03  +7.68610000E-04  +9.99210000E-04  +3.51012000E-03
   -5.17095000E-03  +3.02143000E-03  -3.28451800E-02  -1.48084800E-02  +2.63484400E-02
   -1.60423000E-03  +2.25875000E-03  -1.12276000E-03  +1.21698000E-03  +8.99400000E-04
   -1.19020000E-03  +2.72000000E-06  +6.37700000E-05  -2.46000000E-06  -2.97200000E-05
   -5.75000000E-06  -4.41700000E-05  +1.98000000E-05  +2.66000000E-05  +4.08100000E-05
   +3.73700000E-05  -5.38000000E-06  -1.35100000E-05  -2.32600000E-05  +3.55000000E-06
   +4.46000000E-06  -3.47100000E-05  +6.53200000E-05  -2.21900000E-05  +9.48000000E-06
   -2.67900000E-05  +6.58000000E-06  +1.74800000E-05  +1.57000000E-06  -2.07600000E-05
   +6.92200000E-05  -1.93100000E-05  -7.50500000E-05  +5.82000000E-06  -2.68100000E-05
   -1.45000000E-05  -5.08400000E-05  +8.07600000E-05  +3.68000000E-06  +1.09690000E-04
   +5.00200000E-05  -1.06050000E-04  +5.28600000E-05  -4.05210000E-04  +6.93700000E-05
   +1.92321000E-03  -3.50360000E-04  -4.32170000E-04  -1.56740000E-03  -2.96360000E-04
   +5.13780000E-04  -6.13093200E-02  -5.73333900E-02  +7.17548200E-02  +9.16785900E-02
   +7.46351400E-02  +1.45080000E-04  +9.75800000E-05  +7.25000000E-06  -1.40240000E-04
   -9.61400000E-05  -1.19700000E-05  +1.93600000E-05  -9.45600000E-05  -3.28500000E-05
   +4.83700000E-05  +4.85000000E-06  +5.48300000E-05  +2.82300000E-05  -6.74100000E-05
   -3.32000000E-05  -6.54200000E-05  +6.15000000E-06  +4.76900000E-05  +3.92900000E-05
   +6.88100000E-05  +1.14600000E-05  -1.83660000E-04  -6.63000000E-05  +1.21480000E-04
   +1.02450000E-04  -4.36700000E-05  -5.97900000E-05  +5.57900000E-05  -7.13700000E-05
   +7.14400000E-05  +1.04980000E-04  -1.05150000E-04  -7.29330000E-04  +1.48960000E-04
   -4.02400000E-04  +4.39570000E-04  +1.24060000E-03  +6.07070000E-04  -1.55140000E-04
   -1.03316000E-03  +2.78446000E-03  +4.32870000E-04  +1.88586500E-02  +7.60991000E-03
   -1.77716400E-02  -6.68860000E-04  -3.30596000E-03  +2.23357000E-03  -1.11367000E-03
   +4.09450000E-04  +6.17040000E-04  -3.87100000E-05  -1.16100000E-05  -8.71000000E-06
   -2.17000000E-05  +1.60900000E-05  -1.78900000E-05  -1.61700000E-05  +3.07800000E-05
   -6.19500000E-05  +7.89000000E-06  -3.15400000E-05  -8.70000000E-06  +2.54400000E-05
   -1.89000000E-06  -2.48000000E-06  +4.15300000E-05  -3.12000000E-05  +1.90800000E-05
   -1.63500000E-05  +1.87400000E-05  +7.40000000E-06  -2.18700000E-05  +1.17000000E-05
   -2.53100000E-05  +1.90600000E-05  +2.92900000E-05  +7.20000000E-06  -1.12800000E-05
   +2.39000000E-06  +2.26000000E-05  +2.80600000E-05  -2.05100000E-05  -4.65200000E-05
   -3.11200000E-05  -1.35500000E-05  +3.32300000E-05  -2.05340000E-04  +8.54600000E-05
   -2.35200000E-04  -4.96770000E-04  +8.24150000E-04  +2.52870000E-04  -4.17700000E-05
   -3.08800000E-04  -6.15830000E-04  +2.23540440E-01  +9.16073500E-02  -1.84022960E-01
   -2.40348090E-01  -9.95421400E-02  +1.99459890E-01
end_hess

