# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.35627590    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.45879638E+00  -1.06532421E+00  -2.05709439E+00
   006   -3.12631342E+00  +9.97080818E-01  -4.48372583E-01
   006   -5.02064633E+00  +1.48304874E+00  +1.29309646E+00
   006   -7.17765037E+00  -1.02575388E-02  +1.42679843E+00
   006   -7.47066493E+00  -2.03478699E+00  -2.03848741E-01
   006   -5.58721808E+00  -2.56238225E+00  -1.95802294E+00
   006   -7.50415123E-01  +2.62660719E+00  -7.11400927E-01
   006   -7.88312881E-01  +3.86155138E+00  -3.33765247E+00
   008   -9.53473494E+00  -3.56427485E+00  -1.71317922E-01
   006   +1.61219268E+00  +1.02291394E+00  -2.91930908E-01
   006   +3.58142486E+00  +1.01703154E+00  -1.84493284E+00
   006   +5.99822795E+00  -3.38381337E-01  -1.27628018E+00
   006   +6.32336460E+00  -8.37907498E-01  +1.51379557E+00
   006   +4.36176986E+00  -8.79862961E-01  +3.07345068E+00
   006   +1.72701103E+00  -5.95206321E-01  +2.07328982E+00
   008   +8.71738680E+00  -1.27369947E+00  +2.26672506E+00
   008   +8.14608770E+00  +9.85042264E-01  -2.22570764E+00
   006   -6.69637397E-01  +4.78246930E+00  +1.23836587E+00
   008   +6.80585251E-01  -3.00648409E+00  +1.40852414E+00
   001   -1.06786563E+01  -3.01039770E+00  +1.11451922E+00
   001   -8.62765463E+00  +4.16406181E-01  +2.81005945E+00
   001   -4.85861755E+00  +3.04784263E+00  +2.59561773E+00
   001   -1.98387005E+00  -1.54315379E+00  -3.39140887E+00
   001   -5.81056363E+00  -4.16306268E+00  -3.20813889E+00
   001   -2.53466625E+00  +4.93070313E+00  -3.55753381E+00
   001   +7.89345268E-01  +5.16720852E+00  -3.57766115E+00
   001   -7.12397527E-01  +2.46329066E+00  -4.84668658E+00
   001   -6.85429102E-01  +4.10210677E+00  +3.18156561E+00
   001   +1.05075423E+00  +5.88200611E+00  +9.69028743E-01
   001   -2.27940253E+00  +6.04574037E+00  +9.91249297E-01
   001   +5.28910168E-01  +2.46108946E-01  +3.53353074E+00
   001   +4.62714091E+00  -1.29106007E+00  +5.05980953E+00
   001   +6.03969382E+00  -2.15669048E+00  -2.26078314E+00
   001   +3.56563502E+00  +2.02638811E+00  -3.62373550E+00
   001   +9.80700682E+00  -7.75867789E-01  +8.95706875E-01
   001   +7.98832799E+00  +2.72536860E+00  -1.74535295E+00
   001   +1.03541395E+00  -4.15250968E+00  +2.76199488E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.00000000E-08  -2.00000000E-07  +1.40000000E-07
   -2.10000000E-07  -3.00000000E-07  -4.30000000E-07
   +2.00000000E-08  +6.10000000E-07  -1.20000000E-07
   -1.00000000E-08  +5.50000000E-07  -5.00000000E-08
   -6.00000000E-08  +3.80000000E-07  +1.60000000E-07
   -1.30000000E-07  -4.00000000E-08  +4.00000000E-07
   +2.10000000E-07  +2.60000000E-07  +1.70000000E-07
   +4.80000000E-07  -1.90000000E-07  -5.50000000E-07
   -2.10000000E-07  +3.30000000E-07  +4.60000000E-07
   -1.10000000E-07  +0.00000000E+00  -1.60000000E-07
   +7.00000000E-08  -6.40000000E-07  +2.60000000E-07
   +3.60000000E-07  +3.00000000E-08  +5.90000000E-07
   -7.00000000E-08  -1.90000000E-07  -5.30000000E-07
   -3.70000000E-07  +6.40000000E-07  +4.30000000E-07
   +3.00000000E-07  +8.30000000E-07  +5.10000000E-07
   -2.00000000E-08  -1.90000000E-07  +5.90000000E-07
   -1.00000000E-08  -7.90000000E-07  +3.70000000E-07
   +3.20000000E-07  -3.70000000E-07  -1.03000000E-06
   -5.20000000E-07  -2.10000000E-07  +6.10000000E-07
   -1.60000000E-07  +6.00000000E-07  +3.40000000E-07
   -7.00000000E-08  +7.80000000E-07  -1.40000000E-07
   +1.40000000E-07  +4.90000000E-07  -4.90000000E-07
   +3.00000000E-08  -3.80000000E-07  +3.40000000E-07
   -1.60000000E-07  -2.60000000E-07  +6.50000000E-07
   +1.30000000E-07  -5.80000000E-07  -7.80000000E-07
   +2.80000000E-07  -7.00000000E-07  -6.30000000E-07
   +5.00000000E-08  -8.10000000E-07  -3.30000000E-07
   -7.00000000E-08  +6.00000000E-07  -5.90000000E-07
   +1.60000000E-07  +2.50000000E-07  -8.40000000E-07
   +2.10000000E-07  +4.80000000E-07  -8.20000000E-07
   -2.00000000E-08  +1.90000000E-07  -3.00000000E-08
   -2.50000000E-07  +5.10000000E-07  +4.40000000E-07
   -1.30000000E-07  -7.70000000E-07  +4.70000000E-07
   +1.40000000E-07  -7.40000000E-07  -3.30000000E-07
   -2.40000000E-07  -4.00000000E-08  +5.00000000E-07
   +2.00000000E-08  -6.70000000E-07  -3.00000000E-07
   -1.10000000E-07  +5.30000000E-07  +7.50000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.35136300E-01  +1.41545350E-01  +4.97366410E-01  -1.92045310E-01  +2.10591010E-01
   +4.56199920E-01  -1.19290240E-01  -5.43783700E-02  -1.62543000E-02  +5.52194980E-01
   -6.92262000E-03  -2.19086020E-01  -1.26648550E-01  +1.02646210E-01  +4.79850150E-01
   +2.75175000E-02  -9.45555500E-02  -1.72221230E-01  -1.60493880E-01  +1.87533950E-01
   +4.63531100E-01  +4.03982300E-02  +6.16339800E-02  +3.37302800E-02  -2.24759780E-01
   -1.32055000E-02  +9.58612000E-02  +5.68923140E-01  +2.53196200E-02  +5.79893000E-03
   -1.86386900E-02  +3.25981300E-02  -1.15361860E-01  -6.77393800E-02  +1.50765560E-01
   +5.27572040E-01  +8.57910000E-04  -4.41894900E-02  -3.14675700E-02  +1.38987000E-01
   -3.62089800E-02  -1.93608270E-01  -1.59998950E-01  +2.46335900E-01  +4.72929220E-01
   -2.27565100E-02  -3.21880300E-02  -1.46358800E-02  -4.34522700E-02  +1.14771900E-02
   +4.55457300E-02  -2.56725020E-01  -1.41559880E-01  +8.47017000E-03  +6.04394890E-01
   -2.79022800E-02  -4.77382600E-02  -2.08774400E-02  -2.40715900E-02  +4.14403300E-02
   +4.80242400E-02  -9.47265700E-02  -1.72043360E-01  -3.66751000E-02  +1.48587420E-01
   +4.89886460E-01  -1.20730400E-02  -1.78710300E-02  -1.21639500E-02  +1.30488000E-02
   +2.27300300E-02  +1.90030400E-02  +5.01496500E-02  -4.90173000E-03  -9.77816800E-02
   -1.96782070E-01  +2.29785840E-01  +4.66492870E-01  -4.84356900E-02  -2.83273800E-02
   +8.56579000E-03  -8.44541000E-03  +2.22807800E-02  +2.28274500E-02  +2.41671200E-02
   -1.76308000E-02  -3.11889100E-02  -1.22223960E-01  -5.26928000E-02  -1.05742700E-02
   +6.04367690E-01  +1.15954300E-02  +4.63826400E-02  +3.10293600E-02  +2.02091600E-02
   -2.82977000E-02  -3.48511200E-02  -5.80936400E-02  -3.42458200E-02  +7.33338000E-03
   +3.74932000E-03  -2.23688360E-01  -1.43270880E-01  +1.43887720E-01  +5.17319040E-01
   +4.51228400E-02  +5.89256000E-02  +2.38697100E-02  +2.02153000E-02  -3.53289900E-02
   -5.24856800E-02  -6.73916900E-02  -2.01833700E-02  +2.94164800E-02  +4.01706400E-02
   -1.04739040E-01  -1.91041800E-01  -1.71890530E-01  +2.21211310E-01  +4.79868530E-01
   -2.76572050E-01  -1.05364490E-01  +5.05178500E-02  +1.79750300E-02  -5.49189600E-02
   -5.83896700E-02  -5.93335800E-02  -1.30078300E-02  +2.67711400E-02  +3.96288400E-02
   +5.52399500E-02  +2.83486500E-02  -2.00322180E-01  -6.91871000E-03  +8.24210500E-02
   +5.92846130E-01  -1.54672290E-01  -1.86173040E-01  -7.87854000E-03  -1.99492100E-02
   -2.85987300E-02  -1.94635000E-02  -1.33905000E-02  -5.59095000E-03  +6.93306000E-03
   +2.29354600E-02  +8.01639000E-03  -1.61421600E-02  +4.77435000E-02  -1.23826000E-01
   -7.96619300E-02  +1.73786790E-01  +5.46938050E-01  +8.01659000E-03  -4.13701000E-02
   -1.00988000E-01  -2.52183300E-02  +5.83107000E-03  +3.08829700E-02  +2.70202700E-02
   +6.36334000E-03  -1.56901200E-02  -1.39114000E-03  -3.86632700E-02  -2.54954700E-02
   +1.29969040E-01  -4.16550000E-02  -1.96774130E-01  -1.57105870E-01  +2.50971570E-01
   +4.57009320E-01  -4.75153000E-03  -9.72878000E-03  -4.56665000E-03  -1.42163090E-01
   -4.09642900E-02  +1.34278500E-02  -1.79862600E-02  -1.20760800E-02  +3.25484000E-03
   +9.07400000E-04  -9.01950000E-04  +3.93342000E-03  -2.34528000E-03  +5.19170000E-04
   +1.49792000E-03  +4.68377000E-03  +4.07280000E-04  +1.12382000E-03  +4.75576420E-01
   -2.32584700E-02  -1.55764900E-02  +1.25644000E-03  -4.77292500E-02  -1.09936230E-01
   -2.90891000E-03  +1.06097000E-03  +7.25126000E-03  +3.12169000E-03  +4.98370000E-04
   +2.64861000E-03  -4.03563000E-03  -3.28990000E-04  -1.12174000E-03  -3.87970000E-04
   -3.05000000E-06  -2.84820000E-04  -4.79798000E-03  +4.04734000E-03  +4.71344590E-01
   -1.72605600E-02  -8.66161000E-03  +5.87265000E-03  +1.12445500E-02  -4.31887000E-03
   -8.14783900E-02  +1.50197500E-02  +1.22912900E-02  +2.43651000E-03  +4.16639000E-03
   -3.40807000E-03  +1.17063000E-03  +4.12090000E-04  -8.33410000E-04  -1.57533000E-03
   +8.96480000E-04  -5.54020000E-03  -5.16610000E-04  -3.65250000E-04  -3.16984000E-03
   +4.81621510E-01  -5.50800000E-04  -1.11429000E-03  +8.30840000E-04  -4.56071000E-03
   -1.35697700E-02  +2.63975100E-02  -7.40490000E-04  -2.15163000E-03  -7.18610000E-04
   -1.66191000E-03  -4.85700000E-05  -1.11078000E-03  +3.37410000E-04  +1.01279000E-03
   +7.01030000E-04  +1.77360000E-04  +6.61890000E-04  +1.17710000E-04  -7.53865000E-02
   -6.14280000E-04  +1.23398000E-03  +5.86556020E-01  -1.07291000E-03  -7.48810000E-04
   +1.02990000E-03  -6.86197000E-03  -1.27257700E-02  +1.98387900E-02  +1.22388000E-03
   -1.33463000E-03  -6.55130000E-04  -9.90620000E-04  -4.15690000E-04  -9.22520000E-04
   +2.08400000E-05  +8.05460000E-04  +7.87670000E-04  +4.82180000E-04  +7.12800000E-04
   -2.49300000E-05  +1.90690000E-03  -9.20197000E-02  +3.89099700E-02  +8.88120000E-04
   +5.62379190E-01  -1.76446000E-03  -7.91630000E-04  -9.35400000E-05  +8.85678000E-03
   +8.87761000E-03  -6.17507000E-03  -1.10502000E-03  +3.61000000E-06  -2.43900000E-05
   -5.00800000E-05  -2.95330000E-04  -3.33700000E-05  +1.34440000E-04  +2.71580000E-04
   +4.24990000E-04  +3.93900000E-04  -2.68220000E-04  -2.94350000E-04  -3.41116000E-03
   +3.58903700E-02  -1.55854310E-01  -5.02285000E-03  +5.44360900E-02  +4.91091120E-01
   +4.20841000E-03  +4.94919000E-03  +4.56526000E-03  -1.57622000E-03  -4.40790000E-03
   -3.98338000E-03  +3.93520000E-04  -1.52835000E-03  +3.59148000E-03  -1.23818400E-02
   -1.70588700E-02  -1.07790000E-04  -2.24311090E-01  -1.32682120E-01  +3.58859000E-03
   -4.49306400E-02  -2.82681700E-02  +1.06941500E-02  +1.45669000E-03  +1.07412000E-03
   +1.76410000E-04  -1.10423000E-03  -5.74470000E-04  -4.35360000E-04  +5.00638100E-01
   -1.97910000E-04  -1.40534000E-03  -5.52425000E-03  -2.65070000E-03  -3.21410000E-04
   +2.60868000E-03  +4.03031000E-03  +2.52567000E-03  -7.72026000E-03  -4.38306400E-02
   -2.63591700E-02  -2.59025000E-03  -9.80458100E-02  -1.61217250E-01  -3.88357800E-02
   -1.31892000E-03  +1.03128000E-02  +3.89785000E-03  +1.01362000E-03  +5.08560000E-04
   +7.69300000E-04  -8.79730000E-04  -5.03140000E-04  -3.13240000E-04  +7.04445400E-02
   +2.60490820E-01  +2.08220000E-04  -9.09684000E-03  -3.24215000E-03  -2.16101000E-03
   +3.88258000E-03  +3.82583000E-03  +8.77246000E-03  -3.81493000E-03  -1.58295000E-03
   -2.43731600E-02  -2.10616600E-02  +7.57454000E-03  +3.51223900E-02  -1.48138600E-02
   -8.15230700E-02  +3.44095400E-02  +2.21818900E-02  +3.46534000E-03  -5.60810000E-04
   +3.23170000E-04  -8.88300000E-05  +5.21000000E-05  -1.24900000E-05  -4.76400000E-05
   -2.60900400E-01  +1.62365890E-01  +3.53334380E-01  +9.45420000E-04  +5.00800000E-04
   -5.51300000E-05  -3.44450500E-02  +8.89232000E-03  +3.88450000E-04  -1.38209000E-03
   -1.13118000E-03  -1.28532000E-03  +2.66600000E-04  -4.06090000E-04  +9.95650000E-04
   -1.39700000E-04  -2.56980000E-04  -1.38100000E-04  -1.47410000E-04  +3.35950000E-04
   +8.61040000E-04  -1.39153900E-01  +4.63956500E-02  -1.29449200E-02  -1.23867000E-03
   +5.05924000E-03  -5.85620000E-03  +1.98540000E-04  +2.33850000E-04  -4.50300000E-05
   +6.64976590E-01  -2.72308000E-03  -6.35720000E-04  -1.69890000E-04  -1.10609000E-02
   +1.40270900E-02  -1.79736000E-03  -1.25632000E-03  -1.86145000E-03  -1.00552000E-03
   -6.90230000E-04  -1.51963000E-03  +6.26430000E-04  +3.43270000E-04  +1.30914000E-03
   +6.91440000E-04  +4.82550000E-04  +1.32300000E-05  +1.00040000E-04  +4.07010700E-02
   -1.04854630E-01  +1.61059800E-02  +1.33352700E-02  -1.11721200E-02  +4.91158000E-03
   -1.23610000E-03  -9.20280000E-04  -1.11300000E-05  -8.69220100E-02  +3.33502650E-01
   -8.86730000E-04  +8.24900000E-05  +8.60200000E-04  +3.75658000E-03  -3.43050000E-03
   +1.04000000E-05  +1.05932000E-03  +9.98990000E-04  -5.53890000E-04  +4.07600000E-05
   +1.71830000E-04  -4.92410000E-04  +6.87000000E-05  +1.89400000E-05  -5.90900000E-05
   -3.42700000E-05  +1.17040000E-04  -1.19520000E-04  -7.90829000E-03  +1.33281500E-02
   -8.53057800E-02  -2.69311100E-02  +1.98113600E-02  -6.08944000E-03  -6.19000000E-06
   -2.61100000E-05  +4.46900000E-05  -2.24255400E-01  -1.13240970E-01  +5.58356110E-01
   -1.54100000E-04  +3.26030000E-04  +2.93350000E-04  -1.02636000E-03  +2.72343000E-03
   -4.86220000E-04  -3.37480000E-04  -5.47690000E-04  -3.18770000E-04  -1.54400000E-04
   -4.08380000E-04  +1.07150000E-04  +3.82570000E-04  +4.60360000E-04  +1.02700000E-04
   -3.49900000E-05  -1.46890000E-04  +4.56700000E-05  -2.29579300E-02  +5.34092000E-03
   +1.72649700E-02  -2.09412000E-03  +8.50700000E-05  +1.30237000E-03  -5.93230000E-04
   -4.24210000E-04  +8.92000000E-06  -3.71746520E-01  +1.55324300E-02  +2.18589950E-01
   +6.63490010E-01  -2.14400000E-05  -7.73600000E-05  -3.28690000E-04  +8.86020000E-04
   -2.61888000E-03  -1.34200000E-05  +6.34740000E-04  +5.33550000E-04  +7.20100000E-05
   -5.89600000E-05  +1.44220000E-04  -1.49140000E-04  -1.17140000E-04  -1.00680000E-04
   +4.04600000E-05  +5.68800000E-05  +3.56620000E-04  -7.02400000E-05  +1.49896300E-02
   +4.24148000E-03  -9.74300000E-03  +1.07457000E-03  -1.47229000E-03  -5.06240000E-04
   +1.81810000E-04  +1.35700000E-04  +3.65600000E-05  +1.72571800E-02  -7.81654900E-02
   +2.36484100E-02  -1.09795150E-01  +3.06871610E-01  -1.77190000E-04  -3.39950000E-04
   -5.11760000E-04  -1.86666000E-03  +7.96800000E-04  +3.16580000E-04  -1.91020000E-04
   -2.66820000E-04  +1.81420000E-04  -1.27940000E-04  -1.64130000E-04  +1.68590000E-04
   +4.56100000E-05  +6.82500000E-05  +6.00800000E-05  -3.97100000E-05  +2.59810000E-04
   +9.96000000E-05  +1.46989000E-03  -2.11695000E-03  +8.67624000E-03  -8.66890000E-04
   -2.12480000E-04  +1.33630000E-04  -1.77520000E-04  -1.14210000E-04  +4.61700000E-05
   +2.18474830E-01  +2.54119900E-02  -2.71289480E-01  -2.12257120E-01  -1.92209740E-01
   +6.52739820E-01  +1.14660000E-04  +8.02300000E-05  +1.41720000E-04  +1.24880000E-04
   -4.52400000E-04  +1.44850000E-04  -9.75800000E-05  +4.62600000E-05  +1.86850000E-04
   +1.95520000E-04  +2.88970000E-04  +6.64100000E-05  -4.47060000E-04  -4.11830000E-04
   -9.16800000E-05  +7.82100000E-05  -1.68840000E-04  -1.09690000E-04  +9.61450000E-04
   +1.42250000E-04  +1.29317000E-03  +8.43410000E-04  -4.34800000E-04  +1.53770000E-04
   +6.18940000E-04  +4.09980000E-04  -4.73700000E-05  -2.40416900E-02  +1.19400500E-02
   +4.46243000E-03  -1.65874050E-01  +7.02221400E-02  -2.72865400E-02  +4.96083390E-01
   +1.22960000E-04  -2.03170000E-04  -1.32540000E-04  +1.89770000E-03  -1.23056000E-03
   -2.64000000E-05  +1.41700000E-05  +9.44800000E-05  +4.37660000E-04  +1.02480000E-04
   +2.10300000E-04  -4.90700000E-05  -1.66310000E-04  -2.42180000E-04  -1.06770000E-04
   -7.29400000E-05  -9.45300000E-05  +1.45400000E-05  +3.87176000E-03  +8.55080000E-03
   +6.35324000E-03  +2.73300000E-04  -3.38720000E-04  -5.56100000E-05  +2.60480000E-04
   +1.49340000E-04  +9.35000000E-06  +5.98501000E-03  +4.66341000E-03  -8.08140000E-03
   +4.93127300E-02  -1.15954320E-01  +2.53265300E-02  -3.27870100E-02  +5.57929300E-01
   +1.57770000E-04  -4.37600000E-05  -2.29100000E-05  +1.24419000E-03  -1.27306000E-03
   +7.03700000E-05  +1.47480000E-04  +1.56250000E-04  +1.96620000E-04  +7.80000000E-05
   +2.11180000E-04  -1.22640000E-04  +6.10200000E-05  -1.07580000E-04  -1.02510000E-04
   -8.13200000E-05  +2.65500000E-05  -1.08000000E-05  +4.04123000E-03  +5.03255000E-03
   -6.98860000E-04  -6.71640000E-04  +6.79800000E-04  -1.92510000E-04  +6.06500000E-05
   +6.02000000E-05  -4.53000000E-06  +1.49983000E-02  -1.23895000E-02  +8.56043000E-03
   -1.99921600E-02  +2.51660300E-02  -9.67622900E-02  +7.57305000E-03  +3.78228700E-02
   +5.03469010E-01  +7.03900000E-05  -1.30090000E-04  -2.94200000E-05  -1.14000000E-06
   -3.52400000E-05  +7.62300000E-05  -8.70700000E-05  -4.50800000E-05  +1.88080000E-04
   +7.21700000E-05  +1.20820000E-04  +1.75960000E-04  -6.64560000E-04  -3.88040000E-04
   -8.74000000E-06  +1.16170000E-04  -1.62780000E-04  -3.20500000E-05  -6.20320000E-04
   +7.49200000E-05  +1.04519000E-03  +3.10450000E-04  -3.95200000E-05  -2.81500000E-05
   +6.69820000E-04  +4.04790000E-04  -6.75000000E-06  +1.79273000E-03  +1.30262000E-03
   -1.45700000E-05  -2.85242000E-03  +6.02118000E-03  -2.84929300E-02  -8.07272000E-02
   +5.26740000E-03  -2.32330300E-02  +8.25969250E-01  -4.21500000E-05  +1.90200000E-05
   -2.36000000E-05  -1.57970000E-04  +1.25010000E-04  -1.33300000E-05  +6.21400000E-05
   +4.10000000E-06  -6.36100000E-05  -4.35900000E-05  -5.46200000E-05  -1.29700000E-05
   +1.16320000E-04  +9.15000000E-05  +2.33800000E-05  +2.21800000E-05  +6.67100000E-05
   -1.73700000E-05  -1.41570000E-04  -4.06750000E-04  -3.54250000E-04  -8.07800000E-05
   +3.78700000E-05  -7.11000000E-06  -1.14980000E-04  -6.30800000E-05  -2.99000000E-06
   -8.15000000E-04  +1.92650000E-04  +1.66156000E-03  +8.95752000E-03  -2.29979000E-03
   +1.74118100E-02  +4.60651000E-03  -7.90401800E-02  +6.83705000E-03  -3.53083100E-02
   +2.00105720E-01  +4.23400000E-05  +1.30270000E-04  +7.03200000E-05  +5.77000000E-05
   -5.38840000E-04  +2.21700000E-05  +2.09000000E-05  +1.10250000E-04  +3.52600000E-05
   +1.14350000E-04  +1.71970000E-04  -3.92600000E-05  -7.37200000E-05  -1.63130000E-04
   -5.86300000E-05  -1.91000000E-06  -1.39400000E-05  -4.86700000E-05  +1.38900000E-05
   +8.69700000E-05  -8.55580000E-04  -1.46100000E-05  -1.67200000E-05  -1.64130000E-04
   +1.90780000E-04  +1.43440000E-04  -2.61500000E-05  +2.65571000E-03  +9.59090000E-04
   -2.50456000E-03  -1.67552000E-02  +3.92026000E-03  -6.30421000E-03  -2.78454000E-03
   +1.58734900E-02  -1.88051910E-01  -1.65289090E-01  -7.11895100E-02  +6.61334110E-01
   +1.62200000E-05  +1.06400000E-04  +4.07800000E-05  -2.69220000E-04  -1.58990000E-04
   +5.98000000E-05  +5.95600000E-05  +6.34400000E-05  -1.14020000E-04  +2.90100000E-05
   +2.91300000E-05  -6.40900000E-05  +2.68230000E-04  +8.74500000E-05  -4.45100000E-05
   -4.43500000E-05  +1.03640000E-04  +4.51000000E-06  -1.84300000E-04  -1.44673000E-03
   +5.84400000E-04  +2.29300000E-04  -1.67780000E-04  -7.14600000E-05  -1.96720000E-04
   -9.50700000E-05  -5.78000000E-06  -8.79600000E-05  +3.56918000E-03  -1.10986100E-02
   -3.89360000E-03  +1.29536000E-03  +6.37390000E-04  +7.93333000E-03  +1.83048000E-03
   +7.81464000E-03  -3.50841440E-01  -5.50249000E-03  +2.05824010E-01  +7.12017200E-01
   +2.20600000E-05  -1.47180000E-04  -3.48000000E-05  -6.43280000E-04  -2.34270000E-04
   +1.10720000E-04  +7.90000000E-05  +6.92900000E-05  -2.63700000E-05  -2.13800000E-05
   +3.08800000E-05  +5.75900000E-05  -5.21800000E-05  -9.08500000E-05  +3.70000000E-06
   +9.49900000E-05  +2.17670000E-04  -1.19770000E-04  -5.61220000E-04  -6.38990000E-04
   +2.18931000E-03  +6.56820000E-04  -4.05240000E-04  -3.72400000E-05  +1.60660000E-04
   +1.58750000E-04  -1.75100000E-05  +1.55135300E-02  -1.66073000E-03  +7.86018000E-03
   +6.36220000E-04  +8.91420000E-04  +4.22550000E-04  -2.27926000E-03  +7.05588000E-03
   +2.57327000E-03  -1.24939900E-02  -6.23130600E-02  +2.37942200E-02  -2.16736800E-02
   +1.55405620E-01  -1.23320000E-04  -3.42970000E-04  -1.79430000E-04  +6.44710000E-04
   +2.62880000E-04  +1.65140000E-04  +3.10200000E-05  -9.84500000E-05  +1.46350000E-04
   -1.61870000E-04  -1.49650000E-04  +1.11920000E-04  -3.34440000E-04  -1.74400000E-05
   +1.61900000E-04  +2.55160000E-04  +3.90100000E-05  -6.62100000E-05  +1.27468000E-03
   +1.38091000E-03  -2.80842000E-03  -9.13210000E-04  +6.77780000E-04  +1.88180000E-04
   +2.34490000E-04  +1.43260000E-04  -8.04000000E-06  -2.80140300E-02  +6.38468000E-03
   -1.16236600E-02  +2.80102000E-03  -1.64513000E-03  +7.05070000E-04  +2.08886500E-02
   -6.53440000E-04  -1.68078100E-02  +2.11972840E-01  +2.12802600E-02  -2.99841830E-01
   -1.33611930E-01  -9.54320100E-02  +7.40581920E-01  -1.26710000E-04  -3.67540000E-04
   -2.99300000E-05  +1.42313000E-03  +1.22471000E-03  -1.51878000E-03  -9.13940000E-04
   -3.19710000E-04  +3.60380000E-04  +2.48110000E-04  +3.42760000E-04  +3.98110000E-04
   -4.21400000E-04  -5.56860000E-04  -4.68990000E-04  -3.81230000E-04  -3.99970000E-04
   +1.20510000E-04  +2.95710000E-03  +1.43076300E-02  -2.19292400E-02  -4.66381000E-03
   +3.28811000E-03  +8.61670000E-04  +5.26270000E-04  +3.13790000E-04  +5.15100000E-05
   -9.11187300E-02  +1.39735600E-02  +1.34807000E-03  +6.86683000E-03  -1.69695300E-02
   +2.33237600E-02  -9.22730000E-04  -3.47533000E-03  -1.16260000E-04  -4.06883000E-02
   +6.86488000E-03  +2.64290000E-04  -1.92675040E-01  +2.65517300E-02  -4.28017000E-02
   +5.27993240E-01  -4.87400000E-05  +4.72840000E-04  +2.18450000E-04  +1.05234000E-03
   +7.51860000E-04  -1.50000000E-06  -6.90710000E-04  -1.33600000E-04  +1.79720000E-04
   +2.80960000E-04  +3.37700000E-05  -8.59300000E-05  -1.15800000E-04  -8.39000000E-06
   -1.62770000E-04  -4.94950000E-04  -8.38680000E-04  +3.42130000E-04  +3.62231000E-03
   -7.00011000E-03  +1.26701500E-02  +1.39778000E-03  -3.92200000E-05  -8.49250000E-04
   -2.03800000E-04  -3.00500000E-04  +3.45000000E-05  +1.22618800E-02  -1.02701710E-01
   +5.37688900E-02  -4.28038000E-03  +7.12935000E-03  +2.60365000E-03  -1.05741000E-03
   -8.52534000E-03  -5.23561000E-03  +4.53268000E-03  -5.45460000E-03  -2.25819000E-03
   +2.23480300E-02  -6.57871200E-02  +1.27752000E-02  -6.83207300E-02  +4.45016060E-01
   +2.00000000E-07  +6.15010000E-04  +2.58210000E-04  +2.02740000E-04  -1.35690000E-04
   -2.85690000E-04  -6.18300000E-04  -8.25000000E-06  +2.61690000E-04  +5.64070000E-04
   +7.15740000E-04  -1.17310000E-04  +1.35550000E-04  -3.80960000E-04  -4.73890000E-04
   -4.35830000E-04  -4.10390000E-04  -1.42400000E-05  -4.77253000E-03  +5.43193000E-03
   -1.69906000E-03  +9.25360000E-04  -2.92200000E-04  +7.62710000E-04  +1.84130000E-04
   +1.03010000E-04  -2.58900000E-05  -1.32341000E-03  +4.65084400E-02  -1.61285820E-01
   +8.16206000E-03  +1.18447600E-02  -2.25652100E-02  -8.20900000E-04  -2.95307000E-03
   -3.01622000E-03  +9.03879000E-03  -2.90671000E-03  +2.05122900E-02  -3.17012200E-02
   +1.35533100E-02  -1.16707400E-01  -5.69052000E-02  -2.17130000E-04  +5.57023730E-01
   +2.25700000E-05  +1.49080000E-04  +8.94100000E-05  +8.47100000E-05  +2.02650000E-04
   -1.27970000E-04  +9.80900000E-05  -1.56000000E-05  -2.54540000E-04  -8.40500000E-05
   -1.51890000E-04  -1.94660000E-04  +8.46600000E-04  +4.86980000E-04  -4.16900000E-05
   -2.32610000E-04  +1.52700000E-04  +1.16270000E-04  +7.85160000E-04  -8.51200000E-05
   -8.99900000E-04  -5.89930000E-04  +2.32740000E-04  +3.18100000E-05  -8.81540000E-04
   -5.53090000E-04  +3.69600000E-05  -6.32190000E-04  -1.77040000E-03  +1.32032000E-03
   +2.35675000E-03  +1.59809000E-03  -4.36707000E-03  -2.58063300E-02  +5.42743000E-03
   -1.07502500E-02  -3.00115930E-01  +4.93249000E-02  -8.69422200E-02  -6.31457500E-02
   +1.35887800E-02  -5.04124000E-03  +1.03274700E-02  -1.09415000E-03  +1.00263300E-02
   +5.75003960E-01  +1.02200000E-05  +4.24000000E-06  -1.86400000E-05  -1.69400000E-05
   -2.53600000E-05  +3.10600000E-05  -2.32600000E-05  +2.36000000E-06  +3.77700000E-05
   +2.78500000E-05  +5.16400000E-05  +3.49700000E-05  -1.76810000E-04  -1.15800000E-04
   +2.47000000E-06  +3.31300000E-05  -4.76000000E-05  -1.98300000E-05  -1.80500000E-04
   -3.00000000E-08  +5.58600000E-05  +1.26750000E-04  -3.87200000E-05  +5.92000000E-06
   +1.84700000E-04  +1.24570000E-04  -9.95000000E-06  -6.81100000E-05  -1.14650000E-04
   +4.34330000E-04  +1.79795000E-03  +2.43220000E-04  +3.85980000E-04  +3.61372000E-03
   +2.96535000E-03  +6.43131000E-03  +3.07449200E-02  -5.70827300E-02  +2.96412600E-02
   +4.12615000E-03  +9.91897000E-03  -3.94578000E-03  -4.67576000E-03  +9.24024000E-03
   +6.89510000E-04  +2.01668000E-02  +8.63583000E-02  -1.85400000E-05  -6.73500000E-05
   -4.87400000E-05  -1.03800000E-05  +3.14350000E-04  -2.05200000E-05  +2.48800000E-05
   -6.18400000E-05  -6.74200000E-05  -9.29700000E-05  -1.40540000E-04  -8.83000000E-06
   +2.03430000E-04  +1.89570000E-04  +2.63000000E-05  -3.63000000E-05  +4.14400000E-05
   +5.96000000E-05  +1.65320000E-04  -3.92200000E-05  +4.47090000E-04  -1.19270000E-04
   +7.07500000E-05  +4.30500000E-05  -2.81350000E-04  -1.93290000E-04  +3.13000000E-05
   +2.58800000E-05  -7.23000000E-06  -1.06660000E-04  +2.78903000E-03  +7.73200000E-05
   -7.01017000E-03  -3.81029300E-02  +1.23156300E-02  -1.29612900E-02  -3.62865300E-02
   +2.77794200E-02  -1.32847860E-01  +2.64143600E-02  -5.43771000E-03  +2.30412100E-02
   +1.95289000E-03  +8.36380000E-04  -4.90866000E-03  -1.28502040E-01  -1.49433190E-01
   +4.47254950E-01  -2.53000000E-05  -8.49400000E-05  -1.06970000E-04  +3.32330000E-04
   +5.14360000E-04  -1.03650000E-04  +7.27000000E-06  -1.09690000E-04  -1.09910000E-04
   -1.46960000E-04  -2.32440000E-04  -7.24300000E-05  +5.36160000E-04  +3.91350000E-04
   +1.78800000E-05  -1.62290000E-04  +7.64500000E-05  +1.29190000E-04  +1.40726000E-03
   +1.63165000E-03  +3.37754000E-03  -2.40670000E-04  -1.69620000E-04  +2.17520000E-04
   -6.70950000E-04  -4.40950000E-04  +4.82200000E-05  -3.35583000E-03  +3.46738000E-03
   -5.74039000E-03  -4.57802400E-02  -2.44584600E-02  +2.10301800E-02  -1.58090550E-01
   -2.99820700E-02  +4.77891700E-02  -2.02974200E-02  -7.94997000E-03  +1.01582000E-02
   +4.13842000E-03  -1.54869000E-03  +1.85074000E-03  -5.08690000E-04  +1.68650000E-04
   -2.73899000E-03  +8.34706000E-03  +5.03488000E-03  -5.27315000E-03  +2.60981590E-01
   +5.86600000E-05  +2.59300000E-05  -4.31700000E-05  -1.40110000E-04  -1.48000000E-06
   +2.34000000E-06  +1.48200000E-05  +2.80400000E-05  -2.50200000E-05  +2.15000000E-06
   +1.90700000E-05  -1.59400000E-05  +9.61600000E-05  +2.09900000E-05  -1.75500000E-05
   -3.02000000E-05  +4.42000000E-05  +3.67000000E-06  -5.76300000E-05  -2.53720000E-04
   -4.28500000E-04  -2.21380000E-04  -2.00000000E-06  +2.22700000E-05  -7.35300000E-05
   -1.83400000E-05  -4.62000000E-06  -3.70750000E-04  +2.25300000E-04  +5.54160000E-04
   +9.95369000E-03  +8.29419000E-03  -2.88932000E-03  -6.79356200E-02  -1.22522850E-01
   +2.65122700E-02  -1.09154800E-02  -7.05779000E-03  +1.11807400E-02  +6.89950000E-04
   +3.06260000E-04  +4.01659000E-03  +1.86992000E-03  -9.90610000E-04  +6.69240000E-04
   -3.93899000E-03  +1.23257000E-03  +3.98320000E-03  +3.94026700E-02  +6.29724590E-01
   +1.03300000E-05  -7.63700000E-05  -3.96400000E-05  -3.20000000E-06  +8.15400000E-05
   +8.09900000E-05  +7.10000000E-07  -2.89700000E-05  +1.77100000E-05  -3.18300000E-05
   -3.73300000E-05  +4.23600000E-05  -7.70600000E-05  -6.90000000E-06  +1.25700000E-05
   +3.05200000E-05  -1.95700000E-05  +1.94900000E-05  -1.20420000E-04  -9.83500000E-05
   +1.90730000E-04  +1.86090000E-04  -5.96000000E-06  -4.91300000E-05  +4.87300000E-05
   +1.28300000E-05  +2.03700000E-05  -3.51570000E-04  +5.52120000E-04  +1.25620000E-03
   -3.82070000E-04  -1.01770000E-03  +3.19517000E-03  +4.07541600E-02  +9.85817000E-03
   -8.45352000E-02  +3.01354600E-02  +2.67445700E-02  -2.01578000E-02  -2.42551000E-03
   +8.58300000E-04  -5.86934000E-03  -2.69576000E-03  +1.89304000E-03  -9.99670000E-04
   +7.98149000E-03  +4.02559000E-03  -3.70296000E-03  -1.06681750E-01  +9.15678800E-02
   +1.53335310E-01  -4.90240000E-03  -2.15187000E-03  +1.80351000E-03  -1.35980000E-03
   -2.24108200E-02  -2.00383500E-02  -1.92950000E-03  -1.38518000E-03  -1.44150000E-04
   +2.00170000E-04  -5.74550000E-04  -7.39830000E-04  +3.87990000E-04  +1.52810000E-04
   +4.83400000E-05  +1.52540000E-04  -1.13968000E-03  -9.36060000E-04  -7.37890300E-02
   +1.98483000E-03  +1.49477000E-03  +4.43190000E-04  -2.97190000E-04  -3.96970000E-04
   -5.48700000E-04  -3.63700000E-04  +3.02000000E-05  -3.67628000E-03  +2.23796900E-02
   +1.93319400E-02  -2.84836000E-03  +1.75301000E-03  -1.29075000E-03  +3.76520000E-04
   -2.30041000E-03  -5.62110000E-04  -1.09550000E-04  +7.04800000E-05  +5.60850000E-04
   +1.99540000E-04  -9.77100000E-05  -3.48410000E-04  +2.45940000E-04  +3.94000000E-05
   -1.88030000E-04  -1.34160000E-04  +2.47500000E-05  -3.57390000E-04  -1.67626000E-03
   +3.71600000E-05  -4.60900000E-05  +5.85676250E-01  -2.69390000E-03  -5.33030000E-04
   +7.10910000E-04  -5.57492000E-03  -1.78385900E-02  -1.35256400E-02  -6.02900000E-05
   -5.29840000E-04  +6.51370000E-04  +5.07050000E-04  -4.44120000E-04  -6.00500000E-04
   -2.21290000E-04  +7.04800000E-05  -1.29800000E-05  +3.30510000E-04  -4.23160000E-04
   -7.07530000E-04  -4.73400000E-03  -1.26919090E-01  -4.91391400E-02  -3.25770000E-04
   +8.42462000E-03  +4.58264000E-03  +1.10180000E-04  +3.03500000E-05  -2.19600000E-05
   +1.02188200E-02  -2.29251500E-02  -1.51776000E-02  -1.34880000E-03  -1.12793000E-03
   +1.38479000E-03  +1.53170000E-04  +1.29811000E-03  +4.69520000E-04  +4.06900000E-05
   -4.00100000E-05  -1.48160000E-04  -3.92600000E-05  +1.46810000E-04  -9.97900000E-05
   -3.30770000E-04  -1.13600000E-04  +8.20300000E-04  -6.95600000E-05  +5.45000000E-06
   +9.72800000E-05  +5.17770000E-04  -6.44000000E-05  +3.70400000E-05  -3.42373000E-03
   +5.07827410E-01  +1.82507000E-03  +5.30820000E-04  +1.34600000E-05  -3.31078000E-03
   +7.27140000E-04  +2.42133000E-03  +7.71890000E-04  +1.20299000E-03  -1.51830000E-04
   +1.91600000E-04  +1.61480000E-04  -1.04840000E-04  -1.68070000E-04  -1.99420000E-04
   +1.72440000E-04  +2.92800000E-04  +2.54190000E-04  +2.22430000E-04  -3.77846000E-03
   -4.26884200E-02  -1.17660460E-01  -1.93460000E-04  -2.35155700E-02  -3.58164400E-02
   +3.42850000E-04  +2.28680000E-04  -6.05600000E-05  +7.48335000E-03  -3.74936000E-03
   +2.76251000E-03  -2.30564000E-03  +3.08290000E-04  +8.70000000E-06  +4.43050000E-04
   -5.92560000E-04  +3.35590000E-04  -3.29790000E-04  +8.08700000E-05  +4.31660000E-04
   +1.46520000E-04  +1.00290000E-04  -6.51290000E-04  -9.84250000E-04  +7.09690000E-04
   +1.12618000E-03  +2.99950000E-04  -3.19500000E-05  -2.20980000E-04  -6.76530000E-04
   +1.56030000E-04  -1.12150000E-04  -6.50026000E-03  -6.37511000E-02  +5.39199160E-01
   -2.21064000E-03  +1.63247000E-03  -1.30928000E-03  -3.42646000E-03  +1.51083000E-03
   -1.64530000E-03  +9.19600000E-04  +1.53930000E-04  -7.69780000E-04  -6.76500000E-05
   -2.62810000E-04  -2.04230000E-04  +8.20710000E-04  +3.90580000E-04  +3.11710000E-04
   +4.93250000E-04  +8.95630000E-04  -3.98830000E-04  -1.25051000E-03  -7.46080000E-04
   +1.31020000E-04  +3.79960000E-04  -6.83200000E-05  -6.22800000E-05  -5.18410000E-04
   -2.44880000E-04  -4.83700000E-05  +2.52195000E-03  -4.72757000E-03  +3.85310000E-03
   +2.15740000E-04  +1.05478000E-03  -8.42710000E-04  -4.72510000E-04  +3.63330000E-04
   -2.21656000E-03  +1.00019400E-02  -5.78164000E-03  -6.30093000E-03  -2.96402000E-02
   -3.93283900E-02  -9.19965000E-03  -7.52978000E-02  -2.71264500E-02  -2.84337800E-02
   -7.94597000E-03  +4.82110000E-03  +4.06840000E-04  +1.48360000E-04  -1.23739000E-03
   +1.87628000E-03  +3.92490000E-04  -1.14550000E-04  +2.04390000E-04  +1.25771860E-01
   +1.54018000E-03  -5.72290000E-04  +9.00550000E-04  +2.05432000E-03  -2.23495000E-03
   +7.47560000E-04  -7.11440000E-04  -1.53810000E-04  +5.14530000E-04  +4.30210000E-04
   +8.08260000E-04  +2.50790000E-04  +1.83680000E-04  -7.01350000E-04  -8.06820000E-04
   -4.53550000E-04  +2.63110000E-04  +8.83100000E-05  -1.39070000E-03  +6.74000000E-05
   +5.56000000E-04  +7.95480000E-04  +1.28560000E-04  +1.36290000E-04  +4.54990000E-04
   +5.71920000E-04  -1.52600000E-05  -1.41426800E-02  -3.54026800E-02  +3.30863000E-03
   +3.00040000E-03  -1.82707000E-03  +3.31370000E-04  -4.80600000E-05  -1.62761000E-03
   -6.85680000E-04  +3.94094000E-03  -5.68000000E-06  -3.37811000E-03  -1.87029000E-02
   -5.97835000E-03  -2.01530000E-03  -4.50021700E-02  -1.72340300E-01  -4.99527300E-02
   -4.27452000E-03  +1.55454000E-03  +2.19120000E-04  -9.28670000E-04  +9.98000000E-05
   +4.64360000E-04  +2.79040000E-04  -8.22500000E-05  -7.01590000E-04  +1.71129800E-02
   +4.76997650E-01  -1.74409000E-03  +6.20260000E-04  -1.62443000E-03  -2.00822000E-03
   +1.51255000E-03  -4.62560000E-04  +7.96880000E-04  +1.03060000E-04  -3.94600000E-04
   -6.10160000E-04  -5.74770000E-04  +1.77220000E-04  +1.24930000E-04  +3.70320000E-04
   +3.03440000E-04  +2.79620000E-04  +5.31530000E-04  -2.82350000E-04  +5.23200000E-05
   -5.88520000E-04  -7.28810000E-04  -3.12590000E-04  +1.11500000E-05  -1.23240000E-04
   -2.52950000E-04  -1.87480000E-04  +5.48900000E-05  +1.19278100E-02  +2.87108000E-02
   +7.99645000E-03  -1.43828000E-03  +2.17985000E-03  -4.32290000E-04  -6.05240000E-04
   +1.46240000E-03  +4.50600000E-05  +5.61699000E-03  -2.26458000E-03  -3.85672000E-03
   -1.55357500E-02  -1.51009200E-02  +3.49439000E-03  -1.18684700E-02  -4.73657000E-03
   -9.36637100E-02  -4.21244000E-03  +2.11363000E-03  +7.44770000E-04  +1.01570000E-03
   -4.88870000E-04  +1.00033000E-03  +3.50590000E-04  -3.39390000E-04  -6.88430000E-04
   +1.34390180E-01  -1.98118840E-01  +4.11455360E-01  +2.15500000E-05  +9.76220000E-04
   +1.85024000E-03  +5.84110000E-04  -2.60550000E-04  -5.57760000E-04  -1.03769000E-03
   +1.68460000E-04  +4.05530000E-04  +4.02790000E-03  +2.87025000E-03  -8.18180000E-04
   -3.08359100E-02  +1.15865700E-02  +2.99462500E-02  -3.02756000E-03  -5.44358000E-03
   -1.26558000E-03  -1.26610000E-04  -1.45920000E-04  -1.13650000E-04  +1.31630000E-04
   +6.31800000E-05  +4.36000000E-05  -2.22498180E-01  +7.04994300E-02  +2.13860850E-01
   -2.71200000E-05  +1.67080000E-04  +3.64000000E-06  +8.27000000E-05  -9.08000000E-06
   +1.87600000E-05  -1.05260000E-04  -5.93100000E-05  +7.21000000E-06  -1.55400000E-04
   +3.13600000E-05  -1.95300000E-05  +5.97600000E-05  -3.12000000E-06  -5.28800000E-05
   -1.42780000E-04  -4.76200000E-05  -7.94000000E-06  +1.81550000E-04  -3.54600000E-05
   +4.24900000E-05  +1.13780000E-04  +2.62200000E-05  -2.30700000E-05  +7.24800000E-05
   +2.92000000E-06  -2.42500000E-05  +1.80010000E-04  +1.34900000E-05  +1.42000000E-05
   +2.52581330E-01  -4.43040000E-04  +1.56701000E-03  +1.13170000E-04  +2.29880000E-04
   -3.12400000E-04  -5.06390000E-04  -1.06320000E-04  -6.57330000E-04  +1.37560000E-04
   -1.62019000E-03  +7.68180000E-04  +2.64272000E-03  -2.13221000E-02  +5.69733000E-03
   +2.20313700E-02  -4.28234000E-03  -2.11161000E-03  -9.25900000E-04  +3.08100000E-05
   -7.38300000E-05  -4.79600000E-05  +1.97100000E-05  +8.81000000E-06  +5.90000000E-07
   +1.05949100E-01  -8.29655000E-02  -1.44256480E-01  -4.37700000E-05  +3.65200000E-05
   -2.52700000E-05  +2.75300000E-05  -1.52700000E-05  +9.50000000E-06  -3.79100000E-05
   +3.69000000E-06  +4.90000000E-07  -4.10400000E-05  +4.35000000E-06  -1.47000000E-05
   +8.07000000E-06  -2.45500000E-05  -1.67500000E-05  -1.96000000E-05  +5.00000000E-05
   +7.75000000E-06  +5.67000000E-05  -1.60500000E-05  +2.27200000E-05  +4.57300000E-05
   -3.61000000E-06  +4.99000000E-06  +2.46500000E-05  +2.73500000E-05  +9.23000000E-06
   +1.65600000E-05  -9.26500000E-05  +3.62800000E-05  -7.91133400E-02  +7.91127200E-02
   +7.04880000E-04  -6.99770000E-04  +4.74110000E-04  -1.44690000E-04  -1.86320000E-04
   -9.79000000E-06  +1.34910000E-04  -5.09700000E-05  -8.69580000E-04  -4.86573000E-03
   -4.54500000E-04  +2.01686000E-03  +1.40450000E-04  -5.77590000E-04  -3.12060000E-03
   -2.90670000E-04  -1.70480000E-04  +2.29262000E-03  +1.12710000E-04  +6.51600000E-05
   +1.49100000E-05  -8.19400000E-05  -6.98300000E-05  -3.55900000E-05  +2.45944030E-01
   -1.19907570E-01  -2.81126230E-01  +1.94000000E-05  -7.51200000E-05  -1.21100000E-05
   -3.64300000E-05  +2.12200000E-05  -8.08000000E-06  +2.44000000E-05  +7.30000000E-07
   +1.61100000E-05  -2.43000000E-06  +2.95000000E-06  +1.77500000E-05  +1.01500000E-05
   +1.89900000E-05  +8.50000000E-07  -9.30000000E-06  -4.33900000E-05  +3.09800000E-05
   -1.58200000E-05  +4.93000000E-06  -1.99500000E-05  -2.74000000E-05  +8.36000000E-06
   -1.49500000E-05  -2.64800000E-05  +9.36000000E-06  +3.12200000E-05  +1.98100000E-05
   +6.68700000E-05  -4.11600000E-05  -2.41984200E-01  +1.21932720E-01  +2.80738250E-01
   -3.45160000E-04  -4.07570000E-04  -8.42690000E-04  -1.46953000E-03  -5.26239000E-03
   +9.27520000E-04  -1.40029800E-02  +8.11448000E-03  +1.82060200E-02  -1.89232740E-01
   +3.39801500E-02  +1.38961050E-01  +2.20436000E-03  -4.04584000E-03  -2.39326000E-03
   +2.39524000E-03  -1.90900000E-03  +5.65160000E-04  -8.55000000E-05  +6.04990000E-04
   +9.14100000E-04  -2.83690000E-04  -1.35670000E-04  -8.96800000E-05  +2.19484000E-03
   +1.96533000E-03  -2.58929000E-03  +6.00000000E-07  -2.54710000E-04  +9.41800000E-05
   -1.02970000E-04  +6.34600000E-05  -5.62800000E-05  +6.62600000E-05  +1.74400000E-05
   +2.90100000E-05  +3.05000000E-05  -4.88000000E-06  +3.94800000E-05  +6.40000000E-06
   +2.60200000E-05  -7.36000000E-06  -1.81800000E-05  -3.24000000E-05  +7.26100000E-05
   -6.13800000E-05  +1.35800000E-05  -4.11700000E-05  -7.85100000E-05  +3.32000000E-06
   -1.24500000E-05  -4.07800000E-05  +1.17940000E-04  +3.21700000E-05  -5.85000000E-06
   +8.99000000E-05  -7.38200000E-05  +2.10000000E-07  +6.69260000E-04  +9.97880000E-04
   +1.99004300E-01  -6.31000000E-04  -1.34657000E-03  +1.45760000E-04  -4.67878000E-03
   +6.60380000E-04  -2.18340000E-03  -1.28731800E-02  +7.18283000E-03  +1.37058100E-02
   +3.41250500E-02  -6.29885600E-02  -5.16215300E-02  +1.80667100E-02  +1.62000000E-05
   -1.61451200E-02  -2.31093000E-03  -1.70008000E-03  -5.07287000E-03  -5.69330000E-04
   +5.51740000E-04  +3.19990000E-04  -6.36000000E-05  +2.72300000E-05  -6.68000000E-05
   +2.50501000E-03  +3.49220000E-04  +2.36538000E-03  -1.13550000E-04  -2.59050000E-04
   +4.23600000E-05  -6.44200000E-05  +3.60700000E-05  -9.05000000E-06  +2.63700000E-05
   +4.43000000E-05  +2.54600000E-05  +2.58300000E-05  -7.09000000E-06  +1.07100000E-05
   -8.03000000E-06  +3.59000000E-06  +6.90000000E-07  +2.58900000E-05  -1.36700000E-05
   +1.51000000E-06  -2.89300000E-05  +3.27000000E-06  -8.59000000E-06  -2.24500000E-05
   -4.67000000E-06  +5.88000000E-06  +8.29500000E-05  +3.77900000E-05  +6.22400000E-05
   -1.71100000E-05  +4.58000000E-06  +2.66400000E-05  -1.36034000E-03  -6.75260000E-04
   -2.08890000E-04  -3.48384200E-02  +5.92790700E-02  -1.11134000E-03  -8.55800000E-05
   -3.12650000E-04  +1.18957000E-03  -1.70542000E-03  +4.31298000E-03  -4.70540000E-04
   -5.98460000E-04  +1.62167000E-03  +1.38994050E-01  -5.16430300E-02  -1.74353850E-01
   +1.77312300E-02  -8.80630000E-04  -8.89793000E-03  -8.94000000E-06  -5.46246000E-03
   +7.29490000E-04  +6.41200000E-05  -2.96710000E-04  +2.25910000E-04  -3.32000000E-06
   -8.13800000E-05  +2.46400000E-05  -2.11103000E-03  +2.72319000E-03  -2.35110000E-04
   +7.24900000E-05  +1.56240000E-04  -2.08300000E-05  +4.69400000E-05  -1.03700000E-05
   +1.52300000E-05  -4.41900000E-05  -3.89500000E-05  -1.06900000E-05  -5.82500000E-05
   +1.14600000E-05  -8.69000000E-06  +2.38400000E-05  -2.95000000E-06  -2.22800000E-05
   -4.81400000E-05  +4.24000000E-06  +1.63000000E-05  +6.65700000E-05  -1.16200000E-05
   +1.53600000E-05  +4.29500000E-05  +1.23400000E-05  -1.00000000E-05  +2.29000000E-06
   +3.78100000E-05  -6.30300000E-05  +3.84500000E-05  +2.21800000E-05  -1.54800000E-05
   -8.38180000E-04  -1.59784000E-03  -2.94360000E-04  -1.52863870E-01  +5.71910000E-02
   +1.79522700E-01  -1.82587000E-03  -6.50440000E-04  +5.36271000E-03  +7.77860000E-03
   +1.69917000E-02  +1.30118100E-02  -5.60713300E-02  -2.21474300E-02  -7.45489000E-03
   +1.18869000E-03  -2.05541400E-02  -1.71046100E-02  -2.19631000E-03  -4.26267000E-03
   +2.86214000E-03  -1.28346000E-03  +5.82900000E-05  +1.10290000E-04  -1.92300000E-05
   +1.40984000E-03  -1.56175000E-03  +3.99260000E-04  -2.97500000E-05  -1.07790000E-04
   -4.23040000E-04  -1.28744000E-03  -8.38290000E-04  -3.16220000E-04  -2.07490000E-04
   -1.80100000E-05  +2.33000000E-06  -1.52800000E-05  -5.76900000E-05  -2.33700000E-05
   +5.40400000E-05  +5.56100000E-05  -9.72600000E-05  -5.63000000E-06  +1.84200000E-05
   +4.00200000E-05  -7.00000000E-05  -1.07840000E-04  -2.76500000E-05  +2.44630000E-04
   +2.97140000E-04  +1.16010000E-04  -2.04200000E-05  +1.10600000E-05  +6.62700000E-05
   +2.79000000E-06  -2.25800000E-05  -1.13071000E-03  -5.44850000E-04  +9.35930000E-04
   -4.49900000E-05  -2.33530000E-04  -9.10700000E-05  +1.81800000E-04  +2.62200000E-05
   -1.32710000E-04  -1.57830000E-04  +1.55182000E-03  -1.34055000E-03  +5.58691500E-02
   -5.27940000E-04  +3.23441000E-03  -2.92756000E-03  -1.08179000E-03  -1.18152000E-03
   -4.13450000E-03  -2.18866500E-02  -2.17000810E-01  -1.47195740E-01  +8.65400000E-05
   -1.00166400E-02  -1.20683400E-02  -4.49873000E-03  +2.45971000E-03  -1.47308000E-03
   +1.05090000E-04  -9.24700000E-05  +9.54530000E-04  +7.09600000E-04  -2.22387000E-03
   +1.35986000E-03  -3.51430000E-04  -2.19110000E-04  +1.21650000E-04  -4.42040000E-04
   -9.43200000E-04  -6.01110000E-04  +2.82930000E-04  +4.72280000E-04  -3.39860000E-04
   +1.47240000E-04  -9.94500000E-05  +1.16200000E-04  -2.85500000E-05  -5.70000000E-06
   -7.46900000E-05  +6.84200000E-05  +2.60000000E-06  -6.34400000E-05  -6.13800000E-05
   +1.93800000E-05  +1.25230000E-04  +1.12900000E-04  -1.57430000E-04  -2.95440000E-04
   -6.83000000E-05  +5.20000000E-06  +3.38200000E-05  +3.27100000E-05  -1.99800000E-05
   +3.52700000E-05  -1.99427000E-03  -3.76300000E-04  +4.50120000E-04  -3.86800000E-05
   +8.57400000E-05  +1.20380000E-04  +1.93120000E-04  +6.77000000E-06  -8.53500000E-05
   +1.16981000E-03  -8.78790000E-04  +2.10763000E-03  +2.96861700E-02  +2.28427740E-01
   +5.60896000E-03  -2.72009000E-03  +6.33150000E-04  -3.47002000E-03  -1.65402400E-02
   -8.29912000E-03  -6.96977000E-03  -1.46754880E-01  -1.65748950E-01  +1.44798000E-03
   +1.92110000E-03  +4.07509000E-03  +2.52380000E-03  -1.53983000E-03  +4.38863000E-03
   +2.52100000E-04  +1.06107000E-03  -4.50620000E-04  -2.51104000E-03  +6.43000000E-04
   -1.82994000E-03  +6.22750000E-04  +2.37580000E-04  -1.67500000E-05  -8.22900000E-05
   -4.06600000E-05  +7.13000000E-05  -2.95580000E-04  -2.39370000E-04  +2.94760000E-04
   -8.78200000E-05  +1.28590000E-04  -4.45100000E-05  +1.23500000E-05  -3.50500000E-05
   +2.88800000E-05  -2.52900000E-05  +1.08300000E-05  +2.30000000E-05  +2.96300000E-05
   +3.99700000E-05  -2.03300000E-05  -7.76000000E-05  -1.65660000E-04  -7.59000000E-06
   +2.37300000E-05  +9.70000000E-07  -1.50300000E-05  -2.58100000E-05  +2.26200000E-05
   -1.35700000E-05  -4.58860000E-04  -7.50430000E-04  +5.45310000E-04  +1.22580000E-04
   +1.10530000E-04  +3.30500000E-05  +1.67900000E-05  +2.48400000E-05  -3.33200000E-05
   -1.67032000E-03  +1.86619000E-03  -1.28352000E-03  +6.33635000E-03  +1.62239440E-01
   +1.68502960E-01  -2.01017240E-01  +4.22733000E-02  +1.37919510E-01  +6.13792000E-03
   -1.32441000E-03  -2.29122000E-03  +2.02756000E-03  -2.12151000E-03  +6.60890000E-04
   -2.62690000E-04  -2.97730000E-04  -8.11780000E-04  -5.39060000E-04  -5.15007000E-03
   +1.17899000E-03  -1.41145300E-02  +7.23491000E-03  +1.81980200E-02  -7.67460000E-04
   +3.28620000E-04  -8.16150000E-04  -1.89920000E-04  -3.63430000E-04  +1.97860000E-04
   -1.08436000E-03  +3.24120000E-04  +1.02144000E-03  -1.07780000E-04  -2.45080000E-04
   -2.98550000E-04  -2.17000000E-04  +1.31120000E-04  +1.66550000E-04  -1.45520000E-04
   -6.20000000E-05  -3.03900000E-05  -5.53500000E-05  +3.50000000E-06  -3.32200000E-05
   +2.43000000E-05  -3.09500000E-05  +7.04000000E-06  -5.55800000E-05  +1.05140000E-04
   -1.17980000E-04  +8.60300000E-05  -2.00800000E-05  +4.10000000E-05  +7.94100000E-05
   +2.61000000E-05  -6.69000000E-06  +1.79300000E-05  +1.23560000E-04  -1.37400000E-04
   -1.76670000E-04  -2.08600000E-05  -2.77020000E-04  -3.15320000E-04  -1.21190000E-04
   -4.15000000E-05  -1.69090000E-04  +2.06870000E-04  -1.37600000E-04  +2.17830000E-04
   -1.41360000E-04  -2.49590000E-04  +2.10453990E-01  +4.28735500E-02  -6.93429900E-02
   -5.24704500E-02  +1.85980500E-02  +4.71200000E-05  -1.54853400E-02  -2.49329000E-03
   -1.68875000E-03  -5.29862000E-03  -4.18440000E-04  -1.03426000E-03  +3.33230000E-04
   -5.07434000E-03  +9.69210000E-04  -3.01326000E-03  -1.46354800E-02  +8.00981000E-03
   +1.24054600E-02  +1.45036000E-03  -4.85420000E-04  +1.07545000E-03  -1.15730000E-04
   -7.57840000E-04  -3.20440000E-04  -6.18790000E-04  +3.18920000E-04  +7.58460000E-04
   -1.19190000E-04  -1.71800000E-05  -3.35010000E-04  -9.29400000E-05  -4.64000000E-06
   +1.15540000E-04  -1.03110000E-04  +1.41480000E-04  +4.30000000E-05  +4.90200000E-05
   -4.59700000E-05  -6.77000000E-05  -4.53100000E-05  -1.02690000E-04  +6.50200000E-05
   +2.24470000E-04  +3.71600000E-04  -1.97150000E-04  +1.08500000E-05  -1.22000000E-05
   +5.84100000E-05  +1.08190000E-04  -5.78400000E-05  +4.17500000E-05  +5.86100000E-05
   +3.40000000E-06  +1.27550000E-04  -1.75280000E-04  -3.77910000E-04  +3.54800000E-05
   -2.09520000E-04  -2.37480000E-04  +1.46860000E-04  +2.42600000E-04  -1.87250000E-04
   +2.77700000E-04  +9.66680000E-04  -1.29730000E-04  -8.90430000E-04  -4.14090000E-02
   +6.65685200E-02  +1.36606530E-01  -5.08907900E-02  -1.69894690E-01  +1.53821900E-02
   -3.64451000E-03  -8.46456000E-03  +4.81480000E-04  -5.79122000E-03  +9.88340000E-04
   -9.77100000E-04  +3.75980000E-04  -1.63580000E-04  +1.72485000E-03  -3.02555000E-03
   +5.00861000E-03  +1.23250000E-04  -1.79454000E-03  +2.98375000E-03  -5.28100000E-05
   +1.83318000E-03  -1.54644000E-03  +1.07310000E-04  +1.79370000E-04  -9.33600000E-05
   +3.03230000E-04  +1.19040000E-04  -1.13890000E-04  -3.85620000E-04  -3.20320000E-04
   -2.05650000E-04  -1.12080000E-04  +3.91500000E-04  +2.75580000E-04  -2.40930000E-04
   -3.04000000E-05  +3.18900000E-05  -1.67030000E-04  +4.40300000E-05  -4.82300000E-05
   +6.36700000E-05  +8.75400000E-05  +4.04000000E-06  -2.39630000E-04  -5.15220000E-04
   -2.78060000E-04  +1.77890000E-04  -4.34600000E-05  +5.91900000E-05  +1.60750000E-04
   +3.87300000E-05  -3.31500000E-05  -1.95240000E-04  +7.61600000E-05  -4.54000000E-05
   +7.80400000E-05  +1.36460000E-04  +3.17830000E-04  -1.14630000E-04  +1.02320000E-04
   -7.24500000E-05  -1.39380000E-04  +3.08200000E-04  -3.43140000E-04  +7.55360000E-04
   -9.48200000E-05  -6.24250000E-04  -1.52052820E-01  +5.91835500E-02  +1.73443110E-01
   +2.13683000E-03  -2.00890000E-02  -1.70305500E-02  -2.16313000E-03  -4.55346000E-03
   +2.79677000E-03  -1.54973000E-03  -8.59400000E-05  +2.82360000E-04  -2.03063000E-03
   -5.80340000E-04  +4.55685000E-03  +7.29848000E-03  +1.80365200E-02  +1.40972800E-02
   -5.79258700E-02  -2.87432500E-02  -1.01573000E-02  +4.26400000E-04  -7.61130000E-04
   -7.96140000E-04  +4.48000000E-05  +6.43700000E-05  -1.35900000E-04  +7.98580000E-04
   +8.39640000E-04  -2.04999000E-03  +1.31580000E-04  -7.06400000E-05  +2.26500000E-05
   -5.81700000E-05  +4.03300000E-05  -3.09000000E-06  +1.12000000E-05  -3.52900000E-05
   +9.90000000E-06  -2.00000000E-05  +1.39300000E-05  +1.58800000E-05  +2.47300000E-05
   +5.78700000E-05  -7.93000000E-06  -5.52400000E-05  -1.72860000E-04  +2.24000000E-06
   +1.08700000E-05  +1.43000000E-06  -5.59000000E-06  -1.74500000E-05  +2.69500000E-05
   -5.75000000E-06  -3.72980000E-04  -1.11310000E-04  +9.78400000E-05  +8.04300000E-05
   +2.27800000E-04  +5.37700000E-05  +1.25070000E-04  +3.21200000E-05  -4.07030000E-04
   +1.68850000E-04  +9.53950000E-04  +7.86320000E-04  -9.04900000E-05  +1.67800000E-04
   -2.72250000E-04  -1.24360000E-04  +1.70669000E-03  -1.61679000E-03  +5.32255200E-02
   +3.68110000E-04  -9.43668000E-03  -1.10980200E-02  -4.65948000E-03  +2.57562000E-03
   -1.48888000E-03  +2.64640000E-04  +7.07300000E-05  +7.30820000E-04  -2.42390000E-04
   +2.51282000E-03  -2.29463000E-03  -4.03638000E-03  -2.09296000E-03  -3.47837000E-03
   -2.75076500E-02  -2.25048550E-01  -1.47225670E-01  +2.17100000E-04  -2.26070000E-04
   -7.15020000E-04  -6.68000000E-05  -1.85800000E-05  -5.06000000E-06  +1.17785000E-03
   -4.43780000E-04  +1.74967000E-03  +1.56140000E-04  -1.00130000E-04  +1.38000000E-06
   -4.71500000E-05  +3.42300000E-05  +6.93000000E-06  +3.37000000E-05  +1.57200000E-05
   +5.10000000E-07  +4.50500000E-05  -7.61000000E-06  +6.36000000E-06  -1.13100000E-05
   +8.64000000E-06  +1.31100000E-05  +2.51200000E-05  -1.95400000E-05  +1.07000000E-06
   -5.47900000E-05  +1.07900000E-05  -1.08700000E-05  -3.96200000E-05  -5.34000000E-06
   +1.35800000E-05  -2.35480000E-04  -1.05660000E-04  +1.38450000E-04  -4.42300000E-05
   +1.55800000E-05  +1.38800000E-05  +9.58900000E-05  -1.25650000E-04  +2.75570000E-04
   -2.37300000E-05  -1.17820000E-04  -6.83000000E-05  +2.01240000E-04  -3.02200000E-04
   +2.22810000E-04  +1.24292000E-03  -1.07330000E-03  +2.41889000E-03  +3.31242700E-02
   +2.34031080E-01  +1.07973000E-03  +3.02444000E-03  +4.89470000E-03  +2.63298000E-03
   -2.10630000E-03  +4.40801000E-03  +3.30120000E-04  +1.00672000E-03  -3.05070000E-04
   +5.00080000E-03  -1.93436000E-03  +2.55370000E-04  -4.84029000E-03  -1.86684400E-02
   -8.13998000E-03  -9.69216000E-03  -1.46150070E-01  -1.57078090E-01  +2.21550000E-04
   +9.64000000E-06  +2.30890000E-04  -6.85000000E-06  +2.22000000E-06  -6.94900000E-05
   -1.90593000E-03  +1.92616000E-03  -3.60770000E-04  -6.47000000E-05  -3.49400000E-05
   +3.74000000E-05  -1.72200000E-05  -3.21000000E-06  -3.68200000E-05  +1.49600000E-05
   -1.94100000E-05  +1.74200000E-05  -2.88600000E-05  +1.15200000E-05  +2.38000000E-05
   +2.63000000E-05  +5.16400000E-05  -1.34900000E-05  -2.49700000E-05  -1.53470000E-04
   +1.86500000E-05  +2.00000000E-05  -1.94000000E-06  -1.28700000E-05  -1.47700000E-05
   +1.73700000E-05  -1.88600000E-05  -1.89900000E-05  +4.76700000E-05  -3.17500000E-05
   +1.05810000E-04  +2.56140000E-04  -5.26000000E-06  -3.38490000E-04  +3.29470000E-04
   -2.35200000E-05  -1.44030000E-04  -7.37700000E-04  -6.13040000E-04  -2.59150000E-04
   +2.51650000E-04  -3.23170000E-04  -1.80480000E-03  +2.04095000E-03  -1.80905000E-03
   +9.79988000E-03  +1.60799280E-01  +1.58999930E-01  +2.49480000E-04  +1.78210000E-04
   +1.75800000E-04  +8.14290000E-04  -1.27700000E-03  +3.99930000E-04  +3.10600000E-04
   +1.98470000E-04  +5.82400000E-05  +2.91200000E-05  +2.64600000E-05  -9.88700000E-05
   -3.36600000E-05  -2.68200000E-05  -5.39700000E-05  -1.05690000E-04  +4.73300000E-05
   -5.49500000E-05  -1.02279000E-03  -6.36760000E-04  +9.20470000E-04  -2.43275850E-01
   +1.19599950E-01  -2.29291200E-02  +5.24400000E-05  +1.37600000E-05  +1.42900000E-05
   +3.43170000E-04  -1.34300000E-04  +2.53650000E-04  -1.36590000E-04  +8.51200000E-05
   +2.63870000E-04  +3.02780000E-04  +1.19000000E-05  -2.24300000E-04  -3.32700000E-05
   +2.07300000E-05  +1.29390000E-04  +4.49900000E-05  -6.87000000E-06  -6.62600000E-05
   +2.22500000E-05  -2.16740000E-04  +4.31530000E-04  -1.05430000E-04  +2.26900000E-05
   -1.22510000E-04  -1.57360000E-04  +1.08800000E-05  -4.29900000E-05  -5.16700000E-05
   -1.48280000E-04  +4.16240000E-04  +8.94800000E-05  +1.81520000E-04  -9.23400000E-05
   -9.63000000E-06  -4.08000000E-06  -3.00000000E-08  +2.42800000E-05  +1.49000000E-05
   -4.79000000E-06  +2.32100000E-05  -1.87000000E-06  -2.70000000E-07  +2.94800000E-05
   -6.85400000E-05  +9.13000000E-06  -1.09000000E-06  +9.34000000E-06  -2.67000000E-06
   +2.61231370E-01  +6.37700000E-05  -3.47690000E-04  -5.27430000E-04  +1.04292000E-03
   +4.73680000E-04  -1.65500000E-04  -4.32990000E-04  +5.13700000E-05  +1.03310000E-04
   -9.46000000E-06  +9.19100000E-05  +1.07710000E-04  -1.28430000E-04  -1.99820000E-04
   -2.61000000E-05  -1.75490000E-04  +9.66000000E-06  -7.19000000E-06  +1.18045400E-02
   -9.40438000E-03  +1.63118000E-03  +1.18072700E-01  -1.18390810E-01  +1.25969600E-02
   +1.64100000E-04  +1.48320000E-04  -1.43700000E-05  -7.94400000E-04  -6.57180000E-04
   +2.73524000E-03  -2.87330000E-04  +2.61820000E-04  +3.49060000E-04  -1.04140000E-04
   +1.30140000E-04  -3.95000000E-06  -1.21860000E-04  +2.72900000E-05  +7.37000000E-06
   -3.69100000E-05  -2.02970000E-04  +2.43400000E-04  +1.04452000E-03  +2.06050000E-04
   -9.34700000E-05  +1.58970000E-04  -4.41400000E-05  +3.83700000E-05  +1.66500000E-04
   +2.65500000E-05  -3.19200000E-05  -5.17290000E-04  +2.88080000E-04  -1.02160000E-03
   -1.64970000E-04  -1.09580000E-04  -1.26700000E-05  -2.56500000E-05  -1.94100000E-05
   +2.59900000E-05  +8.94000000E-06  -6.42000000E-06  -1.30000000E-07  +3.13600000E-05
   -3.72000000E-06  +1.45100000E-05  +6.56000000E-05  +1.17860000E-04  +1.63060000E-04
   +1.37000000E-05  -1.44000000E-05  +1.71800000E-05  -1.29903140E-01  +1.26533430E-01
   +3.52000000E-04  +7.40600000E-05  -2.17300000E-05  -1.10614000E-03  -3.89930000E-04
   +7.98840000E-04  +1.04010000E-04  -1.73710000E-04  +1.32070000E-04  +1.24300000E-04
   +4.11800000E-05  -9.32200000E-05  +1.75290000E-04  +3.49300000E-05  -1.37710000E-04
   -3.24970000E-04  +5.60800000E-05  +1.01440000E-04  -2.54338400E-02  +1.59127300E-02
   -5.03636000E-03  -2.08792300E-02  +1.17063500E-02  -4.82953700E-02  -2.28650000E-04
   -1.58410000E-04  +2.88100000E-05  +1.51160000E-03  +1.90165000E-03  -5.49786000E-03
   +7.18230000E-04  +8.80200000E-05  -3.79120000E-04  -2.50800000E-05  +1.35400000E-05
   +2.56900000E-04  +2.25860000E-04  -7.20600000E-05  -5.77200000E-05  +8.32100000E-05
   +2.32910000E-04  -2.83510000E-04  -1.58784000E-03  +5.18930000E-04  +2.38660000E-04
   -1.42160000E-04  +2.29200000E-05  +3.92700000E-05  -9.38100000E-05  -2.11700000E-05
   +6.08800000E-05  -1.13808000E-03  +1.01092000E-03  +1.23139000E-03  +9.61200000E-05
   +1.75790000E-04  -7.63100000E-05  +2.78800000E-05  +3.21000000E-06  -8.32000000E-06
   -1.45300000E-05  +1.16500000E-05  +4.77000000E-06  +1.63700000E-05  -1.10000000E-07
   -7.38800000E-05  +3.86700000E-05  -2.07400000E-05  +4.75200000E-05  +1.03400000E-05
   -1.30700000E-05  -2.82000000E-06  +2.36346900E-02  -1.67050800E-02  +5.49781100E-02
   +1.61280000E-04  +3.44900000E-04  +3.66130000E-04  +5.10730000E-04  -5.18340000E-04
   +8.61260000E-04  +6.21370000E-04  -2.22890000E-04  -2.07960000E-04  -1.38020000E-04
   -1.46490000E-04  -1.10310000E-04  +2.67810000E-04  +2.63240000E-04  +4.03000000E-05
   -7.90900000E-05  +4.62500000E-05  +3.40100000E-05  -1.88880000E-04  +9.48320000E-04
   -1.06320000E-04  -2.03677080E-01  -1.28908740E-01  +2.12377700E-02  -3.43380000E-04
   -2.41060000E-04  +2.87100000E-05  -8.44900000E-05  +1.11450000E-04  +4.66200000E-05
   -8.08350000E-04  +1.15757000E-03  +1.69890000E-04  +9.07000000E-05  +4.23700000E-05
   -2.32180000E-04  -1.36530000E-04  +4.42400000E-05  +5.54900000E-05  +3.35400000E-05
   -1.08000000E-06  +2.07600000E-05  +2.13600000E-05  -1.90180000E-04  -3.20800000E-05
   +7.16900000E-05  -2.17200000E-05  -2.45300000E-05  +7.50000000E-05  +8.95000000E-06
   -1.06600000E-05  +2.28140000E-04  +1.56660000E-04  -5.04660000E-04  +1.13710000E-04
   +3.46800000E-05  +3.31100000E-05  +4.73000000E-05  +1.37600000E-05  -2.47300000E-05
   -4.20800000E-05  -5.29000000E-06  +3.98000000E-06  -4.01500000E-05  +5.14500000E-05
   +3.89000000E-05  -1.04600000E-05  -2.24500000E-05  -3.72300000E-05  -2.34200000E-05
   -1.23100000E-05  -1.47400000E-05  -1.93025500E-02  -1.81586900E-02  +2.52603000E-03
   +2.21975910E-01  -3.29200000E-04  -1.63710000E-04  +2.23670000E-04  +1.40900000E-05
   -3.49080000E-04  +2.97929000E-03  +4.16930000E-04  -4.43500000E-04  -2.51960000E-04
   -5.73980000E-04  -3.36250000E-04  -1.57220000E-04  +9.31000000E-05  +4.62870000E-04
   +4.17140000E-04  +3.44560000E-04  +1.18140000E-04  +3.91100000E-05  -1.07011100E-02
   -8.99715000E-03  -1.11660000E-04  -1.27772030E-01  -1.53065630E-01  +1.75467400E-02
   -3.55300000E-04  -2.54360000E-04  -1.10300000E-05  -8.98760000E-04  +3.26670000E-04
   -2.25790000E-04  +9.66000000E-05  -1.75730000E-04  +7.16990000E-04  +2.42900000E-04
   +2.79300000E-05  -4.08080000E-04  -1.75040000E-04  +6.51200000E-05  +1.70120000E-04
   +5.93800000E-05  +1.62900000E-05  -6.50300000E-05  +2.23700000E-05  -2.51350000E-04
   +2.56450000E-04  -2.58300000E-05  +1.35900000E-05  -1.58500000E-04  -7.64200000E-05
   +7.40300000E-05  -1.27470000E-04  +2.93180000E-04  +3.70190000E-04  -1.37716000E-03
   +1.96630000E-04  +2.55990000E-04  -1.03370000E-04  +4.77700000E-05  +2.47900000E-05
   -2.75900000E-05  -1.01440000E-04  +2.14000000E-06  -3.28700000E-05  +2.94500000E-05
   +1.77500000E-05  +1.00260000E-04  -1.17490000E-04  +3.19790000E-04  -1.19530000E-04
   -6.36000000E-06  -3.63800000E-05  -4.65000000E-06  +1.31479700E-02  +1.17849800E-02
   -2.13677000E-03  +1.40692630E-01  +1.63854340E-01  +2.30350000E-04  -4.68330000E-04
   -2.15200000E-05  -9.70870000E-04  +1.57720000E-03  -5.06265000E-03  +4.33750000E-04
   +7.58960000E-04  +1.29770000E-04  +3.77640000E-04  -3.22500000E-05  +3.82430000E-04
   -2.98200000E-04  -2.79750000E-04  -1.26280000E-04  +3.19380000E-04  -8.30100000E-05
   +1.07100000E-04  +2.33704800E-02  +1.75527400E-02  -3.68117000E-03  +2.05794600E-02
   +1.62229200E-02  -5.08219200E-02  +4.89540000E-04  +3.96980000E-04  -4.03000000E-05
   +6.01660000E-04  -4.66320000E-04  +6.06230000E-04  -6.32260000E-04  -8.56800000E-05
   +5.01120000E-04  -7.57400000E-05  +1.57800000E-05  -1.55000000E-05  -5.11300000E-05
   +8.27000000E-06  +2.43300000E-05  -1.34000000E-06  -2.92600000E-05  -6.06000000E-06
   +3.05300000E-05  -1.20800000E-05  -2.12230000E-04  +2.54900000E-05  -2.25000000E-05
   +3.29000000E-06  +3.27600000E-05  +1.44600000E-05  -3.87300000E-05  +1.22288000E-03
   +1.20313000E-03  +1.16215000E-03  -9.23000000E-05  -2.08390000E-04  +7.99700000E-05
   -5.48700000E-05  +3.56000000E-06  +3.53100000E-05  +1.05940000E-04  +2.89400000E-05
   -1.92000000E-06  -5.84300000E-05  +1.16390000E-04  -1.88490000E-04  -2.63070000E-04
   +3.43690000E-04  +3.34000000E-06  +3.38900000E-05  +3.16400000E-05  +1.56900000E-05
   -2.06597000E-03  -2.26062000E-03  -6.50110000E-04  -2.34906300E-02  -2.03953000E-02
   +5.47616200E-02  -2.37640000E-04  -1.35550000E-04  +2.29310000E-04  +1.26140000E-04
   +7.29350000E-04  +2.18490000E-04  -2.31960000E-04  -1.08400000E-04  +9.59200000E-05
   +1.96770000E-04  +1.07640000E-04  +2.98800000E-05  -1.33700000E-05  -1.37870000E-04
   -9.62500000E-05  -2.72900000E-04  -7.47900000E-05  -5.61900000E-05  -1.95098000E-03
   -3.78400000E-04  -4.25170000E-04  -4.73488600E-02  +6.32005000E-03  +7.41152000E-03
   +5.61200000E-05  +3.64100000E-05  -1.36100000E-05  +4.43220000E-04  -5.52300000E-04
   -5.69490000E-04  -1.00520000E-04  +2.19660000E-04  -6.36060000E-04  -1.53400000E-04
   +2.64200000E-05  +2.32850000E-04  +8.59900000E-05  -3.29300000E-05  -1.19330000E-04
   -3.45400000E-05  -2.20200000E-05  +6.21600000E-05  +7.30700000E-05  +1.14470000E-04
   -3.60700000E-05  +4.65600000E-05  -6.49000000E-06  +1.04350000E-04  +1.28360000E-04
   -3.80000000E-06  +6.05300000E-05  -2.00000000E-04  +1.44800000E-05  -2.45930000E-04
   -1.09100000E-04  -1.04660000E-04  +1.86100000E-05  -9.29000000E-06  -1.15300000E-05
   +8.44000000E-06  +2.69000000E-06  +5.17000000E-06  -1.09700000E-05  +2.80800000E-05
   -2.34000000E-06  -6.10300000E-05  +2.41900000E-04  -5.67860000E-04  +2.64820000E-04
   +9.73000000E-06  -1.98500000E-05  +1.92300000E-05  -2.74090000E-04  +1.87795100E-02
   +2.08046700E-02  +1.45221000E-03  -1.66605600E-02  -1.88659100E-02  +4.83543100E-02
   -4.81410000E-04  -5.90980000E-04  +8.90880000E-04  +1.88640000E-04  +7.32140000E-04
   -3.28580000E-04  -8.09000000E-05  +3.17700000E-05  -1.13430000E-04  +6.10900000E-05
   +7.01400000E-05  +9.37500000E-05  -6.75900000E-05  -2.24400000E-05  -1.10620000E-04
   +9.74000000E-05  -9.41700000E-05  -4.73400000E-05  -7.60920000E-04  +9.58139000E-03
   +1.05200100E-02  +6.30173000E-03  -1.75900350E-01  -1.35962740E-01  +1.30470000E-04
   +8.08600000E-05  -9.18000000E-06  +1.41560000E-04  +6.76360000E-04  -1.84360000E-04
   +7.04320000E-04  +2.30120000E-04  -1.10750000E-04  -5.79200000E-05  -1.92800000E-05
   +1.61110000E-04  +1.24050000E-04  -2.38400000E-05  -4.48300000E-05  -1.94100000E-05
   +3.70900000E-05  -8.91000000E-06  -2.72490000E-04  +3.52600000E-05  -1.48490000E-04
   -3.30300000E-05  +5.57000000E-06  +4.19600000E-05  -3.43000000E-05  -1.60800000E-05
   +6.15000000E-05  -5.20000000E-07  -6.18370000E-04  +2.00225000E-03  -2.50000000E-05
   -4.69600000E-05  +3.30800000E-05  -1.27000000E-05  -3.35000000E-06  +3.83000000E-06
   +2.01200000E-05  -4.57000000E-06  +3.42000000E-06  +1.16300000E-05  -9.17000000E-06
   +1.74100000E-05  -5.62960000E-04  -1.35660000E-03  +7.09140000E-04  +1.42900000E-05
   -8.13000000E-06  +2.90500000E-05  -7.96790000E-04  -1.09773000E-02  -1.10685300E-02
   +2.45377000E-03  -1.30279000E-02  -1.34885300E-02  -7.25279000E-03  +1.90586710E-01
   +2.68060000E-04  -8.34170000E-04  -2.46440000E-04  -1.47437000E-03  -7.74300000E-04
   +7.91290000E-04  +7.53350000E-04  +4.01700000E-05  -2.27820000E-04  -4.48310000E-04
   -3.43820000E-04  -5.21000000E-06  -1.80920000E-04  +3.04330000E-04  +3.35310000E-04
   +4.22860000E-04  +3.50710000E-04  +2.41540000E-04  +1.16193000E-03  -2.06669400E-02
   -2.00105300E-02  +7.85023000E-03  -1.33452440E-01  -1.88513630E-01  -6.21700000E-05
   -9.11000000E-06  +8.80000000E-06  +1.35366000E-03  -9.50000000E-04  +8.45970000E-04
   -2.72360000E-04  +1.93390000E-04  +2.70840000E-04  -1.79190000E-04  +4.00100000E-05
   +2.39350000E-04  +1.10730000E-04  -3.23600000E-05  -2.20600000E-05  +2.24500000E-05
   +1.00100000E-05  +1.26420000E-04  +1.49990000E-04  +7.45900000E-05  -1.38060000E-04
   +6.79000000E-06  -1.12400000E-05  +6.51900000E-05  +1.71700000E-05  +1.18400000E-05
   +3.72300000E-05  -6.60000000E-07  +4.03245000E-03  -5.49511000E-03  +1.66700000E-05
   +1.48300000E-04  +9.72400000E-05  +4.64000000E-06  +9.65000000E-06  -5.71000000E-06
   -1.26200000E-05  +1.63700000E-05  -2.15300000E-05  -1.50400000E-04  +2.31100000E-05
   +8.69700000E-05  -1.49450000E-04  +8.89080000E-04  +2.02730000E-04  +4.37300000E-05
   -1.61000000E-06  -1.61000000E-06  -2.98000000E-06  +3.11103000E-03  +2.78535000E-03
   -4.93980000E-04  +3.55799000E-03  +3.18682000E-03  -7.95290000E-03  +1.45817980E-01
   +2.06134390E-01  -6.39400000E-05  -5.89200000E-05  +2.85800000E-05  +2.46940000E-04
   +3.18680000E-04  -3.21470000E-04  -3.12710000E-04  -5.93930000E-04  -6.45600000E-04
   -8.69500000E-05  +9.40400000E-05  +2.19330000E-04  -5.37100000E-05  -2.32400000E-05
   +4.28800000E-05  +9.66900000E-05  +7.55700000E-05  +6.13000000E-06  -1.98872000E-03
   +4.32530000E-04  -7.81280000E-04  -8.07300000E-05  -2.42240000E-04  -1.20050000E-04
   +1.10220000E-04  +1.13300000E-04  +2.01300000E-05  +6.81100000E-05  -3.52620000E-04
   +6.53840000E-04  -3.76000000E-05  +5.62700000E-05  -8.16200000E-05  -2.14100000E-05
   -6.48600000E-05  +7.18400000E-05  -3.36110000E-04  +2.05500000E-05  +9.55100000E-05
   +6.91100000E-05  -1.46490000E-04  -2.13470000E-04  -2.57010000E-04  +8.61840000E-04
   +3.92860000E-04  +2.40850000E-04  -4.74300000E-05  -1.28100000E-05  +3.62600000E-05
   +5.94600000E-05  -8.98100000E-05  -4.73335100E-02  -8.83790000E-04  +2.26926000E-03
   -1.17900000E-04  -3.24350000E-04  -1.56970000E-04  -2.99100000E-05  -2.13200000E-05
   -7.60000000E-07  -5.40000000E-06  +1.16000000E-06  -2.92900000E-05  -1.57002000E-03
   -1.33830000E-04  -4.15160000E-04  -7.52000000E-06  +5.14200000E-05  +3.60400000E-05
   +7.20000000E-06  +8.50000000E-06  +9.49000000E-06  +2.75090000E-04  -2.10120000E-04
   +3.40370000E-04  +2.05010000E-04  +2.96200000E-04  -2.67800000E-04  +6.89100000E-04
   +8.17300000E-05  -6.57400000E-05  +4.83573000E-02  +2.04450000E-04  -2.07130000E-04
   +2.57000000E-06  +2.67560000E-04  +1.01402000E-03  +4.24400000E-04  -7.96340000E-04
   +1.69080000E-04  +2.95790000E-04  -5.31400000E-05  -2.21480000E-04  -1.28640000E-04
   -1.48590000E-04  +4.91300000E-05  +1.94910000E-04  +1.70010000E-04  +7.12200000E-05
   -4.97400000E-05  +3.08960000E-04  +1.03033400E-02  -2.20012400E-02  +1.75400000E-05
   -3.60765000E-03  -2.73756000E-03  +6.85500000E-05  +1.14600000E-05  -3.58900000E-05
   -2.17730000E-04  +1.03089000E-03  +1.24260000E-04  +2.79000000E-05  -5.78200000E-05
   +8.73600000E-05  +6.19600000E-05  -7.55000000E-06  -3.48400000E-05  +1.19670000E-04
   +4.27100000E-05  -3.41600000E-05  -1.56720000E-04  +1.23730000E-04  +3.17840000E-04
   +9.17230000E-04  -1.71491000E-03  -9.81240000E-04  -2.13940000E-04  -7.37000000E-06
   -1.61000000E-05  -1.05490000E-04  -2.15200000E-05  +2.09100000E-05  -5.40580000E-04
   -7.96768400E-02  +8.70970700E-02  -2.76500000E-05  +2.86310000E-04  +1.39540000E-04
   -4.34000000E-06  +8.30000000E-06  +6.47000000E-06  -1.38900000E-05  +2.17300000E-05
   -1.76600000E-05  -5.58190000E-04  -1.58300000E-04  -2.85520000E-04  -1.24800000E-05
   +5.04500000E-05  -2.97000000E-05  +1.27000000E-06  +1.81900000E-05  -2.05400000E-05
   -2.31560000E-04  -5.10600000E-05  -8.36700000E-05  +2.92580000E-04  +1.45000000E-05
   -9.13500000E-05  -2.96000000E-05  +7.14720000E-04  -1.48583000E-03  +6.20980000E-04
   +8.66244900E-02  -1.38060000E-04  -3.88420000E-04  +3.63500000E-05  +8.43670000E-04
   +8.27410000E-04  +4.79310000E-04  +6.45010000E-04  -3.17470000E-04  -7.64800000E-05
   -2.91390000E-04  -2.70500000E-05  +3.31090000E-04  -3.17100000E-05  +1.95770000E-04
   +8.10200000E-05  +1.65230000E-04  +1.11420000E-04  -2.96000000E-06  +4.18270000E-04
   +8.63304000E-03  -1.83342500E-02  +1.36380000E-04  -4.93404000E-03  -2.48423000E-03
   -3.16000000E-05  +8.68000000E-06  +3.13100000E-05  -7.91570000E-04  +8.05680000E-04
   -5.97540000E-04  +2.75390000E-04  -2.06740000E-04  +9.13400000E-05  -5.01500000E-05
   +1.13160000E-04  -9.14100000E-05  +2.95720000E-04  -5.33500000E-05  -2.20160000E-04
   -1.36040000E-04  -2.51000000E-05  +4.93240000E-04  +7.53500000E-04  +1.20360000E-04
   -9.02800000E-04  -2.92330000E-04  +3.41800000E-05  +9.24500000E-05  +5.73900000E-05
   -8.30900000E-05  +1.32040000E-04  +1.97558000E-03  +8.56309200E-02  -2.84715740E-01
   -1.59820000E-04  +7.12230000E-04  +4.79860000E-04  -1.48900000E-05  -1.14100000E-05
   -1.12400000E-05  -1.90900000E-05  -3.47700000E-05  +4.00000000E-08  -4.31380000E-04
   +3.25720000E-04  +3.23340000E-04  -1.37800000E-05  +1.26140000E-04  +3.23600000E-05
   -2.85300000E-05  +9.43000000E-06  -2.45700000E-05  +1.31300000E-05  +1.03000000E-06
   +3.17350000E-04  -7.10000000E-06  -2.77100000E-05  +4.05050000E-04  -5.20500000E-05
   +5.60880000E-04  -1.46568000E-03  -2.52893000E-03  -9.41480800E-02  +3.10161880E-01
   +9.71200000E-05  +1.73640000E-04  +3.26880000E-04  +6.66230000E-04  +4.22900000E-05
   -5.48000000E-06  -1.54570000E-04  +1.00250000E-04  +4.11030000E-04  +2.06670000E-04
   -1.57980000E-04  -1.74320000E-04  +1.46450000E-04  +5.51600000E-05  -6.82500000E-05
   -1.23830000E-04  -9.61000000E-05  -7.44400000E-05  -1.64217000E-03  +5.35160000E-04
   +6.53050000E-04  -8.63400000E-05  +2.61800000E-04  +3.93880000E-04  -2.18140000E-04
   -1.65440000E-04  -2.00500000E-05  +5.41220000E-04  +1.37287000E-03  +2.70270000E-04
   +5.49160000E-04  +6.95100000E-05  +6.00200000E-05  -3.92100000E-05  -5.87600000E-05
   -5.22600000E-05  -7.97700000E-05  +8.00000000E-06  +1.63100000E-05  +4.41100000E-05
   -2.33600000E-05  -2.08700000E-05  -1.09550000E-04  -1.09680000E-04  +8.82000000E-06
   +8.29500000E-05  -7.29000000E-06  +7.30000000E-06  +6.54800000E-05  +2.75000000E-05
   -3.50500000E-05  -2.37026330E-01  -1.19998690E-01  +3.10841400E-02  +8.35600000E-05
   +2.65900000E-05  +1.80000000E-07  +4.80500000E-05  +2.43300000E-05  -4.80000000E-06
   -2.29500000E-05  -6.36000000E-06  +2.67200000E-05  +1.00560000E-04  -1.50380000E-04
   -5.28410000E-04  +7.76300000E-05  -6.23900000E-05  -5.96200000E-05  -3.35600000E-05
   +1.50000000E-07  -2.13600000E-05  -2.16700000E-05  -1.20060000E-04  +7.26000000E-05
   +3.73080000E-04  +1.82170000E-04  -5.24390000E-04  +2.79320000E-04  +2.64310000E-04
   -6.22400000E-05  +7.70450000E-04  +1.26929000E-03  -3.32880000E-04  +2.54717840E-01
   -1.53872000E-03  -3.46960000E-04  +3.71950000E-04  +1.44718000E-03  -2.65920000E-03
   -3.84649000E-03  +6.09060000E-04  +6.14400000E-05  -6.33040000E-04  -1.61240000E-04
   +6.78300000E-05  +3.84100000E-05  +2.62960000E-04  +1.29190000E-04  -2.58300000E-05
   +1.62400000E-05  -3.46020000E-04  -2.47490000E-04  -2.02655000E-02  -1.51263200E-02
   +3.14816000E-03  +2.49000000E-05  +4.43860000E-04  +1.49797000E-03  -2.53690000E-04
   -1.61700000E-04  +4.96500000E-05  -2.09537000E-03  +2.49750000E-04  +6.48580000E-04
   +7.27320000E-04  +4.67050000E-04  -4.54100000E-05  +1.58200000E-04  -1.11620000E-04
   -4.37400000E-05  +1.30480000E-04  -1.01200000E-05  +4.74700000E-05  +2.36900000E-05
   +8.12100000E-05  -9.38000000E-06  -2.52050000E-04  -3.80800000E-04  +3.80860000E-04
   -4.99100000E-05  +3.19500000E-05  -7.66900000E-05  -1.27990000E-04  +5.53000000E-06
   +2.26000000E-06  -1.18020460E-01  -1.20453610E-01  +2.05619600E-02  +2.49380000E-04
   +7.06600000E-05  -8.15900000E-05  +2.64300000E-05  +1.04300000E-05  -1.58500000E-05
   -5.69900000E-05  -9.90000000E-06  +1.01000000E-06  +2.42990000E-04  +1.03940000E-04
   +3.15110000E-04  +1.43500000E-05  +1.78900000E-05  -6.58000000E-05  -1.00710000E-04
   -1.02880000E-04  +2.92700000E-05  +1.40960000E-04  +4.32300000E-05  -4.49600000E-05
   +2.02960000E-04  +6.43290000E-04  -4.38940000E-04  +3.28560000E-04  +6.23800000E-05
   +1.43170000E-04  -8.89777000E-03  -6.09819000E-03  +9.89990000E-04  +1.30399080E-01
   +1.31788800E-01  -1.18508000E-03  -7.39200000E-04  +4.76660000E-04  +1.07086000E-03
   -2.84994000E-03  -3.07331000E-03  +8.15170000E-04  -2.81400000E-04  -4.92200000E-04
   -1.66660000E-04  +4.02700000E-05  +2.88750000E-04  +8.90300000E-05  +8.82400000E-05
   -1.04900000E-05  +6.80200000E-05  -1.82400000E-04  -2.48130000E-04  -1.82166800E-02
   -1.18361000E-02  +1.10811000E-03  -1.39359000E-03  -9.28110000E-04  +1.02945000E-03
   -6.30100000E-05  +9.16000000E-06  +3.05200000E-05  -8.86500000E-04  +4.17900000E-04
   +7.15750000E-04  +7.22500000E-05  +2.10690000E-04  +4.02300000E-05  +1.21920000E-04
   -5.08300000E-05  -2.49200000E-05  -1.50220000E-04  +2.33400000E-05  +1.06640000E-04
   +1.94700000E-05  -6.57200000E-05  +4.31000000E-06  +1.50030000E-04  -3.36800000E-05
   -4.00840000E-04  -1.88800000E-05  -2.44400000E-05  -6.14000000E-05  -1.22500000E-04
   +1.03100000E-05  -6.62500000E-05  +3.26784800E-02  +2.18182000E-02  -5.24174600E-02
   -3.95600000E-05  +1.29530000E-04  +7.00600000E-05  -6.97000000E-06  -1.32800000E-05
   -2.50000000E-06  -1.21800000E-05  -2.40800000E-05  +6.62000000E-06  -2.18350000E-04
   +5.02150000E-04  +1.72890000E-04  +1.28700000E-05  +1.52000000E-05  +2.99300000E-05
   -1.06540000E-04  -3.41700000E-05  -2.22600000E-05  +2.26900000E-05  +2.40000000E-05
   -6.22400000E-05  +3.12980000E-04  +2.51200000E-05  -7.96470000E-04  +1.78920000E-04
   +2.07580000E-04  +2.18040000E-04  +2.63279500E-02  +1.51260900E-02  -2.89465000E-03
   -3.52549200E-02  -1.88473700E-02  +5.63466700E-02  +1.37090000E-04  +5.94200000E-05
   -1.92500000E-05  +1.93460000E-04  -1.42540000E-04  +2.12080000E-04  -5.66740000E-04
   -7.90290000E-04  +6.78030000E-04  +1.01190000E-04  -9.89500000E-05  -1.47210000E-04
   -1.60090000E-04  -1.70500000E-05  -1.39300000E-05  +4.24800000E-05  +1.82600000E-05
   -1.59200000E-05  +5.34990000E-04  -1.32691000E-03  -1.17210000E-04  +2.24380000E-04
   -3.82660000E-04  -3.05320000E-04  +1.03180000E-04  +4.88500000E-05  -2.48500000E-05
   -1.16380000E-04  +4.17760000E-04  +9.30890000E-04  +7.48940000E-04  +3.94870000E-04
   -2.70610000E-04  +1.46440000E-04  -1.15200000E-05  +2.88600000E-05  +1.59500000E-04
   -2.78400000E-05  +4.85800000E-05  -1.19700000E-05  +6.55000000E-05  +4.25000000E-05
   -1.43640000E-04  -4.05010000E-04  +1.21700000E-04  -1.44180000E-04  +3.25000000E-05
   -6.56500000E-05  -1.60330000E-04  -2.33600000E-05  +1.10400000E-05  -2.11511230E-01
   +1.27743130E-01  -2.74676400E-02  +1.24720000E-04  +9.89800000E-05  -3.17900000E-05
   -9.84000000E-06  +4.66000000E-06  +5.71000000E-06  +3.76900000E-05  -1.19600000E-05
   +2.66200000E-05  -7.21270000E-04  -1.51338000E-03  +2.04070000E-04  -1.48400000E-05
   +1.24000000E-06  +1.08000000E-06  +9.34000000E-06  +2.44300000E-05  -9.92000000E-06
   +3.20920000E-04  -3.22500000E-05  +3.39730000E-04  -2.06680000E-04  +1.25790000E-04
   +1.96700000E-05  +1.77580000E-04  -2.35340000E-04  +1.07170000E-04  +7.69710000E-04
   -1.82866000E-03  +5.14360000E-04  -1.92931900E-02  +1.67893200E-02  -4.18613000E-03
   +2.29233870E-01  -2.72460000E-04  -1.87540000E-04  -2.62900000E-04  +7.48050000E-04
   +9.82930000E-04  +5.59840000E-04  +7.42000000E-06  -3.75050000E-04  -5.45010000E-04
   -3.88590000E-04  +1.50780000E-04  +2.33200000E-04  -1.32590000E-04  +5.50000000E-05
   +1.88290000E-04  +2.38300000E-04  +1.77600000E-04  -1.16600000E-05  +1.94133500E-02
   -1.57191800E-02  +3.27372000E-03  +1.68260000E-04  +6.39370000E-04  +1.56564000E-03
   +1.59430000E-04  +1.48050000E-04  +2.44800000E-05  -1.21290000E-03  -2.68099000E-03
   -3.85099000E-03  +8.51450000E-04  -2.73690000E-04  +4.09480000E-04  -1.53160000E-04
   +5.99980000E-04  +7.18900000E-05  -2.49800000E-05  -3.43700000E-05  -2.00960000E-04
   -5.92300000E-05  -3.92500000E-05  +1.03580000E-04  +5.69900000E-05  +4.59700000E-04
   -1.22930000E-04  +1.41750000E-04  -2.26100000E-05  +1.35970000E-04  +5.51340000E-04
   -3.58300000E-05  +1.88100000E-05  +1.26546660E-01  -1.44569520E-01  +2.11246500E-02
   -2.04800000E-04  -2.88710000E-04  -9.34000000E-05  -3.92800000E-05  -3.58200000E-05
   +7.65000000E-06  +6.72000000E-06  -3.50900000E-05  -7.60000000E-06  -9.77480000E-04
   -9.82610000E-04  +1.02805000E-03  +2.95200000E-05  +7.23800000E-05  +1.24800000E-04
   +2.04300000E-05  -8.44000000E-06  +2.58000000E-05  -3.29110000E-04  +5.31930000E-04
   -5.69280000E-04  -1.15890000E-04  -4.72900000E-05  -1.11950000E-04  -3.29680000E-04
   +5.77500000E-05  +1.82590000E-04  +8.04813000E-03  -6.81396000E-03  +8.29240000E-04
   -1.37808500E-02  +1.15591500E-02  -2.77760000E-03  -1.38890370E-01  +1.56924880E-01
   +1.54900000E-05  +6.08000000E-06  -2.81330000E-04  +6.60800000E-05  +7.84960000E-04
   +5.15870000E-04  -3.32310000E-04  +4.77590000E-04  +6.58340000E-04  -3.71400000E-05
   -2.30340000E-04  -1.94960000E-04  -1.46840000E-04  +7.16400000E-05  +1.36950000E-04
   +1.13560000E-04  +3.48700000E-05  -4.53500000E-05  +1.77050300E-02  -1.38817900E-02
   +1.12215000E-03  +1.11621000E-03  -7.39130000E-04  +1.01010000E-03  +3.66300000E-05
   -1.83400000E-05  -4.27600000E-05  -8.66390000E-04  -2.44591000E-03  -3.54207000E-03
   +7.95190000E-04  -5.41190000E-04  +3.42760000E-04  -1.15890000E-04  +5.91350000E-04
   +2.99300000E-05  +2.79170000E-04  -5.51900000E-05  -2.88760000E-04  -1.45860000E-04
   +3.22400000E-05  +3.71760000E-04  +5.47650000E-04  -1.47840000E-04  -5.84340000E-04
   -1.87380000E-04  +2.27500000E-05  +1.35920000E-04  +4.27600000E-04  -6.66600000E-05
   +7.92600000E-05  -2.75242200E-02  +2.22069600E-02  -5.11477600E-02  -1.30940000E-04
   +4.54530000E-04  +2.59060000E-04  +6.57000000E-06  +1.19500000E-05  +9.02000000E-06
   +1.33100000E-05  -2.35000000E-06  +1.87600000E-05  +3.28440000E-04  +3.95300000E-04
   -2.36000000E-04  +3.15600000E-05  -2.09000000E-05  +1.25700000E-05  +2.18500000E-05
   -1.14400000E-05  +8.42000000E-06  -4.23510000E-04  -1.20440000E-04  -6.64420000E-04
   +7.16700000E-05  +8.99300000E-05  -4.48900000E-05  -1.35710000E-04  +2.08360000E-04
   +3.19050000E-04  -2.45686800E-02  +1.78523100E-02  -2.85030000E-03  +3.97073000E-03
   -3.46349000E-03  -2.24040000E-04  +2.94691200E-02  -2.08919100E-02  +5.48097000E-02
   -4.15900000E-05  -6.88900000E-05  -5.68000000E-06  -8.03000000E-06  +7.73700000E-05
   -3.98490000E-04  -1.41700000E-04  -1.20200000E-05  +7.87600000E-05  -5.03900000E-05
   -1.97100000E-05  +2.84600000E-05  -1.16340000E-04  -2.64100000E-05  +1.10200000E-05
   +4.97000000E-05  +1.83000000E-05  -7.47300000E-05  -2.86950000E-04  +3.17190000E-04
   -1.34880000E-04  +7.53400000E-05  -1.56010000E-04  -3.06100000E-05  +1.08020000E-04
   +6.81700000E-05  -1.20100000E-05  +1.51309000E-03  -1.15005000E-03  -5.49270000E-04
   +4.86860000E-04  +5.17540000E-04  -1.49650000E-04  +2.30320000E-04  +6.88580000E-04
   -4.56900000E-04  -2.39834000E-03  +2.64967000E-03  -3.57129000E-03  -2.09950900E-02
   +1.03063700E-02  +2.20742300E-02  -1.40733270E-01  +5.99403900E-02  +1.06155900E-01
   -2.28009000E-03  -1.00411000E-03  +1.11027000E-03  -1.67500000E-05  -3.14870000E-04
   +3.19230000E-04  -3.36190000E-04  +8.20220000E-04  +3.03200000E-05  +1.05059100E-02
   -1.15722600E-02  -1.24914300E-02  -1.24800000E-05  -4.09000000E-06  +1.12400000E-05
   +2.04600000E-05  -3.66000000E-06  +1.59000000E-06  +6.09500000E-05  +6.45700000E-05
   -1.69300000E-05  +3.07000000E-06  -2.26900000E-05  +4.56000000E-05  +7.50000000E-06
   -1.67000000E-06  +1.03700000E-05  +7.52700000E-05  -2.39200000E-05  +2.68900000E-05
   -1.59000000E-05  +9.89000000E-06  +3.31900000E-05  -1.03000000E-05  -1.51700000E-05
   -4.82800000E-05  +3.08410000E-04  +5.97350000E-04  -6.01210000E-04  -9.34000000E-06
   +9.89000000E-06  -3.37000000E-06  -7.45000000E-06  +5.21300000E-05  -3.34560000E-04
   +1.53176860E-01  -6.56800000E-05  -5.65200000E-05  -6.50200000E-05  +1.66290000E-04
   -3.58100000E-05  -1.09160000E-04  +2.14930000E-04  +7.90500000E-05  +1.20470000E-04
   -9.01500000E-05  -1.40590000E-04  +2.83700000E-05  +3.17000000E-06  +3.15000000E-06
   +1.50600000E-05  +7.44100000E-05  +6.18400000E-05  -3.55100000E-05  +3.47400000E-05
   +3.60080000E-04  -4.41360000E-04  -1.69280000E-04  -6.67700000E-05  -9.73900000E-05
   -5.31000000E-06  +2.53000000E-06  +1.15200000E-05  -1.08207600E-02  +9.06259000E-03
   +1.32729800E-02  +5.69220000E-04  -2.04889000E-03  +2.66098000E-03  +4.43690000E-04
   +5.05680000E-04  +6.12710000E-04  +6.29530000E-04  +4.76080000E-04  +7.73470000E-04
   +3.47922000E-03  +2.29563000E-03  -2.90181000E-03  +6.04706700E-02  -7.93458300E-02
   -6.02543400E-02  +1.27700000E-04  -1.85700000E-04  -3.14580000E-04  -1.54670000E-04
   +8.39100000E-05  -1.43110000E-04  +3.47990000E-04  -1.25996000E-03  +1.10927000E-03
   +6.68634000E-03  -3.29117500E-02  -2.83135800E-02  -3.85000000E-06  +1.71000000E-06
   -9.23000000E-06  -2.25700000E-05  +1.88100000E-05  -1.04100000E-05  -8.60000000E-07
   +2.85400000E-05  -3.06300000E-05  -1.88300000E-05  -5.65700000E-05  +7.87800000E-05
   +2.25500000E-05  -2.39000000E-06  +2.26400000E-05  +1.80200000E-05  +3.47600000E-05
   -3.56900000E-05  -8.00000000E-06  +4.86800000E-05  +2.75000000E-06  -4.23700000E-05
   +7.42000000E-06  -9.29300000E-05  +7.86420000E-04  -1.86718000E-03  +3.03520000E-04
   -6.72000000E-06  +2.22100000E-05  -8.36000000E-06  -1.39600000E-05  +1.11200000E-04
   -1.74310000E-04  -6.19606300E-02  +1.06093940E-01  -4.01500000E-05  -4.70880000E-04
   -2.30880000E-04  -4.25650000E-04  +2.02320000E-04  +1.94100000E-05  -1.56200000E-05
   -4.52700000E-05  +2.12800000E-05  -1.92750000E-04  -1.27480000E-04  +1.31770000E-04
   -2.67610000E-04  -9.04000000E-06  +1.59310000E-04  +2.79100000E-04  +2.06680000E-04
   -1.04390000E-04  +1.08487000E-03  -8.23030000E-04  -1.70270000E-04  -9.96000000E-06
   +5.86500000E-05  +1.16660000E-04  +2.46750000E-04  +1.82070000E-04  -1.50300000E-05
   +1.83427600E-02  -8.71153000E-03  -2.01576300E-02  -1.67138000E-03  +3.11413000E-03
   -3.91392000E-03  -8.89490000E-04  -3.57000000E-06  -3.45310000E-04  -1.50716000E-03
   +7.17220000E-04  -5.89770000E-04  -9.11895000E-03  +5.45669000E-03  +9.49823000E-03
   +1.04059860E-01  -6.16777300E-02  -1.77622630E-01  -8.96840000E-04  -5.70520000E-04
   +4.46650000E-04  +4.55340000E-04  -1.23510000E-04  +2.54960000E-04  +2.15110000E-04
   -1.57450000E-04  -4.55180000E-04  -2.35430000E-04  -1.29776400E-02  -2.24876000E-03
   -3.33300000E-05  -1.86800000E-05  +1.47100000E-05  +1.27000000E-05  -1.57000000E-06
   -1.33200000E-05  -1.42810000E-04  +9.99000000E-05  +1.58400000E-05  +2.68200000E-05
   +2.63700000E-05  +1.31610000E-04  +2.95400000E-05  +2.00100000E-05  +1.39800000E-05
   -1.13960000E-04  +4.34100000E-05  +3.90100000E-05  -9.10000000E-07  -1.43170000E-04
   +3.41700000E-05  +6.12400000E-05  +3.49100000E-05  +1.63720000E-04  -1.78450000E-04
   +4.58650000E-04  +1.13147000E-03  -7.72100000E-05  -2.40210000E-04  +1.40610000E-04
   -4.54100000E-05  -1.39020000E-04  +5.11860000E-04  -1.10176410E-01  +7.52142200E-02
   +1.92962620E-01  +7.38000000E-06  -1.10700000E-05  +2.22200000E-05  +2.44480000E-04
   +6.05700000E-05  -1.50000000E-06  +1.37600000E-05  -3.18300000E-05  -6.54000000E-06
   -2.01000000E-05  -3.43300000E-05  +2.49000000E-06  +5.24200000E-05  +3.88700000E-05
   -2.89000000E-06  -1.74600000E-05  -4.63000000E-06  +1.89800000E-05  +4.94360000E-04
   +4.39780000E-04  -1.04154000E-03  -3.67980000E-04  +2.42200000E-04  +5.46300000E-05
   -7.25100000E-05  -5.40100000E-05  +1.29300000E-05  -4.80314000E-03  -5.91160000E-04
   +3.22620000E-04  -9.49300000E-05  +3.32120000E-04  -2.62980000E-04  -3.49374000E-03
   +1.75119000E-03  +2.33330000E-04  +7.86044000E-03  -5.42366000E-03  +2.72442100E-02
   -6.00247300E-02  +8.79513000E-03  -3.58996900E-02  +1.94430000E-04  +7.18884000E-03
   -2.77968400E-02  +1.26891000E-03  -2.87920000E-04  -1.47214000E-03  -6.15630000E-04
   -9.76920000E-04  +1.33125000E-03  -6.88000000E-06  -4.44900000E-05  -7.49600000E-05
   -2.85450000E-04  -1.08440000E-04  +8.43690000E-04  +4.86000000E-06  +6.62000000E-06
   -1.04700000E-05  -1.84700000E-05  +1.15000000E-06  -2.30000000E-07  +2.09000000E-06
   +1.59100000E-05  -5.63000000E-06  +7.62000000E-06  +1.88100000E-05  +4.66000000E-06
   -6.29000000E-06  -4.45000000E-06  -2.81000000E-06  -1.26500000E-05  +9.26200000E-05
   -1.29430000E-04  +1.61500000E-05  +9.20000000E-07  +1.04000000E-06  +7.49000000E-06
   -1.57200000E-05  +1.18700000E-05  -7.65000000E-06  +2.08000000E-06  +2.60600000E-05
   +7.72000000E-06  +5.66000000E-06  +9.20000000E-07  -6.54000000E-06  +3.39900000E-05
   +2.25400000E-05  +1.00142000E-03  -7.66100000E-05  +5.85410000E-04  +5.79369200E-02
   -3.54000000E-06  +2.16400000E-05  +1.53700000E-05  +2.89900000E-05  -6.13600000E-05
   -1.83600000E-05  -3.88100000E-05  +1.08100000E-05  +3.37800000E-05  +2.61400000E-05
   +1.84500000E-05  -8.39000000E-06  -1.46400000E-05  -1.36300000E-05  -1.11200000E-05
   -6.56000000E-06  -4.26800000E-05  +1.10600000E-05  +9.36000000E-06  +1.45630000E-04
   +2.48630000E-04  +8.33300000E-05  -9.37300000E-05  +4.78000000E-06  +1.80900000E-05
   -5.30000000E-07  -7.40000000E-07  +6.64350000E-04  +5.33960000E-04  +7.83990000E-04
   -3.63300000E-04  -4.00900000E-04  +3.53820000E-04  +1.76117000E-03  +8.83255000E-03
   +3.80265000E-03  +1.71471000E-03  +7.17985000E-03  +1.88900000E-05  +7.58072000E-03
   -4.30364000E-02  +5.89393200E-02  -1.07960000E-04  +6.61410000E-04  +2.34809000E-03
   -1.07751000E-03  -6.19575000E-03  -1.46723000E-03  +4.82730000E-04  +4.67920000E-04
   -2.29817000E-03  -7.88000000E-06  +9.55000000E-06  +4.26300000E-05  +5.20710000E-04
   -2.04420000E-04  +6.84950000E-04  -6.89000000E-06  +4.06000000E-06  -6.20000000E-07
   +4.51000000E-06  +3.55000000E-06  -1.83000000E-06  +1.53300000E-05  -1.10500000E-05
   -7.68000000E-06  -3.97000000E-06  +2.58000000E-06  -1.97100000E-05  -9.43000000E-06
   +2.09000000E-06  -8.26000000E-06  +1.73500000E-05  -3.48400000E-05  +2.14300000E-05
   -1.34100000E-05  +5.48000000E-06  +7.20000000E-06  -4.34000000E-06  -1.50000000E-06
   -4.55700000E-05  +7.01000000E-05  +7.79000000E-06  -2.87700000E-05  -1.21400000E-05
   -2.59400000E-05  +4.52800000E-05  -5.73000000E-06  -2.76000000E-06  -3.56900000E-05
   -4.51060000E-04  -1.66400000E-04  -6.86800000E-05  -1.05491200E-02  +3.38237300E-02
   +7.60000000E-07  -3.34000000E-06  +6.31000000E-06  +7.79300000E-05  +6.37800000E-05
   -1.77000000E-06  -4.25000000E-06  -2.01800000E-05  -1.80400000E-05  -1.49600000E-05
   -3.09400000E-05  -1.05000000E-06  +5.98900000E-05  +4.61200000E-05  -4.19000000E-06
   -2.18300000E-05  -5.11000000E-06  +2.34400000E-05  +3.26660000E-04  +6.96400000E-05
   -3.06600000E-04  -1.50940000E-04  +7.62500000E-05  +5.57000000E-05  -7.81900000E-05
   -5.89200000E-05  +1.13600000E-05  -1.28156000E-03  -1.96990000E-04  +1.26266000E-03
   +2.40000000E-04  -3.78540000E-04  +5.04950000E-04  +2.65806000E-03  +1.13767000E-03
   +1.71811000E-03  -6.36013000E-03  +5.43833000E-03  -1.79238900E-02  -3.13515900E-02
   +5.82121500E-02  -3.24647930E-01  +2.46945000E-03  +2.63452000E-03  -4.66684000E-03
   -1.06577000E-03  -1.21673000E-03  +1.40118000E-03  +9.20000000E-04  +6.18000000E-04
   -1.37425000E-03  -6.14600000E-05  +8.22000000E-06  -4.94100000E-05  -4.33260000E-04
   -1.28400000E-03  +5.24930000E-04  +8.04000000E-06  +7.95000000E-06  -7.81000000E-06
   -1.31000000E-05  -8.20000000E-07  +2.85000000E-06  +5.91000000E-06  +6.46000000E-06
   -4.85000000E-06  +8.44000000E-06  +1.68500000E-05  +6.93000000E-06  -5.78000000E-06
   -2.97000000E-06  -6.09000000E-06  -1.49600000E-05  +3.28000000E-05  -4.81100000E-05
   +5.09000000E-06  -1.47500000E-05  +4.10000000E-07  +1.57300000E-05  -3.56000000E-06
   +1.30000000E-06  -1.11500000E-05  -1.12800000E-05  +7.25000000E-06  +6.14000000E-06
   -5.46000000E-06  -1.54700000E-05  -1.19800000E-05  +3.91800000E-05  +2.80800000E-05
   -5.62910000E-04  -1.06310000E-04  +7.91430000E-04  +3.54785300E-02  -6.45888100E-02
   +3.43586850E-01  -1.88350000E-04  +5.74000000E-05  +1.44370000E-04  -3.78220000E-04
   +5.71820000E-04  -1.47010000E-04  -3.19300000E-05  -8.35600000E-05  -1.69250000E-04
   -6.21300000E-05  -1.62960000E-04  -1.00500000E-05  +1.01400000E-04  +1.70350000E-04
   +8.12500000E-05  +2.37000000E-05  -2.00000000E-07  -1.05400000E-05  -8.50470000E-04
   -1.52237000E-03  -2.72390000E-04  -9.67500000E-05  -1.95600000E-05  +1.70320000E-04
   -1.98400000E-04  -1.52170000E-04  -1.25000000E-06  +1.50000000E-04  +1.25546000E-03
   -1.13906000E-03  -4.62298000E-03  +2.41074000E-02  +1.42670100E-02  -4.22705100E-02
   +1.96234800E-02  +5.63849000E-03  +1.69043000E-03  -4.34563000E-03  -3.34350000E-03
   -1.08206000E-03  +6.00930000E-04  -2.39500000E-04  +5.91500000E-04  +1.47661000E-03
   +4.61060000E-04  +7.68810000E-04  +6.52290000E-04  -2.25700000E-05  -7.32988000E-03
   -3.56573300E-02  -8.27774000E-03  -4.48400000E-05  -1.05690000E-04  -2.41590000E-04
   +2.41140000E-04  -7.77390000E-04  -7.26600000E-04  +2.96500000E-05  +1.00400000E-05
   -9.98000000E-06  -2.49500000E-05  -2.17400000E-05  +1.61100000E-05  +1.02100000E-05
   +1.96800000E-05  -2.49900000E-05  +2.96000000E-06  +5.00600000E-05  +5.68000000E-06
   -2.93900000E-05  -2.05700000E-05  -8.56000000E-06  -1.80800000E-05  +2.39600000E-05
   -7.22500000E-05  +3.34000000E-05  +1.24000000E-05  +2.99200000E-05  -2.79900000E-05
   -2.81900000E-05  -5.08800000E-05  +2.11200000E-05  -2.25400000E-05  +7.64000000E-06
   +1.58700000E-05  -7.38000000E-05  -2.02500000E-05  -6.50300000E-05  +4.58800000E-05
   +4.91300000E-05  -5.92300000E-05  -3.69910000E-04  +1.58100000E-04  +3.44990000E-04
   +6.25150000E-04  -3.66200000E-05  +5.82352600E-02  +7.55400000E-05  -3.18900000E-05
   -4.29100000E-05  +1.82190000E-04  -2.27000000E-04  +2.52400000E-05  +1.20400000E-05
   +3.57800000E-05  +6.62600000E-05  +3.03500000E-05  +6.67700000E-05  -5.03000000E-06
   -2.85900000E-05  -6.40300000E-05  -3.27800000E-05  -1.21800000E-05  -3.04000000E-06
   +3.17000000E-06  +6.81320000E-04  +7.95120000E-04  +9.44600000E-05  -6.57000000E-06
   -4.90000000E-06  -6.37700000E-05  +6.63700000E-05  +5.13500000E-05  -4.40000000E-07
   -5.39090000E-04  -9.07310000E-04  +2.13879000E-03  +6.52267000E-03  -1.21343100E-02
   -8.17201000E-03  +7.03210000E-03  -2.37605670E-01  -1.06914430E-01  +1.59368000E-03
   +6.31419000E-03  +5.04360000E-04  -8.57900000E-04  +3.46980000E-04  +6.53900000E-04
   +1.87750000E-04  +9.67300000E-05  -1.02960000E-04  -5.19330000E-04  -1.57780000E-04
   -1.76450000E-04  -8.67879000E-03  -2.31419800E-02  -4.25860000E-03  -9.60700000E-05
   +9.59800000E-05  +8.42200000E-05  -1.59940000E-04  -2.63820000E-04  -1.72220000E-04
   -9.25000000E-06  -3.21000000E-06  +3.95000000E-06  +9.97000000E-06  +8.11000000E-06
   -5.39000000E-06  +2.19000000E-06  -1.30000000E-05  +1.06400000E-05  -2.84000000E-06
   -9.00000000E-06  -1.54100000E-05  +8.97000000E-06  +6.57000000E-06  +2.76000000E-06
   +1.86500000E-05  -9.50000000E-07  +1.52000000E-05  -8.10000000E-06  +1.97700000E-05
   -1.55500000E-05  +9.87000000E-06  +8.99000000E-06  +5.58000000E-06  +1.41500000E-05
   -9.40000000E-06  -1.90100000E-05  -1.79500000E-05  +1.11500000E-05  +2.60000000E-06
   +3.82000000E-06  +5.38000000E-06  +9.80000000E-07  -1.26140000E-04  +1.02500000E-05
   -8.41000000E-05  -8.22500000E-05  -5.69610000E-04  -1.80690000E-04  -1.80365000E-03
   +2.67771020E-01  -1.93000000E-05  -2.29000000E-05  +3.48000000E-06  -1.33660000E-04
   +1.66470000E-04  +1.49600000E-05  -3.14200000E-05  -3.26700000E-05  -1.11700000E-05
   -1.23600000E-05  -2.71700000E-05  +1.99900000E-05  -1.79100000E-05  +1.15200000E-05
   +1.16400000E-05  +1.63700000E-05  -3.81000000E-06  -1.45000000E-06  -4.43070000E-04
   -7.73490000E-04  -2.06960000E-04  +7.57000000E-06  -9.02000000E-06  +3.05100000E-05
   -1.01000000E-06  -1.76000000E-06  -5.10000000E-07  -1.78220000E-04  +6.61230000E-04
   -5.36950000E-04  +2.60130000E-04  +6.61752000E-03  +6.04814000E-03  -1.52176000E-03
   -1.16449850E-01  -1.09777600E-01  +2.99810000E-03  -2.78984200E-02  -2.21318500E-02
   -9.10020000E-04  +1.07457000E-03  -1.74999000E-03  -5.66150000E-04  -7.11920000E-04
   -5.00440000E-04  +4.70180000E-04  +2.19892000E-03  +1.67825000E-03  +3.30272000E-03
   +1.59208400E-02  +7.56227000E-03  +7.47100000E-05  -6.21700000E-05  -6.47300000E-05
   +1.28140000E-04  +5.20550000E-04  +6.67220000E-04  -2.03000000E-06  -1.19000000E-06
   -1.99000000E-06  -5.19000000E-06  -3.46000000E-06  +6.00000000E-07  -8.16000000E-06
   +1.23500000E-05  -6.13000000E-06  +8.76000000E-06  -2.00000000E-07  +7.38000000E-06
   -1.17000000E-06  -1.03000000E-06  +6.60000000E-07  -1.79000000E-06  -6.24000000E-06
   -5.84000000E-06  +6.29000000E-06  -1.92000000E-06  +2.30000000E-06  -1.48400000E-05
   -1.50000000E-06  -7.55000000E-06  -2.62500000E-05  +1.31400000E-05  +2.78400000E-05
   +7.51000000E-06  -4.87000000E-06  -8.32000000E-06  -9.32000000E-06  -6.97000000E-06
   +8.65000000E-06  +2.03850000E-04  +8.44200000E-05  +1.06790000E-04  +6.85890000E-04
   +1.69923000E-03  +6.74600000E-05  -6.46461000E-03  +1.15796570E-01  +1.19196250E-01
   -6.23000000E-05  +1.38320000E-04  +1.22450000E-04  -3.40270000E-04  +2.03650000E-04
   -1.38590000E-04  -2.43700000E-05  +2.20000000E-06  -8.70400000E-05  +3.55100000E-05
   -6.00000000E-06  +1.60200000E-05  -3.13300000E-05  -1.50800000E-05  +1.97800000E-05
   +1.77700000E-05  -1.67700000E-05  -5.89300000E-05  -3.24090000E-04  -2.55244000E-03
   -1.26791000E-03  -2.08464000E-03  +1.31360000E-03  +4.87020000E-04  +4.20200000E-05
   +2.67000000E-05  -1.64500000E-05  +5.04725000E-03  -1.30879500E-02  +2.27225900E-02
   -5.08961100E-02  +8.72737000E-03  -1.04510000E-03  -1.34044000E-03  +1.37212700E-02
   -2.31216900E-02  -4.28200000E-03  +1.76989000E-03  +2.01827000E-03  +2.54730000E-04
   -2.11860000E-04  -4.40250000E-04  -3.05159000E-03  +4.33246000E-03  +4.07925000E-03
   -8.37240000E-04  +6.89000000E-05  -1.80509000E-03  +3.65553000E-03  -6.80830000E-04
   +6.87780000E-04  +4.65550000E-04  -7.44400000E-05  -5.34200000E-05  +2.28690000E-04
   +2.91440000E-04  -7.02280000E-04  -2.45000000E-06  -7.99000000E-06  +6.01000000E-06
   +1.15600000E-05  -9.76000000E-06  +4.57000000E-06  -3.16000000E-06  -1.34100000E-05
   +2.40000000E-07  +4.05900000E-05  -9.62000000E-05  +2.70000000E-07  +1.34000000E-06
   -2.22000000E-06  +7.45000000E-06  +1.69780000E-04  -2.46400000E-04  -9.17400000E-05
   -1.15748000E-03  +1.31011000E-03  -1.66700000E-04  -1.36398000E-03  +1.59870000E-04
   -6.64900000E-04  +3.17500000E-05  -6.57500000E-05  -1.42970000E-04  +3.21800000E-05
   -3.06000000E-05  +2.74100000E-05  -4.36400000E-05  -8.87900000E-05  -5.89600000E-05
   +1.66780000E-04  -1.02934000E-03  +1.39329000E-03  +1.77060000E-04  -6.44300000E-05
   +5.19000000E-06  +3.11600000E-05  +1.26010000E-04  +1.66940000E-04  +5.58995300E-02
   -1.25280000E-04  +1.23970000E-04  +1.87170000E-04  -6.46460000E-04  +5.69250000E-04
   +3.02210000E-04  -1.32360000E-04  -1.36360000E-04  -1.30230000E-04  +5.69000000E-06
   -3.45400000E-05  +1.41200000E-05  -1.51600000E-05  +4.70400000E-05  +3.34700000E-05
   +4.33200000E-05  -4.06000000E-05  -4.92700000E-05  -2.27314000E-03  -4.76816000E-03
   -2.75334000E-03  +2.43458000E-03  -3.34680000E-04  -7.79200000E-05  -1.35900000E-05
   -2.60800000E-05  -1.79900000E-05  -6.21630000E-04  +5.50390000E-03  +1.88170000E-03
   +9.63063000E-03  -1.12624340E-01  +1.27834410E-01  -1.47682000E-03  -6.15062000E-03
   +1.64826600E-02  +2.09491000E-03  -9.06860000E-04  -3.22013000E-03  -2.54780000E-04
   -5.34000000E-05  +3.23090000E-04  +2.98375000E-03  +6.32657000E-03  +5.67113000E-03
   +6.00180000E-04  +5.38220000E-04  +1.36517000E-03  -8.46560000E-04  +1.37779000E-03
   -1.79656000E-03  +1.33822000E-03  -6.20320000E-04  +2.57240000E-04  -2.60850000E-04
   +1.81830000E-03  -2.32412000E-03  +3.42000000E-06  -1.78000000E-06  -1.10000000E-07
   -6.02000000E-06  -1.55600000E-05  +3.78000000E-06  +4.11000000E-06  -7.71000000E-06
   -6.48000000E-06  -5.94600000E-05  -8.37600000E-05  -2.88400000E-05  -7.76000000E-06
   -9.66000000E-06  +7.12000000E-06  +6.20000000E-07  -2.83660000E-04  -3.74260000E-04
   +1.74671000E-03  -1.29894000E-03  +1.95170000E-04  -1.87160000E-04  -1.57170000E-04
   -2.39800000E-04  -1.99400000E-05  +7.34000000E-06  +6.43000000E-06  -2.11500000E-05
   -1.20000000E-05  +6.50000000E-07  -4.61200000E-05  -3.09290000E-04  -3.39310000E-04
   +5.81700000E-05  -9.16600000E-04  +6.06910000E-04  +5.92000000E-06  +3.95400000E-05
   +9.10300000E-05  -3.13010000E-04  +6.07900000E-05  -3.82070000E-04  -1.38715700E-02
   +1.11667180E-01  -1.79600000E-05  +4.03000000E-06  +2.52100000E-05  -3.44000000E-04
   +1.69000000E-04  +1.18310000E-04  -2.13100000E-05  -5.48700000E-05  -4.32700000E-05
   -1.58300000E-05  -4.52800000E-05  +8.98000000E-06  -7.70000000E-06  +3.59300000E-05
   +1.77700000E-05  +1.40400000E-05  -9.70000000E-07  +1.93400000E-05  -2.71968000E-03
   -1.38769000E-03  -2.29310000E-03  -1.41810000E-03  +1.21702000E-03  +3.55250000E-04
   -3.03500000E-05  -3.08200000E-05  +3.65000000E-06  -8.80520000E-04  +1.13121100E-02
   -1.26172400E-02  +1.95620000E-03  +1.27766630E-01  -2.65977940E-01  +1.90263000E-03
   +2.95186000E-03  -2.88152000E-03  -6.67400000E-05  +5.46280000E-04  +4.13990000E-04
   +1.46630000E-04  -4.13830000E-04  +5.85840000E-04  +4.09564000E-03  +1.55354000E-03
   +2.58427000E-03  -3.15360000E-04  +1.98740000E-04  +6.38200000E-05  +6.63730000E-04
   -1.68183000E-03  +1.16233000E-03  +8.52930000E-04  -2.61800000E-04  +1.01230000E-04
   +5.53000000E-06  +1.47756000E-03  -1.00038000E-03  -8.40000000E-07  +3.13000000E-06
   -6.41000000E-06  -7.49000000E-06  -2.61000000E-06  -1.00000000E-08  -8.10000000E-06
   +1.20700000E-05  -9.18000000E-06  +9.69000000E-06  +2.96700000E-05  -2.22300000E-05
   -5.16000000E-06  +1.00000000E-08  -6.17000000E-06  -5.10620000E-04  -2.56360000E-04
   +3.54460000E-04  -5.82090000E-04  -3.98770000E-04  +2.38110000E-04  -4.46730000E-04
   +2.88750000E-04  +3.87400000E-05  -5.85000000E-05  +1.98300000E-05  +8.11000000E-05
   -4.09000000E-06  -8.30500000E-05  -6.73200000E-05  +1.28200000E-05  -2.30720000E-04
   -1.57720000E-04  +2.86400000E-05  +1.49570000E-04  -4.38680000E-04  -2.33600000E-05
   -4.94300000E-05  -5.00700000E-05  -6.99940000E-04  +3.32200000E-04  -2.43550000E-04
   -7.16200000E-04  -1.43664940E-01  +2.80163590E-01  +9.15000000E-06  +1.14700000E-05
   +1.28900000E-05  +1.54400000E-05  -1.26200000E-04  +1.86300000E-05  -1.34600000E-05
   +1.74600000E-05  +4.63700000E-05  +4.19100000E-05  +6.53200000E-05  +2.34900000E-05
   -1.51510000E-04  -1.14280000E-04  -8.10000000E-06  +3.40700000E-05  -3.06100000E-05
   -2.77400000E-05  -9.98100000E-05  +6.36100000E-05  -1.02420000E-04  +8.02100000E-05
   -3.15900000E-05  -1.05500000E-05  +1.84010000E-04  +1.18460000E-04  -1.13800000E-05
   +6.94000000E-06  -1.98200000E-05  +8.36100000E-05  -6.62450000E-04  -3.23650000E-04
   +1.03208000E-03  -2.39041000E-03  -1.14826000E-03  -4.16710000E-04  -4.33436000E-02
   -9.77969000E-03  +3.49161400E-02  -3.65835000E-03  +8.45650000E-04  -5.21936000E-03
   -9.66330000E-04  +7.87370000E-04  +1.45614000E-03  -1.98140700E-01  -6.39181400E-02
   +1.80403940E-01  +1.07142000E-03  -1.14608000E-03  +2.84461000E-03  +1.10150000E-04
   -3.25600000E-05  +5.54500000E-05  +6.34190000E-04  +1.89220000E-04  +1.04990000E-04
   -3.45600000E-05  -1.23400000E-05  +5.99000000E-06  +1.81900000E-05  +6.69000000E-06
   -1.31200000E-05  -1.52800000E-05  -5.03000000E-06  +3.25000000E-06  -2.28100000E-05
   -1.65600000E-05  -3.87200000E-05  -9.50000000E-07  +1.00100000E-05  +9.60000000E-07
   +5.06100000E-05  -2.73900000E-05  +1.73000000E-06  -5.34000000E-06  +5.04400000E-05
   -1.18100000E-05  -3.37700000E-05  -5.45000000E-06  -1.82200000E-05  -2.00600000E-05
   +1.33500000E-05  -5.44000000E-06  -9.43000000E-06  +4.40300000E-05  +8.74000000E-06
   +4.23500000E-05  -5.07100000E-05  -2.65600000E-05  -3.40050000E-04  +7.25700000E-05
   -2.43480000E-04  +2.29570000E-04  -3.58090000E-04  -2.11940000E-04  -4.29000000E-05
   +2.18100000E-05  -4.22320000E-04  +3.92930000E-04  -2.15400000E-04  -2.59000000E-06
   +2.46816900E-01  -1.03500000E-05  +4.10000000E-07  +5.30000000E-06  +4.20900000E-05
   +2.64500000E-05  -1.42700000E-05  -4.97000000E-06  -8.93000000E-06  -7.49000000E-06
   -8.53000000E-06  -2.66300000E-05  -1.05800000E-05  +4.71400000E-05  +4.32900000E-05
   +1.92000000E-06  -1.20600000E-05  -6.39000000E-06  +1.89100000E-05  +6.17500000E-05
   +5.92100000E-05  +1.09940000E-04  +6.32000000E-06  +9.68000000E-06  -1.06000000E-06
   -6.37400000E-05  -5.22700000E-05  +6.33000000E-06  -2.10110000E-04  +1.47130000E-04
   -3.84760000E-04  -1.27590000E-03  -8.08760000E-04  +7.19370000E-04  +4.50170000E-03
   +2.17359000E-03  +2.82920000E-04  +3.49825000E-03  -6.81940000E-04  -7.52273000E-03
   +2.81755000E-03  +1.07679000E-03  +1.64202000E-03  +2.72750000E-04  +2.18408000E-03
   -7.32200000E-05  -8.17205200E-02  -4.77882600E-02  +1.10321390E-01  -4.36352000E-03
   -2.10224000E-03  -4.11774000E-03  -2.91300000E-05  +3.60200000E-05  -4.43600000E-05
   +6.46610000E-04  +1.03810000E-04  +2.39410000E-04  +7.56000000E-06  +8.50000000E-06
   -4.90000000E-06  -7.66000000E-06  -1.20000000E-07  +1.94000000E-06  +1.08700000E-05
   +1.73000000E-06  -8.48000000E-06  +6.79000000E-06  +2.11300000E-05  +2.98000000E-06
   -8.84000000E-06  -2.61000000E-06  -6.94000000E-06  -1.15100000E-05  +9.09000000E-06
   -3.07000000E-06  -3.33000000E-06  -2.43800000E-05  +1.05700000E-05  +5.69000000E-06
   -3.93000000E-06  -2.26000000E-06  +1.70000000E-06  -6.35000000E-06  +1.07300000E-05
   -6.45000000E-06  -2.42600000E-05  +5.15000000E-06  -1.50800000E-05  +2.08700000E-05
   +1.51800000E-05  -1.29040000E-04  -1.40680000E-04  -1.03620000E-04  -2.13550000E-04
   -6.76160000E-04  -5.81900000E-05  -5.93810000E-04  -4.40470000E-04  -7.13410000E-04
   +3.62860000E-04  -1.77160000E-04  +8.31900000E-05  +7.46916500E-02  +4.87255100E-02
   +7.24000000E-06  +4.90200000E-05  +3.56700000E-05  +6.92000000E-06  -1.13820000E-04
   -2.02300000E-05  -1.17000000E-06  +2.59700000E-05  +3.80000000E-06  +3.44300000E-05
   +4.76100000E-05  -1.80000000E-05  -8.67000000E-06  -3.58000000E-05  -1.38700000E-05
   -4.11000000E-06  -1.14000000E-06  -1.68800000E-05  -2.69000000E-06  -9.90000000E-07
   -3.69510000E-04  -4.18900000E-05  +1.53000000E-05  -1.93000000E-05  +3.88300000E-05
   +3.34400000E-05  -1.37100000E-05  -8.85100000E-05  -4.36790000E-04  +4.19370000E-04
   +1.06782000E-03  +1.15364000E-03  -1.02064000E-03  -9.03093000E-03  -1.53020000E-03
   -3.29480000E-04  -1.82644000E-03  -5.83897000E-03  +1.27433700E-02  -5.34750000E-03
   +1.99706000E-03  -1.12680000E-04  +8.98710000E-04  +3.71510000E-04  +1.72419000E-03
   +2.24989960E-01  +1.09219670E-01  -3.12290140E-01  +3.61358000E-03  -3.18568000E-03
   +5.93520000E-04  +1.68660000E-04  -6.64300000E-05  +1.50530000E-04  -8.51390000E-04
   -2.08570000E-04  -6.96330000E-04  +2.20000000E-07  -5.75000000E-06  +9.58000000E-06
   +1.38200000E-05  +3.40000000E-07  +8.00000000E-08  +7.06000000E-06  -2.36000000E-05
   +1.01300000E-05  -5.36000000E-06  -2.48300000E-05  -6.86000000E-06  +3.10000000E-06
   -2.51000000E-06  +9.89000000E-06  +3.37300000E-05  -8.50000000E-07  -1.65500000E-05
   +4.85000000E-06  +5.44100000E-05  +3.60000000E-07  -3.17300000E-05  -1.35700000E-05
   -1.84200000E-05  +4.22200000E-05  -7.16000000E-06  -6.87000000E-05  +2.99000000E-06
   +2.45000000E-05  +3.63000000E-05  +1.23000000E-05  -5.71700000E-05  -8.39700000E-05
   -4.35030000E-04  +9.30000000E-06  -2.33770000E-04  -2.13360000E-04  -3.23970000E-04
   -1.29520000E-04  +2.50910000E-04  +3.83000000E-06  -2.26250000E-04  -3.81130000E-04
   +4.94200000E-05  -1.22500000E-04  -2.13981980E-01  -1.02384280E-01  +2.99258880E-01
   +5.58700000E-05  +1.69200000E-05  -2.69000000E-06  +2.05000000E-06  -2.59880000E-04
   +4.10800000E-05  -5.54000000E-06  +4.95100000E-05  +8.27900000E-05  +7.04300000E-05
   +1.18640000E-04  +2.63200000E-05  -1.92730000E-04  -1.74260000E-04  -2.55300000E-05
   +4.19400000E-05  -2.41100000E-05  -4.30500000E-05  -1.10960000E-04  +1.65870000E-04
   -3.00780000E-04  +4.31900000E-05  -6.67600000E-05  -1.86800000E-05  +2.64160000E-04
   +1.81650000E-04  -1.90200000E-05  -8.98690000E-04  +4.11020000E-04  +8.97730000E-04
   +2.76454000E-03  -4.80990000E-04  -9.17630000E-04  -2.07130000E-03  -3.94119000E-02
   -8.74892000E-03  +1.69918000E-03  +2.93700000E-05  -1.09000000E-05  -3.95610000E-04
   +4.53310000E-04  +4.06340000E-04  +3.45630000E-04  -8.05080000E-04  +5.94800000E-04
   -1.24327000E-03  -5.41800000E-04  -9.60100000E-04  -4.16397700E-02  +7.09226800E-02
   +3.55738400E-02  +1.84610000E-04  -8.96600000E-05  +1.98080000E-04  -2.31440000E-04
   +4.00990000E-04  -2.89250000E-04  -4.30200000E-05  -1.85200000E-05  +1.30900000E-05
   +3.24600000E-05  +1.19300000E-05  -1.71400000E-05  -2.39200000E-05  -1.65700000E-05
   +1.53600000E-05  -3.01200000E-05  -5.02800000E-05  -5.22500000E-05  +1.26600000E-05
   +1.56100000E-05  +9.52000000E-06  +9.48800000E-05  -2.45000000E-05  +1.04900000E-05
   -2.65000000E-05  +1.20150000E-04  -4.38900000E-05  -3.54900000E-05  +7.28000000E-06
   -1.56400000E-05  +1.05500000E-05  +3.33300000E-05  -3.69100000E-05  -1.80700000E-05
   +9.63700000E-05  +4.26600000E-05  +7.10800000E-05  -1.03090000E-04  -7.96900000E-05
   -5.71300000E-05  +1.10430000E-04  -1.83600000E-04  -1.27030000E-04  +2.72400000E-05
   -1.88300000E-05  -4.76738000E-03  -3.78455000E-03  +2.58415000E-03  -8.19320000E-04
   +9.24600000E-05  -9.90130000E-04  +3.32470000E-04  +1.72495000E-03  +7.21290000E-04
   +4.65624200E-02  -2.43100000E-05  +1.03300000E-05  +2.57200000E-05  -6.11500000E-05
   +1.30000000E-07  +6.48000000E-06  -6.42000000E-06  -2.84000000E-06  +7.40000000E-07
   +5.31000000E-06  -2.17000000E-06  +7.71000000E-06  -4.50400000E-05  -1.46400000E-05
   +6.70000000E-06  +2.02800000E-05  -1.70400000E-05  -1.07300000E-05  -3.55440000E-04
   -3.69630000E-04  -3.44180000E-04  +1.28440000E-04  +5.10700000E-05  -2.34700000E-05
   +4.31000000E-05  +1.91800000E-05  -1.26000000E-06  +6.51240000E-04  -1.94670000E-04
   +7.02900000E-05  +8.67140000E-04  +3.02692000E-03  -9.89110000E-04  +1.94342000E-03
   -2.15301200E-02  -6.61513000E-03  -2.94850000E-04  -2.00890000E-04  +5.86320000E-04
   +7.77300000E-05  +3.49400000E-05  -5.98030000E-04  -2.67150000E-04  +2.56050000E-04
   +1.09390000E-04  +1.22960000E-03  +4.99960000E-04  -2.80240000E-04  +2.78552500E-02
   -4.86020620E-01  -1.21777800E-01  +2.81780000E-04  -3.30700000E-05  +3.20000000E-05
   +3.27210000E-04  +1.78110000E-04  -2.27700000E-05  -1.06600000E-05  -2.00000000E-08
   -1.50000000E-06  +2.29000000E-06  +1.80000000E-06  -4.49000000E-06  -3.06000000E-06
   +4.54000000E-06  -6.81000000E-06  -8.47000000E-06  -2.91000000E-06  -2.02100000E-05
   -4.42000000E-06  +2.55000000E-06  -2.92000000E-06  +1.02100000E-05  -3.51900000E-05
   +9.63000000E-06  -1.52300000E-05  -1.58300000E-05  +1.90100000E-05  -3.47800000E-05
   -1.84800000E-05  -1.39700000E-05  -3.12500000E-05  +6.59000000E-06  +2.20800000E-05
   -2.67100000E-05  -2.51000000E-06  +4.25000000E-06  +1.26000000E-05  -7.39200000E-05
   -3.79600000E-05  +7.54700000E-05  -4.18300000E-05  -5.70000000E-07  +1.46330000E-04
   -3.16100000E-05  -1.45490000E-04  -3.18937000E-03  -1.58990000E-04  +2.50684000E-03
   -4.90020000E-04  +3.40840000E-04  +1.78270000E-04  +4.64030000E-04  -1.69136000E-03
   +9.24700000E-04  -2.91971600E-02  +5.06087510E-01  -1.27200000E-05  +2.86800000E-05
   +1.34000000E-05  -2.69300000E-05  -3.59500000E-05  -7.20600000E-05  +9.40000000E-07
   +2.35700000E-05  +6.00000000E-08  +1.45500000E-05  +1.42200000E-05  -1.12100000E-05
   +2.33000000E-06  -1.22800000E-05  -2.50000000E-07  -4.03000000E-06  +2.32000000E-06
   -1.68700000E-05  +6.11200000E-05  -2.00000000E-06  -3.16200000E-05  -7.77600000E-05
   -7.48400000E-05  +1.22100000E-05  +9.21000000E-06  +1.24300000E-05  -9.58000000E-06
   +1.05650000E-04  -3.90000000E-07  -4.63230000E-04  +1.93630000E-04  -5.16090000E-04
   +9.71380000E-04  +1.13810000E-03  +1.66386200E-02  +1.94953000E-03  +1.82050000E-03
   +2.18858000E-03  +9.67530000E-04  -1.98630000E-04  -3.74020000E-04  -4.09490000E-04
   +6.38060000E-04  -2.13470000E-04  +3.35840000E-04  -1.01542000E-03  -5.60070000E-04
   -1.42822000E-03  +2.64506300E-02  -1.46111110E-01  -5.21219000E-02  +6.84700000E-05
   +4.23200000E-05  +5.73000000E-06  -4.65420000E-04  -8.24100000E-05  -2.59850000E-04
   +3.32000000E-06  -3.70000000E-06  +6.72000000E-06  +7.76000000E-06  -1.61000000E-06
   +2.80000000E-06  +7.67000000E-06  -1.09800000E-05  +1.97000000E-06  +5.44000000E-06
   -2.28100000E-05  +9.30000000E-06  +2.56000000E-06  -4.06000000E-06  +6.71000000E-06
   +4.80700000E-05  +2.05400000E-05  -3.02400000E-05  +2.65000000E-06  +1.09190000E-04
   +3.39900000E-05  -3.89800000E-05  -3.61100000E-05  -2.83200000E-05  +4.01700000E-05
   +4.60000000E-06  -5.99400000E-05  +1.33100000E-05  -3.73700000E-05  +7.05100000E-05
   -2.75100000E-05  -2.38600000E-05  -2.77800000E-05  -7.18200000E-05  +5.25200000E-05
   -8.55100000E-05  -3.04800000E-05  -4.30700000E-05  -6.11700000E-05  +6.55690000E-04
   +5.26510000E-04  +2.12140000E-04  -7.94860000E-04  +1.02310000E-04  -4.80750000E-04
   -2.65150000E-04  +1.93298000E-03  +8.65040000E-04  -2.84039400E-02  +1.26366430E-01
   +5.01493200E-02  -2.29880000E-04  +1.03910000E-04  -2.06160000E-04  -3.20560000E-04
   +3.03350000E-04  -8.54300000E-05  +4.97680000E-04  +1.08730000E-04  -1.99550000E-04
   -3.02690000E-04  -3.74130000E-04  +1.10840000E-04  -1.05050000E-04  +2.07970000E-04
   +2.60250000E-04  +2.58840000E-04  +4.31900000E-05  -1.20020000E-04  -1.37730000E-04
   -2.68630000E-04  +4.09120000E-04  +4.77700000E-05  -3.86200000E-05  +2.83000000E-06
   -7.22900000E-05  -1.40950000E-04  +4.59600000E-05  -1.42719000E-03  -3.70995000E-03
   -6.83530000E-04  +1.39030000E-04  -6.78050000E-04  +5.04930000E-04  +3.56290000E-04
   -1.02994000E-03  +6.34070000E-04  -2.58598000E-03  +9.42520000E-04  +7.59280000E-04
   +1.68844000E-03  +7.60950000E-04  +2.58860000E-04  +1.44286000E-03  -1.53430700E-02
   +1.26158200E-02  +1.63412000E-03  -4.52110000E-04  -9.00000000E-05  -2.19150000E-04
   +4.84190000E-04  -5.10000000E-04  -1.24330000E-04  +1.13500000E-04  -1.23800000E-04
   -3.21461600E-02  +6.74493700E-02  -1.02102820E-01  -5.07000000E-05  +3.49300000E-05
   -4.20000000E-05  -5.08600000E-05  +2.74100000E-05  -2.69100000E-05  -3.47000000E-06
   +4.39800000E-05  -1.01800000E-05  -2.05500000E-05  +6.80000000E-06  +1.50040000E-04
   -2.83300000E-05  +1.00300000E-05  -6.78900000E-05  +8.57000000E-06  +1.16800000E-05
   +2.66800000E-05  -1.20200000E-05  -1.21200000E-05  -2.27000000E-06  +9.53000000E-06
   -3.67000000E-06  +4.91000000E-06  +1.69700000E-05  +3.31100000E-05  +1.05100000E-05
   -1.75500000E-05  -2.52000000E-05  +3.10200000E-05  +4.10000000E-06  +3.41500000E-05
   +2.70900000E-05  +1.26660000E-04  +6.01610000E-04  -4.84360000E-04  +1.09140000E-04
   -5.51160000E-04  -5.74620000E-04  -1.00120000E-04  +1.33730000E-04  -1.30750000E-04
   -3.72800000E-05  +3.71510000E-04  +2.04890000E-04  -1.18710000E-04  -1.81500000E-05
   +3.33250000E-04  +1.49150000E-04  -7.59500000E-05  +1.43810000E-04  +3.16214600E-02
   +2.08810000E-04  -7.24000000E-05  -5.10000000E-06  +6.30700000E-05  +6.20200000E-05
   -1.78100000E-05  -3.41200000E-05  -3.63000000E-06  -6.66100000E-05  +1.08000000E-05
   +2.75000000E-05  -4.27500000E-05  +2.42140000E-04  +1.32280000E-04  -1.46700000E-05
   -1.12460000E-04  -9.72000000E-06  +8.46300000E-05  -1.38800000E-04  -2.89000000E-06
   +3.29130000E-04  +7.13500000E-05  +7.55000000E-06  +7.77000000E-06  -2.01990000E-04
   -1.82420000E-04  +3.22500000E-05  -2.75039000E-03  -5.22277000E-03  -2.16189000E-03
   +7.83780000E-04  -6.09980000E-04  -1.43230000E-04  -1.71710000E-04  -1.82020000E-04
   +3.67790000E-04  -2.36822000E-03  +9.82230000E-04  +7.38220000E-04  +1.00228000E-03
   +2.46921000E-03  -1.38789000E-03  +6.25613000E-03  -2.71742800E-02  +2.97988700E-02
   +2.08949000E-03  -9.55230000E-04  -5.26700000E-05  -9.22700000E-05  +2.84260000E-04
   -4.57890000E-04  -1.08630000E-04  +8.32300000E-05  +1.13710000E-04  +4.41775100E-02
   -2.28088190E-01  +2.14578460E-01  +2.10700000E-05  +3.42500000E-05  -1.20200000E-05
   -7.66000000E-06  -1.96000000E-06  +1.01300000E-05  +2.73000000E-05  -3.75900000E-05
   +6.71000000E-06  -2.22700000E-05  +3.21500000E-05  +7.62800000E-05  -3.41500000E-05
   +4.16000000E-06  -5.55200000E-05  +1.83300000E-05  +1.33700000E-05  +1.94000000E-05
   +7.10000000E-07  +2.11600000E-05  -1.95500000E-05  +2.77000000E-06  -1.81000000E-05
   -5.99000000E-06  +3.93600000E-05  -4.93000000E-05  -7.30200000E-05  +1.63600000E-05
   +1.11000000E-06  -9.02000000E-06  -2.21300000E-05  +3.89600000E-05  -3.28000000E-05
   +7.91140000E-04  -6.45700000E-05  +5.51400000E-05  -6.68550000E-04  -2.01310000E-04
   -1.85880000E-04  -3.94600000E-05  +4.14200000E-05  -1.68140000E-04  +1.07200000E-04
   +5.48540000E-04  +2.33600000E-04  -1.11280000E-04  +1.56200000E-05  +2.82390000E-04
   +5.94200000E-05  -6.21900000E-05  +1.00380000E-04  -4.91049300E-02  +2.58139530E-01
   -1.49200000E-05  +4.83600000E-05  -1.30930000E-04  -1.05460000E-04  -1.11430000E-04
   -4.80000000E-05  +4.59100000E-05  -3.51600000E-05  -6.12900000E-05  -5.61300000E-05
   -7.00000000E-08  -8.85000000E-06  -1.04800000E-05  +4.74200000E-05  +8.97500000E-05
   +8.09700000E-05  +7.32100000E-05  +7.71000000E-06  +8.14600000E-05  -7.07800000E-05
   -3.01700000E-05  +7.40800000E-05  -2.21400000E-05  +2.90000000E-05  -6.59000000E-06
   -1.38400000E-05  -1.55200000E-05  +1.70100000E-04  +3.12500000E-05  -9.47720000E-04
   -3.27980000E-04  +4.45840000E-04  +8.63790000E-04  +4.16900000E-05  -1.67470000E-04
   -1.99280000E-04  +1.51100000E-05  -1.53700000E-05  -6.77810000E-04  -6.89700000E-05
   -1.61998000E-03  +2.14844000E-03  -6.02420000E-04  -1.40880700E-02  +6.18290000E-03
   -3.99180000E-04  +3.29140000E-04  +8.28500000E-05  +9.09000000E-06  -1.57220000E-04
   +1.03820000E-04  +9.30900000E-05  -5.58500000E-05  +3.15700000E-05  -8.79448300E-02
   +2.58707150E-01  -3.21200450E-01  +1.10200000E-05  +1.60000000E-07  +1.66200000E-05
   +1.51000000E-05  -9.91000000E-06  +6.00000000E-07  -7.73000000E-06  -2.06300000E-05
   +2.19300000E-05  +4.80000000E-06  +1.24400000E-05  +1.68990000E-04  -3.12400000E-05
   +2.27000000E-06  -3.67600000E-05  +1.98000000E-06  -1.22300000E-05  +2.66200000E-05
   +1.36300000E-05  +1.38600000E-05  -5.31000000E-06  -7.70000000E-06  -4.82000000E-06
   +1.13900000E-05  -2.27900000E-05  +1.44400000E-05  +6.49500000E-05  -1.12600000E-05
   +6.69000000E-06  -3.77000000E-06  -1.66900000E-05  -4.29300000E-05  +2.82600000E-05
   -4.40900000E-05  -1.37879000E-03  -8.10900000E-05  +7.15800000E-05  -3.49800000E-05
   -6.84160000E-04  +5.34500000E-05  -9.49000000E-06  -1.85250000E-04  -1.03600000E-05
   -9.81000000E-06  +8.20200000E-05  +1.85800000E-05  +5.11200000E-05  -3.33900000E-05
   -3.89500000E-05  +2.00700000E-05  -1.62000000E-05  +8.89261300E-02  -2.41922420E-01
   +3.14404730E-01
end_hess

