# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.18166200    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.42523076E+00  -7.34571893E-01  +1.81316951E+00
   006   +2.04878153E+00  +1.14512895E+00  -2.25244021E-02
   006   +4.01080357E+00  +1.37690286E+00  -1.78636947E+00
   006   +6.13469757E+00  -1.77049233E-01  -1.76994346E+00
   006   +6.38822038E+00  -2.02565443E+00  +4.89162500E-02
   006   +4.52785173E+00  -2.30709217E+00  +1.86490979E+00
   006   -3.84097573E-01  +2.74787818E+00  +9.01105576E-02
   006   -2.44435687E-01  +4.44215831E+00  +2.44921023E+00
   008   +8.48846372E+00  -3.49242366E+00  -2.00879470E-02
   006   -2.68581142E+00  +9.82460985E-01  +9.91795558E-02
   006   -2.84566881E+00  -9.42250111E-01  -1.68109462E+00
   006   -4.93593409E+00  -2.50912028E+00  -1.83081230E+00
   006   -6.94621505E+00  -2.16882758E+00  -1.79769521E-01
   006   -6.83087598E+00  -2.54751748E-01  +1.60379753E+00
   006   -4.72205471E+00  +1.29189724E+00  +1.72691495E+00
   008   -9.05045035E+00  -3.65023915E+00  -2.28045209E-01
   006   -8.07766378E-01  +4.53171773E+00  -2.17517913E+00
   008   +6.31467043E-01  -1.00686427E+00  +3.62304826E+00
   001   -8.89576260E+00  -4.87141240E+00  -1.55183199E+00
   001   -4.99933211E+00  -3.99968389E+00  -3.23592953E+00
   001   -1.29032206E+00  -1.24528182E+00  -2.97684116E+00
   001   -4.67940678E+00  +2.75083555E+00  +3.15582605E+00
   001   -8.39744795E+00  +2.33269242E-03  +2.89102339E+00
   001   -2.65586969E+00  +5.41223303E+00  -1.93301105E+00
   001   +6.15375455E-01  +6.01063224E+00  -2.26548455E+00
   001   -8.15471000E-01  +3.52612039E+00  -3.96690158E+00
   001   -1.99140963E-01  +3.35211110E+00  +4.19043455E+00
   001   +1.46569603E+00  +5.58650275E+00  +2.34983112E+00
   001   -1.84947186E+00  +5.73417505E+00  +2.52011649E+00
   001   +7.60373540E+00  +5.36769738E-02  -3.17486502E+00
   001   +4.70521283E+00  -3.72683413E+00  +3.33244592E+00
   001   +8.44168805E+00  -4.68954465E+00  +1.33371046E+00
   001   +1.01649901E+00  -2.43917315E+00  +4.65466260E+00
   008   +3.87125983E+00  +3.18337169E+00  -3.60555514E+00
   001   +5.34542839E+00  +3.07687180E+00  -4.64560698E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.70000000E-07  +0.00000000E+00  -3.40000000E-07
   +2.00000000E-08  -1.80000000E-07  -5.30000000E-07
   -1.10000000E-07  -8.40000000E-07  -3.50000000E-07
   -2.00000000E-07  -8.30000000E-07  -6.90000000E-07
   -3.40000000E-07  -6.60000000E-07  -6.10000000E-07
   -1.60000000E-07  -3.50000000E-07  -2.90000000E-07
   +5.70000000E-07  +0.00000000E+00  -2.20000000E-07
   +6.50000000E-07  +4.00000000E-07  -9.00000000E-07
   -5.10000000E-07  -1.29000000E-06  -9.20000000E-07
   -2.90000000E-07  +4.10000000E-07  +2.70000000E-07
   -4.10000000E-07  -3.00000000E-08  +6.70000000E-07
   -6.70000000E-07  +2.00000000E-07  +1.25000000E-06
   -9.00000000E-08  +7.50000000E-07  +1.33000000E-06
   +2.50000000E-07  +9.90000000E-07  +1.08000000E-06
   +4.10000000E-07  +7.80000000E-07  +4.70000000E-07
   -5.60000000E-07  +9.30000000E-07  +2.09000000E-06
   +1.50000000E-07  -2.10000000E-07  -7.90000000E-07
   +2.40000000E-07  +3.70000000E-07  +1.20000000E-07
   -8.40000000E-07  +6.70000000E-07  +2.21000000E-06
   -9.70000000E-07  +6.00000000E-08  +1.56000000E-06
   -6.60000000E-07  -3.80000000E-07  +5.10000000E-07
   +7.90000000E-07  +1.03000000E-06  +3.60000000E-07
   +3.30000000E-07  +1.39000000E-06  +1.40000000E-06
   +2.80000000E-07  -7.00000000E-08  -4.40000000E-07
   +2.30000000E-07  -4.60000000E-07  -1.00000000E-06
   -2.40000000E-07  -6.30000000E-07  -3.50000000E-07
   +9.50000000E-07  +5.50000000E-07  -4.10000000E-07
   +9.60000000E-07  +2.50000000E-07  -1.16000000E-06
   +9.70000000E-07  +5.60000000E-07  -6.10000000E-07
   -5.40000000E-07  -1.42000000E-06  -1.16000000E-06
   +8.00000000E-08  -3.00000000E-08  -8.00000000E-08
   -2.60000000E-07  -5.20000000E-07  -3.00000000E-07
   +4.70000000E-07  +7.50000000E-07  +3.50000000E-07
   -4.60000000E-07  -7.40000000E-07  -1.22000000E-06
   -3.40000000E-07  -1.45000000E-06  -1.31000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.84165750E-01  -1.74776710E-01  +4.79980520E-01  -1.38787050E-01  -2.00625280E-01
   +5.09907480E-01  -1.21196480E-01  +6.82622000E-02  -3.44167300E-02  +5.33207450E-01
   +2.49907600E-02  -1.89036540E-01  +1.12220980E-01  -1.23259620E-01  +4.21157160E-01
   +1.12681500E-02  +7.83422700E-02  -1.70695020E-01  -1.47011590E-01  -1.82074070E-01
   +4.86928560E-01  +4.42232000E-02  -7.24937100E-02  +4.22093500E-02  -2.23423330E-01
   +4.11297800E-02  +7.60743300E-02  +5.87314170E-01  -3.33720800E-02  +1.32110100E-02
   +9.39772000E-03  -3.72870000E-04  -1.01019780E-01  +4.07270900E-02  -1.55400480E-01
   +4.67442680E-01  +2.63700000E-04  +4.05690300E-02  -4.65664000E-02  +1.22491870E-01
   +6.75187000E-03  -1.68202980E-01  -1.54990490E-01  -1.99274530E-01  +5.06487110E-01
   -1.82796000E-02  +2.89580600E-02  -1.72909000E-02  -3.40986100E-02  -3.59455000E-03
   +3.76952100E-02  -2.47246950E-01  +1.31356330E-01  +3.19970000E-04  +5.89113840E-01
   +2.98898900E-02  -4.32762300E-02  +2.38993700E-02  +2.17399400E-02  +3.01278400E-02
   -4.16777000E-02  +8.25060500E-02  -1.58751180E-01  +3.68095800E-02  -1.77680490E-01
   +4.69138160E-01  -1.84611300E-02  +2.52801500E-02  -1.26593900E-02  +8.68383000E-03
   -2.13216600E-02  +2.50491700E-02  +5.47949400E-02  -1.73205000E-03  -1.06489410E-01
   -1.86059680E-01  -2.52829140E-01  +5.29256550E-01  -4.91647100E-02  +2.76721600E-02
   +6.98397000E-03  -6.17680000E-03  -1.45230200E-02  +2.19941700E-02  +2.51750600E-02
   +1.09952900E-02  -3.43823700E-02  -1.13471260E-01  +4.44557100E-02  -1.23332400E-02
   +5.90008710E-01  -1.09216200E-02  +3.76751600E-02  -3.59589100E-02  -1.45434600E-02
   -1.63186000E-02  +3.03337500E-02  +5.17031900E-02  -3.73846800E-02  -3.73297000E-03
   -1.00187000E-03  -2.06631740E-01  +1.52953020E-01  -1.69445770E-01  +5.00596060E-01
   +4.97259400E-02  -6.70205600E-02  +3.15825400E-02  +2.15987100E-02  +3.06151600E-02
   -5.03774200E-02  -7.97346200E-02  +2.82803700E-02  +2.80515200E-02  +3.78780700E-02
   +1.17900670E-01  -2.24526710E-01  -1.54109800E-01  -2.32527360E-01  +5.45426670E-01
   -2.30964360E-01  +9.24179900E-02  +3.09637000E-02  +1.89663900E-02  +3.94169500E-02
   -5.18701400E-02  -5.93639500E-02  +1.87140900E-02  +2.60327100E-02  +3.35759400E-02
   -4.69314100E-02  +3.49751800E-02  -2.10946830E-01  +2.12852400E-02  +9.40150300E-02
   +5.73655760E-01  +1.40202450E-01  -1.80891520E-01  +1.67689500E-02  +1.18964100E-02
   -2.08444100E-02  +2.36905600E-02  +1.80008900E-02  -4.02199000E-03  -9.35291000E-03
   -1.88504400E-02  +1.31807200E-02  +1.28485200E-02  -2.46285200E-02  -1.07912630E-01
   +6.88483200E-02  -1.84085500E-01  +4.59872900E-01  -2.17475700E-02  +5.40467500E-02
   -1.06386640E-01  -2.20494800E-02  +2.60138000E-03  +2.35778700E-02  +2.74436900E-02
   -1.03876900E-02  -1.04311100E-02  +3.77601000E-03  +3.52201800E-02  -3.07148300E-02
   +1.46405090E-01  +3.24417000E-02  -2.17785460E-01  -1.75154090E-01  -2.51091150E-01
   +5.29570000E-01  -1.29032000E-03  +1.04436500E-02  -9.40924000E-03  -1.30686860E-01
   +3.83657400E-02  +9.10432000E-03  -1.63636900E-02  +8.54823000E-03  +4.77544000E-03
   +1.49704000E-03  +1.03700000E-04  +2.87621000E-03  -1.74333000E-03  +3.05390000E-04
   +2.88600000E-04  +2.63056000E-03  -3.07250000E-04  +1.72437000E-03  +4.57713600E-01
   +2.02184500E-02  -1.46167600E-02  +3.58954000E-03  +3.79475800E-02  -9.97332300E-02
   +7.86793000E-03  -1.42967000E-03  +7.79725000E-03  -6.19468000E-03  -3.45320000E-04
   +2.56080000E-03  +3.81110000E-03  +1.87840000E-04  -1.30823000E-03  +1.66940000E-04
   -1.62800000E-05  +7.34030000E-04  +3.73756000E-03  -7.70350000E-04  +4.71294750E-01
   -1.96465500E-02  +1.20187700E-02  +5.47353000E-03  +8.23872000E-03  +8.39328000E-03
   -8.17728900E-02  +1.52621900E-02  -1.47163000E-02  +4.97855000E-03  +2.94041000E-03
   +2.89283000E-03  -2.44440000E-04  +2.17900000E-05  +2.01190000E-04  -1.18305000E-03
   +1.73558000E-03  +4.66692000E-03  -2.23400000E-03  +6.06951000E-03  +5.20976000E-03
   +4.68570660E-01  -7.49560000E-04  -2.10930000E-04  +1.47153000E-03  -4.47490000E-03
   +1.81365800E-02  +2.31798800E-02  -6.89820000E-04  +4.17531000E-03  -2.34407000E-03
   -9.52580000E-04  -5.15140000E-04  -7.04290000E-04  +6.91080000E-04  -4.42410000E-04
   +1.50500000E-04  -6.59540000E-04  -7.97250000E-04  +3.43300000E-05  -7.57829900E-02
   -1.84979000E-03  -9.24820000E-04  +5.82714910E-01  +4.99020000E-04  -4.56760000E-04
   -1.42230000E-03  +7.53412000E-03  -1.65390200E-02  -1.65226600E-02  -8.81180000E-04
   -1.65791000E-03  +1.37794000E-03  +3.86550000E-04  +9.76700000E-05  +6.28630000E-04
   -2.40080000E-04  +2.91750000E-04  -2.19360000E-04  +4.12680000E-04  +8.00730000E-04
   -4.91700000E-05  -4.89116000E-03  -1.06334610E-01  -4.70695400E-02  -4.77239000E-03
   +5.40355370E-01  -2.43092000E-03  +1.07706000E-03  +2.16862000E-03  +6.54830000E-03
   -7.17914000E-03  -2.58997000E-03  -7.20720000E-04  +9.55600000E-04  -1.08423000E-03
   -1.84200000E-05  +1.53120000E-04  -1.22190000E-04  +2.51200000E-05  -3.07530000E-04
   +3.09680000E-04  +5.87110000E-04  -9.64100000E-05  -2.56840000E-04  -5.57041000E-03
   -4.30393300E-02  -1.39153700E-01  -6.78286000E-03  -7.05819200E-02  +5.18652630E-01
   +4.61602000E-03  -2.70055000E-03  +5.73075000E-03  -2.33369000E-03  +2.59422000E-03
   -2.47610000E-03  +6.99260000E-04  -7.47180000E-04  +4.01400000E-03  -6.77493000E-03
   +1.84790700E-02  -8.29243000E-03  -2.38168840E-01  +1.00433610E-01  +4.38596900E-02
   -3.98837900E-02  +3.16186000E-02  +5.42524000E-03  +1.58745000E-03  -8.57040000E-04
   +4.70450000E-04  -1.13399000E-03  +4.53760000E-04  -4.22430000E-04  +3.20452760E-01
   +2.91676000E-03  +3.49250000E-04  +5.90747000E-03  +2.67953000E-03  -4.77750000E-04
   -3.21859000E-03  -5.70709000E-03  +3.62869000E-03  +5.92181000E-03  +4.11831000E-02
   -2.89557600E-02  +7.96522000E-03  +1.32186220E-01  -1.49682010E-01  +8.93564000E-03
   +8.88121000E-03  +4.82338000E-03  -4.12670000E-04  -1.25193000E-03  +6.03270000E-04
   -7.49330000E-04  +9.40330000E-04  -4.23470000E-04  +3.53850000E-04  -1.60389910E-01
   +4.09281730E-01  -6.29020000E-04  +1.05907900E-02  -3.47434000E-03  -2.34268000E-03
   -3.35624000E-03  +3.96844000E-03  +9.49633000E-03  +2.03915000E-03  -4.69806000E-03
   -3.32077700E-02  +2.58001400E-02  +6.27343000E-03  +8.95210000E-03  +3.43576000E-02
   -9.03239400E-02  +3.11659000E-02  -1.88105900E-02  +6.55870000E-03  -1.49330000E-04
   -2.76900000E-04  +1.57210000E-04  -3.88000000E-05  +2.94800000E-05  -7.97700000E-05
   -5.81983900E-02  -2.91032170E-01  +3.94244760E-01  -5.52030000E-04  -2.05970000E-04
   -3.07760000E-04  -3.40058300E-02  -1.04633900E-02  +4.37642000E-03  -1.66025000E-03
   +1.12589000E-03  -2.50653000E-03  +1.44050000E-04  +5.19250000E-04  +5.55760000E-04
   -1.26760000E-04  -2.37970000E-04  +2.55570000E-04  +3.93390000E-04  -4.00040000E-04
   +8.13160000E-04  -1.35650190E-01  -4.47816100E-02  +5.24838000E-03  -1.46784000E-03
   -5.60066000E-03  -4.54246000E-03  -8.46900000E-05  +2.84500000E-05  -1.04390000E-04
   +5.56514220E-01  +2.91064000E-03  +1.00001000E-03  -1.75742000E-03  +9.21628000E-03
   +1.15994100E-02  -1.50884000E-03  +1.33314000E-03  -2.96794000E-03  +2.07642000E-03
   +4.02410000E-04  -6.23440000E-04  -6.10010000E-04  -4.85320000E-04  +8.38890000E-04
   -2.48140000E-04  -2.64860000E-04  -2.62920000E-04  -1.15600000E-05  -4.31991400E-02
   -1.09840500E-01  -1.15175500E-02  -1.58165900E-02  -1.51425600E-02  -1.16449000E-03
   +9.60120000E-04  -7.95960000E-04  +1.06270000E-04  +1.03617050E-01  +4.67548450E-01
   -7.73330000E-04  +5.18300000E-04  -3.95980000E-04  +4.60969000E-03  +2.30175000E-03
   -7.81000000E-04  +2.39940000E-04  -3.08070000E-04  -6.80000000E-07  +3.70810000E-04
   -3.33610000E-04  -2.05450000E-04  +4.08800000E-05  +2.96580000E-04  -2.96070000E-04
   -1.02460000E-04  +4.52000000E-06  +2.27410000E-04  +7.20589000E-03  -9.44627000E-03
   -8.03324400E-02  -2.27979800E-02  -1.79815800E-02  +9.66310000E-04  +2.98900000E-05
   -6.54700000E-05  +4.37400000E-05  -1.45501190E-01  +1.90323520E-01  +4.74510980E-01
   -5.31420000E-04  -3.86100000E-04  -7.74440000E-04  -9.58860000E-04  -2.34005000E-03
   -1.69758000E-03  +3.47150000E-04  -1.87480000E-04  -1.30975000E-03  -2.74800000E-05
   +3.41570000E-04  +8.60200000E-05  +3.98500000E-05  -5.41900000E-05  +7.30000000E-05
   +2.50690000E-04  -3.13800000E-05  +8.64900000E-05  -1.68811000E-03  -2.07396200E-02
   -1.90353700E-02  -4.64565000E-03  -3.12810000E-03  +1.26498000E-03  -1.71410000E-04
   +1.17400000E-04  -1.55000000E-06  -1.19709320E-01  +1.07416000E-03  +3.33709300E-02
   +6.31880510E-01  -1.12525000E-03  -8.21450000E-04  +1.49539000E-03  +2.52490000E-04
   -3.05660000E-04  -1.25286000E-03  +3.63430000E-04  -1.16560000E-04  +6.46800000E-05
   +3.85200000E-05  +5.29300000E-05  -2.09430000E-04  +5.86100000E-05  -1.54770000E-04
   +8.38300000E-05  +1.41970000E-04  +9.14400000E-05  -1.77210000E-04  -7.37054000E-03
   -1.61782300E-02  -1.19188300E-02  -2.34254000E-03  -5.25020000E-04  +8.47680000E-04
   -1.17080000E-04  +1.29270000E-04  -4.18000000E-05  -4.70164600E-02  -2.07620850E-01
   -1.04595320E-01  +1.46847320E-01  +4.68788890E-01  -1.14700000E-03  -9.56930000E-04
   +6.82600000E-04  -6.02400000E-04  -8.08720000E-04  -5.87470000E-04  +6.05160000E-04
   +1.71950000E-04  -3.77560000E-04  +2.06600000E-05  -9.61400000E-05  -2.66770000E-04
   +2.41880000E-04  -1.10330000E-04  +1.60450000E-04  +2.00730000E-04  -2.06600000E-04
   -8.15400000E-05  -5.35882000E-03  -1.88060000E-03  +3.84589000E-03  +1.02301000E-03
   +5.04300000E-04  -1.05450000E-04  -1.72980000E-04  +1.09020000E-04  -5.31700000E-05
   -1.27844500E-02  -1.34537130E-01  -1.93194290E-01  -1.76301630E-01  +2.19595990E-01
   +4.71873730E-01  +1.89460000E-04  -1.28760000E-04  +2.46000000E-05  +1.10770000E-04
   -3.98500000E-05  -3.01880000E-04  -9.99800000E-05  +3.23620000E-04  +5.69000000E-06
   +4.24200000E-05  -1.57360000E-04  +7.29200000E-05  +2.63860000E-04  -8.75000000E-06
   -1.90340000E-04  -3.63440000E-04  +1.71910000E-04  +1.84460000E-04  +3.72944000E-03
   +3.10210000E-04  +1.71253000E-03  +4.51260000E-04  +3.28840000E-04  +4.63590000E-04
   -2.04860000E-04  +1.33450000E-04  +1.71900000E-05  +2.81031700E-02  -5.05476200E-02
   -6.24736800E-02  -2.59674820E-01  -1.03076650E-01  +3.22409000E-02  +5.89923870E-01
   -7.20300000E-05  +1.26090000E-04  +9.80000000E-07  +7.12900000E-04  +3.68400000E-05
   +4.13090000E-04  -3.34870000E-04  +1.02380000E-04  +3.65880000E-04  -3.02900000E-05
   -5.86300000E-05  +8.37300000E-05  -1.74630000E-04  +8.98100000E-05  -2.75400000E-05
   -7.03800000E-05  +1.06410000E-04  -4.13600000E-05  +4.10910000E-04  +6.85950000E-04
   -5.71284000E-03  -1.10717000E-03  -6.03650000E-04  +3.26100000E-04  +1.69060000E-04
   -9.67800000E-05  +1.92200000E-05  -1.33812900E-02  -3.04660800E-02  -2.77104000E-02
   -1.49147750E-01  -1.80625580E-01  -2.10804000E-02  +1.61977530E-01  +4.99795730E-01
   -1.12480000E-04  +3.03610000E-04  -3.55170000E-04  +6.57300000E-04  +2.20270000E-04
   +2.69010000E-04  -1.27790000E-04  -5.56800000E-05  -6.85900000E-05  +6.83000000E-06
   +1.75100000E-05  +3.54400000E-05  -2.35030000E-04  +1.13220000E-04  +2.20300000E-05
   +1.93230000E-04  -8.69300000E-05  -4.77900000E-05  +1.75435000E-03  -4.12621000E-03
   -1.10009000E-03  -6.77770000E-04  -6.11220000E-04  +1.47500000E-04  +2.08030000E-04
   -1.70470000E-04  +5.32000000E-06  -2.66730300E-02  -3.94841000E-03  +2.14618700E-02
   -1.27791200E-02  -5.11739500E-02  -1.00128480E-01  -1.48536970E-01  +2.57963480E-01
   +4.72611120E-01  -9.90980000E-04  -9.68800000E-05  +4.85200000E-04  +3.76400000E-05
   +4.34810000E-04  -1.08620000E-04  -2.51480000E-04  -3.56170000E-04  +4.50610000E-04
   +2.39610000E-04  -1.12460000E-04  -6.49800000E-05  -7.19880000E-04  +4.02960000E-04
   +1.33820000E-04  +5.50700000E-04  -1.25650000E-04  -2.48480000E-04  -2.28853000E-03
   -1.96040000E-04  +4.48600000E-05  +3.62850000E-04  -1.89840000E-04  -3.06640000E-04
   +7.37370000E-04  -5.27820000E-04  -5.25000000E-06  -1.32449700E-02  +2.27990200E-02
   +2.69918800E-02  -5.03311200E-02  -3.31292800E-02  +2.40228000E-03  -2.22218610E-01
   +3.62349700E-02  +1.36515120E-01  +6.02814490E-01  -3.25990000E-04  +1.70570000E-04
   -3.82200000E-05  +3.62080000E-04  +6.17740000E-04  -1.89560000E-04  -4.40920000E-04
   -2.37400000E-05  +6.35310000E-04  +2.64790000E-04  -3.75750000E-04  +7.32500000E-05
   -4.84150000E-04  +5.10480000E-04  -1.54750000E-04  +8.41600000E-05  -1.11900000E-05
   -4.35600000E-05  +3.44400000E-05  -6.77790000E-04  -9.52030000E-04  +3.03300000E-04
   +8.13900000E-05  +2.25100000E-05  +6.50830000E-04  -5.13320000E-04  +3.12700000E-05
   +2.20604100E-02  -2.49867400E-02  -3.26248800E-02  +6.54064000E-03  +4.05433000E-02
   +3.27637900E-02  -1.99936000E-02  -1.15704630E-01  -3.26136900E-02  +1.46391000E-01
   +5.03303240E-01  +7.56000000E-06  +1.60230000E-04  -1.47500000E-05  +4.05000000E-04
   +3.31890000E-04  -1.55720000E-04  -3.99040000E-04  +7.09700000E-05  +4.42950000E-04
   +1.28390000E-04  -2.56230000E-04  +9.47400000E-05  -4.51400000E-05  +2.21510000E-04
   -2.21840000E-04  -2.13030000E-04  +8.96200000E-05  +5.53200000E-05  +9.68990000E-04
   -2.48370000E-04  -1.36019000E-03  +1.08900000E-04  -7.46000000E-06  +3.17120000E-04
   +1.77070000E-04  -1.56830000E-04  +2.41100000E-05  +2.68876100E-02  -3.34716000E-02
   -5.52573600E-02  +4.09639300E-02  +5.85422400E-02  +3.26997300E-02  +8.19130200E-02
   -6.96453900E-02  -1.90079870E-01  -1.49226690E-01  +2.36430920E-01  +4.89298520E-01
   -4.07530000E-04  -3.24690000E-04  +8.29760000E-04  -4.64260000E-04  -4.05060000E-04
   -1.48100000E-05  +2.58830000E-04  +1.95700000E-05  -3.73810000E-04  -8.65500000E-05
   +2.16350000E-04  -1.07750000E-04  +7.36900000E-05  -2.40220000E-04  +2.21620000E-04
   +2.49940000E-04  -1.48370000E-04  -2.01950000E-04  +4.28080000E-04  +8.58680000E-04
   +3.95296000E-03  +1.37450000E-04  +5.34490000E-04  +9.80300000E-05  -1.86980000E-04
   +1.67150000E-04  -4.07300000E-05  -4.68755400E-02  +3.88640000E-03  +3.86367200E-02
   -1.87149000E-02  -2.68577700E-02  -1.59743800E-02  +3.44382200E-02  +2.40087600E-02
   +6.31802000E-03  -1.19201160E-01  +1.66335300E-02  +4.83093000E-02  +6.39021760E-01
   -2.63170000E-04  -4.81960000E-04  +6.14000000E-04  -6.72790000E-04  -5.10940000E-04
   +1.15180000E-04  +3.28240000E-04  -1.95500000E-05  -5.71840000E-04  -1.33960000E-04
   +3.27990000E-04  -1.31590000E-04  +1.55180000E-04  -3.67480000E-04  +2.40100000E-04
   +2.78080000E-04  -4.12200000E-05  -8.27200000E-05  -3.09050000E-04  +2.48034000E-03
   -2.64443000E-03  -4.25670000E-04  -5.66400000E-04  -1.01220000E-04  -3.46380000E-04
   +2.98820000E-04  -5.07500000E-05  -3.16596800E-02  +3.82561100E-02  +5.02464300E-02
   -2.61154900E-02  -4.64543500E-02  -2.51240000E-02  +5.71225100E-02  +1.38237300E-02
   -3.23602700E-02  -3.66948600E-02  -2.05189780E-01  -1.06194790E-01  +1.54290710E-01
   +4.71450700E-01  +4.61900000E-04  +1.31500000E-04  -5.18330000E-04  +8.54870000E-04
   +6.36140000E-04  -1.13960000E-04  +3.74190000E-04  -2.50180000E-04  -1.05000000E-06
   -9.73800000E-05  +8.60600000E-05  -9.03000000E-05  +7.88100000E-05  -9.84600000E-05
   +6.53300000E-05  -3.73400000E-05  -3.13000000E-05  +3.04000000E-06  +4.09457000E-03
   -4.19067000E-03  +8.67170000E-04  -5.52290000E-04  -6.59400000E-04  -1.67480000E-04
   -1.11960000E-04  +9.07600000E-05  +8.76000000E-06  +4.41337000E-03  +2.76757100E-02
   +3.00749800E-02  -1.51150800E-02  -2.44466200E-02  -1.69363900E-02  +3.83842500E-02
   -1.05944100E-02  -2.69876800E-02  -3.45769000E-03  -1.41519960E-01  -2.06044880E-01
   -1.85655130E-01  +2.31907870E-01  +4.77971640E-01  -5.01240000E-04  +1.76700000E-05
   +3.43600000E-04  -1.32406000E-03  -1.67856000E-03  +4.57340000E-04  -7.00030000E-04
   +7.37700000E-04  -2.31490000E-04  +4.30100000E-05  -1.27760000E-04  +3.19360000E-04
   +1.00920000E-04  +1.01040000E-04  -2.65800000E-04  -3.55030000E-04  +2.54540000E-04
   +1.95320000E-04  -1.87403800E-02  -6.65770000E-04  +1.29001500E-02  -8.73270000E-04
   -2.17460000E-04  +1.25161000E-03  -3.29700000E-05  +2.48800000E-05  +3.35100000E-05
   -2.34971070E-01  -2.32521800E-02  +8.80111200E-02  +3.56932000E-02  +6.21339900E-02
   +4.24748000E-02  -6.31207300E-02  -1.75776900E-02  +2.20551400E-02  +3.16656300E-02
   -5.30009100E-02  -7.10635700E-02  -2.61702660E-01  -1.01213420E-01  +3.41962300E-02
   +5.86118640E-01  -3.14980000E-04  -1.16740000E-04  +9.53110000E-04  -1.57588000E-03
   -1.95622000E-03  +6.19930000E-04  -4.40930000E-04  +5.68790000E-04  -3.83090000E-04
   -1.00140000E-04  +7.71700000E-05  +2.21680000E-04  +1.12460000E-04  -1.18020000E-04
   -2.23000000E-05  -1.07420000E-04  +6.59200000E-05  -1.18530000E-04  -1.41464300E-02
   +6.26173000E-03  +1.20754000E-02  -7.58270000E-04  -3.32350000E-04  +6.59710000E-04
   -1.45910000E-04  +1.38730000E-04  -3.47000000E-06  +2.37488600E-02  -1.10201930E-01
   -5.69212900E-02  +2.62452100E-02  +1.33274000E-02  -1.22497100E-02  -1.61457700E-02
   -8.22492000E-03  +6.20991000E-03  -1.31738700E-02  -3.37131500E-02  -2.63704500E-02
   -1.47284880E-01  -1.79996990E-01  -1.98801200E-02  +1.52288900E-01  +5.02334100E-01
   +1.67220000E-04  +5.30500000E-05  -5.29930000E-04  -2.16074000E-03  -1.30909000E-03
   +4.23990000E-04  +1.81700000E-05  +2.69420000E-04  -5.33850000E-04  -1.42100000E-04
   +2.94190000E-04  +1.10220000E-04  +1.16620000E-04  -2.25960000E-04  +1.36930000E-04
   +8.49700000E-05  +3.27200000E-05  +1.82320000E-04  +1.05609000E-03  +3.99215000E-03
   +4.61656000E-03  -8.51210000E-04  +8.29680000E-04  +1.87710000E-04  -2.96640000E-04
   +2.11680000E-04  -2.55400000E-05  +1.33932660E-01  -2.67003300E-02  -1.79984810E-01
   +8.45397000E-03  -3.65178800E-02  -3.24521400E-02  +2.33712400E-02  +7.53431000E-03
   -1.15398800E-02  -3.22104100E-02  -4.83000000E-05  +2.36400400E-02  -1.13060700E-02
   -5.14348000E-02  -1.02724430E-01  -1.41168560E-01  +2.53535270E-01  +4.88155570E-01
   +7.86800000E-04  -2.62200000E-04  +8.43000000E-06  -2.95660000E-04  -8.04100000E-04
   -1.11300000E-05  +5.29070000E-04  +3.34050000E-04  -8.23680000E-04  -3.19390000E-04
   +3.13960000E-04  -2.12500000E-05  +8.54260000E-04  -6.24960000E-04  +7.91000000E-06
   -4.40230000E-04  +1.56440000E-04  +2.17270000E-04  +1.76943000E-03  +3.80120000E-04
   +7.17520000E-04  -5.71010000E-04  +2.69200000E-05  +3.09840000E-04  -9.84540000E-04
   +7.37500000E-04  -2.20800000E-05  -1.16951000E-03  -2.40150000E-03  -2.59325000E-03
   +2.45548000E-03  +2.75586000E-03  +5.99745000E-03  -4.20003500E-02  -3.32271400E-02
   +1.50801000E-03  -2.33283710E-01  -9.41186200E-02  +3.51230300E-02  -3.46751000E-03
   -1.44128800E-02  -6.95482000E-03  -8.99070000E-04  +6.09800000E-04  +4.20042000E-03
   +3.21799240E-01  +5.01160000E-04  -2.49650000E-04  +4.86800000E-05  -2.57130000E-04
   -6.67000000E-04  -4.84100000E-05  +4.17310000E-04  +1.59730000E-04  -6.47120000E-04
   -2.67520000E-04  +3.18710000E-04  -3.44900000E-05  +6.33310000E-04  -5.23050000E-04
   +6.30100000E-05  -2.82790000E-04  +1.45200000E-04  +1.67920000E-04  +1.35750000E-03
   +1.70000000E-05  +1.21934000E-03  -4.12730000E-04  -1.17600000E-05  +2.08890000E-04
   -7.72930000E-04  +6.06690000E-04  -1.98500000E-05  -2.75813000E-03  +8.13800000E-04
   +3.63965000E-03  -2.72451000E-03  -5.98200000E-04  -5.86273000E-03  -6.17324000E-03
   +3.92008000E-03  -1.17722000E-03  -1.27834180E-01  -1.46016500E-01  -1.58959300E-02
   -4.07603000E-02  -2.95222700E-02  -8.95594000E-03  +4.79987000E-03  +2.68817000E-03
   -5.75335000E-03  +1.31490230E-01  +4.16129650E-01  +1.90720000E-04  +5.80300000E-05
   -1.72240000E-04  -4.31500000E-05  -1.14320000E-04  +1.66720000E-04  +4.26000000E-05
   +7.36300000E-05  -1.09510000E-04  -4.33800000E-05  +3.05000000E-05  +3.20300000E-05
   +5.24200000E-05  -4.28100000E-05  -1.45500000E-05  -4.24100000E-05  +1.05700000E-05
   +2.28600000E-05  -1.68740000E-04  +3.59990000E-04  +8.06800000E-05  -3.18000000E-05
   -3.10600000E-05  -2.59600000E-05  -6.27100000E-05  +4.61600000E-05  +8.60000000E-06
   -2.83167000E-03  +3.51561000E-03  +3.87866000E-03  +6.98230000E-04  -9.33723000E-03
   -2.23697000E-03  +2.75002300E-02  +1.66444700E-02  +7.19020000E-03  +1.33121000E-03
   -3.91685200E-02  -8.21151100E-02  -3.25122100E-02  -2.62430900E-02  +3.34386000E-03
   +8.45261000E-03  -2.84341000E-03  -3.33433000E-03  -6.85829600E-02  +2.99570880E-01
   +3.71304290E-01  -5.50350000E-03  +1.83152000E-03  +2.09704000E-03  -3.04684000E-03
   +1.71858900E-02  -2.35311100E-02  +1.53561000E-03  -2.61120000E-04  -5.16300000E-05
   -4.11900000E-05  +5.41780000E-04  -3.87740000E-04  +3.35200000E-04  -3.82850000E-04
   +9.11200000E-05  +5.11060000E-04  +9.38990000E-04  -1.03029000E-03  -7.55445600E-02
   +6.06659000E-03  -7.45029000E-03  +4.24060000E-04  +4.94090000E-04  -3.73957000E-03
   -4.24530000E-04  +2.92590000E-04  +2.26300000E-05  -1.25000000E-06  -1.73001500E-02
   +2.11218100E-02  -7.36250000E-04  -1.30046000E-03  +6.63700000E-04  -1.79020000E-04
   +7.64570000E-04  +1.21130000E-04  +5.72990000E-04  +6.69590000E-04  +4.19780000E-04
   -1.08665000E-03  +1.14750000E-04  -1.29288000E-03  -8.92380000E-04  -1.61302000E-03
   -4.81660000E-04  -1.30388000E-03  -1.05735000E-03  -1.54900000E-04  +5.84964050E-01
   +2.14984000E-03  -4.73940000E-04  -7.48990000E-04  +4.09171000E-03  -1.18681200E-02
   +1.35700600E-02  -4.71410000E-04  +1.91369000E-03  -8.47900000E-04  -1.27170000E-04
   -4.92930000E-04  +3.86260000E-04  +8.41100000E-05  +6.88500000E-05  -1.03510000E-04
   -3.29530000E-04  -3.16510000E-04  +5.90210000E-04  +1.01713900E-02  -1.08804550E-01
   +4.73221200E-02  -1.20228000E-03  +1.02621200E-02  -1.32141300E-02  -1.07630000E-04
   +9.11900000E-05  +5.80000000E-07  -8.36123000E-03  -2.33159200E-02  +2.08602200E-02
   -1.56680000E-04  -4.88800000E-04  +1.54159000E-03  -2.50420000E-04  +8.46100000E-04
   -5.93900000E-05  +2.70320000E-04  +5.08020000E-04  +2.92380000E-04  -5.31850000E-04
   +8.72800000E-05  -9.91470000E-04  +1.29885000E-03  -1.33593000E-03  -5.31960000E-04
   -6.60540000E-04  -5.96240000E-04  -9.56800000E-05  +2.81655500E-02  +5.37628140E-01
   +2.17056000E-03  -1.00667000E-03  -8.68240000E-04  -3.11442000E-03  -1.28500000E-03
   +3.27248000E-03  +4.78920000E-04  -1.20078000E-03  +2.23052000E-03  +9.37600000E-05
   +1.08380000E-04  -1.99230000E-04  -2.99610000E-04  +8.49100000E-05  +1.61880000E-04
   +1.24130000E-04  -2.98190000E-04  +3.54570000E-04  -9.96235000E-03  +4.21020900E-02
   -1.32248210E-01  -3.58998000E-03  +1.51067200E-02  -3.91801900E-02  +3.55580000E-04
   -2.41420000E-04  -2.60500000E-05  +7.36029000E-03  +9.81663000E-03  -3.61123000E-03
   -1.57765000E-03  -1.34296000E-03  -5.01600000E-04  +2.89610000E-04  +1.21200000E-05
   -1.21630000E-04  +9.59900000E-05  +2.33280000E-04  +3.55510000E-04  -9.30000000E-06
   -3.54500000E-04  -1.33550000E-04  -7.95920000E-04  +8.28000000E-06  -4.95900000E-05
   -4.81210000E-04  -3.93170000E-04  -1.13190000E-04  -2.60761300E-02  +6.91023600E-02
   +5.26715360E-01  -1.98877560E-01  +2.53142200E-02  +1.03481260E-01  +5.24283000E-03
   -6.90005000E-03  +9.63169000E-03  -2.33170000E-04  +4.82174000E-03  -1.95190000E-03
   -2.52209000E-03  -3.19653000E-03  +4.32834000E-03  +3.29282000E-03  +8.21655000E-03
   -5.31262000E-03  -4.26105000E-02  +1.45162000E-03  +4.41866300E-02  -3.23055000E-03
   +4.34310000E-04  -1.78656000E-03  +1.70801000E-03  +2.25040000E-04  +1.16405000E-03
   -2.77672000E-03  +7.39400000E-05  +1.79656000E-03  -5.09330000E-03  +8.22990000E-04
   -5.37801000E-03  -3.93840000E-04  +2.40099000E-03  +5.38730000E-04  -3.01960000E-04
   -3.37400000E-05  +2.61710000E-04  +1.16101000E-03  -8.36000000E-06  -2.17720000E-04
   +1.04491000E-03  +8.38650000E-04  -2.62370000E-04  -9.72890000E-04  +1.12686000E-03
   -2.04395000E-03  -6.95700000E-04  -4.03420000E-04  -1.70160000E-04  +5.09670000E-04
   +6.09800000E-05  -2.58350000E-04  +3.00329140E-01  -7.88157000E-03  -8.93862500E-02
   +4.99364600E-02  -2.54344700E-02  -1.07714000E-03  +3.11678600E-02  +9.52021000E-03
   -3.43680000E-03  +1.58817000E-03  -3.34791000E-03  +2.58656000E-03  -2.05723000E-03
   +2.28120000E-03  -1.97476000E-03  +8.61126000E-03  +2.27427900E-02  +1.03646600E-02
   -1.63947600E-02  -2.94076000E-03  -1.07237000E-03  -1.30154000E-03  +1.64089000E-03
   -3.54670000E-03  -2.14145000E-03  +9.99300000E-04  +3.02190000E-04  -1.53991000E-03
   +1.25312000E-03  -9.80000000E-04  +2.16796000E-03  -5.35640000E-04  -2.57150000E-04
   +1.50280000E-04  +6.86390000E-04  +4.74060000E-04  -4.13320000E-04  -1.88400000E-04
   +2.34830000E-04  +3.80460000E-04  -7.96300000E-05  -1.09740000E-04  -6.53200000E-05
   +9.50850000E-04  -1.64740000E-04  +2.37000000E-04  +2.95690000E-04  +2.44120000E-04
   -4.10800000E-05  -2.26280000E-04  +4.65120000E-04  -4.04800000E-05  -1.18721150E-01
   +4.36820970E-01  +1.32864680E-01  +2.12986500E-02  -1.81637660E-01  +2.94127300E-02
   +1.60395900E-02  -3.57351000E-02  -6.95702000E-03  +4.65079000E-03  +4.71073000E-03
   +4.76245000E-03  -1.94351000E-03  -3.15832000E-03  +8.96350000E-04  +4.17737000E-03
   +2.56234000E-03  +2.01315900E-02  -4.47300000E-05  -6.01131000E-03  +3.29924000E-03
   -3.95748000E-03  -7.14730000E-04  -5.92020000E-04  +1.12678000E-03  -1.37473000E-03
   +7.03420000E-04  -6.93200000E-04  -6.30900000E-05  -4.07215000E-03  +3.27102000E-03
   -3.57983000E-03  -2.87820000E-04  +4.74390000E-04  -9.01220000E-04  -9.64600000E-05
   +1.72970000E-04  +6.12350000E-04  +1.64640000E-04  +5.10000000E-07  -1.30400000E-04
   -2.75230000E-04  -5.50240000E-04  +3.45640000E-04  -2.79060000E-04  -1.11930000E-04
   -7.41830000E-04  -5.54390000E-04  -3.99140000E-04  +8.58500000E-05  -2.18410000E-04
   -1.15460000E-04  +6.20630000E-04  -1.08357930E-01  -2.91589470E-01  +4.04969300E-01
   -1.14870000E-04  +5.59000000E-06  +4.36600000E-05  +3.13200000E-05  +4.22400000E-05
   -1.04000000E-05  -7.47200000E-05  -5.69500000E-05  +1.07640000E-04  +2.81900000E-05
   -8.43000000E-06  +5.13000000E-06  -1.29990000E-04  +6.39600000E-05  +2.26500000E-05
   +7.98000000E-05  +1.06100000E-05  -2.60600000E-05  -1.70320000E-04  +2.81900000E-05
   +1.04480000E-04  +6.95500000E-05  +2.32900000E-05  -2.76900000E-05  +1.26170000E-04
   -7.74800000E-05  +3.57000000E-06  -1.43560000E-04  +4.61750000E-04  +5.97240000E-04
   -6.68400000E-04  -2.50320000E-04  -2.14090000E-04  +1.53977000E-03  -7.81790000E-04
   -2.30280000E-03  -1.12142000E-03  -3.02470200E-02  -3.11199900E-02  -5.16015000E-03
   -3.59471000E-03  +1.19965000E-03  +1.50122000E-03  -8.37530000E-04  -7.05120000E-04
   -4.30512000E-02  +4.20357100E-02  +6.88829200E-02  +2.71900000E-05  -2.22000000E-06
   -2.00600000E-05  +1.21590000E-04  +4.37400000E-05  -1.23400000E-05  +4.82917500E-02
   -8.82100000E-05  +6.72300000E-05  -3.73500000E-05  +4.56900000E-05  +9.40400000E-05
   +3.58700000E-05  -8.64400000E-05  +1.31000000E-06  +7.86200000E-05  +5.27600000E-05
   -6.44800000E-05  +1.74400000E-05  -1.31100000E-04  +1.11550000E-04  -1.92900000E-05
   +5.63500000E-05  -3.55900000E-05  -3.15600000E-05  -2.18880000E-04  -3.89500000E-05
   -3.42300000E-05  +7.49100000E-05  -7.63000000E-06  -2.48700000E-05  +1.53880000E-04
   -1.28790000E-04  +3.53000000E-06  -8.53800000E-05  +4.91640000E-04  +4.36960000E-04
   +8.96100000E-05  -9.67650000E-04  -3.09310000E-04  +3.58426000E-03  +3.23739000E-03
   +1.59758000E-03  +1.52082000E-03  -2.38617600E-02  -2.20781900E-02  -4.80492000E-03
   -2.31070000E-04  +1.01153000E-03  +5.16910000E-04  +1.53550000E-04  -1.80995000E-03
   +7.86976000E-03  -2.46197120E-01  -2.47866490E-01  +9.63400000E-05  +5.05800000E-05
   +3.16000000E-05  +6.63600000E-05  -5.00300000E-05  +7.10200000E-05  -7.90195000E-03
   +2.67225050E-01  -1.16020000E-04  -3.11900000E-05  +1.09380000E-04  +1.41700000E-05
   +5.62000000E-05  -4.14400000E-05  -3.31800000E-05  -5.38500000E-05  +8.41200000E-05
   +1.34400000E-05  -2.34000000E-06  -2.32100000E-05  -4.91400000E-05  +1.50300000E-05
   +2.87300000E-05  +4.40900000E-05  -5.99000000E-06  -2.31800000E-05  -1.26000000E-04
   -4.78000000E-06  -1.55340000E-04  +2.44400000E-05  -3.00000000E-06  -1.48200000E-05
   +4.44200000E-05  -2.61900000E-05  -6.93000000E-06  +5.86200000E-05  +7.92200000E-05
   +2.00470000E-04  +7.93300000E-05  -1.76900000E-04  -8.71470000E-04  +2.01999000E-03
   +4.52211000E-03  +2.27266000E-03  +7.31090000E-04  -3.38910000E-04  -3.41692000E-03
   +8.75800000E-05  +2.36880000E-04  +2.09204000E-03  +6.74890000E-04  -8.74690000E-04
   +4.30990000E-04  +3.45744800E-02  -2.71303630E-01  -2.97728470E-01  +1.23850000E-04
   +7.86000000E-05  +5.11300000E-05  +1.31720000E-04  +3.18000000E-05  -3.83300000E-05
   -3.79902300E-02  +2.68108480E-01  +2.97547770E-01  +1.64300000E-05  -7.69400000E-05
   +4.94200000E-05  +6.60900000E-05  -1.25800000E-05  +3.52000000E-06  +4.82700000E-05
   +1.31000000E-06  -8.60200000E-05  -3.58200000E-05  +5.97400000E-05  +1.58000000E-05
   +3.46000000E-05  -5.02700000E-05  +1.31100000E-05  -1.55600000E-05  +5.86900000E-05
   +1.38700000E-05  +6.00390000E-04  -6.81570000E-04  -9.05770000E-04  -3.48490000E-04
   -1.41780000E-04  +1.25330000E-04  -6.10300000E-05  +6.83800000E-05  +7.21000000E-06
   -2.39242000E-03  -4.75215000E-03  +1.95322000E-03  +3.86582000E-03  -1.84201600E-02
   -1.89528100E-02  -5.55378900E-02  -1.13137000E-02  +3.98169000E-03  +4.47269000E-03
   +1.69256100E-02  +1.60782800E-02  -2.56849000E-03  -6.99570000E-04  +4.62300000E-03
   -1.59144000E-03  -3.24770000E-04  +1.41350000E-04  +1.91513000E-03  +2.60113000E-03
   -1.30689000E-03  -3.04000000E-06  +6.82800000E-05  -8.14100000E-05  -7.50000000E-06
   +6.77400000E-05  -1.37600000E-05  -8.23280000E-04  -1.08435000E-03  -1.74260000E-04
   +5.23469400E-02  +1.36340000E-04  +1.15000000E-06  -2.62600000E-05  +1.20470000E-04
   -9.69800000E-05  +4.13900000E-05  +4.27800000E-05  +8.85200000E-05  -1.35490000E-04
   -2.39300000E-05  +1.54400000E-05  +2.71900000E-05  +9.31200000E-05  -4.38300000E-05
   -3.17100000E-05  -6.44600000E-05  +2.50300000E-05  +3.33100000E-05  +3.13780000E-04
   -1.61230000E-04  -8.44470000E-04  -3.06240000E-04  -1.93600000E-04  +1.28040000E-04
   -9.95400000E-05  +7.18300000E-05  +5.70000000E-06  -5.00330000E-03  +2.17799000E-03
   -1.61752000E-03  +1.91676000E-03  -1.03128800E-02  -1.35185700E-02  -1.14259000E-02
   -1.92567810E-01  -1.47637790E-01  -4.79151000E-03  -2.11570000E-03  -2.77987000E-03
   -1.62260000E-04  +3.34763000E-03  -1.97866000E-03  -8.22300000E-05  -1.14860000E-04
   +8.32430000E-04  +2.10891000E-03  +6.88370000E-04  +3.14183000E-03  -6.52100000E-05
   -1.80500000E-05  -4.03800000E-05  -7.97500000E-05  -2.68300000E-05  -6.96000000E-06
   +9.45670000E-04  +1.68150000E-04  -1.01154000E-03  +1.50439700E-02  +2.00963070E-01
   -3.21200000E-05  -1.20610000E-04  +9.26700000E-05  -9.96000000E-05  -9.92000000E-06
   -3.56600000E-05  +7.39500000E-05  -3.58200000E-05  -5.47100000E-05  -3.94700000E-05
   +6.50700000E-05  -2.53800000E-05  +4.07500000E-05  -7.47300000E-05  +5.19100000E-05
   +4.96000000E-06  +4.43200000E-05  +8.73000000E-06  +4.18230000E-04  -1.31900000E-04
   +3.97800000E-05  -7.01300000E-05  +3.07900000E-05  +3.77700000E-05  -7.41700000E-05
   +7.72400000E-05  -3.94000000E-06  +1.37710000E-03  -2.14647000E-03  +4.41112000E-03
   +8.36070000E-04  +2.58900000E-05  +1.73389000E-03  +3.93870000E-03  -1.47721970E-01
   -1.78567300E-01  -5.02978000E-03  -1.69432300E-02  -9.17744000E-03  +5.08239000E-03
   -1.69264000E-03  +4.87740000E-04  +3.84460000E-04  +9.88520000E-04  -2.24490000E-04
   -1.83808000E-03  +2.81203000E-03  -2.74400000E-05  -4.52500000E-05  +6.20000000E-07
   -4.59500000E-05  +3.26500000E-05  +9.42000000E-05  -4.07000000E-05  +1.80843000E-03
   +2.82030000E-04  -3.20320000E-04  -4.70176000E-03  +1.62944820E-01  +1.84063280E-01
   -3.76710000E-04  -1.39480000E-04  -5.16940000E-04  -6.83910000E-04  -8.30500000E-04
   -5.71110000E-04  -2.97170000E-04  -3.32510000E-04  -9.94900000E-05  -6.95900000E-05
   +8.88600000E-05  +5.14700000E-05  -1.89410000E-04  +1.10110000E-04  +1.36370000E-04
   +2.70050000E-04  -7.85100000E-05  -3.79300000E-05  -9.08820000E-04  +3.07620000E-04
   -1.01970000E-03  -2.04600000E-05  +1.35990000E-04  -9.09900000E-05  +1.61950000E-04
   -1.33380000E-04  -1.40900000E-05  +4.10008000E-03  -3.71250000E-04  -2.94790000E-04
   -2.14707030E-01  +2.60619900E-02  +1.39691700E-01  -1.46603300E-02  +5.13042000E-03
   +1.68939600E-02  -4.68520000E-04  -5.11641000E-03  +3.30620000E-04  -1.03980000E-04
   -1.74290000E-04  -8.89950000E-04  +2.24791000E-03  -1.73441000E-03  +9.81510000E-04
   -1.42168000E-03  -8.78400000E-05  +8.23480000E-04  +4.46000000E-05  -1.45300000E-05
   +1.84110000E-04  -1.66500000E-05  +8.28600000E-05  +2.75930000E-04  +1.04570000E-04
   +2.17000000E-04  +1.30950000E-04  -2.13800000E-05  +1.20048000E-03  -1.59084000E-03
   +2.26742020E-01  +4.31500000E-05  +5.86170000E-04  -6.70250000E-04  -2.64520000E-04
   -9.35200000E-05  +1.66900000E-04  -4.99690000E-04  +1.59640000E-04  -3.36670000E-04
   +2.26000000E-06  -1.14330000E-04  +1.74200000E-05  -1.24550000E-04  +1.00410000E-04
   +4.58100000E-05  +1.60800000E-04  -2.32620000E-04  -1.13200000E-05  +1.59554000E-03
   -8.11280000E-04  +1.19259000E-03  +1.19140000E-04  +4.90500000E-05  +9.49300000E-05
   +1.72100000E-04  -1.66890000E-04  -7.00000000E-08  +1.83266600E-02  +2.26685000E-03
   -1.41189400E-02  +2.62526700E-02  -5.83430400E-02  -3.56157800E-02  -1.53807000E-02
   +6.21469000E-03  +1.25808700E-02  -4.77113000E-03  +9.56780000E-04  -3.46052000E-03
   -2.62810000E-04  -1.12324000E-03  +2.41500000E-04  -2.27251000E-03  -8.21600000E-04
   -5.72201000E-03  -9.99730000E-04  +4.70700000E-05  +6.32100000E-04  -1.06550000E-04
   -4.80320000E-04  -3.73720000E-04  -3.35650000E-04  -2.65530000E-04  +3.41390000E-04
   +7.52000000E-05  +1.05170000E-04  +1.07820000E-04  +1.65303000E-03  -1.18869000E-03
   +2.02951000E-03  -2.46975000E-02  +5.38472000E-02  +1.71420000E-04  +3.98410000E-04
   -6.85730000E-04  +1.23120000E-04  -1.96560000E-04  +4.26630000E-04  -5.40870000E-04
   -1.97820000E-04  +8.52710000E-04  -4.13400000E-05  -4.34600000E-05  +7.82700000E-05
   -3.42270000E-04  +8.60800000E-05  +2.56100000E-05  +5.30100000E-05  +1.43300000E-04
   -8.14700000E-05  +8.94200000E-05  +1.79111000E-03  -1.38221000E-03  -2.55880000E-04
   -5.72000000E-06  -1.33500000E-05  +3.34350000E-04  -2.21930000E-04  +1.21700000E-05
   +1.74540000E-02  -2.03809000E-03  -8.62326000E-03  +1.39269820E-01  -3.50878600E-02
   -1.62750860E-01  -2.53301000E-03  -8.51820000E-04  +4.32612000E-03  +6.66700000E-04
   -3.07236000E-03  +4.41681000E-03  -1.12597000E-03  +7.00200000E-05  -4.20190000E-04
   +8.96080000E-04  -6.13337000E-03  +1.16940000E-04  +1.02600000E-04  +8.55300000E-05
   +9.19300000E-05  -3.96200000E-05  +2.31700000E-05  -3.03900000E-05  -2.93520000E-04
   +2.72300000E-05  +2.77490000E-04  -4.12300000E-05  -1.05600000E-05  -3.29600000E-05
   -1.26468000E-03  +2.32085000E-03  -1.35736000E-03  -1.53470720E-01  +4.20089900E-02
   +1.66219300E-01  -1.41830000E-04  -2.39700000E-05  +2.55910000E-04  -8.33100000E-05
   -1.09480000E-04  -2.65430000E-04  -5.85200000E-05  -4.73500000E-05  +7.03500000E-05
   +6.15800000E-05  -1.68200000E-05  -7.25000000E-06  -6.24300000E-05  +4.57100000E-05
   +1.64700000E-05  +8.04500000E-05  -2.43000000E-05  -6.00900000E-05  +2.83600000E-05
   +1.38341000E-03  -1.02985000E-03  -2.71253000E-03  -1.49999000E-03  +6.86880000E-04
   +7.88800000E-05  -6.35900000E-05  -1.03800000E-05  +6.53115000E-03  +1.72183600E-02
   +1.59265500E-02  -2.64559000E-03  -8.83160000E-04  +5.16010000E-03  -1.36969000E-03
   -1.93260000E-04  +7.77000000E-06  -2.02161000E-03  -4.61035000E-03  +2.15463000E-03
   +3.05595000E-03  -1.91501200E-02  -1.84339100E-02  -5.67873000E-02  -9.63884000E-03
   +2.02192000E-03  +9.76200000E-05  -9.81270000E-04  -9.65450000E-04  +2.63720000E-04
   +5.75000000E-06  -8.37400000E-05  +1.82230000E-04  -1.56000000E-04  -1.88020000E-04
   -3.17580000E-04  -2.14550000E-04  -1.02850000E-04  -6.57900000E-05  +2.13290000E-04
   -2.20020000E-04  +1.27000000E-04  +1.04398000E-03  +9.14570000E-04  +5.79200700E-02
   +2.76690000E-04  +2.20540000E-04  -4.89000000E-04  +3.25940000E-04  +2.74030000E-04
   -1.10870000E-04  +5.86900000E-05  -7.57600000E-05  +5.75500000E-05  +4.85000000E-06
   -4.05500000E-05  +2.09000000E-05  -1.48900000E-05  +5.48100000E-05  -5.73300000E-05
   -9.90400000E-05  +6.98000000E-06  +8.74900000E-05  +5.51870000E-04  -2.08743000E-03
   +1.24426000E-03  -2.74183000E-03  -1.03050000E-03  +3.42070000E-04  +3.95900000E-05
   -4.01500000E-05  +2.10700000E-05  -5.32690000E-04  +9.79970000E-04  -3.42941000E-03
   -8.29970000E-04  +3.43569000E-03  -2.71388000E-03  +4.97800000E-05  -7.26400000E-05
   +9.19830000E-04  -4.82130000E-03  +2.83917000E-03  -2.01395000E-03  +8.82300000E-04
   -9.69173000E-03  -1.39994200E-02  -9.14350000E-03  -1.94716330E-01  -1.49197490E-01
   -1.46450000E-04  -8.52240000E-04  -8.33920000E-04  -4.07410000E-04  -2.14210000E-04
   +4.57700000E-05  -4.58480000E-04  -4.63900000E-05  +4.35920000E-04  -1.37730000E-04
   -2.08090000E-04  +6.76000000E-05  +1.92550000E-04  -3.53620000E-04  +2.55400000E-04
   -8.51500000E-05  -1.53910000E-04  +1.07900000E-05  +1.74754300E-02  +2.04534490E-01
   -1.22970000E-04  -9.86400000E-05  +1.05590000E-04  -1.58820000E-04  -8.18000000E-06
   +1.37410000E-04  -4.29800000E-05  +2.10000000E-06  -1.13200000E-05  -4.58000000E-06
   +3.09000000E-05  +2.50000000E-07  +7.75000000E-06  -2.90700000E-05  +1.38000000E-06
   -1.47000000E-06  +1.51300000E-05  -1.06000000E-05  -2.11060000E-03  +3.40100000E-04
   -1.77693000E-03  -4.47610000E-04  -9.39380000E-04  +4.50610000E-04  -2.74700000E-05
   +3.75800000E-05  +6.00000000E-07  -1.91231000E-03  -1.48137900E-02  -8.99924000E-03
   +5.20033000E-03  -2.31593000E-03  +8.85090000E-04  +7.83600000E-05  +9.43210000E-04
   -1.55850000E-04  +2.08741000E-03  -2.15000000E-03  +4.42599000E-03  +1.65027000E-03
   -2.76990000E-04  +2.59066000E-03  +2.33976000E-03  -1.49872150E-01  -1.90418730E-01
   -1.46240000E-04  -2.23190000E-04  -4.75900000E-05  +6.80710000E-04  +2.20200000E-04
   -5.62000000E-06  +2.62370000E-04  +6.24100000E-05  -1.43800000E-05  -2.47800000E-05
   +1.19490000E-04  -4.72600000E-05  -2.57030000E-04  +2.27870000E-04  -3.33920000E-04
   -1.54120000E-04  -7.28620000E-04  -6.53200000E-04  -4.02643000E-03  +1.66182600E-01
   +1.94957090E-01  -3.69900000E-05  -7.35200000E-05  +1.88870000E-04  -7.08600000E-05
   -1.91080000E-04  +3.66900000E-05  -1.12800000E-05  +6.39600000E-05  -7.50200000E-05
   -2.40000000E-05  +2.91000000E-05  +4.03000000E-06  +5.79800000E-05  -5.51400000E-05
   +8.29000000E-06  -1.30500000E-05  +2.25200000E-05  -5.77000000E-06  -1.98710000E-04
   +5.57680000E-04  +7.72130000E-04  -3.20400000E-05  +8.54800000E-05  +4.79900000E-05
   -7.67900000E-05  +6.07800000E-05  -8.01000000E-06  -1.06431000E-03  -5.19553000E-03
   +6.03110000E-04  -1.24260000E-04  -2.76180000E-04  -9.14170000E-04  +2.04135000E-03
   -1.61799000E-03  +7.86960000E-04  +3.08760000E-03  -2.45850000E-03  -1.04913000E-03
   -2.19391400E-01  +2.28768200E-02  +1.44255790E-01  -1.36896500E-02  +5.48772000E-03
   +1.60932600E-02  +1.91530000E-04  +1.43654000E-03  -1.07963000E-03  -1.76380000E-04
   -7.65800000E-05  -7.80300000E-05  +8.67800000E-05  +5.47800000E-05  -2.13800000E-04
   -8.43800000E-05  +1.80910000E-04  -1.39990000E-04  +1.95670000E-04  -3.79800000E-05
   -1.65740000E-04  -1.67320000E-04  +2.29420000E-04  -1.27210000E-04  -9.63900000E-05
   +1.31443000E-03  -1.65054000E-03  +2.29646940E-01  -1.72000000E-05  -1.92700000E-05
   +5.54000000E-06  -2.60180000E-04  -2.08330000E-04  +5.61800000E-05  -4.84000000E-06
   +6.75400000E-05  -1.11490000E-04  -1.80300000E-05  +3.21500000E-05  +1.93600000E-05
   +1.92800000E-05  -2.80600000E-05  +1.31300000E-05  -1.48000000E-06  -1.97000000E-06
   +3.17000000E-06  -4.80120000E-04  +4.93070000E-04  +3.62020000E-04  +4.38100000E-05
   +5.26600000E-05  +5.59000000E-05  -3.79300000E-05  +2.94700000E-05  -5.30000000E-07
   -4.78601000E-03  +9.23700000E-04  -2.98970000E-03  -4.42520000E-04  -1.32978000E-03
   +7.28500000E-05  -2.11035000E-03  -1.14652000E-03  -5.14765000E-03  +1.87722600E-02
   +2.59690000E-03  -1.49294400E-02  +2.17958500E-02  -5.52545600E-02  -3.40568200E-02
   -1.43765700E-02  +6.33569000E-03  +1.32535800E-02  +1.18395000E-03  -7.42700000E-05
   +2.61553000E-03  -5.85100000E-05  +3.13700000E-05  -3.77300000E-05  +6.86000000E-06
   -2.10400000E-05  +4.00700000E-05  +1.25620000E-04  +2.38000000E-05  +4.80840000E-04
   +9.44910000E-04  -1.46700000E-04  -7.56720000E-04  +1.95220000E-04  -2.15150000E-04
   +3.19030000E-04  +1.72771000E-03  -1.28412000E-03  +2.06506000E-03  -2.22789400E-02
   +4.92194900E-02  -2.59200000E-05  +5.10000000E-07  +5.13400000E-05  +1.32220000E-04
   +5.93800000E-05  -1.85500000E-05  -2.48300000E-05  -2.66700000E-05  +7.63100000E-05
   +1.40100000E-05  -1.63400000E-05  -1.95000000E-06  -3.22800000E-05  +2.39300000E-05
   -5.87000000E-06  +1.73600000E-05  +8.89000000E-06  -1.25500000E-05  -1.31280000E-04
   -1.20870000E-04  +2.54510000E-04  +1.30100000E-05  +4.45300000E-05  -4.20700000E-05
   +3.98100000E-05  -2.67300000E-05  +4.60000000E-07  +5.70390000E-04  -2.76764000E-03
   +4.22419000E-03  -1.19025000E-03  -1.42370000E-04  -4.48540000E-04  +4.06880000E-04
   -5.44852000E-03  -6.68000000E-06  +1.96174600E-02  -7.06540000E-04  -8.50467000E-03
   +1.43116150E-01  -3.49338900E-02  -1.64016150E-01  -3.12839000E-03  -4.18000000E-06
   +4.59478000E-03  -1.32674000E-03  +2.43961000E-03  -3.10940000E-04  +1.06600000E-05
   -3.92600000E-05  -1.33500000E-05  +4.71600000E-05  +4.03000000E-06  -6.17200000E-05
   -2.00640000E-04  +4.37380000E-04  +1.81000000E-06  +7.93590000E-04  -1.17300000E-04
   -6.21400000E-04  -1.37290000E-04  +3.06480000E-04  -3.07140000E-04  -1.24426000E-03
   +2.42491000E-03  -1.35974000E-03  -1.57340770E-01  +3.86383800E-02  +1.66586970E-01
   -5.50640000E-04  -1.22440000E-04  +6.43780000E-04  +1.49840000E-03  +1.66110000E-04
   -1.19738000E-03  +1.99000000E-04  -1.07771000E-03  +8.62810000E-04  -1.24220000E-04
   +2.68080000E-04  -2.04460000E-04  +1.59000000E-04  -1.97650000E-04  +8.83000000E-05
   -1.15300000E-05  +1.68560000E-04  -1.84260000E-04  -6.13325000E-03  +2.55196000E-03
   +1.04438000E-03  -1.22450000E-04  -1.06910000E-04  +8.24320000E-04  -2.06970000E-04
   +1.81150000E-04  -3.17700000E-05  +7.36380000E-04  -2.13658000E-03  +1.19430000E-04
   +5.26240000E-04  +4.50860000E-04  +4.22840000E-04  -4.43930000E-04  -4.31600000E-05
   +2.08600000E-05  +1.53360000E-04  -1.44760000E-04  -3.35210000E-04  +2.64830000E-04
   +2.47620000E-04  +3.86000000E-06  +1.74160000E-04  -1.49370000E-04  +3.22880000E-04
   -2.24100000E-05  -3.21800000E-05  +3.70800000E-05  -2.62592760E-01  +1.00555740E-01
   +2.95807800E-02  +3.25790000E-04  +2.82000000E-05  -2.99670000E-04  -6.52000000E-06
   +1.35500000E-05  -1.22000000E-06  -6.77000000E-06  +1.36300000E-05  -4.14000000E-06
   +3.69000000E-05  -8.93900000E-05  +1.81100000E-05  +1.83200000E-05  +6.64900000E-05
   -5.52400000E-05  +2.87500000E-05  +1.88800000E-05  +1.11300000E-05  +2.83505530E-01
   +1.46675000E-03  -7.98000000E-05  -7.78740000E-04  -5.77010000E-04  -1.69977000E-03
   +3.89070000E-03  -6.17550000E-04  -3.43860000E-04  +4.36690000E-04  +1.58600000E-05
   -2.39000000E-05  -1.10440000E-04  -2.22110000E-04  +1.38310000E-04  +3.71000000E-05
   -4.27200000E-05  -3.00130000E-04  +2.28010000E-04  +1.86957100E-02  -1.18512700E-02
   -1.26544000E-03  -5.03280000E-04  +2.28180000E-04  -1.35014000E-03  +2.46620000E-04
   -1.70980000E-04  -5.48000000E-06  +1.57371000E-03  +1.41910000E-04  +2.51500000E-05
   -1.49090000E-04  -3.85610000E-04  -5.83370000E-04  +2.08140000E-04  +9.11800000E-05
   -9.53700000E-05  -3.08240000E-04  -6.11000000E-05  +2.21390000E-04  -3.08960000E-04
   -1.45680000E-04  -1.89600000E-05  -1.86950000E-04  +1.93300000E-04  +5.40200000E-05
   +2.50140000E-04  +2.11420000E-04  +9.49000000E-06  +9.80180000E-02  -9.41266400E-02
   -1.54709200E-02  -3.43340000E-04  -5.00300000E-05  +2.65150000E-04  -1.15100000E-05
   -4.35400000E-05  -1.04600000E-05  +1.58700000E-05  +3.39000000E-06  +1.68600000E-05
   +1.03500000E-05  +1.18050000E-04  +1.63830000E-04  +4.45800000E-05  -3.47700000E-05
   +9.54200000E-05  +1.17400000E-05  -1.06600000E-05  -1.78000000E-06  -1.10342550E-01
   +1.01926830E-01  -1.35092000E-03  +5.22670000E-04  +5.68510000E-04  +2.54800000E-04
   +2.56179000E-03  -3.91283000E-03  +3.28610000E-04  +7.62260000E-04  -1.31219000E-03
   -1.72000000E-06  -1.98830000E-04  +1.94370000E-04  +1.12410000E-04  -1.10900000E-05
   -9.94200000E-05  +6.49500000E-05  +2.08140000E-04  -2.46650000E-04  -2.26085900E-02
   +1.22289600E-02  +2.86830000E-04  -1.41672000E-03  +8.97080000E-04  +1.05684000E-03
   -9.84100000E-05  +4.63300000E-05  +3.35700000E-05  -9.80650000E-04  +1.74930000E-04
   +4.30280000E-04  +3.94340000E-04  +4.74200000E-05  -1.95570000E-04  -4.25420000E-04
   -3.87300000E-05  +1.00430000E-04  +1.96690000E-04  -5.74500000E-05  -2.43540000E-04
   +1.91500000E-04  +1.42480000E-04  +1.81000000E-06  -2.30160000E-04  -4.68800000E-05
   +2.30280000E-04  -1.82160000E-04  -1.27520000E-04  -1.68000000E-06  +3.16321300E-02
   -1.70840800E-02  -5.13516900E-02  +6.42100000E-05  -5.49600000E-05  -6.39700000E-05
   +1.60900000E-05  +1.04900000E-05  +1.69500000E-05  +1.51700000E-05  -2.01900000E-05
   +4.63000000E-06  +2.65000000E-06  -5.87000000E-06  +6.73100000E-05  +2.76000000E-05
   -2.32500000E-05  -1.28010000E-04  -4.05000000E-06  +6.25000000E-06  +1.37800000E-05
   -3.36790800E-02  +1.23035500E-02  +5.76127800E-02  +7.89600000E-05  -4.16700000E-05
   -1.97650000E-04  +4.20310000E-04  -2.25040000E-04  +5.54680000E-04  -2.58520000E-04
   +5.39530000E-04  -5.34140000E-04  +4.27800000E-05  -1.06140000E-04  +1.11700000E-05
   -6.42900000E-05  +1.10150000E-04  -3.77800000E-05  +2.70100000E-05  -5.66200000E-05
   +4.83800000E-05  +4.36135000E-03  +5.45871000E-03  -1.08206000E-03  +3.88230000E-04
   +5.39060000E-04  -6.59000000E-05  +9.26100000E-05  -6.81500000E-05  +1.34400000E-05
   +2.53240000E-04  -7.04470000E-04  -6.84830000E-04  +3.55720000E-04  +4.06450000E-04
   +5.02500000E-04  -3.08970000E-04  -2.94800000E-05  +1.02210000E-04  +2.78860000E-04
   +5.40400000E-05  -1.72860000E-04  +1.78520000E-04  -9.48000000E-06  +1.44000000E-05
   +6.18340000E-04  -4.52000000E-05  -1.10360000E-04  -2.21630000E-04  -1.58340000E-04
   +3.30000000E-06  -1.82208520E-01  -1.39322570E-01  +5.72253000E-03  -1.75900000E-05
   +8.84700000E-05  +1.17030000E-04  +1.76400000E-05  +3.50000000E-05  +1.05000000E-05
   -1.76800000E-05  -7.70000000E-07  -1.73600000E-05  -1.00400000E-05  -2.62200000E-05
   -7.90000000E-06  -7.63300000E-05  +8.39700000E-05  -4.29400000E-05  +8.41000000E-06
   +1.52000000E-06  +1.48600000E-05  -1.77008400E-02  -2.02825800E-02  +1.74580000E-04
   +1.99657130E-01  -1.34730000E-04  -1.78110000E-04  +4.60400000E-04  -1.06790000E-04
   +6.38880000E-04  -7.36460000E-04  +4.71200000E-05  -2.29624000E-03  +1.97859000E-03
   -9.18500000E-05  +4.63130000E-04  -3.83980000E-04  -1.41000000E-05  -1.70390000E-04
   +1.60940000E-04  +2.82800000E-05  +1.14550000E-04  -1.55520000E-04  -1.42671500E-02
   -1.37213000E-02  -4.36250000E-04  -1.10620000E-04  +5.59760000E-04  -1.68094000E-03
   -4.26500000E-05  +9.38400000E-05  -4.77700000E-05  +5.21160000E-04  -1.65606000E-03
   +3.95457000E-03  -4.19870000E-04  -2.23320000E-04  +2.89250000E-04  +2.66040000E-04
   +2.26540000E-04  +1.71000000E-06  +1.67100000E-04  +5.73870000E-04  +5.09070000E-04
   -6.52160000E-04  -4.46160000E-04  -4.58920000E-04  +5.61830000E-04  -3.08640000E-04
   -3.88960000E-04  -5.46070000E-04  -4.52950000E-04  -9.46000000E-05  -1.34964440E-01
   -1.87503680E-01  +6.86149000E-03  +3.15270000E-04  +1.41510000E-04  -2.90040000E-04
   +2.80900000E-05  +5.21000000E-05  +4.37900000E-05  -2.19200000E-05  -5.76000000E-05
   -2.60200000E-05  -3.85400000E-05  +1.35280000E-04  -1.03640000E-04  +4.58500000E-05
   -5.25800000E-05  +1.74790000E-04  -9.08500000E-05  -5.87000000E-06  -3.07400000E-05
   +1.02446600E-02  +1.15305600E-02  -4.94450000E-04  +1.48415620E-01  +2.01085170E-01
   +9.75700000E-05  -5.37000000E-06  -1.27810000E-04  +4.58600000E-05  -6.59540000E-04
   +6.33060000E-04  -4.37550000E-04  -7.39600000E-05  +4.94940000E-04  -7.90100000E-05
   +1.86700000E-04  -1.16570000E-04  -6.53800000E-05  -4.16200000E-05  +8.94400000E-05
   +5.73700000E-05  +9.68000000E-06  -4.40500000E-05  +1.83294700E-02  +1.71426600E-02
   -2.24728000E-03  +9.98980000E-04  +9.08280000E-04  +1.23952000E-03  +1.82000000E-05
   -1.52000000E-06  -2.52300000E-05  -1.56737000E-03  +2.40646000E-03  -3.32060000E-03
   -1.70600000E-05  -3.24380000E-04  +4.76900000E-05  +7.55220000E-04  -4.29000000E-05
   +3.46300000E-05  -4.42580000E-04  +4.04500000E-05  +2.92460000E-04  -8.82000000E-06
   -3.22010000E-04  +2.01320000E-04  +6.68050000E-04  +5.06030000E-04  +5.80600000E-05
   +4.35480000E-04  +3.58040000E-04  -2.04000000E-06  +5.83745000E-03  +6.92540000E-03
   -4.86537200E-02  -1.39000000E-05  -7.68300000E-05  -2.53300000E-05  -4.29000000E-06
   -3.19500000E-05  -4.38800000E-05  +3.53100000E-05  +2.91100000E-05  +1.93300000E-05
   -2.62650000E-04  +3.55020000E-04  -1.03180000E-04  -1.76800000E-05  +8.67100000E-05
   -1.54340000E-04  +4.60000000E-05  +3.06600000E-05  -2.24100000E-05  +2.53948000E-03
   +2.81174000E-03  -1.15036000E-03  -7.98340000E-03  -9.97341000E-03  +5.19502000E-02
   +2.51780000E-04  +2.76790000E-04  -3.40230000E-04  +2.69850000E-04  -8.61140000E-04
   +3.22150000E-04  -2.65520000E-04  +1.39819000E-03  -1.65896000E-03  +1.24790000E-04
   -2.90720000E-04  +2.77430000E-04  -6.84500000E-05  +1.37300000E-04  -1.39770000E-04
   +6.37000000E-06  -1.35440000E-04  +1.34120000E-04  -1.74210000E-03  -3.38928000E-03
   -5.41441000E-03  +5.50800000E-05  +1.24511000E-03  -1.05432000E-03  +9.57900000E-05
   -1.05280000E-04  +4.03400000E-05  -2.15160000E-04  +4.71980000E-04  +7.06500000E-04
   +6.60700000E-05  -1.93510000E-04  -9.54700000E-05  -2.43820000E-04  -2.45400000E-05
   -3.86500000E-05  -3.08100000E-05  -1.17040000E-04  -6.16700000E-05  +9.54600000E-05
   +7.06300000E-05  +6.46700000E-05  -1.60750000E-04  -5.71100000E-05  +1.08360000E-04
   +7.08900000E-05  +6.73900000E-05  -1.26000000E-06  -4.52710400E-02  +5.01310000E-04
   +1.16362000E-03  -2.78880000E-04  -6.98200000E-05  +2.59940000E-04  -6.60000000E-06
   -2.43500000E-05  +6.80000000E-06  +2.71100000E-05  -7.67000000E-06  +2.04400000E-05
   +1.67570000E-04  -5.86400000E-05  +8.82200000E-05  +1.32000000E-05  +1.27300000E-05
   -7.91300000E-05  +3.28000000E-06  +1.08900000E-05  -1.05400000E-05  +7.08840000E-04
   +1.39506300E-02  +2.55471200E-02  -7.79700000E-05  -1.04485000E-02  -1.97857800E-02
   +4.73134500E-02  -2.29010000E-04  -5.82200000E-05  +1.41810000E-04  -3.20720000E-04
   +1.11112000E-03  -8.26850000E-04  +3.99020000E-04  +1.37880000E-04  -5.16920000E-04
   +5.19800000E-05  -2.10370000E-04  +8.86600000E-05  +9.40800000E-05  +2.74400000E-05
   -1.07500000E-04  -7.78000000E-05  +4.06000000E-05  +2.94000000E-05  -1.18998000E-03
   +9.94020000E-03  +1.82642700E-02  +2.68810000E-04  -2.18494000E-03  +2.88439000E-03
   -5.76900000E-05  +2.33000000E-05  +2.21400000E-05  +7.05960000E-04  +1.09061000E-03
   +2.93000000E-04  -3.58840000E-04  -1.53470000E-04  +5.38190000E-04  -8.58700000E-05
   -1.75300000E-04  -8.23900000E-05  +3.07400000E-05  -1.23140000E-04  -1.98720000E-04
   +1.30360000E-04  +1.69320000E-04  +1.47110000E-04  -2.12550000E-04  -3.66500000E-05
   -4.87000000E-05  +1.41280000E-04  +9.53300000E-05  +2.17800000E-05  -5.91630000E-04
   -1.17372000E-01  -1.20418620E-01  +1.53200000E-05  +1.49600000E-05  -4.74100000E-05
   -1.51300000E-05  -1.03100000E-05  -1.38400000E-05  -2.86000000E-06  +3.24000000E-06
   +2.22600000E-05  +3.51500000E-05  -6.69310000E-04  +1.88760000E-04  +1.94800000E-05
   -1.29100000E-05  +1.35000000E-05  +9.14000000E-06  -3.92000000E-06  +1.61000000E-06
   -1.15914000E-03  -7.03793000E-03  -1.07947000E-02  +1.66840000E-03  -1.06697800E-02
   -1.92206400E-02  -1.43352000E-03  +1.25184280E-01  +1.58310000E-04  +1.66130000E-04
   -2.70870000E-04  +3.47110000E-04  -6.75840000E-04  +1.25649000E-03  -4.35250000E-04
   +1.02312000E-03  -1.28475000E-03  -8.35400000E-05  -1.53780000E-04  +1.40130000E-04
   +8.15000000E-06  -1.96000000E-06  -2.38000000E-05  -4.10000000E-07  -7.75700000E-05
   +4.28700000E-05  +8.45110000E-04  -1.33317800E-02  -1.96615200E-02  -3.84770000E-04
   +4.55035000E-03  -4.03305000E-03  -2.85400000E-05  +2.30400000E-05  +2.49100000E-05
   -1.56799000E-03  -8.99070000E-04  +7.18130000E-04  +9.56300000E-05  -6.93930000E-04
   +1.36700000E-05  +6.99030000E-04  +3.32000000E-04  +1.61970000E-04  -2.64060000E-04
   +4.33480000E-04  +5.12910000E-04  -4.87380000E-04  -4.83550000E-04  -1.72590000E-04
   +9.58550000E-04  +1.56470000E-04  -3.19480000E-04  -6.59500000E-05  -4.48800000E-05
   -2.77900000E-05  -8.70690000E-04  -1.17918960E-01  -2.53857840E-01  -4.67000000E-05
   +1.15820000E-04  +2.69980000E-04  +2.15000000E-05  +1.77700000E-05  -3.35000000E-06
   +3.68600000E-05  +4.94000000E-06  -5.50000000E-06  -2.77260000E-04  +4.58130000E-04
   +9.08900000E-05  -1.22170000E-04  +1.48300000E-05  +9.29500000E-05  -6.58000000E-06
   +1.50800000E-05  -2.15800000E-05  -2.10000000E-04  -9.78240000E-04  -1.96229000E-03
   +4.53470000E-04  +1.49431000E-03  +1.96611000E-03  -7.74520000E-04  +1.27789660E-01
   +2.76090170E-01  -4.54050000E-04  +4.93810000E-04  +8.67900000E-04  +1.03890000E-04
   -3.93300000E-04  +1.70150000E-04  -2.12240000E-04  -2.46580000E-04  +2.37780000E-04
   +8.92800000E-05  -2.22700000E-05  -2.25200000E-05  -8.05000000E-05  +6.96800000E-05
   +1.92700000E-05  -2.15500000E-05  -1.12800000E-05  -4.45600000E-05  -1.81198000E-03
   +8.25730000E-04  -1.40904000E-03  -4.89669800E-02  +3.40064000E-03  -4.71686000E-03
   +6.16500000E-05  -5.46000000E-05  -1.65700000E-05  +2.84320000E-04  +6.01010000E-04
   -3.11120000E-04  -1.01580000E-04  -1.20420000E-04  -8.45200000E-05  +1.61010000E-04
   +1.26030000E-04  +1.34200000E-05  -9.76600000E-05  +1.65300000E-05  +6.29100000E-05
   -1.32680000E-04  -4.04000000E-06  +2.34190000E-04  +2.33020000E-04  -3.45940000E-04
   -5.22530000E-04  +9.63600000E-05  +1.07730000E-04  +3.26300000E-05  -3.11200000E-05
   -5.15980000E-04  -7.12350000E-04  +2.36020000E-04  -2.56760000E-04  -3.83160000E-04
   -8.84000000E-06  -8.75000000E-06  -4.82000000E-06  +1.32400000E-05  +1.18900000E-05
   +1.54100000E-05  -1.98400000E-05  +4.83000000E-05  +5.21600000E-05  -1.02693000E-03
   +2.75530000E-04  -2.55740000E-04  -8.91000000E-06  -1.88000000E-06  -2.26700000E-05
   +4.33580000E-04  -2.67960000E-04  +2.77850000E-04  +9.40500000E-05  +3.35560000E-04
   -1.52780000E-04  +6.43550000E-04  +1.53490000E-04  -2.61280000E-04  +4.85357900E-02
   +1.87216000E-03  +2.33510000E-04  -2.01132000E-03  -7.13140000E-04  +5.71400000E-04
   +7.91110000E-04  +3.16020000E-04  +1.46250000E-04  -2.30660000E-04  -2.05060000E-04
   +2.53400000E-05  +6.43500000E-05  +1.20040000E-04  -8.93400000E-05  -5.56500000E-05
   -4.22100000E-04  +2.15500000E-05  +2.68710000E-04  -4.61090000E-04  +1.14836600E-02
   -1.63833800E-02  +3.93171000E-03  -1.27283380E-01  +1.27820010E-01  -1.65250000E-04
   +8.51300000E-05  +2.12300000E-05  +1.46890000E-04  +8.95840000E-04  +3.00520000E-04
   +2.02180000E-04  -1.52450000E-04  +8.87000000E-06  +1.37000000E-04  +3.27800000E-05
   -4.00300000E-05  -1.27480000E-04  +3.27500000E-05  +1.67090000E-04  -1.64200000E-05
   -2.29660000E-04  -1.23220000E-04  -4.18370000E-04  +3.51330000E-04  +1.52450000E-04
   +5.68000000E-05  +8.10000000E-06  -2.83500000E-05  -2.47360000E-04  -2.10016000E-03
   -2.93173000E-03  -5.39470000E-04  -1.95456000E-03  +4.71130000E-04  -1.51400000E-05
   -5.32000000E-06  -8.69000000E-06  +4.28000000E-06  +1.75800000E-05  -1.32500000E-05
   -1.95700000E-05  +2.28700000E-05  -4.41500000E-05  -1.75860000E-04  -1.33000000E-04
   -1.95870000E-04  -1.18000000E-05  +2.89600000E-05  -1.98100000E-05  -2.28710000E-04
   -5.56400000E-05  -6.37300000E-05  +2.40060000E-04  +4.87200000E-05  -1.11180000E-04
   -2.90580000E-04  +8.60070000E-04  -1.06762000E-03  -3.32170000E-03  +1.36235060E-01
   +1.57959000E-03  -9.93900000E-05  -1.72153000E-03  -7.46420000E-04  +3.59610000E-04
   +7.75100000E-04  +3.35590000E-04  +3.71060000E-04  -4.43800000E-04  -8.69200000E-05
   +2.32000000E-06  +4.79900000E-05  +3.85100000E-05  -2.60300000E-05  -3.61300000E-05
   -1.80960000E-04  -1.69270000E-04  +1.92280000E-04  -1.00570000E-03  +1.49073200E-02
   -2.02463200E-02  -4.36481000E-03  +1.22944510E-01  -2.42360930E-01  -4.30400000E-05
   +3.01000000E-05  +4.18800000E-05  +8.64520000E-04  +1.11116000E-03  +9.86050000E-04
   -2.37600000E-05  -4.22520000E-04  -2.45300000E-05  +1.90250000E-04  +1.47410000E-04
   +4.37000000E-06  -6.89300000E-05  +1.53730000E-04  +1.30930000E-04  -2.38900000E-04
   -1.14530000E-04  +1.60040000E-04  +1.13220000E-04  -2.65170000E-04  -7.98100000E-05
   -2.68600000E-05  -1.71100000E-05  +1.22600000E-05  +1.96590000E-04  -4.53097000E-03
   -4.37713000E-03  -8.50980000E-04  +2.07630000E-03  +9.04670000E-04  -4.30000000E-06
   +9.91000000E-06  -6.26000000E-06  -1.96000000E-05  +2.01100000E-05  -2.76200000E-05
   -2.44700000E-05  +8.34400000E-05  +2.12400000E-05  -4.78810000E-04  +1.58390000E-04
   +4.02300000E-05  -2.34500000E-05  -2.03800000E-05  -9.85000000E-06  -2.28400000E-05
   -7.64500000E-05  +2.44970000E-04  +4.74400000E-05  -1.13860000E-04  +3.65480000E-04
   -5.05910000E-04  +1.07485000E-03  -1.39225000E-03  +5.49379000E-03  -1.35433540E-01
   +2.63853830E-01  -5.57600000E-05  -1.17230000E-04  +3.51760000E-04  +9.16640000E-04
   +1.39163000E-03  +1.62730000E-04  +2.77600000E-04  -3.79420000E-04  +1.97930000E-04
   -8.48000000E-06  +5.01900000E-05  -1.36850000E-04  -6.26400000E-05  -7.15000000E-06
   +4.67600000E-05  +5.96500000E-05  -2.01000000E-05  -3.14600000E-05  -1.99377000E-03
   +3.38820000E-04  +1.13023000E-03  -2.33878010E-01  -1.24097330E-01  +1.21115100E-02
   +5.04100000E-05  -2.26500000E-05  -3.90000000E-06  +6.79290000E-04  +7.10900000E-05
   +9.63000000E-06  +3.71700000E-05  +1.40830000E-04  +2.45100000E-04  -8.58300000E-05
   -9.36600000E-05  -9.69900000E-05  +1.05300000E-04  +7.86900000E-05  -2.26700000E-05
   +1.82590000E-04  -1.51200000E-04  -2.51970000E-04  -2.30290000E-04  +1.56650000E-04
   +4.57730000E-04  -1.69140000E-04  -1.70200000E-04  -4.86800000E-05  -2.38010000E-04
   +6.54300000E-05  +4.07360000E-04  +5.38900000E-05  +8.23300000E-05  -2.50620000E-04
   +1.67000000E-05  +2.00000000E-05  +8.83000000E-06  -3.12200000E-05  -1.33800000E-05
   -2.39600000E-05  +8.16200000E-05  -5.74600000E-05  -4.88600000E-05  +1.67110000E-04
   -1.96790000E-04  -5.10380000E-04  -7.34000000E-06  -2.37000000E-06  +2.09300000E-05
   +9.97900000E-05  -1.17010000E-04  +5.20900000E-05  +2.48550000E-04  +3.47270000E-04
   -5.62740000E-04  +2.97000000E-04  +2.65070000E-04  -4.18200000E-05  +1.73854000E-03
   +1.82305000E-03  +2.09600000E-05  +2.51588480E-01  -4.89210000E-04  -3.93900000E-04
   +9.63340000E-04  -9.03330000E-04  +7.62020000E-04  +2.89910000E-04  +2.96010000E-04
   -6.94800000E-05  -2.43180000E-04  +1.01640000E-04  +5.10400000E-05  -1.26340000E-04
   +1.28960000E-04  -1.40470000E-04  -2.37900000E-05  +3.89600000E-05  -4.38000000E-05
   +3.39700000E-05  -1.63103700E-02  -1.28963000E-02  +5.45590000E-04  -1.22639900E-01
   -1.26913960E-01  +9.74568000E-03  -1.72530000E-04  +1.73370000E-04  -8.00000000E-07
   +1.24116000E-03  -1.35099000E-03  -3.61435000E-03  -1.22298000E-03  -2.47700000E-04
   +1.99380000E-04  -3.54300000E-05  -3.27430000E-04  -1.28640000E-04  +2.92410000E-04
   +9.95200000E-05  -8.11800000E-05  -9.04800000E-05  +1.32740000E-04  +6.92000000E-05
   +5.38810000E-04  +8.96000000E-05  -4.35940000E-04  -2.68770000E-04  -1.77960000E-04
   +9.87000000E-06  +5.40820000E-04  +2.68760000E-04  +1.20859000E-03  +5.74850000E-04
   -3.74390000E-04  -3.63030000E-04  +3.38500000E-05  +3.49300000E-05  +1.62400000E-05
   -8.42300000E-05  -1.16850000E-04  +8.16000000E-06  +1.02300000E-05  +2.85000000E-05
   -7.83900000E-05  +1.72010000E-04  -8.44000000E-06  +3.16280000E-04  -4.34400000E-05
   -8.92000000E-06  -5.03000000E-06  +1.07120000E-04  +6.90900000E-05  +1.49900000E-05
   +4.48000000E-06  +6.15520000E-04  -7.96200000E-05  +2.65450000E-04  +1.00100000E-05
   +1.10600000E-05  -1.43737500E-02  -8.89764000E-03  -3.57840000E-04  +1.34852310E-01
   +1.37668870E-01  +1.89620000E-04  -5.27800000E-05  +1.77550000E-04  -8.94180000E-04
   +7.32220000E-04  +8.17700000E-04  +1.50870000E-04  -2.30600000E-04  +1.81060000E-04
   -5.48200000E-05  +4.01200000E-05  -1.17570000E-04  +9.60100000E-05  -6.48900000E-05
   -2.83000000E-06  -2.10750000E-04  +1.59100000E-05  +6.10000000E-05  -2.27078000E-02
   -1.55097000E-02  -7.75290000E-04  +1.47195800E-02  +1.08938200E-02  -4.76245800E-02
   -1.63070000E-04  +1.17270000E-04  -1.41200000E-05  +1.01563000E-03  -2.20141000E-03
   -4.46100000E-03  -1.46328000E-03  -8.63050000E-04  +3.03630000E-04  +1.46360000E-04
   -2.62900000E-04  -2.12180000E-04  +1.06420000E-04  +1.40290000E-04  -1.09400000E-05
   -1.96900000E-04  -1.03600000E-05  +1.96820000E-04  +8.26000000E-04  -2.94710000E-04
   -4.96310000E-04  -1.50300000E-04  -7.56700000E-05  +2.43300000E-05  -1.03223000E-03
   -1.00454000E-03  +1.37519000E-03  -1.13070000E-04  +4.72160000E-04  -1.33470000E-04
   +2.02700000E-05  +2.12300000E-05  +7.66000000E-06  -1.17640000E-04  -8.36900000E-05
   -2.70300000E-05  -5.90000000E-07  +4.11600000E-05  -2.23000000E-05  -9.83100000E-05
   +4.65800000E-04  +2.23640000E-04  -2.61200000E-05  -3.33600000E-05  +1.03100000E-05
   +6.81300000E-05  -9.96000000E-06  -1.09050000E-04  +2.17750000E-04  +4.07530000E-04
   -6.59120000E-04  +3.40210000E-04  +1.51230000E-04  +2.25040000E-04  +2.39848500E-02
   +1.30759000E-02  -6.05900000E-05  -1.47034600E-02  -6.58284000E-03  +5.21403400E-02
   -1.99300000E-05  -4.68570000E-04  +6.70130000E-04  +4.97320000E-04  +8.17350000E-04
   +6.12650000E-04  +6.13380000E-04  +4.09160000E-04  -5.87050000E-04  -7.36600000E-05
   +6.09400000E-05  -9.90300000E-05  +2.35100000E-04  -1.92330000E-04  -3.26100000E-05
   -1.59660000E-04  -1.23100000E-05  +4.73800000E-05  +7.27890000E-04  -1.47173000E-03
   -3.81680000E-04  -2.09182460E-01  +1.29877680E-01  +4.98325000E-03  -2.80030000E-04
   +2.29270000E-04  +4.36000000E-06  -8.69900000E-05  +2.72200000E-05  +3.58430000E-04
   +1.04430000E-04  +7.12000000E-05  +2.60000000E-07  +6.97400000E-05  +2.75800000E-05
   -1.98900000E-05  -1.94320000E-04  +7.56000000E-06  +4.56700000E-05  +9.53200000E-05
   -1.90770000E-04  -2.62450000E-04  -7.45010000E-04  -7.65450000E-04  +6.24290000E-04
   +9.66200000E-05  +2.89200000E-05  -2.55400000E-05  +4.62910000E-04  -3.69490000E-04
   -6.97970000E-04  +2.48380000E-04  -9.98700000E-05  -2.21050000E-04  -1.92200000E-05
   -1.28700000E-05  -7.26000000E-06  +1.37900000E-05  +2.14900000E-05  -2.60000000E-06
   -1.31400000E-05  -1.50000000E-06  -1.87600000E-05  -1.22430000E-03  -2.07709000E-03
   -1.98570000E-04  +2.71900000E-05  -5.80000000E-07  +2.01500000E-05  +4.05790000E-04
   -1.67410000E-04  +1.50670000E-04  -2.94930000E-04  +8.75400000E-05  +1.34800000E-04
   +2.48050000E-04  -2.96910000E-04  -2.33100000E-05  +9.84000000E-05  -1.29805000E-03
   -3.58800000E-05  -1.98661300E-02  +1.73715400E-02  +1.92500000E-05  +2.28222240E-01
   -2.03800000E-05  +4.02590000E-04  -4.38000000E-06  -2.96110000E-04  -1.25843000E-03
   -3.69258000E-03  -2.07450000E-04  -1.19930000E-03  +8.94350000E-04  +3.41060000E-04
   +1.37100000E-05  +9.81100000E-05  -3.08630000E-04  +2.45480000E-04  -5.16800000E-05
   +2.62070000E-04  +9.81300000E-05  -2.58300000E-05  +1.54242300E-02  -1.18045300E-02
   +2.47250000E-04  +1.28628720E-01  -1.49356510E-01  -3.92893000E-03  +4.26940000E-04
   -3.52060000E-04  +3.98000000E-06  +7.59390000E-04  +5.30970000E-04  +4.36280000E-04
   -3.31610000E-04  -1.97200000E-04  -1.59680000E-04  +1.94620000E-04  +1.97630000E-04
   +4.02700000E-05  -5.98300000E-05  -1.48000000E-06  +1.01350000E-04  -3.65730000E-04
   +2.21950000E-04  +3.98840000E-04  +3.57300000E-04  -5.32320000E-04  -9.12490000E-04
   +9.78600000E-05  +1.48470000E-04  +6.45400000E-05  +2.96280000E-04  +4.75830000E-04
   +1.71536000E-03  -2.69730000E-04  -7.17930000E-04  -7.30000000E-06  -3.76000000E-06
   -1.31800000E-05  -7.90000000E-07  +6.93000000E-06  +1.45000000E-06  +2.08600000E-05
   +2.11300000E-05  +7.11600000E-05  +1.36340000E-04  -1.66789000E-03  -1.16358000E-03
   +7.88830000E-04  -1.57900000E-05  -3.38700000E-05  -1.81700000E-05  -4.40550000E-04
   +6.53390000E-04  -2.48510000E-04  -1.48100000E-04  -8.93000000E-06  -1.32080000E-04
   -3.64760000E-04  +4.07300000E-05  +1.81380000E-04  +1.31105400E-02  -9.90239000E-03
   -1.82789000E-03  -1.43364300E-02  +1.22043000E-02  +3.81330000E-04  -1.41218640E-01
   +1.60807310E-01  +1.28335000E-03  +3.53930000E-04  -1.72317000E-03  -1.57810000E-04
   -3.07114000E-03  -3.97302000E-03  +1.26670000E-04  -1.19489000E-03  +9.51130000E-04
   +2.27390000E-04  +6.58000000E-05  +2.40850000E-04  -2.05640000E-04  +1.82630000E-04
   -1.32150000E-04  +5.36200000E-05  +1.33410000E-04  +7.92900000E-05  +2.10504000E-02
   -1.50371200E-02  -1.99652000E-03  +3.60508000E-03  -2.44559000E-03  -4.80433700E-02
   +4.08620000E-04  -3.28500000E-04  +4.30800000E-05  +1.68090000E-04  +4.43190000E-04
   +5.87230000E-04  -7.16000000E-06  +4.54000000E-06  -2.03180000E-04  +1.03170000E-04
   +6.86500000E-05  -2.72400000E-05  -1.17560000E-04  +2.01200000E-05  +1.38920000E-04
   -8.01200000E-05  -1.35630000E-04  -1.04780000E-04  -3.02510000E-04  +3.90250000E-04
   +3.80730000E-04  +5.57000000E-05  +3.00100000E-05  -2.22100000E-05  +1.48318000E-03
   -1.02657000E-03  +7.47100000E-04  -9.02080000E-04  +6.93340000E-04  +1.01257000E-03
   -6.03000000E-06  -1.46200000E-05  -3.38000000E-06  +1.72000000E-05  -7.13000000E-06
   +8.16000000E-06  +4.26000000E-05  -8.13000000E-06  +3.84800000E-05  +1.63430000E-04
   +8.41800000E-05  +2.08860000E-04  +8.32000000E-06  +0.00000000E+00  +6.61000000E-06
   -6.50900000E-04  -3.29000000E-06  -8.90150000E-04  +1.08310000E-04  +1.75240000E-04
   -5.47900000E-05  -1.42490000E-04  +1.88660000E-04  +3.74350000E-04  -2.23511700E-02
   +1.50649600E-02  +2.32096000E-03  +1.64853000E-03  -1.26547000E-03  -1.03412000E-03
   -5.36091000E-03  +6.18123000E-03  +5.14971600E-02  -4.93050000E-04  +2.21340000E-04
   -1.23592000E-03  -1.68188000E-03  +4.38012000E-03  -3.63580000E-04  -1.32439700E-02
   -5.96367000E-03  +1.85965200E-02  -1.95551940E-01  -1.34495800E-02  +1.48156910E-01
   +4.58388000E-03  +1.66034000E-03  -2.39412000E-03  +1.87991000E-03  +1.71596000E-03
   +2.64540000E-04  +1.35010000E-04  -4.64270000E-04  +8.87100000E-04  -2.74130000E-04
   +1.03460000E-04  -8.35400000E-05  -2.48140000E-04  -1.52539000E-03  -1.09824000E-03
   +1.69000000E-06  +2.29380000E-04  +3.87500000E-05  -3.44900000E-05  +6.42000000E-06
   +1.78000000E-05  -2.88200000E-05  -1.34000000E-05  +6.42000000E-06  +5.10000000E-05
   +3.06800000E-05  +3.29000000E-06  -5.12000000E-06  -1.32300000E-05  +8.90000000E-06
   -6.02300000E-05  -6.51900000E-05  -3.61800000E-05  -6.41800000E-05  -5.19200000E-05
   -1.07300000E-05  +5.92600000E-05  -1.28140000E-04  +9.94400000E-05  +1.20430000E-04
   -2.26800000E-05  +2.44000000E-05  +3.27000000E-06  +7.89000000E-06  +7.13000000E-06
   -1.46500000E-05  -1.45100000E-05  -4.44000000E-06  +4.32000000E-06  +1.64000000E-05
   +1.98800000E-05  +1.14300000E-05  +9.04000000E-06  -8.10000000E-06  -9.43000000E-06
   -6.31000000E-06  +9.90000000E-07  +1.59800000E-05  +4.80300000E-05  -5.31100000E-05
   +8.46000000E-06  +6.19600000E-05  +1.48300000E-05  -2.92700000E-05  -2.11800000E-05
   -5.47100000E-05  +3.36000000E-06  -4.20000000E-06  -4.15000000E-06  +2.25700000E-05
   -4.46000000E-06  -9.90000000E-07  -2.28200000E-05  +9.01200000E-05  +9.39500000E-05
   +2.04158390E-01  +4.09150000E-04  -1.87620000E-03  -1.58260000E-04  +3.74402000E-03
   -3.05450000E-04  +1.75083000E-03  +1.26439500E-02  +3.92304000E-03  -1.19015500E-02
   -1.25337800E-02  -4.91232600E-02  +3.50269400E-02  -1.82978800E-02  +2.85824000E-03
   +1.52916700E-02  +2.42461000E-03  -1.10466000E-03  +4.34666000E-03  +3.95280000E-04
   +6.69820000E-04  -2.52680000E-04  +5.44000000E-05  +4.18300000E-05  +4.97100000E-05
   -1.22704000E-03  -4.49110000E-04  -2.58010000E-03  +2.15740000E-04  -2.22860000E-04
   -8.92400000E-05  -6.61000000E-06  +1.01800000E-05  +1.31100000E-05  -3.45000000E-06
   +8.84000000E-06  -8.98000000E-06  -7.92000000E-06  -2.29200000E-05  -7.43000000E-06
   +2.31700000E-05  +2.91200000E-05  -2.04400000E-05  +3.20600000E-05  +4.45300000E-05
   +3.73200000E-05  +2.46300000E-05  +1.78800000E-05  -2.00000000E-07  -5.09400000E-05
   +9.61900000E-05  -7.07300000E-05  -2.52540000E-04  +3.08810000E-04  +1.41000000E-05
   -2.05000000E-06  -2.27000000E-06  +2.27000000E-06  -2.86000000E-06  -1.11000000E-06
   +3.17000000E-06  +1.70000000E-06  +7.83000000E-06  +1.15800000E-05  +4.07000000E-06
   -1.10900000E-05  -1.28000000E-06  +7.84000000E-06  +5.77000000E-06  -2.47000000E-06
   -8.09000000E-06  -1.00200000E-05  +1.97300000E-05  -2.37500000E-05  -2.51500000E-05
   -3.47000000E-06  +9.03000000E-06  +1.69500000E-05  +6.92000000E-06  +3.65000000E-06
   -1.95000000E-05  -2.10200000E-05  -1.51100000E-05  -1.20500000E-05  -9.36000000E-06
   -5.09000000E-06  -9.62000000E-06  -2.19900000E-05  +1.37117300E-02  +4.54278300E-02
   -1.25938000E-03  -2.05570000E-04  -5.33790000E-04  +3.73190000E-04  +1.22032000E-03
   +2.33377000E-03  -2.18378000E-03  +3.16835000E-03  +5.12820000E-04  +1.47335600E-01
   +3.52765900E-02  -1.79818640E-01  +1.92138700E-02  +2.16000000E-06  -1.12835700E-02
   -4.87090000E-04  +4.94638000E-03  -3.97000000E-04  -7.20500000E-05  +3.96550000E-04
   +2.16780000E-04  -7.00000000E-07  +4.37200000E-05  +1.85100000E-05  -1.27942000E-03
   -2.48316000E-03  -3.05800000E-05  +1.35810000E-04  -9.24700000E-05  -1.65900000E-05
   +9.99000000E-06  -2.54000000E-06  +1.64700000E-05  -8.40000000E-07  -1.59600000E-05
   -9.30000000E-06  -3.16500000E-05  -3.80200000E-05  -1.49100000E-05  +1.82200000E-05
   +2.74600000E-05  +3.49000000E-06  -4.28000000E-06  -7.40000000E-07  +3.59100000E-05
   +4.74300000E-05  +3.13100000E-05  +4.30000000E-06  +1.64300000E-05  +9.30000000E-07
   +8.40000000E-07  +1.75820000E-04  -7.53100000E-05  +9.23000000E-05  -9.39000000E-06
   -4.64000000E-06  -3.11000000E-06  -3.62000000E-06  +3.37000000E-06  -9.00000000E-08
   -1.62700000E-05  +8.82000000E-06  -1.76600000E-05  +1.40000000E-07  -6.00000000E-08
   -4.39000000E-06  +2.43000000E-06  +5.05000000E-06  -5.05000000E-06  -1.35000000E-06
   -1.54400000E-05  +2.16100000E-05  -1.89800000E-05  -3.42300000E-05  +5.91000000E-06
   +1.90000000E-05  +5.02000000E-06  +5.04000000E-06  -9.46000000E-06  +8.66000000E-06
   +7.49000000E-06  -3.43000000E-06  -1.78000000E-06  -3.26000000E-06  +1.07400000E-05
   +1.84000000E-06  +8.47000000E-06  -1.60331890E-01  -3.92346500E-02  +1.87733880E-01
   +1.22980000E-03  +1.69590400E-02  -1.81959900E-02  -2.72576000E-03  +3.44094000E-03
   +1.85238000E-03  -1.81487000E-03  -1.05060000E-04  +3.61980000E-04  -2.09838000E-03
   +1.11438000E-03  +4.12463000E-03  +5.60015000E-03  -1.60856900E-02  +1.55719400E-02
   -5.37374700E-02  +2.75077700E-02  -6.65152000E-03  +5.76160000E-04  +6.91850000E-04
   -8.96480000E-04  -1.10600000E-05  -7.77100000E-05  -8.05400000E-05  +1.40054000E-03
   -2.80910000E-03  -1.60399000E-03  +1.92700000E-04  +1.10110000E-04  -3.80000000E-07
   -3.45000000E-06  -4.08100000E-05  +1.37800000E-05  -1.07200000E-05  -3.46500000E-05
   +1.21300000E-05  +1.23200000E-05  +2.40400000E-05  +8.82000000E-06  -1.20800000E-05
   -2.39000000E-05  +5.42000000E-06  -1.56900000E-05  -3.19900000E-05  -9.00000000E-08
   -3.54700000E-05  -4.47600000E-05  +2.78000000E-06  -3.59470000E-04  +1.04780000E-04
   +1.60840000E-04  +1.03039000E-03  -1.23403000E-03  -3.08287000E-03  -7.95000000E-06
   +1.16000000E-05  -6.16000000E-06  -1.73300000E-05  -3.78000000E-06  -1.79400000E-05
   +4.24000000E-06  +3.20000000E-05  -1.10000000E-06  +4.35000000E-06  +1.08100000E-05
   -8.88000000E-06  -9.50000000E-06  -6.30000000E-07  -2.35000000E-06  -3.35900000E-05
   +1.06660000E-04  -1.14840000E-04  +5.77000000E-06  +3.70000000E-06  +1.20000000E-05
   -2.84000000E-06  -1.67300000E-05  -1.31000000E-05  +9.73000000E-06  +4.07700000E-05
   +2.93900000E-05  -6.31000000E-06  -1.24400000E-05  +1.38300000E-05  -2.10000000E-05
   +1.75800000E-05  +3.95000000E-05  +3.86170000E-04  -6.75310000E-04  +1.00679000E-03
   +5.18912300E-02  -2.51692000E-03  -9.79504000E-03  +1.58323300E-02  +4.27929000E-03
   +1.02775000E-03  +2.80210000E-04  +1.95720000E-04  -4.69330000E-04  -1.28224000E-03
   +2.40880000E-04  +3.14088000E-03  +1.43673000E-03  +3.37535000E-03  -1.59852000E-03
   +1.53638000E-03  +2.79927600E-02  -1.74796790E-01  +1.48657310E-01  -3.30490000E-04
   -8.04100000E-05  +9.80130000E-04  +4.98300000E-05  +2.62000000E-06  +1.16700000E-04
   -2.24854000E-03  -8.87600000E-05  -2.99797000E-03  -1.10330000E-04  -1.57980000E-04
   -3.49800000E-05  +8.74000000E-06  +3.93600000E-05  +3.33000000E-05  +4.79000000E-06
   -1.99100000E-05  -1.39300000E-05  -4.89000000E-05  -5.45400000E-05  -1.17800000E-05
   +4.16200000E-05  +4.35200000E-05  -5.90000000E-06  -8.54000000E-06  +4.28600000E-05
   +4.09000000E-06  +7.53500000E-05  +5.51300000E-05  -5.60000000E-07  +3.39190000E-04
   -1.30820000E-04  -1.72430000E-04  -2.67244000E-03  -2.47490000E-04  -2.71425000E-03
   -1.22600000E-05  -9.16000000E-06  -1.16000000E-06  -1.70000000E-07  +6.37000000E-06
   +1.10000000E-06  -9.37000000E-06  -9.61000000E-06  -3.69300000E-05  +3.00000000E-06
   -1.84800000E-05  +2.67000000E-06  +1.34200000E-05  +2.06000000E-06  -9.50000000E-07
   +4.25200000E-05  -1.04740000E-04  +9.46500000E-05  -1.29100000E-05  -3.36000000E-06
   +4.50000000E-07  -1.91900000E-05  +1.46400000E-05  -8.42000000E-06  +1.65200000E-05
   +1.56600000E-05  -4.67600000E-05  -1.50300000E-05  -1.45000000E-06  +1.31300000E-05
   +1.95800000E-05  -3.56100000E-05  -5.22000000E-05  +2.75930000E-04  +2.36410000E-04
   +3.93730000E-04  -3.03080100E-02  +1.82566280E-01  +3.11098000E-03  +2.21920000E-04
   -4.52650000E-04  +9.01800000E-04  +9.48220000E-04  +2.56028000E-03  +4.02820000E-04
   -1.25175000E-03  -3.87720000E-04  +4.89685000E-03  +8.70750000E-04  -3.95880000E-04
   -7.04214000E-03  +1.72044200E-02  -1.15658300E-02  -6.49855000E-03  +1.49319970E-01
   -1.88090340E-01  +4.03350000E-04  +8.97500000E-05  +1.38320000E-04  -6.73200000E-05
   +1.00000000E-05  -1.17800000E-05  -1.96470000E-03  -2.66159000E-03  +3.08140000E-04
   +2.70300000E-05  +4.63900000E-05  +3.00500000E-05  +1.59600000E-05  -3.72900000E-05
   +5.00000000E-07  -1.75300000E-05  -2.41900000E-05  +2.56700000E-05  +2.33500000E-05
   +3.61100000E-05  +1.89800000E-05  -7.45000000E-06  -2.82200000E-05  -5.68000000E-06
   -2.54800000E-05  -8.28000000E-06  -1.89800000E-05  -5.12900000E-05  -6.03100000E-05
   +1.33000000E-06  -6.75700000E-05  -2.35900000E-05  +3.19100000E-05  -1.51190000E-03
   -3.66262000E-03  +6.84450000E-04  -7.54000000E-06  +1.72100000E-05  -6.24000000E-06
   -1.86100000E-05  -1.64000000E-06  -2.42800000E-05  +1.41700000E-05  +3.68600000E-05
   +1.78000000E-06  +7.07000000E-06  +3.74000000E-06  -8.37000000E-06  -6.24000000E-06
   -1.33000000E-06  -4.30000000E-07  -3.18200000E-05  +1.94600000E-05  -5.16000000E-06
   +7.61000000E-06  -3.23100000E-05  +4.31000000E-06  +1.71400000E-05  +1.26000000E-06
   -6.40000000E-07  +1.29200000E-05  +3.37800000E-05  +1.35600000E-05  -1.00600000E-05
   -3.38100000E-05  +1.23000000E-06  -2.21700000E-05  +2.83900000E-05  +3.20300000E-05
   -1.84100000E-05  +1.16374000E-03  -4.71400000E-04  +6.40510000E-03  -1.62867460E-01
   +1.97184320E-01  -1.41758000E-03  +5.91630000E-04  -2.30050000E-04  -6.97100000E-05
   -4.72460000E-04  +5.78510000E-04  +1.55834000E-03  +1.56904000E-03  -1.14812000E-03
   -4.58168000E-03  +3.07739000E-03  +2.09576000E-03  -3.66478000E-03  +3.05901900E-02
   -3.29200600E-02  +1.31467000E-03  -4.20220000E-04  -1.73491000E-03  -1.76170000E-04
   -7.30000000E-06  +1.06380000E-04  +3.87600000E-05  +4.36000000E-06  -7.23000000E-06
   -3.66531600E-02  -1.98897300E-02  +4.84074600E-02  -1.53500000E-05  -3.71300000E-05
   -1.49100000E-05  +4.59000000E-06  -1.15900000E-05  +3.19400000E-05  +3.55500000E-05
   -3.47600000E-05  -2.01200000E-05  -1.25400000E-04  -8.21500000E-05  -9.41000000E-06
   +1.46000000E-05  +2.11500000E-05  +2.11200000E-05  -8.23000000E-06  +3.49000000E-06
   +2.81200000E-05  +1.37400000E-04  +8.96300000E-05  +1.14700000E-05  +7.06800000E-05
   -1.21400000E-05  -3.43200000E-05  +6.87450000E-04  -2.53710000E-04  -3.25970000E-04
   -2.99300000E-05  -1.48200000E-05  -1.09600000E-05  -7.00000000E-06  +1.37300000E-05
   -3.50000000E-06  -1.39600000E-05  +5.94000000E-06  -4.02600000E-05  -1.09900000E-05
   +2.95000000E-06  -5.15000000E-06  +6.64000000E-06  +3.21000000E-06  -7.49000000E-06
   +2.65300000E-05  -2.88000000E-05  +1.68600000E-05  -1.64200000E-05  +1.57000000E-06
   +4.80000000E-07  -1.35500000E-05  +9.33000000E-06  +8.10000000E-07  -1.36200000E-05
   +4.53400000E-05  +1.61200000E-05  -1.18400000E-05  +2.10000000E-06  +1.64300000E-05
   +2.67600000E-05  -3.05400000E-05  -5.89000000E-06  -1.40700000E-04  -2.22700000E-04
   -2.16520000E-04  -5.98520000E-04  -4.59930000E-04  +1.77098000E-03  +4.43802800E-02
   +2.72310000E-04  -1.15078000E-03  +1.10990000E-04  -4.55500000E-05  +4.15540000E-04
   -4.56390000E-04  -8.61900000E-05  +2.69330000E-04  +2.09114000E-03  +4.46419000E-03
   +2.91160000E-04  -1.28586000E-03  +4.15100000E-05  -2.34665500E-02  +2.26732700E-02
   -3.68979000E-03  +2.86254000E-03  -1.70491000E-03  +2.06840000E-04  -8.89900000E-05
   -1.29000000E-06  -1.00150000E-04  +4.06300000E-05  -2.85600000E-05  +1.23695200E-02
   -2.36852020E-01  +2.46619010E-01  +2.15300000E-05  +1.09360000E-04  +5.81000000E-06
   -1.16700000E-05  -9.81000000E-06  -1.16700000E-05  -3.45200000E-05  +1.13600000E-05
   +4.13100000E-05  +1.22880000E-04  +1.05080000E-04  +2.57100000E-05  -2.08000000E-05
   -4.64000000E-05  -2.28700000E-05  -1.10000000E-05  -2.09200000E-05  -3.42200000E-05
   -1.55310000E-04  -1.33650000E-04  -9.11000000E-06  -6.36000000E-05  -1.02200000E-05
   +3.84200000E-05  -6.57200000E-04  +1.51950000E-04  +3.06140000E-04  +1.35800000E-05
   +3.21100000E-05  +3.49000000E-06  -1.68800000E-05  -1.44600000E-05  -2.03600000E-05
   +2.65700000E-05  +3.21100000E-05  +3.87900000E-05  +1.69800000E-05  +5.50000000E-07
   -7.04000000E-06  -1.03600000E-05  -3.70000000E-06  +4.88000000E-06  -2.75200000E-05
   +3.53900000E-05  -1.32400000E-05  +1.12700000E-05  -1.28000000E-05  +6.85000000E-06
   +1.46100000E-05  -7.21000000E-06  -9.24000000E-06  +2.27900000E-05  -2.22000000E-05
   -1.61600000E-05  +2.93000000E-06  -3.54800000E-05  -9.38000000E-06  -3.98200000E-05
   +5.00100000E-05  +2.76600000E-05  -2.50500000E-04  -5.43800000E-05  -5.09550000E-04
   +1.07965000E-03  +3.02910000E-04  -2.63810000E-04  -1.38210600E-02  +2.57234080E-01
   +1.22140000E-04  -1.85130000E-04  -7.82390000E-04  +9.54200000E-05  -6.96600000E-05
   -5.83000000E-06  +5.36710000E-04  +8.29620000E-04  +8.36630000E-04  +6.62710000E-04
   -3.02730000E-04  +2.11430000E-03  +6.33690000E-04  -1.68925000E-03  -1.44761000E-03
   +1.89211000E-03  -4.32614000E-03  +2.01891000E-03  -9.00400000E-05  +5.68400000E-05
   -1.08550000E-04  +9.84200000E-05  -5.32600000E-05  +4.53400000E-05  +1.29490000E-02
   +2.72441680E-01  -3.13361610E-01  +3.65900000E-05  -6.16900000E-05  -4.79000000E-06
   +3.77000000E-06  +1.65900000E-05  +3.23900000E-05  +6.54000000E-06  -1.69600000E-05
   -5.94000000E-06  -3.30000000E-05  -3.21800000E-05  -7.98000000E-06  +1.92100000E-05
   +2.65700000E-05  -3.63000000E-06  -1.18300000E-05  +3.24000000E-06  +1.42100000E-05
   +4.55900000E-05  +3.12400000E-05  -3.47000000E-06  -5.40000000E-07  +1.79000000E-05
   -2.02100000E-05  +1.35980000E-04  +1.10500000E-05  -1.65240000E-04  -9.99000000E-06
   -4.06000000E-06  +1.79000000E-06  -7.48000000E-06  +1.25000000E-06  -1.55000000E-06
   -4.39000000E-06  +4.09000000E-06  -2.63400000E-05  +2.11000000E-06  -9.41000000E-06
   -1.00000000E-08  +7.10000000E-06  +3.20000000E-07  -1.71000000E-06  +8.79000000E-06
   -6.90000000E-06  +6.20000000E-07  -5.18000000E-06  -2.95000000E-06  +1.44000000E-06
   -3.73000000E-06  +4.07000000E-06  -2.56000000E-06  +6.77000000E-06  +7.12000000E-06
   -6.05000000E-06  -3.58000000E-06  +7.93000000E-06  +1.64800000E-05  +1.69300000E-05
   -2.88000000E-05  -4.21000000E-05  -1.74450000E-04  -5.35830000E-04  -8.92000000E-06
   +2.04700000E-05  +9.94570000E-04  -3.39110000E-04  -1.70040300E-02  -2.67114080E-01
   +3.11458540E-01  +4.25762000E-03  -2.93960800E-02  +2.26763100E-02  -3.60859000E-03
   +6.70600000E-04  +4.02525000E-03  +1.89769000E-03  -6.60820000E-04  +8.78230000E-04
   -5.87020000E-04  +6.77260000E-04  -3.26550000E-04  -1.32800000E-03  -3.59590000E-04
   +6.22590000E-04  +4.09100000E-04  -2.51910000E-03  +1.39979000E-03  -1.79420000E-04
   -1.17680000E-04  +1.19050000E-04  -7.53200000E-05  +2.62600000E-05  -2.15000000E-06
   +4.91280000E-04  -6.84200000E-05  -3.23710000E-04  +2.86380000E-04  +1.34500000E-04
   -9.82800000E-05  +1.37040000E-04  +3.17390000E-04  -8.92000000E-06  -2.19110000E-04
   -1.78730000E-04  +1.61670000E-04  +1.33690000E-04  -9.83200000E-05  -1.54740000E-04
   +6.80000000E-06  -7.25700000E-05  +1.11020000E-04  -4.74200000E-05  +8.66100000E-05
   -1.17920000E-04  -2.13140000E-04  -1.97770000E-04  +4.03900000E-05  -6.36400000E-05
   -7.06300000E-05  -1.09200000E-05  -5.92048100E-02  +1.22800240E-01  -6.77412400E-02
   -3.46700000E-05  +3.38400000E-05  -3.30900000E-05  -2.92300000E-05  +3.11000000E-06
   -3.69400000E-05  +5.75000000E-06  +3.89200000E-05  +1.19800000E-05  +4.82500000E-05
   +4.86000000E-05  -2.93400000E-05  -7.63300000E-05  +3.42000000E-05  -2.07000000E-05
   -2.13900000E-05  +3.32400000E-05  -2.05900000E-05  -1.72200000E-05  -3.73900000E-05
   +9.92000000E-06  +6.72000000E-06  +2.49200000E-05  -4.10700000E-05  +1.06920000E-04
   -2.61340000E-04  -2.59960000E-04  +1.36000000E-06  +3.35200000E-05  -9.60000000E-06
   -2.46400000E-05  +1.47070000E-04  -9.56900000E-05  +9.91000000E-06  +1.87350000E-04
   -1.14320000E-04  -1.06646000E-03  +1.86684000E-03  -5.19540000E-04  -2.53690000E-04
   +1.51110000E-04  +1.39020000E-04  +5.97490700E-02  +1.66821000E-03  -6.05574000E-03
   +2.54170000E-03  -1.63660000E-04  +2.29017000E-03  -4.07160000E-04  +8.26200000E-04
   +5.71510000E-04  +7.78450000E-04  +1.68420000E-04  +2.93690000E-04  -3.74880000E-04
   +5.24600000E-05  -9.84090000E-04  +2.47640000E-04  +2.02158000E-03  +1.82040000E-03
   -5.36767000E-03  +1.77400000E-04  +1.17230000E-04  -5.36520000E-04  -1.07540000E-04
   -1.91770000E-04  -3.02510000E-04  +3.04740000E-04  -1.50350000E-04  -1.52810000E-04
   +1.89100000E-04  -1.01680000E-04  +2.68190000E-04  +2.49300000E-05  -7.05700000E-05
   -1.17540000E-04  +4.22400000E-05  -6.81700000E-05  +3.46900000E-05  +1.80000000E-05
   +9.85100000E-05  +8.16000000E-05  -4.51700000E-05  -5.09700000E-05  -3.17100000E-05
   -8.19900000E-05  +4.04200000E-05  +4.57200000E-05  -8.25700000E-05  -1.18970000E-04
   +5.43000000E-06  -4.35400000E-05  -3.17100000E-05  -2.08000000E-06  +8.85620300E-02
   -3.46180970E-01  +2.49477700E-01  -2.25400000E-05  +3.14300000E-05  -2.70100000E-05
   -2.50300000E-05  +3.58000000E-06  -4.83200000E-05  +1.67200000E-05  +5.69300000E-05
   +6.21000000E-06  +1.59400000E-05  -3.68700000E-05  -5.38000000E-06  -4.70000000E-06
   +7.51000000E-06  -1.13000000E-06  -2.20500000E-05  +2.46300000E-05  -8.92000000E-06
   +1.11000000E-06  -2.51500000E-05  +1.24700000E-05  +8.19000000E-06  +9.38000000E-06
   -2.01100000E-05  +1.07540000E-04  -1.20080000E-04  +4.64220000E-04  +1.75900000E-05
   -1.27830000E-04  +7.43300000E-05  -5.25900000E-05  -3.36500000E-05  +9.08600000E-05
   -3.45000000E-06  -1.87100000E-05  +3.27400000E-05  +1.57940000E-04  +9.92300000E-05
   +8.53540000E-04  +5.11200000E-05  +9.92100000E-05  -2.48200000E-05  -9.36218000E-02
   +3.48949070E-01  -5.81295000E-03  +2.95206000E-02  -2.66029100E-02  +4.92801000E-03
   -8.48460000E-04  -4.66430000E-04  -4.34580000E-04  +2.08501000E-03  -3.77790000E-04
   -1.63350000E-04  -4.33530000E-04  +6.68460000E-04  +1.52760000E-04  -1.43500000E-04
   -1.36363000E-03  -3.43706000E-03  -1.51067000E-03  +2.65630000E-03  +1.23800000E-05
   -3.06390000E-04  -5.78300000E-05  +1.45690000E-04  -5.04720000E-04  -2.32700000E-05
   -6.60890000E-04  +2.17070000E-04  +2.62260000E-04  -1.71820000E-04  -4.11900000E-05
   -1.10870000E-04  +9.21500000E-05  +1.06200000E-04  -1.78000000E-06  +3.69500000E-05
   -1.73920000E-04  +6.00000000E-08  -2.32630000E-04  -1.12090000E-04  +6.14900000E-05
   +8.11000000E-06  +5.00900000E-05  -3.57200000E-05  -1.60900000E-05  +8.08400000E-05
   -4.22900000E-05  +1.88330000E-04  +1.25610000E-04  -2.13200000E-05  +1.36300000E-05
   -3.32500000E-05  -5.74500000E-05  -3.65715000E-02  +2.20032970E-01  -1.80896900E-01
   -4.63800000E-05  -2.34800000E-05  -4.24000000E-06  -1.73200000E-05  +1.93000000E-05
   -2.33800000E-05  -8.55000000E-06  +2.43300000E-05  -8.68300000E-05  -5.04000000E-06
   -6.40100000E-05  +1.57000000E-05  +4.64800000E-05  -1.40100000E-05  +3.47000000E-06
   +2.68600000E-05  -2.41000000E-05  -2.30000000E-07  -1.35100000E-05  -1.92000000E-06
   +2.05600000E-05  -2.35700000E-05  +1.53900000E-05  -1.18500000E-05  -4.30600000E-05
   +2.88690000E-04  +2.76620000E-04  +5.98000000E-06  -5.52500000E-05  +7.48200000E-05
   +2.36500000E-05  -1.16220000E-04  +4.66000000E-05  +4.58400000E-05  -4.51700000E-05
   +9.04600000E-05  +1.30191000E-03  -1.93590000E-04  +6.73920000E-04  +2.12680000E-04
   -8.61200000E-05  +5.36700000E-05  +4.00127300E-02  -2.47474950E-01  +2.05473580E-01
   -7.75672000E-03  +8.49148000E-03  +5.32290000E-04  +8.17008000E-03  -2.77103200E-02
   +2.87173600E-02  -9.82804300E-02  +1.47052100E-02  +2.47967000E-02  -3.48170000E-04
   +3.53008600E-02  -2.82069400E-02  -4.25681000E-03  -5.63300000E-04  +1.05213600E-02
   +4.89407000E-03  -2.01147000E-03  -2.90937000E-03  +5.47750000E-04  -8.12870000E-04
   -2.04729000E-03  +4.89750000E-04  -4.67810000E-04  +1.51160000E-04  +1.21340000E-04
   +1.72995000E-03  -2.04987000E-03  +2.05550000E-04  +1.82180000E-04  +9.22800000E-05
   +1.40410000E-04  +3.99600000E-05  +5.25300000E-05  -2.53800000E-05  -2.13300000E-05
   +6.68200000E-05  +1.92370000E-04  +1.58390000E-04  +1.11000000E-05  -1.21800000E-05
   -4.53800000E-05  -2.46800000E-05  +4.48500000E-05  -4.44400000E-05  -4.72700000E-05
   -2.25260000E-04  -1.75410000E-04  -1.49900000E-05  -9.46749000E-03  +4.56268000E-03
   -3.32540000E-04  +1.01883000E-03  -2.09574000E-03  +1.46435000E-03  +2.73600000E-05
   +3.97800000E-05  +5.83000000E-06  -1.34700000E-05  -1.06800000E-05  -2.30100000E-05
   +6.49000000E-05  +1.48700000E-04  -7.91500000E-05  +6.54000000E-06  +1.52300000E-05
   -1.72800000E-05  -1.68400000E-05  -1.55000000E-06  +4.00000000E-06  -1.18749000E-03
   -1.22640000E-04  +1.36322000E-03  -5.47167000E-03  +7.47670000E-04  +1.40934000E-03
   -2.03902000E-03  +1.82398000E-03  +2.13901000E-03  +5.06400000E-05  +2.97000000E-06
   +8.48000000E-05  +3.35400000E-05  +3.84500000E-05  -5.55000000E-06  +1.64600000E-05
   -6.31200000E-05  -2.54950000E-04  +1.11711000E-03  -9.85850000E-04  -3.38378000E-03
   +3.20960000E-04  -6.62900000E-05  -2.23880000E-04  -5.20750000E-04  +1.87720000E-04
   -9.65400000E-05  -4.46060000E-04  -1.26200000E-04  +4.14940000E-04  +4.83689800E-01
   +3.30588000E-03  +3.93264000E-03  -1.48928000E-03  -5.69196000E-03  -3.88096000E-03
   +1.49357800E-02  +4.93925800E-02  -1.83870460E-01  +1.09141880E-01  +1.27851300E-02
   -3.37913400E-02  +3.95938600E-02  +6.16184000E-03  +6.73068000E-03  -3.40035000E-03
   -1.43985000E-03  -4.25618000E-03  +3.91781000E-03  +1.40270000E-03  -2.73323000E-03
   -4.11360000E-04  -1.27466000E-03  +3.91060000E-04  -6.81880000E-04  +5.50440000E-04
   -1.85353000E-03  +1.54390000E-03  -7.18610000E-04  +1.10082000E-03  -1.91590000E-04
   -2.80970000E-04  +9.86900000E-05  -1.05630000E-04  +3.09000000E-05  +1.60270000E-04
   -6.00400000E-05  +1.93720000E-04  +2.47950000E-04  +1.92170000E-04  -1.52400000E-04
   -2.13330000E-04  -3.82000000E-06  -6.19700000E-05  +5.21000000E-06  -3.21900000E-04
   -3.05430000E-04  -1.88560000E-04  -6.40900000E-05  +1.83849000E-03  -2.40156000E-03
   -7.19710000E-04  -1.02993000E-03  +2.39810000E-04  +5.22080000E-04  +6.52600000E-05
   +5.35000000E-06  +4.96800000E-05  +1.08400000E-05  -5.63000000E-05  +1.65700000E-05
   +2.16050000E-04  -1.13860000E-04  +2.89430000E-04  +2.02400000E-05  -1.75000000E-06
   +3.33600000E-05  -1.00200000E-05  -5.68000000E-05  +4.33100000E-05  +8.43620000E-04
   +1.01721000E-03  -6.39010000E-04  +3.15271000E-03  +1.14984000E-03  -5.77850000E-04
   -3.91420000E-04  -5.08100000E-05  -3.83940000E-04  +2.31070000E-04  -1.59270000E-04
   -3.30790000E-04  +1.37530000E-04  -8.43400000E-05  +2.25270000E-04  -3.27030000E-04
   +4.62940000E-04  +4.25100000E-04  -2.79748000E-03  -2.62710000E-04  -2.60484000E-03
   -5.12400000E-05  -1.51000000E-05  +1.82800000E-04  -2.93650000E-04  -1.33060000E-04
   -3.79000000E-05  +4.69820000E-04  -5.46200000E-05  -4.84580000E-04  -9.35209000E-02
   +2.49080760E-01  +6.36394000E-03  -5.35125000E-03  +6.24551000E-03  +5.30522000E-03
   +3.25988900E-02  -3.21545100E-02  -1.26574800E-02  +1.35420990E-01  -1.81606610E-01
   -3.47564000E-03  +2.22213000E-02  -7.80869000E-03  +3.11440000E-03  +2.00289000E-03
   +3.46397000E-03  -3.56782000E-03  +4.42693000E-03  -3.41282000E-03  -4.75151000E-03
   +2.68110000E-04  -8.70050000E-04  +1.38978000E-03  -9.13290000E-04  +7.68420000E-04
   -7.97490000E-04  +6.06920000E-04  -1.47040000E-04  -3.96500000E-05  -6.21640000E-04
   +3.80260000E-04  +6.28700000E-04  -2.36630000E-04  +3.72300000E-05  +5.73500000E-05
   -1.67140000E-04  +1.22390000E-04  -2.92340000E-04  -2.89880000E-04  -1.92140000E-04
   +9.28500000E-05  +1.97110000E-04  +8.82900000E-05  -2.42000000E-06  +3.26400000E-05
   +2.36200000E-04  +4.27500000E-04  +3.04690000E-04  +9.01600000E-05  +2.30660000E-03
   -2.54405000E-03  -3.11500000E-04  +4.46350000E-04  +1.37513000E-03  -1.72016000E-03
   -6.88500000E-05  -1.90600000E-05  -7.36900000E-05  +3.55600000E-05  +1.08820000E-04
   -1.50000000E-05  -1.32640000E-04  +2.50880000E-04  -5.45880000E-04  -7.85600000E-05
   +1.44600000E-05  +1.25000000E-06  +1.42700000E-05  +4.94700000E-05  -3.89900000E-05
   +4.54390000E-04  +9.81000000E-05  +6.41880000E-04  +2.70821000E-03  -1.00715000E-03
   -7.17580000E-04  +1.03644000E-03  +3.77190000E-04  +8.66530000E-04  -1.65860000E-04
   +2.50080000E-04  +4.14250000E-04  -1.32840000E-04  +8.08500000E-05  -5.47800000E-05
   +3.26820000E-04  -6.17110000E-04  -4.87090000E-04  -1.52239000E-03  -3.92870000E-03
   +8.48750000E-04  -2.01490000E-04  +6.08200000E-05  -3.21400000E-05  +4.05050000E-04
   -4.30460000E-04  -2.63640000E-04  -3.23420000E-04  -9.92900000E-05  +1.26300000E-05
   -2.54189430E-01  -1.63828170E-01  +4.00105450E-01  +6.11610000E-04  +8.92500000E-05
   +7.93710000E-04  +1.87121000E-03  +1.65042000E-03  -1.38667000E-03  -1.26760000E-04
   -2.70770000E-04  -1.30937000E-03  +2.32109000E-03  +2.78103000E-03  -5.99881000E-03
   -1.08045000E-03  +1.79790000E-04  -2.29180000E-04  -2.59000000E-04  +4.87790000E-04
   -2.82340000E-04  -8.46000000E-06  +4.84600000E-05  -4.48920000E-04  +9.41000000E-05
   -2.44500000E-05  +2.05900000E-05  -8.54200000E-05  +6.24700000E-05  -6.01000000E-05
   +1.04740000E-04  -6.53100000E-05  -1.05000000E-05  -3.63900000E-05  +4.39100000E-05
   +6.37900000E-05  -1.61000000E-06  -2.53100000E-05  -3.21500000E-05  -3.92800000E-05
   -4.32200000E-05  -1.70000000E-05  +3.28500000E-05  +3.22800000E-05  -3.20000000E-07
   -1.91000000E-05  -1.88300000E-05  +2.00300000E-05  +5.48400000E-05  +3.74900000E-05
   -4.79000000E-06  -6.09470000E-04  +5.54310000E-04  -7.12700000E-05  -1.66420000E-04
   -7.43600000E-05  +4.62300000E-05  -1.25000000E-05  -1.06600000E-05  +3.01000000E-06
   -6.72000000E-06  -6.33000000E-06  +7.33000000E-06  +6.46000000E-06  -1.56800000E-05
   +6.90000000E-06  +4.91000000E-06  -5.15000000E-06  -8.25000000E-06  +4.04000000E-06
   +1.84000000E-06  -4.35000000E-06  -1.52390000E-04  -9.63400000E-05  +2.82880000E-04
   -3.73340000E-04  -2.38650000E-04  -4.48300000E-05  -1.90700000E-05  +2.23050000E-04
   +2.97580000E-04  -4.89000000E-06  +3.42000000E-06  +5.90000000E-06  -1.30200000E-05
   +6.63000000E-06  +1.74500000E-05  +1.84700000E-05  -3.27800000E-05  -4.61900000E-05
   -6.69340000E-04  +4.28600000E-04  +1.06275000E-03  -7.66200000E-05  -2.00000000E-06
   +9.50500000E-05  +4.07800000E-05  +1.59600000E-05  +5.71000000E-06  -5.14300000E-05
   -2.86200000E-05  -1.07800000E-05  -3.71084550E-01  +2.75386600E-02  +2.57286410E-01
   +3.69731140E-01  -1.18055000E-03  +1.45842000E-03  +1.32721000E-03  +2.24854000E-03
   -2.82610000E-03  +3.63641000E-03  -3.04179300E-02  -2.46467000E-03  +2.41452900E-02
   -2.46650000E-03  -2.61200000E-04  +5.44590000E-04  +1.86040000E-04  -1.44070000E-03
   +3.19610000E-04  +5.64850000E-04  -1.01010000E-04  -3.04370000E-04  -5.95800000E-05
   -2.97920000E-04  -8.77100000E-05  +6.96200000E-05  +4.77000000E-05  -1.84700000E-05
   -3.86620000E-04  +4.67550000E-04  -2.97840000E-04  +4.84100000E-05  -7.19000000E-05
   -6.80000000E-06  -6.00800000E-05  +2.29500000E-05  +5.68500000E-05  +2.60100000E-05
   -2.98300000E-05  -3.26700000E-05  -8.92400000E-05  -6.68700000E-05  -1.04500000E-05
   +2.59400000E-05  +2.42400000E-05  +8.39000000E-06  -2.52700000E-05  -6.21000000E-06
   +2.42700000E-05  +1.07020000E-04  +6.54800000E-05  +4.12000000E-06  +5.45370000E-04
   -7.10900000E-04  -7.47700000E-05  +5.73190000E-04  -4.08710000E-04  -3.22620000E-04
   -2.38200000E-05  -1.04500000E-05  -5.07000000E-06  -1.14600000E-05  +4.28000000E-06
   +2.52000000E-06  -5.24000000E-06  -2.88000000E-06  +3.21000000E-06  +1.03000000E-06
   -5.08000000E-06  -6.00000000E-06  +6.12000000E-06  +3.33000000E-06  -7.45000000E-06
   +3.60030000E-04  +1.53230000E-04  -1.10310000E-04  +4.50940000E-04  +3.88790000E-04
   -1.38360000E-04  -1.57710000E-04  -1.38200000E-05  -4.55700000E-05  -1.28300000E-05
   +8.04000000E-06  -2.47600000E-05  -2.88800000E-05  +2.11100000E-05  +3.05100000E-05
   +1.10600000E-05  -5.47000000E-06  -1.14800000E-05  +2.23074000E-03  -1.72180000E-04
   -2.54050000E-04  +1.42220000E-04  +4.14100000E-05  -1.30130000E-04  +1.05000000E-05
   +1.93000000E-05  +4.76500000E-05  -1.25150000E-04  -9.10000000E-05  +1.25000000E-04
   +6.06701000E-02  -3.04454700E-02  -2.06924300E-02  -3.32268900E-02  +3.67065100E-02
   +2.25796000E-03  +1.27010000E-04  +9.60000000E-06  -2.22389000E-03  +4.33859000E-03
   -9.76850000E-04  +3.07251600E-02  +6.91440000E-04  -2.68487700E-02  -2.52530000E-04
   -3.68477000E-03  +2.64873000E-03  -8.54500000E-05  +3.88450000E-04  -1.45050000E-03
   -5.93740000E-04  -1.24320000E-04  +6.56700000E-04  -1.43480000E-04  -2.55370000E-04
   +9.51300000E-05  -6.73100000E-05  +9.40400000E-05  -5.88500000E-05  +4.02330000E-04
   -6.49050000E-04  +3.13270000E-04  +1.24100000E-05  +1.12400000E-04  +4.37600000E-05
   -4.21300000E-05  +1.26400000E-05  -1.39500000E-05  -4.29000000E-05  +2.76500000E-05
   +1.05100000E-05  +9.65700000E-05  +7.91300000E-05  +2.21000000E-05  -1.57900000E-05
   -3.21000000E-05  -2.58700000E-05  -2.62800000E-05  -3.67900000E-05  -3.50300000E-05
   -1.34600000E-04  -9.67500000E-05  -2.32700000E-05  -3.67940000E-04  -1.88400000E-05
   -1.39540000E-04  -6.42020000E-04  +2.18390000E-04  +6.01500000E-05  +1.90000000E-05
   +1.14500000E-05  +1.93100000E-05  -1.08400000E-05  -3.11400000E-05  +1.45000000E-06
   +5.53000000E-05  +2.29100000E-05  +7.66100000E-05  +2.27500000E-05  -2.27000000E-06
   -7.79000000E-06  -7.48000000E-06  -8.31000000E-06  +6.79000000E-06  -1.88870000E-04
   +1.28820000E-04  +1.45370000E-04  +1.42480000E-04  -1.75500000E-05  +4.38500000E-05
   -2.20700000E-05  +1.20800000E-05  +1.99590000E-04  +8.06000000E-06  -3.25000000E-05
   -2.13900000E-05  +6.22000000E-06  -4.37600000E-05  -1.82500000E-05  -5.26900000E-05
   +5.19100000E-05  +1.47000000E-05  -8.91730000E-04  +1.15582000E-03  +6.61490000E-04
   -6.59700000E-05  +3.20000000E-06  +1.05850000E-04  +1.87500000E-05  +4.08400000E-05
   +1.49200000E-05  +8.07700000E-05  -1.26600000E-05  -2.05870000E-04  +2.22079430E-01
   +5.22376000E-03  -1.83870860E-01  -2.50049510E-01  -7.69432000E-03  +2.08546910E-01
end_hess

