# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.95490200    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -1.98535678E+00  +1.71874568E+00  -1.94784006E+00
   006   +6.60315814E-01  +1.72238533E+00  -1.85338448E+00
   006   +1.81287591E+00  +4.08239580E+00  -1.83296820E+00
   006   +4.82560051E-01  +6.33698353E+00  -1.89217338E+00
   006   -2.12943078E+00  +6.26934183E+00  -1.97456082E+00
   006   -3.36016378E+00  +3.95381816E+00  -2.00383625E+00
   006   +2.15187428E+00  -7.58225314E-01  -1.78307051E+00
   006   +1.77014434E+00  -2.15255864E+00  -4.30356252E+00
   008   -3.40027207E+00  +8.49797575E+00  -2.02631252E+00
   006   +1.32886352E+00  -2.33146734E+00  +5.06543554E-01
   006   +1.15512392E+00  -1.18849320E+00  +2.86689330E+00
   006   +5.12635963E-01  -2.54503429E+00  +5.00908559E+00
   006   +2.51811317E-02  -5.11743946E+00  +4.83123507E+00
   006   +1.89195797E-01  -6.29582960E+00  +2.49864181E+00
   006   +8.34082124E-01  -4.90680300E+00  +3.74821359E-01
   008   -6.21846242E-01  -6.55204704E+00  +6.86569442E+00
   006   +5.00583088E+00  -2.88775064E-01  -1.49659279E+00
   008   -3.19956222E+00  -5.41569293E-01  -1.98008352E+00
   001   -6.54362635E-01  -5.51726353E+00  +8.34760372E+00
   001   +3.84998264E-01  -1.59647032E+00  +6.82112925E+00
   001   +1.50698288E+00  +8.20365812E-01  +3.04156464E+00
   001   +9.22275635E-01  -5.87932159E+00  -1.41885964E+00
   001   -2.00070615E-01  -8.29763834E+00  +2.36462334E+00
   001   +5.97120970E+00  -2.10448257E+00  -1.38163868E+00
   001   +5.77063951E+00  +7.36667028E-01  -3.11434705E+00
   001   +5.44613387E+00  +7.59708108E-01  +2.21020222E-01
   001   -1.85319172E-01  -2.72203805E+00  -4.57771803E+00
   001   +2.30615560E+00  -9.05143274E-01  -5.85325204E+00
   001   +2.96726667E+00  -3.82755513E+00  -4.41001127E+00
   001   +3.84951151E+00  +4.19381104E+00  -1.75733351E+00
   001   +1.44703148E+00  +8.13631484E+00  -1.86997765E+00
   001   -5.40931671E+00  +3.87819833E+00  -2.07720427E+00
   001   -5.18067156E+00  +8.19097718E+00  -2.08305127E+00
   001   -4.98632983E+00  -2.82705301E-01  -1.90204077E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.21400000E-05  +7.30000000E-07  -2.22000000E-06
   +3.44000000E-06  -4.21000000E-06  -1.28000000E-06
   -2.44000000E-06  -4.24000000E-06  -9.90000000E-07
   -7.00000000E-08  +2.37000000E-06  -1.30000000E-07
   +2.89000000E-06  +2.30000000E-07  -8.00000000E-07
   +1.69000000E-06  +2.39000000E-06  +1.04000000E-06
   -4.15000000E-06  +2.15000000E-06  -1.30000000E-07
   -1.43000000E-06  -2.36000000E-06  -9.00000000E-08
   -8.88000000E-06  -1.79000000E-06  +2.00000000E-08
   +1.43000000E-06  +4.11000000E-06  +1.33000000E-06
   -3.80000000E-07  -1.53000000E-06  +1.20000000E-06
   -1.10000000E-07  -5.90000000E-07  -1.55000000E-06
   -8.10000000E-07  +1.22000000E-06  +1.04000000E-06
   -2.63000000E-06  +1.09000000E-06  +6.60000000E-07
   -2.35000000E-06  -8.00000000E-08  +3.90000000E-07
   -1.74000000E-06  +7.96000000E-06  +1.06900000E-05
   -8.60000000E-07  -2.07000000E-06  +2.00000000E-08
   +6.86100000E-05  -1.40300000E-05  -2.95000000E-06
   -7.40000000E-07  -7.67000000E-06  -1.22500000E-05
   +2.60000000E-07  -3.00000000E-07  -1.70000000E-07
   +1.23000000E-06  -4.06000000E-06  +2.51000000E-06
   -1.15000000E-06  +1.45000000E-06  -1.42000000E-06
   -2.36000000E-06  +5.20000000E-07  +4.00000000E-07
   -1.41000000E-06  -1.50000000E-06  -5.10000000E-07
   +3.00000000E-08  -2.03000000E-06  -3.50000000E-07
   +2.60000000E-07  -2.02000000E-06  -7.30000000E-07
   -1.12000000E-06  +1.24000000E-06  -1.10000000E-07
   -1.40000000E-06  -1.03000000E-06  +4.10000000E-07
   -1.73000000E-06  -1.10000000E-06  +4.50000000E-07
   -3.40000000E-07  -1.69000000E-06  -5.70000000E-07
   +2.00000000E-06  -6.30000000E-07  +1.90000000E-07
   +8.40000000E-07  +3.52000000E-06  +2.80000000E-07
   +1.56400000E-05  +4.10000000E-06  +1.15000000E-06
   -5.00900000E-05  +1.98500000E-05  +4.47000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.04338700E-01  -1.09361300E-02  +7.01999390E-01  +1.46348700E-02  -3.06014000E-03
   +1.69405780E-01  -2.86300200E-01  -1.81371400E-02  -6.51886000E-03  +6.40257740E-01
   +5.63866400E-02  -1.25205370E-01  +1.21029000E-03  +3.23684500E-02  +6.61908340E-01
   -7.88073000E-03  -4.32080000E-04  -7.53715400E-02  +1.52984900E-02  -3.22193000E-03
   +1.79849280E-01  -2.09662900E-02  -3.67337500E-02  -4.25870000E-04  -1.71590710E-01
   -1.11621280E-01  -3.09332000E-03  +7.45131280E-01  -9.56808600E-02  +3.27024800E-02
   -2.90521000E-03  -4.33745000E-02  -2.93218670E-01  +5.93540000E-04  -6.81124000E-03
   +6.88529590E-01  +8.61300000E-05  -1.72211000E-03  +3.74955000E-03  -4.17692000E-03
   -2.09893000E-03  -6.31205100E-02  +2.16253600E-02  -4.35194000E-03  +1.46940180E-01
   -6.60026800E-02  +3.40804500E-02  -2.06588000E-03  +6.79586200E-02  +2.66167500E-02
   +1.73085000E-03  -1.85842000E-01  +6.05430600E-02  -4.51350000E-03  +7.06189300E-01
   +3.64064900E-02  -1.33079000E-02  +1.11602000E-03  -2.37607100E-02  -5.59703900E-02
   -1.23520000E-04  +1.31019750E-01  -2.94347640E-01  +5.79735000E-03  +2.36426700E-02
   +7.58020030E-01  -2.57190000E-03  +1.28716000E-03  -2.04360000E-03  +2.51071000E-03
   +1.40928000E-03  +7.80747000E-03  -5.05529000E-03  +3.19396000E-03  -6.12916500E-02
   +1.86193400E-02  -2.88266000E-03  +1.23294410E-01  +9.18280500E-02  -2.90569400E-02
   +3.04592000E-03  -6.28879400E-02  -3.87978400E-02  -1.57947000E-03  -3.10643400E-02
   +9.21038900E-02  -2.01306000E-03  -3.30783950E-01  -6.56632400E-02  -7.41165000E-03
   +7.39359850E-01  +3.65693600E-02  -6.18273300E-02  +1.34153000E-03  -3.74772400E-02
   -1.70788500E-02  -1.22136000E-03  +3.04038500E-02  +4.33707500E-02  +5.33040000E-04
   +1.36175800E-02  -1.30861250E-01  +8.58110000E-04  +2.26785000E-03  +7.06896990E-01
   +2.91933000E-03  -7.20240000E-04  -3.35704000E-03  -1.77224000E-03  -1.26721000E-03
   -2.42057000E-03  -1.35910000E-03  +2.90316000E-03  +2.51903000E-03  -8.00620000E-03
   -1.91425000E-03  -7.17698600E-02  +1.83176000E-02  -2.70020000E-03  +1.65361310E-01
   -1.98879340E-01  +1.35564120E-01  -4.78260000E-03  -2.25851100E-02  +2.38028300E-02
   -1.39565000E-03  -4.82259000E-03  +1.52711000E-03  -1.27500000E-04  -2.01775400E-02
   -2.71049800E-02  -8.27040000E-04  -1.89074250E-01  -1.29904820E-01  -3.33398000E-03
   +7.36368820E-01  +5.28388400E-02  -2.61164500E-01  +2.97620000E-03  +7.22871300E-02
   +3.52066100E-02  +2.28994000E-03  +3.56028000E-03  -7.00471400E-02  +8.67240000E-04
   -7.59898300E-02  +2.91607500E-02  -2.87809000E-03  -4.86695600E-02  -2.76336290E-01
   -1.35750000E-04  +6.76957000E-03  +7.12264170E-01  -3.97517000E-03  +5.40947000E-03
   -6.37851400E-02  -1.77363000E-03  +8.39280000E-04  +8.51905000E-03  +3.91400000E-05
   +3.80590000E-04  -1.92850000E-03  -7.10950000E-04  -1.09849000E-03  +1.02501200E-02
   -3.93258000E-03  -3.28517000E-03  -6.44591700E-02  +2.14246800E-02  -2.45128000E-03
   +1.12815550E-01  -1.70196800E-02  +2.77950200E-02  -5.86650000E-04  -1.12868960E-01
   +3.88464600E-02  -2.04939000E-03  +1.39548900E-02  -5.18386000E-03  +3.44470000E-04
   -6.17890000E-04  -4.04279000E-03  -3.83030000E-04  -2.26888000E-03  +2.55100000E-05
   -4.08800000E-05  -4.59278000E-03  -1.54182000E-03  -1.62260000E-04  +4.70244590E-01
   +9.99696000E-03  +5.47492000E-03  +8.00370000E-04  +3.34188800E-02  -1.46342820E-01
   +1.55390000E-03  +1.24485400E-02  -2.53552200E-02  +1.48020000E-04  -3.03302000E-03
   -4.20890000E-04  +9.39000000E-06  -1.70540000E-04  -1.77021000E-03  +5.52400000E-05
   -2.91031000E-03  +1.46215000E-03  -2.12870000E-04  -1.72956000E-03  +4.76239930E-01
   -1.03043000E-03  +9.34890000E-04  +2.19362000E-03  -2.35072000E-03  +1.76195000E-03
   -6.85510700E-02  -1.54700000E-05  +3.85530000E-04  +1.87124000E-03  +2.04460000E-04
   +1.77100000E-05  +6.75390000E-03  -3.39620000E-04  +1.64260000E-04  -7.38280000E-04
   -7.15770000E-04  -7.56600000E-05  +4.49951000E-03  +5.40950000E-04  +6.60637000E-03
   +4.78148390E-01  +4.59950000E-04  +3.27374000E-03  +1.03085000E-03  +2.60100000E-03
   +9.84127000E-03  +1.50000600E-02  -1.48375000E-03  -1.42480000E-04  +3.75260000E-04
   -8.41130000E-04  +5.32530000E-04  -7.92710000E-04  +1.06246000E-03  -1.23290000E-04
   +7.00700000E-05  +5.31210000E-04  -5.81970000E-04  -5.45510000E-04  -7.75092500E-02
   -5.10271000E-03  -9.58070000E-03  +5.97802060E-01  -5.03940000E-04  +5.15530000E-04
   +8.27000000E-06  +7.99800000E-05  -2.30466000E-02  -2.51900400E-02  +2.15981000E-03
   -4.24420000E-04  -8.16660000E-04  +4.76600000E-04  -6.36320000E-04  +1.48544000E-03
   -5.82590000E-04  +4.69240000E-04  -8.11400000E-05  -6.58650000E-04  -4.64580000E-04
   +8.43670000E-04  -8.59739000E-03  -9.85306600E-02  -4.25282500E-02  -3.09890000E-04
   +5.58837360E-01  -7.87900000E-05  +1.79648000E-03  +2.03840000E-04  +4.79871000E-03
   -7.88974000E-03  -1.53360000E-03  -4.85310000E-04  +1.26180000E-03  -4.84060000E-04
   -3.04800000E-04  +3.61820000E-04  -1.90250000E-04  +5.78610000E-04  -2.59500000E-05
   +7.09000000E-05  -1.52180000E-04  -5.58150000E-04  +5.94800000E-05  -1.38251000E-02
   -3.78964600E-02  -1.47921740E-01  -9.24268000E-03  -4.98914700E-02  +4.84696470E-01
   -9.83585000E-03  +1.17576000E-03  -5.48690000E-04  +4.62976000E-03  +4.60934000E-03
   +1.43780000E-04  -3.71199000E-03  -1.11129500E-02  -2.14380000E-04  -3.68449300E-02
   +5.58152400E-02  -1.76925000E-03  -1.57455950E-01  +1.11896300E-01  -4.20508000E-03
   +1.31309800E-02  -1.08659600E-02  +8.11200000E-05  +1.24504000E-03  -5.56970000E-04
   +4.20400000E-04  -7.17090000E-04  +6.42580000E-04  -4.18380000E-04  +7.03369470E-01
   -8.04989000E-03  +2.66919000E-03  -2.76730000E-04  +4.82350000E-03  -1.27540000E-03
   +1.90060000E-04  -3.77218000E-03  -1.47203000E-03  -3.83000000E-06  +1.69284600E-02
   -9.06500000E-04  +6.35020000E-04  +5.80772900E-02  -2.69714730E-01  +2.99843000E-03
   +2.85959800E-02  -5.31043600E-02  +1.38308000E-03  -1.28838000E-03  +1.31913000E-03
   -5.84390000E-04  +8.89300000E-04  -9.04260000E-04  +5.26230000E-04  -2.97200700E-02
   +3.87693800E-01  -5.86510000E-04  +8.35800000E-05  +7.75393000E-03  +1.91730000E-04
   +1.49490000E-04  -1.46382000E-03  -2.59420000E-04  -2.58640000E-04  +4.86092000E-03
   -1.44957000E-03  +1.80296000E-03  +7.92396000E-03  -3.99172000E-03  +4.80728000E-03
   -4.42944300E-02  -1.05780000E-04  -1.20470000E-04  +9.83203000E-03  +4.61900000E-05
   -1.58900000E-05  -3.85880000E-04  +1.36200000E-05  -6.84100000E-05  -3.41500000E-05
   +2.21836400E-02  -2.79965000E-03  +2.76321700E-02  -2.90400000E-05  +2.38300000E-03
   -7.44250000E-04  +6.16308000E-03  +6.26309000E-03  -1.05310500E-02  -1.55347000E-03
   +6.85270000E-04  -1.69330000E-04  -4.41160000E-04  +5.89000000E-04  +5.10100000E-04
   +8.10250000E-04  -2.95480000E-04  -8.96200000E-05  +1.91450000E-04  -2.82230000E-04
   +4.06580000E-04  -7.59989300E-02  -1.53389400E-02  +2.19923500E-02  +1.24868000E-03
   +3.23144000E-03  -2.78606000E-03  -5.93570000E-04  +7.79070000E-04  -4.92100000E-05
   +2.20246320E-01  -4.46160000E-04  -3.86710000E-04  +2.74380000E-04  -6.50994000E-03
   -2.66851700E-02  +2.26245200E-02  +2.50743000E-03  -7.27930000E-04  +1.15465000E-03
   +4.31450000E-04  -7.59620000E-04  -1.14396000E-03  -7.87690000E-04  -5.37800000E-05
   +2.91000000E-05  -6.98150000E-04  +2.17620000E-04  -4.96690000E-04  -1.65063400E-02
   -1.13054610E-01  +3.55184200E-02  +5.13378000E-03  +1.15174100E-02  -9.24786000E-03
   +3.37140000E-04  -3.28450000E-04  +1.11900000E-04  +9.14184400E-02  +6.53131010E-01
   -9.99740000E-04  -1.96463000E-03  +3.35210000E-04  -3.74303000E-03  +9.14753000E-03
   -1.12754000E-03  +7.85420000E-04  -8.48740000E-04  -9.76440000E-04  +4.87930000E-04
   -6.04000000E-04  -1.06990000E-04  -8.79770000E-04  +1.98900000E-04  +7.41800000E-05
   +5.52910000E-04  +4.72030000E-04  +3.45700000E-05  +2.09747600E-02  +3.17720900E-02
   -1.40473190E-01  +9.74408000E-03  +1.43988100E-02  -2.89957300E-02  +5.40350000E-04
   -6.42530000E-04  -1.70400000E-05  -7.27448600E-02  +3.78264400E-02  +6.18863570E-01
   -3.43970000E-04  -3.06330000E-04  -3.95480000E-04  +6.31870000E-04  +5.83230000E-04
   -6.24490000E-04  -8.03100000E-05  -3.83750000E-04  -1.88120000E-04  -5.61900000E-05
   +6.94400000E-05  -1.17000000E-06  +9.81900000E-05  -5.30600000E-05  +8.46800000E-05
   +1.94170000E-04  -1.22960000E-04  -4.81100000E-05  +6.27490000E-04  +3.76162000E-03
   +9.25754000E-03  -6.19100000E-05  -1.44207000E-03  +5.86140000E-04  -1.55800000E-05
   +5.04000000E-05  -2.98000000E-05  -7.47132800E-02  -1.13742000E-02  +1.40829400E-02
   +1.81072680E-01  +1.05803000E-03  +6.86220000E-04  +4.03150000E-04  -4.25830000E-04
   +4.52210000E-04  +1.88921000E-03  -1.91720000E-04  +4.08810000E-04  +3.03240000E-04
   +2.59300000E-04  -3.39430000E-04  -3.64530000E-04  -7.85000000E-05  -1.33150000E-04
   +3.31900000E-05  -7.72000000E-05  +8.66200000E-05  -1.53660000E-04  +1.27270000E-04
   +1.26965100E-02  +1.59240000E-02  -1.81279000E-03  -3.18355000E-03  +3.27365000E-03
   +2.65300000E-05  -7.07700000E-05  -1.00300000E-05  +1.76190000E-04  -1.65701660E-01
   -1.12629540E-01  +1.12149170E-01  +7.22522500E-01  +1.27809000E-03  +1.50924000E-03
   -9.09230000E-04  +1.56890000E-04  -6.46270000E-04  -2.56536000E-03  -2.77330000E-04
   -9.23690000E-04  -4.25500000E-04  -2.15410000E-04  -1.17770000E-04  -7.68700000E-05
   +2.45590000E-04  -1.63040000E-04  +9.12000000E-05  +1.68700000E-05  -3.05080000E-04
   +3.87400000E-05  +4.07849000E-03  -4.28004000E-03  -2.72882000E-02  +1.27358000E-03
   +2.91880000E-03  -2.08805000E-03  -2.11650000E-04  +2.50600000E-04  -2.91200000E-05
   +2.68710900E-02  -4.25041400E-02  -2.79225690E-01  -9.00643700E-02  +7.26730000E-03
   +6.69420300E-01  -1.86560000E-04  -8.79500000E-05  -1.36170000E-04  -2.51560000E-04
   -1.55000000E-05  +2.84500000E-05  +9.06000000E-05  -2.88020000E-04  -1.18720000E-04
   -5.74100000E-05  +1.08500000E-05  +1.40800000E-05  +1.87500000E-05  -5.08000000E-06
   +1.97800000E-05  +9.30500000E-05  -9.56100000E-05  +9.92000000E-06  +5.27124000E-03
   -2.39040000E-04  +6.75680000E-04  -1.51600000E-05  -3.77930000E-04  +2.41200000E-04
   +8.12000000E-06  +8.64000000E-06  -2.44600000E-05  +7.56415000E-03  +1.53024200E-02
   +1.82939900E-02  -7.69889300E-02  -4.79988000E-02  +4.97731300E-02  +1.62808750E-01
   -3.73410000E-04  +1.53070000E-04  -1.00390000E-04  +2.33270000E-04  -6.62200000E-05
   +5.34360000E-04  +2.45550000E-04  -1.56480000E-04  +7.10000000E-06  -1.19670000E-04
   +1.26560000E-04  +3.64700000E-05  -7.40000000E-07  +4.10140000E-04  -3.26100000E-05
   +3.90700000E-05  -4.03760000E-04  -2.87300000E-05  -9.08290000E-04  -1.89230000E-04
   -4.29259000E-03  +1.56830000E-04  +5.14040000E-04  -1.06812000E-03  +1.98860000E-04
   -3.34570000E-04  +8.79000000E-06  +6.04837000E-03  +6.78906700E-02  +3.56766000E-02
   -3.62588200E-02  -1.87720930E-01  +5.90896500E-02  +1.03913140E-01  +6.72462550E-01
   -2.43510000E-04  -5.16400000E-05  +2.37100000E-05  +1.67800000E-04  -7.27940000E-04
   +5.97650000E-04  -4.50300000E-05  +4.23860000E-04  +2.33360000E-04  +1.35130000E-04
   +3.01500000E-05  +2.48000000E-06  -1.65160000E-04  +9.37000000E-05  -4.81000000E-05
   -6.37200000E-05  +1.33700000E-04  +2.49900000E-05  -4.14720000E-04  -4.73854000E-03
   -1.64176000E-03  +5.69600000E-04  +8.89550000E-04  -5.64920000E-04  +9.97500000E-05
   -1.26680000E-04  +1.67400000E-05  +7.52493000E-03  -1.90568400E-02  -5.67271600E-02
   +6.34785400E-02  +1.27758440E-01  -2.77372110E-01  -9.86688900E-02  +3.30821600E-02
   +7.28513390E-01  +4.91500000E-05  +3.30100000E-05  +6.47100000E-05  +1.55380000E-04
   -9.85900000E-05  -1.29910000E-04  -4.07800000E-05  +3.32000000E-05  -4.44600000E-05
   -1.08300000E-04  +5.01300000E-05  +2.86800000E-05  +1.62410000E-04  -1.80110000E-04
   +9.20000000E-07  -1.95700000E-05  +5.95700000E-05  -1.74000000E-06  -3.75640000E-04
   -1.73780000E-04  +1.64880000E-04  +1.58550000E-04  +9.76600000E-05  -1.89900000E-05
   -1.64280000E-04  +2.31650000E-04  -5.00000000E-06  -5.58364000E-03  -3.64682000E-03
   -5.13275000E-03  -1.16270000E-03  -1.12227400E-02  +8.29684000E-03  -7.86116500E-02
   -5.11688000E-02  -2.28048000E-03  +1.97765650E-01  -2.89050000E-04  -6.64030000E-04
   +2.61770000E-04  +6.30200000E-05  -3.62890000E-04  +2.10400000E-05  -1.88240000E-04
   +3.01130000E-04  +1.19040000E-04  +6.02300000E-05  +4.62600000E-05  -3.40100000E-05
   +6.75000000E-05  -4.94190000E-04  -1.01000000E-06  -2.07000000E-05  +4.76000000E-04
   -3.06800000E-05  -1.95560000E-04  -2.43947000E-03  +5.78750000E-04  +1.05130000E-04
   +3.95820000E-04  +2.55670000E-04  -2.37800000E-04  +4.18200000E-04  -1.40000000E-05
   -2.91014000E-03  -6.00824200E-02  -4.48292100E-02  -2.11661700E-02  -2.97440100E-02
   +8.60709300E-02  -3.63811100E-02  -3.11441970E-01  -7.13813000E-02  +1.01446210E-01
   +6.87658680E-01  +1.87250000E-04  +4.24480000E-04  -5.41900000E-05  -9.16500000E-04
   -1.07390000E-04  +5.71440000E-04  +1.38780000E-04  +6.30190000E-04  +1.21940000E-04
   +6.83940000E-04  -4.17450000E-04  -6.25900000E-05  -9.32750000E-04  +5.91100000E-04
   -3.98600000E-05  -7.86500000E-05  +2.01800000E-05  +5.79000000E-06  -4.59870000E-04
   -4.54090000E-04  -1.53305000E-03  +1.34510000E-04  -3.48800000E-04  +1.91840000E-04
   +6.80550000E-04  -9.62230000E-04  +2.25000000E-05  -4.70931000E-03  -4.38912800E-02
   -2.69340500E-02  -3.27098000E-03  +2.71397800E-02  +5.37314500E-02  +1.45669000E-02
   +1.21926000E-02  -1.37654800E-01  -8.92813200E-02  +3.05628700E-02  +7.12425980E-01
   -5.17910000E-04  -5.76460000E-04  +6.59400000E-05  -5.91440000E-04  -6.80240000E-04
   +9.15110000E-04  +2.01980000E-04  +3.96500000E-05  +1.49730000E-04  +1.77930000E-04
   -8.02400000E-05  -9.57900000E-05  -2.30550000E-04  +2.87000000E-05  +1.44100000E-05
   -1.02500000E-05  +1.93560000E-04  -8.43500000E-05  +6.08561000E-03  -2.10082000E-03
   +3.72540000E-04  -7.02600000E-05  +4.11600000E-05  -2.79900000E-05  +1.45370000E-04
   -1.55610000E-04  +1.42900000E-05  +3.27484000E-03  -2.06942800E-02  -1.97330000E-03
   -5.21680000E-03  +1.25900000E-04  +1.28174200E-02  +1.17793600E-02  +8.04019000E-03
   -9.20718000E-03  -7.53053700E-02  -1.42210900E-02  +7.80712000E-03  +1.70193950E-01
   -5.54600000E-04  -6.78160000E-04  -6.29800000E-05  -3.03150000E-04  -3.76350000E-04
   +6.19390000E-04  +1.35270000E-04  +2.72900000E-05  +6.59600000E-05  +8.15700000E-05
   -1.02600000E-05  -3.57400000E-05  -1.24680000E-04  -2.39500000E-05  -1.48700000E-05
   +4.13000000E-06  +2.19170000E-04  +5.86900000E-05  -7.59550000E-04  -3.33990000E-03
   -2.64238000E-03  +4.00730000E-04  +2.04070000E-04  -1.00926000E-03  +4.97800000E-05
   -3.08800000E-05  +1.11500000E-05  -1.16834200E-02  -2.89270700E-02  +2.47754900E-02
   -2.78180000E-04  -2.24927000E-03  +2.10439000E-03  -5.04920000E-04  -1.83048900E-02
   -2.83387100E-02  -2.84860000E-04  -1.83943100E-01  -1.31891780E-01  +1.21835760E-01
   +7.35064510E-01  +3.77820000E-04  +3.00270000E-04  -6.08700000E-05  +3.24640000E-04
   +8.33300000E-05  -1.56790000E-04  +3.54600000E-05  -6.70310000E-04  -1.76890000E-04
   -5.29670000E-04  +2.15070000E-04  +2.65300000E-05  +6.40410000E-04  -1.16220000E-04
   +2.81800000E-05  +4.22600000E-05  -3.98290000E-04  -1.42300000E-05  +1.08555000E-03
   -1.67685000E-03  +1.43185000E-03  +1.62510000E-04  +3.57740000E-04  -6.79140000E-04
   -3.50500000E-04  +4.29880000E-04  -1.01600000E-05  +7.79872000E-03  +7.71388900E-02
   +4.68470000E-02  +1.21792700E-02  +4.98500000E-04  -7.44601400E-02  -1.90424800E-02
   -7.73679000E-02  +2.83581600E-02  +2.42562000E-02  -5.25727700E-02  -2.71816050E-01
   -9.26949800E-02  +1.18004700E-02  +6.83855310E-01  -6.70940000E-04  -5.70170000E-04
   -3.36920000E-04  -2.84630000E-04  +5.15550000E-04  -6.55900000E-05  +2.58350000E-04
   -3.54480000E-04  -6.83700000E-05  -1.77250000E-04  +9.51200000E-05  +5.52400000E-05
   +1.49960000E-04  +2.66000000E-05  +2.76000000E-06  +1.50080000E-04  -3.28900000E-05
   +1.55830000E-04  +8.23310000E-04  -8.27421000E-03  +3.44730000E-04  -7.09010000E-04
   +1.38720000E-04  +4.43390000E-04  -5.78400000E-05  +9.28300000E-05  -2.02800000E-05
   -7.84493200E-02  -4.25126000E-02  +1.54766300E-02  +1.15801700E-02  -1.67449000E-03
   -2.07046200E-02  -8.06415000E-03  -1.53154900E-02  +8.09114000E-03  +2.81237000E-03
   +1.87222500E-02  +1.87829900E-02  -7.84120400E-02  -4.85144900E-02  +4.78145600E-02
   +1.79055180E-01  -2.56960000E-04  -5.21690000E-04  +5.58000000E-06  -2.38520000E-04
   +3.40130000E-04  +1.34550000E-04  +3.16270000E-04  -5.90740000E-04  -1.18330000E-04
   -3.53120000E-04  +1.26560000E-04  -1.80000000E-07  +3.81150000E-04  +4.53300000E-05
   +4.95100000E-05  +9.85600000E-05  -3.36900000E-04  -3.06200000E-05  -4.20708000E-03
   -1.35645900E-02  +5.70396000E-03  -9.03040000E-04  -8.69760000E-04  +3.14090000E-04
   -1.43100000E-04  +1.64270000E-04  -2.65600000E-05  -5.40025100E-02  -3.15297630E-01
   +2.14923500E-02  +8.16422000E-03  -2.39779700E-02  -8.55379900E-02  -1.60159100E-02
   -5.89197300E-02  +2.82480100E-02  +8.59448000E-03  +7.78560200E-02  +3.99858800E-02
   -3.65519500E-02  -1.91288850E-01  +5.73924800E-02  +1.01448340E-01  +6.70405620E-01
   +2.10370000E-04  +5.99940000E-04  +1.03580000E-04  +2.15877000E-03  +1.71106000E-03
   -2.93474000E-03  -7.40220000E-04  +6.36490000E-04  +2.72700000E-05  -9.66300000E-05
   +3.09450000E-04  +3.17470000E-04  +2.21030000E-04  -1.61020000E-04  -3.69700000E-05
   -5.33300000E-05  +1.19490000E-04  +1.12080000E-04  +3.70604000E-03  +2.48342400E-02
   +4.55420000E-03  +6.16010000E-04  +2.17683000E-03  -3.78020000E-04  -2.28390000E-04
   +3.16410000E-04  -2.61000000E-06  +1.92727000E-03  -4.81612200E-02  -1.31763300E-01
   -9.63252000E-03  -3.25103800E-02  +2.82567400E-02  +7.29618000E-03  +2.57303300E-02
   -1.56738300E-02  +6.71764000E-03  -1.93968400E-02  -5.95714000E-02  +6.26872000E-02
   +1.26886050E-01  -2.74658710E-01  -8.80293000E-02  +4.18326700E-02  +7.26702670E-01
   -1.49010000E-04  -4.78200000E-05  -1.08000000E-05  -1.62980000E-04  +1.03660000E-04
   +2.92700000E-04  +8.08700000E-05  +1.50190000E-04  +7.30300000E-05  +2.11420000E-04
   -8.84900000E-05  -2.43200000E-05  -2.97940000E-04  +2.30850000E-04  -1.95200000E-05
   -2.00000000E-06  -4.05800000E-05  -3.45800000E-05  -7.64430000E-04  +3.16640000E-04
   -5.58020000E-04  -3.61100000E-05  -1.96540000E-04  +1.71500000E-05  +2.60280000E-04
   -3.55570000E-04  +2.32000000E-06  -1.30397000E-03  +1.37670000E-04  +6.07180000E-04
   +6.95780000E-03  -1.80832000E-03  +4.59000000E-06  +5.26465000E-03  -9.63256000E-03
   +1.23412100E-02  -6.03469500E-02  -4.64031200E-02  +4.45252500E-02  +5.48757000E-03
   -2.23022000E-03  +8.46901000E-03  +4.88885000E-03  -1.21940000E-03  +7.92000000E-05
   +5.27691400E-02  -1.16640000E-04  +2.14120000E-04  -1.28140000E-04  -4.16070000E-04
   +1.52980000E-04  +4.22600000E-04  +1.89500000E-04  +2.33850000E-04  +6.87800000E-05
   +3.26680000E-04  -1.79450000E-04  -1.36000000E-05  -5.06450000E-04  +5.09790000E-04
   -3.17900000E-05  -7.44000000E-06  -1.58710000E-04  -6.26000000E-06  -1.81910000E-04
   +7.69460000E-04  -8.69400000E-04  -5.42900000E-05  -4.34600000E-04  +2.22700000E-05
   +4.61450000E-04  -6.74730000E-04  +2.41400000E-05  +2.60590000E-04  +3.90343000E-03
   +5.03948000E-03  -3.74560000E-04  -3.09060000E-03  -1.01672300E-02  -1.68233000E-02
   -3.13379500E-02  +4.87791000E-02  -3.76912200E-02  -1.73691440E-01  +6.18511600E-02
   +4.54185000E-03  +1.95429300E-02  -1.18044600E-02  -2.29410000E-03  -8.13873000E-03
   -1.76630000E-03  +6.00996300E-02  +4.07751340E-01  +8.90000000E-07  -4.53300000E-04
   +1.55840000E-04  +8.91290000E-04  -1.87590000E-04  -7.11700000E-04  -2.84300000E-04
   -4.30780000E-04  -9.02800000E-05  -6.13840000E-04  +3.84250000E-04  +6.84500000E-05
   +8.94180000E-04  -7.73460000E-04  +3.45100000E-05  +1.39500000E-05  +2.10390000E-04
   +4.83400000E-05  +5.66260000E-04  -4.92120000E-04  +1.74460000E-03  +8.75200000E-05
   +6.23360000E-04  -1.35170000E-04  -7.65000000E-04  +1.10790000E-03  -1.71800000E-05
   +5.19540000E-04  +5.38314000E-03  +4.91470000E-04  +1.54473000E-03  -1.87857000E-03
   -3.84416000E-03  +4.32670000E-03  +8.90664000E-03  -4.99190000E-03  +5.54649000E-02
   +1.12951160E-01  -2.29430780E-01  +1.64657700E-02  +2.72606400E-02  -5.50904100E-02
   -1.37015000E-03  -8.35406000E-03  +2.11258000E-03  -8.08002100E-02  +1.17013080E-01
   +6.50593560E-01  +3.21270000E-04  +1.64886000E-03  -3.63420000E-04  -2.22761800E-02
   +3.98890000E-03  -2.98496000E-03  +7.50000000E-07  +3.12370000E-04  +2.57200000E-04
   -6.18160000E-04  -7.41090000E-04  +3.65900000E-05  +4.71000000E-06  +1.97960000E-04
   -4.59400000E-05  -6.23370000E-04  -3.89340000E-04  +1.00510000E-04  -1.67004450E-01
   -1.35296400E-02  -1.25025600E-02  -1.27268600E-02  -6.14418000E-03  -8.24388000E-03
   +4.59400000E-05  -1.68300000E-04  +5.83000000E-06  -1.80451600E-02  -1.04620500E-02
   +1.00728500E-02  -2.97120000E-04  +6.93000000E-05  -1.47525000E-03  +3.48810000E-04
   -2.45540000E-04  -2.47610000E-04  +6.91700000E-05  -1.48390000E-04  -7.85000000E-05
   +3.45430000E-04  -2.32700000E-05  +3.40210000E-04  -3.53380000E-04  +1.71974000E-03
   -4.96670000E-04  +1.48000000E-05  +1.13330000E-04  -1.56490000E-04  +4.60018020E-01
   +9.09090000E-04  -6.72459000E-03  +9.68200000E-05  +3.08699200E-02  +3.95515000E-03
   +3.07582000E-03  +1.93918000E-03  -2.39292000E-03  +2.50200000E-04  +1.11103000E-03
   +2.55170000E-04  +6.84400000E-05  -3.27100000E-04  +2.92300000E-04  +1.45800000E-05
   +1.54849000E-03  +5.61960000E-04  -5.55100000E-05  -1.76216400E-02  -7.78192500E-02
   -2.45032000E-03  -1.96328600E-02  -5.50577000E-03  -5.99376000E-03  +4.22640000E-04
   -6.12520000E-04  +5.40000000E-07  -2.04885300E-02  -6.60082000E-03  +2.28897000E-03
   -5.93260000E-04  +1.13200000E-05  -4.32960000E-04  +2.87930000E-04  -4.23800000E-04
   -2.39340000E-04  +1.26450000E-04  +1.91930000E-04  -4.98310000E-04  +8.89840000E-04
   -3.78690000E-04  +6.88050000E-04  -4.90310000E-04  +3.11600000E-05  +1.19248000E-03
   -2.47300000E-04  -4.38140000E-04  +7.36740000E-04  -1.40814200E-02  +5.88328810E-01
   -1.61480000E-04  +7.56700000E-05  +4.61190000E-04  -6.21700000E-04  +1.15970000E-04
   +4.39200000E-05  +2.98100000E-05  -1.75410000E-04  -9.03600000E-04  -1.18640000E-04
   +8.44200000E-05  -1.51450000E-04  +1.95250000E-04  +6.70000000E-07  +2.53010000E-04
   -4.01700000E-05  -1.15390000E-04  +6.54200000E-05  -6.15148000E-03  -1.72295000E-03
   -7.45597900E-02  -3.30338400E-02  -1.00979400E-02  -8.97175000E-03  -6.95000000E-05
   +8.07800000E-05  -6.77000000E-06  +2.70283600E-02  +7.68253000E-03  -3.59220000E-04
   +1.46210000E-03  +1.42686000E-03  -1.12595000E-03  -7.21990000E-04  +2.04890000E-04
   +4.78250000E-04  -6.02500000E-05  +7.50800000E-05  +1.16389000E-03  -9.55440000E-04
   +1.57110000E-04  -1.35565000E-03  +6.13530000E-04  -7.98500000E-04  -1.40209000E-03
   +4.13120000E-04  +7.43550000E-04  -1.45307000E-03  -9.45435000E-03  +1.59275000E-03
   +5.88042500E-01  -1.50393330E-01  -1.04896790E-01  -9.21290000E-04  -3.33680100E-02
   -5.19643000E-02  -1.32960000E-03  -5.64182000E-03  +9.95134000E-03  -5.25340000E-04
   +3.52347000E-03  -5.13042000E-03  +2.73200000E-04  -7.99138000E-03  -4.94800000E-04
   -3.21760000E-04  +1.30435300E-02  +1.12647500E-02  -3.53620000E-04  +3.73657000E-03
   -2.84131000E-03  +7.72310000E-04  -1.63865000E-03  +2.02337000E-03  +1.37835000E-03
   +1.41718000E-03  +7.81590000E-04  +6.33700000E-05  -2.28486000E-03  +8.56250000E-04
   -6.93110000E-04  -6.37670000E-04  -2.46880000E-04  +1.72430000E-04  +4.46260000E-04
   +6.27470000E-04  -4.64400000E-05  -7.26100000E-05  -4.31280000E-04  -9.22600000E-05
   +2.63880000E-04  +1.34040000E-04  +3.26600000E-05  -5.69340000E-04  +2.84220000E-04
   -7.31490000E-04  +2.43840000E-04  +3.90430000E-04  -4.75900000E-04  +4.76250000E-04
   +1.11790000E-04  +8.10000000E-06  +7.03988400E-01  -5.21744300E-02  -2.70769890E-01
   -4.21466000E-03  -1.83777400E-02  -5.00322000E-03  -3.14580000E-04  +3.82656000E-03
   +7.68000000E-04  +3.40540000E-04  -5.11312000E-03  -4.28399000E-03  -1.86740000E-04
   +8.51030000E-03  +3.47892000E-03  +3.07370000E-04  -2.59932500E-02  -5.97118500E-02
   -8.71510000E-04  +2.25606000E-03  -2.52861000E-03  +5.32740000E-04  -1.36030000E-03
   -1.50720000E-04  -1.81023000E-03  -7.63430000E-04  -3.36655000E-03  -4.53000000E-06
   +6.46930000E-04  +8.25300000E-05  +2.51124000E-03  +6.02260000E-04  -7.86530000E-04
   -1.39903000E-03  -2.67700000E-05  -1.22640000E-04  +2.39910000E-04  -7.66900000E-05
   +6.78450000E-04  -2.50890000E-04  +6.63870000E-04  +6.99460000E-04  -7.15530000E-04
   +1.30420000E-03  -7.55400000E-05  +2.05940000E-04  +8.27800000E-05  -1.00880000E-04
   +2.73440000E-04  +4.71000000E-05  +7.58030000E-04  +5.28900000E-05  +2.85822500E-02
   +3.91788870E-01  +1.92020000E-03  -4.90480000E-04  -4.53127400E-02  -1.68486000E-03
   -9.64400000E-04  +7.34039000E-03  -5.44100000E-05  +3.93860000E-04  +4.44349000E-03
   +1.01090000E-04  -3.19740000E-04  -1.47888000E-03  -5.87150000E-04  +9.37300000E-05
   +8.08900000E-03  +4.42080000E-04  +3.24140000E-04  +1.05316800E-02  +5.46320000E-04
   -2.38250000E-04  -3.63121000E-03  +1.33350000E-04  -2.15487000E-03  -6.94200000E-04
   +2.98700000E-05  +1.19430000E-04  -1.80900000E-04  -1.93062000E-03  +1.43372000E-03
   -1.46356000E-03  -7.36600000E-04  +5.94480000E-04  +3.99390000E-04  -8.40300000E-05
   +1.73500000E-05  +3.75960000E-04  +1.50000000E-07  -3.45960000E-04  +3.07320000E-04
   +3.52600000E-05  -1.53570000E-04  +1.65080000E-04  -6.90000000E-04  -4.49990000E-04
   -4.20650000E-04  +4.16100000E-05  +2.39170000E-04  -3.24050000E-04  -2.31700000E-05
   +1.14450000E-04  +2.48470000E-04  -2.33366500E-02  +7.85742000E-03  +3.09660900E-02
   +9.52500000E-05  +8.03400000E-05  +1.87000000E-06  +3.28000000E-06  -1.03800000E-05
   -5.20200000E-05  -1.30400000E-05  -1.48000000E-05  -1.50200000E-05  -4.51300000E-05
   +4.19000000E-06  +1.00000000E-08  +6.83300000E-05  -2.95100000E-05  +4.28000000E-06
   -6.11000000E-06  -8.79000000E-06  +1.55000000E-05  -5.89300000E-05  -4.99300000E-05
   +1.16000000E-06  -7.89000000E-06  +2.30000000E-05  -4.46000000E-06  -5.54700000E-05
   +6.18700000E-05  +5.95000000E-06  +1.11370000E-04  -1.52130000E-04  -1.50600000E-04
   -6.69590000E-04  +5.31400000E-05  +6.66000000E-05  -6.28000000E-04  +9.11600000E-04
   -1.68840000E-04  -3.13852000E-03  +7.02605000E-03  +1.15028600E-02  +1.36602000E-03
   -1.83039000E-03  +1.55474000E-03  +1.66836000E-03  +1.98860000E-04  +4.34930000E-04
   -6.18897000E-03  -9.35815000E-03  +5.00345000E-03  -7.38000000E-06  -6.06000000E-06
   +2.51300000E-05  -9.25900000E-05  -8.26000000E-05  +3.02900000E-05  +7.86459000E-03
   +9.66000000E-06  -1.37300000E-05  +1.05100000E-05  -1.18800000E-05  +1.13700000E-05
   +1.25400000E-05  -8.33000000E-06  -2.14200000E-05  -1.32000000E-05  -9.46000000E-06
   -3.89000000E-06  -1.51500000E-05  +2.50500000E-05  -5.55300000E-05  +7.93000000E-06
   +1.13800000E-05  +1.84400000E-05  -2.29200000E-05  -6.44700000E-05  -1.32010000E-04
   -1.05470000E-04  +1.71000000E-05  +2.50200000E-05  -2.41300000E-05  -2.88100000E-05
   +4.84800000E-05  -1.25000000E-05  -1.81100000E-05  -3.19540000E-04  -2.48550000E-04
   -3.03000000E-06  -6.93860000E-04  +3.45800000E-05  -2.19240000E-04  +2.00873000E-03
   +4.51677000E-03  -1.08387000E-03  +1.26450500E-02  +2.54951000E-02  -1.51614000E-03
   -2.06234000E-03  +3.86081000E-03  -1.20830000E-04  +1.01137000E-03  +1.61400000E-05
   -6.25980000E-04  -2.17636210E-01  -2.63494160E-01  +3.22000000E-06  -1.15800000E-05
   +8.48300000E-05  +1.31000000E-05  +1.42600000E-05  -3.15300000E-05  +3.66945000E-03
   +2.06598360E-01  +3.07400000E-05  +1.36960000E-04  -2.81000000E-05  -1.13560000E-04
   +1.86900000E-05  +8.91300000E-05  +4.08500000E-05  +8.55800000E-05  +1.78400000E-05
   +9.11300000E-05  -5.65000000E-05  -2.90000000E-06  -1.43530000E-04  +1.66780000E-04
   -8.93000000E-06  -7.61000000E-06  -6.32000000E-05  +4.98000000E-06  -5.80600000E-05
   +1.96860000E-04  -1.87820000E-04  -1.12800000E-05  -9.88900000E-05  +2.89400000E-05
   +1.33260000E-04  -2.03500000E-04  +4.94000000E-06  +1.91700000E-05  +5.18410000E-04
   +7.68450000E-04  +2.66800000E-05  -3.82740000E-04  -1.15477000E-03  -1.53920000E-03
   -2.10708000E-03  +5.61430000E-03  +1.26242000E-03  -2.26337900E-02  -3.79171700E-02
   +1.89447000E-03  +5.54044000E-03  -2.49690000E-03  -3.92000000E-06  -2.00068000E-03
   -5.71810000E-04  +1.60673400E-02  -2.11599470E-01  -3.62888520E-01  +1.28600000E-05
   -8.85700000E-05  +1.40140000E-04  +1.90400000E-05  -1.12400000E-04  +8.65000000E-05
   -1.78989600E-02  +2.30976900E-01  +3.98292990E-01  +1.03260000E-04  +1.15710000E-04
   -4.98600000E-05  -8.44400000E-05  +1.28130000E-04  -5.29200000E-05  +8.47000000E-06
   -3.27900000E-05  -2.81900000E-05  -3.28700000E-05  -3.62000000E-06  -3.30000000E-06
   +3.74400000E-05  +3.88400000E-05  +2.82000000E-06  -1.30300000E-05  -3.57000000E-05
   +1.98600000E-05  +4.30510000E-04  +8.54200000E-05  +2.86450000E-04  -1.06850000E-04
   -8.67300000E-05  +1.17380000E-04  -9.23000000E-06  -8.89000000E-06  +9.31000000E-06
   +6.56348000E-03  -2.25270000E-03  +2.00164000E-03  +2.01607000E-03  +4.53525000E-03
   +6.87789000E-03  -3.55435900E-02  +2.57203000E-03  +1.88044000E-02  +4.22605000E-03
   -2.91900000E-03  -4.60438000E-03  +4.91644000E-03  -2.17293000E-03  +6.12390000E-04
   -9.47820000E-04  -1.73560000E-04  +3.67700000E-05  -3.43808000E-03  +1.25088000E-03
   -1.42231000E-03  -2.92000000E-05  -1.73700000E-05  +5.23000000E-06  -7.09300000E-05
   -6.73400000E-05  +8.15900000E-05  +4.84650000E-04  -1.11670000E-04  +3.83620000E-04
   +2.63394900E-02  +2.84000000E-06  -9.40000000E-07  +3.90000000E-06  -1.38400000E-05
   +7.17700000E-05  -5.23700000E-05  -1.31000000E-06  -2.75000000E-06  -8.72000000E-06
   +9.64000000E-06  -2.00400000E-05  -1.61700000E-05  -6.50000000E-07  -1.07100000E-05
   +7.87000000E-06  +1.46500000E-05  -6.20000000E-07  -1.28400000E-05  -5.45000000E-06
   +5.96700000E-04  +5.40320000E-04  -6.59000000E-05  -1.72840000E-04  +1.24190000E-04
   +1.10000000E-06  -1.05000000E-06  -1.03700000E-05  -2.16754000E-03  -5.19930000E-04
   +3.09441000E-03  -8.53610000E-04  +1.17124600E-02  +1.55772000E-02  +2.55744000E-03
   -1.20649170E-01  -1.14776050E-01  +2.78003000E-03  -7.84744000E-03  -2.93022900E-02
   -2.30498000E-03  -5.72693000E-03  +2.32400000E-04  -2.68360000E-04  -1.16287000E-03
   +1.19761000E-03  +1.33458000E-03  +2.41851000E-03  -4.40130000E-04  +6.92000000E-05
   +3.47200000E-05  -2.69200000E-05  +6.90000000E-06  -1.13200000E-05  -1.37200000E-05
   -6.20650000E-04  -1.37943000E-03  +1.45184000E-03  -1.80603000E-03  +1.22463600E-01
   +6.85600000E-05  -1.50400000E-05  +9.00000000E-07  +1.17350000E-04  -1.11320000E-04
   -9.16000000E-06  -5.00900000E-05  -7.92500000E-05  -1.22400000E-05  -9.82400000E-05
   +6.79700000E-05  +2.32300000E-05  +1.30750000E-04  -8.37000000E-05  +1.04000000E-06
   -2.24100000E-05  +2.37300000E-05  +3.49400000E-05  -1.27280000E-04  -1.17825000E-03
   -5.41880000E-04  +1.55740000E-04  +3.85710000E-04  -2.27310000E-04  -1.10900000E-04
   +1.54260000E-04  +1.40800000E-05  +2.47136000E-03  +3.79126000E-03  -1.78326000E-03
   +6.57780000E-04  -1.47926100E-02  -1.84638000E-02  +1.87859000E-02  -1.14607060E-01
   -2.70887540E-01  +1.83621000E-03  +3.02089000E-03  -3.08521000E-03  +5.06970000E-04
   -4.85270000E-04  +2.03492000E-03  -3.37700000E-05  +8.18710000E-04  +2.00440000E-04
   -1.24659000E-03  +3.35160000E-04  +3.59290000E-03  -1.05760000E-04  +1.76500000E-05
   -7.74600000E-05  -7.54600000E-05  +1.19700000E-05  +1.56000000E-05  -2.01930000E-04
   -1.56402000E-03  -7.77400000E-05  -2.17830500E-02  +1.23979350E-01  +2.88850890E-01
   +9.33500000E-05  -7.40600000E-05  -7.50100000E-05  +2.42810000E-04  -7.62600000E-05
   -1.35570000E-04  +2.57800000E-05  +3.29080000E-04  +1.91440000E-04  +9.96100000E-05
   -4.02900000E-05  -2.07800000E-05  -1.12110000E-04  +1.14060000E-04  -4.97600000E-05
   -2.02740000E-04  +1.16680000E-04  +9.74000000E-05  -2.99912000E-03  +4.99970000E-04
   -4.62930000E-04  -9.84800000E-05  +1.80330000E-04  -1.85590000E-04  +5.71300000E-05
   -1.17170000E-04  +3.31300000E-05  +4.93214000E-03  +2.07546000E-03  -7.03800000E-05
   -4.84491900E-02  -4.97942000E-02  -2.39780000E-04  +2.27166000E-03  -8.11278000E-03
   -1.10636000E-03  +7.10537000E-03  -1.46512000E-03  +2.64168000E-03  -1.12379000E-03
   +3.84050000E-04  -9.64100000E-05  +6.18275000E-03  -1.01798000E-03  +1.32343000E-03
   -1.07960000E-04  -5.56580000E-04  +1.13250000E-04  -3.29100000E-05  +1.31050000E-04
   +4.85030000E-04  -1.24280000E-04  -5.41000000E-06  +1.43090000E-04  -2.57500000E-05
   +5.91000000E-06  -9.98400000E-05  -4.08801000E-03  +1.05045000E-03  -8.17810000E-04
   +3.78045700E-02  -3.32430000E-04  -1.80080000E-04  +3.82710000E-04  +1.34390000E-04
   +2.53900000E-05  +1.17400000E-03  +3.00700000E-05  +1.92040000E-04  +4.06390000E-04
   +9.27300000E-05  -6.70300000E-05  -5.65100000E-05  -1.24400000E-05  -2.68900000E-05
   -7.16000000E-05  -7.80000000E-05  +1.15490000E-04  -4.45100000E-05  +2.54400000E-04
   -7.65070000E-04  +1.12401000E-03  +1.30260000E-04  +8.49200000E-05  -3.97700000E-05
   +3.59400000E-05  -4.91400000E-05  +1.86100000E-05  -2.80469000E-03  -1.07600000E-02
   +2.24750000E-04  -5.07863400E-02  -3.26200420E-01  -2.55947100E-02  -2.43703000E-03
   -1.18743300E-02  -3.75521000E-03  -1.56985000E-03  +1.44262000E-03  +2.44443000E-03
   +3.58110000E-04  +7.05970000E-04  +7.24300000E-05  -5.21710000E-04  +3.81310000E-04
   -3.15644000E-03  -2.26150000E-04  -1.07361000E-03  +2.87040000E-04  -1.14520000E-04
   -9.79200000E-05  -2.31870000E-04  +3.00100000E-05  +9.86200000E-05  -1.48220000E-04
   +3.09200000E-05  -1.21200000E-05  -2.07900000E-04  +8.39440000E-04  +7.05010000E-04
   +4.13650000E-04  +5.66355700E-02  +3.47527520E-01  -9.40990000E-04  -3.38290000E-04
   -2.67420000E-04  +2.05770000E-04  +1.68610000E-04  -9.18030000E-04  +7.34000000E-06
   +6.51140000E-04  -1.94290000E-04  +1.40520000E-04  +9.42700000E-05  +1.44500000E-05
   -1.66190000E-04  +3.93100000E-04  -3.53700000E-05  +4.30200000E-05  -1.98860000E-04
   +2.62300000E-05  -7.08400000E-04  -5.55230000E-04  +4.71080000E-04  -8.85100000E-05
   +9.43700000E-05  +2.94500000E-05  +2.84320000E-04  -4.24290000E-04  -3.51000000E-06
   -5.21895000E-03  -2.73436200E-02  +3.82286000E-03  -5.37200000E-04  -2.54195700E-02
   -6.17322200E-02  +4.81139000E-03  +2.64112300E-02  +5.67705000E-03  +2.39076000E-03
   +1.92825000E-03  -3.63149000E-03  +5.17100000E-05  +3.06400000E-04  -1.22338000E-03
   +1.43017000E-03  -2.70153000E-03  -5.01685000E-03  +3.15700000E-04  +1.51975000E-03
   -1.10930000E-04  +7.53600000E-05  -5.43900000E-05  -3.74780000E-04  +3.74460000E-04
   +5.24590000E-04  +3.35100000E-05  -3.16100000E-05  +2.95400000E-05  +2.13860000E-04
   -9.19810000E-04  -1.35900000E-04  +7.84290000E-04  -1.42310000E-03  +2.64527500E-02
   +6.20487400E-02  +3.90280000E-04  +4.07730000E-04  -9.61000000E-06  +2.45550000E-04
   +3.18960000E-04  -2.86940000E-04  -1.13630000E-04  +7.42900000E-05  -1.71200000E-05
   -4.90100000E-05  -4.20000000E-07  +2.10900000E-05  +6.97000000E-05  +1.34000000E-06
   +1.70000000E-07  -3.16600000E-05  -1.07450000E-04  -1.73000000E-06  -3.39832000E-03
   +9.55740000E-04  -8.33310000E-04  +6.69640000E-04  -4.32890000E-04  -1.60000000E-06
   -5.11500000E-05  +4.02900000E-05  -1.00000000E-08  +4.97420000E-03  -2.13501000E-03
   -5.22278000E-03  +6.00289000E-03  -2.34229000E-03  +1.00413000E-03  -1.05236000E-03
   -5.86700000E-05  -1.01280000E-04  +7.17778000E-03  -2.44828000E-03  +2.16946000E-03
   +3.52443000E-03  +3.81657000E-03  +7.36014000E-03  -4.08849600E-02  +1.54599000E-03
   +1.26921200E-02  +4.71100000E-05  +2.27800000E-04  +3.98580000E-04  -1.01080000E-04
   -6.17940000E-04  +5.53170000E-04  -1.80410000E-04  -5.41640000E-04  +6.47600000E-05
   -2.02820000E-04  -2.18600000E-05  +7.67600000E-05  -6.76800000E-04  +1.57270000E-04
   -1.23710000E-04  -2.30200000E-05  -1.70010000E-04  -2.94330000E-04  +2.91374000E-02
   -1.88730000E-04  -2.03840000E-04  -8.15500000E-05  +1.06920000E-04  +6.46200000E-05
   +2.79190000E-04  -1.44700000E-05  -1.35000000E-05  +5.32100000E-05  -4.27800000E-05
   +6.03100000E-05  -1.32800000E-05  +4.92100000E-05  -5.50200000E-05  -1.21800000E-05
   +1.29500000E-05  +8.08300000E-05  +1.05200000E-05  +1.14594000E-03  +8.18920000E-04
   -1.21989000E-03  +5.22500000E-05  -4.85300000E-05  -5.32590000E-04  -5.08400000E-05
   +8.54000000E-05  +1.33400000E-05  +1.86472000E-03  -8.03198000E-03  -2.78963800E-02
   -2.54534000E-03  -5.93107000E-03  -7.29000000E-05  -1.17610000E-04  -8.25190000E-04
   +1.04062000E-03  -2.37410000E-03  -6.59870000E-04  +3.01763000E-03  -1.20763000E-03
   +1.09573800E-02  +1.61733100E-02  +1.86347000E-03  -1.23602250E-01  -1.20209840E-01
   -4.07000000E-06  +5.66430000E-04  +5.92580000E-04  +2.20800000E-05  +6.16100000E-05
   +8.06300000E-05  +1.26500000E-05  +2.36690000E-04  +1.71260000E-04  -3.91200000E-05
   -1.12240000E-04  +2.83170000E-04  +1.65110000E-04  +2.53800000E-05  -6.08900000E-05
   +1.50280000E-04  -6.05380000E-04  -1.55165000E-03  +1.88840000E-04  +1.26263570E-01
   -1.14770000E-04  -9.29100000E-05  -1.17000000E-06  -1.91190000E-04  -3.87600000E-05
   +6.18000000E-06  +4.91900000E-05  +3.65000000E-06  -4.31000000E-06  +4.34500000E-05
   -3.13600000E-05  +9.14000000E-06  -7.34900000E-05  +3.03000000E-05  -6.99000000E-06
   +1.05300000E-05  +4.17500000E-05  -1.35000000E-06  -3.50890000E-04  +6.67000000E-05
   -9.59540000E-04  +6.28490000E-04  +1.44661000E-03  -7.08460000E-04  +4.68000000E-05
   -5.79700000E-05  +4.91000000E-06  +1.54290000E-04  -1.11259000E-03  +1.72846000E-03
   +6.96920000E-04  -2.07640000E-04  +1.60978000E-03  -4.80100000E-05  +8.56990000E-04
   +2.71230000E-04  +2.14879000E-03  +3.17130000E-03  -1.26500000E-03  +8.65460000E-04
   -1.39477300E-02  -1.84157700E-02  +1.33526800E-02  -1.20724120E-01  -2.76016540E-01
   +1.05080000E-04  -6.46060000E-04  -1.38134000E-03  +6.01400000E-05  -2.18730000E-04
   +6.73700000E-05  +1.52530000E-04  +1.10910000E-04  +3.79000000E-06  +4.97800000E-05
   +1.67540000E-04  -2.59670000E-04  -9.96600000E-05  -1.33800000E-05  -9.74000000E-05
   +4.39700000E-05  +1.08390000E-04  +1.93500000E-05  -1.71424300E-02  +1.28648960E-01
   +2.96084770E-01  +6.01000000E-05  +3.21700000E-05  +3.35100000E-05  -1.07450000E-04
   -1.67120000E-04  +2.01960000E-04  +2.02700000E-05  +4.33600000E-05  +1.89600000E-05
   +4.22800000E-05  -4.32200000E-05  -2.03300000E-05  -5.42100000E-05  +1.51500000E-05
   -4.26000000E-06  -1.52500000E-05  +5.78000000E-06  +2.41000000E-06  +3.16050000E-04
   -2.65930000E-04  -5.23100000E-05  -5.73300000E-05  +4.75000000E-06  -4.77300000E-05
   +2.84200000E-05  -4.45500000E-05  +1.97000000E-06  +6.54367000E-03  -1.43626000E-03
   +2.40241000E-03  -1.01331000E-03  +3.52430000E-04  -1.48600000E-05  +5.23132000E-03
   -6.94560000E-04  +1.21808000E-03  +5.34518000E-03  +1.50448000E-03  +1.02597000E-03
   -4.67752900E-02  -5.71810100E-02  -5.06670000E-04  +1.25668000E-03  -7.34040000E-03
   -1.47264000E-03  -3.24711000E-03  +8.04460000E-04  -8.81780000E-04  +6.49200000E-05
   -1.78700000E-05  -3.48300000E-05  -7.44200000E-05  -7.15100000E-05  -1.27100000E-05
   -5.16450000E-04  +9.82300000E-05  -1.23510000E-04  +1.14300000E-05  +1.49190000E-04
   +1.00500000E-05  -6.51240000E-04  +9.17700000E-05  -1.27540000E-04  -4.18107000E-03
   +1.11965000E-03  -7.45330000E-04  +3.77331400E-02  -1.04540000E-04  -8.08100000E-05
   -3.07600000E-05  -1.31100000E-04  -5.03000000E-06  +1.13570000E-04  +5.98600000E-05
   -5.91000000E-06  +1.26800000E-05  +4.02600000E-05  -2.24200000E-05  -7.26000000E-06
   -6.53700000E-05  +5.24200000E-05  -1.72000000E-06  +8.56000000E-06  +8.20000000E-07
   -2.84000000E-06  -6.10000000E-06  -3.21570000E-04  -5.28500000E-04  +4.26000000E-06
   -6.62500000E-05  -3.69200000E-05  +5.86100000E-05  -7.77800000E-05  +4.57000000E-06
   -1.80987000E-03  +1.05522000E-03  +2.69584000E-03  +3.81640000E-04  +7.14790000E-04
   -5.02100000E-05  -5.43070000E-04  +5.13250000E-04  -2.96577000E-03  -4.02544000E-03
   -1.17816900E-02  +3.13224000E-03  -5.68558700E-02  -3.31005950E-01  -2.33092800E-02
   -2.08961000E-03  -1.06534100E-02  -3.60818000E-03  +8.64670000E-04  +1.05475000E-03
   +4.81510000E-04  +3.49200000E-05  -8.32400000E-05  +1.30170000E-04  +1.25480000E-04
   +1.06520000E-04  +2.95000000E-05  +1.14080000E-04  +1.18890000E-04  +1.66940000E-04
   -9.46700000E-05  -5.18200000E-04  -1.07700000E-05  +1.16970000E-04  -1.06300000E-04
   +1.43700000E-05  +9.80970000E-04  +6.23520000E-04  +4.60190000E-04  +6.30224200E-02
   +3.50535050E-01  +8.69400000E-05  +9.43700000E-05  +1.99400000E-05  +1.64850000E-04
   +4.67000000E-05  -1.76880000E-04  -5.57700000E-05  +2.19700000E-05  -2.91000000E-06
   -3.19500000E-05  +2.70700000E-05  +2.04300000E-05  +4.65000000E-05  -1.77300000E-05
   -1.91000000E-06  -1.13100000E-05  -1.56300000E-05  +7.17000000E-06  +5.74700000E-05
   +9.05130000E-04  +5.38820000E-04  -4.25200000E-05  +1.41900000E-05  +1.09510000E-04
   -3.60600000E-05  +4.45200000E-05  -9.30000000E-07  +2.41390000E-03  +2.36379000E-03
   -3.54668000E-03  +1.47450000E-04  +3.05180000E-04  -1.58749000E-03  +1.33633000E-03
   -2.31475000E-03  -4.82686000E-03  -5.64013000E-03  -2.85507000E-02  +3.72080000E-03
   -3.10600000E-05  -2.16682300E-02  -6.11518800E-02  +4.66387000E-03  +2.60145100E-02
   +6.62624000E-03  -7.76410000E-04  +8.42290000E-04  +1.95775000E-03  -4.80900000E-05
   +6.24400000E-05  -1.31290000E-04  -7.82100000E-05  -1.05430000E-04  -1.93000000E-05
   -1.01170000E-04  +2.63840000E-04  +3.35550000E-04  -2.78700000E-04  -1.47323000E-03
   -7.24100000E-05  -1.29740000E-04  +4.72900000E-05  +6.57900000E-05  -9.39530000E-04
   -1.40340000E-04  +8.23540000E-04  -8.19860000E-04  +2.32580800E-02  +5.73849800E-02
   -4.27200000E-05  +2.28647000E-03  -1.07370000E-04  -5.74370000E-03  -2.66728000E-03
   -6.99690000E-04  -3.90700000E-04  -1.27297000E-03  +2.90900000E-05  +7.89400000E-05
   +2.80010000E-04  -2.04800000E-05  +1.91020000E-04  -2.70690000E-04  -1.05700000E-05
   -5.26060000E-04  -2.10990000E-04  +3.19300000E-05  -1.74918200E-02  +2.82825200E-02
   -1.43642000E-03  +8.60660000E-04  +1.45323000E-03  +1.01722000E-03  -1.37550000E-04
   +2.85190000E-04  +8.70000000E-07  +6.66040000E-04  +1.12472000E-03  -1.00467000E-03
   +7.55800000E-05  -1.23500000E-04  +7.19630000E-04  +3.79500000E-05  +4.50890000E-04
   -2.31740000E-04  -1.53710000E-04  -4.59770000E-04  -4.02300000E-05  -1.01120000E-04
   -2.53920000E-04  +3.02650000E-04  +2.81240000E-04  -2.02300000E-05  +2.01900000E-05
   +1.06600000E-04  +1.75820000E-04  -2.66720000E-04  -1.01331310E-01  +1.08539850E-01
   -6.67435000E-03  -8.70600000E-05  -3.58810000E-04  -2.43000000E-06  -1.24300000E-05
   +3.03000000E-06  +4.07500000E-05  -5.90000000E-07  -3.81000000E-06  -1.27100000E-05
   +4.36400000E-05  -5.45200000E-05  -9.55900000E-05  -1.08600000E-04  -6.47100000E-05
   -7.27500000E-05  -4.33000000E-06  +9.35000000E-06  +1.65900000E-05  +1.14775190E-01
   -5.24330000E-04  +3.67000000E-06  -4.94000000E-06  -1.30763000E-03  +1.86840000E-04
   -2.13520000E-04  -5.52710000E-04  -5.95690000E-04  +3.15100000E-05  +3.64290000E-04
   +2.79300000E-04  +2.30300000E-05  -9.19900000E-05  +6.49400000E-05  -1.19400000E-05
   +4.77000000E-05  -8.14200000E-05  +1.02200000E-05  -3.46285000E-03  +3.31273000E-03
   -5.58770000E-04  -7.55320000E-04  +5.54310000E-04  -2.55900000E-05  +1.90940000E-04
   -1.72010000E-04  +5.99000000E-06  -9.36890000E-04  +1.03023000E-03  +5.15310000E-04
   -5.85400000E-05  -1.27880000E-04  -5.02910000E-04  +2.30900000E-05  -4.35000000E-05
   +7.57200000E-05  +3.17800000E-05  +7.90200000E-05  +7.50800000E-05  +5.37300000E-05
   +6.58300000E-05  -8.63400000E-05  -2.84300000E-05  +1.95680000E-04  -1.97310000E-04
   -1.14600000E-05  +3.50000000E-05  -5.69600000E-05  +1.11420730E-01  -2.60205300E-01
   +1.31107800E-02  +2.13270000E-04  +3.50160000E-04  -6.73000000E-06  +1.35800000E-05
   -7.95000000E-06  +6.88000000E-06  +2.01900000E-05  -1.25200000E-05  -2.66000000E-06
   -3.50600000E-05  +5.26200000E-05  +7.60600000E-05  +2.30100000E-05  -1.37000000E-05
   -4.19200000E-05  +5.27000000E-06  +1.38100000E-05  -1.64700000E-05  -1.18509880E-01
   +2.80377520E-01  -9.71600000E-05  +1.45910000E-04  +3.90310000E-04  -3.43130000E-04
   -2.84700000E-04  +3.33110000E-04  +1.38000000E-05  -2.18800000E-05  +3.66870000E-04
   -5.39200000E-05  +1.84300000E-05  +1.23530000E-04  +3.32800000E-05  +2.69600000E-05
   -2.56800000E-05  -3.43000000E-05  -5.57300000E-05  -5.25500000E-05  -9.94230000E-04
   +2.48473000E-03  -1.73252000E-03  -5.91880000E-04  +1.10253000E-03  -3.20200000E-05
   -6.00000000E-07  -7.13000000E-06  -1.21900000E-05  +6.44070000E-04  -6.60190000E-04
   +1.16770000E-04  -1.07970000E-04  -4.10830000E-04  -7.16500000E-05  -5.29200000E-05
   +2.10330000E-04  -1.09780000E-04  +9.52000000E-06  -4.89700000E-05  -1.55190000E-04
   -5.72900000E-05  +1.21200000E-05  +4.61000000E-05  +5.68900000E-05  +2.62920000E-04
   +9.99400000E-05  -1.91500000E-05  -2.40200000E-05  +7.26400000E-05  -6.87683000E-03
   +1.33640300E-02  -4.81697500E-02  +2.66100000E-05  +6.20000000E-06  -3.84700000E-05
   +1.37200000E-05  -2.73000000E-06  -1.03100000E-05  +1.17600000E-05  -7.60000000E-06
   +9.12000000E-06  +5.46600000E-05  +5.39500000E-05  +1.35160000E-04  +2.29000000E-06
   -5.28800000E-05  +1.50700000E-05  +8.06000000E-06  -7.09000000E-06  +1.57400000E-05
   +8.08887000E-03  -1.39363400E-02  +4.80563700E-02  -5.06220000E-04  -3.37790000E-04
   -2.43840000E-04  +1.26635000E-03  -5.68920000E-04  +1.16150000E-04  -3.71460000E-04
   +1.56760000E-04  -4.47700000E-05  +1.65900000E-04  +2.85200000E-04  -6.14800000E-05
   +4.86200000E-05  +1.23840000E-04  +3.03500000E-05  +1.34670000E-04  -1.29350000E-04
   +2.05500000E-05  -1.10931200E-02  -1.63834700E-02  +2.52169600E-02  +1.31747000E-03
   +2.98300000E-04  +1.67556000E-03  +1.18630000E-04  -1.23870000E-04  -1.03100000E-05
   -5.57630000E-03  -8.21730000E-04  -1.83163000E-03  +1.26000000E-06  -3.81280000E-04
   +8.89400000E-05  +2.15600000E-04  -2.15960000E-04  +2.49000000E-05  +7.11300000E-05
   +1.11980000E-04  -5.58990000E-04  +3.22720000E-04  -1.83770000E-04  +5.92960000E-04
   -2.10360000E-04  +1.84930000E-04  +6.14430000E-04  -2.19630000E-04  -3.84550000E-04
   +6.98340000E-04  -8.12087100E-02  -4.71336400E-02  +7.35253300E-02  +2.69080000E-04
   +3.18750000E-04  -5.88400000E-05  -5.27000000E-06  -2.27800000E-05  -7.73500000E-05
   -1.69700000E-05  -4.17000000E-06  +7.34200000E-05  -1.07750000E-04  +1.58180000E-04
   +3.21200000E-05  -2.45600000E-04  -3.53300000E-05  -7.42900000E-05  +1.25200000E-05
   -7.27500000E-05  +7.35000000E-05  +5.42655000E-03  +6.59924000E-03  -1.25869600E-02
   +8.86209400E-02  -6.94100000E-05  +1.35560000E-04  +5.77300000E-05  +1.46950000E-04
   +6.78600000E-05  -2.16760000E-04  +7.45140000E-04  -6.21120000E-04  -6.15660000E-04
   -5.45200000E-05  +8.31500000E-05  -8.01000000E-06  +9.89500000E-05  -3.93800000E-05
   +5.56700000E-05  -2.39200000E-05  -3.99500000E-05  -1.76000000E-05  -1.35954000E-03
   -3.46670000E-03  +3.43228000E-03  +1.83940000E-04  +7.27600000E-05  +4.92950000E-04
   -6.26100000E-05  +7.89800000E-05  -3.42000000E-06  -1.75559000E-03  +6.79600000E-04
   -1.33320000E-04  +9.90800000E-05  -2.25000000E-06  -7.51290000E-04  +4.45500000E-05
   -5.73610000E-04  +3.39650000E-04  +1.25310000E-04  +5.59710000E-04  -9.50000000E-06
   +1.49820000E-04  +1.13790000E-04  -2.28810000E-04  -1.71610000E-04  +1.39220000E-04
   +2.49970000E-04  -1.37140000E-04  -2.40890000E-04  +3.37320000E-04  -4.73800000E-02
   -1.12963150E-01  +1.03535310E-01  -3.70900000E-05  -5.87800000E-05  -1.12310000E-04
   +1.03600000E-05  -6.41000000E-06  -5.03300000E-05  +1.19500000E-05  -1.79100000E-05
   +4.19700000E-05  -2.18240000E-04  +1.29650000E-04  +5.34500000E-05  +5.87000000E-06
   -6.23000000E-05  -5.20000000E-07  -2.30400000E-05  -2.31000000E-05  +8.47000000E-06
   -1.11133000E-02  -1.26842900E-02  +2.25861300E-02  +5.27935700E-02  +1.21121870E-01
   +2.52920000E-04  +3.65000000E-06  -4.21700000E-05  +2.99100000E-05  +3.16200000E-04
   +1.61800000E-05  +7.86340000E-04  +1.00495000E-03  +4.41830000E-04  -4.95710000E-04
   -3.01670000E-04  +3.44800000E-05  +6.73100000E-05  +1.38010000E-04  -6.62600000E-05
   -7.45100000E-05  -3.83300000E-05  +1.28200000E-05  -2.28881000E-03  -2.37381000E-03
   +1.78702000E-03  -8.45330000E-04  -5.80820000E-04  +7.86560000E-04  -9.72600000E-05
   -1.15200000E-05  +1.14000000E-06  +3.65800000E-04  +5.60300000E-04  +1.75420000E-04
   +3.51520000E-04  +2.68510000E-04  +1.56240000E-04  +6.29600000E-05  -2.95270000E-04
   +3.06520000E-04  -3.48000000E-05  +2.50170000E-04  +5.08110000E-04  +1.35410000E-04
   +1.18720000E-04  -5.40140000E-04  +2.35600000E-05  -9.29170000E-04  +3.07500000E-04
   +4.75000000E-05  +1.34940000E-04  -2.77420000E-04  +7.50423500E-02  +1.02948160E-01
   -2.13093940E-01  -1.78700000E-04  -2.72130000E-04  +5.17500000E-05  -1.41100000E-05
   -1.00700000E-05  +4.32800000E-05  +5.41000000E-06  -6.21000000E-06  -3.02100000E-05
   -3.25050000E-04  +1.46830000E-04  +2.38800000E-05  -3.55800000E-05  +3.06800000E-05
   +3.80400000E-05  -3.41100000E-05  +2.11000000E-05  -2.53500000E-05  -2.58090000E-04
   -4.00630000E-04  -8.04120000E-04  -8.15429500E-02  -1.14341180E-01  +2.28795800E-01
   -5.01450000E-04  -3.08800000E-04  +2.24650000E-04  +1.71719000E-03  -5.84930000E-04
   +6.83200000E-05  -1.65560000E-04  +3.32630000E-04  -1.15400000E-04  -6.53800000E-05
   +2.71130000E-04  +6.87600000E-05  +1.77230000E-04  +1.51920000E-04  +1.19600000E-05
   +1.12110000E-04  -1.81370000E-04  -2.88000000E-05  -5.35740000E-03  -1.65667500E-02
   -2.63623700E-02  -6.82903000E-03  -9.34160000E-04  +2.56010000E-04  +3.74000000E-05
   -6.24800000E-05  +5.62000000E-06  +1.01440000E-03  +1.17377000E-03  -1.30621000E-03
   +7.04100000E-05  -5.88610000E-04  -3.42300000E-04  -5.27600000E-05  -1.94950000E-04
   +5.37260000E-04  +1.77700000E-05  +4.44130000E-04  +3.87590000E-04  +8.22600000E-05
   +1.50200000E-04  -5.76690000E-04  -4.26400000E-05  -6.67220000E-04  +3.33630000E-04
   +2.03600000E-05  +9.19600000E-05  -1.55290000E-04  -5.79960900E-02  -2.73991200E-02
   -4.31472900E-02  +1.78100000E-04  +2.38170000E-04  +1.26740000E-04  +9.60000000E-07
   -1.31500000E-05  +2.97900000E-05  -1.78000000E-06  -3.47800000E-05  +3.73000000E-06
   -5.94340000E-04  +3.16560000E-04  +4.17340000E-04  +1.93000000E-06  +1.13280000E-04
   -2.06700000E-05  -2.04100000E-05  +5.37000000E-06  -5.94000000E-06  +2.79776000E-03
   +6.89555000E-03  +1.31509900E-02  +1.80870000E-03  +7.09856000E-03  +9.36296000E-03
   +6.38705100E-02  -2.89600000E-05  +1.78620000E-04  -1.48200000E-05  +1.64240000E-04
   +1.07360000E-04  +4.87230000E-04  +6.70120000E-04  -5.53140000E-04  +6.50930000E-04
   -8.47000000E-05  +8.03900000E-05  -1.65600000E-05  +1.24350000E-04  -4.79200000E-05
   -4.32000000E-05  -2.29400000E-05  -4.06400000E-05  +4.42000000E-06  -1.97660000E-04
   -3.81134000E-03  -3.25205000E-03  -1.60224000E-03  -1.67280000E-04  +3.70630000E-04
   -8.76600000E-05  +1.09510000E-04  -1.38000000E-06  +2.70900000E-04  +3.00710000E-04
   -8.32680000E-04  +2.46400000E-04  +9.12400000E-05  -1.55200000E-05  +4.06400000E-05
   -3.61660000E-04  +4.09500000E-04  -3.71500000E-05  +2.75980000E-04  +2.70230000E-04
   +6.17200000E-05  +1.37870000E-04  -3.54920000E-04  -1.34090000E-04  -5.61050000E-04
   +2.04980000E-04  +1.67900000E-05  +2.25900000E-05  -4.87900000E-05  -2.81406700E-02
   -1.16773150E-01  -1.14196760E-01  -1.13410000E-04  -9.08700000E-05  +1.20180000E-04
   -2.14200000E-05  -1.00700000E-05  +1.45700000E-05  -2.05600000E-05  -2.53000000E-06
   +1.98000000E-06  -1.60030000E-04  +2.49790000E-04  -1.78100000E-05  +6.12500000E-05
   +1.21910000E-04  +1.03100000E-05  -1.10000000E-06  -4.60000000E-07  -2.32000000E-06
   -6.45398000E-03  -1.36111400E-02  -2.40873400E-02  +4.26680000E-03  +8.67255000E-03
   +1.43164000E-02  +3.03663100E-02  +1.25967880E-01  -3.91150000E-04  -5.44400000E-05
   -5.01000000E-06  +3.46210000E-04  -5.76000000E-04  +2.09480000E-04  -7.97180000E-04
   -7.89370000E-04  +4.23850000E-04  +3.70440000E-04  +3.59750000E-04  +1.01020000E-04
   +2.13600000E-05  -6.78700000E-05  -7.35900000E-05  +1.08530000E-04  -4.06700000E-05
   +1.51000000E-06  +2.99230000E-04  -5.21480000E-04  -3.21971000E-03  -1.82242000E-03
   -1.12100000E-05  +7.21370000E-04  +8.80200000E-05  +1.47000000E-06  +9.70000000E-07
   +2.34960000E-04  +1.05966000E-03  +5.30730000E-04  +5.87210000E-04  +2.10910000E-04
   -2.22640000E-04  -4.63000000E-06  -1.91240000E-04  +1.72350000E-04  -2.53000000E-06
   +2.33590000E-04  +7.65000000E-05  +8.21100000E-05  +1.01430000E-04  -1.53910000E-04
   -5.68700000E-05  -3.66800000E-04  +9.61900000E-05  -4.01600000E-05  -6.83800000E-05
   +9.17500000E-05  -4.53923000E-02  -1.14528590E-01  -2.35692140E-01  +1.64210000E-04
   +3.02060000E-04  +8.70700000E-05  +2.96000000E-06  -2.60000000E-06  -1.35700000E-05
   +1.91600000E-05  -1.76900000E-05  +3.01800000E-05  +2.62540000E-04  +3.98000000E-05
   -2.09900000E-05  +6.67000000E-06  +5.94500000E-05  -1.24400000E-05  -1.97400000E-05
   -8.20000000E-06  -1.15000000E-06  +1.00513000E-03  +2.07443000E-03  +2.12693000E-03
   -5.23856000E-03  -1.33747100E-02  -1.88102700E-02  +4.94904500E-02  +1.25634240E-01
   +2.53698990E-01  +4.36760000E-04  +3.53820000E-04  -1.36430000E-04  +3.19930000E-04
   +3.96600000E-05  -1.32130000E-04  -5.36400000E-05  -3.72500000E-05  +1.38700000E-05
   +2.54700000E-05  -4.84300000E-05  +1.66000000E-05  -4.53000000E-05  +7.36300000E-05
   +2.27800000E-05  +4.35200000E-05  -1.87080000E-04  -4.11000000E-05  -2.53912000E-03
   -1.53960000E-04  -2.40400000E-04  -2.98640750E-01  -7.23207600E-02  -3.44108200E-02
   +6.05300000E-05  -9.96800000E-05  +2.04700000E-05  +1.54460000E-04  -1.65550000E-04
   +5.45040000E-04  +9.42400000E-05  +8.77700000E-05  -2.42460000E-04  -3.63800000E-05
   -1.57000000E-05  +1.17880000E-04  -6.91200000E-05  -6.20000000E-07  +5.02500000E-05
   +7.74100000E-05  +2.74360000E-04  +1.01940000E-04  +2.77950000E-04  -6.05470000E-04
   -1.52090000E-04  +8.54000000E-06  +4.50600000E-05  +1.08500000E-05  +6.92270000E-04
   -8.72910000E-04  -1.31771000E-03  -2.93308000E-03  +1.39058000E-03  +1.94996000E-03
   -4.04000000E-06  -1.97000000E-06  +7.36000000E-06  -1.02400000E-05  +9.20000000E-06
   -7.48000000E-06  +1.33000000E-06  +4.00600000E-05  +6.20200000E-05  -1.66630000E-04
   +4.50870000E-04  -2.23100000E-05  +2.87300000E-05  -1.30000000E-07  -2.40800000E-05
   +2.95300000E-04  -7.68400000E-05  +2.10600000E-04  +1.58130000E-04  +1.89190000E-04
   +1.04030000E-04  -1.96420000E-04  -1.46790000E-04  -9.46000000E-06  +3.23100720E-01
   -9.02360000E-04  -2.28325000E-03  -5.59170000E-04  -3.02000000E-04  +8.21270000E-04
   +4.19250000E-04  +9.56000000E-06  -4.43780000E-04  +1.19160000E-04  -1.07100000E-04
   +2.92710000E-04  -3.90800000E-05  +1.62810000E-04  -9.45600000E-05  -1.45300000E-05
   +1.36850000E-04  +1.41280000E-04  -4.26000000E-06  -1.45947000E-02  -4.87543000E-03
   -4.54250000E-04  -7.02681300E-02  -6.92495500E-02  -9.10096000E-03  -4.29300000E-05
   +1.22990000E-04  +1.93400000E-05  +4.23500000E-04  +2.74610000E-04  +7.34260000E-04
   +1.70860000E-04  -1.17550000E-04  -3.25900000E-05  -7.93000000E-06  -2.20400000E-05
   -1.97900000E-05  -1.00300000E-05  +3.98300000E-05  +9.18900000E-05  -2.10000000E-05
   -7.48900000E-05  -1.63620000E-04  +9.48000000E-05  +3.89850000E-04  +3.60260000E-04
   +3.34800000E-05  +2.84000000E-05  -1.12000000E-04  +2.33060000E-04  -1.59795000E-03
   -2.76712000E-03  +8.40150000E-04  +8.43030000E-04  +2.30120000E-04  -8.02000000E-06
   +2.50000000E-07  +6.86000000E-06  -2.67100000E-05  +3.27000000E-06  -2.29800000E-05
   -2.84300000E-05  -1.35400000E-05  -2.35400000E-05  +4.17340000E-04  -4.94890000E-04
   +4.05340000E-04  +7.48000000E-06  +8.00000000E-06  +2.09000000E-06  -3.05580000E-04
   +2.83440000E-04  -1.31840000E-04  +4.37420000E-04  +8.89700000E-05  -5.21800000E-05
   -1.07729000E-03  +3.49590000E-04  -4.47660000E-04  +7.79023400E-02  +7.20889800E-02
   -1.05873000E-03  -2.00654000E-03  +6.38800000E-05  +2.28160000E-04  +1.19967000E-03
   +5.63260000E-04  -2.35900000E-05  -2.95250000E-04  +1.05460000E-04  -3.50000000E-05
   +1.94560000E-04  -9.72000000E-06  +8.04900000E-05  -4.77700000E-05  -1.05600000E-05
   +1.79130000E-04  +3.17560000E-04  -7.28100000E-05  -2.77504800E-02  -6.42202000E-03
   -3.08840000E-03  -3.05276700E-02  -8.76602000E-03  -5.12885300E-02  -2.30900000E-05
   +9.63100000E-05  -2.70000000E-06  -5.50530000E-04  +2.50700000E-05  +1.60346000E-03
   +2.66400000E-04  -1.78550000E-04  -2.38180000E-04  -8.86500000E-05  -2.09920000E-04
   +2.39050000E-04  +3.42900000E-05  +2.84970000E-04  +1.01530000E-04  +1.96440000E-04
   +1.80120000E-04  -1.88340000E-04  -1.10090000E-04  +8.10200000E-05  -2.47000000E-04
   -2.40900000E-05  -5.71800000E-05  +8.44500000E-05  -5.04300000E-05  -3.00874000E-03
   -5.42215000E-03  +1.01161000E-03  +4.33290000E-04  -4.65150000E-04  -7.29000000E-06
   +7.67000000E-06  -1.88900000E-05  -3.28400000E-05  -7.90000000E-07  +1.07400000E-05
   -6.12800000E-05  +5.20400000E-05  +4.56800000E-05  -4.45030000E-04  +6.87660000E-04
   -5.67790000E-04  -3.07400000E-05  +8.49000000E-06  -2.37000000E-05  +3.00100000E-04
   +5.17400000E-05  -1.46000000E-05  -3.95000000E-06  -2.04730000E-04  +2.21660000E-04
   -1.97475000E-03  -6.39000000E-04  -1.53980000E-04  +3.57808700E-02  +1.16578700E-02
   +5.58945400E-02  -3.19570000E-04  -4.40270000E-04  +8.56400000E-05  +1.06710000E-04
   +3.91900000E-05  +5.56870000E-04  +4.39500000E-05  +1.72090000E-04  +1.62600000E-05
   +3.17700000E-05  +1.73600000E-05  -2.35400000E-05  -6.38900000E-05  +5.13500000E-05
   +2.01400000E-05  -3.92800000E-05  +1.68710000E-04  -5.21400000E-05  -5.40990000E-04
   +2.64468000E-03  -3.05810000E-03  -6.63585100E-02  -4.39785600E-02  +5.25340000E-02
   +3.18100000E-05  -4.03700000E-05  -2.60700000E-05  +1.63370000E-04  -2.51060000E-04
   -5.40420000E-04  +3.45790000E-04  +4.48800000E-05  -2.58120000E-04  -7.12800000E-05
   -1.26870000E-04  +5.06200000E-05  -1.53200000E-05  +1.46630000E-04  -3.82000000E-06
   +1.25090000E-04  +2.14300000E-05  -8.42400000E-05  +2.47030000E-04  -1.40900000E-04
   -5.02200000E-05  -2.46600000E-05  -4.61000000E-05  +6.72400000E-05  +4.03040000E-04
   +7.45090000E-04  -9.78010000E-04  -3.30050000E-04  +4.66110000E-04  +6.98500000E-05
   -6.00000000E-08  +2.54000000E-06  -1.23400000E-05  -4.48400000E-05  +1.29300000E-05
   -1.13500000E-05  +3.17600000E-05  +8.90000000E-06  +2.19700000E-05  -3.74450000E-04
   +7.82900000E-05  +8.99600000E-05  +2.45600000E-05  -8.10000000E-06  +3.72000000E-06
   +1.85100000E-05  +1.33100000E-05  -7.35100000E-05  -2.06960000E-04  -4.14850000E-04
   -2.92560000E-04  +5.62000000E-06  +4.73700000E-05  +2.19270000E-04  -5.58180000E-03
   -1.91164200E-02  +2.37071800E-02  +6.72771100E-02  -4.40100000E-05  +2.62700000E-05
   -6.25000000E-06  +5.19250000E-04  +1.11577000E-03  -1.05146000E-03  -2.15610000E-04
   +1.90980000E-04  +9.22900000E-05  -1.29800000E-05  +1.43000000E-06  +3.21700000E-05
   +7.78100000E-05  -1.22880000E-04  -7.94000000E-06  +2.34200000E-05  +9.10600000E-05
   -3.50000000E-07  +4.18446000E-03  +8.05974000E-03  -1.38343400E-02  -4.38682600E-02
   -1.48448600E-01  +1.25331200E-01  -1.12900000E-04  +1.68860000E-04  -9.84000000E-06
   -8.79850000E-04  -1.92470000E-03  -2.51914000E-03  +2.24370000E-04  +7.10720000E-04
   -9.00140000E-04  +8.22900000E-05  -1.58580000E-04  -4.21600000E-05  -1.08400000E-05
   -1.78200000E-05  +1.76200000E-05  +5.75000000E-05  +4.05140000E-04  +1.44230000E-04
   -1.75630000E-04  -9.82610000E-04  -1.35330000E-04  -1.36300000E-05  +2.75700000E-05
   +8.81300000E-05  +6.61080000E-04  +3.80820000E-04  -1.37780000E-04  -3.72600000E-05
   +7.26000000E-06  +7.29900000E-05  -6.00000000E-08  -2.42000000E-06  +7.70000000E-07
   +3.55000000E-05  +3.31600000E-05  -5.31900000E-05  -5.72200000E-05  +8.63600000E-05
   +2.42600000E-05  +1.33960000E-04  +5.74340000E-04  +3.62600000E-04  -6.40000000E-07
   +2.50000000E-06  -2.41900000E-05  -1.40870000E-04  -3.42200000E-05  +4.82100000E-05
   +3.50000000E-07  +1.36200000E-04  +5.79300000E-05  +2.05600000E-04  +8.17000000E-05
   -1.30900000E-05  -7.36750000E-04  -5.43683000E-03  +5.45030000E-03  +4.81623900E-02
   +1.60172740E-01  +7.31660000E-04  +4.36720000E-04  +1.76760000E-04  -5.98100000E-04
   +1.55105000E-03  +9.40400000E-04  +3.92600000E-05  -4.69300000E-04  +2.60720000E-04
   -1.67000000E-04  -1.18980000E-04  -7.98900000E-05  +1.14370000E-04  -1.33780000E-04
   -4.26300000E-05  +7.91500000E-05  +4.07600000E-05  -6.67000000E-06  +7.75755000E-03
   +1.72354200E-02  -2.29767300E-02  +5.17949300E-02  +1.22395200E-01  -1.94185590E-01
   -1.57470000E-04  +2.05830000E-04  +1.36000000E-05  -1.43429000E-03  -4.28469000E-03
   -3.33663000E-03  +3.89460000E-04  +1.45776000E-03  -9.21820000E-04  +1.33110000E-04
   -2.26400000E-04  -4.09910000E-04  -1.24430000E-04  -2.57520000E-04  +2.32570000E-04
   +2.37000000E-06  +9.09600000E-05  -1.03000000E-05  -7.60400000E-05  -8.02740000E-04
   +1.12980000E-04  +1.08540000E-04  +2.37400000E-04  -3.31080000E-04  +1.22393000E-03
   +1.10747000E-03  +5.20480000E-04  -2.49520000E-04  -4.33840000E-04  -7.61000000E-05
   -1.16800000E-05  -1.63100000E-05  +6.19000000E-05  +5.64000000E-05  +7.81700000E-05
   -1.64750000E-04  -6.26300000E-05  -7.89000000E-05  -2.07300000E-05  -3.84100000E-05
   -4.35700000E-05  +2.69780000E-04  +1.79900000E-05  +3.93700000E-05  -3.29500000E-05
   +1.79700000E-05  -1.24060000E-04  +3.02100000E-05  -9.74740000E-04  -4.79480000E-04
   +2.47430000E-04  +3.37500000E-05  -2.96290000E-04  +4.69920000E-04  -8.87740000E-04
   -3.61287000E-03  +3.71345000E-03  -5.67563500E-02  -1.31889700E-01  +2.14217120E-01
   -5.65430000E-04  -1.20686000E-03  -2.71290000E-04  +8.34810000E-04  -4.05280000E-04
   -5.98160000E-04  -5.19000000E-06  -3.55180000E-04  +1.28370000E-04  -4.82200000E-05
   +1.79070000E-04  +8.53600000E-05  +1.20520000E-04  -1.14900000E-04  +1.07000000E-05
   +2.42900000E-05  +1.26590000E-04  -3.17600000E-05  +1.07368000E-03  -4.01223000E-03
   -5.61350000E-04  -1.39093510E-01  +1.25878460E-01  +6.46301000E-03  -4.69000000E-05
   +9.39300000E-05  +1.18500000E-05  +7.19800000E-05  +4.09050000E-04  -1.47870000E-04
   -8.10300000E-05  -1.94530000E-04  +1.84920000E-04  +1.34800000E-05  -7.26000000E-06
   -1.02780000E-04  -7.21000000E-06  +8.01900000E-05  -3.32000000E-06  -1.73000000E-05
   -4.06990000E-04  -2.73790000E-04  +1.95160000E-04  +9.46520000E-04  +5.77190000E-04
   +9.44000000E-06  -3.82700000E-05  -8.68000000E-05  +5.44270000E-04  -1.27423000E-03
   -5.96930000E-04  -2.42350000E-04  +8.32620000E-04  +7.38290000E-04  -1.50000000E-06
   +2.23000000E-06  -5.88000000E-06  -3.57000000E-06  -1.24100000E-05  -1.48000000E-06
   -3.51000000E-06  -5.33300000E-05  -7.48500000E-05  -3.83130000E-04  -7.37340000E-04
   +4.61980000E-04  +1.05000000E-06  -3.94000000E-06  +3.67500000E-05  +1.25340000E-04
   -1.87700000E-04  -4.86010000E-04  -2.89400000E-05  -2.50000000E-05  +1.66500000E-04
   +1.19680000E-04  -4.08500000E-05  +2.08580000E-04  -1.51918900E-02  +2.57932600E-02
   +9.39670000E-04  +5.17256000E-03  -8.04809000E-03  -9.85290000E-04  +1.47343570E-01
   -1.00653000E-03  -1.03777000E-03  -1.02450000E-04  -8.48520000E-04  -1.21347000E-03
   -3.69261000E-03  +6.17380000E-04  +5.69490000E-04  -3.38330000E-04  +4.37800000E-04
   -3.08080000E-04  +2.80370000E-04  -5.44740000E-04  +2.79410000E-04  -2.34900000E-05
   -8.77500000E-05  +5.63400000E-05  +1.48010000E-04  +8.41262000E-03  -1.31921500E-02
   +2.02000000E-04  +1.25309190E-01  -2.20578250E-01  -8.97060000E-03  +4.15820000E-04
   -5.68840000E-04  -2.82000000E-06  -1.67030000E-04  -1.06020000E-04  +4.92520000E-04
   -4.90100000E-05  +4.71700000E-05  -2.24490000E-04  -1.95600000E-05  -6.31000000E-06
   +6.11700000E-05  +5.11800000E-05  -5.40200000E-05  +7.93000000E-05  +3.21000000E-05
   +3.21650000E-04  +1.26450000E-04  -8.01320000E-04  -5.98790000E-04  +6.63380000E-04
   -3.67000000E-06  +4.72900000E-05  +7.14000000E-06  +9.59750000E-04  +3.09880000E-04
   +8.81620000E-04  +1.63850000E-04  +9.17980000E-04  +2.00090000E-04  +4.62000000E-06
   -8.32000000E-06  +9.40000000E-06  +2.25500000E-05  +9.70000000E-07  -8.54000000E-06
   +3.39500000E-05  +1.26000000E-06  +6.52900000E-05  -5.54610000E-04  +1.02240000E-04
   +1.29188000E-03  -1.32000000E-05  +1.01800000E-05  -2.62700000E-05  -8.03290000E-04
   +3.14330000E-04  -5.15760000E-04  -2.31200000E-05  -2.29080000E-04  -1.53900000E-05
   -1.43720000E-04  +4.63230000E-04  +1.60250000E-04  -5.58451000E-03  +8.54645000E-03
   +6.82730000E-04  +1.16850000E-02  -1.51661500E-02  -1.52925000E-03  -1.37373570E-01
   +2.41221480E-01  -3.13970000E-04  -9.12840000E-04  +1.01290000E-04  -1.70185000E-03
   -1.86178000E-03  -4.24344000E-03  +6.83080000E-04  -3.92150000E-04  -8.58100000E-05
   +2.94370000E-04  -3.37420000E-04  +3.90790000E-04  -4.28500000E-04  +8.08900000E-05
   -6.12400000E-05  -5.91600000E-05  +1.20540000E-04  +1.84760000E-04  +1.63548900E-02
   -2.36791900E-02  -1.05967000E-03  +5.00578000E-03  -7.53712000E-03  -4.76392500E-02
   +3.07080000E-04  -3.89890000E-04  -1.80000000E-06  +1.42620000E-04  +8.24500000E-05
   +1.17461000E-03  -1.28740000E-04  +9.62000000E-06  -2.54390000E-04  -8.49100000E-05
   -1.47310000E-04  +2.26090000E-04  +6.16800000E-05  +2.68340000E-04  +8.22000000E-06
   +1.59600000E-05  +1.86620000E-04  -1.39480000E-04  +3.28010000E-04  +4.04550000E-04
   -7.05220000E-04  -5.08900000E-05  -8.51500000E-05  +1.50850000E-04  +1.42946000E-03
   -2.73730000E-04  +1.05788000E-03  +2.99370000E-04  +6.63750000E-04  -5.38300000E-05
   +1.00500000E-05  +5.10000000E-06  -2.66100000E-05  +1.20100000E-05  -9.94000000E-06
   +2.42900000E-05  +4.16800000E-05  +2.60700000E-05  +1.02590000E-04  +1.13603000E-03
   +8.25580000E-04  -1.23917000E-03  +2.19600000E-05  -9.97000000E-06  -7.59000000E-06
   -7.17830000E-04  +1.30870000E-04  -2.22450000E-04  -1.73630000E-04  +1.28190000E-04
   -3.72800000E-05  +2.08250000E-04  +3.41230000E-04  +7.68100000E-05  -1.58109000E-03
   +3.53324000E-03  -9.66020000E-04  -1.53938500E-02  +1.88900400E-02  +1.40661000E-03
   -5.71489000E-03  +1.01104800E-02  +5.20311300E-02  +6.62030000E-04  -2.25838000E-03
   -2.22420000E-04  -1.07164000E-02  -2.72270000E-04  -5.90560000E-04  -3.42512580E-01
   -1.76194900E-02  -1.10680500E-02  -1.24995800E-02  -2.82453000E-03  -5.76200000E-04
   +8.56750000E-04  +2.66656000E-03  -2.80270000E-04  +7.61180000E-04  +5.58500000E-05
   +7.16700000E-05  -1.53483000E-03  +9.81590000E-04  +3.52000000E-05  +1.72400000E-05
   -7.35100000E-05  +1.38140000E-04  -1.05259000E-03  +8.03400000E-05  -3.41500000E-05
   +6.66600000E-05  -8.55100000E-05  -1.60620000E-04  +1.64200000E-05  -1.03900000E-04
   -8.25000000E-06  +2.36700000E-05  +3.30600000E-05  +2.12700000E-05  -8.60000000E-07
   -5.04000000E-06  -2.52300000E-05  +1.14000000E-06  -6.14000000E-06  +9.41000000E-06
   +1.06200000E-05  -8.07000000E-06  +6.60500000E-05  -3.90000000E-07  -1.10000000E-07
   +1.65300000E-05  -7.03150000E-04  +2.98017000E-03  -2.06680000E-04  -9.39540000E-04
   -5.64200000E-05  +5.53000000E-06  -5.35000000E-06  -2.57000000E-06  -1.29000000E-06
   -9.70000000E-06  -3.18000000E-06  +3.99000000E-06  -8.69400000E-05  -9.62000000E-06
   +3.05800000E-05  -8.50000000E-06  +7.91000000E-06  -3.08000000E-06  -7.50000000E-06
   -1.16000000E-06  +4.91000000E-06  +4.39650000E-04  +6.69950000E-04  +5.72600000E-05
   -1.32970000E-04  +1.14544000E-03  -3.13110000E-04  -1.92000000E-04  +9.58390000E-04
   +2.84610000E-04  +1.06400000E-05  +4.14600000E-05  +9.22000000E-06  -8.66000000E-06
   -3.23400000E-05  -3.35400000E-05  +4.78900000E-05  -7.34400000E-05  -3.00700000E-05
   +3.66736630E-01  -1.64561000E-03  -4.49170000E-03  +5.78600000E-05  -2.72608800E-02
   +4.07946000E-03  -1.04309000E-03  -1.63319800E-02  -5.92865100E-02  -4.22550000E-04
   +2.79281000E-02  +4.78276000E-03  +9.64400000E-04  +2.78347000E-03  -4.01026000E-03
   +1.69530000E-04  -6.43900000E-05  -1.37602000E-03  +6.86000000E-06  -5.10590000E-04
   +1.22143000E-03  -5.06000000E-05  +2.37420000E-04  -2.48500000E-05  -3.78600000E-05
   +1.39243000E-03  +2.33230000E-04  +4.36300000E-05  +1.32310000E-04  +5.94400000E-05
   +2.03040000E-04  +6.19900000E-05  -1.76800000E-05  -4.04100000E-05  +4.50200000E-05
   +3.35600000E-05  +7.81000000E-06  -4.75000000E-05  -4.67500000E-05  +1.05390000E-04
   +4.67000000E-06  +2.01000000E-06  -5.83200000E-05  +2.84600000E-05  -2.99000000E-06
   -5.88200000E-05  +4.75800000E-05  +8.03500000E-05  -1.37850000E-04  +9.72600000E-05
   -2.11032000E-03  +1.22260000E-04  -1.97286000E-03  -1.73530000E-04  -2.19700000E-05
   -1.17400000E-05  -8.50000000E-07  +2.10700000E-05  -2.73000000E-06  +3.42000000E-06
   -2.20200000E-05  -6.72400000E-05  +5.56800000E-05  -1.44000000E-06  -1.57000000E-05
   -1.29200000E-05  +8.00000000E-06  -3.90000000E-06  +1.31100000E-05  -8.18000000E-06
   -9.48000000E-06  +3.74970000E-04  -7.30800000E-05  +1.08338000E-03  -1.04927000E-03
   -6.71500000E-04  +8.73870000E-04  -1.20325000E-03  +8.08540000E-04  +5.79700000E-05
   +1.23650000E-04  +1.07540000E-04  -5.03600000E-05  +3.98000000E-06  -4.08400000E-05
   -2.44600000E-05  -7.36800000E-05  -3.79600000E-05  +1.36000400E-02  +6.25947500E-02
   +2.47100000E-05  -4.79000000E-06  +6.87746000E-03  -7.17290000E-04  -4.87800000E-05
   +4.77445000E-03  -1.12676900E-02  -2.13210000E-04  -4.03400400E-02  -6.00240000E-04
   -3.07600000E-04  +4.57597000E-03  -4.34900000E-04  +6.36300000E-05  +7.39119000E-03
   +6.97000000E-05  +1.68540000E-04  -1.20253000E-03  +9.79300000E-05  -2.42000000E-05
   -4.18461000E-03  +2.50380000E-04  -8.26900000E-04  +1.89050000E-04  -3.01700000E-05
   +9.95000000E-06  -1.83700000E-05  -1.83910000E-04  +6.10200000E-04  +1.96750000E-04
   +1.68400000E-05  +2.00450000E-04  +1.50780000E-04  -1.81600000E-05  -3.87300000E-05
   -6.53800000E-05  -6.44000000E-06  +3.20000000E-07  +1.06200000E-05  +1.84200000E-05
   +1.76000000E-06  +1.56000000E-05  +2.29700000E-05  +3.72800000E-05  -2.06420000E-04
   +6.70000000E-07  -1.04600000E-05  -2.14900000E-05  -1.51730000E-04  +2.20220000E-04
   +9.90230000E-04  -5.24300000E-05  -1.24700000E-05  -6.38100000E-05  +5.52000000E-06
   +1.15200000E-05  -4.02000000E-06  +1.30300000E-05  +7.06000000E-06  -6.56000000E-06
   +7.48100000E-05  -6.65200000E-05  -3.09100000E-05  -7.89000000E-06  -1.40500000E-05
   -4.01000000E-06  +9.22000000E-06  +3.40000000E-06  -1.24500000E-05  +7.51700000E-05
   -4.13000000E-06  -4.50910000E-04  +5.95170000E-04  -7.81980000E-04  -2.21920000E-04
   -5.64780000E-04  +9.83500000E-04  -5.31740000E-04  -6.04000000E-06  -2.41000000E-06
   -6.00200000E-05  +1.05400000E-05  -2.51300000E-05  -3.87900000E-05  -6.72200000E-05
   -9.32000000E-05  -2.10620000E-04  +1.26017400E-02  +1.92960000E-04  +2.75482300E-02
   -1.45837000E-03  +1.08514000E-03  -3.09600000E-05  -9.71330000E-04  +3.17104000E-03
   -2.57080000E-04  +1.20660300E-02  +1.62517700E-02  +2.80790000E-04  -1.26345380E-01
   -1.20633860E-01  -2.42476000E-03  -9.17161000E-03  -3.07053400E-02  -2.87320000E-04
   -5.52668000E-03  +1.08544000E-03  -3.33610000E-04  +5.53640000E-04  +4.53550000E-04
   -3.12600000E-05  -6.62900000E-05  +5.49900000E-05  -5.49300000E-05  +2.39604000E-03
   +1.99860000E-04  +1.91310000E-04  -8.74200000E-05  +1.01080000E-04  +7.67100000E-05
   -3.97000000E-06  -9.50000000E-07  -7.19000000E-06  +8.55000000E-06  +4.20000000E-07
   -7.27000000E-06  -2.25000000E-06  -2.60000000E-07  +7.71000000E-06  +1.51500000E-05
   +9.32000000E-06  -5.11000000E-06  +9.72000000E-06  +1.07600000E-05  -3.93800000E-05
   +3.17000000E-06  +6.70000000E-06  -1.21600000E-05  +7.42800000E-05  -5.33700000E-05
   +2.00000000E-08  +4.02240000E-04  -1.08590000E-04  +2.57700000E-05  -4.70000000E-07
   +6.10000000E-07  -1.20000000E-07  -1.40000000E-07  -1.60000000E-07  -2.92000000E-06
   -2.59000000E-06  +1.90000000E-07  -6.85000000E-06  -6.89000000E-06  +4.70000000E-07
   +3.83000000E-06  +1.38000000E-06  +3.61000000E-06  -3.86000000E-06  -2.35400000E-05
   -1.26400000E-05  -8.00000000E-08  -1.85400000E-05  -1.16000000E-06  +3.23800000E-05
   -1.18800000E-05  -3.69000000E-06  -3.35900000E-05  -3.29000000E-06  +5.09000000E-06
   +3.76000000E-06  +3.44000000E-06  -5.96000000E-06  +1.23800000E-05  -3.73000000E-06
   +2.88900000E-05  +3.80200000E-05  +9.32020000E-04  -3.71250000E-04  +1.89000000E-04
   +1.27511990E-01  +8.53470000E-04  +8.89800000E-05  +2.22000000E-05  +3.75809000E-03
   -1.97956000E-03  +1.76320000E-04  -1.45818000E-02  -1.75095700E-02  -3.91830000E-04
   -1.22282430E-01  -2.79676760E-01  -2.70513000E-03  +2.22555000E-03  +1.17389000E-03
   +7.89900000E-05  +2.08880000E-04  +1.18472000E-03  +2.35200000E-05  -9.24710000E-04
   -3.23380000E-04  -1.94300000E-05  +1.35790000E-04  -1.62700000E-04  +1.27420000E-04
   -2.67710000E-04  +8.96410000E-04  -2.73800000E-05  +1.71140000E-04  -1.49140000E-04
   -1.66850000E-04  +3.50000000E-06  -2.95800000E-05  +1.32000000E-05  -1.03400000E-05
   -2.66400000E-05  +7.68000000E-06  +1.84400000E-05  +3.66500000E-05  -7.13100000E-05
   -2.45200000E-05  -1.04600000E-05  +2.61100000E-05  -6.55000000E-06  -7.14000000E-06
   +9.38500000E-05  -2.53600000E-05  -5.34400000E-05  +9.31100000E-05  -1.08260000E-04
   -1.85300000E-05  +8.00000000E-06  -7.64900000E-05  +1.16180000E-04  +7.30000000E-06
   +1.94000000E-06  +7.00000000E-07  -1.47400000E-05  -4.12000000E-06  -3.98000000E-06
   +1.76300000E-05  -3.14000000E-06  -3.84000000E-06  -2.79500000E-05  +1.05100000E-05
   +8.81000000E-06  -8.73000000E-06  -5.62000000E-06  -9.25000000E-06  +8.86000000E-06
   +4.79200000E-05  -9.75000000E-06  -9.00000000E-08  +8.70000000E-06  +7.68000000E-06
   -1.95500000E-05  +1.14700000E-05  +1.01600000E-05  +1.78500000E-05  -3.99000000E-06
   +5.80000000E-07  -2.40000000E-06  -2.40000000E-06  +2.10300000E-05  -5.94000000E-06
   +8.91000000E-06  -6.93300000E-05  -7.99800000E-05  +2.04590000E-04  +8.44740000E-04
   -2.85900000E-05  +1.30570370E-01  +2.95433360E-01  -7.61700000E-05  +8.70000000E-05
   -8.65650000E-04  -1.83560000E-04  +2.76400000E-04  +6.32556000E-03  +4.26400000E-04
   +5.38690000E-04  +1.41308000E-03  -2.49733000E-03  -2.63738000E-03  -3.16197900E-02
   -3.56740000E-04  -9.23340000E-04  +4.09731000E-03  -3.54680000E-04  -4.37300000E-05
   +5.06083000E-03  +8.59000000E-06  +3.15900000E-05  +6.25420000E-04  -9.88000000E-05
   +1.08810000E-04  +4.75000000E-06  +1.87260000E-04  -3.23900000E-05  -3.58665000E-03
   +9.15400000E-05  -2.14320000E-04  +1.54600000E-05  +7.99000000E-06  +3.04200000E-05
   +1.33900000E-05  +4.60000000E-07  +8.48000000E-06  -1.89100000E-05  +5.36000000E-06
   -8.03000000E-06  -2.33600000E-05  -1.94300000E-05  -1.62600000E-05  +2.32500000E-05
   +1.73000000E-05  +1.84800000E-05  +9.31000000E-06  -2.47000000E-06  -1.16400000E-05
   +9.38000000E-06  +5.00000000E-07  -6.77000000E-06  -1.20580000E-04  -1.92200000E-05
   -1.77600000E-05  -3.39110000E-04  +1.18000000E-06  +5.74000000E-06  -1.43000000E-06
   +1.92000000E-06  +7.93000000E-06  -8.89000000E-06  -9.33000000E-06  +4.54000000E-06
   +1.94500000E-05  -1.10000000E-07  -1.21500000E-05  +2.60000000E-07  -4.98000000E-06
   -2.64000000E-06  +9.70000000E-07  +2.90000000E-07  +2.63000000E-06  +2.70400000E-05
   +1.85200000E-05  -3.17600000E-05  +2.66000000E-05  -3.20600000E-05  +3.94400000E-05
   +2.24100000E-05  -3.21000000E-06  -1.02100000E-05  -1.55300000E-05  -3.32000000E-06
   -4.32000000E-06  -1.20300000E-05  -2.02400000E-05  +3.70100000E-05  +4.32000000E-05
   +2.02620000E-04  -3.48200000E-05  -4.43666000E-03  +2.68394000E-03  +2.84776000E-03
   +2.36169100E-02  -1.58165900E-02  -6.88010000E-03  -6.16350000E-04  +6.69310000E-04
   +3.59237000E-03  -1.59190000E-04  +8.65920000E-04  +1.44950000E-04  +6.24300000E-05
   +8.15520000E-04  -3.57171000E-03  -1.17160000E-04  -1.41179700E-02  +5.78244000E-03
   -6.44220000E-04  -3.28757500E-01  -9.90335000E-03  -1.07055400E-02  -5.32940000E-04
   -7.87160000E-04  -2.52200000E-05  -7.96300000E-05  +1.55000000E-05  -1.05570000E-04
   +3.11298000E-03  +5.80700000E-05  +2.71190000E-04  -6.63600000E-05  -4.89400000E-05
   +1.92610000E-04  +2.55900000E-05  -2.21000000E-05  -4.49000000E-05  +2.06200000E-05
   +3.30400000E-05  +4.04000000E-06  -2.64600000E-05  -2.94800000E-05  +9.26800000E-05
   +3.28800000E-05  +1.83300000E-05  -5.47400000E-05  +1.46900000E-05  -6.52000000E-06
   -4.75900000E-05  +4.91000000E-05  +6.96200000E-05  -1.14840000E-04  -5.22800000E-05
   +3.88800000E-04  -8.49000000E-06  +3.34453000E-03  -4.74640000E-04  +2.29970000E-04
   -1.65500000E-05  -6.80000000E-07  +1.47100000E-05  -1.03400000E-05  +1.83000000E-06
   -2.30600000E-05  -5.58000000E-06  +5.40000000E-06  +4.86200000E-05  -1.74600000E-05
   -4.15000000E-06  +9.89000000E-06  -5.60000000E-07  +1.30100000E-05  -9.34000000E-06
   -1.34660000E-04  +1.43100000E-05  -4.48000000E-06  +2.13800000E-05  -1.92900000E-05
   -8.46000000E-06  +1.38900000E-05  -2.37400000E-05  +1.01300000E-05  +2.23700000E-05
   +2.76300000E-05  +3.02800000E-05  +8.21000000E-06  -1.29800000E-05  -1.50300000E-05
   +3.52000000E-06  +6.94000000E-05  +5.62700000E-05  -9.45900000E-05  -5.83000000E-06
   -2.18000000E-06  -7.43630000E-04  +1.17260000E-04  -4.48300000E-05  +3.51790280E-01
   +2.59030800E-02  +4.54219000E-03  +8.62640000E-04  +2.40006000E-03  -4.35680000E-03
   +1.39760000E-04  +2.00250000E-04  -1.73805000E-03  +2.77300000E-05  -2.46079000E-03
   -5.00629000E-03  -4.48900000E-05  -2.75792100E-02  +4.27286000E-03  -1.02287000E-03
   -1.02601900E-02  -6.13825700E-02  -1.66000000E-04  +1.08030000E-03  +7.11790000E-04
   +8.05600000E-05  +4.25000000E-06  +8.01300000E-05  +9.74900000E-05  -8.70360000E-04
   +2.87195000E-03  -2.94500000E-05  +3.98700000E-05  +1.33860000E-04  -1.64900000E-04
   -2.23100000E-05  -2.93000000E-06  +2.15400000E-05  -1.18100000E-05  -4.15000000E-06
   +1.12200000E-05  +9.89000000E-06  +8.62000000E-06  -1.69000000E-05  -1.48600000E-05
   -1.39100000E-05  +1.28400000E-05  -3.29400000E-05  -1.71000000E-06  +2.21800000E-05
   -1.49400000E-05  -1.78800000E-05  +2.84500000E-05  +8.96700000E-05  -4.27940000E-04
   -2.38000000E-06  +1.48351000E-03  +2.85039000E-03  -7.64600000E-05  +5.16000000E-06
   -5.70000000E-07  -1.49000000E-06  +2.02000000E-06  -2.46000000E-06  +8.76000000E-06
   +6.96000000E-06  -7.92000000E-06  -1.06700000E-05  +1.19600000E-05  -4.10000000E-07
   -5.77000000E-06  +2.75000000E-06  -6.53000000E-06  +5.56000000E-06  +1.62640000E-04
   +2.45700000E-05  +8.73000000E-06  -2.40000000E-07  +8.34000000E-06  -2.05700000E-05
   -6.94000000E-06  +1.23400000E-05  +1.85900000E-05  -1.08900000E-05  -2.41000000E-05
   -2.80700000E-05  -2.03000000E-06  -2.18000000E-06  -1.12900000E-05  -1.49600000E-05
   -2.76500000E-05  -2.02800000E-05  +1.29400000E-05  +5.33200000E-05  +4.47000000E-06
   -1.43889000E-03  +1.85710000E-04  -4.21100000E-05  +1.11947000E-02  +5.98156400E-02
   -6.41450000E-04  -3.48500000E-05  +3.36534000E-03  -2.56330000E-04  +1.22470000E-04
   +4.99643000E-03  +2.86300000E-05  -1.63000000E-05  -1.07758000E-03  -1.26660000E-04
   +4.72000000E-06  +4.75545000E-03  -4.04160000E-04  +3.04420000E-04  +3.26883000E-03
   -1.09165200E-02  -3.47560000E-04  -2.83080800E-02  -5.79200000E-05  -8.19100000E-05
   +3.75410000E-04  +4.68800000E-05  -2.42200000E-05  -8.37000000E-06  +3.10190000E-04
   -8.69200000E-05  -4.21197000E-03  +1.82800000E-05  +2.07000000E-06  -5.01000000E-06
   +2.95700000E-05  +5.82000000E-06  +5.88000000E-06  +3.20100000E-05  +7.02000000E-06
   -2.21800000E-05  +1.59000000E-06  +1.15100000E-05  +1.36000000E-06  +1.30000000E-07
   -1.36200000E-05  -7.50000000E-07  -1.20300000E-05  +1.41900000E-05  -1.40100000E-05
   +1.54600000E-05  -2.74000000E-06  -1.44700000E-05  +3.15100000E-05  +8.76000000E-06
   -6.31300000E-05  +2.80100000E-05  -1.30210000E-04  -4.49310000E-03  -1.30000000E-05
   +1.08300000E-05  -4.19000000E-06  -1.61500000E-05  +5.83000000E-06  -1.87700000E-05
   -3.45900000E-05  -7.24000000E-06  +9.55000000E-06  -9.40000000E-07  -1.18400000E-05
   -1.13000000E-06  -5.30000000E-07  -8.40000000E-07  -9.00000000E-07  +3.78000000E-06
   +2.04000000E-06  -6.13000000E-05  +3.93600000E-05  +1.63200000E-05  -8.55000000E-06
   -3.52500000E-05  -2.66300000E-05  -1.30000000E-05  -3.41500000E-05  -1.66000000E-05
   +2.90500000E-05  +3.14300000E-05  +1.70300000E-05  -1.52900000E-05  -5.03000000E-06
   +9.37000000E-06  -7.77000000E-06  +5.66000000E-06  -1.89000000E-06  -1.77280000E-04
   -2.41800000E-05  +7.97000000E-06  +3.91410000E-04  +1.18643400E-02  +1.05320000E-04
   +1.96186000E-02  -9.66030000E-04  +1.55640000E-04  -1.29300000E-05  +5.68330000E-04
   -3.21000000E-05  +2.22500000E-05  -1.04755000E-03  -7.46780000E-04  -7.54600000E-05
   +1.56053000E-03  +4.17002000E-03  -4.10100000E-05  -2.83363200E-02  -4.40254000E-03
   -7.98190000E-04  +5.60636000E-03  -3.87118000E-03  +2.55350000E-04  -1.69790000E-04
   +1.73660000E-04  -7.22200000E-05  +1.09350000E-04  -1.03690000E-04  +5.58300000E-05
   -5.19278500E-01  -6.87643400E-02  -1.64969200E-02  +9.34100000E-05  -4.62600000E-05
   -7.69200000E-05  +1.26800000E-05  +6.29000000E-06  +3.45300000E-05  -5.20000000E-07
   -4.93000000E-05  -1.95900000E-05  +3.63400000E-05  +6.68600000E-05  -1.43820000E-04
   -2.32300000E-05  -6.15000000E-06  +6.17900000E-05  +1.24900000E-05  +2.56900000E-05
   +3.24700000E-05  -5.66200000E-05  -1.00720000E-04  +1.61040000E-04  -1.11700000E-05
   -7.06800000E-05  +1.49500000E-05  -6.64600000E-05  -7.27350000E-04  +6.00000000E-06
   +1.33400000E-05  +9.25000000E-06  -2.90500000E-05  +5.30000000E-07  +3.40000000E-06
   +1.84000000E-05  -2.30000000E-05  -6.31000000E-06  -5.37400000E-05  +6.09000000E-06
   +1.09000000E-05  -8.59000000E-06  -4.15000000E-06  -1.22200000E-05  +5.43000000E-06
   +4.04200000E-05  -2.15700000E-05  -6.80000000E-07  -1.88100000E-05  +8.69000000E-06
   -6.03000000E-06  -1.00000000E-05  +1.21700000E-05  +3.57000000E-06  -1.39400000E-05
   +2.07800000E-05  +1.42000000E-05  -1.04400000E-05  +2.11200000E-05  +3.00000000E-05
   +1.68600000E-05  -7.28100000E-05  -4.29000000E-05  -6.07000000E-05  +2.79820000E-04
   +1.56000000E-06  +4.69810000E-04  -1.74200000E-05  +3.32600000E-05  -2.04770000E-04
   +9.19370000E-04  -4.92600000E-05  +5.41614270E-01  +4.53610000E-04  -1.41379000E-03
   +1.79900000E-05  -5.47510000E-04  +2.05600000E-05  -3.27700000E-05  +1.11725000E-03
   +1.18335000E-03  +2.80000000E-05  +1.98372000E-03  -6.12626000E-03  +1.09040000E-04
   +4.64575100E-02  +2.86182000E-03  +1.48226000E-03  +2.07739000E-03  +1.83857000E-03
   +7.57400000E-05  -8.17500000E-05  -1.99560000E-04  +4.84000000E-06  +1.81300000E-05
   +1.48700000E-05  -8.90000000E-06  -1.22874410E-01  -6.39216800E-02  -3.67497000E-03
   -1.64400000E-05  -1.71000000E-05  +4.05700000E-05  -2.07000000E-05  -4.31000000E-06
   -2.42000000E-06  -7.48000000E-06  +4.98000000E-05  +1.31700000E-05  -2.96600000E-05
   -8.03200000E-05  +1.21100000E-04  -3.62000000E-06  -7.03000000E-06  -3.39800000E-05
   -1.24800000E-05  -1.68600000E-05  -1.65900000E-05  +3.51500000E-05  +8.77200000E-05
   -1.37380000E-04  -1.07100000E-05  +7.42000000E-05  -1.30700000E-05  -3.89900000E-05
   +8.09130000E-04  -1.17000000E-06  -1.70000000E-06  -1.15100000E-05  +3.07900000E-05
   +8.31000000E-06  -3.47000000E-06  -1.14600000E-05  +2.06200000E-05  +7.80000000E-07
   +3.21800000E-05  +8.35000000E-06  -1.24900000E-05  +5.48000000E-06  +5.96000000E-06
   +6.74000000E-06  -9.50000000E-07  -3.87900000E-05  +1.13100000E-05  -1.10000000E-07
   +1.07300000E-05  -9.24000000E-06  +7.90000000E-06  +6.53000000E-06  -1.04700000E-05
   -4.32000000E-06  +1.85600000E-05  -3.83800000E-05  -2.50100000E-05  +3.85000000E-06
   -1.43200000E-05  -6.58000000E-06  -2.81400000E-05  +2.43900000E-05  +2.30000000E-07
   +1.61230000E-04  -3.29850000E-04  +5.83000000E-06  +8.34300000E-05  +4.57000000E-05
   +9.50000000E-07  -1.78543000E-03  -1.26173000E-03  -7.41900000E-05  +7.30965800E-02
   +6.67991900E-02  +3.60000000E-06  +6.94000000E-06  -7.15280000E-04  +3.58000000E-06
   +3.84000000E-06  +9.02000000E-05  -8.66300000E-05  -1.15100000E-05  +1.84095000E-03
   -4.11300000E-05  +1.62680000E-04  +2.26240000E-03  -1.04106000E-03  -1.96460000E-04
   -3.02127000E-03  +2.22010000E-04  -1.14950000E-04  -1.05696000E-03  +6.19000000E-06
   -3.46000000E-06  -1.10940000E-04  +1.61600000E-05  -3.20900000E-05  +9.51000000E-06
   -1.62519500E-02  -1.88666000E-03  -3.73195000E-03  -1.27100000E-05  -7.14000000E-06
   +1.95800000E-05  +2.17400000E-05  +1.68400000E-05  +1.50800000E-05  +2.04600000E-05
   +3.00000000E-06  -6.27000000E-06  -2.34000000E-06  +6.73000000E-06  +6.75000000E-06
   +4.80000000E-07  -8.48000000E-06  -3.08000000E-06  +4.46000000E-06  +1.26800000E-05
   -1.86300000E-05  +1.31900000E-05  -2.21000000E-06  -1.79600000E-05  -4.80000000E-07
   -3.35000000E-06  -1.04200000E-05  -1.86600000E-05  -2.65900000E-05  -8.58700000E-05
   -1.04400000E-05  +1.13500000E-05  +6.00000000E-08  -1.12100000E-05  +7.96000000E-06
   -1.79200000E-05  -2.49200000E-05  -5.79000000E-06  +1.34300000E-05  -1.17000000E-06
   -1.00500000E-05  -2.10000000E-06  -5.50000000E-07  -1.33000000E-06  -1.05000000E-06
   +9.80000000E-07  -8.10000000E-07  -3.61000000E-06  +9.58000000E-06  +6.86000000E-06
   -6.21000000E-06  -9.08000000E-06  -4.15000000E-06  -6.31000000E-06  -9.53000000E-06
   -9.19000000E-06  +9.65000000E-06  +1.92400000E-05  +6.00000000E-06  -7.17000000E-06
   -1.08700000E-05  -4.84000000E-06  -1.45400000E-05  +6.26000000E-06  +6.32000000E-06
   -2.09020000E-04  +3.25400000E-05  -3.76000000E-06  -5.90400000E-04  -3.18500000E-05
   +2.85600000E-05  +7.85880000E-04  +1.71771500E-02  +2.04662000E-03  +4.46151000E-03
   -2.73670000E-02  +2.38477000E-03  +4.25010000E-04  +2.41932000E-03  -3.25325000E-03
   +2.53420000E-04  -1.27774000E-03  +5.60380000E-04  -1.28710000E-04  +7.73410000E-04
   +3.39830000E-04  +1.43000000E-06  -1.10765000E-03  -2.26830000E-04  -2.63850000E-04
   +5.51966000E-03  +4.71527000E-03  +8.47200000E-05  +3.74600000E-04  +2.00500000E-04
   -5.64200000E-05  +3.09170000E-04  -5.64000000E-05  +9.41700000E-05  -6.66600000E-05
   +6.93070000E-04  +1.65700000E-05  -1.27470000E-04  +2.47100000E-05  -1.58810000E-04
   -3.17300000E-05  +1.71600000E-05  +1.44850000E-04  +4.37200000E-05  -4.45000000E-06
   -6.59200000E-05  +5.26300000E-05  +7.55700000E-05  -1.85580000E-04  -2.41200000E-05
   -1.29000000E-05  +6.00000000E-05  -4.12800000E-05  -4.78000000E-05  +1.95800000E-05
   -7.67100000E-05  -1.05280000E-04  +1.60750000E-04  -5.98000000E-06  -5.57400000E-05
   -5.99000000E-06  -5.23594480E-01  +5.66115000E-02  +2.24797200E-02  +2.61400000E-05
   +1.40600000E-05  -2.54400000E-05  +1.19000000E-06  +6.18000000E-06  +1.57800000E-05
   -2.96000000E-05  -1.59700000E-05  -5.55000000E-05  +1.05600000E-05  +1.04600000E-05
   -6.29000000E-06  +8.34000000E-06  -2.01200000E-05  +5.54000000E-06  +2.95100000E-05
   -2.61000000E-05  -1.28000000E-06  -1.20400000E-05  +8.93000000E-06  +8.31000000E-06
   -9.12000000E-06  +1.42000000E-05  -6.73000000E-06  -3.22660000E-04  +6.07600000E-05
   +1.64500000E-05  -4.95800000E-05  +1.67900000E-05  +2.94400000E-05  +5.31000000E-06
   -7.36600000E-05  -2.42600000E-05  -1.57300000E-05  -2.57300000E-04  +3.36900000E-05
   +5.00000000E-07  -1.16900000E-05  +3.93800000E-05  -1.32910000E-04  -7.88000000E-04
   +1.41340000E-04  +1.41180000E-04  -6.91000000E-05  +6.95000000E-06  +5.44577180E-01
   -4.71590800E-02  +1.56588000E-03  +1.63826000E-03  -1.92984000E-03  -6.40089000E-03
   +5.53000000E-05  -1.17699000E-03  +1.04684000E-03  -1.74980000E-04  +6.31130000E-04
   -6.09700000E-05  +6.92900000E-05  -3.52440000E-04  -1.42189000E-03  -8.42700000E-05
   -2.57893000E-03  +1.46669000E-03  -2.01280000E-04  -1.56060000E-04  -2.40730000E-04
   -4.62900000E-05  +1.57550000E-04  -2.15410000E-04  -1.87560000E-04  +6.80100000E-05
   +7.05840000E-04  -1.50200000E-05  +1.73440000E-04  +1.57950000E-04  -1.20150000E-04
   +1.24050000E-04  -1.51600000E-05  -1.92590000E-04  -8.19800000E-05  -1.95020000E-04
   +5.80700000E-05  +4.30700000E-05  +2.41490000E-04  -2.60600000E-05  -1.08800000E-04
   -1.41800000E-05  +4.32000000E-06  +6.64300000E-05  +8.53200000E-05  +1.85100000E-05
   -1.21360000E-04  -1.79250000E-04  +2.31130000E-04  -1.17000000E-06  -6.14800000E-05
   +3.93300000E-05  +1.10385470E-01  -5.73695900E-02  -6.48978000E-03  +3.62800000E-05
   +1.09000000E-06  -1.16300000E-05  +5.77000000E-06  -1.87000000E-06  +1.83600000E-05
   -2.21900000E-05  -1.14500000E-05  -3.48700000E-05  +5.87400000E-05  +3.36200000E-05
   -4.87000000E-05  +4.46300000E-05  -6.16700000E-05  +2.80600000E-05  +3.47300000E-05
   -1.09000000E-05  -2.88000000E-06  -1.54000000E-05  -8.46000000E-06  +1.55500000E-05
   +1.72700000E-05  +1.15600000E-05  +2.30000000E-06  +1.36230000E-04  +3.19570000E-04
   +3.73390000E-04  +8.62300000E-05  +1.36900000E-05  -1.37600000E-05  +2.14680000E-04
   +4.18000000E-06  -3.31000000E-05  -1.63850000E-04  -3.49450000E-04  -1.79500000E-05
   +2.13380000E-04  -1.22300000E-05  +3.77000000E-06  +2.02943000E-03  -1.28594000E-03
   +2.21890000E-04  +7.11600000E-05  -3.49780000E-04  +6.45000000E-06  -6.07295600E-02
   +6.26125800E-02  -1.65142000E-03  -9.78420000E-04  -2.56298000E-03  +6.86200000E-05
   -9.90700000E-05  +2.23115000E-03  -3.52810000E-04  -2.56010000E-04  +1.47701000E-03
   -1.30370000E-04  +2.20180000E-04  +1.28760000E-04  +2.48840000E-04  +3.06700000E-05
   -7.60980000E-04  -4.79300000E-05  -1.69370000E-04  -1.28261000E-03  -6.14200000E-05
   -1.32460000E-04  -2.09040000E-04  +1.14490000E-04  -1.95030000E-04  -3.41350000E-04
   -4.80800000E-05  -5.38500000E-05  -6.98000000E-05  +1.97800000E-05  -6.63600000E-05
   +4.29500000E-05  -1.09960000E-04  -7.86600000E-05  +1.68380000E-04  +2.04580000E-04
   +4.41300000E-05  -1.09890000E-04  +2.00600000E-05  +3.24100000E-05  -3.44000000E-05
   +3.20700000E-05  +1.09600000E-05  -2.89800000E-05  -1.02790000E-04  +1.78500000E-05
   -4.30000000E-07  +6.73500000E-05  +2.16200000E-05  -7.71600000E-05  +9.14000000E-06
   +4.50000000E-06  -8.77900000E-05  +2.47234100E-02  -3.49572000E-03  -4.00416000E-03
   -4.88600000E-05  +3.41200000E-05  -2.95100000E-05  -5.66600000E-05  +8.27000000E-06
   -4.50400000E-05  -7.52600000E-05  -1.45000000E-05  +2.45200000E-05  +1.81500000E-05
   -3.17400000E-05  -7.49000000E-06  -1.75500000E-05  +1.02500000E-05  -3.54000000E-06
   -1.95500000E-05  -2.50000000E-07  +2.21000000E-06  +3.61800000E-05  +1.91100000E-05
   -1.84100000E-05  -4.08800000E-05  -9.55000000E-06  -7.57000000E-06  +2.43710000E-04
   +1.71400000E-05  +1.68230000E-04  +1.14030000E-04  +1.86000000E-05  -4.90000000E-06
   +3.26700000E-05  +3.95400000E-05  -2.95000000E-06  -1.71600000E-05  -6.20100000E-05
   -2.22750000E-04  -1.55200000E-05  -4.12000000E-06  -1.06970000E-04  -1.04140000E-04
   +1.79720000E-04  +9.23610000E-04  -4.50000000E-07  +2.11700000E-05  +1.21960000E-04
   -2.30523000E-02  +4.91689000E-03  +4.72990000E-03
end_hess

