# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.36418310    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -1.82388516E-01  +2.57962800E+00  -4.63650322E+00
   006   -1.29505977E-02  +2.49672012E+00  -2.01702769E+00
   006   +2.38096841E+00  +2.72982277E+00  -9.54601144E-01
   006   +4.51961448E+00  +3.02651572E+00  -2.42991707E+00
   006   +4.30289558E+00  +3.10436681E+00  -5.04453868E+00
   006   +1.93619090E+00  +2.88131133E+00  -6.14369365E+00
   006   -2.31877001E+00  +2.26234409E+00  -2.78470054E-01
   006   -2.73131446E+00  +4.85955258E+00  +9.61191207E-01
   008   +6.32965233E+00  +3.38709335E+00  -6.59747928E+00
   006   -1.80009722E+00  +2.13189553E-01  +1.69147633E+00
   006   -7.87261840E-01  -2.34320111E+00  +8.53226928E-01
   006   -1.41383042E+00  -4.40340935E+00  +2.75468357E+00
   006   -7.88846302E-01  -3.63579636E+00  +5.41252224E+00
   006   -1.09635119E+00  -1.22593254E+00  +6.08406949E+00
   006   -1.83254850E+00  +6.31784653E-01  +4.18986809E+00
   008   -1.54129727E+00  -3.21275466E+00  -1.56782522E+00
   008   -1.36116822E-01  -6.67363331E+00  +2.20129495E+00
   008   -1.50039629E-01  -5.49137894E+00  +7.01833404E+00
   006   -4.75993987E+00  +1.66406874E+00  -1.74444785E+00
   001   +7.83854196E+00  +3.51290948E+00  -5.60954227E+00
   001   +6.35950607E+00  +3.19246382E+00  -1.54377125E+00
   001   +2.58686184E+00  +2.66181432E+00  +1.08174391E+00
   001   -1.99615944E+00  +2.39681636E+00  -5.55740936E+00
   001   +1.77577874E+00  +2.93539622E+00  -8.18011356E+00
   001   -3.00624995E+00  +6.27036164E+00  -5.13928985E-01
   001   -4.40638375E+00  +4.86216833E+00  +2.16446039E+00
   001   -1.10846886E+00  +5.43859108E+00  +2.08745133E+00
   001   -4.56435118E+00  +4.29785944E-02  -2.99325834E+00
   001   -6.28721464E+00  +1.29868631E+00  -4.11037743E-01
   001   -5.31995344E+00  +3.26896490E+00  -2.91135368E+00
   001   -2.33319827E+00  +2.47998810E+00  +4.90082583E+00
   001   -8.35358232E-01  -6.48509625E-01  +8.02533689E+00
   001   -3.47741263E+00  -4.72290386E+00  +2.67901963E+00
   001   +1.27583799E+00  -2.20366901E+00  +7.21078851E-01
   001   +2.20928840E-01  -6.97139611E+00  +6.02640313E+00
   001   -3.35039712E+00  -3.28790022E+00  -1.60434650E+00
   001   -2.37048146E-01  -6.93495193E+00  +4.10165823E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.60000000E-07  -1.00000000E-07  -8.00000000E-08
   +6.00000000E-08  +3.90000000E-07  +2.00000000E-08
   -3.60000000E-07  +2.50000000E-07  -2.40000000E-07
   -2.10000000E-07  +3.00000000E-08  -7.50000000E-07
   -5.80000000E-07  +3.70000000E-07  -3.80000000E-07
   -9.30000000E-07  +3.70000000E-07  -2.50000000E-07
   +2.00000000E-08  -4.00000000E-08  +6.50000000E-07
   +1.10000000E-07  -5.40000000E-07  +5.10000000E-07
   -8.80000000E-07  -1.00000000E-07  -8.30000000E-07
   +3.60000000E-07  -1.80000000E-07  +1.90000000E-07
   +4.70000000E-07  -3.00000000E-08  +7.60000000E-07
   -2.00000000E-07  +1.60000000E-07  -1.60000000E-07
   +9.70000000E-07  -3.60000000E-07  +5.10000000E-07
   +7.50000000E-07  -3.20000000E-07  -1.80000000E-07
   +4.50000000E-07  -1.20000000E-07  +3.50000000E-07
   -3.80000000E-07  +5.90000000E-07  -8.70000000E-07
   +7.50000000E-07  +1.40000000E-07  -1.80000000E-07
   +7.10000000E-07  -1.00000000E-08  -4.50000000E-07
   -3.60000000E-07  +1.40000000E-07  +1.90000000E-07
   -8.00000000E-07  +5.30000000E-07  -9.70000000E-07
   -2.40000000E-07  +1.30000000E-07  -8.00000000E-07
   +1.60000000E-07  -2.00000000E-08  -3.40000000E-07
   -7.90000000E-07  +2.50000000E-07  +2.40000000E-07
   -1.10000000E-06  +3.60000000E-07  -2.00000000E-07
   -2.70000000E-07  +0.00000000E+00  +5.90000000E-07
   +3.30000000E-07  -1.10000000E-07  +9.00000000E-07
   +3.60000000E-07  +8.00000000E-08  +1.80000000E-07
   -3.80000000E-07  -9.00000000E-08  +7.70000000E-07
   -2.80000000E-07  +2.80000000E-07  +8.40000000E-07
   -3.20000000E-07  -7.00000000E-08  +6.00000000E-07
   +7.40000000E-07  -1.70000000E-07  +2.40000000E-07
   +1.12000000E-06  -3.10000000E-07  +0.00000000E+00
   +6.30000000E-07  -3.50000000E-07  -4.00000000E-08
   +0.00000000E+00  -2.50000000E-07  -6.90000000E-07
   +8.80000000E-07  -2.60000000E-07  -4.20000000E-07
   -2.20000000E-07  -5.50000000E-07  +5.10000000E-07
   +0.00000000E+00  -5.00000000E-08  -2.50000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.34766530E-01  +6.86462000E-02  +1.51926960E-01  +2.42082900E-02  -1.70817100E-02
   +6.89583030E-01  -1.32729710E-01  -8.23996000E-03  +2.09150900E-02  +6.26988330E-01
   -4.91224000E-03  -6.79619100E-02  +1.20735800E-02  +4.42072400E-02  +1.90307640E-01
   -4.97204600E-02  +3.67488000E-03  -3.24032510E-01  +2.45617100E-02  -1.28740200E-02
   +6.71397770E-01  +2.63065100E-02  +5.69686000E-03  -8.90867400E-02  -2.83425610E-01
   -2.29401200E-02  -3.65595300E-02  +6.78124540E-01  +3.68207000E-03  +9.27797000E-03
   -9.41775000E-03  -1.95952200E-02  -7.22898000E-02  +1.27090000E-04  +5.99194000E-02
   +1.52653030E-01  -3.41824500E-02  -3.16672000E-03  -2.05938800E-02  -1.07171690E-01
   -9.10982000E-03  -1.62409950E-01  -8.13387000E-03  -2.61659600E-02  +7.42981170E-01
   -1.50501200E-02  -2.22512000E-03  +2.93113200E-02  -5.74442900E-02  -6.64185000E-03
   -1.55788400E-02  -2.79179370E-01  -2.99341500E-02  +1.39161900E-01  +7.40826910E-01
   -2.28053000E-03  -4.12159000E-03  +5.73204000E-03  -9.07595000E-03  +7.07992000E-03
   -4.29011000E-03  -2.71275900E-02  -6.28777300E-02  +2.11358700E-02  +6.72521500E-02
   +1.33773170E-01  +2.57149600E-02  +5.55124000E-03  -6.29124400E-02  +4.00468100E-02
   +2.84216000E-03  +6.84954600E-02  +6.89008700E-02  +1.25885900E-02  -2.01631140E-01
   +1.46093100E-02  -2.07576000E-02  +6.91518290E-01  -6.00310500E-02  -8.71974000E-03
   +4.50945500E-02  -2.82955500E-02  -3.92250000E-04  -4.44910200E-02  +5.59170000E-02
   +5.34650000E-03  +2.50619800E-02  -1.40046980E-01  -8.25011000E-03  +1.18076400E-02
   +7.22946130E-01  -6.40298000E-03  +1.39014000E-03  +2.16997000E-03  -5.16750000E-04
   -5.72053000E-03  -3.14878000E-03  +2.36615000E-03  +2.79159000E-03  +4.37011000E-03
   -4.79376000E-03  -7.00750700E-02  +1.06476100E-02  +6.14583600E-02  +1.70354360E-01
   -1.57765600E-02  -4.80955000E-03  +7.95154700E-02  -4.54980600E-02  -3.35914000E-03
   -5.75714400E-02  +8.52813300E-02  +1.17173300E-02  -3.57672500E-02  -7.36130000E-02
   +1.33685000E-03  -3.17741090E-01  +1.28800400E-02  -1.93338800E-02  +7.07518530E-01
   -2.75612950E-01  -2.76510400E-02  +6.65970200E-02  +4.84566200E-02  +9.20300000E-04
   +7.63762900E-02  -7.51004800E-02  -8.77156000E-03  +3.27556000E-03  +2.74694600E-02
   +5.29468000E-03  -8.00584400E-02  -2.76729510E-01  -2.08595400E-02  -4.68416000E-02
   +6.92826670E-01  -2.98251600E-02  -6.45968300E-02  +1.31798400E-02  +3.67198000E-03
   +7.18092000E-03  +1.01777000E-02  -8.31333000E-03  -4.24212000E-03  +3.68960000E-04
   +3.20530000E-03  +9.33246000E-03  -8.11989000E-03  -1.82664800E-02  -7.33291600E-02
   -1.15930000E-03  +6.41187600E-02  +1.38088680E-01  +1.38438670E-01  +2.14134200E-02
   -2.05658240E-01  +2.30505100E-02  +3.95585000E-03  -3.48486000E-02  +5.61588000E-03
   +6.56840000E-04  -2.28752000E-03  -3.06016100E-02  -2.52656000E-03  -1.41537300E-02
   -1.27931070E-01  -1.01442800E-02  -1.81059920E-01  -4.85253000E-03  -2.37990700E-02
   +7.60426720E-01  +5.38705000E-03  -6.76260000E-04  +5.37645000E-03  -1.40844040E-01
   -7.99343000E-03  +4.10477800E-02  -2.79371900E-02  -2.88280000E-03  +1.79304900E-02
   -1.75501000E-03  -4.34140000E-04  -4.08415000E-03  -1.31337000E-03  -2.35560000E-04
   +5.36800000E-04  +1.12163000E-03  -4.22820000E-04  -2.77909000E-03  +4.76846740E-01
   -1.68339000E-03  +2.03808000E-03  +1.58221000E-03  -6.84585000E-03  -6.91235800E-02
   +4.81714000E-03  -3.22618000E-03  +1.05647000E-03  +2.02280000E-03  -1.27631000E-03
   +5.32281000E-03  -5.96150000E-04  -6.44050000E-04  -6.21790000E-04  +3.37310000E-04
   +8.22300000E-05  +6.59149000E-03  +7.39490000E-04  -4.67978000E-03  +4.64025810E-01
   +2.51292700E-02  +2.89944000E-03  -1.54783700E-02  +3.47332100E-02  +5.48071000E-03
   -1.17860640E-01  -2.68644000E-03  -3.47580000E-04  +1.30496300E-02  -4.86493000E-03
   -3.53210000E-04  -1.48260000E-04  -5.94690000E-04  +1.12960000E-04  -2.36560000E-03
   -1.48567000E-03  -1.76990000E-04  -3.50036000E-03  +7.47275000E-03  -9.81000000E-05
   +4.71656740E-01  -1.45768000E-03  +5.67080000E-04  -1.07455000E-03  -8.90069000E-03
   +2.35553300E-02  +1.67045200E-02  -9.93150000E-04  +9.38250000E-04  +1.60190000E-03
   +6.78640000E-04  -5.80380000E-04  +1.02320000E-04  +1.10484000E-03  +2.22900000E-04
   +6.47400000E-05  -1.05401000E-03  -1.29289000E-03  -3.99100000E-05  -7.55249000E-02
   +1.41029000E-02  +6.45418000E-03  +5.85986320E-01  -1.07332000E-03  -6.61450000E-04
   +1.27899000E-03  +8.66894000E-03  +4.28100000E-05  -6.27109000E-03  -1.43698000E-03
   -2.49300000E-04  +5.46930000E-04  -9.71600000E-05  +5.62400000E-05  -3.22800000E-05
   +3.50230000E-04  +1.52720000E-04  -1.77230000E-04  -1.52590000E-04  -2.44180000E-04
   +1.14320000E-04  +9.23273000E-03  -1.49898890E-01  -3.50444200E-02  +2.03944100E-02
   +4.79965220E-01  +1.19372000E-03  -3.70300000E-04  +4.25560000E-04  +1.00670000E-02
   -1.90689100E-02  -1.55266800E-02  -5.82200000E-04  -9.30330000E-04  +8.54000000E-06
   -4.23800000E-04  +3.51890000E-04  -3.96290000E-04  -5.57890000E-04  -2.24000000E-05
   +1.46480000E-04  +4.95970000E-04  +1.17859000E-03  -1.89250000E-04  +5.39365000E-03
   -3.81565200E-02  -9.19647400E-02  +1.36581000E-02  -4.47328800E-02  +5.71105160E-01
   +2.26882000E-03  -1.21250000E-04  -9.15992000E-03  +5.97050000E-04  -6.24070000E-04
   +5.73896000E-03  -3.93657000E-03  -1.14684000E-03  -1.67904000E-03  -4.34111000E-03
   -1.88421000E-03  +9.61277000E-03  -2.31609800E-01  -2.54458100E-02  +1.23689590E-01
   -5.66707100E-02  -8.08841000E-03  +3.11061400E-02  +1.44499000E-03  +1.17604000E-03
   -2.95810000E-04  -1.31525000E-03  -7.08240000E-04  +6.90190000E-04  +6.65959590E-01
   -2.30170000E-04  +5.06973000E-03  -5.57070000E-04  -6.68700000E-05  -1.38637000E-03
   +5.46760000E-04  -7.73210000E-04  +7.24942000E-03  +1.36140000E-04  -3.47651000E-03
   +9.10660000E-03  +2.97142000E-03  -2.32951900E-02  -4.68404400E-02  +1.91211100E-02
   -6.85811000E-03  +6.66072000E-03  +2.96346000E-03  +2.92370000E-04  -4.32990000E-04
   -1.13150000E-04  -1.63820000E-04  -1.17440000E-04  +5.59400000E-05  +6.60350900E-02
   +3.43069700E-02  -2.12350000E-03  +3.48650000E-04  -7.87931000E-03  +5.18952000E-03
   +7.67130000E-04  +3.45021000E-03  -1.02184600E-02  -8.37470000E-04  -2.98975000E-03
   +5.02922400E-02  +7.25414000E-03  -3.59490300E-02  +7.10628300E-02  +1.35274000E-02
   -1.88428000E-01  -8.78538000E-03  -1.53608000E-03  +1.92402300E-02  -7.90070000E-04
   -7.16800000E-04  +6.86410000E-04  +7.32710000E-04  +4.43770000E-04  -4.39860000E-04
   +9.61403900E-02  -4.74503000E-03  +4.14634840E-01  -3.13687000E-03  -9.72340000E-04
   +3.75890000E-04  +4.35633000E-03  -1.63957700E-02  +1.87808700E-02  -2.42920000E-03
   -1.34948000E-03  +1.73155000E-03  +4.51160000E-04  +2.52370000E-04  +6.63320000E-04
   +4.74350000E-04  -8.60400000E-05  -5.51100000E-05  -3.98870000E-04  +8.81060000E-04
   +8.43320000E-04  -7.28035900E-02  +1.88964400E-02  -1.03780700E-02  -8.21820000E-04
   +5.04677000E-03  -4.43304000E-03  -6.97830000E-04  -5.20200000E-05  +4.68020000E-04
   +2.25126830E-01  +1.07111000E-03  -2.48280000E-04  -9.36460000E-04  -6.14836000E-03
   -1.73557000E-03  +7.10026000E-03  -6.98000000E-05  -1.84970000E-04  +1.80230000E-04
   +6.55710000E-04  -1.13530000E-04  +3.49400000E-05  -3.72880000E-04  +1.08300000E-05
   +2.44990000E-04  +8.38100000E-05  -1.45020000E-04  -1.12700000E-04  +1.64043700E-02
   -1.29716100E-01  +3.60064100E-02  +7.50442000E-03  -2.93168600E-02  +2.05004000E-02
   +5.37910000E-04  +9.29300000E-05  -2.84670000E-04  -9.89557600E-02  +4.69149510E-01
   +2.18167000E-03  +5.98860000E-04  -5.18950000E-04  +4.77189000E-03  +1.73494100E-02
   -2.48576100E-02  -2.80060000E-04  -1.19810000E-04  +6.80970000E-04  -5.10630000E-04
   -2.36560000E-04  -6.53900000E-04  +8.77500000E-05  +6.70100000E-05  -2.40300000E-05
   -3.18800000E-05  -7.95430000E-04  -5.39100000E-04  -8.19161000E-03  +4.46296900E-02
   -1.21197620E-01  +6.81700000E-04  -4.84361000E-03  +1.07711300E-02  -2.30000000E-05
   -7.75000000E-06  +4.11000000E-06  -5.56055000E-03  +3.07623200E-02  +7.86793530E-01
   -4.49710000E-04  -1.16380000E-04  +8.59850000E-04  +1.55825000E-03  +3.68000000E-05
   -1.59284000E-03  +2.78690000E-04  -1.63670000E-04  +2.27040000E-04  -7.59660000E-04
   +2.49090000E-04  +4.84340000E-04  -3.93060000E-04  -3.11300000E-05  -2.75060000E-04
   +6.21950000E-04  +2.71000000E-06  -3.62740000E-04  +9.39800000E-05  +4.84130000E-03
   +1.63112000E-03  +1.01566000E-03  -4.18020000E-04  -8.37000000E-05  -1.78900000E-05
   +3.06500000E-05  -4.58200000E-05  -9.35133600E-02  +3.56791300E-02  +7.03710000E-03
   +5.93713110E-01  +2.78000000E-06  +7.71000000E-05  -3.06400000E-05  -1.11870000E-04
   -1.64066000E-03  +1.11420000E-04  +5.13300000E-05  -8.91930000E-04  +9.49950000E-04
   +8.86600000E-05  -9.42600000E-05  -5.98140000E-04  +3.73100000E-05  -3.51000000E-06
   +2.19260000E-04  +1.56510000E-04  -1.13810000E-04  -8.55500000E-05  +3.84147000E-03
   -2.02186700E-02  -4.03140000E-03  +5.13440000E-04  -4.88200000E-04  +2.66045000E-03
   +2.44420000E-04  +3.09100000E-05  -2.43720000E-04  +4.16460400E-02  -1.62778700E-01
   -8.93951000E-03  +1.25495400E-02  +4.85725900E-01  +2.00620000E-04  -4.49250000E-04
   +1.58370000E-04  -1.69407000E-03  +1.06788000E-03  +6.89320000E-04  +1.49498000E-03
   +6.34920000E-04  -5.83100000E-05  -5.92230000E-04  +7.13900000E-05  +6.19230000E-04
   -1.67510000E-04  +6.48500000E-05  -6.24990000E-04  +6.77630000E-04  -1.41970000E-04
   -7.14380000E-04  -5.65256000E-03  +1.77159500E-02  +1.37840400E-02  -1.10880000E-03
   +3.14480000E-03  -5.12136000E-03  -1.60770000E-04  -1.00090000E-04  +5.32000000E-05
   +8.66458000E-03  -1.25853800E-02  -9.31158200E-02  -5.97129000E-03  +1.29119000E-03
   +4.86862020E-01  +1.15110000E-04  +1.21550000E-04  -2.66150000E-04  -2.13820000E-04
   -3.63750000E-04  +2.65220000E-04  -4.48700000E-05  -2.25320000E-04  +1.01460000E-04
   +1.71330000E-04  -4.26600000E-05  -1.54950000E-04  +2.80310000E-04  +6.00600000E-05
   +1.08100000E-05  -2.24450000E-04  -7.44000000E-06  +6.32700000E-05  -3.36540000E-04
   +2.80797000E-03  +2.40269000E-03  -1.72190000E-04  +4.98350000E-04  -9.38950000E-04
   -1.85330000E-04  +5.21000000E-06  +1.00660000E-04  +4.35047000E-03  +1.69071600E-02
   -9.16363000E-03  -9.14320100E-02  -2.46759600E-02  +2.78338700E-02  +5.34850950E-01
   +3.78400000E-05  +3.24200000E-05  +2.46380000E-04  -1.08620000E-04  +3.78250000E-04
   -4.58620000E-04  +1.36310000E-04  +1.46490000E-04  +1.83100000E-05  -1.29400000E-04
   +1.57400000E-05  -1.31620000E-04  -5.48410000E-04  -7.10000000E-05  +2.25360000E-04
   +2.99690000E-04  -1.57700000E-05  -7.64500000E-05  -2.73910000E-04  -1.47748000E-03
   -6.88820000E-04  +1.25900000E-04  -1.71400000E-04  +1.52540000E-04  +5.82090000E-04
   +2.71400000E-05  -3.95990000E-04  -2.45235000E-03  -2.34188800E-02  +1.25060200E-02
   -2.86254700E-02  -1.29521380E-01  +6.30582500E-02  -1.09048000E-03  +5.12330220E-01
   +4.70000000E-07  +1.15010000E-04  -8.68600000E-05  +1.61420000E-04  +5.06800000E-05
   -2.80950000E-04  +3.05100000E-05  +2.33600000E-05  +4.63800000E-05  +4.87900000E-05
   -4.64400000E-05  -9.11800000E-05  -1.10320000E-04  -1.24500000E-05  +4.31200000E-05
   +3.28000000E-06  +2.82000000E-06  +5.79100000E-05  -1.20696000E-03  -4.02622000E-03
   -2.56403000E-03  +2.35540000E-04  -7.24790000E-04  +9.83150000E-04  +1.37870000E-04
   -8.95000000E-06  -8.18200000E-05  +8.53020000E-04  -2.74143000E-03  +1.11770100E-02
   +2.38793700E-02  +4.33604300E-02  -1.13097090E-01  +6.56663000E-03  +1.39860800E-02
   +5.53595890E-01  -1.06300000E-05  -6.26800000E-05  -8.89300000E-05  +2.30650000E-04
   -1.89520000E-04  +1.68140000E-04  -4.51900000E-05  -1.07650000E-04  -3.05100000E-05
   +3.67700000E-05  +1.82400000E-05  +1.55300000E-05  +2.36420000E-04  +3.38500000E-05
   -5.74100000E-05  -1.46560000E-04  +1.12500000E-05  +1.62100000E-05  -1.21490000E-04
   +1.70040000E-04  +9.32200000E-05  -2.46400000E-05  -1.36300000E-05  +1.09700000E-04
   -2.33170000E-04  -2.99300000E-05  +1.46280000E-04  +4.77970000E-04  +3.17763000E-03
   +5.16327000E-03  +4.81863000E-03  -1.65610000E-04  +2.55374000E-03  -8.32316900E-02
   -1.45648600E-02  -3.67845900E-02  +2.17158710E-01  +4.85170000E-04  +2.90900000E-05
   +2.56000000E-05  -1.34916000E-03  +1.15172000E-03  -5.89540000E-04  +3.22680000E-04
   -1.32110000E-04  +2.73210000E-04  -1.12470000E-04  -1.93900000E-05  -4.78850000E-04
   -9.64140000E-04  -7.48800000E-05  +5.42800000E-04  +5.03250000E-04  -1.22610000E-04
   -2.08630000E-04  +2.09146000E-03  -2.89541000E-03  +7.14610000E-04  +2.28980000E-04
   -1.45910000E-04  -4.89860000E-04  +1.17756000E-03  +9.07800000E-05  -8.21940000E-04
   -8.00600000E-03  -4.20000000E-04  -1.40639200E-02  +7.28371000E-03  +2.01626700E-02
   +1.71585600E-02  -6.41264000E-03  -9.49205100E-02  -2.35164800E-02  -1.19035700E-01
   +8.87698070E-01  -5.36000000E-06  -3.71100000E-05  -2.04180000E-04  +1.73640000E-04
   -1.07490000E-04  -1.24650000E-04  -5.81500000E-05  -1.62440000E-04  +4.72600000E-05
   +1.23580000E-04  -3.24800000E-05  +1.10910000E-04  +4.89340000E-04  +9.45900000E-05
   -2.15730000E-04  -2.36200000E-04  -3.54100000E-05  +1.89400000E-05  +1.22818000E-03
   +2.82350000E-04  -2.49410000E-04  -4.34900000E-05  +1.93200000E-05  +1.19480000E-04
   -5.20040000E-04  -6.04600000E-05  +3.45710000E-04  -3.74610000E-03  +1.17331000E-03
   -2.92802000E-03  -1.02958600E-02  +3.98440000E-04  -2.47921800E-02  -2.32608800E-02
   -4.29000500E-02  -1.91113150E-01  +8.67909700E-02  +5.73732500E-02  +5.85201770E-01
   +4.88010000E-04  +1.53730000E-04  -5.08000000E-06  -6.84080000E-04  +1.13583000E-03
   -1.35043000E-03  -8.96300000E-05  -1.06760000E-04  -4.14240000E-04  +2.21000000E-05
   -7.93000000E-06  -5.87400000E-05  -1.93390000E-04  +2.69000000E-05  +5.66200000E-05
   +9.91000000E-05  -1.09490000E-04  -8.36700000E-05  +9.59632000E-03  +1.64726000E-03
   +1.15555000E-03  -1.32280000E-04  +3.49400000E-05  -6.49800000E-05  +2.52900000E-04
   +8.50000000E-06  -1.33130000E-04  +3.83180000E-03  +1.17065000E-03  -7.43994000E-03
   -6.05846000E-03  -2.39712000E-03  +2.95950000E-04  +8.14935000E-03  -5.82288000E-03
   -5.47133000E-03  -7.03981200E-02  +4.79718900E-02  +6.42812000E-03  +1.49930590E-01
   -1.61530000E-04  +1.43100000E-05  -1.70600000E-05  +6.23400000E-04  -2.46420000E-04
   -1.20610000E-04  -1.44310000E-04  +1.55850000E-04  -1.31410000E-04  +1.06400000E-05
   +5.82000000E-06  +2.06100000E-04  +5.76150000E-04  +5.10600000E-05  -3.19960000E-04
   -2.83060000E-04  +2.78600000E-05  +4.43800000E-05  +1.79653000E-03  +2.50172000E-03
   -3.92784000E-03  -2.25800000E-05  -3.94930000E-04  +8.92800000E-04  -6.93500000E-04
   -6.19200000E-05  +4.65640000E-04  +7.69093000E-03  +1.41797600E-02  +2.17929300E-02
   +1.58611000E-03  -7.31314000E-03  -2.30205000E-03  -6.99558000E-03  -9.44808000E-03
   -9.21046000E-03  +4.31488600E-02  -4.53260420E-01  -1.18004550E-01  -1.01536260E-01
   +7.70963370E-01  +1.51330000E-04  +2.47400000E-05  -1.18620000E-04  -3.08210000E-04
   +4.06660000E-04  -4.33770000E-04  -1.78420000E-04  -5.39400000E-05  -1.11830000E-04
   +1.18250000E-04  -1.19300000E-05  +1.19480000E-04  +1.21380000E-04  -3.76000000E-06
   -2.98100000E-05  -1.00570000E-04  -3.04700000E-05  +1.67500000E-05  +8.93130000E-04
   -2.73771000E-03  -1.49525000E-03  +2.71540000E-04  -8.73120000E-04  +3.90080000E-04
   -1.39350000E-04  +8.58000000E-06  +1.15770000E-04  -9.88396000E-03  +2.33230700E-02
   -3.51668700E-02  -2.98098000E-03  -1.97618000E-03  +2.01647000E-03  +1.41753000E-03
   -2.73994900E-02  -2.63268000E-03  +6.28636000E-03  -1.28067970E-01  -1.62112830E-01
   +8.75134000E-02  +1.08334930E-01  +6.76853670E-01  +3.10510000E-04  +1.48910000E-04
   -1.87250000E-04  -1.58963000E-03  +2.41620000E-04  -9.02200000E-05  -6.55030000E-04
   -2.84470000E-04  +4.07630000E-04  +4.40030000E-04  -1.97440000E-04  +1.37640000E-04
   +1.87070000E-04  -3.29600000E-05  +5.41900000E-05  -1.99430000E-04  -3.72000000E-05
   +3.79700000E-05  +4.77774000E-03  -7.64470000E-04  -7.07750000E-03  -1.26616000E-03
   +3.27060000E-04  -4.80550000E-04  -2.11870000E-04  +5.42100000E-05  +1.88920000E-04
   -6.08176500E-02  +1.44479000E-02  +4.47803000E-03  +2.71873000E-03  +5.71711000E-03
   +1.26294200E-02  -6.30995000E-03  -1.28705000E-03  +2.77079000E-03  -3.32239000E-03
   +1.32386600E-02  -2.79165000E-03  -6.86387700E-02  +3.47455400E-02  -3.86929900E-02
   +1.81177020E-01  -6.45080000E-04  +6.63000000E-06  +4.44070000E-04  +7.26710000E-04
   -1.79775000E-03  +2.12620000E-03  -2.99930000E-04  -1.89870000E-04  -5.89900000E-05
   -2.09700000E-05  +2.11700000E-05  +1.60030000E-04  -2.04590000E-04  -3.75800000E-05
   +7.79000000E-06  +1.08580000E-04  +2.01990000E-04  +1.75550000E-04  +2.20330000E-04
   +7.48374000E-03  +2.23887800E-02  +1.53760000E-04  -1.04840000E-03  +2.43819000E-03
   +1.01570000E-04  +2.15100000E-05  -3.71000000E-05  +1.21686900E-02  -1.29792820E-01
   -7.63047100E-02  +2.89664000E-03  +1.72004000E-03  -3.00172800E-02  +3.00640000E-03
   -1.35900000E-04  -2.74590000E-03  +1.37936400E-02  -4.46541400E-02  +2.38099900E-02
   +4.07965300E-02  -1.68715990E-01  +7.91905300E-02  -1.39647580E-01  +6.25365980E-01
   +4.02920000E-04  +1.83250000E-04  +2.89000000E-05  -1.17186000E-03  +2.14660000E-04
   +1.98780000E-04  -9.72280000E-04  -2.11220000E-04  +2.49000000E-06  +3.93360000E-04
   -9.92400000E-05  +1.79380000E-04  +1.14900000E-04  +1.81800000E-05  +8.94100000E-05
   -1.79680000E-04  -5.00700000E-05  +7.30000000E-06  -4.14795000E-03  +4.04335000E-03
   -2.46508500E-02  -2.25590000E-04  +3.46880000E-04  -1.92662000E-03  -1.73910000E-04
   +1.61000000E-05  +1.62580000E-04  +1.47454100E-02  -6.36462300E-02  -4.78359670E-01
   +8.08475000E-03  -1.41063000E-02  -1.57459000E-02  -4.38390000E-03  -2.66021000E-03
   -1.54850000E-04  -4.57827000E-03  +2.30826600E-02  +1.65468700E-02  -3.25461200E-02
   +5.15346800E-02  -1.78326830E-01  +7.17644000E-03  +8.06699800E-02  +7.85923450E-01
   -2.31090000E-04  -4.34570000E-04  -3.34690000E-04  -4.65800000E-04  -7.47000000E-04
   +4.38040000E-04  +2.08490000E-04  -1.70590000E-04  -2.98340000E-04  +2.95790000E-04
   -3.78500000E-05  +1.31910000E-04  +7.00600000E-05  +9.59700000E-05  -1.51210000E-04
   +7.52100000E-05  +5.44200000E-05  +1.01270000E-04  -9.22390000E-04  -1.07651000E-03
   -1.35739000E-03  +2.68170000E-04  -2.42840000E-04  +4.65410000E-04  -7.24800000E-05
   -4.44300000E-05  +1.23660000E-04  +7.79013000E-03  +2.23017000E-03  +1.07781000E-02
   -1.05031050E-01  -1.79124300E-02  -5.49554900E-02  -6.76400000E-04  +1.22553000E-03
   +1.20599000E-03  +1.40271000E-03  +7.14590000E-04  +1.59963000E-03  +1.00856000E-03
   -1.60367000E-03  +5.21030000E-04  -1.39540000E-04  +2.08090000E-03  -2.00514000E-03
   +6.36528900E-01  -4.63760000E-04  -9.24650000E-04  +1.04050000E-04  -3.37980000E-04
   -1.28166000E-03  -2.62230000E-04  +1.13756000E-03  -2.23600000E-05  -1.48230000E-04
   -4.79410000E-04  +5.15300000E-05  +1.04280000E-03  +2.24010000E-04  +1.30660000E-04
   -1.16005000E-03  +4.65530000E-04  +5.78000000E-05  -3.10970000E-04  +6.59900000E-05
   +3.88295000E-03  +1.42311000E-03  -2.47180000E-04  +3.80320000E-04  -3.19970000E-04
   -9.21960000E-04  -8.45800000E-05  +6.96870000E-04  -1.27971400E-02  -5.28719000E-03
   -3.73091000E-02  -3.70760000E-03  -7.56823200E-02  -4.49828800E-02  +6.63601000E-03
   +3.14405000E-03  +1.64712300E-02  -2.01850000E-04  -7.97611000E-03  +9.57480000E-04
   -8.63880000E-04  +3.14345000E-03  +1.71583000E-03  +3.01321000E-03  -1.02150300E-02
   +1.77897000E-03  +3.29655000E-02  +9.25120500E-02  -1.21830000E-04  +7.14410000E-04
   -1.37920000E-04  +1.34877000E-03  +4.95650000E-04  +2.15890000E-04  -1.23146000E-03
   +6.41600000E-05  -4.63150000E-04  +5.56460000E-04  -7.03900000E-05  -2.86890000E-04
   +1.97000000E-06  -9.00300000E-05  +4.65700000E-04  -6.33830000E-04  +1.68960000E-04
   +6.65260000E-04  -5.92920000E-04  +1.41154000E-03  -1.55691000E-03  +4.07900000E-04
   -3.04580000E-04  +7.43510000E-04  +2.10350000E-04  +7.46900000E-05  -5.21700000E-05
   -6.20243000E-03  -7.28649000E-03  -2.09234400E-02  -1.12110600E-02  -4.42269200E-02
   -1.97242120E-01  -1.57122800E-02  -1.18224800E-02  -5.76180400E-02  +2.60453000E-03
   +1.06541200E-02  +1.85345000E-03  -1.77880000E-04  -1.04420000E-03  +7.17400000E-05
   +3.98380000E-04  -4.86342000E-03  +7.50380000E-04  +5.85455600E-02  +7.83623800E-02
   +3.23002730E-01  +4.74800000E-05  -3.85000000E-06  +9.02000000E-06  -2.01450000E-04
   +9.50300000E-05  +9.91700000E-05  +1.30000000E-07  -2.56300000E-05  +2.18000000E-06
   +5.14000000E-05  -6.14800000E-05  -1.02230000E-04  -1.93590000E-04  -1.45200000E-05
   +9.30700000E-05  +9.13600000E-05  -1.58400000E-05  -4.41000000E-06  +1.11940000E-04
   -2.30850000E-04  +8.18700000E-05  +1.87400000E-05  +4.05200000E-05  -7.23200000E-05
   +2.65340000E-04  -2.42000000E-05  -1.56490000E-04  +1.38286000E-03  -1.54908000E-03
   +2.03430000E-04  +1.96740000E-03  +1.08869000E-03  -6.81800000E-04  -1.10979400E-01
   +7.45790900E-02  -4.04240000E-04  +3.82238000E-03  -3.11420000E-04  +4.74940000E-04
   +3.14930000E-04  +1.57274000E-03  -3.50400000E-05  +7.50410000E-04  -9.40040000E-04
   +8.56170000E-04  +2.30258000E-03  +7.94010000E-04  +2.17440000E-04  +1.32925920E-01
   -1.17300000E-04  +7.85000000E-06  -1.72490000E-04  +6.23900000E-04  -8.40000000E-07
   -3.20060000E-04  -8.15400000E-05  -4.41800000E-05  -1.50600000E-05  +7.07200000E-05
   -6.98000000E-06  +2.06560000E-04  +6.37660000E-04  +8.88700000E-05  -3.66690000E-04
   -2.96950000E-04  +1.08300000E-05  +6.14300000E-05  +7.25990000E-04  -1.54038000E-03
   -2.63851000E-03  +1.45030000E-04  -6.08510000E-04  +1.15082000E-03  -7.31440000E-04
   -5.11400000E-05  +5.05790000E-04  -1.88761000E-03  -2.23691000E-03  +9.34099000E-03
   +2.18861900E-02  -4.52957300E-02  -1.11675100E-02  +7.40664700E-02  -1.84544300E-01
   -3.87525000E-03  +1.08944500E-02  -2.30397900E-02  -8.70314000E-03  -5.51650000E-04
   +2.24224000E-03  -2.60184000E-03  +1.56860000E-04  +2.00800000E-05  +7.92010000E-04
   +6.96400000E-05  +3.77667000E-03  -8.49350000E-04  -1.31623390E-01  +2.98022070E-01
   -4.79200000E-05  +3.55600000E-05  -4.67000000E-06  +1.73350000E-04  -2.25320000E-04
   +2.11150000E-04  -1.41330000E-04  +2.97900000E-05  -8.30200000E-05  +2.57500000E-05
   +3.43800000E-05  +2.93000000E-06  +3.61400000E-05  -2.79400000E-05  +5.05100000E-05
   -9.87200000E-05  +5.87500000E-05  +9.61600000E-05  -2.04500000E-04  +1.16709000E-03
   +7.22700000E-04  -4.55500000E-05  +1.77830000E-04  -2.21330000E-04  -3.53100000E-05
   +4.18700000E-05  +3.34400000E-05  +1.69645000E-03  +2.08595000E-03  -2.46849000E-03
   -1.24341100E-02  +1.50325500E-02  +2.30842000E-03  +2.12939900E-02  -4.22717900E-02
   -1.02612060E-01  +2.10375700E-02  -3.32837800E-02  -1.76811500E-02  -1.91167000E-03
   -2.62736000E-03  -7.73331000E-03  -3.37030000E-04  +2.96528000E-03  -1.48207000E-03
   -2.09405000E-03  +7.41893000E-03  +1.57634000E-03  +1.47004000E-02  +1.08975490E-01
   +6.40063340E-01  +4.46600000E-05  +2.88400000E-05  +6.81100000E-05  -2.25560000E-04
   +1.00960000E-04  +5.94400000E-05  +4.59600000E-05  +3.81400000E-05  -1.94700000E-05
   -2.96800000E-05  -1.26500000E-05  -8.28400000E-05  -2.89890000E-04  -4.07300000E-05
   +1.13960000E-04  +1.50250000E-04  +6.96000000E-06  -4.55000000E-06  -6.84130000E-04
   -5.74280000E-04  +7.47000000E-06  +4.14100000E-05  +2.74900000E-05  -1.67700000E-04
   +3.26840000E-04  +2.63300000E-05  -2.02890000E-04  -3.35110000E-04  -1.74180000E-03
   -2.11219000E-03  -1.28384000E-03  +4.81010000E-04  +8.75000000E-04  +4.48221000E-03
   +1.32718700E-02  -9.66072000E-03  -6.25168500E-02  +5.44146700E-02  -5.76764900E-02
   +6.77532000E-03  +1.38972300E-02  -6.65881000E-03  +8.14319000E-03  -4.50100000E-05
   +1.27094000E-03  +4.93900000E-05  -6.84000000E-06  -2.27803000E-03  +1.86535000E-03
   -5.81150000E-04  +2.65277000E-03  +7.78920500E-02  -4.07840000E-04  -9.89600000E-05
   -1.45210000E-04  +1.17392000E-03  -8.97630000E-04  +2.85260000E-04  -2.86410000E-04
   +5.03700000E-05  -6.79700000E-05  +1.08430000E-04  +6.27000000E-06  +4.49420000E-04
   +1.03095000E-03  +1.02260000E-04  -5.32470000E-04  -5.29310000E-04  +7.75700000E-05
   +1.43770000E-04  -3.59230000E-04  +2.61478000E-03  -3.72200000E-04  -1.30840000E-04
   +1.54600000E-05  +5.76010000E-04  -1.23105000E-03  -9.95400000E-05  +8.36490000E-04
   +3.69715000E-03  -9.50330000E-04  +2.95701000E-03  +3.44560000E-04  -4.84368000E-03
   -2.61970000E-03  +3.60340000E-03  -2.42926000E-03  +7.03458000E-03  +5.97732300E-02
   -2.28103820E-01  +1.30067320E-01  +1.84876800E-02  -5.60489000E-02  +3.62622900E-02
   -2.39532000E-03  +4.48711000E-03  -9.94334000E-03  -4.29750000E-04  +3.50661000E-03
   +5.68510000E-04  -3.45250000E-04  +2.68685000E-03  -1.14528000E-02  -1.62523150E-01
   +6.16543190E-01  +2.01490000E-04  +8.75000000E-05  +1.37460000E-04  -5.82450000E-04
   +4.54100000E-04  -5.77500000E-05  +9.06300000E-05  +4.28600000E-05  -2.37700000E-05
   -7.97600000E-05  +3.07900000E-05  -2.81230000E-04  -7.19840000E-04  -1.02630000E-04
   +3.97280000E-04  +3.13900000E-04  -2.49000000E-06  -3.02400000E-05  -5.28400000E-05
   -1.20766000E-03  +5.48380000E-04  +9.03400000E-05  +1.00000000E-05  -3.74150000E-04
   +8.41350000E-04  +9.58900000E-05  -5.60860000E-04  -8.64230000E-04  +1.73230000E-04
   -1.03729000E-03  -3.92415000E-03  -4.37931000E-03  -5.25860000E-04  -8.29755000E-03
   +3.27103400E-02  -3.20481500E-02  -4.22298900E-02  +7.50487500E-02  -2.10450930E-01
   -9.24870000E-04  +9.40209000E-03  +2.08113600E-02  +2.35980000E-04  -6.63833000E-03
   +6.45560000E-04  +8.13900000E-05  +8.94810000E-04  -5.33020000E-03  -2.00080000E-04
   -1.81920000E-04  -1.45294000E-03  +1.43142800E-02  +7.72987900E-02  +4.24581330E-01
   -1.72950000E-04  +4.47430000E-04  +2.62100000E-04  -2.84405200E-02  -7.70888000E-03
   -1.03284800E-02  -2.08712000E-03  -8.58350000E-04  +3.49458000E-03  -6.93100000E-04
   +2.14420000E-04  -1.03423000E-03  +1.72830000E-04  -7.47300000E-05  +2.38440000E-04
   -6.34550000E-04  +3.58600000E-05  -9.34710000E-04  -1.41639630E-01  -1.98632400E-02
   -3.82960900E-02  -2.89270000E-04  -5.09331000E-03  -3.18512000E-03  -6.62300000E-05
   -9.89000000E-06  -2.25000000E-06  -8.08666000E-03  +4.29429000E-03  -1.06385000E-02
   +4.14810000E-04  +1.67670000E-04  +4.95650000E-04  +4.08740000E-04  +4.36700000E-05
   -3.29780000E-04  -5.15000000E-06  +4.07500000E-05  -1.04340000E-04  +2.10080000E-04
   +3.60590000E-04  -9.39800000E-05  -7.11230000E-04  -4.97300000E-04  +2.36666000E-03
   -1.17726000E-03  +1.92545000E-03  -5.60450000E-04  -6.75700000E-05  -2.26910000E-04
   +3.40600000E-05  +6.23000000E-06  -1.88060000E-04  +1.01230000E-04  +4.88606440E-01
   -2.92400000E-05  -6.24600000E-04  -1.79370000E-04  -2.79652000E-03  -9.41240000E-04
   -9.49060000E-04  -3.40210000E-04  +4.15470000E-04  +1.84610000E-04  +2.75000000E-06
   +2.56240000E-04  -2.64000000E-04  +2.25070000E-04  +2.25790000E-04  +1.30100000E-04
   -2.53800000E-04  -1.36470000E-04  -1.63660000E-04  -1.34846500E-02  -7.93087300E-02
   -7.31530000E-03  -2.64602200E-02  -1.43582400E-02  -2.04352400E-02  -1.68750000E-04
   -4.27700000E-05  +6.63200000E-05  +2.00219100E-02  +7.28534000E-03  +1.36928100E-02
   -4.47640000E-04  +2.67770000E-04  +8.62410000E-04  -3.15320000E-04  +2.74040000E-04
   +6.82500000E-04  -2.20570000E-04  +1.80647000E-03  -2.67830000E-04  -1.37342000E-03
   -1.80044000E-03  +2.03770000E-04  +3.75790000E-04  -1.80219000E-03  +3.48300000E-04
   -1.65170000E-04  -9.86820000E-04  -1.23278000E-03  +9.34100000E-05  -2.65400000E-04
   -4.44210000E-04  +4.55210000E-04  -1.73239000E-03  +8.31290000E-04  -1.78196700E-02
   +5.81332460E-01  +2.00284000E-03  +4.87850000E-04  -8.82390000E-04  +1.60916000E-02
   +3.96271000E-03  +1.28130000E-02  +3.03026000E-03  +2.72090000E-04  -3.84409000E-03
   +1.11827000E-03  -1.06350000E-04  +4.22660000E-04  -2.87120000E-04  -2.71900000E-05
   +4.67350000E-04  +3.53880000E-04  +8.80700000E-05  +2.85640000E-04  -4.15383300E-02
   -1.29964000E-02  -9.91630600E-02  -1.72157200E-02  -1.14053500E-02  -1.35223200E-02
   +6.21750000E-04  +7.31600000E-05  -4.68880000E-04  -1.99043400E-02  -2.28210000E-04
   -1.88763800E-02  +1.46348000E-03  +1.75450000E-04  +1.83164000E-03  +7.52000000E-06
   -1.50270000E-04  -7.45720000E-04  +7.01500000E-05  -6.31920000E-04  +1.08950000E-04
   +1.37386000E-03  +1.24913000E-03  -3.87130000E-04  -7.26430000E-04  +1.48351000E-03
   +5.13720000E-04  -3.05814000E-03  +3.02189000E-03  -1.22092000E-03  +3.20000000E-07
   -5.37100000E-05  -3.75700000E-05  -2.75960000E-04  +7.25740000E-04  -4.58130000E-04
   -5.45678900E-02  -1.70017000E-03  +5.62990200E-01  -6.69400000E-04  -1.84350000E-04
   -1.89384000E-03  +7.83800000E-04  +1.25950000E-04  +4.57450000E-04  -1.17856000E-03
   -6.31600000E-05  -3.77580000E-04  +5.72306000E-03  +8.15490000E-04  -2.43100000E-03
   -3.84573900E-02  -3.07823000E-03  -2.13370000E-02  -2.32417000E-03  -7.16350000E-04
   +5.78887000E-03  -1.54220000E-04  -1.23060000E-04  +1.72920000E-04  +1.21130000E-04
   +7.11600000E-05  -7.97000000E-05  -3.75487540E-01  -3.25608400E-02  -2.03944190E-01
   +7.96600000E-05  -5.72000000E-05  -6.90000000E-06  -2.14600000E-05  -3.37000000E-05
   +3.01400000E-05  +3.69900000E-05  -1.04730000E-04  -2.17700000E-05  +4.26700000E-05
   -2.15840000E-04  +1.05220000E-04  -3.17600000E-05  +1.24710000E-04  +3.22900000E-05
   +5.46500000E-05  -2.91100000E-05  +5.04900000E-05  +2.93200000E-05  +1.51660000E-04
   -4.60100000E-05  -3.92000000E-05  +1.32500000E-04  -4.10000000E-06  -6.17200000E-05
   +2.23360000E-04  -1.60530000E-04  +2.16700000E-05  +2.64600000E-05  -9.88100000E-05
   +4.11249010E-01  -2.72330000E-04  +1.68310000E-03  -1.86780000E-04  +9.52000000E-05
   +1.29370000E-04  +6.78300000E-05  -6.33200000E-05  -6.80050000E-04  -3.05800000E-05
   +5.51400000E-04  -7.89480000E-04  -4.03780000E-04  -5.04798000E-03  -3.15204000E-03
   -2.91864000E-03  -6.66690000E-04  +1.99729000E-03  +8.19250000E-04  -1.13000000E-05
   -8.04500000E-05  +2.24200000E-05  +4.12800000E-05  +1.43800000E-05  -2.87500000E-05
   -3.04291300E-02  -6.32898000E-03  -1.43354000E-02  -1.71900000E-05  +1.42000000E-06
   +1.54400000E-05  -5.29600000E-05  +1.64600000E-05  +5.00400000E-05  -2.65600000E-05
   +3.25700000E-05  +2.11100000E-05  +1.18000000E-06  +3.22200000E-05  +9.90000000E-07
   +1.30200000E-05  -9.89000000E-06  -1.17000000E-05  -6.58000000E-06  -9.98000000E-06
   +2.92000000E-06  +3.61300000E-05  -2.84900000E-05  -3.28300000E-05  +5.75200000E-05
   -2.67400000E-05  -4.00900000E-05  +1.18800000E-05  -2.94300000E-05  -4.31000000E-06
   +1.04600000E-05  -6.02000000E-06  -1.35900000E-05  +3.56936700E-02  +7.47273000E-03
   +8.15700000E-05  +6.31600000E-05  +1.12352000E-03  -2.86580000E-04  +3.01500000E-05
   -3.63710000E-04  +3.20700000E-05  +2.13000000E-06  -6.58330000E-04  +4.37714000E-03
   +3.68470000E-04  +1.95672000E-03  +2.81988200E-02  +2.44420000E-03  +1.31282300E-02
   +4.14792000E-03  +6.23650000E-04  -2.67872000E-03  -9.23100000E-05  -6.10900000E-05
   -1.53160000E-04  +8.57900000E-05  +2.68100000E-05  -1.09500000E-05  -2.57424280E-01
   -2.01545000E-02  -2.05047950E-01  +1.46700000E-05  -1.33800000E-05  +1.41900000E-05
   +5.35800000E-05  +7.60000000E-06  +3.29700000E-05  -9.24000000E-06  +3.94000000E-05
   +5.83000000E-06  -1.12000000E-05  +7.61500000E-05  -3.15900000E-05  -1.54100000E-05
   -3.92100000E-05  -1.71600000E-05  -3.39000000E-05  +2.99000000E-06  -2.82100000E-05
   -2.42900000E-05  -3.75000000E-05  -2.05400000E-05  -1.37000000E-06  -5.13400000E-05
   -5.21000000E-06  +8.48000000E-06  -6.93200000E-05  +4.55600000E-05  -2.76700000E-05
   -3.80000000E-07  +3.20700000E-05  +2.22054750E-01  +1.67511500E-02  +1.94182720E-01
   +2.63460000E-04  +9.29900000E-05  +7.49470000E-04  -1.76290000E-03  -1.08831000E-03
   +4.20504000E-03  -1.87663200E-02  -1.77018000E-03  -1.40767900E-02  -2.78635090E-01
   -2.25077500E-02  -1.08478440E-01  -3.38485000E-03  -9.47470000E-04  +3.24939000E-03
   +1.93149000E-03  -3.70900000E-04  -4.64450000E-04  -5.63500000E-04  -1.26880000E-04
   -1.13459000E-03  -4.12200000E-05  -1.07390000E-04  -2.31000000E-06  +3.65462000E-03
   +8.27600000E-04  +9.74800000E-05  +7.57000000E-06  +1.48680000E-04  -9.43600000E-05
   -1.03440000E-04  +2.19400000E-05  -1.04700000E-05  -2.48400000E-05  +6.10300000E-05
   +1.81600000E-05  -2.04800000E-05  +1.29590000E-04  -6.47400000E-05  +5.30500000E-05
   -7.96900000E-05  -1.69000000E-05  -3.01000000E-05  +7.23000000E-06  -2.81700000E-05
   +3.97700000E-05  -9.72700000E-05  +5.62500000E-05  +5.19600000E-05  -7.97700000E-05
   -4.90000000E-07  +5.02400000E-05  -1.52450000E-04  +1.06590000E-04  -2.46820000E-04
   -2.13300000E-05  +4.10600000E-04  -9.14700000E-05  -6.56000000E-06  -1.57137000E-03
   +2.97129280E-01  +7.31000000E-05  -8.77840000E-04  +1.00570000E-04  -1.29621000E-03
   +7.21589000E-03  +8.16820000E-04  -2.92287000E-03  +2.07547000E-03  -1.89071000E-03
   -2.24161800E-02  -3.52111400E-02  -8.49234000E-03  +4.11780000E-04  +4.09756000E-03
   +7.63970000E-04  -4.36530000E-04  +5.40918000E-03  +3.92120000E-04  -1.49190000E-04
   +4.38360000E-04  -2.22950000E-04  +1.80000000E-06  -6.95200000E-05  -4.48700000E-05
   +8.00330000E-04  -3.81531000E-03  -2.27010000E-04  +1.75000000E-06  -2.80500000E-05
   +5.49500000E-05  -1.42820000E-04  +3.56000000E-05  +2.24000000E-05  -2.09500000E-05
   +3.13200000E-05  +3.49500000E-05  -1.30500000E-05  +5.56700000E-05  -2.02300000E-05
   +2.46000000E-05  -3.21600000E-05  -1.50400000E-05  -2.49400000E-05  -3.72000000E-06
   -2.71700000E-05  +4.50600000E-05  -4.65100000E-05  +1.26000000E-05  +6.42700000E-05
   -2.98100000E-05  -2.71300000E-05  +3.07200000E-05  -6.50000000E-05  +2.66400000E-05
   +2.73600000E-05  -6.01200000E-05  +6.86100000E-05  -1.27200000E-04  +5.52670000E-04
   -8.53000000E-05  +2.52850000E-02  +2.54857400E-02  +1.17070000E-03  +1.44550000E-04
   -1.27026000E-03  +3.42862000E-03  +6.73290000E-04  -1.19589000E-03  +1.72171300E-02
   +1.49583000E-03  +1.20318600E-02  -1.08703770E-01  -8.54441000E-03  -1.14374510E-01
   -2.99200800E-02  -2.82258000E-03  -7.10695000E-03  +2.13340000E-04  +4.67350000E-04
   -6.13586000E-03  +5.91160000E-04  +1.12360000E-04  +6.19840000E-04  -3.68300000E-05
   +4.31000000E-05  +4.91900000E-05  -6.67090000E-04  -3.40300000E-04  +2.69785000E-03
   -5.52900000E-05  -6.66300000E-05  +9.02600000E-05  +3.84800000E-05  +8.30000000E-06
   +1.16800000E-05  -9.40000000E-07  +1.46500000E-05  +9.64000000E-06  -5.39000000E-06
   +2.03500000E-05  +2.40000000E-07  -2.17600000E-05  -1.68000000E-06  -8.06000000E-06
   -1.35600000E-05  -1.09700000E-05  -2.11300000E-05  -1.59100000E-05  +9.17000000E-06
   -2.32000000E-05  +1.27000000E-06  -9.15000000E-06  -1.27200000E-05  -5.69000000E-06
   -6.95000000E-06  -2.81000000E-06  +1.58160000E-04  +9.87000000E-06  -2.10880000E-04
   +1.47727000E-03  +2.44200000E-04  -1.45439000E-03  +1.16910310E-01  +9.01119000E-03
   +1.15828110E-01  -5.31166000E-03  -1.22793000E-03  -2.27048000E-03  +3.52960000E-03
   +1.05897000E-03  -2.84134400E-02  -6.31484800E-02  -1.36495000E-03  -2.92589700E-02
   +6.07639000E-03  -8.22870000E-04  +2.67487500E-02  -3.78511000E-03  -1.36715000E-03
   +2.37304000E-03  -1.17383000E-03  -2.37100000E-05  +3.41880000E-04  +4.41940000E-04
   +4.11270000E-04  -5.95240000E-04  -6.24990000E-04  -2.00000000E-06  -8.02700000E-05
   -7.59100000E-05  -8.75500000E-05  +1.54985000E-03  -5.81500000E-04  -3.13220000E-04
   -3.18010000E-04  -5.34400000E-05  -3.21330000E-04  -3.36320000E-04  +3.87000000E-06
   -1.60410000E-04  -5.27000000E-05  +1.23200000E-05  -4.44840000E-04  +1.33050000E-04
   -1.04460000E-04  +2.61340000E-04  +1.93860000E-04  +1.93410000E-04  -2.56690000E-04
   +8.46740000E-04  +1.88700000E-05  +1.23930000E-04  +2.88500000E-04  -9.20200000E-05
   +1.76310000E-04  +6.34800000E-05  -1.03420000E-04  +4.65090000E-04  -2.65450000E-04
   +9.61500000E-05  -7.01100000E-05  +3.64800000E-05  +2.15160000E-04  +3.12900000E-05
   +1.94600000E-05  +8.62520000E-04  +6.02290000E-04  -2.94820000E-04  +6.35675900E-02
   -1.20565000E-03  +6.39283000E-03  -2.09980000E-04  -4.66050000E-04  +4.36771000E-03
   -2.23232000E-03  -8.51000000E-04  -3.97901800E-02  +1.00414200E-02  +4.39960000E-04
   +3.72648000E-03  +3.40734000E-03  -1.32705000E-03  +7.67190000E-03  +6.57600000E-04
   -1.04480000E-04  -1.20759000E-03  -2.47100000E-05  +3.79940000E-04  -3.11897000E-03
   -2.84390000E-04  +4.14660000E-04  +5.77000000E-05  +1.41820000E-04  +9.80000000E-06
   -3.43300000E-05  +1.75150000E-04  -7.04500000E-04  +4.37400000E-05  +5.65600000E-05
   -6.04290000E-04  -2.31000000E-06  -2.44050000E-04  +6.73800000E-05  -1.40580000E-04
   -2.53500000E-05  +7.14700000E-05  -2.90380000E-04  +9.84000000E-05  +3.65200000E-05
   +1.23800000E-04  +1.13230000E-04  +2.01430000E-04  -1.21030000E-04  +3.69090000E-04
   +2.12220000E-04  -1.40000000E-05  +1.69120000E-04  +1.96700000E-05  +1.06630000E-04
   +2.45400000E-05  -4.56000000E-05  +2.07460000E-04  -1.53340000E-04  -7.40200000E-05
   -2.30690000E-04  +1.09910000E-04  +2.78800000E-05  -3.20600000E-05  +5.79000000E-06
   +5.64140000E-04  -4.38214000E-03  -2.41500000E-04  +2.49918000E-03  +2.83553700E-02
   -2.84317000E-03  +2.76100000E-05  +3.93750000E-04  -2.45770000E-04  +7.41370000E-04
   -1.00562500E-02  -2.93575100E-02  +9.43018000E-03  -3.32745590E-01  -4.11083000E-03
   +1.26510000E-04  -1.34800300E-02  +2.92071000E-03  +6.24460000E-04  +1.03819000E-03
   +9.53700000E-05  -6.98400000E-05  +7.66270000E-04  +1.11396000E-03  -5.21000000E-06
   -8.06820000E-04  +6.55000000E-06  -1.46750000E-04  -1.45580000E-04  +2.66940000E-04
   +1.30220000E-04  -1.19091000E-03  +6.29630000E-04  +5.13630000E-04  +2.62970000E-04
   +4.26500000E-05  -1.57280000E-04  -2.72930000E-04  +1.03480000E-04  -6.05100000E-05
   +9.50000000E-06  -2.87300000E-05  +8.91100000E-05  +7.04800000E-05  +2.22800000E-05
   -4.60700000E-05  +4.84000000E-05  +4.61110000E-04  +1.52610000E-04  -1.46380000E-04
   +1.70230000E-04  -1.24600000E-05  +2.15610000E-04  +1.36800000E-05  +4.68400000E-05
   +3.40000000E-07  -4.16000000E-06  -7.53000000E-06  -2.14500000E-05  -9.50000000E-05
   +4.59800000E-05  +1.63020000E-04  -2.22700000E-04  -3.51600000E-05  -4.40000000E-06
   +2.84680000E-04  -2.26020000E-04  +8.66710000E-04  +3.04535300E-02  -1.08208300E-02
   +3.55360680E-01  -2.81250400E-01  -2.46919200E-02  -1.13959370E-01  +1.21859000E-03
   -4.09120000E-04  -1.15177000E-03  +1.57861000E-03  -6.62840000E-04  -2.53020000E-04
   +2.94090000E-04  +1.29650000E-04  +8.35830000E-04  -1.30611000E-03  -1.27414000E-03
   +3.57505000E-03  -1.89526300E-02  -2.17516000E-03  -1.35052300E-02  -1.05302000E-03
   +2.99220000E-04  +1.10810000E-04  -5.85900000E-05  +9.52400000E-05  -3.11200000E-05
   -1.45065000E-03  -1.48810000E-04  -6.07140000E-04  +1.67260000E-04  -1.39270000E-04
   -1.39620000E-04  -8.14300000E-05  -9.47900000E-05  -1.89470000E-04  +1.66900000E-05
   -2.92500000E-05  +2.39900000E-05  +9.43000000E-06  -1.11180000E-04  +1.65600000E-05
   -1.36700000E-05  +5.11100000E-05  +3.21000000E-06  +4.17000000E-06  +5.62200000E-05
   -2.23500000E-05  +3.73900000E-05  +2.69400000E-05  +2.64430000E-04  -8.21000000E-06
   +4.75300000E-05  +3.02000000E-05  -9.29000000E-06  +8.87900000E-05  -3.43300000E-05
   -1.82386000E-03  -5.13620000E-04  +2.61820000E-03  -2.54740000E-04  -1.58300000E-05
   +1.79860000E-04  -9.29300000E-05  +8.30700000E-05  -3.10200000E-05  -2.01000000E-05
   +1.78600000E-05  +1.08860000E-04  +3.03698720E-01  -2.52293600E-02  -4.17373800E-02
   -1.09350400E-02  +7.23410000E-04  +4.44613000E-03  +3.16120000E-04  -4.44270000E-04
   +6.51312000E-03  +6.32930000E-04  +5.10800000E-05  -1.05654000E-03  +1.22510000E-04
   -1.22260000E-03  +7.91528000E-03  +6.97350000E-04  -3.15506000E-03  +3.75050000E-03
   -1.84011000E-03  +2.27090000E-04  -3.74378000E-03  -4.04000000E-05  +4.56200000E-04
   +2.19500000E-04  -6.50830000E-04  -1.88230000E-04  +2.54500000E-05  -8.41100000E-05
   -4.06700000E-04  +9.92600000E-05  +4.30320000E-04  +9.05400000E-05  +1.77700000E-04
   +3.25100000E-04  -8.13000000E-06  -2.50000000E-06  -3.40200000E-05  +7.20000000E-07
   +9.61400000E-05  +1.74500000E-05  +3.74400000E-05  -1.80600000E-05  -6.82000000E-06
   +6.90000000E-06  -1.35520000E-04  +1.47700000E-05  -1.04190000E-04  +1.67530000E-04
   -4.92270000E-04  +3.42000000E-06  -1.08400000E-05  -5.97700000E-05  -2.84000000E-06
   -5.78500000E-05  -1.26800000E-05  -4.98300000E-04  +7.05950000E-04  +5.26920000E-04
   -1.66500000E-05  -1.96740000E-04  +1.55900000E-05  +7.33700000E-05  -7.28650000E-04
   -3.19400000E-05  +9.20800000E-05  +3.74400000E-05  -6.80000000E-06  +2.91090700E-02
   +2.95692400E-02  -1.13839990E-01  -1.06165100E-02  -1.18310970E-01  -2.85915600E-02
   -3.03989000E-03  -7.33705000E-03  +2.24400000E-05  +5.13440000E-04  -6.38140000E-03
   +9.90050000E-04  +1.05190000E-04  -8.59650000E-04  +3.40164000E-03  +7.10630000E-04
   -1.37769000E-03  +1.77345300E-02  +1.82908000E-03  +1.12360800E-02  -1.37301000E-03
   -3.22930000E-04  +8.66130000E-04  +1.97290000E-04  +6.30600000E-05  -6.45600000E-05
   +6.92710000E-04  +5.05900000E-05  +5.93550000E-04  +1.77400000E-04  +1.80430000E-04
   +1.85390000E-04  -2.45170000E-04  -8.87300000E-05  -1.84840000E-04  -2.55800000E-05
   +3.51900000E-05  +5.49700000E-05  -1.63000000E-05  +6.48400000E-05  -3.00600000E-05
   +5.06000000E-06  -8.15100000E-05  +1.14700000E-05  +4.95700000E-05  +1.44300000E-05
   +8.81000000E-06  +2.50900000E-04  -2.00140000E-04  +2.47900000E-04  +4.97200000E-05
   -4.86800000E-05  +9.96000000E-06  +3.91400000E-05  -9.09600000E-05  +7.26400000E-05
   +6.11380000E-04  +4.50700000E-05  -9.56520000E-04  +2.95390000E-04  +2.85900000E-05
   -1.32380000E-04  -7.95500000E-05  -3.92300000E-05  +6.23400000E-05  -1.59934000E-03
   -1.66440000E-04  -5.66640000E-04  +1.19580800E-01  +1.06606300E-02  +1.22233990E-01
   +6.94403000E-03  -4.57810000E-04  +2.64566500E-02  -3.61944000E-03  -1.28533000E-03
   +2.76213000E-03  -1.56357000E-03  -8.76000000E-05  +3.56260000E-04  -5.08816000E-03
   -1.10646000E-03  -1.97955000E-03  +3.33557000E-03  +8.03250000E-04  -2.95783100E-02
   -6.22004200E-02  -2.14177000E-03  -2.48799400E-02  +5.23420000E-04  -1.05600000E-04
   +8.93980000E-04  -9.14800000E-05  -1.04890000E-04  +4.81600000E-05  +2.06281000E-03
   +6.05690000E-04  +6.98910000E-04  -2.42920000E-04  +9.21300000E-05  +1.11040000E-04
   -1.46800000E-05  +2.63100000E-05  +4.71500000E-05  +6.21000000E-06  +1.63600000E-05
   -6.00000000E-08  -8.85000000E-06  +6.60000000E-05  -1.24000000E-05  +4.24600000E-05
   -2.99000000E-05  +5.59000000E-06  +1.42600000E-05  -3.57500000E-05  +2.09400000E-05
   -1.05600000E-05  -1.49100000E-05  -5.31900000E-05  +5.56000000E-06  -2.39500000E-05
   -8.55000000E-06  +1.14400000E-05  -6.21000000E-05  +3.25300000E-05  +1.16190000E-04
   +1.67000000E-05  +1.27000000E-06  +3.52550000E-04  +9.54900000E-05  +2.39500000E-04
   -8.68700000E-05  +6.33700000E-05  -1.51206000E-03  +7.77400000E-05  +8.14600000E-05
   +2.70500000E-05  +8.84620000E-04  +6.39040000E-04  -3.04450000E-04  +5.86513400E-02
   +6.07620000E-04  +2.54235000E-03  +3.49538000E-03  -1.43441000E-03  +7.06644000E-03
   +7.12510000E-04  -9.36400000E-05  -1.03513000E-03  -4.89100000E-05  -1.07647000E-03
   +5.45009000E-03  -3.20500000E-05  -2.77790000E-04  +5.38677000E-03  -2.68427000E-03
   -2.13766000E-03  -3.58581000E-02  +7.80412000E-03  +1.81290000E-04  +3.66330000E-04
   +1.26530000E-04  -1.08720000E-04  +4.10000000E-07  +3.38400000E-05  +5.79330000E-04
   -3.48781000E-03  -6.80100000E-05  +9.41900000E-05  +5.06500000E-05  -7.00000000E-05
   +4.11500000E-05  +1.07600000E-05  +9.32000000E-05  -2.30500000E-05  +1.52400000E-05
   -1.65700000E-05  +8.35000000E-06  +2.58500000E-05  +6.84000000E-06  -8.52000000E-06
   -1.49100000E-05  -8.22000000E-06  +5.00000000E-08  -1.51800000E-05  -2.61000000E-06
   -4.82000000E-06  -4.55500000E-05  -9.30600000E-05  +1.79100000E-05  -2.60300000E-05
   -2.43700000E-05  -3.37000000E-06  -1.27900000E-05  -7.66000000E-06  +9.63000000E-06
   -8.87100000E-05  +4.81000000E-06  +1.01380000E-04  -5.47900000E-04  +1.60000000E-06
   -2.33000000E-06  -4.79000000E-05  -1.55430000E-04  +8.53800000E-05  -6.84180000E-04
   -2.96100000E-05  +6.57970000E-04  -4.45833000E-03  -2.14590000E-04  +2.89449000E-03
   +2.53214400E-02  -4.01363000E-03  +6.45800000E-05  -1.21733200E-02  +3.13714000E-03
   +5.49940000E-04  +6.26170000E-04  -6.68600000E-05  -7.55200000E-05  +7.97560000E-04
   -2.60671000E-03  -1.11030000E-04  +4.52550000E-04  +3.05107000E-03  +9.33340000E-04
   -1.11774600E-02  -2.66281700E-02  +7.75515000E-03  -3.41644020E-01  -5.26320000E-04
   +1.04600000E-05  -3.45370000E-04  +9.69100000E-05  +1.01480000E-04  -7.25300000E-05
   +3.47110000E-04  -1.33220000E-04  +1.17034000E-03  +1.82550000E-04  -9.66000000E-05
   -9.03600000E-05  -9.32000000E-06  -4.74000000E-05  -4.95800000E-05  +5.07000000E-06
   -4.29500000E-05  -3.66000000E-06  +1.51100000E-05  -1.12350000E-04  +2.95100000E-05
   -2.97000000E-05  +5.78000000E-05  +4.41000000E-06  +6.84000000E-06  +3.55700000E-05
   +4.70000000E-06  +1.68100000E-05  +8.21500000E-05  +5.86200000E-05  -1.67300000E-05
   +5.98400000E-05  +1.59700000E-05  -1.89600000E-05  +1.04310000E-04  -5.85200000E-05
   -5.26300000E-05  +6.10000000E-07  -6.43000000E-05  +1.39410000E-04  -5.89000000E-06
   +1.29300000E-04  -6.68000000E-06  +1.71500000E-05  -4.62120000E-04  -1.01800000E-05
   -2.42800000E-05  -8.76600000E-05  +3.22410000E-04  -1.53050000E-04  +8.28960000E-04
   +2.66113400E-02  -8.86092000E-03  +3.62146770E-01  +8.41000000E-05  -7.64900000E-05
   +2.55560000E-04  +2.92820000E-04  +6.02480000E-04  -7.08420000E-04  -2.63080000E-04
   -1.28880000E-04  -4.05860000E-04  -2.33700000E-05  -8.48300000E-05  +8.03400000E-05
   -1.45710000E-04  -7.31000000E-06  +7.63100000E-05  -4.63000000E-06  -3.96200000E-05
   +6.57800000E-05  -2.69495000E-03  +3.91727000E-03  -3.50362000E-03  -5.16538700E-02
   +2.31966100E-02  -2.56646700E-02  +1.33480000E-04  +7.51000000E-06  -7.17000000E-05
   +5.98600000E-05  +9.07410000E-04  +4.41930000E-04  +4.64990000E-04  +3.35520000E-04
   -4.18520000E-04  -8.55200000E-05  +4.52700000E-05  +1.24680000E-04  +4.44200000E-05
   -1.12040000E-04  +3.24300000E-05  +1.31350000E-04  +4.86300000E-05  -6.67100000E-05
   +3.03450000E-04  +2.37560000E-04  +4.35030000E-04  -2.43500000E-05  +2.05600000E-05
   +1.05980000E-04  -3.20900000E-05  +1.13430000E-04  -2.11600000E-05  -4.57800000E-05
   +8.61600000E-05  -5.71500000E-05  -3.97000000E-05  -1.21399000E-03  +4.57440000E-04
   -2.37800000E-05  +1.19500000E-05  +5.10000000E-07  +5.80000000E-06  +1.69900000E-05
   -4.21000000E-06  +1.49560000E-04  +7.48100000E-05  +6.75000000E-05  +1.45800000E-05
   +3.88200000E-05  -2.78900000E-05  +5.04000000E-06  +1.17400000E-05  -4.50000000E-06
   +5.23672700E-02  +5.19400000E-05  +2.73760000E-04  -4.98000000E-06  -1.18092000E-03
   +6.45840000E-04  +8.93680000E-04  +6.65720000E-04  +3.01780000E-04  -1.55110000E-04
   -1.88600000E-04  -1.59610000E-04  +4.12360000E-04  -3.74000000E-05  -5.72600000E-05
   -4.13130000E-04  +2.39970000E-04  +8.43000000E-06  -2.48670000E-04  +4.14164000E-03
   -2.17645700E-02  +2.04101400E-02  +2.33952800E-02  -1.68768750E-01  +1.31766640E-01
   -2.18380000E-04  +4.50000000E-07  +1.57270000E-04  +9.25310000E-04  -4.18289000E-03
   -3.78320000E-03  -1.93550000E-04  -5.39010000E-04  +1.94024000E-03  +3.60640000E-04
   -8.39000000E-06  -3.72950000E-04  -8.76000000E-05  +2.95820000E-04  -1.56530000E-04
   +1.58900000E-05  -1.08100000E-04  +8.42400000E-05  +1.23800000E-04  +1.84740000E-04
   -9.01980000E-04  -1.98010000E-04  +1.00260000E-04  -3.78640000E-04  +3.98300000E-05
   -4.67130000E-04  +7.26400000E-05  +7.75700000E-05  -2.70280000E-04  +1.98860000E-04
   +9.36710000E-04  +3.91140000E-04  +1.66980000E-03  +3.42700000E-05  -3.19000000E-06
   +2.30000000E-06  -7.07000000E-06  -5.15000000E-06  -3.26000000E-06  -9.06900000E-05
   +4.43000000E-05  -3.03200000E-05  -2.52900000E-05  -7.76400000E-05  -8.33500000E-05
   +2.16200000E-05  +8.00000000E-07  +1.63000000E-06  -2.68536600E-02  +1.86558530E-01
   -2.52330000E-04  -1.19800000E-05  +1.93140000E-04  +3.99370000E-04  -8.53510000E-04
   +1.10437000E-03  -2.38310000E-04  -4.74700000E-05  -1.61050000E-04  -5.84000000E-06
   +8.69000000E-06  +1.17520000E-04  +5.67400000E-05  +1.59200000E-05  -7.84700000E-05
   +1.41600000E-05  +3.41700000E-05  +3.52000000E-06  +1.82428000E-03  -1.09342800E-02
   +8.09626000E-03  -2.64676100E-02  +1.34577040E-01  -1.89053890E-01  -1.33810000E-04
   -3.73900000E-05  +9.53200000E-05  +5.71350000E-04  -2.44306000E-03  -1.44751000E-03
   -6.19400000E-05  -6.78650000E-04  +5.35310000E-04  +6.71000000E-05  -1.42720000E-04
   -2.19090000E-04  -3.41200000E-05  -1.23020000E-04  -4.92600000E-05  -1.15200000E-05
   +2.81640000E-04  +4.16700000E-04  +1.74860000E-04  -2.00580000E-04  -8.34610000E-04
   +2.32900000E-05  +1.32780000E-04  +2.01260000E-04  -1.73500000E-05  -5.80500000E-05
   +8.57500000E-05  -2.51600000E-05  +2.28070000E-04  -5.86800000E-05  +4.06450000E-04
   -8.76410000E-04  +7.07530000E-04  +1.71900000E-05  +1.47600000E-05  -4.52000000E-06
   -1.31400000E-05  +1.82800000E-05  -7.49000000E-06  +6.60100000E-05  -1.12600000E-05
   +2.62000000E-05  -4.61600000E-05  -1.93600000E-05  -2.47200000E-05  -1.22600000E-05
   -4.04000000E-06  +1.73200000E-05  +2.83786700E-02  -1.41879310E-01  +2.04279560E-01
   +6.29600000E-05  +3.29030000E-04  -8.66270000E-04  +2.32050000E-04  +1.40548000E-03
   +1.17246000E-03  +7.86000000E-06  +2.35470000E-04  +4.03340000E-04  +2.77280000E-04
   +1.78710000E-04  -2.64280000E-04  +6.14230000E-04  +7.93400000E-05  +2.43890000E-04
   -6.42990000E-04  -1.64220000E-04  +1.87620000E-04  -4.14131000E-03  -1.08890000E-03
   +1.62394000E-03  -2.23218470E-01  -2.20565000E-03  +1.23979200E-01  -3.83570000E-04
   -8.04200000E-05  +2.08670000E-04  -7.35700000E-05  -3.46260000E-04  +4.24340000E-04
   +8.09000000E-06  +2.72620000E-04  +2.15000000E-05  -2.33000000E-05  +8.10900000E-05
   +7.49400000E-05  +4.75400000E-05  +7.00200000E-05  +8.17200000E-05  +1.21250000E-04
   -3.50280000E-04  -4.76530000E-04  +1.97250000E-04  +6.15960000E-04  +9.34200000E-04
   +7.46000000E-06  -5.94700000E-05  -2.47730000E-04  +4.59400000E-05  -4.73800000E-05
   -7.55300000E-05  +1.46400000E-05  -1.91860000E-04  +1.89300000E-05  +5.86110000E-04
   -6.71040000E-04  -9.03530000E-04  +5.52600000E-05  +6.85000000E-06  -7.51000000E-06
   -4.17400000E-05  -1.11000000E-06  -3.37000000E-06  +1.19970000E-04  -3.23010000E-04
   +4.92900000E-05  +5.64100000E-05  +2.88100000E-05  +3.72000000E-05  -2.66500000E-05
   -5.66100000E-05  +2.34300000E-05  +4.35238000E-03  -3.99960000E-04  -3.67416000E-03
   +2.40078640E-01  +6.44180000E-04  +3.52000000E-05  -1.51660000E-04  -4.57310000E-04
   -4.46647000E-03  -1.96830000E-03  +1.98770000E-04  +1.67120000E-04  -2.26290000E-04
   -1.85200000E-05  +2.23000000E-04  -1.12750000E-04  -3.51160000E-04  -8.55900000E-05
   +6.45000000E-05  +3.22880000E-04  +4.30770000E-04  -9.53200000E-05  +2.36771200E-02
   +5.54350000E-04  -1.72602500E-02  -3.73369000E-03  -4.75143600E-02  +1.49128000E-03
   +4.81900000E-04  +4.78200000E-05  -2.84470000E-04  -1.20730000E-04  +1.02099000E-03
   -3.06230000E-04  -2.81300000E-04  -1.09270000E-04  -2.60810000E-04  +1.70200000E-05
   -7.14000000E-05  -1.10600000E-05  +2.06200000E-05  -1.66310000E-04  +2.19500000E-05
   -1.82400000E-05  +1.55660000E-04  +1.40490000E-04  +3.29710000E-04  -4.29060000E-04
   +6.76490000E-04  +1.32600000E-05  +5.84200000E-05  +1.43640000E-04  -4.39500000E-05
   +9.76300000E-05  +3.90200000E-05  -4.09500000E-05  +1.90960000E-04  -9.31700000E-05
   +1.25394000E-03  +1.14233000E-03  +3.26900000E-04  -4.33400000E-05  -1.85800000E-05
   -2.47700000E-05  +4.82500000E-05  -1.10000000E-07  -5.75000000E-06  +7.64100000E-05
   -1.40290000E-04  +1.17220000E-04  -1.81000000E-06  -2.24370000E-04  -5.90000000E-05
   +5.12600000E-05  +3.85000000E-05  -5.16800000E-05  -1.85402700E-02  +8.44400000E-05
   +1.13752500E-02  +2.42412000E-03  +5.08737600E-02  +4.73790000E-04  -1.54530000E-04
   +1.77810000E-04  +1.56690000E-04  -3.21176000E-03  -5.83850000E-04  -6.90950000E-04
   -4.76800000E-05  -1.07880000E-04  +2.30950000E-04  +3.09710000E-04  -5.14600000E-04
   -1.92430000E-04  -4.75300000E-05  +5.32690000E-04  -5.30300000E-05  +2.06400000E-04
   +7.91900000E-05  +1.04099900E-02  +6.43010000E-04  -8.87517000E-03  +1.24185090E-01
   +1.31970000E-03  -1.36508620E-01  +5.12190000E-04  +3.89600000E-05  -3.58320000E-04
   -2.01890000E-04  +5.47360000E-04  -3.64500000E-05  -2.70000000E-07  -1.27070000E-04
   +4.71000000E-05  +3.72100000E-05  -7.76000000E-06  -5.15900000E-05  -2.00300000E-05
   +7.31100000E-05  -3.17600000E-05  -2.47100000E-05  +7.03000000E-06  +1.31880000E-04
   -7.15600000E-04  +5.41140000E-04  -1.63370000E-04  -9.36200000E-05  +2.01000000E-06
   -4.00800000E-05  -2.35000000E-05  -3.34600000E-05  +1.80000000E-05  +1.22100000E-05
   -2.95000000E-05  +2.60300000E-05  +7.23220000E-04  +5.57180000E-04  +3.15420000E-04
   -6.78000000E-05  -9.09000000E-06  -1.07300000E-05  +5.26300000E-05  +2.55000000E-05
   -1.67900000E-05  +1.37490000E-04  -2.36450000E-04  +1.17530000E-04  -1.73800000E-05
   -5.74900000E-05  -7.81100000E-05  +3.24000000E-05  +5.90000000E-06  -4.46400000E-05
   +1.90857600E-02  -8.76990000E-04  -1.26302400E-02  -1.37502430E-01  -5.07550000E-04
   +1.47630140E-01  +1.15500000E-05  -6.20000000E-06  -2.38840000E-04  +7.37730000E-04
   -2.94900000E-05  +6.84420000E-04  -2.91950000E-04  +4.74460000E-04  +5.56110000E-04
   +4.16500000E-05  +7.61900000E-05  -1.67070000E-04  +1.98300000E-05  -4.62400000E-05
   +1.35080000E-04  -5.03200000E-05  +4.03900000E-05  +7.68400000E-05  +2.97034000E-03
   +1.63998000E-03  +3.51637000E-03  -2.18631400E-01  -5.88160600E-02  -1.17008770E-01
   +1.12630000E-04  +1.10200000E-05  -9.10600000E-05  +4.10150000E-04  +1.55780000E-04
   -3.83920000E-04  -1.68520000E-04  -2.39140000E-04  +4.89500000E-05  -1.41000000E-05
   -4.63000000E-05  -2.89700000E-05  -3.57800000E-05  -2.30400000E-05  -7.29100000E-05
   +2.29300000E-05  +2.30110000E-04  +3.19620000E-04  +5.72220000E-04  -3.57400000E-05
   -8.55730000E-04  +1.01430000E-04  +1.90900000E-05  +2.04990000E-04  +1.04000000E-06
   +6.76000000E-06  +4.48700000E-05  -8.22000000E-06  +9.26900000E-05  +2.29300000E-05
   +7.64350000E-04  -5.90000000E-06  +9.34300000E-05  -1.86600000E-05  -3.94000000E-06
   +1.20000000E-06  +1.88600000E-05  +2.62100000E-05  -3.41000000E-06  -4.30140000E-04
   +4.84210000E-04  +1.51860000E-04  -4.13000000E-06  -5.90000000E-07  +3.54300000E-05
   +2.14000000E-06  -7.30000000E-06  -1.13400000E-05  -2.82610000E-03  -7.82730000E-04
   -7.28020000E-04  -1.85110900E-02  -6.17571000E-03  -1.49042600E-02  +2.35042960E-01
   +1.93190000E-04  +2.02300000E-04  -5.14510000E-04  -8.95890000E-04  +2.52760000E-04
   +1.37450000E-03  -4.30680000E-04  +1.50330000E-04  -4.84180000E-04  +4.10460000E-04
   +9.35400000E-05  -9.77200000E-05  +2.93240000E-04  +1.76000000E-05  +3.61980000E-04
   -4.42330000E-04  -7.58100000E-05  +1.42540000E-04  -2.31144200E-02  -7.29621000E-03
   -1.48736300E-02  -5.64186900E-02  -6.60892400E-02  -3.96426000E-02  -1.04140000E-04
   -4.15000000E-05  +6.94700000E-05  -3.70400000E-04  +1.50091000E-03  -7.85110000E-04
   +1.81600000E-04  -6.42500000E-05  -3.69750000E-04  -7.84700000E-05  -2.83600000E-05
   +8.62000000E-06  -1.84800000E-05  -9.23500000E-05  -6.88000000E-06  +8.73200000E-05
   +1.52190000E-04  +2.71760000E-04  -5.40000000E-05  -4.93440000E-04  +4.15370000E-04
   +1.36660000E-04  +1.40400000E-05  +3.33640000E-04  -6.15000000E-06  +8.23100000E-05
   +3.77000000E-05  -2.02800000E-05  +1.60560000E-04  -4.42200000E-05  +1.75136000E-03
   -5.31836000E-03  -2.54742000E-03  +1.86900000E-05  +1.48900000E-05  -8.29000000E-06
   +2.83000000E-06  +1.89600000E-05  -3.15400000E-05  +6.60400000E-04  -3.98040000E-04
   +8.82400000E-05  -8.15000000E-06  -4.33500000E-05  +8.46200000E-05  +9.40000000E-07
   -2.47900000E-05  -2.15000000E-06  +1.81192900E-02  +6.48253000E-03  +1.13303900E-02
   +1.00850000E-04  -1.00119000E-03  +4.16130000E-04  +6.21986600E-02  +7.26317000E-02
   +2.45680000E-04  +1.12760000E-04  -6.98090000E-04  -1.20498000E-03  +8.23000000E-05
   +6.45560000E-04  -1.74040000E-04  +2.23120000E-04  -6.74200000E-05  +4.76270000E-04
   +2.65510000E-04  -3.55810000E-04  +3.74940000E-04  -1.36600000E-05  +3.49730000E-04
   -4.70390000E-04  -1.03030000E-04  +1.85840000E-04  -1.03353900E-02  -2.21015000E-03
   -8.48647000E-03  -1.15755760E-01  -4.03636100E-02  -1.26794810E-01  -9.14200000E-05
   -1.83400000E-05  +5.70100000E-05  +3.66100000E-04  +8.09180000E-04  +2.55200000E-05
   -6.24900000E-05  +5.71000000E-06  -2.28400000E-05  -5.45000000E-06  +4.05300000E-05
   +4.94400000E-05  -1.31200000E-05  +1.10160000E-04  -4.37800000E-05  +6.00600000E-05
   -8.77100000E-05  +3.89500000E-05  +2.85680000E-04  +9.76190000E-04  +1.01660000E-04
   +1.55930000E-04  -8.42400000E-05  +6.12700000E-05  +3.01900000E-05  -5.78100000E-05
   -8.20000000E-06  +2.33300000E-05  -1.14020000E-04  +7.10500000E-05  +1.05853000E-03
   -2.82489000E-03  -1.45028000E-03  +2.72300000E-05  -9.12000000E-06  -1.86500000E-05
   +7.15000000E-06  -1.63900000E-05  -1.63600000E-05  +2.48350000E-04  -3.78760000E-04
   +2.70370000E-04  +1.01600000E-05  +1.54400000E-05  +1.49850000E-04  -9.60000000E-07
   -5.42000000E-06  -1.20000000E-06  -1.81137800E-02  -7.13726000E-03  -1.20669500E-02
   +1.55055200E-02  +5.76361000E-03  +1.12866700E-02  +1.27816160E-01  +4.45997200E-02
   +1.36980440E-01  -4.91170000E-04  -4.39610000E-04  +3.51390000E-04  +1.61743000E-03
   -4.16800000E-05  +5.28400000E-05  -2.49490000E-04  +1.65370000E-04  -1.57590000E-04
   +2.43120000E-04  +4.07900000E-05  -2.26480000E-04  +9.27500000E-05  +1.41100000E-05
   +3.20140000E-04  -2.65670000E-04  +8.04100000E-05  +1.47490000E-04  +4.32451000E-03
   -2.25163000E-02  -1.47928200E-02  -5.00842000E-03  -7.38980000E-04  -2.68612000E-03
   +8.71700000E-05  +1.05400000E-05  -7.90900000E-05  +8.04910000E-04  -1.33580000E-04
   +9.30930000E-04  -5.60130000E-04  -2.11330000E-04  -1.36319000E-03  +6.35400000E-05
   +1.09530000E-04  +1.59670000E-04  -4.66200000E-05  -6.03200000E-05  -4.44800000E-05
   -1.14000000E-05  -4.68300000E-05  +3.16400000E-05  +1.64900000E-05  +1.70870000E-04
   -1.91450000E-04  -7.59800000E-05  +5.67310000E-04  +7.66060000E-04  -3.31200000E-05
   -1.26700000E-05  +9.76800000E-05  +4.20200000E-05  -1.23100000E-05  +9.22200000E-05
   -4.95739300E-02  +2.44372300E-02  +1.91062800E-02  -1.96600000E-05  -1.25000000E-05
   +7.77000000E-06  +2.18400000E-05  -1.73200000E-05  -1.18500000E-05  +6.36700000E-05
   -5.46200000E-05  +2.81100000E-05  -8.40980000E-04  -9.55390000E-04  +8.87800000E-04
   -6.03000000E-06  -4.16600000E-05  -1.13000000E-06  -1.01450000E-04  +9.17000000E-05
   +1.43940000E-04  +1.51040000E-04  +9.92100000E-05  -2.29290000E-04  +2.66490000E-04
   -1.66147000E-03  -1.01736000E-03  +5.27383400E-02  -6.20500000E-04  +2.02350000E-04
   -8.59350000E-04  +7.79490000E-04  +2.21710000E-04  -4.39420000E-04  -2.67030000E-04
   +3.43200000E-05  +1.49190000E-04  +1.64340000E-04  +2.25300000E-05  -3.36900000E-05
   +6.48500000E-05  -5.71600000E-05  -2.43000000E-05  +1.84800000E-04  +7.63400000E-05
   +4.42950000E-04  +1.09501000E-03  -5.15419000E-03  -1.60169000E-03  -2.46194000E-03
   +2.82970000E-04  -1.29867000E-03  +5.67200000E-05  +7.69000000E-06  +4.81300000E-05
   -6.23790000E-04  +1.17350000E-04  +1.17640000E-04  -1.79680000E-04  +1.33200000E-05
   -3.03210000E-04  -2.84600000E-05  -9.68900000E-05  +8.91600000E-05  +2.26400000E-05
   -2.20130000E-04  +2.46300000E-05  +3.22000000E-06  +1.65880000E-04  +4.89700000E-05
   +3.37200000E-05  -7.90200000E-05  -8.59700000E-05  +2.73250000E-03  -3.14926000E-03
   +9.86850000E-04  -2.23700000E-05  +1.36440000E-04  +7.48500000E-05  -2.87300000E-05
   +2.01720000E-04  -9.31200000E-05  +2.11855000E-02  -2.16862130E-01  -1.29107210E-01
   +7.15000000E-06  -4.81000000E-06  -3.10000000E-06  -9.80000000E-07  -1.46900000E-05
   +9.53000000E-06  +9.51400000E-05  -6.34000000E-06  +5.56600000E-05  -2.58120000E-04
   -6.46580000E-04  +9.99200000E-04  -4.15500000E-05  +9.88000000E-06  +7.71000000E-06
   +1.18850000E-04  +6.14420000E-04  -2.20100000E-05  +1.69270000E-04  +6.46600000E-05
   +1.63090000E-04  +6.30200000E-05  -3.35630000E-04  -6.75010000E-04  -2.60178200E-02
   +2.39110350E-01  +5.76930000E-04  +5.18440000E-04  +1.85000000E-05  +8.63440000E-04
   +5.34090000E-04  +1.21320000E-04  -1.66870000E-04  +1.89780000E-04  -1.90800000E-05
   +1.22800000E-05  -3.60000000E-07  -1.50400000E-05  +1.20550000E-04  -3.96800000E-05
   -1.32000000E-06  -8.48000000E-05  -1.19400000E-05  +8.21500000E-05  +3.47385000E-03
   -1.18327800E-02  -8.91630000E-03  -3.11586000E-03  +3.46080000E-04  -1.53484000E-03
   -1.08880000E-04  -1.67000000E-06  +6.30400000E-05  +4.35460000E-04  -3.30600000E-04
   +5.41580000E-04  -7.54860000E-04  -3.62430000E-04  -1.93370000E-03  -1.73130000E-04
   -2.13000000E-06  +1.63100000E-04  -3.33200000E-05  -2.11380000E-04  -7.98600000E-05
   +1.04100000E-05  +1.62000000E-05  +1.38650000E-04  -2.62100000E-05  +2.57450000E-04
   -2.64220000E-04  +1.49212000E-03  -1.37868000E-03  +1.65099000E-03  +6.83600000E-05
   -6.76000000E-06  +1.92030000E-04  +5.78700000E-05  +1.37820000E-04  +7.68500000E-05
   +1.72048300E-02  -1.29904210E-01  -1.46621810E-01  +1.30900000E-05  -8.08000000E-06
   -4.45000000E-06  -1.92500000E-05  -4.09900000E-05  +9.40000000E-07  +1.59000000E-05
   -3.33400000E-05  -1.94000000E-06  +9.39430000E-04  +7.58290000E-04  -4.34850000E-04
   -1.24200000E-05  +2.01300000E-05  +1.22500000E-05  +9.92000000E-06  -2.38810000E-04
   +1.93930000E-04  -8.18700000E-05  +3.87890000E-04  +2.38500000E-04  -8.58700000E-05
   -1.14438000E-03  -7.05300000E-05  -1.89497100E-02  +1.40720550E-01  +1.56605990E-01
   +1.16290000E-04  +5.50200000E-05  -8.13230000E-04  -3.12928000E-03  -1.17346000E-03
   -4.40000000E-03  -8.10010000E-04  -2.48470000E-04  +1.48550000E-03  -4.54770000E-04
   +5.46300000E-05  -1.75700000E-04  +2.29640000E-04  +2.76200000E-05  -2.93420000E-04
   +1.85600000E-05  -5.04800000E-05  +8.48900000E-05  -2.18497400E-02  -4.25641000E-03
   +1.78100500E-02  +3.53320000E-04  +8.79840000E-04  +9.94250000E-04  -3.24340000E-04
   -4.06400000E-05  +2.52090000E-04  +1.12549000E-03  -1.27040000E-04  +2.14602000E-03
   -2.21940000E-04  +1.75090000E-04  +1.72350000E-04  -2.87200000E-04  +9.02600000E-05
   +9.05400000E-05  -3.24400000E-05  +4.61290000E-04  +8.17000000E-06  -7.36800000E-05
   -4.46180000E-04  -1.14100000E-04  +3.37370000E-04  +3.81940000E-04  -8.85880000E-04
   -1.19090000E-04  +1.93510000E-04  -4.00330000E-04  +1.43270000E-04  -7.55200000E-05
   -1.28310000E-04  +7.72200000E-05  -3.76320000E-04  +1.85760000E-04  -1.89855010E-01
   -3.52000000E-02  +1.29553030E-01  +6.13400000E-05  +9.29000000E-06  -1.76800000E-05
   -1.63760000E-04  -2.80000000E-06  +9.07700000E-05  -1.97200000E-05  -5.95600000E-05
   -8.59500000E-05  +1.93750000E-04  +1.34640000E-04  -3.18300000E-05  -3.18300000E-05
   -1.28900000E-05  +3.99100000E-05  +4.31200000E-05  +6.69400000E-05  -1.27110000E-04
   +4.78020000E-04  -5.90210000E-04  -4.80340000E-04  +2.85600000E-04  +1.60460000E-04
   -2.60350000E-04  -2.00551000E-03  -1.99140000E-04  +8.80480000E-04  +2.08996200E-01
   +2.55200000E-05  +3.03590000E-04  -1.21040000E-04  -4.75300000E-04  +1.15980000E-04
   -8.68080000E-04  -2.52150000E-04  +2.67550000E-04  +3.01670000E-04  -3.42500000E-05
   -4.93200000E-05  -1.18090000E-04  +7.26900000E-05  -3.59300000E-05  +1.95400000E-05
   -7.98800000E-05  +9.93000000E-05  +1.50400000E-05  -3.76230000E-03  -2.28925000E-03
   +4.30349000E-03  -7.15010000E-04  -7.45000000E-06  +9.45070000E-04  -4.44900000E-05
   -1.02500000E-05  +2.56700000E-05  +1.02176000E-03  +3.29400000E-05  +9.91800000E-05
   +6.23700000E-05  +2.36800000E-05  -7.68900000E-05  +2.49750000E-04  +9.39000000E-06
   +2.25400000E-05  +1.81700000E-05  -4.96800000E-05  +5.00200000E-05  -6.71700000E-05
   -2.93800000E-05  -4.17800000E-05  +2.47100000E-05  +5.11600000E-05  +1.91000000E-06
   +1.41960000E-04  -2.66190000E-04  +3.69800000E-04  -1.01730000E-04  +7.87900000E-05
   +3.53500000E-05  -3.09000000E-05  +1.55400000E-05  -2.80600000E-05  -3.53216600E-02
   -5.65326900E-02  +2.99712500E-02  +8.32000000E-06  -1.98000000E-06  -3.97000000E-06
   -2.30500000E-05  -5.26200000E-05  +1.43900000E-05  +5.72000000E-06  +3.80000000E-05
   -3.06600000E-05  +1.47240000E-04  -3.81030000E-04  -8.02500000E-05  -8.09000000E-06
   +2.51500000E-05  +7.03000000E-06  -1.02340000E-04  +8.00500000E-05  -2.22800000E-05
   -1.07500000E-04  -3.05600000E-04  -6.31800000E-04  +3.28820000E-04  +4.58500000E-05
   -1.31800000E-04  +1.97716900E-02  +6.43636000E-03  -1.67776100E-02  +3.89976700E-02
   +5.63959000E-02  -2.45690000E-04  +8.40000000E-05  -1.02989000E-03  -2.32863000E-03
   -8.74850000E-04  -2.11183000E-03  -9.39380000E-04  -1.10610000E-04  +7.64910000E-04
   -5.24000000E-05  +7.76300000E-05  -1.79370000E-04  +2.37600000E-05  -9.78000000E-06
   +1.59700000E-05  +1.24020000E-04  +1.38900000E-05  +4.15110000E-04  -1.38974000E-02
   -3.24279000E-03  +9.19599000E-03  -3.72910000E-04  +4.87080000E-04  +7.34750000E-04
   +1.07050000E-04  +6.43000000E-06  +7.83000000E-06  -9.08750000E-04  -6.95100000E-05
   +1.26953000E-03  -2.85500000E-05  -3.05500000E-05  -7.78200000E-05  +1.21620000E-04
   +7.33300000E-05  +4.12800000E-05  -2.85700000E-05  +1.63670000E-04  -2.52200000E-05
   +3.22700000E-05  -6.96000000E-05  -5.49000000E-05  +6.62900000E-05  -1.79950000E-04
   +1.81750000E-04  +1.76770000E-04  -2.83210000E-04  +2.80880000E-04  -3.55100000E-05
   -4.87100000E-05  -3.07000000E-06  +2.58400000E-05  -1.94370000E-04  +1.06970000E-04
   +1.32003700E-01  +3.06222800E-02  -1.63001410E-01  -2.59000000E-06  +1.03000000E-06
   -1.93000000E-06  -5.49000000E-05  -9.98000000E-06  +3.93500000E-05  +3.62600000E-05
   -4.21800000E-05  +7.31500000E-05  +5.20330000E-04  +1.29600000E-05  +5.21920000E-04
   -2.37700000E-05  +2.42000000E-06  +2.03000000E-06  +3.61000000E-05  -1.07360000E-04
   -6.68500000E-05  +3.68000000E-05  -8.74500000E-05  -3.75200000E-05  +5.80900000E-05
   +1.54340000E-04  +9.50200000E-05  +1.22935000E-02  +5.21548000E-03  -1.16499400E-02
   -1.39491810E-01  -3.32702400E-02  +1.75970710E-01  -5.38590000E-04  -3.23800000E-05
   -4.91900000E-05  +9.49650000E-04  +3.17280000E-04  -1.01490000E-04  -2.75860000E-04
   -2.34840000E-04  +5.11200000E-05  +2.14490000E-04  +1.22300000E-05  -1.46260000E-04
   +1.04000000E-06  +2.65000000E-06  +2.05140000E-04  +8.64000000E-06  -7.43000000E-05
   +3.16020000E-04  -7.15756000E-03  +2.15853500E-02  -1.61378000E-02  +8.54890000E-04
   +1.70640000E-03  +3.27090000E-04  +1.72020000E-04  +1.62000000E-05  -7.67600000E-05
   -3.66174000E-03  -2.48966000E-03  -1.79505000E-03  +3.34910000E-04  -2.38480000E-04
   -3.10540000E-04  -1.59060000E-04  -1.10230000E-04  -2.07140000E-04  +8.45600000E-05
   -5.49350000E-04  +1.20450000E-04  +4.00070000E-04  +5.35970000E-04  -1.27940000E-04
   -3.89900000E-05  +6.67910000E-04  -4.39500000E-04  -9.26300000E-05  +3.85510000E-04
   +1.53340000E-04  +1.34300000E-05  +1.35830000E-04  +7.92500000E-05  -1.54780000E-04
   +5.59660000E-04  -2.87720000E-04  -6.49026200E-02  +5.37603600E-02  -3.84185800E-02
   -2.45800000E-05  +3.51000000E-06  +4.08000000E-06  +1.14100000E-05  +3.11400000E-05
   -3.50000000E-07  +1.00320000E-04  +6.33300000E-05  +3.61500000E-05  -9.90150000E-04
   +5.58080000E-04  +1.07896000E-03  -2.35800000E-05  +2.13500000E-05  -1.77000000E-06
   +2.25100000E-05  -9.06040000E-04  -6.84900000E-05  -1.59600000E-05  -1.92700000E-04
   +7.46500000E-05  +4.86800000E-05  +8.85900000E-05  +4.24970000E-04  -1.61003000E-03
   +2.73604000E-03  -1.93708000E-03  +6.92673000E-03  -1.98766700E-02  +1.25358200E-02
   +7.00518400E-02  +3.11260000E-04  +3.04740000E-04  +1.16468000E-03  +7.69600000E-05
   +2.17300000E-05  +3.15530000E-04  +1.34430000E-04  -1.45000000E-05  -1.85970000E-04
   -5.66500000E-05  -8.26000000E-06  -5.00200000E-05  -2.32000000E-06  -5.96300000E-05
   +1.46180000E-04  -3.18080000E-04  -4.30000000E-07  -3.77240000E-04  -2.25721000E-03
   +4.25445000E-03  -4.33101000E-03  -1.20984000E-03  +6.77380000E-04  -1.56879000E-03
   -4.02900000E-05  +4.23000000E-06  -6.55200000E-05  -7.38790000E-04  +4.35330000E-04
   -2.91210000E-04  -5.21640000E-04  -2.29980000E-04  -8.39770000E-04  -9.52200000E-05
   +6.27900000E-05  +8.21500000E-05  -3.27900000E-05  +1.07780000E-04  -8.88300000E-05
   +1.68510000E-04  -1.07820000E-04  +7.15300000E-05  +1.26410000E-04  +3.43360000E-04
   -7.27870000E-04  +8.64840000E-04  -1.02142000E-03  +6.80950000E-04  +7.10100000E-05
   -1.00080000E-04  +8.58000000E-05  +5.75600000E-05  -8.38900000E-05  +1.33480000E-04
   +5.54635300E-02  -2.11894100E-01  +1.17823490E-01  -1.28400000E-05  -6.82000000E-06
   +4.77000000E-06  +5.33000000E-06  +1.49000000E-06  -1.34000000E-05  -5.85700000E-05
   -1.34900000E-05  -3.47200000E-05  -2.28820000E-04  -5.72500000E-05  -5.13020000E-04
   +3.29000000E-05  +2.31700000E-05  -6.87000000E-06  -5.09300000E-04  +1.22450000E-04
   -3.02680000E-04  +1.80640000E-04  -4.21700000E-05  +1.12920000E-04  +8.22900000E-05
   +2.41870000E-04  -1.07160000E-04  +5.58593000E-03  -1.92822400E-02  +1.50464200E-02
   +1.20820000E-03  -3.98609000E-03  +1.62206000E-03  -5.83151200E-02  +2.29024350E-01
   +5.86990000E-04  -3.64370000E-04  -1.52890000E-04  +3.95270000E-04  -8.42900000E-05
   +1.63600000E-04  -1.33810000E-04  -1.10280000E-04  -2.95200000E-05  +2.48900000E-05
   -5.70000000E-07  -1.56000000E-05  +4.62800000E-05  +5.97000000E-05  +2.35400000E-05
   -4.91900000E-05  -1.09100000E-05  +9.39000000E-05  -3.61585000E-03  +1.20457500E-02
   -1.02567800E-02  +1.47820000E-04  +1.28960000E-03  +1.16650000E-04  -3.14900000E-05
   -1.20300000E-05  +2.26300000E-05  -3.63186000E-03  -1.71882000E-03  -1.87485000E-03
   +1.16100000E-05  -4.67680000E-04  -1.03708000E-03  +6.34600000E-05  -1.50160000E-04
   -8.65600000E-05  +7.87100000E-05  -8.59680000E-04  +6.08600000E-05  +2.74410000E-04
   +7.60120000E-04  -6.79600000E-05  -2.74570000E-04  +2.61030000E-04  +5.71380000E-04
   +9.68910000E-04  -7.12800000E-04  +9.44340000E-04  -6.43700000E-05  +1.73450000E-04
   +1.87740000E-04  -1.35980000E-04  +7.18510000E-04  -3.39300000E-04  -3.87469600E-02
   +1.16806180E-01  -1.29884810E-01  +2.13000000E-06  +5.60000000E-06  -3.35000000E-06
   -1.40800000E-05  +1.65800000E-05  +5.30000000E-07  +2.83800000E-05  +4.06700000E-05
   -2.24300000E-05  +9.39610000E-04  -2.92720000E-04  -2.37930000E-04  -5.05000000E-06
   -1.78200000E-05  +6.85000000E-06  -4.77050000E-04  -9.41020000E-04  +4.37800000E-05
   +4.13300000E-05  +6.50400000E-05  -2.72920000E-04  +3.17950000E-04  -1.38710000E-04
   +3.72210000E-04  +5.15425000E-03  -1.59625600E-02  +1.18489800E-02  -6.36177000E-03
   +1.65202500E-02  -1.11794400E-02  +4.47221200E-02  -1.27559330E-01  +1.41506070E-01
   -3.30800000E-04  -6.33000000E-05  +7.68600000E-05  +5.48030000E-04  -4.59810000E-04
   +8.33270000E-04  +1.97820000E-04  +4.58400000E-05  +2.27970000E-04  -9.33400000E-05
   -1.86500000E-05  -3.13600000E-05  +3.99300000E-05  -6.66000000E-06  -2.94100000E-05
   +1.67200000E-05  +4.16200000E-05  +2.51100000E-05  -6.73189000E-03  -1.38386000E-03
   -4.65210000E-04  +9.13750000E-04  +5.74580000E-04  -7.70780000E-04  -6.28200000E-05
   -7.34000000E-06  +1.11300000E-05  +6.27827000E-03  +9.23330000E-04  +1.68985000E-03
   +1.13017600E-02  +1.90239000E-03  -2.36330000E-04  -3.81460000E-04  +1.11900000E-04
   -5.95840000E-04  +8.33760000E-04  +1.63493000E-03  -1.52594000E-03  +1.87466000E-03
   +5.85198000E-03  +3.18361000E-03  -5.86201600E-02  +6.73851800E-02  +2.17856500E-02
   -7.07270000E-04  +1.45019000E-03  +9.16830000E-04  -1.69210000E-04  +7.07200000E-05
   +6.58200000E-05  +9.06700000E-05  +3.70720000E-04  +1.82000000E-04  -9.79300000E-05
   +9.52600000E-04  -1.06859000E-03  -6.00000000E-08  +4.40000000E-07  +1.49900000E-05
   -1.49800000E-05  +4.56000000E-06  +1.17700000E-05  -9.78100000E-05  +6.47900000E-05
   -3.07000000E-05  -2.41000000E-06  -5.06000000E-06  -1.57100000E-05  -2.34800000E-05
   +4.03000000E-06  +1.21100000E-05  -4.91760000E-04  -1.37270000E-04  -2.08310000E-04
   -4.51940000E-04  +9.67940000E-04  -8.84340000E-04  -3.92250000E-04  -7.44720000E-04
   +4.37440000E-04  -4.33400000E-05  -1.56800000E-05  +2.97000000E-06  +1.08000000E-05
   +2.04300000E-05  -3.88700000E-05  -3.00270000E-04  -1.37380000E-04  -1.94140000E-04
   +4.73055500E-02  -3.91200000E-05  +1.56000000E-06  +1.28100000E-05  -6.28000000E-06
   -1.81110000E-04  +1.63910000E-04  +4.38800000E-05  +4.20500000E-05  -2.59900000E-05
   -7.26000000E-06  +7.24000000E-06  +2.69000000E-05  -1.74700000E-05  -6.81000000E-06
   -4.16000000E-06  +1.17000000E-05  +2.48400000E-05  +5.94000000E-06  -1.69932000E-03
   -1.79485000E-03  +3.33640000E-04  +5.03260000E-04  -1.68403000E-03  +3.27042000E-03
   +3.84000000E-06  +4.39000000E-06  -1.03000000E-06  +2.86880000E-03  -2.17978000E-03
   -2.81395000E-03  +2.18870000E-03  +1.68481000E-03  -1.08510000E-04  +1.02450000E-04
   +6.30570000E-04  +1.77810000E-04  +1.66862000E-03  -2.12100000E-05  +3.20643000E-03
   +4.59828000E-03  -1.58641700E-02  -8.23184000E-03  +6.75832100E-02  -2.88108750E-01
   -9.19416000E-02  -1.48530000E-04  +1.88320000E-04  -8.16900000E-05  -3.17800000E-05
   -1.11180000E-04  -1.49950000E-04  +8.88800000E-05  -1.38165000E-03  -3.01340000E-04
   +1.22290000E-04  +2.50820000E-04  -3.92160000E-04  -1.53000000E-06  -5.29000000E-06
   +1.07000000E-06  +1.69000000E-06  -6.27000000E-06  -2.09000000E-06  +4.41400000E-05
   -2.17700000E-05  -6.03000000E-05  +1.30000000E-07  -1.31700000E-05  +2.85000000E-06
   -1.57000000E-06  -1.53000000E-06  +7.40000000E-07  -1.39980000E-04  +2.71670000E-04
   +5.92070000E-04  +2.56500000E-05  -6.81950000E-04  +1.01766000E-03  +1.31990000E-04
   -9.10640000E-04  +1.15485000E-03  -3.08800000E-05  -1.71200000E-05  +1.56400000E-05
   -3.83400000E-05  +1.23100000E-05  -5.63000000E-05  -1.03470000E-04  +3.77000000E-05
   -7.22000000E-05  -7.72472100E-02  +3.09703430E-01  -3.02200000E-05  +2.94300000E-05
   +2.02300000E-05  +8.27900000E-05  +1.84790000E-04  +1.86000000E-05  -8.45800000E-05
   +6.05100000E-05  -5.63800000E-05  +2.57000000E-06  +3.96400000E-05  +5.68300000E-05
   +7.56700000E-05  -6.19000000E-06  -4.59300000E-05  -4.65200000E-05  -1.32600000E-05
   +2.78000000E-06  +6.72980000E-04  -1.10271000E-03  +9.98340000E-04  -9.92000000E-06
   +5.08700000E-04  -1.31126000E-03  -1.05950000E-04  -6.99000000E-06  +7.34800000E-05
   +9.03564000E-03  -3.04441000E-02  -7.26980000E-03  -1.87688000E-03  +1.84214000E-03
   -4.10743000E-03  -2.00430000E-04  +3.86430000E-04  -2.80220000E-04  -1.59719000E-03
   +2.00637000E-03  -3.29203000E-03  -5.40168000E-03  +2.12158900E-02  +9.01204000E-03
   +2.21151300E-02  -8.89038600E-02  -9.01598900E-02  +2.21610000E-04  -2.21226000E-03
   -1.75363000E-03  +6.33300000E-05  -2.53980000E-04  +2.67110000E-04  +5.38100000E-05
   +1.30544000E-03  +5.43200000E-04  -5.13900000E-05  +1.33940000E-04  +3.61700000E-05
   +1.85400000E-05  -6.83000000E-06  -4.25000000E-06  -1.39600000E-05  -1.17000000E-05
   +3.00000000E-07  +4.66800000E-05  -9.15300000E-05  +2.99200000E-05  +1.06700000E-05
   -1.47100000E-05  -1.09000000E-05  -2.84000000E-06  -1.10200000E-05  +9.28000000E-06
   -6.57300000E-05  -7.49100000E-05  +5.52090000E-04  -9.99950000E-04  +9.06200000E-04
   -2.73080000E-04  +5.19980000E-04  +1.09482000E-03  -5.78310000E-04  +9.17800000E-05
   +6.96700000E-05  +1.59700000E-04  -3.11200000E-05  -5.46900000E-05  -2.36900000E-05
   -2.95200000E-05  +6.06000000E-06  -6.09300000E-05  -2.32492200E-02  +9.36134300E-02
   +9.67748100E-02  +6.49200000E-05  +9.89000000E-06  -1.56900000E-05  -1.56330000E-04
   +2.26530000E-04  -2.10490000E-04  +2.14000000E-05  -1.26300000E-05  +4.12600000E-05
   -5.43000000E-06  +8.80000000E-07  -3.24300000E-05  -6.18500000E-05  -5.81000000E-06
   +4.06100000E-05  +2.85500000E-05  -1.99200000E-05  -2.80500000E-05  +8.11980000E-04
   -1.58410000E-04  -2.18860000E-04  +4.15000000E-05  -3.24400000E-05  -4.48700000E-05
   +7.21000000E-05  +1.01800000E-05  -5.65500000E-05  +4.11080000E-04  +1.81109000E-03
   -1.48448000E-03  -5.56420000E-04  +5.79220000E-04  -1.72950000E-04  +9.56417000E-03
   +2.12893000E-03  -3.57910000E-04  +7.53198000E-03  -5.78930000E-04  +2.98977000E-03
   -3.97946300E-02  -3.06257000E-03  -3.91296500E-02  -2.39480000E-04  -4.60686000E-03
   -5.75065000E-03  -6.06900000E-05  -2.16730000E-04  +2.19800000E-05  -4.94350000E-04
   -2.68260000E-04  -1.12520000E-03  -5.97082000E-03  -5.96910000E-04  +7.66490000E-04
   +8.31500000E-05  +4.30600000E-05  +2.57200000E-05  -1.22000000E-05  -2.02000000E-06
   +9.14000000E-06  +4.70000000E-07  -1.77000000E-06  +7.71000000E-06  +1.71000000E-06
   -7.76000000E-06  +1.43800000E-05  -8.39000000E-06  +9.91000000E-06  -4.71000000E-06
   +6.93000000E-06  -2.90000000E-07  -1.06500000E-05  -2.39100000E-05  +3.21100000E-05
   +1.02800000E-05  -3.49900000E-05  -4.97000000E-06  +1.09300000E-05  +6.04000000E-06
   -3.10000000E-06  -1.12000000E-06  -8.16000000E-06  -1.02500000E-05  -1.60500000E-05
   +3.62000000E-06  -1.39900000E-05  +2.03600000E-05  -1.13200000E-05  -6.23000000E-06
   -2.56600000E-05  -4.41630000E-04  -4.99320000E-04  +3.00050000E-04  +2.95613100E-02
   -8.01700000E-05  -1.83300000E-05  +1.62500000E-05  +1.76030000E-04  -1.59460000E-04
   +1.06230000E-04  -6.81000000E-06  +2.85000000E-06  +3.47400000E-05  -1.45400000E-05
   +2.96000000E-06  +2.08100000E-05  +3.48200000E-05  +1.16000000E-06  -1.93300000E-05
   -2.07000000E-05  +2.01800000E-05  +1.52000000E-05  -4.28610000E-04  +4.86970000E-04
   +6.56850000E-04  -1.09000000E-05  +1.06080000E-04  -9.55000000E-06  -5.25800000E-05
   -6.36000000E-06  +3.11200000E-05  +1.50334000E-03  -3.34655000E-03  +1.94088000E-03
   +1.96780000E-04  -5.00530000E-04  +3.34240000E-04  +3.24562000E-03  -3.60540000E-03
   +1.62568000E-03  -4.99545000E-03  -4.16246000E-03  -3.30509100E-02  -4.97228000E-03
   -8.05800600E-02  -7.96309600E-02  +2.20561000E-03  +9.12197000E-03  +2.22772600E-02
   -8.07300000E-05  +3.22580000E-04  -2.06630000E-04  -3.52900000E-05  -1.01586000E-03
   -2.16958000E-03  -1.53823000E-03  +2.51688000E-03  +1.35373000E-03  -3.71900000E-05
   -1.14230000E-04  +2.56600000E-05  +6.21000000E-06  -3.50000000E-07  +1.85000000E-06
   -1.22500000E-05  -1.52000000E-06  +4.41000000E-06  +2.08600000E-05  +3.30000000E-06
   -6.70000000E-07  +7.72000000E-06  -1.00700000E-05  -6.55000000E-06  -7.87000000E-06
   -6.90000000E-07  +7.42000000E-06  +4.60000000E-06  -3.07000000E-05  -1.27800000E-05
   +2.67500000E-05  +2.80000000E-06  -8.98000000E-06  -3.06300000E-05  -1.99800000E-05
   -1.42000000E-06  +5.08000000E-06  +4.85000000E-06  +1.59800000E-05  -1.90000000E-06
   +8.48000000E-06  -1.42700000E-05  +5.03100000E-05  -7.73000000E-06  +4.80900000E-05
   -2.95160000E-04  +7.49870000E-04  -5.40970000E-04  +5.35695000E-03  +8.04949400E-02
   +8.34100000E-05  +2.95200000E-05  +1.01500000E-05  -1.76900000E-04  +1.38800000E-04
   -6.11900000E-05  -2.33000000E-06  +6.73000000E-06  -7.18500000E-05  +6.38000000E-06
   +3.94000000E-06  -2.77600000E-05  -8.34600000E-05  -1.14000000E-05  +4.20100000E-05
   +3.92800000E-05  -1.01500000E-05  -7.54000000E-06  +2.49790000E-04  -5.77090000E-04
   -3.55590000E-04  +1.07900000E-05  -5.57200000E-05  -6.62000000E-05  +1.05250000E-04
   +1.46200000E-05  -6.22100000E-05  -1.36658000E-03  +2.95691000E-03  -2.88360000E-04
   -1.05310000E-04  +2.21580000E-04  +6.35320000E-04  -1.00134000E-03  -7.86160000E-04
   +1.17236000E-03  -2.68127000E-03  +1.62260000E-04  -5.70701000E-03  -3.88666200E-02
   -8.23648500E-02  -3.15606740E-01  -7.67340000E-04  -7.53839000E-03  -1.38492600E-02
   +1.58900000E-05  -1.11140000E-04  -1.76440000E-04  +4.35100000E-05  -1.77220000E-04
   +7.21100000E-05  +1.40881000E-03  +4.40200000E-04  +5.19030000E-04  +3.98200000E-05
   +1.43190000E-04  -7.64000000E-05  -1.71300000E-05  -2.16000000E-06  -1.11000000E-06
   +2.22500000E-05  +3.01000000E-06  -9.08000000E-06  -4.29500000E-05  -1.35500000E-05
   -6.75000000E-06  -7.01000000E-06  +2.94000000E-06  +1.44200000E-05  +9.06000000E-06
   -2.04000000E-06  -8.72000000E-06  -1.03500000E-05  +4.39500000E-05  +2.00000000E-08
   -6.93000000E-06  -1.11300000E-05  +7.33000000E-06  +1.07500000E-05  +9.78000000E-06
   +3.34000000E-06  +2.59000000E-06  -1.01400000E-05  +3.69000000E-06  +8.89000000E-06
   -1.16400000E-05  +1.63900000E-05  -6.11900000E-05  +1.80700000E-05  -5.37300000E-05
   +2.55930000E-04  +3.98230000E-04  +6.92340000E-04  +4.29293700E-02  +8.70508800E-02
   +3.33528550E-01  -2.41500000E-05  +2.25400000E-05  -6.52000000E-05  +6.08800000E-05
   -5.85800000E-05  +3.76200000E-05  -1.34200000E-05  -8.80000000E-07  -1.22700000E-05
   +6.97400000E-05  -3.05800000E-05  -1.17700000E-05  +5.66900000E-05  +9.05000000E-06
   -1.67700000E-05  -3.91300000E-05  +2.50000000E-07  +4.36500000E-05  -2.30440000E-04
   -1.34750000E-04  -2.74660000E-04  +2.91200000E-05  -3.41700000E-05  +1.38300000E-04
   -3.51500000E-05  -1.46900000E-05  +3.64200000E-05  +1.88570000E-04  -1.47451000E-03
   -4.34940000E-04  -1.29988200E-02  -4.49859000E-03  -2.33784000E-03  -2.59518300E-01
   -4.57439500E-02  -7.31123000E-03  -8.47269000E-03  -6.89156000E-03  -6.39688000E-03
   +3.67820000E-04  +3.67598000E-03  -2.60049000E-03  +6.59940000E-04  -1.06631000E-03
   +2.84298000E-03  +3.88737000E-03  +1.90756000E-03  -4.47420000E-04  -1.90464300E-02
   +1.55065600E-02  +4.79882000E-03  +3.53760000E-04  -4.54870000E-04  +3.18330000E-04
   -1.51770000E-04  -4.36500000E-05  -2.90000000E-05  +9.68000000E-06  +1.23700000E-05
   -9.39000000E-06  +4.17000000E-06  +1.77400000E-05  -1.80000000E-06  +3.29500000E-05
   +5.87600000E-05  +6.30000000E-06  +1.12400000E-05  -1.03300000E-05  +2.94200000E-05
   -4.65000000E-06  -2.27000000E-06  +5.92000000E-06  +1.78700000E-05  -5.09000000E-05
   -3.93000000E-06  +9.96000000E-06  -6.86000000E-06  -2.88900000E-05  +1.33700000E-05
   +3.19500000E-05  +1.60200000E-05  -1.84200000E-05  +2.59400000E-05  +1.26420000E-04
   +1.07800000E-04  -1.06230000E-04  -4.47100000E-05  +8.54600000E-05  +7.39300000E-05
   +1.68100000E-05  -7.94700000E-05  -1.02440000E-04  +5.18500000E-05  +3.05100000E-04
   -1.35020000E-04  -1.42260000E-04  +2.95762220E-01  +1.89200000E-05  +3.15700000E-05
   -1.07780000E-04  +1.38000000E-06  -7.22000000E-05  +5.90300000E-05  -7.56000000E-06
   -9.07800000E-05  -1.05000000E-05  +8.68300000E-05  -3.28800000E-05  -4.21200000E-05
   +1.07030000E-04  +2.34100000E-05  -2.42000000E-05  -6.68900000E-05  +2.38000000E-06
   +3.84700000E-05  -1.71520000E-04  -9.34300000E-05  +1.44600000E-05  +9.63000000E-06
   +3.00000000E-06  +3.30700000E-05  -7.49200000E-05  -8.17000000E-06  +5.47600000E-05
   +1.48909000E-03  +2.35346000E-03  +5.63500000E-04  -2.78316800E-02  -5.11771000E-03
   +9.19190000E-04  -4.98066400E-02  -5.47434600E-02  +3.55670000E-04  -6.72585000E-03
   -4.38440000E-04  -1.54026000E-03  -3.98350000E-04  -1.50774000E-03  -1.52555000E-03
   -1.08350000E-04  +1.17775000E-03  -1.75062000E-03  +1.23143000E-03  +1.49592000E-03
   -2.77069000E-03  +4.09644800E-02  -8.49085000E-03  -3.02647000E-03  -4.21880000E-04
   -8.89600000E-05  +2.18850000E-04  -7.70000000E-05  -2.54600000E-05  -1.33800000E-05
   +1.70800000E-05  +8.80000000E-07  -9.73000000E-06  -1.22000000E-06  +7.82000000E-06
   -4.03000000E-06  -6.43000000E-06  +6.27100000E-05  +5.02700000E-05  +8.34000000E-06
   -1.29000000E-06  +1.86500000E-05  -5.00000000E-08  -7.50000000E-06  +4.90000000E-06
   -6.86000000E-06  -8.77000000E-06  -1.04900000E-05  +1.23600000E-05  -8.61000000E-06
   -1.96500000E-05  +1.42000000E-06  -1.82000000E-06  +3.80000000E-07  -1.01500000E-05
   +3.28700000E-05  +2.89600000E-05  +2.73500000E-05  -3.53600000E-05  -1.97400000E-05
   +1.59300000E-05  +2.23900000E-05  +2.35300000E-05  -8.20000000E-07  -2.80900000E-05
   -5.49800000E-05  +2.96950000E-04  +8.68300000E-05  +3.72600000E-05  +4.06271300E-02
   +6.79724900E-02  -5.59100000E-05  -2.69100000E-05  +1.09480000E-04  +1.00010000E-04
   +2.42900000E-05  -4.79200000E-05  -8.64000000E-06  +1.10060000E-04  -6.35600000E-05
   -6.79000000E-05  +2.71000000E-05  +9.52600000E-05  -9.63000000E-06  -1.62600000E-05
   -5.44900000E-05  +3.37700000E-05  +1.20900000E-05  -1.22700000E-05  +2.54060000E-04
   +4.28950000E-04  +2.70500000E-05  -3.90000000E-05  +3.71200000E-05  +8.28000000E-06
   -4.09400000E-05  +2.19000000E-06  +3.20000000E-05  +4.17240000E-04  -8.97300000E-04
   +2.95280000E-04  +2.16485500E-02  +6.72613000E-03  -1.31794000E-03  -1.47579000E-02
   -2.38040000E-04  -5.20259000E-02  -3.13957700E-02  -9.83980000E-03  -4.14726000E-03
   +1.94770000E-04  -1.26354000E-03  -2.71150000E-03  -1.78177000E-03  +1.10333000E-03
   -7.20040000E-04  +1.41186000E-03  -1.55860000E-04  +3.03697000E-03  +1.06775700E-02
   -2.50083000E-03  +3.99603000E-03  +2.41884000E-03  -4.88700000E-05  +1.96000000E-04
   +1.26300000E-05  -2.20400000E-04  +1.79190000E-04  +5.36000000E-06  -6.89000000E-06
   -1.46000000E-06  -7.28000000E-06  -9.19000000E-06  -1.56000000E-06  +4.40400000E-05
   -1.54400000E-05  -4.86700000E-05  +1.94000000E-06  -5.31000000E-06  -1.69200000E-05
   -3.61000000E-06  +9.80000000E-07  +5.89000000E-06  +7.86000000E-06  -7.52000000E-06
   +3.52200000E-05  -2.48400000E-05  +1.51400000E-05  +6.45000000E-06  +1.39900000E-05
   +1.45600000E-05  -1.72000000E-05  +8.39000000E-06  -4.08000000E-06  -1.26100000E-05
   -5.22800000E-05  +1.40000000E-07  -7.72000000E-06  +6.66200000E-05  -2.27600000E-05
   +6.85300000E-05  +8.10800000E-05  -1.47900000E-05  +6.31500000E-05  +1.87582000E-03
   +1.63080000E-04  -3.48630000E-04  +8.74822000E-03  +3.38980000E-03  +5.64787200E-02
   +1.71900000E-04  +4.61200000E-05  -6.61730000E-04  +4.54000000E-05  -5.47810000E-04
   +4.01050000E-04  -1.88590000E-04  -7.47530000E-04  +3.29170000E-04  +2.67550000E-04
   -8.79800000E-05  -3.77830000E-04  +3.90620000E-04  +8.01700000E-05  +2.87070000E-04
   -4.46950000E-04  -1.56200000E-05  +1.41040000E-04  -3.75580000E-04  -1.55100000E-05
   +7.84370000E-04  +3.29100000E-05  +1.02610000E-04  -4.94200000E-05  -1.41170000E-04
   -2.07500000E-05  +5.54500000E-05  -1.11401700E-02  +6.88943000E-03  +7.23723000E-03
   -2.92989520E-01  -2.10025300E-02  +1.82065300E-02  -1.08565500E-02  -6.77600000E-04
   +2.66736000E-03  -7.01520000E-04  +1.62571000E-03  +1.09153000E-03  +7.72670000E-04
   -3.14939000E-03  +1.26186000E-03  -3.00480000E-04  +2.49756000E-03  -4.31217000E-03
   -1.31670900E-02  -3.70762000E-03  -7.21912000E-03  +2.76674000E-03  +8.43330000E-04
   -1.47555000E-03  +3.13140000E-04  -8.01970000E-04  +4.78240000E-04  -2.66000000E-06
   -1.58570000E-04  -1.47150000E-04  +2.47900000E-05  +7.92000000E-06  -1.01400000E-05
   -3.42000000E-06  +1.31200000E-05  -8.00000000E-06  +1.82700000E-05  +5.84000000E-05
   -6.71000000E-06  +2.13900000E-05  -1.20800000E-05  +4.41100000E-05  -6.41000000E-06
   -9.10000000E-06  +1.69000000E-06  +2.76000000E-06  +7.18600000E-05  -2.38900000E-05
   +6.79900000E-05  -4.24800000E-05  -6.61500000E-05  -3.26800000E-05  -4.98000000E-06
   +9.76000000E-06  +2.71500000E-05  -2.06000000E-05  +9.95700000E-05  +7.21100000E-05
   -1.04300000E-05  -1.10900000E-05  -1.02700000E-05  +8.00900000E-05  +1.61500000E-05
   +3.42450000E-04  +1.89730000E-04  +1.39840000E-04  -1.78000000E-06  -5.83900000E-05
   +3.67100000E-05  +4.56090000E-04  -8.31550000E-04  +8.48160000E-04  +3.23955750E-01
   -1.37230000E-04  +1.10000000E-07  +6.40100000E-05  +2.15720000E-04  -6.71390000E-04
   +6.01340000E-04  -2.17660000E-04  -7.43000000E-04  +7.96880000E-04  -2.52280000E-04
   +4.85800000E-05  -3.16900000E-05  -2.31910000E-04  -8.55000000E-05  +1.61360000E-04
   +3.77300000E-05  -1.55000000E-06  -9.47300000E-05  +7.75200000E-05  -4.36300000E-05
   -1.11266000E-03  -2.84670000E-04  -2.29790000E-04  +1.69010000E-04  +2.26620000E-04
   +2.09700000E-05  -1.93890000E-04  +2.84223000E-02  -1.15419000E-03  -6.31559000E-03
   -8.63975000E-03  -4.87078400E-02  +3.08550000E-03  -2.40357500E-02  -3.65880000E-03
   +4.41944000E-03  +8.88700000E-05  -9.01370000E-04  -6.66160000E-04  +1.03283000E-03
   +9.31400000E-04  +8.04860000E-04  +1.17767000E-03  -2.62541000E-03  +5.94790000E-04
   -1.33848400E-02  -3.96270000E-04  -3.79522000E-03  +5.78100000E-04  +2.67625000E-03
   -8.73070000E-04  -3.29770000E-04  +1.05846000E-03  -3.47580000E-04  -1.33160000E-04
   +3.42000000E-04  -2.33260000E-04  -5.81400000E-05  +6.00000000E-08  +3.35500000E-05
   +2.41200000E-05  +3.20000000E-05  +1.08600000E-05  +8.70000000E-07  -5.60640000E-04
   -4.82970000E-04  -1.75700000E-05  -4.49000000E-06  -5.92200000E-05  -8.73000000E-06
   +1.76000000E-06  -1.17700000E-05  -5.12800000E-05  -6.69200000E-05  +9.02500000E-05
   -1.31150000E-04  +1.57080000E-04  +6.53500000E-05  +8.87600000E-05  -1.50900000E-05
   -3.20300000E-05  +3.57100000E-05  +1.96300000E-05  +9.16400000E-05  -7.43800000E-05
   -2.99500000E-05  +8.55000000E-06  -4.19400000E-05  +3.44000000E-06  +3.75000000E-06
   -1.92922000E-03  -5.20450000E-04  -6.05500000E-05  -1.72770000E-04  +5.16500000E-05
   -1.16300000E-05  -1.03584000E-03  -2.78214000E-03  +2.98669000E-03  +2.11022300E-02
   +5.85648000E-02  -4.78700000E-05  -2.94900000E-05  +3.96900000E-05  -2.26110000E-04
   +4.75400000E-04  -2.22640000E-04  +9.12300000E-05  +4.99740000E-04  +1.56120000E-04
   +7.20200000E-05  -6.15600000E-05  -6.48500000E-05  +3.27400000E-05  -1.47000000E-06
   -9.59500000E-05  +4.12200000E-05  -2.00000000E-07  -2.65100000E-05  +1.93580000E-04
   -1.01200000E-04  -2.60480000E-04  +1.34640000E-04  -1.04900000E-05  -1.57500000E-05
   -1.36200000E-05  -1.16900000E-05  +9.75000000E-06  +6.79534000E-03  -2.45210000E-03
   -5.63650000E-04  +3.15994700E-02  +6.90153000E-03  -4.65570600E-02  +2.59173400E-02
   +3.41310000E-03  -1.85706000E-03  -1.36800000E-03  -2.95260000E-04  +1.89376000E-03
   -7.63160000E-04  -6.14710000E-04  +8.57530000E-04  +1.34160000E-03  -1.55614000E-03
   +1.72330000E-04  -4.16370900E-02  -7.74065000E-03  -9.71561000E-03  -1.89867000E-03
   -2.58041000E-03  +1.44827000E-03  +2.39060000E-04  +2.34310000E-04  -2.19920000E-04
   +1.08000000E-04  +1.17600000E-05  -1.56850000E-04  +9.22000000E-06  +1.37700000E-05
   +7.90000000E-07  -5.97000000E-06  +7.44000000E-06  +1.46200000E-05  -1.95300000E-05
   -1.51950000E-04  -9.79000000E-05  +7.98000000E-06  -2.80400000E-05  +2.68900000E-05
   +3.80000000E-07  +7.50000000E-07  +7.70000000E-07  -3.17600000E-05  -2.07000000E-06
   +4.18500000E-05  -3.78600000E-05  +2.21600000E-05  +6.08000000E-06  +4.09200000E-05
   +5.00100000E-05  +3.02000000E-05  +5.52700000E-05  -8.30300000E-05  +1.96760000E-04
   -1.23600000E-05  -1.61100000E-05  -2.00700000E-05  -1.73000000E-05  +9.61200000E-05
   +4.85600000E-05  -3.46090000E-04  +1.36200000E-05  +1.25930000E-04  +2.91000000E-05
   -8.74000000E-06  -6.09700000E-05  +1.17766000E-03  +3.88781000E-03  -2.52256000E-03
   -1.83945500E-02  +2.59981000E-03  +6.30703100E-02  -8.39000000E-06  -5.80000000E-07
   +8.50000000E-07  +5.41000000E-06  +3.28000000E-06  -1.16000000E-05  +2.51900000E-05
   +6.83000000E-06  +1.46200000E-05  -5.65000000E-06  +1.17700000E-05  +1.37800000E-05
   +3.54300000E-05  +6.11000000E-06  -1.82000000E-05  -5.48000000E-06  -4.95000000E-06
   -1.28000000E-05  -1.73020000E-04  -1.59250000E-04  -2.76200000E-05  +4.54000000E-06
   -2.51700000E-05  +1.68000000E-06  -4.69500000E-05  +3.27000000E-06  +2.01000000E-05
   -3.06900000E-04  +3.58170000E-04  -3.51600000E-05  +2.86970000E-04  +9.09130000E-04
   +9.50700000E-05  -3.54730000E-04  +1.01649000E-03  -1.56500000E-04  -5.77289000E-03
   +1.15598100E-02  +6.01658000E-03  +1.62412000E-03  +1.43930000E-03  -1.34096000E-03
   +2.40112000E-03  +4.17400000E-05  -1.93920000E-04  -3.49000000E-05  -4.02270000E-04
   +7.05980000E-04  -1.23043000E-03  -4.16800000E-04  +6.44290000E-04  -2.98858100E-02
   +8.19435700E-02  +4.02475100E-02  +6.64000000E-06  +1.06670000E-04  -5.16800000E-05
   +1.01600000E-05  -1.11400000E-05  +4.88000000E-06  -1.30900000E-05  -1.51700000E-05
   +3.39000000E-06  +1.11900000E-05  -9.47000000E-06  -6.49000000E-06  -5.24000000E-06
   +6.82000000E-06  -1.02800000E-05  +3.30000000E-07  -1.80000000E-07  -8.80000000E-07
   -5.52000000E-06  -9.30000000E-07  +1.31000000E-06  -1.16700000E-05  +3.14000000E-06
   +7.33000000E-06  -1.65000000E-06  -8.50000000E-06  -7.65000000E-06  -6.87000000E-06
   -7.44000000E-06  -3.44800000E-05  +1.85000000E-06  +1.39100000E-05  +1.17900000E-05
   -3.28600000E-05  -2.64200000E-05  -3.86000000E-05  -8.05100000E-05  -9.07000000E-05
   +3.60000000E-05  -7.71660000E-04  -1.91800000E-04  +6.79400000E-05  -3.80390000E-04
   +2.40700000E-04  -5.94260000E-04  -9.23600000E-05  -2.02780000E-04  +1.47270000E-04
   +3.58360500E-02  +4.42000000E-05  +1.85700000E-05  +4.19900000E-05  -1.51800000E-04
   +1.22440000E-04  -3.55600000E-05  +3.40300000E-05  +1.72500000E-05  +2.30500000E-05
   -2.69200000E-05  +9.93000000E-06  -8.14300000E-05  -2.12580000E-04  -2.81300000E-05
   +1.24820000E-04  +9.31300000E-05  -5.33000000E-06  -1.84600000E-05  -3.91400000E-05
   -3.80850000E-04  +1.30930000E-04  +2.43200000E-05  -2.43000000E-06  -7.98100000E-05
   +2.41600000E-04  +2.35300000E-05  -1.69390000E-04  -4.06380000E-04  +3.59000000E-06
   -4.59450000E-04  +1.58060000E-04  -7.94890000E-04  +2.45880000E-04  +5.51620000E-04
   +1.76594000E-03  -2.55350000E-04  +9.36806000E-03  -4.42737600E-02  -1.25946200E-02
   +1.24728000E-03  +2.23645000E-03  +4.73424000E-03  +8.46240000E-04  -1.77374000E-03
   -7.04200000E-05  -9.24200000E-05  +1.76300000E-05  -1.17805000E-03  -5.44810000E-04
   -1.17141000E-03  -6.74310000E-04  +8.48388800E-02  -3.36985130E-01  -1.87947060E-01
   +1.33200000E-05  +2.33890000E-04  -1.21220000E-04  -4.61100000E-05  +1.39000000E-06
   +2.02200000E-05  +2.18300000E-05  +3.04000000E-06  +6.34000000E-06  -6.01100000E-05
   -5.16100000E-05  -1.09300000E-05  -1.36800000E-05  +3.60000000E-07  +1.59000000E-05
   +7.72000000E-06  +1.65000000E-06  -1.88900000E-05  -1.60000000E-05  +4.98300000E-05
   -2.16300000E-05  +8.98000000E-06  -2.58400000E-05  +8.71000000E-06  -1.10000000E-07
   -1.59700000E-05  +1.79100000E-05  +1.96700000E-05  -3.03800000E-05  +6.79000000E-06
   +5.47500000E-05  -5.83000000E-06  +2.95100000E-05  -7.81300000E-05  +3.09500000E-05
   -1.00340000E-04  +1.29600000E-05  -1.14460000E-04  +2.47020000E-04  -1.20320000E-04
   +2.48550000E-04  -6.49000000E-06  +1.27440000E-04  -1.08890000E-04  -4.03200000E-05
   +8.20900000E-05  -6.74100000E-05  -4.66700000E-05  -9.57345400E-02  +3.81135180E-01
   +3.52300000E-05  -4.04000000E-06  -1.57100000E-05  -1.09190000E-04  +9.17000000E-05
   -6.41200000E-05  +4.96800000E-05  -4.09000000E-05  +2.58400000E-05  +1.21400000E-05
   -2.88100000E-05  -7.74000000E-06  +1.86200000E-05  +2.12400000E-05  -3.52000000E-05
   +2.59100000E-05  -3.19700000E-05  -3.41700000E-05  +8.60800000E-05  -3.93030000E-04
   -1.69080000E-04  +1.28000000E-05  -5.27700000E-05  +2.80900000E-05  -9.30000000E-06
   -2.54500000E-05  +4.31000000E-06  -6.09190000E-04  -1.03620000E-04  -1.13350000E-04
   +5.64850000E-04  +4.32930000E-04  +1.73310000E-04  -4.37576000E-03  +7.76325000E-03
   -1.72428000E-03  -5.57745000E-03  +2.63693100E-02  +1.80520100E-02  -2.07505000E-03
   +5.77103000E-03  -4.60164000E-03  +4.98920000E-04  -2.12180000E-04  +1.53310000E-03
   +2.26180000E-04  -1.27487000E-03  +3.33600000E-05  -4.34850000E-04  +8.03500000E-05
   -1.08720000E-04  +5.53738200E-02  -2.34788580E-01  -1.96557120E-01  +7.31000000E-06
   +2.15720000E-04  -3.66800000E-05  +9.21000000E-06  +2.21000000E-05  -3.06000000E-06
   +1.39000000E-06  +1.81000000E-05  +3.20000000E-06  -3.05600000E-05  +8.74000000E-06
   +1.44100000E-05  -1.18700000E-05  +2.71200000E-05  -2.54000000E-06  +5.21000000E-06
   +1.10000000E-05  -6.18000000E-06  +8.80000000E-07  -1.25300000E-05  -2.81200000E-05
   +3.19600000E-05  -1.07000000E-05  -5.24000000E-06  -2.21700000E-05  -1.64300000E-05
   +3.48000000E-06  -3.01300000E-05  -1.94600000E-05  -8.08900000E-05  +3.73300000E-05
   +1.32000000E-05  +1.43100000E-05  -5.92100000E-05  -3.85900000E-05  -8.21400000E-05
   -6.72200000E-05  +2.25810000E-04  -2.66440000E-04  -1.44440000E-04  -1.37640000E-04
   -4.54000000E-05  +8.05200000E-04  -6.07190000E-04  +1.82800000E-05  +1.76260000E-04
   -4.60400000E-05  -7.06300000E-05  -4.53819300E-02  +1.98562910E-01  +1.84346370E-01
   +6.16300000E-05  +5.78800000E-05  +4.08900000E-05  -1.17300000E-04  -1.81800000E-05
   -7.23000000E-05  -9.78300000E-05  +6.10600000E-05  +2.81600000E-05  +2.68900000E-05
   -3.70000000E-07  -7.75400000E-05  -2.85700000E-05  -1.77600000E-05  +7.13700000E-05
   -3.58400000E-05  +1.55300000E-05  +1.02800000E-05  +4.85120000E-04  -8.18630000E-04
   +4.65800000E-05  -1.42520000E-04  +4.50200000E-05  -1.42620000E-04  +6.96700000E-05
   +1.48000000E-05  -5.32600000E-05  +1.72150000E-03  -1.34504000E-03  +6.83660000E-04
   -1.55878100E-02  -2.66080000E-04  +8.52900000E-04  +3.23964000E-03  +1.22530000E-03
   +1.41233000E-03  -1.92750000E-04  -1.17747000E-03  +2.18400000E-05  -1.14940000E-04
   +3.81730000E-04  +1.36390000E-04  -3.82500000E-05  +3.35170000E-04  +6.55200000E-04
   -5.29354890E-01  -2.37808100E-02  -2.09056300E-02  -3.97230000E-04  +2.59260000E-04
   +6.87710000E-04  +2.07830000E-04  +1.42580000E-04  +4.71720000E-04  -7.40340000E-04
   +1.24304000E-03  -2.36010000E-04  -1.17000000E-05  -4.47000000E-06  +2.13000000E-06
   +5.03000000E-06  +1.72000000E-06  +8.80000000E-07  +4.37000000E-06  +9.36000000E-06
   -1.87700000E-05  +2.72700000E-05  -4.16500000E-05  -1.50900000E-05  +4.82000000E-06
   -5.80000000E-06  -3.93000000E-06  -1.71200000E-05  +6.50800000E-05  -6.51000000E-06
   -3.07000000E-06  +2.38400000E-05  +3.96100000E-05  -2.62300000E-05  -3.80300000E-05
   -4.62400000E-05  +4.36410000E-04  +1.26978000E-03  -7.18410000E-04  -1.79500000E-04
   +2.11800000E-04  +2.60640000E-04  -2.87270000E-04  +9.45500000E-05  -2.34100000E-05
   -2.26160000E-04  +1.65900000E-05  +2.77380000E-04  -1.16700000E-05  +3.17400000E-05
   +1.80800000E-05  -4.28970000E-04  +7.80150000E-04  -7.59940000E-04  +1.26852000E-03
   -1.15986000E-03  -3.09978000E-03  -5.94200000E-05  +7.04800000E-05  -1.38400000E-04
   +5.41296590E-01  -8.88500000E-05  -2.22600000E-05  -1.77950000E-04  -1.73450000E-04
   -1.73800000E-04  +3.81920000E-04  -3.66000000E-05  +4.81700000E-05  -2.20630000E-04
   +1.99980000E-04  -2.76800000E-05  -1.15450000E-04  -2.12050000E-04  -1.07200000E-05
   +2.08830000E-04  +1.02510000E-04  +1.65000000E-05  +1.41500000E-04  -1.27055000E-03
   -7.34960000E-04  -4.78090000E-04  +5.23680000E-04  +1.31100000E-05  +1.77350000E-04
   +3.50250000E-04  +2.05800000E-05  -2.09840000E-04  -6.72010000E-04  +7.89740000E-04
   +7.76510000E-04  -1.73519100E-02  -2.05529000E-03  -1.84761000E-03  +2.34942000E-03
   +9.41660000E-04  +3.69310000E-04  -4.28350000E-04  +1.43675000E-03  +4.60600000E-04
   +7.12000000E-06  -1.20654000E-03  -4.13800000E-04  -9.34000000E-05  +9.93700000E-04
   -8.37610000E-04  -6.34968000E-03  -9.41522000E-03  -1.41322500E-02  -6.49370000E-04
   -1.06875000E-03  +9.21500000E-05  +1.34080000E-04  -1.18424000E-03  +1.83760000E-04
   +1.88630000E-04  -1.73511000E-03  -2.15815000E-03  -5.18200000E-05  +1.42300000E-05
   +1.35800000E-05  +5.97800000E-05  +2.21800000E-05  -1.08800000E-05  -7.73000000E-06
   +4.75200000E-05  +5.86600000E-05  -7.71000000E-06  -8.03100000E-05  +2.54140000E-04
   +6.83000000E-06  +1.95200000E-05  -2.94000000E-05  -1.63400000E-05  -5.56400000E-05
   +1.36900000E-05  -1.85000000E-05  -4.12500000E-05  -6.76300000E-05  +8.88100000E-05
   +1.99110000E-04  +1.74700000E-04  +1.67392000E-03  -1.82145000E-03  +3.04105000E-03
   +1.11300000E-05  +2.38200000E-05  +1.14670000E-04  +9.19000000E-06  +1.06541000E-03
   +6.90200000E-04  +4.57400000E-05  +1.36200000E-05  +6.28000000E-05  +1.33440000E-04
   -1.02260000E-04  +2.05600000E-05  -7.03930000E-04  +1.29010000E-04  +1.86140000E-04
   -1.29085000E-03  -1.87150000E-04  -2.84622000E-03  +1.38730000E-04  +7.77200000E-05
   +3.46480000E-04  +2.17448200E-02  +1.37955700E-02  +2.23720000E-04  -4.36700000E-05
   +1.84520000E-04  -1.28690000E-04  +1.28360000E-04  -9.61600000E-05  +4.31300000E-05
   -1.93700000E-05  +1.33900000E-05  -1.15050000E-04  +4.98000000E-06  -3.73700000E-05
   -2.87000000E-06  -1.46000000E-05  +1.32100000E-05  +7.00000000E-08  -2.95600000E-05
   -9.11000000E-05  +3.74830000E-04  -8.77860000E-04  +2.34710000E-04  -2.91540000E-04
   +7.54900000E-05  -2.27780000E-04  -9.42000000E-06  +8.36000000E-06  -3.12700000E-05
   +6.93340000E-04  -9.64800000E-05  +1.91891000E-03  -4.50320400E-02  -3.30466000E-03
   -6.73023000E-03  -4.12540000E-03  +1.00070000E-04  +8.78020000E-04  +5.90040000E-04
   -1.17310000E-04  -3.34440000E-04  +3.48250000E-04  -3.17180000E-04  +4.94320000E-04
   +1.20110000E-04  +6.35130000E-04  -1.05596000E-03  +2.59927900E-02  -1.28431300E-02
   -3.87962000E-02  +1.11029000E-03  -4.28070000E-04  -2.59350000E-04  +1.38100000E-04
   -9.50000000E-06  +4.56260000E-04  -3.25220000E-04  +1.02580000E-03  +1.04245000E-03
   -1.62000000E-06  -8.16000000E-06  +3.93000000E-06  -8.52000000E-06  -8.01000000E-06
   -9.50000000E-07  -5.91600000E-05  +4.39000000E-06  -6.64000000E-06  -6.82000000E-05
   +1.48080000E-04  -1.05600000E-04  +2.50800000E-05  +1.48200000E-05  -1.73700000E-05
   +4.08000000E-06  +9.59900000E-05  -2.21800000E-05  +5.10300000E-05  -1.22500000E-05
   +2.30900000E-05  -5.57800000E-05  -1.25060000E-04  -7.67000000E-05  -8.76980000E-04
   +1.45846000E-03  -5.44490000E-04  +2.83480000E-04  -4.01360000E-04  -2.63810000E-04
   +9.53300000E-05  -2.25710000E-04  -3.37140000E-04  -1.21500000E-04  +2.48000000E-06
   +1.05710000E-04  -7.96400000E-05  +3.72100000E-05  +4.54800000E-05  +2.01870000E-03
   +8.28340000E-04  -6.83920000E-04  -1.46507000E-03  -1.79882000E-03  -5.66953000E-03
   -1.20290000E-04  +1.04710000E-04  -1.80200000E-04  +2.12209400E-02  +1.56781100E-02
   +5.00412600E-02  -8.19000000E-06  -2.03200000E-05  +2.77900000E-05  +3.73900000E-05
   -1.24200000E-05  -6.50800000E-05  +5.83800000E-05  +3.10700000E-05  -1.81200000E-05
   -7.27600000E-05  +5.11300000E-05  +6.92000000E-05  +6.10400000E-05  -1.24000000E-06
   -5.55700000E-05  -2.65000000E-06  +9.57000000E-06  -1.79400000E-05  +6.98300000E-05
   +1.75190000E-04  +6.66500000E-05  -4.19600000E-05  +9.94000000E-06  -1.15500000E-05
   -1.13690000E-04  +2.62000000E-05  +6.24200000E-05  -4.48460000E-04  -1.86810000E-04
   -4.03500000E-04  +2.69872000E-03  +1.36077000E-03  +1.16412000E-03  -2.27870000E-04
   +6.58777000E-03  +2.22347000E-02  -1.45103000E-03  +2.33537000E-03  -1.06983000E-03
   +2.49840000E-04  -4.24000000E-06  +4.83550000E-04  -1.29930000E-04  -1.20140000E-04
   +8.17300000E-05  -1.75816000E-03  -3.76686000E-03  +2.65900000E-04  -1.59618900E-02
   +1.04531300E-02  -4.79734800E-02  +6.21110000E-04  -7.16940000E-04  -5.13000000E-04
   +1.25000000E-05  +1.31000000E-05  +9.08600000E-05  +1.13800000E-05  -4.03600000E-05
   +4.04000000E-06  -2.37500000E-05  -3.78800000E-05  -3.75000000E-06  +2.50300000E-05
   -2.01500000E-05  -1.78100000E-05  -7.32000000E-06  +1.39900000E-05  -3.04700000E-05
   +2.14000000E-06  -8.97000000E-06  +5.27000000E-06  +7.34000000E-06  +1.14000000E-06
   +4.97000000E-06  -1.20100000E-05  +1.06400000E-05  +1.47800000E-05  -6.78000000E-06
   -1.36000000E-05  -1.89700000E-05  -2.05100000E-05  -3.89000000E-06  -8.48100000E-05
   -2.43100000E-05  +1.06300000E-05  +1.45400000E-05  +7.47000000E-06  -5.08500000E-05
   -1.32600000E-05  +8.67400000E-05  +1.13800000E-05  -1.92000000E-05  +1.49700000E-04
   +1.34120000E-04  -2.55200000E-05  -1.04759000E-03  +6.11520000E-04  +7.28870000E-04
   -5.61000000E-04  -5.78360000E-04  -1.14330000E-04  -9.62610000E-04  -3.23600000E-04
   +1.09773000E-03  -7.55880000E-04  +1.65505000E-03  -4.46290000E-04  +1.95397300E-02
   +1.06700000E-05  +3.17600000E-05  +7.44000000E-05  -3.35500000E-05  +1.15000000E-06
   +5.16900000E-05  -7.39300000E-05  +6.13700000E-05  -2.39700000E-05  -1.96300000E-05
   +3.11400000E-05  -1.01150000E-04  -2.72500000E-04  -5.92600000E-05  +2.17250000E-04
   +5.81800000E-05  +2.87100000E-05  +4.14600000E-05  -1.04720000E-04  +1.10880000E-04
   +2.88110000E-04  +1.88500000E-05  +8.19800000E-05  -1.35820000E-04  +3.12650000E-04
   +3.80900000E-05  -2.16320000E-04  +3.87090000E-04  +6.88800000E-05  -3.06880000E-04
   -9.96130000E-04  -2.93961000E-03  -3.66929000E-03  -4.04110000E-04  -1.13280800E-02
   -4.13094500E-02  +4.60370000E-03  -6.60781000E-03  +3.72040000E-04  -4.71980000E-04
   -2.81780000E-04  -2.09759000E-03  -1.92570000E-04  +9.83620000E-04  -3.19180000E-04
   -1.62277000E-03  +3.89286000E-03  -2.59060000E-04  +1.65012600E-02  -3.98806400E-02
   -4.11075900E-02  -1.30000000E-07  +9.21680000E-04  +2.34911000E-03  -1.12000000E-05
   -6.28100000E-05  -1.80980000E-04  -6.17200000E-05  -4.42000000E-06  +2.57100000E-05
   +2.74600000E-05  -4.72000000E-06  +2.74000000E-06  -2.43700000E-05  -4.62900000E-05
   -2.39200000E-05  +9.80000000E-07  -3.78500000E-05  +3.44700000E-05  +2.38000000E-06
   +2.70000000E-07  -1.78400000E-05  -1.62900000E-05  +6.27700000E-05  -5.00000000E-08
   -8.69000000E-06  -1.30600000E-05  +1.40800000E-05  +8.49000000E-06  +4.56000000E-06
   +1.97800000E-05  +1.36350000E-04  +2.36000000E-06  +1.92650000E-04  -1.58700000E-05
   +4.76000000E-06  +3.21100000E-05  -1.94900000E-05  +1.30890000E-04  +4.82300000E-05
   +1.52600000E-05  +3.11000000E-05  +1.51960000E-04  -2.36860000E-04  -5.50370000E-04
   -1.55000000E-06  +5.03710000E-04  +2.90060000E-04  +1.06320000E-04  -4.77010000E-04
   -4.55200000E-04  +4.10830000E-04  -5.01310000E-04  -1.61870000E-04  -2.13619000E-03
   +5.72900000E-04  +2.54720000E-04  +3.29980000E-04  -1.75950900E-02  +5.54001800E-02
   +2.62000000E-06  -4.27200000E-05  +3.99000000E-05  -1.23090000E-04  +3.33200000E-05
   -6.04000000E-06  +9.20600000E-05  +9.78000000E-06  +1.96000000E-05  -3.66400000E-05
   -7.13000000E-06  +3.02800000E-05  -1.21700000E-05  +1.43100000E-05  -3.61200000E-05
   +7.34700000E-05  -3.74400000E-05  -6.82100000E-05  -4.25100000E-05  +2.07200000E-04
   +3.34100000E-04  -4.01000000E-05  +8.05700000E-05  -1.40660000E-04  +2.74000000E-06
   -2.24200000E-05  -1.32600000E-05  -3.39800000E-04  -3.88300000E-05  -1.67885000E-03
   -2.71810000E-04  +3.53708000E-03  +3.57106000E-03  +4.74540000E-04  -4.38300000E-03
   -8.91264000E-03  +8.40530000E-04  -2.97180000E-04  -8.15670000E-04  +2.06500000E-05
   +5.59180000E-04  +6.72300000E-05  +3.61050000E-04  -5.71980000E-04  +2.67320000E-04
   +9.10110000E-04  -2.57407000E-03  -7.18740000E-04  -2.46469800E-02  -8.41935800E-02
   -5.17184400E-01  +1.68310000E-04  +1.19440000E-04  +6.54330000E-04  +4.79400000E-05
   +1.58210000E-04  +1.57510000E-04  +7.10000000E-06  +1.66400000E-05  +4.41000000E-06
   -4.97000000E-06  +3.40000000E-06  +4.35000000E-06  -2.43400000E-05  -2.21100000E-05
   -1.85000000E-05  -2.52500000E-05  +4.09500000E-05  -1.19200000E-05  +4.82000000E-06
   +2.18000000E-05  -1.22400000E-05  -1.36600000E-05  +6.01400000E-05  +6.97000000E-06
   +2.15200000E-05  -1.62100000E-05  -2.92000000E-06  -1.18300000E-05  -2.55900000E-05
   -4.01000000E-06  -7.20900000E-05  -5.57000000E-05  -1.23060000E-04  +4.00800000E-05
   -2.91900000E-05  -1.33500000E-05  -1.82300000E-05  -5.97300000E-05  -8.47800000E-05
   +6.52000000E-05  +2.16100000E-05  -4.78000000E-05  -1.82890000E-04  +5.13600000E-05
   +1.28420000E-04  -1.04919000E-03  +1.01050000E-03  +1.10380000E-04  -8.46000000E-05
   -4.20740000E-04  +5.77900000E-05  +2.92000000E-06  -3.90550000E-04  -1.14200000E-05
   -6.20850000E-04  +9.87700000E-05  +1.13140000E-04  +2.44853500E-02  +8.71439000E-02
   +5.24337790E-01
end_hess

