# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -424.20432070    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.59783719E+00  -2.30595011E+00  +4.67074503E-01
   006   +9.37561989E-03  -2.26877880E+00  +3.91378140E-01
   006   +1.35825653E+00  -4.32881890E-02  -5.31194770E-02
   006   -3.47376914E-02  +2.16690542E+00  -3.68917777E-01
   006   -2.65244689E+00  +2.15962719E+00  -3.05675075E-01
   006   -3.94737832E+00  -8.25060762E-02  +1.07029466E-01
   006   +4.15971631E+00  -3.21207404E-02  -1.71443822E-01
   006   +5.46129439E+00  -2.02818170E+00  -9.77134961E-01
   008   -6.50770671E+00  -2.11628061E-01  +2.00092615E-01
   006   +5.49167895E+00  +2.34547427E+00  +6.37316177E-01
   001   -7.21150479E+00  +1.43378422E+00  -5.85901327E-02
   001   -3.68524780E+00  +3.90801865E+00  -5.76610494E-01
   001   +9.22386044E-01  +3.94232918E+00  -6.98244042E-01
   001   +1.02918552E+00  -4.00834288E+00  +7.28224547E-01
   001   -3.61680316E+00  -4.03990468E+00  +8.28250680E-01
   001   +4.84070836E+00  +2.96680060E+00  +2.49303148E+00
   001   +7.52671072E+00  +2.05673145E+00  +7.12297061E-01
   001   +5.13031595E+00  +3.89061820E+00  -6.82514469E-01
   001   +4.54073653E+00  -3.72298352E+00  -1.65466696E+00
   001   +7.50574907E+00  -2.01081162E+00  -1.01035954E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -4.34000000E-06  +4.09000000E-06  -7.07000000E-06
   -6.31000000E-06  +1.26000000E-06  -1.76000000E-06
   -6.33000000E-06  -3.66900000E-05  +2.17300000E-05
   -1.44000000E-06  +1.11900000E-05  +2.73000000E-06
   +8.89000000E-06  +4.49000000E-06  -5.40000000E-07
   -4.59000000E-06  -9.81000000E-06  +2.50000000E-07
   +3.90400000E-05  -3.72300000E-05  -3.68400000E-05
   -1.73200000E-05  +2.30700000E-05  +5.27000000E-06
   +3.66000000E-06  +2.00000000E-07  +3.80000000E-07
   +6.66000000E-06  +6.78000000E-06  +2.19000000E-06
   +1.50000000E-06  -1.55000000E-06  +1.04000000E-06
   -1.45000000E-06  +9.10000000E-07  +1.22000000E-06
   -8.60000000E-07  +7.59000000E-06  -9.80000000E-07
   +1.21600000E-05  +1.99000000E-06  -7.90000000E-07
   -1.90000000E-07  -2.54000000E-06  -8.40000000E-07
   -8.94000000E-06  +2.10000000E-06  -2.24000000E-06
   -3.55000000E-06  +3.27000000E-06  -3.20000000E-07
   -5.20000000E-07  +9.38000000E-06  +5.37000000E-06
   -2.09000000E-06  +1.19000000E-05  +3.18000000E-06
   -1.39800000E-05  -4.20000000E-07  +8.03000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.33082900E-01  +3.29417200E-02  +7.09181920E-01  -2.38854100E-02  -1.08329830E-01
   +1.51236750E-01  -3.63189730E-01  -3.89068700E-02  +1.52287700E-02  +7.17345140E-01
   +3.13604400E-02  -1.31711050E-01  +1.25980500E-02  -3.94464800E-02  +6.93683590E-01
   +3.99177000E-03  +1.36477300E-02  -6.35821100E-02  -7.87506000E-03  -1.06552070E-01
   +1.66397860E-01  -2.81217500E-02  -2.67614400E-02  +6.93615000E-03  -1.69970290E-01
   -1.07394250E-01  +2.50499300E-02  +6.56023590E-01  -7.95516600E-02  +3.78574100E-02
   -4.07002000E-03  -4.32722400E-02  -2.59691050E-01  +3.81702500E-02  -7.02242000E-03
   +6.64090680E-01  +1.35261200E-02  -2.93598000E-03  +8.16311000E-03  +1.31857300E-02
   +3.68648600E-02  -7.80668200E-02  -1.81222300E-02  -6.89832900E-02  +1.75208080E-01
   -5.66883500E-02  +3.03049700E-02  -4.22225000E-03  +6.82931500E-02  +2.72566000E-02
   -5.52596000E-03  -1.79582460E-01  +5.03899900E-02  -5.60395000E-03  +7.04213420E-01
   +3.15320600E-02  -1.98562200E-02  +2.20360000E-03  -2.38046300E-02  -5.92132200E-02
   +1.20068600E-02  +1.14233400E-01  -2.67956660E-01  +2.70212400E-02  +2.89233600E-02
   +7.08401160E-01  -4.52203000E-03  +2.37831000E-03  -3.32442000E-03  +3.68965000E-03
   +1.21544100E-02  +6.19784000E-03  -1.94148300E-02  +2.90278600E-02  -7.32875900E-02
   -2.01067400E-02  -9.52676600E-02  +1.58490580E-01  +6.64443300E-02  -2.32070600E-02
   +2.44814000E-03  -5.50775800E-02  -3.30073700E-02  +6.45129000E-03  -3.04023000E-02
   +7.87157600E-02  -1.28245100E-02  -3.49222050E-01  -3.49736800E-02  +1.25333600E-02
   +7.14966330E-01  +2.46146400E-02  -5.00230200E-02  +9.63647000E-03  -2.88367600E-02
   -2.11188900E-02  +3.35808000E-03  +2.57950900E-02  +3.65125900E-02  -5.73789000E-03
   +3.50110400E-02  -1.27106110E-01  +1.08253600E-02  -3.16167700E-02  +7.07623830E-01
   -5.95751000E-03  +1.07352200E-02  +6.85376000E-03  +6.22252000E-03  +3.72574000E-03
   -4.23093000E-03  -2.61345000E-03  -7.83192000E-03  +9.67127000E-03  +6.28830000E-04
   +1.30400000E-02  -6.18363400E-02  -8.98837000E-03  -9.81786500E-02  +1.41916380E-01
   -1.62995810E-01  +1.13355640E-01  -1.74472400E-02  -3.11239100E-02  +2.89886700E-02
   -5.02026000E-03  +6.87887000E-03  +2.96522000E-03  -1.19690000E-04  -2.58147100E-02
   -3.23038600E-02  +6.57919000E-03  -1.68377680E-01  -1.12661580E-01  +2.17484800E-02
   +7.13597920E-01  +3.30661200E-02  -2.82319550E-01  +3.72274900E-02  +8.86395900E-02
   +4.67680300E-02  -8.91618000E-03  +1.57572000E-03  -8.48812900E-02  +1.31380800E-02
   -9.30131100E-02  +4.26149600E-02  -4.61570000E-03  -2.78810200E-02  -2.85813920E-01
   +3.70046000E-02  -1.14336800E-02  +7.06459710E-01  -2.32831000E-03  +3.40497900E-02
   -7.76429600E-02  -1.53604100E-02  -8.94848000E-03  +4.00270000E-03  -2.85900000E-05
   +1.38298500E-02  -8.29420000E-03  +1.67215300E-02  -6.35641000E-03  +2.90772000E-03
   +7.28355000E-03  +3.96900700E-02  -7.60149700E-02  -1.23655400E-02  -9.35254600E-02
   +1.80522030E-01  +5.16031000E-03  -2.87967000E-03  -5.64530000E-04  -2.69799600E-02
   -1.27577500E-02  +1.08447000E-03  -2.16589790E-01  -2.24393000E-03  +7.06041000E-03
   -2.48791700E-02  +1.16738300E-02  +2.81283000E-03  +4.53944000E-03  +2.73598000E-03
   -7.64970000E-04  -4.22946000E-03  +1.25890000E-04  -5.02390000E-04  +6.09329240E-01
   -3.00353000E-03  -4.41196000E-03  +2.97120000E-03  -2.72747000E-02  +7.21490000E-03
   +5.54610000E-04  -8.64164000E-03  -1.03653730E-01  -1.55088000E-03  +3.21761500E-02
   +4.34827000E-03  -2.76597000E-03  +1.81485000E-03  -4.90422000E-03  +1.77182000E-03
   +3.73850000E-04  -2.07689000E-03  +4.67030000E-04  -1.20118760E-01  +6.98906170E-01
   -6.43170000E-04  +1.62427000E-03  +6.05847000E-03  +7.13656000E-03  +1.24207000E-03
   +2.93247000E-03  +3.95527000E-03  -1.48086000E-03  -6.90950100E-02  -4.17452000E-03
   -9.46200000E-04  +1.98367000E-03  +6.56370000E-04  +2.35694000E-03  +6.26113000E-03
   -2.64570000E-04  -8.61180000E-04  -4.25110000E-04  -6.36185600E-02  +1.80616290E-01
   +2.48662290E-01  -4.81880000E-04  +7.41030000E-04  -9.19150000E-04  -1.83200000E-04
   +3.89582000E-03  +1.43310000E-03  -2.88229300E-02  +3.05618800E-02  +1.21949500E-02
   -2.63773000E-03  -4.57969000E-03  +5.19950000E-04  -2.46760000E-03  -1.83120000E-04
   -5.95460000E-04  +2.00447000E-03  +1.09759000E-03  -3.11660000E-04  -2.24009870E-01
   +1.77922970E-01  +7.37923800E-02  +7.11015790E-01  +1.37560000E-03  -6.06830000E-04
   -8.09460000E-04  -4.67491000E-03  -3.29573000E-03  -3.41570000E-04  +1.49762200E-02
   +4.98598000E-03  -1.32435000E-03  -3.67593000E-03  +1.85655000E-03  +5.91560000E-04
   +5.67860000E-04  +7.31000000E-04  -1.52210000E-04  -8.08250000E-04  +4.65950000E-04
   -1.23230000E-04  +1.69068760E-01  -3.77358560E-01  -1.26325570E-01  -7.32845800E-02
   +7.05978770E-01  -7.07170000E-04  -2.80650000E-04  -3.91000000E-05  +4.74830000E-04
   +2.02250000E-04  -3.60820000E-04  +4.64515000E-03  -2.93155000E-03  +6.93467000E-03
   -1.66780000E-03  +1.21052000E-03  +1.35623000E-03  +9.57460000E-04  +3.59020000E-04
   -2.32100000E-04  -1.08040000E-04  -8.70270000E-04  +2.21780000E-04  +7.21551100E-02
   -1.28869180E-01  -1.09363570E-01  -4.12055200E-02  +2.39526060E-01  +2.04491520E-01
   -4.45968900E-02  +1.19373700E-02  -5.68190000E-04  +5.28248000E-03  +1.62016000E-03
   -7.06500000E-05  -5.99390000E-03  -2.27008000E-03  -7.65050000E-04  +3.07009000E-03
   -1.89082000E-03  +2.19220000E-04  -4.36448400E-02  -5.94251000E-03  +2.60859000E-03
   -3.14352160E-01  -4.01530800E-02  +1.43152100E-02  +3.66422000E-03  +1.48350000E-04
   +6.60130000E-04  -2.48162000E-03  +3.26030000E-04  +2.12390000E-04  +5.06718310E-01
   +5.11485600E-02  +5.11624000E-03  -1.11616000E-03  -6.05596000E-03  -9.58548000E-03
   +2.66522000E-03  -1.27730000E-04  +7.26238000E-03  -1.43853000E-03  +6.99719000E-03
   -8.30325000E-03  +2.54383000E-03  -4.56222700E-02  +2.51381000E-03  +2.57317000E-03
   +1.18053300E-02  -1.09991550E-01  +1.09509300E-02  -7.23700000E-05  +3.99490000E-04
   -1.42110000E-04  -8.71100000E-05  -2.34200000E-05  +3.23700000E-05  -1.54813560E-01
   +5.69632140E-01  -7.55177000E-03  +1.95960000E-04  +7.57742000E-03  +1.11269000E-03
   +2.48042000E-03  +4.49975000E-03  -6.68000000E-05  -1.25259000E-03  -1.03589000E-03
   -9.60360000E-04  +2.60468000E-03  +7.16238000E-03  +8.99713000E-03  +1.25967000E-03
   +9.59057000E-03  +5.55773000E-03  +1.25742400E-02  -4.64626600E-02  +1.80720000E-04
   -2.68900000E-04  -7.28200000E-04  +1.55070000E-04  +1.05320000E-04  +2.36900000E-05
   +1.30977100E-02  -8.74652900E-02  +4.20276100E-02  -7.25620000E-04  -1.03011000E-03
   +9.64600000E-04  -4.04885000E-03  +2.37827000E-03  -1.13318000E-03  -1.80060700E-02
   -2.84713300E-02  -8.03312000E-03  -1.40427000E-03  -4.87740000E-04  -5.64630000E-04
   +2.36040000E-04  -8.15490000E-04  +2.10920000E-04  +4.30410000E-04  -2.91660000E-04
   -2.12800000E-05  -1.17641340E-01  -5.35645100E-02  -1.87981700E-02  +1.08070200E-02
   +1.18389600E-02  +3.91896000E-03  -6.74690000E-04  +2.38800000E-05  +4.85000000E-05
   +5.79780790E-01  +7.58000000E-06  +4.21690000E-04  +2.50800000E-05  +2.14889000E-03
   +2.66680000E-04  -7.95570000E-04  -6.36548000E-03  +2.64318000E-03  -1.54119000E-03
   +1.17220000E-03  +7.43200000E-05  +2.80360000E-04  -1.20850000E-04  -3.81390000E-04
   +3.31940000E-04  -2.10770000E-04  +1.38230000E-04  +8.58300000E-05  -4.53355200E-02
   -1.72939620E-01  -3.22734500E-02  -1.28820800E-02  -2.98735700E-02  -1.32633100E-02
   +3.80400000E-04  -6.52300000E-05  -8.25600000E-05  -3.69523400E-02  +5.07801360E-01
   +4.92680000E-04  -2.61540000E-04  -1.94310000E-04  +5.96820000E-04  +1.61020000E-04
   +7.53410000E-04  +7.71660000E-04  -3.68100000E-04  +2.86530000E-03  +7.09960000E-04
   -4.86990000E-04  +7.19200000E-05  +2.59680000E-04  +3.11990000E-04  -3.71260000E-04
   -8.90300000E-05  +7.73300000E-05  +2.21700000E-05  -1.99558200E-02  -3.30742400E-02
   -8.63751500E-02  -3.90754000E-03  -1.61214800E-02  +3.29720000E-03  +2.61390000E-04
   +2.75000000E-05  +2.19600000E-05  -1.48826700E-02  -7.34875000E-03  +5.40918470E-01
   -7.06721000E-03  -2.74146000E-03  +8.01550000E-04  +6.49160000E-04  +2.13416000E-03
   -4.08640000E-04  +4.58910000E-04  -8.60250000E-04  +2.31120000E-04  -9.12780000E-04
   +5.03000000E-04  -5.79900000E-05  +3.72774000E-03  +1.26178000E-03  -3.61600000E-04
   -2.58727000E-02  +4.72621500E-02  -7.38948000E-03  -3.22840000E-04  -1.38830000E-04
   -1.30600000E-05  +2.46890000E-04  -3.79900000E-05  -2.64100000E-05  -1.09425740E-01
   +1.38260090E-01  -2.04405800E-02  +7.59100000E-05  -1.62300000E-05  -1.98400000E-05
   +1.38978010E-01  -1.21282000E-03  +2.15478000E-03  +6.11700000E-05  +3.19030000E-04
   -1.69890000E-04  +3.29720000E-04  -4.43800000E-04  -5.41800000E-05  -5.94000000E-05
   +2.20120000E-04  -1.00328000E-03  +2.44700000E-05  -5.59074000E-03  +3.81700000E-03
   -6.58670000E-04  -1.69168000E-03  -2.25560000E-04  -3.35380000E-04  +3.24420000E-04
   -5.00300000E-05  +5.47000000E-05  -1.72600000E-04  +4.68700000E-05  +9.06000000E-06
   +1.91148400E-01  -4.61424620E-01  +7.19745100E-02  -3.82400000E-05  +2.88800000E-05
   +2.06200000E-05  -1.83326870E-01  +4.57552830E-01  +3.80170000E-04  +1.95930000E-04
   +2.26040000E-03  +2.35400000E-05  +2.74520000E-04  +1.61463000E-03  -1.54800000E-05
   +4.17600000E-05  +1.00890000E-04  +4.53000000E-06  +3.45900000E-05  -6.88820000E-04
   +8.09290000E-04  -8.56580000E-04  -8.60920000E-04  +9.29120000E-04  -1.77475000E-03
   -2.34522000E-03  +4.09800000E-05  -2.39100000E-05  -8.55400000E-05  +5.07700000E-05
   +5.00900000E-05  -3.36700000E-05  -2.93592300E-02  +7.34052500E-02  -1.55795200E-02
   -2.27700000E-05  -8.96000000E-06  +2.30200000E-05  +2.72688900E-02  -7.14269900E-02
   +1.58170300E-02  -6.20690000E-04  -3.25478000E-03  +7.35870000E-04  -1.06532000E-03
   -8.49020000E-04  +1.21280000E-04  -5.27233000E-03  -1.53264000E-03  +4.56820000E-04
   -1.07228400E-02  +2.92040600E-02  -4.69273000E-03  -1.27443680E-01  +1.16643440E-01
   -1.73837800E-02  +7.87138000E-03  -1.34488400E-02  +2.13272000E-03  +1.43080000E-04
   +1.56100000E-03  -1.76870000E-04  -5.70340000E-04  -1.29480000E-04  -6.95000000E-06
   +3.71603000E-03  -7.74000000E-04  -6.64500000E-05  +3.51000000E-06  +7.16800000E-05
   +2.75300000E-05  -4.90600000E-04  +8.98090000E-04  -1.21820000E-04  +1.33182940E-01
   -3.94615000E-03  -3.37403000E-03  +1.65797000E-03  -1.31019000E-03  +4.44800000E-05
   -1.55690000E-04  -6.65970000E-04  +2.33128000E-03  +8.46220000E-04  -1.84246000E-03
   +3.63802000E-03  -2.28310000E-04  +1.16820640E-01  -2.62632080E-01  +3.60295900E-02
   +1.95821500E-02  -1.79051400E-02  +3.21091000E-03  -2.05710000E-04  +4.25000000E-05
   +6.61000000E-05  +5.83100000E-05  -1.57000000E-06  -5.45000000E-06  +3.28000000E-06
   +2.55968000E-03  -1.11311000E-03  +5.26900000E-05  -1.42800000E-05  -2.19100000E-05
   -2.10915000E-03  -1.01487000E-03  +3.27770000E-04  -1.27592600E-01  +2.76670760E-01
   +6.75610000E-04  +1.61391000E-03  +5.24044000E-03  +1.56270000E-04  -2.35580000E-04
   -8.60160000E-04  +5.07820000E-04  +9.80830000E-04  +7.04115000E-03  +8.52850000E-04
   -8.51910000E-04  +2.26702000E-03  -1.74460200E-02  +3.59839000E-02  -3.85306200E-02
   -3.32621000E-03  +3.93511000E-03  +3.52528000E-03  +4.87800000E-05  +9.35100000E-05
   +4.56750000E-04  -3.45000000E-05  -5.73000000E-06  -1.32150000E-04  -2.40390000E-04
   -1.07477000E-03  -3.80184000E-03  -4.44100000E-05  -1.90200000E-05  +2.57800000E-05
   +3.84510000E-04  +2.39470000E-04  +5.16330000E-04  +1.89026300E-02  -3.98271800E-02
   +2.92550900E-02  -8.80390000E-04  +7.55240000E-04  -1.37930000E-04  -1.09111000E-03
   +3.39338000E-03  -3.68360000E-04  +1.23119400E-02  +1.32731200E-02  -2.48728000E-03
   -1.20749180E-01  -1.14065430E-01  +2.19190500E-02  -1.07164200E-02  -2.86383800E-02
   +5.49453000E-03  -4.92157000E-03  +1.44969000E-03  +8.16600000E-05  +5.30750000E-04
   -4.29900000E-05  -4.92700000E-05  +9.25000000E-06  -1.40040000E-04  -4.87700000E-05
   -1.35149000E-03  -1.48773000E-03  +2.36840000E-04  -1.30460000E-03  +7.56460000E-04
   -4.92560000E-04  +2.52350000E-04  -1.83980000E-04  +3.23300000E-05  +8.61270000E-04
   +2.46430000E-04  -1.88960000E-04  +1.28766240E-01  +9.47120000E-04  +2.79420000E-04
   -2.75380000E-04  +3.94730000E-03  -3.38105000E-03  +1.50022000E-03  -1.49935400E-02
   -1.73399800E-02  +4.13247000E-03  -1.13907600E-01  -2.73213890E-01  +4.29918300E-02
   +2.18086000E-03  +3.13627000E-03  +1.11330000E-04  +9.69400000E-04  +2.13517000E-03
   +9.20160000E-04  -1.78881000E-03  -3.93120000E-04  -8.65240000E-04  +3.49630000E-04
   +1.14530000E-04  -4.30100000E-05  -1.80220000E-04  -6.88000000E-06  -2.48900000E-05
   -7.02180000E-04  +7.94600000E-05  +2.93490000E-04  +5.31900000E-05  -2.84100000E-05
   +2.61000000E-06  -2.92280000E-04  +7.54560000E-04  -8.37120000E-04  +1.24263550E-01
   +2.87666660E-01  -4.31100000E-05  -2.25530000E-04  -1.15213000E-03  -4.40510000E-04
   +1.79188000E-03  +6.32522000E-03  +2.54949000E-03  +3.45508000E-03  +3.68116000E-03
   +2.16682100E-02  +4.31089000E-02  -4.64104000E-02  -1.03300000E-04  +6.96400000E-04
   +3.67146000E-03  +8.30800000E-05  +1.10325000E-03  +7.62427000E-03  -6.54000000E-05
   -6.07290000E-04  -3.67187000E-03  +3.82950000E-04  -3.36220000E-04  -6.19600000E-05
   +1.31700000E-05  -1.86000000E-06  -6.17400000E-05  -7.36400000E-05  -1.73880000E-04
   +4.12280000E-04  -1.95100000E-05  -2.24000000E-06  -2.38800000E-05  -7.84600000E-05
   -8.50630000E-04  -4.20290000E-03  -2.39129800E-02  -4.77724000E-02  +3.45473600E-02
   -1.13246300E-02  +2.81841900E-02  -4.83147000E-03  -1.28105730E-01  +1.19184210E-01
   -2.37946100E-02  +1.11336600E-02  -1.24564200E-02  +2.35265000E-03  -8.98100000E-04
   -3.20355000E-03  +7.01670000E-04  -8.53880000E-04  -7.43840000E-04  +7.98900000E-05
   -4.57056000E-03  -1.42822000E-03  +7.25290000E-04  +5.60440000E-04  -2.80570000E-04
   +1.36900000E-05  -1.13754000E-03  -3.81490000E-04  +5.44820000E-04  -9.32150000E-04
   +1.56894000E-03  -3.04270000E-04  +1.12860000E-04  +7.77900000E-05  -6.46900000E-05
   -4.20180000E-04  +1.61200000E-05  -3.10100000E-05  +1.48000000E-05  +7.56500000E-05
   -2.19200000E-05  +4.71030000E-04  -7.93280000E-04  +2.32520000E-04  +1.36217230E-01
   -2.37423000E-03  +4.00220000E-03  +6.03000000E-06  +1.18655440E-01  -2.63857350E-01
   +4.38164100E-02  +1.52352800E-02  -1.80272300E-02  +4.15050000E-03  -3.63369000E-03
   -3.56242000E-03  +1.96486000E-03  -9.98440000E-04  +2.64840000E-04  -2.00470000E-04
   -1.10560000E-03  +2.11767000E-03  +1.32199000E-03  +2.38454000E-03  -2.98700000E-04
   -1.21753000E-03  -9.45100000E-05  +6.26830000E-04  -3.43520000E-04  +1.50390000E-04
   +8.72000000E-06  +2.68900000E-05  -2.97060000E-04  +1.00850000E-04  -7.19100000E-05
   -7.91600000E-05  +3.87200000E-05  -3.25400000E-05  +1.05720000E-04  -5.19900000E-05
   -1.22890000E-04  +8.48530000E-04  -1.05661000E-03  +9.17300000E-05  -1.29228230E-01
   +2.78012100E-01  +1.42521000E-03  -8.65210000E-04  +4.64447000E-03  -2.33319900E-02
   +4.52085900E-02  -4.87210700E-02  -5.42490000E-03  +3.77566000E-03  +3.98236000E-03
   +1.27497000E-03  +1.50712000E-03  +5.75033000E-03  -7.36200000E-05  -3.08290000E-04
   -1.04856000E-03  +5.76640000E-04  +1.57238000E-03  +8.08294000E-03  +1.27550000E-03
   -1.61126000E-03  -3.73003000E-03  +6.90050000E-04  +1.53127000E-03  +5.84300000E-05
   +6.50900000E-05  -8.49200000E-05  -4.61000000E-06  -1.88000000E-04  -2.10170000E-04
   +1.34950000E-04  +2.92100000E-05  -4.43600000E-05  -2.30650000E-04  -3.63100000E-05
   -1.05280000E-04  -6.61040000E-04  -1.60590000E-04  +2.47490000E-04  +4.85300000E-05
   +2.32933800E-02  -4.88416400E-02  +3.66043800E-02  -1.27884090E-01  -1.19488890E-01
   +2.52998500E-02  -9.62695000E-03  -2.79873400E-02  +5.76598000E-03  -5.09435000E-03
   +1.31296000E-03  +3.61040000E-04  -9.52920000E-04  +8.01250000E-04  -1.66460000E-04
   -1.30967000E-03  +3.13372000E-03  -3.14360000E-04  +1.11452300E-02  +1.43101800E-02
   -2.92300000E-03  +9.43600000E-05  -1.42142000E-03  +7.05700000E-05  -9.67200000E-05
   +4.21900000E-05  -5.30400000E-05  +1.36157000E-03  -8.09820000E-04  +1.44300000E-05
   -3.90710000E-04  +1.77550000E-04  +3.70700000E-05  +1.09850000E-04  -2.27310000E-04
   +1.95300000E-05  +5.14410000E-04  +8.51250000E-04  -1.33210000E-04  +3.46200000E-05
   -1.03300000E-04  -1.18800000E-05  +8.92770000E-04  +2.60710000E-04  -2.22450000E-04
   +1.31272990E-01  -1.17866220E-01  -2.66879080E-01  +4.76631700E-02  +2.26781000E-03
   +4.61093000E-03  -4.49340000E-04  +8.35510000E-04  +2.11180000E-03  +1.00740000E-03
   +1.22403000E-03  +1.43670000E-04  -2.45420000E-04  +3.76856000E-03  -3.13564000E-03
   +1.46272000E-03  -1.78495700E-02  -1.81544900E-02  +5.01560000E-03  +1.80000000E-04
   +1.04150000E-04  +6.13100000E-05  -7.72000000E-05  -9.86000000E-06  +1.19000000E-05
   -5.25660000E-04  +1.78233000E-03  -9.62380000E-04  +2.57200000E-05  +2.15500000E-05
   +1.61800000E-05  -1.19140000E-04  +3.42520000E-04  -1.80410000E-04  -6.38000000E-04
   -1.01736000E-03  +1.52620000E-04  -7.29900000E-05  -4.00800000E-05  -1.28510000E-04
   -3.73590000E-04  +6.02810000E-04  -1.00711000E-03  +1.29210390E-01  +2.79536550E-01
   +2.46709700E-02  +4.82600100E-02  -4.57180800E-02  +3.47700000E-04  +7.26560000E-04
   +2.62934000E-03  -9.23300000E-05  +7.39440000E-04  +7.59773000E-03  -4.30310000E-04
   -1.12430000E-04  -9.65130000E-04  -2.70110000E-04  +1.49623000E-03  +5.17614000E-03
   +3.40916000E-03  +3.34868000E-03  +4.40347000E-03  +1.38740000E-04  -5.04000000E-06
   +3.82290000E-04  +2.77500000E-05  +2.45700000E-05  -9.36400000E-05  -2.50800000E-04
   -8.78730000E-04  -3.24016000E-03  +1.24570000E-04  +1.33700000E-05  -7.57400000E-05
   +1.57600000E-05  -1.79320000E-04  -5.03470000E-04  +1.07710000E-04  +1.52360000E-04
   -8.65200000E-05  -1.62600000E-05  -9.86100000E-05  -7.05390000E-04  -9.34900000E-05
   -1.11534000E-03  -4.54149000E-03  -2.77671000E-02  -5.23875300E-02  +3.57502000E-02
   +1.48890000E-04  -3.12600000E-05  +1.17300000E-05  +1.20760000E-04  +1.40900000E-05
   +1.89550000E-04  +2.98910000E-04  -2.70130000E-04  -5.70610000E-04  +1.86400000E-05
   -1.71270000E-04  +8.20000000E-07  -1.97000000E-04  +6.52500000E-05  +8.03000000E-05
   -8.72400000E-05  +1.18680000E-04  -1.60000000E-06  +5.33781000E-03  -2.89043000E-03
   -1.52060200E-02  -1.04694000E-03  -1.55670000E-03  +3.95900000E-05  +1.62440000E-04
   +7.32000000E-06  -1.34500000E-05  -7.69950100E-02  +2.38668300E-02  +7.69088600E-02
   -2.88800000E-05  +3.92000000E-06  -4.42000000E-06  +8.05000000E-06  -1.16500000E-05
   -1.31200000E-05  -8.95300000E-05  +1.18720000E-04  -3.42030000E-04  +4.25700000E-05
   +1.00700000E-05  -6.49600000E-05  +1.74500000E-05  +7.10000000E-07  -2.78300000E-05
   +7.80762800E-02  +2.87130000E-04  -1.36160000E-04  -7.81200000E-05  -3.41550000E-04
   -3.56000000E-04  +4.98000000E-04  +1.36919000E-03  +8.04340000E-04  +6.06410000E-04
   -3.52800000E-05  +4.33420000E-04  -1.44900000E-04  -2.41990000E-04  -8.81700000E-05
   -1.04000000E-06  -8.78700000E-05  +2.93050000E-04  -4.90000000E-05  +9.79718000E-03
   -1.05359600E-02  -2.67401500E-02  -3.04711000E-03  -2.99958000E-03  -8.61170000E-04
   +5.57200000E-05  -3.11000000E-05  +2.21900000E-05  +2.44110400E-02  -6.63790900E-02
   -7.05613500E-02  -1.00000000E-07  +9.86000000E-06  -2.30000000E-06  -6.29000000E-06
   -3.10000000E-06  -1.13300000E-05  -1.43910000E-04  -9.97400000E-05  +1.30100000E-04
   +2.77200000E-05  +3.28800000E-05  -3.64200000E-05  +1.60000000E-07  -1.51100000E-05
   -4.40400000E-05  -2.49144700E-02  +7.50446600E-02  +3.23590000E-04  -6.45300000E-05
   -6.95700000E-05  -6.04730000E-04  -3.20080000E-04  +1.66770000E-04  +8.92380000E-04
   +6.85000000E-05  +5.42930000E-04  +1.36800000E-05  -1.37420000E-04  +3.26710000E-04
   -3.07910000E-04  +6.82700000E-05  +1.28730000E-04  -5.32300000E-05  +2.72750000E-04
   -1.04230000E-04  +2.81006000E-03  -2.84328000E-03  -6.31222000E-03  -1.52974000E-03
   -7.51810000E-04  -8.78400000E-05  +1.84300000E-05  +9.95000000E-06  +1.00000000E-08
   +7.62923400E-02  -7.01493000E-02  -2.62217240E-01  -1.97900000E-05  -8.64000000E-06
   -3.42000000E-06  -2.06100000E-05  -7.58000000E-06  -4.52000000E-06  +6.69100000E-05
   +1.74800000E-04  -4.76030000E-04  +5.35000000E-05  +1.02470000E-04  +2.51000000E-06
   -8.18000000E-06  -5.39000000E-06  -1.66600000E-05  -8.40456100E-02  +7.84914300E-02
   +2.83957450E-01  -2.88260000E-04  -1.08550000E-04  +1.58500000E-04  -3.71430000E-04
   +4.91300000E-04  -3.35430000E-04  +4.95400000E-05  -2.61186000E-03  -9.63350000E-04
   +2.46670000E-04  -1.65490000E-04  +6.32500000E-05  +8.44400000E-05  -5.91300000E-05
   -8.06600000E-05  +3.11890000E-04  -1.84700000E-04  -7.40000000E-07  -1.56337600E-02
   +3.16924000E-03  +2.18200000E-04  +1.27316000E-03  +1.78999000E-03  +9.94050000E-04
   -3.75560000E-04  +1.64000000E-05  +2.88700000E-05  -3.13933360E-01  +4.00165600E-02
   -9.65538000E-03  +5.24500000E-05  -1.70700000E-05  -4.85000000E-06  -4.55100000E-05
   +2.26800000E-05  -5.73000000E-06  +1.26970000E-04  -1.19080000E-04  +1.74260000E-04
   +3.36500000E-05  -8.70700000E-05  -2.90700000E-05  -8.10300000E-05  +5.36000000E-06
   +3.90800000E-05  -7.85598000E-03  +1.05347000E-03  -1.13208000E-03  +3.39518840E-01
   -1.03760000E-04  -1.88220000E-04  +2.93640000E-04  -1.19142000E-03  +4.07700000E-04
   -1.71840000E-04  -1.20844000E-03  -4.66460000E-03  -1.77539000E-03  +4.60900000E-04
   -8.22030000E-04  +3.95780000E-04  -6.12700000E-05  +3.20180000E-04  -2.08100000E-05
   +1.49620000E-04  -8.18400000E-05  -5.10300000E-05  -2.92914300E-02  +3.49616000E-03
   -1.01492000E-03  -1.44999000E-03  +7.25800000E-04  +6.16500000E-04  -1.06890000E-04
   +6.24300000E-05  -5.50000000E-07  +4.37760300E-02  -5.26618800E-02  +4.89780000E-04
   -1.63400000E-05  -1.61000000E-05  -5.94000000E-06  -3.09600000E-05  -1.10000000E-06
   +1.08800000E-05  +1.06000000E-05  +4.96700000E-04  -1.34550000E-04  +2.04600000E-05
   -3.20000000E-05  -8.42400000E-05  -1.06940000E-04  +5.82000000E-06  +2.13900000E-05
   +8.22338000E-03  -2.38324000E-03  +1.61052000E-03  -4.34235800E-02  +5.90882900E-02
   +1.87860000E-04  -2.97040000E-04  -1.66000000E-06  -7.02890000E-04  +1.31000000E-05
   +2.27290000E-04  -7.05800000E-05  -1.43190000E-03  +9.34780000E-04  +1.31090000E-04
   +1.46290000E-04  +1.79060000E-04  -2.08410000E-04  -1.73420000E-04  +7.76500000E-05
   -8.37200000E-05  +2.20730000E-04  -4.45700000E-05  -8.97936000E-03  +2.97791000E-03
   -1.32744000E-03  -3.36440000E-04  +1.33390000E-04  -2.19670000E-04  +6.25200000E-05
   -3.36500000E-05  -4.47000000E-06  -8.65698000E-03  -2.00000000E-04  -4.84672400E-02
   +4.50000000E-06  +9.39000000E-06  -1.26000000E-06  -8.62000000E-06  +4.48000000E-06
   +2.62000000E-06  +2.84060000E-04  -1.69630000E-04  -1.72680000E-04  +2.04500000E-05
   -1.36000000E-05  +2.61000000E-05  -3.81000000E-05  -4.59000000E-06  -2.73200000E-05
   +2.87816600E-02  -4.12360000E-03  +3.16726000E-03  +1.06689900E-02  +7.49490000E-04
   +4.62838400E-02  +8.94700000E-05  +1.65130000E-04  +4.81700000E-05  +2.97200000E-05
   -5.56200000E-05  -8.11700000E-05  -2.36000000E-05  +6.92280000E-04  -6.58640000E-04
   -1.09886000E-03  -6.93630000E-04  +4.47000000E-05  -1.18570000E-04  +1.34980000E-04
   +7.97800000E-05  -7.42300000E-05  +1.09000000E-04  +3.12400000E-05  +4.23349000E-03
   -1.05404400E-02  +1.17226700E-02  -8.04430000E-04  -3.59770000E-04  -2.90820000E-04
   +9.73500000E-05  +2.63200000E-05  -3.99000000E-05  -5.54992000E-02  +3.31226500E-02
   -3.10629400E-02  -3.83800000E-05  -6.50000000E-06  +2.66000000E-06  -7.23000000E-06
   -1.77200000E-05  -1.08400000E-05  -2.31335000E-03  -1.49100000E-05  -5.44800000E-05
   +5.27200000E-05  +1.08580000E-04  -7.12200000E-05  +2.21300000E-05  +1.24000000E-06
   -5.85000000E-06  +1.27264000E-03  -8.40166000E-03  +7.13101000E-03  -4.44687000E-03
   +2.35354100E-02  -2.14039400E-02  +5.81755100E-02  +1.12500000E-04  +1.44300000E-04
   +8.27000000E-06  -2.36070000E-04  -2.89470000E-04  -2.06200000E-05  +7.95970000E-04
   +2.08370000E-04  -4.67490000E-04  +4.68770000E-04  -4.27300000E-04  +1.36900000E-05
   -2.33490000E-04  +3.84720000E-04  -5.37400000E-05  +1.41890000E-04  +1.12370000E-04
   +8.50000000E-06  +6.47405000E-03  -2.36588600E-02  +1.58515800E-02  -3.23151000E-03
   -1.13844000E-03  -8.73320000E-04  -6.29200000E-05  +6.04400000E-05  -2.12100000E-05
   +3.50550200E-02  -1.89288170E-01  +1.28921680E-01  -2.16900000E-05  -1.45900000E-05
   +5.37000000E-06  -2.30400000E-05  -1.31500000E-05  -7.80000000E-07  -1.69600000E-04
   +8.50540000E-04  +1.06800000E-05  +5.12300000E-05  +1.59680000E-04  -7.19800000E-05
   -2.95000000E-06  -5.96000000E-06  +6.92000000E-06  -1.94101000E-03  +7.63797000E-03
   -6.30868000E-03  +4.98590000E-04  -3.40938000E-03  +2.52740000E-03  -3.78334200E-02
   +2.08980210E-01  +2.91900000E-05  -3.93600000E-05  +1.23400000E-05  +8.28400000E-05
   -1.67250000E-04  -2.90000000E-05  -5.42600000E-05  +7.03910000E-04  +6.11100000E-05
   -5.31710000E-04  +8.34150000E-04  -3.47730000E-04  -5.37900000E-05  -4.06190000E-04
   +6.01300000E-05  -1.04890000E-04  +1.31370000E-04  +1.64500000E-05  +3.18249000E-03
   -9.42771000E-03  +8.46161000E-03  -4.81560000E-04  -1.05142000E-03  -3.91770000E-04
   +3.65000000E-06  -6.96300000E-05  +4.67000000E-06  -3.13535800E-02  +1.26738560E-01
   -1.54669350E-01  +2.26300000E-05  +1.39900000E-05  -9.70000000E-07  +1.26100000E-05
   +1.43300000E-05  -6.71000000E-06  -1.55580000E-04  -4.16530000E-04  +5.00430000E-04
   +1.59900000E-05  -2.28400000E-05  -4.22000000E-06  +1.70500000E-05  -8.35000000E-06
   +1.74000000E-06  -6.22016000E-03  +2.24092700E-02  -1.91313600E-02  +8.45800000E-05
   -7.12530000E-04  -7.19630000E-04  +3.53724700E-02  -1.38402690E-01  +1.66822970E-01
   -1.11780000E-04  +1.09900000E-05  -1.15030000E-04  -1.06110000E-03  +6.29440000E-04
   +6.36670000E-04  +2.10030000E-04  +1.45700000E-05  -8.67800000E-05  +1.91500000E-04
   -5.76100000E-05  +5.73100000E-05  +7.91000000E-05  -6.72800000E-05  +3.89500000E-05
   -9.85900000E-05  -5.89700000E-05  -4.45600000E-05  +1.09295600E-02  +1.41537700E-02
   +5.59916000E-03  -1.18676680E-01  -1.10810280E-01  -4.45868300E-02  +7.83900000E-05
   -2.30000000E-06  +6.68000000E-06  -1.57571000E-03  +1.56817000E-03  +9.20570000E-04
   -2.03700000E-05  -4.81000000E-06  +3.60000000E-06  +2.50500000E-05  -1.30900000E-05
   -1.89300000E-05  +2.60600000E-05  -3.35600000E-05  +2.63100000E-05  -1.41459000E-03
   +7.82300000E-05  +1.15405000E-03  +6.92000000E-06  +1.43700000E-05  +6.40500000E-05
   +4.80020000E-04  +3.78100000E-04  +1.70800000E-04  +4.55450000E-04  +2.14410000E-04
   +1.11290000E-04  +2.61450000E-04  +1.76590000E-04  +5.21100000E-05  +1.18406670E-01
   +6.07940000E-04  +8.13600000E-05  +1.96670000E-04  -6.30590000E-04  +1.93930000E-04
   +4.58320000E-04  -2.13007000E-03  -3.04690000E-04  +2.74645000E-03  +1.04431000E-03
   -4.38760000E-04  +1.41320000E-04  -6.13420000E-04  -2.86900000E-04  -6.86500000E-05
   +7.04400000E-05  +5.91540000E-04  -1.24060000E-04  -1.37931300E-02  -1.74582300E-02
   -8.08982000E-03  -1.05810130E-01  -2.46573940E-01  -8.54301000E-02  -1.35690000E-04
   -1.34400000E-05  -1.62500000E-05  +3.25308000E-03  +2.63250000E-04  -5.30892000E-03
   +1.80600000E-05  -1.51000000E-05  -2.53600000E-05  +1.62600000E-05  -7.79000000E-06
   -2.94000000E-05  -6.85200000E-05  +9.26200000E-05  +3.16300000E-05  -4.31830000E-04
   +5.37520000E-04  -2.31280000E-04  +3.75000000E-06  -1.21800000E-05  +1.88500000E-05
   -4.91010000E-04  -1.69309000E-03  -3.55700000E-04  +2.83600000E-05  +3.09880000E-04
   +2.00250000E-04  +1.11930000E-04  +2.02170000E-04  +1.89660000E-04  +1.16767460E-01
   +2.61840730E-01  -6.32600000E-04  +7.48900000E-04  -2.60120000E-04  +1.12270000E-03
   -1.30078000E-03  +4.08400000E-05  +9.03960000E-04  +2.55384000E-03  -5.60511000E-03
   -1.22809000E-03  +4.58010000E-04  +1.73420000E-04  +5.77760000E-04  +6.80980000E-04
   +1.45550000E-04  -1.16420000E-04  -8.26410000E-04  +5.69700000E-05  -7.73950000E-03
   -7.53015000E-03  +1.36238000E-03  -4.15999400E-02  -8.67369100E-02  -6.93110900E-02
   +1.21190000E-04  +1.34110000E-04  -6.66000000E-06  +1.15243000E-03  -4.46958000E-03
   +1.08750400E-02  -1.97100000E-05  +2.16800000E-05  +3.14800000E-05  -3.00600000E-05
   +1.16400000E-05  -1.11800000E-05  -6.24300000E-05  +6.41700000E-05  -1.78780000E-04
   +1.23448000E-03  +5.63950000E-04  -2.69720000E-04  +5.49200000E-05  +2.40000000E-07
   +2.33900000E-05  +5.64390000E-04  +1.58852000E-03  +3.44720000E-04  +2.86850000E-04
   +1.97430000E-04  -1.66280000E-04  -6.89870000E-04  -2.34541000E-03  -1.19337000E-03
   +4.48823300E-02  +9.53774500E-02  +6.14355700E-02  +5.11600000E-05  +1.38000000E-05
   +5.78900000E-05  +1.74740000E-04  +1.51280000E-04  -1.10740000E-04  +5.14290000E-04
   +2.63719000E-03  +8.66360000E-04  -4.70040000E-04  -4.73540000E-04  +3.84400000E-04
   -2.46150000E-04  +1.68940000E-04  -1.32640000E-04  +2.78460000E-04  +1.38650000E-04
   -1.36600000E-05  -1.42365000E-02  -3.40232000E-03  -8.80810000E-04  -3.41939100E-01
   -4.12619000E-03  +4.75901000E-03  -3.21820000E-04  -1.18000000E-06  +7.22000000E-06
   +7.52900000E-04  -1.48348000E-03  -8.55750000E-04  +4.84200000E-05  -1.37000000E-05
   -5.84000000E-06  -1.01960000E-04  +1.61000000E-06  -4.42200000E-05  +2.71700000E-05
   +9.90000000E-05  +1.53100000E-05  +1.25640000E-04  +6.05000000E-05  -1.80980000E-04
   -3.58400000E-05  -1.13400000E-05  +8.60000000E-06  +3.16120000E-04  -1.59470000E-04
   -5.08100000E-05  +8.78690000E-04  +6.00220000E-04  +2.36620000E-04  +1.90250000E-04
   -1.89100000E-05  +7.99300000E-05  -8.19137000E-03  +2.18280000E-03  +1.21761000E-03
   +3.62184950E-01  +5.69500000E-05  +2.66810000E-04  +1.30160000E-04  +4.31000000E-06
   -5.21050000E-04  +3.97490000E-04  +9.38400000E-04  -2.23461000E-03  -4.69922000E-03
   +4.58450000E-04  +3.92770000E-04  -6.56700000E-05  +2.99860000E-04  +1.86120000E-04
   +3.80040000E-04  -2.49340000E-04  -2.46440000E-04  -3.76200000E-05  +2.57224700E-02
   +3.22822000E-03  -1.91621000E-03  -9.72761000E-03  -5.36507700E-02  -8.19617000E-03
   +3.11340000E-04  +4.73200000E-05  -3.61600000E-05  +1.83597000E-03  -2.36230000E-04
   +3.30559000E-03  -2.52400000E-05  +2.51600000E-05  -1.40000000E-07  +7.17000000E-05
   -4.83000000E-06  +5.50000000E-06  +1.65600000E-05  -4.61800000E-05  -1.86540000E-04
   +1.14690000E-04  +3.81480000E-04  -3.40340000E-04  +4.38500000E-05  +7.64000000E-06
   +1.26400000E-05  -1.51040000E-04  +4.64160000E-04  +1.53720000E-04  -3.15430000E-04
   -6.52570000E-04  -5.35000000E-04  -8.38400000E-05  -4.95470000E-04  -3.10740000E-04
   -2.29581800E-02  +2.69114000E-03  +8.08300000E-04  +3.63612000E-03  +5.03973300E-02
   +5.67910000E-04  -1.50350000E-04  -6.27100000E-05  -1.06504000E-03  +8.07800000E-05
   +6.27700000E-05  -3.08360000E-04  -4.99675000E-03  +8.60007000E-03  +2.44606000E-03
   -1.69500000E-05  -6.45000000E-06  -6.98010000E-04  -1.06235000E-03  -4.27090000E-04
   +2.15440000E-04  +7.83950000E-04  -5.18900000E-05  +1.14004400E-02  -8.74570000E-04
   +4.55306000E-03  +1.67453000E-03  -7.88232000E-03  -3.60561500E-02  -4.04380000E-04
   -3.66900000E-05  +1.76900000E-05  +1.06008000E-03  +3.06062000E-03  -7.05123000E-03
   +1.84400000E-05  -4.37700000E-05  -6.43000000E-06  +1.25490000E-04  -6.24000000E-06
   -3.28100000E-05  -3.44200000E-05  +6.42500000E-05  +3.07040000E-04  -1.26870000E-04
   -6.25600000E-05  -1.23620000E-04  -2.64000000E-06  -1.21000000E-05  +9.29000000E-06
   -6.70800000E-05  -1.09250000E-03  -2.14020000E-04  -5.09330000E-04  -4.13610000E-04
   +2.53620000E-04  -6.30400000E-05  +1.21183000E-03  +5.52670000E-04  -8.87173000E-03
   +3.18950000E-04  +2.51296000E-03  -5.35749000E-03  +1.11303800E-02  +2.71632300E-02
end_hess

