# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -500.67015010    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.30273068E+00  -1.95319430E+00  +5.64559230E-01
   006   -7.13739384E-01  -1.93928504E+00  +8.98553887E-01
   006   +7.74269170E-01  +8.44512824E-02  +1.01730857E-01
   006   -4.36031053E-01  +2.10119866E+00  -1.06025150E+00
   006   -3.03433875E+00  +2.11392850E+00  -1.41447586E+00
   006   -4.47876935E+00  +8.43783076E-02  -6.00757117E-01
   006   +3.63687442E+00  -3.90911128E-02  +4.51084470E-01
   006   +4.80447013E+00  -1.68125669E+00  -1.61187266E+00
   008   -7.02806016E+00  -1.06963071E-02  -8.86326099E-01
   006   +4.87690476E+00  +2.56802546E+00  +4.67042869E-01
   008   +4.22389819E+00  -1.29887031E+00  +2.76280213E+00
   001   -7.60527579E+00  +1.49087120E+00  -1.71173085E+00
   001   -3.93219204E+00  +3.71614572E+00  -2.32231989E+00
   001   +6.35591994E-01  +3.71386789E+00  -1.71299051E+00
   001   +1.87905281E-01  -3.53045673E+00  +1.81218092E+00
   001   -4.43950537E+00  -3.52972653E+00  +1.19571621E+00
   001   +4.00946279E+00  +3.79503690E+00  +1.88029964E+00
   001   +6.87137618E+00  +2.34678573E+00  +9.24968138E-01
   001   +4.74229399E+00  +3.49921673E+00  -1.36496878E+00
   001   +4.43000254E+00  -8.73973313E-01  -3.46886544E+00
   001   +6.84176212E+00  -1.81907385E+00  -1.33595194E+00
   001   +4.00169465E+00  -3.57576245E+00  -1.54858590E+00
   001   +3.43621262E+00  -3.94254455E-01  +4.11846486E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.50000000E-07  -8.00000000E-08  -2.60000000E-07
   -7.10000000E-07  +4.08000000E-06  -1.45000000E-06
   -8.73000000E-06  -1.24500000E-05  +9.80000000E-07
   +9.86000000E-06  -6.40000000E-07  +2.78000000E-06
   +1.21000000E-06  -1.00000000E-07  +9.40000000E-07
   -2.18000000E-06  -1.64000000E-06  +6.20000000E-07
   -6.22000000E-06  +1.48400000E-05  +4.93000000E-06
   +1.95000000E-06  +7.00000000E-07  +5.66000000E-06
   +1.77000000E-06  +1.00000000E-08  +4.00000000E-08
   -3.16000000E-06  -1.13000000E-06  +4.20000000E-07
   +8.30000000E-07  +3.60000000E-07  -4.20000000E-06
   +5.30000000E-07  -1.03000000E-06  +1.00000000E-06
   -2.00000000E-08  +4.50000000E-07  +8.30000000E-07
   +2.30000000E-06  +1.86000000E-06  +2.70000000E-07
   +1.00000000E-08  -9.70000000E-07  -8.40000000E-07
   +2.50000000E-07  -1.26000000E-06  -6.80000000E-07
   +1.82000000E-06  -3.58000000E-06  -1.10000000E-07
   +6.30000000E-07  +1.42000000E-06  +7.00000000E-07
   -3.30000000E-06  +5.20000000E-07  -1.51000000E-06
   +6.00000000E-07  +6.60000000E-07  -1.18000000E-06
   +9.70000000E-07  +1.23000000E-06  -2.36000000E-06
   +1.50000000E-07  -5.10000000E-07  -2.73000000E-06
   +1.96000000E-06  -2.76000000E-06  -3.85000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.29246110E-01  +6.30718400E-02  +6.13034490E-01  +4.76283300E-02  -2.30434040E-01
   +2.51921440E-01  -3.57827890E-01  -3.65141400E-02  -2.06521900E-02  +7.07611280E-01
   +2.70045500E-02  -1.20731290E-01  +3.25815200E-02  -4.60910000E-03  +6.03922730E-01
   -5.09257400E-02  +2.30944700E-02  -7.95230200E-02  +7.45387200E-02  -2.27144520E-01
   +2.69939810E-01  -3.37920900E-02  -2.41241000E-02  +6.16543000E-03  -1.85266650E-01
   -1.10856680E-01  +4.10827600E-02  +6.25935460E-01  -7.08688400E-02  +3.41186200E-02
   -2.28472600E-02  -5.05347500E-02  -2.27637830E-01  +7.20122200E-02  +1.19008700E-02
   +5.87851580E-01  +2.89110900E-02  -1.44964500E-02  +1.92214700E-02  +1.22409500E-02
   +6.32425400E-02  -1.01082010E-01  +4.46597500E-02  -2.00181050E-01  +2.87121590E-01
   -5.14714600E-02  +2.70561800E-02  -1.96304700E-02  +6.75088700E-02  +2.06580500E-02
   -1.52643000E-03  -1.73076790E-01  +3.67857800E-02  -3.05471800E-02  +6.94396990E-01
   +2.82168400E-02  -1.78068200E-02  +1.09914800E-02  -2.70066600E-02  -4.91614800E-02
   +2.45875000E-02  +9.63905800E-02  -2.38307980E-01  +9.71167700E-02  +5.71899300E-02
   +6.15640360E-01  -2.15026700E-02  +1.14828600E-02  -1.18316200E-02  +2.26528700E-02
   +3.17779300E-02  -3.19424000E-03  -6.26713100E-02  +8.82968100E-02  -1.19528170E-01
   +4.50193100E-02  -2.26175440E-01  +2.59541750E-01  +6.51706300E-02  -2.54288500E-02
   +1.99273700E-02  -5.89819100E-02  -3.21600100E-02  +7.54941000E-03  -2.00355300E-02
   +7.46078400E-02  -4.17965800E-02  -3.40848720E-01  -3.39135600E-02  -1.95237900E-02
   +7.00891850E-01  +1.82215800E-02  -4.03967500E-02  +2.66106600E-02  -2.71294400E-02
   -1.77733400E-02  +3.29249000E-03  +2.75810200E-02  +3.02856200E-02  -8.88597000E-03
   +2.90001500E-02  -1.14781840E-01  +3.13524700E-02  +6.46335000E-03  +6.09155750E-01
   -1.48335000E-03  +2.07948800E-02  -1.81040000E-03  +5.95130000E-03  +2.65433000E-03
   -4.40345000E-03  -1.69652900E-02  -1.03905000E-03  +6.70256000E-03  -5.12483500E-02
   +2.27270700E-02  -7.82704700E-02  +7.29883000E-02  -2.38470390E-01  +2.52954590E-01
   -1.52404090E-01  +8.95712100E-02  -5.51088300E-02  -2.14358100E-02  +2.95390300E-02
   -1.78869700E-02  +5.10785000E-03  -2.40384000E-03  +3.74687000E-03  -3.30913700E-02
   -2.61512100E-02  +8.29689000E-03  -1.79217000E-01  -1.16003730E-01  +4.29513800E-02
   +7.04475420E-01  +1.72728300E-02  -2.48172560E-01  +8.99913000E-02  +8.25093100E-02
   +3.95734200E-02  -6.23470000E-03  -4.12953000E-03  -7.24441900E-02  +3.26503200E-02
   -8.04823700E-02  +3.65996800E-02  -2.90028200E-02  -3.97205500E-02  -2.48437990E-01
   +8.35772700E-02  +2.11200600E-02  +6.15446310E-01  -1.90215500E-02  +9.92342100E-02
   -1.23650070E-01  -4.44600600E-02  -1.47099100E-02  +3.27043000E-03  +3.90524000E-03
   +3.24594400E-02  -2.15606200E-02  +3.48167500E-02  -2.02508400E-02  +1.75558400E-02
   +5.67636000E-03  +7.36462100E-02  -1.05106500E-01  +6.05026600E-02  -2.21132280E-01
   +2.81980620E-01  +2.78073000E-03  -1.94123000E-03  +7.12500000E-04  -2.34608200E-02
   -6.88586000E-03  -4.99400000E-04  -1.76579630E-01  -5.08129000E-03  -9.61510000E-04
   -1.04544900E-02  +7.60185000E-03  -3.99487000E-03  +3.45614000E-03  -8.52510000E-04
   -1.21253000E-03  -3.22004000E-03  -1.14960000E-04  -3.77010000E-04  +5.00316260E-01
   -3.72175000E-03  -3.42058000E-03  +4.69309000E-03  -2.48501800E-02  +8.11175000E-03
   -4.46540000E-03  -2.71076000E-03  -9.13670800E-02  +4.82733000E-03  +2.22226900E-02
   +4.14030000E-03  +2.88690000E-04  +1.79949000E-03  -1.83098000E-03  +4.54913000E-03
   +1.37180000E-04  -2.20877000E-03  +8.71670000E-04  +6.54229000E-03  +5.12561410E-01
   +1.93704000E-03  +3.75485000E-03  +3.72694000E-03  +7.19984000E-03  -5.90666000E-03
   +2.92097000E-03  -1.03884200E-02  +7.14111000E-03  -7.39292300E-02  -1.18172800E-02
   -4.46850000E-04  +1.09764000E-03  -1.62678000E-03  +4.67724000E-03  +4.16960000E-03
   -1.46407000E-03  +1.19167000E-03  -1.07059000E-03  -1.35663700E-02  +1.54568900E-02
   +4.83390610E-01  +3.38520000E-04  +9.17000000E-06  -1.12755000E-03  -7.23780000E-04
   +1.45003000E-03  +1.69900000E-04  -2.32233700E-02  +2.04741300E-02  +2.27157600E-02
   -4.83080000E-04  -1.36087000E-03  +1.55566000E-03  -1.05510000E-03  -1.37856000E-03
   -1.09450000E-03  +1.13458000E-03  +7.88060000E-04  -1.70450000E-04  -9.65575500E-02
   +2.84042900E-02  +3.92889500E-02  +5.68803280E-01  +2.45080000E-04  -3.27540000E-04
   +1.59370000E-04  -1.50700000E-03  -2.12660000E-04  -7.09500000E-05  +7.12319000E-03
   -9.82290000E-04  -1.31850000E-03  -3.55950000E-04  -1.85500000E-05  -2.52270000E-04
   -1.41980000E-04  +7.14000000E-06  +9.37600000E-05  +4.99400000E-05  +3.74830000E-04
   -9.34800000E-05  +2.56587700E-02  -1.17554750E-01  -5.28449000E-02  +2.84620100E-02
   +5.55001560E-01  +2.00000000E-07  -5.32000000E-06  -1.29790000E-04  -1.12464000E-03
   -1.16240000E-04  +1.25900000E-05  +6.79278000E-03  -2.98330000E-04  +3.92461000E-03
   -6.24090000E-04  +2.74060000E-04  -6.37400000E-04  -3.67820000E-04  -5.49150000E-04
   -3.17820000E-04  +5.03920000E-04  +2.55910000E-04  -2.09000000E-06  +2.61614800E-02
   -4.08889400E-02  -1.20120890E-01  +3.52567500E-02  -4.89289400E-02  +5.37776490E-01
   -3.87939600E-02  +1.05931600E-02  -1.12786700E-02  +4.48496000E-03  +5.91110000E-04
   +4.08100000E-05  -5.09847000E-03  -2.04066000E-03  -1.33444000E-03  +2.90536000E-03
   -2.50865000E-03  +4.53400000E-04  -4.60855700E-02  -5.03245000E-03  -4.68707000E-03
   -3.10780080E-01  -3.81484800E-02  -1.57997000E-02  +3.57844000E-03  +1.10300000E-04
   +2.09402000E-03  -1.73083000E-03  -1.93790000E-04  -9.47420000E-04  +4.77829880E-01
   +4.62609300E-02  +5.12392000E-03  +7.14849000E-03  -6.19647000E-03  -7.21674000E-03
   +5.05558000E-03  +3.84120000E-04  +5.91014000E-03  -3.45872000E-03  +5.27821000E-03
   -5.55951000E-03  +7.42734000E-03  -4.11852400E-02  +4.11697000E-03  -2.55201000E-03
   +8.60532000E-03  -9.83220600E-02  +2.81616600E-02  +4.12000000E-05  +8.10000000E-05
   -4.11410000E-04  +8.12000000E-06  -5.46800000E-05  +1.59300000E-05  -1.07539990E-01
   +4.77634660E-01  -2.91035300E-02  +2.59988000E-03  +2.32385000E-03  +3.14466000E-03
   +6.15871000E-03  +2.45251000E-03  -7.82190000E-04  -3.75160000E-03  +2.80800000E-04
   -3.23288000E-03  +6.14621000E-03  +4.10453000E-03  +1.29541700E-02  +2.13745000E-03
   +1.05767200E-02  -3.92804400E-02  +2.19989900E-02  -6.02390100E-02  +6.68370000E-04
   -3.87460000E-04  -2.57930000E-04  -1.26360000E-04  -1.65800000E-05  -1.10390000E-04
   +1.12800300E-01  -2.38812160E-01  +1.61422810E-01  -8.33370000E-04  -9.22570000E-04
   +1.14094000E-03  -4.47754000E-03  +1.89162000E-03  -2.26796000E-03  -1.91935500E-02
   -3.11097900E-02  -7.03000000E-04  -1.99842000E-03  -2.74380000E-04  -6.65200000E-04
   -4.80100000E-05  -8.22920000E-04  +6.07970000E-04  +4.22700000E-04  -1.85860000E-04
   +3.41900000E-05  -1.01388050E-01  -4.41356000E-02  -1.53659000E-03  +6.41791000E-03
   +1.14801500E-02  -2.59560000E-04  -6.88510000E-04  +2.29300000E-05  -7.50800000E-05
   +5.66355700E-01  +3.59830000E-04  +3.02870000E-04  -2.18760000E-04  +2.13350000E-03
   -3.05130000E-04  -1.82430000E-04  -4.84839000E-03  +2.11994000E-03  -2.95607000E-03
   +6.51870000E-04  +2.23960000E-04  +5.41630000E-04  +3.29400000E-05  -4.96500000E-05
   +3.82390000E-04  -2.69050000E-04  +1.58540000E-04  -3.22200000E-05  -4.09124100E-02
   -1.60820010E-01  -6.32920000E-03  -7.60359000E-03  -2.66982300E-02  -7.09321000E-03
   +4.35820000E-04  -6.59200000E-05  +6.26000000E-06  -5.02607900E-02  +4.98318570E-01
   -2.40600000E-05  -2.86070000E-04  +3.48840000E-04  -9.68340000E-04  +3.79470000E-04
   +7.16900000E-05  +3.20590000E-04  -3.67978000E-03  +2.75926000E-03  +1.49380000E-04
   -1.14704000E-03  +3.11000000E-04  +3.42350000E-04  +1.99320000E-04  -6.20480000E-04
   +1.15510000E-04  -6.92200000E-05  +4.71900000E-05  -4.22000000E-03  -1.51251700E-02
   -7.55684300E-02  -9.57807000E-03  -2.57715400E-02  -3.63850000E-04  +4.40200000E-05
   +7.77400000E-05  +3.74500000E-05  +3.92500000E-04  -4.92716000E-03  +5.87571480E-01
   +1.10606000E-03  +1.45340000E-03  -7.07820000E-04  -1.40879000E-03  -1.84268000E-03
   -1.27043000E-03  -1.38775700E-02  +2.33495400E-02  -3.81679500E-02  -3.61679000E-03
   -4.64843000E-03  -2.44040000E-04  -2.66878000E-03  +1.39212000E-03  +5.78430000E-04
   +1.64790000E-03  +1.46126000E-03  -4.89060000E-04  -8.03872700E-02  +2.23557200E-02
   -5.43541000E-03  +5.29229000E-03  -6.03161000E-03  +1.49894000E-02  -2.26344000E-03
   +7.72000000E-06  -3.20080000E-04  +4.61991000E-03  -5.83625000E-03  +1.06579900E-02
   +2.04433170E-01  +4.39700000E-04  +1.02378000E-03  -9.61580000E-04  -2.69181000E-03
   -3.03385000E-03  -1.46130000E-04  +6.96021000E-03  -3.56005000E-03  +1.28775200E-02
   +1.38269000E-03  +1.45991000E-03  +6.15100000E-04  +4.12690000E-04  -8.31000000E-06
   -6.41930000E-04  -6.98500000E-04  -3.54880000E-04  +1.67920000E-04  +2.69472400E-02
   -1.14660590E-01  +2.95832900E-02  -2.66986000E-03  +9.87756000E-03  -1.64602900E-02
   +5.86410000E-04  +3.02730000E-04  +1.77900000E-05  +6.57490000E-03  -2.52079400E-02
   +4.46908100E-02  -1.65869820E-01  +2.95955930E-01  -1.21112000E-03  +2.78440000E-04
   +1.97550000E-04  +2.15103000E-03  +3.46279000E-03  +1.50450000E-03  -1.11929300E-02
   +1.13119300E-02  -1.78213600E-02  -4.24705000E-03  -1.77502000E-03  -9.03460000E-04
   +2.10000000E-04  +1.15460000E-03  +3.09350000E-04  +1.11351000E-03  -7.41490000E-04
   +2.06780000E-04  -2.89800800E-02  +6.43624600E-02  -1.67619500E-01  -5.35606000E-03
   +1.62817200E-02  -4.87007400E-02  -1.38000000E-03  -4.98600000E-05  -1.35550000E-04
   -1.75640000E-03  +1.44294400E-02  -1.80209700E-02  -1.29109240E-01  +9.49248800E-02
   +5.54969860E-01  -7.21061000E-03  -2.41296000E-03  -3.41200000E-05  +8.22470000E-04
   +1.86642000E-03  -1.00789000E-03  +3.69510000E-04  -8.10010000E-04  +5.05700000E-04
   -8.41820000E-04  +4.35710000E-04  -2.60250000E-04  +3.34379000E-03  +1.39445000E-03
   -1.21900000E-04  -2.20598500E-02  +4.29435600E-02  -2.39820000E-02  -3.79450000E-04
   -6.35600000E-05  -1.11470000E-04  +1.11050000E-04  +1.91800000E-05  +4.74300000E-05
   -8.62542300E-02  +9.49954200E-02  -5.82837000E-02  +8.47200000E-05  -2.28600000E-05
   -1.05400000E-05  +2.72590000E-04  -1.18700000E-04  +1.94190000E-04  +1.12501810E-01
   -9.69710000E-04  +2.16552000E-03  -8.24200000E-05  +1.37170000E-04  +1.27930000E-04
   +8.20320000E-04  -2.89770000E-04  -7.77500000E-05  -1.19390000E-04  +1.24040000E-04
   -9.27820000E-04  +1.08690000E-04  -4.71913000E-03  +3.07061000E-03  -2.58876000E-03
   -1.26901000E-03  -1.05260000E-03  -9.78570000E-04  +2.09130000E-04  -1.51700000E-05
   +1.61980000E-04  -1.23970000E-04  -1.62900000E-05  -6.59500000E-05  +1.42734410E-01
   -3.84279110E-01  +2.08751580E-01  -4.27700000E-05  +3.36000000E-05  -4.97000000E-06
   -9.08900000E-05  +1.32900000E-05  -7.33500000E-05  -1.36129190E-01  +3.81513040E-01
   -8.03980000E-04  -2.39600000E-04  +2.23877000E-03  -1.16150000E-04  +1.01653000E-03
   +1.11593000E-03  +1.47960000E-04  -2.14100000E-05  +2.17090000E-04  -8.02600000E-05
   +1.79590000E-04  -7.82010000E-04  +2.91738000E-03  -1.78843000E-03  +3.27270000E-04
   -1.81539000E-03  +4.76703000E-03  -5.26409000E-03  -1.50200000E-04  -2.28000000E-05
   -9.05600000E-05  +8.30800000E-05  -5.63000000E-06  +4.86400000E-05  -8.21785100E-02
   +2.02498200E-01  -1.15725850E-01  +5.50000000E-07  -1.31000000E-06  -6.44000000E-06
   +1.15560000E-04  -2.86900000E-05  +1.63500000E-05  +8.21723300E-02  -2.06212550E-01
   +1.18142970E-01  -1.07103000E-03  -3.47005000E-03  +8.51490000E-04  -1.18827000E-03
   -7.06090000E-04  +3.01000000E-04  -5.62715000E-03  -1.38892000E-03  -8.44490000E-04
   -8.47097000E-03  +2.64814900E-02  -1.44139600E-02  -1.10254390E-01  +9.08657100E-02
   -5.51689500E-02  +8.13528000E-03  -1.35881500E-02  +7.22578000E-03  +7.85810000E-04
   +1.02910000E-03  -4.29710000E-04  -1.42580000E-04  -7.56300000E-05  -8.81100000E-05
   +3.54764000E-03  -3.35460000E-04  +1.16764000E-03  +9.26000000E-06  +8.75600000E-05
   -1.96900000E-05  -7.15170000E-04  +2.18430000E-04  -4.81800000E-04  -5.64790000E-04
   +7.11960000E-04  -5.08730000E-04  +1.14250010E-01  -4.09575000E-03  -1.81510000E-03
   +3.13576000E-03  -1.10539000E-03  -1.16790000E-04  -6.35720000E-04  -7.53890000E-04
   +3.12066000E-03  +1.78928000E-03  -1.61792000E-03  +3.13617000E-03  -6.73800000E-04
   +9.10304900E-02  -2.25210260E-01  +1.06951360E-01  +1.62751200E-02  -1.41525100E-02
   +1.11538300E-02  -3.40070000E-04  +2.01430000E-04  +7.24000000E-05  +9.77000000E-06
   -8.40000000E-06  +5.10000000E-05  +3.60510000E-04  +1.43854000E-03  -2.65342000E-03
   +5.42000000E-05  -3.50900000E-05  -1.73000000E-05  +2.26450000E-04  -6.58100000E-05
   +1.34410000E-04  -2.00212000E-03  -7.34500000E-04  +3.76790000E-04  -9.93261700E-02
   +2.35398410E-01  +1.18146000E-03  +3.19345000E-03  +4.18408000E-03  +4.86110000E-04
   -4.91740000E-04  -7.23470000E-04  -1.33897000E-03  +1.72227000E-03  +5.87529000E-03
   -7.34780000E-04  +2.96447000E-03  +6.24910000E-04  -5.51540700E-02  +1.06885740E-01
   -9.27308500E-02  -7.46993000E-03  +7.33577000E-03  -4.33620000E-04  +1.33900000E-04
   +4.03190000E-04  +3.21720000E-04  -1.21510000E-04  -2.12100000E-05  +1.02900000E-05
   +7.89660000E-04  -2.76682000E-03  -2.56923000E-03  -4.16100000E-05  -8.07000000E-06
   -3.94000000E-06  +1.54010000E-04  -6.60900000E-05  +5.46700000E-05  +8.32310000E-04
   +7.36670000E-04  +3.21050000E-04  +6.11274000E-02  -1.17900860E-01  +8.91099600E-02
   -7.73290000E-04  +7.56950000E-04  -3.22350000E-04  -4.77950000E-04  +2.59036000E-03
   -2.29637000E-03  +1.20194700E-02  +9.93081000E-03  -4.03306000E-03  -1.35488170E-01
   -1.17271150E-01  +4.50629600E-02  -1.24336900E-02  -2.57470500E-02  +1.06731800E-02
   -4.52536000E-03  +1.02667000E-03  -2.13907000E-03  +8.86700000E-05  +4.38480000E-04
   +4.58450000E-04  -1.47560000E-04  -3.99300000E-05  -6.68000000E-05  -1.42756000E-03
   -1.32675000E-03  +4.31620000E-04  -1.61422000E-03  +5.15260000E-04  -9.99540000E-04
   +2.15100000E-04  -5.25010000E-04  +2.85770000E-04  +2.30250000E-04  -1.67390000E-04
   +1.26980000E-04  +8.05350000E-04  +5.33620000E-04  +4.31360000E-04  +1.45645140E-01
   +9.25340000E-04  +2.48500000E-05  -4.67270000E-04  +2.95415000E-03  -1.74870000E-03
   +4.61492000E-03  -1.48957500E-02  -1.37716700E-02  +6.98155000E-03  -1.17214120E-01
   -2.32067690E-01  +8.00514600E-02  +1.98555000E-03  +3.39322000E-03  +4.08880000E-04
   +6.29050000E-04  +3.04613000E-03  +2.34443000E-03  -1.51356000E-03  -1.33672000E-03
   -1.59493000E-03  +4.82680000E-04  -3.09000000E-05  +3.07850000E-04  -1.64670000E-04
   +8.95000000E-06  -3.02600000E-05  -1.04442000E-03  +1.16130000E-04  +4.72070000E-04
   +2.30500000E-04  +5.55860000E-04  -3.06810000E-04  +4.86500000E-05  -3.08000000E-05
   +3.34000000E-06  +2.06900000E-05  -9.62100000E-05  -2.03092000E-03  +1.28578820E-01
   +2.42018150E-01  -4.16630000E-04  -5.24750000E-04  -1.00543000E-03  -2.50865000E-03
   +4.71735000E-03  +4.19302000E-03  +8.40892000E-03  +1.05208000E-02  +3.62400000E-04
   +4.47099900E-02  +7.93997500E-02  -7.19147200E-02  -3.12491000E-03  -3.20873000E-03
   +4.94981000E-03  -1.93980000E-03  +2.42718000E-03  +6.29726000E-03  +1.60777000E-03
   -1.43553000E-03  -2.88995000E-03  +4.60660000E-04  -1.40750000E-04  +2.90250000E-04
   -9.26500000E-05  -1.88950000E-04  +5.24500000E-05  -1.45530000E-04  -2.32600000E-05
   +4.23890000E-04  -6.96790000E-04  -4.52000000E-05  -2.30710000E-04  +1.12500000E-05
   -2.30500000E-05  -2.07800000E-05  +6.70600000E-04  -1.99239000E-03  -3.22304000E-03
   -4.71883900E-02  -8.93612800E-02  +6.37807500E-02  -9.01244000E-03  +2.50558300E-02
   -1.41686700E-02  -1.12900530E-01  +9.53881300E-02  -5.63830000E-02  +1.30661800E-02
   -1.24894700E-02  +6.89059000E-03  -1.58892000E-03  -3.60470000E-03  +7.05520000E-04
   -9.54980000E-04  -5.93720000E-04  +3.10410000E-04  -4.55044000E-03  -1.56110000E-03
   -9.89840000E-04  -1.58830000E-04  -2.99280000E-04  +9.39920000E-04  -3.75980000E-04
   -1.28310000E-04  -1.30300000E-04  -6.80770000E-04  +1.36423000E-03  -7.97880000E-04
   +2.00740000E-04  +5.00100000E-05  -1.91520000E-04  -2.30743000E-03  -2.94360000E-04
   -3.30590000E-04  -4.24230000E-04  +3.78500000E-05  -5.25700000E-05  +1.75800000E-05
   +8.99700000E-05  +5.43800000E-05  +5.20650000E-04  -8.41570000E-04  +5.28360000E-04
   +1.18195430E-01  -2.32471000E-03  +4.36172000E-03  -1.70480000E-04  +9.49666400E-02
   -2.28711040E-01  +1.05742800E-01  +1.18332200E-02  -1.41269800E-02  +1.10010200E-02
   -3.89602000E-03  -1.88950000E-03  +3.60372000E-03  -7.65650000E-04  +1.14890000E-04
   -7.39960000E-04  -1.42310000E-03  +3.07766000E-03  +2.55076000E-03  +1.87477000E-03
   -1.91158000E-03  +4.19440000E-04  -7.93500000E-05  -1.92900000E-05  -5.29100000E-05
   +1.63410000E-04  +2.57200000E-05  -4.42000000E-06  -2.39740000E-04  +1.60190000E-04
   -1.75190000E-04  +1.56695000E-03  +1.97099000E-03  -1.23472000E-03  -6.14400000E-05
   -2.53000000E-06  -1.27070000E-04  +1.19660000E-04  -1.60420000E-04  -2.49630000E-04
   +6.83410000E-04  -8.43710000E-04  +5.46910000E-04  -1.02384400E-01  +2.38646340E-01
   -5.87450000E-04  +3.02571000E-03  +2.90739000E-03  -5.61255200E-02  +1.06865840E-01
   -1.01944080E-01  -5.27985000E-03  +8.10177000E-03  +3.04670000E-04  +8.28150000E-04
   +3.44038000E-03  +4.63117000E-03  +3.60930000E-04  -6.59280000E-04  -7.30960000E-04
   -9.51590000E-04  +2.51949000E-03  +6.98556000E-03  -1.93370000E-04  -9.33370000E-04
   -2.62379000E-03  +4.66690000E-04  +3.52930000E-04  +9.33100000E-05  -1.12200000E-04
   +1.24090000E-04  -8.36000000E-05  -1.69130000E-04  -1.21600000E-05  -2.80920000E-04
   -1.22095000E-03  -7.12440000E-04  -5.64820000E-04  +1.19600000E-05  -1.01200000E-04
   -1.72540000E-04  +2.50500000E-05  -2.46980000E-04  -5.51580000E-04  -2.31630000E-04
   +3.25340000E-04  -1.49610000E-04  +6.28923100E-02  -1.18720590E-01  +9.61293400E-02
   -1.44505750E-01  -1.22736540E-01  +4.64675000E-02  -1.13374900E-02  -2.50838800E-02
   +1.05238500E-02  -4.97914000E-03  +9.05740000E-04  -1.92117000E-03  -8.03320000E-04
   +8.11840000E-04  -3.77380000E-04  -7.34990000E-04  +2.30713000E-03  -1.99268000E-03
   +1.05976600E-02  +1.13658000E-02  -4.92857000E-03  +1.76270000E-04  -1.44607000E-03
   +6.97170000E-04  -3.20100000E-05  -6.66500000E-05  -8.36500000E-05  +1.23798000E-03
   -4.12640000E-04  +8.44640000E-04  -4.52320000E-04  +1.97300000E-04  -7.29800000E-05
   +5.14200000E-05  +1.58890000E-04  -2.18980000E-04  +7.96400000E-05  -1.51230000E-04
   +1.52610000E-04  +5.12320000E-04  +7.03550000E-04  -2.71570000E-04  +9.50000000E-07
   -5.16700000E-05  +1.32680000E-04  +9.09910000E-04  +5.73920000E-04  +4.40730000E-04
   +1.49375890E-01  -1.21041740E-01  -2.27096370E-01  +7.87958100E-02  +2.12854000E-03
   +4.59366000E-03  -5.50610000E-04  +3.95250000E-04  +3.07318000E-03  +2.30903000E-03
   +1.20483000E-03  -8.14200000E-05  -2.74850000E-04  +2.84586000E-03  -1.76389000E-03
   +3.95618000E-03  -1.77798200E-02  -1.41328600E-02  +7.25669000E-03  +2.44410000E-04
   +5.92700000E-05  +1.94490000E-04  -4.46200000E-05  -1.75000000E-05  -3.03500000E-05
   -1.48960000E-04  +9.14980000E-04  -2.16921000E-03  +4.29300000E-05  +4.52800000E-05
   +5.30000000E-06  -1.65620000E-04  +1.36300000E-05  -8.50900000E-05  -5.72000000E-05
   +2.02780000E-04  -3.77230000E-04  -6.51130000E-04  -8.52820000E-04  +3.11220000E-04
   -1.57700000E-05  -1.64290000E-04  -3.00640000E-04  -8.37000000E-06  -3.21150000E-04
   -2.20358000E-03  +1.33022290E-01  +2.35532600E-01  +4.57767800E-02  +7.85326300E-02
   -6.89361700E-02  -2.96858000E-03  -4.02268000E-03  +4.47742000E-03  -2.12053000E-03
   +2.46712000E-03  +6.25713000E-03  -5.31290000E-04  -3.82570000E-04  -8.73260000E-04
   -2.28780000E-03  +3.85308000E-03  +3.30356000E-03  +9.62219000E-03  +1.11732300E-02
   +9.11600000E-04  -5.74500000E-05  -2.42280000E-04  +5.38120000E-04  +3.94600000E-05
   -3.18300000E-05  -3.33300000E-05  +5.91800000E-04  -2.21191000E-03  -2.23617000E-03
   +4.22700000E-05  +6.51600000E-05  -3.66300000E-05  -5.30300000E-05  +3.52200000E-05
   -1.16190000E-04  +1.10980000E-04  -3.93180000E-04  -3.24700000E-04  +3.92960000E-04
   +4.88430000E-04  -2.59430000E-04  +1.18480000E-04  -3.03610000E-04  -6.07080000E-04
   +8.37180000E-04  -2.18539000E-03  -3.60669000E-03  -4.95167200E-02  -8.68498600E-02
   +6.15820300E-02  +9.16600000E-05  -1.55000000E-06  +1.12200000E-05  +1.31860000E-04
   +1.00000000E-07  +1.23800000E-04  +8.82280000E-04  -2.16590000E-04  -5.97380000E-04
   -2.47550000E-04  -1.95020000E-04  -1.92300000E-04  -2.93900000E-05  +1.18000000E-04
   +4.41000000E-06  -1.20750000E-04  +3.07300000E-05  -3.19200000E-05  +5.44870000E-03
   -9.32752000E-03  -1.10754200E-02  -1.03879000E-03  -2.48928000E-03  +1.01710000E-04
   +1.84230000E-04  +7.39000000E-06  +1.96400000E-05  -9.64412600E-02  +6.69486000E-02
   +7.96046100E-02  -1.82910000E-04  +1.19282000E-03  -1.43952000E-03  -2.77900000E-05
   +7.67000000E-06  -7.53000000E-06  +1.39500000E-05  -1.97800000E-05  -1.61700000E-05
   -1.39980000E-04  +3.21000000E-06  -3.54110000E-04  +1.36600000E-05  +1.89200000E-05
   -3.51800000E-05  +2.16700000E-05  +5.67000000E-06  +1.20000000E-07  +1.01205320E-01
   +3.29820000E-04  -1.70160000E-04  +7.12700000E-05  -4.75030000E-04  -2.16630000E-04
   +4.17390000E-04  +1.63673000E-03  +1.21760000E-03  +6.99180000E-04  -1.35200000E-05
   +3.44940000E-04  -7.55300000E-05  -3.45140000E-04  -1.12900000E-05  +4.77000000E-06
   -7.44400000E-05  +3.21940000E-04  -1.68590000E-04  +1.41064300E-02  -1.71738300E-02
   -2.26777400E-02  -3.55585000E-03  -5.25070000E-03  +1.36471000E-03  +1.19740000E-04
   -2.97900000E-05  +3.24500000E-05  +6.61981300E-02  -1.38403290E-01  -1.05767470E-01
   -1.20790000E-04  +2.73387000E-03  +2.90880000E-04  -8.40000000E-06  +6.94000000E-06
   -1.15700000E-05  -9.74000000E-06  -1.36200000E-05  -1.05900000E-05  -1.13270000E-04
   -4.28200000E-05  -9.78500000E-05  +9.70000000E-06  +2.03500000E-05  -5.29500000E-05
   +7.27000000E-06  -2.63100000E-05  -4.62300000E-05  -7.12035300E-02  +1.51400870E-01
   +1.99070000E-04  -4.12200000E-05  +2.09300000E-05  -4.30290000E-04  -8.16900000E-05
   +3.67200000E-05  +4.11590000E-04  -1.02710000E-04  +2.48810000E-04  -7.56100000E-05
   -2.14170000E-04  +5.28900000E-04  -2.36140000E-04  +1.85320000E-04  +2.09700000E-05
   -1.93000000E-06  +1.27780000E-04  -1.19120000E-04  -4.73500000E-05  +1.42520000E-03
   -2.45076000E-03  -9.05980000E-04  -5.01690000E-04  +7.24540000E-04  +4.55000000E-05
   +1.91400000E-05  -9.95000000E-06  +7.77587000E-02  -1.06382830E-01  -1.73288750E-01
   -5.44210000E-04  -1.85300000E-05  +1.99484000E-03  -2.34600000E-05  -1.05500000E-05
   -7.65000000E-06  -1.90100000E-05  -1.06400000E-05  -1.74000000E-06  +1.11490000E-04
   +5.59900000E-05  -6.61110000E-04  +3.83600000E-05  +5.52200000E-05  -2.48100000E-05
   -1.00000000E-05  -2.85000000E-06  -1.29000000E-05  -8.61028900E-02  +1.17861460E-01
   +1.84823370E-01  -3.10470000E-04  -1.09750000E-04  +1.38790000E-04  -4.65430000E-04
   +4.53540000E-04  -5.23620000E-04  +1.62810000E-04  -3.16907000E-03  +1.53100000E-04
   +3.07770000E-04  -1.83180000E-04  +1.55990000E-04  +1.03450000E-04  -9.60000000E-05
   -4.01400000E-05  +3.28530000E-04  -1.68470000E-04  +9.65700000E-05  -1.66252300E-02
   +2.33932000E-03  -4.00084000E-03  +3.61200000E-04  +8.81360000E-04  +3.96850000E-04
   -4.20920000E-04  +2.50600000E-05  -4.31500000E-05  -3.01873040E-01  +3.06866300E-02
   -5.83701400E-02  +2.60569000E-03  +1.68717000E-03  +4.76130000E-04  +5.29300000E-05
   -2.09900000E-05  +1.13900000E-05  -4.57300000E-05  +2.23800000E-05  -1.75100000E-05
   +6.75200000E-05  -5.14100000E-05  +2.41120000E-04  +7.73000000E-06  -1.11090000E-04
   +5.89000000E-06  -1.00680000E-04  +1.47800000E-05  +2.13500000E-05  -1.12770000E-02
   +6.37690000E-04  -3.34841000E-03  +3.26650850E-01  -1.38270000E-04  -2.79890000E-04
   +3.11570000E-04  -1.66419000E-03  +4.68320000E-04  -4.50500000E-04  -9.44430000E-04
   -5.49278000E-03  +8.00670000E-04  +4.34540000E-04  -7.09020000E-04  +7.09400000E-04
   -1.21350000E-04  +2.75080000E-04  -9.60400000E-05  +1.84580000E-04  -3.74900000E-05
   -3.29400000E-05  -3.11834500E-02  +1.03548000E-03  -7.27731000E-03  -9.98600000E-04
   +1.31077000E-03  +4.17940000E-04  -1.37700000E-04  +5.21900000E-05  -4.05700000E-05
   +3.37535900E-02  -4.99336200E-02  +6.80045000E-03  +1.01274000E-03  +2.65804000E-03
   -1.52207000E-03  -8.40000000E-06  -1.48200000E-05  +2.70000000E-07  -4.19700000E-05
   +4.80000000E-06  +1.37000000E-06  +1.85320000E-04  +4.22960000E-04  -2.85900000E-04
   +1.52500000E-05  -3.63000000E-05  -6.81100000E-05  -1.43860000E-04  +6.47000000E-06
   -1.11600000E-05  +1.74412600E-02  -2.32653000E-03  +5.64051000E-03  -3.23178600E-02
   +5.52808500E-02  +1.05960000E-04  -1.41780000E-04  -1.50200000E-05  -1.49400000E-04
   +6.23700000E-05  +2.31760000E-04  +1.01930000E-04  +4.70320000E-04  +3.21370000E-04
   -1.35610000E-04  +3.63750000E-04  -2.05100000E-05  -1.61650000E-04  -2.41130000E-04
   +1.64430000E-04  -3.29100000E-05  +1.35420000E-04  -9.27200000E-05  -1.07410000E-04
   +1.33803000E-03  -1.52030000E-03  -6.74650000E-04  +8.91300000E-05  -3.11930000E-04
   -4.19100000E-05  -4.15600000E-05  +1.24500000E-05  -5.93322600E-02  +5.29298000E-03
   -6.07092400E-02  +8.16580000E-04  -2.46900000E-05  +6.54300000E-05  +2.12400000E-05
   +5.39000000E-06  +3.85000000E-06  -1.11300000E-05  +1.32200000E-05  +2.59000000E-06
   +2.58760000E-04  -3.96840000E-04  -5.29000000E-06  +9.94000000E-06  +2.37000000E-06
   +6.39100000E-05  -9.30000000E-07  -1.91200000E-05  -3.37900000E-05  +2.24712400E-02
   -1.81590000E-03  +5.72695000E-03  +6.44696300E-02  -6.92895000E-03  +6.16120200E-02
   +1.52440000E-04  +8.51300000E-05  -1.47900000E-05  -2.43800000E-05  +6.30000000E-06
   -2.21000000E-05  +3.39790000E-04  +3.97590000E-04  -5.29150000E-04  -1.76008000E-03
   -4.89850000E-04  -5.87400000E-05  -1.45290000E-04  +1.62490000E-04  +8.25700000E-05
   -6.94800000E-05  +1.27370000E-04  -1.34800000E-05  +7.00930000E-04  -2.72625000E-03
   +1.27393500E-02  +2.94620000E-04  +6.34950000E-04  +2.37070000E-04  +9.29300000E-05
   +5.90000000E-07  -4.06600000E-05  -4.85876800E-02  +7.21462000E-03  -1.74586300E-02
   +3.94090000E-04  -3.67835000E-03  +1.53731000E-03  -3.65800000E-05  -3.22000000E-06
   +5.10000000E-06  -4.80000000E-07  -1.73800000E-05  -3.72000000E-06  -2.73697000E-03
   -1.31900000E-05  -4.15070000E-04  +6.02500000E-05  +8.59200000E-05  +1.34000000E-05
   +1.21700000E-05  +1.58000000E-06  -2.76000000E-06  +2.17800000E-04  -7.19012000E-03
   +1.25136400E-02  -7.07700000E-05  +1.39053700E-02  -2.83178700E-02  +5.10392100E-02
   +1.79830000E-04  +3.67200000E-05  +9.23000000E-06  -1.74410000E-04  -1.76630000E-04
   -3.65600000E-05  +1.16640000E-04  +1.39090000E-04  -3.95050000E-04  +4.07260000E-04
   -1.55410000E-04  -9.80100000E-05  -2.27960000E-04  +1.70050000E-04  -9.79800000E-05
   +5.99800000E-05  +1.91730000E-04  -3.19700000E-05  +6.45537000E-03  -6.42084000E-03
   +2.51444200E-02  +4.46560000E-04  +1.05944000E-03  +7.05660000E-04  -1.82100000E-05
   +1.16800000E-05  -1.99400000E-05  +6.63143000E-03  -1.01714440E-01  +1.05274630E-01
   -3.07964000E-03  -8.60918000E-03  +4.01876000E-03  -1.12700000E-05  +2.80000000E-07
   +6.09000000E-06  -1.27800000E-05  -4.07000000E-06  +7.40000000E-07  -3.39300000E-05
   +6.79980000E-04  -8.54100000E-05  +1.34460000E-04  +1.06400000E-04  +6.17800000E-05
   -4.19000000E-06  -5.09000000E-06  +6.89000000E-06  -2.04886000E-03  +9.35317000E-03
   -1.76438400E-02  -1.07440000E-04  -2.18212000E-03  +2.39674000E-03  -8.84487000E-03
   +1.08235620E-01  -7.46900000E-05  -5.55600000E-05  +1.69100000E-05  +2.45990000E-04
   -5.72500000E-05  +7.49800000E-05  -4.41800000E-05  +5.50740000E-04  +1.21330000E-04
   -1.21832000E-03  +1.14499000E-03  -7.39450000E-04  -1.52600000E-05  -5.37670000E-04
   +3.52500000E-04  -1.59160000E-04  +3.68400000E-05  -1.86000000E-05  -4.76040000E-04
   -1.66720000E-03  -7.75090000E-04  -1.42400000E-05  -5.29980000E-04  +9.87000000E-06
   +4.81000000E-06  -9.35300000E-05  +2.37800000E-05  -1.61973400E-02  +1.07564050E-01
   -2.61753030E-01  +7.46110000E-04  +7.17040000E-04  +1.78593000E-03  +2.99900000E-05
   +1.34700000E-05  -2.36000000E-06  +3.68300000E-05  +1.23600000E-05  -1.36100000E-05
   -6.83690000E-04  -7.65390000E-04  +5.79470000E-04  -9.15000000E-05  -9.21500000E-05
   +6.44000000E-06  +1.86500000E-05  -6.23000000E-06  +1.16000000E-06  -2.52565000E-03
   +1.03068100E-02  -1.81369200E-02  +3.06640000E-04  +1.95574000E-03  -5.52589000E-03
   +2.04451900E-02  -1.17678370E-01  +2.82947520E-01  +1.53900000E-05  -1.52200000E-05
   +9.00000000E-06  +3.10000000E-07  -1.61220000E-04  +6.22500000E-05  +3.40060000E-04
   -4.07940000E-04  +4.09760000E-04  -7.13900000E-05  +1.04000000E-06  -1.14770000E-04
   -9.23700000E-05  +7.49800000E-05  -6.72000000E-05  -1.43860000E-04  +1.84500000E-05
   -1.50500000E-05  +7.22690000E-04  -6.79795000E-03  +1.04106900E-02  -5.69651500E-02
   +2.11858300E-02  -4.63032800E-02  +1.77270000E-04  +6.80000000E-07  +1.26300000E-05
   -2.59600000E-05  -3.34540000E-04  -4.23310000E-04  -6.67870000E-04  +1.53820000E-03
   +3.58601000E-03  -2.61200000E-05  +1.58900000E-05  +1.20000000E-07  +4.55000000E-06
   -3.45000000E-06  +6.03000000E-06  +4.82600000E-05  +7.14600000E-05  +3.22300000E-05
   +9.06900000E-05  +9.05500000E-05  -2.85800000E-05  +2.56000000E-06  +2.06000000E-06
   -2.97000000E-06  -1.21410000E-04  -1.15190000E-04  +5.58500000E-05  +6.23500000E-05
   +1.02710000E-04  -1.04380000E-04  +2.65410000E-04  -1.34890000E-04  -6.09300000E-05
   +5.72418000E-02  -1.46840000E-04  +1.06880000E-04  -1.39500000E-04  +7.50600000E-05
   -2.80290000E-04  +1.33030000E-04  -1.71380000E-04  +3.06730000E-04  -4.23300000E-05
   -5.04800000E-05  +2.88940000E-04  -8.12100000E-05  +5.51000000E-05  -6.01800000E-05
   -1.24100000E-05  +5.04000000E-05  -1.10800000E-04  +4.99800000E-05  -4.64761000E-03
   +6.86354000E-03  -1.48218100E-02  +2.04909200E-02  -9.07870500E-02  +9.81183800E-02
   -1.28370000E-04  +9.42000000E-06  -3.23400000E-05  -3.27030000E-04  +4.83640000E-04
   -7.79600000E-05  +1.70051000E-03  -1.38507000E-03  -4.55974000E-03  +6.73000000E-06
   +1.99000000E-06  +1.70900000E-05  +1.81000000E-06  +1.64000000E-05  +5.19000000E-06
   -1.75700000E-05  -8.15500000E-05  +2.67400000E-05  +6.48800000E-05  +7.05900000E-05
   -4.06400000E-05  +2.98000000E-06  -1.70000000E-06  +1.70500000E-05  +4.14500000E-05
   +2.17090000E-04  +2.01460000E-04  -1.80000000E-05  -5.40500000E-05  -5.33900000E-05
   +3.25700000E-05  -5.88980000E-04  -3.72780000E-04  -2.33450600E-02  +9.54706500E-02
   -4.03040000E-04  +1.20060000E-04  -2.07990000E-04  +6.02310000E-04  +4.12420000E-04
   +4.78000000E-05  -9.08340000E-04  -1.36150000E-04  +6.39360000E-04  -1.61500000E-05
   +1.70070000E-04  +2.02640000E-04  +4.31410000E-04  -1.84200000E-05  +1.12350000E-04
   +1.00570000E-04  -3.97230000E-04  +1.55250000E-04  -6.60656000E-03  +1.28638600E-02
   -1.71701400E-02  -4.37094200E-02  +9.45577800E-02  -2.65759940E-01  -1.45640000E-04
   +2.28200000E-05  -1.55400000E-05  -2.98130000E-04  +9.55240000E-04  +3.21950000E-04
   +2.87377000E-03  -3.55800000E-03  -5.26031000E-03  +1.49100000E-05  -1.07700000E-05
   +2.95000000E-06  +2.71000000E-05  +6.92000000E-06  -2.61000000E-06  +5.37500000E-05
   -1.54540000E-04  -7.56700000E-05  -1.22790000E-04  -1.00650000E-04  +7.06200000E-05
   +3.04000000E-06  -1.95000000E-06  -1.06700000E-05  +1.48610000E-04  -7.49800000E-05
   +4.19490000E-04  +1.35180000E-04  -1.97000000E-06  +3.10000000E-05  -1.11370000E-04
   -8.36020000E-04  +4.26460000E-04  +4.80629800E-02  -1.04317420E-01  +2.89309340E-01
   +8.50000000E-07  +3.41500000E-05  -1.22390000E-04  +9.88200000E-05  +5.55780000E-04
   +1.37800000E-05  -3.88940000E-04  +2.13830000E-03  +2.41357000E-03  +2.17890000E-04
   -4.68270000E-04  +5.87980000E-04  -4.66140000E-04  -2.71710000E-04  -1.55950000E-04
   +5.50680000E-04  +2.46510000E-04  -3.94100000E-05  -1.48340600E-02  +4.38380000E-04
   -3.17378000E-03  -3.09273320E-01  +1.56122900E-02  -3.72524400E-02  -6.64280000E-04
   +2.43000000E-06  -7.62600000E-05  +5.35730000E-04  -8.66120000E-04  -6.69920000E-04
   +1.40212000E-03  -5.66740000E-04  -4.19870000E-04  +6.80100000E-05  -4.17500000E-05
   +2.56600000E-05  -7.00200000E-05  +5.10000000E-06  -4.80200000E-05  -2.93000000E-06
   +1.03190000E-04  +1.82300000E-05  +7.00000000E-06  -5.09200000E-05  -5.70000000E-05
   -4.45300000E-05  -1.79900000E-05  -2.45000000E-06  +3.34240000E-04  -1.27050000E-04
   +6.57200000E-05  +6.65590000E-04  +4.65780000E-04  +1.19630000E-04  -4.51400000E-05
   +5.13100000E-05  +1.28190000E-04  -3.35098000E-03  -2.63990000E-04  +1.05090000E-04
   +3.35699130E-01  +5.70370000E-04  -9.65000000E-05  +5.02960000E-04  -2.59070000E-04
   -1.95050000E-04  +1.27530000E-04  +5.52940000E-04  -1.06553000E-03  -3.10342000E-03
   +5.69370000E-04  +2.97600000E-05  +6.21300000E-05  -2.69390000E-04  +9.39900000E-05
   +1.46350000E-04  -2.61850000E-04  +3.68530000E-04  -2.29030000E-04  +2.00869300E-02
   -2.72946000E-03  +2.79456000E-03  +1.45396900E-02  -4.93507300E-02  +2.10341000E-03
   +4.53490000E-04  -5.40700000E-05  +5.23500000E-05  +8.99120000E-04  +6.06820000E-04
   +6.38160000E-04  -1.20066000E-03  +4.11220000E-04  +1.40936000E-03  -1.62600000E-05
   +2.91900000E-05  -2.83400000E-05  +3.84800000E-05  -2.48100000E-05  +2.73000000E-06
   +3.42700000E-05  -7.91700000E-05  -3.58400000E-05  +8.77200000E-05  -2.93400000E-05
   -3.57880000E-04  +4.05800000E-05  +1.38200000E-05  +2.16500000E-05  -3.03440000E-04
   +2.46520000E-04  +1.52090000E-04  -2.57140000E-04  -5.05600000E-04  -5.75530000E-04
   +3.38900000E-05  -8.83500000E-05  +5.14400000E-05  +1.26392500E-02  -1.50018000E-03
   +6.09360000E-04  -1.86664700E-02  +5.03461800E-02  -2.16010000E-04  +1.04180000E-04
   +1.01150000E-04  +5.32700000E-04  -1.49000000E-06  +1.12470000E-04  +8.76610000E-04
   -2.66047000E-03  -2.55636000E-03  +1.51030000E-04  +1.91820000E-04  -6.87600000E-05
   +5.17550000E-04  +3.55810000E-04  +2.81760000E-04  -2.54450000E-04  -4.09850000E-04
   +1.38340000E-04  +2.48139000E-02  -2.09194000E-03  +1.68342000E-03  -3.95299900E-02
   +2.92477000E-03  -5.31816900E-02  +4.14940000E-04  +1.63500000E-05  +2.06400000E-05
   +3.89690000E-04  +1.07144000E-03  +6.59950000E-04  -5.80550000E-04  +1.51580000E-04
   +1.76452000E-03  -2.41000000E-05  +2.66300000E-05  -2.19000000E-05  +5.19600000E-05
   +2.15000000E-06  +3.54000000E-05  +3.47200000E-05  -1.62210000E-04  -1.86790000E-04
   +2.13400000E-05  +3.48700000E-05  -6.70700000E-05  +2.99900000E-05  +7.35000000E-06
   -2.02800000E-05  -4.74900000E-05  +2.70740000E-04  -3.23700000E-05  -3.39490000E-04
   -3.25800000E-04  +3.49900000E-05  -1.82300000E-04  -3.46000000E-06  -3.15000000E-05
   -2.87381500E-02  +3.34940000E-04  -2.34171000E-03  +4.03442800E-02  +1.75400000E-04
   +5.39727200E-02  -2.44180000E-04  -4.35800000E-05  -8.82100000E-05  -1.76670000E-04
   +2.55700000E-04  +3.79000000E-05  +1.08349000E-03  +7.63750000E-04  -3.34190000E-04
   -2.17100000E-04  +1.40590000E-04  -7.35400000E-05  +2.49290000E-04  +1.15790000E-04
   +2.67000000E-05  -1.50430000E-04  -2.03380000E-04  +8.93900000E-05  +3.84613000E-03
   +1.35434500E-02  -8.42680000E-04  -9.10329500E-02  -1.00465950E-01  +4.35236000E-03
   +1.84140000E-04  +2.80000000E-07  +2.46800000E-05  -7.27800000E-04  +1.37454000E-03
   +1.87714000E-03  +1.70810000E-04  -5.30420000E-04  -1.26595000E-03  -2.34300000E-05
   +9.33000000E-06  -4.16000000E-06  +1.55900000E-05  -1.44900000E-05  -1.04200000E-05
   +2.38100000E-05  -5.16500000E-05  +1.63600000E-05  -1.12910000E-04  -1.51500000E-05
   +3.67910000E-04  +6.49000000E-06  +1.60000000E-05  +1.75400000E-05  +7.97370000E-04
   +6.27260000E-04  +2.55560000E-04  +3.21960000E-04  +2.75790000E-04  +2.70900000E-04
   -1.81890000E-04  -1.09670000E-04  +9.69100000E-05  +1.66701000E-03  +6.69527000E-03
   +8.22300000E-05  -1.06768000E-02  -2.92926100E-02  +1.91009000E-03  +9.52362800E-02
   +5.53430000E-04  +4.57800000E-05  +2.25510000E-04  -1.26440000E-04  +1.94600000E-05
   +2.63750000E-04  -1.17935000E-03  +8.93840000E-04  +8.63900000E-05  +5.76330000E-04
   -3.60930000E-04  +4.21960000E-04  -5.10640000E-04  -8.79500000E-05  -6.91700000E-05
   +1.10330000E-04  +4.18330000E-04  -2.49480000E-04  -8.06271000E-03  -1.92894800E-02
   +2.14318000E-03  -9.79409900E-02  -2.75406480E-01  +8.85951000E-03  -5.16200000E-05
   -4.41000000E-06  +2.04000000E-06  +2.73782000E-03  -1.16919000E-03  -3.41602000E-03
   +2.07500000E-05  +1.96437000E-03  +1.12381000E-03  +1.62100000E-05  -1.15000000E-05
   -8.59000000E-06  -1.93000000E-06  -1.62700000E-05  -2.30200000E-05  -7.60500000E-05
   +1.28480000E-04  -5.91600000E-05  +1.19260000E-04  +1.10450000E-04  -2.99610000E-04
   +2.70800000E-05  -5.55000000E-06  +7.60000000E-06  -6.05120000E-04  -1.14339000E-03
   -3.32010000E-04  -2.23800000E-05  +1.57420000E-04  +4.58700000E-05  +8.97600000E-05
   +4.17140000E-04  +4.99300000E-05  -4.30865000E-03  -9.80267000E-03  -5.86450000E-04
   +1.83214000E-03  +3.63438000E-03  -1.15370000E-04  +1.06767300E-01  +2.99293490E-01
   +1.87070000E-04  +1.00880000E-04  -4.74600000E-05  +4.52100000E-05  -4.78340000E-04
   +3.08350000E-04  -1.05298000E-03  +6.93180000E-04  +1.57960000E-04  +1.95650000E-04
   -4.55500000E-05  +1.27800000E-04  -2.75730000E-04  -7.66600000E-05  -2.84100000E-05
   +3.23800000E-05  +2.22690000E-04  -1.07610000E-04  -9.76121000E-03  -2.28939800E-02
   -4.47630000E-04  +4.62959000E-03  +1.14779100E-02  -4.71585300E-02  -8.48000000E-05
   -2.87000000E-06  -2.47600000E-05  +2.34586000E-03  -2.09011000E-03  -3.62997000E-03
   -2.88430000E-04  +5.66090000E-04  +2.10335000E-03  +6.92000000E-06  +2.19000000E-06
   +5.93000000E-06  -5.54000000E-06  -8.00000000E-07  -1.22800000E-05  -3.28000000E-06
   -4.44000000E-06  -3.34300000E-05  +3.12780000E-04  +9.94700000E-05  -3.22610000E-04
   +1.49300000E-05  -8.75000000E-06  +2.30700000E-05  -4.57280000E-04  -1.53605000E-03
   +1.70130000E-04  +1.53450000E-04  +2.17210000E-04  -6.34000000E-06  +6.77100000E-05
   -1.24990000E-04  +2.32280000E-04  +1.23603200E-02  +2.67098100E-02  +3.36950000E-04
   -1.74893000E-03  -4.69348000E-03  -6.94050000E-04  -6.63619000E-03  -8.28339000E-03
   +4.86417800E-02  -6.51770000E-04  +3.35300000E-05  +2.03490000E-04  -5.04650000E-04
   +5.48000000E-05  +1.65730000E-04  +1.83200000E-03  -7.33180000E-04  -8.77050000E-04
   -8.06430000E-04  +8.06080000E-04  -3.97760000E-04  +8.36700000E-04  +2.31330000E-04
   +6.32300000E-05  -6.32020000E-04  -6.07760000E-04  +1.10220000E-04  +2.14465000E-03
   -3.28179000E-03  -1.02966100E-02  +2.85900000E-05  +1.43320000E-04  -1.59184000E-03
   +6.65790000E-04  -8.09000000E-06  +9.38600000E-05  -2.96930000E-04  +2.65540000E-04
   -4.97360000E-04  -1.14115130E-01  +1.29544220E-01  +1.77835620E-01  -8.78800000E-05
   +3.15600000E-05  -4.12300000E-05  +5.32400000E-05  -1.47600000E-05  +3.16700000E-05
   +1.02500000E-04  -1.91290000E-04  +4.43900000E-05  -2.23500000E-05  -6.25810000E-04
   -4.20580000E-04  +5.32000000E-06  +7.00000000E-06  -2.75500000E-05  +2.84090000E-04
   -3.20660000E-04  +2.89780000E-04  -5.09110000E-04  -7.68400000E-05  +4.24280000E-04
   +8.90800000E-05  +3.25250000E-04  -4.98320000E-04  +8.26760000E-04  -1.01360000E-04
   -3.19520000E-04  +2.37080000E-04  -1.92200000E-05  -1.76270000E-04  -5.82300000E-05
   +3.54700000E-05  -3.74900000E-05  +1.10578710E-01  -3.44350000E-04  -3.16000000E-05
   +9.32900000E-05  -6.02900000E-05  +7.00170000E-04  -2.44500000E-04  +2.92300000E-05
   -2.02870000E-04  +5.75350000E-04  +8.84600000E-05  -3.60600000E-05  -1.06280000E-04
   +2.76160000E-04  -2.70890000E-04  +6.13200000E-05  +2.34000000E-06  -1.50390000E-04
   +1.25100000E-05  -8.23274000E-03  +7.68567000E-03  +1.95752600E-02  +1.90810000E-04
   -8.95240000E-04  +2.01526000E-03  -3.48100000E-05  -4.46300000E-05  +1.42600000E-05
   -9.20950000E-04  +1.83295000E-03  +1.92697000E-03  +1.34108740E-01  -1.62055510E-01
   -2.02835350E-01  -3.97000000E-06  -2.29000000E-06  +8.30000000E-06  +3.31200000E-05
   -9.72000000E-06  +6.15000000E-06  +5.98900000E-05  -1.00480000E-04  +1.69960000E-04
   -2.12000000E-04  -6.13460000E-04  -4.08540000E-04  -2.76400000E-05  +1.32700000E-05
   +1.26400000E-05  +5.94860000E-04  -1.05493000E-03  -3.81440000E-04  -1.15180000E-04
   -1.00170000E-04  +2.32900000E-05  +1.85100000E-04  -4.56230000E-04  -5.47290000E-04
   -1.16980000E-04  +8.16640000E-04  +4.76020000E-04  -1.44350000E-04  -6.16100000E-05
   +1.02570000E-04  +1.41870000E-04  +2.14680000E-04  +1.49990000E-04  -1.25497330E-01
   +1.54822670E-01  -1.53180000E-04  -9.17200000E-05  -5.23600000E-05  -2.87880000E-04
   -3.21280000E-04  +9.93200000E-05  -1.28570000E-04  -1.02991000E-03  +1.96205000E-03
   -2.04500000E-04  +7.39560000E-04  +3.78700000E-05  +6.95270000E-04  +8.54500000E-05
   -2.06130000E-04  -6.20410000E-04  -4.23290000E-04  +1.15770000E-04  +1.71134200E-02
   -2.09254900E-02  -3.13142400E-02  -2.25772000E-03  +4.59089000E-03  -6.06220000E-03
   +8.03740000E-04  +2.24600000E-05  +9.99700000E-05  +7.35110000E-04  -5.17900000E-05
   +1.72995000E-03  +1.48196130E-01  -1.61683680E-01  -3.05599510E-01  -9.98000000E-05
   +3.77700000E-05  -2.19100000E-05  +1.13320000E-04  -5.59900000E-05  -1.45500000E-05
   -8.33400000E-05  +1.26700000E-05  +7.42900000E-05  -2.82420000E-04  -2.03430000E-04
   -6.93400000E-05  +6.88300000E-05  +4.42200000E-05  +1.32100000E-05  +3.97460000E-04
   +1.01580000E-03  +3.04200000E-05  -7.87800000E-05  +1.86180000E-04  -2.97000000E-05
   -4.70680000E-04  -5.73310000E-04  +4.17820000E-04  +8.50770000E-04  -1.06215000E-03
   -1.23158000E-03  -5.57200000E-05  +1.74050000E-04  +3.97120000E-04  -1.70340000E-04
   +2.12720000E-04  +4.05460000E-04  -1.64080700E-01  +1.79300250E-01  +3.39218250E-01
end_hess

