---
license: cc0-1.0
language:
- en
pretty_name: The Wilds Drones
task_categories:
- image-classification
- object-detection
- video-classification
tags:
- biology
- animals
- conservation
- drone
- aerial
- video
- wildlife
- CV
size_categories:
- 10<n<100
---

# Dataset Card for The Wilds Drones

This dataset contains drone mission data collected at [The Wilds safari park](https://www.thewilds.org/) in Ohio during Summer 2025. 
Manual drone flights captured video footage of specific sites at The Wilds to support ecological monitoring, animal behavior analysis, and aerial object detection modeling.

## Dataset Details

This dataset was created to support multimodal wildlife monitoring research using unmanned aerial vehicle (UAV) technology. Drone missions were conducted using Parrot ANAFI drones to capture aerial video footage across The Wilds safari park. The dataset provides aerial perspectives for species detection, habitat assessment, and behavioral analysis that complement ground-based camera trap and bioacoustic monitoring efforts.

### Supported Tasks and Leaderboards

- **Object Detection:** Animal detection and tracking from aerial video footage
- **Video Classification:** Species identification and behavioral classification from drone videos
- **Image Classification:** Frame-level analysis of wildlife and habitat features
- **Wildlife Monitoring:** Population assessment and distribution mapping
- **Habitat Analysis:** Landscape and vegetation assessment from aerial perspectives
- **Behavioral Analysis:** Movement patterns and group dynamics from aerial viewpoints

[No benchmarks currently available]

## Dataset Structure

The dataset is organized by mission date and flight number:

```
/dataset/
    20250701_parrotanafi_1/
        metadata/
            0914_2025-07-01T083438-0400_10D6BC_0018.json
            File.jpg
            mission_notes.txt
        video_files/
            VID_001.MP4
            VID_002.MP4
            VID_003.MP4
            VID_004.MP4
    20250703_parrotanafi_1/
        metadata/
            0914_2025-07-03T154754-0400_16A458_0019.json
            0914_2025-07-03T155059-0400_54039C_001A.json
            mission_notes_1.txt
        video_files/
            VID_001.MP4
            VID_002.MP4
            VID_003.MP4
    20250703_parrotanafi_2/
        metadata/
            0914_2025-07-03T162104-0400_BF7B18_001D.json
            mission_notes_2.txt
        video_files/
            VID_001.MP4
            VID_002.MP4
            VID_003.MP4
    20250703_parrotanafi_3/
        metadata/
            0914_2025-07-03T165620-0400_D602EB_001F.json
            mission_notes_3.txt
        video_files/
            VID_001.MP4
            VID_002.MP4
    20250703_parrotanafi_4/
        metadata/
            0914_2025-07-03T172345-0400_75DB7A_0021.json
            mission_notes_4.txt
        video_files/
            VID_001.MP4
            VID_002.MP4
            VID_003.MP4
    20250703_parrotanafi_5/
        metadata/
            0914_2025-07-03T172555-0400_0F0BAD_0008.json
            mission_notes_5.txt
            PNG image.png
        videos/
            VID_001.MP4
            VID_002.MP4
            VID_003.MP4
            VID_004.MP4
            VID_005.MP4
```

### Data Instances

Each drone mission folder contains:
- **Video files:** .MP4 format recordings captured during flight
- **Metadata folder:** Contains telemetry data, flight path images, and mission notes

**Mission Summary:**
- **July 1, 2025:** 1 mission (4 video files)
- **July 3, 2025:** 5 missions (16 video files)
- **Total missions:** 6 drone flights
- **Total video files:** 20 .MP4 recordings

**File Counts by Mission:**
- **20250701_parrotanafi_1:** 4 video files + 3 metadata files
- **20250703_parrotanafi_1:** 3 video files + 3 metadata files (includes 2 telemetry JSON files)
- **20250703_parrotanafi_2:** 3 video files + 2 metadata files
- **20250703_parrotanafi_3:** 2 video files + 2 metadata files
- **20250703_parrotanafi_4:** 3 video files + 2 metadata files
- **20250703_parrotanafi_5:** 5 video files + 3 metadata files (includes PNG flight path image)

**Video File Specifications:**
- **Format:** .MP4 (H.264 encoding typical for Parrot ANAFI)
- **Resolution:** Variable based on drone settings and mission requirements
- **Frame rate:** Variable based on recording settings
- **Duration:** Variable based on mission objectives and flight time

**Filename Conventions:**
- **Videos:** VID_00#.MP4 (sequential numbering within each mission)
- **Telemetry:** 0914_YYYY-MM-DDTHHMISS-SSSS_XXXXXX_00##.json (timestamp and unique identifiers)
- **Mission folders:** YYYYMMDD_parrotanafi_# (date and mission number)

### Data Fields

**mission_notes.txt/mission_notes_#.txt** (found in each mission metadata folder):
- **Flight objectives:** Primary goal of the mission
- **Drone:** Drone model name (Parrot ANAFI)
- **Date/Time:** Date and approximate time of the mission
- **Observations:** Notable events or wildlife sightings captured
- **Lead pilot:** Primary pilot controlling the drone
- **Co-pilot:** Any other pilots assisting with the mission

**Telemetry JSON files:**
- **Flight telemetry data:** GPS coordinates, altitude, speed, camera angles
- **Timestamp information:** Precise timing data for video synchronization
- **Mission metadata:** Flight parameters and settings

**Additional files:**
- **Flight path images:** .jpg/.png visualization of drone flight routes (File.jpg, PNG image.png)
- **Mission documentation:** Supporting materials for flight planning and execution

### Data Splits

This dataset has no predefined training/validation/test splits. Data are organized by mission date and flight number. Users may create their own splits based on:
- **Temporal splits:** Using July 1 vs July 3 missions
- **Mission-based splits:** Using different flight objectives or locations
- **Video-based splits:** Random assignment of individual video files

The concentrated data collection (2 days, 6 missions) limits temporal splitting options. Recommended approach depends on modeling goals and available data size requirements.

## Dataset Creation

### Curation Rationale

This dataset supports aerial wildlife monitoring, behavioral ecology research, and development of automated species detection and tracking models from drone video footage. Aerial perspectives provide unique viewpoints for population assessment, habitat evaluation, and observation of animal behaviors that may be difficult to capture from ground-based sensors.

### Source Data

#### Data Collection and Processing

Drone missions were conducted at The Wilds safari park during July 1-3, 2025, using Parrot ANAFI unmanned aerial vehicles. Six missions were flown across two days with different objectives and flight patterns. 

Missions were planned to complement ground-based sensor deployments (camera traps and bioacoustic monitors) and provide aerial coverage of key wildlife areas. Flight operations followed appropriate regulations and park protocols. Telemetry data and mission metadata were recorded alongside video footage. No video processing, filtering, or annotation was applied to preserve raw footage quality.

### Annotations

#### Annotation process

No species identification, object detection, or behavioral annotations are currently provided with this initial dataset release. Manual and AI-assisted labeling efforts for wildlife detection, species classification, and behavioral annotation are planned for future versions.

#### Who are the annotators?

N/A - annotations will be added in future releases

### Personal and Sensitive Information

The dataset includes GPS telemetry data and coordinates within The Wilds, a public conservation park in Ohio. Some video footage may contain endangered or sensitive species, though specific species identifications are not currently provided. Spatial coordinates have not been redacted as flights occurred within a public conservation area under appropriate permissions.

## Considerations for Using the Data

Video quality varies based on weather conditions, lighting, flight altitude, and camera settings. The limited temporal scope (2 days) and small number of missions should be considered when developing models or drawing ecological conclusions. Some videos may contain motion blur, varying lighting conditions, or other technical artifacts typical of aerial videography.

### Bias, Risks, and Limitations

- **Temporal limitations:** Data represent only 2 days in summer 2025, severely limiting temporal and seasonal representation
- **Spatial bias:** Limited to specific areas within The Wilds, flight paths determined by mission objectives rather than systematic sampling
- **Weather dependency:** Missions conducted only in fair weather conditions, may not represent challenging environmental conditions
- **Flight restrictions:** Aerial access limited by regulations, wildlife disturbance considerations, and operational constraints
- **Technical limitations:** Variable video quality due to different flight conditions, altitudes, and camera settings
- **Species bias:** Detection capabilities vary by animal size, behavior, and habitat visibility from aerial perspectives
- **Sample size:** Limited number of missions (6) and concentrated timeframe reduce dataset diversity

### Recommendations

Users should consider the limited temporal and spatial scope when analyzing this data. The dataset is best suited for proof-of-concept studies, algorithm development, and preliminary aerial wildlife monitoring analyses. The small sample size makes it more appropriate for technique development rather than robust ecological conclusions.

Future dataset releases with additional missions, seasonal coverage, and diverse weather conditions would significantly enhance the dataset's utility for comprehensive aerial wildlife monitoring research.

## Licensing Information

This dataset is dedicated to the public domain under a [CC0 license](https://creativecommons.org/publicdomain/zero/1.0/) for the benefit of scientific pursuits. Users are encouraged to cite the dataset and acknowledge contributors when using this data in research or applications.

## Glossary 

- **UAV/Drone:** Unmanned aerial vehicle used for remote sensing and monitoring
- **Parrot ANAFI:** Specific drone model used for data collection
- **Mission:** Individual flight operation with specific objectives
- **Telemetry:** Flight data including GPS coordinates, altitude, and flight parameters
- **Aerial Monitoring:** Wildlife observation and data collection from airborne platforms
