---
license: cc0-1.0
task_categories:
- image-classification
- object-detection
language:
- en
tags:
- animal
- ecology
- camera-trap
- wildlife
- biology
- image
- animals
- CV
size_categories:
- 10K<n<100K
pretty_name: The Wilds Camera Trap Data
---

# Dataset Card for The Wilds Camera Trap Data

This dataset contains images and video captured from camera traps deployed at [The Wilds safari park](https://www.thewilds.org/) in Ohio during Summer 2025. It supports ecological monitoring, animal behavior analysis, and biodiversity studies.

## Dataset Details

### Dataset Description

This dataset was created to support wildlife monitoring research using camera traps. Data were collected using various camera trap models, with each camera recording photos and videos in the wild. The images are organized by site deployment session, providing valuable data for species detection, behavioral analysis, and biodiversity monitoring.

### Supported Tasks and Leaderboards

- **Image Classification:** Species identification from camera trap images
- **Object Detection:** Animal detection and localization in natural environments
- **Behavioral Analysis:** Activity pattern studies and wildlife monitoring
- **Biodiversity Assessment:** Species richness and abundance estimation

[No benchmarks currently available]

## Dataset Structure

The dataset is organized hierarchically by site and deployment session:

```
/dataset/
    The_Wilds_Camera_Trap_Log2025-06-30_21_56_00.csv
    The_Wilds_Camera_Trap_Log2025-07-04_20_18_08.csv
    TW01-CT02/
        SD02_20250630_20250703/
            images/
                NSCF0002_250630121802_0022.JPG
                NSCF0002_250630121802_0023.JPG
                NSCF0002_250630121803_0024.JPG
                ...
                NSCF0002_250702065001_0437.JPG
                NSCF0002_250702065001_0438.JPG
                NSCF0002_250702065002_0439.JPG
            metadata.txt
    TW02-CT03/
        SD03_20250630_20250703/
            images/
                DSCF0008.JPG
                DSCF0009.JPG
                DSCF0010.JPG
                ...
                DSCF0060.AVI
                DSCF0061.AVI
                DSCF0062.AVI
            metadata.txt
    TW03-CT01/
        SD01_20250630_20250703/
            images/
                100MEDIA/
                    NSCF0001_250630130551_0081.MP4
                    NSCF0001_250630130604_0082.JPG
                    ...
                    NSCF0001_250630164902_0999.JPG
                101MEDIA/
                    NSCF0001_250630164902_0001.JPG
                    NSCF0001_250630164902_0002.MP4
                    ...
                    NSCF0001_250630205901_0999.JPG
                102MEDIA/
                    NSCF0001_250630205901_0001.JPG
                    NSCF0001_250630205902_0002.JPG
                    NSCF0001_250630205902_0003.MP4
                    ...
                    NSCF0001_250701010702_0999.MP4
                103MEDIA/
                104MEDIA/
                105MEDIA/
                106MEDIA/
                107MEDIA/
                108MEDIA/
            metadata.txt
    TW04-CT04/
        SD04_20250630_20250704/
            101MEDIA/
                DSCF0152.JPG
                DSCF0153.JPG
                DSCF0154.JPG
                ...
                DSCF0833.JPG
                DSCF0834.JPG
                DSCF0835.MP4
            metadata.txt
```

### Data Instances

Each camera trap deployment folder (e.g., `TW01-CT02/SD02_20250630_20250703/`) contains:
- **Images folder:** Contains .jpg image files captured by motion detection
- **Video files:** .mp4 format videos in some deployments (stored in 101MEDIA for CT04)
- **Metadata file:** `metadata.txt` with deployment information and camera settings

Images vary in resolution and quality depending on camera model and environmental conditions. Videos are typically short clips (10 seconds) triggered by motion detection.

### Data Fields

**metadata.txt** (found in each deployment folder):
- **Camera Trap ID:** Unique device identifier (e.g., CT01, CT02, CT03, CT04)
- **Trap Model:** Camera model name (e.g., GardePro T5NG, Trail Camera)
- **Camera Serial Number:** Manufacturer-assigned serial number
- **Site ID:** Location code where deployed (e.g., TW01, TW02, TW03, TW04)
- **Deployment Location Description:** Text description of deployment site
- **GPS Coordinates:** Latitude and longitude in decimal format
- **Deployment Date and Time:** Camera deployment timestamp (YYYY-MM-DD HH:MM format)
- **Retrieval Date and Time:** Camera retrieval timestamp (YYYY-MM-DD HH:MM format)
- **Camera Configuration:** Settings including photo/video mode, resolution, trigger sensitivity
- **Maintenance Notes:** Configuration changes or technical issues during deployment
- **Observer:** Name or initials of person completing metadata

**CSV Log Files:**
- `The_Wilds_Camera_Trap_Log2025-06-30_21_56_00.csv`: Deployment log from June 30, 2025
- `The_Wilds_Camera_Trap_Log2025-07-04_20_18_08.csv`: Retrieval log from July 4, 2025

### Data Splits

This dataset has no predefined training/validation/test splits. Data are organized by site (TW01-TW04) and deployment session. Users may create their own splits based on:
- **Temporal splits:** Using deployment dates
- **Spatial splits:** Using different site locations
- **Camera-based splits:** Using different camera trap IDs

Recommended approach depends on modeling goals and research questions.

## Dataset Creation

### Curation Rationale

This dataset supports behavioral ecology research, development of automated species detection models, and studies of animal activity patterns. Camera traps provide non-invasive monitoring of wildlife behavior and are essential tools for conservation biology and ecological research.

### Source Data

#### Data Collection and Processing

Camera trap data were collected at The Wilds safari park during summer 2025 using GardePro and Trail Camera models. Cameras were strategically deployed at four sites (TW01-TW04) using four different camera units (CT01-CT04). 

Cameras were configured to capture both photos and videos based on motion detection. The deployment period was from June 30 to July 3-4, 2025. Upon retrieval, data were organized into folders by site and deployment session, with each deployment containing an images folder and metadata file describing camera settings and deployment context.

### Annotations

#### Annotation process

No species or behavioral annotations are currently provided with this initial dataset release. Manual and AI-assisted labeling efforts for species identification, behavioral classification, and bounding box annotations are planned for future versions.

#### Who are the annotators?

N/A - annotations will be added in future releases

### Personal and Sensitive Information

The dataset includes GPS coordinates within The Wilds, a public conservation park in Ohio. Some images may contain endangered or sensitive species, though specific species identifications are not currently provided. Spatial coordinates have not been redacted as they fall within a public conservation area.

## Considerations for Using the Data

Images and videos exhibit natural variation in quality due to weather conditions, lighting changes, motion blur, and camera settings. Some footage may be partially obstructed by vegetation, contain false triggers from wind-blown plants, or show camera malfunctions. The data represent a specific temporal window (summer 2025) and geographic location, which should be considered when generalizing findings.

### Bias, Risks, and Limitations

- **Sampling bias:** Camera traps were deployed strategically at ecological hotspots rather than randomly, potentially overrepresenting certain species or behaviors
- **Temporal limitations:** Data represent only a 3-4 day deployment period in summer 2025, limiting seasonal representation
- **Detection bias:** Motion-triggered cameras may miss slow-moving species or have reduced detection rates for small animals
- **Spatial bias:** Limited to four sites within The Wilds, may not represent broader regional wildlife patterns
- **Technical limitations:** Variable image quality due to different camera models and environmental conditions

### Recommendations

Users should consider the ecological and methodological context when analyzing this data. The dataset is best suited for proof-of-concept studies, algorithm development, and preliminary ecological analyses. For robust ecological conclusions, combination with additional seasonal data and broader spatial sampling would be beneficial.

Future dataset releases may include additional deployment periods, seasonal data, and species annotations to address current limitations.

## Licensing Information

This dataset is dedicated to the public domain under a [CC0 license](https://creativecommons.org/publicdomain/zero/1.0/) for the benefit of scientific pursuits. Users are encouraged to cite the dataset and acknowledge contributors when using this data in research or applications.

## Glossary 

- **Camera Trap:** Motion-activated camera used for wildlife monitoring
- **Deployment:** Period when a camera trap is installed and actively recording
- **Site ID:** Geographic location identifier (TW01-TW04 in this dataset)
- **Camera Trap ID:** Individual camera device identifier (CT01-CT04 in this dataset)
- **SD Card Session:** Data collection period identified by SD card and date range
