# SmartWilds: Multimodal Wildlife Monitoring Dataset

## Overview
This submission contains comprehensive dataset cards for a multimodal wildlife monitoring dataset collected during summer 2025 at a conservation facility. The dataset encompasses three complementary monitoring modalities: passive acoustic monitoring, camera trap imagery, and aerial drone footage.

## Dataset Characteristics
- **Modalities**: Bioacoustic recordings, camera trap images/videos, aerial drone footage
- **Collection Period**: June-July 2025 (4-day deployment period)
- **Scale**: 311 audio files, 20K images/videos, 20 drone video files
- **Domain**: Wildlife ecology, conservation biology, biodiversity monitoring

## Data Access and Privacy Considerations

Due to the substantial scale of this multimodal dataset and the sensitive nature of wildlife location data, complete anonymization is not technically feasible without significantly compromising the dataset's research value and ecological integrity.

Instead of providing the full raw dataset, we are submitting comprehensive **dataset cards** that include:

### Dataset Cards Contents
- **Detailed metadata** for each monitoring modality (bioacoustics, camera traps, drones)
- **Representative file structures** demonstrating data organization and naming conventions
- **Technical specifications** for audio, image, and video formats
- **Deployment methodologies** and sensor configurations
- **Ethical considerations** regarding wildlife monitoring and location sensitivity
- **Usage guidelines** and recommended analytical approaches

## Modality Overview

### Bioacoustic Monitoring
- **311 audio files** across 4 recording stations
- 48 kHz, 16-bit .wav format
- Scheduled recordings capturing natural soundscapes
- Supporting species detection and behavioral analysis

### Camera Trap Monitoring  
- **20K images/videos** from 4 deployment sites
- Motion-triggered capture of wildlife activity
- Multiple camera models with varying specifications
- Supporting species identification and activity pattern analysis

### Aerial Drone Monitoring
- **20 video files** from 6 flight missions
- Parrot ANAFI UAV platform
- Aerial perspectives for population assessment and habitat evaluation
- Supporting wildlife tracking and landscape analysis

## Data Availability
The complete dataset will be made publicly available on Hugging Face upon publication of the associated research manuscript. This open-source release will include:
- Full multimodal dataset with all audio, image, and video files
- Complete metadata and documentation
- Standardized dataset cards for each modality
- Usage examples and analytical code
- Species annotations and labels (if available at time of release)

**Current Status**: Dataset cards and representative samples available for review. Full dataset release pending manuscript publication.

## Technical Notes
- All data organized hierarchically by site and deployment session
- Standardized metadata formats across all modalities
- No species annotations provided in initial release
- Raw, unprocessed data preserved for analytical flexibility

## License
Dataset cards distributed under CC0-1.0 license for scientific use.

---

*This submission contains representative dataset cards and metadata rather than the complete multimodal dataset due to scale and wildlife location sensitivity. Full dataset access available through formal request process following institutional protocols.*