// Copyright 2013 PSF. Licensed under the PYTHON SOFTWARE FOUNDATION LICENSE VERSION 2
// File originates from the cpython source found in Doc/tools/sphinxext/static/version_switch.js

(function() {
  'use strict';

  var doc_url = "www.pygmt.org";
  //var doc_url = "0.0.0.0:8000"; // for local testing only
  var url_re = new RegExp(doc_url + "\\/(dev|latest|(v\\d+\\.\\d+\\.\\d+))\\/");
  // List all versions.
  // Add one entry "version: title" for any minor releases
  var all_versions = {
    'latest': 'latest',
    'dev': 'dev',
    'v0.17.0': 'v0.17.0',
    'v0.16.0': 'v0.16.0',
    'v0.15.0': 'v0.15.0',
    'v0.14.2': 'v0.14.2',
    'v0.14.1': 'v0.14.1',
    'v0.14.0': 'v0.14.0',
    'v0.13.0': 'v0.13.0',
    'v0.12.0': 'v0.12.0',
    'v0.11.0': 'v0.11.0',
    'v0.10.0': 'v0.10.0',
    'v0.9.0': 'v0.9.0',
    'v0.8.0': 'v0.8.0',
    'v0.7.0': 'v0.7.0',
    'v0.6.1': 'v0.6.1',
    'v0.6.0': 'v0.6.0',
    'v0.5.0': 'v0.5.0',
    'v0.4.1': 'v0.4.1',
    'v0.4.0': 'v0.4.0',
    'v0.3.1': 'v0.3.1',
    'v0.3.0': 'v0.3.0',
    'v0.2.1': 'v0.2.1',
    'v0.2.0': 'v0.2.0',
    'v0.1.2': 'v0.1.2',
    'v0.1.1': 'v0.1.1',
    'v0.1.0': 'v0.1.0',
    '0.0.1a0': 'v0.0.1a0',
  };

  function build_select(current_version, current_release) {
    var buf = ['<select>'];

    $.each(all_versions, function(version, title) {
      buf.push('<option value="' + version + '"');
      if (version == current_version) {
        buf.push(' selected="selected">');
        if (version == "latest" || version == "dev") {
          buf.push(title + ' (' + current_release + ')');
        } else {
          buf.push(current_version);
        }
      } else {
        buf.push('>' + title);
      }
      buf.push('</option>');
    });

    buf.push('</select>');
    return buf.join('');
  }

  function patch_url(url, new_version) {
    return url.replace(url_re, doc_url + '/' + new_version + '/');
  }

  function on_switch() {
    var selected = $(this).children('option:selected').attr('value');

    var url = window.location.href,
        new_url = patch_url(url, selected);

    if (new_url != url) {
      // check beforehand if url exists, else redirect to version's start page
      $.ajax({
        url: new_url,
        success: function() {
           window.location.href = new_url;
        },
        error: function() {
            window.location.href = 'https://' + doc_url + '/' + selected;
        }
      });
    }
  }

  $(document).ready(function() {
    var match = url_re.exec(window.location.href);
    if (match) {
      var release = DOCUMENTATION_OPTIONS.VERSION;
      var version = match[1];
      var select = build_select(version, release);
      $('.version_switch_note').html('Or, select a version from the drop-down menu above.');
      $('.version').html(select);
      $('.version select').bind('change', on_switch);
    }
  });
})();
