# List of employed datasets

| Datasets                 | Domain          | Positive Label          | Label Type | Reported Sensitive Variable | Number of Binary Variables |
| ------------------------ | --------------- | ----------------------- | ---------- | --------------------------- | -------------------------- |
| Adult [17]               | Social          | Income > 50K (1)        | Binary     | sex                         | 902                        |
| Arrhythmia [5]           | Health          | Normal (1)              | Multiclass | gender                      | 318                        |
| Bank [2]                 | Economy         | Subscribed (1)          | Binary     | age                         | 440                        |
| CMC [1]                  | Health          | Frequent use (2)        | Multiclass | wife religion               | 30                         |
| COMPAS [14]              | Justice         | No recidivism (0)       | Binary     | sex                         | 1371                       |
| Credit Card [7]          | Fraud Detection | No default (1)          | Binary     | sex                         | 10                         |
| Crime [3]                | Justice         | Low crime (100)         | Multiclass | black people                | 21                         |
| Diabetes Hospitals [9]   | Social          | Readmitted (0)          | Binary     | gender                      | 709                        |
| Drug [20]                | Health          | No drug use (0)         | Multiclass | gender                      | 20                         |
| German [18]              | Economy         | Good credit (1)         | Binary     | age                         | 518                        |
| Heritage Health [11]     | Social          | Admitted (1)            | Binary     | gender                      | 171                        |
| Hearth Disease [10]      | Health          | No disease (0)          | Binary     | sex                         | 38                         |
| IBM Analytics [12]       | Social          | No attrition (0)        | Binary     | gender                      | 290                        |
| Law School [23]          | Education       | Admitted (2)            | Multiclass | race                        | 50                         |
| SCG-RHC [24]             | Health          | No health challenge (0) | Binary     | gender                      | 61                         |
| Obesity [8]              | Health          | No obesity (0)          | Binary     | gender                      | 60                         |
| Parkinson Monitoring [4] | Health          | No Parkinson (0)        | Binary     | sex                         | 20                         |
| Campus Recruitment [6]   | Education       | Placed (1)              | Binary     | gender                      | 155                        |
| Resyduo [16]             | RecSys          | Recommended (1)         | Binary     | views                       | 10                         |
| Ricci [13]               | Education       | High Score (1)          | Binary     | race                        | 47                         |
| Student Performance [19] | Education       | Passed (1)              | Binary     | sex                         | 309                        |
| US Census [22]           | Social          | High income (1)         | Binary     | sex                         | 150                        |
| Vaccine [21]             | Social          | Vaccine trust (0)       | Binary     | gender                      | 210                        |
| Wine [15]                | Food            | High quality (6)        | Multiclass | type                        | 20                         |

## References

[1] T.-S. Lim, W.-Y. Loh, and Y.-S. Shih, ‘A comparison of prediction accuracy, complexity, and training time of thirty-three old and new classification algorithms’, Machine learning, vol. 40, no. 3, pp. 203–228, 2000.

[2] S. Moro, P. Cortez, and P. Rita, ‘A data-driven approach to predict the success of bank telemarketing’, Decision Support Systems, vol. 62, pp. 22–31, 2014.

[3] M. Redmond and A. Baveja, ‘A data-driven software tool for enabling cooperative information sharing among police departments’, European Journal of Operational Research, vol. 141, no. 3, pp. 660–678, 2002.

[4] A. Tsanas, M. Little, P. McSharry, and L. Ramig, ‘Accurate telemonitoring of Parkinson’s disease progression by non-invasive speech tests’, Nat Prec, pp. 1–1, Oct. 2009, doi: 10.1038/npre.2009.3920.1.

[5] Guvenir H. ,. Acar, Burak, Muderrisoglu, Haldun and R. Quinlan, ‘Arrhythmia’. 1998.

[6] ‘Campus Recruitment’. [Online]. Available: <https://www.kaggle.com/datasets/benroshan/factors-affecting-campus-placement?resource=download>

[7] V. N. Dornadula and S. Geetha, ‘Credit card fraud detection using machine learning algorithms’, Procedia computer science, vol. 165, pp. 631–641, 2019.

[8] F. M. Palechor and A. de la H. Manotas, ‘Dataset for estimation of obesity levels based on eating habits and physical condition in individuals from Colombia, Peru and Mexico’, Data in Brief, vol. 25, p. 104344, Aug. 2019, doi: 10.1016/j.dib.2019.104344.

[9] Clore John, Cios, Krzysztof, DeShazo, Jon and B. Strack, ‘Diabetes 130-US Hospitals for Years 1999-2008’. 2014.

[10] Janosi Andras, Steinbrunn, William, Pfisterer, Matthias and R. Detrano, ‘Heart Disease’. 1988.

[11] ‘Heritage Health Dataset’. 2012. [Online]. Available: <https://www.kaggle.com/c/hhp/data>

[12] ‘IBM HR Analytics Employee Attrition & Performance’. [Online]. Available: <https://www.kaggle.com/datasets/pavansubhasht/ibm-hr-analytics-attrition-dataset>

[13] ‘Journal of Statistics Education - Data Archive’. Accessed: Feb. 29, 2024. [Online]. Available: <https://jse.amstat.org/jse_data_archive.htm>

[14] J. Angwin, J. Larson, S. Mattu, and L. Kirchner, ‘Machine bias’, ProPublica, May, vol. 23, no. 2016, pp. 139–159, 2016.

[15] P. Cortez, A. Cerdeira, F. Almeida, T. Matos, and J. Reis, ‘Modeling wine preferences by data mining from physicochemical properties’, Decision support systems, vol. 47, no. 4, pp. 547–553, 2009.

[16] J. D. Rocco and C. D. Sipio, ‘ResyDuo: Combining data models and CF-based recommender systems to develop Arduino projects’. 2023.

[17] C. A. Ratanamahatana and D. Gunopulos, ‘Scaling up the naive Bayesian classifier: Using decision trees for feature selection’, 2002.

[18] H. Hofmann, ‘Statlog (German Credit Data)’. 1994.

[19] P. Cortez, ‘Student Performance’. 2014.

[20] E. Fehrman, A. K. Muhammad, E. M. Mirkes, V. Egan, and A. N. Gorban, ‘The Five Factor Model of Personality and Evaluation of Drug Consumption Risk’, in Data Science, F. Palumbo, A. Montanari, and M. Vichi, Eds., in Studies in Classification, Data Analysis, and Knowledge Organization. Cham: Springer International Publishing, 2017, pp. 231–242. doi: 10.1007/978-3-319-55723-6_18.

[21] D. Slunge, ‘The Willingness to Pay for Vaccination against Tick-Borne Encephalitis and Implications for Public Health Policy: Evidence from Sweden’, PLoS ONE, vol. 10, no. 12, p. e0143875, Dec. 2015, doi: 10.1371/journal.pone.0143875.

[22] Meek Meek, Thiesson, Thiesson and H. Heckerman, ‘US Census Data (1990)’.

[23] K. A. Austin, C. M. Christopher, and D. Dickerson, ‘Will I Pass the Bar Exam: Predicting Student Success Using LSAT Scores and Law School Performance’, HofstrA l. rev., vol. 45, p. 753, 2016.

[24] M. Chan, L. Klein, J. Fan, and O. Inan, ‘SCG-RHC: Wearable Seismocardiogram Signal and Right Heart Catheter Database’.
