Internal states or decision logics of agents 

* Accounting
  *  [AnnualCostCalculator](./Modules/AnnualCostCalculator.md)
* Conventional
  * [Portfolio](./Modules/Portfolio.md)
  * [PowerPlant](./Modules/PowerPlant.md)
  * [PowerPlantPrototype](./Modules/PowerplantPrototype.md)
* Electrolysis
  * [Electrolyzer](./Modules/Electrolyzer.md)
  * [ElectrolyzerStrategist](./Modules/ElectrolyzerStrategist.md)
  * [FileDispatcher](./Modules/FileDispatcher(Electrolysis).md)
  * [SingleAgentSimple](./Modules/SingleAgentSimple(Electrolysis).md)
  * [MonthlyEquivalence](./Modules/MonthlyEquivalence.md)
* Flexibility
  * [BidSchedule](./Modules/BidSchedule.md)
  * [GenericDevice](./Modules/GenericDevice.md)
  * [GenericDeviceCache](./Modules/GenericDeviceCache.md)
  * [Strategist](./Modules/Strategist(Flexibility).md)
  * Dynamic Programming
    * Assessment
      * [AssessmentFunction](./Modules/AssessmentFunction.md)
      * [AssessmentFunctionBuilder](./Modules/AssessmentFunctionBuilder.md)
      * [MaxProfit](./Modules/MaxProfit.md)
      * [MaxProfitPriceTaker](./Modules/MaxProfitPriceTaker.md)
      * [MinSystemCost](./Modules/MinSystemCost.md)
      * [SensitivityBasedAssessment](./Modules/SensitivityBasedAssessment.md)
      * [Util](./Modules/Util(Assessment).md)
    * Bidding
      * [BidScheduler](./Modules/BidScheduler.md)
      * [BidSchedulerBuilder](./Modules/BidSchedulerBuilder.md)
      * [EnsureDispatch](./Modules/EnsureDispatch.md)
      * [StorageContentValue](./Modules/StorageContentValue.md)
    * States
      * [StateManager](./Modules/StateManager.md)
      * [StateManagerBuilder](./Modules/StateManagerBuilder.md)
      * [EnergyStateManager](./Modules/EnergyStateManager.md)
      * [WaterValues](./Modules/WaterValues.md)
    * [Optimiser](./Modules/Optimiser.md)
* Forecast
  * [FlexibilityAssessor](./Modules/FlexibilityAssessor.md)
  * [ForecastApiRequest](./Modules/ForecastApiRequest.md)
  * [ForecastApiResponse](./Modules/ForecastApiResponse.md)
  * [MarketClearingAssessment](./Modules/MarketClearingAssessment.md)
    * [CostInsensitive](./Modules/CostInsensitive.md)
    * [CostSensitive](./Modules/CostSensitive.md)
  * [PowerForecastError](./Modules/PowerForecastError.md)
  * [Util](./Modules/Util(Forecast).md)
* Heat pump
  * [HeatPumpSchedule](./Modules/HeatPumpSchedule.md)
  * [ThermalResponse](./Modules/ThermalResponse.md)
  * [HeatPump](./Modules/HeatPump.md)
  * [StrategyParameters](./Modules/StrategyParameters(HeatPump).md)
  * [BuildingParameters](./Modules/BuildingParameters.md)
  * [HeatingInputData](./Modules/HeatingInputData(HeatPump).md)
  * [HeatPumpStrategist](./Modules/HeatPumpStrategist.md)
  * [OptimisationInputs](./Modules/OptimisationInputs(HeatPump).md)
  * [OptimisationOutputs](./Modules/OptimisationOutputs(HeatPump).md)
  * [EndUserTariff](./Modules/EndUserTariff.md)
* Load shifting
  * [LoadShiftingStrategist](./Modules/LoadShiftingStrategist.md)
  * [LoadShiftStateManager](./Modules/LoadShiftStateManager.md)
  * [ShiftFileDispatcher](./Modules/ShiftFileDispatcher.md)
  * [ShiftProfitMaximiser](./Modules/ShiftProfitMaximiser.md)
  * [ShiftProfitMaximiserTariffs](./Modules/ShiftProfitMaximiserTariffs.md)
  * [ShiftSystemCostMinimiser](./Modules/ShiftSystemCostMinimiser.md)
  * [ShiftConsumerCostMinimiserExternal](./Modules/ShiftConsumerCostMinimiserExternal.md)
* Market clearing
  * [Bid](./Modules/Bid.md)
  * [MarketClearing](./Modules/MarketClearing.md)
  * [MarketClearingResult](./Modules/MarketClearingResult.md)
  * [MeritOrderKernel](./Modules/MeritOrderKernel.md)
  * [DemandOrderBook](./Modules/DemandOrderBook.md)
  * [OrderBook](./Modules/OrderBook.md)
  * [OrderBookItem](./Modules/OrderBookItem.md)
  * [SupplyOrderBook](./Modules/SupplyOrderBook.md)
  * [TransferOrderBook](./Modules/TransmissionBook.md)
* Sensitivity
  * [MarginalCostSensitivity](./Modules/MarginalCostSensitivity.md)
  * [MeritOrderSensitivity](./Modules/MeritOrderSensitivity.md)
  * [PriceNoSensitivity](./Modules/PriceNoSensitivity.md)
  * [PriceSensitivity](./Modules/PriceSensitivity.md)
  * [SensitivityItem](./Modules/SensitivityItem.md)
  * [StepPower](./Modules/StepPower.md)
* Policy
  * Electricity
    * [Fit](./Modules/Fit.md)
    * [Mpvar](./Modules/Mpvar.md)
    * [Mpfix](./Modules/Mpfix.md)
    * [Cfd](./Modules/Cfd.md)
    * [Cp](./Modules/Cp.md)
    * [FinancialCfD](./Modules/FinancialCfd.md)
    * [SetPolicies](./Modules/SetPolicies.md)
    * [PolicyItem](./Modules/PolicyItem.md)
    * [MarketData](./Modules/MarketData.md)
  * Hydrogen
    * [Mpfix](./Modules/Mpfix(Hydrogen).md)
    * [PolicyItem](./Modules/PolicyItem(Hydrogen).md)
* Storage
  * [ArbitrageStrategist](./Modules/ArbitrageStrategist.md)
  * [FileDispatcher](./Modules/FileDispatcher(Storage).md)
  * [SystemCostMinimiser](./Modules/SystemCostMinimiser(Storage).md)
  * [ProfitMaximiser](./Modules/ProfitMaximiser(Storage).md)
  * [ProfitMaximiserPriceTaker](./Modules/ProfitMaximiserPriceTaker(Storage).md)
  * [MultiAgentMedian](./Modules/MultiAgentMedian(Storage).md)
  * [AbstractDevice](./Modules/AbstractDevice.md)
  * [Device](./Modules/Device.md)
  * [DispatchSchedule](./Modules/DispatchSchedule.md)
* Trader
  * [ClientData](./Modules/ClientData.md)
  * RenewableBidding
    * [BiddingStrategy](./Modules/BiddingStrategy.md)
    * [PremiumBased](./Modules/PremiumBased.md)
    * [AtMarginalCost](./Modules/AtMarginalCost.md)
    * [ContractForDifferences](./Modules/ContractForDifferences.md)
    * [FixedPremium](./Modules/FixedPremium.md)
    * [VariablePremium](./Modules/VariablePremium.md)
* Prediction based strategy
  * [EvBiddingStrategist](./Modules/EvBiddingStrategist.md)
  * [PVBiddingStrategist](./Modules/PvBiddingStrategist.md)
