# Contribution Guidelines for AMIRIS Repositories

AMIRIS is open to your contribution.
It is an interdisciplinary open source project, so help is always appreciated!
Development takes place openly on GitLab and is supplemented by online developer meetings to discuss more complicated issues.

Any kind of contribution to the AMIRIS project is highly relevant: bug reports, feature requests, forum questions and answers, example data, documentation improvements, and code.

## Release plan

There is currently no fixed release schedule. 
However, there is a [Roadmap](../Roadmap.md) with tentative release dates.
Minor bug fixes are released continuously.

## What is where?

For a general overview of AMIRIS please visit the [documentation](../home.md).
There, you will also find relevant background information such as a [Glossary](../Glossary.md) and a description of existing [model components](../Classes.md).
AMIRIS is based on FAME - an open Framework for distributed Agent-based Modelling of Energy systems.
Please visit [FAME on GitLab](https://gitlab.com/fame-framework/wiki/-/wikis/home) to get more details about this framework.

Installation instructions can be found in the [Getting-started](../Get-Started.md) section.
Issues and bugs are tracked in the [Repository](https://gitlab.com/dlr-ve/esy/amiris/amiris/-/issues) on GitLab.
We kindly ask you to discuss the development and configuration of AMIRIS on the [openMod Forum](https://forum.openmod.org/tag/amiris).

### Answers and Discussions

If you have questions about AMIRIS, please post them on the [openMod Forum](https://forum.openmod.org/tag/amiris).
This will help other users who may have a similar problem.
You can also suggest solutions, discuss problems, and comment on our releases.

### Application Examples and Data

You have performed simulations with AMIRIS and have new application examples?
Please consider submitting them to our dedicated [Examples Repository](https://gitlab.com/dlr-ve/esy/amiris/examples).
Please note that we can only publish properly licensed open access data.

### Research

Your research involves AMIRIS?
Please cite [doi: 10.21105/joss.05041](https://doi.org/10.21105/joss.05041) when referencing AMIRIS in your academic publications.

### Bug report

You found a problem within AMIRIS?

1. Please check the open issues list to see whether a similar bug has already been reported.
2. If no similar bug has been reported yet: Open a new issue using the *bug_report* template and fill in the corresponding fields.
3. You can contact the main developers via [amiris@dlr.de](mailto:amiris@dlr.de) or join the [open forum](./Support.md#amiris-open-forum) to discuss the issue with us.

### Feature request

If you need something to be implemented in AMIRIS:

1. Please check the open issues list to see if there is an issue similar to your feature idea.
2. If no similar issue exists: Open a new issue using the *feature_request* template and fill in the corresponding fields.
3. You can contact the main developers via [amiris@dlr.de](mailto:amiris@dlr.de) or join the [open forum](./Support.md#amiris-open-forum) to discuss the issue with us.

## Code

Tag naming conventions, definitions of done, etc. can be found on this dedicated page for [Code Contributions](./Code.md).

## Bugs Reports & Feature Requests

Please report bugs and feature requests by submitting issues using the templates provided in the relevant repositories.

For substantial enhancements, we encourage you to contact us via [amiris@dlr.de](mailto:amiris@dlr.de) or join the [open forum](./Support.md#amiris-open-forum) to collaborate on the code in joint projects or joint publications to further develop AMIRIS.
