% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{validate_gamlss_tbl}
\alias{validate_gamlss_tbl}
\title{Validate GAMLSS Model against Observed Data in a Data Table}
\usage{
validate_gamlss_tbl(dt, gamlss_tbl, mc = 10L, colname, distr_nam = distr_nam)
}
\arguments{
\item{dt}{A data table containing the observed data.}

\item{gamlss_tbl}{A data table containing the GAMLSS model parameters.}

\item{mc}{An integer specifying the number of Monte Carlo iteration for data validation. Default is 10.}

\item{colname}{A character string specifying the column name for the distributional parameter in the output.}

\item{distr_nam}{A character string specifying the distribution name to be used in the validation.}
}
\value{
A data table containing both observed and simulated data for model validation.
}
\description{
This function validates a Generalized Additive Model for Location, Scale, and Shape (GAMLSS) model against observed data in a data table. It generates simulated data from the GAMLSS model and combines it with the observed data for comparison.
}
