% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{shift_bypid}
\alias{shift_bypid}
\title{Shift Values by PID (Participant ID) for Integer, Logical, or Numeric Vectors}
\usage{
shift_bypid(x, lag, id, replace = NA)
}
\arguments{
\item{x}{A vector of integers, logicals, or numerics to be shifted.}

\item{lag}{An integer specifying the lag for shifting values. A positive lag indicates shifting forward, and a negative lag indicates shifting backward.}

\item{id}{A vector representing participant IDs associated with each observation in \code{x}.}

\item{replace}{A value to replace shifted values beyond vector boundaries. Default is \code{NA}.}
}
\value{
A vector with values shifted by the specified lag for each participant ID.
}
\description{
This function shifts values by participant ID (PID) for integer, logical, or numeric vectors. It can handle different data types and supports shifting by a specified lag.
}
