% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_functions.R
\name{plot_synthpop_val}
\alias{plot_synthpop_val}
\title{Plot Synthpop Validation Density and Cumulative Density Functions}
\usage{
plot_synthpop_val(
  dt,
  x,
  grp,
  wt,
  title,
  x_label,
  standardised_to_grp = c(FALSE, TRUE),
  print_to_screen = c(FALSE, TRUE)
)
}
\arguments{
\item{dt}{A data table containing the variables specified by \code{x}, \code{grp}, and \code{wt}.}

\item{x}{A variable to be plotted on the x-axis.}

\item{grp}{A grouping variable for faceting the plots.}

\item{wt}{A variable used for weighting the plots.}

\item{title}{A character string specifying the title for the plots.}

\item{x_label}{A character string specifying the label for the x-axis.}

\item{standardised_to_grp}{A logical vector indicating whether to standardize weights within each group. Default is \code{c(FALSE, TRUE)}.}

\item{print_to_screen}{A logical vector indicating whether to print the plots to the screen. Default is \code{c(FALSE, TRUE)}.}
}
\value{
None (saves density and cumulative density function plots to specified directory).
}
\description{
This function generates and saves density and cumulative density function plots for synthpop validation based on the provided data.
}
