% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghAssetUtils.R
\name{pb_download_liverpool}
\alias{pb_download_liverpool}
\title{Download data from an existing release}
\usage{
pb_download_liverpool(
  file = NULL,
  dest = ".",
  repo = guess_repo(),
  tag = "latest",
  overwrite = TRUE,
  ignore = "manifest.json",
  use_timestamps = TRUE,
  show_progress = getOption("piggyback.verbose", default = interactive()),
  .token = gh::gh_token()
)
}
\arguments{
\item{file}{name or vector of names of files to be downloaded. If \code{NULL},
all assets attached to the release will be downloaded.}

\item{dest}{name of vector of names of where file should be downloaded.
Can be a directory or a list of filenames the same length as \code{file}
vector. Any directories in the path provided must already exist. WARNING! confusing behaviour: \emph{directory} required for single asset; destination \emph{filenames} required for multiple assets.}

\item{overwrite}{Should any local files of the same name be overwritten?
default \code{TRUE}.}

\item{ignore}{a list of files to ignore (if downloading "all" because
\code{file=NULL}).}
}
\description{
Download data from an existing release
}
\examples{
\dontrun{
## Download a specific file.
## (dest can be omitted when run inside and R project)
piggyback::pb_download("iris.tsv.gz",
  repo = "cboettig/piggyback-tests",
  dest = tempdir()
)
}
\dontrun{
## Download all files
piggyback::pb_download(
  repo = "cboettig/piggyback-tests",
  dest = tempdir()
)
}
}
