% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_dt.R
\name{lookup_dt}
\alias{lookup_dt}
\title{Perform Table Lookup and Merge}
\usage{
lookup_dt(
  tbl,
  lookup_tbl,
  merge = TRUE,
  exclude_col = NULL,
  check_lookup_tbl_validity = FALSE
)
}
\arguments{
\item{tbl}{The main data.table on which the lookup operation is performed.}

\item{lookup_tbl}{The data.table used for lookup operations.}

\item{merge}{Logical. If TRUE, the function merges the lookup results into the main data.table.}

\item{exclude_col}{A character vector specifying columns to be excluded from the lookup operation.}

\item{check_lookup_tbl_validity}{Logical. If TRUE, the function checks the validity of the lookup_tbl.}
}
\value{
If merge is TRUE, the main data.table with the lookup results; otherwise, a data.table
containing only the lookup results.
}
\description{
This function performs a table lookup operation between two data.tables, allowing
for merging of columns based on common keys. The lookup is conducted on factors
or integers that start from 1 and increase by 1.
}
